-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-25774729-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-22 17:10:35','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-22 17:10:35','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'jcvcontable@hotmail.com','3764347413',NULL,1,40719,'2022-08-26'),(2,'jcvcontable@hotmail.com','3764347413','',1,40719,'2023-11-20'),(3,'jcvcontable@hotmail.com','3764347413','',1,40719,'2023-11-20');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(5,3,3,5,NULL,0.00,'2023-04-24 22:35:51','2023-04-24 22:35:51',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7657,3,2,NULL,0.00,'2023-04-24 22:35:51','2023-04-24 22:35:51',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1753 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7657,40720,1524,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2400.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(2,7657,40720,1524,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1800.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(3,7657,40720,1524,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',8600.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(4,7657,40720,1524,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5100.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(5,7657,40720,1524,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3800.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(6,7657,40720,1524,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',690.77,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(7,7657,40720,1524,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2500.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(8,7657,40720,1524,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',650.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(9,7657,40720,1524,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',2400.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(10,7657,40720,1524,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',1400.01,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(11,7657,40720,1524,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',10500.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(12,7657,40720,1524,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',10000.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(13,7657,40720,1524,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3900.00,NULL,NULL,1,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(14,7657,40720,1524,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6200.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(15,7657,40720,1524,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5700.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(16,7657,40720,1524,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4700.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(17,7657,40720,1524,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',25000.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(18,7657,40720,1524,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13600.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(19,7657,40720,1524,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5000.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(20,7657,40720,1524,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1700.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(21,7657,40720,1524,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',19000.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(22,7657,40720,1524,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7900.01,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL);
INSERT INTO `balance_libro` VALUES (23,7657,40720,1524,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',10200.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(24,7657,40720,1524,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',9200.01,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(25,7657,40720,1524,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3200.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(26,7657,40720,1524,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2300.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(27,7657,40720,1524,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',23374.32,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(28,7657,40720,1524,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2010.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(29,7657,40720,1524,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1700.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(30,7657,40720,1524,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2300.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(31,7657,40720,1524,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7000.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(32,7657,40720,1524,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',14908.41,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(33,7657,40720,1524,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5300.01,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(34,7657,40720,1524,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',8000.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(35,7657,40720,1524,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',800.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(36,7657,40720,1524,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',800.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(37,7657,40720,1524,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1200.01,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(38,7657,40720,1524,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',14850.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(39,7657,40720,1524,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',2700.01,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(40,7657,40720,1524,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',8000.00,NULL,NULL,1,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(41,7657,40720,1524,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',1900.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(42,7657,40720,1524,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',1600.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(43,7657,40720,1524,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',4500.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL);
INSERT INTO `balance_libro` VALUES (44,7657,40720,1524,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',3000.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(45,7657,40720,1524,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',650.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(46,7657,40720,1524,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',3080.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(47,7657,40720,1524,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',7900.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(48,7657,40720,1524,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',650.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(49,7657,40720,1524,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',900.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(50,7657,40720,1524,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1700.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(51,7657,40720,1524,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',11400.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(52,7657,40720,1524,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5200.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(53,7657,40720,1524,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8900.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(54,7657,40720,1524,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2000.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(55,7657,40720,1524,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2700.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(56,7657,40720,1524,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2900.01,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(57,7657,40720,1524,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',57700.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(58,7657,40720,1524,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2400.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(59,7657,40720,1524,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',18480.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(60,7657,40720,1524,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(61,7657,40720,1524,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2000.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(62,7657,40720,1524,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',0.01,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(63,7657,40720,1524,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',16599.02,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(64,7657,40720,1524,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3600.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL);
INSERT INTO `balance_libro` VALUES (65,7657,40720,1524,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',900.00,NULL,NULL,1,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(66,7657,40720,1524,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3600.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(67,7657,40720,1524,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',44300.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(68,7657,40720,1524,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1500.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(69,7657,40720,1524,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2200.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(70,7657,40720,1524,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4000.01,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(71,7657,40720,1524,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4300.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(72,7657,40720,1524,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',22750.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(73,7657,40720,1524,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',31310.72,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(74,7657,40720,1524,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',26137.87,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(75,7657,40720,1524,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',8700.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(76,7657,40720,1524,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7700.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(77,7657,40720,1524,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4500.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(78,7657,40720,1524,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3500.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(79,7657,40720,1524,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',8000.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(80,7657,40720,1524,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1900.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(81,7657,40720,1524,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7300.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(82,7657,40720,1524,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',10150.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(83,7657,40720,1524,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3600.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(84,7657,40720,1524,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1400.01,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(85,7657,40720,1524,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',25200.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL);
INSERT INTO `balance_libro` VALUES (86,7657,40720,1524,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',23200.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(87,7657,40720,1524,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',16400.00,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(88,7657,40720,1524,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1400.01,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(89,7657,40720,1524,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2700.01,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(90,7657,40720,1524,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',11159.10,NULL,NULL,1,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(91,7657,40720,1524,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3950.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(92,7657,40720,1524,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2700.01,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(93,7657,40720,1524,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3800.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(94,7657,40720,1524,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3400.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(95,7657,40720,1524,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(96,7657,40720,1524,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9500.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(97,7657,40720,1524,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4100.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(98,7657,40720,1524,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',8100.01,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(99,7657,40720,1524,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1650.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(100,7657,40720,1524,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1800.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(101,7657,40720,1524,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7756.88,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(102,7657,40720,1524,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6000.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(103,7657,40720,1524,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3300.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(104,7657,40720,1524,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3500.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(105,7657,40720,1524,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1000.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(106,7657,40720,1524,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',850.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL);
INSERT INTO `balance_libro` VALUES (107,7657,40720,1524,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3600.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(108,7657,40720,1524,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',1100.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(109,7657,40720,1524,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',1200.01,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(110,7657,40720,1524,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',9910.20,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(111,7657,40720,1524,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5953.20,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(112,7657,40720,1524,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5600.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(113,7657,40720,1524,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4000.01,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(114,7657,40720,1524,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',3100.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(115,7657,40720,1524,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',2350.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(116,7657,40720,1524,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',26200.01,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(117,7657,40720,1524,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',7000.00,NULL,NULL,1,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(118,7657,40720,1524,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',3700.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(119,7657,40720,1524,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',100000.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(120,7657,40720,1524,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1800.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(121,7657,40720,1524,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1000.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(122,7657,40720,1524,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1800.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(123,7657,40720,1524,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5200.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(124,7657,40720,1524,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',2600.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(125,7657,40720,1524,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',400.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(126,7657,40720,1524,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',6300.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(127,7657,40720,1524,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',800.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL);
INSERT INTO `balance_libro` VALUES (128,7657,40720,1524,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',11500.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(129,7657,40720,1524,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',11500.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(130,7657,40720,1524,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',900.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(131,7657,40720,1524,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',600.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(132,7657,40720,1524,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',4550.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(133,7657,40720,1524,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',9000.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(134,7657,40720,1524,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6800.02,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(135,7657,40720,1524,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',9000.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(136,7657,40720,1524,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',45000.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(137,7657,40720,1524,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',83700.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(138,7657,40720,1524,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5700.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(139,7657,40720,1524,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8400.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(140,7657,40720,1524,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',12000.01,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(141,7657,40720,1524,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',11000.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(142,7657,40720,1524,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7900.01,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(143,7657,40720,1524,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2200.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(144,7657,40720,1524,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3284.23,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(145,7657,40720,1524,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',12100.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(146,7657,40720,1524,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2500.00,NULL,NULL,1,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(147,7657,40720,1524,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',91438.49,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(148,7657,40720,1524,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL);
INSERT INTO `balance_libro` VALUES (149,7657,40720,1524,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',95004.31,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(150,7657,40720,1524,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(151,7657,40720,1524,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',98000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(152,7657,40720,1524,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(153,7657,40720,1524,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(154,7657,40720,1524,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',9000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(155,7657,40720,1524,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5850.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(156,7657,40720,1524,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',98010.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(157,7657,40720,1524,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',94380.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(158,7657,40720,1524,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99220.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(159,7657,40720,1524,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(160,7657,40720,1524,3,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',91969.68,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(161,7657,40720,1524,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',91584.90,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(162,7657,40720,1524,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(163,7657,40720,1524,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(164,7657,40720,1524,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',95590.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(165,7657,40720,1524,3,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(166,7657,40720,1524,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',94380.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(167,7657,40720,1524,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',91438.49,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(168,7657,40720,1524,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1200.01,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(169,7657,40720,1524,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',800.00,NULL,NULL,1,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL);
INSERT INTO `balance_libro` VALUES (170,7657,40720,1524,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',22053.00,NULL,NULL,1,'2022-08-23 10:50:54','2022-08-23 11:01:56','2022-08-23 11:01:56'),(171,7657,40720,1524,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',975260.00,NULL,NULL,1,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(172,7657,40720,1524,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7661877.30,NULL,NULL,1,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(173,7657,40720,1524,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2558036.80,NULL,NULL,1,'2022-08-23 10:50:54','2022-08-23 11:02:52','2022-08-23 11:02:52'),(174,7657,40720,1524,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',115890.78,NULL,NULL,1,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(175,7657,40720,1524,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',840215.23,NULL,NULL,1,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(176,7657,40720,1524,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',617797.56,NULL,NULL,1,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(177,7657,40720,1524,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',695582.72,NULL,NULL,1,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(178,7657,40720,1524,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',22053.00,NULL,NULL,1,'2022-08-23 11:01:56','2022-08-23 11:01:56',NULL),(179,7657,40720,1524,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2558036.80,NULL,NULL,1,'2022-08-23 11:04:17','2022-08-23 11:04:17',NULL),(180,7657,40744,12129,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1381696.05,NULL,NULL,1,'2022-08-23 15:23:14','2022-08-24 11:44:29','2022-08-24 11:44:29'),(181,7657,40744,12129,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5123.96,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(182,7657,40744,12129,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',131516.45,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(183,7657,40744,12129,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',40000.00,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(184,7657,40744,12129,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',40000.00,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-24 11:45:25','2022-08-24 11:45:25'),(185,7657,40744,12129,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',101454.33,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(186,7657,40744,12129,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',82442.62,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:44:54','2022-08-23 15:44:54'),(187,7657,40744,12129,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',101454.33,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(188,7657,40744,12129,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',47059.22,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(189,7657,40744,12129,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',61494.58,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL);
INSERT INTO `balance_libro` VALUES (190,7657,40744,12129,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',60155.87,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(191,7657,40744,12129,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',67698.41,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(192,7657,40744,12129,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',42601.96,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(193,7657,40744,12129,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4200.00,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(194,7657,40744,12129,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',60176.37,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(195,7657,40744,12129,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',42601.96,NULL,NULL,1,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(196,7657,40744,12129,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',8000.00,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(197,7657,40744,12129,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',60176.37,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(198,7657,40744,12129,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',67698.41,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(199,7657,40744,12129,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',27083.89,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(200,7657,40744,12129,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',60176.37,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(201,7657,40744,12129,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',69225.67,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(202,7657,40744,12129,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',60176.37,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(203,7657,40744,12129,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1500.00,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(204,7657,40744,12129,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',302.50,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(205,7657,40744,12129,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',56971.58,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(206,7657,40744,12129,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',67740.11,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-26 15:55:47','2022-08-26 15:55:47'),(207,7657,40744,12129,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15064.59,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-26 15:57:31','2022-08-26 15:57:31'),(208,7657,40744,12129,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5124.00,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(209,7657,40744,12129,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',46116.08,NULL,NULL,1,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(210,7657,40744,12129,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',91977.84,NULL,NULL,1,'2022-08-23 15:44:54','2022-08-23 15:44:54',NULL);
INSERT INTO `balance_libro` VALUES (211,7657,40760,25764,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',7800.00,NULL,NULL,1,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(212,7657,40760,25764,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',9950.00,NULL,NULL,1,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(213,7657,40760,25764,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',500.00,NULL,NULL,1,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(214,7657,40760,25764,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',450.00,NULL,NULL,1,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(215,7657,40760,25764,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1600.00,NULL,NULL,1,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(216,7657,40760,25764,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',3500.00,NULL,NULL,1,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(217,7657,40760,25764,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5131.97,NULL,NULL,1,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(218,7657,40760,25764,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',700.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(219,7657,40760,25764,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4000.01,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(220,7657,40760,25764,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4100.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(221,7657,40760,25764,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3200.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(222,7657,40760,25764,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',24100.01,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(223,7657,40760,25764,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4100.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(224,7657,40760,25764,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',18500.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(225,7657,40760,25764,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3100.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(226,7657,40760,25764,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',13624.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(227,7657,40760,25764,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',18700.01,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(228,7657,40760,25764,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8140.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(229,7657,40760,25764,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6600.01,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(230,7657,40760,25764,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4900.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(231,7657,40760,25764,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',12400.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL);
INSERT INTO `balance_libro` VALUES (232,7657,40760,25764,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4400.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(233,7657,40760,25764,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',16300.01,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(234,7657,40760,25764,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6700.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(235,7657,40760,25764,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1000.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(236,7657,40760,25764,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',800.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(237,7657,40760,25764,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2400.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(238,7657,40760,25764,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',600.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(239,7657,40760,25764,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1000.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(240,7657,40760,25764,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',500.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(241,7657,40760,25764,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1250.00,NULL,NULL,1,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(242,7657,40760,25764,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1000.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(243,7657,40760,25764,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1100.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(244,7657,40760,25764,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3200.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(245,7657,40760,25764,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1329.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(246,7657,40760,25764,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',27000.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(247,7657,40760,25764,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',2200.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(248,7657,40760,25764,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',398.91,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(249,7657,40760,25764,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',79418.10,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(250,7657,40760,25764,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',14900.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(251,7657,40760,25764,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3500.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(252,7657,40760,25764,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',600.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL);
INSERT INTO `balance_libro` VALUES (253,7657,40760,25764,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3600.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(254,7657,40760,25764,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3700.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(255,7657,40760,25764,3,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',29000.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(256,7657,40760,25764,3,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',60000.26,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(257,7657,40760,25764,3,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',15300.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(258,7657,40760,25764,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1700.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(259,7657,40760,25764,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1500.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(260,7657,40760,25764,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',22300.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(261,7657,40760,25764,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6000.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(262,7657,40760,25764,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5300.01,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(263,7657,40760,25764,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1800.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(264,7657,40760,25764,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5400.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(265,7657,40760,25764,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5500.01,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(266,7657,40760,25764,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4600.00,NULL,NULL,1,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(267,7657,40760,25764,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3150.01,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(268,7657,40760,25764,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',17300.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(269,7657,40760,25764,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',15000.01,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(270,7657,40760,25764,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5800.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(271,7657,40760,25764,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5050.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(272,7657,40760,25764,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',49800.01,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(273,7657,40760,25764,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3500.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL);
INSERT INTO `balance_libro` VALUES (274,7657,40760,25764,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5000.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(275,7657,40760,25764,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',8000.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 22:02:50','2022-08-23 22:02:50'),(276,7657,40760,25764,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',2300.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(277,7657,40760,25764,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7800.01,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(278,7657,40760,25764,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1000.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(279,7657,40760,25764,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',189000.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(280,7657,40760,25764,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5300.01,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(281,7657,40760,25764,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5100.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(282,7657,40760,25764,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5100.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(283,7657,40760,25764,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',21000.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(284,7657,40760,25764,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(285,7657,40760,25764,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2600.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(286,7657,40760,25764,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',30231.05,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(287,7657,40760,25764,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',41750.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(288,7657,40760,25764,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2600.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(289,7657,40760,25764,3,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8600.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(290,7657,40760,25764,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2000.01,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(291,7657,40760,25764,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2600.00,NULL,NULL,1,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(292,7657,40760,25764,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',17246.78,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(293,7657,40760,25764,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2000.01,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(294,7657,40760,25764,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4500.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL);
INSERT INTO `balance_libro` VALUES (295,7657,40760,25764,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4500.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(296,7657,40760,25764,3,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3200.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(297,7657,40760,25764,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1329.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 22:00:42','2022-08-23 22:00:42'),(298,7657,40760,25764,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',27500.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(299,7657,40760,25764,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1500.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(300,7657,40760,25764,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4000.01,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(301,7657,40760,25764,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3450.01,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(302,7657,40760,25764,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4500.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(303,7657,40760,25764,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2300.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(304,7657,40760,25764,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2600.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(305,7657,40760,25764,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',7900.01,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(306,7657,40760,25764,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3500.01,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(307,7657,40760,25764,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5100.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(308,7657,40760,25764,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1750.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(309,7657,40760,25764,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',15600.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(310,7657,40760,25764,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2500.01,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(311,7657,40760,25764,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1000.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(312,7657,40760,25764,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6600.01,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(313,7657,40760,25764,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',2100.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(314,7657,40760,25764,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',44638.01,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(315,7657,40760,25764,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4500.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL);
INSERT INTO `balance_libro` VALUES (316,7657,40760,25764,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11997.83,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(317,7657,40760,25764,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',30812.41,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(318,7657,40760,25764,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2457.71,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(319,7657,40760,25764,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',27000.00,NULL,NULL,1,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(320,7657,40760,25764,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',192492.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 22:01:21','2022-08-23 22:01:21'),(321,7657,40760,25764,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',13500.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 22:14:19','2022-08-23 22:14:19'),(322,7657,40760,25764,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6248500.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 22:13:08','2022-08-23 22:13:08'),(323,7657,40760,25764,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',94380.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(324,7657,40760,25764,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',98000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(325,7657,40760,25764,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',98000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(326,7657,40760,25764,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(327,7657,40760,25764,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',97000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(328,7657,40760,25764,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',960000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(329,7657,40760,25764,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(330,7657,40760,25764,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(331,7657,40760,25764,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',950000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(332,7657,40760,25764,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',91438.49,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(333,7657,40760,25764,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(334,7657,40760,25764,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',950000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(335,7657,40760,25764,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',98000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(336,7657,40760,25764,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',968682.44,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL);
INSERT INTO `balance_libro` VALUES (337,7657,40760,25764,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',97949.50,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(338,7657,40760,25764,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',96261.55,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(339,7657,40760,25764,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(340,7657,40760,25764,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',99000.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(341,7657,40760,25764,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',91062.47,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(342,7657,40760,25764,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',94380.00,NULL,NULL,1,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(343,7657,40760,25764,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',14970.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(344,7657,40760,25764,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',940.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(345,7657,40760,25764,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1600.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(346,7657,40760,25764,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9775.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(347,7657,40760,25764,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',17700.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(348,7657,40760,25764,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',950.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(349,7657,40760,25764,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7861140.92,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(350,7657,40760,25764,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2607211.20,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(351,7657,40760,25764,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8500.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(352,7657,40760,25764,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',230208.55,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(353,7657,40760,25764,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',290204.28,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(354,7657,40760,25764,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2340.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(355,7657,40760,25764,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',21000.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(356,7657,40760,25764,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',15860.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(357,7657,40760,25764,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2340.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL);
INSERT INTO `balance_libro` VALUES (358,7657,40760,25764,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',360811.41,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(359,7657,40760,25764,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',12550.00,NULL,NULL,1,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(360,7657,40760,25764,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',504559.11,NULL,NULL,1,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(361,7657,40760,25764,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',66450.00,NULL,NULL,1,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(362,7657,40760,25764,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',14600.00,NULL,NULL,1,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(363,7657,40760,25764,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',100000.00,NULL,NULL,1,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(364,7657,40760,25764,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',8940.00,NULL,NULL,1,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(365,7657,40760,25764,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',22140.00,NULL,NULL,1,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(366,7657,40760,25764,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',900.00,NULL,NULL,1,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(367,7657,40760,25764,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',9900.00,NULL,NULL,1,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(368,7657,40760,25764,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1329.00,NULL,NULL,1,'2022-08-23 22:00:42','2022-08-23 22:00:42',NULL),(369,7657,40760,25764,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',192491.99,NULL,NULL,1,'2022-08-23 22:01:21','2022-08-23 22:13:56','2022-08-23 22:13:56'),(370,7657,40760,25764,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',8000.00,NULL,NULL,1,'2022-08-23 22:02:50','2022-08-23 22:02:50',NULL),(371,7657,40760,25764,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6248500.00,NULL,NULL,1,'2022-08-23 22:13:08','2022-08-23 22:13:08',NULL),(372,7657,40760,25764,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',192491.99,NULL,NULL,1,'2022-08-23 22:13:56','2022-08-23 22:13:56',NULL),(373,7657,40760,25764,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',13500.00,NULL,NULL,1,'2022-08-23 22:14:19','2022-08-23 22:14:19',NULL),(374,7657,40760,25764,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',73158.00,NULL,NULL,1,'2022-08-23 22:30:26','2022-08-23 22:30:26',NULL),(375,7657,40760,25764,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',19282.07,NULL,NULL,1,'2022-08-23 22:31:54','2022-08-23 22:31:54',NULL),(376,7657,40760,25764,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30120.00,NULL,NULL,1,'2022-08-23 22:33:15','2022-08-23 22:33:15',NULL),(377,7657,40760,25764,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30120.00,NULL,NULL,1,'2022-08-23 22:34:33','2022-08-23 22:34:33',NULL),(378,7657,40760,25764,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',16240.00,NULL,NULL,1,'2022-08-23 22:35:35','2022-08-23 22:35:35',NULL);
INSERT INTO `balance_libro` VALUES (379,7657,40760,25764,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',30120.00,NULL,NULL,1,'2022-08-23 22:36:37','2022-08-23 22:36:37',NULL),(380,7657,40760,25764,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20300.00,NULL,NULL,1,'2022-08-23 22:37:33','2022-08-23 22:37:33',NULL),(381,7657,40760,25764,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',30120.00,NULL,NULL,1,'2022-08-23 22:38:42','2022-08-23 22:38:42',NULL),(382,7657,40760,25764,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',30120.00,NULL,NULL,1,'2022-08-23 22:39:41','2022-08-23 22:39:41',NULL),(383,7657,40760,25764,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',30120.00,NULL,NULL,1,'2022-08-23 22:40:50','2022-08-23 22:40:50',NULL),(384,7657,40760,25764,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',30120.00,NULL,NULL,1,'2022-08-23 22:41:57','2022-08-23 22:41:57',NULL),(385,7657,40760,25764,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',43709.00,NULL,NULL,1,'2022-08-23 22:44:00','2022-08-23 22:44:00',NULL),(386,7657,40760,25764,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',30120.00,NULL,NULL,1,'2022-08-23 22:44:49','2022-08-23 22:44:49',NULL),(387,7657,40760,25764,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',30120.00,NULL,NULL,1,'2022-08-23 22:45:40','2022-08-23 22:45:40',NULL),(388,7657,40760,25764,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',30120.00,NULL,NULL,1,'2022-08-23 22:46:47','2022-08-23 22:46:47',NULL),(389,7657,40744,12129,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1381696.05,NULL,NULL,1,'2022-08-24 11:44:29','2022-08-24 11:44:29',NULL),(390,7657,40744,12129,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',40000.00,NULL,NULL,1,'2022-08-24 11:45:25','2022-08-24 11:45:25',NULL),(391,7657,40744,12129,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',3901.40,NULL,NULL,1,'2022-08-26 15:52:28','2022-08-26 15:52:28',NULL),(392,7657,40744,12129,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',67740.11,NULL,NULL,1,'2022-08-26 15:55:47','2022-08-26 15:55:47',NULL),(393,7657,40744,12129,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15064.59,NULL,NULL,1,'2022-08-26 15:57:31','2022-08-26 15:57:31',NULL),(394,7657,40794,42440,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2074.96,NULL,NULL,1,'2023-04-23 19:01:27','2023-04-23 19:01:27',NULL),(395,7657,40760,25773,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8400.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(396,7657,40760,25773,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2400.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(397,7657,40760,25773,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',48300.01,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(398,7657,40760,25773,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3500.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52');
INSERT INTO `balance_libro` VALUES (399,7657,40760,25773,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2650.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(400,7657,40760,25773,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5600.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(401,7657,40760,25773,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',35800.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(402,7657,40760,25773,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',39200.01,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(403,7657,40760,25773,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5400.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(404,7657,40760,25773,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',11500.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(405,7657,40760,25773,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',53669.05,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(406,7657,40760,25773,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',28999.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(407,7657,40760,25773,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22200.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(408,7657,40760,25773,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6000.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(409,7657,40760,25773,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',800.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(410,7657,40760,25773,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6000.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(411,7657,40760,25773,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',800.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(412,7657,40760,25773,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1150.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(413,7657,40760,25773,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',76300.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(414,7657,40760,25773,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3200.00,NULL,NULL,1,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(415,7657,40760,25773,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22300.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(416,7657,40760,25773,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5374.18,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(417,7657,40760,25773,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',103998.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro` VALUES (418,7657,40760,25773,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',60000.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(419,7657,40760,25773,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',19500.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(420,7657,40760,25773,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3900.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(421,7657,40760,25773,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12600.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(422,7657,40760,25773,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2400.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(423,7657,40760,25773,3,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',39500.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(424,7657,40760,25773,3,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14950.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(425,7657,40760,25773,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',16500.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(426,7657,40760,25773,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',23200.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(427,7657,40760,25773,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',398.91,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(428,7657,40760,25773,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',111999.20,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(429,7657,40760,25773,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5000.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(430,7657,40760,25773,3,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',55700.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(431,7657,40760,25773,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',11600.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(432,7657,40760,25773,3,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',15000.01,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(433,7657,40760,25773,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5300.01,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(434,7657,40760,25773,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',35544.74,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(435,7657,40760,25773,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',34500.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(436,7657,40760,25773,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4600.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro` VALUES (437,7657,40760,25773,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3000.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(438,7657,40760,25773,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',900.00,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(439,7657,40760,25773,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5500.01,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(440,7657,40760,25773,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',71336.61,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(441,7657,40760,25773,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7620.86,NULL,NULL,1,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(442,7657,40760,25773,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3500.01,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(443,7657,40760,25773,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11880.07,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(444,7657,40760,25773,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',29688.40,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(445,7657,40760,25773,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',19000.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(446,7657,40760,25773,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3000.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(447,7657,40760,25773,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',20000.01,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(448,7657,40760,25773,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6200.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(449,7657,40760,25773,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1800.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(450,7657,40760,25773,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2600.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(451,7657,40760,25773,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',23400.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(452,7657,40760,25773,3,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',99120.31,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(453,7657,40760,25773,3,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',687215.07,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(454,7657,40760,25773,3,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2700.01,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(455,7657,40760,25773,3,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5200.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro` VALUES (456,7657,40760,25773,3,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1200.01,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(457,7657,40760,25773,3,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1500.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(458,7657,40760,25773,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3999.99,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(459,7657,40760,25773,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',35100.01,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(460,7657,40760,25773,3,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7200.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(461,7657,40760,25773,3,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',15600.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(462,7657,40760,25773,3,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3700.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(463,7657,40760,25773,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3500.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(464,7657,40760,25773,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3500.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(465,7657,40760,25773,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1600.00,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(466,7657,40760,25773,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',13627.26,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(467,7657,40760,25773,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',29469.77,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(468,7657,40760,25773,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',16207.95,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(469,7657,40760,25773,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',40400.70,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(470,7657,40760,25773,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14432.53,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(471,7657,40760,25773,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',114950.12,NULL,NULL,1,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(472,7657,40760,25773,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7200.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(473,7657,40760,25773,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3900.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(474,7657,40760,25773,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1200.01,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro` VALUES (475,7657,40760,25773,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3600.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(476,7657,40760,25773,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2200.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(477,7657,40760,25773,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7300.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(478,7657,40760,25773,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',34429.24,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(479,7657,40760,25773,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',178049.21,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(480,7657,40760,25773,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',14100.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(481,7657,40760,25773,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1580.01,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(482,7657,40760,25773,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1500.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(483,7657,40760,25773,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5000.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(484,7657,40760,25773,3,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',15600.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(485,7657,40760,25773,3,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8100.01,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(486,7657,40760,25773,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8518.23,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(487,7657,40760,25773,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11880.02,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(488,7657,40760,25773,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',700.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(489,7657,40760,25773,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',6300.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(490,7657,40760,25773,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9700.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(491,7657,40760,25773,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',28900.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(492,7657,40760,25773,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7600.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(493,7657,40760,25773,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4900.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54');
INSERT INTO `balance_libro` VALUES (494,7657,40760,25773,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12300.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(495,7657,40760,25773,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',800.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(496,7657,40760,25773,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',18500.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(497,7657,40760,25773,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4000.01,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(498,7657,40760,25773,3,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12300.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(499,7657,40760,25773,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1500.00,NULL,NULL,1,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(500,7657,40760,25773,3,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1800.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(501,7657,40760,25773,3,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',800.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(502,7657,40760,25773,3,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11500.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(503,7657,40760,25773,3,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2000.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(504,7657,40760,25773,3,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8900.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(505,7657,40760,25773,3,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',800.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(506,7657,40760,25773,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',550.01,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(507,7657,40760,25773,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10900.01,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(508,7657,40760,25773,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1800.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(509,7657,40760,25773,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4400.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(510,7657,40760,25773,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11000.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(511,7657,40760,25773,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',25400.01,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(512,7657,40760,25773,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',21800.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54');
INSERT INTO `balance_libro` VALUES (513,7657,40760,25773,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5200.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(514,7657,40760,25773,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',40800.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(515,7657,40760,25773,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',36340.38,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(516,7657,40760,25773,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11500.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(517,7657,40760,25773,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5800.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(518,7657,40760,25773,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7500.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(519,7657,40760,25773,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6400.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(520,7657,40760,25773,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',84998.12,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(521,7657,40760,25773,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2800.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(522,7657,40760,25773,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4600.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(523,7657,40760,25773,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10700.01,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(524,7657,40760,25773,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5900.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(525,7657,40760,25773,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4500.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(526,7657,40760,25773,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3500.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(527,7657,40760,25773,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4500.00,NULL,NULL,1,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(528,7657,40760,25773,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',22800.01,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(529,7657,40760,25773,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9600.01,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(530,7657,40760,25773,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',18500.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(531,7657,40760,25773,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8700.24,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54');
INSERT INTO `balance_libro` VALUES (532,7657,40760,25773,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27808.52,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(533,7657,40760,25773,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',500.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(534,7657,40760,25773,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1900.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(535,7657,40760,25773,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5600.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(536,7657,40760,25773,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6300.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(537,7657,40760,25773,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6000.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(538,7657,40760,25773,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4500.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(539,7657,40760,25773,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3500.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(540,7657,40760,25773,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4700.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(541,7657,40760,25773,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9000.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(542,7657,40760,25773,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7700.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(543,7657,40760,25773,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8600.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(544,7657,40760,25773,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11200.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(545,7657,40760,25773,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2100.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(546,7657,40760,25773,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1500.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(547,7657,40760,25773,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6500.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(548,7657,40760,25773,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1200.01,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(549,7657,40760,25773,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5200.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(550,7657,40760,25773,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',12900.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro` VALUES (551,7657,40760,25773,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7600.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(552,7657,40760,25773,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3700.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(553,7657,40760,25773,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11600.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(554,7657,40760,25773,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3200.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(555,7657,40760,25773,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5000.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(556,7657,40760,25773,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',800.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(557,7657,40760,25773,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7000.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(558,7657,40760,25773,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1000.00,NULL,NULL,1,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(559,7657,40760,25773,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',17551.34,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(560,7657,40760,25773,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',20525.20,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(561,7657,40760,25773,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3200.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(562,7657,40760,25773,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4600.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(563,7657,40760,25773,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2900.01,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(564,7657,40760,25773,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1600.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(565,7657,40760,25773,3,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4500.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(566,7657,40760,25773,3,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4500.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(567,7657,40760,25773,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1000.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(568,7657,40760,25773,3,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',16500.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(569,7657,40760,25773,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1500.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro` VALUES (570,7657,40760,25773,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4900.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(571,7657,40760,25773,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4400.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(572,7657,40760,25773,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(573,7657,40760,25773,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4000.01,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(574,7657,40760,25773,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',12350.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(575,7657,40760,25773,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1900.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(576,7657,40760,25773,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',18600.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(577,7657,40760,25773,3,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3200.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(578,7657,40760,25773,3,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4200.01,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(579,7657,40760,25773,3,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',8500.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(580,7657,40760,25773,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(581,7657,40760,25773,3,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3500.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(582,7657,40760,25773,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1000.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(583,7657,40760,25773,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',10000.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(584,7657,40760,25773,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2900.01,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(585,7657,40760,25773,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(586,7657,40760,25773,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1800.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(587,7657,40760,25773,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2000.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(588,7657,40760,25773,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',13100.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro` VALUES (589,7657,40760,25773,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4300.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(590,7657,40760,25773,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',14300.00,NULL,NULL,1,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(591,7657,40760,25773,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3600.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(592,7657,40760,25773,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3600.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(593,7657,40760,25773,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4000.01,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(594,7657,40760,25773,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',28050.45,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(595,7657,40760,25773,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',88363.99,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(596,7657,40760,25773,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8340.83,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(597,7657,40760,25773,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',29502.47,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(598,7657,40760,25773,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',181581.39,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(599,7657,40760,25773,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6000.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(600,7657,40760,25773,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10600.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(601,7657,40760,25773,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',34500.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(602,7657,40760,25773,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4200.01,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(603,7657,40760,25773,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2500.01,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(604,7657,40760,25773,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7000.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(605,7657,40760,25773,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4700.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(606,7657,40760,25773,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',81494.54,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(607,7657,40760,25773,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3000.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56');
INSERT INTO `balance_libro` VALUES (608,7657,40760,25773,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9400.01,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(609,7657,40760,25773,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5600.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(610,7657,40760,25773,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4700.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(611,7657,40760,25773,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2700.01,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(612,7657,40760,25773,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4700.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(613,7657,40760,25773,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4500.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(614,7657,40760,25773,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2000.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(615,7657,40760,25773,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4000.01,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(616,7657,40760,25773,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',800.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(617,7657,40760,25773,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',8800.00,NULL,NULL,1,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(618,7657,40760,25773,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4500.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(619,7657,40760,25773,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',800.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(620,7657,40760,25773,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1800.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(621,7657,40760,25773,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3300.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(622,7657,40760,25773,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3000.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(623,7657,40760,25773,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8294.09,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(624,7657,40760,25773,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',386043.72,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(625,7657,40760,25773,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',60100.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(626,7657,40760,25773,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',6850.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56');
INSERT INTO `balance_libro` VALUES (627,7657,40760,25773,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',74541.60,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(628,7657,40760,25773,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',68086.20,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(629,7657,40760,25773,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4950.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(630,7657,40760,25773,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',600.00,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(631,7657,40760,25773,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',98901.60,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(632,7657,40760,25773,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',61752.60,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(633,7657,40760,25773,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',114965.09,NULL,NULL,1,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(634,7657,40760,25773,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8400.00,NULL,NULL,1,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(635,7657,40760,25773,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2400.00,NULL,NULL,1,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(636,7657,40760,25773,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',48300.01,NULL,NULL,1,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(637,7657,40760,25773,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3500.00,NULL,NULL,1,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(638,7657,40760,25773,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2650.00,NULL,NULL,1,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(639,7657,40760,25773,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5600.00,NULL,NULL,1,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(640,7657,40760,25773,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',35800.00,NULL,NULL,1,'2023-04-24 22:12:37','2023-04-24 22:31:02','2023-04-24 22:31:02'),(641,7657,40760,25773,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',39200.01,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(642,7657,40760,25773,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5400.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(643,7657,40760,25773,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',11500.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(644,7657,40760,25773,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',53669.05,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(645,7657,40760,25773,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',28999.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro` VALUES (646,7657,40760,25773,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22200.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(647,7657,40760,25773,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6000.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(648,7657,40760,25773,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',800.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(649,7657,40760,25773,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6000.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(650,7657,40760,25773,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',800.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(651,7657,40760,25773,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1150.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(652,7657,40760,25773,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',76300.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(653,7657,40760,25773,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3200.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(654,7657,40760,25773,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22300.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(655,7657,40760,25773,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5374.18,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(656,7657,40760,25773,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',103998.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(657,7657,40760,25773,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',60000.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(658,7657,40760,25773,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',19500.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(659,7657,40760,25773,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3900.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(660,7657,40760,25773,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12600.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(661,7657,40760,25773,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2400.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(662,7657,40760,25773,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',39500.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(663,7657,40760,25773,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14950.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(664,7657,40760,25773,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',16500.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro` VALUES (665,7657,40760,25773,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',23200.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(666,7657,40760,25773,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',398.91,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(667,7657,40760,25773,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',111999.20,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(668,7657,40760,25773,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5000.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(669,7657,40760,25773,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',55700.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(670,7657,40760,25773,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',11600.00,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(671,7657,40760,25773,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',15000.01,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(672,7657,40760,25773,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5300.01,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(673,7657,40760,25773,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',35544.74,NULL,NULL,1,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(674,7657,40760,25773,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',34500.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(675,7657,40760,25773,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4600.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(676,7657,40760,25773,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3000.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(677,7657,40760,25773,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',900.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(678,7657,40760,25773,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5500.01,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(679,7657,40760,25773,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',71336.61,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(680,7657,40760,25773,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7620.86,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(681,7657,40760,25773,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3500.01,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(682,7657,40760,25773,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11880.07,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(683,7657,40760,25773,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',29688.40,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro` VALUES (684,7657,40760,25773,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',19000.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(685,7657,40760,25773,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3000.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(686,7657,40760,25773,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',20000.01,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(687,7657,40760,25773,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6200.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(688,7657,40760,25773,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1800.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(689,7657,40760,25773,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2600.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(690,7657,40760,25773,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',23400.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(691,7657,40760,25773,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',99120.31,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(692,7657,40760,25773,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',687215.07,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(693,7657,40760,25773,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2700.01,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(694,7657,40760,25773,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5200.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(695,7657,40760,25773,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1200.01,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(696,7657,40760,25773,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1500.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(697,7657,40760,25773,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3999.99,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(698,7657,40760,25773,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',35100.01,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(699,7657,40760,25773,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7200.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(700,7657,40760,25773,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',15600.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(701,7657,40760,25773,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3700.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(702,7657,40760,25773,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3500.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro` VALUES (703,7657,40760,25773,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3500.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(704,7657,40760,25773,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1600.00,NULL,NULL,1,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(705,7657,40760,25773,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',13627.26,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(706,7657,40760,25773,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',29469.77,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(707,7657,40760,25773,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',16207.95,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(708,7657,40760,25773,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',40400.70,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(709,7657,40760,25773,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14432.53,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(710,7657,40760,25773,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',114950.12,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(711,7657,40760,25773,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7200.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(712,7657,40760,25773,3,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3900.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(713,7657,40760,25773,3,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1200.01,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(714,7657,40760,25773,3,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3600.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(715,7657,40760,25773,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2200.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(716,7657,40760,25773,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7300.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(717,7657,40760,25773,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',34429.24,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(718,7657,40760,25773,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',178049.21,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(719,7657,40760,25773,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',14100.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(720,7657,40760,25773,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1580.01,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(721,7657,40760,25773,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1500.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro` VALUES (722,7657,40760,25773,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5000.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(723,7657,40760,25773,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',15600.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(724,7657,40760,25773,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8100.01,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(725,7657,40760,25773,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8518.23,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(726,7657,40760,25773,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11880.02,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(727,7657,40760,25773,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',700.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(728,7657,40760,25773,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',6300.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(729,7657,40760,25773,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9700.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(730,7657,40760,25773,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',28900.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(731,7657,40760,25773,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7600.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(732,7657,40760,25773,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4900.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(733,7657,40760,25773,3,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12300.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(734,7657,40760,25773,3,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',800.00,NULL,NULL,1,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(735,7657,40760,25773,3,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',18500.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(736,7657,40760,25773,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4000.01,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(737,7657,40760,25773,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12300.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(738,7657,40760,25773,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1500.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(739,7657,40760,25773,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1800.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(740,7657,40760,25773,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',800.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro` VALUES (741,7657,40760,25773,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11500.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(742,7657,40760,25773,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2000.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(743,7657,40760,25773,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8900.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(744,7657,40760,25773,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',800.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(745,7657,40760,25773,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',550.01,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(746,7657,40760,25773,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10900.01,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(747,7657,40760,25773,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1800.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(748,7657,40760,25773,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4400.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(749,7657,40760,25773,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11000.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(750,7657,40760,25773,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',25400.01,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(751,7657,40760,25773,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',21800.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(752,7657,40760,25773,3,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5200.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(753,7657,40760,25773,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',40800.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(754,7657,40760,25773,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',36340.38,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(755,7657,40760,25773,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11500.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(756,7657,40760,25773,3,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5800.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(757,7657,40760,25773,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7500.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(758,7657,40760,25773,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6400.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(759,7657,40760,25773,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',84998.12,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro` VALUES (760,7657,40760,25773,3,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2800.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(761,7657,40760,25773,3,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4600.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(762,7657,40760,25773,3,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10700.01,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(763,7657,40760,25773,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5900.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(764,7657,40760,25773,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4500.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(765,7657,40760,25773,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3500.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(766,7657,40760,25773,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4500.00,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(767,7657,40760,25773,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',22800.01,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(768,7657,40760,25773,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9600.01,NULL,NULL,1,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(769,7657,40760,25773,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',18500.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(770,7657,40760,25773,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8700.24,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(771,7657,40760,25773,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27808.52,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(772,7657,40760,25773,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',500.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(773,7657,40760,25773,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1900.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(774,7657,40760,25773,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5600.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(775,7657,40760,25773,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6300.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(776,7657,40760,25773,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6000.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(777,7657,40760,25773,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4500.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(778,7657,40760,25773,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3500.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro` VALUES (779,7657,40760,25773,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4700.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(780,7657,40760,25773,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9000.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(781,7657,40760,25773,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7700.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(782,7657,40760,25773,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8600.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(783,7657,40760,25773,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11200.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(784,7657,40760,25773,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2100.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(785,7657,40760,25773,3,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1500.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(786,7657,40760,25773,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6500.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(787,7657,40760,25773,3,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1200.01,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(788,7657,40760,25773,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5200.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(789,7657,40760,25773,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',12900.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(790,7657,40760,25773,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7600.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(791,7657,40760,25773,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3700.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(792,7657,40760,25773,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11600.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(793,7657,40760,25773,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3200.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(794,7657,40760,25773,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5000.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(795,7657,40760,25773,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',800.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(796,7657,40760,25773,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7000.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(797,7657,40760,25773,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1000.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro` VALUES (798,7657,40760,25773,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',17551.34,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(799,7657,40760,25773,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',20525.20,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(800,7657,40760,25773,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3200.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(801,7657,40760,25773,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4600.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(802,7657,40760,25773,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2900.01,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(803,7657,40760,25773,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1600.00,NULL,NULL,1,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(804,7657,40760,25773,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4500.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(805,7657,40760,25773,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4500.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(806,7657,40760,25773,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1000.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(807,7657,40760,25773,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',16500.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(808,7657,40760,25773,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1500.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(809,7657,40760,25773,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4900.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(810,7657,40760,25773,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4400.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(811,7657,40760,25773,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(812,7657,40760,25773,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4000.01,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(813,7657,40760,25773,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',12350.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(814,7657,40760,25773,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1900.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(815,7657,40760,25773,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',18600.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(816,7657,40760,25773,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3200.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro` VALUES (817,7657,40760,25773,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4200.01,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(818,7657,40760,25773,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',8500.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(819,7657,40760,25773,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(820,7657,40760,25773,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3500.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(821,7657,40760,25773,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1000.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(822,7657,40760,25773,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',10000.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(823,7657,40760,25773,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2900.01,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(824,7657,40760,25773,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(825,7657,40760,25773,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1800.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(826,7657,40760,25773,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2000.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(827,7657,40760,25773,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',13100.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(828,7657,40760,25773,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4300.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(829,7657,40760,25773,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',14300.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(830,7657,40760,25773,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3600.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(831,7657,40760,25773,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3600.00,NULL,NULL,1,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(832,7657,40760,25773,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4000.01,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(833,7657,40760,25773,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',28050.45,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(834,7657,40760,25773,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',88363.99,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(835,7657,40760,25773,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8340.83,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro` VALUES (836,7657,40760,25773,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',29502.47,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(837,7657,40760,25773,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',181581.39,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(838,7657,40760,25773,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6000.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(839,7657,40760,25773,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10600.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(840,7657,40760,25773,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',34500.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(841,7657,40760,25773,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4200.01,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(842,7657,40760,25773,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2500.01,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(843,7657,40760,25773,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7000.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(844,7657,40760,25773,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4700.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(845,7657,40760,25773,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',81494.54,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(846,7657,40760,25773,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3000.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(847,7657,40760,25773,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9400.01,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(848,7657,40760,25773,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5600.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(849,7657,40760,25773,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4700.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(850,7657,40760,25773,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2700.01,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(851,7657,40760,25773,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4700.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(852,7657,40760,25773,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4500.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(853,7657,40760,25773,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2000.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(854,7657,40760,25773,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4000.01,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro` VALUES (855,7657,40760,25773,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',800.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(856,7657,40760,25773,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',8800.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(857,7657,40760,25773,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4500.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(858,7657,40760,25773,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',800.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(859,7657,40760,25773,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1800.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(860,7657,40760,25773,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3300.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(861,7657,40760,25773,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3000.00,NULL,NULL,1,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(862,7657,40760,25773,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8294.09,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(863,7657,40760,25773,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',386043.72,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(864,7657,40760,25773,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',60100.00,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(865,7657,40760,25773,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',6850.00,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(866,7657,40760,25773,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',74541.60,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(867,7657,40760,25773,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',68086.20,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(868,7657,40760,25773,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4950.00,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(869,7657,40760,25773,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',600.00,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(870,7657,40760,25773,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',98901.60,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(871,7657,40760,25773,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',61752.60,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(872,7657,40760,25773,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',114965.09,NULL,NULL,1,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(873,7657,40760,25773,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',349695.59,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL);
INSERT INTO `balance_libro` VALUES (874,7657,40760,25773,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',16000.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(875,7657,40760,25773,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3900.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(876,7657,40760,25773,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2200.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(877,7657,40760,25773,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13068.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(878,7657,40760,25773,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9500.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(879,7657,40760,25773,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',12370.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(880,7657,40760,25773,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3600.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(881,7657,40760,25773,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',800.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(882,7657,40760,25773,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5640.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(883,7657,40760,25773,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',550.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(884,7657,40760,25773,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',100.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(885,7657,40760,25773,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12600.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(886,7657,40760,25773,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',43800.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(887,7657,40760,25773,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4356.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(888,7657,40760,25773,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',16650.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(889,7657,40760,25773,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',46000.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(890,7657,40760,25773,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',32980.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(891,7657,40760,25773,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',31000.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(892,7657,40760,25773,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2920.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(893,7657,40760,25773,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',27500.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(894,7657,40760,25773,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',462825.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL);
INSERT INTO `balance_libro` VALUES (895,7657,40760,25773,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2160.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(896,7657,40760,25773,2,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3500.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(897,7657,40760,25773,2,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2950.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(898,7657,40760,25773,2,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',900.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(899,7657,40760,25773,2,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2100.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(900,7657,40760,25773,2,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7626.00,NULL,NULL,1,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(901,7657,40760,25773,2,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7240.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(902,7657,40760,25773,2,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3650.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(903,7657,40760,25773,2,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17360.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(904,7657,40760,25773,2,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',12140.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(905,7657,40760,25773,2,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',11600.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(906,7657,40760,25773,2,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2380.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(907,7657,40760,25773,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3400.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(908,7657,40760,25773,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17900.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(909,7657,40760,25773,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3010.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(910,7657,40760,25773,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6036.69,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(911,7657,40760,25773,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2790.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(912,7657,40760,25773,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',30600.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(913,7657,40760,25773,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1000.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(914,7657,40760,25773,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1790.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(915,7657,40760,25773,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',850.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL);
INSERT INTO `balance_libro` VALUES (916,7657,40760,25773,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1980.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(917,7657,40760,25773,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',10150.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(918,7657,40760,25773,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',25120.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(919,7657,40760,25773,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4200.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(920,7657,40760,25773,2,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3000.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(921,7657,40760,25773,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5550.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(922,7657,40760,25773,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1910.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(923,7657,40760,25773,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1450.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(924,7657,40760,25773,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4700.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(925,7657,40760,25773,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1600.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(926,7657,40760,25773,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4400.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(927,7657,40760,25773,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1000.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(928,7657,40760,25773,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',16890.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(929,7657,40760,25773,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5200.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(930,7657,40760,25773,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3200.00,NULL,NULL,1,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(931,7657,40760,25773,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2300.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(932,7657,40760,25773,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1700.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(933,7657,40760,25773,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',952151.34,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(934,7657,40760,25773,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',28053.85,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(935,7657,40760,25773,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7000.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(936,7657,40760,25773,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2200.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL);
INSERT INTO `balance_libro` VALUES (937,7657,40760,25773,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2200.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(938,7657,40760,25773,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1586431.68,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(939,7657,40760,25773,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3250.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(940,7657,40760,25773,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1650.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(941,7657,40760,25773,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',21000.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(942,7657,40760,25773,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',7700.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(943,7657,40760,25773,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',8000.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(944,7657,40760,25773,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',600.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(945,7657,40760,25773,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2200.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(946,7657,40760,25773,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',244.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(947,7657,40760,25773,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6840.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(948,7657,40760,25773,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1250.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(949,7657,40760,25773,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',600.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(950,7657,40760,25773,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2900.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(951,7657,40760,25773,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2100.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(952,7657,40760,25773,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4800.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(953,7657,40760,25773,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6700.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(954,7657,40760,25773,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3300.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(955,7657,40760,25773,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1100.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(956,7657,40760,25773,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3300.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(957,7657,40760,25773,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',800.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL);
INSERT INTO `balance_libro` VALUES (958,7657,40760,25773,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2850.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(959,7657,40760,25773,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',450.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(960,7657,40760,25773,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',450.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(961,7657,40760,25773,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1100.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(962,7657,40760,25773,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',950.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(963,7657,40760,25773,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1815000.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(964,7657,40760,25773,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21300.00,NULL,NULL,1,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(965,7657,40760,25773,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18000.00,NULL,NULL,1,'2023-04-26 22:34:00','2023-04-26 22:34:00',NULL),(966,7657,40760,25773,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4150.00,NULL,NULL,1,'2023-04-26 22:34:00','2023-04-26 22:34:00',NULL),(967,7657,40760,25773,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8400.00,NULL,NULL,1,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(968,7657,40760,25773,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2400.00,NULL,NULL,1,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(969,7657,40760,25773,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',48300.01,NULL,NULL,1,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(970,7657,40760,25773,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3500.00,NULL,NULL,1,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(971,7657,40760,25773,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2650.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(972,7657,40760,25773,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5600.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(973,7657,40760,25773,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',35800.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(974,7657,40760,25773,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',39200.01,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(975,7657,40760,25773,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5400.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(976,7657,40760,25773,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',11500.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(977,7657,40760,25773,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',53669.05,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(978,7657,40760,25773,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',28999.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL);
INSERT INTO `balance_libro` VALUES (979,7657,40760,25773,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22200.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(980,7657,40760,25773,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6000.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(981,7657,40760,25773,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',800.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(982,7657,40760,25773,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6000.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(983,7657,40760,25773,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',800.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(984,7657,40760,25773,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1150.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(985,7657,40760,25773,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',76300.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(986,7657,40760,25773,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3200.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(987,7657,40760,25773,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22300.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(988,7657,40760,25773,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5374.18,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 23:13:21','2023-04-26 23:13:21'),(989,7657,40760,25773,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',103998.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(990,7657,40760,25773,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',60000.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(991,7657,40760,25773,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',19500.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(992,7657,40760,25773,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3900.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(993,7657,40760,25773,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12600.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(994,7657,40760,25773,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2400.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(995,7657,40760,25773,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',39500.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(996,7657,40760,25773,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14950.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(997,7657,40760,25773,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',16500.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(998,7657,40760,25773,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',23200.00,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(999,7657,40760,25773,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',398.91,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL);
INSERT INTO `balance_libro` VALUES (1000,7657,40760,25773,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',111999.20,NULL,NULL,1,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(1001,7657,40760,25773,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5000.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1002,7657,40760,25773,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',55700.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1003,7657,40760,25773,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',11600.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1004,7657,40760,25773,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',15000.01,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1005,7657,40760,25773,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5300.01,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1006,7657,40760,25773,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',35544.74,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1007,7657,40760,25773,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',34500.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1008,7657,40760,25773,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4600.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1009,7657,40760,25773,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3000.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1010,7657,40760,25773,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',900.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1011,7657,40760,25773,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5500.01,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1012,7657,40760,25773,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',71336.61,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 23:15:52','2023-04-26 23:15:52'),(1013,7657,40760,25773,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7620.86,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1014,7657,40760,25773,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3500.01,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 23:18:38','2023-04-26 23:18:38'),(1015,7657,40760,25773,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11880.07,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1016,7657,40760,25773,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',29688.40,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1017,7657,40760,25773,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',19000.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1018,7657,40760,25773,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3000.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1019,7657,40760,25773,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',20000.01,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1020,7657,40760,25773,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6200.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL);
INSERT INTO `balance_libro` VALUES (1021,7657,40760,25773,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1800.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1022,7657,40760,25773,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2600.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1023,7657,40760,25773,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',23400.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1024,7657,40760,25773,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',99120.31,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 23:22:45','2023-04-26 23:22:45'),(1025,7657,40760,25773,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',687215.07,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 23:29:24','2023-04-26 23:29:24'),(1026,7657,40760,25773,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2700.01,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1027,7657,40760,25773,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5200.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1028,7657,40760,25773,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1200.01,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1029,7657,40760,25773,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1500.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1030,7657,40760,25773,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3999.99,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1031,7657,40760,25773,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',35100.01,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1032,7657,40760,25773,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7200.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1033,7657,40760,25773,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',15600.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1034,7657,40760,25773,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3700.00,NULL,NULL,1,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(1035,7657,40760,25773,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3500.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1036,7657,40760,25773,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3500.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1037,7657,40760,25773,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1600.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1038,7657,40760,25773,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',13627.26,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1039,7657,40760,25773,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',29469.77,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1040,7657,40760,25773,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',16207.95,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL);
INSERT INTO `balance_libro` VALUES (1041,7657,40760,25773,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',40400.70,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 23:39:54','2023-04-26 23:39:54'),(1042,7657,40760,25773,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14432.53,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 23:48:18','2023-04-26 23:48:18'),(1043,7657,40760,25773,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',178049.21,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1044,7657,40760,25773,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',114950.12,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-27 07:21:10','2023-04-27 07:21:10'),(1045,7657,40760,25773,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7200.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1046,7657,40760,25773,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3900.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1047,7657,40760,25773,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1200.01,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1048,7657,40760,25773,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3600.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1049,7657,40760,25773,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2200.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1050,7657,40760,25773,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7300.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1051,7657,40760,25773,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',34429.24,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1052,7657,40760,25773,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',14100.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1053,7657,40760,25773,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1580.01,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1054,7657,40760,25773,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1500.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1055,7657,40760,25773,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5000.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1056,7657,40760,25773,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',15600.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1057,7657,40760,25773,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8100.01,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1058,7657,40760,25773,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8518.23,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1059,7657,40760,25773,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11880.02,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1060,7657,40760,25773,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',700.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL);
INSERT INTO `balance_libro` VALUES (1061,7657,40760,25773,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',6300.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1062,7657,40760,25773,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9700.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1063,7657,40760,25773,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',28900.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1064,7657,40760,25773,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7600.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1065,7657,40760,25773,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4900.00,NULL,NULL,1,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(1066,7657,40760,25773,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12300.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1067,7657,40760,25773,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',800.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1068,7657,40760,25773,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',18500.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1069,7657,40760,25773,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4000.01,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1070,7657,40760,25773,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12300.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1071,7657,40760,25773,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1500.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1072,7657,40760,25773,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1800.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1073,7657,40760,25773,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',800.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1074,7657,40760,25773,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11500.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1075,7657,40760,25773,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2000.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1076,7657,40760,25773,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8900.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1077,7657,40760,25773,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',800.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1078,7657,40760,25773,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',550.01,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1079,7657,40760,25773,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11500.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1080,7657,40760,25773,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5800.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1081,7657,40760,25773,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7500.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL);
INSERT INTO `balance_libro` VALUES (1082,7657,40760,25773,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6400.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1083,7657,40760,25773,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',84998.12,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-27 07:30:27','2023-04-27 07:30:27'),(1084,7657,40760,25773,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2800.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1085,7657,40760,25773,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4600.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1086,7657,40760,25773,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10700.01,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1087,7657,40760,25773,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5900.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1088,7657,40760,25773,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4500.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1089,7657,40760,25773,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10900.01,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1090,7657,40760,25773,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1800.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1091,7657,40760,25773,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4400.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1092,7657,40760,25773,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11000.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1093,7657,40760,25773,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',25400.01,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1094,7657,40760,25773,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',21800.00,NULL,NULL,1,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(1095,7657,40760,25773,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5200.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1096,7657,40760,25773,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',40800.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1097,7657,40760,25773,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',36340.38,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-27 15:41:44','2023-04-27 15:41:44'),(1098,7657,40760,25773,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3500.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1099,7657,40760,25773,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4500.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1100,7657,40760,25773,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',22800.01,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1101,7657,40760,25773,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9600.01,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL);
INSERT INTO `balance_libro` VALUES (1102,7657,40760,25773,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',18500.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1103,7657,40760,25773,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8700.24,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-27 16:41:33','2023-04-27 16:41:33'),(1104,7657,40760,25773,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27808.52,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1105,7657,40760,25773,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',500.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1106,7657,40760,25773,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1900.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1107,7657,40760,25773,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5600.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1108,7657,40760,25773,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6300.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1109,7657,40760,25773,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6000.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1110,7657,40760,25773,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4500.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1111,7657,40760,25773,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3500.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1112,7657,40760,25773,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4700.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1113,7657,40760,25773,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9000.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1114,7657,40760,25773,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7700.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1115,7657,40760,25773,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8600.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1116,7657,40760,25773,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11200.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1117,7657,40760,25773,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2100.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1118,7657,40760,25773,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1500.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1119,7657,40760,25773,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6500.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1120,7657,40760,25773,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1200.01,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1121,7657,40760,25773,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5200.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(1122,7657,40760,25773,3,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',12900.00,NULL,NULL,1,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL);
INSERT INTO `balance_libro` VALUES (1123,7657,40760,25773,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7600.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1124,7657,40760,25773,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3700.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1125,7657,40760,25773,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11600.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1126,7657,40760,25773,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3200.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1127,7657,40760,25773,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5000.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1128,7657,40760,25773,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',800.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1129,7657,40760,25773,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7000.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1130,7657,40760,25773,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1000.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1131,7657,40760,25773,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',17551.34,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-27 17:13:45','2023-04-27 17:13:45'),(1132,7657,40760,25773,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',20525.20,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-27 17:19:31','2023-04-27 17:19:31'),(1133,7657,40760,25773,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3200.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1134,7657,40760,25773,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4600.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1135,7657,40760,25773,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2900.01,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1136,7657,40760,25773,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1600.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1137,7657,40760,25773,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4500.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1138,7657,40760,25773,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4500.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1139,7657,40760,25773,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1000.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1140,7657,40760,25773,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',16500.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1141,7657,40760,25773,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1500.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1142,7657,40760,25773,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4900.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL);
INSERT INTO `balance_libro` VALUES (1143,7657,40760,25773,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4400.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1144,7657,40760,25773,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1145,7657,40760,25773,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4000.01,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1146,7657,40760,25773,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',12350.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1147,7657,40760,25773,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1900.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1148,7657,40760,25773,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',18600.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1149,7657,40760,25773,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3200.00,NULL,NULL,1,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(1150,7657,40760,25773,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4200.01,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1151,7657,40760,25773,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',8500.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1152,7657,40760,25773,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1153,7657,40760,25773,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3500.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1154,7657,40760,25773,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1000.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1155,7657,40760,25773,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',10000.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1156,7657,40760,25773,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2900.01,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1157,7657,40760,25773,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1158,7657,40760,25773,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1800.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1159,7657,40760,25773,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2000.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1160,7657,40760,25773,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',13100.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1161,7657,40760,25773,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4300.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1162,7657,40760,25773,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',14300.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1163,7657,40760,25773,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3600.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL);
INSERT INTO `balance_libro` VALUES (1164,7657,40760,25773,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3600.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1165,7657,40760,25773,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4000.01,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1166,7657,40760,25773,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',28050.45,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1167,7657,40760,25773,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',88363.99,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1168,7657,40760,25773,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8340.83,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1169,7657,40760,25773,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',29502.47,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-27 17:44:10','2023-04-27 17:44:10'),(1170,7657,40760,25773,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',181581.39,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-27 17:54:46','2023-04-27 17:54:46'),(1171,7657,40760,25773,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6000.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1172,7657,40760,25773,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10600.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1173,7657,40760,25773,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',34500.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1174,7657,40760,25773,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4200.01,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1175,7657,40760,25773,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2500.01,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1176,7657,40760,25773,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7000.00,NULL,NULL,1,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(1177,7657,40760,25773,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4700.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1178,7657,40760,25773,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',81494.54,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-27 17:57:13','2023-04-27 17:57:13'),(1179,7657,40760,25773,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3000.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1180,7657,40760,25773,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9400.01,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1181,7657,40760,25773,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5600.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1182,7657,40760,25773,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4700.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1183,7657,40760,25773,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2700.01,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL);
INSERT INTO `balance_libro` VALUES (1184,7657,40760,25773,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4700.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1185,7657,40760,25773,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4500.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1186,7657,40760,25773,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2000.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1187,7657,40760,25773,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4000.01,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1188,7657,40760,25773,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',800.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1189,7657,40760,25773,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',8800.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1190,7657,40760,25773,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4500.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1191,7657,40760,25773,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',800.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1192,7657,40760,25773,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1800.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1193,7657,40760,25773,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3300.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1194,7657,40760,25773,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3000.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-27 18:05:28','2023-04-27 18:05:28'),(1195,7657,40760,25773,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8294.09,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1196,7657,40760,25773,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',386043.72,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-27 18:15:58','2023-04-27 18:15:58'),(1197,7657,40760,25773,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',60100.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1198,7657,40760,25773,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',6850.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1199,7657,40760,25773,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',74541.60,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-27 18:18:43','2023-04-27 18:18:43'),(1200,7657,40760,25773,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',68086.20,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-27 18:20:28','2023-04-27 18:20:28'),(1201,7657,40760,25773,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4950.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1202,7657,40760,25773,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',600.00,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(1203,7657,40760,25773,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',98901.60,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-27 18:22:27','2023-04-27 18:22:27');
INSERT INTO `balance_libro` VALUES (1204,7657,40760,25773,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',61752.60,NULL,NULL,1,'2023-04-26 22:50:24','2023-04-27 18:23:46','2023-04-27 18:23:46'),(1205,7657,40760,25773,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',114965.09,NULL,NULL,1,'2023-04-26 22:50:25','2023-04-27 18:26:32','2023-04-27 18:26:32'),(1206,7657,40760,25773,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5374.18,NULL,NULL,1,'2023-04-26 23:13:21','2023-04-26 23:13:21',NULL),(1207,7657,40760,25773,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',71336.61,NULL,NULL,1,'2023-04-26 23:15:52','2023-04-26 23:15:52',NULL),(1208,7657,40760,25773,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3500.01,NULL,NULL,1,'2023-04-26 23:18:38','2023-04-26 23:18:38',NULL),(1209,7657,40760,25773,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',99120.30,NULL,NULL,1,'2023-04-26 23:22:45','2023-04-26 23:22:45',NULL),(1210,7657,40760,25773,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',687215.06,NULL,NULL,1,'2023-04-26 23:29:24','2023-04-26 23:29:24',NULL),(1211,7657,40760,25773,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',38262.97,NULL,NULL,1,'2023-04-26 23:39:54','2023-04-26 23:39:54',NULL),(1212,7657,40760,25773,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14432.53,NULL,NULL,1,'2023-04-26 23:48:18','2023-04-27 07:13:30','2023-04-27 07:13:30'),(1213,7657,40760,25773,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14432.53,NULL,NULL,1,'2023-04-27 07:13:30','2023-04-27 07:13:30',NULL),(1214,7657,40760,25773,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',114950.12,NULL,NULL,1,'2023-04-27 07:21:10','2023-04-27 07:21:10',NULL),(1215,7657,40760,25773,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',84998.12,NULL,NULL,1,'2023-04-27 07:30:27','2023-04-27 07:30:27',NULL),(1216,7657,40760,25773,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',36340.38,NULL,NULL,1,'2023-04-27 15:41:44','2023-04-27 15:41:44',NULL),(1217,7657,40760,25773,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8700.24,NULL,NULL,1,'2023-04-27 16:41:33','2023-04-27 16:41:33',NULL),(1218,7657,40760,25773,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',17551.34,NULL,NULL,1,'2023-04-27 17:13:45','2023-04-27 17:13:45',NULL),(1219,7657,40760,25773,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',20525.20,NULL,NULL,1,'2023-04-27 17:19:31','2023-04-27 17:19:31',NULL),(1220,7657,40760,25773,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',29502.48,NULL,NULL,1,'2023-04-27 17:44:10','2023-04-27 17:44:10',NULL),(1221,7657,40760,25773,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',181581.39,NULL,NULL,1,'2023-04-27 17:54:46','2023-04-27 17:54:46',NULL),(1222,7657,40760,25773,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',81555.65,NULL,NULL,1,'2023-04-27 17:57:13','2023-04-27 18:11:18','2023-04-27 18:11:18'),(1223,7657,40760,25773,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2999.99,NULL,NULL,1,'2023-04-27 18:05:28','2023-04-27 18:05:28',NULL);
INSERT INTO `balance_libro` VALUES (1224,7657,40760,25773,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',81555.65,NULL,NULL,1,'2023-04-27 18:11:18','2023-04-27 18:11:18',NULL),(1225,7657,40760,25773,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',386043.72,NULL,NULL,1,'2023-04-27 18:15:58','2023-04-27 18:15:58',NULL),(1226,7657,40760,25773,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',74541.60,NULL,NULL,1,'2023-04-27 18:18:43','2023-04-27 18:18:43',NULL),(1227,7657,40760,25773,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',68086.20,NULL,NULL,1,'2023-04-27 18:20:28','2023-04-27 18:20:28',NULL),(1228,7657,40760,25773,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',98901.60,NULL,NULL,1,'2023-04-27 18:22:27','2023-04-27 18:22:27',NULL),(1229,7657,40760,25773,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',61752.60,NULL,NULL,1,'2023-04-27 18:23:46','2023-04-27 18:23:46',NULL),(1230,7657,40760,25773,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',114965.09,NULL,NULL,1,'2023-04-27 18:26:32','2023-04-27 18:26:32',NULL),(1231,7657,40760,25774,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3720.75,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1232,7657,40760,25774,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5700.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1233,7657,40760,25774,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2850.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1234,7657,40760,25774,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',30000.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1235,7657,40760,25774,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1500.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1236,7657,40760,25774,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5152.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1237,7657,40760,25774,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',8120.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1238,7657,40760,25774,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1100.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1239,7657,40760,25774,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2260.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1240,7657,40760,25774,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',13010.00,NULL,NULL,1,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(1241,7657,40760,25774,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',773.64,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1242,7657,40760,25774,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',34848.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1243,7657,40760,25774,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',3169.98,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1244,7657,40760,25774,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2712.29,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL);
INSERT INTO `balance_libro` VALUES (1245,7657,40760,25774,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2720.50,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1246,7657,40760,25774,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1850.01,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1247,7657,40760,25774,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1600.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1248,7657,40760,25774,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1800.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1249,7657,40760,25774,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8000.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1250,7657,40760,25774,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',15900.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1251,7657,40760,25774,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1800.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1252,7657,40760,25774,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4700.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1253,7657,40760,25774,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',27625.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1254,7657,40760,25774,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',9999.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1255,7657,40760,25774,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2658.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:35:10','2023-04-29 21:35:10'),(1256,7657,40760,25774,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1800.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1257,7657,40760,25774,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',800.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1258,7657,40760,25774,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',900.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1259,7657,40760,25774,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1600.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1260,7657,40760,25774,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',25700.00,NULL,NULL,1,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(1261,7657,40760,25774,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',77000.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1262,7657,40760,25774,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',5300.01,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1263,7657,40760,25774,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4500.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1264,7657,40760,25774,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',14194.40,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:41:34','2023-04-29 21:41:34');
INSERT INTO `balance_libro` VALUES (1265,7657,40760,25774,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',500.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1266,7657,40760,25774,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',10600.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1267,7657,40760,25774,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',8200.01,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1268,7657,40760,25774,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',2500.01,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1269,7657,40760,25774,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',398.91,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1270,7657,40760,25774,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',12360.98,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1271,7657,40760,25774,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',6600.01,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1272,7657,40760,25774,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',400.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1273,7657,40760,25774,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',8800.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1274,7657,40760,25774,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4300.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1275,7657,40760,25774,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9100.01,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1276,7657,40760,25774,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',65138.50,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1277,7657,40760,25774,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',5100.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1278,7657,40760,25774,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',400.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1279,7657,40760,25774,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13500.01,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1280,7657,40760,25774,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4380.01,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1281,7657,40760,25774,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',19500.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1282,7657,40760,25774,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',413820.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1283,7657,40760,25774,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',8324.65,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1284,7657,40760,25774,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',7600.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1285,7657,40760,25774,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',10200.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL);
INSERT INTO `balance_libro` VALUES (1286,7657,40760,25774,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',8300.01,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1287,7657,40760,25774,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',17700.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1288,7657,40760,25774,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',5200.00,NULL,NULL,1,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(1289,7657,40760,25774,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',4600.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1290,7657,40760,25774,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',12000.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1291,7657,40760,25774,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',38431.91,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:44:11','2023-04-29 21:44:11'),(1292,7657,40760,25774,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',6600.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1293,7657,40760,25774,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1200.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1294,7657,40760,25774,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4000.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1295,7657,40760,25774,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1900.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1296,7657,40760,25774,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',750.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1297,7657,40760,25774,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2700.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1298,7657,40760,25774,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',16900.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1299,7657,40760,25774,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8700000.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1300,7657,40760,25774,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',41535.70,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1301,7657,40760,25774,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',273193.95,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:49:13','2023-04-29 21:49:13'),(1302,7657,40760,25774,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4500.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1303,7657,40760,25774,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2600.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1304,7657,40760,25774,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4200.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1305,7657,40760,25774,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2700.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL);
INSERT INTO `balance_libro` VALUES (1306,7657,40760,25774,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',26400.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1307,7657,40760,25774,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3598.99,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1308,7657,40760,25774,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',7700.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1309,7657,40760,25774,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',13500.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1310,7657,40760,25774,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3500.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1311,7657,40760,25774,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',7400.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1312,7657,40760,25774,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',39396.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1313,7657,40760,25774,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',9000.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1314,7657,40760,25774,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',4100.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1315,7657,40760,25774,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',16200.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1316,7657,40760,25774,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',13600.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1317,7657,40760,25774,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30900.01,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1318,7657,40760,25774,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',6700.00,NULL,NULL,1,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(1319,7657,40760,25774,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',44688.40,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1320,7657,40760,25774,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',5500.01,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1321,7657,40760,25774,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1800.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1322,7657,40760,25774,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',10300.88,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:54:11','2023-04-29 21:54:11'),(1323,7657,40760,25774,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',17447.58,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:57:21','2023-04-29 21:57:21'),(1324,7657,40760,25774,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2950.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1325,7657,40760,25774,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',5800.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL);
INSERT INTO `balance_libro` VALUES (1326,7657,40760,25774,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',16100.01,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1327,7657,40760,25774,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',11400.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1328,7657,40760,25774,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',11300.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1329,7657,40760,25774,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',21500.01,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1330,7657,40760,25774,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2500.01,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1331,7657,40760,25774,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4500.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1332,7657,40760,25774,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',32387557.26,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 22:06:47','2023-04-29 22:06:47'),(1333,7657,40760,25774,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',277571.20,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 22:10:12','2023-04-29 22:10:12'),(1334,7657,40760,25774,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1500.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1335,7657,40760,25774,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1200.01,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1336,7657,40760,25774,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3600.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1337,7657,40760,25774,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',15701.74,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 22:16:28','2023-04-29 22:16:28'),(1338,7657,40760,25774,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',43603.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1339,7657,40760,25774,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',4500.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 22:21:52','2023-04-29 22:21:52'),(1340,7657,40760,25774,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1300.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1341,7657,40760,25774,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',8250.01,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1342,7657,40760,25774,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',3300.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1343,7657,40760,25774,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',4450.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1344,7657,40760,25774,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',479080.39,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 22:27:42','2023-04-29 22:27:42'),(1345,7657,40760,25774,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2000.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL);
INSERT INTO `balance_libro` VALUES (1346,7657,40760,25774,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4500.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1347,7657,40760,25774,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4500.00,NULL,NULL,1,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(1348,7657,40760,25774,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1200.01,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1349,7657,40760,25774,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3500.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1350,7657,40760,25774,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',12500.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1351,7657,40760,25774,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',15500.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1352,7657,40760,25774,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',5800.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1353,7657,40760,25774,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4800.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1354,7657,40760,25774,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',30100.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1355,7657,40760,25774,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',288668.66,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1356,7657,40760,25774,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',17560.11,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1357,7657,40760,25774,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',217047.60,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 22:37:38','2023-04-29 22:37:38'),(1358,7657,40760,25774,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',178924.20,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 22:44:30','2023-04-29 22:44:30'),(1359,7657,40760,25774,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',900.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1360,7657,40760,25774,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',9000.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1361,7657,40760,25774,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1600.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1362,7657,40760,25774,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1400.01,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1363,7657,40760,25774,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',200970.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 22:47:24','2023-04-29 22:47:24'),(1364,7657,40760,25774,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1700.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1365,7657,40760,25774,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',193905.60,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 22:49:16','2023-04-29 22:49:16');
INSERT INTO `balance_libro` VALUES (1366,7657,40760,25774,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2700.01,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1367,7657,40760,25774,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6000.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1368,7657,40760,25774,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4000.01,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1369,7657,40760,25774,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4500.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1370,7657,40760,25774,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',8202.57,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1371,7657,40760,25774,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',16333.64,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1372,7657,40760,25774,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3040.89,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1373,7657,40760,25774,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',17424.00,NULL,NULL,1,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(1374,7657,40760,25774,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',9467.10,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1375,7657,40760,25774,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',206085.60,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 22:52:36','2023-04-29 22:52:36'),(1376,7657,40760,25774,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',192931.20,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 22:54:32','2023-04-29 22:54:32'),(1377,7657,40760,25774,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',159403.14,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1378,7657,40760,25774,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',270747.18,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 23:02:28','2023-04-29 23:02:28'),(1379,7657,40760,25774,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7200.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1380,7657,40760,25774,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',15400.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1381,7657,40760,25774,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',210714.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 23:04:22','2023-04-29 23:04:22'),(1382,7657,40760,25774,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1500.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1383,7657,40760,25774,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',5500.01,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1384,7657,40760,25774,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4200.01,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1385,7657,40760,25774,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',14500.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL);
INSERT INTO `balance_libro` VALUES (1386,7657,40760,25774,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4500.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1387,7657,40760,25774,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3400.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1388,7657,40760,25774,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4900.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1389,7657,40760,25774,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',900.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1390,7657,40760,25774,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',5000.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1391,7657,40760,25774,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4800.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1392,7657,40760,25774,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4000.01,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1393,7657,40760,25774,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1500.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1394,7657,40760,25774,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3500.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1395,7657,40760,25774,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',16100.01,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1396,7657,40760,25774,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',21800.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1397,7657,40760,25774,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2800.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1398,7657,40760,25774,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4400.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1399,7657,40760,25774,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',14400.00,NULL,NULL,1,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(1400,7657,40760,25774,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',6500.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1401,7657,40760,25774,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7100.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1402,7657,40760,25774,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1403,7657,40760,25774,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',11000.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1404,7657,40760,25774,3,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1800.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1405,7657,40760,25774,3,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',11500.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1406,7657,40760,25774,3,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',20300.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL);
INSERT INTO `balance_libro` VALUES (1407,7657,40760,25774,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',32600.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1408,7657,40760,25774,3,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',8600.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1409,7657,40760,25774,3,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',9600.01,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1410,7657,40760,25774,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',15500.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1411,7657,40760,25774,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1400.01,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1412,7657,40760,25774,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',5200.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1413,7657,40760,25774,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',75500.01,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1414,7657,40760,25774,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',43700.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1415,7657,40760,25774,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4500.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1416,7657,40760,25774,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',5700.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1417,7657,40760,25774,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4600.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1418,7657,40760,25774,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4800.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1419,7657,40760,25774,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4100.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1420,7657,40760,25774,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',23400.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1421,7657,40760,25774,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4600.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1422,7657,40760,25774,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3700.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1423,7657,40760,25774,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',18200.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1424,7657,40760,25774,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3800.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1425,7657,40760,25774,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',10300.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1426,7657,40760,25774,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',6100.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1427,7657,40760,25774,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',10400.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL);
INSERT INTO `balance_libro` VALUES (1428,7657,40760,25774,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2300.00,NULL,NULL,1,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(1429,7657,40760,25774,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',5000.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1430,7657,40760,25774,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3300.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1431,7657,40760,25774,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',205842.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 23:06:21','2023-04-29 23:06:21'),(1432,7657,40760,25774,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',213150.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 23:07:43','2023-04-29 23:07:43'),(1433,7657,40760,25774,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',217291.20,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 23:10:11','2023-04-29 23:10:11'),(1434,7657,40760,25774,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',245183.40,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 23:15:48','2023-04-29 23:15:48'),(1435,7657,40760,25774,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8200.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1436,7657,40760,25774,3,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1437,7657,40760,25774,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5000.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1438,7657,40760,25774,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4200.01,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1439,7657,40760,25774,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.01,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 23:20:44','2023-04-29 23:20:44'),(1440,7657,40760,25774,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2700.01,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1441,7657,40760,25774,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7700.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1442,7657,40760,25774,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30200.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1443,7657,40760,25774,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5600.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1444,7657,40760,25774,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',36200.01,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1445,7657,40760,25774,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2200.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1446,7657,40760,25774,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9000.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1447,7657,40760,25774,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3800.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL);
INSERT INTO `balance_libro` VALUES (1448,7657,40760,25774,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2000.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1449,7657,40760,25774,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5500.01,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1450,7657,40760,25774,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3200.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1451,7657,40760,25774,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1700.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1452,7657,40760,25774,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4300.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1453,7657,40760,25774,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1200.01,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1454,7657,40760,25774,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3200.00,NULL,NULL,1,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(1455,7657,40760,25774,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',11000.00,NULL,NULL,1,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(1456,7657,40760,25774,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4400.00,NULL,NULL,1,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(1457,7657,40760,25774,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4700.00,NULL,NULL,1,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(1458,7657,40760,25774,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16700.00,NULL,NULL,1,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(1459,7657,40760,25774,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5000.00,NULL,NULL,1,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(1460,7657,40760,25774,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6900.00,NULL,NULL,1,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(1461,7657,40760,25774,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.00,NULL,NULL,1,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(1462,7657,40760,25774,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2200.00,NULL,NULL,1,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(1463,7657,40760,25774,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2658.00,NULL,NULL,1,'2023-04-29 21:35:10','2023-04-29 21:35:10',NULL),(1464,7657,40760,25774,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',14194.40,NULL,NULL,1,'2023-04-29 21:41:34','2023-04-29 21:41:34',NULL),(1465,7657,40760,25774,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',38431.91,NULL,NULL,1,'2023-04-29 21:44:11','2023-04-29 21:44:11',NULL),(1466,7657,40760,25774,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',273193.95,NULL,NULL,1,'2023-04-29 21:49:13','2023-04-29 21:49:13',NULL),(1467,7657,40760,25774,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',10300.88,NULL,NULL,1,'2023-04-29 21:54:11','2023-04-29 21:54:11',NULL),(1468,7657,40760,25774,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',17447.58,NULL,NULL,1,'2023-04-29 21:57:21','2023-04-29 21:57:21',NULL);
INSERT INTO `balance_libro` VALUES (1469,7657,40760,25774,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',33722413.88,NULL,NULL,1,'2023-04-29 22:06:47','2023-04-29 22:06:47',NULL),(1470,7657,40760,25774,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',277571.20,NULL,NULL,1,'2023-04-29 22:10:12','2023-04-29 22:10:12',NULL),(1471,7657,40760,25774,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',15701.74,NULL,NULL,1,'2023-04-29 22:16:28','2023-04-29 22:16:28',NULL),(1472,7657,40760,25774,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',4500.00,NULL,NULL,1,'2023-04-29 22:21:52','2023-04-29 22:21:52',NULL),(1473,7657,40760,25774,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',479080.39,NULL,NULL,1,'2023-04-29 22:27:42','2023-04-29 22:27:42',NULL),(1474,7657,40760,25774,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',217047.60,NULL,NULL,1,'2023-04-29 22:37:38','2023-04-29 22:37:38',NULL),(1475,7657,40760,25774,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',178924.20,NULL,NULL,1,'2023-04-29 22:44:30','2023-04-29 22:44:30',NULL),(1476,7657,40760,25774,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',200970.00,NULL,NULL,1,'2023-04-29 22:47:24','2023-04-29 22:47:24',NULL),(1477,7657,40760,25774,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',193905.60,NULL,NULL,1,'2023-04-29 22:49:16','2023-04-29 22:49:16',NULL),(1478,7657,40760,25774,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',206085.60,NULL,NULL,1,'2023-04-29 22:52:36','2023-04-29 22:52:36',NULL),(1479,7657,40760,25774,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',192931.20,NULL,NULL,1,'2023-04-29 22:54:32','2023-04-29 22:54:32',NULL),(1480,7657,40760,25774,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',270747.18,NULL,NULL,1,'2023-04-29 23:02:28','2023-04-29 23:02:28',NULL),(1481,7657,40760,25774,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',210714.00,NULL,NULL,1,'2023-04-29 23:04:22','2023-04-29 23:04:22',NULL),(1482,7657,40760,25774,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',205842.00,NULL,NULL,1,'2023-04-29 23:06:21','2023-04-29 23:06:21',NULL),(1483,7657,40760,25774,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',213150.00,NULL,NULL,1,'2023-04-29 23:07:43','2023-04-29 23:07:43',NULL),(1484,7657,40760,25774,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',217291.20,NULL,NULL,1,'2023-04-29 23:10:11','2023-04-29 23:10:11',NULL),(1485,7657,40760,25774,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',245183.40,NULL,NULL,1,'2023-04-29 23:15:48','2023-04-29 23:15:48',NULL),(1486,7657,40760,25774,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.01,NULL,NULL,1,'2023-04-29 23:20:44','2023-04-29 23:20:44',NULL),(1487,7657,40760,25775,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',67800.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1488,7657,40760,25775,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',14500.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL);
INSERT INTO `balance_libro` VALUES (1489,7657,40760,25775,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1900.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1490,7657,40760,25775,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',11100.50,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1491,7657,40760,25775,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',174885.09,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 19:11:26','2023-05-08 19:11:26'),(1492,7657,40760,25775,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',4000.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 19:26:59','2023-05-08 19:26:59'),(1493,7657,40760,25775,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',31304430.72,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 19:31:12','2023-05-08 19:31:12'),(1494,7657,40760,25775,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4500.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1495,7657,40760,25775,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1600.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1496,7657,40760,25775,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',10989.99,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1497,7657,40760,25775,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',24200.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1498,7657,40760,25775,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1150.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1499,7657,40760,25775,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4000.01,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1500,7657,40760,25775,3,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3600.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1501,7657,40760,25775,3,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3000.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1502,7657,40760,25775,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',11799.40,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 19:35:08','2023-05-08 19:35:08'),(1503,7657,40760,25775,3,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',4800.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1504,7657,40760,25775,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3428.05,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 19:37:36','2023-05-08 19:37:36'),(1505,7657,40760,25775,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',22456.79,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 19:42:59','2023-05-08 19:42:59'),(1506,7657,40760,25775,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',398.91,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1507,7657,40760,25775,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10587.00,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(1508,7657,40760,25775,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',26619.59,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 19:45:02','2023-05-08 19:45:02');
INSERT INTO `balance_libro` VALUES (1509,7657,40760,25775,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',20801.90,NULL,NULL,1,'2023-05-08 18:54:34','2023-05-08 19:51:48','2023-05-08 19:51:48'),(1510,7657,40760,25775,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',32999.99,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1511,7657,40760,25775,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',270747.18,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 19:54:51','2023-05-08 19:54:51'),(1512,7657,40760,25775,3,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',53676.35,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 19:57:25','2023-05-08 19:57:25'),(1513,7657,40760,25775,3,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',17424.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1514,7657,40760,25775,3,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',14880.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1515,7657,40760,25775,3,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',7300.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1516,7657,40760,25775,3,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1500.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1517,7657,40760,25775,3,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8600.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1518,7657,40760,25775,3,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4600.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1519,7657,40760,25775,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1100.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1520,7657,40760,25775,3,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',17000.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1521,7657,40760,25775,3,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5500.01,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1522,7657,40760,25775,3,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',25900.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1523,7657,40760,25775,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4700.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1524,7657,40760,25775,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4900.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1525,7657,40760,25775,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',600.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1526,7657,40760,25775,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',24721.27,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 20:01:32','2023-05-08 20:01:32'),(1527,7657,40760,25775,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3300.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1528,7657,40760,25775,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',179981.81,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 20:04:01','2023-05-08 20:04:01');
INSERT INTO `balance_libro` VALUES (1529,7657,40760,25775,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',55477.01,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1530,7657,40760,25775,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4700.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1531,7657,40760,25775,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',13700.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1532,7657,40760,25775,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',45263.98,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1533,7657,40760,25775,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',58000.01,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1534,7657,40760,25775,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',28800.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1535,7657,40760,25775,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',12400.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1536,7657,40760,25775,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1000.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1537,7657,40760,25775,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5500.01,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1538,7657,40760,25775,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',40100.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1539,7657,40760,25775,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',12400.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1540,7657,40760,25775,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',11500.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1541,7657,40760,25775,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',26500.00,NULL,NULL,1,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(1542,7657,40760,25775,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',8700.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1543,7657,40760,25775,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1500.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1544,7657,40760,25775,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',11900.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1545,7657,40760,25775,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',6100.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1546,7657,40760,25775,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',12500.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1547,7657,40760,25775,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4000.01,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1548,7657,40760,25775,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1000.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1549,7657,40760,25775,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5400.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL);
INSERT INTO `balance_libro` VALUES (1550,7657,40760,25775,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4000.01,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1551,7657,40760,25775,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',3700.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1552,7657,40760,25775,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5200.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1553,7657,40760,25775,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',6000.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1554,7657,40760,25775,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',17400.01,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1555,7657,40760,25775,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4500.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1556,7657,40760,25775,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2500.01,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1557,7657,40760,25775,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4000.01,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1558,7657,40760,25775,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',10500.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1559,7657,40760,25775,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',3100.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1560,7657,40760,25775,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',6500.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1561,7657,40760,25775,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',24300.01,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1562,7657,40760,25775,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5900.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1563,7657,40760,25775,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',6500.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1564,7657,40760,25775,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',900.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1565,7657,40760,25775,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',600.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1566,7657,40760,25775,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2700.01,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1567,7657,40760,25775,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2500.01,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1568,7657,40760,25775,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1500.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1569,7657,40760,25775,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',3500.00,NULL,NULL,1,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(1570,7657,40760,25775,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',54000.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL);
INSERT INTO `balance_libro` VALUES (1571,7657,40760,25775,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',6500.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1572,7657,40760,25775,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',3700.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1573,7657,40760,25775,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5400.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1574,7657,40760,25775,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',3500.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1575,7657,40760,25775,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',42800.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1576,7657,40760,25775,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',12700.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1577,7657,40760,25775,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',3000.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1578,7657,40760,25775,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',11100.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1579,7657,40760,25775,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',6600.01,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1580,7657,40760,25775,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',3500.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1581,7657,40760,25775,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1600.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1582,7657,40760,25775,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1300.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1583,7657,40760,25775,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',145095.70,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 20:07:10','2023-05-08 20:07:10'),(1584,7657,40760,25775,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',17900.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1585,7657,40760,25775,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',11300.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1586,7657,40760,25775,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6300.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1587,7657,40760,25775,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2000.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1588,7657,40760,25775,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',10100.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1589,7657,40760,25775,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',17700.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1590,7657,40760,25775,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',14600.01,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL);
INSERT INTO `balance_libro` VALUES (1591,7657,40760,25775,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2600.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1592,7657,40760,25775,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6000.00,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1593,7657,40760,25775,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',45900.17,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 20:11:43','2023-05-08 20:11:43'),(1594,7657,40760,25775,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',128697.51,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 20:14:11','2023-05-08 20:14:11'),(1595,7657,40760,25775,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',43956.19,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1596,7657,40760,25775,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',40500.01,NULL,NULL,1,'2023-05-08 18:54:37','2023-05-08 18:54:37',NULL),(1597,7657,40760,25775,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4500.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1598,7657,40760,25775,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',400.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1599,7657,40760,25775,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',11300.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1600,7657,40760,25775,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',500.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1601,7657,40760,25775,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',16000.10,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:21:38','2023-05-08 20:21:38'),(1602,7657,40760,25775,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',16400.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1603,7657,40760,25775,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',12800.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1604,7657,40760,25775,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',3800.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1605,7657,40760,25775,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',3500.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1606,7657,40760,25775,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',4900.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1607,7657,40760,25775,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',5000.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1608,7657,40760,25775,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',13600.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1609,7657,40760,25775,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2699.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1610,7657,40760,25775,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',119109.16,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:23:31','2023-05-08 20:23:31');
INSERT INTO `balance_libro` VALUES (1611,7657,40760,25775,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',31501.30,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:26:45','2023-05-08 20:26:45'),(1612,7657,40760,25775,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',4500.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1613,7657,40760,25775,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',7200.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1614,7657,40760,25775,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',20000.01,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1615,7657,40760,25775,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',3800.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1616,7657,40760,25775,3,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',7700.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1617,7657,40760,25775,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1000.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1618,7657,40760,25775,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',8247.08,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1619,7657,40760,25775,3,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',43956.19,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1620,7657,40760,25775,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',207547.20,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:31:05','2023-05-08 20:31:05'),(1621,7657,40760,25775,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',249690.00,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:36:39','2023-05-08 20:36:39'),(1622,7657,40760,25775,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5499.99,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:42:25','2023-05-08 20:42:25'),(1623,7657,40760,25775,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',270747.18,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:44:40','2023-05-08 20:44:40'),(1624,7657,40760,25775,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2790.44,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:46:04','2023-05-08 20:46:04'),(1625,7657,40760,25775,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',43956.19,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 18:54:38',NULL),(1626,7657,40760,25775,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',268690.80,NULL,NULL,1,'2023-05-08 18:54:38','2023-05-08 20:47:33','2023-05-08 20:47:33'),(1627,7657,40760,25775,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',214368.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 20:51:59','2023-05-08 20:51:59'),(1628,7657,40760,25775,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',39875.29,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1629,7657,40760,25775,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',43956.19,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1630,7657,40760,25775,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',40974.20,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 20:54:12','2023-05-08 20:54:12');
INSERT INTO `balance_libro` VALUES (1631,7657,40760,25775,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',259434.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 20:55:41','2023-05-08 20:55:41'),(1632,7657,40760,25775,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',92178.76,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 21:00:26','2023-05-08 21:00:26'),(1633,7657,40760,25775,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3100.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1634,7657,40760,25775,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',7400.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1635,7657,40760,25775,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',13300.01,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1636,7657,40760,25775,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4400.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1637,7657,40760,25775,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4500.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1638,7657,40760,25775,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1400.01,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1639,7657,40760,25775,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2000.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1640,7657,40760,25775,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3500.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1641,7657,40760,25775,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4100.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1642,7657,40760,25775,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1099.91,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1643,7657,40760,25775,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',43956.19,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 21:08:08','2023-05-08 21:08:08'),(1644,7657,40760,25775,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',245548.80,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 21:09:37','2023-05-08 21:09:37'),(1645,7657,40760,25775,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',213880.80,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 21:10:45','2023-05-08 21:10:45'),(1646,7657,40760,25775,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',218509.20,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 21:11:52','2023-05-08 21:11:52'),(1647,7657,40760,25775,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',222285.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 21:13:35','2023-05-08 21:13:35'),(1648,7657,40760,25775,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',248228.40,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 21:15:24','2023-05-08 21:15:24'),(1649,7657,40760,25775,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',16083.99,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1650,7657,40760,25775,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',17424.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL);
INSERT INTO `balance_libro` VALUES (1651,7657,40760,25775,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',11400.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1652,7657,40760,25775,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4000.01,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1653,7657,40760,25775,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1800.00,NULL,NULL,1,'2023-05-08 18:54:39','2023-05-08 18:54:39',NULL),(1654,7657,40760,25775,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5800.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1655,7657,40760,25775,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1700.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1656,7657,40760,25775,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3500.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1657,7657,40760,25775,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5400.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1658,7657,40760,25775,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3500.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1659,7657,40760,25775,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3500.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1660,7657,40760,25775,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8100.01,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1661,7657,40760,25775,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6500.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1662,7657,40760,25775,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',7500.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1663,7657,40760,25775,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4200.01,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1664,7657,40760,25775,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5000.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1665,7657,40760,25775,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4500.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1666,7657,40760,25775,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3500.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1667,7657,40760,25775,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1600.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1668,7657,40760,25775,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3700.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1669,7657,40760,25775,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',237266.40,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 21:18:44','2023-05-08 21:18:44'),(1670,7657,40760,25775,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',247497.60,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 21:19:59','2023-05-08 21:19:59');
INSERT INTO `balance_libro` VALUES (1671,7657,40760,25775,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',228740.40,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 21:21:24','2023-05-08 21:21:24'),(1672,7657,40760,25775,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',221067.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 21:22:29','2023-05-08 21:22:29'),(1673,7657,40760,25775,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',800.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1674,7657,40760,25775,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3500.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1675,7657,40760,25775,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10600.00,NULL,NULL,1,'2023-05-08 18:54:40','2023-05-08 18:54:40',NULL),(1676,7657,40760,25775,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',174885.09,NULL,NULL,1,'2023-05-08 19:11:26','2023-05-08 19:11:26',NULL),(1677,7657,40760,25775,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3999.99,NULL,NULL,1,'2023-05-08 19:26:59','2023-05-08 19:26:59',NULL),(1678,7657,40760,25775,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',31304430.72,NULL,NULL,1,'2023-05-08 19:31:12','2023-05-08 19:31:12',NULL),(1679,7657,40760,25775,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',11799.39,NULL,NULL,1,'2023-05-08 19:35:08','2023-05-08 19:35:08',NULL),(1680,7657,40760,25775,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3428.05,NULL,NULL,1,'2023-05-08 19:37:36','2023-05-08 19:37:36',NULL),(1681,7657,40760,25775,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',22456.79,NULL,NULL,1,'2023-05-08 19:42:59','2023-05-08 19:42:59',NULL),(1682,7657,40760,25775,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',26619.59,NULL,NULL,1,'2023-05-08 19:45:02','2023-05-08 19:45:53','2023-05-08 19:45:53'),(1683,7657,40760,25775,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',26619.59,NULL,NULL,1,'2023-05-08 19:45:53','2023-05-08 19:45:53',NULL),(1684,7657,40760,25775,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',20801.89,NULL,NULL,1,'2023-05-08 19:51:48','2023-05-08 19:51:48',NULL),(1685,7657,40760,25775,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',270747.18,NULL,NULL,1,'2023-05-08 19:54:51','2023-05-08 19:54:51',NULL),(1686,7657,40760,25775,3,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',53676.35,NULL,NULL,1,'2023-05-08 19:57:25','2023-05-08 19:57:25',NULL),(1687,7657,40760,25775,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',24721.26,NULL,NULL,1,'2023-05-08 20:01:32','2023-05-08 20:01:32',NULL),(1688,7657,40760,25775,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',179981.81,NULL,NULL,1,'2023-05-08 20:04:01','2023-05-08 20:04:01',NULL),(1689,7657,40760,25775,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',145095.70,NULL,NULL,1,'2023-05-08 20:07:10','2023-05-08 20:07:10',NULL),(1690,7657,40760,25775,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',45900.18,NULL,NULL,1,'2023-05-08 20:11:43','2023-05-08 20:11:43',NULL);
INSERT INTO `balance_libro` VALUES (1691,7657,40760,25775,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',128697.51,NULL,NULL,1,'2023-05-08 20:14:11','2023-05-08 20:14:11',NULL),(1692,7657,40760,25775,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',16000.10,NULL,NULL,1,'2023-05-08 20:21:38','2023-05-08 20:21:38',NULL),(1693,7657,40760,25775,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',119109.16,NULL,NULL,1,'2023-05-08 20:23:31','2023-05-08 20:23:31',NULL),(1694,7657,40760,25775,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',31501.30,NULL,NULL,1,'2023-05-08 20:26:45','2023-05-08 20:26:45',NULL),(1695,7657,40760,25775,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',207547.20,NULL,NULL,1,'2023-05-08 20:31:05','2023-05-08 20:37:10','2023-05-08 20:37:10'),(1696,7657,40760,25775,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',249690.00,NULL,NULL,1,'2023-05-08 20:36:39','2023-05-08 20:38:48','2023-05-08 20:38:48'),(1697,7657,40760,25775,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',207547.20,NULL,NULL,1,'2023-05-08 20:37:10','2023-05-08 20:37:10',NULL),(1698,7657,40760,25775,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',249690.00,NULL,NULL,1,'2023-05-08 20:38:48','2023-05-08 20:38:48',NULL),(1699,7657,40760,25775,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5499.99,NULL,NULL,1,'2023-05-08 20:42:25','2023-05-08 20:42:25',NULL),(1700,7657,40760,25775,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',270747.18,NULL,NULL,1,'2023-05-08 20:44:40','2023-05-08 20:44:40',NULL),(1701,7657,40760,25775,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2790.44,NULL,NULL,1,'2023-05-08 20:46:04','2023-05-08 20:46:04',NULL),(1702,7657,40760,25775,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',268690.80,NULL,NULL,1,'2023-05-08 20:47:33','2023-05-08 20:50:27','2023-05-08 20:50:27'),(1703,7657,40760,25775,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',268690.80,NULL,NULL,1,'2023-05-08 20:50:27','2023-05-08 20:50:27',NULL),(1704,7657,40760,25775,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',214368.00,NULL,NULL,1,'2023-05-08 20:51:59','2023-05-08 20:51:59',NULL),(1705,7657,40760,25775,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',41270.53,NULL,NULL,1,'2023-05-08 20:54:12','2023-05-08 20:54:12',NULL),(1706,7657,40760,25775,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',259434.00,NULL,NULL,1,'2023-05-08 20:55:41','2023-05-08 20:58:54','2023-05-08 20:58:54'),(1707,7657,40760,25775,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',259434.00,NULL,NULL,1,'2023-05-08 20:58:54','2023-05-08 20:58:54',NULL),(1708,7657,40760,25775,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',92178.76,NULL,NULL,1,'2023-05-08 21:00:26','2023-05-08 21:00:26',NULL),(1709,7657,40760,25775,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',44253.28,NULL,NULL,1,'2023-05-08 21:08:08','2023-05-08 21:08:08',NULL),(1710,7657,40760,25775,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',245548.80,NULL,NULL,1,'2023-05-08 21:09:37','2023-05-08 21:09:37',NULL);
INSERT INTO `balance_libro` VALUES (1711,7657,40760,25775,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',213880.80,NULL,NULL,1,'2023-05-08 21:10:45','2023-05-08 21:10:45',NULL),(1712,7657,40760,25775,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',218509.20,NULL,NULL,1,'2023-05-08 21:11:52','2023-05-08 21:11:52',NULL),(1713,7657,40760,25775,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',222285.00,NULL,NULL,1,'2023-05-08 21:13:35','2023-05-08 21:13:35',NULL),(1714,7657,40760,25775,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',248228.40,NULL,NULL,1,'2023-05-08 21:15:24','2023-05-08 21:15:24',NULL),(1715,7657,40760,25775,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',237266.40,NULL,NULL,1,'2023-05-08 21:18:44','2023-05-08 21:18:44',NULL),(1716,7657,40760,25775,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',247497.60,NULL,NULL,1,'2023-05-08 21:19:59','2023-05-08 21:19:59',NULL),(1717,7657,40760,25775,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',228740.40,NULL,NULL,1,'2023-05-08 21:21:24','2023-05-08 21:21:24',NULL),(1718,7657,40760,25775,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',221067.00,NULL,NULL,1,'2023-05-08 21:22:29','2023-05-08 21:22:29',NULL),(1719,7657,40897,69486,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',38405.00,NULL,NULL,1,'2023-11-20 20:40:43','2023-11-20 20:40:43',NULL),(1720,7657,40897,69486,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',35000.00,NULL,NULL,1,'2023-11-20 20:40:43','2023-11-20 20:40:43',NULL),(1721,7657,40897,69486,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',17175.00,NULL,NULL,1,'2023-11-20 20:40:43','2023-11-20 20:40:43',NULL),(1722,7657,40897,69486,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',18405.00,NULL,NULL,1,'2023-11-20 20:40:43','2023-11-20 20:40:43',NULL),(1723,7657,40897,69486,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',13260.00,NULL,NULL,1,'2023-11-20 20:40:43','2023-11-20 20:40:43',NULL),(1724,7657,40897,69486,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',500000.00,NULL,NULL,1,'2023-11-20 20:40:43','2023-11-20 20:40:43',NULL),(1725,7657,40897,69486,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',24503.00,NULL,NULL,1,'2023-11-20 20:40:43','2023-11-20 20:40:43',NULL),(1726,7657,40897,69486,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',26750.00,NULL,NULL,1,'2023-11-20 20:40:43','2023-11-20 20:40:43',NULL),(1727,7657,40897,69486,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',30900.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1728,7657,40897,69486,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',35401.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1729,7657,40897,69486,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',200000.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1730,7657,40897,69486,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',21700.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL);
INSERT INTO `balance_libro` VALUES (1731,7657,40897,69486,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-15','2023-10-15',27390.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1732,7657,40897,69486,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-15','2023-10-15',9365.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1733,7657,40897,69486,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-15','2023-10-15',22603.65,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1734,7657,40897,69486,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',17518.87,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1735,7657,40897,69486,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',35000.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1736,7657,40897,69486,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',500000.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1737,7657,40897,69486,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',200000.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1738,7657,40897,69486,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',200000.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1739,7657,40897,69486,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',27360.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1740,7657,40897,69486,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',12401.50,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1741,7657,40897,69486,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',24750.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1742,7657,40897,69486,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',27503.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1743,7657,40897,69486,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',12304.00,NULL,NULL,1,'2023-11-20 20:40:44','2023-11-20 20:40:44',NULL),(1744,7657,40897,69486,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',18704.65,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL),(1745,7657,40897,69486,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-22','2023-10-22',62000.00,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL),(1746,7657,40897,69486,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-22','2023-10-22',21405.00,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL),(1747,7657,40897,69486,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-22','2023-10-22',24637.00,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL),(1748,7657,40897,69486,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',18650.00,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL),(1749,7657,40897,69486,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',27607.56,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL),(1750,7657,40897,69486,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',31203.00,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL),(1751,7657,40897,69486,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',12705.56,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL);
INSERT INTO `balance_libro` VALUES (1752,7657,40897,69486,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',25608.00,NULL,NULL,1,'2023-11-20 20:40:45','2023-11-20 20:40:45',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5592 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7657,1,40720,1524,3,217,1,1983.47,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(2,7657,1,40720,1524,3,68,1,416.53,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(3,7657,1,40720,1524,3,57,2,2400.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(4,7657,2,40720,1524,3,217,1,1487.60,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(5,7657,2,40720,1524,3,68,1,312.40,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(6,7657,2,40720,1524,3,57,2,1800.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(7,7657,3,40720,1524,3,217,1,7107.44,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(8,7657,3,40720,1524,3,68,1,1492.56,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(9,7657,3,40720,1524,3,57,2,8600.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(10,7657,4,40720,1524,3,217,1,4214.88,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(11,7657,4,40720,1524,3,68,1,885.12,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(12,7657,4,40720,1524,3,57,2,5100.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(13,7657,5,40720,1524,3,217,1,3140.50,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(14,7657,5,40720,1524,3,68,1,659.50,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(15,7657,5,40720,1524,3,57,2,3800.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(16,7657,6,40720,1524,3,217,1,547.56,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(17,7657,6,40720,1524,3,68,1,130.02,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(18,7657,6,40720,1524,3,217,1,13.19,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(19,7657,6,40720,1524,3,57,2,690.77,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(20,7657,7,40720,1524,3,250,1,2500.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(21,7657,7,40720,1524,3,57,2,2500.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(22,7657,8,40720,1524,3,217,1,537.19,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(23,7657,8,40720,1524,3,68,1,112.81,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(24,7657,8,40720,1524,3,57,2,650.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(25,7657,9,40720,1524,3,217,1,1983.47,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(26,7657,9,40720,1524,3,68,1,416.53,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(27,7657,9,40720,1524,3,57,2,2400.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(28,7657,10,40720,1524,3,217,1,1157.03,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(29,7657,10,40720,1524,3,68,1,242.98,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(30,7657,10,40720,1524,3,57,2,1400.01,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(31,7657,11,40720,1524,3,217,1,8677.69,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(32,7657,11,40720,1524,3,68,1,1822.31,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(33,7657,11,40720,1524,3,57,2,10500.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(34,7657,12,40720,1524,3,217,1,8264.46,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(35,7657,12,40720,1524,3,68,1,1735.54,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(36,7657,12,40720,1524,3,57,2,10000.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(37,7657,13,40720,1524,3,217,1,3223.14,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(38,7657,13,40720,1524,3,68,1,676.86,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(39,7657,13,40720,1524,3,57,2,3900.00,NULL,'2022-08-23 10:34:07','2022-08-23 10:34:07',NULL),(40,7657,14,40720,1524,3,217,1,5123.97,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(41,7657,14,40720,1524,3,68,1,1076.03,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(42,7657,14,40720,1524,3,57,2,6200.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(43,7657,15,40720,1524,3,217,1,4710.74,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL);
INSERT INTO `balance_libro_details` VALUES (44,7657,15,40720,1524,3,68,1,989.26,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(45,7657,15,40720,1524,3,57,2,5700.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(46,7657,16,40720,1524,3,217,1,3884.30,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(47,7657,16,40720,1524,3,68,1,815.70,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(48,7657,16,40720,1524,3,57,2,4700.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(49,7657,17,40720,1524,3,217,1,20661.16,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(50,7657,17,40720,1524,3,68,1,4338.84,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(51,7657,17,40720,1524,3,57,2,25000.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(52,7657,18,40720,1524,3,217,1,11239.67,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(53,7657,18,40720,1524,3,68,1,2360.33,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(54,7657,18,40720,1524,3,57,2,13600.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(55,7657,19,40720,1524,3,217,1,4132.23,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(56,7657,19,40720,1524,3,68,1,867.77,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(57,7657,19,40720,1524,3,57,2,5000.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(58,7657,20,40720,1524,3,217,1,1404.96,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(59,7657,20,40720,1524,3,68,1,295.04,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(60,7657,20,40720,1524,3,57,2,1700.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(61,7657,21,40720,1524,3,217,1,15702.48,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(62,7657,21,40720,1524,3,68,1,3297.52,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(63,7657,21,40720,1524,3,57,2,19000.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(64,7657,22,40720,1524,3,217,1,6528.93,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(65,7657,22,40720,1524,3,68,1,1371.08,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(66,7657,22,40720,1524,3,57,2,7900.01,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(67,7657,23,40720,1524,3,217,1,8429.75,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(68,7657,23,40720,1524,3,68,1,1770.25,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(69,7657,23,40720,1524,3,57,2,10200.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(70,7657,24,40720,1524,3,217,1,7603.31,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(71,7657,24,40720,1524,3,68,1,1596.70,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(72,7657,24,40720,1524,3,57,2,9200.01,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(73,7657,25,40720,1524,3,217,1,2644.63,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(74,7657,25,40720,1524,3,68,1,555.37,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(75,7657,25,40720,1524,3,57,2,3200.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(76,7657,26,40720,1524,3,217,1,1900.83,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(77,7657,26,40720,1524,3,68,1,399.17,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(78,7657,26,40720,1524,3,57,2,2300.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(79,7657,27,40720,1524,3,217,1,19317.62,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(80,7657,27,40720,1524,3,68,1,4056.70,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(81,7657,27,40720,1524,3,57,2,23374.32,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(82,7657,28,40720,1524,3,217,1,1661.16,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(83,7657,28,40720,1524,3,68,1,348.84,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(84,7657,28,40720,1524,3,57,2,2010.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(85,7657,29,40720,1524,3,217,1,1404.96,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL);
INSERT INTO `balance_libro_details` VALUES (86,7657,29,40720,1524,3,68,1,295.04,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(87,7657,29,40720,1524,3,57,2,1700.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(88,7657,30,40720,1524,3,217,1,1900.83,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(89,7657,30,40720,1524,3,68,1,399.17,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(90,7657,30,40720,1524,3,57,2,2300.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(91,7657,31,40720,1524,3,217,1,5785.12,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(92,7657,31,40720,1524,3,68,1,1214.88,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(93,7657,31,40720,1524,3,57,2,7000.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(94,7657,32,40720,1524,3,217,1,13491.77,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(95,7657,32,40720,1524,3,68,1,1416.64,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(96,7657,32,40720,1524,3,57,2,14908.41,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(97,7657,33,40720,1524,3,217,1,4380.17,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(98,7657,33,40720,1524,3,68,1,919.84,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(99,7657,33,40720,1524,3,57,2,5300.01,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(100,7657,34,40720,1524,3,217,1,6611.57,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(101,7657,34,40720,1524,3,68,1,1388.43,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(102,7657,34,40720,1524,3,57,2,8000.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(103,7657,35,40720,1524,3,217,1,661.16,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(104,7657,35,40720,1524,3,68,1,138.84,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(105,7657,35,40720,1524,3,57,2,800.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(106,7657,36,40720,1524,3,217,1,661.16,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(107,7657,36,40720,1524,3,68,1,138.84,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(108,7657,36,40720,1524,3,57,2,800.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(109,7657,37,40720,1524,3,217,1,991.74,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(110,7657,37,40720,1524,3,68,1,208.27,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(111,7657,37,40720,1524,3,57,2,1200.01,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(112,7657,38,40720,1524,3,217,1,12272.73,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(113,7657,38,40720,1524,3,68,1,2577.27,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(114,7657,38,40720,1524,3,57,2,14850.00,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(115,7657,39,40720,1524,3,217,1,2231.41,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(116,7657,39,40720,1524,3,68,1,468.60,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(117,7657,39,40720,1524,3,57,2,2700.01,NULL,'2022-08-23 10:34:08','2022-08-23 10:34:08',NULL),(118,7657,40,40720,1524,3,217,1,6611.57,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(119,7657,40,40720,1524,3,68,1,1388.43,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(120,7657,40,40720,1524,3,57,2,8000.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(121,7657,41,40720,1524,3,217,1,1570.25,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(122,7657,41,40720,1524,3,68,1,329.75,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(123,7657,41,40720,1524,3,57,2,1900.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(124,7657,42,40720,1524,3,217,1,1322.31,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(125,7657,42,40720,1524,3,68,1,277.69,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(126,7657,42,40720,1524,3,57,2,1600.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(127,7657,43,40720,1524,3,217,1,3719.01,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL);
INSERT INTO `balance_libro_details` VALUES (128,7657,43,40720,1524,3,68,1,780.99,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(129,7657,43,40720,1524,3,57,2,4500.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(130,7657,44,40720,1524,3,217,1,2479.34,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(131,7657,44,40720,1524,3,68,1,520.66,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(132,7657,44,40720,1524,3,57,2,3000.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(133,7657,45,40720,1524,3,217,1,537.19,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(134,7657,45,40720,1524,3,68,1,112.81,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(135,7657,45,40720,1524,3,57,2,650.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(136,7657,46,40720,1524,3,217,1,2545.45,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(137,7657,46,40720,1524,3,68,1,534.55,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(138,7657,46,40720,1524,3,57,2,3080.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(139,7657,47,40720,1524,3,217,1,6528.93,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(140,7657,47,40720,1524,3,68,1,1371.07,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(141,7657,47,40720,1524,3,57,2,7900.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(142,7657,48,40720,1524,3,217,1,537.19,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(143,7657,48,40720,1524,3,68,1,112.81,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(144,7657,48,40720,1524,3,57,2,650.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(145,7657,49,40720,1524,3,217,1,743.80,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(146,7657,49,40720,1524,3,68,1,156.20,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(147,7657,49,40720,1524,3,57,2,900.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(148,7657,50,40720,1524,3,217,1,1404.96,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(149,7657,50,40720,1524,3,68,1,295.04,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(150,7657,50,40720,1524,3,57,2,1700.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(151,7657,51,40720,1524,3,217,1,9421.49,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(152,7657,51,40720,1524,3,68,1,1978.51,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(153,7657,51,40720,1524,3,57,2,11400.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(154,7657,52,40720,1524,3,217,1,4297.52,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(155,7657,52,40720,1524,3,68,1,902.48,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(156,7657,52,40720,1524,3,57,2,5200.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(157,7657,53,40720,1524,3,217,1,7355.37,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(158,7657,53,40720,1524,3,68,1,1544.63,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(159,7657,53,40720,1524,3,57,2,8900.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(160,7657,54,40720,1524,3,250,1,2000.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(161,7657,54,40720,1524,3,57,2,2000.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(162,7657,55,40720,1524,3,217,1,2231.40,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(163,7657,55,40720,1524,3,68,1,468.60,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(164,7657,55,40720,1524,3,57,2,2700.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(165,7657,56,40720,1524,3,217,1,2396.70,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(166,7657,56,40720,1524,3,68,1,503.31,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(167,7657,56,40720,1524,3,57,2,2900.01,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(168,7657,57,40720,1524,3,217,1,47685.95,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(169,7657,57,40720,1524,3,68,1,10014.05,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL);
INSERT INTO `balance_libro_details` VALUES (170,7657,57,40720,1524,3,57,2,57700.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(171,7657,58,40720,1524,3,217,1,1983.47,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(172,7657,58,40720,1524,3,68,1,416.53,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(173,7657,58,40720,1524,3,57,2,2400.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(174,7657,59,40720,1524,3,217,1,15272.73,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(175,7657,59,40720,1524,3,68,1,3207.27,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(176,7657,59,40720,1524,3,57,2,18480.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(177,7657,60,40720,1524,3,217,1,1487.60,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(178,7657,60,40720,1524,3,68,1,312.40,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(179,7657,60,40720,1524,3,57,2,1800.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(180,7657,61,40720,1524,3,217,1,1652.89,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(181,7657,61,40720,1524,3,68,1,347.11,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(182,7657,61,40720,1524,3,57,2,2000.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(183,7657,62,40720,1524,3,217,1,0.01,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(184,7657,62,40720,1524,3,68,1,0.01,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(185,7657,62,40720,1524,3,217,1,-0.01,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(186,7657,62,40720,1524,3,57,2,0.01,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(187,7657,63,40720,1524,3,217,1,15021.74,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(188,7657,63,40720,1524,3,68,1,1577.28,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(189,7657,63,40720,1524,3,57,2,16599.02,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(190,7657,64,40720,1524,3,217,1,2975.21,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(191,7657,64,40720,1524,3,68,1,624.79,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(192,7657,64,40720,1524,3,57,2,3600.00,NULL,'2022-08-23 10:34:09','2022-08-23 10:34:09',NULL),(193,7657,65,40720,1524,3,217,1,743.80,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(194,7657,65,40720,1524,3,68,1,156.20,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(195,7657,65,40720,1524,3,57,2,900.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(196,7657,66,40720,1524,3,217,1,2975.21,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(197,7657,66,40720,1524,3,68,1,624.79,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(198,7657,66,40720,1524,3,57,2,3600.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(199,7657,67,40720,1524,3,217,1,36611.57,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(200,7657,67,40720,1524,3,68,1,7688.43,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(201,7657,67,40720,1524,3,57,2,44300.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(202,7657,68,40720,1524,3,217,1,1239.67,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(203,7657,68,40720,1524,3,68,1,260.33,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(204,7657,68,40720,1524,3,57,2,1500.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(205,7657,69,40720,1524,3,217,1,1818.18,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(206,7657,69,40720,1524,3,68,1,381.82,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(207,7657,69,40720,1524,3,57,2,2200.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(208,7657,70,40720,1524,3,217,1,3305.79,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(209,7657,70,40720,1524,3,68,1,694.22,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(210,7657,70,40720,1524,3,57,2,4000.01,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(211,7657,71,40720,1524,3,217,1,3553.72,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL);
INSERT INTO `balance_libro_details` VALUES (212,7657,71,40720,1524,3,68,1,746.28,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(213,7657,71,40720,1524,3,57,2,4300.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(214,7657,72,40720,1524,3,217,1,18801.65,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(215,7657,72,40720,1524,3,68,1,3948.35,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(216,7657,72,40720,1524,3,57,2,22750.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(217,7657,73,40720,1524,3,217,1,25706.67,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(218,7657,73,40720,1524,3,68,1,5398.40,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(219,7657,73,40720,1524,3,217,1,205.65,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(220,7657,73,40720,1524,3,57,2,31310.72,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(221,7657,74,40720,1524,3,217,1,21601.55,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(222,7657,74,40720,1524,3,68,1,4536.32,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(223,7657,74,40720,1524,3,57,2,26137.87,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(224,7657,75,40720,1524,3,217,1,7190.08,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(225,7657,75,40720,1524,3,68,1,1509.92,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(226,7657,75,40720,1524,3,57,2,8700.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(227,7657,76,40720,1524,3,217,1,6363.64,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(228,7657,76,40720,1524,3,68,1,1336.36,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(229,7657,76,40720,1524,3,57,2,7700.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(230,7657,77,40720,1524,3,217,1,3719.01,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(231,7657,77,40720,1524,3,68,1,780.99,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(232,7657,77,40720,1524,3,57,2,4500.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(233,7657,78,40720,1524,3,217,1,2892.56,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(234,7657,78,40720,1524,3,68,1,607.44,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(235,7657,78,40720,1524,3,57,2,3500.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(236,7657,79,40720,1524,3,250,1,8000.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(237,7657,79,40720,1524,3,57,2,8000.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(238,7657,80,40720,1524,3,217,1,1570.25,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(239,7657,80,40720,1524,3,68,1,329.75,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(240,7657,80,40720,1524,3,57,2,1900.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(241,7657,81,40720,1524,3,217,1,6033.06,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(242,7657,81,40720,1524,3,68,1,1266.94,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(243,7657,81,40720,1524,3,57,2,7300.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(244,7657,82,40720,1524,3,217,1,8388.43,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(245,7657,82,40720,1524,3,68,1,1761.57,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(246,7657,82,40720,1524,3,57,2,10150.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(247,7657,83,40720,1524,3,217,1,2975.21,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(248,7657,83,40720,1524,3,68,1,624.79,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(249,7657,83,40720,1524,3,57,2,3600.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(250,7657,84,40720,1524,3,217,1,1157.03,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(251,7657,84,40720,1524,3,68,1,242.98,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(252,7657,84,40720,1524,3,57,2,1400.01,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(253,7657,85,40720,1524,3,217,1,20826.45,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL);
INSERT INTO `balance_libro_details` VALUES (254,7657,85,40720,1524,3,68,1,4373.55,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(255,7657,85,40720,1524,3,57,2,25200.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(256,7657,86,40720,1524,3,217,1,19173.55,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(257,7657,86,40720,1524,3,68,1,4026.45,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(258,7657,86,40720,1524,3,57,2,23200.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(259,7657,87,40720,1524,3,217,1,13553.72,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(260,7657,87,40720,1524,3,68,1,2846.28,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(261,7657,87,40720,1524,3,57,2,16400.00,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(262,7657,88,40720,1524,3,217,1,1157.03,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(263,7657,88,40720,1524,3,68,1,242.98,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(264,7657,88,40720,1524,3,57,2,1400.01,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(265,7657,89,40720,1524,3,217,1,2231.41,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(266,7657,89,40720,1524,3,68,1,468.60,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(267,7657,89,40720,1524,3,57,2,2700.01,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(268,7657,90,40720,1524,3,217,1,9161.83,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(269,7657,90,40720,1524,3,68,1,1923.98,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(270,7657,90,40720,1524,3,217,1,73.29,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(271,7657,90,40720,1524,3,57,2,11159.10,NULL,'2022-08-23 10:34:10','2022-08-23 10:34:10',NULL),(272,7657,91,40720,1524,3,217,1,3264.46,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(273,7657,91,40720,1524,3,68,1,685.54,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(274,7657,91,40720,1524,3,57,2,3950.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(275,7657,92,40720,1524,3,217,1,2231.41,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(276,7657,92,40720,1524,3,68,1,468.60,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(277,7657,92,40720,1524,3,57,2,2700.01,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(278,7657,93,40720,1524,3,217,1,3140.50,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(279,7657,93,40720,1524,3,68,1,659.50,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(280,7657,93,40720,1524,3,57,2,3800.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(281,7657,94,40720,1524,3,217,1,2809.92,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(282,7657,94,40720,1524,3,68,1,590.08,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(283,7657,94,40720,1524,3,57,2,3400.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(284,7657,95,40720,1524,3,217,1,2479.34,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(285,7657,95,40720,1524,3,68,1,520.66,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(286,7657,95,40720,1524,3,57,2,3000.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(287,7657,96,40720,1524,3,217,1,7851.24,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(288,7657,96,40720,1524,3,68,1,1648.76,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(289,7657,96,40720,1524,3,57,2,9500.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(290,7657,97,40720,1524,3,217,1,3388.43,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(291,7657,97,40720,1524,3,68,1,711.57,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(292,7657,97,40720,1524,3,57,2,4100.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(293,7657,98,40720,1524,3,217,1,6694.22,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(294,7657,98,40720,1524,3,68,1,1405.79,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(295,7657,98,40720,1524,3,57,2,8100.01,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL);
INSERT INTO `balance_libro_details` VALUES (296,7657,99,40720,1524,3,217,1,1363.64,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(297,7657,99,40720,1524,3,68,1,286.36,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(298,7657,99,40720,1524,3,57,2,1650.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(299,7657,100,40720,1524,3,217,1,1487.60,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(300,7657,100,40720,1524,3,68,1,312.40,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(301,7657,100,40720,1524,3,57,2,1800.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(302,7657,101,40720,1524,3,217,2,6368.54,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(303,7657,101,40720,1524,3,67,2,1337.39,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(304,7657,101,40720,1524,3,217,2,50.95,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(305,7657,101,40720,1524,3,57,1,7756.88,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(306,7657,102,40720,1524,3,217,1,4958.68,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(307,7657,102,40720,1524,3,68,1,1041.32,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(308,7657,102,40720,1524,3,57,2,6000.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(309,7657,103,40720,1524,3,217,1,2727.27,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(310,7657,103,40720,1524,3,68,1,572.73,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(311,7657,103,40720,1524,3,57,2,3300.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(312,7657,104,40720,1524,3,217,1,2892.56,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(313,7657,104,40720,1524,3,68,1,607.44,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(314,7657,104,40720,1524,3,57,2,3500.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(315,7657,105,40720,1524,3,217,1,826.45,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(316,7657,105,40720,1524,3,68,1,173.55,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(317,7657,105,40720,1524,3,57,2,1000.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(318,7657,106,40720,1524,3,217,1,702.48,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(319,7657,106,40720,1524,3,68,1,147.52,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(320,7657,106,40720,1524,3,57,2,850.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(321,7657,107,40720,1524,3,217,1,2975.21,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(322,7657,107,40720,1524,3,68,1,624.79,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(323,7657,107,40720,1524,3,57,2,3600.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(324,7657,108,40720,1524,3,217,1,909.09,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(325,7657,108,40720,1524,3,68,1,190.91,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(326,7657,108,40720,1524,3,57,2,1100.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(327,7657,109,40720,1524,3,217,1,991.74,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(328,7657,109,40720,1524,3,68,1,208.27,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(329,7657,109,40720,1524,3,57,2,1200.01,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(330,7657,110,40720,1524,3,217,1,7688.29,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(331,7657,110,40720,1524,3,68,1,1644.85,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(332,7657,110,40720,1524,3,217,1,577.06,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(333,7657,110,40720,1524,3,57,2,9910.20,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(334,7657,111,40720,1524,3,217,1,4920.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(335,7657,111,40720,1524,3,68,1,1033.20,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(336,7657,111,40720,1524,3,57,2,5953.20,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(337,7657,112,40720,1524,3,217,1,4628.10,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL);
INSERT INTO `balance_libro_details` VALUES (338,7657,112,40720,1524,3,68,1,971.90,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(339,7657,112,40720,1524,3,57,2,5600.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(340,7657,113,40720,1524,3,217,1,3305.79,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(341,7657,113,40720,1524,3,68,1,694.22,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(342,7657,113,40720,1524,3,57,2,4000.01,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(343,7657,114,40720,1524,3,217,1,2561.98,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(344,7657,114,40720,1524,3,68,1,538.02,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(345,7657,114,40720,1524,3,57,2,3100.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(346,7657,115,40720,1524,3,217,1,1942.15,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(347,7657,115,40720,1524,3,68,1,407.85,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(348,7657,115,40720,1524,3,57,2,2350.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(349,7657,116,40720,1524,3,217,1,21652.90,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(350,7657,116,40720,1524,3,68,1,4547.11,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(351,7657,116,40720,1524,3,57,2,26200.01,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(352,7657,117,40720,1524,3,217,1,5785.12,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(353,7657,117,40720,1524,3,68,1,1214.88,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(354,7657,117,40720,1524,3,57,2,7000.00,NULL,'2022-08-23 10:34:11','2022-08-23 10:34:11',NULL),(355,7657,118,40720,1524,3,217,1,3057.85,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(356,7657,118,40720,1524,3,68,1,642.15,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(357,7657,118,40720,1524,3,57,2,3700.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(358,7657,119,40720,1524,3,217,1,82644.63,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(359,7657,119,40720,1524,3,68,1,17355.37,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(360,7657,119,40720,1524,3,57,2,100000.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(361,7657,120,40720,1524,3,217,1,1487.60,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(362,7657,120,40720,1524,3,68,1,312.40,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(363,7657,120,40720,1524,3,57,2,1800.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(364,7657,121,40720,1524,3,217,1,826.45,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(365,7657,121,40720,1524,3,68,1,173.55,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(366,7657,121,40720,1524,3,57,2,1000.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(367,7657,122,40720,1524,3,217,1,1487.60,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(368,7657,122,40720,1524,3,68,1,312.40,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(369,7657,122,40720,1524,3,57,2,1800.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(370,7657,123,40720,1524,3,217,1,4297.52,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(371,7657,123,40720,1524,3,68,1,902.48,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(372,7657,123,40720,1524,3,57,2,5200.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(373,7657,124,40720,1524,3,217,1,2148.76,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(374,7657,124,40720,1524,3,68,1,451.24,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(375,7657,124,40720,1524,3,57,2,2600.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(376,7657,125,40720,1524,3,217,1,330.58,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(377,7657,125,40720,1524,3,68,1,69.42,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(378,7657,125,40720,1524,3,57,2,400.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(379,7657,126,40720,1524,3,217,1,5206.61,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL);
INSERT INTO `balance_libro_details` VALUES (380,7657,126,40720,1524,3,68,1,1093.39,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(381,7657,126,40720,1524,3,57,2,6300.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(382,7657,127,40720,1524,3,217,1,661.16,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(383,7657,127,40720,1524,3,68,1,138.84,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(384,7657,127,40720,1524,3,57,2,800.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(385,7657,128,40720,1524,3,217,1,9504.13,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(386,7657,128,40720,1524,3,68,1,1995.87,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(387,7657,128,40720,1524,3,57,2,11500.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(388,7657,129,40720,1524,3,217,1,9504.13,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(389,7657,129,40720,1524,3,68,1,1995.87,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(390,7657,129,40720,1524,3,57,2,11500.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(391,7657,130,40720,1524,3,217,1,743.80,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(392,7657,130,40720,1524,3,68,1,156.20,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(393,7657,130,40720,1524,3,57,2,900.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(394,7657,131,40720,1524,3,217,1,495.87,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(395,7657,131,40720,1524,3,68,1,104.13,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(396,7657,131,40720,1524,3,57,2,600.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(397,7657,132,40720,1524,3,217,1,3760.33,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(398,7657,132,40720,1524,3,68,1,789.67,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(399,7657,132,40720,1524,3,57,2,4550.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(400,7657,133,40720,1524,3,217,1,7438.02,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(401,7657,133,40720,1524,3,68,1,1561.98,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(402,7657,133,40720,1524,3,57,2,9000.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(403,7657,134,40720,1524,3,217,1,5619.85,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(404,7657,134,40720,1524,3,68,1,1180.17,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(405,7657,134,40720,1524,3,57,2,6800.02,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(406,7657,135,40720,1524,3,217,1,7438.02,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(407,7657,135,40720,1524,3,68,1,1561.98,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(408,7657,135,40720,1524,3,57,2,9000.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(409,7657,136,40720,1524,3,217,1,37190.08,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(410,7657,136,40720,1524,3,68,1,7809.92,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(411,7657,136,40720,1524,3,57,2,45000.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(412,7657,137,40720,1524,3,217,1,69173.55,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(413,7657,137,40720,1524,3,68,1,14526.45,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(414,7657,137,40720,1524,3,57,2,83700.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(415,7657,138,40720,1524,3,217,1,4710.74,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(416,7657,138,40720,1524,3,68,1,989.26,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(417,7657,138,40720,1524,3,57,2,5700.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(418,7657,139,40720,1524,3,217,1,6942.15,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(419,7657,139,40720,1524,3,68,1,1457.85,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(420,7657,139,40720,1524,3,57,2,8400.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(421,7657,140,40720,1524,3,217,1,9917.36,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL);
INSERT INTO `balance_libro_details` VALUES (422,7657,140,40720,1524,3,68,1,2082.65,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(423,7657,140,40720,1524,3,57,2,12000.01,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(424,7657,141,40720,1524,3,217,1,9090.91,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(425,7657,141,40720,1524,3,68,1,1909.09,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(426,7657,141,40720,1524,3,57,2,11000.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(427,7657,142,40720,1524,3,217,1,6528.93,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(428,7657,142,40720,1524,3,68,1,1371.08,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(429,7657,142,40720,1524,3,57,2,7900.01,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(430,7657,143,40720,1524,3,217,1,1818.18,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(431,7657,143,40720,1524,3,68,1,381.82,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(432,7657,143,40720,1524,3,57,2,2200.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(433,7657,144,40720,1524,3,217,2,2696.41,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(434,7657,144,40720,1524,3,67,2,566.25,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(435,7657,144,40720,1524,3,217,2,21.57,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(436,7657,144,40720,1524,3,57,1,3284.23,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(437,7657,145,40720,1524,3,217,1,10000.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(438,7657,145,40720,1524,3,68,1,2100.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(439,7657,145,40720,1524,3,57,2,12100.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(440,7657,146,40720,1524,3,250,1,2500.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(441,7657,146,40720,1524,3,57,2,2500.00,NULL,'2022-08-23 10:34:12','2022-08-23 10:34:12',NULL),(442,7657,147,40720,1524,3,217,1,75569.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(443,7657,147,40720,1524,3,68,1,15869.49,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(444,7657,147,40720,1524,3,57,2,91438.49,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(445,7657,148,40720,1524,3,217,1,81818.18,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(446,7657,148,40720,1524,3,68,1,17181.82,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(447,7657,148,40720,1524,3,57,2,99000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(448,7657,149,40720,1524,3,217,1,78515.96,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(449,7657,149,40720,1524,3,68,1,16488.35,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(450,7657,149,40720,1524,3,57,2,95004.31,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(451,7657,150,40720,1524,3,217,1,81818.18,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(452,7657,150,40720,1524,3,68,1,17181.82,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(453,7657,150,40720,1524,3,57,2,99000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(454,7657,151,40720,1524,3,217,1,80991.74,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(455,7657,151,40720,1524,3,68,1,17008.26,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(456,7657,151,40720,1524,3,57,2,98000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(457,7657,152,40720,1524,3,217,1,81818.18,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(458,7657,152,40720,1524,3,68,1,17181.82,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(459,7657,152,40720,1524,3,57,2,99000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(460,7657,153,40720,1524,3,217,1,4132.23,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(461,7657,153,40720,1524,3,68,1,867.77,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(462,7657,153,40720,1524,3,57,2,5000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL);
INSERT INTO `balance_libro_details` VALUES (463,7657,154,40720,1524,3,217,1,7438.02,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(464,7657,154,40720,1524,3,68,1,1561.98,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(465,7657,154,40720,1524,3,57,2,9000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(466,7657,155,40720,1524,3,217,1,4834.71,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(467,7657,155,40720,1524,3,68,1,1015.29,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(468,7657,155,40720,1524,3,57,2,5850.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(469,7657,156,40720,1524,3,217,1,81000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(470,7657,156,40720,1524,3,68,1,17010.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(471,7657,156,40720,1524,3,57,2,98010.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(472,7657,157,40720,1524,3,217,1,78000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(473,7657,157,40720,1524,3,68,1,16380.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(474,7657,157,40720,1524,3,57,2,94380.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(475,7657,158,40720,1524,3,217,1,82000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(476,7657,158,40720,1524,3,68,1,17220.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(477,7657,158,40720,1524,3,57,2,99220.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(478,7657,159,40720,1524,3,217,1,81818.18,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(479,7657,159,40720,1524,3,68,1,17181.82,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(480,7657,159,40720,1524,3,57,2,99000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(481,7657,160,40720,1524,3,217,1,76008.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(482,7657,160,40720,1524,3,68,1,15961.68,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(483,7657,160,40720,1524,3,57,2,91969.68,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(484,7657,161,40720,1524,3,217,1,75690.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(485,7657,161,40720,1524,3,68,1,15894.90,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(486,7657,161,40720,1524,3,57,2,91584.90,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(487,7657,162,40720,1524,3,217,1,81818.18,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(488,7657,162,40720,1524,3,68,1,17181.82,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(489,7657,162,40720,1524,3,57,2,99000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(490,7657,163,40720,1524,3,217,1,81818.18,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(491,7657,163,40720,1524,3,68,1,17181.82,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(492,7657,163,40720,1524,3,57,2,99000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(493,7657,164,40720,1524,3,217,1,79000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(494,7657,164,40720,1524,3,68,1,16590.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(495,7657,164,40720,1524,3,57,2,95590.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(496,7657,165,40720,1524,3,217,1,81818.18,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(497,7657,165,40720,1524,3,68,1,17181.82,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(498,7657,165,40720,1524,3,57,2,99000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(499,7657,166,40720,1524,3,217,1,78000.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(500,7657,166,40720,1524,3,68,1,16380.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(501,7657,166,40720,1524,3,57,2,94380.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(502,7657,167,40720,1524,3,217,1,75569.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(503,7657,167,40720,1524,3,68,1,15869.49,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL);
INSERT INTO `balance_libro_details` VALUES (504,7657,167,40720,1524,3,57,2,91438.49,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(505,7657,168,40720,1524,3,217,1,991.74,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(506,7657,168,40720,1524,3,68,1,208.27,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(507,7657,168,40720,1524,3,57,2,1200.01,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(508,7657,169,40720,1524,3,217,1,661.16,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(509,7657,169,40720,1524,3,68,1,138.84,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(510,7657,169,40720,1524,3,57,2,800.00,NULL,'2022-08-23 10:34:13','2022-08-23 10:34:13',NULL),(511,7657,170,40720,1524,2,96,2,18225.62,NULL,'2022-08-23 10:50:54','2022-08-23 11:01:56','2022-08-23 11:01:56'),(512,7657,170,40720,1524,2,67,2,3827.38,NULL,'2022-08-23 10:50:54','2022-08-23 11:01:56','2022-08-23 11:01:56'),(513,7657,170,40720,1524,2,13,1,22053.00,NULL,'2022-08-23 10:50:54','2022-08-23 11:01:56','2022-08-23 11:01:56'),(514,7657,171,40720,1524,2,96,2,806000.00,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(515,7657,171,40720,1524,2,67,2,169260.00,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(516,7657,171,40720,1524,2,13,1,975260.00,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(517,7657,172,40720,1524,2,96,2,6332130.00,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(518,7657,172,40720,1524,2,67,2,1329747.30,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(519,7657,172,40720,1524,2,13,1,7661877.30,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(520,7657,173,40720,1524,2,96,1,2114080.00,NULL,'2022-08-23 10:50:54','2022-08-23 11:02:52','2022-08-23 11:02:52'),(521,7657,173,40720,1524,2,68,1,443956.80,NULL,'2022-08-23 10:50:54','2022-08-23 11:02:52','2022-08-23 11:02:52'),(522,7657,173,40720,1524,2,13,2,2558036.80,NULL,'2022-08-23 10:50:54','2022-08-23 11:02:52','2022-08-23 11:02:52'),(523,7657,174,40720,1524,2,96,2,95777.50,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(524,7657,174,40720,1524,2,67,2,20113.28,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(525,7657,174,40720,1524,2,13,1,115890.78,NULL,'2022-08-23 10:50:54','2022-08-23 10:50:54',NULL),(526,7657,175,40720,1524,2,96,2,694392.75,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(527,7657,175,40720,1524,2,67,2,145822.48,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(528,7657,175,40720,1524,2,13,1,840215.23,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(529,7657,176,40720,1524,2,96,2,510576.50,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(530,7657,176,40720,1524,2,67,2,107221.06,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(531,7657,176,40720,1524,2,13,1,617797.56,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(532,7657,177,40720,1524,2,96,2,574861.75,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(533,7657,177,40720,1524,2,67,2,120720.97,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(534,7657,177,40720,1524,2,13,1,695582.72,NULL,'2022-08-23 10:50:55','2022-08-23 10:50:55',NULL),(535,7657,178,40720,1524,2,96,2,18225.62,NULL,'2022-08-23 11:01:56','2022-08-23 11:01:56',NULL),(536,7657,178,40720,1524,2,67,2,3827.38,NULL,'2022-08-23 11:01:56','2022-08-23 11:01:56',NULL),(537,7657,178,40720,1524,2,13,1,22053.00,NULL,'2022-08-23 11:01:56','2022-08-23 11:01:56',NULL),(538,7657,179,40720,1524,2,96,1,2114080.00,NULL,'2022-08-23 11:04:17','2022-08-23 11:04:17',NULL),(539,7657,179,40720,1524,2,68,1,443956.80,NULL,'2022-08-23 11:04:17','2022-08-23 11:04:17',NULL),(540,7657,179,40720,1524,2,13,2,2558036.80,NULL,'2022-08-23 11:04:17','2022-08-23 11:04:17',NULL),(541,7657,180,40744,12129,2,96,2,1141897.56,NULL,'2022-08-23 15:23:14','2022-08-24 11:44:29','2022-08-24 11:44:29'),(542,7657,180,40744,12129,2,67,2,239798.49,NULL,'2022-08-23 15:23:14','2022-08-24 11:44:29','2022-08-24 11:44:29');
INSERT INTO `balance_libro_details` VALUES (543,7657,180,40744,12129,2,13,1,1381696.05,NULL,'2022-08-23 15:23:14','2022-08-24 11:44:29','2022-08-24 11:44:29'),(544,7657,181,40744,12129,3,217,1,3744.90,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(545,7657,181,40744,12129,3,68,1,786.43,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(546,7657,181,40744,12129,3,217,1,592.63,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(547,7657,181,40744,12129,3,57,2,5123.96,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(548,7657,182,40744,12129,3,217,1,105120.66,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(549,7657,182,40744,12129,3,68,1,22075.34,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(550,7657,182,40744,12129,3,217,1,4320.45,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(551,7657,182,40744,12129,3,57,2,131516.45,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(552,7657,183,40744,12129,3,250,1,40000.00,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(553,7657,183,40744,12129,3,57,2,40000.00,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(554,7657,184,40744,12129,3,250,1,40000.00,NULL,'2022-08-23 15:23:52','2022-08-24 11:45:25','2022-08-24 11:45:25'),(555,7657,184,40744,12129,3,57,2,40000.00,NULL,'2022-08-23 15:23:52','2022-08-24 11:45:25','2022-08-24 11:45:25'),(556,7657,185,40744,12129,3,217,1,74148.95,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(557,7657,185,40744,12129,3,68,1,15571.28,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(558,7657,185,40744,12129,3,217,1,11734.10,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(559,7657,185,40744,12129,3,57,2,101454.33,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(560,7657,186,40744,12129,3,217,1,60254.05,NULL,'2022-08-23 15:23:52','2022-08-23 15:44:54','2022-08-23 15:44:54'),(561,7657,186,40744,12129,3,68,1,12653.35,NULL,'2022-08-23 15:23:52','2022-08-23 15:44:54','2022-08-23 15:44:54'),(562,7657,186,40744,12129,3,217,1,9535.22,NULL,'2022-08-23 15:23:52','2022-08-23 15:44:54','2022-08-23 15:44:54'),(563,7657,186,40744,12129,3,57,2,82442.62,NULL,'2022-08-23 15:23:52','2022-08-23 15:44:54','2022-08-23 15:44:54'),(564,7657,187,40744,12129,3,217,1,74148.95,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(565,7657,187,40744,12129,3,68,1,15571.28,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(566,7657,187,40744,12129,3,217,1,11734.10,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(567,7657,187,40744,12129,3,57,2,101454.33,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(568,7657,188,40744,12129,3,217,1,37614.28,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(569,7657,188,40744,12129,3,68,1,7899.00,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(570,7657,188,40744,12129,3,217,1,1545.94,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(571,7657,188,40744,12129,3,57,2,47059.22,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(572,7657,189,40744,12129,3,217,1,44962.81,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(573,7657,189,40744,12129,3,68,1,9442.19,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(574,7657,189,40744,12129,3,217,1,7089.58,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(575,7657,189,40744,12129,3,57,2,61494.58,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(576,7657,190,40744,12129,3,217,1,43983.99,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(577,7657,190,40744,12129,3,68,1,9236.64,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(578,7657,190,40744,12129,3,217,1,6935.24,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(579,7657,190,40744,12129,3,57,2,60155.87,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(580,7657,191,40744,12129,3,217,1,49498.85,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(581,7657,191,40744,12129,3,68,1,10394.76,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL);
INSERT INTO `balance_libro_details` VALUES (582,7657,191,40744,12129,3,217,1,7804.80,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(583,7657,191,40744,12129,3,57,2,67698.41,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(584,7657,192,40744,12129,3,217,1,34051.59,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(585,7657,192,40744,12129,3,68,1,7150.84,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(586,7657,192,40744,12129,3,217,1,1399.53,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(587,7657,192,40744,12129,3,57,2,42601.96,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(588,7657,193,40744,12129,3,217,1,3471.07,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(589,7657,193,40744,12129,3,68,1,728.93,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(590,7657,193,40744,12129,3,57,2,4200.00,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(591,7657,194,40744,12129,3,217,1,43998.98,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(592,7657,194,40744,12129,3,68,1,9239.78,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(593,7657,194,40744,12129,3,217,1,6937.61,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(594,7657,194,40744,12129,3,57,2,60176.37,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(595,7657,195,40744,12129,3,217,2,34051.59,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(596,7657,195,40744,12129,3,67,2,7150.84,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(597,7657,195,40744,12129,3,217,2,1399.53,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(598,7657,195,40744,12129,3,57,1,42601.96,NULL,'2022-08-23 15:23:52','2022-08-23 15:23:52',NULL),(599,7657,196,40744,12129,3,250,1,8000.00,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(600,7657,196,40744,12129,3,57,2,8000.00,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(601,7657,197,40744,12129,3,217,1,43998.98,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(602,7657,197,40744,12129,3,68,1,9239.78,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(603,7657,197,40744,12129,3,217,1,6937.61,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(604,7657,197,40744,12129,3,57,2,60176.37,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(605,7657,198,40744,12129,3,217,1,49498.85,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(606,7657,198,40744,12129,3,68,1,10394.76,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(607,7657,198,40744,12129,3,217,1,7804.80,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(608,7657,198,40744,12129,3,57,2,67698.41,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(609,7657,199,40744,12129,3,217,1,22236.36,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(610,7657,199,40744,12129,3,68,1,4669.64,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(611,7657,199,40744,12129,3,217,1,177.89,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(612,7657,199,40744,12129,3,57,2,27083.89,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(613,7657,200,40744,12129,3,217,1,43998.98,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(614,7657,200,40744,12129,3,68,1,9239.78,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(615,7657,200,40744,12129,3,217,1,6937.61,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(616,7657,200,40744,12129,3,57,2,60176.37,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(617,7657,201,40744,12129,3,217,1,50615.53,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(618,7657,201,40744,12129,3,68,1,10629.26,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(619,7657,201,40744,12129,3,217,1,7980.88,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(620,7657,201,40744,12129,3,57,2,69225.67,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(621,7657,202,40744,12129,3,217,1,43998.98,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(622,7657,202,40744,12129,3,68,1,9239.78,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL);
INSERT INTO `balance_libro_details` VALUES (623,7657,202,40744,12129,3,217,1,6937.61,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(624,7657,202,40744,12129,3,57,2,60176.37,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(625,7657,203,40744,12129,3,217,1,1157.27,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(626,7657,203,40744,12129,3,68,1,243.03,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(627,7657,203,40744,12129,3,217,1,99.70,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(628,7657,203,40744,12129,3,57,2,1500.00,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(629,7657,204,40744,12129,3,217,1,250.00,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(630,7657,204,40744,12129,3,68,1,52.50,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(631,7657,204,40744,12129,3,57,2,302.50,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(632,7657,205,40744,12129,3,217,1,45537.19,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(633,7657,205,40744,12129,3,68,1,9562.81,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(634,7657,205,40744,12129,3,217,1,1871.58,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(635,7657,205,40744,12129,3,57,2,56971.58,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(636,7657,206,40744,12129,3,217,1,49529.34,NULL,'2022-08-23 15:23:53','2022-08-26 15:55:47','2022-08-26 15:55:47'),(637,7657,206,40744,12129,3,68,1,10401.16,NULL,'2022-08-23 15:23:53','2022-08-26 15:55:47','2022-08-26 15:55:47'),(638,7657,206,40744,12129,3,217,1,7809.61,NULL,'2022-08-23 15:23:53','2022-08-26 15:55:47','2022-08-26 15:55:47'),(639,7657,206,40744,12129,3,57,2,67740.11,NULL,'2022-08-23 15:23:53','2022-08-26 15:55:47','2022-08-26 15:55:47'),(640,7657,207,40744,12129,3,217,1,11014.73,NULL,'2022-08-23 15:23:53','2022-08-26 15:57:31','2022-08-26 15:57:31'),(641,7657,207,40744,12129,3,68,1,2313.09,NULL,'2022-08-23 15:23:53','2022-08-26 15:57:31','2022-08-26 15:57:31'),(642,7657,207,40744,12129,3,217,1,1736.77,NULL,'2022-08-23 15:23:53','2022-08-26 15:57:31','2022-08-26 15:57:31'),(643,7657,207,40744,12129,3,57,2,15064.59,NULL,'2022-08-23 15:23:53','2022-08-26 15:57:31','2022-08-26 15:57:31'),(644,7657,208,40744,12129,3,217,1,3746.50,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(645,7657,208,40744,12129,3,68,1,786.76,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(646,7657,208,40744,12129,3,217,1,590.74,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(647,7657,208,40744,12129,3,57,2,5124.00,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(648,7657,209,40744,12129,3,217,1,33718.56,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(649,7657,209,40744,12129,3,68,1,7080.90,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(650,7657,209,40744,12129,3,217,1,5316.62,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(651,7657,209,40744,12129,3,57,2,46116.08,NULL,'2022-08-23 15:23:53','2022-08-23 15:23:53',NULL),(652,7657,210,40744,12129,3,217,1,60254.05,NULL,'2022-08-23 15:44:54','2022-08-23 15:44:54',NULL),(653,7657,210,40744,12129,3,68,1,12653.35,NULL,'2022-08-23 15:44:54','2022-08-23 15:44:54',NULL),(654,7657,210,40744,12129,3,217,1,9535.22,NULL,'2022-08-23 15:44:54','2022-08-23 15:44:54',NULL),(655,7657,210,40744,12129,3,222,1,4290.85,NULL,'2022-08-23 15:44:54','2022-08-23 15:44:54',NULL),(656,7657,210,40744,12129,3,221,1,5244.37,NULL,'2022-08-23 15:44:54','2022-08-23 15:44:54',NULL),(657,7657,210,40744,12129,3,57,2,91977.84,NULL,'2022-08-23 15:44:54','2022-08-23 15:44:54',NULL),(658,7657,211,40760,25764,3,217,1,6446.28,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(659,7657,211,40760,25764,3,68,1,1353.72,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(660,7657,211,40760,25764,3,57,2,7800.00,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(661,7657,212,40760,25764,3,217,1,8223.14,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(662,7657,212,40760,25764,3,68,1,1726.86,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL);
INSERT INTO `balance_libro_details` VALUES (663,7657,212,40760,25764,3,57,2,9950.00,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(664,7657,213,40760,25764,3,217,1,413.22,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(665,7657,213,40760,25764,3,68,1,86.78,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(666,7657,213,40760,25764,3,57,2,500.00,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(667,7657,214,40760,25764,3,217,1,371.90,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(668,7657,214,40760,25764,3,68,1,78.10,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(669,7657,214,40760,25764,3,57,2,450.00,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(670,7657,215,40760,25764,3,217,1,1322.31,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(671,7657,215,40760,25764,3,68,1,277.69,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(672,7657,215,40760,25764,3,57,2,1600.00,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(673,7657,216,40760,25764,3,217,1,2892.56,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(674,7657,216,40760,25764,3,68,1,607.44,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(675,7657,216,40760,25764,3,57,2,3500.00,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(676,7657,217,40760,25764,3,217,1,4113.81,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(677,7657,217,40760,25764,3,68,1,863.90,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(678,7657,217,40760,25764,3,217,1,154.26,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(679,7657,217,40760,25764,3,57,2,5131.97,NULL,'2022-08-23 21:54:50','2022-08-23 21:54:50',NULL),(680,7657,218,40760,25764,3,217,1,578.51,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(681,7657,218,40760,25764,3,68,1,121.49,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(682,7657,218,40760,25764,3,57,2,700.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(683,7657,219,40760,25764,3,217,1,3305.79,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(684,7657,219,40760,25764,3,68,1,694.22,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(685,7657,219,40760,25764,3,57,2,4000.01,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(686,7657,220,40760,25764,3,217,1,3388.43,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(687,7657,220,40760,25764,3,68,1,711.57,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(688,7657,220,40760,25764,3,57,2,4100.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(689,7657,221,40760,25764,3,217,1,2644.63,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(690,7657,221,40760,25764,3,68,1,555.37,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(691,7657,221,40760,25764,3,57,2,3200.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(692,7657,222,40760,25764,3,217,1,19917.36,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(693,7657,222,40760,25764,3,68,1,4182.65,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(694,7657,222,40760,25764,3,57,2,24100.01,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(695,7657,223,40760,25764,3,217,1,3388.43,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(696,7657,223,40760,25764,3,68,1,711.57,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(697,7657,223,40760,25764,3,57,2,4100.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(698,7657,224,40760,25764,3,217,1,15289.26,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(699,7657,224,40760,25764,3,68,1,3210.74,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(700,7657,224,40760,25764,3,57,2,18500.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(701,7657,225,40760,25764,3,217,1,2561.98,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(702,7657,225,40760,25764,3,68,1,538.02,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(703,7657,225,40760,25764,3,57,2,3100.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL);
INSERT INTO `balance_libro_details` VALUES (704,7657,226,40760,25764,3,217,1,11259.50,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(705,7657,226,40760,25764,3,68,1,2364.50,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(706,7657,226,40760,25764,3,57,2,13624.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(707,7657,227,40760,25764,3,217,1,15454.55,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(708,7657,227,40760,25764,3,68,1,3245.46,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(709,7657,227,40760,25764,3,57,2,18700.01,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(710,7657,228,40760,25764,3,217,1,6727.27,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(711,7657,228,40760,25764,3,68,1,1412.73,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(712,7657,228,40760,25764,3,57,2,8140.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(713,7657,229,40760,25764,3,217,1,5454.55,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(714,7657,229,40760,25764,3,68,1,1145.46,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(715,7657,229,40760,25764,3,57,2,6600.01,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(716,7657,230,40760,25764,3,217,1,4049.59,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(717,7657,230,40760,25764,3,68,1,850.41,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(718,7657,230,40760,25764,3,57,2,4900.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(719,7657,231,40760,25764,3,217,1,10247.93,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(720,7657,231,40760,25764,3,68,1,2152.07,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(721,7657,231,40760,25764,3,57,2,12400.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(722,7657,232,40760,25764,3,217,1,3636.36,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(723,7657,232,40760,25764,3,68,1,763.64,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(724,7657,232,40760,25764,3,57,2,4400.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(725,7657,233,40760,25764,3,217,1,13471.08,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(726,7657,233,40760,25764,3,68,1,2828.93,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(727,7657,233,40760,25764,3,57,2,16300.01,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(728,7657,234,40760,25764,3,217,1,5537.19,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(729,7657,234,40760,25764,3,68,1,1162.81,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(730,7657,234,40760,25764,3,57,2,6700.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(731,7657,235,40760,25764,3,217,1,826.45,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(732,7657,235,40760,25764,3,68,1,173.55,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(733,7657,235,40760,25764,3,57,2,1000.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(734,7657,236,40760,25764,3,217,1,661.16,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(735,7657,236,40760,25764,3,68,1,138.84,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(736,7657,236,40760,25764,3,57,2,800.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(737,7657,237,40760,25764,3,217,1,1983.47,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(738,7657,237,40760,25764,3,68,1,416.53,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(739,7657,237,40760,25764,3,57,2,2400.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(740,7657,238,40760,25764,3,217,1,495.87,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(741,7657,238,40760,25764,3,68,1,104.13,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(742,7657,238,40760,25764,3,57,2,600.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(743,7657,239,40760,25764,3,217,1,826.45,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(744,7657,239,40760,25764,3,68,1,173.55,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL);
INSERT INTO `balance_libro_details` VALUES (745,7657,239,40760,25764,3,57,2,1000.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(746,7657,240,40760,25764,3,217,1,413.22,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(747,7657,240,40760,25764,3,68,1,86.78,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(748,7657,240,40760,25764,3,57,2,500.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(749,7657,241,40760,25764,3,217,1,1033.06,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(750,7657,241,40760,25764,3,68,1,216.94,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(751,7657,241,40760,25764,3,57,2,1250.00,NULL,'2022-08-23 21:54:51','2022-08-23 21:54:51',NULL),(752,7657,242,40760,25764,3,217,1,826.45,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(753,7657,242,40760,25764,3,68,1,173.55,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(754,7657,242,40760,25764,3,57,2,1000.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(755,7657,243,40760,25764,3,217,1,909.09,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(756,7657,243,40760,25764,3,68,1,190.91,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(757,7657,243,40760,25764,3,57,2,1100.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(758,7657,244,40760,25764,3,217,1,2644.63,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(759,7657,244,40760,25764,3,68,1,555.37,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(760,7657,244,40760,25764,3,57,2,3200.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(761,7657,245,40760,25764,3,250,1,1329.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(762,7657,245,40760,25764,3,57,2,1329.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(763,7657,246,40760,25764,3,217,1,22314.05,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(764,7657,246,40760,25764,3,68,1,4685.95,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(765,7657,246,40760,25764,3,57,2,27000.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(766,7657,247,40760,25764,3,217,1,1818.18,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(767,7657,247,40760,25764,3,68,1,381.82,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(768,7657,247,40760,25764,3,57,2,2200.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(769,7657,248,40760,25764,3,217,1,329.68,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(770,7657,248,40760,25764,3,68,1,69.23,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(771,7657,248,40760,25764,3,57,2,398.91,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(772,7657,249,40760,25764,3,217,1,63504.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(773,7657,249,40760,25764,3,68,1,13335.84,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(774,7657,249,40760,25764,3,217,1,2578.26,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(775,7657,249,40760,25764,3,57,2,79418.10,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(776,7657,250,40760,25764,3,217,1,12314.05,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(777,7657,250,40760,25764,3,68,1,2585.95,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(778,7657,250,40760,25764,3,57,2,14900.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(779,7657,251,40760,25764,3,217,1,2892.56,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(780,7657,251,40760,25764,3,68,1,607.44,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(781,7657,251,40760,25764,3,57,2,3500.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(782,7657,252,40760,25764,3,217,1,495.87,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(783,7657,252,40760,25764,3,68,1,104.13,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(784,7657,252,40760,25764,3,57,2,600.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(785,7657,253,40760,25764,3,217,1,2975.21,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL);
INSERT INTO `balance_libro_details` VALUES (786,7657,253,40760,25764,3,68,1,624.79,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(787,7657,253,40760,25764,3,57,2,3600.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(788,7657,254,40760,25764,3,217,1,3057.85,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(789,7657,254,40760,25764,3,68,1,642.15,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(790,7657,254,40760,25764,3,57,2,3700.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(791,7657,255,40760,25764,3,217,1,23966.94,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(792,7657,255,40760,25764,3,68,1,5033.06,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(793,7657,255,40760,25764,3,57,2,29000.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(794,7657,256,40760,25764,3,217,1,47958.02,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(795,7657,256,40760,25764,3,68,1,10071.18,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(796,7657,256,40760,25764,3,217,1,1971.06,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(797,7657,256,40760,25764,3,57,2,60000.26,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(798,7657,257,40760,25764,3,217,1,12644.63,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(799,7657,257,40760,25764,3,68,1,2655.37,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(800,7657,257,40760,25764,3,57,2,15300.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(801,7657,258,40760,25764,3,217,1,1404.96,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(802,7657,258,40760,25764,3,68,1,295.04,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(803,7657,258,40760,25764,3,57,2,1700.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(804,7657,259,40760,25764,3,217,1,1239.67,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(805,7657,259,40760,25764,3,68,1,260.33,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(806,7657,259,40760,25764,3,57,2,1500.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(807,7657,260,40760,25764,3,217,1,18429.75,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(808,7657,260,40760,25764,3,68,1,3870.25,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(809,7657,260,40760,25764,3,57,2,22300.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(810,7657,261,40760,25764,3,217,1,4958.68,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(811,7657,261,40760,25764,3,68,1,1041.32,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(812,7657,261,40760,25764,3,57,2,6000.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(813,7657,262,40760,25764,3,217,1,4380.17,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(814,7657,262,40760,25764,3,68,1,919.84,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(815,7657,262,40760,25764,3,57,2,5300.01,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(816,7657,263,40760,25764,3,217,1,1487.60,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(817,7657,263,40760,25764,3,68,1,312.40,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(818,7657,263,40760,25764,3,57,2,1800.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(819,7657,264,40760,25764,3,217,1,4462.81,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(820,7657,264,40760,25764,3,68,1,937.19,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(821,7657,264,40760,25764,3,57,2,5400.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(822,7657,265,40760,25764,3,217,1,4545.46,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(823,7657,265,40760,25764,3,68,1,954.55,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(824,7657,265,40760,25764,3,57,2,5500.01,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(825,7657,266,40760,25764,3,217,1,3801.65,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(826,7657,266,40760,25764,3,68,1,798.35,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL);
INSERT INTO `balance_libro_details` VALUES (827,7657,266,40760,25764,3,57,2,4600.00,NULL,'2022-08-23 21:54:52','2022-08-23 21:54:52',NULL),(828,7657,267,40760,25764,3,217,1,2603.31,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(829,7657,267,40760,25764,3,68,1,546.70,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(830,7657,267,40760,25764,3,57,2,3150.01,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(831,7657,268,40760,25764,3,217,1,14297.52,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(832,7657,268,40760,25764,3,68,1,3002.48,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(833,7657,268,40760,25764,3,57,2,17300.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(834,7657,269,40760,25764,3,217,1,12396.70,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(835,7657,269,40760,25764,3,68,1,2603.31,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(836,7657,269,40760,25764,3,57,2,15000.01,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(837,7657,270,40760,25764,3,217,1,4793.39,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(838,7657,270,40760,25764,3,68,1,1006.61,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(839,7657,270,40760,25764,3,57,2,5800.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(840,7657,271,40760,25764,3,217,1,4173.55,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(841,7657,271,40760,25764,3,68,1,876.45,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(842,7657,271,40760,25764,3,57,2,5050.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(843,7657,272,40760,25764,3,217,1,41157.03,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(844,7657,272,40760,25764,3,68,1,8642.98,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(845,7657,272,40760,25764,3,57,2,49800.01,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(846,7657,273,40760,25764,3,217,1,2892.56,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(847,7657,273,40760,25764,3,68,1,607.44,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(848,7657,273,40760,25764,3,57,2,3500.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(849,7657,274,40760,25764,3,217,1,4132.23,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(850,7657,274,40760,25764,3,68,1,867.77,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(851,7657,274,40760,25764,3,57,2,5000.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(852,7657,275,40760,25764,3,250,1,8000.00,NULL,'2022-08-23 21:54:53','2022-08-23 22:02:50','2022-08-23 22:02:50'),(853,7657,275,40760,25764,3,57,2,8000.00,NULL,'2022-08-23 21:54:53','2022-08-23 22:02:50','2022-08-23 22:02:50'),(854,7657,276,40760,25764,3,217,1,1900.83,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(855,7657,276,40760,25764,3,68,1,399.17,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(856,7657,276,40760,25764,3,57,2,2300.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(857,7657,277,40760,25764,3,217,1,6446.29,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(858,7657,277,40760,25764,3,68,1,1353.72,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(859,7657,277,40760,25764,3,57,2,7800.01,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(860,7657,278,40760,25764,3,217,1,826.45,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(861,7657,278,40760,25764,3,68,1,173.55,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(862,7657,278,40760,25764,3,57,2,1000.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(863,7657,279,40760,25764,3,217,1,156198.35,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(864,7657,279,40760,25764,3,68,1,32801.65,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(865,7657,279,40760,25764,3,57,2,189000.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(866,7657,280,40760,25764,3,217,1,4380.17,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(867,7657,280,40760,25764,3,68,1,919.84,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL);
INSERT INTO `balance_libro_details` VALUES (868,7657,280,40760,25764,3,57,2,5300.01,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(869,7657,281,40760,25764,3,217,1,4214.88,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(870,7657,281,40760,25764,3,68,1,885.12,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(871,7657,281,40760,25764,3,57,2,5100.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(872,7657,282,40760,25764,3,217,1,4214.88,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(873,7657,282,40760,25764,3,68,1,885.12,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(874,7657,282,40760,25764,3,57,2,5100.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(875,7657,283,40760,25764,3,217,1,17355.37,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(876,7657,283,40760,25764,3,68,1,3644.63,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(877,7657,283,40760,25764,3,57,2,21000.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(878,7657,284,40760,25764,3,217,1,1487.60,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(879,7657,284,40760,25764,3,68,1,312.40,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(880,7657,284,40760,25764,3,57,2,1800.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(881,7657,285,40760,25764,3,217,1,2148.76,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(882,7657,285,40760,25764,3,68,1,451.24,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(883,7657,285,40760,25764,3,57,2,2600.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(884,7657,286,40760,25764,3,217,1,24820.24,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(885,7657,286,40760,25764,3,68,1,5212.25,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(886,7657,286,40760,25764,3,217,1,198.56,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(887,7657,286,40760,25764,3,57,2,30231.05,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(888,7657,287,40760,25764,3,217,1,34504.13,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(889,7657,287,40760,25764,3,68,1,7245.87,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(890,7657,287,40760,25764,3,57,2,41750.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(891,7657,288,40760,25764,3,217,1,2148.76,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(892,7657,288,40760,25764,3,68,1,451.24,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(893,7657,288,40760,25764,3,57,2,2600.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(894,7657,289,40760,25764,3,217,1,7107.44,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(895,7657,289,40760,25764,3,68,1,1492.56,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(896,7657,289,40760,25764,3,57,2,8600.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(897,7657,290,40760,25764,3,217,1,1652.90,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(898,7657,290,40760,25764,3,68,1,347.11,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(899,7657,290,40760,25764,3,57,2,2000.01,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(900,7657,291,40760,25764,3,217,1,2148.76,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(901,7657,291,40760,25764,3,68,1,451.24,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(902,7657,291,40760,25764,3,57,2,2600.00,NULL,'2022-08-23 21:54:53','2022-08-23 21:54:53',NULL),(903,7657,292,40760,25764,3,217,1,14253.54,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(904,7657,292,40760,25764,3,68,1,2993.24,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(905,7657,292,40760,25764,3,57,2,17246.78,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(906,7657,293,40760,25764,3,217,1,1652.90,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(907,7657,293,40760,25764,3,68,1,347.11,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(908,7657,293,40760,25764,3,57,2,2000.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL);
INSERT INTO `balance_libro_details` VALUES (909,7657,294,40760,25764,3,217,1,3719.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(910,7657,294,40760,25764,3,68,1,780.99,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(911,7657,294,40760,25764,3,57,2,4500.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(912,7657,295,40760,25764,3,217,1,3719.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(913,7657,295,40760,25764,3,68,1,780.99,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(914,7657,295,40760,25764,3,57,2,4500.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(915,7657,296,40760,25764,3,217,1,2644.63,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(916,7657,296,40760,25764,3,68,1,555.37,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(917,7657,296,40760,25764,3,57,2,3200.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(918,7657,297,40760,25764,3,250,1,1329.00,NULL,'2022-08-23 21:54:54','2022-08-23 22:00:42','2022-08-23 22:00:42'),(919,7657,297,40760,25764,3,57,2,1329.00,NULL,'2022-08-23 21:54:54','2022-08-23 22:00:42','2022-08-23 22:00:42'),(920,7657,298,40760,25764,3,217,1,22727.27,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(921,7657,298,40760,25764,3,68,1,4772.73,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(922,7657,298,40760,25764,3,57,2,27500.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(923,7657,299,40760,25764,3,217,1,1239.67,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(924,7657,299,40760,25764,3,68,1,260.33,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(925,7657,299,40760,25764,3,57,2,1500.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(926,7657,300,40760,25764,3,217,1,3305.79,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(927,7657,300,40760,25764,3,68,1,694.22,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(928,7657,300,40760,25764,3,57,2,4000.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(929,7657,301,40760,25764,3,217,1,2851.25,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(930,7657,301,40760,25764,3,68,1,598.76,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(931,7657,301,40760,25764,3,57,2,3450.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(932,7657,302,40760,25764,3,217,1,3719.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(933,7657,302,40760,25764,3,68,1,780.99,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(934,7657,302,40760,25764,3,57,2,4500.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(935,7657,303,40760,25764,3,217,1,1900.83,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(936,7657,303,40760,25764,3,68,1,399.17,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(937,7657,303,40760,25764,3,57,2,2300.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(938,7657,304,40760,25764,3,217,1,2148.76,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(939,7657,304,40760,25764,3,68,1,451.24,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(940,7657,304,40760,25764,3,57,2,2600.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(941,7657,305,40760,25764,3,217,1,6528.93,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(942,7657,305,40760,25764,3,68,1,1371.08,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(943,7657,305,40760,25764,3,57,2,7900.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(944,7657,306,40760,25764,3,217,1,2892.57,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(945,7657,306,40760,25764,3,68,1,607.44,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(946,7657,306,40760,25764,3,57,2,3500.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(947,7657,307,40760,25764,3,217,1,4214.88,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(948,7657,307,40760,25764,3,68,1,885.12,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(949,7657,307,40760,25764,3,57,2,5100.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL);
INSERT INTO `balance_libro_details` VALUES (950,7657,308,40760,25764,3,217,1,1446.28,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(951,7657,308,40760,25764,3,68,1,303.72,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(952,7657,308,40760,25764,3,57,2,1750.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(953,7657,309,40760,25764,3,217,1,12892.56,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(954,7657,309,40760,25764,3,68,1,2707.44,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(955,7657,309,40760,25764,3,57,2,15600.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(956,7657,310,40760,25764,3,217,1,2066.12,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(957,7657,310,40760,25764,3,68,1,433.89,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(958,7657,310,40760,25764,3,57,2,2500.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(959,7657,311,40760,25764,3,217,1,826.45,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(960,7657,311,40760,25764,3,68,1,173.55,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(961,7657,311,40760,25764,3,57,2,1000.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(962,7657,312,40760,25764,3,217,1,5454.55,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(963,7657,312,40760,25764,3,68,1,1145.46,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(964,7657,312,40760,25764,3,57,2,6600.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(965,7657,313,40760,25764,3,217,1,1735.54,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(966,7657,313,40760,25764,3,68,1,364.46,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(967,7657,313,40760,25764,3,57,2,2100.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(968,7657,314,40760,25764,3,217,1,35908.62,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(969,7657,314,40760,25764,3,68,1,7540.81,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(970,7657,314,40760,25764,3,217,1,1188.58,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(971,7657,314,40760,25764,3,57,2,44638.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(972,7657,315,40760,25764,3,217,1,3719.01,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(973,7657,315,40760,25764,3,68,1,780.99,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(974,7657,315,40760,25764,3,57,2,4500.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(975,7657,316,40760,25764,3,217,1,9850.44,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(976,7657,316,40760,25764,3,68,1,2068.59,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(977,7657,316,40760,25764,3,217,1,78.80,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(978,7657,316,40760,25764,3,57,2,11997.83,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(979,7657,317,40760,25764,3,217,1,25464.83,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(980,7657,317,40760,25764,3,68,1,5347.58,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(981,7657,317,40760,25764,3,57,2,30812.41,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(982,7657,318,40760,25764,3,217,1,2031.16,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(983,7657,318,40760,25764,3,68,1,426.55,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(984,7657,318,40760,25764,3,57,2,2457.71,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(985,7657,319,40760,25764,3,217,1,22314.05,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(986,7657,319,40760,25764,3,68,1,4685.95,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(987,7657,319,40760,25764,3,57,2,27000.00,NULL,'2022-08-23 21:54:54','2022-08-23 21:54:54',NULL),(988,7657,320,40760,25764,3,217,1,174200.90,NULL,'2022-08-23 21:54:55','2022-08-23 22:01:21','2022-08-23 22:01:21'),(989,7657,320,40760,25764,3,68,1,18291.10,NULL,'2022-08-23 21:54:55','2022-08-23 22:01:21','2022-08-23 22:01:21'),(990,7657,320,40760,25764,3,57,2,192492.00,NULL,'2022-08-23 21:54:55','2022-08-23 22:01:21','2022-08-23 22:01:21');
INSERT INTO `balance_libro_details` VALUES (991,7657,321,40760,25764,3,217,1,10859.95,NULL,'2022-08-23 21:54:55','2022-08-23 22:14:19','2022-08-23 22:14:19'),(992,7657,321,40760,25764,3,68,1,2280.59,NULL,'2022-08-23 21:54:55','2022-08-23 22:14:19','2022-08-23 22:14:19'),(993,7657,321,40760,25764,3,217,1,359.46,NULL,'2022-08-23 21:54:55','2022-08-23 22:14:19','2022-08-23 22:14:19'),(994,7657,321,40760,25764,3,57,2,13500.00,NULL,'2022-08-23 21:54:55','2022-08-23 22:14:19','2022-08-23 22:14:19'),(995,7657,322,40760,25764,3,217,1,5654751.13,NULL,'2022-08-23 21:54:55','2022-08-23 22:13:08','2022-08-23 22:13:08'),(996,7657,322,40760,25764,3,68,1,593748.87,NULL,'2022-08-23 21:54:55','2022-08-23 22:13:08','2022-08-23 22:13:08'),(997,7657,322,40760,25764,3,57,2,6248500.00,NULL,'2022-08-23 21:54:55','2022-08-23 22:13:08','2022-08-23 22:13:08'),(998,7657,323,40760,25764,3,217,1,78000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(999,7657,323,40760,25764,3,68,1,16380.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1000,7657,323,40760,25764,3,57,2,94380.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1001,7657,324,40760,25764,3,217,1,80991.74,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1002,7657,324,40760,25764,3,68,1,17008.26,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1003,7657,324,40760,25764,3,57,2,98000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1004,7657,325,40760,25764,3,217,1,80991.74,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1005,7657,325,40760,25764,3,68,1,17008.26,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1006,7657,325,40760,25764,3,57,2,98000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1007,7657,326,40760,25764,3,217,1,81818.18,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1008,7657,326,40760,25764,3,68,1,17181.82,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1009,7657,326,40760,25764,3,57,2,99000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1010,7657,327,40760,25764,3,217,1,80165.29,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1011,7657,327,40760,25764,3,68,1,16834.71,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1012,7657,327,40760,25764,3,57,2,97000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1013,7657,328,40760,25764,3,217,1,793388.43,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1014,7657,328,40760,25764,3,68,1,166611.57,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1015,7657,328,40760,25764,3,57,2,960000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1016,7657,329,40760,25764,3,217,1,81818.18,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1017,7657,329,40760,25764,3,68,1,17181.82,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1018,7657,329,40760,25764,3,57,2,99000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1019,7657,330,40760,25764,3,217,1,81818.18,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1020,7657,330,40760,25764,3,68,1,17181.82,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1021,7657,330,40760,25764,3,57,2,99000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1022,7657,331,40760,25764,3,217,1,785123.97,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1023,7657,331,40760,25764,3,68,1,164876.03,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1024,7657,331,40760,25764,3,57,2,950000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1025,7657,332,40760,25764,3,217,1,75569.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1026,7657,332,40760,25764,3,68,1,15869.49,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1027,7657,332,40760,25764,3,57,2,91438.49,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1028,7657,333,40760,25764,3,217,1,81818.18,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1029,7657,333,40760,25764,3,68,1,17181.82,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL);
INSERT INTO `balance_libro_details` VALUES (1030,7657,333,40760,25764,3,57,2,99000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1031,7657,334,40760,25764,3,217,1,785123.97,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1032,7657,334,40760,25764,3,68,1,164876.03,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1033,7657,334,40760,25764,3,57,2,950000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1034,7657,335,40760,25764,3,217,1,80991.74,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1035,7657,335,40760,25764,3,68,1,17008.26,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1036,7657,335,40760,25764,3,57,2,98000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1037,7657,336,40760,25764,3,217,1,800564.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1038,7657,336,40760,25764,3,68,1,168118.44,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1039,7657,336,40760,25764,3,57,2,968682.44,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1040,7657,337,40760,25764,3,217,1,80950.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1041,7657,337,40760,25764,3,68,1,16999.50,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1042,7657,337,40760,25764,3,57,2,97949.50,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1043,7657,338,40760,25764,3,217,1,79555.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1044,7657,338,40760,25764,3,68,1,16706.55,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1045,7657,338,40760,25764,3,57,2,96261.55,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1046,7657,339,40760,25764,3,217,1,81818.18,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1047,7657,339,40760,25764,3,68,1,17181.82,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1048,7657,339,40760,25764,3,57,2,99000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1049,7657,340,40760,25764,3,217,1,81818.18,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1050,7657,340,40760,25764,3,68,1,17181.82,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1051,7657,340,40760,25764,3,57,2,99000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1052,7657,341,40760,25764,3,217,1,75258.24,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1053,7657,341,40760,25764,3,68,1,15804.23,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1054,7657,341,40760,25764,3,57,2,91062.47,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1055,7657,342,40760,25764,3,217,1,78000.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1056,7657,342,40760,25764,3,68,1,16380.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1057,7657,342,40760,25764,3,57,2,94380.00,NULL,'2022-08-23 21:54:55','2022-08-23 21:54:55',NULL),(1058,7657,343,40760,25764,2,96,2,12371.90,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1059,7657,343,40760,25764,2,67,2,2598.10,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1060,7657,343,40760,25764,2,13,1,14970.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1061,7657,344,40760,25764,2,96,2,776.86,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1062,7657,344,40760,25764,2,67,2,163.14,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1063,7657,344,40760,25764,2,13,1,940.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1064,7657,345,40760,25764,2,96,2,1322.31,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1065,7657,345,40760,25764,2,67,2,277.69,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1066,7657,345,40760,25764,2,13,1,1600.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1067,7657,346,40760,25764,2,96,2,8078.52,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1068,7657,346,40760,25764,2,67,2,1696.48,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1069,7657,346,40760,25764,2,13,1,9775.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1070,7657,347,40760,25764,2,96,2,14628.10,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1071,7657,347,40760,25764,2,67,2,3071.90,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1072,7657,347,40760,25764,2,13,1,17700.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1073,7657,348,40760,25764,2,96,2,785.12,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1074,7657,348,40760,25764,2,67,2,164.88,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1075,7657,348,40760,25764,2,13,1,950.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1076,7657,349,40760,25764,2,96,2,6496810.68,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1077,7657,349,40760,25764,2,67,2,1364330.24,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1078,7657,349,40760,25764,2,13,1,7861140.92,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1079,7657,350,40760,25764,2,96,1,2154720.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1080,7657,350,40760,25764,2,68,1,452491.20,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1081,7657,350,40760,25764,2,13,2,2607211.20,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1082,7657,351,40760,25764,2,96,2,7024.80,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1083,7657,351,40760,25764,2,67,2,1475.20,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1084,7657,351,40760,25764,2,13,1,8500.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1085,7657,352,40760,25764,2,96,2,190255.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1086,7657,352,40760,25764,2,67,2,39953.55,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1087,7657,352,40760,25764,2,13,1,230208.55,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1088,7657,353,40760,25764,2,96,2,239838.25,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1089,7657,353,40760,25764,2,67,2,50366.03,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1090,7657,353,40760,25764,2,13,1,290204.28,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1091,7657,354,40760,25764,2,96,2,1933.88,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1092,7657,354,40760,25764,2,67,2,406.12,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1093,7657,354,40760,25764,2,13,1,2340.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1094,7657,355,40760,25764,2,96,2,17355.37,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1095,7657,355,40760,25764,2,67,2,3644.63,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1096,7657,355,40760,25764,2,13,1,21000.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1097,7657,356,40760,25764,2,96,2,13107.44,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1098,7657,356,40760,25764,2,67,2,2752.56,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1099,7657,356,40760,25764,2,13,1,15860.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1100,7657,357,40760,25764,2,96,2,1933.88,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1101,7657,357,40760,25764,2,67,2,406.12,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1102,7657,357,40760,25764,2,13,1,2340.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1103,7657,358,40760,25764,2,96,2,298191.25,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1104,7657,358,40760,25764,2,67,2,62620.16,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1105,7657,358,40760,25764,2,13,1,360811.41,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1106,7657,359,40760,25764,2,96,2,10371.90,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1107,7657,359,40760,25764,2,67,2,2178.10,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1108,7657,359,40760,25764,2,13,1,12550.00,NULL,'2022-08-23 21:55:36','2022-08-23 21:55:36',NULL),(1109,7657,360,40760,25764,2,96,2,416991.00,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1110,7657,360,40760,25764,2,67,2,87568.11,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1111,7657,360,40760,25764,2,13,1,504559.11,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1112,7657,361,40760,25764,2,96,2,54917.36,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1113,7657,361,40760,25764,2,67,2,11532.64,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1114,7657,361,40760,25764,2,13,1,66450.00,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1115,7657,362,40760,25764,2,96,2,12066.12,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1116,7657,362,40760,25764,2,67,2,2533.88,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1117,7657,362,40760,25764,2,13,1,14600.00,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1118,7657,363,40760,25764,2,96,2,82644.62,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1119,7657,363,40760,25764,2,67,2,17355.38,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1120,7657,363,40760,25764,2,13,1,100000.00,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1121,7657,364,40760,25764,2,96,2,7388.42,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1122,7657,364,40760,25764,2,67,2,1551.58,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1123,7657,364,40760,25764,2,13,1,8940.00,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1124,7657,365,40760,25764,2,96,2,18297.52,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1125,7657,365,40760,25764,2,67,2,3842.48,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1126,7657,365,40760,25764,2,13,1,22140.00,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1127,7657,366,40760,25764,2,96,2,743.80,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1128,7657,366,40760,25764,2,67,2,156.20,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1129,7657,366,40760,25764,2,13,1,900.00,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1130,7657,367,40760,25764,2,96,2,8181.82,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1131,7657,367,40760,25764,2,67,2,1718.18,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1132,7657,367,40760,25764,2,13,1,9900.00,NULL,'2022-08-23 21:55:37','2022-08-23 21:55:37',NULL),(1133,7657,368,40760,25764,3,359,1,1329.00,NULL,'2022-08-23 22:00:42','2022-08-23 22:00:42',NULL),(1134,7657,368,40760,25764,3,57,2,1329.00,NULL,'2022-08-23 22:00:42','2022-08-23 22:00:42',NULL),(1135,7657,369,40760,25764,3,217,1,174200.90,NULL,'2022-08-23 22:01:21','2022-08-23 22:13:56','2022-08-23 22:13:56'),(1136,7657,369,40760,25764,3,68,1,18291.09,NULL,'2022-08-23 22:01:21','2022-08-23 22:13:56','2022-08-23 22:13:56'),(1137,7657,369,40760,25764,3,57,2,192491.99,NULL,'2022-08-23 22:01:21','2022-08-23 22:13:56','2022-08-23 22:13:56'),(1138,7657,370,40760,25764,3,250,1,8000.00,NULL,'2022-08-23 22:02:50','2022-08-23 22:02:50',NULL),(1139,7657,370,40760,25764,3,57,2,8000.00,NULL,'2022-08-23 22:02:50','2022-08-23 22:02:50',NULL),(1140,7657,371,40760,25764,3,390,1,5654751.13,NULL,'2022-08-23 22:13:08','2022-08-23 22:13:08',NULL),(1141,7657,371,40760,25764,3,68,1,593748.87,NULL,'2022-08-23 22:13:08','2022-08-23 22:13:08',NULL),(1142,7657,371,40760,25764,3,57,2,6248500.00,NULL,'2022-08-23 22:13:08','2022-08-23 22:13:08',NULL),(1143,7657,372,40760,25764,3,390,1,174200.90,NULL,'2022-08-23 22:13:56','2022-08-23 22:13:56',NULL),(1144,7657,372,40760,25764,3,68,1,18291.09,NULL,'2022-08-23 22:13:56','2022-08-23 22:13:56',NULL),(1145,7657,372,40760,25764,3,57,2,192491.99,NULL,'2022-08-23 22:13:56','2022-08-23 22:13:56',NULL),(1146,7657,373,40760,25764,3,217,1,10859.95,NULL,'2022-08-23 22:14:19','2022-08-23 22:14:19',NULL),(1147,7657,373,40760,25764,3,68,1,2280.59,NULL,'2022-08-23 22:14:19','2022-08-23 22:14:19',NULL),(1148,7657,373,40760,25764,3,217,1,359.46,NULL,'2022-08-23 22:14:19','2022-08-23 22:14:19',NULL),(1149,7657,373,40760,25764,3,57,2,13500.00,NULL,'2022-08-23 22:14:19','2022-08-23 22:14:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1150,7657,374,40760,25764,3,392,1,54936.83,NULL,'2022-08-23 22:30:26','2022-08-23 22:30:26',NULL),(1151,7657,374,40760,25764,3,68,1,11536.73,NULL,'2022-08-23 22:30:26','2022-08-23 22:30:26',NULL),(1152,7657,374,40760,25764,3,392,1,684.41,NULL,'2022-08-23 22:30:26','2022-08-23 22:30:26',NULL),(1153,7657,374,40760,25764,3,224,1,6000.03,NULL,'2022-08-23 22:30:26','2022-08-23 22:30:26',NULL),(1154,7657,374,40760,25764,3,57,2,73158.00,NULL,'2022-08-23 22:30:26','2022-08-23 22:30:26',NULL),(1155,7657,375,40760,25764,3,392,1,14479.56,NULL,'2022-08-23 22:31:54','2022-08-23 22:31:54',NULL),(1156,7657,375,40760,25764,3,68,1,3040.71,NULL,'2022-08-23 22:31:54','2022-08-23 22:31:54',NULL),(1157,7657,375,40760,25764,3,392,1,180.39,NULL,'2022-08-23 22:31:54','2022-08-23 22:31:54',NULL),(1158,7657,375,40760,25764,3,224,1,1581.41,NULL,'2022-08-23 22:31:54','2022-08-23 22:31:54',NULL),(1159,7657,375,40760,25764,3,57,2,19282.07,NULL,'2022-08-23 22:31:54','2022-08-23 22:31:54',NULL),(1160,7657,376,40760,25764,3,392,1,22618.13,NULL,'2022-08-23 22:33:15','2022-08-23 22:33:15',NULL),(1161,7657,376,40760,25764,3,68,1,4749.81,NULL,'2022-08-23 22:33:15','2022-08-23 22:33:15',NULL),(1162,7657,376,40760,25764,3,392,1,281.78,NULL,'2022-08-23 22:33:15','2022-08-23 22:33:15',NULL),(1163,7657,376,40760,25764,3,224,1,2470.28,NULL,'2022-08-23 22:33:15','2022-08-23 22:33:15',NULL),(1164,7657,376,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:33:15','2022-08-23 22:33:15',NULL),(1165,7657,377,40760,25764,3,392,1,22618.13,NULL,'2022-08-23 22:34:33','2022-08-23 22:34:33',NULL),(1166,7657,377,40760,25764,3,68,1,4749.81,NULL,'2022-08-23 22:34:33','2022-08-23 22:34:33',NULL),(1167,7657,377,40760,25764,3,392,1,281.78,NULL,'2022-08-23 22:34:33','2022-08-23 22:34:33',NULL),(1168,7657,377,40760,25764,3,224,1,2470.28,NULL,'2022-08-23 22:34:33','2022-08-23 22:34:33',NULL),(1169,7657,377,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:34:33','2022-08-23 22:34:33',NULL),(1170,7657,378,40760,25764,3,392,1,12534.39,NULL,'2022-08-23 22:35:35','2022-08-23 22:35:35',NULL),(1171,7657,378,40760,25764,3,68,1,2632.22,NULL,'2022-08-23 22:35:35','2022-08-23 22:35:35',NULL),(1172,7657,378,40760,25764,3,392,1,109.90,NULL,'2022-08-23 22:35:35','2022-08-23 22:35:35',NULL),(1173,7657,378,40760,25764,3,224,1,963.49,NULL,'2022-08-23 22:35:35','2022-08-23 22:35:35',NULL),(1174,7657,378,40760,25764,3,57,2,16240.00,NULL,'2022-08-23 22:35:35','2022-08-23 22:35:35',NULL),(1175,7657,379,40760,25764,3,392,1,22618.13,NULL,'2022-08-23 22:36:37','2022-08-23 22:36:37',NULL),(1176,7657,379,40760,25764,3,68,1,4749.81,NULL,'2022-08-23 22:36:37','2022-08-23 22:36:37',NULL),(1177,7657,379,40760,25764,3,392,1,281.78,NULL,'2022-08-23 22:36:37','2022-08-23 22:36:37',NULL),(1178,7657,379,40760,25764,3,224,1,2470.28,NULL,'2022-08-23 22:36:37','2022-08-23 22:36:37',NULL),(1179,7657,379,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:36:37','2022-08-23 22:36:37',NULL),(1180,7657,380,40760,25764,3,392,1,15667.98,NULL,'2022-08-23 22:37:33','2022-08-23 22:37:33',NULL),(1181,7657,380,40760,25764,3,68,1,3290.28,NULL,'2022-08-23 22:37:33','2022-08-23 22:37:33',NULL),(1182,7657,380,40760,25764,3,392,1,137.38,NULL,'2022-08-23 22:37:33','2022-08-23 22:37:33',NULL),(1183,7657,380,40760,25764,3,224,1,1204.36,NULL,'2022-08-23 22:37:33','2022-08-23 22:37:33',NULL),(1184,7657,380,40760,25764,3,57,2,20300.00,NULL,'2022-08-23 22:37:33','2022-08-23 22:37:33',NULL),(1185,7657,381,40760,25764,3,392,1,22618.13,NULL,'2022-08-23 22:38:42','2022-08-23 22:38:42',NULL),(1186,7657,381,40760,25764,3,68,1,4749.81,NULL,'2022-08-23 22:38:42','2022-08-23 22:38:42',NULL),(1187,7657,381,40760,25764,3,221,1,281.78,NULL,'2022-08-23 22:38:42','2022-08-23 22:38:42',NULL),(1188,7657,381,40760,25764,3,224,1,2470.28,NULL,'2022-08-23 22:38:42','2022-08-23 22:38:42',NULL),(1189,7657,381,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:38:42','2022-08-23 22:38:42',NULL);
INSERT INTO `balance_libro_details` VALUES (1190,7657,382,40760,25764,3,392,1,22627.59,NULL,'2022-08-23 22:39:41','2022-08-23 22:39:41',NULL),(1191,7657,382,40760,25764,3,68,1,4751.79,NULL,'2022-08-23 22:39:41','2022-08-23 22:39:41',NULL),(1192,7657,382,40760,25764,3,221,1,280.60,NULL,'2022-08-23 22:39:41','2022-08-23 22:39:41',NULL),(1193,7657,382,40760,25764,3,224,1,2460.02,NULL,'2022-08-23 22:39:41','2022-08-23 22:39:41',NULL),(1194,7657,382,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:39:41','2022-08-23 22:39:41',NULL),(1195,7657,383,40760,25764,3,392,1,22627.59,NULL,'2022-08-23 22:40:50','2022-08-23 22:40:50',NULL),(1196,7657,383,40760,25764,3,68,1,4751.79,NULL,'2022-08-23 22:40:50','2022-08-23 22:40:50',NULL),(1197,7657,383,40760,25764,3,221,1,280.60,NULL,'2022-08-23 22:40:50','2022-08-23 22:40:50',NULL),(1198,7657,383,40760,25764,3,224,1,2460.02,NULL,'2022-08-23 22:40:50','2022-08-23 22:40:50',NULL),(1199,7657,383,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:40:50','2022-08-23 22:40:50',NULL),(1200,7657,384,40760,25764,3,392,1,22627.59,NULL,'2022-08-23 22:41:57','2022-08-23 22:41:57',NULL),(1201,7657,384,40760,25764,3,68,1,4751.79,NULL,'2022-08-23 22:41:57','2022-08-23 22:41:57',NULL),(1202,7657,384,40760,25764,3,221,1,280.60,NULL,'2022-08-23 22:41:57','2022-08-23 22:41:57',NULL),(1203,7657,384,40760,25764,3,224,1,2460.02,NULL,'2022-08-23 22:41:57','2022-08-23 22:41:57',NULL),(1204,7657,384,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:41:57','2022-08-23 22:41:57',NULL),(1205,7657,385,40760,25764,3,392,1,32836.31,NULL,'2022-08-23 22:44:00','2022-08-23 22:44:00',NULL),(1206,7657,385,40760,25764,3,68,1,6895.63,NULL,'2022-08-23 22:44:00','2022-08-23 22:44:00',NULL),(1207,7657,385,40760,25764,3,221,1,407.20,NULL,'2022-08-23 22:44:00','2022-08-23 22:44:00',NULL),(1208,7657,385,40760,25764,3,224,1,3569.86,NULL,'2022-08-23 22:44:00','2022-08-23 22:44:00',NULL),(1209,7657,385,40760,25764,3,57,2,43709.00,NULL,'2022-08-23 22:44:00','2022-08-23 22:44:00',NULL),(1210,7657,386,40760,25764,3,392,1,22627.59,NULL,'2022-08-23 22:44:49','2022-08-23 22:44:49',NULL),(1211,7657,386,40760,25764,3,68,1,4751.79,NULL,'2022-08-23 22:44:49','2022-08-23 22:44:49',NULL),(1212,7657,386,40760,25764,3,221,1,280.60,NULL,'2022-08-23 22:44:49','2022-08-23 22:44:49',NULL),(1213,7657,386,40760,25764,3,224,1,2460.02,NULL,'2022-08-23 22:44:49','2022-08-23 22:44:49',NULL),(1214,7657,386,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:44:49','2022-08-23 22:44:49',NULL),(1215,7657,387,40760,25764,3,392,1,22627.59,NULL,'2022-08-23 22:45:40','2022-08-23 22:45:40',NULL),(1216,7657,387,40760,25764,3,68,1,4751.79,NULL,'2022-08-23 22:45:40','2022-08-23 22:45:40',NULL),(1217,7657,387,40760,25764,3,221,1,280.60,NULL,'2022-08-23 22:45:40','2022-08-23 22:45:40',NULL),(1218,7657,387,40760,25764,3,224,1,2460.02,NULL,'2022-08-23 22:45:40','2022-08-23 22:45:40',NULL),(1219,7657,387,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:45:40','2022-08-23 22:45:40',NULL),(1220,7657,388,40760,25764,3,392,1,22627.59,NULL,'2022-08-23 22:46:47','2022-08-23 22:46:47',NULL),(1221,7657,388,40760,25764,3,68,1,4751.79,NULL,'2022-08-23 22:46:47','2022-08-23 22:46:47',NULL),(1222,7657,388,40760,25764,3,221,1,280.60,NULL,'2022-08-23 22:46:47','2022-08-23 22:46:47',NULL),(1223,7657,388,40760,25764,3,224,1,2460.02,NULL,'2022-08-23 22:46:47','2022-08-23 22:46:47',NULL),(1224,7657,388,40760,25764,3,57,2,30120.00,NULL,'2022-08-23 22:46:47','2022-08-23 22:46:47',NULL),(1225,7657,389,40744,12129,2,96,2,1141897.56,NULL,'2022-08-24 11:44:29','2022-08-24 11:44:29',NULL),(1226,7657,389,40744,12129,2,67,2,239798.49,NULL,'2022-08-24 11:44:29','2022-08-24 11:44:29',NULL),(1227,7657,389,40744,12129,2,13,1,1381696.05,NULL,'2022-08-24 11:44:29','2022-08-24 11:44:29',NULL),(1228,7657,390,40744,12129,3,250,1,40000.00,NULL,'2022-08-24 11:45:25','2022-08-24 11:45:25',NULL),(1229,7657,390,40744,12129,3,57,2,40000.00,NULL,'2022-08-24 11:45:25','2022-08-24 11:45:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1230,7657,391,40744,12129,3,217,1,3003.34,NULL,'2022-08-26 15:52:28','2022-08-26 15:52:28',NULL),(1231,7657,391,40744,12129,3,68,1,630.70,NULL,'2022-08-26 15:52:28','2022-08-26 15:52:28',NULL),(1232,7657,391,40744,12129,3,221,1,27.37,NULL,'2022-08-26 15:52:28','2022-08-26 15:52:28',NULL),(1233,7657,391,40744,12129,3,224,1,239.99,NULL,'2022-08-26 15:52:28','2022-08-26 15:52:28',NULL),(1234,7657,391,40744,12129,3,57,2,3901.40,NULL,'2022-08-26 15:52:28','2022-08-26 15:52:28',NULL),(1235,7657,392,40744,12129,3,217,1,49529.34,NULL,'2022-08-26 15:55:47','2022-08-26 15:55:47',NULL),(1236,7657,392,40744,12129,3,68,1,10401.16,NULL,'2022-08-26 15:55:47','2022-08-26 15:55:47',NULL),(1237,7657,392,40744,12129,3,221,1,631.74,NULL,'2022-08-26 15:55:47','2022-08-26 15:55:47',NULL),(1238,7657,392,40744,12129,3,224,1,5538.45,NULL,'2022-08-26 15:55:47','2022-08-26 15:55:47',NULL),(1239,7657,392,40744,12129,3,238,1,1639.42,NULL,'2022-08-26 15:55:47','2022-08-26 15:55:47',NULL),(1240,7657,392,40744,12129,3,57,2,67740.11,NULL,'2022-08-26 15:55:47','2022-08-26 15:55:47',NULL),(1241,7657,393,40744,12129,3,217,1,11014.73,NULL,'2022-08-26 15:57:31','2022-08-26 15:57:31',NULL),(1242,7657,393,40744,12129,3,68,1,2313.09,NULL,'2022-08-26 15:57:31','2022-08-26 15:57:31',NULL),(1243,7657,393,40744,12129,3,221,1,140.50,NULL,'2022-08-26 15:57:31','2022-08-26 15:57:31',NULL),(1244,7657,393,40744,12129,3,224,1,1231.68,NULL,'2022-08-26 15:57:31','2022-08-26 15:57:31',NULL),(1245,7657,393,40744,12129,3,238,1,364.59,NULL,'2022-08-26 15:57:31','2022-08-26 15:57:31',NULL),(1246,7657,393,40744,12129,3,57,2,15064.59,NULL,'2022-08-26 15:57:31','2022-08-26 15:57:31',NULL),(1247,7657,394,40794,42440,3,359,1,487.25,NULL,'2023-04-23 19:01:27','2023-04-23 19:01:27',NULL),(1248,7657,394,40794,42440,3,68,1,131.56,NULL,'2023-04-23 19:01:27','2023-04-23 19:01:27',NULL),(1249,7657,394,40794,42440,3,359,1,1200.00,NULL,'2023-04-23 19:01:27','2023-04-23 19:01:27',NULL),(1250,7657,394,40794,42440,3,68,1,252.00,NULL,'2023-04-23 19:01:27','2023-04-23 19:01:27',NULL),(1251,7657,394,40794,42440,3,238,1,4.15,NULL,'2023-04-23 19:01:27','2023-04-23 19:01:27',NULL),(1252,7657,394,40794,42440,3,57,2,2074.96,NULL,'2023-04-23 19:01:27','2023-04-23 19:01:27',NULL),(1253,7657,395,40760,25773,3,217,1,6942.15,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1254,7657,395,40760,25773,3,68,1,1457.85,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1255,7657,395,40760,25773,3,57,2,8400.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1256,7657,396,40760,25773,3,217,1,1983.47,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1257,7657,396,40760,25773,3,68,1,416.53,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1258,7657,396,40760,25773,3,57,2,2400.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1259,7657,397,40760,25773,3,217,1,39917.36,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1260,7657,397,40760,25773,3,68,1,8382.65,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1261,7657,397,40760,25773,3,57,2,48300.01,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1262,7657,398,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1263,7657,398,40760,25773,3,68,1,607.44,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1264,7657,398,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1265,7657,399,40760,25773,3,217,1,2190.08,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1266,7657,399,40760,25773,3,68,1,459.92,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1267,7657,399,40760,25773,3,57,2,2650.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52');
INSERT INTO `balance_libro_details` VALUES (1268,7657,400,40760,25773,3,217,1,4628.10,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1269,7657,400,40760,25773,3,68,1,971.90,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1270,7657,400,40760,25773,3,57,2,5600.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1271,7657,401,40760,25773,3,217,1,29586.78,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1272,7657,401,40760,25773,3,68,1,6213.22,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1273,7657,401,40760,25773,3,57,2,35800.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1274,7657,402,40760,25773,3,217,1,32396.70,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1275,7657,402,40760,25773,3,68,1,6803.31,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1276,7657,402,40760,25773,3,57,2,39200.01,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:52','2023-04-24 21:08:52'),(1277,7657,403,40760,25773,3,217,1,4462.81,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1278,7657,403,40760,25773,3,68,1,937.19,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1279,7657,403,40760,25773,3,57,2,5400.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1280,7657,404,40760,25773,3,217,1,9504.13,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1281,7657,404,40760,25773,3,68,1,1995.87,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1282,7657,404,40760,25773,3,57,2,11500.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1283,7657,405,40760,25773,3,217,1,44354.73,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1284,7657,405,40760,25773,3,68,1,9314.32,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1285,7657,405,40760,25773,3,57,2,53669.05,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1286,7657,406,40760,25773,3,217,1,26243.44,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1287,7657,406,40760,25773,3,68,1,2755.56,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1288,7657,406,40760,25773,3,57,2,28999.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1289,7657,407,40760,25773,3,217,1,18347.11,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1290,7657,407,40760,25773,3,68,1,3852.89,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1291,7657,407,40760,25773,3,57,2,22200.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1292,7657,408,40760,25773,3,217,1,4958.68,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1293,7657,408,40760,25773,3,68,1,1041.32,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1294,7657,408,40760,25773,3,57,2,6000.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1295,7657,409,40760,25773,3,217,1,661.16,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1296,7657,409,40760,25773,3,68,1,138.84,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1297,7657,409,40760,25773,3,57,2,800.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1298,7657,410,40760,25773,3,217,1,4958.68,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1299,7657,410,40760,25773,3,68,1,1041.32,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1300,7657,410,40760,25773,3,57,2,6000.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1301,7657,411,40760,25773,3,217,1,661.16,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1302,7657,411,40760,25773,3,68,1,138.84,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro_details` VALUES (1303,7657,411,40760,25773,3,57,2,800.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1304,7657,412,40760,25773,3,217,1,950.41,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1305,7657,412,40760,25773,3,68,1,199.59,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1306,7657,412,40760,25773,3,57,2,1150.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1307,7657,413,40760,25773,3,217,1,63057.85,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1308,7657,413,40760,25773,3,68,1,13242.15,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1309,7657,413,40760,25773,3,57,2,76300.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1310,7657,414,40760,25773,3,217,1,2644.63,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1311,7657,414,40760,25773,3,68,1,555.37,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1312,7657,414,40760,25773,3,57,2,3200.00,NULL,'2023-04-24 21:00:33','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1313,7657,415,40760,25773,3,217,1,18429.75,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1314,7657,415,40760,25773,3,68,1,3870.25,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1315,7657,415,40760,25773,3,57,2,22300.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1316,7657,416,40760,25773,3,217,1,4307.96,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1317,7657,416,40760,25773,3,68,1,904.67,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1318,7657,416,40760,25773,3,217,1,161.55,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1319,7657,416,40760,25773,3,57,2,5374.18,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1320,7657,417,40760,25773,3,217,1,85948.76,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1321,7657,417,40760,25773,3,68,1,18049.24,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1322,7657,417,40760,25773,3,57,2,103998.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1323,7657,418,40760,25773,3,217,1,54298.64,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1324,7657,418,40760,25773,3,68,1,5701.36,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1325,7657,418,40760,25773,3,57,2,60000.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1326,7657,419,40760,25773,3,217,1,16115.70,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1327,7657,419,40760,25773,3,68,1,3384.30,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1328,7657,419,40760,25773,3,57,2,19500.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1329,7657,420,40760,25773,3,217,1,3223.14,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1330,7657,420,40760,25773,3,68,1,676.86,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1331,7657,420,40760,25773,3,57,2,3900.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1332,7657,421,40760,25773,3,217,1,10413.22,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1333,7657,421,40760,25773,3,68,1,2186.78,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1334,7657,421,40760,25773,3,57,2,12600.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1335,7657,422,40760,25773,3,217,1,1983.47,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1336,7657,422,40760,25773,3,68,1,416.53,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1337,7657,422,40760,25773,3,57,2,2400.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro_details` VALUES (1338,7657,423,40760,25773,3,217,1,32644.63,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1339,7657,423,40760,25773,3,68,1,6855.37,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1340,7657,423,40760,25773,3,57,2,39500.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1341,7657,424,40760,25773,3,217,1,12355.37,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1342,7657,424,40760,25773,3,68,1,2594.63,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1343,7657,424,40760,25773,3,57,2,14950.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1344,7657,425,40760,25773,3,217,1,13636.36,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1345,7657,425,40760,25773,3,68,1,2863.64,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1346,7657,425,40760,25773,3,57,2,16500.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1347,7657,426,40760,25773,3,217,1,19173.55,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1348,7657,426,40760,25773,3,68,1,4026.45,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1349,7657,426,40760,25773,3,57,2,23200.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1350,7657,427,40760,25773,3,217,1,329.68,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1351,7657,427,40760,25773,3,68,1,69.23,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1352,7657,427,40760,25773,3,57,2,398.91,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1353,7657,428,40760,25773,3,217,1,92561.32,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1354,7657,428,40760,25773,3,68,1,19437.88,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1355,7657,428,40760,25773,3,57,2,111999.20,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1356,7657,429,40760,25773,3,217,1,4132.23,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1357,7657,429,40760,25773,3,68,1,867.77,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1358,7657,429,40760,25773,3,57,2,5000.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1359,7657,430,40760,25773,3,217,1,46033.06,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1360,7657,430,40760,25773,3,68,1,9666.94,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1361,7657,430,40760,25773,3,57,2,55700.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1362,7657,431,40760,25773,3,217,1,9586.78,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1363,7657,431,40760,25773,3,68,1,2013.22,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1364,7657,431,40760,25773,3,57,2,11600.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1365,7657,432,40760,25773,3,217,1,12396.70,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1366,7657,432,40760,25773,3,68,1,2603.31,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1367,7657,432,40760,25773,3,57,2,15000.01,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1368,7657,433,40760,25773,3,217,1,4380.17,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1369,7657,433,40760,25773,3,68,1,919.84,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1370,7657,433,40760,25773,3,57,2,5300.01,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1371,7657,434,40760,25773,3,217,1,29375.82,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro_details` VALUES (1372,7657,434,40760,25773,3,68,1,6168.92,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1373,7657,434,40760,25773,3,57,2,35544.74,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1374,7657,435,40760,25773,3,217,1,28512.40,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1375,7657,435,40760,25773,3,68,1,5987.60,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1376,7657,435,40760,25773,3,57,2,34500.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1377,7657,436,40760,25773,3,217,1,3801.65,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1378,7657,436,40760,25773,3,68,1,798.35,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1379,7657,436,40760,25773,3,57,2,4600.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1380,7657,437,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1381,7657,437,40760,25773,3,68,1,520.66,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1382,7657,437,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1383,7657,438,40760,25773,3,217,1,743.80,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1384,7657,438,40760,25773,3,68,1,156.20,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1385,7657,438,40760,25773,3,57,2,900.00,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1386,7657,439,40760,25773,3,217,1,4545.46,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1387,7657,439,40760,25773,3,68,1,954.55,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1388,7657,439,40760,25773,3,57,2,5500.01,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1389,7657,440,40760,25773,3,217,1,52538.39,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1390,7657,440,40760,25773,3,68,1,11033.06,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1391,7657,440,40760,25773,3,217,1,7765.16,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1392,7657,440,40760,25773,3,57,2,71336.61,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1393,7657,441,40760,25773,3,217,1,6298.23,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1394,7657,441,40760,25773,3,68,1,1322.63,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1395,7657,441,40760,25773,3,57,2,7620.86,NULL,'2023-04-24 21:00:34','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1396,7657,442,40760,25773,3,217,1,2718.27,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1397,7657,442,40760,25773,3,68,1,570.84,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1398,7657,442,40760,25773,3,217,1,210.90,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1399,7657,442,40760,25773,3,57,2,3500.01,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1400,7657,443,40760,25773,3,217,1,9818.24,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1401,7657,443,40760,25773,3,68,1,2061.83,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1402,7657,443,40760,25773,3,57,2,11880.07,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1403,7657,444,40760,25773,3,250,1,29688.40,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1404,7657,444,40760,25773,3,57,2,29688.40,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1405,7657,445,40760,25773,3,217,1,15702.48,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1406,7657,445,40760,25773,3,68,1,3297.52,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro_details` VALUES (1407,7657,445,40760,25773,3,57,2,19000.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1408,7657,446,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1409,7657,446,40760,25773,3,68,1,520.66,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1410,7657,446,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1411,7657,447,40760,25773,3,217,1,16528.93,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1412,7657,447,40760,25773,3,68,1,3471.08,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1413,7657,447,40760,25773,3,57,2,20000.01,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1414,7657,448,40760,25773,3,217,1,5123.97,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1415,7657,448,40760,25773,3,68,1,1076.03,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1416,7657,448,40760,25773,3,57,2,6200.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1417,7657,449,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1418,7657,449,40760,25773,3,68,1,312.40,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1419,7657,449,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1420,7657,450,40760,25773,3,217,1,2148.76,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1421,7657,450,40760,25773,3,68,1,451.24,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1422,7657,450,40760,25773,3,57,2,2600.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1423,7657,451,40760,25773,3,217,1,19338.84,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1424,7657,451,40760,25773,3,68,1,4061.16,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1425,7657,451,40760,25773,3,57,2,23400.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1426,7657,452,40760,25773,3,217,1,73000.69,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1427,7657,452,40760,25773,3,68,1,15330.15,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1428,7657,452,40760,25773,3,217,1,10789.47,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1429,7657,452,40760,25773,3,57,2,99120.31,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1430,7657,453,40760,25773,3,217,1,552823.64,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1431,7657,453,40760,25773,3,68,1,116092.97,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1432,7657,453,40760,25773,3,217,1,18298.46,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1433,7657,453,40760,25773,3,57,2,687215.07,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1434,7657,454,40760,25773,3,217,1,2231.41,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1435,7657,454,40760,25773,3,68,1,468.60,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1436,7657,454,40760,25773,3,57,2,2700.01,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1437,7657,455,40760,25773,3,217,1,4297.52,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1438,7657,455,40760,25773,3,68,1,902.48,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1439,7657,455,40760,25773,3,57,2,5200.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1440,7657,456,40760,25773,3,217,1,991.74,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1441,7657,456,40760,25773,3,68,1,208.27,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro_details` VALUES (1442,7657,456,40760,25773,3,57,2,1200.01,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1443,7657,457,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1444,7657,457,40760,25773,3,68,1,260.33,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1445,7657,457,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1446,7657,458,40760,25773,3,217,1,3305.78,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1447,7657,458,40760,25773,3,68,1,694.21,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1448,7657,458,40760,25773,3,57,2,3999.99,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1449,7657,459,40760,25773,3,217,1,29008.27,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1450,7657,459,40760,25773,3,68,1,6091.74,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1451,7657,459,40760,25773,3,57,2,35100.01,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1452,7657,460,40760,25773,3,217,1,5950.41,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1453,7657,460,40760,25773,3,68,1,1249.59,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1454,7657,460,40760,25773,3,57,2,7200.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1455,7657,461,40760,25773,3,217,1,12892.56,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1456,7657,461,40760,25773,3,68,1,2707.44,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1457,7657,461,40760,25773,3,57,2,15600.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1458,7657,462,40760,25773,3,217,1,3057.85,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1459,7657,462,40760,25773,3,68,1,642.15,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1460,7657,462,40760,25773,3,57,2,3700.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1461,7657,463,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1462,7657,463,40760,25773,3,68,1,607.44,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1463,7657,463,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1464,7657,464,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1465,7657,464,40760,25773,3,68,1,607.44,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1466,7657,464,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1467,7657,465,40760,25773,3,217,1,1322.31,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1468,7657,465,40760,25773,3,68,1,277.69,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1469,7657,465,40760,25773,3,57,2,1600.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1470,7657,466,40760,25773,3,217,1,11262.20,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1471,7657,466,40760,25773,3,68,1,2365.06,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1472,7657,466,40760,25773,3,57,2,13627.26,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1473,7657,467,40760,25773,3,217,1,24355.18,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1474,7657,467,40760,25773,3,68,1,5114.59,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1475,7657,467,40760,25773,3,57,2,29469.77,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1476,7657,468,40760,25773,3,217,1,13395.00,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro_details` VALUES (1477,7657,468,40760,25773,3,68,1,2812.95,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1478,7657,468,40760,25773,3,57,2,16207.95,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1479,7657,469,40760,25773,3,217,1,32292.15,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1480,7657,469,40760,25773,3,68,1,6781.34,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1481,7657,469,40760,25773,3,217,1,1327.21,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1482,7657,469,40760,25773,3,57,2,40400.70,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1483,7657,470,40760,25773,3,217,1,11535.87,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1484,7657,470,40760,25773,3,68,1,2422.53,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1485,7657,470,40760,25773,3,217,1,474.13,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1486,7657,470,40760,25773,3,57,2,14432.53,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1487,7657,471,40760,25773,3,217,1,92470.54,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1488,7657,471,40760,25773,3,68,1,19418.81,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1489,7657,471,40760,25773,3,217,1,3060.77,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1490,7657,471,40760,25773,3,57,2,114950.12,NULL,'2023-04-24 21:00:35','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1491,7657,472,40760,25773,3,217,1,5950.41,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1492,7657,472,40760,25773,3,68,1,1249.59,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1493,7657,472,40760,25773,3,57,2,7200.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1494,7657,473,40760,25773,3,217,1,3223.14,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1495,7657,473,40760,25773,3,68,1,676.86,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1496,7657,473,40760,25773,3,57,2,3900.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1497,7657,474,40760,25773,3,217,1,991.74,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1498,7657,474,40760,25773,3,68,1,208.27,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1499,7657,474,40760,25773,3,57,2,1200.01,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1500,7657,475,40760,25773,3,217,1,2975.21,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1501,7657,475,40760,25773,3,68,1,624.79,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1502,7657,475,40760,25773,3,57,2,3600.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1503,7657,476,40760,25773,3,217,1,1818.18,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1504,7657,476,40760,25773,3,68,1,381.82,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1505,7657,476,40760,25773,3,57,2,2200.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1506,7657,477,40760,25773,3,217,1,6033.06,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1507,7657,477,40760,25773,3,68,1,1266.94,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1508,7657,477,40760,25773,3,57,2,7300.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1509,7657,478,40760,25773,3,217,1,28453.91,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1510,7657,478,40760,25773,3,68,1,5975.33,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1511,7657,478,40760,25773,3,57,2,34429.24,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53');
INSERT INTO `balance_libro_details` VALUES (1512,7657,479,40760,25773,3,217,1,142314.13,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1513,7657,479,40760,25773,3,68,1,29885.97,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1514,7657,479,40760,25773,3,217,1,5849.11,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1515,7657,479,40760,25773,3,57,2,178049.21,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1516,7657,480,40760,25773,3,217,1,11652.89,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1517,7657,480,40760,25773,3,68,1,2447.11,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1518,7657,480,40760,25773,3,57,2,14100.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1519,7657,481,40760,25773,3,217,1,1305.79,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1520,7657,481,40760,25773,3,68,1,274.22,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1521,7657,481,40760,25773,3,57,2,1580.01,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:53','2023-04-24 21:08:53'),(1522,7657,482,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1523,7657,482,40760,25773,3,68,1,260.33,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1524,7657,482,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1525,7657,483,40760,25773,3,217,1,4132.23,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1526,7657,483,40760,25773,3,68,1,867.77,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1527,7657,483,40760,25773,3,57,2,5000.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1528,7657,484,40760,25773,3,217,1,12892.56,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1529,7657,484,40760,25773,3,68,1,2707.44,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1530,7657,484,40760,25773,3,57,2,15600.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1531,7657,485,40760,25773,3,217,1,6694.22,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1532,7657,485,40760,25773,3,68,1,1405.79,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1533,7657,485,40760,25773,3,57,2,8100.01,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1534,7657,486,40760,25773,3,217,1,7039.86,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1535,7657,486,40760,25773,3,68,1,1478.37,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1536,7657,486,40760,25773,3,57,2,8518.23,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1537,7657,487,40760,25773,3,217,1,9818.20,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1538,7657,487,40760,25773,3,68,1,2061.82,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1539,7657,487,40760,25773,3,57,2,11880.02,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1540,7657,488,40760,25773,3,217,1,578.51,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1541,7657,488,40760,25773,3,68,1,121.49,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1542,7657,488,40760,25773,3,57,2,700.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1543,7657,489,40760,25773,3,217,1,5206.61,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1544,7657,489,40760,25773,3,68,1,1093.39,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1545,7657,489,40760,25773,3,57,2,6300.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1546,7657,490,40760,25773,3,217,1,8016.53,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54');
INSERT INTO `balance_libro_details` VALUES (1547,7657,490,40760,25773,3,68,1,1683.47,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1548,7657,490,40760,25773,3,57,2,9700.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1549,7657,491,40760,25773,3,217,1,23884.30,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1550,7657,491,40760,25773,3,68,1,5015.70,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1551,7657,491,40760,25773,3,57,2,28900.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1552,7657,492,40760,25773,3,217,1,6280.99,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1553,7657,492,40760,25773,3,68,1,1319.01,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1554,7657,492,40760,25773,3,57,2,7600.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1555,7657,493,40760,25773,3,217,1,4049.59,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1556,7657,493,40760,25773,3,68,1,850.41,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1557,7657,493,40760,25773,3,57,2,4900.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1558,7657,494,40760,25773,3,217,1,10165.29,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1559,7657,494,40760,25773,3,68,1,2134.71,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1560,7657,494,40760,25773,3,57,2,12300.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1561,7657,495,40760,25773,3,217,1,661.16,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1562,7657,495,40760,25773,3,68,1,138.84,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1563,7657,495,40760,25773,3,57,2,800.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1564,7657,496,40760,25773,3,217,1,15289.26,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1565,7657,496,40760,25773,3,68,1,3210.74,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1566,7657,496,40760,25773,3,57,2,18500.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1567,7657,497,40760,25773,3,217,1,3305.79,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1568,7657,497,40760,25773,3,68,1,694.22,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1569,7657,497,40760,25773,3,57,2,4000.01,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1570,7657,498,40760,25773,3,217,1,10165.29,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1571,7657,498,40760,25773,3,68,1,2134.71,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1572,7657,498,40760,25773,3,57,2,12300.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1573,7657,499,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1574,7657,499,40760,25773,3,68,1,260.33,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1575,7657,499,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 21:00:36','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1576,7657,500,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1577,7657,500,40760,25773,3,68,1,312.40,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1578,7657,500,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1579,7657,501,40760,25773,3,217,1,661.16,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1580,7657,501,40760,25773,3,68,1,138.84,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1581,7657,501,40760,25773,3,57,2,800.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54');
INSERT INTO `balance_libro_details` VALUES (1582,7657,502,40760,25773,3,217,1,9504.13,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1583,7657,502,40760,25773,3,68,1,1995.87,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1584,7657,502,40760,25773,3,57,2,11500.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1585,7657,503,40760,25773,3,217,1,1652.89,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1586,7657,503,40760,25773,3,68,1,347.11,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1587,7657,503,40760,25773,3,57,2,2000.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1588,7657,504,40760,25773,3,217,1,7355.37,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1589,7657,504,40760,25773,3,68,1,1544.63,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1590,7657,504,40760,25773,3,57,2,8900.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1591,7657,505,40760,25773,3,217,1,661.16,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1592,7657,505,40760,25773,3,68,1,138.84,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1593,7657,505,40760,25773,3,57,2,800.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1594,7657,506,40760,25773,3,217,1,454.55,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1595,7657,506,40760,25773,3,68,1,95.46,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1596,7657,506,40760,25773,3,57,2,550.01,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1597,7657,507,40760,25773,3,217,1,9008.27,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1598,7657,507,40760,25773,3,68,1,1891.74,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1599,7657,507,40760,25773,3,57,2,10900.01,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1600,7657,508,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1601,7657,508,40760,25773,3,68,1,312.40,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1602,7657,508,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1603,7657,509,40760,25773,3,217,1,3636.36,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1604,7657,509,40760,25773,3,68,1,763.64,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1605,7657,509,40760,25773,3,57,2,4400.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1606,7657,510,40760,25773,3,217,1,9090.91,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1607,7657,510,40760,25773,3,68,1,1909.09,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1608,7657,510,40760,25773,3,57,2,11000.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1609,7657,511,40760,25773,3,217,1,20991.74,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1610,7657,511,40760,25773,3,68,1,4408.27,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1611,7657,511,40760,25773,3,57,2,25400.01,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1612,7657,512,40760,25773,3,217,1,18016.53,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1613,7657,512,40760,25773,3,68,1,3783.47,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1614,7657,512,40760,25773,3,57,2,21800.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1615,7657,513,40760,25773,3,217,1,4297.52,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1616,7657,513,40760,25773,3,68,1,902.48,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54');
INSERT INTO `balance_libro_details` VALUES (1617,7657,513,40760,25773,3,57,2,5200.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1618,7657,514,40760,25773,3,217,1,33719.01,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1619,7657,514,40760,25773,3,68,1,7080.99,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1620,7657,514,40760,25773,3,57,2,40800.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1621,7657,515,40760,25773,3,217,1,30018.78,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1622,7657,515,40760,25773,3,68,1,6303.94,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1623,7657,515,40760,25773,3,217,1,17.66,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1624,7657,515,40760,25773,3,57,2,36340.38,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1625,7657,516,40760,25773,3,217,1,9504.13,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1626,7657,516,40760,25773,3,68,1,1995.87,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1627,7657,516,40760,25773,3,57,2,11500.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1628,7657,517,40760,25773,3,217,1,4793.39,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1629,7657,517,40760,25773,3,68,1,1006.61,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1630,7657,517,40760,25773,3,57,2,5800.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1631,7657,518,40760,25773,3,217,1,6198.35,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1632,7657,518,40760,25773,3,68,1,1301.65,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1633,7657,518,40760,25773,3,57,2,7500.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1634,7657,519,40760,25773,3,217,1,5289.26,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1635,7657,519,40760,25773,3,68,1,1110.74,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1636,7657,519,40760,25773,3,57,2,6400.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1637,7657,520,40760,25773,3,217,1,67938.71,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1638,7657,520,40760,25773,3,68,1,14267.13,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1639,7657,520,40760,25773,3,217,1,2792.28,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1640,7657,520,40760,25773,3,57,2,84998.12,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1641,7657,521,40760,25773,3,217,1,2314.05,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1642,7657,521,40760,25773,3,68,1,485.95,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1643,7657,521,40760,25773,3,57,2,2800.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1644,7657,522,40760,25773,3,217,1,3801.65,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1645,7657,522,40760,25773,3,68,1,798.35,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1646,7657,522,40760,25773,3,57,2,4600.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1647,7657,523,40760,25773,3,217,1,8842.98,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1648,7657,523,40760,25773,3,68,1,1857.03,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1649,7657,523,40760,25773,3,57,2,10700.01,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1650,7657,524,40760,25773,3,217,1,4876.03,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1651,7657,524,40760,25773,3,68,1,1023.97,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54');
INSERT INTO `balance_libro_details` VALUES (1652,7657,524,40760,25773,3,57,2,5900.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1653,7657,525,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1654,7657,525,40760,25773,3,68,1,780.99,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1655,7657,525,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1656,7657,526,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1657,7657,526,40760,25773,3,68,1,607.44,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1658,7657,526,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1659,7657,527,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1660,7657,527,40760,25773,3,68,1,780.99,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1661,7657,527,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 21:00:37','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1662,7657,528,40760,25773,3,217,1,18842.98,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1663,7657,528,40760,25773,3,68,1,3957.03,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1664,7657,528,40760,25773,3,57,2,22800.01,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1665,7657,529,40760,25773,3,217,1,7933.89,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1666,7657,529,40760,25773,3,68,1,1666.12,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1667,7657,529,40760,25773,3,57,2,9600.01,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1668,7657,530,40760,25773,3,217,1,15289.26,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1669,7657,530,40760,25773,3,68,1,3210.74,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1670,7657,530,40760,25773,3,57,2,18500.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1671,7657,531,40760,25773,3,217,1,7143.05,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1672,7657,531,40760,25773,3,68,1,1500.04,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1673,7657,531,40760,25773,3,217,1,57.15,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1674,7657,531,40760,25773,3,57,2,8700.24,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1675,7657,532,40760,25773,3,217,1,22982.25,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1676,7657,532,40760,25773,3,68,1,4826.27,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1677,7657,532,40760,25773,3,57,2,27808.52,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1678,7657,533,40760,25773,3,217,1,413.22,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1679,7657,533,40760,25773,3,68,1,86.78,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1680,7657,533,40760,25773,3,57,2,500.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1681,7657,534,40760,25773,3,217,1,1570.25,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1682,7657,534,40760,25773,3,68,1,329.75,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1683,7657,534,40760,25773,3,57,2,1900.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1684,7657,535,40760,25773,3,217,1,4628.10,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1685,7657,535,40760,25773,3,68,1,971.90,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1686,7657,535,40760,25773,3,57,2,5600.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54');
INSERT INTO `balance_libro_details` VALUES (1687,7657,536,40760,25773,3,217,1,5206.61,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1688,7657,536,40760,25773,3,68,1,1093.39,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1689,7657,536,40760,25773,3,57,2,6300.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1690,7657,537,40760,25773,3,217,1,4958.68,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1691,7657,537,40760,25773,3,68,1,1041.32,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1692,7657,537,40760,25773,3,57,2,6000.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1693,7657,538,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1694,7657,538,40760,25773,3,68,1,780.99,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1695,7657,538,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1696,7657,539,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1697,7657,539,40760,25773,3,68,1,607.44,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1698,7657,539,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:54','2023-04-24 21:08:54'),(1699,7657,540,40760,25773,3,217,1,3884.30,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1700,7657,540,40760,25773,3,68,1,815.70,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1701,7657,540,40760,25773,3,57,2,4700.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1702,7657,541,40760,25773,3,217,1,7438.02,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1703,7657,541,40760,25773,3,68,1,1561.98,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1704,7657,541,40760,25773,3,57,2,9000.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1705,7657,542,40760,25773,3,217,1,6363.64,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1706,7657,542,40760,25773,3,68,1,1336.36,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1707,7657,542,40760,25773,3,57,2,7700.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1708,7657,543,40760,25773,3,217,1,7107.44,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1709,7657,543,40760,25773,3,68,1,1492.56,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1710,7657,543,40760,25773,3,57,2,8600.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1711,7657,544,40760,25773,3,217,1,9256.20,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1712,7657,544,40760,25773,3,68,1,1943.80,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1713,7657,544,40760,25773,3,57,2,11200.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1714,7657,545,40760,25773,3,217,1,1735.54,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1715,7657,545,40760,25773,3,68,1,364.46,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1716,7657,545,40760,25773,3,57,2,2100.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1717,7657,546,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1718,7657,546,40760,25773,3,68,1,260.33,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1719,7657,546,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1720,7657,547,40760,25773,3,217,1,5371.90,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1721,7657,547,40760,25773,3,68,1,1128.10,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro_details` VALUES (1722,7657,547,40760,25773,3,57,2,6500.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1723,7657,548,40760,25773,3,217,1,991.74,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1724,7657,548,40760,25773,3,68,1,208.27,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1725,7657,548,40760,25773,3,57,2,1200.01,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1726,7657,549,40760,25773,3,217,1,4297.52,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1727,7657,549,40760,25773,3,68,1,902.48,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1728,7657,549,40760,25773,3,57,2,5200.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1729,7657,550,40760,25773,3,217,1,10661.16,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1730,7657,550,40760,25773,3,68,1,2238.84,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1731,7657,550,40760,25773,3,57,2,12900.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1732,7657,551,40760,25773,3,217,1,6280.99,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1733,7657,551,40760,25773,3,68,1,1319.01,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1734,7657,551,40760,25773,3,57,2,7600.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1735,7657,552,40760,25773,3,217,1,3057.85,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1736,7657,552,40760,25773,3,68,1,642.15,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1737,7657,552,40760,25773,3,57,2,3700.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1738,7657,553,40760,25773,3,217,1,9586.78,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1739,7657,553,40760,25773,3,68,1,2013.22,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1740,7657,553,40760,25773,3,57,2,11600.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1741,7657,554,40760,25773,3,217,1,2644.63,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1742,7657,554,40760,25773,3,68,1,555.37,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1743,7657,554,40760,25773,3,57,2,3200.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1744,7657,555,40760,25773,3,217,1,4132.23,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1745,7657,555,40760,25773,3,68,1,867.77,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1746,7657,555,40760,25773,3,57,2,5000.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1747,7657,556,40760,25773,3,217,1,661.16,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1748,7657,556,40760,25773,3,68,1,138.84,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1749,7657,556,40760,25773,3,57,2,800.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1750,7657,557,40760,25773,3,217,1,5785.12,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1751,7657,557,40760,25773,3,68,1,1214.88,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1752,7657,557,40760,25773,3,57,2,7000.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1753,7657,558,40760,25773,3,217,1,826.45,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1754,7657,558,40760,25773,3,68,1,173.55,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1755,7657,558,40760,25773,3,57,2,1000.00,NULL,'2023-04-24 21:00:38','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1756,7657,559,40760,25773,3,217,1,14119.01,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro_details` VALUES (1757,7657,559,40760,25773,3,68,1,2964.99,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1758,7657,559,40760,25773,3,217,1,467.34,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1759,7657,559,40760,25773,3,57,2,17551.34,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1760,7657,560,40760,25773,3,217,1,16851.56,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1761,7657,560,40760,25773,3,68,1,3538.83,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1762,7657,560,40760,25773,3,217,1,134.81,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1763,7657,560,40760,25773,3,57,2,20525.20,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1764,7657,561,40760,25773,3,217,1,2644.63,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1765,7657,561,40760,25773,3,68,1,555.37,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1766,7657,561,40760,25773,3,57,2,3200.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1767,7657,562,40760,25773,3,217,1,3801.65,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1768,7657,562,40760,25773,3,68,1,798.35,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1769,7657,562,40760,25773,3,57,2,4600.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1770,7657,563,40760,25773,3,217,1,2396.70,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1771,7657,563,40760,25773,3,68,1,503.31,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1772,7657,563,40760,25773,3,57,2,2900.01,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1773,7657,564,40760,25773,3,217,1,1322.31,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1774,7657,564,40760,25773,3,68,1,277.69,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1775,7657,564,40760,25773,3,57,2,1600.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1776,7657,565,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1777,7657,565,40760,25773,3,68,1,780.99,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1778,7657,565,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1779,7657,566,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1780,7657,566,40760,25773,3,68,1,780.99,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1781,7657,566,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1782,7657,567,40760,25773,3,217,1,826.45,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1783,7657,567,40760,25773,3,68,1,173.55,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1784,7657,567,40760,25773,3,57,2,1000.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1785,7657,568,40760,25773,3,217,1,13636.36,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1786,7657,568,40760,25773,3,68,1,2863.64,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1787,7657,568,40760,25773,3,57,2,16500.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1788,7657,569,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1789,7657,569,40760,25773,3,68,1,260.33,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1790,7657,569,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1791,7657,570,40760,25773,3,217,1,4049.59,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro_details` VALUES (1792,7657,570,40760,25773,3,68,1,850.41,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1793,7657,570,40760,25773,3,57,2,4900.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1794,7657,571,40760,25773,3,217,1,3636.36,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1795,7657,571,40760,25773,3,68,1,763.64,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1796,7657,571,40760,25773,3,57,2,4400.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1797,7657,572,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1798,7657,572,40760,25773,3,68,1,520.66,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1799,7657,572,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1800,7657,573,40760,25773,3,217,1,3305.79,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1801,7657,573,40760,25773,3,68,1,694.22,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1802,7657,573,40760,25773,3,57,2,4000.01,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1803,7657,574,40760,25773,3,217,1,10206.61,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1804,7657,574,40760,25773,3,68,1,2143.39,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1805,7657,574,40760,25773,3,57,2,12350.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1806,7657,575,40760,25773,3,217,1,1570.25,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1807,7657,575,40760,25773,3,68,1,329.75,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1808,7657,575,40760,25773,3,57,2,1900.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1809,7657,576,40760,25773,3,217,1,15371.90,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1810,7657,576,40760,25773,3,68,1,3228.10,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1811,7657,576,40760,25773,3,57,2,18600.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1812,7657,577,40760,25773,3,217,1,2644.63,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1813,7657,577,40760,25773,3,68,1,555.37,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1814,7657,577,40760,25773,3,57,2,3200.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1815,7657,578,40760,25773,3,217,1,3471.08,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1816,7657,578,40760,25773,3,68,1,728.93,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1817,7657,578,40760,25773,3,57,2,4200.01,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1818,7657,579,40760,25773,3,217,1,7024.79,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1819,7657,579,40760,25773,3,68,1,1475.21,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1820,7657,579,40760,25773,3,57,2,8500.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1821,7657,580,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1822,7657,580,40760,25773,3,68,1,520.66,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1823,7657,580,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1824,7657,581,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1825,7657,581,40760,25773,3,68,1,607.44,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1826,7657,581,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro_details` VALUES (1827,7657,582,40760,25773,3,217,1,826.45,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1828,7657,582,40760,25773,3,68,1,173.55,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1829,7657,582,40760,25773,3,57,2,1000.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1830,7657,583,40760,25773,3,217,1,8264.46,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1831,7657,583,40760,25773,3,68,1,1735.54,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1832,7657,583,40760,25773,3,57,2,10000.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1833,7657,584,40760,25773,3,217,1,2396.70,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1834,7657,584,40760,25773,3,68,1,503.31,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1835,7657,584,40760,25773,3,57,2,2900.01,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1836,7657,585,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1837,7657,585,40760,25773,3,68,1,520.66,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1838,7657,585,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1839,7657,586,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1840,7657,586,40760,25773,3,68,1,312.40,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1841,7657,586,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1842,7657,587,40760,25773,3,217,1,1652.89,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1843,7657,587,40760,25773,3,68,1,347.11,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1844,7657,587,40760,25773,3,57,2,2000.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1845,7657,588,40760,25773,3,217,1,10826.45,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1846,7657,588,40760,25773,3,68,1,2273.55,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1847,7657,588,40760,25773,3,57,2,13100.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1848,7657,589,40760,25773,3,217,1,3553.72,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1849,7657,589,40760,25773,3,68,1,746.28,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1850,7657,589,40760,25773,3,57,2,4300.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1851,7657,590,40760,25773,3,217,1,11818.18,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1852,7657,590,40760,25773,3,68,1,2481.82,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1853,7657,590,40760,25773,3,57,2,14300.00,NULL,'2023-04-24 21:00:39','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1854,7657,591,40760,25773,3,217,1,2975.21,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1855,7657,591,40760,25773,3,68,1,624.79,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1856,7657,591,40760,25773,3,57,2,3600.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1857,7657,592,40760,25773,3,217,1,2975.21,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1858,7657,592,40760,25773,3,68,1,624.79,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1859,7657,592,40760,25773,3,57,2,3600.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1860,7657,593,40760,25773,3,217,1,3305.79,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1861,7657,593,40760,25773,3,68,1,694.22,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro_details` VALUES (1862,7657,593,40760,25773,3,57,2,4000.01,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1863,7657,594,40760,25773,3,250,1,28050.45,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1864,7657,594,40760,25773,3,57,2,28050.45,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1865,7657,595,40760,25773,3,217,1,73028.09,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1866,7657,595,40760,25773,3,68,1,15335.90,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1867,7657,595,40760,25773,3,57,2,88363.99,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1868,7657,596,40760,25773,3,217,1,6893.25,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1869,7657,596,40760,25773,3,68,1,1447.58,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1870,7657,596,40760,25773,3,57,2,8340.83,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1871,7657,597,40760,25773,3,217,1,21784.65,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1872,7657,597,40760,25773,3,68,1,4574.77,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1873,7657,597,40760,25773,3,217,1,3143.05,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1874,7657,597,40760,25773,3,57,2,29502.47,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1875,7657,598,40760,25773,3,217,1,145195.42,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1876,7657,598,40760,25773,3,68,1,30491.04,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1877,7657,598,40760,25773,3,217,1,5894.93,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1878,7657,598,40760,25773,3,57,2,181581.39,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1879,7657,599,40760,25773,3,217,1,4958.68,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1880,7657,599,40760,25773,3,68,1,1041.32,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1881,7657,599,40760,25773,3,57,2,6000.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1882,7657,600,40760,25773,3,217,1,8760.33,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1883,7657,600,40760,25773,3,68,1,1839.67,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1884,7657,600,40760,25773,3,57,2,10600.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1885,7657,601,40760,25773,3,217,1,28512.40,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1886,7657,601,40760,25773,3,68,1,5987.60,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1887,7657,601,40760,25773,3,57,2,34500.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1888,7657,602,40760,25773,3,217,1,3471.08,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1889,7657,602,40760,25773,3,68,1,728.93,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1890,7657,602,40760,25773,3,57,2,4200.01,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1891,7657,603,40760,25773,3,217,1,2066.12,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1892,7657,603,40760,25773,3,68,1,433.89,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1893,7657,603,40760,25773,3,57,2,2500.01,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1894,7657,604,40760,25773,3,217,1,5785.12,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1895,7657,604,40760,25773,3,68,1,1214.88,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55');
INSERT INTO `balance_libro_details` VALUES (1896,7657,604,40760,25773,3,57,2,7000.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:55','2023-04-24 21:08:55'),(1897,7657,605,40760,25773,3,217,1,3884.30,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1898,7657,605,40760,25773,3,68,1,815.70,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1899,7657,605,40760,25773,3,57,2,4700.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1900,7657,606,40760,25773,3,217,1,66958.66,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1901,7657,606,40760,25773,3,68,1,14000.21,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1902,7657,606,40760,25773,3,217,1,535.67,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1903,7657,606,40760,25773,3,57,2,81494.54,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1904,7657,607,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1905,7657,607,40760,25773,3,68,1,520.66,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1906,7657,607,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1907,7657,608,40760,25773,3,217,1,7768.60,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1908,7657,608,40760,25773,3,68,1,1631.41,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1909,7657,608,40760,25773,3,57,2,9400.01,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1910,7657,609,40760,25773,3,217,1,4628.10,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1911,7657,609,40760,25773,3,68,1,971.90,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1912,7657,609,40760,25773,3,57,2,5600.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1913,7657,610,40760,25773,3,217,1,3884.30,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1914,7657,610,40760,25773,3,68,1,815.70,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1915,7657,610,40760,25773,3,57,2,4700.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1916,7657,611,40760,25773,3,217,1,2231.41,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1917,7657,611,40760,25773,3,68,1,468.60,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1918,7657,611,40760,25773,3,57,2,2700.01,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1919,7657,612,40760,25773,3,217,1,3884.30,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1920,7657,612,40760,25773,3,68,1,815.70,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1921,7657,612,40760,25773,3,57,2,4700.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1922,7657,613,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1923,7657,613,40760,25773,3,68,1,780.99,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1924,7657,613,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1925,7657,614,40760,25773,3,217,1,1652.89,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1926,7657,614,40760,25773,3,68,1,347.11,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1927,7657,614,40760,25773,3,57,2,2000.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1928,7657,615,40760,25773,3,217,1,3305.79,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1929,7657,615,40760,25773,3,68,1,694.22,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1930,7657,615,40760,25773,3,57,2,4000.01,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56');
INSERT INTO `balance_libro_details` VALUES (1931,7657,616,40760,25773,3,217,1,661.16,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1932,7657,616,40760,25773,3,68,1,138.84,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1933,7657,616,40760,25773,3,57,2,800.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1934,7657,617,40760,25773,3,217,1,7272.73,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1935,7657,617,40760,25773,3,68,1,1527.27,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1936,7657,617,40760,25773,3,57,2,8800.00,NULL,'2023-04-24 21:00:40','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1937,7657,618,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1938,7657,618,40760,25773,3,68,1,780.99,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1939,7657,618,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1940,7657,619,40760,25773,3,217,1,661.16,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1941,7657,619,40760,25773,3,68,1,138.84,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1942,7657,619,40760,25773,3,57,2,800.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1943,7657,620,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1944,7657,620,40760,25773,3,68,1,312.40,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1945,7657,620,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1946,7657,621,40760,25773,3,217,1,2727.27,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1947,7657,621,40760,25773,3,68,1,572.73,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1948,7657,621,40760,25773,3,57,2,3300.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1949,7657,622,40760,25773,3,217,1,2339.07,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1950,7657,622,40760,25773,3,68,1,491.21,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1951,7657,622,40760,25773,3,217,1,169.72,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1952,7657,622,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1953,7657,623,40760,25773,3,217,2,6854.62,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1954,7657,623,40760,25773,3,67,2,1439.47,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1955,7657,623,40760,25773,3,57,1,8294.09,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1956,7657,624,40760,25773,3,217,1,310549.21,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1957,7657,624,40760,25773,3,68,1,65215.33,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1958,7657,624,40760,25773,3,217,1,10279.18,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1959,7657,624,40760,25773,3,57,2,386043.72,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1960,7657,625,40760,25773,3,217,1,49669.42,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1961,7657,625,40760,25773,3,68,1,10430.58,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1962,7657,625,40760,25773,3,57,2,60100.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1963,7657,626,40760,25773,3,217,1,5661.16,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1964,7657,626,40760,25773,3,68,1,1188.84,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1965,7657,626,40760,25773,3,57,2,6850.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56');
INSERT INTO `balance_libro_details` VALUES (1966,7657,627,40760,25773,3,217,1,61200.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1967,7657,627,40760,25773,3,68,1,12852.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1968,7657,627,40760,25773,3,217,1,489.60,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1969,7657,627,40760,25773,3,57,2,74541.60,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1970,7657,628,40760,25773,3,217,1,55900.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1971,7657,628,40760,25773,3,68,1,11739.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1972,7657,628,40760,25773,3,217,1,447.20,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1973,7657,628,40760,25773,3,57,2,68086.20,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1974,7657,629,40760,25773,3,217,1,4090.91,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1975,7657,629,40760,25773,3,68,1,859.09,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1976,7657,629,40760,25773,3,57,2,4950.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1977,7657,630,40760,25773,3,217,1,495.87,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1978,7657,630,40760,25773,3,68,1,104.13,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1979,7657,630,40760,25773,3,57,2,600.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1980,7657,631,40760,25773,3,217,1,81200.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1981,7657,631,40760,25773,3,68,1,17052.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1982,7657,631,40760,25773,3,217,1,649.60,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1983,7657,631,40760,25773,3,57,2,98901.60,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1984,7657,632,40760,25773,3,217,1,50700.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1985,7657,632,40760,25773,3,68,1,10647.00,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1986,7657,632,40760,25773,3,217,1,405.60,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1987,7657,632,40760,25773,3,57,2,61752.60,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1988,7657,633,40760,25773,3,217,1,84866.75,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1989,7657,633,40760,25773,3,68,1,17822.02,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1990,7657,633,40760,25773,3,217,1,12276.32,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1991,7657,633,40760,25773,3,57,2,114965.09,NULL,'2023-04-24 21:00:41','2023-04-24 21:08:56','2023-04-24 21:08:56'),(1992,7657,634,40760,25773,3,217,1,6942.15,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(1993,7657,634,40760,25773,3,68,1,1457.85,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(1994,7657,634,40760,25773,3,57,2,8400.00,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(1995,7657,635,40760,25773,3,217,1,1983.47,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(1996,7657,635,40760,25773,3,68,1,416.53,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(1997,7657,635,40760,25773,3,57,2,2400.00,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(1998,7657,636,40760,25773,3,217,1,39917.36,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(1999,7657,636,40760,25773,3,68,1,8382.65,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01');
INSERT INTO `balance_libro_details` VALUES (2000,7657,636,40760,25773,3,57,2,48300.01,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2001,7657,637,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2002,7657,637,40760,25773,3,68,1,607.44,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2003,7657,637,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2004,7657,638,40760,25773,3,217,1,2190.08,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2005,7657,638,40760,25773,3,68,1,459.92,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2006,7657,638,40760,25773,3,57,2,2650.00,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2007,7657,639,40760,25773,3,217,1,4628.10,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2008,7657,639,40760,25773,3,68,1,971.90,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2009,7657,639,40760,25773,3,57,2,5600.00,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:01','2023-04-24 22:31:01'),(2010,7657,640,40760,25773,3,217,1,29586.78,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2011,7657,640,40760,25773,3,68,1,6213.22,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2012,7657,640,40760,25773,3,57,2,35800.00,NULL,'2023-04-24 22:12:37','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2013,7657,641,40760,25773,3,217,1,32396.70,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2014,7657,641,40760,25773,3,68,1,6803.31,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2015,7657,641,40760,25773,3,57,2,39200.01,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2016,7657,642,40760,25773,3,217,1,4462.81,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2017,7657,642,40760,25773,3,68,1,937.19,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2018,7657,642,40760,25773,3,57,2,5400.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2019,7657,643,40760,25773,3,217,1,9504.13,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2020,7657,643,40760,25773,3,68,1,1995.87,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2021,7657,643,40760,25773,3,57,2,11500.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2022,7657,644,40760,25773,3,217,1,44354.73,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2023,7657,644,40760,25773,3,68,1,9314.32,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2024,7657,644,40760,25773,3,57,2,53669.05,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2025,7657,645,40760,25773,3,217,1,26243.44,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2026,7657,645,40760,25773,3,68,1,2755.56,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2027,7657,645,40760,25773,3,57,2,28999.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2028,7657,646,40760,25773,3,217,1,18347.11,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2029,7657,646,40760,25773,3,68,1,3852.89,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2030,7657,646,40760,25773,3,57,2,22200.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2031,7657,647,40760,25773,3,217,1,4958.68,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2032,7657,647,40760,25773,3,68,1,1041.32,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2033,7657,647,40760,25773,3,57,2,6000.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2034,7657,648,40760,25773,3,217,1,661.16,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro_details` VALUES (2035,7657,648,40760,25773,3,68,1,138.84,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2036,7657,648,40760,25773,3,57,2,800.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2037,7657,649,40760,25773,3,217,1,4958.68,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2038,7657,649,40760,25773,3,68,1,1041.32,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2039,7657,649,40760,25773,3,57,2,6000.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2040,7657,650,40760,25773,3,217,1,661.16,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2041,7657,650,40760,25773,3,68,1,138.84,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2042,7657,650,40760,25773,3,57,2,800.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2043,7657,651,40760,25773,3,217,1,950.41,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2044,7657,651,40760,25773,3,68,1,199.59,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2045,7657,651,40760,25773,3,57,2,1150.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2046,7657,652,40760,25773,3,217,1,63057.85,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2047,7657,652,40760,25773,3,68,1,13242.15,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2048,7657,652,40760,25773,3,57,2,76300.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2049,7657,653,40760,25773,3,217,1,2644.63,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2050,7657,653,40760,25773,3,68,1,555.37,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2051,7657,653,40760,25773,3,57,2,3200.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2052,7657,654,40760,25773,3,217,1,18429.75,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2053,7657,654,40760,25773,3,68,1,3870.25,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2054,7657,654,40760,25773,3,57,2,22300.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2055,7657,655,40760,25773,3,217,1,4307.96,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2056,7657,655,40760,25773,3,68,1,904.67,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2057,7657,655,40760,25773,3,217,1,161.55,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2058,7657,655,40760,25773,3,57,2,5374.18,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2059,7657,656,40760,25773,3,217,1,85948.76,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2060,7657,656,40760,25773,3,68,1,18049.24,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2061,7657,656,40760,25773,3,57,2,103998.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2062,7657,657,40760,25773,3,217,1,54298.64,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2063,7657,657,40760,25773,3,68,1,5701.36,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2064,7657,657,40760,25773,3,57,2,60000.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2065,7657,658,40760,25773,3,217,1,16115.70,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2066,7657,658,40760,25773,3,68,1,3384.30,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2067,7657,658,40760,25773,3,57,2,19500.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2068,7657,659,40760,25773,3,217,1,3223.14,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2069,7657,659,40760,25773,3,68,1,676.86,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro_details` VALUES (2070,7657,659,40760,25773,3,57,2,3900.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2071,7657,660,40760,25773,3,217,1,10413.22,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2072,7657,660,40760,25773,3,68,1,2186.78,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2073,7657,660,40760,25773,3,57,2,12600.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2074,7657,661,40760,25773,3,217,1,1983.47,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2075,7657,661,40760,25773,3,68,1,416.53,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2076,7657,661,40760,25773,3,57,2,2400.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2077,7657,662,40760,25773,3,217,1,32644.63,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2078,7657,662,40760,25773,3,68,1,6855.37,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2079,7657,662,40760,25773,3,57,2,39500.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2080,7657,663,40760,25773,3,217,1,12355.37,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2081,7657,663,40760,25773,3,68,1,2594.63,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2082,7657,663,40760,25773,3,57,2,14950.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2083,7657,664,40760,25773,3,217,1,13636.36,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2084,7657,664,40760,25773,3,68,1,2863.64,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2085,7657,664,40760,25773,3,57,2,16500.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2086,7657,665,40760,25773,3,217,1,19173.55,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2087,7657,665,40760,25773,3,68,1,4026.45,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2088,7657,665,40760,25773,3,57,2,23200.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2089,7657,666,40760,25773,3,217,1,329.68,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2090,7657,666,40760,25773,3,68,1,69.23,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2091,7657,666,40760,25773,3,57,2,398.91,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2092,7657,667,40760,25773,3,217,1,92561.32,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2093,7657,667,40760,25773,3,68,1,19437.88,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2094,7657,667,40760,25773,3,57,2,111999.20,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2095,7657,668,40760,25773,3,217,1,4132.23,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2096,7657,668,40760,25773,3,68,1,867.77,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2097,7657,668,40760,25773,3,57,2,5000.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2098,7657,669,40760,25773,3,217,1,46033.06,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2099,7657,669,40760,25773,3,68,1,9666.94,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2100,7657,669,40760,25773,3,57,2,55700.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2101,7657,670,40760,25773,3,217,1,9586.78,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2102,7657,670,40760,25773,3,68,1,2013.22,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2103,7657,670,40760,25773,3,57,2,11600.00,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro_details` VALUES (2104,7657,671,40760,25773,3,217,1,12396.70,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2105,7657,671,40760,25773,3,68,1,2603.31,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2106,7657,671,40760,25773,3,57,2,15000.01,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2107,7657,672,40760,25773,3,217,1,4380.17,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2108,7657,672,40760,25773,3,68,1,919.84,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2109,7657,672,40760,25773,3,57,2,5300.01,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2110,7657,673,40760,25773,3,217,1,29375.82,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2111,7657,673,40760,25773,3,68,1,6168.92,NULL,'2023-04-24 22:12:38','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2112,7657,673,40760,25773,3,57,2,35544.74,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2113,7657,674,40760,25773,3,217,1,28512.40,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2114,7657,674,40760,25773,3,68,1,5987.60,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2115,7657,674,40760,25773,3,57,2,34500.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2116,7657,675,40760,25773,3,217,1,3801.65,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2117,7657,675,40760,25773,3,68,1,798.35,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2118,7657,675,40760,25773,3,57,2,4600.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2119,7657,676,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2120,7657,676,40760,25773,3,68,1,520.66,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2121,7657,676,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2122,7657,677,40760,25773,3,217,1,743.80,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2123,7657,677,40760,25773,3,68,1,156.20,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2124,7657,677,40760,25773,3,57,2,900.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2125,7657,678,40760,25773,3,217,1,4545.46,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2126,7657,678,40760,25773,3,68,1,954.55,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2127,7657,678,40760,25773,3,57,2,5500.01,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2128,7657,679,40760,25773,3,217,1,52538.39,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2129,7657,679,40760,25773,3,68,1,11033.06,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2130,7657,679,40760,25773,3,217,1,7765.16,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2131,7657,679,40760,25773,3,57,2,71336.61,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2132,7657,680,40760,25773,3,217,1,6298.23,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2133,7657,680,40760,25773,3,68,1,1322.63,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2134,7657,680,40760,25773,3,57,2,7620.86,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2135,7657,681,40760,25773,3,217,1,2718.27,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2136,7657,681,40760,25773,3,68,1,570.84,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2137,7657,681,40760,25773,3,217,1,210.90,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2138,7657,681,40760,25773,3,57,2,3500.01,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro_details` VALUES (2139,7657,682,40760,25773,3,217,1,9818.24,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2140,7657,682,40760,25773,3,68,1,2061.83,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2141,7657,682,40760,25773,3,57,2,11880.07,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2142,7657,683,40760,25773,3,250,1,29688.40,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2143,7657,683,40760,25773,3,57,2,29688.40,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2144,7657,684,40760,25773,3,217,1,15702.48,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2145,7657,684,40760,25773,3,68,1,3297.52,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2146,7657,684,40760,25773,3,57,2,19000.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2147,7657,685,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2148,7657,685,40760,25773,3,68,1,520.66,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2149,7657,685,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2150,7657,686,40760,25773,3,217,1,16528.93,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2151,7657,686,40760,25773,3,68,1,3471.08,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2152,7657,686,40760,25773,3,57,2,20000.01,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2153,7657,687,40760,25773,3,217,1,5123.97,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2154,7657,687,40760,25773,3,68,1,1076.03,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2155,7657,687,40760,25773,3,57,2,6200.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2156,7657,688,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2157,7657,688,40760,25773,3,68,1,312.40,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2158,7657,688,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2159,7657,689,40760,25773,3,217,1,2148.76,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2160,7657,689,40760,25773,3,68,1,451.24,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2161,7657,689,40760,25773,3,57,2,2600.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2162,7657,690,40760,25773,3,217,1,19338.84,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2163,7657,690,40760,25773,3,68,1,4061.16,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2164,7657,690,40760,25773,3,57,2,23400.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2165,7657,691,40760,25773,3,217,1,73000.69,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2166,7657,691,40760,25773,3,68,1,15330.15,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2167,7657,691,40760,25773,3,217,1,10789.47,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2168,7657,691,40760,25773,3,57,2,99120.31,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2169,7657,692,40760,25773,3,217,1,552823.64,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2170,7657,692,40760,25773,3,68,1,116092.97,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2171,7657,692,40760,25773,3,217,1,18298.46,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2172,7657,692,40760,25773,3,57,2,687215.07,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro_details` VALUES (2173,7657,693,40760,25773,3,217,1,2231.41,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2174,7657,693,40760,25773,3,68,1,468.60,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2175,7657,693,40760,25773,3,57,2,2700.01,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2176,7657,694,40760,25773,3,217,1,4297.52,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2177,7657,694,40760,25773,3,68,1,902.48,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2178,7657,694,40760,25773,3,57,2,5200.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2179,7657,695,40760,25773,3,217,1,991.74,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2180,7657,695,40760,25773,3,68,1,208.27,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2181,7657,695,40760,25773,3,57,2,1200.01,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2182,7657,696,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2183,7657,696,40760,25773,3,68,1,260.33,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2184,7657,696,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2185,7657,697,40760,25773,3,217,1,3305.78,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2186,7657,697,40760,25773,3,68,1,694.21,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2187,7657,697,40760,25773,3,57,2,3999.99,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2188,7657,698,40760,25773,3,217,1,29008.27,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2189,7657,698,40760,25773,3,68,1,6091.74,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2190,7657,698,40760,25773,3,57,2,35100.01,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2191,7657,699,40760,25773,3,217,1,5950.41,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2192,7657,699,40760,25773,3,68,1,1249.59,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2193,7657,699,40760,25773,3,57,2,7200.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2194,7657,700,40760,25773,3,217,1,12892.56,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2195,7657,700,40760,25773,3,68,1,2707.44,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2196,7657,700,40760,25773,3,57,2,15600.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2197,7657,701,40760,25773,3,217,1,3057.85,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2198,7657,701,40760,25773,3,68,1,642.15,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2199,7657,701,40760,25773,3,57,2,3700.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2200,7657,702,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2201,7657,702,40760,25773,3,68,1,607.44,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2202,7657,702,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2203,7657,703,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2204,7657,703,40760,25773,3,68,1,607.44,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2205,7657,703,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2206,7657,704,40760,25773,3,217,1,1322.31,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2207,7657,704,40760,25773,3,68,1,277.69,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02');
INSERT INTO `balance_libro_details` VALUES (2208,7657,704,40760,25773,3,57,2,1600.00,NULL,'2023-04-24 22:12:39','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2209,7657,705,40760,25773,3,217,1,11262.20,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2210,7657,705,40760,25773,3,68,1,2365.06,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2211,7657,705,40760,25773,3,57,2,13627.26,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2212,7657,706,40760,25773,3,217,1,24355.18,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2213,7657,706,40760,25773,3,68,1,5114.59,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2214,7657,706,40760,25773,3,57,2,29469.77,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2215,7657,707,40760,25773,3,217,1,13395.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2216,7657,707,40760,25773,3,68,1,2812.95,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2217,7657,707,40760,25773,3,57,2,16207.95,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2218,7657,708,40760,25773,3,217,1,32292.15,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2219,7657,708,40760,25773,3,68,1,6781.34,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2220,7657,708,40760,25773,3,217,1,1327.21,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2221,7657,708,40760,25773,3,57,2,40400.70,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2222,7657,709,40760,25773,3,217,1,11535.87,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2223,7657,709,40760,25773,3,68,1,2422.53,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2224,7657,709,40760,25773,3,217,1,474.13,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2225,7657,709,40760,25773,3,57,2,14432.53,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2226,7657,710,40760,25773,3,217,1,92470.54,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2227,7657,710,40760,25773,3,68,1,19418.81,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2228,7657,710,40760,25773,3,217,1,3060.77,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2229,7657,710,40760,25773,3,57,2,114950.12,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2230,7657,711,40760,25773,3,217,1,5950.41,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2231,7657,711,40760,25773,3,68,1,1249.59,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2232,7657,711,40760,25773,3,57,2,7200.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2233,7657,712,40760,25773,3,217,1,3223.14,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2234,7657,712,40760,25773,3,68,1,676.86,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2235,7657,712,40760,25773,3,57,2,3900.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:02','2023-04-24 22:31:02'),(2236,7657,713,40760,25773,3,217,1,991.74,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2237,7657,713,40760,25773,3,68,1,208.27,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2238,7657,713,40760,25773,3,57,2,1200.01,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2239,7657,714,40760,25773,3,217,1,2975.21,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2240,7657,714,40760,25773,3,68,1,624.79,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2241,7657,714,40760,25773,3,57,2,3600.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2242,7657,715,40760,25773,3,217,1,1818.18,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro_details` VALUES (2243,7657,715,40760,25773,3,68,1,381.82,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2244,7657,715,40760,25773,3,57,2,2200.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2245,7657,716,40760,25773,3,217,1,6033.06,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2246,7657,716,40760,25773,3,68,1,1266.94,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2247,7657,716,40760,25773,3,57,2,7300.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2248,7657,717,40760,25773,3,217,1,28453.91,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2249,7657,717,40760,25773,3,68,1,5975.33,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2250,7657,717,40760,25773,3,57,2,34429.24,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2251,7657,718,40760,25773,3,217,1,142314.13,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2252,7657,718,40760,25773,3,68,1,29885.97,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2253,7657,718,40760,25773,3,217,1,5849.11,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2254,7657,718,40760,25773,3,57,2,178049.21,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2255,7657,719,40760,25773,3,217,1,11652.89,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2256,7657,719,40760,25773,3,68,1,2447.11,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2257,7657,719,40760,25773,3,57,2,14100.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2258,7657,720,40760,25773,3,217,1,1305.79,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2259,7657,720,40760,25773,3,68,1,274.22,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2260,7657,720,40760,25773,3,57,2,1580.01,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2261,7657,721,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2262,7657,721,40760,25773,3,68,1,260.33,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2263,7657,721,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2264,7657,722,40760,25773,3,217,1,4132.23,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2265,7657,722,40760,25773,3,68,1,867.77,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2266,7657,722,40760,25773,3,57,2,5000.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2267,7657,723,40760,25773,3,217,1,12892.56,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2268,7657,723,40760,25773,3,68,1,2707.44,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2269,7657,723,40760,25773,3,57,2,15600.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2270,7657,724,40760,25773,3,217,1,6694.22,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2271,7657,724,40760,25773,3,68,1,1405.79,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2272,7657,724,40760,25773,3,57,2,8100.01,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2273,7657,725,40760,25773,3,217,1,7039.86,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2274,7657,725,40760,25773,3,68,1,1478.37,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2275,7657,725,40760,25773,3,57,2,8518.23,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2276,7657,726,40760,25773,3,217,1,9818.20,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2277,7657,726,40760,25773,3,68,1,2061.82,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro_details` VALUES (2278,7657,726,40760,25773,3,57,2,11880.02,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2279,7657,727,40760,25773,3,217,1,578.51,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2280,7657,727,40760,25773,3,68,1,121.49,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2281,7657,727,40760,25773,3,57,2,700.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2282,7657,728,40760,25773,3,217,1,5206.61,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2283,7657,728,40760,25773,3,68,1,1093.39,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2284,7657,728,40760,25773,3,57,2,6300.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2285,7657,729,40760,25773,3,217,1,8016.53,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2286,7657,729,40760,25773,3,68,1,1683.47,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2287,7657,729,40760,25773,3,57,2,9700.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2288,7657,730,40760,25773,3,217,1,23884.30,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2289,7657,730,40760,25773,3,68,1,5015.70,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2290,7657,730,40760,25773,3,57,2,28900.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2291,7657,731,40760,25773,3,217,1,6280.99,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2292,7657,731,40760,25773,3,68,1,1319.01,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2293,7657,731,40760,25773,3,57,2,7600.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2294,7657,732,40760,25773,3,217,1,4049.59,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2295,7657,732,40760,25773,3,68,1,850.41,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2296,7657,732,40760,25773,3,57,2,4900.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2297,7657,733,40760,25773,3,217,1,10165.29,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2298,7657,733,40760,25773,3,68,1,2134.71,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2299,7657,733,40760,25773,3,57,2,12300.00,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2300,7657,734,40760,25773,3,217,1,661.16,NULL,'2023-04-24 22:12:40','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2301,7657,734,40760,25773,3,68,1,138.84,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2302,7657,734,40760,25773,3,57,2,800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2303,7657,735,40760,25773,3,217,1,15289.26,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2304,7657,735,40760,25773,3,68,1,3210.74,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2305,7657,735,40760,25773,3,57,2,18500.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2306,7657,736,40760,25773,3,217,1,3305.79,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2307,7657,736,40760,25773,3,68,1,694.22,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2308,7657,736,40760,25773,3,57,2,4000.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2309,7657,737,40760,25773,3,217,1,10165.29,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2310,7657,737,40760,25773,3,68,1,2134.71,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2311,7657,737,40760,25773,3,57,2,12300.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2312,7657,738,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro_details` VALUES (2313,7657,738,40760,25773,3,68,1,260.33,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2314,7657,738,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2315,7657,739,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2316,7657,739,40760,25773,3,68,1,312.40,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2317,7657,739,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2318,7657,740,40760,25773,3,217,1,661.16,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2319,7657,740,40760,25773,3,68,1,138.84,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2320,7657,740,40760,25773,3,57,2,800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2321,7657,741,40760,25773,3,217,1,9504.13,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2322,7657,741,40760,25773,3,68,1,1995.87,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2323,7657,741,40760,25773,3,57,2,11500.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2324,7657,742,40760,25773,3,217,1,1652.89,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2325,7657,742,40760,25773,3,68,1,347.11,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2326,7657,742,40760,25773,3,57,2,2000.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2327,7657,743,40760,25773,3,217,1,7355.37,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2328,7657,743,40760,25773,3,68,1,1544.63,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2329,7657,743,40760,25773,3,57,2,8900.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2330,7657,744,40760,25773,3,217,1,661.16,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2331,7657,744,40760,25773,3,68,1,138.84,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2332,7657,744,40760,25773,3,57,2,800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2333,7657,745,40760,25773,3,217,1,454.55,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2334,7657,745,40760,25773,3,68,1,95.46,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2335,7657,745,40760,25773,3,57,2,550.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2336,7657,746,40760,25773,3,217,1,9008.27,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2337,7657,746,40760,25773,3,68,1,1891.74,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2338,7657,746,40760,25773,3,57,2,10900.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2339,7657,747,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2340,7657,747,40760,25773,3,68,1,312.40,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2341,7657,747,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2342,7657,748,40760,25773,3,217,1,3636.36,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2343,7657,748,40760,25773,3,68,1,763.64,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2344,7657,748,40760,25773,3,57,2,4400.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2345,7657,749,40760,25773,3,217,1,9090.91,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2346,7657,749,40760,25773,3,68,1,1909.09,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2347,7657,749,40760,25773,3,57,2,11000.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro_details` VALUES (2348,7657,750,40760,25773,3,217,1,20991.74,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2349,7657,750,40760,25773,3,68,1,4408.27,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2350,7657,750,40760,25773,3,57,2,25400.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2351,7657,751,40760,25773,3,217,1,18016.53,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2352,7657,751,40760,25773,3,68,1,3783.47,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2353,7657,751,40760,25773,3,57,2,21800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2354,7657,752,40760,25773,3,217,1,4297.52,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2355,7657,752,40760,25773,3,68,1,902.48,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2356,7657,752,40760,25773,3,57,2,5200.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2357,7657,753,40760,25773,3,217,1,33719.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2358,7657,753,40760,25773,3,68,1,7080.99,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2359,7657,753,40760,25773,3,57,2,40800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2360,7657,754,40760,25773,3,217,1,30018.78,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2361,7657,754,40760,25773,3,68,1,6303.94,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2362,7657,754,40760,25773,3,217,1,17.66,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2363,7657,754,40760,25773,3,57,2,36340.38,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2364,7657,755,40760,25773,3,217,1,9504.13,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2365,7657,755,40760,25773,3,68,1,1995.87,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2366,7657,755,40760,25773,3,57,2,11500.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2367,7657,756,40760,25773,3,217,1,4793.39,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2368,7657,756,40760,25773,3,68,1,1006.61,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2369,7657,756,40760,25773,3,57,2,5800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2370,7657,757,40760,25773,3,217,1,6198.35,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2371,7657,757,40760,25773,3,68,1,1301.65,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2372,7657,757,40760,25773,3,57,2,7500.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2373,7657,758,40760,25773,3,217,1,5289.26,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2374,7657,758,40760,25773,3,68,1,1110.74,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2375,7657,758,40760,25773,3,57,2,6400.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2376,7657,759,40760,25773,3,217,1,67938.71,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2377,7657,759,40760,25773,3,68,1,14267.13,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2378,7657,759,40760,25773,3,217,1,2792.28,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2379,7657,759,40760,25773,3,57,2,84998.12,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2380,7657,760,40760,25773,3,217,1,2314.05,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2381,7657,760,40760,25773,3,68,1,485.95,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2382,7657,760,40760,25773,3,57,2,2800.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro_details` VALUES (2383,7657,761,40760,25773,3,217,1,3801.65,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2384,7657,761,40760,25773,3,68,1,798.35,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2385,7657,761,40760,25773,3,57,2,4600.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2386,7657,762,40760,25773,3,217,1,8842.98,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2387,7657,762,40760,25773,3,68,1,1857.03,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2388,7657,762,40760,25773,3,57,2,10700.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2389,7657,763,40760,25773,3,217,1,4876.03,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2390,7657,763,40760,25773,3,68,1,1023.97,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2391,7657,763,40760,25773,3,57,2,5900.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2392,7657,764,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2393,7657,764,40760,25773,3,68,1,780.99,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2394,7657,764,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2395,7657,765,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2396,7657,765,40760,25773,3,68,1,607.44,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2397,7657,765,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2398,7657,766,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2399,7657,766,40760,25773,3,68,1,780.99,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2400,7657,766,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2401,7657,767,40760,25773,3,217,1,18842.98,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2402,7657,767,40760,25773,3,68,1,3957.03,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2403,7657,767,40760,25773,3,57,2,22800.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2404,7657,768,40760,25773,3,217,1,7933.89,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2405,7657,768,40760,25773,3,68,1,1666.12,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2406,7657,768,40760,25773,3,57,2,9600.01,NULL,'2023-04-24 22:12:41','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2407,7657,769,40760,25773,3,217,1,15289.26,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2408,7657,769,40760,25773,3,68,1,3210.74,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2409,7657,769,40760,25773,3,57,2,18500.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2410,7657,770,40760,25773,3,217,1,7143.05,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2411,7657,770,40760,25773,3,68,1,1500.04,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2412,7657,770,40760,25773,3,217,1,57.15,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2413,7657,770,40760,25773,3,57,2,8700.24,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2414,7657,771,40760,25773,3,217,1,22982.25,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2415,7657,771,40760,25773,3,68,1,4826.27,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2416,7657,771,40760,25773,3,57,2,27808.52,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2417,7657,772,40760,25773,3,217,1,413.22,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro_details` VALUES (2418,7657,772,40760,25773,3,68,1,86.78,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2419,7657,772,40760,25773,3,57,2,500.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2420,7657,773,40760,25773,3,217,1,1570.25,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2421,7657,773,40760,25773,3,68,1,329.75,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2422,7657,773,40760,25773,3,57,2,1900.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2423,7657,774,40760,25773,3,217,1,4628.10,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2424,7657,774,40760,25773,3,68,1,971.90,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2425,7657,774,40760,25773,3,57,2,5600.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2426,7657,775,40760,25773,3,217,1,5206.61,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2427,7657,775,40760,25773,3,68,1,1093.39,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2428,7657,775,40760,25773,3,57,2,6300.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2429,7657,776,40760,25773,3,217,1,4958.68,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2430,7657,776,40760,25773,3,68,1,1041.32,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2431,7657,776,40760,25773,3,57,2,6000.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2432,7657,777,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2433,7657,777,40760,25773,3,68,1,780.99,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2434,7657,777,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2435,7657,778,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2436,7657,778,40760,25773,3,68,1,607.44,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2437,7657,778,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2438,7657,779,40760,25773,3,217,1,3884.30,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2439,7657,779,40760,25773,3,68,1,815.70,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2440,7657,779,40760,25773,3,57,2,4700.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2441,7657,780,40760,25773,3,217,1,7438.02,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2442,7657,780,40760,25773,3,68,1,1561.98,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2443,7657,780,40760,25773,3,57,2,9000.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2444,7657,781,40760,25773,3,217,1,6363.64,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2445,7657,781,40760,25773,3,68,1,1336.36,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2446,7657,781,40760,25773,3,57,2,7700.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2447,7657,782,40760,25773,3,217,1,7107.44,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2448,7657,782,40760,25773,3,68,1,1492.56,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2449,7657,782,40760,25773,3,57,2,8600.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2450,7657,783,40760,25773,3,217,1,9256.20,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2451,7657,783,40760,25773,3,68,1,1943.80,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03'),(2452,7657,783,40760,25773,3,57,2,11200.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:03','2023-04-24 22:31:03');
INSERT INTO `balance_libro_details` VALUES (2453,7657,784,40760,25773,3,217,1,1735.54,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2454,7657,784,40760,25773,3,68,1,364.46,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2455,7657,784,40760,25773,3,57,2,2100.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2456,7657,785,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2457,7657,785,40760,25773,3,68,1,260.33,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2458,7657,785,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2459,7657,786,40760,25773,3,217,1,5371.90,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2460,7657,786,40760,25773,3,68,1,1128.10,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2461,7657,786,40760,25773,3,57,2,6500.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2462,7657,787,40760,25773,3,217,1,991.74,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2463,7657,787,40760,25773,3,68,1,208.27,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2464,7657,787,40760,25773,3,57,2,1200.01,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2465,7657,788,40760,25773,3,217,1,4297.52,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2466,7657,788,40760,25773,3,68,1,902.48,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2467,7657,788,40760,25773,3,57,2,5200.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2468,7657,789,40760,25773,3,217,1,10661.16,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2469,7657,789,40760,25773,3,68,1,2238.84,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2470,7657,789,40760,25773,3,57,2,12900.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2471,7657,790,40760,25773,3,217,1,6280.99,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2472,7657,790,40760,25773,3,68,1,1319.01,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2473,7657,790,40760,25773,3,57,2,7600.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2474,7657,791,40760,25773,3,217,1,3057.85,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2475,7657,791,40760,25773,3,68,1,642.15,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2476,7657,791,40760,25773,3,57,2,3700.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2477,7657,792,40760,25773,3,217,1,9586.78,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2478,7657,792,40760,25773,3,68,1,2013.22,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2479,7657,792,40760,25773,3,57,2,11600.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2480,7657,793,40760,25773,3,217,1,2644.63,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2481,7657,793,40760,25773,3,68,1,555.37,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2482,7657,793,40760,25773,3,57,2,3200.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2483,7657,794,40760,25773,3,217,1,4132.23,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2484,7657,794,40760,25773,3,68,1,867.77,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2485,7657,794,40760,25773,3,57,2,5000.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2486,7657,795,40760,25773,3,217,1,661.16,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2487,7657,795,40760,25773,3,68,1,138.84,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro_details` VALUES (2488,7657,795,40760,25773,3,57,2,800.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2489,7657,796,40760,25773,3,217,1,5785.12,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2490,7657,796,40760,25773,3,68,1,1214.88,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2491,7657,796,40760,25773,3,57,2,7000.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2492,7657,797,40760,25773,3,217,1,826.45,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2493,7657,797,40760,25773,3,68,1,173.55,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2494,7657,797,40760,25773,3,57,2,1000.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2495,7657,798,40760,25773,3,217,1,14119.01,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2496,7657,798,40760,25773,3,68,1,2964.99,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2497,7657,798,40760,25773,3,217,1,467.34,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2498,7657,798,40760,25773,3,57,2,17551.34,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2499,7657,799,40760,25773,3,217,1,16851.56,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2500,7657,799,40760,25773,3,68,1,3538.83,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2501,7657,799,40760,25773,3,217,1,134.81,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2502,7657,799,40760,25773,3,57,2,20525.20,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2503,7657,800,40760,25773,3,217,1,2644.63,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2504,7657,800,40760,25773,3,68,1,555.37,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2505,7657,800,40760,25773,3,57,2,3200.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2506,7657,801,40760,25773,3,217,1,3801.65,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2507,7657,801,40760,25773,3,68,1,798.35,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2508,7657,801,40760,25773,3,57,2,4600.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2509,7657,802,40760,25773,3,217,1,2396.70,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2510,7657,802,40760,25773,3,68,1,503.31,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2511,7657,802,40760,25773,3,57,2,2900.01,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2512,7657,803,40760,25773,3,217,1,1322.31,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2513,7657,803,40760,25773,3,68,1,277.69,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2514,7657,803,40760,25773,3,57,2,1600.00,NULL,'2023-04-24 22:12:42','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2515,7657,804,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2516,7657,804,40760,25773,3,68,1,780.99,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2517,7657,804,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2518,7657,805,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2519,7657,805,40760,25773,3,68,1,780.99,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2520,7657,805,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2521,7657,806,40760,25773,3,217,1,826.45,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2522,7657,806,40760,25773,3,68,1,173.55,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro_details` VALUES (2523,7657,806,40760,25773,3,57,2,1000.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2524,7657,807,40760,25773,3,217,1,13636.36,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2525,7657,807,40760,25773,3,68,1,2863.64,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2526,7657,807,40760,25773,3,57,2,16500.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2527,7657,808,40760,25773,3,217,1,1239.67,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2528,7657,808,40760,25773,3,68,1,260.33,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2529,7657,808,40760,25773,3,57,2,1500.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2530,7657,809,40760,25773,3,217,1,4049.59,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2531,7657,809,40760,25773,3,68,1,850.41,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2532,7657,809,40760,25773,3,57,2,4900.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2533,7657,810,40760,25773,3,217,1,3636.36,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2534,7657,810,40760,25773,3,68,1,763.64,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2535,7657,810,40760,25773,3,57,2,4400.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2536,7657,811,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2537,7657,811,40760,25773,3,68,1,520.66,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2538,7657,811,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2539,7657,812,40760,25773,3,217,1,3305.79,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2540,7657,812,40760,25773,3,68,1,694.22,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2541,7657,812,40760,25773,3,57,2,4000.01,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2542,7657,813,40760,25773,3,217,1,10206.61,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2543,7657,813,40760,25773,3,68,1,2143.39,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2544,7657,813,40760,25773,3,57,2,12350.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2545,7657,814,40760,25773,3,217,1,1570.25,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2546,7657,814,40760,25773,3,68,1,329.75,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2547,7657,814,40760,25773,3,57,2,1900.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2548,7657,815,40760,25773,3,217,1,15371.90,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2549,7657,815,40760,25773,3,68,1,3228.10,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2550,7657,815,40760,25773,3,57,2,18600.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2551,7657,816,40760,25773,3,217,1,2644.63,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2552,7657,816,40760,25773,3,68,1,555.37,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2553,7657,816,40760,25773,3,57,2,3200.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2554,7657,817,40760,25773,3,217,1,3471.08,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2555,7657,817,40760,25773,3,68,1,728.93,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2556,7657,817,40760,25773,3,57,2,4200.01,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2557,7657,818,40760,25773,3,217,1,7024.79,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro_details` VALUES (2558,7657,818,40760,25773,3,68,1,1475.21,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2559,7657,818,40760,25773,3,57,2,8500.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2560,7657,819,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2561,7657,819,40760,25773,3,68,1,520.66,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2562,7657,819,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2563,7657,820,40760,25773,3,217,1,2892.56,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2564,7657,820,40760,25773,3,68,1,607.44,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2565,7657,820,40760,25773,3,57,2,3500.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2566,7657,821,40760,25773,3,217,1,826.45,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2567,7657,821,40760,25773,3,68,1,173.55,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2568,7657,821,40760,25773,3,57,2,1000.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2569,7657,822,40760,25773,3,217,1,8264.46,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2570,7657,822,40760,25773,3,68,1,1735.54,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2571,7657,822,40760,25773,3,57,2,10000.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2572,7657,823,40760,25773,3,217,1,2396.70,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2573,7657,823,40760,25773,3,68,1,503.31,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2574,7657,823,40760,25773,3,57,2,2900.01,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2575,7657,824,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2576,7657,824,40760,25773,3,68,1,520.66,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2577,7657,824,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2578,7657,825,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2579,7657,825,40760,25773,3,68,1,312.40,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2580,7657,825,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2581,7657,826,40760,25773,3,217,1,1652.89,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2582,7657,826,40760,25773,3,68,1,347.11,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2583,7657,826,40760,25773,3,57,2,2000.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2584,7657,827,40760,25773,3,217,1,10826.45,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2585,7657,827,40760,25773,3,68,1,2273.55,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2586,7657,827,40760,25773,3,57,2,13100.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2587,7657,828,40760,25773,3,217,1,3553.72,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2588,7657,828,40760,25773,3,68,1,746.28,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2589,7657,828,40760,25773,3,57,2,4300.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2590,7657,829,40760,25773,3,217,1,11818.18,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2591,7657,829,40760,25773,3,68,1,2481.82,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2592,7657,829,40760,25773,3,57,2,14300.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro_details` VALUES (2593,7657,830,40760,25773,3,217,1,2975.21,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2594,7657,830,40760,25773,3,68,1,624.79,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2595,7657,830,40760,25773,3,57,2,3600.00,NULL,'2023-04-24 22:12:43','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2596,7657,831,40760,25773,3,217,1,2975.21,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2597,7657,831,40760,25773,3,68,1,624.79,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2598,7657,831,40760,25773,3,57,2,3600.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2599,7657,832,40760,25773,3,217,1,3305.79,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2600,7657,832,40760,25773,3,68,1,694.22,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2601,7657,832,40760,25773,3,57,2,4000.01,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2602,7657,833,40760,25773,3,250,1,28050.45,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2603,7657,833,40760,25773,3,57,2,28050.45,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2604,7657,834,40760,25773,3,217,1,73028.09,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2605,7657,834,40760,25773,3,68,1,15335.90,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2606,7657,834,40760,25773,3,57,2,88363.99,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2607,7657,835,40760,25773,3,217,1,6893.25,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2608,7657,835,40760,25773,3,68,1,1447.58,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2609,7657,835,40760,25773,3,57,2,8340.83,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2610,7657,836,40760,25773,3,217,1,21784.65,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2611,7657,836,40760,25773,3,68,1,4574.77,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2612,7657,836,40760,25773,3,217,1,3143.05,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2613,7657,836,40760,25773,3,57,2,29502.47,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2614,7657,837,40760,25773,3,217,1,145195.42,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2615,7657,837,40760,25773,3,68,1,30491.04,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2616,7657,837,40760,25773,3,217,1,5894.93,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2617,7657,837,40760,25773,3,57,2,181581.39,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2618,7657,838,40760,25773,3,217,1,4958.68,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2619,7657,838,40760,25773,3,68,1,1041.32,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2620,7657,838,40760,25773,3,57,2,6000.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2621,7657,839,40760,25773,3,217,1,8760.33,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2622,7657,839,40760,25773,3,68,1,1839.67,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2623,7657,839,40760,25773,3,57,2,10600.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2624,7657,840,40760,25773,3,217,1,28512.40,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2625,7657,840,40760,25773,3,68,1,5987.60,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2626,7657,840,40760,25773,3,57,2,34500.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro_details` VALUES (2627,7657,841,40760,25773,3,217,1,3471.08,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2628,7657,841,40760,25773,3,68,1,728.93,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2629,7657,841,40760,25773,3,57,2,4200.01,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2630,7657,842,40760,25773,3,217,1,2066.12,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2631,7657,842,40760,25773,3,68,1,433.89,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2632,7657,842,40760,25773,3,57,2,2500.01,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2633,7657,843,40760,25773,3,217,1,5785.12,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2634,7657,843,40760,25773,3,68,1,1214.88,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2635,7657,843,40760,25773,3,57,2,7000.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2636,7657,844,40760,25773,3,217,1,3884.30,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2637,7657,844,40760,25773,3,68,1,815.70,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2638,7657,844,40760,25773,3,57,2,4700.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2639,7657,845,40760,25773,3,217,1,66958.66,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2640,7657,845,40760,25773,3,68,1,14000.21,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2641,7657,845,40760,25773,3,217,1,535.67,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2642,7657,845,40760,25773,3,57,2,81494.54,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2643,7657,846,40760,25773,3,217,1,2479.34,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2644,7657,846,40760,25773,3,68,1,520.66,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2645,7657,846,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2646,7657,847,40760,25773,3,217,1,7768.60,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2647,7657,847,40760,25773,3,68,1,1631.41,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2648,7657,847,40760,25773,3,57,2,9400.01,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2649,7657,848,40760,25773,3,217,1,4628.10,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2650,7657,848,40760,25773,3,68,1,971.90,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2651,7657,848,40760,25773,3,57,2,5600.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2652,7657,849,40760,25773,3,217,1,3884.30,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2653,7657,849,40760,25773,3,68,1,815.70,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2654,7657,849,40760,25773,3,57,2,4700.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2655,7657,850,40760,25773,3,217,1,2231.41,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2656,7657,850,40760,25773,3,68,1,468.60,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2657,7657,850,40760,25773,3,57,2,2700.01,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2658,7657,851,40760,25773,3,217,1,3884.30,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2659,7657,851,40760,25773,3,68,1,815.70,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2660,7657,851,40760,25773,3,57,2,4700.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2661,7657,852,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro_details` VALUES (2662,7657,852,40760,25773,3,68,1,780.99,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2663,7657,852,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2664,7657,853,40760,25773,3,217,1,1652.89,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2665,7657,853,40760,25773,3,68,1,347.11,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2666,7657,853,40760,25773,3,57,2,2000.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2667,7657,854,40760,25773,3,217,1,3305.79,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2668,7657,854,40760,25773,3,68,1,694.22,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2669,7657,854,40760,25773,3,57,2,4000.01,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2670,7657,855,40760,25773,3,217,1,661.16,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2671,7657,855,40760,25773,3,68,1,138.84,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2672,7657,855,40760,25773,3,57,2,800.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2673,7657,856,40760,25773,3,217,1,7272.73,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2674,7657,856,40760,25773,3,68,1,1527.27,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2675,7657,856,40760,25773,3,57,2,8800.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2676,7657,857,40760,25773,3,217,1,3719.01,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2677,7657,857,40760,25773,3,68,1,780.99,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2678,7657,857,40760,25773,3,57,2,4500.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2679,7657,858,40760,25773,3,217,1,661.16,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2680,7657,858,40760,25773,3,68,1,138.84,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2681,7657,858,40760,25773,3,57,2,800.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2682,7657,859,40760,25773,3,217,1,1487.60,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2683,7657,859,40760,25773,3,68,1,312.40,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2684,7657,859,40760,25773,3,57,2,1800.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2685,7657,860,40760,25773,3,217,1,2727.27,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2686,7657,860,40760,25773,3,68,1,572.73,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2687,7657,860,40760,25773,3,57,2,3300.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2688,7657,861,40760,25773,3,217,1,2339.07,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2689,7657,861,40760,25773,3,68,1,491.21,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2690,7657,861,40760,25773,3,217,1,169.72,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2691,7657,861,40760,25773,3,57,2,3000.00,NULL,'2023-04-24 22:12:44','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2692,7657,862,40760,25773,3,217,2,6854.62,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2693,7657,862,40760,25773,3,67,2,1439.47,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2694,7657,862,40760,25773,3,57,1,8294.09,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2695,7657,863,40760,25773,3,217,1,310549.21,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2696,7657,863,40760,25773,3,68,1,65215.33,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04');
INSERT INTO `balance_libro_details` VALUES (2697,7657,863,40760,25773,3,217,1,10279.18,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2698,7657,863,40760,25773,3,57,2,386043.72,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2699,7657,864,40760,25773,3,217,1,49669.42,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2700,7657,864,40760,25773,3,68,1,10430.58,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2701,7657,864,40760,25773,3,57,2,60100.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2702,7657,865,40760,25773,3,217,1,5661.16,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2703,7657,865,40760,25773,3,68,1,1188.84,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2704,7657,865,40760,25773,3,57,2,6850.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2705,7657,866,40760,25773,3,217,1,61200.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2706,7657,866,40760,25773,3,68,1,12852.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2707,7657,866,40760,25773,3,217,1,489.60,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2708,7657,866,40760,25773,3,57,2,74541.60,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:04','2023-04-24 22:31:04'),(2709,7657,867,40760,25773,3,217,1,55900.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2710,7657,867,40760,25773,3,68,1,11739.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2711,7657,867,40760,25773,3,217,1,447.20,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2712,7657,867,40760,25773,3,57,2,68086.20,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2713,7657,868,40760,25773,3,217,1,4090.91,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2714,7657,868,40760,25773,3,68,1,859.09,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2715,7657,868,40760,25773,3,57,2,4950.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2716,7657,869,40760,25773,3,217,1,495.87,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2717,7657,869,40760,25773,3,68,1,104.13,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2718,7657,869,40760,25773,3,57,2,600.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2719,7657,870,40760,25773,3,217,1,81200.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2720,7657,870,40760,25773,3,68,1,17052.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2721,7657,870,40760,25773,3,217,1,649.60,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2722,7657,870,40760,25773,3,57,2,98901.60,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2723,7657,871,40760,25773,3,217,1,50700.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2724,7657,871,40760,25773,3,68,1,10647.00,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2725,7657,871,40760,25773,3,217,1,405.60,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2726,7657,871,40760,25773,3,57,2,61752.60,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2727,7657,872,40760,25773,3,217,1,84866.75,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2728,7657,872,40760,25773,3,68,1,17822.02,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2729,7657,872,40760,25773,3,217,1,12276.32,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2730,7657,872,40760,25773,3,57,2,114965.09,NULL,'2023-04-24 22:12:45','2023-04-24 22:31:05','2023-04-24 22:31:05'),(2731,7657,873,40760,25773,2,96,2,289004.62,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL);
INSERT INTO `balance_libro_details` VALUES (2732,7657,873,40760,25773,2,67,2,60690.97,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2733,7657,873,40760,25773,2,13,1,349695.59,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2734,7657,874,40760,25773,2,96,2,13223.14,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2735,7657,874,40760,25773,2,67,2,2776.86,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2736,7657,874,40760,25773,2,13,1,16000.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2737,7657,875,40760,25773,2,96,2,3223.14,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2738,7657,875,40760,25773,2,67,2,676.86,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2739,7657,875,40760,25773,2,13,1,3900.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2740,7657,876,40760,25773,2,96,2,1818.18,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2741,7657,876,40760,25773,2,67,2,381.82,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2742,7657,876,40760,25773,2,13,1,2200.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2743,7657,877,40760,25773,2,96,2,10800.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2744,7657,877,40760,25773,2,67,2,2268.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2745,7657,877,40760,25773,2,13,1,13068.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2746,7657,878,40760,25773,2,96,2,7851.24,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2747,7657,878,40760,25773,2,67,2,1648.76,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2748,7657,878,40760,25773,2,13,1,9500.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2749,7657,879,40760,25773,2,96,2,10223.14,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2750,7657,879,40760,25773,2,67,2,2146.86,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2751,7657,879,40760,25773,2,13,1,12370.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2752,7657,880,40760,25773,2,96,2,2975.21,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2753,7657,880,40760,25773,2,67,2,624.79,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2754,7657,880,40760,25773,2,13,1,3600.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2755,7657,881,40760,25773,2,96,2,661.16,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2756,7657,881,40760,25773,2,67,2,138.84,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2757,7657,881,40760,25773,2,13,1,800.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2758,7657,882,40760,25773,2,96,2,4661.16,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2759,7657,882,40760,25773,2,67,2,978.84,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2760,7657,882,40760,25773,2,13,1,5640.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2761,7657,883,40760,25773,2,96,2,454.55,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2762,7657,883,40760,25773,2,67,2,95.45,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2763,7657,883,40760,25773,2,13,1,550.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2764,7657,884,40760,25773,2,96,2,82.64,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2765,7657,884,40760,25773,2,67,2,17.36,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2766,7657,884,40760,25773,2,13,1,100.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2767,7657,885,40760,25773,2,96,2,10413.22,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2768,7657,885,40760,25773,2,67,2,2186.78,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2769,7657,885,40760,25773,2,13,1,12600.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2770,7657,886,40760,25773,2,96,2,36198.34,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2771,7657,886,40760,25773,2,67,2,7601.66,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2772,7657,886,40760,25773,2,13,1,43800.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL);
INSERT INTO `balance_libro_details` VALUES (2773,7657,887,40760,25773,2,96,2,3600.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2774,7657,887,40760,25773,2,67,2,756.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2775,7657,887,40760,25773,2,13,1,4356.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2776,7657,888,40760,25773,2,96,2,13760.33,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2777,7657,888,40760,25773,2,67,2,2889.67,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2778,7657,888,40760,25773,2,13,1,16650.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2779,7657,889,40760,25773,2,96,2,38016.53,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2780,7657,889,40760,25773,2,67,2,7983.47,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2781,7657,889,40760,25773,2,13,1,46000.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2782,7657,890,40760,25773,2,96,2,27256.20,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2783,7657,890,40760,25773,2,67,2,5723.80,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2784,7657,890,40760,25773,2,13,1,32980.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2785,7657,891,40760,25773,2,96,2,25619.83,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2786,7657,891,40760,25773,2,67,2,5380.17,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2787,7657,891,40760,25773,2,13,1,31000.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2788,7657,892,40760,25773,2,96,2,2413.22,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2789,7657,892,40760,25773,2,67,2,506.78,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2790,7657,892,40760,25773,2,13,1,2920.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2791,7657,893,40760,25773,2,96,2,22727.28,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2792,7657,893,40760,25773,2,67,2,4772.72,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2793,7657,893,40760,25773,2,13,1,27500.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2794,7657,894,40760,25773,2,96,2,382500.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2795,7657,894,40760,25773,2,67,2,80325.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2796,7657,894,40760,25773,2,13,1,462825.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2797,7657,895,40760,25773,2,96,2,1785.12,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2798,7657,895,40760,25773,2,67,2,374.88,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2799,7657,895,40760,25773,2,13,1,2160.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2800,7657,896,40760,25773,2,96,2,2892.56,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2801,7657,896,40760,25773,2,67,2,607.44,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2802,7657,896,40760,25773,2,13,1,3500.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2803,7657,897,40760,25773,2,96,2,2438.02,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2804,7657,897,40760,25773,2,67,2,511.98,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2805,7657,897,40760,25773,2,13,1,2950.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2806,7657,898,40760,25773,2,96,2,743.80,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2807,7657,898,40760,25773,2,67,2,156.20,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2808,7657,898,40760,25773,2,13,1,900.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2809,7657,899,40760,25773,2,96,2,1735.54,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2810,7657,899,40760,25773,2,67,2,364.46,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2811,7657,899,40760,25773,2,13,1,2100.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2812,7657,900,40760,25773,2,96,2,6302.48,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2813,7657,900,40760,25773,2,67,2,1323.52,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL);
INSERT INTO `balance_libro_details` VALUES (2814,7657,900,40760,25773,2,13,1,7626.00,NULL,'2023-04-26 22:33:57','2023-04-26 22:33:57',NULL),(2815,7657,901,40760,25773,2,96,2,5983.47,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2816,7657,901,40760,25773,2,67,2,1256.53,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2817,7657,901,40760,25773,2,13,1,7240.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2818,7657,902,40760,25773,2,96,2,3016.53,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2819,7657,902,40760,25773,2,67,2,633.47,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2820,7657,902,40760,25773,2,13,1,3650.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2821,7657,903,40760,25773,2,96,2,14347.10,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2822,7657,903,40760,25773,2,67,2,3012.90,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2823,7657,903,40760,25773,2,13,1,17360.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2824,7657,904,40760,25773,2,96,2,10033.05,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2825,7657,904,40760,25773,2,67,2,2106.95,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2826,7657,904,40760,25773,2,13,1,12140.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2827,7657,905,40760,25773,2,96,2,9586.78,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2828,7657,905,40760,25773,2,67,2,2013.22,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2829,7657,905,40760,25773,2,13,1,11600.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2830,7657,906,40760,25773,2,96,2,1966.94,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2831,7657,906,40760,25773,2,67,2,413.06,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2832,7657,906,40760,25773,2,13,1,2380.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2833,7657,907,40760,25773,2,96,2,2809.91,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2834,7657,907,40760,25773,2,67,2,590.09,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2835,7657,907,40760,25773,2,13,1,3400.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2836,7657,908,40760,25773,2,96,2,14793.39,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2837,7657,908,40760,25773,2,67,2,3106.61,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2838,7657,908,40760,25773,2,13,1,17900.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2839,7657,909,40760,25773,2,96,2,2487.60,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2840,7657,909,40760,25773,2,67,2,522.40,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2841,7657,909,40760,25773,2,13,1,3010.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2842,7657,910,40760,25773,2,96,2,4989.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2843,7657,910,40760,25773,2,67,2,1047.69,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2844,7657,910,40760,25773,2,13,1,6036.69,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2845,7657,911,40760,25773,2,96,2,2305.78,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2846,7657,911,40760,25773,2,67,2,484.22,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2847,7657,911,40760,25773,2,13,1,2790.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2848,7657,912,40760,25773,2,96,2,25289.26,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2849,7657,912,40760,25773,2,67,2,5310.74,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2850,7657,912,40760,25773,2,13,1,30600.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2851,7657,913,40760,25773,2,96,2,826.44,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2852,7657,913,40760,25773,2,67,2,173.56,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2853,7657,913,40760,25773,2,13,1,1000.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2854,7657,914,40760,25773,2,96,2,1479.33,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL);
INSERT INTO `balance_libro_details` VALUES (2855,7657,914,40760,25773,2,67,2,310.67,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2856,7657,914,40760,25773,2,13,1,1790.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2857,7657,915,40760,25773,2,96,2,702.48,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2858,7657,915,40760,25773,2,67,2,147.52,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2859,7657,915,40760,25773,2,13,1,850.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2860,7657,916,40760,25773,2,96,2,1636.36,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2861,7657,916,40760,25773,2,67,2,343.64,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2862,7657,916,40760,25773,2,13,1,1980.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2863,7657,917,40760,25773,2,96,2,8388.43,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2864,7657,917,40760,25773,2,67,2,1761.57,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2865,7657,917,40760,25773,2,13,1,10150.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2866,7657,918,40760,25773,2,96,2,20760.33,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2867,7657,918,40760,25773,2,67,2,4359.67,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2868,7657,918,40760,25773,2,13,1,25120.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2869,7657,919,40760,25773,2,96,2,3471.07,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2870,7657,919,40760,25773,2,67,2,728.93,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2871,7657,919,40760,25773,2,13,1,4200.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2872,7657,920,40760,25773,2,96,2,2479.34,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2873,7657,920,40760,25773,2,67,2,520.66,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2874,7657,920,40760,25773,2,13,1,3000.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2875,7657,921,40760,25773,2,96,2,4586.77,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2876,7657,921,40760,25773,2,67,2,963.23,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2877,7657,921,40760,25773,2,13,1,5550.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2878,7657,922,40760,25773,2,96,2,1578.51,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2879,7657,922,40760,25773,2,67,2,331.49,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2880,7657,922,40760,25773,2,13,1,1910.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2881,7657,923,40760,25773,2,96,2,1198.35,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2882,7657,923,40760,25773,2,67,2,251.65,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2883,7657,923,40760,25773,2,13,1,1450.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2884,7657,924,40760,25773,2,96,2,3884.29,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2885,7657,924,40760,25773,2,67,2,815.71,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2886,7657,924,40760,25773,2,13,1,4700.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2887,7657,925,40760,25773,2,96,2,1322.31,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2888,7657,925,40760,25773,2,67,2,277.69,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2889,7657,925,40760,25773,2,13,1,1600.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2890,7657,926,40760,25773,2,96,2,3636.36,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2891,7657,926,40760,25773,2,67,2,763.64,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2892,7657,926,40760,25773,2,13,1,4400.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2893,7657,927,40760,25773,2,96,2,826.44,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2894,7657,927,40760,25773,2,67,2,173.56,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2895,7657,927,40760,25773,2,13,1,1000.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL);
INSERT INTO `balance_libro_details` VALUES (2896,7657,928,40760,25773,2,96,2,13958.67,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2897,7657,928,40760,25773,2,67,2,2931.33,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2898,7657,928,40760,25773,2,13,1,16890.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2899,7657,929,40760,25773,2,96,2,4297.52,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2900,7657,929,40760,25773,2,67,2,902.48,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2901,7657,929,40760,25773,2,13,1,5200.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2902,7657,930,40760,25773,2,96,2,2644.62,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2903,7657,930,40760,25773,2,67,2,555.38,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2904,7657,930,40760,25773,2,13,1,3200.00,NULL,'2023-04-26 22:33:58','2023-04-26 22:33:58',NULL),(2905,7657,931,40760,25773,2,96,2,1900.82,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2906,7657,931,40760,25773,2,67,2,399.18,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2907,7657,931,40760,25773,2,13,1,2300.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2908,7657,932,40760,25773,2,96,2,1404.96,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2909,7657,932,40760,25773,2,67,2,295.04,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2910,7657,932,40760,25773,2,13,1,1700.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2911,7657,933,40760,25773,2,96,2,786901.93,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2912,7657,933,40760,25773,2,67,2,165249.41,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2913,7657,933,40760,25773,2,13,1,952151.34,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2914,7657,934,40760,25773,2,96,2,23185.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2915,7657,934,40760,25773,2,67,2,4868.85,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2916,7657,934,40760,25773,2,13,1,28053.85,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2917,7657,935,40760,25773,2,96,2,5785.13,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2918,7657,935,40760,25773,2,67,2,1214.87,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2919,7657,935,40760,25773,2,13,1,7000.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2920,7657,936,40760,25773,2,96,2,1818.18,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2921,7657,936,40760,25773,2,67,2,381.82,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2922,7657,936,40760,25773,2,13,1,2200.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2923,7657,937,40760,25773,2,96,2,1818.18,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2924,7657,937,40760,25773,2,67,2,381.82,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2925,7657,937,40760,25773,2,13,1,2200.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2926,7657,938,40760,25773,2,96,2,1311100.56,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2927,7657,938,40760,25773,2,67,2,275331.12,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2928,7657,938,40760,25773,2,13,1,1586431.68,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2929,7657,939,40760,25773,2,96,2,2685.95,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2930,7657,939,40760,25773,2,67,2,564.05,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2931,7657,939,40760,25773,2,13,1,3250.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2932,7657,940,40760,25773,2,96,2,1363.64,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2933,7657,940,40760,25773,2,67,2,286.36,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2934,7657,940,40760,25773,2,13,1,1650.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2935,7657,941,40760,25773,2,96,2,17355.37,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2936,7657,941,40760,25773,2,67,2,3644.63,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL);
INSERT INTO `balance_libro_details` VALUES (2937,7657,941,40760,25773,2,13,1,21000.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2938,7657,942,40760,25773,2,96,2,6363.64,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2939,7657,942,40760,25773,2,67,2,1336.36,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2940,7657,942,40760,25773,2,13,1,7700.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2941,7657,943,40760,25773,2,96,2,6611.57,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2942,7657,943,40760,25773,2,67,2,1388.43,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2943,7657,943,40760,25773,2,13,1,8000.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2944,7657,944,40760,25773,2,96,2,495.87,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2945,7657,944,40760,25773,2,67,2,104.13,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2946,7657,944,40760,25773,2,13,1,600.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2947,7657,945,40760,25773,2,96,2,1818.18,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2948,7657,945,40760,25773,2,67,2,381.82,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2949,7657,945,40760,25773,2,13,1,2200.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2950,7657,946,40760,25773,2,96,2,201.65,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2951,7657,946,40760,25773,2,67,2,42.35,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2952,7657,946,40760,25773,2,13,1,244.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2953,7657,947,40760,25773,2,96,2,5652.89,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2954,7657,947,40760,25773,2,67,2,1187.11,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2955,7657,947,40760,25773,2,13,1,6840.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2956,7657,948,40760,25773,2,96,2,1033.06,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2957,7657,948,40760,25773,2,67,2,216.94,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2958,7657,948,40760,25773,2,13,1,1250.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2959,7657,949,40760,25773,2,96,2,495.87,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2960,7657,949,40760,25773,2,67,2,104.13,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2961,7657,949,40760,25773,2,13,1,600.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2962,7657,950,40760,25773,2,96,2,2396.69,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2963,7657,950,40760,25773,2,67,2,503.31,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2964,7657,950,40760,25773,2,13,1,2900.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2965,7657,951,40760,25773,2,96,2,1735.54,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2966,7657,951,40760,25773,2,67,2,364.46,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2967,7657,951,40760,25773,2,13,1,2100.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2968,7657,952,40760,25773,2,96,2,3966.94,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2969,7657,952,40760,25773,2,67,2,833.06,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2970,7657,952,40760,25773,2,13,1,4800.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2971,7657,953,40760,25773,2,96,2,5537.19,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2972,7657,953,40760,25773,2,67,2,1162.81,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2973,7657,953,40760,25773,2,13,1,6700.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2974,7657,954,40760,25773,2,96,2,2727.27,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2975,7657,954,40760,25773,2,67,2,572.73,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2976,7657,954,40760,25773,2,13,1,3300.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2977,7657,955,40760,25773,2,96,2,909.09,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL);
INSERT INTO `balance_libro_details` VALUES (2978,7657,955,40760,25773,2,67,2,190.91,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2979,7657,955,40760,25773,2,13,1,1100.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2980,7657,956,40760,25773,2,96,2,2727.27,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2981,7657,956,40760,25773,2,67,2,572.73,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2982,7657,956,40760,25773,2,13,1,3300.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2983,7657,957,40760,25773,2,96,2,661.16,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2984,7657,957,40760,25773,2,67,2,138.84,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2985,7657,957,40760,25773,2,13,1,800.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2986,7657,958,40760,25773,2,96,2,2355.37,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2987,7657,958,40760,25773,2,67,2,494.63,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2988,7657,958,40760,25773,2,13,1,2850.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2989,7657,959,40760,25773,2,96,2,371.90,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2990,7657,959,40760,25773,2,67,2,78.10,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2991,7657,959,40760,25773,2,13,1,450.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2992,7657,960,40760,25773,2,96,2,371.90,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2993,7657,960,40760,25773,2,67,2,78.10,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2994,7657,960,40760,25773,2,13,1,450.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2995,7657,961,40760,25773,2,96,2,909.09,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2996,7657,961,40760,25773,2,67,2,190.91,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2997,7657,961,40760,25773,2,13,1,1100.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2998,7657,962,40760,25773,2,96,2,785.12,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(2999,7657,962,40760,25773,2,67,2,164.88,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(3000,7657,962,40760,25773,2,13,1,950.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(3001,7657,963,40760,25773,2,96,2,1500000.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(3002,7657,963,40760,25773,2,67,2,315000.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(3003,7657,963,40760,25773,2,13,1,1815000.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(3004,7657,964,40760,25773,2,96,2,17603.31,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(3005,7657,964,40760,25773,2,67,2,3696.69,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(3006,7657,964,40760,25773,2,13,1,21300.00,NULL,'2023-04-26 22:33:59','2023-04-26 22:33:59',NULL),(3007,7657,965,40760,25773,2,96,2,14876.02,NULL,'2023-04-26 22:34:00','2023-04-26 22:34:00',NULL),(3008,7657,965,40760,25773,2,67,2,3123.98,NULL,'2023-04-26 22:34:00','2023-04-26 22:34:00',NULL),(3009,7657,965,40760,25773,2,13,1,18000.00,NULL,'2023-04-26 22:34:00','2023-04-26 22:34:00',NULL),(3010,7657,966,40760,25773,2,96,2,3429.75,NULL,'2023-04-26 22:34:00','2023-04-26 22:34:00',NULL),(3011,7657,966,40760,25773,2,67,2,720.25,NULL,'2023-04-26 22:34:00','2023-04-26 22:34:00',NULL),(3012,7657,966,40760,25773,2,13,1,4150.00,NULL,'2023-04-26 22:34:00','2023-04-26 22:34:00',NULL),(3013,7657,967,40760,25773,3,217,1,6942.15,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3014,7657,967,40760,25773,3,68,1,1457.85,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3015,7657,967,40760,25773,3,57,2,8400.00,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3016,7657,968,40760,25773,3,217,1,1983.47,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3017,7657,968,40760,25773,3,68,1,416.53,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3018,7657,968,40760,25773,3,57,2,2400.00,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL);
INSERT INTO `balance_libro_details` VALUES (3019,7657,969,40760,25773,3,217,1,39917.36,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3020,7657,969,40760,25773,3,68,1,8382.65,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3021,7657,969,40760,25773,3,57,2,48300.01,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3022,7657,970,40760,25773,3,217,1,2892.56,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3023,7657,970,40760,25773,3,68,1,607.44,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3024,7657,970,40760,25773,3,57,2,3500.00,NULL,'2023-04-26 22:50:16','2023-04-26 22:50:16',NULL),(3025,7657,971,40760,25773,3,217,1,2190.08,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3026,7657,971,40760,25773,3,68,1,459.92,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3027,7657,971,40760,25773,3,57,2,2650.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3028,7657,972,40760,25773,3,217,1,4628.10,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3029,7657,972,40760,25773,3,68,1,971.90,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3030,7657,972,40760,25773,3,57,2,5600.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3031,7657,973,40760,25773,3,217,1,29586.78,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3032,7657,973,40760,25773,3,68,1,6213.22,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3033,7657,973,40760,25773,3,57,2,35800.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3034,7657,974,40760,25773,3,217,1,32396.70,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3035,7657,974,40760,25773,3,68,1,6803.31,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3036,7657,974,40760,25773,3,57,2,39200.01,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3037,7657,975,40760,25773,3,217,1,4462.81,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3038,7657,975,40760,25773,3,68,1,937.19,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3039,7657,975,40760,25773,3,57,2,5400.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3040,7657,976,40760,25773,3,217,1,9504.13,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3041,7657,976,40760,25773,3,68,1,1995.87,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3042,7657,976,40760,25773,3,57,2,11500.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3043,7657,977,40760,25773,3,217,1,44354.73,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3044,7657,977,40760,25773,3,68,1,9314.32,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3045,7657,977,40760,25773,3,57,2,53669.05,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3046,7657,978,40760,25773,3,217,1,26243.44,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3047,7657,978,40760,25773,3,68,1,2755.56,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3048,7657,978,40760,25773,3,57,2,28999.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3049,7657,979,40760,25773,3,217,1,18347.11,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3050,7657,979,40760,25773,3,68,1,3852.89,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3051,7657,979,40760,25773,3,57,2,22200.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3052,7657,980,40760,25773,3,217,1,4958.68,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3053,7657,980,40760,25773,3,68,1,1041.32,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3054,7657,980,40760,25773,3,57,2,6000.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3055,7657,981,40760,25773,3,217,1,661.16,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3056,7657,981,40760,25773,3,68,1,138.84,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3057,7657,981,40760,25773,3,57,2,800.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3058,7657,982,40760,25773,3,217,1,4958.68,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3059,7657,982,40760,25773,3,68,1,1041.32,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL);
INSERT INTO `balance_libro_details` VALUES (3060,7657,982,40760,25773,3,57,2,6000.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3061,7657,983,40760,25773,3,217,1,661.16,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3062,7657,983,40760,25773,3,68,1,138.84,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3063,7657,983,40760,25773,3,57,2,800.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3064,7657,984,40760,25773,3,217,1,950.41,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3065,7657,984,40760,25773,3,68,1,199.59,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3066,7657,984,40760,25773,3,57,2,1150.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3067,7657,985,40760,25773,3,217,1,63057.85,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3068,7657,985,40760,25773,3,68,1,13242.15,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3069,7657,985,40760,25773,3,57,2,76300.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3070,7657,986,40760,25773,3,217,1,2644.63,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3071,7657,986,40760,25773,3,68,1,555.37,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3072,7657,986,40760,25773,3,57,2,3200.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3073,7657,987,40760,25773,3,217,1,18429.75,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3074,7657,987,40760,25773,3,68,1,3870.25,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3075,7657,987,40760,25773,3,57,2,22300.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3076,7657,988,40760,25773,3,217,1,4307.96,NULL,'2023-04-26 22:50:17','2023-04-26 23:13:21','2023-04-26 23:13:21'),(3077,7657,988,40760,25773,3,68,1,904.67,NULL,'2023-04-26 22:50:17','2023-04-26 23:13:21','2023-04-26 23:13:21'),(3078,7657,988,40760,25773,3,217,1,161.55,NULL,'2023-04-26 22:50:17','2023-04-26 23:13:21','2023-04-26 23:13:21'),(3079,7657,988,40760,25773,3,57,2,5374.18,NULL,'2023-04-26 22:50:17','2023-04-26 23:13:21','2023-04-26 23:13:21'),(3080,7657,989,40760,25773,3,217,1,85948.76,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3081,7657,989,40760,25773,3,68,1,18049.24,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3082,7657,989,40760,25773,3,57,2,103998.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3083,7657,990,40760,25773,3,217,1,54298.64,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3084,7657,990,40760,25773,3,68,1,5701.36,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3085,7657,990,40760,25773,3,57,2,60000.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3086,7657,991,40760,25773,3,217,1,16115.70,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3087,7657,991,40760,25773,3,68,1,3384.30,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3088,7657,991,40760,25773,3,57,2,19500.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3089,7657,992,40760,25773,3,217,1,3223.14,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3090,7657,992,40760,25773,3,68,1,676.86,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3091,7657,992,40760,25773,3,57,2,3900.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3092,7657,993,40760,25773,3,217,1,10413.22,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3093,7657,993,40760,25773,3,68,1,2186.78,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3094,7657,993,40760,25773,3,57,2,12600.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3095,7657,994,40760,25773,3,217,1,1983.47,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3096,7657,994,40760,25773,3,68,1,416.53,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3097,7657,994,40760,25773,3,57,2,2400.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3098,7657,995,40760,25773,3,217,1,32644.63,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3099,7657,995,40760,25773,3,68,1,6855.37,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL);
INSERT INTO `balance_libro_details` VALUES (3100,7657,995,40760,25773,3,57,2,39500.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3101,7657,996,40760,25773,3,217,1,12355.37,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3102,7657,996,40760,25773,3,68,1,2594.63,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3103,7657,996,40760,25773,3,57,2,14950.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3104,7657,997,40760,25773,3,217,1,13636.36,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3105,7657,997,40760,25773,3,68,1,2863.64,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3106,7657,997,40760,25773,3,57,2,16500.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3107,7657,998,40760,25773,3,217,1,19173.55,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3108,7657,998,40760,25773,3,68,1,4026.45,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3109,7657,998,40760,25773,3,57,2,23200.00,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3110,7657,999,40760,25773,3,217,1,329.68,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3111,7657,999,40760,25773,3,68,1,69.23,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3112,7657,999,40760,25773,3,57,2,398.91,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3113,7657,1000,40760,25773,3,217,1,92561.32,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3114,7657,1000,40760,25773,3,68,1,19437.88,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3115,7657,1000,40760,25773,3,57,2,111999.20,NULL,'2023-04-26 22:50:17','2023-04-26 22:50:17',NULL),(3116,7657,1001,40760,25773,3,217,1,4132.23,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3117,7657,1001,40760,25773,3,68,1,867.77,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3118,7657,1001,40760,25773,3,57,2,5000.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3119,7657,1002,40760,25773,3,217,1,46033.06,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3120,7657,1002,40760,25773,3,68,1,9666.94,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3121,7657,1002,40760,25773,3,57,2,55700.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3122,7657,1003,40760,25773,3,217,1,9586.78,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3123,7657,1003,40760,25773,3,68,1,2013.22,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3124,7657,1003,40760,25773,3,57,2,11600.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3125,7657,1004,40760,25773,3,217,1,12396.70,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3126,7657,1004,40760,25773,3,68,1,2603.31,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3127,7657,1004,40760,25773,3,57,2,15000.01,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3128,7657,1005,40760,25773,3,217,1,4380.17,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3129,7657,1005,40760,25773,3,68,1,919.84,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3130,7657,1005,40760,25773,3,57,2,5300.01,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3131,7657,1006,40760,25773,3,217,1,29375.82,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3132,7657,1006,40760,25773,3,68,1,6168.92,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3133,7657,1006,40760,25773,3,57,2,35544.74,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3134,7657,1007,40760,25773,3,217,1,28512.40,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3135,7657,1007,40760,25773,3,68,1,5987.60,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3136,7657,1007,40760,25773,3,57,2,34500.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3137,7657,1008,40760,25773,3,217,1,3801.65,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3138,7657,1008,40760,25773,3,68,1,798.35,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3139,7657,1008,40760,25773,3,57,2,4600.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL);
INSERT INTO `balance_libro_details` VALUES (3140,7657,1009,40760,25773,3,217,1,2479.34,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3141,7657,1009,40760,25773,3,68,1,520.66,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3142,7657,1009,40760,25773,3,57,2,3000.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3143,7657,1010,40760,25773,3,217,1,743.80,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3144,7657,1010,40760,25773,3,68,1,156.20,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3145,7657,1010,40760,25773,3,57,2,900.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3146,7657,1011,40760,25773,3,217,1,4545.46,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3147,7657,1011,40760,25773,3,68,1,954.55,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3148,7657,1011,40760,25773,3,57,2,5500.01,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3149,7657,1012,40760,25773,3,217,1,52538.39,NULL,'2023-04-26 22:50:18','2023-04-26 23:15:52','2023-04-26 23:15:52'),(3150,7657,1012,40760,25773,3,68,1,11033.06,NULL,'2023-04-26 22:50:18','2023-04-26 23:15:52','2023-04-26 23:15:52'),(3151,7657,1012,40760,25773,3,217,1,7765.16,NULL,'2023-04-26 22:50:18','2023-04-26 23:15:52','2023-04-26 23:15:52'),(3152,7657,1012,40760,25773,3,57,2,71336.61,NULL,'2023-04-26 22:50:18','2023-04-26 23:15:52','2023-04-26 23:15:52'),(3153,7657,1013,40760,25773,3,217,1,6298.23,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3154,7657,1013,40760,25773,3,68,1,1322.63,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3155,7657,1013,40760,25773,3,57,2,7620.86,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3156,7657,1014,40760,25773,3,217,1,2718.27,NULL,'2023-04-26 22:50:18','2023-04-26 23:18:38','2023-04-26 23:18:38'),(3157,7657,1014,40760,25773,3,68,1,570.84,NULL,'2023-04-26 22:50:18','2023-04-26 23:18:38','2023-04-26 23:18:38'),(3158,7657,1014,40760,25773,3,217,1,210.90,NULL,'2023-04-26 22:50:18','2023-04-26 23:18:38','2023-04-26 23:18:38'),(3159,7657,1014,40760,25773,3,57,2,3500.01,NULL,'2023-04-26 22:50:18','2023-04-26 23:18:38','2023-04-26 23:18:38'),(3160,7657,1015,40760,25773,3,217,1,9818.24,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3161,7657,1015,40760,25773,3,68,1,2061.83,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3162,7657,1015,40760,25773,3,57,2,11880.07,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3163,7657,1016,40760,25773,3,250,1,29688.40,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3164,7657,1016,40760,25773,3,57,2,29688.40,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3165,7657,1017,40760,25773,3,217,1,15702.48,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3166,7657,1017,40760,25773,3,68,1,3297.52,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3167,7657,1017,40760,25773,3,57,2,19000.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3168,7657,1018,40760,25773,3,217,1,2479.34,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3169,7657,1018,40760,25773,3,68,1,520.66,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3170,7657,1018,40760,25773,3,57,2,3000.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3171,7657,1019,40760,25773,3,217,1,16528.93,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3172,7657,1019,40760,25773,3,68,1,3471.08,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3173,7657,1019,40760,25773,3,57,2,20000.01,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3174,7657,1020,40760,25773,3,217,1,5123.97,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3175,7657,1020,40760,25773,3,68,1,1076.03,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3176,7657,1020,40760,25773,3,57,2,6200.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3177,7657,1021,40760,25773,3,217,1,1487.60,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3178,7657,1021,40760,25773,3,68,1,312.40,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL);
INSERT INTO `balance_libro_details` VALUES (3179,7657,1021,40760,25773,3,57,2,1800.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3180,7657,1022,40760,25773,3,217,1,2148.76,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3181,7657,1022,40760,25773,3,68,1,451.24,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3182,7657,1022,40760,25773,3,57,2,2600.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3183,7657,1023,40760,25773,3,217,1,19338.84,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3184,7657,1023,40760,25773,3,68,1,4061.16,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3185,7657,1023,40760,25773,3,57,2,23400.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3186,7657,1024,40760,25773,3,217,1,73000.69,NULL,'2023-04-26 22:50:18','2023-04-26 23:22:45','2023-04-26 23:22:45'),(3187,7657,1024,40760,25773,3,68,1,15330.15,NULL,'2023-04-26 22:50:18','2023-04-26 23:22:45','2023-04-26 23:22:45'),(3188,7657,1024,40760,25773,3,217,1,10789.47,NULL,'2023-04-26 22:50:18','2023-04-26 23:22:45','2023-04-26 23:22:45'),(3189,7657,1024,40760,25773,3,57,2,99120.31,NULL,'2023-04-26 22:50:18','2023-04-26 23:22:45','2023-04-26 23:22:45'),(3190,7657,1025,40760,25773,3,217,1,552823.64,NULL,'2023-04-26 22:50:18','2023-04-26 23:29:24','2023-04-26 23:29:24'),(3191,7657,1025,40760,25773,3,68,1,116092.97,NULL,'2023-04-26 22:50:18','2023-04-26 23:29:24','2023-04-26 23:29:24'),(3192,7657,1025,40760,25773,3,217,1,18298.46,NULL,'2023-04-26 22:50:18','2023-04-26 23:29:24','2023-04-26 23:29:24'),(3193,7657,1025,40760,25773,3,57,2,687215.07,NULL,'2023-04-26 22:50:18','2023-04-26 23:29:24','2023-04-26 23:29:24'),(3194,7657,1026,40760,25773,3,217,1,2231.41,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3195,7657,1026,40760,25773,3,68,1,468.60,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3196,7657,1026,40760,25773,3,57,2,2700.01,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3197,7657,1027,40760,25773,3,217,1,4297.52,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3198,7657,1027,40760,25773,3,68,1,902.48,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3199,7657,1027,40760,25773,3,57,2,5200.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3200,7657,1028,40760,25773,3,217,1,991.74,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3201,7657,1028,40760,25773,3,68,1,208.27,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3202,7657,1028,40760,25773,3,57,2,1200.01,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3203,7657,1029,40760,25773,3,217,1,1239.67,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3204,7657,1029,40760,25773,3,68,1,260.33,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3205,7657,1029,40760,25773,3,57,2,1500.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3206,7657,1030,40760,25773,3,217,1,3305.78,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3207,7657,1030,40760,25773,3,68,1,694.21,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3208,7657,1030,40760,25773,3,57,2,3999.99,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3209,7657,1031,40760,25773,3,217,1,29008.27,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3210,7657,1031,40760,25773,3,68,1,6091.74,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3211,7657,1031,40760,25773,3,57,2,35100.01,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3212,7657,1032,40760,25773,3,217,1,5950.41,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3213,7657,1032,40760,25773,3,68,1,1249.59,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3214,7657,1032,40760,25773,3,57,2,7200.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3215,7657,1033,40760,25773,3,217,1,12892.56,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3216,7657,1033,40760,25773,3,68,1,2707.44,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3217,7657,1033,40760,25773,3,57,2,15600.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL);
INSERT INTO `balance_libro_details` VALUES (3218,7657,1034,40760,25773,3,217,1,3057.85,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3219,7657,1034,40760,25773,3,68,1,642.15,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3220,7657,1034,40760,25773,3,57,2,3700.00,NULL,'2023-04-26 22:50:18','2023-04-26 22:50:18',NULL),(3221,7657,1035,40760,25773,3,217,1,2892.56,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3222,7657,1035,40760,25773,3,68,1,607.44,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3223,7657,1035,40760,25773,3,57,2,3500.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3224,7657,1036,40760,25773,3,217,1,2892.56,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3225,7657,1036,40760,25773,3,68,1,607.44,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3226,7657,1036,40760,25773,3,57,2,3500.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3227,7657,1037,40760,25773,3,217,1,1322.31,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3228,7657,1037,40760,25773,3,68,1,277.69,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3229,7657,1037,40760,25773,3,57,2,1600.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3230,7657,1038,40760,25773,3,217,1,11262.20,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3231,7657,1038,40760,25773,3,68,1,2365.06,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3232,7657,1038,40760,25773,3,57,2,13627.26,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3233,7657,1039,40760,25773,3,217,1,24355.18,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3234,7657,1039,40760,25773,3,68,1,5114.59,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3235,7657,1039,40760,25773,3,57,2,29469.77,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3236,7657,1040,40760,25773,3,217,1,13395.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3237,7657,1040,40760,25773,3,68,1,2812.95,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3238,7657,1040,40760,25773,3,57,2,16207.95,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3239,7657,1041,40760,25773,3,217,1,32292.15,NULL,'2023-04-26 22:50:19','2023-04-26 23:39:54','2023-04-26 23:39:54'),(3240,7657,1041,40760,25773,3,68,1,6781.34,NULL,'2023-04-26 22:50:19','2023-04-26 23:39:54','2023-04-26 23:39:54'),(3241,7657,1041,40760,25773,3,217,1,1327.21,NULL,'2023-04-26 22:50:19','2023-04-26 23:39:54','2023-04-26 23:39:54'),(3242,7657,1041,40760,25773,3,57,2,40400.70,NULL,'2023-04-26 22:50:19','2023-04-26 23:39:54','2023-04-26 23:39:54'),(3243,7657,1042,40760,25773,3,217,1,11535.87,NULL,'2023-04-26 22:50:19','2023-04-26 23:48:18','2023-04-26 23:48:18'),(3244,7657,1042,40760,25773,3,68,1,2422.53,NULL,'2023-04-26 22:50:19','2023-04-26 23:48:18','2023-04-26 23:48:18'),(3245,7657,1042,40760,25773,3,217,1,474.13,NULL,'2023-04-26 22:50:19','2023-04-26 23:48:18','2023-04-26 23:48:18'),(3246,7657,1042,40760,25773,3,57,2,14432.53,NULL,'2023-04-26 22:50:19','2023-04-26 23:48:18','2023-04-26 23:48:18'),(3247,7657,1043,40760,25773,3,217,1,142314.13,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3248,7657,1043,40760,25773,3,68,1,29885.97,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3249,7657,1043,40760,25773,3,217,1,5849.11,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3250,7657,1043,40760,25773,3,57,2,178049.21,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3251,7657,1044,40760,25773,3,217,1,92470.54,NULL,'2023-04-26 22:50:19','2023-04-27 07:21:10','2023-04-27 07:21:10'),(3252,7657,1044,40760,25773,3,68,1,19418.81,NULL,'2023-04-26 22:50:19','2023-04-27 07:21:10','2023-04-27 07:21:10'),(3253,7657,1044,40760,25773,3,217,1,3060.77,NULL,'2023-04-26 22:50:19','2023-04-27 07:21:10','2023-04-27 07:21:10'),(3254,7657,1044,40760,25773,3,57,2,114950.12,NULL,'2023-04-26 22:50:19','2023-04-27 07:21:10','2023-04-27 07:21:10'),(3255,7657,1045,40760,25773,3,217,1,5950.41,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL);
INSERT INTO `balance_libro_details` VALUES (3256,7657,1045,40760,25773,3,68,1,1249.59,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3257,7657,1045,40760,25773,3,57,2,7200.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3258,7657,1046,40760,25773,3,217,1,3223.14,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3259,7657,1046,40760,25773,3,68,1,676.86,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3260,7657,1046,40760,25773,3,57,2,3900.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3261,7657,1047,40760,25773,3,217,1,991.74,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3262,7657,1047,40760,25773,3,68,1,208.27,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3263,7657,1047,40760,25773,3,57,2,1200.01,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3264,7657,1048,40760,25773,3,217,1,2975.21,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3265,7657,1048,40760,25773,3,68,1,624.79,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3266,7657,1048,40760,25773,3,57,2,3600.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3267,7657,1049,40760,25773,3,217,1,1818.18,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3268,7657,1049,40760,25773,3,68,1,381.82,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3269,7657,1049,40760,25773,3,57,2,2200.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3270,7657,1050,40760,25773,3,217,1,6033.06,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3271,7657,1050,40760,25773,3,68,1,1266.94,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3272,7657,1050,40760,25773,3,57,2,7300.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3273,7657,1051,40760,25773,3,217,1,28453.91,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3274,7657,1051,40760,25773,3,68,1,5975.33,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3275,7657,1051,40760,25773,3,57,2,34429.24,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3276,7657,1052,40760,25773,3,217,1,11652.89,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3277,7657,1052,40760,25773,3,68,1,2447.11,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3278,7657,1052,40760,25773,3,57,2,14100.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3279,7657,1053,40760,25773,3,217,1,1305.79,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3280,7657,1053,40760,25773,3,68,1,274.22,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3281,7657,1053,40760,25773,3,57,2,1580.01,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3282,7657,1054,40760,25773,3,217,1,1239.67,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3283,7657,1054,40760,25773,3,68,1,260.33,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3284,7657,1054,40760,25773,3,57,2,1500.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3285,7657,1055,40760,25773,3,217,1,4132.23,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3286,7657,1055,40760,25773,3,68,1,867.77,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3287,7657,1055,40760,25773,3,57,2,5000.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3288,7657,1056,40760,25773,3,217,1,12892.56,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3289,7657,1056,40760,25773,3,68,1,2707.44,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3290,7657,1056,40760,25773,3,57,2,15600.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3291,7657,1057,40760,25773,3,217,1,6694.22,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3292,7657,1057,40760,25773,3,68,1,1405.79,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3293,7657,1057,40760,25773,3,57,2,8100.01,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3294,7657,1058,40760,25773,3,217,1,7039.86,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3295,7657,1058,40760,25773,3,68,1,1478.37,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL);
INSERT INTO `balance_libro_details` VALUES (3296,7657,1058,40760,25773,3,57,2,8518.23,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3297,7657,1059,40760,25773,3,217,1,9818.20,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3298,7657,1059,40760,25773,3,68,1,2061.82,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3299,7657,1059,40760,25773,3,57,2,11880.02,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3300,7657,1060,40760,25773,3,217,1,578.51,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3301,7657,1060,40760,25773,3,68,1,121.49,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3302,7657,1060,40760,25773,3,57,2,700.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3303,7657,1061,40760,25773,3,217,1,5206.61,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3304,7657,1061,40760,25773,3,68,1,1093.39,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3305,7657,1061,40760,25773,3,57,2,6300.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3306,7657,1062,40760,25773,3,217,1,8016.53,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3307,7657,1062,40760,25773,3,68,1,1683.47,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3308,7657,1062,40760,25773,3,57,2,9700.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3309,7657,1063,40760,25773,3,217,1,23884.30,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3310,7657,1063,40760,25773,3,68,1,5015.70,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3311,7657,1063,40760,25773,3,57,2,28900.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3312,7657,1064,40760,25773,3,217,1,6280.99,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3313,7657,1064,40760,25773,3,68,1,1319.01,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3314,7657,1064,40760,25773,3,57,2,7600.00,NULL,'2023-04-26 22:50:19','2023-04-26 22:50:19',NULL),(3315,7657,1065,40760,25773,3,217,1,4049.59,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3316,7657,1065,40760,25773,3,68,1,850.41,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3317,7657,1065,40760,25773,3,57,2,4900.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3318,7657,1066,40760,25773,3,217,1,10165.29,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3319,7657,1066,40760,25773,3,68,1,2134.71,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3320,7657,1066,40760,25773,3,57,2,12300.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3321,7657,1067,40760,25773,3,217,1,661.16,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3322,7657,1067,40760,25773,3,68,1,138.84,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3323,7657,1067,40760,25773,3,57,2,800.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3324,7657,1068,40760,25773,3,217,1,15289.26,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3325,7657,1068,40760,25773,3,68,1,3210.74,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3326,7657,1068,40760,25773,3,57,2,18500.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3327,7657,1069,40760,25773,3,217,1,3305.79,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3328,7657,1069,40760,25773,3,68,1,694.22,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3329,7657,1069,40760,25773,3,57,2,4000.01,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3330,7657,1070,40760,25773,3,217,1,10165.29,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3331,7657,1070,40760,25773,3,68,1,2134.71,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3332,7657,1070,40760,25773,3,57,2,12300.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3333,7657,1071,40760,25773,3,217,1,1239.67,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3334,7657,1071,40760,25773,3,68,1,260.33,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3335,7657,1071,40760,25773,3,57,2,1500.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL);
INSERT INTO `balance_libro_details` VALUES (3336,7657,1072,40760,25773,3,217,1,1487.60,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3337,7657,1072,40760,25773,3,68,1,312.40,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3338,7657,1072,40760,25773,3,57,2,1800.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3339,7657,1073,40760,25773,3,217,1,661.16,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3340,7657,1073,40760,25773,3,68,1,138.84,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3341,7657,1073,40760,25773,3,57,2,800.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3342,7657,1074,40760,25773,3,217,1,9504.13,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3343,7657,1074,40760,25773,3,68,1,1995.87,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3344,7657,1074,40760,25773,3,57,2,11500.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3345,7657,1075,40760,25773,3,217,1,1652.89,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3346,7657,1075,40760,25773,3,68,1,347.11,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3347,7657,1075,40760,25773,3,57,2,2000.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3348,7657,1076,40760,25773,3,217,1,7355.37,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3349,7657,1076,40760,25773,3,68,1,1544.63,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3350,7657,1076,40760,25773,3,57,2,8900.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3351,7657,1077,40760,25773,3,217,1,661.16,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3352,7657,1077,40760,25773,3,68,1,138.84,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3353,7657,1077,40760,25773,3,57,2,800.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3354,7657,1078,40760,25773,3,217,1,454.55,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3355,7657,1078,40760,25773,3,68,1,95.46,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3356,7657,1078,40760,25773,3,57,2,550.01,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3357,7657,1079,40760,25773,3,217,1,9504.13,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3358,7657,1079,40760,25773,3,68,1,1995.87,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3359,7657,1079,40760,25773,3,57,2,11500.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3360,7657,1080,40760,25773,3,217,1,4793.39,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3361,7657,1080,40760,25773,3,68,1,1006.61,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3362,7657,1080,40760,25773,3,57,2,5800.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3363,7657,1081,40760,25773,3,217,1,6198.35,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3364,7657,1081,40760,25773,3,68,1,1301.65,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3365,7657,1081,40760,25773,3,57,2,7500.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3366,7657,1082,40760,25773,3,217,1,5289.26,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3367,7657,1082,40760,25773,3,68,1,1110.74,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3368,7657,1082,40760,25773,3,57,2,6400.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3369,7657,1083,40760,25773,3,217,1,67938.71,NULL,'2023-04-26 22:50:20','2023-04-27 07:30:27','2023-04-27 07:30:27'),(3370,7657,1083,40760,25773,3,68,1,14267.13,NULL,'2023-04-26 22:50:20','2023-04-27 07:30:27','2023-04-27 07:30:27'),(3371,7657,1083,40760,25773,3,217,1,2792.28,NULL,'2023-04-26 22:50:20','2023-04-27 07:30:27','2023-04-27 07:30:27'),(3372,7657,1083,40760,25773,3,57,2,84998.12,NULL,'2023-04-26 22:50:20','2023-04-27 07:30:27','2023-04-27 07:30:27'),(3373,7657,1084,40760,25773,3,217,1,2314.05,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3374,7657,1084,40760,25773,3,68,1,485.95,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3375,7657,1084,40760,25773,3,57,2,2800.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL);
INSERT INTO `balance_libro_details` VALUES (3376,7657,1085,40760,25773,3,217,1,3801.65,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3377,7657,1085,40760,25773,3,68,1,798.35,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3378,7657,1085,40760,25773,3,57,2,4600.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3379,7657,1086,40760,25773,3,217,1,8842.98,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3380,7657,1086,40760,25773,3,68,1,1857.03,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3381,7657,1086,40760,25773,3,57,2,10700.01,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3382,7657,1087,40760,25773,3,217,1,4876.03,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3383,7657,1087,40760,25773,3,68,1,1023.97,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3384,7657,1087,40760,25773,3,57,2,5900.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3385,7657,1088,40760,25773,3,217,1,3719.01,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3386,7657,1088,40760,25773,3,68,1,780.99,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3387,7657,1088,40760,25773,3,57,2,4500.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3388,7657,1089,40760,25773,3,217,1,9008.27,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3389,7657,1089,40760,25773,3,68,1,1891.74,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3390,7657,1089,40760,25773,3,57,2,10900.01,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3391,7657,1090,40760,25773,3,217,1,1487.60,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3392,7657,1090,40760,25773,3,68,1,312.40,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3393,7657,1090,40760,25773,3,57,2,1800.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3394,7657,1091,40760,25773,3,217,1,3636.36,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3395,7657,1091,40760,25773,3,68,1,763.64,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3396,7657,1091,40760,25773,3,57,2,4400.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3397,7657,1092,40760,25773,3,217,1,9090.91,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3398,7657,1092,40760,25773,3,68,1,1909.09,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3399,7657,1092,40760,25773,3,57,2,11000.00,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3400,7657,1093,40760,25773,3,217,1,20991.74,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3401,7657,1093,40760,25773,3,68,1,4408.27,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3402,7657,1093,40760,25773,3,57,2,25400.01,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3403,7657,1094,40760,25773,3,217,1,18016.53,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3404,7657,1094,40760,25773,3,68,1,3783.47,NULL,'2023-04-26 22:50:20','2023-04-26 22:50:20',NULL),(3405,7657,1094,40760,25773,3,57,2,21800.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3406,7657,1095,40760,25773,3,217,1,4297.52,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3407,7657,1095,40760,25773,3,68,1,902.48,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3408,7657,1095,40760,25773,3,57,2,5200.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3409,7657,1096,40760,25773,3,217,1,33719.01,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3410,7657,1096,40760,25773,3,68,1,7080.99,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3411,7657,1096,40760,25773,3,57,2,40800.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3412,7657,1097,40760,25773,3,217,1,30018.78,NULL,'2023-04-26 22:50:21','2023-04-27 15:41:44','2023-04-27 15:41:44'),(3413,7657,1097,40760,25773,3,68,1,6303.94,NULL,'2023-04-26 22:50:21','2023-04-27 15:41:44','2023-04-27 15:41:44'),(3414,7657,1097,40760,25773,3,217,1,17.66,NULL,'2023-04-26 22:50:21','2023-04-27 15:41:44','2023-04-27 15:41:44'),(3415,7657,1097,40760,25773,3,57,2,36340.38,NULL,'2023-04-26 22:50:21','2023-04-27 15:41:44','2023-04-27 15:41:44');
INSERT INTO `balance_libro_details` VALUES (3416,7657,1098,40760,25773,3,217,1,2892.56,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3417,7657,1098,40760,25773,3,68,1,607.44,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3418,7657,1098,40760,25773,3,57,2,3500.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3419,7657,1099,40760,25773,3,217,1,3719.01,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3420,7657,1099,40760,25773,3,68,1,780.99,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3421,7657,1099,40760,25773,3,57,2,4500.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3422,7657,1100,40760,25773,3,217,1,18842.98,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3423,7657,1100,40760,25773,3,68,1,3957.03,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3424,7657,1100,40760,25773,3,57,2,22800.01,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3425,7657,1101,40760,25773,3,217,1,7933.89,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3426,7657,1101,40760,25773,3,68,1,1666.12,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3427,7657,1101,40760,25773,3,57,2,9600.01,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3428,7657,1102,40760,25773,3,217,1,15289.26,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3429,7657,1102,40760,25773,3,68,1,3210.74,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3430,7657,1102,40760,25773,3,57,2,18500.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3431,7657,1103,40760,25773,3,217,1,7143.05,NULL,'2023-04-26 22:50:21','2023-04-27 16:41:33','2023-04-27 16:41:33'),(3432,7657,1103,40760,25773,3,68,1,1500.04,NULL,'2023-04-26 22:50:21','2023-04-27 16:41:33','2023-04-27 16:41:33'),(3433,7657,1103,40760,25773,3,217,1,57.15,NULL,'2023-04-26 22:50:21','2023-04-27 16:41:33','2023-04-27 16:41:33'),(3434,7657,1103,40760,25773,3,57,2,8700.24,NULL,'2023-04-26 22:50:21','2023-04-27 16:41:33','2023-04-27 16:41:33'),(3435,7657,1104,40760,25773,3,217,1,22982.25,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3436,7657,1104,40760,25773,3,68,1,4826.27,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3437,7657,1104,40760,25773,3,57,2,27808.52,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3438,7657,1105,40760,25773,3,217,1,413.22,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3439,7657,1105,40760,25773,3,68,1,86.78,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3440,7657,1105,40760,25773,3,57,2,500.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3441,7657,1106,40760,25773,3,217,1,1570.25,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3442,7657,1106,40760,25773,3,68,1,329.75,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3443,7657,1106,40760,25773,3,57,2,1900.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3444,7657,1107,40760,25773,3,217,1,4628.10,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3445,7657,1107,40760,25773,3,68,1,971.90,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3446,7657,1107,40760,25773,3,57,2,5600.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3447,7657,1108,40760,25773,3,217,1,5206.61,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3448,7657,1108,40760,25773,3,68,1,1093.39,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3449,7657,1108,40760,25773,3,57,2,6300.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3450,7657,1109,40760,25773,3,217,1,4958.68,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3451,7657,1109,40760,25773,3,68,1,1041.32,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3452,7657,1109,40760,25773,3,57,2,6000.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3453,7657,1110,40760,25773,3,217,1,3719.01,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3454,7657,1110,40760,25773,3,68,1,780.99,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3455,7657,1110,40760,25773,3,57,2,4500.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3456,7657,1111,40760,25773,3,217,1,2892.56,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3457,7657,1111,40760,25773,3,68,1,607.44,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3458,7657,1111,40760,25773,3,57,2,3500.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3459,7657,1112,40760,25773,3,217,1,3884.30,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3460,7657,1112,40760,25773,3,68,1,815.70,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3461,7657,1112,40760,25773,3,57,2,4700.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3462,7657,1113,40760,25773,3,217,1,7438.02,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3463,7657,1113,40760,25773,3,68,1,1561.98,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3464,7657,1113,40760,25773,3,57,2,9000.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3465,7657,1114,40760,25773,3,217,1,6363.64,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3466,7657,1114,40760,25773,3,68,1,1336.36,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3467,7657,1114,40760,25773,3,57,2,7700.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3468,7657,1115,40760,25773,3,217,1,7107.44,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3469,7657,1115,40760,25773,3,68,1,1492.56,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3470,7657,1115,40760,25773,3,57,2,8600.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3471,7657,1116,40760,25773,3,217,1,9256.20,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3472,7657,1116,40760,25773,3,68,1,1943.80,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3473,7657,1116,40760,25773,3,57,2,11200.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3474,7657,1117,40760,25773,3,217,1,1735.54,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3475,7657,1117,40760,25773,3,68,1,364.46,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3476,7657,1117,40760,25773,3,57,2,2100.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3477,7657,1118,40760,25773,3,217,1,1239.67,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3478,7657,1118,40760,25773,3,68,1,260.33,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3479,7657,1118,40760,25773,3,57,2,1500.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3480,7657,1119,40760,25773,3,217,1,5371.90,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3481,7657,1119,40760,25773,3,68,1,1128.10,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3482,7657,1119,40760,25773,3,57,2,6500.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3483,7657,1120,40760,25773,3,217,1,991.74,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3484,7657,1120,40760,25773,3,68,1,208.27,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3485,7657,1120,40760,25773,3,57,2,1200.01,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3486,7657,1121,40760,25773,3,217,1,4297.52,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3487,7657,1121,40760,25773,3,68,1,902.48,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3488,7657,1121,40760,25773,3,57,2,5200.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3489,7657,1122,40760,25773,3,217,1,10661.16,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3490,7657,1122,40760,25773,3,68,1,2238.84,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3491,7657,1122,40760,25773,3,57,2,12900.00,NULL,'2023-04-26 22:50:21','2023-04-26 22:50:21',NULL),(3492,7657,1123,40760,25773,3,217,1,6280.99,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3493,7657,1123,40760,25773,3,68,1,1319.01,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3494,7657,1123,40760,25773,3,57,2,7600.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3495,7657,1124,40760,25773,3,217,1,3057.85,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL);
INSERT INTO `balance_libro_details` VALUES (3496,7657,1124,40760,25773,3,68,1,642.15,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3497,7657,1124,40760,25773,3,57,2,3700.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3498,7657,1125,40760,25773,3,217,1,9586.78,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3499,7657,1125,40760,25773,3,68,1,2013.22,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3500,7657,1125,40760,25773,3,57,2,11600.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3501,7657,1126,40760,25773,3,217,1,2644.63,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3502,7657,1126,40760,25773,3,68,1,555.37,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3503,7657,1126,40760,25773,3,57,2,3200.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3504,7657,1127,40760,25773,3,217,1,4132.23,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3505,7657,1127,40760,25773,3,68,1,867.77,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3506,7657,1127,40760,25773,3,57,2,5000.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3507,7657,1128,40760,25773,3,217,1,661.16,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3508,7657,1128,40760,25773,3,68,1,138.84,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3509,7657,1128,40760,25773,3,57,2,800.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3510,7657,1129,40760,25773,3,217,1,5785.12,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3511,7657,1129,40760,25773,3,68,1,1214.88,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3512,7657,1129,40760,25773,3,57,2,7000.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3513,7657,1130,40760,25773,3,217,1,826.45,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3514,7657,1130,40760,25773,3,68,1,173.55,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3515,7657,1130,40760,25773,3,57,2,1000.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3516,7657,1131,40760,25773,3,217,1,14119.01,NULL,'2023-04-26 22:50:22','2023-04-27 17:13:45','2023-04-27 17:13:45'),(3517,7657,1131,40760,25773,3,68,1,2964.99,NULL,'2023-04-26 22:50:22','2023-04-27 17:13:45','2023-04-27 17:13:45'),(3518,7657,1131,40760,25773,3,217,1,467.34,NULL,'2023-04-26 22:50:22','2023-04-27 17:13:45','2023-04-27 17:13:45'),(3519,7657,1131,40760,25773,3,57,2,17551.34,NULL,'2023-04-26 22:50:22','2023-04-27 17:13:45','2023-04-27 17:13:45'),(3520,7657,1132,40760,25773,3,217,1,16851.56,NULL,'2023-04-26 22:50:22','2023-04-27 17:19:31','2023-04-27 17:19:31'),(3521,7657,1132,40760,25773,3,68,1,3538.83,NULL,'2023-04-26 22:50:22','2023-04-27 17:19:31','2023-04-27 17:19:31'),(3522,7657,1132,40760,25773,3,217,1,134.81,NULL,'2023-04-26 22:50:22','2023-04-27 17:19:31','2023-04-27 17:19:31'),(3523,7657,1132,40760,25773,3,57,2,20525.20,NULL,'2023-04-26 22:50:22','2023-04-27 17:19:31','2023-04-27 17:19:31'),(3524,7657,1133,40760,25773,3,217,1,2644.63,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3525,7657,1133,40760,25773,3,68,1,555.37,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3526,7657,1133,40760,25773,3,57,2,3200.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3527,7657,1134,40760,25773,3,217,1,3801.65,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3528,7657,1134,40760,25773,3,68,1,798.35,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3529,7657,1134,40760,25773,3,57,2,4600.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3530,7657,1135,40760,25773,3,217,1,2396.70,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3531,7657,1135,40760,25773,3,68,1,503.31,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3532,7657,1135,40760,25773,3,57,2,2900.01,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3533,7657,1136,40760,25773,3,217,1,1322.31,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3534,7657,1136,40760,25773,3,68,1,277.69,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL);
INSERT INTO `balance_libro_details` VALUES (3535,7657,1136,40760,25773,3,57,2,1600.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3536,7657,1137,40760,25773,3,217,1,3719.01,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3537,7657,1137,40760,25773,3,68,1,780.99,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3538,7657,1137,40760,25773,3,57,2,4500.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3539,7657,1138,40760,25773,3,217,1,3719.01,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3540,7657,1138,40760,25773,3,68,1,780.99,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3541,7657,1138,40760,25773,3,57,2,4500.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3542,7657,1139,40760,25773,3,217,1,826.45,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3543,7657,1139,40760,25773,3,68,1,173.55,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3544,7657,1139,40760,25773,3,57,2,1000.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3545,7657,1140,40760,25773,3,217,1,13636.36,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3546,7657,1140,40760,25773,3,68,1,2863.64,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3547,7657,1140,40760,25773,3,57,2,16500.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3548,7657,1141,40760,25773,3,217,1,1239.67,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3549,7657,1141,40760,25773,3,68,1,260.33,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3550,7657,1141,40760,25773,3,57,2,1500.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3551,7657,1142,40760,25773,3,217,1,4049.59,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3552,7657,1142,40760,25773,3,68,1,850.41,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3553,7657,1142,40760,25773,3,57,2,4900.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3554,7657,1143,40760,25773,3,217,1,3636.36,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3555,7657,1143,40760,25773,3,68,1,763.64,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3556,7657,1143,40760,25773,3,57,2,4400.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3557,7657,1144,40760,25773,3,217,1,2479.34,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3558,7657,1144,40760,25773,3,68,1,520.66,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3559,7657,1144,40760,25773,3,57,2,3000.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3560,7657,1145,40760,25773,3,217,1,3305.79,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3561,7657,1145,40760,25773,3,68,1,694.22,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3562,7657,1145,40760,25773,3,57,2,4000.01,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3563,7657,1146,40760,25773,3,217,1,10206.61,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3564,7657,1146,40760,25773,3,68,1,2143.39,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3565,7657,1146,40760,25773,3,57,2,12350.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3566,7657,1147,40760,25773,3,217,1,1570.25,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3567,7657,1147,40760,25773,3,68,1,329.75,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3568,7657,1147,40760,25773,3,57,2,1900.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3569,7657,1148,40760,25773,3,217,1,15371.90,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3570,7657,1148,40760,25773,3,68,1,3228.10,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3571,7657,1148,40760,25773,3,57,2,18600.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3572,7657,1149,40760,25773,3,217,1,2644.63,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3573,7657,1149,40760,25773,3,68,1,555.37,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL),(3574,7657,1149,40760,25773,3,57,2,3200.00,NULL,'2023-04-26 22:50:22','2023-04-26 22:50:22',NULL);
INSERT INTO `balance_libro_details` VALUES (3575,7657,1150,40760,25773,3,217,1,3471.08,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3576,7657,1150,40760,25773,3,68,1,728.93,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3577,7657,1150,40760,25773,3,57,2,4200.01,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3578,7657,1151,40760,25773,3,217,1,7024.79,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3579,7657,1151,40760,25773,3,68,1,1475.21,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3580,7657,1151,40760,25773,3,57,2,8500.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3581,7657,1152,40760,25773,3,217,1,2479.34,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3582,7657,1152,40760,25773,3,68,1,520.66,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3583,7657,1152,40760,25773,3,57,2,3000.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3584,7657,1153,40760,25773,3,217,1,2892.56,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3585,7657,1153,40760,25773,3,68,1,607.44,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3586,7657,1153,40760,25773,3,57,2,3500.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3587,7657,1154,40760,25773,3,217,1,826.45,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3588,7657,1154,40760,25773,3,68,1,173.55,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3589,7657,1154,40760,25773,3,57,2,1000.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3590,7657,1155,40760,25773,3,217,1,8264.46,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3591,7657,1155,40760,25773,3,68,1,1735.54,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3592,7657,1155,40760,25773,3,57,2,10000.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3593,7657,1156,40760,25773,3,217,1,2396.70,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3594,7657,1156,40760,25773,3,68,1,503.31,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3595,7657,1156,40760,25773,3,57,2,2900.01,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3596,7657,1157,40760,25773,3,217,1,2479.34,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3597,7657,1157,40760,25773,3,68,1,520.66,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3598,7657,1157,40760,25773,3,57,2,3000.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3599,7657,1158,40760,25773,3,217,1,1487.60,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3600,7657,1158,40760,25773,3,68,1,312.40,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3601,7657,1158,40760,25773,3,57,2,1800.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3602,7657,1159,40760,25773,3,217,1,1652.89,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3603,7657,1159,40760,25773,3,68,1,347.11,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3604,7657,1159,40760,25773,3,57,2,2000.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3605,7657,1160,40760,25773,3,217,1,10826.45,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3606,7657,1160,40760,25773,3,68,1,2273.55,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3607,7657,1160,40760,25773,3,57,2,13100.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3608,7657,1161,40760,25773,3,217,1,3553.72,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3609,7657,1161,40760,25773,3,68,1,746.28,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3610,7657,1161,40760,25773,3,57,2,4300.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3611,7657,1162,40760,25773,3,217,1,11818.18,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3612,7657,1162,40760,25773,3,68,1,2481.82,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3613,7657,1162,40760,25773,3,57,2,14300.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3614,7657,1163,40760,25773,3,217,1,2975.21,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL);
INSERT INTO `balance_libro_details` VALUES (3615,7657,1163,40760,25773,3,68,1,624.79,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3616,7657,1163,40760,25773,3,57,2,3600.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3617,7657,1164,40760,25773,3,217,1,2975.21,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3618,7657,1164,40760,25773,3,68,1,624.79,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3619,7657,1164,40760,25773,3,57,2,3600.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3620,7657,1165,40760,25773,3,217,1,3305.79,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3621,7657,1165,40760,25773,3,68,1,694.22,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3622,7657,1165,40760,25773,3,57,2,4000.01,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3623,7657,1166,40760,25773,3,250,1,28050.45,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3624,7657,1166,40760,25773,3,57,2,28050.45,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3625,7657,1167,40760,25773,3,217,1,73028.09,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3626,7657,1167,40760,25773,3,68,1,15335.90,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3627,7657,1167,40760,25773,3,57,2,88363.99,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3628,7657,1168,40760,25773,3,217,1,6893.25,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3629,7657,1168,40760,25773,3,68,1,1447.58,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3630,7657,1168,40760,25773,3,57,2,8340.83,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3631,7657,1169,40760,25773,3,217,1,21784.65,NULL,'2023-04-26 22:50:23','2023-04-27 17:44:10','2023-04-27 17:44:10'),(3632,7657,1169,40760,25773,3,68,1,4574.77,NULL,'2023-04-26 22:50:23','2023-04-27 17:44:10','2023-04-27 17:44:10'),(3633,7657,1169,40760,25773,3,217,1,3143.05,NULL,'2023-04-26 22:50:23','2023-04-27 17:44:10','2023-04-27 17:44:10'),(3634,7657,1169,40760,25773,3,57,2,29502.47,NULL,'2023-04-26 22:50:23','2023-04-27 17:44:10','2023-04-27 17:44:10'),(3635,7657,1170,40760,25773,3,217,1,145195.42,NULL,'2023-04-26 22:50:23','2023-04-27 17:54:46','2023-04-27 17:54:46'),(3636,7657,1170,40760,25773,3,68,1,30491.04,NULL,'2023-04-26 22:50:23','2023-04-27 17:54:46','2023-04-27 17:54:46'),(3637,7657,1170,40760,25773,3,217,1,5894.93,NULL,'2023-04-26 22:50:23','2023-04-27 17:54:46','2023-04-27 17:54:46'),(3638,7657,1170,40760,25773,3,57,2,181581.39,NULL,'2023-04-26 22:50:23','2023-04-27 17:54:46','2023-04-27 17:54:46'),(3639,7657,1171,40760,25773,3,217,1,4958.68,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3640,7657,1171,40760,25773,3,68,1,1041.32,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3641,7657,1171,40760,25773,3,57,2,6000.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3642,7657,1172,40760,25773,3,217,1,8760.33,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3643,7657,1172,40760,25773,3,68,1,1839.67,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3644,7657,1172,40760,25773,3,57,2,10600.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3645,7657,1173,40760,25773,3,217,1,28512.40,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3646,7657,1173,40760,25773,3,68,1,5987.60,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3647,7657,1173,40760,25773,3,57,2,34500.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3648,7657,1174,40760,25773,3,217,1,3471.08,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3649,7657,1174,40760,25773,3,68,1,728.93,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3650,7657,1174,40760,25773,3,57,2,4200.01,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3651,7657,1175,40760,25773,3,217,1,2066.12,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3652,7657,1175,40760,25773,3,68,1,433.89,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3653,7657,1175,40760,25773,3,57,2,2500.01,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL);
INSERT INTO `balance_libro_details` VALUES (3654,7657,1176,40760,25773,3,217,1,5785.12,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3655,7657,1176,40760,25773,3,68,1,1214.88,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3656,7657,1176,40760,25773,3,57,2,7000.00,NULL,'2023-04-26 22:50:23','2023-04-26 22:50:23',NULL),(3657,7657,1177,40760,25773,3,217,1,3884.30,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3658,7657,1177,40760,25773,3,68,1,815.70,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3659,7657,1177,40760,25773,3,57,2,4700.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3660,7657,1178,40760,25773,3,217,1,66958.66,NULL,'2023-04-26 22:50:24','2023-04-27 17:57:13','2023-04-27 17:57:13'),(3661,7657,1178,40760,25773,3,68,1,14000.21,NULL,'2023-04-26 22:50:24','2023-04-27 17:57:13','2023-04-27 17:57:13'),(3662,7657,1178,40760,25773,3,217,1,535.67,NULL,'2023-04-26 22:50:24','2023-04-27 17:57:13','2023-04-27 17:57:13'),(3663,7657,1178,40760,25773,3,57,2,81494.54,NULL,'2023-04-26 22:50:24','2023-04-27 17:57:13','2023-04-27 17:57:13'),(3664,7657,1179,40760,25773,3,217,1,2479.34,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3665,7657,1179,40760,25773,3,68,1,520.66,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3666,7657,1179,40760,25773,3,57,2,3000.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3667,7657,1180,40760,25773,3,217,1,7768.60,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3668,7657,1180,40760,25773,3,68,1,1631.41,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3669,7657,1180,40760,25773,3,57,2,9400.01,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3670,7657,1181,40760,25773,3,217,1,4628.10,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3671,7657,1181,40760,25773,3,68,1,971.90,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3672,7657,1181,40760,25773,3,57,2,5600.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3673,7657,1182,40760,25773,3,217,1,3884.30,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3674,7657,1182,40760,25773,3,68,1,815.70,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3675,7657,1182,40760,25773,3,57,2,4700.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3676,7657,1183,40760,25773,3,217,1,2231.41,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3677,7657,1183,40760,25773,3,68,1,468.60,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3678,7657,1183,40760,25773,3,57,2,2700.01,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3679,7657,1184,40760,25773,3,217,1,3884.30,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3680,7657,1184,40760,25773,3,68,1,815.70,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3681,7657,1184,40760,25773,3,57,2,4700.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3682,7657,1185,40760,25773,3,217,1,3719.01,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3683,7657,1185,40760,25773,3,68,1,780.99,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3684,7657,1185,40760,25773,3,57,2,4500.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3685,7657,1186,40760,25773,3,217,1,1652.89,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3686,7657,1186,40760,25773,3,68,1,347.11,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3687,7657,1186,40760,25773,3,57,2,2000.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3688,7657,1187,40760,25773,3,217,1,3305.79,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3689,7657,1187,40760,25773,3,68,1,694.22,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3690,7657,1187,40760,25773,3,57,2,4000.01,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3691,7657,1188,40760,25773,3,217,1,661.16,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3692,7657,1188,40760,25773,3,68,1,138.84,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3693,7657,1188,40760,25773,3,57,2,800.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL);
INSERT INTO `balance_libro_details` VALUES (3694,7657,1189,40760,25773,3,217,1,7272.73,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3695,7657,1189,40760,25773,3,68,1,1527.27,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3696,7657,1189,40760,25773,3,57,2,8800.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3697,7657,1190,40760,25773,3,217,1,3719.01,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3698,7657,1190,40760,25773,3,68,1,780.99,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3699,7657,1190,40760,25773,3,57,2,4500.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3700,7657,1191,40760,25773,3,217,1,661.16,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3701,7657,1191,40760,25773,3,68,1,138.84,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3702,7657,1191,40760,25773,3,57,2,800.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3703,7657,1192,40760,25773,3,217,1,1487.60,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3704,7657,1192,40760,25773,3,68,1,312.40,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3705,7657,1192,40760,25773,3,57,2,1800.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3706,7657,1193,40760,25773,3,217,1,2727.27,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3707,7657,1193,40760,25773,3,68,1,572.73,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3708,7657,1193,40760,25773,3,57,2,3300.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3709,7657,1194,40760,25773,3,217,1,2339.07,NULL,'2023-04-26 22:50:24','2023-04-27 18:05:28','2023-04-27 18:05:28'),(3710,7657,1194,40760,25773,3,68,1,491.21,NULL,'2023-04-26 22:50:24','2023-04-27 18:05:28','2023-04-27 18:05:28'),(3711,7657,1194,40760,25773,3,217,1,169.72,NULL,'2023-04-26 22:50:24','2023-04-27 18:05:28','2023-04-27 18:05:28'),(3712,7657,1194,40760,25773,3,57,2,3000.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:05:28','2023-04-27 18:05:28'),(3713,7657,1195,40760,25773,3,217,2,6854.62,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3714,7657,1195,40760,25773,3,67,2,1439.47,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3715,7657,1195,40760,25773,3,57,1,8294.09,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3716,7657,1196,40760,25773,3,217,1,310549.21,NULL,'2023-04-26 22:50:24','2023-04-27 18:15:58','2023-04-27 18:15:58'),(3717,7657,1196,40760,25773,3,68,1,65215.33,NULL,'2023-04-26 22:50:24','2023-04-27 18:15:58','2023-04-27 18:15:58'),(3718,7657,1196,40760,25773,3,217,1,10279.18,NULL,'2023-04-26 22:50:24','2023-04-27 18:15:58','2023-04-27 18:15:58'),(3719,7657,1196,40760,25773,3,57,2,386043.72,NULL,'2023-04-26 22:50:24','2023-04-27 18:15:58','2023-04-27 18:15:58'),(3720,7657,1197,40760,25773,3,217,1,49669.42,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3721,7657,1197,40760,25773,3,68,1,10430.58,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3722,7657,1197,40760,25773,3,57,2,60100.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3723,7657,1198,40760,25773,3,217,1,5661.16,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3724,7657,1198,40760,25773,3,68,1,1188.84,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3725,7657,1198,40760,25773,3,57,2,6850.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3726,7657,1199,40760,25773,3,217,1,61200.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:18:43','2023-04-27 18:18:43'),(3727,7657,1199,40760,25773,3,68,1,12852.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:18:43','2023-04-27 18:18:43'),(3728,7657,1199,40760,25773,3,217,1,489.60,NULL,'2023-04-26 22:50:24','2023-04-27 18:18:43','2023-04-27 18:18:43'),(3729,7657,1199,40760,25773,3,57,2,74541.60,NULL,'2023-04-26 22:50:24','2023-04-27 18:18:43','2023-04-27 18:18:43'),(3730,7657,1200,40760,25773,3,217,1,55900.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:20:28','2023-04-27 18:20:28'),(3731,7657,1200,40760,25773,3,68,1,11739.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:20:28','2023-04-27 18:20:28');
INSERT INTO `balance_libro_details` VALUES (3732,7657,1200,40760,25773,3,217,1,447.20,NULL,'2023-04-26 22:50:24','2023-04-27 18:20:28','2023-04-27 18:20:28'),(3733,7657,1200,40760,25773,3,57,2,68086.20,NULL,'2023-04-26 22:50:24','2023-04-27 18:20:28','2023-04-27 18:20:28'),(3734,7657,1201,40760,25773,3,217,1,4090.91,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3735,7657,1201,40760,25773,3,68,1,859.09,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3736,7657,1201,40760,25773,3,57,2,4950.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3737,7657,1202,40760,25773,3,217,1,495.87,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3738,7657,1202,40760,25773,3,68,1,104.13,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3739,7657,1202,40760,25773,3,57,2,600.00,NULL,'2023-04-26 22:50:24','2023-04-26 22:50:24',NULL),(3740,7657,1203,40760,25773,3,217,1,81200.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:22:27','2023-04-27 18:22:27'),(3741,7657,1203,40760,25773,3,68,1,17052.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:22:27','2023-04-27 18:22:27'),(3742,7657,1203,40760,25773,3,217,1,649.60,NULL,'2023-04-26 22:50:24','2023-04-27 18:22:27','2023-04-27 18:22:27'),(3743,7657,1203,40760,25773,3,57,2,98901.60,NULL,'2023-04-26 22:50:24','2023-04-27 18:22:27','2023-04-27 18:22:27'),(3744,7657,1204,40760,25773,3,217,1,50700.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:23:46','2023-04-27 18:23:46'),(3745,7657,1204,40760,25773,3,68,1,10647.00,NULL,'2023-04-26 22:50:24','2023-04-27 18:23:46','2023-04-27 18:23:46'),(3746,7657,1204,40760,25773,3,217,1,405.60,NULL,'2023-04-26 22:50:24','2023-04-27 18:23:46','2023-04-27 18:23:46'),(3747,7657,1204,40760,25773,3,57,2,61752.60,NULL,'2023-04-26 22:50:24','2023-04-27 18:23:46','2023-04-27 18:23:46'),(3748,7657,1205,40760,25773,3,217,1,84866.75,NULL,'2023-04-26 22:50:25','2023-04-27 18:26:32','2023-04-27 18:26:32'),(3749,7657,1205,40760,25773,3,68,1,17822.02,NULL,'2023-04-26 22:50:25','2023-04-27 18:26:32','2023-04-27 18:26:32'),(3750,7657,1205,40760,25773,3,217,1,12276.32,NULL,'2023-04-26 22:50:25','2023-04-27 18:26:32','2023-04-27 18:26:32'),(3751,7657,1205,40760,25773,3,57,2,114965.09,NULL,'2023-04-26 22:50:25','2023-04-27 18:26:32','2023-04-27 18:26:32'),(3752,7657,1206,40760,25773,3,217,1,4307.96,NULL,'2023-04-26 23:13:21','2023-04-26 23:13:21',NULL),(3753,7657,1206,40760,25773,3,68,1,904.67,NULL,'2023-04-26 23:13:21','2023-04-26 23:13:21',NULL),(3754,7657,1206,40760,25773,3,217,1,18.96,NULL,'2023-04-26 23:13:21','2023-04-26 23:13:21',NULL),(3755,7657,1206,40760,25773,3,238,1,142.59,NULL,'2023-04-26 23:13:21','2023-04-26 23:13:21',NULL),(3756,7657,1206,40760,25773,3,57,2,5374.18,NULL,'2023-04-26 23:13:21','2023-04-26 23:13:21',NULL),(3757,7657,1207,40760,25773,3,217,1,52538.39,NULL,'2023-04-26 23:15:52','2023-04-26 23:15:52',NULL),(3758,7657,1207,40760,25773,3,68,1,11033.06,NULL,'2023-04-26 23:15:52','2023-04-26 23:15:52',NULL),(3759,7657,1207,40760,25773,3,222,1,7765.16,NULL,'2023-04-26 23:15:52','2023-04-26 23:15:52',NULL),(3760,7657,1207,40760,25773,3,57,2,71336.61,NULL,'2023-04-26 23:15:52','2023-04-26 23:15:52',NULL),(3761,7657,1208,40760,25773,3,217,1,2718.27,NULL,'2023-04-26 23:18:38','2023-04-26 23:18:38',NULL),(3762,7657,1208,40760,25773,3,68,1,570.84,NULL,'2023-04-26 23:18:38','2023-04-26 23:18:38',NULL),(3763,7657,1208,40760,25773,3,222,1,210.90,NULL,'2023-04-26 23:18:38','2023-04-26 23:18:38',NULL),(3764,7657,1208,40760,25773,3,57,2,3500.01,NULL,'2023-04-26 23:18:38','2023-04-26 23:18:38',NULL),(3765,7657,1209,40760,25773,3,217,1,73000.69,NULL,'2023-04-26 23:22:45','2023-04-26 23:22:45',NULL),(3766,7657,1209,40760,25773,3,68,1,15330.14,NULL,'2023-04-26 23:22:45','2023-04-26 23:22:45',NULL),(3767,7657,1209,40760,25773,3,222,1,10789.47,NULL,'2023-04-26 23:22:45','2023-04-26 23:22:45',NULL),(3768,7657,1209,40760,25773,3,57,2,99120.30,NULL,'2023-04-26 23:22:45','2023-04-26 23:22:45',NULL),(3769,7657,1210,40760,25773,3,217,1,552823.64,NULL,'2023-04-26 23:29:24','2023-04-26 23:29:24',NULL);
INSERT INTO `balance_libro_details` VALUES (3770,7657,1210,40760,25773,3,68,1,116092.96,NULL,'2023-04-26 23:29:24','2023-04-26 23:29:24',NULL),(3771,7657,1210,40760,25773,3,238,1,18298.46,NULL,'2023-04-26 23:29:24','2023-04-26 23:29:24',NULL),(3772,7657,1210,40760,25773,3,57,2,687215.06,NULL,'2023-04-26 23:29:24','2023-04-26 23:29:24',NULL),(3773,7657,1211,40760,25773,3,217,1,32292.15,NULL,'2023-04-26 23:39:54','2023-04-26 23:39:54',NULL),(3774,7657,1211,40760,25773,3,68,1,6781.35,NULL,'2023-04-26 23:39:54','2023-04-26 23:39:54',NULL),(3775,7657,1211,40760,25773,3,217,1,258.34,NULL,'2023-04-26 23:39:54','2023-04-26 23:39:54',NULL),(3776,7657,1211,40760,25773,3,57,2,38262.97,NULL,'2023-04-26 23:39:54','2023-04-26 23:39:54',NULL),(3777,7657,1211,40760,25773,3,136,2,1068.87,NULL,'2023-04-26 23:39:54','2023-04-26 23:39:54',NULL),(3778,7657,1212,40760,25773,3,217,1,11535.87,NULL,'2023-04-26 23:48:18','2023-04-27 07:13:30','2023-04-27 07:13:30'),(3779,7657,1212,40760,25773,3,68,1,2422.53,NULL,'2023-04-26 23:48:18','2023-04-27 07:13:30','2023-04-27 07:13:30'),(3780,7657,1212,40760,25773,3,217,1,92.29,NULL,'2023-04-26 23:48:18','2023-04-27 07:13:30','2023-04-27 07:13:30'),(3781,7657,1212,40760,25773,3,238,1,381.84,NULL,'2023-04-26 23:48:18','2023-04-27 07:13:30','2023-04-27 07:13:30'),(3782,7657,1212,40760,25773,3,57,2,14432.53,NULL,'2023-04-26 23:48:18','2023-04-27 07:13:30','2023-04-27 07:13:30'),(3783,7657,1213,40760,25773,3,217,1,11535.87,NULL,'2023-04-27 07:13:30','2023-04-27 07:13:30',NULL),(3784,7657,1213,40760,25773,3,68,1,2422.53,NULL,'2023-04-27 07:13:30','2023-04-27 07:13:30',NULL),(3785,7657,1213,40760,25773,3,217,1,92.29,NULL,'2023-04-27 07:13:30','2023-04-27 07:13:30',NULL),(3786,7657,1213,40760,25773,3,238,1,381.84,NULL,'2023-04-27 07:13:30','2023-04-27 07:13:30',NULL),(3787,7657,1213,40760,25773,3,57,2,14432.53,NULL,'2023-04-27 07:13:30','2023-04-27 07:13:30',NULL),(3788,7657,1214,40760,25773,3,217,1,92470.54,NULL,'2023-04-27 07:21:10','2023-04-27 07:21:10',NULL),(3789,7657,1214,40760,25773,3,68,1,19418.81,NULL,'2023-04-27 07:21:10','2023-04-27 07:21:10',NULL),(3790,7657,1214,40760,25773,3,238,1,3060.77,NULL,'2023-04-27 07:21:10','2023-04-27 07:21:10',NULL),(3791,7657,1214,40760,25773,3,57,2,114950.12,NULL,'2023-04-27 07:21:10','2023-04-27 07:21:10',NULL),(3792,7657,1215,40760,25773,3,217,1,67938.71,NULL,'2023-04-27 07:30:27','2023-04-27 07:30:27',NULL),(3793,7657,1215,40760,25773,3,68,1,14267.13,NULL,'2023-04-27 07:30:27','2023-04-27 07:30:27',NULL),(3794,7657,1215,40760,25773,3,217,1,543.51,NULL,'2023-04-27 07:30:27','2023-04-27 07:30:27',NULL),(3795,7657,1215,40760,25773,3,238,1,2248.77,NULL,'2023-04-27 07:30:27','2023-04-27 07:30:27',NULL),(3796,7657,1215,40760,25773,3,57,2,84998.12,NULL,'2023-04-27 07:30:27','2023-04-27 07:30:27',NULL),(3797,7657,1216,40760,25773,3,217,1,30018.78,NULL,'2023-04-27 15:41:44','2023-04-27 15:41:44',NULL),(3798,7657,1216,40760,25773,3,68,1,6303.94,NULL,'2023-04-27 15:41:44','2023-04-27 15:41:44',NULL),(3799,7657,1216,40760,25773,3,217,1,17.66,NULL,'2023-04-27 15:41:44','2023-04-27 15:41:44',NULL),(3800,7657,1216,40760,25773,3,57,2,36340.38,NULL,'2023-04-27 15:41:44','2023-04-27 15:41:44',NULL),(3801,7657,1217,40760,25773,3,217,1,7143.05,NULL,'2023-04-27 16:41:33','2023-04-27 16:41:33',NULL),(3802,7657,1217,40760,25773,3,68,1,1500.04,NULL,'2023-04-27 16:41:33','2023-04-27 16:41:33',NULL),(3803,7657,1217,40760,25773,3,217,1,57.15,NULL,'2023-04-27 16:41:33','2023-04-27 16:41:33',NULL),(3804,7657,1217,40760,25773,3,57,2,8700.24,NULL,'2023-04-27 16:41:33','2023-04-27 16:41:33',NULL),(3805,7657,1218,40760,25773,3,217,1,14119.01,NULL,'2023-04-27 17:13:45','2023-04-27 17:13:45',NULL),(3806,7657,1218,40760,25773,3,68,1,2964.99,NULL,'2023-04-27 17:13:45','2023-04-27 17:13:45',NULL),(3807,7657,1218,40760,25773,3,238,1,467.34,NULL,'2023-04-27 17:13:45','2023-04-27 17:13:45',NULL),(3808,7657,1218,40760,25773,3,57,2,17551.34,NULL,'2023-04-27 17:13:45','2023-04-27 17:13:45',NULL);
INSERT INTO `balance_libro_details` VALUES (3809,7657,1219,40760,25773,3,217,1,16851.56,NULL,'2023-04-27 17:19:31','2023-04-27 17:19:31',NULL),(3810,7657,1219,40760,25773,3,68,1,3538.83,NULL,'2023-04-27 17:19:31','2023-04-27 17:19:31',NULL),(3811,7657,1219,40760,25773,3,217,1,134.81,NULL,'2023-04-27 17:19:31','2023-04-27 17:19:31',NULL),(3812,7657,1219,40760,25773,3,57,2,20525.20,NULL,'2023-04-27 17:19:31','2023-04-27 17:19:31',NULL),(3813,7657,1220,40760,25773,3,217,1,21784.65,NULL,'2023-04-27 17:44:10','2023-04-27 17:44:10',NULL),(3814,7657,1220,40760,25773,3,68,1,4574.78,NULL,'2023-04-27 17:44:10','2023-04-27 17:44:10',NULL),(3815,7657,1220,40760,25773,3,222,1,3143.05,NULL,'2023-04-27 17:44:10','2023-04-27 17:44:10',NULL),(3816,7657,1220,40760,25773,3,57,2,29502.48,NULL,'2023-04-27 17:44:10','2023-04-27 17:44:10',NULL),(3817,7657,1221,40760,25773,3,217,1,145195.42,NULL,'2023-04-27 17:54:46','2023-04-27 17:54:46',NULL),(3818,7657,1221,40760,25773,3,68,1,30491.04,NULL,'2023-04-27 17:54:46','2023-04-27 17:54:46',NULL),(3819,7657,1221,40760,25773,3,217,1,1088.96,NULL,'2023-04-27 17:54:46','2023-04-27 17:54:46',NULL),(3820,7657,1221,40760,25773,3,238,1,4805.97,NULL,'2023-04-27 17:54:46','2023-04-27 17:54:46',NULL),(3821,7657,1221,40760,25773,3,57,2,181581.39,NULL,'2023-04-27 17:54:46','2023-04-27 17:54:46',NULL),(3822,7657,1222,40760,25773,3,217,1,66958.66,NULL,'2023-04-27 17:57:13','2023-04-27 18:11:18','2023-04-27 18:11:18'),(3823,7657,1222,40760,25773,3,68,1,14061.32,NULL,'2023-04-27 17:57:13','2023-04-27 18:11:18','2023-04-27 18:11:18'),(3824,7657,1222,40760,25773,3,217,1,535.67,NULL,'2023-04-27 17:57:13','2023-04-27 18:11:18','2023-04-27 18:11:18'),(3825,7657,1222,40760,25773,3,57,2,81555.65,NULL,'2023-04-27 17:57:13','2023-04-27 18:11:18','2023-04-27 18:11:18'),(3826,7657,1223,40760,25773,3,217,1,2339.07,NULL,'2023-04-27 18:05:28','2023-04-27 18:05:28',NULL),(3827,7657,1223,40760,25773,3,68,1,491.20,NULL,'2023-04-27 18:05:28','2023-04-27 18:05:28',NULL),(3828,7657,1223,40760,25773,3,217,1,92.29,NULL,'2023-04-27 18:05:28','2023-04-27 18:05:28',NULL),(3829,7657,1223,40760,25773,3,238,1,77.43,NULL,'2023-04-27 18:05:28','2023-04-27 18:05:28',NULL),(3830,7657,1223,40760,25773,3,57,2,2999.99,NULL,'2023-04-27 18:05:28','2023-04-27 18:05:28',NULL),(3831,7657,1224,40760,25773,3,217,1,66958.66,NULL,'2023-04-27 18:11:18','2023-04-27 18:11:18',NULL),(3832,7657,1224,40760,25773,3,68,1,14061.32,NULL,'2023-04-27 18:11:18','2023-04-27 18:11:18',NULL),(3833,7657,1224,40760,25773,3,217,1,535.67,NULL,'2023-04-27 18:11:18','2023-04-27 18:11:18',NULL),(3834,7657,1224,40760,25773,3,57,2,81555.65,NULL,'2023-04-27 18:11:18','2023-04-27 18:11:18',NULL),(3835,7657,1225,40760,25773,3,217,1,310549.21,NULL,'2023-04-27 18:15:58','2023-04-27 18:15:58',NULL),(3836,7657,1225,40760,25773,3,68,1,65215.33,NULL,'2023-04-27 18:15:58','2023-04-27 18:15:58',NULL),(3837,7657,1225,40760,25773,3,238,1,10279.18,NULL,'2023-04-27 18:15:58','2023-04-27 18:15:58',NULL),(3838,7657,1225,40760,25773,3,57,2,386043.72,NULL,'2023-04-27 18:15:58','2023-04-27 18:15:58',NULL),(3839,7657,1226,40760,25773,3,217,1,61200.00,NULL,'2023-04-27 18:18:43','2023-04-27 18:18:43',NULL),(3840,7657,1226,40760,25773,3,68,1,12852.00,NULL,'2023-04-27 18:18:43','2023-04-27 18:18:43',NULL),(3841,7657,1226,40760,25773,3,217,1,489.60,NULL,'2023-04-27 18:18:43','2023-04-27 18:18:43',NULL),(3842,7657,1226,40760,25773,3,57,2,74541.60,NULL,'2023-04-27 18:18:43','2023-04-27 18:18:43',NULL),(3843,7657,1227,40760,25773,3,217,1,55900.00,NULL,'2023-04-27 18:20:28','2023-04-27 18:20:28',NULL),(3844,7657,1227,40760,25773,3,68,1,11739.00,NULL,'2023-04-27 18:20:28','2023-04-27 18:20:28',NULL),(3845,7657,1227,40760,25773,3,217,1,447.20,NULL,'2023-04-27 18:20:28','2023-04-27 18:20:28',NULL),(3846,7657,1227,40760,25773,3,57,2,68086.20,NULL,'2023-04-27 18:20:28','2023-04-27 18:20:28',NULL),(3847,7657,1228,40760,25773,3,217,1,81200.00,NULL,'2023-04-27 18:22:27','2023-04-27 18:22:27',NULL);
INSERT INTO `balance_libro_details` VALUES (3848,7657,1228,40760,25773,3,68,1,17052.00,NULL,'2023-04-27 18:22:27','2023-04-27 18:22:27',NULL),(3849,7657,1228,40760,25773,3,217,1,649.60,NULL,'2023-04-27 18:22:27','2023-04-27 18:22:27',NULL),(3850,7657,1228,40760,25773,3,57,2,98901.60,NULL,'2023-04-27 18:22:27','2023-04-27 18:22:27',NULL),(3851,7657,1229,40760,25773,3,217,1,50700.00,NULL,'2023-04-27 18:23:46','2023-04-27 18:23:46',NULL),(3852,7657,1229,40760,25773,3,68,1,10647.00,NULL,'2023-04-27 18:23:46','2023-04-27 18:23:46',NULL),(3853,7657,1229,40760,25773,3,217,1,405.60,NULL,'2023-04-27 18:23:46','2023-04-27 18:23:46',NULL),(3854,7657,1229,40760,25773,3,57,2,61752.60,NULL,'2023-04-27 18:23:46','2023-04-27 18:23:46',NULL),(3855,7657,1230,40760,25773,3,217,1,84866.75,NULL,'2023-04-27 18:26:32','2023-04-27 18:26:32',NULL),(3856,7657,1230,40760,25773,3,68,1,17822.02,NULL,'2023-04-27 18:26:32','2023-04-27 18:26:32',NULL),(3857,7657,1230,40760,25773,3,222,1,12276.32,NULL,'2023-04-27 18:26:32','2023-04-27 18:26:32',NULL),(3858,7657,1230,40760,25773,3,57,2,114965.09,NULL,'2023-04-27 18:26:32','2023-04-27 18:26:32',NULL),(3859,7657,1231,40760,25774,2,96,2,3075.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3860,7657,1231,40760,25774,2,67,2,645.75,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3861,7657,1231,40760,25774,2,13,1,3720.75,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3862,7657,1232,40760,25774,2,96,2,4710.74,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3863,7657,1232,40760,25774,2,67,2,989.26,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3864,7657,1232,40760,25774,2,13,1,5700.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3865,7657,1233,40760,25774,2,96,2,2355.37,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3866,7657,1233,40760,25774,2,67,2,494.63,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3867,7657,1233,40760,25774,2,13,1,2850.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3868,7657,1234,40760,25774,2,96,2,24793.39,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3869,7657,1234,40760,25774,2,67,2,5206.61,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3870,7657,1234,40760,25774,2,13,1,30000.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3871,7657,1235,40760,25774,2,96,2,1239.67,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3872,7657,1235,40760,25774,2,67,2,260.33,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3873,7657,1235,40760,25774,2,13,1,1500.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3874,7657,1236,40760,25774,2,96,2,4257.85,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3875,7657,1236,40760,25774,2,67,2,894.15,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3876,7657,1236,40760,25774,2,13,1,5152.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3877,7657,1237,40760,25774,2,96,2,6710.75,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3878,7657,1237,40760,25774,2,67,2,1409.25,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3879,7657,1237,40760,25774,2,13,1,8120.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3880,7657,1238,40760,25774,2,96,2,909.09,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3881,7657,1238,40760,25774,2,67,2,190.91,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3882,7657,1238,40760,25774,2,13,1,1100.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3883,7657,1239,40760,25774,2,96,2,1867.76,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3884,7657,1239,40760,25774,2,67,2,392.24,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3885,7657,1239,40760,25774,2,13,1,2260.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3886,7657,1240,40760,25774,2,96,2,10752.06,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3887,7657,1240,40760,25774,2,67,2,2257.94,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3888,7657,1240,40760,25774,2,13,1,13010.00,NULL,'2023-04-29 21:27:02','2023-04-29 21:27:02',NULL),(3889,7657,1241,40760,25774,3,217,1,639.37,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3890,7657,1241,40760,25774,3,68,1,134.27,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3891,7657,1241,40760,25774,3,57,2,773.64,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3892,7657,1242,40760,25774,3,217,1,28800.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3893,7657,1242,40760,25774,3,68,1,6048.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3894,7657,1242,40760,25774,3,57,2,34848.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3895,7657,1243,40760,25774,3,217,1,2619.82,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3896,7657,1243,40760,25774,3,68,1,550.16,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3897,7657,1243,40760,25774,3,57,2,3169.98,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3898,7657,1244,40760,25774,3,217,1,2241.56,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3899,7657,1244,40760,25774,3,68,1,470.73,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3900,7657,1244,40760,25774,3,57,2,2712.29,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3901,7657,1245,40760,25774,3,217,1,2248.35,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3902,7657,1245,40760,25774,3,68,1,472.15,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3903,7657,1245,40760,25774,3,57,2,2720.50,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3904,7657,1246,40760,25774,3,217,1,1528.93,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3905,7657,1246,40760,25774,3,68,1,321.08,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3906,7657,1246,40760,25774,3,57,2,1850.01,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3907,7657,1247,40760,25774,3,217,1,1322.31,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3908,7657,1247,40760,25774,3,68,1,277.69,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3909,7657,1247,40760,25774,3,57,2,1600.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3910,7657,1248,40760,25774,3,217,1,1487.60,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3911,7657,1248,40760,25774,3,68,1,312.40,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3912,7657,1248,40760,25774,3,57,2,1800.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3913,7657,1249,40760,25774,3,217,1,6611.57,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3914,7657,1249,40760,25774,3,68,1,1388.43,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3915,7657,1249,40760,25774,3,57,2,8000.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3916,7657,1250,40760,25774,3,217,1,13140.50,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3917,7657,1250,40760,25774,3,68,1,2759.50,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3918,7657,1250,40760,25774,3,57,2,15900.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3919,7657,1251,40760,25774,3,217,1,1487.60,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3920,7657,1251,40760,25774,3,68,1,312.40,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3921,7657,1251,40760,25774,3,57,2,1800.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3922,7657,1252,40760,25774,3,217,1,3884.30,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3923,7657,1252,40760,25774,3,68,1,815.70,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3924,7657,1252,40760,25774,3,57,2,4700.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3925,7657,1253,40760,25774,3,217,1,22830.58,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3926,7657,1253,40760,25774,3,68,1,4794.42,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3927,7657,1253,40760,25774,3,57,2,27625.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL);
INSERT INTO `balance_libro_details` VALUES (3928,7657,1254,40760,25774,3,217,1,8263.64,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3929,7657,1254,40760,25774,3,68,1,1735.36,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3930,7657,1254,40760,25774,3,57,2,9999.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3931,7657,1255,40760,25774,3,250,1,2658.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:35:10','2023-04-29 21:35:10'),(3932,7657,1255,40760,25774,3,57,2,2658.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:35:10','2023-04-29 21:35:10'),(3933,7657,1256,40760,25774,3,217,1,1487.60,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3934,7657,1256,40760,25774,3,68,1,312.40,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3935,7657,1256,40760,25774,3,57,2,1800.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3936,7657,1257,40760,25774,3,217,1,661.16,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3937,7657,1257,40760,25774,3,68,1,138.84,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3938,7657,1257,40760,25774,3,57,2,800.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3939,7657,1258,40760,25774,3,217,1,743.80,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3940,7657,1258,40760,25774,3,68,1,156.20,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3941,7657,1258,40760,25774,3,57,2,900.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3942,7657,1259,40760,25774,3,217,1,1322.31,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3943,7657,1259,40760,25774,3,68,1,277.69,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3944,7657,1259,40760,25774,3,57,2,1600.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3945,7657,1260,40760,25774,3,217,1,21239.67,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3946,7657,1260,40760,25774,3,68,1,4460.33,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3947,7657,1260,40760,25774,3,57,2,25700.00,NULL,'2023-04-29 21:27:51','2023-04-29 21:27:51',NULL),(3948,7657,1261,40760,25774,3,217,1,63636.36,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3949,7657,1261,40760,25774,3,68,1,13363.64,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3950,7657,1261,40760,25774,3,57,2,77000.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3951,7657,1262,40760,25774,3,217,1,4380.17,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3952,7657,1262,40760,25774,3,68,1,919.84,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3953,7657,1262,40760,25774,3,57,2,5300.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3954,7657,1263,40760,25774,3,217,1,3719.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3955,7657,1263,40760,25774,3,68,1,780.99,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3956,7657,1263,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3957,7657,1264,40760,25774,3,217,1,11378.27,NULL,'2023-04-29 21:27:52','2023-04-29 21:41:34','2023-04-29 21:41:34'),(3958,7657,1264,40760,25774,3,68,1,2389.44,NULL,'2023-04-29 21:27:52','2023-04-29 21:41:34','2023-04-29 21:41:34'),(3959,7657,1264,40760,25774,3,217,1,426.69,NULL,'2023-04-29 21:27:52','2023-04-29 21:41:34','2023-04-29 21:41:34'),(3960,7657,1264,40760,25774,3,57,2,14194.40,NULL,'2023-04-29 21:27:52','2023-04-29 21:41:34','2023-04-29 21:41:34'),(3961,7657,1265,40760,25774,3,217,1,413.22,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3962,7657,1265,40760,25774,3,68,1,86.78,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3963,7657,1265,40760,25774,3,57,2,500.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3964,7657,1266,40760,25774,3,217,1,8760.33,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3965,7657,1266,40760,25774,3,68,1,1839.67,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3966,7657,1266,40760,25774,3,57,2,10600.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3967,7657,1267,40760,25774,3,217,1,6776.87,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3968,7657,1267,40760,25774,3,68,1,1423.14,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3969,7657,1267,40760,25774,3,57,2,8200.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3970,7657,1268,40760,25774,3,217,1,2066.12,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3971,7657,1268,40760,25774,3,68,1,433.89,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3972,7657,1268,40760,25774,3,57,2,2500.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3973,7657,1269,40760,25774,3,217,1,329.68,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3974,7657,1269,40760,25774,3,68,1,69.23,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3975,7657,1269,40760,25774,3,57,2,398.91,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3976,7657,1270,40760,25774,3,217,1,10215.69,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3977,7657,1270,40760,25774,3,68,1,2145.29,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3978,7657,1270,40760,25774,3,57,2,12360.98,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3979,7657,1271,40760,25774,3,217,1,5454.55,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3980,7657,1271,40760,25774,3,68,1,1145.46,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3981,7657,1271,40760,25774,3,57,2,6600.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3982,7657,1272,40760,25774,3,217,1,330.58,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3983,7657,1272,40760,25774,3,68,1,69.42,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3984,7657,1272,40760,25774,3,57,2,400.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3985,7657,1273,40760,25774,3,217,1,7272.73,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3986,7657,1273,40760,25774,3,68,1,1527.27,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3987,7657,1273,40760,25774,3,57,2,8800.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3988,7657,1274,40760,25774,3,217,1,3553.72,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3989,7657,1274,40760,25774,3,68,1,746.28,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3990,7657,1274,40760,25774,3,57,2,4300.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3991,7657,1275,40760,25774,3,217,1,7520.67,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3992,7657,1275,40760,25774,3,68,1,1579.34,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3993,7657,1275,40760,25774,3,57,2,9100.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3994,7657,1276,40760,25774,3,217,1,53833.39,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3995,7657,1276,40760,25774,3,68,1,11305.11,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3996,7657,1276,40760,25774,3,57,2,65138.50,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3997,7657,1277,40760,25774,3,217,1,4214.88,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3998,7657,1277,40760,25774,3,68,1,885.12,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(3999,7657,1277,40760,25774,3,57,2,5100.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4000,7657,1278,40760,25774,3,217,1,330.58,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4001,7657,1278,40760,25774,3,68,1,69.42,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4002,7657,1278,40760,25774,3,57,2,400.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4003,7657,1279,40760,25774,3,217,1,11157.03,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4004,7657,1279,40760,25774,3,68,1,2342.98,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4005,7657,1279,40760,25774,3,57,2,13500.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4006,7657,1280,40760,25774,3,217,1,3619.84,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL);
INSERT INTO `balance_libro_details` VALUES (4007,7657,1280,40760,25774,3,68,1,760.17,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4008,7657,1280,40760,25774,3,57,2,4380.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4009,7657,1281,40760,25774,3,217,1,16115.70,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4010,7657,1281,40760,25774,3,68,1,3384.30,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4011,7657,1281,40760,25774,3,57,2,19500.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4012,7657,1282,40760,25774,3,217,1,342000.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4013,7657,1282,40760,25774,3,68,1,71820.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4014,7657,1282,40760,25774,3,57,2,413820.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4015,7657,1283,40760,25774,3,217,1,6879.87,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4016,7657,1283,40760,25774,3,68,1,1444.78,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4017,7657,1283,40760,25774,3,57,2,8324.65,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4018,7657,1284,40760,25774,3,217,1,6280.99,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4019,7657,1284,40760,25774,3,68,1,1319.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4020,7657,1284,40760,25774,3,57,2,7600.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4021,7657,1285,40760,25774,3,217,1,8429.75,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4022,7657,1285,40760,25774,3,68,1,1770.25,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4023,7657,1285,40760,25774,3,57,2,10200.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4024,7657,1286,40760,25774,3,217,1,6859.51,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4025,7657,1286,40760,25774,3,68,1,1440.50,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4026,7657,1286,40760,25774,3,57,2,8300.01,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4027,7657,1287,40760,25774,3,217,1,14628.10,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4028,7657,1287,40760,25774,3,68,1,3071.90,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4029,7657,1287,40760,25774,3,57,2,17700.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4030,7657,1288,40760,25774,3,217,1,4297.52,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4031,7657,1288,40760,25774,3,68,1,902.48,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4032,7657,1288,40760,25774,3,57,2,5200.00,NULL,'2023-04-29 21:27:52','2023-04-29 21:27:52',NULL),(4033,7657,1289,40760,25774,3,217,1,3801.65,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4034,7657,1289,40760,25774,3,68,1,798.35,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4035,7657,1289,40760,25774,3,57,2,4600.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4036,7657,1290,40760,25774,3,217,1,9917.36,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4037,7657,1290,40760,25774,3,68,1,2082.65,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4038,7657,1290,40760,25774,3,57,2,12000.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4039,7657,1291,40760,25774,3,217,1,31553.29,NULL,'2023-04-29 21:27:53','2023-04-29 21:44:11','2023-04-29 21:44:11'),(4040,7657,1291,40760,25774,3,68,1,6626.19,NULL,'2023-04-29 21:27:53','2023-04-29 21:44:11','2023-04-29 21:44:11'),(4041,7657,1291,40760,25774,3,217,1,252.43,NULL,'2023-04-29 21:27:53','2023-04-29 21:44:11','2023-04-29 21:44:11'),(4042,7657,1291,40760,25774,3,57,2,38431.91,NULL,'2023-04-29 21:27:53','2023-04-29 21:44:11','2023-04-29 21:44:11'),(4043,7657,1292,40760,25774,3,217,1,5454.55,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4044,7657,1292,40760,25774,3,68,1,1145.46,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4045,7657,1292,40760,25774,3,57,2,6600.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL);
INSERT INTO `balance_libro_details` VALUES (4046,7657,1293,40760,25774,3,217,1,991.74,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4047,7657,1293,40760,25774,3,68,1,208.27,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4048,7657,1293,40760,25774,3,57,2,1200.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4049,7657,1294,40760,25774,3,217,1,3305.79,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4050,7657,1294,40760,25774,3,68,1,694.22,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4051,7657,1294,40760,25774,3,57,2,4000.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4052,7657,1295,40760,25774,3,217,1,1570.25,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4053,7657,1295,40760,25774,3,68,1,329.75,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4054,7657,1295,40760,25774,3,57,2,1900.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4055,7657,1296,40760,25774,3,217,1,619.84,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4056,7657,1296,40760,25774,3,68,1,130.17,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4057,7657,1296,40760,25774,3,57,2,750.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4058,7657,1297,40760,25774,3,217,1,2231.41,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4059,7657,1297,40760,25774,3,68,1,468.60,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4060,7657,1297,40760,25774,3,57,2,2700.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4061,7657,1298,40760,25774,3,217,1,13966.94,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4062,7657,1298,40760,25774,3,68,1,2933.06,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4063,7657,1298,40760,25774,3,57,2,16900.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4064,7657,1299,40760,25774,3,217,1,7873303.17,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4065,7657,1299,40760,25774,3,68,1,826696.83,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4066,7657,1299,40760,25774,3,57,2,8700000.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4067,7657,1300,40760,25774,3,217,1,34327.04,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4068,7657,1300,40760,25774,3,68,1,7208.66,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4069,7657,1300,40760,25774,3,57,2,41535.70,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4070,7657,1301,40760,25774,3,217,1,219768.28,NULL,'2023-04-29 21:27:53','2023-04-29 21:49:13','2023-04-29 21:49:13'),(4071,7657,1301,40760,25774,3,68,1,46151.34,NULL,'2023-04-29 21:27:53','2023-04-29 21:49:13','2023-04-29 21:49:13'),(4072,7657,1301,40760,25774,3,217,1,7274.33,NULL,'2023-04-29 21:27:53','2023-04-29 21:49:13','2023-04-29 21:49:13'),(4073,7657,1301,40760,25774,3,57,2,273193.95,NULL,'2023-04-29 21:27:53','2023-04-29 21:49:13','2023-04-29 21:49:13'),(4074,7657,1302,40760,25774,3,217,1,3719.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4075,7657,1302,40760,25774,3,68,1,780.99,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4076,7657,1302,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4077,7657,1303,40760,25774,3,217,1,2148.76,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4078,7657,1303,40760,25774,3,68,1,451.24,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4079,7657,1303,40760,25774,3,57,2,2600.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4080,7657,1304,40760,25774,3,217,1,3471.08,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4081,7657,1304,40760,25774,3,68,1,728.93,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4082,7657,1304,40760,25774,3,57,2,4200.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4083,7657,1305,40760,25774,3,217,1,2231.41,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4084,7657,1305,40760,25774,3,68,1,468.60,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4085,7657,1305,40760,25774,3,57,2,2700.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL);
INSERT INTO `balance_libro_details` VALUES (4086,7657,1306,40760,25774,3,217,1,21818.18,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4087,7657,1306,40760,25774,3,68,1,4581.82,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4088,7657,1306,40760,25774,3,57,2,26400.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4089,7657,1307,40760,25774,3,217,1,2974.37,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4090,7657,1307,40760,25774,3,68,1,624.62,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4091,7657,1307,40760,25774,3,57,2,3598.99,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4092,7657,1308,40760,25774,3,217,1,6363.64,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4093,7657,1308,40760,25774,3,68,1,1336.36,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4094,7657,1308,40760,25774,3,57,2,7700.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4095,7657,1309,40760,25774,3,217,1,11157.03,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4096,7657,1309,40760,25774,3,68,1,2342.98,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4097,7657,1309,40760,25774,3,57,2,13500.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4098,7657,1310,40760,25774,3,217,1,2892.56,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4099,7657,1310,40760,25774,3,68,1,607.44,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4100,7657,1310,40760,25774,3,57,2,3500.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4101,7657,1311,40760,25774,3,217,1,6115.70,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4102,7657,1311,40760,25774,3,68,1,1284.30,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4103,7657,1311,40760,25774,3,57,2,7400.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4104,7657,1312,40760,25774,3,217,1,32558.68,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4105,7657,1312,40760,25774,3,68,1,6837.32,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4106,7657,1312,40760,25774,3,57,2,39396.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4107,7657,1313,40760,25774,3,217,1,7438.02,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4108,7657,1313,40760,25774,3,68,1,1561.98,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4109,7657,1313,40760,25774,3,57,2,9000.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4110,7657,1314,40760,25774,3,217,1,3388.43,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4111,7657,1314,40760,25774,3,68,1,711.57,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4112,7657,1314,40760,25774,3,57,2,4100.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4113,7657,1315,40760,25774,3,217,1,13388.43,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4114,7657,1315,40760,25774,3,68,1,2811.57,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4115,7657,1315,40760,25774,3,57,2,16200.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4116,7657,1316,40760,25774,3,217,1,11239.67,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4117,7657,1316,40760,25774,3,68,1,2360.33,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4118,7657,1316,40760,25774,3,57,2,13600.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4119,7657,1317,40760,25774,3,217,1,25537.20,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4120,7657,1317,40760,25774,3,68,1,5362.81,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4121,7657,1317,40760,25774,3,57,2,30900.01,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4122,7657,1318,40760,25774,3,217,1,5537.19,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4123,7657,1318,40760,25774,3,68,1,1162.81,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4124,7657,1318,40760,25774,3,57,2,6700.00,NULL,'2023-04-29 21:27:53','2023-04-29 21:27:53',NULL),(4125,7657,1319,40760,25774,3,250,1,44688.40,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL);
INSERT INTO `balance_libro_details` VALUES (4126,7657,1319,40760,25774,3,57,2,44688.40,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4127,7657,1320,40760,25774,3,217,1,4545.46,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4128,7657,1320,40760,25774,3,68,1,954.55,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4129,7657,1320,40760,25774,3,57,2,5500.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4130,7657,1321,40760,25774,3,217,1,1487.60,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4131,7657,1321,40760,25774,3,68,1,312.40,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4132,7657,1321,40760,25774,3,57,2,1800.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4133,7657,1322,40760,25774,3,217,1,8457.21,NULL,'2023-04-29 21:27:54','2023-04-29 21:54:11','2023-04-29 21:54:11'),(4134,7657,1322,40760,25774,3,68,1,1776.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:54:11','2023-04-29 21:54:11'),(4135,7657,1322,40760,25774,3,217,1,67.66,NULL,'2023-04-29 21:27:54','2023-04-29 21:54:11','2023-04-29 21:54:11'),(4136,7657,1322,40760,25774,3,57,2,10300.88,NULL,'2023-04-29 21:27:54','2023-04-29 21:54:11','2023-04-29 21:54:11'),(4137,7657,1323,40760,25774,3,217,1,14035.54,NULL,'2023-04-29 21:27:54','2023-04-29 21:57:21','2023-04-29 21:57:21'),(4138,7657,1323,40760,25774,3,68,1,2947.46,NULL,'2023-04-29 21:27:54','2023-04-29 21:57:21','2023-04-29 21:57:21'),(4139,7657,1323,40760,25774,3,217,1,464.58,NULL,'2023-04-29 21:27:54','2023-04-29 21:57:21','2023-04-29 21:57:21'),(4140,7657,1323,40760,25774,3,57,2,17447.58,NULL,'2023-04-29 21:27:54','2023-04-29 21:57:21','2023-04-29 21:57:21'),(4141,7657,1324,40760,25774,3,217,1,2438.02,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4142,7657,1324,40760,25774,3,68,1,511.98,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4143,7657,1324,40760,25774,3,57,2,2950.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4144,7657,1325,40760,25774,3,217,1,4793.39,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4145,7657,1325,40760,25774,3,68,1,1006.61,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4146,7657,1325,40760,25774,3,57,2,5800.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4147,7657,1326,40760,25774,3,217,1,13305.79,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4148,7657,1326,40760,25774,3,68,1,2794.22,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4149,7657,1326,40760,25774,3,57,2,16100.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4150,7657,1327,40760,25774,3,217,1,9421.49,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4151,7657,1327,40760,25774,3,68,1,1978.51,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4152,7657,1327,40760,25774,3,57,2,11400.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4153,7657,1328,40760,25774,3,217,1,9338.84,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4154,7657,1328,40760,25774,3,68,1,1961.16,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4155,7657,1328,40760,25774,3,57,2,11300.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4156,7657,1329,40760,25774,3,217,1,17768.60,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4157,7657,1329,40760,25774,3,68,1,3731.41,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4158,7657,1329,40760,25774,3,57,2,21500.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4159,7657,1330,40760,25774,3,217,1,2066.12,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4160,7657,1330,40760,25774,3,68,1,433.89,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4161,7657,1330,40760,25774,3,57,2,2500.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4162,7657,1331,40760,25774,3,217,1,3719.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4163,7657,1331,40760,25774,3,68,1,780.99,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4164,7657,1331,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL);
INSERT INTO `balance_libro_details` VALUES (4165,7657,1332,40760,25774,3,217,1,26590769.50,NULL,'2023-04-29 21:27:54','2023-04-29 22:06:47','2023-04-29 22:06:47'),(4166,7657,1332,40760,25774,3,68,1,5584061.60,NULL,'2023-04-29 21:27:54','2023-04-29 22:06:47','2023-04-29 22:06:47'),(4167,7657,1332,40760,25774,3,217,1,212726.16,NULL,'2023-04-29 21:27:54','2023-04-29 22:06:47','2023-04-29 22:06:47'),(4168,7657,1332,40760,25774,3,57,2,32387557.26,NULL,'2023-04-29 21:27:54','2023-04-29 22:06:47','2023-04-29 22:06:47'),(4169,7657,1333,40760,25774,3,217,1,223289.52,NULL,'2023-04-29 21:27:54','2023-04-29 22:10:12','2023-04-29 22:10:12'),(4170,7657,1333,40760,25774,3,68,1,46890.80,NULL,'2023-04-29 21:27:54','2023-04-29 22:10:12','2023-04-29 22:10:12'),(4171,7657,1333,40760,25774,3,217,1,7390.88,NULL,'2023-04-29 21:27:54','2023-04-29 22:10:12','2023-04-29 22:10:12'),(4172,7657,1333,40760,25774,3,57,2,277571.20,NULL,'2023-04-29 21:27:54','2023-04-29 22:10:12','2023-04-29 22:10:12'),(4173,7657,1334,40760,25774,3,217,1,1239.67,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4174,7657,1334,40760,25774,3,68,1,260.33,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4175,7657,1334,40760,25774,3,57,2,1500.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4176,7657,1335,40760,25774,3,217,1,991.74,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4177,7657,1335,40760,25774,3,68,1,208.27,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4178,7657,1335,40760,25774,3,57,2,1200.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4179,7657,1336,40760,25774,3,217,1,2975.21,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4180,7657,1336,40760,25774,3,68,1,624.79,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4181,7657,1336,40760,25774,3,57,2,3600.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4182,7657,1337,40760,25774,3,217,1,12075.03,NULL,'2023-04-29 21:27:54','2023-04-29 22:16:28','2023-04-29 22:16:28'),(4183,7657,1337,40760,25774,3,68,1,2535.76,NULL,'2023-04-29 21:27:54','2023-04-29 22:16:28','2023-04-29 22:16:28'),(4184,7657,1337,40760,25774,3,217,1,1090.95,NULL,'2023-04-29 21:27:54','2023-04-29 22:16:28','2023-04-29 22:16:28'),(4185,7657,1337,40760,25774,3,57,2,15701.74,NULL,'2023-04-29 21:27:54','2023-04-29 22:16:28','2023-04-29 22:16:28'),(4186,7657,1338,40760,25774,3,217,1,36035.54,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4187,7657,1338,40760,25774,3,68,1,7567.46,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4188,7657,1338,40760,25774,3,57,2,43603.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4189,7657,1339,40760,25774,3,217,1,3518.13,NULL,'2023-04-29 21:27:54','2023-04-29 22:21:52','2023-04-29 22:21:52'),(4190,7657,1339,40760,25774,3,68,1,738.81,NULL,'2023-04-29 21:27:54','2023-04-29 22:21:52','2023-04-29 22:21:52'),(4191,7657,1339,40760,25774,3,217,1,243.06,NULL,'2023-04-29 21:27:54','2023-04-29 22:21:52','2023-04-29 22:21:52'),(4192,7657,1339,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:54','2023-04-29 22:21:52','2023-04-29 22:21:52'),(4193,7657,1340,40760,25774,3,217,1,1074.38,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4194,7657,1340,40760,25774,3,68,1,225.62,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4195,7657,1340,40760,25774,3,57,2,1300.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4196,7657,1341,40760,25774,3,217,1,6818.19,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4197,7657,1341,40760,25774,3,68,1,1431.82,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4198,7657,1341,40760,25774,3,57,2,8250.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4199,7657,1342,40760,25774,3,217,1,2727.27,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4200,7657,1342,40760,25774,3,68,1,572.73,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4201,7657,1342,40760,25774,3,57,2,3300.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL);
INSERT INTO `balance_libro_details` VALUES (4202,7657,1343,40760,25774,3,217,1,3677.69,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4203,7657,1343,40760,25774,3,68,1,772.31,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4204,7657,1343,40760,25774,3,57,2,4450.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4205,7657,1344,40760,25774,3,217,1,393333.65,NULL,'2023-04-29 21:27:54','2023-04-29 22:27:42','2023-04-29 22:27:42'),(4206,7657,1344,40760,25774,3,68,1,82600.07,NULL,'2023-04-29 21:27:54','2023-04-29 22:27:42','2023-04-29 22:27:42'),(4207,7657,1344,40760,25774,3,217,1,3146.67,NULL,'2023-04-29 21:27:54','2023-04-29 22:27:42','2023-04-29 22:27:42'),(4208,7657,1344,40760,25774,3,57,2,479080.39,NULL,'2023-04-29 21:27:54','2023-04-29 22:27:42','2023-04-29 22:27:42'),(4209,7657,1345,40760,25774,3,217,1,1652.89,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4210,7657,1345,40760,25774,3,68,1,347.11,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4211,7657,1345,40760,25774,3,57,2,2000.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4212,7657,1346,40760,25774,3,217,1,3719.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4213,7657,1346,40760,25774,3,68,1,780.99,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4214,7657,1346,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4215,7657,1347,40760,25774,3,217,1,3719.01,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4216,7657,1347,40760,25774,3,68,1,780.99,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4217,7657,1347,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:54','2023-04-29 21:27:54',NULL),(4218,7657,1348,40760,25774,3,217,1,991.74,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4219,7657,1348,40760,25774,3,68,1,208.27,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4220,7657,1348,40760,25774,3,57,2,1200.01,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4221,7657,1349,40760,25774,3,217,1,2892.56,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4222,7657,1349,40760,25774,3,68,1,607.44,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4223,7657,1349,40760,25774,3,57,2,3500.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4224,7657,1350,40760,25774,3,217,1,10330.58,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4225,7657,1350,40760,25774,3,68,1,2169.42,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4226,7657,1350,40760,25774,3,57,2,12500.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4227,7657,1351,40760,25774,3,217,1,12809.92,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4228,7657,1351,40760,25774,3,68,1,2690.08,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4229,7657,1351,40760,25774,3,57,2,15500.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4230,7657,1352,40760,25774,3,217,1,4793.39,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4231,7657,1352,40760,25774,3,68,1,1006.61,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4232,7657,1352,40760,25774,3,57,2,5800.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4233,7657,1353,40760,25774,3,217,1,3966.94,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4234,7657,1353,40760,25774,3,68,1,833.06,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4235,7657,1353,40760,25774,3,57,2,4800.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4236,7657,1354,40760,25774,3,217,1,24876.03,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4237,7657,1354,40760,25774,3,68,1,5223.97,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4238,7657,1354,40760,25774,3,57,2,30100.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4239,7657,1355,40760,25774,3,217,1,238569.14,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4240,7657,1355,40760,25774,3,68,1,50099.52,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL);
INSERT INTO `balance_libro_details` VALUES (4241,7657,1355,40760,25774,3,57,2,288668.66,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4242,7657,1356,40760,25774,3,217,1,14512.49,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4243,7657,1356,40760,25774,3,68,1,3047.62,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4244,7657,1356,40760,25774,3,57,2,17560.11,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4245,7657,1357,40760,25774,3,217,1,178200.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:37:38','2023-04-29 22:37:38'),(4246,7657,1357,40760,25774,3,68,1,37422.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:37:38','2023-04-29 22:37:38'),(4247,7657,1357,40760,25774,3,217,1,1425.60,NULL,'2023-04-29 21:27:55','2023-04-29 22:37:38','2023-04-29 22:37:38'),(4248,7657,1357,40760,25774,3,57,2,217047.60,NULL,'2023-04-29 21:27:55','2023-04-29 22:37:38','2023-04-29 22:37:38'),(4249,7657,1358,40760,25774,3,217,1,146900.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:44:30','2023-04-29 22:44:30'),(4250,7657,1358,40760,25774,3,68,1,30849.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:44:30','2023-04-29 22:44:30'),(4251,7657,1358,40760,25774,3,217,1,1175.20,NULL,'2023-04-29 21:27:55','2023-04-29 22:44:30','2023-04-29 22:44:30'),(4252,7657,1358,40760,25774,3,57,2,178924.20,NULL,'2023-04-29 21:27:55','2023-04-29 22:44:30','2023-04-29 22:44:30'),(4253,7657,1359,40760,25774,3,217,1,743.80,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4254,7657,1359,40760,25774,3,68,1,156.20,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4255,7657,1359,40760,25774,3,57,2,900.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4256,7657,1360,40760,25774,3,217,1,7438.02,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4257,7657,1360,40760,25774,3,68,1,1561.98,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4258,7657,1360,40760,25774,3,57,2,9000.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4259,7657,1361,40760,25774,3,217,1,1322.31,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4260,7657,1361,40760,25774,3,68,1,277.69,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4261,7657,1361,40760,25774,3,57,2,1600.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4262,7657,1362,40760,25774,3,217,1,1157.03,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4263,7657,1362,40760,25774,3,68,1,242.98,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4264,7657,1362,40760,25774,3,57,2,1400.01,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4265,7657,1363,40760,25774,3,217,1,165000.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:47:24','2023-04-29 22:47:24'),(4266,7657,1363,40760,25774,3,68,1,34650.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:47:24','2023-04-29 22:47:24'),(4267,7657,1363,40760,25774,3,217,1,1320.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:47:24','2023-04-29 22:47:24'),(4268,7657,1363,40760,25774,3,57,2,200970.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:47:24','2023-04-29 22:47:24'),(4269,7657,1364,40760,25774,3,217,1,1404.96,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4270,7657,1364,40760,25774,3,68,1,295.04,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4271,7657,1364,40760,25774,3,57,2,1700.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4272,7657,1365,40760,25774,3,217,1,159200.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:49:16','2023-04-29 22:49:16'),(4273,7657,1365,40760,25774,3,68,1,33432.00,NULL,'2023-04-29 21:27:55','2023-04-29 22:49:16','2023-04-29 22:49:16'),(4274,7657,1365,40760,25774,3,217,1,1273.60,NULL,'2023-04-29 21:27:55','2023-04-29 22:49:16','2023-04-29 22:49:16'),(4275,7657,1365,40760,25774,3,57,2,193905.60,NULL,'2023-04-29 21:27:55','2023-04-29 22:49:16','2023-04-29 22:49:16'),(4276,7657,1366,40760,25774,3,217,1,2231.41,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4277,7657,1366,40760,25774,3,68,1,468.60,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL);
INSERT INTO `balance_libro_details` VALUES (4278,7657,1366,40760,25774,3,57,2,2700.01,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4279,7657,1367,40760,25774,3,217,1,4958.68,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4280,7657,1367,40760,25774,3,68,1,1041.32,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4281,7657,1367,40760,25774,3,57,2,6000.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4282,7657,1368,40760,25774,3,217,1,3305.79,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4283,7657,1368,40760,25774,3,68,1,694.22,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4284,7657,1368,40760,25774,3,57,2,4000.01,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4285,7657,1369,40760,25774,3,217,1,3719.01,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4286,7657,1369,40760,25774,3,68,1,780.99,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4287,7657,1369,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4288,7657,1370,40760,25774,3,217,1,6778.98,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4289,7657,1370,40760,25774,3,68,1,1423.59,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4290,7657,1370,40760,25774,3,57,2,8202.57,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4291,7657,1371,40760,25774,3,217,1,13498.88,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4292,7657,1371,40760,25774,3,68,1,2834.76,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4293,7657,1371,40760,25774,3,57,2,16333.64,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4294,7657,1372,40760,25774,3,217,1,2513.13,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4295,7657,1372,40760,25774,3,68,1,527.76,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4296,7657,1372,40760,25774,3,57,2,3040.89,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4297,7657,1373,40760,25774,3,217,1,14400.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4298,7657,1373,40760,25774,3,68,1,3024.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4299,7657,1373,40760,25774,3,57,2,17424.00,NULL,'2023-04-29 21:27:55','2023-04-29 21:27:55',NULL),(4300,7657,1374,40760,25774,3,217,2,7824.05,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4301,7657,1374,40760,25774,3,67,2,1643.05,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4302,7657,1374,40760,25774,3,57,1,9467.10,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4303,7657,1375,40760,25774,3,217,1,169200.00,NULL,'2023-04-29 21:27:56','2023-04-29 22:52:36','2023-04-29 22:52:36'),(4304,7657,1375,40760,25774,3,68,1,35532.00,NULL,'2023-04-29 21:27:56','2023-04-29 22:52:36','2023-04-29 22:52:36'),(4305,7657,1375,40760,25774,3,217,1,1353.60,NULL,'2023-04-29 21:27:56','2023-04-29 22:52:36','2023-04-29 22:52:36'),(4306,7657,1375,40760,25774,3,57,2,206085.60,NULL,'2023-04-29 21:27:56','2023-04-29 22:52:36','2023-04-29 22:52:36'),(4307,7657,1376,40760,25774,3,217,1,158400.00,NULL,'2023-04-29 21:27:56','2023-04-29 22:54:32','2023-04-29 22:54:32'),(4308,7657,1376,40760,25774,3,68,1,33264.00,NULL,'2023-04-29 21:27:56','2023-04-29 22:54:32','2023-04-29 22:54:32'),(4309,7657,1376,40760,25774,3,217,1,1267.20,NULL,'2023-04-29 21:27:56','2023-04-29 22:54:32','2023-04-29 22:54:32'),(4310,7657,1376,40760,25774,3,57,2,192931.20,NULL,'2023-04-29 21:27:56','2023-04-29 22:54:32','2023-04-29 22:54:32'),(4311,7657,1377,40760,25774,3,217,1,130872.86,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4312,7657,1377,40760,25774,3,68,1,27483.30,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4313,7657,1377,40760,25774,3,217,1,1046.98,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4314,7657,1377,40760,25774,3,57,2,159403.14,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4315,7657,1378,40760,25774,3,217,1,217800.00,NULL,'2023-04-29 21:27:56','2023-04-29 23:02:28','2023-04-29 23:02:28');
INSERT INTO `balance_libro_details` VALUES (4316,7657,1378,40760,25774,3,68,1,45738.00,NULL,'2023-04-29 21:27:56','2023-04-29 23:02:28','2023-04-29 23:02:28'),(4317,7657,1378,40760,25774,3,217,1,7209.18,NULL,'2023-04-29 21:27:56','2023-04-29 23:02:28','2023-04-29 23:02:28'),(4318,7657,1378,40760,25774,3,57,2,270747.18,NULL,'2023-04-29 21:27:56','2023-04-29 23:02:28','2023-04-29 23:02:28'),(4319,7657,1379,40760,25774,3,217,1,5950.41,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4320,7657,1379,40760,25774,3,68,1,1249.59,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4321,7657,1379,40760,25774,3,57,2,7200.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4322,7657,1380,40760,25774,3,217,1,12727.27,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4323,7657,1380,40760,25774,3,68,1,2672.73,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4324,7657,1380,40760,25774,3,57,2,15400.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4325,7657,1381,40760,25774,3,217,1,173000.00,NULL,'2023-04-29 21:27:56','2023-04-29 23:04:22','2023-04-29 23:04:22'),(4326,7657,1381,40760,25774,3,68,1,36330.00,NULL,'2023-04-29 21:27:56','2023-04-29 23:04:22','2023-04-29 23:04:22'),(4327,7657,1381,40760,25774,3,217,1,1384.00,NULL,'2023-04-29 21:27:56','2023-04-29 23:04:22','2023-04-29 23:04:22'),(4328,7657,1381,40760,25774,3,57,2,210714.00,NULL,'2023-04-29 21:27:56','2023-04-29 23:04:22','2023-04-29 23:04:22'),(4329,7657,1382,40760,25774,3,217,1,1239.67,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4330,7657,1382,40760,25774,3,68,1,260.33,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4331,7657,1382,40760,25774,3,57,2,1500.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4332,7657,1383,40760,25774,3,217,1,4545.46,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4333,7657,1383,40760,25774,3,68,1,954.55,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4334,7657,1383,40760,25774,3,57,2,5500.01,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4335,7657,1384,40760,25774,3,217,1,3471.08,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4336,7657,1384,40760,25774,3,68,1,728.93,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4337,7657,1384,40760,25774,3,57,2,4200.01,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4338,7657,1385,40760,25774,3,217,1,11983.47,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4339,7657,1385,40760,25774,3,68,1,2516.53,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4340,7657,1385,40760,25774,3,57,2,14500.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4341,7657,1386,40760,25774,3,217,1,3719.01,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4342,7657,1386,40760,25774,3,68,1,780.99,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4343,7657,1386,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4344,7657,1387,40760,25774,3,217,1,2809.92,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4345,7657,1387,40760,25774,3,68,1,590.08,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4346,7657,1387,40760,25774,3,57,2,3400.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4347,7657,1388,40760,25774,3,217,1,4049.59,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4348,7657,1388,40760,25774,3,68,1,850.41,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4349,7657,1388,40760,25774,3,57,2,4900.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4350,7657,1389,40760,25774,3,217,1,743.80,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4351,7657,1389,40760,25774,3,68,1,156.20,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4352,7657,1389,40760,25774,3,57,2,900.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4353,7657,1390,40760,25774,3,217,1,4132.23,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4354,7657,1390,40760,25774,3,68,1,867.77,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL);
INSERT INTO `balance_libro_details` VALUES (4355,7657,1390,40760,25774,3,57,2,5000.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4356,7657,1391,40760,25774,3,217,1,3966.94,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4357,7657,1391,40760,25774,3,68,1,833.06,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4358,7657,1391,40760,25774,3,57,2,4800.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4359,7657,1392,40760,25774,3,217,1,3305.79,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4360,7657,1392,40760,25774,3,68,1,694.22,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4361,7657,1392,40760,25774,3,57,2,4000.01,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4362,7657,1393,40760,25774,3,217,1,1239.67,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4363,7657,1393,40760,25774,3,68,1,260.33,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4364,7657,1393,40760,25774,3,57,2,1500.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4365,7657,1394,40760,25774,3,217,1,2892.56,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4366,7657,1394,40760,25774,3,68,1,607.44,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4367,7657,1394,40760,25774,3,57,2,3500.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4368,7657,1395,40760,25774,3,217,1,13305.79,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4369,7657,1395,40760,25774,3,68,1,2794.22,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4370,7657,1395,40760,25774,3,57,2,16100.01,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4371,7657,1396,40760,25774,3,217,1,18016.53,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4372,7657,1396,40760,25774,3,68,1,3783.47,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4373,7657,1396,40760,25774,3,57,2,21800.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4374,7657,1397,40760,25774,3,217,1,2314.05,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4375,7657,1397,40760,25774,3,68,1,485.95,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4376,7657,1397,40760,25774,3,57,2,2800.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4377,7657,1398,40760,25774,3,217,1,3636.36,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4378,7657,1398,40760,25774,3,68,1,763.64,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4379,7657,1398,40760,25774,3,57,2,4400.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4380,7657,1399,40760,25774,3,217,1,11900.83,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4381,7657,1399,40760,25774,3,68,1,2499.17,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4382,7657,1399,40760,25774,3,57,2,14400.00,NULL,'2023-04-29 21:27:56','2023-04-29 21:27:56',NULL),(4383,7657,1400,40760,25774,3,217,1,5371.90,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4384,7657,1400,40760,25774,3,68,1,1128.10,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4385,7657,1400,40760,25774,3,57,2,6500.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4386,7657,1401,40760,25774,3,217,1,5867.77,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4387,7657,1401,40760,25774,3,68,1,1232.23,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4388,7657,1401,40760,25774,3,57,2,7100.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4389,7657,1402,40760,25774,3,217,1,2479.34,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4390,7657,1402,40760,25774,3,68,1,520.66,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4391,7657,1402,40760,25774,3,57,2,3000.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4392,7657,1403,40760,25774,3,217,1,9090.91,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4393,7657,1403,40760,25774,3,68,1,1909.09,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4394,7657,1403,40760,25774,3,57,2,11000.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL);
INSERT INTO `balance_libro_details` VALUES (4395,7657,1404,40760,25774,3,217,1,1487.60,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4396,7657,1404,40760,25774,3,68,1,312.40,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4397,7657,1404,40760,25774,3,57,2,1800.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4398,7657,1405,40760,25774,3,217,1,9504.13,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4399,7657,1405,40760,25774,3,68,1,1995.87,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4400,7657,1405,40760,25774,3,57,2,11500.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4401,7657,1406,40760,25774,3,217,1,16776.86,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4402,7657,1406,40760,25774,3,68,1,3523.14,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4403,7657,1406,40760,25774,3,57,2,20300.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4404,7657,1407,40760,25774,3,217,1,26942.15,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4405,7657,1407,40760,25774,3,68,1,5657.85,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4406,7657,1407,40760,25774,3,57,2,32600.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4407,7657,1408,40760,25774,3,217,1,7107.44,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4408,7657,1408,40760,25774,3,68,1,1492.56,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4409,7657,1408,40760,25774,3,57,2,8600.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4410,7657,1409,40760,25774,3,217,1,7933.89,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4411,7657,1409,40760,25774,3,68,1,1666.12,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4412,7657,1409,40760,25774,3,57,2,9600.01,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4413,7657,1410,40760,25774,3,217,1,12809.92,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4414,7657,1410,40760,25774,3,68,1,2690.08,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4415,7657,1410,40760,25774,3,57,2,15500.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4416,7657,1411,40760,25774,3,217,1,1157.03,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4417,7657,1411,40760,25774,3,68,1,242.98,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4418,7657,1411,40760,25774,3,57,2,1400.01,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4419,7657,1412,40760,25774,3,217,1,4297.52,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4420,7657,1412,40760,25774,3,68,1,902.48,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4421,7657,1412,40760,25774,3,57,2,5200.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4422,7657,1413,40760,25774,3,217,1,62396.70,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4423,7657,1413,40760,25774,3,68,1,13103.31,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4424,7657,1413,40760,25774,3,57,2,75500.01,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4425,7657,1414,40760,25774,3,217,1,36115.70,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4426,7657,1414,40760,25774,3,68,1,7584.30,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4427,7657,1414,40760,25774,3,57,2,43700.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4428,7657,1415,40760,25774,3,217,1,3719.01,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4429,7657,1415,40760,25774,3,68,1,780.99,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4430,7657,1415,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4431,7657,1416,40760,25774,3,217,1,4710.74,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4432,7657,1416,40760,25774,3,68,1,989.26,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4433,7657,1416,40760,25774,3,57,2,5700.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4434,7657,1417,40760,25774,3,217,1,3801.65,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL);
INSERT INTO `balance_libro_details` VALUES (4435,7657,1417,40760,25774,3,68,1,798.35,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4436,7657,1417,40760,25774,3,57,2,4600.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4437,7657,1418,40760,25774,3,217,1,3966.94,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4438,7657,1418,40760,25774,3,68,1,833.06,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4439,7657,1418,40760,25774,3,57,2,4800.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4440,7657,1419,40760,25774,3,217,1,3388.43,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4441,7657,1419,40760,25774,3,68,1,711.57,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4442,7657,1419,40760,25774,3,57,2,4100.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4443,7657,1420,40760,25774,3,217,1,19338.84,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4444,7657,1420,40760,25774,3,68,1,4061.16,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4445,7657,1420,40760,25774,3,57,2,23400.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4446,7657,1421,40760,25774,3,217,1,3801.65,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4447,7657,1421,40760,25774,3,68,1,798.35,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4448,7657,1421,40760,25774,3,57,2,4600.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4449,7657,1422,40760,25774,3,217,1,3057.85,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4450,7657,1422,40760,25774,3,68,1,642.15,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4451,7657,1422,40760,25774,3,57,2,3700.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4452,7657,1423,40760,25774,3,217,1,15041.32,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4453,7657,1423,40760,25774,3,68,1,3158.68,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4454,7657,1423,40760,25774,3,57,2,18200.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4455,7657,1424,40760,25774,3,217,1,3140.50,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4456,7657,1424,40760,25774,3,68,1,659.50,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4457,7657,1424,40760,25774,3,57,2,3800.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4458,7657,1425,40760,25774,3,217,1,8512.40,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4459,7657,1425,40760,25774,3,68,1,1787.60,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4460,7657,1425,40760,25774,3,57,2,10300.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4461,7657,1426,40760,25774,3,217,1,5041.32,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4462,7657,1426,40760,25774,3,68,1,1058.68,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4463,7657,1426,40760,25774,3,57,2,6100.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4464,7657,1427,40760,25774,3,217,1,8595.04,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4465,7657,1427,40760,25774,3,68,1,1804.96,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4466,7657,1427,40760,25774,3,57,2,10400.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4467,7657,1428,40760,25774,3,217,1,1900.83,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4468,7657,1428,40760,25774,3,68,1,399.17,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4469,7657,1428,40760,25774,3,57,2,2300.00,NULL,'2023-04-29 21:27:57','2023-04-29 21:27:57',NULL),(4470,7657,1429,40760,25774,3,217,1,4132.23,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4471,7657,1429,40760,25774,3,68,1,867.77,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4472,7657,1429,40760,25774,3,57,2,5000.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4473,7657,1430,40760,25774,3,217,1,2727.27,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4474,7657,1430,40760,25774,3,68,1,572.73,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL);
INSERT INTO `balance_libro_details` VALUES (4475,7657,1430,40760,25774,3,57,2,3300.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4476,7657,1431,40760,25774,3,217,1,169000.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:06:21','2023-04-29 23:06:21'),(4477,7657,1431,40760,25774,3,68,1,35490.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:06:21','2023-04-29 23:06:21'),(4478,7657,1431,40760,25774,3,217,1,1352.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:06:21','2023-04-29 23:06:21'),(4479,7657,1431,40760,25774,3,57,2,205842.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:06:21','2023-04-29 23:06:21'),(4480,7657,1432,40760,25774,3,217,1,175000.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:07:43','2023-04-29 23:07:43'),(4481,7657,1432,40760,25774,3,68,1,36750.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:07:43','2023-04-29 23:07:43'),(4482,7657,1432,40760,25774,3,217,1,1400.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:07:43','2023-04-29 23:07:43'),(4483,7657,1432,40760,25774,3,57,2,213150.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:07:43','2023-04-29 23:07:43'),(4484,7657,1433,40760,25774,3,217,1,178400.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:10:11','2023-04-29 23:10:11'),(4485,7657,1433,40760,25774,3,68,1,37464.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:10:11','2023-04-29 23:10:11'),(4486,7657,1433,40760,25774,3,217,1,1427.20,NULL,'2023-04-29 21:27:58','2023-04-29 23:10:11','2023-04-29 23:10:11'),(4487,7657,1433,40760,25774,3,57,2,217291.20,NULL,'2023-04-29 21:27:58','2023-04-29 23:10:11','2023-04-29 23:10:11'),(4488,7657,1434,40760,25774,3,217,1,201300.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:15:48','2023-04-29 23:15:48'),(4489,7657,1434,40760,25774,3,68,1,42273.00,NULL,'2023-04-29 21:27:58','2023-04-29 23:15:48','2023-04-29 23:15:48'),(4490,7657,1434,40760,25774,3,217,1,1610.40,NULL,'2023-04-29 21:27:58','2023-04-29 23:15:48','2023-04-29 23:15:48'),(4491,7657,1434,40760,25774,3,57,2,245183.40,NULL,'2023-04-29 21:27:58','2023-04-29 23:15:48','2023-04-29 23:15:48'),(4492,7657,1435,40760,25774,3,217,1,6776.86,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4493,7657,1435,40760,25774,3,68,1,1423.14,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4494,7657,1435,40760,25774,3,57,2,8200.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4495,7657,1436,40760,25774,3,217,1,330.58,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4496,7657,1436,40760,25774,3,68,1,69.42,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4497,7657,1436,40760,25774,3,57,2,400.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4498,7657,1437,40760,25774,3,217,1,4132.23,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4499,7657,1437,40760,25774,3,68,1,867.77,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4500,7657,1437,40760,25774,3,57,2,5000.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4501,7657,1438,40760,25774,3,217,1,3471.08,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4502,7657,1438,40760,25774,3,68,1,728.93,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4503,7657,1438,40760,25774,3,57,2,4200.01,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4504,7657,1439,40760,25774,3,217,1,2344.41,NULL,'2023-04-29 21:27:58','2023-04-29 23:20:44','2023-04-29 23:20:44'),(4505,7657,1439,40760,25774,3,68,1,492.33,NULL,'2023-04-29 21:27:58','2023-04-29 23:20:44','2023-04-29 23:20:44'),(4506,7657,1439,40760,25774,3,217,1,163.27,NULL,'2023-04-29 21:27:58','2023-04-29 23:20:44','2023-04-29 23:20:44'),(4507,7657,1439,40760,25774,3,57,2,3000.01,NULL,'2023-04-29 21:27:58','2023-04-29 23:20:44','2023-04-29 23:20:44'),(4508,7657,1440,40760,25774,3,217,1,2231.41,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4509,7657,1440,40760,25774,3,68,1,468.60,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4510,7657,1440,40760,25774,3,57,2,2700.01,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4511,7657,1441,40760,25774,3,217,1,6363.64,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL);
INSERT INTO `balance_libro_details` VALUES (4512,7657,1441,40760,25774,3,68,1,1336.36,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4513,7657,1441,40760,25774,3,57,2,7700.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4514,7657,1442,40760,25774,3,217,1,24958.68,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4515,7657,1442,40760,25774,3,68,1,5241.32,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4516,7657,1442,40760,25774,3,57,2,30200.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4517,7657,1443,40760,25774,3,217,1,4628.10,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4518,7657,1443,40760,25774,3,68,1,971.90,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4519,7657,1443,40760,25774,3,57,2,5600.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4520,7657,1444,40760,25774,3,217,1,29917.36,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4521,7657,1444,40760,25774,3,68,1,6282.65,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4522,7657,1444,40760,25774,3,57,2,36200.01,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4523,7657,1445,40760,25774,3,217,1,1818.18,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4524,7657,1445,40760,25774,3,68,1,381.82,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4525,7657,1445,40760,25774,3,57,2,2200.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4526,7657,1446,40760,25774,3,217,1,7438.02,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4527,7657,1446,40760,25774,3,68,1,1561.98,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4528,7657,1446,40760,25774,3,57,2,9000.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4529,7657,1447,40760,25774,3,217,1,3140.50,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4530,7657,1447,40760,25774,3,68,1,659.50,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4531,7657,1447,40760,25774,3,57,2,3800.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4532,7657,1448,40760,25774,3,217,1,1652.89,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4533,7657,1448,40760,25774,3,68,1,347.11,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4534,7657,1448,40760,25774,3,57,2,2000.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4535,7657,1449,40760,25774,3,217,1,4545.46,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4536,7657,1449,40760,25774,3,68,1,954.55,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4537,7657,1449,40760,25774,3,57,2,5500.01,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4538,7657,1450,40760,25774,3,217,1,2644.63,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4539,7657,1450,40760,25774,3,68,1,555.37,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4540,7657,1450,40760,25774,3,57,2,3200.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4541,7657,1451,40760,25774,3,217,1,1404.96,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4542,7657,1451,40760,25774,3,68,1,295.04,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4543,7657,1451,40760,25774,3,57,2,1700.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4544,7657,1452,40760,25774,3,217,1,3553.72,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4545,7657,1452,40760,25774,3,68,1,746.28,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4546,7657,1452,40760,25774,3,57,2,4300.00,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4547,7657,1453,40760,25774,3,217,1,991.74,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4548,7657,1453,40760,25774,3,68,1,208.27,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4549,7657,1453,40760,25774,3,57,2,1200.01,NULL,'2023-04-29 21:27:58','2023-04-29 21:27:58',NULL),(4550,7657,1454,40760,25774,3,217,1,2644.63,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4551,7657,1454,40760,25774,3,68,1,555.37,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL);
INSERT INTO `balance_libro_details` VALUES (4552,7657,1454,40760,25774,3,57,2,3200.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4553,7657,1455,40760,25774,3,217,1,9090.91,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4554,7657,1455,40760,25774,3,68,1,1909.09,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4555,7657,1455,40760,25774,3,57,2,11000.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4556,7657,1456,40760,25774,3,217,1,3636.36,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4557,7657,1456,40760,25774,3,68,1,763.64,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4558,7657,1456,40760,25774,3,57,2,4400.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4559,7657,1457,40760,25774,3,217,1,3884.30,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4560,7657,1457,40760,25774,3,68,1,815.70,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4561,7657,1457,40760,25774,3,57,2,4700.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4562,7657,1458,40760,25774,3,217,1,13801.65,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4563,7657,1458,40760,25774,3,68,1,2898.35,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4564,7657,1458,40760,25774,3,57,2,16700.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4565,7657,1459,40760,25774,3,217,1,4132.23,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4566,7657,1459,40760,25774,3,68,1,867.77,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4567,7657,1459,40760,25774,3,57,2,5000.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4568,7657,1460,40760,25774,3,217,1,5702.48,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4569,7657,1460,40760,25774,3,68,1,1197.52,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4570,7657,1460,40760,25774,3,57,2,6900.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4571,7657,1461,40760,25774,3,217,1,2479.34,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4572,7657,1461,40760,25774,3,68,1,520.66,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4573,7657,1461,40760,25774,3,57,2,3000.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4574,7657,1462,40760,25774,3,217,1,1818.18,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4575,7657,1462,40760,25774,3,68,1,381.82,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4576,7657,1462,40760,25774,3,57,2,2200.00,NULL,'2023-04-29 21:27:59','2023-04-29 21:27:59',NULL),(4577,7657,1463,40760,25774,3,250,1,2658.00,NULL,'2023-04-29 21:35:10','2023-04-29 21:35:10',NULL),(4578,7657,1463,40760,25774,3,57,2,2658.00,NULL,'2023-04-29 21:35:10','2023-04-29 21:35:10',NULL),(4579,7657,1464,40760,25774,3,217,1,11378.27,NULL,'2023-04-29 21:41:34','2023-04-29 21:41:34',NULL),(4580,7657,1464,40760,25774,3,68,1,2389.44,NULL,'2023-04-29 21:41:34','2023-04-29 21:41:34',NULL),(4581,7657,1464,40760,25774,3,217,1,50.07,NULL,'2023-04-29 21:41:34','2023-04-29 21:41:34',NULL),(4582,7657,1464,40760,25774,3,238,1,376.62,NULL,'2023-04-29 21:41:34','2023-04-29 21:41:34',NULL),(4583,7657,1464,40760,25774,3,57,2,14194.40,NULL,'2023-04-29 21:41:34','2023-04-29 21:41:34',NULL),(4584,7657,1465,40760,25774,3,217,1,31553.29,NULL,'2023-04-29 21:44:11','2023-04-29 21:44:11',NULL),(4585,7657,1465,40760,25774,3,68,1,6626.19,NULL,'2023-04-29 21:44:11','2023-04-29 21:44:11',NULL),(4586,7657,1465,40760,25774,3,217,1,252.43,NULL,'2023-04-29 21:44:11','2023-04-29 21:44:11',NULL),(4587,7657,1465,40760,25774,3,57,2,38431.91,NULL,'2023-04-29 21:44:11','2023-04-29 21:44:11',NULL),(4588,7657,1466,40760,25774,3,217,1,219768.28,NULL,'2023-04-29 21:49:13','2023-04-29 21:49:13',NULL),(4589,7657,1466,40760,25774,3,68,1,46151.34,NULL,'2023-04-29 21:49:13','2023-04-29 21:49:13',NULL),(4590,7657,1466,40760,25774,3,238,1,7274.33,NULL,'2023-04-29 21:49:13','2023-04-29 21:49:13',NULL),(4591,7657,1466,40760,25774,3,57,2,273193.95,NULL,'2023-04-29 21:49:13','2023-04-29 21:49:13',NULL);
INSERT INTO `balance_libro_details` VALUES (4592,7657,1467,40760,25774,3,217,1,8457.21,NULL,'2023-04-29 21:54:11','2023-04-29 21:54:11',NULL),(4593,7657,1467,40760,25774,3,68,1,1776.01,NULL,'2023-04-29 21:54:11','2023-04-29 21:54:11',NULL),(4594,7657,1467,40760,25774,3,217,1,67.66,NULL,'2023-04-29 21:54:11','2023-04-29 21:54:11',NULL),(4595,7657,1467,40760,25774,3,57,2,10300.88,NULL,'2023-04-29 21:54:11','2023-04-29 21:54:11',NULL),(4596,7657,1468,40760,25774,3,217,1,14035.54,NULL,'2023-04-29 21:57:21','2023-04-29 21:57:21',NULL),(4597,7657,1468,40760,25774,3,68,1,2947.46,NULL,'2023-04-29 21:57:21','2023-04-29 21:57:21',NULL),(4598,7657,1468,40760,25774,3,238,1,464.58,NULL,'2023-04-29 21:57:21','2023-04-29 21:57:21',NULL),(4599,7657,1468,40760,25774,3,57,2,17447.58,NULL,'2023-04-29 21:57:21','2023-04-29 21:57:21',NULL),(4600,7657,1469,40760,25774,3,217,1,26590769.50,NULL,'2023-04-29 22:06:47','2023-04-29 22:06:47',NULL),(4601,7657,1469,40760,25774,3,68,1,5584061.60,NULL,'2023-04-29 22:06:47','2023-04-29 22:06:47',NULL),(4602,7657,1469,40760,25774,3,217,1,667428.31,NULL,'2023-04-29 22:06:47','2023-04-29 22:06:47',NULL),(4603,7657,1469,40760,25774,3,238,1,880154.47,NULL,'2023-04-29 22:06:47','2023-04-29 22:06:47',NULL),(4604,7657,1469,40760,25774,3,57,2,33722413.88,NULL,'2023-04-29 22:06:47','2023-04-29 22:06:47',NULL),(4605,7657,1470,40760,25774,3,217,1,223289.52,NULL,'2023-04-29 22:10:12','2023-04-29 22:10:12',NULL),(4606,7657,1470,40760,25774,3,68,1,46890.80,NULL,'2023-04-29 22:10:12','2023-04-29 22:10:12',NULL),(4607,7657,1470,40760,25774,3,238,1,7390.88,NULL,'2023-04-29 22:10:12','2023-04-29 22:10:12',NULL),(4608,7657,1470,40760,25774,3,57,2,277571.20,NULL,'2023-04-29 22:10:12','2023-04-29 22:10:12',NULL),(4609,7657,1471,40760,25774,3,217,1,12075.03,NULL,'2023-04-29 22:16:28','2023-04-29 22:16:28',NULL),(4610,7657,1471,40760,25774,3,68,1,2535.76,NULL,'2023-04-29 22:16:28','2023-04-29 22:16:28',NULL),(4611,7657,1471,40760,25774,3,217,1,691.27,NULL,'2023-04-29 22:16:28','2023-04-29 22:16:28',NULL),(4612,7657,1471,40760,25774,3,238,1,399.68,NULL,'2023-04-29 22:16:28','2023-04-29 22:16:28',NULL),(4613,7657,1471,40760,25774,3,57,2,15701.74,NULL,'2023-04-29 22:16:28','2023-04-29 22:16:28',NULL),(4614,7657,1472,40760,25774,3,217,1,3518.13,NULL,'2023-04-29 22:21:52','2023-04-29 22:21:52',NULL),(4615,7657,1472,40760,25774,3,68,1,738.81,NULL,'2023-04-29 22:21:52','2023-04-29 22:21:52',NULL),(4616,7657,1472,40760,25774,3,217,1,126.61,NULL,'2023-04-29 22:21:52','2023-04-29 22:21:52',NULL),(4617,7657,1472,40760,25774,3,238,1,116.45,NULL,'2023-04-29 22:21:52','2023-04-29 22:21:52',NULL),(4618,7657,1472,40760,25774,3,57,2,4500.00,NULL,'2023-04-29 22:21:52','2023-04-29 22:21:52',NULL),(4619,7657,1473,40760,25774,3,217,1,393333.65,NULL,'2023-04-29 22:27:42','2023-04-29 22:27:42',NULL),(4620,7657,1473,40760,25774,3,68,1,82600.07,NULL,'2023-04-29 22:27:42','2023-04-29 22:27:42',NULL),(4621,7657,1473,40760,25774,3,217,1,3146.67,NULL,'2023-04-29 22:27:42','2023-04-29 22:27:42',NULL),(4622,7657,1473,40760,25774,3,57,2,479080.39,NULL,'2023-04-29 22:27:42','2023-04-29 22:27:42',NULL),(4623,7657,1474,40760,25774,3,217,1,178200.00,NULL,'2023-04-29 22:37:38','2023-04-29 22:37:38',NULL),(4624,7657,1474,40760,25774,3,68,1,37422.00,NULL,'2023-04-29 22:37:38','2023-04-29 22:37:38',NULL),(4625,7657,1474,40760,25774,3,217,1,1425.60,NULL,'2023-04-29 22:37:38','2023-04-29 22:37:38',NULL),(4626,7657,1474,40760,25774,3,57,2,217047.60,NULL,'2023-04-29 22:37:38','2023-04-29 22:37:38',NULL),(4627,7657,1475,40760,25774,3,217,1,146900.00,NULL,'2023-04-29 22:44:30','2023-04-29 22:44:30',NULL),(4628,7657,1475,40760,25774,3,68,1,30849.00,NULL,'2023-04-29 22:44:30','2023-04-29 22:44:30',NULL),(4629,7657,1475,40760,25774,3,217,1,1175.20,NULL,'2023-04-29 22:44:30','2023-04-29 22:44:30',NULL),(4630,7657,1475,40760,25774,3,57,2,178924.20,NULL,'2023-04-29 22:44:30','2023-04-29 22:44:30',NULL),(4631,7657,1476,40760,25774,3,217,1,165000.00,NULL,'2023-04-29 22:47:24','2023-04-29 22:47:24',NULL);
INSERT INTO `balance_libro_details` VALUES (4632,7657,1476,40760,25774,3,68,1,34650.00,NULL,'2023-04-29 22:47:24','2023-04-29 22:47:24',NULL),(4633,7657,1476,40760,25774,3,217,1,1320.00,NULL,'2023-04-29 22:47:24','2023-04-29 22:47:24',NULL),(4634,7657,1476,40760,25774,3,57,2,200970.00,NULL,'2023-04-29 22:47:24','2023-04-29 22:47:24',NULL),(4635,7657,1477,40760,25774,3,217,1,159200.00,NULL,'2023-04-29 22:49:16','2023-04-29 22:49:16',NULL),(4636,7657,1477,40760,25774,3,68,1,33432.00,NULL,'2023-04-29 22:49:16','2023-04-29 22:49:16',NULL),(4637,7657,1477,40760,25774,3,217,1,1273.60,NULL,'2023-04-29 22:49:16','2023-04-29 22:49:16',NULL),(4638,7657,1477,40760,25774,3,57,2,193905.60,NULL,'2023-04-29 22:49:16','2023-04-29 22:49:16',NULL),(4639,7657,1478,40760,25774,3,217,1,169200.00,NULL,'2023-04-29 22:52:36','2023-04-29 22:52:36',NULL),(4640,7657,1478,40760,25774,3,68,1,35532.00,NULL,'2023-04-29 22:52:36','2023-04-29 22:52:36',NULL),(4641,7657,1478,40760,25774,3,217,1,1353.60,NULL,'2023-04-29 22:52:36','2023-04-29 22:52:36',NULL),(4642,7657,1478,40760,25774,3,57,2,206085.60,NULL,'2023-04-29 22:52:36','2023-04-29 22:52:36',NULL),(4643,7657,1479,40760,25774,3,217,1,158400.00,NULL,'2023-04-29 22:54:32','2023-04-29 22:54:32',NULL),(4644,7657,1479,40760,25774,3,68,1,33264.00,NULL,'2023-04-29 22:54:32','2023-04-29 22:54:32',NULL),(4645,7657,1479,40760,25774,3,217,1,1267.20,NULL,'2023-04-29 22:54:32','2023-04-29 22:54:32',NULL),(4646,7657,1479,40760,25774,3,57,2,192931.20,NULL,'2023-04-29 22:54:32','2023-04-29 22:54:32',NULL),(4647,7657,1480,40760,25774,3,217,1,217800.00,NULL,'2023-04-29 23:02:28','2023-04-29 23:02:28',NULL),(4648,7657,1480,40760,25774,3,68,1,45738.00,NULL,'2023-04-29 23:02:28','2023-04-29 23:02:28',NULL),(4649,7657,1480,40760,25774,3,238,1,7209.18,NULL,'2023-04-29 23:02:28','2023-04-29 23:02:28',NULL),(4650,7657,1480,40760,25774,3,57,2,270747.18,NULL,'2023-04-29 23:02:28','2023-04-29 23:02:28',NULL),(4651,7657,1481,40760,25774,3,217,1,173000.00,NULL,'2023-04-29 23:04:22','2023-04-29 23:04:22',NULL),(4652,7657,1481,40760,25774,3,68,1,36330.00,NULL,'2023-04-29 23:04:22','2023-04-29 23:04:22',NULL),(4653,7657,1481,40760,25774,3,217,1,1384.00,NULL,'2023-04-29 23:04:22','2023-04-29 23:04:22',NULL),(4654,7657,1481,40760,25774,3,57,2,210714.00,NULL,'2023-04-29 23:04:22','2023-04-29 23:04:22',NULL),(4655,7657,1482,40760,25774,3,217,1,169000.00,NULL,'2023-04-29 23:06:21','2023-04-29 23:06:21',NULL),(4656,7657,1482,40760,25774,3,68,1,35490.00,NULL,'2023-04-29 23:06:21','2023-04-29 23:06:21',NULL),(4657,7657,1482,40760,25774,3,217,1,1352.00,NULL,'2023-04-29 23:06:21','2023-04-29 23:06:21',NULL),(4658,7657,1482,40760,25774,3,57,2,205842.00,NULL,'2023-04-29 23:06:21','2023-04-29 23:06:21',NULL),(4659,7657,1483,40760,25774,3,217,1,175000.00,NULL,'2023-04-29 23:07:43','2023-04-29 23:07:43',NULL),(4660,7657,1483,40760,25774,3,68,1,36750.00,NULL,'2023-04-29 23:07:43','2023-04-29 23:07:43',NULL),(4661,7657,1483,40760,25774,3,217,1,1400.00,NULL,'2023-04-29 23:07:43','2023-04-29 23:07:43',NULL),(4662,7657,1483,40760,25774,3,57,2,213150.00,NULL,'2023-04-29 23:07:43','2023-04-29 23:07:43',NULL),(4663,7657,1484,40760,25774,3,217,1,178400.00,NULL,'2023-04-29 23:10:11','2023-04-29 23:10:11',NULL),(4664,7657,1484,40760,25774,3,68,1,37464.00,NULL,'2023-04-29 23:10:11','2023-04-29 23:10:11',NULL),(4665,7657,1484,40760,25774,3,217,1,1427.20,NULL,'2023-04-29 23:10:11','2023-04-29 23:10:11',NULL),(4666,7657,1484,40760,25774,3,57,2,217291.20,NULL,'2023-04-29 23:10:11','2023-04-29 23:10:11',NULL),(4667,7657,1485,40760,25774,3,217,1,201300.00,NULL,'2023-04-29 23:15:48','2023-04-29 23:15:48',NULL),(4668,7657,1485,40760,25774,3,68,1,42273.00,NULL,'2023-04-29 23:15:48','2023-04-29 23:15:48',NULL),(4669,7657,1485,40760,25774,3,217,1,1610.40,NULL,'2023-04-29 23:15:48','2023-04-29 23:15:48',NULL),(4670,7657,1485,40760,25774,3,57,2,245183.40,NULL,'2023-04-29 23:15:48','2023-04-29 23:15:48',NULL),(4671,7657,1486,40760,25774,3,217,1,2344.41,NULL,'2023-04-29 23:20:44','2023-04-29 23:20:44',NULL);
INSERT INTO `balance_libro_details` VALUES (4672,7657,1486,40760,25774,3,68,1,492.33,NULL,'2023-04-29 23:20:44','2023-04-29 23:20:44',NULL),(4673,7657,1486,40760,25774,3,217,1,85.68,NULL,'2023-04-29 23:20:44','2023-04-29 23:20:44',NULL),(4674,7657,1486,40760,25774,3,238,1,77.59,NULL,'2023-04-29 23:20:44','2023-04-29 23:20:44',NULL),(4675,7657,1486,40760,25774,3,57,2,3000.01,NULL,'2023-04-29 23:20:44','2023-04-29 23:20:44',NULL),(4676,7657,1487,40760,25775,3,217,1,56033.06,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4677,7657,1487,40760,25775,3,68,1,11766.94,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4678,7657,1487,40760,25775,3,57,2,67800.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4679,7657,1488,40760,25775,3,217,1,11983.47,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4680,7657,1488,40760,25775,3,68,1,2516.53,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4681,7657,1488,40760,25775,3,57,2,14500.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4682,7657,1489,40760,25775,3,217,1,1570.25,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4683,7657,1489,40760,25775,3,68,1,329.75,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4684,7657,1489,40760,25775,3,57,2,1900.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4685,7657,1490,40760,25775,3,217,1,8433.31,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4686,7657,1490,40760,25775,3,68,1,1771.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4687,7657,1490,40760,25775,3,217,1,896.19,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4688,7657,1490,40760,25775,3,57,2,11100.50,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4689,7657,1491,40760,25775,3,217,1,143583.82,NULL,'2023-05-08 18:54:34','2023-05-08 19:11:26','2023-05-08 19:11:26'),(4690,7657,1491,40760,25775,3,68,1,30152.60,NULL,'2023-05-08 18:54:34','2023-05-08 19:11:26','2023-05-08 19:11:26'),(4691,7657,1491,40760,25775,3,217,1,1148.67,NULL,'2023-05-08 18:54:34','2023-05-08 19:11:26','2023-05-08 19:11:26'),(4692,7657,1491,40760,25775,3,57,2,174885.09,NULL,'2023-05-08 18:54:34','2023-05-08 19:11:26','2023-05-08 19:11:26'),(4693,7657,1492,40760,25775,3,217,1,3038.90,NULL,'2023-05-08 18:54:34','2023-05-08 19:26:59','2023-05-08 19:26:59'),(4694,7657,1492,40760,25775,3,68,1,638.17,NULL,'2023-05-08 18:54:34','2023-05-08 19:26:59','2023-05-08 19:26:59'),(4695,7657,1492,40760,25775,3,217,1,322.93,NULL,'2023-05-08 18:54:34','2023-05-08 19:26:59','2023-05-08 19:26:59'),(4696,7657,1492,40760,25775,3,57,2,4000.00,NULL,'2023-05-08 18:54:34','2023-05-08 19:26:59','2023-05-08 19:26:59'),(4697,7657,1493,40760,25775,3,217,2,25701503.06,NULL,'2023-05-08 18:54:34','2023-05-08 19:31:12','2023-05-08 19:31:12'),(4698,7657,1493,40760,25775,3,67,2,5397315.64,NULL,'2023-05-08 18:54:34','2023-05-08 19:31:12','2023-05-08 19:31:12'),(4699,7657,1493,40760,25775,3,217,2,205612.02,NULL,'2023-05-08 18:54:34','2023-05-08 19:31:12','2023-05-08 19:31:12'),(4700,7657,1493,40760,25775,3,57,1,31304430.72,NULL,'2023-05-08 18:54:34','2023-05-08 19:31:12','2023-05-08 19:31:12'),(4701,7657,1494,40760,25775,3,217,1,3719.01,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4702,7657,1494,40760,25775,3,68,1,780.99,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4703,7657,1494,40760,25775,3,57,2,4500.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4704,7657,1495,40760,25775,3,217,1,1322.31,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4705,7657,1495,40760,25775,3,68,1,277.69,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4706,7657,1495,40760,25775,3,57,2,1600.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4707,7657,1496,40760,25775,3,217,1,9082.64,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4708,7657,1496,40760,25775,3,68,1,1907.35,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4709,7657,1496,40760,25775,3,57,2,10989.99,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL);
INSERT INTO `balance_libro_details` VALUES (4710,7657,1497,40760,25775,3,217,1,20000.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4711,7657,1497,40760,25775,3,68,1,4200.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4712,7657,1497,40760,25775,3,57,2,24200.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4713,7657,1498,40760,25775,3,217,1,950.41,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4714,7657,1498,40760,25775,3,68,1,199.59,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4715,7657,1498,40760,25775,3,57,2,1150.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4716,7657,1499,40760,25775,3,217,1,3305.79,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4717,7657,1499,40760,25775,3,68,1,694.22,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4718,7657,1499,40760,25775,3,57,2,4000.01,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4719,7657,1500,40760,25775,3,217,1,2975.21,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4720,7657,1500,40760,25775,3,68,1,624.79,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4721,7657,1500,40760,25775,3,57,2,3600.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4722,7657,1501,40760,25775,3,217,1,2479.34,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4723,7657,1501,40760,25775,3,68,1,520.66,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4724,7657,1501,40760,25775,3,57,2,3000.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4725,7657,1502,40760,25775,3,217,1,9458.44,NULL,'2023-05-08 18:54:34','2023-05-08 19:35:08','2023-05-08 19:35:08'),(4726,7657,1502,40760,25775,3,68,1,1986.27,NULL,'2023-05-08 18:54:34','2023-05-08 19:35:08','2023-05-08 19:35:08'),(4727,7657,1502,40760,25775,3,217,1,354.69,NULL,'2023-05-08 18:54:34','2023-05-08 19:35:08','2023-05-08 19:35:08'),(4728,7657,1502,40760,25775,3,57,2,11799.40,NULL,'2023-05-08 18:54:34','2023-05-08 19:35:08','2023-05-08 19:35:08'),(4729,7657,1503,40760,25775,3,217,1,3966.94,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4730,7657,1503,40760,25775,3,68,1,833.06,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4731,7657,1503,40760,25775,3,57,2,4800.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4732,7657,1504,40760,25775,3,217,1,2757.66,NULL,'2023-05-08 18:54:34','2023-05-08 19:37:36','2023-05-08 19:37:36'),(4733,7657,1504,40760,25775,3,68,1,579.11,NULL,'2023-05-08 18:54:34','2023-05-08 19:37:36','2023-05-08 19:37:36'),(4734,7657,1504,40760,25775,3,217,1,91.28,NULL,'2023-05-08 18:54:34','2023-05-08 19:37:36','2023-05-08 19:37:36'),(4735,7657,1504,40760,25775,3,57,2,3428.05,NULL,'2023-05-08 18:54:34','2023-05-08 19:37:36','2023-05-08 19:37:36'),(4736,7657,1505,40760,25775,3,217,1,18437.43,NULL,'2023-05-08 18:54:34','2023-05-08 19:42:59','2023-05-08 19:42:59'),(4737,7657,1505,40760,25775,3,68,1,3871.86,NULL,'2023-05-08 18:54:34','2023-05-08 19:42:59','2023-05-08 19:42:59'),(4738,7657,1505,40760,25775,3,217,1,147.50,NULL,'2023-05-08 18:54:34','2023-05-08 19:42:59','2023-05-08 19:42:59'),(4739,7657,1505,40760,25775,3,57,2,22456.79,NULL,'2023-05-08 18:54:34','2023-05-08 19:42:59','2023-05-08 19:42:59'),(4740,7657,1506,40760,25775,3,217,1,329.68,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4741,7657,1506,40760,25775,3,68,1,69.23,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4742,7657,1506,40760,25775,3,57,2,398.91,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4743,7657,1507,40760,25775,3,217,1,8749.59,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4744,7657,1507,40760,25775,3,68,1,1837.41,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4745,7657,1507,40760,25775,3,57,2,10587.00,NULL,'2023-05-08 18:54:34','2023-05-08 18:54:34',NULL),(4746,7657,1508,40760,25775,3,217,1,21855.17,NULL,'2023-05-08 18:54:34','2023-05-08 19:45:02','2023-05-08 19:45:02'),(4747,7657,1508,40760,25775,3,68,1,4589.59,NULL,'2023-05-08 18:54:34','2023-05-08 19:45:02','2023-05-08 19:45:02');
INSERT INTO `balance_libro_details` VALUES (4748,7657,1508,40760,25775,3,217,1,174.83,NULL,'2023-05-08 18:54:34','2023-05-08 19:45:02','2023-05-08 19:45:02'),(4749,7657,1508,40760,25775,3,57,2,26619.59,NULL,'2023-05-08 18:54:34','2023-05-08 19:45:02','2023-05-08 19:45:02'),(4750,7657,1509,40760,25775,3,217,1,16281.58,NULL,'2023-05-08 18:54:34','2023-05-08 19:51:48','2023-05-08 19:51:48'),(4751,7657,1509,40760,25775,3,68,1,3419.13,NULL,'2023-05-08 18:54:34','2023-05-08 19:51:48','2023-05-08 19:51:48'),(4752,7657,1509,40760,25775,3,217,1,1101.19,NULL,'2023-05-08 18:54:34','2023-05-08 19:51:48','2023-05-08 19:51:48'),(4753,7657,1509,40760,25775,3,57,2,20801.90,NULL,'2023-05-08 18:54:34','2023-05-08 19:51:48','2023-05-08 19:51:48'),(4754,7657,1510,40760,25775,3,217,1,25745.45,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4755,7657,1510,40760,25775,3,68,1,5406.54,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4756,7657,1510,40760,25775,3,217,1,1848.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4757,7657,1510,40760,25775,3,57,2,32999.99,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4758,7657,1511,40760,25775,3,217,1,217800.00,NULL,'2023-05-08 18:54:35','2023-05-08 19:54:51','2023-05-08 19:54:51'),(4759,7657,1511,40760,25775,3,68,1,45738.00,NULL,'2023-05-08 18:54:35','2023-05-08 19:54:51','2023-05-08 19:54:51'),(4760,7657,1511,40760,25775,3,217,1,7209.18,NULL,'2023-05-08 18:54:35','2023-05-08 19:54:51','2023-05-08 19:54:51'),(4761,7657,1511,40760,25775,3,57,2,270747.18,NULL,'2023-05-08 18:54:35','2023-05-08 19:54:51','2023-05-08 19:54:51'),(4762,7657,1512,40760,25775,3,217,1,44069.26,NULL,'2023-05-08 18:54:35','2023-05-08 19:57:25','2023-05-08 19:57:25'),(4763,7657,1512,40760,25775,3,68,1,9254.54,NULL,'2023-05-08 18:54:35','2023-05-08 19:57:25','2023-05-08 19:57:25'),(4764,7657,1512,40760,25775,3,217,1,352.55,NULL,'2023-05-08 18:54:35','2023-05-08 19:57:25','2023-05-08 19:57:25'),(4765,7657,1512,40760,25775,3,57,2,53676.35,NULL,'2023-05-08 18:54:35','2023-05-08 19:57:25','2023-05-08 19:57:25'),(4766,7657,1513,40760,25775,3,217,1,14400.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4767,7657,1513,40760,25775,3,68,1,3024.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4768,7657,1513,40760,25775,3,57,2,17424.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4769,7657,1514,40760,25775,3,217,1,12297.52,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4770,7657,1514,40760,25775,3,68,1,2582.48,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4771,7657,1514,40760,25775,3,57,2,14880.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4772,7657,1515,40760,25775,3,217,1,6033.06,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4773,7657,1515,40760,25775,3,68,1,1266.94,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4774,7657,1515,40760,25775,3,57,2,7300.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4775,7657,1516,40760,25775,3,217,1,1239.67,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4776,7657,1516,40760,25775,3,68,1,260.33,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4777,7657,1516,40760,25775,3,57,2,1500.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4778,7657,1517,40760,25775,3,217,1,7107.44,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4779,7657,1517,40760,25775,3,68,1,1492.56,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4780,7657,1517,40760,25775,3,57,2,8600.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4781,7657,1518,40760,25775,3,217,1,3801.65,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4782,7657,1518,40760,25775,3,68,1,798.35,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4783,7657,1518,40760,25775,3,57,2,4600.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4784,7657,1519,40760,25775,3,217,1,909.09,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4785,7657,1519,40760,25775,3,68,1,190.91,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL);
INSERT INTO `balance_libro_details` VALUES (4786,7657,1519,40760,25775,3,57,2,1100.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4787,7657,1520,40760,25775,3,217,1,14049.59,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4788,7657,1520,40760,25775,3,68,1,2950.41,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4789,7657,1520,40760,25775,3,57,2,17000.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4790,7657,1521,40760,25775,3,217,1,4545.46,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4791,7657,1521,40760,25775,3,68,1,954.55,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4792,7657,1521,40760,25775,3,57,2,5500.01,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4793,7657,1522,40760,25775,3,217,1,21404.96,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4794,7657,1522,40760,25775,3,68,1,4495.04,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4795,7657,1522,40760,25775,3,57,2,25900.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4796,7657,1523,40760,25775,3,217,1,3884.30,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4797,7657,1523,40760,25775,3,68,1,815.70,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4798,7657,1523,40760,25775,3,57,2,4700.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4799,7657,1524,40760,25775,3,217,1,4049.59,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4800,7657,1524,40760,25775,3,68,1,850.41,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4801,7657,1524,40760,25775,3,57,2,4900.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4802,7657,1525,40760,25775,3,217,1,495.87,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4803,7657,1525,40760,25775,3,68,1,104.13,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4804,7657,1525,40760,25775,3,57,2,600.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4805,7657,1526,40760,25775,3,217,1,19759.63,NULL,'2023-05-08 18:54:35','2023-05-08 20:01:32','2023-05-08 20:01:32'),(4806,7657,1526,40760,25775,3,68,1,4149.52,NULL,'2023-05-08 18:54:35','2023-05-08 20:01:32','2023-05-08 20:01:32'),(4807,7657,1526,40760,25775,3,217,1,812.12,NULL,'2023-05-08 18:54:35','2023-05-08 20:01:32','2023-05-08 20:01:32'),(4808,7657,1526,40760,25775,3,57,2,24721.27,NULL,'2023-05-08 18:54:35','2023-05-08 20:01:32','2023-05-08 20:01:32'),(4809,7657,1527,40760,25775,3,217,1,2727.27,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4810,7657,1527,40760,25775,3,68,1,572.73,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4811,7657,1527,40760,25775,3,57,2,3300.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4812,7657,1528,40760,25775,3,217,1,147768.31,NULL,'2023-05-08 18:54:35','2023-05-08 20:04:01','2023-05-08 20:04:01'),(4813,7657,1528,40760,25775,3,68,1,31031.35,NULL,'2023-05-08 18:54:35','2023-05-08 20:04:01','2023-05-08 20:04:01'),(4814,7657,1528,40760,25775,3,217,1,1182.15,NULL,'2023-05-08 18:54:35','2023-05-08 20:04:01','2023-05-08 20:04:01'),(4815,7657,1528,40760,25775,3,57,2,179981.81,NULL,'2023-05-08 18:54:35','2023-05-08 20:04:01','2023-05-08 20:04:01'),(4816,7657,1529,40760,25775,3,217,1,45848.77,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4817,7657,1529,40760,25775,3,68,1,9628.24,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4818,7657,1529,40760,25775,3,57,2,55477.01,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4819,7657,1530,40760,25775,3,217,1,3884.30,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4820,7657,1530,40760,25775,3,68,1,815.70,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4821,7657,1530,40760,25775,3,57,2,4700.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4822,7657,1531,40760,25775,3,217,1,11322.31,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4823,7657,1531,40760,25775,3,68,1,2377.69,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4824,7657,1531,40760,25775,3,57,2,13700.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL);
INSERT INTO `balance_libro_details` VALUES (4825,7657,1532,40760,25775,3,217,1,37408.25,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4826,7657,1532,40760,25775,3,68,1,7855.73,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4827,7657,1532,40760,25775,3,57,2,45263.98,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4828,7657,1533,40760,25775,3,217,1,47933.89,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4829,7657,1533,40760,25775,3,68,1,10066.12,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4830,7657,1533,40760,25775,3,57,2,58000.01,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4831,7657,1534,40760,25775,3,217,1,23801.65,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4832,7657,1534,40760,25775,3,68,1,4998.35,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4833,7657,1534,40760,25775,3,57,2,28800.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4834,7657,1535,40760,25775,3,217,1,10247.93,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4835,7657,1535,40760,25775,3,68,1,2152.07,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4836,7657,1535,40760,25775,3,57,2,12400.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4837,7657,1536,40760,25775,3,217,1,826.45,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4838,7657,1536,40760,25775,3,68,1,173.55,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4839,7657,1536,40760,25775,3,57,2,1000.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4840,7657,1537,40760,25775,3,217,1,4545.46,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4841,7657,1537,40760,25775,3,68,1,954.55,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4842,7657,1537,40760,25775,3,57,2,5500.01,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4843,7657,1538,40760,25775,3,217,1,33140.50,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4844,7657,1538,40760,25775,3,68,1,6959.50,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4845,7657,1538,40760,25775,3,57,2,40100.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4846,7657,1539,40760,25775,3,217,1,10247.93,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4847,7657,1539,40760,25775,3,68,1,2152.07,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4848,7657,1539,40760,25775,3,57,2,12400.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4849,7657,1540,40760,25775,3,217,1,9504.13,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4850,7657,1540,40760,25775,3,68,1,1995.87,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4851,7657,1540,40760,25775,3,57,2,11500.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4852,7657,1541,40760,25775,3,217,1,21900.83,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4853,7657,1541,40760,25775,3,68,1,4599.17,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4854,7657,1541,40760,25775,3,57,2,26500.00,NULL,'2023-05-08 18:54:35','2023-05-08 18:54:35',NULL),(4855,7657,1542,40760,25775,3,217,1,7190.08,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4856,7657,1542,40760,25775,3,68,1,1509.92,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4857,7657,1542,40760,25775,3,57,2,8700.00,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4858,7657,1543,40760,25775,3,217,1,1239.67,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4859,7657,1543,40760,25775,3,68,1,260.33,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4860,7657,1543,40760,25775,3,57,2,1500.00,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4861,7657,1544,40760,25775,3,217,1,9834.71,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4862,7657,1544,40760,25775,3,68,1,2065.29,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4863,7657,1544,40760,25775,3,57,2,11900.00,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4864,7657,1545,40760,25775,3,217,1,5041.32,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL);
INSERT INTO `balance_libro_details` VALUES (4865,7657,1545,40760,25775,3,68,1,1058.68,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4866,7657,1545,40760,25775,3,57,2,6100.00,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4867,7657,1546,40760,25775,3,217,1,10330.58,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4868,7657,1546,40760,25775,3,68,1,2169.42,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4869,7657,1546,40760,25775,3,57,2,12500.00,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4870,7657,1547,40760,25775,3,217,1,3305.79,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4871,7657,1547,40760,25775,3,68,1,694.22,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4872,7657,1547,40760,25775,3,57,2,4000.01,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4873,7657,1548,40760,25775,3,217,1,826.45,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4874,7657,1548,40760,25775,3,68,1,173.55,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4875,7657,1548,40760,25775,3,57,2,1000.00,NULL,'2023-05-08 18:54:36','2023-05-08 18:54:36',NULL),(4876,7657,1549,40760,25775,3,217,1,4462.81,NULL,'2023-0