-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-27787997-3
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-09-05 13:20:45','Actividad Generica 1','000001',NULL),(2,NULL,'2022-09-05 13:20:45','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'AFIP','Patito2022',NULL,1,40720,'2022-10-11');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'lulibreglia@hotmail.com','1150545854',NULL,1,40719,'2022-10-07'),(2,'lulibreglia@hotmail.com','1150545854','',1,40719,'2022-10-07'),(3,'lulibreglia@hotmail.com','1150545854','',1,40719,'2022-10-07'),(4,'pato574867@gmail.com',NULL,'',1,40720,'2022-10-11');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1260 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7776,40720,1584,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',650.00,NULL,NULL,1,'2022-10-11 00:21:00','2022-10-11 00:21:00',NULL),(2,NULL,40720,1584,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:07','2022-10-11 00:26:07',NULL),(3,NULL,40720,1584,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:09','2022-10-11 00:26:09',NULL),(4,NULL,40720,1584,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:12','2022-10-11 00:26:12',NULL),(5,NULL,40720,1584,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:13','2022-10-11 00:26:13',NULL),(6,NULL,40720,1584,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:16','2022-10-11 00:26:16',NULL),(7,NULL,40720,1584,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:18','2022-10-11 00:26:18',NULL),(8,NULL,40720,1584,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:20','2022-10-11 00:26:20',NULL),(9,NULL,40720,1584,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:21','2022-10-11 00:26:21',NULL),(10,NULL,40720,1584,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:23','2022-10-11 00:26:23',NULL),(11,NULL,40720,1584,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:24','2022-10-11 00:26:24',NULL),(12,NULL,40720,1584,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:26','2022-10-11 00:26:26',NULL),(13,NULL,40720,1584,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:28','2022-10-11 00:26:28',NULL),(14,NULL,40720,1584,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:31','2022-10-11 00:26:31',NULL),(15,NULL,40720,1584,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:33','2022-10-11 00:26:33',NULL),(16,NULL,40720,1584,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:34','2022-10-11 00:26:34',NULL),(17,NULL,40720,1584,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:36','2022-10-11 00:26:36',NULL),(18,NULL,40720,1584,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:38','2022-10-11 00:26:38',NULL),(19,NULL,40720,1584,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:39','2022-10-11 00:26:39',NULL),(20,NULL,40720,1584,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:41','2022-10-11 00:26:41',NULL),(21,NULL,40720,1584,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:44','2022-10-11 00:26:44',NULL),(22,NULL,40720,1584,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:46','2022-10-11 00:26:46',NULL),(23,NULL,40720,1584,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:48','2022-10-11 00:26:48',NULL),(24,NULL,40720,1584,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:49','2022-10-11 00:26:49',NULL),(25,NULL,40720,1584,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:51','2022-10-11 00:26:51',NULL),(26,NULL,40720,1584,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:53','2022-10-11 00:26:53',NULL);
INSERT INTO `balance_libro` VALUES (27,NULL,40720,1584,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:55','2022-10-11 00:26:55',NULL),(28,NULL,40720,1584,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:26:58','2022-10-11 00:26:58',NULL),(29,NULL,40720,1584,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:00','2022-10-11 00:27:00',NULL),(30,NULL,40720,1584,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:02','2022-10-11 00:27:02',NULL),(31,NULL,40720,1584,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:04','2022-10-11 00:27:04',NULL),(32,NULL,40720,1584,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:05','2022-10-11 00:27:05',NULL),(33,NULL,40720,1584,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:07','2022-10-11 00:27:07',NULL),(34,NULL,40720,1584,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:10','2022-10-11 00:27:10',NULL),(35,NULL,40720,1584,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:13','2022-10-11 00:27:13',NULL),(36,NULL,40720,1584,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:14','2022-10-11 00:27:14',NULL),(37,NULL,40720,1584,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:16','2022-10-11 00:27:16',NULL),(38,NULL,40720,1584,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:18','2022-10-11 00:27:18',NULL),(39,NULL,40720,1584,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:20','2022-10-11 00:27:20',NULL),(40,NULL,40720,1584,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:21','2022-10-11 00:27:21',NULL),(41,NULL,40720,1584,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:24','2022-10-11 00:27:24',NULL),(42,NULL,40720,1584,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:27','2022-10-11 00:27:27',NULL),(43,NULL,40720,1584,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:28','2022-10-11 00:27:28',NULL),(44,NULL,40720,1584,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:30','2022-10-11 00:27:30',NULL),(45,NULL,40720,1584,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:32','2022-10-11 00:27:32',NULL),(46,NULL,40720,1584,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:33','2022-10-11 00:27:33',NULL),(47,NULL,40720,1584,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:35','2022-10-11 00:27:35',NULL),(48,NULL,40720,1584,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:38','2022-10-11 00:27:38',NULL),(49,NULL,40720,1584,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:41','2022-10-11 00:27:41',NULL),(50,NULL,40720,1584,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:42','2022-10-11 00:27:42',NULL),(51,NULL,40720,1584,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:44','2022-10-11 00:27:44',NULL),(52,NULL,40720,1584,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:46','2022-10-11 00:27:46',NULL);
INSERT INTO `balance_libro` VALUES (53,NULL,40720,1584,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:47','2022-10-11 00:27:47',NULL),(54,NULL,40720,1584,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:49','2022-10-11 00:27:49',NULL),(55,NULL,40720,1584,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:52','2022-10-11 00:27:52',NULL),(56,NULL,40720,1584,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:55','2022-10-11 00:27:55',NULL),(57,NULL,40720,1584,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:56','2022-10-11 00:27:56',NULL),(58,NULL,40720,1584,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:27:58','2022-10-11 00:27:58',NULL),(59,NULL,40720,1584,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:00','2022-10-11 00:28:00',NULL),(60,NULL,40720,1584,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:02','2022-10-11 00:28:02',NULL),(61,NULL,40720,1584,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:03','2022-10-11 00:28:03',NULL),(62,NULL,40720,1584,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:06','2022-10-11 00:28:06',NULL),(63,NULL,40720,1584,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:08','2022-10-11 00:28:08',NULL),(64,NULL,40720,1584,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:10','2022-10-11 00:28:10',NULL),(65,NULL,40720,1584,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:11','2022-10-11 00:28:11',NULL),(66,NULL,40720,1584,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:13','2022-10-11 00:28:13',NULL),(67,NULL,40720,1584,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:15','2022-10-11 00:28:15',NULL),(68,NULL,40720,1584,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:16','2022-10-11 00:28:16',NULL),(69,NULL,40720,1584,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:19','2022-10-11 00:28:19',NULL),(70,NULL,40720,1584,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:22','2022-10-11 00:28:22',NULL),(71,NULL,40720,1584,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:23','2022-10-11 00:28:23',NULL),(72,NULL,40720,1584,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:25','2022-10-11 00:28:25',NULL),(73,NULL,40720,1584,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:27','2022-10-11 00:28:27',NULL),(74,NULL,40720,1584,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:28','2022-10-11 00:28:28',NULL),(75,NULL,40720,1584,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:30','2022-10-11 00:28:30',NULL),(76,NULL,40720,1584,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:33','2022-10-11 00:28:33',NULL),(77,NULL,40720,1584,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:35','2022-10-11 00:28:35',NULL),(78,NULL,40720,1584,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:37','2022-10-11 00:28:37',NULL);
INSERT INTO `balance_libro` VALUES (79,NULL,40720,1584,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:39','2022-10-11 00:28:39',NULL),(80,NULL,40720,1584,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:40','2022-10-11 00:28:40',NULL),(81,NULL,40720,1584,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:42','2022-10-11 00:28:42',NULL),(82,NULL,40720,1584,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:44','2022-10-11 00:28:44',NULL),(83,NULL,40720,1584,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:48','2022-10-11 00:28:48',NULL),(84,NULL,40720,1584,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:49','2022-10-11 00:28:49',NULL),(85,NULL,40720,1584,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:51','2022-10-11 00:28:51',NULL),(86,NULL,40720,1584,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:53','2022-10-11 00:28:53',NULL),(87,NULL,40720,1584,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:55','2022-10-11 00:28:55',NULL),(88,NULL,40720,1584,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:56','2022-10-11 00:28:56',NULL),(89,NULL,40720,1584,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:28:59','2022-10-11 00:28:59',NULL),(90,NULL,40720,1584,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:01','2022-10-11 00:29:01',NULL),(91,NULL,40720,1584,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:03','2022-10-11 00:29:03',NULL),(92,NULL,40720,1584,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:05','2022-10-11 00:29:05',NULL),(93,NULL,40720,1584,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:07','2022-10-11 00:29:07',NULL),(94,NULL,40720,1584,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:09','2022-10-11 00:29:09',NULL),(95,NULL,40720,1584,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:10','2022-10-11 00:29:10',NULL),(96,NULL,40720,1584,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:13','2022-10-11 00:29:13',NULL),(97,NULL,40720,1584,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:15','2022-10-11 00:29:15',NULL),(98,NULL,40720,1584,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:17','2022-10-11 00:29:17',NULL),(99,NULL,40720,1584,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:18','2022-10-11 00:29:18',NULL),(100,NULL,40720,1584,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:20','2022-10-11 00:29:20',NULL),(101,NULL,40720,1584,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:22','2022-10-11 00:29:22',NULL),(102,NULL,40720,1584,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:24','2022-10-11 00:29:24',NULL),(103,NULL,40720,1584,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:27','2022-10-11 00:29:27',NULL);
INSERT INTO `balance_libro` VALUES (104,NULL,40720,1584,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:29','2022-10-11 00:29:29',NULL),(105,NULL,40720,1584,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:31','2022-10-11 00:29:31',NULL),(106,NULL,40720,1584,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:32','2022-10-11 00:29:32',NULL),(107,NULL,40720,1584,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:34','2022-10-11 00:29:34',NULL),(108,NULL,40720,1584,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:36','2022-10-11 00:29:36',NULL),(109,NULL,40720,1584,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:38','2022-10-11 00:29:38',NULL),(110,NULL,40720,1584,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:40','2022-10-11 00:29:40',NULL),(111,NULL,40720,1584,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:42','2022-10-11 00:29:42',NULL),(112,NULL,40720,1584,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:44','2022-10-11 00:29:44',NULL),(113,NULL,40720,1584,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:45','2022-10-11 00:29:45',NULL),(114,NULL,40720,1584,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:47','2022-10-11 00:29:47',NULL),(115,NULL,40720,1584,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:49','2022-10-11 00:29:49',NULL),(116,NULL,40720,1584,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:51','2022-10-11 00:29:51',NULL),(117,NULL,40720,1584,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:54','2022-10-11 00:29:54',NULL),(118,NULL,40720,1584,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:55','2022-10-11 00:29:55',NULL),(119,NULL,40720,1584,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:57','2022-10-11 00:29:57',NULL),(120,NULL,40720,1584,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:29:59','2022-10-11 00:29:59',NULL),(121,NULL,40720,1584,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:01','2022-10-11 00:30:01',NULL),(122,NULL,40720,1584,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:03','2022-10-11 00:30:03',NULL),(123,NULL,40720,1584,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:06','2022-10-11 00:30:06',NULL),(124,NULL,40720,1584,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:08','2022-10-11 00:30:08',NULL),(125,NULL,40720,1584,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:09','2022-10-11 00:30:09',NULL),(126,NULL,40720,1584,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:11','2022-10-11 00:30:11',NULL),(127,NULL,40720,1584,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:13','2022-10-11 00:30:13',NULL),(128,NULL,40720,1584,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:15','2022-10-11 00:30:15',NULL);
INSERT INTO `balance_libro` VALUES (129,NULL,40720,1584,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:19','2022-10-11 00:30:19',NULL),(130,NULL,40720,1584,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:21','2022-10-11 00:30:21',NULL),(131,NULL,40720,1584,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:22','2022-10-11 00:30:22',NULL),(132,NULL,40720,1584,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:24','2022-10-11 00:30:24',NULL),(133,NULL,40720,1584,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:26','2022-10-11 00:30:26',NULL),(134,NULL,40720,1584,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:28','2022-10-11 00:30:28',NULL),(135,NULL,40720,1584,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:30','2022-10-11 00:30:30',NULL),(136,NULL,40720,1584,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:33','2022-10-11 00:30:33',NULL),(137,NULL,40720,1584,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:35','2022-10-11 00:30:35',NULL),(138,NULL,40720,1584,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:37','2022-10-11 00:30:37',NULL),(139,NULL,40720,1584,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:39','2022-10-11 00:30:39',NULL),(140,NULL,40720,1584,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:41','2022-10-11 00:30:41',NULL),(141,NULL,40720,1584,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:42','2022-10-11 00:30:42',NULL),(142,NULL,40720,1584,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:46','2022-10-11 00:30:46',NULL),(143,NULL,40720,1584,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:48','2022-10-11 00:30:48',NULL),(144,NULL,40720,1584,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:50','2022-10-11 00:30:50',NULL),(145,NULL,40720,1584,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:52','2022-10-11 00:30:52',NULL),(146,NULL,40720,1584,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:53','2022-10-11 00:30:53',NULL),(147,NULL,40720,1584,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:55','2022-10-11 00:30:55',NULL),(148,NULL,40720,1584,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:30:57','2022-10-11 00:30:57',NULL),(149,NULL,40720,1584,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:01','2022-10-11 00:31:01',NULL),(150,NULL,40720,1584,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:03','2022-10-11 00:31:03',NULL),(151,NULL,40720,1584,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:05','2022-10-11 00:31:05',NULL),(152,NULL,40720,1584,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:07','2022-10-11 00:31:07',NULL),(153,NULL,40720,1584,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:09','2022-10-11 00:31:09',NULL);
INSERT INTO `balance_libro` VALUES (154,NULL,40720,1584,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:11','2022-10-11 00:31:11',NULL),(155,NULL,40720,1584,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:15','2022-10-11 00:31:15',NULL),(156,NULL,40720,1584,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:17','2022-10-11 00:31:17',NULL),(157,NULL,40720,1584,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:19','2022-10-11 00:31:19',NULL),(158,NULL,40720,1584,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:21','2022-10-11 00:31:21',NULL),(159,NULL,40720,1584,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:23','2022-10-11 00:31:23',NULL),(160,NULL,40720,1584,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:25','2022-10-11 00:31:25',NULL),(161,NULL,40720,1584,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:28','2022-10-11 00:31:28',NULL),(162,NULL,40720,1584,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:30','2022-10-11 00:31:30',NULL),(163,NULL,40720,1584,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:32','2022-10-11 00:31:32',NULL),(164,NULL,40720,1584,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:34','2022-10-11 00:31:34',NULL),(165,NULL,40720,1584,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:35','2022-10-11 00:31:35',NULL),(166,NULL,40720,1584,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:37','2022-10-11 00:31:37',NULL),(167,NULL,40720,1584,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:39','2022-10-11 00:31:39',NULL),(168,NULL,40720,1584,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:42','2022-10-11 00:31:42',NULL),(169,NULL,40720,1584,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:44','2022-10-11 00:31:44',NULL),(170,NULL,40720,1584,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:46','2022-10-11 00:31:46',NULL),(171,NULL,40720,1584,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:48','2022-10-11 00:31:48',NULL),(172,NULL,40720,1584,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:50','2022-10-11 00:31:50',NULL),(173,NULL,40720,1584,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:52','2022-10-11 00:31:52',NULL),(174,NULL,40720,1584,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:54','2022-10-11 00:31:54',NULL),(175,NULL,40720,1584,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:56','2022-10-11 00:31:56',NULL),(176,NULL,40720,1584,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:31:58','2022-10-11 00:31:58',NULL),(177,NULL,40720,1584,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:00','2022-10-11 00:32:00',NULL),(178,NULL,40720,1584,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:02','2022-10-11 00:32:02',NULL);
INSERT INTO `balance_libro` VALUES (179,NULL,40720,1584,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:05','2022-10-11 00:32:05',NULL),(180,NULL,40720,1584,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:07','2022-10-11 00:32:07',NULL),(181,NULL,40720,1584,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:09','2022-10-11 00:32:09',NULL),(182,NULL,40720,1584,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:11','2022-10-11 00:32:11',NULL),(183,NULL,40720,1584,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:13','2022-10-11 00:32:13',NULL),(184,NULL,40720,1584,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:15','2022-10-11 00:32:15',NULL),(185,NULL,40720,1584,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:17','2022-10-11 00:32:17',NULL),(186,NULL,40720,1584,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:20','2022-10-11 00:32:20',NULL),(187,NULL,40720,1584,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:22','2022-10-11 00:32:22',NULL),(188,NULL,40720,1584,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:23','2022-10-11 00:32:23',NULL),(189,NULL,40720,1584,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:25','2022-10-11 00:32:25',NULL),(190,NULL,40720,1584,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:27','2022-10-11 00:32:27',NULL),(191,NULL,40720,1584,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:29','2022-10-11 00:32:29',NULL),(192,NULL,40720,1584,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:33','2022-10-11 00:32:33',NULL),(193,NULL,40720,1584,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:35','2022-10-11 00:32:35',NULL),(194,NULL,40720,1584,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:37','2022-10-11 00:32:37',NULL),(195,NULL,40720,1584,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:38','2022-10-11 00:32:38',NULL),(196,NULL,40720,1584,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:41','2022-10-11 00:32:41',NULL),(197,NULL,40720,1584,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:43','2022-10-11 00:32:43',NULL),(198,NULL,40720,1584,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:45','2022-10-11 00:32:45',NULL),(199,NULL,40720,1584,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:47','2022-10-11 00:32:47',NULL),(200,NULL,40720,1584,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:49','2022-10-11 00:32:49',NULL),(201,NULL,40720,1584,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:51','2022-10-11 00:32:51',NULL),(202,NULL,40720,1584,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:53','2022-10-11 00:32:53',NULL),(203,NULL,40720,1584,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:55','2022-10-11 00:32:55',NULL);
INSERT INTO `balance_libro` VALUES (204,NULL,40720,1584,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:32:58','2022-10-11 00:32:58',NULL),(205,NULL,40720,1584,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:00','2022-10-11 00:33:00',NULL),(206,NULL,40720,1584,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:02','2022-10-11 00:33:02',NULL),(207,NULL,40720,1584,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:04','2022-10-11 00:33:04',NULL),(208,NULL,40720,1584,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:06','2022-10-11 00:33:06',NULL),(209,NULL,40720,1584,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:08','2022-10-11 00:33:08',NULL),(210,NULL,40720,1584,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:11','2022-10-11 00:33:11',NULL),(211,NULL,40720,1584,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:13','2022-10-11 00:33:13',NULL),(212,NULL,40720,1584,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:15','2022-10-11 00:33:15',NULL),(213,NULL,40720,1584,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:17','2022-10-11 00:33:17',NULL),(214,NULL,40720,1584,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:19','2022-10-11 00:33:19',NULL),(215,NULL,40720,1584,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:21','2022-10-11 00:33:21',NULL),(216,NULL,40720,1584,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:23','2022-10-11 00:33:23',NULL),(217,NULL,40720,1584,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:25','2022-10-11 00:33:25',NULL),(218,NULL,40720,1584,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:27','2022-10-11 00:33:27',NULL),(219,NULL,40720,1584,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:29','2022-10-11 00:33:29',NULL),(220,NULL,40720,1584,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:31','2022-10-11 00:33:31',NULL),(221,NULL,40720,1584,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:34','2022-10-11 00:33:34',NULL),(222,NULL,40720,1584,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:36','2022-10-11 00:33:36',NULL),(223,NULL,40720,1584,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:38','2022-10-11 00:33:38',NULL),(224,NULL,40720,1584,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:40','2022-10-11 00:33:40',NULL),(225,NULL,40720,1584,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:42','2022-10-11 00:33:42',NULL),(226,NULL,40720,1584,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:45','2022-10-11 00:33:45',NULL),(227,NULL,40720,1584,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:47','2022-10-11 00:33:47',NULL),(228,NULL,40720,1584,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:49','2022-10-11 00:33:49',NULL);
INSERT INTO `balance_libro` VALUES (229,NULL,40720,1584,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:51','2022-10-11 00:33:51',NULL),(230,NULL,40720,1584,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:53','2022-10-11 00:33:53',NULL),(231,NULL,40720,1584,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:55','2022-10-11 00:33:55',NULL),(232,NULL,40720,1584,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:33:57','2022-10-11 00:33:57',NULL),(233,NULL,40720,1584,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:00','2022-10-11 00:34:00',NULL),(234,NULL,40720,1584,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:02','2022-10-11 00:34:02',NULL),(235,NULL,40720,1584,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:04','2022-10-11 00:34:04',NULL),(236,NULL,40720,1584,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:06','2022-10-11 00:34:06',NULL),(237,NULL,40720,1584,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:08','2022-10-11 00:34:08',NULL),(238,NULL,40720,1584,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:11','2022-10-11 00:34:11',NULL),(239,NULL,40720,1584,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:13','2022-10-11 00:34:13',NULL),(240,NULL,40720,1584,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:15','2022-10-11 00:34:15',NULL),(241,NULL,40720,1584,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:17','2022-10-11 00:34:17',NULL),(242,NULL,40720,1584,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:19','2022-10-11 00:34:19',NULL),(243,NULL,40720,1584,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:21','2022-10-11 00:34:21',NULL),(244,NULL,40720,1584,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:23','2022-10-11 00:34:23',NULL),(245,NULL,40720,1584,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:26','2022-10-11 00:34:26',NULL),(246,NULL,40720,1584,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:28','2022-10-11 00:34:28',NULL),(247,NULL,40720,1584,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:30','2022-10-11 00:34:30',NULL),(248,NULL,40720,1584,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:32','2022-10-11 00:34:32',NULL),(249,NULL,40720,1584,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:34','2022-10-11 00:34:34',NULL),(250,NULL,40720,1584,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:36','2022-10-11 00:34:36',NULL),(251,NULL,40720,1584,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:38','2022-10-11 00:34:38',NULL),(252,NULL,40720,1584,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:41','2022-10-11 00:34:41',NULL),(253,NULL,40720,1584,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:43','2022-10-11 00:34:43',NULL);
INSERT INTO `balance_libro` VALUES (254,NULL,40720,1584,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:45','2022-10-11 00:34:45',NULL),(255,NULL,40720,1584,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:48','2022-10-11 00:34:48',NULL),(256,NULL,40720,1584,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:50','2022-10-11 00:34:50',NULL),(257,NULL,40720,1584,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:52','2022-10-11 00:34:52',NULL),(258,NULL,40720,1584,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:54','2022-10-11 00:34:54',NULL),(259,NULL,40720,1584,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:56','2022-10-11 00:34:56',NULL),(260,NULL,40720,1584,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:34:58','2022-10-11 00:34:58',NULL),(261,NULL,40720,1584,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:00','2022-10-11 00:35:00',NULL),(262,NULL,40720,1584,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:03','2022-10-11 00:35:03',NULL),(263,NULL,40720,1584,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:05','2022-10-11 00:35:05',NULL),(264,NULL,40720,1584,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:07','2022-10-11 00:35:07',NULL),(265,NULL,40720,1584,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:10','2022-10-11 00:35:10',NULL),(266,NULL,40720,1584,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:12','2022-10-11 00:35:12',NULL),(267,NULL,40720,1584,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:14','2022-10-11 00:35:14',NULL),(268,NULL,40720,1584,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:16','2022-10-11 00:35:16',NULL),(269,NULL,40720,1584,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:18','2022-10-11 00:35:18',NULL),(270,NULL,40720,1584,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:20','2022-10-11 00:35:20',NULL),(271,NULL,40720,1584,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:23','2022-10-11 00:35:23',NULL),(272,NULL,40720,1584,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:25','2022-10-11 00:35:25',NULL),(273,NULL,40720,1584,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:27','2022-10-11 00:35:27',NULL),(274,NULL,40720,1584,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:29','2022-10-11 00:35:29',NULL),(275,NULL,40720,1584,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:31','2022-10-11 00:35:31',NULL),(276,NULL,40720,1584,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:34','2022-10-11 00:35:34',NULL),(277,NULL,40720,1584,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:37','2022-10-11 00:35:37',NULL),(278,NULL,40720,1584,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:39','2022-10-11 00:35:39',NULL);
INSERT INTO `balance_libro` VALUES (279,NULL,40720,1584,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:41','2022-10-11 00:35:41',NULL),(280,NULL,40720,1584,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:43','2022-10-11 00:35:43',NULL),(281,NULL,40720,1584,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:45','2022-10-11 00:35:45',NULL),(282,NULL,40720,1584,2,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:48','2022-10-11 00:35:48',NULL),(283,NULL,40720,1584,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:50','2022-10-11 00:35:50',NULL),(284,NULL,40720,1584,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:52','2022-10-11 00:35:52',NULL),(285,NULL,40720,1584,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:54','2022-10-11 00:35:54',NULL),(286,NULL,40720,1584,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:56','2022-10-11 00:35:56',NULL),(287,NULL,40720,1584,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:35:59','2022-10-11 00:35:59',NULL),(288,NULL,40720,1584,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:01','2022-10-11 00:36:01',NULL),(289,NULL,40720,1584,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:04','2022-10-11 00:36:04',NULL),(290,NULL,40720,1584,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:06','2022-10-11 00:36:06',NULL),(291,NULL,40720,1584,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:08','2022-10-11 00:36:08',NULL),(292,NULL,40720,1584,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:10','2022-10-11 00:36:10',NULL),(293,NULL,40720,1584,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:13','2022-10-11 00:36:13',NULL),(294,NULL,40720,1584,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:15','2022-10-11 00:36:15',NULL),(295,NULL,40720,1584,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:17','2022-10-11 00:36:17',NULL),(296,NULL,40720,1584,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:19','2022-10-11 00:36:19',NULL),(297,NULL,40720,1584,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:21','2022-10-11 00:36:21',NULL),(298,NULL,40720,1584,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:24','2022-10-11 00:36:24',NULL),(299,NULL,40720,1584,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:26','2022-10-11 00:36:26',NULL),(300,NULL,40720,1584,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:29','2022-10-11 00:36:29',NULL),(301,NULL,40720,1584,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:31','2022-10-11 00:36:31',NULL),(302,NULL,40720,1584,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:33','2022-10-11 00:36:33',NULL),(303,NULL,40720,1584,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:35','2022-10-11 00:36:35',NULL);
INSERT INTO `balance_libro` VALUES (304,NULL,40720,1584,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:37','2022-10-11 00:36:37',NULL),(305,NULL,40720,1584,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:40','2022-10-11 00:36:40',NULL),(306,NULL,40720,1584,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:42','2022-10-11 00:36:42',NULL),(307,NULL,40720,1584,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:44','2022-10-11 00:36:44',NULL),(308,NULL,40720,1584,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:46','2022-10-11 00:36:46',NULL),(309,NULL,40720,1584,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:48','2022-10-11 00:36:48',NULL),(310,NULL,40720,1584,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:50','2022-10-11 00:36:50',NULL),(311,NULL,40720,1584,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:52','2022-10-11 00:36:52',NULL),(312,NULL,40720,1584,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:54','2022-10-11 00:36:54',NULL),(313,NULL,40720,1584,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:57','2022-10-11 00:36:57',NULL),(314,NULL,40720,1584,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:36:59','2022-10-11 00:36:59',NULL),(315,NULL,40720,1584,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:37:02','2022-10-11 00:37:02',NULL),(316,NULL,40720,1584,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:37:04','2022-10-11 00:37:04',NULL),(317,NULL,40720,1584,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',0.00,NULL,NULL,1,'2022-10-11 00:37:06','2022-10-11 00:37:06',NULL),(318,NULL,40720,1584,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',35.00,NULL,NULL,1,'2022-10-11 00:45:14','2022-10-11 00:45:14',NULL),(319,NULL,40720,1584,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',610.00,NULL,NULL,1,'2022-10-11 00:45:16','2022-10-11 00:45:16',NULL),(320,NULL,40720,1584,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:45:18','2022-10-11 00:45:18',NULL),(321,NULL,40720,1584,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',330.00,NULL,NULL,1,'2022-10-11 00:45:20','2022-10-11 00:45:20',NULL),(322,NULL,40720,1584,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',900.00,NULL,NULL,1,'2022-10-11 00:45:23','2022-10-11 00:45:23',NULL),(323,NULL,40720,1584,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',370.00,NULL,NULL,1,'2022-10-11 00:45:25','2022-10-11 00:45:25',NULL),(324,NULL,40720,1584,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:45:27','2022-10-11 00:45:27',NULL),(325,NULL,40720,1584,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:45:29','2022-10-11 00:45:29',NULL),(326,NULL,40720,1584,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:45:31','2022-10-11 00:45:31',NULL),(327,NULL,40720,1584,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:45:33','2022-10-11 00:45:33',NULL),(328,NULL,40720,1584,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',100.00,NULL,NULL,1,'2022-10-11 00:45:36','2022-10-11 00:45:36',NULL);
INSERT INTO `balance_libro` VALUES (329,NULL,40720,1584,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:45:38','2022-10-11 00:45:38',NULL),(330,NULL,40720,1584,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',380.00,NULL,NULL,1,'2022-10-11 00:45:40','2022-10-11 00:45:40',NULL),(331,NULL,40720,1584,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:45:42','2022-10-11 00:45:42',NULL),(332,NULL,40720,1584,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:45:44','2022-10-11 00:45:44',NULL),(333,NULL,40720,1584,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:45:46','2022-10-11 00:45:46',NULL),(334,NULL,40720,1584,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',170.00,NULL,NULL,1,'2022-10-11 00:45:48','2022-10-11 00:45:48',NULL),(335,NULL,40720,1584,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',650.00,NULL,NULL,1,'2022-10-11 00:45:51','2022-10-11 00:45:51',NULL),(336,NULL,40720,1584,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:45:53','2022-10-11 00:45:53',NULL),(337,NULL,40720,1584,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:45:55','2022-10-11 00:45:55',NULL),(338,NULL,40720,1584,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',370.00,NULL,NULL,1,'2022-10-11 00:45:57','2022-10-11 00:45:57',NULL),(339,NULL,40720,1584,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',90.00,NULL,NULL,1,'2022-10-11 00:46:00','2022-10-11 00:46:00',NULL),(340,NULL,40720,1584,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',410.00,NULL,NULL,1,'2022-10-11 00:46:02','2022-10-11 00:46:02',NULL),(341,NULL,40720,1584,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',100.00,NULL,NULL,1,'2022-10-11 00:46:05','2022-10-11 00:46:05',NULL),(342,NULL,40720,1584,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',850.00,NULL,NULL,1,'2022-10-11 00:46:07','2022-10-11 00:46:07',NULL),(343,NULL,40720,1584,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',470.00,NULL,NULL,1,'2022-10-11 00:46:09','2022-10-11 00:46:09',NULL),(344,NULL,40720,1584,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200.00,NULL,NULL,1,'2022-10-11 00:46:11','2022-10-11 00:46:11',NULL),(345,NULL,40720,1584,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',190.00,NULL,NULL,1,'2022-10-11 00:46:13','2022-10-11 00:46:13',NULL),(346,NULL,40720,1584,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:46:16','2022-10-11 00:46:16',NULL),(347,NULL,40720,1584,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:46:18','2022-10-11 00:46:18',NULL),(348,NULL,40720,1584,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',990.00,NULL,NULL,1,'2022-10-11 00:46:20','2022-10-11 00:46:20',NULL),(349,NULL,40720,1584,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',230.00,NULL,NULL,1,'2022-10-11 00:46:23','2022-10-11 00:46:23',NULL),(350,NULL,40720,1584,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',60.00,NULL,NULL,1,'2022-10-11 00:46:25','2022-10-11 00:46:25',NULL),(351,NULL,40720,1584,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',310.00,NULL,NULL,1,'2022-10-11 00:46:27','2022-10-11 00:46:27',NULL),(352,NULL,40720,1584,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',270.00,NULL,NULL,1,'2022-10-11 00:46:29','2022-10-11 00:46:29',NULL),(353,NULL,40720,1584,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:46:32','2022-10-11 00:46:32',NULL);
INSERT INTO `balance_libro` VALUES (354,NULL,40720,1584,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:46:34','2022-10-11 00:46:34',NULL),(355,NULL,40720,1584,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',150.00,NULL,NULL,1,'2022-10-11 00:46:36','2022-10-11 00:46:36',NULL),(356,NULL,40720,1584,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:46:39','2022-10-11 00:46:39',NULL),(357,NULL,40720,1584,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',450.00,NULL,NULL,1,'2022-10-11 00:46:41','2022-10-11 00:46:41',NULL),(358,NULL,40720,1584,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',550.00,NULL,NULL,1,'2022-10-11 00:46:43','2022-10-11 00:46:43',NULL),(359,NULL,40720,1584,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',330.00,NULL,NULL,1,'2022-10-11 00:46:46','2022-10-11 00:46:46',NULL),(360,NULL,40720,1584,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:46:48','2022-10-11 00:46:48',NULL),(361,NULL,40720,1584,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:46:51','2022-10-11 00:46:51',NULL),(362,NULL,40720,1584,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',720.00,NULL,NULL,1,'2022-10-11 00:46:53','2022-10-11 00:46:53',NULL),(363,NULL,40720,1584,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',180.00,NULL,NULL,1,'2022-10-11 00:46:56','2022-10-11 00:46:56',NULL),(364,NULL,40720,1584,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:46:58','2022-10-11 00:46:58',NULL),(365,NULL,40720,1584,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',790.00,NULL,NULL,1,'2022-10-11 00:47:01','2022-10-11 00:47:01',NULL),(366,NULL,40720,1584,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:47:03','2022-10-11 00:47:03',NULL),(367,NULL,40720,1584,2,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:47:06','2022-10-11 00:47:06',NULL),(368,NULL,40720,1584,2,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:47:08','2022-10-11 00:47:08',NULL),(369,NULL,40720,1584,2,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',850.00,NULL,NULL,1,'2022-10-11 00:47:10','2022-10-11 00:47:10',NULL),(370,NULL,40720,1584,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2600.00,NULL,NULL,1,'2022-10-11 00:47:13','2022-10-11 00:47:13',NULL),(371,NULL,40720,1584,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:47:15','2022-10-11 00:47:15',NULL),(372,NULL,40720,1584,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:47:17','2022-10-11 00:47:17',NULL),(373,NULL,40720,1584,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:47:20','2022-10-11 00:47:20',NULL),(374,NULL,40720,1584,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:47:22','2022-10-11 00:47:22',NULL),(375,NULL,40720,1584,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1580.00,NULL,NULL,1,'2022-10-11 00:47:25','2022-10-11 00:47:25',NULL),(376,NULL,40720,1584,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:47:27','2022-10-11 00:47:27',NULL),(377,NULL,40720,1584,2,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:47:29','2022-10-11 00:47:29',NULL),(378,NULL,40720,1584,2,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',480.00,NULL,NULL,1,'2022-10-11 00:47:31','2022-10-11 00:47:31',NULL);
INSERT INTO `balance_libro` VALUES (379,NULL,40720,1584,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',530.00,NULL,NULL,1,'2022-10-11 00:47:34','2022-10-11 00:47:34',NULL),(380,NULL,40720,1584,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',550.00,NULL,NULL,1,'2022-10-11 00:47:36','2022-10-11 00:47:36',NULL),(381,NULL,40720,1584,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:47:38','2022-10-11 00:47:38',NULL),(382,NULL,40720,1584,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:47:40','2022-10-11 00:47:40',NULL),(383,NULL,40720,1584,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200.00,NULL,NULL,1,'2022-10-11 00:47:43','2022-10-11 00:47:43',NULL),(384,NULL,40720,1584,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',820.00,NULL,NULL,1,'2022-10-11 00:47:45','2022-10-11 00:47:45',NULL),(385,NULL,40720,1584,2,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',650.00,NULL,NULL,1,'2022-10-11 00:47:47','2022-10-11 00:47:47',NULL),(386,NULL,40720,1584,2,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:47:49','2022-10-11 00:47:49',NULL),(387,NULL,40720,1584,2,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',630.00,NULL,NULL,1,'2022-10-11 00:47:51','2022-10-11 00:47:51',NULL),(388,NULL,40720,1584,2,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',100.00,NULL,NULL,1,'2022-10-11 00:47:54','2022-10-11 00:47:54',NULL),(389,NULL,40720,1584,2,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',170.00,NULL,NULL,1,'2022-10-11 00:47:56','2022-10-11 00:47:56',NULL),(390,NULL,40720,1584,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',330.00,NULL,NULL,1,'2022-10-11 00:47:59','2022-10-11 00:47:59',NULL),(391,NULL,40720,1584,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:48:01','2022-10-11 00:48:01',NULL),(392,NULL,40720,1584,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:48:03','2022-10-11 00:48:03',NULL),(393,NULL,40720,1584,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200.00,NULL,NULL,1,'2022-10-11 00:48:06','2022-10-11 00:48:06',NULL),(394,NULL,40720,1584,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',180.00,NULL,NULL,1,'2022-10-11 00:48:08','2022-10-11 00:48:08',NULL),(395,NULL,40720,1584,2,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',140.00,NULL,NULL,1,'2022-10-11 00:48:10','2022-10-11 00:48:10',NULL),(396,NULL,40720,1584,2,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:48:13','2022-10-11 00:48:13',NULL),(397,NULL,40720,1584,2,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',670.00,NULL,NULL,1,'2022-10-11 00:48:15','2022-10-11 00:48:15',NULL),(398,NULL,40720,1584,2,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',800.00,NULL,NULL,1,'2022-10-11 00:48:17','2022-10-11 00:48:17',NULL),(399,NULL,40720,1584,2,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',170.00,NULL,NULL,1,'2022-10-11 00:48:20','2022-10-11 00:48:20',NULL),(400,NULL,40720,1584,2,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:48:22','2022-10-11 00:48:22',NULL),(401,NULL,40720,1584,2,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:48:25','2022-10-11 00:48:25',NULL),(402,NULL,40720,1584,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',140.00,NULL,NULL,1,'2022-10-11 00:48:27','2022-10-11 00:48:27',NULL),(403,NULL,40720,1584,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',150.00,NULL,NULL,1,'2022-10-11 00:48:29','2022-10-11 00:48:29',NULL);
INSERT INTO `balance_libro` VALUES (404,NULL,40720,1584,2,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:48:31','2022-10-11 00:48:31',NULL),(405,NULL,40720,1584,2,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',470.00,NULL,NULL,1,'2022-10-11 00:48:33','2022-10-11 00:48:33',NULL),(406,NULL,40720,1584,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',670.00,NULL,NULL,1,'2022-10-11 00:48:35','2022-10-11 00:48:35',NULL),(407,NULL,40720,1584,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',160.00,NULL,NULL,1,'2022-10-11 00:48:38','2022-10-11 00:48:38',NULL),(408,NULL,40720,1584,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',250.00,NULL,NULL,1,'2022-10-11 00:48:40','2022-10-11 00:48:40',NULL),(409,NULL,40720,1584,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',440.00,NULL,NULL,1,'2022-10-11 00:48:42','2022-10-11 00:48:42',NULL),(410,NULL,40720,1584,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:48:45','2022-10-11 00:48:45',NULL),(411,NULL,40720,1584,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:48:47','2022-10-11 00:48:47',NULL),(412,NULL,40720,1584,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',460.00,NULL,NULL,1,'2022-10-11 00:48:49','2022-10-11 00:48:49',NULL),(413,NULL,40720,1584,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',480.00,NULL,NULL,1,'2022-10-11 00:48:51','2022-10-11 00:48:51',NULL),(414,NULL,40720,1584,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',450.00,NULL,NULL,1,'2022-10-11 00:48:54','2022-10-11 00:48:54',NULL),(415,NULL,40720,1584,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',330.00,NULL,NULL,1,'2022-10-11 00:48:56','2022-10-11 00:48:56',NULL),(416,NULL,40720,1584,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:48:58','2022-10-11 00:48:58',NULL),(417,NULL,40720,1584,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',470.00,NULL,NULL,1,'2022-10-11 00:49:00','2022-10-11 00:49:00',NULL),(418,NULL,40720,1584,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',500.00,NULL,NULL,1,'2022-10-11 00:49:03','2022-10-11 00:49:03',NULL),(419,NULL,40720,1584,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-10-11 00:49:05','2022-10-11 00:49:05',NULL),(420,NULL,40720,1584,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',500.00,NULL,NULL,1,'2022-10-11 00:49:08','2022-10-11 00:49:08',NULL),(421,NULL,40720,1584,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:49:10','2022-10-11 00:49:10',NULL),(422,NULL,40720,1584,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1640.00,NULL,NULL,1,'2022-10-11 00:49:12','2022-10-11 00:49:12',NULL),(423,NULL,40720,1584,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',390.00,NULL,NULL,1,'2022-10-11 00:49:15','2022-10-11 00:49:15',NULL),(424,NULL,40720,1584,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:49:17','2022-10-11 00:49:17',NULL),(425,NULL,40720,1584,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',140.00,NULL,NULL,1,'2022-10-11 00:49:19','2022-10-11 00:49:19',NULL),(426,NULL,40720,1584,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',770.00,NULL,NULL,1,'2022-10-11 00:49:22','2022-10-11 00:49:22',NULL),(427,NULL,40720,1584,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:49:24','2022-10-11 00:49:24',NULL),(428,NULL,40720,1584,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',440.00,NULL,NULL,1,'2022-10-11 00:49:26','2022-10-11 00:49:26',NULL);
INSERT INTO `balance_libro` VALUES (429,NULL,40720,1584,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',170.00,NULL,NULL,1,'2022-10-11 00:49:29','2022-10-11 00:49:29',NULL),(430,NULL,40720,1584,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:49:31','2022-10-11 00:49:31',NULL),(431,NULL,40720,1584,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:49:33','2022-10-11 00:49:33',NULL),(432,NULL,40720,1584,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',290.00,NULL,NULL,1,'2022-10-11 00:49:36','2022-10-11 00:49:36',NULL),(433,NULL,40720,1584,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-10-11 00:49:38','2022-10-11 00:49:38',NULL),(434,NULL,40720,1584,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',270.00,NULL,NULL,1,'2022-10-11 00:49:40','2022-10-11 00:49:40',NULL),(435,NULL,40720,1584,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:49:44','2022-10-11 00:49:44',NULL),(436,NULL,40720,1584,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',180.00,NULL,NULL,1,'2022-10-11 00:49:46','2022-10-11 00:49:46',NULL),(437,NULL,40720,1584,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',250.00,NULL,NULL,1,'2022-10-11 00:49:49','2022-10-11 00:49:49',NULL),(438,NULL,40720,1584,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',50.00,NULL,NULL,1,'2022-10-11 00:49:51','2022-10-11 00:49:51',NULL),(439,NULL,40720,1584,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',540.00,NULL,NULL,1,'2022-10-11 00:49:53','2022-10-11 00:49:53',NULL),(440,NULL,40720,1584,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:49:56','2022-10-11 00:49:56',NULL),(441,NULL,40720,1584,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:49:58','2022-10-11 00:49:58',NULL),(442,NULL,40720,1584,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',540.00,NULL,NULL,1,'2022-10-11 00:50:01','2022-10-11 00:50:01',NULL),(443,NULL,40720,1584,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:50:03','2022-10-11 00:50:03',NULL),(444,NULL,40720,1584,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',740.00,NULL,NULL,1,'2022-10-11 00:50:05','2022-10-11 00:50:05',NULL),(445,NULL,40720,1584,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',340.00,NULL,NULL,1,'2022-10-11 00:50:08','2022-10-11 00:50:08',NULL),(446,NULL,40720,1584,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:50:11','2022-10-11 00:50:11',NULL),(447,NULL,40720,1584,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',270.00,NULL,NULL,1,'2022-10-11 00:50:13','2022-10-11 00:50:13',NULL),(448,NULL,40720,1584,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:50:15','2022-10-11 00:50:15',NULL),(449,NULL,40720,1584,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-10-11 00:50:18','2022-10-11 00:50:18',NULL),(450,NULL,40720,1584,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:50:20','2022-10-11 00:50:20',NULL),(451,NULL,40720,1584,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',250.00,NULL,NULL,1,'2022-10-11 00:50:22','2022-10-11 00:50:22',NULL),(452,NULL,40720,1584,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:50:25','2022-10-11 00:50:25',NULL),(453,NULL,40720,1584,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',570.00,NULL,NULL,1,'2022-10-11 00:50:27','2022-10-11 00:50:27',NULL);
INSERT INTO `balance_libro` VALUES (454,NULL,40720,1584,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',660.00,NULL,NULL,1,'2022-10-11 00:50:30','2022-10-11 00:50:30',NULL),(455,NULL,40720,1584,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:50:32','2022-10-11 00:50:32',NULL),(456,NULL,40720,1584,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',550.00,NULL,NULL,1,'2022-10-11 00:50:35','2022-10-11 00:50:35',NULL),(457,NULL,40720,1584,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',560.00,NULL,NULL,1,'2022-10-11 00:50:37','2022-10-11 00:50:37',NULL),(458,NULL,40720,1584,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',460.00,NULL,NULL,1,'2022-10-11 00:50:40','2022-10-11 00:50:40',NULL),(459,NULL,40720,1584,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:50:42','2022-10-11 00:50:42',NULL),(460,NULL,40720,1584,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',900.00,NULL,NULL,1,'2022-10-11 00:50:45','2022-10-11 00:50:45',NULL),(461,NULL,40720,1584,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',140.00,NULL,NULL,1,'2022-10-11 00:50:47','2022-10-11 00:50:47',NULL),(462,NULL,40720,1584,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',270.00,NULL,NULL,1,'2022-10-11 00:50:49','2022-10-11 00:50:49',NULL),(463,NULL,40720,1584,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',580.00,NULL,NULL,1,'2022-10-11 00:50:52','2022-10-11 00:50:52',NULL),(464,NULL,40720,1584,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',380.00,NULL,NULL,1,'2022-10-11 00:50:55','2022-10-11 00:50:55',NULL),(465,NULL,40720,1584,2,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',460.00,NULL,NULL,1,'2022-10-11 00:50:57','2022-10-11 00:50:57',NULL),(466,NULL,40720,1584,2,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:51:00','2022-10-11 00:51:00',NULL),(467,NULL,40720,1584,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2120.00,NULL,NULL,1,'2022-10-11 00:51:03','2022-10-11 00:51:03',NULL),(468,NULL,40720,1584,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',90.00,NULL,NULL,1,'2022-10-11 00:51:06','2022-10-11 00:51:06',NULL),(469,NULL,40720,1584,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',900.00,NULL,NULL,1,'2022-10-11 00:51:09','2022-10-11 00:51:09',NULL),(470,NULL,40720,1584,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:51:11','2022-10-11 00:51:11',NULL),(471,NULL,40720,1584,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',270.00,NULL,NULL,1,'2022-10-11 00:51:14','2022-10-11 00:51:14',NULL),(472,NULL,40720,1584,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',390.00,NULL,NULL,1,'2022-10-11 00:51:16','2022-10-11 00:51:16',NULL),(473,NULL,40720,1584,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',900.00,NULL,NULL,1,'2022-10-11 00:51:19','2022-10-11 00:51:19',NULL),(474,NULL,40720,1584,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',730.00,NULL,NULL,1,'2022-10-11 00:51:21','2022-10-11 00:51:21',NULL),(475,NULL,40720,1584,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',100.00,NULL,NULL,1,'2022-10-11 00:51:24','2022-10-11 00:51:24',NULL),(476,NULL,40720,1584,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',630.00,NULL,NULL,1,'2022-10-11 00:51:26','2022-10-11 00:51:26',NULL),(477,NULL,40720,1584,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:51:29','2022-10-11 00:51:29',NULL),(478,NULL,40720,1584,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',550.00,NULL,NULL,1,'2022-10-11 00:51:31','2022-10-11 00:51:31',NULL);
INSERT INTO `balance_libro` VALUES (479,NULL,40720,1584,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',270.00,NULL,NULL,1,'2022-10-11 00:51:34','2022-10-11 00:51:34',NULL),(480,NULL,40720,1584,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',500.00,NULL,NULL,1,'2022-10-11 00:51:36','2022-10-11 00:51:36',NULL),(481,NULL,40720,1584,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',250.00,NULL,NULL,1,'2022-10-11 00:51:39','2022-10-11 00:51:39',NULL),(482,NULL,40720,1584,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',170.00,NULL,NULL,1,'2022-10-11 00:51:41','2022-10-11 00:51:41',NULL),(483,NULL,40720,1584,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',650.00,NULL,NULL,1,'2022-10-11 00:51:44','2022-10-11 00:51:44',NULL),(484,NULL,40720,1584,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:51:46','2022-10-11 00:51:46',NULL),(485,NULL,40720,1584,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-10-11 00:51:49','2022-10-11 00:51:49',NULL),(486,NULL,40720,1584,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:51:51','2022-10-11 00:51:51',NULL),(487,NULL,40720,1584,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:51:54','2022-10-11 00:51:54',NULL),(488,NULL,40720,1584,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',490.00,NULL,NULL,1,'2022-10-11 00:51:56','2022-10-11 00:51:56',NULL),(489,NULL,40720,1584,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:51:59','2022-10-11 00:51:59',NULL),(490,NULL,40720,1584,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',290.00,NULL,NULL,1,'2022-10-11 00:52:01','2022-10-11 00:52:01',NULL),(491,NULL,40720,1584,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:52:04','2022-10-11 00:52:04',NULL),(492,NULL,40720,1584,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:52:06','2022-10-11 00:52:06',NULL),(493,NULL,40720,1584,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',460.00,NULL,NULL,1,'2022-10-11 00:52:09','2022-10-11 00:52:09',NULL),(494,NULL,40720,1584,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:52:11','2022-10-11 00:52:11',NULL),(495,NULL,40720,1584,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:52:13','2022-10-11 00:52:13',NULL),(496,NULL,40720,1584,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:52:16','2022-10-11 00:52:16',NULL),(497,NULL,40720,1584,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2600.00,NULL,NULL,1,'2022-10-11 00:52:18','2022-10-11 00:52:18',NULL),(498,NULL,40720,1584,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',170.00,NULL,NULL,1,'2022-10-11 00:52:21','2022-10-11 00:52:21',NULL),(499,NULL,40720,1584,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1090.00,NULL,NULL,1,'2022-10-11 00:52:23','2022-10-11 00:52:23',NULL),(500,NULL,40720,1584,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:52:26','2022-10-11 00:52:26',NULL),(501,NULL,40720,1584,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',630.00,NULL,NULL,1,'2022-10-11 00:52:28','2022-10-11 00:52:28',NULL),(502,NULL,40720,1584,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',580.00,NULL,NULL,1,'2022-10-11 00:52:30','2022-10-11 00:52:30',NULL),(503,NULL,40720,1584,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',360.00,NULL,NULL,1,'2022-10-11 00:52:33','2022-10-11 00:52:33',NULL);
INSERT INTO `balance_libro` VALUES (504,NULL,40720,1584,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',540.00,NULL,NULL,1,'2022-10-11 00:52:36','2022-10-11 00:52:36',NULL),(505,NULL,40720,1584,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:52:39','2022-10-11 00:52:39',NULL),(506,NULL,40720,1584,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',820.00,NULL,NULL,1,'2022-10-11 00:52:41','2022-10-11 00:52:41',NULL),(507,NULL,40720,1584,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1060.00,NULL,NULL,1,'2022-10-11 00:52:44','2022-10-11 00:52:44',NULL),(508,NULL,40720,1584,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:52:46','2022-10-11 00:52:46',NULL),(509,NULL,40720,1584,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',360.00,NULL,NULL,1,'2022-10-11 00:52:49','2022-10-11 00:52:49',NULL),(510,NULL,40720,1584,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',440.00,NULL,NULL,1,'2022-10-11 00:52:51','2022-10-11 00:52:51',NULL),(511,NULL,40720,1584,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:52:54','2022-10-11 00:52:54',NULL),(512,NULL,40720,1584,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',630.00,NULL,NULL,1,'2022-10-11 00:52:56','2022-10-11 00:52:56',NULL),(513,NULL,40720,1584,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:52:59','2022-10-11 00:52:59',NULL),(514,NULL,40720,1584,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:53:02','2022-10-11 00:53:02',NULL),(515,NULL,40720,1584,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:53:04','2022-10-11 00:53:04',NULL),(516,NULL,40720,1584,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1700.00,NULL,NULL,1,'2022-10-11 00:53:07','2022-10-11 00:53:07',NULL),(517,NULL,40720,1584,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',290.00,NULL,NULL,1,'2022-10-11 00:53:10','2022-10-11 00:53:10',NULL),(518,NULL,40720,1584,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200.00,NULL,NULL,1,'2022-10-11 00:53:12','2022-10-11 00:53:12',NULL),(519,NULL,40720,1584,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',670.00,NULL,NULL,1,'2022-10-11 00:53:15','2022-10-11 00:53:15',NULL),(520,NULL,40720,1584,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',140.00,NULL,NULL,1,'2022-10-11 00:53:17','2022-10-11 00:53:17',NULL),(521,NULL,40720,1584,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',560.00,NULL,NULL,1,'2022-10-11 00:53:20','2022-10-11 00:53:20',NULL),(522,NULL,40720,1584,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-10-11 00:53:22','2022-10-11 00:53:22',NULL),(523,NULL,40720,1584,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',600.00,NULL,NULL,1,'2022-10-11 00:53:25','2022-10-11 00:53:25',NULL),(524,NULL,40720,1584,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',740.00,NULL,NULL,1,'2022-10-11 00:53:27','2022-10-11 00:53:27',NULL),(525,NULL,40720,1584,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:53:30','2022-10-11 00:53:30',NULL),(526,NULL,40720,1584,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:53:33','2022-10-11 00:53:33',NULL),(527,NULL,40720,1584,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:53:35','2022-10-11 00:53:35',NULL),(528,NULL,40720,1584,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',830.00,NULL,NULL,1,'2022-10-11 00:53:38','2022-10-11 00:53:38',NULL);
INSERT INTO `balance_libro` VALUES (529,NULL,40720,1584,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-10-11 00:53:40','2022-10-11 00:53:40',NULL),(530,NULL,40720,1584,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:53:43','2022-10-11 00:53:43',NULL),(531,NULL,40720,1584,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',90.00,NULL,NULL,1,'2022-10-11 00:53:45','2022-10-11 00:53:45',NULL),(532,NULL,40720,1584,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',350.00,NULL,NULL,1,'2022-10-11 00:53:48','2022-10-11 00:53:48',NULL),(533,NULL,40720,1584,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',640.00,NULL,NULL,1,'2022-10-11 00:53:50','2022-10-11 00:53:50',NULL),(534,NULL,40720,1584,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:53:53','2022-10-11 00:53:53',NULL),(535,NULL,40720,1584,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:53:56','2022-10-11 00:53:56',NULL),(536,NULL,40720,1584,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:53:58','2022-10-11 00:53:58',NULL),(537,NULL,40720,1584,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',840.00,NULL,NULL,1,'2022-10-11 00:54:00','2022-10-11 00:54:00',NULL),(538,NULL,40720,1584,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:54:03','2022-10-11 00:54:03',NULL),(539,NULL,40720,1584,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',600.00,NULL,NULL,1,'2022-10-11 00:54:06','2022-10-11 00:54:06',NULL),(540,NULL,40720,1584,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:54:08','2022-10-11 00:54:08',NULL),(541,NULL,40720,1584,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',290.00,NULL,NULL,1,'2022-10-11 00:54:10','2022-10-11 00:54:10',NULL),(542,NULL,40720,1584,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',180.00,NULL,NULL,1,'2022-10-11 00:54:13','2022-10-11 00:54:13',NULL),(543,NULL,40720,1584,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',530.00,NULL,NULL,1,'2022-10-11 00:54:16','2022-10-11 00:54:16',NULL),(544,NULL,40720,1584,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-10-11 00:54:18','2022-10-11 00:54:18',NULL),(545,NULL,40720,1584,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',90.00,NULL,NULL,1,'2022-10-11 00:54:20','2022-10-11 00:54:20',NULL),(546,NULL,40720,1584,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:54:23','2022-10-11 00:54:23',NULL),(547,NULL,40720,1584,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:54:25','2022-10-11 00:54:25',NULL),(548,NULL,40720,1584,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',140.00,NULL,NULL,1,'2022-10-11 00:54:28','2022-10-11 00:54:28',NULL),(549,NULL,40720,1584,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:54:30','2022-10-11 00:54:30',NULL),(550,NULL,40720,1584,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:54:33','2022-10-11 00:54:33',NULL),(551,NULL,40720,1584,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:54:35','2022-10-11 00:54:35',NULL),(552,NULL,40720,1584,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',540.00,NULL,NULL,1,'2022-10-11 00:54:38','2022-10-11 00:54:38',NULL),(553,NULL,40720,1584,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',540.00,NULL,NULL,1,'2022-10-11 00:54:41','2022-10-11 00:54:41',NULL);
INSERT INTO `balance_libro` VALUES (554,NULL,40720,1584,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-10-11 00:54:44','2022-10-11 00:54:44',NULL),(555,NULL,40720,1584,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:54:46','2022-10-11 00:54:46',NULL),(556,NULL,40720,1584,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',160.00,NULL,NULL,1,'2022-10-11 00:54:49','2022-10-11 00:54:49',NULL),(557,NULL,40720,1584,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',150.00,NULL,NULL,1,'2022-10-11 00:54:52','2022-10-11 00:54:52',NULL),(558,NULL,40720,1584,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-10-11 00:54:54','2022-10-11 00:54:54',NULL),(559,NULL,40720,1584,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:54:57','2022-10-11 00:54:57',NULL),(560,NULL,40720,1584,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:54:59','2022-10-11 00:54:59',NULL),(561,NULL,40720,1584,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',240.00,NULL,NULL,1,'2022-10-11 00:55:03','2022-10-11 00:55:03',NULL),(562,NULL,40720,1584,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',460.00,NULL,NULL,1,'2022-10-11 00:55:05','2022-10-11 00:55:05',NULL),(563,NULL,40720,1584,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',100.00,NULL,NULL,1,'2022-10-11 00:55:08','2022-10-11 00:55:08',NULL),(564,NULL,40720,1584,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',60.00,NULL,NULL,1,'2022-10-11 00:55:11','2022-10-11 00:55:11',NULL),(565,NULL,40720,1584,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',800.00,NULL,NULL,1,'2022-10-11 00:55:14','2022-10-11 00:55:14',NULL),(566,NULL,40720,1584,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',110.00,NULL,NULL,1,'2022-10-11 00:55:16','2022-10-11 00:55:16',NULL),(567,NULL,40720,1584,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',410.00,NULL,NULL,1,'2022-10-11 00:55:19','2022-10-11 00:55:19',NULL),(568,NULL,40720,1584,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:55:21','2022-10-11 00:55:21',NULL),(569,NULL,40720,1584,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',180.00,NULL,NULL,1,'2022-10-11 00:55:24','2022-10-11 00:55:24',NULL),(570,NULL,40720,1584,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',320.00,NULL,NULL,1,'2022-10-11 00:55:27','2022-10-11 00:55:27',NULL),(571,NULL,40720,1584,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',170.00,NULL,NULL,1,'2022-10-11 00:55:29','2022-10-11 00:55:29',NULL),(572,NULL,40720,1584,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:55:32','2022-10-11 00:55:32',NULL),(573,NULL,40720,1584,2,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:55:34','2022-10-11 00:55:34',NULL),(574,NULL,40720,1584,2,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:55:37','2022-10-11 00:55:37',NULL),(575,NULL,40720,1584,2,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:55:40','2022-10-11 00:55:40',NULL),(576,NULL,40720,1584,2,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:55:43','2022-10-11 00:55:43',NULL),(577,NULL,40720,1584,2,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:55:46','2022-10-11 00:55:46',NULL),(578,NULL,40720,1584,2,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',470.00,NULL,NULL,1,'2022-10-11 00:55:48','2022-10-11 00:55:48',NULL);
INSERT INTO `balance_libro` VALUES (579,NULL,40720,1584,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',680.00,NULL,NULL,1,'2022-10-11 00:55:51','2022-10-11 00:55:51',NULL),(580,NULL,40720,1584,2,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',380.00,NULL,NULL,1,'2022-10-11 00:55:54','2022-10-11 00:55:54',NULL),(581,NULL,40720,1584,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',550.00,NULL,NULL,1,'2022-10-11 00:55:57','2022-10-11 00:55:57',NULL),(582,NULL,40720,1584,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',410.00,NULL,NULL,1,'2022-10-11 00:55:59','2022-10-11 00:55:59',NULL),(583,NULL,40720,1584,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',370.00,NULL,NULL,1,'2022-10-11 00:56:02','2022-10-11 00:56:02',NULL),(584,NULL,40720,1584,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:56:05','2022-10-11 00:56:05',NULL),(585,NULL,40720,1584,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:56:08','2022-10-11 00:56:08',NULL),(586,NULL,40720,1584,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:56:11','2022-10-11 00:56:11',NULL),(587,NULL,40720,1584,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:56:14','2022-10-11 00:56:14',NULL),(588,NULL,40720,1584,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-10-11 00:56:16','2022-10-11 00:56:16',NULL),(589,NULL,40720,1584,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',480.00,NULL,NULL,1,'2022-10-11 00:56:19','2022-10-11 00:56:19',NULL),(590,NULL,40720,1584,2,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',410.00,NULL,NULL,1,'2022-10-11 00:56:22','2022-10-11 00:56:22',NULL),(591,NULL,40720,1584,2,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',860.00,NULL,NULL,1,'2022-10-11 00:56:25','2022-10-11 00:56:25',NULL),(592,NULL,40720,1584,2,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',150.00,NULL,NULL,1,'2022-10-11 00:56:27','2022-10-11 00:56:27',NULL),(593,NULL,40720,1584,2,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:56:30','2022-10-11 00:56:30',NULL),(594,NULL,40720,1584,2,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',180.00,NULL,NULL,1,'2022-10-11 00:56:33','2022-10-11 00:56:33',NULL),(595,NULL,40720,1584,2,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',40.00,NULL,NULL,1,'2022-10-11 00:56:36','2022-10-11 00:56:36',NULL),(596,NULL,40720,1584,2,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200.00,NULL,NULL,1,'2022-10-11 00:56:38','2022-10-11 00:56:38',NULL),(597,NULL,40720,1584,2,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',740.00,NULL,NULL,1,'2022-10-11 00:56:41','2022-10-11 00:56:41',NULL),(598,NULL,40720,1584,2,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1110.00,NULL,NULL,1,'2022-10-11 00:56:44','2022-10-11 00:56:44',NULL),(599,NULL,40720,1584,2,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',340.00,NULL,NULL,1,'2022-10-11 00:56:46','2022-10-11 00:56:46',NULL),(600,NULL,40720,1584,2,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200.00,NULL,NULL,1,'2022-10-11 00:56:49','2022-10-11 00:56:49',NULL),(601,NULL,40720,1584,2,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',590.00,NULL,NULL,1,'2022-10-11 00:56:52','2022-10-11 00:56:52',NULL),(602,NULL,40720,1584,2,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',360.00,NULL,NULL,1,'2022-10-11 00:56:55','2022-10-11 00:56:55',NULL),(603,NULL,40720,1584,2,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',140.00,NULL,NULL,1,'2022-10-11 00:56:57','2022-10-11 00:56:57',NULL);
INSERT INTO `balance_libro` VALUES (604,NULL,40720,1584,2,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',250.00,NULL,NULL,1,'2022-10-11 00:57:00','2022-10-11 00:57:00',NULL),(605,NULL,40720,1584,2,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',370.00,NULL,NULL,1,'2022-10-11 00:57:03','2022-10-11 00:57:03',NULL),(606,NULL,40720,1584,2,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',380.00,NULL,NULL,1,'2022-10-11 00:57:06','2022-10-11 00:57:06',NULL),(607,NULL,40720,1584,2,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:57:09','2022-10-11 00:57:09',NULL),(608,NULL,40720,1584,2,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:57:11','2022-10-11 00:57:11',NULL),(609,NULL,40720,1584,2,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',130.00,NULL,NULL,1,'2022-10-11 00:57:14','2022-10-11 00:57:14',NULL),(610,NULL,40720,1584,2,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',380.00,NULL,NULL,1,'2022-10-11 00:57:17','2022-10-11 00:57:17',NULL),(611,NULL,40720,1584,2,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:57:20','2022-10-11 00:57:20',NULL),(612,NULL,40720,1584,2,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:57:22','2022-10-11 00:57:22',NULL),(613,NULL,40720,1584,2,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',960.00,NULL,NULL,1,'2022-10-11 00:57:25','2022-10-11 00:57:25',NULL),(614,NULL,40720,1584,2,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',790.00,NULL,NULL,1,'2022-10-11 00:57:28','2022-10-11 00:57:28',NULL),(615,NULL,40720,1584,2,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',120.00,NULL,NULL,1,'2022-10-11 00:57:30','2022-10-11 00:57:30',NULL),(616,NULL,40720,1584,2,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',360.00,NULL,NULL,1,'2022-10-11 00:57:33','2022-10-11 00:57:33',NULL),(617,NULL,40720,1584,2,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200.00,NULL,NULL,1,'2022-10-11 00:57:36','2022-10-11 00:57:36',NULL),(618,NULL,40720,1584,2,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',660.00,NULL,NULL,1,'2022-10-11 00:57:39','2022-10-11 00:57:39',NULL),(619,NULL,40720,1584,2,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',350.00,NULL,NULL,1,'2022-10-11 00:57:42','2022-10-11 00:57:42',NULL),(620,NULL,40720,1584,2,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',80.00,NULL,NULL,1,'2022-10-11 00:57:45','2022-10-11 00:57:45',NULL),(621,NULL,40720,1584,2,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-10-11 00:57:47','2022-10-11 00:57:47',NULL),(622,NULL,40720,1584,2,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',560.00,NULL,NULL,1,'2022-10-11 00:57:50','2022-10-11 00:57:50',NULL),(623,NULL,40720,1584,2,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',390.00,NULL,NULL,1,'2022-10-11 00:57:53','2022-10-11 00:57:53',NULL),(624,NULL,40720,1584,2,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',500.00,NULL,NULL,1,'2022-10-11 00:57:55','2022-10-11 00:57:55',NULL),(625,NULL,40720,1584,2,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200.00,NULL,NULL,1,'2022-10-11 00:57:58','2022-10-11 00:57:58',NULL),(626,NULL,40720,1584,2,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',280.00,NULL,NULL,1,'2022-10-11 00:58:00','2022-10-11 00:58:00',NULL),(627,NULL,40720,1584,2,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',490.00,NULL,NULL,1,'2022-10-11 00:58:03','2022-10-11 00:58:03',NULL),(628,NULL,40720,1584,2,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:58:06','2022-10-11 00:58:06',NULL);
INSERT INTO `balance_libro` VALUES (629,NULL,40720,1584,2,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',440.00,NULL,NULL,1,'2022-10-11 00:58:09','2022-10-11 00:58:09',NULL),(630,NULL,40720,1584,2,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',480.00,NULL,NULL,1,'2022-10-11 00:58:12','2022-10-11 00:58:12',NULL),(631,NULL,40720,1584,2,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',860.00,NULL,NULL,1,'2022-10-11 00:58:14','2022-10-11 00:58:14',NULL),(632,NULL,40720,1584,2,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',90.00,NULL,NULL,1,'2022-10-11 00:58:17','2022-10-11 00:58:17',NULL),(633,NULL,40720,1584,2,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',220.00,NULL,NULL,1,'2022-10-11 00:58:20','2022-10-11 00:58:20',NULL),(634,NULL,40720,1584,2,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',630.00,NULL,NULL,1,'2022-10-22 11:27:25','2022-10-22 11:27:25',NULL),(635,NULL,40720,1584,2,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:27:28','2022-10-22 11:27:28',NULL),(636,NULL,40720,1584,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:27:30','2022-10-22 11:27:30',NULL),(637,NULL,40720,1584,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:27:32','2022-10-22 11:27:32',NULL),(638,NULL,40720,1584,2,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:27:35','2022-10-22 11:27:35',NULL),(639,NULL,40720,1584,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:27:37','2022-10-22 11:27:37',NULL),(640,NULL,40720,1584,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',760.00,NULL,NULL,1,'2022-10-22 11:27:40','2022-10-22 11:27:40',NULL),(641,NULL,40720,1584,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',570.00,NULL,NULL,1,'2022-10-22 11:27:43','2022-10-22 11:27:43',NULL),(642,NULL,40720,1584,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',620.00,NULL,NULL,1,'2022-10-22 11:27:45','2022-10-22 11:27:45',NULL),(643,NULL,40720,1584,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',390.00,NULL,NULL,1,'2022-10-22 11:27:48','2022-10-22 11:27:48',NULL),(644,NULL,40720,1584,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',50.00,NULL,NULL,1,'2022-10-22 11:27:50','2022-10-22 11:27:50',NULL),(645,NULL,40720,1584,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:27:53','2022-10-22 11:27:53',NULL),(646,NULL,40720,1584,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:27:55','2022-10-22 11:27:55',NULL),(647,NULL,40720,1584,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',620.00,NULL,NULL,1,'2022-10-22 11:27:58','2022-10-22 11:27:58',NULL),(648,NULL,40720,1584,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:28:00','2022-10-22 11:28:00',NULL),(649,NULL,40720,1584,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',280.00,NULL,NULL,1,'2022-10-22 11:28:03','2022-10-22 11:28:03',NULL),(650,NULL,40720,1584,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',280.00,NULL,NULL,1,'2022-10-22 11:28:06','2022-10-22 11:28:06',NULL),(651,NULL,40720,1584,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:28:08','2022-10-22 11:28:08',NULL),(652,NULL,40720,1584,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',840.00,NULL,NULL,1,'2022-10-22 11:28:12','2022-10-22 11:28:12',NULL),(653,NULL,40720,1584,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:28:15','2022-10-22 11:28:15',NULL);
INSERT INTO `balance_libro` VALUES (654,NULL,40720,1584,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',770.00,NULL,NULL,1,'2022-10-22 11:28:17','2022-10-22 11:28:17',NULL),(655,NULL,40720,1584,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',180.00,NULL,NULL,1,'2022-10-22 11:28:20','2022-10-22 11:28:20',NULL),(656,NULL,40720,1584,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:28:22','2022-10-22 11:28:22',NULL),(657,NULL,40720,1584,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',620.00,NULL,NULL,1,'2022-10-22 11:28:25','2022-10-22 11:28:25',NULL),(658,NULL,40720,1584,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-10-22 11:28:27','2022-10-22 11:28:27',NULL),(659,NULL,40720,1584,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',740.00,NULL,NULL,1,'2022-10-22 11:28:30','2022-10-22 11:28:30',NULL),(660,NULL,40720,1584,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',660.00,NULL,NULL,1,'2022-10-22 11:28:33','2022-10-22 11:28:33',NULL),(661,NULL,40720,1584,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',650.00,NULL,NULL,1,'2022-10-22 11:28:36','2022-10-22 11:28:36',NULL),(662,NULL,40720,1584,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-10-22 11:28:39','2022-10-22 11:28:39',NULL),(663,NULL,40720,1584,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',340.00,NULL,NULL,1,'2022-10-22 11:28:41','2022-10-22 11:28:41',NULL),(664,NULL,40720,1584,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',290.00,NULL,NULL,1,'2022-10-22 11:28:44','2022-10-22 11:28:44',NULL),(665,NULL,40720,1584,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',180.00,NULL,NULL,1,'2022-10-22 11:28:46','2022-10-22 11:28:46',NULL),(666,NULL,40720,1584,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-10-22 11:28:49','2022-10-22 11:28:49',NULL),(667,NULL,40720,1584,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',470.00,NULL,NULL,1,'2022-10-22 11:28:52','2022-10-22 11:28:52',NULL),(668,NULL,40720,1584,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:28:55','2022-10-22 11:28:55',NULL),(669,NULL,40720,1584,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:28:58','2022-10-22 11:28:58',NULL),(670,NULL,40720,1584,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',450.00,NULL,NULL,1,'2022-10-22 11:29:00','2022-10-22 11:29:00',NULL),(671,NULL,40720,1584,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',130.00,NULL,NULL,1,'2022-10-22 11:29:03','2022-10-22 11:29:03',NULL),(672,NULL,40720,1584,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',180.00,NULL,NULL,1,'2022-10-22 11:29:06','2022-10-22 11:29:06',NULL),(673,NULL,40720,1584,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',470.00,NULL,NULL,1,'2022-10-22 11:29:09','2022-10-22 11:29:09',NULL),(674,NULL,40720,1584,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-10-22 11:29:11','2022-10-22 11:29:11',NULL),(675,NULL,40720,1584,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1020.00,NULL,NULL,1,'2022-10-22 11:29:14','2022-10-22 11:29:14',NULL),(676,NULL,40720,1584,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',400.00,NULL,NULL,1,'2022-10-22 11:29:17','2022-10-22 11:29:17',NULL),(677,NULL,40720,1584,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:29:19','2022-10-22 11:29:19',NULL),(678,NULL,40720,1584,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',340.00,NULL,NULL,1,'2022-10-22 11:29:22','2022-10-22 11:29:22',NULL);
INSERT INTO `balance_libro` VALUES (679,NULL,40720,1584,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:29:24','2022-10-22 11:29:24',NULL),(680,NULL,40720,1584,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',380.00,NULL,NULL,1,'2022-10-22 11:29:27','2022-10-22 11:29:27',NULL),(681,NULL,40720,1584,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',380.00,NULL,NULL,1,'2022-10-22 11:29:30','2022-10-22 11:29:30',NULL),(682,NULL,40720,1584,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:29:32','2022-10-22 11:29:32',NULL),(683,NULL,40720,1584,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:29:35','2022-10-22 11:29:35',NULL),(684,NULL,40720,1584,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',380.00,NULL,NULL,1,'2022-10-22 11:29:38','2022-10-22 11:29:38',NULL),(685,NULL,40720,1584,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:29:41','2022-10-22 11:29:41',NULL),(686,NULL,40720,1584,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',40.00,NULL,NULL,1,'2022-10-22 11:29:44','2022-10-22 11:29:44',NULL),(687,NULL,40720,1584,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',20.00,NULL,NULL,1,'2022-10-22 11:29:46','2022-10-22 11:29:46',NULL),(688,NULL,40720,1584,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:29:49','2022-10-22 11:29:49',NULL),(689,NULL,40720,1584,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',890.00,NULL,NULL,1,'2022-10-22 11:29:52','2022-10-22 11:29:52',NULL),(690,NULL,40720,1584,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',130.00,NULL,NULL,1,'2022-10-22 11:29:54','2022-10-22 11:29:54',NULL),(691,NULL,40720,1584,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:29:57','2022-10-22 11:29:57',NULL),(692,NULL,40720,1584,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',420.00,NULL,NULL,1,'2022-10-22 11:30:00','2022-10-22 11:30:00',NULL),(693,NULL,40720,1584,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',180.00,NULL,NULL,1,'2022-10-22 11:30:03','2022-10-22 11:30:03',NULL),(694,NULL,40720,1584,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:30:06','2022-10-22 11:30:06',NULL),(695,NULL,40720,1584,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-10-22 11:30:09','2022-10-22 11:30:09',NULL),(696,NULL,40720,1584,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',420.00,NULL,NULL,1,'2022-10-22 11:30:11','2022-10-22 11:30:11',NULL),(697,NULL,40720,1584,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:30:14','2022-10-22 11:30:14',NULL),(698,NULL,40720,1584,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',470.00,NULL,NULL,1,'2022-10-22 11:30:16','2022-10-22 11:30:16',NULL),(699,NULL,40720,1584,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',520.00,NULL,NULL,1,'2022-10-22 11:30:19','2022-10-22 11:30:19',NULL),(700,NULL,40720,1584,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',720.00,NULL,NULL,1,'2022-10-22 11:30:22','2022-10-22 11:30:22',NULL),(701,NULL,40720,1584,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',400.00,NULL,NULL,1,'2022-10-22 11:30:24','2022-10-22 11:30:24',NULL),(702,NULL,40720,1584,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:30:27','2022-10-22 11:30:27',NULL),(703,NULL,40720,1584,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',860.00,NULL,NULL,1,'2022-10-22 11:30:30','2022-10-22 11:30:30',NULL);
INSERT INTO `balance_libro` VALUES (704,NULL,40720,1584,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:30:33','2022-10-22 11:30:33',NULL),(705,NULL,40720,1584,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',780.00,NULL,NULL,1,'2022-10-22 11:30:35','2022-10-22 11:30:35',NULL),(706,NULL,40720,1584,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',560.00,NULL,NULL,1,'2022-10-22 11:30:38','2022-10-22 11:30:38',NULL),(707,NULL,40720,1584,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-10-22 11:30:41','2022-10-22 11:30:41',NULL),(708,NULL,40720,1584,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:30:43','2022-10-22 11:30:43',NULL),(709,NULL,40720,1584,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',320.00,NULL,NULL,1,'2022-10-22 11:30:46','2022-10-22 11:30:46',NULL),(710,NULL,40720,1584,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',570.00,NULL,NULL,1,'2022-10-22 11:30:49','2022-10-22 11:30:49',NULL),(711,NULL,40720,1584,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',190.00,NULL,NULL,1,'2022-10-22 11:30:52','2022-10-22 11:30:52',NULL),(712,NULL,40720,1584,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',190.00,NULL,NULL,1,'2022-10-22 11:30:55','2022-10-22 11:30:55',NULL),(713,NULL,40720,1584,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:30:57','2022-10-22 11:30:57',NULL),(714,NULL,40720,1584,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:31:00','2022-10-22 11:31:00',NULL),(715,NULL,40720,1584,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',710.00,NULL,NULL,1,'2022-10-22 11:31:03','2022-10-22 11:31:03',NULL),(716,NULL,40720,1584,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',680.00,NULL,NULL,1,'2022-10-22 11:31:05','2022-10-22 11:31:05',NULL),(717,NULL,40720,1584,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:31:08','2022-10-22 11:31:08',NULL),(718,NULL,40720,1584,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',440.00,NULL,NULL,1,'2022-10-22 11:31:11','2022-10-22 11:31:11',NULL),(719,NULL,40720,1584,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:31:14','2022-10-22 11:31:14',NULL),(720,NULL,40720,1584,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:31:17','2022-10-22 11:31:17',NULL),(721,NULL,40720,1584,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',350.00,NULL,NULL,1,'2022-10-22 11:31:20','2022-10-22 11:31:20',NULL),(722,NULL,40720,1584,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:31:22','2022-10-22 11:31:22',NULL),(723,NULL,40720,1584,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',290.00,NULL,NULL,1,'2022-10-22 11:31:25','2022-10-22 11:31:25',NULL),(724,NULL,40720,1584,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',400.00,NULL,NULL,1,'2022-10-22 11:31:28','2022-10-22 11:31:28',NULL),(725,NULL,40720,1584,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',100.00,NULL,NULL,1,'2022-10-22 11:31:30','2022-10-22 11:31:30',NULL),(726,NULL,40720,1584,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',150.00,NULL,NULL,1,'2022-10-22 11:31:33','2022-10-22 11:31:33',NULL),(727,NULL,40720,1584,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',350.00,NULL,NULL,1,'2022-10-22 11:31:36','2022-10-22 11:31:36',NULL),(728,NULL,40720,1584,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',230.00,NULL,NULL,1,'2022-10-22 11:31:39','2022-10-22 11:31:39',NULL);
INSERT INTO `balance_libro` VALUES (729,NULL,40720,1584,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',690.00,NULL,NULL,1,'2022-10-22 11:31:42','2022-10-22 11:31:42',NULL),(730,NULL,40720,1584,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:31:44','2022-10-22 11:31:44',NULL),(731,NULL,40720,1584,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',310.00,NULL,NULL,1,'2022-10-22 11:31:47','2022-10-22 11:31:47',NULL),(732,NULL,40720,1584,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:31:50','2022-10-22 11:31:50',NULL),(733,NULL,40720,1584,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:31:53','2022-10-22 11:31:53',NULL),(734,NULL,40720,1584,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2720.00,NULL,NULL,1,'2022-10-22 11:31:55','2022-10-22 11:31:55',NULL),(735,NULL,40720,1584,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',550.00,NULL,NULL,1,'2022-10-22 11:31:59','2022-10-22 11:31:59',NULL),(736,NULL,40720,1584,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:32:01','2022-10-22 11:32:01',NULL),(737,NULL,40720,1584,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',550.00,NULL,NULL,1,'2022-10-22 11:32:04','2022-10-22 11:32:04',NULL),(738,NULL,40720,1584,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',440.00,NULL,NULL,1,'2022-10-22 11:32:07','2022-10-22 11:32:07',NULL),(739,NULL,40720,1584,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:32:10','2022-10-22 11:32:10',NULL),(740,NULL,40720,1584,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:32:12','2022-10-22 11:32:12',NULL),(741,NULL,40720,1584,2,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',560.00,NULL,NULL,1,'2022-10-22 11:32:15','2022-10-22 11:32:15',NULL),(742,NULL,40720,1584,2,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:32:18','2022-10-22 11:32:18',NULL),(743,NULL,40720,1584,2,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:32:21','2022-10-22 11:32:21',NULL),(744,NULL,40720,1584,2,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',290.00,NULL,NULL,1,'2022-10-22 11:32:23','2022-10-22 11:32:23',NULL),(745,NULL,40720,1584,2,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',740.00,NULL,NULL,1,'2022-10-22 11:32:26','2022-10-22 11:32:26',NULL),(746,NULL,40720,1584,2,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:32:29','2022-10-22 11:32:29',NULL),(747,NULL,40720,1584,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',570.00,NULL,NULL,1,'2022-10-22 11:32:31','2022-10-22 11:32:31',NULL),(748,NULL,40720,1584,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',670.00,NULL,NULL,1,'2022-10-22 11:32:34','2022-10-22 11:32:34',NULL),(749,NULL,40720,1584,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',470.00,NULL,NULL,1,'2022-10-22 11:32:37','2022-10-22 11:32:37',NULL),(750,NULL,40720,1584,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',720.00,NULL,NULL,1,'2022-10-22 11:32:40','2022-10-22 11:32:40',NULL),(751,NULL,40720,1584,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',450.00,NULL,NULL,1,'2022-10-22 11:32:43','2022-10-22 11:32:43',NULL),(752,NULL,40720,1584,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',250.00,NULL,NULL,1,'2022-10-22 11:32:46','2022-10-22 11:32:46',NULL),(753,NULL,40720,1584,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',990.00,NULL,NULL,1,'2022-10-22 11:32:48','2022-10-22 11:32:48',NULL);
INSERT INTO `balance_libro` VALUES (754,NULL,40720,1584,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1040.00,NULL,NULL,1,'2022-10-22 11:32:51','2022-10-22 11:32:51',NULL),(755,NULL,40720,1584,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:32:54','2022-10-22 11:32:54',NULL),(756,NULL,40720,1584,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:32:57','2022-10-22 11:32:57',NULL),(757,NULL,40720,1584,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',320.00,NULL,NULL,1,'2022-10-22 11:32:59','2022-10-22 11:32:59',NULL),(758,NULL,40720,1584,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:33:03','2022-10-22 11:33:03',NULL),(759,NULL,40720,1584,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1160.00,NULL,NULL,1,'2022-10-22 11:33:06','2022-10-22 11:33:06',NULL),(760,NULL,40720,1584,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',310.00,NULL,NULL,1,'2022-10-22 11:33:09','2022-10-22 11:33:09',NULL),(761,NULL,40720,1584,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',670.00,NULL,NULL,1,'2022-10-22 11:33:12','2022-10-22 11:33:12',NULL),(762,NULL,40720,1584,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',90.00,NULL,NULL,1,'2022-10-22 11:33:14','2022-10-22 11:33:14',NULL),(763,NULL,40720,1584,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:33:17','2022-10-22 11:33:17',NULL),(764,NULL,40720,1584,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',400.00,NULL,NULL,1,'2022-10-22 11:33:20','2022-10-22 11:33:20',NULL),(765,NULL,40720,1584,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',620.00,NULL,NULL,1,'2022-10-22 11:33:23','2022-10-22 11:33:23',NULL),(766,NULL,40720,1584,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',530.00,NULL,NULL,1,'2022-10-22 11:33:26','2022-10-22 11:33:26',NULL),(767,NULL,40720,1584,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',640.00,NULL,NULL,1,'2022-10-22 11:33:28','2022-10-22 11:33:28',NULL),(768,NULL,40720,1584,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:33:31','2022-10-22 11:33:31',NULL),(769,NULL,40720,1584,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:33:34','2022-10-22 11:33:34',NULL),(770,NULL,40720,1584,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',230.00,NULL,NULL,1,'2022-10-22 11:33:37','2022-10-22 11:33:37',NULL),(771,NULL,40720,1584,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:33:40','2022-10-22 11:33:40',NULL),(772,NULL,40720,1584,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',490.00,NULL,NULL,1,'2022-10-22 11:33:43','2022-10-22 11:33:43',NULL),(773,NULL,40720,1584,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:33:45','2022-10-22 11:33:45',NULL),(774,NULL,40720,1584,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',190.00,NULL,NULL,1,'2022-10-22 11:33:48','2022-10-22 11:33:48',NULL),(775,NULL,40720,1584,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',150.00,NULL,NULL,1,'2022-10-22 11:33:51','2022-10-22 11:33:51',NULL),(776,NULL,40720,1584,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',180.00,NULL,NULL,1,'2022-10-22 11:33:54','2022-10-22 11:33:54',NULL),(777,NULL,40720,1584,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',350.00,NULL,NULL,1,'2022-10-22 11:33:57','2022-10-22 11:33:57',NULL),(778,NULL,40720,1584,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',20.00,NULL,NULL,1,'2022-10-22 11:34:00','2022-10-22 11:34:00',NULL);
INSERT INTO `balance_libro` VALUES (779,NULL,40720,1584,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:34:03','2022-10-22 11:34:03',NULL),(780,NULL,40720,1584,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',190.00,NULL,NULL,1,'2022-10-22 11:34:06','2022-10-22 11:34:06',NULL),(781,NULL,40720,1584,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',770.00,NULL,NULL,1,'2022-10-22 11:34:09','2022-10-22 11:34:09',NULL),(782,NULL,40720,1584,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:34:11','2022-10-22 11:34:11',NULL),(783,NULL,40720,1584,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',420.00,NULL,NULL,1,'2022-10-22 11:34:14','2022-10-22 11:34:14',NULL),(784,NULL,40720,1584,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',220.00,NULL,NULL,1,'2022-10-22 11:34:17','2022-10-22 11:34:17',NULL),(785,NULL,40720,1584,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',650.00,NULL,NULL,1,'2022-10-22 11:34:20','2022-10-22 11:34:20',NULL),(786,NULL,40720,1584,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:34:23','2022-10-22 11:34:23',NULL),(787,NULL,40720,1584,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:34:26','2022-10-22 11:34:26',NULL),(788,NULL,40720,1584,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:34:29','2022-10-22 11:34:29',NULL),(789,NULL,40720,1584,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',290.00,NULL,NULL,1,'2022-10-22 11:34:32','2022-10-22 11:34:32',NULL),(790,NULL,40720,1584,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',610.00,NULL,NULL,1,'2022-10-22 11:34:35','2022-10-22 11:34:35',NULL),(791,NULL,40720,1584,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:34:37','2022-10-22 11:34:37',NULL),(792,NULL,40720,1584,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',350.00,NULL,NULL,1,'2022-10-22 11:34:40','2022-10-22 11:34:40',NULL),(793,NULL,40720,1584,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',510.00,NULL,NULL,1,'2022-10-22 11:34:43','2022-10-22 11:34:43',NULL),(794,NULL,40720,1584,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:34:46','2022-10-22 11:34:46',NULL),(795,NULL,40720,1584,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',520.00,NULL,NULL,1,'2022-10-22 11:34:49','2022-10-22 11:34:49',NULL),(796,NULL,40720,1584,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:34:52','2022-10-22 11:34:52',NULL),(797,NULL,40720,1584,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:34:54','2022-10-22 11:34:54',NULL),(798,NULL,40720,1584,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1500.00,NULL,NULL,1,'2022-10-22 11:34:57','2022-10-22 11:34:57',NULL),(799,NULL,40720,1584,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',220.00,NULL,NULL,1,'2022-10-22 11:35:00','2022-10-22 11:35:00',NULL),(800,NULL,40720,1584,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:35:03','2022-10-22 11:35:03',NULL),(801,NULL,40720,1584,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',710.00,NULL,NULL,1,'2022-10-22 11:35:06','2022-10-22 11:35:06',NULL),(802,NULL,40720,1584,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:35:09','2022-10-22 11:35:09',NULL),(803,NULL,40720,1584,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',700.00,NULL,NULL,1,'2022-10-22 11:35:12','2022-10-22 11:35:12',NULL);
INSERT INTO `balance_libro` VALUES (804,NULL,40720,1584,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1720.00,NULL,NULL,1,'2022-10-22 11:35:15','2022-10-22 11:35:15',NULL),(805,NULL,40720,1584,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',760.00,NULL,NULL,1,'2022-10-22 11:35:18','2022-10-22 11:35:18',NULL),(806,NULL,40720,1584,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',290.00,NULL,NULL,1,'2022-10-22 11:35:21','2022-10-22 11:35:21',NULL),(807,NULL,40720,1584,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:35:23','2022-10-22 11:35:23',NULL),(808,NULL,40720,1584,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',390.00,NULL,NULL,1,'2022-10-22 11:35:26','2022-10-22 11:35:26',NULL),(809,NULL,40720,1584,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',650.00,NULL,NULL,1,'2022-10-22 11:35:29','2022-10-22 11:35:29',NULL),(810,NULL,40720,1584,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',290.00,NULL,NULL,1,'2022-10-22 11:35:32','2022-10-22 11:35:32',NULL),(811,NULL,40720,1584,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1180.00,NULL,NULL,1,'2022-10-22 11:35:35','2022-10-22 11:35:35',NULL),(812,NULL,40720,1584,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',440.00,NULL,NULL,1,'2022-10-22 11:35:38','2022-10-22 11:35:38',NULL),(813,NULL,40720,1584,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1230.00,NULL,NULL,1,'2022-10-22 11:35:41','2022-10-22 11:35:41',NULL),(814,NULL,40720,1584,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',100.00,NULL,NULL,1,'2022-10-22 11:35:44','2022-10-22 11:35:44',NULL),(815,NULL,40720,1584,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-10-22 11:35:47','2022-10-22 11:35:47',NULL),(816,NULL,40720,1584,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',470.00,NULL,NULL,1,'2022-10-22 11:35:50','2022-10-22 11:35:50',NULL),(817,NULL,40720,1584,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',190.00,NULL,NULL,1,'2022-10-22 11:35:53','2022-10-22 11:35:53',NULL),(818,NULL,40720,1584,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',310.00,NULL,NULL,1,'2022-10-22 11:35:56','2022-10-22 11:35:56',NULL),(819,NULL,40720,1584,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',520.00,NULL,NULL,1,'2022-10-22 11:35:59','2022-10-22 11:35:59',NULL),(820,NULL,40720,1584,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',850.00,NULL,NULL,1,'2022-10-22 11:36:02','2022-10-22 11:36:02',NULL),(821,NULL,40720,1584,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:36:05','2022-10-22 11:36:05',NULL),(822,NULL,40720,1584,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1030.00,NULL,NULL,1,'2022-10-22 11:36:08','2022-10-22 11:36:08',NULL),(823,NULL,40720,1584,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',490.00,NULL,NULL,1,'2022-10-22 11:36:11','2022-10-22 11:36:11',NULL),(824,NULL,40720,1584,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1440.00,NULL,NULL,1,'2022-10-22 11:36:14','2022-10-22 11:36:14',NULL),(825,NULL,40720,1584,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2170.00,NULL,NULL,1,'2022-10-22 11:36:17','2022-10-22 11:36:17',NULL),(826,NULL,40720,1584,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',720.00,NULL,NULL,1,'2022-10-22 11:36:20','2022-10-22 11:36:20',NULL),(827,NULL,40720,1584,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1170.00,NULL,NULL,1,'2022-10-22 11:36:23','2022-10-22 11:36:23',NULL),(828,NULL,40720,1584,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',290.00,NULL,NULL,1,'2022-10-22 11:36:26','2022-10-22 11:36:26',NULL);
INSERT INTO `balance_libro` VALUES (829,NULL,40720,1584,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:36:29','2022-10-22 11:36:29',NULL),(830,NULL,40720,1584,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:36:32','2022-10-22 11:36:32',NULL),(831,NULL,40720,1584,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',270.00,NULL,NULL,1,'2022-10-22 11:36:35','2022-10-22 11:36:35',NULL),(832,NULL,40720,1584,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',130.00,NULL,NULL,1,'2022-10-22 11:36:38','2022-10-22 11:36:38',NULL),(833,NULL,40720,1584,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',860.00,NULL,NULL,1,'2022-10-22 11:36:41','2022-10-22 11:36:41',NULL),(834,NULL,40720,1584,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',570.00,NULL,NULL,1,'2022-10-22 11:36:44','2022-10-22 11:36:44',NULL),(835,NULL,40720,1584,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:36:47','2022-10-22 11:36:47',NULL),(836,NULL,40720,1584,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:36:50','2022-10-22 11:36:50',NULL),(837,NULL,40720,1584,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:36:53','2022-10-22 11:36:53',NULL),(838,NULL,40720,1584,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',540.00,NULL,NULL,1,'2022-10-22 11:36:56','2022-10-22 11:36:56',NULL),(839,NULL,40720,1584,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-10-22 11:36:59','2022-10-22 11:36:59',NULL),(840,NULL,40720,1584,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',100.00,NULL,NULL,1,'2022-10-22 11:37:02','2022-10-22 11:37:02',NULL),(841,NULL,40720,1584,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',380.00,NULL,NULL,1,'2022-10-22 11:37:05','2022-10-22 11:37:05',NULL),(842,NULL,40720,1584,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:37:08','2022-10-22 11:37:08',NULL),(843,NULL,40720,1584,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',160.00,NULL,NULL,1,'2022-10-22 11:37:11','2022-10-22 11:37:11',NULL),(844,NULL,40720,1584,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',650.00,NULL,NULL,1,'2022-10-22 11:37:14','2022-10-22 11:37:14',NULL),(845,NULL,40720,1584,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',180.00,NULL,NULL,1,'2022-10-22 11:37:17','2022-10-22 11:37:17',NULL),(846,NULL,40720,1584,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:37:20','2022-10-22 11:37:20',NULL),(847,NULL,40720,1584,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1560.00,NULL,NULL,1,'2022-10-22 11:37:23','2022-10-22 11:37:23',NULL),(848,NULL,40720,1584,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',380.00,NULL,NULL,1,'2022-10-22 11:37:26','2022-10-22 11:37:26',NULL),(849,NULL,40720,1584,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:37:29','2022-10-22 11:37:29',NULL),(850,NULL,40720,1584,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-10-22 11:37:32','2022-10-22 11:37:32',NULL),(851,NULL,40720,1584,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',290.00,NULL,NULL,1,'2022-10-22 11:37:35','2022-10-22 11:37:35',NULL),(852,NULL,40720,1584,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',50.00,NULL,NULL,1,'2022-10-22 11:37:38','2022-10-22 11:37:38',NULL),(853,NULL,40720,1584,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',220.00,NULL,NULL,1,'2022-10-22 11:37:41','2022-10-22 11:37:41',NULL);
INSERT INTO `balance_libro` VALUES (854,NULL,40720,1584,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:37:44','2022-10-22 11:37:44',NULL),(855,NULL,40720,1584,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',100.00,NULL,NULL,1,'2022-10-22 11:37:47','2022-10-22 11:37:47',NULL),(856,NULL,40720,1584,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:37:50','2022-10-22 11:37:50',NULL),(857,NULL,40720,1584,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:37:53','2022-10-22 11:37:53',NULL),(858,NULL,40720,1584,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:37:56','2022-10-22 11:37:56',NULL),(859,NULL,40720,1584,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:37:59','2022-10-22 11:37:59',NULL),(860,NULL,40720,1584,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:38:02','2022-10-22 11:38:02',NULL),(861,NULL,40720,1584,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',190.00,NULL,NULL,1,'2022-10-22 11:38:05','2022-10-22 11:38:05',NULL),(862,NULL,40720,1584,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:38:08','2022-10-22 11:38:08',NULL),(863,NULL,40720,1584,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:38:11','2022-10-22 11:38:11',NULL),(864,NULL,40720,1584,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:38:14','2022-10-22 11:38:14',NULL),(865,NULL,40720,1584,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:38:17','2022-10-22 11:38:17',NULL),(866,NULL,40720,1584,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:38:20','2022-10-22 11:38:20',NULL),(867,NULL,40720,1584,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:38:23','2022-10-22 11:38:23',NULL),(868,NULL,40720,1584,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',220.00,NULL,NULL,1,'2022-10-22 11:38:26','2022-10-22 11:38:26',NULL),(869,NULL,40720,1584,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',100.00,NULL,NULL,1,'2022-10-22 11:38:29','2022-10-22 11:38:29',NULL),(870,NULL,40720,1584,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:38:32','2022-10-22 11:38:32',NULL),(871,NULL,40720,1584,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:38:35','2022-10-22 11:38:35',NULL),(872,NULL,40720,1584,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',460.00,NULL,NULL,1,'2022-10-22 11:38:38','2022-10-22 11:38:38',NULL),(873,NULL,40720,1584,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',320.00,NULL,NULL,1,'2022-10-22 11:38:41','2022-10-22 11:38:41',NULL),(874,NULL,40720,1584,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',230.00,NULL,NULL,1,'2022-10-22 11:38:44','2022-10-22 11:38:44',NULL),(875,NULL,40720,1584,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:38:47','2022-10-22 11:38:47',NULL),(876,NULL,40720,1584,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:38:50','2022-10-22 11:38:50',NULL),(877,NULL,40720,1584,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',850.00,NULL,NULL,1,'2022-10-22 11:38:53','2022-10-22 11:38:53',NULL),(878,NULL,40720,1584,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:38:56','2022-10-22 11:38:56',NULL);
INSERT INTO `balance_libro` VALUES (879,NULL,40720,1584,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:38:59','2022-10-22 11:38:59',NULL),(880,NULL,40720,1584,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-10-22 11:39:02','2022-10-22 11:39:02',NULL),(881,NULL,40720,1584,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',220.00,NULL,NULL,1,'2022-10-22 11:39:05','2022-10-22 11:39:05',NULL),(882,NULL,40720,1584,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:39:09','2022-10-22 11:39:09',NULL),(883,NULL,40720,1584,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',450.00,NULL,NULL,1,'2022-10-22 11:39:12','2022-10-22 11:39:12',NULL),(884,NULL,40720,1584,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:39:15','2022-10-22 11:39:15',NULL),(885,NULL,40720,1584,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',110.00,NULL,NULL,1,'2022-10-22 11:39:18','2022-10-22 11:39:18',NULL),(886,NULL,40720,1584,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',340.00,NULL,NULL,1,'2022-10-22 11:39:21','2022-10-22 11:39:21',NULL),(887,NULL,40720,1584,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',220.00,NULL,NULL,1,'2022-10-22 11:39:25','2022-10-22 11:39:25',NULL),(888,NULL,40720,1584,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',520.00,NULL,NULL,1,'2022-10-22 11:39:28','2022-10-22 11:39:28',NULL),(889,NULL,40720,1584,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:39:31','2022-10-22 11:39:31',NULL),(890,NULL,40720,1584,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',780.00,NULL,NULL,1,'2022-10-22 11:39:34','2022-10-22 11:39:34',NULL),(891,NULL,40720,1584,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:39:37','2022-10-22 11:39:37',NULL),(892,NULL,40720,1584,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',400.00,NULL,NULL,1,'2022-10-22 11:39:40','2022-10-22 11:39:40',NULL),(893,NULL,40720,1584,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',230.00,NULL,NULL,1,'2022-10-22 11:39:43','2022-10-22 11:39:43',NULL),(894,NULL,40720,1584,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',340.00,NULL,NULL,1,'2022-10-22 11:39:47','2022-10-22 11:39:47',NULL),(895,NULL,40720,1584,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-10-22 11:39:50','2022-10-22 11:39:50',NULL),(896,NULL,40720,1584,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',970.00,NULL,NULL,1,'2022-10-22 11:39:53','2022-10-22 11:39:53',NULL),(897,NULL,40720,1584,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',430.00,NULL,NULL,1,'2022-10-22 11:39:56','2022-10-22 11:39:56',NULL),(898,NULL,40720,1584,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:39:59','2022-10-22 11:39:59',NULL),(899,NULL,40720,1584,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',820.00,NULL,NULL,1,'2022-10-22 11:40:02','2022-10-22 11:40:02',NULL),(900,NULL,40720,1584,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',390.00,NULL,NULL,1,'2022-10-22 11:40:05','2022-10-22 11:40:05',NULL),(901,NULL,40720,1584,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:40:09','2022-10-22 11:40:09',NULL),(902,NULL,40720,1584,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',510.00,NULL,NULL,1,'2022-10-22 11:40:12','2022-10-22 11:40:12',NULL),(903,NULL,40720,1584,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',190.00,NULL,NULL,1,'2022-10-22 11:40:15','2022-10-22 11:40:15',NULL);
INSERT INTO `balance_libro` VALUES (904,NULL,40720,1584,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:40:18','2022-10-22 11:40:18',NULL),(905,NULL,40720,1584,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',280.00,NULL,NULL,1,'2022-10-22 11:40:21','2022-10-22 11:40:21',NULL),(906,NULL,40720,1584,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:40:24','2022-10-22 11:40:24',NULL),(907,NULL,40720,1584,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:40:27','2022-10-22 11:40:27',NULL),(908,NULL,40720,1584,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',340.00,NULL,NULL,1,'2022-10-22 11:40:31','2022-10-22 11:40:31',NULL),(909,NULL,40720,1584,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',580.00,NULL,NULL,1,'2022-10-22 11:40:34','2022-10-22 11:40:34',NULL),(910,NULL,40720,1584,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-10-22 11:40:38','2022-10-22 11:40:38',NULL),(911,NULL,40720,1584,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',490.00,NULL,NULL,1,'2022-10-22 11:40:41','2022-10-22 11:40:41',NULL),(912,NULL,40720,1584,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',450.00,NULL,NULL,1,'2022-10-22 11:40:44','2022-10-22 11:40:44',NULL),(913,NULL,40720,1584,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',230.00,NULL,NULL,1,'2022-10-22 11:40:47','2022-10-22 11:40:47',NULL),(914,NULL,40720,1584,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',150.00,NULL,NULL,1,'2022-10-22 11:40:50','2022-10-22 11:40:50',NULL),(915,NULL,40720,1584,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',620.00,NULL,NULL,1,'2022-10-22 11:40:54','2022-10-22 11:40:54',NULL),(916,NULL,40720,1584,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',130.00,NULL,NULL,1,'2022-10-22 11:40:57','2022-10-22 11:40:57',NULL),(917,NULL,40720,1584,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',310.00,NULL,NULL,1,'2022-10-22 11:41:00','2022-10-22 11:41:00',NULL),(918,NULL,40720,1584,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1140.00,NULL,NULL,1,'2022-10-22 11:41:04','2022-10-22 11:41:04',NULL),(919,NULL,40720,1584,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',100.00,NULL,NULL,1,'2022-10-22 11:41:08','2022-10-22 11:41:08',NULL),(920,NULL,40720,1584,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:41:11','2022-10-22 11:41:11',NULL),(921,NULL,40720,1584,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',240.00,NULL,NULL,1,'2022-10-22 11:41:15','2022-10-22 11:41:15',NULL),(922,NULL,40720,1584,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',360.00,NULL,NULL,1,'2022-10-22 11:41:20','2022-10-22 11:41:20',NULL),(923,NULL,40720,1584,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',390.00,NULL,NULL,1,'2022-10-22 11:41:24','2022-10-22 11:41:24',NULL),(924,NULL,40720,1584,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1180.00,NULL,NULL,1,'2022-10-22 11:41:29','2022-10-22 11:41:29',NULL),(925,NULL,40720,1584,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',980.00,NULL,NULL,1,'2022-10-22 11:41:33','2022-10-22 11:41:33',NULL),(926,NULL,40720,1584,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',390.00,NULL,NULL,1,'2022-10-22 11:41:37','2022-10-22 11:41:37',NULL),(927,NULL,40720,1584,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',920.00,NULL,NULL,1,'2022-10-22 11:41:41','2022-10-22 11:41:41',NULL),(928,NULL,40720,1584,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:41:45','2022-10-22 11:41:45',NULL);
INSERT INTO `balance_libro` VALUES (929,NULL,40720,1584,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:41:48','2022-10-22 11:41:48',NULL),(930,NULL,40720,1584,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',570.00,NULL,NULL,1,'2022-10-22 11:41:52','2022-10-22 11:41:52',NULL),(931,NULL,40720,1584,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',600.00,NULL,NULL,1,'2022-10-22 11:41:55','2022-10-22 11:41:55',NULL),(932,NULL,40720,1584,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:41:59','2022-10-22 11:41:59',NULL),(933,NULL,40720,1584,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',810.00,NULL,NULL,1,'2022-10-22 11:42:02','2022-10-22 11:42:02',NULL),(934,NULL,40720,1584,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',270.00,NULL,NULL,1,'2022-10-22 11:42:05','2022-10-22 11:42:05',NULL),(935,NULL,40720,1584,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',540.00,NULL,NULL,1,'2022-10-22 11:42:09','2022-10-22 11:42:09',NULL),(936,NULL,40720,1584,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',250.00,NULL,NULL,1,'2022-10-22 11:42:12','2022-10-22 11:42:12',NULL),(937,NULL,40720,1584,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140.00,NULL,NULL,1,'2022-10-22 11:42:15','2022-10-22 11:42:15',NULL),(938,NULL,40720,1584,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',510.00,NULL,NULL,1,'2022-10-22 11:42:19','2022-10-22 11:42:19',NULL),(939,NULL,40720,1584,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:42:22','2022-10-22 11:42:22',NULL),(940,NULL,40720,1584,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',310.00,NULL,NULL,1,'2022-10-22 11:42:25','2022-10-22 11:42:25',NULL),(941,NULL,40720,1584,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',340.00,NULL,NULL,1,'2022-10-22 11:42:28','2022-10-22 11:42:28',NULL),(942,NULL,40720,1584,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',630.00,NULL,NULL,1,'2022-10-22 11:42:32','2022-10-22 11:42:32',NULL),(943,NULL,40720,1584,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:42:35','2022-10-22 11:42:35',NULL),(944,NULL,40720,1584,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:42:38','2022-10-22 11:42:38',NULL),(945,NULL,40720,1584,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:42:41','2022-10-22 11:42:41',NULL),(946,NULL,40720,1584,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',260.00,NULL,NULL,1,'2022-10-22 11:42:44','2022-10-22 11:42:44',NULL),(947,NULL,40720,1584,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',80.00,NULL,NULL,1,'2022-10-22 11:42:47','2022-10-22 11:42:47',NULL),(948,NULL,40720,1584,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',250.00,NULL,NULL,1,'2022-10-22 11:42:50','2022-10-22 11:42:50',NULL),(949,NULL,40720,1584,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-22 11:42:54','2022-10-22 11:42:54',NULL),(950,NULL,40720,1584,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',190.00,NULL,NULL,1,'2022-10-22 11:42:57','2022-10-22 11:42:57',NULL),(951,NULL,40720,1584,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',430.00,NULL,NULL,1,'2022-10-22 11:43:01','2022-10-22 11:43:01',NULL),(952,NULL,40720,1584,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-10-22 11:43:04','2022-10-22 11:43:04',NULL),(953,NULL,40720,1584,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',400.00,NULL,NULL,1,'2022-10-22 11:43:07','2022-10-22 11:43:07',NULL);
INSERT INTO `balance_libro` VALUES (954,NULL,40720,1584,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:43:10','2022-10-22 11:43:10',NULL),(955,NULL,40720,1584,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',120.00,NULL,NULL,1,'2022-10-22 11:43:14','2022-10-22 11:43:14',NULL),(956,NULL,40720,1584,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',150.00,NULL,NULL,1,'2022-10-22 11:43:17','2022-10-22 11:43:17',NULL),(957,NULL,40720,1584,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',230.00,NULL,NULL,1,'2022-10-22 11:43:20','2022-10-22 11:43:20',NULL),(958,NULL,40720,1584,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',780.00,NULL,NULL,1,'2022-10-22 11:43:24','2022-10-22 11:43:24',NULL),(959,NULL,40720,1584,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',170.00,NULL,NULL,1,'2022-10-22 11:43:27','2022-10-22 11:43:27',NULL),(960,NULL,40720,1584,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',180.00,NULL,NULL,1,'2022-10-22 11:43:30','2022-10-22 11:43:30',NULL),(961,NULL,40720,1584,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',450.00,NULL,NULL,1,'2022-10-22 11:43:33','2022-10-22 11:43:33',NULL),(962,NULL,40720,1584,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',270.00,NULL,NULL,1,'2022-10-22 11:43:36','2022-10-22 11:43:36',NULL),(963,NULL,40720,1584,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',110.00,NULL,NULL,1,'2022-10-22 11:43:39','2022-10-22 11:43:39',NULL),(964,NULL,40720,1584,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',870.00,NULL,NULL,1,'2022-10-22 11:43:43','2022-10-22 11:43:43',NULL),(965,NULL,40720,1584,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',470.00,NULL,NULL,1,'2022-10-22 12:17:30','2022-10-22 12:17:30',NULL),(966,NULL,40720,1584,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1440.00,NULL,NULL,1,'2022-10-22 12:17:33','2022-10-22 12:17:33',NULL),(967,NULL,40720,1584,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',230.00,NULL,NULL,1,'2022-10-22 12:17:36','2022-10-22 12:17:36',NULL),(968,NULL,40720,1584,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',170.00,NULL,NULL,1,'2022-10-22 12:17:39','2022-10-22 12:17:39',NULL),(969,NULL,40720,1584,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',210.00,NULL,NULL,1,'2022-10-22 12:17:43','2022-10-22 12:17:43',NULL),(970,NULL,40720,1584,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',540.00,NULL,NULL,1,'2022-10-22 12:17:46','2022-10-22 12:17:46',NULL),(971,NULL,40720,1584,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',490.00,NULL,NULL,1,'2022-10-22 12:17:49','2022-10-22 12:17:49',NULL),(972,NULL,40720,1584,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',740.00,NULL,NULL,1,'2022-10-22 12:17:53','2022-10-22 12:17:53',NULL),(973,NULL,40720,1584,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',350.00,NULL,NULL,1,'2022-10-22 12:17:56','2022-10-22 12:17:56',NULL),(974,NULL,40720,1584,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',410.00,NULL,NULL,1,'2022-10-22 12:17:59','2022-10-22 12:17:59',NULL),(975,NULL,40720,1584,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',560.00,NULL,NULL,1,'2022-10-22 12:18:03','2022-10-22 12:18:03',NULL),(976,NULL,40720,1584,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',310.00,NULL,NULL,1,'2022-10-22 12:18:06','2022-10-22 12:18:06',NULL),(977,NULL,40720,1584,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',390.00,NULL,NULL,1,'2022-10-22 12:18:09','2022-10-22 12:18:09',NULL),(978,NULL,40720,1584,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1060.00,NULL,NULL,1,'2022-10-22 12:18:13','2022-10-22 12:18:13',NULL);
INSERT INTO `balance_libro` VALUES (979,NULL,40720,1584,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:18:16','2022-10-22 12:18:16',NULL),(980,NULL,40720,1584,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:18:19','2022-10-22 12:18:19',NULL),(981,NULL,40720,1584,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',670.00,NULL,NULL,1,'2022-10-22 12:18:22','2022-10-22 12:18:22',NULL),(982,NULL,40720,1584,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',810.00,NULL,NULL,1,'2022-10-22 12:18:26','2022-10-22 12:18:26',NULL),(983,NULL,40720,1584,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1270.00,NULL,NULL,1,'2022-10-22 12:18:29','2022-10-22 12:18:29',NULL),(984,NULL,40720,1584,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',280.00,NULL,NULL,1,'2022-10-22 12:18:32','2022-10-22 12:18:32',NULL),(985,NULL,40720,1584,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',520.00,NULL,NULL,1,'2022-10-22 12:18:35','2022-10-22 12:18:35',NULL),(986,NULL,40720,1584,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',310.00,NULL,NULL,1,'2022-10-22 12:18:39','2022-10-22 12:18:39',NULL),(987,NULL,40720,1584,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:18:42','2022-10-22 12:18:42',NULL),(988,NULL,40720,1584,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1390.00,NULL,NULL,1,'2022-10-22 12:18:46','2022-10-22 12:18:46',NULL),(989,NULL,40720,1584,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',340.00,NULL,NULL,1,'2022-10-22 12:18:49','2022-10-22 12:18:49',NULL),(990,NULL,40720,1584,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',210.00,NULL,NULL,1,'2022-10-22 12:18:52','2022-10-22 12:18:52',NULL),(991,NULL,40720,1584,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',730.00,NULL,NULL,1,'2022-10-22 12:18:55','2022-10-22 12:18:55',NULL),(992,NULL,40720,1584,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',120.00,NULL,NULL,1,'2022-10-22 12:18:58','2022-10-22 12:18:58',NULL),(993,NULL,40720,1584,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',510.00,NULL,NULL,1,'2022-10-22 12:19:02','2022-10-22 12:19:02',NULL),(994,NULL,40720,1584,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',190.00,NULL,NULL,1,'2022-10-22 12:19:05','2022-10-22 12:19:05',NULL),(995,NULL,40720,1584,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-10-22 12:19:08','2022-10-22 12:19:08',NULL),(996,NULL,40720,1584,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:19:11','2022-10-22 12:19:11',NULL),(997,NULL,40720,1584,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',580.00,NULL,NULL,1,'2022-10-22 12:19:15','2022-10-22 12:19:15',NULL),(998,NULL,40720,1584,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',520.00,NULL,NULL,1,'2022-10-22 12:19:18','2022-10-22 12:19:18',NULL),(999,NULL,40720,1584,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',410.00,NULL,NULL,1,'2022-10-22 12:19:21','2022-10-22 12:19:21',NULL),(1000,NULL,40720,1584,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:19:25','2022-10-22 12:19:25',NULL),(1001,NULL,40720,1584,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-10-22 12:19:26','2022-10-22 12:19:26',NULL),(1002,NULL,40720,1584,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',440.00,NULL,NULL,1,'2022-10-22 12:19:27','2022-10-22 12:19:27',NULL),(1003,NULL,40720,1584,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',390.00,NULL,NULL,1,'2022-10-22 12:19:28','2022-10-22 12:19:28',NULL);
INSERT INTO `balance_libro` VALUES (1004,NULL,40720,1584,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',860.00,NULL,NULL,1,'2022-10-22 12:19:29','2022-10-22 12:19:29',NULL),(1005,NULL,40720,1584,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1930.00,NULL,NULL,1,'2022-10-22 12:19:30','2022-10-22 12:19:30',NULL),(1006,NULL,40720,1584,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',500.00,NULL,NULL,1,'2022-10-22 12:19:31','2022-10-22 12:19:31',NULL),(1007,NULL,40720,1584,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',150.00,NULL,NULL,1,'2022-10-22 12:19:32','2022-10-22 12:19:32',NULL),(1008,NULL,40720,1584,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',510.00,NULL,NULL,1,'2022-10-22 12:19:33','2022-10-22 12:19:33',NULL),(1009,NULL,40720,1584,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',490.00,NULL,NULL,1,'2022-10-22 12:19:34','2022-10-22 12:19:34',NULL),(1010,NULL,40720,1584,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:19:35','2022-10-22 12:19:35',NULL),(1011,NULL,40720,1584,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',340.00,NULL,NULL,1,'2022-10-22 12:19:36','2022-10-22 12:19:36',NULL),(1012,NULL,40720,1584,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',150.00,NULL,NULL,1,'2022-10-22 12:19:37','2022-10-22 12:19:37',NULL),(1013,NULL,40720,1584,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',310.00,NULL,NULL,1,'2022-10-22 12:19:38','2022-10-22 12:19:38',NULL),(1014,NULL,40720,1584,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',230.00,NULL,NULL,1,'2022-10-22 12:19:40','2022-10-22 12:19:40',NULL),(1015,NULL,40720,1584,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',270.00,NULL,NULL,1,'2022-10-22 12:19:41','2022-10-22 12:19:41',NULL),(1016,NULL,40720,1584,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:19:42','2022-10-22 12:19:42',NULL),(1017,NULL,40720,1584,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',270.00,NULL,NULL,1,'2022-10-22 12:19:43','2022-10-22 12:19:43',NULL),(1018,NULL,40720,1584,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1000.00,NULL,NULL,1,'2022-10-22 12:19:44','2022-10-22 12:19:44',NULL),(1019,NULL,40720,1584,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',440.00,NULL,NULL,1,'2022-10-22 12:19:46','2022-10-22 12:19:46',NULL),(1020,NULL,40720,1584,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',300.00,NULL,NULL,1,'2022-10-22 12:19:47','2022-10-22 12:19:47',NULL),(1021,NULL,40720,1584,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',240.00,NULL,NULL,1,'2022-10-22 12:19:48','2022-10-22 12:19:48',NULL),(1022,NULL,40720,1584,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',220.00,NULL,NULL,1,'2022-10-22 12:19:49','2022-10-22 12:19:49',NULL),(1023,NULL,40720,1584,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',120.00,NULL,NULL,1,'2022-10-22 12:19:50','2022-10-22 12:19:50',NULL),(1024,NULL,40720,1584,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',150.00,NULL,NULL,1,'2022-10-22 12:19:51','2022-10-22 12:19:51',NULL),(1025,NULL,40720,1584,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',260.00,NULL,NULL,1,'2022-10-22 12:19:52','2022-10-22 12:19:52',NULL),(1026,NULL,40720,1584,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',270.00,NULL,NULL,1,'2022-10-22 12:19:53','2022-10-22 12:19:53',NULL),(1027,NULL,40720,1584,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',240.00,NULL,NULL,1,'2022-10-22 12:19:54','2022-10-22 12:19:54',NULL),(1028,NULL,40720,1584,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',710.00,NULL,NULL,1,'2022-10-22 12:19:55','2022-10-22 12:19:55',NULL);
INSERT INTO `balance_libro` VALUES (1029,NULL,40720,1584,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',260.00,NULL,NULL,1,'2022-10-22 12:19:56','2022-10-22 12:19:56',NULL),(1030,NULL,40720,1584,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',80.00,NULL,NULL,1,'2022-10-22 12:19:57','2022-10-22 12:19:57',NULL),(1031,NULL,40720,1584,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1010.00,NULL,NULL,1,'2022-10-22 12:19:58','2022-10-22 12:19:58',NULL),(1032,NULL,40720,1584,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',540.00,NULL,NULL,1,'2022-10-22 12:19:59','2022-10-22 12:19:59',NULL),(1033,NULL,40720,1584,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:20:00','2022-10-22 12:20:00',NULL),(1034,NULL,40720,1584,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1260.00,NULL,NULL,1,'2022-10-22 12:20:01','2022-10-22 12:20:01',NULL),(1035,NULL,40720,1584,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:20:02','2022-10-22 12:20:02',NULL),(1036,NULL,40720,1584,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',900.00,NULL,NULL,1,'2022-10-22 12:20:03','2022-10-22 12:20:03',NULL),(1037,NULL,40720,1584,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',50.00,NULL,NULL,1,'2022-10-22 12:20:05','2022-10-22 12:20:05',NULL),(1038,NULL,40720,1584,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',420.00,NULL,NULL,1,'2022-10-22 12:20:06','2022-10-22 12:20:06',NULL),(1039,NULL,40720,1584,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',310.00,NULL,NULL,1,'2022-10-22 12:20:07','2022-10-22 12:20:07',NULL),(1040,NULL,40720,1584,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',260.00,NULL,NULL,1,'2022-10-22 12:20:09','2022-10-22 12:20:09',NULL),(1041,NULL,40720,1584,2,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',710.00,NULL,NULL,1,'2022-10-22 12:20:10','2022-10-22 12:20:10',NULL),(1042,NULL,40720,1584,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',260.00,NULL,NULL,1,'2022-10-22 12:20:11','2022-10-22 12:20:11',NULL),(1043,NULL,40720,1584,2,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',200.00,NULL,NULL,1,'2022-10-22 12:20:12','2022-10-22 12:20:12',NULL),(1044,NULL,40720,1584,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',230.00,NULL,NULL,1,'2022-10-22 12:20:13','2022-10-22 12:20:13',NULL),(1045,NULL,40720,1584,2,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',250.00,NULL,NULL,1,'2022-10-22 12:20:15','2022-10-22 12:20:15',NULL),(1046,NULL,40720,1584,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',390.00,NULL,NULL,1,'2022-10-22 12:20:17','2022-10-22 12:20:17',NULL),(1047,NULL,40720,1584,2,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',470.00,NULL,NULL,1,'2022-10-22 12:20:18','2022-10-22 12:20:18',NULL),(1048,NULL,40720,1584,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',330.00,NULL,NULL,1,'2022-10-22 12:20:24','2022-10-22 12:20:24',NULL),(1049,NULL,40720,1584,2,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',620.00,NULL,NULL,1,'2022-10-22 12:20:26','2022-10-22 12:20:26',NULL),(1050,NULL,40720,1584,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-10-22 12:20:28','2022-10-22 12:20:28',NULL),(1051,NULL,40720,1584,2,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',390.00,NULL,NULL,1,'2022-10-22 12:20:30','2022-10-22 12:20:30',NULL),(1052,NULL,40720,1584,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',450.00,NULL,NULL,1,'2022-10-22 12:20:31','2022-10-22 12:20:31',NULL),(1053,NULL,40720,1584,2,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',480.00,NULL,NULL,1,'2022-10-22 12:20:32','2022-10-22 12:20:32',NULL);
INSERT INTO `balance_libro` VALUES (1054,NULL,40720,1584,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',680.00,NULL,NULL,1,'2022-10-22 12:20:34','2022-10-22 12:20:34',NULL),(1055,NULL,40720,1584,2,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',430.00,NULL,NULL,1,'2022-10-22 12:20:35','2022-10-22 12:20:35',NULL),(1056,NULL,40720,1584,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:20:36','2022-10-22 12:20:36',NULL),(1057,NULL,40720,1584,2,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:20:39','2022-10-22 12:20:39',NULL),(1058,NULL,40720,1584,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',560.00,NULL,NULL,1,'2022-10-22 12:20:40','2022-10-22 12:20:40',NULL),(1059,NULL,40720,1584,2,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',740.00,NULL,NULL,1,'2022-10-22 12:20:44','2022-10-22 12:20:44',NULL),(1060,NULL,40720,1584,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',610.00,NULL,NULL,1,'2022-10-22 12:20:46','2022-10-22 12:20:46',NULL),(1061,NULL,40720,1584,2,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',490.00,NULL,NULL,1,'2022-10-22 12:20:47','2022-10-22 12:20:47',NULL),(1062,NULL,40720,1584,2,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',440.00,NULL,NULL,1,'2022-10-22 12:20:48','2022-10-22 12:20:48',NULL),(1063,NULL,40720,1584,2,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',240.00,NULL,NULL,1,'2022-10-22 12:20:49','2022-10-22 12:20:49',NULL),(1064,NULL,40720,1584,2,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',170.00,NULL,NULL,1,'2022-10-22 12:20:51','2022-10-22 12:20:51',NULL),(1065,NULL,40720,1584,2,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',390.00,NULL,NULL,1,'2022-10-22 12:20:52','2022-10-22 12:20:52',NULL),(1066,NULL,40720,1584,2,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',240.00,NULL,NULL,1,'2022-10-22 12:20:53','2022-10-22 12:20:53',NULL),(1067,NULL,40720,1584,2,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',280.00,NULL,NULL,1,'2022-10-22 12:20:54','2022-10-22 12:20:54',NULL),(1068,NULL,40720,1584,2,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',490.00,NULL,NULL,1,'2022-10-22 12:20:55','2022-10-22 12:20:55',NULL),(1069,NULL,40720,1584,2,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',820.00,NULL,NULL,1,'2022-10-22 12:20:57','2022-10-22 12:20:57',NULL),(1070,NULL,40720,1584,2,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',780.00,NULL,NULL,1,'2022-10-22 12:20:59','2022-10-22 12:20:59',NULL),(1071,NULL,40720,1584,2,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-10-22 12:21:00','2022-10-22 12:21:00',NULL),(1072,NULL,40720,1584,2,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',310.00,NULL,NULL,1,'2022-10-22 12:21:01','2022-10-22 12:21:01',NULL),(1073,NULL,40720,1584,2,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',410.00,NULL,NULL,1,'2022-10-22 12:21:02','2022-10-22 12:21:02',NULL),(1074,NULL,40720,1584,2,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',450.00,NULL,NULL,1,'2022-10-22 12:21:05','2022-10-22 12:21:05',NULL),(1075,NULL,40720,1584,2,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:21:07','2022-10-22 12:21:07',NULL),(1076,NULL,40720,1584,2,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1770.00,NULL,NULL,1,'2022-10-22 12:21:08','2022-10-22 12:21:08',NULL),(1077,NULL,40720,1584,2,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',550.00,NULL,NULL,1,'2022-10-22 12:21:11','2022-10-22 12:21:11',NULL),(1078,NULL,40720,1584,2,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',470.00,NULL,NULL,1,'2022-10-22 12:21:12','2022-10-22 12:21:12',NULL);
INSERT INTO `balance_libro` VALUES (1079,NULL,40720,1584,2,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:21:14','2022-10-22 12:21:14',NULL),(1080,NULL,40720,1584,2,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:21:15','2022-10-22 12:21:15',NULL),(1081,NULL,40720,1584,2,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',370.00,NULL,NULL,1,'2022-10-22 12:21:17','2022-10-22 12:21:17',NULL),(1082,NULL,40720,1584,2,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',310.00,NULL,NULL,1,'2022-10-22 12:21:18','2022-10-22 12:21:18',NULL),(1083,NULL,40720,1584,2,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',280.00,NULL,NULL,1,'2022-10-22 12:21:19','2022-10-22 12:21:19',NULL),(1084,NULL,40720,1584,2,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',210.00,NULL,NULL,1,'2022-10-22 12:21:21','2022-10-22 12:21:21',NULL),(1085,NULL,40720,1584,2,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',200.00,NULL,NULL,1,'2022-10-22 12:21:22','2022-10-22 12:21:22',NULL),(1086,NULL,40720,1584,2,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',350.00,NULL,NULL,1,'2022-10-22 12:21:23','2022-10-22 12:21:23',NULL),(1087,NULL,40720,1584,2,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',130.00,NULL,NULL,1,'2022-10-22 12:21:25','2022-10-22 12:21:25',NULL),(1088,NULL,40720,1584,2,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',130.00,NULL,NULL,1,'2022-10-22 12:21:29','2022-10-22 12:21:29',NULL),(1089,NULL,40720,1584,2,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',110.00,NULL,NULL,1,'2022-10-22 12:21:30','2022-10-22 12:21:30',NULL),(1090,NULL,40720,1584,2,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',270.00,NULL,NULL,1,'2022-10-22 12:21:31','2022-10-22 12:21:31',NULL),(1091,NULL,40720,1584,2,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',940.00,NULL,NULL,1,'2022-10-22 12:21:33','2022-10-22 12:21:33',NULL),(1092,NULL,40720,1584,2,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',340.00,NULL,NULL,1,'2022-10-22 12:21:34','2022-10-22 12:21:34',NULL),(1093,NULL,40720,1584,2,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1100.00,NULL,NULL,1,'2022-10-22 12:21:35','2022-10-22 12:21:35',NULL),(1094,NULL,40720,1584,2,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',130.00,NULL,NULL,1,'2022-10-22 12:21:36','2022-10-22 12:21:36',NULL),(1095,NULL,40720,1584,2,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',210.00,NULL,NULL,1,'2022-10-22 12:21:37','2022-10-22 12:21:37',NULL),(1096,NULL,40720,1584,2,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',490.00,NULL,NULL,1,'2022-10-22 12:21:38','2022-10-22 12:21:38',NULL),(1097,NULL,40720,1584,2,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',300.00,NULL,NULL,1,'2022-10-22 12:21:39','2022-10-22 12:21:39',NULL),(1098,NULL,40720,1584,2,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2520.00,NULL,NULL,1,'2022-10-22 12:21:41','2022-10-22 12:21:41',NULL),(1099,NULL,40720,1584,2,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',340.00,NULL,NULL,1,'2022-10-22 12:21:42','2022-10-22 12:21:42',NULL),(1100,NULL,40720,1584,2,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',930.00,NULL,NULL,1,'2022-10-22 12:21:45','2022-10-22 12:21:45',NULL),(1101,NULL,40720,1584,2,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',510.00,NULL,NULL,1,'2022-10-22 12:21:46','2022-10-22 12:21:46',NULL),(1102,NULL,40720,1584,2,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',280.00,NULL,NULL,1,'2022-10-22 12:21:48','2022-10-22 12:21:48',NULL),(1103,NULL,40720,1584,2,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',250.00,NULL,NULL,1,'2022-10-22 12:21:49','2022-10-22 12:21:49',NULL);
INSERT INTO `balance_libro` VALUES (1104,NULL,40720,1584,2,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',260.00,NULL,NULL,1,'2022-10-22 12:21:50','2022-10-22 12:21:50',NULL),(1105,NULL,40720,1584,2,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',500.00,NULL,NULL,1,'2022-10-22 12:21:52','2022-10-22 12:21:52',NULL),(1106,NULL,40720,1584,2,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',140.00,NULL,NULL,1,'2022-10-22 12:21:53','2022-10-22 12:21:53',NULL),(1107,NULL,40720,1584,2,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',600.00,NULL,NULL,1,'2022-10-22 12:21:54','2022-10-22 12:21:54',NULL),(1108,NULL,40720,1584,2,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',150.00,NULL,NULL,1,'2022-10-22 12:21:55','2022-10-22 12:21:55',NULL),(1109,NULL,40720,1584,2,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',130.00,NULL,NULL,1,'2022-10-22 12:21:57','2022-10-22 12:21:57',NULL),(1110,NULL,40720,1584,2,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',170.00,NULL,NULL,1,'2022-10-22 12:21:57','2022-10-22 12:21:57',NULL),(1111,NULL,40720,1584,2,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',340.00,NULL,NULL,1,'2022-10-22 12:21:58','2022-10-22 12:21:58',NULL),(1112,NULL,40720,1584,2,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',550.00,NULL,NULL,1,'2022-10-22 12:21:59','2022-10-22 12:21:59',NULL),(1113,NULL,40720,1584,2,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',820.00,NULL,NULL,1,'2022-10-22 12:22:00','2022-10-22 12:22:00',NULL),(1114,NULL,40720,1584,2,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',270.00,NULL,NULL,1,'2022-10-22 12:22:02','2022-10-22 12:22:02',NULL),(1115,NULL,40720,1584,2,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:22:03','2022-10-22 12:22:03',NULL),(1116,NULL,40720,1584,2,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:22:04','2022-10-22 12:22:04',NULL),(1117,NULL,40720,1584,2,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',610.00,NULL,NULL,1,'2022-10-22 12:22:05','2022-10-22 12:22:05',NULL),(1118,NULL,40720,1584,2,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',740.00,NULL,NULL,1,'2022-10-22 12:22:06','2022-10-22 12:22:06',NULL),(1119,NULL,40720,1584,2,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',770.00,NULL,NULL,1,'2022-10-22 12:22:08','2022-10-22 12:22:08',NULL),(1120,NULL,40720,1584,2,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',230.00,NULL,NULL,1,'2022-10-22 12:22:09','2022-10-22 12:22:09',NULL),(1121,NULL,40720,1584,2,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2.00,NULL,NULL,1,'2022-10-22 12:22:10','2022-10-22 12:22:10',NULL),(1122,NULL,40720,1584,2,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',280.00,NULL,NULL,1,'2022-10-22 12:22:11','2022-10-22 12:22:11',NULL),(1123,NULL,40720,1584,2,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',200.00,NULL,NULL,1,'2022-10-22 12:22:12','2022-10-22 12:22:12',NULL),(1124,NULL,40720,1584,2,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:22:13','2022-10-22 12:22:13',NULL),(1125,NULL,40720,1584,2,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',520.00,NULL,NULL,1,'2022-10-22 12:22:14','2022-10-22 12:22:14',NULL),(1126,NULL,40720,1584,2,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',510.00,NULL,NULL,1,'2022-10-22 12:22:15','2022-10-22 12:22:15',NULL),(1127,NULL,40720,1584,2,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:22:16','2022-10-22 12:22:16',NULL),(1128,NULL,40720,1584,2,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:22:17','2022-10-22 12:22:17',NULL);
INSERT INTO `balance_libro` VALUES (1129,NULL,40720,1584,2,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',590.00,NULL,NULL,1,'2022-10-22 12:22:18','2022-10-22 12:22:18',NULL),(1130,NULL,40720,1584,2,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',330.00,NULL,NULL,1,'2022-10-22 12:22:19','2022-10-22 12:22:19',NULL),(1131,NULL,40720,1584,2,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',470.00,NULL,NULL,1,'2022-10-22 12:22:21','2022-10-22 12:22:21',NULL),(1132,NULL,40720,1584,2,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',540.00,NULL,NULL,1,'2022-10-22 12:22:22','2022-10-22 12:22:22',NULL),(1133,NULL,40720,1584,2,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',260.00,NULL,NULL,1,'2022-10-22 12:22:24','2022-10-22 12:22:24',NULL),(1134,NULL,40720,1584,2,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',300.00,NULL,NULL,1,'2022-10-22 12:22:25','2022-10-22 12:22:25',NULL),(1135,NULL,40720,1584,2,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',210.00,NULL,NULL,1,'2022-10-22 12:22:26','2022-10-22 12:22:26',NULL),(1136,NULL,40720,1584,2,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',430.00,NULL,NULL,1,'2022-10-22 12:22:27','2022-10-22 12:22:27',NULL),(1137,NULL,40720,1584,2,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',470.00,NULL,NULL,1,'2022-10-22 12:22:29','2022-10-22 12:22:29',NULL),(1138,NULL,40720,1584,2,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',370.00,NULL,NULL,1,'2022-10-22 12:22:30','2022-10-22 12:22:30',NULL),(1139,NULL,40720,1584,2,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:22:31','2022-10-22 12:22:31',NULL),(1140,NULL,40720,1584,2,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',470.00,NULL,NULL,1,'2022-10-22 12:22:32','2022-10-22 12:22:32',NULL),(1141,NULL,40720,1584,2,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',260.00,NULL,NULL,1,'2022-10-22 12:22:33','2022-10-22 12:22:33',NULL),(1142,NULL,40720,1584,2,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',520.00,NULL,NULL,1,'2022-10-22 12:22:34','2022-10-22 12:22:34',NULL),(1143,NULL,40720,1584,2,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',310.00,NULL,NULL,1,'2022-10-22 12:22:35','2022-10-22 12:22:35',NULL),(1144,NULL,40720,1584,2,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',340.00,NULL,NULL,1,'2022-10-22 12:22:36','2022-10-22 12:22:36',NULL),(1145,NULL,40720,1584,2,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',270.00,NULL,NULL,1,'2022-10-22 12:22:37','2022-10-22 12:22:37',NULL),(1146,NULL,40720,1584,2,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',890.00,NULL,NULL,1,'2022-10-22 12:22:38','2022-10-22 12:22:38',NULL),(1147,NULL,40720,1584,2,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:22:39','2022-10-22 12:22:39',NULL),(1148,NULL,40720,1584,2,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',100.00,NULL,NULL,1,'2022-10-22 12:22:40','2022-10-22 12:22:40',NULL),(1149,NULL,40720,1584,2,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:22:41','2022-10-22 12:22:41',NULL),(1150,NULL,40720,1584,2,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',220.00,NULL,NULL,1,'2022-10-22 12:22:42','2022-10-22 12:22:42',NULL),(1151,NULL,40720,1584,2,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290.00,NULL,NULL,1,'2022-10-22 12:22:43','2022-10-22 12:22:43',NULL),(1152,NULL,40720,1584,2,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',850.00,NULL,NULL,1,'2022-10-22 12:22:44','2022-10-22 12:22:44',NULL),(1153,NULL,40720,1584,2,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',200.00,NULL,NULL,1,'2022-10-22 12:22:46','2022-10-22 12:22:46',NULL);
INSERT INTO `balance_libro` VALUES (1154,NULL,40720,1584,2,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-10-22 12:22:47','2022-10-22 12:22:47',NULL),(1155,NULL,40720,1584,2,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',260.00,NULL,NULL,1,'2022-10-22 12:22:48','2022-10-22 12:22:48',NULL),(1156,NULL,40720,1584,2,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',550.00,NULL,NULL,1,'2022-10-22 12:22:49','2022-10-22 12:22:49',NULL),(1157,NULL,40720,1584,2,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',550.00,NULL,NULL,1,'2022-10-22 12:22:51','2022-10-22 12:22:51',NULL),(1158,NULL,40720,1584,2,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',780.00,NULL,NULL,1,'2022-10-22 12:22:52','2022-10-22 12:22:52',NULL),(1159,NULL,40720,1584,2,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:22:53','2022-10-22 12:22:53',NULL),(1160,NULL,40720,1584,2,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1030.00,NULL,NULL,1,'2022-10-22 12:22:54','2022-10-22 12:22:54',NULL),(1161,NULL,40720,1584,2,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',960.00,NULL,NULL,1,'2022-10-22 12:22:55','2022-10-22 12:22:55',NULL),(1162,NULL,40720,1584,2,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',680.00,NULL,NULL,1,'2022-10-22 12:22:56','2022-10-22 12:22:56',NULL),(1163,NULL,40720,1584,2,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',360.00,NULL,NULL,1,'2022-10-22 12:22:57','2022-10-22 12:22:57',NULL),(1164,NULL,40720,1584,2,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',280.00,NULL,NULL,1,'2022-10-22 12:22:58','2022-10-22 12:22:58',NULL),(1165,NULL,40720,1584,2,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',160.00,NULL,NULL,1,'2022-10-22 12:22:59','2022-10-22 12:22:59',NULL),(1166,NULL,40720,1584,2,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',780.00,NULL,NULL,1,'2022-10-22 12:23:00','2022-10-22 12:23:00',NULL),(1167,NULL,40720,1584,2,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',330.00,NULL,NULL,1,'2022-10-22 12:23:01','2022-10-22 12:23:01',NULL),(1168,NULL,40720,1584,2,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',460.00,NULL,NULL,1,'2022-10-22 12:23:02','2022-10-22 12:23:02',NULL),(1169,NULL,40720,1584,2,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',410.00,NULL,NULL,1,'2022-10-22 12:23:03','2022-10-22 12:23:03',NULL),(1170,NULL,40720,1584,2,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',400.00,NULL,NULL,1,'2022-10-22 12:23:05','2022-10-22 12:23:05',NULL),(1171,NULL,40720,1584,2,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',380.00,NULL,NULL,1,'2022-10-22 12:23:06','2022-10-22 12:23:06',NULL),(1172,NULL,40720,1584,2,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',310.00,NULL,NULL,1,'2022-10-22 12:23:07','2022-10-22 12:23:07',NULL),(1173,NULL,40720,1584,2,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',270.00,NULL,NULL,1,'2022-10-22 12:23:08','2022-10-22 12:23:08',NULL),(1174,NULL,40720,1584,2,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',210.00,NULL,NULL,1,'2022-10-22 12:23:10','2022-10-22 12:23:10',NULL),(1175,NULL,40720,1584,2,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',130.00,NULL,NULL,1,'2022-10-22 12:23:11','2022-10-22 12:23:11',NULL),(1176,NULL,40720,1584,2,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',310.00,NULL,NULL,1,'2022-10-22 12:23:12','2022-10-22 12:23:12',NULL),(1177,NULL,40720,1584,2,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',490.00,NULL,NULL,1,'2022-10-22 12:23:13','2022-10-22 12:23:13',NULL),(1178,NULL,40720,1584,2,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',150.00,NULL,NULL,1,'2022-10-22 12:23:14','2022-10-22 12:23:14',NULL);
INSERT INTO `balance_libro` VALUES (1179,NULL,40720,1584,2,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',130.00,NULL,NULL,1,'2022-10-22 12:23:15','2022-10-22 12:23:15',NULL),(1180,NULL,40720,1584,2,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',60.00,NULL,NULL,1,'2022-10-22 12:23:16','2022-10-22 12:23:16',NULL),(1181,NULL,40720,1584,2,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',80.00,NULL,NULL,1,'2022-10-22 12:23:17','2022-10-22 12:23:17',NULL),(1182,NULL,40720,1584,2,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',150.00,NULL,NULL,1,'2022-10-22 12:23:18','2022-10-22 12:23:18',NULL),(1183,NULL,40720,1584,2,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',200.00,NULL,NULL,1,'2022-10-22 12:23:19','2022-10-22 12:23:19',NULL),(1184,NULL,40720,1584,2,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',300.00,NULL,NULL,1,'2022-10-22 12:23:20','2022-10-22 12:23:20',NULL),(1185,NULL,40720,1584,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',850.00,NULL,NULL,1,'2022-10-22 12:23:21','2022-10-22 12:23:21',NULL),(1186,NULL,40720,1584,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',170.00,NULL,NULL,1,'2022-10-22 12:23:22','2022-10-22 12:23:22',NULL),(1187,NULL,40720,1584,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',510.00,NULL,NULL,1,'2022-10-22 12:23:23','2022-10-22 12:23:23',NULL),(1188,NULL,40720,1584,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',670.00,NULL,NULL,1,'2022-10-22 12:23:24','2022-10-22 12:23:24',NULL),(1189,NULL,40720,1584,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',280.00,NULL,NULL,1,'2022-10-22 12:23:25','2022-10-22 12:23:25',NULL),(1190,NULL,40720,1584,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',320.00,NULL,NULL,1,'2022-10-22 12:23:26','2022-10-22 12:23:26',NULL),(1191,NULL,40720,1584,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',150.00,NULL,NULL,1,'2022-10-22 12:23:28','2022-10-22 12:23:28',NULL),(1192,NULL,40720,1584,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',160.00,NULL,NULL,1,'2022-10-22 12:23:29','2022-10-22 12:23:29',NULL),(1193,NULL,40720,1584,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',200.00,NULL,NULL,1,'2022-10-22 12:23:30','2022-10-22 12:23:30',NULL),(1194,NULL,40720,1584,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',150.00,NULL,NULL,1,'2022-10-22 12:23:32','2022-10-22 12:23:32',NULL),(1195,NULL,40720,1584,2,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',310.00,NULL,NULL,1,'2022-10-22 12:23:33','2022-10-22 12:23:33',NULL),(1196,NULL,40720,1584,2,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',120.00,NULL,NULL,1,'2022-10-22 12:23:34','2022-10-22 12:23:34',NULL),(1197,NULL,40720,1584,2,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',120.00,NULL,NULL,1,'2022-10-22 12:23:35','2022-10-22 12:23:35',NULL),(1198,NULL,40720,1584,2,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',100.00,NULL,NULL,1,'2022-10-22 12:23:36','2022-10-22 12:23:36',NULL),(1199,NULL,40720,1584,2,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',150.00,NULL,NULL,1,'2022-10-22 12:23:37','2022-10-22 12:23:37',NULL),(1200,NULL,40720,1584,2,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',880.00,NULL,NULL,1,'2022-10-22 12:29:33','2022-10-22 12:29:33',NULL),(1201,NULL,40720,1584,2,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',310.00,NULL,NULL,1,'2022-10-22 12:29:34','2022-10-22 12:29:34',NULL),(1202,NULL,40720,1584,2,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',290.00,NULL,NULL,1,'2022-10-22 12:29:35','2022-10-22 12:29:35',NULL),(1203,NULL,40720,1584,2,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',360.00,NULL,NULL,1,'2022-10-22 12:29:36','2022-10-22 12:29:36',NULL);
INSERT INTO `balance_libro` VALUES (1204,NULL,40720,1584,2,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',870.00,NULL,NULL,1,'2022-10-22 12:29:37','2022-10-22 12:29:37',NULL),(1205,NULL,40720,1584,2,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',310.00,NULL,NULL,1,'2022-10-22 12:29:38','2022-10-22 12:29:38',NULL),(1206,NULL,40720,1584,2,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',700.00,NULL,NULL,1,'2022-10-22 12:29:39','2022-10-22 12:29:39',NULL),(1207,NULL,40720,1584,2,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',80.00,NULL,NULL,1,'2022-10-22 12:29:40','2022-10-22 12:29:40',NULL),(1208,NULL,40720,1584,2,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',70.00,NULL,NULL,1,'2022-10-22 12:29:41','2022-10-22 12:29:41',NULL),(1209,NULL,40720,1584,2,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',150.00,NULL,NULL,1,'2022-10-22 12:29:42','2022-10-22 12:29:42',NULL),(1210,NULL,40720,1584,2,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',340.00,NULL,NULL,1,'2022-10-22 12:29:43','2022-10-22 12:29:43',NULL),(1211,NULL,40720,1584,2,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',570.00,NULL,NULL,1,'2022-10-22 12:29:44','2022-10-22 12:29:44',NULL),(1212,NULL,40720,1584,2,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',340.00,NULL,NULL,1,'2022-10-22 12:29:45','2022-10-22 12:29:45',NULL),(1213,NULL,40720,1584,2,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',90.00,NULL,NULL,1,'2022-10-22 12:29:46','2022-10-22 12:29:46',NULL),(1214,NULL,40720,1584,2,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',290.00,NULL,NULL,1,'2022-10-22 12:29:47','2022-10-22 12:29:47',NULL),(1215,NULL,40720,1584,2,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',730.00,NULL,NULL,1,'2022-10-22 12:29:48','2022-10-22 12:29:48',NULL),(1216,NULL,40720,1584,2,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',400.00,NULL,NULL,1,'2022-10-22 12:29:49','2022-10-22 12:29:49',NULL),(1217,NULL,40720,1584,2,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',550.00,NULL,NULL,1,'2022-10-22 12:29:50','2022-10-22 12:29:50',NULL),(1218,NULL,40720,1584,2,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',670.00,NULL,NULL,1,'2022-10-22 12:29:51','2022-10-22 12:29:51',NULL),(1219,NULL,40720,1584,2,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',280.00,NULL,NULL,1,'2022-10-22 12:29:53','2022-10-22 12:29:53',NULL),(1220,NULL,40720,1584,2,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',320.00,NULL,NULL,1,'2022-10-22 12:29:54','2022-10-22 12:29:54',NULL),(1221,NULL,40720,1584,2,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',150.00,NULL,NULL,1,'2022-10-22 12:29:55','2022-10-22 12:29:55',NULL),(1222,NULL,40720,1584,2,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',160.00,NULL,NULL,1,'2022-10-22 12:29:56','2022-10-22 12:29:56',NULL),(1223,NULL,40720,1584,2,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',200.00,NULL,NULL,1,'2022-10-22 12:29:57','2022-10-22 12:29:57',NULL),(1224,NULL,40720,1584,2,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',150.00,NULL,NULL,1,'2022-10-22 12:29:58','2022-10-22 12:29:58',NULL),(1225,NULL,40720,1584,2,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',310.00,NULL,NULL,1,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(1226,NULL,40720,1584,2,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',120.00,NULL,NULL,1,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(1227,NULL,40720,1584,2,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',120.00,NULL,NULL,1,'2022-10-22 12:30:00','2022-10-22 12:30:00',NULL),(1228,NULL,40720,1584,2,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',100.00,NULL,NULL,1,'2022-10-22 12:30:01','2022-10-22 12:30:01',NULL);
INSERT INTO `balance_libro` VALUES (1229,NULL,40720,1584,2,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',150.00,NULL,NULL,1,'2022-10-22 12:30:02','2022-10-22 12:30:02',NULL),(1230,NULL,40720,1584,2,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',390.00,NULL,NULL,1,'2022-10-22 12:33:54','2022-10-22 12:33:54',NULL),(1231,NULL,40720,1584,2,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1080.00,NULL,NULL,1,'2022-10-22 12:33:55','2022-10-22 12:33:55',NULL),(1232,NULL,40720,1584,2,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',270.00,NULL,NULL,1,'2022-10-22 12:33:56','2022-10-22 12:33:56',NULL),(1233,NULL,40720,1584,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',190.00,NULL,NULL,1,'2022-10-22 12:33:57','2022-10-22 12:33:57',NULL),(1234,NULL,40720,1584,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',160.00,NULL,NULL,1,'2022-10-22 12:33:58','2022-10-22 12:33:58',NULL),(1235,NULL,40720,1584,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',380.00,NULL,NULL,1,'2022-10-22 12:33:59','2022-10-22 12:33:59',NULL),(1236,NULL,40720,1584,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',390.00,NULL,NULL,1,'2022-10-22 12:34:00','2022-10-22 12:34:00',NULL),(1237,NULL,40720,1584,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1210.00,NULL,NULL,1,'2022-10-22 12:34:01','2022-10-22 12:34:01',NULL),(1238,NULL,40720,1584,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',330.00,NULL,NULL,1,'2022-10-22 12:34:02','2022-10-22 12:34:02',NULL),(1239,NULL,40720,1584,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',280.00,NULL,NULL,1,'2022-10-22 12:34:03','2022-10-22 12:34:03',NULL),(1240,NULL,40720,1584,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',440.00,NULL,NULL,1,'2022-10-22 12:34:04','2022-10-22 12:34:04',NULL),(1241,NULL,40720,1584,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',250.00,NULL,NULL,1,'2022-10-22 12:34:06','2022-10-22 12:34:06',NULL),(1242,NULL,40720,1584,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',550.00,NULL,NULL,1,'2022-10-22 12:34:07','2022-10-22 12:34:07',NULL),(1243,NULL,40720,1584,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',90.00,NULL,NULL,1,'2022-10-22 12:34:08','2022-10-22 12:34:08',NULL),(1244,NULL,40720,1584,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',290.00,NULL,NULL,1,'2022-10-22 12:34:09','2022-10-22 12:34:09',NULL),(1245,NULL,40720,1584,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',130.00,NULL,NULL,1,'2022-10-22 12:34:11','2022-10-22 12:34:11',NULL),(1246,NULL,40720,1584,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',200.00,NULL,NULL,1,'2022-10-22 12:34:12','2022-10-22 12:34:12',NULL),(1247,NULL,40720,1584,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',250.00,NULL,NULL,1,'2022-10-22 12:34:14','2022-10-22 12:34:14',NULL),(1248,NULL,40720,1584,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',270.00,NULL,NULL,1,'2022-10-22 12:34:15','2022-10-22 12:34:15',NULL),(1249,NULL,40720,1584,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',280.00,NULL,NULL,1,'2022-10-22 12:34:16','2022-10-22 12:34:16',NULL),(1250,NULL,40720,1584,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',220.00,NULL,NULL,1,'2022-10-22 12:34:18','2022-10-22 12:34:18',NULL),(1251,NULL,40720,1584,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',150.00,NULL,NULL,1,'2022-10-22 12:34:19','2022-10-22 12:34:19',NULL),(1252,NULL,40720,1584,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',160.00,NULL,NULL,1,'2022-10-22 12:34:20','2022-10-22 12:34:20',NULL),(1253,NULL,40720,1584,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',200.00,NULL,NULL,1,'2022-10-22 12:34:22','2022-10-22 12:34:22',NULL);
INSERT INTO `balance_libro` VALUES (1254,NULL,40720,1584,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',150.00,NULL,NULL,1,'2022-10-22 12:34:24','2022-10-22 12:34:24',NULL),(1255,NULL,40720,1584,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',310.00,NULL,NULL,1,'2022-10-22 12:34:25','2022-10-22 12:34:25',NULL),(1256,NULL,40720,1584,2,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',120.00,NULL,NULL,1,'2022-10-22 12:34:27','2022-10-22 12:34:27',NULL),(1257,NULL,40720,1584,2,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',120.00,NULL,NULL,1,'2022-10-22 12:34:28','2022-10-22 12:34:28',NULL),(1258,NULL,40720,1584,2,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',100.00,NULL,NULL,1,'2022-10-22 12:34:30','2022-10-22 12:34:30',NULL),(1259,NULL,40720,1584,2,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',150.00,NULL,NULL,1,'2022-10-22 12:34:31','2022-10-22 12:34:31',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7776,1,40720,1584,2,218,2,650.00,NULL,'2022-10-11 00:21:00','2022-10-11 00:21:00',NULL),(2,7776,1,40720,1584,2,13,1,650.00,NULL,'2022-10-11 00:21:00','2022-10-11 00:21:00',NULL),(3,NULL,2,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:07','2022-10-11 00:26:07',NULL),(4,NULL,3,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:09','2022-10-11 00:26:09',NULL),(5,NULL,4,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:12','2022-10-11 00:26:12',NULL),(6,NULL,5,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:13','2022-10-11 00:26:13',NULL),(7,NULL,6,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:16','2022-10-11 00:26:16',NULL),(8,NULL,7,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:18','2022-10-11 00:26:18',NULL),(9,NULL,8,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:20','2022-10-11 00:26:20',NULL),(10,NULL,9,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:21','2022-10-11 00:26:21',NULL),(11,NULL,10,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:23','2022-10-11 00:26:23',NULL),(12,NULL,11,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:24','2022-10-11 00:26:24',NULL),(13,NULL,12,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:26','2022-10-11 00:26:26',NULL),(14,NULL,13,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:28','2022-10-11 00:26:28',NULL),(15,NULL,14,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:31','2022-10-11 00:26:31',NULL),(16,NULL,15,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:33','2022-10-11 00:26:33',NULL),(17,NULL,16,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:34','2022-10-11 00:26:34',NULL),(18,NULL,17,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:36','2022-10-11 00:26:36',NULL),(19,NULL,18,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:38','2022-10-11 00:26:38',NULL),(20,NULL,19,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:39','2022-10-11 00:26:39',NULL),(21,NULL,20,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:41','2022-10-11 00:26:41',NULL),(22,NULL,21,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:44','2022-10-11 00:26:44',NULL),(23,NULL,22,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:46','2022-10-11 00:26:46',NULL),(24,NULL,23,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:48','2022-10-11 00:26:48',NULL),(25,NULL,24,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:49','2022-10-11 00:26:49',NULL),(26,NULL,25,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:51','2022-10-11 00:26:51',NULL),(27,NULL,26,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:53','2022-10-11 00:26:53',NULL),(28,NULL,27,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:55','2022-10-11 00:26:55',NULL),(29,NULL,28,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:26:58','2022-10-11 00:26:58',NULL),(30,NULL,29,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:00','2022-10-11 00:27:00',NULL),(31,NULL,30,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:02','2022-10-11 00:27:02',NULL),(32,NULL,31,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:04','2022-10-11 00:27:04',NULL),(33,NULL,32,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:05','2022-10-11 00:27:05',NULL),(34,NULL,33,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:07','2022-10-11 00:27:07',NULL),(35,NULL,34,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:10','2022-10-11 00:27:10',NULL),(36,NULL,35,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:13','2022-10-11 00:27:13',NULL),(37,NULL,36,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:14','2022-10-11 00:27:14',NULL),(38,NULL,37,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:16','2022-10-11 00:27:16',NULL),(39,NULL,38,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:18','2022-10-11 00:27:18',NULL),(40,NULL,39,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:20','2022-10-11 00:27:20',NULL),(41,NULL,40,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:21','2022-10-11 00:27:21',NULL),(42,NULL,41,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:24','2022-10-11 00:27:24',NULL),(43,NULL,42,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:27','2022-10-11 00:27:27',NULL),(44,NULL,43,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:28','2022-10-11 00:27:28',NULL);
INSERT INTO `balance_libro_details` VALUES (45,NULL,44,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:30','2022-10-11 00:27:30',NULL),(46,NULL,45,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:32','2022-10-11 00:27:32',NULL),(47,NULL,46,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:33','2022-10-11 00:27:33',NULL),(48,NULL,47,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:35','2022-10-11 00:27:35',NULL),(49,NULL,48,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:38','2022-10-11 00:27:38',NULL),(50,NULL,49,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:41','2022-10-11 00:27:41',NULL),(51,NULL,50,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:42','2022-10-11 00:27:42',NULL),(52,NULL,51,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:44','2022-10-11 00:27:44',NULL),(53,NULL,52,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:46','2022-10-11 00:27:46',NULL),(54,NULL,53,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:47','2022-10-11 00:27:47',NULL),(55,NULL,54,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:49','2022-10-11 00:27:49',NULL),(56,NULL,55,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:52','2022-10-11 00:27:52',NULL),(57,NULL,56,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:55','2022-10-11 00:27:55',NULL),(58,NULL,57,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:56','2022-10-11 00:27:56',NULL),(59,NULL,58,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:27:58','2022-10-11 00:27:58',NULL),(60,NULL,59,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:00','2022-10-11 00:28:00',NULL),(61,NULL,60,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:02','2022-10-11 00:28:02',NULL),(62,NULL,61,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:03','2022-10-11 00:28:03',NULL),(63,NULL,62,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:06','2022-10-11 00:28:06',NULL),(64,NULL,63,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:08','2022-10-11 00:28:08',NULL),(65,NULL,64,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:10','2022-10-11 00:28:10',NULL),(66,NULL,65,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:11','2022-10-11 00:28:11',NULL),(67,NULL,66,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:13','2022-10-11 00:28:13',NULL),(68,NULL,67,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:15','2022-10-11 00:28:15',NULL),(69,NULL,68,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:16','2022-10-11 00:28:16',NULL),(70,NULL,69,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:19','2022-10-11 00:28:19',NULL),(71,NULL,70,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:22','2022-10-11 00:28:22',NULL),(72,NULL,71,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:23','2022-10-11 00:28:23',NULL),(73,NULL,72,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:25','2022-10-11 00:28:25',NULL),(74,NULL,73,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:27','2022-10-11 00:28:27',NULL),(75,NULL,74,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:28','2022-10-11 00:28:28',NULL),(76,NULL,75,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:30','2022-10-11 00:28:30',NULL),(77,NULL,76,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:33','2022-10-11 00:28:33',NULL),(78,NULL,77,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:35','2022-10-11 00:28:35',NULL),(79,NULL,78,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:37','2022-10-11 00:28:37',NULL),(80,NULL,79,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:39','2022-10-11 00:28:39',NULL),(81,NULL,80,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:40','2022-10-11 00:28:40',NULL),(82,NULL,81,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:42','2022-10-11 00:28:42',NULL),(83,NULL,82,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:44','2022-10-11 00:28:44',NULL),(84,NULL,83,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:48','2022-10-11 00:28:48',NULL),(85,NULL,84,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:49','2022-10-11 00:28:49',NULL),(86,NULL,85,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:51','2022-10-11 00:28:51',NULL),(87,NULL,86,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:53','2022-10-11 00:28:53',NULL),(88,NULL,87,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:55','2022-10-11 00:28:55',NULL);
INSERT INTO `balance_libro_details` VALUES (89,NULL,88,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:56','2022-10-11 00:28:56',NULL),(90,NULL,89,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:28:59','2022-10-11 00:28:59',NULL),(91,NULL,90,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:01','2022-10-11 00:29:01',NULL),(92,NULL,91,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:03','2022-10-11 00:29:03',NULL),(93,NULL,92,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:05','2022-10-11 00:29:05',NULL),(94,NULL,93,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:07','2022-10-11 00:29:07',NULL),(95,NULL,94,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:09','2022-10-11 00:29:09',NULL),(96,NULL,95,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:10','2022-10-11 00:29:10',NULL),(97,NULL,96,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:13','2022-10-11 00:29:13',NULL),(98,NULL,97,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:15','2022-10-11 00:29:15',NULL),(99,NULL,98,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:17','2022-10-11 00:29:17',NULL),(100,NULL,99,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:18','2022-10-11 00:29:18',NULL),(101,NULL,100,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:20','2022-10-11 00:29:20',NULL),(102,NULL,101,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:22','2022-10-11 00:29:22',NULL),(103,NULL,102,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:24','2022-10-11 00:29:24',NULL),(104,NULL,103,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:27','2022-10-11 00:29:27',NULL),(105,NULL,104,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:29','2022-10-11 00:29:29',NULL),(106,NULL,105,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:31','2022-10-11 00:29:31',NULL),(107,NULL,106,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:32','2022-10-11 00:29:32',NULL),(108,NULL,107,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:34','2022-10-11 00:29:34',NULL),(109,NULL,108,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:36','2022-10-11 00:29:36',NULL),(110,NULL,109,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:38','2022-10-11 00:29:38',NULL),(111,NULL,110,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:40','2022-10-11 00:29:40',NULL),(112,NULL,111,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:42','2022-10-11 00:29:42',NULL),(113,NULL,112,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:44','2022-10-11 00:29:44',NULL),(114,NULL,113,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:45','2022-10-11 00:29:45',NULL),(115,NULL,114,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:47','2022-10-11 00:29:47',NULL),(116,NULL,115,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:49','2022-10-11 00:29:49',NULL),(117,NULL,116,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:51','2022-10-11 00:29:51',NULL),(118,NULL,117,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:54','2022-10-11 00:29:54',NULL),(119,NULL,118,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:55','2022-10-11 00:29:55',NULL),(120,NULL,119,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:57','2022-10-11 00:29:57',NULL),(121,NULL,120,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:29:59','2022-10-11 00:29:59',NULL),(122,NULL,121,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:01','2022-10-11 00:30:01',NULL),(123,NULL,122,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:03','2022-10-11 00:30:03',NULL),(124,NULL,123,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:06','2022-10-11 00:30:06',NULL),(125,NULL,124,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:08','2022-10-11 00:30:08',NULL),(126,NULL,125,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:09','2022-10-11 00:30:09',NULL),(127,NULL,126,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:11','2022-10-11 00:30:11',NULL),(128,NULL,127,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:13','2022-10-11 00:30:13',NULL),(129,NULL,128,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:15','2022-10-11 00:30:15',NULL),(130,NULL,129,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:19','2022-10-11 00:30:19',NULL),(131,NULL,130,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:21','2022-10-11 00:30:21',NULL);
INSERT INTO `balance_libro_details` VALUES (132,NULL,131,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:22','2022-10-11 00:30:22',NULL),(133,NULL,132,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:24','2022-10-11 00:30:24',NULL),(134,NULL,133,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:26','2022-10-11 00:30:26',NULL),(135,NULL,134,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:28','2022-10-11 00:30:28',NULL),(136,NULL,135,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:30','2022-10-11 00:30:30',NULL),(137,NULL,136,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:33','2022-10-11 00:30:33',NULL),(138,NULL,137,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:35','2022-10-11 00:30:35',NULL),(139,NULL,138,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:37','2022-10-11 00:30:37',NULL),(140,NULL,139,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:39','2022-10-11 00:30:39',NULL),(141,NULL,140,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:41','2022-10-11 00:30:41',NULL),(142,NULL,141,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:42','2022-10-11 00:30:42',NULL),(143,NULL,142,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:46','2022-10-11 00:30:46',NULL),(144,NULL,143,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:48','2022-10-11 00:30:48',NULL),(145,NULL,144,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:50','2022-10-11 00:30:50',NULL),(146,NULL,145,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:52','2022-10-11 00:30:52',NULL),(147,NULL,146,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:53','2022-10-11 00:30:53',NULL),(148,NULL,147,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:55','2022-10-11 00:30:55',NULL),(149,NULL,148,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:30:57','2022-10-11 00:30:57',NULL),(150,NULL,149,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:01','2022-10-11 00:31:01',NULL),(151,NULL,150,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:03','2022-10-11 00:31:03',NULL),(152,NULL,151,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:05','2022-10-11 00:31:05',NULL),(153,NULL,152,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:07','2022-10-11 00:31:07',NULL),(154,NULL,153,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:09','2022-10-11 00:31:09',NULL),(155,NULL,154,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:11','2022-10-11 00:31:11',NULL),(156,NULL,155,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:15','2022-10-11 00:31:15',NULL),(157,NULL,156,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:17','2022-10-11 00:31:17',NULL),(158,NULL,157,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:19','2022-10-11 00:31:19',NULL),(159,NULL,158,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:21','2022-10-11 00:31:21',NULL),(160,NULL,159,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:23','2022-10-11 00:31:23',NULL),(161,NULL,160,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:25','2022-10-11 00:31:25',NULL),(162,NULL,161,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:28','2022-10-11 00:31:28',NULL),(163,NULL,162,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:30','2022-10-11 00:31:30',NULL),(164,NULL,163,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:32','2022-10-11 00:31:32',NULL),(165,NULL,164,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:34','2022-10-11 00:31:34',NULL),(166,NULL,165,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:35','2022-10-11 00:31:35',NULL),(167,NULL,166,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:37','2022-10-11 00:31:37',NULL),(168,NULL,167,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:39','2022-10-11 00:31:39',NULL),(169,NULL,168,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:42','2022-10-11 00:31:42',NULL),(170,NULL,169,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:44','2022-10-11 00:31:44',NULL),(171,NULL,170,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:46','2022-10-11 00:31:46',NULL),(172,NULL,171,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:48','2022-10-11 00:31:48',NULL),(173,NULL,172,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:50','2022-10-11 00:31:50',NULL),(174,NULL,173,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:52','2022-10-11 00:31:52',NULL);
INSERT INTO `balance_libro_details` VALUES (175,NULL,174,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:54','2022-10-11 00:31:54',NULL),(176,NULL,175,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:56','2022-10-11 00:31:56',NULL),(177,NULL,176,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:31:58','2022-10-11 00:31:58',NULL),(178,NULL,177,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:00','2022-10-11 00:32:00',NULL),(179,NULL,178,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:02','2022-10-11 00:32:02',NULL),(180,NULL,179,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:05','2022-10-11 00:32:05',NULL),(181,NULL,180,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:07','2022-10-11 00:32:07',NULL),(182,NULL,181,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:09','2022-10-11 00:32:09',NULL),(183,NULL,182,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:11','2022-10-11 00:32:11',NULL),(184,NULL,183,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:13','2022-10-11 00:32:13',NULL),(185,NULL,184,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:15','2022-10-11 00:32:15',NULL),(186,NULL,185,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:17','2022-10-11 00:32:17',NULL),(187,NULL,186,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:20','2022-10-11 00:32:20',NULL),(188,NULL,187,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:22','2022-10-11 00:32:22',NULL),(189,NULL,188,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:24','2022-10-11 00:32:24',NULL),(190,NULL,189,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:25','2022-10-11 00:32:25',NULL),(191,NULL,190,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:28','2022-10-11 00:32:28',NULL),(192,NULL,191,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:29','2022-10-11 00:32:29',NULL),(193,NULL,192,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:33','2022-10-11 00:32:33',NULL),(194,NULL,193,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:35','2022-10-11 00:32:35',NULL),(195,NULL,194,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:37','2022-10-11 00:32:37',NULL),(196,NULL,195,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:38','2022-10-11 00:32:38',NULL),(197,NULL,196,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:41','2022-10-11 00:32:41',NULL),(198,NULL,197,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:43','2022-10-11 00:32:43',NULL),(199,NULL,198,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:45','2022-10-11 00:32:45',NULL),(200,NULL,199,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:47','2022-10-11 00:32:47',NULL),(201,NULL,200,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:49','2022-10-11 00:32:49',NULL),(202,NULL,201,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:51','2022-10-11 00:32:51',NULL),(203,NULL,202,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:53','2022-10-11 00:32:53',NULL),(204,NULL,203,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:55','2022-10-11 00:32:55',NULL),(205,NULL,204,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:32:58','2022-10-11 00:32:58',NULL),(206,NULL,205,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:00','2022-10-11 00:33:00',NULL),(207,NULL,206,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:02','2022-10-11 00:33:02',NULL),(208,NULL,207,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:04','2022-10-11 00:33:04',NULL),(209,NULL,208,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:06','2022-10-11 00:33:06',NULL),(210,NULL,209,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:08','2022-10-11 00:33:08',NULL),(211,NULL,210,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:11','2022-10-11 00:33:11',NULL),(212,NULL,211,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:13','2022-10-11 00:33:13',NULL),(213,NULL,212,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:15','2022-10-11 00:33:15',NULL),(214,NULL,213,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:17','2022-10-11 00:33:17',NULL),(215,NULL,214,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:19','2022-10-11 00:33:19',NULL),(216,NULL,215,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:21','2022-10-11 00:33:21',NULL),(217,NULL,216,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:23','2022-10-11 00:33:23',NULL);
INSERT INTO `balance_libro_details` VALUES (218,NULL,217,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:25','2022-10-11 00:33:25',NULL),(219,NULL,218,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:27','2022-10-11 00:33:27',NULL),(220,NULL,219,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:29','2022-10-11 00:33:29',NULL),(221,NULL,220,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:31','2022-10-11 00:33:31',NULL),(222,NULL,221,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:34','2022-10-11 00:33:34',NULL),(223,NULL,222,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:36','2022-10-11 00:33:36',NULL),(224,NULL,223,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:38','2022-10-11 00:33:38',NULL),(225,NULL,224,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:40','2022-10-11 00:33:40',NULL),(226,NULL,225,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:42','2022-10-11 00:33:42',NULL),(227,NULL,226,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:45','2022-10-11 00:33:45',NULL),(228,NULL,227,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:47','2022-10-11 00:33:47',NULL),(229,NULL,228,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:49','2022-10-11 00:33:49',NULL),(230,NULL,229,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:51','2022-10-11 00:33:51',NULL),(231,NULL,230,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:53','2022-10-11 00:33:53',NULL),(232,NULL,231,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:55','2022-10-11 00:33:55',NULL),(233,NULL,232,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:33:57','2022-10-11 00:33:57',NULL),(234,NULL,233,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:00','2022-10-11 00:34:00',NULL),(235,NULL,234,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:02','2022-10-11 00:34:02',NULL),(236,NULL,235,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:04','2022-10-11 00:34:04',NULL),(237,NULL,236,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:06','2022-10-11 00:34:06',NULL),(238,NULL,237,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:08','2022-10-11 00:34:08',NULL),(239,NULL,238,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:11','2022-10-11 00:34:11',NULL),(240,NULL,239,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:13','2022-10-11 00:34:13',NULL),(241,NULL,240,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:15','2022-10-11 00:34:15',NULL),(242,NULL,241,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:17','2022-10-11 00:34:17',NULL),(243,NULL,242,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:19','2022-10-11 00:34:19',NULL),(244,NULL,243,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:21','2022-10-11 00:34:21',NULL),(245,NULL,244,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:23','2022-10-11 00:34:23',NULL),(246,NULL,245,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:26','2022-10-11 00:34:26',NULL),(247,NULL,246,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:28','2022-10-11 00:34:28',NULL),(248,NULL,247,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:30','2022-10-11 00:34:30',NULL),(249,NULL,248,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:32','2022-10-11 00:34:32',NULL),(250,NULL,249,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:34','2022-10-11 00:34:34',NULL),(251,NULL,250,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:36','2022-10-11 00:34:36',NULL),(252,NULL,251,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:38','2022-10-11 00:34:38',NULL),(253,NULL,252,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:41','2022-10-11 00:34:41',NULL),(254,NULL,253,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:43','2022-10-11 00:34:43',NULL),(255,NULL,254,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:45','2022-10-11 00:34:45',NULL),(256,NULL,255,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:48','2022-10-11 00:34:48',NULL),(257,NULL,256,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:50','2022-10-11 00:34:50',NULL),(258,NULL,257,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:52','2022-10-11 00:34:52',NULL),(259,NULL,258,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:54','2022-10-11 00:34:54',NULL),(260,NULL,259,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:56','2022-10-11 00:34:56',NULL);
INSERT INTO `balance_libro_details` VALUES (261,NULL,260,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:34:58','2022-10-11 00:34:58',NULL),(262,NULL,261,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:00','2022-10-11 00:35:00',NULL),(263,NULL,262,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:03','2022-10-11 00:35:03',NULL),(264,NULL,263,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:05','2022-10-11 00:35:05',NULL),(265,NULL,264,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:07','2022-10-11 00:35:07',NULL),(266,NULL,265,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:10','2022-10-11 00:35:10',NULL),(267,NULL,266,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:12','2022-10-11 00:35:12',NULL),(268,NULL,267,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:14','2022-10-11 00:35:14',NULL),(269,NULL,268,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:16','2022-10-11 00:35:16',NULL),(270,NULL,269,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:18','2022-10-11 00:35:18',NULL),(271,NULL,270,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:20','2022-10-11 00:35:20',NULL),(272,NULL,271,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:23','2022-10-11 00:35:23',NULL),(273,NULL,272,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:25','2022-10-11 00:35:25',NULL),(274,NULL,273,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:27','2022-10-11 00:35:27',NULL),(275,NULL,274,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:29','2022-10-11 00:35:29',NULL),(276,NULL,275,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:31','2022-10-11 00:35:31',NULL),(277,NULL,276,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:34','2022-10-11 00:35:34',NULL),(278,NULL,277,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:37','2022-10-11 00:35:37',NULL),(279,NULL,278,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:39','2022-10-11 00:35:39',NULL),(280,NULL,279,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:41','2022-10-11 00:35:41',NULL),(281,NULL,280,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:43','2022-10-11 00:35:43',NULL),(282,NULL,281,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:45','2022-10-11 00:35:45',NULL),(283,NULL,282,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:48','2022-10-11 00:35:48',NULL),(284,NULL,283,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:50','2022-10-11 00:35:50',NULL),(285,NULL,284,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:52','2022-10-11 00:35:52',NULL),(286,NULL,285,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:54','2022-10-11 00:35:54',NULL),(287,NULL,286,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:56','2022-10-11 00:35:56',NULL),(288,NULL,287,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:35:59','2022-10-11 00:35:59',NULL),(289,NULL,288,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:01','2022-10-11 00:36:01',NULL),(290,NULL,289,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:04','2022-10-11 00:36:04',NULL),(291,NULL,290,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:06','2022-10-11 00:36:06',NULL),(292,NULL,291,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:08','2022-10-11 00:36:08',NULL),(293,NULL,292,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:10','2022-10-11 00:36:10',NULL),(294,NULL,293,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:13','2022-10-11 00:36:13',NULL),(295,NULL,294,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:15','2022-10-11 00:36:15',NULL),(296,NULL,295,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:17','2022-10-11 00:36:17',NULL),(297,NULL,296,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:19','2022-10-11 00:36:19',NULL),(298,NULL,297,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:21','2022-10-11 00:36:21',NULL),(299,NULL,298,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:24','2022-10-11 00:36:24',NULL),(300,NULL,299,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:26','2022-10-11 00:36:26',NULL),(301,NULL,300,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:29','2022-10-11 00:36:29',NULL),(302,NULL,301,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:31','2022-10-11 00:36:31',NULL),(303,NULL,302,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:33','2022-10-11 00:36:33',NULL);
INSERT INTO `balance_libro_details` VALUES (304,NULL,303,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:35','2022-10-11 00:36:35',NULL),(305,NULL,304,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:37','2022-10-11 00:36:37',NULL),(306,NULL,305,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:40','2022-10-11 00:36:40',NULL),(307,NULL,306,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:42','2022-10-11 00:36:42',NULL),(308,NULL,307,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:44','2022-10-11 00:36:44',NULL),(309,NULL,308,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:46','2022-10-11 00:36:46',NULL),(310,NULL,309,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:48','2022-10-11 00:36:48',NULL),(311,NULL,310,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:50','2022-10-11 00:36:50',NULL),(312,NULL,311,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:52','2022-10-11 00:36:52',NULL),(313,NULL,312,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:54','2022-10-11 00:36:54',NULL),(314,NULL,313,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:57','2022-10-11 00:36:57',NULL),(315,NULL,314,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:36:59','2022-10-11 00:36:59',NULL),(316,NULL,315,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:37:02','2022-10-11 00:37:02',NULL),(317,NULL,316,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:37:04','2022-10-11 00:37:04',NULL),(318,NULL,317,40720,1584,2,13,1,0.00,NULL,'2022-10-11 00:37:06','2022-10-11 00:37:06',NULL),(319,NULL,318,40720,1584,2,218,2,35.00,NULL,'2022-10-11 00:45:14','2022-10-11 00:45:14',NULL),(320,NULL,318,40720,1584,2,13,1,35.00,NULL,'2022-10-11 00:45:14','2022-10-11 00:45:14',NULL),(321,NULL,319,40720,1584,2,218,2,610.00,NULL,'2022-10-11 00:45:16','2022-10-11 00:45:16',NULL),(322,NULL,319,40720,1584,2,13,1,610.00,NULL,'2022-10-11 00:45:16','2022-10-11 00:45:16',NULL),(323,NULL,320,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:45:18','2022-10-11 00:45:18',NULL),(324,NULL,320,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:45:18','2022-10-11 00:45:18',NULL),(325,NULL,321,40720,1584,2,218,2,330.00,NULL,'2022-10-11 00:45:20','2022-10-11 00:45:20',NULL),(326,NULL,321,40720,1584,2,13,1,330.00,NULL,'2022-10-11 00:45:20','2022-10-11 00:45:20',NULL),(327,NULL,322,40720,1584,2,218,2,900.00,NULL,'2022-10-11 00:45:23','2022-10-11 00:45:23',NULL),(328,NULL,322,40720,1584,2,13,1,900.00,NULL,'2022-10-11 00:45:23','2022-10-11 00:45:23',NULL),(329,NULL,323,40720,1584,2,218,2,370.00,NULL,'2022-10-11 00:45:25','2022-10-11 00:45:25',NULL),(330,NULL,323,40720,1584,2,13,1,370.00,NULL,'2022-10-11 00:45:25','2022-10-11 00:45:25',NULL),(331,NULL,324,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:45:27','2022-10-11 00:45:27',NULL),(332,NULL,324,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:45:27','2022-10-11 00:45:27',NULL),(333,NULL,325,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:45:29','2022-10-11 00:45:29',NULL),(334,NULL,325,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:45:29','2022-10-11 00:45:29',NULL),(335,NULL,326,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:45:31','2022-10-11 00:45:31',NULL),(336,NULL,326,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:45:31','2022-10-11 00:45:31',NULL),(337,NULL,327,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:45:33','2022-10-11 00:45:33',NULL),(338,NULL,327,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:45:33','2022-10-11 00:45:33',NULL),(339,NULL,328,40720,1584,2,218,2,100.00,NULL,'2022-10-11 00:45:36','2022-10-11 00:45:36',NULL),(340,NULL,328,40720,1584,2,13,1,100.00,NULL,'2022-10-11 00:45:36','2022-10-11 00:45:36',NULL),(341,NULL,329,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:45:38','2022-10-11 00:45:38',NULL),(342,NULL,329,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:45:38','2022-10-11 00:45:38',NULL),(343,NULL,330,40720,1584,2,218,2,380.00,NULL,'2022-10-11 00:45:40','2022-10-11 00:45:40',NULL),(344,NULL,330,40720,1584,2,13,1,380.00,NULL,'2022-10-11 00:45:40','2022-10-11 00:45:40',NULL),(345,NULL,331,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:45:42','2022-10-11 00:45:42',NULL);
INSERT INTO `balance_libro_details` VALUES (346,NULL,331,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:45:42','2022-10-11 00:45:42',NULL),(347,NULL,332,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:45:44','2022-10-11 00:45:44',NULL),(348,NULL,332,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:45:44','2022-10-11 00:45:44',NULL),(349,NULL,333,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:45:46','2022-10-11 00:45:46',NULL),(350,NULL,333,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:45:46','2022-10-11 00:45:46',NULL),(351,NULL,334,40720,1584,2,218,2,170.00,NULL,'2022-10-11 00:45:48','2022-10-11 00:45:48',NULL),(352,NULL,334,40720,1584,2,13,1,170.00,NULL,'2022-10-11 00:45:48','2022-10-11 00:45:48',NULL),(353,NULL,335,40720,1584,2,218,2,650.00,NULL,'2022-10-11 00:45:51','2022-10-11 00:45:51',NULL),(354,NULL,335,40720,1584,2,13,1,650.00,NULL,'2022-10-11 00:45:51','2022-10-11 00:45:51',NULL),(355,NULL,336,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:45:53','2022-10-11 00:45:53',NULL),(356,NULL,336,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:45:53','2022-10-11 00:45:53',NULL),(357,NULL,337,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:45:55','2022-10-11 00:45:55',NULL),(358,NULL,337,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:45:55','2022-10-11 00:45:55',NULL),(359,NULL,338,40720,1584,2,218,2,370.00,NULL,'2022-10-11 00:45:57','2022-10-11 00:45:57',NULL),(360,NULL,338,40720,1584,2,13,1,370.00,NULL,'2022-10-11 00:45:57','2022-10-11 00:45:57',NULL),(361,NULL,339,40720,1584,2,218,2,90.00,NULL,'2022-10-11 00:46:00','2022-10-11 00:46:00',NULL),(362,NULL,339,40720,1584,2,13,1,90.00,NULL,'2022-10-11 00:46:00','2022-10-11 00:46:00',NULL),(363,NULL,340,40720,1584,2,218,2,410.00,NULL,'2022-10-11 00:46:02','2022-10-11 00:46:02',NULL),(364,NULL,340,40720,1584,2,13,1,410.00,NULL,'2022-10-11 00:46:02','2022-10-11 00:46:02',NULL),(365,NULL,341,40720,1584,2,218,2,100.00,NULL,'2022-10-11 00:46:05','2022-10-11 00:46:05',NULL),(366,NULL,341,40720,1584,2,13,1,100.00,NULL,'2022-10-11 00:46:05','2022-10-11 00:46:05',NULL),(367,NULL,342,40720,1584,2,218,2,850.00,NULL,'2022-10-11 00:46:07','2022-10-11 00:46:07',NULL),(368,NULL,342,40720,1584,2,13,1,850.00,NULL,'2022-10-11 00:46:07','2022-10-11 00:46:07',NULL),(369,NULL,343,40720,1584,2,218,2,470.00,NULL,'2022-10-11 00:46:09','2022-10-11 00:46:09',NULL),(370,NULL,343,40720,1584,2,13,1,470.00,NULL,'2022-10-11 00:46:09','2022-10-11 00:46:09',NULL),(371,NULL,344,40720,1584,2,218,2,200.00,NULL,'2022-10-11 00:46:11','2022-10-11 00:46:11',NULL),(372,NULL,344,40720,1584,2,13,1,200.00,NULL,'2022-10-11 00:46:11','2022-10-11 00:46:11',NULL),(373,NULL,345,40720,1584,2,218,2,190.00,NULL,'2022-10-11 00:46:13','2022-10-11 00:46:13',NULL),(374,NULL,345,40720,1584,2,13,1,190.00,NULL,'2022-10-11 00:46:13','2022-10-11 00:46:13',NULL),(375,NULL,346,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:46:16','2022-10-11 00:46:16',NULL),(376,NULL,346,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:46:16','2022-10-11 00:46:16',NULL),(377,NULL,347,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:46:18','2022-10-11 00:46:18',NULL),(378,NULL,347,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:46:18','2022-10-11 00:46:18',NULL),(379,NULL,348,40720,1584,2,218,2,990.00,NULL,'2022-10-11 00:46:20','2022-10-11 00:46:20',NULL),(380,NULL,348,40720,1584,2,13,1,990.00,NULL,'2022-10-11 00:46:20','2022-10-11 00:46:20',NULL),(381,NULL,349,40720,1584,2,218,2,230.00,NULL,'2022-10-11 00:46:23','2022-10-11 00:46:23',NULL),(382,NULL,349,40720,1584,2,13,1,230.00,NULL,'2022-10-11 00:46:23','2022-10-11 00:46:23',NULL),(383,NULL,350,40720,1584,2,218,2,60.00,NULL,'2022-10-11 00:46:25','2022-10-11 00:46:25',NULL),(384,NULL,350,40720,1584,2,13,1,60.00,NULL,'2022-10-11 00:46:25','2022-10-11 00:46:25',NULL),(385,NULL,351,40720,1584,2,218,2,310.00,NULL,'2022-10-11 00:46:27','2022-10-11 00:46:27',NULL),(386,NULL,351,40720,1584,2,13,1,310.00,NULL,'2022-10-11 00:46:27','2022-10-11 00:46:27',NULL),(387,NULL,352,40720,1584,2,218,2,270.00,NULL,'2022-10-11 00:46:29','2022-10-11 00:46:29',NULL);
INSERT INTO `balance_libro_details` VALUES (388,NULL,352,40720,1584,2,13,1,270.00,NULL,'2022-10-11 00:46:29','2022-10-11 00:46:29',NULL),(389,NULL,353,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:46:32','2022-10-11 00:46:32',NULL),(390,NULL,353,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:46:32','2022-10-11 00:46:32',NULL),(391,NULL,354,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:46:34','2022-10-11 00:46:34',NULL),(392,NULL,354,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:46:34','2022-10-11 00:46:34',NULL),(393,NULL,355,40720,1584,2,218,2,150.00,NULL,'2022-10-11 00:46:36','2022-10-11 00:46:36',NULL),(394,NULL,355,40720,1584,2,13,1,150.00,NULL,'2022-10-11 00:46:36','2022-10-11 00:46:36',NULL),(395,NULL,356,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:46:39','2022-10-11 00:46:39',NULL),(396,NULL,356,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:46:39','2022-10-11 00:46:39',NULL),(397,NULL,357,40720,1584,2,218,2,450.00,NULL,'2022-10-11 00:46:41','2022-10-11 00:46:41',NULL),(398,NULL,357,40720,1584,2,13,1,450.00,NULL,'2022-10-11 00:46:41','2022-10-11 00:46:41',NULL),(399,NULL,358,40720,1584,2,218,2,550.00,NULL,'2022-10-11 00:46:43','2022-10-11 00:46:43',NULL),(400,NULL,358,40720,1584,2,13,1,550.00,NULL,'2022-10-11 00:46:43','2022-10-11 00:46:43',NULL),(401,NULL,359,40720,1584,2,218,2,330.00,NULL,'2022-10-11 00:46:46','2022-10-11 00:46:46',NULL),(402,NULL,359,40720,1584,2,13,1,330.00,NULL,'2022-10-11 00:46:46','2022-10-11 00:46:46',NULL),(403,NULL,360,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:46:48','2022-10-11 00:46:48',NULL),(404,NULL,360,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:46:48','2022-10-11 00:46:48',NULL),(405,NULL,361,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:46:51','2022-10-11 00:46:51',NULL),(406,NULL,361,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:46:51','2022-10-11 00:46:51',NULL),(407,NULL,362,40720,1584,2,218,2,720.00,NULL,'2022-10-11 00:46:53','2022-10-11 00:46:53',NULL),(408,NULL,362,40720,1584,2,13,1,720.00,NULL,'2022-10-11 00:46:53','2022-10-11 00:46:53',NULL),(409,NULL,363,40720,1584,2,218,2,180.00,NULL,'2022-10-11 00:46:56','2022-10-11 00:46:56',NULL),(410,NULL,363,40720,1584,2,13,1,180.00,NULL,'2022-10-11 00:46:56','2022-10-11 00:46:56',NULL),(411,NULL,364,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:46:58','2022-10-11 00:46:58',NULL),(412,NULL,364,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:46:58','2022-10-11 00:46:58',NULL),(413,NULL,365,40720,1584,2,218,2,790.00,NULL,'2022-10-11 00:47:01','2022-10-11 00:47:01',NULL),(414,NULL,365,40720,1584,2,13,1,790.00,NULL,'2022-10-11 00:47:01','2022-10-11 00:47:01',NULL),(415,NULL,366,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:47:03','2022-10-11 00:47:03',NULL),(416,NULL,366,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:47:03','2022-10-11 00:47:03',NULL),(417,NULL,367,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:47:06','2022-10-11 00:47:06',NULL),(418,NULL,367,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:47:06','2022-10-11 00:47:06',NULL),(419,NULL,368,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:47:08','2022-10-11 00:47:08',NULL),(420,NULL,368,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:47:08','2022-10-11 00:47:08',NULL),(421,NULL,369,40720,1584,2,218,2,850.00,NULL,'2022-10-11 00:47:10','2022-10-11 00:47:10',NULL),(422,NULL,369,40720,1584,2,13,1,850.00,NULL,'2022-10-11 00:47:10','2022-10-11 00:47:10',NULL),(423,NULL,370,40720,1584,2,218,2,2600.00,NULL,'2022-10-11 00:47:13','2022-10-11 00:47:13',NULL),(424,NULL,370,40720,1584,2,13,1,2600.00,NULL,'2022-10-11 00:47:13','2022-10-11 00:47:13',NULL),(425,NULL,371,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:47:15','2022-10-11 00:47:15',NULL),(426,NULL,371,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:47:15','2022-10-11 00:47:15',NULL),(427,NULL,372,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:47:17','2022-10-11 00:47:17',NULL),(428,NULL,372,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:47:17','2022-10-11 00:47:17',NULL),(429,NULL,373,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:47:20','2022-10-11 00:47:20',NULL);
INSERT INTO `balance_libro_details` VALUES (430,NULL,373,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:47:20','2022-10-11 00:47:20',NULL),(431,NULL,374,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:47:22','2022-10-11 00:47:22',NULL),(432,NULL,374,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:47:22','2022-10-11 00:47:22',NULL),(433,NULL,375,40720,1584,2,218,2,1580.00,NULL,'2022-10-11 00:47:25','2022-10-11 00:47:25',NULL),(434,NULL,375,40720,1584,2,13,1,1580.00,NULL,'2022-10-11 00:47:25','2022-10-11 00:47:25',NULL),(435,NULL,376,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:47:27','2022-10-11 00:47:27',NULL),(436,NULL,376,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:47:27','2022-10-11 00:47:27',NULL),(437,NULL,377,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:47:29','2022-10-11 00:47:29',NULL),(438,NULL,377,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:47:29','2022-10-11 00:47:29',NULL),(439,NULL,378,40720,1584,2,218,2,480.00,NULL,'2022-10-11 00:47:31','2022-10-11 00:47:31',NULL),(440,NULL,378,40720,1584,2,13,1,480.00,NULL,'2022-10-11 00:47:31','2022-10-11 00:47:31',NULL),(441,NULL,379,40720,1584,2,218,2,530.00,NULL,'2022-10-11 00:47:34','2022-10-11 00:47:34',NULL),(442,NULL,379,40720,1584,2,13,1,530.00,NULL,'2022-10-11 00:47:34','2022-10-11 00:47:34',NULL),(443,NULL,380,40720,1584,2,218,2,550.00,NULL,'2022-10-11 00:47:36','2022-10-11 00:47:36',NULL),(444,NULL,380,40720,1584,2,13,1,550.00,NULL,'2022-10-11 00:47:36','2022-10-11 00:47:36',NULL),(445,NULL,381,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:47:38','2022-10-11 00:47:38',NULL),(446,NULL,381,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:47:38','2022-10-11 00:47:38',NULL),(447,NULL,382,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:47:40','2022-10-11 00:47:40',NULL),(448,NULL,382,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:47:40','2022-10-11 00:47:40',NULL),(449,NULL,383,40720,1584,2,218,2,200.00,NULL,'2022-10-11 00:47:43','2022-10-11 00:47:43',NULL),(450,NULL,383,40720,1584,2,13,1,200.00,NULL,'2022-10-11 00:47:43','2022-10-11 00:47:43',NULL),(451,NULL,384,40720,1584,2,218,2,820.00,NULL,'2022-10-11 00:47:45','2022-10-11 00:47:45',NULL),(452,NULL,384,40720,1584,2,13,1,820.00,NULL,'2022-10-11 00:47:45','2022-10-11 00:47:45',NULL),(453,NULL,385,40720,1584,2,218,2,650.00,NULL,'2022-10-11 00:47:47','2022-10-11 00:47:47',NULL),(454,NULL,385,40720,1584,2,13,1,650.00,NULL,'2022-10-11 00:47:47','2022-10-11 00:47:47',NULL),(455,NULL,386,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:47:49','2022-10-11 00:47:49',NULL),(456,NULL,386,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:47:49','2022-10-11 00:47:49',NULL),(457,NULL,387,40720,1584,2,218,2,630.00,NULL,'2022-10-11 00:47:51','2022-10-11 00:47:51',NULL),(458,NULL,387,40720,1584,2,13,1,630.00,NULL,'2022-10-11 00:47:51','2022-10-11 00:47:51',NULL),(459,NULL,388,40720,1584,2,218,2,100.00,NULL,'2022-10-11 00:47:54','2022-10-11 00:47:54',NULL),(460,NULL,388,40720,1584,2,13,1,100.00,NULL,'2022-10-11 00:47:54','2022-10-11 00:47:54',NULL),(461,NULL,389,40720,1584,2,218,2,170.00,NULL,'2022-10-11 00:47:56','2022-10-11 00:47:56',NULL),(462,NULL,389,40720,1584,2,13,1,170.00,NULL,'2022-10-11 00:47:56','2022-10-11 00:47:56',NULL),(463,NULL,390,40720,1584,2,218,2,330.00,NULL,'2022-10-11 00:47:59','2022-10-11 00:47:59',NULL),(464,NULL,390,40720,1584,2,13,1,330.00,NULL,'2022-10-11 00:47:59','2022-10-11 00:47:59',NULL),(465,NULL,391,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:48:01','2022-10-11 00:48:01',NULL),(466,NULL,391,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:48:01','2022-10-11 00:48:01',NULL),(467,NULL,392,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:48:03','2022-10-11 00:48:03',NULL),(468,NULL,392,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:48:03','2022-10-11 00:48:03',NULL),(469,NULL,393,40720,1584,2,218,2,200.00,NULL,'2022-10-11 00:48:06','2022-10-11 00:48:06',NULL),(470,NULL,393,40720,1584,2,13,1,200.00,NULL,'2022-10-11 00:48:06','2022-10-11 00:48:06',NULL),(471,NULL,394,40720,1584,2,218,2,180.00,NULL,'2022-10-11 00:48:08','2022-10-11 00:48:08',NULL);
INSERT INTO `balance_libro_details` VALUES (472,NULL,394,40720,1584,2,13,1,180.00,NULL,'2022-10-11 00:48:08','2022-10-11 00:48:08',NULL),(473,NULL,395,40720,1584,2,218,2,140.00,NULL,'2022-10-11 00:48:10','2022-10-11 00:48:10',NULL),(474,NULL,395,40720,1584,2,13,1,140.00,NULL,'2022-10-11 00:48:10','2022-10-11 00:48:10',NULL),(475,NULL,396,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:48:13','2022-10-11 00:48:13',NULL),(476,NULL,396,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:48:13','2022-10-11 00:48:13',NULL),(477,NULL,397,40720,1584,2,218,2,670.00,NULL,'2022-10-11 00:48:15','2022-10-11 00:48:15',NULL),(478,NULL,397,40720,1584,2,13,1,670.00,NULL,'2022-10-11 00:48:15','2022-10-11 00:48:15',NULL),(479,NULL,398,40720,1584,2,218,2,800.00,NULL,'2022-10-11 00:48:17','2022-10-11 00:48:17',NULL),(480,NULL,398,40720,1584,2,13,1,800.00,NULL,'2022-10-11 00:48:17','2022-10-11 00:48:17',NULL),(481,NULL,399,40720,1584,2,218,2,170.00,NULL,'2022-10-11 00:48:20','2022-10-11 00:48:20',NULL),(482,NULL,399,40720,1584,2,13,1,170.00,NULL,'2022-10-11 00:48:20','2022-10-11 00:48:20',NULL),(483,NULL,400,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:48:22','2022-10-11 00:48:22',NULL),(484,NULL,400,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:48:22','2022-10-11 00:48:22',NULL),(485,NULL,401,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:48:25','2022-10-11 00:48:25',NULL),(486,NULL,401,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:48:25','2022-10-11 00:48:25',NULL),(487,NULL,402,40720,1584,2,218,2,140.00,NULL,'2022-10-11 00:48:27','2022-10-11 00:48:27',NULL),(488,NULL,402,40720,1584,2,13,1,140.00,NULL,'2022-10-11 00:48:27','2022-10-11 00:48:27',NULL),(489,NULL,403,40720,1584,2,218,2,150.00,NULL,'2022-10-11 00:48:29','2022-10-11 00:48:29',NULL),(490,NULL,403,40720,1584,2,13,1,150.00,NULL,'2022-10-11 00:48:29','2022-10-11 00:48:29',NULL),(491,NULL,404,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:48:31','2022-10-11 00:48:31',NULL),(492,NULL,404,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:48:31','2022-10-11 00:48:31',NULL),(493,NULL,405,40720,1584,2,218,2,470.00,NULL,'2022-10-11 00:48:33','2022-10-11 00:48:33',NULL),(494,NULL,405,40720,1584,2,13,1,470.00,NULL,'2022-10-11 00:48:33','2022-10-11 00:48:33',NULL),(495,NULL,406,40720,1584,2,218,2,670.00,NULL,'2022-10-11 00:48:35','2022-10-11 00:48:35',NULL),(496,NULL,406,40720,1584,2,13,1,670.00,NULL,'2022-10-11 00:48:35','2022-10-11 00:48:35',NULL),(497,NULL,407,40720,1584,2,218,2,160.00,NULL,'2022-10-11 00:48:38','2022-10-11 00:48:38',NULL),(498,NULL,407,40720,1584,2,13,1,160.00,NULL,'2022-10-11 00:48:38','2022-10-11 00:48:38',NULL),(499,NULL,408,40720,1584,2,218,2,250.00,NULL,'2022-10-11 00:48:40','2022-10-11 00:48:40',NULL),(500,NULL,408,40720,1584,2,13,1,250.00,NULL,'2022-10-11 00:48:40','2022-10-11 00:48:40',NULL),(501,NULL,409,40720,1584,2,218,2,440.00,NULL,'2022-10-11 00:48:42','2022-10-11 00:48:42',NULL),(502,NULL,409,40720,1584,2,13,1,440.00,NULL,'2022-10-11 00:48:42','2022-10-11 00:48:42',NULL),(503,NULL,410,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:48:45','2022-10-11 00:48:45',NULL),(504,NULL,410,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:48:45','2022-10-11 00:48:45',NULL),(505,NULL,411,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:48:47','2022-10-11 00:48:47',NULL),(506,NULL,411,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:48:47','2022-10-11 00:48:47',NULL),(507,NULL,412,40720,1584,2,218,2,460.00,NULL,'2022-10-11 00:48:49','2022-10-11 00:48:49',NULL),(508,NULL,412,40720,1584,2,13,1,460.00,NULL,'2022-10-11 00:48:49','2022-10-11 00:48:49',NULL),(509,NULL,413,40720,1584,2,218,2,480.00,NULL,'2022-10-11 00:48:51','2022-10-11 00:48:51',NULL),(510,NULL,413,40720,1584,2,13,1,480.00,NULL,'2022-10-11 00:48:51','2022-10-11 00:48:51',NULL),(511,NULL,414,40720,1584,2,218,2,450.00,NULL,'2022-10-11 00:48:54','2022-10-11 00:48:54',NULL),(512,NULL,414,40720,1584,2,13,1,450.00,NULL,'2022-10-11 00:48:54','2022-10-11 00:48:54',NULL),(513,NULL,415,40720,1584,2,218,2,330.00,NULL,'2022-10-11 00:48:56','2022-10-11 00:48:56',NULL);
INSERT INTO `balance_libro_details` VALUES (514,NULL,415,40720,1584,2,13,1,330.00,NULL,'2022-10-11 00:48:56','2022-10-11 00:48:56',NULL),(515,NULL,416,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:48:58','2022-10-11 00:48:58',NULL),(516,NULL,416,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:48:58','2022-10-11 00:48:58',NULL),(517,NULL,417,40720,1584,2,218,2,470.00,NULL,'2022-10-11 00:49:00','2022-10-11 00:49:00',NULL),(518,NULL,417,40720,1584,2,13,1,470.00,NULL,'2022-10-11 00:49:00','2022-10-11 00:49:00',NULL),(519,NULL,418,40720,1584,2,218,2,500.00,NULL,'2022-10-11 00:49:03','2022-10-11 00:49:03',NULL),(520,NULL,418,40720,1584,2,13,1,500.00,NULL,'2022-10-11 00:49:03','2022-10-11 00:49:03',NULL),(521,NULL,419,40720,1584,2,218,2,260.00,NULL,'2022-10-11 00:49:05','2022-10-11 00:49:05',NULL),(522,NULL,419,40720,1584,2,13,1,260.00,NULL,'2022-10-11 00:49:05','2022-10-11 00:49:05',NULL),(523,NULL,420,40720,1584,2,218,2,500.00,NULL,'2022-10-11 00:49:08','2022-10-11 00:49:08',NULL),(524,NULL,420,40720,1584,2,13,1,500.00,NULL,'2022-10-11 00:49:08','2022-10-11 00:49:08',NULL),(525,NULL,421,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:49:10','2022-10-11 00:49:10',NULL),(526,NULL,421,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:49:10','2022-10-11 00:49:10',NULL),(527,NULL,422,40720,1584,2,218,2,1640.00,NULL,'2022-10-11 00:49:12','2022-10-11 00:49:12',NULL),(528,NULL,422,40720,1584,2,13,1,1640.00,NULL,'2022-10-11 00:49:12','2022-10-11 00:49:12',NULL),(529,NULL,423,40720,1584,2,218,2,390.00,NULL,'2022-10-11 00:49:15','2022-10-11 00:49:15',NULL),(530,NULL,423,40720,1584,2,13,1,390.00,NULL,'2022-10-11 00:49:15','2022-10-11 00:49:15',NULL),(531,NULL,424,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:49:17','2022-10-11 00:49:17',NULL),(532,NULL,424,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:49:17','2022-10-11 00:49:17',NULL),(533,NULL,425,40720,1584,2,218,2,140.00,NULL,'2022-10-11 00:49:19','2022-10-11 00:49:19',NULL),(534,NULL,425,40720,1584,2,13,1,140.00,NULL,'2022-10-11 00:49:19','2022-10-11 00:49:19',NULL),(535,NULL,426,40720,1584,2,218,2,770.00,NULL,'2022-10-11 00:49:22','2022-10-11 00:49:22',NULL),(536,NULL,426,40720,1584,2,13,1,770.00,NULL,'2022-10-11 00:49:22','2022-10-11 00:49:22',NULL),(537,NULL,427,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:49:24','2022-10-11 00:49:24',NULL),(538,NULL,427,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:49:24','2022-10-11 00:49:24',NULL),(539,NULL,428,40720,1584,2,218,2,440.00,NULL,'2022-10-11 00:49:26','2022-10-11 00:49:26',NULL),(540,NULL,428,40720,1584,2,13,1,440.00,NULL,'2022-10-11 00:49:26','2022-10-11 00:49:26',NULL),(541,NULL,429,40720,1584,2,218,2,170.00,NULL,'2022-10-11 00:49:29','2022-10-11 00:49:29',NULL),(542,NULL,429,40720,1584,2,13,1,170.00,NULL,'2022-10-11 00:49:29','2022-10-11 00:49:29',NULL),(543,NULL,430,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:49:31','2022-10-11 00:49:31',NULL),(544,NULL,430,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:49:31','2022-10-11 00:49:31',NULL),(545,NULL,431,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:49:33','2022-10-11 00:49:33',NULL),(546,NULL,431,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:49:33','2022-10-11 00:49:33',NULL),(547,NULL,432,40720,1584,2,218,2,290.00,NULL,'2022-10-11 00:49:36','2022-10-11 00:49:36',NULL),(548,NULL,432,40720,1584,2,13,1,290.00,NULL,'2022-10-11 00:49:36','2022-10-11 00:49:36',NULL),(549,NULL,433,40720,1584,2,218,2,260.00,NULL,'2022-10-11 00:49:38','2022-10-11 00:49:38',NULL),(550,NULL,433,40720,1584,2,13,1,260.00,NULL,'2022-10-11 00:49:38','2022-10-11 00:49:38',NULL),(551,NULL,434,40720,1584,2,218,2,270.00,NULL,'2022-10-11 00:49:40','2022-10-11 00:49:40',NULL),(552,NULL,434,40720,1584,2,13,1,270.00,NULL,'2022-10-11 00:49:40','2022-10-11 00:49:40',NULL),(553,NULL,435,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:49:44','2022-10-11 00:49:44',NULL),(554,NULL,435,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:49:44','2022-10-11 00:49:44',NULL),(555,NULL,436,40720,1584,2,218,2,180.00,NULL,'2022-10-11 00:49:46','2022-10-11 00:49:46',NULL);
INSERT INTO `balance_libro_details` VALUES (556,NULL,436,40720,1584,2,13,1,180.00,NULL,'2022-10-11 00:49:46','2022-10-11 00:49:46',NULL),(557,NULL,437,40720,1584,2,218,2,250.00,NULL,'2022-10-11 00:49:49','2022-10-11 00:49:49',NULL),(558,NULL,437,40720,1584,2,13,1,250.00,NULL,'2022-10-11 00:49:49','2022-10-11 00:49:49',NULL),(559,NULL,438,40720,1584,2,218,2,50.00,NULL,'2022-10-11 00:49:51','2022-10-11 00:49:51',NULL),(560,NULL,438,40720,1584,2,13,1,50.00,NULL,'2022-10-11 00:49:51','2022-10-11 00:49:51',NULL),(561,NULL,439,40720,1584,2,218,2,540.00,NULL,'2022-10-11 00:49:53','2022-10-11 00:49:53',NULL),(562,NULL,439,40720,1584,2,13,1,540.00,NULL,'2022-10-11 00:49:53','2022-10-11 00:49:53',NULL),(563,NULL,440,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:49:56','2022-10-11 00:49:56',NULL),(564,NULL,440,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:49:56','2022-10-11 00:49:56',NULL),(565,NULL,441,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:49:58','2022-10-11 00:49:58',NULL),(566,NULL,441,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:49:58','2022-10-11 00:49:58',NULL),(567,NULL,442,40720,1584,2,218,2,540.00,NULL,'2022-10-11 00:50:01','2022-10-11 00:50:01',NULL),(568,NULL,442,40720,1584,2,13,1,540.00,NULL,'2022-10-11 00:50:01','2022-10-11 00:50:01',NULL),(569,NULL,443,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:50:03','2022-10-11 00:50:03',NULL),(570,NULL,443,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:50:03','2022-10-11 00:50:03',NULL),(571,NULL,444,40720,1584,2,218,2,740.00,NULL,'2022-10-11 00:50:05','2022-10-11 00:50:05',NULL),(572,NULL,444,40720,1584,2,13,1,740.00,NULL,'2022-10-11 00:50:05','2022-10-11 00:50:05',NULL),(573,NULL,445,40720,1584,2,218,2,340.00,NULL,'2022-10-11 00:50:08','2022-10-11 00:50:08',NULL),(574,NULL,445,40720,1584,2,13,1,340.00,NULL,'2022-10-11 00:50:08','2022-10-11 00:50:08',NULL),(575,NULL,446,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:50:11','2022-10-11 00:50:11',NULL),(576,NULL,446,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:50:11','2022-10-11 00:50:11',NULL),(577,NULL,447,40720,1584,2,218,2,270.00,NULL,'2022-10-11 00:50:13','2022-10-11 00:50:13',NULL),(578,NULL,447,40720,1584,2,13,1,270.00,NULL,'2022-10-11 00:50:13','2022-10-11 00:50:13',NULL),(579,NULL,448,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:50:15','2022-10-11 00:50:15',NULL),(580,NULL,448,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:50:15','2022-10-11 00:50:15',NULL),(581,NULL,449,40720,1584,2,218,2,260.00,NULL,'2022-10-11 00:50:18','2022-10-11 00:50:18',NULL),(582,NULL,449,40720,1584,2,13,1,260.00,NULL,'2022-10-11 00:50:18','2022-10-11 00:50:18',NULL),(583,NULL,450,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:50:20','2022-10-11 00:50:20',NULL),(584,NULL,450,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:50:20','2022-10-11 00:50:20',NULL),(585,NULL,451,40720,1584,2,218,2,250.00,NULL,'2022-10-11 00:50:22','2022-10-11 00:50:22',NULL),(586,NULL,451,40720,1584,2,13,1,250.00,NULL,'2022-10-11 00:50:22','2022-10-11 00:50:22',NULL),(587,NULL,452,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:50:25','2022-10-11 00:50:25',NULL),(588,NULL,452,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:50:25','2022-10-11 00:50:25',NULL),(589,NULL,453,40720,1584,2,218,2,570.00,NULL,'2022-10-11 00:50:27','2022-10-11 00:50:27',NULL),(590,NULL,453,40720,1584,2,13,1,570.00,NULL,'2022-10-11 00:50:27','2022-10-11 00:50:27',NULL),(591,NULL,454,40720,1584,2,218,2,660.00,NULL,'2022-10-11 00:50:30','2022-10-11 00:50:30',NULL),(592,NULL,454,40720,1584,2,13,1,660.00,NULL,'2022-10-11 00:50:30','2022-10-11 00:50:30',NULL),(593,NULL,455,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:50:32','2022-10-11 00:50:32',NULL),(594,NULL,455,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:50:32','2022-10-11 00:50:32',NULL),(595,NULL,456,40720,1584,2,218,2,550.00,NULL,'2022-10-11 00:50:35','2022-10-11 00:50:35',NULL),(596,NULL,456,40720,1584,2,13,1,550.00,NULL,'2022-10-11 00:50:35','2022-10-11 00:50:35',NULL),(597,NULL,457,40720,1584,2,218,2,560.00,NULL,'2022-10-11 00:50:37','2022-10-11 00:50:37',NULL);
INSERT INTO `balance_libro_details` VALUES (598,NULL,457,40720,1584,2,13,1,560.00,NULL,'2022-10-11 00:50:37','2022-10-11 00:50:37',NULL),(599,NULL,458,40720,1584,2,218,2,460.00,NULL,'2022-10-11 00:50:40','2022-10-11 00:50:40',NULL),(600,NULL,458,40720,1584,2,13,1,460.00,NULL,'2022-10-11 00:50:40','2022-10-11 00:50:40',NULL),(601,NULL,459,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:50:42','2022-10-11 00:50:42',NULL),(602,NULL,459,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:50:42','2022-10-11 00:50:42',NULL),(603,NULL,460,40720,1584,2,218,2,900.00,NULL,'2022-10-11 00:50:45','2022-10-11 00:50:45',NULL),(604,NULL,460,40720,1584,2,13,1,900.00,NULL,'2022-10-11 00:50:45','2022-10-11 00:50:45',NULL),(605,NULL,461,40720,1584,2,218,2,140.00,NULL,'2022-10-11 00:50:47','2022-10-11 00:50:47',NULL),(606,NULL,461,40720,1584,2,13,1,140.00,NULL,'2022-10-11 00:50:47','2022-10-11 00:50:47',NULL),(607,NULL,462,40720,1584,2,218,2,270.00,NULL,'2022-10-11 00:50:49','2022-10-11 00:50:49',NULL),(608,NULL,462,40720,1584,2,13,1,270.00,NULL,'2022-10-11 00:50:49','2022-10-11 00:50:49',NULL),(609,NULL,463,40720,1584,2,218,2,580.00,NULL,'2022-10-11 00:50:52','2022-10-11 00:50:52',NULL),(610,NULL,463,40720,1584,2,13,1,580.00,NULL,'2022-10-11 00:50:52','2022-10-11 00:50:52',NULL),(611,NULL,464,40720,1584,2,218,2,380.00,NULL,'2022-10-11 00:50:55','2022-10-11 00:50:55',NULL),(612,NULL,464,40720,1584,2,13,1,380.00,NULL,'2022-10-11 00:50:55','2022-10-11 00:50:55',NULL),(613,NULL,465,40720,1584,2,218,2,460.00,NULL,'2022-10-11 00:50:57','2022-10-11 00:50:57',NULL),(614,NULL,465,40720,1584,2,13,1,460.00,NULL,'2022-10-11 00:50:57','2022-10-11 00:50:57',NULL),(615,NULL,466,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:51:00','2022-10-11 00:51:00',NULL),(616,NULL,466,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:51:00','2022-10-11 00:51:00',NULL),(617,NULL,467,40720,1584,2,218,2,2120.00,NULL,'2022-10-11 00:51:03','2022-10-11 00:51:03',NULL),(618,NULL,467,40720,1584,2,13,1,2120.00,NULL,'2022-10-11 00:51:03','2022-10-11 00:51:03',NULL),(619,NULL,468,40720,1584,2,218,2,90.00,NULL,'2022-10-11 00:51:06','2022-10-11 00:51:06',NULL),(620,NULL,468,40720,1584,2,13,1,90.00,NULL,'2022-10-11 00:51:06','2022-10-11 00:51:06',NULL),(621,NULL,469,40720,1584,2,218,2,900.00,NULL,'2022-10-11 00:51:09','2022-10-11 00:51:09',NULL),(622,NULL,469,40720,1584,2,13,1,900.00,NULL,'2022-10-11 00:51:09','2022-10-11 00:51:09',NULL),(623,NULL,470,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:51:11','2022-10-11 00:51:11',NULL),(624,NULL,470,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:51:11','2022-10-11 00:51:11',NULL),(625,NULL,471,40720,1584,2,218,2,270.00,NULL,'2022-10-11 00:51:14','2022-10-11 00:51:14',NULL),(626,NULL,471,40720,1584,2,13,1,270.00,NULL,'2022-10-11 00:51:14','2022-10-11 00:51:14',NULL),(627,NULL,472,40720,1584,2,218,2,390.00,NULL,'2022-10-11 00:51:16','2022-10-11 00:51:16',NULL),(628,NULL,472,40720,1584,2,13,1,390.00,NULL,'2022-10-11 00:51:16','2022-10-11 00:51:16',NULL),(629,NULL,473,40720,1584,2,218,2,900.00,NULL,'2022-10-11 00:51:19','2022-10-11 00:51:19',NULL),(630,NULL,473,40720,1584,2,13,1,900.00,NULL,'2022-10-11 00:51:19','2022-10-11 00:51:19',NULL),(631,NULL,474,40720,1584,2,218,2,730.00,NULL,'2022-10-11 00:51:21','2022-10-11 00:51:21',NULL),(632,NULL,474,40720,1584,2,13,1,730.00,NULL,'2022-10-11 00:51:21','2022-10-11 00:51:21',NULL),(633,NULL,475,40720,1584,2,218,2,100.00,NULL,'2022-10-11 00:51:24','2022-10-11 00:51:24',NULL),(634,NULL,475,40720,1584,2,13,1,100.00,NULL,'2022-10-11 00:51:24','2022-10-11 00:51:24',NULL),(635,NULL,476,40720,1584,2,218,2,630.00,NULL,'2022-10-11 00:51:26','2022-10-11 00:51:26',NULL),(636,NULL,476,40720,1584,2,13,1,630.00,NULL,'2022-10-11 00:51:26','2022-10-11 00:51:26',NULL),(637,NULL,477,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:51:29','2022-10-11 00:51:29',NULL),(638,NULL,477,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:51:29','2022-10-11 00:51:29',NULL),(639,NULL,478,40720,1584,2,218,2,550.00,NULL,'2022-10-11 00:51:31','2022-10-11 00:51:31',NULL);
INSERT INTO `balance_libro_details` VALUES (640,NULL,478,40720,1584,2,13,1,550.00,NULL,'2022-10-11 00:51:31','2022-10-11 00:51:31',NULL),(641,NULL,479,40720,1584,2,218,2,270.00,NULL,'2022-10-11 00:51:34','2022-10-11 00:51:34',NULL),(642,NULL,479,40720,1584,2,13,1,270.00,NULL,'2022-10-11 00:51:34','2022-10-11 00:51:34',NULL),(643,NULL,480,40720,1584,2,218,2,500.00,NULL,'2022-10-11 00:51:36','2022-10-11 00:51:36',NULL),(644,NULL,480,40720,1584,2,13,1,500.00,NULL,'2022-10-11 00:51:36','2022-10-11 00:51:36',NULL),(645,NULL,481,40720,1584,2,218,2,250.00,NULL,'2022-10-11 00:51:39','2022-10-11 00:51:39',NULL),(646,NULL,481,40720,1584,2,13,1,250.00,NULL,'2022-10-11 00:51:39','2022-10-11 00:51:39',NULL),(647,NULL,482,40720,1584,2,218,2,170.00,NULL,'2022-10-11 00:51:41','2022-10-11 00:51:41',NULL),(648,NULL,482,40720,1584,2,13,1,170.00,NULL,'2022-10-11 00:51:41','2022-10-11 00:51:41',NULL),(649,NULL,483,40720,1584,2,218,2,650.00,NULL,'2022-10-11 00:51:44','2022-10-11 00:51:44',NULL),(650,NULL,483,40720,1584,2,13,1,650.00,NULL,'2022-10-11 00:51:44','2022-10-11 00:51:44',NULL),(651,NULL,484,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:51:46','2022-10-11 00:51:46',NULL),(652,NULL,484,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:51:46','2022-10-11 00:51:46',NULL),(653,NULL,485,40720,1584,2,218,2,260.00,NULL,'2022-10-11 00:51:49','2022-10-11 00:51:49',NULL),(654,NULL,485,40720,1584,2,13,1,260.00,NULL,'2022-10-11 00:51:49','2022-10-11 00:51:49',NULL),(655,NULL,486,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:51:51','2022-10-11 00:51:51',NULL),(656,NULL,486,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:51:51','2022-10-11 00:51:51',NULL),(657,NULL,487,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:51:54','2022-10-11 00:51:54',NULL),(658,NULL,487,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:51:54','2022-10-11 00:51:54',NULL),(659,NULL,488,40720,1584,2,218,2,490.00,NULL,'2022-10-11 00:51:56','2022-10-11 00:51:56',NULL),(660,NULL,488,40720,1584,2,13,1,490.00,NULL,'2022-10-11 00:51:56','2022-10-11 00:51:56',NULL),(661,NULL,489,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:51:59','2022-10-11 00:51:59',NULL),(662,NULL,489,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:51:59','2022-10-11 00:51:59',NULL),(663,NULL,490,40720,1584,2,218,2,290.00,NULL,'2022-10-11 00:52:01','2022-10-11 00:52:01',NULL),(664,NULL,490,40720,1584,2,13,1,290.00,NULL,'2022-10-11 00:52:01','2022-10-11 00:52:01',NULL),(665,NULL,491,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:52:04','2022-10-11 00:52:04',NULL),(666,NULL,491,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:52:04','2022-10-11 00:52:04',NULL),(667,NULL,492,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:52:06','2022-10-11 00:52:06',NULL),(668,NULL,492,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:52:06','2022-10-11 00:52:06',NULL),(669,NULL,493,40720,1584,2,218,2,460.00,NULL,'2022-10-11 00:52:09','2022-10-11 00:52:09',NULL),(670,NULL,493,40720,1584,2,13,1,460.00,NULL,'2022-10-11 00:52:09','2022-10-11 00:52:09',NULL),(671,NULL,494,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:52:11','2022-10-11 00:52:11',NULL),(672,NULL,494,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:52:11','2022-10-11 00:52:11',NULL),(673,NULL,495,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:52:13','2022-10-11 00:52:13',NULL),(674,NULL,495,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:52:13','2022-10-11 00:52:13',NULL),(675,NULL,496,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:52:16','2022-10-11 00:52:16',NULL),(676,NULL,496,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:52:16','2022-10-11 00:52:16',NULL),(677,NULL,497,40720,1584,2,218,2,2600.00,NULL,'2022-10-11 00:52:18','2022-10-11 00:52:18',NULL),(678,NULL,497,40720,1584,2,13,1,2600.00,NULL,'2022-10-11 00:52:18','2022-10-11 00:52:18',NULL),(679,NULL,498,40720,1584,2,218,2,170.00,NULL,'2022-10-11 00:52:21','2022-10-11 00:52:21',NULL),(680,NULL,498,40720,1584,2,13,1,170.00,NULL,'2022-10-11 00:52:21','2022-10-11 00:52:21',NULL),(681,NULL,499,40720,1584,2,218,2,1090.00,NULL,'2022-10-11 00:52:23','2022-10-11 00:52:23',NULL);
INSERT INTO `balance_libro_details` VALUES (682,NULL,499,40720,1584,2,13,1,1090.00,NULL,'2022-10-11 00:52:23','2022-10-11 00:52:23',NULL),(683,NULL,500,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:52:26','2022-10-11 00:52:26',NULL),(684,NULL,500,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:52:26','2022-10-11 00:52:26',NULL),(685,NULL,501,40720,1584,2,218,2,630.00,NULL,'2022-10-11 00:52:28','2022-10-11 00:52:28',NULL),(686,NULL,501,40720,1584,2,13,1,630.00,NULL,'2022-10-11 00:52:28','2022-10-11 00:52:28',NULL),(687,NULL,502,40720,1584,2,218,2,580.00,NULL,'2022-10-11 00:52:30','2022-10-11 00:52:30',NULL),(688,NULL,502,40720,1584,2,13,1,580.00,NULL,'2022-10-11 00:52:30','2022-10-11 00:52:30',NULL),(689,NULL,503,40720,1584,2,218,2,360.00,NULL,'2022-10-11 00:52:33','2022-10-11 00:52:33',NULL),(690,NULL,503,40720,1584,2,13,1,360.00,NULL,'2022-10-11 00:52:33','2022-10-11 00:52:33',NULL),(691,NULL,504,40720,1584,2,218,2,540.00,NULL,'2022-10-11 00:52:36','2022-10-11 00:52:36',NULL),(692,NULL,504,40720,1584,2,13,1,540.00,NULL,'2022-10-11 00:52:36','2022-10-11 00:52:36',NULL),(693,NULL,505,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:52:39','2022-10-11 00:52:39',NULL),(694,NULL,505,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:52:39','2022-10-11 00:52:39',NULL),(695,NULL,506,40720,1584,2,218,2,820.00,NULL,'2022-10-11 00:52:41','2022-10-11 00:52:41',NULL),(696,NULL,506,40720,1584,2,13,1,820.00,NULL,'2022-10-11 00:52:41','2022-10-11 00:52:41',NULL),(697,NULL,507,40720,1584,2,218,2,1060.00,NULL,'2022-10-11 00:52:44','2022-10-11 00:52:44',NULL),(698,NULL,507,40720,1584,2,13,1,1060.00,NULL,'2022-10-11 00:52:44','2022-10-11 00:52:44',NULL),(699,NULL,508,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:52:46','2022-10-11 00:52:46',NULL),(700,NULL,508,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:52:46','2022-10-11 00:52:46',NULL),(701,NULL,509,40720,1584,2,218,2,360.00,NULL,'2022-10-11 00:52:49','2022-10-11 00:52:49',NULL),(702,NULL,509,40720,1584,2,13,1,360.00,NULL,'2022-10-11 00:52:49','2022-10-11 00:52:49',NULL),(703,NULL,510,40720,1584,2,218,2,440.00,NULL,'2022-10-11 00:52:51','2022-10-11 00:52:51',NULL),(704,NULL,510,40720,1584,2,13,1,440.00,NULL,'2022-10-11 00:52:51','2022-10-11 00:52:51',NULL),(705,NULL,511,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:52:54','2022-10-11 00:52:54',NULL),(706,NULL,511,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:52:54','2022-10-11 00:52:54',NULL),(707,NULL,512,40720,1584,2,218,2,630.00,NULL,'2022-10-11 00:52:56','2022-10-11 00:52:56',NULL),(708,NULL,512,40720,1584,2,13,1,630.00,NULL,'2022-10-11 00:52:56','2022-10-11 00:52:56',NULL),(709,NULL,513,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:52:59','2022-10-11 00:52:59',NULL),(710,NULL,513,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:52:59','2022-10-11 00:52:59',NULL),(711,NULL,514,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:53:02','2022-10-11 00:53:02',NULL),(712,NULL,514,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:53:02','2022-10-11 00:53:02',NULL),(713,NULL,515,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:53:04','2022-10-11 00:53:04',NULL),(714,NULL,515,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:53:04','2022-10-11 00:53:04',NULL),(715,NULL,516,40720,1584,2,218,2,1700.00,NULL,'2022-10-11 00:53:07','2022-10-11 00:53:07',NULL),(716,NULL,516,40720,1584,2,13,1,1700.00,NULL,'2022-10-11 00:53:07','2022-10-11 00:53:07',NULL),(717,NULL,517,40720,1584,2,218,2,290.00,NULL,'2022-10-11 00:53:10','2022-10-11 00:53:10',NULL),(718,NULL,517,40720,1584,2,13,1,290.00,NULL,'2022-10-11 00:53:10','2022-10-11 00:53:10',NULL),(719,NULL,518,40720,1584,2,218,2,200.00,NULL,'2022-10-11 00:53:12','2022-10-11 00:53:12',NULL),(720,NULL,518,40720,1584,2,13,1,200.00,NULL,'2022-10-11 00:53:12','2022-10-11 00:53:12',NULL),(721,NULL,519,40720,1584,2,218,2,670.00,NULL,'2022-10-11 00:53:15','2022-10-11 00:53:15',NULL),(722,NULL,519,40720,1584,2,13,1,670.00,NULL,'2022-10-11 00:53:15','2022-10-11 00:53:15',NULL),(723,NULL,520,40720,1584,2,218,2,140.00,NULL,'2022-10-11 00:53:17','2022-10-11 00:53:17',NULL);
INSERT INTO `balance_libro_details` VALUES (724,NULL,520,40720,1584,2,13,1,140.00,NULL,'2022-10-11 00:53:17','2022-10-11 00:53:17',NULL),(725,NULL,521,40720,1584,2,218,2,560.00,NULL,'2022-10-11 00:53:20','2022-10-11 00:53:20',NULL),(726,NULL,521,40720,1584,2,13,1,560.00,NULL,'2022-10-11 00:53:20','2022-10-11 00:53:20',NULL),(727,NULL,522,40720,1584,2,218,2,260.00,NULL,'2022-10-11 00:53:22','2022-10-11 00:53:22',NULL),(728,NULL,522,40720,1584,2,13,1,260.00,NULL,'2022-10-11 00:53:22','2022-10-11 00:53:22',NULL),(729,NULL,523,40720,1584,2,218,2,600.00,NULL,'2022-10-11 00:53:25','2022-10-11 00:53:25',NULL),(730,NULL,523,40720,1584,2,13,1,600.00,NULL,'2022-10-11 00:53:25','2022-10-11 00:53:25',NULL),(731,NULL,524,40720,1584,2,218,2,740.00,NULL,'2022-10-11 00:53:27','2022-10-11 00:53:27',NULL),(732,NULL,524,40720,1584,2,13,1,740.00,NULL,'2022-10-11 00:53:27','2022-10-11 00:53:27',NULL),(733,NULL,525,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:53:30','2022-10-11 00:53:30',NULL),(734,NULL,525,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:53:30','2022-10-11 00:53:30',NULL),(735,NULL,526,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:53:33','2022-10-11 00:53:33',NULL),(736,NULL,526,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:53:33','2022-10-11 00:53:33',NULL),(737,NULL,527,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:53:35','2022-10-11 00:53:35',NULL),(738,NULL,527,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:53:35','2022-10-11 00:53:35',NULL),(739,NULL,528,40720,1584,2,218,2,830.00,NULL,'2022-10-11 00:53:38','2022-10-11 00:53:38',NULL),(740,NULL,528,40720,1584,2,13,1,830.00,NULL,'2022-10-11 00:53:38','2022-10-11 00:53:38',NULL),(741,NULL,529,40720,1584,2,218,2,260.00,NULL,'2022-10-11 00:53:40','2022-10-11 00:53:40',NULL),(742,NULL,529,40720,1584,2,13,1,260.00,NULL,'2022-10-11 00:53:40','2022-10-11 00:53:40',NULL),(743,NULL,530,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:53:43','2022-10-11 00:53:43',NULL),(744,NULL,530,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:53:43','2022-10-11 00:53:43',NULL),(745,NULL,531,40720,1584,2,218,2,90.00,NULL,'2022-10-11 00:53:45','2022-10-11 00:53:45',NULL),(746,NULL,531,40720,1584,2,13,1,90.00,NULL,'2022-10-11 00:53:45','2022-10-11 00:53:45',NULL),(747,NULL,532,40720,1584,2,218,2,350.00,NULL,'2022-10-11 00:53:48','2022-10-11 00:53:48',NULL),(748,NULL,532,40720,1584,2,13,1,350.00,NULL,'2022-10-11 00:53:48','2022-10-11 00:53:48',NULL),(749,NULL,533,40720,1584,2,218,2,640.00,NULL,'2022-10-11 00:53:50','2022-10-11 00:53:50',NULL),(750,NULL,533,40720,1584,2,13,1,640.00,NULL,'2022-10-11 00:53:50','2022-10-11 00:53:50',NULL),(751,NULL,534,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:53:53','2022-10-11 00:53:53',NULL),(752,NULL,534,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:53:53','2022-10-11 00:53:53',NULL),(753,NULL,535,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:53:56','2022-10-11 00:53:56',NULL),(754,NULL,535,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:53:56','2022-10-11 00:53:56',NULL),(755,NULL,536,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:53:58','2022-10-11 00:53:58',NULL),(756,NULL,536,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:53:58','2022-10-11 00:53:58',NULL),(757,NULL,537,40720,1584,2,218,2,840.00,NULL,'2022-10-11 00:54:00','2022-10-11 00:54:00',NULL),(758,NULL,537,40720,1584,2,13,1,840.00,NULL,'2022-10-11 00:54:00','2022-10-11 00:54:00',NULL),(759,NULL,538,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:54:03','2022-10-11 00:54:03',NULL),(760,NULL,538,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:54:03','2022-10-11 00:54:03',NULL),(761,NULL,539,40720,1584,2,218,2,600.00,NULL,'2022-10-11 00:54:06','2022-10-11 00:54:06',NULL),(762,NULL,539,40720,1584,2,13,1,600.00,NULL,'2022-10-11 00:54:06','2022-10-11 00:54:06',NULL),(763,NULL,540,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:54:08','2022-10-11 00:54:08',NULL),(764,NULL,540,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:54:08','2022-10-11 00:54:08',NULL),(765,NULL,541,40720,1584,2,218,2,290.00,NULL,'2022-10-11 00:54:10','2022-10-11 00:54:10',NULL);
INSERT INTO `balance_libro_details` VALUES (766,NULL,541,40720,1584,2,13,1,290.00,NULL,'2022-10-11 00:54:10','2022-10-11 00:54:10',NULL),(767,NULL,542,40720,1584,2,218,2,180.00,NULL,'2022-10-11 00:54:13','2022-10-11 00:54:13',NULL),(768,NULL,542,40720,1584,2,13,1,180.00,NULL,'2022-10-11 00:54:13','2022-10-11 00:54:13',NULL),(769,NULL,543,40720,1584,2,218,2,530.00,NULL,'2022-10-11 00:54:16','2022-10-11 00:54:16',NULL),(770,NULL,543,40720,1584,2,13,1,530.00,NULL,'2022-10-11 00:54:16','2022-10-11 00:54:16',NULL),(771,NULL,544,40720,1584,2,218,2,300.00,NULL,'2022-10-11 00:54:18','2022-10-11 00:54:18',NULL),(772,NULL,544,40720,1584,2,13,1,300.00,NULL,'2022-10-11 00:54:18','2022-10-11 00:54:18',NULL),(773,NULL,545,40720,1584,2,218,2,90.00,NULL,'2022-10-11 00:54:20','2022-10-11 00:54:20',NULL),(774,NULL,545,40720,1584,2,13,1,90.00,NULL,'2022-10-11 00:54:20','2022-10-11 00:54:20',NULL),(775,NULL,546,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:54:23','2022-10-11 00:54:23',NULL),(776,NULL,546,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:54:23','2022-10-11 00:54:23',NULL),(777,NULL,547,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:54:25','2022-10-11 00:54:25',NULL),(778,NULL,547,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:54:25','2022-10-11 00:54:25',NULL),(779,NULL,548,40720,1584,2,218,2,140.00,NULL,'2022-10-11 00:54:28','2022-10-11 00:54:28',NULL),(780,NULL,548,40720,1584,2,13,1,140.00,NULL,'2022-10-11 00:54:28','2022-10-11 00:54:28',NULL),(781,NULL,549,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:54:30','2022-10-11 00:54:30',NULL),(782,NULL,549,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:54:30','2022-10-11 00:54:30',NULL),(783,NULL,550,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:54:33','2022-10-11 00:54:33',NULL),(784,NULL,550,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:54:33','2022-10-11 00:54:33',NULL),(785,NULL,551,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:54:35','2022-10-11 00:54:35',NULL),(786,NULL,551,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:54:35','2022-10-11 00:54:35',NULL),(787,NULL,552,40720,1584,2,218,2,540.00,NULL,'2022-10-11 00:54:38','2022-10-11 00:54:38',NULL),(788,NULL,552,40720,1584,2,13,1,540.00,NULL,'2022-10-11 00:54:38','2022-10-11 00:54:38',NULL),(789,NULL,553,40720,1584,2,218,2,540.00,NULL,'2022-10-11 00:54:41','2022-10-11 00:54:41',NULL),(790,NULL,553,40720,1584,2,13,1,540.00,NULL,'2022-10-11 00:54:41','2022-10-11 00:54:41',NULL),(791,NULL,554,40720,1584,2,218,2,260.00,NULL,'2022-10-11 00:54:44','2022-10-11 00:54:44',NULL),(792,NULL,554,40720,1584,2,13,1,260.00,NULL,'2022-10-11 00:54:44','2022-10-11 00:54:44',NULL),(793,NULL,555,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:54:46','2022-10-11 00:54:46',NULL),(794,NULL,555,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:54:46','2022-10-11 00:54:46',NULL),(795,NULL,556,40720,1584,2,218,2,160.00,NULL,'2022-10-11 00:54:49','2022-10-11 00:54:49',NULL),(796,NULL,556,40720,1584,2,13,1,160.00,NULL,'2022-10-11 00:54:49','2022-10-11 00:54:49',NULL),(797,NULL,557,40720,1584,2,218,2,150.00,NULL,'2022-10-11 00:54:52','2022-10-11 00:54:52',NULL),(798,NULL,557,40720,1584,2,13,1,150.00,NULL,'2022-10-11 00:54:52','2022-10-11 00:54:52',NULL),(799,NULL,558,40720,1584,2,218,2,260.00,NULL,'2022-10-11 00:54:54','2022-10-11 00:54:54',NULL),(800,NULL,558,40720,1584,2,13,1,260.00,NULL,'2022-10-11 00:54:54','2022-10-11 00:54:54',NULL),(801,NULL,559,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:54:57','2022-10-11 00:54:57',NULL),(802,NULL,559,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:54:57','2022-10-11 00:54:57',NULL),(803,NULL,560,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:54:59','2022-10-11 00:54:59',NULL),(804,NULL,560,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:54:59','2022-10-11 00:54:59',NULL),(805,NULL,561,40720,1584,2,218,2,240.00,NULL,'2022-10-11 00:55:03','2022-10-11 00:55:03',NULL),(806,NULL,561,40720,1584,2,13,1,240.00,NULL,'2022-10-11 00:55:03','2022-10-11 00:55:03',NULL),(807,NULL,562,40720,1584,2,218,2,460.00,NULL,'2022-10-11 00:55:05','2022-10-11 00:55:05',NULL);
INSERT INTO `balance_libro_details` VALUES (808,NULL,562,40720,1584,2,13,1,460.00,NULL,'2022-10-11 00:55:05','2022-10-11 00:55:05',NULL),(809,NULL,563,40720,1584,2,218,2,100.00,NULL,'2022-10-11 00:55:08','2022-10-11 00:55:08',NULL),(810,NULL,563,40720,1584,2,13,1,100.00,NULL,'2022-10-11 00:55:08','2022-10-11 00:55:08',NULL),(811,NULL,564,40720,1584,2,218,2,60.00,NULL,'2022-10-11 00:55:11','2022-10-11 00:55:11',NULL),(812,NULL,564,40720,1584,2,13,1,60.00,NULL,'2022-10-11 00:55:11','2022-10-11 00:55:11',NULL),(813,NULL,565,40720,1584,2,218,2,800.00,NULL,'2022-10-11 00:55:14','2022-10-11 00:55:14',NULL),(814,NULL,565,40720,1584,2,13,1,800.00,NULL,'2022-10-11 00:55:14','2022-10-11 00:55:14',NULL),(815,NULL,566,40720,1584,2,218,2,110.00,NULL,'2022-10-11 00:55:16','2022-10-11 00:55:16',NULL),(816,NULL,566,40720,1584,2,13,1,110.00,NULL,'2022-10-11 00:55:16','2022-10-11 00:55:16',NULL),(817,NULL,567,40720,1584,2,218,2,410.00,NULL,'2022-10-11 00:55:19','2022-10-11 00:55:19',NULL),(818,NULL,567,40720,1584,2,13,1,410.00,NULL,'2022-10-11 00:55:19','2022-10-11 00:55:19',NULL),(819,NULL,568,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:55:21','2022-10-11 00:55:21',NULL),(820,NULL,568,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:55:21','2022-10-11 00:55:21',NULL),(821,NULL,569,40720,1584,2,218,2,180.00,NULL,'2022-10-11 00:55:24','2022-10-11 00:55:24',NULL),(822,NULL,569,40720,1584,2,13,1,180.00,NULL,'2022-10-11 00:55:24','2022-10-11 00:55:24',NULL),(823,NULL,570,40720,1584,2,218,2,320.00,NULL,'2022-10-11 00:55:27','2022-10-11 00:55:27',NULL),(824,NULL,570,40720,1584,2,13,1,320.00,NULL,'2022-10-11 00:55:27','2022-10-11 00:55:27',NULL),(825,NULL,571,40720,1584,2,218,2,170.00,NULL,'2022-10-11 00:55:29','2022-10-11 00:55:29',NULL),(826,NULL,571,40720,1584,2,13,1,170.00,NULL,'2022-10-11 00:55:29','2022-10-11 00:55:29',NULL),(827,NULL,572,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:55:32','2022-10-11 00:55:32',NULL),(828,NULL,572,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:55:32','2022-10-11 00:55:32',NULL),(829,NULL,573,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:55:34','2022-10-11 00:55:34',NULL),(830,NULL,573,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:55:34','2022-10-11 00:55:34',NULL),(831,NULL,574,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:55:37','2022-10-11 00:55:37',NULL),(832,NULL,574,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:55:37','2022-10-11 00:55:37',NULL),(833,NULL,575,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:55:40','2022-10-11 00:55:40',NULL),(834,NULL,575,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:55:40','2022-10-11 00:55:40',NULL),(835,NULL,576,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:55:43','2022-10-11 00:55:43',NULL),(836,NULL,576,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:55:43','2022-10-11 00:55:43',NULL),(837,NULL,577,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:55:46','2022-10-11 00:55:46',NULL),(838,NULL,577,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:55:46','2022-10-11 00:55:46',NULL),(839,NULL,578,40720,1584,2,218,2,470.00,NULL,'2022-10-11 00:55:48','2022-10-11 00:55:48',NULL),(840,NULL,578,40720,1584,2,13,1,470.00,NULL,'2022-10-11 00:55:48','2022-10-11 00:55:48',NULL),(841,NULL,579,40720,1584,2,218,2,680.00,NULL,'2022-10-11 00:55:51','2022-10-11 00:55:51',NULL),(842,NULL,579,40720,1584,2,13,1,680.00,NULL,'2022-10-11 00:55:51','2022-10-11 00:55:51',NULL),(843,NULL,580,40720,1584,2,218,2,380.00,NULL,'2022-10-11 00:55:54','2022-10-11 00:55:54',NULL),(844,NULL,580,40720,1584,2,13,1,380.00,NULL,'2022-10-11 00:55:54','2022-10-11 00:55:54',NULL),(845,NULL,581,40720,1584,2,218,2,550.00,NULL,'2022-10-11 00:55:57','2022-10-11 00:55:57',NULL),(846,NULL,581,40720,1584,2,13,1,550.00,NULL,'2022-10-11 00:55:57','2022-10-11 00:55:57',NULL),(847,NULL,582,40720,1584,2,218,2,410.00,NULL,'2022-10-11 00:55:59','2022-10-11 00:55:59',NULL),(848,NULL,582,40720,1584,2,13,1,410.00,NULL,'2022-10-11 00:55:59','2022-10-11 00:55:59',NULL),(849,NULL,583,40720,1584,2,218,2,370.00,NULL,'2022-10-11 00:56:02','2022-10-11 00:56:02',NULL);
INSERT INTO `balance_libro_details` VALUES (850,NULL,583,40720,1584,2,13,1,370.00,NULL,'2022-10-11 00:56:02','2022-10-11 00:56:02',NULL),(851,NULL,584,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:56:05','2022-10-11 00:56:05',NULL),(852,NULL,584,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:56:05','2022-10-11 00:56:05',NULL),(853,NULL,585,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:56:08','2022-10-11 00:56:08',NULL),(854,NULL,585,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:56:08','2022-10-11 00:56:08',NULL),(855,NULL,586,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:56:11','2022-10-11 00:56:11',NULL),(856,NULL,586,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:56:11','2022-10-11 00:56:11',NULL),(857,NULL,587,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:56:14','2022-10-11 00:56:14',NULL),(858,NULL,587,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:56:14','2022-10-11 00:56:14',NULL),(859,NULL,588,40720,1584,2,218,2,400.00,NULL,'2022-10-11 00:56:16','2022-10-11 00:56:16',NULL),(860,NULL,588,40720,1584,2,13,1,400.00,NULL,'2022-10-11 00:56:16','2022-10-11 00:56:16',NULL),(861,NULL,589,40720,1584,2,218,2,480.00,NULL,'2022-10-11 00:56:19','2022-10-11 00:56:19',NULL),(862,NULL,589,40720,1584,2,13,1,480.00,NULL,'2022-10-11 00:56:19','2022-10-11 00:56:19',NULL),(863,NULL,590,40720,1584,2,218,2,410.00,NULL,'2022-10-11 00:56:22','2022-10-11 00:56:22',NULL),(864,NULL,590,40720,1584,2,13,1,410.00,NULL,'2022-10-11 00:56:22','2022-10-11 00:56:22',NULL),(865,NULL,591,40720,1584,2,218,2,860.00,NULL,'2022-10-11 00:56:25','2022-10-11 00:56:25',NULL),(866,NULL,591,40720,1584,2,13,1,860.00,NULL,'2022-10-11 00:56:25','2022-10-11 00:56:25',NULL),(867,NULL,592,40720,1584,2,218,2,150.00,NULL,'2022-10-11 00:56:27','2022-10-11 00:56:27',NULL),(868,NULL,592,40720,1584,2,13,1,150.00,NULL,'2022-10-11 00:56:27','2022-10-11 00:56:27',NULL),(869,NULL,593,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:56:30','2022-10-11 00:56:30',NULL),(870,NULL,593,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:56:30','2022-10-11 00:56:30',NULL),(871,NULL,594,40720,1584,2,218,2,180.00,NULL,'2022-10-11 00:56:33','2022-10-11 00:56:33',NULL),(872,NULL,594,40720,1584,2,13,1,180.00,NULL,'2022-10-11 00:56:33','2022-10-11 00:56:33',NULL),(873,NULL,595,40720,1584,2,218,2,40.00,NULL,'2022-10-11 00:56:36','2022-10-11 00:56:36',NULL),(874,NULL,595,40720,1584,2,13,1,40.00,NULL,'2022-10-11 00:56:36','2022-10-11 00:56:36',NULL),(875,NULL,596,40720,1584,2,218,2,200.00,NULL,'2022-10-11 00:56:38','2022-10-11 00:56:38',NULL),(876,NULL,596,40720,1584,2,13,1,200.00,NULL,'2022-10-11 00:56:38','2022-10-11 00:56:38',NULL),(877,NULL,597,40720,1584,2,218,2,740.00,NULL,'2022-10-11 00:56:41','2022-10-11 00:56:41',NULL),(878,NULL,597,40720,1584,2,13,1,740.00,NULL,'2022-10-11 00:56:41','2022-10-11 00:56:41',NULL),(879,NULL,598,40720,1584,2,218,2,1110.00,NULL,'2022-10-11 00:56:44','2022-10-11 00:56:44',NULL),(880,NULL,598,40720,1584,2,13,1,1110.00,NULL,'2022-10-11 00:56:44','2022-10-11 00:56:44',NULL),(881,NULL,599,40720,1584,2,218,2,340.00,NULL,'2022-10-11 00:56:46','2022-10-11 00:56:46',NULL),(882,NULL,599,40720,1584,2,13,1,340.00,NULL,'2022-10-11 00:56:46','2022-10-11 00:56:46',NULL),(883,NULL,600,40720,1584,2,218,2,200.00,NULL,'2022-10-11 00:56:49','2022-10-11 00:56:49',NULL),(884,NULL,600,40720,1584,2,13,1,200.00,NULL,'2022-10-11 00:56:49','2022-10-11 00:56:49',NULL),(885,NULL,601,40720,1584,2,218,2,590.00,NULL,'2022-10-11 00:56:52','2022-10-11 00:56:52',NULL),(886,NULL,601,40720,1584,2,13,1,590.00,NULL,'2022-10-11 00:56:52','2022-10-11 00:56:52',NULL),(887,NULL,602,40720,1584,2,218,2,360.00,NULL,'2022-10-11 00:56:55','2022-10-11 00:56:55',NULL),(888,NULL,602,40720,1584,2,13,1,360.00,NULL,'2022-10-11 00:56:55','2022-10-11 00:56:55',NULL),(889,NULL,603,40720,1584,2,218,2,140.00,NULL,'2022-10-11 00:56:57','2022-10-11 00:56:57',NULL),(890,NULL,603,40720,1584,2,13,1,140.00,NULL,'2022-10-11 00:56:57','2022-10-11 00:56:57',NULL),(891,NULL,604,40720,1584,2,218,2,250.00,NULL,'2022-10-11 00:57:00','2022-10-11 00:57:00',NULL);
INSERT INTO `balance_libro_details` VALUES (892,NULL,604,40720,1584,2,13,1,250.00,NULL,'2022-10-11 00:57:00','2022-10-11 00:57:00',NULL),(893,NULL,605,40720,1584,2,218,2,370.00,NULL,'2022-10-11 00:57:03','2022-10-11 00:57:03',NULL),(894,NULL,605,40720,1584,2,13,1,370.00,NULL,'2022-10-11 00:57:03','2022-10-11 00:57:03',NULL),(895,NULL,606,40720,1584,2,218,2,380.00,NULL,'2022-10-11 00:57:06','2022-10-11 00:57:06',NULL),(896,NULL,606,40720,1584,2,13,1,380.00,NULL,'2022-10-11 00:57:06','2022-10-11 00:57:06',NULL),(897,NULL,607,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:57:09','2022-10-11 00:57:09',NULL),(898,NULL,607,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:57:09','2022-10-11 00:57:09',NULL),(899,NULL,608,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:57:11','2022-10-11 00:57:11',NULL),(900,NULL,608,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:57:11','2022-10-11 00:57:11',NULL),(901,NULL,609,40720,1584,2,218,2,130.00,NULL,'2022-10-11 00:57:14','2022-10-11 00:57:14',NULL),(902,NULL,609,40720,1584,2,13,1,130.00,NULL,'2022-10-11 00:57:14','2022-10-11 00:57:14',NULL),(903,NULL,610,40720,1584,2,218,2,380.00,NULL,'2022-10-11 00:57:17','2022-10-11 00:57:17',NULL),(904,NULL,610,40720,1584,2,13,1,380.00,NULL,'2022-10-11 00:57:17','2022-10-11 00:57:17',NULL),(905,NULL,611,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:57:20','2022-10-11 00:57:20',NULL),(906,NULL,611,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:57:20','2022-10-11 00:57:20',NULL),(907,NULL,612,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:57:22','2022-10-11 00:57:22',NULL),(908,NULL,612,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:57:22','2022-10-11 00:57:22',NULL),(909,NULL,613,40720,1584,2,218,2,960.00,NULL,'2022-10-11 00:57:25','2022-10-11 00:57:25',NULL),(910,NULL,613,40720,1584,2,13,1,960.00,NULL,'2022-10-11 00:57:25','2022-10-11 00:57:25',NULL),(911,NULL,614,40720,1584,2,218,2,790.00,NULL,'2022-10-11 00:57:28','2022-10-11 00:57:28',NULL),(912,NULL,614,40720,1584,2,13,1,790.00,NULL,'2022-10-11 00:57:28','2022-10-11 00:57:28',NULL),(913,NULL,615,40720,1584,2,218,2,120.00,NULL,'2022-10-11 00:57:30','2022-10-11 00:57:30',NULL),(914,NULL,615,40720,1584,2,13,1,120.00,NULL,'2022-10-11 00:57:30','2022-10-11 00:57:30',NULL),(915,NULL,616,40720,1584,2,218,2,360.00,NULL,'2022-10-11 00:57:33','2022-10-11 00:57:33',NULL),(916,NULL,616,40720,1584,2,13,1,360.00,NULL,'2022-10-11 00:57:33','2022-10-11 00:57:33',NULL),(917,NULL,617,40720,1584,2,218,2,200.00,NULL,'2022-10-11 00:57:36','2022-10-11 00:57:36',NULL),(918,NULL,617,40720,1584,2,13,1,200.00,NULL,'2022-10-11 00:57:36','2022-10-11 00:57:36',NULL),(919,NULL,618,40720,1584,2,218,2,660.00,NULL,'2022-10-11 00:57:39','2022-10-11 00:57:39',NULL),(920,NULL,618,40720,1584,2,13,1,660.00,NULL,'2022-10-11 00:57:39','2022-10-11 00:57:39',NULL),(921,NULL,619,40720,1584,2,218,2,350.00,NULL,'2022-10-11 00:57:42','2022-10-11 00:57:42',NULL),(922,NULL,619,40720,1584,2,13,1,350.00,NULL,'2022-10-11 00:57:42','2022-10-11 00:57:42',NULL),(923,NULL,620,40720,1584,2,218,2,80.00,NULL,'2022-10-11 00:57:45','2022-10-11 00:57:45',NULL),(924,NULL,620,40720,1584,2,13,1,80.00,NULL,'2022-10-11 00:57:45','2022-10-11 00:57:45',NULL),(925,NULL,621,40720,1584,2,218,2,420.00,NULL,'2022-10-11 00:57:47','2022-10-11 00:57:47',NULL),(926,NULL,621,40720,1584,2,13,1,420.00,NULL,'2022-10-11 00:57:47','2022-10-11 00:57:47',NULL),(927,NULL,622,40720,1584,2,218,2,560.00,NULL,'2022-10-11 00:57:50','2022-10-11 00:57:50',NULL),(928,NULL,622,40720,1584,2,13,1,560.00,NULL,'2022-10-11 00:57:50','2022-10-11 00:57:50',NULL),(929,NULL,623,40720,1584,2,218,2,390.00,NULL,'2022-10-11 00:57:53','2022-10-11 00:57:53',NULL),(930,NULL,623,40720,1584,2,13,1,390.00,NULL,'2022-10-11 00:57:53','2022-10-11 00:57:53',NULL),(931,NULL,624,40720,1584,2,218,2,500.00,NULL,'2022-10-11 00:57:55','2022-10-11 00:57:55',NULL),(932,NULL,624,40720,1584,2,13,1,500.00,NULL,'2022-10-11 00:57:55','2022-10-11 00:57:55',NULL),(933,NULL,625,40720,1584,2,218,2,200.00,NULL,'2022-10-11 00:57:58','2022-10-11 00:57:58',NULL);
INSERT INTO `balance_libro_details` VALUES (934,NULL,625,40720,1584,2,13,1,200.00,NULL,'2022-10-11 00:57:58','2022-10-11 00:57:58',NULL),(935,NULL,626,40720,1584,2,218,2,280.00,NULL,'2022-10-11 00:58:00','2022-10-11 00:58:00',NULL),(936,NULL,626,40720,1584,2,13,1,280.00,NULL,'2022-10-11 00:58:00','2022-10-11 00:58:00',NULL),(937,NULL,627,40720,1584,2,218,2,490.00,NULL,'2022-10-11 00:58:03','2022-10-11 00:58:03',NULL),(938,NULL,627,40720,1584,2,13,1,490.00,NULL,'2022-10-11 00:58:03','2022-10-11 00:58:03',NULL),(939,NULL,628,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:58:06','2022-10-11 00:58:06',NULL),(940,NULL,628,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:58:06','2022-10-11 00:58:06',NULL),(941,NULL,629,40720,1584,2,218,2,440.00,NULL,'2022-10-11 00:58:09','2022-10-11 00:58:09',NULL),(942,NULL,629,40720,1584,2,13,1,440.00,NULL,'2022-10-11 00:58:09','2022-10-11 00:58:09',NULL),(943,NULL,630,40720,1584,2,218,2,480.00,NULL,'2022-10-11 00:58:12','2022-10-11 00:58:12',NULL),(944,NULL,630,40720,1584,2,13,1,480.00,NULL,'2022-10-11 00:58:12','2022-10-11 00:58:12',NULL),(945,NULL,631,40720,1584,2,218,2,860.00,NULL,'2022-10-11 00:58:14','2022-10-11 00:58:14',NULL),(946,NULL,631,40720,1584,2,13,1,860.00,NULL,'2022-10-11 00:58:14','2022-10-11 00:58:14',NULL),(947,NULL,632,40720,1584,2,218,2,90.00,NULL,'2022-10-11 00:58:17','2022-10-11 00:58:17',NULL),(948,NULL,632,40720,1584,2,13,1,90.00,NULL,'2022-10-11 00:58:17','2022-10-11 00:58:17',NULL),(949,NULL,633,40720,1584,2,218,2,220.00,NULL,'2022-10-11 00:58:20','2022-10-11 00:58:20',NULL),(950,NULL,633,40720,1584,2,13,1,220.00,NULL,'2022-10-11 00:58:20','2022-10-11 00:58:20',NULL),(951,NULL,634,40720,1584,2,218,2,630.00,NULL,'2022-10-22 11:27:25','2022-10-22 11:27:25',NULL),(952,NULL,634,40720,1584,2,13,1,630.00,NULL,'2022-10-22 11:27:25','2022-10-22 11:27:25',NULL),(953,NULL,635,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:27:28','2022-10-22 11:27:28',NULL),(954,NULL,635,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:27:28','2022-10-22 11:27:28',NULL),(955,NULL,636,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:27:30','2022-10-22 11:27:30',NULL),(956,NULL,636,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:27:30','2022-10-22 11:27:30',NULL),(957,NULL,637,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:27:32','2022-10-22 11:27:32',NULL),(958,NULL,637,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:27:32','2022-10-22 11:27:32',NULL),(959,NULL,638,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:27:35','2022-10-22 11:27:35',NULL),(960,NULL,638,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:27:35','2022-10-22 11:27:35',NULL),(961,NULL,639,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:27:37','2022-10-22 11:27:37',NULL),(962,NULL,639,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:27:37','2022-10-22 11:27:37',NULL),(963,NULL,640,40720,1584,2,218,2,760.00,NULL,'2022-10-22 11:27:40','2022-10-22 11:27:40',NULL),(964,NULL,640,40720,1584,2,13,1,760.00,NULL,'2022-10-22 11:27:40','2022-10-22 11:27:40',NULL),(965,NULL,641,40720,1584,2,218,2,570.00,NULL,'2022-10-22 11:27:43','2022-10-22 11:27:43',NULL),(966,NULL,641,40720,1584,2,13,1,570.00,NULL,'2022-10-22 11:27:43','2022-10-22 11:27:43',NULL),(967,NULL,642,40720,1584,2,218,2,620.00,NULL,'2022-10-22 11:27:45','2022-10-22 11:27:45',NULL),(968,NULL,642,40720,1584,2,13,1,620.00,NULL,'2022-10-22 11:27:45','2022-10-22 11:27:45',NULL),(969,NULL,643,40720,1584,2,218,2,390.00,NULL,'2022-10-22 11:27:48','2022-10-22 11:27:48',NULL),(970,NULL,643,40720,1584,2,13,1,390.00,NULL,'2022-10-22 11:27:48','2022-10-22 11:27:48',NULL),(971,NULL,644,40720,1584,2,218,2,50.00,NULL,'2022-10-22 11:27:50','2022-10-22 11:27:50',NULL),(972,NULL,644,40720,1584,2,13,1,50.00,NULL,'2022-10-22 11:27:50','2022-10-22 11:27:50',NULL),(973,NULL,645,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:27:53','2022-10-22 11:27:53',NULL),(974,NULL,645,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:27:53','2022-10-22 11:27:53',NULL),(975,NULL,646,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:27:55','2022-10-22 11:27:55',NULL);
INSERT INTO `balance_libro_details` VALUES (976,NULL,646,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:27:55','2022-10-22 11:27:55',NULL),(977,NULL,647,40720,1584,2,218,2,620.00,NULL,'2022-10-22 11:27:58','2022-10-22 11:27:58',NULL),(978,NULL,647,40720,1584,2,13,1,620.00,NULL,'2022-10-22 11:27:58','2022-10-22 11:27:58',NULL),(979,NULL,648,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:28:00','2022-10-22 11:28:00',NULL),(980,NULL,648,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:28:00','2022-10-22 11:28:00',NULL),(981,NULL,649,40720,1584,2,218,2,280.00,NULL,'2022-10-22 11:28:03','2022-10-22 11:28:03',NULL),(982,NULL,649,40720,1584,2,13,1,280.00,NULL,'2022-10-22 11:28:03','2022-10-22 11:28:03',NULL),(983,NULL,650,40720,1584,2,218,2,280.00,NULL,'2022-10-22 11:28:06','2022-10-22 11:28:06',NULL),(984,NULL,650,40720,1584,2,13,1,280.00,NULL,'2022-10-22 11:28:06','2022-10-22 11:28:06',NULL),(985,NULL,651,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:28:08','2022-10-22 11:28:08',NULL),(986,NULL,651,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:28:08','2022-10-22 11:28:08',NULL),(987,NULL,652,40720,1584,2,218,2,840.00,NULL,'2022-10-22 11:28:12','2022-10-22 11:28:12',NULL),(988,NULL,652,40720,1584,2,13,1,840.00,NULL,'2022-10-22 11:28:12','2022-10-22 11:28:12',NULL),(989,NULL,653,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:28:15','2022-10-22 11:28:15',NULL),(990,NULL,653,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:28:15','2022-10-22 11:28:15',NULL),(991,NULL,654,40720,1584,2,218,2,770.00,NULL,'2022-10-22 11:28:17','2022-10-22 11:28:17',NULL),(992,NULL,654,40720,1584,2,13,1,770.00,NULL,'2022-10-22 11:28:17','2022-10-22 11:28:17',NULL),(993,NULL,655,40720,1584,2,218,2,180.00,NULL,'2022-10-22 11:28:20','2022-10-22 11:28:20',NULL),(994,NULL,655,40720,1584,2,13,1,180.00,NULL,'2022-10-22 11:28:20','2022-10-22 11:28:20',NULL),(995,NULL,656,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:28:22','2022-10-22 11:28:22',NULL),(996,NULL,656,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:28:22','2022-10-22 11:28:22',NULL),(997,NULL,657,40720,1584,2,218,2,620.00,NULL,'2022-10-22 11:28:25','2022-10-22 11:28:25',NULL),(998,NULL,657,40720,1584,2,13,1,620.00,NULL,'2022-10-22 11:28:25','2022-10-22 11:28:25',NULL),(999,NULL,658,40720,1584,2,218,2,500.00,NULL,'2022-10-22 11:28:27','2022-10-22 11:28:27',NULL),(1000,NULL,658,40720,1584,2,13,1,500.00,NULL,'2022-10-22 11:28:27','2022-10-22 11:28:27',NULL),(1001,NULL,659,40720,1584,2,218,2,740.00,NULL,'2022-10-22 11:28:30','2022-10-22 11:28:30',NULL),(1002,NULL,659,40720,1584,2,13,1,740.00,NULL,'2022-10-22 11:28:30','2022-10-22 11:28:30',NULL),(1003,NULL,660,40720,1584,2,218,2,660.00,NULL,'2022-10-22 11:28:33','2022-10-22 11:28:33',NULL),(1004,NULL,660,40720,1584,2,13,1,660.00,NULL,'2022-10-22 11:28:33','2022-10-22 11:28:33',NULL),(1005,NULL,661,40720,1584,2,218,2,650.00,NULL,'2022-10-22 11:28:36','2022-10-22 11:28:36',NULL),(1006,NULL,661,40720,1584,2,13,1,650.00,NULL,'2022-10-22 11:28:36','2022-10-22 11:28:36',NULL),(1007,NULL,662,40720,1584,2,218,2,300.00,NULL,'2022-10-22 11:28:39','2022-10-22 11:28:39',NULL),(1008,NULL,662,40720,1584,2,13,1,300.00,NULL,'2022-10-22 11:28:39','2022-10-22 11:28:39',NULL),(1009,NULL,663,40720,1584,2,218,2,340.00,NULL,'2022-10-22 11:28:41','2022-10-22 11:28:41',NULL),(1010,NULL,663,40720,1584,2,13,1,340.00,NULL,'2022-10-22 11:28:41','2022-10-22 11:28:41',NULL),(1011,NULL,664,40720,1584,2,218,2,290.00,NULL,'2022-10-22 11:28:44','2022-10-22 11:28:44',NULL),(1012,NULL,664,40720,1584,2,13,1,290.00,NULL,'2022-10-22 11:28:44','2022-10-22 11:28:44',NULL),(1013,NULL,665,40720,1584,2,218,2,180.00,NULL,'2022-10-22 11:28:46','2022-10-22 11:28:46',NULL),(1014,NULL,665,40720,1584,2,13,1,180.00,NULL,'2022-10-22 11:28:46','2022-10-22 11:28:46',NULL),(1015,NULL,666,40720,1584,2,218,2,300.00,NULL,'2022-10-22 11:28:49','2022-10-22 11:28:49',NULL),(1016,NULL,666,40720,1584,2,13,1,300.00,NULL,'2022-10-22 11:28:49','2022-10-22 11:28:49',NULL),(1017,NULL,667,40720,1584,2,218,2,470.00,NULL,'2022-10-22 11:28:52','2022-10-22 11:28:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1018,NULL,667,40720,1584,2,13,1,470.00,NULL,'2022-10-22 11:28:52','2022-10-22 11:28:52',NULL),(1019,NULL,668,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:28:55','2022-10-22 11:28:55',NULL),(1020,NULL,668,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:28:55','2022-10-22 11:28:55',NULL),(1021,NULL,669,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:28:58','2022-10-22 11:28:58',NULL),(1022,NULL,669,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:28:58','2022-10-22 11:28:58',NULL),(1023,NULL,670,40720,1584,2,218,2,450.00,NULL,'2022-10-22 11:29:00','2022-10-22 11:29:00',NULL),(1024,NULL,670,40720,1584,2,13,1,450.00,NULL,'2022-10-22 11:29:00','2022-10-22 11:29:00',NULL),(1025,NULL,671,40720,1584,2,218,2,130.00,NULL,'2022-10-22 11:29:03','2022-10-22 11:29:03',NULL),(1026,NULL,671,40720,1584,2,13,1,130.00,NULL,'2022-10-22 11:29:03','2022-10-22 11:29:03',NULL),(1027,NULL,672,40720,1584,2,218,2,180.00,NULL,'2022-10-22 11:29:06','2022-10-22 11:29:06',NULL),(1028,NULL,672,40720,1584,2,13,1,180.00,NULL,'2022-10-22 11:29:06','2022-10-22 11:29:06',NULL),(1029,NULL,673,40720,1584,2,218,2,470.00,NULL,'2022-10-22 11:29:09','2022-10-22 11:29:09',NULL),(1030,NULL,673,40720,1584,2,13,1,470.00,NULL,'2022-10-22 11:29:09','2022-10-22 11:29:09',NULL),(1031,NULL,674,40720,1584,2,218,2,300.00,NULL,'2022-10-22 11:29:11','2022-10-22 11:29:11',NULL),(1032,NULL,674,40720,1584,2,13,1,300.00,NULL,'2022-10-22 11:29:11','2022-10-22 11:29:11',NULL),(1033,NULL,675,40720,1584,2,218,2,1020.00,NULL,'2022-10-22 11:29:14','2022-10-22 11:29:14',NULL),(1034,NULL,675,40720,1584,2,13,1,1020.00,NULL,'2022-10-22 11:29:14','2022-10-22 11:29:14',NULL),(1035,NULL,676,40720,1584,2,218,2,400.00,NULL,'2022-10-22 11:29:17','2022-10-22 11:29:17',NULL),(1036,NULL,676,40720,1584,2,13,1,400.00,NULL,'2022-10-22 11:29:17','2022-10-22 11:29:17',NULL),(1037,NULL,677,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:29:19','2022-10-22 11:29:19',NULL),(1038,NULL,677,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:29:19','2022-10-22 11:29:19',NULL),(1039,NULL,678,40720,1584,2,218,2,340.00,NULL,'2022-10-22 11:29:22','2022-10-22 11:29:22',NULL),(1040,NULL,678,40720,1584,2,13,1,340.00,NULL,'2022-10-22 11:29:22','2022-10-22 11:29:22',NULL),(1041,NULL,679,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:29:24','2022-10-22 11:29:24',NULL),(1042,NULL,679,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:29:24','2022-10-22 11:29:24',NULL),(1043,NULL,680,40720,1584,2,218,2,380.00,NULL,'2022-10-22 11:29:27','2022-10-22 11:29:27',NULL),(1044,NULL,680,40720,1584,2,13,1,380.00,NULL,'2022-10-22 11:29:27','2022-10-22 11:29:27',NULL),(1045,NULL,681,40720,1584,2,218,2,380.00,NULL,'2022-10-22 11:29:30','2022-10-22 11:29:30',NULL),(1046,NULL,681,40720,1584,2,13,1,380.00,NULL,'2022-10-22 11:29:30','2022-10-22 11:29:30',NULL),(1047,NULL,682,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:29:32','2022-10-22 11:29:32',NULL),(1048,NULL,682,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:29:32','2022-10-22 11:29:32',NULL),(1049,NULL,683,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:29:35','2022-10-22 11:29:35',NULL),(1050,NULL,683,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:29:35','2022-10-22 11:29:35',NULL),(1051,NULL,684,40720,1584,2,218,2,380.00,NULL,'2022-10-22 11:29:38','2022-10-22 11:29:38',NULL),(1052,NULL,684,40720,1584,2,13,1,380.00,NULL,'2022-10-22 11:29:38','2022-10-22 11:29:38',NULL),(1053,NULL,685,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:29:41','2022-10-22 11:29:41',NULL),(1054,NULL,685,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:29:41','2022-10-22 11:29:41',NULL),(1055,NULL,686,40720,1584,2,218,2,40.00,NULL,'2022-10-22 11:29:44','2022-10-22 11:29:44',NULL),(1056,NULL,686,40720,1584,2,13,1,40.00,NULL,'2022-10-22 11:29:44','2022-10-22 11:29:44',NULL),(1057,NULL,687,40720,1584,2,218,2,20.00,NULL,'2022-10-22 11:29:46','2022-10-22 11:29:46',NULL),(1058,NULL,687,40720,1584,2,13,1,20.00,NULL,'2022-10-22 11:29:46','2022-10-22 11:29:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1059,NULL,688,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:29:49','2022-10-22 11:29:49',NULL),(1060,NULL,688,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:29:49','2022-10-22 11:29:49',NULL),(1061,NULL,689,40720,1584,2,218,2,890.00,NULL,'2022-10-22 11:29:52','2022-10-22 11:29:52',NULL),(1062,NULL,689,40720,1584,2,13,1,890.00,NULL,'2022-10-22 11:29:52','2022-10-22 11:29:52',NULL),(1063,NULL,690,40720,1584,2,218,2,130.00,NULL,'2022-10-22 11:29:54','2022-10-22 11:29:54',NULL),(1064,NULL,690,40720,1584,2,13,1,130.00,NULL,'2022-10-22 11:29:54','2022-10-22 11:29:54',NULL),(1065,NULL,691,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:29:57','2022-10-22 11:29:57',NULL),(1066,NULL,691,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:29:57','2022-10-22 11:29:57',NULL),(1067,NULL,692,40720,1584,2,218,2,420.00,NULL,'2022-10-22 11:30:00','2022-10-22 11:30:00',NULL),(1068,NULL,692,40720,1584,2,13,1,420.00,NULL,'2022-10-22 11:30:00','2022-10-22 11:30:00',NULL),(1069,NULL,693,40720,1584,2,218,2,180.00,NULL,'2022-10-22 11:30:03','2022-10-22 11:30:03',NULL),(1070,NULL,693,40720,1584,2,13,1,180.00,NULL,'2022-10-22 11:30:03','2022-10-22 11:30:03',NULL),(1071,NULL,694,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:30:06','2022-10-22 11:30:06',NULL),(1072,NULL,694,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:30:06','2022-10-22 11:30:06',NULL),(1073,NULL,695,40720,1584,2,218,2,500.00,NULL,'2022-10-22 11:30:09','2022-10-22 11:30:09',NULL),(1074,NULL,695,40720,1584,2,13,1,500.00,NULL,'2022-10-22 11:30:09','2022-10-22 11:30:09',NULL),(1075,NULL,696,40720,1584,2,218,2,420.00,NULL,'2022-10-22 11:30:11','2022-10-22 11:30:11',NULL),(1076,NULL,696,40720,1584,2,13,1,420.00,NULL,'2022-10-22 11:30:11','2022-10-22 11:30:11',NULL),(1077,NULL,697,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:30:14','2022-10-22 11:30:14',NULL),(1078,NULL,697,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:30:14','2022-10-22 11:30:14',NULL),(1079,NULL,698,40720,1584,2,218,2,470.00,NULL,'2022-10-22 11:30:16','2022-10-22 11:30:16',NULL),(1080,NULL,698,40720,1584,2,13,1,470.00,NULL,'2022-10-22 11:30:16','2022-10-22 11:30:16',NULL),(1081,NULL,699,40720,1584,2,218,2,520.00,NULL,'2022-10-22 11:30:19','2022-10-22 11:30:19',NULL),(1082,NULL,699,40720,1584,2,13,1,520.00,NULL,'2022-10-22 11:30:19','2022-10-22 11:30:19',NULL),(1083,NULL,700,40720,1584,2,218,2,720.00,NULL,'2022-10-22 11:30:22','2022-10-22 11:30:22',NULL),(1084,NULL,700,40720,1584,2,13,1,720.00,NULL,'2022-10-22 11:30:22','2022-10-22 11:30:22',NULL),(1085,NULL,701,40720,1584,2,218,2,400.00,NULL,'2022-10-22 11:30:24','2022-10-22 11:30:24',NULL),(1086,NULL,701,40720,1584,2,13,1,400.00,NULL,'2022-10-22 11:30:24','2022-10-22 11:30:24',NULL),(1087,NULL,702,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:30:27','2022-10-22 11:30:27',NULL),(1088,NULL,702,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:30:27','2022-10-22 11:30:27',NULL),(1089,NULL,703,40720,1584,2,218,2,860.00,NULL,'2022-10-22 11:30:30','2022-10-22 11:30:30',NULL),(1090,NULL,703,40720,1584,2,13,1,860.00,NULL,'2022-10-22 11:30:30','2022-10-22 11:30:30',NULL),(1091,NULL,704,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:30:33','2022-10-22 11:30:33',NULL),(1092,NULL,704,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:30:33','2022-10-22 11:30:33',NULL),(1093,NULL,705,40720,1584,2,218,2,780.00,NULL,'2022-10-22 11:30:35','2022-10-22 11:30:35',NULL),(1094,NULL,705,40720,1584,2,13,1,780.00,NULL,'2022-10-22 11:30:35','2022-10-22 11:30:35',NULL),(1095,NULL,706,40720,1584,2,218,2,560.00,NULL,'2022-10-22 11:30:38','2022-10-22 11:30:38',NULL),(1096,NULL,706,40720,1584,2,13,1,560.00,NULL,'2022-10-22 11:30:38','2022-10-22 11:30:38',NULL),(1097,NULL,707,40720,1584,2,218,2,300.00,NULL,'2022-10-22 11:30:41','2022-10-22 11:30:41',NULL),(1098,NULL,707,40720,1584,2,13,1,300.00,NULL,'2022-10-22 11:30:41','2022-10-22 11:30:41',NULL),(1099,NULL,708,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:30:43','2022-10-22 11:30:43',NULL);
INSERT INTO `balance_libro_details` VALUES (1100,NULL,708,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:30:43','2022-10-22 11:30:43',NULL),(1101,NULL,709,40720,1584,2,218,2,320.00,NULL,'2022-10-22 11:30:46','2022-10-22 11:30:46',NULL),(1102,NULL,709,40720,1584,2,13,1,320.00,NULL,'2022-10-22 11:30:46','2022-10-22 11:30:46',NULL),(1103,NULL,710,40720,1584,2,218,2,570.00,NULL,'2022-10-22 11:30:49','2022-10-22 11:30:49',NULL),(1104,NULL,710,40720,1584,2,13,1,570.00,NULL,'2022-10-22 11:30:49','2022-10-22 11:30:49',NULL),(1105,NULL,711,40720,1584,2,218,2,190.00,NULL,'2022-10-22 11:30:52','2022-10-22 11:30:52',NULL),(1106,NULL,711,40720,1584,2,13,1,190.00,NULL,'2022-10-22 11:30:52','2022-10-22 11:30:52',NULL),(1107,NULL,712,40720,1584,2,218,2,190.00,NULL,'2022-10-22 11:30:55','2022-10-22 11:30:55',NULL),(1108,NULL,712,40720,1584,2,13,1,190.00,NULL,'2022-10-22 11:30:55','2022-10-22 11:30:55',NULL),(1109,NULL,713,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:30:57','2022-10-22 11:30:57',NULL),(1110,NULL,713,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:30:57','2022-10-22 11:30:57',NULL),(1111,NULL,714,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:31:00','2022-10-22 11:31:00',NULL),(1112,NULL,714,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:31:00','2022-10-22 11:31:00',NULL),(1113,NULL,715,40720,1584,2,218,2,710.00,NULL,'2022-10-22 11:31:03','2022-10-22 11:31:03',NULL),(1114,NULL,715,40720,1584,2,13,1,710.00,NULL,'2022-10-22 11:31:03','2022-10-22 11:31:03',NULL),(1115,NULL,716,40720,1584,2,218,2,680.00,NULL,'2022-10-22 11:31:05','2022-10-22 11:31:05',NULL),(1116,NULL,716,40720,1584,2,13,1,680.00,NULL,'2022-10-22 11:31:05','2022-10-22 11:31:05',NULL),(1117,NULL,717,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:31:08','2022-10-22 11:31:08',NULL),(1118,NULL,717,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:31:08','2022-10-22 11:31:08',NULL),(1119,NULL,718,40720,1584,2,218,2,440.00,NULL,'2022-10-22 11:31:11','2022-10-22 11:31:11',NULL),(1120,NULL,718,40720,1584,2,13,1,440.00,NULL,'2022-10-22 11:31:11','2022-10-22 11:31:11',NULL),(1121,NULL,719,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:31:14','2022-10-22 11:31:14',NULL),(1122,NULL,719,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:31:14','2022-10-22 11:31:14',NULL),(1123,NULL,720,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:31:17','2022-10-22 11:31:17',NULL),(1124,NULL,720,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:31:17','2022-10-22 11:31:17',NULL),(1125,NULL,721,40720,1584,2,218,2,350.00,NULL,'2022-10-22 11:31:20','2022-10-22 11:31:20',NULL),(1126,NULL,721,40720,1584,2,13,1,350.00,NULL,'2022-10-22 11:31:20','2022-10-22 11:31:20',NULL),(1127,NULL,722,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:31:22','2022-10-22 11:31:22',NULL),(1128,NULL,722,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:31:22','2022-10-22 11:31:22',NULL),(1129,NULL,723,40720,1584,2,218,2,290.00,NULL,'2022-10-22 11:31:25','2022-10-22 11:31:25',NULL),(1130,NULL,723,40720,1584,2,13,1,290.00,NULL,'2022-10-22 11:31:25','2022-10-22 11:31:25',NULL),(1131,NULL,724,40720,1584,2,218,2,400.00,NULL,'2022-10-22 11:31:28','2022-10-22 11:31:28',NULL),(1132,NULL,724,40720,1584,2,13,1,400.00,NULL,'2022-10-22 11:31:28','2022-10-22 11:31:28',NULL),(1133,NULL,725,40720,1584,2,218,2,100.00,NULL,'2022-10-22 11:31:30','2022-10-22 11:31:30',NULL),(1134,NULL,725,40720,1584,2,13,1,100.00,NULL,'2022-10-22 11:31:30','2022-10-22 11:31:30',NULL),(1135,NULL,726,40720,1584,2,218,2,150.00,NULL,'2022-10-22 11:31:33','2022-10-22 11:31:33',NULL),(1136,NULL,726,40720,1584,2,13,1,150.00,NULL,'2022-10-22 11:31:33','2022-10-22 11:31:33',NULL),(1137,NULL,727,40720,1584,2,218,2,350.00,NULL,'2022-10-22 11:31:36','2022-10-22 11:31:36',NULL),(1138,NULL,727,40720,1584,2,13,1,350.00,NULL,'2022-10-22 11:31:36','2022-10-22 11:31:36',NULL),(1139,NULL,728,40720,1584,2,218,2,230.00,NULL,'2022-10-22 11:31:39','2022-10-22 11:31:39',NULL),(1140,NULL,728,40720,1584,2,13,1,230.00,NULL,'2022-10-22 11:31:39','2022-10-22 11:31:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1141,NULL,729,40720,1584,2,218,2,690.00,NULL,'2022-10-22 11:31:42','2022-10-22 11:31:42',NULL),(1142,NULL,729,40720,1584,2,13,1,690.00,NULL,'2022-10-22 11:31:42','2022-10-22 11:31:42',NULL),(1143,NULL,730,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:31:44','2022-10-22 11:31:44',NULL),(1144,NULL,730,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:31:44','2022-10-22 11:31:44',NULL),(1145,NULL,731,40720,1584,2,218,2,310.00,NULL,'2022-10-22 11:31:47','2022-10-22 11:31:47',NULL),(1146,NULL,731,40720,1584,2,13,1,310.00,NULL,'2022-10-22 11:31:47','2022-10-22 11:31:47',NULL),(1147,NULL,732,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:31:50','2022-10-22 11:31:50',NULL),(1148,NULL,732,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:31:50','2022-10-22 11:31:50',NULL),(1149,NULL,733,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:31:53','2022-10-22 11:31:53',NULL),(1150,NULL,733,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:31:53','2022-10-22 11:31:53',NULL),(1151,NULL,734,40720,1584,2,218,2,2720.00,NULL,'2022-10-22 11:31:55','2022-10-22 11:31:55',NULL),(1152,NULL,734,40720,1584,2,13,1,2720.00,NULL,'2022-10-22 11:31:55','2022-10-22 11:31:55',NULL),(1153,NULL,735,40720,1584,2,218,2,550.00,NULL,'2022-10-22 11:31:59','2022-10-22 11:31:59',NULL),(1154,NULL,735,40720,1584,2,13,1,550.00,NULL,'2022-10-22 11:31:59','2022-10-22 11:31:59',NULL),(1155,NULL,736,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:32:01','2022-10-22 11:32:01',NULL),(1156,NULL,736,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:32:01','2022-10-22 11:32:01',NULL),(1157,NULL,737,40720,1584,2,218,2,550.00,NULL,'2022-10-22 11:32:04','2022-10-22 11:32:04',NULL),(1158,NULL,737,40720,1584,2,13,1,550.00,NULL,'2022-10-22 11:32:04','2022-10-22 11:32:04',NULL),(1159,NULL,738,40720,1584,2,218,2,440.00,NULL,'2022-10-22 11:32:07','2022-10-22 11:32:07',NULL),(1160,NULL,738,40720,1584,2,13,1,440.00,NULL,'2022-10-22 11:32:07','2022-10-22 11:32:07',NULL),(1161,NULL,739,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:32:10','2022-10-22 11:32:10',NULL),(1162,NULL,739,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:32:10','2022-10-22 11:32:10',NULL),(1163,NULL,740,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:32:12','2022-10-22 11:32:12',NULL),(1164,NULL,740,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:32:12','2022-10-22 11:32:12',NULL),(1165,NULL,741,40720,1584,2,218,2,560.00,NULL,'2022-10-22 11:32:15','2022-10-22 11:32:15',NULL),(1166,NULL,741,40720,1584,2,13,1,560.00,NULL,'2022-10-22 11:32:15','2022-10-22 11:32:15',NULL),(1167,NULL,742,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:32:18','2022-10-22 11:32:18',NULL),(1168,NULL,742,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:32:18','2022-10-22 11:32:18',NULL),(1169,NULL,743,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:32:21','2022-10-22 11:32:21',NULL),(1170,NULL,743,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:32:21','2022-10-22 11:32:21',NULL),(1171,NULL,744,40720,1584,2,218,2,290.00,NULL,'2022-10-22 11:32:23','2022-10-22 11:32:23',NULL),(1172,NULL,744,40720,1584,2,13,1,290.00,NULL,'2022-10-22 11:32:23','2022-10-22 11:32:23',NULL),(1173,NULL,745,40720,1584,2,218,2,740.00,NULL,'2022-10-22 11:32:26','2022-10-22 11:32:26',NULL),(1174,NULL,745,40720,1584,2,13,1,740.00,NULL,'2022-10-22 11:32:26','2022-10-22 11:32:26',NULL),(1175,NULL,746,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:32:29','2022-10-22 11:32:29',NULL),(1176,NULL,746,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:32:29','2022-10-22 11:32:29',NULL),(1177,NULL,747,40720,1584,2,218,2,570.00,NULL,'2022-10-22 11:32:31','2022-10-22 11:32:31',NULL),(1178,NULL,747,40720,1584,2,13,1,570.00,NULL,'2022-10-22 11:32:31','2022-10-22 11:32:31',NULL),(1179,NULL,748,40720,1584,2,218,2,670.00,NULL,'2022-10-22 11:32:34','2022-10-22 11:32:34',NULL),(1180,NULL,748,40720,1584,2,13,1,670.00,NULL,'2022-10-22 11:32:34','2022-10-22 11:32:34',NULL),(1181,NULL,749,40720,1584,2,218,2,470.00,NULL,'2022-10-22 11:32:37','2022-10-22 11:32:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1182,NULL,749,40720,1584,2,13,1,470.00,NULL,'2022-10-22 11:32:37','2022-10-22 11:32:37',NULL),(1183,NULL,750,40720,1584,2,218,2,720.00,NULL,'2022-10-22 11:32:40','2022-10-22 11:32:40',NULL),(1184,NULL,750,40720,1584,2,13,1,720.00,NULL,'2022-10-22 11:32:40','2022-10-22 11:32:40',NULL),(1185,NULL,751,40720,1584,2,218,2,450.00,NULL,'2022-10-22 11:32:43','2022-10-22 11:32:43',NULL),(1186,NULL,751,40720,1584,2,13,1,450.00,NULL,'2022-10-22 11:32:43','2022-10-22 11:32:43',NULL),(1187,NULL,752,40720,1584,2,218,2,250.00,NULL,'2022-10-22 11:32:46','2022-10-22 11:32:46',NULL),(1188,NULL,752,40720,1584,2,13,1,250.00,NULL,'2022-10-22 11:32:46','2022-10-22 11:32:46',NULL),(1189,NULL,753,40720,1584,2,218,2,990.00,NULL,'2022-10-22 11:32:48','2022-10-22 11:32:48',NULL),(1190,NULL,753,40720,1584,2,13,1,990.00,NULL,'2022-10-22 11:32:48','2022-10-22 11:32:48',NULL),(1191,NULL,754,40720,1584,2,218,2,1040.00,NULL,'2022-10-22 11:32:51','2022-10-22 11:32:51',NULL),(1192,NULL,754,40720,1584,2,13,1,1040.00,NULL,'2022-10-22 11:32:51','2022-10-22 11:32:51',NULL),(1193,NULL,755,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:32:54','2022-10-22 11:32:54',NULL),(1194,NULL,755,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:32:54','2022-10-22 11:32:54',NULL),(1195,NULL,756,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:32:57','2022-10-22 11:32:57',NULL),(1196,NULL,756,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:32:57','2022-10-22 11:32:57',NULL),(1197,NULL,757,40720,1584,2,218,2,320.00,NULL,'2022-10-22 11:32:59','2022-10-22 11:32:59',NULL),(1198,NULL,757,40720,1584,2,13,1,320.00,NULL,'2022-10-22 11:32:59','2022-10-22 11:32:59',NULL),(1199,NULL,758,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:33:03','2022-10-22 11:33:03',NULL),(1200,NULL,758,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:33:03','2022-10-22 11:33:03',NULL),(1201,NULL,759,40720,1584,2,218,2,1160.00,NULL,'2022-10-22 11:33:06','2022-10-22 11:33:06',NULL),(1202,NULL,759,40720,1584,2,13,1,1160.00,NULL,'2022-10-22 11:33:06','2022-10-22 11:33:06',NULL),(1203,NULL,760,40720,1584,2,218,2,310.00,NULL,'2022-10-22 11:33:09','2022-10-22 11:33:09',NULL),(1204,NULL,760,40720,1584,2,13,1,310.00,NULL,'2022-10-22 11:33:09','2022-10-22 11:33:09',NULL),(1205,NULL,761,40720,1584,2,218,2,670.00,NULL,'2022-10-22 11:33:12','2022-10-22 11:33:12',NULL),(1206,NULL,761,40720,1584,2,13,1,670.00,NULL,'2022-10-22 11:33:12','2022-10-22 11:33:12',NULL),(1207,NULL,762,40720,1584,2,218,2,90.00,NULL,'2022-10-22 11:33:14','2022-10-22 11:33:14',NULL),(1208,NULL,762,40720,1584,2,13,1,90.00,NULL,'2022-10-22 11:33:14','2022-10-22 11:33:14',NULL),(1209,NULL,763,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:33:17','2022-10-22 11:33:17',NULL),(1210,NULL,763,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:33:17','2022-10-22 11:33:17',NULL),(1211,NULL,764,40720,1584,2,218,2,400.00,NULL,'2022-10-22 11:33:20','2022-10-22 11:33:20',NULL),(1212,NULL,764,40720,1584,2,13,1,400.00,NULL,'2022-10-22 11:33:20','2022-10-22 11:33:20',NULL),(1213,NULL,765,40720,1584,2,218,2,620.00,NULL,'2022-10-22 11:33:23','2022-10-22 11:33:23',NULL),(1214,NULL,765,40720,1584,2,13,1,620.00,NULL,'2022-10-22 11:33:23','2022-10-22 11:33:23',NULL),(1215,NULL,766,40720,1584,2,218,2,530.00,NULL,'2022-10-22 11:33:26','2022-10-22 11:33:26',NULL),(1216,NULL,766,40720,1584,2,13,1,530.00,NULL,'2022-10-22 11:33:26','2022-10-22 11:33:26',NULL),(1217,NULL,767,40720,1584,2,218,2,640.00,NULL,'2022-10-22 11:33:28','2022-10-22 11:33:28',NULL),(1218,NULL,767,40720,1584,2,13,1,640.00,NULL,'2022-10-22 11:33:28','2022-10-22 11:33:28',NULL),(1219,NULL,768,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:33:31','2022-10-22 11:33:31',NULL),(1220,NULL,768,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:33:31','2022-10-22 11:33:31',NULL),(1221,NULL,769,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:33:34','2022-10-22 11:33:34',NULL),(1222,NULL,769,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:33:34','2022-10-22 11:33:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1223,NULL,770,40720,1584,2,218,2,230.00,NULL,'2022-10-22 11:33:37','2022-10-22 11:33:37',NULL),(1224,NULL,770,40720,1584,2,13,1,230.00,NULL,'2022-10-22 11:33:37','2022-10-22 11:33:37',NULL),(1225,NULL,771,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:33:40','2022-10-22 11:33:40',NULL),(1226,NULL,771,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:33:40','2022-10-22 11:33:40',NULL),(1227,NULL,772,40720,1584,2,218,2,490.00,NULL,'2022-10-22 11:33:43','2022-10-22 11:33:43',NULL),(1228,NULL,772,40720,1584,2,13,1,490.00,NULL,'2022-10-22 11:33:43','2022-10-22 11:33:43',NULL),(1229,NULL,773,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:33:45','2022-10-22 11:33:45',NULL),(1230,NULL,773,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:33:45','2022-10-22 11:33:45',NULL),(1231,NULL,774,40720,1584,2,218,2,190.00,NULL,'2022-10-22 11:33:48','2022-10-22 11:33:48',NULL),(1232,NULL,774,40720,1584,2,13,1,190.00,NULL,'2022-10-22 11:33:48','2022-10-22 11:33:48',NULL),(1233,NULL,775,40720,1584,2,218,2,150.00,NULL,'2022-10-22 11:33:51','2022-10-22 11:33:51',NULL),(1234,NULL,775,40720,1584,2,13,1,150.00,NULL,'2022-10-22 11:33:51','2022-10-22 11:33:51',NULL),(1235,NULL,776,40720,1584,2,218,2,180.00,NULL,'2022-10-22 11:33:54','2022-10-22 11:33:54',NULL),(1236,NULL,776,40720,1584,2,13,1,180.00,NULL,'2022-10-22 11:33:54','2022-10-22 11:33:54',NULL),(1237,NULL,777,40720,1584,2,218,2,350.00,NULL,'2022-10-22 11:33:57','2022-10-22 11:33:57',NULL),(1238,NULL,777,40720,1584,2,13,1,350.00,NULL,'2022-10-22 11:33:57','2022-10-22 11:33:57',NULL),(1239,NULL,778,40720,1584,2,218,2,20.00,NULL,'2022-10-22 11:34:00','2022-10-22 11:34:00',NULL),(1240,NULL,778,40720,1584,2,13,1,20.00,NULL,'2022-10-22 11:34:00','2022-10-22 11:34:00',NULL),(1241,NULL,779,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:34:03','2022-10-22 11:34:03',NULL),(1242,NULL,779,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:34:03','2022-10-22 11:34:03',NULL),(1243,NULL,780,40720,1584,2,218,2,190.00,NULL,'2022-10-22 11:34:06','2022-10-22 11:34:06',NULL),(1244,NULL,780,40720,1584,2,13,1,190.00,NULL,'2022-10-22 11:34:06','2022-10-22 11:34:06',NULL),(1245,NULL,781,40720,1584,2,218,2,770.00,NULL,'2022-10-22 11:34:09','2022-10-22 11:34:09',NULL),(1246,NULL,781,40720,1584,2,13,1,770.00,NULL,'2022-10-22 11:34:09','2022-10-22 11:34:09',NULL),(1247,NULL,782,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:34:11','2022-10-22 11:34:11',NULL),(1248,NULL,782,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:34:11','2022-10-22 11:34:11',NULL),(1249,NULL,783,40720,1584,2,218,2,420.00,NULL,'2022-10-22 11:34:14','2022-10-22 11:34:14',NULL),(1250,NULL,783,40720,1584,2,13,1,420.00,NULL,'2022-10-22 11:34:14','2022-10-22 11:34:14',NULL),(1251,NULL,784,40720,1584,2,218,2,220.00,NULL,'2022-10-22 11:34:17','2022-10-22 11:34:17',NULL),(1252,NULL,784,40720,1584,2,13,1,220.00,NULL,'2022-10-22 11:34:17','2022-10-22 11:34:17',NULL),(1253,NULL,785,40720,1584,2,218,2,650.00,NULL,'2022-10-22 11:34:20','2022-10-22 11:34:20',NULL),(1254,NULL,785,40720,1584,2,13,1,650.00,NULL,'2022-10-22 11:34:20','2022-10-22 11:34:20',NULL),(1255,NULL,786,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:34:23','2022-10-22 11:34:23',NULL),(1256,NULL,786,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:34:23','2022-10-22 11:34:23',NULL),(1257,NULL,787,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:34:26','2022-10-22 11:34:26',NULL),(1258,NULL,787,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:34:26','2022-10-22 11:34:26',NULL),(1259,NULL,788,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:34:29','2022-10-22 11:34:29',NULL),(1260,NULL,788,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:34:29','2022-10-22 11:34:29',NULL),(1261,NULL,789,40720,1584,2,218,2,290.00,NULL,'2022-10-22 11:34:32','2022-10-22 11:34:32',NULL),(1262,NULL,789,40720,1584,2,13,1,290.00,NULL,'2022-10-22 11:34:32','2022-10-22 11:34:32',NULL),(1263,NULL,790,40720,1584,2,218,2,610.00,NULL,'2022-10-22 11:34:35','2022-10-22 11:34:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1264,NULL,790,40720,1584,2,13,1,610.00,NULL,'2022-10-22 11:34:35','2022-10-22 11:34:35',NULL),(1265,NULL,791,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:34:37','2022-10-22 11:34:37',NULL),(1266,NULL,791,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:34:37','2022-10-22 11:34:37',NULL),(1267,NULL,792,40720,1584,2,218,2,350.00,NULL,'2022-10-22 11:34:40','2022-10-22 11:34:40',NULL),(1268,NULL,792,40720,1584,2,13,1,350.00,NULL,'2022-10-22 11:34:40','2022-10-22 11:34:40',NULL),(1269,NULL,793,40720,1584,2,218,2,510.00,NULL,'2022-10-22 11:34:43','2022-10-22 11:34:43',NULL),(1270,NULL,793,40720,1584,2,13,1,510.00,NULL,'2022-10-22 11:34:43','2022-10-22 11:34:43',NULL),(1271,NULL,794,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:34:46','2022-10-22 11:34:46',NULL),(1272,NULL,794,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:34:46','2022-10-22 11:34:46',NULL),(1273,NULL,795,40720,1584,2,218,2,520.00,NULL,'2022-10-22 11:34:49','2022-10-22 11:34:49',NULL),(1274,NULL,795,40720,1584,2,13,1,520.00,NULL,'2022-10-22 11:34:49','2022-10-22 11:34:49',NULL),(1275,NULL,796,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:34:52','2022-10-22 11:34:52',NULL),(1276,NULL,796,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:34:52','2022-10-22 11:34:52',NULL),(1277,NULL,797,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:34:54','2022-10-22 11:34:54',NULL),(1278,NULL,797,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:34:54','2022-10-22 11:34:54',NULL),(1279,NULL,798,40720,1584,2,218,2,1500.00,NULL,'2022-10-22 11:34:57','2022-10-22 11:34:57',NULL),(1280,NULL,798,40720,1584,2,13,1,1500.00,NULL,'2022-10-22 11:34:57','2022-10-22 11:34:57',NULL),(1281,NULL,799,40720,1584,2,218,2,220.00,NULL,'2022-10-22 11:35:00','2022-10-22 11:35:00',NULL),(1282,NULL,799,40720,1584,2,13,1,220.00,NULL,'2022-10-22 11:35:00','2022-10-22 11:35:00',NULL),(1283,NULL,800,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:35:03','2022-10-22 11:35:03',NULL),(1284,NULL,800,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:35:03','2022-10-22 11:35:03',NULL),(1285,NULL,801,40720,1584,2,218,2,710.00,NULL,'2022-10-22 11:35:06','2022-10-22 11:35:06',NULL),(1286,NULL,801,40720,1584,2,13,1,710.00,NULL,'2022-10-22 11:35:06','2022-10-22 11:35:06',NULL),(1287,NULL,802,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:35:09','2022-10-22 11:35:09',NULL),(1288,NULL,802,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:35:09','2022-10-22 11:35:09',NULL),(1289,NULL,803,40720,1584,2,218,2,700.00,NULL,'2022-10-22 11:35:12','2022-10-22 11:35:12',NULL),(1290,NULL,803,40720,1584,2,13,1,700.00,NULL,'2022-10-22 11:35:12','2022-10-22 11:35:12',NULL),(1291,NULL,804,40720,1584,2,218,2,1720.00,NULL,'2022-10-22 11:35:15','2022-10-22 11:35:15',NULL),(1292,NULL,804,40720,1584,2,13,1,1720.00,NULL,'2022-10-22 11:35:15','2022-10-22 11:35:15',NULL),(1293,NULL,805,40720,1584,2,218,2,760.00,NULL,'2022-10-22 11:35:18','2022-10-22 11:35:18',NULL),(1294,NULL,805,40720,1584,2,13,1,760.00,NULL,'2022-10-22 11:35:18','2022-10-22 11:35:18',NULL),(1295,NULL,806,40720,1584,2,218,2,290.00,NULL,'2022-10-22 11:35:21','2022-10-22 11:35:21',NULL),(1296,NULL,806,40720,1584,2,13,1,290.00,NULL,'2022-10-22 11:35:21','2022-10-22 11:35:21',NULL),(1297,NULL,807,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:35:23','2022-10-22 11:35:23',NULL),(1298,NULL,807,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:35:23','2022-10-22 11:35:23',NULL),(1299,NULL,808,40720,1584,2,218,2,390.00,NULL,'2022-10-22 11:35:26','2022-10-22 11:35:26',NULL),(1300,NULL,808,40720,1584,2,13,1,390.00,NULL,'2022-10-22 11:35:26','2022-10-22 11:35:26',NULL),(1301,NULL,809,40720,1584,2,218,2,650.00,NULL,'2022-10-22 11:35:29','2022-10-22 11:35:29',NULL),(1302,NULL,809,40720,1584,2,13,1,650.00,NULL,'2022-10-22 11:35:29','2022-10-22 11:35:29',NULL),(1303,NULL,810,40720,1584,2,218,2,290.00,NULL,'2022-10-22 11:35:32','2022-10-22 11:35:32',NULL),(1304,NULL,810,40720,1584,2,13,1,290.00,NULL,'2022-10-22 11:35:32','2022-10-22 11:35:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1305,NULL,811,40720,1584,2,218,2,1180.00,NULL,'2022-10-22 11:35:35','2022-10-22 11:35:35',NULL),(1306,NULL,811,40720,1584,2,13,1,1180.00,NULL,'2022-10-22 11:35:35','2022-10-22 11:35:35',NULL),(1307,NULL,812,40720,1584,2,218,2,440.00,NULL,'2022-10-22 11:35:38','2022-10-22 11:35:38',NULL),(1308,NULL,812,40720,1584,2,13,1,440.00,NULL,'2022-10-22 11:35:38','2022-10-22 11:35:38',NULL),(1309,NULL,813,40720,1584,2,218,2,1230.00,NULL,'2022-10-22 11:35:41','2022-10-22 11:35:41',NULL),(1310,NULL,813,40720,1584,2,13,1,1230.00,NULL,'2022-10-22 11:35:41','2022-10-22 11:35:41',NULL),(1311,NULL,814,40720,1584,2,218,2,100.00,NULL,'2022-10-22 11:35:44','2022-10-22 11:35:44',NULL),(1312,NULL,814,40720,1584,2,13,1,100.00,NULL,'2022-10-22 11:35:44','2022-10-22 11:35:44',NULL),(1313,NULL,815,40720,1584,2,218,2,500.00,NULL,'2022-10-22 11:35:47','2022-10-22 11:35:47',NULL),(1314,NULL,815,40720,1584,2,13,1,500.00,NULL,'2022-10-22 11:35:47','2022-10-22 11:35:47',NULL),(1315,NULL,816,40720,1584,2,218,2,470.00,NULL,'2022-10-22 11:35:50','2022-10-22 11:35:50',NULL),(1316,NULL,816,40720,1584,2,13,1,470.00,NULL,'2022-10-22 11:35:50','2022-10-22 11:35:50',NULL),(1317,NULL,817,40720,1584,2,218,2,190.00,NULL,'2022-10-22 11:35:53','2022-10-22 11:35:53',NULL),(1318,NULL,817,40720,1584,2,13,1,190.00,NULL,'2022-10-22 11:35:53','2022-10-22 11:35:53',NULL),(1319,NULL,818,40720,1584,2,218,2,310.00,NULL,'2022-10-22 11:35:56','2022-10-22 11:35:56',NULL),(1320,NULL,818,40720,1584,2,13,1,310.00,NULL,'2022-10-22 11:35:56','2022-10-22 11:35:56',NULL),(1321,NULL,819,40720,1584,2,218,2,520.00,NULL,'2022-10-22 11:35:59','2022-10-22 11:35:59',NULL),(1322,NULL,819,40720,1584,2,13,1,520.00,NULL,'2022-10-22 11:35:59','2022-10-22 11:35:59',NULL),(1323,NULL,820,40720,1584,2,218,2,850.00,NULL,'2022-10-22 11:36:02','2022-10-22 11:36:02',NULL),(1324,NULL,820,40720,1584,2,13,1,850.00,NULL,'2022-10-22 11:36:02','2022-10-22 11:36:02',NULL),(1325,NULL,821,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:36:05','2022-10-22 11:36:05',NULL),(1326,NULL,821,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:36:05','2022-10-22 11:36:05',NULL),(1327,NULL,822,40720,1584,2,218,2,1030.00,NULL,'2022-10-22 11:36:08','2022-10-22 11:36:08',NULL),(1328,NULL,822,40720,1584,2,13,1,1030.00,NULL,'2022-10-22 11:36:08','2022-10-22 11:36:08',NULL),(1329,NULL,823,40720,1584,2,218,2,490.00,NULL,'2022-10-22 11:36:11','2022-10-22 11:36:11',NULL),(1330,NULL,823,40720,1584,2,13,1,490.00,NULL,'2022-10-22 11:36:11','2022-10-22 11:36:11',NULL),(1331,NULL,824,40720,1584,2,218,2,1440.00,NULL,'2022-10-22 11:36:14','2022-10-22 11:36:14',NULL),(1332,NULL,824,40720,1584,2,13,1,1440.00,NULL,'2022-10-22 11:36:14','2022-10-22 11:36:14',NULL),(1333,NULL,825,40720,1584,2,218,2,2170.00,NULL,'2022-10-22 11:36:17','2022-10-22 11:36:17',NULL),(1334,NULL,825,40720,1584,2,13,1,2170.00,NULL,'2022-10-22 11:36:17','2022-10-22 11:36:17',NULL),(1335,NULL,826,40720,1584,2,218,2,720.00,NULL,'2022-10-22 11:36:20','2022-10-22 11:36:20',NULL),(1336,NULL,826,40720,1584,2,13,1,720.00,NULL,'2022-10-22 11:36:20','2022-10-22 11:36:20',NULL),(1337,NULL,827,40720,1584,2,218,2,1170.00,NULL,'2022-10-22 11:36:23','2022-10-22 11:36:23',NULL),(1338,NULL,827,40720,1584,2,13,1,1170.00,NULL,'2022-10-22 11:36:23','2022-10-22 11:36:23',NULL),(1339,NULL,828,40720,1584,2,218,2,290.00,NULL,'2022-10-22 11:36:26','2022-10-22 11:36:26',NULL),(1340,NULL,828,40720,1584,2,13,1,290.00,NULL,'2022-10-22 11:36:26','2022-10-22 11:36:26',NULL),(1341,NULL,829,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:36:29','2022-10-22 11:36:29',NULL),(1342,NULL,829,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:36:29','2022-10-22 11:36:29',NULL),(1343,NULL,830,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:36:32','2022-10-22 11:36:32',NULL),(1344,NULL,830,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:36:32','2022-10-22 11:36:32',NULL),(1345,NULL,831,40720,1584,2,218,2,270.00,NULL,'2022-10-22 11:36:35','2022-10-22 11:36:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1346,NULL,831,40720,1584,2,13,1,270.00,NULL,'2022-10-22 11:36:35','2022-10-22 11:36:35',NULL),(1347,NULL,832,40720,1584,2,218,2,130.00,NULL,'2022-10-22 11:36:38','2022-10-22 11:36:38',NULL),(1348,NULL,832,40720,1584,2,13,1,130.00,NULL,'2022-10-22 11:36:38','2022-10-22 11:36:38',NULL),(1349,NULL,833,40720,1584,2,218,2,860.00,NULL,'2022-10-22 11:36:41','2022-10-22 11:36:41',NULL),(1350,NULL,833,40720,1584,2,13,1,860.00,NULL,'2022-10-22 11:36:41','2022-10-22 11:36:41',NULL),(1351,NULL,834,40720,1584,2,218,2,570.00,NULL,'2022-10-22 11:36:44','2022-10-22 11:36:44',NULL),(1352,NULL,834,40720,1584,2,13,1,570.00,NULL,'2022-10-22 11:36:44','2022-10-22 11:36:44',NULL),(1353,NULL,835,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:36:47','2022-10-22 11:36:47',NULL),(1354,NULL,835,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:36:47','2022-10-22 11:36:47',NULL),(1355,NULL,836,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:36:50','2022-10-22 11:36:50',NULL),(1356,NULL,836,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:36:50','2022-10-22 11:36:50',NULL),(1357,NULL,837,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:36:53','2022-10-22 11:36:53',NULL),(1358,NULL,837,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:36:53','2022-10-22 11:36:53',NULL),(1359,NULL,838,40720,1584,2,218,2,540.00,NULL,'2022-10-22 11:36:56','2022-10-22 11:36:56',NULL),(1360,NULL,838,40720,1584,2,13,1,540.00,NULL,'2022-10-22 11:36:56','2022-10-22 11:36:56',NULL),(1361,NULL,839,40720,1584,2,218,2,300.00,NULL,'2022-10-22 11:36:59','2022-10-22 11:36:59',NULL),(1362,NULL,839,40720,1584,2,13,1,300.00,NULL,'2022-10-22 11:36:59','2022-10-22 11:36:59',NULL),(1363,NULL,840,40720,1584,2,218,2,100.00,NULL,'2022-10-22 11:37:02','2022-10-22 11:37:02',NULL),(1364,NULL,840,40720,1584,2,13,1,100.00,NULL,'2022-10-22 11:37:02','2022-10-22 11:37:02',NULL),(1365,NULL,841,40720,1584,2,218,2,380.00,NULL,'2022-10-22 11:37:05','2022-10-22 11:37:05',NULL),(1366,NULL,841,40720,1584,2,13,1,380.00,NULL,'2022-10-22 11:37:05','2022-10-22 11:37:05',NULL),(1367,NULL,842,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:37:08','2022-10-22 11:37:08',NULL),(1368,NULL,842,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:37:08','2022-10-22 11:37:08',NULL),(1369,NULL,843,40720,1584,2,218,2,160.00,NULL,'2022-10-22 11:37:11','2022-10-22 11:37:11',NULL),(1370,NULL,843,40720,1584,2,13,1,160.00,NULL,'2022-10-22 11:37:11','2022-10-22 11:37:11',NULL),(1371,NULL,844,40720,1584,2,218,2,650.00,NULL,'2022-10-22 11:37:14','2022-10-22 11:37:14',NULL),(1372,NULL,844,40720,1584,2,13,1,650.00,NULL,'2022-10-22 11:37:14','2022-10-22 11:37:14',NULL),(1373,NULL,845,40720,1584,2,218,2,180.00,NULL,'2022-10-22 11:37:17','2022-10-22 11:37:17',NULL),(1374,NULL,845,40720,1584,2,13,1,180.00,NULL,'2022-10-22 11:37:17','2022-10-22 11:37:17',NULL),(1375,NULL,846,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:37:20','2022-10-22 11:37:20',NULL),(1376,NULL,846,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:37:20','2022-10-22 11:37:20',NULL),(1377,NULL,847,40720,1584,2,218,2,1560.00,NULL,'2022-10-22 11:37:23','2022-10-22 11:37:23',NULL),(1378,NULL,847,40720,1584,2,13,1,1560.00,NULL,'2022-10-22 11:37:23','2022-10-22 11:37:23',NULL),(1379,NULL,848,40720,1584,2,218,2,380.00,NULL,'2022-10-22 11:37:26','2022-10-22 11:37:26',NULL),(1380,NULL,848,40720,1584,2,13,1,380.00,NULL,'2022-10-22 11:37:26','2022-10-22 11:37:26',NULL),(1381,NULL,849,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:37:29','2022-10-22 11:37:29',NULL),(1382,NULL,849,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:37:29','2022-10-22 11:37:29',NULL),(1383,NULL,850,40720,1584,2,218,2,300.00,NULL,'2022-10-22 11:37:32','2022-10-22 11:37:32',NULL),(1384,NULL,850,40720,1584,2,13,1,300.00,NULL,'2022-10-22 11:37:32','2022-10-22 11:37:32',NULL),(1385,NULL,851,40720,1584,2,218,2,290.00,NULL,'2022-10-22 11:37:35','2022-10-22 11:37:35',NULL),(1386,NULL,851,40720,1584,2,13,1,290.00,NULL,'2022-10-22 11:37:35','2022-10-22 11:37:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1387,NULL,852,40720,1584,2,218,2,50.00,NULL,'2022-10-22 11:37:38','2022-10-22 11:37:38',NULL),(1388,NULL,852,40720,1584,2,13,1,50.00,NULL,'2022-10-22 11:37:38','2022-10-22 11:37:38',NULL),(1389,NULL,853,40720,1584,2,218,2,220.00,NULL,'2022-10-22 11:37:41','2022-10-22 11:37:41',NULL),(1390,NULL,853,40720,1584,2,13,1,220.00,NULL,'2022-10-22 11:37:41','2022-10-22 11:37:41',NULL),(1391,NULL,854,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:37:44','2022-10-22 11:37:44',NULL),(1392,NULL,854,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:37:44','2022-10-22 11:37:44',NULL),(1393,NULL,855,40720,1584,2,218,2,100.00,NULL,'2022-10-22 11:37:47','2022-10-22 11:37:47',NULL),(1394,NULL,855,40720,1584,2,13,1,100.00,NULL,'2022-10-22 11:37:47','2022-10-22 11:37:47',NULL),(1395,NULL,856,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:37:50','2022-10-22 11:37:50',NULL),(1396,NULL,856,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:37:50','2022-10-22 11:37:50',NULL),(1397,NULL,857,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:37:53','2022-10-22 11:37:53',NULL),(1398,NULL,857,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:37:53','2022-10-22 11:37:53',NULL),(1399,NULL,858,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:37:56','2022-10-22 11:37:56',NULL),(1400,NULL,858,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:37:56','2022-10-22 11:37:56',NULL),(1401,NULL,859,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:37:59','2022-10-22 11:37:59',NULL),(1402,NULL,859,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:37:59','2022-10-22 11:37:59',NULL),(1403,NULL,860,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:38:02','2022-10-22 11:38:02',NULL),(1404,NULL,860,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:38:02','2022-10-22 11:38:02',NULL),(1405,NULL,861,40720,1584,2,218,2,190.00,NULL,'2022-10-22 11:38:05','2022-10-22 11:38:05',NULL),(1406,NULL,861,40720,1584,2,13,1,190.00,NULL,'2022-10-22 11:38:05','2022-10-22 11:38:05',NULL),(1407,NULL,862,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:38:08','2022-10-22 11:38:08',NULL),(1408,NULL,862,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:38:08','2022-10-22 11:38:08',NULL),(1409,NULL,863,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:38:11','2022-10-22 11:38:11',NULL),(1410,NULL,863,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:38:11','2022-10-22 11:38:11',NULL),(1411,NULL,864,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:38:14','2022-10-22 11:38:14',NULL),(1412,NULL,864,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:38:14','2022-10-22 11:38:14',NULL),(1413,NULL,865,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:38:17','2022-10-22 11:38:17',NULL),(1414,NULL,865,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:38:17','2022-10-22 11:38:17',NULL),(1415,NULL,866,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:38:20','2022-10-22 11:38:20',NULL),(1416,NULL,866,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:38:20','2022-10-22 11:38:20',NULL),(1417,NULL,867,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:38:23','2022-10-22 11:38:23',NULL),(1418,NULL,867,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:38:23','2022-10-22 11:38:23',NULL),(1419,NULL,868,40720,1584,2,218,2,220.00,NULL,'2022-10-22 11:38:26','2022-10-22 11:38:26',NULL),(1420,NULL,868,40720,1584,2,13,1,220.00,NULL,'2022-10-22 11:38:26','2022-10-22 11:38:26',NULL),(1421,NULL,869,40720,1584,2,218,2,100.00,NULL,'2022-10-22 11:38:29','2022-10-22 11:38:29',NULL),(1422,NULL,869,40720,1584,2,13,1,100.00,NULL,'2022-10-22 11:38:29','2022-10-22 11:38:29',NULL),(1423,NULL,870,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:38:32','2022-10-22 11:38:32',NULL),(1424,NULL,870,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:38:32','2022-10-22 11:38:32',NULL),(1425,NULL,871,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:38:35','2022-10-22 11:38:35',NULL),(1426,NULL,871,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:38:35','2022-10-22 11:38:35',NULL),(1427,NULL,872,40720,1584,2,218,2,460.00,NULL,'2022-10-22 11:38:38','2022-10-22 11:38:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1428,NULL,872,40720,1584,2,13,1,460.00,NULL,'2022-10-22 11:38:38','2022-10-22 11:38:38',NULL),(1429,NULL,873,40720,1584,2,218,2,320.00,NULL,'2022-10-22 11:38:41','2022-10-22 11:38:41',NULL),(1430,NULL,873,40720,1584,2,13,1,320.00,NULL,'2022-10-22 11:38:41','2022-10-22 11:38:41',NULL),(1431,NULL,874,40720,1584,2,218,2,230.00,NULL,'2022-10-22 11:38:44','2022-10-22 11:38:44',NULL),(1432,NULL,874,40720,1584,2,13,1,230.00,NULL,'2022-10-22 11:38:44','2022-10-22 11:38:44',NULL),(1433,NULL,875,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:38:47','2022-10-22 11:38:47',NULL),(1434,NULL,875,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:38:47','2022-10-22 11:38:47',NULL),(1435,NULL,876,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:38:50','2022-10-22 11:38:50',NULL),(1436,NULL,876,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:38:50','2022-10-22 11:38:50',NULL),(1437,NULL,877,40720,1584,2,218,2,850.00,NULL,'2022-10-22 11:38:53','2022-10-22 11:38:53',NULL),(1438,NULL,877,40720,1584,2,13,1,850.00,NULL,'2022-10-22 11:38:53','2022-10-22 11:38:53',NULL),(1439,NULL,878,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:38:56','2022-10-22 11:38:56',NULL),(1440,NULL,878,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:38:56','2022-10-22 11:38:56',NULL),(1441,NULL,879,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:38:59','2022-10-22 11:38:59',NULL),(1442,NULL,879,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:38:59','2022-10-22 11:38:59',NULL),(1443,NULL,880,40720,1584,2,218,2,300.00,NULL,'2022-10-22 11:39:02','2022-10-22 11:39:02',NULL),(1444,NULL,880,40720,1584,2,13,1,300.00,NULL,'2022-10-22 11:39:02','2022-10-22 11:39:02',NULL),(1445,NULL,881,40720,1584,2,218,2,220.00,NULL,'2022-10-22 11:39:05','2022-10-22 11:39:05',NULL),(1446,NULL,881,40720,1584,2,13,1,220.00,NULL,'2022-10-22 11:39:05','2022-10-22 11:39:05',NULL),(1447,NULL,882,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:39:09','2022-10-22 11:39:09',NULL),(1448,NULL,882,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:39:09','2022-10-22 11:39:09',NULL),(1449,NULL,883,40720,1584,2,218,2,450.00,NULL,'2022-10-22 11:39:12','2022-10-22 11:39:12',NULL),(1450,NULL,883,40720,1584,2,13,1,450.00,NULL,'2022-10-22 11:39:12','2022-10-22 11:39:12',NULL),(1451,NULL,884,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:39:15','2022-10-22 11:39:15',NULL),(1452,NULL,884,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:39:15','2022-10-22 11:39:15',NULL),(1453,NULL,885,40720,1584,2,218,2,110.00,NULL,'2022-10-22 11:39:18','2022-10-22 11:39:18',NULL),(1454,NULL,885,40720,1584,2,13,1,110.00,NULL,'2022-10-22 11:39:18','2022-10-22 11:39:18',NULL),(1455,NULL,886,40720,1584,2,218,2,340.00,NULL,'2022-10-22 11:39:21','2022-10-22 11:39:21',NULL),(1456,NULL,886,40720,1584,2,13,1,340.00,NULL,'2022-10-22 11:39:21','2022-10-22 11:39:21',NULL),(1457,NULL,887,40720,1584,2,218,2,220.00,NULL,'2022-10-22 11:39:25','2022-10-22 11:39:25',NULL),(1458,NULL,887,40720,1584,2,13,1,220.00,NULL,'2022-10-22 11:39:25','2022-10-22 11:39:25',NULL),(1459,NULL,888,40720,1584,2,218,2,520.00,NULL,'2022-10-22 11:39:28','2022-10-22 11:39:28',NULL),(1460,NULL,888,40720,1584,2,13,1,520.00,NULL,'2022-10-22 11:39:28','2022-10-22 11:39:28',NULL),(1461,NULL,889,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:39:31','2022-10-22 11:39:31',NULL),(1462,NULL,889,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:39:31','2022-10-22 11:39:31',NULL),(1463,NULL,890,40720,1584,2,218,2,780.00,NULL,'2022-10-22 11:39:34','2022-10-22 11:39:34',NULL),(1464,NULL,890,40720,1584,2,13,1,780.00,NULL,'2022-10-22 11:39:34','2022-10-22 11:39:34',NULL),(1465,NULL,891,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:39:37','2022-10-22 11:39:37',NULL),(1466,NULL,891,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:39:37','2022-10-22 11:39:37',NULL),(1467,NULL,892,40720,1584,2,218,2,400.00,NULL,'2022-10-22 11:39:40','2022-10-22 11:39:40',NULL),(1468,NULL,892,40720,1584,2,13,1,400.00,NULL,'2022-10-22 11:39:40','2022-10-22 11:39:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1469,NULL,893,40720,1584,2,218,2,230.00,NULL,'2022-10-22 11:39:43','2022-10-22 11:39:43',NULL),(1470,NULL,893,40720,1584,2,13,1,230.00,NULL,'2022-10-22 11:39:43','2022-10-22 11:39:43',NULL),(1471,NULL,894,40720,1584,2,218,2,340.00,NULL,'2022-10-22 11:39:47','2022-10-22 11:39:47',NULL),(1472,NULL,894,40720,1584,2,13,1,340.00,NULL,'2022-10-22 11:39:47','2022-10-22 11:39:47',NULL),(1473,NULL,895,40720,1584,2,218,2,500.00,NULL,'2022-10-22 11:39:50','2022-10-22 11:39:50',NULL),(1474,NULL,895,40720,1584,2,13,1,500.00,NULL,'2022-10-22 11:39:50','2022-10-22 11:39:50',NULL),(1475,NULL,896,40720,1584,2,218,2,970.00,NULL,'2022-10-22 11:39:53','2022-10-22 11:39:53',NULL),(1476,NULL,896,40720,1584,2,13,1,970.00,NULL,'2022-10-22 11:39:53','2022-10-22 11:39:53',NULL),(1477,NULL,897,40720,1584,2,218,2,430.00,NULL,'2022-10-22 11:39:56','2022-10-22 11:39:56',NULL),(1478,NULL,897,40720,1584,2,13,1,430.00,NULL,'2022-10-22 11:39:56','2022-10-22 11:39:56',NULL),(1479,NULL,898,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:39:59','2022-10-22 11:39:59',NULL),(1480,NULL,898,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:39:59','2022-10-22 11:39:59',NULL),(1481,NULL,899,40720,1584,2,218,2,820.00,NULL,'2022-10-22 11:40:02','2022-10-22 11:40:02',NULL),(1482,NULL,899,40720,1584,2,13,1,820.00,NULL,'2022-10-22 11:40:02','2022-10-22 11:40:02',NULL),(1483,NULL,900,40720,1584,2,218,2,390.00,NULL,'2022-10-22 11:40:05','2022-10-22 11:40:05',NULL),(1484,NULL,900,40720,1584,2,13,1,390.00,NULL,'2022-10-22 11:40:05','2022-10-22 11:40:05',NULL),(1485,NULL,901,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:40:09','2022-10-22 11:40:09',NULL),(1486,NULL,901,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:40:09','2022-10-22 11:40:09',NULL),(1487,NULL,902,40720,1584,2,218,2,510.00,NULL,'2022-10-22 11:40:12','2022-10-22 11:40:12',NULL),(1488,NULL,902,40720,1584,2,13,1,510.00,NULL,'2022-10-22 11:40:12','2022-10-22 11:40:12',NULL),(1489,NULL,903,40720,1584,2,218,2,190.00,NULL,'2022-10-22 11:40:15','2022-10-22 11:40:15',NULL),(1490,NULL,903,40720,1584,2,13,1,190.00,NULL,'2022-10-22 11:40:15','2022-10-22 11:40:15',NULL),(1491,NULL,904,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:40:18','2022-10-22 11:40:18',NULL),(1492,NULL,904,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:40:18','2022-10-22 11:40:18',NULL),(1493,NULL,905,40720,1584,2,218,2,280.00,NULL,'2022-10-22 11:40:21','2022-10-22 11:40:21',NULL),(1494,NULL,905,40720,1584,2,13,1,280.00,NULL,'2022-10-22 11:40:21','2022-10-22 11:40:21',NULL),(1495,NULL,906,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:40:24','2022-10-22 11:40:24',NULL),(1496,NULL,906,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:40:24','2022-10-22 11:40:24',NULL),(1497,NULL,907,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:40:27','2022-10-22 11:40:27',NULL),(1498,NULL,907,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:40:27','2022-10-22 11:40:27',NULL),(1499,NULL,908,40720,1584,2,218,2,340.00,NULL,'2022-10-22 11:40:31','2022-10-22 11:40:31',NULL),(1500,NULL,908,40720,1584,2,13,1,340.00,NULL,'2022-10-22 11:40:31','2022-10-22 11:40:31',NULL),(1501,NULL,909,40720,1584,2,218,2,580.00,NULL,'2022-10-22 11:40:34','2022-10-22 11:40:34',NULL),(1502,NULL,909,40720,1584,2,13,1,580.00,NULL,'2022-10-22 11:40:34','2022-10-22 11:40:34',NULL),(1503,NULL,910,40720,1584,2,218,2,500.00,NULL,'2022-10-22 11:40:38','2022-10-22 11:40:38',NULL),(1504,NULL,910,40720,1584,2,13,1,500.00,NULL,'2022-10-22 11:40:38','2022-10-22 11:40:38',NULL),(1505,NULL,911,40720,1584,2,218,2,490.00,NULL,'2022-10-22 11:40:41','2022-10-22 11:40:41',NULL),(1506,NULL,911,40720,1584,2,13,1,490.00,NULL,'2022-10-22 11:40:41','2022-10-22 11:40:41',NULL),(1507,NULL,912,40720,1584,2,218,2,450.00,NULL,'2022-10-22 11:40:44','2022-10-22 11:40:44',NULL),(1508,NULL,912,40720,1584,2,13,1,450.00,NULL,'2022-10-22 11:40:44','2022-10-22 11:40:44',NULL),(1509,NULL,913,40720,1584,2,218,2,230.00,NULL,'2022-10-22 11:40:47','2022-10-22 11:40:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1510,NULL,913,40720,1584,2,13,1,230.00,NULL,'2022-10-22 11:40:47','2022-10-22 11:40:47',NULL),(1511,NULL,914,40720,1584,2,218,2,150.00,NULL,'2022-10-22 11:40:50','2022-10-22 11:40:50',NULL),(1512,NULL,914,40720,1584,2,13,1,150.00,NULL,'2022-10-22 11:40:50','2022-10-22 11:40:50',NULL),(1513,NULL,915,40720,1584,2,218,2,620.00,NULL,'2022-10-22 11:40:54','2022-10-22 11:40:54',NULL),(1514,NULL,915,40720,1584,2,13,1,620.00,NULL,'2022-10-22 11:40:54','2022-10-22 11:40:54',NULL),(1515,NULL,916,40720,1584,2,218,2,130.00,NULL,'2022-10-22 11:40:57','2022-10-22 11:40:57',NULL),(1516,NULL,916,40720,1584,2,13,1,130.00,NULL,'2022-10-22 11:40:57','2022-10-22 11:40:57',NULL),(1517,NULL,917,40720,1584,2,218,2,310.00,NULL,'2022-10-22 11:41:00','2022-10-22 11:41:00',NULL),(1518,NULL,917,40720,1584,2,13,1,310.00,NULL,'2022-10-22 11:41:00','2022-10-22 11:41:00',NULL),(1519,NULL,918,40720,1584,2,218,2,1140.00,NULL,'2022-10-22 11:41:04','2022-10-22 11:41:04',NULL),(1520,NULL,918,40720,1584,2,13,1,1140.00,NULL,'2022-10-22 11:41:04','2022-10-22 11:41:04',NULL),(1521,NULL,919,40720,1584,2,218,2,100.00,NULL,'2022-10-22 11:41:08','2022-10-22 11:41:08',NULL),(1522,NULL,919,40720,1584,2,13,1,100.00,NULL,'2022-10-22 11:41:08','2022-10-22 11:41:08',NULL),(1523,NULL,920,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:41:11','2022-10-22 11:41:11',NULL),(1524,NULL,920,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:41:11','2022-10-22 11:41:11',NULL),(1525,NULL,921,40720,1584,2,218,2,240.00,NULL,'2022-10-22 11:41:15','2022-10-22 11:41:15',NULL),(1526,NULL,921,40720,1584,2,13,1,240.00,NULL,'2022-10-22 11:41:15','2022-10-22 11:41:15',NULL),(1527,NULL,922,40720,1584,2,218,2,360.00,NULL,'2022-10-22 11:41:20','2022-10-22 11:41:20',NULL),(1528,NULL,922,40720,1584,2,13,1,360.00,NULL,'2022-10-22 11:41:20','2022-10-22 11:41:20',NULL),(1529,NULL,923,40720,1584,2,218,2,390.00,NULL,'2022-10-22 11:41:24','2022-10-22 11:41:24',NULL),(1530,NULL,923,40720,1584,2,13,1,390.00,NULL,'2022-10-22 11:41:24','2022-10-22 11:41:24',NULL),(1531,NULL,924,40720,1584,2,218,2,1180.00,NULL,'2022-10-22 11:41:29','2022-10-22 11:41:29',NULL),(1532,NULL,924,40720,1584,2,13,1,1180.00,NULL,'2022-10-22 11:41:29','2022-10-22 11:41:29',NULL),(1533,NULL,925,40720,1584,2,218,2,980.00,NULL,'2022-10-22 11:41:33','2022-10-22 11:41:33',NULL),(1534,NULL,925,40720,1584,2,13,1,980.00,NULL,'2022-10-22 11:41:33','2022-10-22 11:41:33',NULL),(1535,NULL,926,40720,1584,2,218,2,390.00,NULL,'2022-10-22 11:41:37','2022-10-22 11:41:37',NULL),(1536,NULL,926,40720,1584,2,13,1,390.00,NULL,'2022-10-22 11:41:37','2022-10-22 11:41:37',NULL),(1537,NULL,927,40720,1584,2,218,2,920.00,NULL,'2022-10-22 11:41:41','2022-10-22 11:41:41',NULL),(1538,NULL,927,40720,1584,2,13,1,920.00,NULL,'2022-10-22 11:41:41','2022-10-22 11:41:41',NULL),(1539,NULL,928,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:41:45','2022-10-22 11:41:45',NULL),(1540,NULL,928,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:41:45','2022-10-22 11:41:45',NULL),(1541,NULL,929,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:41:48','2022-10-22 11:41:48',NULL),(1542,NULL,929,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:41:48','2022-10-22 11:41:48',NULL),(1543,NULL,930,40720,1584,2,218,2,570.00,NULL,'2022-10-22 11:41:52','2022-10-22 11:41:52',NULL),(1544,NULL,930,40720,1584,2,13,1,570.00,NULL,'2022-10-22 11:41:52','2022-10-22 11:41:52',NULL),(1545,NULL,931,40720,1584,2,218,2,600.00,NULL,'2022-10-22 11:41:55','2022-10-22 11:41:55',NULL),(1546,NULL,931,40720,1584,2,13,1,600.00,NULL,'2022-10-22 11:41:55','2022-10-22 11:41:55',NULL),(1547,NULL,932,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:41:59','2022-10-22 11:41:59',NULL),(1548,NULL,932,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:41:59','2022-10-22 11:41:59',NULL),(1549,NULL,933,40720,1584,2,218,2,810.00,NULL,'2022-10-22 11:42:02','2022-10-22 11:42:02',NULL),(1550,NULL,933,40720,1584,2,13,1,810.00,NULL,'2022-10-22 11:42:02','2022-10-22 11:42:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1551,NULL,934,40720,1584,2,218,2,270.00,NULL,'2022-10-22 11:42:05','2022-10-22 11:42:05',NULL),(1552,NULL,934,40720,1584,2,13,1,270.00,NULL,'2022-10-22 11:42:05','2022-10-22 11:42:05',NULL),(1553,NULL,935,40720,1584,2,218,2,540.00,NULL,'2022-10-22 11:42:09','2022-10-22 11:42:09',NULL),(1554,NULL,935,40720,1584,2,13,1,540.00,NULL,'2022-10-22 11:42:09','2022-10-22 11:42:09',NULL),(1555,NULL,936,40720,1584,2,218,2,250.00,NULL,'2022-10-22 11:42:12','2022-10-22 11:42:12',NULL),(1556,NULL,936,40720,1584,2,13,1,250.00,NULL,'2022-10-22 11:42:12','2022-10-22 11:42:12',NULL),(1557,NULL,937,40720,1584,2,218,2,140.00,NULL,'2022-10-22 11:42:15','2022-10-22 11:42:15',NULL),(1558,NULL,937,40720,1584,2,13,1,140.00,NULL,'2022-10-22 11:42:15','2022-10-22 11:42:15',NULL),(1559,NULL,938,40720,1584,2,218,2,510.00,NULL,'2022-10-22 11:42:19','2022-10-22 11:42:19',NULL),(1560,NULL,938,40720,1584,2,13,1,510.00,NULL,'2022-10-22 11:42:19','2022-10-22 11:42:19',NULL),(1561,NULL,939,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:42:22','2022-10-22 11:42:22',NULL),(1562,NULL,939,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:42:22','2022-10-22 11:42:22',NULL),(1563,NULL,940,40720,1584,2,218,2,310.00,NULL,'2022-10-22 11:42:25','2022-10-22 11:42:25',NULL),(1564,NULL,940,40720,1584,2,13,1,310.00,NULL,'2022-10-22 11:42:25','2022-10-22 11:42:25',NULL),(1565,NULL,941,40720,1584,2,218,2,340.00,NULL,'2022-10-22 11:42:28','2022-10-22 11:42:28',NULL),(1566,NULL,941,40720,1584,2,13,1,340.00,NULL,'2022-10-22 11:42:28','2022-10-22 11:42:28',NULL),(1567,NULL,942,40720,1584,2,218,2,630.00,NULL,'2022-10-22 11:42:32','2022-10-22 11:42:32',NULL),(1568,NULL,942,40720,1584,2,13,1,630.00,NULL,'2022-10-22 11:42:32','2022-10-22 11:42:32',NULL),(1569,NULL,943,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:42:35','2022-10-22 11:42:35',NULL),(1570,NULL,943,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:42:35','2022-10-22 11:42:35',NULL),(1571,NULL,944,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:42:38','2022-10-22 11:42:38',NULL),(1572,NULL,944,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:42:38','2022-10-22 11:42:38',NULL),(1573,NULL,945,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:42:41','2022-10-22 11:42:41',NULL),(1574,NULL,945,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:42:41','2022-10-22 11:42:41',NULL),(1575,NULL,946,40720,1584,2,218,2,260.00,NULL,'2022-10-22 11:42:44','2022-10-22 11:42:44',NULL),(1576,NULL,946,40720,1584,2,13,1,260.00,NULL,'2022-10-22 11:42:44','2022-10-22 11:42:44',NULL),(1577,NULL,947,40720,1584,2,218,2,80.00,NULL,'2022-10-22 11:42:47','2022-10-22 11:42:47',NULL),(1578,NULL,947,40720,1584,2,13,1,80.00,NULL,'2022-10-22 11:42:47','2022-10-22 11:42:47',NULL),(1579,NULL,948,40720,1584,2,218,2,250.00,NULL,'2022-10-22 11:42:50','2022-10-22 11:42:50',NULL),(1580,NULL,948,40720,1584,2,13,1,250.00,NULL,'2022-10-22 11:42:50','2022-10-22 11:42:50',NULL),(1581,NULL,949,40720,1584,2,218,2,200.00,NULL,'2022-10-22 11:42:54','2022-10-22 11:42:54',NULL),(1582,NULL,949,40720,1584,2,13,1,200.00,NULL,'2022-10-22 11:42:54','2022-10-22 11:42:54',NULL),(1583,NULL,950,40720,1584,2,218,2,190.00,NULL,'2022-10-22 11:42:57','2022-10-22 11:42:57',NULL),(1584,NULL,950,40720,1584,2,13,1,190.00,NULL,'2022-10-22 11:42:57','2022-10-22 11:42:57',NULL),(1585,NULL,951,40720,1584,2,218,2,430.00,NULL,'2022-10-22 11:43:01','2022-10-22 11:43:01',NULL),(1586,NULL,951,40720,1584,2,13,1,430.00,NULL,'2022-10-22 11:43:01','2022-10-22 11:43:01',NULL),(1587,NULL,952,40720,1584,2,218,2,500.00,NULL,'2022-10-22 11:43:04','2022-10-22 11:43:04',NULL),(1588,NULL,952,40720,1584,2,13,1,500.00,NULL,'2022-10-22 11:43:04','2022-10-22 11:43:04',NULL),(1589,NULL,953,40720,1584,2,218,2,400.00,NULL,'2022-10-22 11:43:07','2022-10-22 11:43:07',NULL),(1590,NULL,953,40720,1584,2,13,1,400.00,NULL,'2022-10-22 11:43:07','2022-10-22 11:43:07',NULL),(1591,NULL,954,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:43:10','2022-10-22 11:43:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1592,NULL,954,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:43:10','2022-10-22 11:43:10',NULL),(1593,NULL,955,40720,1584,2,218,2,120.00,NULL,'2022-10-22 11:43:14','2022-10-22 11:43:14',NULL),(1594,NULL,955,40720,1584,2,13,1,120.00,NULL,'2022-10-22 11:43:14','2022-10-22 11:43:14',NULL),(1595,NULL,956,40720,1584,2,218,2,150.00,NULL,'2022-10-22 11:43:17','2022-10-22 11:43:17',NULL),(1596,NULL,956,40720,1584,2,13,1,150.00,NULL,'2022-10-22 11:43:17','2022-10-22 11:43:17',NULL),(1597,NULL,957,40720,1584,2,218,2,230.00,NULL,'2022-10-22 11:43:20','2022-10-22 11:43:20',NULL),(1598,NULL,957,40720,1584,2,13,1,230.00,NULL,'2022-10-22 11:43:20','2022-10-22 11:43:20',NULL),(1599,NULL,958,40720,1584,2,218,2,780.00,NULL,'2022-10-22 11:43:24','2022-10-22 11:43:24',NULL),(1600,NULL,958,40720,1584,2,13,1,780.00,NULL,'2022-10-22 11:43:24','2022-10-22 11:43:24',NULL),(1601,NULL,959,40720,1584,2,218,2,170.00,NULL,'2022-10-22 11:43:27','2022-10-22 11:43:27',NULL),(1602,NULL,959,40720,1584,2,13,1,170.00,NULL,'2022-10-22 11:43:27','2022-10-22 11:43:27',NULL),(1603,NULL,960,40720,1584,2,218,2,180.00,NULL,'2022-10-22 11:43:30','2022-10-22 11:43:30',NULL),(1604,NULL,960,40720,1584,2,13,1,180.00,NULL,'2022-10-22 11:43:30','2022-10-22 11:43:30',NULL),(1605,NULL,961,40720,1584,2,218,2,450.00,NULL,'2022-10-22 11:43:33','2022-10-22 11:43:33',NULL),(1606,NULL,961,40720,1584,2,13,1,450.00,NULL,'2022-10-22 11:43:33','2022-10-22 11:43:33',NULL),(1607,NULL,962,40720,1584,2,218,2,270.00,NULL,'2022-10-22 11:43:36','2022-10-22 11:43:36',NULL),(1608,NULL,962,40720,1584,2,13,1,270.00,NULL,'2022-10-22 11:43:36','2022-10-22 11:43:36',NULL),(1609,NULL,963,40720,1584,2,218,2,110.00,NULL,'2022-10-22 11:43:39','2022-10-22 11:43:39',NULL),(1610,NULL,963,40720,1584,2,13,1,110.00,NULL,'2022-10-22 11:43:39','2022-10-22 11:43:39',NULL),(1611,NULL,964,40720,1584,2,218,2,870.00,NULL,'2022-10-22 11:43:43','2022-10-22 11:43:43',NULL),(1612,NULL,964,40720,1584,2,13,1,870.00,NULL,'2022-10-22 11:43:43','2022-10-22 11:43:43',NULL),(1613,NULL,965,40720,1584,2,218,2,470.00,NULL,'2022-10-22 12:17:30','2022-10-22 12:17:30',NULL),(1614,NULL,965,40720,1584,2,13,1,470.00,NULL,'2022-10-22 12:17:30','2022-10-22 12:17:30',NULL),(1615,NULL,966,40720,1584,2,218,2,1440.00,NULL,'2022-10-22 12:17:33','2022-10-22 12:17:33',NULL),(1616,NULL,966,40720,1584,2,13,1,1440.00,NULL,'2022-10-22 12:17:33','2022-10-22 12:17:33',NULL),(1617,NULL,967,40720,1584,2,218,2,230.00,NULL,'2022-10-22 12:17:36','2022-10-22 12:17:36',NULL),(1618,NULL,967,40720,1584,2,13,1,230.00,NULL,'2022-10-22 12:17:36','2022-10-22 12:17:36',NULL),(1619,NULL,968,40720,1584,2,218,2,170.00,NULL,'2022-10-22 12:17:39','2022-10-22 12:17:39',NULL),(1620,NULL,968,40720,1584,2,13,1,170.00,NULL,'2022-10-22 12:17:39','2022-10-22 12:17:39',NULL),(1621,NULL,969,40720,1584,2,218,2,210.00,NULL,'2022-10-22 12:17:43','2022-10-22 12:17:43',NULL),(1622,NULL,969,40720,1584,2,13,1,210.00,NULL,'2022-10-22 12:17:43','2022-10-22 12:17:43',NULL),(1623,NULL,970,40720,1584,2,218,2,540.00,NULL,'2022-10-22 12:17:46','2022-10-22 12:17:46',NULL),(1624,NULL,970,40720,1584,2,13,1,540.00,NULL,'2022-10-22 12:17:46','2022-10-22 12:17:46',NULL),(1625,NULL,971,40720,1584,2,218,2,490.00,NULL,'2022-10-22 12:17:49','2022-10-22 12:17:49',NULL),(1626,NULL,971,40720,1584,2,13,1,490.00,NULL,'2022-10-22 12:17:49','2022-10-22 12:17:49',NULL),(1627,NULL,972,40720,1584,2,218,2,740.00,NULL,'2022-10-22 12:17:53','2022-10-22 12:17:53',NULL),(1628,NULL,972,40720,1584,2,13,1,740.00,NULL,'2022-10-22 12:17:53','2022-10-22 12:17:53',NULL),(1629,NULL,973,40720,1584,2,218,2,350.00,NULL,'2022-10-22 12:17:56','2022-10-22 12:17:56',NULL),(1630,NULL,973,40720,1584,2,13,1,350.00,NULL,'2022-10-22 12:17:56','2022-10-22 12:17:56',NULL),(1631,NULL,974,40720,1584,2,218,2,410.00,NULL,'2022-10-22 12:17:59','2022-10-22 12:17:59',NULL),(1632,NULL,974,40720,1584,2,13,1,410.00,NULL,'2022-10-22 12:17:59','2022-10-22 12:17:59',NULL);
INSERT INTO `balance_libro_details` VALUES (1633,NULL,975,40720,1584,2,218,2,560.00,NULL,'2022-10-22 12:18:03','2022-10-22 12:18:03',NULL),(1634,NULL,975,40720,1584,2,13,1,560.00,NULL,'2022-10-22 12:18:03','2022-10-22 12:18:03',NULL),(1635,NULL,976,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:18:06','2022-10-22 12:18:06',NULL),(1636,NULL,976,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:18:06','2022-10-22 12:18:06',NULL),(1637,NULL,977,40720,1584,2,218,2,390.00,NULL,'2022-10-22 12:18:09','2022-10-22 12:18:09',NULL),(1638,NULL,977,40720,1584,2,13,1,390.00,NULL,'2022-10-22 12:18:09','2022-10-22 12:18:09',NULL),(1639,NULL,978,40720,1584,2,218,2,1060.00,NULL,'2022-10-22 12:18:13','2022-10-22 12:18:13',NULL),(1640,NULL,978,40720,1584,2,13,1,1060.00,NULL,'2022-10-22 12:18:13','2022-10-22 12:18:13',NULL),(1641,NULL,979,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:18:16','2022-10-22 12:18:16',NULL),(1642,NULL,979,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:18:16','2022-10-22 12:18:16',NULL),(1643,NULL,980,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:18:19','2022-10-22 12:18:19',NULL),(1644,NULL,980,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:18:19','2022-10-22 12:18:19',NULL),(1645,NULL,981,40720,1584,2,218,2,670.00,NULL,'2022-10-22 12:18:22','2022-10-22 12:18:22',NULL),(1646,NULL,981,40720,1584,2,13,1,670.00,NULL,'2022-10-22 12:18:22','2022-10-22 12:18:22',NULL),(1647,NULL,982,40720,1584,2,218,2,810.00,NULL,'2022-10-22 12:18:26','2022-10-22 12:18:26',NULL),(1648,NULL,982,40720,1584,2,13,1,810.00,NULL,'2022-10-22 12:18:26','2022-10-22 12:18:26',NULL),(1649,NULL,983,40720,1584,2,218,2,1270.00,NULL,'2022-10-22 12:18:29','2022-10-22 12:18:29',NULL),(1650,NULL,983,40720,1584,2,13,1,1270.00,NULL,'2022-10-22 12:18:29','2022-10-22 12:18:29',NULL),(1651,NULL,984,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:18:32','2022-10-22 12:18:32',NULL),(1652,NULL,984,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:18:32','2022-10-22 12:18:32',NULL),(1653,NULL,985,40720,1584,2,218,2,520.00,NULL,'2022-10-22 12:18:35','2022-10-22 12:18:35',NULL),(1654,NULL,985,40720,1584,2,13,1,520.00,NULL,'2022-10-22 12:18:35','2022-10-22 12:18:35',NULL),(1655,NULL,986,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:18:39','2022-10-22 12:18:39',NULL),(1656,NULL,986,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:18:39','2022-10-22 12:18:39',NULL),(1657,NULL,987,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:18:42','2022-10-22 12:18:42',NULL),(1658,NULL,987,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:18:42','2022-10-22 12:18:42',NULL),(1659,NULL,988,40720,1584,2,218,2,1390.00,NULL,'2022-10-22 12:18:46','2022-10-22 12:18:46',NULL),(1660,NULL,988,40720,1584,2,13,1,1390.00,NULL,'2022-10-22 12:18:46','2022-10-22 12:18:46',NULL),(1661,NULL,989,40720,1584,2,218,2,340.00,NULL,'2022-10-22 12:18:49','2022-10-22 12:18:49',NULL),(1662,NULL,989,40720,1584,2,13,1,340.00,NULL,'2022-10-22 12:18:49','2022-10-22 12:18:49',NULL),(1663,NULL,990,40720,1584,2,218,2,210.00,NULL,'2022-10-22 12:18:52','2022-10-22 12:18:52',NULL),(1664,NULL,990,40720,1584,2,13,1,210.00,NULL,'2022-10-22 12:18:52','2022-10-22 12:18:52',NULL),(1665,NULL,991,40720,1584,2,218,2,730.00,NULL,'2022-10-22 12:18:55','2022-10-22 12:18:55',NULL),(1666,NULL,991,40720,1584,2,13,1,730.00,NULL,'2022-10-22 12:18:55','2022-10-22 12:18:55',NULL),(1667,NULL,992,40720,1584,2,218,2,120.00,NULL,'2022-10-22 12:18:58','2022-10-22 12:18:58',NULL),(1668,NULL,992,40720,1584,2,13,1,120.00,NULL,'2022-10-22 12:18:58','2022-10-22 12:18:58',NULL),(1669,NULL,993,40720,1584,2,218,2,510.00,NULL,'2022-10-22 12:19:02','2022-10-22 12:19:02',NULL),(1670,NULL,993,40720,1584,2,13,1,510.00,NULL,'2022-10-22 12:19:02','2022-10-22 12:19:02',NULL),(1671,NULL,994,40720,1584,2,218,2,190.00,NULL,'2022-10-22 12:19:05','2022-10-22 12:19:05',NULL),(1672,NULL,994,40720,1584,2,13,1,190.00,NULL,'2022-10-22 12:19:05','2022-10-22 12:19:05',NULL),(1673,NULL,995,40720,1584,2,218,2,380.00,NULL,'2022-10-22 12:19:08','2022-10-22 12:19:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1674,NULL,995,40720,1584,2,13,1,380.00,NULL,'2022-10-22 12:19:08','2022-10-22 12:19:08',NULL),(1675,NULL,996,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:19:11','2022-10-22 12:19:11',NULL),(1676,NULL,996,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:19:11','2022-10-22 12:19:11',NULL),(1677,NULL,997,40720,1584,2,218,2,580.00,NULL,'2022-10-22 12:19:15','2022-10-22 12:19:15',NULL),(1678,NULL,997,40720,1584,2,13,1,580.00,NULL,'2022-10-22 12:19:15','2022-10-22 12:19:15',NULL),(1679,NULL,998,40720,1584,2,218,2,520.00,NULL,'2022-10-22 12:19:18','2022-10-22 12:19:18',NULL),(1680,NULL,998,40720,1584,2,13,1,520.00,NULL,'2022-10-22 12:19:18','2022-10-22 12:19:18',NULL),(1681,NULL,999,40720,1584,2,218,2,410.00,NULL,'2022-10-22 12:19:21','2022-10-22 12:19:21',NULL),(1682,NULL,999,40720,1584,2,13,1,410.00,NULL,'2022-10-22 12:19:21','2022-10-22 12:19:21',NULL),(1683,NULL,1000,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:19:25','2022-10-22 12:19:25',NULL),(1684,NULL,1000,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:19:25','2022-10-22 12:19:25',NULL),(1685,NULL,1001,40720,1584,2,218,2,380.00,NULL,'2022-10-22 12:19:26','2022-10-22 12:19:26',NULL),(1686,NULL,1001,40720,1584,2,13,1,380.00,NULL,'2022-10-22 12:19:26','2022-10-22 12:19:26',NULL),(1687,NULL,1002,40720,1584,2,218,2,440.00,NULL,'2022-10-22 12:19:27','2022-10-22 12:19:27',NULL),(1688,NULL,1002,40720,1584,2,13,1,440.00,NULL,'2022-10-22 12:19:27','2022-10-22 12:19:27',NULL),(1689,NULL,1003,40720,1584,2,218,2,390.00,NULL,'2022-10-22 12:19:28','2022-10-22 12:19:28',NULL),(1690,NULL,1003,40720,1584,2,13,1,390.00,NULL,'2022-10-22 12:19:28','2022-10-22 12:19:28',NULL),(1691,NULL,1004,40720,1584,2,218,2,860.00,NULL,'2022-10-22 12:19:29','2022-10-22 12:19:29',NULL),(1692,NULL,1004,40720,1584,2,13,1,860.00,NULL,'2022-10-22 12:19:29','2022-10-22 12:19:29',NULL),(1693,NULL,1005,40720,1584,2,218,2,1930.00,NULL,'2022-10-22 12:19:30','2022-10-22 12:19:30',NULL),(1694,NULL,1005,40720,1584,2,13,1,1930.00,NULL,'2022-10-22 12:19:30','2022-10-22 12:19:30',NULL),(1695,NULL,1006,40720,1584,2,218,2,500.00,NULL,'2022-10-22 12:19:31','2022-10-22 12:19:31',NULL),(1696,NULL,1006,40720,1584,2,13,1,500.00,NULL,'2022-10-22 12:19:31','2022-10-22 12:19:31',NULL),(1697,NULL,1007,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:19:32','2022-10-22 12:19:32',NULL),(1698,NULL,1007,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:19:32','2022-10-22 12:19:32',NULL),(1699,NULL,1008,40720,1584,2,218,2,510.00,NULL,'2022-10-22 12:19:33','2022-10-22 12:19:33',NULL),(1700,NULL,1008,40720,1584,2,13,1,510.00,NULL,'2022-10-22 12:19:33','2022-10-22 12:19:33',NULL),(1701,NULL,1009,40720,1584,2,218,2,490.00,NULL,'2022-10-22 12:19:34','2022-10-22 12:19:34',NULL),(1702,NULL,1009,40720,1584,2,13,1,490.00,NULL,'2022-10-22 12:19:34','2022-10-22 12:19:34',NULL),(1703,NULL,1010,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:19:35','2022-10-22 12:19:35',NULL),(1704,NULL,1010,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:19:35','2022-10-22 12:19:35',NULL),(1705,NULL,1011,40720,1584,2,218,2,340.00,NULL,'2022-10-22 12:19:36','2022-10-22 12:19:36',NULL),(1706,NULL,1011,40720,1584,2,13,1,340.00,NULL,'2022-10-22 12:19:36','2022-10-22 12:19:36',NULL),(1707,NULL,1012,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:19:37','2022-10-22 12:19:37',NULL),(1708,NULL,1012,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:19:37','2022-10-22 12:19:37',NULL),(1709,NULL,1013,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:19:38','2022-10-22 12:19:38',NULL),(1710,NULL,1013,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:19:38','2022-10-22 12:19:38',NULL),(1711,NULL,1014,40720,1584,2,218,2,230.00,NULL,'2022-10-22 12:19:40','2022-10-22 12:19:40',NULL),(1712,NULL,1014,40720,1584,2,13,1,230.00,NULL,'2022-10-22 12:19:40','2022-10-22 12:19:40',NULL),(1713,NULL,1015,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:19:41','2022-10-22 12:19:41',NULL),(1714,NULL,1015,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:19:41','2022-10-22 12:19:41',NULL);
INSERT INTO `balance_libro_details` VALUES (1715,NULL,1016,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:19:42','2022-10-22 12:19:42',NULL),(1716,NULL,1016,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:19:42','2022-10-22 12:19:42',NULL),(1717,NULL,1017,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:19:43','2022-10-22 12:19:43',NULL),(1718,NULL,1017,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:19:43','2022-10-22 12:19:43',NULL),(1719,NULL,1018,40720,1584,2,218,2,1000.00,NULL,'2022-10-22 12:19:44','2022-10-22 12:19:44',NULL),(1720,NULL,1018,40720,1584,2,13,1,1000.00,NULL,'2022-10-22 12:19:44','2022-10-22 12:19:44',NULL),(1721,NULL,1019,40720,1584,2,218,2,440.00,NULL,'2022-10-22 12:19:46','2022-10-22 12:19:46',NULL),(1722,NULL,1019,40720,1584,2,13,1,440.00,NULL,'2022-10-22 12:19:46','2022-10-22 12:19:46',NULL),(1723,NULL,1020,40720,1584,2,218,2,300.00,NULL,'2022-10-22 12:19:47','2022-10-22 12:19:47',NULL),(1724,NULL,1020,40720,1584,2,13,1,300.00,NULL,'2022-10-22 12:19:47','2022-10-22 12:19:47',NULL),(1725,NULL,1021,40720,1584,2,218,2,240.00,NULL,'2022-10-22 12:19:48','2022-10-22 12:19:48',NULL),(1726,NULL,1021,40720,1584,2,13,1,240.00,NULL,'2022-10-22 12:19:48','2022-10-22 12:19:48',NULL),(1727,NULL,1022,40720,1584,2,218,2,220.00,NULL,'2022-10-22 12:19:49','2022-10-22 12:19:49',NULL),(1728,NULL,1022,40720,1584,2,13,1,220.00,NULL,'2022-10-22 12:19:49','2022-10-22 12:19:49',NULL),(1729,NULL,1023,40720,1584,2,218,2,120.00,NULL,'2022-10-22 12:19:50','2022-10-22 12:19:50',NULL),(1730,NULL,1023,40720,1584,2,13,1,120.00,NULL,'2022-10-22 12:19:50','2022-10-22 12:19:50',NULL),(1731,NULL,1024,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:19:51','2022-10-22 12:19:51',NULL),(1732,NULL,1024,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:19:51','2022-10-22 12:19:51',NULL),(1733,NULL,1025,40720,1584,2,218,2,260.00,NULL,'2022-10-22 12:19:52','2022-10-22 12:19:52',NULL),(1734,NULL,1025,40720,1584,2,13,1,260.00,NULL,'2022-10-22 12:19:52','2022-10-22 12:19:52',NULL),(1735,NULL,1026,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:19:53','2022-10-22 12:19:53',NULL),(1736,NULL,1026,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:19:53','2022-10-22 12:19:53',NULL),(1737,NULL,1027,40720,1584,2,218,2,240.00,NULL,'2022-10-22 12:19:54','2022-10-22 12:19:54',NULL),(1738,NULL,1027,40720,1584,2,13,1,240.00,NULL,'2022-10-22 12:19:54','2022-10-22 12:19:54',NULL),(1739,NULL,1028,40720,1584,2,218,2,710.00,NULL,'2022-10-22 12:19:55','2022-10-22 12:19:55',NULL),(1740,NULL,1028,40720,1584,2,13,1,710.00,NULL,'2022-10-22 12:19:55','2022-10-22 12:19:55',NULL),(1741,NULL,1029,40720,1584,2,218,2,260.00,NULL,'2022-10-22 12:19:56','2022-10-22 12:19:56',NULL),(1742,NULL,1029,40720,1584,2,13,1,260.00,NULL,'2022-10-22 12:19:56','2022-10-22 12:19:56',NULL),(1743,NULL,1030,40720,1584,2,218,2,80.00,NULL,'2022-10-22 12:19:57','2022-10-22 12:19:57',NULL),(1744,NULL,1030,40720,1584,2,13,1,80.00,NULL,'2022-10-22 12:19:57','2022-10-22 12:19:57',NULL),(1745,NULL,1031,40720,1584,2,218,2,1010.00,NULL,'2022-10-22 12:19:58','2022-10-22 12:19:58',NULL),(1746,NULL,1031,40720,1584,2,13,1,1010.00,NULL,'2022-10-22 12:19:58','2022-10-22 12:19:58',NULL),(1747,NULL,1032,40720,1584,2,218,2,540.00,NULL,'2022-10-22 12:19:59','2022-10-22 12:19:59',NULL),(1748,NULL,1032,40720,1584,2,13,1,540.00,NULL,'2022-10-22 12:19:59','2022-10-22 12:19:59',NULL),(1749,NULL,1033,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:20:00','2022-10-22 12:20:00',NULL),(1750,NULL,1033,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:20:00','2022-10-22 12:20:00',NULL),(1751,NULL,1034,40720,1584,2,218,2,1260.00,NULL,'2022-10-22 12:20:01','2022-10-22 12:20:01',NULL),(1752,NULL,1034,40720,1584,2,13,1,1260.00,NULL,'2022-10-22 12:20:01','2022-10-22 12:20:01',NULL),(1753,NULL,1035,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:20:02','2022-10-22 12:20:02',NULL),(1754,NULL,1035,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:20:02','2022-10-22 12:20:02',NULL),(1755,NULL,1036,40720,1584,2,218,2,900.00,NULL,'2022-10-22 12:20:03','2022-10-22 12:20:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1756,NULL,1036,40720,1584,2,13,1,900.00,NULL,'2022-10-22 12:20:03','2022-10-22 12:20:03',NULL),(1757,NULL,1037,40720,1584,2,218,2,50.00,NULL,'2022-10-22 12:20:05','2022-10-22 12:20:05',NULL),(1758,NULL,1037,40720,1584,2,13,1,50.00,NULL,'2022-10-22 12:20:05','2022-10-22 12:20:05',NULL),(1759,NULL,1038,40720,1584,2,218,2,420.00,NULL,'2022-10-22 12:20:06','2022-10-22 12:20:06',NULL),(1760,NULL,1038,40720,1584,2,13,1,420.00,NULL,'2022-10-22 12:20:06','2022-10-22 12:20:06',NULL),(1761,NULL,1039,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:20:07','2022-10-22 12:20:07',NULL),(1762,NULL,1039,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:20:07','2022-10-22 12:20:07',NULL),(1763,NULL,1040,40720,1584,2,218,2,260.00,NULL,'2022-10-22 12:20:09','2022-10-22 12:20:09',NULL),(1764,NULL,1040,40720,1584,2,13,1,260.00,NULL,'2022-10-22 12:20:09','2022-10-22 12:20:09',NULL),(1765,NULL,1041,40720,1584,2,218,2,710.00,NULL,'2022-10-22 12:20:10','2022-10-22 12:20:10',NULL),(1766,NULL,1041,40720,1584,2,13,1,710.00,NULL,'2022-10-22 12:20:10','2022-10-22 12:20:10',NULL),(1767,NULL,1042,40720,1584,2,218,2,260.00,NULL,'2022-10-22 12:20:11','2022-10-22 12:20:11',NULL),(1768,NULL,1042,40720,1584,2,13,1,260.00,NULL,'2022-10-22 12:20:11','2022-10-22 12:20:11',NULL),(1769,NULL,1043,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:20:12','2022-10-22 12:20:12',NULL),(1770,NULL,1043,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:20:12','2022-10-22 12:20:12',NULL),(1771,NULL,1044,40720,1584,2,218,2,230.00,NULL,'2022-10-22 12:20:13','2022-10-22 12:20:13',NULL),(1772,NULL,1044,40720,1584,2,13,1,230.00,NULL,'2022-10-22 12:20:13','2022-10-22 12:20:13',NULL),(1773,NULL,1045,40720,1584,2,218,2,250.00,NULL,'2022-10-22 12:20:15','2022-10-22 12:20:15',NULL),(1774,NULL,1045,40720,1584,2,13,1,250.00,NULL,'2022-10-22 12:20:15','2022-10-22 12:20:15',NULL),(1775,NULL,1046,40720,1584,2,218,2,390.00,NULL,'2022-10-22 12:20:17','2022-10-22 12:20:17',NULL),(1776,NULL,1046,40720,1584,2,13,1,390.00,NULL,'2022-10-22 12:20:17','2022-10-22 12:20:17',NULL),(1777,NULL,1047,40720,1584,2,218,2,470.00,NULL,'2022-10-22 12:20:18','2022-10-22 12:20:18',NULL),(1778,NULL,1047,40720,1584,2,13,1,470.00,NULL,'2022-10-22 12:20:18','2022-10-22 12:20:18',NULL),(1779,NULL,1048,40720,1584,2,218,2,330.00,NULL,'2022-10-22 12:20:24','2022-10-22 12:20:24',NULL),(1780,NULL,1048,40720,1584,2,13,1,330.00,NULL,'2022-10-22 12:20:24','2022-10-22 12:20:24',NULL),(1781,NULL,1049,40720,1584,2,218,2,620.00,NULL,'2022-10-22 12:20:26','2022-10-22 12:20:26',NULL),(1782,NULL,1049,40720,1584,2,13,1,620.00,NULL,'2022-10-22 12:20:26','2022-10-22 12:20:26',NULL),(1783,NULL,1050,40720,1584,2,218,2,380.00,NULL,'2022-10-22 12:20:28','2022-10-22 12:20:28',NULL),(1784,NULL,1050,40720,1584,2,13,1,380.00,NULL,'2022-10-22 12:20:28','2022-10-22 12:20:28',NULL),(1785,NULL,1051,40720,1584,2,218,2,390.00,NULL,'2022-10-22 12:20:30','2022-10-22 12:20:30',NULL),(1786,NULL,1051,40720,1584,2,13,1,390.00,NULL,'2022-10-22 12:20:30','2022-10-22 12:20:30',NULL),(1787,NULL,1052,40720,1584,2,218,2,450.00,NULL,'2022-10-22 12:20:31','2022-10-22 12:20:31',NULL),(1788,NULL,1052,40720,1584,2,13,1,450.00,NULL,'2022-10-22 12:20:31','2022-10-22 12:20:31',NULL),(1789,NULL,1053,40720,1584,2,218,2,480.00,NULL,'2022-10-22 12:20:32','2022-10-22 12:20:32',NULL),(1790,NULL,1053,40720,1584,2,13,1,480.00,NULL,'2022-10-22 12:20:32','2022-10-22 12:20:32',NULL),(1791,NULL,1054,40720,1584,2,218,2,680.00,NULL,'2022-10-22 12:20:34','2022-10-22 12:20:34',NULL),(1792,NULL,1054,40720,1584,2,13,1,680.00,NULL,'2022-10-22 12:20:34','2022-10-22 12:20:34',NULL),(1793,NULL,1055,40720,1584,2,218,2,430.00,NULL,'2022-10-22 12:20:35','2022-10-22 12:20:35',NULL),(1794,NULL,1055,40720,1584,2,13,1,430.00,NULL,'2022-10-22 12:20:35','2022-10-22 12:20:35',NULL),(1795,NULL,1056,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:20:36','2022-10-22 12:20:36',NULL),(1796,NULL,1056,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:20:36','2022-10-22 12:20:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1797,NULL,1057,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:20:39','2022-10-22 12:20:39',NULL),(1798,NULL,1057,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:20:39','2022-10-22 12:20:39',NULL),(1799,NULL,1058,40720,1584,2,218,2,560.00,NULL,'2022-10-22 12:20:40','2022-10-22 12:20:40',NULL),(1800,NULL,1058,40720,1584,2,13,1,560.00,NULL,'2022-10-22 12:20:40','2022-10-22 12:20:40',NULL),(1801,NULL,1059,40720,1584,2,218,2,740.00,NULL,'2022-10-22 12:20:44','2022-10-22 12:20:44',NULL),(1802,NULL,1059,40720,1584,2,13,1,740.00,NULL,'2022-10-22 12:20:44','2022-10-22 12:20:44',NULL),(1803,NULL,1060,40720,1584,2,218,2,610.00,NULL,'2022-10-22 12:20:46','2022-10-22 12:20:46',NULL),(1804,NULL,1060,40720,1584,2,13,1,610.00,NULL,'2022-10-22 12:20:46','2022-10-22 12:20:46',NULL),(1805,NULL,1061,40720,1584,2,218,2,490.00,NULL,'2022-10-22 12:20:47','2022-10-22 12:20:47',NULL),(1806,NULL,1061,40720,1584,2,13,1,490.00,NULL,'2022-10-22 12:20:47','2022-10-22 12:20:47',NULL),(1807,NULL,1062,40720,1584,2,218,2,440.00,NULL,'2022-10-22 12:20:48','2022-10-22 12:20:48',NULL),(1808,NULL,1062,40720,1584,2,13,1,440.00,NULL,'2022-10-22 12:20:48','2022-10-22 12:20:48',NULL),(1809,NULL,1063,40720,1584,2,218,2,240.00,NULL,'2022-10-22 12:20:49','2022-10-22 12:20:49',NULL),(1810,NULL,1063,40720,1584,2,13,1,240.00,NULL,'2022-10-22 12:20:49','2022-10-22 12:20:49',NULL),(1811,NULL,1064,40720,1584,2,218,2,170.00,NULL,'2022-10-22 12:20:51','2022-10-22 12:20:51',NULL),(1812,NULL,1064,40720,1584,2,13,1,170.00,NULL,'2022-10-22 12:20:51','2022-10-22 12:20:51',NULL),(1813,NULL,1065,40720,1584,2,218,2,390.00,NULL,'2022-10-22 12:20:52','2022-10-22 12:20:52',NULL),(1814,NULL,1065,40720,1584,2,13,1,390.00,NULL,'2022-10-22 12:20:52','2022-10-22 12:20:52',NULL),(1815,NULL,1066,40720,1584,2,218,2,240.00,NULL,'2022-10-22 12:20:53','2022-10-22 12:20:53',NULL),(1816,NULL,1066,40720,1584,2,13,1,240.00,NULL,'2022-10-22 12:20:53','2022-10-22 12:20:53',NULL),(1817,NULL,1067,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:20:54','2022-10-22 12:20:54',NULL),(1818,NULL,1067,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:20:54','2022-10-22 12:20:54',NULL),(1819,NULL,1068,40720,1584,2,218,2,490.00,NULL,'2022-10-22 12:20:55','2022-10-22 12:20:55',NULL),(1820,NULL,1068,40720,1584,2,13,1,490.00,NULL,'2022-10-22 12:20:55','2022-10-22 12:20:55',NULL),(1821,NULL,1069,40720,1584,2,218,2,820.00,NULL,'2022-10-22 12:20:57','2022-10-22 12:20:57',NULL),(1822,NULL,1069,40720,1584,2,13,1,820.00,NULL,'2022-10-22 12:20:57','2022-10-22 12:20:57',NULL),(1823,NULL,1070,40720,1584,2,218,2,780.00,NULL,'2022-10-22 12:20:59','2022-10-22 12:20:59',NULL),(1824,NULL,1070,40720,1584,2,13,1,780.00,NULL,'2022-10-22 12:20:59','2022-10-22 12:20:59',NULL),(1825,NULL,1071,40720,1584,2,218,2,380.00,NULL,'2022-10-22 12:21:00','2022-10-22 12:21:00',NULL),(1826,NULL,1071,40720,1584,2,13,1,380.00,NULL,'2022-10-22 12:21:00','2022-10-22 12:21:00',NULL),(1827,NULL,1072,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:21:01','2022-10-22 12:21:01',NULL),(1828,NULL,1072,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:21:01','2022-10-22 12:21:01',NULL),(1829,NULL,1073,40720,1584,2,218,2,410.00,NULL,'2022-10-22 12:21:02','2022-10-22 12:21:02',NULL),(1830,NULL,1073,40720,1584,2,13,1,410.00,NULL,'2022-10-22 12:21:02','2022-10-22 12:21:02',NULL),(1831,NULL,1074,40720,1584,2,218,2,450.00,NULL,'2022-10-22 12:21:05','2022-10-22 12:21:05',NULL),(1832,NULL,1074,40720,1584,2,13,1,450.00,NULL,'2022-10-22 12:21:05','2022-10-22 12:21:05',NULL),(1833,NULL,1075,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:21:07','2022-10-22 12:21:07',NULL),(1834,NULL,1075,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:21:07','2022-10-22 12:21:07',NULL),(1835,NULL,1076,40720,1584,2,218,2,1770.00,NULL,'2022-10-22 12:21:08','2022-10-22 12:21:08',NULL),(1836,NULL,1076,40720,1584,2,13,1,1770.00,NULL,'2022-10-22 12:21:08','2022-10-22 12:21:08',NULL),(1837,NULL,1077,40720,1584,2,218,2,550.00,NULL,'2022-10-22 12:21:11','2022-10-22 12:21:11',NULL);
INSERT INTO `balance_libro_details` VALUES (1838,NULL,1077,40720,1584,2,13,1,550.00,NULL,'2022-10-22 12:21:11','2022-10-22 12:21:11',NULL),(1839,NULL,1078,40720,1584,2,218,2,470.00,NULL,'2022-10-22 12:21:12','2022-10-22 12:21:12',NULL),(1840,NULL,1078,40720,1584,2,13,1,470.00,NULL,'2022-10-22 12:21:12','2022-10-22 12:21:12',NULL),(1841,NULL,1079,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:21:14','2022-10-22 12:21:14',NULL),(1842,NULL,1079,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:21:14','2022-10-22 12:21:14',NULL),(1843,NULL,1080,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:21:15','2022-10-22 12:21:15',NULL),(1844,NULL,1080,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:21:15','2022-10-22 12:21:15',NULL),(1845,NULL,1081,40720,1584,2,218,2,370.00,NULL,'2022-10-22 12:21:17','2022-10-22 12:21:17',NULL),(1846,NULL,1081,40720,1584,2,13,1,370.00,NULL,'2022-10-22 12:21:17','2022-10-22 12:21:17',NULL),(1847,NULL,1082,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:21:18','2022-10-22 12:21:18',NULL),(1848,NULL,1082,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:21:18','2022-10-22 12:21:18',NULL),(1849,NULL,1083,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:21:19','2022-10-22 12:21:19',NULL),(1850,NULL,1083,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:21:19','2022-10-22 12:21:19',NULL),(1851,NULL,1084,40720,1584,2,218,2,210.00,NULL,'2022-10-22 12:21:21','2022-10-22 12:21:21',NULL),(1852,NULL,1084,40720,1584,2,13,1,210.00,NULL,'2022-10-22 12:21:21','2022-10-22 12:21:21',NULL),(1853,NULL,1085,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:21:22','2022-10-22 12:21:22',NULL),(1854,NULL,1085,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:21:22','2022-10-22 12:21:22',NULL),(1855,NULL,1086,40720,1584,2,218,2,350.00,NULL,'2022-10-22 12:21:23','2022-10-22 12:21:23',NULL),(1856,NULL,1086,40720,1584,2,13,1,350.00,NULL,'2022-10-22 12:21:23','2022-10-22 12:21:23',NULL),(1857,NULL,1087,40720,1584,2,218,2,130.00,NULL,'2022-10-22 12:21:25','2022-10-22 12:21:25',NULL),(1858,NULL,1087,40720,1584,2,13,1,130.00,NULL,'2022-10-22 12:21:25','2022-10-22 12:21:25',NULL),(1859,NULL,1088,40720,1584,2,218,2,130.00,NULL,'2022-10-22 12:21:29','2022-10-22 12:21:29',NULL),(1860,NULL,1088,40720,1584,2,13,1,130.00,NULL,'2022-10-22 12:21:29','2022-10-22 12:21:29',NULL),(1861,NULL,1089,40720,1584,2,218,2,110.00,NULL,'2022-10-22 12:21:30','2022-10-22 12:21:30',NULL),(1862,NULL,1089,40720,1584,2,13,1,110.00,NULL,'2022-10-22 12:21:30','2022-10-22 12:21:30',NULL),(1863,NULL,1090,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:21:31','2022-10-22 12:21:31',NULL),(1864,NULL,1090,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:21:31','2022-10-22 12:21:31',NULL),(1865,NULL,1091,40720,1584,2,218,2,940.00,NULL,'2022-10-22 12:21:33','2022-10-22 12:21:33',NULL),(1866,NULL,1091,40720,1584,2,13,1,940.00,NULL,'2022-10-22 12:21:33','2022-10-22 12:21:33',NULL),(1867,NULL,1092,40720,1584,2,218,2,340.00,NULL,'2022-10-22 12:21:34','2022-10-22 12:21:34',NULL),(1868,NULL,1092,40720,1584,2,13,1,340.00,NULL,'2022-10-22 12:21:34','2022-10-22 12:21:34',NULL),(1869,NULL,1093,40720,1584,2,218,2,1100.00,NULL,'2022-10-22 12:21:35','2022-10-22 12:21:35',NULL),(1870,NULL,1093,40720,1584,2,13,1,1100.00,NULL,'2022-10-22 12:21:35','2022-10-22 12:21:35',NULL),(1871,NULL,1094,40720,1584,2,218,2,130.00,NULL,'2022-10-22 12:21:36','2022-10-22 12:21:36',NULL),(1872,NULL,1094,40720,1584,2,13,1,130.00,NULL,'2022-10-22 12:21:36','2022-10-22 12:21:36',NULL),(1873,NULL,1095,40720,1584,2,218,2,210.00,NULL,'2022-10-22 12:21:37','2022-10-22 12:21:37',NULL),(1874,NULL,1095,40720,1584,2,13,1,210.00,NULL,'2022-10-22 12:21:37','2022-10-22 12:21:37',NULL),(1875,NULL,1096,40720,1584,2,218,2,490.00,NULL,'2022-10-22 12:21:38','2022-10-22 12:21:38',NULL),(1876,NULL,1096,40720,1584,2,13,1,490.00,NULL,'2022-10-22 12:21:38','2022-10-22 12:21:38',NULL),(1877,NULL,1097,40720,1584,2,218,2,300.00,NULL,'2022-10-22 12:21:39','2022-10-22 12:21:39',NULL),(1878,NULL,1097,40720,1584,2,13,1,300.00,NULL,'2022-10-22 12:21:39','2022-10-22 12:21:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1879,NULL,1098,40720,1584,2,218,2,2520.00,NULL,'2022-10-22 12:21:41','2022-10-22 12:21:41',NULL),(1880,NULL,1098,40720,1584,2,13,1,2520.00,NULL,'2022-10-22 12:21:41','2022-10-22 12:21:41',NULL),(1881,NULL,1099,40720,1584,2,218,2,340.00,NULL,'2022-10-22 12:21:42','2022-10-22 12:21:42',NULL),(1882,NULL,1099,40720,1584,2,13,1,340.00,NULL,'2022-10-22 12:21:42','2022-10-22 12:21:42',NULL),(1883,NULL,1100,40720,1584,2,218,2,930.00,NULL,'2022-10-22 12:21:45','2022-10-22 12:21:45',NULL),(1884,NULL,1100,40720,1584,2,13,1,930.00,NULL,'2022-10-22 12:21:45','2022-10-22 12:21:45',NULL),(1885,NULL,1101,40720,1584,2,218,2,510.00,NULL,'2022-10-22 12:21:46','2022-10-22 12:21:46',NULL),(1886,NULL,1101,40720,1584,2,13,1,510.00,NULL,'2022-10-22 12:21:46','2022-10-22 12:21:46',NULL),(1887,NULL,1102,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:21:48','2022-10-22 12:21:48',NULL),(1888,NULL,1102,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:21:48','2022-10-22 12:21:48',NULL),(1889,NULL,1103,40720,1584,2,218,2,250.00,NULL,'2022-10-22 12:21:49','2022-10-22 12:21:49',NULL),(1890,NULL,1103,40720,1584,2,13,1,250.00,NULL,'2022-10-22 12:21:49','2022-10-22 12:21:49',NULL),(1891,NULL,1104,40720,1584,2,218,2,260.00,NULL,'2022-10-22 12:21:50','2022-10-22 12:21:50',NULL),(1892,NULL,1104,40720,1584,2,13,1,260.00,NULL,'2022-10-22 12:21:50','2022-10-22 12:21:50',NULL),(1893,NULL,1105,40720,1584,2,218,2,500.00,NULL,'2022-10-22 12:21:52','2022-10-22 12:21:52',NULL),(1894,NULL,1105,40720,1584,2,13,1,500.00,NULL,'2022-10-22 12:21:52','2022-10-22 12:21:52',NULL),(1895,NULL,1106,40720,1584,2,218,2,140.00,NULL,'2022-10-22 12:21:53','2022-10-22 12:21:53',NULL),(1896,NULL,1106,40720,1584,2,13,1,140.00,NULL,'2022-10-22 12:21:53','2022-10-22 12:21:53',NULL),(1897,NULL,1107,40720,1584,2,218,2,600.00,NULL,'2022-10-22 12:21:54','2022-10-22 12:21:54',NULL),(1898,NULL,1107,40720,1584,2,13,1,600.00,NULL,'2022-10-22 12:21:54','2022-10-22 12:21:54',NULL),(1899,NULL,1108,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:21:55','2022-10-22 12:21:55',NULL),(1900,NULL,1108,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:21:55','2022-10-22 12:21:55',NULL),(1901,NULL,1109,40720,1584,2,218,2,130.00,NULL,'2022-10-22 12:21:57','2022-10-22 12:21:57',NULL),(1902,NULL,1109,40720,1584,2,13,1,130.00,NULL,'2022-10-22 12:21:57','2022-10-22 12:21:57',NULL),(1903,NULL,1110,40720,1584,2,218,2,170.00,NULL,'2022-10-22 12:21:57','2022-10-22 12:21:57',NULL),(1904,NULL,1110,40720,1584,2,13,1,170.00,NULL,'2022-10-22 12:21:57','2022-10-22 12:21:57',NULL),(1905,NULL,1111,40720,1584,2,218,2,340.00,NULL,'2022-10-22 12:21:58','2022-10-22 12:21:58',NULL),(1906,NULL,1111,40720,1584,2,13,1,340.00,NULL,'2022-10-22 12:21:58','2022-10-22 12:21:58',NULL),(1907,NULL,1112,40720,1584,2,218,2,550.00,NULL,'2022-10-22 12:21:59','2022-10-22 12:21:59',NULL),(1908,NULL,1112,40720,1584,2,13,1,550.00,NULL,'2022-10-22 12:21:59','2022-10-22 12:21:59',NULL),(1909,NULL,1113,40720,1584,2,218,2,820.00,NULL,'2022-10-22 12:22:00','2022-10-22 12:22:00',NULL),(1910,NULL,1113,40720,1584,2,13,1,820.00,NULL,'2022-10-22 12:22:00','2022-10-22 12:22:00',NULL),(1911,NULL,1114,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:22:02','2022-10-22 12:22:02',NULL),(1912,NULL,1114,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:22:02','2022-10-22 12:22:02',NULL),(1913,NULL,1115,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:22:03','2022-10-22 12:22:03',NULL),(1914,NULL,1115,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:22:03','2022-10-22 12:22:03',NULL),(1915,NULL,1116,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:22:04','2022-10-22 12:22:04',NULL),(1916,NULL,1116,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:22:04','2022-10-22 12:22:04',NULL),(1917,NULL,1117,40720,1584,2,218,2,610.00,NULL,'2022-10-22 12:22:05','2022-10-22 12:22:05',NULL),(1918,NULL,1117,40720,1584,2,13,1,610.00,NULL,'2022-10-22 12:22:05','2022-10-22 12:22:05',NULL),(1919,NULL,1118,40720,1584,2,218,2,740.00,NULL,'2022-10-22 12:22:06','2022-10-22 12:22:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1920,NULL,1118,40720,1584,2,13,1,740.00,NULL,'2022-10-22 12:22:06','2022-10-22 12:22:06',NULL),(1921,NULL,1119,40720,1584,2,218,2,770.00,NULL,'2022-10-22 12:22:08','2022-10-22 12:22:08',NULL),(1922,NULL,1119,40720,1584,2,13,1,770.00,NULL,'2022-10-22 12:22:08','2022-10-22 12:22:08',NULL),(1923,NULL,1120,40720,1584,2,218,2,230.00,NULL,'2022-10-22 12:22:09','2022-10-22 12:22:09',NULL),(1924,NULL,1120,40720,1584,2,13,1,230.00,NULL,'2022-10-22 12:22:09','2022-10-22 12:22:09',NULL),(1925,NULL,1121,40720,1584,2,218,2,2.00,NULL,'2022-10-22 12:22:10','2022-10-22 12:22:10',NULL),(1926,NULL,1121,40720,1584,2,13,1,2.00,NULL,'2022-10-22 12:22:10','2022-10-22 12:22:10',NULL),(1927,NULL,1122,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:22:11','2022-10-22 12:22:11',NULL),(1928,NULL,1122,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:22:11','2022-10-22 12:22:11',NULL),(1929,NULL,1123,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:22:12','2022-10-22 12:22:12',NULL),(1930,NULL,1123,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:22:12','2022-10-22 12:22:12',NULL),(1931,NULL,1124,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:22:13','2022-10-22 12:22:13',NULL),(1932,NULL,1124,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:22:13','2022-10-22 12:22:13',NULL),(1933,NULL,1125,40720,1584,2,218,2,520.00,NULL,'2022-10-22 12:22:14','2022-10-22 12:22:14',NULL),(1934,NULL,1125,40720,1584,2,13,1,520.00,NULL,'2022-10-22 12:22:14','2022-10-22 12:22:14',NULL),(1935,NULL,1126,40720,1584,2,218,2,510.00,NULL,'2022-10-22 12:22:15','2022-10-22 12:22:15',NULL),(1936,NULL,1126,40720,1584,2,13,1,510.00,NULL,'2022-10-22 12:22:15','2022-10-22 12:22:15',NULL),(1937,NULL,1127,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:22:16','2022-10-22 12:22:16',NULL),(1938,NULL,1127,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:22:16','2022-10-22 12:22:16',NULL),(1939,NULL,1128,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:22:17','2022-10-22 12:22:17',NULL),(1940,NULL,1128,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:22:17','2022-10-22 12:22:17',NULL),(1941,NULL,1129,40720,1584,2,218,2,590.00,NULL,'2022-10-22 12:22:18','2022-10-22 12:22:18',NULL),(1942,NULL,1129,40720,1584,2,13,1,590.00,NULL,'2022-10-22 12:22:18','2022-10-22 12:22:18',NULL),(1943,NULL,1130,40720,1584,2,218,2,330.00,NULL,'2022-10-22 12:22:19','2022-10-22 12:22:19',NULL),(1944,NULL,1130,40720,1584,2,13,1,330.00,NULL,'2022-10-22 12:22:19','2022-10-22 12:22:19',NULL),(1945,NULL,1131,40720,1584,2,218,2,470.00,NULL,'2022-10-22 12:22:21','2022-10-22 12:22:21',NULL),(1946,NULL,1131,40720,1584,2,13,1,470.00,NULL,'2022-10-22 12:22:21','2022-10-22 12:22:21',NULL),(1947,NULL,1132,40720,1584,2,218,2,540.00,NULL,'2022-10-22 12:22:22','2022-10-22 12:22:22',NULL),(1948,NULL,1132,40720,1584,2,13,1,540.00,NULL,'2022-10-22 12:22:22','2022-10-22 12:22:22',NULL),(1949,NULL,1133,40720,1584,2,218,2,260.00,NULL,'2022-10-22 12:22:24','2022-10-22 12:22:24',NULL),(1950,NULL,1133,40720,1584,2,13,1,260.00,NULL,'2022-10-22 12:22:24','2022-10-22 12:22:24',NULL),(1951,NULL,1134,40720,1584,2,218,2,300.00,NULL,'2022-10-22 12:22:25','2022-10-22 12:22:25',NULL),(1952,NULL,1134,40720,1584,2,13,1,300.00,NULL,'2022-10-22 12:22:25','2022-10-22 12:22:25',NULL),(1953,NULL,1135,40720,1584,2,218,2,210.00,NULL,'2022-10-22 12:22:26','2022-10-22 12:22:26',NULL),(1954,NULL,1135,40720,1584,2,13,1,210.00,NULL,'2022-10-22 12:22:26','2022-10-22 12:22:26',NULL),(1955,NULL,1136,40720,1584,2,218,2,430.00,NULL,'2022-10-22 12:22:27','2022-10-22 12:22:27',NULL),(1956,NULL,1136,40720,1584,2,13,1,430.00,NULL,'2022-10-22 12:22:27','2022-10-22 12:22:27',NULL),(1957,NULL,1137,40720,1584,2,218,2,470.00,NULL,'2022-10-22 12:22:29','2022-10-22 12:22:29',NULL),(1958,NULL,1137,40720,1584,2,13,1,470.00,NULL,'2022-10-22 12:22:29','2022-10-22 12:22:29',NULL),(1959,NULL,1138,40720,1584,2,218,2,370.00,NULL,'2022-10-22 12:22:30','2022-10-22 12:22:30',NULL),(1960,NULL,1138,40720,1584,2,13,1,370.00,NULL,'2022-10-22 12:22:30','2022-10-22 12:22:30',NULL);
INSERT INTO `balance_libro_details` VALUES (1961,NULL,1139,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:22:31','2022-10-22 12:22:31',NULL),(1962,NULL,1139,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:22:31','2022-10-22 12:22:31',NULL),(1963,NULL,1140,40720,1584,2,218,2,470.00,NULL,'2022-10-22 12:22:32','2022-10-22 12:22:32',NULL),(1964,NULL,1140,40720,1584,2,13,1,470.00,NULL,'2022-10-22 12:22:32','2022-10-22 12:22:32',NULL),(1965,NULL,1141,40720,1584,2,218,2,260.00,NULL,'2022-10-22 12:22:33','2022-10-22 12:22:33',NULL),(1966,NULL,1141,40720,1584,2,13,1,260.00,NULL,'2022-10-22 12:22:33','2022-10-22 12:22:33',NULL),(1967,NULL,1142,40720,1584,2,218,2,520.00,NULL,'2022-10-22 12:22:34','2022-10-22 12:22:34',NULL),(1968,NULL,1142,40720,1584,2,13,1,520.00,NULL,'2022-10-22 12:22:34','2022-10-22 12:22:34',NULL),(1969,NULL,1143,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:22:35','2022-10-22 12:22:35',NULL),(1970,NULL,1143,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:22:35','2022-10-22 12:22:35',NULL),(1971,NULL,1144,40720,1584,2,218,2,340.00,NULL,'2022-10-22 12:22:36','2022-10-22 12:22:36',NULL),(1972,NULL,1144,40720,1584,2,13,1,340.00,NULL,'2022-10-22 12:22:36','2022-10-22 12:22:36',NULL),(1973,NULL,1145,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:22:37','2022-10-22 12:22:37',NULL),(1974,NULL,1145,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:22:37','2022-10-22 12:22:37',NULL),(1975,NULL,1146,40720,1584,2,218,2,890.00,NULL,'2022-10-22 12:22:38','2022-10-22 12:22:38',NULL),(1976,NULL,1146,40720,1584,2,13,1,890.00,NULL,'2022-10-22 12:22:38','2022-10-22 12:22:38',NULL),(1977,NULL,1147,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:22:39','2022-10-22 12:22:39',NULL),(1978,NULL,1147,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:22:39','2022-10-22 12:22:39',NULL),(1979,NULL,1148,40720,1584,2,218,2,100.00,NULL,'2022-10-22 12:22:40','2022-10-22 12:22:40',NULL),(1980,NULL,1148,40720,1584,2,13,1,100.00,NULL,'2022-10-22 12:22:40','2022-10-22 12:22:40',NULL),(1981,NULL,1149,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:22:41','2022-10-22 12:22:41',NULL),(1982,NULL,1149,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:22:41','2022-10-22 12:22:41',NULL),(1983,NULL,1150,40720,1584,2,218,2,220.00,NULL,'2022-10-22 12:22:42','2022-10-22 12:22:42',NULL),(1984,NULL,1150,40720,1584,2,13,1,220.00,NULL,'2022-10-22 12:22:42','2022-10-22 12:22:42',NULL),(1985,NULL,1151,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:22:43','2022-10-22 12:22:43',NULL),(1986,NULL,1151,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:22:43','2022-10-22 12:22:43',NULL),(1987,NULL,1152,40720,1584,2,218,2,850.00,NULL,'2022-10-22 12:22:44','2022-10-22 12:22:44',NULL),(1988,NULL,1152,40720,1584,2,13,1,850.00,NULL,'2022-10-22 12:22:45','2022-10-22 12:22:45',NULL),(1989,NULL,1153,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:22:46','2022-10-22 12:22:46',NULL),(1990,NULL,1153,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:22:46','2022-10-22 12:22:46',NULL),(1991,NULL,1154,40720,1584,2,218,2,380.00,NULL,'2022-10-22 12:22:47','2022-10-22 12:22:47',NULL),(1992,NULL,1154,40720,1584,2,13,1,380.00,NULL,'2022-10-22 12:22:47','2022-10-22 12:22:47',NULL),(1993,NULL,1155,40720,1584,2,218,2,260.00,NULL,'2022-10-22 12:22:48','2022-10-22 12:22:48',NULL),(1994,NULL,1155,40720,1584,2,13,1,260.00,NULL,'2022-10-22 12:22:48','2022-10-22 12:22:48',NULL),(1995,NULL,1156,40720,1584,2,218,2,550.00,NULL,'2022-10-22 12:22:49','2022-10-22 12:22:49',NULL),(1996,NULL,1156,40720,1584,2,13,1,550.00,NULL,'2022-10-22 12:22:49','2022-10-22 12:22:49',NULL),(1997,NULL,1157,40720,1584,2,218,2,550.00,NULL,'2022-10-22 12:22:51','2022-10-22 12:22:51',NULL),(1998,NULL,1157,40720,1584,2,13,1,550.00,NULL,'2022-10-22 12:22:51','2022-10-22 12:22:51',NULL),(1999,NULL,1158,40720,1584,2,218,2,780.00,NULL,'2022-10-22 12:22:52','2022-10-22 12:22:52',NULL),(2000,NULL,1158,40720,1584,2,13,1,780.00,NULL,'2022-10-22 12:22:52','2022-10-22 12:22:52',NULL),(2001,NULL,1159,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:22:53','2022-10-22 12:22:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2002,NULL,1159,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:22:53','2022-10-22 12:22:53',NULL),(2003,NULL,1160,40720,1584,2,218,2,1030.00,NULL,'2022-10-22 12:22:54','2022-10-22 12:22:54',NULL),(2004,NULL,1160,40720,1584,2,13,1,1030.00,NULL,'2022-10-22 12:22:54','2022-10-22 12:22:54',NULL),(2005,NULL,1161,40720,1584,2,218,2,960.00,NULL,'2022-10-22 12:22:55','2022-10-22 12:22:55',NULL),(2006,NULL,1161,40720,1584,2,13,1,960.00,NULL,'2022-10-22 12:22:55','2022-10-22 12:22:55',NULL),(2007,NULL,1162,40720,1584,2,218,2,680.00,NULL,'2022-10-22 12:22:56','2022-10-22 12:22:56',NULL),(2008,NULL,1162,40720,1584,2,13,1,680.00,NULL,'2022-10-22 12:22:56','2022-10-22 12:22:56',NULL),(2009,NULL,1163,40720,1584,2,218,2,360.00,NULL,'2022-10-22 12:22:57','2022-10-22 12:22:57',NULL),(2010,NULL,1163,40720,1584,2,13,1,360.00,NULL,'2022-10-22 12:22:57','2022-10-22 12:22:57',NULL),(2011,NULL,1164,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:22:58','2022-10-22 12:22:58',NULL),(2012,NULL,1164,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:22:58','2022-10-22 12:22:58',NULL),(2013,NULL,1165,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:22:59','2022-10-22 12:22:59',NULL),(2014,NULL,1165,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:22:59','2022-10-22 12:22:59',NULL),(2015,NULL,1166,40720,1584,2,218,2,780.00,NULL,'2022-10-22 12:23:00','2022-10-22 12:23:00',NULL),(2016,NULL,1166,40720,1584,2,13,1,780.00,NULL,'2022-10-22 12:23:00','2022-10-22 12:23:00',NULL),(2017,NULL,1167,40720,1584,2,218,2,330.00,NULL,'2022-10-22 12:23:01','2022-10-22 12:23:01',NULL),(2018,NULL,1167,40720,1584,2,13,1,330.00,NULL,'2022-10-22 12:23:01','2022-10-22 12:23:01',NULL),(2019,NULL,1168,40720,1584,2,218,2,460.00,NULL,'2022-10-22 12:23:02','2022-10-22 12:23:02',NULL),(2020,NULL,1168,40720,1584,2,13,1,460.00,NULL,'2022-10-22 12:23:02','2022-10-22 12:23:02',NULL),(2021,NULL,1169,40720,1584,2,218,2,410.00,NULL,'2022-10-22 12:23:03','2022-10-22 12:23:03',NULL),(2022,NULL,1169,40720,1584,2,13,1,410.00,NULL,'2022-10-22 12:23:03','2022-10-22 12:23:03',NULL),(2023,NULL,1170,40720,1584,2,218,2,400.00,NULL,'2022-10-22 12:23:05','2022-10-22 12:23:05',NULL),(2024,NULL,1170,40720,1584,2,13,1,400.00,NULL,'2022-10-22 12:23:05','2022-10-22 12:23:05',NULL),(2025,NULL,1171,40720,1584,2,218,2,380.00,NULL,'2022-10-22 12:23:06','2022-10-22 12:23:06',NULL),(2026,NULL,1171,40720,1584,2,13,1,380.00,NULL,'2022-10-22 12:23:06','2022-10-22 12:23:06',NULL),(2027,NULL,1172,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:23:07','2022-10-22 12:23:07',NULL),(2028,NULL,1172,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:23:07','2022-10-22 12:23:07',NULL),(2029,NULL,1173,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:23:08','2022-10-22 12:23:08',NULL),(2030,NULL,1173,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:23:08','2022-10-22 12:23:08',NULL),(2031,NULL,1174,40720,1584,2,218,2,210.00,NULL,'2022-10-22 12:23:10','2022-10-22 12:23:10',NULL),(2032,NULL,1174,40720,1584,2,13,1,210.00,NULL,'2022-10-22 12:23:10','2022-10-22 12:23:10',NULL),(2033,NULL,1175,40720,1584,2,218,2,130.00,NULL,'2022-10-22 12:23:11','2022-10-22 12:23:11',NULL),(2034,NULL,1175,40720,1584,2,13,1,130.00,NULL,'2022-10-22 12:23:11','2022-10-22 12:23:11',NULL),(2035,NULL,1176,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:23:12','2022-10-22 12:23:12',NULL),(2036,NULL,1176,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:23:12','2022-10-22 12:23:12',NULL),(2037,NULL,1177,40720,1584,2,218,2,490.00,NULL,'2022-10-22 12:23:13','2022-10-22 12:23:13',NULL),(2038,NULL,1177,40720,1584,2,13,1,490.00,NULL,'2022-10-22 12:23:13','2022-10-22 12:23:13',NULL),(2039,NULL,1178,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:23:14','2022-10-22 12:23:14',NULL),(2040,NULL,1178,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:23:14','2022-10-22 12:23:14',NULL),(2041,NULL,1179,40720,1584,2,218,2,130.00,NULL,'2022-10-22 12:23:15','2022-10-22 12:23:15',NULL),(2042,NULL,1179,40720,1584,2,13,1,130.00,NULL,'2022-10-22 12:23:15','2022-10-22 12:23:15',NULL);
INSERT INTO `balance_libro_details` VALUES (2043,NULL,1180,40720,1584,2,218,2,60.00,NULL,'2022-10-22 12:23:16','2022-10-22 12:23:16',NULL),(2044,NULL,1180,40720,1584,2,13,1,60.00,NULL,'2022-10-22 12:23:16','2022-10-22 12:23:16',NULL),(2045,NULL,1181,40720,1584,2,218,2,80.00,NULL,'2022-10-22 12:23:17','2022-10-22 12:23:17',NULL),(2046,NULL,1181,40720,1584,2,13,1,80.00,NULL,'2022-10-22 12:23:17','2022-10-22 12:23:17',NULL),(2047,NULL,1182,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:23:18','2022-10-22 12:23:18',NULL),(2048,NULL,1182,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:23:18','2022-10-22 12:23:18',NULL),(2049,NULL,1183,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:23:19','2022-10-22 12:23:19',NULL),(2050,NULL,1183,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:23:19','2022-10-22 12:23:19',NULL),(2051,NULL,1184,40720,1584,2,218,2,300.00,NULL,'2022-10-22 12:23:20','2022-10-22 12:23:20',NULL),(2052,NULL,1184,40720,1584,2,13,1,300.00,NULL,'2022-10-22 12:23:20','2022-10-22 12:23:20',NULL),(2053,NULL,1185,40720,1584,2,218,2,850.00,NULL,'2022-10-22 12:23:21','2022-10-22 12:23:21',NULL),(2054,NULL,1185,40720,1584,2,13,1,850.00,NULL,'2022-10-22 12:23:21','2022-10-22 12:23:21',NULL),(2055,NULL,1186,40720,1584,2,218,2,170.00,NULL,'2022-10-22 12:23:22','2022-10-22 12:23:22',NULL),(2056,NULL,1186,40720,1584,2,13,1,170.00,NULL,'2022-10-22 12:23:22','2022-10-22 12:23:22',NULL),(2057,NULL,1187,40720,1584,2,218,2,510.00,NULL,'2022-10-22 12:23:23','2022-10-22 12:23:23',NULL),(2058,NULL,1187,40720,1584,2,13,1,510.00,NULL,'2022-10-22 12:23:23','2022-10-22 12:23:23',NULL),(2059,NULL,1188,40720,1584,2,218,2,670.00,NULL,'2022-10-22 12:23:24','2022-10-22 12:23:24',NULL),(2060,NULL,1188,40720,1584,2,13,1,670.00,NULL,'2022-10-22 12:23:24','2022-10-22 12:23:24',NULL),(2061,NULL,1189,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:23:25','2022-10-22 12:23:25',NULL),(2062,NULL,1189,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:23:25','2022-10-22 12:23:25',NULL),(2063,NULL,1190,40720,1584,2,218,2,320.00,NULL,'2022-10-22 12:23:26','2022-10-22 12:23:26',NULL),(2064,NULL,1190,40720,1584,2,13,1,320.00,NULL,'2022-10-22 12:23:26','2022-10-22 12:23:26',NULL),(2065,NULL,1191,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:23:28','2022-10-22 12:23:28',NULL),(2066,NULL,1191,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:23:28','2022-10-22 12:23:28',NULL),(2067,NULL,1192,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:23:29','2022-10-22 12:23:29',NULL),(2068,NULL,1192,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:23:29','2022-10-22 12:23:29',NULL),(2069,NULL,1193,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:23:30','2022-10-22 12:23:30',NULL),(2070,NULL,1193,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:23:30','2022-10-22 12:23:30',NULL),(2071,NULL,1194,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:23:32','2022-10-22 12:23:32',NULL),(2072,NULL,1194,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:23:32','2022-10-22 12:23:32',NULL),(2073,NULL,1195,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:23:33','2022-10-22 12:23:33',NULL),(2074,NULL,1195,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:23:33','2022-10-22 12:23:33',NULL),(2075,NULL,1196,40720,1584,2,218,2,120.00,NULL,'2022-10-22 12:23:34','2022-10-22 12:23:34',NULL),(2076,NULL,1196,40720,1584,2,13,1,120.00,NULL,'2022-10-22 12:23:34','2022-10-22 12:23:34',NULL),(2077,NULL,1197,40720,1584,2,218,2,120.00,NULL,'2022-10-22 12:23:35','2022-10-22 12:23:35',NULL),(2078,NULL,1197,40720,1584,2,13,1,120.00,NULL,'2022-10-22 12:23:35','2022-10-22 12:23:35',NULL),(2079,NULL,1198,40720,1584,2,218,2,100.00,NULL,'2022-10-22 12:23:36','2022-10-22 12:23:36',NULL),(2080,NULL,1198,40720,1584,2,13,1,100.00,NULL,'2022-10-22 12:23:36','2022-10-22 12:23:36',NULL),(2081,NULL,1199,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:23:37','2022-10-22 12:23:37',NULL),(2082,NULL,1199,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:23:37','2022-10-22 12:23:37',NULL),(2083,NULL,1200,40720,1584,2,218,2,880.00,NULL,'2022-10-22 12:29:33','2022-10-22 12:29:33',NULL);
INSERT INTO `balance_libro_details` VALUES (2084,NULL,1200,40720,1584,2,13,1,880.00,NULL,'2022-10-22 12:29:33','2022-10-22 12:29:33',NULL),(2085,NULL,1201,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:29:34','2022-10-22 12:29:34',NULL),(2086,NULL,1201,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:29:34','2022-10-22 12:29:34',NULL),(2087,NULL,1202,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:29:35','2022-10-22 12:29:35',NULL),(2088,NULL,1202,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:29:35','2022-10-22 12:29:35',NULL),(2089,NULL,1203,40720,1584,2,218,2,360.00,NULL,'2022-10-22 12:29:36','2022-10-22 12:29:36',NULL),(2090,NULL,1203,40720,1584,2,13,1,360.00,NULL,'2022-10-22 12:29:36','2022-10-22 12:29:36',NULL),(2091,NULL,1204,40720,1584,2,218,2,870.00,NULL,'2022-10-22 12:29:37','2022-10-22 12:29:37',NULL),(2092,NULL,1204,40720,1584,2,13,1,870.00,NULL,'2022-10-22 12:29:37','2022-10-22 12:29:37',NULL),(2093,NULL,1205,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:29:38','2022-10-22 12:29:38',NULL),(2094,NULL,1205,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:29:38','2022-10-22 12:29:38',NULL),(2095,NULL,1206,40720,1584,2,218,2,700.00,NULL,'2022-10-22 12:29:39','2022-10-22 12:29:39',NULL),(2096,NULL,1206,40720,1584,2,13,1,700.00,NULL,'2022-10-22 12:29:39','2022-10-22 12:29:39',NULL),(2097,NULL,1207,40720,1584,2,218,2,80.00,NULL,'2022-10-22 12:29:40','2022-10-22 12:29:40',NULL),(2098,NULL,1207,40720,1584,2,13,1,80.00,NULL,'2022-10-22 12:29:40','2022-10-22 12:29:40',NULL),(2099,NULL,1208,40720,1584,2,218,2,70.00,NULL,'2022-10-22 12:29:41','2022-10-22 12:29:41',NULL),(2100,NULL,1208,40720,1584,2,13,1,70.00,NULL,'2022-10-22 12:29:41','2022-10-22 12:29:41',NULL),(2101,NULL,1209,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:29:42','2022-10-22 12:29:42',NULL),(2102,NULL,1209,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:29:42','2022-10-22 12:29:42',NULL),(2103,NULL,1210,40720,1584,2,218,2,340.00,NULL,'2022-10-22 12:29:43','2022-10-22 12:29:43',NULL),(2104,NULL,1210,40720,1584,2,13,1,340.00,NULL,'2022-10-22 12:29:43','2022-10-22 12:29:43',NULL),(2105,NULL,1211,40720,1584,2,218,2,570.00,NULL,'2022-10-22 12:29:44','2022-10-22 12:29:44',NULL),(2106,NULL,1211,40720,1584,2,13,1,570.00,NULL,'2022-10-22 12:29:44','2022-10-22 12:29:44',NULL),(2107,NULL,1212,40720,1584,2,218,2,340.00,NULL,'2022-10-22 12:29:45','2022-10-22 12:29:45',NULL),(2108,NULL,1212,40720,1584,2,13,1,340.00,NULL,'2022-10-22 12:29:45','2022-10-22 12:29:45',NULL),(2109,NULL,1213,40720,1584,2,218,2,90.00,NULL,'2022-10-22 12:29:46','2022-10-22 12:29:46',NULL),(2110,NULL,1213,40720,1584,2,13,1,90.00,NULL,'2022-10-22 12:29:46','2022-10-22 12:29:46',NULL),(2111,NULL,1214,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:29:47','2022-10-22 12:29:47',NULL),(2112,NULL,1214,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:29:47','2022-10-22 12:29:47',NULL),(2113,NULL,1215,40720,1584,2,218,2,730.00,NULL,'2022-10-22 12:29:48','2022-10-22 12:29:48',NULL),(2114,NULL,1215,40720,1584,2,13,1,730.00,NULL,'2022-10-22 12:29:48','2022-10-22 12:29:48',NULL),(2115,NULL,1216,40720,1584,2,218,2,400.00,NULL,'2022-10-22 12:29:49','2022-10-22 12:29:49',NULL),(2116,NULL,1216,40720,1584,2,13,1,400.00,NULL,'2022-10-22 12:29:49','2022-10-22 12:29:49',NULL),(2117,NULL,1217,40720,1584,2,218,2,550.00,NULL,'2022-10-22 12:29:50','2022-10-22 12:29:50',NULL),(2118,NULL,1217,40720,1584,2,13,1,550.00,NULL,'2022-10-22 12:29:50','2022-10-22 12:29:50',NULL),(2119,NULL,1218,40720,1584,2,218,2,670.00,NULL,'2022-10-22 12:29:51','2022-10-22 12:29:51',NULL),(2120,NULL,1218,40720,1584,2,13,1,670.00,NULL,'2022-10-22 12:29:51','2022-10-22 12:29:51',NULL),(2121,NULL,1219,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:29:53','2022-10-22 12:29:53',NULL),(2122,NULL,1219,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:29:53','2022-10-22 12:29:53',NULL),(2123,NULL,1220,40720,1584,2,218,2,320.00,NULL,'2022-10-22 12:29:54','2022-10-22 12:29:54',NULL),(2124,NULL,1220,40720,1584,2,13,1,320.00,NULL,'2022-10-22 12:29:54','2022-10-22 12:29:54',NULL);
INSERT INTO `balance_libro_details` VALUES (2125,NULL,1221,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:29:55','2022-10-22 12:29:55',NULL),(2126,NULL,1221,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:29:55','2022-10-22 12:29:55',NULL),(2127,NULL,1222,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:29:56','2022-10-22 12:29:56',NULL),(2128,NULL,1222,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:29:56','2022-10-22 12:29:56',NULL),(2129,NULL,1223,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:29:57','2022-10-22 12:29:57',NULL),(2130,NULL,1223,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:29:57','2022-10-22 12:29:57',NULL),(2131,NULL,1224,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:29:58','2022-10-22 12:29:58',NULL),(2132,NULL,1224,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:29:58','2022-10-22 12:29:58',NULL),(2133,NULL,1225,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(2134,NULL,1225,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(2135,NULL,1226,40720,1584,2,218,2,120.00,NULL,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(2136,NULL,1226,40720,1584,2,13,1,120.00,NULL,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(2137,NULL,1227,40720,1584,2,218,2,120.00,NULL,'2022-10-22 12:30:00','2022-10-22 12:30:00',NULL),(2138,NULL,1227,40720,1584,2,13,1,120.00,NULL,'2022-10-22 12:30:00','2022-10-22 12:30:00',NULL),(2139,NULL,1228,40720,1584,2,218,2,100.00,NULL,'2022-10-22 12:30:01','2022-10-22 12:30:01',NULL),(2140,NULL,1228,40720,1584,2,13,1,100.00,NULL,'2022-10-22 12:30:01','2022-10-22 12:30:01',NULL),(2141,NULL,1229,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:30:02','2022-10-22 12:30:02',NULL),(2142,NULL,1229,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:30:02','2022-10-22 12:30:02',NULL),(2143,NULL,1230,40720,1584,2,218,2,390.00,NULL,'2022-10-22 12:33:54','2022-10-22 12:33:54',NULL),(2144,NULL,1230,40720,1584,2,13,1,390.00,NULL,'2022-10-22 12:33:54','2022-10-22 12:33:54',NULL),(2145,NULL,1231,40720,1584,2,218,2,1080.00,NULL,'2022-10-22 12:33:55','2022-10-22 12:33:55',NULL),(2146,NULL,1231,40720,1584,2,13,1,1080.00,NULL,'2022-10-22 12:33:55','2022-10-22 12:33:55',NULL),(2147,NULL,1232,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:33:56','2022-10-22 12:33:56',NULL),(2148,NULL,1232,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:33:56','2022-10-22 12:33:56',NULL),(2149,NULL,1233,40720,1584,2,218,2,190.00,NULL,'2022-10-22 12:33:57','2022-10-22 12:33:57',NULL),(2150,NULL,1233,40720,1584,2,13,1,190.00,NULL,'2022-10-22 12:33:57','2022-10-22 12:33:57',NULL),(2151,NULL,1234,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:33:58','2022-10-22 12:33:58',NULL),(2152,NULL,1234,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:33:58','2022-10-22 12:33:58',NULL),(2153,NULL,1235,40720,1584,2,218,2,380.00,NULL,'2022-10-22 12:33:59','2022-10-22 12:33:59',NULL),(2154,NULL,1235,40720,1584,2,13,1,380.00,NULL,'2022-10-22 12:33:59','2022-10-22 12:33:59',NULL),(2155,NULL,1236,40720,1584,2,218,2,390.00,NULL,'2022-10-22 12:34:00','2022-10-22 12:34:00',NULL),(2156,NULL,1236,40720,1584,2,13,1,390.00,NULL,'2022-10-22 12:34:00','2022-10-22 12:34:00',NULL),(2157,NULL,1237,40720,1584,2,218,2,1210.00,NULL,'2022-10-22 12:34:01','2022-10-22 12:34:01',NULL),(2158,NULL,1237,40720,1584,2,13,1,1210.00,NULL,'2022-10-22 12:34:01','2022-10-22 12:34:01',NULL),(2159,NULL,1238,40720,1584,2,218,2,330.00,NULL,'2022-10-22 12:34:02','2022-10-22 12:34:02',NULL),(2160,NULL,1238,40720,1584,2,13,1,330.00,NULL,'2022-10-22 12:34:02','2022-10-22 12:34:02',NULL),(2161,NULL,1239,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:34:03','2022-10-22 12:34:03',NULL),(2162,NULL,1239,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:34:03','2022-10-22 12:34:03',NULL),(2163,NULL,1240,40720,1584,2,218,2,440.00,NULL,'2022-10-22 12:34:04','2022-10-22 12:34:04',NULL),(2164,NULL,1240,40720,1584,2,13,1,440.00,NULL,'2022-10-22 12:34:04','2022-10-22 12:34:04',NULL),(2165,NULL,1241,40720,1584,2,218,2,250.00,NULL,'2022-10-22 12:34:06','2022-10-22 12:34:06',NULL);
INSERT INTO `balance_libro_details` VALUES (2166,NULL,1241,40720,1584,2,13,1,250.00,NULL,'2022-10-22 12:34:06','2022-10-22 12:34:06',NULL),(2167,NULL,1242,40720,1584,2,218,2,550.00,NULL,'2022-10-22 12:34:07','2022-10-22 12:34:07',NULL),(2168,NULL,1242,40720,1584,2,13,1,550.00,NULL,'2022-10-22 12:34:07','2022-10-22 12:34:07',NULL),(2169,NULL,1243,40720,1584,2,218,2,90.00,NULL,'2022-10-22 12:34:08','2022-10-22 12:34:08',NULL),(2170,NULL,1243,40720,1584,2,13,1,90.00,NULL,'2022-10-22 12:34:08','2022-10-22 12:34:08',NULL),(2171,NULL,1244,40720,1584,2,218,2,290.00,NULL,'2022-10-22 12:34:09','2022-10-22 12:34:09',NULL),(2172,NULL,1244,40720,1584,2,13,1,290.00,NULL,'2022-10-22 12:34:09','2022-10-22 12:34:09',NULL),(2173,NULL,1245,40720,1584,2,218,2,130.00,NULL,'2022-10-22 12:34:11','2022-10-22 12:34:11',NULL),(2174,NULL,1245,40720,1584,2,13,1,130.00,NULL,'2022-10-22 12:34:11','2022-10-22 12:34:11',NULL),(2175,NULL,1246,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:34:12','2022-10-22 12:34:12',NULL),(2176,NULL,1246,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:34:12','2022-10-22 12:34:12',NULL),(2177,NULL,1247,40720,1584,2,218,2,250.00,NULL,'2022-10-22 12:34:14','2022-10-22 12:34:14',NULL),(2178,NULL,1247,40720,1584,2,13,1,250.00,NULL,'2022-10-22 12:34:14','2022-10-22 12:34:14',NULL),(2179,NULL,1248,40720,1584,2,218,2,270.00,NULL,'2022-10-22 12:34:15','2022-10-22 12:34:15',NULL),(2180,NULL,1248,40720,1584,2,13,1,270.00,NULL,'2022-10-22 12:34:15','2022-10-22 12:34:15',NULL),(2181,NULL,1249,40720,1584,2,218,2,280.00,NULL,'2022-10-22 12:34:16','2022-10-22 12:34:16',NULL),(2182,NULL,1249,40720,1584,2,13,1,280.00,NULL,'2022-10-22 12:34:16','2022-10-22 12:34:16',NULL),(2183,NULL,1250,40720,1584,2,218,2,220.00,NULL,'2022-10-22 12:34:18','2022-10-22 12:34:18',NULL),(2184,NULL,1250,40720,1584,2,13,1,220.00,NULL,'2022-10-22 12:34:18','2022-10-22 12:34:18',NULL),(2185,NULL,1251,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:34:19','2022-10-22 12:34:19',NULL),(2186,NULL,1251,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:34:19','2022-10-22 12:34:19',NULL),(2187,NULL,1252,40720,1584,2,218,2,160.00,NULL,'2022-10-22 12:34:20','2022-10-22 12:34:20',NULL),(2188,NULL,1252,40720,1584,2,13,1,160.00,NULL,'2022-10-22 12:34:20','2022-10-22 12:34:20',NULL),(2189,NULL,1253,40720,1584,2,218,2,200.00,NULL,'2022-10-22 12:34:22','2022-10-22 12:34:22',NULL),(2190,NULL,1253,40720,1584,2,13,1,200.00,NULL,'2022-10-22 12:34:22','2022-10-22 12:34:22',NULL),(2191,NULL,1254,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:34:24','2022-10-22 12:34:24',NULL),(2192,NULL,1254,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:34:24','2022-10-22 12:34:24',NULL),(2193,NULL,1255,40720,1584,2,218,2,310.00,NULL,'2022-10-22 12:34:25','2022-10-22 12:34:25',NULL),(2194,NULL,1255,40720,1584,2,13,1,310.00,NULL,'2022-10-22 12:34:25','2022-10-22 12:34:25',NULL),(2195,NULL,1256,40720,1584,2,218,2,120.00,NULL,'2022-10-22 12:34:27','2022-10-22 12:34:27',NULL),(2196,NULL,1256,40720,1584,2,13,1,120.00,NULL,'2022-10-22 12:34:27','2022-10-22 12:34:27',NULL),(2197,NULL,1257,40720,1584,2,218,2,120.00,NULL,'2022-10-22 12:34:28','2022-10-22 12:34:28',NULL),(2198,NULL,1257,40720,1584,2,13,1,120.00,NULL,'2022-10-22 12:34:28','2022-10-22 12:34:28',NULL),(2199,NULL,1258,40720,1584,2,218,2,100.00,NULL,'2022-10-22 12:34:30','2022-10-22 12:34:30',NULL),(2200,NULL,1258,40720,1584,2,13,1,100.00,NULL,'2022-10-22 12:34:30','2022-10-22 12:34:30',NULL),(2201,NULL,1259,40720,1584,2,218,2,150.00,NULL,'2022-10-22 12:34:31','2022-10-22 12:34:31',NULL),(2202,NULL,1259,40720,1584,2,13,1,150.00,NULL,'2022-10-22 12:34:31','2022-10-22 12:34:31',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-09-05 13:20:44',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-09-05 13:20:44',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-09-05 13:20:44',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-05 13:20:44','2022-09-05 13:20:44',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-05 13:21:01','2022-09-05 13:21:01',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-05 13:21:01','2022-09-05 13:21:01',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-05 13:21:01','2022-09-05 13:21:01',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-05 13:21:01','2022-09-05 13:21:01',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:35:08',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:35:08',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:35:08',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:35:08',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:35:08',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:35:08',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:08',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:08',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',1414762.00,117896.00,'No Excluida','0',30,3330,230178.48,496.85,496.85,2192.15,3061.75,5750.75,5750.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',2103025.00,175252.00,'No Excluida','0',45,5000,230178.48,957.27,957.27,2411.36,3061.75,6430.38,6430.38,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',2944235.00,245352.00,'No Excluida','0',60,6700,460356.93,1636.83,1512.56,2652.52,3061.75,7351.10,7226.83,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',3656604.00,304717.00,'No Excluida','0',85,10000,460356.93,2689.05,2484.46,2917.75,3638.26,9245.06,9040.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',4305799.00,358816.00,'No Excluida','0',110,13000,573619.32,5115.04,3967.80,3209.55,4452.02,12776.61,11629.37,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',5382248.00,448520.00,'No Excluida','0',150,16500,575446.12,7036.89,5180.81,3530.49,5145.02,15712.40,13856.32,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',6458698.00,538224.00,'No Excluida','0',200,20000,690535.39,8951.39,6459.54,3883.53,5512.52,18347.44,15855.59,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',7996484.00,666373.00,'No Excluida','0',200,20000,920713.84,20460.26,15856.76,4271.88,6615.02,31347.16,26743.66,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',8949911.00,745825.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,25575.36,4699.08,8190.03,NULL,38464.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',10257028.00,854752.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,30054.72,5169.03,9166.53,NULL,44390.28,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',11379612.00,948301.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,34526.76,5685.87,10505.29,NULL,50717.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (1,7776,NULL,'Luciano2022',NULL,1,40719,1,'2022-10-07 15:40:50','2022-10-07 15:40:50',NULL),(3,7776,'AFIP','Patito2022',NULL,1,40720,1,'2022-10-11 00:12:12','2022-10-11 00:12:12',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(2,NULL,'Articulo 6',6,0,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(3,NULL,'Articulo 7',7,0,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(4,NULL,'Articulo 8',8,0,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(5,NULL,'Articulo 9',9,0,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(6,NULL,'Articulo 10',10,0,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(7,NULL,'Articulo 11',11,0,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(8,NULL,'Articulo 12',12,0,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(9,NULL,'Articulo 13',13,0,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL),(10,NULL,'Articulo 14',14,1,'2022-09-05 13:20:52','2022-09-05 13:20:52',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:43:35','2023-03-12 23:43:35',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1260 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7776,2,40720,40718,13,1584,1,0,'2022-10-11',650.00,1,1.00,'Factura C N°: 0004-00000001',NULL,'2022-10-11 00:21:00','2022-10-11 00:21:00',NULL),(2,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000002',NULL,'2022-10-11 00:26:07','2022-10-11 00:26:07',NULL),(3,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000003',NULL,'2022-10-11 00:26:09','2022-10-11 00:26:09',NULL),(4,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000004',NULL,'2022-10-11 00:26:12','2022-10-11 00:26:12',NULL),(5,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000005',NULL,'2022-10-11 00:26:13','2022-10-11 00:26:13',NULL),(6,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000006',NULL,'2022-10-11 00:26:16','2022-10-11 00:26:16',NULL),(7,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000007',NULL,'2022-10-11 00:26:18','2022-10-11 00:26:18',NULL),(8,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000008',NULL,'2022-10-11 00:26:20','2022-10-11 00:26:20',NULL),(9,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000009',NULL,'2022-10-11 00:26:21','2022-10-11 00:26:21',NULL),(10,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000010',NULL,'2022-10-11 00:26:23','2022-10-11 00:26:23',NULL),(11,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000011',NULL,'2022-10-11 00:26:24','2022-10-11 00:26:24',NULL),(12,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000012',NULL,'2022-10-11 00:26:26','2022-10-11 00:26:26',NULL),(13,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000013',NULL,'2022-10-11 00:26:28','2022-10-11 00:26:28',NULL),(14,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000014',NULL,'2022-10-11 00:26:31','2022-10-11 00:26:31',NULL),(15,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000015',NULL,'2022-10-11 00:26:33','2022-10-11 00:26:33',NULL),(16,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000016',NULL,'2022-10-11 00:26:34','2022-10-11 00:26:34',NULL),(17,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000017',NULL,'2022-10-11 00:26:36','2022-10-11 00:26:36',NULL),(18,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000018',NULL,'2022-10-11 00:26:38','2022-10-11 00:26:38',NULL),(19,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000019',NULL,'2022-10-11 00:26:39','2022-10-11 00:26:39',NULL),(20,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000020',NULL,'2022-10-11 00:26:41','2022-10-11 00:26:41',NULL),(21,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000021',NULL,'2022-10-11 00:26:44','2022-10-11 00:26:44',NULL),(22,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000022',NULL,'2022-10-11 00:26:46','2022-10-11 00:26:46',NULL),(23,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000023',NULL,'2022-10-11 00:26:48','2022-10-11 00:26:48',NULL),(24,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000024',NULL,'2022-10-11 00:26:49','2022-10-11 00:26:49',NULL),(25,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000025',NULL,'2022-10-11 00:26:51','2022-10-11 00:26:51',NULL),(26,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000026',NULL,'2022-10-11 00:26:53','2022-10-11 00:26:53',NULL),(27,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000027',NULL,'2022-10-11 00:26:55','2022-10-11 00:26:55',NULL);
INSERT INTO `cta_cte_cliente` VALUES (28,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000028',NULL,'2022-10-11 00:26:58','2022-10-11 00:26:58',NULL),(29,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000029',NULL,'2022-10-11 00:27:00','2022-10-11 00:27:00',NULL),(30,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000030',NULL,'2022-10-11 00:27:02','2022-10-11 00:27:02',NULL),(31,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000031',NULL,'2022-10-11 00:27:04','2022-10-11 00:27:04',NULL),(32,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000032',NULL,'2022-10-11 00:27:05','2022-10-11 00:27:05',NULL),(33,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000033',NULL,'2022-10-11 00:27:07','2022-10-11 00:27:07',NULL),(34,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000034',NULL,'2022-10-11 00:27:10','2022-10-11 00:27:10',NULL),(35,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000035',NULL,'2022-10-11 00:27:13','2022-10-11 00:27:13',NULL),(36,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000036',NULL,'2022-10-11 00:27:14','2022-10-11 00:27:14',NULL),(37,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000037',NULL,'2022-10-11 00:27:16','2022-10-11 00:27:16',NULL),(38,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000038',NULL,'2022-10-11 00:27:18','2022-10-11 00:27:18',NULL),(39,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000039',NULL,'2022-10-11 00:27:20','2022-10-11 00:27:20',NULL),(40,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000040',NULL,'2022-10-11 00:27:21','2022-10-11 00:27:21',NULL),(41,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000041',NULL,'2022-10-11 00:27:24','2022-10-11 00:27:24',NULL),(42,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000042',NULL,'2022-10-11 00:27:27','2022-10-11 00:27:27',NULL),(43,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000043',NULL,'2022-10-11 00:27:28','2022-10-11 00:27:28',NULL),(44,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000044',NULL,'2022-10-11 00:27:30','2022-10-11 00:27:30',NULL),(45,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000045',NULL,'2022-10-11 00:27:32','2022-10-11 00:27:32',NULL),(46,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000046',NULL,'2022-10-11 00:27:33','2022-10-11 00:27:33',NULL),(47,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000047',NULL,'2022-10-11 00:27:35','2022-10-11 00:27:35',NULL),(48,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000048',NULL,'2022-10-11 00:27:38','2022-10-11 00:27:38',NULL),(49,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000049',NULL,'2022-10-11 00:27:41','2022-10-11 00:27:41',NULL),(50,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000050',NULL,'2022-10-11 00:27:42','2022-10-11 00:27:42',NULL),(51,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000051',NULL,'2022-10-11 00:27:44','2022-10-11 00:27:44',NULL),(52,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000052',NULL,'2022-10-11 00:27:46','2022-10-11 00:27:46',NULL),(53,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000053',NULL,'2022-10-11 00:27:47','2022-10-11 00:27:47',NULL),(54,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000054',NULL,'2022-10-11 00:27:49','2022-10-11 00:27:49',NULL);
INSERT INTO `cta_cte_cliente` VALUES (55,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000055',NULL,'2022-10-11 00:27:52','2022-10-11 00:27:52',NULL),(56,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000056',NULL,'2022-10-11 00:27:55','2022-10-11 00:27:55',NULL),(57,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000057',NULL,'2022-10-11 00:27:56','2022-10-11 00:27:56',NULL),(58,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000058',NULL,'2022-10-11 00:27:58','2022-10-11 00:27:58',NULL),(59,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000059',NULL,'2022-10-11 00:28:00','2022-10-11 00:28:00',NULL),(60,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000060',NULL,'2022-10-11 00:28:02','2022-10-11 00:28:02',NULL),(61,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000061',NULL,'2022-10-11 00:28:03','2022-10-11 00:28:03',NULL),(62,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000062',NULL,'2022-10-11 00:28:06','2022-10-11 00:28:06',NULL),(63,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000063',NULL,'2022-10-11 00:28:08','2022-10-11 00:28:08',NULL),(64,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000064',NULL,'2022-10-11 00:28:10','2022-10-11 00:28:10',NULL),(65,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000065',NULL,'2022-10-11 00:28:11','2022-10-11 00:28:11',NULL),(66,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000066',NULL,'2022-10-11 00:28:13','2022-10-11 00:28:13',NULL),(67,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000067',NULL,'2022-10-11 00:28:15','2022-10-11 00:28:15',NULL),(68,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000068',NULL,'2022-10-11 00:28:16','2022-10-11 00:28:16',NULL),(69,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000069',NULL,'2022-10-11 00:28:19','2022-10-11 00:28:19',NULL),(70,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000070',NULL,'2022-10-11 00:28:22','2022-10-11 00:28:22',NULL),(71,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000071',NULL,'2022-10-11 00:28:23','2022-10-11 00:28:23',NULL),(72,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000072',NULL,'2022-10-11 00:28:25','2022-10-11 00:28:25',NULL),(73,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000073',NULL,'2022-10-11 00:28:27','2022-10-11 00:28:27',NULL),(74,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000074',NULL,'2022-10-11 00:28:28','2022-10-11 00:28:28',NULL),(75,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000075',NULL,'2022-10-11 00:28:30','2022-10-11 00:28:30',NULL),(76,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000076',NULL,'2022-10-11 00:28:33','2022-10-11 00:28:33',NULL),(77,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000077',NULL,'2022-10-11 00:28:35','2022-10-11 00:28:35',NULL),(78,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000078',NULL,'2022-10-11 00:28:37','2022-10-11 00:28:37',NULL),(79,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000079',NULL,'2022-10-11 00:28:39','2022-10-11 00:28:39',NULL),(80,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000080',NULL,'2022-10-11 00:28:40','2022-10-11 00:28:40',NULL),(81,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000081',NULL,'2022-10-11 00:28:42','2022-10-11 00:28:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (82,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000082',NULL,'2022-10-11 00:28:44','2022-10-11 00:28:44',NULL),(83,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000083',NULL,'2022-10-11 00:28:48','2022-10-11 00:28:48',NULL),(84,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000084',NULL,'2022-10-11 00:28:49','2022-10-11 00:28:49',NULL),(85,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000085',NULL,'2022-10-11 00:28:51','2022-10-11 00:28:51',NULL),(86,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000086',NULL,'2022-10-11 00:28:53','2022-10-11 00:28:53',NULL),(87,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000087',NULL,'2022-10-11 00:28:55','2022-10-11 00:28:55',NULL),(88,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000088',NULL,'2022-10-11 00:28:56','2022-10-11 00:28:56',NULL),(89,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000089',NULL,'2022-10-11 00:28:59','2022-10-11 00:28:59',NULL),(90,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000090',NULL,'2022-10-11 00:29:01','2022-10-11 00:29:01',NULL),(91,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000091',NULL,'2022-10-11 00:29:03','2022-10-11 00:29:03',NULL),(92,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000092',NULL,'2022-10-11 00:29:05','2022-10-11 00:29:05',NULL),(93,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000093',NULL,'2022-10-11 00:29:07','2022-10-11 00:29:07',NULL),(94,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000094',NULL,'2022-10-11 00:29:09','2022-10-11 00:29:09',NULL),(95,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000095',NULL,'2022-10-11 00:29:10','2022-10-11 00:29:10',NULL),(96,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000096',NULL,'2022-10-11 00:29:13','2022-10-11 00:29:13',NULL),(97,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000097',NULL,'2022-10-11 00:29:15','2022-10-11 00:29:15',NULL),(98,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000098',NULL,'2022-10-11 00:29:17','2022-10-11 00:29:17',NULL),(99,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000099',NULL,'2022-10-11 00:29:18','2022-10-11 00:29:18',NULL),(100,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000100',NULL,'2022-10-11 00:29:20','2022-10-11 00:29:20',NULL),(101,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000101',NULL,'2022-10-11 00:29:22','2022-10-11 00:29:22',NULL),(102,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000102',NULL,'2022-10-11 00:29:24','2022-10-11 00:29:24',NULL),(103,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000103',NULL,'2022-10-11 00:29:27','2022-10-11 00:29:27',NULL),(104,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000104',NULL,'2022-10-11 00:29:29','2022-10-11 00:29:29',NULL),(105,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000105',NULL,'2022-10-11 00:29:31','2022-10-11 00:29:31',NULL),(106,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000106',NULL,'2022-10-11 00:29:32','2022-10-11 00:29:32',NULL),(107,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000107',NULL,'2022-10-11 00:29:34','2022-10-11 00:29:34',NULL),(108,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000108',NULL,'2022-10-11 00:29:36','2022-10-11 00:29:36',NULL);
INSERT INTO `cta_cte_cliente` VALUES (109,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000109',NULL,'2022-10-11 00:29:38','2022-10-11 00:29:38',NULL),(110,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000110',NULL,'2022-10-11 00:29:40','2022-10-11 00:29:40',NULL),(111,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000111',NULL,'2022-10-11 00:29:42','2022-10-11 00:29:42',NULL),(112,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000112',NULL,'2022-10-11 00:29:44','2022-10-11 00:29:44',NULL),(113,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000113',NULL,'2022-10-11 00:29:45','2022-10-11 00:29:45',NULL),(114,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000114',NULL,'2022-10-11 00:29:47','2022-10-11 00:29:47',NULL),(115,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000115',NULL,'2022-10-11 00:29:49','2022-10-11 00:29:49',NULL),(116,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000116',NULL,'2022-10-11 00:29:51','2022-10-11 00:29:51',NULL),(117,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000117',NULL,'2022-10-11 00:29:54','2022-10-11 00:29:54',NULL),(118,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000118',NULL,'2022-10-11 00:29:55','2022-10-11 00:29:55',NULL),(119,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000119',NULL,'2022-10-11 00:29:57','2022-10-11 00:29:57',NULL),(120,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000120',NULL,'2022-10-11 00:29:59','2022-10-11 00:29:59',NULL),(121,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000121',NULL,'2022-10-11 00:30:01','2022-10-11 00:30:01',NULL),(122,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000122',NULL,'2022-10-11 00:30:03','2022-10-11 00:30:03',NULL),(123,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000123',NULL,'2022-10-11 00:30:06','2022-10-11 00:30:06',NULL),(124,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000124',NULL,'2022-10-11 00:30:08','2022-10-11 00:30:08',NULL),(125,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000125',NULL,'2022-10-11 00:30:09','2022-10-11 00:30:09',NULL),(126,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000126',NULL,'2022-10-11 00:30:11','2022-10-11 00:30:11',NULL),(127,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000127',NULL,'2022-10-11 00:30:13','2022-10-11 00:30:13',NULL),(128,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000128',NULL,'2022-10-11 00:30:15','2022-10-11 00:30:15',NULL),(129,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000129',NULL,'2022-10-11 00:30:19','2022-10-11 00:30:19',NULL),(130,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000130',NULL,'2022-10-11 00:30:21','2022-10-11 00:30:21',NULL),(131,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000131',NULL,'2022-10-11 00:30:22','2022-10-11 00:30:22',NULL),(132,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000132',NULL,'2022-10-11 00:30:24','2022-10-11 00:30:24',NULL),(133,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000133',NULL,'2022-10-11 00:30:26','2022-10-11 00:30:26',NULL),(134,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000134',NULL,'2022-10-11 00:30:28','2022-10-11 00:30:28',NULL),(135,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000135',NULL,'2022-10-11 00:30:30','2022-10-11 00:30:30',NULL);
INSERT INTO `cta_cte_cliente` VALUES (136,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000136',NULL,'2022-10-11 00:30:33','2022-10-11 00:30:33',NULL),(137,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000137',NULL,'2022-10-11 00:30:35','2022-10-11 00:30:35',NULL),(138,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000138',NULL,'2022-10-11 00:30:37','2022-10-11 00:30:37',NULL),(139,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000139',NULL,'2022-10-11 00:30:39','2022-10-11 00:30:39',NULL),(140,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000140',NULL,'2022-10-11 00:30:41','2022-10-11 00:30:41',NULL),(141,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000141',NULL,'2022-10-11 00:30:42','2022-10-11 00:30:42',NULL),(142,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000142',NULL,'2022-10-11 00:30:46','2022-10-11 00:30:46',NULL),(143,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000143',NULL,'2022-10-11 00:30:48','2022-10-11 00:30:48',NULL),(144,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000144',NULL,'2022-10-11 00:30:50','2022-10-11 00:30:50',NULL),(145,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000145',NULL,'2022-10-11 00:30:52','2022-10-11 00:30:52',NULL),(146,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000146',NULL,'2022-10-11 00:30:53','2022-10-11 00:30:53',NULL),(147,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000147',NULL,'2022-10-11 00:30:55','2022-10-11 00:30:55',NULL),(148,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000148',NULL,'2022-10-11 00:30:57','2022-10-11 00:30:57',NULL),(149,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000149',NULL,'2022-10-11 00:31:01','2022-10-11 00:31:01',NULL),(150,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000150',NULL,'2022-10-11 00:31:03','2022-10-11 00:31:03',NULL),(151,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000151',NULL,'2022-10-11 00:31:05','2022-10-11 00:31:05',NULL),(152,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000152',NULL,'2022-10-11 00:31:07','2022-10-11 00:31:07',NULL),(153,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000153',NULL,'2022-10-11 00:31:09','2022-10-11 00:31:09',NULL),(154,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000154',NULL,'2022-10-11 00:31:11','2022-10-11 00:31:11',NULL),(155,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000155',NULL,'2022-10-11 00:31:15','2022-10-11 00:31:15',NULL),(156,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000156',NULL,'2022-10-11 00:31:17','2022-10-11 00:31:17',NULL),(157,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000157',NULL,'2022-10-11 00:31:19','2022-10-11 00:31:19',NULL),(158,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000158',NULL,'2022-10-11 00:31:21','2022-10-11 00:31:21',NULL),(159,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000159',NULL,'2022-10-11 00:31:23','2022-10-11 00:31:23',NULL),(160,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000160',NULL,'2022-10-11 00:31:25','2022-10-11 00:31:25',NULL),(161,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000161',NULL,'2022-10-11 00:31:28','2022-10-11 00:31:28',NULL),(162,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000162',NULL,'2022-10-11 00:31:30','2022-10-11 00:31:30',NULL);
INSERT INTO `cta_cte_cliente` VALUES (163,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000163',NULL,'2022-10-11 00:31:32','2022-10-11 00:31:32',NULL),(164,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000164',NULL,'2022-10-11 00:31:34','2022-10-11 00:31:34',NULL),(165,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000165',NULL,'2022-10-11 00:31:35','2022-10-11 00:31:35',NULL),(166,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000166',NULL,'2022-10-11 00:31:37','2022-10-11 00:31:37',NULL),(167,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000167',NULL,'2022-10-11 00:31:39','2022-10-11 00:31:39',NULL),(168,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000168',NULL,'2022-10-11 00:31:42','2022-10-11 00:31:42',NULL),(169,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000169',NULL,'2022-10-11 00:31:44','2022-10-11 00:31:44',NULL),(170,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000170',NULL,'2022-10-11 00:31:46','2022-10-11 00:31:46',NULL),(171,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000171',NULL,'2022-10-11 00:31:48','2022-10-11 00:31:48',NULL),(172,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000172',NULL,'2022-10-11 00:31:50','2022-10-11 00:31:50',NULL),(173,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000173',NULL,'2022-10-11 00:31:52','2022-10-11 00:31:52',NULL),(174,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000174',NULL,'2022-10-11 00:31:54','2022-10-11 00:31:54',NULL),(175,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000175',NULL,'2022-10-11 00:31:56','2022-10-11 00:31:56',NULL),(176,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000176',NULL,'2022-10-11 00:31:58','2022-10-11 00:31:58',NULL),(177,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000177',NULL,'2022-10-11 00:32:00','2022-10-11 00:32:00',NULL),(178,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000178',NULL,'2022-10-11 00:32:02','2022-10-11 00:32:02',NULL),(179,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000179',NULL,'2022-10-11 00:32:05','2022-10-11 00:32:05',NULL),(180,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000180',NULL,'2022-10-11 00:32:07','2022-10-11 00:32:07',NULL),(181,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000181',NULL,'2022-10-11 00:32:09','2022-10-11 00:32:09',NULL),(182,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000182',NULL,'2022-10-11 00:32:11','2022-10-11 00:32:11',NULL),(183,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000183',NULL,'2022-10-11 00:32:13','2022-10-11 00:32:13',NULL),(184,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000184',NULL,'2022-10-11 00:32:15','2022-10-11 00:32:15',NULL),(185,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000185',NULL,'2022-10-11 00:32:17','2022-10-11 00:32:17',NULL),(186,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000186',NULL,'2022-10-11 00:32:20','2022-10-11 00:32:20',NULL),(187,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000187',NULL,'2022-10-11 00:32:22','2022-10-11 00:32:22',NULL),(188,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000188',NULL,'2022-10-11 00:32:24','2022-10-11 00:32:24',NULL),(189,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000189',NULL,'2022-10-11 00:32:25','2022-10-11 00:32:25',NULL);
INSERT INTO `cta_cte_cliente` VALUES (190,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000190',NULL,'2022-10-11 00:32:28','2022-10-11 00:32:28',NULL),(191,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000191',NULL,'2022-10-11 00:32:29','2022-10-11 00:32:29',NULL),(192,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000192',NULL,'2022-10-11 00:32:33','2022-10-11 00:32:33',NULL),(193,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000193',NULL,'2022-10-11 00:32:35','2022-10-11 00:32:35',NULL),(194,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000194',NULL,'2022-10-11 00:32:37','2022-10-11 00:32:37',NULL),(195,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000195',NULL,'2022-10-11 00:32:39','2022-10-11 00:32:39',NULL),(196,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000196',NULL,'2022-10-11 00:32:41','2022-10-11 00:32:41',NULL),(197,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000197',NULL,'2022-10-11 00:32:43','2022-10-11 00:32:43',NULL),(198,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000198',NULL,'2022-10-11 00:32:45','2022-10-11 00:32:45',NULL),(199,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000199',NULL,'2022-10-11 00:32:47','2022-10-11 00:32:47',NULL),(200,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000200',NULL,'2022-10-11 00:32:49','2022-10-11 00:32:49',NULL),(201,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000201',NULL,'2022-10-11 00:32:51','2022-10-11 00:32:51',NULL),(202,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000202',NULL,'2022-10-11 00:32:53','2022-10-11 00:32:53',NULL),(203,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000203',NULL,'2022-10-11 00:32:55','2022-10-11 00:32:55',NULL),(204,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000204',NULL,'2022-10-11 00:32:58','2022-10-11 00:32:58',NULL),(205,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000205',NULL,'2022-10-11 00:33:00','2022-10-11 00:33:00',NULL),(206,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000206',NULL,'2022-10-11 00:33:02','2022-10-11 00:33:02',NULL),(207,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000207',NULL,'2022-10-11 00:33:04','2022-10-11 00:33:04',NULL),(208,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000208',NULL,'2022-10-11 00:33:06','2022-10-11 00:33:06',NULL),(209,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000209',NULL,'2022-10-11 00:33:08','2022-10-11 00:33:08',NULL),(210,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000210',NULL,'2022-10-11 00:33:11','2022-10-11 00:33:11',NULL),(211,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000211',NULL,'2022-10-11 00:33:13','2022-10-11 00:33:13',NULL),(212,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000212',NULL,'2022-10-11 00:33:15','2022-10-11 00:33:15',NULL),(213,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000213',NULL,'2022-10-11 00:33:17','2022-10-11 00:33:17',NULL),(214,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000214',NULL,'2022-10-11 00:33:19','2022-10-11 00:33:19',NULL),(215,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000215',NULL,'2022-10-11 00:33:21','2022-10-11 00:33:21',NULL),(216,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000216',NULL,'2022-10-11 00:33:23','2022-10-11 00:33:23',NULL);
INSERT INTO `cta_cte_cliente` VALUES (217,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000217',NULL,'2022-10-11 00:33:25','2022-10-11 00:33:25',NULL),(218,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000218',NULL,'2022-10-11 00:33:27','2022-10-11 00:33:27',NULL),(219,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000219',NULL,'2022-10-11 00:33:29','2022-10-11 00:33:29',NULL),(220,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000220',NULL,'2022-10-11 00:33:31','2022-10-11 00:33:31',NULL),(221,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000221',NULL,'2022-10-11 00:33:34','2022-10-11 00:33:34',NULL),(222,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000222',NULL,'2022-10-11 00:33:36','2022-10-11 00:33:36',NULL),(223,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000223',NULL,'2022-10-11 00:33:38','2022-10-11 00:33:38',NULL),(224,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000224',NULL,'2022-10-11 00:33:40','2022-10-11 00:33:40',NULL),(225,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000225',NULL,'2022-10-11 00:33:42','2022-10-11 00:33:42',NULL),(226,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000226',NULL,'2022-10-11 00:33:45','2022-10-11 00:33:45',NULL),(227,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000227',NULL,'2022-10-11 00:33:47','2022-10-11 00:33:47',NULL),(228,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000228',NULL,'2022-10-11 00:33:49','2022-10-11 00:33:49',NULL),(229,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000229',NULL,'2022-10-11 00:33:51','2022-10-11 00:33:51',NULL),(230,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000230',NULL,'2022-10-11 00:33:53','2022-10-11 00:33:53',NULL),(231,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000231',NULL,'2022-10-11 00:33:55','2022-10-11 00:33:55',NULL),(232,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000232',NULL,'2022-10-11 00:33:57','2022-10-11 00:33:57',NULL),(233,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000233',NULL,'2022-10-11 00:34:00','2022-10-11 00:34:00',NULL),(234,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000234',NULL,'2022-10-11 00:34:02','2022-10-11 00:34:02',NULL),(235,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000235',NULL,'2022-10-11 00:34:04','2022-10-11 00:34:04',NULL),(236,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000236',NULL,'2022-10-11 00:34:06','2022-10-11 00:34:06',NULL),(237,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000237',NULL,'2022-10-11 00:34:08','2022-10-11 00:34:08',NULL),(238,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000238',NULL,'2022-10-11 00:34:11','2022-10-11 00:34:11',NULL),(239,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000239',NULL,'2022-10-11 00:34:13','2022-10-11 00:34:13',NULL),(240,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000240',NULL,'2022-10-11 00:34:15','2022-10-11 00:34:15',NULL),(241,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000241',NULL,'2022-10-11 00:34:17','2022-10-11 00:34:17',NULL),(242,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000242',NULL,'2022-10-11 00:34:19','2022-10-11 00:34:19',NULL),(243,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000243',NULL,'2022-10-11 00:34:21','2022-10-11 00:34:21',NULL);
INSERT INTO `cta_cte_cliente` VALUES (244,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000244',NULL,'2022-10-11 00:34:23','2022-10-11 00:34:23',NULL),(245,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000245',NULL,'2022-10-11 00:34:26','2022-10-11 00:34:26',NULL),(246,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000246',NULL,'2022-10-11 00:34:28','2022-10-11 00:34:28',NULL),(247,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000247',NULL,'2022-10-11 00:34:30','2022-10-11 00:34:30',NULL),(248,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000248',NULL,'2022-10-11 00:34:32','2022-10-11 00:34:32',NULL),(249,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000249',NULL,'2022-10-11 00:34:34','2022-10-11 00:34:34',NULL),(250,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000250',NULL,'2022-10-11 00:34:36','2022-10-11 00:34:36',NULL),(251,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000251',NULL,'2022-10-11 00:34:38','2022-10-11 00:34:38',NULL),(252,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000252',NULL,'2022-10-11 00:34:41','2022-10-11 00:34:41',NULL),(253,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000253',NULL,'2022-10-11 00:34:43','2022-10-11 00:34:43',NULL),(254,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000254',NULL,'2022-10-11 00:34:45','2022-10-11 00:34:45',NULL),(255,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000255',NULL,'2022-10-11 00:34:48','2022-10-11 00:34:48',NULL),(256,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000256',NULL,'2022-10-11 00:34:50','2022-10-11 00:34:50',NULL),(257,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000257',NULL,'2022-10-11 00:34:52','2022-10-11 00:34:52',NULL),(258,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000258',NULL,'2022-10-11 00:34:54','2022-10-11 00:34:54',NULL),(259,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000259',NULL,'2022-10-11 00:34:56','2022-10-11 00:34:56',NULL),(260,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000260',NULL,'2022-10-11 00:34:58','2022-10-11 00:34:58',NULL),(261,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000261',NULL,'2022-10-11 00:35:00','2022-10-11 00:35:00',NULL),(262,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000262',NULL,'2022-10-11 00:35:03','2022-10-11 00:35:03',NULL),(263,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000263',NULL,'2022-10-11 00:35:05','2022-10-11 00:35:05',NULL),(264,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000264',NULL,'2022-10-11 00:35:07','2022-10-11 00:35:07',NULL),(265,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000265',NULL,'2022-10-11 00:35:10','2022-10-11 00:35:10',NULL),(266,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000266',NULL,'2022-10-11 00:35:12','2022-10-11 00:35:12',NULL),(267,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000267',NULL,'2022-10-11 00:35:14','2022-10-11 00:35:14',NULL),(268,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000268',NULL,'2022-10-11 00:35:16','2022-10-11 00:35:16',NULL),(269,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000269',NULL,'2022-10-11 00:35:18','2022-10-11 00:35:18',NULL),(270,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000270',NULL,'2022-10-11 00:35:21','2022-10-11 00:35:21',NULL);
INSERT INTO `cta_cte_cliente` VALUES (271,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000271',NULL,'2022-10-11 00:35:23','2022-10-11 00:35:23',NULL),(272,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000272',NULL,'2022-10-11 00:35:25','2022-10-11 00:35:25',NULL),(273,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000273',NULL,'2022-10-11 00:35:27','2022-10-11 00:35:27',NULL),(274,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000274',NULL,'2022-10-11 00:35:29','2022-10-11 00:35:29',NULL),(275,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000275',NULL,'2022-10-11 00:35:31','2022-10-11 00:35:31',NULL),(276,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000276',NULL,'2022-10-11 00:35:35','2022-10-11 00:35:35',NULL),(277,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000277',NULL,'2022-10-11 00:35:37','2022-10-11 00:35:37',NULL),(278,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000278',NULL,'2022-10-11 00:35:39','2022-10-11 00:35:39',NULL),(279,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000279',NULL,'2022-10-11 00:35:41','2022-10-11 00:35:41',NULL),(280,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000280',NULL,'2022-10-11 00:35:43','2022-10-11 00:35:43',NULL),(281,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000281',NULL,'2022-10-11 00:35:45','2022-10-11 00:35:45',NULL),(282,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000282',NULL,'2022-10-11 00:35:48','2022-10-11 00:35:48',NULL),(283,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000283',NULL,'2022-10-11 00:35:50','2022-10-11 00:35:50',NULL),(284,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000284',NULL,'2022-10-11 00:35:52','2022-10-11 00:35:52',NULL),(285,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000285',NULL,'2022-10-11 00:35:54','2022-10-11 00:35:54',NULL),(286,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000286',NULL,'2022-10-11 00:35:56','2022-10-11 00:35:56',NULL),(287,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000287',NULL,'2022-10-11 00:35:59','2022-10-11 00:35:59',NULL),(288,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000288',NULL,'2022-10-11 00:36:01','2022-10-11 00:36:01',NULL),(289,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000289',NULL,'2022-10-11 00:36:04','2022-10-11 00:36:04',NULL),(290,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000290',NULL,'2022-10-11 00:36:06','2022-10-11 00:36:06',NULL),(291,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000291',NULL,'2022-10-11 00:36:08','2022-10-11 00:36:08',NULL),(292,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000292',NULL,'2022-10-11 00:36:10','2022-10-11 00:36:10',NULL),(293,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000293',NULL,'2022-10-11 00:36:13','2022-10-11 00:36:13',NULL),(294,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000294',NULL,'2022-10-11 00:36:15','2022-10-11 00:36:15',NULL),(295,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000295',NULL,'2022-10-11 00:36:17','2022-10-11 00:36:17',NULL),(296,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000296',NULL,'2022-10-11 00:36:19','2022-10-11 00:36:19',NULL),(297,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000297',NULL,'2022-10-11 00:36:21','2022-10-11 00:36:21',NULL);
INSERT INTO `cta_cte_cliente` VALUES (298,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000298',NULL,'2022-10-11 00:36:24','2022-10-11 00:36:24',NULL),(299,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000299',NULL,'2022-10-11 00:36:26','2022-10-11 00:36:26',NULL),(300,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000300',NULL,'2022-10-11 00:36:29','2022-10-11 00:36:29',NULL),(301,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000301',NULL,'2022-10-11 00:36:31','2022-10-11 00:36:31',NULL),(302,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000302',NULL,'2022-10-11 00:36:33','2022-10-11 00:36:33',NULL),(303,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000303',NULL,'2022-10-11 00:36:35','2022-10-11 00:36:35',NULL),(304,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000304',NULL,'2022-10-11 00:36:37','2022-10-11 00:36:37',NULL),(305,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000305',NULL,'2022-10-11 00:36:40','2022-10-11 00:36:40',NULL),(306,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000306',NULL,'2022-10-11 00:36:42','2022-10-11 00:36:42',NULL),(307,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000307',NULL,'2022-10-11 00:36:44','2022-10-11 00:36:44',NULL),(308,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000308',NULL,'2022-10-11 00:36:46','2022-10-11 00:36:46',NULL),(309,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000309',NULL,'2022-10-11 00:36:48','2022-10-11 00:36:48',NULL),(310,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000310',NULL,'2022-10-11 00:36:50','2022-10-11 00:36:50',NULL),(311,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000311',NULL,'2022-10-11 00:36:52','2022-10-11 00:36:52',NULL),(312,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000312',NULL,'2022-10-11 00:36:54','2022-10-11 00:36:54',NULL),(313,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000313',NULL,'2022-10-11 00:36:57','2022-10-11 00:36:57',NULL),(314,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000314',NULL,'2022-10-11 00:36:59','2022-10-11 00:36:59',NULL),(315,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000315',NULL,'2022-10-11 00:37:02','2022-10-11 00:37:02',NULL),(316,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000316',NULL,'2022-10-11 00:37:04','2022-10-11 00:37:04',NULL),(317,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',0.00,1,1.00,'Factura C N°: 0004-00000317',NULL,'2022-10-11 00:37:06','2022-10-11 00:37:06',NULL),(318,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',35.00,1,1.00,'Factura C N°: 0004-00000318',NULL,'2022-10-11 00:45:14','2022-10-11 00:45:14',NULL),(319,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',610.00,1,1.00,'Factura C N°: 0004-00000319',NULL,'2022-10-11 00:45:16','2022-10-11 00:45:16',NULL),(320,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000320',NULL,'2022-10-11 00:45:18','2022-10-11 00:45:18',NULL),(321,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',330.00,1,1.00,'Factura C N°: 0004-00000321',NULL,'2022-10-11 00:45:20','2022-10-11 00:45:20',NULL),(322,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',900.00,1,1.00,'Factura C N°: 0004-00000322',NULL,'2022-10-11 00:45:23','2022-10-11 00:45:23',NULL),(323,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',370.00,1,1.00,'Factura C N°: 0004-00000323',NULL,'2022-10-11 00:45:25','2022-10-11 00:45:25',NULL),(324,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000324',NULL,'2022-10-11 00:45:27','2022-10-11 00:45:27',NULL);
INSERT INTO `cta_cte_cliente` VALUES (325,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000325',NULL,'2022-10-11 00:45:29','2022-10-11 00:45:29',NULL),(326,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000326',NULL,'2022-10-11 00:45:31','2022-10-11 00:45:31',NULL),(327,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000327',NULL,'2022-10-11 00:45:33','2022-10-11 00:45:33',NULL),(328,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',100.00,1,1.00,'Factura C N°: 0004-00000328',NULL,'2022-10-11 00:45:36','2022-10-11 00:45:36',NULL),(329,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000329',NULL,'2022-10-11 00:45:38','2022-10-11 00:45:38',NULL),(330,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',380.00,1,1.00,'Factura C N°: 0004-00000330',NULL,'2022-10-11 00:45:40','2022-10-11 00:45:40',NULL),(331,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000331',NULL,'2022-10-11 00:45:42','2022-10-11 00:45:42',NULL),(332,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000332',NULL,'2022-10-11 00:45:44','2022-10-11 00:45:44',NULL),(333,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000333',NULL,'2022-10-11 00:45:46','2022-10-11 00:45:46',NULL),(334,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',170.00,1,1.00,'Factura C N°: 0004-00000334',NULL,'2022-10-11 00:45:48','2022-10-11 00:45:48',NULL),(335,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',650.00,1,1.00,'Factura C N°: 0004-00000335',NULL,'2022-10-11 00:45:51','2022-10-11 00:45:51',NULL),(336,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000336',NULL,'2022-10-11 00:45:53','2022-10-11 00:45:53',NULL),(337,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000337',NULL,'2022-10-11 00:45:55','2022-10-11 00:45:55',NULL),(338,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',370.00,1,1.00,'Factura C N°: 0004-00000338',NULL,'2022-10-11 00:45:57','2022-10-11 00:45:57',NULL),(339,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',90.00,1,1.00,'Factura C N°: 0004-00000339',NULL,'2022-10-11 00:46:00','2022-10-11 00:46:00',NULL),(340,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',410.00,1,1.00,'Factura C N°: 0004-00000340',NULL,'2022-10-11 00:46:02','2022-10-11 00:46:02',NULL),(341,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',100.00,1,1.00,'Factura C N°: 0004-00000341',NULL,'2022-10-11 00:46:05','2022-10-11 00:46:05',NULL),(342,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',850.00,1,1.00,'Factura C N°: 0004-00000342',NULL,'2022-10-11 00:46:07','2022-10-11 00:46:07',NULL),(343,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',470.00,1,1.00,'Factura C N°: 0004-00000343',NULL,'2022-10-11 00:46:09','2022-10-11 00:46:09',NULL),(344,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',200.00,1,1.00,'Factura C N°: 0004-00000344',NULL,'2022-10-11 00:46:11','2022-10-11 00:46:11',NULL),(345,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',190.00,1,1.00,'Factura C N°: 0004-00000345',NULL,'2022-10-11 00:46:13','2022-10-11 00:46:13',NULL),(346,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000346',NULL,'2022-10-11 00:46:16','2022-10-11 00:46:16',NULL),(347,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000347',NULL,'2022-10-11 00:46:18','2022-10-11 00:46:18',NULL),(348,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',990.00,1,1.00,'Factura C N°: 0004-00000348',NULL,'2022-10-11 00:46:20','2022-10-11 00:46:20',NULL),(349,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',230.00,1,1.00,'Factura C N°: 0004-00000349',NULL,'2022-10-11 00:46:23','2022-10-11 00:46:23',NULL),(350,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',60.00,1,1.00,'Factura C N°: 0004-00000350',NULL,'2022-10-11 00:46:25','2022-10-11 00:46:25',NULL),(351,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',310.00,1,1.00,'Factura C N°: 0004-00000351',NULL,'2022-10-11 00:46:27','2022-10-11 00:46:27',NULL);
INSERT INTO `cta_cte_cliente` VALUES (352,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',270.00,1,1.00,'Factura C N°: 0004-00000352',NULL,'2022-10-11 00:46:29','2022-10-11 00:46:29',NULL),(353,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000353',NULL,'2022-10-11 00:46:32','2022-10-11 00:46:32',NULL),(354,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000354',NULL,'2022-10-11 00:46:34','2022-10-11 00:46:34',NULL),(355,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',150.00,1,1.00,'Factura C N°: 0004-00000355',NULL,'2022-10-11 00:46:36','2022-10-11 00:46:36',NULL),(356,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000356',NULL,'2022-10-11 00:46:39','2022-10-11 00:46:39',NULL),(357,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',450.00,1,1.00,'Factura C N°: 0004-00000357',NULL,'2022-10-11 00:46:41','2022-10-11 00:46:41',NULL),(358,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',550.00,1,1.00,'Factura C N°: 0004-00000358',NULL,'2022-10-11 00:46:43','2022-10-11 00:46:43',NULL),(359,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',330.00,1,1.00,'Factura C N°: 0004-00000359',NULL,'2022-10-11 00:46:46','2022-10-11 00:46:46',NULL),(360,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000360',NULL,'2022-10-11 00:46:48','2022-10-11 00:46:48',NULL),(361,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000361',NULL,'2022-10-11 00:46:51','2022-10-11 00:46:51',NULL),(362,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',720.00,1,1.00,'Factura C N°: 0004-00000362',NULL,'2022-10-11 00:46:53','2022-10-11 00:46:53',NULL),(363,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',180.00,1,1.00,'Factura C N°: 0004-00000363',NULL,'2022-10-11 00:46:56','2022-10-11 00:46:56',NULL),(364,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000364',NULL,'2022-10-11 00:46:58','2022-10-11 00:46:58',NULL),(365,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',790.00,1,1.00,'Factura C N°: 0004-00000365',NULL,'2022-10-11 00:47:01','2022-10-11 00:47:01',NULL),(366,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000366',NULL,'2022-10-11 00:47:03','2022-10-11 00:47:03',NULL),(367,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000367',NULL,'2022-10-11 00:47:06','2022-10-11 00:47:06',NULL),(368,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000368',NULL,'2022-10-11 00:47:08','2022-10-11 00:47:08',NULL),(369,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',850.00,1,1.00,'Factura C N°: 0004-00000369',NULL,'2022-10-11 00:47:11','2022-10-11 00:47:11',NULL),(370,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',2600.00,1,1.00,'Factura C N°: 0004-00000370',NULL,'2022-10-11 00:47:13','2022-10-11 00:47:13',NULL),(371,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000371',NULL,'2022-10-11 00:47:15','2022-10-11 00:47:15',NULL),(372,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000372',NULL,'2022-10-11 00:47:17','2022-10-11 00:47:17',NULL),(373,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000373',NULL,'2022-10-11 00:47:20','2022-10-11 00:47:20',NULL),(374,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000374',NULL,'2022-10-11 00:47:22','2022-10-11 00:47:22',NULL),(375,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',1580.00,1,1.00,'Factura C N°: 0004-00000375',NULL,'2022-10-11 00:47:25','2022-10-11 00:47:25',NULL),(376,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000376',NULL,'2022-10-11 00:47:27','2022-10-11 00:47:27',NULL),(377,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000377',NULL,'2022-10-11 00:47:29','2022-10-11 00:47:29',NULL),(378,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',480.00,1,1.00,'Factura C N°: 0004-00000378',NULL,'2022-10-11 00:47:31','2022-10-11 00:47:31',NULL);
INSERT INTO `cta_cte_cliente` VALUES (379,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',530.00,1,1.00,'Factura C N°: 0004-00000379',NULL,'2022-10-11 00:47:34','2022-10-11 00:47:34',NULL),(380,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',550.00,1,1.00,'Factura C N°: 0004-00000380',NULL,'2022-10-11 00:47:36','2022-10-11 00:47:36',NULL),(381,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000381',NULL,'2022-10-11 00:47:38','2022-10-11 00:47:38',NULL),(382,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000382',NULL,'2022-10-11 00:47:40','2022-10-11 00:47:40',NULL),(383,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',200.00,1,1.00,'Factura C N°: 0004-00000383',NULL,'2022-10-11 00:47:43','2022-10-11 00:47:43',NULL),(384,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',820.00,1,1.00,'Factura C N°: 0004-00000384',NULL,'2022-10-11 00:47:45','2022-10-11 00:47:45',NULL),(385,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',650.00,1,1.00,'Factura C N°: 0004-00000385',NULL,'2022-10-11 00:47:47','2022-10-11 00:47:47',NULL),(386,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000386',NULL,'2022-10-11 00:47:49','2022-10-11 00:47:49',NULL),(387,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',630.00,1,1.00,'Factura C N°: 0004-00000387',NULL,'2022-10-11 00:47:51','2022-10-11 00:47:51',NULL),(388,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',100.00,1,1.00,'Factura C N°: 0004-00000388',NULL,'2022-10-11 00:47:54','2022-10-11 00:47:54',NULL),(389,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',170.00,1,1.00,'Factura C N°: 0004-00000389',NULL,'2022-10-11 00:47:56','2022-10-11 00:47:56',NULL),(390,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',330.00,1,1.00,'Factura C N°: 0004-00000390',NULL,'2022-10-11 00:47:59','2022-10-11 00:47:59',NULL),(391,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000391',NULL,'2022-10-11 00:48:01','2022-10-11 00:48:01',NULL),(392,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000392',NULL,'2022-10-11 00:48:03','2022-10-11 00:48:03',NULL),(393,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',200.00,1,1.00,'Factura C N°: 0004-00000393',NULL,'2022-10-11 00:48:06','2022-10-11 00:48:06',NULL),(394,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',180.00,1,1.00,'Factura C N°: 0004-00000394',NULL,'2022-10-11 00:48:08','2022-10-11 00:48:08',NULL),(395,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',140.00,1,1.00,'Factura C N°: 0004-00000395',NULL,'2022-10-11 00:48:10','2022-10-11 00:48:10',NULL),(396,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000396',NULL,'2022-10-11 00:48:13','2022-10-11 00:48:13',NULL),(397,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',670.00,1,1.00,'Factura C N°: 0004-00000397',NULL,'2022-10-11 00:48:15','2022-10-11 00:48:15',NULL),(398,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',800.00,1,1.00,'Factura C N°: 0004-00000398',NULL,'2022-10-11 00:48:17','2022-10-11 00:48:17',NULL),(399,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',170.00,1,1.00,'Factura C N°: 0004-00000399',NULL,'2022-10-11 00:48:20','2022-10-11 00:48:20',NULL),(400,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000400',NULL,'2022-10-11 00:48:22','2022-10-11 00:48:22',NULL),(401,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000401',NULL,'2022-10-11 00:48:25','2022-10-11 00:48:25',NULL),(402,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',140.00,1,1.00,'Factura C N°: 0004-00000402',NULL,'2022-10-11 00:48:27','2022-10-11 00:48:27',NULL),(403,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',150.00,1,1.00,'Factura C N°: 0004-00000403',NULL,'2022-10-11 00:48:29','2022-10-11 00:48:29',NULL),(404,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000404',NULL,'2022-10-11 00:48:31','2022-10-11 00:48:31',NULL),(405,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',470.00,1,1.00,'Factura C N°: 0004-00000405',NULL,'2022-10-11 00:48:33','2022-10-11 00:48:33',NULL);
INSERT INTO `cta_cte_cliente` VALUES (406,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',670.00,1,1.00,'Factura C N°: 0004-00000406',NULL,'2022-10-11 00:48:35','2022-10-11 00:48:35',NULL),(407,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',160.00,1,1.00,'Factura C N°: 0004-00000407',NULL,'2022-10-11 00:48:38','2022-10-11 00:48:38',NULL),(408,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',250.00,1,1.00,'Factura C N°: 0004-00000408',NULL,'2022-10-11 00:48:40','2022-10-11 00:48:40',NULL),(409,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',440.00,1,1.00,'Factura C N°: 0004-00000409',NULL,'2022-10-11 00:48:42','2022-10-11 00:48:42',NULL),(410,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000410',NULL,'2022-10-11 00:48:45','2022-10-11 00:48:45',NULL),(411,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000411',NULL,'2022-10-11 00:48:47','2022-10-11 00:48:47',NULL),(412,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',460.00,1,1.00,'Factura C N°: 0004-00000412',NULL,'2022-10-11 00:48:49','2022-10-11 00:48:49',NULL),(413,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',480.00,1,1.00,'Factura C N°: 0004-00000413',NULL,'2022-10-11 00:48:51','2022-10-11 00:48:51',NULL),(414,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',450.00,1,1.00,'Factura C N°: 0004-00000414',NULL,'2022-10-11 00:48:54','2022-10-11 00:48:54',NULL),(415,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',330.00,1,1.00,'Factura C N°: 0004-00000415',NULL,'2022-10-11 00:48:56','2022-10-11 00:48:56',NULL),(416,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000416',NULL,'2022-10-11 00:48:58','2022-10-11 00:48:58',NULL),(417,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',470.00,1,1.00,'Factura C N°: 0004-00000417',NULL,'2022-10-11 00:49:00','2022-10-11 00:49:00',NULL),(418,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',500.00,1,1.00,'Factura C N°: 0004-00000418',NULL,'2022-10-11 00:49:03','2022-10-11 00:49:03',NULL),(419,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',260.00,1,1.00,'Factura C N°: 0004-00000419',NULL,'2022-10-11 00:49:05','2022-10-11 00:49:05',NULL),(420,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',500.00,1,1.00,'Factura C N°: 0004-00000420',NULL,'2022-10-11 00:49:08','2022-10-11 00:49:08',NULL),(421,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000421',NULL,'2022-10-11 00:49:10','2022-10-11 00:49:10',NULL),(422,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',1640.00,1,1.00,'Factura C N°: 0004-00000422',NULL,'2022-10-11 00:49:12','2022-10-11 00:49:12',NULL),(423,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',390.00,1,1.00,'Factura C N°: 0004-00000423',NULL,'2022-10-11 00:49:15','2022-10-11 00:49:15',NULL),(424,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000424',NULL,'2022-10-11 00:49:17','2022-10-11 00:49:17',NULL),(425,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',140.00,1,1.00,'Factura C N°: 0004-00000425',NULL,'2022-10-11 00:49:19','2022-10-11 00:49:19',NULL),(426,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',770.00,1,1.00,'Factura C N°: 0004-00000426',NULL,'2022-10-11 00:49:22','2022-10-11 00:49:22',NULL),(427,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000427',NULL,'2022-10-11 00:49:24','2022-10-11 00:49:24',NULL),(428,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',440.00,1,1.00,'Factura C N°: 0004-00000428',NULL,'2022-10-11 00:49:26','2022-10-11 00:49:26',NULL),(429,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',170.00,1,1.00,'Factura C N°: 0004-00000429',NULL,'2022-10-11 00:49:29','2022-10-11 00:49:29',NULL),(430,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000430',NULL,'2022-10-11 00:49:31','2022-10-11 00:49:31',NULL),(431,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000431',NULL,'2022-10-11 00:49:33','2022-10-11 00:49:33',NULL),(432,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',290.00,1,1.00,'Factura C N°: 0004-00000432',NULL,'2022-10-11 00:49:36','2022-10-11 00:49:36',NULL);
INSERT INTO `cta_cte_cliente` VALUES (433,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',260.00,1,1.00,'Factura C N°: 0004-00000433',NULL,'2022-10-11 00:49:38','2022-10-11 00:49:38',NULL),(434,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',270.00,1,1.00,'Factura C N°: 0004-00000434',NULL,'2022-10-11 00:49:40','2022-10-11 00:49:40',NULL),(435,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000435',NULL,'2022-10-11 00:49:44','2022-10-11 00:49:44',NULL),(436,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',180.00,1,1.00,'Factura C N°: 0004-00000436',NULL,'2022-10-11 00:49:46','2022-10-11 00:49:46',NULL),(437,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',250.00,1,1.00,'Factura C N°: 0004-00000437',NULL,'2022-10-11 00:49:49','2022-10-11 00:49:49',NULL),(438,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',50.00,1,1.00,'Factura C N°: 0004-00000438',NULL,'2022-10-11 00:49:51','2022-10-11 00:49:51',NULL),(439,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',540.00,1,1.00,'Factura C N°: 0004-00000439',NULL,'2022-10-11 00:49:53','2022-10-11 00:49:53',NULL),(440,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000440',NULL,'2022-10-11 00:49:56','2022-10-11 00:49:56',NULL),(441,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000441',NULL,'2022-10-11 00:49:58','2022-10-11 00:49:58',NULL),(442,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',540.00,1,1.00,'Factura C N°: 0004-00000442',NULL,'2022-10-11 00:50:01','2022-10-11 00:50:01',NULL),(443,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000443',NULL,'2022-10-11 00:50:03','2022-10-11 00:50:03',NULL),(444,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',740.00,1,1.00,'Factura C N°: 0004-00000444',NULL,'2022-10-11 00:50:05','2022-10-11 00:50:05',NULL),(445,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',340.00,1,1.00,'Factura C N°: 0004-00000445',NULL,'2022-10-11 00:50:08','2022-10-11 00:50:08',NULL),(446,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000446',NULL,'2022-10-11 00:50:11','2022-10-11 00:50:11',NULL),(447,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',270.00,1,1.00,'Factura C N°: 0004-00000447',NULL,'2022-10-11 00:50:13','2022-10-11 00:50:13',NULL),(448,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000448',NULL,'2022-10-11 00:50:15','2022-10-11 00:50:15',NULL),(449,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',260.00,1,1.00,'Factura C N°: 0004-00000449',NULL,'2022-10-11 00:50:18','2022-10-11 00:50:18',NULL),(450,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000450',NULL,'2022-10-11 00:50:20','2022-10-11 00:50:20',NULL),(451,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',250.00,1,1.00,'Factura C N°: 0004-00000451',NULL,'2022-10-11 00:50:22','2022-10-11 00:50:22',NULL),(452,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000452',NULL,'2022-10-11 00:50:25','2022-10-11 00:50:25',NULL),(453,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',570.00,1,1.00,'Factura C N°: 0004-00000453',NULL,'2022-10-11 00:50:27','2022-10-11 00:50:27',NULL),(454,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',660.00,1,1.00,'Factura C N°: 0004-00000454',NULL,'2022-10-11 00:50:30','2022-10-11 00:50:30',NULL),(455,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000455',NULL,'2022-10-11 00:50:32','2022-10-11 00:50:32',NULL),(456,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',550.00,1,1.00,'Factura C N°: 0004-00000456',NULL,'2022-10-11 00:50:35','2022-10-11 00:50:35',NULL),(457,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',560.00,1,1.00,'Factura C N°: 0004-00000457',NULL,'2022-10-11 00:50:37','2022-10-11 00:50:37',NULL),(458,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',460.00,1,1.00,'Factura C N°: 0004-00000458',NULL,'2022-10-11 00:50:40','2022-10-11 00:50:40',NULL),(459,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000459',NULL,'2022-10-11 00:50:42','2022-10-11 00:50:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (460,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',900.00,1,1.00,'Factura C N°: 0004-00000460',NULL,'2022-10-11 00:50:45','2022-10-11 00:50:45',NULL),(461,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',140.00,1,1.00,'Factura C N°: 0004-00000461',NULL,'2022-10-11 00:50:47','2022-10-11 00:50:47',NULL),(462,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',270.00,1,1.00,'Factura C N°: 0004-00000462',NULL,'2022-10-11 00:50:49','2022-10-11 00:50:49',NULL),(463,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',580.00,1,1.00,'Factura C N°: 0004-00000463',NULL,'2022-10-11 00:50:52','2022-10-11 00:50:52',NULL),(464,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',380.00,1,1.00,'Factura C N°: 0004-00000464',NULL,'2022-10-11 00:50:55','2022-10-11 00:50:55',NULL),(465,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',460.00,1,1.00,'Factura C N°: 0004-00000465',NULL,'2022-10-11 00:50:57','2022-10-11 00:50:57',NULL),(466,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000466',NULL,'2022-10-11 00:51:00','2022-10-11 00:51:00',NULL),(467,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',2120.00,1,1.00,'Factura C N°: 0004-00000467',NULL,'2022-10-11 00:51:03','2022-10-11 00:51:03',NULL),(468,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',90.00,1,1.00,'Factura C N°: 0004-00000468',NULL,'2022-10-11 00:51:06','2022-10-11 00:51:06',NULL),(469,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',900.00,1,1.00,'Factura C N°: 0004-00000469',NULL,'2022-10-11 00:51:09','2022-10-11 00:51:09',NULL),(470,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000470',NULL,'2022-10-11 00:51:11','2022-10-11 00:51:11',NULL),(471,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',270.00,1,1.00,'Factura C N°: 0004-00000471',NULL,'2022-10-11 00:51:14','2022-10-11 00:51:14',NULL),(472,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',390.00,1,1.00,'Factura C N°: 0004-00000472',NULL,'2022-10-11 00:51:16','2022-10-11 00:51:16',NULL),(473,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',900.00,1,1.00,'Factura C N°: 0004-00000473',NULL,'2022-10-11 00:51:19','2022-10-11 00:51:19',NULL),(474,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',730.00,1,1.00,'Factura C N°: 0004-00000474',NULL,'2022-10-11 00:51:21','2022-10-11 00:51:21',NULL),(475,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',100.00,1,1.00,'Factura C N°: 0004-00000475',NULL,'2022-10-11 00:51:24','2022-10-11 00:51:24',NULL),(476,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',630.00,1,1.00,'Factura C N°: 0004-00000476',NULL,'2022-10-11 00:51:26','2022-10-11 00:51:26',NULL),(477,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000477',NULL,'2022-10-11 00:51:29','2022-10-11 00:51:29',NULL),(478,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',550.00,1,1.00,'Factura C N°: 0004-00000478',NULL,'2022-10-11 00:51:31','2022-10-11 00:51:31',NULL),(479,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',270.00,1,1.00,'Factura C N°: 0004-00000479',NULL,'2022-10-11 00:51:34','2022-10-11 00:51:34',NULL),(480,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',500.00,1,1.00,'Factura C N°: 0004-00000480',NULL,'2022-10-11 00:51:36','2022-10-11 00:51:36',NULL),(481,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',250.00,1,1.00,'Factura C N°: 0004-00000481',NULL,'2022-10-11 00:51:39','2022-10-11 00:51:39',NULL),(482,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',170.00,1,1.00,'Factura C N°: 0004-00000482',NULL,'2022-10-11 00:51:41','2022-10-11 00:51:41',NULL),(483,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',650.00,1,1.00,'Factura C N°: 0004-00000483',NULL,'2022-10-11 00:51:44','2022-10-11 00:51:44',NULL),(484,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000484',NULL,'2022-10-11 00:51:46','2022-10-11 00:51:46',NULL),(485,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',260.00,1,1.00,'Factura C N°: 0004-00000485',NULL,'2022-10-11 00:51:49','2022-10-11 00:51:49',NULL),(486,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000486',NULL,'2022-10-11 00:51:51','2022-10-11 00:51:51',NULL);
INSERT INTO `cta_cte_cliente` VALUES (487,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000487',NULL,'2022-10-11 00:51:54','2022-10-11 00:51:54',NULL),(488,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',490.00,1,1.00,'Factura C N°: 0004-00000488',NULL,'2022-10-11 00:51:56','2022-10-11 00:51:56',NULL),(489,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000489',NULL,'2022-10-11 00:51:59','2022-10-11 00:51:59',NULL),(490,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',290.00,1,1.00,'Factura C N°: 0004-00000490',NULL,'2022-10-11 00:52:02','2022-10-11 00:52:02',NULL),(491,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000491',NULL,'2022-10-11 00:52:04','2022-10-11 00:52:04',NULL),(492,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000492',NULL,'2022-10-11 00:52:06','2022-10-11 00:52:06',NULL),(493,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',460.00,1,1.00,'Factura C N°: 0004-00000493',NULL,'2022-10-11 00:52:09','2022-10-11 00:52:09',NULL),(494,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000494',NULL,'2022-10-11 00:52:11','2022-10-11 00:52:11',NULL),(495,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000495',NULL,'2022-10-11 00:52:13','2022-10-11 00:52:13',NULL),(496,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000496',NULL,'2022-10-11 00:52:16','2022-10-11 00:52:16',NULL),(497,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',2600.00,1,1.00,'Factura C N°: 0004-00000497',NULL,'2022-10-11 00:52:18','2022-10-11 00:52:18',NULL),(498,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',170.00,1,1.00,'Factura C N°: 0004-00000498',NULL,'2022-10-11 00:52:21','2022-10-11 00:52:21',NULL),(499,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',1090.00,1,1.00,'Factura C N°: 0004-00000499',NULL,'2022-10-11 00:52:23','2022-10-11 00:52:23',NULL),(500,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000500',NULL,'2022-10-11 00:52:26','2022-10-11 00:52:26',NULL),(501,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',630.00,1,1.00,'Factura C N°: 0004-00000501',NULL,'2022-10-11 00:52:28','2022-10-11 00:52:28',NULL),(502,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',580.00,1,1.00,'Factura C N°: 0004-00000502',NULL,'2022-10-11 00:52:30','2022-10-11 00:52:30',NULL),(503,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',360.00,1,1.00,'Factura C N°: 0004-00000503',NULL,'2022-10-11 00:52:33','2022-10-11 00:52:33',NULL),(504,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',540.00,1,1.00,'Factura C N°: 0004-00000504',NULL,'2022-10-11 00:52:36','2022-10-11 00:52:36',NULL),(505,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000505',NULL,'2022-10-11 00:52:39','2022-10-11 00:52:39',NULL),(506,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',820.00,1,1.00,'Factura C N°: 0004-00000506',NULL,'2022-10-11 00:52:41','2022-10-11 00:52:41',NULL),(507,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',1060.00,1,1.00,'Factura C N°: 0004-00000507',NULL,'2022-10-11 00:52:44','2022-10-11 00:52:44',NULL),(508,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000508',NULL,'2022-10-11 00:52:46','2022-10-11 00:52:46',NULL),(509,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',360.00,1,1.00,'Factura C N°: 0004-00000509',NULL,'2022-10-11 00:52:49','2022-10-11 00:52:49',NULL),(510,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',440.00,1,1.00,'Factura C N°: 0004-00000510',NULL,'2022-10-11 00:52:51','2022-10-11 00:52:51',NULL),(511,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000511',NULL,'2022-10-11 00:52:54','2022-10-11 00:52:54',NULL),(512,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',630.00,1,1.00,'Factura C N°: 0004-00000512',NULL,'2022-10-11 00:52:56','2022-10-11 00:52:56',NULL),(513,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000513',NULL,'2022-10-11 00:52:59','2022-10-11 00:52:59',NULL);
INSERT INTO `cta_cte_cliente` VALUES (514,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000514',NULL,'2022-10-11 00:53:02','2022-10-11 00:53:02',NULL),(515,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000515',NULL,'2022-10-11 00:53:04','2022-10-11 00:53:04',NULL),(516,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',1700.00,1,1.00,'Factura C N°: 0004-00000516',NULL,'2022-10-11 00:53:07','2022-10-11 00:53:07',NULL),(517,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',290.00,1,1.00,'Factura C N°: 0004-00000517',NULL,'2022-10-11 00:53:10','2022-10-11 00:53:10',NULL),(518,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',200.00,1,1.00,'Factura C N°: 0004-00000518',NULL,'2022-10-11 00:53:12','2022-10-11 00:53:12',NULL),(519,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',670.00,1,1.00,'Factura C N°: 0004-00000519',NULL,'2022-10-11 00:53:15','2022-10-11 00:53:15',NULL),(520,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',140.00,1,1.00,'Factura C N°: 0004-00000520',NULL,'2022-10-11 00:53:17','2022-10-11 00:53:17',NULL),(521,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',560.00,1,1.00,'Factura C N°: 0004-00000521',NULL,'2022-10-11 00:53:20','2022-10-11 00:53:20',NULL),(522,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',260.00,1,1.00,'Factura C N°: 0004-00000522',NULL,'2022-10-11 00:53:22','2022-10-11 00:53:22',NULL),(523,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',600.00,1,1.00,'Factura C N°: 0004-00000523',NULL,'2022-10-11 00:53:25','2022-10-11 00:53:25',NULL),(524,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',740.00,1,1.00,'Factura C N°: 0004-00000524',NULL,'2022-10-11 00:53:27','2022-10-11 00:53:27',NULL),(525,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000525',NULL,'2022-10-11 00:53:30','2022-10-11 00:53:30',NULL),(526,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000526',NULL,'2022-10-11 00:53:33','2022-10-11 00:53:33',NULL),(527,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000527',NULL,'2022-10-11 00:53:35','2022-10-11 00:53:35',NULL),(528,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',830.00,1,1.00,'Factura C N°: 0004-00000528',NULL,'2022-10-11 00:53:38','2022-10-11 00:53:38',NULL),(529,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',260.00,1,1.00,'Factura C N°: 0004-00000529',NULL,'2022-10-11 00:53:40','2022-10-11 00:53:40',NULL),(530,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000530',NULL,'2022-10-11 00:53:43','2022-10-11 00:53:43',NULL),(531,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',90.00,1,1.00,'Factura C N°: 0004-00000531',NULL,'2022-10-11 00:53:45','2022-10-11 00:53:45',NULL),(532,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',350.00,1,1.00,'Factura C N°: 0004-00000532',NULL,'2022-10-11 00:53:48','2022-10-11 00:53:48',NULL),(533,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',640.00,1,1.00,'Factura C N°: 0004-00000533',NULL,'2022-10-11 00:53:50','2022-10-11 00:53:50',NULL),(534,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000534',NULL,'2022-10-11 00:53:53','2022-10-11 00:53:53',NULL),(535,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000535',NULL,'2022-10-11 00:53:56','2022-10-11 00:53:56',NULL),(536,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000536',NULL,'2022-10-11 00:53:58','2022-10-11 00:53:58',NULL),(537,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',840.00,1,1.00,'Factura C N°: 0004-00000537',NULL,'2022-10-11 00:54:00','2022-10-11 00:54:00',NULL),(538,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000538',NULL,'2022-10-11 00:54:03','2022-10-11 00:54:03',NULL),(539,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',600.00,1,1.00,'Factura C N°: 0004-00000539',NULL,'2022-10-11 00:54:06','2022-10-11 00:54:06',NULL),(540,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000540',NULL,'2022-10-11 00:54:08','2022-10-11 00:54:08',NULL);
INSERT INTO `cta_cte_cliente` VALUES (541,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',290.00,1,1.00,'Factura C N°: 0004-00000541',NULL,'2022-10-11 00:54:10','2022-10-11 00:54:10',NULL),(542,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',180.00,1,1.00,'Factura C N°: 0004-00000542',NULL,'2022-10-11 00:54:13','2022-10-11 00:54:13',NULL),(543,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',530.00,1,1.00,'Factura C N°: 0004-00000543',NULL,'2022-10-11 00:54:16','2022-10-11 00:54:16',NULL),(544,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',300.00,1,1.00,'Factura C N°: 0004-00000544',NULL,'2022-10-11 00:54:18','2022-10-11 00:54:18',NULL),(545,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',90.00,1,1.00,'Factura C N°: 0004-00000545',NULL,'2022-10-11 00:54:20','2022-10-11 00:54:20',NULL),(546,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000546',NULL,'2022-10-11 00:54:23','2022-10-11 00:54:23',NULL),(547,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000547',NULL,'2022-10-11 00:54:25','2022-10-11 00:54:25',NULL),(548,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',140.00,1,1.00,'Factura C N°: 0004-00000548',NULL,'2022-10-11 00:54:28','2022-10-11 00:54:28',NULL),(549,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000549',NULL,'2022-10-11 00:54:30','2022-10-11 00:54:30',NULL),(550,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000550',NULL,'2022-10-11 00:54:33','2022-10-11 00:54:33',NULL),(551,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000551',NULL,'2022-10-11 00:54:35','2022-10-11 00:54:35',NULL),(552,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',540.00,1,1.00,'Factura C N°: 0004-00000552',NULL,'2022-10-11 00:54:38','2022-10-11 00:54:38',NULL),(553,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',540.00,1,1.00,'Factura C N°: 0004-00000553',NULL,'2022-10-11 00:54:41','2022-10-11 00:54:41',NULL),(554,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',260.00,1,1.00,'Factura C N°: 0004-00000554',NULL,'2022-10-11 00:54:44','2022-10-11 00:54:44',NULL),(555,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000555',NULL,'2022-10-11 00:54:46','2022-10-11 00:54:46',NULL),(556,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',160.00,1,1.00,'Factura C N°: 0004-00000556',NULL,'2022-10-11 00:54:49','2022-10-11 00:54:49',NULL),(557,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',150.00,1,1.00,'Factura C N°: 0004-00000557',NULL,'2022-10-11 00:54:52','2022-10-11 00:54:52',NULL),(558,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',260.00,1,1.00,'Factura C N°: 0004-00000558',NULL,'2022-10-11 00:54:54','2022-10-11 00:54:54',NULL),(559,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000559',NULL,'2022-10-11 00:54:57','2022-10-11 00:54:57',NULL),(560,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000560',NULL,'2022-10-11 00:54:59','2022-10-11 00:54:59',NULL),(561,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',240.00,1,1.00,'Factura C N°: 0004-00000561',NULL,'2022-10-11 00:55:03','2022-10-11 00:55:03',NULL),(562,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',460.00,1,1.00,'Factura C N°: 0004-00000562',NULL,'2022-10-11 00:55:05','2022-10-11 00:55:05',NULL),(563,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',100.00,1,1.00,'Factura C N°: 0004-00000563',NULL,'2022-10-11 00:55:08','2022-10-11 00:55:08',NULL),(564,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',60.00,1,1.00,'Factura C N°: 0004-00000564',NULL,'2022-10-11 00:55:11','2022-10-11 00:55:11',NULL),(565,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',800.00,1,1.00,'Factura C N°: 0004-00000565',NULL,'2022-10-11 00:55:14','2022-10-11 00:55:14',NULL),(566,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',110.00,1,1.00,'Factura C N°: 0004-00000566',NULL,'2022-10-11 00:55:16','2022-10-11 00:55:16',NULL),(567,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',410.00,1,1.00,'Factura C N°: 0004-00000567',NULL,'2022-10-11 00:55:19','2022-10-11 00:55:19',NULL);
INSERT INTO `cta_cte_cliente` VALUES (568,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000568',NULL,'2022-10-11 00:55:21','2022-10-11 00:55:21',NULL),(569,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',180.00,1,1.00,'Factura C N°: 0004-00000569',NULL,'2022-10-11 00:55:24','2022-10-11 00:55:24',NULL),(570,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',320.00,1,1.00,'Factura C N°: 0004-00000570',NULL,'2022-10-11 00:55:27','2022-10-11 00:55:27',NULL),(571,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',170.00,1,1.00,'Factura C N°: 0004-00000571',NULL,'2022-10-11 00:55:29','2022-10-11 00:55:29',NULL),(572,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000572',NULL,'2022-10-11 00:55:32','2022-10-11 00:55:32',NULL),(573,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000573',NULL,'2022-10-11 00:55:34','2022-10-11 00:55:34',NULL),(574,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000574',NULL,'2022-10-11 00:55:37','2022-10-11 00:55:37',NULL),(575,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000575',NULL,'2022-10-11 00:55:40','2022-10-11 00:55:40',NULL),(576,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000576',NULL,'2022-10-11 00:55:43','2022-10-11 00:55:43',NULL),(577,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000577',NULL,'2022-10-11 00:55:46','2022-10-11 00:55:46',NULL),(578,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',470.00,1,1.00,'Factura C N°: 0004-00000578',NULL,'2022-10-11 00:55:48','2022-10-11 00:55:48',NULL),(579,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',680.00,1,1.00,'Factura C N°: 0004-00000579',NULL,'2022-10-11 00:55:51','2022-10-11 00:55:51',NULL),(580,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',380.00,1,1.00,'Factura C N°: 0004-00000580',NULL,'2022-10-11 00:55:54','2022-10-11 00:55:54',NULL),(581,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',550.00,1,1.00,'Factura C N°: 0004-00000581',NULL,'2022-10-11 00:55:57','2022-10-11 00:55:57',NULL),(582,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',410.00,1,1.00,'Factura C N°: 0004-00000582',NULL,'2022-10-11 00:55:59','2022-10-11 00:55:59',NULL),(583,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',370.00,1,1.00,'Factura C N°: 0004-00000583',NULL,'2022-10-11 00:56:02','2022-10-11 00:56:02',NULL),(584,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000584',NULL,'2022-10-11 00:56:05','2022-10-11 00:56:05',NULL),(585,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000585',NULL,'2022-10-11 00:56:08','2022-10-11 00:56:08',NULL),(586,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000586',NULL,'2022-10-11 00:56:11','2022-10-11 00:56:11',NULL),(587,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000587',NULL,'2022-10-11 00:56:14','2022-10-11 00:56:14',NULL),(588,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',400.00,1,1.00,'Factura C N°: 0004-00000588',NULL,'2022-10-11 00:56:16','2022-10-11 00:56:16',NULL),(589,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',480.00,1,1.00,'Factura C N°: 0004-00000589',NULL,'2022-10-11 00:56:19','2022-10-11 00:56:19',NULL),(590,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',410.00,1,1.00,'Factura C N°: 0004-00000590',NULL,'2022-10-11 00:56:22','2022-10-11 00:56:22',NULL),(591,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',860.00,1,1.00,'Factura C N°: 0004-00000591',NULL,'2022-10-11 00:56:25','2022-10-11 00:56:25',NULL),(592,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',150.00,1,1.00,'Factura C N°: 0004-00000592',NULL,'2022-10-11 00:56:27','2022-10-11 00:56:27',NULL),(593,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000593',NULL,'2022-10-11 00:56:30','2022-10-11 00:56:30',NULL),(594,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',180.00,1,1.00,'Factura C N°: 0004-00000594',NULL,'2022-10-11 00:56:33','2022-10-11 00:56:33',NULL);
INSERT INTO `cta_cte_cliente` VALUES (595,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',40.00,1,1.00,'Factura C N°: 0004-00000595',NULL,'2022-10-11 00:56:36','2022-10-11 00:56:36',NULL),(596,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',200.00,1,1.00,'Factura C N°: 0004-00000596',NULL,'2022-10-11 00:56:38','2022-10-11 00:56:38',NULL),(597,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',740.00,1,1.00,'Factura C N°: 0004-00000597',NULL,'2022-10-11 00:56:41','2022-10-11 00:56:41',NULL),(598,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',1110.00,1,1.00,'Factura C N°: 0004-00000598',NULL,'2022-10-11 00:56:44','2022-10-11 00:56:44',NULL),(599,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',340.00,1,1.00,'Factura C N°: 0004-00000599',NULL,'2022-10-11 00:56:46','2022-10-11 00:56:46',NULL),(600,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',200.00,1,1.00,'Factura C N°: 0004-00000600',NULL,'2022-10-11 00:56:49','2022-10-11 00:56:49',NULL),(601,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',590.00,1,1.00,'Factura C N°: 0004-00000601',NULL,'2022-10-11 00:56:52','2022-10-11 00:56:52',NULL),(602,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',360.00,1,1.00,'Factura C N°: 0004-00000602',NULL,'2022-10-11 00:56:55','2022-10-11 00:56:55',NULL),(603,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',140.00,1,1.00,'Factura C N°: 0004-00000603',NULL,'2022-10-11 00:56:57','2022-10-11 00:56:57',NULL),(604,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',250.00,1,1.00,'Factura C N°: 0004-00000604',NULL,'2022-10-11 00:57:00','2022-10-11 00:57:00',NULL),(605,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',370.00,1,1.00,'Factura C N°: 0004-00000605',NULL,'2022-10-11 00:57:03','2022-10-11 00:57:03',NULL),(606,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',380.00,1,1.00,'Factura C N°: 0004-00000606',NULL,'2022-10-11 00:57:06','2022-10-11 00:57:06',NULL),(607,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000607',NULL,'2022-10-11 00:57:09','2022-10-11 00:57:09',NULL),(608,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000608',NULL,'2022-10-11 00:57:11','2022-10-11 00:57:11',NULL),(609,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',130.00,1,1.00,'Factura C N°: 0004-00000609',NULL,'2022-10-11 00:57:14','2022-10-11 00:57:14',NULL),(610,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',380.00,1,1.00,'Factura C N°: 0004-00000610',NULL,'2022-10-11 00:57:17','2022-10-11 00:57:17',NULL),(611,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000611',NULL,'2022-10-11 00:57:20','2022-10-11 00:57:20',NULL),(612,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000612',NULL,'2022-10-11 00:57:22','2022-10-11 00:57:22',NULL),(613,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',960.00,1,1.00,'Factura C N°: 0004-00000613',NULL,'2022-10-11 00:57:25','2022-10-11 00:57:25',NULL),(614,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',790.00,1,1.00,'Factura C N°: 0004-00000614',NULL,'2022-10-11 00:57:28','2022-10-11 00:57:28',NULL),(615,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',120.00,1,1.00,'Factura C N°: 0004-00000615',NULL,'2022-10-11 00:57:30','2022-10-11 00:57:30',NULL),(616,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',360.00,1,1.00,'Factura C N°: 0004-00000616',NULL,'2022-10-11 00:57:33','2022-10-11 00:57:33',NULL),(617,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',200.00,1,1.00,'Factura C N°: 0004-00000617',NULL,'2022-10-11 00:57:36','2022-10-11 00:57:36',NULL),(618,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',660.00,1,1.00,'Factura C N°: 0004-00000618',NULL,'2022-10-11 00:57:39','2022-10-11 00:57:39',NULL),(619,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',350.00,1,1.00,'Factura C N°: 0004-00000619',NULL,'2022-10-11 00:57:42','2022-10-11 00:57:42',NULL),(620,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',80.00,1,1.00,'Factura C N°: 0004-00000620',NULL,'2022-10-11 00:57:45','2022-10-11 00:57:45',NULL),(621,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',420.00,1,1.00,'Factura C N°: 0004-00000621',NULL,'2022-10-11 00:57:47','2022-10-11 00:57:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (622,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',560.00,1,1.00,'Factura C N°: 0004-00000622',NULL,'2022-10-11 00:57:50','2022-10-11 00:57:50',NULL),(623,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',390.00,1,1.00,'Factura C N°: 0004-00000623',NULL,'2022-10-11 00:57:53','2022-10-11 00:57:53',NULL),(624,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',500.00,1,1.00,'Factura C N°: 0004-00000624',NULL,'2022-10-11 00:57:55','2022-10-11 00:57:55',NULL),(625,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',200.00,1,1.00,'Factura C N°: 0004-00000625',NULL,'2022-10-11 00:57:58','2022-10-11 00:57:58',NULL),(626,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',280.00,1,1.00,'Factura C N°: 0004-00000626',NULL,'2022-10-11 00:58:00','2022-10-11 00:58:00',NULL),(627,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',490.00,1,1.00,'Factura C N°: 0004-00000627',NULL,'2022-10-11 00:58:03','2022-10-11 00:58:03',NULL),(628,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000628',NULL,'2022-10-11 00:58:06','2022-10-11 00:58:06',NULL),(629,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',440.00,1,1.00,'Factura C N°: 0004-00000629',NULL,'2022-10-11 00:58:09','2022-10-11 00:58:09',NULL),(630,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',480.00,1,1.00,'Factura C N°: 0004-00000630',NULL,'2022-10-11 00:58:12','2022-10-11 00:58:12',NULL),(631,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',860.00,1,1.00,'Factura C N°: 0004-00000631',NULL,'2022-10-11 00:58:14','2022-10-11 00:58:14',NULL),(632,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',90.00,1,1.00,'Factura C N°: 0004-00000632',NULL,'2022-10-11 00:58:17','2022-10-11 00:58:17',NULL),(633,NULL,2,40720,40718,13,1584,1,0,'2022-10-11',220.00,1,1.00,'Factura C N°: 0004-00000633',NULL,'2022-10-11 00:58:20','2022-10-11 00:58:20',NULL),(634,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',630.00,1,1.00,'Factura C N°: 0004-00000634',NULL,'2022-10-22 11:27:25','2022-10-22 11:27:25',NULL),(635,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000635',NULL,'2022-10-22 11:27:28','2022-10-22 11:27:28',NULL),(636,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000636',NULL,'2022-10-22 11:27:30','2022-10-22 11:27:30',NULL),(637,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000637',NULL,'2022-10-22 11:27:32','2022-10-22 11:27:32',NULL),(638,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000638',NULL,'2022-10-22 11:27:35','2022-10-22 11:27:35',NULL),(639,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000639',NULL,'2022-10-22 11:27:37','2022-10-22 11:27:37',NULL),(640,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',760.00,1,1.00,'Factura C N°: 0004-00000640',NULL,'2022-10-22 11:27:40','2022-10-22 11:27:40',NULL),(641,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',570.00,1,1.00,'Factura C N°: 0004-00000641',NULL,'2022-10-22 11:27:43','2022-10-22 11:27:43',NULL),(642,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',620.00,1,1.00,'Factura C N°: 0004-00000642',NULL,'2022-10-22 11:27:45','2022-10-22 11:27:45',NULL),(643,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',390.00,1,1.00,'Factura C N°: 0004-00000643',NULL,'2022-10-22 11:27:48','2022-10-22 11:27:48',NULL),(644,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',50.00,1,1.00,'Factura C N°: 0004-00000644',NULL,'2022-10-22 11:27:50','2022-10-22 11:27:50',NULL),(645,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000645',NULL,'2022-10-22 11:27:53','2022-10-22 11:27:53',NULL),(646,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000646',NULL,'2022-10-22 11:27:55','2022-10-22 11:27:55',NULL),(647,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',620.00,1,1.00,'Factura C N°: 0004-00000647',NULL,'2022-10-22 11:27:58','2022-10-22 11:27:58',NULL),(648,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000648',NULL,'2022-10-22 11:28:00','2022-10-22 11:28:00',NULL);
INSERT INTO `cta_cte_cliente` VALUES (649,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',280.00,1,1.00,'Factura C N°: 0004-00000649',NULL,'2022-10-22 11:28:03','2022-10-22 11:28:03',NULL),(650,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',280.00,1,1.00,'Factura C N°: 0004-00000650',NULL,'2022-10-22 11:28:06','2022-10-22 11:28:06',NULL),(651,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000651',NULL,'2022-10-22 11:28:08','2022-10-22 11:28:08',NULL),(652,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',840.00,1,1.00,'Factura C N°: 0004-00000652',NULL,'2022-10-22 11:28:12','2022-10-22 11:28:12',NULL),(653,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000653',NULL,'2022-10-22 11:28:15','2022-10-22 11:28:15',NULL),(654,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',770.00,1,1.00,'Factura C N°: 0004-00000654',NULL,'2022-10-22 11:28:17','2022-10-22 11:28:17',NULL),(655,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',180.00,1,1.00,'Factura C N°: 0004-00000655',NULL,'2022-10-22 11:28:20','2022-10-22 11:28:20',NULL),(656,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000656',NULL,'2022-10-22 11:28:22','2022-10-22 11:28:22',NULL),(657,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',620.00,1,1.00,'Factura C N°: 0004-00000657',NULL,'2022-10-22 11:28:25','2022-10-22 11:28:25',NULL),(658,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',500.00,1,1.00,'Factura C N°: 0004-00000658',NULL,'2022-10-22 11:28:27','2022-10-22 11:28:27',NULL),(659,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',740.00,1,1.00,'Factura C N°: 0004-00000659',NULL,'2022-10-22 11:28:30','2022-10-22 11:28:30',NULL),(660,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',660.00,1,1.00,'Factura C N°: 0004-00000660',NULL,'2022-10-22 11:28:33','2022-10-22 11:28:33',NULL),(661,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',650.00,1,1.00,'Factura C N°: 0004-00000661',NULL,'2022-10-22 11:28:36','2022-10-22 11:28:36',NULL),(662,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',300.00,1,1.00,'Factura C N°: 0004-00000662',NULL,'2022-10-22 11:28:39','2022-10-22 11:28:39',NULL),(663,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',340.00,1,1.00,'Factura C N°: 0004-00000663',NULL,'2022-10-22 11:28:41','2022-10-22 11:28:41',NULL),(664,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',290.00,1,1.00,'Factura C N°: 0004-00000664',NULL,'2022-10-22 11:28:44','2022-10-22 11:28:44',NULL),(665,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',180.00,1,1.00,'Factura C N°: 0004-00000665',NULL,'2022-10-22 11:28:46','2022-10-22 11:28:46',NULL),(666,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',300.00,1,1.00,'Factura C N°: 0004-00000666',NULL,'2022-10-22 11:28:49','2022-10-22 11:28:49',NULL),(667,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',470.00,1,1.00,'Factura C N°: 0004-00000667',NULL,'2022-10-22 11:28:52','2022-10-22 11:28:52',NULL),(668,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000668',NULL,'2022-10-22 11:28:55','2022-10-22 11:28:55',NULL),(669,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000669',NULL,'2022-10-22 11:28:58','2022-10-22 11:28:58',NULL),(670,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',450.00,1,1.00,'Factura C N°: 0004-00000670',NULL,'2022-10-22 11:29:00','2022-10-22 11:29:00',NULL),(671,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',130.00,1,1.00,'Factura C N°: 0004-00000671',NULL,'2022-10-22 11:29:03','2022-10-22 11:29:03',NULL),(672,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',180.00,1,1.00,'Factura C N°: 0004-00000672',NULL,'2022-10-22 11:29:06','2022-10-22 11:29:06',NULL),(673,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',470.00,1,1.00,'Factura C N°: 0004-00000673',NULL,'2022-10-22 11:29:09','2022-10-22 11:29:09',NULL),(674,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',300.00,1,1.00,'Factura C N°: 0004-00000674',NULL,'2022-10-22 11:29:11','2022-10-22 11:29:11',NULL),(675,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1020.00,1,1.00,'Factura C N°: 0004-00000675',NULL,'2022-10-22 11:29:14','2022-10-22 11:29:14',NULL);
INSERT INTO `cta_cte_cliente` VALUES (676,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',400.00,1,1.00,'Factura C N°: 0004-00000676',NULL,'2022-10-22 11:29:17','2022-10-22 11:29:17',NULL),(677,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000677',NULL,'2022-10-22 11:29:19','2022-10-22 11:29:19',NULL),(678,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',340.00,1,1.00,'Factura C N°: 0004-00000678',NULL,'2022-10-22 11:29:22','2022-10-22 11:29:22',NULL),(679,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000679',NULL,'2022-10-22 11:29:24','2022-10-22 11:29:24',NULL),(680,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',380.00,1,1.00,'Factura C N°: 0004-00000680',NULL,'2022-10-22 11:29:27','2022-10-22 11:29:27',NULL),(681,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',380.00,1,1.00,'Factura C N°: 0004-00000681',NULL,'2022-10-22 11:29:30','2022-10-22 11:29:30',NULL),(682,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000682',NULL,'2022-10-22 11:29:32','2022-10-22 11:29:32',NULL),(683,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000683',NULL,'2022-10-22 11:29:35','2022-10-22 11:29:35',NULL),(684,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',380.00,1,1.00,'Factura C N°: 0004-00000684',NULL,'2022-10-22 11:29:38','2022-10-22 11:29:38',NULL),(685,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000685',NULL,'2022-10-22 11:29:41','2022-10-22 11:29:41',NULL),(686,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',40.00,1,1.00,'Factura C N°: 0004-00000686',NULL,'2022-10-22 11:29:44','2022-10-22 11:29:44',NULL),(687,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',20.00,1,1.00,'Factura C N°: 0004-00000687',NULL,'2022-10-22 11:29:46','2022-10-22 11:29:46',NULL),(688,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000688',NULL,'2022-10-22 11:29:49','2022-10-22 11:29:49',NULL),(689,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',890.00,1,1.00,'Factura C N°: 0004-00000689',NULL,'2022-10-22 11:29:52','2022-10-22 11:29:52',NULL),(690,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',130.00,1,1.00,'Factura C N°: 0004-00000690',NULL,'2022-10-22 11:29:54','2022-10-22 11:29:54',NULL),(691,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000691',NULL,'2022-10-22 11:29:57','2022-10-22 11:29:57',NULL),(692,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',420.00,1,1.00,'Factura C N°: 0004-00000692',NULL,'2022-10-22 11:30:00','2022-10-22 11:30:00',NULL),(693,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',180.00,1,1.00,'Factura C N°: 0004-00000693',NULL,'2022-10-22 11:30:03','2022-10-22 11:30:03',NULL),(694,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000694',NULL,'2022-10-22 11:30:06','2022-10-22 11:30:06',NULL),(695,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',500.00,1,1.00,'Factura C N°: 0004-00000695',NULL,'2022-10-22 11:30:09','2022-10-22 11:30:09',NULL),(696,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',420.00,1,1.00,'Factura C N°: 0004-00000696',NULL,'2022-10-22 11:30:11','2022-10-22 11:30:11',NULL),(697,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000697',NULL,'2022-10-22 11:30:14','2022-10-22 11:30:14',NULL),(698,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',470.00,1,1.00,'Factura C N°: 0004-00000698',NULL,'2022-10-22 11:30:16','2022-10-22 11:30:16',NULL),(699,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',520.00,1,1.00,'Factura C N°: 0004-00000699',NULL,'2022-10-22 11:30:19','2022-10-22 11:30:19',NULL),(700,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',720.00,1,1.00,'Factura C N°: 0004-00000700',NULL,'2022-10-22 11:30:22','2022-10-22 11:30:22',NULL),(701,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',400.00,1,1.00,'Factura C N°: 0004-00000701',NULL,'2022-10-22 11:30:24','2022-10-22 11:30:24',NULL),(702,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000702',NULL,'2022-10-22 11:30:27','2022-10-22 11:30:27',NULL);
INSERT INTO `cta_cte_cliente` VALUES (703,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',860.00,1,1.00,'Factura C N°: 0004-00000703',NULL,'2022-10-22 11:30:30','2022-10-22 11:30:30',NULL),(704,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000704',NULL,'2022-10-22 11:30:33','2022-10-22 11:30:33',NULL),(705,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',780.00,1,1.00,'Factura C N°: 0004-00000705',NULL,'2022-10-22 11:30:35','2022-10-22 11:30:35',NULL),(706,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',560.00,1,1.00,'Factura C N°: 0004-00000706',NULL,'2022-10-22 11:30:38','2022-10-22 11:30:38',NULL),(707,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',300.00,1,1.00,'Factura C N°: 0004-00000707',NULL,'2022-10-22 11:30:41','2022-10-22 11:30:41',NULL),(708,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000708',NULL,'2022-10-22 11:30:44','2022-10-22 11:30:44',NULL),(709,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',320.00,1,1.00,'Factura C N°: 0004-00000709',NULL,'2022-10-22 11:30:46','2022-10-22 11:30:46',NULL),(710,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',570.00,1,1.00,'Factura C N°: 0004-00000710',NULL,'2022-10-22 11:30:49','2022-10-22 11:30:49',NULL),(711,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',190.00,1,1.00,'Factura C N°: 0004-00000711',NULL,'2022-10-22 11:30:52','2022-10-22 11:30:52',NULL),(712,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',190.00,1,1.00,'Factura C N°: 0004-00000712',NULL,'2022-10-22 11:30:55','2022-10-22 11:30:55',NULL),(713,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000713',NULL,'2022-10-22 11:30:57','2022-10-22 11:30:57',NULL),(714,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000714',NULL,'2022-10-22 11:31:00','2022-10-22 11:31:00',NULL),(715,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',710.00,1,1.00,'Factura C N°: 0004-00000715',NULL,'2022-10-22 11:31:03','2022-10-22 11:31:03',NULL),(716,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',680.00,1,1.00,'Factura C N°: 0004-00000716',NULL,'2022-10-22 11:31:06','2022-10-22 11:31:06',NULL),(717,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000717',NULL,'2022-10-22 11:31:08','2022-10-22 11:31:08',NULL),(718,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',440.00,1,1.00,'Factura C N°: 0004-00000718',NULL,'2022-10-22 11:31:11','2022-10-22 11:31:11',NULL),(719,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000719',NULL,'2022-10-22 11:31:14','2022-10-22 11:31:14',NULL),(720,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000720',NULL,'2022-10-22 11:31:17','2022-10-22 11:31:17',NULL),(721,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',350.00,1,1.00,'Factura C N°: 0004-00000721',NULL,'2022-10-22 11:31:20','2022-10-22 11:31:20',NULL),(722,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000722',NULL,'2022-10-22 11:31:22','2022-10-22 11:31:22',NULL),(723,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',290.00,1,1.00,'Factura C N°: 0004-00000723',NULL,'2022-10-22 11:31:25','2022-10-22 11:31:25',NULL),(724,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',400.00,1,1.00,'Factura C N°: 0004-00000724',NULL,'2022-10-22 11:31:28','2022-10-22 11:31:28',NULL),(725,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',100.00,1,1.00,'Factura C N°: 0004-00000725',NULL,'2022-10-22 11:31:30','2022-10-22 11:31:30',NULL),(726,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',150.00,1,1.00,'Factura C N°: 0004-00000726',NULL,'2022-10-22 11:31:33','2022-10-22 11:31:33',NULL),(727,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',350.00,1,1.00,'Factura C N°: 0004-00000727',NULL,'2022-10-22 11:31:36','2022-10-22 11:31:36',NULL),(728,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',230.00,1,1.00,'Factura C N°: 0004-00000728',NULL,'2022-10-22 11:31:39','2022-10-22 11:31:39',NULL),(729,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',690.00,1,1.00,'Factura C N°: 0004-00000729',NULL,'2022-10-22 11:31:42','2022-10-22 11:31:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (730,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000730',NULL,'2022-10-22 11:31:44','2022-10-22 11:31:44',NULL),(731,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',310.00,1,1.00,'Factura C N°: 0004-00000731',NULL,'2022-10-22 11:31:47','2022-10-22 11:31:47',NULL),(732,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000732',NULL,'2022-10-22 11:31:50','2022-10-22 11:31:50',NULL),(733,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000733',NULL,'2022-10-22 11:31:53','2022-10-22 11:31:53',NULL),(734,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',2720.00,1,1.00,'Factura C N°: 0004-00000734',NULL,'2022-10-22 11:31:55','2022-10-22 11:31:55',NULL),(735,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',550.00,1,1.00,'Factura C N°: 0004-00000735',NULL,'2022-10-22 11:31:59','2022-10-22 11:31:59',NULL),(736,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000736',NULL,'2022-10-22 11:32:01','2022-10-22 11:32:01',NULL),(737,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',550.00,1,1.00,'Factura C N°: 0004-00000737',NULL,'2022-10-22 11:32:04','2022-10-22 11:32:04',NULL),(738,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',440.00,1,1.00,'Factura C N°: 0004-00000738',NULL,'2022-10-22 11:32:07','2022-10-22 11:32:07',NULL),(739,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000739',NULL,'2022-10-22 11:32:10','2022-10-22 11:32:10',NULL),(740,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000740',NULL,'2022-10-22 11:32:12','2022-10-22 11:32:12',NULL),(741,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',560.00,1,1.00,'Factura C N°: 0004-00000741',NULL,'2022-10-22 11:32:15','2022-10-22 11:32:15',NULL),(742,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000742',NULL,'2022-10-22 11:32:18','2022-10-22 11:32:18',NULL),(743,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000743',NULL,'2022-10-22 11:32:21','2022-10-22 11:32:21',NULL),(744,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',290.00,1,1.00,'Factura C N°: 0004-00000744',NULL,'2022-10-22 11:32:23','2022-10-22 11:32:23',NULL),(745,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',740.00,1,1.00,'Factura C N°: 0004-00000745',NULL,'2022-10-22 11:32:26','2022-10-22 11:32:26',NULL),(746,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000746',NULL,'2022-10-22 11:32:29','2022-10-22 11:32:29',NULL),(747,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',570.00,1,1.00,'Factura C N°: 0004-00000747',NULL,'2022-10-22 11:32:31','2022-10-22 11:32:31',NULL),(748,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',670.00,1,1.00,'Factura C N°: 0004-00000748',NULL,'2022-10-22 11:32:34','2022-10-22 11:32:34',NULL),(749,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',470.00,1,1.00,'Factura C N°: 0004-00000749',NULL,'2022-10-22 11:32:37','2022-10-22 11:32:37',NULL),(750,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',720.00,1,1.00,'Factura C N°: 0004-00000750',NULL,'2022-10-22 11:32:40','2022-10-22 11:32:40',NULL),(751,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',450.00,1,1.00,'Factura C N°: 0004-00000751',NULL,'2022-10-22 11:32:43','2022-10-22 11:32:43',NULL),(752,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',250.00,1,1.00,'Factura C N°: 0004-00000752',NULL,'2022-10-22 11:32:46','2022-10-22 11:32:46',NULL),(753,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',990.00,1,1.00,'Factura C N°: 0004-00000753',NULL,'2022-10-22 11:32:48','2022-10-22 11:32:48',NULL),(754,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1040.00,1,1.00,'Factura C N°: 0004-00000754',NULL,'2022-10-22 11:32:51','2022-10-22 11:32:51',NULL),(755,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000755',NULL,'2022-10-22 11:32:54','2022-10-22 11:32:54',NULL),(756,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000756',NULL,'2022-10-22 11:32:57','2022-10-22 11:32:57',NULL);
INSERT INTO `cta_cte_cliente` VALUES (757,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',320.00,1,1.00,'Factura C N°: 0004-00000757',NULL,'2022-10-22 11:32:59','2022-10-22 11:32:59',NULL),(758,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000758',NULL,'2022-10-22 11:33:03','2022-10-22 11:33:03',NULL),(759,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1160.00,1,1.00,'Factura C N°: 0004-00000759',NULL,'2022-10-22 11:33:06','2022-10-22 11:33:06',NULL),(760,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',310.00,1,1.00,'Factura C N°: 0004-00000760',NULL,'2022-10-22 11:33:09','2022-10-22 11:33:09',NULL),(761,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',670.00,1,1.00,'Factura C N°: 0004-00000761',NULL,'2022-10-22 11:33:12','2022-10-22 11:33:12',NULL),(762,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',90.00,1,1.00,'Factura C N°: 0004-00000762',NULL,'2022-10-22 11:33:14','2022-10-22 11:33:14',NULL),(763,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000763',NULL,'2022-10-22 11:33:17','2022-10-22 11:33:17',NULL),(764,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',400.00,1,1.00,'Factura C N°: 0004-00000764',NULL,'2022-10-22 11:33:20','2022-10-22 11:33:20',NULL),(765,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',620.00,1,1.00,'Factura C N°: 0004-00000765',NULL,'2022-10-22 11:33:23','2022-10-22 11:33:23',NULL),(766,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',530.00,1,1.00,'Factura C N°: 0004-00000766',NULL,'2022-10-22 11:33:26','2022-10-22 11:33:26',NULL),(767,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',640.00,1,1.00,'Factura C N°: 0004-00000767',NULL,'2022-10-22 11:33:28','2022-10-22 11:33:28',NULL),(768,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000768',NULL,'2022-10-22 11:33:31','2022-10-22 11:33:31',NULL),(769,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000769',NULL,'2022-10-22 11:33:34','2022-10-22 11:33:34',NULL),(770,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',230.00,1,1.00,'Factura C N°: 0004-00000770',NULL,'2022-10-22 11:33:37','2022-10-22 11:33:37',NULL),(771,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000771',NULL,'2022-10-22 11:33:40','2022-10-22 11:33:40',NULL),(772,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',490.00,1,1.00,'Factura C N°: 0004-00000772',NULL,'2022-10-22 11:33:43','2022-10-22 11:33:43',NULL),(773,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000773',NULL,'2022-10-22 11:33:45','2022-10-22 11:33:45',NULL),(774,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',190.00,1,1.00,'Factura C N°: 0004-00000774',NULL,'2022-10-22 11:33:48','2022-10-22 11:33:48',NULL),(775,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',150.00,1,1.00,'Factura C N°: 0004-00000775',NULL,'2022-10-22 11:33:51','2022-10-22 11:33:51',NULL),(776,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',180.00,1,1.00,'Factura C N°: 0004-00000776',NULL,'2022-10-22 11:33:54','2022-10-22 11:33:54',NULL),(777,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',350.00,1,1.00,'Factura C N°: 0004-00000777',NULL,'2022-10-22 11:33:57','2022-10-22 11:33:57',NULL),(778,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',20.00,1,1.00,'Factura C N°: 0004-00000778',NULL,'2022-10-22 11:34:00','2022-10-22 11:34:00',NULL),(779,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000779',NULL,'2022-10-22 11:34:03','2022-10-22 11:34:03',NULL),(780,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',190.00,1,1.00,'Factura C N°: 0004-00000780',NULL,'2022-10-22 11:34:06','2022-10-22 11:34:06',NULL),(781,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',770.00,1,1.00,'Factura C N°: 0004-00000781',NULL,'2022-10-22 11:34:09','2022-10-22 11:34:09',NULL),(782,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000782',NULL,'2022-10-22 11:34:11','2022-10-22 11:34:11',NULL),(783,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',420.00,1,1.00,'Factura C N°: 0004-00000783',NULL,'2022-10-22 11:34:14','2022-10-22 11:34:14',NULL);
INSERT INTO `cta_cte_cliente` VALUES (784,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',220.00,1,1.00,'Factura C N°: 0004-00000784',NULL,'2022-10-22 11:34:17','2022-10-22 11:34:17',NULL),(785,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',650.00,1,1.00,'Factura C N°: 0004-00000785',NULL,'2022-10-22 11:34:20','2022-10-22 11:34:20',NULL),(786,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000786',NULL,'2022-10-22 11:34:23','2022-10-22 11:34:23',NULL),(787,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000787',NULL,'2022-10-22 11:34:26','2022-10-22 11:34:26',NULL),(788,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000788',NULL,'2022-10-22 11:34:29','2022-10-22 11:34:29',NULL),(789,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',290.00,1,1.00,'Factura C N°: 0004-00000789',NULL,'2022-10-22 11:34:32','2022-10-22 11:34:32',NULL),(790,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',610.00,1,1.00,'Factura C N°: 0004-00000790',NULL,'2022-10-22 11:34:35','2022-10-22 11:34:35',NULL),(791,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000791',NULL,'2022-10-22 11:34:38','2022-10-22 11:34:38',NULL),(792,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',350.00,1,1.00,'Factura C N°: 0004-00000792',NULL,'2022-10-22 11:34:40','2022-10-22 11:34:40',NULL),(793,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',510.00,1,1.00,'Factura C N°: 0004-00000793',NULL,'2022-10-22 11:34:43','2022-10-22 11:34:43',NULL),(794,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000794',NULL,'2022-10-22 11:34:46','2022-10-22 11:34:46',NULL),(795,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',520.00,1,1.00,'Factura C N°: 0004-00000795',NULL,'2022-10-22 11:34:49','2022-10-22 11:34:49',NULL),(796,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000796',NULL,'2022-10-22 11:34:52','2022-10-22 11:34:52',NULL),(797,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000797',NULL,'2022-10-22 11:34:54','2022-10-22 11:34:54',NULL),(798,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1500.00,1,1.00,'Factura C N°: 0004-00000798',NULL,'2022-10-22 11:34:57','2022-10-22 11:34:57',NULL),(799,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',220.00,1,1.00,'Factura C N°: 0004-00000799',NULL,'2022-10-22 11:35:00','2022-10-22 11:35:00',NULL),(800,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000800',NULL,'2022-10-22 11:35:03','2022-10-22 11:35:03',NULL),(801,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',710.00,1,1.00,'Factura C N°: 0004-00000801',NULL,'2022-10-22 11:35:06','2022-10-22 11:35:06',NULL),(802,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000802',NULL,'2022-10-22 11:35:09','2022-10-22 11:35:09',NULL),(803,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',700.00,1,1.00,'Factura C N°: 0004-00000803',NULL,'2022-10-22 11:35:12','2022-10-22 11:35:12',NULL),(804,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1720.00,1,1.00,'Factura C N°: 0004-00000804',NULL,'2022-10-22 11:35:15','2022-10-22 11:35:15',NULL),(805,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',760.00,1,1.00,'Factura C N°: 0004-00000805',NULL,'2022-10-22 11:35:18','2022-10-22 11:35:18',NULL),(806,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',290.00,1,1.00,'Factura C N°: 0004-00000806',NULL,'2022-10-22 11:35:21','2022-10-22 11:35:21',NULL),(807,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000807',NULL,'2022-10-22 11:35:24','2022-10-22 11:35:24',NULL),(808,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',390.00,1,1.00,'Factura C N°: 0004-00000808',NULL,'2022-10-22 11:35:26','2022-10-22 11:35:26',NULL),(809,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',650.00,1,1.00,'Factura C N°: 0004-00000809',NULL,'2022-10-22 11:35:29','2022-10-22 11:35:29',NULL),(810,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',290.00,1,1.00,'Factura C N°: 0004-00000810',NULL,'2022-10-22 11:35:32','2022-10-22 11:35:32',NULL);
INSERT INTO `cta_cte_cliente` VALUES (811,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1180.00,1,1.00,'Factura C N°: 0004-00000811',NULL,'2022-10-22 11:35:35','2022-10-22 11:35:35',NULL),(812,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',440.00,1,1.00,'Factura C N°: 0004-00000812',NULL,'2022-10-22 11:35:38','2022-10-22 11:35:38',NULL),(813,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1230.00,1,1.00,'Factura C N°: 0004-00000813',NULL,'2022-10-22 11:35:41','2022-10-22 11:35:41',NULL),(814,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',100.00,1,1.00,'Factura C N°: 0004-00000814',NULL,'2022-10-22 11:35:44','2022-10-22 11:35:44',NULL),(815,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',500.00,1,1.00,'Factura C N°: 0004-00000815',NULL,'2022-10-22 11:35:47','2022-10-22 11:35:47',NULL),(816,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',470.00,1,1.00,'Factura C N°: 0004-00000816',NULL,'2022-10-22 11:35:50','2022-10-22 11:35:50',NULL),(817,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',190.00,1,1.00,'Factura C N°: 0004-00000817',NULL,'2022-10-22 11:35:53','2022-10-22 11:35:53',NULL),(818,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',310.00,1,1.00,'Factura C N°: 0004-00000818',NULL,'2022-10-22 11:35:56','2022-10-22 11:35:56',NULL),(819,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',520.00,1,1.00,'Factura C N°: 0004-00000819',NULL,'2022-10-22 11:35:59','2022-10-22 11:35:59',NULL),(820,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',850.00,1,1.00,'Factura C N°: 0004-00000820',NULL,'2022-10-22 11:36:02','2022-10-22 11:36:02',NULL),(821,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000821',NULL,'2022-10-22 11:36:05','2022-10-22 11:36:05',NULL),(822,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1030.00,1,1.00,'Factura C N°: 0004-00000822',NULL,'2022-10-22 11:36:08','2022-10-22 11:36:08',NULL),(823,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',490.00,1,1.00,'Factura C N°: 0004-00000823',NULL,'2022-10-22 11:36:11','2022-10-22 11:36:11',NULL),(824,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1440.00,1,1.00,'Factura C N°: 0004-00000824',NULL,'2022-10-22 11:36:14','2022-10-22 11:36:14',NULL),(825,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',2170.00,1,1.00,'Factura C N°: 0004-00000825',NULL,'2022-10-22 11:36:17','2022-10-22 11:36:17',NULL),(826,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',720.00,1,1.00,'Factura C N°: 0004-00000826',NULL,'2022-10-22 11:36:20','2022-10-22 11:36:20',NULL),(827,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1170.00,1,1.00,'Factura C N°: 0004-00000827',NULL,'2022-10-22 11:36:23','2022-10-22 11:36:23',NULL),(828,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',290.00,1,1.00,'Factura C N°: 0004-00000828',NULL,'2022-10-22 11:36:26','2022-10-22 11:36:26',NULL),(829,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000829',NULL,'2022-10-22 11:36:29','2022-10-22 11:36:29',NULL),(830,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000830',NULL,'2022-10-22 11:36:32','2022-10-22 11:36:32',NULL),(831,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',270.00,1,1.00,'Factura C N°: 0004-00000831',NULL,'2022-10-22 11:36:35','2022-10-22 11:36:35',NULL),(832,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',130.00,1,1.00,'Factura C N°: 0004-00000832',NULL,'2022-10-22 11:36:38','2022-10-22 11:36:38',NULL),(833,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',860.00,1,1.00,'Factura C N°: 0004-00000833',NULL,'2022-10-22 11:36:41','2022-10-22 11:36:41',NULL),(834,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',570.00,1,1.00,'Factura C N°: 0004-00000834',NULL,'2022-10-22 11:36:44','2022-10-22 11:36:44',NULL),(835,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000835',NULL,'2022-10-22 11:36:47','2022-10-22 11:36:47',NULL),(836,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000836',NULL,'2022-10-22 11:36:50','2022-10-22 11:36:50',NULL);
INSERT INTO `cta_cte_cliente` VALUES (837,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000837',NULL,'2022-10-22 11:36:53','2022-10-22 11:36:53',NULL),(838,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',540.00,1,1.00,'Factura C N°: 0004-00000838',NULL,'2022-10-22 11:36:56','2022-10-22 11:36:56',NULL),(839,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',300.00,1,1.00,'Factura C N°: 0004-00000839',NULL,'2022-10-22 11:36:59','2022-10-22 11:36:59',NULL),(840,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',100.00,1,1.00,'Factura C N°: 0004-00000840',NULL,'2022-10-22 11:37:02','2022-10-22 11:37:02',NULL),(841,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',380.00,1,1.00,'Factura C N°: 0004-00000841',NULL,'2022-10-22 11:37:05','2022-10-22 11:37:05',NULL),(842,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000842',NULL,'2022-10-22 11:37:08','2022-10-22 11:37:08',NULL),(843,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',160.00,1,1.00,'Factura C N°: 0004-00000843',NULL,'2022-10-22 11:37:11','2022-10-22 11:37:11',NULL),(844,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',650.00,1,1.00,'Factura C N°: 0004-00000844',NULL,'2022-10-22 11:37:14','2022-10-22 11:37:14',NULL),(845,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',180.00,1,1.00,'Factura C N°: 0004-00000845',NULL,'2022-10-22 11:37:17','2022-10-22 11:37:17',NULL),(846,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000846',NULL,'2022-10-22 11:37:20','2022-10-22 11:37:20',NULL),(847,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1560.00,1,1.00,'Factura C N°: 0004-00000847',NULL,'2022-10-22 11:37:23','2022-10-22 11:37:23',NULL),(848,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',380.00,1,1.00,'Factura C N°: 0004-00000848',NULL,'2022-10-22 11:37:26','2022-10-22 11:37:26',NULL),(849,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000849',NULL,'2022-10-22 11:37:29','2022-10-22 11:37:29',NULL),(850,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',300.00,1,1.00,'Factura C N°: 0004-00000850',NULL,'2022-10-22 11:37:32','2022-10-22 11:37:32',NULL),(851,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',290.00,1,1.00,'Factura C N°: 0004-00000851',NULL,'2022-10-22 11:37:35','2022-10-22 11:37:35',NULL),(852,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',50.00,1,1.00,'Factura C N°: 0004-00000852',NULL,'2022-10-22 11:37:38','2022-10-22 11:37:38',NULL),(853,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',220.00,1,1.00,'Factura C N°: 0004-00000853',NULL,'2022-10-22 11:37:41','2022-10-22 11:37:41',NULL),(854,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000854',NULL,'2022-10-22 11:37:44','2022-10-22 11:37:44',NULL),(855,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',100.00,1,1.00,'Factura C N°: 0004-00000855',NULL,'2022-10-22 11:37:47','2022-10-22 11:37:47',NULL),(856,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000856',NULL,'2022-10-22 11:37:50','2022-10-22 11:37:50',NULL),(857,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000857',NULL,'2022-10-22 11:37:53','2022-10-22 11:37:53',NULL),(858,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000858',NULL,'2022-10-22 11:37:56','2022-10-22 11:37:56',NULL),(859,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000859',NULL,'2022-10-22 11:37:59','2022-10-22 11:37:59',NULL),(860,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000860',NULL,'2022-10-22 11:38:02','2022-10-22 11:38:02',NULL),(861,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',190.00,1,1.00,'Factura C N°: 0004-00000861',NULL,'2022-10-22 11:38:05','2022-10-22 11:38:05',NULL),(862,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000862',NULL,'2022-10-22 11:38:08','2022-10-22 11:38:08',NULL),(863,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000863',NULL,'2022-10-22 11:38:11','2022-10-22 11:38:11',NULL);
INSERT INTO `cta_cte_cliente` VALUES (864,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000864',NULL,'2022-10-22 11:38:14','2022-10-22 11:38:14',NULL),(865,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000865',NULL,'2022-10-22 11:38:17','2022-10-22 11:38:17',NULL),(866,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000866',NULL,'2022-10-22 11:38:20','2022-10-22 11:38:20',NULL),(867,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000867',NULL,'2022-10-22 11:38:23','2022-10-22 11:38:23',NULL),(868,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',220.00,1,1.00,'Factura C N°: 0004-00000868',NULL,'2022-10-22 11:38:26','2022-10-22 11:38:26',NULL),(869,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',100.00,1,1.00,'Factura C N°: 0004-00000869',NULL,'2022-10-22 11:38:29','2022-10-22 11:38:29',NULL),(870,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000870',NULL,'2022-10-22 11:38:32','2022-10-22 11:38:32',NULL),(871,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000871',NULL,'2022-10-22 11:38:35','2022-10-22 11:38:35',NULL),(872,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',460.00,1,1.00,'Factura C N°: 0004-00000872',NULL,'2022-10-22 11:38:38','2022-10-22 11:38:38',NULL),(873,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',320.00,1,1.00,'Factura C N°: 0004-00000873',NULL,'2022-10-22 11:38:41','2022-10-22 11:38:41',NULL),(874,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',230.00,1,1.00,'Factura C N°: 0004-00000874',NULL,'2022-10-22 11:38:44','2022-10-22 11:38:44',NULL),(875,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000875',NULL,'2022-10-22 11:38:47','2022-10-22 11:38:47',NULL),(876,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000876',NULL,'2022-10-22 11:38:50','2022-10-22 11:38:50',NULL),(877,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',850.00,1,1.00,'Factura C N°: 0004-00000877',NULL,'2022-10-22 11:38:53','2022-10-22 11:38:53',NULL),(878,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000878',NULL,'2022-10-22 11:38:56','2022-10-22 11:38:56',NULL),(879,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000879',NULL,'2022-10-22 11:38:59','2022-10-22 11:38:59',NULL),(880,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',300.00,1,1.00,'Factura C N°: 0004-00000880',NULL,'2022-10-22 11:39:02','2022-10-22 11:39:02',NULL),(881,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',220.00,1,1.00,'Factura C N°: 0004-00000881',NULL,'2022-10-22 11:39:06','2022-10-22 11:39:06',NULL),(882,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000882',NULL,'2022-10-22 11:39:09','2022-10-22 11:39:09',NULL),(883,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',450.00,1,1.00,'Factura C N°: 0004-00000883',NULL,'2022-10-22 11:39:12','2022-10-22 11:39:12',NULL),(884,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000884',NULL,'2022-10-22 11:39:15','2022-10-22 11:39:15',NULL),(885,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',110.00,1,1.00,'Factura C N°: 0004-00000885',NULL,'2022-10-22 11:39:18','2022-10-22 11:39:18',NULL),(886,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',340.00,1,1.00,'Factura C N°: 0004-00000886',NULL,'2022-10-22 11:39:21','2022-10-22 11:39:21',NULL),(887,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',220.00,1,1.00,'Factura C N°: 0004-00000887',NULL,'2022-10-22 11:39:25','2022-10-22 11:39:25',NULL),(888,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',520.00,1,1.00,'Factura C N°: 0004-00000888',NULL,'2022-10-22 11:39:28','2022-10-22 11:39:28',NULL),(889,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000889',NULL,'2022-10-22 11:39:31','2022-10-22 11:39:31',NULL),(890,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',780.00,1,1.00,'Factura C N°: 0004-00000890',NULL,'2022-10-22 11:39:34','2022-10-22 11:39:34',NULL);
INSERT INTO `cta_cte_cliente` VALUES (891,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000891',NULL,'2022-10-22 11:39:37','2022-10-22 11:39:37',NULL),(892,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',400.00,1,1.00,'Factura C N°: 0004-00000892',NULL,'2022-10-22 11:39:40','2022-10-22 11:39:40',NULL),(893,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',230.00,1,1.00,'Factura C N°: 0004-00000893',NULL,'2022-10-22 11:39:43','2022-10-22 11:39:43',NULL),(894,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',340.00,1,1.00,'Factura C N°: 0004-00000894',NULL,'2022-10-22 11:39:47','2022-10-22 11:39:47',NULL),(895,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',500.00,1,1.00,'Factura C N°: 0004-00000895',NULL,'2022-10-22 11:39:50','2022-10-22 11:39:50',NULL),(896,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',970.00,1,1.00,'Factura C N°: 0004-00000896',NULL,'2022-10-22 11:39:53','2022-10-22 11:39:53',NULL),(897,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',430.00,1,1.00,'Factura C N°: 0004-00000897',NULL,'2022-10-22 11:39:56','2022-10-22 11:39:56',NULL),(898,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000898',NULL,'2022-10-22 11:39:59','2022-10-22 11:39:59',NULL),(899,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',820.00,1,1.00,'Factura C N°: 0004-00000899',NULL,'2022-10-22 11:40:02','2022-10-22 11:40:02',NULL),(900,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',390.00,1,1.00,'Factura C N°: 0004-00000900',NULL,'2022-10-22 11:40:05','2022-10-22 11:40:05',NULL),(901,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000901',NULL,'2022-10-22 11:40:09','2022-10-22 11:40:09',NULL),(902,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',510.00,1,1.00,'Factura C N°: 0004-00000902',NULL,'2022-10-22 11:40:12','2022-10-22 11:40:12',NULL),(903,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',190.00,1,1.00,'Factura C N°: 0004-00000903',NULL,'2022-10-22 11:40:15','2022-10-22 11:40:15',NULL),(904,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000904',NULL,'2022-10-22 11:40:18','2022-10-22 11:40:18',NULL),(905,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',280.00,1,1.00,'Factura C N°: 0004-00000905',NULL,'2022-10-22 11:40:21','2022-10-22 11:40:21',NULL),(906,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000906',NULL,'2022-10-22 11:40:24','2022-10-22 11:40:24',NULL),(907,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000907',NULL,'2022-10-22 11:40:27','2022-10-22 11:40:27',NULL),(908,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',340.00,1,1.00,'Factura C N°: 0004-00000908',NULL,'2022-10-22 11:40:31','2022-10-22 11:40:31',NULL),(909,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',580.00,1,1.00,'Factura C N°: 0004-00000909',NULL,'2022-10-22 11:40:34','2022-10-22 11:40:34',NULL),(910,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',500.00,1,1.00,'Factura C N°: 0004-00000910',NULL,'2022-10-22 11:40:38','2022-10-22 11:40:38',NULL),(911,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',490.00,1,1.00,'Factura C N°: 0004-00000911',NULL,'2022-10-22 11:40:41','2022-10-22 11:40:41',NULL),(912,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',450.00,1,1.00,'Factura C N°: 0004-00000912',NULL,'2022-10-22 11:40:44','2022-10-22 11:40:44',NULL),(913,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',230.00,1,1.00,'Factura C N°: 0004-00000913',NULL,'2022-10-22 11:40:47','2022-10-22 11:40:47',NULL),(914,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',150.00,1,1.00,'Factura C N°: 0004-00000914',NULL,'2022-10-22 11:40:50','2022-10-22 11:40:50',NULL),(915,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',620.00,1,1.00,'Factura C N°: 0004-00000915',NULL,'2022-10-22 11:40:54','2022-10-22 11:40:54',NULL),(916,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',130.00,1,1.00,'Factura C N°: 0004-00000916',NULL,'2022-10-22 11:40:57','2022-10-22 11:40:57',NULL),(917,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',310.00,1,1.00,'Factura C N°: 0004-00000917',NULL,'2022-10-22 11:41:00','2022-10-22 11:41:00',NULL);
INSERT INTO `cta_cte_cliente` VALUES (918,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1140.00,1,1.00,'Factura C N°: 0004-00000918',NULL,'2022-10-22 11:41:04','2022-10-22 11:41:04',NULL),(919,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',100.00,1,1.00,'Factura C N°: 0004-00000919',NULL,'2022-10-22 11:41:08','2022-10-22 11:41:08',NULL),(920,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000920',NULL,'2022-10-22 11:41:11','2022-10-22 11:41:11',NULL),(921,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',240.00,1,1.00,'Factura C N°: 0004-00000921',NULL,'2022-10-22 11:41:15','2022-10-22 11:41:15',NULL),(922,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',360.00,1,1.00,'Factura C N°: 0004-00000922',NULL,'2022-10-22 11:41:20','2022-10-22 11:41:20',NULL),(923,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',390.00,1,1.00,'Factura C N°: 0004-00000923',NULL,'2022-10-22 11:41:25','2022-10-22 11:41:25',NULL),(924,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',1180.00,1,1.00,'Factura C N°: 0004-00000924',NULL,'2022-10-22 11:41:29','2022-10-22 11:41:29',NULL),(925,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',980.00,1,1.00,'Factura C N°: 0004-00000925',NULL,'2022-10-22 11:41:33','2022-10-22 11:41:33',NULL),(926,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',390.00,1,1.00,'Factura C N°: 0004-00000926',NULL,'2022-10-22 11:41:37','2022-10-22 11:41:37',NULL),(927,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',920.00,1,1.00,'Factura C N°: 0004-00000927',NULL,'2022-10-22 11:41:41','2022-10-22 11:41:41',NULL),(928,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000928',NULL,'2022-10-22 11:41:45','2022-10-22 11:41:45',NULL),(929,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000929',NULL,'2022-10-22 11:41:48','2022-10-22 11:41:48',NULL),(930,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',570.00,1,1.00,'Factura C N°: 0004-00000930',NULL,'2022-10-22 11:41:52','2022-10-22 11:41:52',NULL),(931,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',600.00,1,1.00,'Factura C N°: 0004-00000931',NULL,'2022-10-22 11:41:55','2022-10-22 11:41:55',NULL),(932,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000932',NULL,'2022-10-22 11:41:59','2022-10-22 11:41:59',NULL),(933,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',810.00,1,1.00,'Factura C N°: 0004-00000933',NULL,'2022-10-22 11:42:02','2022-10-22 11:42:02',NULL),(934,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',270.00,1,1.00,'Factura C N°: 0004-00000934',NULL,'2022-10-22 11:42:05','2022-10-22 11:42:05',NULL),(935,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',540.00,1,1.00,'Factura C N°: 0004-00000935',NULL,'2022-10-22 11:42:09','2022-10-22 11:42:09',NULL),(936,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',250.00,1,1.00,'Factura C N°: 0004-00000936',NULL,'2022-10-22 11:42:12','2022-10-22 11:42:12',NULL),(937,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',140.00,1,1.00,'Factura C N°: 0004-00000937',NULL,'2022-10-22 11:42:15','2022-10-22 11:42:15',NULL),(938,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',510.00,1,1.00,'Factura C N°: 0004-00000938',NULL,'2022-10-22 11:42:19','2022-10-22 11:42:19',NULL),(939,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000939',NULL,'2022-10-22 11:42:22','2022-10-22 11:42:22',NULL),(940,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',310.00,1,1.00,'Factura C N°: 0004-00000940',NULL,'2022-10-22 11:42:25','2022-10-22 11:42:25',NULL),(941,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',340.00,1,1.00,'Factura C N°: 0004-00000941',NULL,'2022-10-22 11:42:28','2022-10-22 11:42:28',NULL),(942,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',630.00,1,1.00,'Factura C N°: 0004-00000942',NULL,'2022-10-22 11:42:32','2022-10-22 11:42:32',NULL),(943,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000943',NULL,'2022-10-22 11:42:35','2022-10-22 11:42:35',NULL),(944,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000944',NULL,'2022-10-22 11:42:38','2022-10-22 11:42:38',NULL);
INSERT INTO `cta_cte_cliente` VALUES (945,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000945',NULL,'2022-10-22 11:42:41','2022-10-22 11:42:41',NULL),(946,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',260.00,1,1.00,'Factura C N°: 0004-00000946',NULL,'2022-10-22 11:42:44','2022-10-22 11:42:44',NULL),(947,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',80.00,1,1.00,'Factura C N°: 0004-00000947',NULL,'2022-10-22 11:42:47','2022-10-22 11:42:47',NULL),(948,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',250.00,1,1.00,'Factura C N°: 0004-00000948',NULL,'2022-10-22 11:42:50','2022-10-22 11:42:50',NULL),(949,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',200.00,1,1.00,'Factura C N°: 0004-00000949',NULL,'2022-10-22 11:42:54','2022-10-22 11:42:54',NULL),(950,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',190.00,1,1.00,'Factura C N°: 0004-00000950',NULL,'2022-10-22 11:42:57','2022-10-22 11:42:57',NULL),(951,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',430.00,1,1.00,'Factura C N°: 0004-00000951',NULL,'2022-10-22 11:43:01','2022-10-22 11:43:01',NULL),(952,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',500.00,1,1.00,'Factura C N°: 0004-00000952',NULL,'2022-10-22 11:43:04','2022-10-22 11:43:04',NULL),(953,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',400.00,1,1.00,'Factura C N°: 0004-00000953',NULL,'2022-10-22 11:43:07','2022-10-22 11:43:07',NULL),(954,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000954',NULL,'2022-10-22 11:43:10','2022-10-22 11:43:10',NULL),(955,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',120.00,1,1.00,'Factura C N°: 0004-00000955',NULL,'2022-10-22 11:43:14','2022-10-22 11:43:14',NULL),(956,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',150.00,1,1.00,'Factura C N°: 0004-00000956',NULL,'2022-10-22 11:43:17','2022-10-22 11:43:17',NULL),(957,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',230.00,1,1.00,'Factura C N°: 0004-00000957',NULL,'2022-10-22 11:43:20','2022-10-22 11:43:20',NULL),(958,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',780.00,1,1.00,'Factura C N°: 0004-00000958',NULL,'2022-10-22 11:43:24','2022-10-22 11:43:24',NULL),(959,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',170.00,1,1.00,'Factura C N°: 0004-00000959',NULL,'2022-10-22 11:43:27','2022-10-22 11:43:27',NULL),(960,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',180.00,1,1.00,'Factura C N°: 0004-00000960',NULL,'2022-10-22 11:43:30','2022-10-22 11:43:30',NULL),(961,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',450.00,1,1.00,'Factura C N°: 0004-00000961',NULL,'2022-10-22 11:43:33','2022-10-22 11:43:33',NULL),(962,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',270.00,1,1.00,'Factura C N°: 0004-00000962',NULL,'2022-10-22 11:43:36','2022-10-22 11:43:36',NULL),(963,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',110.00,1,1.00,'Factura C N°: 0004-00000963',NULL,'2022-10-22 11:43:39','2022-10-22 11:43:39',NULL),(964,NULL,2,40720,40718,13,1584,1,0,'2022-10-17',870.00,1,1.00,'Factura C N°: 0004-00000964',NULL,'2022-10-22 11:43:43','2022-10-22 11:43:43',NULL),(965,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',470.00,1,1.00,'Factura C N°: 0004-00000965',NULL,'2022-10-22 12:17:30','2022-10-22 12:17:30',NULL),(966,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1440.00,1,1.00,'Factura C N°: 0004-00000966',NULL,'2022-10-22 12:17:33','2022-10-22 12:17:33',NULL),(967,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',230.00,1,1.00,'Factura C N°: 0004-00000967',NULL,'2022-10-22 12:17:36','2022-10-22 12:17:36',NULL),(968,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',170.00,1,1.00,'Factura C N°: 0004-00000968',NULL,'2022-10-22 12:17:39','2022-10-22 12:17:39',NULL),(969,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',210.00,1,1.00,'Factura C N°: 0004-00000969',NULL,'2022-10-22 12:17:43','2022-10-22 12:17:43',NULL),(970,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',540.00,1,1.00,'Factura C N°: 0004-00000970',NULL,'2022-10-22 12:17:46','2022-10-22 12:17:46',NULL),(971,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',490.00,1,1.00,'Factura C N°: 0004-00000971',NULL,'2022-10-22 12:17:49','2022-10-22 12:17:49',NULL);
INSERT INTO `cta_cte_cliente` VALUES (972,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',740.00,1,1.00,'Factura C N°: 0004-00000972',NULL,'2022-10-22 12:17:53','2022-10-22 12:17:53',NULL),(973,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',350.00,1,1.00,'Factura C N°: 0004-00000973',NULL,'2022-10-22 12:17:56','2022-10-22 12:17:56',NULL),(974,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',410.00,1,1.00,'Factura C N°: 0004-00000974',NULL,'2022-10-22 12:17:59','2022-10-22 12:17:59',NULL),(975,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',560.00,1,1.00,'Factura C N°: 0004-00000975',NULL,'2022-10-22 12:18:03','2022-10-22 12:18:03',NULL),(976,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',310.00,1,1.00,'Factura C N°: 0004-00000976',NULL,'2022-10-22 12:18:06','2022-10-22 12:18:06',NULL),(977,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',390.00,1,1.00,'Factura C N°: 0004-00000977',NULL,'2022-10-22 12:18:09','2022-10-22 12:18:09',NULL),(978,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1060.00,1,1.00,'Factura C N°: 0004-00000978',NULL,'2022-10-22 12:18:13','2022-10-22 12:18:13',NULL),(979,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00000979',NULL,'2022-10-22 12:18:16','2022-10-22 12:18:16',NULL),(980,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00000980',NULL,'2022-10-22 12:18:19','2022-10-22 12:18:19',NULL),(981,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',670.00,1,1.00,'Factura C N°: 0004-00000981',NULL,'2022-10-22 12:18:22','2022-10-22 12:18:22',NULL),(982,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',810.00,1,1.00,'Factura C N°: 0004-00000982',NULL,'2022-10-22 12:18:26','2022-10-22 12:18:26',NULL),(983,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1270.00,1,1.00,'Factura C N°: 0004-00000983',NULL,'2022-10-22 12:18:29','2022-10-22 12:18:29',NULL),(984,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',280.00,1,1.00,'Factura C N°: 0004-00000984',NULL,'2022-10-22 12:18:32','2022-10-22 12:18:32',NULL),(985,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',520.00,1,1.00,'Factura C N°: 0004-00000985',NULL,'2022-10-22 12:18:35','2022-10-22 12:18:35',NULL),(986,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',310.00,1,1.00,'Factura C N°: 0004-00000986',NULL,'2022-10-22 12:18:39','2022-10-22 12:18:39',NULL),(987,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00000987',NULL,'2022-10-22 12:18:42','2022-10-22 12:18:42',NULL),(988,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1390.00,1,1.00,'Factura C N°: 0004-00000988',NULL,'2022-10-22 12:18:46','2022-10-22 12:18:46',NULL),(989,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',340.00,1,1.00,'Factura C N°: 0004-00000989',NULL,'2022-10-22 12:18:49','2022-10-22 12:18:49',NULL),(990,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',210.00,1,1.00,'Factura C N°: 0004-00000990',NULL,'2022-10-22 12:18:52','2022-10-22 12:18:52',NULL),(991,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',730.00,1,1.00,'Factura C N°: 0004-00000991',NULL,'2022-10-22 12:18:55','2022-10-22 12:18:55',NULL),(992,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',120.00,1,1.00,'Factura C N°: 0004-00000992',NULL,'2022-10-22 12:18:58','2022-10-22 12:18:58',NULL),(993,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',510.00,1,1.00,'Factura C N°: 0004-00000993',NULL,'2022-10-22 12:19:02','2022-10-22 12:19:02',NULL),(994,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',190.00,1,1.00,'Factura C N°: 0004-00000994',NULL,'2022-10-22 12:19:05','2022-10-22 12:19:05',NULL),(995,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',380.00,1,1.00,'Factura C N°: 0004-00000995',NULL,'2022-10-22 12:19:08','2022-10-22 12:19:08',NULL),(996,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00000996',NULL,'2022-10-22 12:19:11','2022-10-22 12:19:11',NULL),(997,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',580.00,1,1.00,'Factura C N°: 0004-00000997',NULL,'2022-10-22 12:19:15','2022-10-22 12:19:15',NULL),(998,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',520.00,1,1.00,'Factura C N°: 0004-00000998',NULL,'2022-10-22 12:19:18','2022-10-22 12:19:18',NULL);
INSERT INTO `cta_cte_cliente` VALUES (999,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',410.00,1,1.00,'Factura C N°: 0004-00000999',NULL,'2022-10-22 12:19:21','2022-10-22 12:19:21',NULL),(1000,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001000',NULL,'2022-10-22 12:19:25','2022-10-22 12:19:25',NULL),(1001,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',380.00,1,1.00,'Factura C N°: 0004-00001001',NULL,'2022-10-22 12:19:26','2022-10-22 12:19:26',NULL),(1002,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',440.00,1,1.00,'Factura C N°: 0004-00001002',NULL,'2022-10-22 12:19:27','2022-10-22 12:19:27',NULL),(1003,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',390.00,1,1.00,'Factura C N°: 0004-00001003',NULL,'2022-10-22 12:19:28','2022-10-22 12:19:28',NULL),(1004,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',860.00,1,1.00,'Factura C N°: 0004-00001004',NULL,'2022-10-22 12:19:29','2022-10-22 12:19:29',NULL),(1005,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1930.00,1,1.00,'Factura C N°: 0004-00001005',NULL,'2022-10-22 12:19:30','2022-10-22 12:19:30',NULL),(1006,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',500.00,1,1.00,'Factura C N°: 0004-00001006',NULL,'2022-10-22 12:19:31','2022-10-22 12:19:31',NULL),(1007,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',150.00,1,1.00,'Factura C N°: 0004-00001007',NULL,'2022-10-22 12:19:32','2022-10-22 12:19:32',NULL),(1008,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',510.00,1,1.00,'Factura C N°: 0004-00001008',NULL,'2022-10-22 12:19:33','2022-10-22 12:19:33',NULL),(1009,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',490.00,1,1.00,'Factura C N°: 0004-00001009',NULL,'2022-10-22 12:19:34','2022-10-22 12:19:34',NULL),(1010,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001010',NULL,'2022-10-22 12:19:35','2022-10-22 12:19:35',NULL),(1011,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',340.00,1,1.00,'Factura C N°: 0004-00001011',NULL,'2022-10-22 12:19:36','2022-10-22 12:19:36',NULL),(1012,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',150.00,1,1.00,'Factura C N°: 0004-00001012',NULL,'2022-10-22 12:19:37','2022-10-22 12:19:37',NULL),(1013,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',310.00,1,1.00,'Factura C N°: 0004-00001013',NULL,'2022-10-22 12:19:38','2022-10-22 12:19:38',NULL),(1014,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',230.00,1,1.00,'Factura C N°: 0004-00001014',NULL,'2022-10-22 12:19:40','2022-10-22 12:19:40',NULL),(1015,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',270.00,1,1.00,'Factura C N°: 0004-00001015',NULL,'2022-10-22 12:19:41','2022-10-22 12:19:41',NULL),(1016,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001016',NULL,'2022-10-22 12:19:42','2022-10-22 12:19:42',NULL),(1017,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',270.00,1,1.00,'Factura C N°: 0004-00001017',NULL,'2022-10-22 12:19:43','2022-10-22 12:19:43',NULL),(1018,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1000.00,1,1.00,'Factura C N°: 0004-00001018',NULL,'2022-10-22 12:19:44','2022-10-22 12:19:44',NULL),(1019,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',440.00,1,1.00,'Factura C N°: 0004-00001019',NULL,'2022-10-22 12:19:46','2022-10-22 12:19:46',NULL),(1020,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',300.00,1,1.00,'Factura C N°: 0004-00001020',NULL,'2022-10-22 12:19:47','2022-10-22 12:19:47',NULL),(1021,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',240.00,1,1.00,'Factura C N°: 0004-00001021',NULL,'2022-10-22 12:19:48','2022-10-22 12:19:48',NULL),(1022,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',220.00,1,1.00,'Factura C N°: 0004-00001022',NULL,'2022-10-22 12:19:49','2022-10-22 12:19:49',NULL),(1023,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',120.00,1,1.00,'Factura C N°: 0004-00001023',NULL,'2022-10-22 12:19:50','2022-10-22 12:19:50',NULL),(1024,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',150.00,1,1.00,'Factura C N°: 0004-00001024',NULL,'2022-10-22 12:19:51','2022-10-22 12:19:51',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1025,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',260.00,1,1.00,'Factura C N°: 0004-00001025',NULL,'2022-10-22 12:19:52','2022-10-22 12:19:52',NULL),(1026,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',270.00,1,1.00,'Factura C N°: 0004-00001026',NULL,'2022-10-22 12:19:53','2022-10-22 12:19:53',NULL),(1027,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',240.00,1,1.00,'Factura C N°: 0004-00001027',NULL,'2022-10-22 12:19:54','2022-10-22 12:19:54',NULL),(1028,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',710.00,1,1.00,'Factura C N°: 0004-00001028',NULL,'2022-10-22 12:19:55','2022-10-22 12:19:55',NULL),(1029,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',260.00,1,1.00,'Factura C N°: 0004-00001029',NULL,'2022-10-22 12:19:56','2022-10-22 12:19:56',NULL),(1030,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',80.00,1,1.00,'Factura C N°: 0004-00001030',NULL,'2022-10-22 12:19:57','2022-10-22 12:19:57',NULL),(1031,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1010.00,1,1.00,'Factura C N°: 0004-00001031',NULL,'2022-10-22 12:19:58','2022-10-22 12:19:58',NULL),(1032,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',540.00,1,1.00,'Factura C N°: 0004-00001032',NULL,'2022-10-22 12:19:59','2022-10-22 12:19:59',NULL),(1033,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001033',NULL,'2022-10-22 12:20:00','2022-10-22 12:20:00',NULL),(1034,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1260.00,1,1.00,'Factura C N°: 0004-00001034',NULL,'2022-10-22 12:20:01','2022-10-22 12:20:01',NULL),(1035,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001035',NULL,'2022-10-22 12:20:02','2022-10-22 12:20:02',NULL),(1036,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',900.00,1,1.00,'Factura C N°: 0004-00001036',NULL,'2022-10-22 12:20:04','2022-10-22 12:20:04',NULL),(1037,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',50.00,1,1.00,'Factura C N°: 0004-00001037',NULL,'2022-10-22 12:20:05','2022-10-22 12:20:05',NULL),(1038,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',420.00,1,1.00,'Factura C N°: 0004-00001038',NULL,'2022-10-22 12:20:06','2022-10-22 12:20:06',NULL),(1039,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',310.00,1,1.00,'Factura C N°: 0004-00001039',NULL,'2022-10-22 12:20:07','2022-10-22 12:20:07',NULL),(1040,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',260.00,1,1.00,'Factura C N°: 0004-00001040',NULL,'2022-10-22 12:20:09','2022-10-22 12:20:09',NULL),(1041,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',710.00,1,1.00,'Factura C N°: 0004-00001041',NULL,'2022-10-22 12:20:10','2022-10-22 12:20:10',NULL),(1042,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',260.00,1,1.00,'Factura C N°: 0004-00001042',NULL,'2022-10-22 12:20:11','2022-10-22 12:20:11',NULL),(1043,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',200.00,1,1.00,'Factura C N°: 0004-00001043',NULL,'2022-10-22 12:20:12','2022-10-22 12:20:12',NULL),(1044,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',230.00,1,1.00,'Factura C N°: 0004-00001044',NULL,'2022-10-22 12:20:13','2022-10-22 12:20:13',NULL),(1045,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',250.00,1,1.00,'Factura C N°: 0004-00001045',NULL,'2022-10-22 12:20:16','2022-10-22 12:20:16',NULL),(1046,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',390.00,1,1.00,'Factura C N°: 0004-00001046',NULL,'2022-10-22 12:20:17','2022-10-22 12:20:17',NULL),(1047,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',470.00,1,1.00,'Factura C N°: 0004-00001047',NULL,'2022-10-22 12:20:18','2022-10-22 12:20:18',NULL),(1048,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',330.00,1,1.00,'Factura C N°: 0004-00001048',NULL,'2022-10-22 12:20:24','2022-10-22 12:20:24',NULL),(1049,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',620.00,1,1.00,'Factura C N°: 0004-00001049',NULL,'2022-10-22 12:20:26','2022-10-22 12:20:26',NULL),(1050,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',380.00,1,1.00,'Factura C N°: 0004-00001050',NULL,'2022-10-22 12:20:28','2022-10-22 12:20:28',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1051,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',390.00,1,1.00,'Factura C N°: 0004-00001051',NULL,'2022-10-22 12:20:30','2022-10-22 12:20:30',NULL),(1052,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',450.00,1,1.00,'Factura C N°: 0004-00001052',NULL,'2022-10-22 12:20:31','2022-10-22 12:20:31',NULL),(1053,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',480.00,1,1.00,'Factura C N°: 0004-00001053',NULL,'2022-10-22 12:20:32','2022-10-22 12:20:32',NULL),(1054,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',680.00,1,1.00,'Factura C N°: 0004-00001054',NULL,'2022-10-22 12:20:34','2022-10-22 12:20:34',NULL),(1055,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',430.00,1,1.00,'Factura C N°: 0004-00001055',NULL,'2022-10-22 12:20:35','2022-10-22 12:20:35',NULL),(1056,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001056',NULL,'2022-10-22 12:20:36','2022-10-22 12:20:36',NULL),(1057,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001057',NULL,'2022-10-22 12:20:39','2022-10-22 12:20:39',NULL),(1058,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',560.00,1,1.00,'Factura C N°: 0004-00001058',NULL,'2022-10-22 12:20:40','2022-10-22 12:20:40',NULL),(1059,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',740.00,1,1.00,'Factura C N°: 0004-00001059',NULL,'2022-10-22 12:20:44','2022-10-22 12:20:44',NULL),(1060,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',610.00,1,1.00,'Factura C N°: 0004-00001060',NULL,'2022-10-22 12:20:46','2022-10-22 12:20:46',NULL),(1061,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',490.00,1,1.00,'Factura C N°: 0004-00001061',NULL,'2022-10-22 12:20:47','2022-10-22 12:20:47',NULL),(1062,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',440.00,1,1.00,'Factura C N°: 0004-00001062',NULL,'2022-10-22 12:20:48','2022-10-22 12:20:48',NULL),(1063,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',240.00,1,1.00,'Factura C N°: 0004-00001063',NULL,'2022-10-22 12:20:49','2022-10-22 12:20:49',NULL),(1064,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',170.00,1,1.00,'Factura C N°: 0004-00001064',NULL,'2022-10-22 12:20:51','2022-10-22 12:20:51',NULL),(1065,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',390.00,1,1.00,'Factura C N°: 0004-00001065',NULL,'2022-10-22 12:20:52','2022-10-22 12:20:52',NULL),(1066,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',240.00,1,1.00,'Factura C N°: 0004-00001066',NULL,'2022-10-22 12:20:53','2022-10-22 12:20:53',NULL),(1067,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',280.00,1,1.00,'Factura C N°: 0004-00001067',NULL,'2022-10-22 12:20:54','2022-10-22 12:20:54',NULL),(1068,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',490.00,1,1.00,'Factura C N°: 0004-00001068',NULL,'2022-10-22 12:20:56','2022-10-22 12:20:56',NULL),(1069,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',820.00,1,1.00,'Factura C N°: 0004-00001069',NULL,'2022-10-22 12:20:57','2022-10-22 12:20:57',NULL),(1070,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',780.00,1,1.00,'Factura C N°: 0004-00001070',NULL,'2022-10-22 12:20:59','2022-10-22 12:20:59',NULL),(1071,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',380.00,1,1.00,'Factura C N°: 0004-00001071',NULL,'2022-10-22 12:21:00','2022-10-22 12:21:00',NULL),(1072,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',310.00,1,1.00,'Factura C N°: 0004-00001072',NULL,'2022-10-22 12:21:01','2022-10-22 12:21:01',NULL),(1073,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',410.00,1,1.00,'Factura C N°: 0004-00001073',NULL,'2022-10-22 12:21:02','2022-10-22 12:21:02',NULL),(1074,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',450.00,1,1.00,'Factura C N°: 0004-00001074',NULL,'2022-10-22 12:21:05','2022-10-22 12:21:05',NULL),(1075,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001075',NULL,'2022-10-22 12:21:07','2022-10-22 12:21:07',NULL),(1076,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1770.00,1,1.00,'Factura C N°: 0004-00001076',NULL,'2022-10-22 12:21:08','2022-10-22 12:21:08',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1077,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',550.00,1,1.00,'Factura C N°: 0004-00001077',NULL,'2022-10-22 12:21:11','2022-10-22 12:21:11',NULL),(1078,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',470.00,1,1.00,'Factura C N°: 0004-00001078',NULL,'2022-10-22 12:21:12','2022-10-22 12:21:12',NULL),(1079,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001079',NULL,'2022-10-22 12:21:14','2022-10-22 12:21:14',NULL),(1080,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001080',NULL,'2022-10-22 12:21:15','2022-10-22 12:21:15',NULL),(1081,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',370.00,1,1.00,'Factura C N°: 0004-00001081',NULL,'2022-10-22 12:21:17','2022-10-22 12:21:17',NULL),(1082,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',310.00,1,1.00,'Factura C N°: 0004-00001082',NULL,'2022-10-22 12:21:18','2022-10-22 12:21:18',NULL),(1083,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',280.00,1,1.00,'Factura C N°: 0004-00001083',NULL,'2022-10-22 12:21:19','2022-10-22 12:21:19',NULL),(1084,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',210.00,1,1.00,'Factura C N°: 0004-00001084',NULL,'2022-10-22 12:21:21','2022-10-22 12:21:21',NULL),(1085,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',200.00,1,1.00,'Factura C N°: 0004-00001085',NULL,'2022-10-22 12:21:22','2022-10-22 12:21:22',NULL),(1086,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',350.00,1,1.00,'Factura C N°: 0004-00001086',NULL,'2022-10-22 12:21:23','2022-10-22 12:21:23',NULL),(1087,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',130.00,1,1.00,'Factura C N°: 0004-00001087',NULL,'2022-10-22 12:21:25','2022-10-22 12:21:25',NULL),(1088,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',130.00,1,1.00,'Factura C N°: 0004-00001088',NULL,'2022-10-22 12:21:29','2022-10-22 12:21:29',NULL),(1089,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',110.00,1,1.00,'Factura C N°: 0004-00001089',NULL,'2022-10-22 12:21:30','2022-10-22 12:21:30',NULL),(1090,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',270.00,1,1.00,'Factura C N°: 0004-00001090',NULL,'2022-10-22 12:21:31','2022-10-22 12:21:31',NULL),(1091,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',940.00,1,1.00,'Factura C N°: 0004-00001091',NULL,'2022-10-22 12:21:33','2022-10-22 12:21:33',NULL),(1092,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',340.00,1,1.00,'Factura C N°: 0004-00001092',NULL,'2022-10-22 12:21:34','2022-10-22 12:21:34',NULL),(1093,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1100.00,1,1.00,'Factura C N°: 0004-00001093',NULL,'2022-10-22 12:21:35','2022-10-22 12:21:35',NULL),(1094,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',130.00,1,1.00,'Factura C N°: 0004-00001094',NULL,'2022-10-22 12:21:36','2022-10-22 12:21:36',NULL),(1095,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',210.00,1,1.00,'Factura C N°: 0004-00001095',NULL,'2022-10-22 12:21:37','2022-10-22 12:21:37',NULL),(1096,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',490.00,1,1.00,'Factura C N°: 0004-00001096',NULL,'2022-10-22 12:21:38','2022-10-22 12:21:38',NULL),(1097,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',300.00,1,1.00,'Factura C N°: 0004-00001097',NULL,'2022-10-22 12:21:39','2022-10-22 12:21:39',NULL),(1098,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',2520.00,1,1.00,'Factura C N°: 0004-00001098',NULL,'2022-10-22 12:21:41','2022-10-22 12:21:41',NULL),(1099,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',340.00,1,1.00,'Factura C N°: 0004-00001099',NULL,'2022-10-22 12:21:42','2022-10-22 12:21:42',NULL),(1100,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',930.00,1,1.00,'Factura C N°: 0004-00001100',NULL,'2022-10-22 12:21:45','2022-10-22 12:21:45',NULL),(1101,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',510.00,1,1.00,'Factura C N°: 0004-00001101',NULL,'2022-10-22 12:21:46','2022-10-22 12:21:46',NULL),(1102,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',280.00,1,1.00,'Factura C N°: 0004-00001102',NULL,'2022-10-22 12:21:48','2022-10-22 12:21:48',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1103,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',250.00,1,1.00,'Factura C N°: 0004-00001103',NULL,'2022-10-22 12:21:49','2022-10-22 12:21:49',NULL),(1104,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',260.00,1,1.00,'Factura C N°: 0004-00001104',NULL,'2022-10-22 12:21:50','2022-10-22 12:21:50',NULL),(1105,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',500.00,1,1.00,'Factura C N°: 0004-00001105',NULL,'2022-10-22 12:21:52','2022-10-22 12:21:52',NULL),(1106,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',140.00,1,1.00,'Factura C N°: 0004-00001106',NULL,'2022-10-22 12:21:53','2022-10-22 12:21:53',NULL),(1107,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',600.00,1,1.00,'Factura C N°: 0004-00001107',NULL,'2022-10-22 12:21:54','2022-10-22 12:21:54',NULL),(1108,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',150.00,1,1.00,'Factura C N°: 0004-00001108',NULL,'2022-10-22 12:21:55','2022-10-22 12:21:55',NULL),(1109,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',130.00,1,1.00,'Factura C N°: 0004-00001109',NULL,'2022-10-22 12:21:57','2022-10-22 12:21:57',NULL),(1110,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',170.00,1,1.00,'Factura C N°: 0004-00001110',NULL,'2022-10-22 12:21:58','2022-10-22 12:21:58',NULL),(1111,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',340.00,1,1.00,'Factura C N°: 0004-00001111',NULL,'2022-10-22 12:21:58','2022-10-22 12:21:58',NULL),(1112,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',550.00,1,1.00,'Factura C N°: 0004-00001112',NULL,'2022-10-22 12:21:59','2022-10-22 12:21:59',NULL),(1113,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',820.00,1,1.00,'Factura C N°: 0004-00001113',NULL,'2022-10-22 12:22:01','2022-10-22 12:22:01',NULL),(1114,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',270.00,1,1.00,'Factura C N°: 0004-00001114',NULL,'2022-10-22 12:22:02','2022-10-22 12:22:02',NULL),(1115,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001115',NULL,'2022-10-22 12:22:03','2022-10-22 12:22:03',NULL),(1116,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001116',NULL,'2022-10-22 12:22:04','2022-10-22 12:22:04',NULL),(1117,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',610.00,1,1.00,'Factura C N°: 0004-00001117',NULL,'2022-10-22 12:22:05','2022-10-22 12:22:05',NULL),(1118,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',740.00,1,1.00,'Factura C N°: 0004-00001118',NULL,'2022-10-22 12:22:06','2022-10-22 12:22:06',NULL),(1119,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',770.00,1,1.00,'Factura C N°: 0004-00001119',NULL,'2022-10-22 12:22:08','2022-10-22 12:22:08',NULL),(1120,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',230.00,1,1.00,'Factura C N°: 0004-00001120',NULL,'2022-10-22 12:22:09','2022-10-22 12:22:09',NULL),(1121,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',2.00,1,1.00,'Factura C N°: 0004-00001121',NULL,'2022-10-22 12:22:10','2022-10-22 12:22:10',NULL),(1122,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',280.00,1,1.00,'Factura C N°: 0004-00001122',NULL,'2022-10-22 12:22:11','2022-10-22 12:22:11',NULL),(1123,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',200.00,1,1.00,'Factura C N°: 0004-00001123',NULL,'2022-10-22 12:22:12','2022-10-22 12:22:12',NULL),(1124,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001124',NULL,'2022-10-22 12:22:13','2022-10-22 12:22:13',NULL),(1125,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',520.00,1,1.00,'Factura C N°: 0004-00001125',NULL,'2022-10-22 12:22:14','2022-10-22 12:22:14',NULL),(1126,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',510.00,1,1.00,'Factura C N°: 0004-00001126',NULL,'2022-10-22 12:22:15','2022-10-22 12:22:15',NULL),(1127,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001127',NULL,'2022-10-22 12:22:16','2022-10-22 12:22:16',NULL),(1128,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001128',NULL,'2022-10-22 12:22:17','2022-10-22 12:22:17',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1129,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',590.00,1,1.00,'Factura C N°: 0004-00001129',NULL,'2022-10-22 12:22:18','2022-10-22 12:22:18',NULL),(1130,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',330.00,1,1.00,'Factura C N°: 0004-00001130',NULL,'2022-10-22 12:22:19','2022-10-22 12:22:19',NULL),(1131,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',470.00,1,1.00,'Factura C N°: 0004-00001131',NULL,'2022-10-22 12:22:21','2022-10-22 12:22:21',NULL),(1132,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',540.00,1,1.00,'Factura C N°: 0004-00001132',NULL,'2022-10-22 12:22:22','2022-10-22 12:22:22',NULL),(1133,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',260.00,1,1.00,'Factura C N°: 0004-00001133',NULL,'2022-10-22 12:22:24','2022-10-22 12:22:24',NULL),(1134,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',300.00,1,1.00,'Factura C N°: 0004-00001134',NULL,'2022-10-22 12:22:25','2022-10-22 12:22:25',NULL),(1135,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',210.00,1,1.00,'Factura C N°: 0004-00001135',NULL,'2022-10-22 12:22:26','2022-10-22 12:22:26',NULL),(1136,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',430.00,1,1.00,'Factura C N°: 0004-00001136',NULL,'2022-10-22 12:22:27','2022-10-22 12:22:27',NULL),(1137,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',470.00,1,1.00,'Factura C N°: 0004-00001137',NULL,'2022-10-22 12:22:29','2022-10-22 12:22:29',NULL),(1138,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',370.00,1,1.00,'Factura C N°: 0004-00001138',NULL,'2022-10-22 12:22:30','2022-10-22 12:22:30',NULL),(1139,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001139',NULL,'2022-10-22 12:22:31','2022-10-22 12:22:31',NULL),(1140,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',470.00,1,1.00,'Factura C N°: 0004-00001140',NULL,'2022-10-22 12:22:32','2022-10-22 12:22:32',NULL),(1141,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',260.00,1,1.00,'Factura C N°: 0004-00001141',NULL,'2022-10-22 12:22:33','2022-10-22 12:22:33',NULL),(1142,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',520.00,1,1.00,'Factura C N°: 0004-00001142',NULL,'2022-10-22 12:22:34','2022-10-22 12:22:34',NULL),(1143,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',310.00,1,1.00,'Factura C N°: 0004-00001143',NULL,'2022-10-22 12:22:35','2022-10-22 12:22:35',NULL),(1144,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',340.00,1,1.00,'Factura C N°: 0004-00001144',NULL,'2022-10-22 12:22:36','2022-10-22 12:22:36',NULL),(1145,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',270.00,1,1.00,'Factura C N°: 0004-00001145',NULL,'2022-10-22 12:22:37','2022-10-22 12:22:37',NULL),(1146,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',890.00,1,1.00,'Factura C N°: 0004-00001146',NULL,'2022-10-22 12:22:38','2022-10-22 12:22:38',NULL),(1147,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001147',NULL,'2022-10-22 12:22:39','2022-10-22 12:22:39',NULL),(1148,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',100.00,1,1.00,'Factura C N°: 0004-00001148',NULL,'2022-10-22 12:22:40','2022-10-22 12:22:40',NULL),(1149,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001149',NULL,'2022-10-22 12:22:41','2022-10-22 12:22:41',NULL),(1150,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',220.00,1,1.00,'Factura C N°: 0004-00001150',NULL,'2022-10-22 12:22:42','2022-10-22 12:22:42',NULL),(1151,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',290.00,1,1.00,'Factura C N°: 0004-00001151',NULL,'2022-10-22 12:22:43','2022-10-22 12:22:43',NULL),(1152,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',850.00,1,1.00,'Factura C N°: 0004-00001152',NULL,'2022-10-22 12:22:45','2022-10-22 12:22:45',NULL),(1153,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',200.00,1,1.00,'Factura C N°: 0004-00001153',NULL,'2022-10-22 12:22:46','2022-10-22 12:22:46',NULL),(1154,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',380.00,1,1.00,'Factura C N°: 0004-00001154',NULL,'2022-10-22 12:22:47','2022-10-22 12:22:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1155,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',260.00,1,1.00,'Factura C N°: 0004-00001155',NULL,'2022-10-22 12:22:48','2022-10-22 12:22:48',NULL),(1156,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',550.00,1,1.00,'Factura C N°: 0004-00001156',NULL,'2022-10-22 12:22:49','2022-10-22 12:22:49',NULL),(1157,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',550.00,1,1.00,'Factura C N°: 0004-00001157',NULL,'2022-10-22 12:22:51','2022-10-22 12:22:51',NULL),(1158,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',780.00,1,1.00,'Factura C N°: 0004-00001158',NULL,'2022-10-22 12:22:52','2022-10-22 12:22:52',NULL),(1159,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001159',NULL,'2022-10-22 12:22:53','2022-10-22 12:22:53',NULL),(1160,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',1030.00,1,1.00,'Factura C N°: 0004-00001160',NULL,'2022-10-22 12:22:54','2022-10-22 12:22:54',NULL),(1161,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',960.00,1,1.00,'Factura C N°: 0004-00001161',NULL,'2022-10-22 12:22:55','2022-10-22 12:22:55',NULL),(1162,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',680.00,1,1.00,'Factura C N°: 0004-00001162',NULL,'2022-10-22 12:22:56','2022-10-22 12:22:56',NULL),(1163,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',360.00,1,1.00,'Factura C N°: 0004-00001163',NULL,'2022-10-22 12:22:57','2022-10-22 12:22:57',NULL),(1164,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',280.00,1,1.00,'Factura C N°: 0004-00001164',NULL,'2022-10-22 12:22:58','2022-10-22 12:22:58',NULL),(1165,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',160.00,1,1.00,'Factura C N°: 0004-00001165',NULL,'2022-10-22 12:22:59','2022-10-22 12:22:59',NULL),(1166,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',780.00,1,1.00,'Factura C N°: 0004-00001166',NULL,'2022-10-22 12:23:00','2022-10-22 12:23:00',NULL),(1167,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',330.00,1,1.00,'Factura C N°: 0004-00001167',NULL,'2022-10-22 12:23:01','2022-10-22 12:23:01',NULL),(1168,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',460.00,1,1.00,'Factura C N°: 0004-00001168',NULL,'2022-10-22 12:23:02','2022-10-22 12:23:02',NULL),(1169,NULL,2,40720,40718,13,1584,1,0,'2022-10-18',410.00,1,1.00,'Factura C N°: 0004-00001169',NULL,'2022-10-22 12:23:03','2022-10-22 12:23:03',NULL),(1170,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',400.00,1,1.00,'Factura C N°: 0004-00001170',NULL,'2022-10-22 12:23:05','2022-10-22 12:23:05',NULL),(1171,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',380.00,1,1.00,'Factura C N°: 0004-00001171',NULL,'2022-10-22 12:23:06','2022-10-22 12:23:06',NULL),(1172,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',310.00,1,1.00,'Factura C N°: 0004-00001172',NULL,'2022-10-22 12:23:07','2022-10-22 12:23:07',NULL),(1173,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',270.00,1,1.00,'Factura C N°: 0004-00001173',NULL,'2022-10-22 12:23:08','2022-10-22 12:23:08',NULL),(1174,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',210.00,1,1.00,'Factura C N°: 0004-00001174',NULL,'2022-10-22 12:23:10','2022-10-22 12:23:10',NULL),(1175,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',130.00,1,1.00,'Factura C N°: 0004-00001175',NULL,'2022-10-22 12:23:11','2022-10-22 12:23:11',NULL),(1176,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',310.00,1,1.00,'Factura C N°: 0004-00001176',NULL,'2022-10-22 12:23:12','2022-10-22 12:23:12',NULL),(1177,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',490.00,1,1.00,'Factura C N°: 0004-00001177',NULL,'2022-10-22 12:23:13','2022-10-22 12:23:13',NULL),(1178,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',150.00,1,1.00,'Factura C N°: 0004-00001178',NULL,'2022-10-22 12:23:14','2022-10-22 12:23:14',NULL),(1179,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',130.00,1,1.00,'Factura C N°: 0004-00001179',NULL,'2022-10-22 12:23:15','2022-10-22 12:23:15',NULL),(1180,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',60.00,1,1.00,'Factura C N°: 0004-00001180',NULL,'2022-10-22 12:23:16','2022-10-22 12:23:16',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1181,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',80.00,1,1.00,'Factura C N°: 0004-00001181',NULL,'2022-10-22 12:23:17','2022-10-22 12:23:17',NULL),(1182,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',150.00,1,1.00,'Factura C N°: 0004-00001182',NULL,'2022-10-22 12:23:18','2022-10-22 12:23:18',NULL),(1183,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',200.00,1,1.00,'Factura C N°: 0004-00001183',NULL,'2022-10-22 12:23:19','2022-10-22 12:23:19',NULL),(1184,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',300.00,1,1.00,'Factura C N°: 0004-00001184',NULL,'2022-10-22 12:23:20','2022-10-22 12:23:20',NULL),(1185,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',850.00,1,1.00,'Factura C N°: 0004-00001185',NULL,'2022-10-22 12:23:21','2022-10-22 12:23:21',NULL),(1186,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',170.00,1,1.00,'Factura C N°: 0004-00001186',NULL,'2022-10-22 12:23:22','2022-10-22 12:23:22',NULL),(1187,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',510.00,1,1.00,'Factura C N°: 0004-00001187',NULL,'2022-10-22 12:23:23','2022-10-22 12:23:23',NULL),(1188,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',670.00,1,1.00,'Factura C N°: 0004-00001188',NULL,'2022-10-22 12:23:24','2022-10-22 12:23:24',NULL),(1189,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',280.00,1,1.00,'Factura C N°: 0004-00001189',NULL,'2022-10-22 12:23:25','2022-10-22 12:23:25',NULL),(1190,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',320.00,1,1.00,'Factura C N°: 0004-00001190',NULL,'2022-10-22 12:23:26','2022-10-22 12:23:26',NULL),(1191,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',150.00,1,1.00,'Factura C N°: 0004-00001191',NULL,'2022-10-22 12:23:28','2022-10-22 12:23:28',NULL),(1192,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',160.00,1,1.00,'Factura C N°: 0004-00001192',NULL,'2022-10-22 12:23:29','2022-10-22 12:23:29',NULL),(1193,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',200.00,1,1.00,'Factura C N°: 0004-00001193',NULL,'2022-10-22 12:23:30','2022-10-22 12:23:30',NULL),(1194,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',150.00,1,1.00,'Factura C N°: 0004-00001194',NULL,'2022-10-22 12:23:32','2022-10-22 12:23:32',NULL),(1195,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',310.00,1,1.00,'Factura C N°: 0004-00001195',NULL,'2022-10-22 12:23:33','2022-10-22 12:23:33',NULL),(1196,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',120.00,1,1.00,'Factura C N°: 0004-00001196',NULL,'2022-10-22 12:23:34','2022-10-22 12:23:34',NULL),(1197,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',120.00,1,1.00,'Factura C N°: 0004-00001197',NULL,'2022-10-22 12:23:35','2022-10-22 12:23:35',NULL),(1198,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',100.00,1,1.00,'Factura C N°: 0004-00001198',NULL,'2022-10-22 12:23:36','2022-10-22 12:23:36',NULL),(1199,NULL,2,40720,40718,13,1584,1,0,'2022-10-19',150.00,1,1.00,'Factura C N°: 0004-00001199',NULL,'2022-10-22 12:23:37','2022-10-22 12:23:37',NULL),(1200,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',880.00,1,1.00,'Factura C N°: 0004-00001200',NULL,'2022-10-22 12:29:33','2022-10-22 12:29:33',NULL),(1201,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',310.00,1,1.00,'Factura C N°: 0004-00001201',NULL,'2022-10-22 12:29:34','2022-10-22 12:29:34',NULL),(1202,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',290.00,1,1.00,'Factura C N°: 0004-00001202',NULL,'2022-10-22 12:29:35','2022-10-22 12:29:35',NULL),(1203,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',360.00,1,1.00,'Factura C N°: 0004-00001203',NULL,'2022-10-22 12:29:36','2022-10-22 12:29:36',NULL),(1204,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',870.00,1,1.00,'Factura C N°: 0004-00001204',NULL,'2022-10-22 12:29:37','2022-10-22 12:29:37',NULL),(1205,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',310.00,1,1.00,'Factura C N°: 0004-00001205',NULL,'2022-10-22 12:29:38','2022-10-22 12:29:38',NULL),(1206,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',700.00,1,1.00,'Factura C N°: 0004-00001206',NULL,'2022-10-22 12:29:39','2022-10-22 12:29:39',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1207,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',80.00,1,1.00,'Factura C N°: 0004-00001207',NULL,'2022-10-22 12:29:40','2022-10-22 12:29:40',NULL),(1208,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',70.00,1,1.00,'Factura C N°: 0004-00001208',NULL,'2022-10-22 12:29:41','2022-10-22 12:29:41',NULL),(1209,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',150.00,1,1.00,'Factura C N°: 0004-00001209',NULL,'2022-10-22 12:29:42','2022-10-22 12:29:42',NULL),(1210,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',340.00,1,1.00,'Factura C N°: 0004-00001210',NULL,'2022-10-22 12:29:43','2022-10-22 12:29:43',NULL),(1211,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',570.00,1,1.00,'Factura C N°: 0004-00001211',NULL,'2022-10-22 12:29:44','2022-10-22 12:29:44',NULL),(1212,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',340.00,1,1.00,'Factura C N°: 0004-00001212',NULL,'2022-10-22 12:29:45','2022-10-22 12:29:45',NULL),(1213,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',90.00,1,1.00,'Factura C N°: 0004-00001213',NULL,'2022-10-22 12:29:46','2022-10-22 12:29:46',NULL),(1214,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',290.00,1,1.00,'Factura C N°: 0004-00001214',NULL,'2022-10-22 12:29:47','2022-10-22 12:29:47',NULL),(1215,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',730.00,1,1.00,'Factura C N°: 0004-00001215',NULL,'2022-10-22 12:29:48','2022-10-22 12:29:48',NULL),(1216,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',400.00,1,1.00,'Factura C N°: 0004-00001216',NULL,'2022-10-22 12:29:49','2022-10-22 12:29:49',NULL),(1217,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',550.00,1,1.00,'Factura C N°: 0004-00001217',NULL,'2022-10-22 12:29:50','2022-10-22 12:29:50',NULL),(1218,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',670.00,1,1.00,'Factura C N°: 0004-00001218',NULL,'2022-10-22 12:29:51','2022-10-22 12:29:51',NULL),(1219,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',280.00,1,1.00,'Factura C N°: 0004-00001219',NULL,'2022-10-22 12:29:53','2022-10-22 12:29:53',NULL),(1220,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',320.00,1,1.00,'Factura C N°: 0004-00001220',NULL,'2022-10-22 12:29:54','2022-10-22 12:29:54',NULL),(1221,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',150.00,1,1.00,'Factura C N°: 0004-00001221',NULL,'2022-10-22 12:29:55','2022-10-22 12:29:55',NULL),(1222,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',160.00,1,1.00,'Factura C N°: 0004-00001222',NULL,'2022-10-22 12:29:56','2022-10-22 12:29:56',NULL),(1223,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',200.00,1,1.00,'Factura C N°: 0004-00001223',NULL,'2022-10-22 12:29:57','2022-10-22 12:29:57',NULL),(1224,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',150.00,1,1.00,'Factura C N°: 0004-00001224',NULL,'2022-10-22 12:29:58','2022-10-22 12:29:58',NULL),(1225,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',310.00,1,1.00,'Factura C N°: 0004-00001225',NULL,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(1226,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',120.00,1,1.00,'Factura C N°: 0004-00001226',NULL,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(1227,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',120.00,1,1.00,'Factura C N°: 0004-00001227',NULL,'2022-10-22 12:30:00','2022-10-22 12:30:00',NULL),(1228,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',100.00,1,1.00,'Factura C N°: 0004-00001228',NULL,'2022-10-22 12:30:01','2022-10-22 12:30:01',NULL),(1229,NULL,2,40720,40718,13,1584,1,0,'2022-10-20',150.00,1,1.00,'Factura C N°: 0004-00001229',NULL,'2022-10-22 12:30:03','2022-10-22 12:30:03',NULL),(1230,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',390.00,1,1.00,'Factura C N°: 0004-00001230',NULL,'2022-10-22 12:33:54','2022-10-22 12:33:54',NULL),(1231,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',1080.00,1,1.00,'Factura C N°: 0004-00001231',NULL,'2022-10-22 12:33:55','2022-10-22 12:33:55',NULL),(1232,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',270.00,1,1.00,'Factura C N°: 0004-00001232',NULL,'2022-10-22 12:33:56','2022-10-22 12:33:56',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1233,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',190.00,1,1.00,'Factura C N°: 0004-00001233',NULL,'2022-10-22 12:33:58','2022-10-22 12:33:58',NULL),(1234,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',160.00,1,1.00,'Factura C N°: 0004-00001234',NULL,'2022-10-22 12:33:58','2022-10-22 12:33:58',NULL),(1235,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',380.00,1,1.00,'Factura C N°: 0004-00001235',NULL,'2022-10-22 12:33:59','2022-10-22 12:33:59',NULL),(1236,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',390.00,1,1.00,'Factura C N°: 0004-00001236',NULL,'2022-10-22 12:34:00','2022-10-22 12:34:00',NULL),(1237,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',1210.00,1,1.00,'Factura C N°: 0004-00001237',NULL,'2022-10-22 12:34:01','2022-10-22 12:34:01',NULL),(1238,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',330.00,1,1.00,'Factura C N°: 0004-00001238',NULL,'2022-10-22 12:34:02','2022-10-22 12:34:02',NULL),(1239,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',280.00,1,1.00,'Factura C N°: 0004-00001239',NULL,'2022-10-22 12:34:03','2022-10-22 12:34:03',NULL),(1240,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',440.00,1,1.00,'Factura C N°: 0004-00001240',NULL,'2022-10-22 12:34:04','2022-10-22 12:34:04',NULL),(1241,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',250.00,1,1.00,'Factura C N°: 0004-00001241',NULL,'2022-10-22 12:34:06','2022-10-22 12:34:06',NULL),(1242,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',550.00,1,1.00,'Factura C N°: 0004-00001242',NULL,'2022-10-22 12:34:07','2022-10-22 12:34:07',NULL),(1243,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',90.00,1,1.00,'Factura C N°: 0004-00001243',NULL,'2022-10-22 12:34:08','2022-10-22 12:34:08',NULL),(1244,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',290.00,1,1.00,'Factura C N°: 0004-00001244',NULL,'2022-10-22 12:34:09','2022-10-22 12:34:09',NULL),(1245,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',130.00,1,1.00,'Factura C N°: 0004-00001245',NULL,'2022-10-22 12:34:11','2022-10-22 12:34:11',NULL),(1246,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',200.00,1,1.00,'Factura C N°: 0004-00001246',NULL,'2022-10-22 12:34:12','2022-10-22 12:34:12',NULL),(1247,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',250.00,1,1.00,'Factura C N°: 0004-00001247',NULL,'2022-10-22 12:34:14','2022-10-22 12:34:14',NULL),(1248,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',270.00,1,1.00,'Factura C N°: 0004-00001248',NULL,'2022-10-22 12:34:15','2022-10-22 12:34:15',NULL),(1249,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',280.00,1,1.00,'Factura C N°: 0004-00001249',NULL,'2022-10-22 12:34:16','2022-10-22 12:34:16',NULL),(1250,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',220.00,1,1.00,'Factura C N°: 0004-00001250',NULL,'2022-10-22 12:34:18','2022-10-22 12:34:18',NULL),(1251,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',150.00,1,1.00,'Factura C N°: 0004-00001251',NULL,'2022-10-22 12:34:19','2022-10-22 12:34:19',NULL),(1252,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',160.00,1,1.00,'Factura C N°: 0004-00001252',NULL,'2022-10-22 12:34:20','2022-10-22 12:34:20',NULL),(1253,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',200.00,1,1.00,'Factura C N°: 0004-00001253',NULL,'2022-10-22 12:34:22','2022-10-22 12:34:22',NULL),(1254,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',150.00,1,1.00,'Factura C N°: 0004-00001254',NULL,'2022-10-22 12:34:24','2022-10-22 12:34:24',NULL),(1255,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',310.00,1,1.00,'Factura C N°: 0004-00001255',NULL,'2022-10-22 12:34:25','2022-10-22 12:34:25',NULL),(1256,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',120.00,1,1.00,'Factura C N°: 0004-00001256',NULL,'2022-10-22 12:34:27','2022-10-22 12:34:27',NULL),(1257,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',120.00,1,1.00,'Factura C N°: 0004-00001257',NULL,'2022-10-22 12:34:28','2022-10-22 12:34:28',NULL),(1258,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',100.00,1,1.00,'Factura C N°: 0004-00001258',NULL,'2022-10-22 12:34:30','2022-10-22 12:34:30',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1259,NULL,2,40720,40718,13,1584,1,0,'2022-10-21',150.00,1,1.00,'Factura C N°: 0004-00001259',NULL,'2022-10-22 12:34:31','2022-10-22 12:34:31',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1260 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,7776,1,10,NULL,'2022-10-11 00:21:00','2022-10-11 00:21:00',NULL),(2,NULL,2,11,NULL,'2022-10-11 00:26:07','2022-10-11 00:26:07',NULL),(3,NULL,3,12,NULL,'2022-10-11 00:26:09','2022-10-11 00:26:09',NULL),(4,NULL,4,13,NULL,'2022-10-11 00:26:12','2022-10-11 00:26:12',NULL),(5,NULL,5,14,NULL,'2022-10-11 00:26:13','2022-10-11 00:26:13',NULL),(6,NULL,6,15,NULL,'2022-10-11 00:26:16','2022-10-11 00:26:16',NULL),(7,NULL,7,16,NULL,'2022-10-11 00:26:18','2022-10-11 00:26:18',NULL),(8,NULL,8,17,NULL,'2022-10-11 00:26:20','2022-10-11 00:26:20',NULL),(9,NULL,9,18,NULL,'2022-10-11 00:26:21','2022-10-11 00:26:21',NULL),(10,NULL,10,19,NULL,'2022-10-11 00:26:23','2022-10-11 00:26:23',NULL),(11,NULL,11,20,NULL,'2022-10-11 00:26:24','2022-10-11 00:26:24',NULL),(12,NULL,12,21,NULL,'2022-10-11 00:26:26','2022-10-11 00:26:26',NULL),(13,NULL,13,22,NULL,'2022-10-11 00:26:28','2022-10-11 00:26:28',NULL),(14,NULL,14,23,NULL,'2022-10-11 00:26:31','2022-10-11 00:26:31',NULL),(15,NULL,15,24,NULL,'2022-10-11 00:26:33','2022-10-11 00:26:33',NULL),(16,NULL,16,25,NULL,'2022-10-11 00:26:34','2022-10-11 00:26:34',NULL),(17,NULL,17,26,NULL,'2022-10-11 00:26:36','2022-10-11 00:26:36',NULL),(18,NULL,18,27,NULL,'2022-10-11 00:26:38','2022-10-11 00:26:38',NULL),(19,NULL,19,28,NULL,'2022-10-11 00:26:39','2022-10-11 00:26:39',NULL),(20,NULL,20,29,NULL,'2022-10-11 00:26:41','2022-10-11 00:26:41',NULL),(21,NULL,21,30,NULL,'2022-10-11 00:26:44','2022-10-11 00:26:44',NULL),(22,NULL,22,31,NULL,'2022-10-11 00:26:46','2022-10-11 00:26:46',NULL),(23,NULL,23,32,NULL,'2022-10-11 00:26:48','2022-10-11 00:26:48',NULL),(24,NULL,24,33,NULL,'2022-10-11 00:26:49','2022-10-11 00:26:49',NULL),(25,NULL,25,34,NULL,'2022-10-11 00:26:51','2022-10-11 00:26:51',NULL),(26,NULL,26,35,NULL,'2022-10-11 00:26:53','2022-10-11 00:26:53',NULL),(27,NULL,27,36,NULL,'2022-10-11 00:26:55','2022-10-11 00:26:55',NULL),(28,NULL,28,37,NULL,'2022-10-11 00:26:58','2022-10-11 00:26:58',NULL),(29,NULL,29,38,NULL,'2022-10-11 00:27:00','2022-10-11 00:27:00',NULL),(30,NULL,30,39,NULL,'2022-10-11 00:27:02','2022-10-11 00:27:02',NULL),(31,NULL,31,40,NULL,'2022-10-11 00:27:04','2022-10-11 00:27:04',NULL),(32,NULL,32,41,NULL,'2022-10-11 00:27:05','2022-10-11 00:27:05',NULL),(33,NULL,33,42,NULL,'2022-10-11 00:27:07','2022-10-11 00:27:07',NULL),(34,NULL,34,43,NULL,'2022-10-11 00:27:10','2022-10-11 00:27:10',NULL),(35,NULL,35,44,NULL,'2022-10-11 00:27:13','2022-10-11 00:27:13',NULL),(36,NULL,36,45,NULL,'2022-10-11 00:27:14','2022-10-11 00:27:14',NULL),(37,NULL,37,46,NULL,'2022-10-11 00:27:16','2022-10-11 00:27:16',NULL),(38,NULL,38,47,NULL,'2022-10-11 00:27:18','2022-10-11 00:27:18',NULL),(39,NULL,39,48,NULL,'2022-10-11 00:27:20','2022-10-11 00:27:20',NULL),(40,NULL,40,49,NULL,'2022-10-11 00:27:21','2022-10-11 00:27:21',NULL),(41,NULL,41,50,NULL,'2022-10-11 00:27:24','2022-10-11 00:27:24',NULL),(42,NULL,42,51,NULL,'2022-10-11 00:27:27','2022-10-11 00:27:27',NULL),(43,NULL,43,52,NULL,'2022-10-11 00:27:28','2022-10-11 00:27:28',NULL),(44,NULL,44,53,NULL,'2022-10-11 00:27:30','2022-10-11 00:27:30',NULL),(45,NULL,45,54,NULL,'2022-10-11 00:27:32','2022-10-11 00:27:32',NULL),(46,NULL,46,55,NULL,'2022-10-11 00:27:33','2022-10-11 00:27:33',NULL),(47,NULL,47,56,NULL,'2022-10-11 00:27:35','2022-10-11 00:27:35',NULL),(48,NULL,48,57,NULL,'2022-10-11 00:27:38','2022-10-11 00:27:38',NULL),(49,NULL,49,58,NULL,'2022-10-11 00:27:41','2022-10-11 00:27:41',NULL),(50,NULL,50,59,NULL,'2022-10-11 00:27:42','2022-10-11 00:27:42',NULL),(51,NULL,51,60,NULL,'2022-10-11 00:27:44','2022-10-11 00:27:44',NULL),(52,NULL,52,61,NULL,'2022-10-11 00:27:46','2022-10-11 00:27:46',NULL),(53,NULL,53,62,NULL,'2022-10-11 00:27:47','2022-10-11 00:27:47',NULL),(54,NULL,54,63,NULL,'2022-10-11 00:27:49','2022-10-11 00:27:49',NULL),(55,NULL,55,64,NULL,'2022-10-11 00:27:52','2022-10-11 00:27:52',NULL),(56,NULL,56,65,NULL,'2022-10-11 00:27:55','2022-10-11 00:27:55',NULL),(57,NULL,57,66,NULL,'2022-10-11 00:27:56','2022-10-11 00:27:56',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (58,NULL,58,67,NULL,'2022-10-11 00:27:58','2022-10-11 00:27:58',NULL),(59,NULL,59,68,NULL,'2022-10-11 00:28:00','2022-10-11 00:28:00',NULL),(60,NULL,60,69,NULL,'2022-10-11 00:28:02','2022-10-11 00:28:02',NULL),(61,NULL,61,70,NULL,'2022-10-11 00:28:03','2022-10-11 00:28:03',NULL),(62,NULL,62,71,NULL,'2022-10-11 00:28:06','2022-10-11 00:28:06',NULL),(63,NULL,63,72,NULL,'2022-10-11 00:28:08','2022-10-11 00:28:08',NULL),(64,NULL,64,73,NULL,'2022-10-11 00:28:10','2022-10-11 00:28:10',NULL),(65,NULL,65,74,NULL,'2022-10-11 00:28:11','2022-10-11 00:28:11',NULL),(66,NULL,66,75,NULL,'2022-10-11 00:28:13','2022-10-11 00:28:13',NULL),(67,NULL,67,76,NULL,'2022-10-11 00:28:15','2022-10-11 00:28:15',NULL),(68,NULL,68,77,NULL,'2022-10-11 00:28:16','2022-10-11 00:28:16',NULL),(69,NULL,69,78,NULL,'2022-10-11 00:28:19','2022-10-11 00:28:19',NULL),(70,NULL,70,79,NULL,'2022-10-11 00:28:22','2022-10-11 00:28:22',NULL),(71,NULL,71,80,NULL,'2022-10-11 00:28:23','2022-10-11 00:28:23',NULL),(72,NULL,72,81,NULL,'2022-10-11 00:28:25','2022-10-11 00:28:25',NULL),(73,NULL,73,82,NULL,'2022-10-11 00:28:27','2022-10-11 00:28:27',NULL),(74,NULL,74,83,NULL,'2022-10-11 00:28:28','2022-10-11 00:28:28',NULL),(75,NULL,75,84,NULL,'2022-10-11 00:28:30','2022-10-11 00:28:30',NULL),(76,NULL,76,85,NULL,'2022-10-11 00:28:33','2022-10-11 00:28:33',NULL),(77,NULL,77,86,NULL,'2022-10-11 00:28:35','2022-10-11 00:28:35',NULL),(78,NULL,78,87,NULL,'2022-10-11 00:28:37','2022-10-11 00:28:37',NULL),(79,NULL,79,88,NULL,'2022-10-11 00:28:39','2022-10-11 00:28:39',NULL),(80,NULL,80,89,NULL,'2022-10-11 00:28:40','2022-10-11 00:28:40',NULL),(81,NULL,81,90,NULL,'2022-10-11 00:28:42','2022-10-11 00:28:42',NULL),(82,NULL,82,91,NULL,'2022-10-11 00:28:44','2022-10-11 00:28:44',NULL),(83,NULL,83,92,NULL,'2022-10-11 00:28:48','2022-10-11 00:28:48',NULL),(84,NULL,84,93,NULL,'2022-10-11 00:28:49','2022-10-11 00:28:49',NULL),(85,NULL,85,94,NULL,'2022-10-11 00:28:51','2022-10-11 00:28:51',NULL),(86,NULL,86,95,NULL,'2022-10-11 00:28:53','2022-10-11 00:28:53',NULL),(87,NULL,87,96,NULL,'2022-10-11 00:28:55','2022-10-11 00:28:55',NULL),(88,NULL,88,97,NULL,'2022-10-11 00:28:56','2022-10-11 00:28:56',NULL),(89,NULL,89,98,NULL,'2022-10-11 00:28:59','2022-10-11 00:28:59',NULL),(90,NULL,90,99,NULL,'2022-10-11 00:29:01','2022-10-11 00:29:01',NULL),(91,NULL,91,100,NULL,'2022-10-11 00:29:03','2022-10-11 00:29:03',NULL),(92,NULL,92,101,NULL,'2022-10-11 00:29:05','2022-10-11 00:29:05',NULL),(93,NULL,93,102,NULL,'2022-10-11 00:29:07','2022-10-11 00:29:07',NULL),(94,NULL,94,103,NULL,'2022-10-11 00:29:09','2022-10-11 00:29:09',NULL),(95,NULL,95,104,NULL,'2022-10-11 00:29:10','2022-10-11 00:29:10',NULL),(96,NULL,96,105,NULL,'2022-10-11 00:29:13','2022-10-11 00:29:13',NULL),(97,NULL,97,106,NULL,'2022-10-11 00:29:15','2022-10-11 00:29:15',NULL),(98,NULL,98,107,NULL,'2022-10-11 00:29:17','2022-10-11 00:29:17',NULL),(99,NULL,99,108,NULL,'2022-10-11 00:29:18','2022-10-11 00:29:18',NULL),(100,NULL,100,109,NULL,'2022-10-11 00:29:20','2022-10-11 00:29:20',NULL),(101,NULL,101,110,NULL,'2022-10-11 00:29:22','2022-10-11 00:29:22',NULL),(102,NULL,102,111,NULL,'2022-10-11 00:29:24','2022-10-11 00:29:24',NULL),(103,NULL,103,112,NULL,'2022-10-11 00:29:27','2022-10-11 00:29:27',NULL),(104,NULL,104,113,NULL,'2022-10-11 00:29:29','2022-10-11 00:29:29',NULL),(105,NULL,105,114,NULL,'2022-10-11 00:29:31','2022-10-11 00:29:31',NULL),(106,NULL,106,115,NULL,'2022-10-11 00:29:32','2022-10-11 00:29:32',NULL),(107,NULL,107,116,NULL,'2022-10-11 00:29:34','2022-10-11 00:29:34',NULL),(108,NULL,108,117,NULL,'2022-10-11 00:29:36','2022-10-11 00:29:36',NULL),(109,NULL,109,118,NULL,'2022-10-11 00:29:38','2022-10-11 00:29:38',NULL),(110,NULL,110,119,NULL,'2022-10-11 00:29:40','2022-10-11 00:29:40',NULL),(111,NULL,111,120,NULL,'2022-10-11 00:29:42','2022-10-11 00:29:42',NULL),(112,NULL,112,121,NULL,'2022-10-11 00:29:44','2022-10-11 00:29:44',NULL),(113,NULL,113,122,NULL,'2022-10-11 00:29:45','2022-10-11 00:29:45',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (114,NULL,114,123,NULL,'2022-10-11 00:29:47','2022-10-11 00:29:47',NULL),(115,NULL,115,124,NULL,'2022-10-11 00:29:49','2022-10-11 00:29:49',NULL),(116,NULL,116,125,NULL,'2022-10-11 00:29:51','2022-10-11 00:29:51',NULL),(117,NULL,117,126,NULL,'2022-10-11 00:29:54','2022-10-11 00:29:54',NULL),(118,NULL,118,127,NULL,'2022-10-11 00:29:55','2022-10-11 00:29:55',NULL),(119,NULL,119,128,NULL,'2022-10-11 00:29:57','2022-10-11 00:29:57',NULL),(120,NULL,120,129,NULL,'2022-10-11 00:29:59','2022-10-11 00:29:59',NULL),(121,NULL,121,130,NULL,'2022-10-11 00:30:01','2022-10-11 00:30:01',NULL),(122,NULL,122,131,NULL,'2022-10-11 00:30:03','2022-10-11 00:30:03',NULL),(123,NULL,123,132,NULL,'2022-10-11 00:30:06','2022-10-11 00:30:06',NULL),(124,NULL,124,133,NULL,'2022-10-11 00:30:08','2022-10-11 00:30:08',NULL),(125,NULL,125,134,NULL,'2022-10-11 00:30:09','2022-10-11 00:30:09',NULL),(126,NULL,126,135,NULL,'2022-10-11 00:30:11','2022-10-11 00:30:11',NULL),(127,NULL,127,136,NULL,'2022-10-11 00:30:13','2022-10-11 00:30:13',NULL),(128,NULL,128,137,NULL,'2022-10-11 00:30:15','2022-10-11 00:30:15',NULL),(129,NULL,129,138,NULL,'2022-10-11 00:30:19','2022-10-11 00:30:19',NULL),(130,NULL,130,139,NULL,'2022-10-11 00:30:21','2022-10-11 00:30:21',NULL),(131,NULL,131,140,NULL,'2022-10-11 00:30:22','2022-10-11 00:30:22',NULL),(132,NULL,132,141,NULL,'2022-10-11 00:30:24','2022-10-11 00:30:24',NULL),(133,NULL,133,142,NULL,'2022-10-11 00:30:26','2022-10-11 00:30:26',NULL),(134,NULL,134,143,NULL,'2022-10-11 00:30:28','2022-10-11 00:30:28',NULL),(135,NULL,135,144,NULL,'2022-10-11 00:30:30','2022-10-11 00:30:30',NULL),(136,NULL,136,145,NULL,'2022-10-11 00:30:33','2022-10-11 00:30:33',NULL),(137,NULL,137,146,NULL,'2022-10-11 00:30:35','2022-10-11 00:30:35',NULL),(138,NULL,138,147,NULL,'2022-10-11 00:30:37','2022-10-11 00:30:37',NULL),(139,NULL,139,148,NULL,'2022-10-11 00:30:39','2022-10-11 00:30:39',NULL),(140,NULL,140,149,NULL,'2022-10-11 00:30:41','2022-10-11 00:30:41',NULL),(141,NULL,141,150,NULL,'2022-10-11 00:30:42','2022-10-11 00:30:42',NULL),(142,NULL,142,151,NULL,'2022-10-11 00:30:46','2022-10-11 00:30:46',NULL),(143,NULL,143,152,NULL,'2022-10-11 00:30:48','2022-10-11 00:30:48',NULL),(144,NULL,144,153,NULL,'2022-10-11 00:30:50','2022-10-11 00:30:50',NULL),(145,NULL,145,154,NULL,'2022-10-11 00:30:52','2022-10-11 00:30:52',NULL),(146,NULL,146,155,NULL,'2022-10-11 00:30:53','2022-10-11 00:30:53',NULL),(147,NULL,147,156,NULL,'2022-10-11 00:30:55','2022-10-11 00:30:55',NULL),(148,NULL,148,157,NULL,'2022-10-11 00:30:57','2022-10-11 00:30:57',NULL),(149,NULL,149,158,NULL,'2022-10-11 00:31:01','2022-10-11 00:31:01',NULL),(150,NULL,150,159,NULL,'2022-10-11 00:31:03','2022-10-11 00:31:03',NULL),(151,NULL,151,160,NULL,'2022-10-11 00:31:05','2022-10-11 00:31:05',NULL),(152,NULL,152,161,NULL,'2022-10-11 00:31:07','2022-10-11 00:31:07',NULL),(153,NULL,153,162,NULL,'2022-10-11 00:31:09','2022-10-11 00:31:09',NULL),(154,NULL,154,163,NULL,'2022-10-11 00:31:11','2022-10-11 00:31:11',NULL),(155,NULL,155,164,NULL,'2022-10-11 00:31:15','2022-10-11 00:31:15',NULL),(156,NULL,156,165,NULL,'2022-10-11 00:31:17','2022-10-11 00:31:17',NULL),(157,NULL,157,166,NULL,'2022-10-11 00:31:19','2022-10-11 00:31:19',NULL),(158,NULL,158,167,NULL,'2022-10-11 00:31:21','2022-10-11 00:31:21',NULL),(159,NULL,159,168,NULL,'2022-10-11 00:31:23','2022-10-11 00:31:23',NULL),(160,NULL,160,169,NULL,'2022-10-11 00:31:25','2022-10-11 00:31:25',NULL),(161,NULL,161,170,NULL,'2022-10-11 00:31:28','2022-10-11 00:31:28',NULL),(162,NULL,162,171,NULL,'2022-10-11 00:31:30','2022-10-11 00:31:30',NULL),(163,NULL,163,172,NULL,'2022-10-11 00:31:32','2022-10-11 00:31:32',NULL),(164,NULL,164,173,NULL,'2022-10-11 00:31:34','2022-10-11 00:31:34',NULL),(165,NULL,165,174,NULL,'2022-10-11 00:31:35','2022-10-11 00:31:35',NULL),(166,NULL,166,175,NULL,'2022-10-11 00:31:37','2022-10-11 00:31:37',NULL),(167,NULL,167,176,NULL,'2022-10-11 00:31:39','2022-10-11 00:31:39',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (168,NULL,168,177,NULL,'2022-10-11 00:31:42','2022-10-11 00:31:42',NULL),(169,NULL,169,178,NULL,'2022-10-11 00:31:44','2022-10-11 00:31:44',NULL),(170,NULL,170,179,NULL,'2022-10-11 00:31:46','2022-10-11 00:31:46',NULL),(171,NULL,171,180,NULL,'2022-10-11 00:31:48','2022-10-11 00:31:48',NULL),(172,NULL,172,181,NULL,'2022-10-11 00:31:50','2022-10-11 00:31:50',NULL),(173,NULL,173,182,NULL,'2022-10-11 00:31:52','2022-10-11 00:31:52',NULL),(174,NULL,174,183,NULL,'2022-10-11 00:31:54','2022-10-11 00:31:54',NULL),(175,NULL,175,184,NULL,'2022-10-11 00:31:56','2022-10-11 00:31:56',NULL),(176,NULL,176,185,NULL,'2022-10-11 00:31:58','2022-10-11 00:31:58',NULL),(177,NULL,177,186,NULL,'2022-10-11 00:32:00','2022-10-11 00:32:00',NULL),(178,NULL,178,187,NULL,'2022-10-11 00:32:02','2022-10-11 00:32:02',NULL),(179,NULL,179,188,NULL,'2022-10-11 00:32:05','2022-10-11 00:32:05',NULL),(180,NULL,180,189,NULL,'2022-10-11 00:32:07','2022-10-11 00:32:07',NULL),(181,NULL,181,190,NULL,'2022-10-11 00:32:09','2022-10-11 00:32:09',NULL),(182,NULL,182,191,NULL,'2022-10-11 00:32:11','2022-10-11 00:32:11',NULL),(183,NULL,183,192,NULL,'2022-10-11 00:32:13','2022-10-11 00:32:13',NULL),(184,NULL,184,193,NULL,'2022-10-11 00:32:15','2022-10-11 00:32:15',NULL),(185,NULL,185,194,NULL,'2022-10-11 00:32:17','2022-10-11 00:32:17',NULL),(186,NULL,186,195,NULL,'2022-10-11 00:32:20','2022-10-11 00:32:20',NULL),(187,NULL,187,196,NULL,'2022-10-11 00:32:22','2022-10-11 00:32:22',NULL),(188,NULL,188,197,NULL,'2022-10-11 00:32:24','2022-10-11 00:32:24',NULL),(189,NULL,189,198,NULL,'2022-10-11 00:32:25','2022-10-11 00:32:25',NULL),(190,NULL,190,199,NULL,'2022-10-11 00:32:28','2022-10-11 00:32:28',NULL),(191,NULL,191,200,NULL,'2022-10-11 00:32:29','2022-10-11 00:32:29',NULL),(192,NULL,192,201,NULL,'2022-10-11 00:32:33','2022-10-11 00:32:33',NULL),(193,NULL,193,202,NULL,'2022-10-11 00:32:35','2022-10-11 00:32:35',NULL),(194,NULL,194,203,NULL,'2022-10-11 00:32:37','2022-10-11 00:32:37',NULL),(195,NULL,195,204,NULL,'2022-10-11 00:32:39','2022-10-11 00:32:39',NULL),(196,NULL,196,205,NULL,'2022-10-11 00:32:41','2022-10-11 00:32:41',NULL),(197,NULL,197,206,NULL,'2022-10-11 00:32:43','2022-10-11 00:32:43',NULL),(198,NULL,198,207,NULL,'2022-10-11 00:32:45','2022-10-11 00:32:45',NULL),(199,NULL,199,208,NULL,'2022-10-11 00:32:47','2022-10-11 00:32:47',NULL),(200,NULL,200,209,NULL,'2022-10-11 00:32:49','2022-10-11 00:32:49',NULL),(201,NULL,201,210,NULL,'2022-10-11 00:32:51','2022-10-11 00:32:51',NULL),(202,NULL,202,211,NULL,'2022-10-11 00:32:53','2022-10-11 00:32:53',NULL),(203,NULL,203,212,NULL,'2022-10-11 00:32:55','2022-10-11 00:32:55',NULL),(204,NULL,204,213,NULL,'2022-10-11 00:32:58','2022-10-11 00:32:58',NULL),(205,NULL,205,214,NULL,'2022-10-11 00:33:00','2022-10-11 00:33:00',NULL),(206,NULL,206,215,NULL,'2022-10-11 00:33:02','2022-10-11 00:33:02',NULL),(207,NULL,207,216,NULL,'2022-10-11 00:33:04','2022-10-11 00:33:04',NULL),(208,NULL,208,217,NULL,'2022-10-11 00:33:06','2022-10-11 00:33:06',NULL),(209,NULL,209,218,NULL,'2022-10-11 00:33:08','2022-10-11 00:33:08',NULL),(210,NULL,210,219,NULL,'2022-10-11 00:33:11','2022-10-11 00:33:11',NULL),(211,NULL,211,220,NULL,'2022-10-11 00:33:13','2022-10-11 00:33:13',NULL),(212,NULL,212,221,NULL,'2022-10-11 00:33:15','2022-10-11 00:33:15',NULL),(213,NULL,213,222,NULL,'2022-10-11 00:33:17','2022-10-11 00:33:17',NULL),(214,NULL,214,223,NULL,'2022-10-11 00:33:19','2022-10-11 00:33:19',NULL),(215,NULL,215,224,NULL,'2022-10-11 00:33:21','2022-10-11 00:33:21',NULL),(216,NULL,216,225,NULL,'2022-10-11 00:33:23','2022-10-11 00:33:23',NULL),(217,NULL,217,226,NULL,'2022-10-11 00:33:25','2022-10-11 00:33:25',NULL),(218,NULL,218,227,NULL,'2022-10-11 00:33:27','2022-10-11 00:33:27',NULL),(219,NULL,219,228,NULL,'2022-10-11 00:33:29','2022-10-11 00:33:29',NULL),(220,NULL,220,229,NULL,'2022-10-11 00:33:31','2022-10-11 00:33:31',NULL),(221,NULL,221,230,NULL,'2022-10-11 00:33:34','2022-10-11 00:33:34',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (222,NULL,222,231,NULL,'2022-10-11 00:33:36','2022-10-11 00:33:36',NULL),(223,NULL,223,232,NULL,'2022-10-11 00:33:38','2022-10-11 00:33:38',NULL),(224,NULL,224,233,NULL,'2022-10-11 00:33:40','2022-10-11 00:33:40',NULL),(225,NULL,225,234,NULL,'2022-10-11 00:33:42','2022-10-11 00:33:42',NULL),(226,NULL,226,235,NULL,'2022-10-11 00:33:45','2022-10-11 00:33:45',NULL),(227,NULL,227,236,NULL,'2022-10-11 00:33:47','2022-10-11 00:33:47',NULL),(228,NULL,228,237,NULL,'2022-10-11 00:33:49','2022-10-11 00:33:49',NULL),(229,NULL,229,238,NULL,'2022-10-11 00:33:51','2022-10-11 00:33:51',NULL),(230,NULL,230,239,NULL,'2022-10-11 00:33:53','2022-10-11 00:33:53',NULL),(231,NULL,231,240,NULL,'2022-10-11 00:33:55','2022-10-11 00:33:55',NULL),(232,NULL,232,241,NULL,'2022-10-11 00:33:57','2022-10-11 00:33:57',NULL),(233,NULL,233,242,NULL,'2022-10-11 00:34:00','2022-10-11 00:34:00',NULL),(234,NULL,234,243,NULL,'2022-10-11 00:34:02','2022-10-11 00:34:02',NULL),(235,NULL,235,244,NULL,'2022-10-11 00:34:04','2022-10-11 00:34:04',NULL),(236,NULL,236,245,NULL,'2022-10-11 00:34:06','2022-10-11 00:34:06',NULL),(237,NULL,237,246,NULL,'2022-10-11 00:34:08','2022-10-11 00:34:08',NULL),(238,NULL,238,247,NULL,'2022-10-11 00:34:11','2022-10-11 00:34:11',NULL),(239,NULL,239,248,NULL,'2022-10-11 00:34:13','2022-10-11 00:34:13',NULL),(240,NULL,240,249,NULL,'2022-10-11 00:34:15','2022-10-11 00:34:15',NULL),(241,NULL,241,250,NULL,'2022-10-11 00:34:17','2022-10-11 00:34:17',NULL),(242,NULL,242,251,NULL,'2022-10-11 00:34:19','2022-10-11 00:34:19',NULL),(243,NULL,243,252,NULL,'2022-10-11 00:34:21','2022-10-11 00:34:21',NULL),(244,NULL,244,253,NULL,'2022-10-11 00:34:23','2022-10-11 00:34:23',NULL),(245,NULL,245,254,NULL,'2022-10-11 00:34:26','2022-10-11 00:34:26',NULL),(246,NULL,246,255,NULL,'2022-10-11 00:34:28','2022-10-11 00:34:28',NULL),(247,NULL,247,256,NULL,'2022-10-11 00:34:30','2022-10-11 00:34:30',NULL),(248,NULL,248,257,NULL,'2022-10-11 00:34:32','2022-10-11 00:34:32',NULL),(249,NULL,249,258,NULL,'2022-10-11 00:34:34','2022-10-11 00:34:34',NULL),(250,NULL,250,259,NULL,'2022-10-11 00:34:36','2022-10-11 00:34:36',NULL),(251,NULL,251,260,NULL,'2022-10-11 00:34:38','2022-10-11 00:34:38',NULL),(252,NULL,252,261,NULL,'2022-10-11 00:34:41','2022-10-11 00:34:41',NULL),(253,NULL,253,262,NULL,'2022-10-11 00:34:43','2022-10-11 00:34:43',NULL),(254,NULL,254,263,NULL,'2022-10-11 00:34:45','2022-10-11 00:34:45',NULL),(255,NULL,255,264,NULL,'2022-10-11 00:34:48','2022-10-11 00:34:48',NULL),(256,NULL,256,265,NULL,'2022-10-11 00:34:50','2022-10-11 00:34:50',NULL),(257,NULL,257,266,NULL,'2022-10-11 00:34:52','2022-10-11 00:34:52',NULL),(258,NULL,258,267,NULL,'2022-10-11 00:34:54','2022-10-11 00:34:54',NULL),(259,NULL,259,268,NULL,'2022-10-11 00:34:56','2022-10-11 00:34:56',NULL),(260,NULL,260,269,NULL,'2022-10-11 00:34:58','2022-10-11 00:34:58',NULL),(261,NULL,261,270,NULL,'2022-10-11 00:35:00','2022-10-11 00:35:00',NULL),(262,NULL,262,271,NULL,'2022-10-11 00:35:03','2022-10-11 00:35:03',NULL),(263,NULL,263,272,NULL,'2022-10-11 00:35:05','2022-10-11 00:35:05',NULL),(264,NULL,264,273,NULL,'2022-10-11 00:35:07','2022-10-11 00:35:07',NULL),(265,NULL,265,274,NULL,'2022-10-11 00:35:10','2022-10-11 00:35:10',NULL),(266,NULL,266,275,NULL,'2022-10-11 00:35:12','2022-10-11 00:35:12',NULL),(267,NULL,267,276,NULL,'2022-10-11 00:35:14','2022-10-11 00:35:14',NULL),(268,NULL,268,277,NULL,'2022-10-11 00:35:16','2022-10-11 00:35:16',NULL),(269,NULL,269,278,NULL,'2022-10-11 00:35:18','2022-10-11 00:35:18',NULL),(270,NULL,270,279,NULL,'2022-10-11 00:35:21','2022-10-11 00:35:21',NULL),(271,NULL,271,280,NULL,'2022-10-11 00:35:23','2022-10-11 00:35:23',NULL),(272,NULL,272,281,NULL,'2022-10-11 00:35:25','2022-10-11 00:35:25',NULL),(273,NULL,273,282,NULL,'2022-10-11 00:35:27','2022-10-11 00:35:27',NULL),(274,NULL,274,283,NULL,'2022-10-11 00:35:29','2022-10-11 00:35:29',NULL),(275,NULL,275,284,NULL,'2022-10-11 00:35:31','2022-10-11 00:35:31',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (276,NULL,276,285,NULL,'2022-10-11 00:35:35','2022-10-11 00:35:35',NULL),(277,NULL,277,286,NULL,'2022-10-11 00:35:37','2022-10-11 00:35:37',NULL),(278,NULL,278,287,NULL,'2022-10-11 00:35:39','2022-10-11 00:35:39',NULL),(279,NULL,279,288,NULL,'2022-10-11 00:35:41','2022-10-11 00:35:41',NULL),(280,NULL,280,289,NULL,'2022-10-11 00:35:43','2022-10-11 00:35:43',NULL),(281,NULL,281,290,NULL,'2022-10-11 00:35:45','2022-10-11 00:35:45',NULL),(282,NULL,282,291,NULL,'2022-10-11 00:35:48','2022-10-11 00:35:48',NULL),(283,NULL,283,292,NULL,'2022-10-11 00:35:50','2022-10-11 00:35:50',NULL),(284,NULL,284,293,NULL,'2022-10-11 00:35:52','2022-10-11 00:35:52',NULL),(285,NULL,285,294,NULL,'2022-10-11 00:35:54','2022-10-11 00:35:54',NULL),(286,NULL,286,295,NULL,'2022-10-11 00:35:56','2022-10-11 00:35:56',NULL),(287,NULL,287,296,NULL,'2022-10-11 00:35:59','2022-10-11 00:35:59',NULL),(288,NULL,288,297,NULL,'2022-10-11 00:36:01','2022-10-11 00:36:01',NULL),(289,NULL,289,298,NULL,'2022-10-11 00:36:04','2022-10-11 00:36:04',NULL),(290,NULL,290,299,NULL,'2022-10-11 00:36:06','2022-10-11 00:36:06',NULL),(291,NULL,291,300,NULL,'2022-10-11 00:36:08','2022-10-11 00:36:08',NULL),(292,NULL,292,301,NULL,'2022-10-11 00:36:10','2022-10-11 00:36:10',NULL),(293,NULL,293,302,NULL,'2022-10-11 00:36:13','2022-10-11 00:36:13',NULL),(294,NULL,294,303,NULL,'2022-10-11 00:36:15','2022-10-11 00:36:15',NULL),(295,NULL,295,304,NULL,'2022-10-11 00:36:17','2022-10-11 00:36:17',NULL),(296,NULL,296,305,NULL,'2022-10-11 00:36:19','2022-10-11 00:36:19',NULL),(297,NULL,297,306,NULL,'2022-10-11 00:36:21','2022-10-11 00:36:21',NULL),(298,NULL,298,307,NULL,'2022-10-11 00:36:24','2022-10-11 00:36:24',NULL),(299,NULL,299,308,NULL,'2022-10-11 00:36:26','2022-10-11 00:36:26',NULL),(300,NULL,300,309,NULL,'2022-10-11 00:36:29','2022-10-11 00:36:29',NULL),(301,NULL,301,310,NULL,'2022-10-11 00:36:31','2022-10-11 00:36:31',NULL),(302,NULL,302,311,NULL,'2022-10-11 00:36:33','2022-10-11 00:36:33',NULL),(303,NULL,303,312,NULL,'2022-10-11 00:36:35','2022-10-11 00:36:35',NULL),(304,NULL,304,313,NULL,'2022-10-11 00:36:37','2022-10-11 00:36:37',NULL),(305,NULL,305,314,NULL,'2022-10-11 00:36:40','2022-10-11 00:36:40',NULL),(306,NULL,306,315,NULL,'2022-10-11 00:36:42','2022-10-11 00:36:42',NULL),(307,NULL,307,316,NULL,'2022-10-11 00:36:44','2022-10-11 00:36:44',NULL),(308,NULL,308,317,NULL,'2022-10-11 00:36:46','2022-10-11 00:36:46',NULL),(309,NULL,309,318,NULL,'2022-10-11 00:36:48','2022-10-11 00:36:48',NULL),(310,NULL,310,319,NULL,'2022-10-11 00:36:50','2022-10-11 00:36:50',NULL),(311,NULL,311,320,NULL,'2022-10-11 00:36:52','2022-10-11 00:36:52',NULL),(312,NULL,312,321,NULL,'2022-10-11 00:36:54','2022-10-11 00:36:54',NULL),(313,NULL,313,322,NULL,'2022-10-11 00:36:57','2022-10-11 00:36:57',NULL),(314,NULL,314,323,NULL,'2022-10-11 00:36:59','2022-10-11 00:36:59',NULL),(315,NULL,315,324,NULL,'2022-10-11 00:37:02','2022-10-11 00:37:02',NULL),(316,NULL,316,325,NULL,'2022-10-11 00:37:04','2022-10-11 00:37:04',NULL),(317,NULL,317,326,NULL,'2022-10-11 00:37:06','2022-10-11 00:37:06',NULL),(318,NULL,318,327,NULL,'2022-10-11 00:45:14','2022-10-11 00:45:14',NULL),(319,NULL,319,328,NULL,'2022-10-11 00:45:16','2022-10-11 00:45:16',NULL),(320,NULL,320,329,NULL,'2022-10-11 00:45:18','2022-10-11 00:45:18',NULL),(321,NULL,321,330,NULL,'2022-10-11 00:45:20','2022-10-11 00:45:20',NULL),(322,NULL,322,331,NULL,'2022-10-11 00:45:23','2022-10-11 00:45:23',NULL),(323,NULL,323,332,NULL,'2022-10-11 00:45:25','2022-10-11 00:45:25',NULL),(324,NULL,324,333,NULL,'2022-10-11 00:45:27','2022-10-11 00:45:27',NULL),(325,NULL,325,334,NULL,'2022-10-11 00:45:29','2022-10-11 00:45:29',NULL),(326,NULL,326,335,NULL,'2022-10-11 00:45:31','2022-10-11 00:45:31',NULL),(327,NULL,327,336,NULL,'2022-10-11 00:45:33','2022-10-11 00:45:33',NULL),(328,NULL,328,337,NULL,'2022-10-11 00:45:36','2022-10-11 00:45:36',NULL),(329,NULL,329,338,NULL,'2022-10-11 00:45:38','2022-10-11 00:45:38',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (330,NULL,330,339,NULL,'2022-10-11 00:45:40','2022-10-11 00:45:40',NULL),(331,NULL,331,340,NULL,'2022-10-11 00:45:42','2022-10-11 00:45:42',NULL),(332,NULL,332,341,NULL,'2022-10-11 00:45:44','2022-10-11 00:45:44',NULL),(333,NULL,333,342,NULL,'2022-10-11 00:45:46','2022-10-11 00:45:46',NULL),(334,NULL,334,343,NULL,'2022-10-11 00:45:48','2022-10-11 00:45:48',NULL),(335,NULL,335,344,NULL,'2022-10-11 00:45:51','2022-10-11 00:45:51',NULL),(336,NULL,336,345,NULL,'2022-10-11 00:45:53','2022-10-11 00:45:53',NULL),(337,NULL,337,346,NULL,'2022-10-11 00:45:55','2022-10-11 00:45:55',NULL),(338,NULL,338,347,NULL,'2022-10-11 00:45:57','2022-10-11 00:45:57',NULL),(339,NULL,339,348,NULL,'2022-10-11 00:46:00','2022-10-11 00:46:00',NULL),(340,NULL,340,349,NULL,'2022-10-11 00:46:02','2022-10-11 00:46:02',NULL),(341,NULL,341,350,NULL,'2022-10-11 00:46:05','2022-10-11 00:46:05',NULL),(342,NULL,342,351,NULL,'2022-10-11 00:46:07','2022-10-11 00:46:07',NULL),(343,NULL,343,352,NULL,'2022-10-11 00:46:09','2022-10-11 00:46:09',NULL),(344,NULL,344,353,NULL,'2022-10-11 00:46:11','2022-10-11 00:46:11',NULL),(345,NULL,345,354,NULL,'2022-10-11 00:46:13','2022-10-11 00:46:13',NULL),(346,NULL,346,355,NULL,'2022-10-11 00:46:16','2022-10-11 00:46:16',NULL),(347,NULL,347,356,NULL,'2022-10-11 00:46:18','2022-10-11 00:46:18',NULL),(348,NULL,348,357,NULL,'2022-10-11 00:46:20','2022-10-11 00:46:20',NULL),(349,NULL,349,358,NULL,'2022-10-11 00:46:23','2022-10-11 00:46:23',NULL),(350,NULL,350,359,NULL,'2022-10-11 00:46:25','2022-10-11 00:46:25',NULL),(351,NULL,351,360,NULL,'2022-10-11 00:46:27','2022-10-11 00:46:27',NULL),(352,NULL,352,361,NULL,'2022-10-11 00:46:29','2022-10-11 00:46:29',NULL),(353,NULL,353,362,NULL,'2022-10-11 00:46:32','2022-10-11 00:46:32',NULL),(354,NULL,354,363,NULL,'2022-10-11 00:46:34','2022-10-11 00:46:34',NULL),(355,NULL,355,364,NULL,'2022-10-11 00:46:36','2022-10-11 00:46:36',NULL),(356,NULL,356,365,NULL,'2022-10-11 00:46:39','2022-10-11 00:46:39',NULL),(357,NULL,357,366,NULL,'2022-10-11 00:46:41','2022-10-11 00:46:41',NULL),(358,NULL,358,367,NULL,'2022-10-11 00:46:43','2022-10-11 00:46:43',NULL),(359,NULL,359,368,NULL,'2022-10-11 00:46:46','2022-10-11 00:46:46',NULL),(360,NULL,360,369,NULL,'2022-10-11 00:46:48','2022-10-11 00:46:48',NULL),(361,NULL,361,370,NULL,'2022-10-11 00:46:51','2022-10-11 00:46:51',NULL),(362,NULL,362,371,NULL,'2022-10-11 00:46:53','2022-10-11 00:46:53',NULL),(363,NULL,363,372,NULL,'2022-10-11 00:46:56','2022-10-11 00:46:56',NULL),(364,NULL,364,373,NULL,'2022-10-11 00:46:58','2022-10-11 00:46:58',NULL),(365,NULL,365,374,NULL,'2022-10-11 00:47:01','2022-10-11 00:47:01',NULL),(366,NULL,366,375,NULL,'2022-10-11 00:47:03','2022-10-11 00:47:03',NULL),(367,NULL,367,376,NULL,'2022-10-11 00:47:06','2022-10-11 00:47:06',NULL),(368,NULL,368,377,NULL,'2022-10-11 00:47:08','2022-10-11 00:47:08',NULL),(369,NULL,369,378,NULL,'2022-10-11 00:47:11','2022-10-11 00:47:11',NULL),(370,NULL,370,379,NULL,'2022-10-11 00:47:13','2022-10-11 00:47:13',NULL),(371,NULL,371,380,NULL,'2022-10-11 00:47:15','2022-10-11 00:47:15',NULL),(372,NULL,372,381,NULL,'2022-10-11 00:47:17','2022-10-11 00:47:17',NULL),(373,NULL,373,382,NULL,'2022-10-11 00:47:20','2022-10-11 00:47:20',NULL),(374,NULL,374,383,NULL,'2022-10-11 00:47:22','2022-10-11 00:47:22',NULL),(375,NULL,375,384,NULL,'2022-10-11 00:47:25','2022-10-11 00:47:25',NULL),(376,NULL,376,385,NULL,'2022-10-11 00:47:27','2022-10-11 00:47:27',NULL),(377,NULL,377,386,NULL,'2022-10-11 00:47:29','2022-10-11 00:47:29',NULL),(378,NULL,378,387,NULL,'2022-10-11 00:47:31','2022-10-11 00:47:31',NULL),(379,NULL,379,388,NULL,'2022-10-11 00:47:34','2022-10-11 00:47:34',NULL),(380,NULL,380,389,NULL,'2022-10-11 00:47:36','2022-10-11 00:47:36',NULL),(381,NULL,381,390,NULL,'2022-10-11 00:47:38','2022-10-11 00:47:38',NULL),(382,NULL,382,391,NULL,'2022-10-11 00:47:40','2022-10-11 00:47:40',NULL),(383,NULL,383,392,NULL,'2022-10-11 00:47:43','2022-10-11 00:47:43',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (384,NULL,384,393,NULL,'2022-10-11 00:47:45','2022-10-11 00:47:45',NULL),(385,NULL,385,394,NULL,'2022-10-11 00:47:47','2022-10-11 00:47:47',NULL),(386,NULL,386,395,NULL,'2022-10-11 00:47:49','2022-10-11 00:47:49',NULL),(387,NULL,387,396,NULL,'2022-10-11 00:47:51','2022-10-11 00:47:51',NULL),(388,NULL,388,397,NULL,'2022-10-11 00:47:54','2022-10-11 00:47:54',NULL),(389,NULL,389,398,NULL,'2022-10-11 00:47:56','2022-10-11 00:47:56',NULL),(390,NULL,390,399,NULL,'2022-10-11 00:47:59','2022-10-11 00:47:59',NULL),(391,NULL,391,400,NULL,'2022-10-11 00:48:01','2022-10-11 00:48:01',NULL),(392,NULL,392,401,NULL,'2022-10-11 00:48:03','2022-10-11 00:48:03',NULL),(393,NULL,393,402,NULL,'2022-10-11 00:48:06','2022-10-11 00:48:06',NULL),(394,NULL,394,403,NULL,'2022-10-11 00:48:08','2022-10-11 00:48:08',NULL),(395,NULL,395,404,NULL,'2022-10-11 00:48:10','2022-10-11 00:48:10',NULL),(396,NULL,396,405,NULL,'2022-10-11 00:48:13','2022-10-11 00:48:13',NULL),(397,NULL,397,406,NULL,'2022-10-11 00:48:15','2022-10-11 00:48:15',NULL),(398,NULL,398,407,NULL,'2022-10-11 00:48:17','2022-10-11 00:48:17',NULL),(399,NULL,399,408,NULL,'2022-10-11 00:48:20','2022-10-11 00:48:20',NULL),(400,NULL,400,409,NULL,'2022-10-11 00:48:22','2022-10-11 00:48:22',NULL),(401,NULL,401,410,NULL,'2022-10-11 00:48:25','2022-10-11 00:48:25',NULL),(402,NULL,402,411,NULL,'2022-10-11 00:48:27','2022-10-11 00:48:27',NULL),(403,NULL,403,412,NULL,'2022-10-11 00:48:29','2022-10-11 00:48:29',NULL),(404,NULL,404,413,NULL,'2022-10-11 00:48:31','2022-10-11 00:48:31',NULL),(405,NULL,405,414,NULL,'2022-10-11 00:48:33','2022-10-11 00:48:33',NULL),(406,NULL,406,415,NULL,'2022-10-11 00:48:35','2022-10-11 00:48:35',NULL),(407,NULL,407,416,NULL,'2022-10-11 00:48:38','2022-10-11 00:48:38',NULL),(408,NULL,408,417,NULL,'2022-10-11 00:48:40','2022-10-11 00:48:40',NULL),(409,NULL,409,418,NULL,'2022-10-11 00:48:42','2022-10-11 00:48:42',NULL),(410,NULL,410,419,NULL,'2022-10-11 00:48:45','2022-10-11 00:48:45',NULL),(411,NULL,411,420,NULL,'2022-10-11 00:48:47','2022-10-11 00:48:47',NULL),(412,NULL,412,421,NULL,'2022-10-11 00:48:49','2022-10-11 00:48:49',NULL),(413,NULL,413,422,NULL,'2022-10-11 00:48:51','2022-10-11 00:48:51',NULL),(414,NULL,414,423,NULL,'2022-10-11 00:48:54','2022-10-11 00:48:54',NULL),(415,NULL,415,424,NULL,'2022-10-11 00:48:56','2022-10-11 00:48:56',NULL),(416,NULL,416,425,NULL,'2022-10-11 00:48:58','2022-10-11 00:48:58',NULL),(417,NULL,417,426,NULL,'2022-10-11 00:49:00','2022-10-11 00:49:00',NULL),(418,NULL,418,427,NULL,'2022-10-11 00:49:03','2022-10-11 00:49:03',NULL),(419,NULL,419,428,NULL,'2022-10-11 00:49:05','2022-10-11 00:49:05',NULL),(420,NULL,420,429,NULL,'2022-10-11 00:49:08','2022-10-11 00:49:08',NULL),(421,NULL,421,430,NULL,'2022-10-11 00:49:10','2022-10-11 00:49:10',NULL),(422,NULL,422,431,NULL,'2022-10-11 00:49:12','2022-10-11 00:49:12',NULL),(423,NULL,423,432,NULL,'2022-10-11 00:49:15','2022-10-11 00:49:15',NULL),(424,NULL,424,433,NULL,'2022-10-11 00:49:17','2022-10-11 00:49:17',NULL),(425,NULL,425,434,NULL,'2022-10-11 00:49:19','2022-10-11 00:49:19',NULL),(426,NULL,426,435,NULL,'2022-10-11 00:49:22','2022-10-11 00:49:22',NULL),(427,NULL,427,436,NULL,'2022-10-11 00:49:24','2022-10-11 00:49:24',NULL),(428,NULL,428,437,NULL,'2022-10-11 00:49:26','2022-10-11 00:49:26',NULL),(429,NULL,429,438,NULL,'2022-10-11 00:49:29','2022-10-11 00:49:29',NULL),(430,NULL,430,439,NULL,'2022-10-11 00:49:31','2022-10-11 00:49:31',NULL),(431,NULL,431,440,NULL,'2022-10-11 00:49:33','2022-10-11 00:49:33',NULL),(432,NULL,432,441,NULL,'2022-10-11 00:49:36','2022-10-11 00:49:36',NULL),(433,NULL,433,442,NULL,'2022-10-11 00:49:38','2022-10-11 00:49:38',NULL),(434,NULL,434,443,NULL,'2022-10-11 00:49:40','2022-10-11 00:49:40',NULL),(435,NULL,435,444,NULL,'2022-10-11 00:49:44','2022-10-11 00:49:44',NULL),(436,NULL,436,445,NULL,'2022-10-11 00:49:46','2022-10-11 00:49:46',NULL),(437,NULL,437,446,NULL,'2022-10-11 00:49:49','2022-10-11 00:49:49',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (438,NULL,438,447,NULL,'2022-10-11 00:49:51','2022-10-11 00:49:51',NULL),(439,NULL,439,448,NULL,'2022-10-11 00:49:53','2022-10-11 00:49:53',NULL),(440,NULL,440,449,NULL,'2022-10-11 00:49:56','2022-10-11 00:49:56',NULL),(441,NULL,441,450,NULL,'2022-10-11 00:49:58','2022-10-11 00:49:58',NULL),(442,NULL,442,451,NULL,'2022-10-11 00:50:01','2022-10-11 00:50:01',NULL),(443,NULL,443,452,NULL,'2022-10-11 00:50:03','2022-10-11 00:50:03',NULL),(444,NULL,444,453,NULL,'2022-10-11 00:50:05','2022-10-11 00:50:05',NULL),(445,NULL,445,454,NULL,'2022-10-11 00:50:08','2022-10-11 00:50:08',NULL),(446,NULL,446,455,NULL,'2022-10-11 00:50:11','2022-10-11 00:50:11',NULL),(447,NULL,447,456,NULL,'2022-10-11 00:50:13','2022-10-11 00:50:13',NULL),(448,NULL,448,457,NULL,'2022-10-11 00:50:15','2022-10-11 00:50:15',NULL),(449,NULL,449,458,NULL,'2022-10-11 00:50:18','2022-10-11 00:50:18',NULL),(450,NULL,450,459,NULL,'2022-10-11 00:50:20','2022-10-11 00:50:20',NULL),(451,NULL,451,460,NULL,'2022-10-11 00:50:22','2022-10-11 00:50:22',NULL),(452,NULL,452,461,NULL,'2022-10-11 00:50:25','2022-10-11 00:50:25',NULL),(453,NULL,453,462,NULL,'2022-10-11 00:50:27','2022-10-11 00:50:27',NULL),(454,NULL,454,463,NULL,'2022-10-11 00:50:30','2022-10-11 00:50:30',NULL),(455,NULL,455,464,NULL,'2022-10-11 00:50:32','2022-10-11 00:50:32',NULL),(456,NULL,456,465,NULL,'2022-10-11 00:50:35','2022-10-11 00:50:35',NULL),(457,NULL,457,466,NULL,'2022-10-11 00:50:37','2022-10-11 00:50:37',NULL),(458,NULL,458,467,NULL,'2022-10-11 00:50:40','2022-10-11 00:50:40',NULL),(459,NULL,459,468,NULL,'2022-10-11 00:50:42','2022-10-11 00:50:42',NULL),(460,NULL,460,469,NULL,'2022-10-11 00:50:45','2022-10-11 00:50:45',NULL),(461,NULL,461,470,NULL,'2022-10-11 00:50:47','2022-10-11 00:50:47',NULL),(462,NULL,462,471,NULL,'2022-10-11 00:50:49','2022-10-11 00:50:49',NULL),(463,NULL,463,472,NULL,'2022-10-11 00:50:52','2022-10-11 00:50:52',NULL),(464,NULL,464,473,NULL,'2022-10-11 00:50:55','2022-10-11 00:50:55',NULL),(465,NULL,465,474,NULL,'2022-10-11 00:50:57','2022-10-11 00:50:57',NULL),(466,NULL,466,475,NULL,'2022-10-11 00:51:00','2022-10-11 00:51:00',NULL),(467,NULL,467,476,NULL,'2022-10-11 00:51:03','2022-10-11 00:51:03',NULL),(468,NULL,468,477,NULL,'2022-10-11 00:51:06','2022-10-11 00:51:06',NULL),(469,NULL,469,478,NULL,'2022-10-11 00:51:09','2022-10-11 00:51:09',NULL),(470,NULL,470,479,NULL,'2022-10-11 00:51:11','2022-10-11 00:51:11',NULL),(471,NULL,471,480,NULL,'2022-10-11 00:51:14','2022-10-11 00:51:14',NULL),(472,NULL,472,481,NULL,'2022-10-11 00:51:16','2022-10-11 00:51:16',NULL),(473,NULL,473,482,NULL,'2022-10-11 00:51:19','2022-10-11 00:51:19',NULL),(474,NULL,474,483,NULL,'2022-10-11 00:51:21','2022-10-11 00:51:21',NULL),(475,NULL,475,484,NULL,'2022-10-11 00:51:24','2022-10-11 00:51:24',NULL),(476,NULL,476,485,NULL,'2022-10-11 00:51:26','2022-10-11 00:51:26',NULL),(477,NULL,477,486,NULL,'2022-10-11 00:51:29','2022-10-11 00:51:29',NULL),(478,NULL,478,487,NULL,'2022-10-11 00:51:31','2022-10-11 00:51:31',NULL),(479,NULL,479,488,NULL,'2022-10-11 00:51:34','2022-10-11 00:51:34',NULL),(480,NULL,480,489,NULL,'2022-10-11 00:51:36','2022-10-11 00:51:36',NULL),(481,NULL,481,490,NULL,'2022-10-11 00:51:39','2022-10-11 00:51:39',NULL),(482,NULL,482,491,NULL,'2022-10-11 00:51:41','2022-10-11 00:51:41',NULL),(483,NULL,483,492,NULL,'2022-10-11 00:51:44','2022-10-11 00:51:44',NULL),(484,NULL,484,493,NULL,'2022-10-11 00:51:46','2022-10-11 00:51:46',NULL),(485,NULL,485,494,NULL,'2022-10-11 00:51:49','2022-10-11 00:51:49',NULL),(486,NULL,486,495,NULL,'2022-10-11 00:51:51','2022-10-11 00:51:51',NULL),(487,NULL,487,496,NULL,'2022-10-11 00:51:54','2022-10-11 00:51:54',NULL),(488,NULL,488,497,NULL,'2022-10-11 00:51:56','2022-10-11 00:51:56',NULL),(489,NULL,489,498,NULL,'2022-10-11 00:51:59','2022-10-11 00:51:59',NULL),(490,NULL,490,499,NULL,'2022-10-11 00:52:02','2022-10-11 00:52:02',NULL),(491,NULL,491,500,NULL,'2022-10-11 00:52:04','2022-10-11 00:52:04',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (492,NULL,492,501,NULL,'2022-10-11 00:52:06','2022-10-11 00:52:06',NULL),(493,NULL,493,502,NULL,'2022-10-11 00:52:09','2022-10-11 00:52:09',NULL),(494,NULL,494,503,NULL,'2022-10-11 00:52:11','2022-10-11 00:52:11',NULL),(495,NULL,495,504,NULL,'2022-10-11 00:52:13','2022-10-11 00:52:13',NULL),(496,NULL,496,505,NULL,'2022-10-11 00:52:16','2022-10-11 00:52:16',NULL),(497,NULL,497,506,NULL,'2022-10-11 00:52:19','2022-10-11 00:52:19',NULL),(498,NULL,498,507,NULL,'2022-10-11 00:52:21','2022-10-11 00:52:21',NULL),(499,NULL,499,508,NULL,'2022-10-11 00:52:23','2022-10-11 00:52:23',NULL),(500,NULL,500,509,NULL,'2022-10-11 00:52:26','2022-10-11 00:52:26',NULL),(501,NULL,501,510,NULL,'2022-10-11 00:52:28','2022-10-11 00:52:28',NULL),(502,NULL,502,511,NULL,'2022-10-11 00:52:30','2022-10-11 00:52:30',NULL),(503,NULL,503,512,NULL,'2022-10-11 00:52:33','2022-10-11 00:52:33',NULL),(504,NULL,504,513,NULL,'2022-10-11 00:52:36','2022-10-11 00:52:36',NULL),(505,NULL,505,514,NULL,'2022-10-11 00:52:39','2022-10-11 00:52:39',NULL),(506,NULL,506,515,NULL,'2022-10-11 00:52:41','2022-10-11 00:52:41',NULL),(507,NULL,507,516,NULL,'2022-10-11 00:52:44','2022-10-11 00:52:44',NULL),(508,NULL,508,517,NULL,'2022-10-11 00:52:46','2022-10-11 00:52:46',NULL),(509,NULL,509,518,NULL,'2022-10-11 00:52:49','2022-10-11 00:52:49',NULL),(510,NULL,510,519,NULL,'2022-10-11 00:52:51','2022-10-11 00:52:51',NULL),(511,NULL,511,520,NULL,'2022-10-11 00:52:54','2022-10-11 00:52:54',NULL),(512,NULL,512,521,NULL,'2022-10-11 00:52:56','2022-10-11 00:52:56',NULL),(513,NULL,513,522,NULL,'2022-10-11 00:52:59','2022-10-11 00:52:59',NULL),(514,NULL,514,523,NULL,'2022-10-11 00:53:02','2022-10-11 00:53:02',NULL),(515,NULL,515,524,NULL,'2022-10-11 00:53:04','2022-10-11 00:53:04',NULL),(516,NULL,516,525,NULL,'2022-10-11 00:53:07','2022-10-11 00:53:07',NULL),(517,NULL,517,526,NULL,'2022-10-11 00:53:10','2022-10-11 00:53:10',NULL),(518,NULL,518,527,NULL,'2022-10-11 00:53:12','2022-10-11 00:53:12',NULL),(519,NULL,519,528,NULL,'2022-10-11 00:53:15','2022-10-11 00:53:15',NULL),(520,NULL,520,529,NULL,'2022-10-11 00:53:17','2022-10-11 00:53:17',NULL),(521,NULL,521,530,NULL,'2022-10-11 00:53:20','2022-10-11 00:53:20',NULL),(522,NULL,522,531,NULL,'2022-10-11 00:53:22','2022-10-11 00:53:22',NULL),(523,NULL,523,532,NULL,'2022-10-11 00:53:25','2022-10-11 00:53:25',NULL),(524,NULL,524,533,NULL,'2022-10-11 00:53:27','2022-10-11 00:53:27',NULL),(525,NULL,525,534,NULL,'2022-10-11 00:53:30','2022-10-11 00:53:30',NULL),(526,NULL,526,535,NULL,'2022-10-11 00:53:33','2022-10-11 00:53:33',NULL),(527,NULL,527,536,NULL,'2022-10-11 00:53:35','2022-10-11 00:53:35',NULL),(528,NULL,528,537,NULL,'2022-10-11 00:53:38','2022-10-11 00:53:38',NULL),(529,NULL,529,538,NULL,'2022-10-11 00:53:40','2022-10-11 00:53:40',NULL),(530,NULL,530,539,NULL,'2022-10-11 00:53:43','2022-10-11 00:53:43',NULL),(531,NULL,531,540,NULL,'2022-10-11 00:53:45','2022-10-11 00:53:45',NULL),(532,NULL,532,541,NULL,'2022-10-11 00:53:48','2022-10-11 00:53:48',NULL),(533,NULL,533,542,NULL,'2022-10-11 00:53:50','2022-10-11 00:53:50',NULL),(534,NULL,534,543,NULL,'2022-10-11 00:53:53','2022-10-11 00:53:53',NULL),(535,NULL,535,544,NULL,'2022-10-11 00:53:56','2022-10-11 00:53:56',NULL),(536,NULL,536,545,NULL,'2022-10-11 00:53:58','2022-10-11 00:53:58',NULL),(537,NULL,537,546,NULL,'2022-10-11 00:54:00','2022-10-11 00:54:00',NULL),(538,NULL,538,547,NULL,'2022-10-11 00:54:03','2022-10-11 00:54:03',NULL),(539,NULL,539,548,NULL,'2022-10-11 00:54:06','2022-10-11 00:54:06',NULL),(540,NULL,540,549,NULL,'2022-10-11 00:54:08','2022-10-11 00:54:08',NULL),(541,NULL,541,550,NULL,'2022-10-11 00:54:10','2022-10-11 00:54:10',NULL),(542,NULL,542,551,NULL,'2022-10-11 00:54:13','2022-10-11 00:54:13',NULL),(543,NULL,543,552,NULL,'2022-10-11 00:54:16','2022-10-11 00:54:16',NULL),(544,NULL,544,553,NULL,'2022-10-11 00:54:18','2022-10-11 00:54:18',NULL),(545,NULL,545,554,NULL,'2022-10-11 00:54:20','2022-10-11 00:54:20',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (546,NULL,546,555,NULL,'2022-10-11 00:54:23','2022-10-11 00:54:23',NULL),(547,NULL,547,556,NULL,'2022-10-11 00:54:25','2022-10-11 00:54:25',NULL),(548,NULL,548,557,NULL,'2022-10-11 00:54:28','2022-10-11 00:54:28',NULL),(549,NULL,549,558,NULL,'2022-10-11 00:54:30','2022-10-11 00:54:30',NULL),(550,NULL,550,559,NULL,'2022-10-11 00:54:33','2022-10-11 00:54:33',NULL),(551,NULL,551,560,NULL,'2022-10-11 00:54:35','2022-10-11 00:54:35',NULL),(552,NULL,552,561,NULL,'2022-10-11 00:54:38','2022-10-11 00:54:38',NULL),(553,NULL,553,562,NULL,'2022-10-11 00:54:41','2022-10-11 00:54:41',NULL),(554,NULL,554,563,NULL,'2022-10-11 00:54:44','2022-10-11 00:54:44',NULL),(555,NULL,555,564,NULL,'2022-10-11 00:54:46','2022-10-11 00:54:46',NULL),(556,NULL,556,565,NULL,'2022-10-11 00:54:49','2022-10-11 00:54:49',NULL),(557,NULL,557,566,NULL,'2022-10-11 00:54:52','2022-10-11 00:54:52',NULL),(558,NULL,558,567,NULL,'2022-10-11 00:54:54','2022-10-11 00:54:54',NULL),(559,NULL,559,568,NULL,'2022-10-11 00:54:57','2022-10-11 00:54:57',NULL),(560,NULL,560,569,NULL,'2022-10-11 00:54:59','2022-10-11 00:54:59',NULL),(561,NULL,561,570,NULL,'2022-10-11 00:55:03','2022-10-11 00:55:03',NULL),(562,NULL,562,571,NULL,'2022-10-11 00:55:05','2022-10-11 00:55:05',NULL),(563,NULL,563,572,NULL,'2022-10-11 00:55:08','2022-10-11 00:55:08',NULL),(564,NULL,564,573,NULL,'2022-10-11 00:55:11','2022-10-11 00:55:11',NULL),(565,NULL,565,574,NULL,'2022-10-11 00:55:14','2022-10-11 00:55:14',NULL),(566,NULL,566,575,NULL,'2022-10-11 00:55:16','2022-10-11 00:55:16',NULL),(567,NULL,567,576,NULL,'2022-10-11 00:55:19','2022-10-11 00:55:19',NULL),(568,NULL,568,577,NULL,'2022-10-11 00:55:21','2022-10-11 00:55:21',NULL),(569,NULL,569,578,NULL,'2022-10-11 00:55:24','2022-10-11 00:55:24',NULL),(570,NULL,570,579,NULL,'2022-10-11 00:55:27','2022-10-11 00:55:27',NULL),(571,NULL,571,580,NULL,'2022-10-11 00:55:29','2022-10-11 00:55:29',NULL),(572,NULL,572,581,NULL,'2022-10-11 00:55:32','2022-10-11 00:55:32',NULL),(573,NULL,573,582,NULL,'2022-10-11 00:55:34','2022-10-11 00:55:34',NULL),(574,NULL,574,583,NULL,'2022-10-11 00:55:37','2022-10-11 00:55:37',NULL),(575,NULL,575,584,NULL,'2022-10-11 00:55:40','2022-10-11 00:55:40',NULL),(576,NULL,576,585,NULL,'2022-10-11 00:55:43','2022-10-11 00:55:43',NULL),(577,NULL,577,586,NULL,'2022-10-11 00:55:46','2022-10-11 00:55:46',NULL),(578,NULL,578,587,NULL,'2022-10-11 00:55:48','2022-10-11 00:55:48',NULL),(579,NULL,579,588,NULL,'2022-10-11 00:55:51','2022-10-11 00:55:51',NULL),(580,NULL,580,589,NULL,'2022-10-11 00:55:54','2022-10-11 00:55:54',NULL),(581,NULL,581,590,NULL,'2022-10-11 00:55:57','2022-10-11 00:55:57',NULL),(582,NULL,582,591,NULL,'2022-10-11 00:55:59','2022-10-11 00:55:59',NULL),(583,NULL,583,592,NULL,'2022-10-11 00:56:02','2022-10-11 00:56:02',NULL),(584,NULL,584,593,NULL,'2022-10-11 00:56:05','2022-10-11 00:56:05',NULL),(585,NULL,585,594,NULL,'2022-10-11 00:56:08','2022-10-11 00:56:08',NULL),(586,NULL,586,595,NULL,'2022-10-11 00:56:11','2022-10-11 00:56:11',NULL),(587,NULL,587,596,NULL,'2022-10-11 00:56:14','2022-10-11 00:56:14',NULL),(588,NULL,588,597,NULL,'2022-10-11 00:56:16','2022-10-11 00:56:16',NULL),(589,NULL,589,598,NULL,'2022-10-11 00:56:19','2022-10-11 00:56:19',NULL),(590,NULL,590,599,NULL,'2022-10-11 00:56:22','2022-10-11 00:56:22',NULL),(591,NULL,591,600,NULL,'2022-10-11 00:56:25','2022-10-11 00:56:25',NULL),(592,NULL,592,601,NULL,'2022-10-11 00:56:27','2022-10-11 00:56:27',NULL),(593,NULL,593,602,NULL,'2022-10-11 00:56:30','2022-10-11 00:56:30',NULL),(594,NULL,594,603,NULL,'2022-10-11 00:56:33','2022-10-11 00:56:33',NULL),(595,NULL,595,604,NULL,'2022-10-11 00:56:36','2022-10-11 00:56:36',NULL),(596,NULL,596,605,NULL,'2022-10-11 00:56:38','2022-10-11 00:56:38',NULL),(597,NULL,597,606,NULL,'2022-10-11 00:56:41','2022-10-11 00:56:41',NULL),(598,NULL,598,607,NULL,'2022-10-11 00:56:44','2022-10-11 00:56:44',NULL),(599,NULL,599,608,NULL,'2022-10-11 00:56:46','2022-10-11 00:56:46',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (600,NULL,600,609,NULL,'2022-10-11 00:56:49','2022-10-11 00:56:49',NULL),(601,NULL,601,610,NULL,'2022-10-11 00:56:52','2022-10-11 00:56:52',NULL),(602,NULL,602,611,NULL,'2022-10-11 00:56:55','2022-10-11 00:56:55',NULL),(603,NULL,603,612,NULL,'2022-10-11 00:56:57','2022-10-11 00:56:57',NULL),(604,NULL,604,613,NULL,'2022-10-11 00:57:00','2022-10-11 00:57:00',NULL),(605,NULL,605,614,NULL,'2022-10-11 00:57:03','2022-10-11 00:57:03',NULL),(606,NULL,606,615,NULL,'2022-10-11 00:57:06','2022-10-11 00:57:06',NULL),(607,NULL,607,616,NULL,'2022-10-11 00:57:09','2022-10-11 00:57:09',NULL),(608,NULL,608,617,NULL,'2022-10-11 00:57:11','2022-10-11 00:57:11',NULL),(609,NULL,609,618,NULL,'2022-10-11 00:57:14','2022-10-11 00:57:14',NULL),(610,NULL,610,619,NULL,'2022-10-11 00:57:17','2022-10-11 00:57:17',NULL),(611,NULL,611,620,NULL,'2022-10-11 00:57:20','2022-10-11 00:57:20',NULL),(612,NULL,612,621,NULL,'2022-10-11 00:57:22','2022-10-11 00:57:22',NULL),(613,NULL,613,622,NULL,'2022-10-11 00:57:25','2022-10-11 00:57:25',NULL),(614,NULL,614,623,NULL,'2022-10-11 00:57:28','2022-10-11 00:57:28',NULL),(615,NULL,615,624,NULL,'2022-10-11 00:57:30','2022-10-11 00:57:30',NULL),(616,NULL,616,625,NULL,'2022-10-11 00:57:33','2022-10-11 00:57:33',NULL),(617,NULL,617,626,NULL,'2022-10-11 00:57:36','2022-10-11 00:57:36',NULL),(618,NULL,618,627,NULL,'2022-10-11 00:57:39','2022-10-11 00:57:39',NULL),(619,NULL,619,628,NULL,'2022-10-11 00:57:42','2022-10-11 00:57:42',NULL),(620,NULL,620,629,NULL,'2022-10-11 00:57:45','2022-10-11 00:57:45',NULL),(621,NULL,621,630,NULL,'2022-10-11 00:57:47','2022-10-11 00:57:47',NULL),(622,NULL,622,631,NULL,'2022-10-11 00:57:50','2022-10-11 00:57:50',NULL),(623,NULL,623,632,NULL,'2022-10-11 00:57:53','2022-10-11 00:57:53',NULL),(624,NULL,624,633,NULL,'2022-10-11 00:57:55','2022-10-11 00:57:55',NULL),(625,NULL,625,634,NULL,'2022-10-11 00:57:58','2022-10-11 00:57:58',NULL),(626,NULL,626,635,NULL,'2022-10-11 00:58:00','2022-10-11 00:58:00',NULL),(627,NULL,627,636,NULL,'2022-10-11 00:58:03','2022-10-11 00:58:03',NULL),(628,NULL,628,637,NULL,'2022-10-11 00:58:06','2022-10-11 00:58:06',NULL),(629,NULL,629,638,NULL,'2022-10-11 00:58:09','2022-10-11 00:58:09',NULL),(630,NULL,630,639,NULL,'2022-10-11 00:58:12','2022-10-11 00:58:12',NULL),(631,NULL,631,640,NULL,'2022-10-11 00:58:14','2022-10-11 00:58:14',NULL),(632,NULL,632,641,NULL,'2022-10-11 00:58:17','2022-10-11 00:58:17',NULL),(633,NULL,633,642,NULL,'2022-10-11 00:58:20','2022-10-11 00:58:20',NULL),(634,NULL,634,643,NULL,'2022-10-22 11:27:25','2022-10-22 11:27:25',NULL),(635,NULL,635,644,NULL,'2022-10-22 11:27:28','2022-10-22 11:27:28',NULL),(636,NULL,636,645,NULL,'2022-10-22 11:27:30','2022-10-22 11:27:30',NULL),(637,NULL,637,646,NULL,'2022-10-22 11:27:32','2022-10-22 11:27:32',NULL),(638,NULL,638,647,NULL,'2022-10-22 11:27:35','2022-10-22 11:27:35',NULL),(639,NULL,639,648,NULL,'2022-10-22 11:27:37','2022-10-22 11:27:37',NULL),(640,NULL,640,649,NULL,'2022-10-22 11:27:40','2022-10-22 11:27:40',NULL),(641,NULL,641,650,NULL,'2022-10-22 11:27:43','2022-10-22 11:27:43',NULL),(642,NULL,642,651,NULL,'2022-10-22 11:27:45','2022-10-22 11:27:45',NULL),(643,NULL,643,652,NULL,'2022-10-22 11:27:48','2022-10-22 11:27:48',NULL),(644,NULL,644,653,NULL,'2022-10-22 11:27:50','2022-10-22 11:27:50',NULL),(645,NULL,645,654,NULL,'2022-10-22 11:27:53','2022-10-22 11:27:53',NULL),(646,NULL,646,655,NULL,'2022-10-22 11:27:55','2022-10-22 11:27:55',NULL),(647,NULL,647,656,NULL,'2022-10-22 11:27:58','2022-10-22 11:27:58',NULL),(648,NULL,648,657,NULL,'2022-10-22 11:28:00','2022-10-22 11:28:00',NULL),(649,NULL,649,658,NULL,'2022-10-22 11:28:03','2022-10-22 11:28:03',NULL),(650,NULL,650,659,NULL,'2022-10-22 11:28:06','2022-10-22 11:28:06',NULL),(651,NULL,651,660,NULL,'2022-10-22 11:28:08','2022-10-22 11:28:08',NULL),(652,NULL,652,661,NULL,'2022-10-22 11:28:12','2022-10-22 11:28:12',NULL),(653,NULL,653,662,NULL,'2022-10-22 11:28:15','2022-10-22 11:28:15',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (654,NULL,654,663,NULL,'2022-10-22 11:28:17','2022-10-22 11:28:17',NULL),(655,NULL,655,664,NULL,'2022-10-22 11:28:20','2022-10-22 11:28:20',NULL),(656,NULL,656,665,NULL,'2022-10-22 11:28:22','2022-10-22 11:28:22',NULL),(657,NULL,657,666,NULL,'2022-10-22 11:28:25','2022-10-22 11:28:25',NULL),(658,NULL,658,667,NULL,'2022-10-22 11:28:27','2022-10-22 11:28:27',NULL),(659,NULL,659,668,NULL,'2022-10-22 11:28:30','2022-10-22 11:28:30',NULL),(660,NULL,660,669,NULL,'2022-10-22 11:28:33','2022-10-22 11:28:33',NULL),(661,NULL,661,670,NULL,'2022-10-22 11:28:36','2022-10-22 11:28:36',NULL),(662,NULL,662,671,NULL,'2022-10-22 11:28:39','2022-10-22 11:28:39',NULL),(663,NULL,663,672,NULL,'2022-10-22 11:28:41','2022-10-22 11:28:41',NULL),(664,NULL,664,673,NULL,'2022-10-22 11:28:44','2022-10-22 11:28:44',NULL),(665,NULL,665,674,NULL,'2022-10-22 11:28:46','2022-10-22 11:28:46',NULL),(666,NULL,666,675,NULL,'2022-10-22 11:28:49','2022-10-22 11:28:49',NULL),(667,NULL,667,676,NULL,'2022-10-22 11:28:52','2022-10-22 11:28:52',NULL),(668,NULL,668,677,NULL,'2022-10-22 11:28:55','2022-10-22 11:28:55',NULL),(669,NULL,669,678,NULL,'2022-10-22 11:28:58','2022-10-22 11:28:58',NULL),(670,NULL,670,679,NULL,'2022-10-22 11:29:00','2022-10-22 11:29:00',NULL),(671,NULL,671,680,NULL,'2022-10-22 11:29:03','2022-10-22 11:29:03',NULL),(672,NULL,672,681,NULL,'2022-10-22 11:29:06','2022-10-22 11:29:06',NULL),(673,NULL,673,682,NULL,'2022-10-22 11:29:09','2022-10-22 11:29:09',NULL),(674,NULL,674,683,NULL,'2022-10-22 11:29:11','2022-10-22 11:29:11',NULL),(675,NULL,675,684,NULL,'2022-10-22 11:29:14','2022-10-22 11:29:14',NULL),(676,NULL,676,685,NULL,'2022-10-22 11:29:17','2022-10-22 11:29:17',NULL),(677,NULL,677,686,NULL,'2022-10-22 11:29:19','2022-10-22 11:29:19',NULL),(678,NULL,678,687,NULL,'2022-10-22 11:29:22','2022-10-22 11:29:22',NULL),(679,NULL,679,688,NULL,'2022-10-22 11:29:24','2022-10-22 11:29:24',NULL),(680,NULL,680,689,NULL,'2022-10-22 11:29:27','2022-10-22 11:29:27',NULL),(681,NULL,681,690,NULL,'2022-10-22 11:29:30','2022-10-22 11:29:30',NULL),(682,NULL,682,691,NULL,'2022-10-22 11:29:32','2022-10-22 11:29:32',NULL),(683,NULL,683,692,NULL,'2022-10-22 11:29:35','2022-10-22 11:29:35',NULL),(684,NULL,684,693,NULL,'2022-10-22 11:29:38','2022-10-22 11:29:38',NULL),(685,NULL,685,694,NULL,'2022-10-22 11:29:41','2022-10-22 11:29:41',NULL),(686,NULL,686,695,NULL,'2022-10-22 11:29:44','2022-10-22 11:29:44',NULL),(687,NULL,687,696,NULL,'2022-10-22 11:29:46','2022-10-22 11:29:46',NULL),(688,NULL,688,697,NULL,'2022-10-22 11:29:49','2022-10-22 11:29:49',NULL),(689,NULL,689,698,NULL,'2022-10-22 11:29:52','2022-10-22 11:29:52',NULL),(690,NULL,690,699,NULL,'2022-10-22 11:29:54','2022-10-22 11:29:54',NULL),(691,NULL,691,700,NULL,'2022-10-22 11:29:57','2022-10-22 11:29:57',NULL),(692,NULL,692,701,NULL,'2022-10-22 11:30:00','2022-10-22 11:30:00',NULL),(693,NULL,693,702,NULL,'2022-10-22 11:30:03','2022-10-22 11:30:03',NULL),(694,NULL,694,703,NULL,'2022-10-22 11:30:06','2022-10-22 11:30:06',NULL),(695,NULL,695,704,NULL,'2022-10-22 11:30:09','2022-10-22 11:30:09',NULL),(696,NULL,696,705,NULL,'2022-10-22 11:30:11','2022-10-22 11:30:11',NULL),(697,NULL,697,706,NULL,'2022-10-22 11:30:14','2022-10-22 11:30:14',NULL),(698,NULL,698,707,NULL,'2022-10-22 11:30:16','2022-10-22 11:30:16',NULL),(699,NULL,699,708,NULL,'2022-10-22 11:30:19','2022-10-22 11:30:19',NULL),(700,NULL,700,709,NULL,'2022-10-22 11:30:22','2022-10-22 11:30:22',NULL),(701,NULL,701,710,NULL,'2022-10-22 11:30:24','2022-10-22 11:30:24',NULL),(702,NULL,702,711,NULL,'2022-10-22 11:30:27','2022-10-22 11:30:27',NULL),(703,NULL,703,712,NULL,'2022-10-22 11:30:30','2022-10-22 11:30:30',NULL),(704,NULL,704,713,NULL,'2022-10-22 11:30:33','2022-10-22 11:30:33',NULL),(705,NULL,705,714,NULL,'2022-10-22 11:30:35','2022-10-22 11:30:35',NULL),(706,NULL,706,715,NULL,'2022-10-22 11:30:38','2022-10-22 11:30:38',NULL),(707,NULL,707,716,NULL,'2022-10-22 11:30:41','2022-10-22 11:30:41',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (708,NULL,708,717,NULL,'2022-10-22 11:30:44','2022-10-22 11:30:44',NULL),(709,NULL,709,718,NULL,'2022-10-22 11:30:46','2022-10-22 11:30:46',NULL),(710,NULL,710,719,NULL,'2022-10-22 11:30:49','2022-10-22 11:30:49',NULL),(711,NULL,711,720,NULL,'2022-10-22 11:30:52','2022-10-22 11:30:52',NULL),(712,NULL,712,721,NULL,'2022-10-22 11:30:55','2022-10-22 11:30:55',NULL),(713,NULL,713,722,NULL,'2022-10-22 11:30:57','2022-10-22 11:30:57',NULL),(714,NULL,714,723,NULL,'2022-10-22 11:31:00','2022-10-22 11:31:00',NULL),(715,NULL,715,724,NULL,'2022-10-22 11:31:03','2022-10-22 11:31:03',NULL),(716,NULL,716,725,NULL,'2022-10-22 11:31:06','2022-10-22 11:31:06',NULL),(717,NULL,717,726,NULL,'2022-10-22 11:31:08','2022-10-22 11:31:08',NULL),(718,NULL,718,727,NULL,'2022-10-22 11:31:11','2022-10-22 11:31:11',NULL),(719,NULL,719,728,NULL,'2022-10-22 11:31:14','2022-10-22 11:31:14',NULL),(720,NULL,720,729,NULL,'2022-10-22 11:31:17','2022-10-22 11:31:17',NULL),(721,NULL,721,730,NULL,'2022-10-22 11:31:20','2022-10-22 11:31:20',NULL),(722,NULL,722,731,NULL,'2022-10-22 11:31:22','2022-10-22 11:31:22',NULL),(723,NULL,723,732,NULL,'2022-10-22 11:31:25','2022-10-22 11:31:25',NULL),(724,NULL,724,733,NULL,'2022-10-22 11:31:28','2022-10-22 11:31:28',NULL),(725,NULL,725,734,NULL,'2022-10-22 11:31:30','2022-10-22 11:31:30',NULL),(726,NULL,726,735,NULL,'2022-10-22 11:31:33','2022-10-22 11:31:33',NULL),(727,NULL,727,736,NULL,'2022-10-22 11:31:36','2022-10-22 11:31:36',NULL),(728,NULL,728,737,NULL,'2022-10-22 11:31:39','2022-10-22 11:31:39',NULL),(729,NULL,729,738,NULL,'2022-10-22 11:31:42','2022-10-22 11:31:42',NULL),(730,NULL,730,739,NULL,'2022-10-22 11:31:44','2022-10-22 11:31:44',NULL),(731,NULL,731,740,NULL,'2022-10-22 11:31:47','2022-10-22 11:31:47',NULL),(732,NULL,732,741,NULL,'2022-10-22 11:31:50','2022-10-22 11:31:50',NULL),(733,NULL,733,742,NULL,'2022-10-22 11:31:53','2022-10-22 11:31:53',NULL),(734,NULL,734,743,NULL,'2022-10-22 11:31:55','2022-10-22 11:31:55',NULL),(735,NULL,735,744,NULL,'2022-10-22 11:31:59','2022-10-22 11:31:59',NULL),(736,NULL,736,745,NULL,'2022-10-22 11:32:01','2022-10-22 11:32:01',NULL),(737,NULL,737,746,NULL,'2022-10-22 11:32:04','2022-10-22 11:32:04',NULL),(738,NULL,738,747,NULL,'2022-10-22 11:32:07','2022-10-22 11:32:07',NULL),(739,NULL,739,748,NULL,'2022-10-22 11:32:10','2022-10-22 11:32:10',NULL),(740,NULL,740,749,NULL,'2022-10-22 11:32:12','2022-10-22 11:32:12',NULL),(741,NULL,741,750,NULL,'2022-10-22 11:32:15','2022-10-22 11:32:15',NULL),(742,NULL,742,751,NULL,'2022-10-22 11:32:18','2022-10-22 11:32:18',NULL),(743,NULL,743,752,NULL,'2022-10-22 11:32:21','2022-10-22 11:32:21',NULL),(744,NULL,744,753,NULL,'2022-10-22 11:32:23','2022-10-22 11:32:23',NULL),(745,NULL,745,754,NULL,'2022-10-22 11:32:26','2022-10-22 11:32:26',NULL),(746,NULL,746,755,NULL,'2022-10-22 11:32:29','2022-10-22 11:32:29',NULL),(747,NULL,747,756,NULL,'2022-10-22 11:32:31','2022-10-22 11:32:31',NULL),(748,NULL,748,757,NULL,'2022-10-22 11:32:34','2022-10-22 11:32:34',NULL),(749,NULL,749,758,NULL,'2022-10-22 11:32:37','2022-10-22 11:32:37',NULL),(750,NULL,750,759,NULL,'2022-10-22 11:32:40','2022-10-22 11:32:40',NULL),(751,NULL,751,760,NULL,'2022-10-22 11:32:43','2022-10-22 11:32:43',NULL),(752,NULL,752,761,NULL,'2022-10-22 11:32:46','2022-10-22 11:32:46',NULL),(753,NULL,753,762,NULL,'2022-10-22 11:32:48','2022-10-22 11:32:48',NULL),(754,NULL,754,763,NULL,'2022-10-22 11:32:51','2022-10-22 11:32:51',NULL),(755,NULL,755,764,NULL,'2022-10-22 11:32:54','2022-10-22 11:32:54',NULL),(756,NULL,756,765,NULL,'2022-10-22 11:32:57','2022-10-22 11:32:57',NULL),(757,NULL,757,766,NULL,'2022-10-22 11:32:59','2022-10-22 11:32:59',NULL),(758,NULL,758,767,NULL,'2022-10-22 11:33:03','2022-10-22 11:33:03',NULL),(759,NULL,759,768,NULL,'2022-10-22 11:33:06','2022-10-22 11:33:06',NULL),(760,NULL,760,769,NULL,'2022-10-22 11:33:09','2022-10-22 11:33:09',NULL),(761,NULL,761,770,NULL,'2022-10-22 11:33:12','2022-10-22 11:33:12',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (762,NULL,762,771,NULL,'2022-10-22 11:33:14','2022-10-22 11:33:14',NULL),(763,NULL,763,772,NULL,'2022-10-22 11:33:17','2022-10-22 11:33:17',NULL),(764,NULL,764,773,NULL,'2022-10-22 11:33:20','2022-10-22 11:33:20',NULL),(765,NULL,765,774,NULL,'2022-10-22 11:33:23','2022-10-22 11:33:23',NULL),(766,NULL,766,775,NULL,'2022-10-22 11:33:26','2022-10-22 11:33:26',NULL),(767,NULL,767,776,NULL,'2022-10-22 11:33:28','2022-10-22 11:33:28',NULL),(768,NULL,768,777,NULL,'2022-10-22 11:33:31','2022-10-22 11:33:31',NULL),(769,NULL,769,778,NULL,'2022-10-22 11:33:34','2022-10-22 11:33:34',NULL),(770,NULL,770,779,NULL,'2022-10-22 11:33:37','2022-10-22 11:33:37',NULL),(771,NULL,771,780,NULL,'2022-10-22 11:33:40','2022-10-22 11:33:40',NULL),(772,NULL,772,781,NULL,'2022-10-22 11:33:43','2022-10-22 11:33:43',NULL),(773,NULL,773,782,NULL,'2022-10-22 11:33:45','2022-10-22 11:33:45',NULL),(774,NULL,774,783,NULL,'2022-10-22 11:33:48','2022-10-22 11:33:48',NULL),(775,NULL,775,784,NULL,'2022-10-22 11:33:51','2022-10-22 11:33:51',NULL),(776,NULL,776,785,NULL,'2022-10-22 11:33:54','2022-10-22 11:33:54',NULL),(777,NULL,777,786,NULL,'2022-10-22 11:33:57','2022-10-22 11:33:57',NULL),(778,NULL,778,787,NULL,'2022-10-22 11:34:00','2022-10-22 11:34:00',NULL),(779,NULL,779,788,NULL,'2022-10-22 11:34:03','2022-10-22 11:34:03',NULL),(780,NULL,780,789,NULL,'2022-10-22 11:34:06','2022-10-22 11:34:06',NULL),(781,NULL,781,790,NULL,'2022-10-22 11:34:09','2022-10-22 11:34:09',NULL),(782,NULL,782,791,NULL,'2022-10-22 11:34:11','2022-10-22 11:34:11',NULL),(783,NULL,783,792,NULL,'2022-10-22 11:34:14','2022-10-22 11:34:14',NULL),(784,NULL,784,793,NULL,'2022-10-22 11:34:17','2022-10-22 11:34:17',NULL),(785,NULL,785,794,NULL,'2022-10-22 11:34:20','2022-10-22 11:34:20',NULL),(786,NULL,786,795,NULL,'2022-10-22 11:34:23','2022-10-22 11:34:23',NULL),(787,NULL,787,796,NULL,'2022-10-22 11:34:26','2022-10-22 11:34:26',NULL),(788,NULL,788,797,NULL,'2022-10-22 11:34:29','2022-10-22 11:34:29',NULL),(789,NULL,789,798,NULL,'2022-10-22 11:34:32','2022-10-22 11:34:32',NULL),(790,NULL,790,799,NULL,'2022-10-22 11:34:35','2022-10-22 11:34:35',NULL),(791,NULL,791,800,NULL,'2022-10-22 11:34:38','2022-10-22 11:34:38',NULL),(792,NULL,792,801,NULL,'2022-10-22 11:34:40','2022-10-22 11:34:40',NULL),(793,NULL,793,802,NULL,'2022-10-22 11:34:43','2022-10-22 11:34:43',NULL),(794,NULL,794,803,NULL,'2022-10-22 11:34:46','2022-10-22 11:34:46',NULL),(795,NULL,795,804,NULL,'2022-10-22 11:34:49','2022-10-22 11:34:49',NULL),(796,NULL,796,805,NULL,'2022-10-22 11:34:52','2022-10-22 11:34:52',NULL),(797,NULL,797,806,NULL,'2022-10-22 11:34:54','2022-10-22 11:34:54',NULL),(798,NULL,798,807,NULL,'2022-10-22 11:34:57','2022-10-22 11:34:57',NULL),(799,NULL,799,808,NULL,'2022-10-22 11:35:00','2022-10-22 11:35:00',NULL),(800,NULL,800,809,NULL,'2022-10-22 11:35:03','2022-10-22 11:35:03',NULL),(801,NULL,801,810,NULL,'2022-10-22 11:35:06','2022-10-22 11:35:06',NULL),(802,NULL,802,811,NULL,'2022-10-22 11:35:09','2022-10-22 11:35:09',NULL),(803,NULL,803,812,NULL,'2022-10-22 11:35:12','2022-10-22 11:35:12',NULL),(804,NULL,804,813,NULL,'2022-10-22 11:35:15','2022-10-22 11:35:15',NULL),(805,NULL,805,814,NULL,'2022-10-22 11:35:18','2022-10-22 11:35:18',NULL),(806,NULL,806,815,NULL,'2022-10-22 11:35:21','2022-10-22 11:35:21',NULL),(807,NULL,807,816,NULL,'2022-10-22 11:35:24','2022-10-22 11:35:24',NULL),(808,NULL,808,817,NULL,'2022-10-22 11:35:26','2022-10-22 11:35:26',NULL),(809,NULL,809,818,NULL,'2022-10-22 11:35:29','2022-10-22 11:35:29',NULL),(810,NULL,810,819,NULL,'2022-10-22 11:35:32','2022-10-22 11:35:32',NULL),(811,NULL,811,820,NULL,'2022-10-22 11:35:35','2022-10-22 11:35:35',NULL),(812,NULL,812,821,NULL,'2022-10-22 11:35:38','2022-10-22 11:35:38',NULL),(813,NULL,813,822,NULL,'2022-10-22 11:35:41','2022-10-22 11:35:41',NULL),(814,NULL,814,823,NULL,'2022-10-22 11:35:44','2022-10-22 11:35:44',NULL),(815,NULL,815,824,NULL,'2022-10-22 11:35:47','2022-10-22 11:35:47',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (816,NULL,816,825,NULL,'2022-10-22 11:35:50','2022-10-22 11:35:50',NULL),(817,NULL,817,826,NULL,'2022-10-22 11:35:53','2022-10-22 11:35:53',NULL),(818,NULL,818,827,NULL,'2022-10-22 11:35:56','2022-10-22 11:35:56',NULL),(819,NULL,819,828,NULL,'2022-10-22 11:35:59','2022-10-22 11:35:59',NULL),(820,NULL,820,829,NULL,'2022-10-22 11:36:02','2022-10-22 11:36:02',NULL),(821,NULL,821,830,NULL,'2022-10-22 11:36:05','2022-10-22 11:36:05',NULL),(822,NULL,822,831,NULL,'2022-10-22 11:36:08','2022-10-22 11:36:08',NULL),(823,NULL,823,832,NULL,'2022-10-22 11:36:11','2022-10-22 11:36:11',NULL),(824,NULL,824,833,NULL,'2022-10-22 11:36:14','2022-10-22 11:36:14',NULL),(825,NULL,825,834,NULL,'2022-10-22 11:36:17','2022-10-22 11:36:17',NULL),(826,NULL,826,835,NULL,'2022-10-22 11:36:20','2022-10-22 11:36:20',NULL),(827,NULL,827,836,NULL,'2022-10-22 11:36:23','2022-10-22 11:36:23',NULL),(828,NULL,828,837,NULL,'2022-10-22 11:36:26','2022-10-22 11:36:26',NULL),(829,NULL,829,838,NULL,'2022-10-22 11:36:29','2022-10-22 11:36:29',NULL),(830,NULL,830,839,NULL,'2022-10-22 11:36:32','2022-10-22 11:36:32',NULL),(831,NULL,831,840,NULL,'2022-10-22 11:36:35','2022-10-22 11:36:35',NULL),(832,NULL,832,841,NULL,'2022-10-22 11:36:38','2022-10-22 11:36:38',NULL),(833,NULL,833,842,NULL,'2022-10-22 11:36:41','2022-10-22 11:36:41',NULL),(834,NULL,834,843,NULL,'2022-10-22 11:36:44','2022-10-22 11:36:44',NULL),(835,NULL,835,844,NULL,'2022-10-22 11:36:47','2022-10-22 11:36:47',NULL),(836,NULL,836,845,NULL,'2022-10-22 11:36:50','2022-10-22 11:36:50',NULL),(837,NULL,837,846,NULL,'2022-10-22 11:36:53','2022-10-22 11:36:53',NULL),(838,NULL,838,847,NULL,'2022-10-22 11:36:56','2022-10-22 11:36:56',NULL),(839,NULL,839,848,NULL,'2022-10-22 11:36:59','2022-10-22 11:36:59',NULL),(840,NULL,840,849,NULL,'2022-10-22 11:37:02','2022-10-22 11:37:02',NULL),(841,NULL,841,850,NULL,'2022-10-22 11:37:05','2022-10-22 11:37:05',NULL),(842,NULL,842,851,NULL,'2022-10-22 11:37:08','2022-10-22 11:37:08',NULL),(843,NULL,843,852,NULL,'2022-10-22 11:37:11','2022-10-22 11:37:11',NULL),(844,NULL,844,853,NULL,'2022-10-22 11:37:14','2022-10-22 11:37:14',NULL),(845,NULL,845,854,NULL,'2022-10-22 11:37:17','2022-10-22 11:37:17',NULL),(846,NULL,846,855,NULL,'2022-10-22 11:37:20','2022-10-22 11:37:20',NULL),(847,NULL,847,856,NULL,'2022-10-22 11:37:23','2022-10-22 11:37:23',NULL),(848,NULL,848,857,NULL,'2022-10-22 11:37:26','2022-10-22 11:37:26',NULL),(849,NULL,849,858,NULL,'2022-10-22 11:37:29','2022-10-22 11:37:29',NULL),(850,NULL,850,859,NULL,'2022-10-22 11:37:32','2022-10-22 11:37:32',NULL),(851,NULL,851,860,NULL,'2022-10-22 11:37:35','2022-10-22 11:37:35',NULL),(852,NULL,852,861,NULL,'2022-10-22 11:37:38','2022-10-22 11:37:38',NULL),(853,NULL,853,862,NULL,'2022-10-22 11:37:41','2022-10-22 11:37:41',NULL),(854,NULL,854,863,NULL,'2022-10-22 11:37:44','2022-10-22 11:37:44',NULL),(855,NULL,855,864,NULL,'2022-10-22 11:37:47','2022-10-22 11:37:47',NULL),(856,NULL,856,865,NULL,'2022-10-22 11:37:50','2022-10-22 11:37:50',NULL),(857,NULL,857,866,NULL,'2022-10-22 11:37:53','2022-10-22 11:37:53',NULL),(858,NULL,858,867,NULL,'2022-10-22 11:37:56','2022-10-22 11:37:56',NULL),(859,NULL,859,868,NULL,'2022-10-22 11:37:59','2022-10-22 11:37:59',NULL),(860,NULL,860,869,NULL,'2022-10-22 11:38:02','2022-10-22 11:38:02',NULL),(861,NULL,861,870,NULL,'2022-10-22 11:38:05','2022-10-22 11:38:05',NULL),(862,NULL,862,871,NULL,'2022-10-22 11:38:08','2022-10-22 11:38:08',NULL),(863,NULL,863,872,NULL,'2022-10-22 11:38:11','2022-10-22 11:38:11',NULL),(864,NULL,864,873,NULL,'2022-10-22 11:38:14','2022-10-22 11:38:14',NULL),(865,NULL,865,874,NULL,'2022-10-22 11:38:17','2022-10-22 11:38:17',NULL),(866,NULL,866,875,NULL,'2022-10-22 11:38:20','2022-10-22 11:38:20',NULL),(867,NULL,867,876,NULL,'2022-10-22 11:38:23','2022-10-22 11:38:23',NULL),(868,NULL,868,877,NULL,'2022-10-22 11:38:26','2022-10-22 11:38:26',NULL),(869,NULL,869,878,NULL,'2022-10-22 11:38:29','2022-10-22 11:38:29',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (870,NULL,870,879,NULL,'2022-10-22 11:38:32','2022-10-22 11:38:32',NULL),(871,NULL,871,880,NULL,'2022-10-22 11:38:35','2022-10-22 11:38:35',NULL),(872,NULL,872,881,NULL,'2022-10-22 11:38:38','2022-10-22 11:38:38',NULL),(873,NULL,873,882,NULL,'2022-10-22 11:38:41','2022-10-22 11:38:41',NULL),(874,NULL,874,883,NULL,'2022-10-22 11:38:44','2022-10-22 11:38:44',NULL),(875,NULL,875,884,NULL,'2022-10-22 11:38:47','2022-10-22 11:38:47',NULL),(876,NULL,876,885,NULL,'2022-10-22 11:38:50','2022-10-22 11:38:50',NULL),(877,NULL,877,886,NULL,'2022-10-22 11:38:53','2022-10-22 11:38:53',NULL),(878,NULL,878,887,NULL,'2022-10-22 11:38:56','2022-10-22 11:38:56',NULL),(879,NULL,879,888,NULL,'2022-10-22 11:38:59','2022-10-22 11:38:59',NULL),(880,NULL,880,889,NULL,'2022-10-22 11:39:02','2022-10-22 11:39:02',NULL),(881,NULL,881,890,NULL,'2022-10-22 11:39:06','2022-10-22 11:39:06',NULL),(882,NULL,882,891,NULL,'2022-10-22 11:39:09','2022-10-22 11:39:09',NULL),(883,NULL,883,892,NULL,'2022-10-22 11:39:12','2022-10-22 11:39:12',NULL),(884,NULL,884,893,NULL,'2022-10-22 11:39:15','2022-10-22 11:39:15',NULL),(885,NULL,885,894,NULL,'2022-10-22 11:39:18','2022-10-22 11:39:18',NULL),(886,NULL,886,895,NULL,'2022-10-22 11:39:21','2022-10-22 11:39:21',NULL),(887,NULL,887,896,NULL,'2022-10-22 11:39:25','2022-10-22 11:39:25',NULL),(888,NULL,888,897,NULL,'2022-10-22 11:39:28','2022-10-22 11:39:28',NULL),(889,NULL,889,898,NULL,'2022-10-22 11:39:31','2022-10-22 11:39:31',NULL),(890,NULL,890,899,NULL,'2022-10-22 11:39:34','2022-10-22 11:39:34',NULL),(891,NULL,891,900,NULL,'2022-10-22 11:39:37','2022-10-22 11:39:37',NULL),(892,NULL,892,901,NULL,'2022-10-22 11:39:40','2022-10-22 11:39:40',NULL),(893,NULL,893,902,NULL,'2022-10-22 11:39:43','2022-10-22 11:39:43',NULL),(894,NULL,894,903,NULL,'2022-10-22 11:39:47','2022-10-22 11:39:47',NULL),(895,NULL,895,904,NULL,'2022-10-22 11:39:50','2022-10-22 11:39:50',NULL),(896,NULL,896,905,NULL,'2022-10-22 11:39:53','2022-10-22 11:39:53',NULL),(897,NULL,897,906,NULL,'2022-10-22 11:39:56','2022-10-22 11:39:56',NULL),(898,NULL,898,907,NULL,'2022-10-22 11:39:59','2022-10-22 11:39:59',NULL),(899,NULL,899,908,NULL,'2022-10-22 11:40:02','2022-10-22 11:40:02',NULL),(900,NULL,900,909,NULL,'2022-10-22 11:40:05','2022-10-22 11:40:05',NULL),(901,NULL,901,910,NULL,'2022-10-22 11:40:09','2022-10-22 11:40:09',NULL),(902,NULL,902,911,NULL,'2022-10-22 11:40:12','2022-10-22 11:40:12',NULL),(903,NULL,903,912,NULL,'2022-10-22 11:40:15','2022-10-22 11:40:15',NULL),(904,NULL,904,913,NULL,'2022-10-22 11:40:18','2022-10-22 11:40:18',NULL),(905,NULL,905,914,NULL,'2022-10-22 11:40:21','2022-10-22 11:40:21',NULL),(906,NULL,906,915,NULL,'2022-10-22 11:40:24','2022-10-22 11:40:24',NULL),(907,NULL,907,916,NULL,'2022-10-22 11:40:27','2022-10-22 11:40:27',NULL),(908,NULL,908,917,NULL,'2022-10-22 11:40:31','2022-10-22 11:40:31',NULL),(909,NULL,909,918,NULL,'2022-10-22 11:40:34','2022-10-22 11:40:34',NULL),(910,NULL,910,919,NULL,'2022-10-22 11:40:38','2022-10-22 11:40:38',NULL),(911,NULL,911,920,NULL,'2022-10-22 11:40:41','2022-10-22 11:40:41',NULL),(912,NULL,912,921,NULL,'2022-10-22 11:40:44','2022-10-22 11:40:44',NULL),(913,NULL,913,922,NULL,'2022-10-22 11:40:47','2022-10-22 11:40:47',NULL),(914,NULL,914,923,NULL,'2022-10-22 11:40:50','2022-10-22 11:40:50',NULL),(915,NULL,915,924,NULL,'2022-10-22 11:40:54','2022-10-22 11:40:54',NULL),(916,NULL,916,925,NULL,'2022-10-22 11:40:57','2022-10-22 11:40:57',NULL),(917,NULL,917,926,NULL,'2022-10-22 11:41:00','2022-10-22 11:41:00',NULL),(918,NULL,918,927,NULL,'2022-10-22 11:41:04','2022-10-22 11:41:04',NULL),(919,NULL,919,928,NULL,'2022-10-22 11:41:08','2022-10-22 11:41:08',NULL),(920,NULL,920,929,NULL,'2022-10-22 11:41:11','2022-10-22 11:41:11',NULL),(921,NULL,921,930,NULL,'2022-10-22 11:41:15','2022-10-22 11:41:15',NULL),(922,NULL,922,931,NULL,'2022-10-22 11:41:20','2022-10-22 11:41:20',NULL),(923,NULL,923,932,NULL,'2022-10-22 11:41:25','2022-10-22 11:41:25',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (924,NULL,924,933,NULL,'2022-10-22 11:41:29','2022-10-22 11:41:29',NULL),(925,NULL,925,934,NULL,'2022-10-22 11:41:33','2022-10-22 11:41:33',NULL),(926,NULL,926,935,NULL,'2022-10-22 11:41:37','2022-10-22 11:41:37',NULL),(927,NULL,927,936,NULL,'2022-10-22 11:41:41','2022-10-22 11:41:41',NULL),(928,NULL,928,937,NULL,'2022-10-22 11:41:45','2022-10-22 11:41:45',NULL),(929,NULL,929,938,NULL,'2022-10-22 11:41:48','2022-10-22 11:41:48',NULL),(930,NULL,930,939,NULL,'2022-10-22 11:41:52','2022-10-22 11:41:52',NULL),(931,NULL,931,940,NULL,'2022-10-22 11:41:55','2022-10-22 11:41:55',NULL),(932,NULL,932,941,NULL,'2022-10-22 11:41:59','2022-10-22 11:41:59',NULL),(933,NULL,933,942,NULL,'2022-10-22 11:42:02','2022-10-22 11:42:02',NULL),(934,NULL,934,943,NULL,'2022-10-22 11:42:05','2022-10-22 11:42:05',NULL),(935,NULL,935,944,NULL,'2022-10-22 11:42:09','2022-10-22 11:42:09',NULL),(936,NULL,936,945,NULL,'2022-10-22 11:42:12','2022-10-22 11:42:12',NULL),(937,NULL,937,946,NULL,'2022-10-22 11:42:15','2022-10-22 11:42:15',NULL),(938,NULL,938,947,NULL,'2022-10-22 11:42:19','2022-10-22 11:42:19',NULL),(939,NULL,939,948,NULL,'2022-10-22 11:42:22','2022-10-22 11:42:22',NULL),(940,NULL,940,949,NULL,'2022-10-22 11:42:25','2022-10-22 11:42:25',NULL),(941,NULL,941,950,NULL,'2022-10-22 11:42:28','2022-10-22 11:42:28',NULL),(942,NULL,942,951,NULL,'2022-10-22 11:42:32','2022-10-22 11:42:32',NULL),(943,NULL,943,952,NULL,'2022-10-22 11:42:35','2022-10-22 11:42:35',NULL),(944,NULL,944,953,NULL,'2022-10-22 11:42:38','2022-10-22 11:42:38',NULL),(945,NULL,945,954,NULL,'2022-10-22 11:42:41','2022-10-22 11:42:41',NULL),(946,NULL,946,955,NULL,'2022-10-22 11:42:44','2022-10-22 11:42:44',NULL),(947,NULL,947,956,NULL,'2022-10-22 11:42:47','2022-10-22 11:42:47',NULL),(948,NULL,948,957,NULL,'2022-10-22 11:42:50','2022-10-22 11:42:50',NULL),(949,NULL,949,958,NULL,'2022-10-22 11:42:54','2022-10-22 11:42:54',NULL),(950,NULL,950,959,NULL,'2022-10-22 11:42:57','2022-10-22 11:42:57',NULL),(951,NULL,951,960,NULL,'2022-10-22 11:43:01','2022-10-22 11:43:01',NULL),(952,NULL,952,961,NULL,'2022-10-22 11:43:04','2022-10-22 11:43:04',NULL),(953,NULL,953,962,NULL,'2022-10-22 11:43:07','2022-10-22 11:43:07',NULL),(954,NULL,954,963,NULL,'2022-10-22 11:43:10','2022-10-22 11:43:10',NULL),(955,NULL,955,964,NULL,'2022-10-22 11:43:14','2022-10-22 11:43:14',NULL),(956,NULL,956,965,NULL,'2022-10-22 11:43:17','2022-10-22 11:43:17',NULL),(957,NULL,957,966,NULL,'2022-10-22 11:43:20','2022-10-22 11:43:20',NULL),(958,NULL,958,967,NULL,'2022-10-22 11:43:24','2022-10-22 11:43:24',NULL),(959,NULL,959,968,NULL,'2022-10-22 11:43:27','2022-10-22 11:43:27',NULL),(960,NULL,960,969,NULL,'2022-10-22 11:43:30','2022-10-22 11:43:30',NULL),(961,NULL,961,970,NULL,'2022-10-22 11:43:33','2022-10-22 11:43:33',NULL),(962,NULL,962,971,NULL,'2022-10-22 11:43:36','2022-10-22 11:43:36',NULL),(963,NULL,963,972,NULL,'2022-10-22 11:43:39','2022-10-22 11:43:39',NULL),(964,NULL,964,973,NULL,'2022-10-22 11:43:43','2022-10-22 11:43:43',NULL),(965,NULL,965,974,NULL,'2022-10-22 12:17:30','2022-10-22 12:17:30',NULL),(966,NULL,966,975,NULL,'2022-10-22 12:17:33','2022-10-22 12:17:33',NULL),(967,NULL,967,976,NULL,'2022-10-22 12:17:36','2022-10-22 12:17:36',NULL),(968,NULL,968,977,NULL,'2022-10-22 12:17:39','2022-10-22 12:17:39',NULL),(969,NULL,969,978,NULL,'2022-10-22 12:17:43','2022-10-22 12:17:43',NULL),(970,NULL,970,979,NULL,'2022-10-22 12:17:46','2022-10-22 12:17:46',NULL),(971,NULL,971,980,NULL,'2022-10-22 12:17:49','2022-10-22 12:17:49',NULL),(972,NULL,972,981,NULL,'2022-10-22 12:17:53','2022-10-22 12:17:53',NULL),(973,NULL,973,982,NULL,'2022-10-22 12:17:56','2022-10-22 12:17:56',NULL),(974,NULL,974,983,NULL,'2022-10-22 12:17:59','2022-10-22 12:17:59',NULL),(975,NULL,975,984,NULL,'2022-10-22 12:18:03','2022-10-22 12:18:03',NULL),(976,NULL,976,985,NULL,'2022-10-22 12:18:06','2022-10-22 12:18:06',NULL),(977,NULL,977,986,NULL,'2022-10-22 12:18:09','2022-10-22 12:18:09',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (978,NULL,978,987,NULL,'2022-10-22 12:18:13','2022-10-22 12:18:13',NULL),(979,NULL,979,988,NULL,'2022-10-22 12:18:16','2022-10-22 12:18:16',NULL),(980,NULL,980,989,NULL,'2022-10-22 12:18:19','2022-10-22 12:18:19',NULL),(981,NULL,981,990,NULL,'2022-10-22 12:18:22','2022-10-22 12:18:22',NULL),(982,NULL,982,991,NULL,'2022-10-22 12:18:26','2022-10-22 12:18:26',NULL),(983,NULL,983,992,NULL,'2022-10-22 12:18:29','2022-10-22 12:18:29',NULL),(984,NULL,984,993,NULL,'2022-10-22 12:18:32','2022-10-22 12:18:32',NULL),(985,NULL,985,994,NULL,'2022-10-22 12:18:35','2022-10-22 12:18:35',NULL),(986,NULL,986,995,NULL,'2022-10-22 12:18:39','2022-10-22 12:18:39',NULL),(987,NULL,987,996,NULL,'2022-10-22 12:18:42','2022-10-22 12:18:42',NULL),(988,NULL,988,997,NULL,'2022-10-22 12:18:46','2022-10-22 12:18:46',NULL),(989,NULL,989,998,NULL,'2022-10-22 12:18:49','2022-10-22 12:18:49',NULL),(990,NULL,990,999,NULL,'2022-10-22 12:18:52','2022-10-22 12:18:52',NULL),(991,NULL,991,1000,NULL,'2022-10-22 12:18:55','2022-10-22 12:18:55',NULL),(992,NULL,992,1001,NULL,'2022-10-22 12:18:58','2022-10-22 12:18:58',NULL),(993,NULL,993,1002,NULL,'2022-10-22 12:19:02','2022-10-22 12:19:02',NULL),(994,NULL,994,1003,NULL,'2022-10-22 12:19:05','2022-10-22 12:19:05',NULL),(995,NULL,995,1004,NULL,'2022-10-22 12:19:08','2022-10-22 12:19:08',NULL),(996,NULL,996,1005,NULL,'2022-10-22 12:19:11','2022-10-22 12:19:11',NULL),(997,NULL,997,1006,NULL,'2022-10-22 12:19:15','2022-10-22 12:19:15',NULL),(998,NULL,998,1007,NULL,'2022-10-22 12:19:18','2022-10-22 12:19:18',NULL),(999,NULL,999,1008,NULL,'2022-10-22 12:19:21','2022-10-22 12:19:21',NULL),(1000,NULL,1000,1009,NULL,'2022-10-22 12:19:25','2022-10-22 12:19:25',NULL),(1001,NULL,1001,1010,NULL,'2022-10-22 12:19:26','2022-10-22 12:19:26',NULL),(1002,NULL,1002,1011,NULL,'2022-10-22 12:19:27','2022-10-22 12:19:27',NULL),(1003,NULL,1003,1012,NULL,'2022-10-22 12:19:28','2022-10-22 12:19:28',NULL),(1004,NULL,1004,1013,NULL,'2022-10-22 12:19:29','2022-10-22 12:19:29',NULL),(1005,NULL,1005,1014,NULL,'2022-10-22 12:19:30','2022-10-22 12:19:30',NULL),(1006,NULL,1006,1015,NULL,'2022-10-22 12:19:31','2022-10-22 12:19:31',NULL),(1007,NULL,1007,1016,NULL,'2022-10-22 12:19:32','2022-10-22 12:19:32',NULL),(1008,NULL,1008,1017,NULL,'2022-10-22 12:19:33','2022-10-22 12:19:33',NULL),(1009,NULL,1009,1018,NULL,'2022-10-22 12:19:34','2022-10-22 12:19:34',NULL),(1010,NULL,1010,1019,NULL,'2022-10-22 12:19:35','2022-10-22 12:19:35',NULL),(1011,NULL,1011,1020,NULL,'2022-10-22 12:19:36','2022-10-22 12:19:36',NULL),(1012,NULL,1012,1021,NULL,'2022-10-22 12:19:37','2022-10-22 12:19:37',NULL),(1013,NULL,1013,1022,NULL,'2022-10-22 12:19:38','2022-10-22 12:19:38',NULL),(1014,NULL,1014,1023,NULL,'2022-10-22 12:19:40','2022-10-22 12:19:40',NULL),(1015,NULL,1015,1024,NULL,'2022-10-22 12:19:41','2022-10-22 12:19:41',NULL),(1016,NULL,1016,1025,NULL,'2022-10-22 12:19:42','2022-10-22 12:19:42',NULL),(1017,NULL,1017,1026,NULL,'2022-10-22 12:19:43','2022-10-22 12:19:43',NULL),(1018,NULL,1018,1027,NULL,'2022-10-22 12:19:44','2022-10-22 12:19:44',NULL),(1019,NULL,1019,1028,NULL,'2022-10-22 12:19:46','2022-10-22 12:19:46',NULL),(1020,NULL,1020,1029,NULL,'2022-10-22 12:19:47','2022-10-22 12:19:47',NULL),(1021,NULL,1021,1030,NULL,'2022-10-22 12:19:48','2022-10-22 12:19:48',NULL),(1022,NULL,1022,1031,NULL,'2022-10-22 12:19:49','2022-10-22 12:19:49',NULL),(1023,NULL,1023,1032,NULL,'2022-10-22 12:19:50','2022-10-22 12:19:50',NULL),(1024,NULL,1024,1033,NULL,'2022-10-22 12:19:51','2022-10-22 12:19:51',NULL),(1025,NULL,1025,1034,NULL,'2022-10-22 12:19:52','2022-10-22 12:19:52',NULL),(1026,NULL,1026,1035,NULL,'2022-10-22 12:19:53','2022-10-22 12:19:53',NULL),(1027,NULL,1027,1036,NULL,'2022-10-22 12:19:54','2022-10-22 12:19:54',NULL),(1028,NULL,1028,1037,NULL,'2022-10-22 12:19:55','2022-10-22 12:19:55',NULL),(1029,NULL,1029,1038,NULL,'2022-10-22 12:19:56','2022-10-22 12:19:56',NULL),(1030,NULL,1030,1039,NULL,'2022-10-22 12:19:57','2022-10-22 12:19:57',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1031,NULL,1031,1040,NULL,'2022-10-22 12:19:58','2022-10-22 12:19:58',NULL),(1032,NULL,1032,1041,NULL,'2022-10-22 12:19:59','2022-10-22 12:19:59',NULL),(1033,NULL,1033,1042,NULL,'2022-10-22 12:20:00','2022-10-22 12:20:00',NULL),(1034,NULL,1034,1043,NULL,'2022-10-22 12:20:01','2022-10-22 12:20:01',NULL),(1035,NULL,1035,1044,NULL,'2022-10-22 12:20:02','2022-10-22 12:20:02',NULL),(1036,NULL,1036,1045,NULL,'2022-10-22 12:20:04','2022-10-22 12:20:04',NULL),(1037,NULL,1037,1046,NULL,'2022-10-22 12:20:05','2022-10-22 12:20:05',NULL),(1038,NULL,1038,1047,NULL,'2022-10-22 12:20:06','2022-10-22 12:20:06',NULL),(1039,NULL,1039,1048,NULL,'2022-10-22 12:20:07','2022-10-22 12:20:07',NULL),(1040,NULL,1040,1049,NULL,'2022-10-22 12:20:09','2022-10-22 12:20:09',NULL),(1041,NULL,1041,1050,NULL,'2022-10-22 12:20:10','2022-10-22 12:20:10',NULL),(1042,NULL,1042,1051,NULL,'2022-10-22 12:20:11','2022-10-22 12:20:11',NULL),(1043,NULL,1043,1052,NULL,'2022-10-22 12:20:12','2022-10-22 12:20:12',NULL),(1044,NULL,1044,1053,NULL,'2022-10-22 12:20:13','2022-10-22 12:20:13',NULL),(1045,NULL,1045,1054,NULL,'2022-10-22 12:20:16','2022-10-22 12:20:16',NULL),(1046,NULL,1046,1055,NULL,'2022-10-22 12:20:17','2022-10-22 12:20:17',NULL),(1047,NULL,1047,1056,NULL,'2022-10-22 12:20:18','2022-10-22 12:20:18',NULL),(1048,NULL,1048,1057,NULL,'2022-10-22 12:20:24','2022-10-22 12:20:24',NULL),(1049,NULL,1049,1058,NULL,'2022-10-22 12:20:26','2022-10-22 12:20:26',NULL),(1050,NULL,1050,1059,NULL,'2022-10-22 12:20:28','2022-10-22 12:20:28',NULL),(1051,NULL,1051,1060,NULL,'2022-10-22 12:20:30','2022-10-22 12:20:30',NULL),(1052,NULL,1052,1061,NULL,'2022-10-22 12:20:31','2022-10-22 12:20:31',NULL),(1053,NULL,1053,1062,NULL,'2022-10-22 12:20:32','2022-10-22 12:20:32',NULL),(1054,NULL,1054,1063,NULL,'2022-10-22 12:20:34','2022-10-22 12:20:34',NULL),(1055,NULL,1055,1064,NULL,'2022-10-22 12:20:35','2022-10-22 12:20:35',NULL),(1056,NULL,1056,1065,NULL,'2022-10-22 12:20:36','2022-10-22 12:20:36',NULL),(1057,NULL,1057,1066,NULL,'2022-10-22 12:20:39','2022-10-22 12:20:39',NULL),(1058,NULL,1058,1067,NULL,'2022-10-22 12:20:40','2022-10-22 12:20:40',NULL),(1059,NULL,1059,1068,NULL,'2022-10-22 12:20:44','2022-10-22 12:20:44',NULL),(1060,NULL,1060,1069,NULL,'2022-10-22 12:20:46','2022-10-22 12:20:46',NULL),(1061,NULL,1061,1070,NULL,'2022-10-22 12:20:47','2022-10-22 12:20:47',NULL),(1062,NULL,1062,1071,NULL,'2022-10-22 12:20:48','2022-10-22 12:20:48',NULL),(1063,NULL,1063,1072,NULL,'2022-10-22 12:20:49','2022-10-22 12:20:49',NULL),(1064,NULL,1064,1073,NULL,'2022-10-22 12:20:51','2022-10-22 12:20:51',NULL),(1065,NULL,1065,1074,NULL,'2022-10-22 12:20:52','2022-10-22 12:20:52',NULL),(1066,NULL,1066,1075,NULL,'2022-10-22 12:20:53','2022-10-22 12:20:53',NULL),(1067,NULL,1067,1076,NULL,'2022-10-22 12:20:54','2022-10-22 12:20:54',NULL),(1068,NULL,1068,1077,NULL,'2022-10-22 12:20:56','2022-10-22 12:20:56',NULL),(1069,NULL,1069,1078,NULL,'2022-10-22 12:20:57','2022-10-22 12:20:57',NULL),(1070,NULL,1070,1079,NULL,'2022-10-22 12:20:59','2022-10-22 12:20:59',NULL),(1071,NULL,1071,1080,NULL,'2022-10-22 12:21:00','2022-10-22 12:21:00',NULL),(1072,NULL,1072,1081,NULL,'2022-10-22 12:21:01','2022-10-22 12:21:01',NULL),(1073,NULL,1073,1082,NULL,'2022-10-22 12:21:02','2022-10-22 12:21:02',NULL),(1074,NULL,1074,1083,NULL,'2022-10-22 12:21:05','2022-10-22 12:21:05',NULL),(1075,NULL,1075,1084,NULL,'2022-10-22 12:21:07','2022-10-22 12:21:07',NULL),(1076,NULL,1076,1085,NULL,'2022-10-22 12:21:08','2022-10-22 12:21:08',NULL),(1077,NULL,1077,1086,NULL,'2022-10-22 12:21:11','2022-10-22 12:21:11',NULL),(1078,NULL,1078,1087,NULL,'2022-10-22 12:21:12','2022-10-22 12:21:12',NULL),(1079,NULL,1079,1088,NULL,'2022-10-22 12:21:14','2022-10-22 12:21:14',NULL),(1080,NULL,1080,1089,NULL,'2022-10-22 12:21:15','2022-10-22 12:21:15',NULL),(1081,NULL,1081,1090,NULL,'2022-10-22 12:21:17','2022-10-22 12:21:17',NULL),(1082,NULL,1082,1091,NULL,'2022-10-22 12:21:18','2022-10-22 12:21:18',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1083,NULL,1083,1092,NULL,'2022-10-22 12:21:19','2022-10-22 12:21:19',NULL),(1084,NULL,1084,1093,NULL,'2022-10-22 12:21:21','2022-10-22 12:21:21',NULL),(1085,NULL,1085,1094,NULL,'2022-10-22 12:21:22','2022-10-22 12:21:22',NULL),(1086,NULL,1086,1095,NULL,'2022-10-22 12:21:23','2022-10-22 12:21:23',NULL),(1087,NULL,1087,1096,NULL,'2022-10-22 12:21:25','2022-10-22 12:21:25',NULL),(1088,NULL,1088,1097,NULL,'2022-10-22 12:21:29','2022-10-22 12:21:29',NULL),(1089,NULL,1089,1098,NULL,'2022-10-22 12:21:30','2022-10-22 12:21:30',NULL),(1090,NULL,1090,1099,NULL,'2022-10-22 12:21:31','2022-10-22 12:21:31',NULL),(1091,NULL,1091,1100,NULL,'2022-10-22 12:21:33','2022-10-22 12:21:33',NULL),(1092,NULL,1092,1101,NULL,'2022-10-22 12:21:34','2022-10-22 12:21:34',NULL),(1093,NULL,1093,1102,NULL,'2022-10-22 12:21:35','2022-10-22 12:21:35',NULL),(1094,NULL,1094,1103,NULL,'2022-10-22 12:21:36','2022-10-22 12:21:36',NULL),(1095,NULL,1095,1104,NULL,'2022-10-22 12:21:37','2022-10-22 12:21:37',NULL),(1096,NULL,1096,1105,NULL,'2022-10-22 12:21:38','2022-10-22 12:21:38',NULL),(1097,NULL,1097,1106,NULL,'2022-10-22 12:21:39','2022-10-22 12:21:39',NULL),(1098,NULL,1098,1107,NULL,'2022-10-22 12:21:41','2022-10-22 12:21:41',NULL),(1099,NULL,1099,1108,NULL,'2022-10-22 12:21:42','2022-10-22 12:21:42',NULL),(1100,NULL,1100,1109,NULL,'2022-10-22 12:21:45','2022-10-22 12:21:45',NULL),(1101,NULL,1101,1110,NULL,'2022-10-22 12:21:46','2022-10-22 12:21:46',NULL),(1102,NULL,1102,1111,NULL,'2022-10-22 12:21:48','2022-10-22 12:21:48',NULL),(1103,NULL,1103,1112,NULL,'2022-10-22 12:21:49','2022-10-22 12:21:49',NULL),(1104,NULL,1104,1113,NULL,'2022-10-22 12:21:50','2022-10-22 12:21:50',NULL),(1105,NULL,1105,1114,NULL,'2022-10-22 12:21:52','2022-10-22 12:21:52',NULL),(1106,NULL,1106,1115,NULL,'2022-10-22 12:21:53','2022-10-22 12:21:53',NULL),(1107,NULL,1107,1116,NULL,'2022-10-22 12:21:54','2022-10-22 12:21:54',NULL),(1108,NULL,1108,1117,NULL,'2022-10-22 12:21:55','2022-10-22 12:21:55',NULL),(1109,NULL,1109,1118,NULL,'2022-10-22 12:21:57','2022-10-22 12:21:57',NULL),(1110,NULL,1110,1119,NULL,'2022-10-22 12:21:58','2022-10-22 12:21:58',NULL),(1111,NULL,1111,1120,NULL,'2022-10-22 12:21:58','2022-10-22 12:21:58',NULL),(1112,NULL,1112,1121,NULL,'2022-10-22 12:21:59','2022-10-22 12:21:59',NULL),(1113,NULL,1113,1122,NULL,'2022-10-22 12:22:01','2022-10-22 12:22:01',NULL),(1114,NULL,1114,1123,NULL,'2022-10-22 12:22:02','2022-10-22 12:22:02',NULL),(1115,NULL,1115,1124,NULL,'2022-10-22 12:22:03','2022-10-22 12:22:03',NULL),(1116,NULL,1116,1125,NULL,'2022-10-22 12:22:04','2022-10-22 12:22:04',NULL),(1117,NULL,1117,1126,NULL,'2022-10-22 12:22:05','2022-10-22 12:22:05',NULL),(1118,NULL,1118,1127,NULL,'2022-10-22 12:22:06','2022-10-22 12:22:06',NULL),(1119,NULL,1119,1128,NULL,'2022-10-22 12:22:08','2022-10-22 12:22:08',NULL),(1120,NULL,1120,1129,NULL,'2022-10-22 12:22:09','2022-10-22 12:22:09',NULL),(1121,NULL,1121,1130,NULL,'2022-10-22 12:22:10','2022-10-22 12:22:10',NULL),(1122,NULL,1122,1131,NULL,'2022-10-22 12:22:11','2022-10-22 12:22:11',NULL),(1123,NULL,1123,1132,NULL,'2022-10-22 12:22:12','2022-10-22 12:22:12',NULL),(1124,NULL,1124,1133,NULL,'2022-10-22 12:22:13','2022-10-22 12:22:13',NULL),(1125,NULL,1125,1134,NULL,'2022-10-22 12:22:14','2022-10-22 12:22:14',NULL),(1126,NULL,1126,1135,NULL,'2022-10-22 12:22:15','2022-10-22 12:22:15',NULL),(1127,NULL,1127,1136,NULL,'2022-10-22 12:22:16','2022-10-22 12:22:16',NULL),(1128,NULL,1128,1137,NULL,'2022-10-22 12:22:17','2022-10-22 12:22:17',NULL),(1129,NULL,1129,1138,NULL,'2022-10-22 12:22:18','2022-10-22 12:22:18',NULL),(1130,NULL,1130,1139,NULL,'2022-10-22 12:22:19','2022-10-22 12:22:19',NULL),(1131,NULL,1131,1140,NULL,'2022-10-22 12:22:21','2022-10-22 12:22:21',NULL),(1132,NULL,1132,1141,NULL,'2022-10-22 12:22:22','2022-10-22 12:22:22',NULL),(1133,NULL,1133,1142,NULL,'2022-10-22 12:22:24','2022-10-22 12:22:24',NULL),(1134,NULL,1134,1143,NULL,'2022-10-22 12:22:25','2022-10-22 12:22:25',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1135,NULL,1135,1144,NULL,'2022-10-22 12:22:26','2022-10-22 12:22:26',NULL),(1136,NULL,1136,1145,NULL,'2022-10-22 12:22:27','2022-10-22 12:22:27',NULL),(1137,NULL,1137,1146,NULL,'2022-10-22 12:22:29','2022-10-22 12:22:29',NULL),(1138,NULL,1138,1147,NULL,'2022-10-22 12:22:30','2022-10-22 12:22:30',NULL),(1139,NULL,1139,1148,NULL,'2022-10-22 12:22:31','2022-10-22 12:22:31',NULL),(1140,NULL,1140,1149,NULL,'2022-10-22 12:22:32','2022-10-22 12:22:32',NULL),(1141,NULL,1141,1150,NULL,'2022-10-22 12:22:33','2022-10-22 12:22:33',NULL),(1142,NULL,1142,1151,NULL,'2022-10-22 12:22:34','2022-10-22 12:22:34',NULL),(1143,NULL,1143,1152,NULL,'2022-10-22 12:22:35','2022-10-22 12:22:35',NULL),(1144,NULL,1144,1153,NULL,'2022-10-22 12:22:36','2022-10-22 12:22:36',NULL),(1145,NULL,1145,1154,NULL,'2022-10-22 12:22:37','2022-10-22 12:22:37',NULL),(1146,NULL,1146,1155,NULL,'2022-10-22 12:22:38','2022-10-22 12:22:38',NULL),(1147,NULL,1147,1156,NULL,'2022-10-22 12:22:39','2022-10-22 12:22:39',NULL),(1148,NULL,1148,1157,NULL,'2022-10-22 12:22:40','2022-10-22 12:22:40',NULL),(1149,NULL,1149,1158,NULL,'2022-10-22 12:22:41','2022-10-22 12:22:41',NULL),(1150,NULL,1150,1159,NULL,'2022-10-22 12:22:42','2022-10-22 12:22:42',NULL),(1151,NULL,1151,1160,NULL,'2022-10-22 12:22:43','2022-10-22 12:22:43',NULL),(1152,NULL,1152,1161,NULL,'2022-10-22 12:22:45','2022-10-22 12:22:45',NULL),(1153,NULL,1153,1162,NULL,'2022-10-22 12:22:46','2022-10-22 12:22:46',NULL),(1154,NULL,1154,1163,NULL,'2022-10-22 12:22:47','2022-10-22 12:22:47',NULL),(1155,NULL,1155,1164,NULL,'2022-10-22 12:22:48','2022-10-22 12:22:48',NULL),(1156,NULL,1156,1165,NULL,'2022-10-22 12:22:49','2022-10-22 12:22:49',NULL),(1157,NULL,1157,1166,NULL,'2022-10-22 12:22:51','2022-10-22 12:22:51',NULL),(1158,NULL,1158,1167,NULL,'2022-10-22 12:22:52','2022-10-22 12:22:52',NULL),(1159,NULL,1159,1168,NULL,'2022-10-22 12:22:53','2022-10-22 12:22:53',NULL),(1160,NULL,1160,1169,NULL,'2022-10-22 12:22:54','2022-10-22 12:22:54',NULL),(1161,NULL,1161,1170,NULL,'2022-10-22 12:22:55','2022-10-22 12:22:55',NULL),(1162,NULL,1162,1171,NULL,'2022-10-22 12:22:56','2022-10-22 12:22:56',NULL),(1163,NULL,1163,1172,NULL,'2022-10-22 12:22:57','2022-10-22 12:22:57',NULL),(1164,NULL,1164,1173,NULL,'2022-10-22 12:22:58','2022-10-22 12:22:58',NULL),(1165,NULL,1165,1174,NULL,'2022-10-22 12:22:59','2022-10-22 12:22:59',NULL),(1166,NULL,1166,1175,NULL,'2022-10-22 12:23:00','2022-10-22 12:23:00',NULL),(1167,NULL,1167,1176,NULL,'2022-10-22 12:23:01','2022-10-22 12:23:01',NULL),(1168,NULL,1168,1177,NULL,'2022-10-22 12:23:02','2022-10-22 12:23:02',NULL),(1169,NULL,1169,1178,NULL,'2022-10-22 12:23:03','2022-10-22 12:23:03',NULL),(1170,NULL,1170,1179,NULL,'2022-10-22 12:23:05','2022-10-22 12:23:05',NULL),(1171,NULL,1171,1181,NULL,'2022-10-22 12:23:06','2022-10-22 12:23:06',NULL),(1172,NULL,1172,1182,NULL,'2022-10-22 12:23:07','2022-10-22 12:23:07',NULL),(1173,NULL,1173,1183,NULL,'2022-10-22 12:23:08','2022-10-22 12:23:08',NULL),(1174,NULL,1174,1184,NULL,'2022-10-22 12:23:10','2022-10-22 12:23:10',NULL),(1175,NULL,1175,1185,NULL,'2022-10-22 12:23:11','2022-10-22 12:23:11',NULL),(1176,NULL,1176,1186,NULL,'2022-10-22 12:23:12','2022-10-22 12:23:12',NULL),(1177,NULL,1177,1187,NULL,'2022-10-22 12:23:13','2022-10-22 12:23:13',NULL),(1178,NULL,1178,1188,NULL,'2022-10-22 12:23:14','2022-10-22 12:23:14',NULL),(1179,NULL,1179,1189,NULL,'2022-10-22 12:23:15','2022-10-22 12:23:15',NULL),(1180,NULL,1180,1190,NULL,'2022-10-22 12:23:16','2022-10-22 12:23:16',NULL),(1181,NULL,1181,1191,NULL,'2022-10-22 12:23:17','2022-10-22 12:23:17',NULL),(1182,NULL,1182,1192,NULL,'2022-10-22 12:23:18','2022-10-22 12:23:18',NULL),(1183,NULL,1183,1193,NULL,'2022-10-22 12:23:19','2022-10-22 12:23:19',NULL),(1184,NULL,1184,1194,NULL,'2022-10-22 12:23:20','2022-10-22 12:23:20',NULL),(1185,NULL,1185,1195,NULL,'2022-10-22 12:23:21','2022-10-22 12:23:21',NULL),(1186,NULL,1186,1196,NULL,'2022-10-22 12:23:22','2022-10-22 12:23:22',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1187,NULL,1187,1197,NULL,'2022-10-22 12:23:23','2022-10-22 12:23:23',NULL),(1188,NULL,1188,1198,NULL,'2022-10-22 12:23:24','2022-10-22 12:23:24',NULL),(1189,NULL,1189,1199,NULL,'2022-10-22 12:23:25','2022-10-22 12:23:25',NULL),(1190,NULL,1190,1200,NULL,'2022-10-22 12:23:26','2022-10-22 12:23:26',NULL),(1191,NULL,1191,1201,NULL,'2022-10-22 12:23:28','2022-10-22 12:23:28',NULL),(1192,NULL,1192,1202,NULL,'2022-10-22 12:23:29','2022-10-22 12:23:29',NULL),(1193,NULL,1193,1203,NULL,'2022-10-22 12:23:30','2022-10-22 12:23:30',NULL),(1194,NULL,1194,1204,NULL,'2022-10-22 12:23:32','2022-10-22 12:23:32',NULL),(1195,NULL,1195,1205,NULL,'2022-10-22 12:23:33','2022-10-22 12:23:33',NULL),(1196,NULL,1196,1206,NULL,'2022-10-22 12:23:34','2022-10-22 12:23:34',NULL),(1197,NULL,1197,1207,NULL,'2022-10-22 12:23:35','2022-10-22 12:23:35',NULL),(1198,NULL,1198,1208,NULL,'2022-10-22 12:23:36','2022-10-22 12:23:36',NULL),(1199,NULL,1199,1209,NULL,'2022-10-22 12:23:37','2022-10-22 12:23:37',NULL),(1200,NULL,1200,1210,NULL,'2022-10-22 12:29:33','2022-10-22 12:29:33',NULL),(1201,NULL,1201,1211,NULL,'2022-10-22 12:29:34','2022-10-22 12:29:34',NULL),(1202,NULL,1202,1212,NULL,'2022-10-22 12:29:35','2022-10-22 12:29:35',NULL),(1203,NULL,1203,1213,NULL,'2022-10-22 12:29:36','2022-10-22 12:29:36',NULL),(1204,NULL,1204,1214,NULL,'2022-10-22 12:29:37','2022-10-22 12:29:37',NULL),(1205,NULL,1205,1215,NULL,'2022-10-22 12:29:38','2022-10-22 12:29:38',NULL),(1206,NULL,1206,1216,NULL,'2022-10-22 12:29:39','2022-10-22 12:29:39',NULL),(1207,NULL,1207,1217,NULL,'2022-10-22 12:29:40','2022-10-22 12:29:40',NULL),(1208,NULL,1208,1218,NULL,'2022-10-22 12:29:41','2022-10-22 12:29:41',NULL),(1209,NULL,1209,1219,NULL,'2022-10-22 12:29:42','2022-10-22 12:29:42',NULL),(1210,NULL,1210,1220,NULL,'2022-10-22 12:29:43','2022-10-22 12:29:43',NULL),(1211,NULL,1211,1221,NULL,'2022-10-22 12:29:44','2022-10-22 12:29:44',NULL),(1212,NULL,1212,1222,NULL,'2022-10-22 12:29:45','2022-10-22 12:29:45',NULL),(1213,NULL,1213,1223,NULL,'2022-10-22 12:29:46','2022-10-22 12:29:46',NULL),(1214,NULL,1214,1224,NULL,'2022-10-22 12:29:47','2022-10-22 12:29:47',NULL),(1215,NULL,1215,1225,NULL,'2022-10-22 12:29:48','2022-10-22 12:29:48',NULL),(1216,NULL,1216,1226,NULL,'2022-10-22 12:29:49','2022-10-22 12:29:49',NULL),(1217,NULL,1217,1227,NULL,'2022-10-22 12:29:50','2022-10-22 12:29:50',NULL),(1218,NULL,1218,1228,NULL,'2022-10-22 12:29:51','2022-10-22 12:29:51',NULL),(1219,NULL,1219,1229,NULL,'2022-10-22 12:29:53','2022-10-22 12:29:53',NULL),(1220,NULL,1220,1230,NULL,'2022-10-22 12:29:54','2022-10-22 12:29:54',NULL),(1221,NULL,1221,1231,NULL,'2022-10-22 12:29:55','2022-10-22 12:29:55',NULL),(1222,NULL,1222,1232,NULL,'2022-10-22 12:29:56','2022-10-22 12:29:56',NULL),(1223,NULL,1223,1233,NULL,'2022-10-22 12:29:57','2022-10-22 12:29:57',NULL),(1224,NULL,1224,1234,NULL,'2022-10-22 12:29:58','2022-10-22 12:29:58',NULL),(1225,NULL,1225,1235,NULL,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(1226,NULL,1226,1236,NULL,'2022-10-22 12:29:59','2022-10-22 12:29:59',NULL),(1227,NULL,1227,1237,NULL,'2022-10-22 12:30:00','2022-10-22 12:30:00',NULL),(1228,NULL,1228,1238,NULL,'2022-10-22 12:30:02','2022-10-22 12:30:02',NULL),(1229,NULL,1229,1239,NULL,'2022-10-22 12:30:03','2022-10-22 12:30:03',NULL),(1230,NULL,1230,1240,NULL,'2022-10-22 12:33:54','2022-10-22 12:33:54',NULL),(1231,NULL,1231,1241,NULL,'2022-10-22 12:33:55','2022-10-22 12:33:55',NULL),(1232,NULL,1232,1242,NULL,'2022-10-22 12:33:56','2022-10-22 12:33:56',NULL),(1233,NULL,1233,1243,NULL,'2022-10-22 12:33:58','2022-10-22 12:33:58',NULL),(1234,NULL,1234,1244,NULL,'2022-10-22 12:33:58','2022-10-22 12:33:58',NULL),(1235,NULL,1235,1245,NULL,'2022-10-22 12:33:59','2022-10-22 12:33:59',NULL),(1236,NULL,1236,1246,NULL,'2022-10-22 12:34:00','2022-10-22 12:34:00',NULL),(1237,NULL,1237,1247,NULL,'2022-10-22 12:34:01','2022-10-22 12:34:01',NULL),(1238,NULL,1238,1248,NULL,'2022-10-22 12:34:02','2022-10-22 12:34:02',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1239,NULL,1239,1249,NULL,'2022-10-22 12:34:03','2022-10-22 12:34:03',NULL),(1240,NULL,1240,1250,NULL,'2022-10-22 12:34:04','2022-10-22 12:34:04',NULL),(1241,NULL,1241,1251,NULL,'2022-10-22 12:34:06','2022-10-22 12:34:06',NULL),(1242,NULL,1242,1252,NULL,'2022-10-22 12:34:07','2022-10-22 12:34:07',NULL),(1243,NULL,1243,1253,NULL,'2022-10-22 12:34:08','2022-10-22 12:34:08',NULL),(1244,NULL,1244,1254,NULL,'2022-10-22 12:34:09','2022-10-22 12:34:09',NULL),(1245,NULL,1245,1255,NULL,'2022-10-22 12:34:11','2022-10-22 12:34:11',NULL),(1246,NULL,1246,1256,NULL,'2022-10-22 12:34:12','2022-10-22 12:34:12',NULL),(1247,NULL,1247,1257,NULL,'2022-10-22 12:34:14','2022-10-22 12:34:14',NULL),(1248,NULL,1248,1258,NULL,'2022-10-22 12:34:15','2022-10-22 12:34:15',NULL),(1249,NULL,1249,1259,NULL,'2022-10-22 12:34:16','2022-10-22 12:34:16',NULL),(1250,NULL,1250,1260,NULL,'2022-10-22 12:34:18','2022-10-22 12:34:18',NULL),(1251,NULL,1251,1261,NULL,'2022-10-22 12:34:19','2022-10-22 12:34:19',NULL),(1252,NULL,1252,1262,NULL,'2022-10-22 12:34:20','2022-10-22 12:34:20',NULL),(1253,NULL,1253,1263,NULL,'2022-10-22 12:34:22','2022-10-22 12:34:22',NULL),(1254,NULL,1254,1264,NULL,'2022-10-22 12:34:24','2022-10-22 12:34:24',NULL),(1255,NULL,1255,1265,NULL,'2022-10-22 12:34:25','2022-10-22 12:34:25',NULL),(1256,NULL,1256,1266,NULL,'2022-10-22 12:34:27','2022-10-22 12:34:27',NULL),(1257,NULL,1257,1267,NULL,'2022-10-22 12:34:28','2022-10-22 12:34:28',NULL),(1258,NULL,1258,1268,NULL,'2022-10-22 12:34:30','2022-10-22 12:34:30',NULL),(1259,NULL,1259,1269,NULL,'2022-10-22 12:34:31','2022-10-22 12:34:31',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES',1,NULL,NULL,NULL),(5,NULL,'PERCEPCIONES',1,NULL,NULL,NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,'Clientes - Deudores',0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,'Anticipos Impuesto a las Ganancias',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,'Retenciones Impuesto a las Ganancias',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(25,NULL,1,25,NULL,4,'Retenciones de IVA',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(57,NULL,1,57,NULL,8,'Proveedores en Cta. Cte. locales',0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,'Cheques emitidos ',0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(62,NULL,1,62,NULL,8,'Sueldos y Jornales a pagar',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,'Intereses y Gastos bancarios',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(162,NULL,1,162,NULL,4,'Retenciones SUSS',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(176,NULL,1,176,NULL,3,'Cheques en Cartera',1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(201,NULL,1,201,NULL,6,'Monotributo',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(203,NULL,1,203,NULL,6,'Autonomos',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(219,NULL,1,219,NULL,8,'Pagos AFIP',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,'Retenciones de IIBB Buenos Aires',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(252,NULL,1,252,NULL,4,'Retenciones de IIBB Capital Federal',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(253,NULL,1,253,NULL,4,'Retenciones de IIBB Catamarca',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(254,NULL,1,254,NULL,4,'Retenciones de IIBB Chaco',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(255,NULL,1,255,NULL,4,'Retenciones de IIBB Chubut',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(256,NULL,1,256,NULL,4,'Retenciones de IIBB Córdoba',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(257,NULL,1,257,NULL,4,'Retenciones de IIBB Corrientes',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(258,NULL,1,258,NULL,4,'Retenciones de IIBB Entre Ríos',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(259,NULL,1,259,NULL,4,'Retenciones de IIBB Formosa',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(260,NULL,1,260,NULL,4,'Retenciones de IIBB Jujuy',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(261,NULL,1,261,NULL,4,'Retenciones de IIBB La Pampa',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(262,NULL,1,262,NULL,4,'Retenciones de IIBB La Rioja',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(263,NULL,1,263,NULL,4,'Retenciones de IIBB Mendoza',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(264,NULL,1,264,NULL,4,'Retenciones de IIBB Misiones',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(265,NULL,1,265,NULL,4,'Retenciones de IIBB Neuquén',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(266,NULL,1,266,NULL,4,'Retenciones de IIBB Pascua Lama',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(267,NULL,1,267,NULL,4,'Retenciones de IIBB Río Negro',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(268,NULL,1,268,NULL,4,'Retenciones de IIBB Salta',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(269,NULL,1,269,NULL,4,'Retenciones de IIBB San Juan',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(270,NULL,1,270,NULL,4,'Retenciones de IIBB San Luis',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(271,NULL,1,271,NULL,4,'Retenciones de IIBB Santa Cruz',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (272,NULL,1,272,NULL,4,'Retenciones de IIBB Santa Fe',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(273,NULL,1,273,NULL,4,'Retenciones de IIBB Santiago del Estero',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(274,NULL,1,274,NULL,4,'Retenciones de IIBB Tierra del Fuego',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(275,NULL,1,275,NULL,4,'Retenciones de IIBB Tucuman',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(351,NULL,1,351,NULL,8,'BANCO SIRCREB',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,'Caja en Pesos',0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:14:22','2023-03-20 23:14:22'),(360,NULL,1,360,NULL,8,'Retenciones Bancarias de Ganancias a Favor',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,'Anticipo de Clientes',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,'Caja en Dolares',0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:14:22','2023-03-20 23:14:22'),(409,NULL,1,409,NULL,6,'IVA Crédito Fiscal No computable',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(418,NULL,1,418,NULL,8,'Deudas Bancarias',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,'Préstamo',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,1,441,NULL,8,'Leasing',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,1,448,NULL,8,'Planes de Pagos AFIP',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,1,450,NULL,3,'Cheques Rechazados',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(467,NULL,1,467,NULL,6,'Interés',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:48',NULL),(468,NULL,1,14,NULL,8,'Deudores por ventas comunes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(469,NULL,1,15,NULL,8,'Deudores por ventas morosos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(470,NULL,1,16,NULL,8,'Deudores en gestión judicial',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(471,NULL,1,17,NULL,8,'Previsión deudores incobrables',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(472,NULL,1,22,NULL,8,'Anticipo Impto.Ganancia Mínima Presunta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(473,NULL,1,24,NULL,4,'Impuesto a las Ganancias (Saldo a favor)',0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:54:56',NULL),(474,NULL,1,27,NULL,8,'Anticipos de proveedores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(475,NULL,1,28,NULL,8,'Depósito en garantía alquileres',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(476,NULL,1,29,NULL,8,'Derechos adquiridos a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(477,NULL,1,30,NULL,8,'Intereses a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(478,NULL,1,31,NULL,8,'Cuentas a rendir - Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(479,NULL,1,32,NULL,8,'Alquileres no devengados',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(480,NULL,1,38,NULL,8,'Equipos de computación valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(481,NULL,1,39,NULL,8,'Equipos de computación ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(482,NULL,1,40,NULL,8,'Amortización Acumulada Equipos de comput.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(483,NULL,1,42,NULL,8,'Instalaciones valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(484,NULL,1,43,NULL,8,'Instalaciones ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(485,NULL,1,44,NULL,8,'Amortización Acumulada Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (486,NULL,1,46,NULL,8,'Muebles y utiles valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(487,NULL,1,47,NULL,8,'Muebles y utiles ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(488,NULL,1,48,NULL,8,'Amortización Acumulada Muebles y Útiles',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(489,NULL,1,50,NULL,8,'Gastos de organización valores historicos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(490,NULL,1,51,NULL,8,'Gastos de organización ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(491,NULL,1,52,NULL,8,'Amortización acumulada gs. de organización',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(492,NULL,1,58,NULL,8,'Proveedores en cta. cte. exterior',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(493,NULL,1,59,NULL,8,'Derechos de exhibición a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(494,NULL,1,63,NULL,8,'Cargas sociales a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(495,NULL,1,64,NULL,8,'Sindicatos a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(496,NULL,1,67,NULL,8,'IVA Debito Fiscal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(497,NULL,1,68,NULL,8,'IVA Credito Fiscal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(498,NULL,1,69,NULL,8,'Impuestos Internos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(499,NULL,1,70,NULL,8,'Impuestos al Combustible',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(500,NULL,1,71,NULL,8,'IVA Retenciones de terceros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(501,NULL,1,72,NULL,5,'IVA Percepciones realiz.por terceros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(502,NULL,1,73,NULL,8,'IVA Saldo a favor',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(503,NULL,1,74,NULL,8,'IVA a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(504,NULL,1,75,NULL,5,'Percepciones Ingresos Brutos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(505,NULL,1,76,NULL,8,'Otros Pagos AFIP',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(506,NULL,1,78,NULL,8,'Impuesto a los Ingresos Brutos Pasivo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(507,NULL,1,79,NULL,8,'Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(508,NULL,1,80,NULL,8,'Impuesto a la Ganancia Mínima Presunta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(509,NULL,1,81,NULL,8,'AFIP - Retenciones Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(510,NULL,1,82,NULL,8,'AFIP - Plan de Facilidades Decreto 338/02',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(511,NULL,1,87,NULL,8,'Acciones en circulación',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(512,NULL,1,88,NULL,8,'Ajuste del Capital',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(513,NULL,1,89,NULL,8,'Aportes Irrevocables Futuras Suscripciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(514,NULL,1,91,NULL,8,'Resultado del ejercicio',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(515,NULL,1,92,NULL,8,'Resultado ejercicios anteriores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(516,NULL,1,93,NULL,8,'A.R.E.A.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(517,NULL,1,96,NULL,7,'VENTAS',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(518,NULL,1,97,NULL,7,'Honorarios',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(519,NULL,1,99,NULL,7,'Descuentos obtenidos',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (520,NULL,1,100,NULL,7,'Reintegros por exportaciones',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(521,NULL,1,102,NULL,7,'Intereses Cobrados',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(522,NULL,1,103,NULL,7,'Diferencias de cambio',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(523,NULL,1,104,NULL,7,'Descuentos obtenidos',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(524,NULL,1,110,NULL,6,'Sueldos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(525,NULL,1,111,NULL,6,'Contribuciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(526,NULL,1,112,NULL,6,'Sindicato',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(527,NULL,1,114,NULL,8,'ACA',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(528,NULL,1,115,NULL,6,'Aereos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(529,NULL,1,116,NULL,6,'Alquiler',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(530,NULL,1,117,NULL,8,'AGUA AYSA',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(531,NULL,1,118,NULL,8,'TV Cablevision',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(532,NULL,1,119,NULL,1,'Caja Jubilacion Consejo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(533,NULL,1,120,NULL,6,'Celulares',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(534,NULL,1,121,NULL,3,'Cheques',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(535,NULL,1,123,NULL,8,'Comida',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(536,NULL,1,126,NULL,6,'Fletes y acarreos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(537,NULL,1,127,NULL,8,'Luz Edesur',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(538,NULL,1,128,NULL,6,'Movilidad y Viáticos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(539,NULL,1,129,NULL,8,'Mantenimiento',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(540,NULL,1,130,NULL,8,'IVA No Computable',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(541,NULL,1,131,NULL,8,'Entretenimiento',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(542,NULL,1,132,NULL,6,'Amortización Bienes de Uso',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(543,NULL,1,135,NULL,6,'Gastos varios',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(544,NULL,1,136,NULL,6,'Ajuste por redondeo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(545,NULL,1,137,NULL,6,'Deudores Incobrables',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(546,NULL,1,141,NULL,6,'Intereses Proveedores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(547,NULL,1,143,NULL,6,'Diferencias de cambio',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(548,NULL,1,144,NULL,8,'Diferencia de Cambio Bces. en M.Extranjera',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(549,NULL,1,145,NULL,6,'Diferencia tipo cambio Vendedor/Comprador',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(550,NULL,1,146,NULL,8,'Diferencia por conversion en Bce. en Mon. Extranj.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(551,NULL,1,147,NULL,8,'Diferencia de cambio CMV',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(552,NULL,1,148,NULL,8,'Diferencia de cambio PT',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(553,NULL,1,149,NULL,8,'Resultado por Exposición a la Inflación',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(554,NULL,1,150,NULL,8,'Diferencia de cambio PE',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(555,NULL,1,151,NULL,8,'Diferencia de cambio Ds.Vtas.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (556,NULL,1,152,NULL,6,'Diferencia de cambio ME',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(557,NULL,1,153,NULL,6,'Descuentos otorgados',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(558,NULL,1,155,NULL,6,'Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(559,NULL,1,156,NULL,6,'Impuesto a los Ingresos Brutos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(560,NULL,1,157,NULL,6,'Impuesto al Debito y Credito Bancario',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(561,NULL,1,159,NULL,6,'Pérdida por venta bienes de uso',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(562,NULL,1,160,NULL,6,'Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(563,NULL,1,161,NULL,6,'Amortizaciones extraordinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(564,NULL,1,178,NULL,8,'Google',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(565,NULL,1,188,NULL,6,'Publicidad',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(566,NULL,1,191,NULL,6,'Cargas Sociales',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(567,NULL,1,192,NULL,6,'Honorarios',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(568,NULL,1,193,NULL,6,'Telefono Fijo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(569,NULL,1,198,NULL,6,'Seguros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(570,NULL,1,199,NULL,6,'Internet',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(571,NULL,1,204,NULL,6,'Multas Impositivas',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(572,NULL,1,208,NULL,6,'Impuesto a los Ingresos Brutos - BS AS',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(573,NULL,1,209,NULL,6,'SIRCREB',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(574,NULL,1,212,NULL,6,'Tarjeta Visa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(575,NULL,1,213,NULL,6,'Tarjeta American Express',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(576,NULL,1,214,NULL,6,'Tarjeta Mastercard',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(577,NULL,1,215,NULL,8,'Tarjeta Shopping',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(578,NULL,1,216,NULL,6,'Tarjeta Cencosud',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(579,NULL,1,217,NULL,6,'Compras',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(580,NULL,1,218,NULL,7,'Ventas No Gravadas',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(581,NULL,1,220,NULL,5,'Perc IVA -RG3337',0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:54:56',NULL),(582,NULL,1,221,NULL,6,'Imps. Internos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(583,NULL,1,222,NULL,6,'Imp. Gasoil',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(584,NULL,1,223,NULL,6,'Imp. Hídricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(585,NULL,1,224,NULL,6,'ITC',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(586,NULL,1,225,NULL,5,'Perc IIBB  Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(587,NULL,1,226,NULL,5,'Perc IIBB  Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(588,NULL,1,227,NULL,5,'Perc IIBB  Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(589,NULL,1,228,NULL,5,'Perc IIBB  Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(590,NULL,1,229,NULL,5,'Perc IIBB  Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(591,NULL,1,230,NULL,5,'Perc IIBB  Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(592,NULL,1,231,NULL,5,'Perc IIBB  Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (593,NULL,1,232,NULL,5,'Perc IIBB  Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(594,NULL,1,233,NULL,5,'Perc IIBB  Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(595,NULL,1,234,NULL,5,'Perc IIBB  Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(596,NULL,1,235,NULL,5,'Perc IIBB  La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(597,NULL,1,236,NULL,5,'Perc IIBB  La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(598,NULL,1,237,NULL,5,'Perc IIBB  Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(599,NULL,1,238,NULL,5,'Perc IIBB  Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(600,NULL,1,239,NULL,5,'Perc IIBB  Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(601,NULL,1,240,NULL,5,'Perc IIBB  Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(602,NULL,1,241,NULL,5,'Perc IIBB  Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(603,NULL,1,242,NULL,5,'Perc IIBB  Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(604,NULL,1,243,NULL,5,'Perc IIBB  San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(605,NULL,1,244,NULL,5,'Perc IIBB  San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(606,NULL,1,245,NULL,5,'Perc IIBB  Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(607,NULL,1,246,NULL,5,'Perc IIBB  Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(608,NULL,1,247,NULL,5,'Perc IIBB  Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(609,NULL,1,248,NULL,5,'Perc IIBB  Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(610,NULL,1,249,NULL,5,'Perc IIBB  Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(611,NULL,1,250,NULL,6,'Compras No Gravadas',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(612,NULL,1,276,NULL,6,'SIRCREB Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(613,NULL,1,277,NULL,6,'SIRCREB Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(614,NULL,1,278,NULL,6,'SIRCREB Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(615,NULL,1,279,NULL,6,'SIRCREB Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(616,NULL,1,280,NULL,6,'SIRCREB Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(617,NULL,1,281,NULL,6,'SIRCREB Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(618,NULL,1,282,NULL,6,'SIRCREB Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(619,NULL,1,283,NULL,6,'SIRCREB Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(620,NULL,1,284,NULL,6,'SIRCREB Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(621,NULL,1,285,NULL,6,'SIRCREB Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(622,NULL,1,286,NULL,6,'SIRCREB La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(623,NULL,1,287,NULL,6,'SIRCREB La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(624,NULL,1,288,NULL,6,'SIRCREB Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(625,NULL,1,289,NULL,6,'SIRCREB Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(626,NULL,1,290,NULL,6,'SIRCREB Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(627,NULL,1,291,NULL,6,'SIRCREB Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(628,NULL,1,292,NULL,6,'SIRCREB Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (629,NULL,1,293,NULL,6,'SIRCREB Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(630,NULL,1,294,NULL,6,'SIRCREB San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(631,NULL,1,295,NULL,6,'SIRCREB San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(632,NULL,1,296,NULL,6,'SIRCREB Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(633,NULL,1,297,NULL,6,'SIRCREB Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(634,NULL,1,298,NULL,6,'SIRCREB Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(635,NULL,1,299,NULL,6,'SIRCREB Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(636,NULL,1,300,NULL,6,'SIRCREB Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(637,NULL,1,301,NULL,8,'IIBB a Favor Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(638,NULL,1,302,NULL,8,'IIBB a Favor Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(639,NULL,1,303,NULL,8,'IIBB a Favor Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(640,NULL,1,304,NULL,8,'IIBB a Favor Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(641,NULL,1,305,NULL,8,'IIBB a Favor Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(642,NULL,1,306,NULL,8,'IIBB a Favor Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:48',NULL),(643,NULL,1,307,NULL,8,'IIBB a Favor Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:49',NULL),(644,NULL,1,308,NULL,8,'IIBB a Favor Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:49',NULL),(645,NULL,1,309,NULL,8,'IIBB a Favor Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:49',NULL),(646,NULL,1,310,NULL,8,'IIBB a Favor Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:49',NULL),(647,NULL,1,311,NULL,8,'IIBB a Favor La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:49',NULL),(648,NULL,1,312,NULL,8,'IIBB a Favor La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:49',NULL),(649,NULL,1,313,NULL,8,'IIBB a Favor Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:49',NULL),(650,NULL,1,314,NULL,8,'IIBB a Favor Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(651,NULL,1,315,NULL,8,'IIBB a Favor Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(652,NULL,1,316,NULL,8,'IIBB a Favor Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(653,NULL,1,317,NULL,8,'IIBB a Favor Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(654,NULL,1,318,NULL,8,'IIBB a Favor Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(655,NULL,1,319,NULL,8,'IIBB a Favor San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(656,NULL,1,320,NULL,8,'IIBB a Favor San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(657,NULL,1,321,NULL,8,'IIBB a Favor Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(658,NULL,1,322,NULL,8,'IIBB a Favor Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(659,NULL,1,323,NULL,8,'IIBB a Favor Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(660,NULL,1,324,NULL,8,'IIBB a Favor Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(661,NULL,1,325,NULL,8,'IIBB a Favor Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(662,NULL,1,326,NULL,8,'IIBB a Pagar Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(663,NULL,1,327,NULL,8,'IIBB a Pagar Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (664,NULL,1,328,NULL,8,'IIBB a Pagar Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(665,NULL,1,329,NULL,8,'IIBB a Pagar Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(666,NULL,1,330,NULL,8,'IIBB a Pagar Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(667,NULL,1,331,NULL,8,'IIBB a Pagar Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(668,NULL,1,332,NULL,8,'IIBB a Pagar Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(669,NULL,1,333,NULL,8,'IIBB a Pagar Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(670,NULL,1,334,NULL,8,'IIBB a Pagar Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(671,NULL,1,335,NULL,8,'IIBB a Pagar Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(672,NULL,1,336,NULL,8,'IIBB a Pagar La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(673,NULL,1,337,NULL,8,'IIBB a Pagar La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(674,NULL,1,338,NULL,8,'IIBB a Pagar Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(675,NULL,1,339,NULL,8,'IIBB a Pagar Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(676,NULL,1,340,NULL,8,'IIBB a Pagar Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(677,NULL,1,341,NULL,8,'IIBB a Pagar Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(678,NULL,1,342,NULL,8,'IIBB a Pagar Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(679,NULL,1,343,NULL,8,'IIBB a Pagar Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(680,NULL,1,344,NULL,8,'IIBB a Pagar San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(681,NULL,1,345,NULL,8,'IIBB a Pagar San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(682,NULL,1,346,NULL,8,'IIBB a Pagar Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(683,NULL,1,347,NULL,8,'IIBB a Pagar Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(684,NULL,1,348,NULL,8,'IIBB a Pagar Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(685,NULL,1,349,NULL,8,'IIBB a Pagar Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(686,NULL,1,350,NULL,8,'IIBB a Pagar Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(687,NULL,1,352,NULL,8,'Compensacion',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(688,NULL,1,353,NULL,8,'IVA Saldo Tecnico',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(689,NULL,1,354,NULL,8,'IVA Saldo Libre Disponibilidad',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(690,NULL,1,361,NULL,8,'Equipos de Computación',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(691,NULL,1,362,NULL,8,'Computadoras',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(692,NULL,1,363,NULL,8,'Muebles y Utiles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(693,NULL,1,365,NULL,8,'Provision Honorarios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(694,NULL,1,366,NULL,8,'Cta. Cte Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(695,NULL,1,367,NULL,8,'Provisión Honorarios Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(696,NULL,1,368,NULL,8,'Cuenta Particular Socio 1',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(697,NULL,1,369,NULL,8,'Capital',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(698,NULL,1,380,NULL,8,'Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(699,NULL,1,381,NULL,8,'Reserva Legal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (700,NULL,1,382,NULL,8,'Reserva Legal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(701,NULL,1,383,NULL,8,'Resultado no asignado',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(702,NULL,1,386,NULL,8,'PLAZO FIJO',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(703,NULL,1,388,NULL,8,'ACCIONES',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(704,NULL,1,389,NULL,8,'Inmuebles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(705,NULL,1,390,NULL,8,'Vehiculos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(706,NULL,1,391,NULL,8,'Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(707,NULL,1,392,NULL,8,'MERCADERIAS',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(708,NULL,1,393,NULL,8,'OTROS',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(709,NULL,1,395,NULL,8,'Cuenta Particular Socio 2',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(710,NULL,1,396,NULL,6,'Comisiones Y gastos Bancarios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(711,NULL,1,411,NULL,8,'Provisión Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(712,NULL,1,412,NULL,6,'Amortización Muebles y Útiles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(713,NULL,1,413,NULL,6,'Amortización Equipos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(714,NULL,1,414,NULL,8,'Amortizacion Acumulada Equipos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(715,NULL,1,415,NULL,8,'Amortización Acumulada Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(716,NULL,1,416,NULL,8,'Materias Primas',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(717,NULL,1,419,NULL,8,'Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(718,NULL,1,420,NULL,8,'Amortización Acumulada Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(719,NULL,1,421,NULL,8,'Amortización Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(720,NULL,1,422,NULL,8,'Amortización Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(721,NULL,1,423,NULL,8,'Accesorios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(722,NULL,1,424,NULL,8,'Amortización Acumulada Accesorios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(723,NULL,1,426,NULL,8,'Reserva Facultativa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(724,NULL,1,427,NULL,8,'Créditos por Impuestos Diferidos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(725,NULL,1,428,NULL,8,'Fondo de Comercio',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(726,NULL,1,429,NULL,8,'Amortizacion Acumulada Fondo de Comercio',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(727,NULL,1,430,NULL,8,'Intereses a devengar AGIP',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(728,NULL,1,431,NULL,8,'PFP IIBB',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(729,NULL,1,434,NULL,8,'Productos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(730,NULL,1,435,NULL,8,'Intereses a devengar PFP',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(731,NULL,1,437,NULL,8,'Imp. Ley 25413 Cred 0.6%',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(732,NULL,1,438,NULL,8,'Honorarios Directorio a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(733,NULL,1,439,NULL,8,'Reserva para Futuras Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(734,NULL,1,440,NULL,8,'TEAC - Trabajos Ejecutados a Certificar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (735,NULL,1,444,NULL,8,'Banco Santander Rio Cta Cte',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(736,NULL,1,449,NULL,8,'Leasing',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(737,NULL,1,453,NULL,8,'Inversión Central Caribe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(738,NULL,1,454,NULL,8,'Otras Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(739,NULL,1,455,NULL,8,'Otros Créditos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(740,NULL,1,456,NULL,8,'Provisión Honorarios Socio Gerente',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(741,NULL,1,459,NULL,8,'Moratoria SUSS a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(742,NULL,1,460,NULL,8,'Impuestos Municipales a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(743,NULL,1,461,NULL,6,'Amortización Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(744,NULL,1,462,NULL,8,'Amortización Equipos de comput.',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(745,NULL,1,463,NULL,8,'Cuenta Particular Socio 3',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(746,NULL,1,464,NULL,8,'Cuenta Particular Socio 4',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(747,NULL,1,465,NULL,8,'Otras Reservas',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(748,NULL,1,466,NULL,8,'IGMP (Saldo a Favor)',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(749,NULL,1,468,NULL,8,'Productos en Proceso',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(750,NULL,1,469,NULL,8,'Depósitos en Garantía Socio Gerente',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(751,NULL,1,470,NULL,8,'Fondos Embargados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(752,NULL,1,471,NULL,8,'Cuota Solid.',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(753,NULL,1,472,NULL,8,'Anticipo Honorarios Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(754,NULL,1,473,NULL,8,'SICORE a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(755,NULL,1,476,NULL,6,'RECPAM',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL),(756,NULL,1,478,NULL,6,'CO2 - Imp. Al Carbono',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:49',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRE