-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-28869304-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-09-05 16:45:13','Actividad Generica 1','000001',NULL),(2,NULL,'2022-09-05 16:45:13','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'leoncito','20288693049',NULL,1,40719,'2022-09-07'),(2,'leoncito','20288693049',NULL,1,40719,'2022-09-07'),(3,'leoncito','20288693049',NULL,1,40719,'2022-09-16'),(4,'leoncito','20288693049',NULL,1,40719,'2022-09-26'),(5,'leoncito','20288693049',NULL,1,40719,'2022-09-26'),(6,'leoncito','20288693049',NULL,1,40719,'2022-09-26'),(7,'leoncito','20288693049',NULL,1,40719,'2022-09-26'),(8,'leoncito','20288693049',NULL,1,40719,'2022-09-26'),(9,'leoncito','20288693049',NULL,1,40719,'2022-09-27'),(10,'leoncito','20288693049',NULL,1,40719,'2022-09-27'),(11,'leoncito','20288693049',NULL,1,40719,'2022-10-29');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'diegozarahe@gmail.com','1128491093',NULL,1,40719,'2022-09-07'),(2,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-07'),(3,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-07'),(4,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-07'),(5,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-07'),(6,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-16'),(7,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-26'),(8,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-26'),(9,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-26'),(10,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-26'),(11,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-26'),(12,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-27'),(13,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-09-27'),(14,'diegozarahe@gmail.com','1128491093','',1,40719,'2022-10-29');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=551 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7777,40719,11,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',121.00,NULL,NULL,1,'2022-09-08 10:30:29','2022-09-08 10:40:46','2022-09-08 10:40:46'),(2,7777,40719,11,3,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',1310.90,NULL,NULL,1,'2022-09-08 10:40:18','2022-09-26 19:10:04','2022-09-26 19:10:04'),(3,7777,40719,11,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2420.00,NULL,NULL,1,'2022-09-08 10:40:46','2022-09-26 19:09:49','2022-09-26 19:09:49'),(4,7777,40719,11,21,NULL,NULL,NULL,4,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',1310.09,NULL,NULL,1,'2022-09-08 11:42:06','2022-09-08 11:46:20','2022-09-08 11:46:20'),(5,7777,40719,11,21,NULL,NULL,NULL,5,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',1310.90,NULL,NULL,1,'2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(6,NULL,40719,1661,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3025.00,NULL,NULL,1,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(7,NULL,40719,1661,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',11797.50,NULL,NULL,1,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(8,NULL,40719,1661,2,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',193600.00,NULL,NULL,1,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(9,NULL,40719,1661,2,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',73872.48,NULL,NULL,1,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(10,NULL,40719,1661,2,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4094.00,NULL,NULL,1,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(11,NULL,40719,1661,2,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2420.00,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(12,NULL,40719,1661,2,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2521.50,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(13,NULL,40719,1661,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2420.00,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(14,NULL,40719,1661,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',15730.00,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(15,NULL,40719,1661,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55660.00,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(16,NULL,40719,1661,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55660.00,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(17,NULL,40719,1661,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2964.50,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(18,NULL,40719,1661,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5747.50,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(19,NULL,40719,1661,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8288.50,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(20,NULL,40719,1661,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',1914704.00,NULL,NULL,1,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(21,NULL,40719,1661,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',315810.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(22,NULL,40719,1661,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',79376.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(23,NULL,40719,1661,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',79376.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10');
INSERT INTO `balance_libro` VALUES (24,NULL,40719,1661,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',83732.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(25,NULL,40719,1661,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',81917.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(26,NULL,40719,1661,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',77440.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(27,NULL,40719,1661,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3751.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(28,NULL,40719,1661,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',157865.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(29,NULL,40719,1661,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',30250.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(30,NULL,40719,1661,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',285560.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(31,NULL,40719,1661,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',36300.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(32,NULL,40719,1661,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',62097.20,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(33,NULL,40719,1661,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26620.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(34,NULL,40719,1661,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49740.08,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(35,NULL,40719,1661,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',123178.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(36,NULL,40719,1661,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19360.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(37,NULL,40719,1661,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',84276.50,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(38,NULL,40719,1661,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',6243.60,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(39,NULL,40719,1661,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23353.00,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(40,NULL,40719,1661,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',25711.29,NULL,NULL,1,'2022-09-27 10:52:58','2022-09-27 13:28:11','2022-09-27 13:28:11'),(41,NULL,40719,1661,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',76862.27,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(42,NULL,40719,1661,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111467.62,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(43,NULL,40719,1661,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',655.05,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(44,NULL,40719,1661,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3899.71,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(45,NULL,40719,1661,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',83228.88,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `balance_libro` VALUES (46,NULL,40719,1661,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',93207.27,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(47,NULL,40719,1661,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',546315.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(48,NULL,40719,1661,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',62338.60,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(49,NULL,40719,1661,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26059.77,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(50,NULL,40719,1661,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4456.91,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(51,NULL,40719,1661,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5082.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(52,NULL,40719,1661,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',180048.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(53,NULL,40719,1661,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',45012.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(54,NULL,40719,1661,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',290400.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(55,NULL,40719,1661,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',188760.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(56,NULL,40719,1661,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',425920.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(57,NULL,40719,1661,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',25410.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(58,NULL,40719,1661,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',133100.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(59,NULL,40719,1661,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',708329.14,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(60,NULL,40719,1661,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',77319.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(61,NULL,40719,1661,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5666.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(62,NULL,40719,1661,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2200.00,NULL,NULL,1,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(63,NULL,40719,1661,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',230.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(64,NULL,40719,1661,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',37200.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(65,NULL,40719,1661,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',75867.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(66,NULL,40719,1661,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49005.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(67,NULL,40719,1661,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',106480.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `balance_libro` VALUES (68,NULL,40719,1661,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52514.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(69,NULL,40719,1661,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',42579.90,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(70,NULL,40719,1661,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',263632.38,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(71,NULL,40719,1661,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52514.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(72,NULL,40719,1661,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',337206.43,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(73,NULL,40719,1661,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',344850.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(74,NULL,40719,1661,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',114950.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(75,NULL,40719,1661,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',136125.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(76,NULL,40719,1661,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',120516.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(77,NULL,40719,1661,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',31218.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(78,NULL,40719,1661,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52635.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(79,NULL,40719,1661,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52635.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(80,NULL,40719,1661,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19360.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(81,NULL,40719,1661,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',236857.50,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(82,NULL,40719,1661,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',115434.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(83,NULL,40719,1661,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',87120.00,NULL,NULL,1,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(84,NULL,40719,1661,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111804.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(85,NULL,40719,1661,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111804.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(86,NULL,40719,1661,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',172425.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(87,NULL,40719,1661,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111804.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(88,NULL,40719,1661,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111804.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(89,NULL,40719,1661,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',154880.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `balance_libro` VALUES (90,NULL,40719,1661,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',50820.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(91,NULL,40719,1661,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',74899.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(92,NULL,40719,1661,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23232.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(93,NULL,40719,1661,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',93899.03,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(94,NULL,40719,1661,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26777.30,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(95,NULL,40719,1661,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',27104.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(96,NULL,40719,1661,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',92516.60,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(97,NULL,40719,1661,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',20424.80,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(98,NULL,40719,1661,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',13068.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(99,NULL,40719,1661,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',13068.00,NULL,NULL,1,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(100,NULL,40719,1661,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',17351.40,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(101,NULL,40719,1661,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',94864.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(102,NULL,40719,1661,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',36300.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(103,NULL,40719,1661,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19965.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(104,NULL,40719,1661,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',36300.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(105,NULL,40719,1661,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',1169918.75,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(106,NULL,40719,1661,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21780.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(107,NULL,40719,1661,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',75020.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(108,NULL,40719,1661,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',130680.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(109,NULL,40719,1661,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',60802.50,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(110,NULL,40719,1661,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',18150.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(111,NULL,40719,1661,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',37510.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `balance_libro` VALUES (112,NULL,40719,1661,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',79376.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(113,NULL,40719,1661,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',85184.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(114,NULL,40719,1661,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',42592.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(115,NULL,40719,1661,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',99480.15,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(116,NULL,40719,1661,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',170610.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(117,NULL,40719,1661,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',83187.50,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(118,NULL,40719,1661,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',45375.00,NULL,NULL,1,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(119,NULL,40719,1661,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23837.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(120,NULL,40719,1661,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33275.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(121,NULL,40719,1661,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',125840.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(122,NULL,40719,1661,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10890.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(123,NULL,40719,1661,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21175.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(124,NULL,40719,1661,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52030.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(125,NULL,40719,1661,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',59622.75,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(126,NULL,40719,1661,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26620.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(127,NULL,40719,1661,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',228690.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(128,NULL,40719,1661,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49489.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(129,NULL,40719,1661,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',231310.86,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(130,NULL,40719,1661,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',231310.86,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(131,NULL,40719,1661,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',108280.48,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(132,NULL,40719,1661,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',195339.98,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(133,NULL,40719,1661,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',108658.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `balance_libro` VALUES (134,NULL,40719,1661,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',66792.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(135,NULL,40719,1661,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',104181.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(136,NULL,40719,1661,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',142538.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(137,NULL,40719,1661,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21538.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(138,NULL,40719,1661,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',18755.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(139,NULL,40719,1661,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',43076.00,NULL,NULL,1,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(140,NULL,40719,1661,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33880.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(141,NULL,40719,1661,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',53542.50,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(142,NULL,40719,1661,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',7562.50,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(143,NULL,40719,1661,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',68244.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(144,NULL,40719,1661,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21780.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(145,NULL,40719,1661,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21780.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(146,NULL,40719,1661,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52635.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(147,NULL,40719,1661,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33759.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(148,NULL,40719,1661,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',122815.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(149,NULL,40719,1661,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',65340.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(150,NULL,40719,1661,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',427372.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(151,NULL,40719,1661,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',6776.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(152,NULL,40719,1661,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',175450.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(153,NULL,40719,1661,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',65340.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(154,NULL,40719,1661,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',300080.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(155,NULL,40719,1661,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33759.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13');
INSERT INTO `balance_libro` VALUES (156,NULL,40719,1661,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',65340.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(157,NULL,40719,1661,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49005.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(158,NULL,40719,1661,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',350900.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(159,NULL,40719,1661,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',459679.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(160,NULL,40719,1661,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',36300.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(161,NULL,40719,1661,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',363000.00,NULL,NULL,1,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(162,NULL,40719,1661,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33880.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(163,NULL,40719,1661,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',83079.64,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(164,NULL,40719,1661,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',54450.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(165,NULL,40719,1661,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',62436.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(166,NULL,40719,1661,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',41624.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(167,NULL,40719,1661,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',62436.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(168,NULL,40719,1661,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',16940.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(169,NULL,40719,1661,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',63888.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(170,NULL,40719,1661,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',85184.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(171,NULL,40719,1661,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',20812.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(172,NULL,40719,1661,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',39954.20,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(173,NULL,40719,1661,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',41745.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(174,NULL,40719,1661,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21780.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(175,NULL,40719,1661,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9075.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(176,NULL,40719,1661,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',30250.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(177,NULL,40719,1661,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9075.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13');
INSERT INTO `balance_libro` VALUES (178,NULL,40719,1661,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9075.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(179,NULL,40719,1661,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',521985.03,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(180,NULL,40719,1661,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9378.24,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(181,NULL,40719,1661,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',324280.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(182,NULL,40719,1661,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8131.20,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(183,NULL,40719,1661,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',11253.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(184,NULL,40719,1661,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55660.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(185,NULL,40719,1661,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5995.49,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(186,NULL,40719,1661,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',58080.00,NULL,NULL,1,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(187,NULL,40719,1661,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',87120.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(188,NULL,40719,1661,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4954.95,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(189,NULL,40719,1661,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5995.49,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(190,NULL,40719,1661,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',69696.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(191,NULL,40719,1661,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2377274.90,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(192,NULL,40719,1661,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55935.88,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(193,NULL,40719,1661,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10466.50,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(194,NULL,40719,1661,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',265595.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(195,NULL,40719,1661,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',78529.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(196,NULL,40719,1661,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',302258.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(197,NULL,40719,1661,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',18755.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(198,NULL,40719,1661,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',64800.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(199,NULL,40719,1661,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',7744.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14');
INSERT INTO `balance_libro` VALUES (200,NULL,40719,1661,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',22597.96,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(201,NULL,40719,1661,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',98010.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(202,NULL,40719,1661,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10587.50,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(203,NULL,40719,1661,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23716.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(204,NULL,40719,1661,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23716.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(205,NULL,40719,1661,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',70180.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(206,NULL,40719,1661,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',67518.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(207,NULL,40719,1661,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',38115.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(208,NULL,40719,1661,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',25192.20,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(209,NULL,40719,1661,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10164.00,NULL,NULL,1,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(210,NULL,40719,1661,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19602.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(211,NULL,40719,1661,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',38750.25,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(212,NULL,40719,1661,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19602.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(213,NULL,40719,1661,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',63525.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(214,NULL,40719,1661,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',159132.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(215,NULL,40719,1661,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26680.50,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(216,NULL,40719,1661,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',38115.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(217,NULL,40719,1661,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',18755.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(218,NULL,40719,1661,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',13320.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(219,NULL,40719,1661,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',46464.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(220,NULL,40719,1661,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',208725.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(221,NULL,40719,1661,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',208725.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15');
INSERT INTO `balance_libro` VALUES (222,NULL,40719,1661,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',202917.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(223,NULL,40719,1661,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3751.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(224,NULL,40719,1661,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',125840.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(225,NULL,40719,1661,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',937.75,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(226,NULL,40719,1661,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',937.75,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(227,NULL,40719,1661,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',176418.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(228,NULL,40719,1661,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8228.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(229,NULL,40719,1661,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55660.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(230,NULL,40719,1661,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',100963.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(231,NULL,40719,1661,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',42350.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(232,NULL,40719,1661,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5372.40,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(233,NULL,40719,1661,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',44528.00,NULL,NULL,1,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(234,NULL,40719,1661,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',802130.18,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(235,NULL,40719,1661,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',172546.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(236,NULL,40719,1661,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',77440.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(237,NULL,40719,1661,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9982.50,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(238,NULL,40719,1661,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',50820.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(239,NULL,40719,1661,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19602.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(240,NULL,40719,1661,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',296401.60,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(241,NULL,40719,1661,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',296401.60,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(242,NULL,40719,1661,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',159720.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(243,NULL,40719,1661,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',48400.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15');
INSERT INTO `balance_libro` VALUES (244,NULL,40719,1661,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',164196.03,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(245,NULL,40719,1661,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',163350.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(246,NULL,40719,1661,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',254100.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(247,NULL,40719,1661,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',16607.25,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(248,NULL,40719,1661,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26317.50,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(249,NULL,40719,1661,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',286044.00,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(250,NULL,40719,1661,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5263.50,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(251,NULL,40719,1661,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',340765.04,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(252,NULL,40719,1661,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',171576.79,NULL,NULL,1,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(253,NULL,40719,1661,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',142296.00,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(254,NULL,40719,1661,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49005.00,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(255,NULL,40719,1661,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',17800.00,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(256,NULL,40719,1661,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',29516.26,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(257,NULL,40719,1661,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',29516.26,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(258,NULL,40719,1661,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',38720.00,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(259,NULL,40719,1661,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',617100.00,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(260,NULL,40719,1661,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',296401.60,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(261,NULL,40719,1661,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',50820.00,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(262,NULL,40719,1661,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',15004.00,NULL,NULL,1,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(263,7777,40719,1661,8,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49604.87,NULL,NULL,1,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(264,7777,40719,1661,8,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',255167.29,NULL,NULL,1,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(265,7777,40719,1661,8,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10637.14,NULL,NULL,1,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14');
INSERT INTO `balance_libro` VALUES (266,7777,40719,1661,8,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',6058.51,NULL,NULL,1,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(267,7777,40719,1661,8,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8654.62,NULL,NULL,1,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(268,7777,40719,1661,8,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49604.87,NULL,NULL,1,'2022-09-27 10:55:28','2022-09-27 13:30:14','2022-09-27 13:30:14'),(269,7777,40719,1661,8,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',255167.29,NULL,NULL,1,'2022-09-27 10:55:28','2022-09-27 13:30:14','2022-09-27 13:30:14'),(270,7777,40719,1661,8,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10637.14,NULL,NULL,1,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(271,7777,40719,1661,8,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',6058.51,NULL,NULL,1,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(272,7777,40719,1661,8,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8654.62,NULL,NULL,1,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(273,NULL,40719,1661,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3025.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(274,NULL,40719,1661,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',11797.50,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(275,NULL,40719,1661,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',193600.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(276,NULL,40719,1661,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',73872.48,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(277,NULL,40719,1661,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4094.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(278,NULL,40719,1661,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2420.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(279,NULL,40719,1661,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2521.50,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(280,NULL,40719,1661,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2420.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(281,NULL,40719,1661,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',15730.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(282,NULL,40719,1661,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55660.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(283,NULL,40719,1661,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55660.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(284,NULL,40719,1661,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2964.50,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(285,NULL,40719,1661,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5747.50,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(286,NULL,40719,1661,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8288.50,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(287,NULL,40719,1661,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',1914704.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(288,NULL,40719,1661,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',315810.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(289,NULL,40719,1661,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',79376.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL);
INSERT INTO `balance_libro` VALUES (290,NULL,40719,1661,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',79376.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(291,NULL,40719,1661,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',83732.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(292,NULL,40719,1661,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',81917.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(293,NULL,40719,1661,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',77440.00,NULL,NULL,1,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(294,NULL,40719,1661,2,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3751.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(295,NULL,40719,1661,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',157865.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(296,NULL,40719,1661,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',30250.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(297,NULL,40719,1661,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',285560.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(298,NULL,40719,1661,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',36300.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(299,NULL,40719,1661,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',62097.20,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(300,NULL,40719,1661,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26620.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(301,NULL,40719,1661,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49740.08,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(302,NULL,40719,1661,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',123178.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(303,NULL,40719,1661,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19360.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(304,NULL,40719,1661,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',84276.50,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(305,NULL,40719,1661,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',6243.60,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(306,NULL,40719,1661,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23353.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(307,NULL,40719,1661,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',25711.29,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(308,NULL,40719,1661,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',76862.27,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(309,NULL,40719,1661,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111467.62,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(310,NULL,40719,1661,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',655.05,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(311,NULL,40719,1661,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3899.71,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(312,NULL,40719,1661,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',83228.88,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(313,NULL,40719,1661,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',93207.27,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(314,NULL,40719,1661,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',546315.00,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL);
INSERT INTO `balance_libro` VALUES (315,NULL,40719,1661,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',62338.60,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(316,NULL,40719,1661,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26059.77,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(317,NULL,40719,1661,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4456.91,NULL,NULL,1,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(318,NULL,40719,1661,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5082.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(319,NULL,40719,1661,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',180048.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(320,NULL,40719,1661,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',45012.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(321,NULL,40719,1661,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',290400.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(322,NULL,40719,1661,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',188760.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(323,NULL,40719,1661,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',425920.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(324,NULL,40719,1661,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',25410.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(325,NULL,40719,1661,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',133100.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(326,NULL,40719,1661,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',708329.14,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(327,NULL,40719,1661,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',77319.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(328,NULL,40719,1661,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5666.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(329,NULL,40719,1661,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2200.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(330,NULL,40719,1661,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',230.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(331,NULL,40719,1661,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',37200.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(332,NULL,40719,1661,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',75867.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(333,NULL,40719,1661,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49005.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(334,NULL,40719,1661,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',106480.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(335,NULL,40719,1661,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52514.00,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(336,NULL,40719,1661,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',42579.90,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(337,NULL,40719,1661,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',263632.38,NULL,NULL,1,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(338,NULL,40719,1661,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52514.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(339,NULL,40719,1661,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',337206.43,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL);
INSERT INTO `balance_libro` VALUES (340,NULL,40719,1661,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',344850.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(341,NULL,40719,1661,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',114950.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(342,NULL,40719,1661,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',136125.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(343,NULL,40719,1661,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',120516.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(344,NULL,40719,1661,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',31218.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(345,NULL,40719,1661,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52635.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(346,NULL,40719,1661,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52635.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(347,NULL,40719,1661,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19360.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(348,NULL,40719,1661,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',236857.50,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(349,NULL,40719,1661,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',115434.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(350,NULL,40719,1661,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',87120.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(351,NULL,40719,1661,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111804.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(352,NULL,40719,1661,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111804.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(353,NULL,40719,1661,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',172425.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(354,NULL,40719,1661,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111804.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(355,NULL,40719,1661,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',111804.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(356,NULL,40719,1661,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',154880.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(357,NULL,40719,1661,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',50820.00,NULL,NULL,1,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(358,NULL,40719,1661,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',74899.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(359,NULL,40719,1661,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23232.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(360,NULL,40719,1661,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',93899.03,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(361,NULL,40719,1661,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26777.30,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(362,NULL,40719,1661,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',27104.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(363,NULL,40719,1661,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',92516.60,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL);
INSERT INTO `balance_libro` VALUES (364,NULL,40719,1661,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',20424.80,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(365,NULL,40719,1661,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',13068.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(366,NULL,40719,1661,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',13068.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(367,NULL,40719,1661,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',17351.40,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(368,NULL,40719,1661,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',94864.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(369,NULL,40719,1661,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',36300.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(370,NULL,40719,1661,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19965.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(371,NULL,40719,1661,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',36300.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(372,NULL,40719,1661,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',1169918.75,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(373,NULL,40719,1661,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21780.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(374,NULL,40719,1661,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',75020.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(375,NULL,40719,1661,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',130680.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(376,NULL,40719,1661,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',60802.50,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(377,NULL,40719,1661,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',18150.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(378,NULL,40719,1661,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',37510.00,NULL,NULL,1,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(379,NULL,40719,1661,2,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',79376.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(380,NULL,40719,1661,2,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',85184.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(381,NULL,40719,1661,2,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',42592.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(382,NULL,40719,1661,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',99480.15,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(383,NULL,40719,1661,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',170610.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(384,NULL,40719,1661,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',83187.50,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(385,NULL,40719,1661,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',45375.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(386,NULL,40719,1661,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23837.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(387,NULL,40719,1661,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33275.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(388,NULL,40719,1661,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',125840.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL);
INSERT INTO `balance_libro` VALUES (389,NULL,40719,1661,2,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10890.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(390,NULL,40719,1661,2,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21175.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(391,NULL,40719,1661,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52030.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(392,NULL,40719,1661,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',59622.75,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(393,NULL,40719,1661,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26620.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(394,NULL,40719,1661,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',228690.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(395,NULL,40719,1661,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49489.00,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(396,NULL,40719,1661,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',231310.86,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(397,NULL,40719,1661,2,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',231310.86,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(398,NULL,40719,1661,2,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',108280.48,NULL,NULL,1,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(399,NULL,40719,1661,2,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',195339.98,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(400,NULL,40719,1661,2,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',108658.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(401,NULL,40719,1661,2,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',66792.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(402,NULL,40719,1661,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',104181.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(403,NULL,40719,1661,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',142538.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(404,NULL,40719,1661,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21538.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(405,NULL,40719,1661,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',18755.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(406,NULL,40719,1661,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',43076.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(407,NULL,40719,1661,2,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33880.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(408,NULL,40719,1661,2,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',53542.50,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(409,NULL,40719,1661,2,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',7562.50,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(410,NULL,40719,1661,2,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',68244.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(411,NULL,40719,1661,2,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21780.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(412,NULL,40719,1661,2,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21780.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL);
INSERT INTO `balance_libro` VALUES (413,NULL,40719,1661,2,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',52635.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(414,NULL,40719,1661,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33759.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(415,NULL,40719,1661,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',122815.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(416,NULL,40719,1661,2,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',65340.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(417,NULL,40719,1661,2,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',427372.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(418,NULL,40719,1661,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',6776.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(419,NULL,40719,1661,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',175450.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(420,NULL,40719,1661,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',65340.00,NULL,NULL,1,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(421,NULL,40719,1661,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',300080.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(422,NULL,40719,1661,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33759.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(423,NULL,40719,1661,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',65340.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(424,NULL,40719,1661,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49005.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(425,NULL,40719,1661,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',350900.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(426,NULL,40719,1661,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',459679.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(427,NULL,40719,1661,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',36300.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(428,NULL,40719,1661,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',363000.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(429,NULL,40719,1661,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',33880.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(430,NULL,40719,1661,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',83079.64,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(431,NULL,40719,1661,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',54450.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(432,NULL,40719,1661,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',62436.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(433,NULL,40719,1661,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',41624.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(434,NULL,40719,1661,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',62436.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(435,NULL,40719,1661,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',16940.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(436,NULL,40719,1661,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',63888.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(437,NULL,40719,1661,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',85184.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL);
INSERT INTO `balance_libro` VALUES (438,NULL,40719,1661,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',20812.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(439,NULL,40719,1661,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',39954.20,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(440,NULL,40719,1661,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',41745.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(441,NULL,40719,1661,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21780.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(442,NULL,40719,1661,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9075.00,NULL,NULL,1,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(443,NULL,40719,1661,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',30250.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(444,NULL,40719,1661,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9075.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(445,NULL,40719,1661,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9075.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(446,NULL,40719,1661,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',521985.03,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(447,NULL,40719,1661,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9378.24,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(448,NULL,40719,1661,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',324280.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(449,NULL,40719,1661,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8131.20,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(450,NULL,40719,1661,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',11253.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(451,NULL,40719,1661,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55660.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(452,NULL,40719,1661,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5995.49,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(453,NULL,40719,1661,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',58080.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(454,NULL,40719,1661,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',87120.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(455,NULL,40719,1661,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4954.95,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(456,NULL,40719,1661,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5995.49,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(457,NULL,40719,1661,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',69696.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(458,NULL,40719,1661,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2377274.90,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(459,NULL,40719,1661,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55935.88,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(460,NULL,40719,1661,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10466.50,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(461,NULL,40719,1661,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',265595.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(462,NULL,40719,1661,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',78529.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL);
INSERT INTO `balance_libro` VALUES (463,NULL,40719,1661,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',302258.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(464,NULL,40719,1661,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',18755.00,NULL,NULL,1,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(465,NULL,40719,1661,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',64800.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(466,NULL,40719,1661,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',7744.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(467,NULL,40719,1661,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',22597.96,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(468,NULL,40719,1661,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',98010.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(469,NULL,40719,1661,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10587.50,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(470,NULL,40719,1661,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23716.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(471,NULL,40719,1661,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',23716.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(472,NULL,40719,1661,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',70180.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(473,NULL,40719,1661,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',67518.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(474,NULL,40719,1661,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',38115.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(475,NULL,40719,1661,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',25192.20,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(476,NULL,40719,1661,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10164.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(477,NULL,40719,1661,2,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19602.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(478,NULL,40719,1661,2,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',38750.25,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(479,NULL,40719,1661,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19602.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(480,NULL,40719,1661,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',63525.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(481,NULL,40719,1661,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',159132.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(482,NULL,40719,1661,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26680.50,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(483,NULL,40719,1661,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',38115.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(484,NULL,40719,1661,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',18755.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(485,NULL,40719,1661,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',13320.00,NULL,NULL,1,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(486,NULL,40719,1661,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',46464.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(487,NULL,40719,1661,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',208725.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL);
INSERT INTO `balance_libro` VALUES (488,NULL,40719,1661,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',208725.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(489,NULL,40719,1661,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',202917.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(490,NULL,40719,1661,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3751.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(491,NULL,40719,1661,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',125840.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(492,NULL,40719,1661,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',937.75,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(493,NULL,40719,1661,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',937.75,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(494,NULL,40719,1661,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',176418.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(495,NULL,40719,1661,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8228.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(496,NULL,40719,1661,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',55660.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(497,NULL,40719,1661,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',100963.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(498,NULL,40719,1661,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',42350.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(499,NULL,40719,1661,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5372.40,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(500,NULL,40719,1661,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',44528.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(501,NULL,40719,1661,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',802130.18,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(502,NULL,40719,1661,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',172546.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(503,NULL,40719,1661,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',77440.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(504,NULL,40719,1661,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',9982.50,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(505,NULL,40719,1661,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',50820.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(506,NULL,40719,1661,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',19602.00,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(507,NULL,40719,1661,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',296401.60,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(508,NULL,40719,1661,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',296401.60,NULL,NULL,1,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(509,NULL,40719,1661,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',159720.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(510,NULL,40719,1661,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',48400.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(511,NULL,40719,1661,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',164196.03,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(512,NULL,40719,1661,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',163350.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL);
INSERT INTO `balance_libro` VALUES (513,NULL,40719,1661,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',254100.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(514,NULL,40719,1661,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',16607.25,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(515,NULL,40719,1661,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',26317.50,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(516,NULL,40719,1661,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',286044.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(517,NULL,40719,1661,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5263.50,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(518,NULL,40719,1661,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',340765.04,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(519,NULL,40719,1661,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',171576.79,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(520,NULL,40719,1661,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',142296.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(521,NULL,40719,1661,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49005.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(522,NULL,40719,1661,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',17800.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(523,NULL,40719,1661,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',29516.26,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(524,NULL,40719,1661,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',29516.26,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(525,NULL,40719,1661,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',38720.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(526,NULL,40719,1661,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',617100.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(527,NULL,40719,1661,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',296401.60,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(528,NULL,40719,1661,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',50820.00,NULL,NULL,1,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(529,NULL,40719,1661,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',15004.00,NULL,NULL,1,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(530,7777,40719,1661,8,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',49604.87,NULL,NULL,1,'2022-09-27 13:33:54','2022-09-27 13:33:54',NULL),(531,7777,40719,1661,8,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',255167.29,NULL,NULL,1,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(532,7777,40719,1661,8,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10637.14,NULL,NULL,1,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(533,7777,40719,1661,8,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',6058.51,NULL,NULL,1,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(534,7777,40719,1661,8,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8654.62,NULL,NULL,1,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(535,7777,40719,12,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',8000.00,NULL,NULL,1,'2022-10-07 10:59:16','2022-10-07 11:00:41','2022-10-07 11:00:41'),(536,7777,40719,12,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',10000.00,NULL,NULL,1,'2022-10-07 11:00:08','2022-10-07 11:02:42','2022-10-07 11:02:42');
INSERT INTO `balance_libro` VALUES (537,7777,40719,12,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',10000.00,NULL,NULL,1,'2022-10-07 11:02:42','2022-10-07 11:04:29','2022-10-07 11:04:29'),(538,7777,40719,12,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',10000.00,NULL,NULL,1,'2022-10-07 11:04:29','2022-10-07 11:06:12','2022-10-07 11:06:12'),(539,7777,40719,12,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',10000.00,NULL,NULL,1,'2022-10-07 11:23:34','2022-10-07 11:23:34',NULL),(540,7777,40719,12,3,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',24200.00,NULL,NULL,1,'2022-10-07 15:01:30','2022-10-07 15:03:29','2022-10-07 15:03:29'),(541,7777,40719,12,3,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',24200.00,NULL,NULL,1,'2022-10-07 15:03:29','2022-10-07 15:44:10','2022-10-07 15:44:10'),(542,7777,40719,12,20,NULL,NULL,NULL,527,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',10000.00,NULL,NULL,1,'2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(543,7777,40719,1661,20,NULL,NULL,NULL,528,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',363000.00,NULL,NULL,1,'2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(544,7777,40719,1661,20,NULL,NULL,NULL,529,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180048.00,NULL,NULL,1,'2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(545,7777,40719,1661,20,NULL,NULL,NULL,530,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',254100.00,NULL,NULL,1,'2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(546,7777,40719,1661,20,NULL,NULL,NULL,531,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',163350.00,NULL,NULL,1,'2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(547,7777,40719,1661,21,NULL,NULL,NULL,532,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',24200.00,NULL,NULL,1,'2022-10-07 15:33:06','2022-10-07 15:44:10','2022-10-07 15:44:10'),(549,7777,40719,12,3,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',24200.00,NULL,NULL,1,'2022-10-07 15:48:50','2022-10-07 15:48:50',NULL),(550,7777,40719,12,21,NULL,NULL,NULL,535,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',24200.00,NULL,NULL,1,'2022-10-07 15:50:03','2022-10-07 15:50:03',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1551 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7777,1,40719,11,2,96,2,100.00,NULL,'2022-09-08 10:30:29','2022-09-08 10:40:46','2022-09-08 10:40:46'),(2,7777,1,40719,11,2,67,2,21.00,NULL,'2022-09-08 10:30:29','2022-09-08 10:40:46','2022-09-08 10:40:46'),(3,7777,1,40719,11,2,13,1,121.00,NULL,'2022-09-08 10:30:29','2022-09-08 10:40:46','2022-09-08 10:40:46'),(4,7777,2,40719,11,3,217,1,1000.00,NULL,'2022-09-08 10:40:18','2022-09-26 19:10:04','2022-09-26 19:10:04'),(5,7777,2,40719,11,3,68,1,210.00,NULL,'2022-09-08 10:40:18','2022-09-26 19:10:04','2022-09-26 19:10:04'),(6,7777,2,40719,11,3,220,1,100.00,NULL,'2022-09-08 10:40:18','2022-09-26 19:10:04','2022-09-26 19:10:04'),(7,7777,2,40719,11,3,225,1,0.50,NULL,'2022-09-08 10:40:18','2022-09-26 19:10:04','2022-09-26 19:10:04'),(8,7777,2,40719,11,3,226,1,0.40,NULL,'2022-09-08 10:40:18','2022-09-26 19:10:04','2022-09-26 19:10:04'),(9,7777,2,40719,11,3,57,2,1310.90,NULL,'2022-09-08 10:40:18','2022-09-26 19:10:04','2022-09-26 19:10:04'),(10,7777,3,40719,11,2,96,2,2000.00,NULL,'2022-09-08 10:40:46','2022-09-26 19:09:49','2022-09-26 19:09:49'),(11,7777,3,40719,11,2,67,2,420.00,NULL,'2022-09-08 10:40:46','2022-09-26 19:09:49','2022-09-26 19:09:49'),(12,7777,3,40719,11,2,13,1,2420.00,NULL,'2022-09-08 10:40:46','2022-09-26 19:09:49','2022-09-26 19:09:49'),(13,7777,4,40719,11,21,57,1,1310.09,NULL,'2022-09-08 11:42:06','2022-09-08 11:46:20','2022-09-08 11:46:20'),(14,7777,4,40719,11,21,359,2,1310.09,NULL,'2022-09-08 11:42:06','2022-09-08 11:46:20','2022-09-08 11:46:20'),(15,7777,5,40719,11,21,57,1,1310.90,NULL,'2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(16,7777,5,40719,11,21,359,2,1310.90,NULL,'2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(17,NULL,6,40719,1661,2,96,2,2500.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(18,NULL,6,40719,1661,2,67,2,525.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(19,NULL,6,40719,1661,2,13,1,3025.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(20,NULL,7,40719,1661,2,96,2,9750.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(21,NULL,7,40719,1661,2,67,2,2047.50,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(22,NULL,7,40719,1661,2,13,1,11797.50,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(23,NULL,8,40719,1661,2,96,1,160000.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(24,NULL,8,40719,1661,2,68,1,33600.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(25,NULL,8,40719,1661,2,13,2,193600.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(26,NULL,9,40719,1661,2,218,2,73872.48,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(27,NULL,9,40719,1661,2,13,1,73872.48,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(28,NULL,10,40719,1661,2,218,2,4094.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(29,NULL,10,40719,1661,2,13,1,4094.00,NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(30,NULL,11,40719,1661,2,218,2,2420.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(31,NULL,11,40719,1661,2,13,1,2420.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(32,NULL,12,40719,1661,2,218,2,2521.50,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(33,NULL,12,40719,1661,2,13,1,2521.50,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(34,NULL,13,40719,1661,2,218,2,2420.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(35,NULL,13,40719,1661,2,13,1,2420.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(36,NULL,14,40719,1661,2,96,2,13000.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(37,NULL,14,40719,1661,2,67,2,2730.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10');
INSERT INTO `balance_libro_details` VALUES (38,NULL,14,40719,1661,2,13,1,15730.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(39,NULL,15,40719,1661,2,96,2,46000.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(40,NULL,15,40719,1661,2,67,2,9660.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(41,NULL,15,40719,1661,2,13,1,55660.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(42,NULL,16,40719,1661,2,96,2,46000.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(43,NULL,16,40719,1661,2,67,2,9660.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(44,NULL,16,40719,1661,2,13,1,55660.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(45,NULL,17,40719,1661,2,96,2,2450.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(46,NULL,17,40719,1661,2,67,2,514.50,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(47,NULL,17,40719,1661,2,13,1,2964.50,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(48,NULL,18,40719,1661,2,96,2,4750.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(49,NULL,18,40719,1661,2,67,2,997.50,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(50,NULL,18,40719,1661,2,13,1,5747.50,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(51,NULL,19,40719,1661,2,96,2,6850.00,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(52,NULL,19,40719,1661,2,67,2,1438.50,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(53,NULL,19,40719,1661,2,13,1,8288.50,NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(54,NULL,20,40719,1661,2,96,2,1582400.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(55,NULL,20,40719,1661,2,67,2,332304.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(56,NULL,20,40719,1661,2,13,1,1914704.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(57,NULL,21,40719,1661,2,96,2,261000.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(58,NULL,21,40719,1661,2,67,2,54810.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(59,NULL,21,40719,1661,2,13,1,315810.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(60,NULL,22,40719,1661,2,96,2,65600.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(61,NULL,22,40719,1661,2,67,2,13776.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(62,NULL,22,40719,1661,2,13,1,79376.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(63,NULL,23,40719,1661,2,96,2,65600.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(64,NULL,23,40719,1661,2,67,2,13776.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(65,NULL,23,40719,1661,2,13,1,79376.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(66,NULL,24,40719,1661,2,96,2,69200.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(67,NULL,24,40719,1661,2,67,2,14532.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(68,NULL,24,40719,1661,2,13,1,83732.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(69,NULL,25,40719,1661,2,96,2,67700.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(70,NULL,25,40719,1661,2,67,2,14217.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(71,NULL,25,40719,1661,2,13,1,81917.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(72,NULL,26,40719,1661,2,96,2,64000.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(73,NULL,26,40719,1661,2,67,2,13440.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10');
INSERT INTO `balance_libro_details` VALUES (74,NULL,26,40719,1661,2,13,1,77440.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(75,NULL,27,40719,1661,2,218,2,3751.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(76,NULL,27,40719,1661,2,13,1,3751.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(77,NULL,28,40719,1661,2,218,2,157865.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(78,NULL,28,40719,1661,2,13,1,157865.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(79,NULL,29,40719,1661,2,218,2,30250.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(80,NULL,29,40719,1661,2,13,1,30250.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(81,NULL,30,40719,1661,2,218,2,285560.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(82,NULL,30,40719,1661,2,13,1,285560.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(83,NULL,31,40719,1661,2,218,2,36300.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(84,NULL,31,40719,1661,2,13,1,36300.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(85,NULL,32,40719,1661,2,96,2,51320.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(86,NULL,32,40719,1661,2,67,2,10777.20,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(87,NULL,32,40719,1661,2,13,1,62097.20,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(88,NULL,33,40719,1661,2,96,2,22000.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(89,NULL,33,40719,1661,2,67,2,4620.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(90,NULL,33,40719,1661,2,13,1,26620.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(91,NULL,34,40719,1661,2,96,2,41107.50,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(92,NULL,34,40719,1661,2,67,2,8632.58,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(93,NULL,34,40719,1661,2,13,1,49740.08,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(94,NULL,35,40719,1661,2,96,2,101800.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(95,NULL,35,40719,1661,2,67,2,21378.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(96,NULL,35,40719,1661,2,13,1,123178.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(97,NULL,36,40719,1661,2,96,2,16000.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(98,NULL,36,40719,1661,2,67,2,3360.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(99,NULL,36,40719,1661,2,13,1,19360.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(100,NULL,37,40719,1661,2,96,2,69650.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(101,NULL,37,40719,1661,2,67,2,14626.50,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(102,NULL,37,40719,1661,2,13,1,84276.50,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(103,NULL,38,40719,1661,2,96,2,5160.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(104,NULL,38,40719,1661,2,67,2,1083.60,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(105,NULL,38,40719,1661,2,13,1,6243.60,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(106,NULL,39,40719,1661,2,96,2,19300.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(107,NULL,39,40719,1661,2,67,2,4053.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(108,NULL,39,40719,1661,2,13,1,23353.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(109,NULL,40,40719,1661,2,96,2,21249.00,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `balance_libro_details` VALUES (110,NULL,40,40719,1661,2,67,2,4462.29,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:11','2022-09-27 13:28:11'),(111,NULL,40,40719,1661,2,13,1,25711.29,NULL,'2022-09-27 10:52:58','2022-09-27 13:28:11','2022-09-27 13:28:11'),(112,NULL,41,40719,1661,2,96,2,63522.54,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(113,NULL,41,40719,1661,2,67,2,13339.73,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(114,NULL,41,40719,1661,2,13,1,76862.27,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(115,NULL,42,40719,1661,2,96,2,92122.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(116,NULL,42,40719,1661,2,67,2,19345.62,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(117,NULL,42,40719,1661,2,13,1,111467.62,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(118,NULL,43,40719,1661,2,96,2,541.36,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(119,NULL,43,40719,1661,2,67,2,113.69,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(120,NULL,43,40719,1661,2,13,1,655.05,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(121,NULL,44,40719,1661,2,96,2,3222.90,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(122,NULL,44,40719,1661,2,67,2,676.81,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(123,NULL,44,40719,1661,2,13,1,3899.71,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(124,NULL,45,40719,1661,2,96,2,68784.20,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(125,NULL,45,40719,1661,2,67,2,14444.68,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(126,NULL,45,40719,1661,2,13,1,83228.88,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(127,NULL,46,40719,1661,2,96,2,77030.80,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(128,NULL,46,40719,1661,2,67,2,16176.47,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(129,NULL,46,40719,1661,2,13,1,93207.27,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(130,NULL,47,40719,1661,2,96,2,451500.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(131,NULL,47,40719,1661,2,67,2,94815.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(132,NULL,47,40719,1661,2,13,1,546315.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(133,NULL,48,40719,1661,2,96,2,51519.50,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(134,NULL,48,40719,1661,2,67,2,10819.10,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(135,NULL,48,40719,1661,2,13,1,62338.60,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(136,NULL,49,40719,1661,2,96,2,21537.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(137,NULL,49,40719,1661,2,67,2,4522.77,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(138,NULL,49,40719,1661,2,13,1,26059.77,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(139,NULL,50,40719,1661,2,96,2,3683.40,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(140,NULL,50,40719,1661,2,67,2,773.51,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(141,NULL,50,40719,1661,2,13,1,4456.91,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(142,NULL,51,40719,1661,2,96,2,4200.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(143,NULL,51,40719,1661,2,67,2,882.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(144,NULL,51,40719,1661,2,13,1,5082.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `balance_libro_details` VALUES (145,NULL,52,40719,1661,2,96,2,148800.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(146,NULL,52,40719,1661,2,67,2,31248.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(147,NULL,52,40719,1661,2,13,1,180048.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(148,NULL,53,40719,1661,2,96,2,37200.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(149,NULL,53,40719,1661,2,67,2,7812.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(150,NULL,53,40719,1661,2,13,1,45012.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(151,NULL,54,40719,1661,2,96,2,240000.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(152,NULL,54,40719,1661,2,67,2,50400.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(153,NULL,54,40719,1661,2,13,1,290400.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(154,NULL,55,40719,1661,2,96,2,156000.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(155,NULL,55,40719,1661,2,67,2,32760.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(156,NULL,55,40719,1661,2,13,1,188760.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(157,NULL,56,40719,1661,2,96,2,352000.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(158,NULL,56,40719,1661,2,67,2,73920.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(159,NULL,56,40719,1661,2,13,1,425920.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(160,NULL,57,40719,1661,2,96,2,21000.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(161,NULL,57,40719,1661,2,67,2,4410.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(162,NULL,57,40719,1661,2,13,1,25410.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(163,NULL,58,40719,1661,2,96,2,110000.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(164,NULL,58,40719,1661,2,67,2,23100.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(165,NULL,58,40719,1661,2,13,1,133100.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(166,NULL,59,40719,1661,2,218,2,708329.14,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(167,NULL,59,40719,1661,2,13,1,708329.14,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(168,NULL,60,40719,1661,2,218,2,77319.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(169,NULL,60,40719,1661,2,13,1,77319.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(170,NULL,61,40719,1661,2,218,2,5666.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(171,NULL,61,40719,1661,2,13,1,5666.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(172,NULL,62,40719,1661,2,218,2,2200.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(173,NULL,62,40719,1661,2,13,1,2200.00,NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(174,NULL,63,40719,1661,2,218,1,230.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(175,NULL,63,40719,1661,2,13,2,230.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(176,NULL,64,40719,1661,2,218,1,37200.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(177,NULL,64,40719,1661,2,13,2,37200.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(178,NULL,65,40719,1661,2,218,2,75867.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(179,NULL,65,40719,1661,2,13,1,75867.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `balance_libro_details` VALUES (180,NULL,66,40719,1661,2,96,2,40500.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(181,NULL,66,40719,1661,2,67,2,8505.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(182,NULL,66,40719,1661,2,13,1,49005.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(183,NULL,67,40719,1661,2,218,2,106480.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(184,NULL,67,40719,1661,2,13,1,106480.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(185,NULL,68,40719,1661,2,96,2,43400.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(186,NULL,68,40719,1661,2,67,2,9114.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(187,NULL,68,40719,1661,2,13,1,52514.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(188,NULL,69,40719,1661,2,96,2,35190.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(189,NULL,69,40719,1661,2,67,2,7389.90,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(190,NULL,69,40719,1661,2,13,1,42579.90,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(191,NULL,70,40719,1661,2,96,2,217878.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(192,NULL,70,40719,1661,2,67,2,45754.38,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(193,NULL,70,40719,1661,2,13,1,263632.38,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(194,NULL,71,40719,1661,2,96,2,43400.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(195,NULL,71,40719,1661,2,67,2,9114.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(196,NULL,71,40719,1661,2,13,1,52514.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(197,NULL,72,40719,1661,2,96,2,278683.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(198,NULL,72,40719,1661,2,67,2,58523.43,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(199,NULL,72,40719,1661,2,13,1,337206.43,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(200,NULL,73,40719,1661,2,96,2,285000.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(201,NULL,73,40719,1661,2,67,2,59850.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(202,NULL,73,40719,1661,2,13,1,344850.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(203,NULL,74,40719,1661,2,96,2,95000.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(204,NULL,74,40719,1661,2,67,2,19950.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(205,NULL,74,40719,1661,2,13,1,114950.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(206,NULL,75,40719,1661,2,96,2,112500.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(207,NULL,75,40719,1661,2,67,2,23625.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(208,NULL,75,40719,1661,2,13,1,136125.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(209,NULL,76,40719,1661,2,96,2,99600.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(210,NULL,76,40719,1661,2,67,2,20916.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(211,NULL,76,40719,1661,2,13,1,120516.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(212,NULL,77,40719,1661,2,96,2,25800.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(213,NULL,77,40719,1661,2,67,2,5418.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(214,NULL,77,40719,1661,2,13,1,31218.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `balance_libro_details` VALUES (215,NULL,78,40719,1661,2,96,2,43500.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(216,NULL,78,40719,1661,2,67,2,9135.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(217,NULL,78,40719,1661,2,13,1,52635.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(218,NULL,79,40719,1661,2,96,2,43500.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(219,NULL,79,40719,1661,2,67,2,9135.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(220,NULL,79,40719,1661,2,13,1,52635.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(221,NULL,80,40719,1661,2,96,2,16000.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(222,NULL,80,40719,1661,2,67,2,3360.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(223,NULL,80,40719,1661,2,13,1,19360.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(224,NULL,81,40719,1661,2,96,2,195750.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(225,NULL,81,40719,1661,2,67,2,41107.50,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(226,NULL,81,40719,1661,2,13,1,236857.50,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(227,NULL,82,40719,1661,2,96,2,95400.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(228,NULL,82,40719,1661,2,67,2,20034.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(229,NULL,82,40719,1661,2,13,1,115434.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(230,NULL,83,40719,1661,2,96,2,72000.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(231,NULL,83,40719,1661,2,67,2,15120.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(232,NULL,83,40719,1661,2,13,1,87120.00,NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(233,NULL,84,40719,1661,2,96,2,92400.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(234,NULL,84,40719,1661,2,67,2,19404.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(235,NULL,84,40719,1661,2,13,1,111804.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(236,NULL,85,40719,1661,2,96,2,92400.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(237,NULL,85,40719,1661,2,67,2,19404.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(238,NULL,85,40719,1661,2,13,1,111804.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(239,NULL,86,40719,1661,2,96,2,142500.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(240,NULL,86,40719,1661,2,67,2,29925.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(241,NULL,86,40719,1661,2,13,1,172425.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(242,NULL,87,40719,1661,2,96,2,92400.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(243,NULL,87,40719,1661,2,67,2,19404.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(244,NULL,87,40719,1661,2,13,1,111804.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(245,NULL,88,40719,1661,2,96,2,92400.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(246,NULL,88,40719,1661,2,67,2,19404.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(247,NULL,88,40719,1661,2,13,1,111804.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(248,NULL,89,40719,1661,2,96,2,128000.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(249,NULL,89,40719,1661,2,67,2,26880.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `balance_libro_details` VALUES (250,NULL,89,40719,1661,2,13,1,154880.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(251,NULL,90,40719,1661,2,96,2,42000.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(252,NULL,90,40719,1661,2,67,2,8820.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(253,NULL,90,40719,1661,2,13,1,50820.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(254,NULL,91,40719,1661,2,96,2,61900.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(255,NULL,91,40719,1661,2,67,2,12999.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(256,NULL,91,40719,1661,2,13,1,74899.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(257,NULL,92,40719,1661,2,96,2,19200.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(258,NULL,92,40719,1661,2,67,2,4032.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(259,NULL,92,40719,1661,2,13,1,23232.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(260,NULL,93,40719,1661,2,96,2,77602.50,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(261,NULL,93,40719,1661,2,67,2,16296.53,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(262,NULL,93,40719,1661,2,13,1,93899.03,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(263,NULL,94,40719,1661,2,96,2,22130.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(264,NULL,94,40719,1661,2,67,2,4647.30,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(265,NULL,94,40719,1661,2,13,1,26777.30,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(266,NULL,95,40719,1661,2,96,2,22400.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(267,NULL,95,40719,1661,2,67,2,4704.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(268,NULL,95,40719,1661,2,13,1,27104.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(269,NULL,96,40719,1661,2,96,2,76460.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(270,NULL,96,40719,1661,2,67,2,16056.60,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(271,NULL,96,40719,1661,2,13,1,92516.60,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(272,NULL,97,40719,1661,2,96,2,16880.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(273,NULL,97,40719,1661,2,67,2,3544.80,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(274,NULL,97,40719,1661,2,13,1,20424.80,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(275,NULL,98,40719,1661,2,96,2,10800.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(276,NULL,98,40719,1661,2,67,2,2268.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(277,NULL,98,40719,1661,2,13,1,13068.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(278,NULL,99,40719,1661,2,96,1,10800.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(279,NULL,99,40719,1661,2,68,1,2268.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(280,NULL,99,40719,1661,2,13,2,13068.00,NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(281,NULL,100,40719,1661,2,96,2,14340.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(282,NULL,100,40719,1661,2,67,2,3011.40,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(283,NULL,100,40719,1661,2,13,1,17351.40,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(284,NULL,101,40719,1661,2,96,2,78400.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `balance_libro_details` VALUES (285,NULL,101,40719,1661,2,67,2,16464.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(286,NULL,101,40719,1661,2,13,1,94864.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(287,NULL,102,40719,1661,2,96,2,30000.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(288,NULL,102,40719,1661,2,67,2,6300.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(289,NULL,102,40719,1661,2,13,1,36300.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(290,NULL,103,40719,1661,2,96,2,16500.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(291,NULL,103,40719,1661,2,67,2,3465.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(292,NULL,103,40719,1661,2,13,1,19965.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(293,NULL,104,40719,1661,2,96,2,30000.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(294,NULL,104,40719,1661,2,67,2,6300.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(295,NULL,104,40719,1661,2,13,1,36300.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(296,NULL,105,40719,1661,2,96,2,966875.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(297,NULL,105,40719,1661,2,67,2,203043.75,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(298,NULL,105,40719,1661,2,13,1,1169918.75,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(299,NULL,106,40719,1661,2,96,2,18000.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(300,NULL,106,40719,1661,2,67,2,3780.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(301,NULL,106,40719,1661,2,13,1,21780.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(302,NULL,107,40719,1661,2,96,2,62000.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(303,NULL,107,40719,1661,2,67,2,13020.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(304,NULL,107,40719,1661,2,13,1,75020.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(305,NULL,108,40719,1661,2,96,2,108000.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(306,NULL,108,40719,1661,2,67,2,22680.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(307,NULL,108,40719,1661,2,13,1,130680.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(308,NULL,109,40719,1661,2,96,2,50250.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(309,NULL,109,40719,1661,2,67,2,10552.50,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(310,NULL,109,40719,1661,2,13,1,60802.50,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(311,NULL,110,40719,1661,2,96,2,15000.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(312,NULL,110,40719,1661,2,67,2,3150.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(313,NULL,110,40719,1661,2,13,1,18150.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(314,NULL,111,40719,1661,2,96,2,31000.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(315,NULL,111,40719,1661,2,67,2,6510.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(316,NULL,111,40719,1661,2,13,1,37510.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(317,NULL,112,40719,1661,2,96,2,65600.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(318,NULL,112,40719,1661,2,67,2,13776.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(319,NULL,112,40719,1661,2,13,1,79376.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `balance_libro_details` VALUES (320,NULL,113,40719,1661,2,96,2,70400.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(321,NULL,113,40719,1661,2,67,2,14784.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(322,NULL,113,40719,1661,2,13,1,85184.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(323,NULL,114,40719,1661,2,96,2,35200.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(324,NULL,114,40719,1661,2,67,2,7392.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(325,NULL,114,40719,1661,2,13,1,42592.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(326,NULL,115,40719,1661,2,96,2,82215.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(327,NULL,115,40719,1661,2,67,2,17265.15,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(328,NULL,115,40719,1661,2,13,1,99480.15,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(329,NULL,116,40719,1661,2,96,2,141000.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(330,NULL,116,40719,1661,2,67,2,29610.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(331,NULL,116,40719,1661,2,13,1,170610.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(332,NULL,117,40719,1661,2,96,2,68750.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(333,NULL,117,40719,1661,2,67,2,14437.50,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(334,NULL,117,40719,1661,2,13,1,83187.50,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(335,NULL,118,40719,1661,2,96,2,37500.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(336,NULL,118,40719,1661,2,67,2,7875.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(337,NULL,118,40719,1661,2,13,1,45375.00,NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(338,NULL,119,40719,1661,2,96,2,19700.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(339,NULL,119,40719,1661,2,67,2,4137.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(340,NULL,119,40719,1661,2,13,1,23837.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(341,NULL,120,40719,1661,2,96,2,27500.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(342,NULL,120,40719,1661,2,67,2,5775.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(343,NULL,120,40719,1661,2,13,1,33275.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(344,NULL,121,40719,1661,2,96,1,104000.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(345,NULL,121,40719,1661,2,68,1,21840.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(346,NULL,121,40719,1661,2,13,2,125840.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(347,NULL,122,40719,1661,2,96,2,9000.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(348,NULL,122,40719,1661,2,67,2,1890.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(349,NULL,122,40719,1661,2,13,1,10890.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(350,NULL,123,40719,1661,2,96,2,17500.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(351,NULL,123,40719,1661,2,67,2,3675.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(352,NULL,123,40719,1661,2,13,1,21175.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(353,NULL,124,40719,1661,2,218,1,52030.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(354,NULL,124,40719,1661,2,13,2,52030.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `balance_libro_details` VALUES (355,NULL,125,40719,1661,2,96,2,49275.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(356,NULL,125,40719,1661,2,67,2,10347.75,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(357,NULL,125,40719,1661,2,13,1,59622.75,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(358,NULL,126,40719,1661,2,96,2,22000.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(359,NULL,126,40719,1661,2,67,2,4620.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(360,NULL,126,40719,1661,2,13,1,26620.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(361,NULL,127,40719,1661,2,96,2,189000.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(362,NULL,127,40719,1661,2,67,2,39690.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(363,NULL,127,40719,1661,2,13,1,228690.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(364,NULL,128,40719,1661,2,96,2,40900.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(365,NULL,128,40719,1661,2,67,2,8589.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(366,NULL,128,40719,1661,2,13,1,49489.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(367,NULL,129,40719,1661,2,96,2,191166.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(368,NULL,129,40719,1661,2,67,2,40144.86,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(369,NULL,129,40719,1661,2,13,1,231310.86,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(370,NULL,130,40719,1661,2,96,2,191166.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(371,NULL,130,40719,1661,2,67,2,40144.86,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(372,NULL,130,40719,1661,2,13,1,231310.86,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(373,NULL,131,40719,1661,2,96,2,89488.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(374,NULL,131,40719,1661,2,67,2,18792.48,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(375,NULL,131,40719,1661,2,13,1,108280.48,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(376,NULL,132,40719,1661,2,96,2,161438.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(377,NULL,132,40719,1661,2,67,2,33901.98,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(378,NULL,132,40719,1661,2,13,1,195339.98,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(379,NULL,133,40719,1661,2,96,2,89800.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(380,NULL,133,40719,1661,2,67,2,18858.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(381,NULL,133,40719,1661,2,13,1,108658.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(382,NULL,134,40719,1661,2,96,2,55200.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(383,NULL,134,40719,1661,2,67,2,11592.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(384,NULL,134,40719,1661,2,13,1,66792.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(385,NULL,135,40719,1661,2,96,2,86100.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(386,NULL,135,40719,1661,2,67,2,18081.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(387,NULL,135,40719,1661,2,13,1,104181.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(388,NULL,136,40719,1661,2,96,2,117800.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(389,NULL,136,40719,1661,2,67,2,24738.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `balance_libro_details` VALUES (390,NULL,136,40719,1661,2,13,1,142538.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(391,NULL,137,40719,1661,2,96,2,17800.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(392,NULL,137,40719,1661,2,67,2,3738.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(393,NULL,137,40719,1661,2,13,1,21538.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(394,NULL,138,40719,1661,2,96,2,15500.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(395,NULL,138,40719,1661,2,67,2,3255.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(396,NULL,138,40719,1661,2,13,1,18755.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(397,NULL,139,40719,1661,2,96,2,35600.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(398,NULL,139,40719,1661,2,67,2,7476.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(399,NULL,139,40719,1661,2,13,1,43076.00,NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(400,NULL,140,40719,1661,2,96,2,28000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(401,NULL,140,40719,1661,2,67,2,5880.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(402,NULL,140,40719,1661,2,13,1,33880.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(403,NULL,141,40719,1661,2,96,2,44250.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(404,NULL,141,40719,1661,2,67,2,9292.50,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(405,NULL,141,40719,1661,2,13,1,53542.50,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(406,NULL,142,40719,1661,2,96,2,6250.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(407,NULL,142,40719,1661,2,67,2,1312.50,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(408,NULL,142,40719,1661,2,13,1,7562.50,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(409,NULL,143,40719,1661,2,96,2,56400.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(410,NULL,143,40719,1661,2,67,2,11844.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(411,NULL,143,40719,1661,2,13,1,68244.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(412,NULL,144,40719,1661,2,96,2,18000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(413,NULL,144,40719,1661,2,67,2,3780.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(414,NULL,144,40719,1661,2,13,1,21780.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(415,NULL,145,40719,1661,2,96,2,18000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(416,NULL,145,40719,1661,2,67,2,3780.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(417,NULL,145,40719,1661,2,13,1,21780.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(418,NULL,146,40719,1661,2,96,2,43500.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(419,NULL,146,40719,1661,2,67,2,9135.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(420,NULL,146,40719,1661,2,13,1,52635.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(421,NULL,147,40719,1661,2,96,2,27900.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(422,NULL,147,40719,1661,2,67,2,5859.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(423,NULL,147,40719,1661,2,13,1,33759.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(424,NULL,148,40719,1661,2,96,2,101500.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13');
INSERT INTO `balance_libro_details` VALUES (425,NULL,148,40719,1661,2,67,2,21315.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(426,NULL,148,40719,1661,2,13,1,122815.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(427,NULL,149,40719,1661,2,96,2,54000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(428,NULL,149,40719,1661,2,67,2,11340.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(429,NULL,149,40719,1661,2,13,1,65340.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(430,NULL,150,40719,1661,2,96,2,353200.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(431,NULL,150,40719,1661,2,67,2,74172.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(432,NULL,150,40719,1661,2,13,1,427372.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(433,NULL,151,40719,1661,2,96,2,5600.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(434,NULL,151,40719,1661,2,67,2,1176.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(435,NULL,151,40719,1661,2,13,1,6776.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(436,NULL,152,40719,1661,2,96,2,145000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(437,NULL,152,40719,1661,2,67,2,30450.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(438,NULL,152,40719,1661,2,13,1,175450.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(439,NULL,153,40719,1661,2,96,2,54000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(440,NULL,153,40719,1661,2,67,2,11340.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(441,NULL,153,40719,1661,2,13,1,65340.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(442,NULL,154,40719,1661,2,96,2,248000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(443,NULL,154,40719,1661,2,67,2,52080.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(444,NULL,154,40719,1661,2,13,1,300080.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(445,NULL,155,40719,1661,2,96,2,27900.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(446,NULL,155,40719,1661,2,67,2,5859.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(447,NULL,155,40719,1661,2,13,1,33759.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(448,NULL,156,40719,1661,2,96,2,54000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(449,NULL,156,40719,1661,2,67,2,11340.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(450,NULL,156,40719,1661,2,13,1,65340.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(451,NULL,157,40719,1661,2,96,2,40500.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(452,NULL,157,40719,1661,2,67,2,8505.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(453,NULL,157,40719,1661,2,13,1,49005.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(454,NULL,158,40719,1661,2,96,2,290000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(455,NULL,158,40719,1661,2,67,2,60900.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(456,NULL,158,40719,1661,2,13,1,350900.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(457,NULL,159,40719,1661,2,96,2,379900.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(458,NULL,159,40719,1661,2,67,2,79779.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(459,NULL,159,40719,1661,2,13,1,459679.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13');
INSERT INTO `balance_libro_details` VALUES (460,NULL,160,40719,1661,2,96,1,30000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(461,NULL,160,40719,1661,2,68,1,6300.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(462,NULL,160,40719,1661,2,13,2,36300.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(463,NULL,161,40719,1661,2,96,2,300000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(464,NULL,161,40719,1661,2,67,2,63000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(465,NULL,161,40719,1661,2,13,1,363000.00,NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(466,NULL,162,40719,1661,2,96,2,28000.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(467,NULL,162,40719,1661,2,67,2,5880.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(468,NULL,162,40719,1661,2,13,1,33880.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(469,NULL,163,40719,1661,2,218,2,83079.64,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(470,NULL,163,40719,1661,2,13,1,83079.64,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(471,NULL,164,40719,1661,2,218,2,54450.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(472,NULL,164,40719,1661,2,13,1,54450.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(473,NULL,165,40719,1661,2,96,2,51600.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(474,NULL,165,40719,1661,2,67,2,10836.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(475,NULL,165,40719,1661,2,13,1,62436.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(476,NULL,166,40719,1661,2,96,2,34400.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(477,NULL,166,40719,1661,2,67,2,7224.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(478,NULL,166,40719,1661,2,13,1,41624.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(479,NULL,167,40719,1661,2,96,2,51600.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(480,NULL,167,40719,1661,2,67,2,10836.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(481,NULL,167,40719,1661,2,13,1,62436.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(482,NULL,168,40719,1661,2,96,2,14000.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(483,NULL,168,40719,1661,2,67,2,2940.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(484,NULL,168,40719,1661,2,13,1,16940.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(485,NULL,169,40719,1661,2,96,2,52800.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(486,NULL,169,40719,1661,2,67,2,11088.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(487,NULL,169,40719,1661,2,13,1,63888.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(488,NULL,170,40719,1661,2,96,2,70400.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(489,NULL,170,40719,1661,2,67,2,14784.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(490,NULL,170,40719,1661,2,13,1,85184.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(491,NULL,171,40719,1661,2,96,2,17200.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(492,NULL,171,40719,1661,2,67,2,3612.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(493,NULL,171,40719,1661,2,13,1,20812.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(494,NULL,172,40719,1661,2,96,2,33020.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13');
INSERT INTO `balance_libro_details` VALUES (495,NULL,172,40719,1661,2,67,2,6934.20,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(496,NULL,172,40719,1661,2,13,1,39954.20,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(497,NULL,173,40719,1661,2,96,2,34500.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(498,NULL,173,40719,1661,2,67,2,7245.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(499,NULL,173,40719,1661,2,13,1,41745.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(500,NULL,174,40719,1661,2,96,2,18000.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(501,NULL,174,40719,1661,2,67,2,3780.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(502,NULL,174,40719,1661,2,13,1,21780.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(503,NULL,175,40719,1661,2,218,2,9075.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(504,NULL,175,40719,1661,2,13,1,9075.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(505,NULL,176,40719,1661,2,96,2,25000.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(506,NULL,176,40719,1661,2,67,2,5250.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(507,NULL,176,40719,1661,2,13,1,30250.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(508,NULL,177,40719,1661,2,96,2,7500.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(509,NULL,177,40719,1661,2,67,2,1575.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(510,NULL,177,40719,1661,2,13,1,9075.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(511,NULL,178,40719,1661,2,218,1,9075.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(512,NULL,178,40719,1661,2,13,2,9075.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(513,NULL,179,40719,1661,2,96,2,431392.59,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(514,NULL,179,40719,1661,2,67,2,90592.44,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(515,NULL,179,40719,1661,2,13,1,521985.03,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(516,NULL,180,40719,1661,2,96,2,7750.61,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(517,NULL,180,40719,1661,2,67,2,1627.63,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(518,NULL,180,40719,1661,2,13,1,9378.24,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(519,NULL,181,40719,1661,2,96,2,268000.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(520,NULL,181,40719,1661,2,67,2,56280.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(521,NULL,181,40719,1661,2,13,1,324280.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(522,NULL,182,40719,1661,2,96,2,6720.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(523,NULL,182,40719,1661,2,67,2,1411.20,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(524,NULL,182,40719,1661,2,13,1,8131.20,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(525,NULL,183,40719,1661,2,96,2,9300.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(526,NULL,183,40719,1661,2,67,2,1953.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(527,NULL,183,40719,1661,2,13,1,11253.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(528,NULL,184,40719,1661,2,96,2,46000.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(529,NULL,184,40719,1661,2,67,2,9660.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14');
INSERT INTO `balance_libro_details` VALUES (530,NULL,184,40719,1661,2,13,1,55660.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(531,NULL,185,40719,1661,2,96,2,4954.95,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(532,NULL,185,40719,1661,2,67,2,1040.54,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(533,NULL,185,40719,1661,2,13,1,5995.49,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(534,NULL,186,40719,1661,2,96,2,48000.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(535,NULL,186,40719,1661,2,67,2,10080.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(536,NULL,186,40719,1661,2,13,1,58080.00,NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(537,NULL,187,40719,1661,2,96,2,72000.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(538,NULL,187,40719,1661,2,67,2,15120.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(539,NULL,187,40719,1661,2,13,1,87120.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(540,NULL,188,40719,1661,2,96,2,4095.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(541,NULL,188,40719,1661,2,67,2,859.95,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(542,NULL,188,40719,1661,2,13,1,4954.95,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(543,NULL,189,40719,1661,2,96,1,4954.95,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(544,NULL,189,40719,1661,2,68,1,1040.54,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(545,NULL,189,40719,1661,2,13,2,5995.49,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(546,NULL,190,40719,1661,2,96,2,57600.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(547,NULL,190,40719,1661,2,67,2,12096.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(548,NULL,190,40719,1661,2,13,1,69696.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(549,NULL,191,40719,1661,2,96,2,1964690.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(550,NULL,191,40719,1661,2,67,2,412584.90,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(551,NULL,191,40719,1661,2,13,1,2377274.90,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(552,NULL,192,40719,1661,2,96,2,46228.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(553,NULL,192,40719,1661,2,67,2,9707.88,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(554,NULL,192,40719,1661,2,13,1,55935.88,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(555,NULL,193,40719,1661,2,96,2,8650.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(556,NULL,193,40719,1661,2,67,2,1816.50,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(557,NULL,193,40719,1661,2,13,1,10466.50,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(558,NULL,194,40719,1661,2,96,2,219500.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(559,NULL,194,40719,1661,2,67,2,46095.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(560,NULL,194,40719,1661,2,13,1,265595.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(561,NULL,195,40719,1661,2,218,2,78529.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(562,NULL,195,40719,1661,2,13,1,78529.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(563,NULL,196,40719,1661,2,218,2,302258.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(564,NULL,196,40719,1661,2,13,1,302258.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14');
INSERT INTO `balance_libro_details` VALUES (565,NULL,197,40719,1661,2,218,2,18755.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(566,NULL,197,40719,1661,2,13,1,18755.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(567,NULL,198,40719,1661,2,218,2,64800.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(568,NULL,198,40719,1661,2,13,1,64800.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(569,NULL,199,40719,1661,2,96,2,6400.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(570,NULL,199,40719,1661,2,67,2,1344.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(571,NULL,199,40719,1661,2,13,1,7744.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(572,NULL,200,40719,1661,2,96,2,18676.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(573,NULL,200,40719,1661,2,67,2,3921.96,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(574,NULL,200,40719,1661,2,13,1,22597.96,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(575,NULL,201,40719,1661,2,96,2,81000.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(576,NULL,201,40719,1661,2,67,2,17010.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(577,NULL,201,40719,1661,2,13,1,98010.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(578,NULL,202,40719,1661,2,96,2,8750.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(579,NULL,202,40719,1661,2,67,2,1837.50,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(580,NULL,202,40719,1661,2,13,1,10587.50,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(581,NULL,203,40719,1661,2,96,2,19600.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(582,NULL,203,40719,1661,2,67,2,4116.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(583,NULL,203,40719,1661,2,13,1,23716.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(584,NULL,204,40719,1661,2,96,2,19600.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(585,NULL,204,40719,1661,2,67,2,4116.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(586,NULL,204,40719,1661,2,13,1,23716.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(587,NULL,205,40719,1661,2,96,2,58000.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(588,NULL,205,40719,1661,2,67,2,12180.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(589,NULL,205,40719,1661,2,13,1,70180.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(590,NULL,206,40719,1661,2,96,2,55800.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(591,NULL,206,40719,1661,2,67,2,11718.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(592,NULL,206,40719,1661,2,13,1,67518.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(593,NULL,207,40719,1661,2,96,2,31500.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(594,NULL,207,40719,1661,2,67,2,6615.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(595,NULL,207,40719,1661,2,13,1,38115.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(596,NULL,208,40719,1661,2,96,2,20820.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(597,NULL,208,40719,1661,2,67,2,4372.20,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(598,NULL,208,40719,1661,2,13,1,25192.20,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(599,NULL,209,40719,1661,2,96,2,8400.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14');
INSERT INTO `balance_libro_details` VALUES (600,NULL,209,40719,1661,2,67,2,1764.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(601,NULL,209,40719,1661,2,13,1,10164.00,NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(602,NULL,210,40719,1661,2,96,2,16200.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(603,NULL,210,40719,1661,2,67,2,3402.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(604,NULL,210,40719,1661,2,13,1,19602.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(605,NULL,211,40719,1661,2,96,2,32025.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(606,NULL,211,40719,1661,2,67,2,6725.25,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(607,NULL,211,40719,1661,2,13,1,38750.25,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(608,NULL,212,40719,1661,2,96,2,16200.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(609,NULL,212,40719,1661,2,67,2,3402.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(610,NULL,212,40719,1661,2,13,1,19602.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(611,NULL,213,40719,1661,2,96,2,52500.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(612,NULL,213,40719,1661,2,67,2,11025.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(613,NULL,213,40719,1661,2,13,1,63525.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(614,NULL,214,40719,1661,2,218,2,159132.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(615,NULL,214,40719,1661,2,13,1,159132.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(616,NULL,215,40719,1661,2,218,2,26680.50,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(617,NULL,215,40719,1661,2,13,1,26680.50,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(618,NULL,216,40719,1661,2,218,2,38115.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(619,NULL,216,40719,1661,2,13,1,38115.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(620,NULL,217,40719,1661,2,218,2,18755.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(621,NULL,217,40719,1661,2,13,1,18755.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(622,NULL,218,40719,1661,2,218,2,13320.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(623,NULL,218,40719,1661,2,13,1,13320.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(624,NULL,219,40719,1661,2,96,2,38400.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(625,NULL,219,40719,1661,2,67,2,8064.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(626,NULL,219,40719,1661,2,13,1,46464.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(627,NULL,220,40719,1661,2,96,2,172500.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(628,NULL,220,40719,1661,2,67,2,36225.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(629,NULL,220,40719,1661,2,13,1,208725.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(630,NULL,221,40719,1661,2,96,2,172500.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(631,NULL,221,40719,1661,2,67,2,36225.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(632,NULL,221,40719,1661,2,13,1,208725.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(633,NULL,222,40719,1661,2,96,2,167700.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(634,NULL,222,40719,1661,2,67,2,35217.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15');
INSERT INTO `balance_libro_details` VALUES (635,NULL,222,40719,1661,2,13,1,202917.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(636,NULL,223,40719,1661,2,96,2,3100.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(637,NULL,223,40719,1661,2,67,2,651.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(638,NULL,223,40719,1661,2,13,1,3751.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(639,NULL,224,40719,1661,2,96,2,104000.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(640,NULL,224,40719,1661,2,67,2,21840.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(641,NULL,224,40719,1661,2,13,1,125840.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(642,NULL,225,40719,1661,2,96,2,775.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(643,NULL,225,40719,1661,2,67,2,162.75,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(644,NULL,225,40719,1661,2,13,1,937.75,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(645,NULL,226,40719,1661,2,96,2,775.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(646,NULL,226,40719,1661,2,67,2,162.75,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(647,NULL,226,40719,1661,2,13,1,937.75,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(648,NULL,227,40719,1661,2,218,2,176418.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(649,NULL,227,40719,1661,2,13,1,176418.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(650,NULL,228,40719,1661,2,218,2,8228.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(651,NULL,228,40719,1661,2,13,1,8228.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(652,NULL,229,40719,1661,2,218,2,55660.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(653,NULL,229,40719,1661,2,13,1,55660.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(654,NULL,230,40719,1661,2,218,2,100963.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(655,NULL,230,40719,1661,2,13,1,100963.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(656,NULL,231,40719,1661,2,218,2,42350.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(657,NULL,231,40719,1661,2,13,1,42350.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(658,NULL,232,40719,1661,2,96,2,4440.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(659,NULL,232,40719,1661,2,67,2,932.40,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(660,NULL,232,40719,1661,2,13,1,5372.40,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(661,NULL,233,40719,1661,2,96,2,36800.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(662,NULL,233,40719,1661,2,67,2,7728.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(663,NULL,233,40719,1661,2,13,1,44528.00,NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(664,NULL,234,40719,1661,2,96,2,662917.50,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(665,NULL,234,40719,1661,2,67,2,139212.68,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(666,NULL,234,40719,1661,2,13,1,802130.18,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(667,NULL,235,40719,1661,2,96,2,142600.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(668,NULL,235,40719,1661,2,67,2,29946.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(669,NULL,235,40719,1661,2,13,1,172546.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15');
INSERT INTO `balance_libro_details` VALUES (670,NULL,236,40719,1661,2,96,2,64000.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(671,NULL,236,40719,1661,2,67,2,13440.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(672,NULL,236,40719,1661,2,13,1,77440.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(673,NULL,237,40719,1661,2,218,2,9982.50,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(674,NULL,237,40719,1661,2,13,1,9982.50,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(675,NULL,238,40719,1661,2,96,2,42000.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(676,NULL,238,40719,1661,2,67,2,8820.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(677,NULL,238,40719,1661,2,13,1,50820.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(678,NULL,239,40719,1661,2,96,2,16200.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(679,NULL,239,40719,1661,2,67,2,3402.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(680,NULL,239,40719,1661,2,13,1,19602.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(681,NULL,240,40719,1661,2,96,2,244960.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(682,NULL,240,40719,1661,2,67,2,51441.60,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(683,NULL,240,40719,1661,2,13,1,296401.60,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(684,NULL,241,40719,1661,2,96,1,244960.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(685,NULL,241,40719,1661,2,68,1,51441.60,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(686,NULL,241,40719,1661,2,13,2,296401.60,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(687,NULL,242,40719,1661,2,96,2,132000.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(688,NULL,242,40719,1661,2,67,2,27720.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(689,NULL,242,40719,1661,2,13,1,159720.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(690,NULL,243,40719,1661,2,96,2,40000.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(691,NULL,243,40719,1661,2,67,2,8400.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(692,NULL,243,40719,1661,2,13,1,48400.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(693,NULL,244,40719,1661,2,96,2,135699.20,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(694,NULL,244,40719,1661,2,67,2,28496.83,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(695,NULL,244,40719,1661,2,13,1,164196.03,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(696,NULL,245,40719,1661,2,96,2,135000.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(697,NULL,245,40719,1661,2,67,2,28350.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(698,NULL,245,40719,1661,2,13,1,163350.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(699,NULL,246,40719,1661,2,96,2,210000.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(700,NULL,246,40719,1661,2,67,2,44100.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(701,NULL,246,40719,1661,2,13,1,254100.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(702,NULL,247,40719,1661,2,96,2,13725.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(703,NULL,247,40719,1661,2,67,2,2882.25,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(704,NULL,247,40719,1661,2,13,1,16607.25,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15');
INSERT INTO `balance_libro_details` VALUES (705,NULL,248,40719,1661,2,96,2,21750.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(706,NULL,248,40719,1661,2,67,2,4567.50,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(707,NULL,248,40719,1661,2,13,1,26317.50,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(708,NULL,249,40719,1661,2,96,2,236400.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(709,NULL,249,40719,1661,2,67,2,49644.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(710,NULL,249,40719,1661,2,13,1,286044.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(711,NULL,250,40719,1661,2,96,2,4350.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(712,NULL,250,40719,1661,2,67,2,913.50,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(713,NULL,250,40719,1661,2,13,1,5263.50,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(714,NULL,251,40719,1661,2,96,2,281624.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(715,NULL,251,40719,1661,2,67,2,59141.04,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(716,NULL,251,40719,1661,2,13,1,340765.04,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(717,NULL,252,40719,1661,2,96,2,141799.00,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(718,NULL,252,40719,1661,2,67,2,29777.79,NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(719,NULL,252,40719,1661,2,13,1,171576.79,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(720,NULL,253,40719,1661,2,96,2,117600.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(721,NULL,253,40719,1661,2,67,2,24696.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(722,NULL,253,40719,1661,2,13,1,142296.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(723,NULL,254,40719,1661,2,96,2,40500.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(724,NULL,254,40719,1661,2,67,2,8505.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(725,NULL,254,40719,1661,2,13,1,49005.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(726,NULL,255,40719,1661,2,218,2,17800.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(727,NULL,255,40719,1661,2,13,1,17800.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(728,NULL,256,40719,1661,2,96,2,24393.60,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(729,NULL,256,40719,1661,2,67,2,5122.66,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(730,NULL,256,40719,1661,2,13,1,29516.26,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(731,NULL,257,40719,1661,2,96,2,24393.60,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(732,NULL,257,40719,1661,2,67,2,5122.66,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(733,NULL,257,40719,1661,2,13,1,29516.26,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(734,NULL,258,40719,1661,2,96,2,32000.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(735,NULL,258,40719,1661,2,67,2,6720.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(736,NULL,258,40719,1661,2,13,1,38720.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(737,NULL,259,40719,1661,2,96,2,510000.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(738,NULL,259,40719,1661,2,67,2,107100.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(739,NULL,259,40719,1661,2,13,1,617100.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15');
INSERT INTO `balance_libro_details` VALUES (740,NULL,260,40719,1661,2,96,2,244960.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(741,NULL,260,40719,1661,2,67,2,51441.60,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(742,NULL,260,40719,1661,2,13,1,296401.60,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(743,NULL,261,40719,1661,2,96,2,42000.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(744,NULL,261,40719,1661,2,67,2,8820.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(745,NULL,261,40719,1661,2,13,1,50820.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(746,NULL,262,40719,1661,2,96,2,12400.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(747,NULL,262,40719,1661,2,67,2,2604.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(748,NULL,262,40719,1661,2,13,1,15004.00,NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(749,7777,263,40719,1661,8,276,1,49604.87,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(750,7777,263,40719,1661,8,351,2,49604.87,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(751,7777,264,40719,1661,8,277,1,255167.29,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(752,7777,264,40719,1661,8,351,2,255167.29,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(753,7777,265,40719,1661,8,281,1,10637.14,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(754,7777,265,40719,1661,8,351,2,10637.14,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(755,7777,266,40719,1661,8,292,1,6058.51,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(756,7777,266,40719,1661,8,351,2,6058.51,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(757,7777,267,40719,1661,8,300,1,8654.62,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(758,7777,267,40719,1661,8,351,2,8654.62,NULL,'2022-09-27 10:54:20','2022-09-27 13:30:14','2022-09-27 13:30:14'),(759,7777,268,40719,1661,8,276,1,49604.87,NULL,'2022-09-27 10:55:28','2022-09-27 13:30:14','2022-09-27 13:30:14'),(760,7777,268,40719,1661,8,351,2,49604.87,NULL,'2022-09-27 10:55:28','2022-09-27 13:30:14','2022-09-27 13:30:14'),(761,7777,269,40719,1661,8,277,1,255167.29,NULL,'2022-09-27 10:55:28','2022-09-27 13:30:14','2022-09-27 13:30:14'),(762,7777,269,40719,1661,8,351,2,255167.29,NULL,'2022-09-27 10:55:28','2022-09-27 13:30:14','2022-09-27 13:30:14'),(763,7777,270,40719,1661,8,281,1,10637.14,NULL,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(764,7777,270,40719,1661,8,351,2,10637.14,NULL,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(765,7777,271,40719,1661,8,292,1,6058.51,NULL,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(766,7777,271,40719,1661,8,351,2,6058.51,NULL,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(767,7777,272,40719,1661,8,300,1,8654.62,NULL,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(768,7777,272,40719,1661,8,351,2,8654.62,NULL,'2022-09-27 10:55:29','2022-09-27 13:30:14','2022-09-27 13:30:14'),(769,NULL,273,40719,1661,2,96,2,2500.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(770,NULL,273,40719,1661,2,67,2,525.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(771,NULL,273,40719,1661,2,13,1,3025.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(772,NULL,274,40719,1661,2,96,2,9750.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(773,NULL,274,40719,1661,2,67,2,2047.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(774,NULL,274,40719,1661,2,13,1,11797.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(775,NULL,275,40719,1661,2,96,1,160000.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL);
INSERT INTO `balance_libro_details` VALUES (776,NULL,275,40719,1661,2,68,1,33600.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(777,NULL,275,40719,1661,2,13,2,193600.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(778,NULL,276,40719,1661,2,218,2,73872.48,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(779,NULL,276,40719,1661,2,13,1,73872.48,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(780,NULL,277,40719,1661,2,218,2,4094.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(781,NULL,277,40719,1661,2,13,1,4094.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(782,NULL,278,40719,1661,2,218,2,2420.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(783,NULL,278,40719,1661,2,13,1,2420.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(784,NULL,279,40719,1661,2,218,2,2521.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(785,NULL,279,40719,1661,2,13,1,2521.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(786,NULL,280,40719,1661,2,218,2,2420.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(787,NULL,280,40719,1661,2,13,1,2420.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(788,NULL,281,40719,1661,2,96,2,13000.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(789,NULL,281,40719,1661,2,67,2,2730.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(790,NULL,281,40719,1661,2,13,1,15730.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(791,NULL,282,40719,1661,2,96,2,46000.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(792,NULL,282,40719,1661,2,67,2,9660.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(793,NULL,282,40719,1661,2,13,1,55660.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(794,NULL,283,40719,1661,2,96,2,46000.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(795,NULL,283,40719,1661,2,67,2,9660.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(796,NULL,283,40719,1661,2,13,1,55660.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(797,NULL,284,40719,1661,2,96,2,2450.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(798,NULL,284,40719,1661,2,67,2,514.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(799,NULL,284,40719,1661,2,13,1,2964.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(800,NULL,285,40719,1661,2,96,2,4750.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(801,NULL,285,40719,1661,2,67,2,997.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(802,NULL,285,40719,1661,2,13,1,5747.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(803,NULL,286,40719,1661,2,96,2,6850.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(804,NULL,286,40719,1661,2,67,2,1438.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(805,NULL,286,40719,1661,2,13,1,8288.50,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(806,NULL,287,40719,1661,2,96,2,1582400.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(807,NULL,287,40719,1661,2,67,2,332304.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(808,NULL,287,40719,1661,2,13,1,1914704.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(809,NULL,288,40719,1661,2,96,2,261000.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(810,NULL,288,40719,1661,2,67,2,54810.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(811,NULL,288,40719,1661,2,13,1,315810.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(812,NULL,289,40719,1661,2,96,2,65600.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(813,NULL,289,40719,1661,2,67,2,13776.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(814,NULL,289,40719,1661,2,13,1,79376.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(815,NULL,290,40719,1661,2,96,2,65600.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(816,NULL,290,40719,1661,2,67,2,13776.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL);
INSERT INTO `balance_libro_details` VALUES (817,NULL,290,40719,1661,2,13,1,79376.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(818,NULL,291,40719,1661,2,96,2,69200.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(819,NULL,291,40719,1661,2,67,2,14532.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(820,NULL,291,40719,1661,2,13,1,83732.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(821,NULL,292,40719,1661,2,96,2,67700.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(822,NULL,292,40719,1661,2,67,2,14217.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(823,NULL,292,40719,1661,2,13,1,81917.00,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(824,NULL,293,40719,1661,2,96,2,64000.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(825,NULL,293,40719,1661,2,67,2,13440.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(826,NULL,293,40719,1661,2,13,1,77440.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(827,NULL,294,40719,1661,2,218,2,3751.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(828,NULL,294,40719,1661,2,13,1,3751.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(829,NULL,295,40719,1661,2,218,2,157865.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(830,NULL,295,40719,1661,2,13,1,157865.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(831,NULL,296,40719,1661,2,218,2,30250.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(832,NULL,296,40719,1661,2,13,1,30250.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(833,NULL,297,40719,1661,2,218,2,285560.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(834,NULL,297,40719,1661,2,13,1,285560.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(835,NULL,298,40719,1661,2,218,2,36300.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(836,NULL,298,40719,1661,2,13,1,36300.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(837,NULL,299,40719,1661,2,96,2,51320.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(838,NULL,299,40719,1661,2,67,2,10777.20,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(839,NULL,299,40719,1661,2,13,1,62097.20,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(840,NULL,300,40719,1661,2,96,2,22000.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(841,NULL,300,40719,1661,2,67,2,4620.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(842,NULL,300,40719,1661,2,13,1,26620.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(843,NULL,301,40719,1661,2,96,2,41107.50,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(844,NULL,301,40719,1661,2,67,2,8632.58,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(845,NULL,301,40719,1661,2,13,1,49740.08,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(846,NULL,302,40719,1661,2,96,2,101800.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(847,NULL,302,40719,1661,2,67,2,21378.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(848,NULL,302,40719,1661,2,13,1,123178.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(849,NULL,303,40719,1661,2,96,2,16000.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(850,NULL,303,40719,1661,2,67,2,3360.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(851,NULL,303,40719,1661,2,13,1,19360.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(852,NULL,304,40719,1661,2,96,2,69650.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(853,NULL,304,40719,1661,2,67,2,14626.50,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(854,NULL,304,40719,1661,2,13,1,84276.50,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(855,NULL,305,40719,1661,2,96,2,5160.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(856,NULL,305,40719,1661,2,67,2,1083.60,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(857,NULL,305,40719,1661,2,13,1,6243.60,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL);
INSERT INTO `balance_libro_details` VALUES (858,NULL,306,40719,1661,2,96,2,19300.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(859,NULL,306,40719,1661,2,67,2,4053.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(860,NULL,306,40719,1661,2,13,1,23353.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(861,NULL,307,40719,1661,2,96,2,21249.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(862,NULL,307,40719,1661,2,67,2,4462.29,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(863,NULL,307,40719,1661,2,13,1,25711.29,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(864,NULL,308,40719,1661,2,96,2,63522.54,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(865,NULL,308,40719,1661,2,67,2,13339.73,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(866,NULL,308,40719,1661,2,13,1,76862.27,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(867,NULL,309,40719,1661,2,96,2,92122.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(868,NULL,309,40719,1661,2,67,2,19345.62,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(869,NULL,309,40719,1661,2,13,1,111467.62,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(870,NULL,310,40719,1661,2,96,2,541.36,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(871,NULL,310,40719,1661,2,67,2,113.69,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(872,NULL,310,40719,1661,2,13,1,655.05,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(873,NULL,311,40719,1661,2,96,2,3222.90,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(874,NULL,311,40719,1661,2,67,2,676.81,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(875,NULL,311,40719,1661,2,13,1,3899.71,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(876,NULL,312,40719,1661,2,96,2,68784.20,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(877,NULL,312,40719,1661,2,67,2,14444.68,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(878,NULL,312,40719,1661,2,13,1,83228.88,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(879,NULL,313,40719,1661,2,96,2,77030.80,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(880,NULL,313,40719,1661,2,67,2,16176.47,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(881,NULL,313,40719,1661,2,13,1,93207.27,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(882,NULL,314,40719,1661,2,96,2,451500.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(883,NULL,314,40719,1661,2,67,2,94815.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(884,NULL,314,40719,1661,2,13,1,546315.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(885,NULL,315,40719,1661,2,96,2,51519.50,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(886,NULL,315,40719,1661,2,67,2,10819.10,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(887,NULL,315,40719,1661,2,13,1,62338.60,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(888,NULL,316,40719,1661,2,96,2,21537.00,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(889,NULL,316,40719,1661,2,67,2,4522.77,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(890,NULL,316,40719,1661,2,13,1,26059.77,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(891,NULL,317,40719,1661,2,96,2,3683.40,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(892,NULL,317,40719,1661,2,67,2,773.51,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(893,NULL,317,40719,1661,2,13,1,4456.91,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(894,NULL,318,40719,1661,2,96,2,4200.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(895,NULL,318,40719,1661,2,67,2,882.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(896,NULL,318,40719,1661,2,13,1,5082.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(897,NULL,319,40719,1661,2,96,2,148800.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(898,NULL,319,40719,1661,2,67,2,31248.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL);
INSERT INTO `balance_libro_details` VALUES (899,NULL,319,40719,1661,2,13,1,180048.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(900,NULL,320,40719,1661,2,96,2,37200.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(901,NULL,320,40719,1661,2,67,2,7812.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(902,NULL,320,40719,1661,2,13,1,45012.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(903,NULL,321,40719,1661,2,96,2,240000.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(904,NULL,321,40719,1661,2,67,2,50400.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(905,NULL,321,40719,1661,2,13,1,290400.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(906,NULL,322,40719,1661,2,96,2,156000.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(907,NULL,322,40719,1661,2,67,2,32760.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(908,NULL,322,40719,1661,2,13,1,188760.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(909,NULL,323,40719,1661,2,96,2,352000.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(910,NULL,323,40719,1661,2,67,2,73920.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(911,NULL,323,40719,1661,2,13,1,425920.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(912,NULL,324,40719,1661,2,96,2,21000.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(913,NULL,324,40719,1661,2,67,2,4410.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(914,NULL,324,40719,1661,2,13,1,25410.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(915,NULL,325,40719,1661,2,96,2,110000.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(916,NULL,325,40719,1661,2,67,2,23100.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(917,NULL,325,40719,1661,2,13,1,133100.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(918,NULL,326,40719,1661,2,218,2,708329.14,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(919,NULL,326,40719,1661,2,13,1,708329.14,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(920,NULL,327,40719,1661,2,218,2,77319.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(921,NULL,327,40719,1661,2,13,1,77319.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(922,NULL,328,40719,1661,2,218,2,5666.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(923,NULL,328,40719,1661,2,13,1,5666.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(924,NULL,329,40719,1661,2,218,2,2200.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(925,NULL,329,40719,1661,2,13,1,2200.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(926,NULL,330,40719,1661,2,218,1,230.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(927,NULL,330,40719,1661,2,13,2,230.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(928,NULL,331,40719,1661,2,218,1,37200.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(929,NULL,331,40719,1661,2,13,2,37200.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(930,NULL,332,40719,1661,2,218,2,75867.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(931,NULL,332,40719,1661,2,13,1,75867.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(932,NULL,333,40719,1661,2,96,2,40500.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(933,NULL,333,40719,1661,2,67,2,8505.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(934,NULL,333,40719,1661,2,13,1,49005.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(935,NULL,334,40719,1661,2,218,2,106480.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(936,NULL,334,40719,1661,2,13,1,106480.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(937,NULL,335,40719,1661,2,96,2,43400.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(938,NULL,335,40719,1661,2,67,2,9114.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(939,NULL,335,40719,1661,2,13,1,52514.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL);
INSERT INTO `balance_libro_details` VALUES (940,NULL,336,40719,1661,2,96,2,35190.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(941,NULL,336,40719,1661,2,67,2,7389.90,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(942,NULL,336,40719,1661,2,13,1,42579.90,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(943,NULL,337,40719,1661,2,96,2,217878.00,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(944,NULL,337,40719,1661,2,67,2,45754.38,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(945,NULL,337,40719,1661,2,13,1,263632.38,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(946,NULL,338,40719,1661,2,96,2,43400.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(947,NULL,338,40719,1661,2,67,2,9114.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(948,NULL,338,40719,1661,2,13,1,52514.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(949,NULL,339,40719,1661,2,96,2,278683.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(950,NULL,339,40719,1661,2,67,2,58523.43,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(951,NULL,339,40719,1661,2,13,1,337206.43,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(952,NULL,340,40719,1661,2,96,2,285000.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(953,NULL,340,40719,1661,2,67,2,59850.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(954,NULL,340,40719,1661,2,13,1,344850.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(955,NULL,341,40719,1661,2,96,2,95000.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(956,NULL,341,40719,1661,2,67,2,19950.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(957,NULL,341,40719,1661,2,13,1,114950.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(958,NULL,342,40719,1661,2,96,2,112500.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(959,NULL,342,40719,1661,2,67,2,23625.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(960,NULL,342,40719,1661,2,13,1,136125.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(961,NULL,343,40719,1661,2,96,2,99600.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(962,NULL,343,40719,1661,2,67,2,20916.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(963,NULL,343,40719,1661,2,13,1,120516.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(964,NULL,344,40719,1661,2,96,2,25800.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(965,NULL,344,40719,1661,2,67,2,5418.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(966,NULL,344,40719,1661,2,13,1,31218.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(967,NULL,345,40719,1661,2,96,2,43500.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(968,NULL,345,40719,1661,2,67,2,9135.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(969,NULL,345,40719,1661,2,13,1,52635.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(970,NULL,346,40719,1661,2,96,2,43500.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(971,NULL,346,40719,1661,2,67,2,9135.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(972,NULL,346,40719,1661,2,13,1,52635.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(973,NULL,347,40719,1661,2,96,2,16000.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(974,NULL,347,40719,1661,2,67,2,3360.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(975,NULL,347,40719,1661,2,13,1,19360.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(976,NULL,348,40719,1661,2,96,2,195750.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(977,NULL,348,40719,1661,2,67,2,41107.50,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(978,NULL,348,40719,1661,2,13,1,236857.50,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(979,NULL,349,40719,1661,2,96,2,95400.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(980,NULL,349,40719,1661,2,67,2,20034.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL);
INSERT INTO `balance_libro_details` VALUES (981,NULL,349,40719,1661,2,13,1,115434.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(982,NULL,350,40719,1661,2,96,2,72000.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(983,NULL,350,40719,1661,2,67,2,15120.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(984,NULL,350,40719,1661,2,13,1,87120.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(985,NULL,351,40719,1661,2,96,2,92400.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(986,NULL,351,40719,1661,2,67,2,19404.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(987,NULL,351,40719,1661,2,13,1,111804.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(988,NULL,352,40719,1661,2,96,2,92400.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(989,NULL,352,40719,1661,2,67,2,19404.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(990,NULL,352,40719,1661,2,13,1,111804.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(991,NULL,353,40719,1661,2,96,2,142500.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(992,NULL,353,40719,1661,2,67,2,29925.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(993,NULL,353,40719,1661,2,13,1,172425.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(994,NULL,354,40719,1661,2,96,2,92400.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(995,NULL,354,40719,1661,2,67,2,19404.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(996,NULL,354,40719,1661,2,13,1,111804.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(997,NULL,355,40719,1661,2,96,2,92400.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(998,NULL,355,40719,1661,2,67,2,19404.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(999,NULL,355,40719,1661,2,13,1,111804.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(1000,NULL,356,40719,1661,2,96,2,128000.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(1001,NULL,356,40719,1661,2,67,2,26880.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(1002,NULL,356,40719,1661,2,13,1,154880.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(1003,NULL,357,40719,1661,2,96,2,42000.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(1004,NULL,357,40719,1661,2,67,2,8820.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(1005,NULL,357,40719,1661,2,13,1,50820.00,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(1006,NULL,358,40719,1661,2,96,2,61900.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1007,NULL,358,40719,1661,2,67,2,12999.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1008,NULL,358,40719,1661,2,13,1,74899.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1009,NULL,359,40719,1661,2,96,2,19200.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1010,NULL,359,40719,1661,2,67,2,4032.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1011,NULL,359,40719,1661,2,13,1,23232.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1012,NULL,360,40719,1661,2,96,2,77602.50,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1013,NULL,360,40719,1661,2,67,2,16296.53,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1014,NULL,360,40719,1661,2,13,1,93899.03,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1015,NULL,361,40719,1661,2,96,2,22130.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1016,NULL,361,40719,1661,2,67,2,4647.30,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1017,NULL,361,40719,1661,2,13,1,26777.30,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1018,NULL,362,40719,1661,2,96,2,22400.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1019,NULL,362,40719,1661,2,67,2,4704.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1020,NULL,362,40719,1661,2,13,1,27104.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1021,NULL,363,40719,1661,2,96,2,76460.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1022,NULL,363,40719,1661,2,67,2,16056.60,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1023,NULL,363,40719,1661,2,13,1,92516.60,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1024,NULL,364,40719,1661,2,96,2,16880.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1025,NULL,364,40719,1661,2,67,2,3544.80,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1026,NULL,364,40719,1661,2,13,1,20424.80,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1027,NULL,365,40719,1661,2,96,2,10800.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1028,NULL,365,40719,1661,2,67,2,2268.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1029,NULL,365,40719,1661,2,13,1,13068.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1030,NULL,366,40719,1661,2,96,1,10800.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1031,NULL,366,40719,1661,2,68,1,2268.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1032,NULL,366,40719,1661,2,13,2,13068.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1033,NULL,367,40719,1661,2,96,2,14340.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1034,NULL,367,40719,1661,2,67,2,3011.40,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1035,NULL,367,40719,1661,2,13,1,17351.40,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1036,NULL,368,40719,1661,2,96,2,78400.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1037,NULL,368,40719,1661,2,67,2,16464.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1038,NULL,368,40719,1661,2,13,1,94864.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1039,NULL,369,40719,1661,2,96,2,30000.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1040,NULL,369,40719,1661,2,67,2,6300.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1041,NULL,369,40719,1661,2,13,1,36300.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1042,NULL,370,40719,1661,2,96,2,16500.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1043,NULL,370,40719,1661,2,67,2,3465.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1044,NULL,370,40719,1661,2,13,1,19965.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1045,NULL,371,40719,1661,2,96,2,30000.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1046,NULL,371,40719,1661,2,67,2,6300.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1047,NULL,371,40719,1661,2,13,1,36300.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1048,NULL,372,40719,1661,2,96,2,966875.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1049,NULL,372,40719,1661,2,67,2,203043.75,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1050,NULL,372,40719,1661,2,13,1,1169918.75,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1051,NULL,373,40719,1661,2,96,2,18000.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1052,NULL,373,40719,1661,2,67,2,3780.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1053,NULL,373,40719,1661,2,13,1,21780.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1054,NULL,374,40719,1661,2,96,2,62000.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1055,NULL,374,40719,1661,2,67,2,13020.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1056,NULL,374,40719,1661,2,13,1,75020.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1057,NULL,375,40719,1661,2,96,2,108000.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1058,NULL,375,40719,1661,2,67,2,22680.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1059,NULL,375,40719,1661,2,13,1,130680.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1060,NULL,376,40719,1661,2,96,2,50250.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1061,NULL,376,40719,1661,2,67,2,10552.50,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1062,NULL,376,40719,1661,2,13,1,60802.50,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1063,NULL,377,40719,1661,2,96,2,15000.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1064,NULL,377,40719,1661,2,67,2,3150.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1065,NULL,377,40719,1661,2,13,1,18150.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1066,NULL,378,40719,1661,2,96,2,31000.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1067,NULL,378,40719,1661,2,67,2,6510.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1068,NULL,378,40719,1661,2,13,1,37510.00,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(1069,NULL,379,40719,1661,2,96,2,65600.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1070,NULL,379,40719,1661,2,67,2,13776.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1071,NULL,379,40719,1661,2,13,1,79376.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1072,NULL,380,40719,1661,2,96,2,70400.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1073,NULL,380,40719,1661,2,67,2,14784.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1074,NULL,380,40719,1661,2,13,1,85184.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1075,NULL,381,40719,1661,2,96,2,35200.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1076,NULL,381,40719,1661,2,67,2,7392.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1077,NULL,381,40719,1661,2,13,1,42592.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1078,NULL,382,40719,1661,2,96,2,82215.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1079,NULL,382,40719,1661,2,67,2,17265.15,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1080,NULL,382,40719,1661,2,13,1,99480.15,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1081,NULL,383,40719,1661,2,96,2,141000.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1082,NULL,383,40719,1661,2,67,2,29610.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1083,NULL,383,40719,1661,2,13,1,170610.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1084,NULL,384,40719,1661,2,96,2,68750.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1085,NULL,384,40719,1661,2,67,2,14437.50,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1086,NULL,384,40719,1661,2,13,1,83187.50,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1087,NULL,385,40719,1661,2,96,2,37500.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1088,NULL,385,40719,1661,2,67,2,7875.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1089,NULL,385,40719,1661,2,13,1,45375.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1090,NULL,386,40719,1661,2,96,2,19700.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1091,NULL,386,40719,1661,2,67,2,4137.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1092,NULL,386,40719,1661,2,13,1,23837.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1093,NULL,387,40719,1661,2,96,2,27500.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1094,NULL,387,40719,1661,2,67,2,5775.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1095,NULL,387,40719,1661,2,13,1,33275.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1096,NULL,388,40719,1661,2,96,1,104000.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1097,NULL,388,40719,1661,2,68,1,21840.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1098,NULL,388,40719,1661,2,13,2,125840.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1099,NULL,389,40719,1661,2,96,2,9000.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1100,NULL,389,40719,1661,2,67,2,1890.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1101,NULL,389,40719,1661,2,13,1,10890.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1102,NULL,390,40719,1661,2,96,2,17500.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1103,NULL,390,40719,1661,2,67,2,3675.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1104,NULL,390,40719,1661,2,13,1,21175.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1105,NULL,391,40719,1661,2,218,1,52030.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1106,NULL,391,40719,1661,2,13,2,52030.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1107,NULL,392,40719,1661,2,96,2,49275.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1108,NULL,392,40719,1661,2,67,2,10347.75,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1109,NULL,392,40719,1661,2,13,1,59622.75,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1110,NULL,393,40719,1661,2,96,2,22000.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1111,NULL,393,40719,1661,2,67,2,4620.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1112,NULL,393,40719,1661,2,13,1,26620.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1113,NULL,394,40719,1661,2,96,2,189000.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1114,NULL,394,40719,1661,2,67,2,39690.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1115,NULL,394,40719,1661,2,13,1,228690.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1116,NULL,395,40719,1661,2,96,2,40900.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1117,NULL,395,40719,1661,2,67,2,8589.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1118,NULL,395,40719,1661,2,13,1,49489.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1119,NULL,396,40719,1661,2,96,2,191166.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1120,NULL,396,40719,1661,2,67,2,40144.86,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1121,NULL,396,40719,1661,2,13,1,231310.86,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1122,NULL,397,40719,1661,2,96,2,191166.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1123,NULL,397,40719,1661,2,67,2,40144.86,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1124,NULL,397,40719,1661,2,13,1,231310.86,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1125,NULL,398,40719,1661,2,96,2,89488.00,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1126,NULL,398,40719,1661,2,67,2,18792.48,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1127,NULL,398,40719,1661,2,13,1,108280.48,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(1128,NULL,399,40719,1661,2,96,2,161438.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1129,NULL,399,40719,1661,2,67,2,33901.98,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1130,NULL,399,40719,1661,2,13,1,195339.98,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1131,NULL,400,40719,1661,2,96,2,89800.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1132,NULL,400,40719,1661,2,67,2,18858.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1133,NULL,400,40719,1661,2,13,1,108658.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1134,NULL,401,40719,1661,2,96,2,55200.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1135,NULL,401,40719,1661,2,67,2,11592.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1136,NULL,401,40719,1661,2,13,1,66792.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1137,NULL,402,40719,1661,2,96,2,86100.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1138,NULL,402,40719,1661,2,67,2,18081.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1139,NULL,402,40719,1661,2,13,1,104181.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1140,NULL,403,40719,1661,2,96,2,117800.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1141,NULL,403,40719,1661,2,67,2,24738.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1142,NULL,403,40719,1661,2,13,1,142538.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1143,NULL,404,40719,1661,2,96,2,17800.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1144,NULL,404,40719,1661,2,67,2,3738.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL);
INSERT INTO `balance_libro_details` VALUES (1145,NULL,404,40719,1661,2,13,1,21538.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1146,NULL,405,40719,1661,2,96,2,15500.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1147,NULL,405,40719,1661,2,67,2,3255.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1148,NULL,405,40719,1661,2,13,1,18755.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1149,NULL,406,40719,1661,2,96,2,35600.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1150,NULL,406,40719,1661,2,67,2,7476.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1151,NULL,406,40719,1661,2,13,1,43076.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1152,NULL,407,40719,1661,2,96,2,28000.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1153,NULL,407,40719,1661,2,67,2,5880.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1154,NULL,407,40719,1661,2,13,1,33880.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1155,NULL,408,40719,1661,2,96,2,44250.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1156,NULL,408,40719,1661,2,67,2,9292.50,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1157,NULL,408,40719,1661,2,13,1,53542.50,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1158,NULL,409,40719,1661,2,96,2,6250.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1159,NULL,409,40719,1661,2,67,2,1312.50,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1160,NULL,409,40719,1661,2,13,1,7562.50,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1161,NULL,410,40719,1661,2,96,2,56400.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1162,NULL,410,40719,1661,2,67,2,11844.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1163,NULL,410,40719,1661,2,13,1,68244.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1164,NULL,411,40719,1661,2,96,2,18000.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1165,NULL,411,40719,1661,2,67,2,3780.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1166,NULL,411,40719,1661,2,13,1,21780.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1167,NULL,412,40719,1661,2,96,2,18000.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1168,NULL,412,40719,1661,2,67,2,3780.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1169,NULL,412,40719,1661,2,13,1,21780.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1170,NULL,413,40719,1661,2,96,2,43500.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1171,NULL,413,40719,1661,2,67,2,9135.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1172,NULL,413,40719,1661,2,13,1,52635.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1173,NULL,414,40719,1661,2,96,2,27900.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1174,NULL,414,40719,1661,2,67,2,5859.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1175,NULL,414,40719,1661,2,13,1,33759.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1176,NULL,415,40719,1661,2,96,2,101500.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1177,NULL,415,40719,1661,2,67,2,21315.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1178,NULL,415,40719,1661,2,13,1,122815.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1179,NULL,416,40719,1661,2,96,2,54000.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1180,NULL,416,40719,1661,2,67,2,11340.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1181,NULL,416,40719,1661,2,13,1,65340.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1182,NULL,417,40719,1661,2,96,2,353200.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1183,NULL,417,40719,1661,2,67,2,74172.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1184,NULL,417,40719,1661,2,13,1,427372.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1185,NULL,418,40719,1661,2,96,2,5600.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL);
INSERT INTO `balance_libro_details` VALUES (1186,NULL,418,40719,1661,2,67,2,1176.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1187,NULL,418,40719,1661,2,13,1,6776.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1188,NULL,419,40719,1661,2,96,2,145000.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1189,NULL,419,40719,1661,2,67,2,30450.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1190,NULL,419,40719,1661,2,13,1,175450.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1191,NULL,420,40719,1661,2,96,2,54000.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1192,NULL,420,40719,1661,2,67,2,11340.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1193,NULL,420,40719,1661,2,13,1,65340.00,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(1194,NULL,421,40719,1661,2,96,2,248000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1195,NULL,421,40719,1661,2,67,2,52080.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1196,NULL,421,40719,1661,2,13,1,300080.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1197,NULL,422,40719,1661,2,96,2,27900.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1198,NULL,422,40719,1661,2,67,2,5859.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1199,NULL,422,40719,1661,2,13,1,33759.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1200,NULL,423,40719,1661,2,96,2,54000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1201,NULL,423,40719,1661,2,67,2,11340.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1202,NULL,423,40719,1661,2,13,1,65340.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1203,NULL,424,40719,1661,2,96,2,40500.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1204,NULL,424,40719,1661,2,67,2,8505.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1205,NULL,424,40719,1661,2,13,1,49005.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1206,NULL,425,40719,1661,2,96,2,290000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1207,NULL,425,40719,1661,2,67,2,60900.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1208,NULL,425,40719,1661,2,13,1,350900.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1209,NULL,426,40719,1661,2,96,2,379900.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1210,NULL,426,40719,1661,2,67,2,79779.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1211,NULL,426,40719,1661,2,13,1,459679.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1212,NULL,427,40719,1661,2,96,1,30000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1213,NULL,427,40719,1661,2,68,1,6300.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1214,NULL,427,40719,1661,2,13,2,36300.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1215,NULL,428,40719,1661,2,96,2,300000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1216,NULL,428,40719,1661,2,67,2,63000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1217,NULL,428,40719,1661,2,13,1,363000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1218,NULL,429,40719,1661,2,96,2,28000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1219,NULL,429,40719,1661,2,67,2,5880.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1220,NULL,429,40719,1661,2,13,1,33880.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1221,NULL,430,40719,1661,2,218,2,83079.64,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1222,NULL,430,40719,1661,2,13,1,83079.64,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1223,NULL,431,40719,1661,2,218,2,54450.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1224,NULL,431,40719,1661,2,13,1,54450.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1225,NULL,432,40719,1661,2,96,2,51600.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1226,NULL,432,40719,1661,2,67,2,10836.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL);
INSERT INTO `balance_libro_details` VALUES (1227,NULL,432,40719,1661,2,13,1,62436.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1228,NULL,433,40719,1661,2,96,2,34400.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1229,NULL,433,40719,1661,2,67,2,7224.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1230,NULL,433,40719,1661,2,13,1,41624.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1231,NULL,434,40719,1661,2,96,2,51600.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1232,NULL,434,40719,1661,2,67,2,10836.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1233,NULL,434,40719,1661,2,13,1,62436.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1234,NULL,435,40719,1661,2,96,2,14000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1235,NULL,435,40719,1661,2,67,2,2940.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1236,NULL,435,40719,1661,2,13,1,16940.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1237,NULL,436,40719,1661,2,96,2,52800.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1238,NULL,436,40719,1661,2,67,2,11088.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1239,NULL,436,40719,1661,2,13,1,63888.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1240,NULL,437,40719,1661,2,96,2,70400.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1241,NULL,437,40719,1661,2,67,2,14784.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1242,NULL,437,40719,1661,2,13,1,85184.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1243,NULL,438,40719,1661,2,96,2,17200.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1244,NULL,438,40719,1661,2,67,2,3612.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1245,NULL,438,40719,1661,2,13,1,20812.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1246,NULL,439,40719,1661,2,96,2,33020.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1247,NULL,439,40719,1661,2,67,2,6934.20,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1248,NULL,439,40719,1661,2,13,1,39954.20,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1249,NULL,440,40719,1661,2,96,2,34500.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1250,NULL,440,40719,1661,2,67,2,7245.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1251,NULL,440,40719,1661,2,13,1,41745.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1252,NULL,441,40719,1661,2,96,2,18000.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1253,NULL,441,40719,1661,2,67,2,3780.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1254,NULL,441,40719,1661,2,13,1,21780.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1255,NULL,442,40719,1661,2,218,2,9075.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1256,NULL,442,40719,1661,2,13,1,9075.00,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(1257,NULL,443,40719,1661,2,96,2,25000.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1258,NULL,443,40719,1661,2,67,2,5250.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1259,NULL,443,40719,1661,2,13,1,30250.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1260,NULL,444,40719,1661,2,96,2,7500.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1261,NULL,444,40719,1661,2,67,2,1575.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1262,NULL,444,40719,1661,2,13,1,9075.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1263,NULL,445,40719,1661,2,218,1,9075.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1264,NULL,445,40719,1661,2,13,2,9075.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1265,NULL,446,40719,1661,2,96,2,431392.59,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1266,NULL,446,40719,1661,2,67,2,90592.44,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1267,NULL,446,40719,1661,2,13,1,521985.03,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1268,NULL,447,40719,1661,2,96,2,7750.61,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1269,NULL,447,40719,1661,2,67,2,1627.63,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1270,NULL,447,40719,1661,2,13,1,9378.24,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1271,NULL,448,40719,1661,2,96,2,268000.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1272,NULL,448,40719,1661,2,67,2,56280.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1273,NULL,448,40719,1661,2,13,1,324280.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1274,NULL,449,40719,1661,2,96,2,6720.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1275,NULL,449,40719,1661,2,67,2,1411.20,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1276,NULL,449,40719,1661,2,13,1,8131.20,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1277,NULL,450,40719,1661,2,96,2,9300.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1278,NULL,450,40719,1661,2,67,2,1953.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1279,NULL,450,40719,1661,2,13,1,11253.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1280,NULL,451,40719,1661,2,96,2,46000.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1281,NULL,451,40719,1661,2,67,2,9660.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1282,NULL,451,40719,1661,2,13,1,55660.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1283,NULL,452,40719,1661,2,96,2,4954.95,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1284,NULL,452,40719,1661,2,67,2,1040.54,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1285,NULL,452,40719,1661,2,13,1,5995.49,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1286,NULL,453,40719,1661,2,96,2,48000.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1287,NULL,453,40719,1661,2,67,2,10080.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1288,NULL,453,40719,1661,2,13,1,58080.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1289,NULL,454,40719,1661,2,96,2,72000.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1290,NULL,454,40719,1661,2,67,2,15120.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1291,NULL,454,40719,1661,2,13,1,87120.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1292,NULL,455,40719,1661,2,96,2,4095.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1293,NULL,455,40719,1661,2,67,2,859.95,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1294,NULL,455,40719,1661,2,13,1,4954.95,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1295,NULL,456,40719,1661,2,96,1,4954.95,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1296,NULL,456,40719,1661,2,68,1,1040.54,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1297,NULL,456,40719,1661,2,13,2,5995.49,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1298,NULL,457,40719,1661,2,96,2,57600.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1299,NULL,457,40719,1661,2,67,2,12096.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1300,NULL,457,40719,1661,2,13,1,69696.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1301,NULL,458,40719,1661,2,96,2,1964690.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1302,NULL,458,40719,1661,2,67,2,412584.90,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1303,NULL,458,40719,1661,2,13,1,2377274.90,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1304,NULL,459,40719,1661,2,96,2,46228.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1305,NULL,459,40719,1661,2,67,2,9707.88,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1306,NULL,459,40719,1661,2,13,1,55935.88,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1307,NULL,460,40719,1661,2,96,2,8650.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1308,NULL,460,40719,1661,2,67,2,1816.50,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1309,NULL,460,40719,1661,2,13,1,10466.50,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1310,NULL,461,40719,1661,2,96,2,219500.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1311,NULL,461,40719,1661,2,67,2,46095.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1312,NULL,461,40719,1661,2,13,1,265595.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1313,NULL,462,40719,1661,2,218,2,78529.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1314,NULL,462,40719,1661,2,13,1,78529.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1315,NULL,463,40719,1661,2,218,2,302258.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1316,NULL,463,40719,1661,2,13,1,302258.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1317,NULL,464,40719,1661,2,218,2,18755.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1318,NULL,464,40719,1661,2,13,1,18755.00,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(1319,NULL,465,40719,1661,2,218,2,64800.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1320,NULL,465,40719,1661,2,13,1,64800.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1321,NULL,466,40719,1661,2,96,2,6400.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1322,NULL,466,40719,1661,2,67,2,1344.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1323,NULL,466,40719,1661,2,13,1,7744.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1324,NULL,467,40719,1661,2,96,2,18676.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1325,NULL,467,40719,1661,2,67,2,3921.96,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1326,NULL,467,40719,1661,2,13,1,22597.96,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1327,NULL,468,40719,1661,2,96,2,81000.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1328,NULL,468,40719,1661,2,67,2,17010.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1329,NULL,468,40719,1661,2,13,1,98010.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1330,NULL,469,40719,1661,2,96,2,8750.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1331,NULL,469,40719,1661,2,67,2,1837.50,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1332,NULL,469,40719,1661,2,13,1,10587.50,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1333,NULL,470,40719,1661,2,96,2,19600.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1334,NULL,470,40719,1661,2,67,2,4116.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1335,NULL,470,40719,1661,2,13,1,23716.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1336,NULL,471,40719,1661,2,96,2,19600.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1337,NULL,471,40719,1661,2,67,2,4116.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1338,NULL,471,40719,1661,2,13,1,23716.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1339,NULL,472,40719,1661,2,96,2,58000.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1340,NULL,472,40719,1661,2,67,2,12180.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1341,NULL,472,40719,1661,2,13,1,70180.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1342,NULL,473,40719,1661,2,96,2,55800.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1343,NULL,473,40719,1661,2,67,2,11718.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1344,NULL,473,40719,1661,2,13,1,67518.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1345,NULL,474,40719,1661,2,96,2,31500.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1346,NULL,474,40719,1661,2,67,2,6615.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1347,NULL,474,40719,1661,2,13,1,38115.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1348,NULL,475,40719,1661,2,96,2,20820.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1349,NULL,475,40719,1661,2,67,2,4372.20,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1350,NULL,475,40719,1661,2,13,1,25192.20,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1351,NULL,476,40719,1661,2,96,2,8400.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1352,NULL,476,40719,1661,2,67,2,1764.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1353,NULL,476,40719,1661,2,13,1,10164.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1354,NULL,477,40719,1661,2,96,2,16200.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1355,NULL,477,40719,1661,2,67,2,3402.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1356,NULL,477,40719,1661,2,13,1,19602.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1357,NULL,478,40719,1661,2,96,2,32025.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1358,NULL,478,40719,1661,2,67,2,6725.25,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1359,NULL,478,40719,1661,2,13,1,38750.25,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1360,NULL,479,40719,1661,2,96,2,16200.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1361,NULL,479,40719,1661,2,67,2,3402.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1362,NULL,479,40719,1661,2,13,1,19602.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1363,NULL,480,40719,1661,2,96,2,52500.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1364,NULL,480,40719,1661,2,67,2,11025.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1365,NULL,480,40719,1661,2,13,1,63525.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1366,NULL,481,40719,1661,2,218,2,159132.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1367,NULL,481,40719,1661,2,13,1,159132.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1368,NULL,482,40719,1661,2,218,2,26680.50,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1369,NULL,482,40719,1661,2,13,1,26680.50,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1370,NULL,483,40719,1661,2,218,2,38115.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1371,NULL,483,40719,1661,2,13,1,38115.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1372,NULL,484,40719,1661,2,218,2,18755.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1373,NULL,484,40719,1661,2,13,1,18755.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1374,NULL,485,40719,1661,2,218,2,13320.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1375,NULL,485,40719,1661,2,13,1,13320.00,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(1376,NULL,486,40719,1661,2,96,2,38400.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1377,NULL,486,40719,1661,2,67,2,8064.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1378,NULL,486,40719,1661,2,13,1,46464.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1379,NULL,487,40719,1661,2,96,2,172500.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1380,NULL,487,40719,1661,2,67,2,36225.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1381,NULL,487,40719,1661,2,13,1,208725.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1382,NULL,488,40719,1661,2,96,2,172500.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1383,NULL,488,40719,1661,2,67,2,36225.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1384,NULL,488,40719,1661,2,13,1,208725.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1385,NULL,489,40719,1661,2,96,2,167700.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1386,NULL,489,40719,1661,2,67,2,35217.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1387,NULL,489,40719,1661,2,13,1,202917.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1388,NULL,490,40719,1661,2,96,2,3100.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1389,NULL,490,40719,1661,2,67,2,651.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1390,NULL,490,40719,1661,2,13,1,3751.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1391,NULL,491,40719,1661,2,96,2,104000.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1392,NULL,491,40719,1661,2,67,2,21840.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1393,NULL,491,40719,1661,2,13,1,125840.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1394,NULL,492,40719,1661,2,96,2,775.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1395,NULL,492,40719,1661,2,67,2,162.75,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1396,NULL,492,40719,1661,2,13,1,937.75,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1397,NULL,493,40719,1661,2,96,2,775.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1398,NULL,493,40719,1661,2,67,2,162.75,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1399,NULL,493,40719,1661,2,13,1,937.75,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1400,NULL,494,40719,1661,2,218,2,176418.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1401,NULL,494,40719,1661,2,13,1,176418.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1402,NULL,495,40719,1661,2,218,2,8228.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1403,NULL,495,40719,1661,2,13,1,8228.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1404,NULL,496,40719,1661,2,218,2,55660.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1405,NULL,496,40719,1661,2,13,1,55660.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1406,NULL,497,40719,1661,2,218,2,100963.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1407,NULL,497,40719,1661,2,13,1,100963.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1408,NULL,498,40719,1661,2,218,2,42350.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1409,NULL,498,40719,1661,2,13,1,42350.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1410,NULL,499,40719,1661,2,96,2,4440.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1411,NULL,499,40719,1661,2,67,2,932.40,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1412,NULL,499,40719,1661,2,13,1,5372.40,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1413,NULL,500,40719,1661,2,96,2,36800.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1414,NULL,500,40719,1661,2,67,2,7728.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1415,NULL,500,40719,1661,2,13,1,44528.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1416,NULL,501,40719,1661,2,96,2,662917.50,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1417,NULL,501,40719,1661,2,67,2,139212.68,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1418,NULL,501,40719,1661,2,13,1,802130.18,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1419,NULL,502,40719,1661,2,96,2,142600.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1420,NULL,502,40719,1661,2,67,2,29946.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1421,NULL,502,40719,1661,2,13,1,172546.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1422,NULL,503,40719,1661,2,96,2,64000.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1423,NULL,503,40719,1661,2,67,2,13440.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1424,NULL,503,40719,1661,2,13,1,77440.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1425,NULL,504,40719,1661,2,218,2,9982.50,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1426,NULL,504,40719,1661,2,13,1,9982.50,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1427,NULL,505,40719,1661,2,96,2,42000.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1428,NULL,505,40719,1661,2,67,2,8820.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1429,NULL,505,40719,1661,2,13,1,50820.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1430,NULL,506,40719,1661,2,96,2,16200.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1431,NULL,506,40719,1661,2,67,2,3402.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1432,NULL,506,40719,1661,2,13,1,19602.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1433,NULL,507,40719,1661,2,96,2,244960.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1434,NULL,507,40719,1661,2,67,2,51441.60,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1435,NULL,507,40719,1661,2,13,1,296401.60,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1436,NULL,508,40719,1661,2,96,1,244960.00,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1437,NULL,508,40719,1661,2,68,1,51441.60,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1438,NULL,508,40719,1661,2,13,2,296401.60,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(1439,NULL,509,40719,1661,2,96,2,132000.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1440,NULL,509,40719,1661,2,67,2,27720.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1441,NULL,509,40719,1661,2,13,1,159720.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1442,NULL,510,40719,1661,2,96,2,40000.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1443,NULL,510,40719,1661,2,67,2,8400.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1444,NULL,510,40719,1661,2,13,1,48400.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1445,NULL,511,40719,1661,2,96,2,135699.20,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1446,NULL,511,40719,1661,2,67,2,28496.83,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1447,NULL,511,40719,1661,2,13,1,164196.03,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1448,NULL,512,40719,1661,2,96,2,135000.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1449,NULL,512,40719,1661,2,67,2,28350.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1450,NULL,512,40719,1661,2,13,1,163350.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1451,NULL,513,40719,1661,2,96,2,210000.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1452,NULL,513,40719,1661,2,67,2,44100.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1453,NULL,513,40719,1661,2,13,1,254100.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1454,NULL,514,40719,1661,2,96,2,13725.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1455,NULL,514,40719,1661,2,67,2,2882.25,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1456,NULL,514,40719,1661,2,13,1,16607.25,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1457,NULL,515,40719,1661,2,96,2,21750.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1458,NULL,515,40719,1661,2,67,2,4567.50,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1459,NULL,515,40719,1661,2,13,1,26317.50,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1460,NULL,516,40719,1661,2,96,2,236400.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1461,NULL,516,40719,1661,2,67,2,49644.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1462,NULL,516,40719,1661,2,13,1,286044.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1463,NULL,517,40719,1661,2,96,2,4350.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1464,NULL,517,40719,1661,2,67,2,913.50,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1465,NULL,517,40719,1661,2,13,1,5263.50,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1466,NULL,518,40719,1661,2,96,2,281624.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1467,NULL,518,40719,1661,2,67,2,59141.04,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1468,NULL,518,40719,1661,2,13,1,340765.04,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1469,NULL,519,40719,1661,2,96,2,141799.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1470,NULL,519,40719,1661,2,67,2,29777.79,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1471,NULL,519,40719,1661,2,13,1,171576.79,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1472,NULL,520,40719,1661,2,96,2,117600.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL);
INSERT INTO `balance_libro_details` VALUES (1473,NULL,520,40719,1661,2,67,2,24696.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1474,NULL,520,40719,1661,2,13,1,142296.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1475,NULL,521,40719,1661,2,96,2,40500.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1476,NULL,521,40719,1661,2,67,2,8505.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1477,NULL,521,40719,1661,2,13,1,49005.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1478,NULL,522,40719,1661,2,218,2,17800.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1479,NULL,522,40719,1661,2,13,1,17800.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1480,NULL,523,40719,1661,2,96,2,24393.60,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1481,NULL,523,40719,1661,2,67,2,5122.66,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1482,NULL,523,40719,1661,2,13,1,29516.26,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1483,NULL,524,40719,1661,2,96,2,24393.60,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1484,NULL,524,40719,1661,2,67,2,5122.66,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1485,NULL,524,40719,1661,2,13,1,29516.26,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1486,NULL,525,40719,1661,2,96,2,32000.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1487,NULL,525,40719,1661,2,67,2,6720.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1488,NULL,525,40719,1661,2,13,1,38720.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1489,NULL,526,40719,1661,2,96,2,510000.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1490,NULL,526,40719,1661,2,67,2,107100.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1491,NULL,526,40719,1661,2,13,1,617100.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1492,NULL,527,40719,1661,2,96,2,244960.00,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1493,NULL,527,40719,1661,2,67,2,51441.60,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1494,NULL,527,40719,1661,2,13,1,296401.60,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(1495,NULL,528,40719,1661,2,96,2,42000.00,NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(1496,NULL,528,40719,1661,2,67,2,8820.00,NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(1497,NULL,528,40719,1661,2,13,1,50820.00,NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(1498,NULL,529,40719,1661,2,96,2,12400.00,NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(1499,NULL,529,40719,1661,2,67,2,2604.00,NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(1500,NULL,529,40719,1661,2,13,1,15004.00,NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(1501,7777,530,40719,1661,8,276,1,49604.87,NULL,'2022-09-27 13:33:54','2022-09-27 13:33:54',NULL),(1502,7777,530,40719,1661,8,351,2,49604.87,NULL,'2022-09-27 13:33:54','2022-09-27 13:33:54',NULL),(1503,7777,531,40719,1661,8,277,1,255167.29,NULL,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(1504,7777,531,40719,1661,8,351,2,255167.29,NULL,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(1505,7777,532,40719,1661,8,281,1,10637.14,NULL,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(1506,7777,532,40719,1661,8,351,2,10637.14,NULL,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(1507,7777,533,40719,1661,8,292,1,6058.51,NULL,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(1508,7777,533,40719,1661,8,351,2,6058.51,NULL,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(1509,7777,534,40719,1661,8,300,1,8654.62,NULL,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(1510,7777,534,40719,1661,8,351,2,8654.62,NULL,'2022-09-27 13:33:55','2022-09-27 13:33:55',NULL),(1511,7777,535,40719,12,2,96,2,6611.57,NULL,'2022-10-07 10:59:16','2022-10-07 11:00:41','2022-10-07 11:00:41'),(1512,7777,535,40719,12,2,67,2,1388.43,NULL,'2022-10-07 10:59:16','2022-10-07 11:00:41','2022-10-07 11:00:41');
INSERT INTO `balance_libro_details` VALUES (1513,7777,535,40719,12,2,13,1,8000.00,NULL,'2022-10-07 10:59:16','2022-10-07 11:00:41','2022-10-07 11:00:41'),(1514,7777,536,40719,12,2,96,2,8264.46,NULL,'2022-10-07 11:00:08','2022-10-07 11:02:42','2022-10-07 11:02:42'),(1515,7777,536,40719,12,2,67,2,1735.54,NULL,'2022-10-07 11:00:08','2022-10-07 11:02:42','2022-10-07 11:02:42'),(1516,7777,536,40719,12,2,13,1,10000.00,NULL,'2022-10-07 11:00:08','2022-10-07 11:02:42','2022-10-07 11:02:42'),(1517,7777,537,40719,12,2,96,2,8264.46,NULL,'2022-10-07 11:02:42','2022-10-07 11:04:29','2022-10-07 11:04:29'),(1518,7777,537,40719,12,2,67,2,1735.54,NULL,'2022-10-07 11:02:42','2022-10-07 11:04:29','2022-10-07 11:04:29'),(1519,7777,537,40719,12,2,13,1,10000.00,NULL,'2022-10-07 11:02:42','2022-10-07 11:04:29','2022-10-07 11:04:29'),(1520,7777,538,40719,12,2,96,2,8264.46,NULL,'2022-10-07 11:04:29','2022-10-07 11:06:12','2022-10-07 11:06:12'),(1521,7777,538,40719,12,2,67,2,1735.54,NULL,'2022-10-07 11:04:29','2022-10-07 11:06:12','2022-10-07 11:06:12'),(1522,7777,538,40719,12,2,13,1,10000.00,NULL,'2022-10-07 11:04:29','2022-10-07 11:06:12','2022-10-07 11:06:12'),(1523,7777,539,40719,12,2,96,2,8264.46,NULL,'2022-10-07 11:23:34','2022-10-07 11:23:34',NULL),(1524,7777,539,40719,12,2,67,2,1735.54,NULL,'2022-10-07 11:23:34','2022-10-07 11:23:34',NULL),(1525,7777,539,40719,12,2,13,1,10000.00,NULL,'2022-10-07 11:23:34','2022-10-07 11:23:34',NULL),(1526,7777,540,40719,12,3,217,1,20000.00,NULL,'2022-10-07 15:01:30','2022-10-07 15:03:29','2022-10-07 15:03:29'),(1527,7777,540,40719,12,3,68,1,4200.00,NULL,'2022-10-07 15:01:30','2022-10-07 15:03:29','2022-10-07 15:03:29'),(1528,7777,540,40719,12,3,57,2,24200.00,NULL,'2022-10-07 15:01:30','2022-10-07 15:03:29','2022-10-07 15:03:29'),(1529,7777,541,40719,12,3,217,1,20000.00,NULL,'2022-10-07 15:03:29','2022-10-07 15:44:10','2022-10-07 15:44:10'),(1530,7777,541,40719,12,3,68,1,4200.00,NULL,'2022-10-07 15:03:29','2022-10-07 15:44:10','2022-10-07 15:44:10'),(1531,7777,541,40719,12,3,57,2,24200.00,NULL,'2022-10-07 15:03:29','2022-10-07 15:44:10','2022-10-07 15:44:10'),(1532,7777,542,40719,12,20,13,2,10000.00,NULL,'2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(1533,7777,542,40719,12,20,359,1,10000.00,NULL,'2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(1534,7777,543,40719,1661,20,13,2,363000.00,NULL,'2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(1535,7777,543,40719,1661,20,359,1,363000.00,NULL,'2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(1536,7777,544,40719,1661,20,13,2,180048.00,NULL,'2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(1537,7777,544,40719,1661,20,359,1,180048.00,NULL,'2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(1538,7777,545,40719,1661,20,13,2,254100.00,NULL,'2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(1539,7777,545,40719,1661,20,359,1,254100.00,NULL,'2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(1540,7777,546,40719,1661,20,13,2,163350.00,NULL,'2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(1541,7777,546,40719,1661,20,359,1,163350.00,NULL,'2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(1542,7777,547,40719,1661,21,57,1,24200.00,NULL,'2022-10-07 15:33:06','2022-10-07 15:44:10','2022-10-07 15:44:10'),(1543,7777,547,40719,1661,21,359,2,24200.00,NULL,'2022-10-07 15:33:06','2022-10-07 15:44:10','2022-10-07 15:44:10'),(1546,7777,549,40719,12,3,392,1,20000.00,NULL,'2022-10-07 15:48:50','2022-10-07 15:48:50',NULL),(1547,7777,549,40719,12,3,68,1,4200.00,NULL,'2022-10-07 15:48:50','2022-10-07 15:48:50',NULL),(1548,7777,549,40719,12,3,57,2,24200.00,NULL,'2022-10-07 15:48:50','2022-10-07 15:48:50',NULL),(1549,7777,550,40719,12,21,57,1,24200.00,NULL,'2022-10-07 15:50:03','2022-10-07 15:50:03',NULL),(1550,7777,550,40719,12,21,359,2,24200.00,NULL,'2022-10-07 15:50:03','2022-10-07 15:50:03',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-09-05 16:45:13',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-09-05 16:45:13',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-09-05 16:45:13',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-05 16:45:13','2022-09-05 16:45:13',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-05 16:45:20','2022-09-05 16:45:21',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-05 16:45:20','2022-09-05 16:45:21',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-05 16:45:20','2022-09-05 16:45:21',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-05 16:45:20','2022-09-05 16:45:21',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-05 16:45:32','2022-09-05 16:45:32',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-05 16:45:32','2022-09-05 16:45:32',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-05 16:45:32','2022-09-05 16:45:32',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-05 16:45:32','2022-09-05 16:45:32',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:04:26','2023-05-30 15:04:26',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:35:09',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:35:09',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:35:09',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:35:09',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:35:09',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:35:09',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:09',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:09',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',1414762.00,117896.00,'No Excluida','0',30,3330,230178.48,496.85,496.85,2192.15,3061.75,5750.75,5750.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',2103025.00,175252.00,'No Excluida','0',45,5000,230178.48,957.27,957.27,2411.36,3061.75,6430.38,6430.38,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',2944235.00,245352.00,'No Excluida','0',60,6700,460356.93,1636.83,1512.56,2652.52,3061.75,7351.10,7226.83,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',3656604.00,304717.00,'No Excluida','0',85,10000,460356.93,2689.05,2484.46,2917.75,3638.26,9245.06,9040.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',4305799.00,358816.00,'No Excluida','0',110,13000,573619.32,5115.04,3967.80,3209.55,4452.02,12776.61,11629.37,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',5382248.00,448520.00,'No Excluida','0',150,16500,575446.12,7036.89,5180.81,3530.49,5145.02,15712.40,13856.32,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',6458698.00,538224.00,'No Excluida','0',200,20000,690535.39,8951.39,6459.54,3883.53,5512.52,18347.44,15855.59,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',7996484.00,666373.00,'No Excluida','0',200,20000,920713.84,20460.26,15856.76,4271.88,6615.02,31347.16,26743.66,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',8949911.00,745825.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,25575.36,4699.08,8190.03,NULL,38464.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',10257028.00,854752.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,30054.72,5169.03,9166.53,NULL,44390.28,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',11379612.00,948301.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,34526.76,5685.87,10505.29,NULL,50717.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (14,7777,'leoncito','20288693049',NULL,1,40719,1,'2022-10-29 14:22:28','2022-10-29 14:22:28',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(2,NULL,'Articulo 6',6,0,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(3,NULL,'Articulo 7',7,0,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(4,NULL,'Articulo 8',8,0,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(5,NULL,'Articulo 9',9,0,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(6,NULL,'Articulo 10',10,0,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(7,NULL,'Articulo 11',11,0,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(8,NULL,'Articulo 12',12,0,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(9,NULL,'Articulo 13',13,0,'2022-09-05 16:45:21','2022-09-05 16:45:21',NULL),(10,NULL,'Articulo 14',14,1,'2022-09-05 16:45:21','2022-09-05 16:45:22',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:43:35','2023-03-12 23:43:35',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (3,NULL,1,NULL,'[{\"id\":40719,\"user_id\":7777,\"field_name1\":\"Empresa prueba SRL\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-28869304-9\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-09-06T01:44:59.000000Z\",\"updated_at\":\"2022-09-07T16:34:48.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":2,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":2,\"user_id\":7777,\"person_id\":40719,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-09-05T19:45:34.000000Z\",\"updated_at\":\"2022-09-27T14:16:18.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2021-1\",\"obligation_salaries\":1,\"empleada_domestica\":0,\"prorratear_iva\":1,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40719,\"person_id_titular\":40719,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2021-01-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":14,\"user_id\":7777,\"person_id\":40719,\"liquidator_id\":6,\"created_at\":\"2022-09-27T14:16:18.000000Z\",\"updated_at\":\"2022-09-27T14:16:18.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":6,\"user_id\":null,\"name\":\"Betty\",\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}},\"periods\":[{\"id\":11,\"user_id\":null,\"code\":\"2022-09\",\"year\":2022,\"period_number\":9,\"date_from\":\"2022-09-01\",\"date_to\":\"2022-09-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40719,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2022-10-07 11:59:59','2022-10-07 12:00:01',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=536 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7777,2,40719,40720,13,11,1,0,'2022-09-08',121.00,1,1.00,'Factura A N°: 0001-00000001',NULL,'2022-09-08 10:30:29','2022-09-08 10:40:46','2022-09-08 10:40:46'),(2,7777,3,40719,40721,57,11,2,0,'2022-09-08',1310.90,1,1.00,'Factura A N°: 0008-06556554',NULL,'2022-09-08 10:40:18','2022-09-26 19:10:04','2022-09-26 19:10:04'),(3,7777,2,40719,40720,13,11,1,0,'2022-09-08',2420.00,1,1.00,'Factura A N°: 0001-00000001',NULL,'2022-09-08 10:40:46','2022-09-26 19:09:50','2022-09-26 19:09:50'),(4,7777,21,40719,40721,57,11,1,0,'2022-09-08',1310.09,1,1.00,NULL,NULL,'2022-09-08 11:42:06','2022-09-08 11:46:20','2022-09-08 11:46:20'),(5,7777,21,40719,40721,57,11,1,0,'2022-09-08',1310.90,1,1.00,NULL,NULL,'2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(6,7777,2,40719,40825,13,1661,1,0,'2021-12-01',3025.00,1,1.00,'Factura A N°: 0004-00007449',NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(7,7777,2,40719,40825,13,1661,1,0,'2021-12-01',11797.50,1,1.00,'Factura A N°: 0004-00007584',NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(8,7777,2,40719,40826,13,1661,2,0,'2021-12-01',193600.00,1,1.00,'NOTA DE CREDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000023',NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(9,7777,2,40719,40827,13,1661,1,0,'2021-12-01',73872.48,1,1.00,'Factura B N°: 0004-00001209',NULL,'2022-09-27 10:52:56','2022-09-27 13:28:10','2022-09-27 13:28:10'),(10,7777,2,40719,40827,13,1661,1,0,'2021-12-01',4094.00,1,1.00,'Factura B N°: 0004-00001214',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(11,7777,2,40719,40827,13,1661,1,0,'2021-12-01',2420.00,1,1.00,'Factura B N°: 0004-00001224',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(12,7777,2,40719,40827,13,1661,1,0,'2021-12-01',2521.50,1,1.00,'Factura B N°: 0004-00001231',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(13,7777,2,40719,40827,13,1661,1,0,'2021-12-01',2420.00,1,1.00,'Factura B N°: 0004-00001232',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(14,7777,2,40719,40828,13,1661,1,0,'2021-12-01',15730.00,1,1.00,'Factura A N°: 0004-00007445',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(15,7777,2,40719,40829,13,1661,1,0,'2021-12-01',55660.00,1,1.00,'Factura A N°: 0004-00007517',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(16,7777,2,40719,40829,13,1661,1,0,'2021-12-01',55660.00,1,1.00,'Factura A N°: 0004-00007564',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(17,7777,2,40719,40830,13,1661,1,0,'2021-12-01',2964.50,1,1.00,'Factura A N°: 0004-00007443',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(18,7777,2,40719,40830,13,1661,1,0,'2021-12-01',5747.50,1,1.00,'Factura A N°: 0004-00007444',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(19,7777,2,40719,40830,13,1661,1,0,'2021-12-01',8288.50,1,1.00,'Factura A N°: 0004-00007461',NULL,'2022-09-27 10:52:57','2022-09-27 13:28:10','2022-09-27 13:28:10'),(20,7777,2,40719,40831,13,1661,1,0,'2021-12-01',1914704.00,1,1.00,'Factura A N°: 0004-00007471',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(21,7777,2,40719,40831,13,1661,1,0,'2021-12-01',315810.00,1,1.00,'Factura A N°: 0004-00007513',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(22,7777,2,40719,40832,13,1661,1,0,'2021-12-01',79376.00,1,1.00,'Factura A N°: 0004-00007438',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(23,7777,2,40719,40832,13,1661,1,0,'2021-12-01',79376.00,1,1.00,'Factura A N°: 0004-00007502',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(24,7777,2,40719,40832,13,1661,1,0,'2021-12-01',83732.00,1,1.00,'Factura A N°: 0004-00007563',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10');
INSERT INTO `cta_cte_cliente` VALUES (25,7777,2,40719,40832,13,1661,1,0,'2021-12-01',81917.00,1,1.00,'Factura A N°: 0004-00007605',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(26,7777,2,40719,40833,13,1661,1,0,'2021-12-01',77440.00,1,1.00,'Factura A N°: 0004-00007616',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(27,7777,2,40719,40834,13,1661,1,0,'2021-12-01',3751.00,1,1.00,'Factura B N°: 0004-00001206',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(28,7777,2,40719,40834,13,1661,1,0,'2021-12-01',157865.00,1,1.00,'Factura B N°: 0004-00001216',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(29,7777,2,40719,40834,13,1661,1,0,'2021-12-01',30250.00,1,1.00,'Factura B N°: 0004-00001226',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(30,7777,2,40719,40834,13,1661,1,0,'2021-12-01',285560.00,1,1.00,'Factura B N°: 0004-00001227',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(31,7777,2,40719,40834,13,1661,1,0,'2021-12-01',36300.00,1,1.00,'Factura B N°: 0004-00001230',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(32,7777,2,40719,40835,13,1661,1,0,'2021-12-01',62097.20,1,1.00,'Factura A N°: 0004-00007543',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(33,7777,2,40719,40836,13,1661,1,0,'2021-12-01',26620.00,1,1.00,'Factura A N°: 0004-00007568',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(34,7777,2,40719,40837,13,1661,1,0,'2021-12-01',49740.08,1,1.00,'Factura A N°: 0004-00007492',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(35,7777,2,40719,40837,13,1661,1,0,'2021-12-01',123178.00,1,1.00,'Factura A N°: 0004-00007539',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(36,7777,2,40719,40837,13,1661,1,0,'2021-12-01',19360.00,1,1.00,'Factura A N°: 0004-00007580',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(37,7777,2,40719,40837,13,1661,1,0,'2021-12-01',84276.50,1,1.00,'Factura A N°: 0004-00007624',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(38,7777,2,40719,40838,13,1661,1,0,'2021-12-01',6243.60,1,1.00,'Factura A N°: 0004-00007545',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(39,7777,2,40719,40839,13,1661,1,0,'2021-12-01',23353.00,1,1.00,'Factura A N°: 0004-00007610',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:10','2022-09-27 13:28:10'),(40,7777,2,40719,40840,13,1661,1,0,'2021-12-01',25711.29,1,1.00,'Factura A N°: 0004-00007465',NULL,'2022-09-27 10:52:58','2022-09-27 13:28:11','2022-09-27 13:28:11'),(41,7777,2,40719,40841,13,1661,1,0,'2021-12-01',76862.27,1,1.00,'Factura A N°: 0004-00007475',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(42,7777,2,40719,40841,13,1661,1,0,'2021-12-01',111467.62,1,1.00,'Factura A N°: 0004-00007507',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(43,7777,2,40719,40841,13,1661,1,0,'2021-12-01',655.05,1,1.00,'Factura A N°: 0004-00007514',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(44,7777,2,40719,40841,13,1661,1,0,'2021-12-01',3899.71,1,1.00,'Factura A N°: 0004-00007515',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(45,7777,2,40719,40841,13,1661,1,0,'2021-12-01',83228.88,1,1.00,'Factura A N°: 0004-00007562',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(46,7777,2,40719,40841,13,1661,1,0,'2021-12-01',93207.27,1,1.00,'Factura A N°: 0004-00007595',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(47,7777,2,40719,40842,13,1661,1,0,'2021-12-01',546315.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000302',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `cta_cte_cliente` VALUES (48,7777,2,40719,40843,13,1661,1,0,'2021-12-01',62338.60,1,1.00,'Factura A N°: 0004-00007537',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(49,7777,2,40719,40843,13,1661,1,0,'2021-12-01',26059.77,1,1.00,'Factura A N°: 0004-00007590',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(50,7777,2,40719,40843,13,1661,1,0,'2021-12-01',4456.91,1,1.00,'Factura A N°: 0004-00007596',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(51,7777,2,40719,40844,13,1661,1,0,'2021-12-01',5082.00,1,1.00,'Factura A N°: 0004-00007588',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(52,7777,2,40719,40845,13,1661,1,0,'2021-12-01',180048.00,1,1.00,'Factura A N°: 0004-00007498',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(53,7777,2,40719,40846,13,1661,1,0,'2021-12-01',45012.00,1,1.00,'Factura A N°: 0004-00007608',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(54,7777,2,40719,40847,13,1661,1,0,'2021-12-01',290400.00,1,1.00,'Factura A N°: 0004-00007506',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(55,7777,2,40719,40847,13,1661,1,0,'2021-12-01',188760.00,1,1.00,'Factura A N°: 0004-00007510',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(56,7777,2,40719,40847,13,1661,1,0,'2021-12-01',425920.00,1,1.00,'Factura A N°: 0004-00007604',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(57,7777,2,40719,40848,13,1661,1,0,'2021-12-01',25410.00,1,1.00,'Factura A N°: 0004-00007554',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(58,7777,2,40719,40849,13,1661,1,0,'2021-12-01',133100.00,1,1.00,'Factura A N°: 0004-00007486',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(59,7777,2,40719,40850,13,1661,1,0,'2021-12-01',708329.14,1,1.00,'Factura B N°: 0004-00001200',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(60,7777,2,40719,40850,13,1661,1,0,'2021-12-01',77319.00,1,1.00,'Factura B N°: 0004-00001203',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(61,7777,2,40719,40850,13,1661,1,0,'2021-12-01',5666.00,1,1.00,'Factura B N°: 0004-00001208',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(62,7777,2,40719,40850,13,1661,1,0,'2021-12-01',2200.00,1,1.00,'Factura B N°: 0004-00001218',NULL,'2022-09-27 10:52:59','2022-09-27 13:28:11','2022-09-27 13:28:11'),(63,7777,2,40719,40850,13,1661,2,0,'2021-12-01',230.00,1,1.00,'Nota de crédito B N°: 0004-00000077',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(64,7777,2,40719,40850,13,1661,2,0,'2021-12-01',37200.00,1,1.00,'Nota de crédito B N°: 0004-00000078',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(65,7777,2,40719,40850,13,1661,1,0,'2021-12-01',75867.00,1,1.00,'Factura B N°: 0004-00001223',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(66,7777,2,40719,40851,13,1661,1,0,'2021-12-01',49005.00,1,1.00,'Factura A N°: 0004-00007551',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(67,7777,2,40719,40852,13,1661,1,0,'2021-12-01',106480.00,1,1.00,'Factura B N°: 0004-00001219',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(68,7777,2,40719,40853,13,1661,1,0,'2021-12-01',52514.00,1,1.00,'Factura A N°: 0004-00007452',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(69,7777,2,40719,40853,13,1661,1,0,'2021-12-01',42579.90,1,1.00,'Factura A N°: 0004-00007480',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(70,7777,2,40719,40853,13,1661,1,0,'2021-12-01',263632.38,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000297',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11');
INSERT INTO `cta_cte_cliente` VALUES (71,7777,2,40719,40853,13,1661,1,0,'2021-12-01',52514.00,1,1.00,'Factura A N°: 0004-00007586',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(72,7777,2,40719,40853,13,1661,1,0,'2021-12-01',337206.43,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000306',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(73,7777,2,40719,40854,13,1661,1,0,'2021-12-01',344850.00,1,1.00,'Factura A N°: 0004-00007524',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(74,7777,2,40719,40854,13,1661,1,0,'2021-12-01',114950.00,1,1.00,'Factura A N°: 0004-00007536',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(75,7777,2,40719,40855,13,1661,1,0,'2021-12-01',136125.00,1,1.00,'Factura A N°: 0004-00007463',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(76,7777,2,40719,40855,13,1661,1,0,'2021-12-01',120516.00,1,1.00,'Factura A N°: 0004-00007575',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(77,7777,2,40719,40855,13,1661,1,0,'2021-12-01',31218.00,1,1.00,'Factura A N°: 0004-00007609',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(78,7777,2,40719,40856,13,1661,1,0,'2021-12-01',52635.00,1,1.00,'Factura A N°: 0004-00007583',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(79,7777,2,40719,40856,13,1661,1,0,'2021-12-01',52635.00,1,1.00,'Factura A N°: 0004-00007621',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(80,7777,2,40719,40857,13,1661,1,0,'2021-12-01',19360.00,1,1.00,'Factura A N°: 0004-00007436',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(81,7777,2,40719,40857,13,1661,1,0,'2021-12-01',236857.50,1,1.00,'Factura A N°: 0004-00007599',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(82,7777,2,40719,40858,13,1661,1,0,'2021-12-01',115434.00,1,1.00,'Factura A N°: 0004-00007483',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(83,7777,2,40719,40858,13,1661,1,0,'2021-12-01',87120.00,1,1.00,'Factura A N°: 0004-00007544',NULL,'2022-09-27 10:53:00','2022-09-27 13:28:11','2022-09-27 13:28:11'),(84,7777,2,40719,40859,13,1661,1,0,'2021-12-01',111804.00,1,1.00,'Factura A N°: 0004-00007432',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(85,7777,2,40719,40859,13,1661,1,0,'2021-12-01',111804.00,1,1.00,'Factura A N°: 0004-00007462',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(86,7777,2,40719,40859,13,1661,1,0,'2021-12-01',172425.00,1,1.00,'Factura A N°: 0004-00007489',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(87,7777,2,40719,40859,13,1661,1,0,'2021-12-01',111804.00,1,1.00,'Factura A N°: 0004-00007540',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(88,7777,2,40719,40859,13,1661,1,0,'2021-12-01',111804.00,1,1.00,'Factura A N°: 0004-00007582',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(89,7777,2,40719,40859,13,1661,1,0,'2021-12-01',154880.00,1,1.00,'Factura A N°: 0004-00007619',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(90,7777,2,40719,40859,13,1661,1,0,'2021-12-01',50820.00,1,1.00,'Factura A N°: 0004-00007620',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(91,7777,2,40719,40860,13,1661,1,0,'2021-12-01',74899.00,1,1.00,'Factura A N°: 0004-00007534',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(92,7777,2,40719,40860,13,1661,1,0,'2021-12-01',23232.00,1,1.00,'Factura A N°: 0004-00007573',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:11','2022-09-27 13:28:11'),(93,7777,2,40719,40861,13,1661,1,0,'2021-12-01',93899.03,1,1.00,'Factura A N°: 0004-00007434',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `cta_cte_cliente` VALUES (94,7777,2,40719,40861,13,1661,1,0,'2021-12-01',26777.30,1,1.00,'Factura A N°: 0004-00007473',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(95,7777,2,40719,40861,13,1661,1,0,'2021-12-01',27104.00,1,1.00,'Factura A N°: 0004-00007505',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(96,7777,2,40719,40861,13,1661,1,0,'2021-12-01',92516.60,1,1.00,'Factura A N°: 0004-00007579',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(97,7777,2,40719,40862,13,1661,1,0,'2021-12-01',20424.80,1,1.00,'Factura A N°: 0004-00007429',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(98,7777,2,40719,40862,13,1661,1,0,'2021-12-01',13068.00,1,1.00,'Factura A N°: 0004-00007553',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(99,7777,2,40719,40862,13,1661,2,0,'2021-12-01',13068.00,1,1.00,'Nota de crédito A N°: 0004-00000293',NULL,'2022-09-27 10:53:01','2022-09-27 13:28:12','2022-09-27 13:28:12'),(100,7777,2,40719,40862,13,1661,1,0,'2021-12-01',17351.40,1,1.00,'Factura A N°: 0004-00007615',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(101,7777,2,40719,40863,13,1661,1,0,'2021-12-01',94864.00,1,1.00,'Factura A N°: 0004-00007560',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(102,7777,2,40719,40864,13,1661,1,0,'2021-12-01',36300.00,1,1.00,'Factura A N°: 0004-00007491',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(103,7777,2,40719,40864,13,1661,1,0,'2021-12-01',19965.00,1,1.00,'Factura A N°: 0004-00007565',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(104,7777,2,40719,40865,13,1661,1,0,'2021-12-01',36300.00,1,1.00,'Factura A N°: 0004-00007435',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(105,7777,2,40719,40866,13,1661,1,0,'2021-12-01',1169918.75,1,1.00,'Factura A N°: 0004-00007447',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(106,7777,2,40719,40866,13,1661,1,0,'2021-12-01',21780.00,1,1.00,'Factura A N°: 0004-00007470',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(107,7777,2,40719,40866,13,1661,1,0,'2021-12-01',75020.00,1,1.00,'Factura A N°: 0004-00007589',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(108,7777,2,40719,40867,13,1661,1,0,'2021-12-01',130680.00,1,1.00,'Factura A N°: 0004-00007474',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(109,7777,2,40719,40867,13,1661,1,0,'2021-12-01',60802.50,1,1.00,'Factura A N°: 0004-00007481',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(110,7777,2,40719,40867,13,1661,1,0,'2021-12-01',18150.00,1,1.00,'Factura A N°: 0004-00007509',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(111,7777,2,40719,40867,13,1661,1,0,'2021-12-01',37510.00,1,1.00,'Factura A N°: 0004-00007618',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(112,7777,2,40719,40868,13,1661,1,0,'2021-12-01',79376.00,1,1.00,'Factura A N°: 0004-00007456',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(113,7777,2,40719,40868,13,1661,1,0,'2021-12-01',85184.00,1,1.00,'Factura A N°: 0004-00007550',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(114,7777,2,40719,40868,13,1661,1,0,'2021-12-01',42592.00,1,1.00,'Factura A N°: 0004-00007607',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(115,7777,2,40719,40869,13,1661,1,0,'2021-12-01',99480.15,1,1.00,'Factura A N°: 0004-00007493',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(116,7777,2,40719,40870,13,1661,1,0,'2021-12-01',170610.00,1,1.00,'Factura A N°: 0004-00007428',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `cta_cte_cliente` VALUES (117,7777,2,40719,40870,13,1661,1,0,'2021-12-01',83187.50,1,1.00,'Factura A N°: 0004-00007446',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(118,7777,2,40719,40870,13,1661,1,0,'2021-12-01',45375.00,1,1.00,'Factura A N°: 0004-00007535',NULL,'2022-09-27 10:53:02','2022-09-27 13:28:12','2022-09-27 13:28:12'),(119,7777,2,40719,40870,13,1661,1,0,'2021-12-01',23837.00,1,1.00,'Factura A N°: 0004-00007581',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(120,7777,2,40719,40871,13,1661,1,0,'2021-12-01',33275.00,1,1.00,'Factura A N°: 0004-00007482',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(121,7777,2,40719,40872,13,1661,2,0,'2021-12-01',125840.00,1,1.00,'Nota de crédito A N°: 0004-00000290',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(122,7777,2,40719,40873,13,1661,1,0,'2021-12-01',10890.00,1,1.00,'Factura A N°: 0004-00007484',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(123,7777,2,40719,40873,13,1661,1,0,'2021-12-01',21175.00,1,1.00,'Factura A N°: 0004-00007487',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(124,7777,2,40719,40873,13,1661,2,0,'2021-12-01',52030.00,1,1.00,'Nota de crédito A N°: 0004-00000291',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(125,7777,2,40719,40873,13,1661,1,0,'2021-12-01',59622.75,1,1.00,'Factura A N°: 0004-00007530',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(126,7777,2,40719,40873,13,1661,1,0,'2021-12-01',26620.00,1,1.00,'Factura A N°: 0004-00007531',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(127,7777,2,40719,40873,13,1661,1,0,'2021-12-01',228690.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000303',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(128,7777,2,40719,40873,13,1661,1,0,'2021-12-01',49489.00,1,1.00,'Factura A N°: 0004-00007606',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(129,7777,2,40719,40874,13,1661,1,0,'2021-12-01',231310.86,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000296',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(130,7777,2,40719,40874,13,1661,1,0,'2021-12-01',231310.86,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000300',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(131,7777,2,40719,40874,13,1661,1,0,'2021-12-01',108280.48,1,1.00,'Factura A N°: 0004-00007572',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(132,7777,2,40719,40874,13,1661,1,0,'2021-12-01',195339.98,1,1.00,'Factura A N°: 0004-00007603',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(133,7777,2,40719,40875,13,1661,1,0,'2021-12-01',108658.00,1,1.00,'Factura A N°: 0004-00007464',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(134,7777,2,40719,40875,13,1661,1,0,'2021-12-01',66792.00,1,1.00,'Factura A N°: 0004-00007485',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(135,7777,2,40719,40875,13,1661,1,0,'2021-12-01',104181.00,1,1.00,'Factura A N°: 0004-00007533',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(136,7777,2,40719,40875,13,1661,1,0,'2021-12-01',142538.00,1,1.00,'Factura A N°: 0004-00007614',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(137,7777,2,40719,40876,13,1661,1,0,'2021-12-01',21538.00,1,1.00,'Factura A N°: 0004-00007437',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(138,7777,2,40719,40876,13,1661,1,0,'2021-12-01',18755.00,1,1.00,'Factura A N°: 0004-00007548',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12'),(139,7777,2,40719,40876,13,1661,1,0,'2021-12-01',43076.00,1,1.00,'Factura A N°: 0004-00007549',NULL,'2022-09-27 10:53:03','2022-09-27 13:28:12','2022-09-27 13:28:12');
INSERT INTO `cta_cte_cliente` VALUES (140,7777,2,40719,40877,13,1661,1,0,'2021-12-01',33880.00,1,1.00,'Factura A N°: 0004-00007466',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(141,7777,2,40719,40877,13,1661,1,0,'2021-12-01',53542.50,1,1.00,'Factura A N°: 0004-00007488',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(142,7777,2,40719,40877,13,1661,1,0,'2021-12-01',7562.50,1,1.00,'Factura A N°: 0004-00007499',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(143,7777,2,40719,40878,13,1661,1,0,'2021-12-01',68244.00,1,1.00,'Factura A N°: 0004-00007585',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(144,7777,2,40719,40879,13,1661,1,0,'2021-12-01',21780.00,1,1.00,'Factura A N°: 0004-00007467',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(145,7777,2,40719,40879,13,1661,1,0,'2021-12-01',21780.00,1,1.00,'Factura A N°: 0004-00007602',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(146,7777,2,40719,40880,13,1661,1,0,'2021-12-01',52635.00,1,1.00,'Factura A N°: 0004-00007431',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(147,7777,2,40719,40880,13,1661,1,0,'2021-12-01',33759.00,1,1.00,'Factura A N°: 0004-00007442',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(148,7777,2,40719,40880,13,1661,1,0,'2021-12-01',122815.00,1,1.00,'Factura A N°: 0004-00007450',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(149,7777,2,40719,40880,13,1661,1,0,'2021-12-01',65340.00,1,1.00,'Factura A N°: 0004-00007451',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(150,7777,2,40719,40880,13,1661,1,0,'2021-12-01',427372.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000295',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(151,7777,2,40719,40880,13,1661,1,0,'2021-12-01',6776.00,1,1.00,'Factura A N°: 0004-00007503',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(152,7777,2,40719,40880,13,1661,1,0,'2021-12-01',175450.00,1,1.00,'Factura A N°: 0004-00007504',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(153,7777,2,40719,40880,13,1661,1,0,'2021-12-01',65340.00,1,1.00,'Factura A N°: 0004-00007529',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(154,7777,2,40719,40880,13,1661,1,0,'2021-12-01',300080.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000299',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(155,7777,2,40719,40880,13,1661,1,0,'2021-12-01',33759.00,1,1.00,'Factura A N°: 0004-00007541',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(156,7777,2,40719,40880,13,1661,1,0,'2021-12-01',65340.00,1,1.00,'Factura A N°: 0004-00007570',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(157,7777,2,40719,40880,13,1661,1,0,'2021-12-01',49005.00,1,1.00,'Factura A N°: 0004-00007574',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(158,7777,2,40719,40880,13,1661,1,0,'2021-12-01',350900.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000304',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(159,7777,2,40719,40880,13,1661,1,0,'2021-12-01',459679.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000308',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(160,7777,2,40719,40881,13,1661,2,0,'2021-12-01',36300.00,1,1.00,'Nota de crédito A N°: 0004-00000288',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13'),(161,7777,2,40719,40882,13,1661,1,0,'2021-12-01',363000.00,1,1.00,'Factura A N°: 0004-00007613',NULL,'2022-09-27 10:53:04','2022-09-27 13:28:13','2022-09-27 13:28:13');
INSERT INTO `cta_cte_cliente` VALUES (162,7777,2,40719,40883,13,1661,1,0,'2021-12-01',33880.00,1,1.00,'Factura A N°: 0004-00007439',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(163,7777,2,40719,40884,13,1661,1,0,'2021-12-01',83079.64,1,1.00,'Factura B N°: 0004-00001217',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(164,7777,2,40719,40884,13,1661,1,0,'2021-12-01',54450.00,1,1.00,'Factura B N°: 0004-00001228',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(165,7777,2,40719,40885,13,1661,1,0,'2021-12-01',62436.00,1,1.00,'Factura A N°: 0004-00007433',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(166,7777,2,40719,40885,13,1661,1,0,'2021-12-01',41624.00,1,1.00,'Factura A N°: 0004-00007472',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(167,7777,2,40719,40885,13,1661,1,0,'2021-12-01',62436.00,1,1.00,'Factura A N°: 0004-00007525',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(168,7777,2,40719,40885,13,1661,1,0,'2021-12-01',16940.00,1,1.00,'Factura A N°: 0004-00007552',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(169,7777,2,40719,40885,13,1661,1,0,'2021-12-01',63888.00,1,1.00,'Factura A N°: 0004-00007578',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(170,7777,2,40719,40886,13,1661,1,0,'2021-12-01',85184.00,1,1.00,'Factura A N°: 0004-00007490',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(171,7777,2,40719,40886,13,1661,1,0,'2021-12-01',20812.00,1,1.00,'Factura A N°: 0004-00007594',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(172,7777,2,40719,40887,13,1661,1,0,'2021-12-01',39954.20,1,1.00,'Factura A N°: 0004-00007448',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(173,7777,2,40719,40888,13,1661,1,0,'2021-12-01',41745.00,1,1.00,'Factura A N°: 0004-00007468',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(174,7777,2,40719,40889,13,1661,1,0,'2021-12-01',21780.00,1,1.00,'Factura A N°: 0004-00007440',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(175,7777,2,40719,40889,13,1661,1,0,'2021-12-01',9075.00,1,1.00,'Factura A N°: 0004-00007546',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(176,7777,2,40719,40889,13,1661,1,0,'2021-12-01',30250.00,1,1.00,'Factura A N°: 0004-00007592',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(177,7777,2,40719,40889,13,1661,1,0,'2021-12-01',9075.00,1,1.00,'Factura A N°: 0004-00007625',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(178,7777,2,40719,40889,13,1661,2,0,'2021-12-01',9075.00,1,1.00,'Nota de crédito A N°: 0004-00000294',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(179,7777,2,40719,40890,13,1661,1,0,'2021-12-01',521985.03,1,1.00,'Factura A N°: 0004-00007477',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:13','2022-09-27 13:28:13'),(180,7777,2,40719,40890,13,1661,1,0,'2021-12-01',9378.24,1,1.00,'Factura A N°: 0004-00007516',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(181,7777,2,40719,40890,13,1661,1,0,'2021-12-01',324280.00,1,1.00,'Factura A N°: 0004-00007601',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(182,7777,2,40719,40890,13,1661,1,0,'2021-12-01',8131.20,1,1.00,'Factura A N°: 0004-00007612',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(183,7777,2,40719,40891,13,1661,1,0,'2021-12-01',11253.00,1,1.00,'Factura A N°: 0004-00007455',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(184,7777,2,40719,40891,13,1661,1,0,'2021-12-01',55660.00,1,1.00,'Factura A N°: 0004-00007501',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14');
INSERT INTO `cta_cte_cliente` VALUES (185,7777,2,40719,40891,13,1661,1,0,'2021-12-01',5995.49,1,1.00,'Factura A N°: 0004-00007526',NULL,'2022-09-27 10:53:05','2022-09-27 13:28:14','2022-09-27 13:28:14'),(186,7777,2,40719,40891,13,1661,1,0,'2021-12-01',58080.00,1,1.00,'Factura A N°: 0004-00007527',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(187,7777,2,40719,40891,13,1661,1,0,'2021-12-01',87120.00,1,1.00,'Factura A N°: 0004-00007528',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(188,7777,2,40719,40891,13,1661,1,0,'2021-12-01',4954.95,1,1.00,'Factura A N°: 0004-00007542',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(189,7777,2,40719,40891,13,1661,2,0,'2021-12-01',5995.49,1,1.00,'Nota de crédito A N°: 0004-00000292',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(190,7777,2,40719,40891,13,1661,1,0,'2021-12-01',69696.00,1,1.00,'Factura A N°: 0004-00007567',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(191,7777,2,40719,40892,13,1661,1,0,'2021-12-01',2377274.90,1,1.00,'Factura A N°: 0004-00007593',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(192,7777,2,40719,40892,13,1661,1,0,'2021-12-01',55935.88,1,1.00,'Factura A N°: 0004-00007598',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(193,7777,2,40719,40893,13,1661,1,0,'2021-12-01',10466.50,1,1.00,'Factura A N°: 0004-00007547',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(194,7777,2,40719,40893,13,1661,1,0,'2021-12-01',265595.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000307',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(195,7777,2,40719,40894,13,1661,1,0,'2021-12-01',78529.00,1,1.00,'Factura B N°: 0004-00001205',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(196,7777,2,40719,40894,13,1661,1,0,'2021-12-01',302258.00,1,1.00,'Factura B N°: 0004-00001210',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(197,7777,2,40719,40894,13,1661,1,0,'2021-12-01',18755.00,1,1.00,'Factura B N°: 0004-00001221',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(198,7777,2,40719,40895,13,1661,1,0,'2021-12-01',64800.00,1,1.00,'Factura B N°: 0004-00001211',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(199,7777,2,40719,40896,13,1661,1,0,'2021-12-01',7744.00,1,1.00,'Factura A N°: 0004-00007571',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(200,7777,2,40719,40897,13,1661,1,0,'2021-12-01',22597.96,1,1.00,'Factura A N°: 0004-00007453',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(201,7777,2,40719,40897,13,1661,1,0,'2021-12-01',98010.00,1,1.00,'Factura A N°: 0004-00007454',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(202,7777,2,40719,40898,13,1661,1,0,'2021-12-01',10587.50,1,1.00,'Factura A N°: 0004-00007519',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(203,7777,2,40719,40898,13,1661,1,0,'2021-12-01',23716.00,1,1.00,'Factura A N°: 0004-00007561',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(204,7777,2,40719,40899,13,1661,1,0,'2021-12-01',23716.00,1,1.00,'Factura A N°: 0004-00007557',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(205,7777,2,40719,40900,13,1661,1,0,'2021-12-01',70180.00,1,1.00,'Factura A N°: 0004-00007508',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(206,7777,2,40719,40900,13,1661,1,0,'2021-12-01',67518.00,1,1.00,'Factura A N°: 0004-00007617',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(207,7777,2,40719,40901,13,1661,1,0,'2021-12-01',38115.00,1,1.00,'Factura A N°: 0004-00007622',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14');
INSERT INTO `cta_cte_cliente` VALUES (208,7777,2,40719,40902,13,1661,1,0,'2021-12-01',25192.20,1,1.00,'Factura A N°: 0004-00007576',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(209,7777,2,40719,40903,13,1661,1,0,'2021-12-01',10164.00,1,1.00,'Factura A N°: 0004-00007457',NULL,'2022-09-27 10:53:06','2022-09-27 13:28:14','2022-09-27 13:28:14'),(210,7777,2,40719,40903,13,1661,1,0,'2021-12-01',19602.00,1,1.00,'Factura A N°: 0004-00007458',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(211,7777,2,40719,40903,13,1661,1,0,'2021-12-01',38750.25,1,1.00,'Factura A N°: 0004-00007479',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(212,7777,2,40719,40903,13,1661,1,0,'2021-12-01',19602.00,1,1.00,'Factura A N°: 0004-00007532',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(213,7777,2,40719,40903,13,1661,1,0,'2021-12-01',63525.00,1,1.00,'Factura A N°: 0004-00007566',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(214,7777,2,40719,40904,13,1661,1,0,'2021-12-01',159132.00,1,1.00,'Factura B N°: 0004-00001199',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(215,7777,2,40719,40904,13,1661,1,0,'2021-12-01',26680.50,1,1.00,'Factura B N°: 0004-00001204',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:14','2022-09-27 13:28:14'),(216,7777,2,40719,40904,13,1661,1,0,'2021-12-01',38115.00,1,1.00,'Factura B N°: 0004-00001212',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(217,7777,2,40719,40904,13,1661,1,0,'2021-12-01',18755.00,1,1.00,'Factura B N°: 0004-00001213',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(218,7777,2,40719,40904,13,1661,1,0,'2021-12-01',13320.00,1,1.00,'Factura B N°: 0004-00001222',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(219,7777,2,40719,40905,13,1661,1,0,'2021-12-01',46464.00,1,1.00,'Factura A N°: 0004-00007476',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(220,7777,2,40719,40905,13,1661,1,0,'2021-12-01',208725.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000298',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(221,7777,2,40719,40905,13,1661,1,0,'2021-12-01',208725.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000301',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(222,7777,2,40719,40905,13,1661,1,0,'2021-12-01',202917.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000305',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(223,7777,2,40719,40905,13,1661,1,0,'2021-12-01',3751.00,1,1.00,'Factura A N°: 0004-00007591',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(224,7777,2,40719,40906,13,1661,1,0,'2021-12-01',125840.00,1,1.00,'Factura A N°: 0004-00007427',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(225,7777,2,40719,40907,13,1661,1,0,'2021-12-01',937.75,1,1.00,'Factura A N°: 0004-00007518',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(226,7777,2,40719,40907,13,1661,1,0,'2021-12-01',937.75,1,1.00,'Factura A N°: 0004-00007611',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(227,7777,2,40719,40908,13,1661,1,0,'2021-12-01',176418.00,1,1.00,'Factura B N°: 0004-00001201',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(228,7777,2,40719,40908,13,1661,1,0,'2021-12-01',8228.00,1,1.00,'Factura B N°: 0004-00001207',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(229,7777,2,40719,40908,13,1661,1,0,'2021-12-01',55660.00,1,1.00,'Factura B N°: 0004-00001215',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(230,7777,2,40719,40908,13,1661,1,0,'2021-12-01',100963.00,1,1.00,'Factura B N°: 0004-00001225',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15');
INSERT INTO `cta_cte_cliente` VALUES (231,7777,2,40719,40908,13,1661,1,0,'2021-12-01',42350.00,1,1.00,'Factura B N°: 0004-00001229',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(232,7777,2,40719,40909,13,1661,1,0,'2021-12-01',5372.40,1,1.00,'Factura A N°: 0004-00007459',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(233,7777,2,40719,40909,13,1661,1,0,'2021-12-01',44528.00,1,1.00,'Factura A N°: 0004-00007460',NULL,'2022-09-27 10:53:07','2022-09-27 13:28:15','2022-09-27 13:28:15'),(234,7777,2,40719,40909,13,1661,1,0,'2021-12-01',802130.18,1,1.00,'Factura A N°: 0004-00007478',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(235,7777,2,40719,40909,13,1661,1,0,'2021-12-01',172546.00,1,1.00,'Factura A N°: 0004-00007538',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(236,7777,2,40719,40909,13,1661,1,0,'2021-12-01',77440.00,1,1.00,'Factura A N°: 0004-00007587',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(237,7777,2,40719,40910,13,1661,1,0,'2021-12-01',9982.50,1,1.00,'Factura B N°: 0004-00001220',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(238,7777,2,40719,40911,13,1661,1,0,'2021-12-01',50820.00,1,1.00,'Factura A N°: 0004-00007569',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(239,7777,2,40719,40912,13,1661,1,0,'2021-12-01',19602.00,1,1.00,'Factura A N°: 0004-00007523',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(240,7777,2,40719,40913,13,1661,1,0,'2021-12-01',296401.60,1,1.00,'Factura A N°: 0004-00007441',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(241,7777,2,40719,40913,13,1661,2,0,'2021-12-01',296401.60,1,1.00,'Nota de crédito A N°: 0004-00000289',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(242,7777,2,40719,40913,13,1661,1,0,'2021-12-01',159720.00,1,1.00,'Factura A N°: 0004-00007500',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(243,7777,2,40719,40914,13,1661,1,0,'2021-12-01',48400.00,1,1.00,'Factura A N°: 0004-00007597',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(244,7777,2,40719,40915,13,1661,1,0,'2021-12-01',164196.03,1,1.00,'Factura A N°: 0004-00007512',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(245,7777,2,40719,40916,13,1661,1,0,'2021-12-01',163350.00,1,1.00,'Factura A N°: 0004-00007430',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(246,7777,2,40719,40916,13,1661,1,0,'2021-12-01',254100.00,1,1.00,'Factura A N°: 0004-00007521',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(247,7777,2,40719,40917,13,1661,1,0,'2021-12-01',16607.25,1,1.00,'Factura A N°: 0004-00007497',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(248,7777,2,40719,40917,13,1661,1,0,'2021-12-01',26317.50,1,1.00,'Factura A N°: 0004-00007522',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(249,7777,2,40719,40917,13,1661,1,0,'2021-12-01',286044.00,1,1.00,'Factura A N°: 0004-00007556',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(250,7777,2,40719,40917,13,1661,1,0,'2021-12-01',5263.50,1,1.00,'Factura A N°: 0004-00007577',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(251,7777,2,40719,40918,13,1661,1,0,'2021-12-01',340765.04,1,1.00,'Factura A N°: 0004-00007558',NULL,'2022-09-27 10:53:08','2022-09-27 13:28:15','2022-09-27 13:28:15'),(252,7777,2,40719,40918,13,1661,1,0,'2021-12-01',171576.79,1,1.00,'Factura A N°: 0004-00007623',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(253,7777,2,40719,40919,13,1661,1,0,'2021-12-01',142296.00,1,1.00,'Factura A N°: 0004-00007555',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15');
INSERT INTO `cta_cte_cliente` VALUES (254,7777,2,40719,40919,13,1661,1,0,'2021-12-01',49005.00,1,1.00,'Factura A N°: 0004-00007559',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(255,7777,2,40719,40920,13,1661,1,0,'2021-12-01',17800.00,1,1.00,'Factura B N°: 0004-00001202',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(256,7777,2,40719,40921,13,1661,1,0,'2021-12-01',29516.26,1,1.00,'Factura A N°: 0004-00007495',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(257,7777,2,40719,40922,13,1661,1,0,'2021-12-01',29516.26,1,1.00,'Factura A N°: 0004-00007496',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(258,7777,2,40719,40923,13,1661,1,0,'2021-12-01',38720.00,1,1.00,'Factura A N°: 0004-00007511',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(259,7777,2,40719,40924,13,1661,1,0,'2021-12-01',617100.00,1,1.00,'Factura A N°: 0004-00007600',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(260,7777,2,40719,40925,13,1661,1,0,'2021-12-01',296401.60,1,1.00,'Factura A N°: 0004-00007469',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(261,7777,2,40719,40926,13,1661,1,0,'2021-12-01',50820.00,1,1.00,'Factura A N°: 0004-00007494',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(262,7777,2,40719,40926,13,1661,1,0,'2021-12-01',15004.00,1,1.00,'Factura A N°: 0004-00007520',NULL,'2022-09-27 10:53:09','2022-09-27 13:28:15','2022-09-27 13:28:15'),(263,NULL,2,40719,40825,13,1661,1,0,'2021-12-01',3025.00,1,1.00,'Factura A N°: 0004-00007449',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(264,NULL,2,40719,40825,13,1661,1,0,'2021-12-01',11797.50,1,1.00,'Factura A N°: 0004-00007584',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(265,NULL,2,40719,40826,13,1661,2,0,'2021-12-01',193600.00,1,1.00,'NOTA DE CREDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000023',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(266,NULL,2,40719,40827,13,1661,1,0,'2021-12-01',73872.48,1,1.00,'Factura B N°: 0004-00001209',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(267,NULL,2,40719,40827,13,1661,1,0,'2021-12-01',4094.00,1,1.00,'Factura B N°: 0004-00001214',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(268,NULL,2,40719,40827,13,1661,1,0,'2021-12-01',2420.00,1,1.00,'Factura B N°: 0004-00001224',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(269,NULL,2,40719,40827,13,1661,1,0,'2021-12-01',2521.50,1,1.00,'Factura B N°: 0004-00001231',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(270,NULL,2,40719,40827,13,1661,1,0,'2021-12-01',2420.00,1,1.00,'Factura B N°: 0004-00001232',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(271,NULL,2,40719,40828,13,1661,1,0,'2021-12-01',15730.00,1,1.00,'Factura A N°: 0004-00007445',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(272,NULL,2,40719,40829,13,1661,1,0,'2021-12-01',55660.00,1,1.00,'Factura A N°: 0004-00007517',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(273,NULL,2,40719,40829,13,1661,1,0,'2021-12-01',55660.00,1,1.00,'Factura A N°: 0004-00007564',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(274,NULL,2,40719,40830,13,1661,1,0,'2021-12-01',2964.50,1,1.00,'Factura A N°: 0004-00007443',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(275,NULL,2,40719,40830,13,1661,1,0,'2021-12-01',5747.50,1,1.00,'Factura A N°: 0004-00007444',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(276,NULL,2,40719,40830,13,1661,1,0,'2021-12-01',8288.50,1,1.00,'Factura A N°: 0004-00007461',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(277,NULL,2,40719,40831,13,1661,1,0,'2021-12-01',1914704.00,1,1.00,'Factura A N°: 0004-00007471',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(278,NULL,2,40719,40831,13,1661,1,0,'2021-12-01',315810.00,1,1.00,'Factura A N°: 0004-00007513',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (279,NULL,2,40719,40832,13,1661,1,0,'2021-12-01',79376.00,1,1.00,'Factura A N°: 0004-00007438',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(280,NULL,2,40719,40832,13,1661,1,0,'2021-12-01',79376.00,1,1.00,'Factura A N°: 0004-00007502',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(281,NULL,2,40719,40832,13,1661,1,0,'2021-12-01',83732.00,1,1.00,'Factura A N°: 0004-00007563',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(282,NULL,2,40719,40832,13,1661,1,0,'2021-12-01',81917.00,1,1.00,'Factura A N°: 0004-00007605',NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(283,NULL,2,40719,40833,13,1661,1,0,'2021-12-01',77440.00,1,1.00,'Factura A N°: 0004-00007616',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(284,NULL,2,40719,40834,13,1661,1,0,'2021-12-01',3751.00,1,1.00,'Factura B N°: 0004-00001206',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(285,NULL,2,40719,40834,13,1661,1,0,'2021-12-01',157865.00,1,1.00,'Factura B N°: 0004-00001216',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(286,NULL,2,40719,40834,13,1661,1,0,'2021-12-01',30250.00,1,1.00,'Factura B N°: 0004-00001226',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(287,NULL,2,40719,40834,13,1661,1,0,'2021-12-01',285560.00,1,1.00,'Factura B N°: 0004-00001227',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(288,NULL,2,40719,40834,13,1661,1,0,'2021-12-01',36300.00,1,1.00,'Factura B N°: 0004-00001230',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(289,NULL,2,40719,40835,13,1661,1,0,'2021-12-01',62097.20,1,1.00,'Factura A N°: 0004-00007543',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(290,NULL,2,40719,40836,13,1661,1,0,'2021-12-01',26620.00,1,1.00,'Factura A N°: 0004-00007568',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(291,NULL,2,40719,40837,13,1661,1,0,'2021-12-01',49740.08,1,1.00,'Factura A N°: 0004-00007492',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(292,NULL,2,40719,40837,13,1661,1,0,'2021-12-01',123178.00,1,1.00,'Factura A N°: 0004-00007539',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(293,NULL,2,40719,40837,13,1661,1,0,'2021-12-01',19360.00,1,1.00,'Factura A N°: 0004-00007580',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(294,NULL,2,40719,40837,13,1661,1,0,'2021-12-01',84276.50,1,1.00,'Factura A N°: 0004-00007624',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(295,NULL,2,40719,40838,13,1661,1,0,'2021-12-01',6243.60,1,1.00,'Factura A N°: 0004-00007545',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(296,NULL,2,40719,40839,13,1661,1,0,'2021-12-01',23353.00,1,1.00,'Factura A N°: 0004-00007610',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(297,NULL,2,40719,40840,13,1661,1,0,'2021-12-01',25711.29,1,1.00,'Factura A N°: 0004-00007465',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(298,NULL,2,40719,40841,13,1661,1,0,'2021-12-01',76862.27,1,1.00,'Factura A N°: 0004-00007475',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(299,NULL,2,40719,40841,13,1661,1,0,'2021-12-01',111467.62,1,1.00,'Factura A N°: 0004-00007507',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(300,NULL,2,40719,40841,13,1661,1,0,'2021-12-01',655.05,1,1.00,'Factura A N°: 0004-00007514',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(301,NULL,2,40719,40841,13,1661,1,0,'2021-12-01',3899.71,1,1.00,'Factura A N°: 0004-00007515',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(302,NULL,2,40719,40841,13,1661,1,0,'2021-12-01',83228.88,1,1.00,'Factura A N°: 0004-00007562',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(303,NULL,2,40719,40841,13,1661,1,0,'2021-12-01',93207.27,1,1.00,'Factura A N°: 0004-00007595',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(304,NULL,2,40719,40842,13,1661,1,0,'2021-12-01',546315.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000302',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL);
INSERT INTO `cta_cte_cliente` VALUES (305,NULL,2,40719,40843,13,1661,1,0,'2021-12-01',62338.60,1,1.00,'Factura A N°: 0004-00007537',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(306,NULL,2,40719,40843,13,1661,1,0,'2021-12-01',26059.77,1,1.00,'Factura A N°: 0004-00007590',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(307,NULL,2,40719,40843,13,1661,1,0,'2021-12-01',4456.91,1,1.00,'Factura A N°: 0004-00007596',NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(308,NULL,2,40719,40844,13,1661,1,0,'2021-12-01',5082.00,1,1.00,'Factura A N°: 0004-00007588',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(309,NULL,2,40719,40845,13,1661,1,0,'2021-12-01',180048.00,1,1.00,'Factura A N°: 0004-00007498',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(310,NULL,2,40719,40846,13,1661,1,0,'2021-12-01',45012.00,1,1.00,'Factura A N°: 0004-00007608',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(311,NULL,2,40719,40847,13,1661,1,0,'2021-12-01',290400.00,1,1.00,'Factura A N°: 0004-00007506',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(312,NULL,2,40719,40847,13,1661,1,0,'2021-12-01',188760.00,1,1.00,'Factura A N°: 0004-00007510',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(313,NULL,2,40719,40847,13,1661,1,0,'2021-12-01',425920.00,1,1.00,'Factura A N°: 0004-00007604',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(314,NULL,2,40719,40848,13,1661,1,0,'2021-12-01',25410.00,1,1.00,'Factura A N°: 0004-00007554',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(315,NULL,2,40719,40849,13,1661,1,0,'2021-12-01',133100.00,1,1.00,'Factura A N°: 0004-00007486',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(316,NULL,2,40719,40850,13,1661,1,0,'2021-12-01',708329.14,1,1.00,'Factura B N°: 0004-00001200',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(317,NULL,2,40719,40850,13,1661,1,0,'2021-12-01',77319.00,1,1.00,'Factura B N°: 0004-00001203',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(318,NULL,2,40719,40850,13,1661,1,0,'2021-12-01',5666.00,1,1.00,'Factura B N°: 0004-00001208',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(319,NULL,2,40719,40850,13,1661,1,0,'2021-12-01',2200.00,1,1.00,'Factura B N°: 0004-00001218',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(320,NULL,2,40719,40850,13,1661,2,0,'2021-12-01',230.00,1,1.00,'Nota de crédito B N°: 0004-00000077',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(321,NULL,2,40719,40850,13,1661,2,0,'2021-12-01',37200.00,1,1.00,'Nota de crédito B N°: 0004-00000078',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(322,NULL,2,40719,40850,13,1661,1,0,'2021-12-01',75867.00,1,1.00,'Factura B N°: 0004-00001223',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(323,NULL,2,40719,40851,13,1661,1,0,'2021-12-01',49005.00,1,1.00,'Factura A N°: 0004-00007551',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(324,NULL,2,40719,40852,13,1661,1,0,'2021-12-01',106480.00,1,1.00,'Factura B N°: 0004-00001219',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(325,NULL,2,40719,40853,13,1661,1,0,'2021-12-01',52514.00,1,1.00,'Factura A N°: 0004-00007452',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(326,NULL,2,40719,40853,13,1661,1,0,'2021-12-01',42579.90,1,1.00,'Factura A N°: 0004-00007480',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(327,NULL,2,40719,40853,13,1661,1,0,'2021-12-01',263632.38,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000297',NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(328,NULL,2,40719,40853,13,1661,1,0,'2021-12-01',52514.00,1,1.00,'Factura A N°: 0004-00007586',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(329,NULL,2,40719,40853,13,1661,1,0,'2021-12-01',337206.43,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000306',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(330,NULL,2,40719,40854,13,1661,1,0,'2021-12-01',344850.00,1,1.00,'Factura A N°: 0004-00007524',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL);
INSERT INTO `cta_cte_cliente` VALUES (331,NULL,2,40719,40854,13,1661,1,0,'2021-12-01',114950.00,1,1.00,'Factura A N°: 0004-00007536',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(332,NULL,2,40719,40855,13,1661,1,0,'2021-12-01',136125.00,1,1.00,'Factura A N°: 0004-00007463',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(333,NULL,2,40719,40855,13,1661,1,0,'2021-12-01',120516.00,1,1.00,'Factura A N°: 0004-00007575',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(334,NULL,2,40719,40855,13,1661,1,0,'2021-12-01',31218.00,1,1.00,'Factura A N°: 0004-00007609',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(335,NULL,2,40719,40856,13,1661,1,0,'2021-12-01',52635.00,1,1.00,'Factura A N°: 0004-00007583',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(336,NULL,2,40719,40856,13,1661,1,0,'2021-12-01',52635.00,1,1.00,'Factura A N°: 0004-00007621',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(337,NULL,2,40719,40857,13,1661,1,0,'2021-12-01',19360.00,1,1.00,'Factura A N°: 0004-00007436',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(338,NULL,2,40719,40857,13,1661,1,0,'2021-12-01',236857.50,1,1.00,'Factura A N°: 0004-00007599',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(339,NULL,2,40719,40858,13,1661,1,0,'2021-12-01',115434.00,1,1.00,'Factura A N°: 0004-00007483',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(340,NULL,2,40719,40858,13,1661,1,0,'2021-12-01',87120.00,1,1.00,'Factura A N°: 0004-00007544',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(341,NULL,2,40719,40859,13,1661,1,0,'2021-12-01',111804.00,1,1.00,'Factura A N°: 0004-00007432',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(342,NULL,2,40719,40859,13,1661,1,0,'2021-12-01',111804.00,1,1.00,'Factura A N°: 0004-00007462',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(343,NULL,2,40719,40859,13,1661,1,0,'2021-12-01',172425.00,1,1.00,'Factura A N°: 0004-00007489',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(344,NULL,2,40719,40859,13,1661,1,0,'2021-12-01',111804.00,1,1.00,'Factura A N°: 0004-00007540',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(345,NULL,2,40719,40859,13,1661,1,0,'2021-12-01',111804.00,1,1.00,'Factura A N°: 0004-00007582',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(346,NULL,2,40719,40859,13,1661,1,0,'2021-12-01',154880.00,1,1.00,'Factura A N°: 0004-00007619',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(347,NULL,2,40719,40859,13,1661,1,0,'2021-12-01',50820.00,1,1.00,'Factura A N°: 0004-00007620',NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(348,NULL,2,40719,40860,13,1661,1,0,'2021-12-01',74899.00,1,1.00,'Factura A N°: 0004-00007534',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(349,NULL,2,40719,40860,13,1661,1,0,'2021-12-01',23232.00,1,1.00,'Factura A N°: 0004-00007573',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(350,NULL,2,40719,40861,13,1661,1,0,'2021-12-01',93899.03,1,1.00,'Factura A N°: 0004-00007434',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(351,NULL,2,40719,40861,13,1661,1,0,'2021-12-01',26777.30,1,1.00,'Factura A N°: 0004-00007473',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(352,NULL,2,40719,40861,13,1661,1,0,'2021-12-01',27104.00,1,1.00,'Factura A N°: 0004-00007505',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(353,NULL,2,40719,40861,13,1661,1,0,'2021-12-01',92516.60,1,1.00,'Factura A N°: 0004-00007579',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(354,NULL,2,40719,40862,13,1661,1,0,'2021-12-01',20424.80,1,1.00,'Factura A N°: 0004-00007429',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(355,NULL,2,40719,40862,13,1661,1,0,'2021-12-01',13068.00,1,1.00,'Factura A N°: 0004-00007553',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(356,NULL,2,40719,40862,13,1661,2,0,'2021-12-01',13068.00,1,1.00,'Nota de crédito A N°: 0004-00000293',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL);
INSERT INTO `cta_cte_cliente` VALUES (357,NULL,2,40719,40862,13,1661,1,0,'2021-12-01',17351.40,1,1.00,'Factura A N°: 0004-00007615',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(358,NULL,2,40719,40863,13,1661,1,0,'2021-12-01',94864.00,1,1.00,'Factura A N°: 0004-00007560',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(359,NULL,2,40719,40864,13,1661,1,0,'2021-12-01',36300.00,1,1.00,'Factura A N°: 0004-00007491',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(360,NULL,2,40719,40864,13,1661,1,0,'2021-12-01',19965.00,1,1.00,'Factura A N°: 0004-00007565',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(361,NULL,2,40719,40865,13,1661,1,0,'2021-12-01',36300.00,1,1.00,'Factura A N°: 0004-00007435',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(362,NULL,2,40719,40866,13,1661,1,0,'2021-12-01',1169918.75,1,1.00,'Factura A N°: 0004-00007447',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(363,NULL,2,40719,40866,13,1661,1,0,'2021-12-01',21780.00,1,1.00,'Factura A N°: 0004-00007470',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(364,NULL,2,40719,40866,13,1661,1,0,'2021-12-01',75020.00,1,1.00,'Factura A N°: 0004-00007589',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(365,NULL,2,40719,40867,13,1661,1,0,'2021-12-01',130680.00,1,1.00,'Factura A N°: 0004-00007474',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(366,NULL,2,40719,40867,13,1661,1,0,'2021-12-01',60802.50,1,1.00,'Factura A N°: 0004-00007481',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(367,NULL,2,40719,40867,13,1661,1,0,'2021-12-01',18150.00,1,1.00,'Factura A N°: 0004-00007509',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(368,NULL,2,40719,40867,13,1661,1,0,'2021-12-01',37510.00,1,1.00,'Factura A N°: 0004-00007618',NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(369,NULL,2,40719,40868,13,1661,1,0,'2021-12-01',79376.00,1,1.00,'Factura A N°: 0004-00007456',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(370,NULL,2,40719,40868,13,1661,1,0,'2021-12-01',85184.00,1,1.00,'Factura A N°: 0004-00007550',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(371,NULL,2,40719,40868,13,1661,1,0,'2021-12-01',42592.00,1,1.00,'Factura A N°: 0004-00007607',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(372,NULL,2,40719,40869,13,1661,1,0,'2021-12-01',99480.15,1,1.00,'Factura A N°: 0004-00007493',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(373,NULL,2,40719,40870,13,1661,1,0,'2021-12-01',170610.00,1,1.00,'Factura A N°: 0004-00007428',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(374,NULL,2,40719,40870,13,1661,1,0,'2021-12-01',83187.50,1,1.00,'Factura A N°: 0004-00007446',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(375,NULL,2,40719,40870,13,1661,1,0,'2021-12-01',45375.00,1,1.00,'Factura A N°: 0004-00007535',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(376,NULL,2,40719,40870,13,1661,1,0,'2021-12-01',23837.00,1,1.00,'Factura A N°: 0004-00007581',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(377,NULL,2,40719,40871,13,1661,1,0,'2021-12-01',33275.00,1,1.00,'Factura A N°: 0004-00007482',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(378,NULL,2,40719,40872,13,1661,2,0,'2021-12-01',125840.00,1,1.00,'Nota de crédito A N°: 0004-00000290',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(379,NULL,2,40719,40873,13,1661,1,0,'2021-12-01',10890.00,1,1.00,'Factura A N°: 0004-00007484',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(380,NULL,2,40719,40873,13,1661,1,0,'2021-12-01',21175.00,1,1.00,'Factura A N°: 0004-00007487',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(381,NULL,2,40719,40873,13,1661,2,0,'2021-12-01',52030.00,1,1.00,'Nota de crédito A N°: 0004-00000291',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(382,NULL,2,40719,40873,13,1661,1,0,'2021-12-01',59622.75,1,1.00,'Factura A N°: 0004-00007530',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (383,NULL,2,40719,40873,13,1661,1,0,'2021-12-01',26620.00,1,1.00,'Factura A N°: 0004-00007531',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(384,NULL,2,40719,40873,13,1661,1,0,'2021-12-01',228690.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000303',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(385,NULL,2,40719,40873,13,1661,1,0,'2021-12-01',49489.00,1,1.00,'Factura A N°: 0004-00007606',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(386,NULL,2,40719,40874,13,1661,1,0,'2021-12-01',231310.86,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000296',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(387,NULL,2,40719,40874,13,1661,1,0,'2021-12-01',231310.86,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000300',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(388,NULL,2,40719,40874,13,1661,1,0,'2021-12-01',108280.48,1,1.00,'Factura A N°: 0004-00007572',NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(389,NULL,2,40719,40874,13,1661,1,0,'2021-12-01',195339.98,1,1.00,'Factura A N°: 0004-00007603',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(390,NULL,2,40719,40875,13,1661,1,0,'2021-12-01',108658.00,1,1.00,'Factura A N°: 0004-00007464',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(391,NULL,2,40719,40875,13,1661,1,0,'2021-12-01',66792.00,1,1.00,'Factura A N°: 0004-00007485',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(392,NULL,2,40719,40875,13,1661,1,0,'2021-12-01',104181.00,1,1.00,'Factura A N°: 0004-00007533',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(393,NULL,2,40719,40875,13,1661,1,0,'2021-12-01',142538.00,1,1.00,'Factura A N°: 0004-00007614',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(394,NULL,2,40719,40876,13,1661,1,0,'2021-12-01',21538.00,1,1.00,'Factura A N°: 0004-00007437',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(395,NULL,2,40719,40876,13,1661,1,0,'2021-12-01',18755.00,1,1.00,'Factura A N°: 0004-00007548',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(396,NULL,2,40719,40876,13,1661,1,0,'2021-12-01',43076.00,1,1.00,'Factura A N°: 0004-00007549',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(397,NULL,2,40719,40877,13,1661,1,0,'2021-12-01',33880.00,1,1.00,'Factura A N°: 0004-00007466',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(398,NULL,2,40719,40877,13,1661,1,0,'2021-12-01',53542.50,1,1.00,'Factura A N°: 0004-00007488',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(399,NULL,2,40719,40877,13,1661,1,0,'2021-12-01',7562.50,1,1.00,'Factura A N°: 0004-00007499',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(400,NULL,2,40719,40878,13,1661,1,0,'2021-12-01',68244.00,1,1.00,'Factura A N°: 0004-00007585',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(401,NULL,2,40719,40879,13,1661,1,0,'2021-12-01',21780.00,1,1.00,'Factura A N°: 0004-00007467',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(402,NULL,2,40719,40879,13,1661,1,0,'2021-12-01',21780.00,1,1.00,'Factura A N°: 0004-00007602',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(403,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',52635.00,1,1.00,'Factura A N°: 0004-00007431',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(404,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',33759.00,1,1.00,'Factura A N°: 0004-00007442',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(405,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',122815.00,1,1.00,'Factura A N°: 0004-00007450',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(406,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',65340.00,1,1.00,'Factura A N°: 0004-00007451',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(407,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',427372.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000295',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL);
INSERT INTO `cta_cte_cliente` VALUES (408,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',6776.00,1,1.00,'Factura A N°: 0004-00007503',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(409,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',175450.00,1,1.00,'Factura A N°: 0004-00007504',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(410,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',65340.00,1,1.00,'Factura A N°: 0004-00007529',NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(411,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',300080.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000299',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(412,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',33759.00,1,1.00,'Factura A N°: 0004-00007541',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(413,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',65340.00,1,1.00,'Factura A N°: 0004-00007570',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(414,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',49005.00,1,1.00,'Factura A N°: 0004-00007574',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(415,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',350900.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000304',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(416,NULL,2,40719,40880,13,1661,1,0,'2021-12-01',459679.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000308',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(417,NULL,2,40719,40881,13,1661,2,0,'2021-12-01',36300.00,1,1.00,'Nota de crédito A N°: 0004-00000288',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(418,NULL,2,40719,40882,13,1661,1,0,'2021-12-01',363000.00,1,1.00,'Factura A N°: 0004-00007613',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(419,NULL,2,40719,40883,13,1661,1,0,'2021-12-01',33880.00,1,1.00,'Factura A N°: 0004-00007439',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(420,NULL,2,40719,40884,13,1661,1,0,'2021-12-01',83079.64,1,1.00,'Factura B N°: 0004-00001217',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(421,NULL,2,40719,40884,13,1661,1,0,'2021-12-01',54450.00,1,1.00,'Factura B N°: 0004-00001228',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(422,NULL,2,40719,40885,13,1661,1,0,'2021-12-01',62436.00,1,1.00,'Factura A N°: 0004-00007433',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(423,NULL,2,40719,40885,13,1661,1,0,'2021-12-01',41624.00,1,1.00,'Factura A N°: 0004-00007472',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(424,NULL,2,40719,40885,13,1661,1,0,'2021-12-01',62436.00,1,1.00,'Factura A N°: 0004-00007525',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(425,NULL,2,40719,40885,13,1661,1,0,'2021-12-01',16940.00,1,1.00,'Factura A N°: 0004-00007552',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(426,NULL,2,40719,40885,13,1661,1,0,'2021-12-01',63888.00,1,1.00,'Factura A N°: 0004-00007578',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(427,NULL,2,40719,40886,13,1661,1,0,'2021-12-01',85184.00,1,1.00,'Factura A N°: 0004-00007490',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(428,NULL,2,40719,40886,13,1661,1,0,'2021-12-01',20812.00,1,1.00,'Factura A N°: 0004-00007594',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(429,NULL,2,40719,40887,13,1661,1,0,'2021-12-01',39954.20,1,1.00,'Factura A N°: 0004-00007448',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(430,NULL,2,40719,40888,13,1661,1,0,'2021-12-01',41745.00,1,1.00,'Factura A N°: 0004-00007468',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(431,NULL,2,40719,40889,13,1661,1,0,'2021-12-01',21780.00,1,1.00,'Factura A N°: 0004-00007440',NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(432,NULL,2,40719,40889,13,1661,1,0,'2021-12-01',9075.00,1,1.00,'Factura A N°: 0004-00007546',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL);
INSERT INTO `cta_cte_cliente` VALUES (433,NULL,2,40719,40889,13,1661,1,0,'2021-12-01',30250.00,1,1.00,'Factura A N°: 0004-00007592',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(434,NULL,2,40719,40889,13,1661,1,0,'2021-12-01',9075.00,1,1.00,'Factura A N°: 0004-00007625',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(435,NULL,2,40719,40889,13,1661,2,0,'2021-12-01',9075.00,1,1.00,'Nota de crédito A N°: 0004-00000294',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(436,NULL,2,40719,40890,13,1661,1,0,'2021-12-01',521985.03,1,1.00,'Factura A N°: 0004-00007477',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(437,NULL,2,40719,40890,13,1661,1,0,'2021-12-01',9378.24,1,1.00,'Factura A N°: 0004-00007516',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(438,NULL,2,40719,40890,13,1661,1,0,'2021-12-01',324280.00,1,1.00,'Factura A N°: 0004-00007601',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(439,NULL,2,40719,40890,13,1661,1,0,'2021-12-01',8131.20,1,1.00,'Factura A N°: 0004-00007612',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(440,NULL,2,40719,40891,13,1661,1,0,'2021-12-01',11253.00,1,1.00,'Factura A N°: 0004-00007455',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(441,NULL,2,40719,40891,13,1661,1,0,'2021-12-01',55660.00,1,1.00,'Factura A N°: 0004-00007501',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(442,NULL,2,40719,40891,13,1661,1,0,'2021-12-01',5995.49,1,1.00,'Factura A N°: 0004-00007526',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(443,NULL,2,40719,40891,13,1661,1,0,'2021-12-01',58080.00,1,1.00,'Factura A N°: 0004-00007527',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(444,NULL,2,40719,40891,13,1661,1,0,'2021-12-01',87120.00,1,1.00,'Factura A N°: 0004-00007528',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(445,NULL,2,40719,40891,13,1661,1,0,'2021-12-01',4954.95,1,1.00,'Factura A N°: 0004-00007542',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(446,NULL,2,40719,40891,13,1661,2,0,'2021-12-01',5995.49,1,1.00,'Nota de crédito A N°: 0004-00000292',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(447,NULL,2,40719,40891,13,1661,1,0,'2021-12-01',69696.00,1,1.00,'Factura A N°: 0004-00007567',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(448,NULL,2,40719,40892,13,1661,1,0,'2021-12-01',2377274.90,1,1.00,'Factura A N°: 0004-00007593',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(449,NULL,2,40719,40892,13,1661,1,0,'2021-12-01',55935.88,1,1.00,'Factura A N°: 0004-00007598',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(450,NULL,2,40719,40893,13,1661,1,0,'2021-12-01',10466.50,1,1.00,'Factura A N°: 0004-00007547',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(451,NULL,2,40719,40893,13,1661,1,0,'2021-12-01',265595.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000307',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(452,NULL,2,40719,40894,13,1661,1,0,'2021-12-01',78529.00,1,1.00,'Factura B N°: 0004-00001205',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(453,NULL,2,40719,40894,13,1661,1,0,'2021-12-01',302258.00,1,1.00,'Factura B N°: 0004-00001210',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(454,NULL,2,40719,40894,13,1661,1,0,'2021-12-01',18755.00,1,1.00,'Factura B N°: 0004-00001221',NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(455,NULL,2,40719,40895,13,1661,1,0,'2021-12-01',64800.00,1,1.00,'Factura B N°: 0004-00001211',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(456,NULL,2,40719,40896,13,1661,1,0,'2021-12-01',7744.00,1,1.00,'Factura A N°: 0004-00007571',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(457,NULL,2,40719,40897,13,1661,1,0,'2021-12-01',22597.96,1,1.00,'Factura A N°: 0004-00007453',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(458,NULL,2,40719,40897,13,1661,1,0,'2021-12-01',98010.00,1,1.00,'Factura A N°: 0004-00007454',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL);
INSERT INTO `cta_cte_cliente` VALUES (459,NULL,2,40719,40898,13,1661,1,0,'2021-12-01',10587.50,1,1.00,'Factura A N°: 0004-00007519',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(460,NULL,2,40719,40898,13,1661,1,0,'2021-12-01',23716.00,1,1.00,'Factura A N°: 0004-00007561',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(461,NULL,2,40719,40899,13,1661,1,0,'2021-12-01',23716.00,1,1.00,'Factura A N°: 0004-00007557',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(462,NULL,2,40719,40900,13,1661,1,0,'2021-12-01',70180.00,1,1.00,'Factura A N°: 0004-00007508',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(463,NULL,2,40719,40900,13,1661,1,0,'2021-12-01',67518.00,1,1.00,'Factura A N°: 0004-00007617',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(464,NULL,2,40719,40901,13,1661,1,0,'2021-12-01',38115.00,1,1.00,'Factura A N°: 0004-00007622',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(465,NULL,2,40719,40902,13,1661,1,0,'2021-12-01',25192.20,1,1.00,'Factura A N°: 0004-00007576',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(466,NULL,2,40719,40903,13,1661,1,0,'2021-12-01',10164.00,1,1.00,'Factura A N°: 0004-00007457',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(467,NULL,2,40719,40903,13,1661,1,0,'2021-12-01',19602.00,1,1.00,'Factura A N°: 0004-00007458',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(468,NULL,2,40719,40903,13,1661,1,0,'2021-12-01',38750.25,1,1.00,'Factura A N°: 0004-00007479',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(469,NULL,2,40719,40903,13,1661,1,0,'2021-12-01',19602.00,1,1.00,'Factura A N°: 0004-00007532',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(470,NULL,2,40719,40903,13,1661,1,0,'2021-12-01',63525.00,1,1.00,'Factura A N°: 0004-00007566',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(471,NULL,2,40719,40904,13,1661,1,0,'2021-12-01',159132.00,1,1.00,'Factura B N°: 0004-00001199',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(472,NULL,2,40719,40904,13,1661,1,0,'2021-12-01',26680.50,1,1.00,'Factura B N°: 0004-00001204',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(473,NULL,2,40719,40904,13,1661,1,0,'2021-12-01',38115.00,1,1.00,'Factura B N°: 0004-00001212',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(474,NULL,2,40719,40904,13,1661,1,0,'2021-12-01',18755.00,1,1.00,'Factura B N°: 0004-00001213',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(475,NULL,2,40719,40904,13,1661,1,0,'2021-12-01',13320.00,1,1.00,'Factura B N°: 0004-00001222',NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(476,NULL,2,40719,40905,13,1661,1,0,'2021-12-01',46464.00,1,1.00,'Factura A N°: 0004-00007476',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(477,NULL,2,40719,40905,13,1661,1,0,'2021-12-01',208725.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000298',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(478,NULL,2,40719,40905,13,1661,1,0,'2021-12-01',208725.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000301',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(479,NULL,2,40719,40905,13,1661,1,0,'2021-12-01',202917.00,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0004-00000305',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(480,NULL,2,40719,40905,13,1661,1,0,'2021-12-01',3751.00,1,1.00,'Factura A N°: 0004-00007591',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(481,NULL,2,40719,40906,13,1661,1,0,'2021-12-01',125840.00,1,1.00,'Factura A N°: 0004-00007427',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(482,NULL,2,40719,40907,13,1661,1,0,'2021-12-01',937.75,1,1.00,'Factura A N°: 0004-00007518',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(483,NULL,2,40719,40907,13,1661,1,0,'2021-12-01',937.75,1,1.00,'Factura A N°: 0004-00007611',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL);
INSERT INTO `cta_cte_cliente` VALUES (484,NULL,2,40719,40908,13,1661,1,0,'2021-12-01',176418.00,1,1.00,'Factura B N°: 0004-00001201',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(485,NULL,2,40719,40908,13,1661,1,0,'2021-12-01',8228.00,1,1.00,'Factura B N°: 0004-00001207',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(486,NULL,2,40719,40908,13,1661,1,0,'2021-12-01',55660.00,1,1.00,'Factura B N°: 0004-00001215',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(487,NULL,2,40719,40908,13,1661,1,0,'2021-12-01',100963.00,1,1.00,'Factura B N°: 0004-00001225',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(488,NULL,2,40719,40908,13,1661,1,0,'2021-12-01',42350.00,1,1.00,'Factura B N°: 0004-00001229',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(489,NULL,2,40719,40909,13,1661,1,0,'2021-12-01',5372.40,1,1.00,'Factura A N°: 0004-00007459',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(490,NULL,2,40719,40909,13,1661,1,0,'2021-12-01',44528.00,1,1.00,'Factura A N°: 0004-00007460',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(491,NULL,2,40719,40909,13,1661,1,0,'2021-12-01',802130.18,1,1.00,'Factura A N°: 0004-00007478',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(492,NULL,2,40719,40909,13,1661,1,0,'2021-12-01',172546.00,1,1.00,'Factura A N°: 0004-00007538',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(493,NULL,2,40719,40909,13,1661,1,0,'2021-12-01',77440.00,1,1.00,'Factura A N°: 0004-00007587',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(494,NULL,2,40719,40910,13,1661,1,0,'2021-12-01',9982.50,1,1.00,'Factura B N°: 0004-00001220',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(495,NULL,2,40719,40911,13,1661,1,0,'2021-12-01',50820.00,1,1.00,'Factura A N°: 0004-00007569',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(496,NULL,2,40719,40912,13,1661,1,0,'2021-12-01',19602.00,1,1.00,'Factura A N°: 0004-00007523',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(497,NULL,2,40719,40913,13,1661,1,0,'2021-12-01',296401.60,1,1.00,'Factura A N°: 0004-00007441',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(498,NULL,2,40719,40913,13,1661,2,0,'2021-12-01',296401.60,1,1.00,'Nota de crédito A N°: 0004-00000289',NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(499,NULL,2,40719,40913,13,1661,1,0,'2021-12-01',159720.00,1,1.00,'Factura A N°: 0004-00007500',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(500,NULL,2,40719,40914,13,1661,1,0,'2021-12-01',48400.00,1,1.00,'Factura A N°: 0004-00007597',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(501,NULL,2,40719,40915,13,1661,1,0,'2021-12-01',164196.03,1,1.00,'Factura A N°: 0004-00007512',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(502,NULL,2,40719,40916,13,1661,1,0,'2021-12-01',163350.00,1,1.00,'Factura A N°: 0004-00007430',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(503,NULL,2,40719,40916,13,1661,1,0,'2021-12-01',254100.00,1,1.00,'Factura A N°: 0004-00007521',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(504,NULL,2,40719,40917,13,1661,1,0,'2021-12-01',16607.25,1,1.00,'Factura A N°: 0004-00007497',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(505,NULL,2,40719,40917,13,1661,1,0,'2021-12-01',26317.50,1,1.00,'Factura A N°: 0004-00007522',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(506,NULL,2,40719,40917,13,1661,1,0,'2021-12-01',286044.00,1,1.00,'Factura A N°: 0004-00007556',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(507,NULL,2,40719,40917,13,1661,1,0,'2021-12-01',5263.50,1,1.00,'Factura A N°: 0004-00007577',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(508,NULL,2,40719,40918,13,1661,1,0,'2021-12-01',340765.04,1,1.00,'Factura A N°: 0004-00007558',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(509,NULL,2,40719,40918,13,1661,1,0,'2021-12-01',171576.79,1,1.00,'Factura A N°: 0004-00007623',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL);
INSERT INTO `cta_cte_cliente` VALUES (510,NULL,2,40719,40919,13,1661,1,0,'2021-12-01',142296.00,1,1.00,'Factura A N°: 0004-00007555',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(511,NULL,2,40719,40919,13,1661,1,0,'2021-12-01',49005.00,1,1.00,'Factura A N°: 0004-00007559',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(512,NULL,2,40719,40920,13,1661,1,0,'2021-12-01',17800.00,1,1.00,'Factura B N°: 0004-00001202',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(513,NULL,2,40719,40921,13,1661,1,0,'2021-12-01',29516.26,1,1.00,'Factura A N°: 0004-00007495',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(514,NULL,2,40719,40922,13,1661,1,0,'2021-12-01',29516.26,1,1.00,'Factura A N°: 0004-00007496',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(515,NULL,2,40719,40923,13,1661,1,0,'2021-12-01',38720.00,1,1.00,'Factura A N°: 0004-00007511',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(516,NULL,2,40719,40924,13,1661,1,0,'2021-12-01',617100.00,1,1.00,'Factura A N°: 0004-00007600',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(517,NULL,2,40719,40925,13,1661,1,0,'2021-12-01',296401.60,1,1.00,'Factura A N°: 0004-00007469',NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(518,NULL,2,40719,40926,13,1661,1,0,'2021-12-01',50820.00,1,1.00,'Factura A N°: 0004-00007494',NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(519,NULL,2,40719,40926,13,1661,1,0,'2021-12-01',15004.00,1,1.00,'Factura A N°: 0004-00007520',NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(520,7777,2,40719,40927,13,12,1,0,'2022-10-07',8000.00,1,1.00,'Factura B N°: 0008-00002345',NULL,'2022-10-07 10:59:16','2022-10-07 11:00:41','2022-10-07 11:00:41'),(521,7777,2,40719,40927,13,12,1,0,'2022-10-07',10000.00,1,1.00,'Factura B N°: 0001-00123456',NULL,'2022-10-07 11:00:08','2022-10-07 11:02:42','2022-10-07 11:02:42'),(522,7777,2,40719,40927,13,12,1,0,'2022-10-07',10000.00,1,1.00,'Factura B N°: 0001-00123456',NULL,'2022-10-07 11:02:42','2022-10-07 11:04:29','2022-10-07 11:04:29'),(523,7777,2,40719,40927,13,12,1,0,'2022-10-07',10000.00,1,1.00,'Factura B N°: 0001-00123456',NULL,'2022-10-07 11:04:29','2022-10-07 11:06:12','2022-10-07 11:06:12'),(524,7777,2,40719,40718,13,12,1,0,'2022-10-07',10000.00,1,1.00,'Factura B N°: 0001-00002345',NULL,'2022-10-07 11:23:34','2022-10-07 11:23:34',NULL),(525,7777,3,40719,40928,57,12,2,0,'2022-10-07',24200.00,1,1.00,'Factura A N°: 0008-00086543',NULL,'2022-10-07 15:01:30','2022-10-07 15:03:29','2022-10-07 15:03:29'),(526,7777,3,40719,40928,57,12,2,0,'2022-10-07',24200.00,1,1.00,'Factura A N°: 0008-00086543',NULL,'2022-10-07 15:03:29','2022-10-07 15:44:10','2022-10-07 15:44:10'),(527,7777,20,40719,40718,13,12,2,0,'2022-10-07',10000.00,1,1.00,NULL,NULL,'2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(528,7777,20,40719,40882,13,1661,2,0,'2021-12-31',363000.00,1,1.00,NULL,NULL,'2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(529,7777,20,40719,40845,13,1661,2,0,'2021-12-31',180048.00,1,1.00,NULL,NULL,'2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(530,7777,20,40719,40916,13,1661,2,0,'2021-12-31',254100.00,1,1.00,NULL,NULL,'2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(531,7777,20,40719,40916,13,1661,2,0,'2021-12-31',163350.00,1,1.00,NULL,NULL,'2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(532,7777,21,40719,40721,57,1661,1,0,'2022-10-07',24200.00,1,1.00,NULL,NULL,'2022-10-07 15:33:06','2022-10-07 15:44:10','2022-10-07 15:44:10'),(534,7777,3,40719,40928,57,12,2,0,'2022-10-07',24200.00,1,1.00,'Factura A N°: 0001-00234234',NULL,'2022-10-07 15:48:50','2022-10-07 15:48:50',NULL),(535,7777,21,40719,40928,57,12,1,0,'2022-10-07',24200.00,1,1.00,NULL,NULL,'2022-10-07 15:50:02','2022-10-07 15:50:02',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_details` VALUES (1,7777,4,40719,40721,57,11,21,1,1310.09,'2022-09-08 11:42:06','2022-09-08 11:46:20','2022-09-08 11:46:20'),(2,7777,4,40719,40721,359,11,21,2,1310.09,'2022-09-08 11:42:06','2022-09-08 11:46:20','2022-09-08 11:46:20'),(3,7777,5,40719,40721,57,11,21,1,1310.90,'2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(4,7777,5,40719,40721,359,11,21,2,1310.90,'2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(5,7777,527,40719,40718,13,12,20,2,10000.00,'2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(6,7777,527,40719,40718,359,12,20,1,10000.00,'2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(7,7777,528,40719,40882,13,1661,20,2,363000.00,'2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(8,7777,528,40719,40882,359,1661,20,1,363000.00,'2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(9,7777,529,40719,40845,13,1661,20,2,180048.00,'2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(10,7777,529,40719,40845,359,1661,20,1,180048.00,'2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(11,7777,530,40719,40916,13,1661,20,2,254100.00,'2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(12,7777,530,40719,40916,359,1661,20,1,254100.00,'2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(13,7777,531,40719,40916,13,1661,20,2,163350.00,'2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(14,7777,531,40719,40916,359,1661,20,1,163350.00,'2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(15,7777,532,40719,40721,57,1661,21,1,24200.00,'2022-10-07 15:33:06','2022-10-07 15:44:10','2022-10-07 15:44:10'),(16,7777,532,40719,40721,359,1661,21,2,24200.00,'2022-10-07 15:33:06','2022-10-07 15:44:10','2022-10-07 15:44:10'),(19,7777,535,40719,40928,57,12,21,1,24200.00,'2022-10-07 15:50:02','2022-10-07 15:50:02',NULL),(20,7777,535,40719,40928,359,12,21,2,24200.00,'2022-10-07 15:50:02','2022-10-07 15:50:02',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=533 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,7777,1,1,NULL,'2022-09-08 10:30:29','2022-09-08 10:40:46','2022-09-08 10:40:46'),(2,7777,2,2,NULL,'2022-09-08 10:40:18','2022-09-08 10:40:18',NULL),(3,7777,3,1,NULL,'2022-09-08 10:40:46','2022-09-08 10:40:46',NULL),(4,NULL,6,3,NULL,'2022-09-27 10:52:56','2022-09-27 10:52:56',NULL),(5,NULL,7,4,NULL,'2022-09-27 10:52:56','2022-09-27 10:52:56',NULL),(6,NULL,8,5,NULL,'2022-09-27 10:52:56','2022-09-27 10:52:56',NULL),(7,NULL,9,6,NULL,'2022-09-27 10:52:56','2022-09-27 10:52:56',NULL),(8,NULL,10,7,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(9,NULL,11,8,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(10,NULL,12,9,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(11,NULL,13,10,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(12,NULL,14,11,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(13,NULL,15,12,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(14,NULL,16,13,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(15,NULL,17,14,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(16,NULL,18,15,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(17,NULL,19,16,NULL,'2022-09-27 10:52:57','2022-09-27 10:52:57',NULL),(18,NULL,20,17,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(19,NULL,21,18,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(20,NULL,22,19,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(21,NULL,23,20,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(22,NULL,24,21,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(23,NULL,25,22,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(24,NULL,26,23,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(25,NULL,27,24,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(26,NULL,28,25,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(27,NULL,29,26,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(28,NULL,30,27,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(29,NULL,31,28,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(30,NULL,32,29,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(31,NULL,33,30,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(32,NULL,34,31,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(33,NULL,35,32,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(34,NULL,36,33,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(35,NULL,37,34,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(36,NULL,38,35,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(37,NULL,39,36,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(38,NULL,40,37,NULL,'2022-09-27 10:52:58','2022-09-27 10:52:58',NULL),(39,NULL,41,38,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(40,NULL,42,39,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(41,NULL,43,40,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(42,NULL,44,41,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(43,NULL,45,42,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(44,NULL,46,43,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(45,NULL,47,44,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(46,NULL,48,45,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(47,NULL,49,46,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(48,NULL,50,47,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(49,NULL,51,48,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(50,NULL,52,49,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(51,NULL,53,50,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(52,NULL,54,51,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(53,NULL,55,52,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(54,NULL,56,53,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(55,NULL,57,54,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(56,NULL,58,55,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(57,NULL,59,56,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (58,NULL,60,57,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(59,NULL,61,58,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(60,NULL,62,59,NULL,'2022-09-27 10:52:59','2022-09-27 10:52:59',NULL),(61,NULL,63,60,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(62,NULL,64,61,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(63,NULL,65,62,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(64,NULL,66,63,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(65,NULL,67,64,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(66,NULL,68,65,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(67,NULL,69,66,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(68,NULL,70,67,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(69,NULL,71,68,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(70,NULL,72,69,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(71,NULL,73,70,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(72,NULL,74,71,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(73,NULL,75,72,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(74,NULL,76,73,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(75,NULL,77,74,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(76,NULL,78,75,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(77,NULL,79,76,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(78,NULL,80,77,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(79,NULL,81,78,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(80,NULL,82,79,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(81,NULL,83,80,NULL,'2022-09-27 10:53:00','2022-09-27 10:53:00',NULL),(82,NULL,84,81,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(83,NULL,85,82,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(84,NULL,86,83,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(85,NULL,87,84,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(86,NULL,88,85,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(87,NULL,89,86,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(88,NULL,90,87,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(89,NULL,91,88,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(90,NULL,92,89,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(91,NULL,93,90,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(92,NULL,94,91,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(93,NULL,95,92,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(94,NULL,96,93,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(95,NULL,97,94,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(96,NULL,98,95,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(97,NULL,99,96,NULL,'2022-09-27 10:53:01','2022-09-27 10:53:01',NULL),(98,NULL,100,97,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(99,NULL,101,98,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(100,NULL,102,99,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(101,NULL,103,100,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(102,NULL,104,101,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(103,NULL,105,102,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(104,NULL,106,103,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(105,NULL,107,104,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(106,NULL,108,105,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(107,NULL,109,106,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(108,NULL,110,107,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(109,NULL,111,108,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(110,NULL,112,109,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(111,NULL,113,110,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(112,NULL,114,111,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(113,NULL,115,112,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (114,NULL,116,113,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(115,NULL,117,114,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(116,NULL,118,115,NULL,'2022-09-27 10:53:02','2022-09-27 10:53:02',NULL),(117,NULL,119,116,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(118,NULL,120,117,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(119,NULL,121,118,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(120,NULL,122,119,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(121,NULL,123,120,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(122,NULL,124,121,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(123,NULL,125,122,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(124,NULL,126,123,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(125,NULL,127,124,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(126,NULL,128,125,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(127,NULL,129,126,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(128,NULL,130,127,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(129,NULL,131,128,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(130,NULL,132,129,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(131,NULL,133,130,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(132,NULL,134,131,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(133,NULL,135,132,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(134,NULL,136,133,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(135,NULL,137,134,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(136,NULL,138,135,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(137,NULL,139,136,NULL,'2022-09-27 10:53:03','2022-09-27 10:53:03',NULL),(138,NULL,140,137,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(139,NULL,141,138,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(140,NULL,142,139,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(141,NULL,143,140,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(142,NULL,144,141,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(143,NULL,145,142,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(144,NULL,146,143,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(145,NULL,147,144,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(146,NULL,148,145,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(147,NULL,149,146,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(148,NULL,150,147,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(149,NULL,151,148,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(150,NULL,152,149,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(151,NULL,153,150,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(152,NULL,154,151,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(153,NULL,155,152,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(154,NULL,156,153,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(155,NULL,157,154,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(156,NULL,158,155,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(157,NULL,159,156,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(158,NULL,160,157,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(159,NULL,161,158,NULL,'2022-09-27 10:53:04','2022-09-27 10:53:04',NULL),(160,NULL,162,159,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(161,NULL,163,160,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(162,NULL,164,161,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(163,NULL,165,162,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(164,NULL,166,163,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(165,NULL,167,164,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(166,NULL,168,165,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(167,NULL,169,166,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (168,NULL,170,167,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(169,NULL,171,168,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(170,NULL,172,169,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(171,NULL,173,170,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(172,NULL,174,171,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(173,NULL,175,172,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(174,NULL,176,173,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(175,NULL,177,174,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(176,NULL,178,175,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(177,NULL,179,176,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(178,NULL,180,177,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(179,NULL,181,178,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(180,NULL,182,179,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(181,NULL,183,180,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(182,NULL,184,181,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(183,NULL,185,182,NULL,'2022-09-27 10:53:05','2022-09-27 10:53:05',NULL),(184,NULL,186,183,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(185,NULL,187,184,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(186,NULL,188,185,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(187,NULL,189,186,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(188,NULL,190,187,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(189,NULL,191,188,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(190,NULL,192,189,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(191,NULL,193,190,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(192,NULL,194,191,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(193,NULL,195,192,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(194,NULL,196,193,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(195,NULL,197,194,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(196,NULL,198,195,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(197,NULL,199,196,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(198,NULL,200,197,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(199,NULL,201,198,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(200,NULL,202,199,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(201,NULL,203,200,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(202,NULL,204,201,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(203,NULL,205,202,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(204,NULL,206,203,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(205,NULL,207,204,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(206,NULL,208,205,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(207,NULL,209,206,NULL,'2022-09-27 10:53:06','2022-09-27 10:53:06',NULL),(208,NULL,210,207,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(209,NULL,211,208,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(210,NULL,212,209,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(211,NULL,213,210,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(212,NULL,214,211,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(213,NULL,215,212,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(214,NULL,216,213,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(215,NULL,217,214,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(216,NULL,218,215,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(217,NULL,219,216,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(218,NULL,220,217,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(219,NULL,221,218,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(220,NULL,222,219,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(221,NULL,223,220,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (222,NULL,224,221,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(223,NULL,225,222,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(224,NULL,226,223,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(225,NULL,227,224,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(226,NULL,228,225,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(227,NULL,229,226,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(228,NULL,230,227,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(229,NULL,231,228,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(230,NULL,232,229,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(231,NULL,233,230,NULL,'2022-09-27 10:53:07','2022-09-27 10:53:07',NULL),(232,NULL,234,231,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(233,NULL,235,232,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(234,NULL,236,233,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(235,NULL,237,234,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(236,NULL,238,235,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(237,NULL,239,236,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(238,NULL,240,237,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(239,NULL,241,238,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(240,NULL,242,239,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(241,NULL,243,240,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(242,NULL,244,241,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(243,NULL,245,242,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(244,NULL,246,243,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(245,NULL,247,244,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(246,NULL,248,245,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(247,NULL,249,246,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(248,NULL,250,247,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(249,NULL,251,248,NULL,'2022-09-27 10:53:08','2022-09-27 10:53:08',NULL),(250,NULL,252,249,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(251,NULL,253,250,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(252,NULL,254,251,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(253,NULL,255,252,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(254,NULL,256,253,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(255,NULL,257,254,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(256,NULL,258,255,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(257,NULL,259,256,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(258,NULL,260,257,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(259,NULL,261,258,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(260,NULL,262,259,NULL,'2022-09-27 10:53:09','2022-09-27 10:53:09',NULL),(261,NULL,263,270,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(262,NULL,264,271,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(263,NULL,265,272,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(264,NULL,266,273,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(265,NULL,267,274,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(266,NULL,268,275,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(267,NULL,269,276,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(268,NULL,270,277,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(269,NULL,271,278,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(270,NULL,272,279,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(271,NULL,273,280,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(272,NULL,274,281,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(273,NULL,275,282,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(274,NULL,276,283,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(275,NULL,277,284,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (276,NULL,278,285,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(277,NULL,279,286,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(278,NULL,280,287,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(279,NULL,281,288,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(280,NULL,282,289,NULL,'2022-09-27 13:32:42','2022-09-27 13:32:42',NULL),(281,NULL,283,290,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(282,NULL,284,291,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(283,NULL,285,292,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(284,NULL,286,293,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(285,NULL,287,294,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(286,NULL,288,295,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(287,NULL,289,296,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(288,NULL,290,297,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(289,NULL,291,298,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(290,NULL,292,299,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(291,NULL,293,300,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(292,NULL,294,301,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(293,NULL,295,302,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(294,NULL,296,303,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(295,NULL,297,304,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(296,NULL,298,305,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(297,NULL,299,306,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(298,NULL,300,307,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(299,NULL,301,308,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(300,NULL,302,309,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(301,NULL,303,310,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(302,NULL,304,311,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(303,NULL,305,312,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(304,NULL,306,313,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(305,NULL,307,314,NULL,'2022-09-27 13:32:43','2022-09-27 13:32:43',NULL),(306,NULL,308,315,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(307,NULL,309,316,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(308,NULL,310,317,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(309,NULL,311,318,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(310,NULL,312,319,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(311,NULL,313,320,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(312,NULL,314,321,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(313,NULL,315,322,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(314,NULL,316,323,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(315,NULL,317,324,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(316,NULL,318,325,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(317,NULL,319,326,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(318,NULL,320,327,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(319,NULL,321,328,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(320,NULL,322,329,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(321,NULL,323,330,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(322,NULL,324,331,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(323,NULL,325,332,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(324,NULL,326,333,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(325,NULL,327,334,NULL,'2022-09-27 13:32:44','2022-09-27 13:32:44',NULL),(326,NULL,328,335,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(327,NULL,329,336,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(328,NULL,330,337,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(329,NULL,331,338,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (330,NULL,332,339,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(331,NULL,333,340,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(332,NULL,334,341,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(333,NULL,335,342,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(334,NULL,336,343,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(335,NULL,337,344,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(336,NULL,338,345,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(337,NULL,339,346,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(338,NULL,340,347,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(339,NULL,341,348,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(340,NULL,342,349,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(341,NULL,343,350,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(342,NULL,344,351,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(343,NULL,345,352,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(344,NULL,346,353,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(345,NULL,347,354,NULL,'2022-09-27 13:32:45','2022-09-27 13:32:45',NULL),(346,NULL,348,355,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(347,NULL,349,356,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(348,NULL,350,357,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(349,NULL,351,358,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(350,NULL,352,359,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(351,NULL,353,360,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(352,NULL,354,361,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(353,NULL,355,362,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(354,NULL,356,363,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(355,NULL,357,364,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(356,NULL,358,365,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(357,NULL,359,366,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(358,NULL,360,367,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(359,NULL,361,368,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(360,NULL,362,369,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(361,NULL,363,370,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(362,NULL,364,371,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(363,NULL,365,372,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(364,NULL,366,373,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(365,NULL,367,374,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(366,NULL,368,375,NULL,'2022-09-27 13:32:46','2022-09-27 13:32:46',NULL),(367,NULL,369,376,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(368,NULL,370,377,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(369,NULL,371,378,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(370,NULL,372,379,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(371,NULL,373,380,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(372,NULL,374,381,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(373,NULL,375,382,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(374,NULL,376,383,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(375,NULL,377,384,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(376,NULL,378,385,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(377,NULL,379,386,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(378,NULL,380,387,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(379,NULL,381,388,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(380,NULL,382,389,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(381,NULL,383,390,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(382,NULL,384,391,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(383,NULL,385,392,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (384,NULL,386,393,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(385,NULL,387,394,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(386,NULL,388,395,NULL,'2022-09-27 13:32:47','2022-09-27 13:32:47',NULL),(387,NULL,389,396,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(388,NULL,390,397,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(389,NULL,391,398,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(390,NULL,392,399,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(391,NULL,393,400,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(392,NULL,394,401,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(393,NULL,395,402,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(394,NULL,396,403,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(395,NULL,397,404,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(396,NULL,398,405,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(397,NULL,399,406,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(398,NULL,400,407,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(399,NULL,401,408,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(400,NULL,402,409,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(401,NULL,403,410,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(402,NULL,404,411,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(403,NULL,405,412,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(404,NULL,406,413,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(405,NULL,407,414,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(406,NULL,408,415,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(407,NULL,409,416,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(408,NULL,410,417,NULL,'2022-09-27 13:32:48','2022-09-27 13:32:48',NULL),(409,NULL,411,418,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(410,NULL,412,419,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(411,NULL,413,420,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(412,NULL,414,421,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(413,NULL,415,422,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(414,NULL,416,423,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(415,NULL,417,424,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(416,NULL,418,425,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(417,NULL,419,426,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(418,NULL,420,427,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(419,NULL,421,428,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(420,NULL,422,429,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(421,NULL,423,430,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(422,NULL,424,431,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(423,NULL,425,432,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(424,NULL,426,433,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(425,NULL,427,434,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(426,NULL,428,435,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(427,NULL,429,436,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(428,NULL,430,437,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(429,NULL,431,438,NULL,'2022-09-27 13:32:49','2022-09-27 13:32:49',NULL),(430,NULL,432,439,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(431,NULL,433,440,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(432,NULL,434,441,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(433,NULL,435,442,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(434,NULL,436,443,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(435,NULL,437,444,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(436,NULL,438,445,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(437,NULL,439,446,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (438,NULL,440,447,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(439,NULL,441,448,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(440,NULL,442,449,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(441,NULL,443,450,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(442,NULL,444,451,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(443,NULL,445,452,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(444,NULL,446,453,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(445,NULL,447,454,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(446,NULL,448,455,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(447,NULL,449,456,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(448,NULL,450,457,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(449,NULL,451,458,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(450,NULL,452,459,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(451,NULL,453,460,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(452,NULL,454,461,NULL,'2022-09-27 13:32:50','2022-09-27 13:32:50',NULL),(453,NULL,455,462,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(454,NULL,456,463,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(455,NULL,457,464,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(456,NULL,458,465,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(457,NULL,459,466,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(458,NULL,460,467,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(459,NULL,461,468,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(460,NULL,462,469,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(461,NULL,463,470,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(462,NULL,464,471,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(463,NULL,465,472,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(464,NULL,466,473,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(465,NULL,467,474,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(466,NULL,468,475,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(467,NULL,469,476,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(468,NULL,470,477,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(469,NULL,471,478,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(470,NULL,472,479,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(471,NULL,473,480,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(472,NULL,474,481,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(473,NULL,475,482,NULL,'2022-09-27 13:32:51','2022-09-27 13:32:51',NULL),(474,NULL,476,483,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(475,NULL,477,484,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(476,NULL,478,485,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(477,NULL,479,486,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(478,NULL,480,487,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(479,NULL,481,488,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(480,NULL,482,489,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(481,NULL,483,490,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(482,NULL,484,491,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(483,NULL,485,492,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(484,NULL,486,493,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(485,NULL,487,494,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(486,NULL,488,495,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(487,NULL,489,496,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(488,NULL,490,497,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(489,NULL,491,498,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(490,NULL,492,499,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(491,NULL,493,500,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (492,NULL,494,501,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(493,NULL,495,502,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(494,NULL,496,503,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(495,NULL,497,504,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(496,NULL,498,505,NULL,'2022-09-27 13:32:52','2022-09-27 13:32:52',NULL),(497,NULL,499,506,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(498,NULL,500,507,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(499,NULL,501,508,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(500,NULL,502,509,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(501,NULL,503,510,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(502,NULL,504,511,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(503,NULL,505,512,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(504,NULL,506,513,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(505,NULL,507,514,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(506,NULL,508,515,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(507,NULL,509,516,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(508,NULL,510,517,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(509,NULL,511,518,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(510,NULL,512,519,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(511,NULL,513,520,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(512,NULL,514,521,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(513,NULL,515,522,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(514,NULL,516,523,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(515,NULL,517,524,NULL,'2022-09-27 13:32:53','2022-09-27 13:32:53',NULL),(516,NULL,518,525,NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(517,NULL,519,526,NULL,'2022-09-27 13:32:54','2022-09-27 13:32:54',NULL),(518,7777,520,532,NULL,'2022-10-07 10:59:16','2022-10-07 10:59:16',NULL),(519,7777,521,533,NULL,'2022-10-07 11:00:08','2022-10-07 11:02:42','2022-10-07 11:02:42'),(520,7777,522,533,NULL,'2022-10-07 11:02:42','2022-10-07 11:04:29','2022-10-07 11:04:29'),(521,7777,523,533,NULL,'2022-10-07 11:04:29','2022-10-07 11:04:29',NULL),(522,7777,524,534,NULL,'2022-10-07 11:23:34','2022-10-07 11:23:34',NULL),(523,7777,525,535,NULL,'2022-10-07 15:01:30','2022-10-07 15:03:29','2022-10-07 15:03:29'),(524,7777,526,535,NULL,'2022-10-07 15:03:29','2022-10-07 15:03:29',NULL),(525,NULL,527,534,10000.00,NULL,NULL,NULL),(526,NULL,528,425,363000.00,NULL,NULL,NULL),(527,NULL,529,316,180048.00,NULL,NULL,NULL),(528,NULL,530,510,254100.00,NULL,NULL,NULL),(529,NULL,531,509,163350.00,NULL,NULL,NULL),(530,7777,532,535,24200.00,NULL,'2022-10-07 15:44:10','2022-10-07 15:44:10'),(531,7777,534,536,NULL,'2022-10-07 15:48:50','2022-10-07 15:48:50',NULL),(532,NULL,535,536,24200.00,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria` VALUES (1,7777,40719,4,NULL,57,11,'2022-09-08',1310.09,1,1.00,NULL,NULL,'2022-09-08 11:42:06','2022-09-08 11:46:20','2022-09-08 11:46:20'),(2,7777,40719,5,NULL,57,11,'2022-09-08',1310.90,1,1.00,NULL,NULL,'2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(3,7777,40719,527,NULL,13,12,'2022-10-07',10000.00,1,1.00,NULL,NULL,'2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(4,7777,40719,528,NULL,13,1661,'2021-12-31',363000.00,1,1.00,NULL,NULL,'2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(5,7777,40719,529,NULL,13,1661,'2021-12-31',180048.00,1,1.00,NULL,NULL,'2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(6,7777,40719,530,NULL,13,1661,'2021-12-31',254100.00,1,1.00,NULL,NULL,'2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(7,7777,40719,531,NULL,13,1661,'2021-12-31',163350.00,1,1.00,NULL,NULL,'2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(8,7777,40719,532,NULL,57,1661,'2022-10-07',24200.00,1,1.00,NULL,NULL,'2022-10-07 15:33:06','2022-10-07 15:44:10','2022-10-07 15:44:10'),(10,7777,40719,535,NULL,57,12,'2022-10-07',24200.00,1,1.00,NULL,NULL,'2022-10-07 15:50:02','2022-10-07 15:50:02',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES',1,NULL,NULL,NULL),(5,NULL,'PERCEPCIONES',1,NULL,NULL,NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,'Clientes - Deudores',0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,'Anticipos Impuesto a las Ganancias',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,'Retenciones Impuesto a las Ganancias',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(25,NULL,1,25,NULL,4,'Retenciones de IVA',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(57,NULL,1,57,NULL,8,'Proveedores en Cta. Cte. locales',0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,'Cheques emitidos ',0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(62,NULL,1,62,NULL,8,'Sueldos y Jornales a pagar',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,'Intereses y Gastos bancarios',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(162,NULL,1,162,NULL,4,'Retenciones SUSS',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(176,NULL,1,176,NULL,3,'Cheques en Cartera',1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(201,NULL,1,201,NULL,6,'Monotributo',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(203,NULL,1,203,NULL,6,'Autonomos',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(219,NULL,1,219,NULL,8,'Pagos AFIP',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,'Retenciones de IIBB Buenos Aires',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(252,NULL,1,252,NULL,4,'Retenciones de IIBB Capital Federal',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(253,NULL,1,253,NULL,4,'Retenciones de IIBB Catamarca',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(254,NULL,1,254,NULL,4,'Retenciones de IIBB Chaco',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(255,NULL,1,255,NULL,4,'Retenciones de IIBB Chubut',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(256,NULL,1,256,NULL,4,'Retenciones de IIBB Córdoba',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(257,NULL,1,257,NULL,4,'Retenciones de IIBB Corrientes',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(258,NULL,1,258,NULL,4,'Retenciones de IIBB Entre Ríos',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(259,NULL,1,259,NULL,4,'Retenciones de IIBB Formosa',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(260,NULL,1,260,NULL,4,'Retenciones de IIBB Jujuy',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(261,NULL,1,261,NULL,4,'Retenciones de IIBB La Pampa',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(262,NULL,1,262,NULL,4,'Retenciones de IIBB La Rioja',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(263,NULL,1,263,NULL,4,'Retenciones de IIBB Mendoza',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(264,NULL,1,264,NULL,4,'Retenciones de IIBB Misiones',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(265,NULL,1,265,NULL,4,'Retenciones de IIBB Neuquén',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(266,NULL,1,266,NULL,4,'Retenciones de IIBB Pascua Lama',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(267,NULL,1,267,NULL,4,'Retenciones de IIBB Río Negro',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(268,NULL,1,268,NULL,4,'Retenciones de IIBB Salta',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(269,NULL,1,269,NULL,4,'Retenciones de IIBB San Juan',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(270,NULL,1,270,NULL,4,'Retenciones de IIBB San Luis',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(271,NULL,1,271,NULL,4,'Retenciones de IIBB Santa Cruz',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (272,NULL,1,272,NULL,4,'Retenciones de IIBB Santa Fe',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(273,NULL,1,273,NULL,4,'Retenciones de IIBB Santiago del Estero',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(274,NULL,1,274,NULL,4,'Retenciones de IIBB Tierra del Fuego',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(275,NULL,1,275,NULL,4,'Retenciones de IIBB Tucuman',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(351,NULL,1,351,NULL,8,'BANCO SIRCREB',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,'Caja en Pesos',0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:14:23','2023-03-20 23:14:23'),(360,NULL,1,360,NULL,8,'Retenciones Bancarias de Ganancias a Favor',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,'Anticipo de Clientes',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,'Caja en Dolares',0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:14:23','2023-03-20 23:14:23'),(409,NULL,1,409,NULL,6,'IVA Crédito Fiscal No computable',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(418,NULL,1,418,NULL,8,'Deudas Bancarias',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,'Préstamo',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,1,441,NULL,8,'Leasing',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,1,448,NULL,8,'Planes de Pagos AFIP',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,1,450,NULL,3,'Cheques Rechazados',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(467,NULL,1,467,NULL,6,'Interés',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:08:50',NULL),(468,NULL,1,14,NULL,8,'Deudores por ventas comunes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(469,NULL,1,15,NULL,8,'Deudores por ventas morosos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(470,NULL,1,16,NULL,8,'Deudores en gestión judicial',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(471,NULL,1,17,NULL,8,'Previsión deudores incobrables',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(472,NULL,1,22,NULL,8,'Anticipo Impto.Ganancia Mínima Presunta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(473,NULL,1,24,NULL,4,'Impuesto a las Ganancias (Saldo a favor)',0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:54:56',NULL),(474,NULL,1,27,NULL,8,'Anticipos de proveedores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(475,NULL,1,28,NULL,8,'Depósito en garantía alquileres',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(476,NULL,1,29,NULL,8,'Derechos adquiridos a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(477,NULL,1,30,NULL,8,'Intereses a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(478,NULL,1,31,NULL,8,'Cuentas a rendir - Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(479,NULL,1,32,NULL,8,'Alquileres no devengados',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(480,NULL,1,38,NULL,8,'Equipos de computación valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(481,NULL,1,39,NULL,8,'Equipos de computación ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(482,NULL,1,40,NULL,8,'Amortización Acumulada Equipos de comput.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(483,NULL,1,42,NULL,8,'Instalaciones valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(484,NULL,1,43,NULL,8,'Instalaciones ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(485,NULL,1,44,NULL,8,'Amortización Acumulada Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (486,NULL,1,46,NULL,8,'Muebles y utiles valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(487,NULL,1,47,NULL,8,'Muebles y utiles ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(488,NULL,1,48,NULL,8,'Amortización Acumulada Muebles y Útiles',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(489,NULL,1,50,NULL,8,'Gastos de organización valores historicos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(490,NULL,1,51,NULL,8,'Gastos de organización ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(491,NULL,1,52,NULL,8,'Amortización acumulada gs. de organización',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(492,NULL,1,58,NULL,8,'Proveedores en cta. cte. exterior',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(493,NULL,1,59,NULL,8,'Derechos de exhibición a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(494,NULL,1,63,NULL,8,'Cargas sociales a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(495,NULL,1,64,NULL,8,'Sindicatos a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(496,NULL,1,67,NULL,8,'IVA Debito Fiscal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(497,NULL,1,68,NULL,8,'IVA Credito Fiscal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(498,NULL,1,69,NULL,8,'Impuestos Internos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(499,NULL,1,70,NULL,8,'Impuestos al Combustible',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(500,NULL,1,71,NULL,8,'IVA Retenciones de terceros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:50',NULL),(501,NULL,1,72,NULL,5,'IVA Percepciones realiz.por terceros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(502,NULL,1,73,NULL,8,'IVA Saldo a favor',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(503,NULL,1,74,NULL,8,'IVA a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(504,NULL,1,75,NULL,5,'Percepciones Ingresos Brutos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(505,NULL,1,76,NULL,8,'Otros Pagos AFIP',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(506,NULL,1,78,NULL,8,'Impuesto a los Ingresos Brutos Pasivo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(507,NULL,1,79,NULL,8,'Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(508,NULL,1,80,NULL,8,'Impuesto a la Ganancia Mínima Presunta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(509,NULL,1,81,NULL,8,'AFIP - Retenciones Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(510,NULL,1,82,NULL,8,'AFIP - Plan de Facilidades Decreto 338/02',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(511,NULL,1,87,NULL,8,'Acciones en circulación',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(512,NULL,1,88,NULL,8,'Ajuste del Capital',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(513,NULL,1,89,NULL,8,'Aportes Irrevocables Futuras Suscripciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(514,NULL,1,91,NULL,8,'Resultado del ejercicio',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(515,NULL,1,92,NULL,8,'Resultado ejercicios anteriores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(516,NULL,1,93,NULL,8,'A.R.E.A.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(517,NULL,1,96,NULL,7,'VENTAS',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(518,NULL,1,97,NULL,7,'Honorarios',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(519,NULL,1,99,NULL,7,'Descuentos obtenidos',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (520,NULL,1,100,NULL,7,'Reintegros por exportaciones',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(521,NULL,1,102,NULL,7,'Intereses Cobrados',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(522,NULL,1,103,NULL,7,'Diferencias de cambio',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(523,NULL,1,104,NULL,7,'Descuentos obtenidos',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(524,NULL,1,110,NULL,6,'Sueldos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(525,NULL,1,111,NULL,6,'Contribuciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(526,NULL,1,112,NULL,6,'Sindicato',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(527,NULL,1,114,NULL,8,'ACA',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(528,NULL,1,115,NULL,6,'Aereos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(529,NULL,1,116,NULL,6,'Alquiler',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(530,NULL,1,117,NULL,8,'AGUA AYSA',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(531,NULL,1,118,NULL,8,'TV Cablevision',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(532,NULL,1,119,NULL,1,'Caja Jubilacion Consejo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(533,NULL,1,120,NULL,6,'Celulares',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(534,NULL,1,121,NULL,3,'Cheques',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(535,NULL,1,123,NULL,8,'Comida',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(536,NULL,1,126,NULL,6,'Fletes y acarreos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(537,NULL,1,127,NULL,8,'Luz Edesur',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(538,NULL,1,128,NULL,6,'Movilidad y Viáticos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(539,NULL,1,129,NULL,8,'Mantenimiento',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(540,NULL,1,130,NULL,8,'IVA No Computable',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(541,NULL,1,131,NULL,8,'Entretenimiento',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(542,NULL,1,132,NULL,6,'Amortización Bienes de Uso',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(543,NULL,1,135,NULL,6,'Gastos varios',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(544,NULL,1,136,NULL,6,'Ajuste por redondeo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(545,NULL,1,137,NULL,6,'Deudores Incobrables',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(546,NULL,1,141,NULL,6,'Intereses Proveedores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(547,NULL,1,143,NULL,6,'Diferencias de cambio',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(548,NULL,1,144,NULL,8,'Diferencia de Cambio Bces. en M.Extranjera',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(549,NULL,1,145,NULL,6,'Diferencia tipo cambio Vendedor/Comprador',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(550,NULL,1,146,NULL,8,'Diferencia por conversion en Bce. en Mon. Extranj.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(551,NULL,1,147,NULL,8,'Diferencia de cambio CMV',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(552,NULL,1,148,NULL,8,'Diferencia de cambio PT',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(553,NULL,1,149,NULL,8,'Resultado por Exposición a la Inflación',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(554,NULL,1,150,NULL,8,'Diferencia de cambio PE',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(555,NULL,1,151,NULL,8,'Diferencia de cambio Ds.Vtas.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (556,NULL,1,152,NULL,6,'Diferencia de cambio ME',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(557,NULL,1,153,NULL,6,'Descuentos otorgados',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(558,NULL,1,155,NULL,6,'Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(559,NULL,1,156,NULL,6,'Impuesto a los Ingresos Brutos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(560,NULL,1,157,NULL,6,'Impuesto al Debito y Credito Bancario',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(561,NULL,1,159,NULL,6,'Pérdida por venta bienes de uso',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(562,NULL,1,160,NULL,6,'Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(563,NULL,1,161,NULL,6,'Amortizaciones extraordinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(564,NULL,1,178,NULL,8,'Google',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(565,NULL,1,188,NULL,6,'Publicidad',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(566,NULL,1,191,NULL,6,'Cargas Sociales',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(567,NULL,1,192,NULL,6,'Honorarios',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(568,NULL,1,193,NULL,6,'Telefono Fijo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(569,NULL,1,198,NULL,6,'Seguros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(570,NULL,1,199,NULL,6,'Internet',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(571,NULL,1,204,NULL,6,'Multas Impositivas',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(572,NULL,1,208,NULL,6,'Impuesto a los Ingresos Brutos - BS AS',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(573,NULL,1,209,NULL,6,'SIRCREB',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(574,NULL,1,212,NULL,6,'Tarjeta Visa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(575,NULL,1,213,NULL,6,'Tarjeta American Express',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(576,NULL,1,214,NULL,6,'Tarjeta Mastercard',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(577,NULL,1,215,NULL,8,'Tarjeta Shopping',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(578,NULL,1,216,NULL,6,'Tarjeta Cencosud',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(579,NULL,1,217,NULL,6,'Compras',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(580,NULL,1,218,NULL,7,'Ventas No Gravadas',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(581,NULL,1,220,NULL,5,'Perc IVA -RG3337',0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:54:56',NULL),(582,NULL,1,221,NULL,6,'Imps. Internos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(583,NULL,1,222,NULL,6,'Imp. Gasoil',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(584,NULL,1,223,NULL,6,'Imp. Hídricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(585,NULL,1,224,NULL,6,'ITC',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(586,NULL,1,225,NULL,5,'Perc IIBB  Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(587,NULL,1,226,NULL,5,'Perc IIBB  Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(588,NULL,1,227,NULL,5,'Perc IIBB  Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(589,NULL,1,228,NULL,5,'Perc IIBB  Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(590,NULL,1,229,NULL,5,'Perc IIBB  Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(591,NULL,1,230,NULL,5,'Perc IIBB  Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(592,NULL,1,231,NULL,5,'Perc IIBB  Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (593,NULL,1,232,NULL,5,'Perc IIBB  Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(594,NULL,1,233,NULL,5,'Perc IIBB  Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(595,NULL,1,234,NULL,5,'Perc IIBB  Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(596,NULL,1,235,NULL,5,'Perc IIBB  La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(597,NULL,1,236,NULL,5,'Perc IIBB  La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(598,NULL,1,237,NULL,5,'Perc IIBB  Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(599,NULL,1,238,NULL,5,'Perc IIBB  Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(600,NULL,1,239,NULL,5,'Perc IIBB  Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(601,NULL,1,240,NULL,5,'Perc IIBB  Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(602,NULL,1,241,NULL,5,'Perc IIBB  Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(603,NULL,1,242,NULL,5,'Perc IIBB  Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(604,NULL,1,243,NULL,5,'Perc IIBB  San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(605,NULL,1,244,NULL,5,'Perc IIBB  San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(606,NULL,1,245,NULL,5,'Perc IIBB  Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(607,NULL,1,246,NULL,5,'Perc IIBB  Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(608,NULL,1,247,NULL,5,'Perc IIBB  Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(609,NULL,1,248,NULL,5,'Perc IIBB  Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(610,NULL,1,249,NULL,5,'Perc IIBB  Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(611,NULL,1,250,NULL,6,'Compras No Gravadas',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(612,NULL,1,276,NULL,6,'SIRCREB Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(613,NULL,1,277,NULL,6,'SIRCREB Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(614,NULL,1,278,NULL,6,'SIRCREB Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(615,NULL,1,279,NULL,6,'SIRCREB Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(616,NULL,1,280,NULL,6,'SIRCREB Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(617,NULL,1,281,NULL,6,'SIRCREB Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(618,NULL,1,282,NULL,6,'SIRCREB Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(619,NULL,1,283,NULL,6,'SIRCREB Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(620,NULL,1,284,NULL,6,'SIRCREB Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(621,NULL,1,285,NULL,6,'SIRCREB Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(622,NULL,1,286,NULL,6,'SIRCREB La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(623,NULL,1,287,NULL,6,'SIRCREB La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(624,NULL,1,288,NULL,6,'SIRCREB Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(625,NULL,1,289,NULL,6,'SIRCREB Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(626,NULL,1,290,NULL,6,'SIRCREB Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(627,NULL,1,291,NULL,6,'SIRCREB Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(628,NULL,1,292,NULL,6,'SIRCREB Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (629,NULL,1,293,NULL,6,'SIRCREB Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(630,NULL,1,294,NULL,6,'SIRCREB San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(631,NULL,1,295,NULL,6,'SIRCREB San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(632,NULL,1,296,NULL,6,'SIRCREB Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(633,NULL,1,297,NULL,6,'SIRCREB Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(634,NULL,1,298,NULL,6,'SIRCREB Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(635,NULL,1,299,NULL,6,'SIRCREB Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(636,NULL,1,300,NULL,6,'SIRCREB Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(637,NULL,1,301,NULL,8,'IIBB a Favor Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(638,NULL,1,302,NULL,8,'IIBB a Favor Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(639,NULL,1,303,NULL,8,'IIBB a Favor Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(640,NULL,1,304,NULL,8,'IIBB a Favor Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(641,NULL,1,305,NULL,8,'IIBB a Favor Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(642,NULL,1,306,NULL,8,'IIBB a Favor Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(643,NULL,1,307,NULL,8,'IIBB a Favor Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(644,NULL,1,308,NULL,8,'IIBB a Favor Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(645,NULL,1,309,NULL,8,'IIBB a Favor Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(646,NULL,1,310,NULL,8,'IIBB a Favor Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(647,NULL,1,311,NULL,8,'IIBB a Favor La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(648,NULL,1,312,NULL,8,'IIBB a Favor La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(649,NULL,1,313,NULL,8,'IIBB a Favor Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:08:51',NULL),(650,NULL,1,314,NULL,8,'IIBB a Favor Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(651,NULL,1,315,NULL,8,'IIBB a Favor Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(652,NULL,1,316,NULL,8,'IIBB a Favor Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(653,NULL,1,317,NULL,8,'IIBB a Favor Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(654,NULL,1,318,NULL,8,'IIBB a Favor Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(655,NULL,1,319,NULL,8,'IIBB a Favor San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(656,NULL,1,320,NULL,8,'IIBB a Favor San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(657,NULL,1,321,NULL,8,'IIBB a Favor Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(658,NULL,1,322,NULL,8,'IIBB a Favor Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(659,NULL,1,323,NULL,8,'IIBB a Favor Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(660,NULL,1,324,NULL,8,'IIBB a Favor Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(661,NULL,1,325,NULL,8,'IIBB a Favor Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(662,NULL,1,326,NULL,8,'IIBB a Pagar Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(663,NULL,1,327,NULL,8,'IIBB a Pagar Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (664,NULL,1,328,NULL,8,'IIBB a Pagar Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(665,NULL,1,329,NULL,8,'IIBB a Pagar Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(666,NULL,1,330,NULL,8,'IIBB a Pagar Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(667,NULL,1,331,NULL,8,'IIBB a Pagar Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(668,NULL,1,332,NULL,8,'IIBB a Pagar Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(669,NULL,1,333,NULL,8,'IIBB a Pagar Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(670,NULL,1,334,NULL,8,'IIBB a Pagar Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(671,NULL,1,335,NULL,8,'IIBB a Pagar Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(672,NULL,1,336,NULL,8,'IIBB a Pagar La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(673,NULL,1,337,NULL,8,'IIBB a Pagar La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(674,NULL,1,338,NULL,8,'IIBB a Pagar Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(675,NULL,1,339,NULL,8,'IIBB a Pagar Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(676,NULL,1,340,NULL,8,'IIBB a Pagar Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(677,NULL,1,341,NULL,8,'IIBB a Pagar Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(678,NULL,1,342,NULL,8,'IIBB a Pagar Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(679,NULL,1,343,NULL,8,'IIBB a Pagar Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(680,NULL,1,344,NULL,8,'IIBB a Pagar San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(681,NULL,1,345,NULL,8,'IIBB a Pagar San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(682,NULL,1,346,NULL,8,'IIBB a Pagar Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(683,NULL,1,347,NULL,8,'IIBB a Pagar Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(684,NULL,1,348,NULL,8,'IIBB a Pagar Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(685,NULL,1,349,NULL,8,'IIBB a Pagar Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(686,NULL,1,350,NULL,8,'IIBB a Pagar Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(687,NULL,1,352,NULL,8,'Compensacion',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(688,NULL,1,353,NULL,8,'IVA Saldo Tecnico',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(689,NULL,1,354,NULL,8,'IVA Saldo Libre Disponibilidad',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(690,NULL,1,361,NULL,8,'Equipos de Computación',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(691,NULL,1,362,NULL,8,'Computadoras',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(692,NULL,1,363,NULL,8,'Muebles y Utiles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(693,NULL,1,365,NULL,8,'Provision Honorarios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(694,NULL,1,366,NULL,8,'Cta. Cte Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(695,NULL,1,367,NULL,8,'Provisión Honorarios Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(696,NULL,1,368,NULL,8,'Cuenta Particular Socio 1',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(697,NULL,1,369,NULL,8,'Capital',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(698,NULL,1,380,NULL,8,'Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(699,NULL,1,381,NULL,8,'Reserva Legal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (700,NULL,1,382,NULL,8,'Reserva Legal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(701,NULL,1,383,NULL,8,'Resultado no asignado',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(702,NULL,1,386,NULL,8,'PLAZO FIJO',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(703,NULL,1,388,NULL,8,'ACCIONES',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(704,NULL,1,389,NULL,8,'Inmuebles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(705,NULL,1,390,NULL,8,'Vehiculos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(706,NULL,1,391,NULL,8,'Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(707,NULL,1,392,NULL,8,'MERCADERIAS',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:51',NULL),(708,NULL,1,393,NULL,8,'OTROS',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(709,NULL,1,395,NULL,8,'Cuenta Particular Socio 2',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(710,NULL,1,396,NULL,6,'Comisiones Y gastos Bancarios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(711,NULL,1,411,NULL,8,'Provisión Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(712,NULL,1,412,NULL,6,'Amortización Muebles y Útiles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(713,NULL,1,413,NULL,6,'Amortización Equipos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(714,NULL,1,414,NULL,8,'Amortizacion Acumulada Equipos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(715,NULL,1,415,NULL,8,'Amortización Acumulada Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(716,NULL,1,416,NULL,8,'Materias Primas',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(717,NULL,1,419,NULL,8,'Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(718,NULL,1,420,NULL,8,'Amortización Acumulada Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(719,NULL,1,421,NULL,8,'Amortización Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(720,NULL,1,422,NULL,8,'Amortización Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(721,NULL,1,423,NULL,8,'Accesorios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(722,NULL,1,424,NULL,8,'Amortización Acumulada Accesorios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(723,NULL,1,426,NULL,8,'Reserva Facultativa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(724,NULL,1,427,NULL,8,'Créditos por Impuestos Diferidos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(725,NULL,1,428,NULL,8,'Fondo de Comercio',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(726,NULL,1,429,NULL,8,'Amortizacion Acumulada Fondo de Comercio',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(727,NULL,1,430,NULL,8,'Intereses a devengar AGIP',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(728,NULL,1,431,NULL,8,'PFP IIBB',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(729,NULL,1,434,NULL,8,'Productos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(730,NULL,1,435,NULL,8,'Intereses a devengar PFP',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(731,NULL,1,437,NULL,8,'Imp. Ley 25413 Cred 0.6%',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(732,NULL,1,438,NULL,8,'Honorarios Directorio a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(733,NULL,1,439,NULL,8,'Reserva para Futuras Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(734,NULL,1,440,NULL,8,'TEAC - Trabajos Ejecutados a Certificar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (735,NULL,1,444,NULL,8,'Banco Santander Rio Cta Cte',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(736,NULL,1,449,NULL,8,'Leasing',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(737,NULL,1,453,NULL,8,'Inversión Central Caribe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(738,NULL,1,454,NULL,8,'Otras Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(739,NULL,1,455,NULL,8,'Otros Créditos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(740,NULL,1,456,NULL,8,'Provisión Honorarios Socio Gerente',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(741,NULL,1,459,NULL,8,'Moratoria SUSS a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(742,NULL,1,460,NULL,8,'Impuestos Municipales a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(743,NULL,1,461,NULL,6,'Amortización Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(744,NULL,1,462,NULL,8,'Amortización Equipos de comput.',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(745,NULL,1,463,NULL,8,'Cuenta Particular Socio 3',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(746,NULL,1,464,NULL,8,'Cuenta Particular Socio 4',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(747,NULL,1,465,NULL,8,'Otras Reservas',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(748,NULL,1,466,NULL,8,'IGMP (Saldo a Favor)',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(749,NULL,1,468,NULL,8,'Productos en Proceso',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(750,NULL,1,469,NULL,8,'Depósitos en Garantía Socio Gerente',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(751,NULL,1,470,NULL,8,'Fondos Embargados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(752,NULL,1,471,NULL,8,'Cuota Solid.',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(753,NULL,1,472,NULL,8,'Anticipo Honorarios Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(754,NULL,1,473,NULL,8,'SICORE a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(755,NULL,1,476,NULL,6,'RECPAM',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL),(756,NULL,1,478,NULL,6,'CO2 - Imp. Al Carbono',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:08:52',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_detail` VALUES (3,7777,2,57,40719,11,1,1310.90,0,'2022-09-08','2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(4,7777,2,359,40719,11,2,1310.90,0,'2022-09-08','2022-09-08 11:50:13','2022-09-08 11:50:13',NULL),(5,7777,3,13,40719,12,2,10000.00,0,'2022-10-07','2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(6,7777,3,359,40719,12,1,10000.00,0,'2022-10-07','2022-10-07 15:07:25','2022-10-07 15:07:25',NULL),(7,7777,4,13,40719,1661,2,363000.00,0,'2021-12-31','2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(8,7777,4,359,40719,1661,1,363000.00,0,'2021-12-31','2022-10-07 15:13:38','2022-10-07 15:13:38',NULL),(9,7777,5,13,40719,1661,2,180048.00,0,'2021-12-31','2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(10,7777,5,359,40719,1661,1,180048.00,0,'2021-12-31','2022-10-07 15:17:04','2022-10-07 15:17:04',NULL),(11,7777,6,13,40719,1661,2,254100.00,0,'2021-12-31','2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(12,7777,6,359,40719,1661,1,254100.00,0,'2021-12-31','2022-10-07 15:24:33','2022-10-07 15:24:33',NULL),(13,7777,7,13,40719,1661,2,163350.00,0,'2021-12-31','2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(14,7777,7,359,40719,1661,1,163350.00,0,'2021-12-31','2022-10-07 15:29:06','2022-10-07 15:29:06',NULL),(19,7777,10,57,40719,12,1,24200.00,0,'2022-10-07','2022-10-07 15:50:03','2022-10-07 15:50:03',NULL),(20,7777,10,359,40719,12,2,24200.00,0,'2022-10-07','2022-10-07 15:50:03','2022-10-07 15:50:03',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `is_no_a_la_orden` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'BORRADOR',1,NULL,'2023-08-06 23:58:20',NULL),(2,NULL,'TERMINADO',1,NULL,'2023-08-06 23:58:20',NULL),(3,NULL,'ELIMINADO',1,NULL,'2023-08-13 09:17:31',NULL),(4,NULL,'PAGADO',1,NULL,'2023-08-06 23:58:20','2023-08-06 23:58:20'),(5,NULL,'CONCILIADO',1,NULL,'2023-08-06 23:58:20','2023-08-06 23:58:20');
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas`
--

DROP TABLE IF EXISTS `dc_firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_firmante_dc` tinyint(1) NOT NULL DEFAULT '0',
  `show_create_dc` tinyint(1) NOT NULL DEFAULT '0',
  `faltan_firmas` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas`
--

LOCK TABLES `dc_firmas` WRITE;
/*!40000 ALTER TABLE `dc_firmas` DISABLE KEYS */;
INSERT INTO `dc_firmas` VALUES (1,NULL,'NO',1,1,0,1,NULL,'2023-08-06 23:58:21',NULL),(2,NULL,'RECHAZADO',1,1,0,1,NULL,'2023-08-06 23:58:21',NULL),(3,NULL,'ACEPTADO',1,0,0,1,NULL,'2023-08-06 23:58:21',NULL),(4,NULL,'FALTAN FIRMAS',0,0,1,1,'2023-08-06 23:58:20','2023-08-06 23:58:21',NULL);
/*!40000 ALTER TABLE `dc_firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_ordenes`
--

DROP TABLE IF EXISTS `dc_firmas_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `user_id_que_firma` int(10) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_firmas_ordenes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_firmas_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_firmas_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_firmas_ordenes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_ordenes`
--

LOCK TABLES `dc_firmas_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_firmas_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_reglas`
--

DROP TABLE IF EXISTS `dc_firmas_reglas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_reglas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL,
  `grupos_users_ids` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_reglas_person_id_foreign` (`person_id`),
  KEY `dc_firmas_reglas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_firmas_reglas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_reglas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_reglas`
--

LOCK TABLES `dc_firmas_reglas` WRITE;
/*!40000 ALTER TABLE `dc_firmas_reglas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_reglas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_files`
--

DROP TABLE IF EXISTS `dc_orden_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_files_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_orden_files_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_files`
--

LOCK TABLES `dc_orden_files` WRITE;
/*!40000 ALTER TABLE `dc_orden_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `sucursal` int(11) NOT NULL DEFAULT '1',
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '1.00',
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `is_multiples_ot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `is_completado` tinyint(1) NOT NULL DEFAULT '0',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  KEY `dc_ordenes_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `dc_ordenes_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_moneda_id_foreign` (`moneda_id`),
  KEY `dc_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `dc_ordenes_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_req`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_req`
--

LOCK TABLES `dc_ordenes_compra_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id_destino` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  KEY `dc_ordenes_details_inv_producto_id_destino_foreign` (`inv_producto_id_destino`),
  KEY `dc_ordenes_details_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_destino_foreign` FOREIGN KEY (`inv_producto_id_destino`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_facturada`
--

DROP TABLE IF EXISTS `dc_ordenes_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_facturada_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_facturada_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `dc_ordenes_facturada_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `dc_ordenes_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_facturada`
--

LOCK TABLES `dc_ordenes_facturada` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingreso_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_ingreso_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingreso_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingreso_compra`
--

LOCK TABLES `dc_ordenes_ingreso_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_origen_destino`
--

DROP TABLE IF EXISTS `dc_ordenes_origen_destino`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_origen_destino` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_origen_destino`
--

LOCK TABLES `dc_ordenes_origen_destino` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` DISABLE KEYS */;
INSERT INTO `dc_ordenes_origen_destino` VALUES (1,NULL,'Orden de Trabajo','App\\Models\\Inventario\\InvOrdenTrabajo',1,NULL,NULL,NULL),(2,NULL,'Centro de Costos','App\\Models\\Inventario\\InvOrdenTrabajoHorasTipo',1,NULL,'2023-09-12 22:19:42',NULL),(3,NULL,'Deposito','App\\Models\\Inventario\\InvDeposito',0,NULL,'2023-07-03 22:09:26',NULL),(4,NULL,'Empleado','App\\Models\\SyJEmpleado',0,NULL,'2023-07-03 22:09:26',NULL);
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_servicio_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_servicio_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_servicio_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_servicio_compra`
--

LOCK TABLES `dc_ordenes_servicio_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `usabilidad` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'ORDEN DE COMPRAS',NULL,1,NULL,'2022-09-09 16:52:37',NULL),(2,NULL,'ORDEN DE VENTAS',NULL,1,NULL,'2022-09-09 16:52:37',NULL),(3,NULL,'PRESUPUESTO',NULL,1,NULL,NULL,NULL),(4,NULL,'REQUERIMIENTO',NULL,1,NULL,NULL,NULL),(5,NULL,'REMITO DE INGRESO',NULL,1,NULL,'2023-06-12 23:28:15',NULL),(6,NULL,'REMITO DE EGRESO',NULL,1,NULL,NULL,NULL),(7,NULL,'REMITO INTERNO',NULL,1,NULL,NULL,NULL),(8,NULL,'REMITO DE INGRESO','Es lo mismo que un remito de ingreso, \n        pero los productosa ingresar provienen de una Orden de Compra',1,NULL,NULL,NULL),(9,NULL,'REMITO DE SERVICIO','Es un remito de Ingreso de un servicio que se\n        asigna directo a una OT',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` int(10) unsigned NOT NULL,
  `other_tax_id` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_other_tax_id_foreign` (`other_tax_id`),
  CONSTRAINT `fact_elec_perc_ret_other_tax_id_foreign` FOREIGN KEY (`other_tax_id`) REFERENCES `other_taxes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret`
--

LOCK TABLES `fact_elec_perc_ret` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret` DISABLE KEYS */;
INSERT INTO `fact_elec_perc_ret` VALUES (1,NULL,'Per./Ret de Imp. a las Ganancias',1,1032,1,NULL,NULL,NULL),(2,NULL,'Per./Ret de IVA',1,1000,1,NULL,NULL,NULL),(3,NULL,'Per./Ret de IIBB',2,1006,1,NULL,NULL,NULL),(4,NULL,'Impuestos Internos',4,1001,1,NULL,NULL,NULL),(5,NULL,'Impuestos Municipales',3,1031,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `fact_elec_perc_ret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret_details`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_perc_ret_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `detalle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(10) unsigned DEFAULT NULL,
  `base_imponible` decimal(16,2) DEFAULT NULL,
  `alicuota` decimal(16,2) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` (`fact_elec_perc_ret_id`),
  KEY `fact_elec_perc_ret_details_person_id_foreign` (`person_id`),
  KEY `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_perc_ret_details_zone_id_foreign` (`zone_id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` FOREIGN KEY (`fact_elec_perc_ret_id`) REFERENCES `fact_elec_perc_ret` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret_details`
--

LOCK TABLES `fact_elec_perc_ret_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `referencia` text COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_otros_tributos` decimal(16,2) DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fact_elec_receipts_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq`
--

DROP TABLE IF EXISTS `faq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pregunta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `respuesta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq`
--

LOCK TABLES `faq` WRITE;
/*!40000 ALTER TABLE `faq` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_upload_details`
--

DROP TABLE IF EXISTS `file_upload_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_upload_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_upload_id` int(10) unsigned NOT NULL,
  `detail` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_upload_details_file_upload_id_foreign` (`file_upload_id`),
  CONSTRAINT `file_upload_details_file_upload_id_foreign` FOREIGN KEY (`file_upload_id`) REFERENCES `file_uploads` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_upload_details`
--

LOCK TABLES `file_upload_details` WRITE;
/*!40000 ALTER TABLE `file_upload_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_upload_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_uploads`
--

DROP TABLE IF EXISTS `file_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_type_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_uploads_data_type_id_foreign` (`data_type_id`),
  KEY `file_uploads_user_id_foreign` (`user_id`),
  KEY `file_uploads_person_id_foreign` (`person_id`),
  KEY `file_uploads_period_id_foreign` (`period_id`),
  CONSTRAINT `file_uploads_data_type_id_foreign` FOREIGN KEY (`data_type_id`) REFERENCES `data_types` (`id`),
  CONSTRAINT `file_uploads_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `file_uploads_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `file_uploads_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tusers` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_uploads`
--

LOCK TABLES `file_uploads` WRITE;
/*!40000 ALTER TABLE `file_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_art_90`
--

DROP TABLE IF EXISTS `ganan_art_90`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_art_90` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_art_90`
--

LOCK TABLES `ganan_art_90` WRITE;
/*!40000 ALTER TABLE `ganan_art_90` DISABLE KEYS */;
INSERT INTO `ganan_art_90` VALUES (1,2017,0.00,20000.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,2017,20000.00,40000.00,1000.00,0.09,20000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,2017,40000.00,60000.00,2800.00,0.12,40000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,2017,60000.00,80000.00,5200.00,0.15,60000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,2017,80000.00,120000.00,8200.00,0.19,80000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,2017,120000.00,160000.00,15800.00,0.23,120000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,2017,160000.00,240000.00,25000.00,0.27,160000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,2017,240000.00,320000.00,46600.00,0.31,240000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,2017,320000.00,999999999.99,71400.00,0.35,320000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,2018,0.00,25754.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,2018,25754.00,51508.00,1287.70,0.09,25754.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,2018,51508.00,77262.00,3605.56,0.12,51508.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,2018,77262.00,103016.00,6696.04,0.15,77262.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,2018,103016.00,154524.00,10559.14,0.19,103016.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(15,2018,154524.00,206032.00,20345.66,0.23,154524.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(16,2018,206032.00,309048.00,32192.50,0.27,206032.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(17,2018,309048.00,412064.00,60006.82,0.31,309048.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(18,2018,412064.00,999999999.99,91941.78,0.35,412064.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(19,2019,0.00,33039.81,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(20,2019,33039.81,66079.61,1651.99,0.09,33039.81,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(21,2019,66079.61,99119.42,4625.57,0.12,66079.61,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(22,2019,99119.42,132159.23,8590.35,0.15,99119.42,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(23,2019,132159.23,198238.84,13546.32,0.19,132159.23,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(24,2019,198238.84,264318.45,26101.45,0.23,198238.84,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(25,2019,264318.45,396477.68,41299.76,0.27,264318.45,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(26,2019,396477.68,528636.91,76982.75,0.31,396477.68,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(27,2019,528636.91,999999999.99,117952.11,0.35,528636.91,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(28,2016,0.00,10000.00,0.00,0.09,0.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(29,2016,10000.00,20000.00,900.00,0.14,10000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(30,2016,20000.00,30000.00,2300.00,0.19,20000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(31,2016,30000.00,60000.00,4200.00,0.23,30000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(32,2016,60000.00,90000.00,11100.00,0.27,60000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(33,2016,90000.00,120000.00,19200.00,0.31,90000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(34,2016,120000.00,999999999.00,28500.00,0.35,120000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(37,2020,0.00,47669.16,0.00,0.05,0.00,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(38,2020,47669.16,95338.32,2383.46,0.09,47669.16,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(39,2020,95338.32,143007.48,6673.68,0.12,95338.32,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(40,2020,143007.48,190676.65,12393.98,0.15,143007.48,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(41,2020,190676.65,286014.96,19544.36,0.19,190676.65,'2020-01-28 14:17:39','2022-09-05 16:45:16',NULL),(42,2020,286014.96,381353.28,37658.64,0.23,286014.96,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_art_90` VALUES (43,2020,381353.28,572029.92,59586.45,0.27,381353.28,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(44,2020,572029.92,762706.57,111069.14,0.31,572029.92,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(45,2020,762706.57,999999999.99,170178.90,0.35,762706.57,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(46,2021,0.00,64532.64,0.00,0.05,0.00,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(47,2021,64532.64,129065.29,3226.63,0.09,64532.64,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(48,2021,129065.29,193597.93,9034.57,0.12,129065.29,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(49,2021,193597.93,258130.58,16778.49,0.15,193597.93,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(50,2021,258130.58,387195.86,26458.39,0.19,258130.58,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(51,2021,387195.86,516261.14,50980.79,0.23,387195.86,'2022-09-05 16:45:17','2022-09-05 16:45:33',NULL),(52,2021,516261.14,774391.71,80665.80,0.27,516261.14,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(53,2021,774391.71,1032522.30,150361.06,0.31,774391.71,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(54,2021,1032522.30,999999999.99,230381.54,0.35,1032522.30,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(55,2022,0.00,97201.99,0.00,0.05,0.00,'2022-09-05 16:45:24','2022-09-05 16:45:25',NULL),(56,2022,97201.99,194404.01,4860.10,0.09,97201.99,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(57,2022,194404.01,291606.01,13608.29,0.12,194404.01,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(58,2022,291606.01,388808.02,25272.52,0.15,291606.01,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(59,2022,388808.02,583212.02,39852.82,0.19,388808.02,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(60,2022,583212.02,777616.02,76789.59,0.23,583212.02,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(61,2022,777616.02,1166424.03,121502.49,0.27,777616.02,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(62,2022,1166424.03,1555232.07,226480.67,0.31,1166424.03,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(63,2022,1555232.07,999999999.99,347011.15,0.35,1555232.07,'2022-09-05 16:45:24','2023-06-27 10:54:09',NULL),(64,2023,0.00,173834.61,0.00,0.05,0.00,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(65,2023,173834.61,347669.23,8691.73,0.09,173834.61,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(66,2023,347669.23,521503.84,24336.85,0.12,347669.23,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(67,2023,521503.84,695338.47,45197.00,0.15,521503.84,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(68,2023,695338.47,1043007.68,71272.19,0.19,695338.47,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(69,2023,1043007.68,1390676.90,137329.34,0.23,1043007.68,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(70,2023,1390676.90,2086015.35,217293.26,0.27,1390676.90,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(71,2023,2086015.35,2781353.85,405034.64,0.31,2086015.35,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(72,2023,2781353.85,999999999.99,620589.58,0.35,2781353.85,'2022-12-28 17:48:10','2023-06-27 10:54:09',NULL);
/*!40000 ALTER TABLE `ganan_art_90` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_categorias`
--

DROP TABLE IF EXISTS `ganan_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_categorias`
--

LOCK TABLES `ganan_categorias` WRITE;
/*!40000 ALTER TABLE `ganan_categorias` DISABLE KEYS */;
INSERT INTO `ganan_categorias` VALUES (1,'Primera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,'Segunda',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(3,'Tercera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(4,'Cuarta',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_conceptos_anticipos`
--

DROP TABLE IF EXISTS `ganan_conceptos_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_conceptos_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ganan_conceptos_anticipos_nombre_unique` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_conceptos_anticipos`
--

LOCK TABLES `ganan_conceptos_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` DISABLE KEYS */;
INSERT INTO `ganan_conceptos_anticipos` VALUES (1,NULL,'Anticipos',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,'Retenciones y Percepciones',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,'Saldo a Favor Anterior',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL);
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_anticipos`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_anticipos`
--

LOCK TABLES `ganan_ddjj_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_deducciones`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_deduccion_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_deducciones_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` (`ganan_deduccion_id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` FOREIGN KEY (`ganan_deduccion_id`) REFERENCES `ganan_deducciones` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_deducciones`
--

LOCK TABLES `ganan_ddjj_detail_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_ing_egr`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_ing_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_ing_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `ganan_categoria_id` int(10) unsigned NOT NULL,
  `ganan_tipo_op_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_ing_egr_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` (`ganan_categoria_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` (`ganan_tipo_op_id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` FOREIGN KEY (`ganan_categoria_id`) REFERENCES `ganan_categorias` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` FOREIGN KEY (`ganan_tipo_op_id`) REFERENCES `ganan_tipos_op` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_ing_egr`
--

LOCK TABLES `ganan_ddjj_detail_ing_egr` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjjs`
--

DROP TABLE IF EXISTS `ganan_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ingresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `ingresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deducciones_total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `ganan_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjjs`
--

LOCK TABLES `ganan_ddjjs` WRITE;
/*!40000 ALTER TABLE `ganan_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_deducciones`
--

DROP TABLE IF EXISTS `ganan_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `generales` tinyint(1) NOT NULL DEFAULT '0',
  `particulares` tinyint(1) NOT NULL DEFAULT '0',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_deducciones`
--

LOCK TABLES `ganan_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_deducciones` DISABLE KEYS */;
INSERT INTO `ganan_deducciones` VALUES (1,NULL,2017,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,2017,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,2017,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,NULL,2017,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,NULL,2017,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,NULL,2017,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,NULL,2017,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,NULL,2017,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,NULL,2017,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,NULL,2017,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,NULL,2017,1,0,'Servicio Doméstico',51967.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,NULL,2017,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,NULL,2017,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,NULL,2017,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(15,NULL,2017,0,1,'Conyuge',48447.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(16,NULL,2017,0,1,'Hijo Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(17,NULL,2017,0,1,'Hijo Menor 18 años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(18,NULL,2017,0,1,'Hijastro Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(19,NULL,2017,0,1,'Hijastro Menor 18 Años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(20,NULL,2017,0,1,'Ganancia No Imponible',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(21,NULL,2017,0,1,'Deduccion Especial',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(22,NULL,2018,1,0,'Primas de seguro para el caso de muerte',12000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(23,NULL,2018,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(24,NULL,2018,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(25,NULL,2018,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(26,NULL,2018,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(27,NULL,2018,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(28,NULL,2018,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(29,NULL,2018,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(30,NULL,2018,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (31,NULL,2018,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(32,NULL,2018,1,0,'Servicio Doméstico',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(33,NULL,2018,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(34,NULL,2018,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(35,NULL,2018,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(36,NULL,2018,0,1,'Conyuge',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(37,NULL,2018,0,1,'Hijo Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(38,NULL,2018,0,1,'Hijo Menor 18 años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(39,NULL,2018,0,1,'Hijastro Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(40,NULL,2018,0,1,'Hijastro Menor 18 Años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(41,NULL,2018,0,1,'Ganancia No Imponible',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(42,NULL,2018,0,1,'Deduccion Especial',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(43,NULL,2019,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(44,NULL,2019,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(45,NULL,2019,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(46,NULL,2019,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(47,NULL,2019,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(48,NULL,2019,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(49,NULL,2019,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(50,NULL,2019,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(51,NULL,2019,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(52,NULL,2019,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(53,NULL,2019,1,0,'Servicio Doméstico',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(54,NULL,2019,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(55,NULL,2019,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(56,NULL,2019,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(57,NULL,2019,0,1,'Conyuge',80033.97,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(58,NULL,2019,0,1,'Hijo Incapacitado',40361.43,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(59,NULL,2019,0,1,'Hijo Menor 18 años',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(60,NULL,2019,0,1,'Hijastro Incapacitado',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(61,NULL,2019,0,1,'Hijastro Menor 18 Años',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(62,NULL,2019,0,1,'Ganancia No Imponible',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(63,NULL,2019,0,1,'Deduccion Especial',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (64,NULL,2016,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(65,NULL,2016,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(66,NULL,2016,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(67,NULL,2016,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(68,NULL,2016,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(69,NULL,2016,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(70,NULL,2016,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(71,NULL,2016,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(72,NULL,2016,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(73,NULL,2016,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(74,NULL,2016,1,0,'Servicio Doméstico',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(75,NULL,2016,1,0,'Donaciones',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(76,NULL,2016,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(77,NULL,2016,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y \n            Paramédica',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(78,NULL,2016,0,1,'Conyuge',39778.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(79,NULL,2016,0,1,'Hijo Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(80,NULL,2016,0,1,'Hijo Menor 18 años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(81,NULL,2016,0,1,'Hijastro Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(82,NULL,2016,0,1,'Hijastro Menor 18 Años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(83,NULL,2016,0,1,'Ganancia No Imponible',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(84,NULL,2016,0,1,'Deduccion Especial',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(85,NULL,2019,1,0,'Alquileres',103018.97,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(86,NULL,2020,1,0,'Alquileres',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(87,NULL,2020,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(88,NULL,2020,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(89,NULL,2020,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(90,NULL,2020,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(91,NULL,2020,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(92,NULL,2020,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(93,NULL,2020,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_deducciones` VALUES (94,NULL,2020,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(95,NULL,2020,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(96,NULL,2020,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(97,NULL,2020,1,0,'Servicio Doméstico',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(98,NULL,2020,1,0,'Donaciones',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(99,NULL,2020,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(100,NULL,2020,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(101,NULL,2020,0,1,'Conyuge',115471.38,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(102,NULL,2020,0,1,'Hijo Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(103,NULL,2020,0,1,'Hijo Menor 18 años',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(104,NULL,2020,0,1,'Hijastro Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(105,NULL,2020,0,1,'Hijastro Menor 18 Años',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(106,NULL,2020,0,1,'Ganancia No Imponible',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(107,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1',103018.79,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(108,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1 \"Nuevos Profesionales / Emprendedores',309652.93,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(109,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 2',594533.62,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(110,NULL,2021,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(111,NULL,2021,1,0,'Gastos de Sepelio',996.23,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(112,NULL,2021,1,0,'Aportes a Obras Sociales',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(113,NULL,2021,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(114,NULL,2021,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(115,NULL,2021,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(116,NULL,2021,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(117,NULL,2021,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(118,NULL,2021,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(119,NULL,2021,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(120,NULL,2021,1,0,'Servicio Doméstico',167678.40,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(121,NULL,2021,1,0,'Donaciones',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(122,NULL,2021,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(123,NULL,2021,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(124,NULL,2021,0,1,'Conyuge',156320.63,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(125,NULL,2021,0,1,'Hijo Menor 18 años',78833.08,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL);
INSERT INTO `ganan_deducciones` VALUES (126,NULL,2021,0,1,'Ganancia No Imponible',167678.40,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(127,NULL,2021,0,1,'Deduccion Especial',804856.34,1,'2022-09-05 16:45:17','2022-09-05 16:45:17',NULL),(128,NULL,2022,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(129,NULL,2022,1,0,'Gastos de Sepelio',996.23,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(130,NULL,2022,1,0,'Aportes a Obras Sociales',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(131,NULL,2022,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(132,NULL,2022,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(133,NULL,2022,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(134,NULL,2022,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(135,NULL,2022,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(136,NULL,2022,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(137,NULL,2022,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(138,NULL,2022,1,0,'Servicio Doméstico',252564.84,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(139,NULL,2022,1,0,'Donaciones',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(140,NULL,2022,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(141,NULL,2022,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(142,NULL,2022,1,0,'Alquileres',252564.84,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(143,NULL,2022,0,1,'Conyuge',235457.25,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(144,NULL,2022,0,1,'Hijo Menor 18 años',118741.97,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(145,NULL,2022,0,1,'Ganancia No Imponible',252564.84,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(146,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',1212311.24,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(147,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',505129.68,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(148,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',631412.10,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(149,NULL,2022,0,1,'Hijo Incapacitado',237483.94,1,'2022-09-05 16:45:24','2022-09-05 16:45:24',NULL),(150,NULL,2021,1,0,'Alquileres',167678.40,1,NULL,NULL,NULL),(151,NULL,2023,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(152,NULL,2023,1,0,'Aportes a Obras Sociales',0.00,1,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(153,NULL,2023,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(154,NULL,2023,1,0,'Gastos de Sepelio',996.23,1,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(155,NULL,2023,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL);
INSERT INTO `ganan_deducciones` VALUES (156,NULL,2023,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(157,NULL,2023,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(158,NULL,2023,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-12-28 17:48:10','2022-12-28 17:48:10',NULL),(159,NULL,2023,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(160,NULL,2023,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(161,NULL,2023,1,0,'Servicio Doméstico',451686.96,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(162,NULL,2023,1,0,'Donaciones',0.00,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(163,NULL,2023,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(164,NULL,2023,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(165,NULL,2023,1,0,'Alquileres',451686.96,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(166,NULL,2023,0,1,'Ganancia No Imponible',451686.96,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(167,NULL,2023,0,1,'Conyuge',421091.75,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(168,NULL,2023,0,1,'Hijo Menor 18 años',212358.14,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(169,NULL,2023,0,1,'Hijo Incapacitado',424716.28,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(170,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',1580904.36,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(171,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',1806747.84,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL),(172,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',2168097.42,1,'2022-12-28 17:48:11','2022-12-28 17:48:11',NULL);
/*!40000 ALTER TABLE `ganan_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_tipos_op`
--

DROP TABLE IF EXISTS `ganan_tipos_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_tipos_op` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_tipos_op`
--

LOCK TABLES `ganan_tipos_op` WRITE;
/*!40000 ALTER TABLE `ganan_tipos_op` DISABLE KEYS */;
INSERT INTO `ganan_tipos_op` VALUES (1,NULL,'Gravado',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,NULL,'Exento',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_tipos_op` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iibb_perceptions`
--

DROP TABLE IF EXISTS `iibb_perceptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iibb_perceptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iibb_perceptions`
--

LOCK TABLES `iibb_perceptions` WRITE;
/*!40000 ALTER TABLE `iibb_perceptions` DISABLE KEYS */;
INSERT INTO `iibb_perceptions` VALUES (1,NULL,NULL,NULL,'IIBB CABA','IIBBCABA'),(2,NULL,NULL,NULL,'IIBB Bs. As.','IIBBBSAS'),(3,NULL,NULL,NULL,'Percepcion IIBB Tucuman','IIBBTucuman'),(4,NULL,NULL,NULL,'Perc IIBB Misiones','IIBBMisiones'),(5,NULL,NULL,NULL,'Perc IIBB Cordoba','IIBBCba'),(6,NULL,NULL,NULL,'Pec IIBB La Pampa','IIBB La Pampa'),(7,NULL,NULL,NULL,'Perc IIBB Rio Negro','IIBB Rio Negro'),(8,NULL,NULL,NULL,'Perc IIBB Corrientes','IIIBB Corrientes'),(9,NULL,NULL,NULL,'Perc IIBB Santiago del Estero','IIBBSantiago');
/*!40000 ALTER TABLE `iibb_perceptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_combos`
--

DROP TABLE IF EXISTS `inv_combos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_combos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inv_product_combo_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `cantidades` int(11) NOT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_combos_inv_product_combo_id_foreign` (`inv_product_combo_id`),
  KEY `inv_combos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_combos_inv_product_combo_id_foreign` FOREIGN KEY (`inv_product_combo_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_combos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_combos`
--

LOCK TABLES `inv_combos` WRITE;
/*!40000 ALTER TABLE `inv_combos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_combos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock`
--

DROP TABLE IF EXISTS `inv_control_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_control_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock`
--

LOCK TABLES `inv_control_stock` WRITE;
/*!40000 ALTER TABLE `inv_control_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock_detail`
--

DROP TABLE IF EXISTS `inv_control_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_control_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `stock_actual` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_real` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_control_stock_detail_inv_control_stock_id_foreign` (`inv_control_stock_id`),
  KEY `inv_control_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_control_stock_detail_inv_control_stock_id_foreign` FOREIGN KEY (`inv_control_stock_id`) REFERENCES `inv_control_stock` (`id`),
  CONSTRAINT `inv_control_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_control_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock_detail`
--

LOCK TABLES `inv_control_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_control_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_depositos`
--

DROP TABLE IF EXISTS `inv_depositos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_depositos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_depositos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_depositos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_depositos`
--

LOCK TABLES `inv_depositos` WRITE;
/*!40000 ALTER TABLE `inv_depositos` DISABLE KEYS */;
INSERT INTO `inv_depositos` VALUES (1,NULL,40719,'Deposito 1',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_depositos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_descarga_details`
--

DROP TABLE IF EXISTS `inv_descarga_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_descarga_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_descarga_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_descarga_details_person_id_foreign` (`person_id`),
  KEY `inv_descarga_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `inv_descarga_details_inv_descarga_id_foreign` (`inv_descarga_id`),
  CONSTRAINT `inv_descarga_details_inv_descarga_id_foreign` FOREIGN KEY (`inv_descarga_id`) REFERENCES `inv_descargas` (`id`),
  CONSTRAINT `inv_descarga_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_descarga_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_descarga_details`
--

LOCK TABLES `inv_descarga_details` WRITE;
/*!40000 ALTER TABLE `inv_descarga_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_descarga_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_descargas`
--

DROP TABLE IF EXISTS `inv_descargas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_descargas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `fecha` datetime NOT NULL DEFAULT '2023-03-15 23:47:53',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_descargas_person_id_foreign` (`person_id`),
  KEY `inv_descargas_inv_orden_trabajo_gastos_tipo_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_descargas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_descargas_inv_orden_trabajo_gastos_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_descargas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_descargas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_descargas`
--

LOCK TABLES `inv_descargas` WRITE;
/*!40000 ALTER TABLE `inv_descargas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_descargas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores`
--

DROP TABLE IF EXISTS `inv_indicadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orden` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores`
--

LOCK TABLES `inv_indicadores` WRITE;
/*!40000 ALTER TABLE `inv_indicadores` DISABLE KEYS */;
INSERT INTO `inv_indicadores` VALUES (1,NULL,'Datos Grales','datos_grales','card_info',5,1,NULL,'2022-09-05 16:45:32',NULL),(2,NULL,'Impuestos Asociados','impuestos_asociados','card_info',6,1,NULL,'2022-09-05 16:45:32',NULL),(3,NULL,'Informacion de Liquidacion','informacion_de_liquidacion','card_info',7,1,NULL,'2022-09-05 16:45:32',NULL),(4,NULL,'Cantidad Ventas del Mes','cantidad_ventas_del_mes','card',1,1,NULL,'2022-09-05 16:45:32',NULL),(5,NULL,'Total Facturado En El Mes','total_facturado_en_el_mes','card',2,1,NULL,'2022-09-05 16:45:32',NULL),(6,NULL,'Total Facturado En El Dia','total_facturado_en_el_dia','card',3,1,NULL,'2022-09-05 16:45:32',NULL),(7,NULL,'Total Facturado En El Año','total_facturado_en_el_anio','card',4,1,NULL,'2022-09-05 16:45:32',NULL),(8,NULL,'Facturacion Mensual','facturacion_mensual','grafico',8,1,NULL,'2022-09-05 16:45:32',NULL),(9,NULL,'Proyeccion de Ganancias','proyeccion_de_ganancias','tabla',9,1,NULL,'2022-09-05 16:45:32',NULL),(10,NULL,'Posicion IVA','posicion_de_iva','tabla',10,1,NULL,'2022-09-05 16:45:32',NULL);
/*!40000 ALTER TABLE `inv_indicadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores_persons`
--

DROP TABLE IF EXISTS `inv_indicadores_persons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores_persons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_indicador_id` bigint(20) unsigned NOT NULL,
  `objetivo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_indicadores_persons_person_id_foreign` (`person_id`),
  KEY `inv_indicadores_persons_inv_indicador_id_foreign` (`inv_indicador_id`),
  CONSTRAINT `inv_indicadores_persons_inv_indicador_id_foreign` FOREIGN KEY (`inv_indicador_id`) REFERENCES `inv_indicadores` (`id`),
  CONSTRAINT `inv_indicadores_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores_persons`
--

LOCK TABLES `inv_indicadores_persons` WRITE;
/*!40000 ALTER TABLE `inv_indicadores_persons` DISABLE KEYS */;
INSERT INTO `inv_indicadores_persons` VALUES (1,NULL,40719,4,0.00,NULL,'2022-10-07 10:53:11','2022-10-07 10:53:11'),(2,NULL,40719,4,0.00,NULL,'2022-10-07 10:53:24','2022-10-07 10:53:24'),(3,NULL,40719,5,0.00,NULL,'2022-10-07 10:53:24','2022-10-07 10:53:24'),(4,NULL,40719,2,0.00,NULL,'2022-10-07 10:53:45','2022-10-07 10:53:45'),(5,NULL,40719,4,0.00,NULL,'2022-10-07 10:53:45','2022-10-07 10:53:45'),(6,NULL,40719,5,0.00,NULL,'2022-10-07 10:53:45','2022-10-07 10:53:45'),(7,NULL,40719,2,0.00,NULL,'2022-10-07 10:53:59','2022-10-07 10:53:59'),(8,NULL,40719,4,0.00,NULL,'2022-10-07 10:53:59','2022-10-07 10:53:59'),(9,NULL,40719,5,0.00,NULL,'2022-10-07 10:53:59','2022-10-07 10:53:59'),(10,NULL,40719,8,0.00,NULL,'2022-10-07 10:53:59','2022-10-07 10:53:59'),(11,NULL,40719,2,0.00,NULL,'2022-10-07 11:07:06','2022-10-07 11:07:06'),(12,NULL,40719,4,0.00,NULL,'2022-10-07 11:07:06','2022-10-07 11:07:06'),(13,NULL,40719,5,0.00,NULL,'2022-10-07 11:07:06','2022-10-07 11:07:06'),(14,NULL,40719,8,0.00,NULL,'2022-10-07 11:07:06','2022-10-07 11:07:06'),(15,NULL,40719,10,0.00,NULL,'2022-10-07 11:07:06','2022-10-07 11:07:06'),(16,NULL,40719,2,0.00,NULL,'2022-10-07 11:07:11','2022-10-07 11:07:11'),(17,NULL,40719,5,0.00,NULL,'2022-10-07 11:07:11','2022-10-07 11:07:11'),(18,NULL,40719,8,0.00,NULL,'2022-10-07 11:07:11','2022-10-07 11:07:11'),(19,NULL,40719,10,0.00,NULL,'2022-10-07 11:07:11','2022-10-07 11:07:11'),(20,NULL,40719,2,0.00,NULL,'2022-10-07 11:07:21','2022-10-07 11:07:21'),(21,NULL,40719,8,0.00,NULL,'2022-10-07 11:07:21','2022-10-07 11:07:21'),(22,NULL,40719,10,0.00,NULL,'2022-10-07 11:07:21','2022-10-07 11:07:21'),(23,NULL,40719,2,0.00,NULL,'2022-10-07 11:07:28','2022-10-07 11:07:28'),(24,NULL,40719,4,0.00,NULL,'2022-10-07 11:07:28','2022-10-07 11:07:28'),(25,NULL,40719,8,0.00,NULL,'2022-10-07 11:07:28','2022-10-07 11:07:28'),(26,NULL,40719,10,0.00,NULL,'2022-10-07 11:07:28','2022-10-07 11:07:28'),(27,NULL,40719,2,0.00,NULL,'2022-10-07 11:07:30','2022-10-07 11:07:30'),(28,NULL,40719,4,0.00,NULL,'2022-10-07 11:07:30','2022-10-07 11:07:30'),(29,NULL,40719,6,0.00,NULL,'2022-10-07 11:07:30','2022-10-07 11:07:30'),(30,NULL,40719,8,0.00,NULL,'2022-10-07 11:07:30','2022-10-07 11:07:30'),(31,NULL,40719,10,0.00,NULL,'2022-10-07 11:07:30','2022-10-07 11:07:30'),(32,NULL,40719,2,0.00,NULL,'2022-10-07 11:07:38','2022-10-07 11:07:38'),(33,NULL,40719,4,0.00,NULL,'2022-10-07 11:07:38','2022-10-07 11:07:38'),(34,NULL,40719,8,0.00,NULL,'2022-10-07 11:07:38','2022-10-07 11:07:38'),(35,NULL,40719,10,0.00,NULL,'2022-10-07 11:07:38','2022-10-07 11:07:38'),(36,NULL,40719,2,0.00,NULL,NULL,NULL),(37,NULL,40719,4,0.00,NULL,NULL,NULL),(38,NULL,40719,5,0.00,NULL,NULL,NULL),(39,NULL,40719,8,0.00,NULL,NULL,NULL),(40,NULL,40719,10,0.00,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_indicadores_persons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ing_egr_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock`
--

LOCK TABLES `inv_ing_egr_stock` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock_detail`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_ing_egr_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `sumar1_restar0` tinyint(1) NOT NULL DEFAULT '1',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` (`inv_ing_egr_stock_id`),
  KEY `inv_ing_egr_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` FOREIGN KEY (`inv_ing_egr_stock_id`) REFERENCES `inv_ing_egr_stock` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock_detail`
--

LOCK TABLES `inv_ing_egr_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_lista_de_precios`
--

DROP TABLE IF EXISTS `inv_lista_de_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_lista_de_precios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `porcentaje_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_lista_de_precios_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_lista_de_precios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_lista_de_precios`
--

LOCK TABLES `inv_lista_de_precios` WRITE;
/*!40000 ALTER TABLE `inv_lista_de_precios` DISABLE KEYS */;
INSERT INTO `inv_lista_de_precios` VALUES (1,7777,40719,'Vestimenta formal',0.00,1,'2022-10-03 10:29:19','2022-10-03 10:29:19',NULL);
/*!40000 ALTER TABLE `inv_lista_de_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_clasificacion`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_clasificacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_clasificacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_clasificacion_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_clasificacion_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_clasificacion`
--

LOCK TABLES `inv_orden_trabajo_clasificacion` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_clasificacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_clasificacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_config_cc`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_config_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_config_cc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `horas_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `horas_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `asiento_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_config_cc_person_id_foreign` (`person_id`),
  KEY `hcc_id_foreign` (`horas_conta_plan_cuenta_id`),
  KEY `gcc_id_foreign` (`gastos_conta_plan_cuenta_id`),
  KEY `pcc_id_foreign` (`productos_conta_plan_cuenta_id`),
  KEY `h_contra_cc_id_foreign` (`horas_contra_conta_plan_cuenta_id`),
  KEY `g_contra_cc_id_foreign` (`gastos_contra_conta_plan_cuenta_id`),
  KEY `p_contra_cc_id_foreign` (`productos_contra_conta_plan_cuenta_id`),
  KEY `ahcc_id_foreign` (`asiento_horas_cpc_id`),
  KEY `agcc_id_foreign` (`asiento_gastos_cpc_id`),
  KEY `apcc_id_foreign` (`asiento_productos_cpc_id`),
  KEY `ah_contra_cc_id_foreign` (`asiento_contra_horas_cpc_id`),
  KEY `ag_contra_cc_id_foreign` (`asiento_contra_gastos_cpc_id`),
  KEY `ap_contra_cc_id_foreign` (`asiento_contra_productos_cpc_id`),
  CONSTRAINT `ag_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `agcc_id_foreign` FOREIGN KEY (`asiento_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ah_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ahcc_id_foreign` FOREIGN KEY (`asiento_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ap_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `apcc_id_foreign` FOREIGN KEY (`asiento_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `g_contra_cc_id_foreign` FOREIGN KEY (`gastos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `gcc_id_foreign` FOREIGN KEY (`gastos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `h_contra_cc_id_foreign` FOREIGN KEY (`horas_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `hcc_id_foreign` FOREIGN KEY (`horas_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `inv_orden_trabajo_config_cc_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `p_contra_cc_id_foreign` FOREIGN KEY (`productos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `pcc_id_foreign` FOREIGN KEY (`productos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_config_cc`
--

LOCK TABLES `inv_orden_trabajo_config_cc` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_facturada`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_facturada_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_facturada`
--

LOCK TABLES `inv_orden_trabajo_facturada` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-09-05 16:45:28',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_gastos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajo_gastos_receipt_id_foreign` (`receipt_id`),
  KEY `i_o_t_g_t_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `i_o_t_g_t_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos`
--

LOCK TABLES `inv_orden_trabajo_gastos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_gastos_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos_tipos`
--

LOCK TABLES `inv_orden_trabajo_gastos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-15 23:34:54',
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_ot_hora_disponible_id` bigint(20) unsigned NOT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_horas_inv_ot_hora_disponible_id_foreign` (`inv_ot_hora_disponible_id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_ot_hora_disponible_id_foreign` FOREIGN KEY (`inv_ot_hora_disponible_id`) REFERENCES `inv_orden_trabajo_horas_disponibles` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas`
--

LOCK TABLES `inv_orden_trabajo_horas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_dispo`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cargar_asignar` int(10) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-22 21:45:19',
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_dispo_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_dispo_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `inv_orden_trabajo_horas_dispo_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_dispo`
--

LOCK TABLES `inv_orden_trabajo_horas_dispo` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_disponibles`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_disponibles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_disponibles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_horas_dispo_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-15 23:34:54',
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_disponibles_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_disponibles_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_ot_hs_tipo_dis` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_ot_horas_dispo_id` (`inv_orden_trabajo_horas_dispo_id`),
  CONSTRAINT `inv_orden_trabajo_horas_disponibles_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_disponibles_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_ot_horas_dispo_id` FOREIGN KEY (`inv_orden_trabajo_horas_dispo_id`) REFERENCES `inv_orden_trabajo_horas_dispo` (`id`),
  CONSTRAINT `inv_ot_hs_tipo_dis` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_disponibles`
--

LOCK TABLES `inv_orden_trabajo_horas_disponibles` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_disponibles` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_disponibles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(16,2) NOT NULL DEFAULT '1.00',
  `cantidad_disponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_disponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_tipos`
--

LOCK TABLES `inv_orden_trabajo_horas_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_productos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-09-05 16:45:28',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '1.00',
  `total` decimal(16,2) NOT NULL DEFAULT '1.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_productos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_productos_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `inv_orden_trabajo_productos_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `inv_orden_trabajo_productos_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_productos`
--

LOCK TABLES `inv_orden_trabajo_productos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_servicios`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_servicios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_servicios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-14 22:25:41',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_servicios_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_servicios_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_servicios_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `inv_orden_trabajo_servicios_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  CONSTRAINT `inv_orden_trabajo_servicios_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_servicios`
--

LOCK TABLES `inv_orden_trabajo_servicios` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_servicios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_servicios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajos`
--

DROP TABLE IF EXISTS `inv_orden_trabajos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `inv_ot_clasificacion_id` int(10) unsigned DEFAULT NULL,
  `patente` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-09-05 16:45:28',
  `fecha_cierre` datetime DEFAULT NULL,
  `numero` int(10) unsigned NOT NULL,
  `responsable` text COLLATE utf8mb4_unicode_ci,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `cerrada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajos_inv_ot_clasificacion_id_foreign` (`inv_ot_clasificacion_id`),
  CONSTRAINT `inv_orden_trabajos_inv_ot_clasificacion_id_foreign` FOREIGN KEY (`inv_ot_clasificacion_id`) REFERENCES `inv_orden_trabajo_clasificacion` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajos`
--

LOCK TABLES `inv_orden_trabajos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_horas_importe_dispo`
--

DROP TABLE IF EXISTS `inv_ot_horas_importe_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_horas_importe_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-12 22:19:42',
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_horas_importe_dispo_person_id_foreign` (`person_id`),
  KEY `inv_ot_horas_importe_dispo_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `inv_ot_horas_importe_dispo_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_horas_importe_dispo`
--

LOCK TABLES `inv_ot_horas_importe_dispo` WRITE;
/*!40000 ALTER TABLE `inv_ot_horas_importe_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_horas_importe_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_horas_importe_disponible`
--

DROP TABLE IF EXISTS `inv_ot_horas_importe_disponible`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_horas_importe_disponible` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_horas_importe_dispo_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned NOT NULL,
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_h_imp_dispo_id` (`inv_ot_horas_importe_dispo_id`),
  KEY `inv_ot_h_tipo_id` (`inv_orden_trabajo_horas_tipo_id`),
  CONSTRAINT `inv_ot_h_imp_dispo_id` FOREIGN KEY (`inv_ot_horas_importe_dispo_id`) REFERENCES `inv_ot_horas_importe_dispo` (`id`),
  CONSTRAINT `inv_ot_h_tipo_id` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_horas_importe_disponible`
--

LOCK TABLES `inv_ot_horas_importe_disponible` WRITE;
/*!40000 ALTER TABLE `inv_ot_horas_importe_disponible` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_horas_importe_disponible` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_product_receipt`
--

DROP TABLE IF EXISTS `inv_product_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_product_receipt` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `receiptable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `receiptable_id` int(10) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento_por1_imp0` tinyint(1) NOT NULL DEFAULT '1',
  `descuento_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_con_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_product_receipt_type_id_foreign` (`type_id`),
  KEY `inv_product_receipt_person_id_foreign` (`person_id`),
  KEY `inv_product_receipt_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_product_receipt_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_product_receipt_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_product_receipt_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_product_receipt`
--

LOCK TABLES `inv_product_receipt` WRITE;
/*!40000 ALTER TABLE `inv_product_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_product_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_producto_fotos`
--

DROP TABLE IF EXISTS `inv_producto_fotos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_producto_fotos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned NOT NULL,
  `foto` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_producto_fotos_inv_producto_id_foreign` (`inv_producto_id`),
  CONSTRAINT `inv_producto_fotos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_producto_fotos`
--

LOCK TABLES `inv_producto_fotos` WRITE;
/*!40000 ALTER TABLE `inv_producto_fotos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_producto_fotos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_producto_prioridad`
--

DROP TABLE IF EXISTS `inv_producto_prioridad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_producto_prioridad` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_producto_prioridad`
--

LOCK TABLES `inv_producto_prioridad` WRITE;
/*!40000 ALTER TABLE `inv_producto_prioridad` DISABLE KEYS */;
INSERT INTO `inv_producto_prioridad` VALUES (1,'Alta',1,NULL,NULL,NULL),(2,'Media',1,NULL,NULL,NULL),(3,'Baja',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_producto_prioridad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos`
--

DROP TABLE IF EXISTS `inv_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `inv_producto_tipo_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `inv_deposito_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `person_prov_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_externo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fac_ele_unidad_medida_id` int(10) unsigned NOT NULL DEFAULT '8',
  `inv_rubro_sub_id` bigint(20) unsigned NOT NULL,
  `inv_ubicacion_id` bigint(20) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `margen` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `system_tax_id` int(10) unsigned DEFAULT NULL,
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `inv_lista_de_precio_id` bigint(20) unsigned DEFAULT NULL,
  `inv_prioridad_id` bigint(20) unsigned NOT NULL DEFAULT '3',
  `foto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_minimo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `texto_corto` text COLLATE utf8mb4_unicode_ci,
  `texto_largo` text COLLATE utf8mb4_unicode_ci,
  `show_in_catalogo` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_productos_person_id_foreign` (`person_id`),
  KEY `inv_productos_person_prov_id_foreign` (`person_prov_id`),
  KEY `inv_productos_fac_ele_unidad_medida_id_foreign` (`fac_ele_unidad_medida_id`),
  KEY `inv_productos_inv_rubro_sub_id_foreign` (`inv_rubro_sub_id`),
  KEY `inv_productos_inv_ubicacion_id_foreign` (`inv_ubicacion_id`),
  KEY `inv_productos_system_tax_id_foreign` (`system_tax_id`),
  KEY `inv_productos_inv_lista_de_precio_id_foreign` (`inv_lista_de_precio_id`),
  KEY `inv_productos_inv_producto_tipo_id_foreign` (`inv_producto_tipo_id`),
  KEY `inv_productos_moneda_id_foreign` (`moneda_id`),
  KEY `inv_productos_inv_deposito_id_foreign` (`inv_deposito_id`),
  KEY `inv_productos_inv_prioridad_id_foreign` (`inv_prioridad_id`),
  CONSTRAINT `inv_productos_fac_ele_unidad_medida_id_foreign` FOREIGN KEY (`fac_ele_unidad_medida_id`) REFERENCES `fac_elec_unidad_medidas` (`id`),
  CONSTRAINT `inv_productos_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_productos_inv_lista_de_precio_id_foreign` FOREIGN KEY (`inv_lista_de_precio_id`) REFERENCES `inv_lista_de_precios` (`id`),
  CONSTRAINT `inv_productos_inv_prioridad_id_foreign` FOREIGN KEY (`inv_prioridad_id`) REFERENCES `inv_producto_prioridad` (`id`),
  CONSTRAINT `inv_productos_inv_producto_tipo_id_foreign` FOREIGN KEY (`inv_producto_tipo_id`) REFERENCES `inv_productos_tipos` (`id`),
  CONSTRAINT `inv_productos_inv_rubro_sub_id_foreign` FOREIGN KEY (`inv_rubro_sub_id`) REFERENCES `inv_rubros_sub` (`id`),
  CONSTRAINT `inv_productos_inv_ubicacion_id_foreign` FOREIGN KEY (`inv_ubicacion_id`) REFERENCES `inv_ubicaciones` (`id`),
  CONSTRAINT `inv_productos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `inv_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_person_prov_id_foreign` FOREIGN KEY (`person_prov_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos`
--

LOCK TABLES `inv_productos` WRITE;
/*!40000 ALTER TABLE `inv_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos_tipos`
--

DROP TABLE IF EXISTS `inv_productos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos_tipos`
--

LOCK TABLES `inv_productos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_productos_tipos` DISABLE KEYS */;
INSERT INTO `inv_productos_tipos` VALUES (1,NULL,'Unitario',1,NULL,NULL,NULL),(2,NULL,'Combo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_productos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros`
--

DROP TABLE IF EXISTS `inv_rubros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_rubros_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros`
--

LOCK TABLES `inv_rubros` WRITE;
/*!40000 ALTER TABLE `inv_rubros` DISABLE KEYS */;
INSERT INTO `inv_rubros` VALUES (1,7777,40719,'Vestimenta formal',1,'2022-10-03 10:16:10','2022-10-03 10:16:10',NULL),(2,7777,40719,'Vestimenta casual',1,'2022-10-03 10:17:06','2022-10-03 10:17:06',NULL),(3,7777,40719,'pantalones de vestir',1,'2022-10-03 10:18:14','2022-10-03 10:18:57','2022-10-03 10:18:57');
/*!40000 ALTER TABLE `inv_rubros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros_sub`
--

DROP TABLE IF EXISTS `inv_rubros_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros_sub` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_rubro_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_sub_person_id_foreign` (`person_id`),
  KEY `inv_rubros_sub_inv_rubro_id_foreign` (`inv_rubro_id`),
  CONSTRAINT `inv_rubros_sub_inv_rubro_id_foreign` FOREIGN KEY (`inv_rubro_id`) REFERENCES `inv_rubros` (`id`),
  CONSTRAINT `inv_rubros_sub_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros_sub`
--

LOCK TABLES `inv_rubros_sub` WRITE;
/*!40000 ALTER TABLE `inv_rubros_sub` DISABLE KEYS */;
INSERT INTO `inv_rubros_sub` VALUES (1,7777,40719,1,'trajes formales',1,'2022-10-03 10:17:33','2022-10-03 10:17:33',NULL),(2,7777,40719,1,'sacos blazer',1,'2022-10-03 10:17:46','2022-10-03 10:17:46',NULL),(3,7777,40719,1,'corbatas',1,'2022-10-03 10:18:00','2022-10-03 10:18:00',NULL),(4,7777,40719,2,'Sacos sport',1,'2022-10-03 10:18:49','2022-10-03 10:18:49',NULL),(5,7777,40719,2,'Pantalones chinos',1,'2022-10-03 10:19:30','2022-10-03 10:19:30',NULL);
/*!40000 ALTER TABLE `inv_rubros_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_stock_movimientos`
--

DROP TABLE IF EXISTS `inv_stock_movimientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_stock_movimientos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `movimiento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` bigint(20) unsigned NOT NULL,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_morph` (`transactionable_type`,`transactionable_id`),
  KEY `inv_stock_movimientos_person_id_foreign` (`person_id`),
  KEY `inv_stock_movimientos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_stock_movimientos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_stock_movimientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_stock_movimientos`
--

LOCK TABLES `inv_stock_movimientos` WRITE;
/*!40000 ALTER TABLE `inv_stock_movimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_stock_movimientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ubicaciones`
--

DROP TABLE IF EXISTS `inv_ubicaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ubicaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_deposito_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ubicaciones_person_id_foreign` (`person_id`),
  KEY `inv_ubicaciones_inv_deposito_id_foreign` (`inv_deposito_id`),
  CONSTRAINT `inv_ubicaciones_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_ubicaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ubicaciones`
--

LOCK TABLES `inv_ubicaciones` WRITE;
/*!40000 ALTER TABLE `inv_ubicaciones` DISABLE KEYS */;
INSERT INTO `inv_ubicaciones` VALUES (1,7777,40719,1,'Estanteria 1',1,'2022-10-03 10:29:39','2023-05-17 06:39:57',NULL);
/*!40000 ALTER TABLE `inv_ubicaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_agrupacion`
--

DROP TABLE IF EXISTS `iva_agrupacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_agrupacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `ordr` int(11) NOT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_agrupacion`
--

LOCK TABLES `iva_agrupacion` WRITE;
/*!40000 ALTER TABLE `iva_agrupacion` DISABLE KEYS */;
INSERT INTO `iva_agrupacion` VALUES (1,1,1,0.00,'Operaciones con Responsables Inscriptos',1,NULL,NULL,NULL),(2,1,2,0.00,'Operaciones con Consumidores finales, Exentos y No alcanzados',1,NULL,NULL,NULL),(3,1,3,0.00,'Operaciones no gravadas y exentas',1,NULL,NULL,NULL),(4,1,4,0.00,'Credito fiscal a restituir',1,NULL,NULL,NULL),(5,2,5,0.00,'Debito fiscal a restituir',1,NULL,NULL,NULL),(6,2,6,0.00,'Total Credito Fiscal',1,NULL,NULL,NULL),(7,2,7,0.00,'Total Operaciones que no Generan Credito Fiscal',1,NULL,NULL,NULL),(8,1,8,0.00,'Operaciones con Monotributistas - Regimen Simmplificado',1,'2022-09-05 16:45:27','2022-09-05 16:45:27',NULL);
/*!40000 ALTER TABLE `iva_agrupacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_conditions`
--

DROP TABLE IF EXISTS `iva_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_conditions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `iva_conditions_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_conditions`
--

LOCK TABLES `iva_conditions` WRITE;
/*!40000 ALTER TABLE `iva_conditions` DISABLE KEYS */;
INSERT INTO `iva_conditions` VALUES (1,'Monotributo',NULL,NULL),(2,'Responsable Inscripto',NULL,NULL),(3,'Otro',NULL,NULL);
/*!40000 ALTER TABLE `iva_conditions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_creditos_tipos`
--

DROP TABLE IF EXISTS `iva_creditos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_creditos_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_creditos_tipos`
--

LOCK TABLES `iva_creditos_tipos` WRITE;
/*!40000 ALTER TABLE `iva_creditos_tipos` DISABLE KEYS */;
INSERT INTO `iva_creditos_tipos` VALUES (1,0,'Compras de bienes (excepto bienes de uso)',0.00,1,NULL,NULL,NULL),(2,0,'Locaciones',0.00,1,NULL,NULL,NULL),(3,0,'Prestaciones de servicios',0.00,1,NULL,NULL,NULL),(4,0,'Inversiones de Bienes de Uso',0.00,1,NULL,NULL,NULL),(5,0,'Compras de bienes usados a consumidores finales',0.00,1,NULL,NULL,NULL),(6,0,'Tur IVA',0.00,1,NULL,NULL,NULL),(7,0,'Contribuciones de la Seguridad Social',0.00,1,NULL,NULL,NULL),(8,0,'Contribuciones de la Seguridad Social - Artículo 91 Ley 27.467',0.00,1,NULL,NULL,NULL),(9,0,'Otros Conceptos',0.00,1,NULL,NULL,NULL),(10,0,'Compras de Bienes en el Exterior',0.00,1,NULL,NULL,NULL),(11,0,'Compras de Servicios en el exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(12,0,'Compras de Servicios en el exterior - Impuesto ingresado por el responsable',0.00,1,NULL,NULL,NULL),(13,0,'Locaciones o prestaciones gravadas en el país realizadas por sujetos del exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(14,0,'Régimen especial de compensación para la estabilización de precios - Emergencia alimentaria - Ley 27.519',0.00,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `iva_creditos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  `base_de_dato` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `liquidators`
--

DROP TABLE IF EXISTS `liquidators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `liquidators` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `liquidators_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `liquidators`
--

LOCK TABLES `liquidators` WRITE;
/*!40000 ALTER TABLE `liquidators` DISABLE KEYS */;
INSERT INTO `liquidators` VALUES (1,NULL,'Florencia',NULL,NULL,NULL),(2,NULL,'Jose Luis',NULL,NULL,NULL),(3,NULL,'Elizabet',NULL,NULL,NULL),(4,NULL,'Graciela',NULL,NULL,NULL),(5,NULL,'Agustina',NULL,NULL,NULL),(6,NULL,'Betty',NULL,NULL,NULL),(7,NULL,'Hernan',NULL,NULL,NULL);
/*!40000 ALTER TABLE `liquidators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `localidad`
--

DROP TABLE IF EXISTS `localidad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `localidad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `localidad_descripcion_unique` (`descripcion`),
  KEY `localidad_zone_id_foreign` (`zone_id`),
  CONSTRAINT `localidad_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `localidad`
--

LOCK TABLES `localidad` WRITE;
/*!40000 ALTER TABLE `localidad` DISABLE KEYS */;
INSERT INTO `localidad` VALUES (1,NULL,22,'Capital Federal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,23,'Vicente Lopez',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,23,'San Isidro',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,23,'Lomas del Mirador',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,23,'Avellaneda',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,23,'Saenz Peña',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,23,'Caseros',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(8,NULL,23,'Moron',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `localidad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_debug`
--

DROP TABLE IF EXISTS `log_debug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_debug` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `function_name` varchar(255) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15499 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_debug`
--

LOCK TABLES `log_debug` WRITE;
/*!40000 ALTER TABLE `log_debug` DISABLE KEYS */;
INSERT INTO `log_debug` VALUES (1,NULL,'assingMorePeriods','ejecutando funcion','2018-06-06 12:58:53',NULL),(2,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2, periodo->2018-5','2018-06-06 12:58:53',NULL),(3,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(4,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(5,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(6,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(7,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(8,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(9,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(10,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(11,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(12,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(13,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(14,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(15,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(16,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->3, periodo->2018-5','2018-06-06 12:58:53',NULL),(17,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(18,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(19,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(20,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(21,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(22,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(23,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(24,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(25,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(26,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(27,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(28,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(29,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(30,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->5, periodo->2018-5','2018-06-06 12:58:53',NULL),(31,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(32,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(33,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(34,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (35,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(36,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(37,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(38,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(39,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(40,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(41,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(42,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(43,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(44,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->96, periodo->2018-5','2018-06-06 12:58:53',NULL),(45,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(46,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(47,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(48,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(49,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(50,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(51,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(52,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(53,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(54,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(55,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(56,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(57,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(58,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->338, periodo->2018-5','2018-06-06 12:58:53',NULL),(59,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(60,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(61,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(62,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(63,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(64,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(65,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(66,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(67,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (68,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(69,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(70,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(71,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(72,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->435, periodo->2018-5','2018-06-06 12:58:53',NULL),(73,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(74,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(75,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(76,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(77,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(78,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(79,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(80,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(81,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(82,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(83,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(84,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(85,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(86,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->436, periodo->2018-5','2018-06-06 12:58:53',NULL),(87,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(88,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(89,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(90,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(91,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(92,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(93,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(94,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(95,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(96,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(97,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(98,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(99,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(100,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->448, periodo->2018-5','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (101,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(102,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(103,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(104,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(105,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(106,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(107,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(108,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(109,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(110,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(111,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(112,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(113,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(114,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->639, periodo->2018-5','2018-06-06 12:58:53',NULL),(115,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(116,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(117,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(118,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(119,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(120,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(121,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(122,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(123,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(124,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(125,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(126,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(127,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(128,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->640, periodo->2018-5','2018-06-06 12:58:53',NULL),(129,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(130,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(131,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(132,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(133,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (134,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(135,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(136,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(137,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(138,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(139,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(140,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(141,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(142,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->673, periodo->2018-5','2018-06-06 12:58:53',NULL),(143,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(144,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(145,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(146,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(147,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(148,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(149,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(150,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(151,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(152,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(153,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(154,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(155,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(156,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->784, periodo->2018-5','2018-06-06 12:58:53',NULL),(157,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(158,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(159,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(160,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(161,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(162,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(163,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(164,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(165,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(166,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (167,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(168,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(169,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(170,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1479, periodo->2018-5','2018-06-06 12:58:53',NULL),(171,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(172,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(173,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(174,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(175,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(176,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(177,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(178,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(179,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(180,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(181,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(182,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(183,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(184,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1634, periodo->2018-5','2018-06-06 12:58:54',NULL),(185,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(186,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(187,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(188,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(189,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(190,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(191,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(192,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(193,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(194,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(195,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(196,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(197,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(198,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1717, periodo->2018-5','2018-06-06 12:58:54',NULL),(199,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (200,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(201,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(202,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(203,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(204,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(205,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(206,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(207,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(208,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(209,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(210,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(211,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(212,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1729, periodo->2018-5','2018-06-06 12:58:54',NULL),(213,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(214,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(215,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(216,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(217,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(218,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(219,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(220,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(221,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(222,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(223,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(224,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(225,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(226,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1736, periodo->2018-5','2018-06-06 12:58:54',NULL),(227,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(228,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(229,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(230,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(231,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(232,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (233,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(234,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(235,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(236,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(237,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(238,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(239,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(240,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1845, periodo->2018-5','2018-06-06 12:58:54',NULL),(241,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(242,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(243,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(244,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(245,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(246,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(247,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(248,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(249,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(250,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(251,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(252,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(253,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(254,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1859, periodo->2018-5','2018-06-06 12:58:54',NULL),(255,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(256,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(257,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(258,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(259,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(260,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(261,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(262,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(263,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(264,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(265,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (266,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(267,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(268,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1865, periodo->2018-5','2018-06-06 12:58:54',NULL),(269,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(270,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(271,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(272,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(273,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(274,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(275,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(276,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(277,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(278,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(279,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(280,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(281,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(282,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1870, periodo->2018-5','2018-06-06 12:58:54',NULL),(283,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(284,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(285,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(286,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(287,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(288,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(289,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(290,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(291,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(292,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(293,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(294,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(295,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(296,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1979, periodo->2018-5','2018-06-06 12:58:54',NULL),(297,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(298,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (299,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(300,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(301,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(302,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(303,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(304,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(305,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(306,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(307,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(308,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(309,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(310,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1990, periodo->2018-5','2018-06-06 12:58:54',NULL),(311,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(312,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(313,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(314,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(315,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(316,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(317,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(318,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(319,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(320,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(321,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(322,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(323,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(324,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1991, periodo->2018-5','2018-06-06 12:58:54',NULL),(325,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(326,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(327,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(328,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(329,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(330,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(331,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (332,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(333,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(334,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(335,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(336,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(337,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(338,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1992, periodo->2018-5','2018-06-06 12:58:54',NULL),(339,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(340,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(341,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(342,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(343,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(344,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(345,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(346,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(347,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(348,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(349,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(350,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(351,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(352,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1993, periodo->2018-5','2018-06-06 12:58:54',NULL),(353,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(354,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(355,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(356,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(357,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(358,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(359,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(360,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(361,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(362,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(363,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(364,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (365,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(366,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1994, periodo->2018-5','2018-06-06 12:58:54',NULL),(367,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(368,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(369,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(370,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(371,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(372,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(373,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(374,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(375,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(376,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(377,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(378,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(379,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(380,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1995, periodo->2018-5','2018-06-06 12:58:54',NULL),(381,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(382,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(383,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(384,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(385,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(386,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(387,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(388,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(389,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(390,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(391,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(392,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(393,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(394,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1996, periodo->2018-6','2018-06-06 12:58:54',NULL),(395,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->7, contador->0','2018-06-06 12:58:54',NULL),(396,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->7, contador->1','2018-06-06 12:58:54',NULL),(397,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (398,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(399,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(400,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(401,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(402,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(403,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(404,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(405,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(406,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(407,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(408,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1997, periodo->2018-5','2018-06-06 12:58:54',NULL),(409,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(410,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(411,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(412,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(413,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(414,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(415,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(416,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(417,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(418,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(419,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(420,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(421,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(422,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1998, periodo->2018-5','2018-06-06 12:58:54',NULL),(423,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(424,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(425,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(426,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(427,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(428,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(429,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(430,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (431,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(432,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(433,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(434,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(435,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(436,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1999, periodo->2018-5','2018-06-06 12:58:54',NULL),(437,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(438,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(439,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(440,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(441,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(442,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(443,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(444,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(445,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(446,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(447,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(448,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(449,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(450,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2000, periodo->2018-5','2018-06-06 12:58:54',NULL),(451,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(452,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(453,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(454,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(455,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(456,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(457,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(458,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(459,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(460,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(461,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(462,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(463,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (464,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2001, periodo->2018-5','2018-06-06 12:58:54',NULL),(465,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(466,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(467,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(468,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(469,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(470,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(471,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(472,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(473,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(474,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(475,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(476,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(477,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(478,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2002, periodo->2018-5','2018-06-06 12:58:54',NULL),(479,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(480,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(481,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(482,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(483,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(484,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(485,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(486,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(487,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(488,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(489,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(490,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(491,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(492,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2003, periodo->2018-5','2018-06-06 12:58:54',NULL),(493,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(494,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(495,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(496,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (497,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(498,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(499,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(500,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(501,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(502,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(503,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(504,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(505,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(506,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2004, periodo->2018-5','2018-06-06 12:58:54',NULL),(507,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(508,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(509,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(510,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(511,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(512,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(513,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(514,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(515,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(516,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(517,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(518,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(519,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(520,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2005, periodo->2018-5','2018-06-06 12:58:54',NULL),(521,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(522,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(523,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(524,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(525,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(526,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(527,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(528,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(529,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (530,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(531,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(532,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(533,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(534,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2006, periodo->2018-5','2018-06-06 12:58:54',NULL),(535,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(536,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(537,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(538,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(539,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(540,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(541,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(542,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(543,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(544,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(545,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(546,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(547,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(548,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2007, periodo->2018-5','2018-06-06 12:58:54',NULL),(549,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(550,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(551,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(552,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(553,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(554,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(555,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(556,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(557,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(558,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(559,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(560,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(561,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(562,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2008, periodo->2018-5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (563,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(564,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(565,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(566,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(567,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(568,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(569,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(570,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(571,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(572,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(573,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(574,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(575,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(576,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2009, periodo->2018-5','2018-06-06 12:58:54',NULL),(577,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(578,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(579,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(580,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(581,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(582,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(583,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(584,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(585,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(586,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(587,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(588,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(589,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(590,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2010, periodo->2018-5','2018-06-06 12:58:54',NULL),(591,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(592,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(593,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(594,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(595,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (596,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(597,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(598,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(599,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(600,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(601,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(602,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(603,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(604,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2011, periodo->2018-5','2018-06-06 12:58:54',NULL),(605,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(606,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(607,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(608,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(609,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(610,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(611,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(612,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(613,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(614,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(615,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(616,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(617,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(618,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2012, periodo->2018-5','2018-06-06 12:58:54',NULL),(619,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(620,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(621,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(622,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(623,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(624,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(625,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(626,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(627,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(628,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (629,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(630,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(631,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(632,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2013, periodo->2018-5','2018-06-06 12:58:54',NULL),(633,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(634,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(635,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(636,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(637,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(638,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(639,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(640,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(641,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(642,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(643,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(644,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(645,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(646,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2014, periodo->2018-5','2018-06-06 12:58:54',NULL),(647,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(648,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(649,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(650,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(651,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(652,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(653,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(654,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(655,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(656,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(657,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(658,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(659,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(660,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2015, periodo->2018-5','2018-06-06 12:58:54',NULL),(661,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (662,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(663,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(664,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(665,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(666,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(667,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(668,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(669,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(670,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(671,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(672,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(673,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(674,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2016, periodo->2018-5','2018-06-06 12:58:54',NULL),(675,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(676,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(677,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(678,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(679,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(680,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(681,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(682,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(683,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(684,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(685,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(686,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(687,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(688,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2017, periodo->2018-5','2018-06-06 12:58:54',NULL),(689,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(690,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(691,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(692,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(693,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(694,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (695,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(696,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(697,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(698,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(699,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(700,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(701,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(702,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2018, periodo->2018-5','2018-06-06 12:58:54',NULL),(703,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(704,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(705,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(706,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(707,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(708,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(709,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(710,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(711,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(712,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(713,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(714,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(715,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(716,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2019, periodo->2018-5','2018-06-06 12:58:54',NULL),(717,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(718,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(719,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(720,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(721,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(722,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(723,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(724,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(725,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(726,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(727,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (728,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(729,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(730,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2021, periodo->2018-5','2018-06-06 12:58:54',NULL),(731,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(732,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(733,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(734,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(735,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(736,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(737,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(738,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(739,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(740,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(741,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(742,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(743,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(744,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2022, periodo->2018-5','2018-06-06 12:58:54',NULL),(745,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(746,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(747,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(748,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(749,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(750,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(751,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(752,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(753,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(754,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(755,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(756,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(757,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(758,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2023, periodo->2018-5','2018-06-06 12:58:54',NULL),(759,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(760,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (761,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(762,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(763,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(764,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(765,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(766,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(767,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(768,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(769,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(770,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(771,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(772,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2024, periodo->2018-5','2018-06-06 12:58:54',NULL),(773,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(774,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(775,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(776,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(777,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(778,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(779,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(780,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(781,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(782,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(783,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(784,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(785,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(786,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2025, periodo->2018-5','2018-06-06 12:58:54',NULL),(787,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(788,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(789,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(790,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(791,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(792,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(793,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (794,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(795,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(796,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(797,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(798,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(799,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(800,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2026, periodo->2018-5','2018-06-06 12:58:54',NULL),(801,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(802,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(803,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(804,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(805,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(806,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(807,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(808,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(809,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(810,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(811,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(812,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(813,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(814,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2027, periodo->2018-5','2018-06-06 12:58:54',NULL),(815,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(816,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(817,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(818,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(819,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(820,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(821,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(822,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(823,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(824,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(825,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(826,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (827,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(828,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2028, periodo->2018-5','2018-06-06 12:58:54',NULL),(829,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(830,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(831,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(832,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(833,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(834,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(835,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(836,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(837,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(838,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(839,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(840,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(841,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(842,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2029, periodo->2018-5','2018-06-06 12:58:54',NULL),(843,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(844,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(845,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(846,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(847,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(848,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(849,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(850,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(851,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(852,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(853,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(854,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(855,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(856,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2030, periodo->2018-5','2018-06-06 12:58:54',NULL),(857,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(858,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(859,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (860,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(861,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(862,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(863,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(864,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(865,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(866,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(867,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(868,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(869,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(870,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2031, periodo->2018-5','2018-06-06 12:58:54',NULL),(871,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(872,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(873,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(874,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(875,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(876,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(877,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(878,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(879,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(880,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(881,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(882,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(883,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(884,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2032, periodo->2018-5','2018-06-06 12:58:54',NULL),(885,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(886,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(887,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(888,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(889,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(89