-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-30086821-6
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-11 14:20:33','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-11 14:20:33','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'mmartire@mmyasociados.com.ar','1157475926','Contador',1,40736,'2023-04-08'),(2,'marcelomartire@mmyasociados.com.ar','1157475926',NULL,1,40719,'2025-04-01');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(5,3,1,110,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(6,3,1,191,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(7,3,1,62,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(8,3,1,486,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(9,3,1,470,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(10,3,1,162,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(11,3,1,63,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(12,3,1,1442,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(13,3,1,1441,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(14,3,1,1443,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL),(15,3,1,1444,NULL,0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7941,1,2,'Sueldos',0.00,'2024-09-17 12:02:15','2024-09-17 12:02:15',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3606 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7941,40734,22734,1,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,11698095.46,'ajuste en sueldos y jornales a pagar',NULL,1,'2022-11-27 17:04:33','2022-11-27 17:04:33',NULL),(2,7941,40734,22735,1,2,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-11-30',NULL,10455367.21,NULL,NULL,1,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(3,7941,40734,22736,1,3,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-12-31',NULL,17498657.94,NULL,NULL,1,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(4,7941,40735,24237,2,4,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6559793.53,'Subdiario Ventas',NULL,1,'2023-04-08 11:39:35','2023-04-08 11:39:35',NULL),(5,7941,40735,24238,2,5,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3269041.37,'Subdiario Ventas',NULL,1,'2023-04-11 08:27:54','2023-04-11 08:27:54',NULL),(6,7941,40735,24239,2,6,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4944248.29,'Subdiario Ventas',NULL,1,'2023-04-11 08:29:44','2023-04-11 08:29:44',NULL),(7,7941,40735,24240,2,7,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',4635120.38,'Subdiario Ventas',NULL,1,'2023-04-11 08:31:00','2023-04-11 08:31:00',NULL),(8,7941,40735,24241,2,8,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6757033.64,'Subdiario Ventas',NULL,1,'2023-04-11 08:32:27','2023-04-11 08:32:27',NULL),(9,7941,40735,24242,2,9,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5663534.76,'Subdiario Ventas',NULL,1,'2023-04-11 08:33:41','2023-04-11 08:33:41',NULL),(10,7941,40735,24243,2,10,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5181620.21,'Subdiario Ventas',NULL,1,'2023-04-11 08:34:56','2023-04-11 08:34:56',NULL),(11,7941,40735,24244,2,11,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1446002.43,'Subdiario Ventas',NULL,1,'2023-04-11 08:36:06','2023-04-11 08:36:06',NULL),(12,7941,40735,24245,2,12,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8463962.39,'Subdiario Ventas',NULL,1,'2023-04-11 08:37:27','2023-04-11 08:37:27',NULL),(13,7941,40735,24246,2,13,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1289831.74,'Subdiario Ventas',NULL,1,'2023-04-11 08:38:22','2023-04-11 08:38:22',NULL),(14,7941,40735,24247,2,14,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6140254.88,'Subdiario Ventas',NULL,1,'2023-04-11 08:39:26','2023-04-11 08:39:26',NULL),(15,7941,40735,24248,2,15,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1984076.54,'Subdiario Ventas',NULL,1,'2023-04-11 08:40:52','2023-04-11 08:52:30','2023-04-11 08:52:30'),(16,7941,40735,24248,2,16,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1984076.54,'Subdiario Ventas',NULL,1,'2023-04-11 08:52:30','2023-04-30 11:36:32','2023-04-30 11:36:32'),(17,7941,40735,24237,15,17,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1138476.56,'DJ IVA',NULL,1,'2023-04-13 09:16:31','2023-04-13 09:16:31',NULL),(18,7941,40735,24238,15,18,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',784727.45,'DJ IVA',NULL,1,'2023-04-13 09:19:45','2023-04-13 09:19:45',NULL),(19,7941,40735,24239,15,19,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1263775.90,'DJ IVA',NULL,1,'2023-04-13 09:21:57','2023-04-13 09:21:57',NULL);
INSERT INTO `balance_libro` VALUES (20,7941,40735,24240,15,20,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',804442.38,'DJ IVA',NULL,1,'2023-04-13 09:36:07','2023-04-13 09:36:07',NULL),(21,7941,40735,24241,15,21,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1269043.46,'DJ IVA',NULL,1,'2023-04-13 09:38:24','2023-04-13 09:38:24',NULL),(22,7941,40735,24242,15,22,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1047660.15,'DJ IVA',NULL,1,'2023-04-13 09:40:48','2023-04-13 09:40:48',NULL),(23,7941,40735,24243,15,23,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',899289.46,'DJ IVA',NULL,1,'2023-04-13 09:45:11','2023-04-13 09:45:11',NULL),(24,7941,40735,24244,15,24,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',250959.10,'DJ IVA',NULL,1,'2023-04-13 09:46:40','2023-04-13 09:46:40',NULL),(27,7941,40735,24245,15,27,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1469213.23,'DJ IVA',NULL,1,'2023-04-13 09:50:57','2023-04-13 09:50:57',NULL),(28,7941,40735,24246,15,28,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1126755.84,'DJ IVA',NULL,1,'2023-04-13 09:53:46','2023-04-13 09:53:46',NULL),(29,7941,40735,24247,15,29,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1065664.07,'DJ IVA',NULL,1,'2023-04-13 09:55:01','2023-04-13 09:55:01',NULL),(30,7941,40735,24248,15,30,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',344343.86,NULL,NULL,1,'2023-04-13 09:56:04','2023-04-13 10:01:27','2023-04-13 10:01:27'),(31,7941,40735,24248,15,31,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',344343.86,'DJ IVA',NULL,1,'2023-04-13 10:01:27','2023-04-13 10:01:27',NULL),(32,7941,40735,24237,16,32,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',155864.71,'DJ IIBB',NULL,1,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(33,7941,40735,24238,16,33,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',105278.59,'DJ IIBB',NULL,1,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(34,7941,40735,24239,16,34,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',139961.43,'DJ IIBB',NULL,1,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(35,7941,40735,24240,16,35,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',132436.01,'DJ IIBB',NULL,1,'2023-04-13 13:32:28','2023-04-13 13:32:28',NULL),(36,7941,40735,24241,16,36,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',244241.72,'DJ IIBB',NULL,1,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(37,7941,40735,24242,16,37,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',139176.91,'DJ IIBB',NULL,1,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(38,7941,40735,24243,16,38,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',216793.32,'DJ IIBB',NULL,1,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(39,7941,40735,24244,16,39,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',139720.88,'DJ IIBB',NULL,1,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(40,7941,40735,24245,16,40,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',257102.76,'DJ IIBB',NULL,1,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL),(41,7941,40735,24246,16,41,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',208464.62,'DJ IIBB',NULL,1,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL);
INSERT INTO `balance_libro` VALUES (42,7941,40735,24247,16,42,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',253657.57,'DJ IIBB',NULL,1,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(43,7941,40735,24248,16,43,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',138613.88,'DJ IIBB',NULL,1,'2023-04-13 14:11:24','2023-04-13 14:11:24',NULL),(44,7941,40735,24237,3,44,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1267610.38,'SUBDIARIO COMPRAS',NULL,1,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(45,7941,40735,24238,3,45,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1830073.80,'SUBDIARIO COMPRAS',NULL,1,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(46,7941,40735,24238,3,46,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1830073.80,'SUBDIARIO COMPRAS',NULL,1,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(47,7941,40735,24237,3,47,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1267610.38,'SUBDIARIO COMPRAS',NULL,1,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(48,7941,40735,24239,3,48,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4322172.27,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(49,7941,40735,24240,3,49,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1681513.91,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 10:07:05','2023-04-14 10:07:05',NULL),(50,7941,40735,24241,3,50,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4529863.15,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(51,7941,40735,24242,3,51,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',8380846.51,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(52,7941,40735,24243,3,52,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',878684.16,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(53,7941,40735,24244,3,53,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',783347.76,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(54,7941,40735,24245,3,54,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1567915.30,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(55,7941,40735,24246,3,55,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4134431.16,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(56,7941,40735,24247,3,56,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1753850.21,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL),(57,7941,40735,24246,3,57,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4134431.16,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(58,7941,40735,24239,3,58,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4322172.27,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(59,7941,40735,24248,3,59,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1175907.27,'SUBDIARIO COMPRAS',NULL,1,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(60,7941,40735,24238,1,60,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',748897.70,'SUELDOS',NULL,1,'2023-04-23 10:36:25','2023-04-23 10:36:25',NULL);
INSERT INTO `balance_libro` VALUES (61,7941,40735,24237,12,61,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',16307470.93,'SALDOS INICIALES',NULL,1,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(62,7941,40735,24237,12,62,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',16307470.93,'SALDOS INICIALES',NULL,1,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(63,7941,40735,24239,1,63,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',636905.69,'SUELDOS',NULL,1,'2023-04-25 15:32:13','2023-04-25 15:32:13',NULL),(64,7941,40735,24240,1,64,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',847313.68,'SUELDOS',NULL,1,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(65,7941,40735,24241,1,65,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',823569.22,'SUELDOS',NULL,1,'2023-04-30 10:59:55','2023-04-30 10:59:55',NULL),(66,7941,40735,24242,1,66,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1193857.99,'SUELDOS',NULL,1,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(67,7941,40735,24243,1,67,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',894802.88,'SUELDOS',NULL,1,'2023-04-30 11:07:42','2023-04-30 11:07:42',NULL),(68,7941,40735,24244,1,68,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',985381.97,'SUELDOS',NULL,1,'2023-04-30 11:09:21','2023-04-30 11:09:21',NULL),(69,7941,40735,24245,1,69,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1083377.66,'SUELDOS',NULL,1,'2023-04-30 11:14:35','2023-04-30 11:14:35',NULL),(70,7941,40735,24246,1,70,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1129302.97,'SUELDOS',NULL,1,'2023-04-30 11:18:08','2023-04-30 11:18:08',NULL),(71,7941,40735,24247,1,71,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1217379.95,'SUELDOS',NULL,1,'2023-04-30 11:19:50','2023-04-30 11:19:50',NULL),(72,7941,40735,24248,1,72,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2005551.37,'SUELDOS',NULL,1,'2023-04-30 11:22:05','2023-04-30 11:22:05',NULL),(73,7941,40735,24237,1,73,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',543072.52,'SUELDOS',NULL,1,'2023-04-30 11:23:17','2023-04-30 11:23:17',NULL),(74,7941,40735,24237,7,74,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1094.45,'SICORE',NULL,1,'2023-04-30 11:26:29','2023-04-30 11:26:29',NULL),(75,7941,40735,24239,7,75,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',50375.02,'SICORE',NULL,1,'2023-04-30 11:28:38','2023-04-30 11:28:38',NULL),(76,7941,40735,24240,7,76,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',956.60,'SICORE',NULL,1,'2023-04-30 11:29:21','2023-04-30 11:29:21',NULL),(77,7941,40735,24241,7,77,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',8087.24,'SICORE',NULL,1,'2023-04-30 11:30:01','2023-04-30 11:30:01',NULL),(78,7941,40735,24242,7,78,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3056.60,'SICORE',NULL,1,'2023-04-30 11:30:31','2023-04-30 11:30:31',NULL),(79,7941,40735,24243,7,79,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',137159.93,'SICORE',NULL,1,'2023-04-30 11:31:04','2023-04-30 11:31:04',NULL),(80,7941,40735,24244,7,80,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1356.60,'SICORE',NULL,1,'2023-04-30 11:31:31','2023-04-30 11:31:31',NULL);
INSERT INTO `balance_libro` VALUES (81,7941,40735,24245,7,81,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8355.64,'SICORE',NULL,1,'2023-04-30 11:32:03','2023-04-30 11:32:03',NULL),(82,7941,40735,24246,7,82,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',60317.22,'SICORE',NULL,1,'2023-04-30 11:33:10','2023-04-30 11:33:10',NULL),(83,7941,40735,24247,7,83,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1632.60,'SICORE',NULL,1,'2023-04-30 11:33:55','2023-04-30 11:33:55',NULL),(84,7941,40735,24248,7,84,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',10439.47,'SICORE',NULL,1,'2023-04-30 11:34:27','2023-04-30 11:34:27',NULL),(85,7941,40735,24248,2,85,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1984076.54,'SUBDIARIO VENTAS',NULL,1,'2023-04-30 11:36:32','2023-04-30 11:36:48','2023-04-30 11:36:48'),(86,7941,40735,24248,2,86,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1984076.54,'Subdiario Ventas',NULL,1,'2023-04-30 11:36:48','2023-04-30 11:36:48',NULL),(87,7941,40735,24237,5,87,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1001561.75,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(88,7941,40735,24238,5,88,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2897510.01,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(89,7941,40735,24239,5,89,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2208162.44,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(90,7941,40735,24240,5,90,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1735331.66,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40'),(91,7941,40735,24241,5,91,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3854803.23,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(92,7941,40735,24242,5,92,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1369769.78,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(93,7941,40735,24241,5,93,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3854803.23,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(94,7941,40735,24242,5,94,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1369769.78,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(95,7941,40735,24242,5,95,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1369769.78,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(96,7941,40735,24243,5,96,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',553701.01,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:07:02','2023-04-30 12:07:02',NULL),(97,7941,40735,24244,5,97,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',979857.60,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:09:13','2023-04-30 12:09:13',NULL),(98,7941,40735,24245,5,98,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1332169.07,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL);
INSERT INTO `balance_libro` VALUES (99,7941,40735,24246,5,99,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3319138.47,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(100,7941,40735,24247,5,100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1253434.90,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(101,7941,40735,24237,5,101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1001561.75,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(102,7941,40735,24246,5,102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3319138.47,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(103,7941,40735,24242,5,103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1369769.78,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(104,7941,40735,24241,5,104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3854803.23,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(105,7941,40735,24240,5,105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1735331.66,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(106,7941,40735,24239,5,106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2208162.44,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(107,7941,40735,24237,5,107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1001561.75,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL),(108,7941,40735,24248,5,108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1669467.49,'BANCO BBVA 9023-8',NULL,1,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(109,7941,40735,24237,5,109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1663088.47,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(110,7941,40735,24238,5,110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1854247.37,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(111,7941,40735,24239,5,111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3485096.89,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 13:07:26','2023-04-30 13:07:26',NULL),(112,7941,40735,24240,5,112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1835552.03,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:13:26','2023-04-30 17:13:26',NULL),(113,7941,40735,24241,5,113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5459630.70,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:18:02','2023-04-30 17:18:02',NULL),(114,7941,40735,24242,5,114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5663534.74,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:22:47','2023-04-30 17:22:47',NULL),(115,7941,40735,24243,5,115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',10105851.06,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:27:29','2023-04-30 17:27:29',NULL),(116,7941,40735,24244,5,116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1086456.52,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:31:06','2023-04-30 17:31:06',NULL);
INSERT INTO `balance_libro` VALUES (117,7941,40735,24245,5,117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1642551.00,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:37:45','2023-04-30 17:37:45',NULL),(118,7941,40735,24246,5,118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4141770.76,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:40:48','2023-04-30 17:40:48',NULL),(119,7941,40735,24247,5,119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5122561.72,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:43:16','2023-04-30 17:43:16',NULL),(120,7941,40735,24248,5,120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2674427.64,'BANCO BBVA 2712-6',NULL,1,'2023-04-30 17:46:40','2023-04-30 17:46:40',NULL),(121,7941,40736,25772,5,121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1500100.00,'BANCO GALICIA',NULL,1,'2023-05-02 11:27:03','2023-05-02 11:27:03',NULL),(122,7941,40736,25773,5,122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1500000.00,'BANCO GALICIA',NULL,1,'2023-05-02 11:27:45','2023-05-02 11:27:45',NULL),(123,7941,40736,25774,5,123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1566817.34,'BANCO GALICIA',NULL,1,'2023-05-02 11:28:48','2023-05-02 11:28:48',NULL),(124,7941,40736,25775,5,124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2500000.00,'BANCO GALICIA',NULL,1,'2023-05-02 11:30:03','2023-05-02 11:30:03',NULL),(125,7941,40736,25776,5,125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2006000.00,'BANCO GALICIA',NULL,1,'2023-05-02 11:31:10','2023-05-02 11:31:10',NULL),(126,7941,40736,25777,5,126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1492144.00,'BANCO GALICIA',NULL,1,'2023-05-02 11:32:02','2023-05-02 11:32:02',NULL),(127,7941,40736,25778,5,127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6100000.00,'BANCO GALICIA',NULL,1,'2023-05-02 11:33:12','2023-05-02 11:33:12',NULL),(128,7941,40735,24237,12,128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',16307470.93,'SALDOS INICIALES',NULL,1,'2023-05-06 19:23:52','2023-05-06 19:23:52',NULL),(129,7941,40869,203033,3,129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',206533.90,'SUBDIARIO COMPRAS',NULL,1,'2023-10-31 11:34:21','2023-10-31 11:44:52','2023-10-31 11:44:52'),(130,7941,40869,203033,3,130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',206533.90,'SUBDIARIO COMPRAS',NULL,1,'2023-10-31 11:44:52','2023-10-31 11:46:05','2023-10-31 11:46:05'),(131,7941,40869,203033,3,131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',206533.90,'SUBDIARIO COMPRAS',NULL,1,'2023-10-31 11:46:05','2024-05-02 15:22:37','2024-05-02 15:22:37'),(132,7941,40869,203034,5,132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2176582.52,'BANCO SANTANDER 1',NULL,1,'2023-10-31 11:50:23','2023-10-31 11:51:33','2023-10-31 11:51:33'),(133,7941,40869,203034,5,133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2176582.52,'BANCO SANTANDER 1',NULL,1,'2023-10-31 11:51:33','2023-10-31 12:07:24','2023-10-31 12:07:24'),(134,7941,40869,203034,5,134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',27888.64,'BANCO SANTANDER 2',NULL,1,'2023-10-31 11:55:04','2023-10-31 12:07:32','2023-10-31 12:07:32');
INSERT INTO `balance_libro` VALUES (135,7941,40869,203034,5,135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3787979.60,'BANCO MACRO',NULL,1,'2023-10-31 12:01:00','2023-10-31 12:01:00',NULL),(136,7941,40869,203034,5,136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',49337.04,'BANCO MACRO 1',NULL,1,'2023-10-31 12:07:14','2023-10-31 12:07:14',NULL),(137,7941,40869,203034,5,137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2176582.52,'BANCO SANTANDER',NULL,1,'2023-10-31 12:07:24','2023-10-31 12:07:24',NULL),(138,7941,40869,203034,5,138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',27888.64,'BANCO SANTANDER 1',NULL,1,'2023-10-31 12:07:32','2023-10-31 12:07:32',NULL),(139,7941,40869,203034,3,139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6708402.95,'SUBDIARIO COMPRAS',NULL,1,'2023-10-31 12:10:48','2024-05-02 16:04:49','2024-05-02 16:04:49'),(140,7941,40869,203034,2,140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7899391.00,'SUBDIARIO VENTAS',NULL,1,'2023-10-31 12:12:19','2023-10-31 12:12:19',NULL),(141,7941,40869,203034,20,141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',298800.00,'CREDITOS',NULL,1,'2023-10-31 12:14:50','2024-05-02 15:58:03','2024-05-02 15:58:03'),(142,7941,40869,203035,5,142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',506960.00,'BANCO SANTANDER',NULL,1,'2023-10-31 12:16:32','2024-05-02 16:01:43','2024-05-02 16:01:43'),(143,7941,40869,203035,5,143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',5468.11,'BANCO SANTANDER 1',NULL,1,'2023-10-31 12:20:16','2023-10-31 12:20:16',NULL),(144,7941,40869,203035,5,144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',63902.95,'BANCO MACRO',NULL,1,'2023-10-31 12:21:35','2023-10-31 12:21:35',NULL),(145,7941,40869,203035,5,145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4770069.11,'BANCO MACRO 1',NULL,1,'2023-10-31 12:23:43','2023-10-31 12:23:43',NULL),(146,7941,40869,203035,3,146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',5434053.51,'SUBDIARIO COMPRAS',NULL,1,'2023-10-31 12:26:02','2024-05-02 16:06:23','2024-05-02 16:06:23'),(147,7941,40869,203035,2,147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6402867.00,'SUBDIARIO VENTAS',NULL,1,'2023-10-31 12:26:57','2023-10-31 12:26:57',NULL),(148,7941,40869,203035,20,148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',56700.00,'CREDITOS',NULL,1,'2023-10-31 12:27:54','2023-10-31 12:27:54',NULL),(149,7941,40869,203036,5,149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1986844.80,'BANCO SANTANDER',NULL,1,'2023-10-31 12:32:32','2023-10-31 12:32:32',NULL),(150,7941,40869,203036,5,150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',111015.53,'BANCO SANTANDER 1',NULL,1,'2023-10-31 12:34:30','2023-10-31 12:36:54','2023-10-31 12:36:54'),(151,7941,40869,203036,5,151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',274568.73,'BANCO MACRO',NULL,1,'2023-10-31 12:36:36','2023-10-31 12:36:36',NULL),(152,7941,40869,203036,5,152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',111015.53,'BANCO SANTANDER 1',NULL,1,'2023-10-31 12:36:54','2023-10-31 12:36:54',NULL);
INSERT INTO `balance_libro` VALUES (153,7941,40869,203036,5,153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4606799.06,'BANCO MACRO 1',NULL,1,'2023-10-31 12:39:16','2023-10-31 12:39:16',NULL),(154,7941,40869,203036,3,154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',3351270.48,'SUBDIARIO COMPRAS',NULL,1,'2023-10-31 12:41:31','2023-10-31 12:41:31',NULL),(155,7941,40869,203036,2,155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',6164027.00,'SUBDIARIO VENTAS',NULL,1,'2023-10-31 12:42:32','2023-10-31 12:42:32',NULL),(156,7941,40869,203036,20,156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',255551.20,'CREDITOS',NULL,1,'2023-10-31 12:43:16','2023-10-31 12:43:16',NULL),(157,7941,40869,203034,16,157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',172444.54,'DJ IIBB',NULL,1,'2023-10-31 12:51:39','2023-10-31 12:55:32','2023-10-31 12:55:32'),(158,7941,40869,203034,16,158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',172444.54,'DJ IIBB',NULL,1,'2023-10-31 12:55:32','2023-10-31 13:01:47','2023-10-31 13:01:47'),(159,7941,40869,203034,16,159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',172444.54,'DJ IIBB',NULL,1,'2023-10-31 13:01:47','2023-10-31 13:01:47',NULL),(160,7941,40869,203035,16,160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',145141.47,'DJ IIBB',NULL,1,'2023-10-31 13:03:00','2023-10-31 13:03:00',NULL),(161,7941,40869,203036,16,161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',327109.67,'DJ IIBB',NULL,1,'2023-10-31 13:05:41','2023-10-31 13:05:41',NULL),(162,7941,40869,203033,15,162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',34933.66,'DJ IVA',NULL,1,'2023-10-31 13:09:20','2023-10-31 13:09:20',NULL),(163,7941,40869,203034,15,163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1420158.24,'DJ IVA',NULL,1,'2023-10-31 13:10:50','2023-10-31 13:10:50',NULL),(164,7941,40869,203035,15,164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1111241.43,'DJ IVA',NULL,1,'2023-10-31 13:12:37','2023-10-31 13:12:37',NULL),(165,7941,40869,203036,15,165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1069789.87,'DJ IVA',NULL,1,'2023-10-31 13:13:25','2023-10-31 13:13:25',NULL),(166,7941,40869,203033,1,166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1092078.36,'SUELDOS',NULL,1,'2023-10-31 13:16:03','2023-10-31 13:16:03',NULL),(167,7941,40869,203034,1,167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1012078.36,'SUELDOS',NULL,1,'2023-10-31 13:19:56','2023-10-31 13:19:56',NULL),(168,7941,40869,203035,1,168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1416878.36,'SUELDOS',NULL,1,'2023-10-31 13:22:36','2023-10-31 13:22:36',NULL),(169,7941,40869,203036,1,169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1416878.36,'SUELDOS',NULL,1,'2023-10-31 13:24:16','2023-10-31 13:24:16',NULL),(170,7941,40735,24263,3,170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',17324473.34,'Costo de Mercaderías Vendidas',NULL,1,'2024-01-02 15:15:17','2024-01-15 11:24:05','2024-01-15 11:24:05'),(171,7941,40735,24263,3,171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',17324473.34,'banco BBVA',NULL,1,'2024-01-02 15:17:54','2024-01-02 15:18:33','2024-01-02 15:18:33');
INSERT INTO `balance_libro` VALUES (172,7941,40735,24263,5,172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2100000.00,'Banco BBVA',NULL,1,'2024-01-02 15:18:07','2024-01-15 11:37:20','2024-01-15 11:37:20'),(173,7941,40735,24263,7,173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2860337.15,'Retenciones Sufridas',NULL,1,'2024-01-02 15:34:43','2024-01-15 11:38:30','2024-01-15 11:38:30'),(174,7941,40735,24263,5,174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',22719.04,'Gastos Bancarios',NULL,1,'2024-01-02 15:36:43','2024-01-15 11:39:03','2024-01-15 11:39:03'),(175,7941,40735,24263,9,175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',247495.75,'Compensacion anticipos de ganancias',NULL,1,'2024-01-02 15:39:49','2024-01-15 11:39:34','2024-01-15 11:39:34'),(176,7941,40735,24263,5,176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',583986.12,'Impuesto al debito y credito bancario',NULL,1,'2024-01-02 15:41:58','2024-01-15 11:40:04','2024-01-15 11:40:04'),(177,7941,40735,24263,19,177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1334896.66,'Proveedores',NULL,1,'2024-01-02 15:54:00','2024-01-15 11:40:39','2024-01-15 11:40:39'),(178,7941,40735,24263,15,178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',644636.62,'IVA',NULL,1,'2024-01-02 15:56:47','2024-01-15 11:41:12','2024-01-15 11:41:12'),(179,7941,40735,24263,19,179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',369372.28,'Impuestos,tasas y contribuciones',NULL,1,'2024-01-02 15:59:47','2024-01-15 11:41:41','2024-01-15 11:41:41'),(180,7941,40735,24263,4,180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2387334.93,'Amortizacion del ejercicio',NULL,1,'2024-01-02 16:04:40','2024-01-15 11:42:43','2024-01-15 11:42:43'),(181,7941,40735,24263,19,181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',660055.00,'Bienes de uso',NULL,1,'2024-01-02 16:06:10','2024-01-15 11:44:06','2024-01-15 11:44:06'),(182,7941,40735,24263,19,182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',17117.33,'Bienes de uso',NULL,1,'2024-01-02 16:08:02','2024-01-15 11:46:18','2024-01-15 11:46:18'),(183,7941,40735,24263,1,183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1373754.77,'Sueldos y cargas sociales',NULL,1,'2024-01-02 16:12:22','2024-01-15 11:45:27','2024-01-15 11:45:27'),(184,7941,40735,24263,6,184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1660664.45,'Impuestos a las ganancias',NULL,1,'2024-01-02 16:20:30','2024-01-15 11:43:41','2024-01-15 11:43:41'),(185,7941,40735,24263,16,185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',119670.09,'Ingresos brutos',NULL,1,'2024-01-02 16:24:10','2024-01-15 11:44:36','2024-01-15 11:44:36'),(186,7941,40735,24263,23,186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',12530472.90,'Ajustes por inflación bienes de uso',NULL,1,'2024-01-02 16:31:58','2024-01-15 11:45:01','2024-01-15 11:45:01'),(187,7941,40735,24263,23,187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1303996.40,'Ajuste por inflación amortización del equipo',NULL,1,'2024-01-02 16:33:55','2024-01-15 11:45:52','2024-01-15 11:45:52'),(188,7941,40735,24263,23,188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',6201222.10,'Ajuste por inflacion cuentas de PN',NULL,1,'2024-01-02 16:42:35','2024-01-15 11:43:12','2024-01-15 11:43:12');
INSERT INTO `balance_libro` VALUES (189,7941,40735,24263,23,189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',18600314.52,'Ajuste por inflacion ventas',NULL,1,'2024-01-02 16:43:51','2024-01-15 11:36:48','2024-01-15 11:36:48'),(190,7941,40735,24263,23,190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',7313546.67,'Ajuste por inflacion cuentas de gastos',NULL,1,'2024-01-02 16:51:07','2024-01-15 11:32:38','2024-01-15 11:32:38'),(191,7941,40735,24248,3,191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',17324473.34,'Costo de Mercaderías Vendidas',NULL,1,'2024-01-15 11:24:05','2024-01-15 11:24:05',NULL),(192,7941,40735,24248,23,192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7313546.67,'Ajuste por inflacion cuentas de gastos',NULL,1,'2024-01-15 11:32:38','2024-01-15 11:32:38',NULL),(193,7941,40735,24248,23,193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',18600314.52,'Ajuste por inflacion ventas',NULL,1,'2024-01-15 11:36:48','2024-01-15 11:36:48',NULL),(194,7941,40735,24248,5,194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2100000.00,'Banco BBVA',NULL,1,'2024-01-15 11:37:20','2024-01-15 11:37:20',NULL),(195,7941,40735,24263,7,195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2860337.15,'Retenciones Sufridas',NULL,1,'2024-01-15 11:38:30','2024-01-15 11:42:14','2024-01-15 11:42:14'),(196,7941,40735,24248,5,196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',22719.04,'Gastos Bancarios',NULL,1,'2024-01-15 11:39:03','2024-01-15 11:39:03',NULL),(197,7941,40735,24248,9,197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',247495.75,'Compensacion anticipos de ganancias',NULL,1,'2024-01-15 11:39:34','2024-01-15 11:39:34',NULL),(198,7941,40735,24248,5,198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',583986.12,'Impuesto al debito y credito bancario',NULL,1,'2024-01-15 11:40:04','2024-01-15 11:40:04',NULL),(199,7941,40735,24248,19,199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1334896.66,'Proveedores',NULL,1,'2024-01-15 11:40:39','2024-01-15 11:40:39',NULL),(200,7941,40735,24248,15,200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',644636.62,'IVA',NULL,1,'2024-01-15 11:41:12','2024-01-15 11:41:12',NULL),(201,7941,40735,24248,19,201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',369372.28,'Impuestos,tasas y contribuciones',NULL,1,'2024-01-15 11:41:41','2024-01-16 07:44:52','2024-01-16 07:44:52'),(202,7941,40735,24248,7,202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2860337.15,'Retenciones Sufridas',NULL,1,'2024-01-15 11:42:14','2024-01-15 11:42:14',NULL),(203,7941,40735,24248,4,203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2387334.93,'Amortizacion del ejercicio',NULL,1,'2024-01-15 11:42:43','2024-01-15 11:42:43',NULL),(204,7941,40735,24248,23,204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6201222.10,'Ajuste por inflacion cuentas de PN',NULL,1,'2024-01-15 11:43:12','2024-01-15 11:43:12',NULL),(205,7941,40735,24248,6,205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1660664.45,'Impuestos a las ganancias',NULL,1,'2024-01-15 11:43:41','2024-01-15 11:43:41',NULL),(206,7941,40735,24248,19,206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',660055.00,'Bienes de uso',NULL,1,'2024-01-15 11:44:06','2024-01-15 11:44:06',NULL);
INSERT INTO `balance_libro` VALUES (207,7941,40735,24248,16,207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',119670.09,'Ingresos brutos',NULL,1,'2024-01-15 11:44:36','2024-01-15 11:44:36',NULL),(208,7941,40735,24248,23,208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12530472.90,'Ajustes por inflación bienes de uso',NULL,1,'2024-01-15 11:45:01','2024-01-15 11:45:01',NULL),(209,7941,40735,24248,1,209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1373754.77,'Sueldos y cargas sociales',NULL,1,'2024-01-15 11:45:27','2024-01-15 11:45:27',NULL),(210,7941,40735,24248,23,210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1303996.40,'Ajuste por inflación amortización del equipo',NULL,1,'2024-01-15 11:45:52','2024-01-15 11:45:52',NULL),(211,7941,40735,24248,19,211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',17117.33,'Bienes de uso',NULL,1,'2024-01-15 11:46:18','2024-01-15 11:46:18',NULL),(212,7941,40735,24248,19,212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',369372.28,'Impuestos,tasas y contribuciones',NULL,1,'2024-01-16 07:44:52','2024-01-16 07:44:52',NULL),(213,7941,40735,24248,18,213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',140256.32,'Reclasificación de cuentas',NULL,1,'2024-01-16 07:49:25','2024-01-16 07:49:25',NULL),(214,7941,40735,24248,17,214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',35618298.03,NULL,NULL,1,'2024-01-16 10:47:19','2024-01-16 10:48:42','2024-01-16 10:48:42'),(215,7941,40735,24248,17,215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',35618298.03,NULL,NULL,1,'2024-01-16 10:48:42','2024-01-16 11:18:41','2024-01-16 11:18:41'),(216,7941,40735,24248,17,216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',65471893.57,NULL,NULL,1,'2024-01-16 11:10:09','2024-01-16 11:10:09',NULL),(217,7941,40735,24248,17,217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',35618298.03,NULL,NULL,1,'2024-01-16 11:18:41','2024-01-16 11:18:41',NULL),(218,7941,40735,24252,12,218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',35618298.03,'asiento de inicio de jercicio',NULL,1,'2024-01-18 10:48:34','2025-04-04 13:13:11','2025-04-04 13:13:11'),(219,7941,40735,24252,2,219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16885497.99,'SUBDIARIO VENTAS 01-2023',NULL,1,'2024-01-18 10:52:18','2024-01-18 10:52:18',NULL),(220,7941,40735,24252,15,220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2930540.97,'DJ IVA 01-2023',NULL,1,'2024-01-18 10:55:03','2024-01-18 11:10:01','2024-01-18 11:10:01'),(221,7941,40735,24253,2,221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1611179.13,'SUBDIARIO VENTAS 02-2023',NULL,1,'2024-01-18 10:57:03','2024-01-18 10:57:03',NULL),(222,7941,40735,24253,15,222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2356764.62,'DJ IVA 02-2023',NULL,1,'2024-01-18 11:00:37','2024-01-18 11:08:52','2024-01-18 11:08:52'),(223,7941,40735,24254,2,223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5177180.10,'SUBDIARIO VENTAS 03-2023',NULL,1,'2024-01-18 11:01:54','2024-01-18 11:01:54',NULL),(224,7941,40735,24254,15,224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1684379.54,'DJ IVA 03-2023',NULL,1,'2024-01-18 11:07:34','2024-01-18 11:07:34',NULL);
INSERT INTO `balance_libro` VALUES (225,7941,40735,24253,15,225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2356764.62,'DJ IVA 02-2023',NULL,1,'2024-01-18 11:08:52','2024-01-18 11:08:52',NULL),(226,7941,40735,24252,15,226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2930540.97,'DJ IVA 01-2023',NULL,1,'2024-01-18 11:10:01','2024-01-18 11:10:01',NULL),(227,7941,40735,24255,2,227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3535368.32,'SUBDIARIO VENTAS 04-2023',NULL,1,'2024-01-18 11:11:29','2024-01-18 11:11:29',NULL),(228,7941,40735,24255,15,228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1086195.50,'DJ IVA 04-2023',NULL,1,'2024-01-18 11:14:35','2024-01-18 11:14:35',NULL),(229,7941,40735,24256,2,229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',628716.00,'SUBDIARIO VENTAS 05-2023',NULL,1,'2024-01-18 11:15:50','2024-01-18 11:15:50',NULL),(230,7941,40735,24256,15,230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1411788.56,'DJ IVA 05-2023',NULL,1,'2024-01-18 11:18:29','2024-01-18 11:18:29',NULL),(231,7941,40735,24257,2,231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',14737263.33,'SUBDIARIO VENTAS 06-2023',NULL,1,'2024-01-18 11:21:29','2024-01-18 11:21:29',NULL),(232,7941,40735,24257,15,232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2557706.86,'DJ IVA 06-2023',NULL,1,'2024-01-18 11:24:08','2024-01-18 11:24:08',NULL),(233,7941,40735,24258,2,233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5631088.32,'SUBDIARIO VENTAS 07-2023',NULL,1,'2024-01-18 11:25:31','2024-01-18 11:25:31',NULL),(234,7941,40735,24258,15,234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1366836.10,'DJ IVA 07-2023',NULL,1,'2024-01-18 11:28:03','2024-01-18 11:28:03',NULL),(235,7941,40735,24259,2,235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',14332571.00,'SUBDIARIO VENTAS 08-2023',NULL,1,'2024-01-18 11:29:27','2024-01-18 11:29:27',NULL),(236,7941,40735,24259,15,236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',2487471.00,'DJ IVA 08-2023',NULL,1,'2024-01-18 11:32:18','2024-01-18 11:32:18',NULL),(237,7941,40735,24260,2,237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5653749.20,'SUBDIARIO VENTAS 09-2023',NULL,1,'2024-01-18 11:33:41','2024-01-18 11:33:41',NULL),(238,7941,40735,24260,15,238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1260164.78,'DJ IVA 09-2023',NULL,1,'2024-01-18 11:35:41','2024-01-18 11:35:41',NULL),(239,7941,40735,24261,2,239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',22452176.30,'SUBDIARIO VENTAS 10-2023',NULL,1,'2024-01-18 11:38:30','2024-01-18 11:38:30',NULL),(240,7941,40735,24261,15,240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4420425.28,'DJ IVA 10-2023',NULL,1,'2024-01-18 11:41:17','2024-01-18 11:41:17',NULL),(241,7941,40735,24262,2,241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',10639540.82,'SUBDIARIO VENTAS 11-2023',NULL,1,'2024-01-18 11:43:17','2024-01-18 11:43:17',NULL),(242,7941,40735,24262,15,242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2583266.62,'DJ IVA 11-2023',NULL,1,'2024-01-18 11:46:02','2024-01-18 11:46:02',NULL);
INSERT INTO `balance_libro` VALUES (243,7941,40735,24263,2,243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',14924001.89,'SUBDIARIO VENTAS 12-2023',NULL,1,'2024-01-18 11:47:19','2024-01-18 11:47:19',NULL),(244,7941,40735,24263,15,244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2590116.03,'DJ IVA 12-2023',NULL,1,'2024-01-18 11:49:37','2024-05-06 15:36:17','2024-05-06 15:36:17'),(245,7941,40735,24252,16,245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',348873.83,'DJ IIBB 01-2023',NULL,1,'2024-01-18 11:59:43','2024-01-18 11:59:43',NULL),(246,7941,40735,24253,16,246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',66728.07,'DJ IIBB 02-2023',NULL,1,'2024-01-18 12:02:23','2024-01-18 12:02:23',NULL),(247,7941,40735,24254,16,247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',121351.91,'DJ IIBB 03-2023',NULL,1,'2024-01-18 12:05:30','2024-01-18 12:05:30',NULL),(248,7941,40735,24255,16,248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',77422.65,'DJ IIBB 04-2023',NULL,1,'2024-01-18 12:08:34','2024-01-18 12:08:34',NULL),(249,7941,40735,24256,16,249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',74157.23,'DJ IIBB 05-2023',NULL,1,'2024-01-18 12:11:14','2024-01-18 12:11:14',NULL),(250,7941,40735,24257,16,250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',377650.79,'DJ IIBB 06-2023',NULL,1,'2024-01-18 12:13:51','2024-01-18 12:13:51',NULL),(251,7941,40735,24258,16,251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',268974.58,'DJ IIBB 07-2023',NULL,1,'2024-01-18 12:15:53','2024-01-18 12:15:53',NULL),(252,7941,40735,24259,16,252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',365042.09,'DJ IIBB 08-2023',NULL,1,'2024-01-18 12:18:04','2024-01-18 12:18:04',NULL),(253,7941,40735,24260,16,253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',205702.49,'DJ IIBB 09-2023',NULL,1,'2024-01-18 12:19:50','2024-01-18 12:19:50',NULL),(254,7941,40735,24261,16,254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',618566.35,'DJ IIBB 10-2023',NULL,1,'2024-01-18 12:22:01','2024-01-18 12:22:01',NULL),(255,7941,40735,24262,16,255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',440668.79,'DJ IIBB 11-2023',NULL,1,'2024-01-18 12:24:04','2024-01-18 12:24:04',NULL),(256,7941,40735,24263,16,256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',375434.70,'DJ IIBB 12-2023',NULL,1,'2024-01-18 12:26:29','2024-01-18 12:26:29',NULL),(257,7941,40869,203037,2,257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',6068932.56,'SUBDIARIO VENTAS 10-2023',NULL,1,'2024-01-18 13:27:21','2024-01-18 13:27:21',NULL),(258,7941,40869,203038,2,258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',8166445.46,'SUBDIARIO VENTAS 11-2023',NULL,1,'2024-01-18 13:28:52','2024-01-18 13:28:52',NULL),(259,7941,40869,203039,2,259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',7087822.14,'SUBDIARIO VENTAS 12-2023',NULL,1,'2024-01-18 13:30:10','2024-01-18 13:30:10',NULL),(260,7941,40869,203037,15,260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1053285.82,'DJ IVA 10-2023',NULL,1,'2024-01-18 13:32:30','2024-01-18 13:32:30',NULL);
INSERT INTO `balance_libro` VALUES (261,7941,40869,203038,15,261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1417316.98,'DJ IVA 11-2023',NULL,1,'2024-01-18 13:34:32','2024-01-18 13:34:32',NULL),(262,7941,40869,203039,15,262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1230214.74,'DJ IVA 12-2023',NULL,1,'2024-01-18 13:36:49','2024-01-18 13:36:49',NULL),(263,7941,40869,203037,16,263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',457277.66,'DJ IIBB 10-2023',NULL,1,'2024-01-18 13:40:12','2024-01-18 13:40:12',NULL),(264,7941,40869,203038,16,264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',404545.83,'DJ IIBB 11-2023',NULL,1,'2024-01-18 13:42:55','2024-01-18 13:42:55',NULL),(265,7941,40869,203039,16,265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',280971.66,'DJ IIBB 12-2023',NULL,1,'2024-01-18 13:45:02','2024-05-02 15:32:14','2024-05-02 15:32:14'),(266,7941,40869,203037,20,266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',177959.95,'CREDITOS',NULL,1,'2024-01-18 15:01:23','2024-01-18 15:01:23',NULL),(267,7941,40869,203037,3,267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',5496546.64,'SUBDIARIO COMPRAS 10-2023',NULL,1,'2024-01-18 15:04:54','2024-01-18 15:04:54',NULL),(268,7941,40869,203037,5,268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4319446.28,'BANCO MACRO 1',NULL,1,'2024-01-18 15:08:26','2024-05-02 15:46:22','2024-05-02 15:46:22'),(269,7941,40869,203037,5,269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',256952.65,'BANCO MACRO',NULL,1,'2024-01-18 15:12:12','2024-01-18 15:12:12',NULL),(270,7941,40869,203037,5,270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',74902.11,'BANCO SANTANDER 1',NULL,1,'2024-01-18 15:14:49','2024-01-18 15:14:49',NULL),(271,7941,40869,203037,5,271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1308228.40,'BANCO SANTANDER',NULL,1,'2024-01-18 15:17:13','2024-01-18 15:17:13',NULL),(272,7941,40869,203038,20,272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',216823.38,'CREDITOS',NULL,1,'2024-01-18 15:27:34','2024-01-18 15:27:34',NULL),(273,7941,40869,203039,20,273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',265650.00,'CREDITOS',NULL,1,'2024-01-18 15:40:25','2024-01-18 15:40:25',NULL),(274,7941,40869,203039,3,274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',5240513.72,'SUBDIARIO COMPRAS 12-2023',NULL,1,'2024-01-18 15:45:22','2024-01-18 15:45:22',NULL),(275,7941,40869,203039,5,275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',5335486.85,'BANCO MACRO 1',NULL,1,'2024-01-18 16:16:54','2024-05-02 15:38:29','2024-05-02 15:38:29'),(276,7941,40869,203039,5,276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',78377.75,'BANCO MACRO',NULL,1,'2024-01-18 16:18:55','2024-01-18 16:18:55',NULL),(277,7941,40869,203039,5,277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',24091.39,'BANCO SANTANDER 1',NULL,1,'2024-01-18 16:20:08','2024-05-02 15:54:41','2024-05-02 15:54:41'),(278,7941,40869,203039,5,278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2104390.42,'BANCO SANTANDER',NULL,1,'2024-01-18 16:22:14','2024-05-02 15:35:11','2024-05-02 15:35:11');
INSERT INTO `balance_libro` VALUES (279,7941,40869,203038,3,279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6352687.36,'SUBDIARIO COMPRAS 11-2023',NULL,1,'2024-01-18 16:25:01','2024-01-18 16:25:01',NULL),(280,7941,40869,203038,5,280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',29630.13,'BANCO SANTANDER 1',NULL,1,'2024-01-18 16:27:28','2024-01-18 16:27:28',NULL),(281,7941,40869,203038,5,281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1616595.24,'BANCO SANTANDER',NULL,1,'2024-01-18 16:29:02','2024-01-18 16:29:02',NULL),(282,7941,40870,204550,16,282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6525158.08,'DJ IIBB 01-2023',NULL,1,'2024-01-19 08:40:59','2024-01-19 08:40:59',NULL),(283,7941,40870,204551,16,283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6526484.31,'DJ IIBB 02-2023',NULL,1,'2024-01-19 08:42:21','2024-01-19 08:42:21',NULL),(284,7941,40870,204552,16,284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',7094920.72,'DJ IIBB 03-2023',NULL,1,'2024-01-19 08:43:57','2024-01-19 08:43:57',NULL),(285,7941,40870,204553,16,285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',7967848.88,'DJ IIBB 04-2023',NULL,1,'2024-01-19 08:45:10','2024-01-19 08:45:10',NULL),(286,7941,40870,204554,16,286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8759073.52,'DJ IIBB 05-2023',NULL,1,'2024-01-19 08:47:10','2024-01-19 08:47:10',NULL),(287,7941,40870,204555,16,287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9526883.99,'DJ IIBB 06-2023',NULL,1,'2024-01-19 08:48:39','2024-01-19 08:48:39',NULL),(288,7941,40870,204556,16,288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10636983.75,'DJ IIBB 07-2023',NULL,1,'2024-01-19 08:50:17','2024-01-19 08:50:17',NULL),(289,7941,40870,204557,16,289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',11448325.95,'DJ IIBB 08-2023',NULL,1,'2024-01-19 08:51:41','2024-01-19 08:51:41',NULL),(290,7941,40870,204558,16,290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',12034634.66,'DJ IIBB 09-2023',NULL,1,'2024-01-19 08:53:11','2024-01-19 08:53:11',NULL),(291,7941,40870,204559,16,291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',13283454.07,'DJ IIBB 10-2023',NULL,1,'2024-01-19 08:54:35','2024-01-19 08:54:35',NULL),(292,7941,40870,204560,16,292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',14089971.95,'DJ IIBB 11-2023',NULL,1,'2024-01-19 08:56:02','2024-01-19 08:56:02',NULL),(293,7941,40870,204561,16,293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',15097932.10,'DJ IIBB 12-2023',NULL,1,'2024-01-19 08:57:12','2024-01-19 08:57:12',NULL),(294,7941,40870,204550,15,294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',33285696.62,'DJ IVA 01-2023',NULL,1,'2024-01-19 14:30:12','2024-01-19 14:30:12',NULL),(295,7941,40870,204551,15,295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',33649430.58,'DJ IVA 02-2023',NULL,1,'2024-01-19 14:32:24','2024-01-19 14:32:24',NULL),(296,7941,40870,204552,15,296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',42491255.31,'DJ IVA 03-2023',NULL,1,'2024-01-19 14:35:36','2024-01-19 14:35:36',NULL);
INSERT INTO `balance_libro` VALUES (297,7941,40870,204553,15,297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',50247268.68,'DJ IVA 04-2023',NULL,1,'2024-01-19 14:37:28','2024-01-19 14:37:28',NULL),(298,7941,40870,204554,15,298,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',53492295.81,'DJ IVA 05-2023',NULL,1,'2024-01-19 14:39:29','2024-01-19 14:39:29',NULL),(299,7941,40870,204555,15,299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',61434537.35,'DJ IVA 06-2023',NULL,1,'2024-01-19 14:41:15','2024-01-19 14:41:15',NULL),(300,7941,40870,204556,15,300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',67639512.88,'DJ IVA 07-2023',NULL,1,'2024-01-19 14:43:07','2024-01-19 14:43:07',NULL),(301,7941,40870,204557,15,301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',73485084.92,'DJ IVA 08-2023',NULL,1,'2024-01-19 14:45:13','2024-01-19 14:45:13',NULL),(302,7941,40870,204558,15,302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',78407861.60,'DJ IVA 09-2023',NULL,1,'2024-01-19 14:47:10','2024-01-19 14:47:10',NULL),(303,7941,40870,204559,15,303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',94807415.40,'DJ IVA 10-2023',NULL,1,'2024-01-19 14:49:16','2024-01-19 14:49:16',NULL),(304,7941,40870,204560,15,304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',103776578.81,'DJ IVA 11-2023',NULL,1,'2024-01-19 14:51:12','2024-01-19 14:51:12',NULL),(305,7941,40870,204561,15,305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',109902404.56,'DJ IVA 12-2023',NULL,1,'2024-01-19 14:54:13','2024-01-19 14:54:13',NULL),(306,7941,40771,77286,2,306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2960144.00,'SUBDIARIO VENTAS 01-2023',NULL,1,'2024-01-23 10:51:58','2025-02-21 15:45:14','2025-02-21 15:45:14'),(307,7941,40771,77286,15,307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',513744.00,'DJ IVA 01-2023',NULL,1,'2024-01-23 10:53:51','2025-02-21 15:45:14','2025-02-21 15:45:14'),(308,7941,40771,77287,2,308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3210038.00,'SUBDIARIO VENTAS 02-2023',NULL,1,'2024-01-23 10:55:13','2025-02-21 15:45:14','2025-02-21 15:45:14'),(309,7941,40771,77287,15,309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',562635.71,'DJ IVA 02-2023',NULL,1,'2024-01-23 10:57:09','2025-02-21 15:45:14','2025-02-21 15:45:14'),(310,7941,40771,77288,2,310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3336806.00,'SUBDIARIO VENTAS 03-2023',NULL,1,'2024-01-23 10:58:12','2025-02-21 15:45:14','2025-02-21 15:45:14'),(311,7941,40771,77288,15,311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',971412.40,'DJ IVA 03-2023',NULL,1,'2024-01-23 11:01:39','2025-02-21 15:45:14','2025-02-21 15:45:14'),(312,7941,40771,77289,2,312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',5891840.00,'SUBDIARIO VENTAS 04-2023',NULL,1,'2024-01-23 11:02:54','2024-01-23 11:02:54',NULL),(313,7941,40771,77289,15,313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1390155.08,'DJ IVA 04-2023',NULL,1,'2024-01-23 11:06:36','2024-01-23 11:06:36',NULL),(314,7941,40771,77290,2,314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6299487.01,'SUBDIARIO VENTAS 05-2023',NULL,1,'2024-01-23 11:07:51','2024-01-23 11:07:51',NULL);
INSERT INTO `balance_libro` VALUES (315,7941,40771,77290,15,315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1167761.29,'DJ IVA 05-2023',NULL,1,'2024-01-23 11:10:09','2024-01-23 11:10:09',NULL),(316,7941,40771,77291,2,316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7039620.02,'SUBDIARIO VENTAS 06-2023',NULL,1,'2024-01-23 11:11:24','2024-01-23 11:11:24',NULL),(317,7941,40771,77291,15,317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1196156.46,'DJ IVA 06-2023',NULL,1,'2024-01-23 11:12:51','2024-01-23 11:12:51',NULL),(318,7941,40771,77292,2,318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7678872.99,'SUBDIARIO VENTAS 07-2023',NULL,1,'2024-01-23 11:14:15','2024-01-23 11:14:15',NULL),(319,7941,40771,77292,15,319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1361865.53,'DJ IVA 07-2023',NULL,1,'2024-01-23 11:15:41','2024-01-23 11:15:41',NULL),(320,7941,40771,77293,2,320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',8671529.01,'SUBDIARIO VENTAS 08-2023',NULL,1,'2024-01-23 11:16:50','2024-01-23 11:16:50',NULL),(321,7941,40771,77293,15,321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1462461.52,'DJ IVA 08-2023',NULL,1,'2024-01-23 11:18:14','2024-01-23 11:18:14',NULL),(322,7941,40771,77294,2,322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',10241245.26,'SUBDIARIO VENTAS 09-2023',NULL,1,'2024-01-23 11:19:27','2024-01-23 11:19:27',NULL),(323,7941,40771,77294,15,323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2674586.18,'DJ IVA 09-2023',NULL,1,'2024-01-23 11:21:24','2024-01-23 11:21:24',NULL),(324,7941,40771,77295,2,324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',14125919.96,'SUBDIARIO VENTAS 10-2023',NULL,1,'2024-01-23 11:22:38','2024-01-23 11:22:38',NULL),(325,7941,40771,77295,15,325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',2616635.20,'DJ IVA 10-2023',NULL,1,'2024-01-23 11:24:55','2024-01-23 11:24:55',NULL),(326,7941,40771,77296,2,326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',12545402.00,'SUBDIARIO VENTAS 11-2023',NULL,1,'2024-01-23 11:26:03','2024-01-23 11:26:03',NULL),(327,7941,40771,77296,15,327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2233290.35,'DJ IVA 11-2023',NULL,1,'2024-01-23 11:27:19','2024-01-23 11:27:19',NULL),(328,7941,40771,77297,2,328,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',10257886.96,'SUBDIARIO VENTAS 12-2023',NULL,1,'2024-01-23 11:28:22','2024-01-23 11:28:22',NULL),(329,7941,40771,77297,15,329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1729326.39,'DJ IVA 12-2023',NULL,1,'2024-01-23 11:29:24','2024-01-23 11:29:24',NULL),(330,7941,40735,24252,3,330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6171447.21,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 12:08:39','2024-03-26 12:08:39',NULL),(331,7941,40735,24253,3,331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9841723.80,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 12:19:39','2024-03-26 12:19:39',NULL),(332,7941,40735,24254,3,332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2012361.16,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 12:24:54','2024-03-26 12:24:54',NULL);
INSERT INTO `balance_libro` VALUES (333,7941,40735,24255,3,333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1885800.05,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 12:48:20','2024-03-26 12:48:20',NULL),(334,7941,40735,24256,3,334,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5597805.49,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 14:55:25','2024-03-26 14:55:25',NULL),(335,7941,40735,24257,3,335,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4494692.22,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 15:01:22','2024-03-26 15:01:22',NULL),(336,7941,40735,24258,3,336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',8059225.00,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 15:04:42','2024-03-26 15:04:42',NULL),(337,7941,40735,24259,3,337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',10617713.76,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 15:10:35','2024-03-26 15:10:35',NULL),(338,7941,40735,24260,3,338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',7852604.89,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 15:13:38','2024-03-26 15:13:38',NULL),(339,7941,40735,24261,3,339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',24488168.12,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 15:18:40','2024-03-26 15:18:40',NULL),(340,7941,40735,24262,3,340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',12530572.91,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 15:21:58','2024-03-26 15:21:58',NULL),(341,7941,40735,24263,3,341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1350281.77,'SUBDIARIO COMPRAS',NULL,1,'2024-03-26 15:24:53','2024-03-26 15:24:53',NULL),(342,7941,40735,24252,5,342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1651463.51,'BANCO BBVA9023-8',NULL,1,'2024-04-18 10:31:42','2024-04-18 12:09:46','2024-04-18 12:09:46'),(343,7941,40735,24255,5,343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',995738.76,'BANCO BBVA9023-8',NULL,1,'2024-04-18 10:56:55','2024-04-18 12:09:33','2024-04-18 12:09:33'),(344,7941,40735,24253,5,344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5500846.30,'BANCO BBVA9023-8',NULL,1,'2024-04-18 11:04:14','2024-04-18 12:08:58','2024-04-18 12:08:58'),(345,7941,40735,24254,5,345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3163574.12,'BANCO BBVA9023-8',NULL,1,'2024-04-18 11:10:12','2024-04-18 12:08:43','2024-04-18 12:08:43'),(346,7941,40735,24256,5,346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2662428.46,'BANCO BBVA9023-8',NULL,1,'2024-04-18 11:48:56','2024-04-18 12:08:31','2024-04-18 12:08:31'),(347,7941,40735,24257,5,347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1362396.77,'BANCO BBVA9023-8',NULL,1,'2024-04-18 11:52:31','2024-04-18 12:08:20','2024-04-18 12:08:20'),(348,7941,40735,24258,5,348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',950000.00,'BANCO BBVA9023-8',NULL,1,'2024-04-18 11:57:04','2024-04-18 12:07:58','2024-04-18 12:07:58'),(349,7941,40735,24259,5,349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',564093.50,'BANCO BBVA9023-8',NULL,1,'2024-04-18 12:00:59','2024-04-18 12:07:47','2024-04-18 12:07:47'),(350,7941,40735,24260,5,350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',314000.00,'BANCO BBVA9023-8',NULL,1,'2024-04-18 12:04:31','2024-04-18 12:07:32','2024-04-18 12:07:32');
INSERT INTO `balance_libro` VALUES (351,7941,40735,24260,5,351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',314000.00,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:07:32','2024-04-18 12:08:11','2024-04-18 12:08:11'),(352,7941,40735,24259,5,352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',564093.50,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:07:47','2024-04-18 12:07:47',NULL),(353,7941,40735,24258,5,353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',950000.00,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:07:58','2024-04-18 12:07:58',NULL),(354,7941,40735,24260,5,354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',314000.00,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:08:11','2024-04-18 12:08:11',NULL),(355,7941,40735,24257,5,355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1362396.77,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:08:20','2024-04-18 12:08:20',NULL),(356,7941,40735,24256,5,356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2662428.46,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:08:31','2024-04-18 12:08:31',NULL),(357,7941,40735,24254,5,357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3163574.12,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:08:43','2024-04-18 12:08:43',NULL),(358,7941,40735,24253,5,358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5500846.30,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:08:58','2024-04-18 12:08:58',NULL),(359,7941,40735,24255,5,359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',995738.76,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:09:33','2024-04-18 12:09:33',NULL),(360,7941,40735,24252,5,360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1651463.51,'BANCO BBVA 9023-8',NULL,1,'2024-04-18 12:09:46','2024-04-18 12:09:46',NULL),(361,7941,40735,24252,5,361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2943608.74,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 12:25:41','2024-04-18 12:25:41',NULL),(362,7941,40735,24253,5,362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',10491103.85,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 12:31:36','2024-04-18 12:31:36',NULL),(363,7941,40735,24254,5,363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2339765.20,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 12:36:28','2024-04-18 12:36:28',NULL),(364,7941,40735,24255,5,364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3999445.85,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 12:49:27','2024-04-18 12:49:27',NULL),(365,7941,40735,24256,5,365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2406274.04,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 12:57:32','2024-04-18 12:57:32',NULL),(366,7941,40735,24257,5,366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',14513325.27,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 13:10:44','2024-04-18 13:10:44',NULL),(367,7941,40735,24258,5,367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',8820911.45,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 13:20:57','2024-04-18 13:20:57',NULL),(368,7941,40735,24259,5,368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',11623231.85,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 13:34:03','2024-04-18 13:34:03',NULL);
INSERT INTO `balance_libro` VALUES (369,7941,40735,24260,5,369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',11963297.68,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 13:39:33','2024-04-18 13:39:33',NULL),(370,7941,40735,24261,5,370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',19075339.35,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 13:45:12','2024-04-18 13:45:12',NULL),(371,7941,40735,24262,5,371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',17656816.06,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 13:56:08','2024-04-18 13:56:08',NULL),(372,7941,40735,24263,3,372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',13055571.02,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 15:14:34','2024-04-18 16:17:02','2024-04-18 16:17:02'),(373,7941,40735,24263,5,373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',13055571.02,'BANCO BBVA 2712-6',NULL,1,'2024-04-18 16:17:02','2024-04-18 16:17:02',NULL),(374,7941,40869,203037,1,374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1416956.72,'SUELDOS',NULL,1,'2024-04-22 11:25:01','2024-04-22 11:25:01',NULL),(375,7941,40869,203038,1,375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1619356.72,'SUELDOS',NULL,1,'2024-04-22 11:30:01','2024-04-22 11:30:01',NULL),(376,7941,40869,203039,1,376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2428956.72,'SUELDOS',NULL,1,'2024-04-22 11:35:16','2024-04-22 11:35:16',NULL),(377,7941,40735,24252,1,377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1218798.15,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:00:01','2024-04-23 12:00:01',NULL),(378,7941,40735,24253,1,378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1512223.86,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:02:19','2024-04-23 12:02:19',NULL),(379,7941,40735,24254,1,379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1378048.97,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:04:49','2024-04-23 12:04:49',NULL),(380,7941,40735,24255,1,380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1318168.13,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:08:14','2024-04-23 12:08:14',NULL),(381,7941,40735,24256,1,381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1883749.69,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:10:18','2024-04-23 12:10:18',NULL),(382,7941,40735,24257,1,382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1489418.32,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:12:37','2024-04-23 12:12:37',NULL),(383,7941,40735,24258,1,383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1074661.36,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:15:23','2024-04-23 12:15:23',NULL),(384,7941,40735,24259,1,384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1572887.41,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:17:18','2024-04-23 12:17:18',NULL),(385,7941,40735,24260,1,385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',806921.41,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:19:49','2024-04-23 12:19:49',NULL),(386,7941,40735,24261,1,386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',660946.28,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:22:03','2024-04-23 12:22:03',NULL);
INSERT INTO `balance_libro` VALUES (387,7941,40735,24262,1,387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',786040.12,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:24:32','2024-04-23 12:24:32',NULL),(388,7941,40735,24263,1,388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1309396.72,'Sueldos y Cargas Sociales',NULL,1,'2024-04-23 12:26:26','2024-04-23 12:26:26',NULL),(389,7941,40771,77286,16,389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',91866.60,'DJ IIBB',NULL,1,'2024-04-24 13:38:25','2024-04-24 13:38:25',NULL),(390,7941,40771,77287,16,390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',99560.09,'DJ IIBB',NULL,1,'2024-04-24 14:30:47','2024-04-24 14:30:47',NULL),(391,7941,40771,77288,16,391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',136878.47,'DJ IIBB',NULL,1,'2024-04-24 14:33:43','2024-04-24 14:36:52','2024-04-24 14:36:52'),(392,7941,40771,77289,16,392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',178036.92,'DJ IIBB',NULL,1,'2024-04-24 14:35:56','2024-04-24 14:35:56',NULL),(393,7941,40771,77288,16,393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',136878.47,'DJ IIBB',NULL,1,'2024-04-24 14:36:52','2024-04-24 14:36:52',NULL),(394,7941,40771,77290,16,394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',190135.33,'DJ IIBB',NULL,1,'2024-04-24 14:38:24','2024-04-24 14:38:24',NULL),(395,7941,40771,77291,16,395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',205395.74,'DJ IIBB',NULL,1,'2024-04-24 14:40:15','2024-04-24 14:40:15',NULL),(396,7941,40771,77292,16,396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',233227.15,'DJ IIBB',NULL,1,'2024-04-24 14:49:19','2024-04-24 14:49:19',NULL),(397,7941,40771,77293,16,397,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',255991.82,'DJ IIBB',NULL,1,'2024-04-24 14:50:52','2024-04-24 14:50:52',NULL),(398,7941,40771,77294,16,398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',473633.32,'DJ IIBB',NULL,1,'2024-04-24 14:52:19','2024-04-24 14:52:19',NULL),(399,7941,40771,77295,16,399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',508284.14,'DJ IIBB',NULL,1,'2024-04-24 14:55:57','2024-04-24 14:55:57',NULL),(400,7941,40771,77296,16,400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',368134.53,'DJ IIBB',NULL,1,'2024-04-24 14:57:18','2024-04-24 14:58:41','2024-04-24 14:58:41'),(401,7941,40771,77297,16,401,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',308626.56,'DJ IIBB',NULL,1,'2024-04-24 14:58:34','2024-04-24 14:58:34',NULL),(402,7941,40771,77296,16,402,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',368134.53,'DJ IIBB',NULL,1,'2024-04-24 14:58:41','2024-04-24 14:58:41',NULL),(403,7941,40771,77286,3,403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1037821.27,'Subdiario Compras',NULL,1,'2024-04-25 11:16:17','2024-04-25 11:16:29','2024-04-25 11:16:29'),(404,7941,40771,77286,3,404,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1037821.27,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:16:29','2024-05-02 16:03:41','2024-05-02 16:03:41'),(405,7941,40771,77287,3,405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2496286.41,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:24:02','2024-05-02 16:02:56','2024-05-02 16:02:56');
INSERT INTO `balance_libro` VALUES (406,7941,40771,77288,3,406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5805293.25,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:27:15','2024-05-02 16:02:22','2024-05-02 16:02:22'),(407,7941,40771,77289,3,407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6348037.28,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:29:28','2024-05-02 15:59:28','2024-05-02 15:59:28'),(408,7941,40771,77290,3,408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2757882.86,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:33:00','2024-05-02 15:58:38','2024-05-02 15:58:38'),(409,7941,40771,77291,3,409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3878091.33,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:36:56','2024-05-02 15:57:48','2024-05-02 15:57:48'),(410,7941,40771,77292,3,410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3010889.41,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:39:27','2024-05-02 15:56:37','2024-05-02 15:56:37'),(411,7941,40771,77293,3,411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',7184699.00,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:40:53','2024-05-02 15:55:53','2024-05-02 15:55:53'),(412,7941,40771,77294,3,412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',14980894.18,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:42:25','2024-05-02 15:55:15','2024-05-02 15:55:15'),(413,7941,40771,77295,3,413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',8790979.27,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:44:02','2024-05-02 15:54:31','2024-05-02 15:54:31'),(414,7941,40771,77296,3,414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5656239.83,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:46:10','2024-05-02 15:52:55','2024-05-02 15:52:55'),(415,7941,40771,77297,3,415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4931320.20,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 11:47:32','2024-05-02 15:52:15','2024-05-02 15:52:15'),(416,7941,40871,206080,16,416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',98146.48,'DJ IIBB',NULL,1,'2024-04-25 12:37:45','2024-04-25 12:37:45',NULL),(417,7941,40871,206081,16,417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',119146.31,'DJ IIBB',NULL,1,'2024-04-25 12:40:57','2024-04-25 12:40:57',NULL),(418,7941,40871,206080,2,418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3278094.74,'SUBDIARIO VENTAS',NULL,1,'2024-04-25 13:09:11','2024-04-25 13:09:11',NULL),(419,7941,40871,206081,2,419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3969330.62,'SUBDIARIO VENTAS',NULL,1,'2024-04-25 13:10:35','2024-04-25 13:10:35',NULL),(420,7941,40871,206080,15,420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',619343.69,'DJ IVA',NULL,1,'2024-04-25 13:17:56','2024-04-25 13:17:56',NULL),(421,7941,40871,206081,15,421,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',688892.09,'DJ IVA',NULL,1,'2024-04-25 13:21:26','2024-04-25 13:21:26',NULL),(422,7941,40871,206080,3,422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3669287.41,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 14:07:13','2024-04-26 14:55:19','2024-04-26 14:55:19'),(423,7941,40871,206081,3,423,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2711173.78,'SUBDIARIO COMPRAS',NULL,1,'2024-04-25 14:08:44','2024-04-26 14:53:01','2024-04-26 14:53:01');
INSERT INTO `balance_libro` VALUES (424,7941,40871,206080,5,424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3278095.19,'BANCO SANTANDER 041-77663/9',NULL,1,'2024-04-25 15:51:50','2025-04-02 09:35:23','2025-04-02 09:35:23'),(425,7941,40871,206081,5,425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4067773.92,'BANCO SANTANDER 041-77663/9',NULL,1,'2024-04-25 15:54:28','2024-04-25 15:54:28',NULL),(426,7941,40871,206081,3,426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2711173.78,'SUBDIARIO COMPRAS',NULL,1,'2024-04-26 14:53:01','2024-05-02 15:34:06','2024-05-02 15:34:06'),(427,7941,40871,206080,3,427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3669287.41,'SUBDIARIO COMPRAS',NULL,1,'2024-04-26 14:55:19','2024-05-02 15:33:45','2024-05-02 15:33:45'),(428,7941,40771,77286,5,428,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2827729.82,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 10:01:56','2024-04-30 15:56:21','2024-04-30 15:56:21'),(429,7941,40771,77286,1,429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',620803.58,'SUELDOS',NULL,1,'2024-04-30 13:34:36','2024-04-30 13:34:36',NULL),(430,7941,40771,77287,1,430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',607779.83,'SUELDOS',NULL,1,'2024-04-30 13:36:23','2024-04-30 13:36:23',NULL),(431,7941,40771,77288,1,431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',758567.00,'SUELDOS',NULL,1,'2024-04-30 13:39:31','2024-04-30 13:39:31',NULL),(432,7941,40771,77289,1,432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',948459.85,'SUELDOS',NULL,1,'2024-04-30 13:42:15','2024-04-30 13:42:15',NULL),(433,7941,40771,77290,1,433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',985755.15,'SUELDOS',NULL,1,'2024-04-30 13:43:11','2024-04-30 13:43:11',NULL),(434,7941,40771,77291,1,434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1465877.80,'SUELDOS',NULL,1,'2024-04-30 13:44:25','2024-04-30 13:44:25',NULL),(435,7941,40771,77292,1,435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1092405.77,'SUELDOS',NULL,1,'2024-04-30 13:45:24','2024-04-30 13:45:24',NULL),(436,7941,40771,77293,1,436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1307500.89,'SUELDOS',NULL,1,'2024-04-30 13:46:28','2024-04-30 13:46:28',NULL),(437,7941,40771,77294,1,437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1361089.25,'SUELDOS',NULL,1,'2024-04-30 13:47:51','2024-04-30 13:47:51',NULL),(438,7941,40771,77295,2,438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1592011.03,'SUELDOS',NULL,1,'2024-04-30 13:49:00','2024-04-30 14:11:47','2024-04-30 14:11:47'),(439,7941,40771,77296,1,439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1718804.92,'SUELDOS',NULL,1,'2024-04-30 13:51:50','2024-04-30 13:51:50',NULL),(440,7941,40771,77297,1,440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3071435.91,'SUELDOS',NULL,1,'2024-04-30 13:55:37','2024-04-30 14:11:32','2024-04-30 14:11:32'),(441,7941,40771,77297,1,441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3071435.91,'SUELDOS',NULL,1,'2024-04-30 14:11:32','2024-04-30 14:11:32',NULL),(442,7941,40771,77295,1,442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1592011.03,'SUELDOS',NULL,1,'2024-04-30 14:11:47','2024-04-30 14:11:47',NULL);
INSERT INTO `balance_libro` VALUES (443,7941,40870,204550,5,443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',27276890.06,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 15:27:01','2024-04-30 17:10:43','2024-04-30 17:10:43'),(444,7941,40870,204551,5,444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',17888859.33,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 15:30:22','2024-04-30 15:30:22',NULL),(445,7941,40870,204552,5,445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',48343020.61,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 15:35:54','2024-04-30 15:35:54',NULL),(446,7941,40870,204553,5,446,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',34012142.08,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 15:43:56','2024-04-30 15:43:56',NULL),(447,7941,40771,77286,5,447,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2827729.82,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 15:56:21','2024-04-30 15:56:21',NULL),(448,7941,40771,77287,5,448,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2997917.19,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 16:01:25','2024-04-30 16:02:13','2024-04-30 16:02:13'),(449,7941,40771,77287,5,449,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2997917.19,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 16:02:13','2024-04-30 16:04:42','2024-04-30 16:04:42'),(450,7941,40771,77287,5,450,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2997917.19,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 16:02:13','2024-04-30 16:04:29','2024-04-30 16:04:29'),(451,7941,40771,77287,5,451,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2997917.19,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 16:04:29','2024-04-30 16:04:29',NULL),(452,7941,40771,77288,5,452,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3715643.25,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 16:17:07','2024-04-30 16:17:07',NULL),(453,7941,40771,77289,5,453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',4220966.90,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 16:24:32','2024-04-30 16:24:32',NULL),(454,7941,40771,77290,5,454,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5703517.64,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 16:42:25','2024-04-30 16:42:25',NULL),(455,7941,40870,204554,5,455,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',61919019.10,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:09:23','2024-04-30 17:09:23',NULL),(456,7941,40870,204550,5,456,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',27276890.06,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:10:43','2024-04-30 17:10:43',NULL),(457,7941,40870,204555,5,457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',52227700.98,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:18:09','2024-04-30 17:18:09',NULL),(458,7941,40870,204556,5,458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',58221167.26,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:27:35','2024-04-30 17:27:35',NULL),(459,7941,40771,77306,5,459,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5650064.88,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 17:32:36','2024-04-30 17:33:49','2024-04-30 17:33:49');
INSERT INTO `balance_libro` VALUES (460,7941,40870,204557,5,460,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',57478418.62,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:33:11','2024-04-30 17:33:11',NULL),(461,7941,40771,77291,5,461,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5650064.88,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 17:33:49','2024-04-30 17:33:49',NULL),(462,7941,40870,204558,5,462,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',56086203.82,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:39:24','2024-04-30 17:39:24',NULL),(463,7941,40870,204559,5,463,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',118668426.39,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:45:56','2024-04-30 17:45:56',NULL),(464,7941,40771,77292,5,464,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6516463.77,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 17:47:10','2024-04-30 17:47:10',NULL),(465,7941,40870,204560,3,465,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',70827781.60,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:51:19','2025-01-24 12:22:31','2025-01-24 12:22:31'),(466,7941,40771,77293,5,466,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6554609.71,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 17:54:49','2024-04-30 17:54:49',NULL),(467,7941,40870,204561,5,467,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',101744141.01,'BANCO SANTANDER 9161-3',NULL,1,'2024-04-30 17:56:32','2024-04-30 17:56:32',NULL),(468,7941,40771,77294,5,468,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',7451378.29,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 18:12:03','2024-04-30 18:12:03',NULL),(469,7941,40771,77295,5,469,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',11719269.70,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 18:17:58','2024-04-30 18:17:58',NULL),(470,7941,40771,77296,5,470,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',10243560.67,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 18:25:11','2024-04-30 18:25:11',NULL),(471,7941,40771,77297,5,471,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',12315657.28,'BANCO SANTANDER 041-028387/2',NULL,1,'2024-04-30 18:29:58','2024-04-30 18:29:58',NULL),(472,7941,40870,204561,3,472,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',37022205.81,'COMPRAS',NULL,1,'2024-05-02 14:35:25','2024-05-02 16:11:03','2024-05-02 16:11:03'),(473,7941,40869,203038,5,473,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',126366.27,'BANCO MACRO',NULL,1,'2024-05-02 14:44:15','2024-05-03 11:51:07','2024-05-03 11:51:07'),(474,7941,40869,203033,3,474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',207773.57,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:22:37','2024-05-03 12:49:56','2024-05-03 12:49:56'),(475,7941,40869,203039,16,475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',889827.28,'DJ IIBB 12-2023',NULL,1,'2024-05-02 15:32:14','2024-05-02 15:32:14',NULL),(476,7941,40871,206080,3,476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3669287.41,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:33:45','2024-05-02 15:33:45',NULL),(477,7941,40871,206081,3,477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2711173.78,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:34:06','2024-05-02 15:34:06',NULL);
INSERT INTO `balance_libro` VALUES (478,7941,40869,203039,5,478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2378959.15,'BANCO SANTANDER',NULL,1,'2024-05-02 15:35:11','2024-05-02 15:35:11',NULL),(479,7941,40869,203039,5,479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',5415486.85,'BANCO MACRO 1',NULL,1,'2024-05-02 15:38:29','2024-05-02 16:03:39','2024-05-02 16:03:39'),(480,7941,40869,203037,5,480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4660573.42,'BANCO MACRO 1',NULL,1,'2024-05-02 15:46:22','2024-05-02 15:46:22',NULL),(481,7941,40869,203038,5,481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6091518.63,'BANCO MACRO 1',NULL,1,'2024-05-02 15:50:13','2024-05-02 15:50:13',NULL),(482,7941,40771,77297,3,482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4931320.20,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:52:15','2024-05-02 15:52:15',NULL),(483,7941,40771,77296,3,483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5656239.83,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:52:55','2024-05-02 15:52:55',NULL),(484,7941,40771,77295,3,484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',8790979.27,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:54:31','2024-05-02 15:54:31',NULL),(485,7941,40869,203039,5,485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',394517.43,'BANCO SANTANDER 1',NULL,1,'2024-05-02 15:54:41','2024-05-02 15:54:41',NULL),(486,7941,40771,77294,3,486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',14980894.18,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:55:15','2024-05-02 15:55:15',NULL),(487,7941,40771,77293,3,487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',7184699.00,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:55:53','2024-05-02 15:55:53',NULL),(488,7941,40771,77292,3,488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3010889.41,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:56:37','2024-05-02 15:56:37',NULL),(489,7941,40771,77291,3,489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3878091.33,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:57:48','2024-05-02 15:57:48',NULL),(490,7941,40869,203034,20,490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',303525.00,'CREDITOS',NULL,1,'2024-05-02 15:58:03','2024-05-02 15:58:03',NULL),(491,7941,40771,77290,3,491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2757882.86,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:58:38','2024-05-02 15:58:38',NULL),(492,7941,40771,77289,3,492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6348037.28,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 15:59:28','2024-05-02 15:59:28',NULL),(493,7941,40869,203035,5,493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',584308.52,'BANCO SANTANDER',NULL,1,'2024-05-02 16:01:43','2024-05-02 16:01:43',NULL),(494,7941,40771,77288,3,494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5805293.25,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 16:02:22','2024-05-02 16:02:22',NULL),(495,7941,40771,77287,3,495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2496286.41,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 16:02:56','2024-05-02 16:02:56',NULL),(496,7941,40869,203039,5,496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',5731459.36,'BANCO MACRO 1',NULL,1,'2024-05-02 16:03:39','2024-05-02 16:03:39',NULL);
INSERT INTO `balance_libro` VALUES (497,7941,40771,77286,3,497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1037821.27,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 16:03:41','2024-05-02 16:03:41',NULL),(498,7941,40869,203034,3,498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7821487.43,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 16:04:49','2024-05-02 16:04:49',NULL),(499,7941,40869,203035,3,499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6513727.00,'SUBDIARIO COMPRAS',NULL,1,'2024-05-02 16:06:23','2024-05-02 16:06:23',NULL),(500,7941,40870,204561,3,500,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',37022205.81,'COMPRAS',NULL,1,'2024-05-02 16:11:03','2024-05-02 16:11:03',NULL),(501,7941,40870,204560,3,501,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',65554939.43,'COMPRAS',NULL,1,'2024-05-02 16:12:53','2024-05-02 16:12:53',NULL),(502,7941,40870,204559,3,502,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',103751821.19,'COMPRAS',NULL,1,'2024-05-02 16:15:20','2024-05-02 16:15:20',NULL),(503,7941,40870,204558,3,503,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',30953393.68,'COMPRAS',NULL,1,'2024-05-02 16:17:12','2024-05-02 16:17:12',NULL),(504,7941,40870,204557,3,504,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',40456618.86,'COMPRAS',NULL,1,'2024-05-02 16:21:26','2024-05-02 16:21:26',NULL),(505,7941,40870,204556,3,505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',43533962.64,'COMPRAS',NULL,1,'2024-05-02 16:25:42','2024-05-02 16:25:42',NULL),(506,7941,40869,203039,3,506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',18000000.00,'CMV 12-2023',NULL,1,'2024-05-02 16:27:11','2024-05-02 16:27:11',NULL),(507,7941,40869,203039,3,507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',6785478.25,'PROVEEDORES 12-2023',NULL,1,'2024-05-02 16:41:50','2024-05-02 16:41:50',NULL),(508,7941,40869,203039,2,508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',76609.18,'DEPOSITO EFECTIVO 12-2023',NULL,1,'2024-05-02 16:43:19','2024-05-02 16:43:19',NULL),(509,7941,40869,203039,2,509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1343929.78,'DEUDORES POR VENTAS 12-2023',NULL,1,'2024-05-02 16:49:27','2024-05-02 16:49:27',NULL),(510,7941,40869,203039,15,510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',55673.98,'IMPUESTOS VARIOS 12-2023',NULL,1,'2024-05-02 16:53:05','2024-05-02 16:53:05',NULL),(511,7941,40869,203039,6,511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',241017.78,'PROVISION IMPUESTOS A LAS GANANCIAS 12-2023',NULL,1,'2024-05-02 16:54:50','2024-05-06 12:33:26','2024-05-06 12:33:26'),(512,7941,40870,204555,3,512,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',52706898.32,'COMPRAS',NULL,1,'2024-05-02 19:04:34','2024-05-02 19:04:34',NULL),(513,7941,40870,204554,3,513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',21219710.28,'COMPRAS',NULL,1,'2024-05-02 19:05:30','2024-05-02 19:05:30',NULL),(514,7941,40870,204553,3,514,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',51788883.92,'COMPRAS',NULL,1,'2024-05-02 19:07:29','2024-05-02 19:07:29',NULL),(515,7941,40870,204552,3,515,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',61042023.63,'COMPRAS',NULL,1,'2024-05-02 19:08:32','2024-05-02 19:08:32',NULL);
INSERT INTO `balance_libro` VALUES (516,7941,40870,204551,3,516,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3316949.40,'COMPRAS',NULL,1,'2024-05-02 19:09:47','2024-05-02 19:09:47',NULL),(517,7941,40870,204550,3,517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6576926.68,'COMPRAS',NULL,1,'2024-05-02 19:11:11','2024-05-02 19:11:11',NULL),(518,7941,40869,203038,5,518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',126366.27,'BANCO MACRO',NULL,1,'2024-05-03 11:51:07','2024-05-03 11:51:07',NULL),(519,7941,40869,203039,15,519,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',10088.47,'IMPUESTOS VARIOS 12-2023',NULL,1,'2024-05-03 11:58:15','2024-05-03 11:58:15',NULL),(520,7941,40869,203037,10,520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',355776.79,'PLAN DE PAGOS 10-2023',NULL,1,'2024-05-03 12:04:18','2024-05-03 12:04:18',NULL),(521,7941,40869,203033,3,521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',207773.57,'SUBDIARIO COMPRAS',NULL,1,'2024-05-03 12:49:56','2024-05-03 12:49:56',NULL),(522,7941,40736,25782,5,522,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4239898.54,'BANCO GALICIA 01-2023',NULL,1,'2024-05-03 13:03:15','2024-05-03 13:18:29','2024-05-03 13:18:29'),(523,7941,40736,25782,5,523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4239898.54,'BANCO GALICIA',NULL,1,'2024-05-03 13:18:29','2024-05-03 13:18:29',NULL),(524,7941,40736,25783,5,524,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7506035.62,'BANCO GALICIA',NULL,1,'2024-05-03 13:21:46','2024-05-03 13:21:46',NULL),(525,7941,40736,25784,5,525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4288000.00,'BANCO GALICIA',NULL,1,'2024-05-03 13:25:43','2024-05-03 13:25:43',NULL),(526,7941,40736,25785,5,526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3274016.70,'BANCO GALICIA',NULL,1,'2024-05-03 13:29:37','2024-05-03 13:29:37',NULL),(527,7941,40736,25786,5,527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7386463.49,'BANCO GALICIA',NULL,1,'2024-05-03 13:35:00','2024-05-03 13:35:00',NULL),(528,7941,40736,25787,5,528,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9215640.96,'BANCO GALICIA',NULL,1,'2024-05-03 13:38:42','2024-05-03 13:38:42',NULL),(529,7941,40736,25788,5,529,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',8891344.40,'BANCO GALICIA',NULL,1,'2024-05-03 13:42:20','2024-05-03 13:42:20',NULL),(530,7941,40736,25789,5,530,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',7584027.40,'BANCO GALICIA',NULL,1,'2024-05-03 13:46:24','2024-05-03 13:46:24',NULL),(531,7941,40736,25790,5,531,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5312576.30,'BANCO GALICIA',NULL,1,'2024-05-03 13:52:56','2024-05-03 13:52:56',NULL),(532,7941,40736,25791,5,532,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',35119639.39,'BANCO GALICIA',NULL,1,'2024-05-03 13:56:20','2024-05-03 13:56:20',NULL),(533,7941,40736,25792,3,533,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',32010619.18,'BANCO GALICIA',NULL,1,'2024-05-03 13:59:36','2024-05-03 13:59:44','2024-05-03 13:59:44'),(534,7941,40736,25792,5,534,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',32010619.18,'BANCO GALICIA',NULL,1,'2024-05-03 13:59:44','2024-05-03 13:59:44',NULL);
INSERT INTO `balance_libro` VALUES (535,7941,40736,25793,5,535,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',27233172.88,'BANCO GALICIA',NULL,1,'2024-05-03 14:03:30','2024-05-03 14:03:30',NULL),(536,7941,40869,203028,12,536,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',194779.00,'ASIENTO DE INICIO',NULL,1,'2024-05-03 15:57:51','2024-05-03 15:57:51',NULL),(537,7941,40870,204550,5,537,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8971.76,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:07:42','2024-05-03 16:09:33','2024-05-03 16:09:33'),(538,7941,40870,204552,5,538,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8971.76,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:09:33','2024-05-03 16:09:33',NULL),(539,7941,40870,204553,5,539,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',50000.00,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:12:56','2024-05-03 16:12:56',NULL),(540,7941,40870,204554,5,540,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',50000.00,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:17:46','2024-05-03 16:17:46',NULL),(541,7941,40870,204555,3,541,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',12560.57,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:19:48','2024-05-03 16:23:51','2024-05-03 16:23:51'),(542,7941,40870,204556,5,542,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',12560.47,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:21:57','2024-05-03 16:21:57',NULL),(543,7941,40870,204557,5,543,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',12312.24,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:23:43','2024-05-03 16:23:43',NULL),(544,7941,40870,204555,5,544,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',12560.57,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:23:51','2024-05-03 16:23:51',NULL),(545,7941,40870,204558,5,545,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',12312.24,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:26:12','2024-05-03 16:26:12',NULL),(546,7941,40870,204559,5,546,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',100000.00,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:28:08','2024-05-03 16:28:08',NULL),(547,7941,40870,204560,5,547,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',18462.11,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:29:56','2024-05-03 16:29:56',NULL),(548,7941,40870,204561,5,548,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',18462.11,'BANCO SANTANDER 9171-2',NULL,1,'2024-05-03 16:31:36','2024-05-03 16:31:36',NULL),(549,7941,40872,207601,2,549,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2033659.89,'SUBDIARIO VENTAS 07-2023',NULL,1,'2024-05-06 11:31:04','2024-05-06 11:31:04',NULL),(550,7941,40872,207602,2,550,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4010218.95,'SUBDIARIO VENTAS 08-2023',NULL,1,'2024-05-06 11:32:43','2024-05-06 11:32:43',NULL),(551,7941,40872,207603,2,551,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5705873.51,'SUBDIARIO VENTAS 09-2023',NULL,1,'2024-05-06 11:36:59','2024-05-06 11:36:59',NULL),(552,7941,40872,207604,2,552,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',3463766.15,'SUBDIARIO VENTAS 10-2023',NULL,1,'2024-05-06 11:38:40','2024-05-06 11:38:40',NULL);
INSERT INTO `balance_libro` VALUES (553,7941,40872,207605,2,553,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1809598.00,'SUBDIARIO VENTAS 11-2023',NULL,1,'2024-05-06 11:40:21','2024-05-06 11:40:21',NULL),(554,7941,40872,207606,2,554,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4766567.78,'SUBDIARIO VENTAS 12-2023',NULL,1,'2024-05-06 11:41:41','2024-05-06 11:41:41',NULL),(555,7941,40872,207600,15,555,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',71209.95,'DJ IVA 06-2023',NULL,1,'2024-05-06 12:25:58','2024-05-06 12:44:41','2024-05-06 12:44:41'),(556,7941,40872,207601,15,556,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',474144.39,'DJ IVA 07-2023',NULL,1,'2024-05-06 12:29:17','2024-05-06 12:46:22','2024-05-06 12:46:22'),(557,7941,40869,203039,6,557,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',241017.78,'PROVISION IMPUESTOS A LAS GANANCIAS 12-2023',NULL,1,'2024-05-06 12:33:26','2024-05-06 12:33:26',NULL),(558,7941,40872,207602,15,558,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',524141.09,'DJ IVA 08-2023',NULL,1,'2024-05-06 12:35:42','2024-05-06 12:48:01','2024-05-06 12:48:01'),(559,7941,40872,207600,15,559,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',71209.95,'DJ IVA 06-2023',NULL,1,'2024-05-06 12:44:41','2024-05-06 12:44:41',NULL),(560,7941,40872,207601,15,560,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',474144.39,'DJ IVA 07-2023',NULL,1,'2024-05-06 12:46:22','2024-05-06 12:46:22',NULL),(561,7941,40872,207602,15,561,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',524141.09,'DJ IVA 08-2023',NULL,1,'2024-05-06 12:48:01','2024-05-06 12:48:01',NULL),(562,7941,40872,207603,15,562,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',655098.52,'DJ IVA 09-2023',NULL,1,'2024-05-06 12:51:27','2024-05-06 12:51:27',NULL),(563,7941,40872,207604,15,563,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',329136.15,'DJ IVA 10-2023',NULL,1,'2024-05-06 12:54:02','2024-05-06 12:54:02',NULL),(564,7941,40872,207605,15,564,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',535114.82,'DJ IVA 11-2023',NULL,1,'2024-05-06 12:55:35','2024-05-06 12:55:35',NULL),(565,7941,40872,207606,15,565,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',704454.88,'DJ IVA 12-2023',NULL,1,'2024-05-06 12:57:36','2024-05-06 12:57:36',NULL),(566,7941,40872,207600,3,566,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',749399.98,'SUBDIARIO COMPRAS 06-2023',NULL,1,'2024-05-06 13:05:53','2024-05-06 13:05:53',NULL),(567,7941,40872,207601,3,567,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3918818.97,'SUBDIARIO COMPRAS 07-2023',NULL,1,'2024-05-06 13:08:23','2024-05-06 13:08:23',NULL),(568,7941,40872,207602,3,568,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',2598114.04,'SUBDIARIO COMPRAS 08-2023',NULL,1,'2024-05-06 13:09:45','2024-05-06 13:09:45',NULL),(569,7941,40872,207603,3,569,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5913389.94,'SUBDIARIO COMPRAS 09-2023',NULL,1,'2024-05-06 13:11:39','2024-05-06 13:11:39',NULL),(570,7941,40872,207604,3,570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',2260336.90,'SUBDIARIO COMPRAS 10-2023',NULL,1,'2024-05-06 13:14:41','2024-05-07 17:37:56','2024-05-07 17:37:56');
INSERT INTO `balance_libro` VALUES (571,7941,40872,207605,3,571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5767316.06,'SUBDIARIO COMPRAS 11-2023',NULL,1,'2024-05-06 13:17:02','2024-05-07 17:38:21','2024-05-07 17:38:21'),(572,7941,40872,207606,3,572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3730950.55,'SUBDIARIO COMPRAS 12-2023',NULL,1,'2024-05-06 13:18:41','2024-05-06 13:18:41',NULL),(573,7941,40872,207601,16,573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',55212.49,'DJ IIBB 07-2023',NULL,1,'2024-05-06 13:25:16','2024-05-06 13:25:16',NULL),(574,7941,40872,207602,16,574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',107520.65,'DJ IIBB 08-2023',NULL,1,'2024-05-06 13:26:23','2024-05-06 13:26:23',NULL),(575,7941,40771,77295,5,575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',2271961.26,'BANCO SANTANDER U$D Nº 041-028388/9',NULL,1,'2024-05-06 13:26:23','2024-05-06 13:29:58','2024-05-06 13:29:58'),(576,7941,40872,207603,16,576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',153402.84,'DJ IIBB 09-2023',NULL,1,'2024-05-06 13:27:57','2024-05-06 13:27:57',NULL),(577,7941,40872,207604,16,577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',94038.90,'DJ IIBB 10-2023',NULL,1,'2024-05-06 13:29:29','2024-05-06 13:29:29',NULL),(578,7941,40771,77295,5,578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',2271961.26,'BANCO SANTANDER U$D Nº 041-028388/9',NULL,1,'2024-05-06 13:29:58','2024-05-06 13:29:58',NULL),(579,7941,40872,207605,3,579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',74778.56,'DJ IIBB 11-2023',NULL,1,'2024-05-06 13:32:14','2024-05-06 13:32:14',NULL),(580,7941,40872,207606,16,580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',129409.08,'DJ IIBB 12-2023',NULL,1,'2024-05-06 13:34:30','2024-05-06 13:34:30',NULL),(581,7941,40872,207604,1,581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',100342.00,'Sueldos y Cargas Sociales 10-2023',NULL,1,'2024-05-06 13:41:50','2024-05-06 13:41:50',NULL),(582,7941,40872,207605,1,582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',102084.00,'Sueldos y Cargas Sociales 11-2023',NULL,1,'2024-05-06 13:43:25','2024-05-06 13:43:25',NULL),(583,7941,40872,207606,1,583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',127555.50,'Sueldos y Cargas Sociales 12-2023',NULL,1,'2024-05-06 13:44:59','2024-05-06 13:44:59',NULL),(584,7941,40735,24263,15,584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2590116.03,'DJ IVA 12-2023',NULL,1,'2024-05-06 15:36:17','2024-05-06 15:36:17',NULL),(585,7941,40872,207601,5,585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2421331.66,'BANCO ICBC 07-2023',NULL,1,'2024-05-06 16:44:04','2024-05-08 15:10:37','2024-05-08 15:10:37'),(586,7941,40872,207602,5,586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',700700.00,'BANCO ICBC 08-2023',NULL,1,'2024-05-06 16:47:02','2024-05-08 15:11:19','2024-05-08 15:11:19'),(587,7941,40872,207603,5,587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',951920.00,'BANCO ICBC 09-2023',NULL,1,'2024-05-06 16:50:33','2024-05-08 15:11:49','2024-05-08 15:11:49'),(588,7941,40872,207604,5,588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',552500.00,'BANCO ICBC 10-2023',NULL,1,'2024-05-06 16:52:38','2024-05-08 15:12:10','2024-05-08 15:12:10');
INSERT INTO `balance_libro` VALUES (589,7941,40872,207605,5,589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',748122.35,'BANCO ICBC 11-2023',NULL,1,'2024-05-06 16:54:13','2024-05-08 15:12:33','2024-05-08 15:12:33'),(590,7941,40870,204550,5,590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3834195.35,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:18:37','2024-05-07 10:25:00','2024-05-07 10:25:00'),(591,7941,40870,204550,5,591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3834195.35,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:25:00','2024-05-07 10:25:00',NULL),(592,7941,40870,204551,5,592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1775628.58,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:26:38','2024-05-07 10:26:38',NULL),(593,7941,40870,204552,5,593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3132499.07,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:27:43','2024-05-07 10:27:43',NULL),(594,7941,40870,204553,5,594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',5716460.72,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:29:07','2024-05-07 10:30:50','2024-05-07 10:30:50'),(595,7941,40872,207604,5,595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',8640483.48,'BANCO DE COMERCIO 10-2023',NULL,1,'2024-05-07 10:30:23','2024-05-07 10:30:23',NULL),(596,7941,40870,204554,5,596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5716460.72,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:30:50','2024-05-07 10:30:50',NULL),(597,7941,40872,207605,5,597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',472820.00,'BANCO DE COMERCIO 11-2023',NULL,1,'2024-05-07 10:31:46','2024-05-07 10:31:46',NULL),(598,7941,40870,204553,5,598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',9899347.38,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:32:13','2024-05-07 10:32:13',NULL),(599,7941,40872,207606,5,599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',30000.00,'BANCO DE COMERCIO 12-2023',NULL,1,'2024-05-07 10:32:57','2024-05-07 10:32:57',NULL),(600,7941,40870,204555,5,600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4659716.27,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:33:25','2024-05-07 10:33:25',NULL),(601,7941,40870,204556,5,601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10836098.00,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:35:18','2024-05-07 10:35:18',NULL),(602,7941,40870,204557,5,602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6711561.65,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:37:31','2024-05-07 10:37:31',NULL),(603,7941,40870,204558,5,603,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5332735.00,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:38:59','2024-05-07 10:38:59',NULL),(604,7941,40870,204559,5,604,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',10022970.30,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:41:18','2024-05-07 10:41:18',NULL),(605,7941,40870,204560,5,605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5567714.50,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:42:31','2024-05-07 10:42:31',NULL),(606,7941,40870,204561,5,606,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',13297500.00,'BANCO DOLARES CTA 9555-4',NULL,1,'2024-05-07 10:44:36','2024-05-07 10:44:36',NULL);
INSERT INTO `balance_libro` VALUES (607,7941,40872,207604,3,607,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',2260336.90,'SUBDIARIO COMPRAS 10-2023',NULL,1,'2024-05-07 17:37:56','2024-05-07 17:37:56',NULL),(608,7941,40872,207605,3,608,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5767316.06,'SUBDIARIO COMPRAS 11-2023',NULL,1,'2024-05-07 17:38:21','2024-05-07 17:38:21',NULL),(609,7941,40872,207602,5,609,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3443289.65,'BANCO SUPERVIELLE 08-2023',NULL,1,'2024-05-08 12:47:35','2024-05-08 14:25:05','2024-05-08 14:25:05'),(610,7941,40872,207603,5,610,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4685332.27,'BANCO SUPERVIELLE 09-2023',NULL,1,'2024-05-08 12:50:55','2024-05-08 14:25:43','2024-05-08 14:25:43'),(611,7941,40872,207602,5,611,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3443289.65,'BANCO SUPERVIELLE 08-2023',NULL,1,'2024-05-08 14:25:05','2024-05-08 14:25:05',NULL),(612,7941,40872,207603,5,612,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4685332.27,'BANCO SUPERVIELLE 09-2023',NULL,1,'2024-05-08 14:25:43','2024-05-08 14:25:43',NULL),(613,7941,40872,207601,5,613,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2421331.66,'BANCO ICBC 07-2023',NULL,1,'2024-05-08 15:10:37','2024-05-08 15:10:37',NULL),(614,7941,40872,207602,5,614,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',700700.00,'BANCO ICBC 08-2023',NULL,1,'2024-05-08 15:11:19','2024-05-08 15:11:19',NULL),(615,7941,40872,207603,5,615,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',951920.00,'BANCO ICBC 09-2023',NULL,1,'2024-05-08 15:11:49','2024-05-08 15:11:49',NULL),(616,7941,40872,207604,5,616,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',552500.00,'BANCO ICBC 10-2023',NULL,1,'2024-05-08 15:12:10','2024-05-08 15:14:13','2024-05-08 15:14:13'),(617,7941,40872,207605,5,617,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',748122.35,'BANCO ICBC 11-2023',NULL,1,'2024-05-08 15:12:33','2024-05-08 15:14:46','2024-05-08 15:14:46'),(618,7941,40872,207604,5,618,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',552500.00,'BANCO ICBC 10-2023',NULL,1,'2024-05-08 15:14:13','2024-05-08 15:14:13',NULL),(619,7941,40872,207605,5,619,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',748122.35,'BANCO ICBC 11-2023',NULL,1,'2024-05-08 15:14:46','2024-05-08 15:14:46',NULL),(620,7941,40872,207604,5,620,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',500000.00,'BANCO SUPERVIELLE 10-2023',NULL,1,'2024-05-08 15:17:25','2024-05-08 15:17:25',NULL),(621,7941,40872,207605,5,621,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2291698.00,'BANCO SUPERVIELLE 11-2023',NULL,1,'2024-05-08 15:21:12','2024-05-08 15:28:51','2024-05-08 15:28:51'),(622,7941,40872,207606,5,622,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4958044.46,'BANCO SUPERVIELLE 12-2023',NULL,1,'2024-05-08 15:22:59','2024-05-08 15:29:05','2024-05-08 15:29:05'),(623,7941,40872,207605,5,623,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2291698.00,'BANCO SUPERVIELLE 11-2023',NULL,1,'2024-05-08 15:28:51','2024-05-08 15:28:51',NULL),(624,7941,40872,207606,5,624,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4958044.46,'BANCO SUPERVIELLE 12-2023',NULL,1,'2024-05-08 15:29:05','2024-05-08 15:29:05',NULL);
INSERT INTO `balance_libro` VALUES (625,7941,40875,212190,2,625,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',1073270.00,'SUBDIARIO DE VENTAS',NULL,1,'2024-07-02 11:30:50','2024-07-02 11:46:30','2024-07-02 11:46:30'),(626,7941,40875,212191,2,626,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',3890150.00,'SUBDIARIO DE VENTAS',NULL,1,'2024-07-02 11:32:19','2024-07-02 11:47:08','2024-07-02 11:47:08'),(627,7941,40875,212192,2,627,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',3872000.00,'SUBDIARIO DE VENTAS',NULL,1,'2024-07-02 11:34:07','2024-07-02 11:46:44','2024-07-02 11:46:44'),(628,7941,40875,212193,2,628,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',8615526.70,'SUBDIARIO DE VENTAS',NULL,1,'2024-07-02 11:35:27','2024-07-02 11:47:24','2024-07-02 11:47:24'),(629,7941,40875,212194,2,629,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',8228110.11,'SUBDIARIO DE VENTAS',NULL,1,'2024-07-02 11:38:06','2024-07-02 11:46:59','2024-07-02 11:46:59'),(630,7941,40875,212190,2,630,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',1073270.00,'SUBDIARIO VENTAS',NULL,1,'2024-07-02 11:46:30','2024-07-02 11:46:30',NULL),(631,7941,40875,212192,2,631,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',3872000.00,'SUBDIARIO VENTAS',NULL,1,'2024-07-02 11:46:44','2024-09-19 16:02:46','2024-09-19 16:02:46'),(632,7941,40875,212194,2,632,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',8228110.11,'SUBDIARIO VENTAS',NULL,1,'2024-07-02 11:46:59','2024-09-19 16:43:59','2024-09-19 16:43:59'),(633,7941,40875,212191,2,633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',3890150.00,'SUBDIARIO VENTAS',NULL,1,'2024-07-02 11:47:08','2024-07-02 11:47:08',NULL),(634,7941,40875,212193,2,634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',8615526.70,'SUBDIARIO VENTAS',NULL,1,'2024-07-02 11:47:24','2024-09-19 16:06:15','2024-09-19 16:06:15'),(635,7941,40875,212191,3,635,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',758025.00,'SUBDIARIO COMPRAS',NULL,1,'2024-07-02 11:53:19','2024-07-02 11:53:19',NULL),(636,7941,40875,212192,3,636,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',531909.21,'SUBDIARIO COMPRAS',NULL,1,'2024-07-02 12:01:07','2024-07-02 12:01:07',NULL),(637,7941,40875,212193,3,637,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',646063.74,'SUBDIARIO COMPRAS',NULL,1,'2024-07-02 12:04:07','2024-07-02 12:04:07',NULL),(638,7941,40875,212194,3,638,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',442033.00,'SUBDIARIO COMPRAS',NULL,1,'2024-07-02 12:15:23','2024-07-04 11:44:51','2024-07-04 11:44:51'),(639,7941,40875,212190,15,639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',186270.00,'DJ IVA',NULL,1,'2024-07-02 12:17:29','2024-07-02 12:17:29',NULL),(640,7941,40875,212191,15,640,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',675150.00,'DJ IVA',NULL,1,'2024-07-02 12:23:00','2024-07-02 12:23:00',NULL),(641,7941,40875,212192,15,641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',672000.00,'DJ IVA',NULL,1,'2024-07-02 12:23:44','2024-07-02 12:23:44',NULL),(642,7941,40875,212193,15,642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',1495256.70,'DJ IVA',NULL,1,'2024-07-02 12:25:04','2024-07-02 12:25:04',NULL);
INSERT INTO `balance_libro` VALUES (643,7941,40875,212191,5,643,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',1512525.80,'BANCO SANTANDER',NULL,1,'2024-07-02 12:38:54','2024-07-02 12:38:54',NULL),(644,7941,40875,212192,5,644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',7702273.22,'BANCO SANTANDER',NULL,1,'2024-07-02 12:43:18','2025-01-23 11:44:07','2025-01-23 11:44:07'),(645,7941,40875,212193,5,645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',8721183.81,'BANCO SANTANDER',NULL,1,'2024-07-02 12:46:29','2024-07-02 12:46:29',NULL),(646,7941,40875,212190,16,646,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',33630.00,'DJ IIBB',NULL,1,'2024-07-02 12:58:38','2024-07-02 12:58:38',NULL),(647,7941,40875,212191,16,647,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',115400.00,'DJ IIBB',NULL,1,'2024-07-02 12:59:57','2024-07-02 12:59:58',NULL),(648,7941,40875,212192,16,648,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',267726.77,'DJ IIBB',NULL,1,'2024-07-02 13:01:36','2024-07-02 13:01:36',NULL),(649,7941,40875,212193,16,649,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',567615.41,'DJ IIBB',NULL,1,'2024-07-02 13:04:23','2024-07-02 13:04:23',NULL),(650,7941,40874,210658,16,650,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3483896.39,'DJ IIBB 04-2023',NULL,1,'2024-07-02 15:35:31','2024-07-04 16:06:05','2024-07-04 16:06:05'),(651,7941,40874,210658,15,651,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',11133335.34,'DJ IVA 04-2023',NULL,1,'2024-07-02 15:42:05','2024-07-04 16:07:04','2024-07-04 16:07:04'),(652,7941,40874,210659,16,652,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3321821.44,'DJ IIBB 05-2023',NULL,1,'2024-07-02 17:39:52','2024-07-02 17:43:44','2024-07-02 17:43:44'),(653,7941,40874,210660,16,653,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4161131.90,'DJ IIBB 06-2023',NULL,1,'2024-07-02 17:43:28','2024-07-04 16:06:51','2024-07-04 16:06:51'),(654,7941,40874,210659,16,654,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3321821.44,'DJ IIBB 05-2023',NULL,1,'2024-07-02 17:43:44','2024-07-04 16:06:35','2024-07-04 16:06:35'),(655,7941,40874,210661,16,655,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4174190.46,'DJ IIBB 07-2023',NULL,1,'2024-07-02 17:47:00','2024-07-04 16:06:19','2024-07-04 16:06:19'),(656,7941,40875,212191,1,656,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',3438739.27,'SUELDOS',NULL,1,'2024-07-02 17:51:24','2024-07-02 17:51:24',NULL),(657,7941,40875,212192,1,657,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',4449102.93,'SUELDOS',NULL,1,'2024-07-02 17:53:13','2024-07-02 17:53:13',NULL),(658,7941,40875,212193,1,658,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',5460076.38,'SUELDOS',NULL,1,'2024-07-02 17:54:22','2024-07-02 17:54:22',NULL),(659,7941,40875,212194,1,659,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',7310066.22,'SUELDOS',NULL,1,'2024-07-02 17:55:48','2024-07-02 17:55:48',NULL),(660,7941,40876,213704,2,660,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2046357.40,'SUBDIARIO VENTAS 04-2023',NULL,1,'2024-07-03 12:44:16','2024-07-03 13:04:39','2024-07-03 13:04:39');
INSERT INTO `balance_libro` VALUES (661,7941,40876,213705,2,661,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2982554.31,'SUBDIARIO VENTAS 05-2023',NULL,1,'2024-07-03 12:46:17','2024-07-03 13:05:09','2024-07-03 13:05:09'),(662,7941,40876,213707,2,662,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2006745.47,'SUBDIARIO VENTAS 07-2023',NULL,1,'2024-07-03 12:48:28','2024-07-03 13:05:31','2024-07-03 13:05:31'),(663,7941,40876,213708,2,663,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4729707.70,'SUBDIARIO VENTAS 08-2023',NULL,1,'2024-07-03 12:49:41','2024-07-03 13:05:39','2024-07-03 13:05:39'),(664,7941,40876,213709,2,664,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2500628.35,'SUBDIARIO VENTAS 09-2023',NULL,1,'2024-07-03 12:50:50','2024-07-03 13:05:50','2024-07-03 13:05:50'),(665,7941,40876,213710,2,665,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1806265.01,'SUBDIARIO VENTAS 10-2023',NULL,1,'2024-07-03 12:51:54','2024-07-03 13:05:19','2024-07-03 13:05:19'),(666,7941,40876,213711,2,666,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3631671.01,'SUBDIARIO VENTAS 11-2023',NULL,1,'2024-07-03 12:53:11','2024-07-03 13:06:18','2024-07-03 13:06:18'),(667,7941,40876,213712,2,667,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4477514.25,'SUBDIARIO VENTAS 12-2023',NULL,1,'2024-07-03 12:54:31','2024-07-03 13:06:46','2024-07-03 13:06:46'),(668,7941,40876,213719,2,668,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3815009.00,'SUBDIARIO VENTAS 01-2024',NULL,1,'2024-07-03 12:56:09','2024-07-03 13:06:32','2024-07-03 13:06:32'),(669,7941,40876,213720,2,669,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',441650.00,'SUBDIARIO VENTAS 02-2024',NULL,1,'2024-07-03 12:57:32','2024-07-03 13:06:09','2024-07-03 13:06:09'),(670,7941,40876,213721,2,670,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2250600.00,'SUBDIARIO VENTAS 03-2024',NULL,1,'2024-07-03 12:59:31','2024-07-03 13:06:00','2024-07-03 13:06:00'),(671,7941,40876,213704,15,671,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',355152.94,'DJ IVA',NULL,1,'2024-07-03 13:02:57','2024-07-03 13:02:57',NULL),(672,7941,40876,213704,2,672,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2046357.40,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:04:39','2024-07-03 13:04:39',NULL),(673,7941,40876,213705,2,673,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2982554.31,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:05:09','2024-07-03 13:05:09',NULL),(674,7941,40876,213710,2,674,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1806265.01,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:05:19','2024-07-03 13:05:19',NULL),(675,7941,40876,213707,2,675,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2006745.47,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:05:31','2024-07-03 13:05:31',NULL),(676,7941,40876,213708,2,676,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4729707.70,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:05:39','2024-07-03 13:05:39',NULL),(677,7941,40876,213709,2,677,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2500628.35,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:05:50','2024-07-03 13:05:50',NULL);
INSERT INTO `balance_libro` VALUES (678,7941,40876,213721,2,678,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2250600.00,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:06:00','2024-07-03 13:06:00',NULL),(679,7941,40876,213720,2,679,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',441650.00,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:06:09','2024-07-03 13:06:09',NULL),(680,7941,40876,213711,2,680,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3631671.01,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:06:18','2024-07-03 13:06:18',NULL),(681,7941,40876,213719,2,681,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3815009.00,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:06:32','2024-07-03 13:06:32',NULL),(682,7941,40876,213712,2,682,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4477514.25,'SUBDIARIO VENTAS',NULL,1,'2024-07-03 13:06:46','2024-07-03 13:06:46',NULL),(683,7941,40876,213705,15,683,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',517633.39,'DJ IVA',NULL,1,'2024-07-03 13:16:08','2024-07-03 13:16:08',NULL),(684,7941,40876,213706,15,684,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5010.67,'DJ IVA',NULL,1,'2024-07-03 13:18:14','2024-07-03 13:18:14',NULL),(685,7941,40876,213707,15,685,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',348278.14,'DJ IVA',NULL,1,'2024-07-03 13:20:47','2024-07-03 13:20:47',NULL),(686,7941,40876,213708,15,686,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',820858.37,'DJ IVA',NULL,1,'2024-07-03 13:24:32','2024-07-03 13:24:32',NULL),(687,7941,40876,213709,15,687,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',433993.35,'DJ IVA',NULL,1,'2024-07-03 13:28:39','2024-07-03 13:28:39',NULL),(688,7941,40876,213710,15,688,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',313484.01,'DJ IVA',NULL,1,'2024-07-03 13:30:55','2024-07-03 13:30:55',NULL),(689,7941,40876,213711,15,689,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',630290.01,'DJ IVA',NULL,1,'2024-07-03 13:32:16','2024-07-03 13:32:16',NULL),(690,7941,40876,213712,15,690,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',777089.25,'DJ IVA',NULL,1,'2024-07-03 13:33:40','2024-07-03 13:33:40',NULL),(691,7941,40876,213719,15,691,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',662109.00,'DJ IVA',NULL,1,'2024-07-03 13:38:12','2024-07-03 13:38:12',NULL),(692,7941,40876,213720,15,692,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',76650.00,'DJ IVA',NULL,1,'2024-07-03 13:39:28','2024-07-03 13:39:28',NULL),(693,7941,40876,213721,15,693,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',390600.00,'DJ IVA',NULL,1,'2024-07-03 13:40:39','2024-07-03 13:40:39',NULL),(694,7941,40875,212194,5,694,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',7873941.23,'BANCO SANTANDER',NULL,1,'2024-07-04 09:08:37','2024-07-04 09:09:46','2024-07-04 09:09:46'),(695,7941,40875,212194,5,695,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',7873941.23,'BANCO SANTANDER',NULL,1,'2024-07-04 09:09:46','2024-07-04 09:09:46',NULL),(696,7941,40875,212194,3,696,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',442033.00,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 11:44:51','2024-09-18 12:27:17','2024-09-18 12:27:17');
INSERT INTO `balance_libro` VALUES (697,7941,40876,213704,5,697,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1653600.10,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 12:08:01','2024-07-04 12:10:41','2024-07-04 12:10:41'),(698,7941,40876,213704,5,698,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1653600.10,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 12:10:41','2024-07-04 12:10:41',NULL),(699,7941,40876,213705,5,699,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1773842.10,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 12:15:18','2024-07-04 12:15:18',NULL),(700,7941,40876,213706,5,700,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1371712.54,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 12:20:55','2024-07-04 12:20:55',NULL),(701,7941,40876,213707,5,701,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2149041.28,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 12:27:34','2024-07-04 12:27:34',NULL),(702,7941,40876,213708,5,702,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4729707.70,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 12:34:15','2024-07-04 12:34:15',NULL),(703,7941,40876,213709,5,703,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2578515.70,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 12:39:48','2024-07-04 12:39:48',NULL),(704,7941,40876,213710,5,704,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',2059870.08,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 12:45:55','2024-07-04 12:45:55',NULL),(705,7941,40876,213711,5,705,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3603014.40,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 13:04:38','2024-07-04 13:04:38',NULL),(706,7941,40876,213712,5,706,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4655295.28,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 13:11:51','2024-07-04 13:11:51',NULL),(707,7941,40876,213719,5,707,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3789600.40,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 13:16:54','2024-07-04 13:16:54',NULL),(708,7941,40876,213720,5,708,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1717471.02,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 13:27:27','2024-07-04 13:27:27',NULL),(709,7941,40876,213721,5,709,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2214743.40,'BANCO SANTANDER 7225-3',NULL,1,'2024-07-04 13:31:49','2024-07-04 13:31:49',NULL),(710,7941,40876,213704,3,710,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1009430.37,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:31:21','2024-07-04 15:31:21',NULL),(711,7941,40876,213705,3,711,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',939150.50,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:32:37','2024-07-04 15:32:37',NULL),(712,7941,40876,213706,3,712,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',500466.49,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:33:51','2024-07-04 15:33:51',NULL),(713,7941,40876,213707,3,713,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',613373.31,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:35:22','2024-07-04 15:35:22',NULL),(714,7941,40876,213708,3,714,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1209232.88,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:36:29','2024-07-04 15:36:29',NULL);
INSERT INTO `balance_libro` VALUES (715,7941,40876,213709,3,715,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1150934.02,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:38:08','2024-07-04 15:38:08',NULL),(716,7941,40876,213710,3,716,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1072502.55,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:39:02','2024-07-04 15:39:02',NULL),(717,7941,40876,213711,3,717,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1117841.81,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:40:09','2024-07-04 15:40:09',NULL),(718,7941,40876,213711,3,718,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2553540.15,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:41:20','2024-08-05 15:40:44','2024-08-05 15:40:44'),(719,7941,40876,213719,3,719,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',844707.93,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:42:29','2024-07-04 15:42:29',NULL),(720,7941,40876,213720,3,720,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',696673.24,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:44:06','2024-07-04 15:44:06',NULL),(721,7941,40876,213721,3,721,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',1217933.14,'SUBDIARIO COMPRAS',NULL,1,'2024-07-04 15:46:14','2024-07-04 15:46:14',NULL),(722,7941,40874,210658,16,722,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3483896.39,'DJ IIBB',NULL,1,'2024-07-04 16:06:05','2024-07-04 16:06:05',NULL),(723,7941,40874,210661,16,723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4174190.46,'DJ IIBB',NULL,1,'2024-07-04 16:06:19','2024-07-04 16:06:19',NULL),(724,7941,40874,210659,16,724,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3321821.44,'DJ IIBB',NULL,1,'2024-07-04 16:06:35','2024-07-04 16:06:35',NULL),(725,7941,40874,210660,16,725,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4161131.90,'DJ IIBB',NULL,1,'2024-07-04 16:06:51','2024-07-04 16:06:51',NULL),(726,7941,40874,210658,15,726,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',11133335.34,'DJ IVA',NULL,1,'2024-07-04 16:07:04','2024-07-04 16:07:04',NULL),(727,7941,40876,213707,16,727,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',86411.78,'DJ IIBB',NULL,1,'2024-07-04 16:09:50','2024-07-04 16:09:50',NULL),(728,7941,40876,213708,16,728,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',121060.97,'DJ IIBB',NULL,1,'2024-07-04 16:11:48','2024-07-04 16:11:48',NULL),(729,7941,40876,213709,16,729,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',68383.60,'DJ IIBB',NULL,1,'2024-07-04 16:15:01','2024-07-04 16:15:01',NULL),(730,7941,40876,213710,16,730,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',81003.06,'DJ IIBB',NULL,1,'2024-07-04 16:20:11','2024-07-04 16:20:11',NULL),(731,7941,40876,213711,16,731,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',183889.70,'DJ IIBB',NULL,1,'2024-07-04 16:23:05','2024-07-04 16:23:05',NULL),(732,7941,40876,213712,16,732,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',118983.71,'DJ IIBB',NULL,1,'2024-07-04 16:25:48','2024-07-04 16:25:48',NULL),(733,7941,40876,213719,16,733,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',111442.40,'DJ IIBB',NULL,1,'2024-07-04 16:27:36','2024-07-04 16:27:36',NULL);
INSERT INTO `balance_libro` VALUES (734,7941,40876,213720,16,734,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',26786.97,'DJ IIBB',NULL,1,'2024-07-04 16:29:27','2024-07-04 16:29:27',NULL),(735,7941,40876,213721,16,735,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',107166.38,'DJ IIBB',NULL,1,'2024-07-04 16:31:30','2024-07-04 16:31:30',NULL),(736,7941,40874,210662,16,736,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3321821.44,'DJ IIBB',NULL,1,'2024-07-04 17:16:31','2024-07-04 17:19:12','2024-07-04 17:19:12'),(737,7941,40874,210662,16,737,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4409302.60,'DJ IIBB',NULL,1,'2024-07-04 17:19:12','2024-07-04 17:19:12',NULL),(738,7941,40874,210663,16,738,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4961078.59,'DJ IIBB',NULL,1,'2024-07-04 17:22:44','2024-07-04 17:22:44',NULL),(739,7941,40874,210664,16,739,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',6949955.13,'DJ IIBB',NULL,1,'2024-07-04 17:25:49','2024-07-04 17:25:49',NULL),(740,7941,40874,210665,16,740,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6757957.74,'DJ IIBB',NULL,1,'2024-07-04 17:29:44','2024-07-04 17:29:44',NULL),(741,7941,40874,210666,16,741,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',10752065.76,'DJ IIBB',NULL,1,'2024-07-04 17:32:58','2024-07-04 17:32:58',NULL),(742,7941,40874,210673,16,742,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',10477508.19,'DJ IIBB',NULL,1,'2024-07-04 17:36:12','2024-07-04 17:36:12',NULL),(743,7941,40874,210674,16,743,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',11006520.60,'DJ IIBB',NULL,1,'2024-07-04 17:38:45','2024-07-04 17:38:45',NULL),(744,7941,40874,210675,16,744,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',14680408.67,'DJ IIBB',NULL,1,'2024-07-04 17:41:22','2024-07-04 17:41:22',NULL),(745,7941,40874,210659,15,745,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',11097980.93,'DJ IVA',NULL,1,'2024-07-05 10:17:31','2024-07-05 10:17:31',NULL),(746,7941,40874,210660,15,746,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',13268442.62,'DJ IVA',NULL,1,'2024-07-05 10:20:59','2024-07-05 10:20:59',NULL),(747,7941,40874,210661,15,747,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',14526175.15,'DJ IVA',NULL,1,'2024-07-05 10:24:48','2024-07-05 10:24:48',NULL),(748,7941,40874,210662,15,748,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',24311888.76,'DJ IVA',NULL,1,'2024-07-05 10:28:48','2024-07-05 10:28:48',NULL),(749,7941,40874,210663,15,749,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',21542215.46,'DJ IVA',NULL,1,'2024-07-05 10:33:08','2024-07-05 10:33:08',NULL),(750,7941,40874,210664,15,750,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',22000485.90,'DJ IVA',NULL,1,'2024-07-05 10:42:11','2024-07-05 10:42:11',NULL),(751,7941,40874,210665,15,751,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',23194790.80,'DJ IVA',NULL,1,'2024-07-05 10:45:35','2024-07-05 10:45:35',NULL),(752,7941,40874,210666,15,752,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',30611125.56,'DJ IVA',NULL,1,'2024-07-05 10:48:10','2024-07-05 10:48:10',NULL);
INSERT INTO `balance_libro` VALUES (753,7941,40874,210673,15,753,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',32317678.86,'DJ IVA',NULL,1,'2024-07-05 10:51:35','2024-07-05 10:51:35',NULL),(754,7941,40874,210674,15,754,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',36248072.48,'DJ IVA',NULL,1,'2024-07-05 10:53:40','2024-07-05 10:53:40',NULL),(755,7941,40874,210675,15,755,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',64032639.40,'DJ IVA',NULL,1,'2024-07-05 10:56:13','2024-07-05 10:56:13',NULL),(756,7941,40874,210658,2,756,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',70742779.46,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:35:59','2024-07-05 14:35:59',NULL),(757,7941,40874,210659,2,757,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',67451963.93,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:37:39','2024-07-05 14:37:39',NULL),(758,7941,40874,210660,2,758,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',83830022.41,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:38:57','2024-07-05 14:38:57',NULL),(759,7941,40874,210661,2,759,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',91576872.06,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:40:27','2024-07-05 14:40:27',NULL),(760,7941,40874,210662,2,760,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',90433722.70,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:42:07','2024-07-05 14:42:07',NULL),(761,7941,40874,210663,2,761,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',107830123.09,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:43:34','2024-07-05 14:43:34',NULL),(762,7941,40874,210664,2,762,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',142977162.23,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:44:43','2024-07-05 14:44:43',NULL),(763,7941,40874,210665,2,763,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',137763225.56,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:46:00','2024-07-05 14:46:00',NULL),(764,7941,40874,210673,2,764,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',207265925.85,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:55:10','2024-07-05 14:55:11',NULL),(765,7941,40874,210674,2,765,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',208991178.91,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:56:43','2024-07-05 14:56:43',NULL),(766,7941,40874,210675,2,766,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',256521614.64,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 14:57:54','2024-07-05 14:57:54',NULL),(767,7941,40876,213704,16,767,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',52378.29,'DJ IIBB',NULL,1,'2024-07-05 15:38:37','2024-07-05 15:38:37',NULL),(768,7941,40876,213705,16,768,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',76341.07,'DJ IIBB',NULL,1,'2024-07-05 15:40:51','2024-07-05 15:40:51',NULL),(769,7941,40876,213706,16,769,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',34292.81,'DJ IIBB',NULL,1,'2024-07-05 15:42:39','2024-07-05 15:42:39',NULL),(770,7941,40874,210666,2,770,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',213572188.61,'SUBDIARIO VENTAS',NULL,1,'2024-07-05 16:08:53','2024-07-05 16:08:53',NULL),(771,7941,40874,210658,1,771,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',16075418.13,'Sueldos y cargas sociales',NULL,1,'2024-07-17 10:02:32','2024-07-17 10:02:32',NULL);
INSERT INTO `balance_libro` VALUES (772,7941,40874,210659,1,772,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',16951941.38,'Sueldos y cargas sociales',NULL,1,'2024-07-17 11:06:06','2024-07-17 11:06:06',NULL),(773,7941,40874,210660,1,773,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',26599450.56,'Sueldos y cargas sociales',NULL,1,'2024-07-17 11:27:34','2024-07-17 11:27:34',NULL),(774,7941,40874,210661,1,774,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',20310453.28,'Sueldos y cargas sociales',NULL,1,'2024-07-17 11:36:30','2024-07-17 11:36:30',NULL),(775,7941,40874,210662,1,775,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',24734372.61,'Sueldos y cargas sociales',NULL,1,'2024-07-17 11:39:57','2024-07-17 11:39:57',NULL),(776,7941,40874,210663,1,776,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',26937651.37,'Sueldos y cargas sociales',NULL,1,'2024-07-17 11:47:02','2024-07-17 11:47:02',NULL),(777,7941,40874,210664,1,777,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',32616257.39,'Sueldos y cargas sociales',NULL,1,'2024-07-17 11:51:23','2024-07-17 11:51:23',NULL),(778,7941,40874,210665,1,778,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',33741445.45,'Sueldos y cargas sociales',NULL,1,'2024-07-17 11:55:50','2024-07-17 11:55:50',NULL),(779,7941,40874,210666,1,779,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',58104333.35,'Sueldos y cargas sociales',NULL,1,'2024-07-17 11:59:22','2024-07-17 11:59:22',NULL),(780,7941,40874,210673,1,780,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',53058506.16,'Sueldos y cargas sociales',NULL,1,'2024-07-17 12:03:18','2024-07-17 12:03:18',NULL),(781,7941,40874,210674,1,781,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',59720509.98,'Sueldos y cargas sociales',NULL,1,'2024-07-17 12:08:19','2024-07-17 12:08:19',NULL),(782,7941,40874,210675,1,782,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',68039933.96,'Sueldos y cargas sociales',NULL,1,'2024-07-17 12:11:40','2024-07-17 12:11:40',NULL),(783,7941,40874,210658,12,783,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',321959130.38,'Asiento de inicio de ejercicio',NULL,1,'2024-07-22 09:46:08','2024-07-22 09:46:08',NULL),(784,7941,40874,210658,5,784,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',4167415.52,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 09:56:03','2024-07-22 10:00:59','2024-07-22 10:00:59'),(785,7941,40874,210659,5,785,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4277424.80,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 09:59:49','2024-07-22 09:59:49',NULL),(786,7941,40874,210658,5,786,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',4167415.52,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:00:59','2024-07-22 10:00:59',NULL),(787,7941,40874,210660,5,787,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5444215.87,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:04:48','2024-07-22 10:04:48',NULL),(788,7941,40874,210661,5,788,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6996359.12,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:13:41','2024-07-22 10:13:41',NULL),(789,7941,40874,210662,5,789,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6788412.67,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:17:18','2024-07-22 10:17:18',NULL);
INSERT INTO `balance_libro` VALUES (790,7941,40874,210663,5,790,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',9214723.84,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:21:13','2024-07-22 10:21:13',NULL),(791,7941,40874,210664,5,791,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',11663511.58,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:24:24','2024-07-22 10:24:24',NULL),(792,7941,40874,210665,5,792,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',13084204.12,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:27:51','2024-07-22 10:27:51',NULL),(793,7941,40874,210666,5,793,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',15984294.08,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:30:36','2024-07-22 10:30:36',NULL),(794,7941,40874,210673,5,794,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',19250693.44,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:33:19','2024-07-22 10:33:19',NULL),(795,7941,40874,210674,5,795,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',25506875.46,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:36:17','2024-07-22 10:36:17',NULL),(796,7941,40874,210675,5,796,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',32981933.53,'BANCO CREDICOOP 112861',NULL,1,'2024-07-22 10:38:54','2024-07-22 10:38:54',NULL),(797,7941,40874,210658,5,797,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',8026.07,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 10:55:30','2024-07-22 10:55:30',NULL),(798,7941,40874,210659,5,798,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4527.01,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 10:57:53','2024-07-22 10:57:53',NULL),(799,7941,40874,210660,5,799,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5784.51,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:00:08','2024-07-22 11:00:08',NULL),(800,7941,40874,210661,5,800,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1142079.17,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:04:54','2024-08-06 16:04:13','2024-08-06 16:04:13'),(801,7941,40874,210662,5,801,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4038500.00,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:07:54','2024-08-06 16:04:56','2024-08-06 16:04:56'),(802,7941,40874,210663,5,802,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5784.51,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:09:53','2024-07-22 11:09:53',NULL),(803,7941,40874,210664,5,803,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',5784.51,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:11:43','2024-07-22 11:11:43',NULL),(804,7941,40874,210665,5,804,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',31853.67,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:16:09','2024-07-22 11:16:09',NULL),(805,7941,40874,210666,5,805,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',5889.09,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:24:45','2024-07-22 11:24:45',NULL),(806,7941,40874,210673,5,806,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',12000.00,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:27:22','2024-08-06 16:05:40','2024-08-06 16:05:40'),(807,7941,40874,210674,5,807,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1008000.00,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:29:59','2024-08-06 16:06:34','2024-08-06 16:06:34');
INSERT INTO `balance_libro` VALUES (808,7941,40874,210675,5,808,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',8000.00,'BANCO CREDICOOP 97980',NULL,1,'2024-07-22 11:33:51','2024-08-06 16:07:07','2024-08-06 16:07:07'),(809,7941,40874,210658,6,809,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',7307729.56,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:06:35','2024-08-13 08:51:57','2024-08-13 08:51:57'),(810,7941,40874,210659,5,810,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8415940.96,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:09:50','2024-07-22 12:09:50',NULL),(811,7941,40874,210660,5,811,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9521310.38,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:13:19','2024-07-22 12:13:19',NULL),(812,7941,40874,210661,5,812,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10886835.39,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:19:44','2024-07-22 12:19:44',NULL),(813,7941,40874,210662,5,813,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',11822216.15,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:25:16','2024-07-22 12:25:16',NULL),(814,7941,40874,210663,5,814,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',13648030.60,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:28:28','2024-07-22 12:28:28',NULL),(815,7941,40874,210664,5,815,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',16606959.51,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:31:49','2024-07-22 12:31:49',NULL),(816,7941,40874,210665,5,816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',18293060.55,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:35:20','2024-07-22 12:35:20',NULL),(817,7941,40874,210666,5,817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',21132123.79,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:39:20','2024-07-22 12:39:20',NULL),(818,7941,40874,210673,5,818,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',23614049.39,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:44:07','2024-07-22 12:44:07',NULL),(819,7941,40874,210674,5,819,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',31380904.24,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:47:57','2024-08-06 16:11:41','2024-08-06 16:11:41'),(820,7941,40874,210675,5,820,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',32601963.64,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 12:52:28','2024-08-06 16:12:39','2024-08-06 16:12:39'),(821,7941,40874,210658,5,821,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',21683748.15,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:15:12','2024-07-22 13:15:12',NULL),(822,7941,40874,210659,5,822,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',25737023.49,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:18:40','2024-07-22 13:18:40',NULL),(823,7941,40874,210658,5,823,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',7307729.56,'BANCO CREDICOOP 69495',NULL,1,'2024-07-22 13:23:32','2024-07-22 13:23:32',NULL),(824,7941,40874,210661,5,824,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',33345713.34,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:27:37','2024-07-22 13:27:37',NULL),(825,7941,40874,210662,5,825,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',35938017.41,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:31:07','2024-07-22 13:31:07',NULL);
INSERT INTO `balance_libro` VALUES (826,7941,40874,210663,5,826,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',36787490.77,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:37:00','2024-07-22 13:37:00',NULL),(827,7941,40874,210664,5,827,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',40439625.95,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:41:08','2024-07-22 13:41:08',NULL),(828,7941,40874,210665,5,828,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',54067012.78,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:44:30','2024-07-22 13:44:30',NULL),(829,7941,40874,210666,5,829,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',56946519.31,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:50:24','2024-07-22 13:50:24',NULL),(830,7941,40874,210673,5,830,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',63019469.67,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:53:37','2024-07-22 13:53:37',NULL),(831,7941,40874,210674,5,831,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',78285043.63,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:56:31','2024-07-22 13:56:31',NULL),(832,7941,40874,210675,5,832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',99832312.57,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 13:59:47','2024-07-22 13:59:47',NULL),(833,7941,40874,210658,5,833,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2666744.03,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 14:52:23','2024-07-22 14:52:23',NULL),(834,7941,40874,210659,5,834,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2798622.59,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 14:54:03','2024-07-22 14:54:03',NULL),(835,7941,40874,210660,5,835,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4360000.00,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 14:56:00','2024-08-06 16:01:12','2024-08-06 16:01:12'),(836,7941,40874,210661,5,836,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3000182.59,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 14:58:28','2024-08-06 16:01:50','2024-08-06 16:01:50'),(837,7941,40874,210662,5,837,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3400000.00,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 15:00:09','2024-07-22 15:00:09',NULL),(838,7941,40874,210663,5,838,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4231230.97,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 15:01:56','2024-07-22 15:01:56',NULL),(839,7941,40874,210664,5,839,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4995760.79,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 15:03:21','2024-07-22 15:03:21',NULL),(840,7941,40874,210665,5,840,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5211495.47,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 15:06:33','2024-07-22 15:06:33',NULL),(841,7941,40874,210666,5,841,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',8100000.00,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 15:09:55','2024-07-22 15:09:55',NULL),(842,7941,40874,210660,5,842,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',30101271.58,'BANCO CREDICOOP 99962',NULL,1,'2024-07-22 16:35:58','2024-07-22 16:35:58',NULL),(843,7941,40874,210673,5,843,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',21607.50,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 16:56:03','2024-07-22 16:56:03',NULL);
INSERT INTO `balance_libro` VALUES (844,7941,40874,210674,5,844,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',81737.15,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 16:58:17','2024-07-22 16:58:17',NULL),(845,7941,40874,210675,5,845,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',28914.64,'BANCO SUPERVIELLE 79963',NULL,1,'2024-07-22 17:00:47','2024-08-06 16:02:42','2024-08-06 16:02:42'),(846,7941,40874,210658,5,846,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',82215663.32,'BANCO CREDICOOP 59029',NULL,1,'2024-07-24 11:19:18','2024-07-26 09:19:09','2024-07-26 09:19:09'),(847,7941,40874,210659,5,847,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',73479195.89,'BANCO CREDICOOP 59029',NULL,1,'2024-07-24 11:26:32','2024-07-26 09:22:35','2024-07-26 09:22:35'),(848,7941,40874,210658,5,848,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2224512.63,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:24:23','2024-07-24 17:24:23',NULL),(849,7941,40874,210659,5,849,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',9339694.98,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:25:51','2024-07-24 17:25:51',NULL),(850,7941,40874,210660,5,850,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11433477.81,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:27:22','2024-07-24 17:27:22',NULL),(851,7941,40874,210661,5,851,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5393787.68,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:29:05','2024-07-24 17:29:05',NULL),(852,7941,40874,210662,5,852,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',7964962.69,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:30:40','2024-07-24 17:30:40',NULL),(853,7941,40874,210663,5,853,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',54419147.90,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:32:11','2024-07-24 17:35:28','2024-07-24 17:35:28'),(854,7941,40874,210664,5,854,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',87441524.28,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:33:45','2024-07-24 17:33:45',NULL),(855,7941,40874,210663,5,855,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',54419147.90,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:35:28','2024-07-24 17:35:28',NULL),(856,7941,40874,210665,5,856,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',11957793.33,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:37:54','2024-07-24 17:37:54',NULL),(857,7941,40874,210666,5,857,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',234313080.35,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:39:42','2024-07-24 17:39:42',NULL),(858,7941,40874,210673,5,858,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',35174851.22,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:40:55','2024-07-24 17:40:55',NULL),(859,7941,40874,210674,5,859,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',21319515.28,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:42:21','2024-07-24 17:42:21',NULL),(860,7941,40874,210675,5,860,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',220646636.25,'FONDO COMUN DE INVERSION',NULL,1,'2024-07-24 17:43:30','2024-07-24 17:43:30',NULL),(861,7941,40874,210658,5,861,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',695904.71,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 15:31:02','2024-07-25 15:31:02',NULL);
INSERT INTO `balance_libro` VALUES (862,7941,40874,210659,5,862,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1709373.83,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 15:34:46','2024-07-25 15:34:46',NULL),(863,7941,40874,210660,5,863,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1093825.16,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 15:41:18','2024-07-25 15:41:18',NULL),(864,7941,40874,210661,5,864,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2093258.56,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 15:48:47','2024-07-25 15:48:47',NULL),(865,7941,40874,210662,5,865,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',2761510.62,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 15:52:10','2024-07-25 15:52:10',NULL),(866,7941,40874,210663,5,866,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2623743.66,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 15:55:32','2024-07-25 15:55:32',NULL),(867,7941,40874,210664,5,867,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1476344.71,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 15:59:05','2024-07-25 15:59:05',NULL),(868,7941,40874,210665,5,868,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5633317.76,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 16:02:06','2024-07-25 16:02:06',NULL),(869,7941,40874,210666,5,869,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3857994.09,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 16:06:30','2024-07-25 16:06:30',NULL),(870,7941,40874,210673,5,870,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3384163.89,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 16:10:54','2024-07-25 16:10:54',NULL),(871,7941,40874,210674,5,871,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',2581779.49,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 16:13:43','2024-07-25 16:13:43',NULL),(872,7941,40874,210675,5,872,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',3390701.73,'TARJETA DE CREDITO VISA',NULL,1,'2024-07-25 16:17:13','2024-07-25 16:17:13',NULL),(873,7941,40874,210658,5,873,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',74174782.77,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 09:19:09','2024-08-06 15:17:38','2024-08-06 15:17:38'),(874,7941,40874,210659,5,874,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',73479195.89,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 09:22:35','2024-08-06 15:19:42','2024-08-06 15:19:42'),(875,7941,40874,210661,5,875,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',117183410.11,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 09:31:49','2024-08-06 15:34:02','2024-08-06 15:34:02'),(876,7941,40874,210662,5,876,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',190615582.12,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 09:41:19','2024-08-06 15:36:26','2024-08-06 15:36:26'),(877,7941,40874,210663,5,877,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',199302074.06,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 09:53:06','2024-08-06 15:38:43','2024-08-06 15:38:43'),(878,7941,40874,210664,5,878,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',250098470.62,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 10:00:21','2024-08-06 15:41:16','2024-08-06 15:41:16');
INSERT INTO `balance_libro` VALUES (879,7941,40874,210665,5,879,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',249985078.53,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 10:07:39','2024-08-06 15:43:25','2024-08-06 15:43:25'),(880,7941,40874,210673,5,880,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',213905238.03,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 10:16:13','2024-08-06 15:55:56','2024-08-06 15:55:56'),(881,7941,40874,210674,5,881,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',358989848.87,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 10:22:45','2024-08-06 15:57:45','2024-08-06 15:57:45'),(882,7941,40874,210675,5,882,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',522450481.77,'BANCO CREDICOOP 59029',NULL,1,'2024-07-26 10:31:42','2024-08-06 15:59:13','2024-08-06 15:59:13'),(883,7941,40874,210660,5,883,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9000000.00,'Prestamo Cuenta 59029',NULL,1,'2024-08-02 15:19:03','2024-08-02 15:19:03',NULL),(884,7941,40874,210661,5,884,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1949287.52,'Cuota 1 de 6',NULL,1,'2024-08-02 15:22:15','2024-08-07 17:38:41','2024-08-07 17:38:41'),(885,7941,40874,210662,5,885,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1950642.09,'Cuota 2 de 6',NULL,1,'2024-08-02 15:24:36','2024-08-07 17:40:04','2024-08-07 17:40:04'),(886,7941,40874,210663,5,886,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1937347.72,'Cuota 3 de 6',NULL,1,'2024-08-02 15:26:48','2024-08-07 17:41:42','2024-08-07 17:41:42'),(887,7941,40874,210664,5,887,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1906134.30,'Cuota 4 de 6',NULL,1,'2024-08-02 15:28:46','2024-08-02 15:30:26','2024-08-02 15:30:26'),(888,7941,40874,210665,5,888,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1906134.30,'Cuota 5 de 6',NULL,1,'2024-08-02 15:30:26','2024-08-07 17:44:41','2024-08-07 17:44:41'),(889,7941,40874,210664,5,889,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1914059.80,'Cuota 4 de 6',NULL,1,'2024-08-02 15:32:27','2024-08-07 17:43:17','2024-08-07 17:43:17'),(890,7941,40874,210666,5,890,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1885556.84,'Cuota 6 de 6',NULL,1,'2024-08-02 15:34:03','2024-08-07 17:46:13','2024-08-07 17:46:13'),(891,7941,40874,210666,5,891,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',17000000.00,'Prestamo Cuenta 59029',NULL,1,'2024-08-02 15:36:21','2024-08-02 15:36:21',NULL),(892,7941,40874,210674,5,892,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',5851936.75,'Cuota 1 de 6',NULL,1,'2024-08-02 15:38:29','2024-08-07 17:48:54','2024-08-07 17:48:54'),(893,7941,40874,210675,5,893,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4597795.37,'Cuota 2 de 6',NULL,1,'2024-08-02 15:39:59','2024-08-07 17:53:41','2024-08-07 17:53:41'),(894,7941,40876,213712,3,894,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2553540.15,'SUBDIARIO COMPRAS',NULL,1,'2024-08-05 15:44:28','2024-08-05 15:44:28',NULL),(895,7941,40874,210658,3,895,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',24556327.36,'COMPRAS',NULL,1,'2024-08-05 17:19:59','2024-08-05 17:19:59',NULL),(896,7941,40874,210659,3,896,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',21967867.51,'COMPRAS',NULL,1,'2024-08-05 17:30:05','2024-08-05 17:30:05',NULL);
INSERT INTO `balance_libro` VALUES (897,7941,40874,210660,3,897,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',25812686.35,'COMPRAS',NULL,1,'2024-08-05 17:42:42','2024-08-05 17:42:42',NULL),(898,7941,40874,210661,3,898,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',32174941.10,'COMPRAS',NULL,1,'2024-08-05 17:55:23','2024-08-05 17:55:23',NULL),(899,7941,40874,210662,3,899,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',66489891.63,'COMPRAS',NULL,1,'2024-08-06 09:30:15','2024-08-06 09:30:15',NULL),(900,7941,40874,210663,3,900,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',32532661.11,'COMPRAS',NULL,1,'2024-08-06 09:44:02','2024-08-06 09:44:02',NULL),(901,7941,40874,210664,3,901,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',49883123.71,'COMPRAS',NULL,1,'2024-08-06 09:55:42','2024-08-06 09:55:42',NULL),(902,7941,40874,210665,3,902,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',44299375.83,'COMPRAS',NULL,1,'2024-08-06 10:07:07','2024-08-06 10:07:07',NULL),(903,7941,40874,210666,3,903,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',55929144.78,'COMPRAS',NULL,1,'2024-08-06 10:16:55','2024-08-06 10:16:55',NULL),(904,7941,40874,210673,3,904,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',97920304.15,'COMPRAS',NULL,1,'2024-08-06 10:27:17','2024-08-06 10:27:17',NULL),(905,7941,40874,210674,3,905,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',91390625.56,'COMPRAS',NULL,1,'2024-08-06 10:35:24','2024-08-06 10:35:24',NULL),(906,7941,40874,210675,3,906,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',131212805.16,'COMPRAS',NULL,1,'2024-08-06 10:47:04','2024-08-06 10:47:04',NULL),(907,7941,40874,210658,5,907,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',74174782.77,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:17:38','2024-08-06 15:17:38',NULL),(908,7941,40874,210659,5,908,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',73479195.89,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:19:42','2024-08-06 15:19:42',NULL),(909,7941,40874,210660,5,909,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',102562743.34,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:31:22','2024-08-06 15:31:22',NULL),(910,7941,40874,210661,5,910,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',117183410.11,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:34:02','2024-08-06 15:34:02',NULL),(911,7941,40874,210662,5,911,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',190615582.12,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:36:26','2024-08-06 15:36:26',NULL),(912,7941,40874,210663,5,912,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',199302074.06,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:38:43','2024-08-06 15:38:43',NULL),(913,7941,40874,210664,5,913,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',250098470.62,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:41:16','2024-08-06 15:41:16',NULL),(914,7941,40874,210665,5,914,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',249985078.53,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:43:25','2024-08-06 15:43:25',NULL),(915,7941,40874,210666,5,915,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',488166840.33,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:53:32','2024-08-06 15:53:32',NULL);
INSERT INTO `balance_libro` VALUES (916,7941,40874,210673,5,916,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',213905238.03,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:55:56','2024-08-06 15:55:56',NULL),(917,7941,40874,210674,5,917,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',358989848.87,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:57:45','2024-08-07 15:36:19','2024-08-07 15:36:19'),(918,7941,40874,210675,5,918,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',522450481.77,'BANCO CREDICOOP 59029',NULL,1,'2024-08-06 15:59:13','2024-08-06 15:59:13',NULL),(919,7941,40874,210660,5,919,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4360000.00,'BANCO SUPERVIELLE 79963',NULL,1,'2024-08-06 16:01:12','2024-08-06 16:01:12',NULL),(920,7941,40874,210661,5,920,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3000182.59,'BANCO SUPERVIELLE 79963',NULL,1,'2024-08-06 16:01:50','2024-08-06 16:01:50',NULL),(921,7941,40874,210675,5,921,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',28914.64,'BANCO SUPERVIELLE 79963',NULL,1,'2024-08-06 16:02:42','2024-08-06 16:02:42',NULL),(922,7941,40874,210661,5,922,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1142079.17,'BANCO CREDICOOP 97980',NULL,1,'2024-08-06 16:04:13','2024-08-06 16:04:13',NULL),(923,7941,40874,210662,5,923,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4038500.00,'BANCO CREDICOOP 97980',NULL,1,'2024-08-06 16:04:56','2024-08-06 16:04:56',NULL),(924,7941,40874,210673,5,924,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',12000.00,'BANCO CREDICOOP 97980',NULL,1,'2024-08-06 16:05:40','2024-08-06 16:05:40',NULL),(925,7941,40874,210674,5,925,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1008000.00,'BANCO CREDICOOP 97980',NULL,1,'2024-08-06 16:06:34','2024-08-06 16:06:34',NULL),(926,7941,40874,210675,5,926,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',8000.00,'BANCO CREDICOOP 97980',NULL,1,'2024-08-06 16:07:07','2024-08-06 16:07:07',NULL),(927,7941,40874,210674,5,927,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',31380904.24,'BANCO CREDICOOP 69495',NULL,1,'2024-08-06 16:11:41','2024-08-06 16:11:41',NULL),(928,7941,40874,210675,5,928,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',32601963.64,'BANCO CREDICOOP 69495',NULL,1,'2024-08-06 16:12:39','2024-08-06 16:12:39',NULL),(929,7941,40874,210658,5,929,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6378857.70,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 16:27:44','2024-08-06 16:27:44',NULL),(930,7941,40874,210659,5,930,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7941496.62,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 16:34:31','2024-08-06 16:34:31',NULL),(931,7941,40874,210660,5,931,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10097614.36,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 16:40:24','2024-08-06 16:40:24',NULL),(932,7941,40874,210661,5,932,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',8075853.75,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 16:47:19','2024-08-06 16:47:19',NULL),(933,7941,40874,210662,5,933,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',9146759.71,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 16:53:18','2024-08-06 16:53:18',NULL);
INSERT INTO `balance_libro` VALUES (934,7941,40874,210663,5,934,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',11279535.17,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 16:58:14','2024-08-06 16:58:14',NULL),(935,7941,40874,210664,5,935,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',13196516.94,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 17:03:15','2024-08-06 17:03:15',NULL),(936,7941,40874,210665,5,936,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',15515817.71,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 17:08:38','2024-08-06 17:08:38',NULL),(937,7941,40874,210666,5,937,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',21283316.20,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 17:12:51','2024-08-06 17:12:51',NULL),(938,7941,40874,210673,5,938,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',23893036.53,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 17:18:45','2024-08-06 17:18:45',NULL),(939,7941,40874,210674,5,939,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',31995458.59,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 17:23:58','2024-08-06 17:23:58',NULL),(940,7941,40874,210675,5,940,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',32854436.86,'MERCADO PAGO CUENTA 1',NULL,1,'2024-08-06 17:29:14','2024-08-06 17:29:14',NULL),(941,7941,40874,210658,5,941,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2539217.40,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 17:34:29','2024-08-06 17:34:29',NULL),(942,7941,40874,210659,5,942,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3778662.65,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 17:39:12','2024-08-06 17:39:12',NULL),(943,7941,40874,210660,5,943,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2620688.08,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 17:43:08','2024-08-06 17:43:08',NULL),(944,7941,40874,210661,5,944,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4265060.99,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 17:48:33','2024-08-06 17:48:33',NULL),(945,7941,40874,210662,5,945,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4066076.00,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 17:53:49','2024-08-06 17:53:49',NULL),(946,7941,40874,210663,5,946,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4267867.27,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 17:58:34','2024-08-06 17:58:34',NULL),(947,7941,40874,210664,5,947,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',3896038.99,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 18:03:00','2024-08-06 18:03:00',NULL),(948,7941,40874,210665,5,948,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',4309052.64,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 18:07:11','2024-08-06 18:07:11',NULL),(949,7941,40874,210666,5,949,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',865683.04,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 18:10:40','2024-08-06 18:10:40',NULL),(950,7941,40874,210673,5,950,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',18670.50,'MERCADO PAGO CUENTA 2',NULL,1,'2024-08-06 18:15:33','2024-08-06 18:15:33',NULL),(951,7941,40874,210674,5,951,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',358989848.87,'BANCO CREDICOOP 59029',NULL,1,'2024-08-07 15:36:19','2024-08-07 15:36:19',NULL);
INSERT INTO `balance_libro` VALUES (952,7941,40874,210658,5,952,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3022023.82,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 16:36:00','2024-08-07 16:36:00',NULL),(953,7941,40874,210659,5,953,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1118246.27,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 16:39:43','2024-08-07 16:39:43',NULL),(954,7941,40874,210660,5,954,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2281561.80,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 16:46:04','2024-08-07 16:46:04',NULL),(955,7941,40874,210661,5,955,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2802431.17,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 16:51:12','2024-08-07 16:51:12',NULL),(956,7941,40874,210662,5,956,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',2004506.28,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 16:55:46','2024-08-07 16:55:46',NULL),(957,7941,40874,210663,5,957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2172328.82,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 16:59:52','2024-08-07 16:59:52',NULL),(958,7941,40874,210664,5,958,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',2323454.56,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 17:04:11','2024-08-07 17:04:11',NULL),(959,7941,40874,210665,5,959,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2444357.40,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 17:08:09','2024-08-07 17:08:09',NULL),(960,7941,40874,210666,5,960,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2620947.07,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 17:12:22','2024-08-07 17:12:22',NULL),(961,7941,40874,210673,5,961,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2705810.49,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 17:17:23','2024-08-07 17:17:23',NULL),(962,7941,40874,210674,5,962,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',2822462.93,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 17:22:47','2024-08-07 17:22:47',NULL),(963,7941,40874,210675,5,963,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2870857.58,'MERCADO PAGO CUENTA 4',NULL,1,'2024-08-07 17:26:32','2024-08-07 17:26:32',NULL),(964,7941,40874,210675,5,964,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4309866.39,'MERCADO PAGO CUENTA 3',NULL,1,'2024-08-07 17:31:51','2024-08-07 17:31:51',NULL),(965,7941,40874,210675,5,965,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2872415.00,'MERCADO PAGO CUENTA 5',NULL,1,'2024-08-07 17:34:21','2024-08-07 17:34:21',NULL),(966,7941,40874,210661,5,966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1949287.52,'Cuota 1 de 6',NULL,1,'2024-08-07 17:38:41','2024-08-07 17:38:41',NULL),(967,7941,40874,210662,5,967,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1950642.09,'Cuota 2 de 6',NULL,1,'2024-08-07 17:40:04','2024-08-07 17:40:04',NULL),(968,7941,40874,210663,5,968,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1937347.72,'Cuota 3 de 6',NULL,1,'2024-08-07 17:41:42','2024-08-07 17:41:42',NULL),(969,7941,40874,210664,5,969,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1914059.80,'Cuota 4 de 6',NULL,1,'2024-08-07 17:43:17','2024-08-07 17:43:17',NULL);
INSERT INTO `balance_libro` VALUES (970,7941,40874,210665,5,970,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1906134.30,'Cuota 5 de 6',NULL,1,'2024-08-07 17:44:41','2024-08-07 17:44:41',NULL),(971,7941,40874,210666,5,971,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1885556.84,'Cuota 6 de 6',NULL,1,'2024-08-07 17:46:13','2024-08-07 17:46:13',NULL),(972,7941,40874,210674,5,972,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',5851936.75,'Cuota 1 de 6',NULL,1,'2024-08-07 17:48:54','2024-08-07 17:48:54',NULL),(973,7941,40874,210658,5,973,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',737332.40,'Cuota 4 de 6',NULL,1,'2024-08-07 17:53:41','2024-08-07 17:53:41',NULL),(974,7941,40874,210659,5,974,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',730651.33,'Cuota 5 de 6',NULL,1,'2024-08-07 17:57:15','2024-08-07 17:57:15',NULL),(975,7941,40874,210660,5,975,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',727149.26,'Cuota 6 de 6',NULL,1,'2024-08-07 17:59:18','2024-08-07 17:59:18',NULL),(976,7941,40874,210675,5,976,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4597795.37,'Cuota 2 de 6',NULL,1,'2024-08-07 18:01:38','2024-08-07 18:01:38',NULL),(977,7941,40874,210658,5,977,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',7307729.56,'BANCO CREDICOOP 69495',NULL,1,'2024-08-13 08:51:57','2024-08-13 09:03:50','2024-08-13 09:03:50'),(978,7941,40874,210675,5,978,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',157975408.05,'Ajuste MP a banco Superville',NULL,1,'2024-08-21 09:00:18','2024-08-21 09:00:18',NULL),(979,7941,40878,216749,2,979,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',207086.66,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 16:55:26','2024-08-29 09:46:08','2024-08-29 09:46:08'),(980,7941,40878,216750,2,980,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',224481.62,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 16:56:50','2024-08-28 16:56:50',NULL),(981,7941,40878,216751,2,981,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',241990.32,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 16:59:13','2024-08-28 16:59:13',NULL),(982,7941,40878,216752,2,982,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',256510.32,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:00:33','2024-08-28 17:00:33',NULL),(983,7941,40878,216753,2,983,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',272671.08,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:01:50','2024-08-28 17:01:50',NULL),(984,7941,40878,216754,2,984,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',306482.11,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:02:59','2024-08-28 17:02:59',NULL),(985,7941,40878,216755,2,985,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',345405.39,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:04:13','2024-08-28 17:04:13',NULL),(986,7941,40878,216756,2,986,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',374073.92,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:05:50','2024-08-28 17:05:50',NULL),(987,7941,40878,216764,2,987,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',421992.34,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:11:12','2024-08-28 17:11:12',NULL);
INSERT INTO `balance_libro` VALUES (988,7941,40878,216765,2,988,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',529600.06,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:12:26','2024-08-28 17:12:26',NULL),(989,7941,40878,216766,2,989,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',638773.52,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:13:48','2024-08-28 17:13:48',NULL),(990,7941,40878,216767,2,990,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',723091.62,'SUBDIARIO VENTAS',NULL,1,'2024-08-28 17:14:55','2024-08-28 17:14:55',NULL),(991,7941,40878,216749,16,991,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4278.65,'DJ IIBB',NULL,1,'2024-08-28 17:35:07','2024-08-29 11:39:32','2024-08-29 11:39:32'),(992,7941,40878,216751,1,992,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10000.00,'SUELDOS',NULL,1,'2024-08-28 22:09:05','2024-08-28 22:10:00','2024-08-28 22:10:00'),(993,7941,40878,216749,5,993,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',197489.90,'BANCO CREDICOOP',NULL,1,'2024-08-28 22:23:30','2024-08-28 22:25:14','2024-08-28 22:25:14'),(994,7941,40878,216749,5,994,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',197489.90,'BANCO CREDICOOP',NULL,1,'2024-08-28 22:25:14','2024-08-28 22:28:10','2024-08-28 22:28:10'),(995,7941,40878,216749,5,995,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',197489.90,'BANCO CREDICOOP',NULL,1,'2024-08-28 22:28:10','2024-08-28 22:28:10',NULL),(996,7941,40878,216750,5,996,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',302794.13,'BANCO CREDICOOP',NULL,1,'2024-08-29 08:58:47','2024-09-03 16:41:47','2024-09-03 16:41:47'),(997,7941,40878,216751,5,997,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',230662.80,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:02:06','2024-08-29 09:02:06',NULL),(998,7941,40878,216752,5,998,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',263939.47,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:09:10','2024-08-29 09:09:10',NULL),(999,7941,40878,216753,5,999,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',268822.20,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:12:03','2024-08-29 09:12:03',NULL),(1000,7941,40878,216754,5,1000,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',320112.60,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:14:57','2024-08-29 09:14:57',NULL),(1001,7941,40878,216755,5,1001,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',206650.51,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:20:27','2024-08-29 09:20:27',NULL),(1002,7941,40878,216756,5,1002,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',704001.97,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:23:41','2024-08-29 09:23:41',NULL),(1003,7941,40878,216764,5,1003,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',401739.10,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:27:28','2024-08-29 09:27:28',NULL),(1004,7941,40878,216765,5,1004,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',571624.59,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:29:53','2024-08-29 09:29:53',NULL),(1005,7941,40878,216766,5,1005,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',614057.84,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:32:03','2024-08-29 09:32:03',NULL);
INSERT INTO `balance_libro` VALUES (1006,7941,40878,216767,5,1006,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',687907.84,'BANCO CREDICOOP',NULL,1,'2024-08-29 09:34:10','2024-08-29 09:34:10',NULL),(1007,7941,40878,216749,3,1007,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',36300.00,'COMPRAS',NULL,1,'2024-08-29 09:35:32','2024-08-29 09:35:32',NULL),(1008,7941,40878,216749,15,1008,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',35940.66,'DJ IVA',NULL,1,'2024-08-29 09:43:55','2024-08-29 09:43:55',NULL),(1009,7941,40878,216749,2,1009,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',207086.66,'SUBDIARIO VENTAS',NULL,1,'2024-08-29 09:46:08','2024-08-29 09:46:08',NULL),(1010,7941,40878,216750,3,1010,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',693088.00,'COMPRAS',NULL,1,'2024-08-29 09:49:44','2024-08-29 09:49:44',NULL),(1011,7941,40878,216751,3,1011,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',56628.00,'COMPRAS',NULL,1,'2024-08-29 09:55:40','2024-08-29 09:55:40',NULL),(1012,7941,40878,216752,3,1012,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',359128.00,'COMPRAS',NULL,1,'2024-08-29 09:57:40','2024-08-29 09:57:40',NULL),(1013,7941,40878,216753,3,1013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',468028.00,'COMPRAS',NULL,1,'2024-08-29 09:58:47','2024-08-29 09:58:47',NULL),(1014,7941,40878,216754,3,1014,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',431728.00,'COMPRAS',NULL,1,'2024-08-29 10:01:23','2024-08-29 10:01:23',NULL),(1015,7941,40878,216755,3,1015,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',450362.00,'COMPRAS',NULL,1,'2024-08-29 10:02:56','2024-08-29 10:02:56',NULL),(1016,7941,40878,216756,3,1016,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',87362.00,'COMPRAS',NULL,1,'2024-08-29 10:04:29','2024-08-29 10:04:29',NULL),(1017,7941,40878,216764,3,1017,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',694923.57,'COMPRAS',NULL,1,'2024-08-29 10:05:41','2024-08-29 10:05:41',NULL),(1018,7941,40878,216765,3,1018,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',131587.50,'COMPRAS',NULL,1,'2024-08-29 10:06:55','2024-08-29 10:06:55',NULL),(1019,7941,40878,216766,3,1019,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',327000.00,'COMPRAS',NULL,1,'2024-08-29 10:08:00','2024-08-29 10:08:00',NULL),(1020,7941,40878,216767,3,1020,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',776429.09,'COMPRAS',NULL,1,'2024-08-29 10:09:18','2024-08-29 10:09:18',NULL),(1021,7941,40878,216750,15,1021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',121320.00,'DJ IVA',NULL,1,'2024-08-29 10:45:12','2024-08-29 10:45:12',NULL),(1022,7941,40878,216751,15,1022,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',93220.38,'DJ IVA',NULL,1,'2024-08-29 10:51:34','2024-08-29 10:51:34',NULL),(1023,7941,40878,216752,15,1023,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',114598.62,'DJ IVA',NULL,1,'2024-08-29 10:56:23','2024-08-29 10:56:23',NULL),(1024,7941,40878,216753,15,1024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',152361.54,'DJ IVA',NULL,1,'2024-08-29 11:00:10','2024-08-29 11:00:10',NULL);
INSERT INTO `balance_libro` VALUES (1025,7941,40878,216754,15,1025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',180998.45,'DJ IVA',NULL,1,'2024-08-29 11:10:03','2024-08-29 11:10:03',NULL),(1026,7941,40878,216755,15,1026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',207001.34,'DJ IVA',NULL,1,'2024-08-29 11:16:52','2024-08-29 11:16:52',NULL),(1027,7941,40878,216756,15,1027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',163249.41,'DJ IVA',NULL,1,'2024-08-29 11:19:39','2024-08-29 11:19:39',NULL),(1028,7941,40878,216764,15,1028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',219968.38,'DJ IVA',NULL,1,'2024-08-29 11:22:48','2024-08-29 11:22:48',NULL),(1029,7941,40878,216765,15,1029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',169747.54,'DJ IVA',NULL,1,'2024-08-29 11:25:09','2024-08-29 11:25:09',NULL),(1030,7941,40878,216766,15,1030,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',120013.48,'DJ IVA',NULL,1,'2024-08-29 11:29:57','2024-08-29 11:29:57',NULL),(1031,7941,40878,216766,15,1031,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',120013.48,'DJ IVA',NULL,1,'2024-08-29 11:29:58','2024-08-30 17:44:06','2024-08-30 17:44:06'),(1032,7941,40878,216767,15,1032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',129422.05,'DJ IVA',NULL,1,'2024-08-29 11:36:03','2024-08-29 11:36:03',NULL),(1033,7941,40878,216749,16,1033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4278.65,'DJ IIBB',NULL,1,'2024-08-29 11:39:32','2024-08-29 11:39:32',NULL),(1034,7941,40878,216750,16,1034,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4638.05,'DJ IIBB',NULL,1,'2024-08-29 11:45:28','2024-08-29 11:45:28',NULL),(1035,7941,40878,216751,16,1035,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3999.84,'DJ IIBB',NULL,1,'2024-08-29 11:51:06','2024-08-29 11:51:06',NULL),(1036,7941,40878,216752,16,1036,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4239.84,'DJ IIBB',NULL,1,'2024-08-29 11:52:31','2024-08-29 11:52:31',NULL),(1037,7941,40878,216753,16,1037,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4506.96,'DJ IIBB',NULL,1,'2024-08-29 11:53:49','2024-08-29 11:53:49',NULL),(1038,7941,40878,216754,16,1038,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',5925.13,'DJ IIBB',NULL,1,'2024-08-29 11:56:00','2024-08-29 11:56:00',NULL),(1039,7941,40878,216755,16,1039,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',8563.77,'DJ IIBB',NULL,1,'2024-08-29 11:58:20','2024-08-29 11:58:20',NULL),(1040,7941,40878,216756,16,1040,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',13775.49,'DJ IIBB',NULL,1,'2024-08-29 12:00:19','2024-08-29 12:00:19',NULL),(1041,7941,40878,216764,16,1041,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',10462.62,'DJ IIBB',NULL,1,'2024-08-29 12:03:00','2024-08-29 12:03:00',NULL),(1042,7941,40878,216765,16,1042,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',13130.58,'DJ IIBB',NULL,1,'2024-08-29 12:04:47','2024-08-29 12:04:47',NULL),(1043,7941,40878,216766,16,1043,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',15837.36,'DJ IIBB',NULL,1,'2024-08-29 12:06:03','2024-08-29 12:06:03',NULL);
INSERT INTO `balance_libro` VALUES (1044,7941,40878,216767,16,1044,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',17927.89,'DJ IIBB',NULL,1,'2024-08-29 12:08:10','2024-08-29 12:08:10',NULL),(1045,7941,40878,216749,12,1045,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',60998627.32,'SALDOS INICIALES',NULL,1,'2024-08-30 17:25:17','2024-08-30 17:25:17',NULL),(1046,7941,40735,24257,2,1046,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',42536588.61,'VENTAS',NULL,1,'2024-09-03 10:19:24','2024-09-03 10:19:57','2024-09-03 10:19:57'),(1047,7941,40879,218279,2,1047,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',42536588.61,'VENTAS',NULL,1,'2024-09-03 10:31:45','2024-09-03 10:31:45',NULL),(1048,7941,40879,218280,2,1048,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',55596861.73,'VENTAS',NULL,1,'2024-09-03 10:32:55','2024-09-03 10:32:55',NULL),(1049,7941,40879,218280,2,1049,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',55596861.73,'VENTAS',NULL,1,'2024-09-03 10:33:00','2024-09-03 10:33:17','2024-09-03 10:33:17'),(1050,7941,40879,218280,2,1050,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',55596861.73,'VENTAS',NULL,1,'2024-09-03 10:33:01','2024-09-03 10:33:22','2024-09-03 10:33:22'),(1051,7941,40879,218281,2,1051,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',55388492.48,'VENTAS',NULL,1,'2024-09-03 10:34:45','2024-09-03 10:34:45',NULL),(1052,7941,40879,218282,2,1052,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',54676773.46,'VENTAS',NULL,1,'2024-09-03 10:35:48','2024-09-03 10:35:48',NULL),(1053,7941,40879,218283,2,1053,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',68216377.06,'VENTAS',NULL,1,'2024-09-03 10:39:11','2024-09-03 10:39:11',NULL),(1054,7941,40879,218284,2,1054,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',74292937.55,'VENTAS',NULL,1,'2024-09-03 11:18:12','2024-09-03 11:18:12',NULL),(1055,7941,40879,218285,2,1055,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',70141429.79,'VENTAS',NULL,1,'2024-09-03 11:28:05','2024-09-03 11:28:05',NULL),(1056,7941,40879,218286,2,1056,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',120919465.35,'VENTAS',NULL,1,'2024-09-03 11:29:00','2024-09-03 11:55:54','2024-09-03 11:55:54'),(1057,7941,40879,218286,2,1057,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',101897670.52,'VENTAS',NULL,1,'2024-09-03 11:55:54','2024-09-03 11:55:54',NULL),(1058,7941,40879,218287,2,1058,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',120919465.35,'VENTAS',NULL,1,'2024-09-03 12:03:36','2024-09-03 12:03:36',NULL),(1059,7941,40879,218288,2,1059,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',149013266.64,'VENTAS',NULL,1,'2024-09-03 12:04:15','2024-09-03 12:04:15',NULL),(1060,7941,40879,218289,2,1060,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',172708970.34,'VENTAS',NULL,1,'2024-09-03 12:05:06','2024-09-03 12:05:06',NULL),(1061,7941,40879,218290,2,1061,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',186854547.02,'VENTAS',NULL,1,'2024-09-03 12:05:57','2024-09-03 12:05:57',NULL),(1062,7941,40879,218279,15,1062,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10496031.76,'DJ IVA',NULL,1,'2024-09-03 12:13:20','2024-09-03 12:17:14','2024-09-03 12:17:14');
INSERT INTO `balance_libro` VALUES (1063,7941,40879,218280,15,1063,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',9649042.12,'DJ IVA',NULL,1,'2024-09-03 12:16:05','2024-09-03 12:16:05',NULL),(1064,7941,40879,218279,15,1064,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10496031.76,'DJ IVA',NULL,1,'2024-09-03 12:17:14','2024-09-03 12:17:14',NULL),(1065,7941,40879,218281,15,1065,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',10212827.38,'DJ IVA',NULL,1,'2024-09-03 12:19:05','2024-09-03 12:19:05',NULL),(1066,7941,40879,218282,15,1066,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',9489357.38,'DJ IVA',NULL,1,'2024-09-03 12:21:39','2024-09-03 12:21:39',NULL),(1067,7941,40879,218283,15,1067,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',12471957.41,'DJ IVA',NULL,1,'2024-09-03 12:22:51','2024-09-03 12:22:52',NULL),(1068,7941,40879,218284,15,1068,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',12893815.61,'DJ IVA',NULL,1,'2024-09-03 12:24:52','2024-09-03 12:24:52',NULL),(1069,7941,40879,218285,15,1069,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',12173306.00,'DJ IVA',NULL,1,'2024-09-03 12:27:46','2024-09-03 12:27:46',NULL),(1070,7941,40879,218286,15,1070,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',17684719.68,'DJ IVA',NULL,1,'2024-09-03 12:29:00','2024-09-03 12:29:00',NULL),(1071,7941,40879,218287,15,1071,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',20970188.91,'DJ IVA',NULL,1,'2024-09-03 12:29:57','2024-09-03 12:29:57',NULL),(1072,7941,40879,218288,15,1072,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',25861806.61,'DJ IVA',NULL,1,'2024-09-03 12:31:10','2024-09-03 12:31:10',NULL),(1073,7941,40879,218289,15,1073,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',29974284.11,'DJ IVA',NULL,1,'2024-09-03 12:32:03','2024-09-03 12:32:03',NULL),(1074,7941,40879,218290,15,1074,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',43531420.07,'DJ IVA',NULL,1,'2024-09-03 12:33:35','2024-09-03 12:33:35',NULL),(1075,7941,40878,216767,7,1075,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',217839.02,'RETENCIONES IIGG',NULL,1,'2024-09-03 15:16:18','2024-09-03 15:16:18',NULL),(1076,7941,40878,216750,5,1076,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',302794.13,'BANCO CREDICOOP',NULL,1,'2024-09-03 16:41:47','2024-09-03 16:41:47',NULL),(1077,7941,40879,218279,3,1077,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',54498963.16,'COMPRAS',NULL,1,'2024-09-13 11:42:43','2024-09-16 08:37:17','2024-09-16 08:37:17'),(1078,7941,40879,218280,3,1078,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',12130839.50,'COMPRAS',NULL,1,'2024-09-13 11:58:39','2024-09-16 08:42:36','2024-09-16 08:42:36'),(1079,7941,40879,218281,3,1079,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',58489781.29,'COMPRAS',NULL,1,'2024-09-13 12:14:57','2024-09-13 12:49:24','2024-09-13 12:49:24'),(1080,7941,40879,218282,3,1080,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',54723572.99,'COMPRAS',NULL,1,'2024-09-13 12:38:50','2024-09-16 08:40:47','2024-09-16 08:40:47'),(1081,7941,40879,218281,3,1081,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',58489781.29,'COMPRAS',NULL,1,'2024-09-13 12:49:24','2024-09-16 08:46:30','2024-09-16 08:46:30');
INSERT INTO `balance_libro` VALUES (1082,7941,40879,218279,3,1082,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',54498963.16,'COMPRAS',NULL,1,'2024-09-16 08:37:17','2024-10-04 13:09:10','2024-10-04 13:09:10'),(1083,7941,40879,218282,3,1083,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',54723572.99,'COMPRAS',NULL,1,'2024-09-16 08:40:47','2024-10-04 13:14:03','2024-10-04 13:14:03'),(1084,7941,40879,218280,3,1084,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',12130839.50,'COMPRAS',NULL,1,'2024-09-16 08:42:36','2024-10-04 13:11:20','2024-10-04 13:11:20'),(1085,7941,40879,218281,3,1085,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',58489781.29,'COMPRAS',NULL,1,'2024-09-16 08:46:30','2024-10-04 13:12:07','2024-10-04 13:12:07'),(1086,7941,40879,218283,3,1086,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',72897388.56,'COMPRAS',NULL,1,'2024-09-16 09:27:46','2024-10-04 13:17:00','2024-10-04 13:17:00'),(1087,7941,40879,218284,3,1087,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',43457476.53,'COMPRAS',NULL,1,'2024-09-16 09:50:30','2024-09-19 11:57:46','2024-09-19 11:57:46'),(1088,7941,40879,218285,3,1088,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',49741038.98,'COMPRAS',NULL,1,'2024-09-16 10:15:54','2024-09-16 10:15:54',NULL),(1089,7941,40879,218286,3,1089,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',90117173.57,'COMPRAS',NULL,1,'2024-09-16 11:10:20','2024-09-16 11:10:20',NULL),(1090,7941,40879,218287,3,1090,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',45490196.04,'COMPRAS',NULL,1,'2024-09-16 11:34:21','2024-09-16 11:34:21',NULL),(1091,7941,40879,218288,3,1091,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',27219335.46,'COMPRAS',NULL,1,'2024-09-16 11:51:24','2024-09-16 11:51:24',NULL),(1092,7941,40879,218289,3,1092,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',69752694.26,'COMPRAS',NULL,1,'2024-09-16 12:07:35','2024-09-16 12:07:35',NULL),(1093,7941,40879,218279,16,1093,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3806874.13,'DJ IIBB',NULL,1,'2024-09-17 10:08:45','2024-09-17 10:08:45',NULL),(1094,7941,40879,218280,16,1094,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4817089.73,'DJ IIBB',NULL,1,'2024-09-17 10:28:04','2024-09-17 10:28:04',NULL),(1095,7941,40879,218281,16,1095,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6806287.62,'DJ IIBB',NULL,1,'2024-09-17 10:36:29','2024-09-17 10:36:29',NULL),(1096,7941,40879,218282,16,1096,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',6331651.97,'DJ IIBB',NULL,1,'2024-09-17 10:46:27','2024-09-17 10:46:27',NULL),(1097,7941,40879,218283,16,1097,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',5811004.33,'DJ IIBB',NULL,1,'2024-09-17 10:53:18','2024-09-17 10:53:18',NULL),(1098,7941,40879,218284,16,1098,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',4904383.51,'DJ IIBB',NULL,1,'2024-09-17 10:56:58','2024-09-17 10:56:58',NULL),(1099,7941,40879,218285,16,1099,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3929582.21,'DJ IIBB',NULL,1,'2024-09-17 11:01:46','2024-09-17 11:01:46',NULL),(1100,7941,40879,218286,16,1100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3445356.10,'DJ IIBB',NULL,1,'2024-09-17 11:04:55','2024-09-17 11:04:55',NULL);
INSERT INTO `balance_libro` VALUES (1101,7941,40879,218287,16,1101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',3398325.37,'DJ IIBB',NULL,1,'2024-09-17 11:09:04','2024-09-17 11:09:04',NULL),(1102,7941,40879,218288,16,1102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4187211.22,'DJ IIBB',NULL,1,'2024-09-17 11:11:58','2024-09-17 11:11:58',NULL),(1103,7941,40879,218289,16,1103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',5113073.70,'DJ IIBB',NULL,1,'2024-09-17 11:16:03','2024-09-17 11:16:03',NULL),(1104,7941,40879,218290,16,1104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',6848384.03,'DJ IIBB',NULL,1,'2024-09-17 11:27:31','2024-09-17 11:27:31',NULL),(1105,7941,40879,218279,1,1105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',18087861.25,'Sueldos',NULL,1,'2024-09-17 11:54:14','2024-09-17 11:54:14',NULL),(1106,7941,40879,218280,1,1106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',13701492.77,'Sueldos',NULL,1,'2024-09-17 12:50:27','2024-09-17 12:50:27',NULL),(1107,7941,40879,218281,1,1107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',15694620.57,'Sueldos',NULL,1,'2024-09-17 12:52:44','2024-09-17 12:52:44',NULL),(1108,7941,40879,218281,1,1108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',15694620.57,'Sueldos',NULL,1,'2024-09-17 12:52:45','2024-09-17 12:53:16','2024-09-17 12:53:16'),(1109,7941,40879,218281,1,1109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',15694620.57,'Sueldos',NULL,1,'2024-09-17 12:52:46','2024-09-17 12:53:11','2024-09-17 12:53:11'),(1110,7941,40879,218282,1,1110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',16193934.01,'Sueldos',NULL,1,'2024-09-17 12:56:18','2024-09-17 12:56:18',NULL),(1111,7941,40879,218283,1,1111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',19199927.32,'Sueldos',NULL,1,'2024-09-17 12:58:45','2024-09-17 12:58:45',NULL),(1112,7941,40879,218284,1,1112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',21544349.48,'Sueldos',NULL,1,'2024-09-17 13:00:23','2024-09-17 13:00:23',NULL),(1113,7941,40879,218285,1,1113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',34087280.32,'Sueldos',NULL,1,'2024-09-17 13:02:33','2024-09-17 13:02:33',NULL),(1114,7941,40879,218286,1,1114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',32056335.08,'Sueldos',NULL,1,'2024-09-17 13:04:06','2024-09-17 13:04:06',NULL),(1115,7941,40879,218287,1,1115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',36058418.77,'Sueldos',NULL,1,'2024-09-17 13:05:33','2024-09-17 13:05:33',NULL),(1116,7941,40879,218288,1,1116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',32024815.75,'Sueldos',NULL,1,'2024-09-17 13:07:17','2024-09-17 13:07:17',NULL),(1117,7941,40879,218289,1,1117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',36787322.41,'Sueldos',NULL,1,'2024-09-17 13:08:31','2024-09-17 13:08:31',NULL),(1118,7941,40879,218290,1,1118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',38458743.26,'Sueldos',NULL,1,'2024-09-17 13:09:44','2024-09-17 13:09:44',NULL),(1119,7941,40875,212195,2,1119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',11724635.01,'SUBDIARIO VENTAS',NULL,1,'2024-09-18 12:13:26','2024-09-18 12:13:26',NULL);
INSERT INTO `balance_libro` VALUES (1120,7941,40875,212195,15,1120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2034854.01,'DJ IVA',NULL,1,'2024-09-18 12:14:40','2024-09-18 12:14:40',NULL),(1121,7941,40875,212194,15,1121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1428019.11,'DJ IVA',NULL,1,'2024-09-18 12:17:13','2024-09-18 12:17:14',NULL),(1122,7941,40875,212195,3,1122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1361366.04,'SUBDIARIO COMPRAS',NULL,1,'2024-09-18 12:25:18','2024-09-18 12:25:18',NULL),(1123,7941,40875,212194,3,1123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',442033.00,'SUBDIARIO COMPRAS',NULL,1,'2024-09-18 12:27:17','2024-09-18 12:27:17',NULL),(1124,7941,40875,212195,5,1124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6062868.44,'BANCO SANTANDER',NULL,1,'2024-09-18 12:32:23','2024-09-18 12:35:11','2024-09-18 12:35:11'),(1125,7941,40875,212195,5,1125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6062868.44,'BANCO SANTANDER',NULL,1,'2024-09-18 12:35:11','2024-09-18 12:35:11',NULL),(1126,7941,40875,212194,16,1126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',702464.58,'DJ IIBB',NULL,1,'2024-09-18 12:47:29','2024-09-18 12:47:29',NULL),(1127,7941,40875,212195,16,1127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',514941.90,'DJ IIBB',NULL,1,'2024-09-18 12:50:00','2024-09-18 12:50:00',NULL),(1128,7941,40875,212196,16,1128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',485348.54,'DJ IIBB',NULL,1,'2024-09-18 12:54:28','2024-09-18 12:54:28',NULL),(1129,7941,40875,212195,1,1129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',5460419.78,'SUELDOS',NULL,1,'2024-09-18 15:33:59','2024-09-18 15:33:59',NULL),(1130,7941,40875,212196,1,1130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',5460527.78,'SUELDOS',NULL,1,'2024-09-18 15:35:49','2024-09-18 15:35:49',NULL),(1131,7941,40879,218279,12,1131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',859493095.00,'Asiento de inicio',NULL,1,'2024-09-19 11:07:53','2024-09-19 11:18:57','2024-09-19 11:18:57'),(1132,7941,40879,218279,12,1132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',859493095.00,'Asiento de inicio',NULL,1,'2024-09-19 11:18:57','2024-09-19 11:24:41','2024-09-19 11:24:41'),(1133,7941,40879,218279,12,1133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',859493095.00,'Asiento de inicio',NULL,1,'2024-09-19 11:24:41','2024-09-19 11:24:41',NULL),(1134,7941,40879,218284,3,1134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',43457476.53,'COMPRAS',NULL,1,'2024-09-19 11:57:46','2024-09-19 11:57:46',NULL),(1135,7941,40875,212192,2,1135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',3897056.60,'SUBDIARIO VENTAS',NULL,1,'2024-09-19 16:02:46','2024-09-19 16:10:17','2024-09-19 16:10:17'),(1136,7941,40875,212193,2,1136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',8864007.50,'SUBDIARIO VENTAS',NULL,1,'2024-09-19 16:06:15','2024-09-19 16:21:43','2024-09-19 16:21:43'),(1137,7941,40875,212192,2,1137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',3897056.60,'SUBDIARIO VENTAS',NULL,1,'2024-09-19 16:10:17','2024-09-19 16:10:17',NULL);
INSERT INTO `balance_libro` VALUES (1138,7941,40875,212193,2,1138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',8864007.50,'SUBDIARIO VENTAS',NULL,1,'2024-09-19 16:21:43','2024-09-19 16:21:43',NULL),(1139,7941,40875,212194,2,1139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',8702773.08,'SUBDIARIO VENTAS',NULL,1,'2024-09-19 16:43:59','2024-09-19 16:43:59',NULL),(1140,7941,40875,212196,5,1140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',18073615.84,'BANCO SANTANDER',NULL,1,'2024-09-19 17:00:12','2024-09-19 17:00:12',NULL),(1141,7941,40875,212196,3,1141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',2336663.63,'SUBDIARIO COMPRAS',NULL,1,'2024-09-19 17:03:47','2024-09-19 17:03:47',NULL),(1142,7941,40875,212196,2,1142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',13175668.44,'SUBDIARIO VENTAS',NULL,1,'2024-09-19 17:06:19','2024-09-19 17:06:19',NULL),(1143,7941,40875,212196,15,1143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',2222272.92,'DJ IVA',NULL,1,'2024-09-19 17:08:30','2024-09-19 17:08:30',NULL),(1144,7941,40879,218290,3,1144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',244677118.82,'COMPRAS',NULL,1,'2024-10-01 09:41:32','2024-10-02 22:22:38','2024-10-02 22:22:38'),(1145,7941,40879,218290,3,1145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',244677118.82,'COMPRAS',NULL,1,'2024-10-02 22:22:38','2024-10-04 13:18:55','2024-10-04 13:18:55'),(1146,7941,40879,218279,3,1146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',31076582.88,'COMPRAS',NULL,1,'2024-10-04 13:09:10','2024-10-04 13:09:10',NULL),(1147,7941,40879,218280,3,1147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',12130839.50,'COMPRAS',NULL,1,'2024-10-04 13:11:20','2024-10-04 13:11:20',NULL),(1148,7941,40879,218281,3,1148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',58489781.29,'COMPRAS',NULL,1,'2024-10-04 13:12:07','2024-10-04 13:12:07',NULL),(1149,7941,40879,218282,3,1149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',54723572.99,'COMPRAS',NULL,1,'2024-10-04 13:14:03','2024-10-04 13:14:03',NULL),(1150,7941,40879,218283,3,1150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',72897388.56,'COMPRAS',NULL,1,'2024-10-04 13:17:00','2024-10-04 13:17:00',NULL),(1151,7941,40879,218290,3,1151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',244677118.82,'COMPRAS',NULL,1,'2024-10-04 13:18:55','2024-10-04 13:18:55',NULL),(1152,7941,40875,212197,1,1152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',5460649.78,'SUELDOS',NULL,1,'2024-10-21 16:12:21','2024-10-21 16:12:21',NULL),(1153,7941,40875,212197,5,1153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',13363278.41,'BANCO SANTANDER',NULL,1,'2024-10-21 16:27:54','2024-10-21 16:27:54',NULL),(1154,7941,40875,212197,3,1154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',4953826.36,'SUBDIARIO COMPRAS',NULL,1,'2024-10-21 16:35:05','2024-10-21 16:35:05',NULL),(1155,7941,40875,212197,2,1155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',13639237.66,'SUBDIARIO VENTAS',NULL,1,'2024-10-21 16:43:00','2024-10-21 16:43:00',NULL),(1156,7941,40875,212197,15,1156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',2310441.21,'DJ IVA',NULL,1,'2024-10-21 16:45:19','2024-10-21 16:45:19',NULL);
INSERT INTO `balance_libro` VALUES (1157,7941,40875,212197,16,1157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',452711.00,'DJ IIBB',NULL,1,'2024-10-21 16:48:43','2024-10-21 16:49:23','2024-10-21 16:49:23'),(1158,7941,40875,212197,16,1158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',452711.00,'DJ IIBB',NULL,1,'2024-10-21 16:49:23','2024-10-21 16:49:23',NULL),(1159,7941,40881,221308,12,1159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',224785733.00,'Asiento de inicio',NULL,1,'2024-10-28 11:13:40','2024-11-19 10:52:46','2024-11-19 10:52:46'),(1160,7941,40881,221308,2,1160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3547258.13,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 11:51:29','2024-10-28 11:51:29',NULL),(1161,7941,40881,221309,2,1161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4700850.00,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 11:55:04','2024-10-28 11:55:04',NULL),(1162,7941,40881,221310,2,1162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',6008860.00,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 11:56:42','2024-10-28 11:56:42',NULL),(1163,7941,40881,221311,2,1163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2462350.00,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 11:59:20','2024-10-28 11:59:20',NULL),(1164,7941,40881,221312,2,1164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',8546490.38,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 12:01:37','2024-10-28 12:01:37',NULL),(1165,7941,40881,221315,2,1165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',10870483.91,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 12:02:53','2024-10-28 12:02:53',NULL),(1166,7941,40881,221316,2,1166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',6909100.00,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 12:04:37','2024-10-28 12:04:37',NULL),(1167,7941,40881,221317,2,1167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',7139000.00,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 12:06:32','2024-10-28 12:06:32',NULL),(1168,7941,40881,221318,2,1168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',7548094.95,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 12:07:38','2024-11-22 12:58:10','2024-11-22 12:58:10'),(1169,7941,40881,221319,2,1169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',13552000.00,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 12:09:10','2024-10-28 12:09:10',NULL),(1170,7941,40881,221320,2,1170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',6388800.00,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 12:17:00','2024-10-28 12:17:00',NULL),(1171,7941,40881,221321,2,1171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',7893808.89,'SUBDIARIO VENTAS',NULL,1,'2024-10-28 12:19:22','2024-10-28 12:19:22',NULL),(1172,7941,40881,221308,15,1172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',620914.53,'DJ IVA',NULL,1,'2024-11-04 15:14:02','2024-11-04 15:14:02',NULL),(1173,7941,40881,221309,15,1173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',818321.67,'DJ IVA',NULL,1,'2024-11-04 15:18:06','2024-11-04 15:18:06',NULL),(1174,7941,40881,221310,15,1174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1046038.88,'DJ IVA',NULL,1,'2024-11-04 15:21:30','2024-11-04 15:21:30',NULL);
INSERT INTO `balance_libro` VALUES (1175,7941,40881,221311,15,1175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',431081.02,'DJ IVA',NULL,1,'2024-11-04 15:25:19','2024-11-04 15:25:19',NULL),(1176,7941,40881,221312,15,1176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1487905.72,'DJ IVA',NULL,1,'2024-11-04 15:28:16','2024-11-04 15:28:16',NULL),(1177,7941,40881,221315,15,1177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1891900.19,'DJ IVA',NULL,1,'2024-11-04 15:36:08','2024-11-04 15:36:08',NULL),(1178,7941,40881,221316,15,1178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1216284.52,'DJ IVA',NULL,1,'2024-11-04 15:42:26','2024-11-04 15:42:26',NULL),(1179,7941,40881,221317,15,1179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1321304.42,'DJ IVA',NULL,1,'2024-11-04 15:48:40','2024-11-04 15:48:40',NULL),(1180,7941,40881,221318,15,1180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',704383.37,'DJ IVA',NULL,1,'2024-11-04 15:55:14','2024-11-04 15:55:14',NULL),(1181,7941,40881,221319,15,1181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2353911.34,'DJ IVA',NULL,1,'2024-11-04 15:57:03','2024-11-04 15:57:03',NULL),(1182,7941,40881,221320,15,1182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1122714.08,'DJ IVA',NULL,1,'2024-11-04 15:59:36','2024-11-04 15:59:36',NULL),(1183,7941,40881,221321,15,1183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1377162.68,'DJ IVA',NULL,1,'2024-11-04 16:02:29','2024-11-04 16:02:29',NULL),(1184,7941,40881,221308,16,1184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',92918.08,'DJ IIBB',NULL,1,'2024-11-04 16:07:18','2024-11-04 16:31:01','2024-11-04 16:31:01'),(1185,7941,40881,221309,16,1185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',78164.50,'DJ IIBB',NULL,1,'2024-11-04 16:09:34','2024-11-04 16:31:38','2024-11-04 16:31:38'),(1186,7941,40881,221310,16,1186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',99320.00,'DJ IIBB',NULL,1,'2024-11-04 16:11:46','2024-11-04 16:11:46',NULL),(1187,7941,40881,221311,16,1187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',40700.00,'DJ IIBB',NULL,1,'2024-11-04 16:13:24','2024-11-04 16:13:24',NULL),(1188,7941,40881,221312,16,1188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',201524.50,'DJ IIBB',NULL,1,'2024-11-04 16:15:49','2024-11-04 16:15:49',NULL),(1189,7941,40881,221315,16,1189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',179677.42,'DJ IIBB',NULL,1,'2024-11-04 16:18:34','2024-11-04 16:32:57','2024-11-04 16:32:57'),(1190,7941,40881,221316,16,1190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',286000.00,'DJ IIBB',NULL,1,'2024-11-04 16:20:37','2024-11-04 16:33:27','2024-11-04 16:33:27'),(1191,7941,40881,221317,16,1191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',171890.00,'DJ IIBB',NULL,1,'2024-11-04 16:22:24','2024-11-04 16:22:24',NULL),(1192,7941,40881,221318,16,1192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',66761.90,'DJ IIBB',NULL,1,'2024-11-04 16:24:47','2024-11-04 16:24:47',NULL),(1193,7941,40881,221319,16,1193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',224000.00,'DJ IIBB',NULL,1,'2024-11-04 16:26:13','2024-11-04 16:34:37','2024-11-04 16:34:37');
INSERT INTO `balance_libro` VALUES (1194,7941,40881,221320,16,1194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',422000.00,'DJ IIBB',NULL,1,'2024-11-04 16:27:38','2024-11-04 16:35:02','2024-11-04 16:35:02'),(1195,7941,40881,221321,16,1195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',563400.00,'DJ IIBB',NULL,1,'2024-11-04 16:29:23','2024-11-04 16:35:31','2024-11-04 16:35:31'),(1196,7941,40881,221308,16,1196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',92918.08,'DJ IIBB',NULL,1,'2024-11-04 16:31:01','2024-11-04 16:31:01',NULL),(1197,7941,40881,221309,16,1197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',78164.50,'DJ IIBB',NULL,1,'2024-11-04 16:31:38','2024-11-04 16:31:38',NULL),(1198,7941,40881,221315,16,1198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',179677.42,'DJ IIBB',NULL,1,'2024-11-04 16:32:57','2024-11-04 16:32:57',NULL),(1199,7941,40881,221316,16,1199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',286000.00,'DJ IIBB',NULL,1,'2024-11-04 16:33:27','2024-11-04 16:33:27',NULL),(1200,7941,40881,221319,16,1200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',224000.00,'DJ IIBB',NULL,1,'2024-11-04 16:34:37','2024-11-04 16:34:37',NULL),(1201,7941,40881,221320,16,1201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',422000.00,'DJ IIBB',NULL,1,'2024-11-04 16:35:02','2024-11-04 16:35:02',NULL),(1202,7941,40881,221321,16,1202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',563400.00,'DJ IIBB',NULL,1,'2024-11-04 16:35:31','2024-11-04 16:35:31',NULL),(1203,7941,40882,222830,2,1203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',306482.11,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 16:45:37','2024-11-06 16:45:37',NULL),(1204,7941,40882,222831,2,1204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',345405.39,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 16:47:17','2024-11-06 16:47:17',NULL),(1205,7941,40882,222832,2,1205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',374073.92,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 16:48:25','2024-11-06 16:48:25',NULL),(1206,7941,40882,222830,15,1206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',245453.47,'DJ IVA',NULL,1,'2024-11-06 16:51:13','2024-11-06 16:51:13',NULL),(1207,7941,40882,222831,15,1207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',271456.36,'DJ IVA',NULL,1,'2024-11-06 16:53:55','2024-11-06 16:53:55',NULL),(1208,7941,40882,222832,15,1208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',227703.97,'DJ IVA',NULL,1,'2024-11-06 16:56:53','2024-11-06 16:56:53',NULL),(1209,7941,40882,222833,2,1209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',421992.34,'DJ IVA',NULL,1,'2024-11-06 17:00:31','2024-11-06 17:04:42','2024-11-06 17:04:42'),(1210,7941,40882,222834,2,1210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',529600.06,'DJ IVA',NULL,1,'2024-11-06 17:01:59','2024-11-06 17:04:59','2024-11-06 17:04:59'),(1211,7941,40882,222835,2,1211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',638773.52,'DJ IVA',NULL,1,'2024-11-06 17:03:06','2024-11-06 17:05:16','2024-11-06 17:05:16'),(1212,7941,40882,222836,2,1212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',723091.62,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:04:17','2024-11-06 17:04:17',NULL);
INSERT INTO `balance_libro` VALUES (1213,7941,40882,222833,2,1213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',421992.34,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:04:42','2024-11-06 17:04:42',NULL),(1214,7941,40882,222834,2,1214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',529600.06,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:04:59','2024-11-06 17:04:59',NULL),(1215,7941,40882,222835,2,1215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',638773.52,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:05:16','2024-11-06 17:05:16',NULL),(1216,7941,40882,222837,2,1216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',5642631.72,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:07:05','2024-11-06 17:07:05',NULL),(1217,7941,40882,222838,2,1217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1476200.00,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:08:19','2024-11-06 17:08:19',NULL),(1218,7941,40882,222839,2,1218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1516372.00,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:09:33','2024-11-06 17:09:33',NULL),(1219,7941,40882,222840,2,1219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1583457.05,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:10:46','2024-11-06 17:10:46',NULL),(1220,7941,40882,222841,2,1220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1647719.80,'SUBDIARIO VENTAS',NULL,1,'2024-11-06 17:12:05','2024-11-06 17:12:05',NULL),(1221,7941,40882,222833,15,1221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',284889.55,'DJ IVA',NULL,1,'2024-11-06 17:16:35','2024-11-06 17:16:35',NULL),(1222,7941,40882,222834,15,1222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',244222.22,'DJ IVA',NULL,1,'2024-11-06 17:19:14','2024-11-06 17:19:14',NULL),(1223,7941,40882,222835,15,1223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',152488.16,'DJ IVA',NULL,1,'2024-11-06 17:21:47','2024-11-06 17:21:47',NULL),(1224,7941,40882,222836,15,1224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',126896.66,'DJ IVA',NULL,1,'2024-11-06 17:24:37','2024-11-06 17:24:37',NULL),(1225,7941,40882,222837,15,1225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',988671.42,'DJ IVA',NULL,1,'2024-11-06 17:27:10','2024-11-06 17:27:10',NULL),(1226,7941,40882,222838,15,1226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',262073.62,'DJ IVA',NULL,1,'2024-11-06 17:29:36','2024-11-06 17:29:36',NULL),(1227,7941,40882,222839,15,1227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',266251.57,'DJ IVA',NULL,1,'2024-11-06 17:32:11','2024-11-06 17:32:11',NULL),(1228,7941,40882,222840,15,1228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',274814.86,'DJ IVA',NULL,1,'2024-11-06 17:34:57','2024-11-06 17:34:57',NULL),(1229,7941,40882,222841,15,1229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',285967.90,'DJ IVA',NULL,1,'2024-11-06 17:36:37','2024-11-06 17:36:37',NULL),(1230,7941,40882,222830,16,1230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',7598.73,'DJ IIBB',NULL,1,'2024-11-07 15:27:54','2024-11-07 15:27:54',NULL),(1231,7941,40882,222831,16,1231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',8563.77,'DJ IIBB',NULL,1,'2024-11-07 15:29:16','2024-11-07 15:29:16',NULL);
INSERT INTO `balance_libro` VALUES (1232,7941,40882,222832,16,1232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',9274.56,'DJ IIBB',NULL,1,'2024-11-07 15:30:50','2024-11-07 15:30:50',NULL),(1233,7941,40882,222833,16,1233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',10462.62,'DJ IIBB',NULL,1,'2024-11-07 15:33:20','2024-11-07 15:33:20',NULL),(1234,7941,40882,222834,16,1234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',13130.58,'DJ IIBB',NULL,1,'2024-11-07 15:34:34','2024-11-07 15:34:34',NULL),(1235,7941,40882,222835,16,1235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',15837.36,'DJ IIBB',NULL,1,'2024-11-07 15:36:23','2024-11-07 15:36:23',NULL),(1236,7941,40882,222836,16,1236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',17927.89,'DJ IIBB',NULL,1,'2024-11-07 15:38:09','2024-11-07 15:38:09',NULL),(1237,7941,40882,222837,16,1237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',139899.96,'DJ IIBB',NULL,1,'2024-11-07 15:39:24','2024-11-07 15:39:24',NULL),(1238,7941,40882,222838,16,1238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',44110.55,'DJ IIBB',NULL,1,'2024-11-07 15:40:39','2024-11-07 15:40:39',NULL),(1239,7941,40882,222839,16,1239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',37596.00,'DJ IIBB',NULL,1,'2024-11-07 15:42:32','2024-11-07 15:42:32',NULL),(1240,7941,40882,222840,16,1240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',39259.27,'DJ IIBB',NULL,1,'2024-11-07 15:44:50','2024-11-07 15:44:50',NULL),(1241,7941,40882,222841,16,1241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',40852.56,'DJ IIBB',NULL,1,'2024-11-07 15:46:21','2024-11-07 15:46:21',NULL),(1242,7941,40881,221308,3,1242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',5002901.84,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 10:59:05','2024-11-08 10:59:05',NULL),(1243,7941,40881,221309,3,1243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5717835.77,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:00:34','2024-11-08 11:00:34',NULL),(1244,7941,40881,221310,3,1244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',7277975.92,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:01:54','2024-12-06 13:40:10','2024-12-06 13:40:10'),(1245,7941,40881,221311,3,1245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3986431.21,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:03:02','2024-11-08 11:03:02',NULL),(1246,7941,40881,221312,3,1246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',9717155.73,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:04:14','2024-11-08 11:04:14',NULL),(1247,7941,40881,221315,3,1247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',13268585.03,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:05:22','2024-11-08 11:05:22',NULL),(1248,7941,40881,221316,3,1248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',9806064.30,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:06:31','2024-11-08 11:06:31',NULL),(1249,7941,40881,221317,3,1249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',10178177.55,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:15:05','2024-11-08 11:15:05',NULL),(1250,7941,40881,221318,3,1250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',7592804.00,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:16:14','2024-11-08 11:16:14',NULL);
INSERT INTO `balance_libro` VALUES (1251,7941,40881,221319,3,1251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',27623212.28,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:17:31','2024-11-08 11:17:31',NULL),(1252,7941,40881,221320,3,1252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',6965780.64,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:18:40','2024-11-08 11:18:40',NULL),(1253,7941,40881,221321,3,1253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',10863730.60,'SUBDIARIO COMPRAS',NULL,1,'2024-11-08 11:20:03','2024-11-08 11:20:03',NULL),(1254,7941,40881,221308,5,1254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4619471.71,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:17:43','2024-11-11 11:17:43',NULL),(1255,7941,40881,221309,5,1255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',3935157.12,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:23:56','2024-11-11 11:23:56',NULL),(1256,7941,40881,221310,5,1256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',8100000.00,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:28:40','2024-11-11 11:28:40',NULL),(1257,7941,40881,221311,5,1257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',4194325.36,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:34:18','2024-11-11 11:34:18',NULL),(1258,7941,40881,221312,5,1258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',10098929.81,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:37:49','2024-11-11 11:37:49',NULL),(1259,7941,40881,221315,5,1259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',6600000.00,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:47:36','2024-11-11 11:47:36',NULL),(1260,7941,40881,221316,5,1260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',14300000.00,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:51:45','2024-11-11 11:51:45',NULL),(1261,7941,40881,221317,5,1261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',12900371.05,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:55:25','2024-11-11 11:55:25',NULL),(1262,7941,40881,221318,5,1262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',8000000.00,'BANCO CREDICOOP',NULL,1,'2024-11-11 11:58:47','2024-11-11 11:58:47',NULL),(1263,7941,40881,221319,5,1263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',14425229.66,'BANCO CREDICOOP',NULL,1,'2024-11-11 12:02:10','2024-11-11 12:02:10',NULL),(1264,7941,40881,221320,5,1264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',21100000.00,'BANCO CREDICOOP',NULL,1,'2024-11-11 12:06:16','2024-11-11 12:06:16',NULL),(1265,7941,40881,221321,5,1265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',12954490.88,'BANCO CREDICOOP',NULL,1,'2024-11-11 12:09:29','2024-11-11 12:09:29',NULL),(1266,7941,40882,222830,5,1266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',310945.14,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:15:27','2024-11-14 16:15:27',NULL),(1267,7941,40882,222831,5,1267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',271860.05,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:19:49','2024-11-14 16:19:49',NULL),(1268,7941,40882,222832,5,1268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',693766.90,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:23:31','2024-11-14 16:23:31',NULL);
INSERT INTO `balance_libro` VALUES (1269,7941,40882,222833,5,1269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',401739.10,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:27:04','2024-11-14 16:27:04',NULL),(1270,7941,40882,222834,5,1270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',633475.85,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:31:53','2024-11-14 16:31:53',NULL),(1271,7941,40882,222835,5,1271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',655317.12,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:36:47','2024-11-14 16:36:47',NULL),(1272,7941,40882,222836,5,1272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',892907.84,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:41:40','2024-11-14 16:41:40',NULL),(1273,7941,40882,222837,5,1273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',650940.70,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:45:33','2024-11-14 16:45:33',NULL),(1274,7941,40882,222838,5,1274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',4901172.00,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:50:28','2024-11-14 16:50:28',NULL),(1275,7941,40882,222839,5,1275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1019227.00,'BANCO CREDICOOP',NULL,1,'2024-11-14 16:55:08','2024-11-14 16:55:08',NULL),(1276,7941,40882,222840,5,1276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',12993911.22,'BANCO CREDICOOP',NULL,1,'2024-11-14 17:01:39','2024-11-14 17:01:39',NULL),(1277,7941,40882,222841,5,1277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1378971.84,'BANCO CREDICOOP',NULL,1,'2024-11-14 17:06:35','2024-11-14 17:06:35',NULL),(1278,7941,40882,222830,3,1278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',443828.00,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 16:56:35','2024-11-15 16:56:35',NULL),(1279,7941,40882,222831,3,1279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',450362.00,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 16:57:47','2024-11-15 16:57:47',NULL),(1280,7941,40882,222832,3,1280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',87362.00,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 16:58:59','2024-11-15 16:58:59',NULL),(1281,7941,40882,222833,3,1281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',697625.50,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:00:12','2024-11-15 17:00:12',NULL),(1282,7941,40882,222834,3,1282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',131587.50,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:01:25','2024-11-15 17:01:25',NULL),(1283,7941,40882,222835,3,1283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',85000.00,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:02:09','2024-11-15 17:02:09',NULL),(1284,7941,40882,222836,3,1284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',489762.02,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:03:20','2024-11-15 17:03:20',NULL),(1285,7941,40882,222837,3,1285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',5687000.00,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:04:27','2024-11-15 17:04:27',NULL),(1286,7941,40882,222838,3,1286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',4512336.42,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:06:27','2024-11-15 17:06:27',NULL);
INSERT INTO `balance_libro` VALUES (1287,7941,40882,222839,3,1287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1608094.95,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:07:29','2024-11-15 17:07:29',NULL),(1288,7941,40882,222840,3,1288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',974286.06,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:08:30','2024-11-15 17:08:30',NULL),(1289,7941,40882,222841,3,1289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',987000.00,'SUBDIARIO COMPRAS',NULL,1,'2024-11-15 17:09:36','2024-11-15 17:09:36',NULL),(1290,7941,40882,222841,12,1290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',155853671.00,'Asiento de inicio',NULL,1,'2024-11-19 09:53:59','2024-11-19 10:22:00','2024-11-19 10:22:00'),(1291,7941,40882,222841,12,1291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',155853671.00,'Asiento de inicio',NULL,1,'2024-11-19 10:22:00','2025-01-02 10:19:21','2025-01-02 10:19:21'),(1292,7941,40881,221308,12,1292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',224785733.00,'Asiento de inicio',NULL,1,'2024-11-19 10:52:46','2024-11-19 10:52:46',NULL),(1293,7941,40881,221318,2,1293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4039094.95,'SUBDIARIO VENTAS',NULL,1,'2024-11-22 12:58:10','2024-11-22 12:58:10',NULL),(1294,7941,40875,212198,1,1294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',5460723.78,'SUELDOS',NULL,1,'2024-11-25 17:07:46','2025-01-16 11:17:44','2025-01-16 11:17:44'),(1295,7941,40875,212198,1,1295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',5460723.78,'SUELDOS',NULL,1,'2024-11-26 10:55:21','2024-11-26 10:55:33','2024-11-26 10:55:33'),(1296,7941,40875,212198,2,1296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',7683500.00,'SUBDIARIO VENTAS',NULL,1,'2024-11-26 10:57:31','2024-11-26 11:05:14','2024-11-26 11:05:14'),(1297,7941,40875,212198,15,1297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1333500.00,'DJ IVA',NULL,1,'2024-11-26 10:59:02','2024-11-26 10:59:02',NULL),(1298,7941,40875,212198,16,1298,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',231652.28,'DJ IIBB',NULL,1,'2024-11-26 11:03:52','2024-11-26 11:03:52',NULL),(1299,7941,40875,212198,2,1299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',7728157.60,'SUBDIARIO VENTAS',NULL,1,'2024-11-26 11:05:14','2024-11-26 11:05:14',NULL),(1300,7941,40875,212198,3,1300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1573788.46,'SUBDIARIO COMPRAS',NULL,1,'2024-11-26 11:08:45','2024-11-26 11:08:45',NULL),(1301,7941,40875,212198,5,1301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',11735918.30,'BANCO SANTANDER',NULL,1,'2024-11-26 11:16:46','2024-11-26 11:16:46',NULL),(1302,7941,40911,266840,15,1302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',106260.00,'DJ IVA',NULL,1,'2024-12-05 16:19:10','2024-12-05 16:19:10',NULL),(1303,7941,40911,266841,15,1303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',106260.00,'DJ IVA',NULL,1,'2024-12-05 16:21:12','2024-12-05 16:21:12',NULL),(1304,7941,40911,266843,15,1304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',214672.50,'DJ IVA',NULL,1,'2024-12-05 16:22:50','2024-12-05 16:22:50',NULL);
INSERT INTO `balance_libro` VALUES (1305,7941,40911,266844,15,1305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',246172.50,'DJ IVA',NULL,1,'2024-12-05 16:26:01','2024-12-05 16:26:01',NULL),(1306,7941,40911,266846,15,1306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',270.00,'DJ IVA',NULL,1,'2024-12-05 16:27:13','2024-12-05 16:27:13',NULL),(1307,7941,40911,266847,15,1307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',540.00,'DJ IVA',NULL,1,'2024-12-05 16:28:33','2024-12-05 16:28:33',NULL),(1308,7941,40911,266848,15,1308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',918.00,'DJ IVA',NULL,1,'2024-12-05 16:29:48','2024-12-05 16:29:48',NULL),(1309,7941,40911,266849,15,1309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1296.00,'DJ IVA',NULL,1,'2024-12-05 16:31:16','2024-12-05 16:31:16',NULL),(1310,7941,40911,266850,15,1310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1674.00,'DJ IVA',NULL,1,'2024-12-05 16:32:50','2024-12-05 16:32:50',NULL),(1311,7941,40911,266851,15,1311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',2184.00,'DJ IVA',NULL,1,'2024-12-05 16:34:27','2024-12-05 16:34:27',NULL),(1312,7941,40911,266852,15,1312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2694.00,'DJ IVA',NULL,1,'2024-12-05 16:35:36','2024-12-05 16:35:36',NULL),(1313,7941,40911,266840,16,1313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',180.00,'DJ IIBB',NULL,1,'2024-12-05 16:42:15','2024-12-05 16:42:15',NULL),(1314,7941,40911,266841,16,1314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',180.00,'DJ IIBB',NULL,1,'2024-12-05 16:43:02','2024-12-05 16:43:02',NULL),(1315,7941,40911,266843,16,1315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',180.00,'DJ IIBB',NULL,1,'2024-12-05 16:44:36','2024-12-05 16:44:36',NULL),(1316,7941,40911,266844,16,1316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',540.00,'DJ IIBB',NULL,1,'2024-12-05 16:47:39','2024-12-05 16:47:39',NULL),(1317,7941,40911,266845,16,1317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',900.00,'DJ IIBB',NULL,1,'2024-12-05 16:49:54','2024-12-05 16:49:54',NULL),(1318,7941,40911,266846,16,1318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1440.00,'DJ IIBB',NULL,1,'2024-12-05 16:51:08','2024-12-05 16:51:08',NULL),(1319,7941,40911,266847,16,1319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',65980.00,'DJ IIBB',NULL,1,'2024-12-05 16:53:09','2024-12-05 16:53:09',NULL),(1320,7941,40911,266848,16,1320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',128336.00,'DJ IIBB',NULL,1,'2024-12-05 16:54:51','2024-12-05 16:54:51',NULL),(1321,7941,40911,266849,16,1321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',188336.00,'DJ IIBB',NULL,1,'2024-12-05 16:56:11','2024-12-05 16:56:11',NULL),(1322,7941,40911,266850,16,1322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',248292.00,'DJ IIBB',NULL,1,'2024-12-05 16:57:56','2024-12-05 16:57:56',NULL),(1323,7941,40911,266851,16,1323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',311712.00,'DJ IIBB',NULL,1,'2024-12-05 16:59:58','2024-12-05 16:59:58',NULL);
INSERT INTO `balance_libro` VALUES (1324,7941,40911,266852,16,1324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',378732.00,'DJ IIBB',NULL,1,'2024-12-05 17:01:37','2024-12-05 17:01:37',NULL),(1325,7941,40881,221310,3,1325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',7277975.92,'SUBDIARIO COMPRAS',NULL,1,'2024-12-06 13:40:10','2024-12-06 13:40:10',NULL),(1326,7941,40911,266840,5,1326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',27683080.87,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:09:10','2024-12-23 17:09:10',NULL),(1327,7941,40911,266841,5,1327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1450000.00,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:10:41','2024-12-23 17:10:41',NULL),(1328,7941,40911,266843,5,1328,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',439778.82,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:13:23','2024-12-23 17:13:23',NULL),(1329,7941,40911,266844,5,1329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',447565.62,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:17:34','2024-12-23 17:17:34',NULL),(1330,7941,40911,266845,5,1330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1400000.00,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:19:52','2024-12-23 17:19:52',NULL),(1331,7941,40911,266846,5,1331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1209873.17,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:25:52','2024-12-23 17:25:52',NULL),(1332,7941,40911,266847,5,1332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1600000.00,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:30:18','2024-12-23 17:30:18',NULL),(1333,7941,40911,266848,5,1333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1540000.00,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:37:02','2024-12-23 17:37:02',NULL),(1334,7941,40911,266849,5,1334,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1587134.03,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:42:03','2024-12-23 17:42:03',NULL),(1335,7941,40911,266850,5,1335,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1480000.00,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:45:54','2024-12-23 17:45:54',NULL),(1336,7941,40911,266851,5,1336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1590093.70,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:50:39','2024-12-23 17:50:39',NULL),(1337,7941,40911,266852,5,1337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1650000.00,'BANCO CREDICOOP',NULL,1,'2024-12-23 17:54:22','2024-12-23 17:54:22',NULL),(1338,7941,40882,222830,12,1338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',155853671.00,'Asiento de inicio',NULL,1,'2025-01-02 10:19:21','2025-01-07 14:51:29','2025-01-07 14:51:29'),(1339,7941,40882,222830,12,1339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',155853671.00,'Asiento de inicio',NULL,1,'2025-01-07 14:51:29','2025-01-07 14:51:29',NULL),(1346,7941,40911,266840,12,1346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',1.00,'Asiento de inicio',NULL,1,'2025-01-09 12:26:08','2025-01-09 12:26:35','2025-01-09 12:26:35'),(1347,7941,40911,266840,12,1347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',1000.00,'asiento',NULL,1,'2025-01-09 12:28:33','2025-01-09 12:28:59','2025-01-09 12:28:59');
INSERT INTO `balance_libro` VALUES (1349,7941,40911,266840,12,1349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',26578178.00,'saldos iniciales',NULL,1,'2025-01-09 12:41:48','2025-01-22 15:22:29','2025-01-22 15:22:29'),(1350,7941,40911,266843,3,1350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',624662.50,'COMPRAS',NULL,1,'2025-01-15 17:19:39','2025-01-15 17:48:12','2025-01-15 17:48:12'),(1351,7941,40911,266844,3,1351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1418422.50,'SUBDIARIO COMPRAS',NULL,1,'2025-01-15 17:32:12','2025-01-15 17:32:12',NULL),(1352,7941,40911,266845,3,1352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',35000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-01-15 17:34:57','2025-01-15 17:34:57',NULL),(1353,7941,40911,266847,3,1353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',35000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-01-15 17:41:12','2025-01-15 17:41:12',NULL),(1354,7941,40911,266843,3,1354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',624662.50,'SUBDIARIO COMPRAS',NULL,1,'2025-01-15 17:48:12','2025-01-15 17:48:12',NULL),(1355,7941,40875,212199,3,1355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3689973.87,'SUBDIARIO COMPRAS',NULL,1,'2025-01-16 10:19:05','2025-03-10 09:25:46','2025-03-10 09:25:46'),(1356,7941,40875,212199,2,1356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',13680406.41,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 10:26:39','2025-01-16 10:26:39',NULL),(1357,7941,40875,212199,1,1357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',5460809.78,'SUELDOS',NULL,1,'2025-01-16 11:17:44','2025-01-16 11:17:44',NULL),(1358,7941,40875,212199,5,1358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',16488900.05,'BANCO SANTANDER',NULL,1,'2025-01-16 12:24:52','2025-01-16 12:24:52',NULL),(1359,7941,40875,212199,15,1359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',2374285.41,'DJ IVA',NULL,1,'2025-01-16 12:59:23','2025-01-16 12:59:23',NULL),(1360,7941,40875,212199,16,1360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',406609.24,'DJ IIBB',NULL,1,'2025-01-16 14:17:29','2025-01-16 14:17:29',NULL),(1361,7941,40873,209144,2,1361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',120002.00,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 16:40:28','2025-01-16 16:40:28',NULL),(1362,7941,40873,209145,2,1362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',400000.00,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 16:42:35','2025-01-16 16:42:35',NULL),(1363,7941,40873,209146,2,1363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2226152.00,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 16:48:45','2025-01-16 16:48:45',NULL),(1364,7941,40873,209147,2,1364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',192000.00,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 16:51:04','2025-01-16 16:51:04',NULL),(1365,7941,40873,209148,2,1365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',9002732.75,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 16:53:01','2025-01-16 16:53:01',NULL),(1366,7941,40873,209149,2,1366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',11733757.20,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 16:54:43','2025-01-16 16:54:43',NULL);
INSERT INTO `balance_libro` VALUES (1367,7941,40873,209150,2,1367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',10638925.00,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 17:20:53','2025-01-16 17:20:53',NULL),(1368,7941,40873,209151,2,1368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',15572058.98,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 17:22:14','2025-01-16 17:22:14',NULL),(1369,7941,40873,209152,2,1369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',27255108.22,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 17:23:20','2025-01-16 17:23:20',NULL),(1370,7941,40873,209153,2,1370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',31735534.34,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 17:24:42','2025-01-16 17:24:42',NULL),(1371,7941,40873,209150,2,1371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',10638925.00,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 17:27:37','2025-01-17 08:27:58','2025-01-17 08:27:58'),(1372,7941,40873,209144,15,1372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',20826.79,'DJ IVA',NULL,1,'2025-01-16 17:28:05','2025-01-16 17:28:05',NULL),(1373,7941,40873,209145,15,1373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',69421.49,'DJ IVA',NULL,1,'2025-01-16 17:29:07','2025-01-16 17:29:07',NULL),(1374,7941,40873,209151,2,1374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',15572058.98,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 17:29:15','2025-01-17 08:32:27','2025-01-17 08:32:27'),(1375,7941,40873,209146,15,1375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',386356.96,'DJ IVA',NULL,1,'2025-01-16 17:30:13','2025-01-16 17:30:13',NULL),(1376,7941,40873,209152,2,1376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',27255108.22,'SUBDIARIO VENTAS',NULL,1,'2025-01-16 17:30:55','2025-01-17 08:32:27','2025-01-17 08:32:27'),(1377,7941,40873,209147,15,1377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',33322.31,'DJ IVA',NULL,1,'2025-01-16 17:31:02','2025-01-16 17:31:02',NULL),(1378,7941,40873,209148,15,1378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1562457.75,'DJ IVA',NULL,1,'2025-01-16 17:32:17','2025-01-16 17:32:17',NULL),(1379,7941,40873,209149,15,1379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3609776.57,'DJ IVA',NULL,1,'2025-01-16 17:34:24','2025-01-16 17:34:24',NULL),(1380,7941,40873,209150,15,1380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',2587968.81,'DJ IVA',NULL,1,'2025-01-16 17:39:21','2025-01-16 17:39:21',NULL),(1381,7941,40873,209151,15,1381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',2702588.75,'DJ IVA',NULL,1,'2025-01-16 17:41:26','2025-01-16 17:41:26',NULL),(1382,7941,40873,209152,15,1382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4730225.40,'DJ IVA',NULL,1,'2025-01-16 17:43:37','2025-01-16 17:43:37',NULL),(1383,7941,40873,209153,15,1383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',5507820.01,'DJ IVA',NULL,1,'2025-01-16 17:44:59','2025-01-16 17:44:59',NULL),(1384,7941,40873,209144,16,1384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',3272.79,'DJ IIBB',NULL,1,'2025-01-16 17:51:27','2025-01-16 17:51:27',NULL),(1385,7941,40873,209145,16,1385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',10909.10,'DJ IIBB',NULL,1,'2025-01-16 17:52:44','2025-01-16 17:52:44',NULL);
INSERT INTO `balance_libro` VALUES (1386,7941,40873,209146,16,1386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',46684.21,'DJ IIBB',NULL,1,'2025-01-16 17:53:33','2025-01-16 17:53:33',NULL),(1387,7941,40873,209147,16,1387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3966.94,'DJ IIBB',NULL,1,'2025-01-16 17:54:22','2025-01-16 17:54:22',NULL),(1388,7941,40873,209148,16,1388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',588727.62,'DJ IIBB',NULL,1,'2025-01-16 17:56:04','2025-01-16 17:56:04',NULL),(1389,7941,40873,209149,16,1389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1745272.04,'DJ IIBB',NULL,1,'2025-01-16 17:59:02','2025-01-16 17:59:02',NULL),(1390,7941,40873,209150,16,1390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',2038539.65,'DJ IIBB',NULL,1,'2025-01-16 18:01:44','2025-01-16 18:01:44',NULL),(1391,7941,40873,209151,16,1391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',2386068.20,'DJ IIBB',NULL,1,'2025-01-16 18:04:25','2025-01-16 18:04:25',NULL),(1392,7941,40873,209152,16,1392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2817482.57,'DJ IIBB',NULL,1,'2025-01-16 18:06:59','2025-01-16 18:06:59',NULL),(1393,7941,40873,209153,16,1393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2614430.32,'DJ IIBB',NULL,1,'2025-01-16 18:09:07','2025-01-16 18:09:07',NULL),(1394,7941,40873,209154,16,1394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2835678.16,'DJ IIBB',NULL,1,'2025-01-16 18:11:27','2025-01-16 18:11:27',NULL),(1395,7941,40873,209154,2,1395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',39482254.96,'SUBDIARIO VENTAS',NULL,1,'2025-01-17 08:40:11','2025-01-17 08:40:11',NULL),(1396,7941,40873,209149,1,1396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',7205419.61,'SUELDOS',NULL,1,'2025-01-17 09:10:31','2025-01-17 09:10:31',NULL),(1397,7941,40873,209150,1,1397,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',7107465.24,'SUELDOS',NULL,1,'2025-01-17 09:16:27','2025-01-17 09:16:27',NULL),(1398,7941,40873,209151,1,1398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6795487.00,'SUELDOS',NULL,1,'2025-01-17 09:51:59','2025-01-17 09:51:59',NULL),(1399,7941,40873,209152,1,1399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',6474707.28,'SUELDOS',NULL,1,'2025-01-17 10:07:08','2025-01-17 10:07:08',NULL),(1400,7941,40873,209153,1,1400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',6133190.94,'SUELDOS',NULL,1,'2025-01-17 10:10:42','2025-01-17 10:10:42',NULL),(1401,7941,40873,209154,1,1401,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',9396837.02,'SUELDOS',NULL,1,'2025-01-17 10:15:42','2025-01-17 10:15:42',NULL),(1402,7941,40877,215240,2,1402,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',96058401.07,'SUBDIARIO VENTAS',NULL,1,'2025-01-17 13:27:19','2025-01-17 13:27:19',NULL),(1403,7941,40877,215241,2,1403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',104889479.72,'SUBDIARIO VENTAS',NULL,1,'2025-01-17 13:49:20','2025-01-17 13:49:20',NULL),(1404,7941,40877,215242,2,1404,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',106821177.18,'SUBDIARIO VENTAS',NULL,1,'2025-01-17 13:54:31','2025-01-17 13:54:31',NULL);
INSERT INTO `balance_libro` VALUES (1405,7941,40877,215243,2,1405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',95525010.60,'SUBDIARIO VENTAS',NULL,1,'2025-01-17 13:56:10','2025-01-17 13:56:10',NULL),(1406,7941,40877,215244,2,1406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',72940533.98,'SUBDIARIO VENTAS',NULL,1,'2025-01-17 13:57:42','2025-01-17 13:57:42',NULL),(1407,7941,40877,215245,2,1407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',79705701.74,'SUBDIARIO VENTAS',NULL,1,'2025-01-17 13:59:16','2025-01-17 13:59:16',NULL),(1408,7941,40877,215240,15,1408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',16660495.54,'DJ IVA',NULL,1,'2025-01-17 14:07:44','2025-01-17 14:07:44',NULL),(1409,7941,40877,215241,15,1409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',18187356.26,'DJ IVA',NULL,1,'2025-01-17 14:10:40','2025-01-17 14:10:40',NULL),(1410,7941,40877,215242,15,1410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',18524577.26,'DJ IVA',NULL,1,'2025-01-17 14:14:41','2025-01-17 14:14:41',NULL),(1411,7941,40877,215243,15,1411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',16578720.85,'DJ IVA',NULL,1,'2025-01-17 14:18:43','2025-01-17 14:18:43',NULL),(1412,7941,40877,215245,15,1412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',12751913.05,'DJ IVA',NULL,1,'2025-01-17 14:23:09','2025-01-17 14:25:15','2025-01-17 14:25:15'),(1413,7941,40877,215244,15,1413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',12751913.05,'DJ IVA',NULL,1,'2025-01-17 14:25:15','2025-01-17 14:25:15',NULL),(1414,7941,40877,215245,15,1414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',13833220.96,'DJ IVA',NULL,1,'2025-01-17 14:31:28','2025-01-27 13:13:21','2025-01-27 13:13:21'),(1415,7941,40911,266840,3,1415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',249260.00,'SUBDIARIO COMPRAS',NULL,1,'2025-01-22 14:37:59','2025-01-22 14:37:59',NULL),(1416,7941,40911,266846,3,1416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',35000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-01-22 14:42:42','2025-01-22 14:42:42',NULL),(1417,7941,40911,266840,12,1417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',26578178.00,'saldos iniciales',NULL,1,'2025-01-22 15:22:29','2025-03-05 19:11:13','2025-03-05 19:11:13'),(1418,7941,40875,212192,5,1418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',7702273.22,'BANCO SANTANDER',NULL,1,'2025-01-23 11:44:07','2025-01-23 11:44:07',NULL),(1419,7941,40870,204565,16,1419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',16408729.70,'DJ IIBB',NULL,1,'2025-01-23 14:51:02','2025-01-23 14:51:02',NULL),(1420,7941,40870,204566,16,1420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',17470201.53,'DJ IIBB',NULL,1,'2025-01-23 14:53:35','2025-01-23 14:53:35',NULL),(1421,7941,40870,204567,16,1421,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',18397289.69,'DJ IIBB',NULL,1,'2025-01-23 14:55:09','2025-01-23 14:55:09',NULL),(1422,7941,40870,204568,16,1422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',20953875.44,'DJ IIBB',NULL,1,'2025-01-23 14:56:22','2025-01-23 14:56:22',NULL),(1423,7941,40870,204569,16,1423,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',24293946.73,'DJ IIBB',NULL,1,'2025-01-23 14:57:56','2025-01-23 14:57:56',NULL);
INSERT INTO `balance_libro` VALUES (1424,7941,40870,204570,16,1424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',24380994.73,'DJ IIBB',NULL,1,'2025-01-23 14:59:33','2025-01-23 14:59:33',NULL),(1425,7941,40870,204571,16,1425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',27408411.66,'DJ IIBB',NULL,1,'2025-01-23 15:00:48','2025-01-23 15:00:48',NULL),(1426,7941,40870,204572,16,1426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',33611396.22,'DJ IIBB',NULL,1,'2025-01-23 15:01:56','2025-01-23 15:01:56',NULL),(1427,7941,40870,204573,16,1427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',36021787.32,'DJ IIBB',NULL,1,'2025-01-23 15:03:08','2025-01-23 15:03:08',NULL),(1428,7941,40870,204574,16,1428,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',38758172.17,'DJ IIBB',NULL,1,'2025-01-23 15:15:17','2025-01-23 15:15:17',NULL),(1429,7941,40870,204575,16,1429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',41517081.77,'DJ IIBB',NULL,1,'2025-01-23 15:16:28','2025-01-23 15:16:28',NULL),(1430,7941,40870,204576,16,1430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',42234648.35,'DJ IIBB',NULL,1,'2025-01-23 15:17:31','2025-01-23 15:17:31',NULL),(1431,7941,40870,204565,3,1431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',58943569.96,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 12:01:58','2025-01-24 12:19:12','2025-01-24 12:19:12'),(1432,7941,40870,204565,3,1432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',58943569.96,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 12:19:12','2025-02-25 13:24:02','2025-02-25 13:24:02'),(1433,7941,40870,204566,3,1433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',92472636.86,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 12:21:58','2025-02-25 13:54:03','2025-02-25 13:54:03'),(1434,7941,40870,204560,5,1434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',70827781.60,'BANCO SANTANDER 9161-3',NULL,1,'2025-01-24 12:22:31','2025-01-24 12:22:31',NULL),(1435,7941,40870,204567,3,1435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',81412046.14,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 12:25:03','2025-01-24 12:25:03',NULL),(1436,7941,40870,204568,3,1436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',95297791.26,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 12:26:04','2025-01-24 12:26:04',NULL),(1437,7941,40870,204569,3,1437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',108598809.43,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 12:27:11','2025-01-24 12:27:11',NULL),(1438,7941,40870,204570,3,1438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',75014487.71,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 12:28:12','2025-01-24 12:28:12',NULL),(1439,7941,40870,204571,3,1439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',190082501.91,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 16:31:34','2025-01-24 16:31:34',NULL),(1440,7941,40870,204572,3,1440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',369220189.38,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 16:33:23','2025-01-24 16:33:23',NULL),(1441,7941,40870,204573,3,1441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',114734939.87,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 16:35:13','2025-01-24 16:35:13',NULL);
INSERT INTO `balance_libro` VALUES (1442,7941,40870,204574,3,1442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',117576226.46,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 16:36:36','2025-01-24 16:36:36',NULL),(1443,7941,40870,204575,3,1443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',81035454.06,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 16:37:55','2025-01-24 16:37:55',NULL),(1444,7941,40870,204576,3,1444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',421761427.00,'SUBDIARIO COMPRAS',NULL,1,'2025-01-24 16:45:58','2025-01-24 16:45:58',NULL),(1445,7941,40873,209148,5,1445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',7290756.00,'BANCO CREDICOOP',NULL,1,'2025-01-27 12:14:56','2025-01-27 12:14:56',NULL),(1446,7941,40873,209149,5,1446,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',10118561.25,'BANCO CREDICOOP',NULL,1,'2025-01-27 12:17:58','2025-01-27 12:17:58',NULL),(1447,7941,40873,209150,5,1447,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',10427331.02,'BANCO CREDICOOP',NULL,1,'2025-01-27 12:20:50','2025-01-27 12:20:50',NULL),(1448,11429,40873,209151,5,1448,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',15749852.50,'BANCO CREDICOOP',NULL,1,'2025-01-27 12:25:21','2025-04-30 16:48:42','2025-04-30 16:48:42'),(1449,7941,40873,209152,5,1449,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',12120909.58,'BANCO CREDICOOP',NULL,1,'2025-01-27 12:29:03','2025-01-27 12:29:03',NULL),(1450,7941,40873,209153,5,1450,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',18645978.00,'BANCO CREDICOOP',NULL,1,'2025-01-27 12:38:13','2025-01-27 12:38:13',NULL),(1451,7941,40873,209154,5,1451,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',26236108.80,'BANCO CREDICOOP',NULL,1,'2025-01-27 12:42:15','2025-01-27 12:42:15',NULL),(1452,7941,40877,215234,2,1452,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',89298319.63,'SUBDIARIO VENTAS',NULL,1,'2025-01-27 12:58:06','2025-01-27 12:58:06',NULL),(1453,7941,40877,215235,2,1453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',126276054.48,'SUBDIARIO VENTAS',NULL,1,'2025-01-27 12:59:41','2025-01-27 12:59:41',NULL),(1454,11429,40877,215236,2,1454,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',99720200.44,'SUBDIARIO VENTAS',NULL,1,'2025-01-27 13:01:01','2025-05-05 15:25:15','2025-05-05 15:25:15'),(1455,11429,40877,215237,2,1455,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',84850509.46,'SUBDIARIO VENTAS',NULL,1,'2025-01-27 13:02:10','2025-05-05 15:26:38','2025-05-05 15:26:38'),(1456,7941,40877,215238,2,1456,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',103613384.79,'SUBDIARIO VENTAS',NULL,1,'2025-01-27 13:03:20','2025-01-27 13:03:20',NULL),(1457,7941,40877,215239,2,1457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',55218567.30,'SUBDIARIO VENTAS',NULL,1,'2025-01-27 13:04:28','2025-01-27 13:04:28',NULL),(1458,11429,40877,215245,15,1458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',13833220.96,'DJ IVA',NULL,1,'2025-01-27 13:13:21','2025-05-06 16:28:57','2025-05-06 16:28:57'),(1459,11429,40877,215234,15,1459,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',16819398.91,'DJ IVA',NULL,1,'2025-01-27 13:18:43','2025-05-05 17:13:50','2025-05-05 17:13:50');
INSERT INTO `balance_libro` VALUES (1460,11429,40877,215235,15,1460,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',21915678.88,'DJ IVA',NULL,1,'2025-01-27 13:22:55','2025-05-07 13:34:42','2025-05-07 13:34:42'),(1461,11429,40877,215236,15,1461,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',20139352.60,'DJ IVA',NULL,1,'2025-01-27 13:26:44','2025-05-05 15:36:13','2025-05-05 15:36:13'),(1462,7941,40877,215237,15,1462,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',14716274.03,'DJ IVA',NULL,1,'2025-01-27 13:38:09','2025-01-27 13:38:09',NULL),(1463,11429,40877,215238,15,1463,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',18678421.42,'DJ IVA',NULL,1,'2025-01-27 13:40:43','2025-05-05 17:16:01','2025-05-05 17:16:01'),(1464,7941,40877,215239,15,1464,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',9560693.42,'DJ IVA',NULL,1,'2025-01-27 13:55:46','2025-01-27 13:55:46',NULL),(1465,7941,40877,215241,1,1465,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',11178983.74,'SUELDOS',NULL,1,'2025-01-28 11:12:17','2025-01-28 11:12:17',NULL),(1466,7941,40877,215242,1,1466,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',10863068.27,'SUELDOS',NULL,1,'2025-01-28 11:14:23','2025-01-28 11:14:23',NULL),(1467,7941,40877,215243,1,1467,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',12008121.88,'SUELDOS',NULL,1,'2025-01-28 11:17:34','2025-01-28 11:17:34',NULL),(1468,7941,40877,215244,1,1468,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',10778961.98,'SUELDOS',NULL,1,'2025-01-28 11:26:06','2025-01-28 11:26:06',NULL),(1469,7941,40877,215245,1,1469,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',17251312.68,'SUELDOS',NULL,1,'2025-01-28 11:31:47','2025-01-28 11:38:59','2025-01-28 11:38:59'),(1470,7941,40877,215245,1,1470,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',17251312.68,'SUELDOS',NULL,1,'2025-01-28 11:31:47','2025-01-28 11:32:37','2025-01-28 11:32:37'),(1471,7941,40877,215245,1,1471,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',17251312.68,'SUELDOS',NULL,1,'2025-01-28 11:41:41','2025-01-28 11:41:41',NULL),(1472,7941,40735,24267,2,1472,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3323996.46,'SUBDIARIO VENTAS',NULL,1,'2025-02-12 17:26:49','2025-02-14 10:52:01','2025-02-14 10:52:01'),(1473,7941,40735,24268,2,1473,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',9216263.33,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 09:18:11','2025-02-13 10:15:54','2025-02-13 10:15:54'),(1474,7941,40735,24269,2,1474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',9524660.81,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 09:25:50','2025-02-13 09:52:27','2025-02-13 09:52:27'),(1475,7941,40735,24270,2,1475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',18885927.30,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 09:29:55','2025-02-13 09:55:41','2025-02-13 09:55:41'),(1476,7941,40735,24271,2,1476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3025000.00,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 09:45:28','2025-02-13 10:22:20','2025-02-13 10:22:20'),(1477,7941,40735,24269,2,1477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',9524660.81,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 09:52:27','2025-02-13 10:18:29','2025-02-13 10:18:29');
INSERT INTO `balance_libro` VALUES (1478,7941,40735,24270,2,1478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',18885927.30,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 09:55:41','2025-02-13 10:20:24','2025-02-13 10:20:24'),(1479,7941,40735,24268,2,1479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',9216263.33,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 10:15:54','2025-02-14 10:54:41','2025-02-14 10:54:41'),(1480,7941,40735,24269,2,1480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',9524660.81,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 10:18:29','2025-02-14 10:55:34','2025-02-14 10:55:34'),(1481,7941,40735,24270,2,1481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',18885927.30,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 10:20:24','2025-02-14 10:56:19','2025-02-14 10:56:19'),(1482,7941,40735,24271,2,1482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3025000.00,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 10:22:20','2025-02-14 10:56:54','2025-02-14 10:56:54'),(1483,7941,40735,24272,2,1483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',5658952.20,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 10:27:08','2025-02-14 10:57:29','2025-02-14 10:57:29'),(1484,7941,40735,24273,2,1484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6470320.96,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 10:53:04','2025-02-14 11:00:41','2025-02-14 11:00:41'),(1485,7941,40735,24274,2,1485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3131991.64,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 11:05:50','2025-02-14 11:02:15','2025-02-14 11:02:15'),(1486,7941,40735,24275,2,1486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',7356760.20,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 11:14:31','2025-02-14 11:04:15','2025-02-14 11:04:15'),(1487,7941,40735,24276,2,1487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',7822761.98,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 11:31:26','2025-02-14 11:05:46','2025-02-14 11:05:46'),(1488,7941,40735,24277,2,1488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',8888387.75,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 11:36:20','2025-02-14 11:07:42','2025-02-14 11:07:42'),(1489,7941,40735,24278,2,1489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',30078917.40,'SUBDIARIO VENTAS',NULL,1,'2025-02-13 11:43:44','2025-02-14 11:09:19','2025-02-14 11:09:19'),(1490,7941,40735,24267,15,1490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1341254.40,'DJ IVA',NULL,1,'2025-02-13 12:21:18','2025-02-13 12:21:18',NULL),(1491,7941,40735,24268,15,1491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1809089.90,'DJ IVA',NULL,1,'2025-02-13 13:36:02','2025-02-13 13:36:02',NULL),(1492,7941,40735,24269,15,1492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',2466418.76,'DJ IVA',NULL,1,'2025-02-13 13:52:22','2025-02-13 15:14:44','2025-02-13 15:14:44'),(1493,7941,40735,24270,15,1493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2201667.30,'DJ IVA',NULL,1,'2025-02-13 14:45:47','2025-02-13 14:45:47',NULL),(1494,7941,40735,24271,15,1494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1565446.16,'DJ IVA',NULL,1,'2025-02-13 14:56:02','2025-02-13 14:56:02',NULL),(1495,7941,40735,24269,15,1495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',2461126.75,'DJ IVA',NULL,1,'2025-02-13 15:14:44','2025-02-13 15:14:44',NULL);
INSERT INTO `balance_libro` VALUES (1496,7941,40735,24272,15,1496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',1762237.95,'DJ IVA',NULL,1,'2025-02-13 16:44:58','2025-02-13 16:44:58',NULL),(1497,7941,40735,24273,15,1497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1154548.58,'DJ IVA',NULL,1,'2025-02-13 16:54:56','2025-02-13 16:54:56',NULL),(1498,7941,40735,24274,15,1498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',543568.93,'DJ IVA',NULL,1,'2025-02-13 17:06:34','2025-02-13 17:06:34',NULL),(1499,7941,40735,24275,15,1499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1276791.80,'DJ IVA',NULL,1,'2025-02-13 17:15:48','2025-02-13 17:15:48',NULL),(1500,7941,40735,24276,15,1500,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1357669.57,'DJ IVA',NULL,1,'2025-02-13 17:19:18','2025-02-13 17:19:18',NULL),(1501,7941,40735,24277,15,1501,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',1542612.75,'DJ IVA',NULL,1,'2025-02-14 09:40:42','2025-02-14 09:40:42',NULL),(1502,7941,40735,24278,15,1502,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5220307.64,'DJ IVA',NULL,1,'2025-02-14 09:43:47','2025-02-14 09:43:47',NULL),(1503,7941,40735,24267,2,1503,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3323996.97,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 10:52:01','2025-02-14 10:52:01',NULL),(1504,7941,40735,24268,2,1504,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',9216264.09,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 10:54:41','2025-02-14 10:54:41',NULL),(1505,7941,40735,24269,2,1505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',9524660.81,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 10:55:34','2025-02-14 10:55:34',NULL),(1506,7941,40735,24270,2,1506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',18885927.30,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 10:56:20','2025-02-14 10:56:20',NULL),(1507,7941,40735,24271,2,1507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3025000.00,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 10:56:54','2025-02-14 10:56:54',NULL),(1508,7941,40735,24272,2,1508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',5658952.20,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 10:57:29','2025-02-14 10:57:29',NULL),(1509,7941,40735,24273,2,1509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6470317.35,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 11:00:41','2025-02-14 11:00:41',NULL),(1510,7941,40735,24274,2,1510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3131992.41,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 11:02:15','2025-02-14 11:02:15',NULL),(1511,7941,40735,24275,2,1511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',7356752.77,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 11:04:15','2025-02-14 11:04:15',NULL),(1512,7941,40735,24276,2,1512,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',7822762.77,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 11:05:46','2025-02-14 11:05:46',NULL),(1513,7941,40735,24277,2,1513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',8888387.75,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 11:07:42','2025-02-14 11:07:42',NULL),(1514,7941,40735,24278,2,1514,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',30078915.45,'SUBDIARIO VENTAS',NULL,1,'2025-02-14 11:09:19','2025-02-14 11:09:19',NULL);
INSERT INTO `balance_libro` VALUES (1515,7941,40735,24267,16,1515,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',238079.58,'DJ IIBB',NULL,1,'2025-02-14 12:18:12','2025-02-14 12:18:12',NULL),(1516,7941,40735,24268,16,1516,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',245868.44,'DJ IIBB',NULL,1,'2025-02-14 15:32:32','2025-02-14 15:32:32',NULL),(1517,7941,40735,24269,16,1517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',523119.70,'DJ IIBB',NULL,1,'2025-02-14 15:50:56','2025-02-14 15:50:56',NULL),(1518,7941,40735,24270,16,1518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',553982.90,'DJ IIBB',NULL,1,'2025-02-14 16:02:13','2025-02-14 16:02:13',NULL),(1519,7941,40735,24271,16,1519,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',196105.06,'DJ IIBB',NULL,1,'2025-02-14 16:06:01','2025-02-14 16:06:01',NULL),(1520,7941,40735,24272,16,1520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',251076.41,'DJ IIBB',NULL,1,'2025-02-14 16:10:50','2025-02-14 16:10:50',NULL),(1521,7941,40735,24273,16,1521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',268523.88,'DJ IIBB',NULL,1,'2025-02-14 16:17:04','2025-02-14 16:17:04',NULL),(1522,7941,40735,24274,16,1522,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',200202.97,'DJ IIBB',NULL,1,'2025-02-14 16:20:01','2025-02-14 16:20:01',NULL),(1523,7941,40735,24275,16,1523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',287819.21,'DJ IIBB',NULL,1,'2025-02-14 16:25:03','2025-02-14 16:25:03',NULL),(1524,7941,40735,24276,16,1524,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',278097.44,'DJ IIBB',NULL,1,'2025-02-14 16:31:37','2025-02-14 16:31:37',NULL),(1525,7941,40735,24277,16,1525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',306258.68,'DJ IIBB',NULL,1,'2025-02-14 16:35:55','2025-02-14 16:35:55',NULL),(1526,7941,40735,24278,16,1526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',768667.59,'DJ IIBB',NULL,1,'2025-02-14 16:38:59','2025-02-14 16:38:59',NULL),(1527,7941,40871,206083,15,1527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2921276.04,'DJ IVA',NULL,1,'2025-02-17 12:09:06','2025-02-17 12:10:27','2025-02-17 12:10:27'),(1528,7941,40871,206083,2,1528,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2921276.04,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:10:27','2025-02-17 12:10:27',NULL),(1529,7941,40871,206084,2,1529,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',3484371.15,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:12:53','2025-02-17 12:12:53',NULL),(1530,7941,40871,206085,2,1530,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',3522312.92,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:17:08','2025-02-17 12:17:08',NULL),(1531,7941,40871,206086,2,1531,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4163927.13,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:20:21','2025-02-17 12:20:21',NULL),(1532,7941,40871,206087,2,1532,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',7462138.26,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:23:06','2025-02-17 12:23:06',NULL),(1533,7941,40871,206088,2,1533,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',19483141.62,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:25:29','2025-02-17 12:25:29',NULL);
INSERT INTO `balance_libro` VALUES (1534,7941,40871,206089,2,1534,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',25393589.24,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:28:45','2025-02-17 12:28:45',NULL),(1535,7941,40871,206090,2,1535,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',23208563.59,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:31:57','2025-02-17 12:31:57',NULL),(1536,7941,40871,206091,2,1536,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',24960387.33,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:36:15','2025-02-17 12:36:15',NULL),(1537,7941,40871,206092,2,1537,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',26099577.94,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:42:09','2025-02-17 12:42:09',NULL),(1538,7941,40871,206093,2,1538,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',21103106.81,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:44:45','2025-02-17 12:44:45',NULL),(1539,7941,40871,206094,2,1539,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',28750852.04,'SUBDIARIO VENTAS',NULL,1,'2025-02-17 12:47:44','2025-02-17 12:47:44',NULL),(1540,7941,40871,206083,15,1540,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',506998.32,'DJ IVA',NULL,1,'2025-02-17 15:46:08','2025-02-17 15:46:08',NULL),(1541,7941,40871,206084,15,1541,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',604725.57,'DJ IVA',NULL,1,'2025-02-17 15:50:10','2025-02-17 15:50:10',NULL),(1542,7941,40871,206085,15,1542,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',714950.06,'DJ IVA',NULL,1,'2025-02-17 15:53:46','2025-02-17 16:17:54','2025-02-17 16:17:54'),(1543,7941,40871,206086,15,1543,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',722665.04,'DJ IVA',NULL,1,'2025-02-17 16:02:03','2025-02-17 16:02:03',NULL),(1544,7941,40871,206087,15,1544,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3191858.57,'DJ IVA',NULL,1,'2025-02-17 16:15:18','2025-02-17 16:15:18',NULL),(1545,7941,40871,206085,15,1545,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',714950.06,'DJ IVA',NULL,1,'2025-02-17 16:17:54','2025-02-17 16:17:54',NULL),(1546,7941,40871,206088,15,1546,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',5395863.31,'DJ IVA',NULL,1,'2025-02-17 16:24:02','2025-02-17 16:24:02',NULL),(1547,7941,40871,206089,15,1547,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',5070233.19,'DJ IVA',NULL,1,'2025-02-17 16:28:11','2025-02-17 16:28:11',NULL),(1548,7941,40871,206090,15,1548,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',4027932.52,'DJ IVA',NULL,1,'2025-02-17 16:42:35','2025-02-17 16:42:35',NULL),(1549,7941,40871,206091,15,1549,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',4331968.05,'DJ IVA',NULL,1,'2025-02-17 16:46:37','2025-02-17 16:46:37',NULL),(1550,7941,40871,206092,15,1550,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4529678.82,'DJ IVA',NULL,1,'2025-02-17 16:51:11','2025-02-17 16:51:11',NULL),(1551,7941,40871,206093,15,1551,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3662522.67,'DJ IVA',NULL,1,'2025-02-17 17:00:50','2025-02-17 17:00:50',NULL),(1552,7941,40871,206094,15,1552,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4989817.30,'DJ IVA',NULL,1,'2025-02-17 17:08:08','2025-02-17 17:08:08',NULL);
INSERT INTO `balance_libro` VALUES (1553,7941,40871,206083,16,1553,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',99702.42,'DJ IIBB',NULL,1,'2025-02-17 17:37:34','2025-02-17 17:37:34',NULL),(1554,7941,40871,206084,16,1554,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',209253.80,'DJ IIBB',NULL,1,'2025-02-17 17:43:14','2025-02-17 17:43:14',NULL),(1555,7941,40871,206085,16,1555,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',224302.12,'DJ IIBB',NULL,1,'2025-02-17 17:47:24','2025-02-17 17:47:24',NULL),(1556,7941,40871,206086,16,1556,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',180792.12,'DJ IIBB',NULL,1,'2025-02-17 17:51:02','2025-02-17 17:51:02',NULL),(1557,7941,40871,206087,16,1557,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',237607.58,'DJ IIBB',NULL,1,'2025-02-17 17:54:11','2025-02-17 17:54:11',NULL),(1558,7941,40871,206088,16,1558,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',489909.50,'DJ IIBB',NULL,1,'2025-02-18 09:20:42','2025-02-18 09:20:42',NULL),(1559,7941,40871,206089,16,1559,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',648482.65,'DJ IIBB',NULL,1,'2025-02-18 09:30:23','2025-02-18 09:30:23',NULL),(1560,7941,40871,206090,16,1560,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',585413.80,'DJ IIBB',NULL,1,'2025-02-18 09:38:57','2025-02-18 09:38:57',NULL),(1561,7941,40871,206091,16,1561,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',773246.18,'DJ IIBB',NULL,1,'2025-02-18 09:46:26','2025-02-18 09:46:26',NULL),(1562,7941,40871,206092,16,1562,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',783349.61,'DJ IIBB',NULL,1,'2025-02-18 09:53:29','2025-02-18 09:53:29',NULL),(1563,7941,40871,206093,16,1563,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',647266.68,'DJ IIBB',NULL,1,'2025-02-18 10:00:06','2025-02-18 10:00:06',NULL),(1564,7941,40871,206094,16,1564,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',813773.21,'DJ IIBB',NULL,1,'2025-02-18 10:09:21','2025-02-18 10:09:21',NULL),(1565,7941,40872,207615,15,1565,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',281736.00,'DJ IVA',NULL,1,'2025-02-18 13:19:44','2025-02-18 13:19:44',NULL),(1566,7941,40871,206087,1,1566,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',967250.10,'SUELDOS',NULL,1,'2025-02-21 12:43:14','2025-02-21 12:43:14',NULL),(1567,7941,40871,206088,1,1567,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',3456708.36,'SUELDOS',NULL,1,'2025-02-21 12:46:35','2025-02-21 12:46:35',NULL),(1568,7941,40871,206089,1,1568,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3130658.08,'SUELDOS',NULL,1,'2025-02-21 12:50:06','2025-02-21 12:50:06',NULL),(1569,7941,40871,206090,1,1569,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3215779.75,'SUELDOS',NULL,1,'2025-02-21 12:53:55','2025-02-21 12:53:55',NULL),(1570,7941,40871,206091,1,1570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',4572499.14,'SUELDOS',NULL,1,'2025-02-21 13:03:39','2025-02-21 13:03:39',NULL),(1571,7941,40871,206092,1,1571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4994460.34,'SUELDOS',NULL,1,'2025-02-21 13:11:18','2025-02-21 13:11:18',NULL);
INSERT INTO `balance_libro` VALUES (1572,7941,40871,206093,1,1572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',4835381.70,'SUELDOS',NULL,1,'2025-02-21 13:15:01','2025-02-21 13:15:01',NULL),(1573,7941,40871,206094,1,1573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',7540542.92,'SUELDOS',NULL,1,'2025-02-21 13:19:04','2025-02-21 13:19:04',NULL),(1574,7941,40771,77301,2,1574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4979747.87,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:39:27','2025-02-26 14:44:55','2025-02-26 14:44:55'),(1575,7941,40771,77302,2,1575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',6666456.00,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:40:38','2025-02-21 13:40:38',NULL),(1576,7941,40771,77303,2,1576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',8360876.76,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:41:56','2025-02-27 11:14:14','2025-02-27 11:14:14'),(1577,7941,40771,77304,2,1577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',8738873.98,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:43:04','2025-02-21 13:43:04',NULL),(1578,7941,40771,77305,2,1578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',13940059.97,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:44:37','2025-02-21 13:44:38',NULL),(1579,7941,40771,77306,2,1579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',15300710.04,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:48:28','2025-02-21 13:48:28',NULL),(1580,7941,40771,77307,2,1580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',19601082.24,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:52:42','2025-02-26 14:55:07','2025-02-26 14:55:07'),(1581,7941,40771,77308,2,1581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',19368329.99,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:54:01','2025-02-21 13:54:01',NULL),(1582,7941,40771,77309,2,1582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',19211550.49,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:55:09','2025-04-21 15:29:10','2025-04-21 15:29:10'),(1583,7941,40771,77310,2,1583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',26547280.31,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:56:13','2025-02-21 13:56:13',NULL),(1584,7941,40771,77311,2,1584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',25566581.88,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:57:17','2025-02-21 13:57:17',NULL),(1585,7941,40771,77312,2,1585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',32047109.86,'SUBDIARIO VENTAS',NULL,1,'2025-02-21 13:58:25','2025-02-21 13:58:25',NULL),(1586,7941,40771,77301,15,1586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',766631.85,'DJ IVA',NULL,1,'2025-02-21 14:06:50','2025-02-27 11:15:37','2025-02-27 11:15:37'),(1587,7941,40771,77302,15,1587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1056732.49,'DJ IVA',NULL,1,'2025-02-21 14:09:55','2025-02-27 11:18:10','2025-02-27 11:18:10'),(1588,7941,40771,77303,15,1588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',1361192.27,'DJ IVA',NULL,1,'2025-02-21 14:48:25','2025-02-26 14:57:29','2025-02-26 14:57:29'),(1589,7941,40771,77304,15,1589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1486853.57,'DJ IVA',NULL,1,'2025-02-21 14:51:19','2025-02-26 14:59:11','2025-02-26 14:59:11');
INSERT INTO `balance_libro` VALUES (1590,7941,40771,77305,15,1590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2357430.02,'DJ IVA',NULL,1,'2025-02-21 14:53:08','2025-02-28 10:01:05','2025-02-28 10:01:05'),(1591,7941,40771,77306,15,1591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2545123.64,'DJ IVA',NULL,1,'2025-02-21 14:55:12','2025-02-26 15:00:19','2025-02-26 15:00:19'),(1592,7941,40771,77307,15,1592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3298009.91,'DJ IVA',NULL,1,'2025-02-21 14:58:13','2025-02-26 15:02:04','2025-02-26 15:02:04'),(1593,7941,40771,77308,15,1593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3245910.99,'DJ IVA',NULL,1,'2025-02-21 15:01:08','2025-02-26 15:06:16','2025-02-26 15:06:16'),(1594,7941,40771,77309,15,1594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3312977.88,'DJ IVA',NULL,1,'2025-02-21 15:02:46','2025-02-26 15:07:32','2025-02-26 15:07:32'),(1595,7941,40771,77310,15,1595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4503408.40,'DJ IVA',NULL,1,'2025-02-21 15:04:17','2025-02-28 10:07:26','2025-02-28 10:07:26'),(1596,7941,40771,77311,15,1596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',4316355.94,'DJ IVA',NULL,1,'2025-02-21 15:05:52','2025-02-28 10:08:18','2025-02-28 10:08:18'),(1597,7941,40771,77312,15,1597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5533934.12,'DJ IVA',NULL,1,'2025-02-21 15:08:19','2025-02-26 17:16:06','2025-02-26 17:16:06'),(1598,7941,40771,77301,16,1598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',155987.16,'DJ IIBB',NULL,1,'2025-02-21 15:29:03','2025-02-26 14:51:20','2025-02-26 14:51:20'),(1599,7941,40771,77302,16,1599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',205181.70,'DJ IIBB',NULL,1,'2025-02-21 15:32:11','2025-02-26 14:53:49','2025-02-26 14:53:49'),(1600,7941,40771,77303,16,1600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',254441.70,'DJ IIBB',NULL,1,'2025-02-21 15:34:15','2025-02-26 15:03:09','2025-02-26 15:03:09'),(1601,7941,40771,77304,16,1601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',265641.15,'DJ IIBB',NULL,1,'2025-02-21 15:36:21','2025-02-26 15:07:21','2025-02-26 15:07:21'),(1602,7941,40771,77305,16,1602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',416302.57,'DJ IIBB',NULL,1,'2025-02-21 15:42:20','2025-02-26 15:15:45','2025-02-26 15:15:45'),(1603,7941,40771,77305,16,1603,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',416302.57,'DJ IIBB',NULL,1,'2025-02-21 15:42:21','2025-02-21 15:43:05','2025-02-21 15:43:05'),(1604,7941,40771,77305,16,1604,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',416302.57,'DJ IIBB',NULL,1,'2025-02-21 15:42:21','2025-02-21 15:46:34','2025-02-21 15:46:34'),(1605,7941,40771,77305,16,1605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',416302.57,'DJ IIBB',NULL,1,'2025-02-21 15:42:23','2025-02-21 15:46:34','2025-02-21 15:46:34'),(1606,7941,40771,77305,16,1606,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',416302.57,'DJ IIBB',NULL,1,'2025-02-21 15:42:24','2025-02-21 15:46:34','2025-02-21 15:46:34'),(1607,7941,40771,77306,16,1607,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',455984.76,'DJ IIBB',NULL,1,'2025-02-21 15:50:20','2025-02-26 15:19:54','2025-02-26 15:19:54');
INSERT INTO `balance_libro` VALUES (1608,7941,40771,77307,16,1608,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',582997.58,'DJ IIBB',NULL,1,'2025-02-21 15:58:26','2025-02-26 15:36:59','2025-02-26 15:36:59'),(1609,7941,40771,77308,16,1609,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',574270.17,'DJ IIBB',NULL,1,'2025-02-21 16:01:27','2025-02-26 15:33:11','2025-02-26 15:33:11'),(1610,7941,40771,77309,16,1610,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',570081.89,'DJ IIBB',NULL,1,'2025-02-21 16:03:55','2025-02-26 15:40:40','2025-02-26 15:40:40'),(1611,7941,40771,77310,16,1611,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',782272.44,'DJ IIBB',NULL,1,'2025-02-21 16:06:16','2025-02-26 15:43:22','2025-02-26 15:43:22'),(1612,7941,40771,77311,16,1612,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',754200.13,'DJ IIBB',NULL,1,'2025-02-21 16:08:00','2025-02-26 15:46:16','2025-02-26 15:46:16'),(1613,7941,40771,77312,16,1613,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',942206.62,'DJ IIBB',NULL,1,'2025-02-21 16:09:05','2025-02-26 15:49:34','2025-02-26 15:49:34'),(1614,7941,40771,77312,1,1614,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5246362.82,'SUELDOS',NULL,1,'2025-02-21 16:27:14','2025-02-21 16:27:14',NULL),(1615,7941,40771,77310,1,1615,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',3514994.02,'SUELDOS',NULL,1,'2025-02-21 16:31:53','2025-02-21 16:31:53',NULL),(1616,7941,40771,77309,1,1616,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3322109.54,'SUELDOS',NULL,1,'2025-02-21 16:34:56','2025-02-21 16:34:56',NULL),(1617,7941,40872,207616,15,1617,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',281736.00,'DJ IVA',NULL,1,'2025-02-21 16:35:48','2025-02-21 16:39:52','2025-02-21 16:39:52'),(1618,7941,40872,207616,15,1618,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',159075.00,'DJ IVA',NULL,1,'2025-02-21 16:39:52','2025-02-21 16:39:52',NULL),(1619,11429,40872,207632,15,1619,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',304565.09,'DJ IVA',NULL,1,'2025-02-21 16:42:28','2025-05-05 12:30:23','2025-05-05 12:30:23'),(1620,7941,40771,77308,1,1620,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',2362638.45,'SUELDOS',NULL,1,'2025-02-21 16:44:52','2025-02-21 16:44:52',NULL),(1621,7941,40872,207618,15,1621,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',152720.01,'DJ IVA',NULL,1,'2025-02-21 16:47:32','2025-02-21 16:47:32',NULL),(1622,7941,40872,207619,15,1622,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',350461.11,'DJ IVA',NULL,1,'2025-02-21 16:50:55','2025-02-21 16:50:55',NULL),(1623,7941,40771,77307,1,1623,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2018872.74,'SUELDOS',NULL,1,'2025-02-21 16:59:00','2025-02-21 16:59:00',NULL),(1624,7941,40872,207620,15,1624,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',254974.09,'DJ IVA',NULL,1,'2025-02-21 16:59:02','2025-02-21 16:59:02',NULL),(1625,7941,40771,77306,1,1625,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2927300.09,'SUELDOS',NULL,1,'2025-02-21 17:02:14','2025-02-21 17:02:14',NULL),(1626,7941,40771,77305,1,1626,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2108377.41,'SUELDOS',NULL,1,'2025-02-21 17:05:29','2025-02-21 17:05:29',NULL);
INSERT INTO `balance_libro` VALUES (1627,7941,40872,207621,15,1627,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',477189.24,'DJ IVA',NULL,1,'2025-02-21 17:24:37','2025-02-21 17:24:37',NULL),(1628,7941,40872,207622,15,1628,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',295422.43,'DJ IVA',NULL,1,'2025-02-21 17:42:28','2025-02-21 17:42:28',NULL),(1629,7941,40872,207623,15,1629,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',257393.46,'DJ IVA',NULL,1,'2025-02-21 17:49:19','2025-02-21 17:49:19',NULL),(1630,7941,40872,207624,15,1630,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',700604.89,'DJ IVA',NULL,1,'2025-02-21 17:55:21','2025-02-21 17:55:21',NULL),(1631,7941,40771,77311,1,1631,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3613075.71,'SUELDOS',NULL,1,'2025-02-24 12:21:12','2025-02-24 12:21:12',NULL),(1632,7941,40771,77304,1,1632,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2375814.07,'SUELDOS',NULL,1,'2025-02-24 12:23:46','2025-02-24 12:23:46',NULL),(1633,7941,40771,77303,1,1633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',2877073.03,'SUELDOS',NULL,1,'2025-02-24 12:27:04','2025-02-24 12:27:04',NULL),(1634,7941,40771,77302,1,1634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',2563255.87,'SUELDOS',NULL,1,'2025-02-24 12:29:00','2025-02-24 12:29:00',NULL),(1635,7941,40771,77301,1,1635,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2648530.28,'SUELDOS',NULL,1,'2025-02-24 12:32:50','2025-02-24 12:32:50',NULL),(1636,7941,40871,206083,3,1636,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1928460.43,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 15:09:53','2025-02-24 15:09:53',NULL),(1637,7941,40871,206084,3,1637,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1721936.24,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 15:12:16','2025-02-24 15:12:16',NULL),(1638,7941,40871,206085,3,1638,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',4025495.14,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 15:14:35','2025-02-24 15:14:35',NULL),(1639,7941,40871,206086,3,1639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2762613.63,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 15:17:09','2025-02-24 15:17:09',NULL),(1640,7941,40871,206087,3,1640,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',18278548.46,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 15:19:38','2025-02-24 15:19:38',NULL),(1641,7941,40871,206088,3,1641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',20083461.55,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 15:21:55','2025-02-24 15:21:55',NULL),(1642,7941,40871,206090,3,1642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',15909627.15,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 15:31:39','2025-02-25 13:56:41','2025-02-25 13:56:41'),(1643,7941,40871,206089,3,1643,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',17498064.76,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 15:56:27','2025-02-24 15:56:27',NULL),(1644,7941,40735,24267,3,1644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',8058307.74,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 16:19:21','2025-02-24 16:23:32','2025-02-24 16:23:32'),(1645,7941,40735,24267,3,1645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',8277462.04,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 16:23:32','2025-02-24 16:23:32',NULL);
INSERT INTO `balance_libro` VALUES (1646,7941,40735,24268,3,1646,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',6393370.25,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 16:42:02','2025-02-24 16:44:07','2025-02-24 16:44:07'),(1647,7941,40735,24268,3,1647,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',6449899.18,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 16:44:07','2025-02-24 16:44:07',NULL),(1648,7941,40735,24269,3,1648,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',21404839.19,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 16:56:58','2025-02-24 16:56:58',NULL),(1649,7941,40735,24270,3,1649,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2649314.83,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 17:06:28','2025-02-24 17:06:28',NULL),(1650,7941,40735,24271,3,1650,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',5126211.43,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 17:12:53','2025-02-24 17:20:09','2025-02-24 17:20:09'),(1651,7941,40735,24271,3,1651,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',5169750.95,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 17:20:09','2025-02-24 17:20:09',NULL),(1652,7941,40735,24272,3,1652,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',4496671.89,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 17:47:45','2025-02-24 17:48:49','2025-02-24 17:48:49'),(1653,7941,40735,24272,3,1653,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',4496671.89,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 17:48:49','2025-02-24 17:48:49',NULL),(1654,7941,40735,24274,3,1654,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',2511164.87,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 17:53:44','2025-02-24 17:53:44',NULL),(1655,7941,40735,24275,3,1655,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3535081.38,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 17:59:12','2025-02-24 18:00:59','2025-02-24 18:00:59'),(1656,7941,40735,24275,3,1656,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',4135081.38,'SUBDIARIO COMPRAS',NULL,1,'2025-02-24 18:00:59','2025-02-24 18:00:59',NULL),(1657,7941,40871,206091,3,1657,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',23146228.79,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 09:29:25','2025-02-25 09:29:25',NULL),(1658,7941,40735,24276,3,1658,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',5763497.01,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 09:29:31','2025-02-25 09:32:25','2025-02-25 09:32:25'),(1659,7941,40735,24276,3,1659,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',5856968.08,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 09:32:25','2025-02-25 09:32:25',NULL),(1660,7941,40871,206092,3,1660,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',22786834.90,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 09:34:28','2025-02-25 09:34:28',NULL),(1661,7941,40871,206093,3,1661,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',17335463.76,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 09:38:10','2025-02-25 09:38:10',NULL),(1662,7941,40871,206094,3,1662,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',23585870.47,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 09:43:07','2025-02-25 09:43:07',NULL),(1663,7941,40735,24277,3,1663,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3849001.44,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 09:59:26','2025-02-25 09:59:26',NULL);
INSERT INTO `balance_libro` VALUES (1664,7941,40735,24278,3,1664,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',18716917.82,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 10:12:26','2025-02-25 10:14:53','2025-02-25 10:14:53'),(1665,7941,40735,24278,3,1665,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',18887165.75,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 10:14:53','2025-02-25 10:14:53',NULL),(1666,7941,40870,204565,3,1666,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',58943569.96,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 13:24:02','2025-02-25 13:24:02',NULL),(1667,7941,40870,204566,3,1667,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',92478948.85,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 13:54:03','2025-02-25 13:54:03',NULL),(1668,7941,40871,206090,3,1668,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',15909627.15,'SUBDIARIO COMPRAS',NULL,1,'2025-02-25 13:56:41','2025-02-25 13:56:41',NULL),(1669,7941,40870,204565,15,1669,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',119100455.94,'DJ IVA',NULL,1,'2025-02-25 14:07:25','2025-02-25 14:07:25',NULL),(1670,7941,40870,204566,15,1670,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',132910424.07,'DJ IVA',NULL,1,'2025-02-25 14:19:56','2025-02-25 14:19:56',NULL),(1671,7941,40870,204567,15,1671,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',145340768.67,'DJ IVA',NULL,1,'2025-02-25 14:21:52','2025-02-25 14:21:52',NULL),(1672,7941,40870,204568,15,1672,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',160390370.59,'DJ IVA',NULL,1,'2025-02-25 14:24:03','2025-02-25 14:24:03',NULL),(1673,7941,40870,204569,15,1673,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',176411472.48,'DJ IVA',NULL,1,'2025-02-25 14:25:39','2025-02-25 14:25:39',NULL),(1674,7941,40870,204570,15,1674,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',186661260.81,'DJ IVA',NULL,1,'2025-02-25 14:27:14','2025-02-25 14:27:14',NULL),(1675,7941,40870,204571,15,1675,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',214350590.07,'DJ IVA',NULL,1,'2025-02-25 14:29:06','2025-02-25 14:29:06',NULL),(1676,7941,40870,204572,15,1676,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',270119548.59,'DJ IVA',NULL,1,'2025-02-25 14:30:42','2025-02-25 14:30:42',NULL),(1677,7941,40870,204573,15,1677,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',282044050.36,'DJ IVA',NULL,1,'2025-02-25 14:32:34','2025-02-25 14:32:34',NULL),(1678,7941,40870,204574,15,1678,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',297244307.86,'DJ IVA',NULL,1,'2025-02-25 14:34:28','2025-02-25 14:34:28',NULL),(1679,7941,40870,204575,15,1679,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',306454430.13,'DJ IVA',NULL,1,'2025-02-25 14:36:01','2025-02-25 14:36:01',NULL),(1680,7941,40870,204576,15,1680,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',355453758.48,'DJ IVA',NULL,1,'2025-02-25 14:37:29','2025-02-25 14:37:29',NULL),(1681,7941,40771,77301,3,1681,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3043520.09,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 09:11:41','2025-02-26 09:11:41',NULL),(1682,7941,40771,77302,3,1682,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',5327249.58,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 09:19:14','2025-02-26 09:19:14',NULL);
INSERT INTO `balance_libro` VALUES (1683,7941,40771,77303,3,1683,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',7724961.22,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 09:26:06','2025-02-26 09:26:06',NULL),(1684,7941,40771,77304,3,1684,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4590529.30,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 09:32:26','2025-02-26 09:32:26',NULL),(1685,7941,40771,77305,3,1685,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',4705719.41,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 09:36:36','2025-02-26 09:36:36',NULL),(1686,7941,40771,77306,3,1686,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',4363084.66,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 09:41:38','2025-02-26 09:41:38',NULL),(1687,7941,40771,77307,3,1687,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6294663.45,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 09:49:32','2025-02-26 09:49:32',NULL),(1688,7941,40771,77308,3,1688,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',5211375.75,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 09:58:09','2025-02-26 09:58:09',NULL),(1689,7941,40771,77309,3,1689,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',19186895.49,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 10:02:38','2025-02-26 10:02:38',NULL),(1690,7941,40771,77310,3,1690,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',19112205.88,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 10:09:58','2025-02-26 10:09:58',NULL),(1691,7941,40771,77311,3,1691,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',5976790.84,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 10:14:09','2025-02-26 10:14:09',NULL),(1692,7941,40771,77312,3,1692,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',15867648.53,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 10:21:48','2025-02-26 10:21:48',NULL),(1693,11429,40873,209145,3,1693,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',200000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 12:15:13','2025-05-02 10:00:54','2025-05-02 10:00:54'),(1694,11429,40873,209146,3,1694,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1000000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 12:17:21','2025-05-02 10:11:27','2025-05-02 10:11:27'),(1695,7941,40873,209148,3,1695,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',8587842.94,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 12:20:29','2025-02-26 12:20:29',NULL),(1696,7941,40873,209149,3,1696,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',21225959.23,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 12:24:47','2025-02-26 12:24:47',NULL),(1697,7941,40873,209150,3,1697,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',5931021.94,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 12:38:18','2025-02-26 12:50:48','2025-02-26 12:50:48'),(1698,7941,40873,209150,3,1698,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',5931021.94,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 12:50:48','2025-02-26 12:50:48',NULL),(1699,7941,40873,209151,3,1699,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',9539723.34,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 13:11:38','2025-02-26 13:13:09','2025-02-26 13:13:09'),(1700,7941,40873,209151,3,1700,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',9539723.34,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 13:13:09','2025-02-26 13:13:09',NULL);
INSERT INTO `balance_libro` VALUES (1701,7941,40873,209152,3,1701,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',17985488.12,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 13:21:20','2025-02-26 13:21:20',NULL),(1702,7941,40873,209153,3,1702,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',24810741.17,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 13:46:07','2025-02-26 13:46:07',NULL),(1703,11429,40873,209154,3,1703,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',28169636.21,'SUBDIARIO COMPRAS',NULL,1,'2025-02-26 14:00:24','2025-05-02 10:49:54','2025-05-02 10:49:54'),(1704,7941,40771,77301,2,1704,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4978476.98,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 14:44:55','2025-02-27 11:12:16','2025-02-27 11:12:16'),(1705,7941,40771,77301,16,1705,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',155987.16,'DJ IIBB',NULL,1,'2025-02-26 14:51:20','2025-02-26 14:51:20',NULL),(1706,7941,40771,77302,16,1706,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',205181.70,'DJ IIBB',NULL,1,'2025-02-26 14:53:49','2025-02-26 14:53:49',NULL),(1707,7941,40771,77307,2,1707,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',19650669.00,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 14:55:07','2025-02-26 14:55:07',NULL),(1708,7941,40771,77303,15,1708,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',1366459.07,'DJ IVA',NULL,1,'2025-02-26 14:57:29','2025-02-27 11:23:52','2025-02-27 11:23:52'),(1709,7941,40771,77304,15,1709,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1486853.57,'DJ IVA',NULL,1,'2025-02-26 14:59:11','2025-04-21 13:39:28','2025-04-21 13:39:28'),(1710,7941,40771,77306,15,1710,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2545123.64,'DJ IVA',NULL,1,'2025-02-26 15:00:19','2025-02-26 15:03:20','2025-02-26 15:03:20'),(1711,7941,40771,77307,15,1711,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3298009.91,'DJ IVA',NULL,1,'2025-02-26 15:02:04','2025-02-28 10:03:04','2025-02-28 10:03:04'),(1712,7941,40771,77303,16,1712,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',254441.70,'DJ IIBB',NULL,1,'2025-02-26 15:03:09','2025-02-26 15:03:09',NULL),(1713,7941,40771,77306,15,1713,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2545123.64,'DJ IVA',NULL,1,'2025-02-26 15:03:20','2025-02-28 10:02:13','2025-02-28 10:02:13'),(1714,7941,40771,77308,15,1714,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3245910.99,'DJ IVA',NULL,1,'2025-02-26 15:06:16','2025-02-28 10:03:39','2025-02-28 10:03:39'),(1715,7941,40771,77304,16,1715,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',265641.15,'DJ IIBB',NULL,1,'2025-02-26 15:07:21','2025-02-26 15:07:21',NULL),(1716,7941,40771,77309,15,1716,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3312977.88,'DJ IVA',NULL,1,'2025-02-26 15:07:32','2025-02-28 10:05:12','2025-02-28 10:05:12'),(1717,7941,40771,77305,16,1717,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',416302.57,'DJ IIBB',NULL,1,'2025-02-26 15:15:45','2025-02-26 15:15:45',NULL),(1718,7941,40771,77306,16,1718,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',455984.76,'DJ IIBB',NULL,1,'2025-02-26 15:19:54','2025-02-26 15:19:54',NULL);
INSERT INTO `balance_libro` VALUES (1719,7941,40872,207615,2,1719,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',2964936.00,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:26:33','2025-02-26 15:26:33',NULL),(1720,7941,40872,207616,2,1720,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1674075.00,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:28:10','2025-02-26 15:28:10',NULL),(1721,7941,40872,207617,2,1721,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3205184.99,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:30:30','2025-02-26 15:30:30',NULL),(1722,7941,40872,207618,2,1722,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',1607196.30,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:33:03','2025-02-26 15:33:03',NULL),(1723,7941,40771,77308,16,1723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',574270.17,'DJ IIBB',NULL,1,'2025-02-26 15:33:11','2025-02-26 15:33:11',NULL),(1724,7941,40771,77307,16,1724,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',582997.58,'DJ IIBB',NULL,1,'2025-02-26 15:36:59','2025-02-26 16:32:40','2025-02-26 16:32:40'),(1725,7941,40872,207619,2,1725,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3688185.97,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:37:27','2025-02-26 15:37:27',NULL),(1726,7941,40872,207621,2,1726,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',5021848.67,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:39:54','2025-02-26 15:39:54',NULL),(1727,7941,40771,77309,16,1727,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',570081.89,'DJ IIBB',NULL,1,'2025-02-26 15:40:40','2025-02-26 15:40:40',NULL),(1728,7941,40872,207622,2,1728,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1501000.01,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:41:59','2025-02-26 15:41:59',NULL),(1729,7941,40771,77310,16,1729,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',782272.44,'DJ IIBB',NULL,1,'2025-02-26 15:43:22','2025-02-26 15:43:22',NULL),(1730,7941,40872,207623,2,1730,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',1690650.00,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:44:25','2025-02-26 15:44:25',NULL),(1731,7941,40771,77311,16,1731,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',754200.13,'DJ IIBB',NULL,1,'2025-02-26 15:46:16','2025-02-26 15:46:16',NULL),(1732,7941,40872,207624,2,1732,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2676906.47,'SUBDIARIO VENTAS',NULL,1,'2025-02-26 15:46:42','2025-02-26 15:46:42',NULL),(1733,7941,40771,77312,16,1733,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',942206.62,'DJ IIBB',NULL,1,'2025-02-26 15:49:34','2025-02-26 15:49:34',NULL),(1734,7941,40771,77307,16,1734,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',582060.82,'DJ IIBB',NULL,1,'2025-02-26 16:32:40','2025-02-26 16:32:40',NULL),(1735,7941,40771,77312,15,1735,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5533934.12,'DJ IVA',NULL,1,'2025-02-26 17:16:06','2025-02-28 10:09:38','2025-02-28 10:09:38'),(1736,7941,40771,77312,15,1736,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5533934.12,'DJ IVA',NULL,1,'2025-02-26 17:16:06','2025-02-26 17:17:54','2025-02-26 17:17:54'),(1737,7941,40771,77312,15,1737,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5533934.12,'DJ IVA',NULL,1,'2025-02-26 17:16:06','2025-02-26 17:20:58','2025-02-26 17:20:58');
INSERT INTO `balance_libro` VALUES (1738,7941,40872,207614,16,1738,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',65999.34,'DJ IIBB',NULL,1,'2025-02-26 18:35:21','2025-02-26 18:35:21',NULL),(1739,7941,40872,207615,16,1739,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',80496.00,'DJ IIBB',NULL,1,'2025-02-26 18:37:36','2025-02-26 18:37:36',NULL),(1740,7941,40872,207616,16,1740,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',38859.88,'DJ IIBB',NULL,1,'2025-02-26 18:41:59','2025-02-26 18:41:59',NULL),(1741,7941,40872,207617,16,1741,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',84030.96,'DJ IIBB',NULL,1,'2025-02-26 18:45:11','2025-02-26 18:45:11',NULL),(1742,7941,40872,207618,16,1742,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',74743.79,'DJ IIBB',NULL,1,'2025-02-26 18:48:24','2025-02-26 18:48:24',NULL),(1743,7941,40872,207619,16,1743,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',99477.45,'DJ IIBB',NULL,1,'2025-02-26 18:53:20','2025-02-26 18:53:20',NULL),(1744,7941,40872,207620,16,1744,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',11298.32,'DJ IIBB',NULL,1,'2025-02-26 18:55:45','2025-02-26 18:55:45',NULL),(1745,7941,40872,207621,16,1745,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',131658.78,'DJ IIBB',NULL,1,'2025-02-26 18:58:46','2025-02-26 18:58:46',NULL),(1746,7941,40872,207622,16,1746,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',39352.01,'DJ IIBB',NULL,1,'2025-02-26 19:00:28','2025-02-26 19:00:28',NULL),(1747,7941,40872,207623,16,1747,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',44324.10,'DJ IIBB',NULL,1,'2025-02-26 19:05:02','2025-02-26 19:05:02',NULL),(1748,7941,40872,207624,16,1748,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',69195.17,'DJ IIBB',NULL,1,'2025-02-26 19:08:06','2025-02-26 19:08:06',NULL),(1749,7941,40913,269888,15,1749,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',23625212.95,'DJ IVA',NULL,1,'2025-02-27 09:15:34','2025-02-27 09:15:34',NULL),(1750,7941,40913,269889,15,1750,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',14154916.45,'DJ IVA',NULL,1,'2025-02-27 09:22:38','2025-02-27 09:22:38',NULL),(1751,7941,40913,269890,15,1751,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',15546037.31,'DJ IVA',NULL,1,'2025-02-27 09:28:14','2025-02-27 09:28:14',NULL),(1752,7941,40913,269891,15,1752,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',21850998.76,'DJ IVA',NULL,1,'2025-02-27 09:32:10','2025-02-27 09:32:10',NULL),(1753,7941,40913,269892,15,1753,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',31243870.24,'DJ IVA',NULL,1,'2025-02-27 09:37:22','2025-02-27 09:37:22',NULL),(1754,7941,40913,269893,15,1754,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',14895626.91,'DJ IVA',NULL,1,'2025-02-27 09:43:47','2025-02-27 09:43:47',NULL),(1755,7941,40913,269894,15,1755,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',21353032.83,'DJ IVA',NULL,1,'2025-02-27 11:08:14','2025-02-27 11:08:14',NULL),(1756,7941,40771,77301,2,1756,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4978476.98,'SUBDIARIO VENTAS',NULL,1,'2025-02-27 11:12:16','2025-02-27 11:12:16',NULL);
INSERT INTO `balance_libro` VALUES (1757,7941,40771,77303,2,1757,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',8360876.76,'SUBDIARIO VENTAS',NULL,1,'2025-02-27 11:14:14','2025-02-27 11:14:14',NULL),(1758,7941,40771,77301,15,1758,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',765360.96,'DJ IVA',NULL,1,'2025-02-27 11:15:37','2025-02-27 11:15:37',NULL),(1759,7941,40771,77302,15,1759,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1055278.81,'DJ IVA',NULL,1,'2025-02-27 11:18:10','2025-02-27 11:18:10',NULL),(1760,7941,40771,77303,15,1760,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',1347310.89,'DJ IVA',NULL,1,'2025-02-27 11:23:52','2025-02-27 11:23:52',NULL),(1761,7941,40913,269888,16,1761,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1080471.57,'DJ IIBB',NULL,1,'2025-02-27 13:07:18','2025-02-27 13:07:18',NULL),(1762,7941,40913,269889,16,1762,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1238668.96,'DJ IIBB',NULL,1,'2025-02-27 14:04:25','2025-02-27 14:04:25',NULL),(1763,7941,40913,269890,16,1763,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',2098045.93,'DJ IIBB',NULL,1,'2025-02-27 14:12:00','2025-02-27 14:12:00',NULL),(1764,7941,40913,269891,16,1764,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2017445.98,'DJ IIBB',NULL,1,'2025-02-27 14:27:38','2025-02-27 14:27:38',NULL),(1765,7941,40913,269892,16,1765,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2485413.08,'DJ IIBB',NULL,1,'2025-02-27 14:41:03','2025-02-27 14:41:03',NULL),(1766,7941,40913,269893,16,1766,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2503474.49,'DJ IIBB',NULL,1,'2025-02-27 14:46:30','2025-02-27 14:46:30',NULL),(1767,7941,40913,269894,16,1767,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2908468.65,'DJ IIBB',NULL,1,'2025-02-27 14:50:41','2025-02-27 14:50:41',NULL),(1768,7941,40913,269895,16,1768,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',2761822.73,'DJ IIBB',NULL,1,'2025-02-27 14:58:21','2025-02-27 14:58:21',NULL),(1769,7941,40913,269896,16,1769,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3019532.25,'DJ IIBB',NULL,1,'2025-02-27 15:02:45','2025-02-27 15:02:45',NULL),(1770,7941,40913,269897,16,1770,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',3163370.50,'DJ IIBB',NULL,1,'2025-02-27 15:05:52','2025-02-27 15:05:52',NULL),(1771,7941,40913,269898,16,1771,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3883615.86,'DJ IIBB',NULL,1,'2025-02-27 15:09:44','2025-02-27 15:09:44',NULL),(1772,7941,40913,269899,16,1772,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5468136.79,'DJ IIBB',NULL,1,'2025-02-27 15:13:44','2025-02-27 15:13:44',NULL),(1773,7941,40771,77305,15,1773,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2311650.49,'DJ IVA',NULL,1,'2025-02-28 10:01:05','2025-02-28 10:01:05',NULL),(1774,7941,40771,77306,15,1774,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2545123.64,'DJ IVA',NULL,1,'2025-02-28 10:02:13','2025-02-28 10:02:13',NULL),(1775,7941,40771,77307,15,1775,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3298009.91,'DJ IVA',NULL,1,'2025-02-28 10:03:04','2025-02-28 10:03:04',NULL);
INSERT INTO `balance_libro` VALUES (1776,7941,40771,77308,15,1776,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3245910.99,'DJ IVA',NULL,1,'2025-02-28 10:03:39','2025-02-28 10:03:39',NULL),(1777,7941,40771,77309,15,1777,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3215846.37,'DJ IVA',NULL,1,'2025-02-28 10:05:12','2025-02-28 10:05:12',NULL),(1778,7941,40771,77310,15,1778,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4488989.56,'DJ IVA',NULL,1,'2025-02-28 10:07:26','2025-02-28 10:07:26',NULL),(1779,7941,40771,77311,15,1779,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',4316355.94,'DJ IVA',NULL,1,'2025-02-28 10:08:18','2025-02-28 10:08:18',NULL),(1780,7941,40771,77312,15,1780,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5436519.89,'DJ IVA',NULL,1,'2025-02-28 10:09:38','2025-02-28 10:09:38',NULL),(1781,7941,40877,215234,1,1781,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4064749.11,'SUELDOS',NULL,1,'2025-02-28 17:03:17','2025-02-28 17:03:17',NULL),(1782,7941,40877,215235,1,1782,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',2789847.41,'SUELDOS',NULL,1,'2025-02-28 17:05:46','2025-02-28 17:05:46',NULL),(1783,7941,40877,215236,1,1783,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',3374558.42,'SUELDOS',NULL,1,'2025-02-28 17:08:37','2025-02-28 17:08:37',NULL),(1784,7941,40877,215237,1,1784,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',7915871.94,'SUELDOS',NULL,1,'2025-02-28 17:10:28','2025-02-28 17:10:28',NULL),(1785,7941,40877,215238,1,1785,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',7415893.79,'SUELDOS',NULL,1,'2025-02-28 17:12:38','2025-02-28 17:12:38',NULL),(1786,7941,40877,215239,1,1786,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',11177507.47,'SUELDOS',NULL,1,'2025-02-28 17:14:40','2025-02-28 17:14:40',NULL),(1787,7941,40877,215240,1,1787,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',9274044.54,'SUELDOS',NULL,1,'2025-02-28 17:16:35','2025-02-28 17:16:35',NULL),(1788,7941,40911,266840,12,1788,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',26578178.00,'saldos iniciales',NULL,1,'2025-03-05 19:11:13','2025-03-06 13:52:17','2025-03-06 13:52:17'),(1789,7941,40911,266840,12,1789,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',26578178.00,'SALDOS INICIALES',NULL,1,'2025-03-06 13:33:06','2025-03-06 13:51:20','2025-03-06 13:51:20'),(1790,7941,40911,266840,12,1790,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',26578178.00,'saldos iniciales',NULL,1,'2025-03-06 13:52:17','2025-03-06 13:52:17',NULL),(1791,7941,40875,212199,3,1791,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3689973.87,'SUBDIARIO COMPRAS',NULL,1,'2025-03-10 09:25:46','2025-03-10 09:50:29','2025-03-10 09:50:29'),(1792,7941,40875,212199,3,1792,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3689973.87,'SUBDIARIO COMPRAS',NULL,1,'2025-03-10 09:50:29','2025-03-10 09:50:29',NULL),(1793,7941,40871,206083,5,1793,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1529127.00,'BANCO SANTANDER',NULL,1,'2025-03-10 13:59:57','2025-03-10 13:59:57',NULL),(1794,7941,40871,206084,5,1794,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',2853901.99,'BANCO SANTANDER',NULL,1,'2025-03-10 15:24:18','2025-03-10 15:24:18',NULL);
INSERT INTO `balance_libro` VALUES (1795,7941,40871,206085,5,1795,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',3499675.00,'BANCO SANTANDER',NULL,1,'2025-03-10 15:33:17','2025-03-10 15:33:17',NULL),(1796,7941,40871,206086,5,1796,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4325848.26,'BANCO SANTANDER',NULL,1,'2025-03-10 15:39:13','2025-03-10 15:39:13',NULL),(1797,7941,40871,206087,5,1797,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',6754638.00,'BANCO SANTANDER',NULL,1,'2025-03-10 16:18:50','2025-03-10 16:18:50',NULL),(1798,7941,40871,206088,5,1798,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',17975570.00,'BANCO SANTANDER',NULL,1,'2025-03-10 16:29:43','2025-03-10 16:29:43',NULL),(1799,7941,40871,206089,5,1799,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14555356.00,'BANCO SANTANDER',NULL,1,'2025-03-10 16:42:32','2025-03-10 16:42:32',NULL),(1800,7941,40871,206090,5,1800,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',13738655.11,'BANCO SANTANDER',NULL,1,'2025-03-10 16:57:49','2025-03-10 16:57:49',NULL),(1801,7941,40871,206091,5,1801,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',16010386.00,'BANCO SANTANDER',NULL,1,'2025-03-10 17:03:59','2025-03-10 17:03:59',NULL),(1802,7941,40871,206092,5,1802,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',18376547.00,'BANCO SANTANDER',NULL,1,'2025-03-10 17:15:39','2025-03-10 17:15:39',NULL),(1803,7941,40871,206093,5,1803,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',18000856.00,'BANCO SANTANDER',NULL,1,'2025-03-10 17:25:53','2025-03-10 17:25:53',NULL),(1804,7941,40871,206094,5,1804,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',25603751.00,'BANCO SANTANDER',NULL,1,'2025-03-10 17:39:55','2025-03-10 17:39:55',NULL),(1805,7941,40870,204565,5,1805,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',27693.17,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 13:17:43','2025-03-11 13:17:43',NULL),(1806,7941,40870,204566,5,1806,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',100000.00,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 13:27:10','2025-03-11 13:27:10',NULL),(1807,7941,40870,204567,5,1807,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',41539.75,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 13:32:15','2025-03-11 13:32:15',NULL),(1808,7941,40870,204568,5,1808,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',100000.00,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 13:38:24','2025-03-11 13:38:24',NULL),(1809,7941,40870,204569,5,1809,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',41539.75,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 13:44:45','2025-03-11 13:44:45',NULL),(1810,7941,40870,204570,5,1810,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',41539.75,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 13:53:07','2025-03-11 13:53:08',NULL),(1811,7941,40870,204571,5,1811,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',100000.00,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 14:00:16','2025-03-11 14:00:16',NULL),(1812,7941,40870,204572,5,1812,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',41539.75,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 14:07:41','2025-03-11 14:07:41',NULL);
INSERT INTO `balance_libro` VALUES (1813,7941,40870,204573,5,1813,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',100000.00,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 14:13:47','2025-03-11 14:13:47',NULL),(1814,7941,40870,204574,5,1814,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',41539.75,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 14:17:13','2025-03-11 14:17:13',NULL),(1815,7941,40870,204575,5,1815,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',44284.12,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 14:24:49','2025-03-11 14:24:49',NULL),(1816,7941,40870,204576,5,1816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',80000.00,'BANCO SANTANDER cta 9171-2',NULL,1,'2025-03-11 14:28:43','2025-03-11 14:28:43',NULL),(1817,7941,40870,204565,5,1817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',15942500.00,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 14:44:39','2025-03-11 14:44:39',NULL),(1818,7941,40870,204566,5,1818,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',20655548.57,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 14:48:58','2025-03-11 14:48:58',NULL),(1819,7941,40870,204567,5,1819,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',17354846.51,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 14:51:20','2025-03-11 14:51:20',NULL),(1820,7941,40870,204568,5,1820,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',31130735.52,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 14:53:01','2025-03-11 14:53:01',NULL),(1821,7941,40870,204569,5,1821,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',21014022.30,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 14:54:56','2025-03-11 14:54:56',NULL),(1822,7941,40870,204570,5,1822,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',30126068.00,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 14:58:50','2025-03-11 14:58:50',NULL),(1823,7941,40870,204571,5,1823,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',32022782.55,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 15:01:14','2025-03-11 15:01:14',NULL),(1824,7941,40870,204572,5,1824,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',34059743.36,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 15:03:29','2025-03-11 15:03:29',NULL),(1825,7941,40870,204573,5,1825,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',36426497.58,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 15:07:24','2025-03-11 15:07:24',NULL),(1826,7941,40870,204574,5,1826,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',69517500.00,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 15:09:57','2025-03-11 15:09:57',NULL),(1827,7941,40870,204575,5,1827,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',31129430.64,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 15:12:44','2025-03-11 15:12:45',NULL),(1828,7941,40870,204576,5,1828,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',245965745.18,'BANCO SANTANDER cta 9555-4',NULL,1,'2025-03-11 15:14:48','2025-03-11 15:14:48',NULL),(1829,7941,40870,204565,5,1829,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',131519544.06,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 17:58:25','2025-03-11 18:16:21','2025-03-11 18:16:21');
INSERT INTO `balance_libro` VALUES (1830,7941,40870,204565,5,1830,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',131519544.06,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 18:16:21','2025-03-11 18:16:21',NULL),(1831,7941,40870,204566,5,1831,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',146390784.24,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 18:24:17','2025-03-11 18:24:17',NULL),(1832,7941,40870,204567,5,1832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',122496989.05,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 18:35:27','2025-03-11 18:35:27',NULL),(1833,7941,40870,204568,5,1833,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',153619037.53,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 18:43:02','2025-03-11 18:43:02',NULL),(1834,7941,40870,204569,5,1834,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',204536923.38,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 18:50:16','2025-03-11 18:50:16',NULL),(1835,7941,40870,204570,5,1835,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',105094351.73,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 18:56:15','2025-03-11 18:56:15',NULL),(1836,7941,40870,204571,5,1836,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',173292840.61,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 19:02:58','2025-03-11 19:02:58',NULL),(1837,7941,40870,204572,5,1837,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',248303159.06,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 19:09:42','2025-03-11 19:09:42',NULL),(1838,7941,40870,204573,5,1838,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',171395753.56,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 19:16:55','2025-03-11 19:16:55',NULL),(1839,7941,40870,204574,5,1839,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',203670219.93,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 19:23:39','2025-03-11 19:23:39',NULL),(1840,7941,40870,204575,5,1840,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',179635733.56,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 19:28:50','2025-03-11 19:28:50',NULL),(1841,7941,40870,204576,5,1841,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',248195139.72,'BANCO SANTANDER cta 9161-3',NULL,1,'2025-03-11 19:33:53','2025-03-11 19:33:54',NULL),(1842,7941,40871,206083,12,1842,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1439784.17,'SALDOS INICIALES',NULL,1,'2025-03-15 16:46:18','2025-03-15 16:46:18',NULL),(1843,7941,40870,204565,12,1843,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2291591797.38,'SALDOS INICIALES',NULL,1,'2025-03-18 16:16:04','2025-03-18 16:24:02','2025-03-18 16:24:02'),(1844,7941,40870,204565,12,1844,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2291591797.38,'SALDOS INICIALES',NULL,1,'2025-03-18 16:24:02','2025-03-19 09:06:02','2025-03-19 09:06:02'),(1845,7941,40870,204565,12,1845,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2291591797.38,'SALDOS INICIALES',NULL,1,'2025-03-19 09:06:02','2025-03-19 09:06:02',NULL),(1846,7941,40913,269895,15,1846,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',22637754.43,'DJ IVA',NULL,1,'2025-03-19 10:32:12','2025-03-19 10:32:12',NULL),(1847,7941,40913,269897,15,1847,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',21225926.00,'DJ IVA',NULL,1,'2025-03-19 10:47:48','2025-03-19 10:47:48',NULL);
INSERT INTO `balance_libro` VALUES (1848,7941,40913,269898,15,1848,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',32775037.79,'DJ IVA',NULL,1,'2025-03-19 10:57:34','2025-03-19 10:57:34',NULL),(1849,7941,40913,269899,15,1849,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',39978226.85,'DJ IVA',NULL,1,'2025-03-19 11:04:34','2025-03-19 11:04:34',NULL),(1850,7941,40913,269888,2,1850,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',109961604.42,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:08:13','2025-03-19 11:08:13',NULL),(1851,7941,40913,269889,2,1851,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',81559282.73,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:17:14','2025-03-19 11:17:14',NULL),(1852,7941,40913,269890,2,1852,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',89574788.76,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:19:07','2025-03-19 11:19:07',NULL),(1853,7941,40913,269891,2,1853,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',125903376.07,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:20:38','2025-03-19 11:20:38',NULL),(1854,7941,40913,269892,2,1854,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',180024206.98,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:22:13','2025-03-19 11:22:13',NULL),(1855,7941,40913,269893,2,1855,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',85996885.90,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:23:30','2025-03-19 11:23:30',NULL),(1856,7941,40913,269894,2,1856,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',123050941.55,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:25:32','2025-03-19 11:25:32',NULL),(1857,7941,40913,269895,2,1857,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',130436585.05,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:26:55','2025-03-19 11:26:55',NULL),(1858,7941,40913,269896,2,1858,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',116738916.64,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:28:01','2025-03-19 11:28:01',NULL),(1859,7941,40913,270137,2,1859,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',126076610.29,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:30:06','2025-03-19 11:30:45','2025-03-19 11:30:45'),(1860,7941,40913,269897,2,1860,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',122301764.08,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:33:14','2025-03-19 11:33:14',NULL),(1861,7941,40913,269898,2,1861,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',126076610.29,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:35:17','2025-03-19 11:35:17',NULL),(1862,7941,40913,269899,2,1862,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',139520596.84,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 11:36:32','2025-03-19 11:36:32',NULL),(1863,7941,40913,269896,2,1863,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20258890.33,'SUBDIARIO VENTAS',NULL,1,'2025-03-19 13:30:32','2025-03-19 13:34:30','2025-03-19 13:34:30'),(1864,7941,40913,269896,15,1864,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20258890.33,'DJ IVA',NULL,1,'2025-03-19 13:34:30','2025-03-19 13:34:30',NULL),(1865,7941,40913,269888,1,1865,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',15155651.05,'SUELDOS',NULL,1,'2025-03-21 11:17:10','2025-03-21 11:22:05','2025-03-21 11:22:05');
INSERT INTO `balance_libro` VALUES (1866,7941,40913,269889,1,1866,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',16476014.67,'SUELDOS',NULL,1,'2025-03-21 11:20:51','2025-03-21 11:20:51',NULL),(1867,7941,40913,269888,1,1867,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',15155651.05,'SUELDOS',NULL,1,'2025-03-21 11:22:05','2025-03-21 11:22:05',NULL),(1868,7941,40913,269890,1,1868,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',18612842.15,'SUELDOS',NULL,1,'2025-03-21 11:57:21','2025-03-21 11:57:21',NULL),(1869,7941,40913,269891,1,1869,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',17191748.44,'SUELDOS',NULL,1,'2025-03-21 12:35:58','2025-03-21 12:35:58',NULL),(1870,7941,40913,269892,1,1870,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',19363565.63,'SUELDOS',NULL,1,'2025-03-21 12:38:46','2025-03-21 12:38:46',NULL),(1871,7941,40913,269893,1,1871,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',19657612.79,'SUELDOS',NULL,1,'2025-03-21 12:41:48','2025-03-21 12:41:48',NULL),(1872,7941,40913,269894,1,1872,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',19657612.79,'SUELDOS',NULL,1,'2025-03-25 09:08:44','2025-03-25 09:08:44',NULL),(1873,7941,40913,269895,1,1873,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',23483031.53,'SUELDOS',NULL,1,'2025-03-25 10:56:49','2025-03-25 10:56:49',NULL),(1874,7941,40871,206083,19,1874,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',162732.00,'Seg. e Higiene',NULL,1,'2025-03-25 11:59:25','2025-03-25 11:59:25',NULL),(1875,7941,40871,206084,19,1875,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',232587.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:00:12','2025-03-25 12:00:12',NULL),(1876,7941,40871,206085,19,1876,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',172490.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:00:59','2025-03-25 12:00:59',NULL),(1877,7941,40871,206086,19,1877,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',172490.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:01:27','2025-03-25 12:01:27',NULL),(1878,7941,40871,206087,19,1878,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',144423.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:02:03','2025-03-25 12:02:03',NULL),(1879,7941,40871,206088,19,1879,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',96357.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:02:33','2025-03-25 12:02:33',NULL),(1880,7941,40871,206089,19,1880,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',304174.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:03:11','2025-03-25 12:03:11',NULL),(1881,7941,40871,206090,19,1881,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',286679.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:03:38','2025-03-25 12:03:38',NULL),(1882,7941,40871,206091,19,1882,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',299161.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:04:07','2025-03-25 12:04:07',NULL),(1883,7941,40871,206092,19,1883,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',312676.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:04:38','2025-03-25 12:04:38',NULL),(1884,7941,40871,206093,19,1884,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',253677.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:05:14','2025-03-25 12:05:14',NULL);
INSERT INTO `balance_libro` VALUES (1885,7941,40871,206094,19,1885,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',344117.00,'Seg. e Higiene',NULL,1,'2025-03-25 12:05:40','2025-03-25 12:05:40',NULL),(1886,7941,40913,269896,1,1886,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20901095.81,'SUELDOS',NULL,1,'2025-03-25 12:59:20','2025-03-25 13:02:09','2025-03-25 13:02:09'),(1887,7941,40913,269896,1,1887,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20901095.81,'SUELDOS',NULL,1,'2025-03-25 13:02:09','2025-03-25 13:02:09',NULL),(1888,7941,40913,269897,1,1888,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',23483031.53,'SUELDOS',NULL,1,'2025-03-25 13:04:48','2025-03-25 13:04:48',NULL),(1889,7941,40913,269898,1,1889,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',23076554.73,'SUELDOS',NULL,1,'2025-03-25 13:07:40','2025-03-25 13:07:40',NULL),(1890,7941,40913,269899,1,1890,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',36471806.56,'SUELDOS',NULL,1,'2025-03-25 13:13:06','2025-03-25 13:13:06',NULL),(1891,7941,40913,269888,12,1891,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',5964589.99,'saldos iniciales',NULL,1,'2025-03-25 17:37:28','2025-03-25 17:39:40','2025-03-25 17:39:40'),(1892,7941,40913,269903,12,1892,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',5964589.99,'saldos iniciales',NULL,1,'2025-03-25 17:39:40','2025-03-26 13:33:05','2025-03-26 13:33:05'),(1893,7941,40913,269903,12,1893,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',5964589.99,'saldos iniciales',NULL,1,'2025-03-26 13:33:05','2025-03-26 14:05:15','2025-03-26 14:05:15'),(1894,7941,40913,269903,12,1894,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',609319575.73,'saldos iniciales',NULL,1,'2025-03-26 14:05:15','2025-04-03 15:19:39','2025-04-03 15:19:39'),(1895,7941,40911,266840,12,1895,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',48803337.54,'saldos iniciales',NULL,1,'2025-03-26 14:59:21','2025-03-26 14:59:21',NULL),(1896,7941,40912,268358,3,1896,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',8550861.09,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 15:40:21','2025-03-26 15:40:21',NULL),(1897,7941,40912,268359,3,1897,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',3138912.71,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 15:52:12','2025-03-26 15:52:12',NULL),(1898,7941,40912,268360,3,1898,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',9092779.26,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 16:09:13','2025-03-26 16:09:13',NULL),(1899,7941,40912,268361,3,1899,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',9241557.17,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 16:15:45','2025-03-26 16:15:45',NULL),(1900,7941,40912,268362,3,1900,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',12676234.19,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 16:21:04','2025-03-26 16:21:04',NULL),(1904,11429,40912,268363,3,1904,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',5091219.21,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 16:31:30','2025-05-06 12:01:47','2025-05-06 12:01:47'),(1905,7941,40912,268364,3,1905,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',10416452.20,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 16:37:48','2025-03-26 16:37:48',NULL);
INSERT INTO `balance_libro` VALUES (1906,7941,40912,268365,3,1906,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',4930502.50,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 16:58:28','2025-03-26 16:58:28',NULL),(1907,7941,40912,268366,3,1907,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6982056.26,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 17:05:22','2025-03-26 17:05:22',NULL),(1908,7941,40912,268367,3,1908,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',5471900.77,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 17:14:33','2025-03-26 17:14:33',NULL),(1909,7941,40912,268368,3,1909,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',7972373.00,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 17:21:24','2025-03-26 17:21:24',NULL),(1910,7941,40912,268369,3,1910,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4037080.83,'SUBDIARIO COMPRAS',NULL,1,'2025-03-26 17:41:51','2025-03-26 17:41:51',NULL),(1911,7941,40912,268358,2,1911,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',18228527.79,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 09:50:30','2025-03-27 09:50:30',NULL),(1912,7941,40912,268359,2,1912,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',8937392.75,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 09:52:00','2025-03-27 09:52:00',NULL),(1913,7941,40912,268360,2,1913,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',21195858.56,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 09:54:05','2025-03-27 09:54:05',NULL),(1914,7941,40912,268361,2,1914,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',13057856.86,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 09:55:16','2025-03-27 09:55:16',NULL),(1915,7941,40912,268362,2,1915,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',8762188.63,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 09:56:22','2025-03-27 09:56:22',NULL),(1916,7941,40912,268363,2,1916,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',28841076.00,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 09:57:37','2025-03-27 09:57:37',NULL),(1917,7941,40912,268364,2,1917,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',20210675.52,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 09:58:49','2025-03-27 09:58:49',NULL),(1918,7941,40912,268365,2,1918,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',22827776.92,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 10:10:27','2025-03-27 10:10:27',NULL),(1919,7941,40912,268366,2,1919,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',22371471.96,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 10:24:54','2025-03-27 10:24:54',NULL),(1920,7941,40912,268367,2,1920,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',20831094.03,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 10:27:09','2025-03-27 10:27:09',NULL),(1921,7941,40912,268368,2,1921,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',18619923.49,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 10:32:35','2025-03-27 10:32:35',NULL),(1922,7941,40912,268369,2,1922,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',11610524.00,'SUBDIARIO VENTAS',NULL,1,'2025-03-27 10:35:47','2025-03-27 10:35:47',NULL),(1923,7941,40912,268358,15,1923,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3163628.79,'DJ IVA',NULL,1,'2025-03-27 10:50:34','2025-03-27 10:50:34',NULL);
INSERT INTO `balance_libro` VALUES (1924,7941,40912,268359,15,1924,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1551117.75,'DJ IVA',NULL,1,'2025-03-27 10:52:44','2025-03-27 10:52:44',NULL),(1925,7941,40912,268360,15,1925,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',3678620.08,'DJ IVA',NULL,1,'2025-03-27 10:54:28','2025-03-27 10:54:28',NULL),(1926,7941,40912,268361,15,1926,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4351621.06,'DJ IVA',NULL,1,'2025-03-27 11:00:54','2025-03-27 11:00:54',NULL),(1927,7941,40912,268362,15,1927,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2940515.25,'DJ IVA',NULL,1,'2025-03-27 11:03:30','2025-03-27 11:03:30',NULL),(1928,7941,40912,268363,15,1928,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',5005476.00,'DJ IVA',NULL,1,'2025-03-27 11:10:43','2025-03-27 11:10:43',NULL),(1929,7941,40912,268364,15,1929,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3507637.90,'DJ IVA',NULL,1,'2025-03-27 11:13:01','2025-03-27 11:13:01',NULL),(1930,7941,40912,268365,15,1930,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3961845.58,'DJ IVA',NULL,1,'2025-03-27 11:15:26','2025-03-27 11:15:26',NULL),(1931,7941,40912,268366,15,1931,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3882652.16,'DJ IVA',NULL,1,'2025-03-27 11:17:52','2025-03-27 11:17:52',NULL),(1932,7941,40912,268367,15,1932,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',3615313.84,'DJ IVA',NULL,1,'2025-03-27 11:21:41','2025-03-27 11:21:41',NULL),(1933,7941,40912,268368,15,1933,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3628113.95,'DJ IVA',NULL,1,'2025-03-27 11:24:26','2025-03-27 11:24:26',NULL),(1934,7941,40735,24267,1,1934,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',882911.41,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:07:27','2025-03-27 14:07:27',NULL),(1935,7941,40735,24268,1,1935,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',941942.88,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:09:56','2025-03-27 14:09:56',NULL),(1936,7941,40735,24269,1,1936,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1047904.54,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:12:43','2025-03-27 14:12:43',NULL),(1937,7941,40735,24270,1,1937,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',935428.47,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:15:15','2025-03-27 14:15:15',NULL),(1938,7941,40735,24271,1,1938,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1666322.97,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:18:01','2025-03-27 14:18:01',NULL),(1939,7941,40735,24272,1,1939,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',2931111.37,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:21:11','2025-03-27 14:21:11',NULL),(1940,7941,40735,24273,1,1940,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1971950.96,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:23:54','2025-03-27 14:23:54',NULL),(1941,7941,40735,24274,1,1941,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1666365.38,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:26:17','2025-03-27 14:26:17',NULL);
INSERT INTO `balance_libro` VALUES (1942,7941,40735,24275,1,1942,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1887557.86,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:29:24','2025-03-27 14:29:24',NULL),(1943,7941,40735,24276,1,1943,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2045349.14,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:32:11','2025-03-27 14:32:11',NULL),(1944,7941,40735,24277,1,1944,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2328597.64,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:34:42','2025-03-27 14:34:42',NULL),(1945,7941,40735,24278,1,1945,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1963502.10,'Sueldos y Cargas Sociales',NULL,1,'2025-03-27 14:37:09','2025-03-27 14:37:09',NULL),(1946,7941,40912,268358,16,1946,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1198278.36,'DJ IIBB',NULL,1,'2025-03-28 13:29:17','2025-03-28 13:29:17',NULL),(1947,7941,40912,268359,16,1947,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1153725.82,'DJ IIBB',NULL,1,'2025-03-28 13:34:16','2025-03-28 13:34:16',NULL),(1948,7941,40912,268360,16,1948,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',1357960.04,'DJ IIBB',NULL,1,'2025-03-28 13:40:20','2025-03-28 13:40:20',NULL),(1949,7941,40912,268361,16,1949,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2091238.33,'DJ IIBB',NULL,1,'2025-03-28 13:44:36','2025-03-28 13:44:36',NULL),(1950,7941,40912,268362,16,1950,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2164073.17,'DJ IIBB',NULL,1,'2025-03-28 13:49:12','2025-03-28 13:49:12',NULL),(1951,7941,40912,268363,16,1951,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2105147.83,'DJ IIBB',NULL,1,'2025-03-28 13:53:16','2025-03-28 13:53:16',NULL),(1952,7941,40912,268364,16,1952,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1902267.51,'DJ IIBB',NULL,1,'2025-03-28 13:56:03','2025-03-28 13:56:03',NULL),(1953,7941,40912,268365,16,1953,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',1744413.46,'DJ IIBB',NULL,1,'2025-03-28 13:58:24','2025-03-28 13:58:24',NULL),(1954,7941,40912,268366,16,1954,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1558574.11,'DJ IIBB',NULL,1,'2025-03-28 14:00:49','2025-03-28 14:00:49',NULL),(1955,7941,40912,268367,16,1955,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1378324.49,'DJ IIBB',NULL,1,'2025-03-28 14:03:04','2025-03-28 14:03:04',NULL),(1956,7941,40912,268368,16,1956,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',1315506.15,'DJ IIBB',NULL,1,'2025-03-28 14:05:06','2025-03-28 14:05:06',NULL),(1957,7941,40912,268369,16,1957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1204926.20,'DJ IIBB',NULL,1,'2025-03-28 14:08:10','2025-03-28 14:08:10',NULL),(1958,7941,40912,268369,15,1958,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2123974.08,'DJ IVA',NULL,1,'2025-03-28 15:53:08','2025-03-28 15:53:08',NULL),(1959,7941,40771,77301,12,1959,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',249527197.00,'saldos iniciales',NULL,1,'2025-04-01 11:26:21','2025-04-22 09:38:36','2025-04-22 09:38:36'),(1960,7941,40735,24267,5,1960,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4040586.51,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 11:37:36','2025-04-01 11:37:36',NULL);
INSERT INTO `balance_libro` VALUES (1961,7941,40735,24268,5,1961,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',9589678.64,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 11:57:48','2025-04-01 11:57:48',NULL),(1962,7941,40915,272949,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',100.00,NULL,NULL,1,'2025-04-01 14:08:52','2025-04-01 14:08:52',NULL),(1963,7941,40915,272950,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',100.00,NULL,NULL,1,'2025-04-01 14:20:11','2025-04-01 14:20:11',NULL),(1964,7941,40915,272950,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',100.00,NULL,NULL,1,'2025-04-01 15:19:41','2025-04-01 15:19:41',NULL),(1965,7941,40915,272950,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',100.00,NULL,NULL,1,'2025-04-01 15:22:35','2025-04-01 15:22:35',NULL),(1966,7941,40735,24269,5,1966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',10670492.00,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 15:24:34','2025-04-01 15:24:34',NULL),(1967,7941,40735,24270,5,1967,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',19885228.97,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 15:31:07','2025-04-01 15:31:07',NULL),(1968,7941,40735,24271,5,1968,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',7677673.69,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 15:39:15','2025-04-01 15:39:15',NULL),(1969,7941,40735,24272,5,1969,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',7930882.63,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 15:46:59','2025-04-01 15:46:59',NULL),(1970,7941,40915,272950,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',100.00,NULL,NULL,1,'2025-04-01 15:48:33','2025-04-01 15:48:33',NULL),(1971,7941,40735,24273,5,1971,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6300000.00,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 15:53:59','2025-04-01 15:53:59',NULL),(1972,7941,40735,24274,5,1972,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',4080834.82,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 16:00:12','2025-04-01 16:00:12',NULL),(1973,7941,40735,24275,5,1973,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6363226.20,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 16:06:36','2025-04-01 16:06:36',NULL),(1974,7941,40735,24276,5,1974,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',8571800.55,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 16:13:27','2025-04-01 16:13:27',NULL),(1975,7941,40735,24277,5,1975,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',9354396.55,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 16:22:49','2025-04-01 16:22:49',NULL),(1976,7941,40735,24278,5,1976,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',26415650.00,'BANCO BBVA 2712-6',NULL,1,'2025-04-01 16:29:40','2025-04-01 16:29:40',NULL),(1977,7941,40871,206088,5,1977,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',727434.00,'Mercado Pago',NULL,1,'2025-04-02 09:20:11','2025-04-02 09:20:11',NULL),(1978,7941,40871,206089,5,1978,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2141047.00,'Mercado Pago',NULL,1,'2025-04-02 09:23:28','2025-04-02 09:23:28',NULL),(1979,7941,40871,206090,5,1979,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',2044914.00,'Mercado Pago',NULL,1,'2025-04-02 09:27:49','2025-04-02 09:27:49',NULL);
INSERT INTO `balance_libro` VALUES (1980,7941,40871,206091,5,1980,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',2469454.29,'Mercado Pago',NULL,1,'2025-04-02 09:30:26','2025-04-02 09:30:26',NULL),(1981,7941,40871,206092,5,1981,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4592274.76,'Mercado Pago',NULL,1,'2025-04-02 09:32:52','2025-04-02 09:32:52',NULL),(1982,7941,40871,206080,5,1982,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3278095.19,'BANCO SANTANDER 041-77663/9',NULL,1,'2025-04-02 09:35:23','2025-04-02 09:35:23',NULL),(1983,7941,40871,206093,5,1983,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',3584148.38,'Mercado Pago',NULL,1,'2025-04-02 09:38:13','2025-04-02 09:38:13',NULL),(1984,7941,40871,206094,5,1984,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',3549801.44,'Mercado Pago',NULL,1,'2025-04-02 09:44:55','2025-04-02 09:44:55',NULL),(1985,7941,40913,269888,3,1985,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',146157985.04,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 12:49:14','2025-04-03 13:18:16','2025-04-03 13:18:16'),(1986,7941,40913,269888,3,1986,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',146157985.04,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 13:18:16','2025-04-03 13:18:16',NULL),(1987,7941,40913,269889,3,1987,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',7548256.17,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 14:44:11','2025-04-03 15:12:31','2025-04-03 15:12:31'),(1988,7941,40913,269889,3,1988,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',7548256.17,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 15:12:31','2025-04-03 15:12:31',NULL),(1989,7941,40913,269903,12,1989,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',611344565.86,'saldos iniciales',NULL,1,'2025-04-03 15:19:39','2025-04-09 09:35:37','2025-04-09 09:35:37'),(1990,7941,40735,24269,5,1990,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1530234.78,'Prestamo Cuenta 27126',NULL,1,'2025-04-03 15:21:15','2025-04-04 20:24:30','2025-04-04 20:24:30'),(1991,7941,40913,269890,3,1991,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',7869121.80,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 15:24:46','2025-04-03 15:24:46',NULL),(1992,7941,40735,24270,5,1992,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',194462.56,'Cuota 1 de 12',NULL,1,'2025-04-03 15:28:16','2025-04-04 20:22:54','2025-04-04 20:22:54'),(1993,7941,40735,24271,5,1993,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',181807.88,'cuota 2 de 12',NULL,1,'2025-04-03 15:32:12','2025-04-03 15:32:12',NULL),(1994,7941,40735,24272,5,1994,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',175466.45,'Cuota 3 de 12',NULL,1,'2025-04-03 15:34:10','2025-04-03 15:34:10',NULL),(1995,7941,40735,24273,5,1995,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',172916.42,'Cuota 4 de 12',NULL,1,'2025-04-03 15:36:51','2025-04-03 15:36:51',NULL),(1996,7941,40735,24274,5,1996,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',168245.42,'Cuota 5 de 12',NULL,1,'2025-04-03 15:38:52','2025-04-03 15:38:52',NULL),(1997,7941,40913,269891,3,1997,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',12359835.53,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 16:22:47','2025-04-03 16:22:47',NULL);
INSERT INTO `balance_libro` VALUES (1998,7941,40735,24275,5,1998,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',163318.18,'Cuota 6 de 12',NULL,1,'2025-04-03 16:25:05','2025-04-03 16:25:05',NULL),(1999,7941,40735,24276,5,1999,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',158144.04,'Cuota 7 de 12',NULL,1,'2025-04-03 16:26:43','2025-04-03 16:26:43',NULL),(2000,7941,40735,24277,5,2000,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',152840.56,'Cuota 8 de 12',NULL,1,'2025-04-03 16:28:45','2025-04-03 16:28:45',NULL),(2001,7941,40735,24278,5,2001,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',147243.62,'Cuota 9 de 12',NULL,1,'2025-04-03 16:30:25','2025-04-03 16:30:25',NULL),(2002,7941,40913,269892,3,2002,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',14388407.43,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 16:36:24','2025-04-03 16:36:24',NULL),(2003,7941,40913,269892,3,2003,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',14388407.43,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 16:36:24','2025-04-03 16:37:32','2025-04-03 16:37:32'),(2004,7941,40913,269893,3,2004,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',16294816.12,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 16:58:41','2025-04-03 16:58:41',NULL),(2005,7941,40913,269894,3,2005,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',9617492.32,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 17:15:38','2025-04-03 17:15:38',NULL),(2006,7941,40913,269895,3,2006,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',39458286.47,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 17:28:23','2025-04-03 17:28:23',NULL),(2007,7941,40913,269896,3,2007,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',49033132.13,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 17:47:59','2025-04-03 17:47:59',NULL),(2008,7941,40913,269897,3,2008,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',21637172.32,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 19:28:47','2025-04-03 19:28:47',NULL),(2009,7941,40913,269898,3,2009,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',12111374617.87,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 19:50:58','2025-04-08 13:02:42','2025-04-08 13:02:42'),(2010,7941,40913,269899,3,2010,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',182455530.18,'SUBDIARIO COMPRAS',NULL,1,'2025-04-03 20:12:04','2025-04-03 20:12:04',NULL),(2011,7941,40735,24252,12,2011,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',35618298.03,'asiento de inicio de jercicio',NULL,1,'2025-04-04 13:13:11','2025-04-04 13:13:11',NULL),(2012,7941,40735,24267,12,2012,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',118520778.93,'ASIENTO DE INICIO',NULL,1,'2025-04-04 13:26:08','2025-04-04 13:26:08',NULL),(2013,7941,40913,269888,5,2013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',99822592.94,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:06:35','2025-04-04 15:06:35',NULL),(2014,7941,40913,269889,5,2014,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',107722673.20,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:12:00','2025-04-04 15:12:00',NULL),(2015,7941,40913,269890,5,2015,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',173944001.18,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:27:20','2025-04-04 15:27:20',NULL);
INSERT INTO `balance_libro` VALUES (2016,7941,40913,269891,5,2016,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',76932023.55,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:31:57','2025-04-04 15:31:57',NULL),(2017,7941,40913,269892,5,2017,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',84884000.87,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:37:56','2025-04-04 15:37:56',NULL),(2018,7941,40913,269893,5,2018,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',183315631.80,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:43:58','2025-04-04 15:43:58',NULL),(2019,7941,40913,269894,5,2019,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',109636177.10,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:49:25','2025-04-04 15:49:25',NULL),(2020,7941,40913,269895,5,2020,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',120700629.36,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:54:20','2025-04-04 15:54:20',NULL),(2021,7941,40913,269896,5,2021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',153128169.39,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 15:59:49','2025-04-04 15:59:49',NULL),(2022,7941,40913,269897,5,2022,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',150484286.22,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 16:04:02','2025-04-04 16:04:02',NULL),(2023,7941,40913,269898,5,2023,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',199991657.60,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 16:13:56','2025-04-04 16:13:56',NULL),(2024,7941,40913,269899,5,2024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',439017263.20,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-04 16:19:42','2025-04-09 09:38:18','2025-04-09 09:38:18'),(2025,7941,40913,269888,5,2025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',1259505.29,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-04 16:42:50','2025-04-04 16:42:50',NULL),(2026,7941,40913,269890,5,2026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1081932.88,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-04 16:44:04','2025-04-04 16:44:04',NULL),(2027,7941,40913,269891,5,2027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1267689.99,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-04 16:45:10','2025-04-04 16:45:10',NULL),(2028,7941,40913,269892,5,2028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1108820.23,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-04 16:46:32','2025-04-04 16:46:32',NULL),(2029,7941,40913,269894,5,2029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1808191.91,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-04 16:47:32','2025-04-10 11:38:22','2025-04-10 11:38:22'),(2030,7941,40914,271418,15,2030,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',83668.63,'DJ IVA',NULL,1,'2025-04-04 16:58:54','2025-04-04 16:58:54',NULL),(2031,7941,40914,271419,15,2031,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',89526.93,'DJ IVA',NULL,1,'2025-04-04 17:04:55','2025-04-04 17:04:55',NULL),(2032,7941,40914,271420,15,2032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',170708.03,'DJ IVA',NULL,1,'2025-04-04 17:11:50','2025-04-04 17:11:50',NULL),(2033,7941,40914,271421,15,2033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',7178.03,'DJ IVA',NULL,1,'2025-04-04 17:13:49','2025-04-04 17:13:49',NULL);
INSERT INTO `balance_libro` VALUES (2034,7941,40914,271422,15,2034,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',173442.53,'DJ IVA',NULL,1,'2025-04-04 17:19:38','2025-04-04 17:19:38',NULL),(2035,7941,40914,271423,15,2035,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',185610.73,'DJ IVA',NULL,1,'2025-04-04 17:24:33','2025-04-04 17:24:33',NULL),(2036,7941,40914,271424,15,2036,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',192243.26,'DJ IVA',NULL,1,'2025-04-04 17:28:05','2025-04-04 17:28:05',NULL),(2037,7941,40914,271425,15,2037,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',191041.89,'DJ IVA',NULL,1,'2025-04-04 17:32:16','2025-04-04 17:32:16',NULL),(2038,7941,40914,271426,15,2038,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',14829.19,'DJ IVA',NULL,1,'2025-04-04 17:35:14','2025-04-04 17:35:14',NULL),(2039,7941,40914,271427,15,2039,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',21896.39,'DJ IVA',NULL,1,'2025-04-04 17:39:29','2025-04-04 17:39:29',NULL),(2040,7941,40914,271428,15,2040,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',137396.39,'DJ IVA',NULL,1,'2025-04-04 17:44:59','2025-04-04 17:44:59',NULL),(2041,7941,40914,271429,15,2041,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',113015.07,'DJ IVA',NULL,1,'2025-04-04 17:50:36','2025-04-04 17:50:36',NULL),(2042,7941,40914,271420,2,2042,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',943800.00,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:01:53','2025-04-04 18:01:53',NULL),(2043,7941,40914,271420,2,2043,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',943800.00,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:01:53','2025-04-04 18:02:13','2025-04-04 18:02:13'),(2044,7941,40914,271422,2,2044,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',919600.00,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:05:04','2025-04-04 18:05:04',NULL),(2045,7941,40914,271423,2,2045,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',1011560.00,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:07:40','2025-04-04 18:07:40',NULL),(2046,7941,40914,271424,2,2046,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1057540.00,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:11:16','2025-04-04 18:11:16',NULL),(2047,7941,40914,271425,2,2047,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',1057540.00,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:13:24','2025-04-04 18:13:24',NULL),(2048,7941,40914,271428,2,2048,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',632830.00,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:17:09','2025-04-04 18:17:09',NULL),(2049,7941,40914,271428,2,2049,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',632830.00,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:17:09','2025-04-04 18:17:28','2025-04-04 18:17:28'),(2050,7941,40914,271429,2,2050,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',651182.07,'SUBDIARIO VENTAS',NULL,1,'2025-04-04 18:20:28','2025-04-04 18:20:28',NULL),(2051,7941,40735,24270,5,2051,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',59639.77,'Cuota 1 de 12',NULL,1,'2025-04-04 20:22:54','2025-04-04 20:22:54',NULL),(2052,7941,40735,24269,5,2052,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',390234.78,'Prestamo Cuenta 27126',NULL,1,'2025-04-04 20:24:30','2025-04-04 20:24:30',NULL);
INSERT INTO `balance_libro` VALUES (2053,7941,40914,271418,16,2053,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1072.00,'DJ IIBB',NULL,1,'2025-04-07 09:37:09','2025-04-07 09:37:09',NULL),(2054,7941,40914,271419,16,2054,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',1192.00,'DJ IIBB',NULL,1,'2025-04-07 10:40:46','2025-04-07 10:40:46',NULL),(2055,7941,40735,24273,3,2055,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2398515.01,'SUBDIARIO COMPRAS',NULL,1,'2025-04-07 17:16:11','2025-04-07 17:16:11',NULL),(2056,7941,40914,271420,16,2056,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',15600.00,'DJ IIBB',NULL,1,'2025-04-07 17:36:11','2025-04-07 17:36:11',NULL),(2057,7941,40914,271421,16,2057,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',180.00,'DJ IIBB',NULL,1,'2025-04-07 17:39:30','2025-04-07 17:39:30',NULL),(2058,7941,40914,271422,16,2058,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',15200.00,'DJ IIBB',NULL,1,'2025-04-07 17:48:35','2025-04-07 17:48:35',NULL),(2059,7941,40914,271423,16,2059,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',16720.00,'DJ IIBB',NULL,1,'2025-04-07 17:52:00','2025-04-07 17:52:00',NULL),(2060,7941,40913,269888,6,2060,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',5432507.92,'DJ IIGG',NULL,1,'2025-04-08 10:59:49','2025-04-15 15:49:03','2025-04-15 15:49:03'),(2061,7941,40914,271423,16,2061,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',16720.00,'DJ IIBB',NULL,1,'2025-04-08 11:04:07','2025-04-08 12:59:29','2025-04-08 12:59:29'),(2062,7941,40913,269888,3,2062,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1.00,NULL,NULL,1,'2025-04-08 11:26:38','2025-04-08 11:27:11','2025-04-08 11:27:11'),(2063,7941,40914,271424,16,2063,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',17480.00,'DJ IIBB',NULL,1,'2025-04-08 11:41:43','2025-04-08 11:41:43',NULL),(2064,7941,40914,271425,16,2064,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',17480.00,'DJ IIBB',NULL,1,'2025-04-08 11:46:26','2025-04-08 11:46:26',NULL),(2065,7941,40913,269898,3,2065,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',183655188.81,'SUBDIARIO COMPRAS',NULL,1,'2025-04-08 13:02:42','2025-04-08 13:02:42',NULL),(2066,7941,40914,271426,16,2066,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',33732.00,'DJ IIBB',NULL,1,'2025-04-08 13:07:01','2025-04-08 13:07:01',NULL),(2067,7941,40914,271427,16,2067,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',34532.00,'DJ IIBB',NULL,1,'2025-04-08 13:09:51','2025-04-08 13:09:51',NULL),(2068,7941,40914,271428,16,2068,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',36187.00,'DJ IIBB',NULL,1,'2025-04-08 13:15:04','2025-04-08 13:15:04',NULL),(2069,7941,40914,271429,16,2069,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',26127.00,'DJ IIBB',NULL,1,'2025-04-08 13:19:17','2025-04-08 13:19:17',NULL),(2070,7941,40913,269888,12,2070,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',611344565.86,'saldos iniciales',NULL,1,'2025-04-09 09:35:37','2025-04-09 09:35:37',NULL),(2071,7941,40913,269899,5,2071,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',439017263.20,'BANCO CREDICOOP 041-77663 9',NULL,1,'2025-04-09 09:38:18','2025-04-09 09:38:18',NULL);
INSERT INTO `balance_libro` VALUES (2072,7941,40914,271418,3,2072,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',5418.00,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 12:36:18','2025-04-09 12:36:18',NULL),(2073,7941,40914,271420,3,2073,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',473443.50,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 12:39:21','2025-04-09 12:39:21',NULL),(2074,7941,40914,271421,3,2074,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',35000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 12:41:09','2025-04-09 12:41:09',NULL),(2076,7941,40914,271423,3,2076,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',994850.00,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 12:56:55','2025-04-09 12:56:55',NULL),(2077,7941,40914,271424,3,2077,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1053332.93,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 13:10:53','2025-04-09 13:10:53',NULL),(2078,7941,40914,271425,3,2078,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',1053332.93,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 13:16:05','2025-04-09 13:16:05',NULL),(2079,7941,40914,271426,3,2079,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',80000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 13:17:17','2025-04-09 13:17:17',NULL),(2080,7941,40914,271427,3,2080,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',80000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 13:18:40','2025-04-09 13:18:40',NULL),(2081,7941,40914,271428,3,2081,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',745500.00,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 13:23:14','2025-04-09 13:23:14',NULL),(2082,7941,40914,271429,3,2082,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',90000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 13:24:01','2025-04-09 13:24:01',NULL),(2083,7941,40914,271422,3,2083,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1254906.50,'SUBDIARIO COMPRAS',NULL,1,'2025-04-09 14:27:19','2025-04-09 14:27:19',NULL),(2084,11429,40877,215234,12,2084,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',159108402.28,'saldos iniciales',NULL,1,'2025-04-09 15:00:21','2025-05-06 09:54:33','2025-05-06 09:54:33'),(2085,7941,40914,271418,5,2085,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',5450.51,'BANCO CREDICOOP',NULL,1,'2025-04-10 10:02:22','2025-04-10 10:12:01','2025-04-10 10:12:01'),(2086,7941,40914,271418,5,2086,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',5450.51,'BANCO CREDICOOP',NULL,1,'2025-04-10 10:12:01','2025-04-10 10:12:01',NULL),(2087,7941,40914,271419,5,2087,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',7605.36,'BANCO CREDICOOP',NULL,1,'2025-04-10 10:36:57','2025-04-10 10:36:57',NULL),(2088,7941,40914,271420,5,2088,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',7605.84,'BANCO CREDICOOP',NULL,1,'2025-04-10 10:47:43','2025-04-10 10:58:37','2025-04-10 10:58:37'),(2089,7941,40914,271420,5,2089,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',7685.64,'BANCO CREDICOOP',NULL,1,'2025-04-10 10:58:37','2025-04-10 10:58:37',NULL),(2090,7941,40914,271421,5,2090,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',12174.26,'BANCO CREDICOOP',NULL,1,'2025-04-10 11:10:22','2025-04-10 11:10:22',NULL);
INSERT INTO `balance_libro` VALUES (2091,7941,40914,271422,5,2091,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',200000.00,'BANCO CREDICOOP',NULL,1,'2025-04-10 11:23:59','2025-04-10 11:23:59',NULL),(2092,7941,40913,269894,5,2092,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1108191.91,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-10 11:38:22','2025-04-10 11:38:22',NULL),(2093,7941,40914,271423,5,2093,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',1043800.00,'BANCO CREDICOOP',NULL,1,'2025-04-10 11:43:30','2025-04-10 11:43:30',NULL),(2094,7941,40913,269895,5,2094,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',5112891.24,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-10 11:44:35','2025-04-10 12:01:38','2025-04-10 12:01:38'),(2095,7941,40913,269896,5,2095,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',2213216.05,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-10 11:46:49','2025-04-10 11:46:49',NULL),(2096,7941,40913,269897,5,2096,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1344765.00,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-10 11:48:17','2025-04-10 11:48:17',NULL),(2097,7941,40913,269898,5,2097,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',5036088.84,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-10 11:50:15','2025-04-10 11:50:15',NULL),(2098,7941,40914,271424,5,2098,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',185764.43,'BANCO CREDICOOP',NULL,1,'2025-04-10 11:50:52','2025-04-10 11:50:52',NULL),(2099,7941,40913,269899,5,2099,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4527000.00,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-10 11:51:31','2025-04-10 11:51:31',NULL),(2100,7941,40913,269895,5,2100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',10142891.24,'BANCO PATAGONIA 107014153',NULL,1,'2025-04-10 12:01:38','2025-04-10 12:01:38',NULL),(2101,7941,40914,271425,5,2101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',385332.17,'BANCO CREDICOOP',NULL,1,'2025-04-10 12:06:42','2025-04-10 12:06:42',NULL),(2102,7941,40914,271426,5,2102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1684559.54,'BANCO CREDICOOP',NULL,1,'2025-04-10 12:15:19','2025-04-10 12:15:19',NULL),(2103,7941,40914,271427,5,2103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',40000.00,'BANCO CREDICOOP',NULL,1,'2025-04-10 12:24:30','2025-04-10 12:24:30',NULL),(2104,7941,40914,271428,5,2104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',2634137.74,'BANCO CREDICOOP',NULL,1,'2025-04-10 12:48:05','2025-04-10 12:48:05',NULL),(2105,7941,40914,271429,5,2105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',25799.18,'BANCO CREDICOOP',NULL,1,'2025-04-10 12:53:22','2025-04-10 12:53:22',NULL),(2106,7941,40912,268358,5,2106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',26566936.88,'Banco Patagonia',NULL,1,'2025-04-11 11:10:37','2025-04-11 11:12:54','2025-04-11 11:12:54'),(2107,7941,40912,268358,5,2107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',26566936.88,'Banco Patagonia',NULL,1,'2025-04-11 11:12:54','2025-04-11 11:12:54',NULL),(2108,7941,40912,268359,5,2108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',9145324.20,'Banco Patagonia',NULL,1,'2025-04-11 11:26:17','2025-04-11 11:26:17',NULL);
INSERT INTO `balance_libro` VALUES (2109,7941,40912,268360,5,2109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',12771195.59,'Banco Patagonia',NULL,1,'2025-04-11 11:39:15','2025-04-11 11:39:15',NULL),(2110,7941,40912,268361,5,2110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',17516431.26,'Banco Patagonia',NULL,1,'2025-04-11 11:59:38','2025-04-11 11:59:38',NULL),(2111,7941,40912,268362,5,2111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',29662695.32,'Banco Patagonia',NULL,1,'2025-04-11 12:07:10','2025-04-11 12:07:10',NULL),(2112,7941,40912,268363,5,2112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',19734512.49,'Banco Patagonia',NULL,1,'2025-04-11 12:17:50','2025-04-11 12:17:50',NULL),(2113,7941,40912,268364,5,2113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',26852623.43,'Banco Patagonia',NULL,1,'2025-04-11 12:27:54','2025-04-11 12:27:54',NULL),(2114,7941,40912,268365,5,2114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',27669124.97,'Banco Patagonia',NULL,1,'2025-04-11 12:38:58','2025-04-11 12:38:58',NULL),(2115,7941,40912,268366,5,2115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20950132.63,'Banco Patagonia',NULL,1,'2025-04-11 12:47:41','2025-04-11 12:47:41',NULL),(2116,7941,40912,268367,5,2116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',17139998.15,'Banco Patagonia',NULL,1,'2025-04-11 12:55:25','2025-04-11 12:55:25',NULL),(2117,7941,40912,268368,5,2117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',24169590.33,'Banco Patagonia',NULL,1,'2025-04-11 13:05:02','2025-04-11 13:05:02',NULL),(2118,7941,40912,268369,5,2118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',15006678.10,'Banco Patagonia',NULL,1,'2025-04-11 13:14:34','2025-04-11 13:14:34',NULL),(2119,7941,40912,268362,5,2119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',400000.00,'Banco Patagonia subcuenta',NULL,1,'2025-04-11 13:18:55','2025-04-11 13:18:55',NULL),(2120,7941,40912,268363,5,2120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',79896.26,'Banco Patagonia  subcuenta',NULL,1,'2025-04-11 13:20:56','2025-04-11 13:20:56',NULL),(2121,7941,40912,268358,1,2121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2392043.42,'SUELDOS',NULL,1,'2025-04-11 14:09:09','2025-04-11 14:09:09',NULL),(2122,7941,40912,268359,1,2122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',2630701.55,'SUELDOS',NULL,1,'2025-04-11 14:16:45','2025-04-11 14:16:45',NULL),(2123,7941,40912,268360,1,2123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2785167.94,'SUELDOS',NULL,1,'2025-04-11 14:34:58','2025-04-11 14:34:58',NULL),(2124,7941,40912,268361,1,2124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3114280.10,'SUELDOS',NULL,1,'2025-04-11 14:43:47','2025-04-11 14:43:47',NULL),(2125,7941,40912,268362,1,2125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3151661.53,'SUELDOS',NULL,1,'2025-04-11 15:01:08','2025-04-11 15:01:08',NULL),(2126,7941,40912,268363,1,2126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',4877325.21,'SUELDOS',NULL,1,'2025-04-11 15:11:19','2025-04-11 15:11:19',NULL),(2127,7941,40912,268364,1,2127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3342036.83,'SUELDOS',NULL,1,'2025-04-11 15:15:59','2025-04-11 15:15:59',NULL);
INSERT INTO `balance_libro` VALUES (2128,7941,40912,268365,1,2128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3422236.02,'SUELDOS',NULL,1,'2025-04-11 15:20:17','2025-04-11 15:20:17',NULL),(2129,7941,40912,268366,1,2129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3715788.98,'SUELDOS',NULL,1,'2025-04-11 15:24:08','2025-04-11 15:24:08',NULL),(2130,7941,40912,268367,1,2130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',3970605.50,'SUELDOS',NULL,1,'2025-04-11 15:28:41','2025-04-11 15:28:41',NULL),(2131,7941,40912,268368,1,2131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',4320242.60,'SUELDOS',NULL,1,'2025-04-11 15:33:07','2025-04-11 15:33:07',NULL),(2132,7941,40912,268369,1,2132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',6586689.92,'SUELDOS',NULL,1,'2025-04-11 15:37:49','2025-04-11 15:37:49',NULL),(2133,7941,40877,215234,3,2133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',97344974.04,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 13:28:03','2025-04-14 13:36:15','2025-04-14 13:36:15'),(2134,7941,40877,215234,3,2134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',97362632.98,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 13:36:15','2025-04-14 13:36:15',NULL),(2135,7941,40877,215235,3,2135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',92867599.67,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 13:47:37','2025-04-14 13:47:37',NULL),(2136,7941,40877,215236,3,2136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',116307494.75,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 14:08:01','2025-04-14 14:08:01',NULL),(2137,7941,40877,215237,3,2137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',62040753.02,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 20:40:19','2025-04-14 20:40:19',NULL),(2138,7941,40877,215238,3,2138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',107780458.46,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 20:46:55','2025-04-14 20:46:55',NULL),(2139,7941,40877,215239,3,2139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',49696576.84,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 20:55:36','2025-04-14 20:55:36',NULL),(2140,7941,40877,215240,3,2140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',94912906.55,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 21:00:55','2025-04-14 21:00:55',NULL),(2141,7941,40877,215241,3,2141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',92933356.22,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 21:06:06','2025-04-14 21:06:06',NULL),(2142,7941,40877,215242,3,2142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',92778271.64,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 21:12:17','2025-04-14 21:12:17',NULL),(2143,7941,40877,215243,3,2143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',79778195.07,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 21:18:36','2025-04-14 21:18:36',NULL),(2144,7941,40877,215244,3,2144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',74908591.04,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 21:27:34','2025-04-14 21:31:42','2025-04-14 21:31:42'),(2145,7941,40877,215244,3,2145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',74993810.63,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 21:31:42','2025-04-14 21:31:42',NULL);
INSERT INTO `balance_libro` VALUES (2146,7941,40877,215245,3,2146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',54139924.52,'SUBDIARIO COMPRAS',NULL,1,'2025-04-14 21:37:00','2025-04-14 21:37:00',NULL),(2147,7941,40914,271418,12,2147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',261733080.72,'SALDOS INICIALES',NULL,1,'2025-04-15 09:29:56','2025-04-15 09:31:30','2025-04-15 09:31:30'),(2148,7941,40914,271418,12,2148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',261733080.72,'SALDOS INICIALES',NULL,1,'2025-04-15 09:31:30','2025-04-15 09:31:30',NULL),(2149,7941,40877,215234,5,2149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',9932.83,'BANCO CREDICOOP',NULL,1,'2025-04-15 14:19:33','2025-04-15 14:51:38','2025-04-15 14:51:38'),(2150,7941,40877,215234,5,2150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',10000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 14:51:38','2025-04-15 14:56:12','2025-04-15 14:56:12'),(2151,7941,40877,215234,5,2151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',10000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 14:56:12','2025-04-15 15:24:40','2025-04-15 15:24:40'),(2152,11429,40877,215235,5,2152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',10025.80,'BANCO CREDICOOP',NULL,1,'2025-04-15 15:16:24','2025-04-29 13:13:41','2025-04-29 13:13:41'),(2153,7941,40877,215236,5,2153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',11226.84,'BANCO CREDICOOP',NULL,1,'2025-04-15 15:21:59','2025-04-15 15:21:59',NULL),(2154,7941,40877,215234,5,2154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',10000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 15:24:40','2025-04-15 15:24:40',NULL),(2155,7941,40913,269888,5,2155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',85692.22,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:28:27','2025-04-15 15:28:27',NULL),(2156,7941,40877,215237,5,2156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',14769.89,'BANCO CREDICOOP',NULL,1,'2025-04-15 15:30:16','2025-04-15 15:30:16',NULL),(2157,7941,40913,269889,5,2157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',85692.22,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:31:21','2025-04-15 15:31:21',NULL),(2158,7941,40913,269890,5,2158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',208639.18,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:33:22','2025-04-15 15:33:22',NULL),(2159,7941,40913,269891,5,2159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:36:04','2025-04-15 15:36:04',NULL),(2160,7941,40877,215238,5,2160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',20000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 15:36:09','2025-04-15 15:36:09',NULL),(2161,7941,40913,269892,5,2161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:37:56','2025-04-15 15:37:56',NULL),(2162,7941,40913,269893,5,2162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:41:36','2025-04-15 15:41:36',NULL),(2163,7941,40877,215239,5,2163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',19863.52,'BANCO CREDICOOP',NULL,1,'2025-04-15 15:41:56','2025-04-15 15:41:56',NULL);
INSERT INTO `balance_libro` VALUES (2164,7941,40913,269894,5,2164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:43:45','2025-04-15 15:43:45',NULL),(2165,7941,40913,269895,5,2165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:45:37','2025-04-15 15:45:37',NULL),(2166,7941,40877,215240,5,2166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',40000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 15:46:20','2025-04-15 15:46:20',NULL),(2167,7941,40913,269896,5,2167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:47:54','2025-04-15 15:47:54',NULL),(2168,7941,40913,269888,6,2168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',5432507.92,'DJ IIGG',NULL,1,'2025-04-15 15:49:03','2025-04-15 15:49:03',NULL),(2169,7941,40913,269897,5,2169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:52:06','2025-04-15 15:52:06',NULL),(2170,7941,40913,269898,5,2170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:54:07','2025-04-15 15:54:07',NULL),(2171,7941,40877,215241,5,2171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',20000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 15:54:32','2025-04-15 15:54:32',NULL),(2172,7941,40913,269899,5,2172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',209740.78,'BANCO PROVINCIA',NULL,1,'2025-04-15 15:56:41','2025-04-15 15:56:41',NULL),(2173,7941,40877,215242,5,2173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',26320.91,'BANCO CREDICOOP',NULL,1,'2025-04-15 16:00:56','2025-04-15 16:00:56',NULL),(2174,7941,40877,215243,5,2174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',680000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 16:12:25','2025-04-15 16:15:14','2025-04-15 16:15:14'),(2175,11429,40877,215243,5,2175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',680000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 16:15:14','2025-05-06 10:35:05','2025-05-06 10:35:05'),(2176,11429,40877,215244,5,2176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',700000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 16:20:35','2025-05-06 11:58:54','2025-05-06 11:58:54'),(2177,7941,40877,215245,5,2177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1006000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 16:31:01','2025-04-15 16:35:19','2025-04-15 16:35:19'),(2178,11429,40877,215245,5,2178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1006000.00,'BANCO CREDICOOP',NULL,1,'2025-04-15 16:35:19','2025-05-06 12:00:11','2025-05-06 12:00:11'),(2179,7941,40771,77312,5,2179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',177256.48,'Prestamo Banco Santander',NULL,1,'2025-04-15 17:04:16','2025-04-15 17:04:16',NULL),(2180,7941,40872,207613,1,2180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',458217.36,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:31:06','2025-04-15 17:31:06',NULL),(2181,7941,40872,207614,1,2181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',534634.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:32:31','2025-04-15 17:32:31',NULL);
INSERT INTO `balance_libro` VALUES (2182,7941,40872,207615,1,2182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',534634.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:34:20','2025-04-15 17:34:20',NULL),(2183,7941,40872,207616,1,2183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',534634.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:36:04','2025-04-15 17:36:04',NULL),(2184,7941,40872,207617,1,2184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',534634.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:37:44','2025-04-15 17:37:44',NULL),(2185,7941,40872,207618,1,2185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',801623.14,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:39:20','2025-04-15 17:39:20',NULL),(2186,7941,40872,207619,1,2186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',534634.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:41:05','2025-04-15 17:41:05',NULL),(2187,7941,40872,207620,1,2187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',535081.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:43:30','2025-04-15 17:43:30',NULL),(2188,7941,40872,207621,1,2188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',535142.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:44:59','2025-04-15 17:44:59',NULL),(2189,7941,40872,207622,1,2189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',535179.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:46:25','2025-04-15 17:46:25',NULL),(2190,7941,40872,207623,1,2190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',535222.39,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:47:54','2025-04-15 17:47:54',NULL),(2191,7941,40872,207624,1,2191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',802282.14,'Sueldos y Cargas Sociales',NULL,1,'2025-04-15 17:49:12','2025-04-15 17:49:12',NULL),(2192,7941,40771,77301,5,2192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',8425435.58,'BANCO SANTANDER',NULL,1,'2025-04-16 16:11:49','2025-04-16 16:11:49',NULL),(2193,7941,40771,77302,5,2193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',8625808.30,'BANCO SANTANDER',NULL,1,'2025-04-16 16:22:31','2025-04-16 16:22:31',NULL),(2194,7941,40771,77303,5,2194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',5297128.76,'BANCO SANTANDER',NULL,1,'2025-04-16 16:31:46','2025-04-16 16:31:46',NULL),(2195,7941,40771,77304,5,2195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',6046457.82,'BANCO SANTANDER',NULL,1,'2025-04-16 16:45:06','2025-04-16 16:45:06',NULL),(2196,7941,40771,77305,5,2196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',10682178.05,'BANCO SANTANDER',NULL,1,'2025-04-16 16:50:27','2025-04-16 16:50:27',NULL),(2197,7941,40771,77306,5,2197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',12431928.11,'BANCO SANTANDER',NULL,1,'2025-04-16 16:58:03','2025-04-16 16:58:03',NULL),(2198,7941,40771,77307,5,2198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',16953274.13,'BANCO SANTANDER',NULL,1,'2025-04-16 17:04:45','2025-04-16 17:04:45',NULL),(2199,7941,40771,77308,5,2199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',13435195.36,'BANCO SANTANDER',NULL,1,'2025-04-16 17:13:32','2025-04-16 17:13:32',NULL);
INSERT INTO `balance_libro` VALUES (2200,7941,40771,77309,5,2200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',15367106.17,'BANCO SANTANDER',NULL,1,'2025-04-16 17:24:55','2025-04-16 17:24:55',NULL),(2201,7941,40771,77310,5,2201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',22265677.34,'BANCO SANTANDER',NULL,1,'2025-04-16 17:33:47','2025-04-16 17:33:47',NULL),(2202,7941,40771,77311,5,2202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',21319779.80,'BANCO SANTANDER',NULL,1,'2025-04-16 17:39:51','2025-04-16 17:39:51',NULL),(2203,7941,40771,77312,5,2203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',21625718.58,'BANCO SANTANDER',NULL,1,'2025-04-16 17:45:29','2025-04-16 17:45:29',NULL),(2204,7941,40771,77312,5,2204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',991102.08,'BANCO SANTANDER  U$S Nº 041-028388/9',NULL,1,'2025-04-16 17:51:30','2025-04-22 09:03:07','2025-04-22 09:03:07'),(2205,7941,40877,215234,5,2205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',6363636.48,'BANCO GALICIA',NULL,1,'2025-04-17 10:51:43','2025-04-17 12:46:51','2025-04-17 12:46:51'),(2206,11429,40877,215234,5,2206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',30776124.29,'BANCO PROVINCIA',NULL,1,'2025-04-17 11:13:22','2025-05-06 16:10:48','2025-05-06 16:10:48'),(2207,11429,40877,215235,5,2207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',34045906.83,'BANCO PROVINCIA',NULL,1,'2025-04-17 11:21:08','2025-05-06 16:13:11','2025-05-06 16:13:11'),(2208,7941,40877,215236,5,2208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',28760032.13,'BANCO GALICIA',NULL,1,'2025-04-17 11:31:45','2025-04-17 12:11:07','2025-04-17 12:11:07'),(2209,7941,40877,215237,5,2209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',11154276.86,'BANCO GALICIA',NULL,1,'2025-04-17 11:36:37','2025-04-17 12:11:52','2025-04-17 12:11:52'),(2210,7941,40877,215238,5,2210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',6423006.34,'BANCO GALICIA',NULL,1,'2025-04-17 11:43:04','2025-04-17 12:12:38','2025-04-17 12:12:38'),(2211,7941,40877,215239,5,2211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',11243623.25,'BANCO GALICIA',NULL,1,'2025-04-17 11:47:16','2025-04-17 12:13:00','2025-04-17 12:13:00'),(2212,7941,40877,215240,5,2212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',8340226.47,'BANCO GALICIA',NULL,1,'2025-04-17 11:51:50','2025-04-17 12:13:34','2025-04-17 12:13:34'),(2213,7941,40877,215241,5,2213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',4946535.11,'BANCO GALICIA',NULL,1,'2025-04-17 11:55:31','2025-04-17 12:14:16','2025-04-17 12:14:16'),(2214,7941,40877,215242,5,2214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20475843.20,'BANCO GALICIA',NULL,1,'2025-04-17 12:00:20','2025-04-17 12:14:42','2025-04-17 12:14:42'),(2215,7941,40877,215243,5,2215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',15321774.18,'BANCO GALICIA',NULL,1,'2025-04-17 12:06:00','2025-04-17 12:15:03','2025-04-17 12:15:03'),(2216,11429,40877,215236,5,2216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',28760032.13,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:11:07','2025-05-06 16:15:23','2025-05-06 16:15:23');
INSERT INTO `balance_libro` VALUES (2217,11429,40877,215237,5,2217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',11154276.86,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:11:52','2025-05-06 16:17:49','2025-05-06 16:17:49'),(2218,11429,40877,215238,5,2218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',6423006.34,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:12:38','2025-05-06 16:19:20','2025-05-06 16:19:20'),(2219,11429,40877,215239,5,2219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',11243623.25,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:13:00','2025-05-06 16:20:30','2025-05-06 16:20:30'),(2220,11429,40877,215240,5,2220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',8340226.47,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:13:34','2025-05-06 16:22:26','2025-05-06 16:22:26'),(2221,11429,40877,215241,5,2221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',4946535.11,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:14:16','2025-05-06 16:25:12','2025-05-06 16:25:12'),(2222,11429,40877,215242,5,2222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20475843.20,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:14:42','2025-05-06 16:32:54','2025-05-06 16:32:54'),(2223,11429,40877,215243,5,2223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',15321774.18,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:15:03','2025-05-06 16:34:36','2025-05-06 16:34:36'),(2224,7941,40877,215234,5,2224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',98391145.64,'BANCO SANTANDER',NULL,1,'2025-04-17 12:16:23','2025-04-17 12:23:22','2025-04-17 12:23:22'),(2225,11429,40877,215244,5,2225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',13384929.97,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:23:12','2025-05-06 16:36:33','2025-05-06 16:36:33'),(2226,7941,40877,215234,5,2226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',98391145.64,'BANCO SANTANDER',NULL,1,'2025-04-17 12:23:22','2025-04-17 12:45:23','2025-04-17 12:45:23'),(2227,11429,40877,215245,5,2227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',11400412.28,'BANCO PROVINCIA',NULL,1,'2025-04-17 12:29:13','2025-05-06 16:37:13','2025-05-06 16:37:13'),(2228,7941,40877,215235,5,2228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',85940725.51,'BANCO SANTANDER',NULL,1,'2025-04-17 12:43:46','2025-04-17 12:46:09','2025-04-17 12:46:09'),(2229,11429,40877,215234,5,2229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',98391145.64,'BANCO SANTANDER',NULL,1,'2025-04-17 12:45:23','2025-05-06 15:00:27','2025-05-06 15:00:27'),(2230,11429,40877,215235,5,2230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',85940725.51,'BANCO SANTANDER',NULL,1,'2025-04-17 12:46:09','2025-05-06 15:07:18','2025-05-06 15:07:18'),(2231,7941,40877,215234,5,2231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',6609298.38,'BANCO GALICIA',NULL,1,'2025-04-17 12:46:51','2025-04-17 12:46:51',NULL),(2232,7941,40877,215235,5,2232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',14187579.09,'BANCO GALICIA',NULL,1,'2025-04-17 12:54:15','2025-04-17 12:54:15',NULL),(2233,11429,40877,215236,5,2233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',88273461.00,'BANCO SANTANDER',NULL,1,'2025-04-17 12:55:03','2025-05-06 15:12:29','2025-05-06 15:12:29');
INSERT INTO `balance_libro` VALUES (2234,7941,40877,215236,5,2234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',5717261.95,'BANCO GALICIA',NULL,1,'2025-04-17 12:58:02','2025-04-17 12:58:02',NULL),(2235,7941,40877,215237,5,2235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',6519037.64,'BANCO GALICIA',NULL,1,'2025-04-17 13:03:19','2025-04-17 13:03:19',NULL),(2236,7941,40877,215238,5,2236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2072730.69,'BANCO GALICIA',NULL,1,'2025-04-17 13:06:00','2025-04-17 13:06:00',NULL),(2237,7941,40877,215237,5,2237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',97675937.82,'BANCO SANTANDER',NULL,1,'2025-04-17 13:24:34','2025-04-17 13:34:43','2025-04-17 13:34:43'),(2238,7941,40877,215238,5,2238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',108467986.05,'BANCO SANTANDER',NULL,1,'2025-04-17 13:30:51','2025-04-17 13:35:20','2025-04-17 13:35:20'),(2239,11429,40877,215237,5,2239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',97675937.82,'BANCO SANTANDER',NULL,1,'2025-04-17 13:34:43','2025-05-06 15:25:35','2025-05-06 15:25:35'),(2240,11429,40877,215238,5,2240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',108467986.05,'BANCO SANTANDER',NULL,1,'2025-04-17 13:35:20','2025-05-06 15:29:11','2025-05-06 15:29:11'),(2241,11429,40877,215239,5,2241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',72879855.57,'BANCO SANTANDER',NULL,1,'2025-04-17 13:42:40','2025-05-06 15:31:41','2025-05-06 15:31:41'),(2242,11429,40877,215239,5,2242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',8250619.38,'BANCO GALICIA',NULL,1,'2025-04-17 13:43:15','2025-05-07 15:14:02','2025-05-07 15:14:02'),(2243,11429,40877,215240,5,2243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',101097975.67,'BANCO SANTANDER',NULL,1,'2025-04-17 13:48:46','2025-05-06 15:35:36','2025-05-06 15:35:36'),(2244,7941,40877,215240,5,2244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',12430639.03,'BANCO GALICIA',NULL,1,'2025-04-17 13:49:03','2025-04-17 13:49:03',NULL),(2245,11429,40877,215241,5,2245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3186146.75,'BANCO GALICIA',NULL,1,'2025-04-17 13:54:43','2025-05-07 15:53:04','2025-05-07 15:53:04'),(2246,11429,40877,215242,5,2246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',22172200.35,'BANCO GALICIA',NULL,1,'2025-04-17 13:58:43','2025-05-05 15:31:29','2025-05-05 15:31:29'),(2247,7941,40877,215243,5,2247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',15396352.29,'BANCO GALICIA',NULL,1,'2025-04-17 14:02:27','2025-04-17 14:02:27',NULL),(2248,11429,40877,215244,5,2248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3188753.52,'BANCO GALICIA',NULL,1,'2025-04-17 14:07:10','2025-05-05 15:47:51','2025-05-05 15:47:51'),(2249,11429,40877,215241,5,2249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',111824455.60,'BANCO SANTANDER',NULL,1,'2025-04-17 14:13:29','2025-05-06 15:39:13','2025-05-06 15:39:13'),(2250,11429,40877,215242,5,2250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',123890303.10,'BANCO SANTANDER',NULL,1,'2025-04-17 14:21:49','2025-05-06 15:41:40','2025-05-06 15:41:40');
INSERT INTO `balance_libro` VALUES (2251,11429,40877,215243,5,2251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',129367455.74,'BANCO SANTANDER',NULL,1,'2025-04-17 14:27:35','2025-05-06 15:44:23','2025-05-06 15:44:23'),(2252,11429,40877,215244,5,2252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',71505445.04,'BANCO SANTANDER',NULL,1,'2025-04-17 14:33:04','2025-05-06 15:48:10','2025-05-06 15:48:10'),(2253,11429,40877,215245,5,2253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',119824630.93,'BANCO SANTANDER',NULL,1,'2025-04-17 14:41:06','2025-05-06 15:50:46','2025-05-06 15:50:46'),(2254,7941,40873,209154,12,2254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',100000.00,'ASIENTO DE INICIO',NULL,1,'2025-04-17 14:47:47','2025-04-17 14:47:47',NULL),(2255,7941,40873,209154,15,2255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',6852292.18,'DJ IVA',NULL,1,'2025-04-17 14:50:48','2025-04-17 14:50:48',NULL),(2256,7941,40873,209154,5,2256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',36085482.71,'MERCADO PAGO',NULL,1,'2025-04-17 14:57:15','2025-04-17 14:57:15',NULL),(2257,7941,40872,207614,2,2257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',2430975.69,'SUBDIARIO VENTAS',NULL,1,'2025-04-17 15:14:24','2025-04-17 15:14:24',NULL),(2258,7941,40872,207613,15,2258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',251523.10,'DJ IVA',NULL,1,'2025-04-17 15:19:06','2025-04-17 15:19:06',NULL),(2259,7941,40872,207614,15,2259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',423713.17,'DJ IVA',NULL,1,'2025-04-17 15:21:30','2025-04-17 15:21:30',NULL),(2260,7941,40877,215245,6,2260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',13945757.67,'DJ Ganancias',NULL,1,'2025-04-17 15:25:05','2025-04-17 15:25:05',NULL),(2261,7941,40877,215245,6,2261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1849549.41,'Compensacion Saldo de Libre disponibilidad',NULL,1,'2025-04-17 15:29:45','2025-04-17 15:29:45',NULL),(2262,7941,40877,215245,6,2262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5113553.93,'Compensacion anticipos 1-7',NULL,1,'2025-04-17 15:32:44','2025-04-17 15:32:44',NULL),(2263,7941,40877,215245,6,2263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',817330.26,'Compensacion anticipos 8-10 /2023',NULL,1,'2025-04-17 15:34:09','2025-04-17 15:34:09',NULL),(2264,7941,40872,207613,12,2264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4993217.00,'Asiento de inicio',NULL,1,'2025-04-17 17:14:13','2025-04-17 17:14:13',NULL),(2265,7941,40771,77304,15,2265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1410726.89,'DJ IVA',NULL,1,'2025-04-21 13:39:28','2025-04-21 13:39:28',NULL),(2266,7941,40771,77309,2,2266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',19211550.49,'SUBDIARIO VENTAS',NULL,1,'2025-04-21 15:29:10','2025-04-21 15:29:10',NULL),(2267,7941,40771,77312,5,2267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',991102.08,'BANCO SANTANDER  U$S Nº 041-028388/9',NULL,1,'2025-04-22 09:03:07','2025-04-22 09:34:54','2025-04-22 09:34:54'),(2268,7941,40771,77312,5,2268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',991102.08,'BANCO SANTANDER  U$S Nº 041-028388/9',NULL,1,'2025-04-22 09:34:54','2025-04-22 09:43:20','2025-04-22 09:43:20');
INSERT INTO `balance_libro` VALUES (2269,7941,40771,77301,12,2269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',249527197.00,'saldos iniciales',NULL,1,'2025-04-22 09:38:36','2025-04-22 09:54:37','2025-04-22 09:54:37'),(2270,7941,40771,77312,5,2270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1457407.48,'BANCO SANTANDER  U$S Nº 041-028388/9',NULL,1,'2025-04-22 09:43:20','2025-04-22 09:43:20',NULL),(2271,7941,40771,77301,12,2271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',249527197.00,'saldos iniciales',NULL,1,'2025-04-22 09:54:37','2025-04-25 15:05:44','2025-04-25 15:05:44'),(2272,7941,40872,207619,5,2272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',30000.00,'BANCO ICBC',NULL,1,'2025-04-22 13:54:14','2025-04-22 13:54:14',NULL),(2273,7941,40872,207620,5,2273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',20741.87,'BANCO ICBC',NULL,1,'2025-04-22 14:41:54','2025-04-22 14:41:54',NULL),(2274,7941,40872,207621,5,2274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20547.95,'BANCO ICBC',NULL,1,'2025-04-22 14:45:21','2025-04-22 14:45:21',NULL),(2275,7941,40872,207622,5,2275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',24000.00,'BANCO ICBC',NULL,1,'2025-04-22 14:50:04','2025-04-22 14:50:04',NULL),(2276,7941,40872,207623,5,2276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',40000.00,'BANCO ICBC',NULL,1,'2025-04-22 14:56:35','2025-04-22 14:56:35',NULL),(2277,7941,40872,207624,5,2277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',25936.56,'BANCO ICBC',NULL,1,'2025-04-22 15:01:16','2025-04-22 15:01:16',NULL),(2278,7941,40872,207613,5,2278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3418383.67,'BANCO SUPERVILLE',NULL,1,'2025-04-22 16:13:23','2025-04-22 16:15:49','2025-04-22 16:15:49'),(2279,7941,40872,207613,5,2279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3418383.67,'BANCO SUPERVILLE',NULL,1,'2025-04-22 16:15:49','2025-04-22 16:15:49',NULL),(2280,7941,40872,207614,5,2280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',2952049.15,'BANCO SUPERVILLE',NULL,1,'2025-04-22 16:45:46','2025-04-22 16:45:46',NULL),(2281,7941,40872,207615,5,2281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',3601936.00,'BANCO SUPERVILLE',NULL,1,'2025-04-22 17:06:13','2025-04-22 17:06:13',NULL),(2282,7941,40872,207616,5,2282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1058618.25,'BANCO SUPERVILLE',NULL,1,'2025-04-22 17:21:05','2025-04-22 17:21:05',NULL),(2283,11429,40872,207632,5,2283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3360047.18,'BANCO SUPERVILLE',NULL,1,'2025-04-22 17:43:06','2025-04-29 16:46:15','2025-04-29 16:46:15'),(2284,7941,40912,268358,12,2284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',43929255.12,'saldos iniciales',NULL,1,'2025-04-23 15:25:30','2025-04-23 15:25:30',NULL),(2285,7941,40872,207618,5,2285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',4152433.00,'BANCO SUPERVILLE',NULL,1,'2025-04-23 23:42:17','2025-04-23 23:42:17',NULL),(2286,7941,40872,207619,5,2286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3768392.50,'BANCO SUPERVILLE',NULL,1,'2025-04-23 23:55:27','2025-04-23 23:55:27',NULL);
INSERT INTO `balance_libro` VALUES (2287,7941,40872,207620,5,2287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',2640200.51,'BANCO SUPERVILLE',NULL,1,'2025-04-24 00:02:48','2025-04-24 00:02:48',NULL),(2288,7941,40872,207621,5,2288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6110391.37,'BANCO SUPERVILLE',NULL,1,'2025-04-24 00:10:00','2025-04-24 00:10:00',NULL),(2289,7941,40872,207622,5,2289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',3882560.82,'BANCO SUPERVILLE',NULL,1,'2025-04-24 00:14:39','2025-04-24 00:14:39',NULL),(2290,7941,40872,207623,5,2290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',2640050.00,'BANCO SUPERVILLE',NULL,1,'2025-04-24 00:19:03','2025-04-24 00:19:03',NULL),(2291,7941,40872,207624,5,2291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4481321.07,'BANCO SUPERVILLE',NULL,1,'2025-04-24 00:33:21','2025-04-24 00:33:21',NULL),(2292,7941,40872,207613,5,2292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2958.90,'Banco Comafi',NULL,1,'2025-04-24 09:26:50','2025-04-24 09:26:50',NULL),(2293,7941,40872,207614,5,2293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',17359.63,'Banco Comafi',NULL,1,'2025-04-24 09:30:38','2025-04-24 09:30:38',NULL),(2294,7941,40872,207615,5,2294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',41589.04,'Banco Comafi',NULL,1,'2025-04-24 09:36:06','2025-04-24 09:36:06',NULL),(2295,7941,40872,207616,5,2295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',23436.58,'Banco Comafi',NULL,1,'2025-04-24 09:38:48','2025-04-24 09:38:48',NULL),(2296,7941,40872,207617,5,2296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',9000.00,'Banco Comofi',NULL,1,'2025-04-24 09:41:44','2025-04-24 09:41:44',NULL),(2297,7941,40771,77301,12,2297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',249527197.00,'saldos iniciales',NULL,1,'2025-04-25 15:05:44','2025-04-25 15:05:44',NULL),(2298,7941,40915,272950,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',60000.00,NULL,NULL,1,'2025-04-28 09:34:22','2025-04-28 09:34:22',NULL),(2299,7941,40915,272950,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',900000.00,NULL,NULL,1,'2025-04-28 09:34:23','2025-04-28 09:34:23',NULL),(2300,7941,40915,272950,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',820000.00,NULL,NULL,1,'2025-04-28 09:34:25','2025-04-28 09:34:25',NULL),(2301,7941,40915,272950,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',90000.00,NULL,NULL,1,'2025-04-28 09:34:26','2025-04-28 09:34:26',NULL),(2302,7941,40915,272950,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',155000.00,NULL,NULL,1,'2025-04-28 09:34:27','2025-04-28 09:34:27',NULL),(2303,7941,40915,272950,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',310000.00,NULL,NULL,1,'2025-04-28 09:34:28','2025-04-28 09:34:28',NULL),(2304,7941,40915,272950,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',100.00,NULL,NULL,1,'2025-04-28 09:53:34','2025-04-28 09:53:34',NULL),(2305,7941,40915,272950,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',160000.00,NULL,NULL,1,'2025-04-28 10:39:11','2025-04-28 10:39:11',NULL),(2306,7941,40915,272950,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',35000.00,NULL,NULL,1,'2025-04-28 10:39:13','2025-04-28 10:39:13',NULL);
INSERT INTO `balance_libro` VALUES (2307,7941,40915,272950,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',160000.00,NULL,NULL,1,'2025-04-28 10:41:12','2025-04-28 10:41:12',NULL),(2308,7941,40915,272950,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',35000.00,NULL,NULL,1,'2025-04-28 10:41:14','2025-04-28 10:41:14',NULL),(2309,7941,40915,272950,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',160000.00,NULL,NULL,1,'2025-04-28 10:42:30','2025-04-28 10:42:30',NULL),(2310,7941,40915,272950,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',35000.00,NULL,NULL,1,'2025-04-28 10:42:31','2025-04-28 10:42:31',NULL),(2311,7941,40915,272950,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',160000.00,NULL,NULL,1,'2025-04-28 10:44:27','2025-04-28 10:44:27',NULL),(2312,7941,40915,272950,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',35000.00,NULL,NULL,1,'2025-04-28 10:44:29','2025-04-28 10:44:29',NULL),(2313,7941,40915,272950,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',35000.00,NULL,NULL,1,'2025-04-28 11:02:52','2025-04-28 11:02:52',NULL),(2314,7941,40915,272950,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',35000.00,NULL,NULL,1,'2025-04-28 11:04:25','2025-04-28 11:04:25',NULL),(2315,7941,40915,272950,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',35000.00,NULL,NULL,1,'2025-04-28 11:06:36','2025-04-28 11:06:36',NULL),(2316,7941,40915,272950,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',160000.00,NULL,NULL,1,'2025-04-28 11:08:23','2025-04-28 11:08:23',NULL),(2317,7941,40915,272950,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',160000.00,NULL,NULL,1,'2025-04-28 11:09:12','2025-04-28 11:09:12',NULL),(2318,7941,40915,272950,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',160000.00,NULL,NULL,1,'2025-04-28 11:10:03','2025-04-28 11:10:03',NULL),(2319,7941,40915,272950,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',600.00,NULL,NULL,1,'2025-04-28 11:11:08','2025-04-28 11:11:08',NULL),(2320,7941,40915,272950,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',165000.00,NULL,NULL,1,'2025-04-28 12:06:10','2025-04-28 12:06:10',NULL),(2321,7941,40915,272950,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',460000.00,NULL,NULL,1,'2025-04-28 12:06:11','2025-04-28 12:06:11',NULL),(2322,7941,40915,272950,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',190000.00,NULL,NULL,1,'2025-04-28 12:06:12','2025-04-28 12:06:12',NULL),(2323,7941,40719,51,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',260000.00,NULL,NULL,1,'2025-04-28 15:34:16','2025-04-28 15:34:16',NULL),(2324,7941,40719,51,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',175000.00,NULL,NULL,1,'2025-04-28 15:34:17','2025-04-28 15:34:17',NULL),(2325,7941,40719,51,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',175000.00,NULL,NULL,1,'2025-04-28 15:34:18','2025-04-28 15:34:18',NULL),(2326,7941,40719,51,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',100000.00,NULL,NULL,1,'2025-04-28 15:34:19','2025-04-28 15:34:19',NULL),(2327,7941,40719,51,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',200000.00,NULL,NULL,1,'2025-04-28 15:34:20','2025-04-28 15:34:20',NULL);
INSERT INTO `balance_libro` VALUES (2328,7941,40719,51,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',510000.00,NULL,NULL,1,'2025-04-28 15:34:22','2025-04-28 15:34:22',NULL),(2329,7941,40719,51,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',120000.00,NULL,NULL,1,'2025-04-28 15:34:22','2025-04-28 15:34:22',NULL),(2330,7941,40719,51,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',550000.00,NULL,NULL,1,'2025-04-28 15:34:23','2025-04-28 15:34:23',NULL),(2331,7941,40719,51,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-29','2025-04-29',150000.00,NULL,NULL,1,'2025-04-29 11:22:14','2025-04-29 11:22:14',NULL),(2332,7941,40719,51,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-29','2025-04-29',250000.00,NULL,NULL,1,'2025-04-29 11:22:34','2025-04-29 11:22:34',NULL),(2333,7941,40719,51,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-29','2025-04-29',155000.00,NULL,NULL,1,'2025-04-29 11:22:53','2025-04-29 11:22:53',NULL),(2334,7941,40719,51,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-29','2025-04-29',770000.00,NULL,NULL,1,'2025-04-29 11:23:01','2025-04-29 11:23:01',NULL),(2335,7941,40719,51,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-29','2025-04-29',620000.00,NULL,NULL,1,'2025-04-29 11:23:03','2025-04-29 11:23:03',NULL),(2336,11429,40877,215235,5,2336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',10000.00,'BANCO CREDICOOP',NULL,1,'2025-04-29 13:13:41','2025-04-29 13:13:41',NULL),(2337,11429,40872,207617,5,2337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3360047.18,'BANCO SUPERVILLE',NULL,1,'2025-04-29 16:46:15','2025-04-29 16:46:15',NULL),(2338,11429,40873,209151,5,2338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',15749852.50,'BANCO CREDICOOP',NULL,1,'2025-04-30 16:48:42','2025-04-30 16:48:42',NULL),(2339,11429,40873,209145,3,2339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',200000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-05-02 10:00:54','2025-05-02 10:00:54',NULL),(2340,11429,40873,209146,3,2340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1000000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-05-02 10:11:27','2025-05-02 10:11:27',NULL),(2341,11429,40873,209154,3,2341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',28169636.21,'SUBDIARIO COMPRAS',NULL,1,'2025-05-02 10:49:54','2025-05-02 10:49:54',NULL),(2342,11429,40877,215236,2,2342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',99710015.44,'SUBDIARIO VENTAS',NULL,1,'2025-05-05 15:25:15','2025-05-05 15:25:15',NULL),(2343,11429,40877,215237,2,2343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',84743359.01,'SUBDIARIO VENTAS',NULL,1,'2025-05-05 15:26:38','2025-05-05 15:26:38',NULL),(2344,11429,40877,215242,5,2344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',22472200.35,'BANCO GALICIA',NULL,1,'2025-05-05 15:31:29','2025-05-05 15:31:29',NULL),(2345,11429,40877,215236,15,2345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',20139356.94,'DJ IVA',NULL,1,'2025-05-05 15:36:13','2025-05-05 15:39:57','2025-05-05 15:39:57'),(2346,11429,40877,215236,15,2346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',20139352.61,'DJ IVA',NULL,1,'2025-05-05 15:39:57','2025-05-05 17:14:56','2025-05-05 17:14:56');
INSERT INTO `balance_libro` VALUES (2347,11429,40877,215244,5,2347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3522479.04,'BANCO GALICIA',NULL,1,'2025-05-05 15:47:51','2025-05-05 15:47:51',NULL),(2348,11429,40877,215234,15,2348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',16819398.91,'DJ IVA',NULL,1,'2025-05-05 17:13:50','2025-05-05 17:13:50',NULL),(2349,11429,40877,215236,15,2349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',20139352.61,'DJ IVA',NULL,1,'2025-05-05 17:14:56','2025-05-05 17:14:56',NULL),(2350,11429,40877,215238,15,2350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',18678421.42,'DJ IVA',NULL,1,'2025-05-05 17:16:01','2025-05-05 17:16:01',NULL),(2351,11429,40877,215234,12,2351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',159108402.28,'saldos iniciales',NULL,1,'2025-05-06 09:54:33','2025-05-06 09:54:33',NULL),(2352,11429,40877,215243,5,2352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',680000.00,'BANCO CREDICOOP',NULL,1,'2025-05-06 10:35:05','2025-05-06 11:54:47','2025-05-06 11:54:47'),(2353,11429,40877,215243,5,2353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',680000.00,'BANCO CREDICOOP',NULL,1,'2025-05-06 11:54:47','2025-05-06 11:54:47',NULL),(2354,11429,40877,215244,5,2354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',700000.00,'BANCO CREDICOOP',NULL,1,'2025-05-06 11:58:54','2025-05-06 11:58:54',NULL),(2355,11429,40877,215245,5,2355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1006000.00,'BANCO CREDICOOP',NULL,1,'2025-05-06 12:00:11','2025-05-06 12:00:11',NULL),(2356,11429,40912,268363,3,2356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',5058783.38,'SUBDIARIO COMPRAS',NULL,1,'2025-05-06 12:01:47','2025-05-06 12:01:47',NULL),(2357,11429,40877,215234,5,2357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',98391145.64,'BANCO SANTANDER',NULL,1,'2025-05-06 15:00:27','2025-05-06 15:00:27',NULL),(2358,11429,40877,215235,5,2358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',99944194.98,'BANCO SANTANDER',NULL,1,'2025-05-06 15:07:18','2025-05-06 15:07:18',NULL),(2359,11429,40877,215236,5,2359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',88273461.00,'BANCO SANTANDER',NULL,1,'2025-05-06 15:12:29','2025-05-06 15:51:35','2025-05-06 15:51:35'),(2360,11429,40877,215237,5,2360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',97676310.74,'BANCO SANTANDER',NULL,1,'2025-05-06 15:25:35','2025-05-06 15:52:34','2025-05-06 15:52:34'),(2361,11429,40877,215238,5,2361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',108467986.05,'BANCO SANTANDER',NULL,1,'2025-05-06 15:29:11','2025-05-06 15:53:22','2025-05-06 15:53:22'),(2362,11429,40877,215239,5,2362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',72879855.57,'BANCO SANTANDER',NULL,1,'2025-05-06 15:31:41','2025-05-06 15:54:13','2025-05-06 15:54:13'),(2363,11429,40877,215240,5,2363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',101097975.67,'BANCO SANTANDER',NULL,1,'2025-05-06 15:35:36','2025-05-06 15:54:57','2025-05-06 15:54:57'),(2364,11429,40877,215241,5,2364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',111824455.60,'BANCO SANTANDER',NULL,1,'2025-05-06 15:39:13','2025-05-06 15:55:46','2025-05-06 15:55:46');
INSERT INTO `balance_libro` VALUES (2365,11429,40877,215242,5,2365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',123890303.10,'BANCO SANTANDER',NULL,1,'2025-05-06 15:41:40','2025-05-06 15:56:40','2025-05-06 15:56:40'),(2366,11429,40877,215243,5,2366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',129367455.74,'BANCO SANTANDER',NULL,1,'2025-05-06 15:44:23','2025-05-06 15:57:31','2025-05-06 15:57:31'),(2367,11429,40877,215244,5,2367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',71505445.04,'BANCO SANTANDER',NULL,1,'2025-05-06 15:48:10','2025-05-06 15:48:10',NULL),(2368,11429,40877,215245,5,2368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',119824630.93,'BANCO SANTANDER',NULL,1,'2025-05-06 15:50:46','2025-05-06 15:50:46',NULL),(2369,11429,40877,215236,5,2369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',88273461.00,'BANCO SANTANDER',NULL,1,'2025-05-06 15:51:35','2025-05-06 15:51:35',NULL),(2370,11429,40877,215237,5,2370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',97676310.74,'BANCO SANTANDER',NULL,1,'2025-05-06 15:52:34','2025-05-06 15:52:34',NULL),(2371,11429,40877,215238,5,2371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',108467986.05,'BANCO SANTANDER',NULL,1,'2025-05-06 15:53:22','2025-05-06 15:53:22',NULL),(2372,11429,40877,215239,5,2372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',72879855.57,'BANCO SANTANDER',NULL,1,'2025-05-06 15:54:13','2025-05-06 15:54:13',NULL),(2373,11429,40877,215240,5,2373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',101097975.67,'BANCO SANTANDER',NULL,1,'2025-05-06 15:54:57','2025-05-06 15:54:57',NULL),(2374,11429,40877,215241,5,2374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',111824455.60,'BANCO SANTANDER',NULL,1,'2025-05-06 15:55:46','2025-05-06 15:55:46',NULL),(2375,11429,40877,215242,5,2375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',123890303.10,'BANCO SANTANDER',NULL,1,'2025-05-06 15:56:40','2025-05-06 15:56:40',NULL),(2376,11429,40877,215243,5,2376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',129367455.74,'BANCO SANTANDER',NULL,1,'2025-05-06 15:57:31','2025-05-06 15:57:31',NULL),(2377,11429,40877,215234,5,2377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',30776124.29,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:10:48','2025-05-06 16:10:48',NULL),(2378,11429,40877,215235,5,2378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',34045906.83,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:13:11','2025-05-06 16:13:11',NULL),(2379,11429,40877,215236,5,2379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',28760032.13,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:15:23','2025-05-06 16:15:23',NULL),(2380,11429,40877,215237,5,2380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',11154276.86,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:17:49','2025-05-06 16:17:49',NULL),(2381,11429,40877,215238,5,2381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',6423006.34,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:19:20','2025-05-06 16:19:20',NULL),(2382,11429,40877,215239,5,2382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',11243623.25,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:20:30','2025-05-06 16:20:30',NULL);
INSERT INTO `balance_libro` VALUES (2383,11429,40877,215240,5,2383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',8340226.47,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:22:26','2025-05-06 16:22:26',NULL),(2384,11429,40877,215241,5,2384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',4946535.11,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:25:12','2025-05-06 16:25:12',NULL),(2385,11429,40877,215245,15,2385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',13833220.96,'DJ IVA',NULL,1,'2025-05-06 16:28:57','2025-05-06 16:28:57',NULL),(2386,11429,40877,215242,5,2386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',20475843.20,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:32:54','2025-05-06 16:32:54',NULL),(2387,11429,40877,215243,5,2387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',15321774.18,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:34:36','2025-05-06 16:34:36',NULL),(2388,11429,40877,215244,5,2388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',13384929.97,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:36:33','2025-05-06 16:36:33',NULL),(2389,11429,40877,215245,5,2389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',11400412.28,'BANCO PROVINCIA',NULL,1,'2025-05-06 16:37:13','2025-05-06 16:37:13',NULL),(2390,11429,40877,215235,15,2390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',21915678.88,'DJ IVA',NULL,1,'2025-05-07 13:34:42','2025-05-07 13:34:42',NULL),(2391,11429,40877,215239,5,2391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',8250619.38,'BANCO GALICIA',NULL,1,'2025-05-07 15:14:02','2025-05-07 15:44:55','2025-05-07 15:44:55'),(2392,11429,40877,215239,5,2392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',8250619.38,'BANCO GALICIA',NULL,1,'2025-05-07 15:44:55','2025-05-07 16:03:59','2025-05-07 16:03:59'),(2393,11429,40877,215241,5,2393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',3186146.75,'BANCO GALICIA',NULL,1,'2025-05-07 15:53:04','2025-05-07 15:53:04',NULL),(2394,11429,40877,215239,5,2394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',8250619.38,'BANCO GALICIA',NULL,1,'2025-05-07 16:03:59','2025-05-07 16:03:59',NULL),(2395,7941,40915,272951,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',70000.00,NULL,NULL,1,'2025-05-29 13:54:52','2025-05-29 13:54:52',NULL),(2396,7941,40915,272951,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',900000.00,NULL,NULL,1,'2025-05-29 14:05:05','2025-05-29 14:05:05',NULL),(2397,7941,40915,272951,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',820000.00,NULL,NULL,1,'2025-05-29 14:05:06','2025-05-29 14:05:06',NULL),(2398,7941,40915,272951,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',90000.00,NULL,NULL,1,'2025-05-29 14:07:44','2025-05-29 14:07:44',NULL),(2399,7941,40915,272951,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',170000.00,NULL,NULL,1,'2025-05-29 14:07:45','2025-05-29 14:07:45',NULL),(2400,7941,40915,272951,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',310000.00,NULL,NULL,1,'2025-05-29 14:07:46','2025-05-29 14:07:46',NULL),(2401,7941,40915,272951,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',160000.00,NULL,NULL,1,'2025-05-29 14:07:47','2025-05-29 14:07:47',NULL);
INSERT INTO `balance_libro` VALUES (2402,7941,40915,272951,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',35000.00,NULL,NULL,1,'2025-05-29 14:07:48','2025-05-29 14:07:48',NULL),(2403,7941,40915,272951,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',190000.00,NULL,NULL,1,'2025-05-29 14:07:49','2025-05-29 14:07:49',NULL),(2404,7941,40915,272951,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',460000.00,NULL,NULL,1,'2025-05-29 14:07:50','2025-05-29 14:07:50',NULL),(2405,7941,40915,272951,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',190000.00,NULL,NULL,1,'2025-05-29 14:07:51','2025-05-29 14:07:51',NULL),(2406,7941,40915,272951,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',130000.00,NULL,NULL,1,'2025-05-29 14:07:52','2025-05-29 14:07:52',NULL),(2407,7941,40915,272951,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',130000.00,NULL,NULL,1,'2025-05-29 14:07:53','2025-05-29 14:07:53',NULL),(2408,NULL,40719,52,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',260000.00,NULL,NULL,1,'2025-05-30 14:49:38','2025-05-30 14:49:38',NULL),(2409,NULL,40719,52,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',175000.00,NULL,NULL,1,'2025-05-30 14:49:39','2025-05-30 14:49:39',NULL),(2410,NULL,40719,52,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',175000.00,NULL,NULL,1,'2025-05-30 14:49:40','2025-05-30 14:49:40',NULL),(2411,NULL,40719,52,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',100000.00,NULL,NULL,1,'2025-05-30 14:49:41','2025-05-30 14:49:41',NULL),(2412,NULL,40719,52,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',220000.00,NULL,NULL,1,'2025-05-30 14:49:42','2025-05-30 14:49:42',NULL),(2413,NULL,40719,52,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',560000.00,NULL,NULL,1,'2025-05-30 14:49:43','2025-05-30 14:49:43',NULL),(2414,NULL,40719,52,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',200000.00,NULL,NULL,1,'2025-05-30 14:49:44','2025-05-30 14:49:44',NULL),(2415,NULL,40719,52,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',590000.00,NULL,NULL,1,'2025-05-30 14:49:45','2025-05-30 14:49:45',NULL),(2416,NULL,40719,52,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',250000.00,NULL,NULL,1,'2025-05-30 14:49:46','2025-05-30 14:49:46',NULL),(2417,NULL,40719,52,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',210000.00,NULL,NULL,1,'2025-05-30 14:49:47','2025-05-30 14:49:47',NULL),(2418,NULL,40719,52,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',770000.00,NULL,NULL,1,'2025-05-30 14:49:48','2025-05-30 14:49:48',NULL),(2419,NULL,40719,52,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',620000.00,NULL,NULL,1,'2025-05-30 14:49:49','2025-05-30 14:49:49',NULL),(2420,NULL,40719,52,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',470000.00,NULL,NULL,1,'2025-05-30 14:49:50','2025-05-30 14:49:50',NULL),(2421,NULL,40719,52,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',110000.00,NULL,NULL,1,'2025-05-30 14:49:51','2025-05-30 14:49:51',NULL),(2422,7941,40719,52,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',260000.00,NULL,NULL,1,'2025-05-30 14:50:19','2025-05-30 14:50:19',NULL);
INSERT INTO `balance_libro` VALUES (2423,7941,40719,52,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',175000.00,NULL,NULL,1,'2025-05-30 14:50:20','2025-05-30 14:50:20',NULL),(2424,7941,40719,52,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',175000.00,NULL,NULL,1,'2025-05-30 14:50:21','2025-05-30 14:50:21',NULL),(2425,7941,40719,52,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',100000.00,NULL,NULL,1,'2025-05-30 14:50:22','2025-05-30 14:50:22',NULL),(2426,7941,40719,52,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',260000.00,NULL,NULL,1,'2025-05-30 15:50:41','2025-05-30 15:50:41',NULL),(2427,7941,40719,52,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',175000.00,NULL,NULL,1,'2025-05-30 15:52:06','2025-05-30 15:52:06',NULL),(2428,7941,40719,52,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',175000.00,NULL,NULL,1,'2025-05-30 15:53:22','2025-05-30 15:53:22',NULL),(2429,7941,40719,52,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',100000.00,NULL,NULL,1,'2025-05-30 15:55:07','2025-05-30 15:55:07',NULL),(2430,11429,40874,210676,2,2430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',343752222.80,'VENTAS',NULL,1,'2025-06-10 12:30:29','2025-06-10 12:30:29',NULL),(2431,11429,40874,210677,2,2431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',350513096.53,'VENTAS',NULL,1,'2025-06-10 12:32:58','2025-06-10 12:32:58',NULL),(2432,11429,40874,210678,2,2432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',355778882.73,'VENTAS',NULL,1,'2025-06-10 12:34:21','2025-06-10 12:34:21',NULL),(2433,11429,40874,210679,2,2433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',425343217.63,'VENTAS',NULL,1,'2025-06-10 12:39:23','2025-06-10 12:39:23',NULL),(2434,11429,40874,210680,2,2434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',405957782.62,'VENTAS',NULL,1,'2025-06-10 12:41:40','2025-06-10 12:41:40',NULL),(2435,11429,40874,210681,2,2435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',454674923.89,'VENTAS',NULL,1,'2025-06-10 12:43:32','2025-06-10 12:43:32',NULL),(2436,11429,40874,210682,2,2436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',465690766.94,'VENTAS',NULL,1,'2025-06-10 12:45:23','2025-06-10 12:45:23',NULL),(2437,11429,40874,210683,2,2437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',528386452.59,'VENTAS',NULL,1,'2025-06-10 12:47:21','2025-06-10 12:47:21',NULL),(2438,11429,40874,210684,2,2438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',531682052.46,'VENTAS',NULL,1,'2025-06-10 12:48:47','2025-06-10 12:48:47',NULL),(2439,11429,40874,210688,2,2439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',518010843.79,'VENTAS',NULL,1,'2025-06-10 12:52:50','2025-06-10 12:52:50',NULL),(2440,11429,40874,210689,2,2440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',559192577.43,'VENTAS',NULL,1,'2025-06-10 12:57:47','2025-06-10 12:57:47',NULL),(2441,11429,40874,210690,2,2441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',498277645.01,'VENTAS',NULL,1,'2025-06-10 12:59:45','2025-06-10 12:59:45',NULL),(2442,11429,40874,210676,15,2442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',55150895.82,'DJ IVA',NULL,1,'2025-06-10 14:18:21','2025-06-10 14:18:21',NULL);
INSERT INTO `balance_libro` VALUES (2443,11429,40874,210692,15,2443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',59658412.02,'DJ IVA',NULL,1,'2025-06-10 14:22:40','2025-06-10 14:36:22','2025-06-10 14:36:22'),(2444,11429,40874,210678,15,2444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',60065764.29,'DJ IVA',NULL,1,'2025-06-10 14:24:55','2025-06-10 14:24:55',NULL),(2445,11429,40874,210679,15,2445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',70162055.46,'DJ IVA',NULL,1,'2025-06-10 14:26:42','2025-06-10 14:26:42',NULL),(2446,11429,40874,210680,15,2446,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',69972449.05,'DJ IVA',NULL,1,'2025-06-10 14:31:50','2025-06-10 14:35:53','2025-06-10 14:35:53'),(2447,11429,40874,210680,15,2447,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',69972449.05,'DJ IVA',NULL,1,'2025-06-10 14:35:53','2025-06-10 14:35:53',NULL),(2448,11429,40874,210692,15,2448,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',59658412.02,'DJ IVA',NULL,1,'2025-06-10 14:36:22','2025-06-10 14:37:02','2025-06-10 14:37:02'),(2449,11429,40874,210677,15,2449,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',59658412.02,'DJ IVA',NULL,1,'2025-06-10 14:37:02','2025-06-10 14:37:02',NULL),(2450,11429,40874,210681,15,2450,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',75919809.22,'DJ IVA',NULL,1,'2025-06-10 14:42:34','2025-06-10 14:42:34',NULL),(2451,11429,40874,210682,15,2451,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',78111490.13,'DJ IVA',NULL,1,'2025-06-10 14:47:04','2025-06-10 14:47:04',NULL),(2452,11429,40874,210683,15,2452,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',84724918.84,'DJ IVA',NULL,1,'2025-06-10 14:50:35','2025-06-10 14:50:35',NULL),(2453,11429,40874,210684,15,2453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',90282331.13,'DJ IVA',NULL,1,'2025-06-10 14:52:11','2025-06-10 14:52:11',NULL),(2454,11429,40874,210688,15,2454,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',88907133.60,'DJ IVA',NULL,1,'2025-06-10 15:00:10','2025-06-10 15:00:10',NULL),(2455,11429,40874,210689,15,2455,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',93029086.57,'DJ IVA',NULL,1,'2025-06-10 15:03:25','2025-06-10 15:03:25',NULL),(2456,11429,40874,210690,15,2456,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',85872645.58,'DJ IVA',NULL,1,'2025-06-10 15:05:10','2025-06-10 15:05:10',NULL),(2457,11429,40874,210676,16,2457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',15570265.23,'DJ IIBB',NULL,1,'2025-06-10 15:19:46','2025-06-10 15:19:46',NULL),(2458,11429,40874,210677,16,2458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',15999850.70,'DJ IIBB',NULL,1,'2025-06-10 15:22:51','2025-06-10 15:22:51',NULL),(2459,11429,40874,210678,16,2459,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',17228225.08,'DJ IIBB',NULL,1,'2025-06-10 15:31:41','2025-06-10 15:31:41',NULL),(2460,11429,40874,210679,16,2460,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',19429954.68,'DJ IIBB',NULL,1,'2025-06-10 15:35:43','2025-06-10 16:16:22','2025-06-10 16:16:22'),(2461,11429,40874,210680,16,2461,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',18642855.92,'DJ IIBB',NULL,1,'2025-06-10 15:39:02','2025-06-10 15:39:02',NULL);
INSERT INTO `balance_libro` VALUES (2462,11429,40874,210681,16,2462,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',21226591.48,'DJ IIBB',NULL,1,'2025-06-10 15:42:50','2025-06-10 15:42:50',NULL),(2463,11429,40874,210682,16,2463,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',23626806.58,'DJ IIBB',NULL,1,'2025-06-10 15:45:27','2025-06-10 15:45:27',NULL),(2464,11429,40874,210683,16,2464,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',24883924.69,'DJ IIBB',NULL,1,'2025-06-10 15:50:09','2025-06-10 15:50:09',NULL),(2465,11429,40874,210684,16,2465,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',24882868.29,'DJ IIBB',NULL,1,'2025-06-10 15:53:50','2025-06-10 15:53:50',NULL),(2466,11429,40874,210688,16,2466,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',25086392.64,'DJ IIBB',NULL,1,'2025-06-10 15:59:59','2025-06-10 15:59:59',NULL),(2467,11429,40874,210689,16,2467,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',28377303.63,'DJ IIBB',NULL,1,'2025-06-10 16:03:35','2025-06-10 16:03:35',NULL),(2468,11429,40874,210690,16,2468,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',24026467.39,'DJ IIBB',NULL,1,'2025-06-10 16:06:40','2025-06-10 16:06:40',NULL),(2469,11429,40874,210679,16,2469,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',19429954.68,'DJ IIBB',NULL,1,'2025-06-10 16:16:22','2025-06-10 16:16:22',NULL),(2470,11429,40874,210676,1,2470,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',68221729.68,'Sueldos y cargas sociales',NULL,1,'2025-06-10 16:38:43','2025-06-10 16:38:43',NULL),(2471,11429,40874,210677,1,2471,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',73324732.65,'Sueldos y cargas sociales',NULL,1,'2025-06-11 10:35:42','2025-06-11 10:35:42',NULL),(2472,11429,40874,210678,1,2472,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',109757331.98,'Sueldos y cargas sociales',NULL,1,'2025-06-11 10:51:34','2025-06-11 11:38:36','2025-06-11 11:38:36'),(2473,11429,40874,210679,1,2473,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',88232328.91,'Sueldos y cargas sociales',NULL,1,'2025-06-11 10:54:56','2025-06-11 10:54:56',NULL),(2474,11429,40874,210680,1,2474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',86767224.80,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:04:49','2025-06-11 11:04:49',NULL),(2475,11429,40874,210681,1,2475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',99421087.62,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:07:39','2025-06-11 11:07:39',NULL),(2476,11429,40874,210682,1,2476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',102664381.53,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:10:47','2025-06-11 11:10:47',NULL),(2477,11429,40874,210683,1,2477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',106101778.49,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:15:42','2025-06-11 11:15:42',NULL),(2478,11429,40874,210684,1,2478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',172596152.21,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:20:27','2025-06-11 11:20:27',NULL),(2479,11429,40874,210688,1,2479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',135604887.13,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:22:14','2025-06-11 11:22:14',NULL);
INSERT INTO `balance_libro` VALUES (2480,11429,40874,210689,1,2480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',113626053.54,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:29:59','2025-06-11 11:29:59',NULL),(2481,11429,40874,210690,1,2481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',118995055.63,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:31:46','2025-06-11 11:31:46',NULL),(2482,11429,40874,210678,1,2482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',109757331.98,'Sueldos y cargas sociales',NULL,1,'2025-06-11 11:38:36','2025-06-11 11:38:36',NULL),(2483,11429,40876,213722,2,2483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1562000.00,'VENTAS',NULL,1,'2025-06-24 16:09:32','2025-06-24 16:09:32',NULL),(2484,11429,40876,213723,2,2484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1053910.00,'VENTAS',NULL,1,'2025-06-24 16:15:23','2025-06-24 16:15:23',NULL),(2485,11429,40876,213724,2,2485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',12241168.88,'VENTAS',NULL,1,'2025-06-24 16:16:28','2025-06-24 16:16:28',NULL),(2486,11429,40876,213725,2,2486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1600000.00,'VENTAS',NULL,1,'2025-06-24 16:20:18','2025-06-24 16:20:18',NULL),(2487,11429,40876,213726,2,2487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',12241168.88,'VENTAS',NULL,1,'2025-06-25 15:16:53','2025-06-25 15:24:21','2025-06-25 15:24:21'),(2488,11429,40876,213726,2,2488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',15394999.98,'VENTAS',NULL,1,'2025-06-25 15:24:21','2025-06-25 15:24:21',NULL),(2489,11429,40876,213727,2,2489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',7089420.02,'VENTAS',NULL,1,'2025-06-25 15:26:38','2025-06-25 15:26:38',NULL),(2490,11429,40876,213728,2,2490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4272999.99,'VENTAS',NULL,1,'2025-06-25 15:27:27','2025-06-25 15:27:27',NULL),(2491,11429,40876,213729,2,2491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',6080045.34,'VENTAS',NULL,1,'2025-06-25 15:28:26','2025-06-25 15:28:26',NULL),(2492,11429,40876,213730,2,2492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1400000.02,'VENTAS',NULL,1,'2025-06-25 15:29:24','2025-06-25 15:29:24',NULL),(2493,11429,40876,213734,2,2493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',890000.00,'VENTAS',NULL,1,'2025-06-25 15:55:34','2025-06-25 15:55:34',NULL),(2494,11429,40876,213735,2,2494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1101100.00,'VENTAS',NULL,1,'2025-06-25 15:56:30','2025-06-25 15:56:30',NULL),(2495,11429,40876,213736,2,2495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1101100.00,'VENTAS',NULL,1,'2025-06-25 15:57:27','2025-06-25 15:57:27',NULL),(2496,11429,40876,213722,15,2496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',271090.91,'DJ IVA',NULL,1,'2025-06-25 16:13:30','2025-06-25 16:13:30',NULL),(2497,11429,40876,213723,15,2497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',182910.00,'DJ IVA',NULL,1,'2025-06-25 16:15:38','2025-06-25 16:15:38',NULL),(2498,11429,40876,213724,15,2498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',208320.00,'DJ IVA',NULL,1,'2025-06-25 16:16:58','2025-06-25 16:16:58',NULL);
INSERT INTO `balance_libro` VALUES (2499,11429,40876,213725,15,2499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',277685.95,'DJ IVA',NULL,1,'2025-06-25 16:18:14','2025-06-25 16:18:14',NULL),(2500,11429,40876,213726,15,2500,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',2671859.50,'DJ IVA',NULL,1,'2025-06-25 16:20:10','2025-06-25 16:20:10',NULL),(2501,11429,40876,213727,15,2501,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1230395.21,'DJ IVA',NULL,1,'2025-06-25 16:21:44','2025-06-25 16:21:44',NULL),(2502,11429,40876,213728,15,2502,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',741595.04,'DJ IVA',NULL,1,'2025-06-25 17:53:49','2025-06-25 17:53:49',NULL),(2503,11429,40876,213729,15,2503,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1055214.48,'DJ IVA',NULL,1,'2025-06-25 17:55:12','2025-06-25 17:55:12',NULL),(2504,11429,40876,213730,15,2504,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',242975.21,'DJ IVA',NULL,1,'2025-06-25 17:56:44','2025-06-25 17:56:44',NULL),(2505,11429,40876,213734,15,2505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',154462.81,'DJ IVA',NULL,1,'2025-06-25 17:58:20','2025-06-25 17:58:20',NULL),(2506,11429,40876,213735,15,2506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',191100.00,'DJ IVA',NULL,1,'2025-06-25 17:59:17','2025-06-25 17:59:17',NULL),(2507,11429,40876,213736,15,2507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',191100.00,'DJ IVA',NULL,1,'2025-06-25 18:00:22','2025-06-25 18:00:22',NULL),(2508,11429,40876,213722,3,2508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',421127.77,'COMPRAS',NULL,1,'2025-06-26 11:58:21','2025-06-26 11:58:21',NULL),(2509,11429,40876,213723,3,2509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',493092.56,'COMPRAS',NULL,1,'2025-06-26 12:04:15','2025-06-26 12:04:15',NULL),(2510,11429,40876,213724,3,2510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',501378.56,'COMPRAS',NULL,1,'2025-06-26 12:07:52','2025-06-26 12:07:52',NULL),(2511,11429,40876,213725,3,2511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3518831.11,'COMPRAS',NULL,1,'2025-06-26 12:09:22','2025-06-26 12:09:22',NULL),(2512,11429,40876,213726,3,2512,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',8374759.02,'COMPRAS',NULL,1,'2025-06-26 12:10:59','2025-06-26 12:10:59',NULL),(2513,11429,40876,213727,3,2513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3409303.20,'COMPRAS',NULL,1,'2025-06-26 12:14:25','2025-06-26 12:14:25',NULL),(2514,11429,40876,213728,3,2514,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',3705849.94,'COMPRAS',NULL,1,'2025-06-26 12:15:54','2025-06-26 12:15:54',NULL),(2515,11429,40876,213729,3,2515,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',3880724.94,'COMPRAS',NULL,1,'2025-06-26 12:18:28','2025-06-26 12:18:29',NULL),(2516,11429,40876,213730,3,2516,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',646308.08,'COMPRAS',NULL,1,'2025-06-26 12:20:04','2025-06-26 12:20:04',NULL),(2517,11429,40876,213734,3,2517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',737058.08,'COMPRAS',NULL,1,'2025-06-26 12:21:33','2025-06-26 12:21:33',NULL);
INSERT INTO `balance_libro` VALUES (2518,11429,40876,213735,3,2518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',646734.53,'COMPRAS',NULL,1,'2025-06-26 12:22:40','2025-06-26 12:22:40',NULL),(2519,11429,40876,213736,3,2519,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',651300.54,'COMPRAS',NULL,1,'2025-06-26 12:23:53','2025-06-26 12:23:53',NULL),(2520,11429,40876,213722,16,2520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',67858.83,'DJ IIBB',NULL,1,'2025-06-26 12:32:52','2025-06-26 12:32:52',NULL),(2521,11429,40876,213723,16,2521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',42788.65,'DJ IIBB',NULL,1,'2025-06-26 12:35:49','2025-06-26 12:35:49',NULL),(2522,11429,40876,213724,16,2522,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',109783.66,'DJ IIBB',NULL,1,'2025-06-26 12:38:09','2025-06-26 12:38:09',NULL),(2523,11429,40876,213725,16,2523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',88609.94,'DJ IIBB',NULL,1,'2025-06-26 12:53:21','2025-06-26 12:53:21',NULL),(2524,11429,40876,213726,16,2524,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',540650.77,'DJ IIBB',NULL,1,'2025-06-26 12:56:15','2025-06-26 12:56:15',NULL),(2525,11429,40876,213727,16,2525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',248970.47,'DJ IIBB',NULL,1,'2025-06-26 12:58:31','2025-06-26 12:58:31',NULL),(2526,11429,40876,213728,16,2526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',158401.51,'DJ IIBB',NULL,1,'2025-06-26 13:01:03','2025-06-26 13:01:03',NULL),(2527,11429,40876,213729,16,2527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',230726.33,'DJ IIBB',NULL,1,'2025-06-26 13:03:18','2025-06-26 13:03:18',NULL),(2528,11429,40876,213730,16,2528,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',67900.34,'DJ IIBB',NULL,1,'2025-06-26 13:54:55','2025-06-26 13:54:55',NULL),(2529,11429,40876,213734,16,2529,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',40704.82,'DJ IIBB',NULL,1,'2025-06-26 14:07:35','2025-06-26 14:07:35',NULL),(2530,11429,40876,213735,16,2530,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',33281.43,'DJ IIBB',NULL,1,'2025-06-26 14:11:10','2025-06-26 14:11:10',NULL),(2531,11429,40876,213736,16,2531,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',33281.43,'DJ IIBB',NULL,1,'2025-06-26 14:20:57','2025-06-26 14:20:57',NULL),(2532,7941,40915,272952,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',70000.00,NULL,NULL,1,'2025-06-27 13:39:21','2025-06-27 13:39:21',NULL),(2533,NULL,40915,272952,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',980000.00,NULL,NULL,1,'2025-06-27 13:40:08','2025-06-27 13:40:08',NULL),(2534,NULL,40915,272952,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',890000.00,NULL,NULL,1,'2025-06-27 13:40:09','2025-06-27 13:40:09',NULL),(2535,NULL,40915,272952,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',100000.00,NULL,NULL,1,'2025-06-27 13:40:10','2025-06-27 13:40:10',NULL),(2536,NULL,40915,272952,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',170000.00,NULL,NULL,1,'2025-06-27 13:40:11','2025-06-27 13:40:11',NULL),(2537,NULL,40915,272952,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',310000.00,NULL,NULL,1,'2025-06-27 13:40:12','2025-06-27 13:40:12',NULL);
INSERT INTO `balance_libro` VALUES (2538,NULL,40915,272952,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',160000.00,NULL,NULL,1,'2025-06-27 13:40:13','2025-06-27 13:40:13',NULL),(2539,NULL,40915,272952,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',40000.00,NULL,NULL,1,'2025-06-27 13:40:15','2025-06-27 13:40:15',NULL),(2540,NULL,40915,272952,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',190000.00,NULL,NULL,1,'2025-06-27 13:40:16','2025-06-27 13:40:16',NULL),(2541,NULL,40915,272952,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',460000.00,NULL,NULL,1,'2025-06-27 13:40:17','2025-06-27 13:40:17',NULL),(2542,NULL,40915,272952,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',200000.00,NULL,NULL,1,'2025-06-27 13:40:18','2025-06-27 13:40:18',NULL),(2543,NULL,40915,272952,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',150000.00,NULL,NULL,1,'2025-06-27 13:40:19','2025-06-27 13:40:19',NULL),(2544,NULL,40915,272952,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',150000.00,NULL,NULL,1,'2025-06-27 13:40:20','2025-06-27 13:40:20',NULL),(2545,NULL,40915,272952,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',400000.00,NULL,NULL,1,'2025-06-27 13:40:21','2025-06-27 13:40:21',NULL),(2546,7941,40915,272952,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',150000.00,NULL,NULL,1,'2025-06-27 14:08:48','2025-06-27 14:08:48',NULL),(2547,7941,40719,53,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',280000.00,NULL,NULL,1,'2025-06-27 15:53:04','2025-06-27 15:53:04',NULL),(2548,7941,40719,53,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',190000.00,NULL,NULL,1,'2025-06-27 15:54:02','2025-06-27 15:54:02',NULL),(2549,7941,40719,53,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',190000.00,NULL,NULL,1,'2025-06-27 15:54:03','2025-06-27 15:54:03',NULL),(2550,7941,40719,53,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',140000.00,NULL,NULL,1,'2025-06-27 15:54:04','2025-06-27 15:54:04',NULL),(2551,7941,40719,53,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',220000.00,NULL,NULL,1,'2025-06-27 15:54:06','2025-06-27 15:54:06',NULL),(2552,7941,40719,53,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',560000.00,NULL,NULL,1,'2025-06-27 15:54:07','2025-06-27 15:54:07',NULL),(2553,7941,40719,53,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',200000.00,NULL,NULL,1,'2025-06-27 15:54:48','2025-06-27 15:54:48',NULL),(2554,7941,40719,53,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',605000.00,NULL,NULL,1,'2025-06-27 15:54:49','2025-06-27 15:54:49',NULL),(2555,7941,40719,53,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',260000.00,NULL,NULL,1,'2025-06-27 15:54:50','2025-06-27 15:54:50',NULL),(2556,7941,40719,53,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',210000.00,NULL,NULL,1,'2025-06-27 15:54:51','2025-06-27 15:54:51',NULL),(2557,7941,40719,53,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',400000.00,NULL,NULL,1,'2025-06-27 15:54:52','2025-06-27 15:54:52',NULL),(2558,7941,40719,53,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',100000.00,NULL,NULL,1,'2025-06-27 15:54:53','2025-06-27 15:54:53',NULL);
INSERT INTO `balance_libro` VALUES (2559,7941,40719,53,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',960000.00,NULL,NULL,1,'2025-06-30 12:28:21','2025-06-30 12:28:21',NULL),(2560,7941,40719,53,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',770000.00,NULL,NULL,1,'2025-06-30 12:28:22','2025-06-30 12:28:22',NULL),(2561,11429,40876,213722,5,2561,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1538868.63,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-02 16:14:03','2025-07-02 16:14:03',NULL),(2562,11429,40876,213723,5,2562,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1037833.40,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-02 16:20:00','2025-07-02 16:20:00',NULL),(2563,11429,40876,213724,5,2563,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',12572968.35,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-02 16:37:32','2025-07-02 16:37:32',NULL),(2564,11429,40876,213725,5,2564,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1549199.19,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:09:03','2025-07-03 09:09:03',NULL),(2565,11429,40876,213726,5,2565,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',15112645.48,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:14:34','2025-07-03 09:59:25','2025-07-03 09:59:25'),(2566,11429,40876,213727,5,2566,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6993094.89,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:26:30','2025-07-03 09:26:30',NULL),(2567,11429,40876,213728,5,2567,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',5963205.34,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:30:34','2025-07-03 09:30:34',NULL),(2568,11429,40876,213729,5,2568,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',5841388.74,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:34:10','2025-07-03 09:34:10',NULL),(2569,11429,40876,213730,5,2569,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1773398.12,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:37:10','2025-07-03 09:37:10',NULL),(2570,11429,40876,213734,5,2570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',976749.24,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:46:06','2025-07-03 09:46:06',NULL),(2571,11429,40876,213735,5,2571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1084243.40,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:51:23','2025-07-03 09:51:23',NULL),(2572,11429,40876,213736,5,2572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1197487.75,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:56:13','2025-07-03 09:56:13',NULL),(2573,11429,40876,213726,5,2573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',15112645.48,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 09:59:25','2025-07-03 10:49:01','2025-07-03 10:49:01'),(2574,11429,40876,213722,12,2574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',13461334.87,'SALDOS INICIALES',NULL,1,'2025-07-03 10:46:00','2025-07-03 10:46:00',NULL),(2575,11429,40876,213726,5,2575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',15112645.48,'BANCO SANTANDER 017225/3',NULL,1,'2025-07-03 10:49:01','2025-07-03 10:49:01',NULL),(2576,11429,40876,213722,6,2576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',932166.33,'DJ IIGG',NULL,1,'2025-07-03 10:53:45','2025-07-03 10:53:45',NULL);
INSERT INTO `balance_libro` VALUES (2577,11429,40874,210676,5,2577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',35435882.62,'BANCO CREDICOOP 69495',NULL,1,'2025-07-04 13:22:25','2025-07-22 15:21:22','2025-07-22 15:21:22'),(2578,11429,40874,210677,5,2578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',43277671.68,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 10:22:58','2025-07-07 10:42:41','2025-07-07 10:42:41'),(2579,11429,40874,210678,5,2579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',40647540.63,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 10:40:49','2025-07-07 10:40:49',NULL),(2580,11429,40874,210677,5,2580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',43277671.68,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 10:42:41','2025-07-07 10:42:41',NULL),(2581,11429,40874,210676,5,2581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',320687811.17,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 10:54:52','2025-07-17 16:43:07','2025-07-17 16:43:07'),(2582,11429,40874,210677,5,2582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',334180490.21,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 11:05:36','2025-07-17 17:18:38','2025-07-17 17:18:38'),(2583,11429,40874,210678,5,2583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',460326814.68,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 11:20:11','2025-07-17 17:19:48','2025-07-17 17:19:48'),(2584,11429,40874,210679,5,2584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',43464258.19,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 11:28:46','2025-07-07 11:28:46',NULL),(2585,11429,40874,210679,5,2585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',505789620.14,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 11:35:49','2025-07-11 11:56:54','2025-07-11 11:56:54'),(2586,11429,40874,210680,5,2586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',46480894.41,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 11:39:23','2025-07-07 11:39:23',NULL),(2587,11429,40874,210681,5,2587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',46225769.31,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 11:46:27','2025-07-07 15:34:40','2025-07-07 15:34:40'),(2588,11429,40874,210680,5,2588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',518302189.95,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 12:19:57','2025-07-17 17:22:55','2025-07-17 17:22:55'),(2589,11429,40874,210676,5,2589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',47626023.18,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 12:28:35','2025-07-07 12:39:37','2025-07-07 12:39:37'),(2590,11429,40874,210681,5,2590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',440156058.95,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 12:31:59','2025-07-17 17:24:01','2025-07-17 17:24:01'),(2591,11429,40874,210676,5,2591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',47626023.18,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 12:39:37','2025-07-07 13:22:17','2025-07-07 13:22:17'),(2592,11429,40874,210676,12,2592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',1450237823.46,'SALDOS INICIALES',NULL,1,'2025-07-07 12:40:00','2025-07-07 13:22:48','2025-07-07 13:22:48'),(2593,11429,40874,210682,5,2593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',479676406.76,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 12:42:01','2025-07-07 12:46:11','2025-07-07 12:46:11');
INSERT INTO `balance_libro` VALUES (2594,11429,40874,210677,5,2594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',49062325.03,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 12:45:48','2025-07-07 13:23:28','2025-07-07 13:23:28'),(2595,11429,40874,210682,5,2595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',479676406.76,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 12:46:11','2025-07-17 17:25:03','2025-07-17 17:25:03'),(2596,11429,40874,210678,5,2596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',44627731.93,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 12:53:10','2025-07-07 13:26:33','2025-07-07 13:26:33'),(2597,11429,40874,210683,5,2597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',670512263.31,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 12:59:07','2025-07-11 11:58:35','2025-07-11 11:58:35'),(2598,11429,40874,210679,5,2598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',54444151.93,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:02:36','2025-07-07 13:28:42','2025-07-07 13:28:42'),(2599,11429,40874,210684,5,2599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',595048536.21,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 13:10:29','2025-07-17 17:27:46','2025-07-17 17:27:46'),(2600,11429,40874,210682,5,2600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',47997594.26,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 13:11:57','2025-07-07 13:11:57',NULL),(2601,11429,40874,210683,5,2601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',46865697.77,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 13:20:22','2025-07-07 13:20:22',NULL),(2602,11429,40874,210688,5,2602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',654616587.80,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 13:22:11','2025-07-11 11:59:30','2025-07-11 11:59:30'),(2603,11429,40874,210676,5,2603,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',47626023.18,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:22:17','2025-07-07 13:22:17',NULL),(2604,11429,40874,210676,12,2604,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',1770900948.51,'SALDOS INICIALES',NULL,1,'2025-07-07 13:22:48','2025-07-07 13:33:37','2025-07-07 13:33:37'),(2605,11429,40874,210677,5,2605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',49062325.03,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:23:28','2025-07-07 13:23:28',NULL),(2606,11429,40874,210678,5,2606,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',44627731.93,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:26:33','2025-07-07 13:26:33',NULL),(2607,11429,40874,210684,5,2607,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',51538772.16,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 13:26:36','2025-07-07 13:26:36',NULL),(2608,11429,40874,210679,5,2608,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',54444151.93,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:28:42','2025-07-07 13:28:42',NULL),(2609,11429,40874,210688,5,2609,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',45618960.71,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 13:31:42','2025-07-07 13:31:42',NULL),(2610,11429,40874,210676,12,2610,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',1770901619.39,'SALDOS INICIALES',NULL,1,'2025-07-07 13:33:37','2025-07-07 13:33:37',NULL);
INSERT INTO `balance_libro` VALUES (2611,11429,40874,210689,5,2611,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',520600723.64,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 13:34:04','2025-07-17 17:30:39','2025-07-17 17:30:39'),(2612,11429,40874,210680,5,2612,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',57819808.60,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:35:27','2025-07-07 13:35:27',NULL),(2613,11429,40874,210689,5,2613,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',49521253.11,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 13:37:51','2025-07-07 13:37:51',NULL),(2614,11429,40874,210681,5,2614,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',66979005.76,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:40:23','2025-07-07 13:40:23',NULL),(2615,11429,40874,210690,5,2615,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',48206941.41,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 13:45:11','2025-07-07 13:45:11',NULL),(2616,11429,40874,210690,5,2616,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',504139044.35,'BANCO CREDICOOP 59029',NULL,1,'2025-07-07 13:47:38','2025-07-17 17:31:52','2025-07-17 17:31:52'),(2617,11429,40874,210682,5,2617,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',60616973.34,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:47:45','2025-07-07 13:47:45',NULL),(2618,11429,40874,210683,5,2618,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',78143670.81,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:52:27','2025-07-07 13:52:27',NULL),(2619,11429,40874,210684,5,2619,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',75103715.39,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 13:59:29','2025-07-07 13:59:29',NULL),(2620,11429,40874,210688,5,2620,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',108879338.18,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 14:08:17','2025-07-07 14:08:17',NULL),(2621,11429,40874,210689,5,2621,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',91977573.14,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 14:12:41','2025-07-07 14:12:41',NULL),(2622,11429,40874,210690,5,2622,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',97599931.19,'BANCO CREDICOOP 043-011286-1',NULL,1,'2025-07-07 14:16:42','2025-07-07 14:16:42',NULL),(2623,11429,40874,210676,6,2623,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',27689112.92,'DJ IIGG',NULL,1,'2025-07-07 14:20:12','2025-07-07 14:20:12',NULL),(2624,11429,40880,274526,2,2624,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',15774177.22,'VENTAS',NULL,1,'2025-07-07 14:32:22','2025-07-07 14:32:22',NULL),(2625,11429,40880,274527,2,2625,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',25221601.79,'VENTAS',NULL,1,'2025-07-07 14:34:14','2025-07-07 14:34:14',NULL),(2626,11429,40880,274528,2,2626,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',25063204.01,'VENTAS',NULL,1,'2025-07-07 14:35:41','2025-07-07 14:35:41',NULL),(2627,11429,40880,274529,2,2627,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',29248464.31,'VENTAS',NULL,1,'2025-07-07 14:37:31','2025-07-07 14:37:31',NULL),(2628,11429,40880,274530,2,2628,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',40891666.51,'VENTAS',NULL,1,'2025-07-07 14:45:57','2025-07-07 14:45:57',NULL);
INSERT INTO `balance_libro` VALUES (2629,11429,40880,219801,2,2629,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',37958003.67,'VENTAS',NULL,1,'2025-07-07 14:47:53','2025-07-07 14:47:53',NULL),(2630,11429,40880,219802,2,2630,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',24713880.39,NULL,NULL,1,'2025-07-07 14:48:44','2025-07-07 14:53:33','2025-07-07 14:53:33'),(2631,11429,40880,219802,2,2631,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',24713880.39,'VENTAS',NULL,1,'2025-07-07 14:53:33','2025-07-07 14:53:33',NULL),(2632,11429,40874,210676,5,2632,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',129239470.80,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 14:53:39','2025-07-08 09:53:50','2025-07-08 09:53:50'),(2633,11429,40880,219803,2,2633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',53545659.84,'VENTAS',NULL,1,'2025-07-07 14:57:52','2025-07-07 14:57:52',NULL),(2634,11429,40880,219804,2,2634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',21452448.56,'VENTAS',NULL,1,'2025-07-07 14:59:00','2025-07-07 14:59:00',NULL),(2635,11429,40880,219808,2,2635,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',50782299.45,'VENTAS',NULL,1,'2025-07-07 15:00:56','2025-07-07 15:00:56',NULL),(2636,11429,40880,219809,2,2636,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',55428171.89,'VENTAS',NULL,1,'2025-07-07 15:02:16','2025-07-07 15:02:16',NULL),(2637,11429,40880,219810,2,2637,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',26860968.41,'VENTAS',NULL,1,'2025-07-07 15:03:00','2025-07-07 15:03:00',NULL),(2638,11429,40874,210677,5,2638,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',126234027.28,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 15:05:23','2025-07-08 09:54:53','2025-07-08 09:54:53'),(2639,11429,40874,210678,5,2639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',142904898.82,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 15:16:35','2025-07-08 09:56:14','2025-07-08 09:56:14'),(2640,11429,40880,274526,15,2640,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3360168.08,'DJ IVA',NULL,1,'2025-07-07 15:17:42','2025-07-07 15:17:42',NULL),(2641,11429,40880,274527,15,2641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',4377302.79,'DJ IVA',NULL,1,'2025-07-07 15:20:11','2025-07-07 15:20:11',NULL),(2642,11429,40874,210679,5,2642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',176874124.33,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 15:29:03','2025-07-08 09:57:23','2025-07-08 09:57:23'),(2643,11429,40880,274528,15,2643,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',4349812.27,'DJ IVA',NULL,1,'2025-07-07 15:29:15','2025-07-08 15:53:45','2025-07-08 15:53:45'),(2644,11429,40880,274529,15,2644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',5076179.76,'DJ IVA',NULL,1,'2025-07-07 15:31:16','2025-07-07 15:31:16',NULL),(2645,11429,40880,274530,15,2645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',7096900.80,'DJ IVA',NULL,1,'2025-07-07 15:32:42','2025-07-07 15:32:42',NULL),(2646,11429,40880,219801,15,2646,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6587752.70,'DJ IVA',NULL,1,'2025-07-07 15:33:55','2025-07-07 15:33:55',NULL);
INSERT INTO `balance_libro` VALUES (2647,11429,40874,210681,5,2647,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',46268584.68,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 15:34:40','2025-07-07 16:13:57','2025-07-07 16:13:57'),(2648,11429,40880,219802,15,2648,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4289185.85,'DJ IVA',NULL,1,'2025-07-07 15:35:20','2025-07-07 15:35:20',NULL),(2649,11429,40874,210680,5,2649,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',148515666.04,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 15:35:24','2025-07-08 09:58:22','2025-07-08 09:58:22'),(2650,11429,40880,219803,15,2650,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',9293048.40,'DJ IVA',NULL,1,'2025-07-07 15:36:19','2025-07-07 15:36:19',NULL),(2651,11429,40880,219804,15,2651,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',3723152.23,'DJ IVA',NULL,1,'2025-07-07 15:37:16','2025-07-07 15:37:16',NULL),(2652,11429,40880,219808,15,2652,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',8813456.93,'DJ IVA',NULL,1,'2025-07-07 15:40:13','2025-07-07 15:40:13',NULL),(2653,11429,40880,219809,15,2653,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',9619765.37,'DJ IVA',NULL,1,'2025-07-07 15:41:00','2025-07-07 15:41:00',NULL),(2654,11429,40880,219810,15,2654,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',4661820.96,'DJ IVA',NULL,1,'2025-07-07 15:42:05','2025-07-07 15:42:05',NULL),(2655,11429,40874,210681,5,2655,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',160332505.90,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 15:43:10','2025-07-08 09:59:30','2025-07-08 09:59:30'),(2656,11429,40874,210682,5,2656,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',174015810.33,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 16:00:11','2025-07-08 10:00:25','2025-07-08 10:00:25'),(2657,11429,40874,210683,5,2657,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',172287808.40,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 16:07:19','2025-07-08 10:01:37','2025-07-08 10:01:37'),(2658,11429,40874,210681,5,2658,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',46268584.68,'BANCO CREDICOOP 69495',NULL,1,'2025-07-07 16:13:57','2025-07-07 16:13:57',NULL),(2659,11429,40874,210684,5,2659,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',188399823.28,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 16:14:32','2025-07-08 10:02:47','2025-07-08 10:02:47'),(2660,11429,40874,210688,5,2660,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',199717449.31,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 16:31:36','2025-07-08 10:04:06','2025-07-08 10:04:06'),(2661,11429,40719,36,5,2661,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',21000.00,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 17:03:01','2025-07-07 18:19:33','2025-07-07 18:19:33'),(2662,11429,40719,37,5,2662,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1049.99,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 17:04:30','2025-07-07 18:20:50','2025-07-07 18:20:50'),(2663,11429,40719,43,5,2663,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',26025.74,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 17:17:42','2025-07-07 18:21:44','2025-07-07 18:21:44');
INSERT INTO `balance_libro` VALUES (2664,11429,40719,44,5,2664,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',54476.02,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 17:21:57','2025-07-07 18:22:17','2025-07-07 18:22:17'),(2665,11429,40719,48,5,2665,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',28553.06,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 17:27:56','2025-07-07 18:22:51','2025-07-07 18:22:51'),(2666,11429,40874,210689,5,2666,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',145249264.73,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 17:28:59','2025-07-08 10:05:06','2025-07-08 10:05:06'),(2667,11429,40719,49,5,2667,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',35258.35,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 17:32:17','2025-07-07 18:23:16','2025-07-07 18:23:16'),(2668,11429,40874,210690,5,2668,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',154170974.79,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-07 17:36:31','2025-07-08 10:07:43','2025-07-08 10:07:43'),(2669,11429,40719,50,5,2669,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',70297.33,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 17:38:17','2025-07-07 18:23:52','2025-07-07 18:23:52'),(2670,11429,40874,210676,5,2670,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',21000.00,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 18:32:01','2025-07-07 18:32:01',NULL),(2671,11429,40874,210677,5,2671,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1049.99,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 18:33:49','2025-07-07 18:33:49',NULL),(2672,11429,40874,210683,5,2672,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',26025.74,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 18:40:16','2025-07-07 18:40:16',NULL),(2673,11429,40874,210684,5,2673,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',54476.02,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 18:45:37','2025-07-07 18:45:37',NULL),(2674,11429,40874,210688,5,2674,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',28553.06,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 18:50:42','2025-07-07 18:50:42',NULL),(2675,11429,40874,210689,5,2675,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',35258.35,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 18:55:50','2025-07-07 18:55:50',NULL),(2676,11429,40874,210690,5,2676,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',70297.33,'BANCO CREDICOOP 043-009798-0',NULL,1,'2025-07-07 19:00:55','2025-07-07 19:00:55',NULL),(2677,11429,40874,210676,5,2677,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',129239470.80,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 09:53:50','2025-07-08 09:53:50',NULL),(2678,11429,40874,210677,5,2678,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',126234027.28,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 09:54:53','2025-07-08 09:54:53',NULL),(2679,11429,40874,210678,5,2679,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',142904898.82,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 09:56:14','2025-07-08 09:56:14',NULL),(2680,11429,40874,210679,5,2680,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',176874124.33,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 09:57:23','2025-07-16 11:26:46','2025-07-16 11:26:46');
INSERT INTO `balance_libro` VALUES (2681,11429,40874,210680,5,2681,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',148515666.04,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 09:58:22','2025-07-08 09:58:22',NULL),(2682,11429,40874,210681,5,2682,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',160332505.90,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 09:59:30','2025-07-08 09:59:30',NULL),(2683,11429,40874,210682,5,2683,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',174015810.33,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 10:00:25','2025-07-08 10:00:25',NULL),(2684,11429,40874,210683,5,2684,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',172287808.40,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 10:01:37','2025-07-08 10:01:37',NULL),(2685,11429,40874,210684,5,2685,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',188399823.28,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 10:02:47','2025-07-08 10:02:47',NULL),(2686,11429,40874,210688,5,2686,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',199717449.31,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 10:04:06','2025-07-08 10:04:06',NULL),(2687,11429,40874,210689,5,2687,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',145249264.73,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 10:05:06','2025-07-08 10:08:31','2025-07-08 10:08:31'),(2688,11429,40874,210690,5,2688,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',154170974.79,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 10:07:43','2025-07-08 10:07:43',NULL),(2689,11429,40874,210689,5,2689,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',145249264.73,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-08 10:08:31','2025-07-08 10:08:31',NULL),(2690,11429,40880,274526,16,2690,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',651863.06,'DJ IIBB',NULL,1,'2025-07-08 12:44:49','2025-07-08 12:44:49',NULL),(2691,11429,40880,274527,16,2691,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',570054.58,'DJ IIBB',NULL,1,'2025-07-08 12:46:43','2025-07-08 12:46:43',NULL),(2692,11429,40880,274528,16,2692,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',427805.70,'DJ IIBB',NULL,1,'2025-07-08 12:48:36','2025-07-08 12:48:36',NULL),(2693,11429,40880,274529,16,2693,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',395438.68,'DJ IIBB',NULL,1,'2025-07-08 12:50:11','2025-07-08 12:50:11',NULL),(2694,11429,40880,274530,16,2694,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',902268.26,'DJ IIBB',NULL,1,'2025-07-08 12:53:25','2025-07-08 12:53:25',NULL),(2695,11429,40880,219801,16,2695,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1280043.82,'DJ IIBB',NULL,1,'2025-07-08 12:56:51','2025-07-08 12:56:51',NULL),(2696,11429,40880,219802,16,2696,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1489459.31,'DJ IIBB',NULL,1,'2025-07-08 12:57:57','2025-07-08 12:57:57',NULL),(2697,11429,40880,219803,16,2697,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1425936.33,'DJ IIBB',NULL,1,'2025-07-08 12:59:06','2025-07-08 12:59:06',NULL),(2698,11429,40880,219804,16,2698,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1067401.50,'DJ IIBB',NULL,1,'2025-07-08 13:01:32','2025-07-08 13:01:32',NULL);
INSERT INTO `balance_libro` VALUES (2699,11429,40880,219808,16,2699,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1148577.80,'DJ IIBB',NULL,1,'2025-07-08 13:11:55','2025-07-08 13:11:55',NULL),(2700,11429,40880,219809,16,2700,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',837764.47,'DJ IIBB',NULL,1,'2025-07-08 13:19:28','2025-07-08 13:19:28',NULL),(2701,11429,40880,219810,16,2701,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',501182.73,'DJ IIBB',NULL,1,'2025-07-08 13:22:39','2025-07-08 13:22:39',NULL),(2702,11429,40880,274528,15,2702,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',4349812.27,'DJ IVA',NULL,1,'2025-07-08 15:53:45','2025-07-08 15:53:45',NULL),(2703,11429,40880,219810,5,2703,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',40000.00,'BANCO PROVINCIA',NULL,1,'2025-07-08 15:57:27','2025-07-08 15:57:27',NULL),(2704,11429,40874,210679,5,2704,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',505789620.14,'BANCO CREDICOOP 59029',NULL,1,'2025-07-11 11:56:54','2025-07-17 17:21:39','2025-07-17 17:21:39'),(2705,11429,40874,210683,5,2705,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',670512263.31,'BANCO CREDICOOP 59029',NULL,1,'2025-07-11 11:58:35','2025-07-16 11:37:15','2025-07-16 11:37:15'),(2706,11429,40874,210688,5,2706,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',654616587.80,'BANCO CREDICOOP 59029',NULL,1,'2025-07-11 11:59:30','2025-07-17 17:29:28','2025-07-17 17:29:28'),(2707,11429,40880,274526,1,2707,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1809906.71,'SUELDOS',NULL,1,'2025-07-11 14:24:10','2025-07-11 14:24:10',NULL),(2708,11429,40880,274527,1,2708,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2082444.45,'SUELDOS',NULL,1,'2025-07-11 14:25:20','2025-07-11 14:25:20',NULL),(2709,11429,40880,274528,1,2709,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',3119552.08,'SUELDOS',NULL,1,'2025-07-11 14:27:27','2025-07-11 14:27:27',NULL),(2710,11429,40880,274529,1,2710,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2324259.16,'SUELDOS',NULL,1,'2025-07-11 14:28:39','2025-07-11 14:28:39',NULL),(2711,11429,40880,274530,1,2711,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',2023138.10,'SUELDOS',NULL,1,'2025-07-11 14:30:24','2025-07-11 14:30:24',NULL),(2712,11429,40880,219801,1,2712,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',2306826.06,'SUELDOS',NULL,1,'2025-07-11 14:33:12','2025-07-11 14:33:12',NULL),(2713,11429,40880,219802,1,2713,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2316688.33,'SUELDOS',NULL,1,'2025-07-11 14:39:53','2025-07-11 14:39:53',NULL),(2714,11429,40880,219803,1,2714,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2363160.85,'SUELDOS',NULL,1,'2025-07-11 14:43:21','2025-07-11 14:43:21',NULL),(2715,11429,40880,219804,1,2715,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4691477.21,'SUELDOS',NULL,1,'2025-07-11 14:44:14','2025-07-11 14:44:14',NULL),(2716,11429,40880,219808,1,2716,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',3490638.73,'SUELDOS',NULL,1,'2025-07-11 15:03:05','2025-07-11 15:03:05',NULL),(2717,11429,40880,219809,1,2717,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',3497060.68,'SUELDOS',NULL,1,'2025-07-11 15:04:09','2025-07-11 15:04:09',NULL);
INSERT INTO `balance_libro` VALUES (2718,11429,40880,219810,1,2718,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',3997571.41,'SUELDOS',NULL,1,'2025-07-11 15:08:18','2025-07-11 15:08:18',NULL),(2719,11429,40874,210676,5,2719,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',35000.12,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:01:51','2025-07-14 11:01:51',NULL),(2720,11429,40874,210677,5,2720,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',4123.83,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:06:06','2025-07-14 11:06:06',NULL),(2721,11429,40874,210678,5,2721,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',42811.63,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:12:59','2025-07-14 11:12:59',NULL),(2722,11429,40874,210679,5,2722,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2367.16,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:22:11','2025-07-14 11:22:11',NULL),(2723,11429,40874,210680,5,2723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',189.04,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:29:55','2025-07-14 11:29:55',NULL),(2724,11429,40874,210681,5,2724,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',5832.00,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:37:42','2025-07-14 11:37:42',NULL),(2725,11429,40874,210682,5,2725,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',7199.34,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:43:39','2025-07-14 11:43:39',NULL),(2726,11429,40874,210683,5,2726,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',101900000.00,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:47:21','2025-07-14 11:47:21',NULL),(2727,11429,40874,210684,5,2727,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1500000.00,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:51:34','2025-07-14 11:51:34',NULL),(2728,11429,40874,210688,5,2728,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',32248084.33,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 11:59:03','2025-07-14 11:59:03',NULL),(2729,11429,40874,210689,5,2729,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',221004.25,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 12:02:25','2025-07-14 12:02:25',NULL),(2730,11429,40874,210690,5,2730,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',25146.61,'BANCO SUPERVIELLE 79963',NULL,1,'2025-07-14 12:16:26','2025-07-14 12:16:26',NULL),(2731,11429,40874,210679,5,2731,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',176874124.33,'Banco Credicoop CTA  9996-2',NULL,1,'2025-07-16 11:26:46','2025-07-16 11:26:46',NULL),(2732,11429,40874,210683,5,2732,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',670512263.31,'BANCO CREDICOOP 59029',NULL,1,'2025-07-16 11:37:15','2025-07-17 17:26:31','2025-07-17 17:26:31'),(2733,11429,40880,274526,3,2733,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',12617420.74,'COMPRAS',NULL,1,'2025-07-17 14:43:34','2025-07-17 15:12:46','2025-07-17 15:12:46'),(2734,11429,40880,274527,3,2734,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',15704431.29,'COMPRAS',NULL,1,'2025-07-17 14:57:31','2025-07-17 14:57:31',NULL),(2735,11429,40880,274528,3,2735,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',7986852.83,'COMPRAS',NULL,1,'2025-07-17 15:03:38','2025-07-17 15:11:40','2025-07-17 15:11:40');
INSERT INTO `balance_libro` VALUES (2736,11429,40880,274529,3,2736,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',26092341.20,'COMPRAS',NULL,1,'2025-07-17 15:10:48','2025-07-17 15:10:48',NULL),(2737,11429,40880,274528,3,2737,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',7986852.83,'COMPRAS',NULL,1,'2025-07-17 15:11:40','2025-07-17 15:11:40',NULL),(2738,11429,40880,274526,3,2738,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',12617420.74,'COMPRAS',NULL,1,'2025-07-17 15:12:46','2025-07-17 15:12:46',NULL),(2739,11429,40880,274530,3,2739,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',12184613.78,'COMPRAS',NULL,1,'2025-07-17 15:18:21','2025-07-17 15:18:21',NULL),(2740,11429,40880,219801,3,2740,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',24517046.90,'COMPRAS',NULL,1,'2025-07-17 15:21:30','2025-07-17 15:21:30',NULL),(2741,11429,40880,219802,3,2741,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',24720980.09,'COMPRAS',NULL,1,'2025-07-17 15:25:29','2025-07-17 15:25:30',NULL),(2742,11429,40880,219803,3,2742,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',34600016.79,'COMPRAS',NULL,1,'2025-07-17 15:28:37','2025-07-17 15:28:37',NULL),(2743,11429,40880,219804,3,2743,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',21698631.11,'COMPRAS',NULL,1,'2025-07-17 15:30:42','2025-07-17 15:30:42',NULL),(2744,11429,40880,219808,3,2744,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',45775749.18,'COMPRAS',NULL,1,'2025-07-17 15:33:52','2025-07-17 15:33:52',NULL),(2745,11429,40880,219809,3,2745,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45047393.96,'COMPRAS',NULL,1,'2025-07-17 15:40:27','2025-07-17 15:40:27',NULL),(2746,11429,40880,219810,3,2746,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',20460587.49,'COMPRAS',NULL,1,'2025-07-17 15:45:40','2025-07-17 15:45:40',NULL),(2747,11429,40874,210676,5,2747,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',320687811.17,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 16:43:07','2025-07-17 16:47:29','2025-07-17 16:47:29'),(2748,11429,40874,210676,5,2748,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',320687811.17,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 16:47:29','2025-07-17 16:47:29',NULL),(2749,11429,40874,210677,5,2749,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',334180490.21,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:18:38','2025-07-17 17:18:38',NULL),(2750,11429,40874,210678,5,2750,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',460326814.68,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:19:48','2025-07-17 17:19:48',NULL),(2751,11429,40874,210679,5,2751,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',505789620.14,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:21:39','2025-07-17 17:21:39',NULL),(2752,11429,40874,210680,5,2752,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',518302189.95,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:22:55','2025-07-17 17:22:55',NULL),(2753,11429,40874,210681,5,2753,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',440156058.95,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:24:01','2025-07-17 17:24:01',NULL);
INSERT INTO `balance_libro` VALUES (2754,11429,40874,210682,5,2754,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',479676406.76,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:25:03','2025-07-17 17:25:03',NULL),(2755,11429,40874,210683,5,2755,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',670512263.31,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:26:31','2025-07-17 17:26:31',NULL),(2756,11429,40874,210684,5,2756,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',595048536.21,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:27:46','2025-07-17 17:27:46',NULL),(2757,11429,40874,210688,5,2757,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',654616587.80,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:29:28','2025-07-22 16:42:12','2025-07-22 16:42:12'),(2758,11429,40874,210689,5,2758,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',520600723.64,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:30:39','2025-07-22 16:43:31','2025-07-22 16:43:31'),(2759,11429,40874,210690,5,2759,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',504139044.35,'BANCO CREDICOOP 59029',NULL,1,'2025-07-17 17:31:52','2025-07-22 16:46:30','2025-07-22 16:46:30'),(2760,11429,40874,210676,5,2760,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4953181.58,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 13:29:09','2025-07-22 13:29:09',NULL),(2761,11429,40874,210677,5,2761,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',6279716.72,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 13:32:23','2025-07-22 13:32:23',NULL),(2762,11429,40874,210678,5,2762,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',5189962.88,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 13:35:27','2025-07-22 13:35:27',NULL),(2763,11429,40874,210679,5,2763,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',8291017.85,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 13:39:18','2025-07-22 13:39:18',NULL),(2764,11429,40874,210680,5,2764,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',6756395.15,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 13:42:16','2025-07-22 13:42:16',NULL),(2765,11429,40874,210676,5,2765,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',35435882.62,'BANCO CREDICOOP 69495',NULL,1,'2025-07-22 15:21:22','2025-07-22 15:21:22',NULL),(2766,11429,40874,210681,5,2766,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',7696654.47,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 15:28:11','2025-07-22 15:28:11',NULL),(2767,11429,40874,210682,5,2767,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',10252000.81,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 15:31:18','2025-07-22 15:31:18',NULL),(2768,11429,40874,210683,5,2768,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',6350414.75,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 15:34:47','2025-07-22 15:34:47',NULL),(2769,11429,40874,210684,5,2769,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5322516.00,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 15:37:26','2025-07-22 15:37:26',NULL),(2770,11429,40874,210688,5,2770,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',10171783.00,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 15:41:49','2025-07-22 15:41:49',NULL);
INSERT INTO `balance_libro` VALUES (2771,11429,40874,210689,5,2771,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',6774199.53,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 15:44:35','2025-07-22 15:44:35',NULL),(2772,11429,40874,210690,5,2772,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',4791223.30,'TARJETA DE CREDITO VISA',NULL,1,'2025-07-22 15:47:08','2025-07-22 15:47:08',NULL),(2773,11429,40874,210680,5,2773,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',463396.19,'TARJETA DE CREDITO CABAL',NULL,1,'2025-07-22 15:49:05','2025-07-22 15:49:05',NULL),(2774,11429,40874,210681,5,2774,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',46878.27,'TARJETA DE CREDITO CABAL',NULL,1,'2025-07-22 15:50:44','2025-07-22 15:50:44',NULL),(2775,11429,40874,210682,5,2775,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',349535.02,'TARJETA DE CREDITO CABAL',NULL,1,'2025-07-22 15:52:10','2025-07-22 15:52:10',NULL),(2776,11429,40874,210683,5,2776,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2739001.79,'TARJETA DE CREDITO CABAL',NULL,1,'2025-07-22 15:53:17','2025-07-22 15:53:17',NULL),(2777,11429,40874,210684,5,2777,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1164967.01,'TARJETA DE CREDITO CABAL',NULL,1,'2025-07-22 15:55:28','2025-07-22 15:55:28',NULL),(2778,11429,40874,210688,5,2778,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',613896.78,'TARJETA DE CREDITO CABAL',NULL,1,'2025-07-22 15:56:39','2025-07-22 15:56:39',NULL),(2779,11429,40874,210689,5,2779,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',304229.79,'TARJETA DE CREDITO CABAL',NULL,1,'2025-07-22 15:57:56','2025-07-22 15:57:56',NULL),(2780,11429,40874,210690,5,2780,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',304229.79,'TARJETA DE CREDITO CABAL',NULL,1,'2025-07-22 15:59:28','2025-07-22 15:59:28',NULL),(2781,11429,40874,210688,5,2781,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',654616587.80,'BANCO CREDICOOP 59029',NULL,1,'2025-07-22 16:42:12','2025-07-22 16:42:12',NULL),(2782,11429,40874,210689,5,2782,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',520600723.64,'BANCO CREDICOOP 59029',NULL,1,'2025-07-22 16:43:31','2025-07-22 16:43:31',NULL),(2783,11429,40874,210690,5,2783,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',504139044.35,'BANCO CREDICOOP 59029',NULL,1,'2025-07-22 16:46:30','2025-07-22 16:46:30',NULL),(2784,11429,40874,210690,5,2784,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',60906044.57,'MERCADO PAGO CUENTA 3',NULL,1,'2025-07-22 17:29:06','2025-07-22 17:29:06',NULL),(2785,11429,40874,210690,5,2785,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',20308905.69,'MERCADO PAGO CUENTA 6',NULL,1,'2025-07-22 17:34:46','2025-07-22 17:34:46',NULL),(2786,11429,40874,210690,5,2786,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',9006307.03,'MERCADO PAGO CUENTA 5',NULL,1,'2025-07-22 17:37:34','2025-07-22 17:37:34',NULL),(2787,11429,40874,210676,5,2787,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',39996136.47,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-23 17:25:35','2025-07-23 17:25:35',NULL),(2788,11429,40874,210677,5,2788,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',52652454.44,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-23 17:31:39','2025-07-23 17:31:39',NULL);
INSERT INTO `balance_libro` VALUES (2789,11429,40874,210678,5,2789,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',62368352.15,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-23 17:45:18','2025-07-23 17:45:18',NULL),(2790,11429,40874,210679,5,2790,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',59945278.49,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-23 17:52:42','2025-07-23 17:52:42',NULL),(2791,11429,40874,210680,5,2791,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',63681857.37,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-23 18:01:25','2025-07-23 18:01:25',NULL),(2792,11429,40874,210681,5,2792,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',79333408.62,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-24 09:38:19','2025-07-24 09:38:19',NULL),(2793,11429,40874,210682,5,2793,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',72752975.60,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-24 09:51:12','2025-07-24 09:51:12',NULL),(2794,11429,40874,210683,5,2794,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',89393772.08,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-24 09:58:51','2025-07-24 09:58:51',NULL),(2795,11429,40874,210684,5,2795,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',110919050.44,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-24 10:16:31','2025-07-24 10:16:31',NULL),(2796,11429,40874,210688,5,2796,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',90156842.42,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-24 10:22:42','2025-07-24 10:22:42',NULL),(2797,11429,40874,210689,5,2797,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',92544736.47,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-24 10:29:15','2025-07-24 10:29:15',NULL),(2798,11429,40874,210690,5,2798,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',94447715.63,'MERCADO PAGO CUENTA 1',NULL,1,'2025-07-24 10:33:45','2025-07-24 10:33:45',NULL),(2799,11429,40874,210676,3,2799,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',116546756.59,'SUBDIARIO COMPRAS',NULL,1,'2025-07-24 16:33:33','2025-07-24 16:33:33',NULL),(2800,11429,40874,210677,3,2800,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',130011881.12,'SUBDIARIO COMPRAS',NULL,1,'2025-07-24 16:39:08','2025-07-24 16:39:08',NULL),(2801,11429,40874,210678,3,2801,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',103147934.26,'SUBDIARIO COMPRAS',NULL,1,'2025-07-24 16:45:41','2025-07-24 16:45:41',NULL),(2802,11429,40874,210679,3,2802,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',283771167.48,'SUBDIARIO COMPRAS',NULL,1,'2025-07-24 16:52:04','2025-07-24 16:52:04',NULL),(2803,11429,40874,210680,3,2803,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',308846747.83,'SUBDIARIO COMPRAS',NULL,1,'2025-07-24 16:57:05','2025-07-24 16:57:05',NULL),(2804,11429,40874,210681,3,2804,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',232362822.25,'SUBDIARIO COMPRAS',NULL,1,'2025-07-24 17:04:59','2025-07-24 17:04:59',NULL),(2805,11429,40874,210682,3,2805,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',253228198.10,'SUBDIARIO COMPRAS',NULL,1,'2025-07-25 10:29:48','2025-07-25 10:29:48',NULL),(2806,11429,40874,210683,3,2806,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',178688918.27,'SUBDIARIO COMPRAS',NULL,1,'2025-07-25 10:36:58','2025-07-25 10:36:58',NULL);
INSERT INTO `balance_libro` VALUES (2807,11429,40874,210684,3,2807,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',230030454.35,'SUBDIARIO COMPRAS',NULL,1,'2025-07-25 10:45:59','2025-07-25 10:45:59',NULL),(2808,11429,40874,210688,3,2808,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',513682111.26,'SUBDIARIO COMPRAS',NULL,1,'2025-07-25 11:04:29','2025-07-25 11:04:29',NULL),(2809,11429,40874,210689,3,2809,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',262189763.86,'SUBDIARIO COMPRAS',NULL,1,'2025-07-25 11:11:54','2025-07-25 11:11:54',NULL),(2810,11429,40874,210690,3,2810,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',387922139.13,'SUBDIARIO COMPRAS',NULL,1,'2025-07-25 11:17:38','2025-07-25 11:17:38',NULL),(2811,7941,40915,272953,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',70000.00,NULL,NULL,1,'2025-07-28 18:18:49','2025-07-28 18:18:49',NULL),(2812,NULL,40915,272953,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',980000.00,NULL,NULL,1,'2025-07-28 18:19:09','2025-07-28 18:19:09',NULL),(2813,NULL,40915,272953,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',890000.00,NULL,NULL,1,'2025-07-28 18:19:10','2025-07-28 18:19:10',NULL),(2814,NULL,40915,272953,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',100000.00,NULL,NULL,1,'2025-07-28 18:19:11','2025-07-28 18:19:11',NULL),(2815,NULL,40915,272953,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',170000.00,NULL,NULL,1,'2025-07-28 18:19:13','2025-07-28 18:19:13',NULL),(2816,NULL,40915,272953,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',330000.00,NULL,NULL,1,'2025-07-28 18:19:14','2025-07-28 18:19:14',NULL),(2817,NULL,40915,272953,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',170000.00,NULL,NULL,1,'2025-07-28 18:19:15','2025-07-28 18:19:15',NULL),(2818,NULL,40915,272953,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',40000.00,NULL,NULL,1,'2025-07-28 18:19:16','2025-07-28 18:19:16',NULL),(2819,NULL,40915,272953,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',280000.00,NULL,NULL,1,'2025-07-28 18:19:17','2025-07-28 18:19:17',NULL),(2820,NULL,40915,272953,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',190000.00,NULL,NULL,1,'2025-07-28 18:19:18','2025-07-28 18:19:18',NULL),(2821,NULL,40915,272953,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',500000.00,NULL,NULL,1,'2025-07-28 18:19:19','2025-07-28 18:19:19',NULL),(2822,NULL,40915,272953,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',200000.00,NULL,NULL,1,'2025-07-28 18:19:20','2025-07-28 18:19:20',NULL),(2823,NULL,40915,272953,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-28','2025-07-28',150000.00,NULL,NULL,1,'2025-07-28 18:19:21','2025-07-28 18:19:21',NULL),(2824,7941,40915,272953,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',150000.00,NULL,NULL,1,'2025-07-29 10:42:10','2025-07-29 10:42:10',NULL),(2825,NULL,40719,54,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',960000.00,NULL,NULL,1,'2025-07-29 11:14:59','2025-07-29 11:14:59',NULL),(2826,NULL,40719,54,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',770000.00,NULL,NULL,1,'2025-07-29 11:15:01','2025-07-29 11:15:01',NULL);
INSERT INTO `balance_libro` VALUES (2827,NULL,40719,54,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',280000.00,NULL,NULL,1,'2025-07-29 11:15:02','2025-07-29 11:15:02',NULL),(2828,NULL,40719,54,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',190000.00,NULL,NULL,1,'2025-07-29 11:15:03','2025-07-29 11:15:03',NULL),(2829,NULL,40719,54,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',190000.00,NULL,NULL,1,'2025-07-29 11:15:04','2025-07-29 11:15:04',NULL),(2830,NULL,40719,54,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',140000.00,NULL,NULL,1,'2025-07-29 11:15:05','2025-07-29 11:15:05',NULL),(2831,NULL,40719,54,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',100000.00,NULL,NULL,1,'2025-07-29 11:15:06','2025-07-29 11:15:06',NULL),(2832,NULL,40719,54,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',220000.00,NULL,NULL,1,'2025-07-29 11:15:07','2025-07-29 11:15:07',NULL),(2833,NULL,40719,54,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',210000.00,NULL,NULL,1,'2025-07-29 11:15:08','2025-07-29 11:15:08',NULL),(2834,NULL,40719,54,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',605000.00,NULL,NULL,1,'2025-07-29 11:15:09','2025-07-29 11:15:09',NULL),(2835,NULL,40719,54,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',260000.00,NULL,NULL,1,'2025-07-29 11:15:10','2025-07-29 11:15:10',NULL),(2836,NULL,40719,54,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',210000.00,NULL,NULL,1,'2025-07-29 11:15:12','2025-07-29 11:15:12',NULL),(2837,NULL,40719,54,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',350000.00,NULL,NULL,1,'2025-07-29 11:15:13','2025-07-29 11:15:13',NULL),(2838,NULL,40719,54,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',50000.00,NULL,NULL,1,'2025-07-29 11:15:14','2025-07-29 11:15:14',NULL),(2839,11429,40880,274526,12,2839,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',106738361.87,'SALDOS INICIALES',NULL,1,'2025-08-04 14:55:42','2025-08-04 15:00:55','2025-08-04 15:00:55'),(2840,11429,40880,274526,12,2840,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',280961427.39,'SALDOS INICIALES',NULL,1,'2025-08-04 15:00:55','2025-08-04 15:25:23','2025-08-04 15:25:23'),(2841,11429,40880,274526,12,2841,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',287506594.83,'SALDOS INICIALES',NULL,1,'2025-08-04 15:25:23','2025-08-04 15:30:53','2025-08-04 15:30:53'),(2842,11429,40880,274526,12,2842,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',287506594.83,'SALDOS INICIALES',NULL,1,'2025-08-04 15:30:53','2025-08-04 16:04:43','2025-08-04 16:04:43'),(2843,11429,40880,274526,12,2843,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',287506594.83,'SALDOS INICIALES',NULL,1,'2025-08-04 16:04:43','2025-08-04 16:04:43',NULL),(2844,11429,40880,274526,6,2844,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',5877282.13,'DJ IIGG',NULL,1,'2025-08-04 16:07:23','2025-08-04 16:09:30','2025-08-04 16:09:30'),(2845,11429,40880,274526,6,2845,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',5877282.13,'DJ IIGG',NULL,1,'2025-08-04 16:09:30','2025-08-04 16:09:30',NULL);
INSERT INTO `balance_libro` VALUES (2846,11429,40878,216768,2,2846,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',802631.72,'VENTAS',NULL,1,'2025-08-06 17:41:39','2025-08-06 17:41:39',NULL),(2847,11429,40878,216769,2,2847,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1028500.00,'VENTAS',NULL,1,'2025-08-06 17:44:24','2025-08-06 17:44:24',NULL),(2848,11429,40878,216770,2,2848,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1071697.00,'VENTAS',NULL,1,'2025-08-06 17:50:27','2025-08-06 17:50:27',NULL),(2849,11429,40878,216771,2,2849,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1120995.05,'VENTAS',NULL,1,'2025-08-06 17:52:25','2025-08-06 17:52:25',NULL),(2850,11429,40878,216772,2,2850,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1165834.88,'VENTAS',NULL,1,'2025-08-06 17:53:34','2025-08-06 17:53:34',NULL),(2851,11429,40878,216773,2,2851,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1214799.90,'VENTAS',NULL,1,'2025-08-06 17:54:49','2025-08-06 17:54:49',NULL),(2852,11429,40878,216774,2,2852,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1257317.91,'VENTAS',NULL,1,'2025-08-06 17:55:56','2025-08-06 17:55:56',NULL),(2853,11429,40878,216775,2,2853,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1291265.50,'VENTAS',NULL,1,'2025-08-06 17:57:13','2025-08-06 17:57:13',NULL),(2854,11429,40878,216779,2,2854,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1322255.91,'VENTAS',NULL,1,'2025-08-06 17:58:08','2025-08-06 17:58:08',NULL),(2855,11429,40878,216780,2,2855,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1357956.78,'VENTAS',NULL,1,'2025-08-06 17:59:02','2025-08-06 17:59:02',NULL),(2856,11429,40878,216781,2,2856,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',6106831.86,'VENTAS',NULL,1,'2025-08-06 18:00:33','2025-08-06 18:00:33',NULL),(2857,11429,40878,216782,2,2857,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',2873139.81,'VENTAS',NULL,1,'2025-08-06 18:01:44','2025-08-06 18:01:44',NULL),(2858,11429,40878,216768,15,2858,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',142796.81,'DJ IVA',NULL,1,'2025-08-07 09:07:27','2025-08-07 09:07:27',NULL),(2859,11429,40878,216769,15,2859,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',182375.09,'DJ IVA',NULL,1,'2025-08-07 09:13:58','2025-08-07 09:13:58',NULL),(2860,11429,40878,216770,15,2860,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',189253.01,'DJ IVA',NULL,1,'2025-08-07 09:16:03','2025-08-07 09:16:03',NULL),(2861,11429,40878,216771,15,2861,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',196634.09,'DJ IVA',NULL,1,'2025-08-07 09:30:15','2025-08-07 09:52:28','2025-08-07 09:52:28'),(2862,11429,40878,216772,15,2862,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',202334.98,'DJ IVA',NULL,1,'2025-08-07 09:37:15','2025-08-07 09:37:15',NULL),(2863,11429,40878,216773,15,2863,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',210833.04,'DJ IVA',NULL,1,'2025-08-07 09:38:11','2025-08-07 09:38:11',NULL),(2864,11429,40878,216774,15,2864,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',218212.20,'DJ IVA',NULL,1,'2025-08-07 09:39:46','2025-08-07 09:39:46',NULL);
INSERT INTO `balance_libro` VALUES (2865,11429,40878,216775,15,2865,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',230599.98,'DJ IVA',NULL,1,'2025-08-07 09:41:21','2025-08-07 09:41:21',NULL),(2866,11429,40878,216779,15,2866,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',229482.43,'DJ IVA',NULL,1,'2025-08-07 09:43:46','2025-08-07 09:43:46',NULL),(2867,11429,40878,216780,15,2867,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',235678.45,'DJ IVA',NULL,1,'2025-08-07 09:44:49','2025-08-07 09:44:49',NULL),(2868,11429,40878,216781,15,2868,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1059863.38,'DJ IVA',NULL,1,'2025-08-07 09:48:50','2025-08-07 10:00:28','2025-08-07 10:00:28'),(2869,11429,40878,216782,15,2869,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',498644.10,'DJ IVA',NULL,1,'2025-08-07 09:50:19','2025-08-07 10:03:57','2025-08-07 10:03:57'),(2870,11429,40878,216771,15,2870,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',196634.09,'DJ IVA',NULL,1,'2025-08-07 09:52:28','2025-08-07 09:52:28',NULL),(2871,11429,40878,216781,15,2871,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1059863.38,'DJ IVA',NULL,1,'2025-08-07 10:00:28','2025-08-07 10:00:28',NULL),(2872,11429,40878,216782,15,2872,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',498644.10,'DJ IVA',NULL,1,'2025-08-07 10:03:57','2025-08-07 10:03:57',NULL),(2873,11429,40878,216768,3,2873,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',883600.00,'COMPRAS',NULL,1,'2025-08-07 10:19:06','2025-08-07 10:19:06',NULL),(2874,11429,40878,216769,3,2874,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1138500.00,'COMPRAS',NULL,1,'2025-08-07 10:20:09','2025-08-07 10:20:09',NULL),(2875,11429,40878,216770,3,2875,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1175951.92,'COMPRAS',NULL,1,'2025-08-07 10:21:09','2025-08-07 10:21:09',NULL),(2876,11429,40878,216771,3,2876,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1175951.92,'COMPRAS',NULL,1,'2025-08-07 10:22:26','2025-08-07 10:26:08','2025-08-07 10:26:08'),(2877,11429,40878,216771,3,2877,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1222048.08,'COMPRAS',NULL,1,'2025-08-07 10:26:08','2025-08-07 10:26:08',NULL),(2878,11429,40878,216772,3,2878,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',140000.00,'COMPRAS',NULL,1,'2025-08-07 10:35:54','2025-08-07 10:35:54',NULL),(2879,11429,40878,216773,3,2879,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',140000.00,'COMPRAS',NULL,1,'2025-08-07 10:37:20','2025-08-07 10:37:20',NULL),(2880,11429,40878,216774,3,2880,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',745000.00,'COMPRAS',NULL,1,'2025-08-07 10:38:12','2025-08-07 10:38:12',NULL),(2881,11429,40878,216775,3,2881,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1485237.98,'COMPRAS',NULL,1,'2025-08-07 10:39:17','2025-08-07 10:39:17',NULL),(2882,11429,40878,216779,3,2882,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',160000.00,'COMPRAS',NULL,1,'2025-08-07 10:39:58','2025-08-07 10:39:58',NULL),(2883,11429,40878,216780,3,2883,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1023420.91,'COMPRAS',NULL,1,'2025-08-07 10:42:09','2025-08-07 10:42:09',NULL);
INSERT INTO `balance_libro` VALUES (2884,11429,40878,216781,3,2884,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',724974.04,'COMPRAS',NULL,1,'2025-08-07 10:44:08','2025-08-07 10:44:08',NULL),(2885,11429,40878,216782,3,2885,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',1471429.09,'COMPRAS',NULL,1,'2025-08-07 10:45:55','2025-08-07 10:45:55',NULL),(2886,11429,40880,274530,5,2886,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',184375.97,'TARJETA DE CREDITO VISA PATAGONIA',NULL,1,'2025-08-07 11:04:37','2025-08-07 11:04:37',NULL),(2887,11429,40880,219801,5,2887,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',203337.69,'TARJETA DE CREDITO VISA PATAGONIA',NULL,1,'2025-08-07 11:07:00','2025-08-07 11:07:00',NULL),(2888,11429,40880,219802,5,2888,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',260267.80,'TARJETA DE CREDITO VISA PATAGONIA',NULL,1,'2025-08-07 11:09:49','2025-08-07 11:09:49',NULL),(2889,11429,40880,219803,5,2889,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',417488.18,'TARJETA DE CREDITO VISA PATAGONIA',NULL,1,'2025-08-07 11:12:08','2025-08-07 11:12:08',NULL),(2890,11429,40880,219804,5,2890,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',208028.28,'TARJETA DE CREDITO VISA PATAGONIA',NULL,1,'2025-08-07 11:13:36','2025-08-07 11:13:36',NULL),(2891,11429,40880,219808,5,2891,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',393420.39,'TARJETA DE CREDITO VISA PATAGONIA',NULL,1,'2025-08-07 11:15:17','2025-08-07 11:15:17',NULL),(2892,11429,40878,216768,16,2892,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',19899.96,'DJ IIBB',NULL,1,'2025-08-07 11:17:00','2025-08-07 11:17:00',NULL),(2893,11429,40880,219809,5,2893,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',265702.03,'TARJETA DE CREDITO VISA PATAGONIA',NULL,1,'2025-08-07 11:17:55','2025-08-07 11:17:55',NULL),(2894,11429,40878,216769,16,2894,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',25500.00,'DJ IIBB',NULL,1,'2025-08-07 11:18:11','2025-08-07 11:18:11',NULL),(2895,11429,40880,219810,5,2895,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',52098.31,'TARJETA DE CREDITO VISA PATAGONIA',NULL,1,'2025-08-07 11:19:26','2025-08-07 11:19:26',NULL),(2896,11429,40878,216770,16,2896,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',26571.00,'DJ IIBB',NULL,1,'2025-08-07 11:23:36','2025-08-07 11:23:36',NULL),(2897,11429,40878,216771,16,2897,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',27793.27,'DJ IIBB',NULL,1,'2025-08-07 11:25:37','2025-08-07 11:25:37',NULL),(2898,11429,40878,216772,16,2898,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',28905.00,'DJ IIBB',NULL,1,'2025-08-07 11:33:27','2025-08-07 11:33:27',NULL),(2899,11429,40878,216773,16,2899,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',30119.91,'DJ IIBB',NULL,1,'2025-08-07 11:34:36','2025-08-07 11:34:36',NULL),(2900,11429,40878,216774,16,2900,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',31173.17,'DJ IIBB',NULL,1,'2025-08-07 11:36:26','2025-08-07 11:36:26',NULL),(2901,11429,40878,216775,16,2901,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',32014.85,'DJ IIBB',NULL,1,'2025-08-07 11:38:13','2025-08-07 11:38:13',NULL);
INSERT INTO `balance_libro` VALUES (2902,11429,40878,216779,16,2902,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',32783.20,'DJ IIBB',NULL,1,'2025-08-07 11:39:25','2025-08-07 11:39:25',NULL),(2903,11429,40878,216780,16,2903,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',33668.35,'DJ IIBB',NULL,1,'2025-08-07 11:41:57','2025-08-07 11:41:57',NULL),(2904,11429,40878,216781,16,2904,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',151409.05,'DJ IIBB',NULL,1,'2025-08-07 11:44:57','2025-08-07 11:44:57',NULL),(2905,11429,40878,216782,16,2905,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',71234.87,'DJ IIBB',NULL,1,'2025-08-07 11:46:27','2025-08-07 11:46:27',NULL),(2906,11429,40880,274526,5,2906,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',667380.80,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 14:51:55','2025-08-07 14:53:16','2025-08-07 14:53:16'),(2907,11429,40880,274526,5,2907,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',667380.80,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 14:53:16','2025-08-07 14:53:16',NULL),(2908,11429,40880,274527,5,2908,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',570781.74,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 14:56:05','2025-08-07 14:56:05',NULL),(2909,11429,40880,274528,5,2909,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',189093.57,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 14:59:48','2025-08-07 14:59:48',NULL),(2910,11429,40880,274529,5,2910,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',877006.20,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 15:03:53','2025-08-07 15:03:53',NULL),(2911,11429,40880,274530,5,2911,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',364456.26,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 16:32:35','2025-08-07 16:32:35',NULL),(2912,11429,40880,219801,5,2912,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',241714.00,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 16:35:36','2025-08-07 16:35:36',NULL),(2913,11429,40880,219802,5,2913,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',307494.31,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 16:54:06','2025-08-07 16:54:06',NULL),(2914,11429,40880,219803,5,2914,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',193130.95,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 16:58:13','2025-08-07 16:58:13',NULL),(2915,11429,40880,219804,5,2915,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',377738.80,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 17:02:55','2025-08-07 17:02:55',NULL),(2916,11429,40880,219808,5,2916,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',212496.43,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 17:06:59','2025-08-07 17:06:59',NULL),(2917,11429,40880,219809,5,2917,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',409631.60,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 17:10:24','2025-08-07 17:10:24',NULL),(2918,11429,40880,219810,5,2918,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',668173.92,'TARJETA DE CREDITO VISA CREDICOOP',NULL,1,'2025-08-07 17:13:03','2025-08-07 17:13:03',NULL);
INSERT INTO `balance_libro` VALUES (2919,11429,40880,274526,5,2919,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',675181.07,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:18:32','2025-08-07 17:18:32',NULL),(2920,11429,40880,274527,5,2920,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',260003.12,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:22:15','2025-08-07 17:22:16',NULL),(2921,11429,40880,274528,5,2921,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',112842.10,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:24:27','2025-08-07 17:24:27',NULL),(2922,11429,40880,274529,5,2922,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',366934.27,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:26:52','2025-08-07 17:26:52',NULL),(2923,11429,40880,274530,5,2923,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',236333.39,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:29:17','2025-08-07 17:29:17',NULL),(2924,11429,40880,219801,5,2924,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',323524.73,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:32:27','2025-08-07 17:32:27',NULL),(2925,11429,40880,219802,5,2925,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',794942.09,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:34:37','2025-08-07 17:34:37',NULL),(2926,11429,40880,219803,5,2926,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',487992.00,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:37:12','2025-08-07 17:37:12',NULL),(2927,11429,40880,219804,5,2927,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',442381.15,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:39:23','2025-08-07 17:39:23',NULL),(2928,11429,40880,219808,5,2928,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',493714.38,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:41:26','2025-08-07 17:41:26',NULL),(2929,11429,40880,219809,5,2929,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',278598.51,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:43:50','2025-08-07 17:43:50',NULL),(2930,11429,40880,219810,5,2930,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',493117.39,'TARJETA DE CREDITO CABAL',NULL,1,'2025-08-07 17:45:57','2025-08-07 17:45:57',NULL),(2931,11429,40878,216768,5,2931,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',773937.87,'BANCO CREDICOOP',NULL,1,'2025-08-07 18:04:01','2025-08-07 18:04:01',NULL),(2932,11429,40878,216769,5,2932,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',984232.18,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:04:47','2025-08-08 09:55:38','2025-08-08 09:55:38'),(2933,11429,40878,216770,5,2933,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1019227.00,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:09:49','2025-08-08 09:09:49',NULL),(2934,11429,40878,216771,5,2934,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1136463.14,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:19:07','2025-08-08 09:19:07',NULL),(2935,11429,40878,216772,5,2935,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1173316.02,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:23:33','2025-08-08 09:23:33',NULL),(2936,11429,40878,216773,5,2936,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1240486.64,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:28:01','2025-08-08 09:28:01',NULL);
INSERT INTO `balance_libro` VALUES (2937,11429,40878,216774,5,2937,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1257317.92,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:33:40','2025-08-08 09:33:40',NULL),(2938,11429,40878,216775,5,2938,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1351265.51,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:37:52','2025-08-08 09:37:52',NULL),(2939,11429,40878,216779,5,2939,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1432255.89,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:42:53','2025-08-08 09:42:53',NULL),(2940,11429,40878,216780,5,2940,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1357956.79,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:45:32','2025-08-08 09:45:32',NULL),(2941,11429,40878,216781,5,2941,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',5378641.77,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:49:06','2025-08-08 09:49:06',NULL),(2942,11429,40878,216782,5,2942,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',4361139.81,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:52:07','2025-08-08 09:52:07',NULL),(2943,11429,40878,216769,5,2943,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',984232.18,'BANCO CREDICOOP',NULL,1,'2025-08-08 09:55:38','2025-08-08 09:55:38',NULL),(2944,11429,40880,219810,5,2944,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',112388.95,'prestamo banco credicoop',NULL,1,'2025-08-08 12:34:40','2025-08-08 12:34:40',NULL),(2945,11429,40880,219810,5,2945,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2425401.77,'Prestamos Banco Nacion 1',NULL,1,'2025-08-08 12:40:09','2025-08-08 12:40:09',NULL),(2946,11429,40880,219810,5,2946,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1361389.97,'Prestamo Banco Patagonia',NULL,1,'2025-08-08 12:44:36','2025-08-08 12:44:36',NULL),(2947,11429,40880,219810,5,2947,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',379517.46,'Prestamo Banco Nacion 2',NULL,1,'2025-08-08 12:46:22','2025-08-08 12:46:22',NULL),(2948,11429,40880,274526,5,2948,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2456679.44,'Banco Patagonia',NULL,1,'2025-08-08 13:06:02','2025-08-08 13:08:15','2025-08-08 13:08:15'),(2949,11429,40880,274526,5,2949,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2456679.44,'Banco Patagonia',NULL,1,'2025-08-08 13:08:15','2025-08-08 13:08:15',NULL),(2950,11429,40880,274527,5,2950,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',6876354.73,'Banco Patagonia',NULL,1,'2025-08-08 13:16:34','2025-08-08 13:16:34',NULL),(2951,11429,40880,274526,5,2951,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',985000.00,'Banco Nacion cta cte',NULL,1,'2025-08-08 13:20:41','2025-08-08 13:20:41',NULL),(2952,11429,40880,274528,5,2952,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1719442.97,'Banco Patagonia',NULL,1,'2025-08-08 13:20:52','2025-08-08 13:20:52',NULL),(2953,11429,40880,274529,5,2953,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',5972933.28,'Banco Patagonia',NULL,1,'2025-08-08 13:25:16','2025-08-08 13:25:16',NULL),(2954,11429,40880,274527,5,2954,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',4293600.00,'Banco Nacion cta cte',NULL,1,'2025-08-08 13:27:48','2025-08-08 13:27:48',NULL);
INSERT INTO `balance_libro` VALUES (2955,11429,40880,274530,5,2955,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',11316811.39,'Banco Patagonia',NULL,1,'2025-08-08 13:30:26','2025-08-08 13:30:26',NULL),(2956,11429,40880,274528,5,2956,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',2528355.09,'Banco Nacion cta cte',NULL,1,'2025-08-08 13:33:13','2025-08-08 13:33:13',NULL),(2957,11429,40880,274526,5,2957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',12214273.99,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 13:34:26','2025-08-08 13:34:26',NULL),(2958,11429,40880,219801,5,2958,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',15376816.46,'Banco Patagonia',NULL,1,'2025-08-08 13:36:24','2025-08-08 13:36:24',NULL),(2959,11429,40880,274529,5,2959,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2956855.92,'Banco Nacion cta cte',NULL,1,'2025-08-08 13:39:33','2025-08-08 13:39:33',NULL),(2960,11429,40880,219802,5,2960,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',9284565.88,'Banco Patagonia',NULL,1,'2025-08-08 13:42:31','2025-08-08 13:42:31',NULL),(2961,11429,40880,274530,5,2961,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',684584.52,'Banco Nacion cta cte',NULL,1,'2025-08-08 13:44:27','2025-08-08 13:44:27',NULL),(2962,11429,40880,219803,5,2962,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',9700582.49,'Banco Patagonia',NULL,1,'2025-08-08 13:49:01','2025-08-08 13:49:01',NULL),(2963,11429,40880,219804,5,2963,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',6800633.72,'Banco Patagonia',NULL,1,'2025-08-08 13:54:59','2025-08-08 13:54:59',NULL),(2964,11429,40880,219801,5,2964,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',462003.04,'Banco Nacion cta cte',NULL,1,'2025-08-08 13:59:32','2025-08-08 13:59:32',NULL),(2965,11429,40880,219808,5,2965,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',5582613.63,'Banco Patagonia',NULL,1,'2025-08-08 14:00:36','2025-08-08 14:00:36',NULL),(2966,11429,40880,219809,5,2966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',2328600.00,'Banco Patagonia',NULL,1,'2025-08-08 14:04:52','2025-08-08 14:04:52',NULL),(2967,11429,40880,219802,5,2967,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',385975.62,'Banco Nacion cta cte',NULL,1,'2025-08-08 14:05:55','2025-08-08 14:05:55',NULL),(2968,11429,40880,219810,5,2968,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',3201554.14,'Banco Patagonia',NULL,1,'2025-08-08 14:09:14','2025-08-08 14:09:14',NULL),(2969,11429,40880,274527,5,2969,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',15613599.06,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 14:11:24','2025-08-08 14:11:24',NULL),(2970,11429,40880,219803,5,2970,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',713875.07,'Banco Nacion cta cte',NULL,1,'2025-08-08 14:23:54','2025-08-08 14:23:54',NULL),(2971,11429,40880,219804,5,2971,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',5594565.47,'Banco Nacion cta cte',NULL,1,'2025-08-08 14:31:06','2025-08-08 14:31:06',NULL),(2972,11429,40880,274528,5,2972,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',20961963.49,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 14:32:29','2025-08-08 14:32:29',NULL);
INSERT INTO `balance_libro` VALUES (2973,11429,40880,219808,5,2973,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',2664784.62,'Banco Nacion cta cte',NULL,1,'2025-08-08 14:36:03','2025-08-08 14:36:03',NULL),(2974,11429,40880,274529,5,2974,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',21292864.54,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 14:45:22','2025-08-08 14:45:22',NULL),(2975,11429,40880,219809,5,2975,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',17768973.02,'Banco Nacion cta cte',NULL,1,'2025-08-08 14:47:51','2025-08-08 14:47:51',NULL),(2976,11429,40880,219810,5,2976,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2518998.79,'Banco Nacion cta cte',NULL,1,'2025-08-08 15:02:19','2025-08-08 15:02:19',NULL),(2977,11429,40880,274526,5,2977,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',143145.48,'Banco Credicoop 0720204351',NULL,1,'2025-08-08 15:23:40','2025-08-08 15:23:40',NULL),(2978,11429,40880,274527,5,2978,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',72698.59,'Banco Credicoop 0720204351',NULL,1,'2025-08-08 15:32:11','2025-08-08 15:32:11',NULL),(2979,11429,40880,274528,5,2979,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',330562.00,'Banco Credicoop 0720204351',NULL,1,'2025-08-08 15:37:26','2025-08-08 15:37:26',NULL),(2980,11429,40880,274530,5,2980,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',23704416.98,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 15:40:58','2025-08-08 15:40:58',NULL),(2981,11429,40880,274529,5,2981,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',255956.12,'Banco Credicoop 0720204351',NULL,1,'2025-08-08 15:44:26','2025-08-08 15:44:26',NULL),(2982,11429,40880,274530,5,2982,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',764835.51,'Banco Credicoop 0720204351',NULL,1,'2025-08-08 15:48:14','2025-08-08 15:48:14',NULL),(2983,11429,40880,219802,5,2983,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1776000.00,'BANCO CREDICOOP 202043',NULL,1,'2025-08-08 15:50:40','2025-08-08 15:50:40',NULL),(2984,11429,40880,219801,5,2984,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',711706.51,'Banco Credicoop 0720204351',NULL,1,'2025-08-08 15:54:12','2025-08-08 15:54:12',NULL),(2985,11429,40880,219803,5,2985,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',11521661.87,'BANCO CREDICOOP 202043',NULL,1,'2025-08-08 15:56:56','2025-08-08 15:56:56',NULL),(2986,11429,40880,219801,5,2986,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',23695370.26,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 15:58:08','2025-08-08 15:58:08',NULL),(2987,11429,40880,219804,5,2987,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2592564.44,'BANCO CREDICOOP 202043',NULL,1,'2025-08-08 16:02:14','2025-08-08 16:02:14',NULL),(2988,11429,40880,219808,5,2988,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',570000.00,'BANCO CREDICOOP 202043',NULL,1,'2025-08-08 16:07:00','2025-08-08 16:07:00',NULL),(2989,11429,40880,219809,5,2989,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',3801754.47,'BANCO CREDICOOP 202043',NULL,1,'2025-08-08 16:11:39','2025-08-08 16:11:39',NULL),(2990,11429,40880,219810,5,2990,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',4146031.74,'BANCO CREDICOOP 202043',NULL,1,'2025-08-08 16:18:22','2025-08-08 16:18:22',NULL);
INSERT INTO `balance_libro` VALUES (2991,11429,40880,219802,5,2991,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',31534052.28,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 16:18:53','2025-08-08 16:18:53',NULL),(2992,11429,40880,219804,5,2992,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',24762501.65,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 16:19:44','2025-08-08 16:19:44',NULL),(2993,11429,40880,219808,5,2993,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',28064363.16,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 16:26:18','2025-08-08 16:26:19',NULL),(2994,11429,40880,219803,5,2994,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',27294203.85,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 16:32:44','2025-08-08 16:32:44',NULL),(2995,11429,40880,219809,5,2995,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45425202.23,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 16:33:02','2025-08-08 16:33:02',NULL),(2996,11429,40880,219810,5,2996,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',33690426.40,'BANCO CREDICOOP 0720149735',NULL,1,'2025-08-08 16:41:57','2025-08-08 16:41:57',NULL),(2997,11429,40878,216768,12,2997,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',243595295.00,'Asiento de inicio',NULL,1,'2025-08-15 12:42:37','2025-08-22 15:28:00','2025-08-22 15:28:00'),(2998,11429,40941,274531,3,2998,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',150000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 09:26:09','2025-08-20 09:26:09',NULL),(2999,11429,40941,274532,3,2999,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',270200.00,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 09:42:07','2025-08-20 09:42:07',NULL),(3000,11429,40941,274533,3,3000,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',139000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 09:59:19','2025-08-20 09:59:19',NULL),(3001,11429,40941,274534,3,3001,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',150000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 10:04:34','2025-08-20 10:04:34',NULL),(3002,11429,40941,274538,3,3002,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',180000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 10:05:57','2025-08-20 10:05:57',NULL),(3003,11429,40941,274546,3,3003,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',180000.00,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 10:07:24','2025-08-20 10:07:24',NULL),(3004,11429,40941,274547,3,3004,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',872882.82,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 10:09:26','2025-08-20 10:09:26',NULL),(3005,11429,40941,274548,3,3005,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',872882.82,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 10:12:07','2025-08-21 11:40:33','2025-08-21 11:40:33'),(3006,11429,40941,274549,3,3006,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',889220.24,'SUBDIARIO COMPRAS',NULL,1,'2025-08-20 10:15:59','2025-08-20 10:15:59',NULL),(3007,11429,40941,274532,15,3007,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',25200.00,'DJ IVA',NULL,1,'2025-08-20 11:50:09','2025-08-20 11:50:09',NULL),(3008,11429,40941,274533,15,3008,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',28875.91,'DJ IVA',NULL,1,'2025-08-20 12:01:26','2025-08-20 12:01:26',NULL);
INSERT INTO `balance_libro` VALUES (3009,11429,40941,274534,15,3009,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',28875.91,'DJ IVA',NULL,1,'2025-08-20 12:08:28','2025-08-20 12:08:28',NULL),(3010,11429,40941,274535,15,3010,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',28875.91,'DJ IVA',NULL,1,'2025-08-20 12:13:01','2025-08-20 12:13:01',NULL),(3011,11429,40941,274536,15,3011,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',28875.91,'DJ IVA',NULL,1,'2025-08-20 12:17:19','2025-08-20 12:17:19',NULL),(3012,11429,40941,274537,15,3012,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',29385.91,'DJ IVA',NULL,1,'2025-08-20 12:25:44','2025-08-20 12:25:44',NULL),(3013,11429,40941,274538,15,3013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',29985.91,'DJ IVA',NULL,1,'2025-08-20 12:35:33','2025-08-20 12:35:33',NULL),(3014,11429,40941,274546,15,3014,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',30585.91,'DJ IVA',NULL,1,'2025-08-20 12:41:01','2025-08-20 12:41:01',NULL),(3015,11429,40941,274547,15,3015,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',78665.74,'DJ IVA',NULL,1,'2025-08-20 12:53:12','2025-08-20 12:53:12',NULL),(3016,11429,40941,274548,15,3016,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',127549.57,'DJ IVA',NULL,1,'2025-08-20 13:01:02','2025-08-20 13:01:02',NULL),(3017,11429,40941,274549,15,3017,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',179077.37,'DJ IVA',NULL,1,'2025-08-20 13:08:20','2025-08-20 13:08:20',NULL),(3018,11429,40878,216768,6,3018,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',217839.02,'DJ Ganancias',NULL,1,'2025-08-20 15:23:44','2025-08-20 15:23:44',NULL),(3019,11429,40941,274533,16,3019,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3675.91,'DJ IIBB',NULL,1,'2025-08-20 16:31:50','2025-08-20 16:31:50',NULL),(3020,11429,40941,274534,16,3020,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',3675.91,'DJ IIBB',NULL,1,'2025-08-20 16:41:14','2025-08-20 16:41:14',NULL),(3021,11429,40941,274535,16,3021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',3675.91,'DJ IIBB',NULL,1,'2025-08-20 16:43:02','2025-08-20 16:43:02',NULL),(3022,11429,40941,274536,16,3022,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',3675.91,'DJ IIBB',NULL,1,'2025-08-20 16:46:14','2025-08-20 16:46:14',NULL),(3023,11429,40941,274537,16,3023,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',3675.91,'DJ IIBB',NULL,1,'2025-08-20 16:47:58','2025-08-20 16:47:58',NULL),(3024,11429,40941,274538,16,3024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',17675.91,'DJ IIBB',NULL,1,'2025-08-20 16:55:56','2025-08-20 16:55:56',NULL),(3025,11429,40941,274546,16,3025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',17675.91,'DJ IIBB',NULL,1,'2025-08-20 17:06:03','2025-08-20 17:06:03',NULL),(3026,11429,40941,274547,16,3026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',17675.91,'DJ IIBB',NULL,1,'2025-08-20 17:08:13','2025-08-20 17:08:13',NULL),(3027,11429,40941,274548,16,3027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',58479.91,'DJ IIBB',NULL,1,'2025-08-20 17:15:26','2025-09-01 16:10:58','2025-09-01 16:10:58');
INSERT INTO `balance_libro` VALUES (3028,11429,40941,274549,16,3028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',118692.46,'DJ IIBB',NULL,1,'2025-08-20 17:20:49','2025-08-20 17:20:49',NULL),(3029,11429,40941,274548,3,3029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',899682.89,'SUBDIARIO COMPRAS',NULL,1,'2025-08-21 11:40:33','2025-08-21 11:40:33',NULL),(3030,11429,40941,274531,12,3030,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',30000000.00,'ASIENTO INICIO',NULL,1,'2025-08-21 15:34:31','2025-08-21 15:34:31',NULL),(3031,11429,40878,216768,12,3031,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',243595295.00,'Asiento de inicio',NULL,1,'2025-08-22 15:28:00','2025-08-22 15:28:00',NULL),(3032,11429,40941,274532,5,3032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1.08,'BANCO CREDICOOP',NULL,1,'2025-08-27 13:04:54','2025-08-27 13:04:54',NULL),(3033,11429,40941,274533,5,3033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1187501.00,'BANCO CREDICOOP',NULL,1,'2025-08-27 13:35:44','2025-08-27 13:35:44',NULL),(3034,11429,40941,274535,5,3034,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',164109.79,'BANCO CREDICOOP',NULL,1,'2025-08-27 13:47:08','2025-08-27 13:47:08',NULL),(3035,11429,40941,274536,5,3035,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',244589.79,'BANCO CREDICOOP',NULL,1,'2025-08-27 13:54:20','2025-08-27 13:54:20',NULL),(3036,11429,40941,274537,5,3036,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',700000.00,'BANCO CREDICOOP',NULL,1,'2025-08-27 14:02:09','2025-08-27 14:02:09',NULL),(3037,11429,40941,274538,5,3037,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',700000.00,'BANCO CREDICOOP',NULL,1,'2025-08-27 14:07:01','2025-08-27 14:07:01',NULL),(3038,11429,40941,274534,5,3038,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',836061.36,'BANCO CREDICOOP',NULL,1,'2025-08-27 14:09:38','2025-08-27 14:11:46','2025-08-27 14:11:46'),(3039,11429,40941,274534,5,3039,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',526061.36,'BANCO CREDICOOP',NULL,1,'2025-08-27 14:11:46','2025-08-27 14:11:46',NULL),(3040,11429,40941,274546,5,3040,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',405036.73,'BANCO CREDICOOP',NULL,1,'2025-08-27 15:02:16','2025-08-27 15:02:16',NULL),(3041,11429,40941,274547,5,3041,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',47866.49,'BANCO CREDICOOP',NULL,1,'2025-08-27 15:06:36','2025-08-27 15:06:36',NULL),(3042,11429,40941,274548,5,3042,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2000000.00,'BANCO CREDICOOP',NULL,1,'2025-08-27 15:11:41','2025-08-27 15:11:41',NULL),(3043,11429,40941,274549,5,3043,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',3088246.83,'BANCO CREDICOOP',NULL,1,'2025-08-27 15:15:15','2025-08-27 15:15:15',NULL),(3044,7941,40915,272954,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',80000.00,NULL,NULL,1,'2025-08-28 13:32:20','2025-08-28 13:32:20',NULL),(3045,7941,40915,272954,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',100000.00,NULL,NULL,1,'2025-08-28 13:32:21','2025-08-28 13:32:21',NULL),(3046,7941,40915,272954,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',180000.00,NULL,NULL,1,'2025-08-28 13:32:22','2025-08-28 13:32:22',NULL);
INSERT INTO `balance_libro` VALUES (3047,7941,40915,272954,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',330000.00,NULL,NULL,1,'2025-08-28 13:32:24','2025-08-28 13:32:24',NULL),(3048,7941,40915,272954,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',170000.00,NULL,NULL,1,'2025-08-28 13:32:25','2025-08-28 13:32:25',NULL),(3049,7941,40915,272954,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',40000.00,NULL,NULL,1,'2025-08-28 13:34:41','2025-08-28 13:34:41',NULL),(3050,7941,40915,272954,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',280000.00,NULL,NULL,1,'2025-08-28 13:34:43','2025-08-28 13:34:43',NULL),(3051,7941,40915,272954,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',200000.00,NULL,NULL,1,'2025-08-28 13:34:44','2025-08-28 13:34:44',NULL),(3052,7941,40915,272954,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',500000.00,NULL,NULL,1,'2025-08-28 13:34:45','2025-08-28 13:34:45',NULL),(3053,7941,40915,272954,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',210000.00,NULL,NULL,1,'2025-08-28 13:34:46','2025-08-28 13:34:46',NULL),(3054,7941,40915,272954,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-08-28 13:34:48','2025-08-28 13:34:48',NULL),(3055,7941,40915,272954,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-08-28 13:34:49','2025-08-28 13:34:49',NULL),(3056,7941,40915,272954,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',70000.00,NULL,NULL,1,'2025-08-28 13:34:50','2025-08-28 13:34:50',NULL),(3057,7941,40915,272954,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',890000.00,NULL,NULL,1,'2025-08-28 13:45:40','2025-08-28 13:45:40',NULL),(3058,7941,40719,55,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',960000.00,NULL,NULL,1,'2025-08-28 15:17:41','2025-08-28 15:17:41',NULL),(3059,7941,40719,55,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',770000.00,NULL,NULL,1,'2025-08-28 15:17:42','2025-08-28 15:17:42',NULL),(3060,7941,40719,55,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',200000.00,NULL,NULL,1,'2025-08-28 15:17:44','2025-08-28 15:17:44',NULL),(3061,7941,40719,55,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',280000.00,NULL,NULL,1,'2025-08-28 15:17:45','2025-08-28 15:17:45',NULL),(3062,7941,40719,55,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',190000.00,NULL,NULL,1,'2025-08-28 15:17:46','2025-08-28 15:17:46',NULL),(3063,7941,40719,55,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',190000.00,NULL,NULL,1,'2025-08-28 15:19:07','2025-08-28 15:19:07',NULL),(3064,7941,40719,55,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',140000.00,NULL,NULL,1,'2025-08-28 15:19:08','2025-08-28 15:19:08',NULL),(3065,7941,40719,55,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',100000.00,NULL,NULL,1,'2025-08-28 15:19:09','2025-08-28 15:19:09',NULL),(3066,7941,40719,55,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',240000.00,NULL,NULL,1,'2025-08-28 15:19:10','2025-08-28 15:19:10',NULL),(3067,7941,40719,55,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',210000.00,NULL,NULL,1,'2025-08-28 15:19:11','2025-08-28 15:19:11',NULL);
INSERT INTO `balance_libro` VALUES (3068,7941,40719,55,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',605000.00,NULL,NULL,1,'2025-08-28 15:19:13','2025-08-28 15:19:13',NULL),(3069,7941,40719,55,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',280000.00,NULL,NULL,1,'2025-08-28 15:19:14','2025-08-28 15:19:14',NULL),(3070,7941,40719,55,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',250000.00,NULL,NULL,1,'2025-08-28 15:19:15','2025-08-28 15:19:15',NULL),(3071,7941,40719,55,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',350000.00,NULL,NULL,1,'2025-08-28 15:19:16','2025-08-28 15:19:16',NULL),(3072,7941,40719,55,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',50000.00,NULL,NULL,1,'2025-08-28 15:19:17','2025-08-28 15:19:17',NULL),(3073,NULL,40915,272954,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',80000.00,NULL,NULL,1,'2025-08-29 12:54:43','2025-08-29 12:54:43',NULL),(3074,NULL,40915,272954,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',100000.00,NULL,NULL,1,'2025-08-29 12:54:44','2025-08-29 12:54:44',NULL),(3075,NULL,40915,272954,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',180000.00,NULL,NULL,1,'2025-08-29 12:54:45','2025-08-29 12:54:45',NULL),(3076,NULL,40915,272954,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',330000.00,NULL,NULL,1,'2025-08-29 12:54:46','2025-08-29 12:54:46',NULL),(3077,NULL,40915,272954,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',170000.00,NULL,NULL,1,'2025-08-29 12:54:47','2025-08-29 12:54:47',NULL),(3078,NULL,40915,272954,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',40000.00,NULL,NULL,1,'2025-08-29 12:54:48','2025-08-29 12:54:48',NULL),(3079,NULL,40915,272954,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',280000.00,NULL,NULL,1,'2025-08-29 12:54:49','2025-08-29 12:54:49',NULL),(3080,NULL,40915,272954,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',200000.00,NULL,NULL,1,'2025-08-29 12:54:50','2025-08-29 12:54:50',NULL),(3081,NULL,40915,272954,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',500000.00,NULL,NULL,1,'2025-08-29 12:54:52','2025-08-29 12:54:52',NULL),(3082,NULL,40915,272954,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',210000.00,NULL,NULL,1,'2025-08-29 12:54:53','2025-08-29 12:54:53',NULL),(3083,NULL,40915,272954,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-08-29 12:54:54','2025-08-29 12:54:54',NULL),(3084,NULL,40915,272954,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-08-29 12:54:55','2025-08-29 12:54:55',NULL),(3085,NULL,40915,272954,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',70000.00,NULL,NULL,1,'2025-08-29 12:54:56','2025-08-29 12:54:56',NULL),(3086,NULL,40915,272954,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',80000.00,NULL,NULL,1,'2025-08-29 12:54:58','2025-08-29 12:54:58',NULL),(3087,NULL,40915,272954,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',100000.00,NULL,NULL,1,'2025-08-29 12:55:00','2025-08-29 12:55:00',NULL),(3088,NULL,40915,272954,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',180000.00,NULL,NULL,1,'2025-08-29 12:55:01','2025-08-29 12:55:01',NULL);
INSERT INTO `balance_libro` VALUES (3089,NULL,40915,272954,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',330000.00,NULL,NULL,1,'2025-08-29 12:55:02','2025-08-29 12:55:02',NULL),(3090,NULL,40915,272954,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',170000.00,NULL,NULL,1,'2025-08-29 12:55:03','2025-08-29 12:55:03',NULL),(3091,NULL,40915,272954,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',40000.00,NULL,NULL,1,'2025-08-29 12:55:04','2025-08-29 12:55:04',NULL),(3092,NULL,40915,272954,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',280000.00,NULL,NULL,1,'2025-08-29 12:55:05','2025-08-29 12:55:05',NULL),(3093,NULL,40915,272954,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',200000.00,NULL,NULL,1,'2025-08-29 12:55:07','2025-08-29 12:55:07',NULL),(3094,NULL,40915,272954,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',500000.00,NULL,NULL,1,'2025-08-29 12:55:07','2025-08-29 12:55:07',NULL),(3095,NULL,40915,272954,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',210000.00,NULL,NULL,1,'2025-08-29 12:55:08','2025-08-29 12:55:08',NULL),(3096,NULL,40915,272954,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-08-29 12:55:10','2025-08-29 12:55:10',NULL),(3097,NULL,40915,272954,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-08-29 12:55:11','2025-08-29 12:55:11',NULL),(3098,NULL,40915,272954,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',70000.00,NULL,NULL,1,'2025-08-29 12:55:12','2025-08-29 12:55:12',NULL),(3099,11429,40879,218291,1,3099,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',57113296.09,'SUELDOS',NULL,1,'2025-09-01 13:18:15','2025-09-01 13:18:15',NULL),(3100,11429,40879,218292,1,3100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',45684549.00,'SUELDOS',NULL,1,'2025-09-01 13:23:43','2025-09-01 13:23:43',NULL),(3101,11429,40879,218293,1,3101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',44386142.75,'SUELDOS',NULL,1,'2025-09-01 13:38:56','2025-09-01 13:38:56',NULL),(3102,11429,40879,218294,1,3102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',46508634.44,'SUELDOS',NULL,1,'2025-09-01 13:44:16','2025-09-01 13:44:16',NULL),(3103,11429,40879,218295,1,3103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',50176646.60,'SUELDOS',NULL,1,'2025-09-01 13:58:18','2025-09-01 13:58:18',NULL),(3104,11429,40879,218296,1,3104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',49993312.21,'SUELDOS',NULL,1,'2025-09-01 14:18:15','2025-09-01 14:18:15',NULL),(3105,11429,40879,218297,1,3105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',79669471.74,'SUELDOS',NULL,1,'2025-09-01 14:25:05','2025-09-01 14:25:05',NULL),(3106,11429,40879,218301,1,3106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',53929974.57,'SUELDOS',NULL,1,'2025-09-01 14:28:41','2025-09-01 14:28:41',NULL),(3107,11429,40879,218302,1,3107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',55970787.99,'SUELDOS',NULL,1,'2025-09-01 14:39:53','2025-09-01 14:39:53',NULL),(3108,11429,40879,218303,1,3108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',56415802.77,'SUELDOS',NULL,1,'2025-09-01 14:42:46','2025-09-01 14:42:46',NULL);
INSERT INTO `balance_libro` VALUES (3109,11429,40941,274548,5,3109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',58479.91,'DJ IIBB',NULL,1,'2025-09-01 16:10:58','2025-09-01 16:10:58',NULL),(3110,11429,40879,218291,15,3110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',36897595.00,'DJ IVA',NULL,1,'2025-09-01 17:10:24','2025-09-01 17:10:24',NULL),(3111,11429,40879,218292,15,3111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',34737669.18,'DJ IVA',NULL,1,'2025-09-01 17:18:34','2025-09-01 17:18:34',NULL),(3112,11429,40879,218293,15,3112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',41855904.57,'DJ IVA',NULL,1,'2025-09-01 17:26:24','2025-09-01 17:26:24',NULL),(3113,11429,40879,218294,15,3113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',39551953.35,'DJ IVA',NULL,1,'2025-09-01 17:32:46','2025-09-01 17:32:46',NULL),(3114,11429,40879,218295,15,3114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',42863733.58,'DJ IVA',NULL,1,'2025-09-01 17:38:07','2025-09-01 17:38:07',NULL),(3115,11429,40879,218296,15,3115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',45999753.35,'DJ IVA',NULL,1,'2025-09-01 17:43:45','2025-09-01 17:43:45',NULL),(3116,11429,40879,218297,15,3116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',48525022.64,'DJ IVA',NULL,1,'2025-09-01 17:51:39','2025-09-01 17:51:39',NULL),(3117,11429,40879,218301,15,3117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',46366839.41,'DJ IVA',NULL,1,'2025-09-01 18:04:21','2025-09-01 18:04:21',NULL),(3118,11429,40879,218302,15,3118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',48095074.00,'DJ IVA',NULL,1,'2025-09-01 18:11:01','2025-09-01 18:11:01',NULL),(3119,11429,40879,218304,1,3119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',57409578.10,'SUELDOS',NULL,1,'2025-09-02 09:03:46','2025-09-02 09:03:46',NULL),(3120,11429,40879,218305,1,3120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',62970844.86,'SUELDOS',NULL,1,'2025-09-02 10:57:05','2025-09-02 10:57:05',NULL),(3121,11429,40945,276071,16,3121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',255717.63,'IIBB',NULL,1,'2025-09-02 13:55:34','2025-09-02 13:55:34',NULL),(3122,11429,40945,276072,16,3122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',357336.95,'IIBB',NULL,1,'2025-09-02 13:59:52','2025-09-02 13:59:52',NULL),(3123,11429,40945,276068,15,3123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',52549.97,'DJ IVA',NULL,1,'2025-09-02 14:43:47','2025-09-02 14:43:47',NULL),(3124,11429,40945,276069,15,3124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',8028037.96,'DJ IVA',NULL,1,'2025-09-02 14:50:41','2025-09-02 14:50:41',NULL),(3125,11429,40945,276070,15,3125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',8345962.62,'DJ IVA',NULL,1,'2025-09-02 14:57:41','2025-09-02 14:57:41',NULL),(3126,11429,40945,276071,15,3126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',8728144.39,'DJ IVA',NULL,1,'2025-09-02 15:04:47','2025-09-02 15:04:47',NULL),(3127,11429,40945,276072,15,3127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',7531951.43,'DJ IVA',NULL,1,'2025-09-02 15:08:43','2025-09-02 15:08:43',NULL);
INSERT INTO `balance_libro` VALUES (3128,11429,40945,276071,2,3128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',9020295.67,'ventas',NULL,1,'2025-09-02 15:14:44','2025-09-02 15:14:44',NULL),(3129,11429,40945,276072,2,3129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',7546218.19,'ventas',NULL,1,'2025-09-02 15:38:46','2025-09-02 15:38:46',NULL),(3130,11429,40945,276068,3,3130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1574716.32,'COMPRAS',NULL,1,'2025-09-02 15:52:16','2025-09-10 15:40:30','2025-09-10 15:40:30'),(3131,11429,40945,276069,3,3131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',30854910.03,'COMPRAS',NULL,1,'2025-09-02 15:56:41','2025-09-10 12:17:10','2025-09-10 12:17:10'),(3132,11429,40945,276070,3,3132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-02','2025-03-02',3517167.96,'COMPRAS',NULL,1,'2025-09-02 16:07:52','2025-09-10 15:36:28','2025-09-10 15:36:28'),(3133,11429,40945,276071,3,3133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',2494686.09,'compras',NULL,1,'2025-09-02 16:12:01','2025-09-10 15:35:37','2025-09-10 15:35:37'),(3134,11429,40945,276072,3,3134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',3909371.03,'COMPRAS',NULL,1,'2025-09-02 16:16:15','2025-09-10 15:34:56','2025-09-10 15:34:56'),(3135,11429,40945,276073,3,3135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',3686438.34,'COMPRAS',NULL,1,'2025-09-02 16:18:49','2025-09-10 15:34:14','2025-09-10 15:34:14'),(3136,11429,40945,276074,3,3136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',33627903.55,'COMPRAS',NULL,1,'2025-09-02 16:23:49','2025-09-10 15:34:04','2025-09-10 15:34:04'),(3137,11429,40879,218303,15,3137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',49346606.70,'DJ IVA',NULL,1,'2025-09-02 17:01:36','2025-09-02 17:01:36',NULL),(3138,11429,40879,218304,15,3138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',47725350.33,'DJ IVA',NULL,1,'2025-09-02 17:10:05','2025-09-02 17:10:05',NULL),(3139,11429,40879,218305,15,3139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',77841449.15,'DJ IVA',NULL,1,'2025-09-02 17:22:19','2025-09-02 17:22:19',NULL),(3140,11429,40879,218291,2,3140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',212600428.34,'SUBDIARIO VENTAS',NULL,1,'2025-09-02 17:33:44','2025-09-02 21:10:18','2025-09-02 21:10:18'),(3141,11429,40879,218292,2,3141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',200155141.46,'VENTAS',NULL,1,'2025-09-02 17:48:34','2025-09-02 17:48:34',NULL),(3142,11429,40879,218293,2,3142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',241169735.85,'VENTAS',NULL,1,'2025-09-02 17:54:42','2025-09-02 17:54:42',NULL),(3143,11429,40879,218291,2,3143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',212600428.34,'VENTAS',NULL,1,'2025-09-02 21:10:18','2025-09-02 21:10:18',NULL),(3144,11429,40879,218294,2,3144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',227894588.33,'VENTAS',NULL,1,'2025-09-02 21:23:00','2025-09-02 21:23:00',NULL),(3145,11429,40879,218295,2,3145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',247160773.63,'VENTAS',NULL,1,'2025-09-02 21:26:00','2025-09-02 21:26:00',NULL);
INSERT INTO `balance_libro` VALUES (3146,11429,40879,218296,2,3146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',264862174.86,'VENTAS',NULL,1,'2025-09-02 21:28:56','2025-09-02 21:28:56',NULL),(3147,11429,40879,218297,2,3147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',279596559.03,'VENTAS',NULL,1,'2025-09-02 21:35:00','2025-09-02 21:35:00',NULL),(3148,11429,40879,218301,2,3148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',267161312.80,'VENTAS',NULL,1,'2025-09-02 21:45:54','2025-09-02 21:45:54',NULL),(3149,11429,40879,218302,2,3149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',267445955.27,'VENTAS',NULL,1,'2025-09-02 21:56:14','2025-09-02 21:56:14',NULL),(3150,11429,40879,218303,2,3150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',284330448.13,'VENTAS',NULL,1,'2025-09-02 22:00:14','2025-09-02 22:00:14',NULL),(3151,11429,40879,218304,2,3151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',274988923.33,'VENTAS',NULL,1,'2025-09-02 22:02:51','2025-09-02 22:02:51',NULL),(3152,11429,40879,218305,2,3152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',286348592.78,'VENTAS',NULL,1,'2025-09-02 22:06:42','2025-09-02 22:06:42',NULL),(3153,11429,40879,218291,16,3153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',7695686.14,'DJ IIBB',NULL,1,'2025-09-04 10:54:21','2025-09-04 10:54:21',NULL),(3154,11429,40879,218292,16,3154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6820216.17,'DJ IIBB',NULL,1,'2025-09-04 11:39:49','2025-09-04 11:39:49',NULL),(3155,7941,40915,272954,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',280000.00,NULL,NULL,1,'2025-09-04 11:54:41','2025-09-04 11:54:41',NULL),(3156,7941,40915,272954,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',280000.00,NULL,NULL,1,'2025-09-04 11:56:42','2025-09-04 11:56:42',NULL),(3157,11429,40879,218293,16,3157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',7141152.61,'DJ IIBB',NULL,1,'2025-09-04 11:58:08','2025-09-04 11:58:08',NULL),(3158,7941,40915,272954,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',100000.00,NULL,NULL,1,'2025-09-04 12:07:59','2025-09-04 12:07:59',NULL),(3159,7941,40915,272954,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',100000.00,NULL,NULL,1,'2025-09-04 12:09:01','2025-09-04 12:09:01',NULL),(3160,11429,40879,218294,16,3160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',7303832.76,'DJ IIBB',NULL,1,'2025-09-04 12:09:36','2025-09-04 12:09:36',NULL),(3161,7941,40915,272954,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',500000.00,NULL,NULL,1,'2025-09-04 12:11:32','2025-09-04 12:11:32',NULL),(3162,7941,40915,272954,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',500000.00,NULL,NULL,1,'2025-09-04 12:12:39','2025-09-04 12:12:39',NULL),(3163,7941,40915,272954,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',170000.00,NULL,NULL,1,'2025-09-04 12:15:57','2025-09-04 12:15:57',NULL),(3164,11429,40879,218295,16,3164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',6946201.51,'DJ IIBB',NULL,1,'2025-09-04 12:16:07','2025-09-04 12:16:07',NULL),(3165,7941,40915,272954,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',170000.00,NULL,NULL,1,'2025-09-04 12:21:28','2025-09-04 12:21:28',NULL);
INSERT INTO `balance_libro` VALUES (3166,7941,40915,272954,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',330000.00,NULL,NULL,1,'2025-09-04 12:31:12','2025-09-04 12:31:12',NULL),(3167,11429,40879,218296,16,3167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',8963920.89,'DJ IIBB',NULL,1,'2025-09-04 12:37:48','2025-09-04 12:37:48',NULL),(3168,7941,40915,272954,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',330000.00,NULL,NULL,1,'2025-09-04 12:42:44','2025-09-04 12:42:44',NULL),(3169,11429,40879,218297,16,3169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',11370748.34,'DJ IIBB',NULL,1,'2025-09-04 12:47:18','2025-09-04 12:47:18',NULL),(3170,7941,40915,272954,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',80000.00,NULL,NULL,1,'2025-09-04 12:54:23','2025-09-04 12:54:23',NULL),(3171,7941,40915,272954,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',80000.00,NULL,NULL,1,'2025-09-04 12:55:41','2025-09-04 12:55:41',NULL),(3172,11429,40879,218301,16,3172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'0025-01-31','0025-01-31',13138630.52,'DJ IIBB',NULL,1,'2025-09-04 13:05:21','2025-09-04 13:05:21',NULL),(3173,7941,40915,272954,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',200000.00,NULL,NULL,1,'2025-09-04 13:08:19','2025-09-04 13:08:19',NULL),(3174,7941,40915,272954,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',200000.00,NULL,NULL,1,'2025-09-04 13:11:09','2025-09-04 13:11:09',NULL),(3175,7941,40915,272954,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',70000.00,NULL,NULL,1,'2025-09-04 13:13:15','2025-09-04 13:13:15',NULL),(3176,7941,40915,272954,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',70000.00,NULL,NULL,1,'2025-09-04 13:15:47','2025-09-04 13:15:47',NULL),(3177,7941,40915,272954,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-09-04 13:25:15','2025-09-04 13:25:15',NULL),(3178,11429,40879,218302,16,3178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',11953140.99,'DJ IIBB',NULL,1,'2025-09-04 13:25:43','2025-09-04 13:25:43',NULL),(3179,7941,40915,272954,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-09-04 13:27:44','2025-09-04 13:27:44',NULL),(3180,11429,40879,218303,16,3180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',12031286.34,'DJ IIBB',NULL,1,'2025-09-04 13:57:39','2025-09-04 13:57:39',NULL),(3181,7941,40915,272954,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-09-04 14:09:51','2025-09-04 14:09:51',NULL),(3182,11429,40879,218304,16,3182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',11545897.82,'DJ IIBB',NULL,1,'2025-09-04 14:10:01','2025-09-04 14:10:01',NULL),(3183,7941,40915,272954,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',160000.00,NULL,NULL,1,'2025-09-04 14:11:47','2025-09-04 14:11:47',NULL),(3184,7941,40915,272954,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',180000.00,NULL,NULL,1,'2025-09-04 14:17:02','2025-09-04 14:17:02',NULL),(3185,7941,40915,272954,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',180000.00,NULL,NULL,1,'2025-09-04 14:18:45','2025-09-04 14:18:45',NULL);
INSERT INTO `balance_libro` VALUES (3186,11429,40879,218305,16,3186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',11536061.86,'DJ IIBB',NULL,1,'2025-09-04 14:20:37','2025-09-04 14:20:37',NULL),(3187,7941,40915,272954,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',210000.00,NULL,NULL,1,'2025-09-04 14:23:12','2025-09-04 14:23:12',NULL),(3188,7941,40915,272954,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',210000.00,NULL,NULL,1,'2025-09-04 14:24:39','2025-09-04 14:24:39',NULL),(3189,7941,40915,272954,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',40000.00,NULL,NULL,1,'2025-09-04 14:28:56','2025-09-04 14:28:56',NULL),(3190,7941,40915,272954,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',40000.00,NULL,NULL,1,'2025-09-04 14:30:19','2025-09-04 14:30:19',NULL),(3191,11429,40945,276061,12,3191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',30000000.00,'ASIENTO DE INICIO',NULL,1,'2025-09-04 15:13:04','2025-09-04 15:13:05',NULL),(3192,11429,40945,276068,5,3192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1500000.00,'BANCO GALICIA',NULL,1,'2025-09-04 16:32:55','2025-09-04 16:32:55',NULL),(3193,11429,40945,276070,5,3193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',3000000.00,'BANCO GALICIA',NULL,1,'2025-09-04 16:38:01','2025-09-04 16:38:01',NULL),(3194,11429,40945,276071,5,3194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',3500000.00,'BANCO GALICIA',NULL,1,'2025-09-04 16:42:50','2025-09-04 16:42:50',NULL),(3195,11429,40879,218291,6,3195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',22442822.64,'DJ Ganancias',NULL,1,'2025-09-05 13:56:02','2025-09-05 13:56:02',NULL),(3196,11429,40879,218291,12,3196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',236989911.00,'Saldos Iniciales',NULL,1,'2025-09-05 14:53:34','2025-09-05 15:58:28','2025-09-05 15:58:28'),(3197,11429,40879,218291,12,3197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',407705092.00,'Saldos Iniciales',NULL,1,'2025-09-05 15:58:28','2025-09-05 17:22:13','2025-09-05 17:22:13'),(3198,11429,40879,218291,12,3198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',1143156072.00,'Saldos Iniciales',NULL,1,'2025-09-05 17:22:13','2025-09-05 18:23:25','2025-09-05 18:23:25'),(3199,11429,40945,276069,5,3199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',16217069.71,'BANCO GALICIA',NULL,1,'2025-09-05 18:00:11','2025-09-08 11:10:39','2025-09-08 11:10:39'),(3200,11429,40945,276072,5,3200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',6410933.56,'BANCO GALICIA',NULL,1,'2025-09-05 18:15:06','2025-09-08 11:17:20','2025-09-08 11:17:20'),(3201,11429,40879,218291,12,3201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',3327092187.00,'Saldos Iniciales',NULL,1,'2025-09-05 18:23:25','2025-09-05 18:42:52','2025-09-05 18:42:52'),(3202,11429,40945,276070,19,3202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',994.00,'Mercado Pago',NULL,1,'2025-09-05 18:25:15','2025-09-08 11:19:05','2025-09-08 11:19:05'),(3203,11429,40945,276071,19,3203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',5965483.81,'Mercado Pago',NULL,1,'2025-09-05 18:30:26','2025-09-08 11:20:51','2025-09-08 11:20:51');
INSERT INTO `balance_libro` VALUES (3204,11429,40945,276072,19,3204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',5533245.33,'Mercado Pago',NULL,1,'2025-09-05 18:33:44','2025-09-08 11:21:47','2025-09-08 11:21:47'),(3205,11429,40879,218291,12,3205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',3568887306.00,'Saldos Iniciales',NULL,1,'2025-09-05 18:42:52','2025-09-08 12:01:03','2025-09-08 12:01:03'),(3206,11429,40945,276069,5,3206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',16217069.71,'BANCO GALICIA',NULL,1,'2025-09-08 11:10:39','2025-09-09 13:35:28','2025-09-09 13:35:28'),(3207,11429,40945,276072,5,3207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',6410933.56,'BANCO GALICIA',NULL,1,'2025-09-08 11:17:20','2025-09-08 11:17:20',NULL),(3208,11429,40945,276070,19,3208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',994.00,'Mercado Pago',NULL,1,'2025-09-08 11:19:05','2025-09-09 13:59:23','2025-09-09 13:59:23'),(3209,11429,40945,276071,19,3209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',5965483.81,'Mercado Pago',NULL,1,'2025-09-08 11:20:51','2025-09-09 13:59:32','2025-09-09 13:59:32'),(3210,11429,40945,276072,19,3210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',5533245.33,'Mercado Pago',NULL,1,'2025-09-08 11:21:47','2025-09-09 13:59:42','2025-09-09 13:59:42'),(3211,11429,40879,218291,12,3211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',3568887309.28,'Saldos Iniciales',NULL,1,'2025-09-08 12:01:03','2025-09-08 12:01:03',NULL),(3212,11429,40879,218291,5,3212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1642117.25,'MERCADO PAGO',NULL,1,'2025-09-08 13:13:45','2025-09-08 13:13:45',NULL),(3213,11429,40879,218292,5,3213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1748092.26,'MERCADO PAGO',NULL,1,'2025-09-08 13:16:22','2025-09-08 13:16:22',NULL),(3214,11429,40879,218293,5,3214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',2282283.44,'MERCADO PAGO',NULL,1,'2025-09-08 13:30:31','2025-09-08 13:30:31',NULL),(3215,11429,40879,218294,5,3215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1731672.69,'MERCADO PAGO',NULL,1,'2025-09-08 13:32:42','2025-09-08 13:32:42',NULL),(3216,11429,40879,218295,5,3216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2697382.36,'MERCADO PAGO',NULL,1,'2025-09-08 13:34:41','2025-09-08 13:34:41',NULL),(3217,11429,40879,218296,5,3217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2374692.15,'MERCADO PAGO',NULL,1,'2025-09-08 13:36:53','2025-09-08 13:36:53',NULL),(3218,11429,40879,218297,5,3218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2898875.49,'MERCADO PAGO',NULL,1,'2025-09-08 13:39:14','2025-09-08 13:39:14',NULL),(3219,11429,40879,218291,3,3219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',19566421.94,'SUBDIARIO COMPRAS',NULL,1,'2025-09-08 13:43:27','2025-09-08 13:50:21','2025-09-08 13:50:21'),(3220,11429,40879,218291,3,3220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',19566421.94,'SUBDIARIO COMPRAS',NULL,1,'2025-09-08 13:50:21','2025-09-08 15:07:34','2025-09-08 15:07:34'),(3221,11429,40879,218301,5,3221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',2004898.96,'MERCADO PAGO',NULL,1,'2025-09-08 14:36:11','2025-09-08 14:36:11',NULL);
INSERT INTO `balance_libro` VALUES (3222,11429,40879,218302,5,3222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',2176176.99,'MERCADO PAGO',NULL,1,'2025-09-08 14:38:25','2025-09-08 14:38:25',NULL),(3223,11429,40879,218303,5,3223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2474067.34,'MERCADO PAGO',NULL,1,'2025-09-08 14:40:32','2025-09-08 14:40:32',NULL),(3224,11429,40879,218304,5,3224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',2474755.66,'MERCADO PAGO',NULL,1,'2025-09-08 14:42:19','2025-09-08 14:42:19',NULL),(3225,11429,40879,218305,5,3225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1805155.21,'MERCADO PAGO',NULL,1,'2025-09-08 14:46:12','2025-09-08 14:46:12',NULL),(3226,11429,40879,218291,3,3226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',19566421.94,'COMPRAS',NULL,1,'2025-09-08 15:07:34','2025-09-08 15:07:34',NULL),(3227,11429,40879,218292,3,3227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',44207121.92,'COMPRAS',NULL,1,'2025-09-08 15:24:05','2025-09-08 15:24:05',NULL),(3228,11429,40879,218293,3,3228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',57843252.06,'COMPRAS',NULL,1,'2025-09-08 15:38:36','2025-09-08 15:38:36',NULL),(3229,11429,40879,218294,3,3229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',41492957.34,'COMPRAS',NULL,1,'2025-09-08 15:53:30','2025-09-08 15:53:30',NULL),(3230,11429,40879,218295,3,3230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',17165695.91,'COMPRAS',NULL,1,'2025-09-08 16:08:54','2025-09-08 16:08:54',NULL),(3231,11429,40879,218296,3,3231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',132651953.49,'COMPRAS',NULL,1,'2025-09-08 16:21:49','2025-09-08 16:21:49',NULL),(3232,11429,40879,218297,3,3232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',102296033.44,'COMPRAS',NULL,1,'2025-09-08 16:36:08','2025-09-08 16:36:08',NULL),(3233,11429,40879,218301,3,3233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'0025-01-31','0025-01-31',240775841.02,'COMPRAS',NULL,1,'2025-09-08 16:53:49','2025-09-12 10:23:16','2025-09-12 10:23:16'),(3234,11429,40879,218302,3,3234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',246815159.35,'COMPRAS',NULL,1,'2025-09-08 17:16:57','2025-09-09 13:11:09','2025-09-09 13:11:09'),(3235,11429,40879,218303,3,3235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',219106574.04,'COMPRAS',NULL,1,'2025-09-08 17:31:21','2025-09-09 13:13:25','2025-09-09 13:13:25'),(3236,11429,40879,218304,3,3236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',250115424.81,'COMPRAS',NULL,1,'2025-09-08 17:42:11','2025-09-08 17:42:11',NULL),(3237,11429,40879,218305,3,3237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',415849156.14,'COMPRAS',NULL,1,'2025-09-08 17:58:44','2025-09-09 13:14:58','2025-09-09 13:14:58'),(3238,11429,40879,218291,5,3238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',297566409.49,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 11:05:27','2025-09-09 11:18:37','2025-09-09 11:18:37'),(3239,11429,40879,218291,5,3239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',297566409.49,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 11:18:37','2025-09-11 17:36:04','2025-09-11 17:36:04');
INSERT INTO `balance_libro` VALUES (3240,11429,40879,218292,5,3240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',298205180.88,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 11:25:15','2025-09-11 17:37:15','2025-09-11 17:37:15'),(3241,11429,40879,218293,5,3241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',244661045.53,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 11:33:56','2025-09-09 11:33:56',NULL),(3242,11429,40879,218294,5,3242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',299668698.36,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 11:42:07','2025-09-09 11:42:07',NULL),(3243,11429,40879,218295,5,3243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',229865618.97,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 11:50:11','2025-09-09 11:50:11',NULL),(3244,11429,40879,218296,5,3244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',333705643.70,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 11:58:23','2025-09-09 11:58:23',NULL),(3245,11429,40879,218297,5,3245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',377057256.64,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 12:11:09','2025-09-22 13:58:06','2025-09-22 13:58:06'),(3246,11429,40879,218301,5,3246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',477371980.32,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 12:19:41','2025-09-09 12:19:41',NULL),(3247,11429,40879,218302,5,3247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',322397468.48,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 12:28:50','2025-09-11 17:38:57','2025-09-11 17:38:57'),(3248,11429,40879,218303,5,3248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',369768730.30,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 12:36:15','2025-09-11 17:39:56','2025-09-11 17:39:56'),(3249,11429,40879,218304,5,3249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',501656176.23,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 12:44:07','2025-09-22 15:41:07','2025-09-22 15:41:07'),(3250,11429,40879,218305,5,3250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',696808376.09,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-09 12:51:23','2025-09-11 17:41:28','2025-09-11 17:41:28'),(3251,11429,40879,218302,3,3251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',246815159.35,'COMPRAS',NULL,1,'2025-09-09 13:11:09','2025-09-09 13:11:09',NULL),(3252,11429,40879,218303,3,3252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',219106574.04,'COMPRAS',NULL,1,'2025-09-09 13:13:25','2025-09-09 13:13:25',NULL),(3253,11429,40879,218305,3,3253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',415849156.14,'COMPRAS',NULL,1,'2025-09-09 13:14:58','2025-09-12 10:45:07','2025-09-12 10:45:07'),(3254,11429,40945,276069,5,3254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',16217069.71,'BANCO GALICIA',NULL,1,'2025-09-09 13:35:28','2025-09-10 12:18:23','2025-09-10 12:18:23'),(3255,11429,40945,276070,5,3255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',994.00,'MERCADO PAGO',NULL,1,'2025-09-09 13:37:58','2025-09-09 13:37:58',NULL),(3256,11429,40945,276071,5,3256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',5965483.81,'MERCADO PAGO',NULL,1,'2025-09-09 13:48:45','2025-09-09 13:48:45',NULL);
INSERT INTO `balance_libro` VALUES (3257,11429,40945,276072,5,3257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',5533245.33,'MERCADO PAGO',NULL,1,'2025-09-09 13:51:13','2025-09-09 13:51:13',NULL),(3258,11429,40879,218291,5,3258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',818099.87,'BANCO MACRO',NULL,1,'2025-09-09 17:05:27','2025-09-09 17:05:27',NULL),(3259,11429,40879,218292,5,3259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1845223.20,'BANCO MACRO',NULL,1,'2025-09-09 17:07:58','2025-09-09 17:07:58',NULL),(3260,11429,40879,218293,5,3260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1764907.65,'BANCO MACRO',NULL,1,'2025-09-09 17:11:39','2025-09-09 17:11:39',NULL),(3261,11429,40879,218294,5,3261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1354981.83,'BANCO MACRO',NULL,1,'2025-09-09 17:14:22','2025-09-09 17:14:22',NULL),(3262,11429,40879,218295,5,3262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1314551.25,'BANCO MACRO',NULL,1,'2025-09-09 17:17:01','2025-09-09 17:17:01',NULL),(3263,11429,40879,218296,5,3263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1917147.38,'BANCO MACRO',NULL,1,'2025-09-09 17:22:50','2025-09-09 17:22:51',NULL),(3264,11429,40879,218297,5,3264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1882572.25,'BANCO MACRO',NULL,1,'2025-09-09 17:26:19','2025-09-09 17:26:19',NULL),(3265,11429,40879,218301,5,3265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',3867092.71,'BANCO MACRO',NULL,1,'2025-09-09 17:29:40','2025-09-09 17:29:40',NULL),(3266,11429,40879,218302,5,3266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1880947.38,'BANCO MACRO',NULL,1,'2025-09-09 17:32:49','2025-09-09 17:32:49',NULL),(3267,11429,40879,218303,5,3267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1880947.38,'BANCO MACRO',NULL,1,'2025-09-09 17:35:42','2025-09-09 17:35:42',NULL),(3268,11429,40879,218304,5,3268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',1882384.76,'BANCO MACRO',NULL,1,'2025-09-09 17:38:31','2025-09-09 17:38:31',NULL),(3269,11429,40879,218305,5,3269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',2171488.76,'BANCO MACRO',NULL,1,'2025-09-09 17:41:23','2025-09-09 17:41:23',NULL),(3270,11429,40879,218301,5,3270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',3387450.00,'BANCO CREDICOOP EN DOLARES',NULL,1,'2025-09-10 10:44:49','2025-09-10 10:44:49',NULL),(3271,11429,40879,218302,5,3271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',18675.66,'BANCO CREDICOOP EN DOLARES',NULL,1,'2025-09-10 10:47:55','2025-09-10 10:47:55',NULL),(3272,11429,40879,218303,5,3272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',9984500.00,'BANCO CREDICOOP EN DOLARES',NULL,1,'2025-09-10 10:50:41','2025-09-10 10:50:41',NULL),(3273,11429,40879,218304,5,3273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',78027.38,'BANCO CREDICOOP EN DOLARES',NULL,1,'2025-09-10 10:53:56','2025-09-10 10:53:56',NULL),(3274,11429,40945,276069,3,3274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',30854914.59,'COMPRAS',NULL,1,'2025-09-10 12:17:10','2025-09-10 12:17:10',NULL);
INSERT INTO `balance_libro` VALUES (3275,11429,40945,276069,5,3275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',16217069.71,'BANCO GALICIA',NULL,1,'2025-09-10 12:18:23','2025-09-10 12:18:23',NULL),(3276,11429,40945,276072,19,3276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1632077.73,'Diferencia de Cambio - Deuda Ext. al cierre',NULL,1,'2025-09-10 12:20:00','2025-09-10 12:20:00',NULL),(3277,11429,40945,276072,3,3277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',3909371.03,'COMPRAS',NULL,1,'2025-09-10 15:34:56','2025-09-10 15:34:56',NULL),(3278,11429,40945,276071,3,3278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',2494686.09,'compras',NULL,1,'2025-09-10 15:35:37','2025-09-10 15:35:37',NULL),(3279,11429,40945,276070,3,3279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-02','2025-03-02',3517167.96,'COMPRAS',NULL,1,'2025-09-10 15:36:28','2025-09-10 15:36:28',NULL),(3280,11429,40945,276068,3,3280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1574716.32,'COMPRAS',NULL,1,'2025-09-10 15:40:30','2025-09-10 15:40:30',NULL),(3281,11429,40879,218305,5,3281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1527096.78,'ASIENTO PRESTAMO CREDICOOP',NULL,1,'2025-09-10 17:15:14','2025-09-10 17:15:14',NULL),(3282,11429,40879,218291,5,3282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',569677.69,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 12:03:08','2025-09-11 12:03:08',NULL),(3283,11429,40879,218292,5,3283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',510020.94,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 12:07:02','2025-09-11 12:07:02',NULL),(3284,11429,40879,218293,5,3284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',320952.60,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 12:09:52','2025-09-11 12:09:52',NULL),(3285,11429,40879,218294,5,3285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1360795.28,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 12:11:20','2025-09-11 12:11:20',NULL),(3286,11429,40879,218295,5,3286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1161666.12,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 12:15:19','2025-09-11 12:15:19',NULL),(3287,11429,40879,218296,5,3287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1299552.67,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 12:54:41','2025-09-11 12:54:41',NULL),(3288,11429,40879,218297,5,3288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',711558.64,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 12:57:49','2025-09-11 12:57:49',NULL),(3289,11429,40879,218301,5,3289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',2140615.04,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 13:00:33','2025-09-11 13:00:33',NULL),(3290,11429,40879,218302,5,3290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',850272.05,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 13:02:22','2025-09-11 13:02:22',NULL),(3291,11429,40879,218303,5,3291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1490899.14,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 13:04:57','2025-09-11 13:04:57',NULL);
INSERT INTO `balance_libro` VALUES (3292,11429,40879,218304,5,3292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',1140507.31,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 13:07:08','2025-09-11 13:07:08',NULL),(3293,11429,40879,218305,5,3293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1049197.43,'TARJETA DE CREDITO AMERICAN EXPRESS',NULL,1,'2025-09-11 13:08:28','2025-09-11 13:08:28',NULL),(3294,11429,40879,218295,5,3294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',84968.00,'TARJETA DE CREDITO VISA',NULL,1,'2025-09-11 13:37:57','2025-09-11 13:37:57',NULL),(3295,11429,40879,218296,5,3295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',398668.57,'TARJETA DE CREDITO VISA',NULL,1,'2025-09-11 13:40:43','2025-09-11 13:40:43',NULL),(3296,11429,40879,218297,5,3296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',304505.18,'TARJETA DE CREDITO VISA',NULL,1,'2025-09-11 13:42:51','2025-09-11 13:42:51',NULL),(3297,11429,40879,218301,5,3297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',361218.63,'TARJETA DE CREDITO VISA',NULL,1,'2025-09-11 13:44:56','2025-09-11 13:44:56',NULL),(3298,11429,40879,218302,5,3298,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',336778.73,'TARJETA DE CREDITO VISA',NULL,1,'2025-09-11 13:46:28','2025-09-11 13:46:28',NULL),(3299,11429,40879,218303,5,3299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',415689.43,'TARJETA DE CREDITO VISA',NULL,1,'2025-09-11 13:48:23','2025-09-11 13:48:23',NULL),(3300,11429,40879,218304,5,3300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',637523.84,'TARJETA DE CREDITO VISA',NULL,1,'2025-09-11 13:50:00','2025-09-11 13:50:00',NULL),(3301,11429,40879,218305,5,3301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',525115.00,'TARJETA DE CREDITO VISA',NULL,1,'2025-09-11 13:51:34','2025-09-11 13:51:34',NULL),(3302,11429,40879,218291,5,3302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',297566409.49,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-11 17:36:04','2025-09-12 12:18:58','2025-09-12 12:18:58'),(3303,11429,40879,218292,5,3303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',298205180.88,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-11 17:37:15','2025-09-12 12:23:51','2025-09-12 12:23:51'),(3304,11429,40879,218302,5,3304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',322397468.48,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-11 17:38:57','2025-09-12 12:01:58','2025-09-12 12:01:58'),(3305,11429,40879,218303,5,3305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',369768730.30,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-11 17:39:56','2025-09-12 12:05:37','2025-09-12 12:05:37'),(3306,11429,40879,218305,5,3306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',696808376.09,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-11 17:41:28','2025-09-12 12:09:40','2025-09-12 12:09:40'),(3307,11429,40879,218301,3,3307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'0025-01-31','0025-01-31',242787365.32,'COMPRAS',NULL,1,'2025-09-12 10:23:16','2025-09-12 10:36:48','2025-09-12 10:36:48'),(3308,11429,40879,218301,3,3308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'0025-01-31','0025-01-31',242787365.32,'COMPRAS',NULL,1,'2025-09-12 10:36:48','2025-09-12 11:51:28','2025-09-12 11:51:28');
INSERT INTO `balance_libro` VALUES (3309,11429,40879,218305,3,3309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',415943540.04,'COMPRAS',NULL,1,'2025-09-12 10:45:07','2025-09-12 10:45:07',NULL),(3310,11429,40879,218301,3,3310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'0025-01-31','0025-01-31',242787365.32,'COMPRAS',NULL,1,'2025-09-12 11:51:28','2025-09-12 11:51:28',NULL),(3311,11429,40879,218302,5,3311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',401821946.29,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-12 12:01:58','2025-09-12 12:01:58',NULL),(3312,11429,40879,218303,5,3312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',416273312.23,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-12 12:05:37','2025-09-12 12:05:37',NULL),(3313,11429,40879,218305,5,3313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',773419004.85,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-12 12:09:40','2025-09-12 12:09:40',NULL),(3314,11429,40879,218291,5,3314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',387327845.07,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-12 12:18:58','2025-09-12 12:18:58',NULL),(3315,11429,40879,218292,5,3315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',368409385.60,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-12 12:23:51','2025-09-12 12:23:51',NULL),(3316,11429,40879,218297,5,3316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',357146422.56,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-22 13:58:06','2025-09-22 13:58:06',NULL),(3317,11429,40879,218304,5,3317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',499830434.26,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-22 15:41:07','2025-09-22 15:46:31','2025-09-22 15:46:31'),(3318,11429,40879,218304,5,3318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',505065745.93,'BANCO CREDICOOP EN PESOS',NULL,1,'2025-09-22 15:46:31','2025-09-22 15:46:31',NULL),(3319,7941,40915,272955,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',80000.00,NULL,NULL,1,'2025-09-26 14:32:13','2025-09-26 14:32:13',NULL),(3320,7941,40915,272955,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',105000.00,NULL,NULL,1,'2025-09-26 14:32:14','2025-09-26 14:32:14',NULL),(3321,7941,40915,272955,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',180000.00,NULL,NULL,1,'2025-09-26 14:46:48','2025-09-26 14:46:48',NULL),(3322,7941,40915,272955,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',330000.00,NULL,NULL,1,'2025-09-26 14:46:49','2025-09-26 14:46:49',NULL),(3323,7941,40915,272955,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',170000.00,NULL,NULL,1,'2025-09-26 14:51:53','2025-09-26 14:51:53',NULL),(3324,7941,40915,272955,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',45000.00,NULL,NULL,1,'2025-09-26 14:51:54','2025-09-26 14:51:54',NULL),(3325,7941,40915,272955,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',90000.00,NULL,NULL,1,'2025-09-26 14:51:55','2025-09-26 14:51:55',NULL),(3326,7941,40915,272955,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',280000.00,NULL,NULL,1,'2025-09-26 14:54:50','2025-09-26 14:54:50',NULL),(3327,7941,40915,272955,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',200000.00,NULL,NULL,1,'2025-09-26 14:54:51','2025-09-26 14:54:51',NULL);
INSERT INTO `balance_libro` VALUES (3328,7941,40915,272955,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',500000.00,NULL,NULL,1,'2025-09-26 14:54:52','2025-09-26 14:54:52',NULL),(3329,7941,40915,272955,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',160000.00,NULL,NULL,1,'2025-09-26 14:54:54','2025-09-26 14:54:54',NULL),(3330,7941,40915,272955,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',160000.00,NULL,NULL,1,'2025-09-26 14:54:55','2025-09-26 14:54:55',NULL),(3331,7941,40719,56,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',100000.00,NULL,NULL,1,'2025-09-26 15:51:36','2025-09-26 15:51:36',NULL),(3332,7941,40719,56,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',240000.00,NULL,NULL,1,'2025-09-26 15:51:37','2025-09-26 15:51:37',NULL),(3333,7941,40719,56,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',250000.00,NULL,NULL,1,'2025-09-26 15:51:37','2025-09-26 15:51:37',NULL),(3334,7941,40719,56,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',210000.00,NULL,NULL,1,'2025-09-26 15:53:43','2025-09-26 15:53:43',NULL),(3335,7941,40719,56,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',280000.00,NULL,NULL,1,'2025-09-26 15:53:44','2025-09-26 15:53:44',NULL),(3336,7941,40719,56,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',150000.00,NULL,NULL,1,'2025-09-26 16:04:33','2025-09-26 16:04:33',NULL),(3337,7941,40719,56,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',250000.00,NULL,NULL,1,'2025-09-26 16:04:34','2025-09-26 16:04:34',NULL),(3338,7941,40915,272955,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',1040000.00,NULL,NULL,1,'2025-09-30 09:08:15','2025-09-30 09:08:15',NULL),(3339,7941,40915,272955,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',650000.00,NULL,NULL,1,'2025-09-30 09:08:16','2025-09-30 09:08:16',NULL),(3340,7941,40719,56,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',1010000.00,NULL,NULL,1,'2025-09-30 09:33:04','2025-09-30 09:33:04',NULL),(3341,7941,40719,56,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',800000.00,NULL,NULL,1,'2025-09-30 09:33:06','2025-09-30 09:33:06',NULL),(3342,7941,40719,56,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',290000.00,NULL,NULL,1,'2025-09-30 09:38:02','2025-09-30 09:38:02',NULL),(3343,7941,40719,56,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',200000.00,NULL,NULL,1,'2025-09-30 09:38:03','2025-09-30 09:38:03',NULL),(3344,7941,40719,56,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',200000.00,NULL,NULL,1,'2025-09-30 09:38:04','2025-09-30 09:38:04',NULL),(3345,7941,40719,56,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',150000.00,NULL,NULL,1,'2025-09-30 09:38:05','2025-09-30 09:38:05',NULL),(3346,7941,40719,56,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',150000.00,NULL,NULL,1,'2025-09-30 09:56:25','2025-09-30 09:56:25',NULL),(3347,11429,40946,277592,2,3347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',847000.00,'VENTAS',NULL,1,'2025-10-02 13:15:04','2025-10-02 13:15:04',NULL),(3348,11429,40946,277593,2,3348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',283000.00,'VENTAS',NULL,1,'2025-10-02 13:23:10','2025-10-02 13:23:10',NULL);
INSERT INTO `balance_libro` VALUES (3349,11429,40946,277594,2,3349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',13431447.65,'VENTAS',NULL,1,'2025-10-02 13:24:32','2025-10-02 13:24:32',NULL),(3350,11429,40946,277595,2,3350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',37889949.09,'VENTAS',NULL,1,'2025-10-02 13:26:00','2025-10-02 13:26:00',NULL),(3351,11429,40946,277586,15,3351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2015.04,'DJ IVA',NULL,1,'2025-10-02 13:34:26','2025-10-02 13:34:26',NULL),(3352,11429,40946,277587,15,3352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',73474.42,'DJ IVA',NULL,1,'2025-10-02 14:23:56','2025-10-02 14:23:56',NULL),(3353,11429,40946,277588,15,3353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',389672.96,'DJ IVA',NULL,1,'2025-10-02 14:26:30','2025-10-02 14:26:30',NULL),(3354,11429,40946,277590,15,3354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',737872.51,'DJ IVA',NULL,1,'2025-10-02 14:30:14','2025-10-02 14:30:14',NULL),(3355,11429,40946,277591,15,3355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',975633.25,'DJ IVA',NULL,1,'2025-10-02 14:32:03','2025-10-02 14:32:03',NULL),(3356,11429,40946,277593,15,3356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',1323407.96,'DJ IVA',NULL,1,'2025-10-02 14:33:52','2025-10-02 14:33:52',NULL),(3357,11429,40946,277592,15,3357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1111457.17,'DJ IVA',NULL,1,'2025-10-02 14:35:43','2025-10-02 14:35:43',NULL),(3358,11429,40946,277594,15,3358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',16574684.47,'DJ IVA',NULL,1,'2025-10-02 14:37:53','2025-10-02 14:37:53',NULL),(3359,11429,40946,277595,15,3359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',15003880.81,'DJ IVA',NULL,1,'2025-10-02 14:39:49','2025-10-02 14:39:49',NULL),(3360,11429,40946,277586,16,3360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',37753.06,'DJ IIBB',NULL,1,'2025-10-02 15:42:49','2025-10-02 15:42:49',NULL),(3361,11429,40946,277587,16,3361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',38670.97,'DJ IIBB',NULL,1,'2025-10-02 15:45:50','2025-10-02 15:45:50',NULL),(3362,11429,40946,277588,16,3362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',74217.60,'DJ IIBB',NULL,1,'2025-10-02 15:46:58','2025-10-02 15:46:58',NULL),(3363,11429,40946,277590,16,3363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',93395.68,'DJ IIBB',NULL,1,'2025-10-02 15:47:48','2025-10-02 15:47:48',NULL),(3364,11429,40946,277591,16,3364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',94854.18,'DJ IIBB',NULL,1,'2025-10-02 15:48:41','2025-10-02 15:48:41',NULL),(3365,11429,40946,277592,16,3365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',109476.44,'DJ IIBB',NULL,1,'2025-10-02 15:50:23','2025-10-02 15:50:23',NULL),(3366,11429,40946,277593,16,3366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',129891.74,'DJ IIBB',NULL,1,'2025-10-02 15:51:51','2025-10-02 15:51:51',NULL),(3367,11429,40946,277594,16,3367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1212993.03,'DJ IIBB',NULL,1,'2025-10-02 15:53:27','2025-10-02 15:53:27',NULL);
INSERT INTO `balance_libro` VALUES (3368,11429,40946,277595,16,3368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',1609086.22,'DJ IIBB',NULL,1,'2025-10-02 15:58:51','2025-10-02 15:58:51',NULL),(3369,11429,40946,277593,5,3369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',21331.51,'Mercado Pago',NULL,1,'2025-10-06 09:22:20','2025-10-06 09:22:20',NULL),(3370,11429,40946,277594,5,3370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',2219955.76,'Mercado Pago',NULL,1,'2025-10-06 09:26:50','2025-10-06 16:01:58','2025-10-06 16:01:58'),(3371,11429,40946,277595,5,3371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',10957496.20,'Mercado Pago',NULL,1,'2025-10-06 09:30:24','2025-10-06 16:02:39','2025-10-06 16:02:39'),(3372,11429,40946,277590,5,3372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1136674.22,'Banco ICBC En Pesos',NULL,1,'2025-10-06 10:01:02','2025-10-06 16:03:22','2025-10-06 16:03:22'),(3373,11429,40946,277591,5,3373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',4000000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 10:08:25','2025-10-06 16:04:30','2025-10-06 16:04:30'),(3374,11429,40946,277592,5,3374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1618989.15,'Banco ICBC En Pesos',NULL,1,'2025-10-06 10:12:38','2025-10-06 16:05:55','2025-10-06 16:05:55'),(3375,11429,40946,277593,5,3375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',2000000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 10:16:41','2025-10-06 16:07:37','2025-10-06 16:07:37'),(3376,11429,40946,277594,5,3376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',35022716.34,'Banco ICBC En Pesos',NULL,1,'2025-10-06 10:23:30','2025-10-06 16:08:27','2025-10-06 16:08:27'),(3377,11429,40946,277595,5,3377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',22892303.73,'Banco ICBC En Pesos',NULL,1,'2025-10-06 10:29:55','2025-10-06 16:09:09','2025-10-06 16:09:09'),(3378,11429,40946,277593,5,3378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',56525000.00,'Banco ICBC En Dolares',NULL,1,'2025-10-06 10:40:50','2025-10-06 10:40:50',NULL),(3379,11429,40946,277594,5,3379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',57803178.50,'Banco ICBC En Dolares',NULL,1,'2025-10-06 10:46:03','2025-10-17 12:16:38','2025-10-17 12:16:38'),(3380,11429,40946,277595,5,3380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',606846.15,'Banco ICBC En Dolares',NULL,1,'2025-10-06 10:47:42','2025-10-06 10:47:42',NULL),(3381,11429,40946,277586,5,3381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1350000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 10:55:11','2025-10-06 11:06:33','2025-10-06 11:06:33'),(3382,11429,40946,277587,5,3382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',3000000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 10:57:37','2025-10-06 11:07:30','2025-10-06 11:07:30'),(3383,11429,40946,277588,5,3383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2709758.72,'Banco ICBC En Pesos',NULL,1,'2025-10-06 11:01:17','2025-10-06 11:08:08','2025-10-06 11:08:08'),(3384,11429,40946,277586,5,3384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1350000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 11:06:33','2025-10-06 16:11:29','2025-10-06 16:11:29');
INSERT INTO `balance_libro` VALUES (3385,11429,40946,277587,5,3385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',3000000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 11:07:30','2025-10-06 16:12:09','2025-10-06 16:12:09'),(3386,11429,40946,277588,5,3386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2709758.72,'Banco ICBC En Pesos',NULL,1,'2025-10-06 11:08:08','2025-10-06 16:10:38','2025-10-06 16:10:38'),(3387,11429,40946,277583,12,3387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',5000000.00,'Asiento de Inicio',NULL,1,'2025-10-06 11:08:59','2025-10-06 11:08:59',NULL),(3388,11429,40946,277587,5,3388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',74167.46,'Tarjeta de Credito VISA',NULL,1,'2025-10-06 11:18:34','2025-10-06 14:18:41','2025-10-06 14:18:41'),(3389,11429,40946,277588,5,3389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',7254.71,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 11:20:51','2025-10-06 14:19:14','2025-10-06 14:19:14'),(3390,11429,40946,277590,5,3390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',49960.00,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 11:27:39','2025-10-06 11:27:39',NULL),(3391,11429,40946,277591,5,3391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',674518.71,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 11:35:22','2025-10-06 11:35:22',NULL),(3392,11429,40946,277592,5,3392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',141332.37,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 11:43:04','2025-10-06 14:21:03','2025-10-06 14:21:03'),(3393,11429,40946,277593,5,3393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',569379.21,'Tarjeta de Credito VISA',NULL,1,'2025-10-06 12:16:57','2025-10-06 12:16:57',NULL),(3394,11429,40946,277594,5,3394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',236273.92,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 12:33:19','2025-10-06 12:33:19',NULL),(3395,11429,40946,277595,5,3395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',74312.00,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 12:39:54','2025-10-06 12:39:54',NULL),(3396,11429,40946,277587,5,3396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',74167.46,'Tarjeta de Credito VISA',NULL,1,'2025-10-06 14:18:41','2025-10-06 15:51:13','2025-10-06 15:51:13'),(3397,11429,40946,277588,5,3397,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',7254.71,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 14:19:14','2025-10-06 15:52:37','2025-10-06 15:52:37'),(3398,11429,40946,277592,5,3398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',141332.37,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 14:21:03','2025-10-06 15:54:05','2025-10-06 15:54:05'),(3399,11429,40946,277586,3,3399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',477010.20,'COMPRAS',NULL,1,'2025-10-06 15:09:35','2025-10-06 15:09:35',NULL),(3400,11429,40946,277587,3,3400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',566024.40,'COMPRAS',NULL,1,'2025-10-06 15:18:37','2025-10-06 15:18:37',NULL),(3401,11429,40946,277588,3,3401,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',3117136.69,'COMPRAS',NULL,1,'2025-10-06 15:24:01','2025-10-17 11:48:27','2025-10-17 11:48:27');
INSERT INTO `balance_libro` VALUES (3402,11429,40946,277590,3,3402,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',4967055.10,'COMPRAS',NULL,1,'2025-10-06 15:26:02','2025-10-06 15:26:02',NULL),(3403,11429,40946,277591,3,3403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',2007256.29,'COMPRAS',NULL,1,'2025-10-06 15:28:55','2025-10-06 15:34:51','2025-10-06 15:34:51'),(3404,11429,40946,277592,3,3404,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1365568.35,'COMPRAS',NULL,1,'2025-10-06 15:31:19','2025-10-06 15:31:19',NULL),(3405,11429,40946,277593,3,3405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',2276992.39,'COMPRAS',NULL,1,'2025-10-06 15:34:10','2025-10-06 15:34:10',NULL),(3406,11429,40946,277591,3,3406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',2007256.29,'COMPRAS',NULL,1,'2025-10-06 15:34:51','2025-10-06 15:34:51',NULL),(3407,11429,40946,277594,3,3407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',61782348.16,'COMPRAS',NULL,1,'2025-10-06 15:38:10','2025-10-17 12:10:54','2025-10-17 12:10:54'),(3408,11429,40946,277595,3,3408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',4521474.76,'COMPRAS',NULL,1,'2025-10-06 15:41:17','2025-10-06 15:41:17',NULL),(3409,11429,40946,277587,5,3409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',74167.46,'Tarjeta de Credito VISA',NULL,1,'2025-10-06 15:51:13','2025-10-06 15:51:13',NULL),(3410,11429,40946,277588,5,3410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',7254.71,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 15:52:37','2025-10-06 15:52:37',NULL),(3411,11429,40946,277592,5,3411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',141332.37,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 15:54:05','2025-10-06 16:10:42','2025-10-06 16:10:42'),(3412,11429,40946,277594,5,3412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',2219955.76,'Mercado Pago',NULL,1,'2025-10-06 16:01:58','2025-10-06 16:01:58',NULL),(3413,11429,40946,277595,5,3413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',10957496.20,'Mercado Pago',NULL,1,'2025-10-06 16:02:39','2025-10-06 16:02:39',NULL),(3414,11429,40946,277590,5,3414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1136674.22,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:03:22','2025-10-06 16:03:22',NULL),(3415,11429,40946,277591,5,3415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',4000000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:04:30','2025-10-06 16:04:30',NULL),(3416,11429,40946,277592,5,3416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1618989.15,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:05:55','2025-10-06 16:05:55',NULL),(3417,11429,40946,277593,5,3417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',2000000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:07:37','2025-10-06 16:07:37',NULL),(3418,11429,40946,277594,5,3418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',35022716.34,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:08:27','2025-10-17 12:12:54','2025-10-17 12:12:54'),(3419,11429,40946,277595,5,3419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',22892303.73,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:09:09','2025-10-06 16:09:09',NULL);
INSERT INTO `balance_libro` VALUES (3420,11429,40946,277588,5,3420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2709758.72,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:10:38','2025-10-06 16:10:38',NULL),(3421,11429,40946,277592,5,3421,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',141332.37,'Tarjeta De Credito VISA',NULL,1,'2025-10-06 16:10:42','2025-10-06 16:10:42',NULL),(3422,11429,40946,277586,5,3422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1350000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:11:29','2025-10-06 16:11:29',NULL),(3423,11429,40946,277587,5,3423,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',3000000.00,'Banco ICBC En Pesos',NULL,1,'2025-10-06 16:12:09','2025-10-06 16:12:09',NULL),(3424,11429,40944,279110,3,3424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',698305.26,'SUBDIARIO COMPRAS',NULL,1,'2025-10-08 23:37:10','2025-10-08 23:37:10',NULL),(3425,11429,40944,279113,3,3425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',256674.00,'SUBDIARIO COMPRAS',NULL,1,'2025-10-08 23:42:43','2025-10-08 23:42:43',NULL),(3426,11429,40944,279114,3,3426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',705546.00,'SUBDIARIO COMPRAS',NULL,1,'2025-10-08 23:49:10','2025-10-08 23:49:10',NULL),(3427,11429,40944,279115,3,3427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',2555095.75,'SUBDIARIO COMPRAS',NULL,1,'2025-10-08 23:55:43','2025-10-08 23:55:43',NULL),(3428,11429,40944,279116,3,3428,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1683531.62,'SUBDIARIO COMPRAS',NULL,1,'2025-10-09 00:02:31','2025-10-09 00:02:31',NULL),(3429,11429,40944,279117,3,3429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',2483355.85,'SUBDIARIO COMPRAS',NULL,1,'2025-10-09 00:09:31','2025-10-09 00:09:31',NULL),(3430,11429,40880,219810,16,3430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1000.00,'DJ IIBB',NULL,1,'2025-10-09 11:23:58','2025-10-09 11:26:05','2025-10-09 11:26:05'),(3431,11429,40944,279114,16,3431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1000.00,'DJ IIBB',NULL,1,'2025-10-09 11:29:05','2025-10-28 09:58:28','2025-10-28 09:58:28'),(3432,11429,40944,279115,16,3432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',1425.00,'DJ IIBB',NULL,1,'2025-10-09 11:31:00','2025-10-28 09:57:22','2025-10-28 09:57:22'),(3433,11429,40944,279116,16,3433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',14755.05,'DJ IIBB',NULL,1,'2025-10-09 11:34:39','2025-10-09 11:34:39',NULL),(3434,11429,40944,279117,16,3434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',14755.05,'DJ IIBB',NULL,1,'2025-10-09 11:37:08','2025-10-09 11:37:08',NULL),(3435,11429,40944,279112,15,3435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',117786.43,'DJ IVA',NULL,1,'2025-10-09 11:44:21','2025-10-09 11:44:21',NULL),(3436,11429,40944,279113,15,3436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',137400.43,'DJ IVA',NULL,1,'2025-10-09 11:47:54','2025-10-09 11:47:54',NULL),(3437,11429,40944,279114,2,3437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',166375.00,'SUBDIARIO VENTAS',NULL,1,'2025-10-09 11:50:28','2025-10-09 11:50:28',NULL);
INSERT INTO `balance_libro` VALUES (3438,11429,40944,279114,15,3438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',230346.43,'DJ IVA',NULL,1,'2025-10-09 11:51:11','2025-10-09 11:51:11',NULL),(3439,11429,40944,279115,15,3439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',613497.09,'DJ IVA',NULL,1,'2025-10-09 11:55:12','2025-10-09 11:55:12',NULL),(3440,11429,40944,279115,2,3440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',172425.00,'SUBDIARIO VENTAS',NULL,1,'2025-10-09 11:55:22','2025-10-09 11:55:22',NULL),(3441,11429,40944,279116,15,3441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',583572.09,'DJ IVA',NULL,1,'2025-10-09 11:58:01','2025-10-09 11:58:01',NULL),(3442,11429,40944,279117,15,3442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',726036.67,'DJ IVA',NULL,1,'2025-10-09 12:04:04','2025-10-09 12:04:04',NULL),(3443,11429,40944,279118,15,3443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',726036.67,'DJ IVA',NULL,1,'2025-10-09 12:05:38','2025-10-09 12:06:30','2025-10-09 12:06:30'),(3444,11429,40944,279105,12,3444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',300000.00,'Asieno de inicio',NULL,1,'2025-10-09 12:47:58','2025-10-09 12:47:58',NULL),(3445,11429,40944,279110,5,3445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',707592.77,'BANCO GALICIA',NULL,1,'2025-10-09 17:13:43','2025-10-13 09:30:54','2025-10-13 09:30:54'),(3446,11429,40944,279112,5,3446,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',17.54,'BANCO GALICIA',NULL,1,'2025-10-09 17:24:38','2025-10-28 10:11:23','2025-10-28 10:11:23'),(3447,11429,40944,279113,5,3447,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',350200.00,'BANCO GALICIA',NULL,1,'2025-10-09 17:44:16','2025-10-28 10:12:26','2025-10-28 10:12:26'),(3448,11429,40944,279114,5,3448,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',714351.45,'BANCO GALICIA',NULL,1,'2025-10-13 08:54:48','2025-10-13 12:00:02','2025-10-13 12:00:02'),(3449,11429,40944,279115,5,3449,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',657201.84,'BANCO GALICIA',NULL,1,'2025-10-13 09:06:04','2025-10-13 12:07:39','2025-10-13 12:07:39'),(3450,11429,40944,279116,5,3450,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',669725.00,'BANCO GALICIA',NULL,1,'2025-10-13 09:12:54','2025-10-13 09:12:54',NULL),(3451,11429,40944,279117,5,3451,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',150900.00,'BANCO GALICIA',NULL,1,'2025-10-13 09:15:08','2025-10-13 09:15:08',NULL),(3452,11429,40944,279110,5,3452,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',707600.00,'BANCO GALICIA',NULL,1,'2025-10-13 09:30:54','2025-10-28 10:14:27','2025-10-28 10:14:27'),(3453,11429,40944,279114,5,3453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',714351.45,'BANCO GALICIA',NULL,1,'2025-10-13 12:00:02','2025-10-28 10:15:17','2025-10-28 10:15:17'),(3454,11429,40944,279115,5,3454,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',657201.84,'BANCO GALICIA',NULL,1,'2025-10-13 12:07:39','2025-10-28 10:39:32','2025-10-28 10:39:32'),(3455,11429,40946,277588,3,3455,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2977887.56,'COMPRAS',NULL,1,'2025-10-17 11:48:27','2025-10-17 11:48:27',NULL);
INSERT INTO `balance_libro` VALUES (3456,11429,40946,277594,3,3456,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',59311101.76,'COMPRAS',NULL,1,'2025-10-17 12:10:54','2025-10-17 12:10:54',NULL),(3457,11429,40946,277594,5,3457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',35022716.34,'Banco ICBC En Pesos',NULL,1,'2025-10-17 12:12:54','2025-10-17 12:12:54',NULL),(3458,11429,40946,277594,5,3458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',58547335.00,'Banco ICBC En Dolares',NULL,1,'2025-10-17 12:16:38','2025-10-17 12:16:38',NULL),(3459,7941,40915,272956,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-22','2025-10-22',80000.00,NULL,NULL,1,'2025-10-22 16:43:34','2025-10-22 16:43:34',NULL),(3460,7941,40915,272956,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-22','2025-10-22',1040000.00,NULL,NULL,1,'2025-10-22 16:43:35','2025-10-22 16:43:35',NULL),(3461,7941,40915,272956,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-22','2025-10-22',650000.00,NULL,NULL,1,'2025-10-22 16:43:36','2025-10-22 16:43:36',NULL),(3462,7941,40915,272956,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',105000.00,NULL,NULL,1,'2025-10-23 11:39:12','2025-10-23 11:39:12',NULL),(3463,7941,40915,272956,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',180000.00,NULL,NULL,1,'2025-10-23 11:39:14','2025-10-23 11:39:14',NULL),(3464,7941,40915,272956,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',350000.00,NULL,NULL,1,'2025-10-23 11:39:15','2025-10-23 11:39:15',NULL),(3465,7941,40915,272956,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',180000.00,NULL,NULL,1,'2025-10-23 11:39:16','2025-10-23 11:39:16',NULL),(3466,7941,40915,272956,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',45000.00,NULL,NULL,1,'2025-10-23 11:39:17','2025-10-23 11:39:17',NULL),(3467,7941,40915,272956,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',300000.00,NULL,NULL,1,'2025-10-23 11:39:18','2025-10-23 11:39:18',NULL),(3468,7941,40915,272956,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',200000.00,NULL,NULL,1,'2025-10-23 11:43:28','2025-10-23 11:43:28',NULL),(3469,7941,40915,272956,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',550000.00,NULL,NULL,1,'2025-10-23 11:43:29','2025-10-23 11:43:29',NULL),(3470,7941,40915,272956,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',220000.00,NULL,NULL,1,'2025-10-23 11:43:30','2025-10-23 11:43:30',NULL),(3471,7941,40915,272956,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',170000.00,NULL,NULL,1,'2025-10-23 11:43:31','2025-10-23 11:43:31',NULL),(3472,7941,40915,272956,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',170000.00,NULL,NULL,1,'2025-10-23 11:43:32','2025-10-23 11:43:32',NULL),(3473,7941,40915,272956,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',90000.00,NULL,NULL,1,'2025-10-23 11:43:33','2025-10-23 11:43:33',NULL),(3474,7941,40719,57,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',1010000.00,NULL,NULL,1,'2025-10-23 15:25:06','2025-10-23 15:25:06',NULL),(3475,7941,40719,57,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',800000.00,NULL,NULL,1,'2025-10-23 15:25:07','2025-10-23 15:25:07',NULL);
INSERT INTO `balance_libro` VALUES (3476,7941,40719,57,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',290000.00,NULL,NULL,1,'2025-10-23 15:25:09','2025-10-23 15:25:09',NULL),(3477,7941,40719,57,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',200000.00,NULL,NULL,1,'2025-10-23 15:25:10','2025-10-23 15:25:10',NULL),(3478,7941,40719,57,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',200000.00,NULL,NULL,1,'2025-10-23 15:25:11','2025-10-23 15:25:11',NULL),(3479,7941,40719,57,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',150000.00,NULL,NULL,1,'2025-10-23 15:34:14','2025-10-23 15:34:14',NULL),(3480,7941,40719,57,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',100000.00,NULL,NULL,1,'2025-10-23 15:34:15','2025-10-23 15:34:15',NULL),(3481,7941,40719,57,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',240000.00,NULL,NULL,1,'2025-10-23 15:34:16','2025-10-23 15:34:16',NULL),(3482,7941,40719,57,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',220000.00,NULL,NULL,1,'2025-10-23 15:34:17','2025-10-23 15:34:17',NULL),(3483,7941,40719,57,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',290000.00,NULL,NULL,1,'2025-10-23 15:34:19','2025-10-23 15:34:19',NULL),(3484,7941,40719,57,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',250000.00,NULL,NULL,1,'2025-10-23 15:34:20','2025-10-23 15:34:20',NULL),(3485,7941,40719,57,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',500000.00,NULL,NULL,1,'2025-10-23 15:34:21','2025-10-23 15:34:21',NULL),(3486,11429,40944,279110,15,3486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',117786.43,'DJ IVA',NULL,1,'2025-10-28 09:48:26','2025-10-28 09:48:26',NULL),(3487,11429,40944,279115,16,3487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',1425.00,'DJ IIBB',NULL,1,'2025-10-28 09:57:22','2025-10-28 09:57:22',NULL),(3488,11429,40944,279114,16,3488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1000.00,'DJ IIBB',NULL,1,'2025-10-28 09:58:28','2025-10-28 09:58:28',NULL),(3489,11429,40944,279112,5,3489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',17.54,'BANCO GALICIA',NULL,1,'2025-10-28 10:11:23','2025-10-28 10:11:23',NULL),(3490,11429,40944,279113,5,3490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',350200.00,'BANCO GALICIA',NULL,1,'2025-10-28 10:12:26','2025-10-28 10:12:26',NULL),(3491,11429,40944,279110,5,3491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',707600.00,'BANCO GALICIA',NULL,1,'2025-10-28 10:14:27','2025-10-28 10:14:27',NULL),(3492,11429,40944,279114,5,3492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',714351.45,'BANCO GALICIA',NULL,1,'2025-10-28 10:15:17','2025-10-28 10:15:17',NULL),(3493,11429,40944,279115,5,3493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',657201.84,'BANCO GALICIA',NULL,1,'2025-10-28 10:39:32','2025-10-28 10:39:32',NULL),(3494,11429,40930,280629,2,3494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',31935936.04,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:29:09','2025-10-30 15:29:09',NULL),(3495,11429,40930,280630,2,3495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',32801562.41,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:30:37','2025-10-30 15:30:37',NULL);
INSERT INTO `balance_libro` VALUES (3496,11429,40930,280631,2,3496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',44524257.91,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:31:50','2025-10-30 15:31:50',NULL),(3497,11429,40930,280634,2,3497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',28462301.65,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:34:03','2025-10-30 15:34:03',NULL),(3498,11429,40930,280635,2,3498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',28336517.77,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:35:49','2025-10-30 15:35:49',NULL),(3499,11429,40930,280636,2,3499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',37343935.98,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:37:13','2025-10-30 15:37:13',NULL),(3500,11429,40930,280637,2,3500,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',42270799.76,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:43:12','2025-10-30 15:43:12',NULL),(3501,11429,40930,280638,2,3501,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',45842262.90,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:45:23','2025-10-30 15:45:23',NULL),(3502,11429,40930,280639,2,3502,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',38759421.50,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:47:34','2025-10-30 15:47:34',NULL),(3503,11429,40930,280640,2,3503,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-30','2025-07-30',15060165.75,'SUBDIARIO VENTAS',NULL,1,'2025-10-30 15:51:10','2025-10-30 15:51:10',NULL),(3504,11429,40930,280629,15,3504,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',3430689.33,'DJ IVA',NULL,1,'2025-10-30 16:17:37','2025-10-30 16:17:37',NULL),(3505,11429,40930,280630,15,3505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3133329.46,'DJ IVA',NULL,1,'2025-10-30 16:21:39','2025-10-30 16:21:39',NULL),(3506,11429,40930,280631,15,3506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4571524.96,'DJ IVA',NULL,1,'2025-10-30 16:27:24','2025-10-30 16:27:24',NULL),(3507,11429,40930,280634,15,3507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',2933397.60,'DJ IVA',NULL,1,'2025-10-30 16:33:37','2025-10-30 16:33:37',NULL),(3508,11429,40930,280635,15,3508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',2751712.22,'DJ IVA',NULL,1,'2025-10-30 16:35:37','2025-10-30 16:35:37',NULL),(3509,11429,40930,280636,15,3509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',3563546.63,'DJ IVA',NULL,1,'2025-10-30 16:37:39','2025-10-30 16:37:39',NULL),(3510,11429,40930,280637,15,3510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',4057988.76,'DJ IVA',NULL,1,'2025-10-30 16:41:45','2025-10-30 16:41:45',NULL),(3511,11429,40930,280638,15,3511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',4401282.90,'DJ IVA',NULL,1,'2025-10-30 16:43:35','2025-10-30 16:43:35',NULL),(3512,11429,40930,280639,15,3512,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',3778156.20,'DJ IVA',NULL,1,'2025-10-30 16:45:28','2025-10-30 16:45:28',NULL),(3513,11429,40930,280640,15,3513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',1459515.75,'DJ IVA',NULL,1,'2025-10-30 16:47:05','2025-10-30 16:47:05',NULL),(3514,11429,40930,280629,16,3514,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',855157.40,'DJ IIBB',NULL,1,'2025-10-30 17:05:02','2025-10-30 17:25:08','2025-10-30 17:25:08');
INSERT INTO `balance_libro` VALUES (3515,11429,40930,280630,16,3515,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',593364.64,'DJ IIBB',NULL,1,'2025-10-30 17:07:40','2025-10-30 17:28:14','2025-10-30 17:28:14'),(3516,11429,40930,280631,16,3516,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',841645.02,'DJ IIBB',NULL,1,'2025-10-30 17:11:39','2025-10-30 17:11:39',NULL),(3517,11429,40930,280634,16,3517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',772221.90,'DJ IIBB',NULL,1,'2025-10-30 17:20:49','2025-10-30 17:20:49',NULL),(3518,11429,40930,280635,16,3518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',768758.49,'DJ IIBB',NULL,1,'2025-10-30 17:23:12','2025-10-30 17:29:57','2025-10-30 17:29:57'),(3519,11429,40930,280629,16,3519,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',855157.40,'DJ IIBB',NULL,1,'2025-10-30 17:25:08','2025-10-30 17:25:08',NULL),(3520,11429,40930,280630,16,3520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',593364.64,'DJ IIBB',NULL,1,'2025-10-30 17:28:14','2025-10-30 17:28:14',NULL),(3521,11429,40930,280635,16,3521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',768758.49,'DJ IIBB',NULL,1,'2025-10-30 17:29:57','2025-10-30 17:29:57',NULL),(3522,11429,40930,280636,16,3522,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',1013201.68,'DJ IIBB',NULL,1,'2025-10-31 09:15:43','2025-10-31 09:15:43',NULL),(3523,11429,40930,280637,16,3523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',1147033.86,'DJ IIBB',NULL,1,'2025-10-31 09:21:41','2025-10-31 09:21:41',NULL),(3524,11429,40930,280638,16,3524,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',1243229.40,'DJ IIBB',NULL,1,'2025-10-31 09:28:32','2025-10-31 09:28:32',NULL),(3525,11429,40930,280639,16,3525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',1051089.00,'DJ IIBB',NULL,1,'2025-10-31 09:36:53','2025-10-31 09:36:53',NULL),(3526,11429,40930,280640,16,3526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',408019.50,'DJ IIBB',NULL,1,'2025-10-31 09:39:01','2025-10-31 09:39:01',NULL),(3527,11429,40930,280627,12,3527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',2000000.00,'Saldos Iniciales',NULL,1,'2025-10-31 14:55:56','2025-10-31 14:55:56',NULL),(3528,11429,40881,221322,2,3528,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',7651810.10,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 12:14:58','2025-11-05 12:14:58',NULL),(3529,11429,40881,221323,2,3529,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1826524.04,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 12:20:40','2025-11-05 12:20:40',NULL),(3530,11429,40881,221325,2,3530,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',18428300.00,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 13:06:16','2025-11-05 13:06:16',NULL),(3531,11429,40881,221326,2,3531,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2045475.96,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 13:08:06','2025-11-05 13:08:06',NULL),(3532,11429,40881,221330,2,3532,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',2131905.05,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 13:38:07','2025-11-05 13:38:07',NULL),(3533,11429,40881,221331,2,3533,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',3835410.81,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 13:40:51','2025-11-05 13:40:51',NULL);
INSERT INTO `balance_libro` VALUES (3534,11429,40881,221332,2,3534,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',549974.04,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 13:42:45','2025-11-05 13:42:45',NULL),(3535,11429,40881,221333,2,3535,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',2621667.07,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 13:45:42','2025-11-05 13:45:42',NULL),(3536,11429,40881,221334,2,3536,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',2880951.92,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 13:58:15','2025-11-05 13:58:15',NULL),(3537,11429,40881,221335,2,3537,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',648213.94,NULL,NULL,1,'2025-11-05 14:03:49','2025-11-05 14:03:49',NULL),(3538,11429,40881,221336,2,3538,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',9075000.00,'SUBDIARIO VENTAS',NULL,1,'2025-11-05 14:09:22','2025-11-05 14:09:22',NULL),(3539,11429,40881,221322,15,3539,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',1330608.02,'DJ IVA',NULL,1,'2025-11-05 14:35:14','2025-11-05 14:35:14',NULL),(3540,11429,40881,221323,15,3540,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',317000.04,'DJ IVA',NULL,1,'2025-11-05 14:49:01','2025-11-05 14:49:01',NULL),(3541,11429,40881,221324,15,3541,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',6766.94,'DJ IVA',NULL,1,'2025-11-05 15:08:01','2025-11-05 15:08:01',NULL),(3542,11429,40881,221325,15,3542,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',3198300.00,'DJ IVA',NULL,1,'2025-11-05 15:11:40','2025-11-05 15:11:40',NULL),(3543,11429,40881,221326,15,3543,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',360133.27,'DJ IVA',NULL,1,'2025-11-05 15:21:37','2025-11-05 15:21:37',NULL),(3544,11429,40881,221330,15,3544,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',385654.48,'DJ IVA',NULL,1,'2025-11-05 15:41:06','2025-11-05 15:41:06',NULL),(3545,11429,40881,221331,15,3545,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',674711.84,'DJ IVA',NULL,1,'2025-11-05 16:45:54','2025-11-05 16:45:54',NULL),(3546,11429,40881,221332,15,3546,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',283180.81,'DJ IVA',NULL,1,'2025-11-05 17:19:41','2025-11-05 17:19:41',NULL),(3547,11429,40881,221333,15,3547,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',594520.53,'DJ IVA',NULL,1,'2025-11-05 17:29:40','2025-11-05 17:29:40',NULL),(3548,11429,40881,221334,15,3548,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',500433.55,'DJ IVA',NULL,1,'2025-11-05 17:38:44','2025-11-05 17:38:44',NULL),(3549,11429,40881,221335,15,3549,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',114936.60,'DJ IVA',NULL,1,'2025-11-05 17:41:12','2025-11-05 17:41:12',NULL),(3550,11429,40881,221336,15,3550,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',1647351.74,'DJ IVA',NULL,1,'2025-11-05 17:44:43','2025-11-05 17:44:43',NULL),(3551,11429,40881,221322,16,3551,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',458400.85,'DJ IIBB',NULL,1,'2025-11-06 09:47:16','2025-11-06 09:47:16',NULL),(3552,11429,40881,221323,16,3552,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',331924.65,'DJ IIBB',NULL,1,'2025-11-06 09:49:01','2025-11-06 09:49:01',NULL);
INSERT INTO `balance_libro` VALUES (3553,11429,40881,221324,16,3553,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',301734.17,'DJ IIBB',NULL,1,'2025-11-06 09:50:06','2025-11-06 09:50:06',NULL),(3554,11429,40881,221325,16,3554,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',304600.00,'DJ IIBB',NULL,1,'2025-11-06 09:53:00','2025-11-06 09:53:00',NULL),(3555,11429,40881,221326,16,3555,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',33809.52,'DJ IIBB',NULL,1,'2025-11-06 09:55:21','2025-11-06 09:55:21',NULL),(3556,11429,40881,221330,16,3556,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',91300.00,'DJ IIBB',NULL,1,'2025-11-06 09:59:51','2025-11-06 09:59:51',NULL),(3557,11429,40881,221331,16,3557,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',99161.90,'DJ IIBB',NULL,1,'2025-11-06 10:12:51','2025-11-06 10:12:51',NULL),(3558,11429,40881,221332,16,3558,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',118626.68,'DJ IIBB',NULL,1,'2025-11-06 10:22:27','2025-11-06 10:22:27',NULL),(3559,11429,40881,221333,16,3559,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',109536.20,'DJ IIBB',NULL,1,'2025-11-06 10:32:28','2025-11-06 10:32:28',NULL),(3560,11429,40881,221334,16,3560,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',66202.86,'DJ IIBB',NULL,1,'2025-11-06 10:37:34','2025-11-06 10:37:34',NULL),(3561,11429,40881,221335,16,3561,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',18583.82,'DJ IIBB',NULL,1,'2025-11-06 10:39:59','2025-11-06 10:39:59',NULL),(3562,11429,40881,221336,16,3562,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',150000.00,'DJ IIBB',NULL,1,'2025-11-06 10:41:25','2025-11-06 10:41:25',NULL),(3563,11429,40881,221322,12,3563,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',887356391.00,'Saldos Iniciales',NULL,1,'2025-11-06 11:27:46','2025-11-06 11:27:46',NULL),(3564,11429,40930,280629,3,3564,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',32781463.57,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 15:30:43','2025-11-07 09:47:40','2025-11-07 09:47:40'),(3565,11429,40930,280630,3,3565,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',31240440.58,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 16:39:53','2025-11-06 16:39:53',NULL),(3566,11429,40930,280631,3,3566,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',40658301.75,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 16:47:29','2025-11-06 16:47:29',NULL),(3567,11429,40930,280634,3,3567,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',26700399.66,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 16:51:57','2025-11-06 16:51:57',NULL),(3568,11429,40930,280635,3,3568,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',24770866.79,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 16:57:27','2025-11-06 16:57:27',NULL),(3569,11429,40930,280636,3,3569,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',34145120.67,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 17:01:55','2025-11-06 17:01:55',NULL),(3570,11429,40930,280637,3,3570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',40259264.76,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 17:06:27','2025-11-06 17:06:27',NULL),(3571,11429,40930,280638,3,3571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',43185337.07,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 17:17:03','2025-11-06 17:17:03',NULL);
INSERT INTO `balance_libro` VALUES (3572,11429,40930,280639,3,3572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',35295601.16,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 17:20:42','2025-11-06 17:20:42',NULL),(3573,11429,40930,280640,3,3573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',15178283.47,'SUBDIARIO COMPRAS',NULL,1,'2025-11-06 17:32:19','2025-11-06 17:32:19',NULL),(3574,11429,40930,280629,3,3574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',32781463.57,'SUBDIARIO COMPRAS',NULL,1,'2025-11-07 09:47:40','2025-11-07 09:47:40',NULL),(3575,11429,40930,280629,1,3575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2022571.89,'Sueldos',NULL,1,'2025-11-13 13:15:10','2025-11-13 13:15:10',NULL),(3576,11429,40930,280630,1,3576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2022614.89,'Sueldos',NULL,1,'2025-11-13 13:16:45','2025-11-13 13:16:45',NULL),(3577,11429,40930,280631,1,3577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2528028.39,'Sueldos',NULL,1,'2025-11-13 13:18:02','2025-11-13 13:18:02',NULL),(3578,11429,40930,280634,1,3578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',2022717.89,'Sueldos',NULL,1,'2025-11-13 13:20:38','2025-11-13 13:20:38',NULL),(3579,11429,40930,280635,1,3579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',2022741.89,'Sueldos',NULL,1,'2025-11-13 13:22:13','2025-11-13 13:22:13',NULL),(3580,11429,40930,280636,1,3580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2022931.68,'Sueldos',NULL,1,'2025-11-13 13:23:37','2025-11-13 13:23:37',NULL),(3581,11429,40930,280637,1,3581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',2023007.68,'Sueldos',NULL,1,'2025-11-13 13:24:54','2025-11-13 13:24:54',NULL),(3582,11429,40930,280638,1,3582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',2023059.68,'Sueldos',NULL,1,'2025-11-13 13:26:14','2025-11-13 13:26:14',NULL),(3583,11429,40930,280639,1,3583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',3033783.68,'Sueldos',NULL,1,'2025-11-13 13:27:55','2025-11-13 13:27:55',NULL),(3584,11429,40930,280640,1,3584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',2023124.68,'Sueldos',NULL,1,'2025-11-13 13:29:11','2025-11-13 13:29:11',NULL),(3585,11429,40930,280627,5,3585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',17862802.13,'Banco Galicia',NULL,1,'2025-11-19 15:04:39','2025-11-20 14:22:03','2025-11-20 14:22:03'),(3586,11429,40930,280630,5,3586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',36274402.25,'Banco Galicia',NULL,1,'2025-11-19 15:58:52','2025-11-19 15:58:52',NULL),(3587,11429,40930,280631,5,3587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',48486708.62,'Banco Galicia',NULL,1,'2025-11-19 16:17:32','2025-11-19 16:17:32',NULL),(3588,11429,40930,280634,5,3588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',36714532.48,'Banco Galicia',NULL,1,'2025-11-19 17:26:12','2025-11-19 17:26:12',NULL),(3589,11429,40930,280635,5,3589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',29827484.85,'Banco Galicia',NULL,1,'2025-11-20 09:26:32','2025-11-20 09:26:32',NULL),(3590,11429,40930,280636,5,3590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',31060891.56,'Banco Galicia',NULL,1,'2025-11-20 09:51:35','2025-11-20 09:51:35',NULL);
INSERT INTO `balance_libro` VALUES (3591,11429,40930,280637,5,3591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',44767899.45,'Banco Galicia',NULL,1,'2025-11-20 10:03:02','2025-11-20 10:03:02',NULL),(3592,11429,40930,280638,5,3592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',42347084.88,'Banco Galicia',NULL,1,'2025-11-20 10:10:36','2025-11-20 10:10:36',NULL),(3593,11429,40930,280639,5,3593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',52506978.83,'Banco Galicia',NULL,1,'2025-11-20 10:20:36','2025-11-20 10:20:36',NULL),(3594,11429,40930,280640,5,3594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',23796165.80,'Banco Galicia',NULL,1,'2025-11-20 10:33:28','2025-11-20 10:33:28',NULL),(3595,11429,40930,280629,5,3595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',17862802.13,'Banco Galicia',NULL,1,'2025-11-20 14:22:03','2025-11-20 14:22:03',NULL),(3596,11429,40930,280634,5,3596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',289278.00,'Tarjeta de Credito VISA',NULL,1,'2025-11-20 17:46:29','2025-11-20 17:54:17','2025-11-20 17:54:17'),(3597,11429,40930,280635,5,3597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1186938.66,'Tarjeta De Credito Visa',NULL,1,'2025-11-20 17:48:15','2025-11-20 17:55:06','2025-11-20 17:55:06'),(3598,11429,40930,280636,5,3598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',236186.14,'Tarjeta De Credito VISA',NULL,1,'2025-11-20 17:50:06','2025-11-20 17:55:48','2025-11-20 17:55:48'),(3599,11429,40930,280637,5,3599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',568952.33,'Tarjeta De Credito VISA',NULL,1,'2025-11-20 17:53:10','2025-11-20 17:53:10',NULL),(3600,11429,40930,280634,5,3600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',289278.00,'Tarjeta De Credito VISA',NULL,1,'2025-11-20 17:54:17','2025-11-20 17:54:17',NULL),(3601,11429,40930,280635,5,3601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1186938.66,'Tarjeta De Credito Visa',NULL,1,'2025-11-20 17:55:06','2025-11-20 17:55:06',NULL),(3602,11429,40930,280636,5,3602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',236186.14,'Tarjeta De Credito VISA',NULL,1,'2025-11-20 17:55:48','2025-11-20 17:55:48',NULL),(3603,11429,40930,280638,5,3603,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',374741.64,'Tarjeta De Credito VISA',NULL,1,'2025-11-20 17:57:40','2025-11-20 17:57:40',NULL),(3604,11429,40930,280639,5,3604,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',268010.72,'Tarjeta De Credito VISA',NULL,1,'2025-11-20 17:59:12','2025-11-20 17:59:12',NULL),(3605,11429,40930,280640,5,3605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',734079.37,'Tarjeta De Credito VISA',NULL,1,'2025-11-20 18:01:53','2025-11-20 18:01:53',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27219 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7941,1,40734,22734,1,110,1,9152402.16,NULL,'2022-11-27 17:04:33','2022-11-27 17:04:33',NULL),(2,7941,1,40734,22734,1,111,1,1716852.28,NULL,'2022-11-27 17:04:33','2022-11-27 17:04:33',NULL),(3,7941,1,40734,22734,1,112,1,67021.90,NULL,'2022-11-27 17:04:34','2022-11-27 17:04:34',NULL),(4,7941,1,40734,22734,1,62,2,8000139.54,NULL,'2022-11-27 17:04:34','2022-11-27 17:04:34',NULL),(5,7941,1,40734,22734,1,63,2,2806446.25,NULL,'2022-11-27 17:04:34','2022-11-27 17:04:34',NULL),(6,7941,1,40734,22734,1,64,2,129690.55,NULL,'2022-11-27 17:04:34','2022-11-27 17:04:34',NULL),(7,7941,1,40734,22734,1,63,1,761819.12,NULL,'2022-11-27 17:04:34','2022-11-27 17:04:34',NULL),(8,7941,1,40734,22734,1,162,2,761819.12,NULL,'2022-11-27 17:04:34','2022-11-27 17:04:34',NULL),(9,7941,2,40734,22735,1,110,1,8158893.87,NULL,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(10,7941,2,40734,22735,1,111,1,1818790.27,NULL,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(11,7941,2,40734,22735,1,112,1,69149.99,NULL,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(12,7941,2,40734,22735,1,62,2,6942269.67,NULL,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(13,7941,2,40734,22735,1,63,2,2967346.12,NULL,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(14,7941,2,40734,22735,1,64,2,137218.34,NULL,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(15,7941,2,40734,22735,1,63,1,408533.08,NULL,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(16,7941,2,40734,22735,1,162,2,408533.08,NULL,'2022-12-13 10:13:18','2022-12-13 10:13:18',NULL),(17,7941,3,40734,22736,1,110,1,13461061.12,NULL,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(18,7941,3,40734,22736,1,111,1,2724714.24,NULL,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(19,7941,3,40734,22736,1,112,1,102221.80,NULL,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(20,7941,3,40734,22736,1,62,2,11646071.40,NULL,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(21,7941,3,40734,22736,1,63,2,4449165.26,NULL,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(22,7941,3,40734,22736,1,64,2,192760.50,NULL,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(23,7941,3,40734,22736,1,63,1,1210660.78,NULL,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(24,7941,3,40734,22736,1,162,2,1210660.78,NULL,'2023-01-06 14:22:27','2023-01-06 14:22:27',NULL),(25,7941,4,40735,24237,2,14,1,6559793.53,NULL,'2023-04-08 11:39:35','2023-04-08 11:39:35',NULL),(26,7941,4,40735,24237,2,67,2,1138476.56,NULL,'2023-04-08 11:39:35','2023-04-08 11:39:35',NULL),(27,7941,4,40735,24237,2,96,2,5421316.97,NULL,'2023-04-08 11:39:35','2023-04-08 11:39:35',NULL),(28,7941,5,40735,24238,2,14,1,3269041.37,NULL,'2023-04-11 08:27:54','2023-04-11 08:27:54',NULL),(29,7941,5,40735,24238,2,67,2,567354.29,NULL,'2023-04-11 08:27:54','2023-04-11 08:27:54',NULL),(30,7941,5,40735,24238,2,96,2,2701687.08,NULL,'2023-04-11 08:27:54','2023-04-11 08:27:54',NULL),(31,7941,6,40735,24239,2,14,1,4944248.29,NULL,'2023-04-11 08:29:44','2023-04-11 08:29:44',NULL),(32,7941,6,40735,24239,2,67,2,858092.68,NULL,'2023-04-11 08:29:44','2023-04-11 08:29:44',NULL),(33,7941,6,40735,24239,2,96,2,4086155.61,NULL,'2023-04-11 08:29:44','2023-04-11 08:29:44',NULL),(34,7941,7,40735,24240,2,14,1,4635120.38,NULL,'2023-04-11 08:31:00','2023-04-11 08:31:00',NULL),(35,7941,7,40735,24240,2,67,2,804442.38,NULL,'2023-04-11 08:31:00','2023-04-11 08:31:00',NULL),(36,7941,7,40735,24240,2,96,2,3830678.00,NULL,'2023-04-11 08:31:00','2023-04-11 08:31:00',NULL),(37,7941,8,40735,24241,2,14,1,6757033.64,NULL,'2023-04-11 08:32:27','2023-04-11 08:32:27',NULL),(38,7941,8,40735,24241,2,67,2,1172708.32,NULL,'2023-04-11 08:32:27','2023-04-11 08:32:27',NULL),(39,7941,8,40735,24241,2,96,2,5584325.32,NULL,'2023-04-11 08:32:27','2023-04-11 08:32:27',NULL),(40,7941,9,40735,24242,2,14,1,5663534.76,NULL,'2023-04-11 08:33:41','2023-04-11 08:33:41',NULL),(41,7941,9,40735,24242,2,67,2,668803.14,NULL,'2023-04-11 08:33:41','2023-04-11 08:33:41',NULL);
INSERT INTO `balance_libro_details` VALUES (42,7941,9,40735,24242,2,96,2,4994731.62,NULL,'2023-04-11 08:33:41','2023-04-11 08:33:41',NULL),(43,7941,10,40735,24243,2,14,1,5181620.21,NULL,'2023-04-11 08:34:56','2023-04-11 08:34:56',NULL),(44,7941,10,40735,24243,2,67,2,899289.46,NULL,'2023-04-11 08:34:56','2023-04-11 08:34:56',NULL),(45,7941,10,40735,24243,2,96,2,4282330.75,NULL,'2023-04-11 08:34:56','2023-04-11 08:34:56',NULL),(46,7941,11,40735,24244,2,14,1,1446002.43,NULL,'2023-04-11 08:36:06','2023-04-11 08:36:06',NULL),(47,7941,11,40735,24244,2,67,2,250959.10,NULL,'2023-04-11 08:36:06','2023-04-11 08:36:06',NULL),(48,7941,11,40735,24244,2,96,2,1195043.33,NULL,'2023-04-11 08:36:06','2023-04-11 08:36:06',NULL),(49,7941,12,40735,24245,2,14,1,8463962.39,NULL,'2023-04-11 08:37:27','2023-04-11 08:37:27',NULL),(50,7941,12,40735,24245,2,67,2,1468952.15,NULL,'2023-04-11 08:37:27','2023-04-11 08:37:27',NULL),(51,7941,12,40735,24245,2,96,2,6995010.24,NULL,'2023-04-11 08:37:27','2023-04-11 08:37:27',NULL),(52,7941,13,40735,24246,2,14,1,1289831.74,NULL,'2023-04-11 08:38:22','2023-04-11 08:38:22',NULL),(53,7941,13,40735,24246,2,67,2,223855.10,NULL,'2023-04-11 08:38:22','2023-04-11 08:38:22',NULL),(54,7941,13,40735,24246,2,96,2,1065976.64,NULL,'2023-04-11 08:38:22','2023-04-11 08:38:22',NULL),(55,7941,14,40735,24247,2,14,1,6140254.88,NULL,'2023-04-11 08:39:26','2023-04-11 08:39:26',NULL),(56,7941,14,40735,24247,2,67,2,1065664.07,NULL,'2023-04-11 08:39:26','2023-04-11 08:39:26',NULL),(57,7941,14,40735,24247,2,96,2,5074590.81,NULL,'2023-04-11 08:39:26','2023-04-11 08:39:26',NULL),(58,7941,15,40735,24248,2,14,1,1984076.54,NULL,'2023-04-11 08:40:52','2023-04-11 08:52:30','2023-04-11 08:52:30'),(59,7941,15,40735,24248,2,67,2,344343.86,NULL,'2023-04-11 08:40:52','2023-04-11 08:52:30','2023-04-11 08:52:30'),(60,7941,15,40735,24248,2,14,2,1639732.68,NULL,'2023-04-11 08:40:52','2023-04-11 08:52:30','2023-04-11 08:52:30'),(61,7941,16,40735,24248,2,14,1,1984076.54,NULL,'2023-04-11 08:52:30','2023-04-30 11:36:32','2023-04-30 11:36:32'),(62,7941,16,40735,24248,2,67,2,344343.86,NULL,'2023-04-11 08:52:30','2023-04-30 11:36:32','2023-04-30 11:36:32'),(63,7941,16,40735,24248,2,96,2,1639732.68,NULL,'2023-04-11 08:52:30','2023-04-30 11:36:32','2023-04-30 11:36:32'),(64,7941,17,40735,24237,15,67,1,1138476.56,NULL,'2023-04-13 09:16:31','2023-04-13 09:16:31',NULL),(65,7941,17,40735,24237,15,25,2,121372.22,NULL,'2023-04-13 09:16:31','2023-04-13 09:16:31',NULL),(66,7941,17,40735,24237,15,68,2,202383.10,NULL,'2023-04-13 09:16:31','2023-04-13 09:16:31',NULL),(67,7941,17,40735,24237,15,74,2,330824.98,NULL,'2023-04-13 09:16:31','2023-04-13 09:16:31',NULL),(68,7941,17,40735,24237,15,353,2,421859.71,NULL,'2023-04-13 09:16:31','2023-04-13 09:16:31',NULL),(69,7941,17,40735,24237,15,354,2,62036.55,NULL,'2023-04-13 09:16:31','2023-04-13 09:16:31',NULL),(70,7941,18,40735,24238,15,67,1,567354.29,NULL,'2023-04-13 09:19:45','2023-04-13 09:19:45',NULL),(71,7941,18,40735,24238,15,354,1,217373.16,NULL,'2023-04-13 09:19:45','2023-04-13 09:19:45',NULL),(72,7941,18,40735,24238,15,25,2,484813.87,NULL,'2023-04-13 09:19:45','2023-04-13 09:19:45',NULL),(73,7941,18,40735,24238,15,25,2,1965.60,NULL,'2023-04-13 09:19:45','2023-04-13 09:19:45',NULL),(74,7941,18,40735,24238,15,68,2,297947.98,NULL,'2023-04-13 09:19:45','2023-04-13 09:19:45',NULL),(75,7941,19,40735,24239,15,67,1,858092.68,NULL,'2023-04-13 09:21:57','2023-04-13 09:21:57',NULL),(76,7941,19,40735,24239,15,354,1,405683.22,NULL,'2023-04-13 09:21:57','2023-04-13 09:21:57',NULL),(77,7941,19,40735,24239,15,25,2,340818.89,NULL,'2023-04-13 09:21:57','2023-04-13 09:21:57',NULL),(78,7941,19,40735,24239,15,25,2,597.31,NULL,'2023-04-13 09:21:57','2023-04-13 09:21:57',NULL),(79,7941,19,40735,24239,15,68,2,704986.54,NULL,'2023-04-13 09:21:57','2023-04-13 09:21:57',NULL),(80,7941,19,40735,24239,15,354,2,217373.16,NULL,'2023-04-13 09:21:57','2023-04-13 09:21:57',NULL),(81,7941,20,40735,24240,15,67,1,804442.38,NULL,'2023-04-13 09:36:07','2023-04-13 09:36:07',NULL);
INSERT INTO `balance_libro_details` VALUES (82,7941,20,40735,24240,15,25,2,40304.78,NULL,'2023-04-13 09:36:07','2023-04-13 09:36:07',NULL),(83,7941,20,40735,24240,15,25,2,1850.85,NULL,'2023-04-13 09:36:07','2023-04-13 09:36:07',NULL),(84,7941,20,40735,24240,15,68,2,265857.68,NULL,'2023-04-13 09:36:07','2023-04-13 09:36:07',NULL),(85,7941,20,40735,24240,15,74,2,90745.84,NULL,'2023-04-13 09:36:07','2023-04-13 09:36:07',NULL),(86,7941,20,40735,24240,15,354,2,405683.23,NULL,'2023-04-13 09:36:07','2023-04-13 09:36:07',NULL),(87,7941,21,40735,24241,15,67,1,1172708.32,NULL,'2023-04-13 09:38:24','2023-04-13 09:38:24',NULL),(88,7941,21,40735,24241,15,354,1,96335.14,NULL,'2023-04-13 09:38:24','2023-04-13 09:38:24',NULL),(89,7941,21,40735,24241,15,25,2,528482.35,NULL,'2023-04-13 09:38:24','2023-04-13 09:38:24',NULL),(90,7941,21,40735,24241,15,25,2,2648.16,NULL,'2023-04-13 09:38:24','2023-04-13 09:38:24',NULL),(91,7941,21,40735,24241,15,68,2,737912.95,NULL,'2023-04-13 09:38:24','2023-04-13 09:38:24',NULL),(92,7941,22,40735,24242,15,67,1,668803.14,NULL,'2023-04-13 09:40:48','2023-04-13 09:40:48',NULL),(93,7941,22,40735,24242,15,353,1,164102.24,NULL,'2023-04-13 09:40:48','2023-04-13 09:40:48',NULL),(94,7941,22,40735,24242,15,354,1,214754.77,NULL,'2023-04-13 09:40:48','2023-04-13 09:40:48',NULL),(95,7941,22,40735,24242,15,25,2,207160.80,NULL,'2023-04-13 09:40:48','2023-04-13 09:40:48',NULL),(96,7941,22,40735,24242,15,25,2,2004.67,NULL,'2023-04-13 09:40:48','2023-04-13 09:40:48',NULL),(97,7941,22,40735,24242,15,68,2,832905.38,NULL,'2023-04-13 09:40:48','2023-04-13 09:40:48',NULL),(98,7941,22,40735,24242,15,354,2,5589.30,NULL,'2023-04-13 09:40:48','2023-04-13 09:40:48',NULL),(99,7941,23,40735,24243,15,67,1,899289.46,NULL,'2023-04-13 09:45:11','2023-04-13 09:45:11',NULL),(100,7941,23,40735,24243,15,25,2,4545.21,NULL,'2023-04-13 09:45:11','2023-04-13 09:45:11',NULL),(101,7941,23,40735,24243,15,68,2,139248.78,NULL,'2023-04-13 09:45:11','2023-04-13 09:45:11',NULL),(102,7941,23,40735,24243,15,74,2,376638.46,NULL,'2023-04-13 09:45:11','2023-04-13 09:45:11',NULL),(103,7941,23,40735,24243,15,353,2,164102.24,NULL,'2023-04-13 09:45:11','2023-04-13 09:45:11',NULL),(104,7941,23,40735,24243,15,354,2,214754.77,NULL,'2023-04-13 09:45:11','2023-04-13 09:45:11',NULL),(105,7941,24,40735,24244,15,67,1,250959.10,NULL,'2023-04-13 09:46:40','2023-04-13 09:46:40',NULL),(106,7941,24,40735,24244,15,25,2,89434.80,NULL,'2023-04-13 09:46:40','2023-04-13 09:46:40',NULL),(107,7941,24,40735,24244,15,25,2,3870.54,NULL,'2023-04-13 09:46:40','2023-04-13 09:46:40',NULL),(108,7941,24,40735,24244,15,68,2,95847.73,NULL,'2023-04-13 09:46:40','2023-04-13 09:46:40',NULL),(109,7941,24,40735,24244,15,74,2,61806.03,NULL,'2023-04-13 09:46:40','2023-04-13 09:46:40',NULL),(114,7941,27,40735,24245,15,67,1,1468952.15,NULL,'2023-04-13 09:50:57','2023-04-13 09:50:57',NULL),(115,7941,27,40735,24245,15,68,2,253465.83,NULL,'2023-04-13 09:50:57','2023-04-13 09:50:57',NULL),(116,7941,27,40735,24245,15,74,2,1215747.40,NULL,'2023-04-13 09:50:57','2023-04-13 09:50:57',NULL),(117,7941,27,40735,24245,15,25,1,261.08,NULL,'2023-04-13 09:50:57','2023-04-13 09:50:57',NULL),(118,7941,28,40735,24246,15,67,1,223855.10,NULL,'2023-04-13 09:53:46','2023-04-13 09:53:46',NULL),(119,7941,28,40735,24246,15,353,1,471605.84,NULL,'2023-04-13 09:53:46','2023-04-13 09:53:46',NULL),(120,7941,28,40735,24246,15,354,1,431294.90,NULL,'2023-04-13 09:53:46','2023-04-13 09:53:46',NULL),(121,7941,28,40735,24246,15,25,2,429020.02,NULL,'2023-04-13 09:53:46','2023-04-13 09:53:46',NULL),(122,7941,28,40735,24246,15,25,2,2274.88,NULL,'2023-04-13 09:53:46','2023-04-13 09:53:46',NULL),(123,7941,28,40735,24246,15,68,2,695460.94,NULL,'2023-04-13 09:53:46','2023-04-13 09:53:46',NULL),(124,7941,29,40735,24247,15,67,1,1065664.07,NULL,'2023-04-13 09:55:01','2023-04-13 09:55:01',NULL),(125,7941,29,40735,24247,15,25,2,412.54,NULL,'2023-04-13 09:55:01','2023-04-13 09:55:01',NULL),(126,7941,29,40735,24247,15,68,2,287962.48,NULL,'2023-04-13 09:55:01','2023-04-13 09:55:01',NULL);
INSERT INTO `balance_libro_details` VALUES (127,7941,29,40735,24247,15,74,2,305683.21,NULL,'2023-04-13 09:55:01','2023-04-13 09:55:01',NULL),(128,7941,29,40735,24247,15,353,2,471605.84,NULL,'2023-04-13 09:55:01','2023-04-13 09:55:01',NULL),(129,7941,30,40735,24248,15,67,1,344343.86,NULL,'2023-04-13 09:56:04','2023-04-13 10:01:27','2023-04-13 10:01:27'),(130,7941,30,40735,24248,15,25,2,4353.19,NULL,'2023-04-13 09:56:04','2023-04-13 10:01:27','2023-04-13 10:01:27'),(131,7941,30,40735,24248,15,68,2,175500.74,NULL,'2023-04-13 09:56:04','2023-04-13 10:01:27','2023-04-13 10:01:27'),(132,7941,30,40735,24248,15,74,2,164489.93,NULL,'2023-04-13 09:56:04','2023-04-13 10:01:27','2023-04-13 10:01:27'),(133,7941,31,40735,24248,15,67,1,344343.86,NULL,'2023-04-13 10:01:27','2023-04-13 10:01:27',NULL),(134,7941,31,40735,24248,15,25,2,4353.19,NULL,'2023-04-13 10:01:27','2023-04-13 10:01:27',NULL),(135,7941,31,40735,24248,15,68,2,175500.74,NULL,'2023-04-13 10:01:27','2023-04-13 10:01:27',NULL),(136,7941,31,40735,24248,15,74,2,164489.93,NULL,'2023-04-13 10:01:27','2023-04-13 10:01:27',NULL),(137,7941,32,40735,24237,16,156,1,135532.92,NULL,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(138,7941,32,40735,24237,16,302,1,15953.94,NULL,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(139,7941,32,40735,24237,16,315,1,4377.85,NULL,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(140,7941,32,40735,24237,16,252,2,33.80,NULL,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(141,7941,32,40735,24237,16,251,2,2891.52,NULL,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(142,7941,32,40735,24237,16,302,2,18269.14,NULL,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(143,7941,32,40735,24237,16,315,2,4377.85,NULL,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(144,7941,32,40735,24237,16,326,2,130292.40,NULL,'2023-04-13 12:32:11','2023-04-13 12:32:11',NULL),(145,7941,33,40735,24238,16,156,1,67542.18,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(146,7941,33,40735,24238,16,315,1,4377.85,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(147,7941,33,40735,24238,16,302,1,33358.56,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(148,7941,33,40735,24238,16,252,2,2610.00,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(149,7941,33,40735,24238,16,252,2,14794.62,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(150,7941,33,40735,24238,16,251,2,18297.67,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(151,7941,33,40735,24238,16,302,2,15953.94,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(152,7941,33,40735,24238,16,315,2,4377.85,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(153,7941,33,40735,24238,16,326,2,49244.51,NULL,'2023-04-13 12:38:05','2023-04-13 12:38:05',NULL),(154,7941,34,40735,24239,16,156,1,102153.89,NULL,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(155,7941,34,40735,24239,16,302,1,33429.69,NULL,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(156,7941,34,40735,24239,16,315,1,4377.85,NULL,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(157,7941,34,40735,24239,16,252,2,71.13,NULL,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(158,7941,34,40735,24239,16,251,2,41146.36,NULL,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(159,7941,34,40735,24239,16,302,2,33358.56,NULL,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(160,7941,34,40735,24239,16,315,2,4377.85,NULL,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(161,7941,34,40735,24239,16,326,2,61007.53,NULL,'2023-04-13 12:45:14','2023-04-13 12:45:14',NULL),(162,7941,35,40735,24240,16,156,1,95766.95,NULL,'2023-04-13 13:32:28','2023-04-13 13:32:28',NULL),(163,7941,35,40735,24240,16,302,1,36669.06,NULL,'2023-04-13 13:32:28','2023-04-13 13:32:28',NULL),(164,7941,35,40735,24240,16,251,2,4727.57,NULL,'2023-04-13 13:32:28','2023-04-13 13:32:28',NULL),(165,7941,35,40735,24240,16,252,2,3239.37,NULL,'2023-04-13 13:32:28','2023-04-13 13:32:28',NULL),(166,7941,35,40735,24240,16,251,2,21078.00,NULL,'2023-04-13 13:32:28','2023-04-13 13:32:28',NULL);
INSERT INTO `balance_libro_details` VALUES (167,7941,35,40735,24240,16,302,2,33429.69,NULL,'2023-04-13 13:32:28','2023-04-13 13:32:28',NULL),(168,7941,35,40735,24240,16,326,2,69961.38,NULL,'2023-04-13 13:32:28','2023-04-13 13:32:28',NULL),(169,7941,36,40735,24241,16,156,1,139608.13,NULL,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(170,7941,36,40735,24241,16,302,1,104633.59,NULL,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(171,7941,36,40735,24241,16,251,2,43391.92,NULL,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(172,7941,36,40735,24241,16,251,2,622.96,NULL,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(173,7941,36,40735,24241,16,252,2,67964.53,NULL,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(174,7941,36,40735,24241,16,251,2,77939.80,NULL,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(175,7941,36,40735,24241,16,302,2,36669.06,NULL,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(176,7941,36,40735,24241,16,326,2,17653.45,NULL,'2023-04-13 13:37:21','2023-04-13 13:37:21',NULL),(177,7941,37,40735,24242,16,156,1,34370.55,NULL,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(178,7941,37,40735,24242,16,302,1,104806.36,NULL,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(179,7941,37,40735,24242,16,251,2,17592.43,NULL,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(180,7941,37,40735,24242,16,251,2,703.31,NULL,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(181,7941,37,40735,24242,16,251,2,3892.68,NULL,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(182,7941,37,40735,24242,16,252,2,172.77,NULL,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(183,7941,37,40735,24242,16,302,2,104633.59,NULL,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(184,7941,37,40735,24242,16,326,2,12182.13,NULL,'2023-04-13 13:51:55','2023-04-13 13:51:55',NULL),(185,7941,38,40735,24243,16,156,1,107058.27,NULL,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(186,7941,38,40735,24243,16,302,1,109735.05,NULL,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(187,7941,38,40735,24243,16,251,2,5728.48,NULL,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(188,7941,38,40735,24243,16,251,2,4505.28,NULL,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(189,7941,38,40735,24243,16,251,2,10034.77,NULL,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(190,7941,38,40735,24243,16,252,2,4928.69,NULL,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(191,7941,38,40735,24243,16,302,2,104806.36,NULL,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(192,7941,38,40735,24243,16,326,2,86789.74,NULL,'2023-04-13 13:56:18','2023-04-13 13:56:18',NULL),(193,7941,39,40735,24244,16,156,1,29876.08,NULL,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(194,7941,39,40735,24244,16,302,1,109844.80,NULL,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(195,7941,39,40735,24244,16,251,2,11804.85,NULL,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(196,7941,39,40735,24244,16,251,2,1764.85,NULL,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(197,7941,39,40735,24244,16,251,2,5575.34,NULL,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(198,7941,39,40735,24244,16,252,2,109.75,NULL,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(199,7941,39,40735,24244,16,302,2,109735.05,NULL,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(200,7941,39,40735,24244,16,326,2,10731.04,NULL,'2023-04-13 14:01:21','2023-04-13 14:01:21',NULL),(201,7941,40,40735,24245,16,156,1,174875.18,NULL,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL),(202,7941,40,40735,24245,16,302,1,82227.58,NULL,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL),(203,7941,40,40735,24245,16,251,2,1926.60,NULL,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL),(204,7941,40,40735,24245,16,251,2,1819.94,NULL,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL),(205,7941,40,40735,24245,16,251,2,15136.32,NULL,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL),(206,7941,40,40735,24245,16,252,2,1579.27,NULL,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL);
INSERT INTO `balance_libro_details` VALUES (207,7941,40,40735,24245,16,302,2,109844.80,NULL,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL),(208,7941,40,40735,24245,16,326,2,126795.83,NULL,'2023-04-13 14:04:03','2023-04-13 14:04:03',NULL),(209,7941,41,40735,24246,16,156,1,26649.27,NULL,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL),(210,7941,41,40735,24246,16,302,1,86413.58,NULL,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL),(211,7941,41,40735,24246,16,301,1,95401.77,NULL,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL),(212,7941,41,40735,24246,16,252,2,4186.00,NULL,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL),(213,7941,41,40735,24246,16,251,2,35374.66,NULL,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL),(214,7941,41,40735,24246,16,251,2,6913.36,NULL,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL),(215,7941,41,40735,24246,16,251,2,79763.02,NULL,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL),(216,7941,41,40735,24246,16,302,2,82227.58,NULL,'2023-04-13 14:06:28','2023-04-13 14:06:28',NULL),(217,7941,42,40735,24247,16,156,1,126864.73,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(218,7941,42,40735,24247,16,302,1,86421.96,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(219,7941,42,40735,24247,16,301,1,40370.88,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(220,7941,42,40735,24247,16,251,2,45484.33,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(221,7941,42,40735,24247,16,251,2,5122.56,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(222,7941,42,40735,24247,16,251,2,21226.95,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(223,7941,42,40735,24247,16,252,2,8.38,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(224,7941,42,40735,24247,16,302,2,86413.58,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(225,7941,42,40735,24247,16,301,2,95401.77,NULL,'2023-04-13 14:08:45','2023-04-13 14:08:45',NULL),(226,7941,43,40735,24248,16,156,1,40993.32,NULL,'2023-04-13 14:11:24','2023-04-13 14:11:24',NULL),(227,7941,43,40735,24248,16,302,1,86432.74,NULL,'2023-04-13 14:11:24','2023-04-13 14:11:24',NULL),(228,7941,43,40735,24248,16,301,1,11187.82,NULL,'2023-04-13 14:11:24','2023-04-13 14:11:24',NULL),(229,7941,43,40735,24248,16,252,2,10.78,NULL,'2023-04-13 14:11:24','2023-04-13 14:11:24',NULL),(230,7941,43,40735,24248,16,251,2,11810.26,NULL,'2023-04-13 14:11:24','2023-04-13 14:11:24',NULL),(231,7941,43,40735,24248,16,302,2,86421.96,NULL,'2023-04-13 14:11:24','2023-04-13 14:11:24',NULL),(232,7941,43,40735,24248,16,301,2,40370.88,NULL,'2023-04-13 14:11:24','2023-04-13 14:11:24',NULL),(233,7941,44,40735,24237,3,392,1,439019.28,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(234,7941,44,40735,24237,3,192,1,102450.00,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(235,7941,44,40735,24237,3,126,1,171254.83,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(236,7941,44,40735,24237,3,128,1,91248.61,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(237,7941,44,40735,24237,3,396,1,18115.88,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(238,7941,44,40735,24237,3,68,1,202383.20,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(239,7941,44,40735,24237,3,126,1,5000.00,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(240,7941,44,40735,24237,3,221,1,1614.26,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(241,7941,44,40735,24237,3,192,1,233760.74,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(242,7941,44,40735,24237,3,57,2,1267610.38,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(243,7941,44,40735,24237,3,75,1,2763.58,NULL,'2023-04-13 14:32:12','2023-04-13 18:17:52','2023-04-13 18:17:52'),(244,7941,45,40735,24238,3,392,1,75120.31,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26');
INSERT INTO `balance_libro_details` VALUES (245,7941,45,40735,24238,3,192,1,618505.37,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(246,7941,45,40735,24238,3,363,1,60506.37,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(247,7941,45,40735,24238,3,128,1,59090.86,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(248,7941,45,40735,24238,3,192,1,7438.02,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(249,7941,45,40735,24238,3,396,1,17118.52,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(250,7941,45,40735,24238,3,361,1,588000.00,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(251,7941,45,40735,24238,3,68,1,297948.14,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(252,7941,45,40735,24238,3,75,1,71050.00,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(253,7941,45,40735,24238,3,221,1,35296.21,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(254,7941,45,40735,24238,3,57,2,1830073.80,NULL,'2023-04-13 15:39:59','2023-04-13 18:17:26','2023-04-13 18:17:26'),(255,7941,46,40735,24238,3,392,1,75120.31,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(256,7941,46,40735,24238,3,192,1,618505.37,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(257,7941,46,40735,24238,3,363,1,60506.37,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(258,7941,46,40735,24238,3,128,1,59090.86,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(259,7941,46,40735,24238,3,192,1,7438.02,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(260,7941,46,40735,24238,3,396,1,17118.52,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(261,7941,46,40735,24238,3,361,1,588000.00,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(262,7941,46,40735,24238,3,68,1,297948.14,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(263,7941,46,40735,24238,3,221,1,35296.21,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(264,7941,46,40735,24238,3,57,2,1830073.80,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(265,7941,46,40735,24238,3,251,1,71050.00,NULL,'2023-04-13 18:17:26','2023-04-13 18:17:26',NULL),(266,7941,47,40735,24237,3,392,1,439019.28,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(267,7941,47,40735,24237,3,192,1,102450.00,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(268,7941,47,40735,24237,3,126,1,171254.83,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(269,7941,47,40735,24237,3,128,1,91248.61,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(270,7941,47,40735,24237,3,396,1,18115.88,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(271,7941,47,40735,24237,3,68,1,202383.20,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(272,7941,47,40735,24237,3,126,1,5000.00,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(273,7941,47,40735,24237,3,221,1,1614.26,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(274,7941,47,40735,24237,3,192,1,233760.74,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(275,7941,47,40735,24237,3,57,2,1267610.38,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(276,7941,47,40735,24237,3,251,1,2763.58,NULL,'2023-04-13 18:17:52','2023-04-13 18:17:52',NULL),(277,7941,48,40735,24239,3,392,1,2708356.79,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(278,7941,48,40735,24239,3,135,1,1785.12,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(279,7941,48,40735,24239,3,192,1,301074.17,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(280,7941,48,40735,24239,3,363,1,2054.93,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(281,7941,48,40735,24239,3,128,1,388513.85,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(282,7941,48,40735,24239,3,192,1,93678.02,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01');
INSERT INTO `balance_libro_details` VALUES (283,7941,48,40735,24239,3,396,1,78473.50,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(284,7941,48,40735,24239,3,68,1,704986.54,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(285,7941,48,40735,24239,3,251,1,1809.21,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(286,7941,48,40735,24239,3,69,1,41440.14,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(287,7941,48,40735,24239,3,57,2,4322172.27,NULL,'2023-04-14 09:45:36','2023-04-14 11:57:01','2023-04-14 11:57:01'),(288,7941,49,40735,24240,3,392,1,807687.93,NULL,'2023-04-14 10:07:05','2023-04-14 10:07:05',NULL),(289,7941,49,40735,24240,3,135,1,35702.47,NULL,'2023-04-14 10:07:05','2023-04-14 10:07:05',NULL),(290,7941,49,40735,24240,3,363,1,44619.86,NULL,'2023-04-14 10:07:05','2023-04-14 10:07:05',NULL),(291,7941,49,40735,24240,3,128,1,63087.30,NULL,'2023-04-14 10:07:06','2023-04-14 10:07:06',NULL),(292,7941,49,40735,24240,3,192,1,346144.48,NULL,'2023-04-14 10:07:06','2023-04-14 10:07:06',NULL),(293,7941,49,40735,24240,3,396,1,16936.76,NULL,'2023-04-14 10:07:06','2023-04-14 10:07:06',NULL),(294,7941,49,40735,24240,3,361,1,75046.87,NULL,'2023-04-14 10:07:06','2023-04-14 10:07:06',NULL),(295,7941,49,40735,24240,3,68,1,262253.58,NULL,'2023-04-14 10:07:06','2023-04-14 10:07:06',NULL),(296,7941,49,40735,24240,3,251,1,2506.98,NULL,'2023-04-14 10:07:06','2023-04-14 10:07:06',NULL),(297,7941,49,40735,24240,3,221,1,27527.68,NULL,'2023-04-14 10:07:06','2023-04-14 10:07:06',NULL),(298,7941,49,40735,24240,3,57,2,1681513.91,NULL,'2023-04-14 10:07:06','2023-04-14 10:07:06',NULL),(299,7941,50,40735,24241,3,392,1,3359268.75,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(300,7941,50,40735,24241,3,135,1,1950.41,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(301,7941,50,40735,24241,3,192,1,179945.34,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(302,7941,50,40735,24241,3,363,1,35589.27,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(303,7941,50,40735,24241,3,128,1,58061.44,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(304,7941,50,40735,24241,3,396,1,7274.26,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(305,7941,50,40735,24241,3,68,1,737912.92,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(306,7941,50,40735,24241,3,251,1,1470.95,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(307,7941,50,40735,24241,3,221,1,148389.81,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(308,7941,50,40735,24241,3,57,2,4529863.15,NULL,'2023-04-14 10:20:38','2023-04-14 10:20:38',NULL),(309,7941,51,40735,24242,3,392,1,121552.21,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(310,7941,51,40735,24242,3,135,1,19809.91,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(311,7941,51,40735,24242,3,192,1,260000.00,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(312,7941,51,40735,24242,3,380,1,97728.51,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(313,7941,51,40735,24242,3,419,1,6967481.32,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(314,7941,51,40735,24242,3,128,1,71341.55,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(315,7941,51,40735,24242,3,68,1,832905.42,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(316,7941,51,40735,24242,3,251,1,382.99,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(317,7941,51,40735,24242,3,221,1,9644.60,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(318,7941,51,40735,24242,3,57,2,8380846.51,NULL,'2023-04-14 10:39:25','2023-04-14 10:39:25',NULL),(319,7941,52,40735,24243,3,392,1,63680.29,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(320,7941,52,40735,24243,3,135,1,2247.93,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(321,7941,52,40735,24243,3,192,1,372820.63,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(322,7941,52,40735,24243,3,419,1,136041.31,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL);
INSERT INTO `balance_libro_details` VALUES (323,7941,52,40735,24243,3,128,1,128662.80,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(324,7941,52,40735,24243,3,396,1,5282.50,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(325,7941,52,40735,24243,3,361,1,2247.94,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(326,7941,52,40735,24243,3,68,1,139248.49,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(327,7941,52,40735,24243,3,251,1,1160.92,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(328,7941,52,40735,24243,3,221,1,27291.35,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(329,7941,52,40735,24243,3,57,2,878684.16,NULL,'2023-04-14 10:52:49','2023-04-14 10:52:49',NULL),(330,7941,53,40735,24244,3,392,1,73539.84,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(331,7941,53,40735,24244,3,135,1,2314.05,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(332,7941,53,40735,24244,3,192,1,350586.36,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(333,7941,53,40735,24244,3,128,1,238152.45,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(334,7941,53,40735,24244,3,396,1,15414.14,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(335,7941,53,40735,24244,3,68,1,95848.88,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(336,7941,53,40735,24244,3,251,1,1224.93,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(337,7941,53,40735,24244,3,221,1,6267.11,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(338,7941,53,40735,24244,3,57,2,783347.76,NULL,'2023-04-14 11:28:19','2023-04-14 11:28:19',NULL),(339,7941,54,40735,24245,3,392,1,956585.26,NULL,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(340,7941,54,40735,24245,3,135,1,3471.07,NULL,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(341,7941,54,40735,24245,3,192,1,232509.76,NULL,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(342,7941,54,40735,24245,3,128,1,69873.69,NULL,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(343,7941,54,40735,24245,3,396,1,31729.00,NULL,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(344,7941,54,40735,24245,3,68,1,253465.83,NULL,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(345,7941,54,40735,24245,3,221,1,20280.69,NULL,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(346,7941,54,40735,24245,3,57,2,1567915.30,NULL,'2023-04-14 11:30:02','2023-04-14 11:30:02',NULL),(347,7941,55,40735,24246,3,392,1,2989143.40,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(348,7941,55,40735,24246,3,192,1,256319.64,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(349,7941,55,40735,24246,3,363,1,6561.98,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(350,7941,55,40735,24246,3,128,1,113195.09,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(351,7941,55,40735,24246,3,396,1,6420.00,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(352,7941,55,40735,24246,3,68,1,695460.94,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(353,7941,55,40735,24246,3,251,1,47960.22,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(354,7941,55,40735,24246,3,221,1,19369.89,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(355,7941,55,40735,24246,3,141,2,4134431.16,NULL,'2023-04-14 11:49:33','2023-04-14 11:55:22','2023-04-14 11:55:22'),(356,7941,56,40735,24247,3,392,1,950703.18,NULL,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL),(357,7941,56,40735,24247,3,135,1,60900.18,NULL,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL),(358,7941,56,40735,24247,3,192,1,263275.00,NULL,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL),(359,7941,56,40735,24247,3,128,1,165575.28,NULL,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL),(360,7941,56,40735,24247,3,68,1,287962.47,NULL,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL),(361,7941,56,40735,24247,3,75,1,4259.31,NULL,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL);
INSERT INTO `balance_libro_details` VALUES (362,7941,56,40735,24247,3,221,1,21174.79,NULL,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL),(363,7941,56,40735,24247,3,57,2,1753850.21,NULL,'2023-04-14 11:54:53','2023-04-14 11:54:53',NULL),(364,7941,57,40735,24246,3,392,1,2989143.40,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(365,7941,57,40735,24246,3,192,1,256319.64,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(366,7941,57,40735,24246,3,363,1,6561.98,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(367,7941,57,40735,24246,3,128,1,113195.09,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(368,7941,57,40735,24246,3,396,1,6420.00,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(369,7941,57,40735,24246,3,68,1,695460.94,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(370,7941,57,40735,24246,3,251,1,47960.22,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(371,7941,57,40735,24246,3,221,1,19369.89,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(372,7941,57,40735,24246,3,57,2,4134431.16,NULL,'2023-04-14 11:55:22','2023-04-14 11:55:22',NULL),(373,7941,58,40735,24239,3,392,1,2708356.79,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(374,7941,58,40735,24239,3,135,1,1785.12,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(375,7941,58,40735,24239,3,192,1,301074.17,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(376,7941,58,40735,24239,3,363,1,2054.93,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(377,7941,58,40735,24239,3,128,1,388513.85,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(378,7941,58,40735,24239,3,192,1,93678.02,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(379,7941,58,40735,24239,3,396,1,78473.50,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(380,7941,58,40735,24239,3,68,1,704986.54,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(381,7941,58,40735,24239,3,251,1,1809.21,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(382,7941,58,40735,24239,3,57,2,4322172.27,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(383,7941,58,40735,24239,3,221,1,41440.14,NULL,'2023-04-14 11:57:01','2023-04-14 11:57:01',NULL),(384,7941,59,40735,24248,3,392,1,368609.71,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(385,7941,59,40735,24248,3,135,1,8677.69,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(386,7941,59,40735,24248,3,192,1,335220.79,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(387,7941,59,40735,24248,3,363,1,6252.48,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(388,7941,59,40735,24248,3,128,1,224959.68,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(389,7941,59,40735,24248,3,396,1,45610.43,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(390,7941,59,40735,24248,3,68,1,175500.74,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(391,7941,59,40735,24248,3,221,1,11075.75,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(392,7941,59,40735,24248,3,57,2,1175907.27,NULL,'2023-04-14 12:11:35','2023-04-14 12:11:35',NULL),(393,7941,60,40735,24238,1,110,1,591701.57,NULL,'2023-04-23 10:36:25','2023-04-23 10:36:25',NULL),(394,7941,60,40735,24238,1,112,1,9804.77,NULL,'2023-04-23 10:36:25','2023-04-23 10:36:25',NULL),(395,7941,60,40735,24238,1,191,1,147391.36,NULL,'2023-04-23 10:36:25','2023-04-23 10:36:25',NULL),(396,7941,60,40735,24238,1,62,2,502302.00,NULL,'2023-04-23 10:36:25','2023-04-23 10:36:25',NULL),(397,7941,60,40735,24238,1,63,2,195421.63,NULL,'2023-04-23 10:36:25','2023-04-23 10:36:25',NULL),(398,7941,60,40735,24238,1,162,2,41369.30,NULL,'2023-04-23 10:36:25','2023-04-23 10:36:25',NULL),(399,7941,60,40735,24238,1,64,2,9804.77,NULL,'2023-04-23 10:36:25','2023-04-23 10:36:25',NULL),(400,7941,61,40735,24237,12,359,1,1372245.63,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(401,7941,61,40735,24237,12,482,1,328590.35,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14');
INSERT INTO `balance_libro_details` VALUES (402,7941,61,40735,24237,12,483,1,2960216.10,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(403,7941,61,40735,24237,12,301,2,35710.67,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(404,7941,61,40735,24237,12,392,1,1433800.00,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(405,7941,61,40735,24237,12,74,1,660837.61,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(406,7941,61,40735,24237,12,57,2,2351644.75,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(407,7941,61,40735,24237,12,326,1,30679.81,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(408,7941,61,40735,24237,12,473,1,52322.54,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(409,7941,61,40735,24237,12,79,1,140256.32,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(410,7941,61,40735,24237,12,62,2,447324.14,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(411,7941,61,40735,24237,12,63,2,221485.10,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(412,7941,61,40735,24237,12,64,2,7651.68,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(413,7941,61,40735,24237,12,438,2,321533.04,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(414,7941,61,40735,24237,12,368,2,302818.56,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(415,7941,61,40735,24237,12,363,1,108062.06,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(416,7941,61,40735,24237,12,48,2,70116.67,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(417,7941,61,40735,24237,12,391,1,753937.51,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(418,7941,61,40735,24237,12,391,1,4029030.70,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(419,7941,61,40735,24237,12,361,1,152476.41,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(420,7941,61,40735,24237,12,419,1,4285015.89,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(421,7941,61,40735,24237,12,415,2,322432.08,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(422,7941,61,40735,24237,12,415,2,1878988.05,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(423,7941,61,40735,24237,12,414,2,68617.75,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(424,7941,61,40735,24237,12,420,2,4103174.01,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(425,7941,61,40735,24237,12,369,2,347697.12,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(426,7941,61,40735,24237,12,381,2,69539.43,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(427,7941,61,40735,24237,12,465,2,1846565.18,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(428,7941,61,40735,24237,12,383,2,3912172.70,NULL,'2023-04-23 11:33:09','2023-04-25 15:17:14','2023-04-25 15:17:14'),(429,7941,62,40735,24237,12,359,1,1372245.63,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(430,7941,62,40735,24237,12,482,1,328590.35,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(431,7941,62,40735,24237,12,483,1,2960216.10,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(432,7941,62,40735,24237,12,301,2,35710.67,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(433,7941,62,40735,24237,12,392,1,1433800.00,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(434,7941,62,40735,24237,12,74,1,660837.61,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(435,7941,62,40735,24237,12,57,2,2351644.75,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52');
INSERT INTO `balance_libro_details` VALUES (436,7941,62,40735,24237,12,326,1,30679.81,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(437,7941,62,40735,24237,12,473,1,52322.54,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(438,7941,62,40735,24237,12,79,1,140256.32,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(439,7941,62,40735,24237,12,62,2,447324.14,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(440,7941,62,40735,24237,12,63,2,221485.10,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(441,7941,62,40735,24237,12,64,2,7651.68,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(442,7941,62,40735,24237,12,438,2,321533.04,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(443,7941,62,40735,24237,12,368,2,302818.56,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(444,7941,62,40735,24237,12,363,1,108062.06,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(445,7941,62,40735,24237,12,48,2,70116.67,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(446,7941,62,40735,24237,12,391,1,753937.51,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(447,7941,62,40735,24237,12,361,1,152476.41,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(448,7941,62,40735,24237,12,419,1,4285015.89,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(449,7941,62,40735,24237,12,415,2,322432.08,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(450,7941,62,40735,24237,12,414,2,68617.75,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(451,7941,62,40735,24237,12,420,2,4103174.01,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(452,7941,62,40735,24237,12,369,2,347697.12,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(453,7941,62,40735,24237,12,381,2,69539.43,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(454,7941,62,40735,24237,12,465,2,1846565.18,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(455,7941,62,40735,24237,12,383,2,3912172.72,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(456,7941,62,40735,24237,12,484,1,4029030.70,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(457,7941,62,40735,24237,12,485,2,1878988.03,NULL,'2023-04-25 15:17:14','2023-05-06 19:23:52','2023-05-06 19:23:52'),(458,7941,63,40735,24239,1,110,1,508630.41,NULL,'2023-04-25 15:32:13','2023-04-25 15:32:13',NULL),(459,7941,63,40735,24239,1,112,1,10961.47,NULL,'2023-04-25 15:32:13','2023-04-25 15:32:13',NULL),(460,7941,63,40735,24239,1,191,1,117313.81,NULL,'2023-04-25 15:32:13','2023-04-25 15:32:13',NULL),(461,7941,63,40735,24239,1,63,2,192658.23,NULL,'2023-04-25 15:32:13','2023-04-25 15:32:13',NULL),(462,7941,63,40735,24239,1,62,2,433285.99,NULL,'2023-04-25 15:32:13','2023-04-25 15:32:13',NULL),(463,7941,63,40735,24239,1,64,2,10961.47,NULL,'2023-04-25 15:32:13','2023-04-25 15:32:13',NULL),(464,7941,64,40735,24240,1,110,1,673431.00,NULL,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(465,7941,64,40735,24240,1,112,1,16262.01,NULL,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(466,7941,64,40735,24240,1,191,1,157620.67,NULL,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(467,7941,64,40735,24240,1,486,2,13750.00,NULL,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(468,7941,64,40735,24240,1,63,2,239648.74,NULL,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(469,7941,64,40735,24240,1,162,2,22685.93,NULL,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(470,7941,64,40735,24240,1,62,2,554967.00,NULL,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(471,7941,64,40735,24240,1,64,2,16262.01,NULL,'2023-04-30 10:57:07','2023-04-30 10:57:07',NULL),(472,7941,65,40735,24241,1,110,1,656680.09,NULL,'2023-04-30 10:59:55','2023-04-30 10:59:55',NULL);
INSERT INTO `balance_libro_details` VALUES (473,7941,65,40735,24241,1,112,1,15797.53,NULL,'2023-04-30 10:59:55','2023-04-30 10:59:55',NULL),(474,7941,65,40735,24241,1,191,1,151091.60,NULL,'2023-04-30 10:59:55','2023-04-30 10:59:55',NULL),(475,7941,65,40735,24241,1,486,2,13750.00,NULL,'2023-04-30 10:59:55','2023-04-30 10:59:55',NULL),(476,7941,65,40735,24241,1,63,2,254410.69,NULL,'2023-04-30 10:59:55','2023-04-30 10:59:55',NULL),(477,7941,65,40735,24241,1,62,2,539611.00,NULL,'2023-04-30 10:59:55','2023-04-30 10:59:55',NULL),(478,7941,65,40735,24241,1,64,2,15797.53,NULL,'2023-04-30 10:59:55','2023-04-30 10:59:55',NULL),(479,7941,66,40735,24242,1,110,1,947744.95,NULL,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(480,7941,66,40735,24242,1,112,1,20815.95,NULL,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(481,7941,66,40735,24242,1,191,1,225297.09,NULL,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(482,7941,66,40735,24242,1,486,2,43750.00,NULL,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(483,7941,66,40735,24242,1,63,2,370746.06,NULL,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(484,7941,66,40735,24242,1,162,2,43788.29,NULL,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(485,7941,66,40735,24242,1,62,2,714757.69,NULL,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(486,7941,66,40735,24242,1,64,2,20815.95,NULL,'2023-04-30 11:06:09','2023-04-30 11:06:09',NULL),(487,7941,67,40735,24243,1,110,1,698239.58,NULL,'2023-04-30 11:07:42','2023-04-30 11:07:42',NULL),(488,7941,67,40735,24243,1,112,1,15428.95,NULL,'2023-04-30 11:07:42','2023-04-30 11:07:42',NULL),(489,7941,67,40735,24243,1,191,1,181134.35,NULL,'2023-04-30 11:07:42','2023-04-30 11:07:42',NULL),(490,7941,67,40735,24243,1,63,2,258151.63,NULL,'2023-04-30 11:07:42','2023-04-30 11:07:42',NULL),(491,7941,67,40735,24243,1,62,2,621222.30,NULL,'2023-04-30 11:07:42','2023-04-30 11:07:42',NULL),(492,7941,67,40735,24243,1,64,2,15428.95,NULL,'2023-04-30 11:07:42','2023-04-30 11:07:42',NULL),(493,7941,68,40735,24244,1,110,1,786246.65,NULL,'2023-04-30 11:09:21','2023-04-30 11:09:21',NULL),(494,7941,68,40735,24244,1,112,1,17257.18,NULL,'2023-04-30 11:09:21','2023-04-30 11:09:21',NULL),(495,7941,68,40735,24244,1,191,1,181878.14,NULL,'2023-04-30 11:09:21','2023-04-30 11:09:21',NULL),(496,7941,68,40735,24244,1,63,2,290615.28,NULL,'2023-04-30 11:09:21','2023-04-30 11:09:21',NULL),(497,7941,68,40735,24244,1,162,2,5323.50,NULL,'2023-04-30 11:09:21','2023-04-30 11:09:21',NULL),(498,7941,68,40735,24244,1,62,2,672186.01,NULL,'2023-04-30 11:09:21','2023-04-30 11:09:21',NULL),(499,7941,68,40735,24244,1,64,2,17257.18,NULL,'2023-04-30 11:09:21','2023-04-30 11:09:21',NULL),(500,7941,69,40735,24245,1,110,1,864312.23,NULL,'2023-04-30 11:14:35','2023-04-30 11:14:35',NULL),(501,7941,69,40735,24245,1,112,1,19251.92,NULL,'2023-04-30 11:14:35','2023-04-30 11:14:35',NULL),(502,7941,69,40735,24245,1,191,1,199813.51,NULL,'2023-04-30 11:14:35','2023-04-30 11:14:35',NULL),(503,7941,69,40735,24245,1,63,2,327883.74,NULL,'2023-04-30 11:14:35','2023-04-30 11:14:35',NULL),(504,7941,69,40735,24245,1,62,2,736242.00,NULL,'2023-04-30 11:14:35','2023-04-30 11:14:35',NULL),(505,7941,69,40735,24245,1,64,2,19251.92,NULL,'2023-04-30 11:14:35','2023-04-30 11:14:35',NULL),(506,7941,70,40735,24246,1,110,1,882428.01,NULL,'2023-04-30 11:18:08','2023-04-30 11:18:08',NULL),(507,7941,70,40735,24246,1,112,1,18507.72,NULL,'2023-04-30 11:18:08','2023-04-30 11:18:08',NULL),(508,7941,70,40735,24246,1,191,1,228367.24,NULL,'2023-04-30 11:18:08','2023-04-30 11:18:08',NULL),(509,7941,70,40735,24246,1,63,2,332169.37,NULL,'2023-04-30 11:18:08','2023-04-30 11:18:08',NULL),(510,7941,70,40735,24246,1,162,2,25536.88,NULL,'2023-04-30 11:18:08','2023-04-30 11:18:08',NULL),(511,7941,70,40735,24246,1,62,2,753089.00,NULL,'2023-04-30 11:18:08','2023-04-30 11:18:08',NULL),(512,7941,70,40735,24246,1,64,2,18507.72,NULL,'2023-04-30 11:18:08','2023-04-30 11:18:08',NULL),(513,7941,71,40735,24247,1,110,1,971861.07,NULL,'2023-04-30 11:19:50','2023-04-30 11:19:50',NULL);
INSERT INTO `balance_libro_details` VALUES (514,7941,71,40735,24247,1,112,1,21570.04,NULL,'2023-04-30 11:19:50','2023-04-30 11:19:50',NULL),(515,7941,71,40735,24247,1,191,1,223948.84,NULL,'2023-04-30 11:19:50','2023-04-30 11:19:50',NULL),(516,7941,71,40735,24247,1,63,2,368647.90,NULL,'2023-04-30 11:19:50','2023-04-30 11:19:50',NULL),(517,7941,71,40735,24247,1,62,2,827162.01,NULL,'2023-04-30 11:19:50','2023-04-30 11:19:50',NULL),(518,7941,71,40735,24247,1,64,2,21570.04,NULL,'2023-04-30 11:19:50','2023-04-30 11:19:50',NULL),(519,7941,72,40735,24248,1,110,1,1519528.69,NULL,'2023-04-30 11:22:05','2023-04-30 11:22:05',NULL),(520,7941,72,40735,24248,1,112,1,31371.85,NULL,'2023-04-30 11:22:05','2023-04-30 11:22:05',NULL),(521,7941,72,40735,24248,1,191,1,454650.83,NULL,'2023-04-30 11:22:05','2023-04-30 11:22:05',NULL),(522,7941,72,40735,24248,1,486,2,20730.00,NULL,'2023-04-30 11:22:05','2023-04-30 11:22:05',NULL),(523,7941,72,40735,24248,1,63,2,592834.75,NULL,'2023-04-30 11:22:05','2023-04-30 11:22:05',NULL),(524,7941,72,40735,24248,1,62,2,1360614.77,NULL,'2023-04-30 11:22:05','2023-04-30 11:22:05',NULL),(525,7941,72,40735,24248,1,64,2,31371.85,NULL,'2023-04-30 11:22:05','2023-04-30 11:22:05',NULL),(526,7941,73,40735,24237,1,110,1,424483.70,NULL,'2023-04-30 11:23:17','2023-04-30 11:23:17',NULL),(527,7941,73,40735,24237,1,191,1,118588.82,NULL,'2023-04-30 11:23:17','2023-04-30 11:23:17',NULL),(528,7941,73,40735,24237,1,63,2,221337.46,NULL,'2023-04-30 11:23:17','2023-04-30 11:23:17',NULL),(529,7941,73,40735,24237,1,62,2,321735.06,NULL,'2023-04-30 11:23:17','2023-04-30 11:23:17',NULL),(530,7941,74,40735,24237,7,57,1,1094.45,NULL,'2023-04-30 11:26:29','2023-04-30 11:26:29',NULL),(531,7941,74,40735,24237,7,473,2,1094.45,NULL,'2023-04-30 11:26:29','2023-04-30 11:26:29',NULL),(532,7941,75,40735,24239,7,57,1,50375.02,NULL,'2023-04-30 11:28:38','2023-04-30 11:28:38',NULL),(533,7941,75,40735,24239,7,473,2,50375.02,NULL,'2023-04-30 11:28:38','2023-04-30 11:28:38',NULL),(534,7941,76,40735,24240,7,57,1,956.60,NULL,'2023-04-30 11:29:21','2023-04-30 11:29:21',NULL),(535,7941,76,40735,24240,7,473,2,956.60,NULL,'2023-04-30 11:29:21','2023-04-30 11:29:21',NULL),(536,7941,77,40735,24241,7,57,1,8087.24,NULL,'2023-04-30 11:30:01','2023-04-30 11:30:01',NULL),(537,7941,77,40735,24241,7,473,2,8087.24,NULL,'2023-04-30 11:30:01','2023-04-30 11:30:01',NULL),(538,7941,78,40735,24242,7,57,1,3056.60,NULL,'2023-04-30 11:30:31','2023-04-30 11:30:31',NULL),(539,7941,78,40735,24242,7,473,2,3056.60,NULL,'2023-04-30 11:30:31','2023-04-30 11:30:31',NULL),(540,7941,79,40735,24243,7,57,1,137159.93,NULL,'2023-04-30 11:31:04','2023-04-30 11:31:04',NULL),(541,7941,79,40735,24243,7,473,2,137159.93,NULL,'2023-04-30 11:31:04','2023-04-30 11:31:04',NULL),(542,7941,80,40735,24244,7,57,1,1356.60,NULL,'2023-04-30 11:31:31','2023-04-30 11:31:31',NULL),(543,7941,80,40735,24244,7,473,2,1356.60,NULL,'2023-04-30 11:31:31','2023-04-30 11:31:31',NULL),(544,7941,81,40735,24245,7,57,1,8355.64,NULL,'2023-04-30 11:32:03','2023-04-30 11:32:03',NULL),(545,7941,81,40735,24245,7,473,2,8355.64,NULL,'2023-04-30 11:32:03','2023-04-30 11:32:03',NULL),(546,7941,82,40735,24246,7,57,1,60317.22,NULL,'2023-04-30 11:33:10','2023-04-30 11:33:10',NULL),(547,7941,82,40735,24246,7,473,2,60317.22,NULL,'2023-04-30 11:33:10','2023-04-30 11:33:10',NULL),(548,7941,83,40735,24247,7,57,1,1632.60,NULL,'2023-04-30 11:33:55','2023-04-30 11:33:55',NULL),(549,7941,83,40735,24247,7,473,2,1632.60,NULL,'2023-04-30 11:33:55','2023-04-30 11:33:55',NULL),(550,7941,84,40735,24248,7,57,1,10439.47,NULL,'2023-04-30 11:34:27','2023-04-30 11:34:27',NULL),(551,7941,84,40735,24248,7,473,2,10439.47,NULL,'2023-04-30 11:34:27','2023-04-30 11:34:27',NULL),(552,7941,85,40735,24248,2,14,1,1984076.54,NULL,'2023-04-30 11:36:32','2023-04-30 11:36:48','2023-04-30 11:36:48'),(553,7941,85,40735,24248,2,67,2,344343.86,NULL,'2023-04-30 11:36:32','2023-04-30 11:36:48','2023-04-30 11:36:48');
INSERT INTO `balance_libro_details` VALUES (554,7941,85,40735,24248,2,96,2,1639732.68,NULL,'2023-04-30 11:36:32','2023-04-30 11:36:48','2023-04-30 11:36:48'),(555,7941,86,40735,24248,2,14,1,1984076.54,NULL,'2023-04-30 11:36:48','2023-04-30 11:36:48',NULL),(556,7941,86,40735,24248,2,67,2,344343.86,NULL,'2023-04-30 11:36:48','2023-04-30 11:36:48',NULL),(557,7941,86,40735,24248,2,96,2,1639732.68,NULL,'2023-04-30 11:36:48','2023-04-30 11:36:48',NULL),(558,7941,87,40735,24237,5,14,2,846447.76,NULL,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(559,7941,87,40735,24237,5,57,1,604913.04,NULL,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(560,7941,87,40735,24237,5,62,1,386163.00,NULL,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(561,7941,87,40735,24237,5,396,1,300.00,NULL,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(562,7941,87,40735,24237,5,68,1,63.00,NULL,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(563,7941,87,40735,24237,5,75,1,7.50,NULL,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(564,7941,87,40735,24237,5,157,1,10115.21,NULL,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(565,7941,87,40735,24237,5,482,2,155113.99,NULL,'2023-04-30 11:40:57','2023-04-30 12:51:28','2023-04-30 12:51:28'),(566,7941,88,40735,24238,5,14,2,2897510.01,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(567,7941,88,40735,24238,5,483,1,900000.00,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(568,7941,88,40735,24238,5,57,1,189912.36,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(569,7941,88,40735,24238,5,62,1,138523.00,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(570,7941,88,40735,24238,5,74,1,330824.98,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(571,7941,88,40735,24238,5,396,1,16.50,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(572,7941,88,40735,24238,5,68,1,3.46,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(573,7941,88,40735,24238,5,157,1,22210.81,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(574,7941,88,40735,24238,5,482,1,1316018.90,NULL,'2023-04-30 11:42:34','2023-04-30 11:42:34',NULL),(575,7941,89,40735,24239,5,14,2,2208162.44,NULL,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(576,7941,89,40735,24239,5,57,1,1501583.42,NULL,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(577,7941,89,40735,24239,5,62,1,505049.00,NULL,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(578,7941,89,40735,24239,5,396,1,670.00,NULL,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(579,7941,89,40735,24239,5,68,1,140.70,NULL,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(580,7941,89,40735,24239,5,75,1,16.75,NULL,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(581,7941,89,40735,24239,5,157,1,24315.67,NULL,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(582,7941,89,40735,24239,5,482,1,176386.90,NULL,'2023-04-30 11:44:06','2023-04-30 12:54:09','2023-04-30 12:54:09'),(583,7941,90,40735,24240,5,14,2,241012.94,NULL,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40'),(584,7941,90,40735,24240,5,57,1,1446151.27,NULL,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40'),(585,7941,90,40735,24240,5,62,1,276922.00,NULL,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40'),(586,7941,90,40735,24240,5,396,1,140.00,NULL,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40'),(587,7941,90,40735,24240,5,68,1,29.40,NULL,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40'),(588,7941,90,40735,24240,5,75,1,3.50,NULL,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40'),(589,7941,90,40735,24240,5,157,1,12085.49,NULL,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40'),(590,7941,90,40735,24240,5,482,2,1494318.72,NULL,'2023-04-30 11:46:43','2023-04-30 12:53:40','2023-04-30 12:53:40');
INSERT INTO `balance_libro_details` VALUES (591,7941,91,40735,24241,5,14,2,3780192.90,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(592,7941,91,40735,24241,5,57,2,74610.33,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(593,7941,91,40735,24241,5,483,1,1000000.00,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(594,7941,91,40735,24241,5,57,1,999155.97,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(595,7941,91,40735,24241,5,62,1,206745.00,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(596,7941,91,40735,24241,5,326,1,69961.38,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(597,7941,91,40735,24241,5,396,1,2142.21,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(598,7941,91,40735,24241,5,68,1,136.50,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(599,7941,91,40735,24241,5,209,1,289.52,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(600,7941,91,40735,24241,5,75,1,16.25,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(601,7941,91,40735,24241,5,157,1,25316.33,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(602,7941,91,40735,24241,5,482,1,1551040.07,NULL,'2023-04-30 11:52:30','2023-04-30 12:00:59','2023-04-30 12:00:59'),(603,7941,92,40735,24242,5,14,2,1369769.78,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(604,7941,92,40735,24242,5,57,1,116814.00,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(605,7941,92,40735,24242,5,62,1,606330.00,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(606,7941,92,40735,24242,5,396,1,630.00,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(607,7941,92,40735,24242,5,68,1,132.30,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(608,7941,92,40735,24242,5,209,1,225.57,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(609,7941,92,40735,24242,5,75,1,15.75,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(610,7941,92,40735,24242,5,157,1,16980.03,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(611,7941,92,40735,24242,5,482,1,628642.13,NULL,'2023-04-30 11:57:49','2023-04-30 12:01:17','2023-04-30 12:01:17'),(612,7941,93,40735,24241,5,14,2,3780192.90,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(613,7941,93,40735,24241,5,57,2,74610.33,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(614,7941,93,40735,24241,5,483,1,1000000.00,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(615,7941,93,40735,24241,5,57,1,999155.97,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(616,7941,93,40735,24241,5,62,1,206745.00,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(617,7941,93,40735,24241,5,326,1,69961.38,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(618,7941,93,40735,24241,5,396,1,2142.21,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(619,7941,93,40735,24241,5,68,1,136.50,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(620,7941,93,40735,24241,5,75,1,16.25,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(621,7941,93,40735,24241,5,157,1,25316.33,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(622,7941,93,40735,24241,5,482,1,1551040.07,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(623,7941,93,40735,24241,5,487,1,289.52,NULL,'2023-04-30 12:00:59','2023-04-30 12:53:22','2023-04-30 12:53:22'),(624,7941,94,40735,24242,5,14,2,1369769.78,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(625,7941,94,40735,24242,5,57,1,116814.00,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56');
INSERT INTO `balance_libro_details` VALUES (626,7941,94,40735,24242,5,62,1,606330.00,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(627,7941,94,40735,24242,5,396,1,630.00,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(628,7941,94,40735,24242,5,68,1,132.30,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(629,7941,94,40735,24242,5,75,1,15.75,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(630,7941,94,40735,24242,5,157,1,16980.03,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(631,7941,94,40735,24242,5,482,1,628642.13,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(632,7941,94,40735,24242,5,487,1,225.57,NULL,'2023-04-30 12:01:17','2023-04-30 12:52:56','2023-04-30 12:52:56'),(633,7941,95,40735,24242,5,14,2,1369769.78,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(634,7941,95,40735,24242,5,57,1,116814.00,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(635,7941,95,40735,24242,5,62,1,606330.00,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(636,7941,95,40735,24242,5,396,1,630.00,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(637,7941,95,40735,24242,5,68,1,132.30,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(638,7941,95,40735,24242,5,487,1,225.57,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(639,7941,95,40735,24242,5,75,1,15.75,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(640,7941,95,40735,24242,5,157,1,16980.03,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(641,7941,95,40735,24242,5,482,1,628642.13,NULL,'2023-04-30 12:04:58','2023-04-30 12:05:25','2023-04-30 12:05:25'),(642,7941,96,40735,24243,5,483,1,200000.00,NULL,'2023-04-30 12:07:02','2023-04-30 12:07:02',NULL),(643,7941,96,40735,24243,5,57,1,188734.86,NULL,'2023-04-30 12:07:02','2023-04-30 12:07:02',NULL),(644,7941,96,40735,24243,5,62,1,161962.00,NULL,'2023-04-30 12:07:02','2023-04-30 12:07:02',NULL),(645,7941,96,40735,24243,5,157,1,3004.15,NULL,'2023-04-30 12:07:02','2023-04-30 12:07:02',NULL),(646,7941,96,40735,24243,5,482,2,553701.01,NULL,'2023-04-30 12:07:02','2023-04-30 12:07:02',NULL),(647,7941,97,40735,24244,5,14,2,979857.60,NULL,'2023-04-30 12:09:13','2023-04-30 12:09:13',NULL),(648,7941,97,40735,24244,5,57,1,161159.60,NULL,'2023-04-30 12:09:13','2023-04-30 12:09:13',NULL),(649,7941,97,40735,24244,5,62,1,327393.00,NULL,'2023-04-30 12:09:13','2023-04-30 12:09:13',NULL),(650,7941,97,40735,24244,5,63,1,258151.63,NULL,'2023-04-30 12:09:13','2023-04-30 12:09:13',NULL),(651,7941,97,40735,24244,5,487,1,979.85,NULL,'2023-04-30 12:09:13','2023-04-30 12:09:13',NULL),(652,7941,97,40735,24244,5,157,1,10365.19,NULL,'2023-04-30 12:09:13','2023-04-30 12:09:13',NULL),(653,7941,97,40735,24244,5,482,1,221808.33,NULL,'2023-04-30 12:09:13','2023-04-30 12:09:13',NULL),(654,7941,98,40735,24245,5,14,2,177395.40,NULL,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL),(655,7941,98,40735,24245,5,57,1,472152.99,NULL,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL),(656,7941,98,40735,24245,5,62,1,469989.00,NULL,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL),(657,7941,98,40735,24245,5,20,1,4207.92,NULL,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL),(658,7941,98,40735,24245,5,74,1,376638.47,NULL,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL),(659,7941,98,40735,24245,5,487,1,177.39,NULL,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL),(660,7941,98,40735,24245,5,157,1,9003.30,NULL,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL),(661,7941,98,40735,24245,5,482,2,1154773.67,NULL,'2023-04-30 12:14:06','2023-04-30 12:14:06',NULL),(662,7941,99,40735,24246,5,14,2,3319138.47,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(663,7941,99,40735,24246,5,57,1,541082.59,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58');
INSERT INTO `balance_libro_details` VALUES (664,7941,99,40735,24246,5,62,1,511827.00,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(665,7941,99,40735,24246,5,63,1,327883.74,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(666,7941,99,40735,24246,5,326,1,126795.83,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(667,7941,99,40735,24246,5,396,1,610.00,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(668,7941,99,40735,24246,5,68,1,128.10,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(669,7941,99,40735,24246,5,75,1,3319.13,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(670,7941,99,40735,24246,5,25,1,15.25,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(671,7941,99,40735,24246,5,157,1,28984.70,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(672,7941,99,40735,24246,5,482,1,1778492.13,NULL,'2023-04-30 12:46:56','2023-04-30 12:51:58','2023-04-30 12:51:58'),(673,7941,100,40735,24247,5,57,1,372244.12,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(674,7941,100,40735,24247,5,62,1,560822.00,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(675,7941,100,40735,24247,5,63,1,306632.49,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(676,7941,100,40735,24247,5,396,1,4960.00,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(677,7941,100,40735,24247,5,68,1,1041.60,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(678,7941,100,40735,24247,5,25,1,135.00,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(679,7941,100,40735,24247,5,157,1,7475.69,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(680,7941,100,40735,24247,5,482,2,1253434.90,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(681,7941,100,40735,24247,5,251,1,124.00,NULL,'2023-04-30 12:49:45','2023-04-30 12:49:45',NULL),(682,7941,101,40735,24237,5,14,2,846447.76,NULL,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(683,7941,101,40735,24237,5,57,1,604913.04,NULL,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(684,7941,101,40735,24237,5,62,1,386163.00,NULL,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(685,7941,101,40735,24237,5,396,1,300.00,NULL,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(686,7941,101,40735,24237,5,68,1,63.00,NULL,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(687,7941,101,40735,24237,5,157,1,10115.21,NULL,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(688,7941,101,40735,24237,5,482,2,155113.99,NULL,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(689,7941,101,40735,24237,5,251,1,7.50,NULL,'2023-04-30 12:51:28','2023-04-30 12:54:43','2023-04-30 12:54:43'),(690,7941,102,40735,24246,5,14,2,3319138.47,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(691,7941,102,40735,24246,5,57,1,541082.59,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(692,7941,102,40735,24246,5,62,1,511827.00,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(693,7941,102,40735,24246,5,63,1,327883.74,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(694,7941,102,40735,24246,5,326,1,126795.83,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(695,7941,102,40735,24246,5,396,1,610.00,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(696,7941,102,40735,24246,5,68,1,128.10,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(697,7941,102,40735,24246,5,25,1,15.25,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(698,7941,102,40735,24246,5,157,1,28984.70,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(699,7941,102,40735,24246,5,482,1,1778492.13,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(700,7941,102,40735,24246,5,251,1,3319.13,NULL,'2023-04-30 12:51:58','2023-04-30 12:51:58',NULL),(701,7941,103,40735,24242,5,14,2,1369769.78,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL);
INSERT INTO `balance_libro_details` VALUES (702,7941,103,40735,24242,5,57,1,116814.00,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(703,7941,103,40735,24242,5,62,1,606330.00,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(704,7941,103,40735,24242,5,396,1,630.00,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(705,7941,103,40735,24242,5,68,1,132.30,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(706,7941,103,40735,24242,5,157,1,16980.03,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(707,7941,103,40735,24242,5,482,1,628642.13,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(708,7941,103,40735,24242,5,487,1,225.57,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(709,7941,103,40735,24242,5,251,1,15.75,NULL,'2023-04-30 12:52:56','2023-04-30 12:52:56',NULL),(710,7941,104,40735,24241,5,14,2,3780192.90,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(711,7941,104,40735,24241,5,57,2,74610.33,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(712,7941,104,40735,24241,5,483,1,1000000.00,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(713,7941,104,40735,24241,5,57,1,999155.97,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(714,7941,104,40735,24241,5,62,1,206745.00,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(715,7941,104,40735,24241,5,326,1,69961.38,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(716,7941,104,40735,24241,5,396,1,2142.21,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(717,7941,104,40735,24241,5,68,1,136.50,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(718,7941,104,40735,24241,5,157,1,25316.33,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(719,7941,104,40735,24241,5,482,1,1551040.07,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(720,7941,104,40735,24241,5,487,1,289.52,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(721,7941,104,40735,24241,5,251,1,16.25,NULL,'2023-04-30 12:53:22','2023-04-30 12:53:22',NULL),(722,7941,105,40735,24240,5,14,2,241012.94,NULL,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(723,7941,105,40735,24240,5,57,1,1446151.27,NULL,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(724,7941,105,40735,24240,5,62,1,276922.00,NULL,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(725,7941,105,40735,24240,5,396,1,140.00,NULL,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(726,7941,105,40735,24240,5,68,1,29.40,NULL,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(727,7941,105,40735,24240,5,157,1,12085.49,NULL,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(728,7941,105,40735,24240,5,482,2,1494318.72,NULL,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(729,7941,105,40735,24240,5,251,1,3.50,NULL,'2023-04-30 12:53:40','2023-04-30 12:53:40',NULL),(730,7941,106,40735,24239,5,14,2,2208162.44,NULL,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(731,7941,106,40735,24239,5,57,1,1501583.42,NULL,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(732,7941,106,40735,24239,5,62,1,505049.00,NULL,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(733,7941,106,40735,24239,5,396,1,670.00,NULL,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(734,7941,106,40735,24239,5,68,1,140.70,NULL,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(735,7941,106,40735,24239,5,157,1,24315.67,NULL,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(736,7941,106,40735,24239,5,482,1,176386.90,NULL,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(737,7941,106,40735,24239,5,251,1,16.75,NULL,'2023-04-30 12:54:09','2023-04-30 12:54:09',NULL),(738,7941,107,40735,24237,5,14,2,846447.76,NULL,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL),(739,7941,107,40735,24237,5,57,1,604913.04,NULL,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL),(740,7941,107,40735,24237,5,62,1,386163.00,NULL,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL),(741,7941,107,40735,24237,5,396,1,300.00,NULL,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL),(742,7941,107,40735,24237,5,68,1,63.00,NULL,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL);
INSERT INTO `balance_libro_details` VALUES (743,7941,107,40735,24237,5,157,1,10115.21,NULL,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL),(744,7941,107,40735,24237,5,482,2,155113.99,NULL,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL),(745,7941,107,40735,24237,5,251,1,7.50,NULL,'2023-04-30 12:54:43','2023-04-30 12:54:43',NULL),(746,7941,108,40735,24248,5,14,2,1326660.72,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(747,7941,108,40735,24248,5,57,1,379639.10,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(748,7941,108,40735,24248,5,62,1,902676.00,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(749,7941,108,40735,24248,5,63,1,368647.90,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(750,7941,108,40735,24248,5,396,1,4880.00,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(751,7941,108,40735,24248,5,68,1,1024.80,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(752,7941,108,40735,24248,5,251,1,122.00,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(753,7941,108,40735,24248,5,25,1,135.00,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(754,7941,108,40735,24248,5,157,1,12342.69,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(755,7941,108,40735,24248,5,482,2,342806.77,NULL,'2023-04-30 12:56:37','2023-04-30 12:56:37',NULL),(756,7941,109,40735,24237,5,14,2,1391767.37,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(757,7941,109,40735,24237,5,14,2,151000.00,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(758,7941,109,40735,24237,5,57,1,1314063.52,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(759,7941,109,40735,24237,5,62,1,71500.00,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(760,7941,109,40735,24237,5,20,1,16933.33,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(761,7941,109,40735,24237,5,63,1,190271.97,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(762,7941,109,40735,24237,5,473,1,28770.61,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(763,7941,109,40735,24237,5,396,1,18115.88,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(764,7941,109,40735,24237,5,68,1,3804.33,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(765,7941,109,40735,24237,5,251,1,452.89,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(766,7941,109,40735,24237,5,25,1,517.50,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(767,7941,109,40735,24237,5,157,1,18658.44,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(768,7941,109,40735,24237,5,483,2,120321.10,NULL,'2023-04-30 13:01:10','2023-04-30 13:01:10',NULL),(769,7941,110,40735,24238,5,14,2,954247.37,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(770,7941,110,40735,24238,5,482,2,900000.00,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(771,7941,110,40735,24238,5,57,1,792372.05,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(772,7941,110,40735,24238,5,62,1,71500.00,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(773,7941,110,40735,24238,5,63,1,221337.46,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(774,7941,110,40735,24238,5,326,1,33922.31,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(775,7941,110,40735,24238,5,64,1,9804.77,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(776,7941,110,40735,24238,5,473,1,1094.45,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(777,7941,110,40735,24238,5,203,1,22968.62,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(778,7941,110,40735,24238,5,396,1,16245.88,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(779,7941,110,40735,24238,5,68,1,3411.63,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(780,7941,110,40735,24238,5,251,1,406.14,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(781,7941,110,40735,24238,5,25,1,466.50,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(782,7941,110,40735,24238,5,157,1,13381.59,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL),(783,7941,110,40735,24238,5,483,1,667335.97,NULL,'2023-04-30 13:04:02','2023-04-30 13:04:02',NULL);
INSERT INTO `balance_libro_details` VALUES (784,7941,111,40735,24239,5,14,2,3485096.89,NULL,'2023-04-30 13:07:26','2023-04-30 13:07:26',NULL),(785,7941,111,40735,24239,5,57,1,1755512.71,NULL,'2023-04-30 13:07:26','2023-04-30 13:07:26',NULL),(786,7941,111,40735,24239,5,62,1,100000.00,NULL,'2023-04-30 13:07:26','2023-04-30 13:07:26',NULL),(787,7941,111,40735,24239,5,63,1,195421.63,NULL,'2023-04-30 13:07:26','2023-04-30 13:07:26',NULL),(788,7941,111,40735,24239,5,326,1