-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-30504273-1
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-09-30 17:45:36','Actividad Generica 1','000001',NULL),(2,NULL,'2022-09-30 17:45:36','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Diazrobin22',NULL,1,40720,'2022-10-19'),(2,NULL,'Diazrobin22',NULL,1,40720,'2024-04-16');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'rafadiazaugier@gmail.com','3816166256',NULL,1,40719,'2023-01-10');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2115 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7908,40720,1526,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1200.06,NULL,NULL,1,'2022-10-03 12:16:31','2022-10-03 12:16:31',NULL),(2,7908,40720,1526,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',4999.95,NULL,NULL,1,'2022-10-03 18:01:33','2022-10-03 18:01:33',NULL),(3,7908,40720,1526,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2001.38,NULL,NULL,1,'2022-10-03 18:05:16','2022-10-03 18:05:16',NULL),(4,7908,40720,1526,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',1500.91,NULL,NULL,1,'2022-10-03 18:08:01','2022-10-03 18:08:01',NULL),(5,7908,40720,1526,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',1999.58,NULL,NULL,1,'2022-10-03 18:09:50','2022-10-03 18:09:50',NULL),(6,7908,40720,1526,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2566.41,NULL,NULL,1,'2022-10-03 18:13:10','2022-10-03 18:14:14','2022-10-03 18:14:14'),(7,7908,40720,1526,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',3100.40,NULL,NULL,1,'2022-10-03 18:14:14','2022-10-03 18:14:14',NULL),(8,7908,40720,1526,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',10027.49,NULL,NULL,1,'2022-10-03 18:18:30','2022-10-03 18:18:30',NULL),(9,7908,40720,1526,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',5000.39,NULL,NULL,1,'2022-10-03 18:20:39','2022-10-03 18:20:39',NULL),(10,7908,40720,1526,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2999.98,NULL,NULL,1,'2022-10-03 18:22:57','2022-10-03 18:22:57',NULL),(11,7908,40720,1526,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',6995.92,NULL,NULL,1,'2022-10-03 18:26:29','2022-10-03 18:26:29',NULL),(12,7908,40720,1526,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',3012.20,NULL,NULL,1,'2022-10-03 18:30:18','2022-10-03 18:30:18',NULL),(13,7908,40720,1526,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',3038.29,NULL,NULL,1,'2022-10-03 18:31:52','2022-10-03 18:31:52',NULL),(14,7908,40720,1526,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',6000.90,NULL,NULL,1,'2022-10-03 18:33:37','2022-10-03 18:33:37',NULL),(15,7908,40720,1526,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',4001.32,NULL,NULL,1,'2022-10-03 18:35:10','2022-10-03 18:35:10',NULL),(16,7908,40720,1526,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',20000.01,NULL,NULL,1,'2022-10-03 18:38:49','2022-10-03 18:38:49',NULL),(17,7908,40720,1526,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',30000.00,NULL,NULL,1,'2022-10-03 18:40:42','2022-10-03 18:40:42',NULL),(18,7908,40720,1526,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2000.08,NULL,NULL,1,'2022-10-03 18:42:32','2022-10-03 18:42:32',NULL),(19,7908,40720,1526,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',1999.99,NULL,NULL,1,'2022-10-03 18:43:54','2022-10-03 18:43:54',NULL),(20,7908,40720,1526,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',9000.99,NULL,NULL,1,'2022-10-03 18:45:29','2022-10-03 18:45:29',NULL),(21,7908,40720,1526,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',3001.32,NULL,NULL,1,'2022-10-03 18:47:36','2022-10-03 18:47:36',NULL);
INSERT INTO `balance_libro` VALUES (22,7908,40720,1526,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2500.05,NULL,NULL,1,'2022-10-03 18:49:37','2022-10-03 18:49:37',NULL),(23,7908,40720,1526,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2979.65,NULL,NULL,1,'2022-10-04 12:36:29','2022-10-04 12:36:29',NULL),(24,7908,40720,1526,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',3001.00,NULL,NULL,1,'2022-10-04 12:39:55','2022-10-04 12:39:55',NULL),(25,7908,40720,1526,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',20001.80,NULL,NULL,1,'2022-10-04 12:41:37','2022-10-04 12:41:37',NULL),(26,7908,40720,1526,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',20023.40,NULL,NULL,1,'2022-10-04 12:43:01','2022-10-04 12:43:01',NULL),(27,7908,40720,1526,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',3000.06,NULL,NULL,1,'2022-10-04 12:44:53','2022-10-04 12:44:53',NULL),(28,7908,40720,1526,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2272.23,NULL,NULL,1,'2022-10-04 12:49:20','2022-10-04 12:49:20',NULL),(29,7908,40720,1526,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',179000.01,NULL,NULL,1,'2022-10-04 12:52:20','2022-10-04 12:52:20',NULL),(30,7908,40720,1526,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',141075.18,NULL,NULL,1,'2022-10-05 12:17:57','2022-10-05 12:17:57',NULL),(31,7908,40720,1526,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',92485.46,NULL,NULL,1,'2022-10-05 12:20:41','2022-10-05 12:20:41',NULL),(32,7908,40720,1526,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',194894.96,NULL,NULL,1,'2022-10-05 12:23:11','2022-10-05 12:23:11',NULL),(33,7908,40720,1526,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',60792.69,NULL,NULL,1,'2022-10-05 12:25:56','2022-10-05 12:25:56',NULL),(34,7908,40720,1526,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',62169.80,NULL,NULL,1,'2022-10-05 12:30:13','2022-10-05 12:30:13',NULL),(35,7908,40720,1526,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',400695.75,NULL,NULL,1,'2022-10-05 12:35:30','2022-10-05 12:35:30',NULL),(36,7908,40720,1526,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',25211.45,NULL,NULL,1,'2022-10-05 12:39:26','2022-10-05 12:39:26',NULL),(37,7908,40720,1526,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',141075.18,NULL,NULL,1,'2022-10-05 12:45:31','2022-10-05 12:55:18','2022-10-05 12:55:18'),(38,7908,40720,1526,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',141075.18,NULL,NULL,1,'2022-10-05 12:55:18','2022-10-05 12:55:18',NULL),(39,7908,40720,1526,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',110500.00,NULL,NULL,1,'2022-10-11 12:11:57','2022-10-12 12:57:50','2022-10-12 12:57:50'),(40,7908,40720,1526,7,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',57894.35,NULL,NULL,1,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL),(41,7908,40720,1526,7,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',138288.44,NULL,NULL,1,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL),(42,7908,40720,1526,7,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',258960.31,NULL,NULL,1,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL);
INSERT INTO `balance_libro` VALUES (43,7908,40720,1525,15,51,'App\\Models\\PeriodLiquidation',NULL,51,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',807.64,NULL,NULL,1,'2022-10-12 13:18:48','2022-10-12 13:18:48',NULL),(44,7908,40720,1526,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',913903.69,NULL,NULL,1,'2022-10-12 14:59:47','2022-10-12 14:59:47',NULL),(45,7908,40720,1526,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2182981.76,NULL,NULL,1,'2022-10-12 15:02:34','2022-10-12 15:02:34',NULL),(46,7908,40720,1526,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',4087873.47,NULL,NULL,1,'2022-10-12 15:05:37','2022-10-12 15:05:37',NULL),(47,7908,40720,1526,15,57,'App\\Models\\PeriodLiquidation',NULL,57,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',707047.88,NULL,NULL,1,'2022-10-12 15:26:05','2022-10-12 19:43:44','2022-10-12 19:43:44'),(48,7908,40720,1526,15,57,'App\\Models\\PeriodLiquidation',NULL,57,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',707047.88,NULL,NULL,1,'2022-10-12 20:49:14','2022-10-13 00:16:50','2022-10-13 00:16:50'),(49,7908,40720,1526,7,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',87.00,NULL,NULL,1,'2022-10-13 13:01:03','2022-10-13 13:01:03',NULL),(50,7908,40720,1526,7,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',544.16,NULL,NULL,1,'2022-10-13 13:07:58','2022-10-13 13:07:58',NULL),(51,7908,40720,1526,15,62,'App\\Models\\PeriodLiquidation',NULL,62,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',707047.88,NULL,NULL,1,'2022-10-15 15:19:05','2022-10-15 15:19:05',NULL),(52,7908,40720,1527,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',2999.94,NULL,NULL,1,'2022-11-07 12:15:03','2022-11-07 12:15:03',NULL),(53,7908,40720,1527,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1800.80,NULL,NULL,1,'2022-11-07 12:18:17','2022-11-07 12:18:17',NULL),(54,7908,40720,1527,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',4002.20,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 12:20:27',NULL),(55,7908,40720,1527,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',20002.89,NULL,NULL,1,'2022-11-07 12:21:23','2022-11-07 12:21:23',NULL),(56,7908,40720,1527,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3999.96,NULL,NULL,1,'2022-11-07 12:22:38','2022-11-07 12:23:28','2022-11-07 12:23:28'),(57,7908,40720,1527,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3999.96,NULL,NULL,1,'2022-11-07 12:23:28','2022-11-07 12:23:28',NULL),(58,7908,40720,1527,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',16702.90,NULL,NULL,1,'2022-11-07 12:25:02','2022-11-07 12:25:02',NULL),(59,7908,40720,1527,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',2003.00,NULL,NULL,1,'2022-11-07 12:26:21','2022-11-07 12:26:21',NULL),(60,7908,40720,1527,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',4005.20,NULL,NULL,1,'2022-11-07 12:27:17','2022-11-07 12:27:17',NULL),(61,7908,40720,1527,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',32499.99,NULL,NULL,1,'2022-11-07 12:29:32','2022-11-07 12:29:32',NULL),(62,7908,40720,1527,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',54354.00,NULL,NULL,1,'2022-11-07 12:31:41','2022-11-07 12:31:41',NULL),(63,7908,40720,1527,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2940.00,NULL,NULL,1,'2022-11-07 12:33:10','2022-11-07 12:33:10',NULL);
INSERT INTO `balance_libro` VALUES (64,7908,40720,1527,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',5000.00,NULL,NULL,1,'2022-11-07 12:34:09','2022-11-07 12:34:09',NULL),(65,7908,40720,1527,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4710.61,NULL,NULL,1,'2022-11-07 12:36:44','2022-11-07 12:36:44',NULL),(66,7908,40720,1527,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3150.57,NULL,NULL,1,'2022-11-07 12:39:35','2022-11-07 14:48:52','2022-11-07 14:48:52'),(67,7908,40720,1527,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5002.79,NULL,NULL,1,'2022-11-07 12:42:10','2022-11-07 12:42:10',NULL),(68,7908,40720,1527,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2004.60,NULL,NULL,1,'2022-11-07 12:43:44','2022-11-07 12:43:44',NULL),(69,7908,40720,1527,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',5000.01,NULL,NULL,1,'2022-11-07 12:44:38','2022-11-07 12:44:38',NULL),(70,7908,40720,1527,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3504.70,NULL,NULL,1,'2022-11-07 12:45:48','2022-11-07 12:45:48',NULL),(71,7908,40720,1527,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3003.50,NULL,NULL,1,'2022-11-07 12:46:44','2022-11-07 12:46:44',NULL),(72,7908,40720,1527,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3003.90,NULL,NULL,1,'2022-11-07 12:48:05','2022-11-07 12:48:05',NULL),(73,7908,40720,1527,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',25602.05,NULL,NULL,1,'2022-11-07 12:49:53','2022-11-07 12:49:53',NULL),(74,7908,40720,1527,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2002.13,NULL,NULL,1,'2022-11-07 12:51:03','2022-11-07 12:51:03',NULL),(75,7908,40720,1527,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4000.39,NULL,NULL,1,'2022-11-07 12:53:55','2022-11-07 12:53:55',NULL),(76,7908,40720,1527,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',3000.79,NULL,NULL,1,'2022-11-07 12:55:11','2022-11-07 12:55:11',NULL),(77,7908,40720,1527,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',3001.00,NULL,NULL,1,'2022-11-07 12:56:12','2022-11-07 12:56:12',NULL),(78,7908,40720,1527,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',21090.53,NULL,NULL,1,'2022-11-07 13:05:53','2022-11-07 13:05:53',NULL),(79,7908,40720,1527,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',40610.25,NULL,NULL,1,'2022-11-07 13:07:42','2022-11-07 13:07:42',NULL),(80,7908,40720,1527,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2760.00,NULL,NULL,1,'2022-11-07 13:08:32','2022-11-07 13:08:32',NULL),(81,7908,40720,1527,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',800.28,NULL,NULL,1,'2022-11-07 13:09:41','2022-11-07 13:09:41',NULL),(82,7908,40720,1527,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',10182.78,NULL,NULL,1,'2022-11-07 14:35:05','2022-11-07 14:35:05',NULL),(83,7908,40720,1527,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',4761.39,NULL,NULL,1,'2022-11-07 14:36:12','2022-11-07 14:36:12',NULL),(84,7908,40720,1527,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2540.29,NULL,NULL,1,'2022-11-07 14:39:00','2022-11-07 14:39:00',NULL);
INSERT INTO `balance_libro` VALUES (85,7908,40720,1527,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',9188.11,NULL,NULL,1,'2022-11-07 14:41:47','2022-11-07 14:41:47',NULL),(86,7908,40720,1527,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3150.57,NULL,NULL,1,'2022-11-07 14:48:52','2022-11-07 14:48:52',NULL),(87,7908,40720,1527,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29948.08,NULL,NULL,1,'2022-11-07 17:31:34','2022-11-07 17:31:34',NULL),(88,7908,40720,1527,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',31485.78,NULL,NULL,1,'2022-11-07 17:32:44','2022-11-07 17:32:44',NULL),(89,7908,40720,1527,15,103,'App\\Models\\PeriodLiquidation',NULL,103,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',62594.30,NULL,NULL,1,'2022-11-18 12:45:12','2022-11-18 12:45:12',NULL),(90,7908,40720,1528,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1374734.77,NULL,NULL,1,'2022-11-18 15:36:32','2022-11-18 15:36:32',NULL),(91,7908,40720,1528,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',654530.01,NULL,NULL,1,'2022-11-24 18:40:31','2022-11-24 18:40:31',NULL),(92,7908,40720,1528,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3300002.75,NULL,NULL,1,'2022-11-24 18:57:13','2022-11-24 18:57:13',NULL),(93,7908,40720,1528,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',575355.00,NULL,NULL,1,'2022-11-29 20:05:47','2022-11-29 20:05:47',NULL),(94,7908,40720,1528,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',5450.00,NULL,NULL,1,'2022-11-29 20:17:23','2022-11-29 20:17:23',NULL),(95,7908,40720,1528,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',119600.01,NULL,NULL,1,'2022-11-29 20:20:40','2022-11-29 20:20:40',NULL),(96,7908,40720,1528,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',3500.01,NULL,NULL,1,'2022-12-19 19:19:03','2022-12-19 19:19:03',NULL),(97,7908,40720,1528,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1999.98,NULL,NULL,1,'2022-12-19 19:21:05','2022-12-19 19:21:05',NULL),(98,7908,40720,1528,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',6000.12,NULL,NULL,1,'2022-12-19 19:22:54','2022-12-19 19:22:54',NULL),(99,7908,40720,1528,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1999.98,NULL,NULL,1,'2022-12-20 12:24:47','2022-12-20 12:24:47',NULL),(100,7908,40720,1528,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',7000.02,NULL,NULL,1,'2022-12-20 12:26:53','2022-12-20 12:26:53',NULL),(101,7908,40720,1528,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',3301.67,NULL,NULL,1,'2022-12-20 12:28:32','2022-12-20 12:28:32',NULL),(102,7908,40720,1528,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',5000.69,NULL,NULL,1,'2022-12-20 12:30:29','2022-12-20 12:30:29',NULL),(103,7908,40720,1528,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',42900.02,NULL,NULL,1,'2022-12-20 12:33:05','2022-12-20 12:33:05',NULL),(104,7908,40720,1528,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',7199.60,NULL,NULL,1,'2022-12-20 12:35:17','2022-12-20 12:35:17',NULL),(105,7908,40720,1528,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',4000.81,NULL,NULL,1,'2022-12-20 12:36:13','2022-12-20 12:36:13',NULL);
INSERT INTO `balance_libro` VALUES (106,7908,40720,1528,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',3999.60,NULL,NULL,1,'2022-12-20 12:38:35','2022-12-20 12:38:35',NULL),(107,7908,40720,1528,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',8001.21,NULL,NULL,1,'2022-12-20 12:40:00','2022-12-20 12:40:00',NULL),(108,7908,40720,1528,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',3002.09,NULL,NULL,1,'2022-12-20 12:41:41','2022-12-20 12:41:41',NULL),(109,7908,40720,1528,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',3001.20,NULL,NULL,1,'2022-12-20 12:43:30','2022-12-20 12:43:30',NULL),(110,7908,40720,1528,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',5000.71,NULL,NULL,1,'2022-12-20 12:45:24','2022-12-20 12:45:24',NULL),(111,7908,40720,1528,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',4002.01,NULL,NULL,1,'2022-12-20 12:47:14','2022-12-20 12:47:14',NULL),(112,7908,40720,1528,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3501.00,NULL,NULL,1,'2022-12-20 12:48:59','2022-12-20 12:48:59',NULL),(113,7908,40720,1528,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2999.80,NULL,NULL,1,'2022-12-20 12:50:02','2022-12-20 12:50:02',NULL),(114,7908,40720,1528,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',3002.60,NULL,NULL,1,'2022-12-20 12:51:36','2022-12-20 12:51:36',NULL),(115,7908,40720,1528,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5001.21,NULL,NULL,1,'2022-12-20 12:56:25','2022-12-20 12:56:25',NULL),(116,7908,40720,1528,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',4000.09,NULL,NULL,1,'2022-12-20 16:56:24','2022-12-20 17:35:07','2022-12-20 17:35:07'),(117,7908,40720,1528,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',3006.07,NULL,NULL,1,'2022-12-20 16:59:10','2022-12-20 17:34:48','2022-12-20 17:34:48'),(118,7908,40720,1528,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',3003.36,NULL,NULL,1,'2022-12-20 17:00:40','2022-12-20 17:34:29','2022-12-20 17:34:29'),(119,7908,40720,1528,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',4000.01,NULL,NULL,1,'2022-12-20 17:03:13','2022-12-20 17:34:14','2022-12-20 17:34:14'),(120,7908,40720,1528,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',8100.22,NULL,NULL,1,'2022-12-20 17:06:19','2022-12-20 17:33:37','2022-12-20 17:33:37'),(121,7908,40720,1528,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2000.07,NULL,NULL,1,'2022-12-20 17:07:58','2022-12-20 17:33:25','2022-12-20 17:33:25'),(122,7908,40720,1528,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6441.10,NULL,NULL,1,'2022-12-20 17:12:23','2022-12-20 17:32:41','2022-12-20 17:32:41'),(123,7908,40720,1528,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5260.00,NULL,NULL,1,'2022-12-20 17:13:40','2022-12-20 17:32:32','2022-12-20 17:32:32'),(124,7908,40720,1528,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5260.00,NULL,NULL,1,'2022-12-20 17:14:43','2022-12-20 17:31:38','2022-12-20 17:31:38'),(125,7908,40720,1528,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4759.99,NULL,NULL,1,'2022-12-20 17:15:35','2022-12-20 17:31:27','2022-12-20 17:31:27');
INSERT INTO `balance_libro` VALUES (126,7908,40720,1528,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',18530.38,NULL,NULL,1,'2022-12-20 17:16:45','2022-12-20 17:31:15','2022-12-20 17:31:15'),(127,7908,40720,1528,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',11140.68,NULL,NULL,1,'2022-12-20 17:17:31','2022-12-20 17:31:05','2022-12-20 17:31:05'),(128,7908,40720,1528,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',9000.00,NULL,NULL,1,'2022-12-20 17:19:00','2022-12-20 17:30:49','2022-12-20 17:30:49'),(129,7908,40720,1528,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',9095.00,NULL,NULL,1,'2022-12-20 17:21:46','2022-12-20 17:30:33','2022-12-20 17:30:33'),(130,7908,40720,1528,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',4000.09,NULL,NULL,1,'2022-12-20 17:38:56','2022-12-20 17:38:56',NULL),(131,7908,40720,1528,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',3006.07,NULL,NULL,1,'2022-12-20 17:41:16','2022-12-20 17:41:16',NULL),(132,7908,40720,1528,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',3003.36,NULL,NULL,1,'2022-12-20 17:42:26','2022-12-20 17:42:26',NULL),(133,7908,40720,1528,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',4000.01,NULL,NULL,1,'2022-12-20 17:43:58','2022-12-20 17:43:58',NULL),(134,7908,40720,1528,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',8100.20,NULL,NULL,1,'2022-12-20 17:46:07','2022-12-20 17:46:07',NULL),(135,7908,40720,1528,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2000.07,NULL,NULL,1,'2022-12-20 17:47:29','2022-12-20 17:47:29',NULL),(136,7908,40720,1528,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6441.10,NULL,NULL,1,'2022-12-20 17:49:41','2022-12-20 17:49:41',NULL),(137,7908,40720,1528,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',9095.00,NULL,NULL,1,'2022-12-20 17:50:57','2022-12-20 17:50:57',NULL),(138,7908,40720,1528,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',9000.00,NULL,NULL,1,'2022-12-20 17:52:29','2022-12-20 17:52:29',NULL),(139,7908,40720,1528,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',11140.68,NULL,NULL,1,'2022-12-20 17:54:12','2022-12-20 17:54:12',NULL),(140,7908,40720,1528,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',18530.38,NULL,NULL,1,'2022-12-20 17:55:01','2022-12-20 17:55:01',NULL),(141,7908,40720,1528,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4759.99,NULL,NULL,1,'2022-12-20 17:56:02','2022-12-20 17:56:02',NULL),(142,7908,40720,1528,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5260.00,NULL,NULL,1,'2022-12-20 17:57:08','2022-12-20 17:57:08',NULL),(143,7908,40720,1528,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5260.00,NULL,NULL,1,'2022-12-20 17:59:36','2022-12-20 17:59:36',NULL),(144,7908,40720,1528,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',7999.31,NULL,NULL,1,'2022-12-21 12:39:48','2022-12-21 12:39:48',NULL),(145,7908,40720,1528,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',3000.06,NULL,NULL,1,'2022-12-21 12:41:50','2022-12-21 12:41:50',NULL),(146,7908,40720,1528,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4001.31,NULL,NULL,1,'2022-12-21 12:43:39','2022-12-21 12:43:39',NULL);
INSERT INTO `balance_libro` VALUES (147,7908,40720,1528,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',57003.28,NULL,NULL,1,'2022-12-21 12:46:08','2022-12-21 12:47:10','2022-12-21 12:47:10'),(148,7908,40720,1528,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',57003.28,NULL,NULL,1,'2022-12-21 12:47:10','2022-12-21 12:47:10',NULL),(149,7908,40720,1528,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4002.17,NULL,NULL,1,'2022-12-21 12:48:48','2022-12-21 12:48:48',NULL),(150,7908,40720,1528,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',8500.06,NULL,NULL,1,'2022-12-21 12:50:21','2022-12-21 12:50:21',NULL),(151,7908,40720,1528,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',33083.30,NULL,NULL,1,'2022-12-21 14:41:37','2022-12-21 14:41:37',NULL),(152,7908,40720,1528,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',40359.95,NULL,NULL,1,'2022-12-21 15:25:47','2022-12-21 15:25:47',NULL),(153,7908,40720,1528,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3061.20,NULL,NULL,1,'2022-12-21 15:28:05','2022-12-21 15:28:05',NULL),(154,7908,40720,1528,15,193,'App\\Models\\PeriodLiquidation',NULL,193,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',586944.92,NULL,NULL,1,'2022-12-21 17:06:35','2022-12-21 17:25:21','2022-12-21 17:25:21'),(155,7908,40720,1528,15,194,'App\\Models\\PeriodLiquidation',NULL,194,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',586944.92,NULL,NULL,1,'2022-12-22 14:09:13','2022-12-22 14:09:13',NULL),(156,7908,40720,1529,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1085501.85,NULL,NULL,1,'2023-01-02 18:56:00','2023-01-02 18:56:00',NULL),(157,7908,40720,1529,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1118923.56,NULL,NULL,1,'2023-01-02 19:00:41','2023-01-02 19:00:41',NULL),(158,7908,40720,1529,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',987285.50,NULL,NULL,1,'2023-01-02 19:02:51','2023-01-02 19:02:51',NULL),(159,7908,40720,1529,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',432665.29,NULL,NULL,1,'2023-01-02 19:14:45','2023-01-02 19:14:45',NULL),(160,7908,40720,1529,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',30540.40,NULL,NULL,1,'2023-01-04 19:17:55','2023-01-16 19:28:30','2023-01-16 19:28:30'),(161,7908,40720,1529,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',95059.28,NULL,NULL,1,'2023-01-04 19:17:55','2023-01-16 19:50:06','2023-01-16 19:50:06'),(162,7908,40720,1529,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',9972.30,NULL,NULL,1,'2023-01-04 19:17:55','2023-01-16 19:41:34','2023-01-16 19:41:34'),(163,7908,40720,1529,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',18036.24,NULL,NULL,1,'2023-01-04 19:17:55','2023-01-16 19:50:37','2023-01-16 19:50:37'),(164,7908,40720,1529,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',18036.24,NULL,NULL,1,'2023-01-04 19:17:56','2023-01-16 19:49:32','2023-01-16 19:49:32'),(165,7908,40720,1529,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',114933.52,NULL,NULL,1,'2023-01-04 19:17:56','2023-01-16 19:52:07','2023-01-16 19:52:07'),(166,7908,40720,1529,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',270673.16,NULL,NULL,1,'2023-01-04 19:17:56','2023-01-16 19:51:35','2023-01-16 19:51:35');
INSERT INTO `balance_libro` VALUES (167,7908,40720,1529,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',215229.65,NULL,NULL,1,'2023-01-04 19:17:56','2023-01-16 19:42:51','2023-01-16 19:42:51'),(168,7908,40720,1529,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2880003.28,NULL,NULL,1,'2023-01-04 19:52:04','2023-01-04 19:52:04',NULL),(169,7908,40720,1533,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2280003.00,NULL,NULL,1,'2023-01-06 12:35:57','2023-01-06 12:35:57',NULL),(170,7908,40720,1533,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',61389.00,NULL,NULL,1,'2023-01-10 18:48:02','2023-01-10 18:48:02',NULL),(171,7908,40720,1529,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',34523.32,NULL,NULL,1,'2023-01-11 20:32:41','2023-01-11 20:32:41',NULL),(172,7908,40720,1529,3,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2001.96,NULL,NULL,1,'2023-01-11 20:34:38','2023-01-11 20:34:38',NULL),(173,7908,40720,1529,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7300.29,NULL,NULL,1,'2023-01-11 20:36:58','2023-01-11 20:36:58',NULL),(174,7908,40720,1529,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2999.95,NULL,NULL,1,'2023-01-11 20:38:55','2023-01-11 20:38:55',NULL),(175,7908,40720,1529,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',22999.70,NULL,NULL,1,'2023-01-11 20:41:13','2023-01-11 20:41:13',NULL),(176,7908,40720,1529,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',8005.02,NULL,NULL,1,'2023-01-11 20:43:08','2023-01-11 20:43:08',NULL),(177,7908,40720,1529,3,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',11201.29,NULL,NULL,1,'2023-01-12 12:41:07','2023-01-12 12:41:07',NULL),(178,7908,40720,1529,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4499.79,NULL,NULL,1,'2023-01-12 12:42:11','2023-01-12 12:42:11',NULL),(179,7908,40720,1529,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3002.89,NULL,NULL,1,'2023-01-12 12:43:08','2023-01-12 12:43:08',NULL),(180,7908,40720,1529,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',19000.70,NULL,NULL,1,'2023-01-12 12:45:58','2023-01-12 12:45:58',NULL),(181,7908,40720,1529,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4002.57,NULL,NULL,1,'2023-01-12 12:48:08','2023-01-12 12:48:08',NULL),(182,7908,40720,1529,3,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',4999.28,NULL,NULL,1,'2023-01-12 12:49:21','2023-01-12 12:49:21',NULL),(183,7908,40720,1529,3,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2500.09,NULL,NULL,1,'2023-01-12 12:53:06','2023-01-12 12:53:06',NULL),(184,7908,40720,1529,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',3001.11,NULL,NULL,1,'2023-01-12 12:54:30','2023-01-12 12:54:30',NULL),(185,7908,40720,1529,3,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',23000.60,NULL,NULL,1,'2023-01-12 12:55:45','2023-01-12 12:55:45',NULL),(186,7908,40720,1529,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',7000.22,NULL,NULL,1,'2023-01-12 12:58:55','2023-01-12 12:58:55',NULL),(187,7908,40720,1529,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',12001.59,NULL,NULL,1,'2023-01-12 12:59:50','2023-01-12 12:59:50',NULL);
INSERT INTO `balance_libro` VALUES (188,7908,40720,1529,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',13001.33,NULL,NULL,1,'2023-01-12 13:00:44','2023-01-12 13:00:44',NULL),(189,7908,40720,1529,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',7999.92,NULL,NULL,1,'2023-01-12 13:03:52','2023-01-12 13:03:52',NULL),(190,7908,40720,1529,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',7192.06,NULL,NULL,1,'2023-01-16 16:52:13','2023-01-16 16:52:13',NULL),(191,7908,40720,1529,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',2607.24,NULL,NULL,1,'2023-01-16 16:56:42','2023-01-16 16:56:42',NULL),(192,7908,40720,1529,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2657.80,NULL,NULL,1,'2023-01-16 16:59:42','2023-01-16 16:59:42',NULL),(193,7908,40720,1529,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1100.00,NULL,NULL,1,'2023-01-16 17:00:45','2023-01-16 17:00:45',NULL),(194,7908,40720,1529,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',16660.47,NULL,NULL,1,'2023-01-16 17:02:22','2023-01-16 17:02:22',NULL),(195,7908,40720,1529,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2218.22,NULL,NULL,1,'2023-01-16 17:03:10','2023-01-16 17:03:10',NULL),(196,7908,40720,1529,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1093.17,NULL,NULL,1,'2023-01-16 17:04:03','2023-01-16 17:04:03',NULL),(197,7908,40720,1529,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',30074.27,NULL,NULL,1,'2023-01-16 18:21:18','2023-01-16 18:21:18',NULL),(198,7908,40720,1529,15,234,'App\\Models\\PeriodLiquidation',NULL,234,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',566581.90,NULL,NULL,1,'2023-01-16 18:44:52','2023-01-16 18:48:07','2023-01-16 18:48:07'),(199,7908,40720,1529,15,234,'App\\Models\\PeriodLiquidation',NULL,234,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',566581.90,NULL,NULL,1,'2023-01-16 19:05:16','2023-01-16 19:24:06','2023-01-16 19:24:06'),(200,7908,40720,1529,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',30352.27,NULL,NULL,1,'2023-01-16 19:28:30','2023-01-16 19:52:32','2023-01-16 19:52:32'),(201,7908,40720,1529,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',9911.30,NULL,NULL,1,'2023-01-16 19:41:34','2023-01-16 19:48:28','2023-01-16 19:48:28'),(202,7908,40720,1529,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',213903.80,NULL,NULL,1,'2023-01-16 19:42:51','2023-01-16 19:51:13','2023-01-16 19:51:13'),(203,7908,40720,1529,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',9911.30,NULL,NULL,1,'2023-01-16 19:48:28','2023-01-16 19:48:28',NULL),(204,7908,40720,1529,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',17924.70,NULL,NULL,1,'2023-01-16 19:49:32','2023-01-16 19:49:32',NULL),(205,7908,40720,1529,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',94473.70,NULL,NULL,1,'2023-01-16 19:50:06','2023-01-16 19:50:06',NULL),(206,7908,40720,1529,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',17924.70,NULL,NULL,1,'2023-01-16 19:50:37','2023-01-16 19:50:37',NULL),(207,7908,40720,1529,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',213903.80,NULL,NULL,1,'2023-01-16 19:51:13','2023-01-16 19:51:13',NULL);
INSERT INTO `balance_libro` VALUES (208,7908,40720,1529,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',269005.42,NULL,NULL,1,'2023-01-16 19:51:35','2023-01-16 19:51:35',NULL),(209,7908,40720,1529,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',114224.63,NULL,NULL,1,'2023-01-16 19:52:07','2023-01-16 19:52:07',NULL),(210,7908,40720,1529,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',30352.27,NULL,NULL,1,'2023-01-16 19:52:32','2023-01-16 19:52:32',NULL),(211,7908,40720,1529,15,246,'App\\Models\\PeriodLiquidation',NULL,246,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',566581.90,NULL,NULL,1,'2023-01-17 20:07:23','2023-01-17 20:11:35','2023-01-17 20:11:35'),(212,7908,40720,1529,15,246,'App\\Models\\PeriodLiquidation',NULL,246,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',566581.90,NULL,NULL,1,'2023-01-17 21:35:04','2023-01-17 21:35:04',NULL),(213,7908,40720,1534,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2760001.53,NULL,NULL,1,'2023-02-02 17:15:07','2023-02-02 17:15:07',NULL),(214,7908,40720,1533,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3902.78,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(215,7908,40720,1533,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',73789.85,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 20:02:08','2023-02-02 20:02:08'),(216,7908,40720,1533,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5998.45,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(217,7908,40720,1533,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',20000.00,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(218,7908,40720,1533,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',59227.75,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:58:17','2023-02-02 19:58:17'),(219,7908,40720,1533,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',117987.25,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:57:56','2023-02-02 19:57:56'),(220,7908,40720,1533,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4600.00,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(221,7908,40720,1533,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',37711.04,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 20:00:49','2023-02-02 20:00:49'),(222,7908,40720,1533,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11224.45,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 20:00:31','2023-02-02 20:00:31'),(223,7908,40720,1533,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',435.16,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(224,7908,40720,1533,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',14199.87,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(225,7908,40720,1533,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4009.09,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(226,7908,40720,1533,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',23132.50,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(227,7908,40720,1533,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',24909.86,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL);
INSERT INTO `balance_libro` VALUES (228,7908,40720,1533,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',27600.00,NULL,NULL,1,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(229,7908,40720,1533,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',26780.78,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(230,7908,40720,1533,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3292.98,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(231,7908,40720,1533,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6900.00,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(232,7908,40720,1533,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',859.30,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(233,7908,40720,1533,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2978.50,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(234,7908,40720,1533,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3389.79,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(235,7908,40720,1533,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',776.13,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(236,7908,40720,1533,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',207.00,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(237,7908,40720,1533,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6420.00,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(238,7908,40720,1533,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',20200.00,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(239,7908,40720,1533,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1036970.00,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(240,7908,40720,1533,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4500.00,NULL,NULL,1,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(241,7908,40720,1533,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',118211.72,NULL,NULL,1,'2023-02-02 19:57:56','2023-02-02 20:01:13','2023-02-02 20:01:13'),(242,7908,40720,1533,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',58863.35,NULL,NULL,1,'2023-02-02 19:58:17','2023-02-02 20:01:43','2023-02-02 20:01:43'),(243,7908,40720,1533,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11154.39,NULL,NULL,1,'2023-02-02 20:00:31','2023-02-02 20:00:31',NULL),(244,7908,40720,1533,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',37478.73,NULL,NULL,1,'2023-02-02 20:00:49','2023-02-02 20:00:49',NULL),(245,7908,40720,1533,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',118211.72,NULL,NULL,1,'2023-02-02 20:01:13','2023-02-02 20:01:13',NULL),(246,7908,40720,1533,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',58863.35,NULL,NULL,1,'2023-02-02 20:01:43','2023-02-02 20:01:43',NULL),(247,7908,40720,1533,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',73335.29,NULL,NULL,1,'2023-02-02 20:02:08','2023-02-02 20:02:49','2023-02-02 20:02:49'),(248,7908,40720,1533,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',73335.29,NULL,NULL,1,'2023-02-02 20:02:49','2023-02-02 20:02:49',NULL);
INSERT INTO `balance_libro` VALUES (249,7908,40720,1533,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',42757.96,NULL,NULL,1,'2023-02-02 20:10:41','2023-02-02 20:13:02','2023-02-02 20:13:02'),(250,7908,40720,1533,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',22154.41,NULL,NULL,1,'2023-02-02 20:10:41','2023-02-02 20:12:12','2023-02-02 20:12:12'),(251,7908,40720,1533,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',85120.07,NULL,NULL,1,'2023-02-02 20:10:41','2023-02-02 20:11:55','2023-02-02 20:11:55'),(252,7908,40720,1533,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',84595.72,NULL,NULL,1,'2023-02-02 20:11:55','2023-02-02 20:11:55',NULL),(253,7908,40720,1533,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',22016.37,NULL,NULL,1,'2023-02-02 20:12:12','2023-02-02 20:12:12',NULL),(254,7908,40720,1533,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',42494.56,NULL,NULL,1,'2023-02-02 20:13:02','2023-02-02 20:13:02',NULL),(255,7908,40720,1533,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',30001.00,NULL,NULL,1,'2023-02-07 12:52:02','2023-02-07 12:52:02',NULL),(256,7908,40720,1533,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3799.61,NULL,NULL,1,'2023-02-07 12:53:06','2023-02-07 12:53:06',NULL),(257,7908,40720,1533,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3800.90,NULL,NULL,1,'2023-02-07 12:54:14','2023-02-07 12:54:14',NULL),(258,7908,40720,1533,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8700.39,NULL,NULL,1,'2023-02-07 12:55:19','2023-02-07 12:55:19',NULL),(259,7908,40720,1533,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22102.30,NULL,NULL,1,'2023-02-07 12:56:37','2023-02-07 12:56:37',NULL),(260,7908,40720,1533,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',18801.61,NULL,NULL,1,'2023-02-07 12:57:34','2023-02-07 12:57:34',NULL),(261,7908,40720,1533,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7600.50,NULL,NULL,1,'2023-02-07 12:58:33','2023-02-07 12:58:33',NULL),(262,7908,40720,1533,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5016.99,NULL,NULL,1,'2023-02-07 12:59:30','2023-02-07 12:59:30',NULL),(263,7908,40720,1533,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11506.71,NULL,NULL,1,'2023-02-07 13:00:40','2023-02-07 13:00:40',NULL),(264,7908,40720,1533,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',11603.51,NULL,NULL,1,'2023-02-07 13:01:41','2023-02-07 13:01:41',NULL),(265,7908,40720,1533,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3802.40,NULL,NULL,1,'2023-02-07 13:02:29','2023-02-07 13:02:29',NULL),(266,7908,40720,1533,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8003.61,NULL,NULL,1,'2023-02-07 13:03:22','2023-02-07 13:03:22',NULL),(267,7908,40720,1533,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',10002.01,NULL,NULL,1,'2023-02-07 13:05:45','2023-02-07 13:05:45',NULL),(268,7908,40720,1533,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',11701.69,NULL,NULL,1,'2023-02-07 13:06:38','2023-02-07 13:06:38',NULL),(269,7908,40720,1533,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',12801.91,NULL,NULL,1,'2023-02-07 13:07:37','2023-02-07 13:07:37',NULL);
INSERT INTO `balance_libro` VALUES (270,7908,40720,1533,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',17107.39,NULL,NULL,1,'2023-02-07 13:08:58','2023-02-07 13:08:58',NULL),(271,7908,40720,1533,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8009.50,NULL,NULL,1,'2023-02-07 18:18:48','2023-02-07 18:18:48',NULL),(272,7908,40720,1533,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9999.99,NULL,NULL,1,'2023-02-07 18:20:07','2023-02-07 18:20:07',NULL),(273,7908,40720,1533,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',11509.00,NULL,NULL,1,'2023-02-07 18:20:51','2023-02-07 18:20:51',NULL),(274,7908,40720,1533,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4001.40,NULL,NULL,1,'2023-02-07 18:22:38','2023-02-07 18:22:38',NULL),(275,7908,40720,1533,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8000.99,NULL,NULL,1,'2023-02-07 18:23:34','2023-02-07 18:23:34',NULL),(276,7908,40720,1533,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8001.60,NULL,NULL,1,'2023-02-07 19:26:18','2023-02-07 19:26:18',NULL),(277,7908,40720,1533,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11511.80,NULL,NULL,1,'2023-02-07 19:27:38','2023-02-07 19:27:38',NULL),(278,7908,40720,1533,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6011.61,NULL,NULL,1,'2023-02-07 19:28:45','2023-02-07 19:28:45',NULL),(279,7908,40720,1533,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',10500.48,NULL,NULL,1,'2023-02-07 19:29:49','2023-02-07 19:29:49',NULL),(280,7908,40720,1533,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10000.30,NULL,NULL,1,'2023-02-07 19:31:01','2023-02-07 19:31:01',NULL),(281,7908,40720,1533,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11000.79,NULL,NULL,1,'2023-02-07 19:31:51','2023-02-07 19:31:51',NULL),(282,7908,40720,1533,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',13010.00,NULL,NULL,1,'2023-02-07 19:32:47','2023-02-07 19:32:47',NULL),(283,7908,40720,1533,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6002.90,NULL,NULL,1,'2023-02-07 19:34:20','2023-02-07 19:34:20',NULL),(284,7908,40720,1533,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',21150.00,NULL,NULL,1,'2023-02-07 19:37:59','2023-02-07 19:37:59',NULL),(285,7908,40720,1533,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',10000.26,NULL,NULL,1,'2023-02-07 19:38:55','2023-02-07 19:38:55',NULL),(286,7908,40720,1533,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',10003.57,NULL,NULL,1,'2023-02-07 19:40:19','2023-02-07 19:40:19',NULL),(287,7908,40720,1533,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8699.96,NULL,NULL,1,'2023-02-07 19:41:30','2023-02-07 19:41:30',NULL),(288,7908,40720,1533,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16001.56,NULL,NULL,1,'2023-02-07 19:42:25','2023-02-07 19:42:25',NULL),(289,7908,40720,1533,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9300.57,NULL,NULL,1,'2023-02-07 19:44:42','2023-02-07 19:44:42',NULL),(290,7908,40720,1533,3,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',12450.00,NULL,NULL,1,'2023-02-07 19:45:37','2023-02-07 19:45:37',NULL);
INSERT INTO `balance_libro` VALUES (291,7908,40720,1533,3,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11000.85,NULL,NULL,1,'2023-02-07 19:46:38','2023-02-07 19:46:38',NULL),(292,7908,40720,1533,3,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',12450.83,NULL,NULL,1,'2023-02-07 19:48:37','2023-02-07 19:48:37',NULL),(293,7908,40720,1533,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3500.01,NULL,NULL,1,'2023-02-08 11:34:14','2023-02-08 11:34:14',NULL),(294,7908,40720,1533,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4004.21,NULL,NULL,1,'2023-02-08 12:08:52','2023-02-08 12:08:52',NULL),(295,7908,40720,1533,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8021.82,NULL,NULL,1,'2023-02-08 12:09:37','2023-02-08 12:09:37',NULL),(296,7908,40720,1533,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',10028.01,NULL,NULL,1,'2023-02-08 12:10:19','2023-02-08 12:10:19',NULL),(297,7908,40720,1533,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9401.00,NULL,NULL,1,'2023-02-08 12:11:05','2023-02-08 12:11:05',NULL),(298,7908,40720,1533,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6021.40,NULL,NULL,1,'2023-02-08 12:12:02','2023-02-08 12:12:02',NULL),(299,7908,40720,1533,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4001.89,NULL,NULL,1,'2023-02-08 12:12:46','2023-02-08 12:12:46',NULL),(300,7908,40720,1533,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4002.77,NULL,NULL,1,'2023-02-08 12:14:03','2023-02-08 12:14:03',NULL),(301,7908,40720,1533,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5001.40,NULL,NULL,1,'2023-02-08 12:15:29','2023-02-08 12:15:29',NULL),(302,7908,40720,1533,15,311,'App\\Models\\PeriodLiquidation',NULL,311,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',445985.01,NULL,NULL,1,'2023-02-08 12:20:37','2023-02-08 12:20:37',NULL),(303,7908,40720,1534,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',116007.54,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(304,7908,40720,1534,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',327322.66,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(305,7908,40720,1534,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',168300.00,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(306,7908,40720,1534,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1752816.74,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:36:21','2023-02-22 12:36:21'),(307,7908,40720,1534,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',10900.98,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:39:04','2023-02-22 12:39:04'),(308,7908,40720,1534,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',67953.29,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:38:39','2023-02-22 12:38:39'),(309,7908,40720,1534,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',28172.46,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:38:16','2023-02-22 12:38:16'),(310,7908,40720,1534,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',60066.55,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:37:55','2023-02-22 12:37:55');
INSERT INTO `balance_libro` VALUES (311,7908,40720,1534,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',41319.61,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:37:20','2023-02-22 12:37:20'),(312,7908,40720,1534,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1108.24,NULL,NULL,1,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(313,7908,40720,1534,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1741000.00,NULL,NULL,1,'2023-02-22 12:36:21','2024-04-23 21:47:11','2024-04-23 21:47:11'),(314,7908,40720,1534,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',41065.08,NULL,NULL,1,'2023-02-22 12:37:20','2023-02-22 12:39:45','2023-02-22 12:39:45'),(315,7908,40720,1534,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',59661.60,NULL,NULL,1,'2023-02-22 12:37:55','2023-02-22 12:40:06','2023-02-22 12:40:06'),(316,7908,40720,1534,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',27998.92,NULL,NULL,1,'2023-02-22 12:38:16','2023-02-22 12:40:26','2023-02-22 12:40:26'),(317,7908,40720,1534,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',68037.37,NULL,NULL,1,'2023-02-22 12:38:39','2023-02-22 12:41:06','2023-02-22 12:41:06'),(318,7908,40720,1534,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',10834.30,NULL,NULL,1,'2023-02-22 12:39:04','2023-02-22 12:39:04',NULL),(319,7908,40720,1534,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',41065.08,NULL,NULL,1,'2023-02-22 12:39:45','2023-02-22 12:39:45',NULL),(320,7908,40720,1534,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',59661.60,NULL,NULL,1,'2023-02-22 12:40:06','2023-02-22 12:40:06',NULL),(321,7908,40720,1534,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',27998.92,NULL,NULL,1,'2023-02-22 12:40:26','2023-02-22 12:40:40','2023-02-22 12:40:40'),(322,7908,40720,1534,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',27998.92,NULL,NULL,1,'2023-02-22 12:40:40','2023-02-22 12:40:53','2023-02-22 12:40:53'),(323,7908,40720,1534,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',27998.92,NULL,NULL,1,'2023-02-22 12:40:53','2023-02-22 12:40:53',NULL),(324,7908,40720,1534,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',68037.37,NULL,NULL,1,'2023-02-22 12:41:06','2023-02-22 12:41:06',NULL),(325,7908,40720,1534,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',131344.00,NULL,NULL,1,'2023-02-22 12:52:52','2023-02-22 12:52:52',NULL),(326,7908,40720,1534,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4000.00,NULL,NULL,1,'2023-02-22 12:57:27','2023-02-22 12:57:27',NULL),(327,7908,40720,1534,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',3002.30,NULL,NULL,1,'2023-02-22 12:58:26','2023-02-22 12:58:26',NULL),(328,7908,40720,1534,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4001.31,NULL,NULL,1,'2023-02-22 12:59:23','2023-02-22 12:59:23',NULL),(329,7908,40720,1534,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4146.29,NULL,NULL,1,'2023-02-22 13:01:04','2023-02-22 13:01:04',NULL),(330,7908,40720,1534,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',8003.40,NULL,NULL,1,'2023-02-22 13:02:12','2023-02-22 13:02:12',NULL);
INSERT INTO `balance_libro` VALUES (331,7908,40720,1534,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4000.81,NULL,NULL,1,'2023-02-22 13:03:23','2023-02-22 13:03:23',NULL),(332,7908,40720,1534,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',40001.68,NULL,NULL,1,'2023-02-22 13:04:40','2023-02-22 13:04:40',NULL),(333,7908,40720,1534,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',7000.40,NULL,NULL,1,'2023-02-22 13:06:06','2023-02-22 13:06:06',NULL),(334,7908,40720,1534,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',575960.00,NULL,NULL,1,'2023-03-20 19:29:30','2023-03-20 19:29:30',NULL),(335,7908,40720,1534,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4500.00,NULL,NULL,1,'2023-03-20 19:29:30','2023-03-20 19:29:30',NULL),(336,7908,40720,1534,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',8000.08,NULL,NULL,1,'2023-03-20 19:43:01','2023-03-20 19:43:01',NULL),(337,7908,40720,1534,3,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5001.11,NULL,NULL,1,'2023-03-20 19:44:41','2023-03-20 19:44:41',NULL),(338,7908,40720,1534,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',10002.29,NULL,NULL,1,'2023-03-20 19:45:43','2023-03-20 19:45:43',NULL),(339,7908,40720,1534,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',4001.01,NULL,NULL,1,'2023-03-21 18:56:20','2023-03-21 18:56:20',NULL),(340,7908,40720,1534,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',6001.58,NULL,NULL,1,'2023-03-21 18:57:13','2023-03-21 18:57:13',NULL),(341,7908,40720,1534,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',10001.00,NULL,NULL,1,'2023-03-21 18:59:33','2023-03-21 18:59:33',NULL),(342,7908,40720,1534,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',2999.99,NULL,NULL,1,'2023-03-21 19:00:45','2023-03-21 19:00:45',NULL),(343,7908,40720,1534,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3999.81,NULL,NULL,1,'2023-03-21 19:02:30','2023-03-21 19:02:30',NULL),(344,7908,40720,1534,15,348,'App\\Models\\PeriodLiquidation',NULL,348,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',486458.47,NULL,NULL,1,'2023-03-21 19:32:43','2024-04-23 21:44:14','2024-04-23 21:44:14'),(345,7908,40720,1535,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3240000.06,NULL,NULL,1,'2023-03-21 20:10:11','2023-03-21 20:10:11',NULL),(346,7908,40720,1535,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',87658.51,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:32:35','2023-03-21 20:32:35'),(347,7908,40720,1535,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',77400.00,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(348,7908,40720,1535,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2100.00,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(349,7908,40720,1535,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2282.82,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(350,7908,40720,1535,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5427.90,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(351,7908,40720,1535,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1380.00,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL);
INSERT INTO `balance_libro` VALUES (352,7908,40720,1535,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',15632.85,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:31:49','2023-03-21 20:31:49'),(353,7908,40720,1535,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',43012.42,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:31:22','2023-03-21 20:31:22'),(354,7908,40720,1535,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1912.01,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(355,7908,40720,1535,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15737.21,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:30:34','2023-03-21 20:30:34'),(356,7908,40720,1535,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15737.21,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:30:11','2023-03-21 20:30:11'),(357,7908,40720,1535,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',8390.00,NULL,NULL,1,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(358,7908,40720,1535,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15630.11,NULL,NULL,1,'2023-03-21 20:30:11','2023-03-21 20:30:11',NULL),(359,7908,40720,1535,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15630.11,NULL,NULL,1,'2023-03-21 20:30:34','2023-03-21 20:30:34',NULL),(360,7908,40720,1535,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',42747.46,NULL,NULL,1,'2023-03-21 20:31:22','2023-03-21 20:31:22',NULL),(361,7908,40720,1535,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',15526.47,NULL,NULL,1,'2023-03-21 20:31:49','2023-03-21 20:32:15','2023-03-21 20:32:15'),(362,7908,40720,1535,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',15526.47,NULL,NULL,1,'2023-03-21 20:32:15','2023-03-21 20:32:15',NULL),(363,7908,40720,1535,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',87118.52,NULL,NULL,1,'2023-03-21 20:32:35','2023-03-21 20:32:35',NULL),(364,7908,40720,1536,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4725002.20,NULL,NULL,1,'2023-04-26 19:40:48','2023-05-23 14:29:13','2023-05-23 14:29:13'),(365,7908,40720,1536,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',19900.00,NULL,NULL,1,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(366,7908,40720,1536,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',10900.00,NULL,NULL,1,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(367,7908,40720,1536,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',9430.00,NULL,NULL,1,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(368,7908,40720,1536,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',15480.00,NULL,NULL,1,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(369,7908,40720,1536,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',6476900.00,NULL,NULL,1,'2023-04-26 19:46:22','2024-04-23 21:31:03','2024-04-23 21:31:03'),(370,7908,40720,1536,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2100100.00,NULL,NULL,1,'2023-04-26 19:46:22','2024-04-23 21:32:07','2024-04-23 21:32:07'),(371,7908,40720,1536,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',7740.00,NULL,NULL,1,'2023-04-26 19:46:34','2023-04-26 19:46:34',NULL);
INSERT INTO `balance_libro` VALUES (372,7908,40720,1535,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3003.79,NULL,NULL,1,'2023-05-19 18:15:54','2023-05-19 18:15:54',NULL),(373,7908,40720,1535,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',10005.60,NULL,NULL,1,'2023-05-19 18:17:04','2023-05-19 18:17:04',NULL),(374,7908,40720,1535,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',10000.59,NULL,NULL,1,'2023-05-19 18:18:34','2023-05-19 18:18:34',NULL),(375,7908,40720,1535,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4004.60,NULL,NULL,1,'2023-05-19 18:19:47','2023-05-19 18:19:47',NULL),(376,7908,40720,1535,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',12999.78,NULL,NULL,1,'2023-05-19 18:21:10','2023-05-19 18:21:10',NULL),(377,7908,40720,1535,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10000.29,NULL,NULL,1,'2023-05-19 18:22:20','2023-05-19 18:22:20',NULL),(378,7908,40720,1535,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',8024.40,NULL,NULL,1,'2023-05-19 18:23:46','2023-05-19 18:23:46',NULL),(379,7908,40720,1535,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',7999.99,NULL,NULL,1,'2023-05-19 18:25:57','2023-05-19 18:25:57',NULL),(380,7908,40720,1535,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4000.01,NULL,NULL,1,'2023-05-19 18:27:41','2023-05-19 18:27:41',NULL),(381,7908,40720,1535,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',10002.80,NULL,NULL,1,'2023-05-19 18:29:43','2023-05-19 18:29:43',NULL),(382,7908,40720,1535,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',8002.11,NULL,NULL,1,'2023-05-19 18:31:29','2023-05-19 18:31:29',NULL),(383,7908,40720,1535,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3314.72,NULL,NULL,1,'2023-05-19 18:33:00','2023-05-19 18:33:00',NULL),(384,7908,40720,1535,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',7999.50,NULL,NULL,1,'2023-05-19 18:34:17','2023-05-19 18:34:17',NULL),(385,7908,40720,1535,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3003.89,NULL,NULL,1,'2023-05-19 18:35:19','2023-05-19 18:35:19',NULL),(386,7908,40720,1535,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',15282.30,NULL,NULL,1,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(387,7908,40720,1535,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',65760.07,NULL,NULL,1,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(388,7908,40720,1535,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',6084.60,NULL,NULL,1,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(389,7908,40720,1535,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',2635.16,NULL,NULL,1,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(390,7908,40720,1535,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',91.82,NULL,NULL,1,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(391,7908,40720,1535,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2843500.00,NULL,NULL,1,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(392,7908,40720,1535,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',65916.46,NULL,NULL,1,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL);
INSERT INTO `balance_libro` VALUES (393,7908,40720,1535,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6000.00,NULL,NULL,1,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(394,7908,40720,1535,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',60800.00,NULL,NULL,1,'2023-05-19 18:53:17','2023-05-19 18:53:17',NULL),(395,7908,40720,1535,15,379,'App\\Models\\PeriodLiquidation',NULL,379,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',600130.89,NULL,NULL,1,'2023-05-23 12:14:28','2023-05-23 12:14:28',NULL),(396,7908,40720,1536,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4725002.20,NULL,NULL,1,'2023-05-23 14:30:35','2023-05-23 14:30:35',NULL),(397,7908,40720,1536,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4725002.20,NULL,NULL,1,'2023-05-23 14:30:46','2023-05-23 14:31:45','2023-05-23 14:31:45'),(398,7908,40720,1536,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.00,NULL,NULL,1,'2023-05-23 14:32:26','2023-05-23 14:32:26',NULL),(399,7908,40720,1536,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2970.00,NULL,NULL,1,'2023-05-23 14:32:26','2023-05-23 14:32:26',NULL),(400,7908,40720,1536,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',10008.10,NULL,NULL,1,'2023-05-23 14:52:31','2023-05-23 14:52:31',NULL),(401,7908,40720,1536,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',10005.53,NULL,NULL,1,'2023-05-23 14:53:25','2023-05-23 14:53:25',NULL),(402,7908,40720,1536,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3999.99,NULL,NULL,1,'2023-05-23 14:54:15','2023-05-23 14:54:15',NULL),(403,7908,40720,1536,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10004.52,NULL,NULL,1,'2023-05-23 14:55:40','2023-05-23 14:55:40',NULL),(404,7908,40720,1536,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',9300.69,NULL,NULL,1,'2023-05-23 14:56:24','2023-05-23 14:56:24',NULL),(405,7908,40720,1536,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4000.11,NULL,NULL,1,'2023-05-23 14:58:08','2023-05-23 14:58:08',NULL),(406,7908,40720,1536,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',6999.85,NULL,NULL,1,'2023-05-23 14:59:22','2023-05-23 14:59:22',NULL),(407,7908,40720,1536,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3199.99,NULL,NULL,1,'2023-05-23 15:01:43','2023-05-23 15:01:43',NULL),(408,7908,40720,1536,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3800.03,NULL,NULL,1,'2023-05-23 15:02:30','2023-05-23 15:02:30',NULL),(409,7908,40720,1536,15,398,'App\\Models\\PeriodLiquidation',NULL,398,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1545670.10,NULL,NULL,1,'2023-05-24 12:19:58','2024-04-23 21:28:37','2024-04-23 21:28:37'),(410,7908,40720,1537,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4500002.10,NULL,NULL,1,'2023-05-24 14:59:49','2023-05-24 14:59:49',NULL),(411,7908,40720,1537,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',87730.55,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:02:53','2023-05-24 15:02:53'),(412,7908,40720,1537,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',5500.00,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(413,7908,40720,1537,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1600.00,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL);
INSERT INTO `balance_libro` VALUES (414,7908,40720,1537,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',424308.00,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(415,7908,40720,1537,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',22700.00,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(416,7908,40720,1537,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',32000.00,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(417,7908,40720,1537,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',48094.52,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:02:29','2023-05-24 15:02:29'),(418,7908,40720,1537,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',39944.96,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:02:02','2023-05-24 15:02:02'),(419,7908,40720,1537,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',26535.45,NULL,NULL,1,'2023-05-24 15:00:12','2023-05-24 15:01:34','2023-05-24 15:01:34'),(420,7908,40720,1537,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',26371.41,NULL,NULL,1,'2023-05-24 15:01:34','2023-06-23 20:24:32','2023-06-23 20:24:32'),(421,7908,40720,1537,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',39698.89,NULL,NULL,1,'2023-05-24 15:02:02','2023-06-23 20:24:58','2023-06-23 20:24:58'),(422,7908,40720,1537,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',47798.25,NULL,NULL,1,'2023-05-24 15:02:29','2023-06-23 20:25:21','2023-06-23 20:25:21'),(423,7908,40720,1537,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',87190.12,NULL,NULL,1,'2023-05-24 15:02:53','2023-06-23 20:25:42','2023-06-23 20:25:42'),(424,7908,40720,1537,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',2492752.47,NULL,NULL,1,'2023-06-22 20:22:55','2023-06-22 20:22:55',NULL),(425,7908,40720,1537,7,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',157911.92,NULL,NULL,1,'2023-06-23 13:50:32','2023-06-23 13:50:32',NULL),(426,7908,40720,1537,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',12650.00,NULL,NULL,1,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(427,7908,40720,1537,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',13489.62,NULL,NULL,1,'2023-06-23 14:51:50','2023-06-23 20:20:32','2023-06-23 20:20:32'),(428,7908,40720,1537,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',53387.95,NULL,NULL,1,'2023-06-23 14:51:50','2023-06-23 20:23:44','2023-06-23 20:23:44'),(429,7908,40720,1537,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',35164.50,NULL,NULL,1,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(430,7908,40720,1537,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6000.00,NULL,NULL,1,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(431,7908,40720,1537,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',16000.01,NULL,NULL,1,'2023-06-23 19:29:51','2023-06-23 19:29:51',NULL),(432,7908,40720,1537,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',9803.31,NULL,NULL,1,'2023-06-23 19:31:49','2023-06-23 19:31:49',NULL),(433,7908,40720,1537,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',12014.37,NULL,NULL,1,'2023-06-23 19:33:03','2023-06-23 19:33:03',NULL);
INSERT INTO `balance_libro` VALUES (434,7908,40720,1537,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',3002.70,NULL,NULL,1,'2023-06-23 19:34:42','2023-06-23 19:34:42',NULL),(435,7908,40720,1537,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',15001.51,NULL,NULL,1,'2023-06-23 19:35:54','2023-06-23 19:35:54',NULL),(436,7908,40720,1537,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',10000.10,NULL,NULL,1,'2023-06-23 19:36:51','2023-06-23 19:36:51',NULL),(437,7908,40720,1537,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',3003.00,NULL,NULL,1,'2023-06-23 19:37:55','2023-06-23 19:37:55',NULL),(438,7908,40720,1537,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',23000.58,NULL,NULL,1,'2023-06-23 19:39:22','2023-06-23 19:39:22',NULL),(439,7908,40720,1537,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',9250.81,NULL,NULL,1,'2023-06-23 19:42:04','2023-06-23 19:42:04',NULL),(440,7908,40720,1537,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',10003.21,NULL,NULL,1,'2023-06-23 19:43:42','2023-06-23 19:43:42',NULL),(441,7908,40720,1537,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',7999.93,NULL,NULL,1,'2023-06-23 19:46:54','2023-06-23 19:46:54',NULL),(442,7908,40720,1537,15,424,'App\\Models\\PeriodLiquidation',NULL,424,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1042896.93,NULL,NULL,1,'2023-06-23 20:02:10','2023-06-23 20:15:39','2023-06-23 20:15:39'),(443,7908,40720,1537,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',13407.10,NULL,NULL,1,'2023-06-23 20:20:32','2023-06-23 20:24:11','2023-06-23 20:24:11'),(444,7908,40720,1537,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',53057.90,NULL,NULL,1,'2023-06-23 20:23:44','2023-06-23 20:28:24','2023-06-23 20:28:24'),(445,7908,40720,1537,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',13407.10,NULL,NULL,1,'2023-06-23 20:24:11','2023-06-23 20:24:11',NULL),(446,7908,40720,1537,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',26371.41,NULL,NULL,1,'2023-06-23 20:24:32','2023-06-23 20:24:32',NULL),(447,7908,40720,1537,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',39698.89,NULL,NULL,1,'2023-06-23 20:24:58','2023-06-23 20:24:58',NULL),(448,7908,40720,1537,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',47798.25,NULL,NULL,1,'2023-06-23 20:25:21','2023-06-23 20:25:21',NULL),(449,7908,40720,1537,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',87190.12,NULL,NULL,1,'2023-06-23 20:25:42','2023-06-23 20:26:12','2023-06-23 20:26:12'),(450,7908,40720,1537,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',87190.12,NULL,NULL,1,'2023-06-23 20:26:12','2023-06-23 20:26:12',NULL),(451,7908,40720,1537,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',53057.90,NULL,NULL,1,'2023-06-23 20:28:24','2023-06-23 20:28:24',NULL),(452,7908,40720,1537,15,424,'App\\Models\\PeriodLiquidation',NULL,424,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1042896.93,NULL,NULL,1,'2023-06-26 11:56:52','2023-06-26 11:56:52',NULL),(453,7908,40720,1538,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',159000.00,NULL,NULL,1,'2023-06-26 12:58:30','2023-06-26 12:58:30',NULL);
INSERT INTO `balance_libro` VALUES (454,7908,40720,1538,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',11200.00,NULL,NULL,1,'2023-06-26 12:58:30','2023-06-26 12:58:30',NULL),(455,7908,40720,1538,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',3600.00,NULL,NULL,1,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(456,7908,40720,1538,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',260542.50,NULL,NULL,1,'2023-06-26 12:58:31','2023-06-26 12:59:26','2023-06-26 12:59:26'),(457,7908,40720,1538,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',99800.00,NULL,NULL,1,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(458,7908,40720,1538,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',254300.00,NULL,NULL,1,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(459,7908,40720,1538,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',258937.52,NULL,NULL,1,'2023-06-26 12:59:26','2023-06-26 12:59:26',NULL),(460,7908,40720,1538,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',5310000.30,NULL,NULL,1,'2023-06-26 13:10:18','2023-06-26 13:10:18',NULL),(461,7908,40720,1539,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',5850002.73,NULL,NULL,1,'2023-07-03 19:47:37','2023-07-03 19:47:37',NULL),(462,7908,40720,1539,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',20500001.50,NULL,NULL,1,'2023-07-24 16:17:09','2023-07-24 16:17:09',NULL),(463,7908,40720,1538,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',90404.22,NULL,NULL,1,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(464,7908,40720,1538,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6000.00,NULL,NULL,1,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(465,7908,40720,1538,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1573000.00,NULL,NULL,1,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(466,7908,40720,1538,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2420000.00,NULL,NULL,1,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(467,7908,40720,1539,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',317000.00,NULL,NULL,1,'2023-07-31 18:57:40','2023-07-31 18:57:40',NULL),(468,7908,40720,1539,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',1573000.00,NULL,NULL,1,'2023-07-31 18:57:40','2023-08-09 19:07:05','2023-08-09 19:07:05'),(469,7908,40720,1539,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',2420000.00,NULL,NULL,1,'2023-07-31 18:57:40','2023-08-09 19:06:40','2023-08-09 19:06:40'),(470,7908,40720,1539,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',1799.00,NULL,NULL,1,'2023-07-31 18:57:41','2023-07-31 18:57:41',NULL),(471,7908,40720,1539,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',43520.00,NULL,NULL,1,'2023-07-31 18:57:41','2023-07-31 18:57:41',NULL),(472,7908,40720,1539,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',2711961.44,NULL,NULL,1,'2023-07-31 18:57:41','2023-07-31 19:06:27','2023-07-31 19:06:27'),(473,7908,40720,1539,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',459256.40,NULL,NULL,1,'2023-07-31 18:57:41','2023-07-31 19:06:02','2023-07-31 19:06:02');
INSERT INTO `balance_libro` VALUES (474,7908,40720,1539,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',234777.12,NULL,NULL,1,'2023-07-31 18:57:41','2023-07-31 19:05:47','2023-07-31 19:05:47'),(475,7908,40720,1539,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',340800.00,NULL,NULL,1,'2023-07-31 18:57:41','2023-07-31 19:05:30','2023-07-31 19:05:30'),(476,7908,40720,1539,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',41831780.00,NULL,NULL,1,'2023-07-31 18:57:41','2023-07-31 19:05:15','2023-07-31 19:05:15'),(477,7908,40720,1539,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',457892.19,NULL,NULL,1,'2023-07-31 18:57:41','2023-07-31 19:04:52','2023-07-31 19:04:52'),(478,7908,40720,1539,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',455073.67,NULL,NULL,1,'2023-07-31 19:04:52','2023-08-09 19:10:31','2023-08-09 19:10:31'),(479,7908,40720,1539,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',41549768.00,NULL,NULL,1,'2023-07-31 19:05:15','2023-08-09 19:34:56','2023-08-09 19:34:56'),(480,7908,40720,1539,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',338701.89,NULL,NULL,1,'2023-07-31 19:05:30','2023-08-09 19:35:13','2023-08-09 19:35:13'),(481,7908,40720,1539,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',233331.56,NULL,NULL,1,'2023-07-31 19:05:47','2023-08-09 19:35:35','2023-08-09 19:35:35'),(482,7908,40720,1539,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',456426.08,NULL,NULL,1,'2023-07-31 19:06:02','2023-08-09 19:35:54','2023-08-09 19:35:54'),(483,7908,40720,1539,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',2695254.43,NULL,NULL,1,'2023-07-31 19:06:27','2023-08-09 19:36:14','2023-08-09 19:36:14'),(484,7908,40720,1538,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',10000.20,NULL,NULL,1,'2023-08-02 19:12:51','2023-08-02 19:12:51',NULL),(485,7908,40720,1538,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',8006.61,NULL,NULL,1,'2023-08-02 19:14:10','2023-08-02 19:14:10',NULL),(486,7908,40720,1538,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',6701.31,NULL,NULL,1,'2023-08-02 19:15:04','2023-08-02 19:15:04',NULL),(487,7908,40720,1538,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',12000.71,NULL,NULL,1,'2023-08-02 19:15:54','2023-08-02 19:15:54',NULL),(488,7908,40720,1538,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',10008.61,NULL,NULL,1,'2023-08-02 19:16:45','2023-08-02 19:16:45',NULL),(489,7908,40720,1538,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',7001.30,NULL,NULL,1,'2023-08-02 19:17:28','2023-08-02 19:17:28',NULL),(490,7908,40720,1538,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',7002.21,NULL,NULL,1,'2023-08-02 19:18:19','2023-08-02 19:18:19',NULL),(491,7908,40720,1538,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',10004.11,NULL,NULL,1,'2023-08-02 19:18:58','2023-08-02 19:18:58',NULL),(492,7908,40720,1538,3,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',10000.51,NULL,NULL,1,'2023-08-02 19:19:52','2023-08-02 19:19:52',NULL),(493,7908,40720,1538,3,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',8002.51,NULL,NULL,1,'2023-08-02 19:20:39','2023-08-02 19:20:39',NULL);
INSERT INTO `balance_libro` VALUES (494,7908,40720,1538,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',12003.51,NULL,NULL,1,'2023-08-02 19:21:18','2023-08-02 19:21:18',NULL),(495,7908,40720,1538,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',9999.59,NULL,NULL,1,'2023-08-02 19:22:21','2023-08-02 19:22:21',NULL),(496,7908,40720,1538,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10022.30,NULL,NULL,1,'2023-08-02 19:23:17','2023-08-02 19:23:17',NULL),(497,7908,40720,1538,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',8000.40,NULL,NULL,1,'2023-08-02 19:24:05','2023-08-02 19:24:05',NULL),(498,7908,40720,1538,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',4014.61,NULL,NULL,1,'2023-08-02 19:25:00','2023-08-02 19:25:00',NULL),(499,7908,40720,1538,3,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',15003.83,NULL,NULL,1,'2023-08-02 19:26:22','2023-08-02 19:26:22',NULL),(500,7908,40720,1538,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',20007.01,NULL,NULL,1,'2023-08-02 19:27:10','2023-08-02 19:27:10',NULL),(501,7908,40720,1538,3,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',5000.00,NULL,NULL,1,'2023-08-02 19:28:08','2023-08-02 19:28:08',NULL),(502,7908,40720,1538,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',10001.09,NULL,NULL,1,'2023-08-02 19:29:03','2023-08-02 19:29:03',NULL),(503,7908,40720,1538,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',19999.70,NULL,NULL,1,'2023-08-02 19:29:45','2023-08-02 19:29:45',NULL),(504,7908,40720,1538,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',23007.01,NULL,NULL,1,'2023-08-02 19:30:41','2023-08-02 19:30:41',NULL),(505,7908,40720,1538,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',20094.50,NULL,NULL,1,'2023-08-02 19:31:34','2023-08-02 19:31:34',NULL),(506,7908,40720,1538,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',8000.64,NULL,NULL,1,'2023-08-02 19:32:41','2023-08-02 19:32:41',NULL),(507,7908,40720,1538,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',7000.06,NULL,NULL,1,'2023-08-02 19:33:52','2023-08-02 19:33:52',NULL),(508,7908,40720,1538,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',3004.41,NULL,NULL,1,'2023-08-02 19:36:01','2023-08-02 19:36:01',NULL),(509,7908,40720,1538,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',2000.00,NULL,NULL,1,'2023-08-02 19:40:19','2023-08-02 19:40:19',NULL),(510,7908,40720,1538,15,482,'App\\Models\\PeriodLiquidation',NULL,482,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',921570.30,NULL,NULL,1,'2023-08-02 19:42:05','2023-08-02 19:44:25','2023-08-02 19:44:25'),(511,7908,40720,1538,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',308089.25,NULL,NULL,1,'2023-08-02 19:50:18','2023-08-02 19:50:18',NULL),(512,7908,40720,1538,7,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',19516.97,NULL,NULL,1,'2023-08-02 19:57:04','2023-08-02 19:57:04',NULL),(513,7908,40720,1538,15,485,'App\\Models\\PeriodLiquidation',NULL,485,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',950845.75,NULL,NULL,1,'2023-08-02 19:58:14','2023-08-02 19:58:14',NULL),(514,7908,40720,1540,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',10125004.73,NULL,NULL,1,'2023-08-04 13:55:20','2023-08-04 13:55:20',NULL);
INSERT INTO `balance_libro` VALUES (515,7908,40720,1539,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',3993000.00,NULL,NULL,1,'2023-08-09 18:39:22','2023-08-09 19:04:06','2023-08-09 19:04:06'),(516,7908,40720,1539,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',329811.44,NULL,NULL,1,'2023-08-09 19:17:11','2023-08-09 19:43:19','2023-08-09 19:43:19'),(517,7908,40720,1539,7,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',20893.03,NULL,NULL,1,'2023-08-09 19:20:20','2023-08-09 19:20:20',NULL),(518,7908,40720,1539,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',1573000.00,NULL,NULL,1,'2023-08-09 19:25:30','2023-08-09 19:42:04','2023-08-09 19:42:04'),(519,7908,40720,1539,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',2420000.00,NULL,NULL,1,'2023-08-09 19:25:30','2023-08-09 19:41:46','2023-08-09 19:41:46'),(520,7908,40720,1539,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',3993000.00,NULL,NULL,1,'2023-08-09 19:25:30','2023-08-09 19:36:36','2023-08-09 19:36:36'),(521,7908,40720,1539,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',457892.19,NULL,NULL,1,'2023-08-09 19:25:30','2023-08-09 19:34:35','2023-08-09 19:34:35'),(522,7908,40720,1539,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6000.00,NULL,NULL,1,'2023-08-09 19:25:30','2023-08-09 19:25:30',NULL),(523,7908,40720,1539,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',455073.67,NULL,NULL,1,'2023-08-09 19:34:35','2023-08-09 19:34:35',NULL),(524,7908,40720,1539,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',41549768.00,NULL,NULL,1,'2023-08-09 19:34:56','2024-04-23 20:32:18','2024-04-23 20:32:18'),(525,7908,40720,1539,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',338701.89,NULL,NULL,1,'2023-08-09 19:35:13','2023-08-09 19:35:13',NULL),(526,7908,40720,1539,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',233331.56,NULL,NULL,1,'2023-08-09 19:35:35','2023-08-09 19:35:35',NULL),(527,7908,40720,1539,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',456426.08,NULL,NULL,1,'2023-08-09 19:35:54','2023-08-09 19:35:54',NULL),(528,7908,40720,1539,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',2695254.43,NULL,NULL,1,'2023-08-09 19:36:14','2023-08-09 19:36:14',NULL),(529,7908,40720,1539,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',329811.44,NULL,NULL,1,'2023-08-09 19:43:19','2023-08-09 19:43:19',NULL),(530,7908,40720,1539,3,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',28003.19,NULL,NULL,1,'2023-08-15 20:47:04','2023-08-15 20:47:04',NULL),(531,7908,40720,1539,3,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',15003.40,NULL,NULL,1,'2023-08-15 20:48:13','2023-08-15 20:48:13',NULL),(532,7908,40720,1539,3,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',4999.92,NULL,NULL,1,'2023-08-15 20:49:36','2023-08-15 20:49:36',NULL),(533,7908,40720,1539,3,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',25010.60,NULL,NULL,1,'2023-08-15 20:50:53','2023-08-15 20:50:53',NULL),(534,7908,40720,1539,3,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',4001.71,NULL,NULL,1,'2023-08-15 20:51:51','2023-08-15 20:51:51',NULL);
INSERT INTO `balance_libro` VALUES (535,7908,40720,1539,3,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',8002.21,NULL,NULL,1,'2023-08-15 20:53:49','2023-08-15 20:53:49',NULL),(536,7908,40720,1539,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',15007.70,NULL,NULL,1,'2023-08-15 20:54:42','2023-08-15 20:54:42',NULL),(537,7908,40720,1539,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',4999.92,NULL,NULL,1,'2023-08-15 20:57:04','2023-08-15 20:57:04',NULL),(538,7908,40720,1539,3,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',5015.31,NULL,NULL,1,'2023-08-15 20:59:01','2023-08-15 20:59:01',NULL),(539,7908,40720,1539,3,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',8001.91,NULL,NULL,1,'2023-08-15 21:00:03','2023-08-15 21:00:03',NULL),(540,7908,40720,1539,3,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',22000.61,NULL,NULL,1,'2023-08-15 21:01:07','2023-08-15 21:01:07',NULL),(541,7908,40720,1539,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',12003.51,NULL,NULL,1,'2023-08-15 21:02:09','2023-08-15 21:02:09',NULL),(542,7908,40720,1539,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-02','2023-07-02',4500.04,NULL,NULL,1,'2023-08-15 21:03:48','2023-08-15 21:03:48',NULL),(543,7908,40720,1539,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',10000.14,NULL,NULL,1,'2023-08-15 21:04:57','2023-08-15 21:04:57',NULL),(544,7908,40720,1539,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',8000.00,NULL,NULL,1,'2023-08-15 21:07:08','2023-08-15 21:07:08',NULL),(545,7908,40720,1539,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',4002.03,NULL,NULL,1,'2023-08-15 21:10:07','2023-08-15 21:10:07',NULL),(546,7908,40720,1539,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',10000.51,NULL,NULL,1,'2023-08-15 21:11:31','2023-08-15 21:11:31',NULL),(547,7908,40720,1539,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',10004.40,NULL,NULL,1,'2023-08-15 21:12:24','2023-08-15 21:12:24',NULL),(548,7908,40720,1539,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',4000.03,NULL,NULL,1,'2023-08-15 21:13:46','2023-08-15 21:13:46',NULL),(549,7908,40720,1539,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-09','2023-07-09',4000.00,NULL,NULL,1,'2023-08-15 21:15:50','2023-08-15 21:15:50',NULL),(550,7908,40720,1539,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',950.00,NULL,NULL,1,'2023-08-15 21:24:56','2023-08-15 21:24:56',NULL),(551,7908,40720,1539,15,545,'App\\Models\\PeriodLiquidation',NULL,545,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4791966.93,NULL,NULL,1,'2023-08-22 12:35:27','2024-04-23 20:28:36','2024-04-23 20:28:36'),(552,7908,40720,1540,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',34046.23,NULL,NULL,1,'2023-08-24 13:14:21','2023-08-24 13:14:21',NULL),(553,7908,40720,1540,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',92951.65,NULL,NULL,1,'2023-08-24 13:14:21','2023-08-24 13:15:39','2023-08-24 13:15:39'),(554,7908,40720,1540,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',46950.00,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(555,7908,40720,1540,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',1806.68,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL);
INSERT INTO `balance_libro` VALUES (556,7908,40720,1540,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',21270.71,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(557,7908,40720,1540,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',3600.00,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(558,7908,40720,1540,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',906000.00,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(559,7908,40720,1540,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',57987.70,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(560,7908,40720,1540,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',3706.04,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(561,7908,40720,1540,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',10130.12,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(562,7908,40720,1540,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',11507579.20,NULL,NULL,1,'2023-08-24 13:14:22','2023-08-24 13:15:14','2023-08-24 13:15:14'),(563,7908,40720,1540,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',11430000.01,NULL,NULL,1,'2023-08-24 13:15:14','2024-08-07 11:14:22','2024-08-07 11:14:22'),(564,7908,40720,1540,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',92379.05,NULL,NULL,1,'2023-08-24 13:15:39','2023-08-24 13:15:39',NULL),(565,7908,40720,1540,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',992205.12,NULL,NULL,1,'2023-08-24 13:25:37','2023-08-28 21:14:42','2023-08-28 21:14:42'),(566,7908,40720,1541,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',14500004.75,NULL,NULL,1,'2023-09-01 19:32:56','2023-09-01 19:32:56',NULL),(567,7908,40720,1540,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',10274.10,NULL,NULL,1,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(568,7908,40720,1540,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',1727880.00,NULL,NULL,1,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(569,7908,40720,1540,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6000.00,NULL,NULL,1,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(570,7908,40720,1540,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',992205.12,NULL,NULL,1,'2023-09-21 13:13:39','2023-09-21 13:13:39',NULL),(571,7908,40720,1541,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',7080.00,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(572,7908,40720,1541,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',42624.68,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:06:34','2023-09-21 19:06:34'),(573,7908,40720,1541,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',20032.72,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:06:01','2023-09-21 19:06:01'),(574,7908,40720,1541,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',6728400.00,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:05:35','2023-09-21 19:05:35'),(575,7908,40720,1541,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',4748.46,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL);
INSERT INTO `balance_libro` VALUES (576,7908,40720,1541,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',6050.00,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(577,7908,40720,1541,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',7476.98,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(578,7908,40720,1541,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',36300.00,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(579,7908,40720,1541,3,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',1581.78,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(580,7908,40720,1541,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',9878.22,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(581,7908,40720,1541,3,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',21907.94,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(582,7908,40720,1541,3,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',9449.56,NULL,NULL,1,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(583,7908,40720,1541,3,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',3125.01,NULL,NULL,1,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(584,7908,40720,1541,3,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',3390.00,NULL,NULL,1,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(585,7908,40720,1541,3,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',5250.00,NULL,NULL,1,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(586,7908,40720,1541,3,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',4500.00,NULL,NULL,1,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(587,7908,40720,1541,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',6683040.00,NULL,NULL,1,'2023-09-21 19:05:35','2023-09-21 19:06:57','2023-09-21 19:06:57'),(588,7908,40720,1541,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',19910.19,NULL,NULL,1,'2023-09-21 19:06:01','2023-09-21 19:07:18','2023-09-21 19:07:18'),(589,7908,40720,1541,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',42362.10,NULL,NULL,1,'2023-09-21 19:06:34','2023-09-21 19:07:37','2023-09-21 19:07:37'),(590,7908,40720,1541,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',6683040.00,NULL,NULL,1,'2023-09-21 19:06:57','2023-10-09 19:10:33','2023-10-09 19:10:33'),(591,7908,40720,1541,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',19910.19,NULL,NULL,1,'2023-09-21 19:07:18','2023-09-21 19:07:18',NULL),(592,7908,40720,1541,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',42362.10,NULL,NULL,1,'2023-09-21 19:07:37','2023-10-09 19:11:00','2023-10-09 19:11:00'),(593,7908,40720,1541,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',1182044.16,NULL,NULL,1,'2023-09-26 18:22:07','2023-09-26 18:34:08','2023-09-26 18:34:08'),(594,7908,40720,1541,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',799257.03,NULL,NULL,1,'2023-09-26 18:22:07','2023-09-26 18:29:20','2023-09-26 18:29:20'),(595,7908,40720,1541,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',824542.40,NULL,NULL,1,'2023-09-26 18:22:07','2023-09-26 18:28:14','2023-09-26 18:28:14');
INSERT INTO `balance_libro` VALUES (596,7908,40720,1541,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',836904.97,NULL,NULL,1,'2023-09-26 18:22:08','2023-09-26 18:27:39','2023-09-26 18:27:39'),(597,7908,40720,1541,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',837471.25,NULL,NULL,1,'2023-09-26 18:22:08','2023-09-26 18:26:50','2023-09-26 18:26:50'),(598,7908,40720,1541,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',28000.00,NULL,NULL,1,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(599,7908,40720,1541,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',10000.39,NULL,NULL,1,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(600,7908,40720,1541,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',4500.00,NULL,NULL,1,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(601,7908,40720,1541,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',1281684.95,NULL,NULL,1,'2023-09-26 18:22:08','2023-09-26 18:32:03','2023-09-26 18:32:03'),(602,7908,40720,1541,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',606545.64,NULL,NULL,1,'2023-09-26 18:22:08','2023-10-09 19:10:05','2023-10-09 19:10:05'),(603,7908,40720,1541,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',20029.86,NULL,NULL,1,'2023-09-26 18:22:08','2023-10-09 19:09:26','2023-10-09 19:09:26'),(604,7908,40720,1541,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',4500.00,NULL,NULL,1,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(605,7908,40720,1541,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',837471.25,NULL,NULL,1,'2023-09-26 18:26:50','2024-11-13 12:35:08','2024-11-13 12:35:08'),(606,7908,40720,1541,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',836904.97,NULL,NULL,1,'2023-09-26 18:27:39','2024-11-13 12:35:58','2024-11-13 12:35:58'),(607,7908,40720,1541,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',824542.40,NULL,NULL,1,'2023-09-26 18:28:14','2024-11-13 12:36:26','2024-11-13 12:36:26'),(608,7908,40720,1541,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',799257.03,NULL,NULL,1,'2023-09-26 18:29:20','2024-11-13 12:37:05','2024-11-13 12:37:05'),(609,7908,40720,1541,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',1281684.95,NULL,NULL,1,'2023-09-26 18:32:03','2024-11-13 12:32:06','2024-11-13 12:32:06'),(610,7908,40720,1541,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',1182044.16,NULL,NULL,1,'2023-09-26 18:34:08','2024-11-13 12:30:19','2024-11-13 12:30:19'),(611,7908,40720,1540,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',5000.02,NULL,NULL,1,'2023-09-26 18:37:00','2023-09-26 18:37:00',NULL),(612,7908,40720,1540,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',10003.32,NULL,NULL,1,'2023-09-26 18:38:30','2023-09-26 18:38:30',NULL),(613,7908,40720,1540,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',30003.24,NULL,NULL,1,'2023-09-26 18:39:41','2023-09-26 18:39:41',NULL),(614,7908,40720,1540,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',10000.29,NULL,NULL,1,'2023-09-26 18:41:04','2023-09-26 18:41:04',NULL),(615,7908,40720,1540,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',13604.32,NULL,NULL,1,'2023-09-26 18:42:07','2023-09-26 18:42:07',NULL);
INSERT INTO `balance_libro` VALUES (616,7908,40720,1540,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',15012.52,NULL,NULL,1,'2023-09-26 18:43:28','2023-09-26 18:43:28',NULL),(617,7908,40720,1540,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',12001.01,NULL,NULL,1,'2023-09-26 18:44:27','2023-09-26 18:44:27',NULL),(618,7908,40720,1540,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',5001.20,NULL,NULL,1,'2023-09-26 18:49:17','2023-09-26 18:49:17',NULL),(619,7908,40720,1540,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',7002.40,NULL,NULL,1,'2023-09-26 18:50:19','2023-09-26 18:50:19',NULL),(620,7908,40720,1540,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',10002.60,NULL,NULL,1,'2023-09-26 18:51:36','2023-09-26 18:51:36',NULL),(621,7908,40720,1540,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',3466.55,NULL,NULL,1,'2023-09-26 18:54:56','2023-09-26 18:54:56',NULL),(622,7908,40720,1540,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',22000.00,NULL,NULL,1,'2023-09-26 18:58:40','2023-09-26 18:58:40',NULL),(623,7908,40720,1540,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',24000.01,NULL,NULL,1,'2023-09-26 19:00:01','2023-09-26 19:00:01',NULL),(624,7908,40720,1540,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',15000.38,NULL,NULL,1,'2023-09-27 19:07:25','2023-09-27 19:07:25',NULL),(625,7908,40720,1540,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',10005.87,NULL,NULL,1,'2023-09-27 19:08:45','2023-09-27 19:08:45',NULL),(626,7908,40720,1540,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',25001.79,NULL,NULL,1,'2023-09-27 19:09:35','2023-09-27 19:09:35',NULL),(627,7908,40720,1540,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',10003.67,NULL,NULL,1,'2023-09-27 19:10:40','2023-09-27 19:10:40',NULL),(628,7908,40720,1540,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',10001.39,NULL,NULL,1,'2023-09-27 19:13:19','2023-09-27 19:13:19',NULL),(629,7908,40720,1540,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',24006.10,NULL,NULL,1,'2023-09-27 19:14:34','2023-09-27 19:14:34',NULL),(630,7908,40720,1540,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',20004.24,NULL,NULL,1,'2023-09-27 19:15:33','2023-09-27 19:15:33',NULL),(631,7908,40720,1540,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',4003.46,NULL,NULL,1,'2023-09-27 19:16:35','2023-09-27 19:16:35',NULL),(632,7908,40720,1540,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',14000.56,NULL,NULL,1,'2023-09-27 19:17:24','2023-09-27 19:17:24',NULL),(633,7908,40720,1540,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',40000.19,NULL,NULL,1,'2023-09-27 19:18:38','2023-09-27 19:18:38',NULL),(634,7908,40720,1540,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',25000.02,NULL,NULL,1,'2023-09-27 19:20:07','2023-09-27 19:20:07',NULL),(635,7908,40720,1540,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',15005.27,NULL,NULL,1,'2023-09-27 19:21:11','2023-09-27 19:21:11',NULL),(636,7908,40720,1540,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',20004.25,NULL,NULL,1,'2023-09-27 19:22:27','2023-09-27 19:22:27',NULL);
INSERT INTO `balance_libro` VALUES (637,7908,40720,1540,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',10000.05,NULL,NULL,1,'2023-09-27 19:24:21','2023-09-27 19:24:21',NULL),(638,7908,40720,1540,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',25001.59,NULL,NULL,1,'2023-09-27 19:41:02','2023-09-27 19:41:02',NULL),(639,7908,40720,1540,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',15005.11,NULL,NULL,1,'2023-09-27 19:42:09','2023-09-27 19:42:09',NULL),(640,7908,40720,1540,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',4999.92,NULL,NULL,1,'2023-09-27 19:43:28','2023-09-27 19:43:28',NULL),(641,7908,40720,1542,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',21000003.75,NULL,NULL,1,'2023-10-04 19:53:40','2023-10-04 19:53:40',NULL),(642,7908,40720,1541,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',11998.29,NULL,NULL,1,'2023-10-09 11:45:26','2023-10-09 11:45:26',NULL),(643,7908,40720,1541,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',5064.28,NULL,NULL,1,'2023-10-09 11:47:16','2023-10-09 11:47:16',NULL),(644,7908,40720,1541,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',259000.00,NULL,NULL,1,'2023-10-09 11:49:51','2023-10-09 11:49:51',NULL),(645,7908,40720,1541,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',8000.16,NULL,NULL,1,'2023-10-09 11:51:12','2023-10-09 11:51:12',NULL),(646,7908,40720,1541,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',5001.59,NULL,NULL,1,'2023-10-09 11:53:22','2023-10-09 11:53:22',NULL),(647,7908,40720,1541,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',30000.38,NULL,NULL,1,'2023-10-09 11:54:17','2023-10-09 11:54:17',NULL),(648,7908,40720,1541,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',15015.40,NULL,NULL,1,'2023-10-09 11:56:57','2023-10-09 11:56:57',NULL),(649,7908,40720,1541,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',15000.38,NULL,NULL,1,'2023-10-09 11:58:10','2023-10-09 11:58:10',NULL),(650,7908,40720,1541,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',20003.46,NULL,NULL,1,'2023-10-09 11:59:02','2023-10-09 11:59:02',NULL),(651,7908,40720,1541,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',20004.88,NULL,NULL,1,'2023-10-09 11:59:56','2023-10-09 11:59:56',NULL),(652,7908,40720,1541,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',10005.87,NULL,NULL,1,'2023-10-09 12:00:54','2023-10-09 12:00:54',NULL),(653,7908,40720,1541,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',15006.02,NULL,NULL,1,'2023-10-09 12:03:13','2023-10-09 12:03:13',NULL),(654,7908,40720,1541,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',30202.60,NULL,NULL,1,'2023-10-09 12:04:53','2023-10-09 12:04:53',NULL),(655,7908,40720,1541,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10001.20,NULL,NULL,1,'2023-10-09 12:07:08','2023-10-09 12:07:08',NULL),(656,7908,40720,1541,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',5000.60,NULL,NULL,1,'2023-10-09 12:08:44','2023-10-09 12:08:44',NULL),(657,7908,40720,1541,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',10000.39,NULL,NULL,1,'2023-10-09 12:12:42','2023-10-09 12:12:42',NULL);
INSERT INTO `balance_libro` VALUES (658,7908,40720,1541,3,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',15011.22,NULL,NULL,1,'2023-10-09 12:15:04','2023-10-09 12:15:04',NULL),(659,7908,40720,1541,3,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',5000.20,NULL,NULL,1,'2023-10-09 12:16:17','2023-10-09 12:16:17',NULL),(660,7908,40720,1541,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',15007.81,NULL,NULL,1,'2023-10-09 12:17:51','2023-10-09 12:17:51',NULL),(661,7908,40720,1541,3,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',15003.98,NULL,NULL,1,'2023-10-09 12:19:31','2023-10-09 12:19:31',NULL),(662,7908,40720,1541,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',16003.08,NULL,NULL,1,'2023-10-09 12:20:55','2023-10-09 12:20:55',NULL),(663,7908,40720,1541,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',13501.31,NULL,NULL,1,'2023-10-09 12:21:47','2023-10-09 12:21:47',NULL),(664,7908,40720,1541,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',15003.39,NULL,NULL,1,'2023-10-09 12:22:45','2023-10-09 12:22:45',NULL),(665,7908,40720,1540,15,632,'App\\Models\\PeriodLiquidation',NULL,632,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1856467.90,NULL,NULL,1,'2023-10-09 18:18:46','2024-08-07 11:12:10','2024-08-07 11:12:10'),(666,7908,40720,1541,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',42612.50,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 19:09:08','2023-10-09 19:09:08'),(667,7908,40720,1541,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',303233.00,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 19:08:48','2023-10-09 19:08:48'),(668,7908,40720,1541,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',20027.00,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 19:08:23','2023-10-09 19:08:23'),(669,7908,40720,1541,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',136360.00,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 19:08:00','2023-10-09 19:08:00'),(670,7908,40720,1541,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',4500.00,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(671,7908,40720,1541,3,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',1608383.30,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(672,7908,40720,1541,3,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',4500.00,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(673,7908,40720,1541,3,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',6000.00,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(674,7908,40720,1541,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',2299000.00,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(675,7908,40720,1541,3,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',14565.25,NULL,NULL,1,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(676,7908,40720,1541,15,634,'App\\Models\\PeriodLiquidation',NULL,634,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2653169.30,NULL,NULL,1,'2023-10-09 18:58:30','2023-10-09 18:59:24','2023-10-09 18:59:24'),(677,7908,40720,1541,15,635,'App\\Models\\PeriodLiquidation',NULL,635,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2653169.30,NULL,NULL,1,'2023-10-09 19:00:26','2023-10-09 19:06:34','2023-10-09 19:06:34');
INSERT INTO `balance_libro` VALUES (678,7908,40720,1541,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',135520.00,NULL,NULL,1,'2023-10-09 19:08:00','2023-10-09 19:08:00',NULL),(679,7908,40720,1541,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',19904.50,NULL,NULL,1,'2023-10-09 19:08:23','2023-10-09 19:08:23',NULL),(680,7908,40720,1541,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',301362.60,NULL,NULL,1,'2023-10-09 19:08:48','2023-10-09 19:08:48',NULL),(681,7908,40720,1541,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',42350.00,NULL,NULL,1,'2023-10-09 19:09:08','2023-10-09 19:09:08',NULL),(682,7908,40720,1541,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',19907.34,NULL,NULL,1,'2023-10-09 19:09:26','2023-10-09 19:09:26',NULL),(683,7908,40720,1541,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',602811.30,NULL,NULL,1,'2023-10-09 19:10:05','2023-10-09 19:10:05',NULL),(684,7908,40720,1541,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',6683040.00,NULL,NULL,1,'2023-10-09 19:10:33','2023-10-09 19:10:33',NULL),(685,7908,40720,1541,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',42362.10,NULL,NULL,1,'2023-10-09 19:11:00','2023-10-09 19:11:00',NULL),(686,7908,40720,1541,15,644,'App\\Models\\PeriodLiquidation',NULL,644,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2653169.30,NULL,NULL,1,'2023-10-09 19:12:00','2024-11-13 12:27:28','2024-11-13 12:27:28'),(687,7908,40720,1542,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',2299000.00,NULL,NULL,1,'2023-10-18 11:56:37','2023-10-19 11:39:16','2023-10-19 11:39:16'),(688,7908,40720,1542,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',3300.00,NULL,NULL,1,'2023-10-18 11:56:37','2023-10-18 11:56:37',NULL),(689,7908,40720,1542,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',4500.00,NULL,NULL,1,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(690,7908,40720,1542,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',68199.48,NULL,NULL,1,'2023-10-18 11:56:38','2023-11-24 18:51:36','2023-11-24 18:51:36'),(691,7908,40720,1542,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',4462.50,NULL,NULL,1,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(692,7908,40720,1542,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',4500.00,NULL,NULL,1,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(693,7908,40720,1542,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',232000.00,NULL,NULL,1,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(694,7908,40720,1542,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',10000.00,NULL,NULL,1,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(695,7908,40720,1542,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',50267.22,NULL,NULL,1,'2023-10-18 11:56:38','2023-11-24 18:54:22','2023-11-24 18:54:22'),(696,7908,40720,1542,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',3725396.60,NULL,NULL,1,'2023-10-18 11:56:38','2023-11-24 18:52:56','2023-11-24 18:52:56'),(697,7908,40720,1542,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',42624.68,NULL,NULL,1,'2023-10-18 11:56:38','2023-11-24 18:50:55','2023-11-24 18:50:55');
INSERT INTO `balance_libro` VALUES (698,7908,40720,1542,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',2299000.00,NULL,NULL,1,'2023-10-19 11:39:16','2023-10-19 11:39:16',NULL),(699,7908,40720,1542,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',6000.00,NULL,NULL,1,'2023-10-24 17:20:14','2023-10-24 17:20:14',NULL),(700,7908,40720,1542,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',46000.00,NULL,NULL,1,'2023-10-24 17:20:14','2023-10-24 17:20:14',NULL),(701,7908,40720,1542,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',88662.99,NULL,NULL,1,'2023-10-24 17:20:15','2023-11-24 18:53:48','2023-11-24 18:53:48'),(702,7908,40720,1542,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',168786.14,NULL,NULL,1,'2023-10-24 17:20:15','2023-11-24 18:50:24','2023-11-24 18:50:24'),(703,7908,40720,1542,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1243762.63,NULL,NULL,1,'2023-10-30 18:06:53','2024-11-13 12:46:42','2024-11-13 12:46:42'),(704,7908,40720,1542,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1247663.67,NULL,NULL,1,'2023-10-30 18:06:53','2024-11-13 12:46:18','2024-11-13 12:46:18'),(705,7908,40720,1542,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1153507.52,NULL,NULL,1,'2023-10-30 18:06:53','2024-11-13 12:45:55','2024-11-13 12:45:55'),(706,7908,40720,1542,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1258408.47,NULL,NULL,1,'2023-10-30 18:06:53','2024-11-13 12:45:34','2024-11-13 12:45:34'),(707,7908,40720,1542,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1268686.38,NULL,NULL,1,'2023-10-30 18:06:53','2024-11-13 12:45:17','2024-11-13 12:45:17'),(708,7908,40720,1542,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1236134.79,NULL,NULL,1,'2023-10-30 18:06:53','2024-11-13 12:44:57','2024-11-13 12:44:57'),(709,7908,40720,1542,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1234693.68,NULL,NULL,1,'2023-10-30 18:06:53','2024-11-13 12:44:34','2024-11-13 12:44:34'),(710,7908,40720,1542,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',2299000.00,NULL,NULL,1,'2023-10-30 18:41:39','2023-10-30 18:41:39',NULL),(711,7908,40720,1542,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',6337980.00,NULL,NULL,1,'2023-11-01 19:01:37','2023-11-01 19:01:37',NULL),(712,7908,40720,1543,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',12600002.25,NULL,NULL,1,'2023-11-07 19:20:11','2023-11-07 19:20:11',NULL),(713,7908,40720,1543,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',85200.00,NULL,NULL,1,'2023-11-22 18:33:25','2023-11-22 18:33:25',NULL),(714,7908,40720,1543,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',803673.50,NULL,NULL,1,'2023-11-22 18:33:26','2023-11-22 18:37:14','2023-11-22 18:37:14'),(715,7908,40720,1543,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',492606.47,NULL,NULL,1,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(716,7908,40720,1543,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',3100.00,NULL,NULL,1,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(717,7908,40720,1543,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',475310.00,NULL,NULL,1,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL);
INSERT INTO `balance_libro` VALUES (718,7908,40720,1543,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',230879.04,NULL,NULL,1,'2023-11-22 18:33:26','2023-11-22 18:36:31','2023-11-22 18:36:31'),(719,7908,40720,1543,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',55289.19,NULL,NULL,1,'2023-11-22 18:33:26','2023-11-22 18:35:57','2023-11-22 18:35:57'),(720,7908,40720,1543,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',54950.19,NULL,NULL,1,'2023-11-22 18:35:57','2023-11-22 18:35:57',NULL),(721,7908,40720,1543,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',229455.17,NULL,NULL,1,'2023-11-22 18:36:31','2023-11-22 18:36:31',NULL),(722,7908,40720,1543,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',798721.00,NULL,NULL,1,'2023-11-22 18:37:14','2023-11-22 18:37:14',NULL),(723,7908,40720,1542,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',10002.21,NULL,NULL,1,'2023-11-22 18:51:30','2023-11-22 18:51:30',NULL),(724,7908,40720,1542,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',13033.01,NULL,NULL,1,'2023-11-22 18:53:19','2023-11-22 18:53:19',NULL),(725,7908,40720,1542,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',15000.28,NULL,NULL,1,'2023-11-22 18:55:09','2023-11-22 18:55:09',NULL),(726,7908,40720,1542,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',16001.80,NULL,NULL,1,'2023-11-22 18:57:07','2023-11-22 18:57:07',NULL),(727,7908,40720,1542,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',12002.98,NULL,NULL,1,'2023-11-22 18:59:34','2023-11-22 18:59:34',NULL),(728,7908,40720,1542,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',18013.71,NULL,NULL,1,'2023-11-22 19:02:46','2023-11-22 19:02:46',NULL),(729,7908,40720,1542,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',15041.30,NULL,NULL,1,'2023-11-23 19:25:20','2023-11-23 19:25:20',NULL),(730,7908,40720,1542,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',25494.82,NULL,NULL,1,'2023-11-23 19:26:05','2023-11-23 19:26:05',NULL),(731,7908,40720,1542,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',11900.30,NULL,NULL,1,'2023-11-23 19:26:48','2023-11-23 19:26:48',NULL),(732,7908,40720,1542,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',7003.21,NULL,NULL,1,'2023-11-23 19:27:54','2023-11-23 19:27:54',NULL),(733,7908,40720,1542,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',81001.32,NULL,NULL,1,'2023-11-23 19:29:00','2023-11-23 19:29:00',NULL),(734,7908,40720,1542,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',40424.00,NULL,NULL,1,'2023-11-23 19:30:17','2023-11-23 19:30:17',NULL),(735,7908,40720,1542,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',20002.05,NULL,NULL,1,'2023-11-23 19:32:43','2023-11-23 19:32:43',NULL),(736,7908,40720,1542,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',20002.05,NULL,NULL,1,'2023-11-23 19:36:30','2023-11-23 19:36:30',NULL),(737,7908,40720,1542,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',18009.47,NULL,NULL,1,'2023-11-23 19:37:21','2023-11-23 19:37:21',NULL),(738,7908,40720,1542,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',33003.54,NULL,NULL,1,'2023-11-23 19:38:14','2023-11-23 19:38:14',NULL);
INSERT INTO `balance_libro` VALUES (739,7908,40720,1542,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',39999.99,NULL,NULL,1,'2023-11-23 19:39:21','2023-11-23 19:39:21',NULL),(740,7908,40720,1542,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',50000.01,NULL,NULL,1,'2023-11-23 19:40:24','2023-11-23 19:40:24',NULL),(741,7908,40720,1542,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',6000.01,NULL,NULL,1,'2023-11-23 19:41:21','2023-11-23 19:41:21',NULL),(742,7908,40720,1542,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',10000.05,NULL,NULL,1,'2023-11-23 19:43:45','2023-11-23 19:43:45',NULL),(743,7908,40720,1542,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',10000.05,NULL,NULL,1,'2023-11-23 19:44:33','2023-11-23 19:44:33',NULL),(744,7908,40720,1542,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',8300.01,NULL,NULL,1,'2023-11-23 19:46:35','2023-11-23 19:46:35',NULL),(745,7908,40720,1542,15,690,'App\\Models\\PeriodLiquidation',NULL,690,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4043628.75,NULL,NULL,1,'2023-11-23 19:48:45','2023-11-24 18:49:36','2023-11-24 18:49:36'),(746,7908,40720,1542,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',167746.39,NULL,NULL,1,'2023-11-24 18:50:24','2023-11-24 18:50:24',NULL),(747,7908,40720,1542,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',42362.10,NULL,NULL,1,'2023-11-24 18:50:55','2023-11-24 18:50:55',NULL),(748,7908,40720,1542,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',67779.36,NULL,NULL,1,'2023-11-24 18:51:36','2023-11-24 18:51:36',NULL),(749,7908,40720,1542,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',3702447.54,NULL,NULL,1,'2023-11-24 18:52:56','2023-11-24 18:52:56',NULL),(750,7908,40720,1542,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',88119.31,NULL,NULL,1,'2023-11-24 18:53:48','2023-11-24 18:53:48',NULL),(751,7908,40720,1542,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',49957.12,NULL,NULL,1,'2023-11-24 18:54:22','2023-11-24 18:54:22',NULL),(752,7908,40720,1542,15,697,'App\\Models\\PeriodLiquidation',NULL,697,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4043628.75,NULL,NULL,1,'2023-11-24 18:56:41','2024-11-13 12:42:57','2024-11-13 12:42:57'),(753,7908,40720,1543,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',124597.08,NULL,NULL,1,'2023-11-30 19:59:44','2023-11-30 19:59:44',NULL),(754,7908,40720,1543,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',885272.47,NULL,NULL,1,'2023-11-30 19:59:44','2024-11-13 12:53:25','2024-11-13 12:53:25'),(755,7908,40720,1543,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',871647.70,NULL,NULL,1,'2023-11-30 19:59:44','2024-11-13 12:53:10','2024-11-13 12:53:10'),(756,7908,40720,1543,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',949473.69,NULL,NULL,1,'2023-11-30 19:59:45','2024-11-13 12:52:53','2024-11-13 12:52:53'),(757,7908,40720,1543,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',1085591.43,NULL,NULL,1,'2023-11-30 19:59:45','2024-11-13 12:51:11','2024-11-13 12:51:11'),(758,7908,40720,1543,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',748953.70,NULL,NULL,1,'2023-11-30 19:59:45','2024-11-13 12:52:37','2024-11-13 12:52:37');
INSERT INTO `balance_libro` VALUES (759,7908,40720,1543,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',770455.40,NULL,NULL,1,'2023-11-30 19:59:45','2024-11-13 12:52:19','2024-11-13 12:52:19'),(760,7908,40720,1543,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1097417.97,NULL,NULL,1,'2023-11-30 19:59:45','2024-11-13 12:50:58','2024-11-13 12:50:58'),(761,7908,40720,1543,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',1110354.08,NULL,NULL,1,'2023-11-30 19:59:45','2024-11-13 12:50:38','2024-11-13 12:50:38'),(762,7908,40720,1543,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',1123690.70,NULL,NULL,1,'2023-11-30 19:59:45','2024-11-13 12:50:19','2024-11-13 12:50:19'),(763,7908,40720,1543,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',24749.99,NULL,NULL,1,'2023-11-30 19:59:45','2023-11-30 19:59:45',NULL),(764,7908,40720,1543,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',30004.00,NULL,NULL,1,'2023-12-04 11:59:15','2023-12-04 11:59:15',NULL),(765,7908,40720,1543,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',20003.28,NULL,NULL,1,'2023-12-04 12:00:17','2023-12-04 12:00:17',NULL),(766,7908,40720,1543,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',50002.80,NULL,NULL,1,'2023-12-04 12:01:23','2023-12-04 12:01:23',NULL),(767,7908,40720,1543,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',15000.99,NULL,NULL,1,'2023-12-04 12:02:13','2023-12-04 12:02:13',NULL),(768,7908,40720,1543,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',19299.98,NULL,NULL,1,'2023-12-04 12:03:20','2023-12-04 12:03:20',NULL),(769,7908,40720,1543,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',33012.60,NULL,NULL,1,'2023-12-04 12:04:43','2023-12-04 12:04:43',NULL),(770,7908,40720,1543,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',60054.21,NULL,NULL,1,'2023-12-04 12:05:53','2023-12-04 12:05:53',NULL),(771,7908,40720,1543,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',80023.62,NULL,NULL,1,'2023-12-04 12:07:48','2023-12-04 12:07:48',NULL),(772,7908,40720,1543,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',73010.21,NULL,NULL,1,'2023-12-04 12:08:59','2023-12-04 12:08:59',NULL),(773,7908,40720,1543,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',13703.20,NULL,NULL,1,'2023-12-04 12:09:48','2023-12-04 12:09:48',NULL),(774,7908,40720,1543,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',42721.82,NULL,NULL,1,'2023-12-04 12:10:44','2023-12-04 12:10:44',NULL),(775,7908,40720,1543,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',7001.61,NULL,NULL,1,'2023-12-04 12:13:12','2023-12-04 12:13:12',NULL),(776,7908,40720,1543,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',50024.98,NULL,NULL,1,'2023-12-04 12:14:12','2023-12-04 12:14:12',NULL),(777,7908,40720,1543,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',27702.00,NULL,NULL,1,'2023-12-04 12:15:10','2023-12-04 12:15:10',NULL),(778,7908,40720,1543,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',50009.11,NULL,NULL,1,'2023-12-04 12:16:21','2023-12-04 12:16:21',NULL),(779,7908,40720,1543,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',18000.14,NULL,NULL,1,'2023-12-04 12:17:34','2023-12-04 12:17:34',NULL);
INSERT INTO `balance_libro` VALUES (780,7908,40720,1543,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',15000.12,NULL,NULL,1,'2023-12-04 12:18:36','2023-12-04 12:18:36',NULL),(781,7908,40720,1543,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',10000.48,NULL,NULL,1,'2023-12-04 12:20:11','2023-12-04 12:20:11',NULL),(782,7908,40720,1543,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13800.44,NULL,NULL,1,'2023-12-04 12:22:28','2023-12-04 12:22:28',NULL),(783,7908,40720,1544,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',12465004.37,NULL,NULL,1,'2023-12-04 19:47:40','2023-12-04 19:47:40',NULL),(784,7908,40720,1543,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',15300.00,NULL,NULL,1,'2023-12-13 11:25:45','2023-12-13 11:25:45',NULL),(785,7908,40720,1543,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',12613.79,NULL,NULL,1,'2023-12-13 11:27:48','2023-12-13 11:27:48',NULL),(786,7908,40720,1543,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',1700.00,NULL,NULL,1,'2023-12-13 11:29:45','2023-12-13 11:29:45',NULL),(787,7908,40720,1543,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',9500.00,NULL,NULL,1,'2023-12-13 11:32:52','2023-12-13 11:32:52',NULL),(788,7908,40720,1543,15,728,'App\\Models\\PeriodLiquidation',NULL,728,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2186777.25,NULL,NULL,1,'2023-12-13 19:41:59','2024-11-13 12:48:55','2024-11-13 12:48:55'),(789,7908,40720,1544,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',2952903.19,NULL,NULL,1,'2023-12-15 11:53:02','2023-12-15 11:54:40','2023-12-15 11:54:40'),(790,7908,40720,1544,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',43000.00,NULL,NULL,1,'2023-12-15 11:53:02','2023-12-15 11:53:02',NULL),(791,7908,40720,1544,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',143969.62,NULL,NULL,1,'2023-12-15 11:53:02','2023-12-15 11:55:31','2023-12-15 11:55:31'),(792,7908,40720,1544,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',6750.00,NULL,NULL,1,'2023-12-15 11:53:02','2023-12-15 11:53:02',NULL),(793,7908,40720,1544,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',2932995.98,NULL,NULL,1,'2023-12-15 11:54:40','2023-12-15 11:54:40',NULL),(794,7908,40720,1544,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',143082.74,NULL,NULL,1,'2023-12-15 11:55:31','2023-12-15 11:55:31',NULL),(795,7908,40720,1544,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',20470.13,NULL,NULL,1,'2023-12-26 19:43:59','2023-12-26 19:43:59',NULL),(796,7908,40720,1544,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',18000.00,NULL,NULL,1,'2023-12-26 19:43:59','2023-12-26 19:43:59',NULL),(797,7908,40720,1544,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',54578.09,NULL,NULL,1,'2023-12-26 19:43:59','2024-02-07 12:38:07','2024-02-07 12:38:07'),(798,7908,40720,1544,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',78352.94,NULL,NULL,1,'2023-12-26 19:43:59','2024-02-07 12:37:42','2024-02-07 12:37:42'),(799,7908,40720,1544,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',331366.98,NULL,NULL,1,'2023-12-26 19:43:59','2024-02-07 12:37:14','2024-02-07 12:37:14');
INSERT INTO `balance_libro` VALUES (800,7908,40720,1544,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',945000.00,NULL,NULL,1,'2023-12-26 19:44:00','2023-12-26 19:44:00',NULL),(801,7908,40720,1544,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',18100.07,NULL,NULL,1,'2023-12-26 19:44:00','2024-02-07 12:33:52','2024-02-07 12:33:52'),(802,7908,40720,1544,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',670171.66,NULL,NULL,1,'2023-12-27 18:26:03','2023-12-27 18:29:28','2023-12-27 18:29:28'),(803,7908,40720,1544,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',1729810.13,NULL,NULL,1,'2023-12-27 18:26:04','2023-12-27 18:29:00','2023-12-27 18:29:00'),(804,7908,40720,1544,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',246905.35,NULL,NULL,1,'2023-12-27 18:26:04','2023-12-27 18:28:30','2023-12-27 18:28:30'),(805,7908,40720,1544,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',560822.23,NULL,NULL,1,'2023-12-27 18:26:04','2023-12-27 18:28:03','2023-12-27 18:28:03'),(806,7908,40720,1544,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',557373.07,NULL,NULL,1,'2023-12-27 18:28:03','2024-02-07 12:18:57','2024-02-07 12:18:57'),(807,7908,40720,1544,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',245384.37,NULL,NULL,1,'2023-12-27 18:28:30','2023-12-27 18:28:30',NULL),(808,7908,40720,1544,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',1719151.22,NULL,NULL,1,'2023-12-27 18:29:00','2023-12-27 18:29:00',NULL),(809,7908,40720,1544,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',666043.29,NULL,NULL,1,'2023-12-27 18:29:28','2023-12-27 18:29:28',NULL),(810,7908,40720,1544,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',1419600.00,NULL,NULL,1,'2023-12-28 21:33:47','2023-12-28 21:33:47',NULL),(811,7908,40720,1544,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',20000.00,NULL,NULL,1,'2023-12-28 21:33:47','2023-12-28 21:33:47',NULL),(812,7908,40720,1548,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',13050004.27,NULL,NULL,1,'2024-01-03 12:10:49','2024-01-03 12:10:49',NULL),(813,7908,40720,1548,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',28000005.00,NULL,NULL,1,'2024-01-18 10:04:12','2024-01-18 10:04:12',NULL),(814,7908,40720,1548,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',440000.00,NULL,NULL,1,'2024-01-27 20:59:21','2024-01-27 20:59:21',NULL),(815,7908,40720,1548,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',18000.00,NULL,NULL,1,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(816,7908,40720,1548,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',36000.00,NULL,NULL,1,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(817,7908,40720,1548,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',17000.00,NULL,NULL,1,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(818,7908,40720,1548,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',498000.00,NULL,NULL,1,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(819,7908,40720,1548,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',24959000.00,NULL,NULL,1,'2024-01-27 20:59:22','2024-04-23 22:13:12','2024-04-23 22:13:12');
INSERT INTO `balance_libro` VALUES (820,7908,40720,1548,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',650000.00,NULL,NULL,1,'2024-01-27 20:59:22','2024-04-23 22:12:12','2024-04-23 22:12:12'),(821,7908,40720,1548,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',122646.27,NULL,NULL,1,'2024-01-27 20:59:22','2024-01-27 21:00:30','2024-01-27 21:00:30'),(822,7908,40720,1548,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',88000.00,NULL,NULL,1,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(823,7908,40720,1548,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',55510.00,NULL,NULL,1,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(824,7908,40720,1548,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',119679.02,NULL,NULL,1,'2024-01-27 21:00:30','2024-01-27 21:00:45','2024-01-27 21:00:45'),(825,7908,40720,1548,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',119679.02,NULL,NULL,1,'2024-01-27 21:00:45','2024-01-27 21:00:45',NULL),(826,7908,40720,1548,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',19998.64,NULL,NULL,1,'2024-01-29 11:36:42','2024-01-29 11:36:42',NULL),(827,7908,40720,1548,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',44899.99,NULL,NULL,1,'2024-01-29 11:39:01','2024-01-29 11:39:01',NULL),(828,7908,40720,1548,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',49864.98,NULL,NULL,1,'2024-01-29 11:42:12','2024-01-29 11:42:12',NULL),(829,7908,40720,1548,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',52019.01,NULL,NULL,1,'2024-01-29 11:43:48','2024-01-29 11:43:48',NULL),(830,7908,40720,1548,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',57020.03,NULL,NULL,1,'2024-01-29 11:45:22','2024-01-29 11:45:22',NULL),(831,7908,40720,1548,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',47143.04,NULL,NULL,1,'2024-01-29 11:46:55','2024-01-29 11:46:55',NULL),(832,7908,40720,1548,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',29996.01,NULL,NULL,1,'2024-01-29 11:48:27','2024-01-29 11:48:27',NULL),(833,7908,40720,1548,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',19398.98,NULL,NULL,1,'2024-01-29 11:49:15','2024-01-29 11:49:15',NULL),(834,7908,40720,1548,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',99998.96,NULL,NULL,1,'2024-01-29 11:50:57','2024-01-29 11:50:57',NULL),(835,7908,40720,1548,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',57173.04,NULL,NULL,1,'2024-01-29 11:52:07','2024-01-29 11:52:07',NULL),(836,7908,40720,1548,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',117303.93,NULL,NULL,1,'2024-01-29 11:53:28','2024-01-29 11:53:28',NULL),(837,7908,40720,1548,3,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',34608.04,NULL,NULL,1,'2024-01-29 11:54:30','2024-01-29 11:54:30',NULL),(838,7908,40720,1548,3,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',34498.99,NULL,NULL,1,'2024-01-29 11:55:23','2024-01-29 11:55:23',NULL),(839,7908,40720,1548,3,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',17504.99,NULL,NULL,1,'2024-01-29 11:56:05','2024-01-29 11:56:05',NULL),(840,7908,40720,1548,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',42006.97,NULL,NULL,1,'2024-01-29 11:57:43','2024-01-29 11:57:43',NULL);
INSERT INTO `balance_libro` VALUES (841,7908,40720,1548,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',100016.00,NULL,NULL,1,'2024-01-29 11:58:48','2024-01-29 11:58:48',NULL),(842,7908,40720,1548,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',30022.96,NULL,NULL,1,'2024-01-29 11:59:37','2024-01-29 11:59:37',NULL),(843,7908,40720,1548,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',30004.02,NULL,NULL,1,'2024-01-29 12:00:26','2024-01-29 12:00:26',NULL),(844,7908,40720,1548,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',100018.96,NULL,NULL,1,'2024-01-29 12:01:27','2024-01-29 12:01:27',NULL),(845,7908,40720,1548,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',40014.00,NULL,NULL,1,'2024-01-29 12:02:18','2024-01-29 12:02:18',NULL),(846,7908,40720,1548,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',100023.99,NULL,NULL,1,'2024-01-29 12:03:22','2024-01-29 12:03:22',NULL),(847,7908,40720,1548,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',15000.97,NULL,NULL,1,'2024-01-29 12:04:19','2024-01-29 12:04:19',NULL),(848,7908,40720,1548,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',40036.02,NULL,NULL,1,'2024-01-29 12:05:04','2024-01-29 12:05:04',NULL),(849,7908,40720,1548,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',100043.96,NULL,NULL,1,'2024-01-29 12:07:40','2024-01-29 12:07:40',NULL),(850,7908,40720,1548,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',55038.01,NULL,NULL,1,'2024-01-29 12:08:24','2024-01-29 12:08:24',NULL),(851,7908,40720,1548,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',40006.95,NULL,NULL,1,'2024-01-29 12:09:39','2024-01-29 12:09:39',NULL),(852,7908,40720,1548,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',360940.05,NULL,NULL,1,'2024-01-30 11:13:19','2024-01-30 11:21:35','2024-01-30 11:21:35'),(853,7908,40720,1548,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',288752.04,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:20:54','2024-01-30 11:20:54'),(854,7908,40720,1548,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',26253.18,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:20:17','2024-01-30 11:20:17'),(855,7908,40720,1548,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',168438.69,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:19:54','2024-01-30 11:19:54'),(856,7908,40720,1548,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',112292.46,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:19:24','2024-01-30 11:19:24'),(857,7908,40720,1548,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',85619.30,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:18:59','2024-01-30 11:18:59'),(858,7908,40720,1548,3,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',6118.61,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:16:15','2024-01-30 11:16:15'),(859,7908,40720,1548,3,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',565472.75,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:15:47','2024-01-30 11:15:47'),(860,7908,40720,1548,3,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',360940.05,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:15:16','2024-01-30 11:15:16');
INSERT INTO `balance_libro` VALUES (861,7908,40720,1548,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',161224.83,NULL,NULL,1,'2024-01-30 11:13:20','2024-01-30 11:14:50','2024-01-30 11:14:50'),(862,7908,40720,1548,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',160226.75,NULL,NULL,1,'2024-01-30 11:14:50','2024-01-30 11:14:50',NULL),(863,7908,40720,1548,3,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',358716.60,NULL,NULL,1,'2024-01-30 11:15:16','2024-01-30 11:15:16',NULL),(864,7908,40720,1548,3,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',561989.34,NULL,NULL,1,'2024-01-30 11:15:47','2024-01-30 11:15:47',NULL),(865,7908,40720,1548,3,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',6078.25,NULL,NULL,1,'2024-01-30 11:16:15','2024-01-30 11:16:15',NULL),(866,7908,40720,1548,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',85095.55,NULL,NULL,1,'2024-01-30 11:18:59','2024-01-30 11:18:59',NULL),(867,7908,40720,1548,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',111600.72,NULL,NULL,1,'2024-01-30 11:19:24','2024-01-30 11:19:24',NULL),(868,7908,40720,1548,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',167401.08,NULL,NULL,1,'2024-01-30 11:19:54','2024-01-30 11:19:54',NULL),(869,7908,40720,1548,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',26086.67,NULL,NULL,1,'2024-01-30 11:20:17','2024-01-30 11:20:17',NULL),(870,7908,40720,1548,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',286973.28,NULL,NULL,1,'2024-01-30 11:20:54','2024-01-30 11:20:54',NULL),(871,7908,40720,1548,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',358716.60,NULL,NULL,1,'2024-01-30 11:21:35','2024-01-30 11:21:35',NULL),(872,7908,40720,1549,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',12600002.25,NULL,NULL,1,'2024-02-01 16:25:33','2024-02-01 16:25:33',NULL),(873,7908,40720,1548,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1355079.00,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:14:18','2024-11-13 13:14:18'),(874,7908,40720,1548,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1336688.21,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:13:54','2024-11-13 13:13:54'),(875,7908,40720,1548,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1344381.39,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:04:26','2024-11-13 13:04:26'),(876,7908,40720,1548,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1379545.20,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:13:41','2024-11-13 13:13:41'),(877,7908,40720,1548,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1331661.87,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:13:27','2024-11-13 13:13:27'),(878,7908,40720,1548,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1343992.98,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:04:12','2024-11-13 13:04:12'),(879,7908,40720,1548,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1279022.03,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:13:14','2024-11-13 13:13:14'),(880,7908,40720,1548,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1346517.04,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:12:59','2024-11-13 13:12:59');
INSERT INTO `balance_libro` VALUES (881,7908,40720,1548,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1355622.29,NULL,NULL,1,'2024-02-05 18:04:57','2024-11-13 13:12:45','2024-11-13 13:12:45'),(882,7908,40720,1548,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1399223.43,NULL,NULL,1,'2024-02-05 18:04:58','2024-11-13 13:12:31','2024-11-13 13:12:31'),(883,7908,40720,1548,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1345463.13,NULL,NULL,1,'2024-02-05 18:04:58','2024-11-13 13:12:17','2024-11-13 13:12:17'),(884,7908,40720,1548,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1366622.40,NULL,NULL,1,'2024-02-05 18:04:58','2024-11-13 13:03:56','2024-11-13 13:03:56'),(885,7908,40720,1548,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1295222.31,NULL,NULL,1,'2024-02-05 18:04:58','2024-02-15 19:23:31','2024-02-15 19:23:31'),(886,7908,40720,1548,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1349362.96,NULL,NULL,1,'2024-02-05 18:04:58','2024-11-13 13:11:51','2024-11-13 13:11:51'),(887,7908,40720,1548,3,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1338262.42,NULL,NULL,1,'2024-02-05 18:04:58','2024-11-13 13:11:26','2024-11-13 13:11:26'),(888,7908,40720,1544,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',9500.00,NULL,NULL,1,'2024-02-05 18:16:59','2024-02-05 18:16:59',NULL),(889,7908,40720,1544,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',1058227.68,NULL,NULL,1,'2024-02-05 18:16:59','2024-11-13 12:57:24','2024-11-13 12:57:24'),(890,7908,40720,1544,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',976926.17,NULL,NULL,1,'2024-02-05 18:16:59','2024-11-13 12:57:07','2024-11-13 12:57:07'),(891,7908,40720,1544,3,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',1022452.42,NULL,NULL,1,'2024-02-05 18:16:59','2024-11-13 12:56:46','2024-11-13 12:56:46'),(892,7908,40720,1544,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',975727.06,NULL,NULL,1,'2024-02-05 18:16:59','2024-11-13 12:56:24','2024-11-13 12:56:24'),(893,7908,40720,1544,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',30006.80,NULL,NULL,1,'2024-02-05 19:07:54','2024-02-05 19:07:54',NULL),(894,7908,40720,1544,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',15003.12,NULL,NULL,1,'2024-02-05 19:18:14','2024-02-05 19:18:14',NULL),(895,7908,40720,1544,3,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',20008.43,NULL,NULL,1,'2024-02-05 19:19:05','2024-02-05 19:19:05',NULL),(896,7908,40720,1544,3,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',10004.18,NULL,NULL,1,'2024-02-05 19:19:48','2024-02-05 19:19:48',NULL),(897,7908,40720,1544,3,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',20005.76,NULL,NULL,1,'2024-02-05 19:20:40','2024-02-05 19:20:40',NULL),(898,7908,40720,1544,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',41754.90,NULL,NULL,1,'2024-02-05 19:21:33','2024-02-05 19:21:33',NULL),(899,7908,40720,1544,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',15407.97,NULL,NULL,1,'2024-02-05 19:22:34','2024-02-05 19:22:34',NULL),(900,7908,40720,1544,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',10000.51,NULL,NULL,1,'2024-02-05 19:23:21','2024-02-05 19:23:21',NULL);
INSERT INTO `balance_libro` VALUES (901,7908,40720,1544,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',18003.24,NULL,NULL,1,'2024-02-05 19:24:16','2024-02-05 19:24:16',NULL),(902,7908,40720,1544,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',10007.60,NULL,NULL,1,'2024-02-05 19:24:59','2024-02-05 19:24:59',NULL),(903,7908,40720,1544,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',15004.01,NULL,NULL,1,'2024-02-05 19:26:02','2024-02-05 19:26:02',NULL),(904,7908,40720,1544,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',50010.76,NULL,NULL,1,'2024-02-05 19:26:55','2024-02-05 19:26:55',NULL),(905,7908,40720,1544,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',45104.18,NULL,NULL,1,'2024-02-05 19:28:16','2024-02-05 19:28:16',NULL),(906,7908,40720,1544,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',50000.89,NULL,NULL,1,'2024-02-05 19:29:01','2024-02-05 19:29:01',NULL),(907,7908,40720,1544,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',39999.80,NULL,NULL,1,'2024-02-05 19:29:58','2024-02-05 19:29:58',NULL),(908,7908,40720,1544,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',50001.23,NULL,NULL,1,'2024-02-05 19:30:54','2024-02-05 19:30:54',NULL),(909,7908,40720,1544,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',45030.09,NULL,NULL,1,'2024-02-05 19:31:50','2024-02-05 19:31:50',NULL),(910,7908,40720,1544,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',15000.04,NULL,NULL,1,'2024-02-05 19:39:01','2024-02-05 19:39:01',NULL),(911,7908,40720,1544,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',17000.03,NULL,NULL,1,'2024-02-05 19:40:26','2024-02-05 19:40:26',NULL),(912,7908,40720,1544,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',10000.05,NULL,NULL,1,'2024-02-05 19:42:27','2024-02-05 19:42:27',NULL),(913,7908,40720,1544,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',557373.07,NULL,NULL,1,'2024-02-07 12:18:57','2024-02-07 12:18:57',NULL),(914,7908,40720,1544,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',18100.06,NULL,NULL,1,'2024-02-07 12:33:52','2024-02-07 12:33:52',NULL),(915,7908,40720,1544,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',329325.70,NULL,NULL,1,'2024-02-07 12:37:14','2024-02-07 12:37:14',NULL),(916,7908,40720,1544,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',77875.84,NULL,NULL,1,'2024-02-07 12:37:42','2024-02-07 12:37:42',NULL),(917,7908,40720,1544,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',54241.88,NULL,NULL,1,'2024-02-07 12:38:07','2024-02-07 12:38:07',NULL),(918,7908,40720,1544,15,829,'App\\Models\\PeriodLiquidation',NULL,829,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2163347.87,NULL,NULL,1,'2024-02-07 12:48:47','2024-11-13 12:55:12','2024-11-13 12:55:12'),(919,7908,40720,1548,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',9500.00,NULL,NULL,1,'2024-02-15 11:58:18','2024-02-15 11:58:18',NULL),(920,7908,40720,1548,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',19998.02,NULL,NULL,1,'2024-02-15 12:04:21','2024-02-15 12:04:21',NULL),(921,7908,40720,1548,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',100164.92,NULL,NULL,1,'2024-02-15 12:05:51','2024-02-15 12:05:51',NULL);
INSERT INTO `balance_libro` VALUES (922,7908,40720,1548,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',34501.99,NULL,NULL,1,'2024-02-15 12:07:16','2024-02-15 12:07:16',NULL),(923,7908,40720,1548,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',43275.00,NULL,NULL,1,'2024-02-15 12:08:25','2024-02-15 12:08:25',NULL),(924,7908,40720,1548,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',50035.99,NULL,NULL,1,'2024-02-15 12:13:20','2024-02-15 12:13:20',NULL),(925,7908,40720,1548,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-28','2024-01-28',49997.04,NULL,NULL,1,'2024-02-15 12:14:57','2024-02-15 12:14:57',NULL),(926,7908,40720,1548,3,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',32009.62,NULL,NULL,1,'2024-02-15 12:16:35','2024-02-15 12:16:35',NULL),(927,7908,40720,1548,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',10800.00,NULL,NULL,1,'2024-02-15 12:17:43','2024-02-15 12:17:43',NULL),(928,7908,40720,1548,15,840,'App\\Models\\PeriodLiquidation',NULL,840,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',7124381.78,NULL,NULL,1,'2024-02-15 12:21:39','2024-02-15 19:13:32','2024-02-15 19:13:32'),(929,7908,40720,1548,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',1295222.32,NULL,NULL,1,'2024-02-15 19:23:31','2024-11-13 13:03:30','2024-11-13 13:03:30'),(930,7908,40720,1548,15,840,'App\\Models\\PeriodLiquidation',NULL,840,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',7124381.78,NULL,NULL,1,'2024-02-15 19:30:17','2024-04-23 22:07:43','2024-04-23 22:07:43'),(931,7908,40720,1549,3,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',240292.00,NULL,NULL,1,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(932,7908,40720,1549,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',19000.00,NULL,NULL,1,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(933,7908,40720,1549,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',22000.00,NULL,NULL,1,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(934,7908,40720,1549,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',98978.83,NULL,NULL,1,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(935,7908,40720,1549,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',35000.00,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(936,7908,40720,1549,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',26028.04,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(937,7908,40720,1549,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',16974.81,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(938,7908,40720,1549,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',3838.52,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(939,7908,40720,1549,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',8112.00,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(940,7908,40720,1549,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',99999.99,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(941,7908,40720,1549,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',53339.63,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:04:21','2024-02-26 19:04:21');
INSERT INTO `balance_libro` VALUES (942,7908,40720,1549,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',197173.00,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(943,7908,40720,1549,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',486203.90,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:03:48','2024-02-26 19:03:48'),(944,7908,40720,1549,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',163907.02,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:03:26','2024-02-26 19:03:26'),(945,7908,40720,1549,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',1603547.76,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:06:44','2024-02-26 19:06:44'),(946,7908,40720,1549,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',632780.88,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:06:15','2024-02-26 19:06:15'),(947,7908,40720,1549,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',14039.10,NULL,NULL,1,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(948,7908,40720,1549,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',162892.33,NULL,NULL,1,'2024-02-26 19:03:26','2024-02-26 19:05:18','2024-02-26 19:05:18'),(949,7908,40720,1549,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',483206.72,NULL,NULL,1,'2024-02-26 19:03:48','2024-02-26 19:05:29','2024-02-26 19:05:29'),(950,7908,40720,1549,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',53009.63,NULL,NULL,1,'2024-02-26 19:04:21','2024-02-26 19:05:06','2024-02-26 19:05:06'),(951,7908,40720,1549,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',53009.63,NULL,NULL,1,'2024-02-26 19:05:06','2024-02-26 19:05:40','2024-02-26 19:05:40'),(952,7908,40720,1549,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',162892.33,NULL,NULL,1,'2024-02-26 19:05:18','2024-02-26 19:05:18',NULL),(953,7908,40720,1549,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',483206.72,NULL,NULL,1,'2024-02-26 19:05:29','2024-02-26 19:05:29',NULL),(954,7908,40720,1549,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',53009.63,NULL,NULL,1,'2024-02-26 19:05:40','2024-02-26 19:05:40',NULL),(955,7908,40720,1549,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',628877.85,NULL,NULL,1,'2024-02-26 19:06:15','2024-02-26 19:06:15',NULL),(956,7908,40720,1549,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',1593670.48,NULL,NULL,1,'2024-02-26 19:06:44','2024-02-26 19:06:44',NULL),(957,7908,40720,1549,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',13600000.00,NULL,NULL,1,'2024-02-27 19:04:11','2024-04-23 22:09:48','2024-04-23 22:09:48'),(958,7908,40720,1549,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',1311880.79,NULL,NULL,1,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(959,7908,40720,1549,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',1304999.52,NULL,NULL,1,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(960,7908,40720,1549,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',1271949.58,NULL,NULL,1,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(961,7908,40720,1549,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',1321952.31,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL);
INSERT INTO `balance_libro` VALUES (962,7908,40720,1549,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',1270728.69,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(963,7908,40720,1549,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',1283375.61,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(964,7908,40720,1549,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',1310114.19,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(965,7908,40720,1549,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',1296427.88,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(966,7908,40720,1549,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',57312.11,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-27 18:45:58','2024-03-27 18:45:58'),(967,7908,40720,1549,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',57312.11,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-27 18:45:38','2024-03-27 18:45:38'),(968,7908,40720,1549,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',325455.10,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-27 18:45:22','2024-03-27 18:45:22'),(969,7908,40720,1549,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',82277.93,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-27 18:44:27','2024-03-27 18:44:27'),(970,7908,40720,1549,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',82277.93,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-27 18:44:11','2024-03-27 18:44:11'),(971,7908,40720,1549,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',325455.10,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-27 18:43:50','2024-03-27 18:43:50'),(972,7908,40720,1549,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',171936.32,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-27 18:43:30','2024-03-27 18:43:30'),(973,7908,40720,1549,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',19999.97,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-27 18:42:38','2024-03-27 18:42:38'),(974,7908,40720,1549,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',14999.99,NULL,NULL,1,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(975,7908,40720,1550,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',13800004.02,NULL,NULL,1,'2024-03-05 20:05:09','2024-03-05 20:05:09',NULL),(976,7908,40720,1550,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',30313.15,NULL,NULL,1,'2024-03-27 11:40:11','2024-05-02 18:52:45','2024-05-02 18:52:45'),(977,7908,40720,1550,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',326190.73,NULL,NULL,1,'2024-03-27 11:40:11','2024-05-02 18:52:27','2024-05-02 18:52:27'),(978,7908,40720,1550,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',44007.33,NULL,NULL,1,'2024-03-27 11:40:11','2024-05-02 18:54:47','2024-05-02 18:54:47'),(979,7908,40720,1550,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',105192.00,NULL,NULL,1,'2024-03-27 11:40:11','2024-05-02 18:55:34','2024-05-02 18:55:34'),(980,7908,40720,1550,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',42606.01,NULL,NULL,1,'2024-03-27 11:40:11','2024-05-02 18:56:44','2024-05-02 18:56:44'),(981,7908,40720,1550,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',46003.53,NULL,NULL,1,'2024-03-27 11:40:12','2024-05-02 18:54:32','2024-05-02 18:54:32');
INSERT INTO `balance_libro` VALUES (982,7908,40720,1550,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',14304.10,NULL,NULL,1,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(983,7908,40720,1550,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',263179.42,NULL,NULL,1,'2024-03-27 11:40:12','2024-05-02 18:52:07','2024-05-02 18:52:07'),(984,7908,40720,1550,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',136194.77,NULL,NULL,1,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(985,7908,40720,1550,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',380000.00,NULL,NULL,1,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(986,7908,40720,1550,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',14145.38,NULL,NULL,1,'2024-03-27 11:40:12','2024-05-02 18:59:17','2024-05-02 18:59:17'),(987,7908,40720,1550,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',24203.09,NULL,NULL,1,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(988,7908,40720,1550,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',7200.00,NULL,NULL,1,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(989,7908,40720,1550,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',329288.09,NULL,NULL,1,'2024-03-27 11:40:12','2024-05-02 18:51:46','2024-05-02 18:51:46'),(990,7908,40720,1550,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',185766.21,NULL,NULL,1,'2024-03-27 11:40:12','2024-05-02 18:51:30','2024-05-02 18:51:30'),(991,7908,40720,1550,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',57987.09,NULL,NULL,1,'2024-03-27 11:40:12','2024-05-02 18:51:04','2024-05-02 18:51:04'),(992,7908,40720,1550,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',19537.50,NULL,NULL,1,'2024-03-27 11:40:13','2024-03-27 11:40:13',NULL),(993,7908,40720,1550,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',18000.00,NULL,NULL,1,'2024-03-27 11:40:13','2024-03-27 11:40:13',NULL),(994,7908,40720,1550,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',83246.94,NULL,NULL,1,'2024-03-27 11:40:13','2024-05-02 18:50:44','2024-05-02 18:50:44'),(995,7908,40720,1550,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',10417.68,NULL,NULL,1,'2024-03-27 11:40:13','2024-05-02 18:53:55','2024-05-02 18:53:55'),(996,7908,40720,1549,7,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',2941054.43,NULL,NULL,1,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(997,7908,40720,1549,7,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',295696.32,NULL,NULL,1,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(998,7908,40720,1549,7,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',451337.64,NULL,NULL,1,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(999,7908,40720,1549,7,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',415358.82,NULL,NULL,1,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(1000,7908,40720,1549,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',4667777.60,NULL,NULL,1,'2024-03-27 14:34:33','2024-03-27 19:41:22','2024-03-27 19:41:22'),(1001,7908,40720,1549,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',7124687.04,NULL,NULL,1,'2024-03-27 14:38:11','2024-03-27 19:41:02','2024-03-27 19:41:02');
INSERT INTO `balance_libro` VALUES (1002,7908,40720,1549,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',6556735.74,NULL,NULL,1,'2024-03-27 14:40:39','2024-03-27 19:40:40','2024-03-27 19:40:40'),(1003,7908,40720,1549,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',46426644.89,NULL,NULL,1,'2024-03-27 14:43:05','2024-03-27 19:40:17','2024-03-27 19:40:17'),(1004,7908,40720,1549,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',42602.97,NULL,NULL,1,'2024-03-27 17:57:46','2024-03-27 17:57:46',NULL),(1005,7908,40720,1549,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',58576.76,NULL,NULL,1,'2024-03-27 17:59:28','2024-03-27 17:59:28',NULL),(1006,7908,40720,1549,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',154415.14,NULL,NULL,1,'2024-03-27 18:00:21','2024-03-27 18:00:21',NULL),(1007,7908,40720,1549,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',122603.98,NULL,NULL,1,'2024-03-27 18:12:43','2024-03-27 18:12:43',NULL),(1008,7908,40720,1549,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',31306.03,NULL,NULL,1,'2024-03-27 18:13:35','2024-03-27 18:13:35',NULL),(1009,7908,40720,1549,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',39999.02,NULL,NULL,1,'2024-03-27 18:14:24','2024-03-27 18:14:24',NULL),(1010,7908,40720,1549,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',30000.00,NULL,NULL,1,'2024-03-27 18:15:04','2024-03-27 18:15:04',NULL),(1011,7908,40720,1549,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',56000.03,NULL,NULL,1,'2024-03-27 18:15:50','2024-03-27 18:15:50',NULL),(1012,7908,40720,1549,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',44999.05,NULL,NULL,1,'2024-03-27 18:16:43','2024-03-27 18:16:43',NULL),(1013,7908,40720,1549,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',40010.96,NULL,NULL,1,'2024-03-27 18:18:02','2024-03-27 18:18:02',NULL),(1014,7908,40720,1549,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',58004.96,NULL,NULL,1,'2024-03-27 18:18:51','2024-03-27 18:18:51',NULL),(1015,7908,40720,1549,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',20000.80,NULL,NULL,1,'2024-03-27 18:19:39','2024-03-27 18:19:39',NULL),(1016,7908,40720,1549,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-18','2024-02-18',14999.98,NULL,NULL,1,'2024-03-27 18:20:38','2024-03-27 18:20:38',NULL),(1017,7908,40720,1549,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',20020.96,NULL,NULL,1,'2024-03-27 18:21:41','2024-03-27 18:21:41',NULL),(1018,7908,40720,1549,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',17999.97,NULL,NULL,1,'2024-03-27 18:22:28','2024-03-27 18:32:43','2024-03-27 18:32:43'),(1019,7908,40720,1549,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',39995.97,NULL,NULL,1,'2024-03-27 18:23:28','2024-03-27 18:33:18','2024-03-27 18:33:18'),(1020,7908,40720,1549,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',18005.04,NULL,NULL,1,'2024-03-27 18:24:28','2024-03-27 18:32:21','2024-03-27 18:32:21'),(1021,7908,40720,1549,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',30000.06,NULL,NULL,1,'2024-03-27 18:27:27','2024-03-27 18:27:27',NULL);
INSERT INTO `balance_libro` VALUES (1022,7908,40720,1549,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',29999.97,NULL,NULL,1,'2024-03-27 18:31:48','2024-03-27 18:31:48',NULL),(1023,7908,40720,1549,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',18005.04,NULL,NULL,1,'2024-03-27 18:32:21','2024-03-27 18:32:21',NULL),(1024,7908,40720,1549,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',17999.97,NULL,NULL,1,'2024-03-27 18:32:43','2024-03-27 18:32:43',NULL),(1025,7908,40720,1549,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',39995.97,NULL,NULL,1,'2024-03-27 18:33:18','2024-03-27 18:33:18',NULL),(1026,7908,40720,1549,15,895,'App\\Models\\PeriodLiquidation',NULL,895,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',8341948.07,NULL,NULL,1,'2024-03-27 18:34:56','2024-03-27 18:41:03','2024-03-27 18:41:03'),(1027,7908,40720,1549,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',18856.66,NULL,NULL,1,'2024-03-27 18:42:38','2024-03-27 18:42:38',NULL),(1028,7908,40720,1549,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',170877.17,NULL,NULL,1,'2024-03-27 18:43:30','2024-03-27 18:43:30',NULL),(1029,7908,40720,1549,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',323446.07,NULL,NULL,1,'2024-03-27 18:43:50','2024-03-27 18:43:50',NULL),(1030,7908,40720,1549,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',81776.93,NULL,NULL,1,'2024-03-27 18:44:11','2024-03-27 18:44:11',NULL),(1031,7908,40720,1549,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',81776.93,NULL,NULL,1,'2024-03-27 18:44:27','2024-03-27 18:44:27',NULL),(1032,7908,40720,1549,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',323446.07,NULL,NULL,1,'2024-03-27 18:45:22','2024-03-27 18:45:22',NULL),(1033,7908,40720,1549,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',56959.06,NULL,NULL,1,'2024-03-27 18:45:38','2024-03-27 18:45:38',NULL),(1034,7908,40720,1549,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',56959.06,NULL,NULL,1,'2024-03-27 18:45:58','2024-03-27 18:45:58',NULL),(1035,7908,40720,1549,15,904,'App\\Models\\PeriodLiquidation',NULL,904,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',8341948.07,NULL,NULL,1,'2024-03-27 19:38:37','2024-03-27 19:39:39','2024-03-27 19:39:39'),(1036,7908,40720,1549,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',46426644.89,NULL,NULL,1,'2024-03-27 19:40:17','2024-03-27 19:40:17',NULL),(1037,7908,40720,1549,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',6556735.74,NULL,NULL,1,'2024-03-27 19:40:40','2024-03-27 19:40:40',NULL),(1038,7908,40720,1549,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',7124687.04,NULL,NULL,1,'2024-03-27 19:41:02','2024-03-27 19:41:02',NULL),(1039,7908,40720,1549,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',4667777.60,NULL,NULL,1,'2024-03-27 19:41:22','2024-03-27 19:41:22',NULL),(1040,7908,40720,1549,15,909,'App\\Models\\PeriodLiquidation',NULL,909,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',8341948.07,NULL,NULL,1,'2024-03-27 19:55:32','2024-04-23 22:08:02','2024-04-23 22:08:02'),(1041,7908,40720,1550,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',14999.99,NULL,NULL,1,'2024-03-28 11:12:45','2024-03-28 11:12:45',NULL);
INSERT INTO `balance_libro` VALUES (1042,7908,40720,1551,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',10250000.75,NULL,NULL,1,'2024-04-08 10:16:03','2024-04-08 10:16:03',NULL),(1043,7908,40720,1551,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',152092.20,NULL,NULL,1,'2024-04-17 11:30:32','2024-04-17 11:30:32',NULL),(1044,7908,40720,1539,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',41549768.00,NULL,NULL,1,'2024-04-23 20:32:18','2024-04-23 20:37:04','2024-04-23 20:37:04'),(1045,7908,40720,1539,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',41549768.00,NULL,NULL,1,'2024-04-23 20:37:04','2024-04-23 20:37:04',NULL),(1046,7908,40720,1539,15,545,'App\\Models\\PeriodLiquidation',NULL,545,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4791966.93,NULL,NULL,1,'2024-04-23 21:28:19','2024-04-23 21:28:19',NULL),(1047,7908,40720,1536,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',6476900.00,NULL,NULL,1,'2024-04-23 21:31:03','2024-04-23 21:31:03',NULL),(1048,7908,40720,1536,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2100099.99,NULL,NULL,1,'2024-04-23 21:32:07','2024-04-23 21:32:07',NULL),(1049,7908,40720,1534,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1741000.00,NULL,NULL,1,'2024-04-23 21:47:11','2024-04-23 21:47:11',NULL),(1050,7908,40720,1536,15,398,'App\\Models\\PeriodLiquidation',NULL,398,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1545670.10,NULL,NULL,1,'2024-04-23 21:47:41','2024-04-23 21:47:41',NULL),(1051,7908,40720,1534,15,348,'App\\Models\\PeriodLiquidation',NULL,348,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',486458.47,NULL,NULL,1,'2024-04-23 21:48:00','2024-04-23 21:48:00',NULL),(1052,7908,40720,1549,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',13600000.00,NULL,NULL,1,'2024-04-23 22:09:48','2024-04-23 22:09:48',NULL),(1053,7908,40720,1548,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',650000.00,NULL,NULL,1,'2024-04-23 22:12:12','2024-04-23 22:12:12',NULL),(1054,7908,40720,1548,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',24959000.00,NULL,NULL,1,'2024-04-23 22:13:12','2024-04-23 22:13:12',NULL),(1055,7908,40720,1549,15,909,'App\\Models\\PeriodLiquidation',NULL,909,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',8341948.07,NULL,NULL,1,'2024-04-23 22:14:52','2024-04-23 22:14:52',NULL),(1056,7908,40720,1548,15,840,'App\\Models\\PeriodLiquidation',NULL,840,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',7124381.78,NULL,NULL,1,'2024-04-23 22:15:13','2024-11-13 13:00:58','2024-11-13 13:00:58'),(1057,7908,40720,1550,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1029699.11,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1058,7908,40720,1550,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1038359.08,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1059,7908,40720,1550,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1039239.96,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1060,7908,40720,1550,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1035456.29,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1061,7908,40720,1550,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1035931.82,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL);
INSERT INTO `balance_libro` VALUES (1062,7908,40720,1550,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1038183.63,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1063,7908,40720,1550,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1046946.45,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1064,7908,40720,1550,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',992682.79,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1065,7908,40720,1550,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1093786.24,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1066,7908,40720,1550,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1021143.20,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1067,7908,40720,1550,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',69702.97,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(1068,7908,40720,1550,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',83981.04,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 18:50:25','2024-05-02 18:50:25'),(1069,7908,40720,1550,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',187404.36,NULL,NULL,1,'2024-05-02 12:26:39','2024-05-02 18:50:00','2024-05-02 18:50:00'),(1070,7908,40720,1550,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',31143.73,NULL,NULL,1,'2024-05-02 12:26:40','2024-05-02 12:26:40',NULL),(1071,7908,40720,1551,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',23967.61,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(1072,7908,40720,1551,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',193358.88,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:42:59','2024-05-02 12:42:59'),(1073,7908,40720,1551,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',84274.68,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:42:43','2024-05-02 12:42:43'),(1074,7908,40720,1551,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',5300.00,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(1075,7908,40720,1551,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1944.80,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(1076,7908,40720,1551,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1944.80,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(1077,7908,40720,1551,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',84400.00,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(1078,7908,40720,1551,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',71300.00,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(1079,7908,40720,1551,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',2950.00,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(1080,7908,40720,1551,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',40980030.00,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(1081,7908,40720,1551,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',37086000.00,NULL,NULL,1,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL);
INSERT INTO `balance_libro` VALUES (1082,7908,40720,1551,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',16071.99,NULL,NULL,1,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(1083,7908,40720,1551,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',124407.18,NULL,NULL,1,'2024-05-02 12:40:08','2024-05-02 12:42:24','2024-05-02 12:42:24'),(1084,7908,40720,1551,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',92000.00,NULL,NULL,1,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(1085,7908,40720,1551,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',20000.01,NULL,NULL,1,'2024-05-02 12:40:08','2024-05-02 12:41:54','2024-05-02 12:41:54'),(1086,7908,40720,1551,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',93170.00,NULL,NULL,1,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(1087,7908,40720,1551,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',85606.49,NULL,NULL,1,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(1088,7908,40720,1551,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',14999.99,NULL,NULL,1,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(1089,7908,40720,1551,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',74797.80,NULL,NULL,1,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(1090,7908,40720,1551,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',17935.68,NULL,NULL,1,'2024-05-02 12:41:54','2024-05-02 12:41:54',NULL),(1091,7908,40720,1551,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',123640.81,NULL,NULL,1,'2024-05-02 12:42:24','2024-05-02 12:42:24',NULL),(1092,7908,40720,1551,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',83761.52,NULL,NULL,1,'2024-05-02 12:42:43','2024-05-02 12:42:43',NULL),(1093,7908,40720,1551,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',192167.12,NULL,NULL,1,'2024-05-02 12:42:59','2024-05-02 12:42:59',NULL),(1094,7908,40720,1551,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1944.80,NULL,NULL,1,'2024-05-02 12:51:57','2024-05-02 12:51:57',NULL),(1095,7908,40720,1551,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',40980030.00,NULL,NULL,1,'2024-05-02 12:51:57','2024-05-02 12:51:57',NULL),(1096,7908,40720,1550,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-03','2024-03-03',14998.98,NULL,NULL,1,'2024-05-02 18:29:25','2024-05-02 18:29:25',NULL),(1097,7908,40720,1550,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',24999.01,NULL,NULL,1,'2024-05-02 18:30:18','2024-05-02 18:30:18',NULL),(1098,7908,40720,1550,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',30009.02,NULL,NULL,1,'2024-05-02 18:31:03','2024-05-02 18:31:03',NULL),(1099,7908,40720,1550,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',40025.03,NULL,NULL,1,'2024-05-02 18:32:36','2024-05-02 18:32:36',NULL),(1100,7908,40720,1550,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',40012.99,NULL,NULL,1,'2024-05-02 18:33:29','2024-05-02 18:33:29',NULL),(1101,7908,40720,1550,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',59028.01,NULL,NULL,1,'2024-05-02 18:34:51','2024-05-02 18:34:51',NULL),(1102,7908,40720,1550,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',20035.04,NULL,NULL,1,'2024-05-02 18:35:48','2024-05-02 18:35:48',NULL);
INSERT INTO `balance_libro` VALUES (1103,7908,40720,1550,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',64998.97,NULL,NULL,1,'2024-05-02 18:36:52','2024-05-02 18:36:52',NULL),(1104,7908,40720,1550,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',40000.01,NULL,NULL,1,'2024-05-02 18:37:50','2024-05-02 18:37:50',NULL),(1105,7908,40720,1550,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',10002.00,NULL,NULL,1,'2024-05-02 18:40:56','2024-05-02 18:40:56',NULL),(1106,7908,40720,1550,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',46994.92,NULL,NULL,1,'2024-05-02 18:42:37','2024-05-02 18:42:37',NULL),(1107,7908,40720,1550,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',186249.49,NULL,NULL,1,'2024-05-02 18:50:00','2024-05-02 18:50:00',NULL),(1108,7908,40720,1550,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',83469.67,NULL,NULL,1,'2024-05-02 18:50:25','2024-05-02 18:50:25',NULL),(1109,7908,40720,1550,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',82740.04,NULL,NULL,1,'2024-05-02 18:50:44','2024-05-02 18:50:44',NULL),(1110,7908,40720,1550,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',57629.88,NULL,NULL,1,'2024-05-02 18:51:04','2024-05-02 18:51:04',NULL),(1111,7908,40720,1550,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',184621.44,NULL,NULL,1,'2024-05-02 18:51:30','2024-05-02 18:51:30',NULL),(1112,7908,40720,1550,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',327255.39,NULL,NULL,1,'2024-05-02 18:51:46','2024-05-02 18:51:46',NULL),(1113,7908,40720,1550,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',261558.19,NULL,NULL,1,'2024-05-02 18:52:07','2024-05-02 18:52:07',NULL),(1114,7908,40720,1550,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',324177.15,NULL,NULL,1,'2024-05-02 18:52:27','2024-05-02 18:52:27',NULL),(1115,7908,40720,1550,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',30124.01,NULL,NULL,1,'2024-05-02 18:52:45','2024-05-02 18:52:45',NULL),(1116,7908,40720,1550,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',10353.51,NULL,NULL,1,'2024-05-02 18:53:55','2024-05-02 18:53:55',NULL),(1117,7908,40720,1550,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',42433.99,NULL,NULL,1,'2024-05-02 18:54:32','2024-05-02 18:54:32',NULL),(1118,7908,40720,1550,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',40592.67,NULL,NULL,1,'2024-05-02 18:54:47','2024-05-02 18:54:47',NULL),(1119,7908,40720,1550,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',104544.00,NULL,NULL,1,'2024-05-02 18:55:34','2024-05-02 18:55:34',NULL),(1120,7908,40720,1550,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',38798.87,NULL,NULL,1,'2024-05-02 18:56:44','2024-05-02 18:56:44',NULL),(1121,7908,40720,1550,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',14145.37,NULL,NULL,1,'2024-05-02 18:59:17','2024-05-02 18:59:17',NULL),(1122,7908,40720,1550,15,947,'App\\Models\\PeriodLiquidation',NULL,947,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2395042.02,NULL,NULL,1,'2024-05-02 19:00:31','2024-05-02 19:00:31',NULL),(1123,7908,40720,1551,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',30004.95,NULL,NULL,1,'2024-05-22 18:28:42','2024-05-22 18:28:42',NULL);
INSERT INTO `balance_libro` VALUES (1124,7908,40720,1551,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-07','2024-04-07',9998.03,NULL,NULL,1,'2024-05-22 18:30:16','2024-05-22 18:30:16',NULL),(1125,7908,40720,1551,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',91006.97,NULL,NULL,1,'2024-05-22 18:31:08','2024-05-22 18:31:08',NULL),(1126,7908,40720,1551,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',50004.96,NULL,NULL,1,'2024-05-22 18:31:58','2024-05-22 18:31:58',NULL),(1127,7908,40720,1551,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',50012.02,NULL,NULL,1,'2024-05-22 18:34:06','2024-05-22 18:34:06',NULL),(1128,7908,40720,1551,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',20011.23,NULL,NULL,1,'2024-05-22 18:36:51','2024-05-22 18:36:51',NULL),(1129,7908,40720,1551,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',30001.96,NULL,NULL,1,'2024-05-22 18:37:45','2024-05-22 18:37:45',NULL),(1130,7908,40720,1551,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',30108.05,NULL,NULL,1,'2024-05-22 18:43:05','2024-05-22 18:43:05',NULL),(1131,7908,40720,1551,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',30006.06,NULL,NULL,1,'2024-05-22 18:45:28','2024-05-22 18:45:28',NULL),(1132,7908,40720,1551,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',29998.03,NULL,NULL,1,'2024-05-22 18:54:08','2024-05-22 18:54:08',NULL),(1133,7908,40720,1551,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',31066.04,NULL,NULL,1,'2024-05-22 18:55:03','2024-05-22 18:55:03',NULL),(1134,7908,40720,1551,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',50000.02,NULL,NULL,1,'2024-05-22 18:55:53','2024-05-22 18:55:53',NULL),(1135,7908,40720,1551,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',60032.04,NULL,NULL,1,'2024-05-22 18:57:20','2024-05-22 18:57:20',NULL),(1136,7908,40720,1551,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',29997.99,NULL,NULL,1,'2024-05-22 18:58:11','2024-05-22 18:58:11',NULL),(1137,7908,40720,1551,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',200000.00,NULL,NULL,1,'2024-05-22 19:08:08','2024-05-22 19:08:08',NULL),(1138,7908,40720,1551,15,983,'App\\Models\\PeriodLiquidation',NULL,983,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',7710962.27,NULL,NULL,1,'2024-05-22 19:15:42','2024-05-22 19:15:42',NULL),(1139,7908,40720,1552,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',4299.39,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:21:40','2024-06-25 12:21:40'),(1140,7908,40720,1552,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',79199.00,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(1141,7908,40720,1552,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',6989.00,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(1142,7908,40720,1552,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',129826.00,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(1143,7908,40720,1552,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',109237.92,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:24:45','2024-06-25 12:24:45'),(1144,7908,40720,1552,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',23340.00,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL);
INSERT INTO `balance_libro` VALUES (1145,7908,40720,1552,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',15950.00,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(1146,7908,40720,1552,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',11100.00,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(1147,7908,40720,1552,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',65000.00,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(1148,7908,40720,1552,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',29229.99,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(1149,7908,40720,1552,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',306532.32,NULL,NULL,1,'2024-06-25 12:19:23','2024-06-25 12:22:41','2024-06-25 12:22:41'),(1150,7908,40720,1552,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',14999.99,NULL,NULL,1,'2024-06-25 12:19:24','2024-06-25 12:19:24',NULL),(1151,7908,40720,1552,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',4299.40,NULL,NULL,1,'2024-06-25 12:21:40','2024-06-25 12:21:40',NULL),(1152,7908,40720,1552,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',306532.30,NULL,NULL,1,'2024-06-25 12:22:41','2024-06-25 12:22:41',NULL),(1153,7908,40720,1552,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',108565.00,NULL,NULL,1,'2024-06-25 12:24:45','2024-06-25 12:24:45',NULL),(1154,7908,40720,1552,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',240000.00,NULL,NULL,1,'2024-06-25 13:16:15','2024-06-25 13:16:15',NULL),(1155,7908,40720,1552,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',30001.01,NULL,NULL,1,'2024-06-25 13:19:29','2024-06-25 13:19:29',NULL),(1156,7908,40720,1552,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',40041.03,NULL,NULL,1,'2024-06-25 13:20:47','2024-06-25 13:20:47',NULL),(1157,7908,40720,1552,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',40009.96,NULL,NULL,1,'2024-06-25 13:21:58','2024-06-25 13:21:58',NULL),(1158,7908,40720,1552,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',20009.96,NULL,NULL,1,'2024-06-25 13:23:02','2024-06-25 13:23:02',NULL),(1159,7908,40720,1552,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',20018.98,NULL,NULL,1,'2024-06-25 13:23:54','2024-06-25 13:23:54',NULL),(1160,7908,40720,1552,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-19','2024-05-19',30004.06,NULL,NULL,1,'2024-06-25 13:25:06','2024-06-25 13:25:06',NULL),(1161,7908,40720,1552,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-19','2024-05-19',30000.00,NULL,NULL,1,'2024-06-25 13:25:58','2024-06-25 13:25:58',NULL),(1162,7908,40720,1552,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',50173.03,NULL,NULL,1,'2024-06-25 13:27:09','2024-06-25 13:27:09',NULL),(1163,7908,40720,1552,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',29994.97,NULL,NULL,1,'2024-06-25 13:28:16','2024-06-25 13:28:16',NULL),(1164,7908,40720,1552,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',30024.02,NULL,NULL,1,'2024-06-25 13:29:28','2024-06-25 13:29:28',NULL),(1165,7908,40720,1552,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',20000.16,NULL,NULL,1,'2024-06-25 13:33:48','2024-06-25 13:33:48',NULL);
INSERT INTO `balance_libro` VALUES (1166,7908,40720,1552,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',40000.06,NULL,NULL,1,'2024-06-25 13:36:02','2024-06-25 13:36:02',NULL),(1167,7908,40720,1552,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-25','2024-05-25',30001.17,NULL,NULL,1,'2024-06-25 13:37:12','2024-06-25 13:37:12',NULL),(1168,7908,40720,1552,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',30001.18,NULL,NULL,1,'2024-06-25 13:38:13','2024-06-25 13:38:13',NULL),(1169,7908,40720,1552,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',15006.90,NULL,NULL,1,'2024-06-25 13:39:50','2024-06-25 13:39:50',NULL),(1170,7908,40720,1552,15,1006,'App\\Models\\PeriodLiquidation',NULL,1006,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2277196.33,NULL,NULL,1,'2024-06-25 13:43:51','2024-06-25 13:43:51',NULL),(1171,7908,40720,1553,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',97000.00,NULL,NULL,1,'2024-07-25 19:06:19','2024-07-25 19:06:19',NULL),(1172,7908,40720,1553,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',126585.11,NULL,NULL,1,'2024-07-25 19:06:20','2024-07-25 19:09:42','2024-07-25 19:09:42'),(1173,7908,40720,1553,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',9111.57,NULL,NULL,1,'2024-07-25 19:06:20','2024-07-25 19:11:10','2024-07-25 19:11:10'),(1174,7908,40720,1553,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',13900.00,NULL,NULL,1,'2024-07-25 19:06:20','2024-07-25 19:06:20',NULL),(1175,7908,40720,1553,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',22500.00,NULL,NULL,1,'2024-07-25 19:06:20','2024-07-25 19:06:20',NULL),(1176,7908,40720,1553,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',125805.32,NULL,NULL,1,'2024-07-25 19:09:42','2024-07-25 19:09:42',NULL),(1177,7908,40720,1553,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',9000.00,NULL,NULL,1,'2024-07-25 19:11:10','2024-07-25 19:11:10',NULL),(1178,7908,40720,1553,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',9878576.30,NULL,NULL,1,'2024-07-25 19:20:57','2024-07-25 19:20:57',NULL),(1179,7908,40720,1553,2,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',4273641.38,NULL,NULL,1,'2024-07-25 19:24:20','2024-07-25 19:24:20',NULL),(1180,7908,40720,1553,7,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',309403.90,NULL,NULL,1,'2024-07-25 19:30:02','2024-07-25 19:30:02',NULL),(1181,7908,40720,1553,7,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',715191.04,NULL,NULL,1,'2024-07-25 19:30:02','2024-07-25 19:30:02',NULL),(1182,7908,40720,1553,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',30000.02,NULL,NULL,1,'2024-07-25 19:46:29','2024-07-25 19:46:29',NULL),(1183,7908,40720,1553,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',20045.98,NULL,NULL,1,'2024-07-25 19:47:36','2024-07-25 19:47:36',NULL),(1184,7908,40720,1553,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',40016.02,NULL,NULL,1,'2024-07-25 19:48:30','2024-07-25 19:48:30',NULL),(1185,7908,40720,1553,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',199994.95,NULL,NULL,1,'2024-07-25 19:49:46','2024-07-25 19:49:46',NULL),(1186,7908,40720,1553,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',40014.01,NULL,NULL,1,'2024-07-25 19:50:57','2024-07-25 19:50:57',NULL);
INSERT INTO `balance_libro` VALUES (1187,7908,40720,1553,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',29997.04,NULL,NULL,1,'2024-07-25 19:51:39','2024-07-25 19:51:39',NULL),(1188,7908,40720,1553,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',150023.98,NULL,NULL,1,'2024-07-25 19:54:09','2024-07-25 19:54:09',NULL),(1189,7908,40720,1553,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',50045.02,NULL,NULL,1,'2024-07-25 19:55:32','2024-07-25 19:55:32',NULL),(1190,7908,40720,1553,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-02','2024-06-02',30007.02,NULL,NULL,1,'2024-07-25 19:56:39','2024-07-25 19:56:39',NULL),(1191,7908,40720,1553,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',15011.02,NULL,NULL,1,'2024-07-25 19:57:59','2024-07-25 19:57:59',NULL),(1192,7908,40720,1553,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',150000.59,NULL,NULL,1,'2024-07-25 19:59:30','2024-07-25 19:59:30',NULL),(1193,7908,40720,1553,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',15016.66,NULL,NULL,1,'2024-07-25 20:02:11','2024-07-25 20:02:11',NULL),(1194,7908,40720,1553,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',50023.06,NULL,NULL,1,'2024-07-26 10:28:16','2024-07-26 10:28:16',NULL),(1195,7908,40720,1553,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',30007.02,NULL,NULL,1,'2024-07-26 10:30:36','2024-07-26 10:30:36',NULL),(1196,7908,40720,1553,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',20003.04,NULL,NULL,1,'2024-07-26 10:31:37','2024-07-26 10:31:37',NULL),(1197,7908,40720,1553,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-16','2024-06-16',15022.99,NULL,NULL,1,'2024-07-26 10:32:16','2024-07-26 10:32:16',NULL),(1198,7908,40720,1553,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',99998.01,NULL,NULL,1,'2024-07-26 10:33:12','2024-07-26 10:33:12',NULL),(1199,7908,40720,1553,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',15004.98,NULL,NULL,1,'2024-07-26 10:34:07','2024-07-26 10:34:07',NULL),(1200,7908,40720,1553,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',20005.99,NULL,NULL,1,'2024-07-26 10:34:52','2024-07-26 10:34:52',NULL),(1201,7908,40720,1553,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',20006.97,NULL,NULL,1,'2024-07-26 10:35:35','2024-07-26 10:35:35',NULL),(1202,7908,40720,1553,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',20000.04,NULL,NULL,1,'2024-07-26 10:36:55','2024-07-26 10:36:55',NULL),(1203,7908,40720,1553,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',30014.11,NULL,NULL,1,'2024-07-26 10:38:39','2024-07-26 10:38:39',NULL),(1204,7908,40720,1553,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',10004.30,NULL,NULL,1,'2024-07-26 10:39:58','2024-07-26 10:39:58',NULL),(1205,7908,40720,1553,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',40002.06,NULL,NULL,1,'2024-07-26 10:41:23','2024-07-26 10:41:23',NULL),(1206,7908,40720,1553,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',150000.59,NULL,NULL,1,'2024-07-26 10:44:55','2024-07-26 10:44:55',NULL),(1207,7908,40720,1553,15,1043,'App\\Models\\PeriodLiquidation',NULL,1043,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',3560021.70,NULL,NULL,1,'2024-07-26 10:48:39','2024-07-26 10:48:39',NULL);
INSERT INTO `balance_libro` VALUES (1208,7908,40720,1555,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',9200002.68,NULL,NULL,1,'2024-08-05 19:50:14','2024-08-05 19:50:14',NULL),(1209,7908,40720,1540,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',11430000.01,NULL,NULL,1,'2024-08-07 11:14:22','2024-08-07 11:14:22',NULL),(1210,7908,40720,1540,15,632,'App\\Models\\PeriodLiquidation',NULL,632,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1856467.90,NULL,NULL,1,'2024-08-07 11:15:47','2024-08-07 11:15:47',NULL),(1211,7908,40720,1554,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',36800.00,NULL,NULL,1,'2024-08-28 20:14:56','2024-08-28 20:14:56',NULL),(1212,7908,40720,1554,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',78650.00,NULL,NULL,1,'2024-08-28 20:14:56','2024-08-28 20:14:56',NULL),(1213,7908,40720,1554,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',68860.20,NULL,NULL,1,'2024-08-28 20:14:56','2024-08-28 20:14:56',NULL),(1214,7908,40720,1554,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',9004.80,NULL,NULL,1,'2024-08-28 20:14:56','2024-08-28 20:14:56',NULL),(1215,7908,40720,1554,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',826738.74,NULL,NULL,1,'2024-08-28 20:14:56','2024-08-28 20:14:56',NULL),(1216,7908,40720,1554,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',1016400.00,NULL,NULL,1,'2024-08-28 20:14:57','2024-08-28 20:14:57',NULL),(1217,7908,40720,1554,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',124000.80,NULL,NULL,1,'2024-08-28 20:14:57','2024-08-28 20:18:43','2024-08-28 20:18:43'),(1218,7908,40720,1554,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',329999.00,NULL,NULL,1,'2024-08-28 20:14:57','2024-08-28 20:14:57',NULL),(1219,7908,40720,1554,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',131323.25,NULL,NULL,1,'2024-08-28 20:14:57','2024-08-28 20:16:27','2024-08-28 20:16:27'),(1220,7908,40720,1554,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',635152.92,NULL,NULL,1,'2024-08-28 20:14:57','2024-08-28 20:17:53','2024-08-28 20:17:53'),(1221,7908,40720,1554,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',132963.30,NULL,NULL,1,'2024-08-28 20:14:57','2024-08-28 20:17:27','2024-08-28 20:17:27'),(1222,7908,40720,1554,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',22500.00,NULL,NULL,1,'2024-08-28 20:14:57','2024-08-28 20:14:57',NULL),(1223,7908,40720,1554,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',130514.28,NULL,NULL,1,'2024-08-28 20:16:27','2024-08-28 20:16:27',NULL),(1224,7908,40720,1554,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',132150.73,NULL,NULL,1,'2024-08-28 20:17:27','2024-08-28 20:17:27',NULL),(1225,7908,40720,1554,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',631243.71,NULL,NULL,1,'2024-08-28 20:17:53','2024-08-28 20:17:53',NULL),(1226,7908,40720,1554,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',123239.95,NULL,NULL,1,'2024-08-28 20:18:43','2024-08-28 20:18:43',NULL),(1227,7908,40720,1555,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',8203875.81,NULL,NULL,1,'2024-08-28 20:39:06','2024-08-28 20:45:35','2024-08-28 20:45:35');
INSERT INTO `balance_libro` VALUES (1228,7908,40720,1555,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',8203875.81,NULL,NULL,1,'2024-08-28 20:45:35','2024-08-28 20:45:35',NULL),(1229,7908,40720,1554,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',30027.00,NULL,NULL,1,'2024-08-31 19:25:19','2024-08-31 19:25:19',NULL),(1230,7908,40720,1554,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',50003.04,NULL,NULL,1,'2024-08-31 19:26:13','2024-08-31 19:26:13',NULL),(1231,7908,40720,1554,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',59999.96,NULL,NULL,1,'2024-08-31 19:27:07','2024-08-31 19:27:07',NULL),(1232,7908,40720,1554,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',30000.04,NULL,NULL,1,'2024-08-31 19:28:08','2024-08-31 19:28:08',NULL),(1233,7908,40720,1554,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',30002.96,NULL,NULL,1,'2024-08-31 19:29:32','2024-08-31 19:29:32',NULL),(1234,7908,40720,1554,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',118013.04,NULL,NULL,1,'2024-08-31 19:30:56','2024-08-31 19:30:56',NULL),(1235,7908,40720,1554,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',16011.98,NULL,NULL,1,'2024-08-31 19:31:56','2024-08-31 19:31:56',NULL),(1236,7908,40720,1554,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',146006.04,NULL,NULL,1,'2024-08-31 19:35:11','2024-08-31 19:35:11',NULL),(1237,7908,40720,1554,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',100003.03,NULL,NULL,1,'2024-08-31 19:36:20','2024-08-31 19:36:20',NULL),(1238,7908,40720,1554,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',15000.02,NULL,NULL,1,'2024-08-31 19:37:10','2024-08-31 19:37:10',NULL),(1239,7908,40720,1554,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',133880.01,NULL,NULL,1,'2024-08-31 19:38:23','2024-08-31 19:38:23',NULL),(1240,7908,40720,1554,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',153505.99,NULL,NULL,1,'2024-08-31 19:39:28','2024-08-31 19:39:28',NULL),(1241,7908,40720,1554,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',42210.02,NULL,NULL,1,'2024-08-31 19:40:36','2024-08-31 19:40:36',NULL),(1242,7908,40720,1554,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',40000.01,NULL,NULL,1,'2024-08-31 19:41:18','2024-08-31 19:41:18',NULL),(1243,7908,40720,1554,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',50023.94,NULL,NULL,1,'2024-08-31 19:42:04','2024-08-31 19:42:04',NULL),(1244,7908,40720,1554,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',39996.96,NULL,NULL,1,'2024-08-31 19:43:14','2024-08-31 19:43:14',NULL),(1245,7908,40720,1554,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',100153.02,NULL,NULL,1,'2024-08-31 19:44:33','2024-08-31 19:44:33',NULL),(1246,7908,40720,1554,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',70006.52,NULL,NULL,1,'2024-08-31 19:46:17','2024-08-31 19:46:17',NULL),(1247,7908,40720,1554,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',20006.43,NULL,NULL,1,'2024-08-31 19:47:11','2024-08-31 19:47:11',NULL),(1248,7908,40720,1554,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',15000.02,NULL,NULL,1,'2024-08-31 19:48:21','2024-08-31 19:48:21',NULL);
INSERT INTO `balance_libro` VALUES (1249,7908,40720,1554,15,1077,'App\\Models\\PeriodLiquidation',NULL,1077,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',3007505.07,NULL,NULL,1,'2024-08-31 19:50:45','2024-08-31 19:50:45',NULL),(1250,7908,40720,1555,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',46000.00,NULL,NULL,1,'2024-09-03 12:14:51','2024-09-03 12:14:51',NULL),(1251,7908,40720,1555,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',89220.36,NULL,NULL,1,'2024-09-03 12:14:51','2024-09-03 12:21:26','2024-09-03 12:21:26'),(1252,7908,40720,1555,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',54044.29,NULL,NULL,1,'2024-09-03 12:14:51','2024-09-03 12:20:16','2024-09-03 12:20:16'),(1253,7908,40720,1555,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',285182.33,NULL,NULL,1,'2024-09-03 12:14:52','2024-09-03 12:19:47','2024-09-03 12:19:47'),(1254,7908,40720,1555,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',13500.00,NULL,NULL,1,'2024-09-03 12:14:52','2024-09-03 12:14:52',NULL),(1255,7908,40720,1555,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',286843.00,NULL,NULL,1,'2024-09-03 12:14:52','2024-09-03 12:19:17','2024-09-03 12:19:17'),(1256,7908,40720,1555,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',25000.05,NULL,NULL,1,'2024-09-03 12:14:52','2024-09-03 12:17:18','2024-09-03 12:17:18'),(1257,7908,40720,1555,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',21587.26,NULL,NULL,1,'2024-09-03 12:17:18','2024-09-03 12:17:18',NULL),(1258,7908,40720,1555,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',285076.00,NULL,NULL,1,'2024-09-03 12:19:17','2024-09-03 12:19:17',NULL),(1259,7908,40720,1555,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',283425.56,NULL,NULL,1,'2024-09-03 12:19:47','2024-09-03 12:19:47',NULL),(1260,7908,40720,1555,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',53713.72,NULL,NULL,1,'2024-09-03 12:20:16','2024-09-03 12:20:16',NULL),(1261,7908,40720,1555,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',88670.75,NULL,NULL,1,'2024-09-03 12:21:26','2024-09-03 12:21:26',NULL),(1262,7908,40720,1555,7,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',519702.54,NULL,NULL,1,'2024-09-09 12:31:54','2024-09-09 12:31:54',NULL),(1263,7908,40720,1555,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',70059.00,NULL,NULL,1,'2024-09-09 20:04:47','2024-09-09 20:04:47',NULL),(1264,7908,40720,1555,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',20018.95,NULL,NULL,1,'2024-09-09 20:05:53','2024-09-09 20:05:53',NULL),(1265,7908,40720,1555,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-22','2024-08-22',60000.07,NULL,NULL,1,'2024-09-09 20:07:34','2024-09-09 20:07:34',NULL),(1266,7908,40720,1555,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',20011.97,NULL,NULL,1,'2024-09-09 20:09:07','2024-09-09 20:09:07',NULL),(1267,7908,40720,1555,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',30004.01,NULL,NULL,1,'2024-09-09 20:10:04','2024-09-09 20:10:04',NULL),(1268,7908,40720,1555,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',83007.05,NULL,NULL,1,'2024-09-09 20:11:18','2024-09-09 20:11:18',NULL);
INSERT INTO `balance_libro` VALUES (1269,7908,40720,1555,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',10001.96,NULL,NULL,1,'2024-09-09 20:12:22','2024-09-09 20:12:22',NULL),(1270,7908,40720,1555,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',45007.04,NULL,NULL,1,'2024-09-09 20:13:32','2024-09-09 20:13:32',NULL),(1271,7908,40720,1555,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',180009.01,NULL,NULL,1,'2024-09-09 20:14:42','2024-09-09 20:14:42',NULL),(1272,7908,40720,1555,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',19995.96,NULL,NULL,1,'2024-09-09 20:15:50','2024-09-09 20:15:50',NULL),(1273,7908,40720,1555,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',19997.01,NULL,NULL,1,'2024-09-09 20:16:56','2024-09-09 20:16:56',NULL),(1274,7908,40720,1555,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',50002.73,NULL,NULL,1,'2024-09-09 20:18:33','2024-09-09 20:18:33',NULL),(1275,7908,40720,1555,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',20000.05,NULL,NULL,1,'2024-09-09 20:22:39','2024-09-09 20:22:39',NULL),(1276,7908,40720,1555,15,1102,'App\\Models\\PeriodLiquidation',NULL,1102,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',3765314.68,NULL,NULL,1,'2024-09-09 20:32:48','2024-09-09 20:32:48',NULL),(1277,7908,40720,1556,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',16176728.21,NULL,NULL,1,'2024-09-27 19:19:20','2024-09-27 19:22:36','2024-09-27 19:22:36'),(1278,7908,40720,1556,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',374260.00,NULL,NULL,1,'2024-09-27 19:19:20','2024-10-25 19:51:32','2024-10-25 19:51:32'),(1279,7908,40720,1556,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',260127.87,NULL,NULL,1,'2024-09-27 19:19:20','2024-09-27 19:22:11','2024-09-27 19:22:11'),(1280,7908,40720,1556,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',642952.12,NULL,NULL,1,'2024-09-27 19:19:20','2024-09-27 19:21:56','2024-09-27 19:21:56'),(1281,7908,40720,1556,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',7824.72,NULL,NULL,1,'2024-09-27 19:19:21','2024-09-27 19:21:38','2024-09-27 19:21:38'),(1282,7908,40720,1556,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',6800.00,NULL,NULL,1,'2024-09-27 19:19:21','2024-09-27 19:19:21',NULL),(1283,7908,40720,1556,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',145459.60,NULL,NULL,1,'2024-09-27 19:19:21','2024-09-27 19:21:20','2024-09-27 19:21:20'),(1284,7908,40720,1556,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',219128.81,NULL,NULL,1,'2024-09-27 19:19:21','2024-09-27 19:20:57','2024-09-27 19:20:57'),(1285,7908,40720,1556,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',31092.15,NULL,NULL,1,'2024-09-27 19:19:21','2024-09-27 19:20:44','2024-09-27 19:20:44'),(1286,7908,40720,1556,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',251653.86,NULL,NULL,1,'2024-09-27 19:19:21','2024-10-25 19:50:42','2024-10-25 19:50:42'),(1287,7908,40720,1556,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',30894.63,NULL,NULL,1,'2024-09-27 19:20:44','2024-09-27 19:20:44',NULL),(1288,7908,40720,1556,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',217777.98,NULL,NULL,1,'2024-09-27 19:20:57','2024-10-25 19:52:45','2024-10-25 19:52:45');
INSERT INTO `balance_libro` VALUES (1289,7908,40720,1556,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',144563.54,NULL,NULL,1,'2024-09-27 19:21:20','2024-09-27 19:21:20',NULL),(1290,7908,40720,1556,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',7776.52,NULL,NULL,1,'2024-09-27 19:21:38','2024-09-27 19:21:38',NULL),(1291,7908,40720,1556,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',638997.98,NULL,NULL,1,'2024-09-27 19:21:56','2024-09-27 19:21:56',NULL),(1292,7908,40720,1556,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',258525.44,NULL,NULL,1,'2024-09-27 19:22:11','2024-09-27 19:22:11',NULL),(1293,7908,40720,1556,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',16067666.88,NULL,NULL,1,'2024-09-27 19:22:36','2024-10-25 19:54:52','2024-10-25 19:54:52'),(1294,7908,40720,1556,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',16313.83,NULL,NULL,1,'2024-10-25 19:46:37','2024-10-25 19:46:37',NULL),(1295,7908,40720,1556,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',22500.00,NULL,NULL,1,'2024-10-25 19:46:37','2024-10-25 19:46:37',NULL),(1296,7908,40720,1556,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',251653.86,NULL,NULL,1,'2024-10-25 19:50:42','2024-10-25 19:50:42',NULL),(1297,7908,40720,1556,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',374260.01,NULL,NULL,1,'2024-10-25 19:51:32','2024-10-25 19:51:32',NULL),(1298,7908,40720,1556,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',217777.98,NULL,NULL,1,'2024-10-25 19:52:45','2024-10-25 19:52:45',NULL),(1299,7908,40720,1556,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',16067666.88,NULL,NULL,1,'2024-10-25 19:54:52','2024-10-25 19:54:52',NULL),(1300,7908,40720,1556,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',18134189.26,NULL,NULL,1,'2024-10-25 20:06:54','2024-10-25 20:15:34','2024-10-25 20:15:34'),(1301,7908,40720,1556,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',18134189.25,NULL,NULL,1,'2024-10-25 20:15:34','2024-10-28 19:34:05','2024-10-28 19:34:05'),(1302,7908,40720,1556,7,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',1148772.17,NULL,NULL,1,'2024-10-25 20:18:03','2024-10-25 20:18:03',NULL),(1303,7908,40720,1556,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',18134189.26,NULL,NULL,1,'2024-10-25 20:27:08','2024-10-25 20:29:20','2024-10-25 20:29:20'),(1304,7908,40720,1556,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',18134189.25,NULL,NULL,1,'2024-10-25 20:29:20','2024-10-25 20:29:20',NULL),(1305,7908,40720,1556,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',120014.02,NULL,NULL,1,'2024-10-28 18:53:42','2024-10-28 18:53:42',NULL),(1306,7908,40720,1556,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',48999.01,NULL,NULL,1,'2024-10-28 18:54:50','2024-10-28 18:54:50',NULL),(1307,7908,40720,1556,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',20007.00,NULL,NULL,1,'2024-10-28 18:55:51','2024-10-28 18:55:51',NULL),(1308,7908,40720,1556,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',104002.15,NULL,NULL,1,'2024-10-28 18:57:12','2024-10-28 18:57:12',NULL);
INSERT INTO `balance_libro` VALUES (1309,7908,40720,1556,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',60016.96,NULL,NULL,1,'2024-10-28 18:58:05','2024-10-28 18:58:05',NULL),(1310,7908,40720,1556,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',150014.89,NULL,NULL,1,'2024-10-28 18:58:57','2024-10-28 18:58:57',NULL),(1311,7908,40720,1556,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',61998.03,NULL,NULL,1,'2024-10-28 19:00:26','2024-10-28 19:00:26',NULL),(1312,7908,40720,1556,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',60036.02,NULL,NULL,1,'2024-10-28 19:01:30','2024-10-28 19:01:30',NULL),(1313,7908,40720,1556,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',39998.00,NULL,NULL,1,'2024-10-28 19:02:54','2024-10-28 19:02:54',NULL),(1314,7908,40720,1556,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',60077.12,NULL,NULL,1,'2024-10-28 19:04:19','2024-10-28 19:04:19',NULL),(1315,7908,40720,1556,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',60008.06,NULL,NULL,1,'2024-10-28 19:05:26','2024-10-28 19:05:26',NULL),(1316,7908,40720,1556,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',50008.97,NULL,NULL,1,'2024-10-28 19:06:34','2024-10-28 19:06:34',NULL),(1317,7908,40720,1556,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',40051.98,NULL,NULL,1,'2024-10-28 19:08:01','2024-10-28 19:08:01',NULL),(1318,7908,40720,1556,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-22','2024-09-22',29997.94,NULL,NULL,1,'2024-10-28 19:09:18','2024-10-28 19:09:18',NULL),(1319,7908,40720,1556,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',24998.03,NULL,NULL,1,'2024-10-28 19:10:25','2024-10-28 19:10:25',NULL),(1320,7908,40720,1556,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',80007.06,NULL,NULL,1,'2024-10-28 19:11:33','2024-10-28 19:11:33',NULL),(1321,7908,40720,1556,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',70058.94,NULL,NULL,1,'2024-10-28 19:12:23','2024-10-28 19:12:23',NULL),(1322,7908,40720,1556,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',75103.96,NULL,NULL,1,'2024-10-28 19:13:19','2024-10-28 19:13:19',NULL),(1323,7908,40720,1556,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',40004.99,NULL,NULL,1,'2024-10-28 19:14:12','2024-10-28 19:14:12',NULL),(1324,7908,40720,1556,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',150019.94,NULL,NULL,1,'2024-10-28 19:15:20','2024-10-28 19:15:20',NULL),(1325,7908,40720,1556,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',80005.01,NULL,NULL,1,'2024-10-28 19:16:22','2024-10-28 19:16:22',NULL),(1326,7908,40720,1556,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',40036.96,NULL,NULL,1,'2024-10-28 19:17:12','2024-10-28 19:17:12',NULL),(1327,7908,40720,1556,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',60011.99,NULL,NULL,1,'2024-10-28 19:18:03','2024-10-28 19:18:03',NULL),(1328,7908,40720,1556,15,1161,'App\\Models\\PeriodLiquidation',NULL,1161,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',4647782.20,NULL,NULL,1,'2024-10-30 11:08:28','2024-11-12 19:08:01','2024-11-12 19:08:01');
INSERT INTO `balance_libro` VALUES (1329,7908,40720,1556,15,1161,'App\\Models\\PeriodLiquidation',NULL,1161,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',4647782.20,NULL,NULL,1,'2024-11-12 19:10:39','2024-11-12 19:10:39',NULL),(1330,7908,40720,1557,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',24506.29,NULL,NULL,1,'2024-11-25 18:32:39','2024-11-25 18:32:39',NULL),(1331,7908,40720,1557,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',55760.89,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-26 12:26:24','2024-11-26 12:26:24'),(1332,7908,40720,1557,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',220685.27,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-26 12:26:13','2024-11-26 12:26:13'),(1333,7908,40720,1557,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',1309413.65,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-26 12:25:57','2024-11-26 12:25:57'),(1334,7908,40720,1557,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',251403.39,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-25 18:32:40',NULL),(1335,7908,40720,1557,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',9768200.00,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-25 18:32:40',NULL),(1336,7908,40720,1557,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',40561.22,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-26 12:25:43','2024-11-26 12:25:43'),(1337,7908,40720,1557,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',725459.00,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-25 18:32:40',NULL),(1338,7908,40720,1557,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',456562.50,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-26 12:27:41','2024-11-26 12:27:41'),(1339,7908,40720,1557,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',28000.01,NULL,NULL,1,'2024-11-25 18:32:40','2024-11-25 18:32:40',NULL),(1340,7908,40720,1558,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',383010.03,NULL,NULL,1,'2024-11-25 18:35:30','2025-01-03 21:06:17','2025-01-03 21:06:17'),(1341,7908,40720,1558,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',56819.46,NULL,NULL,1,'2024-11-25 18:35:30','2025-01-03 21:05:27','2025-01-03 21:05:27'),(1342,7908,40720,1558,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',74961.57,NULL,NULL,1,'2024-11-25 18:35:30','2025-01-03 21:05:08','2025-01-03 21:05:08'),(1343,7908,40720,1558,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',5000.00,NULL,NULL,1,'2024-11-25 18:35:30','2025-01-03 20:59:56','2025-01-03 20:59:56'),(1344,7908,40720,1558,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',66883.76,NULL,NULL,1,'2024-11-25 18:35:30','2025-01-03 21:04:51','2025-01-03 21:04:51'),(1345,7908,40720,1558,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',125537.85,NULL,NULL,1,'2024-11-25 18:35:30','2025-01-03 21:04:16','2025-01-03 21:04:16'),(1346,7908,40720,1558,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',193524.98,NULL,NULL,1,'2024-11-25 18:35:30','2025-01-03 21:03:46','2025-01-03 21:03:46'),(1347,7908,40720,1558,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',57420.27,NULL,NULL,1,'2024-11-25 18:35:31','2025-01-03 21:03:27','2025-01-03 21:03:27');
INSERT INTO `balance_libro` VALUES (1348,7908,40720,1558,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',247412.93,NULL,NULL,1,'2024-11-25 18:35:31','2025-01-03 21:03:06','2025-01-03 21:03:06'),(1349,7908,40720,1558,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',151498.40,NULL,NULL,1,'2024-11-25 18:35:31','2025-01-03 21:02:43','2025-01-03 21:02:43'),(1350,7908,40720,1558,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',193524.98,NULL,NULL,1,'2024-11-25 18:35:31','2025-01-03 21:02:18','2025-01-03 21:02:18'),(1351,7908,40720,1558,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',6704.25,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1352,7908,40720,1558,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',14043.01,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1353,7908,40720,1558,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',70357.70,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1354,7908,40720,1558,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',11721.30,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1355,7908,40720,1558,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',364.29,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1356,7908,40720,1558,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',317541.70,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1357,7908,40720,1558,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',25180.59,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1358,7908,40720,1558,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',459800.00,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1359,7908,40720,1558,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',117128.00,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1360,7908,40720,1558,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',642134.80,NULL,NULL,1,'2024-11-25 18:35:31','2024-11-25 18:35:31',NULL),(1361,7908,40720,1558,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',22575.70,NULL,NULL,1,'2024-11-25 18:35:31','2025-01-03 20:56:18','2025-01-03 20:56:18'),(1362,7908,40720,1557,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',15054376.35,NULL,NULL,1,'2024-11-25 18:47:12','2024-11-25 18:47:12',NULL),(1363,7908,40720,1558,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',8905892.30,NULL,NULL,1,'2024-11-25 18:51:28','2024-11-25 18:51:28',NULL),(1364,7908,40720,1558,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',5498117.32,NULL,NULL,1,'2024-11-25 18:57:43','2024-11-25 18:57:43',NULL),(1365,7908,40720,1557,7,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',953670.90,NULL,NULL,1,'2024-11-25 19:03:26','2024-11-25 19:03:26',NULL),(1366,7908,40720,1557,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',30009.98,NULL,NULL,1,'2024-11-26 11:46:00','2024-11-26 11:46:00',NULL),(1367,7908,40720,1557,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',55004.94,NULL,NULL,1,'2024-11-26 11:48:22','2024-11-26 11:48:22',NULL);
INSERT INTO `balance_libro` VALUES (1368,7908,40720,1557,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',30005.02,NULL,NULL,1,'2024-11-26 11:49:06','2024-11-26 11:49:06',NULL),(1369,7908,40720,1557,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',11635.03,NULL,NULL,1,'2024-11-26 11:50:28','2024-11-26 11:50:28',NULL),(1370,7908,40720,1557,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',30015.00,NULL,NULL,1,'2024-11-26 11:51:22','2024-11-26 11:51:22',NULL),(1371,7908,40720,1557,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',101086.09,NULL,NULL,1,'2024-11-26 11:53:57','2024-11-26 11:53:57',NULL),(1372,7908,40720,1557,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',20045.02,NULL,NULL,1,'2024-11-26 11:56:10','2024-11-26 11:56:10',NULL),(1373,7908,40720,1557,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',29996.04,NULL,NULL,1,'2024-11-26 11:56:54','2024-11-26 11:56:54',NULL),(1374,7908,40720,1557,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',60014.03,NULL,NULL,1,'2024-11-26 11:57:43','2024-11-26 11:57:43',NULL),(1375,7908,40720,1557,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',60019.90,NULL,NULL,1,'2024-11-26 11:58:32','2024-11-26 11:58:32',NULL),(1376,7908,40720,1557,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',150021.07,NULL,NULL,1,'2024-11-26 11:59:13','2024-11-26 11:59:13',NULL),(1377,7908,40720,1557,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',150015.02,NULL,NULL,1,'2024-11-26 12:00:26','2024-11-26 12:00:26',NULL),(1378,7908,40720,1557,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',40008.05,NULL,NULL,1,'2024-11-26 12:02:24','2024-11-26 12:02:24',NULL),(1379,7908,40720,1557,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',110025.00,NULL,NULL,1,'2024-11-26 12:03:12','2024-11-26 12:03:12',NULL),(1380,7908,40720,1557,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',30039.01,NULL,NULL,1,'2024-11-26 12:04:55','2024-11-26 12:04:55',NULL),(1381,7908,40720,1557,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',30000.04,NULL,NULL,1,'2024-11-26 12:06:14','2024-11-26 12:06:14',NULL),(1382,7908,40720,1557,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',30000.04,NULL,NULL,1,'2024-11-26 12:07:32','2024-11-26 12:07:32',NULL),(1383,7908,40720,1557,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',20003.98,NULL,NULL,1,'2024-11-26 12:09:00','2024-11-26 12:09:00',NULL),(1384,7908,40720,1557,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',49999.92,NULL,NULL,1,'2024-11-26 12:09:58','2024-11-26 12:11:14','2024-11-26 12:11:14'),(1385,7908,40720,1557,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',49999.92,NULL,NULL,1,'2024-11-26 12:11:14','2024-11-26 12:12:39','2024-11-26 12:12:39'),(1386,7908,40720,1557,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',25000.04,NULL,NULL,1,'2024-11-26 12:12:39','2024-11-26 12:12:39',NULL),(1387,7908,40720,1557,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',20000.02,NULL,NULL,1,'2024-11-26 12:14:41','2024-11-26 12:14:41',NULL);
INSERT INTO `balance_libro` VALUES (1388,7908,40720,1557,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',30011.01,NULL,NULL,1,'2024-11-26 12:20:21','2024-11-26 12:20:21',NULL),(1389,7908,40720,1557,15,1248,'App\\Models\\PeriodLiquidation',NULL,1248,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',5511141.62,NULL,NULL,1,'2024-11-26 12:23:37','2024-11-26 12:25:08','2024-11-26 12:25:08'),(1390,7908,40720,1557,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',40311.36,NULL,NULL,1,'2024-11-26 12:25:44','2024-11-26 12:25:44',NULL),(1391,7908,40720,1557,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',1301341.39,NULL,NULL,1,'2024-11-26 12:25:57','2024-11-26 12:25:57',NULL),(1392,7908,40720,1557,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',219320.97,NULL,NULL,1,'2024-11-26 12:26:13','2024-11-26 12:26:13',NULL),(1393,7908,40720,1557,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',55419.82,NULL,NULL,1,'2024-11-26 12:26:24','2024-11-26 12:26:24',NULL),(1394,7908,40720,1557,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',453750.00,NULL,NULL,1,'2024-11-26 12:27:41','2024-11-26 12:27:41',NULL),(1395,7908,40720,1557,15,1255,'App\\Models\\PeriodLiquidation',NULL,1255,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',5511141.62,NULL,NULL,1,'2024-11-26 12:29:07','2024-11-26 12:29:07',NULL),(1396,7908,40720,1558,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',28000.01,NULL,NULL,1,'2025-01-03 19:35:12','2025-01-03 19:35:12',NULL),(1397,7908,40720,1559,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',7100.00,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 19:37:49',NULL),(1398,7908,40720,1559,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',32383.82,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 21:12:09','2025-01-03 21:12:09'),(1399,7908,40720,1559,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',5419.16,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 19:37:49',NULL),(1400,7908,40720,1559,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',254953.80,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 21:11:47','2025-01-03 21:11:47'),(1401,7908,40720,1559,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',58307.18,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 21:20:53','2025-01-03 21:20:53'),(1402,7908,40720,1559,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',58307.18,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 21:11:24','2025-01-03 21:11:24'),(1403,7908,40720,1559,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',196514.15,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 21:10:59','2025-01-03 21:10:59'),(1404,7908,40720,1559,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',251234.45,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 21:10:40','2025-01-03 21:10:40'),(1405,7908,40720,1559,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',108299.32,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 21:10:20','2025-01-03 21:10:20'),(1406,7908,40720,1559,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-16','2024-12-16',98481.14,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 21:09:46','2025-01-03 21:09:46'),(1407,7908,40720,1559,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',20205145.00,NULL,NULL,1,'2025-01-03 19:37:49','2025-04-22 19:16:13','2025-04-22 19:16:13');
INSERT INTO `balance_libro` VALUES (1408,7908,40720,1559,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',16066982.25,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 20:55:18','2025-01-03 20:55:18'),(1409,7908,40720,1559,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',23800.00,NULL,NULL,1,'2025-01-03 19:37:49','2025-01-03 19:37:49',NULL),(1410,7908,40720,1559,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',370250.00,NULL,NULL,1,'2025-01-03 19:37:50','2025-01-03 21:00:27','2025-01-03 21:00:27'),(1411,7908,40720,1559,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',186876.86,NULL,NULL,1,'2025-01-03 19:37:50','2025-01-03 21:09:24','2025-01-03 21:09:24'),(1412,7908,40720,1559,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',256193.66,NULL,NULL,1,'2025-01-03 19:37:50','2025-01-03 20:54:41','2025-01-03 20:54:41'),(1413,7908,40720,1559,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',59022.43,NULL,NULL,1,'2025-01-03 19:37:50','2025-01-03 21:09:04','2025-01-03 21:09:04'),(1414,7908,40720,1559,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',28000.01,NULL,NULL,1,'2025-01-03 19:37:50','2025-01-03 19:37:50',NULL),(1415,7908,40720,1558,7,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',564174.17,NULL,NULL,1,'2025-01-03 19:52:17','2025-01-03 19:52:17',NULL),(1416,7908,40720,1558,7,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',348297.02,NULL,NULL,1,'2025-01-03 19:52:17','2025-01-03 19:52:17',NULL),(1417,7908,40720,1559,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',13182518.26,NULL,NULL,1,'2025-01-03 20:07:54','2025-01-03 20:21:44','2025-01-03 20:21:44'),(1418,7908,40720,1559,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',13182518.26,NULL,NULL,1,'2025-01-03 20:21:44','2025-01-03 20:22:05','2025-01-03 20:22:05'),(1419,7908,40720,1559,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',13182518.26,NULL,NULL,1,'2025-01-03 20:26:48','2025-01-03 20:26:48',NULL),(1420,7908,40720,1559,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',42585.18,NULL,NULL,1,'2025-01-03 20:33:17','2025-01-03 20:44:38','2025-01-03 20:44:38'),(1421,7908,40720,1559,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',42585.18,NULL,NULL,1,'2025-01-03 20:46:04','2025-01-03 20:54:16','2025-01-03 20:54:16'),(1422,7908,40720,1559,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',42585.18,NULL,NULL,1,'2025-01-03 20:54:16','2025-01-03 20:54:16',NULL),(1423,7908,40720,1559,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',254615.46,NULL,NULL,1,'2025-01-03 20:54:41','2025-01-03 20:54:41',NULL),(1424,7908,40720,1559,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',15968007.00,NULL,NULL,1,'2025-01-03 20:55:18','2025-01-03 20:55:18',NULL),(1425,7908,40720,1558,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',22575.70,NULL,NULL,1,'2025-01-03 20:56:18','2025-01-03 20:56:18',NULL),(1426,7908,40720,1558,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',5000.00,NULL,NULL,1,'2025-01-03 20:59:56','2025-01-03 20:59:56',NULL),(1427,7908,40720,1559,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',370250.01,NULL,NULL,1,'2025-01-03 21:00:27','2025-01-03 21:00:27',NULL);
INSERT INTO `balance_libro` VALUES (1428,7908,40720,1558,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',192334.82,NULL,NULL,1,'2025-01-03 21:02:18','2025-01-03 21:02:18',NULL),(1429,7908,40720,1558,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',150565.14,NULL,NULL,1,'2025-01-03 21:02:43','2025-01-03 21:02:43',NULL),(1430,7908,40720,1558,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',245882.59,NULL,NULL,1,'2025-01-03 21:03:06','2025-01-03 21:03:06',NULL),(1431,7908,40720,1558,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',57069.05,NULL,NULL,1,'2025-01-03 21:03:27','2025-01-03 21:03:27',NULL),(1432,7908,40720,1558,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',192334.82,NULL,NULL,1,'2025-01-03 21:03:46','2025-01-03 21:03:46',NULL),(1433,7908,40720,1558,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',124762.65,NULL,NULL,1,'2025-01-03 21:04:16','2025-01-03 21:04:16',NULL),(1434,7908,40720,1558,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',66471.75,NULL,NULL,1,'2025-01-03 21:04:51','2025-01-03 21:04:51',NULL),(1435,7908,40720,1558,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',74494.86,NULL,NULL,1,'2025-01-03 21:05:08','2025-01-03 21:05:08',NULL),(1436,7908,40720,1558,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',56471.91,NULL,NULL,1,'2025-01-03 21:05:27','2025-01-03 21:05:27',NULL),(1437,7908,40720,1558,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',380644.70,NULL,NULL,1,'2025-01-03 21:06:17','2025-01-03 21:06:17',NULL),(1438,7908,40720,1559,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',58661.41,NULL,NULL,1,'2025-01-03 21:09:04','2025-01-03 21:09:04',NULL),(1439,7908,40720,1559,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',185719.51,NULL,NULL,1,'2025-01-03 21:09:24','2025-01-03 21:09:24',NULL),(1440,7908,40720,1559,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-16','2024-12-16',97874.48,NULL,NULL,1,'2025-01-03 21:09:46','2025-01-03 21:10:04','2025-01-03 21:10:04'),(1441,7908,40720,1559,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-16','2024-12-16',97874.48,NULL,NULL,1,'2025-01-03 21:10:04','2025-01-03 21:10:04',NULL),(1442,7908,40720,1559,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',107640.03,NULL,NULL,1,'2025-01-03 21:10:20','2025-01-03 21:10:20',NULL),(1443,7908,40720,1559,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',249680.48,NULL,NULL,1,'2025-01-03 21:10:40','2025-01-03 21:10:40',NULL),(1444,7908,40720,1559,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',195305.62,NULL,NULL,1,'2025-01-03 21:10:59','2025-01-03 21:10:59',NULL),(1445,7908,40720,1559,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',57950.53,NULL,NULL,1,'2025-01-03 21:11:24','2025-01-03 21:11:24',NULL),(1446,7908,40720,1559,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',253379.45,NULL,NULL,1,'2025-01-03 21:11:47','2025-01-03 21:11:47',NULL),(1447,7908,40720,1559,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',32181.04,NULL,NULL,1,'2025-01-03 21:12:09','2025-01-03 21:12:09',NULL);
INSERT INTO `balance_libro` VALUES (1448,7908,40720,1559,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',57950.53,NULL,NULL,1,'2025-01-03 21:20:53','2025-01-03 21:20:53',NULL),(1449,7908,40720,1563,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',18020009.10,NULL,NULL,1,'2025-01-06 18:31:42','2025-01-06 18:31:42',NULL),(1450,7908,40720,1559,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',71561.96,NULL,NULL,1,'2025-01-06 19:34:49','2025-01-06 19:35:55','2025-01-06 19:35:55'),(1451,7908,40720,1558,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',71561.96,NULL,NULL,1,'2025-01-06 19:35:55','2025-01-06 19:35:55',NULL),(1452,7908,40720,1558,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',60008.06,NULL,NULL,1,'2025-01-06 19:38:13','2025-01-06 19:38:13',NULL),(1453,7908,40720,1558,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',50013.97,NULL,NULL,1,'2025-01-06 19:39:15','2025-01-06 19:39:15',NULL),(1454,7908,40720,1558,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',150035.14,NULL,NULL,1,'2025-01-06 19:40:29','2025-01-06 19:40:29',NULL),(1455,7908,40720,1558,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',50003.96,NULL,NULL,1,'2025-01-06 19:41:44','2025-01-06 19:41:44',NULL),(1456,7908,40720,1558,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',50065.01,NULL,NULL,1,'2025-01-06 19:42:37','2025-01-06 19:42:37',NULL),(1457,7908,40720,1558,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',99997.95,NULL,NULL,1,'2025-01-06 19:43:44','2025-01-06 19:43:44',NULL),(1458,7908,40720,1558,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',150002.96,NULL,NULL,1,'2025-01-06 19:44:42','2025-01-06 19:44:42',NULL),(1459,7908,40720,1558,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',30012.98,NULL,NULL,1,'2025-01-06 19:45:51','2025-01-06 19:45:51',NULL),(1460,7908,40720,1558,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',150033.04,NULL,NULL,1,'2025-01-06 19:46:48','2025-01-06 19:46:48',NULL),(1461,7908,40720,1558,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',29933.97,NULL,NULL,1,'2025-01-06 19:47:52','2025-01-06 19:47:52',NULL),(1462,7908,40720,1558,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',151204.02,NULL,NULL,1,'2025-01-06 19:48:46','2025-01-06 19:48:46',NULL),(1463,7908,40720,1558,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',30804.98,NULL,NULL,1,'2025-01-06 19:49:42','2025-01-06 19:49:42',NULL),(1464,7908,40720,1558,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',150019.99,NULL,NULL,1,'2025-01-06 19:51:48','2025-01-06 19:51:48',NULL),(1465,7908,40720,1558,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',50076.04,NULL,NULL,1,'2025-01-06 19:52:36','2025-01-06 19:52:36',NULL),(1466,7908,40720,1558,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',50020.01,NULL,NULL,1,'2025-01-06 19:53:34','2025-01-06 19:53:34',NULL),(1467,7908,40720,1558,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',40035.96,NULL,NULL,1,'2025-01-06 19:54:23','2025-01-06 19:54:23',NULL);
INSERT INTO `balance_libro` VALUES (1468,7908,40720,1558,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',150011.03,NULL,NULL,1,'2025-01-06 19:56:47','2025-01-06 19:56:47',NULL),(1469,7908,40720,1558,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',100010.00,NULL,NULL,1,'2025-01-06 19:59:25','2025-01-06 19:59:25',NULL),(1470,7908,40720,1558,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',100015.00,NULL,NULL,1,'2025-01-06 20:00:34','2025-01-06 20:00:34',NULL),(1471,7908,40720,1558,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-19','2024-11-19',100039.08,NULL,NULL,1,'2025-01-06 20:01:47','2025-01-06 20:01:47',NULL),(1472,7908,40720,1558,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',100014.05,NULL,NULL,1,'2025-01-06 20:03:00','2025-01-06 20:03:00',NULL),(1473,7908,40720,1558,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',100026.94,NULL,NULL,1,'2025-01-06 20:04:45','2025-01-06 20:04:45',NULL),(1474,7908,40720,1558,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-23','2024-11-23',30000.02,NULL,NULL,1,'2025-01-06 20:05:34','2025-01-06 20:05:34',NULL),(1475,7908,40720,1558,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',100024.98,NULL,NULL,1,'2025-01-06 20:06:23','2025-01-06 20:06:23',NULL),(1476,7908,40720,1558,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',30000.98,NULL,NULL,1,'2025-01-06 20:07:15','2025-01-06 20:07:15',NULL),(1477,7908,40720,1558,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',50046.01,NULL,NULL,1,'2025-01-06 20:08:19','2025-01-06 20:08:19',NULL),(1478,7908,40720,1558,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',152087.04,NULL,NULL,1,'2025-01-06 20:09:17','2025-01-06 20:09:17',NULL),(1479,7908,40720,1558,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',50241.01,NULL,NULL,1,'2025-01-06 20:10:09','2025-01-06 20:10:09',NULL),(1480,7908,40720,1558,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',30000.99,NULL,NULL,1,'2025-01-06 20:11:05','2025-01-06 20:11:05',NULL),(1481,7908,40720,1558,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',40022.95,NULL,NULL,1,'2025-01-06 20:12:01','2025-01-06 20:12:01',NULL),(1482,7908,40720,1558,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-03','2024-11-03',30018.02,NULL,NULL,1,'2025-01-07 11:32:44','2025-01-07 11:32:44',NULL),(1483,7908,40720,1558,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',49999.91,NULL,NULL,1,'2025-01-07 11:34:47','2025-01-07 11:34:47',NULL),(1484,7908,40720,1558,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-17','2024-11-17',54994.10,NULL,NULL,1,'2025-01-07 11:37:49','2025-01-07 11:37:49',NULL),(1485,7908,40720,1558,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',30006.07,NULL,NULL,1,'2025-01-07 11:39:28','2025-01-07 11:39:28',NULL),(1486,7908,40720,1558,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-17','2024-11-17',40009.03,NULL,NULL,1,'2025-01-07 11:41:24','2025-01-07 11:41:24',NULL),(1487,7908,40720,1558,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',300000.01,NULL,NULL,1,'2025-01-07 11:46:03','2025-01-07 11:46:03',NULL),(1488,7908,40720,1559,7,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',835091.65,NULL,NULL,1,'2025-01-07 12:39:01','2025-01-07 12:39:01',NULL);
INSERT INTO `balance_libro` VALUES (1489,7908,40720,1559,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',100096.00,NULL,NULL,1,'2025-01-07 12:55:25','2025-01-07 12:55:25',NULL),(1490,7908,40720,1559,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',150043.04,NULL,NULL,1,'2025-01-07 12:56:16','2025-01-07 12:56:16',NULL),(1491,7908,40720,1559,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',31135.98,NULL,NULL,1,'2025-01-07 12:57:09','2025-01-07 12:57:09',NULL),(1492,7908,40720,1559,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-10','2024-12-10',50010.05,NULL,NULL,1,'2025-01-07 12:57:58','2025-01-07 12:57:58',NULL),(1493,7908,40720,1559,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',30017.01,NULL,NULL,1,'2025-01-07 12:58:49','2025-01-07 12:58:49',NULL),(1494,7908,40720,1559,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',100013.04,NULL,NULL,1,'2025-01-07 12:59:30','2025-01-07 12:59:30',NULL),(1495,7908,40720,1559,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',50006.00,NULL,NULL,1,'2025-01-07 13:00:28','2025-01-07 13:00:28',NULL),(1496,7908,40720,1559,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',150000.95,NULL,NULL,1,'2025-01-07 13:01:21','2025-01-07 13:01:21',NULL),(1497,7908,40720,1559,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-09','2024-12-09',50001.96,NULL,NULL,1,'2025-01-07 13:02:14','2025-01-07 13:02:14',NULL),(1498,7908,40720,1559,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-07','2024-12-07',30011.02,NULL,NULL,1,'2025-01-07 13:02:56','2025-01-07 13:02:56',NULL),(1499,7908,40720,1559,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',29999.97,NULL,NULL,1,'2025-01-07 13:03:35','2025-01-07 13:03:35',NULL),(1500,7908,40720,1559,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',10013.03,NULL,NULL,1,'2025-01-07 13:04:11','2025-01-07 13:04:11',NULL),(1501,7908,40720,1559,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-14','2024-12-14',30017.98,NULL,NULL,1,'2025-01-07 13:04:59','2025-01-07 13:04:59',NULL),(1502,7908,40720,1559,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',150019.03,NULL,NULL,1,'2025-01-07 13:06:02','2025-01-07 13:06:02',NULL),(1503,7908,40720,1559,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',50000.96,NULL,NULL,1,'2025-01-07 13:06:47','2025-01-07 13:06:47',NULL),(1504,7908,40720,1559,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-22','2024-12-22',30005.06,NULL,NULL,1,'2025-01-07 13:07:32','2025-01-07 13:07:32',NULL),(1505,7908,40720,1559,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',200007.02,NULL,NULL,1,'2025-01-07 13:08:30','2025-01-07 13:08:30',NULL),(1506,7908,40720,1559,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',150025.97,NULL,NULL,1,'2025-01-07 13:09:27','2025-01-07 13:09:27',NULL),(1507,7908,40720,1559,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',100008.04,NULL,NULL,1,'2025-01-07 13:10:13','2025-01-07 13:10:13',NULL),(1508,7908,40720,1559,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-10','2024-12-10',140016.95,NULL,NULL,1,'2025-01-07 13:10:57','2025-01-07 13:10:57',NULL),(1509,7908,40720,1559,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',99996.00,NULL,NULL,1,'2025-01-07 13:12:18','2025-01-07 13:12:18',NULL);
INSERT INTO `balance_libro` VALUES (1510,7908,40720,1559,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',24035.95,NULL,NULL,1,'2025-01-07 13:14:17','2025-01-07 13:14:17',NULL),(1511,7908,40720,1559,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',40092.99,NULL,NULL,1,'2025-01-07 13:16:08','2025-01-07 13:16:08',NULL),(1512,7908,40720,1559,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',40011.00,NULL,NULL,1,'2025-01-07 13:17:25','2025-01-07 13:17:25',NULL),(1513,7908,40720,1559,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',249996.06,NULL,NULL,1,'2025-01-07 13:18:48','2025-01-07 13:18:48',NULL),(1514,7908,40720,1559,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',150012.97,NULL,NULL,1,'2025-01-07 13:20:11','2025-01-07 13:20:11',NULL),(1515,7908,40720,1559,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',100044.03,NULL,NULL,1,'2025-01-07 13:21:29','2025-01-07 13:21:29',NULL),(1516,7908,40720,1559,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-14','2024-12-14',150574.97,NULL,NULL,1,'2025-01-07 13:22:15','2025-01-07 13:22:15',NULL),(1517,7908,40720,1559,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-14','2024-12-14',150030.01,NULL,NULL,1,'2025-01-07 13:23:04','2025-01-07 13:23:04',NULL),(1518,7908,40720,1559,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-18','2024-12-18',150091.05,NULL,NULL,1,'2025-01-07 13:24:08','2025-01-07 13:24:08',NULL),(1519,7908,40720,1559,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',50018.05,NULL,NULL,1,'2025-01-07 13:24:52','2025-01-07 13:24:52',NULL),(1520,7908,40720,1559,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',30007.00,NULL,NULL,1,'2025-01-07 13:25:31','2025-01-07 13:25:31',NULL),(1521,7908,40720,1559,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',160041.06,NULL,NULL,1,'2025-01-07 13:26:13','2025-01-07 13:26:13',NULL),(1522,7908,40720,1559,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',50055.02,NULL,NULL,1,'2025-01-07 13:26:52','2025-01-07 13:26:52',NULL),(1523,7908,40720,1559,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',150048.04,NULL,NULL,1,'2025-01-07 13:27:29','2025-01-07 13:27:29',NULL),(1524,7908,40720,1559,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',100034.99,NULL,NULL,1,'2025-01-07 13:28:08','2025-01-07 13:28:08',NULL),(1525,7908,40720,1559,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',50036.03,NULL,NULL,1,'2025-01-07 13:28:50','2025-01-07 13:28:50',NULL),(1526,7908,40720,1559,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',150045.97,NULL,NULL,1,'2025-01-07 13:29:38','2025-01-07 13:29:38',NULL),(1527,7908,40720,1559,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',100050.99,NULL,NULL,1,'2025-01-07 13:30:26','2025-01-07 13:30:26',NULL),(1528,7908,40720,1559,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',100013.04,NULL,NULL,1,'2025-01-07 13:31:24','2025-01-07 13:31:24',NULL),(1529,7908,40720,1558,15,1393,'App\\Models\\PeriodLiquidation',NULL,1393,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',6031401.61,NULL,NULL,1,'2025-01-07 17:45:45','2025-01-07 17:45:45',NULL);
INSERT INTO `balance_libro` VALUES (1530,7908,40720,1559,15,1395,'App\\Models\\PeriodLiquidation',NULL,1395,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',11108034.81,NULL,NULL,1,'2025-01-07 18:06:31','2025-04-22 19:13:08','2025-04-22 19:13:08'),(1531,7908,40720,1564,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',19810502.44,NULL,NULL,1,'2025-02-03 18:48:11','2025-02-03 18:48:11',NULL),(1532,7908,40720,1563,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',199696.18,NULL,NULL,1,'2025-02-03 19:11:33','2025-02-03 19:11:33',NULL),(1533,7908,40720,1563,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-11','2025-01-11',4500.00,NULL,NULL,1,'2025-02-03 19:11:33','2025-02-03 19:12:44','2025-02-03 19:12:44'),(1534,7908,40720,1563,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',249129.72,NULL,NULL,1,'2025-02-03 19:11:33','2025-02-03 19:15:42','2025-02-03 19:15:42'),(1535,7908,40720,1563,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',59737.68,NULL,NULL,1,'2025-02-03 19:11:33','2025-02-03 19:15:22','2025-02-03 19:15:22'),(1536,7908,40720,1563,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',130028.75,NULL,NULL,1,'2025-02-03 19:11:33','2025-02-03 19:15:05','2025-02-03 19:15:05'),(1537,7908,40720,1563,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',212417.61,NULL,NULL,1,'2025-02-03 19:11:34','2025-02-03 19:14:38','2025-02-03 19:14:38'),(1538,7908,40720,1563,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',60138.22,NULL,NULL,1,'2025-02-03 19:11:34','2025-02-03 19:14:17','2025-02-03 19:14:17'),(1539,7908,40720,1563,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',166352.28,NULL,NULL,1,'2025-02-03 19:11:34','2025-02-03 19:13:55','2025-02-03 19:13:55'),(1540,7908,40720,1563,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-11','2025-01-11',4499.99,NULL,NULL,1,'2025-02-03 19:12:44','2025-02-03 19:12:44',NULL),(1541,7908,40720,1563,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',165322.30,NULL,NULL,1,'2025-02-03 19:13:55','2025-02-03 19:13:55',NULL),(1542,7908,40720,1563,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',59770.37,NULL,NULL,1,'2025-02-03 19:14:17','2025-02-03 19:14:17',NULL),(1543,7908,40720,1563,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',211103.86,NULL,NULL,1,'2025-02-03 19:14:38','2025-02-03 19:14:38',NULL),(1544,7908,40720,1563,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',129227.75,NULL,NULL,1,'2025-02-03 19:15:05','2025-02-03 19:15:05',NULL),(1545,7908,40720,1563,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',59372.28,NULL,NULL,1,'2025-02-03 19:15:22','2025-02-03 19:15:22',NULL),(1546,7908,40720,1563,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',247595.04,NULL,NULL,1,'2025-02-03 19:15:42','2025-02-03 19:15:42',NULL),(1547,7908,40720,1563,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-24','2025-01-24',100015.05,NULL,NULL,1,'2025-02-26 14:29:04','2025-03-14 13:08:52','2025-03-14 13:08:52'),(1548,7908,40720,1563,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-26','2025-01-26',40004.07,NULL,NULL,1,'2025-02-26 14:33:12','2025-03-14 13:08:26','2025-03-14 13:08:26'),(1549,7908,40720,1563,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-24','2025-01-24',100015.05,NULL,NULL,1,'2025-03-14 13:50:53','2025-03-14 13:55:29','2025-03-14 13:55:29');
INSERT INTO `balance_libro` VALUES (1550,7908,40720,1563,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-26','2025-01-26',40004.07,NULL,NULL,1,'2025-03-14 13:50:53','2025-03-14 13:55:28','2025-03-14 13:55:28'),(1551,7908,40720,1563,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',99700.06,NULL,NULL,1,'2025-03-14 17:27:29','2025-03-14 17:27:29',NULL),(1552,7908,40720,1563,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',100030.01,NULL,NULL,1,'2025-03-14 17:27:29','2025-03-14 17:27:29',NULL),(1553,7908,40720,1563,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',30004.04,NULL,NULL,1,'2025-03-14 17:27:29','2025-03-14 17:27:29',NULL),(1554,7908,40720,1563,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-14','2025-01-14',160094.97,NULL,NULL,1,'2025-03-14 17:27:29','2025-03-14 17:27:29',NULL),(1555,7908,40720,1563,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',50007.96,NULL,NULL,1,'2025-03-14 17:27:29','2025-03-14 17:27:29',NULL),(1556,7908,40720,1563,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-18','2025-01-18',29998.95,NULL,NULL,1,'2025-03-14 17:27:29','2025-03-14 17:27:29',NULL),(1557,7908,40720,1563,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-18','2025-01-18',99997.98,NULL,NULL,1,'2025-03-14 17:27:29','2025-03-14 17:27:29',NULL),(1558,7908,40720,1563,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',100071.00,NULL,NULL,1,'2025-03-14 17:27:29','2025-03-14 17:27:29',NULL),(1559,7908,40720,1563,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',47472.53,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1560,7908,40720,1563,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',149998.96,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1561,7908,40720,1563,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',30002.99,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1562,7908,40720,1563,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',150041.96,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1563,7908,40720,1563,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',150008.07,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1564,7908,40720,1563,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',50007.96,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1565,7908,40720,1563,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',150009.99,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1566,7908,40720,1563,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',151619.89,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1567,7908,40720,1563,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',149997.97,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1568,7908,40720,1563,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',150073.99,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1569,7908,40720,1563,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-05','2025-01-05',40008.93,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL);
INSERT INTO `balance_libro` VALUES (1570,7908,40720,1563,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',70009.00,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1571,7908,40720,1563,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-12','2025-01-12',29996.93,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1572,7908,40720,1563,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-25','2025-01-25',50020.04,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1573,7908,40720,1563,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-24','2025-01-24',100015.05,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1574,7908,40720,1563,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-26','2025-01-26',40004.07,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1575,7908,40720,1563,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',29999.94,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1576,7908,40720,1563,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',100042.96,NULL,NULL,1,'2025-03-14 17:27:30','2025-03-14 17:27:30',NULL),(1577,7908,40720,1563,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',19995.06,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1578,7908,40720,1563,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',100004.96,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1579,7908,40720,1563,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',29996.96,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1580,7908,40720,1563,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-30','2025-01-30',100040.97,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1581,7908,40720,1563,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-07','2025-01-07',29996.96,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1582,7908,40720,1563,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-07','2025-01-07',100015.03,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1583,7908,40720,1563,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',149865.02,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1584,7908,40720,1563,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',50020.04,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1585,7908,40720,1563,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',150096.02,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1586,7908,40720,1563,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',50010.01,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1587,7908,40720,1563,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-09','2025-01-09',99994.98,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1588,7908,40720,1563,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',150021.02,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1589,7908,40720,1563,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-11','2025-01-11',150049.07,NULL,NULL,1,'2025-03-14 17:27:31','2025-03-14 17:27:31',NULL),(1590,7908,40720,1564,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',30000.04,NULL,NULL,1,'2025-03-14 21:04:32','2025-03-14 21:04:32',NULL);
INSERT INTO `balance_libro` VALUES (1591,7908,40720,1564,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',50000.96,NULL,NULL,1,'2025-03-14 21:04:32','2025-03-14 21:04:32',NULL),(1592,7908,40720,1564,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',25056.94,NULL,NULL,1,'2025-03-14 21:04:32','2025-03-14 21:04:32',NULL),(1593,7908,40720,1564,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-14','2025-02-14',80021.04,NULL,NULL,1,'2025-03-14 21:04:32','2025-03-14 21:04:32',NULL),(1594,7908,40720,1564,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',49995.95,NULL,NULL,1,'2025-03-14 21:04:32','2025-03-14 21:04:32',NULL),(1595,7908,40720,1564,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-11','2025-02-11',50011.06,NULL,NULL,1,'2025-03-14 21:04:32','2025-03-14 21:04:32',NULL),(1596,7908,40720,1564,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-09','2025-02-09',25001.06,NULL,NULL,1,'2025-03-14 21:04:32','2025-03-14 21:04:32',NULL),(1597,7908,40720,1564,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',100014.03,NULL,NULL,1,'2025-03-14 21:04:32','2025-03-14 21:04:32',NULL),(1598,7908,40720,1564,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',25017.05,NULL,NULL,1,'2025-03-14 21:04:33','2025-03-14 21:04:33',NULL),(1599,7908,40720,1564,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',108996.05,NULL,NULL,1,'2025-03-14 21:04:33','2025-03-14 21:04:33',NULL),(1600,7908,40720,1564,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-08','2025-02-08',10018.05,NULL,NULL,1,'2025-03-14 21:04:33','2025-03-14 21:04:33',NULL),(1601,7908,40720,1564,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',35993.93,NULL,NULL,1,'2025-03-14 21:04:33','2025-03-14 21:04:33',NULL),(1602,7908,40720,1564,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',30009.98,NULL,NULL,1,'2025-03-14 21:04:33','2025-03-14 21:04:33',NULL),(1603,7908,40720,1563,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-30','2025-01-30',28000.01,NULL,NULL,1,'2025-03-14 21:13:28','2025-03-14 21:13:28',NULL),(1604,7908,40720,1563,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',8299.99,NULL,NULL,1,'2025-03-25 18:40:27','2025-03-25 18:40:27',NULL),(1605,7908,40720,1563,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',11000.01,NULL,NULL,1,'2025-03-25 18:41:14','2025-03-25 18:41:14',NULL),(1606,7908,40720,1563,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',30009.41,NULL,NULL,1,'2025-03-25 18:43:44','2025-03-25 18:43:44',NULL),(1607,7908,40720,1563,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',19999.99,NULL,NULL,1,'2025-03-25 18:47:28','2025-03-25 18:47:28',NULL),(1608,7908,40720,1563,15,1429,'App\\Models\\PeriodLiquidation',NULL,1429,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',10585412.03,NULL,NULL,1,'2025-03-25 20:24:31','2025-03-25 20:24:31',NULL),(1609,7908,40720,1564,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',60324.19,NULL,NULL,1,'2025-03-25 20:52:10','2025-03-27 19:35:00','2025-03-27 19:35:00'),(1610,7908,40720,1564,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',166866.69,NULL,NULL,1,'2025-03-25 20:52:10','2025-03-27 19:34:41','2025-03-27 19:34:41');
INSERT INTO `balance_libro` VALUES (1611,7908,40720,1564,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',134839.24,NULL,NULL,1,'2025-03-25 20:52:10','2025-03-27 19:34:14','2025-03-27 19:34:14'),(1612,7908,40720,1564,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',1299568.02,NULL,NULL,1,'2025-03-25 20:52:10','2025-03-27 19:30:02','2025-03-27 19:30:02'),(1613,7908,40720,1564,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',809024.89,NULL,NULL,1,'2025-03-25 20:52:10','2025-03-27 19:28:15','2025-03-27 19:28:15'),(1614,7908,40720,1564,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',269678.48,NULL,NULL,1,'2025-03-25 20:52:10','2025-03-27 19:27:35','2025-03-27 19:27:35'),(1615,7908,40720,1564,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',647215.70,NULL,NULL,1,'2025-03-25 20:52:10','2025-03-27 19:27:14','2025-03-27 19:27:14'),(1616,7908,40720,1564,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-08','2025-02-08',13387.00,NULL,NULL,1,'2025-03-25 20:52:10','2025-03-25 20:52:10',NULL),(1617,7908,40720,1564,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-12','2025-02-12',121015.00,NULL,NULL,1,'2025-03-25 20:52:11','2025-03-27 19:31:23','2025-03-27 19:31:23'),(1618,7908,40720,1564,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',38712.00,NULL,NULL,1,'2025-03-25 20:52:11','2025-03-25 20:52:11',NULL),(1619,7908,40720,1564,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',70599.26,NULL,NULL,1,'2025-03-25 20:52:11','2025-03-27 19:32:36','2025-03-27 19:32:36'),(1620,7908,40720,1564,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',33552.91,NULL,NULL,1,'2025-03-25 20:52:11','2025-03-25 20:52:11',NULL),(1621,7908,40720,1564,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',33552.91,NULL,NULL,1,'2025-03-25 20:52:11','2025-03-25 20:52:11',NULL),(1622,7908,40720,1564,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',41066.79,NULL,NULL,1,'2025-03-25 20:52:11','2025-03-27 19:26:48','2025-03-27 19:26:48'),(1623,7908,40720,1564,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',97830.75,NULL,NULL,1,'2025-03-25 20:52:11','2025-03-27 19:33:44','2025-03-27 19:33:44'),(1624,7908,40720,1564,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',28000.01,NULL,NULL,1,'2025-03-25 20:52:11','2025-03-25 20:52:11',NULL),(1625,7908,40720,1564,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-19','2025-02-19',70000.08,NULL,NULL,1,'2025-03-26 13:51:34','2025-03-26 13:51:34',NULL),(1626,7908,40720,1564,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-23','2025-02-23',50000.06,NULL,NULL,1,'2025-03-26 13:53:31','2025-03-26 13:53:31',NULL),(1627,7908,40720,1564,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',80005.07,NULL,NULL,1,'2025-03-26 13:55:37','2025-03-26 13:55:37',NULL),(1628,7908,40720,1564,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',50000.06,NULL,NULL,1,'2025-03-26 13:58:14','2025-03-26 13:58:14',NULL),(1629,7908,40720,1564,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',40813.81,NULL,NULL,1,'2025-03-27 19:26:48','2025-03-27 19:26:48',NULL),(1630,7908,40720,1564,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',643228.74,NULL,NULL,1,'2025-03-27 19:27:14','2025-03-27 19:27:14',NULL);
INSERT INTO `balance_libro` VALUES (1631,7908,40720,1564,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',268011.98,NULL,NULL,1,'2025-03-27 19:27:35','2025-03-27 19:27:35',NULL),(1632,7908,40720,1564,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',804035.93,NULL,NULL,1,'2025-03-27 19:28:15','2025-03-27 19:28:15',NULL),(1633,7908,40720,1564,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',1291562.47,NULL,NULL,1,'2025-03-27 19:30:02','2025-03-27 19:30:02',NULL),(1634,7908,40720,1564,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-12','2025-02-12',109036.34,NULL,NULL,1,'2025-03-27 19:31:23','2025-03-27 19:31:23',NULL),(1635,7908,40720,1564,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',70599.24,NULL,NULL,1,'2025-03-27 19:32:36','2025-03-27 19:32:36',NULL),(1636,7908,40720,1564,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',97228.10,NULL,NULL,1,'2025-03-27 19:33:44','2025-03-27 19:33:44',NULL),(1637,7908,40720,1564,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',134005.99,NULL,NULL,1,'2025-03-27 19:34:14','2025-03-27 19:34:14',NULL),(1638,7908,40720,1564,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',165833.53,NULL,NULL,1,'2025-03-27 19:34:41','2025-03-27 19:34:41',NULL),(1639,7908,40720,1564,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',59955.20,NULL,NULL,1,'2025-03-27 19:35:00','2025-03-27 19:35:00',NULL),(1640,7908,40720,1564,15,1454,'App\\Models\\PeriodLiquidation',NULL,1454,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',8255717.04,NULL,NULL,1,'2025-03-27 19:54:13','2025-03-27 19:54:44','2025-03-27 19:54:44'),(1641,7908,40720,1564,9,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',5239072.10,NULL,NULL,1,'2025-03-27 19:58:42','2025-03-27 20:01:54','2025-03-27 20:01:54'),(1642,7908,40720,1564,9,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',5239072.10,NULL,NULL,1,'2025-03-27 19:59:17','2025-03-27 20:03:34','2025-03-27 20:03:34'),(1643,7908,40720,1564,9,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',5239072.10,NULL,NULL,1,'2025-03-27 19:59:44','2025-03-27 20:03:48','2025-03-27 20:03:48'),(1644,7908,40720,1564,9,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',5239072.10,NULL,NULL,1,'2025-03-27 20:00:32','2025-03-27 20:00:32',NULL),(1645,7908,40720,1564,15,1462,'App\\Models\\PeriodLiquidation',NULL,1462,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',3438186.37,NULL,NULL,1,'2025-03-27 20:05:57','2025-03-27 20:05:57',NULL),(1646,7908,40720,1565,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',6632.64,NULL,NULL,1,'2025-04-08 14:46:48','2025-04-08 14:46:48',NULL),(1647,7908,40720,1565,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',20247.93,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:27:30','2025-04-25 12:27:30'),(1648,7908,40720,1565,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',168726.48,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:39:26','2025-04-25 12:39:26'),(1649,7908,40720,1565,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',46544.23,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:29:17','2025-04-25 12:29:17'),(1650,7908,40720,1565,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',168726.48,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:38:27','2025-04-25 12:38:27');
INSERT INTO `balance_libro` VALUES (1651,7908,40720,1565,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',136277.44,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:37:43','2025-04-25 12:37:43'),(1652,7908,40720,1565,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',127195.12,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:37:20','2025-04-25 12:37:20'),(1653,7908,40720,1565,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',168726.48,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:37:00','2025-04-25 12:37:00'),(1654,7908,40720,1565,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',26000.00,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-08 14:46:49',NULL),(1655,7908,40720,1565,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',123409.22,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:36:18','2025-04-25 12:36:18'),(1656,7908,40720,1565,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',168884.76,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:35:53','2025-04-25 12:35:53'),(1657,7908,40720,1565,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-19','2025-03-19',123640.54,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:46:41','2025-04-25 12:46:41'),(1658,7908,40720,1565,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',52442.15,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:30:21','2025-04-25 12:30:21'),(1659,7908,40720,1565,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',137012.52,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:35:29','2025-04-25 12:35:29'),(1660,7908,40720,1565,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',123958.61,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:34:59','2025-04-25 12:34:59'),(1661,7908,40720,1565,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',124016.44,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:33:58','2025-04-25 12:33:58'),(1662,7908,40720,1565,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',61354.15,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:33:20','2025-04-25 12:33:20'),(1663,7908,40720,1565,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',169715.73,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:32:43','2025-04-25 12:32:43'),(1664,7908,40720,1565,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',255871.02,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:32:21','2025-04-25 12:32:21'),(1665,7908,40720,1565,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',151666.28,NULL,NULL,1,'2025-04-08 14:46:49','2025-04-25 12:31:57','2025-04-25 12:31:57'),(1666,7908,40720,1565,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',51445000.00,NULL,NULL,1,'2025-04-08 14:46:50','2025-04-08 14:46:50',NULL),(1667,7908,40720,1565,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',28000.01,NULL,NULL,1,'2025-04-08 14:46:50','2025-04-08 14:46:50',NULL),(1668,7908,40720,1565,7,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',1090569.38,NULL,NULL,1,'2025-04-14 19:36:00','2025-04-14 19:36:00',NULL),(1669,7908,40720,1565,7,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',1267665.00,NULL,NULL,1,'2025-04-14 19:36:00','2025-04-25 12:53:28','2025-04-25 12:53:28');
INSERT INTO `balance_libro` VALUES (1670,7908,40720,1565,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',14608330.00,NULL,NULL,1,'2025-04-14 19:53:53','2025-04-25 20:09:03','2025-04-25 20:09:03'),(1671,7908,40720,1565,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',12567513.75,NULL,NULL,1,'2025-04-14 19:57:07','2025-04-25 20:08:40','2025-04-25 20:08:40'),(1672,7908,40720,1559,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',20205145.01,NULL,NULL,1,'2025-04-22 19:16:13','2025-04-22 19:16:13',NULL),(1673,7908,40720,1559,15,1395,'App\\Models\\PeriodLiquidation',NULL,1395,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',11108034.81,NULL,NULL,1,'2025-04-22 19:17:36','2025-04-22 19:17:36',NULL),(1674,7908,40720,1565,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',20000.01,NULL,NULL,1,'2025-04-25 12:27:30','2025-04-25 12:27:30',NULL),(1675,7908,40720,1565,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',45145.10,NULL,NULL,1,'2025-04-25 12:29:17','2025-04-25 12:29:17',NULL),(1676,7908,40720,1565,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',52119.10,NULL,NULL,1,'2025-04-25 12:30:21','2025-04-25 12:30:51','2025-04-25 12:30:51'),(1677,7908,40720,1565,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',52119.10,NULL,NULL,1,'2025-04-25 12:30:51','2025-04-25 12:30:51',NULL),(1678,7908,40720,1565,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',150731.99,NULL,NULL,1,'2025-04-25 12:31:57','2025-04-25 12:31:57',NULL),(1679,7908,40720,1565,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',254294.81,NULL,NULL,1,'2025-04-25 12:32:21','2025-04-25 12:32:21',NULL),(1680,7908,40720,1565,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',168664.93,NULL,NULL,1,'2025-04-25 12:32:43','2025-04-25 12:32:58','2025-04-25 12:32:58'),(1681,7908,40720,1565,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',168664.92,NULL,NULL,1,'2025-04-25 12:32:58','2025-04-25 12:32:58',NULL),(1682,7908,40720,1565,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',60978.86,NULL,NULL,1,'2025-04-25 12:33:20','2025-04-25 12:33:20',NULL),(1683,7908,40720,1565,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',123255.14,NULL,NULL,1,'2025-04-25 12:33:58','2025-04-25 12:33:58',NULL),(1684,7908,40720,1565,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',123197.66,NULL,NULL,1,'2025-04-25 12:34:59','2025-04-25 12:34:59',NULL),(1685,7908,40720,1565,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',136165.84,NULL,NULL,1,'2025-04-25 12:35:29','2025-04-25 12:35:29',NULL),(1686,7908,40720,1565,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',167839.10,NULL,NULL,1,'2025-04-25 12:35:53','2025-04-25 12:35:53',NULL),(1687,7908,40720,1565,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',122651.65,NULL,NULL,1,'2025-04-25 12:36:18','2025-04-25 12:36:31','2025-04-25 12:36:31'),(1688,7908,40720,1565,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',122651.65,NULL,NULL,1,'2025-04-25 12:36:31','2025-04-25 12:36:31',NULL),(1689,7908,40720,1565,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',167681.80,NULL,NULL,1,'2025-04-25 12:37:00','2025-04-25 12:37:00',NULL);
INSERT INTO `balance_libro` VALUES (1690,7908,40720,1565,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',126406.28,NULL,NULL,1,'2025-04-25 12:37:20','2025-04-25 12:37:20',NULL),(1691,7908,40720,1565,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',135435.30,NULL,NULL,1,'2025-04-25 12:37:43','2025-04-25 12:37:58','2025-04-25 12:37:58'),(1692,7908,40720,1565,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',135435.30,NULL,NULL,1,'2025-04-25 12:37:58','2025-04-25 12:37:58',NULL),(1693,7908,40720,1565,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',167681.80,NULL,NULL,1,'2025-04-25 12:38:27','2025-04-25 12:38:27',NULL),(1694,7908,40720,1565,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',167681.80,NULL,NULL,1,'2025-04-25 12:39:26','2025-04-25 12:39:26',NULL),(1695,7908,40720,1565,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-19','2025-03-19',122881.55,NULL,NULL,1,'2025-04-25 12:46:41','2025-04-25 12:46:41',NULL),(1696,7908,40720,1565,7,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',1267665.00,NULL,NULL,1,'2025-04-25 12:53:28','2025-04-25 12:53:28',NULL),(1697,7908,40720,1565,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-12','2025-03-12',100319.02,NULL,NULL,1,'2025-04-25 18:31:57','2025-04-25 18:31:57',NULL),(1698,7908,40720,1565,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',40049.01,NULL,NULL,1,'2025-04-25 18:33:37','2025-04-25 18:33:37',NULL),(1699,7908,40720,1565,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',40000.99,NULL,NULL,1,'2025-04-25 18:36:10','2025-04-25 18:36:10',NULL),(1700,7908,40720,1565,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-05','2025-03-05',30003.00,NULL,NULL,1,'2025-04-25 18:37:45','2025-04-25 18:37:45',NULL),(1701,7908,40720,1565,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',50087.99,NULL,NULL,1,'2025-04-25 18:38:45','2025-04-25 18:38:45',NULL),(1702,7908,40720,1565,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',50030.97,NULL,NULL,1,'2025-04-25 18:39:46','2025-04-25 18:39:46',NULL),(1703,7908,40720,1565,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',19989.04,NULL,NULL,1,'2025-04-25 18:40:59','2025-04-25 18:40:59',NULL),(1704,7908,40720,1565,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',19999.95,NULL,NULL,1,'2025-04-25 18:42:06','2025-04-25 18:42:06',NULL),(1705,7908,40720,1565,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',50000.03,NULL,NULL,1,'2025-04-25 18:43:04','2025-04-25 18:43:04',NULL),(1706,7908,40720,1565,3,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',50032.00,NULL,NULL,1,'2025-04-25 18:44:25','2025-04-25 18:44:25',NULL),(1707,7908,40720,1565,3,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',40013.96,NULL,NULL,1,'2025-04-25 18:53:52','2025-04-25 18:53:52',NULL),(1708,7908,40720,1565,15,1509,'App\\Models\\PeriodLiquidation',NULL,1509,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',7733332.34,NULL,NULL,1,'2025-04-25 19:46:25','2025-04-25 20:08:04','2025-04-25 20:08:04'),(1709,7908,40720,1565,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',12567513.75,NULL,NULL,1,'2025-04-25 20:08:40','2025-04-25 20:25:26','2025-04-25 20:25:26');
INSERT INTO `balance_libro` VALUES (1710,7908,40720,1565,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',14608330.00,NULL,NULL,1,'2025-04-25 20:09:03','2025-04-25 20:26:25','2025-04-25 20:26:25'),(1711,7908,40720,1565,15,1509,'App\\Models\\PeriodLiquidation',NULL,1509,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',7733332.34,NULL,NULL,1,'2025-04-25 20:10:02','2025-04-25 20:19:10','2025-04-25 20:19:10'),(1712,7908,40720,1565,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',12567513.75,NULL,NULL,1,'2025-04-25 20:25:26','2025-04-25 20:25:26',NULL),(1713,7908,40720,1565,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',14608330.00,NULL,NULL,1,'2025-04-25 20:26:25','2025-04-25 20:26:25',NULL),(1714,7908,40720,1565,15,1509,'App\\Models\\PeriodLiquidation',NULL,1509,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',7733332.34,NULL,NULL,1,'2025-04-25 20:35:06','2025-04-25 20:35:06',NULL),(1715,7908,40720,1566,7,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',680002.97,NULL,NULL,1,'2025-05-13 14:20:31','2025-05-13 14:20:31',NULL),(1716,7908,40720,1566,7,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',1218613.59,NULL,NULL,1,'2025-05-13 14:20:31','2025-05-13 14:20:31',NULL),(1717,7908,40720,1566,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',14043070.94,NULL,NULL,1,'2025-05-13 14:31:17','2025-05-13 14:31:17',NULL),(1718,7908,40720,1566,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',7836224.69,NULL,NULL,1,'2025-05-13 14:33:13','2025-05-13 14:33:13',NULL),(1719,7908,40720,1566,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-04','2025-04-04',65000.11,NULL,NULL,1,'2025-05-13 14:40:34','2025-05-13 14:40:34',NULL),(1720,7908,40720,1566,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-08','2025-04-08',1500.00,NULL,NULL,1,'2025-05-13 14:40:34','2025-05-13 14:40:34',NULL),(1721,7908,40720,1566,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-08','2025-04-08',272700.00,NULL,NULL,1,'2025-05-13 14:40:34','2025-05-13 14:40:34',NULL),(1722,7908,40720,1566,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-08','2025-04-08',118000.00,NULL,NULL,1,'2025-05-13 14:40:34','2025-05-13 14:40:34',NULL),(1723,7908,40720,1566,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',64284.00,NULL,NULL,1,'2025-05-13 14:40:34','2025-05-14 19:09:02','2025-05-14 19:09:02'),(1724,7908,40720,1566,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',993480.00,NULL,NULL,1,'2025-05-13 14:40:34','2025-05-14 19:08:45','2025-05-14 19:08:45'),(1725,7908,40720,1566,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',157885.46,NULL,NULL,1,'2025-05-13 14:40:34','2025-05-14 19:08:12','2025-05-14 19:08:12'),(1726,7908,40720,1566,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-25','2025-04-25',296881.12,NULL,NULL,1,'2025-05-13 14:40:34','2025-05-14 19:09:53','2025-05-14 19:09:53'),(1727,7908,40720,1566,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',212300.00,NULL,NULL,1,'2025-05-13 14:40:35','2025-05-13 14:40:35',NULL),(1728,7908,40720,1566,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',28000.01,NULL,NULL,1,'2025-05-13 14:40:35','2025-05-13 14:40:35',NULL),(1729,7908,40720,1566,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',248824.29,NULL,NULL,1,'2025-05-13 14:40:35','2025-05-14 19:09:38','2025-05-14 19:09:38');
INSERT INTO `balance_libro` VALUES (1730,7908,40720,1566,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-22','2025-04-22',3033921.33,NULL,NULL,1,'2025-05-13 14:44:05','2025-05-14 19:07:54','2025-05-14 19:07:54'),(1731,7908,40720,1566,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',40001.06,NULL,NULL,1,'2025-05-14 18:43:47','2025-05-14 18:43:47',NULL),(1732,7908,40720,1566,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',70033.06,NULL,NULL,1,'2025-05-14 18:48:28','2025-05-14 18:48:28',NULL),(1733,7908,40720,1566,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-18','2025-04-18',50004.99,NULL,NULL,1,'2025-05-14 18:50:12','2025-05-14 18:50:12',NULL),(1734,7908,40720,1566,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',39999.99,NULL,NULL,1,'2025-05-14 18:51:09','2025-05-14 18:51:09',NULL),(1735,7908,40720,1566,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-24','2025-04-24',60034.01,NULL,NULL,1,'2025-05-14 18:52:03','2025-05-14 18:52:03',NULL),(1736,7908,40720,1566,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-14','2025-04-14',40033.96,NULL,NULL,1,'2025-05-14 18:52:47','2025-05-14 18:52:47',NULL),(1737,7908,40720,1566,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-13','2025-04-13',40009.06,NULL,NULL,1,'2025-05-14 18:53:37','2025-05-14 18:53:37',NULL),(1738,7908,40720,1566,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-12','2025-04-12',19999.05,NULL,NULL,1,'2025-05-14 18:54:32','2025-05-14 18:54:32',NULL),(1739,7908,40720,1566,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-05','2025-04-05',30007.00,NULL,NULL,1,'2025-05-14 18:55:32','2025-05-14 18:55:32',NULL),(1740,7908,40720,1566,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-08','2025-04-08',80167.00,NULL,NULL,1,'2025-05-14 18:56:27','2025-05-14 18:56:27',NULL),(1741,7908,40720,1566,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',100170.99,NULL,NULL,1,'2025-05-14 18:57:16','2025-05-14 18:57:16',NULL),(1742,7908,40720,1566,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',60036.03,NULL,NULL,1,'2025-05-14 18:58:22','2025-05-14 18:58:22',NULL),(1743,7908,40720,1566,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',127623.39,NULL,NULL,1,'2025-05-14 19:01:37','2025-05-14 19:01:37',NULL),(1744,7908,40720,1566,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-22','2025-04-22',3033921.33,NULL,NULL,1,'2025-05-14 19:07:54','2025-05-14 19:07:54',NULL),(1745,7908,40720,1566,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',156912.86,NULL,NULL,1,'2025-05-14 19:08:12','2025-05-14 19:08:12',NULL),(1746,7908,40720,1566,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',987360.00,NULL,NULL,1,'2025-05-14 19:08:45','2025-05-14 19:08:45',NULL),(1747,7908,40720,1566,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',63888.00,NULL,NULL,1,'2025-05-14 19:09:02','2025-05-14 19:09:02',NULL),(1748,7908,40720,1566,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',247291.49,NULL,NULL,1,'2025-05-14 19:09:38','2025-05-14 19:09:38',NULL),(1749,7908,40720,1566,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-25','2025-04-25',295046.16,NULL,NULL,1,'2025-05-14 19:09:53','2025-05-14 19:09:53',NULL);
INSERT INTO `balance_libro` VALUES (1750,7908,40720,1566,15,1548,'App\\Models\\PeriodLiquidation',NULL,1548,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',5458145.44,NULL,NULL,1,'2025-05-14 19:21:18','2025-05-14 19:30:02','2025-05-14 19:30:02'),(1751,7908,40720,1566,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-14','2025-04-14',459800.00,NULL,NULL,1,'2025-05-14 19:31:51','2025-05-14 19:31:51',NULL),(1752,7908,40720,1566,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-23','2025-04-23',1491750.00,NULL,NULL,1,'2025-05-14 19:31:51','2025-05-14 19:31:51',NULL),(1753,7908,40720,1566,15,1551,'App\\Models\\PeriodLiquidation',NULL,1551,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',5458145.44,NULL,NULL,1,'2025-05-14 19:34:56','2025-05-14 19:34:56',NULL),(1754,7908,40720,1567,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',76736.59,NULL,NULL,1,'2025-05-26 19:35:06','2025-06-17 19:03:48','2025-06-17 19:03:48'),(1755,7908,40720,1567,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',64401.11,NULL,NULL,1,'2025-05-26 19:35:06','2025-06-17 19:03:24','2025-06-17 19:03:24'),(1756,7908,40720,1567,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',76736.59,NULL,NULL,1,'2025-05-26 19:35:06','2025-06-17 19:03:07','2025-06-17 19:03:07'),(1757,7908,40720,1567,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',153473.18,NULL,NULL,1,'2025-05-26 19:35:06','2025-06-17 19:02:53','2025-06-17 19:02:53'),(1758,7908,40720,1567,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',155791.30,NULL,NULL,1,'2025-05-26 19:35:06','2025-06-17 19:02:36','2025-06-17 19:02:36'),(1759,7908,40720,1567,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',65373.85,NULL,NULL,1,'2025-05-26 19:35:06','2025-06-17 19:02:22','2025-06-17 19:02:22'),(1760,7908,40720,1567,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-23','2025-05-23',18009.34,NULL,NULL,1,'2025-05-26 19:35:06','2025-05-26 19:35:06',NULL),(1761,7908,40720,1567,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-24','2025-05-24',30000.00,NULL,NULL,1,'2025-05-26 19:35:06','2025-05-26 19:35:06',NULL),(1762,7908,40720,1567,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-12','2025-05-12',8750001.26,NULL,NULL,1,'2025-05-26 19:35:21','2025-06-11 19:58:18','2025-06-11 19:58:18'),(1763,7908,40720,1567,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',594000.00,NULL,NULL,1,'2025-06-02 12:26:37','2025-06-02 12:26:37',NULL),(1764,7908,40720,1567,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',288000.00,NULL,NULL,1,'2025-06-02 12:26:37','2025-06-02 12:26:37',NULL),(1765,7908,40720,1567,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',28000.01,NULL,NULL,1,'2025-06-02 12:26:37','2025-06-02 12:26:37',NULL),(1766,7908,40720,1567,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',90855.49,NULL,NULL,1,'2025-06-02 12:26:37','2025-06-17 19:07:20','2025-06-17 19:07:20'),(1767,7908,40720,1567,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',227902.95,NULL,NULL,1,'2025-06-02 12:26:37','2025-06-17 19:06:42','2025-06-17 19:06:42'),(1768,7908,40720,1567,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',7346524.42,NULL,NULL,1,'2025-06-02 12:39:24','2025-06-11 19:56:46','2025-06-11 19:56:46');
INSERT INTO `balance_libro` VALUES (1769,7908,40720,1567,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',3720476.73,NULL,NULL,1,'2025-06-02 12:43:27','2025-06-02 12:46:03','2025-06-02 12:46:03'),(1770,7908,40720,1567,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',3720476.73,NULL,NULL,1,'2025-06-02 12:46:03','2025-06-11 19:56:08','2025-06-11 19:56:08'),(1771,7908,40720,1567,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-17','2025-05-17',49999.02,NULL,NULL,1,'2025-06-03 12:45:58','2025-06-03 12:45:58',NULL),(1772,7908,40720,1567,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-17','2025-05-17',40007.95,NULL,NULL,1,'2025-06-03 12:48:48','2025-06-03 12:48:48',NULL),(1773,7908,40720,1567,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',60080.03,NULL,NULL,1,'2025-06-03 18:25:34','2025-06-03 18:25:34',NULL),(1774,7908,40720,1567,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',150033.99,NULL,NULL,1,'2025-06-03 18:28:51','2025-06-03 18:28:51',NULL),(1775,7908,40720,1567,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-27','2025-05-27',50001.05,NULL,NULL,1,'2025-06-03 18:29:45','2025-06-03 18:29:45',NULL),(1776,7908,40720,1567,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-26','2025-05-26',39998.01,NULL,NULL,1,'2025-06-03 18:30:53','2025-06-03 18:30:53',NULL),(1777,7908,40720,1567,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-22','2025-05-22',40061.97,NULL,NULL,1,'2025-06-03 18:32:21','2025-06-03 18:32:21',NULL),(1778,7908,40720,1567,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-20','2025-05-20',54484.04,NULL,NULL,1,'2025-06-03 18:33:46','2025-06-03 18:33:46',NULL),(1779,7908,40720,1567,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-16','2025-05-16',80003.04,NULL,NULL,1,'2025-06-03 18:36:57','2025-06-03 18:36:57',NULL),(1780,7908,40720,1567,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-15','2025-05-15',50005.02,NULL,NULL,1,'2025-06-03 18:38:55','2025-06-03 18:38:55',NULL),(1781,7908,40720,1567,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-13','2025-05-13',110001.93,NULL,NULL,1,'2025-06-03 18:39:50','2025-06-03 18:39:50',NULL),(1782,7908,40720,1567,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-07','2025-05-07',63002.92,NULL,NULL,1,'2025-06-03 18:40:55','2025-06-03 18:40:55',NULL),(1783,7908,40720,1567,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-07','2025-05-07',100029.05,NULL,NULL,1,'2025-06-03 18:42:07','2025-06-03 18:42:07',NULL),(1784,7908,40720,1567,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-07','2025-05-07',50002.00,NULL,NULL,1,'2025-06-03 18:43:16','2025-06-03 18:43:16',NULL),(1785,7908,40720,1567,7,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',428710.71,NULL,NULL,1,'2025-06-11 19:29:27','2025-06-17 19:11:41','2025-06-17 19:11:41'),(1786,7908,40720,1567,7,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',465390.69,NULL,NULL,1,'2025-06-11 19:29:27','2025-06-17 19:11:26','2025-06-17 19:11:26'),(1787,7908,40720,1567,7,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',235686.31,NULL,NULL,1,'2025-06-11 19:29:27','2025-06-17 19:10:38','2025-06-17 19:10:38'),(1788,7908,40720,1567,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',3720476.73,NULL,NULL,1,'2025-06-11 19:56:08','2025-06-11 19:58:34','2025-06-11 19:58:34');
INSERT INTO `balance_libro` VALUES (1789,7908,40720,1567,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',7346524.42,NULL,NULL,1,'2025-06-11 19:56:46','2025-06-11 19:58:46','2025-06-11 19:58:46'),(1790,7908,40720,1567,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-12','2025-05-12',8750001.26,NULL,NULL,1,'2025-06-11 19:58:18','2025-06-11 19:58:18',NULL),(1791,7908,40720,1567,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',3720476.73,NULL,NULL,1,'2025-06-11 19:58:34','2025-06-11 19:58:34',NULL),(1792,7908,40720,1567,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',7346524.42,NULL,NULL,1,'2025-06-11 19:58:46','2025-06-11 19:58:46',NULL),(1793,7908,40720,1567,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',6767504.71,NULL,NULL,1,'2025-06-11 20:14:24','2025-06-11 20:14:24',NULL),(1794,7908,40720,1567,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',64973.98,NULL,NULL,1,'2025-06-17 19:02:22','2025-06-17 19:02:22',NULL),(1795,7908,40720,1567,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',154831.60,NULL,NULL,1,'2025-06-17 19:02:36','2025-06-17 19:02:36',NULL),(1796,7908,40720,1567,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',152527.76,NULL,NULL,1,'2025-06-17 19:02:53','2025-06-17 19:02:53',NULL),(1797,7908,40720,1567,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',76263.88,NULL,NULL,1,'2025-06-17 19:03:07','2025-06-17 19:03:07',NULL),(1798,7908,40720,1567,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',64007.19,NULL,NULL,1,'2025-06-17 19:03:24','2025-06-17 19:03:24',NULL),(1799,7908,40720,1567,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',76263.88,NULL,NULL,1,'2025-06-17 19:03:48','2025-06-17 19:03:48',NULL),(1800,7908,40720,1567,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',226499.03,NULL,NULL,1,'2025-06-17 19:06:42','2025-06-17 19:06:42',NULL),(1801,7908,40720,1567,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',90295.81,NULL,NULL,1,'2025-06-17 19:07:20','2025-06-17 19:07:20',NULL),(1802,7908,40720,1567,7,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',235686.31,NULL,NULL,1,'2025-06-17 19:10:39','2025-06-17 19:11:05','2025-06-17 19:11:05'),(1803,7908,40720,1567,7,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',235686.31,NULL,NULL,1,'2025-06-17 19:11:05','2025-06-17 19:11:05',NULL),(1804,7908,40720,1567,7,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',465390.69,NULL,NULL,1,'2025-06-17 19:11:26','2025-06-17 19:11:26',NULL),(1805,7908,40720,1567,7,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',428710.71,NULL,NULL,1,'2025-06-17 19:11:41','2025-06-17 19:11:41',NULL),(1806,7908,40720,1567,15,1597,'App\\Models\\PeriodLiquidation',NULL,1597,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',3213276.81,NULL,NULL,1,'2025-06-17 19:13:08','2025-06-17 19:13:08',NULL),(1807,7908,40720,1568,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-02','2025-06-02',34500.00,NULL,NULL,1,'2025-06-24 12:14:15','2025-06-24 12:14:15',NULL),(1808,7908,40720,1568,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-05','2025-06-05',139999.42,NULL,NULL,1,'2025-06-24 12:14:15','2025-06-24 12:14:15',NULL);
INSERT INTO `balance_libro` VALUES (1809,7908,40720,1568,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-10','2025-06-10',22000.00,NULL,NULL,1,'2025-06-24 12:14:15','2025-06-24 12:14:15',NULL),(1810,7908,40720,1568,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-12','2025-06-12',63319.74,NULL,NULL,1,'2025-06-24 12:14:15','2025-07-14 19:39:00','2025-07-14 19:39:00'),(1811,7908,40720,1568,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-12','2025-06-12',161177.52,NULL,NULL,1,'2025-06-24 12:14:16','2025-07-14 19:38:45','2025-07-14 19:38:45'),(1812,7908,40720,1568,3,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-13','2025-06-13',53000.00,NULL,NULL,1,'2025-06-24 12:14:16','2025-06-24 12:14:16',NULL),(1813,7908,40720,1568,3,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-13','2025-06-13',187545.29,NULL,NULL,1,'2025-06-24 12:14:16','2025-07-14 19:40:07','2025-07-14 19:40:07'),(1814,7908,40720,1568,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-18','2025-06-18',91333.51,NULL,NULL,1,'2025-06-24 12:14:16','2025-07-14 19:41:01','2025-07-14 19:41:01'),(1815,7908,40720,1568,3,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-24','2025-06-24',1450548.00,NULL,NULL,1,'2025-07-08 20:27:12','2025-07-08 20:27:12',NULL),(1816,7908,40720,1568,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',895081.77,NULL,NULL,1,'2025-07-08 20:31:05','2025-07-08 20:31:05',NULL),(1817,7908,40720,1568,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',1731510.00,NULL,NULL,1,'2025-07-08 20:34:00','2025-07-08 20:34:00',NULL),(1818,7908,40720,1568,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-06','2025-06-06',1270272.01,NULL,NULL,1,'2025-07-08 20:38:28','2025-07-08 20:38:28',NULL),(1819,7908,40720,1568,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-17','2025-06-17',1359454.55,NULL,NULL,1,'2025-07-08 20:41:47','2025-07-08 20:41:47',NULL),(1820,7908,40720,1568,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-19','2025-06-19',2271980.70,NULL,NULL,1,'2025-07-08 20:44:17','2025-07-08 20:44:17',NULL),(1821,7908,40719,53,7,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',259696.25,NULL,NULL,1,'2025-07-11 16:54:59','2025-07-11 16:54:59',NULL),(1822,7908,40719,53,7,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',1579485.21,NULL,NULL,1,'2025-07-11 16:54:59','2025-07-11 16:54:59',NULL),(1823,7908,40719,53,7,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',449983.75,NULL,NULL,1,'2025-07-11 16:54:59','2025-07-11 16:54:59',NULL),(1824,7908,40719,53,7,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-19','2025-06-19',720670.72,NULL,NULL,1,'2025-07-11 16:54:59','2025-07-11 16:54:59',NULL),(1825,7908,40719,53,7,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-03','2025-06-03',354750.53,NULL,NULL,1,'2025-07-11 16:54:59','2025-07-11 16:54:59',NULL),(1826,7908,40719,53,7,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-03','2025-06-03',724818.18,NULL,NULL,1,'2025-07-11 16:54:59','2025-07-11 16:54:59',NULL),(1827,7908,40720,1568,7,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',259696.25,NULL,NULL,1,'2025-07-11 16:56:49','2025-07-11 16:56:49',NULL),(1828,7908,40720,1568,7,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',1579485.21,NULL,NULL,1,'2025-07-11 16:56:49','2025-07-11 16:56:49',NULL);
INSERT INTO `balance_libro` VALUES (1829,7908,40720,1568,7,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',449983.75,NULL,NULL,1,'2025-07-11 16:56:49','2025-07-11 16:56:49',NULL),(1830,7908,40720,1568,7,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-19','2025-06-19',720670.72,NULL,NULL,1,'2025-07-11 16:56:50','2025-07-11 16:56:50',NULL),(1831,7908,40720,1568,7,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-03','2025-06-03',354750.53,NULL,NULL,1,'2025-07-11 16:56:50','2025-07-11 16:56:50',NULL),(1832,7908,40720,1568,7,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-03','2025-06-03',724818.18,NULL,NULL,1,'2025-07-11 16:56:50','2025-07-11 16:56:50',NULL),(1833,7908,40720,1568,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',7103314.96,NULL,NULL,1,'2025-07-14 19:14:36','2025-07-14 19:14:36',NULL),(1834,7908,40720,1568,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',24933302.23,NULL,NULL,1,'2025-07-14 19:20:12','2025-07-14 19:20:12',NULL),(1835,7908,40720,1568,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',4099490.85,NULL,NULL,1,'2025-07-14 19:21:55','2025-07-14 19:21:55',NULL),(1836,7908,40720,1568,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-19','2025-06-19',11376302.08,NULL,NULL,1,'2025-07-14 19:23:56','2025-07-14 19:23:56',NULL),(1837,7908,40720,1568,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-03','2025-06-03',11441772.68,NULL,NULL,1,'2025-07-14 19:25:49','2025-07-14 19:25:49',NULL),(1838,7908,40720,1568,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-03','2025-06-03',5599990.49,NULL,NULL,1,'2025-07-14 19:28:12','2025-07-14 19:28:12',NULL),(1839,7908,40720,1568,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',23600.00,NULL,NULL,1,'2025-07-14 19:32:03','2025-07-14 19:32:03',NULL),(1840,7908,40720,1568,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',28000.01,NULL,NULL,1,'2025-07-14 19:32:03','2025-07-14 19:32:03',NULL),(1841,7908,40720,1568,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',207190.94,NULL,NULL,1,'2025-07-14 19:32:03','2025-07-14 19:42:19','2025-07-14 19:42:19'),(1842,7908,40720,1568,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-12','2025-06-12',160184.64,NULL,NULL,1,'2025-07-14 19:38:45','2025-07-14 19:38:45',NULL),(1843,7908,40720,1568,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-12','2025-06-12',62929.68,NULL,NULL,1,'2025-07-14 19:39:00','2025-07-14 19:39:00',NULL),(1844,7908,40720,1568,3,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-13','2025-06-13',167719.45,NULL,NULL,1,'2025-07-14 19:40:07','2025-07-14 19:40:07',NULL),(1845,7908,40720,1568,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-18','2025-06-18',90808.18,NULL,NULL,1,'2025-07-14 19:41:01','2025-07-14 19:41:01',NULL),(1846,7908,40720,1568,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',205914.61,NULL,NULL,1,'2025-07-14 19:42:19','2025-07-14 19:42:19',NULL),(1847,7908,40720,1568,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-04','2025-06-04',150019.95,NULL,NULL,1,'2025-07-16 19:15:58','2025-07-16 19:15:58',NULL),(1848,7908,40720,1568,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-03','2025-06-03',118996.00,NULL,NULL,1,'2025-07-16 19:17:52','2025-07-16 19:17:52',NULL);
INSERT INTO `balance_libro` VALUES (1849,7908,40720,1568,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-23','2025-06-23',50014.03,NULL,NULL,1,'2025-07-16 19:18:47','2025-07-16 19:18:47',NULL),(1850,7908,40720,1568,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-20','2025-06-20',150001.03,NULL,NULL,1,'2025-07-16 19:19:33','2025-07-16 19:19:33',NULL),(1851,7908,40720,1568,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-19','2025-06-19',105021.94,NULL,NULL,1,'2025-07-16 19:20:30','2025-07-16 19:20:30',NULL),(1852,7908,40720,1568,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-18','2025-06-18',160039.01,NULL,NULL,1,'2025-07-16 19:21:19','2025-07-16 19:21:19',NULL),(1853,7908,40720,1568,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-18','2025-06-18',52656.94,NULL,NULL,1,'2025-07-16 19:22:01','2025-07-16 19:22:01',NULL),(1854,7908,40720,1568,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',120086.01,NULL,NULL,1,'2025-07-16 19:23:08','2025-07-16 19:23:08',NULL),(1855,7908,40720,1568,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',15007.03,NULL,NULL,1,'2025-07-16 19:23:52','2025-07-16 19:23:52',NULL),(1856,7908,40720,1568,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',84823.95,NULL,NULL,1,'2025-07-16 19:24:45','2025-07-16 19:24:45',NULL),(1857,7908,40720,1568,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-24','2025-06-24',30015.01,NULL,NULL,1,'2025-07-16 19:25:24','2025-07-16 19:25:24',NULL),(1858,7908,40720,1568,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-24','2025-06-24',74745.00,NULL,NULL,1,'2025-07-16 19:26:50','2025-07-16 19:41:43','2025-07-16 19:41:43'),(1859,7908,40720,1568,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-24','2025-06-24',120092.96,NULL,NULL,1,'2025-07-16 19:27:58','2025-07-16 19:27:58',NULL),(1860,7908,40720,1568,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-25','2025-06-25',119996.94,NULL,NULL,1,'2025-07-16 19:28:54','2025-07-16 19:28:54',NULL),(1861,7908,40720,1568,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-25','2025-06-25',92008.05,NULL,NULL,1,'2025-07-16 19:29:40','2025-07-16 19:39:50','2025-07-16 19:39:50'),(1862,7908,40720,1568,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-28','2025-06-28',60000.03,NULL,NULL,1,'2025-07-16 19:31:24','2025-07-16 19:31:24',NULL),(1863,7908,40720,1568,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',78911.97,NULL,NULL,1,'2025-07-16 19:32:51','2025-07-16 19:40:44','2025-07-16 19:40:44'),(1864,7908,40720,1568,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',60015.98,NULL,NULL,1,'2025-07-16 19:34:32','2025-07-16 19:34:32',NULL),(1865,7908,40720,1568,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',100020.96,NULL,NULL,1,'2025-07-16 19:36:09','2025-07-16 19:38:28','2025-07-16 19:38:28'),(1866,7908,40720,1568,15,1657,'App\\Models\\PeriodLiquidation',NULL,1657,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',6134106.96,NULL,NULL,1,'2025-07-24 18:43:54','2025-07-24 18:43:54',NULL),(1867,7908,40720,1569,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-03','2025-07-03',375895.00,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-12 20:11:23',NULL),(1868,7908,40720,1569,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-04','2025-07-04',24500.92,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-18 20:34:14','2025-08-18 20:34:14');
INSERT INTO `balance_libro` VALUES (1869,7908,40720,1569,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-08','2025-07-08',9630075.00,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-12 20:11:23',NULL),(1870,7908,40720,1569,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-11','2025-07-11',9600.00,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-12 20:11:23',NULL),(1871,7908,40720,1569,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-15','2025-07-15',45000.00,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-12 20:11:23',NULL),(1872,7908,40720,1569,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-18','2025-07-18',327000.00,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-12 20:11:23',NULL),(1873,7908,40720,1569,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-18','2025-07-18',278472.30,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-18 20:19:04','2025-08-18 20:19:04'),(1874,7908,40720,1569,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',8554352.00,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-12 20:11:23',NULL),(1875,7908,40720,1569,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',11.55,NULL,NULL,1,'2025-08-12 20:11:23','2025-08-12 20:11:23',NULL),(1876,7908,40720,1569,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-30','2025-07-30',9336302.00,NULL,NULL,1,'2025-08-12 20:11:24','2025-08-12 20:11:24',NULL),(1877,7908,40720,1569,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-30','2025-07-30',278533.66,NULL,NULL,1,'2025-08-12 20:11:24','2025-08-18 20:21:00','2025-08-18 20:21:00'),(1878,7908,40720,1569,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',55000.01,NULL,NULL,1,'2025-08-12 20:11:24','2025-08-12 20:11:24',NULL),(1879,7908,40720,1569,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',11.55,NULL,NULL,1,'2025-08-12 20:14:02','2025-08-12 20:14:02',NULL),(1880,7908,40720,1569,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-30','2025-07-30',8554352.00,NULL,NULL,1,'2025-08-12 20:14:02','2025-08-12 20:14:02',NULL),(1881,7908,40720,1570,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-14','2025-08-14',10575001.30,NULL,NULL,1,'2025-08-14 10:56:13','2025-08-14 10:56:13',NULL),(1903,7908,40720,1569,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-24','2025-07-24',100019.10,NULL,NULL,1,'2025-08-14 13:22:37','2025-08-14 13:22:37',NULL),(1904,7908,40720,1569,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-21','2025-07-21',30048.00,NULL,NULL,1,'2025-08-14 13:22:37','2025-08-14 13:30:56','2025-08-14 13:30:56'),(1905,7908,40720,1569,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-23','2025-07-23',30002.93,NULL,NULL,1,'2025-08-14 13:22:37','2025-08-14 13:22:37',NULL),(1906,7908,40720,1569,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-23','2025-07-23',100169.07,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1907,7908,40720,1569,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-23','2025-07-23',40018.03,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1908,7908,40720,1569,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-23','2025-07-23',60013.01,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1909,7908,40720,1569,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-22','2025-07-22',150152.05,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL);
INSERT INTO `balance_libro` VALUES (1910,7908,40720,1569,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-22','2025-07-22',70069.96,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1911,7908,40720,1569,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',62047.00,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1912,7908,40720,1569,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',110046.93,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1913,7908,40720,1569,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-30','2025-07-30',120085.98,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1914,7908,40720,1569,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-30','2025-07-30',30019.98,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1915,7908,40720,1569,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',49998.95,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1916,7908,40720,1569,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',80266.00,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1917,7908,40720,1569,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-29','2025-07-29',102007.98,NULL,NULL,1,'2025-08-14 13:22:38','2025-08-14 13:22:38',NULL),(1918,7908,40720,1569,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-01','2025-07-01',150034.98,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1919,7908,40720,1569,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-02','2025-07-02',80042.08,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1920,7908,40720,1569,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-02','2025-07-02',150020.03,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1921,7908,40720,1569,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-03','2025-07-03',150020.95,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1922,7908,40720,1569,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-04','2025-07-04',150024.96,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:28:15','2025-08-14 13:28:15'),(1923,7908,40720,1569,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-04','2025-07-04',30002.94,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1924,7908,40720,1569,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-12','2025-07-12',70106.98,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1925,7908,40720,1569,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-12','2025-07-12',120000.03,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1926,7908,40720,1569,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-10','2025-07-10',100016.95,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:26:50','2025-08-14 13:26:50'),(1927,7908,40720,1569,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-10','2025-07-10',39997.00,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1928,7908,40720,1569,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-09','2025-07-09',100006.00,NULL,NULL,1,'2025-08-14 13:22:39','2025-08-14 13:22:39',NULL),(1929,7908,40720,1569,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-09','2025-07-09',50022.94,NULL,NULL,1,'2025-08-14 13:22:40','2025-08-14 13:22:40',NULL);
INSERT INTO `balance_libro` VALUES (1930,7908,40720,1569,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-08','2025-07-08',118998.01,NULL,NULL,1,'2025-08-14 13:22:40','2025-08-14 13:22:40',NULL),(1931,7908,40720,1569,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-08','2025-07-08',49999.06,NULL,NULL,1,'2025-08-14 13:22:40','2025-08-14 13:22:40',NULL),(1932,7908,40720,1569,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-05','2025-07-05',99999.05,NULL,NULL,1,'2025-08-14 13:22:40','2025-08-14 13:22:40',NULL),(1933,7908,40720,1569,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-05','2025-07-05',60012.00,NULL,NULL,1,'2025-08-14 13:22:40','2025-08-14 13:25:53','2025-08-14 13:25:53'),(1934,7908,40720,1569,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-05','2025-07-05',60012.00,NULL,NULL,1,'2025-08-14 13:25:53','2025-08-14 13:25:53',NULL),(1935,7908,40720,1569,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-10','2025-07-10',100016.95,NULL,NULL,1,'2025-08-14 13:26:50','2025-08-14 13:26:50',NULL),(1936,7908,40720,1569,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-04','2025-07-04',150024.96,NULL,NULL,1,'2025-08-14 13:28:15','2025-08-14 13:28:15',NULL),(1937,7908,40720,1569,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-21','2025-07-21',30048.00,NULL,NULL,1,'2025-08-14 13:30:56','2025-08-14 13:30:56',NULL),(1938,7908,40720,1570,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-14','2025-08-14',10125004.73,NULL,NULL,1,'2025-08-14 14:45:58','2025-08-14 14:45:58',NULL),(1939,7908,40720,1569,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-18','2025-07-18',276763.18,NULL,NULL,1,'2025-08-18 20:19:04','2025-08-18 20:19:04',NULL),(1940,7908,40720,1569,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-30','2025-07-30',276817.85,NULL,NULL,1,'2025-08-18 20:21:00','2025-08-18 20:31:47','2025-08-18 20:31:47'),(1941,7908,40720,1569,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-30','2025-07-30',276817.85,NULL,NULL,1,'2025-08-18 20:31:47','2025-08-18 20:31:47',NULL),(1942,7908,40720,1569,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-04','2025-07-04',24500.93,NULL,NULL,1,'2025-08-18 20:34:14','2025-08-18 20:34:14',NULL),(1943,7908,40720,1569,15,1672,'App\\Models\\PeriodLiquidation',NULL,1672,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-07-31','2025-07-31',4669044.71,NULL,NULL,1,'2025-08-18 20:57:48','2025-08-18 20:57:48',NULL),(1944,7908,40720,1570,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-25','2025-08-25',10575001.30,NULL,NULL,1,'2025-08-25 14:27:43','2025-08-25 14:27:43',NULL),(1945,7908,40720,1570,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-04','2025-08-04',256186.64,NULL,NULL,1,'2025-09-02 11:32:34','2025-09-02 11:32:34',NULL),(1946,7908,40720,1570,3,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-06','2025-08-06',79500.00,NULL,NULL,1,'2025-09-02 11:32:34','2025-09-02 11:32:34',NULL),(1947,7908,40720,1570,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-06','2025-08-06',498579.86,NULL,NULL,1,'2025-09-02 11:32:34','2025-09-02 11:32:34',NULL),(1948,7908,40720,1570,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-06','2025-08-06',253645.83,NULL,NULL,1,'2025-09-02 11:32:34','2025-09-02 11:32:34',NULL),(1949,7908,40720,1570,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-06','2025-08-06',241043.32,NULL,NULL,1,'2025-09-02 11:32:34','2025-09-02 11:32:34',NULL);
INSERT INTO `balance_libro` VALUES (1950,7908,40720,1570,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-06','2025-08-06',339957.95,NULL,NULL,1,'2025-09-02 11:32:34','2025-09-02 11:32:34',NULL),(1951,7908,40720,1570,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-15','2025-08-15',43.23,NULL,NULL,1,'2025-09-02 11:32:35','2025-09-02 11:37:56','2025-09-02 11:37:56'),(1952,7908,40720,1570,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',43.23,NULL,NULL,1,'2025-09-02 11:32:35','2025-09-02 11:36:59','2025-09-02 11:36:59'),(1953,7908,40720,1570,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',963.49,NULL,NULL,1,'2025-09-02 11:32:35','2025-09-19 12:13:10','2025-09-19 12:13:10'),(1954,7908,40720,1570,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',287050.85,NULL,NULL,1,'2025-09-02 11:32:35','2025-09-02 11:35:46','2025-09-02 11:35:46'),(1955,7908,40720,1570,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-31','2025-08-31',55000.01,NULL,NULL,1,'2025-09-02 11:32:35','2025-09-02 11:32:35',NULL),(1956,7908,40720,1570,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',287050.85,NULL,NULL,1,'2025-09-02 11:35:46','2025-09-19 12:15:18','2025-09-19 12:15:18'),(1957,7908,40720,1570,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',43.23,NULL,NULL,1,'2025-09-02 11:36:59','2025-09-19 12:17:47','2025-09-19 12:17:47'),(1958,7908,40720,1570,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-15','2025-08-15',43.23,NULL,NULL,1,'2025-09-02 11:37:56','2025-09-19 12:17:58','2025-09-19 12:17:58'),(1959,7908,40720,1571,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-02','2025-09-02',19125008.92,NULL,NULL,1,'2025-09-02 12:04:13','2025-09-02 12:04:13',NULL),(1960,7908,40720,1570,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-30','2025-08-30',40009.05,NULL,NULL,1,'2025-09-18 20:26:41','2025-09-18 20:26:41',NULL),(1961,7908,40720,1570,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-31','2025-08-31',73010.07,NULL,NULL,1,'2025-09-18 20:29:35','2025-09-18 20:29:35',NULL),(1962,7908,40720,1570,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-04','2025-08-04',100066.09,NULL,NULL,1,'2025-09-18 20:32:50','2025-09-18 20:32:50',NULL),(1963,7908,40720,1570,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-05','2025-08-05',70057.92,NULL,NULL,1,'2025-09-18 20:32:50','2025-09-18 20:32:50',NULL),(1964,7908,40720,1570,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-05','2025-08-05',100020.98,NULL,NULL,1,'2025-09-18 20:32:50','2025-09-18 20:32:50',NULL),(1965,7908,40720,1570,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-06','2025-08-06',40018.02,NULL,NULL,1,'2025-09-18 20:32:50','2025-09-18 20:32:50',NULL),(1966,7908,40720,1570,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-06','2025-08-06',100040.08,NULL,NULL,1,'2025-09-18 20:32:50','2025-09-18 20:32:50',NULL),(1967,7908,40720,1570,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-07','2025-08-07',60027.96,NULL,NULL,1,'2025-09-18 20:32:50','2025-09-18 20:32:50',NULL),(1968,7908,40720,1570,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-07','2025-08-07',32403.05,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1969,7908,40720,1570,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-08','2025-08-08',69010.04,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL);
INSERT INTO `balance_libro` VALUES (1970,7908,40720,1570,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-08','2025-08-08',30017.00,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1971,7908,40720,1570,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-08','2025-08-08',33335.60,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1972,7908,40720,1570,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-13','2025-08-13',50059.95,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1973,7908,40720,1570,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-13','2025-08-13',120000.05,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1974,7908,40720,1570,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-14','2025-08-14',83003.97,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1975,7908,40720,1570,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-14','2025-08-14',60001.01,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1976,7908,40720,1570,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-14','2025-08-14',102932.76,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:37:43','2025-09-18 20:37:43'),(1977,7908,40720,1570,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-14','2025-08-14',90024.01,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1978,7908,40720,1570,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-14','2025-08-14',120124.06,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1979,7908,40720,1570,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-15','2025-08-15',49996.00,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1980,7908,40720,1570,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-15','2025-08-15',100007.93,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1981,7908,40720,1570,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-15','2025-08-15',80006.94,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1982,7908,40720,1570,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-18','2025-08-18',52037.98,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1983,7908,40720,1570,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-19','2025-08-19',100287.97,NULL,NULL,1,'2025-09-18 20:32:51','2025-09-18 20:32:51',NULL),(1984,7908,40720,1570,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-20','2025-08-20',59995.00,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL),(1985,7908,40720,1570,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-20','2025-08-20',120466.97,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL),(1986,7908,40720,1570,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-20','2025-08-20',80000.96,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL),(1987,7908,40720,1570,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-21','2025-08-21',60004.92,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL),(1988,7908,40720,1570,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-22','2025-08-22',40018.03,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL),(1989,7908,40720,1570,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-23','2025-08-23',30017.03,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL),(1990,7908,40720,1570,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-27','2025-08-27',40017.94,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL);
INSERT INTO `balance_libro` VALUES (1991,7908,40720,1570,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-27','2025-08-27',50008.93,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL),(1992,7908,40720,1570,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',70035.05,NULL,NULL,1,'2025-09-18 20:32:52','2025-09-18 20:32:52',NULL),(1993,7908,40720,1570,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-14','2025-08-14',102179.05,NULL,NULL,1,'2025-09-18 20:37:43','2025-09-18 20:37:43',NULL),(1994,7908,40720,1570,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',963.50,NULL,NULL,1,'2025-09-19 12:13:10','2025-09-19 12:15:37','2025-09-19 12:15:37'),(1995,7908,40720,1570,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-15','2025-08-15',43.23,NULL,NULL,1,'2025-09-19 12:25:37','2025-09-19 12:25:37',NULL),(1996,7908,40720,1570,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-28','2025-08-28',43.23,NULL,NULL,1,'2025-09-19 12:25:37','2025-09-19 12:25:37',NULL),(1997,7908,40720,1570,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',963.49,NULL,NULL,1,'2025-09-19 12:25:37','2025-09-19 18:54:22','2025-09-19 18:54:22'),(1998,7908,40720,1570,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',287050.85,NULL,NULL,1,'2025-09-19 12:25:38','2025-09-19 12:25:38',NULL),(1999,7908,40720,1570,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',963.49,NULL,NULL,1,'2025-09-22 19:30:21','2025-09-22 20:12:52','2025-09-22 20:12:52'),(2000,7908,40720,1570,15,1703,'App\\Models\\PeriodLiquidation',NULL,1703,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-31','2025-08-31',5959829.81,NULL,NULL,1,'2025-09-22 19:46:59','2025-09-22 19:56:39','2025-09-22 19:56:39'),(2001,7908,40720,1570,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',963.50,NULL,NULL,1,'2025-09-22 20:12:52','2025-09-22 20:13:08','2025-09-22 20:13:08'),(2002,7908,40720,1570,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-29','2025-08-29',963.49,NULL,NULL,1,'2025-09-22 20:21:09','2025-09-22 20:21:09',NULL),(2003,7908,40720,1570,15,1707,'App\\Models\\PeriodLiquidation',NULL,1707,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-08-31','2025-08-31',5959829.81,NULL,NULL,1,'2025-09-22 20:47:45','2025-09-22 20:47:45',NULL),(2004,7908,40720,1571,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-01','2025-09-01',648395.80,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 20:03:24','2025-09-30 20:03:24'),(2005,7908,40720,1571,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-05','2025-09-05',125.85,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 19:51:02','2025-09-30 19:51:02'),(2006,7908,40720,1571,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-08','2025-09-08',138000.00,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 20:05:11','2025-09-30 20:05:11'),(2007,7908,40720,1571,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-12','2025-09-12',14057.55,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 19:54:17','2025-09-30 19:54:17'),(2008,7908,40720,1571,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-17','2025-09-17',102.27,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 19:53:30','2025-09-30 19:53:30'),(2009,7908,40720,1571,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-17','2025-09-17',1303.34,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 19:52:57','2025-09-30 19:52:57'),(2010,7908,40720,1571,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-27','2025-09-27',53.57,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 19:52:29','2025-09-30 19:52:29');
INSERT INTO `balance_libro` VALUES (2011,7908,40720,1571,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-27','2025-09-27',319.47,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 19:52:04','2025-09-30 19:52:04'),(2012,7908,40720,1571,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',55000.01,NULL,NULL,1,'2025-09-30 19:48:33','2025-09-30 20:06:04','2025-09-30 20:06:04'),(2013,7908,40720,1571,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-05','2025-09-05',125.86,NULL,NULL,1,'2025-09-30 19:51:02','2025-09-30 20:04:55','2025-09-30 20:04:55'),(2014,7908,40720,1571,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-27','2025-09-27',319.47,NULL,NULL,1,'2025-09-30 19:52:04','2025-09-30 20:06:16','2025-09-30 20:06:16'),(2015,7908,40720,1571,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-27','2025-09-27',53.57,NULL,NULL,1,'2025-09-30 19:52:29','2025-09-30 20:06:28','2025-09-30 20:06:28'),(2016,7908,40720,1571,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-17','2025-09-17',1303.34,NULL,NULL,1,'2025-09-30 19:52:57','2025-09-30 20:06:42','2025-09-30 20:06:42'),(2017,7908,40720,1571,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-17','2025-09-17',102.27,NULL,NULL,1,'2025-09-30 19:53:30','2025-09-30 20:06:55','2025-09-30 20:06:55'),(2018,7908,40720,1571,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-12','2025-09-12',14057.55,NULL,NULL,1,'2025-09-30 19:54:17','2025-09-30 19:56:08','2025-09-30 19:56:08'),(2019,7908,40720,1571,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-12','2025-09-12',14057.55,NULL,NULL,1,'2025-09-30 19:56:08','2025-09-30 20:05:27','2025-09-30 20:05:27'),(2020,7908,40720,1571,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-01','2025-09-01',648395.80,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2021,7908,40720,1571,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-05','2025-09-05',125.85,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2022,7908,40720,1571,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-08','2025-09-08',138000.00,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2023,7908,40720,1571,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-12','2025-09-12',14057.55,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2024,7908,40720,1571,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-17','2025-09-17',102.27,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2025,7908,40720,1571,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-17','2025-09-17',1303.34,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2026,7908,40720,1571,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-27','2025-09-27',53.57,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2027,7908,40720,1571,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-27','2025-09-27',319.47,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2028,7908,40720,1571,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',55000.01,NULL,NULL,1,'2025-09-30 20:08:31','2025-09-30 20:08:31',NULL),(2029,7908,40720,1572,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-01','2025-10-01',19550005.69,NULL,NULL,1,'2025-10-01 15:19:26','2025-10-01 15:19:26',NULL),(2030,7908,40720,1571,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-03','2025-09-03',50018.99,NULL,NULL,1,'2025-10-30 19:22:58','2025-10-30 19:22:58',NULL);
INSERT INTO `balance_libro` VALUES (2031,7908,40720,1571,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-04','2025-09-04',50000.04,NULL,NULL,1,'2025-10-30 19:22:58','2025-10-30 19:22:58',NULL),(2032,7908,40720,1571,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-05','2025-09-05',30040.94,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2033,7908,40720,1571,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-05','2025-09-05',50211.92,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2034,7908,40720,1571,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-05','2025-09-05',70024.96,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2035,7908,40720,1571,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-06','2025-09-06',20018.99,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2036,7908,40720,1571,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-06','2025-09-06',100000.08,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2037,7908,40720,1571,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-07','2025-09-07',50003.97,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2038,7908,40720,1571,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-08','2025-09-08',60011.99,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2039,7908,40720,1571,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-10','2025-09-10',120027.01,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2040,7908,40720,1571,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-11','2025-09-11',80017.05,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2041,7908,40720,1571,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-11','2025-09-11',100066.96,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2042,7908,40720,1571,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-12','2025-09-12',123052.08,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2043,7908,40720,1571,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-12','2025-09-12',80003.04,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2044,7908,40720,1571,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-12','2025-09-12',30002.03,NULL,NULL,1,'2025-10-30 19:22:59','2025-10-30 19:22:59',NULL),(2045,7908,40720,1571,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-13','2025-09-13',30013.07,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2046,7908,40720,1571,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-15','2025-09-15',129822.04,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2047,7908,40720,1571,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-15','2025-09-15',40010.09,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2048,7908,40720,1571,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-16','2025-09-16',80000.13,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2049,7908,40720,1571,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-16','2025-09-16',140049.97,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2050,7908,40720,1571,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-16','2025-09-16',40004.00,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2051,7908,40720,1571,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-18','2025-09-18',121514.07,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL);
INSERT INTO `balance_libro` VALUES (2052,7908,40720,1571,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-18','2025-09-18',60010.98,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2053,7908,40720,1571,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-22','2025-09-22',100039.94,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2054,7908,40720,1571,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-22','2025-09-22',80009.00,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2055,7908,40720,1571,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-22','2025-09-22',50013.05,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2056,7908,40720,1571,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-23','2025-09-23',60082.04,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2057,7908,40720,1571,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-23','2025-09-23',40026.93,NULL,NULL,1,'2025-10-30 19:23:00','2025-10-30 19:23:00',NULL),(2058,7908,40720,1571,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-25','2025-09-25',40017.05,NULL,NULL,1,'2025-10-30 19:23:01','2025-10-30 19:23:01',NULL),(2059,7908,40720,1571,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-25','2025-09-25',70042.07,NULL,NULL,1,'2025-10-30 19:23:01','2025-10-30 19:23:01',NULL),(2060,7908,40720,1571,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',50008.08,NULL,NULL,1,'2025-10-30 19:23:01','2025-10-30 19:23:01',NULL),(2061,7908,40720,1571,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-26','2025-09-26',60007.01,NULL,NULL,1,'2025-10-30 19:23:01','2025-10-30 19:23:01',NULL),(2062,7908,40720,1571,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-09-30','2025-09-30',40002.95,NULL,NULL,1,'2025-10-30 19:23:01','2025-10-30 19:23:01',NULL),(2063,7908,40720,1572,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-02','2025-10-02',39995.93,NULL,NULL,1,'2025-11-04 20:21:13','2025-11-04 20:21:13',NULL),(2064,7908,40720,1572,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-02','2025-10-02',50195.96,NULL,NULL,1,'2025-11-04 20:21:13','2025-11-04 20:21:13',NULL),(2065,7908,40720,1572,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-02','2025-10-02',40001.99,NULL,NULL,1,'2025-11-04 20:21:13','2025-11-04 20:21:13',NULL),(2066,7908,40720,1572,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-05','2025-10-05',30016.02,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2067,7908,40720,1572,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-06','2025-10-06',50022.00,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2068,7908,40720,1572,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-07','2025-10-07',50043.09,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2069,7908,40720,1572,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-07','2025-10-07',50030.04,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2070,7908,40720,1572,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-08','2025-10-08',40023.95,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2071,7908,40720,1572,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-09','2025-10-09',58162.12,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2072,7908,40720,1572,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-10','2025-10-10',80058.05,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL);
INSERT INTO `balance_libro` VALUES (2073,7908,40720,1572,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-10','2025-10-10',30056.08,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2074,7908,40720,1572,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-12','2025-10-12',30017.05,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2075,7908,40720,1572,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-13','2025-10-13',40010.04,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2076,7908,40720,1572,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-16','2025-10-16',40000.01,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2077,7908,40720,1572,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',89930.87,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2078,7908,40720,1572,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',30730.97,NULL,NULL,1,'2025-11-04 20:21:14','2025-11-04 20:21:14',NULL),(2079,7908,40720,1572,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',25013.05,NULL,NULL,1,'2025-11-04 20:21:15','2025-11-04 20:21:15',NULL),(2080,7908,40720,1572,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-23','2025-10-23',72009.03,NULL,NULL,1,'2025-11-04 20:21:15','2025-11-04 20:21:15',NULL),(2081,7908,40720,1572,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-26','2025-10-26',40001.07,NULL,NULL,1,'2025-11-04 20:21:15','2025-11-04 20:21:15',NULL),(2082,7908,40720,1572,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-26','2025-10-26',29997.01,NULL,NULL,1,'2025-11-04 20:21:15','2025-11-04 20:21:15',NULL),(2083,7908,40720,1572,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-30','2025-10-30',100048.02,NULL,NULL,1,'2025-11-04 20:21:15','2025-11-04 20:21:15',NULL),(2084,7908,40720,1572,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-30','2025-10-30',50046.02,NULL,NULL,1,'2025-11-04 20:21:15','2025-11-04 20:21:15',NULL),(2085,7908,40720,1572,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-31','2025-10-31',55000.03,NULL,NULL,1,'2025-11-04 20:21:15','2025-11-04 20:21:15',NULL),(2086,7908,40720,1572,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-01','2025-10-01',52008.69,NULL,NULL,1,'2025-11-04 20:43:56','2025-11-04 20:43:56',NULL),(2087,7908,40720,1572,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-01','2025-10-01',280512.64,NULL,NULL,1,'2025-11-04 20:43:56','2025-11-04 20:43:56',NULL),(2088,7908,40720,1572,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-02','2025-10-02',10504.79,NULL,NULL,1,'2025-11-04 20:43:56','2025-11-04 20:43:56',NULL),(2089,7908,40720,1572,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-03','2025-10-03',42000.00,NULL,NULL,1,'2025-11-04 20:43:56','2025-11-04 20:45:55','2025-11-04 20:45:55'),(2090,7908,40720,1572,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-09','2025-10-09',13500.00,NULL,NULL,1,'2025-11-04 20:43:56','2025-11-04 20:43:56',NULL),(2091,7908,40720,1572,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-09','2025-10-09',711706.50,NULL,NULL,1,'2025-11-04 20:43:56','2025-11-04 20:43:56',NULL),(2092,7908,40720,1572,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-22','2025-10-22',93230.50,NULL,NULL,1,'2025-11-04 20:43:56','2025-11-04 20:43:56',NULL),(2093,7908,40720,1572,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-31','2025-10-31',55000.01,NULL,NULL,1,'2025-11-04 20:43:56','2025-11-04 20:43:56',NULL);
INSERT INTO `balance_libro` VALUES (2094,7908,40720,1572,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-10-03','2025-10-03',42000.02,NULL,NULL,1,'2025-11-04 20:45:55','2025-11-04 20:45:55',NULL),(2095,7908,40720,1573,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-04','2025-11-04',24000011.20,NULL,NULL,1,'2025-11-04 22:57:44','2025-11-04 22:57:44',NULL),(2096,7908,40720,1573,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-04','2025-11-04',50000.04,NULL,NULL,1,'2025-11-14 18:52:46','2025-11-14 18:52:46',NULL),(2097,7908,40720,1573,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-06','2025-11-06',480654.92,NULL,NULL,1,'2025-11-14 18:52:46','2025-11-14 18:52:46',NULL),(2098,7908,40720,1573,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-10','2025-11-10',21000.00,NULL,NULL,1,'2025-11-14 18:52:46','2025-11-14 18:52:46',NULL),(2099,7908,40720,1573,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-11','2025-11-11',1965.79,NULL,NULL,1,'2025-11-14 18:52:46','2025-11-14 18:52:46',NULL),(2100,7908,40720,1573,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-13','2025-11-13',53.57,NULL,NULL,1,'2025-11-14 18:52:46','2025-11-14 18:52:46',NULL),(2101,7908,40720,1573,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',226330.90,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2102,7908,40720,1573,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',1173700.00,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2103,7908,40720,1573,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',1064800.00,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2104,7908,40720,1573,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',695702.16,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2105,7908,40720,1573,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',29420.44,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2106,7908,40720,1573,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',296450.00,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2107,7908,40720,1573,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',413126.85,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2108,7908,40720,1573,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',186.76,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2109,7908,40720,1573,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',85971.29,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2110,7908,40720,1573,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',10671.40,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2111,7908,40720,1573,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',153878.19,NULL,NULL,1,'2025-11-20 15:49:50','2025-11-20 15:49:50',NULL),(2112,7908,40720,1573,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-14','2025-11-14',1862.89,NULL,NULL,1,'2025-11-20 15:49:51','2025-11-20 15:49:51',NULL),(2113,7908,40720,1573,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-18','2025-11-18',1452000.00,NULL,NULL,1,'2025-11-20 15:49:51','2025-11-20 15:49:51',NULL),(2114,7908,40720,1573,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-11-18','2025-11-18',2000000.00,NULL,NULL,1,'2025-11-20 15:49:51','2025-11-20 15:49:51',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7738 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7908,1,40720,1526,3,217,1,905.84,NULL,'2022-10-03 12:16:31','2022-10-03 12:16:31',NULL),(2,7908,1,40720,1526,3,68,1,190.23,NULL,'2022-10-03 12:16:31','2022-10-03 12:16:31',NULL),(3,7908,1,40720,1526,3,222,1,103.99,NULL,'2022-10-03 12:16:31','2022-10-03 12:16:31',NULL),(4,7908,1,40720,1526,3,57,2,1200.06,NULL,'2022-10-03 12:16:31','2022-10-03 12:16:31',NULL),(5,7908,2,40720,1526,3,217,1,3774.11,NULL,'2022-10-03 18:01:33','2022-10-03 18:01:33',NULL),(6,7908,2,40720,1526,3,68,1,792.56,NULL,'2022-10-03 18:01:33','2022-10-03 18:01:33',NULL),(7,7908,2,40720,1526,3,222,1,433.28,NULL,'2022-10-03 18:01:33','2022-10-03 18:01:33',NULL),(8,7908,2,40720,1526,3,57,2,4999.95,NULL,'2022-10-03 18:01:33','2022-10-03 18:01:33',NULL),(9,7908,3,40720,1526,3,217,1,1430.80,NULL,'2022-10-03 18:05:16','2022-10-03 18:05:16',NULL),(10,7908,3,40720,1526,3,68,1,300.47,NULL,'2022-10-03 18:05:16','2022-10-03 18:05:16',NULL),(11,7908,3,40720,1526,3,222,1,270.11,NULL,'2022-10-03 18:05:16','2022-10-03 18:05:16',NULL),(12,7908,3,40720,1526,3,57,2,2001.38,NULL,'2022-10-03 18:05:16','2022-10-03 18:05:16',NULL),(13,7908,4,40720,1526,3,217,1,1174.20,NULL,'2022-10-03 18:08:01','2022-10-03 18:08:01',NULL),(14,7908,4,40720,1526,3,68,1,246.58,NULL,'2022-10-03 18:08:01','2022-10-03 18:08:01',NULL),(15,7908,4,40720,1526,3,222,1,80.13,NULL,'2022-10-03 18:08:01','2022-10-03 18:08:01',NULL),(16,7908,4,40720,1526,3,57,2,1500.91,NULL,'2022-10-03 18:08:01','2022-10-03 18:08:01',NULL),(17,7908,5,40720,1526,3,217,1,1543.72,NULL,'2022-10-03 18:09:50','2022-10-03 18:09:50',NULL),(18,7908,5,40720,1526,3,68,1,324.18,NULL,'2022-10-03 18:09:50','2022-10-03 18:09:50',NULL),(19,7908,5,40720,1526,3,222,1,131.68,NULL,'2022-10-03 18:09:50','2022-10-03 18:09:50',NULL),(20,7908,5,40720,1526,3,57,2,1999.58,NULL,'2022-10-03 18:09:50','2022-10-03 18:09:50',NULL),(21,7908,6,40720,1526,3,217,1,1837.58,NULL,'2022-10-03 18:13:10','2022-10-03 18:14:14','2022-10-03 18:14:14'),(22,7908,6,40720,1526,3,68,1,385.89,NULL,'2022-10-03 18:13:10','2022-10-03 18:14:14','2022-10-03 18:14:14'),(23,7908,6,40720,1526,3,222,1,342.94,NULL,'2022-10-03 18:13:10','2022-10-03 18:14:14','2022-10-03 18:14:14'),(24,7908,6,40720,1526,3,57,2,2566.41,NULL,'2022-10-03 18:13:10','2022-10-03 18:14:14','2022-10-03 18:14:14'),(25,7908,7,40720,1526,3,217,1,2278.89,NULL,'2022-10-03 18:14:14','2022-10-03 18:14:14',NULL),(26,7908,7,40720,1526,3,68,1,478.57,NULL,'2022-10-03 18:14:14','2022-10-03 18:14:14',NULL),(27,7908,7,40720,1526,3,222,1,342.94,NULL,'2022-10-03 18:14:14','2022-10-03 18:14:14',NULL),(28,7908,7,40720,1526,3,57,2,3100.40,NULL,'2022-10-03 18:14:14','2022-10-03 18:14:14',NULL),(29,7908,8,40720,1526,3,217,1,7467.01,NULL,'2022-10-03 18:18:30','2022-10-03 18:18:30',NULL),(30,7908,8,40720,1526,3,68,1,1568.07,NULL,'2022-10-03 18:18:30','2022-10-03 18:18:30',NULL),(31,7908,8,40720,1526,3,222,1,992.41,NULL,'2022-10-03 18:18:30','2022-10-03 18:18:30',NULL),(32,7908,8,40720,1526,3,57,2,10027.49,NULL,'2022-10-03 18:18:30','2022-10-03 18:18:30',NULL),(33,7908,9,40720,1526,3,217,1,3675.45,NULL,'2022-10-03 18:20:39','2022-10-03 18:20:39',NULL),(34,7908,9,40720,1526,3,68,1,771.84,NULL,'2022-10-03 18:20:39','2022-10-03 18:20:39',NULL),(35,7908,9,40720,1526,3,222,1,553.10,NULL,'2022-10-03 18:20:39','2022-10-03 18:20:39',NULL),(36,7908,9,40720,1526,3,57,2,5000.39,NULL,'2022-10-03 18:20:39','2022-10-03 18:20:39',NULL),(37,7908,10,40720,1526,3,217,1,2327.35,NULL,'2022-10-03 18:22:57','2022-10-03 18:22:57',NULL),(38,7908,10,40720,1526,3,68,1,488.74,NULL,'2022-10-03 18:22:57','2022-10-03 18:22:57',NULL),(39,7908,10,40720,1526,3,222,1,183.89,NULL,'2022-10-03 18:22:57','2022-10-03 18:22:57',NULL),(40,7908,10,40720,1526,3,57,2,2999.98,NULL,'2022-10-03 18:22:57','2022-10-03 18:22:57',NULL),(41,7908,11,40720,1526,3,217,1,5476.71,NULL,'2022-10-03 18:26:29','2022-10-03 18:26:29',NULL),(42,7908,11,40720,1526,3,68,1,1150.11,NULL,'2022-10-03 18:26:29','2022-10-03 18:26:29',NULL);
INSERT INTO `balance_libro_details` VALUES (43,7908,11,40720,1526,3,222,1,369.10,NULL,'2022-10-03 18:26:29','2022-10-03 18:26:29',NULL),(44,7908,11,40720,1526,3,57,2,6995.92,NULL,'2022-10-03 18:26:29','2022-10-03 18:26:29',NULL),(45,7908,12,40720,1526,3,217,1,2214.07,NULL,'2022-10-03 18:30:18','2022-10-03 18:30:18',NULL),(46,7908,12,40720,1526,3,68,1,464.95,NULL,'2022-10-03 18:30:18','2022-10-03 18:30:18',NULL),(47,7908,12,40720,1526,3,222,1,333.18,NULL,'2022-10-03 18:30:18','2022-10-03 18:30:18',NULL),(48,7908,12,40720,1526,3,57,2,3012.20,NULL,'2022-10-03 18:30:18','2022-10-03 18:30:18',NULL),(49,7908,13,40720,1526,3,217,1,2357.07,NULL,'2022-10-03 18:31:52','2022-10-03 18:31:52',NULL),(50,7908,13,40720,1526,3,68,1,494.98,NULL,'2022-10-03 18:31:52','2022-10-03 18:31:52',NULL),(51,7908,13,40720,1526,3,222,1,186.24,NULL,'2022-10-03 18:31:52','2022-10-03 18:31:52',NULL),(52,7908,13,40720,1526,3,57,2,3038.29,NULL,'2022-10-03 18:31:52','2022-10-03 18:31:52',NULL),(53,7908,14,40720,1526,3,217,1,4526.55,NULL,'2022-10-03 18:33:37','2022-10-03 18:33:37',NULL),(54,7908,14,40720,1526,3,68,1,950.58,NULL,'2022-10-03 18:33:37','2022-10-03 18:33:37',NULL),(55,7908,14,40720,1526,3,222,1,523.77,NULL,'2022-10-03 18:33:37','2022-10-03 18:33:37',NULL),(56,7908,14,40720,1526,3,57,2,6000.90,NULL,'2022-10-03 18:33:37','2022-10-03 18:33:37',NULL),(57,7908,15,40720,1526,3,217,1,3104.17,NULL,'2022-10-03 18:35:10','2022-10-03 18:35:10',NULL),(58,7908,15,40720,1526,3,68,1,651.88,NULL,'2022-10-03 18:35:10','2022-10-03 18:35:10',NULL),(59,7908,15,40720,1526,3,222,1,245.27,NULL,'2022-10-03 18:35:10','2022-10-03 18:35:10',NULL),(60,7908,15,40720,1526,3,57,2,4001.32,NULL,'2022-10-03 18:35:10','2022-10-03 18:35:10',NULL),(61,7908,16,40720,1526,3,217,1,16528.93,NULL,'2022-10-03 18:38:49','2022-10-03 18:38:49',NULL),(62,7908,16,40720,1526,3,68,1,3471.08,NULL,'2022-10-03 18:38:49','2022-10-03 18:38:49',NULL),(63,7908,16,40720,1526,3,57,2,20000.01,NULL,'2022-10-03 18:38:49','2022-10-03 18:38:49',NULL),(64,7908,17,40720,1526,3,217,1,24793.39,NULL,'2022-10-03 18:40:42','2022-10-03 18:40:42',NULL),(65,7908,17,40720,1526,3,68,1,5206.61,NULL,'2022-10-03 18:40:42','2022-10-03 18:40:42',NULL),(66,7908,17,40720,1526,3,57,2,30000.00,NULL,'2022-10-03 18:40:42','2022-10-03 18:40:42',NULL),(67,7908,18,40720,1526,3,217,1,1565.75,NULL,'2022-10-03 18:42:32','2022-10-03 18:42:32',NULL),(68,7908,18,40720,1526,3,68,1,328.81,NULL,'2022-10-03 18:42:32','2022-10-03 18:42:32',NULL),(69,7908,18,40720,1526,3,222,1,105.52,NULL,'2022-10-03 18:42:32','2022-10-03 18:42:32',NULL),(70,7908,18,40720,1526,3,57,2,2000.08,NULL,'2022-10-03 18:42:32','2022-10-03 18:42:32',NULL),(71,7908,19,40720,1526,3,217,1,1544.03,NULL,'2022-10-03 18:43:54','2022-10-03 18:43:54',NULL),(72,7908,19,40720,1526,3,68,1,324.25,NULL,'2022-10-03 18:43:54','2022-10-03 18:43:54',NULL),(73,7908,19,40720,1526,3,222,1,131.71,NULL,'2022-10-03 18:43:54','2022-10-03 18:43:54',NULL),(74,7908,19,40720,1526,3,57,2,1999.99,NULL,'2022-10-03 18:43:54','2022-10-03 18:43:54',NULL),(75,7908,20,40720,1526,3,217,1,6794.22,NULL,'2022-10-03 18:45:29','2022-10-03 18:45:29',NULL),(76,7908,20,40720,1526,3,68,1,1426.79,NULL,'2022-10-03 18:45:29','2022-10-03 18:45:29',NULL),(77,7908,20,40720,1526,3,222,1,779.98,NULL,'2022-10-03 18:45:29','2022-10-03 18:45:29',NULL),(78,7908,20,40720,1526,3,57,2,9000.99,NULL,'2022-10-03 18:45:29','2022-10-03 18:45:29',NULL),(79,7908,21,40720,1526,3,217,1,2263.93,NULL,'2022-10-03 18:47:36','2022-10-03 18:47:36',NULL),(80,7908,21,40720,1526,3,68,1,475.43,NULL,'2022-10-03 18:47:36','2022-10-03 18:47:36',NULL),(81,7908,21,40720,1526,3,222,1,261.96,NULL,'2022-10-03 18:47:36','2022-10-03 18:47:36',NULL),(82,7908,21,40720,1526,3,57,2,3001.32,NULL,'2022-10-03 18:47:36','2022-10-03 18:47:36',NULL),(83,7908,22,40720,1526,3,217,1,1887.11,NULL,'2022-10-03 18:49:37','2022-10-03 18:49:37',NULL),(84,7908,22,40720,1526,3,68,1,396.29,NULL,'2022-10-03 18:49:37','2022-10-03 18:49:37',NULL);
INSERT INTO `balance_libro_details` VALUES (85,7908,22,40720,1526,3,222,1,216.65,NULL,'2022-10-03 18:49:37','2022-10-03 18:49:37',NULL),(86,7908,22,40720,1526,3,57,2,2500.05,NULL,'2022-10-03 18:49:37','2022-10-03 18:49:37',NULL),(87,7908,23,40720,1526,3,217,1,2314.70,NULL,'2022-10-04 12:36:29','2022-10-04 12:36:29',NULL),(88,7908,23,40720,1526,3,68,1,486.09,NULL,'2022-10-04 12:36:29','2022-10-04 12:36:29',NULL),(89,7908,23,40720,1526,3,222,1,178.86,NULL,'2022-10-04 12:36:29','2022-10-04 12:36:29',NULL),(90,7908,23,40720,1526,3,57,2,2979.65,NULL,'2022-10-04 12:36:29','2022-10-04 12:36:29',NULL),(91,7908,24,40720,1526,3,217,1,2328.14,NULL,'2022-10-04 12:39:55','2022-10-04 12:39:55',NULL),(92,7908,24,40720,1526,3,68,1,488.91,NULL,'2022-10-04 12:39:55','2022-10-04 12:39:55',NULL),(93,7908,24,40720,1526,3,222,1,183.95,NULL,'2022-10-04 12:39:55','2022-10-04 12:39:55',NULL),(94,7908,24,40720,1526,3,57,2,3001.00,NULL,'2022-10-04 12:39:55','2022-10-04 12:39:55',NULL),(95,7908,25,40720,1526,3,217,1,15087.61,NULL,'2022-10-04 12:41:37','2022-10-04 12:41:37',NULL),(96,7908,25,40720,1526,3,68,1,3168.40,NULL,'2022-10-04 12:41:37','2022-10-04 12:41:37',NULL),(97,7908,25,40720,1526,3,222,1,1745.79,NULL,'2022-10-04 12:41:37','2022-10-04 12:41:37',NULL),(98,7908,25,40720,1526,3,57,2,20001.80,NULL,'2022-10-04 12:41:37','2022-10-04 12:41:37',NULL),(99,7908,26,40720,1526,3,217,1,15103.90,NULL,'2022-10-04 12:43:01','2022-10-04 12:43:01',NULL),(100,7908,26,40720,1526,3,68,1,3171.82,NULL,'2022-10-04 12:43:01','2022-10-04 12:43:01',NULL),(101,7908,26,40720,1526,3,222,1,1747.68,NULL,'2022-10-04 12:43:01','2022-10-04 12:43:01',NULL),(102,7908,26,40720,1526,3,57,2,20023.40,NULL,'2022-10-04 12:43:01','2022-10-04 12:43:01',NULL),(103,7908,27,40720,1526,3,217,1,2264.54,NULL,'2022-10-04 12:44:53','2022-10-04 12:44:53',NULL),(104,7908,27,40720,1526,3,68,1,475.55,NULL,'2022-10-04 12:44:53','2022-10-04 12:44:53',NULL),(105,7908,27,40720,1526,3,222,1,259.97,NULL,'2022-10-04 12:44:53','2022-10-04 12:44:53',NULL),(106,7908,27,40720,1526,3,57,2,3000.06,NULL,'2022-10-04 12:44:53','2022-10-04 12:44:53',NULL),(107,7908,28,40720,1526,3,217,1,1854.88,NULL,'2022-10-04 12:49:20','2022-10-04 12:49:20',NULL),(108,7908,28,40720,1526,3,68,1,389.52,NULL,'2022-10-04 12:49:20','2022-10-04 12:49:20',NULL),(109,7908,28,40720,1526,3,249,1,27.83,NULL,'2022-10-04 12:49:20','2022-10-04 12:49:20',NULL),(110,7908,28,40720,1526,3,57,2,2272.23,NULL,'2022-10-04 12:49:20','2022-10-04 12:49:20',NULL),(111,7908,29,40720,1526,3,217,1,147933.89,NULL,'2022-10-04 12:52:20','2022-10-04 12:52:20',NULL),(112,7908,29,40720,1526,3,68,1,31066.12,NULL,'2022-10-04 12:52:20','2022-10-04 12:52:20',NULL),(113,7908,29,40720,1526,3,57,2,179000.01,NULL,'2022-10-04 12:52:20','2022-10-04 12:52:20',NULL),(114,7908,30,40720,1526,3,217,1,115872.54,NULL,'2022-10-05 12:17:57','2022-10-05 12:17:57',NULL),(115,7908,30,40720,1526,3,68,1,24333.23,NULL,'2022-10-05 12:17:57','2022-10-05 12:17:57',NULL),(116,7908,30,40720,1526,3,249,1,869.41,NULL,'2022-10-05 12:17:57','2022-10-05 12:17:57',NULL),(117,7908,30,40720,1526,3,57,2,141075.18,NULL,'2022-10-05 12:17:57','2022-10-05 12:17:57',NULL),(118,7908,31,40720,1526,3,217,1,75963.35,NULL,'2022-10-05 12:20:41','2022-10-05 12:20:41',NULL),(119,7908,31,40720,1526,3,68,1,15952.30,NULL,'2022-10-05 12:20:41','2022-10-05 12:20:41',NULL),(120,7908,31,40720,1526,3,249,1,569.81,NULL,'2022-10-05 12:20:41','2022-10-05 12:20:41',NULL),(121,7908,31,40720,1526,3,57,2,92485.46,NULL,'2022-10-05 12:20:41','2022-10-05 12:20:41',NULL),(122,7908,32,40720,1526,3,217,1,160077.40,NULL,'2022-10-05 12:23:11','2022-10-05 12:23:11',NULL),(123,7908,32,40720,1526,3,68,1,33616.25,NULL,'2022-10-05 12:23:11','2022-10-05 12:23:11',NULL),(124,7908,32,40720,1526,3,249,1,1201.31,NULL,'2022-10-05 12:23:11','2022-10-05 12:23:11',NULL),(125,7908,32,40720,1526,3,57,2,194894.96,NULL,'2022-10-05 12:23:11','2022-10-05 12:23:11',NULL),(126,7908,33,40720,1526,3,217,1,49932.40,NULL,'2022-10-05 12:25:56','2022-10-05 12:25:56',NULL);
INSERT INTO `balance_libro_details` VALUES (127,7908,33,40720,1526,3,68,1,10485.80,NULL,'2022-10-05 12:25:56','2022-10-05 12:25:56',NULL),(128,7908,33,40720,1526,3,249,1,374.49,NULL,'2022-10-05 12:25:56','2022-10-05 12:25:56',NULL),(129,7908,33,40720,1526,3,57,2,60792.69,NULL,'2022-10-05 12:25:56','2022-10-05 12:25:56',NULL),(130,7908,34,40720,1526,3,217,1,51063.22,NULL,'2022-10-05 12:30:13','2022-10-05 12:30:13',NULL),(131,7908,34,40720,1526,3,68,1,10723.28,NULL,'2022-10-05 12:30:14','2022-10-05 12:30:14',NULL),(132,7908,34,40720,1526,3,249,1,383.30,NULL,'2022-10-05 12:30:14','2022-10-05 12:30:14',NULL),(133,7908,34,40720,1526,3,57,2,62169.80,NULL,'2022-10-05 12:30:14','2022-10-05 12:30:14',NULL),(134,7908,35,40720,1526,3,217,1,329113.26,NULL,'2022-10-05 12:35:30','2022-10-05 12:35:30',NULL),(135,7908,35,40720,1526,3,68,1,69113.78,NULL,'2022-10-05 12:35:30','2022-10-05 12:35:30',NULL),(136,7908,35,40720,1526,3,249,1,2468.71,NULL,'2022-10-05 12:35:30','2022-10-05 12:35:30',NULL),(137,7908,35,40720,1526,3,57,2,400695.75,NULL,'2022-10-05 12:35:30','2022-10-05 12:35:30',NULL),(138,7908,36,40720,1526,3,217,1,20707.26,NULL,'2022-10-05 12:39:26','2022-10-05 12:39:26',NULL),(139,7908,36,40720,1526,3,68,1,4348.52,NULL,'2022-10-05 12:39:26','2022-10-05 12:39:26',NULL),(140,7908,36,40720,1526,3,249,1,155.67,NULL,'2022-10-05 12:39:26','2022-10-05 12:39:26',NULL),(141,7908,36,40720,1526,3,57,2,25211.45,NULL,'2022-10-05 12:39:26','2022-10-05 12:39:26',NULL),(142,7908,37,40720,1526,2,96,1,115872.54,NULL,'2022-10-05 12:45:31','2022-10-05 12:55:18','2022-10-05 12:55:18'),(143,7908,37,40720,1526,2,68,1,24333.23,NULL,'2022-10-05 12:45:31','2022-10-05 12:55:18','2022-10-05 12:55:18'),(144,7908,37,40720,1526,2,249,1,869.41,NULL,'2022-10-05 12:45:31','2022-10-05 12:55:18','2022-10-05 12:55:18'),(145,7908,37,40720,1526,2,13,2,141075.18,NULL,'2022-10-05 12:45:31','2022-10-05 12:55:18','2022-10-05 12:55:18'),(146,7908,38,40720,1526,2,96,2,115872.54,NULL,'2022-10-05 12:55:18','2022-10-05 12:55:18',NULL),(147,7908,38,40720,1526,2,67,2,24333.23,NULL,'2022-10-05 12:55:18','2022-10-05 12:55:18',NULL),(148,7908,38,40720,1526,2,249,2,869.41,NULL,'2022-10-05 12:55:18','2022-10-05 12:55:18',NULL),(149,7908,38,40720,1526,2,13,1,141075.18,NULL,'2022-10-05 12:55:18','2022-10-05 12:55:18',NULL),(150,7908,39,40720,1526,2,96,2,100000.00,NULL,'2022-10-11 12:11:57','2022-10-12 12:57:50','2022-10-12 12:57:50'),(151,7908,39,40720,1526,2,67,2,10500.00,NULL,'2022-10-11 12:11:57','2022-10-12 12:57:50','2022-10-12 12:57:50'),(152,7908,39,40720,1526,2,13,1,110500.00,NULL,'2022-10-11 12:11:57','2022-10-12 12:57:50','2022-10-12 12:57:50'),(153,7908,40,40720,1526,7,25,1,57894.35,NULL,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL),(154,7908,40,40720,1526,7,13,2,57894.35,NULL,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL),(155,7908,41,40720,1526,7,25,1,138288.44,NULL,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL),(156,7908,41,40720,1526,7,13,2,138288.44,NULL,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL),(157,7908,42,40720,1526,7,25,1,258960.31,NULL,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL),(158,7908,42,40720,1526,7,13,2,258960.31,NULL,'2022-10-12 12:47:43','2022-10-12 12:47:43',NULL),(159,7908,43,40720,1525,15,354,1,807.64,NULL,'2022-10-12 13:18:48','2022-10-12 13:18:48',NULL),(160,7908,43,40720,1525,15,136,2,807.64,NULL,'2022-10-12 13:18:48','2022-10-12 13:18:48',NULL),(161,7908,44,40720,1526,2,96,2,827062.16,NULL,'2022-10-12 14:59:47','2022-10-12 14:59:47',NULL),(162,7908,44,40720,1526,2,67,2,86841.53,NULL,'2022-10-12 14:59:47','2022-10-12 14:59:47',NULL),(163,7908,44,40720,1526,2,13,1,913903.69,NULL,'2022-10-12 14:59:47','2022-10-12 14:59:47',NULL),(164,7908,45,40720,1526,2,96,2,1975549.10,NULL,'2022-10-12 15:02:34','2022-10-12 15:02:34',NULL),(165,7908,45,40720,1526,2,67,2,207432.66,NULL,'2022-10-12 15:02:34','2022-10-12 15:02:34',NULL),(166,7908,45,40720,1526,2,13,1,2182981.76,NULL,'2022-10-12 15:02:34','2022-10-12 15:02:34',NULL);
INSERT INTO `balance_libro_details` VALUES (167,7908,46,40720,1526,2,96,2,3699433.00,NULL,'2022-10-12 15:05:37','2022-10-12 15:05:37',NULL),(168,7908,46,40720,1526,2,67,2,388440.47,NULL,'2022-10-12 15:05:37','2022-10-12 15:05:37',NULL),(169,7908,46,40720,1526,2,13,1,4087873.47,NULL,'2022-10-12 15:05:37','2022-10-12 15:05:37',NULL),(170,7908,47,40720,1526,15,67,1,707047.88,NULL,'2022-10-12 15:26:05','2022-10-12 19:43:44','2022-10-12 19:43:44'),(171,7908,47,40720,1526,15,68,2,228322.58,NULL,'2022-10-12 15:26:05','2022-10-12 19:43:44','2022-10-12 19:43:44'),(172,7908,47,40720,1526,15,354,2,807.64,NULL,'2022-10-12 15:26:05','2022-10-12 19:43:44','2022-10-12 19:43:44'),(173,7908,47,40720,1526,15,25,2,455143.10,NULL,'2022-10-12 15:26:05','2022-10-12 19:43:44','2022-10-12 19:43:44'),(174,7908,47,40720,1526,15,74,2,22774.56,NULL,'2022-10-12 15:26:05','2022-10-12 19:43:44','2022-10-12 19:43:44'),(175,7908,48,40720,1526,15,67,1,707047.88,NULL,'2022-10-12 20:49:14','2022-10-13 00:16:50','2022-10-13 00:16:50'),(176,7908,48,40720,1526,15,68,2,228322.58,NULL,'2022-10-12 20:49:14','2022-10-13 00:16:50','2022-10-13 00:16:50'),(177,7908,48,40720,1526,15,354,2,807.64,NULL,'2022-10-12 20:49:14','2022-10-13 00:16:50','2022-10-13 00:16:50'),(178,7908,48,40720,1526,15,25,2,455143.10,NULL,'2022-10-12 20:49:14','2022-10-13 00:16:50','2022-10-13 00:16:50'),(179,7908,48,40720,1526,15,74,2,22774.56,NULL,'2022-10-12 20:49:14','2022-10-13 00:16:50','2022-10-13 00:16:50'),(180,7908,49,40720,1526,7,25,1,87.00,NULL,'2022-10-13 13:01:03','2022-10-13 13:01:03',NULL),(181,7908,49,40720,1526,7,13,2,87.00,NULL,'2022-10-13 13:01:03','2022-10-13 13:01:03',NULL),(182,7908,50,40720,1526,7,25,1,544.16,NULL,'2022-10-13 13:07:58','2022-10-13 13:07:58',NULL),(183,7908,50,40720,1526,7,13,2,544.16,NULL,'2022-10-13 13:07:58','2022-10-13 13:07:58',NULL),(184,7908,51,40720,1526,15,67,1,707047.88,NULL,'2022-10-15 15:19:05','2022-10-15 15:19:05',NULL),(185,7908,51,40720,1526,15,68,2,228322.58,NULL,'2022-10-15 15:19:05','2022-10-15 15:19:05',NULL),(186,7908,51,40720,1526,15,354,2,807.64,NULL,'2022-10-15 15:19:05','2022-10-15 15:19:05',NULL),(187,7908,51,40720,1526,15,25,2,455774.26,NULL,'2022-10-15 15:19:05','2022-10-15 15:19:05',NULL),(188,7908,51,40720,1526,15,74,2,22143.40,NULL,'2022-10-15 15:19:05','2022-10-15 15:19:05',NULL),(189,7908,52,40720,1527,3,217,1,2265.63,NULL,'2022-11-07 12:15:03','2022-11-07 12:15:03',NULL),(190,7908,52,40720,1527,3,68,1,475.78,NULL,'2022-11-07 12:15:03','2022-11-07 12:15:03',NULL),(191,7908,52,40720,1527,3,222,1,258.53,NULL,'2022-11-07 12:15:03','2022-11-07 12:15:03',NULL),(192,7908,52,40720,1527,3,57,2,2999.94,NULL,'2022-11-07 12:15:03','2022-11-07 12:15:03',NULL),(193,7908,53,40720,1527,3,217,1,1251.95,NULL,'2022-11-07 12:18:17','2022-11-07 12:18:17',NULL),(194,7908,53,40720,1527,3,68,1,262.91,NULL,'2022-11-07 12:18:17','2022-11-07 12:18:17',NULL),(195,7908,53,40720,1527,3,222,1,285.94,NULL,'2022-11-07 12:18:17','2022-11-07 12:18:17',NULL),(196,7908,53,40720,1527,3,57,2,1800.80,NULL,'2022-11-07 12:18:17','2022-11-07 12:18:17',NULL),(197,7908,54,40720,1527,3,217,1,2975.35,NULL,'2022-11-07 12:20:27','2022-11-07 12:20:27',NULL),(198,7908,54,40720,1527,3,68,1,624.82,NULL,'2022-11-07 12:20:27','2022-11-07 12:20:27',NULL),(199,7908,54,40720,1527,3,222,1,402.03,NULL,'2022-11-07 12:20:27','2022-11-07 12:20:27',NULL),(200,7908,54,40720,1527,3,57,2,4002.20,NULL,'2022-11-07 12:20:27','2022-11-07 12:20:27',NULL),(201,7908,55,40720,1527,3,217,1,14866.70,NULL,'2022-11-07 12:21:23','2022-11-07 12:21:23',NULL),(202,7908,55,40720,1527,3,68,1,3122.01,NULL,'2022-11-07 12:21:23','2022-11-07 12:21:23',NULL),(203,7908,55,40720,1527,3,222,1,2014.18,NULL,'2022-11-07 12:21:23','2022-11-07 12:21:23',NULL),(204,7908,55,40720,1527,3,57,2,20002.89,NULL,'2022-11-07 12:21:23','2022-11-07 12:21:23',NULL),(205,7908,56,40720,1527,3,217,1,3042.05,NULL,'2022-11-07 12:22:38','2022-11-07 12:23:28','2022-11-07 12:23:28'),(206,7908,56,40720,1527,3,68,1,638.83,NULL,'2022-11-07 12:22:38','2022-11-07 12:23:28','2022-11-07 12:23:28');
INSERT INTO `balance_libro_details` VALUES (207,7908,56,40720,1527,3,222,1,319.08,NULL,'2022-11-07 12:22:38','2022-11-07 12:23:28','2022-11-07 12:23:28'),(208,7908,56,40720,1527,3,57,2,3999.96,NULL,'2022-11-07 12:22:38','2022-11-07 12:23:28','2022-11-07 12:23:28'),(209,7908,57,40720,1527,3,217,1,3042.05,NULL,'2022-11-07 12:23:28','2022-11-07 12:23:28',NULL),(210,7908,57,40720,1527,3,68,1,638.83,NULL,'2022-11-07 12:23:28','2022-11-07 12:23:28',NULL),(211,7908,57,40720,1527,3,222,1,319.08,NULL,'2022-11-07 12:23:28','2022-11-07 12:23:28',NULL),(212,7908,57,40720,1527,3,57,2,3999.96,NULL,'2022-11-07 12:23:28','2022-11-07 12:23:28',NULL),(213,7908,58,40720,1527,3,217,1,12537.88,NULL,'2022-11-07 12:25:02','2022-11-07 12:25:02',NULL),(214,7908,58,40720,1527,3,68,1,2632.95,NULL,'2022-11-07 12:25:02','2022-11-07 12:25:02',NULL),(215,7908,58,40720,1527,3,222,1,1532.07,NULL,'2022-11-07 12:25:02','2022-11-07 12:25:02',NULL),(216,7908,58,40720,1527,3,57,2,16702.90,NULL,'2022-11-07 12:25:02','2022-11-07 12:25:02',NULL),(217,7908,59,40720,1527,3,217,1,1538.26,NULL,'2022-11-07 12:26:21','2022-11-07 12:26:21',NULL),(218,7908,59,40720,1527,3,68,1,323.03,NULL,'2022-11-07 12:26:21','2022-11-07 12:26:21',NULL),(219,7908,59,40720,1527,3,222,1,141.71,NULL,'2022-11-07 12:26:21','2022-11-07 12:26:21',NULL),(220,7908,59,40720,1527,3,57,2,2003.00,NULL,'2022-11-07 12:26:21','2022-11-07 12:26:21',NULL),(221,7908,60,40720,1527,3,217,1,3075.90,NULL,'2022-11-07 12:27:17','2022-11-07 12:27:17',NULL),(222,7908,60,40720,1527,3,68,1,645.94,NULL,'2022-11-07 12:27:17','2022-11-07 12:27:17',NULL),(223,7908,60,40720,1527,3,222,1,283.36,NULL,'2022-11-07 12:27:17','2022-11-07 12:27:17',NULL),(224,7908,60,40720,1527,3,57,2,4005.20,NULL,'2022-11-07 12:27:17','2022-11-07 12:27:17',NULL),(225,7908,61,40720,1527,3,217,1,26859.50,NULL,'2022-11-07 12:29:32','2022-11-07 12:29:32',NULL),(226,7908,61,40720,1527,3,68,1,5640.50,NULL,'2022-11-07 12:29:32','2022-11-07 12:29:32',NULL),(227,7908,61,40720,1527,3,57,2,32499.99,NULL,'2022-11-07 12:29:32','2022-11-07 12:29:32',NULL),(228,7908,61,40720,1527,3,136,2,0.01,NULL,'2022-11-07 12:29:32','2022-11-07 12:29:32',NULL),(229,7908,62,40720,1527,3,217,1,44920.66,NULL,'2022-11-07 12:31:41','2022-11-07 12:31:41',NULL),(230,7908,62,40720,1527,3,68,1,9433.34,NULL,'2022-11-07 12:31:41','2022-11-07 12:31:41',NULL),(231,7908,62,40720,1527,3,57,2,54354.00,NULL,'2022-11-07 12:31:41','2022-11-07 12:31:41',NULL),(232,7908,63,40720,1527,3,217,1,2429.75,NULL,'2022-11-07 12:33:10','2022-11-07 12:33:10',NULL),(233,7908,63,40720,1527,3,68,1,510.25,NULL,'2022-11-07 12:33:10','2022-11-07 12:33:10',NULL),(234,7908,63,40720,1527,3,57,2,2940.00,NULL,'2022-11-07 12:33:10','2022-11-07 12:33:10',NULL),(235,7908,64,40720,1527,3,217,1,4132.23,NULL,'2022-11-07 12:34:09','2022-11-07 12:34:09',NULL),(236,7908,64,40720,1527,3,68,1,867.77,NULL,'2022-11-07 12:34:09','2022-11-07 12:34:09',NULL),(237,7908,64,40720,1527,3,57,2,5000.00,NULL,'2022-11-07 12:34:09','2022-11-07 12:34:09',NULL),(238,7908,65,40720,1527,3,217,1,3893.07,NULL,'2022-11-07 12:36:44','2022-11-07 12:36:44',NULL),(239,7908,65,40720,1527,3,68,1,817.54,NULL,'2022-11-07 12:36:44','2022-11-07 12:36:44',NULL),(240,7908,65,40720,1527,3,57,2,4710.61,NULL,'2022-11-07 12:36:44','2022-11-07 12:36:44',NULL),(241,7908,66,40720,1527,3,217,1,2571.90,NULL,'2022-11-07 12:39:35','2022-11-07 14:48:52','2022-11-07 14:48:52'),(242,7908,66,40720,1527,3,68,1,540.10,NULL,'2022-11-07 12:39:35','2022-11-07 14:48:52','2022-11-07 14:48:52'),(243,7908,66,40720,1527,3,220,1,38.57,NULL,'2022-11-07 12:39:35','2022-11-07 14:48:52','2022-11-07 14:48:52'),(244,7908,66,40720,1527,3,57,2,3150.57,NULL,'2022-11-07 12:39:35','2022-11-07 14:48:52','2022-11-07 14:48:52'),(245,7908,67,40720,1527,3,217,1,3883.58,NULL,'2022-11-07 12:42:10','2022-11-07 12:42:10',NULL),(246,7908,67,40720,1527,3,68,1,815.55,NULL,'2022-11-07 12:42:10','2022-11-07 12:42:10',NULL),(247,7908,67,40720,1527,3,222,1,303.66,NULL,'2022-11-07 12:42:10','2022-11-07 12:42:10',NULL);
INSERT INTO `balance_libro_details` VALUES (248,7908,67,40720,1527,3,57,2,5002.79,NULL,'2022-11-07 12:42:10','2022-11-07 12:42:10',NULL),(249,7908,68,40720,1527,3,217,1,1539.49,NULL,'2022-11-07 12:43:44','2022-11-07 12:43:44',NULL),(250,7908,68,40720,1527,3,68,1,323.29,NULL,'2022-11-07 12:43:44','2022-11-07 12:43:44',NULL),(251,7908,68,40720,1527,3,222,1,141.82,NULL,'2022-11-07 12:43:44','2022-11-07 12:43:44',NULL),(252,7908,68,40720,1527,3,57,2,2004.60,NULL,'2022-11-07 12:43:44','2022-11-07 12:43:44',NULL),(253,7908,69,40720,1527,3,217,1,3839.89,NULL,'2022-11-07 12:44:38','2022-11-07 12:44:38',NULL),(254,7908,69,40720,1527,3,68,1,806.38,NULL,'2022-11-07 12:44:38','2022-11-07 12:44:38',NULL),(255,7908,69,40720,1527,3,222,1,353.74,NULL,'2022-11-07 12:44:38','2022-11-07 12:44:38',NULL),(256,7908,69,40720,1527,3,57,2,5000.01,NULL,'2022-11-07 12:44:38','2022-11-07 12:44:38',NULL),(257,7908,70,40720,1527,3,217,1,2691.53,NULL,'2022-11-07 12:45:48','2022-11-07 12:45:48',NULL),(258,7908,70,40720,1527,3,68,1,565.22,NULL,'2022-11-07 12:45:48','2022-11-07 12:45:48',NULL),(259,7908,70,40720,1527,3,222,1,247.95,NULL,'2022-11-07 12:45:48','2022-11-07 12:45:48',NULL),(260,7908,70,40720,1527,3,57,2,3504.70,NULL,'2022-11-07 12:45:48','2022-11-07 12:45:48',NULL),(261,7908,71,40720,1527,3,217,1,2306.62,NULL,'2022-11-07 12:46:44','2022-11-07 12:46:44',NULL),(262,7908,71,40720,1527,3,68,1,484.39,NULL,'2022-11-07 12:46:44','2022-11-07 12:46:44',NULL),(263,7908,71,40720,1527,3,222,1,212.49,NULL,'2022-11-07 12:46:44','2022-11-07 12:46:44',NULL),(264,7908,71,40720,1527,3,57,2,3003.50,NULL,'2022-11-07 12:46:44','2022-11-07 12:46:44',NULL),(265,7908,72,40720,1527,3,217,1,2245.46,NULL,'2022-11-07 12:48:05','2022-11-07 12:48:05',NULL),(266,7908,72,40720,1527,3,68,1,471.55,NULL,'2022-11-07 12:48:05','2022-11-07 12:48:05',NULL),(267,7908,72,40720,1527,3,222,1,286.89,NULL,'2022-11-07 12:48:05','2022-11-07 12:48:05',NULL),(268,7908,72,40720,1527,3,57,2,3003.90,NULL,'2022-11-07 12:48:05','2022-11-07 12:48:05',NULL),(269,7908,73,40720,1527,3,217,1,19874.44,NULL,'2022-11-07 12:49:53','2022-11-07 12:49:53',NULL),(270,7908,73,40720,1527,3,68,1,4173.63,NULL,'2022-11-07 12:49:53','2022-11-07 12:49:53',NULL),(271,7908,73,40720,1527,3,222,1,1553.98,NULL,'2022-11-07 12:49:53','2022-11-07 12:49:53',NULL),(272,7908,73,40720,1527,3,57,2,25602.05,NULL,'2022-11-07 12:49:53','2022-11-07 12:49:53',NULL),(273,7908,74,40720,1527,3,217,1,1573.30,NULL,'2022-11-07 12:51:03','2022-11-07 12:51:03',NULL),(274,7908,74,40720,1527,3,68,1,330.39,NULL,'2022-11-07 12:51:03','2022-11-07 12:51:03',NULL),(275,7908,74,40720,1527,3,222,1,98.44,NULL,'2022-11-07 12:51:04','2022-11-07 12:51:04',NULL),(276,7908,74,40720,1527,3,57,2,2002.13,NULL,'2022-11-07 12:51:04','2022-11-07 12:51:04',NULL),(277,7908,75,40720,1527,3,217,1,3072.21,NULL,'2022-11-07 12:53:55','2022-11-07 12:53:55',NULL),(278,7908,75,40720,1527,3,68,1,645.16,NULL,'2022-11-07 12:53:55','2022-11-07 12:53:55',NULL),(279,7908,75,40720,1527,3,222,1,283.02,NULL,'2022-11-07 12:53:55','2022-11-07 12:53:55',NULL),(280,7908,75,40720,1527,3,57,2,4000.39,NULL,'2022-11-07 12:53:55','2022-11-07 12:53:55',NULL),(281,7908,76,40720,1527,3,217,1,2086.21,NULL,'2022-11-07 12:55:11','2022-11-07 12:55:11',NULL),(282,7908,76,40720,1527,3,68,1,438.10,NULL,'2022-11-07 12:55:11','2022-11-07 12:55:11',NULL),(283,7908,76,40720,1527,3,222,1,476.48,NULL,'2022-11-07 12:55:11','2022-11-07 12:55:11',NULL),(284,7908,76,40720,1527,3,57,2,3000.79,NULL,'2022-11-07 12:55:11','2022-11-07 12:55:11',NULL),(285,7908,77,40720,1527,3,217,1,2157.32,NULL,'2022-11-07 12:56:12','2022-11-07 12:56:12',NULL),(286,7908,77,40720,1527,3,68,1,453.04,NULL,'2022-11-07 12:56:12','2022-11-07 12:56:12',NULL),(287,7908,77,40720,1527,3,222,1,390.64,NULL,'2022-11-07 12:56:12','2022-11-07 12:56:12',NULL),(288,7908,77,40720,1527,3,57,2,3001.00,NULL,'2022-11-07 12:56:12','2022-11-07 12:56:12',NULL),(289,7908,78,40720,1527,3,217,1,17430.19,NULL,'2022-11-07 13:05:53','2022-11-07 13:05:53',NULL);
INSERT INTO `balance_libro_details` VALUES (290,7908,78,40720,1527,3,68,1,3660.34,NULL,'2022-11-07 13:05:53','2022-11-07 13:05:53',NULL),(291,7908,78,40720,1527,3,57,2,21090.53,NULL,'2022-11-07 13:05:53','2022-11-07 13:05:53',NULL),(292,7908,79,40720,1527,3,217,1,33562.19,NULL,'2022-11-07 13:07:42','2022-11-07 13:07:42',NULL),(293,7908,79,40720,1527,3,68,1,7048.06,NULL,'2022-11-07 13:07:42','2022-11-07 13:07:42',NULL),(294,7908,79,40720,1527,3,57,2,40610.25,NULL,'2022-11-07 13:07:42','2022-11-07 13:07:42',NULL),(295,7908,80,40720,1527,3,217,1,2280.99,NULL,'2022-11-07 13:08:32','2022-11-07 13:08:32',NULL),(296,7908,80,40720,1527,3,68,1,479.01,NULL,'2022-11-07 13:08:32','2022-11-07 13:08:32',NULL),(297,7908,80,40720,1527,3,57,2,2760.00,NULL,'2022-11-07 13:08:32','2022-11-07 13:08:32',NULL),(298,7908,81,40720,1527,3,217,1,661.39,NULL,'2022-11-07 13:09:41','2022-11-07 13:09:41',NULL),(299,7908,81,40720,1527,3,68,1,138.89,NULL,'2022-11-07 13:09:41','2022-11-07 13:09:41',NULL),(300,7908,81,40720,1527,3,57,2,800.28,NULL,'2022-11-07 13:09:41','2022-11-07 13:09:41',NULL),(301,7908,82,40720,1527,3,217,1,8415.52,NULL,'2022-11-07 14:35:05','2022-11-07 14:35:05',NULL),(302,7908,82,40720,1527,3,68,1,1767.26,NULL,'2022-11-07 14:35:05','2022-11-07 14:35:05',NULL),(303,7908,82,40720,1527,3,57,2,10182.78,NULL,'2022-11-07 14:35:05','2022-11-07 14:35:05',NULL),(304,7908,83,40720,1527,3,217,1,3935.03,NULL,'2022-11-07 14:36:12','2022-11-07 14:36:12',NULL),(305,7908,83,40720,1527,3,68,1,826.36,NULL,'2022-11-07 14:36:12','2022-11-07 14:36:12',NULL),(306,7908,83,40720,1527,3,57,2,4761.39,NULL,'2022-11-07 14:36:12','2022-11-07 14:36:12',NULL),(307,7908,84,40720,1527,3,217,1,2099.41,NULL,'2022-11-07 14:39:00','2022-11-07 14:39:00',NULL),(308,7908,84,40720,1527,3,68,1,440.88,NULL,'2022-11-07 14:39:00','2022-11-07 14:39:00',NULL),(309,7908,84,40720,1527,3,57,2,2540.29,NULL,'2022-11-07 14:39:00','2022-11-07 14:39:00',NULL),(310,7908,85,40720,1527,3,217,1,7593.48,NULL,'2022-11-07 14:41:47','2022-11-07 14:41:47',NULL),(311,7908,85,40720,1527,3,68,1,1594.63,NULL,'2022-11-07 14:41:47','2022-11-07 14:41:47',NULL),(312,7908,85,40720,1527,3,57,2,9188.11,NULL,'2022-11-07 14:41:47','2022-11-07 14:41:47',NULL),(313,7908,86,40720,1527,3,217,1,2571.90,NULL,'2022-11-07 14:48:52','2022-11-07 14:48:52',NULL),(314,7908,86,40720,1527,3,68,1,540.10,NULL,'2022-11-07 14:48:52','2022-11-07 14:48:52',NULL),(315,7908,86,40720,1527,3,249,1,38.57,NULL,'2022-11-07 14:48:52','2022-11-07 14:48:52',NULL),(316,7908,86,40720,1527,3,57,2,3150.57,NULL,'2022-11-07 14:48:52','2022-11-07 14:48:52',NULL),(317,7908,87,40720,1527,3,217,1,24598.01,NULL,'2022-11-07 17:31:34','2022-11-07 17:31:34',NULL),(318,7908,87,40720,1527,3,68,1,5165.58,NULL,'2022-11-07 17:31:34','2022-11-07 17:31:34',NULL),(319,7908,87,40720,1527,3,249,1,184.49,NULL,'2022-11-07 17:31:34','2022-11-07 17:31:34',NULL),(320,7908,87,40720,1527,3,57,2,29948.08,NULL,'2022-11-07 17:31:34','2022-11-07 17:31:34',NULL),(321,7908,88,40720,1527,3,217,1,25861.01,NULL,'2022-11-07 17:32:44','2022-11-07 17:32:44',NULL),(322,7908,88,40720,1527,3,68,1,5430.81,NULL,'2022-11-07 17:32:44','2022-11-07 17:32:44',NULL),(323,7908,88,40720,1527,3,249,1,193.96,NULL,'2022-11-07 17:32:44','2022-11-07 17:32:44',NULL),(324,7908,88,40720,1527,3,57,2,31485.78,NULL,'2022-11-07 17:32:44','2022-11-07 17:32:44',NULL),(325,7908,89,40720,1527,15,68,2,62594.30,NULL,'2022-11-18 12:45:12','2022-11-18 12:45:12',NULL),(326,7908,89,40720,1527,15,353,1,62594.30,NULL,'2022-11-18 12:45:12','2022-11-18 12:45:12',NULL),(327,7908,90,40720,1528,3,217,1,1129145.60,NULL,'2022-11-18 15:36:32','2022-11-18 15:36:32',NULL),(328,7908,90,40720,1528,3,68,1,237120.58,NULL,'2022-11-18 15:36:32','2022-11-18 15:36:32',NULL),(329,7908,90,40720,1528,3,249,1,8468.59,NULL,'2022-11-18 15:36:32','2022-11-18 15:36:32',NULL),(330,7908,90,40720,1528,3,57,2,1374734.77,NULL,'2022-11-18 15:36:32','2022-11-18 15:36:32',NULL),(331,7908,91,40720,1528,3,217,1,503022.65,NULL,'2022-11-24 18:40:31','2022-11-24 18:40:31',NULL);
INSERT INTO `balance_libro_details` VALUES (332,7908,91,40720,1528,3,68,1,105634.76,NULL,'2022-11-24 18:40:31','2022-11-24 18:40:31',NULL),(333,7908,91,40720,1528,3,221,1,45872.60,NULL,'2022-11-24 18:40:31','2022-11-24 18:40:31',NULL),(334,7908,91,40720,1528,3,57,2,654530.01,NULL,'2022-11-24 18:40:31','2022-11-24 18:40:31',NULL),(335,7908,92,40720,1528,2,96,2,2727275.00,NULL,'2022-11-24 18:57:13','2022-11-24 18:57:13',NULL),(336,7908,92,40720,1528,2,67,2,572727.75,NULL,'2022-11-24 18:57:13','2022-11-24 18:57:13',NULL),(337,7908,92,40720,1528,2,13,1,3300002.75,NULL,'2022-11-24 18:57:13','2022-11-24 18:57:13',NULL),(338,7908,93,40720,1528,3,217,1,475500.00,NULL,'2022-11-29 20:05:47','2022-11-29 20:05:47',NULL),(339,7908,93,40720,1528,3,68,1,99855.00,NULL,'2022-11-29 20:05:47','2022-11-29 20:05:47',NULL),(340,7908,93,40720,1528,3,57,2,575355.00,NULL,'2022-11-29 20:05:47','2022-11-29 20:05:47',NULL),(341,7908,94,40720,1528,3,217,1,4504.13,NULL,'2022-11-29 20:17:23','2022-11-29 20:17:23',NULL),(342,7908,94,40720,1528,3,68,1,945.87,NULL,'2022-11-29 20:17:23','2022-11-29 20:17:23',NULL),(343,7908,94,40720,1528,3,57,2,5450.00,NULL,'2022-11-29 20:17:23','2022-11-29 20:17:23',NULL),(344,7908,95,40720,1528,3,217,1,98842.98,NULL,'2022-11-29 20:20:40','2022-11-29 20:20:40',NULL),(345,7908,95,40720,1528,3,68,1,20757.03,NULL,'2022-11-29 20:20:40','2022-11-29 20:20:40',NULL),(346,7908,95,40720,1528,3,57,2,119600.01,NULL,'2022-11-29 20:20:40','2022-11-29 20:20:40',NULL),(347,7908,96,40720,1528,3,217,1,2676.93,NULL,'2022-12-19 19:19:03','2022-12-19 19:19:03',NULL),(348,7908,96,40720,1528,3,68,1,562.16,NULL,'2022-12-19 19:19:03','2022-12-19 19:19:03',NULL),(349,7908,96,40720,1528,3,222,1,260.92,NULL,'2022-12-19 19:19:03','2022-12-19 19:19:03',NULL),(350,7908,96,40720,1528,3,57,2,3500.01,NULL,'2022-12-19 19:19:03','2022-12-19 19:19:03',NULL),(351,7908,97,40720,1528,3,217,1,1529.65,NULL,'2022-12-19 19:21:05','2022-12-19 19:21:05',NULL),(352,7908,97,40720,1528,3,68,1,321.23,NULL,'2022-12-19 19:21:05','2022-12-19 19:21:05',NULL),(353,7908,97,40720,1528,3,222,1,149.10,NULL,'2022-12-19 19:21:05','2022-12-19 19:21:05',NULL),(354,7908,97,40720,1528,3,57,2,1999.98,NULL,'2022-12-19 19:21:05','2022-12-19 19:21:05',NULL),(355,7908,98,40720,1528,3,217,1,4589.11,NULL,'2022-12-19 19:22:54','2022-12-19 19:22:54',NULL),(356,7908,98,40720,1528,3,68,1,963.71,NULL,'2022-12-19 19:22:54','2022-12-19 19:22:54',NULL),(357,7908,98,40720,1528,3,222,1,447.30,NULL,'2022-12-19 19:22:54','2022-12-19 19:22:54',NULL),(358,7908,98,40720,1528,3,57,2,6000.12,NULL,'2022-12-19 19:22:54','2022-12-19 19:22:54',NULL),(359,7908,99,40720,1528,3,217,1,1529.65,NULL,'2022-12-20 12:24:47','2022-12-20 12:24:47',NULL),(360,7908,99,40720,1528,3,68,1,321.23,NULL,'2022-12-20 12:24:47','2022-12-20 12:24:47',NULL),(361,7908,99,40720,1528,3,222,1,149.10,NULL,'2022-12-20 12:24:47','2022-12-20 12:24:47',NULL),(362,7908,99,40720,1528,3,57,2,1999.98,NULL,'2022-12-20 12:24:47','2022-12-20 12:24:47',NULL),(363,7908,100,40720,1528,3,217,1,5353.87,NULL,'2022-12-20 12:26:53','2022-12-20 12:26:53',NULL),(364,7908,100,40720,1528,3,68,1,1124.31,NULL,'2022-12-20 12:26:53','2022-12-20 12:26:53',NULL),(365,7908,100,40720,1528,3,222,1,521.84,NULL,'2022-12-20 12:26:53','2022-12-20 12:26:53',NULL),(366,7908,100,40720,1528,3,57,2,7000.02,NULL,'2022-12-20 12:26:53','2022-12-20 12:26:53',NULL),(367,7908,101,40720,1528,3,217,1,2525.24,NULL,'2022-12-20 12:28:32','2022-12-20 12:28:32',NULL),(368,7908,101,40720,1528,3,68,1,530.30,NULL,'2022-12-20 12:28:32','2022-12-20 12:28:32',NULL),(369,7908,101,40720,1528,3,222,1,246.13,NULL,'2022-12-20 12:28:32','2022-12-20 12:28:32',NULL),(370,7908,101,40720,1528,3,57,2,3301.67,NULL,'2022-12-20 12:28:32','2022-12-20 12:28:32',NULL),(371,7908,102,40720,1528,3,217,1,3507.96,NULL,'2022-12-20 12:30:29','2022-12-20 12:30:29',NULL),(372,7908,102,40720,1528,3,68,1,736.67,NULL,'2022-12-20 12:30:29','2022-12-20 12:30:29',NULL),(373,7908,102,40720,1528,3,222,1,756.06,NULL,'2022-12-20 12:30:29','2022-12-20 12:30:29',NULL);
INSERT INTO `balance_libro_details` VALUES (374,7908,102,40720,1528,3,57,2,5000.69,NULL,'2022-12-20 12:30:29','2022-12-20 12:30:29',NULL),(375,7908,103,40720,1528,3,217,1,35454.56,NULL,'2022-12-20 12:33:05','2022-12-20 12:33:05',NULL),(376,7908,103,40720,1528,3,68,1,7445.46,NULL,'2022-12-20 12:33:05','2022-12-20 12:33:05',NULL),(377,7908,103,40720,1528,3,57,2,42900.02,NULL,'2022-12-20 12:33:05','2022-12-20 12:33:05',NULL),(378,7908,104,40720,1528,3,217,1,5050.49,NULL,'2022-12-20 12:35:17','2022-12-20 12:35:17',NULL),(379,7908,104,40720,1528,3,68,1,1060.60,NULL,'2022-12-20 12:35:17','2022-12-20 12:35:17',NULL),(380,7908,104,40720,1528,3,222,1,1088.51,NULL,'2022-12-20 12:35:17','2022-12-20 12:35:17',NULL),(381,7908,104,40720,1528,3,57,2,7199.60,NULL,'2022-12-20 12:35:17','2022-12-20 12:35:17',NULL),(382,7908,105,40720,1528,3,217,1,3087.79,NULL,'2022-12-20 12:36:13','2022-12-20 12:36:13',NULL),(383,7908,105,40720,1528,3,68,1,648.44,NULL,'2022-12-20 12:36:13','2022-12-20 12:36:13',NULL),(384,7908,105,40720,1528,3,222,1,264.58,NULL,'2022-12-20 12:36:13','2022-12-20 12:36:13',NULL),(385,7908,105,40720,1528,3,57,2,4000.81,NULL,'2022-12-20 12:36:13','2022-12-20 12:36:13',NULL),(386,7908,106,40720,1528,3,217,1,2805.70,NULL,'2022-12-20 12:38:35','2022-12-20 12:38:35',NULL),(387,7908,106,40720,1528,3,68,1,589.20,NULL,'2022-12-20 12:38:35','2022-12-20 12:38:35',NULL),(388,7908,106,40720,1528,3,222,1,604.70,NULL,'2022-12-20 12:38:35','2022-12-20 12:38:35',NULL),(389,7908,106,40720,1528,3,57,2,3999.60,NULL,'2022-12-20 12:38:35','2022-12-20 12:38:35',NULL),(390,7908,107,40720,1528,3,217,1,6163.12,NULL,'2022-12-20 12:40:00','2022-12-20 12:40:00',NULL),(391,7908,107,40720,1528,3,68,1,1294.26,NULL,'2022-12-20 12:40:00','2022-12-20 12:40:00',NULL),(392,7908,107,40720,1528,3,222,1,543.83,NULL,'2022-12-20 12:40:00','2022-12-20 12:40:00',NULL),(393,7908,107,40720,1528,3,57,2,8001.21,NULL,'2022-12-20 12:40:00','2022-12-20 12:40:00',NULL),(394,7908,108,40720,1528,3,217,1,2312.43,NULL,'2022-12-20 12:41:41','2022-12-20 12:41:41',NULL),(395,7908,108,40720,1528,3,68,1,485.61,NULL,'2022-12-20 12:41:41','2022-12-20 12:41:41',NULL),(396,7908,108,40720,1528,3,222,1,204.05,NULL,'2022-12-20 12:41:41','2022-12-20 12:41:41',NULL),(397,7908,108,40720,1528,3,57,2,3002.09,NULL,'2022-12-20 12:41:41','2022-12-20 12:41:41',NULL),(398,7908,109,40720,1528,3,217,1,2311.74,NULL,'2022-12-20 12:43:30','2022-12-20 12:43:30',NULL),(399,7908,109,40720,1528,3,68,1,485.47,NULL,'2022-12-20 12:43:30','2022-12-20 12:43:30',NULL),(400,7908,109,40720,1528,3,222,1,203.99,NULL,'2022-12-20 12:43:30','2022-12-20 12:43:30',NULL),(401,7908,109,40720,1528,3,57,2,3001.20,NULL,'2022-12-20 12:43:30','2022-12-20 12:43:30',NULL),(402,7908,110,40720,1528,3,217,1,3620.60,NULL,'2022-12-20 12:45:24','2022-12-20 12:45:24',NULL),(403,7908,110,40720,1528,3,68,1,760.33,NULL,'2022-12-20 12:45:24','2022-12-20 12:45:24',NULL),(404,7908,110,40720,1528,3,222,1,619.78,NULL,'2022-12-20 12:45:24','2022-12-20 12:45:24',NULL),(405,7908,110,40720,1528,3,57,2,5000.71,NULL,'2022-12-20 12:45:24','2022-12-20 12:45:24',NULL),(406,7908,111,40720,1528,3,217,1,2944.94,NULL,'2022-12-20 12:47:14','2022-12-20 12:47:14',NULL),(407,7908,111,40720,1528,3,68,1,618.44,NULL,'2022-12-20 12:47:14','2022-12-20 12:47:14',NULL),(408,7908,111,40720,1528,3,222,1,438.63,NULL,'2022-12-20 12:47:14','2022-12-20 12:47:14',NULL),(409,7908,111,40720,1528,3,57,2,4002.01,NULL,'2022-12-20 12:47:14','2022-12-20 12:47:14',NULL),(410,7908,112,40720,1528,3,217,1,2696.73,NULL,'2022-12-20 12:48:59','2022-12-20 12:48:59',NULL),(411,7908,112,40720,1528,3,68,1,566.31,NULL,'2022-12-20 12:48:59','2022-12-20 12:48:59',NULL),(412,7908,112,40720,1528,3,222,1,237.96,NULL,'2022-12-20 12:48:59','2022-12-20 12:48:59',NULL),(413,7908,112,40720,1528,3,57,2,3501.00,NULL,'2022-12-20 12:48:59','2022-12-20 12:48:59',NULL),(414,7908,113,40720,1528,3,217,1,2104.35,NULL,'2022-12-20 12:50:02','2022-12-20 12:50:02',NULL),(415,7908,113,40720,1528,3,68,1,441.91,NULL,'2022-12-20 12:50:02','2022-12-20 12:50:02',NULL);
INSERT INTO `balance_libro_details` VALUES (416,7908,113,40720,1528,3,222,1,453.54,NULL,'2022-12-20 12:50:02','2022-12-20 12:50:02',NULL),(417,7908,113,40720,1528,3,57,2,2999.80,NULL,'2022-12-20 12:50:02','2022-12-20 12:50:02',NULL),(418,7908,114,40720,1528,3,217,1,2312.83,NULL,'2022-12-20 12:51:36','2022-12-20 12:51:36',NULL),(419,7908,114,40720,1528,3,68,1,485.69,NULL,'2022-12-20 12:51:36','2022-12-20 12:51:36',NULL),(420,7908,114,40720,1528,3,222,1,204.08,NULL,'2022-12-20 12:51:36','2022-12-20 12:51:36',NULL),(421,7908,114,40720,1528,3,57,2,3002.60,NULL,'2022-12-20 12:51:36','2022-12-20 12:51:36',NULL),(422,7908,115,40720,1528,3,217,1,3852.88,NULL,'2022-12-20 12:56:25','2022-12-20 12:56:25',NULL),(423,7908,115,40720,1528,3,68,1,809.10,NULL,'2022-12-20 12:56:25','2022-12-20 12:56:25',NULL),(424,7908,115,40720,1528,3,222,1,339.23,NULL,'2022-12-20 12:56:25','2022-12-20 12:56:25',NULL),(425,7908,115,40720,1528,3,57,2,5001.21,NULL,'2022-12-20 12:56:25','2022-12-20 12:56:25',NULL),(426,7908,116,40720,1528,2,96,2,3087.24,NULL,'2022-12-20 16:56:24','2022-12-20 17:35:07','2022-12-20 17:35:07'),(427,7908,116,40720,1528,2,67,2,648.32,NULL,'2022-12-20 16:56:24','2022-12-20 17:35:07','2022-12-20 17:35:07'),(428,7908,116,40720,1528,2,222,2,264.53,NULL,'2022-12-20 16:56:24','2022-12-20 17:35:07','2022-12-20 17:35:07'),(429,7908,116,40720,1528,2,13,1,4000.09,NULL,'2022-12-20 16:56:24','2022-12-20 17:35:07','2022-12-20 17:35:07'),(430,7908,117,40720,1528,2,96,2,2343.46,NULL,'2022-12-20 16:59:10','2022-12-20 17:34:48','2022-12-20 17:34:48'),(431,7908,117,40720,1528,2,67,2,492.13,NULL,'2022-12-20 16:59:10','2022-12-20 17:34:48','2022-12-20 17:34:48'),(432,7908,117,40720,1528,2,222,2,170.48,NULL,'2022-12-20 16:59:10','2022-12-20 17:34:48','2022-12-20 17:34:48'),(433,7908,117,40720,1528,2,13,1,3006.07,NULL,'2022-12-20 16:59:10','2022-12-20 17:34:48','2022-12-20 17:34:48'),(434,7908,118,40720,1528,2,96,2,2368.03,NULL,'2022-12-20 17:00:40','2022-12-20 17:34:29','2022-12-20 17:34:29'),(435,7908,118,40720,1528,2,67,2,497.29,NULL,'2022-12-20 17:00:40','2022-12-20 17:34:29','2022-12-20 17:34:29'),(436,7908,118,40720,1528,2,222,2,138.04,NULL,'2022-12-20 17:00:40','2022-12-20 17:34:29','2022-12-20 17:34:29'),(437,7908,118,40720,1528,2,13,1,3003.36,NULL,'2022-12-20 17:00:40','2022-12-20 17:34:29','2022-12-20 17:34:29'),(438,7908,119,40720,1528,2,96,2,2822.21,NULL,'2022-12-20 17:03:13','2022-12-20 17:34:14','2022-12-20 17:34:14'),(439,7908,119,40720,1528,2,67,2,592.66,NULL,'2022-12-20 17:03:13','2022-12-20 17:34:14','2022-12-20 17:34:14'),(440,7908,119,40720,1528,2,222,2,585.14,NULL,'2022-12-20 17:03:13','2022-12-20 17:34:14','2022-12-20 17:34:14'),(441,7908,119,40720,1528,2,13,1,4000.01,NULL,'2022-12-20 17:03:13','2022-12-20 17:34:14','2022-12-20 17:34:14'),(442,7908,120,40720,1528,2,96,2,5747.12,NULL,'2022-12-20 17:06:19','2022-12-20 17:33:37','2022-12-20 17:33:37'),(443,7908,120,40720,1528,2,67,2,1206.90,NULL,'2022-12-20 17:06:19','2022-12-20 17:33:37','2022-12-20 17:33:37'),(444,7908,120,40720,1528,2,222,2,1146.20,NULL,'2022-12-20 17:06:19','2022-12-20 17:33:37','2022-12-20 17:33:37'),(445,7908,120,40720,1528,2,13,1,8100.22,NULL,'2022-12-20 17:06:19','2022-12-20 17:33:37','2022-12-20 17:33:37'),(446,7908,121,40720,1528,2,96,2,1552.62,NULL,'2022-12-20 17:07:58','2022-12-20 17:33:25','2022-12-20 17:33:25'),(447,7908,121,40720,1528,2,67,2,326.05,NULL,'2022-12-20 17:07:58','2022-12-20 17:33:25','2022-12-20 17:33:25'),(448,7908,121,40720,1528,2,222,2,121.40,NULL,'2022-12-20 17:07:58','2022-12-20 17:33:25','2022-12-20 17:33:25'),(449,7908,121,40720,1528,2,13,1,2000.07,NULL,'2022-12-20 17:07:58','2022-12-20 17:33:25','2022-12-20 17:33:25'),(450,7908,122,40720,1528,2,96,2,5323.22,NULL,'2022-12-20 17:12:23','2022-12-20 17:32:41','2022-12-20 17:32:41'),(451,7908,122,40720,1528,2,67,2,1117.88,NULL,'2022-12-20 17:12:23','2022-12-20 17:32:41','2022-12-20 17:32:41'),(452,7908,122,40720,1528,2,13,1,6441.10,NULL,'2022-12-20 17:12:23','2022-12-20 17:32:41','2022-12-20 17:32:41');
INSERT INTO `balance_libro_details` VALUES (453,7908,123,40720,1528,2,96,2,4347.11,NULL,'2022-12-20 17:13:40','2022-12-20 17:32:32','2022-12-20 17:32:32'),(454,7908,123,40720,1528,2,67,2,912.89,NULL,'2022-12-20 17:13:40','2022-12-20 17:32:32','2022-12-20 17:32:32'),(455,7908,123,40720,1528,2,13,1,5260.00,NULL,'2022-12-20 17:13:40','2022-12-20 17:32:32','2022-12-20 17:32:32'),(456,7908,124,40720,1528,2,96,2,4347.11,NULL,'2022-12-20 17:14:43','2022-12-20 17:31:38','2022-12-20 17:31:38'),(457,7908,124,40720,1528,2,67,2,912.89,NULL,'2022-12-20 17:14:43','2022-12-20 17:31:38','2022-12-20 17:31:38'),(458,7908,124,40720,1528,2,13,1,5260.00,NULL,'2022-12-20 17:14:43','2022-12-20 17:31:38','2022-12-20 17:31:38'),(459,7908,125,40720,1528,2,96,2,3933.88,NULL,'2022-12-20 17:15:35','2022-12-20 17:31:27','2022-12-20 17:31:27'),(460,7908,125,40720,1528,2,67,2,826.11,NULL,'2022-12-20 17:15:35','2022-12-20 17:31:27','2022-12-20 17:31:27'),(461,7908,125,40720,1528,2,13,1,4759.99,NULL,'2022-12-20 17:15:35','2022-12-20 17:31:27','2022-12-20 17:31:27'),(462,7908,126,40720,1528,2,96,2,15314.36,NULL,'2022-12-20 17:16:45','2022-12-20 17:31:15','2022-12-20 17:31:15'),(463,7908,126,40720,1528,2,67,2,3216.02,NULL,'2022-12-20 17:16:45','2022-12-20 17:31:15','2022-12-20 17:31:15'),(464,7908,126,40720,1528,2,13,1,18530.38,NULL,'2022-12-20 17:16:45','2022-12-20 17:31:15','2022-12-20 17:31:15'),(465,7908,127,40720,1528,2,96,2,9207.17,NULL,'2022-12-20 17:17:31','2022-12-20 17:31:05','2022-12-20 17:31:05'),(466,7908,127,40720,1528,2,67,2,1933.51,NULL,'2022-12-20 17:17:31','2022-12-20 17:31:05','2022-12-20 17:31:05'),(467,7908,127,40720,1528,2,13,1,11140.68,NULL,'2022-12-20 17:17:31','2022-12-20 17:31:05','2022-12-20 17:31:05'),(468,7908,128,40720,1528,2,96,2,7438.02,NULL,'2022-12-20 17:19:00','2022-12-20 17:30:49','2022-12-20 17:30:49'),(469,7908,128,40720,1528,2,67,2,1561.98,NULL,'2022-12-20 17:19:00','2022-12-20 17:30:49','2022-12-20 17:30:49'),(470,7908,128,40720,1528,2,13,1,9000.00,NULL,'2022-12-20 17:19:00','2022-12-20 17:30:49','2022-12-20 17:30:49'),(471,7908,129,40720,1528,2,96,2,7516.53,NULL,'2022-12-20 17:21:46','2022-12-20 17:30:33','2022-12-20 17:30:33'),(472,7908,129,40720,1528,2,67,2,1578.47,NULL,'2022-12-20 17:21:46','2022-12-20 17:30:33','2022-12-20 17:30:33'),(473,7908,129,40720,1528,2,13,1,9095.00,NULL,'2022-12-20 17:21:46','2022-12-20 17:30:33','2022-12-20 17:30:33'),(474,7908,130,40720,1528,3,217,1,3087.24,NULL,'2022-12-20 17:38:56','2022-12-20 17:38:56',NULL),(475,7908,130,40720,1528,3,68,1,648.32,NULL,'2022-12-20 17:38:56','2022-12-20 17:38:56',NULL),(476,7908,130,40720,1528,3,222,1,264.53,NULL,'2022-12-20 17:38:56','2022-12-20 17:38:56',NULL),(477,7908,130,40720,1528,3,57,2,4000.09,NULL,'2022-12-20 17:38:56','2022-12-20 17:38:56',NULL),(478,7908,131,40720,1528,3,217,1,2343.46,NULL,'2022-12-20 17:41:16','2022-12-20 17:41:16',NULL),(479,7908,131,40720,1528,3,68,1,492.13,NULL,'2022-12-20 17:41:16','2022-12-20 17:41:16',NULL),(480,7908,131,40720,1528,3,222,1,170.48,NULL,'2022-12-20 17:41:16','2022-12-20 17:41:16',NULL),(481,7908,131,40720,1528,3,57,2,3006.07,NULL,'2022-12-20 17:41:16','2022-12-20 17:41:16',NULL),(482,7908,132,40720,1528,3,217,1,2368.03,NULL,'2022-12-20 17:42:26','2022-12-20 17:42:26',NULL),(483,7908,132,40720,1528,3,68,1,497.29,NULL,'2022-12-20 17:42:26','2022-12-20 17:42:26',NULL),(484,7908,132,40720,1528,3,222,1,138.04,NULL,'2022-12-20 17:42:26','2022-12-20 17:42:26',NULL),(485,7908,132,40720,1528,3,57,2,3003.36,NULL,'2022-12-20 17:42:26','2022-12-20 17:42:26',NULL),(486,7908,133,40720,1528,3,217,1,2822.21,NULL,'2022-12-20 17:43:58','2022-12-20 17:43:58',NULL),(487,7908,133,40720,1528,3,68,1,592.66,NULL,'2022-12-20 17:43:58','2022-12-20 17:43:58',NULL),(488,7908,133,40720,1528,3,222,1,585.14,NULL,'2022-12-20 17:43:58','2022-12-20 17:43:58',NULL),(489,7908,133,40720,1528,3,57,2,4000.01,NULL,'2022-12-20 17:43:58','2022-12-20 17:43:58',NULL),(490,7908,134,40720,1528,3,217,1,5747.11,NULL,'2022-12-20 17:46:07','2022-12-20 17:46:07',NULL);
INSERT INTO `balance_libro_details` VALUES (491,7908,134,40720,1528,3,68,1,1206.89,NULL,'2022-12-20 17:46:07','2022-12-20 17:46:07',NULL),(492,7908,134,40720,1528,3,222,1,1146.20,NULL,'2022-12-20 17:46:07','2022-12-20 17:46:07',NULL),(493,7908,134,40720,1528,3,57,2,8100.20,NULL,'2022-12-20 17:46:07','2022-12-20 17:46:07',NULL),(494,7908,135,40720,1528,3,217,1,1552.62,NULL,'2022-12-20 17:47:29','2022-12-20 17:47:29',NULL),(495,7908,135,40720,1528,3,68,1,326.05,NULL,'2022-12-20 17:47:29','2022-12-20 17:47:29',NULL),(496,7908,135,40720,1528,3,222,1,121.40,NULL,'2022-12-20 17:47:29','2022-12-20 17:47:29',NULL),(497,7908,135,40720,1528,3,57,2,2000.07,NULL,'2022-12-20 17:47:29','2022-12-20 17:47:29',NULL),(498,7908,136,40720,1528,3,217,1,5323.22,NULL,'2022-12-20 17:49:41','2022-12-20 17:49:41',NULL),(499,7908,136,40720,1528,3,68,1,1117.88,NULL,'2022-12-20 17:49:41','2022-12-20 17:49:41',NULL),(500,7908,136,40720,1528,3,57,2,6441.10,NULL,'2022-12-20 17:49:41','2022-12-20 17:49:41',NULL),(501,7908,137,40720,1528,3,217,1,7516.53,NULL,'2022-12-20 17:50:57','2022-12-20 17:50:57',NULL),(502,7908,137,40720,1528,3,68,1,1578.47,NULL,'2022-12-20 17:50:57','2022-12-20 17:50:57',NULL),(503,7908,137,40720,1528,3,57,2,9095.00,NULL,'2022-12-20 17:50:57','2022-12-20 17:50:57',NULL),(504,7908,138,40720,1528,3,217,1,7438.02,NULL,'2022-12-20 17:52:29','2022-12-20 17:52:29',NULL),(505,7908,138,40720,1528,3,68,1,1561.98,NULL,'2022-12-20 17:52:29','2022-12-20 17:52:29',NULL),(506,7908,138,40720,1528,3,57,2,9000.00,NULL,'2022-12-20 17:52:29','2022-12-20 17:52:29',NULL),(507,7908,139,40720,1528,3,217,1,9207.17,NULL,'2022-12-20 17:54:12','2022-12-20 17:54:12',NULL),(508,7908,139,40720,1528,3,68,1,1933.51,NULL,'2022-12-20 17:54:12','2022-12-20 17:54:12',NULL),(509,7908,139,40720,1528,3,57,2,11140.68,NULL,'2022-12-20 17:54:12','2022-12-20 17:54:12',NULL),(510,7908,140,40720,1528,3,217,1,15314.36,NULL,'2022-12-20 17:55:01','2022-12-20 17:55:01',NULL),(511,7908,140,40720,1528,3,68,1,3216.02,NULL,'2022-12-20 17:55:01','2022-12-20 17:55:01',NULL),(512,7908,140,40720,1528,3,57,2,18530.38,NULL,'2022-12-20 17:55:01','2022-12-20 17:55:01',NULL),(513,7908,141,40720,1528,3,217,1,3933.88,NULL,'2022-12-20 17:56:02','2022-12-20 17:56:02',NULL),(514,7908,141,40720,1528,3,68,1,826.11,NULL,'2022-12-20 17:56:02','2022-12-20 17:56:02',NULL),(515,7908,141,40720,1528,3,57,2,4759.99,NULL,'2022-12-20 17:56:02','2022-12-20 17:56:02',NULL),(516,7908,142,40720,1528,3,217,1,4347.11,NULL,'2022-12-20 17:57:08','2022-12-20 17:57:08',NULL),(517,7908,142,40720,1528,3,68,1,912.89,NULL,'2022-12-20 17:57:08','2022-12-20 17:57:08',NULL),(518,7908,142,40720,1528,3,57,2,5260.00,NULL,'2022-12-20 17:57:08','2022-12-20 17:57:08',NULL),(519,7908,143,40720,1528,3,217,1,4347.11,NULL,'2022-12-20 17:59:36','2022-12-20 17:59:36',NULL),(520,7908,143,40720,1528,3,68,1,912.89,NULL,'2022-12-20 17:59:36','2022-12-20 17:59:36',NULL),(521,7908,143,40720,1528,3,57,2,5260.00,NULL,'2022-12-20 17:59:36','2022-12-20 17:59:36',NULL),(522,7908,144,40720,1528,3,217,1,5611.48,NULL,'2022-12-21 12:39:48','2022-12-21 12:39:48',NULL),(523,7908,144,40720,1528,3,68,1,1178.41,NULL,'2022-12-21 12:39:48','2022-12-21 12:39:48',NULL),(524,7908,144,40720,1528,3,222,1,1209.42,NULL,'2022-12-21 12:39:48','2022-12-21 12:39:48',NULL),(525,7908,144,40720,1528,3,57,2,7999.31,NULL,'2022-12-21 12:39:48','2022-12-21 12:39:48',NULL),(526,7908,145,40720,1528,3,217,1,2294.55,NULL,'2022-12-21 12:41:50','2022-12-21 12:41:50',NULL),(527,7908,145,40720,1528,3,68,1,481.86,NULL,'2022-12-21 12:41:50','2022-12-21 12:41:50',NULL),(528,7908,145,40720,1528,3,222,1,223.65,NULL,'2022-12-21 12:41:50','2022-12-21 12:41:50',NULL),(529,7908,145,40720,1528,3,57,2,3000.06,NULL,'2022-12-21 12:41:50','2022-12-21 12:41:50',NULL),(530,7908,146,40720,1528,3,217,1,3154.88,NULL,'2022-12-21 12:43:39','2022-12-21 12:43:39',NULL),(531,7908,146,40720,1528,3,68,1,662.52,NULL,'2022-12-21 12:43:39','2022-12-21 12:43:39',NULL),(532,7908,146,40720,1528,3,222,1,183.91,NULL,'2022-12-21 12:43:39','2022-12-21 12:43:39',NULL);
INSERT INTO `balance_libro_details` VALUES (533,7908,146,40720,1528,3,57,2,4001.31,NULL,'2022-12-21 12:43:39','2022-12-21 12:43:39',NULL),(534,7908,147,40720,1528,3,217,1,42882.99,NULL,'2022-12-21 12:46:08','2022-12-21 12:47:10','2022-12-21 12:47:10'),(535,7908,147,40720,1528,3,68,1,9005.43,NULL,'2022-12-21 12:46:08','2022-12-21 12:47:10','2022-12-21 12:47:10'),(536,7908,147,40720,1528,3,222,1,5114.86,NULL,'2022-12-21 12:46:08','2022-12-21 12:47:10','2022-12-21 12:47:10'),(537,7908,147,40720,1528,3,57,2,57003.28,NULL,'2022-12-21 12:46:08','2022-12-21 12:47:10','2022-12-21 12:47:10'),(538,7908,148,40720,1528,3,217,1,42882.99,NULL,'2022-12-21 12:47:10','2022-12-21 12:47:10',NULL),(539,7908,148,40720,1528,3,68,1,9005.43,NULL,'2022-12-21 12:47:10','2022-12-21 12:47:10',NULL),(540,7908,148,40720,1528,3,222,1,5114.86,NULL,'2022-12-21 12:47:10','2022-12-21 12:47:10',NULL),(541,7908,148,40720,1528,3,57,2,57003.28,NULL,'2022-12-21 12:47:10','2022-12-21 12:47:10',NULL),(542,7908,149,40720,1528,3,217,1,3120.00,NULL,'2022-12-21 12:48:48','2022-12-21 12:48:48',NULL),(543,7908,149,40720,1528,3,68,1,655.20,NULL,'2022-12-21 12:48:48','2022-12-21 12:48:48',NULL),(544,7908,149,40720,1528,3,222,1,226.97,NULL,'2022-12-21 12:48:48','2022-12-21 12:48:48',NULL),(545,7908,149,40720,1528,3,57,2,4002.17,NULL,'2022-12-21 12:48:48','2022-12-21 12:48:48',NULL),(546,7908,150,40720,1528,3,217,1,6501.15,NULL,'2022-12-21 12:50:21','2022-12-21 12:50:21',NULL),(547,7908,150,40720,1528,3,68,1,1365.24,NULL,'2022-12-21 12:50:21','2022-12-21 12:50:21',NULL),(548,7908,150,40720,1528,3,222,1,633.67,NULL,'2022-12-21 12:50:21','2022-12-21 12:50:21',NULL),(549,7908,150,40720,1528,3,57,2,8500.06,NULL,'2022-12-21 12:50:21','2022-12-21 12:50:21',NULL),(550,7908,151,40720,1528,3,217,1,29737.80,NULL,'2022-12-21 14:41:37','2022-12-21 14:41:37',NULL),(551,7908,151,40720,1528,3,68,1,3122.47,NULL,'2022-12-21 14:41:37','2022-12-21 14:41:37',NULL),(552,7908,151,40720,1528,3,249,1,223.03,NULL,'2022-12-21 14:41:37','2022-12-21 14:41:37',NULL),(553,7908,151,40720,1528,3,57,2,33083.30,NULL,'2022-12-21 14:41:37','2022-12-21 14:41:37',NULL),(554,7908,152,40720,1528,3,217,1,33149.86,NULL,'2022-12-21 15:25:47','2022-12-21 15:25:47',NULL),(555,7908,152,40720,1528,3,68,1,6961.47,NULL,'2022-12-21 15:25:47','2022-12-21 15:25:47',NULL),(556,7908,152,40720,1528,3,249,1,248.62,NULL,'2022-12-21 15:25:47','2022-12-21 15:25:47',NULL),(557,7908,152,40720,1528,3,57,2,40359.95,NULL,'2022-12-21 15:25:47','2022-12-21 15:25:47',NULL),(558,7908,153,40720,1528,3,217,1,2529.92,NULL,'2022-12-21 15:28:05','2022-12-21 15:28:05',NULL),(559,7908,153,40720,1528,3,68,1,531.28,NULL,'2022-12-21 15:28:05','2022-12-21 15:28:05',NULL),(560,7908,153,40720,1528,3,57,2,3061.20,NULL,'2022-12-21 15:28:05','2022-12-21 15:28:05',NULL),(561,7908,154,40720,1528,15,67,1,572727.75,NULL,'2022-12-21 17:06:35','2022-12-21 17:25:21','2022-12-21 17:25:21'),(562,7908,154,40720,1528,15,68,2,524350.62,NULL,'2022-12-21 17:06:35','2022-12-21 17:25:21','2022-12-21 17:25:21'),(563,7908,154,40720,1528,15,353,2,62594.30,NULL,'2022-12-21 17:06:35','2022-12-21 17:25:21','2022-12-21 17:25:21'),(564,7908,154,40720,1528,15,353,1,14217.17,NULL,'2022-12-21 17:06:35','2022-12-21 17:25:21','2022-12-21 17:25:21'),(565,7908,155,40720,1528,15,67,1,572727.75,NULL,'2022-12-22 14:09:13','2022-12-22 14:09:13',NULL),(566,7908,155,40720,1528,15,68,2,524350.62,NULL,'2022-12-22 14:09:13','2022-12-22 14:09:13',NULL),(567,7908,155,40720,1528,15,353,2,62594.30,NULL,'2022-12-22 14:09:13','2022-12-22 14:09:13',NULL),(568,7908,155,40720,1528,15,353,1,14217.17,NULL,'2022-12-22 14:09:13','2022-12-22 14:09:13',NULL),(569,7908,156,40720,1529,3,217,1,975732.00,NULL,'2023-01-02 18:56:00','2023-01-02 18:56:00',NULL),(570,7908,156,40720,1529,3,68,1,102451.86,NULL,'2023-01-02 18:56:00','2023-01-02 18:56:00',NULL),(571,7908,156,40720,1529,3,249,1,7317.99,NULL,'2023-01-02 18:56:00','2023-01-02 18:56:00',NULL),(572,7908,156,40720,1529,3,57,2,1085501.85,NULL,'2023-01-02 18:56:00','2023-01-02 18:56:00',NULL);
INSERT INTO `balance_libro_details` VALUES (573,7908,157,40720,1529,3,217,1,1012600.51,NULL,'2023-01-02 19:00:41','2023-01-02 19:00:41',NULL),(574,7908,157,40720,1529,3,68,1,106323.05,NULL,'2023-01-02 19:00:41','2023-01-02 19:00:41',NULL),(575,7908,157,40720,1529,3,57,2,1118923.56,NULL,'2023-01-02 19:00:41','2023-01-02 19:00:41',NULL),(576,7908,158,40720,1529,3,217,1,893471.04,NULL,'2023-01-02 19:02:51','2023-01-02 19:02:51',NULL),(577,7908,158,40720,1529,3,68,1,93814.46,NULL,'2023-01-02 19:02:51','2023-01-02 19:02:51',NULL),(578,7908,158,40720,1529,3,57,2,987285.50,NULL,'2023-01-02 19:02:51','2023-01-02 19:02:51',NULL),(579,7908,159,40720,1529,3,217,1,355371.90,NULL,'2023-01-02 19:14:45','2023-01-02 19:14:45',NULL),(580,7908,159,40720,1529,3,68,1,74628.10,NULL,'2023-01-02 19:14:45','2023-01-02 19:14:45',NULL),(581,7908,159,40720,1529,3,249,1,2665.29,NULL,'2023-01-02 19:14:45','2023-01-02 19:14:45',NULL),(582,7908,159,40720,1529,3,57,2,432665.29,NULL,'2023-01-02 19:14:45','2023-01-02 19:14:45',NULL),(583,7908,160,40720,1529,3,217,1,25084.52,NULL,'2023-01-04 19:17:55','2023-01-16 19:28:30','2023-01-16 19:28:30'),(584,7908,160,40720,1529,3,68,1,5267.75,NULL,'2023-01-04 19:17:55','2023-01-16 19:28:30','2023-01-16 19:28:30'),(585,7908,160,40720,1529,3,217,1,1.11,NULL,'2023-01-04 19:17:55','2023-01-16 19:28:30','2023-01-16 19:28:30'),(586,7908,160,40720,1529,3,57,2,30540.40,NULL,'2023-01-04 19:17:55','2023-01-16 19:28:30','2023-01-16 19:28:30'),(587,7908,160,40720,1529,3,136,1,187.02,NULL,'2023-01-04 19:17:55','2023-01-16 19:28:30','2023-01-16 19:28:30'),(588,7908,161,40720,1529,3,217,1,78077.44,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:06','2023-01-16 19:50:06'),(589,7908,161,40720,1529,3,68,1,16396.26,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:06','2023-01-16 19:50:06'),(590,7908,161,40720,1529,3,217,1,3.36,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:06','2023-01-16 19:50:06'),(591,7908,161,40720,1529,3,57,2,95059.28,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:06','2023-01-16 19:50:06'),(592,7908,161,40720,1529,3,136,1,582.22,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:06','2023-01-16 19:50:06'),(593,7908,162,40720,1529,3,217,1,8191.16,NULL,'2023-01-04 19:17:55','2023-01-16 19:41:34','2023-01-16 19:41:34'),(594,7908,162,40720,1529,3,68,1,1720.14,NULL,'2023-01-04 19:17:55','2023-01-16 19:41:34','2023-01-16 19:41:34'),(595,7908,162,40720,1529,3,217,1,0.35,NULL,'2023-01-04 19:17:55','2023-01-16 19:41:34','2023-01-16 19:41:34'),(596,7908,162,40720,1529,3,57,2,9972.30,NULL,'2023-01-04 19:17:55','2023-01-16 19:41:34','2023-01-16 19:41:34'),(597,7908,162,40720,1529,3,136,1,60.65,NULL,'2023-01-04 19:17:55','2023-01-16 19:41:34','2023-01-16 19:41:34'),(598,7908,163,40720,1529,3,217,1,14813.80,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:37','2023-01-16 19:50:37'),(599,7908,163,40720,1529,3,68,1,3110.90,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:37','2023-01-16 19:50:37'),(600,7908,163,40720,1529,3,217,1,0.64,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:37','2023-01-16 19:50:37'),(601,7908,163,40720,1529,3,57,2,18036.24,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:37','2023-01-16 19:50:37'),(602,7908,163,40720,1529,3,136,1,110.90,NULL,'2023-01-04 19:17:55','2023-01-16 19:50:37','2023-01-16 19:50:37'),(603,7908,164,40720,1529,3,217,1,14813.80,NULL,'2023-01-04 19:17:56','2023-01-16 19:49:32','2023-01-16 19:49:32'),(604,7908,164,40720,1529,3,68,1,3110.90,NULL,'2023-01-04 19:17:56','2023-01-16 19:49:32','2023-01-16 19:49:32'),(605,7908,164,40720,1529,3,217,1,0.64,NULL,'2023-01-04 19:17:56','2023-01-16 19:49:32','2023-01-16 19:49:32'),(606,7908,164,40720,1529,3,57,2,18036.24,NULL,'2023-01-04 19:17:56','2023-01-16 19:49:32','2023-01-16 19:49:32'),(607,7908,164,40720,1529,3,136,1,110.90,NULL,'2023-01-04 19:17:56','2023-01-16 19:49:32','2023-01-16 19:49:32'),(608,7908,165,40720,1529,3,217,1,94400.52,NULL,'2023-01-04 19:17:56','2023-01-16 19:52:07','2023-01-16 19:52:07'),(609,7908,165,40720,1529,3,68,1,19824.11,NULL,'2023-01-04 19:17:56','2023-01-16 19:52:07','2023-01-16 19:52:07');
INSERT INTO `balance_libro_details` VALUES (610,7908,165,40720,1529,3,217,1,4.01,NULL,'2023-01-04 19:17:56','2023-01-16 19:52:07','2023-01-16 19:52:07'),(611,7908,165,40720,1529,3,57,2,114933.52,NULL,'2023-01-04 19:17:56','2023-01-16 19:52:07','2023-01-16 19:52:07'),(612,7908,165,40720,1529,3,136,1,704.88,NULL,'2023-01-04 19:17:56','2023-01-16 19:52:07','2023-01-16 19:52:07'),(613,7908,166,40720,1529,3,217,1,222318.53,NULL,'2023-01-04 19:17:56','2023-01-16 19:51:35','2023-01-16 19:51:35'),(614,7908,166,40720,1529,3,68,1,46687.60,NULL,'2023-01-04 19:17:56','2023-01-16 19:51:35','2023-01-16 19:51:35'),(615,7908,166,40720,1529,3,217,1,9.43,NULL,'2023-01-04 19:17:56','2023-01-16 19:51:35','2023-01-16 19:51:35'),(616,7908,166,40720,1529,3,57,2,270673.16,NULL,'2023-01-04 19:17:56','2023-01-16 19:51:35','2023-01-16 19:51:35'),(617,7908,166,40720,1529,3,136,1,1657.60,NULL,'2023-01-04 19:17:56','2023-01-16 19:51:35','2023-01-16 19:51:35'),(618,7908,167,40720,1529,3,217,1,176780.00,NULL,'2023-01-04 19:17:56','2023-01-16 19:42:51','2023-01-16 19:42:51'),(619,7908,167,40720,1529,3,68,1,37123.80,NULL,'2023-01-04 19:17:56','2023-01-16 19:42:51','2023-01-16 19:42:51'),(620,7908,167,40720,1529,3,217,1,7.50,NULL,'2023-01-04 19:17:56','2023-01-16 19:42:51','2023-01-16 19:42:51'),(621,7908,167,40720,1529,3,57,2,215229.65,NULL,'2023-01-04 19:17:56','2023-01-16 19:42:51','2023-01-16 19:42:51'),(622,7908,167,40720,1529,3,136,1,1318.35,NULL,'2023-01-04 19:17:56','2023-01-16 19:42:51','2023-01-16 19:42:51'),(623,7908,168,40720,1529,2,96,2,2380168.00,NULL,'2023-01-04 19:52:04','2023-01-04 19:52:04',NULL),(624,7908,168,40720,1529,2,67,2,499835.28,NULL,'2023-01-04 19:52:04','2023-01-04 19:52:04',NULL),(625,7908,168,40720,1529,2,13,1,2880003.28,NULL,'2023-01-04 19:52:04','2023-01-04 19:52:04',NULL),(626,7908,169,40720,1533,2,96,2,1884300.00,NULL,'2023-01-06 12:35:57','2023-01-06 12:35:57',NULL),(627,7908,169,40720,1533,2,67,2,395703.00,NULL,'2023-01-06 12:35:57','2023-01-06 12:35:57',NULL),(628,7908,169,40720,1533,2,13,1,2280003.00,NULL,'2023-01-06 12:35:57','2023-01-06 12:35:57',NULL),(629,7908,170,40720,1533,3,217,1,50734.71,NULL,'2023-01-10 18:48:02','2023-01-10 18:48:02',NULL),(630,7908,170,40720,1533,3,68,1,10654.29,NULL,'2023-01-10 18:48:02','2023-01-10 18:48:02',NULL),(631,7908,170,40720,1533,3,57,2,61389.00,NULL,'2023-01-10 18:48:02','2023-01-10 18:48:02',NULL),(632,7908,171,40720,1529,3,217,1,26067.60,NULL,'2023-01-11 20:32:41','2023-01-11 20:32:41',NULL),(633,7908,171,40720,1529,3,68,1,5474.20,NULL,'2023-01-11 20:32:41','2023-01-11 20:32:41',NULL),(634,7908,171,40720,1529,3,222,1,2981.52,NULL,'2023-01-11 20:32:41','2023-01-11 20:32:41',NULL),(635,7908,171,40720,1529,3,57,2,34523.32,NULL,'2023-01-11 20:32:41','2023-01-11 20:32:41',NULL),(636,7908,172,40720,1529,3,217,1,1564.30,NULL,'2023-01-11 20:34:38','2023-01-11 20:34:38',NULL),(637,7908,172,40720,1529,3,68,1,328.50,NULL,'2023-01-11 20:34:38','2023-01-11 20:34:38',NULL),(638,7908,172,40720,1529,3,222,1,109.16,NULL,'2023-01-11 20:34:38','2023-01-11 20:34:38',NULL),(639,7908,172,40720,1529,3,57,2,2001.96,NULL,'2023-01-11 20:34:38','2023-01-11 20:34:38',NULL),(640,7908,173,40720,1529,3,217,1,5512.26,NULL,'2023-01-11 20:36:58','2023-01-11 20:36:58',NULL),(641,7908,173,40720,1529,3,68,1,1157.57,NULL,'2023-01-11 20:36:58','2023-01-11 20:36:58',NULL),(642,7908,173,40720,1529,3,222,1,630.46,NULL,'2023-01-11 20:36:58','2023-01-11 20:36:58',NULL),(643,7908,173,40720,1529,3,57,2,7300.29,NULL,'2023-01-11 20:36:58','2023-01-11 20:36:58',NULL),(644,7908,174,40720,1529,3,217,1,2315.34,NULL,'2023-01-11 20:38:55','2023-01-11 20:38:55',NULL),(645,7908,174,40720,1529,3,68,1,486.22,NULL,'2023-01-11 20:38:55','2023-01-11 20:38:55',NULL),(646,7908,174,40720,1529,3,222,1,198.39,NULL,'2023-01-11 20:38:55','2023-01-11 20:38:55',NULL),(647,7908,174,40720,1529,3,57,2,2999.95,NULL,'2023-01-11 20:38:55','2023-01-11 20:38:55',NULL),(648,7908,175,40720,1529,3,217,1,17366.47,NULL,'2023-01-11 20:41:13','2023-01-11 20:41:13',NULL);
INSERT INTO `balance_libro_details` VALUES (649,7908,175,40720,1529,3,68,1,3646.96,NULL,'2023-01-11 20:41:13','2023-01-11 20:41:13',NULL),(650,7908,175,40720,1529,3,222,1,1986.27,NULL,'2023-01-11 20:41:13','2023-01-11 20:41:13',NULL),(651,7908,175,40720,1529,3,57,2,22999.70,NULL,'2023-01-11 20:41:13','2023-01-11 20:41:13',NULL),(652,7908,176,40720,1529,3,217,1,6044.38,NULL,'2023-01-11 20:43:08','2023-01-11 20:43:08',NULL),(653,7908,176,40720,1529,3,68,1,1269.32,NULL,'2023-01-11 20:43:08','2023-01-11 20:43:08',NULL),(654,7908,176,40720,1529,3,222,1,691.32,NULL,'2023-01-11 20:43:08','2023-01-11 20:43:08',NULL),(655,7908,176,40720,1529,3,57,2,8005.02,NULL,'2023-01-11 20:43:08','2023-01-11 20:43:08',NULL),(656,7908,177,40720,1529,3,217,1,8457.80,NULL,'2023-01-12 12:41:07','2023-01-12 12:41:07',NULL),(657,7908,177,40720,1529,3,68,1,1776.14,NULL,'2023-01-12 12:41:07','2023-01-12 12:41:07',NULL),(658,7908,177,40720,1529,3,222,1,967.35,NULL,'2023-01-12 12:41:07','2023-01-12 12:41:07',NULL),(659,7908,177,40720,1529,3,57,2,11201.29,NULL,'2023-01-12 12:41:07','2023-01-12 12:41:07',NULL),(660,7908,178,40720,1529,3,217,1,3285.71,NULL,'2023-01-12 12:42:11','2023-01-12 12:42:11',NULL),(661,7908,178,40720,1529,3,68,1,690.00,NULL,'2023-01-12 12:42:11','2023-01-12 12:42:11',NULL),(662,7908,178,40720,1529,3,222,1,524.08,NULL,'2023-01-12 12:42:11','2023-01-12 12:42:11',NULL),(663,7908,178,40720,1529,3,57,2,4499.79,NULL,'2023-01-12 12:42:11','2023-01-12 12:42:11',NULL),(664,7908,179,40720,1529,3,217,1,2192.69,NULL,'2023-01-12 12:43:08','2023-01-12 12:43:08',NULL),(665,7908,179,40720,1529,3,68,1,460.46,NULL,'2023-01-12 12:43:08','2023-01-12 12:43:08',NULL),(666,7908,179,40720,1529,3,222,1,349.74,NULL,'2023-01-12 12:43:08','2023-01-12 12:43:08',NULL),(667,7908,179,40720,1529,3,57,2,3002.89,NULL,'2023-01-12 12:43:08','2023-01-12 12:43:08',NULL),(668,7908,180,40720,1529,3,217,1,14699.95,NULL,'2023-01-12 12:45:58','2023-01-12 12:45:58',NULL),(669,7908,180,40720,1529,3,68,1,3086.99,NULL,'2023-01-12 12:45:58','2023-01-12 12:45:58',NULL),(670,7908,180,40720,1529,3,222,1,1213.76,NULL,'2023-01-12 12:45:58','2023-01-12 12:45:58',NULL),(671,7908,180,40720,1529,3,57,2,19000.70,NULL,'2023-01-12 12:45:58','2023-01-12 12:45:58',NULL),(672,7908,181,40720,1529,3,217,1,3096.60,NULL,'2023-01-12 12:48:08','2023-01-12 12:48:08',NULL),(673,7908,181,40720,1529,3,68,1,650.29,NULL,'2023-01-12 12:48:08','2023-01-12 12:48:08',NULL),(674,7908,181,40720,1529,3,222,1,255.68,NULL,'2023-01-12 12:48:08','2023-01-12 12:48:08',NULL),(675,7908,181,40720,1529,3,57,2,4002.57,NULL,'2023-01-12 12:48:08','2023-01-12 12:48:08',NULL),(676,7908,182,40720,1529,3,217,1,3862.10,NULL,'2023-01-12 12:49:21','2023-01-12 12:49:21',NULL),(677,7908,182,40720,1529,3,68,1,811.04,NULL,'2023-01-12 12:49:21','2023-01-12 12:49:21',NULL),(678,7908,182,40720,1529,3,222,1,326.14,NULL,'2023-01-12 12:49:21','2023-01-12 12:49:21',NULL),(679,7908,182,40720,1529,3,57,2,4999.28,NULL,'2023-01-12 12:49:21','2023-01-12 12:49:21',NULL),(680,7908,183,40720,1529,3,217,1,1917.95,NULL,'2023-01-12 12:53:06','2023-01-12 12:53:06',NULL),(681,7908,183,40720,1529,3,68,1,402.77,NULL,'2023-01-12 12:53:06','2023-01-12 12:53:06',NULL),(682,7908,183,40720,1529,3,222,1,179.37,NULL,'2023-01-12 12:53:06','2023-01-12 12:53:06',NULL),(683,7908,183,40720,1529,3,57,2,2500.09,NULL,'2023-01-12 12:53:06','2023-01-12 12:53:06',NULL),(684,7908,184,40720,1529,3,217,1,2321.82,NULL,'2023-01-12 12:54:30','2023-01-12 12:54:30',NULL),(685,7908,184,40720,1529,3,68,1,487.58,NULL,'2023-01-12 12:54:30','2023-01-12 12:54:30',NULL),(686,7908,184,40720,1529,3,222,1,191.71,NULL,'2023-01-12 12:54:30','2023-01-12 12:54:30',NULL),(687,7908,184,40720,1529,3,57,2,3001.11,NULL,'2023-01-12 12:54:30','2023-01-12 12:54:30',NULL),(688,7908,185,40720,1529,3,217,1,17367.15,NULL,'2023-01-12 12:55:45','2023-01-12 12:55:45',NULL),(689,7908,185,40720,1529,3,68,1,3647.10,NULL,'2023-01-12 12:55:45','2023-01-12 12:55:45',NULL),(690,7908,185,40720,1529,3,222,1,1986.35,NULL,'2023-01-12 12:55:45','2023-01-12 12:55:45',NULL);
INSERT INTO `balance_libro_details` VALUES (691,7908,185,40720,1529,3,57,2,23000.60,NULL,'2023-01-12 12:55:45','2023-01-12 12:55:45',NULL),(692,7908,186,40720,1529,3,217,1,5469.86,NULL,'2023-01-12 12:58:55','2023-01-12 12:58:55',NULL),(693,7908,186,40720,1529,3,68,1,1148.67,NULL,'2023-01-12 12:58:55','2023-01-12 12:58:55',NULL),(694,7908,186,40720,1529,3,222,1,381.69,NULL,'2023-01-12 12:58:55','2023-01-12 12:58:55',NULL),(695,7908,186,40720,1529,3,57,2,7000.22,NULL,'2023-01-12 12:58:55','2023-01-12 12:58:55',NULL),(696,7908,187,40720,1529,3,217,1,9377.85,NULL,'2023-01-12 12:59:50','2023-01-12 12:59:50',NULL),(697,7908,187,40720,1529,3,68,1,1969.35,NULL,'2023-01-12 12:59:50','2023-01-12 12:59:50',NULL),(698,7908,187,40720,1529,3,222,1,654.39,NULL,'2023-01-12 12:59:50','2023-01-12 12:59:50',NULL),(699,7908,187,40720,1529,3,57,2,12001.59,NULL,'2023-01-12 12:59:50','2023-01-12 12:59:50',NULL),(700,7908,188,40720,1529,3,217,1,10159.03,NULL,'2023-01-12 13:00:44','2023-01-12 13:00:44',NULL),(701,7908,188,40720,1529,3,68,1,2133.40,NULL,'2023-01-12 13:00:44','2023-01-12 13:00:44',NULL),(702,7908,188,40720,1529,3,222,1,708.90,NULL,'2023-01-12 13:00:44','2023-01-12 13:00:44',NULL),(703,7908,188,40720,1529,3,57,2,13001.33,NULL,'2023-01-12 13:00:44','2023-01-12 13:00:44',NULL),(704,7908,189,40720,1529,3,217,1,6137.15,NULL,'2023-01-12 13:03:52','2023-01-12 13:03:52',NULL),(705,7908,189,40720,1529,3,68,1,1288.80,NULL,'2023-01-12 13:03:52','2023-01-12 13:03:52',NULL),(706,7908,189,40720,1529,3,222,1,573.97,NULL,'2023-01-12 13:03:52','2023-01-12 13:03:52',NULL),(707,7908,189,40720,1529,3,57,2,7999.92,NULL,'2023-01-12 13:03:52','2023-01-12 13:03:52',NULL),(708,7908,190,40720,1529,3,217,1,5871.07,NULL,'2023-01-16 16:52:13','2023-01-16 16:52:13',NULL),(709,7908,190,40720,1529,3,68,1,1232.92,NULL,'2023-01-16 16:52:13','2023-01-16 16:52:13',NULL),(710,7908,190,40720,1529,3,249,1,88.07,NULL,'2023-01-16 16:52:13','2023-01-16 16:52:13',NULL),(711,7908,190,40720,1529,3,57,2,7192.06,NULL,'2023-01-16 16:52:13','2023-01-16 16:52:13',NULL),(712,7908,191,40720,1529,3,217,1,2154.74,NULL,'2023-01-16 16:56:42','2023-01-16 16:56:42',NULL),(713,7908,191,40720,1529,3,68,1,452.50,NULL,'2023-01-16 16:56:42','2023-01-16 16:56:42',NULL),(714,7908,191,40720,1529,3,57,2,2607.24,NULL,'2023-01-16 16:56:42','2023-01-16 16:56:42',NULL),(715,7908,192,40720,1529,3,217,1,2196.53,NULL,'2023-01-16 16:59:42','2023-01-16 16:59:42',NULL),(716,7908,192,40720,1529,3,68,1,461.27,NULL,'2023-01-16 16:59:42','2023-01-16 16:59:42',NULL),(717,7908,192,40720,1529,3,57,2,2657.80,NULL,'2023-01-16 16:59:42','2023-01-16 16:59:42',NULL),(718,7908,193,40720,1529,3,217,1,909.09,NULL,'2023-01-16 17:00:45','2023-01-16 17:00:45',NULL),(719,7908,193,40720,1529,3,68,1,190.91,NULL,'2023-01-16 17:00:45','2023-01-16 17:00:45',NULL),(720,7908,193,40720,1529,3,57,2,1100.00,NULL,'2023-01-16 17:00:45','2023-01-16 17:00:45',NULL),(721,7908,194,40720,1529,3,217,1,13768.98,NULL,'2023-01-16 17:02:22','2023-01-16 17:02:22',NULL),(722,7908,194,40720,1529,3,68,1,2891.49,NULL,'2023-01-16 17:02:22','2023-01-16 17:02:22',NULL),(723,7908,194,40720,1529,3,57,2,16660.47,NULL,'2023-01-16 17:02:22','2023-01-16 17:02:22',NULL),(724,7908,195,40720,1529,3,217,1,1833.24,NULL,'2023-01-16 17:03:10','2023-01-16 17:03:10',NULL),(725,7908,195,40720,1529,3,68,1,384.98,NULL,'2023-01-16 17:03:10','2023-01-16 17:03:10',NULL),(726,7908,195,40720,1529,3,57,2,2218.22,NULL,'2023-01-16 17:03:10','2023-01-16 17:03:10',NULL),(727,7908,196,40720,1529,3,217,1,903.45,NULL,'2023-01-16 17:04:03','2023-01-16 17:04:03',NULL),(728,7908,196,40720,1529,3,68,1,189.72,NULL,'2023-01-16 17:04:03','2023-01-16 17:04:03',NULL),(729,7908,196,40720,1529,3,57,2,1093.17,NULL,'2023-01-16 17:04:03','2023-01-16 17:04:03',NULL),(730,7908,197,40720,1529,3,217,1,24701.66,NULL,'2023-01-16 18:21:18','2023-01-16 18:21:18',NULL),(731,7908,197,40720,1529,3,68,1,5187.35,NULL,'2023-01-16 18:21:18','2023-01-16 18:21:18',NULL),(732,7908,197,40720,1529,3,249,1,185.26,NULL,'2023-01-16 18:21:18','2023-01-16 18:21:18',NULL);
INSERT INTO `balance_libro_details` VALUES (733,7908,197,40720,1529,3,57,2,30074.27,NULL,'2023-01-16 18:21:18','2023-01-16 18:21:18',NULL),(734,7908,198,40720,1529,15,67,1,499835.28,NULL,'2023-01-16 18:44:52','2023-01-16 18:48:07','2023-01-16 18:48:07'),(735,7908,198,40720,1529,15,68,2,552364.73,NULL,'2023-01-16 18:44:52','2023-01-16 18:48:07','2023-01-16 18:48:07'),(736,7908,198,40720,1529,15,353,2,14217.17,NULL,'2023-01-16 18:44:52','2023-01-16 18:48:07','2023-01-16 18:48:07'),(737,7908,198,40720,1529,15,353,1,66746.62,NULL,'2023-01-16 18:44:52','2023-01-16 18:48:07','2023-01-16 18:48:07'),(738,7908,199,40720,1529,15,67,1,499835.28,NULL,'2023-01-16 19:05:16','2023-01-16 19:24:06','2023-01-16 19:24:06'),(739,7908,199,40720,1529,15,68,2,552364.73,NULL,'2023-01-16 19:05:16','2023-01-16 19:24:06','2023-01-16 19:24:06'),(740,7908,199,40720,1529,15,353,2,14217.17,NULL,'2023-01-16 19:05:16','2023-01-16 19:24:06','2023-01-16 19:24:06'),(741,7908,199,40720,1529,15,353,1,66746.62,NULL,'2023-01-16 19:05:16','2023-01-16 19:24:06','2023-01-16 19:24:06'),(742,7908,200,40720,1529,3,217,1,25084.52,NULL,'2023-01-16 19:28:30','2023-01-16 19:52:32','2023-01-16 19:52:32'),(743,7908,200,40720,1529,3,68,1,5267.75,NULL,'2023-01-16 19:28:30','2023-01-16 19:52:32','2023-01-16 19:52:32'),(744,7908,200,40720,1529,3,57,2,30352.27,NULL,'2023-01-16 19:28:30','2023-01-16 19:52:32','2023-01-16 19:52:32'),(745,7908,201,40720,1529,3,217,1,8191.16,NULL,'2023-01-16 19:41:34','2023-01-16 19:48:28','2023-01-16 19:48:28'),(746,7908,201,40720,1529,3,68,1,1720.14,NULL,'2023-01-16 19:41:34','2023-01-16 19:48:28','2023-01-16 19:48:28'),(747,7908,201,40720,1529,3,57,2,9911.30,NULL,'2023-01-16 19:41:34','2023-01-16 19:48:28','2023-01-16 19:48:28'),(748,7908,202,40720,1529,3,217,1,176780.00,NULL,'2023-01-16 19:42:51','2023-01-16 19:51:13','2023-01-16 19:51:13'),(749,7908,202,40720,1529,3,68,1,37123.80,NULL,'2023-01-16 19:42:51','2023-01-16 19:51:13','2023-01-16 19:51:13'),(750,7908,202,40720,1529,3,57,2,213903.80,NULL,'2023-01-16 19:42:51','2023-01-16 19:51:13','2023-01-16 19:51:13'),(751,7908,203,40720,1529,3,217,1,8191.16,NULL,'2023-01-16 19:48:28','2023-01-16 19:48:28',NULL),(752,7908,203,40720,1529,3,68,1,1720.14,NULL,'2023-01-16 19:48:28','2023-01-16 19:48:28',NULL),(753,7908,203,40720,1529,3,57,2,9911.30,NULL,'2023-01-16 19:48:28','2023-01-16 19:48:28',NULL),(754,7908,204,40720,1529,3,217,1,14813.80,NULL,'2023-01-16 19:49:32','2023-01-16 19:49:32',NULL),(755,7908,204,40720,1529,3,68,1,3110.90,NULL,'2023-01-16 19:49:32','2023-01-16 19:49:32',NULL),(756,7908,204,40720,1529,3,57,2,17924.70,NULL,'2023-01-16 19:49:32','2023-01-16 19:49:32',NULL),(757,7908,205,40720,1529,3,217,1,78077.44,NULL,'2023-01-16 19:50:06','2023-01-16 19:50:06',NULL),(758,7908,205,40720,1529,3,68,1,16396.26,NULL,'2023-01-16 19:50:06','2023-01-16 19:50:06',NULL),(759,7908,205,40720,1529,3,57,2,94473.70,NULL,'2023-01-16 19:50:06','2023-01-16 19:50:06',NULL),(760,7908,206,40720,1529,3,217,1,14813.80,NULL,'2023-01-16 19:50:37','2023-01-16 19:50:37',NULL),(761,7908,206,40720,1529,3,68,1,3110.90,NULL,'2023-01-16 19:50:37','2023-01-16 19:50:37',NULL),(762,7908,206,40720,1529,3,57,2,17924.70,NULL,'2023-01-16 19:50:37','2023-01-16 19:50:37',NULL),(763,7908,207,40720,1529,3,217,1,176780.00,NULL,'2023-01-16 19:51:13','2023-01-16 19:51:13',NULL),(764,7908,207,40720,1529,3,68,1,37123.80,NULL,'2023-01-16 19:51:13','2023-01-16 19:51:13',NULL),(765,7908,207,40720,1529,3,57,2,213903.80,NULL,'2023-01-16 19:51:13','2023-01-16 19:51:13',NULL),(766,7908,208,40720,1529,3,217,1,222318.53,NULL,'2023-01-16 19:51:35','2023-01-16 19:51:35',NULL),(767,7908,208,40720,1529,3,68,1,46686.89,NULL,'2023-01-16 19:51:35','2023-01-16 19:51:35',NULL),(768,7908,208,40720,1529,3,57,2,269005.42,NULL,'2023-01-16 19:51:35','2023-01-16 19:51:35',NULL),(769,7908,209,40720,1529,3,217,1,94400.52,NULL,'2023-01-16 19:52:07','2023-01-16 19:52:07',NULL),(770,7908,209,40720,1529,3,68,1,19824.11,NULL,'2023-01-16 19:52:07','2023-01-16 19:52:07',NULL);
INSERT INTO `balance_libro_details` VALUES (771,7908,209,40720,1529,3,57,2,114224.63,NULL,'2023-01-16 19:52:07','2023-01-16 19:52:07',NULL),(772,7908,210,40720,1529,3,217,1,25084.52,NULL,'2023-01-16 19:52:32','2023-01-16 19:52:32',NULL),(773,7908,210,40720,1529,3,68,1,5267.75,NULL,'2023-01-16 19:52:32','2023-01-16 19:52:32',NULL),(774,7908,210,40720,1529,3,57,2,30352.27,NULL,'2023-01-16 19:52:32','2023-01-16 19:52:32',NULL),(775,7908,211,40720,1529,15,67,1,499835.28,NULL,'2023-01-17 20:07:23','2023-01-17 20:11:35','2023-01-17 20:11:35'),(776,7908,211,40720,1529,15,68,2,552364.73,NULL,'2023-01-17 20:07:23','2023-01-17 20:11:35','2023-01-17 20:11:35'),(777,7908,211,40720,1529,15,353,2,14217.17,NULL,'2023-01-17 20:07:23','2023-01-17 20:11:35','2023-01-17 20:11:35'),(778,7908,211,40720,1529,15,353,1,66746.62,NULL,'2023-01-17 20:07:23','2023-01-17 20:11:35','2023-01-17 20:11:35'),(779,7908,212,40720,1529,15,67,1,499835.28,NULL,'2023-01-17 21:35:04','2023-01-17 21:35:04',NULL),(780,7908,212,40720,1529,15,68,2,552364.73,NULL,'2023-01-17 21:35:04','2023-01-17 21:35:04',NULL),(781,7908,212,40720,1529,15,353,2,14217.17,NULL,'2023-01-17 21:35:04','2023-01-17 21:35:04',NULL),(782,7908,212,40720,1529,15,353,1,66746.62,NULL,'2023-01-17 21:35:04','2023-01-17 21:35:04',NULL),(783,7908,213,40720,1534,2,96,2,2280993.00,NULL,'2023-02-02 17:15:07','2023-02-02 17:15:07',NULL),(784,7908,213,40720,1534,2,67,2,479008.53,NULL,'2023-02-02 17:15:07','2023-02-02 17:15:07',NULL),(785,7908,213,40720,1534,2,13,1,2760001.53,NULL,'2023-02-02 17:15:07','2023-02-02 17:15:07',NULL),(786,7908,214,40720,1533,3,217,1,3185.95,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(787,7908,214,40720,1533,3,68,1,669.05,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(788,7908,214,40720,1533,3,217,1,47.78,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(789,7908,214,40720,1533,3,57,2,3902.78,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(790,7908,215,40720,1533,3,217,1,60607.68,NULL,'2023-02-02 19:55:56','2023-02-02 20:02:08','2023-02-02 20:02:08'),(791,7908,215,40720,1533,3,68,1,12727.61,NULL,'2023-02-02 19:55:56','2023-02-02 20:02:08','2023-02-02 20:02:08'),(792,7908,215,40720,1533,3,217,1,2.52,NULL,'2023-02-02 19:55:56','2023-02-02 20:02:08','2023-02-02 20:02:08'),(793,7908,215,40720,1533,3,57,2,73789.85,NULL,'2023-02-02 19:55:56','2023-02-02 20:02:08','2023-02-02 20:02:08'),(794,7908,215,40720,1533,3,136,1,452.04,NULL,'2023-02-02 19:55:56','2023-02-02 20:02:08','2023-02-02 20:02:08'),(795,7908,216,40720,1533,3,217,1,4896.69,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(796,7908,216,40720,1533,3,68,1,1028.31,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(797,7908,216,40720,1533,3,217,1,73.45,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(798,7908,216,40720,1533,3,57,2,5998.45,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(799,7908,217,40720,1533,3,217,1,16528.93,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(800,7908,217,40720,1533,3,68,1,3471.07,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(801,7908,217,40720,1533,3,57,2,20000.00,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(802,7908,218,40720,1533,3,217,1,48647.40,NULL,'2023-02-02 19:55:56','2023-02-02 19:58:17','2023-02-02 19:58:17'),(803,7908,218,40720,1533,3,68,1,10215.95,NULL,'2023-02-02 19:55:56','2023-02-02 19:58:17','2023-02-02 19:58:17'),(804,7908,218,40720,1533,3,217,1,2.00,NULL,'2023-02-02 19:55:56','2023-02-02 19:58:17','2023-02-02 19:58:17'),(805,7908,218,40720,1533,3,57,2,59227.75,NULL,'2023-02-02 19:55:56','2023-02-02 19:58:17','2023-02-02 19:58:17'),(806,7908,218,40720,1533,3,136,1,362.40,NULL,'2023-02-02 19:55:56','2023-02-02 19:58:17','2023-02-02 19:58:17'),(807,7908,219,40720,1533,3,217,1,97695.64,NULL,'2023-02-02 19:55:56','2023-02-02 19:57:56','2023-02-02 19:57:56'),(808,7908,219,40720,1533,3,68,1,19559.17,NULL,'2023-02-02 19:55:56','2023-02-02 19:57:56','2023-02-02 19:57:56');
INSERT INTO `balance_libro_details` VALUES (809,7908,219,40720,1533,3,217,1,4.02,NULL,'2023-02-02 19:55:56','2023-02-02 19:57:56','2023-02-02 19:57:56'),(810,7908,219,40720,1533,3,57,2,117987.25,NULL,'2023-02-02 19:55:56','2023-02-02 19:57:56','2023-02-02 19:57:56'),(811,7908,219,40720,1533,3,136,1,728.42,NULL,'2023-02-02 19:55:56','2023-02-02 19:57:56','2023-02-02 19:57:56'),(812,7908,220,40720,1533,3,217,1,3801.65,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(813,7908,220,40720,1533,3,68,1,798.35,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(814,7908,220,40720,1533,3,57,2,4600.00,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(815,7908,221,40720,1533,3,217,1,30974.16,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:49','2023-02-02 20:00:49'),(816,7908,221,40720,1533,3,68,1,6504.57,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:49','2023-02-02 20:00:49'),(817,7908,221,40720,1533,3,217,1,1.26,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:49','2023-02-02 20:00:49'),(818,7908,221,40720,1533,3,57,2,37711.04,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:49','2023-02-02 20:00:49'),(819,7908,221,40720,1533,3,136,1,231.05,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:49','2023-02-02 20:00:49'),(820,7908,222,40720,1533,3,217,1,9218.50,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:31','2023-02-02 20:00:31'),(821,7908,222,40720,1533,3,68,1,1935.89,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:31','2023-02-02 20:00:31'),(822,7908,222,40720,1533,3,217,1,0.38,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:31','2023-02-02 20:00:31'),(823,7908,222,40720,1533,3,57,2,11224.45,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:31','2023-02-02 20:00:31'),(824,7908,222,40720,1533,3,136,1,69.68,NULL,'2023-02-02 19:55:56','2023-02-02 20:00:31','2023-02-02 20:00:31'),(825,7908,223,40720,1533,3,217,1,359.64,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(826,7908,223,40720,1533,3,68,1,75.52,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(827,7908,223,40720,1533,3,57,2,435.16,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(828,7908,224,40720,1533,3,217,1,11591.74,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(829,7908,224,40720,1533,3,68,1,2434.26,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(830,7908,224,40720,1533,3,217,1,173.87,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(831,7908,224,40720,1533,3,57,2,14199.87,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(832,7908,225,40720,1533,3,217,1,3272.73,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(833,7908,225,40720,1533,3,68,1,687.27,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(834,7908,225,40720,1533,3,217,1,49.09,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(835,7908,225,40720,1533,3,57,2,4009.09,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(836,7908,226,40720,1533,3,217,1,19000.00,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(837,7908,226,40720,1533,3,68,1,3990.00,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(838,7908,226,40720,1533,3,217,1,142.50,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(839,7908,226,40720,1533,3,57,2,23132.50,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(840,7908,227,40720,1533,3,217,1,20586.66,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(841,7908,227,40720,1533,3,68,1,4323.20,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(842,7908,227,40720,1533,3,57,2,24909.86,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(843,7908,228,40720,1533,3,217,1,22809.92,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(844,7908,228,40720,1533,3,68,1,4790.08,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(845,7908,228,40720,1533,3,57,2,27600.00,NULL,'2023-02-02 19:55:56','2023-02-02 19:55:56',NULL),(846,7908,229,40720,1533,3,217,1,22132.88,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(847,7908,229,40720,1533,3,68,1,4647.90,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL);
INSERT INTO `balance_libro_details` VALUES (848,7908,229,40720,1533,3,57,2,26780.78,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(849,7908,230,40720,1533,3,217,1,2721.47,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(850,7908,230,40720,1533,3,68,1,571.51,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(851,7908,230,40720,1533,3,57,2,3292.98,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(852,7908,231,40720,1533,3,217,1,5702.48,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(853,7908,231,40720,1533,3,68,1,1197.52,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(854,7908,231,40720,1533,3,57,2,6900.00,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(855,7908,232,40720,1533,3,217,1,710.17,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(856,7908,232,40720,1533,3,68,1,149.13,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(857,7908,232,40720,1533,3,57,2,859.30,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(858,7908,233,40720,1533,3,217,1,2461.57,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(859,7908,233,40720,1533,3,68,1,516.93,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(860,7908,233,40720,1533,3,57,2,2978.50,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(861,7908,234,40720,1533,3,217,1,2801.48,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(862,7908,234,40720,1533,3,68,1,588.31,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(863,7908,234,40720,1533,3,57,2,3389.79,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(864,7908,235,40720,1533,3,217,1,641.43,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(865,7908,235,40720,1533,3,68,1,134.70,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(866,7908,235,40720,1533,3,57,2,776.13,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(867,7908,236,40720,1533,3,217,1,171.07,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(868,7908,236,40720,1533,3,68,1,35.93,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(869,7908,236,40720,1533,3,57,2,207.00,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(870,7908,237,40720,1533,3,217,1,5305.79,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(871,7908,237,40720,1533,3,68,1,1114.21,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(872,7908,237,40720,1533,3,57,2,6420.00,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(873,7908,238,40720,1533,3,217,1,16694.21,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(874,7908,238,40720,1533,3,68,1,3505.79,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(875,7908,238,40720,1533,3,57,2,20200.00,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(876,7908,239,40720,1533,3,217,1,857000.00,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(877,7908,239,40720,1533,3,68,1,179970.00,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(878,7908,239,40720,1533,3,57,2,1036970.00,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(879,7908,240,40720,1533,3,217,1,3719.01,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(880,7908,240,40720,1533,3,68,1,780.99,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(881,7908,240,40720,1533,3,57,2,4500.00,NULL,'2023-02-02 19:55:57','2023-02-02 19:55:57',NULL),(882,7908,241,40720,1533,3,217,1,97695.64,NULL,'2023-02-02 19:57:56','2023-02-02 20:01:13','2023-02-02 20:01:13'),(883,7908,241,40720,1533,3,68,1,20516.08,NULL,'2023-02-02 19:57:56','2023-02-02 20:01:13','2023-02-02 20:01:13'),(884,7908,241,40720,1533,3,57,2,118211.72,NULL,'2023-02-02 19:57:56','2023-02-02 20:01:13','2023-02-02 20:01:13'),(885,7908,242,40720,1533,3,217,1,48647.40,NULL,'2023-02-02 19:58:17','2023-02-02 20:01:43','2023-02-02 20:01:43'),(886,7908,242,40720,1533,3,68,1,10215.95,NULL,'2023-02-02 19:58:17','2023-02-02 20:01:43','2023-02-02 20:01:43'),(887,7908,242,40720,1533,3,57,2,58863.35,NULL,'2023-02-02 19:58:17','2023-02-02 20:01:43','2023-02-02 20:01:43');
INSERT INTO `balance_libro_details` VALUES (888,7908,243,40720,1533,3,217,1,9218.50,NULL,'2023-02-02 20:00:31','2023-02-02 20:00:31',NULL),(889,7908,243,40720,1533,3,68,1,1935.89,NULL,'2023-02-02 20:00:31','2023-02-02 20:00:31',NULL),(890,7908,243,40720,1533,3,57,2,11154.39,NULL,'2023-02-02 20:00:31','2023-02-02 20:00:31',NULL),(891,7908,244,40720,1533,3,217,1,30974.16,NULL,'2023-02-02 20:00:49','2023-02-02 20:00:49',NULL),(892,7908,244,40720,1533,3,68,1,6504.57,NULL,'2023-02-02 20:00:49','2023-02-02 20:00:49',NULL),(893,7908,244,40720,1533,3,57,2,37478.73,NULL,'2023-02-02 20:00:49','2023-02-02 20:00:49',NULL),(894,7908,245,40720,1533,3,217,1,97695.64,NULL,'2023-02-02 20:01:13','2023-02-02 20:01:13',NULL),(895,7908,245,40720,1533,3,68,1,20516.08,NULL,'2023-02-02 20:01:13','2023-02-02 20:01:13',NULL),(896,7908,245,40720,1533,3,57,2,118211.72,NULL,'2023-02-02 20:01:13','2023-02-02 20:01:13',NULL),(897,7908,246,40720,1533,3,217,1,48647.40,NULL,'2023-02-02 20:01:43','2023-02-02 20:01:43',NULL),(898,7908,246,40720,1533,3,68,1,10215.95,NULL,'2023-02-02 20:01:43','2023-02-02 20:01:43',NULL),(899,7908,246,40720,1533,3,57,2,58863.35,NULL,'2023-02-02 20:01:43','2023-02-02 20:01:43',NULL),(900,7908,247,40720,1533,3,217,1,60607.68,NULL,'2023-02-02 20:02:08','2023-02-02 20:02:49','2023-02-02 20:02:49'),(901,7908,247,40720,1533,3,68,1,12727.61,NULL,'2023-02-02 20:02:08','2023-02-02 20:02:49','2023-02-02 20:02:49'),(902,7908,247,40720,1533,3,57,2,73335.29,NULL,'2023-02-02 20:02:08','2023-02-02 20:02:49','2023-02-02 20:02:49'),(903,7908,248,40720,1533,3,217,1,60607.68,NULL,'2023-02-02 20:02:49','2023-02-02 20:02:49',NULL),(904,7908,248,40720,1533,3,68,1,12727.61,NULL,'2023-02-02 20:02:49','2023-02-02 20:02:49',NULL),(905,7908,248,40720,1533,3,57,2,73335.29,NULL,'2023-02-02 20:02:49','2023-02-02 20:02:49',NULL),(906,7908,249,40720,1533,3,217,1,35119.47,NULL,'2023-02-02 20:10:41','2023-02-02 20:13:02','2023-02-02 20:13:02'),(907,7908,249,40720,1533,3,68,1,7375.09,NULL,'2023-02-02 20:10:41','2023-02-02 20:13:02','2023-02-02 20:13:02'),(908,7908,249,40720,1533,3,217,1,263.40,NULL,'2023-02-02 20:10:41','2023-02-02 20:13:02','2023-02-02 20:13:02'),(909,7908,249,40720,1533,3,57,2,42757.96,NULL,'2023-02-02 20:10:41','2023-02-02 20:13:02','2023-02-02 20:13:02'),(910,7908,250,40720,1533,3,217,1,18195.35,NULL,'2023-02-02 20:10:41','2023-02-02 20:12:12','2023-02-02 20:12:12'),(911,7908,250,40720,1533,3,68,1,3821.71,NULL,'2023-02-02 20:10:41','2023-02-02 20:12:12','2023-02-02 20:12:12'),(912,7908,250,40720,1533,3,217,1,0.74,NULL,'2023-02-02 20:10:41','2023-02-02 20:12:12','2023-02-02 20:12:12'),(913,7908,250,40720,1533,3,57,2,22154.41,NULL,'2023-02-02 20:10:41','2023-02-02 20:12:12','2023-02-02 20:12:12'),(914,7908,250,40720,1533,3,136,1,136.61,NULL,'2023-02-02 20:10:41','2023-02-02 20:12:12','2023-02-02 20:12:12'),(915,7908,251,40720,1533,3,217,1,69913.82,NULL,'2023-02-02 20:10:41','2023-02-02 20:11:55','2023-02-02 20:11:55'),(916,7908,251,40720,1533,3,68,1,14681.90,NULL,'2023-02-02 20:10:41','2023-02-02 20:11:55','2023-02-02 20:11:55'),(917,7908,251,40720,1533,3,217,1,524.35,NULL,'2023-02-02 20:10:41','2023-02-02 20:11:55','2023-02-02 20:11:55'),(918,7908,251,40720,1533,3,57,2,85120.07,NULL,'2023-02-02 20:10:41','2023-02-02 20:11:55','2023-02-02 20:11:55'),(919,7908,252,40720,1533,3,217,1,69913.82,NULL,'2023-02-02 20:11:55','2023-02-02 20:11:55',NULL),(920,7908,252,40720,1533,3,68,1,14681.90,NULL,'2023-02-02 20:11:55','2023-02-02 20:11:55',NULL),(921,7908,252,40720,1533,3,57,2,84595.72,NULL,'2023-02-02 20:11:55','2023-02-02 20:11:55',NULL),(922,7908,253,40720,1533,3,217,1,18195.35,NULL,'2023-02-02 20:12:12','2023-02-02 20:12:12',NULL),(923,7908,253,40720,1533,3,68,1,3821.02,NULL,'2023-02-02 20:12:12','2023-02-02 20:12:12',NULL),(924,7908,253,40720,1533,3,57,2,22016.37,NULL,'2023-02-02 20:12:12','2023-02-02 20:12:12',NULL),(925,7908,254,40720,1533,3,217,1,35119.47,NULL,'2023-02-02 20:13:02','2023-02-02 20:13:02',NULL);
INSERT INTO `balance_libro_details` VALUES (926,7908,254,40720,1533,3,68,1,7375.09,NULL,'2023-02-02 20:13:02','2023-02-02 20:13:02',NULL),(927,7908,254,40720,1533,3,57,2,42494.56,NULL,'2023-02-02 20:13:02','2023-02-02 20:13:02',NULL),(928,7908,255,40720,1533,3,217,1,22745.88,NULL,'2023-02-07 12:52:02','2023-02-07 12:52:02',NULL),(929,7908,255,40720,1533,3,68,1,4776.63,NULL,'2023-02-07 12:52:02','2023-02-07 12:52:02',NULL),(930,7908,255,40720,1533,3,222,1,2478.49,NULL,'2023-02-07 12:52:02','2023-02-07 12:52:02',NULL),(931,7908,255,40720,1533,3,57,2,30001.00,NULL,'2023-02-07 12:52:02','2023-02-07 12:52:02',NULL),(932,7908,256,40720,1533,3,217,1,2868.98,NULL,'2023-02-07 12:53:06','2023-02-07 12:53:06',NULL),(933,7908,256,40720,1533,3,68,1,602.49,NULL,'2023-02-07 12:53:06','2023-02-07 12:53:06',NULL),(934,7908,256,40720,1533,3,222,1,328.14,NULL,'2023-02-07 12:53:06','2023-02-07 12:53:06',NULL),(935,7908,256,40720,1533,3,57,2,3799.61,NULL,'2023-02-07 12:53:06','2023-02-07 12:53:06',NULL),(936,7908,257,40720,1533,3,217,1,2869.96,NULL,'2023-02-07 12:54:14','2023-02-07 12:54:14',NULL),(937,7908,257,40720,1533,3,68,1,602.69,NULL,'2023-02-07 12:54:14','2023-02-07 12:54:14',NULL),(938,7908,257,40720,1533,3,222,1,328.25,NULL,'2023-02-07 12:54:14','2023-02-07 12:54:14',NULL),(939,7908,257,40720,1533,3,57,2,3800.90,NULL,'2023-02-07 12:54:14','2023-02-07 12:54:14',NULL),(940,7908,258,40720,1533,3,217,1,6569.44,NULL,'2023-02-07 12:55:19','2023-02-07 12:55:19',NULL),(941,7908,258,40720,1533,3,68,1,1379.58,NULL,'2023-02-07 12:55:19','2023-02-07 12:55:19',NULL),(942,7908,258,40720,1533,3,222,1,751.37,NULL,'2023-02-07 12:55:19','2023-02-07 12:55:19',NULL),(943,7908,258,40720,1533,3,57,2,8700.39,NULL,'2023-02-07 12:55:19','2023-02-07 12:55:19',NULL),(944,7908,259,40720,1533,3,217,1,16688.87,NULL,'2023-02-07 12:56:37','2023-02-07 12:56:37',NULL),(945,7908,259,40720,1533,3,68,1,3504.66,NULL,'2023-02-07 12:56:37','2023-02-07 12:56:37',NULL),(946,7908,259,40720,1533,3,222,1,1908.77,NULL,'2023-02-07 12:56:37','2023-02-07 12:56:37',NULL),(947,7908,259,40720,1533,3,57,2,22102.30,NULL,'2023-02-07 12:56:37','2023-02-07 12:56:37',NULL),(948,7908,260,40720,1533,3,217,1,14196.60,NULL,'2023-02-07 12:57:34','2023-02-07 12:57:34',NULL),(949,7908,260,40720,1533,3,68,1,2981.29,NULL,'2023-02-07 12:57:34','2023-02-07 12:57:34',NULL),(950,7908,260,40720,1533,3,222,1,1623.72,NULL,'2023-02-07 12:57:34','2023-02-07 12:57:34',NULL),(951,7908,260,40720,1533,3,57,2,18801.61,NULL,'2023-02-07 12:57:34','2023-02-07 12:57:34',NULL),(952,7908,261,40720,1533,3,217,1,5738.94,NULL,'2023-02-07 12:58:33','2023-02-07 12:58:33',NULL),(953,7908,261,40720,1533,3,68,1,1205.18,NULL,'2023-02-07 12:58:34','2023-02-07 12:58:34',NULL),(954,7908,261,40720,1533,3,222,1,656.38,NULL,'2023-02-07 12:58:34','2023-02-07 12:58:34',NULL),(955,7908,261,40720,1533,3,57,2,7600.50,NULL,'2023-02-07 12:58:34','2023-02-07 12:58:34',NULL),(956,7908,262,40720,1533,3,217,1,3881.41,NULL,'2023-02-07 12:59:30','2023-02-07 12:59:30',NULL),(957,7908,262,40720,1533,3,68,1,815.10,NULL,'2023-02-07 12:59:30','2023-02-07 12:59:30',NULL),(958,7908,262,40720,1533,3,222,1,320.48,NULL,'2023-02-07 12:59:30','2023-02-07 12:59:30',NULL),(959,7908,262,40720,1533,3,57,2,5016.99,NULL,'2023-02-07 12:59:30','2023-02-07 12:59:30',NULL),(960,7908,263,40720,1533,3,217,1,8688.41,NULL,'2023-02-07 13:00:40','2023-02-07 13:00:40',NULL),(961,7908,263,40720,1533,3,68,1,1824.57,NULL,'2023-02-07 13:00:40','2023-02-07 13:00:40',NULL),(962,7908,263,40720,1533,3,222,1,993.73,NULL,'2023-02-07 13:00:40','2023-02-07 13:00:40',NULL),(963,7908,263,40720,1533,3,57,2,11506.71,NULL,'2023-02-07 13:00:40','2023-02-07 13:00:40',NULL),(964,7908,264,40720,1533,3,217,1,8761.50,NULL,'2023-02-07 13:01:41','2023-02-07 13:01:41',NULL),(965,7908,264,40720,1533,3,68,1,1839.92,NULL,'2023-02-07 13:01:41','2023-02-07 13:01:41',NULL),(966,7908,264,40720,1533,3,222,1,1002.09,NULL,'2023-02-07 13:01:41','2023-02-07 13:01:41',NULL);
INSERT INTO `balance_libro_details` VALUES (967,7908,264,40720,1533,3,57,2,11603.51,NULL,'2023-02-07 13:01:41','2023-02-07 13:01:41',NULL),(968,7908,265,40720,1533,3,217,1,2871.09,NULL,'2023-02-07 13:02:29','2023-02-07 13:02:29',NULL),(969,7908,265,40720,1533,3,68,1,602.93,NULL,'2023-02-07 13:02:29','2023-02-07 13:02:29',NULL),(970,7908,265,40720,1533,3,222,1,328.38,NULL,'2023-02-07 13:02:29','2023-02-07 13:02:29',NULL),(971,7908,265,40720,1533,3,57,2,3802.40,NULL,'2023-02-07 13:02:29','2023-02-07 13:02:29',NULL),(972,7908,266,40720,1533,3,217,1,6117.65,NULL,'2023-02-07 13:03:22','2023-02-07 13:03:22',NULL),(973,7908,266,40720,1533,3,68,1,1284.71,NULL,'2023-02-07 13:03:22','2023-02-07 13:03:22',NULL),(974,7908,266,40720,1533,3,222,1,601.25,NULL,'2023-02-07 13:03:22','2023-02-07 13:03:22',NULL),(975,7908,266,40720,1533,3,57,2,8003.61,NULL,'2023-02-07 13:03:22','2023-02-07 13:03:22',NULL),(976,7908,267,40720,1533,3,217,1,7552.26,NULL,'2023-02-07 13:05:45','2023-02-07 13:05:45',NULL),(977,7908,267,40720,1533,3,68,1,1585.97,NULL,'2023-02-07 13:05:45','2023-02-07 13:05:45',NULL),(978,7908,267,40720,1533,3,222,1,863.78,NULL,'2023-02-07 13:05:45','2023-02-07 13:05:45',NULL),(979,7908,267,40720,1533,3,57,2,10002.01,NULL,'2023-02-07 13:05:45','2023-02-07 13:05:45',NULL),(980,7908,268,40720,1533,3,217,1,8835.64,NULL,'2023-02-07 13:06:38','2023-02-07 13:06:38',NULL),(981,7908,268,40720,1533,3,68,1,1855.48,NULL,'2023-02-07 13:06:38','2023-02-07 13:06:38',NULL),(982,7908,268,40720,1533,3,222,1,1010.57,NULL,'2023-02-07 13:06:38','2023-02-07 13:06:38',NULL),(983,7908,268,40720,1533,3,57,2,11701.69,NULL,'2023-02-07 13:06:38','2023-02-07 13:06:38',NULL),(984,7908,269,40720,1533,3,217,1,9654.07,NULL,'2023-02-07 13:07:37','2023-02-07 13:07:37',NULL),(985,7908,269,40720,1533,3,68,1,2027.35,NULL,'2023-02-07 13:07:37','2023-02-07 13:07:37',NULL),(986,7908,269,40720,1533,3,222,1,1120.49,NULL,'2023-02-07 13:07:37','2023-02-07 13:07:37',NULL),(987,7908,269,40720,1533,3,57,2,12801.91,NULL,'2023-02-07 13:07:37','2023-02-07 13:07:37',NULL),(988,7908,270,40720,1533,3,217,1,12917.34,NULL,'2023-02-07 13:08:58','2023-02-07 13:08:58',NULL),(989,7908,270,40720,1533,3,68,1,2712.64,NULL,'2023-02-07 13:08:58','2023-02-07 13:08:58',NULL),(990,7908,270,40720,1533,3,222,1,1477.41,NULL,'2023-02-07 13:08:58','2023-02-07 13:08:58',NULL),(991,7908,270,40720,1533,3,57,2,17107.39,NULL,'2023-02-07 13:08:58','2023-02-07 13:08:58',NULL),(992,7908,271,40720,1533,3,217,1,6241.76,NULL,'2023-02-07 18:18:48','2023-02-07 18:18:48',NULL),(993,7908,271,40720,1533,3,68,1,1310.77,NULL,'2023-02-07 18:18:48','2023-02-07 18:18:48',NULL),(994,7908,271,40720,1533,3,222,1,456.97,NULL,'2023-02-07 18:18:48','2023-02-07 18:18:48',NULL),(995,7908,271,40720,1533,3,57,2,8009.50,NULL,'2023-02-07 18:18:48','2023-02-07 18:18:48',NULL),(996,7908,272,40720,1533,3,217,1,7550.73,NULL,'2023-02-07 18:20:07','2023-02-07 18:20:07',NULL),(997,7908,272,40720,1533,3,68,1,1585.65,NULL,'2023-02-07 18:20:07','2023-02-07 18:20:07',NULL),(998,7908,272,40720,1533,3,222,1,863.61,NULL,'2023-02-07 18:20:07','2023-02-07 18:20:07',NULL),(999,7908,272,40720,1533,3,57,2,9999.99,NULL,'2023-02-07 18:20:07','2023-02-07 18:20:07',NULL),(1000,7908,273,40720,1533,3,217,1,8690.14,NULL,'2023-02-07 18:20:51','2023-02-07 18:20:51',NULL),(1001,7908,273,40720,1533,3,68,1,1824.93,NULL,'2023-02-07 18:20:51','2023-02-07 18:20:51',NULL),(1002,7908,273,40720,1533,3,222,1,993.93,NULL,'2023-02-07 18:20:51','2023-02-07 18:20:51',NULL),(1003,7908,273,40720,1533,3,57,2,11509.00,NULL,'2023-02-07 18:20:51','2023-02-07 18:20:51',NULL),(1004,7908,274,40720,1533,3,217,1,2846.70,NULL,'2023-02-07 18:22:38','2023-02-07 18:22:38',NULL),(1005,7908,274,40720,1533,3,68,1,597.81,NULL,'2023-02-07 18:22:38','2023-02-07 18:22:38',NULL),(1006,7908,274,40720,1533,3,222,1,556.89,NULL,'2023-02-07 18:22:38','2023-02-07 18:22:38',NULL),(1007,7908,274,40720,1533,3,57,2,4001.40,NULL,'2023-02-07 18:22:38','2023-02-07 18:22:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1008,7908,275,40720,1533,3,217,1,6021.83,NULL,'2023-02-07 18:23:34','2023-02-07 18:23:34',NULL),(1009,7908,275,40720,1533,3,68,1,1264.58,NULL,'2023-02-07 18:23:34','2023-02-07 18:23:34',NULL),(1010,7908,275,40720,1533,3,222,1,714.58,NULL,'2023-02-07 18:23:34','2023-02-07 18:23:34',NULL),(1011,7908,275,40720,1533,3,57,2,8000.99,NULL,'2023-02-07 18:23:34','2023-02-07 18:23:34',NULL),(1012,7908,276,40720,1533,3,217,1,6022.28,NULL,'2023-02-07 19:26:18','2023-02-07 19:26:18',NULL),(1013,7908,276,40720,1533,3,68,1,1264.68,NULL,'2023-02-07 19:26:18','2023-02-07 19:26:18',NULL),(1014,7908,276,40720,1533,3,222,1,714.64,NULL,'2023-02-07 19:26:18','2023-02-07 19:26:18',NULL),(1015,7908,276,40720,1533,3,57,2,8001.60,NULL,'2023-02-07 19:26:18','2023-02-07 19:26:18',NULL),(1016,7908,277,40720,1533,3,217,1,8692.26,NULL,'2023-02-07 19:27:38','2023-02-07 19:27:38',NULL),(1017,7908,277,40720,1533,3,68,1,1825.37,NULL,'2023-02-07 19:27:38','2023-02-07 19:27:38',NULL),(1018,7908,277,40720,1533,3,222,1,994.17,NULL,'2023-02-07 19:27:38','2023-02-07 19:27:38',NULL),(1019,7908,277,40720,1533,3,57,2,11511.80,NULL,'2023-02-07 19:27:38','2023-02-07 19:27:38',NULL),(1020,7908,278,40720,1533,3,217,1,4533.42,NULL,'2023-02-07 19:28:45','2023-02-07 19:28:45',NULL),(1021,7908,278,40720,1533,3,68,1,952.02,NULL,'2023-02-07 19:28:45','2023-02-07 19:28:45',NULL),(1022,7908,278,40720,1533,3,222,1,526.17,NULL,'2023-02-07 19:28:45','2023-02-07 19:28:45',NULL),(1023,7908,278,40720,1533,3,57,2,6011.61,NULL,'2023-02-07 19:28:45','2023-02-07 19:28:45',NULL),(1024,7908,279,40720,1533,3,217,1,7928.64,NULL,'2023-02-07 19:29:49','2023-02-07 19:29:49',NULL),(1025,7908,279,40720,1533,3,68,1,1665.01,NULL,'2023-02-07 19:29:49','2023-02-07 19:29:49',NULL),(1026,7908,279,40720,1533,3,222,1,906.83,NULL,'2023-02-07 19:29:49','2023-02-07 19:29:49',NULL),(1027,7908,279,40720,1533,3,57,2,10500.48,NULL,'2023-02-07 19:29:49','2023-02-07 19:29:49',NULL),(1028,7908,280,40720,1533,3,217,1,7550.97,NULL,'2023-02-07 19:31:01','2023-02-07 19:31:01',NULL),(1029,7908,280,40720,1533,3,68,1,1585.70,NULL,'2023-02-07 19:31:01','2023-02-07 19:31:01',NULL),(1030,7908,280,40720,1533,3,222,1,863.63,NULL,'2023-02-07 19:31:01','2023-02-07 19:31:01',NULL),(1031,7908,280,40720,1533,3,57,2,10000.30,NULL,'2023-02-07 19:31:01','2023-02-07 19:31:01',NULL),(1032,7908,281,40720,1533,3,217,1,8295.82,NULL,'2023-02-07 19:31:51','2023-02-07 19:31:51',NULL),(1033,7908,281,40720,1533,3,68,1,1742.12,NULL,'2023-02-07 19:31:51','2023-02-07 19:31:51',NULL),(1034,7908,281,40720,1533,3,222,1,962.85,NULL,'2023-02-07 19:31:51','2023-02-07 19:31:51',NULL),(1035,7908,281,40720,1533,3,57,2,11000.79,NULL,'2023-02-07 19:31:51','2023-02-07 19:31:51',NULL),(1036,7908,282,40720,1533,3,217,1,9810.99,NULL,'2023-02-07 19:32:47','2023-02-07 19:32:47',NULL),(1037,7908,282,40720,1533,3,68,1,2060.31,NULL,'2023-02-07 19:32:47','2023-02-07 19:32:47',NULL),(1038,7908,282,40720,1533,3,222,1,1138.70,NULL,'2023-02-07 19:32:47','2023-02-07 19:32:47',NULL),(1039,7908,282,40720,1533,3,57,2,13010.00,NULL,'2023-02-07 19:32:47','2023-02-07 19:32:47',NULL),(1040,7908,283,40720,1533,3,217,1,4678.03,NULL,'2023-02-07 19:34:20','2023-02-07 19:34:20',NULL),(1041,7908,283,40720,1533,3,68,1,982.39,NULL,'2023-02-07 19:34:20','2023-02-07 19:34:20',NULL),(1042,7908,283,40720,1533,3,222,1,342.48,NULL,'2023-02-07 19:34:20','2023-02-07 19:34:20',NULL),(1043,7908,283,40720,1533,3,57,2,6002.90,NULL,'2023-02-07 19:34:20','2023-02-07 19:34:20',NULL),(1044,7908,284,40720,1533,3,217,1,17479.34,NULL,'2023-02-07 19:37:59','2023-02-07 19:37:59',NULL),(1045,7908,284,40720,1533,3,68,1,3670.66,NULL,'2023-02-07 19:37:59','2023-02-07 19:37:59',NULL),(1046,7908,284,40720,1533,3,57,2,21150.00,NULL,'2023-02-07 19:37:59','2023-02-07 19:37:59',NULL),(1047,7908,285,40720,1533,3,217,1,7814.04,NULL,'2023-02-07 19:38:55','2023-02-07 19:38:55',NULL),(1048,7908,285,40720,1533,3,68,1,1640.95,NULL,'2023-02-07 19:38:55','2023-02-07 19:38:55',NULL);
INSERT INTO `balance_libro_details` VALUES (1049,7908,285,40720,1533,3,222,1,545.27,NULL,'2023-02-07 19:38:55','2023-02-07 19:38:55',NULL),(1050,7908,285,40720,1533,3,57,2,10000.26,NULL,'2023-02-07 19:38:55','2023-02-07 19:38:55',NULL),(1051,7908,286,40720,1533,3,217,1,7816.63,NULL,'2023-02-07 19:40:19','2023-02-07 19:40:19',NULL),(1052,7908,286,40720,1533,3,68,1,1641.49,NULL,'2023-02-07 19:40:19','2023-02-07 19:40:19',NULL),(1053,7908,286,40720,1533,3,222,1,545.45,NULL,'2023-02-07 19:40:19','2023-02-07 19:40:19',NULL),(1054,7908,286,40720,1533,3,57,2,10003.57,NULL,'2023-02-07 19:40:19','2023-02-07 19:40:19',NULL),(1055,7908,287,40720,1533,3,217,1,6814.83,NULL,'2023-02-07 19:41:30','2023-02-07 19:41:30',NULL),(1056,7908,287,40720,1533,3,68,1,1431.11,NULL,'2023-02-07 19:41:30','2023-02-07 19:41:30',NULL),(1057,7908,287,40720,1533,3,222,1,454.02,NULL,'2023-02-07 19:41:30','2023-02-07 19:41:30',NULL),(1058,7908,287,40720,1533,3,57,2,8699.96,NULL,'2023-02-07 19:41:30','2023-02-07 19:41:30',NULL),(1059,7908,288,40720,1533,3,217,1,12534.30,NULL,'2023-02-07 19:42:25','2023-02-07 19:42:25',NULL),(1060,7908,288,40720,1533,3,68,1,2632.20,NULL,'2023-02-07 19:42:25','2023-02-07 19:42:25',NULL),(1061,7908,288,40720,1533,3,222,1,835.06,NULL,'2023-02-07 19:42:25','2023-02-07 19:42:25',NULL),(1062,7908,288,40720,1533,3,57,2,16001.56,NULL,'2023-02-07 19:42:25','2023-02-07 19:42:25',NULL),(1063,7908,289,40720,1533,3,217,1,7267.31,NULL,'2023-02-07 19:44:42','2023-02-07 19:44:42',NULL),(1064,7908,289,40720,1533,3,68,1,1526.14,NULL,'2023-02-07 19:44:42','2023-02-07 19:44:42',NULL),(1065,7908,289,40720,1533,3,222,1,507.12,NULL,'2023-02-07 19:44:42','2023-02-07 19:44:42',NULL),(1066,7908,289,40720,1533,3,57,2,9300.57,NULL,'2023-02-07 19:44:42','2023-02-07 19:44:42',NULL),(1067,7908,290,40720,1533,3,217,1,9728.23,NULL,'2023-02-07 19:45:37','2023-02-07 19:45:37',NULL),(1068,7908,290,40720,1533,3,68,1,2042.93,NULL,'2023-02-07 19:45:37','2023-02-07 19:45:37',NULL),(1069,7908,290,40720,1533,3,222,1,678.84,NULL,'2023-02-07 19:45:37','2023-02-07 19:45:37',NULL),(1070,7908,290,40720,1533,3,57,2,12450.00,NULL,'2023-02-07 19:45:37','2023-02-07 19:45:37',NULL),(1071,7908,291,40720,1533,3,217,1,8617.16,NULL,'2023-02-07 19:46:38','2023-02-07 19:46:38',NULL),(1072,7908,291,40720,1533,3,68,1,1809.60,NULL,'2023-02-07 19:46:38','2023-02-07 19:46:38',NULL),(1073,7908,291,40720,1533,3,222,1,574.09,NULL,'2023-02-07 19:46:38','2023-02-07 19:46:38',NULL),(1074,7908,291,40720,1533,3,57,2,11000.85,NULL,'2023-02-07 19:46:38','2023-02-07 19:46:38',NULL),(1075,7908,292,40720,1533,3,217,1,9728.88,NULL,'2023-02-07 19:48:37','2023-02-07 19:48:37',NULL),(1076,7908,292,40720,1533,3,68,1,2043.06,NULL,'2023-02-07 19:48:37','2023-02-07 19:48:37',NULL),(1077,7908,292,40720,1533,3,222,1,678.89,NULL,'2023-02-07 19:48:37','2023-02-07 19:48:37',NULL),(1078,7908,292,40720,1533,3,57,2,12450.83,NULL,'2023-02-07 19:48:37','2023-02-07 19:48:37',NULL),(1079,7908,293,40720,1533,3,217,1,2727.54,NULL,'2023-02-08 11:34:14','2023-02-08 11:34:14',NULL),(1080,7908,293,40720,1533,3,68,1,572.78,NULL,'2023-02-08 11:34:14','2023-02-08 11:34:14',NULL),(1081,7908,293,40720,1533,3,222,1,199.69,NULL,'2023-02-08 11:34:14','2023-02-08 11:34:14',NULL),(1082,7908,293,40720,1533,3,57,2,3500.01,NULL,'2023-02-08 11:34:14','2023-02-08 11:34:14',NULL),(1083,7908,294,40720,1533,3,217,1,3013.71,NULL,'2023-02-08 12:08:52','2023-02-08 12:08:52',NULL),(1084,7908,294,40720,1533,3,68,1,632.88,NULL,'2023-02-08 12:08:52','2023-02-08 12:08:52',NULL),(1085,7908,294,40720,1533,3,222,1,357.62,NULL,'2023-02-08 12:08:52','2023-02-08 12:08:52',NULL),(1086,7908,294,40720,1533,3,57,2,4004.21,NULL,'2023-02-08 12:08:52','2023-02-08 12:08:52',NULL),(1087,7908,295,40720,1533,3,217,1,6037.50,NULL,'2023-02-08 12:09:37','2023-02-08 12:09:37',NULL),(1088,7908,295,40720,1533,3,68,1,1267.88,NULL,'2023-02-08 12:09:37','2023-02-08 12:09:37',NULL),(1089,7908,295,40720,1533,3,222,1,716.44,NULL,'2023-02-08 12:09:37','2023-02-08 12:09:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1090,7908,295,40720,1533,3,57,2,8021.82,NULL,'2023-02-08 12:09:37','2023-02-08 12:09:37',NULL),(1091,7908,296,40720,1533,3,217,1,7547.43,NULL,'2023-02-08 12:10:19','2023-02-08 12:10:19',NULL),(1092,7908,296,40720,1533,3,68,1,1584.96,NULL,'2023-02-08 12:10:19','2023-02-08 12:10:19',NULL),(1093,7908,296,40720,1533,3,222,1,895.62,NULL,'2023-02-08 12:10:19','2023-02-08 12:10:19',NULL),(1094,7908,296,40720,1533,3,57,2,10028.01,NULL,'2023-02-08 12:10:19','2023-02-08 12:10:19',NULL),(1095,7908,297,40720,1533,3,217,1,6919.83,NULL,'2023-02-08 12:11:05','2023-02-08 12:11:05',NULL),(1096,7908,297,40720,1533,3,68,1,1453.16,NULL,'2023-02-08 12:11:05','2023-02-08 12:11:05',NULL),(1097,7908,297,40720,1533,3,222,1,1028.01,NULL,'2023-02-08 12:11:05','2023-02-08 12:11:05',NULL),(1098,7908,297,40720,1533,3,57,2,9401.00,NULL,'2023-02-08 12:11:05','2023-02-08 12:11:05',NULL),(1099,7908,298,40720,1533,3,217,1,4692.45,NULL,'2023-02-08 12:12:02','2023-02-08 12:12:02',NULL),(1100,7908,298,40720,1533,3,68,1,985.41,NULL,'2023-02-08 12:12:02','2023-02-08 12:12:02',NULL),(1101,7908,298,40720,1533,3,222,1,343.54,NULL,'2023-02-08 12:12:02','2023-02-08 12:12:02',NULL),(1102,7908,298,40720,1533,3,57,2,6021.40,NULL,'2023-02-08 12:12:02','2023-02-08 12:12:02',NULL),(1103,7908,299,40720,1533,3,217,1,3118.65,NULL,'2023-02-08 12:12:46','2023-02-08 12:12:46',NULL),(1104,7908,299,40720,1533,3,68,1,654.92,NULL,'2023-02-08 12:12:46','2023-02-08 12:12:46',NULL),(1105,7908,299,40720,1533,3,222,1,228.32,NULL,'2023-02-08 12:12:46','2023-02-08 12:12:46',NULL),(1106,7908,299,40720,1533,3,57,2,4001.89,NULL,'2023-02-08 12:12:46','2023-02-08 12:12:46',NULL),(1107,7908,300,40720,1533,3,217,1,3135.44,NULL,'2023-02-08 12:14:03','2023-02-08 12:14:03',NULL),(1108,7908,300,40720,1533,3,68,1,658.44,NULL,'2023-02-08 12:14:03','2023-02-08 12:14:03',NULL),(1109,7908,300,40720,1533,3,222,1,208.89,NULL,'2023-02-08 12:14:03','2023-02-08 12:14:03',NULL),(1110,7908,300,40720,1533,3,57,2,4002.77,NULL,'2023-02-08 12:14:03','2023-02-08 12:14:03',NULL),(1111,7908,301,40720,1533,3,217,1,3880.00,NULL,'2023-02-08 12:15:29','2023-02-08 12:15:29',NULL),(1112,7908,301,40720,1533,3,68,1,814.80,NULL,'2023-02-08 12:15:29','2023-02-08 12:15:29',NULL),(1113,7908,301,40720,1533,3,222,1,306.60,NULL,'2023-02-08 12:15:29','2023-02-08 12:15:29',NULL),(1114,7908,301,40720,1533,3,57,2,5001.40,NULL,'2023-02-08 12:15:29','2023-02-08 12:15:29',NULL),(1115,7908,302,40720,1533,15,67,1,395703.00,NULL,'2023-02-08 12:20:37','2023-02-08 12:20:37',NULL),(1116,7908,302,40720,1533,15,68,2,379238.39,NULL,'2023-02-08 12:20:37','2023-02-08 12:20:37',NULL),(1117,7908,302,40720,1533,15,353,2,66746.62,NULL,'2023-02-08 12:20:37','2023-02-08 12:20:37',NULL),(1118,7908,302,40720,1533,15,353,1,50282.01,NULL,'2023-02-08 12:20:37','2023-02-08 12:20:37',NULL),(1119,7908,303,40720,1534,3,217,1,95874.00,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1120,7908,303,40720,1534,3,68,1,20133.54,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1121,7908,303,40720,1534,3,57,2,116007.54,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1122,7908,304,40720,1534,3,217,1,270514.60,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1123,7908,304,40720,1534,3,68,1,56808.06,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1124,7908,304,40720,1534,3,57,2,327322.66,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1125,7908,305,40720,1534,3,217,1,139090.91,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1126,7908,305,40720,1534,3,68,1,29209.09,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1127,7908,305,40720,1534,3,57,2,168300.00,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1128,7908,306,40720,1534,3,217,1,1575565.61,NULL,'2023-02-22 12:34:34','2023-02-22 12:36:21','2023-02-22 12:36:21'),(1129,7908,306,40720,1534,3,68,1,165434.39,NULL,'2023-02-22 12:34:34','2023-02-22 12:36:21','2023-02-22 12:36:21');
INSERT INTO `balance_libro_details` VALUES (1130,7908,306,40720,1534,3,217,1,11816.74,NULL,'2023-02-22 12:34:34','2023-02-22 12:36:21','2023-02-22 12:36:21'),(1131,7908,306,40720,1534,3,57,2,1752816.74,NULL,'2023-02-22 12:34:34','2023-02-22 12:36:21','2023-02-22 12:36:21'),(1132,7908,307,40720,1534,3,217,1,8953.97,NULL,'2023-02-22 12:34:34','2023-02-22 12:39:04','2023-02-22 12:39:04'),(1133,7908,307,40720,1534,3,68,1,1880.33,NULL,'2023-02-22 12:34:34','2023-02-22 12:39:04','2023-02-22 12:39:04'),(1134,7908,307,40720,1534,3,217,1,0.35,NULL,'2023-02-22 12:34:34','2023-02-22 12:39:04','2023-02-22 12:39:04'),(1135,7908,307,40720,1534,3,57,2,10900.98,NULL,'2023-02-22 12:34:34','2023-02-22 12:39:04','2023-02-22 12:39:04'),(1136,7908,307,40720,1534,3,136,1,66.33,NULL,'2023-02-22 12:34:34','2023-02-22 12:39:04','2023-02-22 12:39:04'),(1137,7908,308,40720,1534,3,217,1,56229.23,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:39','2023-02-22 12:38:39'),(1138,7908,308,40720,1534,3,68,1,11301.77,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:39','2023-02-22 12:38:39'),(1139,7908,308,40720,1534,3,217,1,2.19,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:39','2023-02-22 12:38:39'),(1140,7908,308,40720,1534,3,57,2,67953.29,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:39','2023-02-22 12:38:39'),(1141,7908,308,40720,1534,3,136,1,420.10,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:39','2023-02-22 12:38:39'),(1142,7908,309,40720,1534,3,217,1,23139.60,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:16','2023-02-22 12:38:16'),(1143,7908,309,40720,1534,3,68,1,4859.32,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:16','2023-02-22 12:38:16'),(1144,7908,309,40720,1534,3,217,1,0.90,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:16','2023-02-22 12:38:16'),(1145,7908,309,40720,1534,3,57,2,28172.46,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:16','2023-02-22 12:38:16'),(1146,7908,309,40720,1534,3,136,1,172.64,NULL,'2023-02-22 12:34:34','2023-02-22 12:38:16','2023-02-22 12:38:16'),(1147,7908,310,40720,1534,3,217,1,53992.40,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:55','2023-02-22 12:37:55'),(1148,7908,310,40720,1534,3,68,1,5669.20,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:55','2023-02-22 12:37:55'),(1149,7908,310,40720,1534,3,217,1,2.10,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:55','2023-02-22 12:37:55'),(1150,7908,310,40720,1534,3,57,2,60066.55,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:55','2023-02-22 12:37:55'),(1151,7908,310,40720,1534,3,136,1,402.85,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:55','2023-02-22 12:37:55'),(1152,7908,311,40720,1534,3,217,1,33938.08,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:20','2023-02-22 12:37:20'),(1153,7908,311,40720,1534,3,68,1,7127.00,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:20','2023-02-22 12:37:20'),(1154,7908,311,40720,1534,3,217,1,1.32,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:20','2023-02-22 12:37:20'),(1155,7908,311,40720,1534,3,57,2,41319.61,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:20','2023-02-22 12:37:20'),(1156,7908,311,40720,1534,3,136,1,253.21,NULL,'2023-02-22 12:34:34','2023-02-22 12:37:20','2023-02-22 12:37:20'),(1157,7908,312,40720,1534,3,217,1,915.90,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1158,7908,312,40720,1534,3,68,1,192.34,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1159,7908,312,40720,1534,3,57,2,1108.24,NULL,'2023-02-22 12:34:34','2023-02-22 12:34:34',NULL),(1160,7908,313,40720,1534,3,217,1,1575565.61,NULL,'2023-02-22 12:36:21','2024-04-23 21:47:11','2024-04-23 21:47:11'),(1161,7908,313,40720,1534,3,68,1,165434.39,NULL,'2023-02-22 12:36:21','2024-04-23 21:47:11','2024-04-23 21:47:11'),(1162,7908,313,40720,1534,3,57,2,1741000.00,NULL,'2023-02-22 12:36:21','2024-04-23 21:47:11','2024-04-23 21:47:11'),(1163,7908,314,40720,1534,3,217,1,33938.08,NULL,'2023-02-22 12:37:20','2023-02-22 12:39:45','2023-02-22 12:39:45'),(1164,7908,314,40720,1534,3,68,1,7127.00,NULL,'2023-02-22 12:37:20','2023-02-22 12:39:45','2023-02-22 12:39:45');
INSERT INTO `balance_libro_details` VALUES (1165,7908,314,40720,1534,3,57,2,41065.08,NULL,'2023-02-22 12:37:20','2023-02-22 12:39:45','2023-02-22 12:39:45'),(1166,7908,315,40720,1534,3,217,1,53992.40,NULL,'2023-02-22 12:37:55','2023-02-22 12:40:06','2023-02-22 12:40:06'),(1167,7908,315,40720,1534,3,68,1,5669.20,NULL,'2023-02-22 12:37:55','2023-02-22 12:40:06','2023-02-22 12:40:06'),(1168,7908,315,40720,1534,3,57,2,59661.60,NULL,'2023-02-22 12:37:55','2023-02-22 12:40:06','2023-02-22 12:40:06'),(1169,7908,316,40720,1534,3,217,1,23139.60,NULL,'2023-02-22 12:38:16','2023-02-22 12:40:26','2023-02-22 12:40:26'),(1170,7908,316,40720,1534,3,68,1,4859.32,NULL,'2023-02-22 12:38:16','2023-02-22 12:40:26','2023-02-22 12:40:26'),(1171,7908,316,40720,1534,3,57,2,27998.92,NULL,'2023-02-22 12:38:16','2023-02-22 12:40:26','2023-02-22 12:40:26'),(1172,7908,317,40720,1534,3,217,1,56229.23,NULL,'2023-02-22 12:38:39','2023-02-22 12:41:06','2023-02-22 12:41:06'),(1173,7908,317,40720,1534,3,68,1,11808.14,NULL,'2023-02-22 12:38:39','2023-02-22 12:41:06','2023-02-22 12:41:06'),(1174,7908,317,40720,1534,3,57,2,68037.37,NULL,'2023-02-22 12:38:39','2023-02-22 12:41:06','2023-02-22 12:41:06'),(1175,7908,318,40720,1534,3,217,1,8953.97,NULL,'2023-02-22 12:39:04','2023-02-22 12:39:04',NULL),(1176,7908,318,40720,1534,3,68,1,1880.33,NULL,'2023-02-22 12:39:04','2023-02-22 12:39:04',NULL),(1177,7908,318,40720,1534,3,57,2,10834.30,NULL,'2023-02-22 12:39:04','2023-02-22 12:39:04',NULL),(1178,7908,319,40720,1534,3,217,1,33938.08,NULL,'2023-02-22 12:39:45','2023-02-22 12:39:45',NULL),(1179,7908,319,40720,1534,3,68,1,7127.00,NULL,'2023-02-22 12:39:45','2023-02-22 12:39:45',NULL),(1180,7908,319,40720,1534,3,57,2,41065.08,NULL,'2023-02-22 12:39:45','2023-02-22 12:39:45',NULL),(1181,7908,320,40720,1534,3,217,1,53992.40,NULL,'2023-02-22 12:40:06','2023-02-22 12:40:06',NULL),(1182,7908,320,40720,1534,3,68,1,5669.20,NULL,'2023-02-22 12:40:06','2023-02-22 12:40:06',NULL),(1183,7908,320,40720,1534,3,57,2,59661.60,NULL,'2023-02-22 12:40:06','2023-02-22 12:40:06',NULL),(1184,7908,321,40720,1534,3,217,1,23139.60,NULL,'2023-02-22 12:40:26','2023-02-22 12:40:40','2023-02-22 12:40:40'),(1185,7908,321,40720,1534,3,68,1,4859.32,NULL,'2023-02-22 12:40:26','2023-02-22 12:40:40','2023-02-22 12:40:40'),(1186,7908,321,40720,1534,3,57,2,27998.92,NULL,'2023-02-22 12:40:26','2023-02-22 12:40:40','2023-02-22 12:40:40'),(1187,7908,322,40720,1534,3,217,1,23139.60,NULL,'2023-02-22 12:40:40','2023-02-22 12:40:53','2023-02-22 12:40:53'),(1188,7908,322,40720,1534,3,68,1,4859.32,NULL,'2023-02-22 12:40:40','2023-02-22 12:40:53','2023-02-22 12:40:53'),(1189,7908,322,40720,1534,3,57,2,27998.92,NULL,'2023-02-22 12:40:40','2023-02-22 12:40:53','2023-02-22 12:40:53'),(1190,7908,323,40720,1534,3,217,1,23139.60,NULL,'2023-02-22 12:40:53','2023-02-22 12:40:53',NULL),(1191,7908,323,40720,1534,3,68,1,4859.32,NULL,'2023-02-22 12:40:53','2023-02-22 12:40:53',NULL),(1192,7908,323,40720,1534,3,57,2,27998.92,NULL,'2023-02-22 12:40:53','2023-02-22 12:40:53',NULL),(1193,7908,324,40720,1534,3,217,1,56229.23,NULL,'2023-02-22 12:41:06','2023-02-22 12:41:06',NULL),(1194,7908,324,40720,1534,3,68,1,11808.14,NULL,'2023-02-22 12:41:06','2023-02-22 12:41:06',NULL),(1195,7908,324,40720,1534,3,57,2,68037.37,NULL,'2023-02-22 12:41:06','2023-02-22 12:41:06',NULL),(1196,7908,325,40720,1534,3,217,1,118863.35,NULL,'2023-02-22 12:52:52','2023-02-22 12:52:52',NULL),(1197,7908,325,40720,1534,3,68,1,12480.65,NULL,'2023-02-22 12:52:52','2023-02-22 12:52:52',NULL),(1198,7908,325,40720,1534,3,57,2,131344.00,NULL,'2023-02-22 12:52:52','2023-02-22 12:52:52',NULL),(1199,7908,326,40720,1534,3,217,1,3032.69,NULL,'2023-02-22 12:57:27','2023-02-22 12:57:27',NULL),(1200,7908,326,40720,1534,3,68,1,636.86,NULL,'2023-02-22 12:57:27','2023-02-22 12:57:27',NULL),(1201,7908,326,40720,1534,3,222,1,330.45,NULL,'2023-02-22 12:57:27','2023-02-22 12:57:27',NULL),(1202,7908,326,40720,1534,3,57,2,4000.00,NULL,'2023-02-22 12:57:27','2023-02-22 12:57:27',NULL);
INSERT INTO `balance_libro_details` VALUES (1203,7908,327,40720,1534,3,217,1,2332.44,NULL,'2023-02-22 12:58:26','2023-02-22 12:58:26',NULL),(1204,7908,327,40720,1534,3,68,1,489.81,NULL,'2023-02-22 12:58:26','2023-02-22 12:58:26',NULL),(1205,7908,327,40720,1534,3,222,1,180.05,NULL,'2023-02-22 12:58:26','2023-02-22 12:58:26',NULL),(1206,7908,327,40720,1534,3,57,2,3002.30,NULL,'2023-02-22 12:58:26','2023-02-22 12:58:26',NULL),(1207,7908,328,40720,1534,3,217,1,3108.55,NULL,'2023-02-22 12:59:23','2023-02-22 12:59:23',NULL),(1208,7908,328,40720,1534,3,68,1,652.80,NULL,'2023-02-22 12:59:23','2023-02-22 12:59:23',NULL),(1209,7908,328,40720,1534,3,222,1,239.96,NULL,'2023-02-22 12:59:23','2023-02-22 12:59:23',NULL),(1210,7908,328,40720,1534,3,57,2,4001.31,NULL,'2023-02-22 12:59:23','2023-02-22 12:59:23',NULL),(1211,7908,329,40720,1534,3,217,1,3231.18,NULL,'2023-02-22 13:01:04','2023-02-22 13:01:04',NULL),(1212,7908,329,40720,1534,3,68,1,678.55,NULL,'2023-02-22 13:01:04','2023-02-22 13:01:04',NULL),(1213,7908,329,40720,1534,3,222,1,236.56,NULL,'2023-02-22 13:01:04','2023-02-22 13:01:04',NULL),(1214,7908,329,40720,1534,3,57,2,4146.29,NULL,'2023-02-22 13:01:04','2023-02-22 13:01:04',NULL),(1215,7908,330,40720,1534,3,217,1,6023.64,NULL,'2023-02-22 13:02:12','2023-02-22 13:02:12',NULL),(1216,7908,330,40720,1534,3,68,1,1264.96,NULL,'2023-02-22 13:02:12','2023-02-22 13:02:12',NULL),(1217,7908,330,40720,1534,3,222,1,714.80,NULL,'2023-02-22 13:02:12','2023-02-22 13:02:12',NULL),(1218,7908,330,40720,1534,3,57,2,8003.40,NULL,'2023-02-22 13:02:12','2023-02-22 13:02:12',NULL),(1219,7908,331,40720,1534,3,217,1,2846.28,NULL,'2023-02-22 13:03:23','2023-02-22 13:03:23',NULL),(1220,7908,331,40720,1534,3,68,1,597.72,NULL,'2023-02-22 13:03:23','2023-02-22 13:03:23',NULL),(1221,7908,331,40720,1534,3,222,1,556.81,NULL,'2023-02-22 13:03:23','2023-02-22 13:03:23',NULL),(1222,7908,331,40720,1534,3,57,2,4000.81,NULL,'2023-02-22 13:03:23','2023-02-22 13:03:23',NULL),(1223,7908,332,40720,1534,3,217,1,30373.25,NULL,'2023-02-22 13:04:40','2023-02-22 13:04:40',NULL),(1224,7908,332,40720,1534,3,68,1,6378.38,NULL,'2023-02-22 13:04:40','2023-02-22 13:04:40',NULL),(1225,7908,332,40720,1534,3,222,1,3250.05,NULL,'2023-02-22 13:04:40','2023-02-22 13:04:40',NULL),(1226,7908,332,40720,1534,3,57,2,40001.68,NULL,'2023-02-22 13:04:40','2023-02-22 13:04:40',NULL),(1227,7908,333,40720,1534,3,217,1,5269.03,NULL,'2023-02-22 13:06:06','2023-02-22 13:06:06',NULL),(1228,7908,333,40720,1534,3,68,1,1106.50,NULL,'2023-02-22 13:06:06','2023-02-22 13:06:06',NULL),(1229,7908,333,40720,1534,3,222,1,624.87,NULL,'2023-02-22 13:06:06','2023-02-22 13:06:06',NULL),(1230,7908,333,40720,1534,3,57,2,7000.40,NULL,'2023-02-22 13:06:06','2023-02-22 13:06:06',NULL),(1231,7908,334,40720,1534,3,217,1,476000.00,NULL,'2023-03-20 19:29:30','2023-03-20 19:29:30',NULL),(1232,7908,334,40720,1534,3,68,1,99960.00,NULL,'2023-03-20 19:29:30','2023-03-20 19:29:30',NULL),(1233,7908,334,40720,1534,3,57,2,575960.00,NULL,'2023-03-20 19:29:30','2023-03-20 19:29:30',NULL),(1234,7908,335,40720,1534,3,217,1,3719.01,NULL,'2023-03-20 19:29:30','2023-03-20 19:29:30',NULL),(1235,7908,335,40720,1534,3,68,1,780.99,NULL,'2023-03-20 19:29:30','2023-03-20 19:29:30',NULL),(1236,7908,335,40720,1534,3,57,2,4500.00,NULL,'2023-03-20 19:29:30','2023-03-20 19:29:30',NULL),(1237,7908,336,40720,1534,3,217,1,6356.18,NULL,'2023-03-20 19:43:01','2023-03-20 19:43:01',NULL),(1238,7908,336,40720,1534,3,68,1,1334.80,NULL,'2023-03-20 19:43:01','2023-03-20 19:43:01',NULL),(1239,7908,336,40720,1534,3,222,1,309.10,NULL,'2023-03-20 19:43:01','2023-03-20 19:43:01',NULL),(1240,7908,336,40720,1534,3,57,2,8000.08,NULL,'2023-03-20 19:43:01','2023-03-20 19:43:01',NULL),(1241,7908,337,40720,1534,3,217,1,3557.92,NULL,'2023-03-20 19:44:41','2023-03-20 19:44:41',NULL),(1242,7908,337,40720,1534,3,68,1,747.16,NULL,'2023-03-20 19:44:41','2023-03-20 19:44:41',NULL),(1243,7908,337,40720,1534,3,222,1,696.03,NULL,'2023-03-20 19:44:41','2023-03-20 19:44:41',NULL);
INSERT INTO `balance_libro_details` VALUES (1244,7908,337,40720,1534,3,57,2,5001.11,NULL,'2023-03-20 19:44:41','2023-03-20 19:44:41',NULL),(1245,7908,338,40720,1534,3,217,1,7695.76,NULL,'2023-03-20 19:45:43','2023-03-20 19:45:43',NULL),(1246,7908,338,40720,1534,3,68,1,1616.11,NULL,'2023-03-20 19:45:43','2023-03-20 19:45:43',NULL),(1247,7908,338,40720,1534,3,222,1,690.42,NULL,'2023-03-20 19:45:43','2023-03-20 19:45:43',NULL),(1248,7908,338,40720,1534,3,57,2,10002.29,NULL,'2023-03-20 19:45:43','2023-03-20 19:45:43',NULL),(1249,7908,339,40720,1534,3,217,1,3108.32,NULL,'2023-03-21 18:56:20','2023-03-21 18:56:20',NULL),(1250,7908,339,40720,1534,3,68,1,652.75,NULL,'2023-03-21 18:56:20','2023-03-21 18:56:20',NULL),(1251,7908,339,40720,1534,3,222,1,239.94,NULL,'2023-03-21 18:56:20','2023-03-21 18:56:20',NULL),(1252,7908,339,40720,1534,3,57,2,4001.01,NULL,'2023-03-21 18:56:20','2023-03-21 18:56:20',NULL),(1253,7908,340,40720,1534,3,217,1,4420.10,NULL,'2023-03-21 18:57:13','2023-03-21 18:57:13',NULL),(1254,7908,340,40720,1534,3,68,1,928.22,NULL,'2023-03-21 18:57:13','2023-03-21 18:57:13',NULL),(1255,7908,340,40720,1534,3,222,1,653.26,NULL,'2023-03-21 18:57:13','2023-03-21 18:57:13',NULL),(1256,7908,340,40720,1534,3,57,2,6001.58,NULL,'2023-03-21 18:57:13','2023-03-21 18:57:13',NULL),(1257,7908,341,40720,1534,3,217,1,7772.62,NULL,'2023-03-21 18:59:33','2023-03-21 18:59:33',NULL),(1258,7908,341,40720,1534,3,68,1,1632.25,NULL,'2023-03-21 18:59:33','2023-03-21 18:59:33',NULL),(1259,7908,341,40720,1534,3,222,1,596.13,NULL,'2023-03-21 18:59:33','2023-03-21 18:59:33',NULL),(1260,7908,341,40720,1534,3,57,2,10001.00,NULL,'2023-03-21 18:59:33','2023-03-21 18:59:33',NULL),(1261,7908,342,40720,1534,3,217,1,2208.21,NULL,'2023-03-21 19:00:45','2023-03-21 19:00:45',NULL),(1262,7908,342,40720,1534,3,68,1,463.72,NULL,'2023-03-21 19:00:45','2023-03-21 19:00:45',NULL),(1263,7908,342,40720,1534,3,222,1,328.06,NULL,'2023-03-21 19:00:45','2023-03-21 19:00:45',NULL),(1264,7908,342,40720,1534,3,57,2,2999.99,NULL,'2023-03-21 19:00:45','2023-03-21 19:00:45',NULL),(1265,7908,343,40720,1534,3,217,1,3108.59,NULL,'2023-03-21 19:02:30','2023-03-21 19:02:30',NULL),(1266,7908,343,40720,1534,3,68,1,652.80,NULL,'2023-03-21 19:02:30','2023-03-21 19:02:30',NULL),(1267,7908,343,40720,1534,3,222,1,238.42,NULL,'2023-03-21 19:02:30','2023-03-21 19:02:30',NULL),(1268,7908,343,40720,1534,3,57,2,3999.81,NULL,'2023-03-21 19:02:30','2023-03-21 19:02:30',NULL),(1269,7908,344,40720,1534,15,67,1,479008.53,NULL,'2023-03-21 19:32:43','2024-04-23 21:44:14','2024-04-23 21:44:14'),(1270,7908,344,40720,1534,15,68,2,436176.46,NULL,'2023-03-21 19:32:43','2024-04-23 21:44:14','2024-04-23 21:44:14'),(1271,7908,344,40720,1534,15,353,2,50282.01,NULL,'2023-03-21 19:32:43','2024-04-23 21:44:14','2024-04-23 21:44:14'),(1272,7908,344,40720,1534,15,353,1,7449.94,NULL,'2023-03-21 19:32:43','2024-04-23 21:44:14','2024-04-23 21:44:14'),(1273,7908,345,40720,1535,2,96,2,2677686.00,NULL,'2023-03-21 20:10:11','2023-03-21 20:10:11',NULL),(1274,7908,345,40720,1535,2,67,2,562314.06,NULL,'2023-03-21 20:10:11','2023-03-21 20:10:11',NULL),(1275,7908,345,40720,1535,2,13,1,3240000.06,NULL,'2023-03-21 20:10:11','2023-03-21 20:10:11',NULL),(1276,7908,346,40720,1535,3,217,1,71998.78,NULL,'2023-03-21 20:11:47','2023-03-21 20:32:34','2023-03-21 20:32:34'),(1277,7908,346,40720,1535,3,68,1,15119.74,NULL,'2023-03-21 20:11:47','2023-03-21 20:32:34','2023-03-21 20:32:34'),(1278,7908,346,40720,1535,3,217,1,539.99,NULL,'2023-03-21 20:11:47','2023-03-21 20:32:34','2023-03-21 20:32:34'),(1279,7908,346,40720,1535,3,57,2,87658.51,NULL,'2023-03-21 20:11:47','2023-03-21 20:32:34','2023-03-21 20:32:34'),(1280,7908,347,40720,1535,3,217,1,63966.94,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1281,7908,347,40720,1535,3,68,1,13433.06,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1282,7908,347,40720,1535,3,57,2,77400.00,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1283,7908,348,40720,1535,3,217,1,1735.54,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1284,7908,348,40720,1535,3,68,1,364.46,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1285,7908,348,40720,1535,3,57,2,2100.00,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1286,7908,349,40720,1535,3,217,1,1886.63,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1287,7908,349,40720,1535,3,68,1,396.19,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1288,7908,349,40720,1535,3,57,2,2282.82,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1289,7908,350,40720,1535,3,217,1,4485.87,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1290,7908,350,40720,1535,3,68,1,942.03,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1291,7908,350,40720,1535,3,57,2,5427.90,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1292,7908,351,40720,1535,3,217,1,1140.50,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1293,7908,351,40720,1535,3,68,1,239.50,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1294,7908,351,40720,1535,3,57,2,1380.00,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1295,7908,352,40720,1535,3,217,1,14051.10,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:49','2023-03-21 20:31:49'),(1296,7908,352,40720,1535,3,68,1,1475.37,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:49','2023-03-21 20:31:49'),(1297,7908,352,40720,1535,3,217,1,0.53,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:49','2023-03-21 20:31:49'),(1298,7908,352,40720,1535,3,57,2,15632.85,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:49','2023-03-21 20:31:49'),(1299,7908,352,40720,1535,3,136,1,105.85,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:49','2023-03-21 20:31:49'),(1300,7908,353,40720,1535,3,217,1,35328.48,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:22','2023-03-21 20:31:22'),(1301,7908,353,40720,1535,3,68,1,7418.98,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:22','2023-03-21 20:31:22'),(1302,7908,353,40720,1535,3,217,1,1.32,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:22','2023-03-21 20:31:22'),(1303,7908,353,40720,1535,3,57,2,43012.42,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:22','2023-03-21 20:31:22'),(1304,7908,353,40720,1535,3,136,1,263.64,NULL,'2023-03-21 20:11:47','2023-03-21 20:31:22','2023-03-21 20:31:22'),(1305,7908,354,40720,1535,3,217,1,1580.17,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1306,7908,354,40720,1535,3,68,1,331.84,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1307,7908,354,40720,1535,3,57,2,1912.01,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1308,7908,355,40720,1535,3,217,1,14144.90,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:34','2023-03-21 20:30:34'),(1309,7908,355,40720,1535,3,68,1,1485.21,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:34','2023-03-21 20:30:34'),(1310,7908,355,40720,1535,3,217,1,0.53,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:34','2023-03-21 20:30:34'),(1311,7908,355,40720,1535,3,57,2,15737.21,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:34','2023-03-21 20:30:34'),(1312,7908,355,40720,1535,3,136,1,106.57,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:34','2023-03-21 20:30:34'),(1313,7908,356,40720,1535,3,217,1,14144.90,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:11','2023-03-21 20:30:11'),(1314,7908,356,40720,1535,3,68,1,1485.21,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:11','2023-03-21 20:30:11'),(1315,7908,356,40720,1535,3,217,1,0.53,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:11','2023-03-21 20:30:11'),(1316,7908,356,40720,1535,3,57,2,15737.21,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:11','2023-03-21 20:30:11'),(1317,7908,356,40720,1535,3,136,1,106.57,NULL,'2023-03-21 20:11:47','2023-03-21 20:30:11','2023-03-21 20:30:11'),(1318,7908,357,40720,1535,3,217,1,6933.88,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1319,7908,357,40720,1535,3,68,1,1456.12,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1320,7908,357,40720,1535,3,57,2,8390.00,NULL,'2023-03-21 20:11:47','2023-03-21 20:11:47',NULL),(1321,7908,358,40720,1535,3,217,1,14144.90,NULL,'2023-03-21 20:30:11','2023-03-21 20:30:11',NULL);
INSERT INTO `balance_libro_details` VALUES (1322,7908,358,40720,1535,3,68,1,1485.21,NULL,'2023-03-21 20:30:11','2023-03-21 20:30:11',NULL),(1323,7908,358,40720,1535,3,57,2,15630.11,NULL,'2023-03-21 20:30:11','2023-03-21 20:30:11',NULL),(1324,7908,359,40720,1535,3,217,1,14144.90,NULL,'2023-03-21 20:30:34','2023-03-21 20:30:34',NULL),(1325,7908,359,40720,1535,3,68,1,1485.21,NULL,'2023-03-21 20:30:34','2023-03-21 20:30:34',NULL),(1326,7908,359,40720,1535,3,57,2,15630.11,NULL,'2023-03-21 20:30:34','2023-03-21 20:30:34',NULL),(1327,7908,360,40720,1535,3,217,1,35328.48,NULL,'2023-03-21 20:31:22','2023-03-21 20:31:22',NULL),(1328,7908,360,40720,1535,3,68,1,7418.98,NULL,'2023-03-21 20:31:22','2023-03-21 20:31:22',NULL),(1329,7908,360,40720,1535,3,57,2,42747.46,NULL,'2023-03-21 20:31:22','2023-03-21 20:31:22',NULL),(1330,7908,361,40720,1535,3,217,1,14051.10,NULL,'2023-03-21 20:31:49','2023-03-21 20:32:15','2023-03-21 20:32:15'),(1331,7908,361,40720,1535,3,68,1,1475.37,NULL,'2023-03-21 20:31:49','2023-03-21 20:32:15','2023-03-21 20:32:15'),(1332,7908,361,40720,1535,3,57,2,15526.47,NULL,'2023-03-21 20:31:49','2023-03-21 20:32:15','2023-03-21 20:32:15'),(1333,7908,362,40720,1535,3,217,1,14051.10,NULL,'2023-03-21 20:32:15','2023-03-21 20:32:15',NULL),(1334,7908,362,40720,1535,3,68,1,1475.37,NULL,'2023-03-21 20:32:15','2023-03-21 20:32:15',NULL),(1335,7908,362,40720,1535,3,57,2,15526.47,NULL,'2023-03-21 20:32:15','2023-03-21 20:32:15',NULL),(1336,7908,363,40720,1535,3,217,1,71998.78,NULL,'2023-03-21 20:32:35','2023-03-21 20:32:35',NULL),(1337,7908,363,40720,1535,3,68,1,15119.74,NULL,'2023-03-21 20:32:35','2023-03-21 20:32:35',NULL),(1338,7908,363,40720,1535,3,57,2,87118.52,NULL,'2023-03-21 20:32:35','2023-03-21 20:32:35',NULL),(1339,7908,364,40720,1536,3,217,1,3904960.50,NULL,'2023-04-26 19:40:48','2023-05-23 14:29:13','2023-05-23 14:29:13'),(1340,7908,364,40720,1536,3,68,1,820041.70,NULL,'2023-04-26 19:40:48','2023-05-23 14:29:13','2023-05-23 14:29:13'),(1341,7908,364,40720,1536,3,57,2,4725002.20,NULL,'2023-04-26 19:40:48','2023-05-23 14:29:13','2023-05-23 14:29:13'),(1342,7908,365,40720,1536,3,217,1,16446.28,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1343,7908,365,40720,1536,3,68,1,3453.72,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1344,7908,365,40720,1536,3,57,2,19900.00,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1345,7908,366,40720,1536,3,217,1,9008.26,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1346,7908,366,40720,1536,3,68,1,1891.74,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1347,7908,366,40720,1536,3,57,2,10900.00,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1348,7908,367,40720,1536,3,217,1,7793.39,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1349,7908,367,40720,1536,3,68,1,1636.61,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1350,7908,367,40720,1536,3,57,2,9430.00,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1351,7908,368,40720,1536,3,217,1,12793.39,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1352,7908,368,40720,1536,3,68,1,2686.61,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1353,7908,368,40720,1536,3,57,2,15480.00,NULL,'2023-04-26 19:46:22','2023-04-26 19:46:22',NULL),(1354,7908,369,40720,1536,3,217,1,5352809.92,NULL,'2023-04-26 19:46:22','2024-04-23 21:31:03','2024-04-23 21:31:03'),(1355,7908,369,40720,1536,3,68,1,1124090.08,NULL,'2023-04-26 19:46:22','2024-04-23 21:31:03','2024-04-23 21:31:03'),(1356,7908,369,40720,1536,3,57,2,6476900.00,NULL,'2023-04-26 19:46:22','2024-04-23 21:31:03','2024-04-23 21:31:03'),(1357,7908,370,40720,1536,3,217,1,1719917.35,NULL,'2023-04-26 19:46:22','2024-04-23 21:32:07','2024-04-23 21:32:07'),(1358,7908,370,40720,1536,3,68,1,361182.65,NULL,'2023-04-26 19:46:22','2024-04-23 21:32:07','2024-04-23 21:32:07'),(1359,7908,370,40720,1536,3,217,1,19000.00,NULL,'2023-04-26 19:46:22','2024-04-23 21:32:07','2024-04-23 21:32:07');
INSERT INTO `balance_libro_details` VALUES (1360,7908,370,40720,1536,3,57,2,2100100.00,NULL,'2023-04-26 19:46:22','2024-04-23 21:32:07','2024-04-23 21:32:07'),(1361,7908,371,40720,1536,2,96,1,6396.69,NULL,'2023-04-26 19:46:34','2023-04-26 19:46:34',NULL),(1362,7908,371,40720,1536,2,68,1,1343.31,NULL,'2023-04-26 19:46:34','2023-04-26 19:46:34',NULL),(1363,7908,371,40720,1536,2,13,2,7740.00,NULL,'2023-04-26 19:46:34','2023-04-26 19:46:34',NULL),(1364,7908,372,40720,1535,3,217,1,2344.48,NULL,'2023-05-19 18:15:54','2023-05-19 18:15:54',NULL),(1365,7908,372,40720,1535,3,68,1,492.34,NULL,'2023-05-19 18:15:54','2023-05-19 18:15:54',NULL),(1366,7908,372,40720,1535,3,222,1,166.97,NULL,'2023-05-19 18:15:54','2023-05-19 18:15:54',NULL),(1367,7908,372,40720,1535,3,57,2,3003.79,NULL,'2023-05-19 18:15:54','2023-05-19 18:15:54',NULL),(1368,7908,373,40720,1535,3,217,1,7406.94,NULL,'2023-05-19 18:17:04','2023-05-19 18:17:04',NULL),(1369,7908,373,40720,1535,3,68,1,1555.46,NULL,'2023-05-19 18:17:04','2023-05-19 18:17:04',NULL),(1370,7908,373,40720,1535,3,222,1,1043.20,NULL,'2023-05-19 18:17:04','2023-05-19 18:17:04',NULL),(1371,7908,373,40720,1535,3,57,2,10005.60,NULL,'2023-05-19 18:17:04','2023-05-19 18:17:04',NULL),(1372,7908,374,40720,1535,3,217,1,7805.54,NULL,'2023-05-19 18:18:34','2023-05-19 18:18:34',NULL),(1373,7908,374,40720,1535,3,68,1,1639.16,NULL,'2023-05-19 18:18:34','2023-05-19 18:18:34',NULL),(1374,7908,374,40720,1535,3,222,1,555.89,NULL,'2023-05-19 18:18:34','2023-05-19 18:18:34',NULL),(1375,7908,374,40720,1535,3,57,2,10000.59,NULL,'2023-05-19 18:18:34','2023-05-19 18:18:34',NULL),(1376,7908,375,40720,1535,3,217,1,3058.60,NULL,'2023-05-19 18:19:47','2023-05-19 18:19:47',NULL),(1377,7908,375,40720,1535,3,68,1,642.31,NULL,'2023-05-19 18:19:47','2023-05-19 18:19:47',NULL),(1378,7908,375,40720,1535,3,222,1,303.69,NULL,'2023-05-19 18:19:47','2023-05-19 18:19:47',NULL),(1379,7908,375,40720,1535,3,57,2,4004.60,NULL,'2023-05-19 18:19:47','2023-05-19 18:19:47',NULL),(1380,7908,376,40720,1535,3,217,1,9831.13,NULL,'2023-05-19 18:21:10','2023-05-19 18:21:10',NULL),(1381,7908,376,40720,1535,3,68,1,2064.54,NULL,'2023-05-19 18:21:10','2023-05-19 18:21:10',NULL),(1382,7908,376,40720,1535,3,222,1,1104.11,NULL,'2023-05-19 18:21:10','2023-05-19 18:21:10',NULL),(1383,7908,376,40720,1535,3,57,2,12999.78,NULL,'2023-05-19 18:21:10','2023-05-19 18:21:10',NULL),(1384,7908,377,40720,1535,3,217,1,7610.54,NULL,'2023-05-19 18:22:20','2023-05-19 18:22:20',NULL),(1385,7908,377,40720,1535,3,68,1,1598.21,NULL,'2023-05-19 18:22:20','2023-05-19 18:22:20',NULL),(1386,7908,377,40720,1535,3,222,1,791.54,NULL,'2023-05-19 18:22:20','2023-05-19 18:22:20',NULL),(1387,7908,377,40720,1535,3,57,2,10000.29,NULL,'2023-05-19 18:22:20','2023-05-19 18:22:20',NULL),(1388,7908,378,40720,1535,3,217,1,6250.77,NULL,'2023-05-19 18:23:46','2023-05-19 18:23:46',NULL),(1389,7908,378,40720,1535,3,68,1,1312.66,NULL,'2023-05-19 18:23:46','2023-05-19 18:23:46',NULL),(1390,7908,378,40720,1535,3,222,1,460.97,NULL,'2023-05-19 18:23:46','2023-05-19 18:23:46',NULL),(1391,7908,378,40720,1535,3,57,2,8024.40,NULL,'2023-05-19 18:23:46','2023-05-19 18:23:46',NULL),(1392,7908,379,40720,1535,3,217,1,6223.59,NULL,'2023-05-19 18:25:57','2023-05-19 18:25:57',NULL),(1393,7908,379,40720,1535,3,68,1,1306.95,NULL,'2023-05-19 18:25:57','2023-05-19 18:25:57',NULL),(1394,7908,379,40720,1535,3,222,1,469.45,NULL,'2023-05-19 18:25:57','2023-05-19 18:25:57',NULL),(1395,7908,379,40720,1535,3,57,2,7999.99,NULL,'2023-05-19 18:25:57','2023-05-19 18:25:57',NULL),(1396,7908,380,40720,1535,3,217,1,3108.74,NULL,'2023-05-19 18:27:41','2023-05-19 18:27:41',NULL),(1397,7908,380,40720,1535,3,68,1,652.84,NULL,'2023-05-19 18:27:41','2023-05-19 18:27:41',NULL),(1398,7908,380,40720,1535,3,222,1,238.43,NULL,'2023-05-19 18:27:41','2023-05-19 18:27:41',NULL),(1399,7908,380,40720,1535,3,57,2,4000.01,NULL,'2023-05-19 18:27:41','2023-05-19 18:27:41',NULL),(1400,7908,381,40720,1535,3,217,1,7598.37,NULL,'2023-05-19 18:29:43','2023-05-19 18:29:43',NULL);
INSERT INTO `balance_libro_details` VALUES (1401,7908,381,40720,1535,3,68,1,1595.66,NULL,'2023-05-19 18:29:43','2023-05-19 18:29:43',NULL),(1402,7908,381,40720,1535,3,222,1,808.77,NULL,'2023-05-19 18:29:43','2023-05-19 18:29:43',NULL),(1403,7908,381,40720,1535,3,57,2,10002.80,NULL,'2023-05-19 18:29:43','2023-05-19 18:29:43',NULL),(1404,7908,382,40720,1535,3,217,1,6078.60,NULL,'2023-05-19 18:31:29','2023-05-19 18:31:29',NULL),(1405,7908,382,40720,1535,3,68,1,1276.51,NULL,'2023-05-19 18:31:29','2023-05-19 18:31:29',NULL),(1406,7908,382,40720,1535,3,222,1,647.00,NULL,'2023-05-19 18:31:29','2023-05-19 18:31:29',NULL),(1407,7908,382,40720,1535,3,57,2,8002.11,NULL,'2023-05-19 18:31:29','2023-05-19 18:31:29',NULL),(1408,7908,383,40720,1535,3,217,1,2578.69,NULL,'2023-05-19 18:33:00','2023-05-19 18:33:00',NULL),(1409,7908,383,40720,1535,3,68,1,541.52,NULL,'2023-05-19 18:33:00','2023-05-19 18:33:00',NULL),(1410,7908,383,40720,1535,3,222,1,194.51,NULL,'2023-05-19 18:33:00','2023-05-19 18:33:00',NULL),(1411,7908,383,40720,1535,3,57,2,3314.72,NULL,'2023-05-19 18:33:00','2023-05-19 18:33:00',NULL),(1412,7908,384,40720,1535,3,217,1,6223.21,NULL,'2023-05-19 18:34:17','2023-05-19 18:34:17',NULL),(1413,7908,384,40720,1535,3,68,1,1306.87,NULL,'2023-05-19 18:34:17','2023-05-19 18:34:17',NULL),(1414,7908,384,40720,1535,3,222,1,469.42,NULL,'2023-05-19 18:34:17','2023-05-19 18:34:17',NULL),(1415,7908,384,40720,1535,3,57,2,7999.50,NULL,'2023-05-19 18:34:17','2023-05-19 18:34:17',NULL),(1416,7908,385,40720,1535,3,217,1,2336.88,NULL,'2023-05-19 18:35:19','2023-05-19 18:35:19',NULL),(1417,7908,385,40720,1535,3,68,1,490.74,NULL,'2023-05-19 18:35:19','2023-05-19 18:35:19',NULL),(1418,7908,385,40720,1535,3,222,1,176.27,NULL,'2023-05-19 18:35:19','2023-05-19 18:35:19',NULL),(1419,7908,385,40720,1535,3,57,2,3003.89,NULL,'2023-05-19 18:35:19','2023-05-19 18:35:19',NULL),(1420,7908,386,40720,1535,3,217,1,12630.00,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1421,7908,386,40720,1535,3,68,1,2652.30,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1422,7908,386,40720,1535,3,57,2,15282.30,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1423,7908,387,40720,1535,3,217,1,54347.17,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1424,7908,387,40720,1535,3,68,1,11412.90,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1425,7908,387,40720,1535,3,57,2,65760.07,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1426,7908,388,40720,1535,3,217,1,5028.60,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1427,7908,388,40720,1535,3,68,1,1056.00,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1428,7908,388,40720,1535,3,57,2,6084.60,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1429,7908,389,40720,1535,3,217,1,2177.82,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1430,7908,389,40720,1535,3,68,1,457.34,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1431,7908,389,40720,1535,3,57,2,2635.16,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1432,7908,390,40720,1535,3,217,1,75.88,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1433,7908,390,40720,1535,3,68,1,15.94,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1434,7908,390,40720,1535,3,57,2,91.82,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1435,7908,391,40720,1535,3,217,1,2350000.00,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1436,7908,391,40720,1535,3,68,1,493500.00,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1437,7908,391,40720,1535,3,57,2,2843500.00,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1438,7908,392,40720,1535,3,217,1,54140.83,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1439,7908,392,40720,1535,3,68,1,11369.57,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1440,7908,392,40720,1535,3,217,1,406.06,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1441,7908,392,40720,1535,3,57,2,65916.46,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1442,7908,393,40720,1535,3,217,1,4958.68,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1443,7908,393,40720,1535,3,68,1,1041.32,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1444,7908,393,40720,1535,3,57,2,6000.00,NULL,'2023-05-19 18:46:35','2023-05-19 18:46:35',NULL),(1445,7908,394,40720,1535,3,217,1,50247.93,NULL,'2023-05-19 18:53:17','2023-05-19 18:53:17',NULL),(1446,7908,394,40720,1535,3,68,1,10552.07,NULL,'2023-05-19 18:53:17','2023-05-19 18:53:17',NULL),(1447,7908,394,40720,1535,3,57,2,60800.00,NULL,'2023-05-19 18:53:17','2023-05-19 18:53:17',NULL),(1448,7908,395,40720,1535,15,67,1,562314.06,NULL,'2023-05-23 12:14:28','2023-05-23 12:14:28',NULL),(1449,7908,395,40720,1535,15,68,2,592680.95,NULL,'2023-05-23 12:14:28','2023-05-23 12:14:28',NULL),(1450,7908,395,40720,1535,15,353,2,7449.94,NULL,'2023-05-23 12:14:28','2023-05-23 12:14:28',NULL),(1451,7908,395,40720,1535,15,353,1,37816.83,NULL,'2023-05-23 12:14:28','2023-05-23 12:14:28',NULL),(1452,7908,396,40720,1536,2,96,2,3904960.50,NULL,'2023-05-23 14:30:35','2023-05-23 14:30:35',NULL),(1453,7908,396,40720,1536,2,67,2,820041.70,NULL,'2023-05-23 14:30:35','2023-05-23 14:30:35',NULL),(1454,7908,396,40720,1536,2,13,1,4725002.20,NULL,'2023-05-23 14:30:35','2023-05-23 14:30:35',NULL),(1455,7908,397,40720,1536,3,217,1,3904960.50,NULL,'2023-05-23 14:30:46','2023-05-23 14:31:45','2023-05-23 14:31:45'),(1456,7908,397,40720,1536,3,68,1,820041.70,NULL,'2023-05-23 14:30:46','2023-05-23 14:31:45','2023-05-23 14:31:45'),(1457,7908,397,40720,1536,3,57,2,4725002.20,NULL,'2023-05-23 14:30:46','2023-05-23 14:31:45','2023-05-23 14:31:45'),(1458,7908,398,40720,1536,3,217,1,4958.68,NULL,'2023-05-23 14:32:26','2023-05-23 14:32:26',NULL),(1459,7908,398,40720,1536,3,68,1,1041.32,NULL,'2023-05-23 14:32:26','2023-05-23 14:32:26',NULL),(1460,7908,398,40720,1536,3,57,2,6000.00,NULL,'2023-05-23 14:32:26','2023-05-23 14:32:26',NULL),(1461,7908,399,40720,1536,3,217,1,2454.55,NULL,'2023-05-23 14:32:26','2023-05-23 14:32:26',NULL),(1462,7908,399,40720,1536,3,68,1,515.45,NULL,'2023-05-23 14:32:26','2023-05-23 14:32:26',NULL),(1463,7908,399,40720,1536,3,57,2,2970.00,NULL,'2023-05-23 14:32:26','2023-05-23 14:32:26',NULL),(1464,7908,400,40720,1536,3,217,1,7493.21,NULL,'2023-05-23 14:52:31','2023-05-23 14:52:31',NULL),(1465,7908,400,40720,1536,3,68,1,1573.57,NULL,'2023-05-23 14:52:31','2023-05-23 14:52:31',NULL),(1466,7908,400,40720,1536,3,222,1,941.32,NULL,'2023-05-23 14:52:31','2023-05-23 14:52:31',NULL),(1467,7908,400,40720,1536,3,57,2,10008.10,NULL,'2023-05-23 14:52:31','2023-05-23 14:52:31',NULL),(1468,7908,401,40720,1536,3,217,1,7818.12,NULL,'2023-05-23 14:53:25','2023-05-23 14:53:25',NULL),(1469,7908,401,40720,1536,3,68,1,1641.81,NULL,'2023-05-23 14:53:25','2023-05-23 14:53:25',NULL),(1470,7908,401,40720,1536,3,222,1,545.60,NULL,'2023-05-23 14:53:25','2023-05-23 14:53:25',NULL),(1471,7908,401,40720,1536,3,57,2,10005.53,NULL,'2023-05-23 14:53:25','2023-05-23 14:53:25',NULL),(1472,7908,402,40720,1536,3,217,1,3055.08,NULL,'2023-05-23 14:54:15','2023-05-23 14:54:15',NULL),(1473,7908,402,40720,1536,3,68,1,641.57,NULL,'2023-05-23 14:54:15','2023-05-23 14:54:15',NULL),(1474,7908,402,40720,1536,3,222,1,303.34,NULL,'2023-05-23 14:54:15','2023-05-23 14:54:15',NULL),(1475,7908,402,40720,1536,3,57,2,3999.99,NULL,'2023-05-23 14:54:15','2023-05-23 14:54:15',NULL),(1476,7908,403,40720,1536,3,217,1,7808.60,NULL,'2023-05-23 14:55:40','2023-05-23 14:55:40',NULL),(1477,7908,403,40720,1536,3,68,1,1639.81,NULL,'2023-05-23 14:55:40','2023-05-23 14:55:40',NULL),(1478,7908,403,40720,1536,3,222,1,556.11,NULL,'2023-05-23 14:55:40','2023-05-23 14:55:40',NULL),(1479,7908,403,40720,1536,3,57,2,10004.52,NULL,'2023-05-23 14:55:40','2023-05-23 14:55:40',NULL),(1480,7908,404,40720,1536,3,217,1,7132.85,NULL,'2023-05-23 14:56:24','2023-05-23 14:56:24',NULL),(1481,7908,404,40720,1536,3,68,1,1497.90,NULL,'2023-05-23 14:56:24','2023-05-23 14:56:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1482,7908,404,40720,1536,3,222,1,669.94,NULL,'2023-05-23 14:56:24','2023-05-23 14:56:24',NULL),(1483,7908,404,40720,1536,3,57,2,9300.69,NULL,'2023-05-23 14:56:24','2023-05-23 14:56:24',NULL),(1484,7908,405,40720,1536,3,217,1,3125.60,NULL,'2023-05-23 14:58:08','2023-05-23 14:58:08',NULL),(1485,7908,405,40720,1536,3,68,1,656.38,NULL,'2023-05-23 14:58:08','2023-05-23 14:58:08',NULL),(1486,7908,405,40720,1536,3,222,1,218.13,NULL,'2023-05-23 14:58:08','2023-05-23 14:58:08',NULL),(1487,7908,405,40720,1536,3,57,2,4000.11,NULL,'2023-05-23 14:58:08','2023-05-23 14:58:08',NULL),(1488,7908,406,40720,1536,3,217,1,5456.52,NULL,'2023-05-23 14:59:22','2023-05-23 14:59:22',NULL),(1489,7908,406,40720,1536,3,68,1,1145.87,NULL,'2023-05-23 14:59:22','2023-05-23 14:59:22',NULL),(1490,7908,406,40720,1536,3,222,1,397.46,NULL,'2023-05-23 14:59:22','2023-05-23 14:59:22',NULL),(1491,7908,406,40720,1536,3,57,2,6999.85,NULL,'2023-05-23 14:59:22','2023-05-23 14:59:22',NULL),(1492,7908,407,40720,1536,3,217,1,2644.62,NULL,'2023-05-23 15:01:43','2023-05-23 15:01:43',NULL),(1493,7908,407,40720,1536,3,68,1,555.37,NULL,'2023-05-23 15:01:43','2023-05-23 15:01:43',NULL),(1494,7908,407,40720,1536,3,57,2,3199.99,NULL,'2023-05-23 15:01:43','2023-05-23 15:01:43',NULL),(1495,7908,408,40720,1536,3,217,1,3140.52,NULL,'2023-05-23 15:02:30','2023-05-23 15:02:30',NULL),(1496,7908,408,40720,1536,3,68,1,659.51,NULL,'2023-05-23 15:02:30','2023-05-23 15:02:30',NULL),(1497,7908,408,40720,1536,3,57,2,3800.03,NULL,'2023-05-23 15:02:30','2023-05-23 15:02:30',NULL),(1498,7908,409,40720,1536,15,67,1,820041.71,NULL,'2023-05-24 12:19:58','2024-04-23 21:28:37','2024-04-23 21:28:37'),(1499,7908,409,40720,1536,15,68,2,1507853.26,NULL,'2023-05-24 12:19:58','2024-04-23 21:28:37','2024-04-23 21:28:37'),(1500,7908,409,40720,1536,15,353,2,37816.83,NULL,'2023-05-24 12:19:58','2024-04-23 21:28:37','2024-04-23 21:28:37'),(1501,7908,409,40720,1536,15,353,1,725628.39,NULL,'2023-05-24 12:19:58','2024-04-23 21:28:37','2024-04-23 21:28:37'),(1502,7908,409,40720,1536,15,136,2,0.01,NULL,'2023-05-24 12:19:58','2024-04-23 21:28:37','2024-04-23 21:28:37'),(1503,7908,410,40720,1537,2,96,2,3719010.00,NULL,'2023-05-24 14:59:49','2023-05-24 14:59:49',NULL),(1504,7908,410,40720,1537,2,67,2,780992.10,NULL,'2023-05-24 14:59:49','2023-05-24 14:59:49',NULL),(1505,7908,410,40720,1537,2,13,1,4500002.10,NULL,'2023-05-24 14:59:49','2023-05-24 14:59:49',NULL),(1506,7908,411,40720,1537,3,217,1,72057.95,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:53','2023-05-24 15:02:53'),(1507,7908,411,40720,1537,3,68,1,15132.17,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:53','2023-05-24 15:02:53'),(1508,7908,411,40720,1537,3,217,1,540.43,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:53','2023-05-24 15:02:53'),(1509,7908,411,40720,1537,3,57,2,87730.55,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:53','2023-05-24 15:02:53'),(1510,7908,412,40720,1537,3,217,1,4545.45,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1511,7908,412,40720,1537,3,68,1,954.55,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1512,7908,412,40720,1537,3,57,2,5500.00,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1513,7908,413,40720,1537,3,217,1,1322.31,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1514,7908,413,40720,1537,3,68,1,277.69,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1515,7908,413,40720,1537,3,57,2,1600.00,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1516,7908,414,40720,1537,3,217,1,350667.77,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1517,7908,414,40720,1537,3,68,1,73640.23,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1518,7908,414,40720,1537,3,57,2,424308.00,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1519,7908,415,40720,1537,3,217,1,18760.33,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1520,7908,415,40720,1537,3,68,1,3939.67,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL);
INSERT INTO `balance_libro_details` VALUES (1521,7908,415,40720,1537,3,57,2,22700.00,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1522,7908,416,40720,1537,3,217,1,26446.28,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1523,7908,416,40720,1537,3,68,1,5553.72,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1524,7908,416,40720,1537,3,57,2,32000.00,NULL,'2023-05-24 15:00:12','2023-05-24 15:00:12',NULL),(1525,7908,417,40720,1537,3,217,1,39502.69,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:29','2023-05-24 15:02:29'),(1526,7908,417,40720,1537,3,68,1,8295.56,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:29','2023-05-24 15:02:29'),(1527,7908,417,40720,1537,3,217,1,296.27,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:29','2023-05-24 15:02:29'),(1528,7908,417,40720,1537,3,57,2,48094.52,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:29','2023-05-24 15:02:29'),(1529,7908,418,40720,1537,3,217,1,32809.00,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:02','2023-05-24 15:02:02'),(1530,7908,418,40720,1537,3,68,1,6889.89,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:02','2023-05-24 15:02:02'),(1531,7908,418,40720,1537,3,217,1,1.05,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:02','2023-05-24 15:02:02'),(1532,7908,418,40720,1537,3,57,2,39944.96,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:02','2023-05-24 15:02:02'),(1533,7908,418,40720,1537,3,136,1,245.02,NULL,'2023-05-24 15:00:12','2023-05-24 15:02:02','2023-05-24 15:02:02'),(1534,7908,419,40720,1537,3,217,1,21794.55,NULL,'2023-05-24 15:00:12','2023-05-24 15:01:34','2023-05-24 15:01:34'),(1535,7908,419,40720,1537,3,68,1,4576.86,NULL,'2023-05-24 15:00:12','2023-05-24 15:01:34','2023-05-24 15:01:34'),(1536,7908,419,40720,1537,3,217,1,0.70,NULL,'2023-05-24 15:00:12','2023-05-24 15:01:34','2023-05-24 15:01:34'),(1537,7908,419,40720,1537,3,57,2,26535.45,NULL,'2023-05-24 15:00:12','2023-05-24 15:01:34','2023-05-24 15:01:34'),(1538,7908,419,40720,1537,3,136,1,163.34,NULL,'2023-05-24 15:00:12','2023-05-24 15:01:34','2023-05-24 15:01:34'),(1539,7908,420,40720,1537,3,217,1,21794.55,NULL,'2023-05-24 15:01:34','2023-06-23 20:24:32','2023-06-23 20:24:32'),(1540,7908,420,40720,1537,3,68,1,4576.86,NULL,'2023-05-24 15:01:34','2023-06-23 20:24:32','2023-06-23 20:24:32'),(1541,7908,420,40720,1537,3,57,2,26371.41,NULL,'2023-05-24 15:01:34','2023-06-23 20:24:32','2023-06-23 20:24:32'),(1542,7908,421,40720,1537,3,217,1,32809.00,NULL,'2023-05-24 15:02:02','2023-06-23 20:24:58','2023-06-23 20:24:58'),(1543,7908,421,40720,1537,3,68,1,6889.89,NULL,'2023-05-24 15:02:02','2023-06-23 20:24:58','2023-06-23 20:24:58'),(1544,7908,421,40720,1537,3,57,2,39698.89,NULL,'2023-05-24 15:02:02','2023-06-23 20:24:58','2023-06-23 20:24:58'),(1545,7908,422,40720,1537,3,217,1,39502.69,NULL,'2023-05-24 15:02:29','2023-06-23 20:25:21','2023-06-23 20:25:21'),(1546,7908,422,40720,1537,3,68,1,8295.56,NULL,'2023-05-24 15:02:29','2023-06-23 20:25:21','2023-06-23 20:25:21'),(1547,7908,422,40720,1537,3,57,2,47798.25,NULL,'2023-05-24 15:02:29','2023-06-23 20:25:21','2023-06-23 20:25:21'),(1548,7908,423,40720,1537,3,217,1,72057.95,NULL,'2023-05-24 15:02:53','2023-06-23 20:25:42','2023-06-23 20:25:42'),(1549,7908,423,40720,1537,3,68,1,15132.17,NULL,'2023-05-24 15:02:53','2023-06-23 20:25:42','2023-06-23 20:25:42'),(1550,7908,423,40720,1537,3,57,2,87190.12,NULL,'2023-05-24 15:02:53','2023-06-23 20:25:42','2023-06-23 20:25:42'),(1551,7908,424,40720,1537,2,96,2,2255884.59,NULL,'2023-06-22 20:22:55','2023-06-22 20:22:55',NULL),(1552,7908,424,40720,1537,2,67,2,236867.88,NULL,'2023-06-22 20:22:55','2023-06-22 20:22:55',NULL),(1553,7908,424,40720,1537,2,13,1,2492752.47,NULL,'2023-06-22 20:22:55','2023-06-22 20:22:55',NULL),(1554,7908,425,40720,1537,7,25,1,157911.92,NULL,'2023-06-23 13:50:32','2023-06-23 13:50:32',NULL),(1555,7908,425,40720,1537,7,13,2,157911.92,NULL,'2023-06-23 13:50:32','2023-06-23 13:50:32',NULL),(1556,7908,426,40720,1537,3,217,1,10454.55,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1557,7908,426,40720,1537,3,68,1,2195.45,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(1558,7908,426,40720,1537,3,57,2,12650.00,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(1559,7908,427,40720,1537,3,217,1,11080.25,NULL,'2023-06-23 14:51:50','2023-06-23 20:20:32','2023-06-23 20:20:32'),(1560,7908,427,40720,1537,3,68,1,2326.85,NULL,'2023-06-23 14:51:50','2023-06-23 20:20:32','2023-06-23 20:20:32'),(1561,7908,427,40720,1537,3,217,1,0.35,NULL,'2023-06-23 14:51:50','2023-06-23 20:20:32','2023-06-23 20:20:32'),(1562,7908,427,40720,1537,3,57,2,13489.62,NULL,'2023-06-23 14:51:50','2023-06-23 20:20:32','2023-06-23 20:20:32'),(1563,7908,427,40720,1537,3,136,1,82.17,NULL,'2023-06-23 14:51:50','2023-06-23 20:20:32','2023-06-23 20:20:32'),(1564,7908,428,40720,1537,3,217,1,43849.50,NULL,'2023-06-23 14:51:50','2023-06-23 20:23:44','2023-06-23 20:23:44'),(1565,7908,428,40720,1537,3,68,1,9208.40,NULL,'2023-06-23 14:51:50','2023-06-23 20:23:44','2023-06-23 20:23:44'),(1566,7908,428,40720,1537,3,217,1,1.40,NULL,'2023-06-23 14:51:50','2023-06-23 20:23:44','2023-06-23 20:23:44'),(1567,7908,428,40720,1537,3,57,2,53387.95,NULL,'2023-06-23 14:51:50','2023-06-23 20:23:44','2023-06-23 20:23:44'),(1568,7908,428,40720,1537,3,136,1,328.65,NULL,'2023-06-23 14:51:50','2023-06-23 20:23:44','2023-06-23 20:23:44'),(1569,7908,429,40720,1537,3,217,1,29061.57,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(1570,7908,429,40720,1537,3,68,1,6102.93,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(1571,7908,429,40720,1537,3,57,2,35164.50,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(1572,7908,430,40720,1537,3,217,1,4958.68,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(1573,7908,430,40720,1537,3,68,1,1041.32,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(1574,7908,430,40720,1537,3,57,2,6000.00,NULL,'2023-06-23 14:51:50','2023-06-23 14:51:50',NULL),(1575,7908,431,40720,1537,3,217,1,12315.06,NULL,'2023-06-23 19:29:51','2023-06-23 19:29:51',NULL),(1576,7908,431,40720,1537,3,68,1,2586.16,NULL,'2023-06-23 19:29:51','2023-06-23 19:29:51',NULL),(1577,7908,431,40720,1537,3,222,1,1098.79,NULL,'2023-06-23 19:29:51','2023-06-23 19:29:51',NULL),(1578,7908,431,40720,1537,3,57,2,16000.01,NULL,'2023-06-23 19:29:51','2023-06-23 19:29:51',NULL),(1579,7908,432,40720,1537,3,217,1,7545.52,NULL,'2023-06-23 19:31:49','2023-06-23 19:31:49',NULL),(1580,7908,432,40720,1537,3,68,1,1584.56,NULL,'2023-06-23 19:31:49','2023-06-23 19:31:49',NULL),(1581,7908,432,40720,1537,3,222,1,673.23,NULL,'2023-06-23 19:31:49','2023-06-23 19:31:49',NULL),(1582,7908,432,40720,1537,3,57,2,9803.31,NULL,'2023-06-23 19:31:49','2023-06-23 19:31:49',NULL),(1583,7908,433,40720,1537,3,217,1,9344.68,NULL,'2023-06-23 19:33:03','2023-06-23 19:33:03',NULL),(1584,7908,433,40720,1537,3,68,1,1962.38,NULL,'2023-06-23 19:33:03','2023-06-23 19:33:03',NULL),(1585,7908,433,40720,1537,3,222,1,707.31,NULL,'2023-06-23 19:33:03','2023-06-23 19:33:03',NULL),(1586,7908,433,40720,1537,3,57,2,12014.37,NULL,'2023-06-23 19:33:03','2023-06-23 19:33:03',NULL),(1587,7908,434,40720,1537,3,217,1,2352.88,NULL,'2023-06-23 19:34:42','2023-06-23 19:34:42',NULL),(1588,7908,434,40720,1537,3,68,1,494.10,NULL,'2023-06-23 19:34:42','2023-06-23 19:34:42',NULL),(1589,7908,434,40720,1537,3,222,1,155.72,NULL,'2023-06-23 19:34:42','2023-06-23 19:34:42',NULL),(1590,7908,434,40720,1537,3,57,2,3002.70,NULL,'2023-06-23 19:34:42','2023-06-23 19:34:42',NULL),(1591,7908,435,40720,1537,3,217,1,11546.52,NULL,'2023-06-23 19:35:54','2023-06-23 19:35:54',NULL),(1592,7908,435,40720,1537,3,68,1,2424.77,NULL,'2023-06-23 19:35:54','2023-06-23 19:35:54',NULL),(1593,7908,435,40720,1537,3,222,1,1030.22,NULL,'2023-06-23 19:35:54','2023-06-23 19:35:54',NULL),(1594,7908,435,40720,1537,3,57,2,15001.51,NULL,'2023-06-23 19:35:54','2023-06-23 19:35:54',NULL),(1595,7908,436,40720,1537,3,217,1,7835.95,NULL,'2023-06-23 19:36:51','2023-06-23 19:36:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1596,7908,436,40720,1537,3,68,1,1645.55,NULL,'2023-06-23 19:36:51','2023-06-23 19:36:51',NULL),(1597,7908,436,40720,1537,3,222,1,518.60,NULL,'2023-06-23 19:36:51','2023-06-23 19:36:51',NULL),(1598,7908,436,40720,1537,3,57,2,10000.10,NULL,'2023-06-23 19:36:51','2023-06-23 19:36:51',NULL),(1599,7908,437,40720,1537,3,217,1,2346.49,NULL,'2023-06-23 19:37:55','2023-06-23 19:37:55',NULL),(1600,7908,437,40720,1537,3,68,1,492.76,NULL,'2023-06-23 19:37:55','2023-06-23 19:37:55',NULL),(1601,7908,437,40720,1537,3,222,1,163.75,NULL,'2023-06-23 19:37:55','2023-06-23 19:37:55',NULL),(1602,7908,437,40720,1537,3,57,2,3003.00,NULL,'2023-06-23 19:37:55','2023-06-23 19:37:55',NULL),(1603,7908,438,40720,1537,3,217,1,17755.24,NULL,'2023-06-23 19:39:22','2023-06-23 19:39:22',NULL),(1604,7908,438,40720,1537,3,68,1,3728.60,NULL,'2023-06-23 19:39:22','2023-06-23 19:39:22',NULL),(1605,7908,438,40720,1537,3,222,1,1516.74,NULL,'2023-06-23 19:39:22','2023-06-23 19:39:22',NULL),(1606,7908,438,40720,1537,3,57,2,23000.58,NULL,'2023-06-23 19:39:22','2023-06-23 19:39:22',NULL),(1607,7908,439,40720,1537,3,217,1,7094.60,NULL,'2023-06-23 19:42:04','2023-06-23 19:42:04',NULL),(1608,7908,439,40720,1537,3,68,1,1489.87,NULL,'2023-06-23 19:42:04','2023-06-23 19:42:04',NULL),(1609,7908,439,40720,1537,3,222,1,666.34,NULL,'2023-06-23 19:42:04','2023-06-23 19:42:04',NULL),(1610,7908,439,40720,1537,3,57,2,9250.81,NULL,'2023-06-23 19:42:04','2023-06-23 19:42:04',NULL),(1611,7908,440,40720,1537,3,217,1,7523.73,NULL,'2023-06-23 19:43:42','2023-06-23 19:43:42',NULL),(1612,7908,440,40720,1537,3,68,1,1579.98,NULL,'2023-06-23 19:43:42','2023-06-23 19:43:42',NULL),(1613,7908,440,40720,1537,3,222,1,899.50,NULL,'2023-06-23 19:43:42','2023-06-23 19:43:42',NULL),(1614,7908,440,40720,1537,3,57,2,10003.21,NULL,'2023-06-23 19:43:42','2023-06-23 19:43:42',NULL),(1615,7908,441,40720,1537,3,217,1,5869.53,NULL,'2023-06-23 19:46:54','2023-06-23 19:46:54',NULL),(1616,7908,441,40720,1537,3,68,1,1232.60,NULL,'2023-06-23 19:46:54','2023-06-23 19:46:54',NULL),(1617,7908,441,40720,1537,3,222,1,897.80,NULL,'2023-06-23 19:46:54','2023-06-23 19:46:54',NULL),(1618,7908,441,40720,1537,3,57,2,7999.93,NULL,'2023-06-23 19:46:54','2023-06-23 19:46:54',NULL),(1619,7908,442,40720,1537,15,67,1,1017859.98,NULL,'2023-06-23 20:02:10','2023-06-23 20:15:39','2023-06-23 20:15:39'),(1620,7908,442,40720,1537,15,68,2,159356.63,NULL,'2023-06-23 20:02:10','2023-06-23 20:15:39','2023-06-23 20:15:39'),(1621,7908,442,40720,1537,15,353,2,725628.39,NULL,'2023-06-23 20:02:10','2023-06-23 20:15:39','2023-06-23 20:15:39'),(1622,7908,442,40720,1537,15,25,2,157911.92,NULL,'2023-06-23 20:02:10','2023-06-23 20:15:39','2023-06-23 20:15:39'),(1623,7908,442,40720,1537,15,354,1,25036.95,NULL,'2023-06-23 20:02:10','2023-06-23 20:15:39','2023-06-23 20:15:39'),(1624,7908,442,40720,1537,15,136,1,0.01,NULL,'2023-06-23 20:02:10','2023-06-23 20:15:39','2023-06-23 20:15:39'),(1625,7908,443,40720,1537,3,217,1,11080.25,NULL,'2023-06-23 20:20:32','2023-06-23 20:24:11','2023-06-23 20:24:11'),(1626,7908,443,40720,1537,3,68,1,2326.85,NULL,'2023-06-23 20:20:32','2023-06-23 20:24:11','2023-06-23 20:24:11'),(1627,7908,443,40720,1537,3,57,2,13407.10,NULL,'2023-06-23 20:20:32','2023-06-23 20:24:11','2023-06-23 20:24:11'),(1628,7908,444,40720,1537,3,217,1,43849.50,NULL,'2023-06-23 20:23:44','2023-06-23 20:28:24','2023-06-23 20:28:24'),(1629,7908,444,40720,1537,3,68,1,9208.40,NULL,'2023-06-23 20:23:44','2023-06-23 20:28:24','2023-06-23 20:28:24'),(1630,7908,444,40720,1537,3,57,2,53057.90,NULL,'2023-06-23 20:23:44','2023-06-23 20:28:24','2023-06-23 20:28:24'),(1631,7908,445,40720,1537,3,217,1,11080.25,NULL,'2023-06-23 20:24:11','2023-06-23 20:24:11',NULL),(1632,7908,445,40720,1537,3,68,1,2326.85,NULL,'2023-06-23 20:24:11','2023-06-23 20:24:11',NULL),(1633,7908,445,40720,1537,3,57,2,13407.10,NULL,'2023-06-23 20:24:11','2023-06-23 20:24:11',NULL),(1634,7908,446,40720,1537,3,217,1,21794.55,NULL,'2023-06-23 20:24:32','2023-06-23 20:24:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1635,7908,446,40720,1537,3,68,1,4576.86,NULL,'2023-06-23 20:24:32','2023-06-23 20:24:32',NULL),(1636,7908,446,40720,1537,3,57,2,26371.41,NULL,'2023-06-23 20:24:32','2023-06-23 20:24:32',NULL),(1637,7908,447,40720,1537,3,217,1,32809.00,NULL,'2023-06-23 20:24:58','2023-06-23 20:24:58',NULL),(1638,7908,447,40720,1537,3,68,1,6889.89,NULL,'2023-06-23 20:24:58','2023-06-23 20:24:58',NULL),(1639,7908,447,40720,1537,3,57,2,39698.89,NULL,'2023-06-23 20:24:58','2023-06-23 20:24:58',NULL),(1640,7908,448,40720,1537,3,217,1,39502.69,NULL,'2023-06-23 20:25:21','2023-06-23 20:25:21',NULL),(1641,7908,448,40720,1537,3,68,1,8295.56,NULL,'2023-06-23 20:25:21','2023-06-23 20:25:21',NULL),(1642,7908,448,40720,1537,3,57,2,47798.25,NULL,'2023-06-23 20:25:21','2023-06-23 20:25:21',NULL),(1643,7908,449,40720,1537,3,217,1,72057.95,NULL,'2023-06-23 20:25:42','2023-06-23 20:26:12','2023-06-23 20:26:12'),(1644,7908,449,40720,1537,3,68,1,15132.17,NULL,'2023-06-23 20:25:42','2023-06-23 20:26:12','2023-06-23 20:26:12'),(1645,7908,449,40720,1537,3,57,2,87190.12,NULL,'2023-06-23 20:25:42','2023-06-23 20:26:12','2023-06-23 20:26:12'),(1646,7908,450,40720,1537,3,217,1,72057.95,NULL,'2023-06-23 20:26:12','2023-06-23 20:26:12',NULL),(1647,7908,450,40720,1537,3,68,1,15132.17,NULL,'2023-06-23 20:26:12','2023-06-23 20:26:12',NULL),(1648,7908,450,40720,1537,3,57,2,87190.12,NULL,'2023-06-23 20:26:12','2023-06-23 20:26:12',NULL),(1649,7908,451,40720,1537,3,217,1,43849.50,NULL,'2023-06-23 20:28:24','2023-06-23 20:28:24',NULL),(1650,7908,451,40720,1537,3,68,1,9208.40,NULL,'2023-06-23 20:28:24','2023-06-23 20:28:24',NULL),(1651,7908,451,40720,1537,3,57,2,53057.90,NULL,'2023-06-23 20:28:24','2023-06-23 20:28:24',NULL),(1652,7908,452,40720,1537,15,67,1,1017859.98,NULL,'2023-06-26 11:56:52','2023-06-26 11:56:52',NULL),(1653,7908,452,40720,1537,15,68,2,159356.63,NULL,'2023-06-26 11:56:52','2023-06-26 11:56:52',NULL),(1654,7908,452,40720,1537,15,353,2,725628.39,NULL,'2023-06-26 11:56:52','2023-06-26 11:56:52',NULL),(1655,7908,452,40720,1537,15,25,2,157911.92,NULL,'2023-06-26 11:56:52','2023-06-26 11:56:52',NULL),(1656,7908,452,40720,1537,15,354,1,25036.95,NULL,'2023-06-26 11:56:52','2023-06-26 11:56:52',NULL),(1657,7908,452,40720,1537,15,136,1,0.01,NULL,'2023-06-26 11:56:52','2023-06-26 11:56:52',NULL),(1658,7908,453,40720,1538,3,217,1,131404.96,NULL,'2023-06-26 12:58:30','2023-06-26 12:58:30',NULL),(1659,7908,453,40720,1538,3,68,1,27595.04,NULL,'2023-06-26 12:58:30','2023-06-26 12:58:30',NULL),(1660,7908,453,40720,1538,3,57,2,159000.00,NULL,'2023-06-26 12:58:30','2023-06-26 12:58:30',NULL),(1661,7908,454,40720,1538,3,217,1,9256.20,NULL,'2023-06-26 12:58:30','2023-06-26 12:58:30',NULL),(1662,7908,454,40720,1538,3,68,1,1943.80,NULL,'2023-06-26 12:58:30','2023-06-26 12:58:30',NULL),(1663,7908,454,40720,1538,3,57,2,11200.00,NULL,'2023-06-26 12:58:30','2023-06-26 12:58:30',NULL),(1664,7908,455,40720,1538,3,217,1,2975.21,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(1665,7908,455,40720,1538,3,68,1,624.79,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(1666,7908,455,40720,1538,3,57,2,3600.00,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(1667,7908,456,40720,1538,3,217,1,213997.95,NULL,'2023-06-26 12:58:31','2023-06-26 12:59:26','2023-06-26 12:59:26'),(1668,7908,456,40720,1538,3,68,1,44939.57,NULL,'2023-06-26 12:58:31','2023-06-26 12:59:26','2023-06-26 12:59:26'),(1669,7908,456,40720,1538,3,217,1,1604.98,NULL,'2023-06-26 12:58:31','2023-06-26 12:59:26','2023-06-26 12:59:26'),(1670,7908,456,40720,1538,3,57,2,260542.50,NULL,'2023-06-26 12:58:31','2023-06-26 12:59:26','2023-06-26 12:59:26'),(1671,7908,457,40720,1538,3,217,1,82479.34,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(1672,7908,457,40720,1538,3,68,1,17320.66,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(1673,7908,457,40720,1538,3,57,2,99800.00,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL);
INSERT INTO `balance_libro_details` VALUES (1674,7908,458,40720,1538,3,217,1,210165.29,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(1675,7908,458,40720,1538,3,68,1,44134.71,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(1676,7908,458,40720,1538,3,57,2,254300.00,NULL,'2023-06-26 12:58:31','2023-06-26 12:58:31',NULL),(1677,7908,459,40720,1538,3,217,1,213997.95,NULL,'2023-06-26 12:59:26','2023-06-26 12:59:26',NULL),(1678,7908,459,40720,1538,3,68,1,44939.57,NULL,'2023-06-26 12:59:26','2023-06-26 12:59:26',NULL),(1679,7908,459,40720,1538,3,57,2,258937.52,NULL,'2023-06-26 12:59:26','2023-06-26 12:59:26',NULL),(1680,7908,460,40720,1538,2,96,2,4388430.00,NULL,'2023-06-26 13:10:18','2023-06-26 13:10:18',NULL),(1681,7908,460,40720,1538,2,67,2,921570.30,NULL,'2023-06-26 13:10:18','2023-06-26 13:10:18',NULL),(1682,7908,460,40720,1538,2,13,1,5310000.30,NULL,'2023-06-26 13:10:18','2023-06-26 13:10:18',NULL),(1683,7908,461,40720,1539,2,96,2,4834713.00,NULL,'2023-07-03 19:47:37','2023-07-03 19:47:37',NULL),(1684,7908,461,40720,1539,2,67,2,1015289.73,NULL,'2023-07-03 19:47:37','2023-07-03 19:47:37',NULL),(1685,7908,461,40720,1539,2,13,1,5850002.73,NULL,'2023-07-03 19:47:37','2023-07-03 19:47:37',NULL),(1686,7908,462,40720,1539,2,96,2,16942150.00,NULL,'2023-07-24 16:17:09','2023-07-24 16:17:09',NULL),(1687,7908,462,40720,1539,2,67,2,3557851.50,NULL,'2023-07-24 16:17:09','2023-07-24 16:17:09',NULL),(1688,7908,462,40720,1539,2,13,1,20500001.50,NULL,'2023-07-24 16:17:09','2023-07-24 16:17:09',NULL),(1689,7908,463,40720,1538,3,217,1,74253.98,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1690,7908,463,40720,1538,3,68,1,15593.34,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1691,7908,463,40720,1538,3,217,1,556.90,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1692,7908,463,40720,1538,3,57,2,90404.22,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1693,7908,464,40720,1538,3,217,1,4958.68,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1694,7908,464,40720,1538,3,68,1,1041.32,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1695,7908,464,40720,1538,3,57,2,6000.00,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1696,7908,465,40720,1538,3,217,1,1300000.00,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1697,7908,465,40720,1538,3,68,1,273000.00,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1698,7908,465,40720,1538,3,57,2,1573000.00,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1699,7908,466,40720,1538,3,217,1,2000000.00,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1700,7908,466,40720,1538,3,68,1,420000.00,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1701,7908,466,40720,1538,3,57,2,2420000.00,NULL,'2023-07-31 18:46:54','2023-07-31 18:46:54',NULL),(1702,7908,467,40720,1539,3,217,1,261983.47,NULL,'2023-07-31 18:57:40','2023-07-31 18:57:40',NULL),(1703,7908,467,40720,1539,3,68,1,55016.53,NULL,'2023-07-31 18:57:40','2023-07-31 18:57:40',NULL),(1704,7908,467,40720,1539,3,57,2,317000.00,NULL,'2023-07-31 18:57:40','2023-07-31 18:57:40',NULL),(1705,7908,468,40720,1539,3,217,1,1300000.00,NULL,'2023-07-31 18:57:40','2023-08-09 19:07:05','2023-08-09 19:07:05'),(1706,7908,468,40720,1539,3,68,1,273000.00,NULL,'2023-07-31 18:57:40','2023-08-09 19:07:05','2023-08-09 19:07:05'),(1707,7908,468,40720,1539,3,57,2,1573000.00,NULL,'2023-07-31 18:57:40','2023-08-09 19:07:05','2023-08-09 19:07:05'),(1708,7908,469,40720,1539,3,217,1,2000000.00,NULL,'2023-07-31 18:57:40','2023-08-09 19:06:40','2023-08-09 19:06:40'),(1709,7908,469,40720,1539,3,68,1,420000.00,NULL,'2023-07-31 18:57:40','2023-08-09 19:06:40','2023-08-09 19:06:40'),(1710,7908,469,40720,1539,3,57,2,2420000.00,NULL,'2023-07-31 18:57:40','2023-08-09 19:06:40','2023-08-09 19:06:40'),(1711,7908,470,40720,1539,3,217,1,1486.78,NULL,'2023-07-31 18:57:41','2023-07-31 18:57:41',NULL),(1712,7908,470,40720,1539,3,68,1,312.22,NULL,'2023-07-31 18:57:41','2023-07-31 18:57:41',NULL);
INSERT INTO `balance_libro_details` VALUES (1713,7908,470,40720,1539,3,57,2,1799.00,NULL,'2023-07-31 18:57:41','2023-07-31 18:57:41',NULL),(1714,7908,471,40720,1539,3,217,1,35966.94,NULL,'2023-07-31 18:57:41','2023-07-31 18:57:41',NULL),(1715,7908,471,40720,1539,3,68,1,7553.06,NULL,'2023-07-31 18:57:41','2023-07-31 18:57:41',NULL),(1716,7908,471,40720,1539,3,57,2,43520.00,NULL,'2023-07-31 18:57:41','2023-07-31 18:57:41',NULL),(1717,7908,472,40720,1539,3,217,1,2227483.00,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:27','2023-07-31 19:06:27'),(1718,7908,472,40720,1539,3,68,1,467770.72,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:27','2023-07-31 19:06:27'),(1719,7908,472,40720,1539,3,217,1,58.83,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:27','2023-07-31 19:06:27'),(1720,7908,472,40720,1539,3,57,2,2711961.44,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:27','2023-07-31 19:06:27'),(1721,7908,472,40720,1539,3,136,1,16648.89,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:27','2023-07-31 19:06:27'),(1722,7908,473,40720,1539,3,217,1,377211.64,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:02','2023-07-31 19:06:02'),(1723,7908,473,40720,1539,3,68,1,79213.28,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:02','2023-07-31 19:06:02'),(1724,7908,473,40720,1539,3,217,1,9.97,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:02','2023-07-31 19:06:02'),(1725,7908,473,40720,1539,3,57,2,459256.40,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:02','2023-07-31 19:06:02'),(1726,7908,473,40720,1539,3,136,1,2821.51,NULL,'2023-07-31 18:57:41','2023-07-31 19:06:02','2023-07-31 19:06:02'),(1727,7908,474,40720,1539,3,217,1,192836.00,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:47','2023-07-31 19:05:47'),(1728,7908,474,40720,1539,3,68,1,40495.56,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:47','2023-07-31 19:05:47'),(1729,7908,474,40720,1539,3,217,1,5.09,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:47','2023-07-31 19:05:47'),(1730,7908,474,40720,1539,3,57,2,234777.12,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:47','2023-07-31 19:05:47'),(1731,7908,474,40720,1539,3,136,1,1440.47,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:47','2023-07-31 19:05:47'),(1732,7908,475,40720,1539,3,217,1,279918.92,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:30','2023-07-31 19:05:30'),(1733,7908,475,40720,1539,3,68,1,58782.32,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:30','2023-07-31 19:05:30'),(1734,7908,475,40720,1539,3,217,1,7.39,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:30','2023-07-31 19:05:30'),(1735,7908,475,40720,1539,3,57,2,340800.00,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:30','2023-07-31 19:05:30'),(1736,7908,475,40720,1539,3,136,1,2091.37,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:30','2023-07-31 19:05:30'),(1737,7908,476,40720,1539,3,217,1,37601600.00,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:15','2023-07-31 19:05:15'),(1738,7908,476,40720,1539,3,68,1,3948168.00,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:15','2023-07-31 19:05:15'),(1739,7908,476,40720,1539,3,217,1,993.00,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:15','2023-07-31 19:05:15'),(1740,7908,476,40720,1539,3,57,2,41831780.00,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:15','2023-07-31 19:05:15'),(1741,7908,476,40720,1539,3,136,1,281019.00,NULL,'2023-07-31 18:57:41','2023-07-31 19:05:15','2023-07-31 19:05:15'),(1742,7908,477,40720,1539,3,217,1,376093.94,NULL,'2023-07-31 18:57:41','2023-07-31 19:04:52','2023-07-31 19:04:52'),(1743,7908,477,40720,1539,3,68,1,78980.27,NULL,'2023-07-31 18:57:41','2023-07-31 19:04:52','2023-07-31 19:04:52'),(1744,7908,477,40720,1539,3,217,1,9.94,NULL,'2023-07-31 18:57:41','2023-07-31 19:04:52','2023-07-31 19:04:52'),(1745,7908,477,40720,1539,3,57,2,457892.19,NULL,'2023-07-31 18:57:41','2023-07-31 19:04:52','2023-07-31 19:04:52'),(1746,7908,477,40720,1539,3,136,1,2808.04,NULL,'2023-07-31 18:57:41','2023-07-31 19:04:52','2023-07-31 19:04:52'),(1747,7908,478,40720,1539,3,217,1,376093.94,NULL,'2023-07-31 19:04:52','2023-08-09 19:10:31','2023-08-09 19:10:31');
INSERT INTO `balance_libro_details` VALUES (1748,7908,478,40720,1539,3,68,1,78979.73,NULL,'2023-07-31 19:04:52','2023-08-09 19:10:31','2023-08-09 19:10:31'),(1749,7908,478,40720,1539,3,57,2,455073.67,NULL,'2023-07-31 19:04:52','2023-08-09 19:10:31','2023-08-09 19:10:31'),(1750,7908,479,40720,1539,3,217,1,37601600.00,NULL,'2023-07-31 19:05:15','2023-08-09 19:34:56','2023-08-09 19:34:56'),(1751,7908,479,40720,1539,3,68,1,3948168.00,NULL,'2023-07-31 19:05:15','2023-08-09 19:34:56','2023-08-09 19:34:56'),(1752,7908,479,40720,1539,3,57,2,41549768.00,NULL,'2023-07-31 19:05:15','2023-08-09 19:34:56','2023-08-09 19:34:56'),(1753,7908,480,40720,1539,3,217,1,279918.92,NULL,'2023-07-31 19:05:30','2023-08-09 19:35:13','2023-08-09 19:35:13'),(1754,7908,480,40720,1539,3,68,1,58782.97,NULL,'2023-07-31 19:05:30','2023-08-09 19:35:13','2023-08-09 19:35:13'),(1755,7908,480,40720,1539,3,57,2,338701.89,NULL,'2023-07-31 19:05:30','2023-08-09 19:35:13','2023-08-09 19:35:13'),(1756,7908,481,40720,1539,3,217,1,192836.00,NULL,'2023-07-31 19:05:47','2023-08-09 19:35:35','2023-08-09 19:35:35'),(1757,7908,481,40720,1539,3,68,1,40495.56,NULL,'2023-07-31 19:05:47','2023-08-09 19:35:35','2023-08-09 19:35:35'),(1758,7908,481,40720,1539,3,57,2,233331.56,NULL,'2023-07-31 19:05:47','2023-08-09 19:35:35','2023-08-09 19:35:35'),(1759,7908,482,40720,1539,3,217,1,377211.64,NULL,'2023-07-31 19:06:02','2023-08-09 19:35:54','2023-08-09 19:35:54'),(1760,7908,482,40720,1539,3,68,1,79214.44,NULL,'2023-07-31 19:06:02','2023-08-09 19:35:54','2023-08-09 19:35:54'),(1761,7908,482,40720,1539,3,57,2,456426.08,NULL,'2023-07-31 19:06:02','2023-08-09 19:35:54','2023-08-09 19:35:54'),(1762,7908,483,40720,1539,3,217,1,2227483.00,NULL,'2023-07-31 19:06:27','2023-08-09 19:36:14','2023-08-09 19:36:14'),(1763,7908,483,40720,1539,3,68,1,467771.43,NULL,'2023-07-31 19:06:27','2023-08-09 19:36:14','2023-08-09 19:36:14'),(1764,7908,483,40720,1539,3,57,2,2695254.43,NULL,'2023-07-31 19:06:27','2023-08-09 19:36:14','2023-08-09 19:36:14'),(1765,7908,484,40720,1538,3,217,1,7337.12,NULL,'2023-08-02 19:12:51','2023-08-02 19:12:51',NULL),(1766,7908,484,40720,1538,3,68,1,1540.80,NULL,'2023-08-02 19:12:51','2023-08-02 19:12:51',NULL),(1767,7908,484,40720,1538,3,222,1,1122.28,NULL,'2023-08-02 19:12:51','2023-08-02 19:12:51',NULL),(1768,7908,484,40720,1538,3,57,2,10000.20,NULL,'2023-08-02 19:12:51','2023-08-02 19:12:51',NULL),(1769,7908,485,40720,1538,3,217,1,6197.64,NULL,'2023-08-02 19:14:10','2023-08-02 19:14:10',NULL),(1770,7908,485,40720,1538,3,68,1,1301.50,NULL,'2023-08-02 19:14:10','2023-08-02 19:14:10',NULL),(1771,7908,485,40720,1538,3,222,1,507.47,NULL,'2023-08-02 19:14:10','2023-08-02 19:14:10',NULL),(1772,7908,485,40720,1538,3,57,2,8006.61,NULL,'2023-08-02 19:14:10','2023-08-02 19:14:10',NULL),(1773,7908,486,40720,1538,3,217,1,5187.25,NULL,'2023-08-02 19:15:04','2023-08-02 19:15:04',NULL),(1774,7908,486,40720,1538,3,68,1,1089.32,NULL,'2023-08-02 19:15:04','2023-08-02 19:15:04',NULL),(1775,7908,486,40720,1538,3,222,1,424.74,NULL,'2023-08-02 19:15:04','2023-08-02 19:15:04',NULL),(1776,7908,486,40720,1538,3,57,2,6701.31,NULL,'2023-08-02 19:15:04','2023-08-02 19:15:04',NULL),(1777,7908,487,40720,1538,3,217,1,9289.33,NULL,'2023-08-02 19:15:54','2023-08-02 19:15:54',NULL),(1778,7908,487,40720,1538,3,68,1,1950.76,NULL,'2023-08-02 19:15:54','2023-08-02 19:15:54',NULL),(1779,7908,487,40720,1538,3,222,1,760.62,NULL,'2023-08-02 19:15:54','2023-08-02 19:15:54',NULL),(1780,7908,487,40720,1538,3,57,2,12000.71,NULL,'2023-08-02 19:15:54','2023-08-02 19:15:54',NULL),(1781,7908,488,40720,1538,3,217,1,7747.31,NULL,'2023-08-02 19:16:45','2023-08-02 19:16:45',NULL),(1782,7908,488,40720,1538,3,68,1,1626.94,NULL,'2023-08-02 19:16:45','2023-08-02 19:16:45',NULL),(1783,7908,488,40720,1538,3,222,1,634.36,NULL,'2023-08-02 19:16:45','2023-08-02 19:16:45',NULL),(1784,7908,488,40720,1538,3,57,2,10008.61,NULL,'2023-08-02 19:16:45','2023-08-02 19:16:45',NULL),(1785,7908,489,40720,1538,3,217,1,5419.46,NULL,'2023-08-02 19:17:28','2023-08-02 19:17:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1786,7908,489,40720,1538,3,68,1,1138.09,NULL,'2023-08-02 19:17:28','2023-08-02 19:17:28',NULL),(1787,7908,489,40720,1538,3,222,1,443.75,NULL,'2023-08-02 19:17:28','2023-08-02 19:17:28',NULL),(1788,7908,489,40720,1538,3,57,2,7001.30,NULL,'2023-08-02 19:17:28','2023-08-02 19:17:28',NULL),(1789,7908,490,40720,1538,3,217,1,5391.67,NULL,'2023-08-02 19:18:19','2023-08-02 19:18:19',NULL),(1790,7908,490,40720,1538,3,68,1,1132.25,NULL,'2023-08-02 19:18:19','2023-08-02 19:18:19',NULL),(1791,7908,490,40720,1538,3,222,1,478.29,NULL,'2023-08-02 19:18:19','2023-08-02 19:18:19',NULL),(1792,7908,490,40720,1538,3,57,2,7002.21,NULL,'2023-08-02 19:18:19','2023-08-02 19:18:19',NULL),(1793,7908,491,40720,1538,3,217,1,7703.12,NULL,'2023-08-02 19:18:58','2023-08-02 19:18:58',NULL),(1794,7908,491,40720,1538,3,68,1,1617.66,NULL,'2023-08-02 19:18:58','2023-08-02 19:18:58',NULL),(1795,7908,491,40720,1538,3,222,1,683.33,NULL,'2023-08-02 19:18:58','2023-08-02 19:18:58',NULL),(1796,7908,491,40720,1538,3,57,2,10004.11,NULL,'2023-08-02 19:18:58','2023-08-02 19:18:58',NULL),(1797,7908,492,40720,1538,3,217,1,7700.35,NULL,'2023-08-02 19:19:52','2023-08-02 19:19:52',NULL),(1798,7908,492,40720,1538,3,68,1,1617.07,NULL,'2023-08-02 19:19:52','2023-08-02 19:19:52',NULL),(1799,7908,492,40720,1538,3,222,1,683.09,NULL,'2023-08-02 19:19:52','2023-08-02 19:19:52',NULL),(1800,7908,492,40720,1538,3,57,2,10000.51,NULL,'2023-08-02 19:19:53','2023-08-02 19:19:53',NULL),(1801,7908,493,40720,1538,3,217,1,6187.55,NULL,'2023-08-02 19:20:39','2023-08-02 19:20:39',NULL),(1802,7908,493,40720,1538,3,68,1,1299.39,NULL,'2023-08-02 19:20:39','2023-08-02 19:20:39',NULL),(1803,7908,493,40720,1538,3,222,1,515.57,NULL,'2023-08-02 19:20:39','2023-08-02 19:20:39',NULL),(1804,7908,493,40720,1538,3,57,2,8002.51,NULL,'2023-08-02 19:20:39','2023-08-02 19:20:39',NULL),(1805,7908,494,40720,1538,3,217,1,9281.13,NULL,'2023-08-02 19:21:18','2023-08-02 19:21:18',NULL),(1806,7908,494,40720,1538,3,68,1,1949.04,NULL,'2023-08-02 19:21:18','2023-08-02 19:21:18',NULL),(1807,7908,494,40720,1538,3,222,1,773.34,NULL,'2023-08-02 19:21:18','2023-08-02 19:21:18',NULL),(1808,7908,494,40720,1538,3,57,2,12003.51,NULL,'2023-08-02 19:21:18','2023-08-02 19:21:18',NULL),(1809,7908,495,40720,1538,3,217,1,7848.06,NULL,'2023-08-02 19:22:21','2023-08-02 19:22:21',NULL),(1810,7908,495,40720,1538,3,68,1,1648.09,NULL,'2023-08-02 19:22:21','2023-08-02 19:22:21',NULL),(1811,7908,495,40720,1538,3,222,1,503.44,NULL,'2023-08-02 19:22:21','2023-08-02 19:22:21',NULL),(1812,7908,495,40720,1538,3,57,2,9999.59,NULL,'2023-08-02 19:22:21','2023-08-02 19:22:21',NULL),(1813,7908,496,40720,1538,3,217,1,7749.26,NULL,'2023-08-02 19:23:17','2023-08-02 19:23:17',NULL),(1814,7908,496,40720,1538,3,68,1,1627.34,NULL,'2023-08-02 19:23:17','2023-08-02 19:23:17',NULL),(1815,7908,496,40720,1538,3,222,1,645.70,NULL,'2023-08-02 19:23:17','2023-08-02 19:23:17',NULL),(1816,7908,496,40720,1538,3,57,2,10022.30,NULL,'2023-08-02 19:23:17','2023-08-02 19:23:17',NULL),(1817,7908,497,40720,1538,3,217,1,6192.83,NULL,'2023-08-02 19:24:05','2023-08-02 19:24:05',NULL),(1818,7908,497,40720,1538,3,68,1,1300.49,NULL,'2023-08-02 19:24:05','2023-08-02 19:24:05',NULL),(1819,7908,497,40720,1538,3,222,1,507.08,NULL,'2023-08-02 19:24:05','2023-08-02 19:24:05',NULL),(1820,7908,497,40720,1538,3,57,2,8000.40,NULL,'2023-08-02 19:24:05','2023-08-02 19:24:05',NULL),(1821,7908,498,40720,1538,3,217,1,3091.23,NULL,'2023-08-02 19:25:00','2023-08-02 19:25:00',NULL),(1822,7908,498,40720,1538,3,68,1,649.16,NULL,'2023-08-02 19:25:00','2023-08-02 19:25:00',NULL),(1823,7908,498,40720,1538,3,222,1,274.22,NULL,'2023-08-02 19:25:00','2023-08-02 19:25:00',NULL),(1824,7908,498,40720,1538,3,57,2,4014.61,NULL,'2023-08-02 19:25:00','2023-08-02 19:25:00',NULL),(1825,7908,499,40720,1538,3,217,1,11507.19,NULL,'2023-08-02 19:26:22','2023-08-02 19:26:22',NULL),(1826,7908,499,40720,1538,3,68,1,2416.51,NULL,'2023-08-02 19:26:22','2023-08-02 19:26:22',NULL);
INSERT INTO `balance_libro_details` VALUES (1827,7908,499,40720,1538,3,222,1,1080.13,NULL,'2023-08-02 19:26:22','2023-08-02 19:26:22',NULL),(1828,7908,499,40720,1538,3,57,2,15003.83,NULL,'2023-08-02 19:26:22','2023-08-02 19:26:22',NULL),(1829,7908,500,40720,1538,3,217,1,15405.31,NULL,'2023-08-02 19:27:10','2023-08-02 19:27:10',NULL),(1830,7908,500,40720,1538,3,68,1,3235.12,NULL,'2023-08-02 19:27:10','2023-08-02 19:27:10',NULL),(1831,7908,500,40720,1538,3,222,1,1366.58,NULL,'2023-08-02 19:27:10','2023-08-02 19:27:10',NULL),(1832,7908,500,40720,1538,3,57,2,20007.01,NULL,'2023-08-02 19:27:10','2023-08-02 19:27:10',NULL),(1833,7908,501,40720,1538,3,217,1,3668.49,NULL,'2023-08-02 19:28:08','2023-08-02 19:28:08',NULL),(1834,7908,501,40720,1538,3,68,1,770.38,NULL,'2023-08-02 19:28:08','2023-08-02 19:28:08',NULL),(1835,7908,501,40720,1538,3,222,1,561.13,NULL,'2023-08-02 19:28:08','2023-08-02 19:28:08',NULL),(1836,7908,501,40720,1538,3,57,2,5000.00,NULL,'2023-08-02 19:28:08','2023-08-02 19:28:08',NULL),(1837,7908,502,40720,1538,3,217,1,7836.73,NULL,'2023-08-02 19:29:03','2023-08-02 19:29:03',NULL),(1838,7908,502,40720,1538,3,68,1,1645.71,NULL,'2023-08-02 19:29:03','2023-08-02 19:29:03',NULL),(1839,7908,502,40720,1538,3,222,1,518.65,NULL,'2023-08-02 19:29:03','2023-08-02 19:29:03',NULL),(1840,7908,502,40720,1538,3,57,2,10001.09,NULL,'2023-08-02 19:29:03','2023-08-02 19:29:03',NULL),(1841,7908,503,40720,1538,3,217,1,15393.59,NULL,'2023-08-02 19:29:45','2023-08-02 19:29:45',NULL),(1842,7908,503,40720,1538,3,68,1,3232.65,NULL,'2023-08-02 19:29:45','2023-08-02 19:29:45',NULL),(1843,7908,503,40720,1538,3,222,1,1373.46,NULL,'2023-08-02 19:29:45','2023-08-02 19:29:45',NULL),(1844,7908,503,40720,1538,3,57,2,19999.70,NULL,'2023-08-02 19:29:45','2023-08-02 19:29:45',NULL),(1845,7908,504,40720,1538,3,217,1,17600.24,NULL,'2023-08-02 19:30:41','2023-08-02 19:30:41',NULL),(1846,7908,504,40720,1538,3,68,1,3696.05,NULL,'2023-08-02 19:30:41','2023-08-02 19:30:41',NULL),(1847,7908,504,40720,1538,3,222,1,1710.72,NULL,'2023-08-02 19:30:41','2023-08-02 19:30:41',NULL),(1848,7908,504,40720,1538,3,57,2,23007.01,NULL,'2023-08-02 19:30:41','2023-08-02 19:30:41',NULL),(1849,7908,505,40720,1538,3,217,1,15466.55,NULL,'2023-08-02 19:31:34','2023-08-02 19:31:34',NULL),(1850,7908,505,40720,1538,3,68,1,3247.98,NULL,'2023-08-02 19:31:34','2023-08-02 19:31:34',NULL),(1851,7908,505,40720,1538,3,222,1,1379.97,NULL,'2023-08-02 19:31:34','2023-08-02 19:31:34',NULL),(1852,7908,505,40720,1538,3,57,2,20094.50,NULL,'2023-08-02 19:31:34','2023-08-02 19:31:34',NULL),(1853,7908,506,40720,1538,3,217,1,6017.58,NULL,'2023-08-02 19:32:41','2023-08-02 19:32:41',NULL),(1854,7908,506,40720,1538,3,68,1,1263.69,NULL,'2023-08-02 19:32:41','2023-08-02 19:32:41',NULL),(1855,7908,506,40720,1538,3,222,1,719.37,NULL,'2023-08-02 19:32:41','2023-08-02 19:32:41',NULL),(1856,7908,506,40720,1538,3,57,2,8000.64,NULL,'2023-08-02 19:32:41','2023-08-02 19:32:41',NULL),(1857,7908,507,40720,1538,3,217,1,5303.57,NULL,'2023-08-02 19:33:52','2023-08-02 19:33:52',NULL),(1858,7908,507,40720,1538,3,68,1,1113.75,NULL,'2023-08-02 19:33:52','2023-08-02 19:33:52',NULL),(1859,7908,507,40720,1538,3,222,1,582.74,NULL,'2023-08-02 19:33:52','2023-08-02 19:33:52',NULL),(1860,7908,507,40720,1538,3,57,2,7000.06,NULL,'2023-08-02 19:33:52','2023-08-02 19:33:52',NULL),(1861,7908,508,40720,1538,3,217,1,2380.42,NULL,'2023-08-02 19:36:01','2023-08-02 19:36:01',NULL),(1862,7908,508,40720,1538,3,68,1,499.89,NULL,'2023-08-02 19:36:01','2023-08-02 19:36:01',NULL),(1863,7908,508,40720,1538,3,222,1,124.10,NULL,'2023-08-02 19:36:01','2023-08-02 19:36:01',NULL),(1864,7908,508,40720,1538,3,57,2,3004.41,NULL,'2023-08-02 19:36:01','2023-08-02 19:36:01',NULL),(1865,7908,509,40720,1538,3,217,1,1652.89,NULL,'2023-08-02 19:40:19','2023-08-02 19:40:19',NULL),(1866,7908,509,40720,1538,3,68,1,347.11,NULL,'2023-08-02 19:40:19','2023-08-02 19:40:19',NULL),(1867,7908,509,40720,1538,3,57,2,2000.00,NULL,'2023-08-02 19:40:19','2023-08-02 19:40:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1868,7908,510,40720,1538,15,67,1,921570.30,NULL,'2023-08-02 19:42:05','2023-08-02 19:44:25','2023-08-02 19:44:25'),(1869,7908,510,40720,1538,15,68,2,889149.97,NULL,'2023-08-02 19:42:05','2023-08-02 19:44:25','2023-08-02 19:44:25'),(1870,7908,510,40720,1538,15,354,2,25036.95,NULL,'2023-08-02 19:42:05','2023-08-02 19:44:25','2023-08-02 19:44:25'),(1871,7908,510,40720,1538,15,74,2,7383.38,NULL,'2023-08-02 19:42:05','2023-08-02 19:44:25','2023-08-02 19:44:25'),(1872,7908,511,40720,1538,2,96,2,278813.80,NULL,'2023-08-02 19:50:18','2023-08-02 19:50:18',NULL),(1873,7908,511,40720,1538,2,67,2,29275.45,NULL,'2023-08-02 19:50:18','2023-08-02 19:50:18',NULL),(1874,7908,511,40720,1538,2,13,1,308089.25,NULL,'2023-08-02 19:50:18','2023-08-02 19:50:18',NULL),(1875,7908,512,40720,1538,7,25,1,19516.97,NULL,'2023-08-02 19:57:04','2023-08-02 19:57:04',NULL),(1876,7908,512,40720,1538,7,13,2,19516.97,NULL,'2023-08-02 19:57:04','2023-08-02 19:57:04',NULL),(1877,7908,513,40720,1538,15,67,1,950845.75,NULL,'2023-08-02 19:58:14','2023-08-02 19:58:14',NULL),(1878,7908,513,40720,1538,15,68,2,889149.97,NULL,'2023-08-02 19:58:14','2023-08-02 19:58:14',NULL),(1879,7908,513,40720,1538,15,354,2,25036.95,NULL,'2023-08-02 19:58:14','2023-08-02 19:58:14',NULL),(1880,7908,513,40720,1538,15,25,2,19516.97,NULL,'2023-08-02 19:58:14','2023-08-02 19:58:14',NULL),(1881,7908,513,40720,1538,15,74,2,17141.86,NULL,'2023-08-02 19:58:14','2023-08-02 19:58:14',NULL),(1882,7908,514,40720,1540,2,96,2,8367772.50,NULL,'2023-08-04 13:55:20','2023-08-04 13:55:20',NULL),(1883,7908,514,40720,1540,2,67,2,1757232.23,NULL,'2023-08-04 13:55:20','2023-08-04 13:55:20',NULL),(1884,7908,514,40720,1540,2,13,1,10125004.73,NULL,'2023-08-04 13:55:20','2023-08-04 13:55:20',NULL),(1885,7908,515,40720,1539,2,96,1,3300000.00,NULL,'2023-08-09 18:39:22','2023-08-09 19:04:06','2023-08-09 19:04:06'),(1886,7908,515,40720,1539,2,68,1,693000.00,NULL,'2023-08-09 18:39:22','2023-08-09 19:04:06','2023-08-09 19:04:06'),(1887,7908,515,40720,1539,2,13,2,3993000.00,NULL,'2023-08-09 18:39:22','2023-08-09 19:04:06','2023-08-09 19:04:06'),(1888,7908,516,40720,1539,2,96,2,298471.89,NULL,'2023-08-09 19:17:11','2023-08-09 19:43:19','2023-08-09 19:43:19'),(1889,7908,516,40720,1539,2,67,2,31339.55,NULL,'2023-08-09 19:17:11','2023-08-09 19:43:19','2023-08-09 19:43:19'),(1890,7908,516,40720,1539,2,13,1,329811.44,NULL,'2023-08-09 19:17:11','2023-08-09 19:43:19','2023-08-09 19:43:19'),(1891,7908,517,40720,1539,7,25,1,20893.03,NULL,'2023-08-09 19:20:20','2023-08-09 19:20:20',NULL),(1892,7908,517,40720,1539,7,13,2,20893.03,NULL,'2023-08-09 19:20:20','2023-08-09 19:20:20',NULL),(1893,7908,518,40720,1539,3,217,1,1300000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:42:04','2023-08-09 19:42:04'),(1894,7908,518,40720,1539,3,68,1,273000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:42:04','2023-08-09 19:42:04'),(1895,7908,518,40720,1539,3,57,2,1573000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:42:04','2023-08-09 19:42:04'),(1896,7908,519,40720,1539,3,217,1,2000000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:41:46','2023-08-09 19:41:46'),(1897,7908,519,40720,1539,3,68,1,420000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:41:46','2023-08-09 19:41:46'),(1898,7908,519,40720,1539,3,57,2,2420000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:41:46','2023-08-09 19:41:46'),(1899,7908,520,40720,1539,3,217,2,3300000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:36:36','2023-08-09 19:36:36'),(1900,7908,520,40720,1539,3,67,2,693000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:36:36','2023-08-09 19:36:36'),(1901,7908,520,40720,1539,3,57,1,3993000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:36:36','2023-08-09 19:36:36'),(1902,7908,521,40720,1539,3,217,1,376093.94,NULL,'2023-08-09 19:25:30','2023-08-09 19:34:35','2023-08-09 19:34:35'),(1903,7908,521,40720,1539,3,68,1,78980.27,NULL,'2023-08-09 19:25:30','2023-08-09 19:34:35','2023-08-09 19:34:35'),(1904,7908,521,40720,1539,3,217,1,9.94,NULL,'2023-08-09 19:25:30','2023-08-09 19:34:35','2023-08-09 19:34:35');
INSERT INTO `balance_libro_details` VALUES (1905,7908,521,40720,1539,3,57,2,457892.19,NULL,'2023-08-09 19:25:30','2023-08-09 19:34:35','2023-08-09 19:34:35'),(1906,7908,521,40720,1539,3,136,1,2808.04,NULL,'2023-08-09 19:25:30','2023-08-09 19:34:35','2023-08-09 19:34:35'),(1907,7908,522,40720,1539,3,217,1,4958.68,NULL,'2023-08-09 19:25:30','2023-08-09 19:25:30',NULL),(1908,7908,522,40720,1539,3,68,1,1041.32,NULL,'2023-08-09 19:25:30','2023-08-09 19:25:30',NULL),(1909,7908,522,40720,1539,3,57,2,6000.00,NULL,'2023-08-09 19:25:30','2023-08-09 19:25:30',NULL),(1910,7908,523,40720,1539,3,217,1,376093.94,NULL,'2023-08-09 19:34:35','2023-08-09 19:34:35',NULL),(1911,7908,523,40720,1539,3,68,1,78979.73,NULL,'2023-08-09 19:34:35','2023-08-09 19:34:35',NULL),(1912,7908,523,40720,1539,3,57,2,455073.67,NULL,'2023-08-09 19:34:35','2023-08-09 19:34:35',NULL),(1913,7908,524,40720,1539,3,217,1,37601600.00,NULL,'2023-08-09 19:34:56','2024-04-23 20:32:18','2024-04-23 20:32:18'),(1914,7908,524,40720,1539,3,68,1,3948168.00,NULL,'2023-08-09 19:34:56','2024-04-23 20:32:18','2024-04-23 20:32:18'),(1915,7908,524,40720,1539,3,57,2,41549768.00,NULL,'2023-08-09 19:34:56','2024-04-23 20:32:18','2024-04-23 20:32:18'),(1916,7908,525,40720,1539,3,217,1,279918.92,NULL,'2023-08-09 19:35:13','2023-08-09 19:35:13',NULL),(1917,7908,525,40720,1539,3,68,1,58782.97,NULL,'2023-08-09 19:35:13','2023-08-09 19:35:13',NULL),(1918,7908,525,40720,1539,3,57,2,338701.89,NULL,'2023-08-09 19:35:13','2023-08-09 19:35:13',NULL),(1919,7908,526,40720,1539,3,217,1,192836.00,NULL,'2023-08-09 19:35:35','2023-08-09 19:35:35',NULL),(1920,7908,526,40720,1539,3,68,1,40495.56,NULL,'2023-08-09 19:35:35','2023-08-09 19:35:35',NULL),(1921,7908,526,40720,1539,3,57,2,233331.56,NULL,'2023-08-09 19:35:35','2023-08-09 19:35:35',NULL),(1922,7908,527,40720,1539,3,217,1,377211.64,NULL,'2023-08-09 19:35:54','2023-08-09 19:35:54',NULL),(1923,7908,527,40720,1539,3,68,1,79214.44,NULL,'2023-08-09 19:35:54','2023-08-09 19:35:54',NULL),(1924,7908,527,40720,1539,3,57,2,456426.08,NULL,'2023-08-09 19:35:54','2023-08-09 19:35:54',NULL),(1925,7908,528,40720,1539,3,217,1,2227483.00,NULL,'2023-08-09 19:36:14','2023-08-09 19:36:14',NULL),(1926,7908,528,40720,1539,3,68,1,467771.43,NULL,'2023-08-09 19:36:14','2023-08-09 19:36:14',NULL),(1927,7908,528,40720,1539,3,57,2,2695254.43,NULL,'2023-08-09 19:36:14','2023-08-09 19:36:14',NULL),(1928,7908,529,40720,1539,2,96,2,298471.89,NULL,'2023-08-09 19:43:19','2023-08-09 19:43:19',NULL),(1929,7908,529,40720,1539,2,67,2,31339.55,NULL,'2023-08-09 19:43:19','2023-08-09 19:43:19',NULL),(1930,7908,529,40720,1539,2,13,1,329811.44,NULL,'2023-08-09 19:43:19','2023-08-09 19:43:19',NULL),(1931,7908,530,40720,1539,3,217,1,21716.47,NULL,'2023-08-15 20:47:04','2023-08-15 20:47:04',NULL),(1932,7908,530,40720,1539,3,68,1,4560.46,NULL,'2023-08-15 20:47:04','2023-08-15 20:47:04',NULL),(1933,7908,530,40720,1539,3,222,1,1726.26,NULL,'2023-08-15 20:47:04','2023-08-15 20:47:04',NULL),(1934,7908,530,40720,1539,3,57,2,28003.19,NULL,'2023-08-15 20:47:04','2023-08-15 20:47:04',NULL),(1935,7908,531,40720,1539,3,217,1,11635.14,NULL,'2023-08-15 20:48:13','2023-08-15 20:48:13',NULL),(1936,7908,531,40720,1539,3,68,1,2443.38,NULL,'2023-08-15 20:48:13','2023-08-15 20:48:13',NULL),(1937,7908,531,40720,1539,3,222,1,924.88,NULL,'2023-08-15 20:48:13','2023-08-15 20:48:13',NULL),(1938,7908,531,40720,1539,3,57,2,15003.40,NULL,'2023-08-15 20:48:13','2023-08-15 20:48:13',NULL),(1939,7908,532,40720,1539,3,217,1,3803.03,NULL,'2023-08-15 20:49:36','2023-08-15 20:49:36',NULL),(1940,7908,532,40720,1539,3,68,1,798.64,NULL,'2023-08-15 20:49:36','2023-08-15 20:49:36',NULL),(1941,7908,532,40720,1539,3,222,1,398.25,NULL,'2023-08-15 20:49:36','2023-08-15 20:49:36',NULL),(1942,7908,532,40720,1539,3,57,2,4999.92,NULL,'2023-08-15 20:49:36','2023-08-15 20:49:36',NULL),(1943,7908,533,40720,1539,3,217,1,19395.72,NULL,'2023-08-15 20:50:53','2023-08-15 20:50:53',NULL),(1944,7908,533,40720,1539,3,68,1,4073.10,NULL,'2023-08-15 20:50:53','2023-08-15 20:50:53',NULL);
INSERT INTO `balance_libro_details` VALUES (1945,7908,533,40720,1539,3,222,1,1541.78,NULL,'2023-08-15 20:50:53','2023-08-15 20:50:53',NULL),(1946,7908,533,40720,1539,3,57,2,25010.60,NULL,'2023-08-15 20:50:53','2023-08-15 20:50:53',NULL),(1947,7908,534,40720,1539,3,217,1,2972.05,NULL,'2023-08-15 20:51:51','2023-08-15 20:51:51',NULL),(1948,7908,534,40720,1539,3,68,1,624.13,NULL,'2023-08-15 20:51:51','2023-08-15 20:51:51',NULL),(1949,7908,534,40720,1539,3,222,1,405.53,NULL,'2023-08-15 20:51:51','2023-08-15 20:51:51',NULL),(1950,7908,534,40720,1539,3,57,2,4001.71,NULL,'2023-08-15 20:51:51','2023-08-15 20:51:51',NULL),(1951,7908,535,40720,1539,3,217,1,6205.71,NULL,'2023-08-15 20:53:49','2023-08-15 20:53:49',NULL),(1952,7908,535,40720,1539,3,68,1,1303.20,NULL,'2023-08-15 20:53:49','2023-08-15 20:53:49',NULL),(1953,7908,535,40720,1539,3,222,1,493.30,NULL,'2023-08-15 20:53:49','2023-08-15 20:53:49',NULL),(1954,7908,535,40720,1539,3,57,2,8002.21,NULL,'2023-08-15 20:53:49','2023-08-15 20:53:49',NULL),(1955,7908,536,40720,1539,3,217,1,11638.47,NULL,'2023-08-15 20:54:42','2023-08-15 20:54:42',NULL),(1956,7908,536,40720,1539,3,68,1,2444.08,NULL,'2023-08-15 20:54:42','2023-08-15 20:54:42',NULL),(1957,7908,536,40720,1539,3,222,1,925.15,NULL,'2023-08-15 20:54:42','2023-08-15 20:54:42',NULL),(1958,7908,536,40720,1539,3,57,2,15007.70,NULL,'2023-08-15 20:54:42','2023-08-15 20:54:42',NULL),(1959,7908,537,40720,1539,3,217,1,3803.03,NULL,'2023-08-15 20:57:04','2023-08-15 20:57:04',NULL),(1960,7908,537,40720,1539,3,68,1,798.64,NULL,'2023-08-15 20:57:04','2023-08-15 20:57:04',NULL),(1961,7908,537,40720,1539,3,222,1,398.25,NULL,'2023-08-15 20:57:04','2023-08-15 20:57:04',NULL),(1962,7908,537,40720,1539,3,57,2,4999.92,NULL,'2023-08-15 20:57:04','2023-08-15 20:57:04',NULL),(1963,7908,538,40720,1539,3,217,1,3889.37,NULL,'2023-08-15 20:59:01','2023-08-15 20:59:01',NULL),(1964,7908,538,40720,1539,3,68,1,816.77,NULL,'2023-08-15 20:59:01','2023-08-15 20:59:01',NULL),(1965,7908,538,40720,1539,3,222,1,309.17,NULL,'2023-08-15 20:59:01','2023-08-15 20:59:01',NULL),(1966,7908,538,40720,1539,3,57,2,5015.31,NULL,'2023-08-15 20:59:01','2023-08-15 20:59:01',NULL),(1967,7908,539,40720,1539,3,217,1,6289.20,NULL,'2023-08-15 21:00:03','2023-08-15 21:00:03',NULL),(1968,7908,539,40720,1539,3,68,1,1320.73,NULL,'2023-08-15 21:00:03','2023-08-15 21:00:03',NULL),(1969,7908,539,40720,1539,3,222,1,391.98,NULL,'2023-08-15 21:00:03','2023-08-15 21:00:03',NULL),(1970,7908,539,40720,1539,3,57,2,8001.91,NULL,'2023-08-15 21:00:03','2023-08-15 21:00:03',NULL),(1971,7908,540,40720,1539,3,217,1,17010.90,NULL,'2023-08-15 21:01:07','2023-08-15 21:01:07',NULL),(1972,7908,540,40720,1539,3,68,1,3572.29,NULL,'2023-08-15 21:01:07','2023-08-15 21:01:07',NULL),(1973,7908,540,40720,1539,3,222,1,1417.42,NULL,'2023-08-15 21:01:07','2023-08-15 21:01:07',NULL),(1974,7908,540,40720,1539,3,57,2,22000.61,NULL,'2023-08-15 21:01:07','2023-08-15 21:01:07',NULL),(1975,7908,541,40720,1539,3,217,1,9281.13,NULL,'2023-08-15 21:02:09','2023-08-15 21:02:09',NULL),(1976,7908,541,40720,1539,3,68,1,1949.04,NULL,'2023-08-15 21:02:09','2023-08-15 21:02:09',NULL),(1977,7908,541,40720,1539,3,222,1,773.34,NULL,'2023-08-15 21:02:09','2023-08-15 21:02:09',NULL),(1978,7908,541,40720,1539,3,57,2,12003.51,NULL,'2023-08-15 21:02:09','2023-08-15 21:02:09',NULL),(1979,7908,542,40720,1539,3,217,1,3409.44,NULL,'2023-08-15 21:03:48','2023-08-15 21:03:48',NULL),(1980,7908,542,40720,1539,3,68,1,715.98,NULL,'2023-08-15 21:03:48','2023-08-15 21:03:48',NULL),(1981,7908,542,40720,1539,3,222,1,374.62,NULL,'2023-08-15 21:03:48','2023-08-15 21:03:48',NULL),(1982,7908,542,40720,1539,3,57,2,4500.04,NULL,'2023-08-15 21:03:48','2023-08-15 21:03:48',NULL),(1983,7908,543,40720,1539,3,217,1,7606.29,NULL,'2023-08-15 21:04:57','2023-08-15 21:04:57',NULL),(1984,7908,543,40720,1539,3,68,1,1597.32,NULL,'2023-08-15 21:04:57','2023-08-15 21:04:57',NULL),(1985,7908,543,40720,1539,3,222,1,796.53,NULL,'2023-08-15 21:04:57','2023-08-15 21:04:57',NULL);
INSERT INTO `balance_libro_details` VALUES (1986,7908,543,40720,1539,3,57,2,10000.14,NULL,'2023-08-15 21:04:57','2023-08-15 21:04:57',NULL),(1987,7908,544,40720,1539,3,217,1,6084.94,NULL,'2023-08-15 21:07:08','2023-08-15 21:07:08',NULL),(1988,7908,544,40720,1539,3,68,1,1277.84,NULL,'2023-08-15 21:07:08','2023-08-15 21:07:08',NULL),(1989,7908,544,40720,1539,3,222,1,637.22,NULL,'2023-08-15 21:07:08','2023-08-15 21:07:08',NULL),(1990,7908,544,40720,1539,3,57,2,8000.00,NULL,'2023-08-15 21:07:08','2023-08-15 21:07:08',NULL),(1991,7908,545,40720,1539,3,217,1,3051.64,NULL,'2023-08-15 21:10:07','2023-08-15 21:10:07',NULL),(1992,7908,545,40720,1539,3,68,1,640.84,NULL,'2023-08-15 21:10:07','2023-08-15 21:10:07',NULL),(1993,7908,545,40720,1539,3,222,1,309.55,NULL,'2023-08-15 21:10:07','2023-08-15 21:10:07',NULL),(1994,7908,545,40720,1539,3,57,2,4002.03,NULL,'2023-08-15 21:10:07','2023-08-15 21:10:07',NULL),(1995,7908,546,40720,1539,3,217,1,8003.16,NULL,'2023-08-15 21:11:31','2023-08-15 21:11:31',NULL),(1996,7908,546,40720,1539,3,68,1,1680.66,NULL,'2023-08-15 21:11:31','2023-08-15 21:11:31',NULL),(1997,7908,546,40720,1539,3,222,1,316.69,NULL,'2023-08-15 21:11:31','2023-08-15 21:11:31',NULL),(1998,7908,546,40720,1539,3,57,2,10000.51,NULL,'2023-08-15 21:11:31','2023-08-15 21:11:31',NULL),(1999,7908,547,40720,1539,3,217,1,8006.27,NULL,'2023-08-15 21:12:24','2023-08-15 21:12:24',NULL),(2000,7908,547,40720,1539,3,68,1,1681.32,NULL,'2023-08-15 21:12:24','2023-08-15 21:12:24',NULL),(2001,7908,547,40720,1539,3,222,1,316.81,NULL,'2023-08-15 21:12:24','2023-08-15 21:12:24',NULL),(2002,7908,547,40720,1539,3,57,2,10004.40,NULL,'2023-08-15 21:12:24','2023-08-15 21:12:24',NULL),(2003,7908,548,40720,1539,3,217,1,3030.61,NULL,'2023-08-15 21:13:46','2023-08-15 21:13:46',NULL),(2004,7908,548,40720,1539,3,68,1,636.43,NULL,'2023-08-15 21:13:46','2023-08-15 21:13:46',NULL),(2005,7908,548,40720,1539,3,222,1,332.99,NULL,'2023-08-15 21:13:46','2023-08-15 21:13:46',NULL),(2006,7908,548,40720,1539,3,57,2,4000.03,NULL,'2023-08-15 21:13:46','2023-08-15 21:13:46',NULL),(2007,7908,549,40720,1539,3,217,1,3042.47,NULL,'2023-08-15 21:15:50','2023-08-15 21:15:50',NULL),(2008,7908,549,40720,1539,3,68,1,638.92,NULL,'2023-08-15 21:15:50','2023-08-15 21:15:50',NULL),(2009,7908,549,40720,1539,3,222,1,318.61,NULL,'2023-08-15 21:15:50','2023-08-15 21:15:50',NULL),(2010,7908,549,40720,1539,3,57,2,4000.00,NULL,'2023-08-15 21:15:50','2023-08-15 21:15:50',NULL),(2011,7908,550,40720,1539,3,217,1,785.12,NULL,'2023-08-15 21:24:56','2023-08-15 21:24:56',NULL),(2012,7908,550,40720,1539,3,68,1,164.88,NULL,'2023-08-15 21:24:56','2023-08-15 21:24:56',NULL),(2013,7908,550,40720,1539,3,57,2,950.00,NULL,'2023-08-15 21:24:56','2023-08-15 21:24:56',NULL),(2014,7908,551,40720,1539,15,67,1,4604480.78,NULL,'2023-08-22 12:35:27','2024-04-23 20:28:36','2024-04-23 20:28:36'),(2015,7908,551,40720,1539,15,68,2,4771073.90,NULL,'2023-08-22 12:35:27','2024-04-23 20:28:36','2024-04-23 20:28:36'),(2016,7908,551,40720,1539,15,25,2,20893.03,NULL,'2023-08-22 12:35:27','2024-04-23 20:28:36','2024-04-23 20:28:36'),(2017,7908,551,40720,1539,15,353,1,166593.12,NULL,'2023-08-22 12:35:27','2024-04-23 20:28:36','2024-04-23 20:28:36'),(2018,7908,551,40720,1539,15,354,1,20893.03,NULL,'2023-08-22 12:35:27','2024-04-23 20:28:36','2024-04-23 20:28:36'),(2019,7908,552,40720,1540,3,217,1,28137.38,NULL,'2023-08-24 13:14:21','2023-08-24 13:14:21',NULL),(2020,7908,552,40720,1540,3,68,1,5908.85,NULL,'2023-08-24 13:14:21','2023-08-24 13:14:21',NULL),(2021,7908,552,40720,1540,3,57,2,34046.23,NULL,'2023-08-24 13:14:21','2023-08-24 13:14:21',NULL),(2022,7908,553,40720,1540,3,217,1,76346.32,NULL,'2023-08-24 13:14:21','2023-08-24 13:15:39','2023-08-24 13:15:39'),(2023,7908,553,40720,1540,3,68,1,16032.73,NULL,'2023-08-24 13:14:21','2023-08-24 13:15:39','2023-08-24 13:15:39'),(2024,7908,553,40720,1540,3,217,1,572.60,NULL,'2023-08-24 13:14:21','2023-08-24 13:15:39','2023-08-24 13:15:39');
INSERT INTO `balance_libro_details` VALUES (2025,7908,553,40720,1540,3,57,2,92951.65,NULL,'2023-08-24 13:14:21','2023-08-24 13:15:39','2023-08-24 13:15:39'),(2026,7908,554,40720,1540,3,217,1,38801.65,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2027,7908,554,40720,1540,3,68,1,8148.35,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2028,7908,554,40720,1540,3,57,2,46950.00,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2029,7908,555,40720,1540,3,217,1,1493.12,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2030,7908,555,40720,1540,3,68,1,313.56,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2031,7908,555,40720,1540,3,57,2,1806.68,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2032,7908,556,40720,1540,3,217,1,17579.10,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2033,7908,556,40720,1540,3,68,1,3691.61,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2034,7908,556,40720,1540,3,57,2,21270.71,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2035,7908,557,40720,1540,3,217,1,2975.21,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2036,7908,557,40720,1540,3,68,1,624.79,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2037,7908,557,40720,1540,3,57,2,3600.00,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2038,7908,558,40720,1540,3,217,1,748760.33,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2039,7908,558,40720,1540,3,68,1,157239.67,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2040,7908,558,40720,1540,3,57,2,906000.00,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2041,7908,559,40720,1540,3,217,1,47923.72,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2042,7908,559,40720,1540,3,68,1,10063.98,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2043,7908,559,40720,1540,3,57,2,57987.70,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2044,7908,560,40720,1540,3,217,1,3062.84,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2045,7908,560,40720,1540,3,68,1,643.20,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2046,7908,560,40720,1540,3,57,2,3706.04,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2047,7908,561,40720,1540,3,217,1,8372.00,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2048,7908,561,40720,1540,3,68,1,1758.12,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2049,7908,561,40720,1540,3,57,2,10130.12,NULL,'2023-08-24 13:14:22','2023-08-24 13:14:22',NULL),(2050,7908,562,40720,1540,3,217,1,10343891.41,NULL,'2023-08-24 13:14:22','2023-08-24 13:15:14','2023-08-24 13:15:14'),(2051,7908,562,40720,1540,3,68,1,1086108.60,NULL,'2023-08-24 13:14:22','2023-08-24 13:15:14','2023-08-24 13:15:14'),(2052,7908,562,40720,1540,3,217,1,77579.19,NULL,'2023-08-24 13:14:22','2023-08-24 13:15:14','2023-08-24 13:15:14'),(2053,7908,562,40720,1540,3,57,2,11507579.20,NULL,'2023-08-24 13:14:22','2023-08-24 13:15:14','2023-08-24 13:15:14'),(2054,7908,563,40720,1540,3,217,1,10343891.41,NULL,'2023-08-24 13:15:14','2024-08-07 11:14:22','2024-08-07 11:14:22'),(2055,7908,563,40720,1540,3,68,1,1086108.60,NULL,'2023-08-24 13:15:14','2024-08-07 11:14:22','2024-08-07 11:14:22'),(2056,7908,563,40720,1540,3,57,2,11430000.01,NULL,'2023-08-24 13:15:14','2024-08-07 11:14:22','2024-08-07 11:14:22'),(2057,7908,564,40720,1540,3,217,1,76346.32,NULL,'2023-08-24 13:15:39','2023-08-24 13:15:39',NULL),(2058,7908,564,40720,1540,3,68,1,16032.73,NULL,'2023-08-24 13:15:39','2023-08-24 13:15:39',NULL),(2059,7908,564,40720,1540,3,57,2,92379.05,NULL,'2023-08-24 13:15:39','2023-08-24 13:15:39',NULL),(2060,7908,565,40720,1540,2,96,1,897922.80,NULL,'2023-08-24 13:25:37','2023-08-28 21:14:42','2023-08-28 21:14:42'),(2061,7908,565,40720,1540,2,68,1,94282.32,NULL,'2023-08-24 13:25:37','2023-08-28 21:14:42','2023-08-28 21:14:42'),(2062,7908,565,40720,1540,2,13,2,992205.12,NULL,'2023-08-24 13:25:37','2023-08-28 21:14:42','2023-08-28 21:14:42'),(2063,7908,566,40720,1541,2,96,2,11983475.00,NULL,'2023-09-01 19:32:56','2023-09-01 19:32:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2064,7908,566,40720,1541,2,67,2,2516529.75,NULL,'2023-09-01 19:32:56','2023-09-01 19:32:56',NULL),(2065,7908,566,40720,1541,2,13,1,14500004.75,NULL,'2023-09-01 19:32:56','2023-09-01 19:32:56',NULL),(2066,7908,567,40720,1540,3,217,1,8490.99,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2067,7908,567,40720,1540,3,68,1,1783.11,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2068,7908,567,40720,1540,3,57,2,10274.10,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2069,7908,568,40720,1540,3,217,1,1428000.00,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2070,7908,568,40720,1540,3,68,1,299880.00,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2071,7908,568,40720,1540,3,57,2,1727880.00,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2072,7908,569,40720,1540,3,217,1,4958.68,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2073,7908,569,40720,1540,3,68,1,1041.32,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2074,7908,569,40720,1540,3,57,2,6000.00,NULL,'2023-09-21 12:59:56','2023-09-21 12:59:56',NULL),(2075,7908,570,40720,1540,3,217,2,897922.80,NULL,'2023-09-21 13:13:39','2023-09-21 13:13:39',NULL),(2076,7908,570,40720,1540,3,67,2,94282.32,NULL,'2023-09-21 13:13:39','2023-09-21 13:13:39',NULL),(2077,7908,570,40720,1540,3,57,1,992205.12,NULL,'2023-09-21 13:13:39','2023-09-21 13:13:39',NULL),(2078,7908,571,40720,1541,3,217,1,5851.24,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2079,7908,571,40720,1541,3,68,1,1228.76,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2080,7908,571,40720,1541,3,57,2,7080.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2081,7908,572,40720,1541,3,217,1,35010.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:34','2023-09-21 19:06:34'),(2082,7908,572,40720,1541,3,68,1,7352.10,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:34','2023-09-21 19:06:34'),(2083,7908,572,40720,1541,3,217,1,0.75,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:34','2023-09-21 19:06:34'),(2084,7908,572,40720,1541,3,57,2,42624.68,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:34','2023-09-21 19:06:34'),(2085,7908,572,40720,1541,3,136,1,261.83,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:34','2023-09-21 19:06:34'),(2086,7908,573,40720,1541,3,217,1,16454.70,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:01','2023-09-21 19:06:01'),(2087,7908,573,40720,1541,3,68,1,3455.49,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:01','2023-09-21 19:06:01'),(2088,7908,573,40720,1541,3,217,1,0.35,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:01','2023-09-21 19:06:01'),(2089,7908,573,40720,1541,3,57,2,20032.72,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:01','2023-09-21 19:06:01'),(2090,7908,573,40720,1541,3,136,1,122.18,NULL,'2023-09-21 19:04:11','2023-09-21 19:06:01','2023-09-21 19:06:01'),(2091,7908,574,40720,1541,3,217,1,6048000.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:05:35','2023-09-21 19:05:35'),(2092,7908,574,40720,1541,3,68,1,635040.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:05:35','2023-09-21 19:05:35'),(2093,7908,574,40720,1541,3,217,1,129.60,NULL,'2023-09-21 19:04:11','2023-09-21 19:05:35','2023-09-21 19:05:35'),(2094,7908,574,40720,1541,3,57,2,6728400.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:05:35','2023-09-21 19:05:35'),(2095,7908,574,40720,1541,3,136,1,45230.40,NULL,'2023-09-21 19:04:11','2023-09-21 19:05:35','2023-09-21 19:05:35'),(2096,7908,575,40720,1541,3,217,1,3924.35,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2097,7908,575,40720,1541,3,68,1,824.11,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2098,7908,575,40720,1541,3,57,2,4748.46,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2099,7908,576,40720,1541,3,217,1,5000.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2100,7908,576,40720,1541,3,68,1,1050.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2101,7908,576,40720,1541,3,57,2,6050.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL);
INSERT INTO `balance_libro_details` VALUES (2102,7908,577,40720,1541,3,217,1,6179.32,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2103,7908,577,40720,1541,3,68,1,1297.66,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2104,7908,577,40720,1541,3,57,2,7476.98,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2105,7908,578,40720,1541,3,217,1,30000.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2106,7908,578,40720,1541,3,68,1,6300.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2107,7908,578,40720,1541,3,57,2,36300.00,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2108,7908,579,40720,1541,3,217,1,1307.26,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2109,7908,579,40720,1541,3,68,1,274.52,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2110,7908,579,40720,1541,3,57,2,1581.78,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2111,7908,580,40720,1541,3,217,1,8163.82,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2112,7908,580,40720,1541,3,68,1,1714.40,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2113,7908,580,40720,1541,3,57,2,9878.22,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2114,7908,581,40720,1541,3,217,1,18105.74,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2115,7908,581,40720,1541,3,68,1,3802.20,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2116,7908,581,40720,1541,3,57,2,21907.94,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2117,7908,582,40720,1541,3,217,1,7809.55,NULL,'2023-09-21 19:04:11','2023-09-21 19:04:11',NULL),(2118,7908,582,40720,1541,3,68,1,1640.01,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2119,7908,582,40720,1541,3,57,2,9449.56,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2120,7908,583,40720,1541,3,217,1,2582.65,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2121,7908,583,40720,1541,3,68,1,542.36,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2122,7908,583,40720,1541,3,57,2,3125.01,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2123,7908,584,40720,1541,3,217,1,2801.65,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2124,7908,584,40720,1541,3,68,1,588.35,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2125,7908,584,40720,1541,3,57,2,3390.00,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2126,7908,585,40720,1541,3,217,1,4338.84,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2127,7908,585,40720,1541,3,68,1,911.16,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2128,7908,585,40720,1541,3,57,2,5250.00,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2129,7908,586,40720,1541,3,217,1,3719.01,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2130,7908,586,40720,1541,3,68,1,780.99,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2131,7908,586,40720,1541,3,57,2,4500.00,NULL,'2023-09-21 19:04:12','2023-09-21 19:04:12',NULL),(2132,7908,587,40720,1541,3,217,1,6048000.00,NULL,'2023-09-21 19:05:35','2023-09-21 19:06:57','2023-09-21 19:06:57'),(2133,7908,587,40720,1541,3,68,1,635040.00,NULL,'2023-09-21 19:05:35','2023-09-21 19:06:57','2023-09-21 19:06:57'),(2134,7908,587,40720,1541,3,57,2,6683040.00,NULL,'2023-09-21 19:05:35','2023-09-21 19:06:57','2023-09-21 19:06:57'),(2135,7908,588,40720,1541,3,217,1,16454.70,NULL,'2023-09-21 19:06:01','2023-09-21 19:07:18','2023-09-21 19:07:18'),(2136,7908,588,40720,1541,3,68,1,3455.49,NULL,'2023-09-21 19:06:01','2023-09-21 19:07:18','2023-09-21 19:07:18'),(2137,7908,588,40720,1541,3,57,2,19910.19,NULL,'2023-09-21 19:06:01','2023-09-21 19:07:18','2023-09-21 19:07:18'),(2138,7908,589,40720,1541,3,217,1,35010.00,NULL,'2023-09-21 19:06:34','2023-09-21 19:07:37','2023-09-21 19:07:37'),(2139,7908,589,40720,1541,3,68,1,7352.10,NULL,'2023-09-21 19:06:34','2023-09-21 19:07:37','2023-09-21 19:07:37'),(2140,7908,589,40720,1541,3,57,2,42362.10,NULL,'2023-09-21 19:06:34','2023-09-21 19:07:37','2023-09-21 19:07:37');
INSERT INTO `balance_libro_details` VALUES (2141,7908,590,40720,1541,3,217,1,6048000.00,NULL,'2023-09-21 19:06:57','2023-10-09 19:10:33','2023-10-09 19:10:33'),(2142,7908,590,40720,1541,3,68,1,635040.00,NULL,'2023-09-21 19:06:57','2023-10-09 19:10:33','2023-10-09 19:10:33'),(2143,7908,590,40720,1541,3,57,2,6683040.00,NULL,'2023-09-21 19:06:57','2023-10-09 19:10:33','2023-10-09 19:10:33'),(2144,7908,591,40720,1541,3,217,1,16454.70,NULL,'2023-09-21 19:07:18','2023-09-21 19:07:18',NULL),(2145,7908,591,40720,1541,3,68,1,3455.49,NULL,'2023-09-21 19:07:18','2023-09-21 19:07:18',NULL),(2146,7908,591,40720,1541,3,57,2,19910.19,NULL,'2023-09-21 19:07:18','2023-09-21 19:07:18',NULL),(2147,7908,592,40720,1541,3,217,1,35010.00,NULL,'2023-09-21 19:07:37','2023-10-09 19:11:00','2023-10-09 19:11:00'),(2148,7908,592,40720,1541,3,68,1,7352.10,NULL,'2023-09-21 19:07:37','2023-10-09 19:11:00','2023-10-09 19:11:00'),(2149,7908,592,40720,1541,3,57,2,42362.10,NULL,'2023-09-21 19:07:37','2023-10-09 19:11:00','2023-10-09 19:11:00'),(2150,7908,593,40720,1541,3,217,1,976896.00,NULL,'2023-09-26 18:22:07','2023-09-26 18:34:08','2023-09-26 18:34:08'),(2151,7908,593,40720,1541,3,68,1,205148.16,NULL,'2023-09-26 18:22:07','2023-09-26 18:34:08','2023-09-26 18:34:08'),(2152,7908,593,40720,1541,3,57,2,1182044.16,NULL,'2023-09-26 18:22:07','2023-09-26 18:34:08','2023-09-26 18:34:08'),(2153,7908,594,40720,1541,3,217,1,660543.00,NULL,'2023-09-26 18:22:07','2023-09-26 18:29:20','2023-09-26 18:29:20'),(2154,7908,594,40720,1541,3,68,1,138714.03,NULL,'2023-09-26 18:22:07','2023-09-26 18:29:20','2023-09-26 18:29:20'),(2155,7908,594,40720,1541,3,57,2,799257.03,NULL,'2023-09-26 18:22:07','2023-09-26 18:29:20','2023-09-26 18:29:20'),(2156,7908,595,40720,1541,3,217,1,681440.00,NULL,'2023-09-26 18:22:07','2023-09-26 18:28:14','2023-09-26 18:28:14'),(2157,7908,595,40720,1541,3,68,1,143102.40,NULL,'2023-09-26 18:22:07','2023-09-26 18:28:14','2023-09-26 18:28:14'),(2158,7908,595,40720,1541,3,57,2,824542.40,NULL,'2023-09-26 18:22:08','2023-09-26 18:28:14','2023-09-26 18:28:14'),(2159,7908,596,40720,1541,3,217,1,691657.00,NULL,'2023-09-26 18:22:08','2023-09-26 18:27:39','2023-09-26 18:27:39'),(2160,7908,596,40720,1541,3,68,1,145247.97,NULL,'2023-09-26 18:22:08','2023-09-26 18:27:39','2023-09-26 18:27:39'),(2161,7908,596,40720,1541,3,57,2,836904.97,NULL,'2023-09-26 18:22:08','2023-09-26 18:27:39','2023-09-26 18:27:39'),(2162,7908,597,40720,1541,3,217,1,692125.00,NULL,'2023-09-26 18:22:08','2023-09-26 18:26:50','2023-09-26 18:26:50'),(2163,7908,597,40720,1541,3,68,1,145346.25,NULL,'2023-09-26 18:22:08','2023-09-26 18:26:50','2023-09-26 18:26:50'),(2164,7908,597,40720,1541,3,57,2,837471.25,NULL,'2023-09-26 18:22:08','2023-09-26 18:26:50','2023-09-26 18:26:50'),(2165,7908,598,40720,1541,3,217,1,23140.50,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2166,7908,598,40720,1541,3,68,1,4859.50,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2167,7908,598,40720,1541,3,57,2,28000.00,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2168,7908,599,40720,1541,3,217,1,7703.62,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2169,7908,599,40720,1541,3,68,1,1617.76,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2170,7908,599,40720,1541,3,217,1,679.01,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2171,7908,599,40720,1541,3,57,2,10000.39,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2172,7908,600,40720,1541,3,217,1,3719.01,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2173,7908,600,40720,1541,3,68,1,780.99,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2174,7908,600,40720,1541,3,57,2,4500.00,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2175,7908,601,40720,1541,3,217,1,1059243.76,NULL,'2023-09-26 18:22:08','2023-09-26 18:32:03','2023-09-26 18:32:03'),(2176,7908,601,40720,1541,3,68,1,222441.19,NULL,'2023-09-26 18:22:08','2023-09-26 18:32:03','2023-09-26 18:32:03');
INSERT INTO `balance_libro_details` VALUES (2177,7908,601,40720,1541,3,57,2,1281684.95,NULL,'2023-09-26 18:22:08','2023-09-26 18:32:03','2023-09-26 18:32:03'),(2178,7908,602,40720,1541,3,217,1,498191.16,NULL,'2023-09-26 18:22:08','2023-10-09 19:10:05','2023-10-09 19:10:05'),(2179,7908,602,40720,1541,3,68,1,104619.44,NULL,'2023-09-26 18:22:08','2023-10-09 19:10:05','2023-10-09 19:10:05'),(2180,7908,602,40720,1541,3,217,1,10.67,NULL,'2023-09-26 18:22:08','2023-10-09 19:10:05','2023-10-09 19:10:05'),(2181,7908,602,40720,1541,3,57,2,606545.64,NULL,'2023-09-26 18:22:08','2023-10-09 19:10:05','2023-10-09 19:10:05'),(2182,7908,602,40720,1541,3,136,1,3724.37,NULL,'2023-09-26 18:22:08','2023-10-09 19:10:05','2023-10-09 19:10:05'),(2183,7908,603,40720,1541,3,217,1,16452.35,NULL,'2023-09-26 18:22:08','2023-10-09 19:09:26','2023-10-09 19:09:26'),(2184,7908,603,40720,1541,3,68,1,3454.99,NULL,'2023-09-26 18:22:08','2023-10-09 19:09:26','2023-10-09 19:09:26'),(2185,7908,603,40720,1541,3,217,1,0.35,NULL,'2023-09-26 18:22:08','2023-10-09 19:09:26','2023-10-09 19:09:26'),(2186,7908,603,40720,1541,3,57,2,20029.86,NULL,'2023-09-26 18:22:08','2023-10-09 19:09:26','2023-10-09 19:09:26'),(2187,7908,603,40720,1541,3,136,1,122.17,NULL,'2023-09-26 18:22:08','2023-10-09 19:09:26','2023-10-09 19:09:26'),(2188,7908,604,40720,1541,3,217,1,3719.01,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2189,7908,604,40720,1541,3,68,1,780.99,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2190,7908,604,40720,1541,3,57,2,4500.00,NULL,'2023-09-26 18:22:08','2023-09-26 18:22:08',NULL),(2191,7908,605,40720,1541,3,217,1,692125.00,NULL,'2023-09-26 18:26:50','2024-11-13 12:35:08','2024-11-13 12:35:08'),(2192,7908,605,40720,1541,3,68,1,145346.25,NULL,'2023-09-26 18:26:50','2024-11-13 12:35:08','2024-11-13 12:35:08'),(2193,7908,605,40720,1541,3,57,2,837471.25,NULL,'2023-09-26 18:26:50','2024-11-13 12:35:08','2024-11-13 12:35:08'),(2194,7908,606,40720,1541,3,217,1,691657.00,NULL,'2023-09-26 18:27:39','2024-11-13 12:35:58','2024-11-13 12:35:58'),(2195,7908,606,40720,1541,3,68,1,145247.97,NULL,'2023-09-26 18:27:39','2024-11-13 12:35:58','2024-11-13 12:35:58'),(2196,7908,606,40720,1541,3,57,2,836904.97,NULL,'2023-09-26 18:27:39','2024-11-13 12:35:58','2024-11-13 12:35:58'),(2197,7908,607,40720,1541,3,217,1,681440.00,NULL,'2023-09-26 18:28:14','2024-11-13 12:36:26','2024-11-13 12:36:26'),(2198,7908,607,40720,1541,3,68,1,143102.40,NULL,'2023-09-26 18:28:14','2024-11-13 12:36:26','2024-11-13 12:36:26'),(2199,7908,607,40720,1541,3,57,2,824542.40,NULL,'2023-09-26 18:28:14','2024-11-13 12:36:26','2024-11-13 12:36:26'),(2200,7908,608,40720,1541,3,217,1,660543.00,NULL,'2023-09-26 18:29:20','2024-11-13 12:37:05','2024-11-13 12:37:05'),(2201,7908,608,40720,1541,3,68,1,138714.03,NULL,'2023-09-26 18:29:20','2024-11-13 12:37:05','2024-11-13 12:37:05'),(2202,7908,608,40720,1541,3,57,2,799257.03,NULL,'2023-09-26 18:29:20','2024-11-13 12:37:05','2024-11-13 12:37:05'),(2203,7908,609,40720,1541,3,217,1,1059243.76,NULL,'2023-09-26 18:32:03','2024-11-13 12:32:06','2024-11-13 12:32:06'),(2204,7908,609,40720,1541,3,68,1,222441.19,NULL,'2023-09-26 18:32:03','2024-11-13 12:32:06','2024-11-13 12:32:06'),(2205,7908,609,40720,1541,3,57,2,1281684.95,NULL,'2023-09-26 18:32:03','2024-11-13 12:32:06','2024-11-13 12:32:06'),(2206,7908,610,40720,1541,3,217,1,976896.00,NULL,'2023-09-26 18:34:08','2024-11-13 12:30:19','2024-11-13 12:30:19'),(2207,7908,610,40720,1541,3,68,1,205148.16,NULL,'2023-09-26 18:34:08','2024-11-13 12:30:19','2024-11-13 12:30:19'),(2208,7908,610,40720,1541,3,57,2,1182044.16,NULL,'2023-09-26 18:34:08','2024-11-13 12:30:19','2024-11-13 12:30:19'),(2209,7908,611,40720,1540,3,217,1,3852.30,NULL,'2023-09-26 18:37:00','2023-09-26 18:37:00',NULL),(2210,7908,611,40720,1540,3,68,1,808.98,NULL,'2023-09-26 18:37:00','2023-09-26 18:37:00',NULL),(2211,7908,611,40720,1540,3,222,1,338.74,NULL,'2023-09-26 18:37:00','2023-09-26 18:37:00',NULL),(2212,7908,611,40720,1540,3,57,2,5000.02,NULL,'2023-09-26 18:37:00','2023-09-26 18:37:00',NULL);
INSERT INTO `balance_libro_details` VALUES (2213,7908,612,40720,1540,3,217,1,7707.12,NULL,'2023-09-26 18:38:30','2023-09-26 18:38:30',NULL),(2214,7908,612,40720,1540,3,68,1,1618.50,NULL,'2023-09-26 18:38:30','2023-09-26 18:38:30',NULL),(2215,7908,612,40720,1540,3,222,1,677.70,NULL,'2023-09-26 18:38:30','2023-09-26 18:38:30',NULL),(2216,7908,612,40720,1540,3,57,2,10003.32,NULL,'2023-09-26 18:38:30','2023-09-26 18:38:30',NULL),(2217,7908,613,40720,1540,3,217,1,24003.80,NULL,'2023-09-26 18:39:41','2023-09-26 18:39:41',NULL),(2218,7908,613,40720,1540,3,68,1,5040.80,NULL,'2023-09-26 18:39:41','2023-09-26 18:39:41',NULL),(2219,7908,613,40720,1540,3,222,1,958.64,NULL,'2023-09-26 18:39:41','2023-09-26 18:39:41',NULL),(2220,7908,613,40720,1540,3,57,2,30003.24,NULL,'2023-09-26 18:39:41','2023-09-26 18:39:41',NULL),(2221,7908,614,40720,1540,3,217,1,8065.63,NULL,'2023-09-26 18:41:04','2023-09-26 18:41:04',NULL),(2222,7908,614,40720,1540,3,68,1,1693.78,NULL,'2023-09-26 18:41:04','2023-09-26 18:41:04',NULL),(2223,7908,614,40720,1540,3,222,1,240.88,NULL,'2023-09-26 18:41:04','2023-09-26 18:41:04',NULL),(2224,7908,614,40720,1540,3,57,2,10000.29,NULL,'2023-09-26 18:41:04','2023-09-26 18:41:04',NULL),(2225,7908,615,40720,1540,3,217,1,10662.90,NULL,'2023-09-26 18:42:07','2023-09-26 18:42:07',NULL),(2226,7908,615,40720,1540,3,68,1,2239.21,NULL,'2023-09-26 18:42:07','2023-09-26 18:42:07',NULL),(2227,7908,615,40720,1540,3,222,1,702.21,NULL,'2023-09-26 18:42:07','2023-09-26 18:42:07',NULL),(2228,7908,615,40720,1540,3,57,2,13604.32,NULL,'2023-09-26 18:42:07','2023-09-26 18:42:07',NULL),(2229,7908,616,40720,1540,3,217,1,11703.74,NULL,'2023-09-26 18:43:28','2023-09-26 18:43:28',NULL),(2230,7908,616,40720,1540,3,68,1,2457.79,NULL,'2023-09-26 18:43:28','2023-09-26 18:43:28',NULL),(2231,7908,616,40720,1540,3,222,1,850.99,NULL,'2023-09-26 18:43:28','2023-09-26 18:43:28',NULL),(2232,7908,616,40720,1540,3,57,2,15012.52,NULL,'2023-09-26 18:43:28','2023-09-26 18:43:28',NULL),(2233,7908,617,40720,1540,3,217,1,9355.97,NULL,'2023-09-26 18:44:27','2023-09-26 18:44:27',NULL),(2234,7908,617,40720,1540,3,68,1,1964.75,NULL,'2023-09-26 18:44:27','2023-09-26 18:44:27',NULL),(2235,7908,617,40720,1540,3,222,1,680.29,NULL,'2023-09-26 18:44:27','2023-09-26 18:44:27',NULL),(2236,7908,617,40720,1540,3,57,2,12001.01,NULL,'2023-09-26 18:44:27','2023-09-26 18:44:27',NULL),(2237,7908,618,40720,1540,3,217,1,3818.23,NULL,'2023-09-26 18:49:17','2023-09-26 18:49:17',NULL),(2238,7908,618,40720,1540,3,68,1,801.83,NULL,'2023-09-26 18:49:17','2023-09-26 18:49:17',NULL),(2239,7908,618,40720,1540,3,222,1,381.14,NULL,'2023-09-26 18:49:17','2023-09-26 18:49:17',NULL),(2240,7908,618,40720,1540,3,57,2,5001.20,NULL,'2023-09-26 18:49:17','2023-09-26 18:49:17',NULL),(2241,7908,619,40720,1540,3,217,1,5556.36,NULL,'2023-09-26 18:50:19','2023-09-26 18:50:19',NULL),(2242,7908,619,40720,1540,3,68,1,1166.84,NULL,'2023-09-26 18:50:19','2023-09-26 18:50:19',NULL),(2243,7908,619,40720,1540,3,222,1,279.20,NULL,'2023-09-26 18:50:19','2023-09-26 18:50:19',NULL),(2244,7908,619,40720,1540,3,57,2,7002.40,NULL,'2023-09-26 18:50:19','2023-09-26 18:50:19',NULL),(2245,7908,620,40720,1540,3,217,1,7757.02,NULL,'2023-09-26 18:51:36','2023-09-26 18:51:36',NULL),(2246,7908,620,40720,1540,3,68,1,1628.97,NULL,'2023-09-26 18:51:36','2023-09-26 18:51:36',NULL),(2247,7908,620,40720,1540,3,222,1,616.61,NULL,'2023-09-26 18:51:36','2023-09-26 18:51:36',NULL),(2248,7908,620,40720,1540,3,57,2,10002.60,NULL,'2023-09-26 18:51:36','2023-09-26 18:51:36',NULL),(2249,7908,621,40720,1540,3,217,1,2864.92,NULL,'2023-09-26 18:54:56','2023-09-26 18:54:56',NULL),(2250,7908,621,40720,1540,3,68,1,601.63,NULL,'2023-09-26 18:54:56','2023-09-26 18:54:56',NULL),(2251,7908,621,40720,1540,3,57,2,3466.55,NULL,'2023-09-26 18:54:56','2023-09-26 18:54:56',NULL),(2252,7908,622,40720,1540,3,217,1,18181.82,NULL,'2023-09-26 18:58:40','2023-09-26 18:58:40',NULL),(2253,7908,622,40720,1540,3,68,1,3818.18,NULL,'2023-09-26 18:58:40','2023-09-26 18:58:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2254,7908,622,40720,1540,3,57,2,22000.00,NULL,'2023-09-26 18:58:40','2023-09-26 18:58:40',NULL),(2255,7908,623,40720,1540,3,217,1,19834.72,NULL,'2023-09-26 19:00:01','2023-09-26 19:00:01',NULL),(2256,7908,623,40720,1540,3,68,1,4165.29,NULL,'2023-09-26 19:00:01','2023-09-26 19:00:01',NULL),(2257,7908,623,40720,1540,3,57,2,24000.01,NULL,'2023-09-26 19:00:01','2023-09-26 19:00:01',NULL),(2258,7908,624,40720,1540,3,217,1,12000.91,NULL,'2023-09-27 19:07:25','2023-09-27 19:07:25',NULL),(2259,7908,624,40720,1540,3,68,1,2520.19,NULL,'2023-09-27 19:07:25','2023-09-27 19:07:25',NULL),(2260,7908,624,40720,1540,3,222,1,479.28,NULL,'2023-09-27 19:07:25','2023-09-27 19:07:25',NULL),(2261,7908,624,40720,1540,3,57,2,15000.38,NULL,'2023-09-27 19:07:25','2023-09-27 19:07:25',NULL),(2262,7908,625,40720,1540,3,217,1,8070.12,NULL,'2023-09-27 19:08:45','2023-09-27 19:08:45',NULL),(2263,7908,625,40720,1540,3,68,1,1694.73,NULL,'2023-09-27 19:08:45','2023-09-27 19:08:45',NULL),(2264,7908,625,40720,1540,3,222,1,241.02,NULL,'2023-09-27 19:08:45','2023-09-27 19:08:45',NULL),(2265,7908,625,40720,1540,3,57,2,10005.87,NULL,'2023-09-27 19:08:45','2023-09-27 19:08:45',NULL),(2266,7908,626,40720,1540,3,217,1,20002.44,NULL,'2023-09-27 19:09:35','2023-09-27 19:09:35',NULL),(2267,7908,626,40720,1540,3,68,1,4200.51,NULL,'2023-09-27 19:09:36','2023-09-27 19:09:36',NULL),(2268,7908,626,40720,1540,3,222,1,798.84,NULL,'2023-09-27 19:09:36','2023-09-27 19:09:36',NULL),(2269,7908,626,40720,1540,3,57,2,25001.79,NULL,'2023-09-27 19:09:36','2023-09-27 19:09:36',NULL),(2270,7908,627,40720,1540,3,217,1,8003.34,NULL,'2023-09-27 19:10:40','2023-09-27 19:10:40',NULL),(2271,7908,627,40720,1540,3,68,1,1680.70,NULL,'2023-09-27 19:10:40','2023-09-27 19:10:40',NULL),(2272,7908,627,40720,1540,3,222,1,319.63,NULL,'2023-09-27 19:10:40','2023-09-27 19:10:40',NULL),(2273,7908,627,40720,1540,3,57,2,10003.67,NULL,'2023-09-27 19:10:40','2023-09-27 19:10:40',NULL),(2274,7908,628,40720,1540,3,217,1,8028.83,NULL,'2023-09-27 19:13:19','2023-09-27 19:13:19',NULL),(2275,7908,628,40720,1540,3,68,1,1686.05,NULL,'2023-09-27 19:13:19','2023-09-27 19:13:19',NULL),(2276,7908,628,40720,1540,3,222,1,286.51,NULL,'2023-09-27 19:13:19','2023-09-27 19:13:19',NULL),(2277,7908,628,40720,1540,3,57,2,10001.39,NULL,'2023-09-27 19:13:19','2023-09-27 19:13:19',NULL),(2278,7908,629,40720,1540,3,217,1,18957.09,NULL,'2023-09-27 19:14:34','2023-09-27 19:14:34',NULL),(2279,7908,629,40720,1540,3,68,1,3980.99,NULL,'2023-09-27 19:14:34','2023-09-27 19:14:34',NULL),(2280,7908,629,40720,1540,3,222,1,1068.02,NULL,'2023-09-27 19:14:34','2023-09-27 19:14:34',NULL),(2281,7908,629,40720,1540,3,57,2,24006.10,NULL,'2023-09-27 19:14:34','2023-09-27 19:14:34',NULL),(2282,7908,630,40720,1540,3,217,1,15957.78,NULL,'2023-09-27 19:15:33','2023-09-27 19:15:33',NULL),(2283,7908,630,40720,1540,3,68,1,3351.13,NULL,'2023-09-27 19:15:33','2023-09-27 19:15:33',NULL),(2284,7908,630,40720,1540,3,222,1,695.33,NULL,'2023-09-27 19:15:33','2023-09-27 19:15:33',NULL),(2285,7908,630,40720,1540,3,57,2,20004.24,NULL,'2023-09-27 19:15:33','2023-09-27 19:15:33',NULL),(2286,7908,631,40720,1540,3,217,1,3209.66,NULL,'2023-09-27 19:16:35','2023-09-27 19:16:35',NULL),(2287,7908,631,40720,1540,3,68,1,674.03,NULL,'2023-09-27 19:16:35','2023-09-27 19:16:35',NULL),(2288,7908,631,40720,1540,3,222,1,119.77,NULL,'2023-09-27 19:16:35','2023-09-27 19:16:35',NULL),(2289,7908,631,40720,1540,3,57,2,4003.46,NULL,'2023-09-27 19:16:35','2023-09-27 19:16:35',NULL),(2290,7908,632,40720,1540,3,217,1,10774.64,NULL,'2023-09-27 19:17:24','2023-09-27 19:17:24',NULL),(2291,7908,632,40720,1540,3,68,1,2262.67,NULL,'2023-09-27 19:17:24','2023-09-27 19:17:24',NULL),(2292,7908,632,40720,1540,3,222,1,963.25,NULL,'2023-09-27 19:17:24','2023-09-27 19:17:24',NULL),(2293,7908,632,40720,1540,3,57,2,14000.56,NULL,'2023-09-27 19:17:24','2023-09-27 19:17:24',NULL),(2294,7908,633,40720,1540,3,217,1,32001.76,NULL,'2023-09-27 19:18:38','2023-09-27 19:18:38',NULL);
INSERT INTO `balance_libro_details` VALUES (2295,7908,633,40720,1540,3,68,1,6720.37,NULL,'2023-09-27 19:18:38','2023-09-27 19:18:38',NULL),(2296,7908,633,40720,1540,3,222,1,1278.06,NULL,'2023-09-27 19:18:38','2023-09-27 19:18:38',NULL),(2297,7908,633,40720,1540,3,57,2,40000.19,NULL,'2023-09-27 19:18:38','2023-09-27 19:18:38',NULL),(2298,7908,634,40720,1540,3,217,1,19943.02,NULL,'2023-09-27 19:20:07','2023-09-27 19:20:07',NULL),(2299,7908,634,40720,1540,3,68,1,4188.03,NULL,'2023-09-27 19:20:07','2023-09-27 19:20:07',NULL),(2300,7908,634,40720,1540,3,222,1,868.97,NULL,'2023-09-27 19:20:07','2023-09-27 19:20:07',NULL),(2301,7908,634,40720,1540,3,57,2,25000.02,NULL,'2023-09-27 19:20:07','2023-09-27 19:20:07',NULL),(2302,7908,635,40720,1540,3,217,1,12022.26,NULL,'2023-09-27 19:21:11','2023-09-27 19:21:11',NULL),(2303,7908,635,40720,1540,3,68,1,2524.67,NULL,'2023-09-27 19:21:11','2023-09-27 19:21:11',NULL),(2304,7908,635,40720,1540,3,222,1,458.34,NULL,'2023-09-27 19:21:11','2023-09-27 19:21:11',NULL),(2305,7908,635,40720,1540,3,57,2,15005.27,NULL,'2023-09-27 19:21:11','2023-09-27 19:21:11',NULL),(2306,7908,636,40720,1540,3,217,1,15957.79,NULL,'2023-09-27 19:22:27','2023-09-27 19:22:27',NULL),(2307,7908,636,40720,1540,3,68,1,3351.14,NULL,'2023-09-27 19:22:27','2023-09-27 19:22:27',NULL),(2308,7908,636,40720,1540,3,222,1,695.32,NULL,'2023-09-27 19:22:27','2023-09-27 19:22:27',NULL),(2309,7908,636,40720,1540,3,57,2,20004.25,NULL,'2023-09-27 19:22:27','2023-09-27 19:22:27',NULL),(2310,7908,637,40720,1540,3,217,1,7704.60,NULL,'2023-09-27 19:24:21','2023-09-27 19:24:21',NULL),(2311,7908,637,40720,1540,3,68,1,1617.97,NULL,'2023-09-27 19:24:21','2023-09-27 19:24:21',NULL),(2312,7908,637,40720,1540,3,222,1,677.48,NULL,'2023-09-27 19:24:21','2023-09-27 19:24:21',NULL),(2313,7908,637,40720,1540,3,57,2,10000.05,NULL,'2023-09-27 19:24:21','2023-09-27 19:24:21',NULL),(2314,7908,638,40720,1540,3,217,1,19344.79,NULL,'2023-09-27 19:41:02','2023-09-27 19:41:02',NULL),(2315,7908,638,40720,1540,3,68,1,4062.41,NULL,'2023-09-27 19:41:02','2023-09-27 19:41:02',NULL),(2316,7908,638,40720,1540,3,222,1,1594.39,NULL,'2023-09-27 19:41:02','2023-09-27 19:41:02',NULL),(2317,7908,638,40720,1540,3,57,2,25001.59,NULL,'2023-09-27 19:41:02','2023-09-27 19:41:02',NULL),(2318,7908,639,40720,1540,3,217,1,11610.09,NULL,'2023-09-27 19:42:09','2023-09-27 19:42:09',NULL),(2319,7908,639,40720,1540,3,68,1,2438.12,NULL,'2023-09-27 19:42:09','2023-09-27 19:42:09',NULL),(2320,7908,639,40720,1540,3,222,1,956.90,NULL,'2023-09-27 19:42:09','2023-09-27 19:42:09',NULL),(2321,7908,639,40720,1540,3,57,2,15005.11,NULL,'2023-09-27 19:42:09','2023-09-27 19:42:09',NULL),(2322,7908,640,40720,1540,3,217,1,3731.43,NULL,'2023-09-27 19:43:28','2023-09-27 19:43:28',NULL),(2323,7908,640,40720,1540,3,68,1,783.60,NULL,'2023-09-27 19:43:28','2023-09-27 19:43:28',NULL),(2324,7908,640,40720,1540,3,222,1,484.89,NULL,'2023-09-27 19:43:28','2023-09-27 19:43:28',NULL),(2325,7908,640,40720,1540,3,57,2,4999.92,NULL,'2023-09-27 19:43:28','2023-09-27 19:43:28',NULL),(2326,7908,641,40720,1542,2,96,2,17355375.00,NULL,'2023-10-04 19:53:40','2023-10-04 19:53:40',NULL),(2327,7908,641,40720,1542,2,67,2,3644628.75,NULL,'2023-10-04 19:53:40','2023-10-04 19:53:40',NULL),(2328,7908,641,40720,1542,2,13,1,21000003.75,NULL,'2023-10-04 19:53:40','2023-10-04 19:53:40',NULL),(2329,7908,642,40720,1541,3,217,1,9301.77,NULL,'2023-10-09 11:45:26','2023-10-09 11:45:26',NULL),(2330,7908,642,40720,1541,3,68,1,1953.37,NULL,'2023-10-09 11:45:26','2023-10-09 11:45:26',NULL),(2331,7908,642,40720,1541,3,222,1,743.15,NULL,'2023-10-09 11:45:26','2023-10-09 11:45:26',NULL),(2332,7908,642,40720,1541,3,57,2,11998.29,NULL,'2023-10-09 11:45:26','2023-10-09 11:45:26',NULL),(2333,7908,643,40720,1541,3,217,1,3860.38,NULL,'2023-10-09 11:47:16','2023-10-09 11:47:16',NULL),(2334,7908,643,40720,1541,3,68,1,810.68,NULL,'2023-10-09 11:47:16','2023-10-09 11:47:16',NULL),(2335,7908,643,40720,1541,3,222,1,393.22,NULL,'2023-10-09 11:47:16','2023-10-09 11:47:16',NULL);
INSERT INTO `balance_libro_details` VALUES (2336,7908,643,40720,1541,3,57,2,5064.28,NULL,'2023-10-09 11:47:16','2023-10-09 11:47:16',NULL),(2337,7908,644,40720,1541,3,217,1,214049.59,NULL,'2023-10-09 11:49:51','2023-10-09 11:49:51',NULL),(2338,7908,644,40720,1541,3,68,1,44950.41,NULL,'2023-10-09 11:49:51','2023-10-09 11:49:51',NULL),(2339,7908,644,40720,1541,3,57,2,259000.00,NULL,'2023-10-09 11:49:51','2023-10-09 11:49:51',NULL),(2340,7908,645,40720,1541,3,217,1,6163.78,NULL,'2023-10-09 11:51:12','2023-10-09 11:51:12',NULL),(2341,7908,645,40720,1541,3,68,1,1294.39,NULL,'2023-10-09 11:51:12','2023-10-09 11:51:12',NULL),(2342,7908,645,40720,1541,3,222,1,541.99,NULL,'2023-10-09 11:51:12','2023-10-09 11:51:12',NULL),(2343,7908,645,40720,1541,3,57,2,8000.16,NULL,'2023-10-09 11:51:12','2023-10-09 11:51:12',NULL),(2344,7908,646,40720,1541,3,217,1,3777.25,NULL,'2023-10-09 11:53:22','2023-10-09 11:53:22',NULL),(2345,7908,646,40720,1541,3,68,1,793.22,NULL,'2023-10-09 11:53:22','2023-10-09 11:53:22',NULL),(2346,7908,646,40720,1541,3,222,1,431.12,NULL,'2023-10-09 11:53:22','2023-10-09 11:53:22',NULL),(2347,7908,646,40720,1541,3,57,2,5001.59,NULL,'2023-10-09 11:53:22','2023-10-09 11:53:22',NULL),(2348,7908,647,40720,1541,3,217,1,23388.26,NULL,'2023-10-09 11:54:17','2023-10-09 11:54:17',NULL),(2349,7908,647,40720,1541,3,68,1,4911.53,NULL,'2023-10-09 11:54:17','2023-10-09 11:54:17',NULL),(2350,7908,647,40720,1541,3,222,1,1700.59,NULL,'2023-10-09 11:54:17','2023-10-09 11:54:17',NULL),(2351,7908,647,40720,1541,3,57,2,30000.38,NULL,'2023-10-09 11:54:18','2023-10-09 11:54:18',NULL),(2352,7908,648,40720,1541,3,217,1,11705.98,NULL,'2023-10-09 11:56:57','2023-10-09 11:56:57',NULL),(2353,7908,648,40720,1541,3,68,1,2458.26,NULL,'2023-10-09 11:56:57','2023-10-09 11:56:57',NULL),(2354,7908,648,40720,1541,3,222,1,851.16,NULL,'2023-10-09 11:56:57','2023-10-09 11:56:57',NULL),(2355,7908,648,40720,1541,3,57,2,15015.40,NULL,'2023-10-09 11:56:57','2023-10-09 11:56:57',NULL),(2356,7908,649,40720,1541,3,217,1,12000.91,NULL,'2023-10-09 11:58:10','2023-10-09 11:58:10',NULL),(2357,7908,649,40720,1541,3,68,1,2520.19,NULL,'2023-10-09 11:58:10','2023-10-09 11:58:10',NULL),(2358,7908,649,40720,1541,3,222,1,479.28,NULL,'2023-10-09 11:58:10','2023-10-09 11:58:10',NULL),(2359,7908,649,40720,1541,3,57,2,15000.38,NULL,'2023-10-09 11:58:10','2023-10-09 11:58:10',NULL),(2360,7908,650,40720,1541,3,217,1,16003.57,NULL,'2023-10-09 11:59:02','2023-10-09 11:59:02',NULL),(2361,7908,650,40720,1541,3,68,1,3360.75,NULL,'2023-10-09 11:59:02','2023-10-09 11:59:02',NULL),(2362,7908,650,40720,1541,3,222,1,639.14,NULL,'2023-10-09 11:59:02','2023-10-09 11:59:02',NULL),(2363,7908,650,40720,1541,3,57,2,20003.46,NULL,'2023-10-09 11:59:02','2023-10-09 11:59:02',NULL),(2364,7908,651,40720,1541,3,217,1,16004.71,NULL,'2023-10-09 11:59:56','2023-10-09 11:59:56',NULL),(2365,7908,651,40720,1541,3,68,1,3360.99,NULL,'2023-10-09 11:59:56','2023-10-09 11:59:56',NULL),(2366,7908,651,40720,1541,3,222,1,639.18,NULL,'2023-10-09 11:59:56','2023-10-09 11:59:56',NULL),(2367,7908,651,40720,1541,3,57,2,20004.88,NULL,'2023-10-09 11:59:56','2023-10-09 11:59:56',NULL),(2368,7908,652,40720,1541,3,217,1,8070.12,NULL,'2023-10-09 12:00:54','2023-10-09 12:00:54',NULL),(2369,7908,652,40720,1541,3,68,1,1694.73,NULL,'2023-10-09 12:00:54','2023-10-09 12:00:54',NULL),(2370,7908,652,40720,1541,3,222,1,241.02,NULL,'2023-10-09 12:00:54','2023-10-09 12:00:54',NULL),(2371,7908,652,40720,1541,3,57,2,10005.87,NULL,'2023-10-09 12:00:54','2023-10-09 12:00:54',NULL),(2372,7908,653,40720,1541,3,217,1,12102.94,NULL,'2023-10-09 12:03:13','2023-10-09 12:03:13',NULL),(2373,7908,653,40720,1541,3,68,1,2541.62,NULL,'2023-10-09 12:03:13','2023-10-09 12:03:13',NULL),(2374,7908,653,40720,1541,3,222,1,361.46,NULL,'2023-10-09 12:03:13','2023-10-09 12:03:13',NULL),(2375,7908,653,40720,1541,3,57,2,15006.02,NULL,'2023-10-09 12:03:13','2023-10-09 12:03:13',NULL),(2376,7908,654,40720,1541,3,217,1,24163.29,NULL,'2023-10-09 12:04:53','2023-10-09 12:04:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2377,7908,654,40720,1541,3,68,1,5074.29,NULL,'2023-10-09 12:04:53','2023-10-09 12:04:53',NULL),(2378,7908,654,40720,1541,3,222,1,965.02,NULL,'2023-10-09 12:04:53','2023-10-09 12:04:53',NULL),(2379,7908,654,40720,1541,3,57,2,30202.60,NULL,'2023-10-09 12:04:53','2023-10-09 12:04:53',NULL),(2380,7908,655,40720,1541,3,217,1,8001.36,NULL,'2023-10-09 12:07:08','2023-10-09 12:07:08',NULL),(2381,7908,655,40720,1541,3,68,1,1680.29,NULL,'2023-10-09 12:07:08','2023-10-09 12:07:08',NULL),(2382,7908,655,40720,1541,3,222,1,319.55,NULL,'2023-10-09 12:07:08','2023-10-09 12:07:08',NULL),(2383,7908,655,40720,1541,3,57,2,10001.20,NULL,'2023-10-09 12:07:08','2023-10-09 12:07:08',NULL),(2384,7908,656,40720,1541,3,217,1,4000.68,NULL,'2023-10-09 12:08:44','2023-10-09 12:08:44',NULL),(2385,7908,656,40720,1541,3,68,1,840.14,NULL,'2023-10-09 12:08:44','2023-10-09 12:08:44',NULL),(2386,7908,656,40720,1541,3,222,1,159.78,NULL,'2023-10-09 12:08:44','2023-10-09 12:08:44',NULL),(2387,7908,656,40720,1541,3,57,2,5000.60,NULL,'2023-10-09 12:08:44','2023-10-09 12:08:44',NULL),(2388,7908,657,40720,1541,3,217,1,7703.62,NULL,'2023-10-09 12:12:42','2023-10-09 12:12:42',NULL),(2389,7908,657,40720,1541,3,68,1,1617.76,NULL,'2023-10-09 12:12:42','2023-10-09 12:12:42',NULL),(2390,7908,657,40720,1541,3,222,1,679.01,NULL,'2023-10-09 12:12:42','2023-10-09 12:12:42',NULL),(2391,7908,657,40720,1541,3,57,2,10000.39,NULL,'2023-10-09 12:12:42','2023-10-09 12:12:42',NULL),(2392,7908,658,40720,1541,3,217,1,11905.82,NULL,'2023-10-09 12:15:04','2023-10-09 12:15:04',NULL),(2393,7908,658,40720,1541,3,68,1,2500.22,NULL,'2023-10-09 12:15:04','2023-10-09 12:15:04',NULL),(2394,7908,658,40720,1541,3,222,1,605.18,NULL,'2023-10-09 12:15:04','2023-10-09 12:15:04',NULL),(2395,7908,658,40720,1541,3,57,2,15011.22,NULL,'2023-10-09 12:15:04','2023-10-09 12:15:04',NULL),(2396,7908,659,40720,1541,3,217,1,3776.20,NULL,'2023-10-09 12:16:17','2023-10-09 12:16:17',NULL),(2397,7908,659,40720,1541,3,68,1,793.00,NULL,'2023-10-09 12:16:17','2023-10-09 12:16:17',NULL),(2398,7908,659,40720,1541,3,222,1,431.00,NULL,'2023-10-09 12:16:17','2023-10-09 12:16:17',NULL),(2399,7908,659,40720,1541,3,57,2,5000.20,NULL,'2023-10-09 12:16:17','2023-10-09 12:16:17',NULL),(2400,7908,660,40720,1541,3,217,1,11742.26,NULL,'2023-10-09 12:17:51','2023-10-09 12:17:51',NULL),(2401,7908,660,40720,1541,3,68,1,2465.87,NULL,'2023-10-09 12:17:51','2023-10-09 12:17:51',NULL),(2402,7908,660,40720,1541,3,222,1,799.68,NULL,'2023-10-09 12:17:51','2023-10-09 12:17:51',NULL),(2403,7908,660,40720,1541,3,57,2,15007.81,NULL,'2023-10-09 12:17:51','2023-10-09 12:17:51',NULL),(2404,7908,661,40720,1541,3,217,1,11739.26,NULL,'2023-10-09 12:19:31','2023-10-09 12:19:31',NULL),(2405,7908,661,40720,1541,3,68,1,2465.24,NULL,'2023-10-09 12:19:31','2023-10-09 12:19:31',NULL),(2406,7908,661,40720,1541,3,222,1,799.48,NULL,'2023-10-09 12:19:31','2023-10-09 12:19:31',NULL),(2407,7908,661,40720,1541,3,57,2,15003.98,NULL,'2023-10-09 12:19:31','2023-10-09 12:19:31',NULL),(2408,7908,662,40720,1541,3,217,1,12520.96,NULL,'2023-10-09 12:20:55','2023-10-09 12:20:55',NULL),(2409,7908,662,40720,1541,3,68,1,2629.40,NULL,'2023-10-09 12:20:55','2023-10-09 12:20:55',NULL),(2410,7908,662,40720,1541,3,222,1,852.72,NULL,'2023-10-09 12:20:56','2023-10-09 12:20:56',NULL),(2411,7908,662,40720,1541,3,57,2,16003.08,NULL,'2023-10-09 12:20:56','2023-10-09 12:20:56',NULL),(2412,7908,663,40720,1541,3,217,1,10563.55,NULL,'2023-10-09 12:21:47','2023-10-09 12:21:47',NULL),(2413,7908,663,40720,1541,3,68,1,2218.35,NULL,'2023-10-09 12:21:47','2023-10-09 12:21:47',NULL),(2414,7908,663,40720,1541,3,222,1,719.41,NULL,'2023-10-09 12:21:47','2023-10-09 12:21:47',NULL),(2415,7908,663,40720,1541,3,57,2,13501.31,NULL,'2023-10-09 12:21:47','2023-10-09 12:21:47',NULL),(2416,7908,664,40720,1541,3,217,1,11738.79,NULL,'2023-10-09 12:22:45','2023-10-09 12:22:45',NULL),(2417,7908,664,40720,1541,3,68,1,2465.15,NULL,'2023-10-09 12:22:45','2023-10-09 12:22:45',NULL);
INSERT INTO `balance_libro_details` VALUES (2418,7908,664,40720,1541,3,222,1,799.45,NULL,'2023-10-09 12:22:45','2023-10-09 12:22:45',NULL),(2419,7908,664,40720,1541,3,57,2,15003.39,NULL,'2023-10-09 12:22:45','2023-10-09 12:22:45',NULL),(2420,7908,665,40720,1540,15,67,1,1851514.12,NULL,'2023-10-09 18:18:46','2024-08-07 11:12:10','2024-08-07 11:12:10'),(2421,7908,665,40720,1540,15,68,2,1668981.75,NULL,'2023-10-09 18:18:46','2024-08-07 11:12:10','2024-08-07 11:12:10'),(2422,7908,665,40720,1540,15,353,2,166593.12,NULL,'2023-10-09 18:18:46','2024-08-07 11:12:10','2024-08-07 11:12:10'),(2423,7908,665,40720,1540,15,354,2,20893.03,NULL,'2023-10-09 18:18:46','2024-08-07 11:12:10','2024-08-07 11:12:10'),(2424,7908,665,40720,1540,15,354,1,4953.78,NULL,'2023-10-09 18:18:46','2024-08-07 11:12:10','2024-08-07 11:12:10'),(2425,7908,666,40720,1541,3,217,1,35000.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:09:08','2023-10-09 19:09:08'),(2426,7908,666,40720,1541,3,68,1,7350.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:09:08','2023-10-09 19:09:08'),(2427,7908,666,40720,1541,3,217,1,0.75,NULL,'2023-10-09 18:53:48','2023-10-09 19:09:08','2023-10-09 19:09:08'),(2428,7908,666,40720,1541,3,57,2,42612.50,NULL,'2023-10-09 18:53:48','2023-10-09 19:09:08','2023-10-09 19:09:08'),(2429,7908,666,40720,1541,3,136,1,261.75,NULL,'2023-10-09 18:53:48','2023-10-09 19:09:08','2023-10-09 19:09:08'),(2430,7908,667,40720,1541,3,217,1,249060.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:48','2023-10-09 19:08:48'),(2431,7908,667,40720,1541,3,68,1,52304.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:48','2023-10-09 19:08:48'),(2432,7908,667,40720,1541,3,217,1,5.34,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:48','2023-10-09 19:08:48'),(2433,7908,667,40720,1541,3,57,2,303233.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:48','2023-10-09 19:08:48'),(2434,7908,667,40720,1541,3,136,1,1863.66,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:48','2023-10-09 19:08:48'),(2435,7908,668,40720,1541,3,217,1,16450.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:23','2023-10-09 19:08:23'),(2436,7908,668,40720,1541,3,68,1,3454.50,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:23','2023-10-09 19:08:23'),(2437,7908,668,40720,1541,3,217,1,0.35,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:23','2023-10-09 19:08:23'),(2438,7908,668,40720,1541,3,57,2,20027.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:23','2023-10-09 19:08:23'),(2439,7908,668,40720,1541,3,136,1,122.15,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:23','2023-10-09 19:08:23'),(2440,7908,669,40720,1541,3,217,1,112000.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:00','2023-10-09 19:08:00'),(2441,7908,669,40720,1541,3,68,1,23520.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:00','2023-10-09 19:08:00'),(2442,7908,669,40720,1541,3,217,1,2.40,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:00','2023-10-09 19:08:00'),(2443,7908,669,40720,1541,3,57,2,136360.00,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:00','2023-10-09 19:08:00'),(2444,7908,669,40720,1541,3,136,1,837.60,NULL,'2023-10-09 18:53:48','2023-10-09 19:08:00','2023-10-09 19:08:00'),(2445,7908,670,40720,1541,3,217,1,3719.01,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2446,7908,670,40720,1541,3,68,1,780.99,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2447,7908,670,40720,1541,3,57,2,4500.00,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2448,7908,671,40720,1541,3,217,1,1329242.40,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2449,7908,671,40720,1541,3,68,1,279140.90,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2450,7908,671,40720,1541,3,57,2,1608383.30,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2451,7908,672,40720,1541,3,217,1,3719.01,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2452,7908,672,40720,1541,3,68,1,780.99,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2453,7908,672,40720,1541,3,57,2,4500.00,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL);
INSERT INTO `balance_libro_details` VALUES (2454,7908,673,40720,1541,3,217,1,4958.68,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2455,7908,673,40720,1541,3,68,1,1041.32,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2456,7908,673,40720,1541,3,57,2,6000.00,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2457,7908,674,40720,1541,3,217,1,1900000.00,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2458,7908,674,40720,1541,3,68,1,399000.00,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2459,7908,674,40720,1541,3,57,2,2299000.00,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2460,7908,675,40720,1541,3,217,1,12037.40,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2461,7908,675,40720,1541,3,68,1,2527.85,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2462,7908,675,40720,1541,3,57,2,14565.25,NULL,'2023-10-09 18:53:48','2023-10-09 18:53:48',NULL),(2463,7908,676,40720,1541,15,67,1,2516529.75,NULL,'2023-10-09 18:58:30','2023-10-09 18:59:23','2023-10-09 18:59:23'),(2464,7908,676,40720,1541,15,68,2,2648215.52,NULL,'2023-10-09 18:58:30','2023-10-09 18:59:23','2023-10-09 18:59:23'),(2465,7908,676,40720,1541,15,354,2,4953.78,NULL,'2023-10-09 18:58:30','2023-10-09 18:59:23','2023-10-09 18:59:23'),(2466,7908,676,40720,1541,15,353,1,131685.77,NULL,'2023-10-09 18:58:30','2023-10-09 18:59:23','2023-10-09 18:59:23'),(2467,7908,676,40720,1541,15,354,1,4953.78,NULL,'2023-10-09 18:58:30','2023-10-09 18:59:23','2023-10-09 18:59:23'),(2468,7908,677,40720,1541,15,67,1,2516529.75,NULL,'2023-10-09 19:00:26','2023-10-09 19:06:34','2023-10-09 19:06:34'),(2469,7908,677,40720,1541,15,68,2,2648215.52,NULL,'2023-10-09 19:00:26','2023-10-09 19:06:34','2023-10-09 19:06:34'),(2470,7908,677,40720,1541,15,354,2,4953.78,NULL,'2023-10-09 19:00:26','2023-10-09 19:06:34','2023-10-09 19:06:34'),(2471,7908,677,40720,1541,15,353,1,131685.77,NULL,'2023-10-09 19:00:26','2023-10-09 19:06:34','2023-10-09 19:06:34'),(2472,7908,677,40720,1541,15,354,1,4953.78,NULL,'2023-10-09 19:00:26','2023-10-09 19:06:34','2023-10-09 19:06:34'),(2473,7908,678,40720,1541,3,217,1,112000.00,NULL,'2023-10-09 19:08:00','2023-10-09 19:08:00',NULL),(2474,7908,678,40720,1541,3,68,1,23520.00,NULL,'2023-10-09 19:08:00','2023-10-09 19:08:00',NULL),(2475,7908,678,40720,1541,3,57,2,135520.00,NULL,'2023-10-09 19:08:00','2023-10-09 19:08:00',NULL),(2476,7908,679,40720,1541,3,217,1,16450.00,NULL,'2023-10-09 19:08:23','2023-10-09 19:08:23',NULL),(2477,7908,679,40720,1541,3,68,1,3454.50,NULL,'2023-10-09 19:08:23','2023-10-09 19:08:23',NULL),(2478,7908,679,40720,1541,3,57,2,19904.50,NULL,'2023-10-09 19:08:23','2023-10-09 19:08:23',NULL),(2479,7908,680,40720,1541,3,217,1,249060.00,NULL,'2023-10-09 19:08:48','2023-10-09 19:08:48',NULL),(2480,7908,680,40720,1541,3,68,1,52302.60,NULL,'2023-10-09 19:08:48','2023-10-09 19:08:48',NULL),(2481,7908,680,40720,1541,3,57,2,301362.60,NULL,'2023-10-09 19:08:48','2023-10-09 19:08:48',NULL),(2482,7908,681,40720,1541,3,217,1,35000.00,NULL,'2023-10-09 19:09:08','2023-10-09 19:09:08',NULL),(2483,7908,681,40720,1541,3,68,1,7350.00,NULL,'2023-10-09 19:09:08','2023-10-09 19:09:08',NULL),(2484,7908,681,40720,1541,3,57,2,42350.00,NULL,'2023-10-09 19:09:08','2023-10-09 19:09:08',NULL),(2485,7908,682,40720,1541,3,217,1,16452.35,NULL,'2023-10-09 19:09:26','2023-10-09 19:09:26',NULL),(2486,7908,682,40720,1541,3,68,1,3454.99,NULL,'2023-10-09 19:09:26','2023-10-09 19:09:26',NULL),(2487,7908,682,40720,1541,3,57,2,19907.34,NULL,'2023-10-09 19:09:26','2023-10-09 19:09:26',NULL),(2488,7908,683,40720,1541,3,217,1,498191.16,NULL,'2023-10-09 19:10:05','2023-10-09 19:10:05',NULL),(2489,7908,683,40720,1541,3,68,1,104620.14,NULL,'2023-10-09 19:10:05','2023-10-09 19:10:05',NULL),(2490,7908,683,40720,1541,3,57,2,602811.30,NULL,'2023-10-09 19:10:05','2023-10-09 19:10:05',NULL),(2491,7908,684,40720,1541,3,217,1,6048000.00,NULL,'2023-10-09 19:10:33','2023-10-09 19:10:33',NULL),(2492,7908,684,40720,1541,3,68,1,635040.00,NULL,'2023-10-09 19:10:33','2023-10-09 19:10:33',NULL);
INSERT INTO `balance_libro_details` VALUES (2493,7908,684,40720,1541,3,57,2,6683040.00,NULL,'2023-10-09 19:10:33','2023-10-09 19:10:33',NULL),(2494,7908,685,40720,1541,3,217,1,35010.00,NULL,'2023-10-09 19:11:00','2023-10-09 19:11:00',NULL),(2495,7908,685,40720,1541,3,68,1,7352.10,NULL,'2023-10-09 19:11:00','2023-10-09 19:11:00',NULL),(2496,7908,685,40720,1541,3,57,2,42362.10,NULL,'2023-10-09 19:11:00','2023-10-09 19:11:00',NULL),(2497,7908,686,40720,1541,15,67,1,2516529.75,NULL,'2023-10-09 19:12:00','2024-11-13 12:27:28','2024-11-13 12:27:28'),(2498,7908,686,40720,1541,15,68,2,2648215.52,NULL,'2023-10-09 19:12:00','2024-11-13 12:27:28','2024-11-13 12:27:28'),(2499,7908,686,40720,1541,15,354,2,4953.78,NULL,'2023-10-09 19:12:00','2024-11-13 12:27:28','2024-11-13 12:27:28'),(2500,7908,686,40720,1541,15,353,1,131685.77,NULL,'2023-10-09 19:12:00','2024-11-13 12:27:28','2024-11-13 12:27:28'),(2501,7908,686,40720,1541,15,354,1,4953.78,NULL,'2023-10-09 19:12:00','2024-11-13 12:27:28','2024-11-13 12:27:28'),(2502,7908,687,40720,1542,3,217,1,1900000.00,NULL,'2023-10-18 11:56:37','2023-10-19 11:39:16','2023-10-19 11:39:16'),(2503,7908,687,40720,1542,3,68,1,399000.00,NULL,'2023-10-18 11:56:37','2023-10-19 11:39:16','2023-10-19 11:39:16'),(2504,7908,687,40720,1542,3,57,2,2299000.00,NULL,'2023-10-18 11:56:37','2023-10-19 11:39:16','2023-10-19 11:39:16'),(2505,7908,688,40720,1542,3,217,1,2727.27,NULL,'2023-10-18 11:56:37','2023-10-18 11:56:37',NULL),(2506,7908,688,40720,1542,3,68,1,572.73,NULL,'2023-10-18 11:56:37','2023-10-18 11:56:37',NULL),(2507,7908,688,40720,1542,3,57,2,3300.00,NULL,'2023-10-18 11:56:37','2023-10-18 11:56:37',NULL),(2508,7908,689,40720,1542,3,217,1,3719.01,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2509,7908,689,40720,1542,3,68,1,780.99,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2510,7908,689,40720,1542,3,57,2,4500.00,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2511,7908,690,40720,1542,3,217,1,56016.00,NULL,'2023-10-18 11:56:38','2023-11-24 18:51:36','2023-11-24 18:51:36'),(2512,7908,690,40720,1542,3,68,1,11763.36,NULL,'2023-10-18 11:56:38','2023-11-24 18:51:36','2023-11-24 18:51:36'),(2513,7908,690,40720,1542,3,217,1,1.20,NULL,'2023-10-18 11:56:38','2023-11-24 18:51:36','2023-11-24 18:51:36'),(2514,7908,690,40720,1542,3,57,2,68199.48,NULL,'2023-10-18 11:56:38','2023-11-24 18:51:36','2023-11-24 18:51:36'),(2515,7908,690,40720,1542,3,136,1,418.92,NULL,'2023-10-18 11:56:38','2023-11-24 18:51:36','2023-11-24 18:51:36'),(2516,7908,691,40720,1542,3,217,1,3688.02,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2517,7908,691,40720,1542,3,68,1,774.48,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2518,7908,691,40720,1542,3,57,2,4462.50,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2519,7908,692,40720,1542,3,217,1,3719.01,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2520,7908,692,40720,1542,3,68,1,780.99,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2521,7908,692,40720,1542,3,57,2,4500.00,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2522,7908,693,40720,1542,3,217,1,191735.54,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2523,7908,693,40720,1542,3,68,1,40264.46,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2524,7908,693,40720,1542,3,57,2,232000.00,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2525,7908,694,40720,1542,3,217,1,8264.46,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2526,7908,694,40720,1542,3,68,1,1735.54,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2527,7908,694,40720,1542,3,57,2,10000.00,NULL,'2023-10-18 11:56:38','2023-10-18 11:56:38',NULL),(2528,7908,695,40720,1542,3,217,1,41286.88,NULL,'2023-10-18 11:56:38','2023-11-24 18:54:22','2023-11-24 18:54:22'),(2529,7908,695,40720,1542,3,68,1,8669.66,NULL,'2023-10-18 11:56:38','2023-11-24 18:54:22','2023-11-24 18:54:22'),(2530,7908,695,40720,1542,3,217,1,0.85,NULL,'2023-10-18 11:56:38','2023-11-24 18:54:22','2023-11-24 18:54:22');
INSERT INTO `balance_libro_details` VALUES (2531,7908,695,40720,1542,3,57,2,50267.22,NULL,'2023-10-18 11:56:38','2023-11-24 18:54:22','2023-11-24 18:54:22'),(2532,7908,695,40720,1542,3,136,1,309.83,NULL,'2023-10-18 11:56:38','2023-11-24 18:54:22','2023-11-24 18:54:22'),(2533,7908,696,40720,1542,3,217,1,3059874.00,NULL,'2023-10-18 11:56:38','2023-11-24 18:52:56','2023-11-24 18:52:56'),(2534,7908,696,40720,1542,3,68,1,642573.54,NULL,'2023-10-18 11:56:38','2023-11-24 18:52:56','2023-11-24 18:52:56'),(2535,7908,696,40720,1542,3,217,1,65.55,NULL,'2023-10-18 11:56:38','2023-11-24 18:52:56','2023-11-24 18:52:56'),(2536,7908,696,40720,1542,3,57,2,3725396.60,NULL,'2023-10-18 11:56:38','2023-11-24 18:52:56','2023-11-24 18:52:56'),(2537,7908,696,40720,1542,3,136,1,22883.51,NULL,'2023-10-18 11:56:38','2023-11-24 18:52:56','2023-11-24 18:52:56'),(2538,7908,697,40720,1542,3,217,1,35010.00,NULL,'2023-10-18 11:56:38','2023-11-24 18:50:55','2023-11-24 18:50:55'),(2539,7908,697,40720,1542,3,68,1,7352.10,NULL,'2023-10-18 11:56:38','2023-11-24 18:50:55','2023-11-24 18:50:55'),(2540,7908,697,40720,1542,3,217,1,0.75,NULL,'2023-10-18 11:56:38','2023-11-24 18:50:55','2023-11-24 18:50:55'),(2541,7908,697,40720,1542,3,57,2,42624.68,NULL,'2023-10-18 11:56:38','2023-11-24 18:50:55','2023-11-24 18:50:55'),(2542,7908,697,40720,1542,3,136,1,261.83,NULL,'2023-10-18 11:56:38','2023-11-24 18:50:55','2023-11-24 18:50:55'),(2543,7908,698,40720,1542,3,217,1,1900000.00,NULL,'2023-10-19 11:39:16','2023-10-19 11:39:16',NULL),(2544,7908,698,40720,1542,3,68,1,399000.00,NULL,'2023-10-19 11:39:16','2023-10-19 11:39:16',NULL),(2545,7908,698,40720,1542,3,57,2,2299000.00,NULL,'2023-10-19 11:39:16','2023-10-19 11:39:16',NULL),(2546,7908,699,40720,1542,3,217,1,4958.68,NULL,'2023-10-24 17:20:14','2023-10-24 17:20:14',NULL),(2547,7908,699,40720,1542,3,68,1,1041.32,NULL,'2023-10-24 17:20:14','2023-10-24 17:20:14',NULL),(2548,7908,699,40720,1542,3,57,2,6000.00,NULL,'2023-10-24 17:20:14','2023-10-24 17:20:14',NULL),(2549,7908,700,40720,1542,3,217,1,38016.53,NULL,'2023-10-24 17:20:14','2023-10-24 17:20:14',NULL),(2550,7908,700,40720,1542,3,68,1,7983.47,NULL,'2023-10-24 17:20:14','2023-10-24 17:20:14',NULL),(2551,7908,700,40720,1542,3,57,2,46000.00,NULL,'2023-10-24 17:20:15','2023-10-24 17:20:15',NULL),(2552,7908,701,40720,1542,3,217,1,72825.88,NULL,'2023-10-24 17:20:15','2023-11-24 18:53:48','2023-11-24 18:53:48'),(2553,7908,701,40720,1542,3,68,1,15292.52,NULL,'2023-10-24 17:20:15','2023-11-24 18:53:48','2023-11-24 18:53:48'),(2554,7908,701,40720,1542,3,217,1,1.49,NULL,'2023-10-24 17:20:15','2023-11-24 18:53:48','2023-11-24 18:53:48'),(2555,7908,701,40720,1542,3,57,2,88662.99,NULL,'2023-10-24 17:20:15','2023-11-24 18:53:48','2023-11-24 18:53:48'),(2556,7908,701,40720,1542,3,136,1,543.10,NULL,'2023-10-24 17:20:15','2023-11-24 18:53:48','2023-11-24 18:53:48'),(2557,7908,702,40720,1542,3,217,1,138633.38,NULL,'2023-10-24 17:20:15','2023-11-24 18:50:24','2023-11-24 18:50:24'),(2558,7908,702,40720,1542,3,68,1,29113.01,NULL,'2023-10-24 17:20:15','2023-11-24 18:50:24','2023-11-24 18:50:24'),(2559,7908,702,40720,1542,3,217,1,1039.75,NULL,'2023-10-24 17:20:15','2023-11-24 18:50:24','2023-11-24 18:50:24'),(2560,7908,702,40720,1542,3,57,2,168786.14,NULL,'2023-10-24 17:20:15','2023-11-24 18:50:24','2023-11-24 18:50:24'),(2561,7908,703,40720,1542,3,217,1,1027903.00,NULL,'2023-10-30 18:06:53','2024-11-13 12:46:42','2024-11-13 12:46:42'),(2562,7908,703,40720,1542,3,68,1,215859.63,NULL,'2023-10-30 18:06:53','2024-11-13 12:46:42','2024-11-13 12:46:42'),(2563,7908,703,40720,1542,3,57,2,1243762.63,NULL,'2023-10-30 18:06:53','2024-11-13 12:46:42','2024-11-13 12:46:42'),(2564,7908,704,40720,1542,3,217,1,1031127.00,NULL,'2023-10-30 18:06:53','2024-11-13 12:46:18','2024-11-13 12:46:18'),(2565,7908,704,40720,1542,3,68,1,216536.67,NULL,'2023-10-30 18:06:53','2024-11-13 12:46:18','2024-11-13 12:46:18'),(2566,7908,704,40720,1542,3,57,2,1247663.67,NULL,'2023-10-30 18:06:53','2024-11-13 12:46:18','2024-11-13 12:46:18');
INSERT INTO `balance_libro_details` VALUES (2567,7908,705,40720,1542,3,217,1,953312.00,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:55','2024-11-13 12:45:55'),(2568,7908,705,40720,1542,3,68,1,200195.52,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:55','2024-11-13 12:45:55'),(2569,7908,705,40720,1542,3,57,2,1153507.52,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:55','2024-11-13 12:45:55'),(2570,7908,706,40720,1542,3,217,1,1040007.00,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:34','2024-11-13 12:45:34'),(2571,7908,706,40720,1542,3,68,1,218401.47,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:34','2024-11-13 12:45:34'),(2572,7908,706,40720,1542,3,57,2,1258408.47,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:34','2024-11-13 12:45:34'),(2573,7908,707,40720,1542,3,217,1,1048501.14,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:17','2024-11-13 12:45:17'),(2574,7908,707,40720,1542,3,68,1,220185.24,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:17','2024-11-13 12:45:17'),(2575,7908,707,40720,1542,3,57,2,1268686.38,NULL,'2023-10-30 18:06:53','2024-11-13 12:45:17','2024-11-13 12:45:17'),(2576,7908,708,40720,1542,3,217,1,1021599.00,NULL,'2023-10-30 18:06:53','2024-11-13 12:44:57','2024-11-13 12:44:57'),(2577,7908,708,40720,1542,3,68,1,214535.79,NULL,'2023-10-30 18:06:53','2024-11-13 12:44:57','2024-11-13 12:44:57'),(2578,7908,708,40720,1542,3,57,2,1236134.79,NULL,'2023-10-30 18:06:53','2024-11-13 12:44:57','2024-11-13 12:44:57'),(2579,7908,709,40720,1542,3,217,1,1020408.00,NULL,'2023-10-30 18:06:53','2024-11-13 12:44:34','2024-11-13 12:44:34'),(2580,7908,709,40720,1542,3,68,1,214285.68,NULL,'2023-10-30 18:06:53','2024-11-13 12:44:34','2024-11-13 12:44:34'),(2581,7908,709,40720,1542,3,57,2,1234693.68,NULL,'2023-10-30 18:06:53','2024-11-13 12:44:34','2024-11-13 12:44:34'),(2582,7908,710,40720,1542,3,217,2,1900000.00,NULL,'2023-10-30 18:41:39','2023-10-30 18:41:39',NULL),(2583,7908,710,40720,1542,3,67,2,399000.00,NULL,'2023-10-30 18:41:39','2023-10-30 18:41:39',NULL),(2584,7908,710,40720,1542,3,57,1,2299000.00,NULL,'2023-10-30 18:41:39','2023-10-30 18:41:39',NULL),(2585,7908,711,40720,1542,3,217,1,5238000.00,NULL,'2023-11-01 19:01:37','2023-11-01 19:01:37',NULL),(2586,7908,711,40720,1542,3,68,1,1099980.00,NULL,'2023-11-01 19:01:37','2023-11-01 19:01:37',NULL),(2587,7908,711,40720,1542,3,57,2,6337980.00,NULL,'2023-11-01 19:01:37','2023-11-01 19:01:37',NULL),(2588,7908,712,40720,1543,2,96,2,10413225.00,NULL,'2023-11-07 19:20:11','2023-11-07 19:20:11',NULL),(2589,7908,712,40720,1543,2,67,2,2186777.25,NULL,'2023-11-07 19:20:11','2023-11-07 19:20:11',NULL),(2590,7908,712,40720,1543,2,13,1,12600002.25,NULL,'2023-11-07 19:20:11','2023-11-07 19:20:11',NULL),(2591,7908,713,40720,1543,3,217,1,70413.22,NULL,'2023-11-22 18:33:25','2023-11-22 18:33:25',NULL),(2592,7908,713,40720,1543,3,68,1,14786.78,NULL,'2023-11-22 18:33:25','2023-11-22 18:33:25',NULL),(2593,7908,713,40720,1543,3,57,2,85200.00,NULL,'2023-11-22 18:33:25','2023-11-22 18:33:25',NULL),(2594,7908,714,40720,1543,3,217,1,660100.00,NULL,'2023-11-22 18:33:26','2023-11-22 18:37:14','2023-11-22 18:37:14'),(2595,7908,714,40720,1543,3,68,1,138621.00,NULL,'2023-11-22 18:33:26','2023-11-22 18:37:14','2023-11-22 18:37:14'),(2596,7908,714,40720,1543,3,217,1,14.15,NULL,'2023-11-22 18:33:26','2023-11-22 18:37:14','2023-11-22 18:37:14'),(2597,7908,714,40720,1543,3,57,2,803673.50,NULL,'2023-11-22 18:33:26','2023-11-22 18:37:14','2023-11-22 18:37:14'),(2598,7908,714,40720,1543,3,136,1,4938.35,NULL,'2023-11-22 18:33:26','2023-11-22 18:37:14','2023-11-22 18:37:14'),(2599,7908,715,40720,1543,3,217,1,407112.79,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(2600,7908,715,40720,1543,3,68,1,85493.68,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(2601,7908,715,40720,1543,3,57,2,492606.47,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(2602,7908,716,40720,1543,3,217,1,2561.98,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(2603,7908,716,40720,1543,3,68,1,538.02,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL);
INSERT INTO `balance_libro_details` VALUES (2604,7908,716,40720,1543,3,57,2,3100.00,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(2605,7908,717,40720,1543,3,217,1,392818.18,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(2606,7908,717,40720,1543,3,68,1,82491.82,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(2607,7908,717,40720,1543,3,57,2,475310.00,NULL,'2023-11-22 18:33:26','2023-11-22 18:33:26',NULL),(2608,7908,718,40720,1543,3,217,1,189632.37,NULL,'2023-11-22 18:33:26','2023-11-22 18:36:31','2023-11-22 18:36:31'),(2609,7908,718,40720,1543,3,68,1,39821.23,NULL,'2023-11-22 18:33:26','2023-11-22 18:36:31','2023-11-22 18:36:31'),(2610,7908,718,40720,1543,3,217,1,3.90,NULL,'2023-11-22 18:33:26','2023-11-22 18:36:31','2023-11-22 18:36:31'),(2611,7908,718,40720,1543,3,57,2,230879.04,NULL,'2023-11-22 18:33:26','2023-11-22 18:36:31','2023-11-22 18:36:31'),(2612,7908,718,40720,1543,3,136,1,1421.54,NULL,'2023-11-22 18:33:26','2023-11-22 18:36:31','2023-11-22 18:36:31'),(2613,7908,719,40720,1543,3,217,1,45413.38,NULL,'2023-11-22 18:33:26','2023-11-22 18:35:57','2023-11-22 18:35:57'),(2614,7908,719,40720,1543,3,68,1,9535.90,NULL,'2023-11-22 18:33:26','2023-11-22 18:35:57','2023-11-22 18:35:57'),(2615,7908,719,40720,1543,3,217,1,0.93,NULL,'2023-11-22 18:33:26','2023-11-22 18:35:57','2023-11-22 18:35:57'),(2616,7908,719,40720,1543,3,57,2,55289.19,NULL,'2023-11-22 18:33:26','2023-11-22 18:35:57','2023-11-22 18:35:57'),(2617,7908,719,40720,1543,3,136,1,338.98,NULL,'2023-11-22 18:33:26','2023-11-22 18:35:57','2023-11-22 18:35:57'),(2618,7908,720,40720,1543,3,217,1,45413.38,NULL,'2023-11-22 18:35:57','2023-11-22 18:35:57',NULL),(2619,7908,720,40720,1543,3,68,1,9536.81,NULL,'2023-11-22 18:35:57','2023-11-22 18:35:57',NULL),(2620,7908,720,40720,1543,3,57,2,54950.19,NULL,'2023-11-22 18:35:57','2023-11-22 18:35:57',NULL),(2621,7908,721,40720,1543,3,217,1,189632.37,NULL,'2023-11-22 18:36:31','2023-11-22 18:36:31',NULL),(2622,7908,721,40720,1543,3,68,1,39822.80,NULL,'2023-11-22 18:36:31','2023-11-22 18:36:31',NULL),(2623,7908,721,40720,1543,3,57,2,229455.17,NULL,'2023-11-22 18:36:31','2023-11-22 18:36:31',NULL),(2624,7908,722,40720,1543,3,217,1,660100.00,NULL,'2023-11-22 18:37:14','2023-11-22 18:37:14',NULL),(2625,7908,722,40720,1543,3,68,1,138621.00,NULL,'2023-11-22 18:37:14','2023-11-22 18:37:14',NULL),(2626,7908,722,40720,1543,3,57,2,798721.00,NULL,'2023-11-22 18:37:14','2023-11-22 18:37:14',NULL),(2627,7908,723,40720,1542,3,217,1,7722.46,NULL,'2023-11-22 18:51:30','2023-11-22 18:51:30',NULL),(2628,7908,723,40720,1542,3,68,1,1621.72,NULL,'2023-11-22 18:51:30','2023-11-22 18:51:30',NULL),(2629,7908,723,40720,1542,3,221,1,658.03,NULL,'2023-11-22 18:51:30','2023-11-22 18:51:30',NULL),(2630,7908,723,40720,1542,3,57,2,10002.21,NULL,'2023-11-22 18:51:30','2023-11-22 18:51:30',NULL),(2631,7908,724,40720,1542,3,217,1,10161.27,NULL,'2023-11-22 18:53:19','2023-11-22 18:53:19',NULL),(2632,7908,724,40720,1542,3,68,1,2133.87,NULL,'2023-11-22 18:53:19','2023-11-22 18:53:19',NULL),(2633,7908,724,40720,1542,3,221,1,737.87,NULL,'2023-11-22 18:53:19','2023-11-22 18:53:19',NULL),(2634,7908,724,40720,1542,3,57,2,13033.01,NULL,'2023-11-22 18:53:19','2023-11-22 18:53:19',NULL),(2635,7908,725,40720,1542,3,217,1,12003.16,NULL,'2023-11-22 18:55:09','2023-11-22 18:55:09',NULL),(2636,7908,725,40720,1542,3,68,1,2520.66,NULL,'2023-11-22 18:55:09','2023-11-22 18:55:09',NULL),(2637,7908,725,40720,1542,3,221,1,476.46,NULL,'2023-11-22 18:55:09','2023-11-22 18:55:09',NULL),(2638,7908,725,40720,1542,3,57,2,15000.28,NULL,'2023-11-22 18:55:09','2023-11-22 18:55:09',NULL),(2639,7908,726,40720,1542,3,217,1,12354.60,NULL,'2023-11-22 18:57:07','2023-11-22 18:57:07',NULL),(2640,7908,726,40720,1542,3,68,1,2594.47,NULL,'2023-11-22 18:57:07','2023-11-22 18:57:07',NULL),(2641,7908,726,40720,1542,3,221,1,1052.73,NULL,'2023-11-22 18:57:07','2023-11-22 18:57:07',NULL),(2642,7908,726,40720,1542,3,57,2,16001.80,NULL,'2023-11-22 18:57:07','2023-11-22 18:57:07',NULL);
INSERT INTO `balance_libro_details` VALUES (2643,7908,727,40720,1542,3,217,1,9243.18,NULL,'2023-11-22 18:59:34','2023-11-22 18:59:34',NULL),(2644,7908,727,40720,1542,3,68,1,1941.07,NULL,'2023-11-22 18:59:34','2023-11-22 18:59:34',NULL),(2645,7908,727,40720,1542,3,221,1,818.73,NULL,'2023-11-22 18:59:34','2023-11-22 18:59:34',NULL),(2646,7908,727,40720,1542,3,57,2,12002.98,NULL,'2023-11-22 18:59:34','2023-11-22 18:59:34',NULL),(2647,7908,728,40720,1542,3,217,1,13604.14,NULL,'2023-11-22 19:02:46','2023-11-22 19:02:46',NULL),(2648,7908,728,40720,1542,3,68,1,2856.87,NULL,'2023-11-22 19:02:46','2023-11-22 19:02:46',NULL),(2649,7908,728,40720,1542,3,221,1,1552.70,NULL,'2023-11-22 19:02:46','2023-11-22 19:02:46',NULL),(2650,7908,728,40720,1542,3,57,2,18013.71,NULL,'2023-11-22 19:02:46','2023-11-22 19:02:46',NULL),(2651,7908,729,40720,1542,3,217,1,11581.61,NULL,'2023-11-23 19:25:20','2023-11-23 19:25:20',NULL),(2652,7908,729,40720,1542,3,68,1,2432.14,NULL,'2023-11-23 19:25:20','2023-11-23 19:25:20',NULL),(2653,7908,729,40720,1542,3,221,1,1027.55,NULL,'2023-11-23 19:25:20','2023-11-23 19:25:20',NULL),(2654,7908,729,40720,1542,3,57,2,15041.30,NULL,'2023-11-23 19:25:20','2023-11-23 19:25:20',NULL),(2655,7908,730,40720,1542,3,217,1,19793.44,NULL,'2023-11-23 19:26:05','2023-11-23 19:26:05',NULL),(2656,7908,730,40720,1542,3,68,1,4156.62,NULL,'2023-11-23 19:26:05','2023-11-23 19:26:05',NULL),(2657,7908,730,40720,1542,3,221,1,1544.76,NULL,'2023-11-23 19:26:05','2023-11-23 19:26:05',NULL),(2658,7908,730,40720,1542,3,57,2,25494.82,NULL,'2023-11-23 19:26:05','2023-11-23 19:26:05',NULL),(2659,7908,731,40720,1542,3,217,1,9294.18,NULL,'2023-11-23 19:26:48','2023-11-23 19:26:48',NULL),(2660,7908,731,40720,1542,3,68,1,1951.78,NULL,'2023-11-23 19:26:48','2023-11-23 19:26:48',NULL),(2661,7908,731,40720,1542,3,221,1,654.34,NULL,'2023-11-23 19:26:48','2023-11-23 19:26:48',NULL),(2662,7908,731,40720,1542,3,57,2,11900.30,NULL,'2023-11-23 19:26:48','2023-11-23 19:26:48',NULL),(2663,7908,732,40720,1542,3,217,1,5546.75,NULL,'2023-11-23 19:27:54','2023-11-23 19:27:54',NULL),(2664,7908,732,40720,1542,3,68,1,1164.82,NULL,'2023-11-23 19:27:54','2023-11-23 19:27:54',NULL),(2665,7908,732,40720,1542,3,221,1,291.64,NULL,'2023-11-23 19:27:54','2023-11-23 19:27:54',NULL),(2666,7908,732,40720,1542,3,57,2,7003.21,NULL,'2023-11-23 19:27:54','2023-11-23 19:27:54',NULL),(2667,7908,733,40720,1542,3,217,1,64155.44,NULL,'2023-11-23 19:29:00','2023-11-23 19:29:00',NULL),(2668,7908,733,40720,1542,3,68,1,13472.64,NULL,'2023-11-23 19:29:00','2023-11-23 19:29:00',NULL),(2669,7908,733,40720,1542,3,221,1,3373.24,NULL,'2023-11-23 19:29:00','2023-11-23 19:29:00',NULL),(2670,7908,733,40720,1542,3,57,2,81001.32,NULL,'2023-11-23 19:29:00','2023-11-23 19:29:00',NULL),(2671,7908,734,40720,1542,3,217,1,32017.00,NULL,'2023-11-23 19:30:17','2023-11-23 19:30:17',NULL),(2672,7908,734,40720,1542,3,68,1,6723.57,NULL,'2023-11-23 19:30:17','2023-11-23 19:30:17',NULL),(2673,7908,734,40720,1542,3,221,1,1683.43,NULL,'2023-11-23 19:30:17','2023-11-23 19:30:17',NULL),(2674,7908,734,40720,1542,3,57,2,40424.00,NULL,'2023-11-23 19:30:17','2023-11-23 19:30:17',NULL),(2675,7908,735,40720,1542,3,217,1,16005.55,NULL,'2023-11-23 19:32:43','2023-11-23 19:32:43',NULL),(2676,7908,735,40720,1542,3,68,1,3361.17,NULL,'2023-11-23 19:32:43','2023-11-23 19:32:43',NULL),(2677,7908,735,40720,1542,3,221,1,635.33,NULL,'2023-11-23 19:32:43','2023-11-23 19:32:43',NULL),(2678,7908,735,40720,1542,3,57,2,20002.05,NULL,'2023-11-23 19:32:43','2023-11-23 19:32:43',NULL),(2679,7908,736,40720,1542,3,217,1,16005.55,NULL,'2023-11-23 19:36:30','2023-11-23 19:36:30',NULL),(2680,7908,736,40720,1542,3,68,1,3361.17,NULL,'2023-11-23 19:36:30','2023-11-23 19:36:30',NULL),(2681,7908,736,40720,1542,3,221,1,635.33,NULL,'2023-11-23 19:36:30','2023-11-23 19:36:30',NULL),(2682,7908,736,40720,1542,3,57,2,20002.05,NULL,'2023-11-23 19:36:30','2023-11-23 19:36:30',NULL),(2683,7908,737,40720,1542,3,217,1,14411.10,NULL,'2023-11-23 19:37:21','2023-11-23 19:37:21',NULL);
INSERT INTO `balance_libro_details` VALUES (2684,7908,737,40720,1542,3,68,1,3026.33,NULL,'2023-11-23 19:37:21','2023-11-23 19:37:21',NULL),(2685,7908,737,40720,1542,3,221,1,572.04,NULL,'2023-11-23 19:37:21','2023-11-23 19:37:21',NULL),(2686,7908,737,40720,1542,3,57,2,18009.47,NULL,'2023-11-23 19:37:21','2023-11-23 19:37:21',NULL),(2687,7908,738,40720,1542,3,217,1,26223.89,NULL,'2023-11-23 19:38:14','2023-11-23 19:38:14',NULL),(2688,7908,738,40720,1542,3,68,1,5507.02,NULL,'2023-11-23 19:38:14','2023-11-23 19:38:14',NULL),(2689,7908,738,40720,1542,3,221,1,1272.63,NULL,'2023-11-23 19:38:14','2023-11-23 19:38:14',NULL),(2690,7908,738,40720,1542,3,57,2,33003.54,NULL,'2023-11-23 19:38:14','2023-11-23 19:38:14',NULL),(2691,7908,739,40720,1542,3,217,1,32319.65,NULL,'2023-11-23 19:39:21','2023-11-23 19:39:21',NULL),(2692,7908,739,40720,1542,3,68,1,6787.13,NULL,'2023-11-23 19:39:21','2023-11-23 19:39:21',NULL),(2693,7908,739,40720,1542,3,221,1,893.21,NULL,'2023-11-23 19:39:21','2023-11-23 19:39:21',NULL),(2694,7908,739,40720,1542,3,57,2,39999.99,NULL,'2023-11-23 19:39:21','2023-11-23 19:39:21',NULL),(2695,7908,740,40720,1542,3,217,1,40009.80,NULL,'2023-11-23 19:40:24','2023-11-23 19:40:24',NULL),(2696,7908,740,40720,1542,3,68,1,8402.06,NULL,'2023-11-23 19:40:24','2023-11-23 19:40:24',NULL),(2697,7908,740,40720,1542,3,221,1,1588.15,NULL,'2023-11-23 19:40:24','2023-11-23 19:40:24',NULL),(2698,7908,740,40720,1542,3,57,2,50000.01,NULL,'2023-11-23 19:40:24','2023-11-23 19:40:24',NULL),(2699,7908,741,40720,1542,3,217,1,4801.18,NULL,'2023-11-23 19:41:21','2023-11-23 19:41:21',NULL),(2700,7908,741,40720,1542,3,68,1,1008.25,NULL,'2023-11-23 19:41:21','2023-11-23 19:41:21',NULL),(2701,7908,741,40720,1542,3,221,1,190.58,NULL,'2023-11-23 19:41:21','2023-11-23 19:41:21',NULL),(2702,7908,741,40720,1542,3,57,2,6000.01,NULL,'2023-11-23 19:41:21','2023-11-23 19:41:21',NULL),(2703,7908,742,40720,1542,3,217,1,7704.60,NULL,'2023-11-23 19:43:45','2023-11-23 19:43:45',NULL),(2704,7908,742,40720,1542,3,68,1,1617.97,NULL,'2023-11-23 19:43:45','2023-11-23 19:43:45',NULL),(2705,7908,742,40720,1542,3,221,1,677.48,NULL,'2023-11-23 19:43:45','2023-11-23 19:43:45',NULL),(2706,7908,742,40720,1542,3,57,2,10000.05,NULL,'2023-11-23 19:43:45','2023-11-23 19:43:45',NULL),(2707,7908,743,40720,1542,3,217,1,7704.60,NULL,'2023-11-23 19:44:33','2023-11-23 19:44:33',NULL),(2708,7908,743,40720,1542,3,68,1,1617.97,NULL,'2023-11-23 19:44:33','2023-11-23 19:44:33',NULL),(2709,7908,743,40720,1542,3,221,1,677.48,NULL,'2023-11-23 19:44:33','2023-11-23 19:44:33',NULL),(2710,7908,743,40720,1542,3,57,2,10000.05,NULL,'2023-11-23 19:44:33','2023-11-23 19:44:33',NULL),(2711,7908,744,40720,1542,3,217,1,6859.51,NULL,'2023-11-23 19:46:35','2023-11-23 19:46:35',NULL),(2712,7908,744,40720,1542,3,68,1,1440.50,NULL,'2023-11-23 19:46:35','2023-11-23 19:46:35',NULL),(2713,7908,744,40720,1542,3,57,2,8300.01,NULL,'2023-11-23 19:46:35','2023-11-23 19:46:35',NULL),(2714,7908,745,40720,1542,15,67,1,4043628.75,NULL,'2023-11-23 19:48:45','2023-11-24 18:49:36','2023-11-24 18:49:36'),(2715,7908,745,40720,1542,15,68,2,3847379.44,NULL,'2023-11-23 19:48:45','2023-11-24 18:49:36','2023-11-24 18:49:36'),(2716,7908,745,40720,1542,15,353,2,131685.77,NULL,'2023-11-23 19:48:45','2023-11-24 18:49:36','2023-11-24 18:49:36'),(2717,7908,745,40720,1542,15,354,2,4953.78,NULL,'2023-11-23 19:48:45','2023-11-24 18:49:36','2023-11-24 18:49:36'),(2718,7908,745,40720,1542,15,74,2,59609.76,NULL,'2023-11-23 19:48:45','2023-11-24 18:49:36','2023-11-24 18:49:36'),(2719,7908,746,40720,1542,3,217,1,138633.38,NULL,'2023-11-24 18:50:24','2023-11-24 18:50:24',NULL),(2720,7908,746,40720,1542,3,68,1,29113.01,NULL,'2023-11-24 18:50:24','2023-11-24 18:50:24',NULL),(2721,7908,746,40720,1542,3,57,2,167746.39,NULL,'2023-11-24 18:50:24','2023-11-24 18:50:24',NULL),(2722,7908,747,40720,1542,3,217,1,35010.00,NULL,'2023-11-24 18:50:55','2023-11-24 18:50:55',NULL),(2723,7908,747,40720,1542,3,68,1,7352.10,NULL,'2023-11-24 18:50:55','2023-11-24 18:50:55',NULL);
INSERT INTO `balance_libro_details` VALUES (2724,7908,747,40720,1542,3,57,2,42362.10,NULL,'2023-11-24 18:50:55','2023-11-24 18:50:55',NULL),(2725,7908,748,40720,1542,3,217,1,56016.00,NULL,'2023-11-24 18:51:36','2023-11-24 18:51:36',NULL),(2726,7908,748,40720,1542,3,68,1,11763.36,NULL,'2023-11-24 18:51:36','2023-11-24 18:51:36',NULL),(2727,7908,748,40720,1542,3,57,2,67779.36,NULL,'2023-11-24 18:51:36','2023-11-24 18:51:36',NULL),(2728,7908,749,40720,1542,3,217,1,3059874.00,NULL,'2023-11-24 18:52:56','2023-11-24 18:52:56',NULL),(2729,7908,749,40720,1542,3,68,1,642573.54,NULL,'2023-11-24 18:52:56','2023-11-24 18:52:56',NULL),(2730,7908,749,40720,1542,3,57,2,3702447.54,NULL,'2023-11-24 18:52:56','2023-11-24 18:52:56',NULL),(2731,7908,750,40720,1542,3,217,1,72825.88,NULL,'2023-11-24 18:53:48','2023-11-24 18:53:48',NULL),(2732,7908,750,40720,1542,3,68,1,15293.43,NULL,'2023-11-24 18:53:48','2023-11-24 18:53:48',NULL),(2733,7908,750,40720,1542,3,57,2,88119.31,NULL,'2023-11-24 18:53:48','2023-11-24 18:53:48',NULL),(2734,7908,751,40720,1542,3,217,1,41286.88,NULL,'2023-11-24 18:54:22','2023-11-24 18:54:22',NULL),(2735,7908,751,40720,1542,3,68,1,8670.24,NULL,'2023-11-24 18:54:22','2023-11-24 18:54:22',NULL),(2736,7908,751,40720,1542,3,57,2,49957.12,NULL,'2023-11-24 18:54:22','2023-11-24 18:54:22',NULL),(2737,7908,752,40720,1542,15,67,1,4043628.75,NULL,'2023-11-24 18:56:41','2024-11-13 12:42:57','2024-11-13 12:42:57'),(2738,7908,752,40720,1542,15,68,2,3847379.44,NULL,'2023-11-24 18:56:41','2024-11-13 12:42:57','2024-11-13 12:42:57'),(2739,7908,752,40720,1542,15,353,2,131685.77,NULL,'2023-11-24 18:56:41','2024-11-13 12:42:57','2024-11-13 12:42:57'),(2740,7908,752,40720,1542,15,354,2,4953.78,NULL,'2023-11-24 18:56:41','2024-11-13 12:42:57','2024-11-13 12:42:57'),(2741,7908,752,40720,1542,15,74,2,59609.76,NULL,'2023-11-24 18:56:41','2024-11-13 12:42:57','2024-11-13 12:42:57'),(2742,7908,753,40720,1543,3,217,1,102972.79,NULL,'2023-11-30 19:59:44','2023-11-30 19:59:44',NULL),(2743,7908,753,40720,1543,3,68,1,21624.29,NULL,'2023-11-30 19:59:44','2023-11-30 19:59:44',NULL),(2744,7908,753,40720,1543,3,57,2,124597.08,NULL,'2023-11-30 19:59:44','2023-11-30 19:59:44',NULL),(2745,7908,754,40720,1543,3,217,1,731630.14,NULL,'2023-11-30 19:59:44','2024-11-13 12:53:25','2024-11-13 12:53:25'),(2746,7908,754,40720,1543,3,68,1,153642.33,NULL,'2023-11-30 19:59:44','2024-11-13 12:53:25','2024-11-13 12:53:25'),(2747,7908,754,40720,1543,3,57,2,885272.47,NULL,'2023-11-30 19:59:44','2024-11-13 12:53:25','2024-11-13 12:53:25'),(2748,7908,755,40720,1543,3,217,1,720370.00,NULL,'2023-11-30 19:59:44','2024-11-13 12:53:10','2024-11-13 12:53:10'),(2749,7908,755,40720,1543,3,68,1,151277.70,NULL,'2023-11-30 19:59:44','2024-11-13 12:53:10','2024-11-13 12:53:10'),(2750,7908,755,40720,1543,3,57,2,871647.70,NULL,'2023-11-30 19:59:44','2024-11-13 12:53:10','2024-11-13 12:53:10'),(2751,7908,756,40720,1543,3,217,1,784689.00,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:53','2024-11-13 12:52:53'),(2752,7908,756,40720,1543,3,68,1,164784.69,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:53','2024-11-13 12:52:53'),(2753,7908,756,40720,1543,3,57,2,949473.69,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:53','2024-11-13 12:52:53'),(2754,7908,757,40720,1543,3,217,1,897183.00,NULL,'2023-11-30 19:59:45','2024-11-13 12:51:11','2024-11-13 12:51:11'),(2755,7908,757,40720,1543,3,68,1,188408.43,NULL,'2023-11-30 19:59:45','2024-11-13 12:51:11','2024-11-13 12:51:11'),(2756,7908,757,40720,1543,3,57,2,1085591.43,NULL,'2023-11-30 19:59:45','2024-11-13 12:51:11','2024-11-13 12:51:11'),(2757,7908,758,40720,1543,3,217,1,618970.00,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:37','2024-11-13 12:52:37'),(2758,7908,758,40720,1543,3,68,1,129983.70,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:37','2024-11-13 12:52:37'),(2759,7908,758,40720,1543,3,57,2,748953.70,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:37','2024-11-13 12:52:37'),(2760,7908,759,40720,1543,3,217,1,636740.00,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:19','2024-11-13 12:52:19');
INSERT INTO `balance_libro_details` VALUES (2761,7908,759,40720,1543,3,68,1,133715.40,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:19','2024-11-13 12:52:19'),(2762,7908,759,40720,1543,3,57,2,770455.40,NULL,'2023-11-30 19:59:45','2024-11-13 12:52:19','2024-11-13 12:52:19'),(2763,7908,760,40720,1543,3,217,1,906957.00,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:58','2024-11-13 12:50:58'),(2764,7908,760,40720,1543,3,68,1,190460.97,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:58','2024-11-13 12:50:58'),(2765,7908,760,40720,1543,3,57,2,1097417.97,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:58','2024-11-13 12:50:58'),(2766,7908,761,40720,1543,3,217,1,917648.00,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:38','2024-11-13 12:50:38'),(2767,7908,761,40720,1543,3,68,1,192706.08,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:38','2024-11-13 12:50:38'),(2768,7908,761,40720,1543,3,57,2,1110354.08,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:38','2024-11-13 12:50:38'),(2769,7908,762,40720,1543,3,217,1,928670.00,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:19','2024-11-13 12:50:19'),(2770,7908,762,40720,1543,3,68,1,195020.70,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:19','2024-11-13 12:50:19'),(2771,7908,762,40720,1543,3,57,2,1123690.70,NULL,'2023-11-30 19:59:45','2024-11-13 12:50:19','2024-11-13 12:50:19'),(2772,7908,763,40720,1543,3,217,1,20454.52,NULL,'2023-11-30 19:59:45','2023-11-30 19:59:45',NULL),(2773,7908,763,40720,1543,3,68,1,4295.45,NULL,'2023-11-30 19:59:45','2023-11-30 19:59:45',NULL),(2774,7908,763,40720,1543,3,217,1,0.02,NULL,'2023-11-30 19:59:45','2023-11-30 19:59:45',NULL),(2775,7908,763,40720,1543,3,57,2,24749.99,NULL,'2023-11-30 19:59:45','2023-11-30 19:59:45',NULL),(2776,7908,764,40720,1543,3,217,1,23561.88,NULL,'2023-12-04 11:59:15','2023-12-04 11:59:15',NULL),(2777,7908,764,40720,1543,3,68,1,4947.99,NULL,'2023-12-04 11:59:15','2023-12-04 11:59:15',NULL),(2778,7908,764,40720,1543,3,221,1,1494.13,NULL,'2023-12-04 11:59:15','2023-12-04 11:59:15',NULL),(2779,7908,764,40720,1543,3,57,2,30004.00,NULL,'2023-12-04 11:59:15','2023-12-04 11:59:15',NULL),(2780,7908,765,40720,1543,3,217,1,15708.40,NULL,'2023-12-04 12:00:17','2023-12-04 12:00:17',NULL),(2781,7908,765,40720,1543,3,68,1,3298.76,NULL,'2023-12-04 12:00:17','2023-12-04 12:00:17',NULL),(2782,7908,765,40720,1543,3,221,1,996.12,NULL,'2023-12-04 12:00:17','2023-12-04 12:00:17',NULL),(2783,7908,765,40720,1543,3,57,2,20003.28,NULL,'2023-12-04 12:00:17','2023-12-04 12:00:17',NULL),(2784,7908,766,40720,1543,3,217,1,39047.64,NULL,'2023-12-04 12:01:23','2023-12-04 12:01:23',NULL),(2785,7908,766,40720,1543,3,68,1,8200.00,NULL,'2023-12-04 12:01:23','2023-12-04 12:01:23',NULL),(2786,7908,766,40720,1543,3,221,1,2755.16,NULL,'2023-12-04 12:01:23','2023-12-04 12:01:23',NULL),(2787,7908,766,40720,1543,3,57,2,50002.80,NULL,'2023-12-04 12:01:23','2023-12-04 12:01:23',NULL),(2788,7908,767,40720,1543,3,217,1,11925.27,NULL,'2023-12-04 12:02:13','2023-12-04 12:02:13',NULL),(2789,7908,767,40720,1543,3,68,1,2504.31,NULL,'2023-12-04 12:02:13','2023-12-04 12:02:13',NULL),(2790,7908,767,40720,1543,3,221,1,571.41,NULL,'2023-12-04 12:02:13','2023-12-04 12:02:13',NULL),(2791,7908,767,40720,1543,3,57,2,15000.99,NULL,'2023-12-04 12:02:13','2023-12-04 12:02:13',NULL),(2792,7908,768,40720,1543,3,217,1,14994.09,NULL,'2023-12-04 12:03:20','2023-12-04 12:03:20',NULL),(2793,7908,768,40720,1543,3,68,1,3148.76,NULL,'2023-12-04 12:03:20','2023-12-04 12:03:20',NULL),(2794,7908,768,40720,1543,3,221,1,1157.13,NULL,'2023-12-04 12:03:20','2023-12-04 12:03:20',NULL),(2795,7908,768,40720,1543,3,57,2,19299.98,NULL,'2023-12-04 12:03:20','2023-12-04 12:03:20',NULL),(2796,7908,769,40720,1543,3,217,1,26112.65,NULL,'2023-12-04 12:04:43','2023-12-04 12:04:43',NULL),(2797,7908,769,40720,1543,3,68,1,5483.66,NULL,'2023-12-04 12:04:43','2023-12-04 12:04:43',NULL),(2798,7908,769,40720,1543,3,221,1,1416.29,NULL,'2023-12-04 12:04:43','2023-12-04 12:04:43',NULL),(2799,7908,769,40720,1543,3,57,2,33012.60,NULL,'2023-12-04 12:04:43','2023-12-04 12:04:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2800,7908,770,40720,1543,3,217,1,47741.03,NULL,'2023-12-04 12:05:53','2023-12-04 12:05:53',NULL),(2801,7908,770,40720,1543,3,68,1,10025.62,NULL,'2023-12-04 12:05:53','2023-12-04 12:05:53',NULL),(2802,7908,770,40720,1543,3,221,1,2287.56,NULL,'2023-12-04 12:05:53','2023-12-04 12:05:53',NULL),(2803,7908,770,40720,1543,3,57,2,60054.21,NULL,'2023-12-04 12:05:53','2023-12-04 12:05:53',NULL),(2804,7908,771,40720,1543,3,217,1,63596.94,NULL,'2023-12-04 12:07:48','2023-12-04 12:07:48',NULL),(2805,7908,771,40720,1543,3,68,1,13355.36,NULL,'2023-12-04 12:07:48','2023-12-04 12:07:48',NULL),(2806,7908,771,40720,1543,3,221,1,3071.32,NULL,'2023-12-04 12:07:48','2023-12-04 12:07:48',NULL),(2807,7908,771,40720,1543,3,57,2,80023.62,NULL,'2023-12-04 12:07:48','2023-12-04 12:07:48',NULL),(2808,7908,772,40720,1543,3,217,1,58040.60,NULL,'2023-12-04 12:08:59','2023-12-04 12:08:59',NULL),(2809,7908,772,40720,1543,3,68,1,12188.53,NULL,'2023-12-04 12:08:59','2023-12-04 12:08:59',NULL),(2810,7908,772,40720,1543,3,221,1,2781.08,NULL,'2023-12-04 12:08:59','2023-12-04 12:08:59',NULL),(2811,7908,772,40720,1543,3,57,2,73010.21,NULL,'2023-12-04 12:08:59','2023-12-04 12:08:59',NULL),(2812,7908,773,40720,1543,3,217,1,10817.97,NULL,'2023-12-04 12:09:48','2023-12-04 12:09:48',NULL),(2813,7908,773,40720,1543,3,68,1,2271.77,NULL,'2023-12-04 12:09:48','2023-12-04 12:09:48',NULL),(2814,7908,773,40720,1543,3,221,1,613.46,NULL,'2023-12-04 12:09:48','2023-12-04 12:09:48',NULL),(2815,7908,773,40720,1543,3,57,2,13703.20,NULL,'2023-12-04 12:09:48','2023-12-04 12:09:48',NULL),(2816,7908,774,40720,1543,3,217,1,33531.31,NULL,'2023-12-04 12:10:44','2023-12-04 12:10:44',NULL),(2817,7908,774,40720,1543,3,68,1,7041.58,NULL,'2023-12-04 12:10:44','2023-12-04 12:10:44',NULL),(2818,7908,774,40720,1543,3,221,1,2148.93,NULL,'2023-12-04 12:10:44','2023-12-04 12:10:44',NULL),(2819,7908,774,40720,1543,3,57,2,42721.82,NULL,'2023-12-04 12:10:44','2023-12-04 12:10:44',NULL),(2820,7908,775,40720,1543,3,217,1,5527.41,NULL,'2023-12-04 12:13:12','2023-12-04 12:13:12',NULL),(2821,7908,775,40720,1543,3,68,1,1160.76,NULL,'2023-12-04 12:13:12','2023-12-04 12:13:12',NULL),(2822,7908,775,40720,1543,3,221,1,313.44,NULL,'2023-12-04 12:13:12','2023-12-04 12:13:12',NULL),(2823,7908,775,40720,1543,3,57,2,7001.61,NULL,'2023-12-04 12:13:12','2023-12-04 12:13:12',NULL),(2824,7908,776,40720,1543,3,217,1,39768.14,NULL,'2023-12-04 12:14:12','2023-12-04 12:14:12',NULL),(2825,7908,776,40720,1543,3,68,1,8351.31,NULL,'2023-12-04 12:14:12','2023-12-04 12:14:12',NULL),(2826,7908,776,40720,1543,3,221,1,1905.53,NULL,'2023-12-04 12:14:12','2023-12-04 12:14:12',NULL),(2827,7908,776,40720,1543,3,57,2,50024.98,NULL,'2023-12-04 12:14:12','2023-12-04 12:14:12',NULL),(2828,7908,777,40720,1543,3,217,1,22022.13,NULL,'2023-12-04 12:15:10','2023-12-04 12:15:10',NULL),(2829,7908,777,40720,1543,3,68,1,4624.65,NULL,'2023-12-04 12:15:10','2023-12-04 12:15:10',NULL),(2830,7908,777,40720,1543,3,221,1,1055.22,NULL,'2023-12-04 12:15:10','2023-12-04 12:15:10',NULL),(2831,7908,777,40720,1543,3,57,2,27702.00,NULL,'2023-12-04 12:15:10','2023-12-04 12:15:10',NULL),(2832,7908,778,40720,1543,3,217,1,39755.52,NULL,'2023-12-04 12:16:21','2023-12-04 12:16:21',NULL),(2833,7908,778,40720,1543,3,68,1,8348.66,NULL,'2023-12-04 12:16:21','2023-12-04 12:16:21',NULL),(2834,7908,778,40720,1543,3,221,1,1904.93,NULL,'2023-12-04 12:16:21','2023-12-04 12:16:21',NULL),(2835,7908,778,40720,1543,3,57,2,50009.11,NULL,'2023-12-04 12:16:21','2023-12-04 12:16:21',NULL),(2836,7908,779,40720,1543,3,217,1,14327.02,NULL,'2023-12-04 12:17:34','2023-12-04 12:17:34',NULL),(2837,7908,779,40720,1543,3,68,1,3008.67,NULL,'2023-12-04 12:17:34','2023-12-04 12:17:34',NULL),(2838,7908,779,40720,1543,3,221,1,664.45,NULL,'2023-12-04 12:17:34','2023-12-04 12:17:34',NULL),(2839,7908,779,40720,1543,3,57,2,18000.14,NULL,'2023-12-04 12:17:34','2023-12-04 12:17:34',NULL),(2840,7908,780,40720,1543,3,217,1,11739.36,NULL,'2023-12-04 12:18:36','2023-12-04 12:18:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2841,7908,780,40720,1543,3,68,1,2465.27,NULL,'2023-12-04 12:18:36','2023-12-04 12:18:36',NULL),(2842,7908,780,40720,1543,3,221,1,795.49,NULL,'2023-12-04 12:18:36','2023-12-04 12:18:36',NULL),(2843,7908,780,40720,1543,3,57,2,15000.12,NULL,'2023-12-04 12:18:36','2023-12-04 12:18:36',NULL),(2844,7908,781,40720,1543,3,217,1,8032.19,NULL,'2023-12-04 12:20:11','2023-12-04 12:20:11',NULL),(2845,7908,781,40720,1543,3,68,1,1686.76,NULL,'2023-12-04 12:20:11','2023-12-04 12:20:11',NULL),(2846,7908,781,40720,1543,3,221,1,281.53,NULL,'2023-12-04 12:20:11','2023-12-04 12:20:11',NULL),(2847,7908,781,40720,1543,3,57,2,10000.48,NULL,'2023-12-04 12:20:11','2023-12-04 12:20:11',NULL),(2848,7908,782,40720,1543,3,217,1,11084.25,NULL,'2023-12-04 12:22:28','2023-12-04 12:22:28',NULL),(2849,7908,782,40720,1543,3,68,1,2327.69,NULL,'2023-12-04 12:22:28','2023-12-04 12:22:28',NULL),(2850,7908,782,40720,1543,3,221,1,388.50,NULL,'2023-12-04 12:22:28','2023-12-04 12:22:28',NULL),(2851,7908,782,40720,1543,3,57,2,13800.44,NULL,'2023-12-04 12:22:28','2023-12-04 12:22:28',NULL),(2852,7908,783,40720,1544,2,96,2,10301656.50,NULL,'2023-12-04 19:47:41','2023-12-04 19:47:41',NULL),(2853,7908,783,40720,1544,2,67,2,2163347.87,NULL,'2023-12-04 19:47:41','2023-12-04 19:47:41',NULL),(2854,7908,783,40720,1544,2,13,1,12465004.37,NULL,'2023-12-04 19:47:41','2023-12-04 19:47:41',NULL),(2855,7908,784,40720,1543,3,217,1,12644.63,NULL,'2023-12-13 11:25:45','2023-12-13 11:25:45',NULL),(2856,7908,784,40720,1543,3,68,1,2655.37,NULL,'2023-12-13 11:25:45','2023-12-13 11:25:45',NULL),(2857,7908,784,40720,1543,3,57,2,15300.00,NULL,'2023-12-13 11:25:45','2023-12-13 11:25:45',NULL),(2858,7908,785,40720,1543,3,217,1,9900.26,NULL,'2023-12-13 11:27:48','2023-12-13 11:27:48',NULL),(2859,7908,785,40720,1543,3,68,1,2079.05,NULL,'2023-12-13 11:27:48','2023-12-13 11:27:48',NULL),(2860,7908,785,40720,1543,3,221,1,634.48,NULL,'2023-12-13 11:27:48','2023-12-13 11:27:48',NULL),(2861,7908,785,40720,1543,3,57,2,12613.79,NULL,'2023-12-13 11:27:48','2023-12-13 11:27:48',NULL),(2862,7908,786,40720,1543,3,217,1,1404.96,NULL,'2023-12-13 11:29:45','2023-12-13 11:29:45',NULL),(2863,7908,786,40720,1543,3,68,1,295.04,NULL,'2023-12-13 11:29:45','2023-12-13 11:29:45',NULL),(2864,7908,786,40720,1543,3,57,2,1700.00,NULL,'2023-12-13 11:29:45','2023-12-13 11:29:45',NULL),(2865,7908,787,40720,1543,3,217,1,7851.24,NULL,'2023-12-13 11:32:52','2023-12-13 11:32:52',NULL),(2866,7908,787,40720,1543,3,68,1,1648.76,NULL,'2023-12-13 11:32:52','2023-12-13 11:32:52',NULL),(2867,7908,787,40720,1543,3,57,2,9500.00,NULL,'2023-12-13 11:32:52','2023-12-13 11:32:52',NULL),(2868,7908,788,40720,1543,15,67,1,2186777.25,NULL,'2023-12-13 19:41:59','2024-11-13 12:48:55','2024-11-13 12:48:55'),(2869,7908,788,40720,1543,15,68,2,2008328.96,NULL,'2023-12-13 19:41:59','2024-11-13 12:48:55','2024-11-13 12:48:55'),(2870,7908,788,40720,1543,15,74,2,178448.29,NULL,'2023-12-13 19:41:59','2024-11-13 12:48:55','2024-11-13 12:48:55'),(2871,7908,789,40720,1544,3,217,1,2654295.00,NULL,'2023-12-15 11:53:02','2023-12-15 11:54:40','2023-12-15 11:54:40'),(2872,7908,789,40720,1544,3,68,1,278700.98,NULL,'2023-12-15 11:53:02','2023-12-15 11:54:40','2023-12-15 11:54:40'),(2873,7908,789,40720,1544,3,217,1,19907.21,NULL,'2023-12-15 11:53:02','2023-12-15 11:54:40','2023-12-15 11:54:40'),(2874,7908,789,40720,1544,3,57,2,2952903.19,NULL,'2023-12-15 11:53:02','2023-12-15 11:54:40','2023-12-15 11:54:40'),(2875,7908,790,40720,1544,3,217,1,35537.19,NULL,'2023-12-15 11:53:02','2023-12-15 11:53:02',NULL),(2876,7908,790,40720,1544,3,68,1,7462.81,NULL,'2023-12-15 11:53:02','2023-12-15 11:53:02',NULL),(2877,7908,790,40720,1544,3,57,2,43000.00,NULL,'2023-12-15 11:53:02','2023-12-15 11:53:02',NULL),(2878,7908,791,40720,1544,3,217,1,118250.20,NULL,'2023-12-15 11:53:02','2023-12-15 11:55:31','2023-12-15 11:55:31'),(2879,7908,791,40720,1544,3,68,1,24832.54,NULL,'2023-12-15 11:53:02','2023-12-15 11:55:31','2023-12-15 11:55:31');
INSERT INTO `balance_libro_details` VALUES (2880,7908,791,40720,1544,3,217,1,886.88,NULL,'2023-12-15 11:53:02','2023-12-15 11:55:31','2023-12-15 11:55:31'),(2881,7908,791,40720,1544,3,57,2,143969.62,NULL,'2023-12-15 11:53:02','2023-12-15 11:55:31','2023-12-15 11:55:31'),(2882,7908,792,40720,1544,3,217,1,5578.51,NULL,'2023-12-15 11:53:02','2023-12-15 11:53:02',NULL),(2883,7908,792,40720,1544,3,68,1,1171.49,NULL,'2023-12-15 11:53:02','2023-12-15 11:53:02',NULL),(2884,7908,792,40720,1544,3,57,2,6750.00,NULL,'2023-12-15 11:53:02','2023-12-15 11:53:02',NULL),(2885,7908,793,40720,1544,3,217,1,2654295.00,NULL,'2023-12-15 11:54:40','2023-12-15 11:54:40',NULL),(2886,7908,793,40720,1544,3,68,1,278700.98,NULL,'2023-12-15 11:54:40','2023-12-15 11:54:40',NULL),(2887,7908,793,40720,1544,3,57,2,2932995.98,NULL,'2023-12-15 11:54:40','2023-12-15 11:54:40',NULL),(2888,7908,794,40720,1544,3,217,1,118250.20,NULL,'2023-12-15 11:55:31','2023-12-15 11:55:31',NULL),(2889,7908,794,40720,1544,3,68,1,24832.54,NULL,'2023-12-15 11:55:31','2023-12-15 11:55:31',NULL),(2890,7908,794,40720,1544,3,57,2,143082.74,NULL,'2023-12-15 11:55:31','2023-12-15 11:55:31',NULL),(2891,7908,795,40720,1544,3,217,1,16917.46,NULL,'2023-12-26 19:43:59','2023-12-26 19:43:59',NULL),(2892,7908,795,40720,1544,3,68,1,3552.67,NULL,'2023-12-26 19:43:59','2023-12-26 19:43:59',NULL),(2893,7908,795,40720,1544,3,57,2,20470.13,NULL,'2023-12-26 19:43:59','2023-12-26 19:43:59',NULL),(2894,7908,796,40720,1544,3,217,1,14876.03,NULL,'2023-12-26 19:43:59','2023-12-26 19:43:59',NULL),(2895,7908,796,40720,1544,3,68,1,3123.97,NULL,'2023-12-26 19:43:59','2023-12-26 19:43:59',NULL),(2896,7908,796,40720,1544,3,57,2,18000.00,NULL,'2023-12-26 19:43:59','2023-12-26 19:43:59',NULL),(2897,7908,797,40720,1544,3,217,1,44828.00,NULL,'2023-12-26 19:43:59','2024-02-07 12:38:07','2024-02-07 12:38:07'),(2898,7908,797,40720,1544,3,68,1,9413.88,NULL,'2023-12-26 19:43:59','2024-02-07 12:38:07','2024-02-07 12:38:07'),(2899,7908,797,40720,1544,3,217,1,0.42,NULL,'2023-12-26 19:43:59','2024-02-07 12:38:07','2024-02-07 12:38:07'),(2900,7908,797,40720,1544,3,57,2,54578.09,NULL,'2023-12-26 19:43:59','2024-02-07 12:38:07','2024-02-07 12:38:07'),(2901,7908,797,40720,1544,3,136,1,335.79,NULL,'2023-12-26 19:43:59','2024-02-07 12:38:07','2024-02-07 12:38:07'),(2902,7908,798,40720,1544,3,217,1,64360.20,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:42','2024-02-07 12:37:42'),(2903,7908,798,40720,1544,3,68,1,13512.44,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:42','2024-02-07 12:37:42'),(2904,7908,798,40720,1544,3,217,1,0.60,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:42','2024-02-07 12:37:42'),(2905,7908,798,40720,1544,3,57,2,78352.94,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:42','2024-02-07 12:37:42'),(2906,7908,798,40720,1544,3,136,1,479.70,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:42','2024-02-07 12:37:42'),(2907,7908,799,40720,1544,3,217,1,272170.00,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:14','2024-02-07 12:37:14'),(2908,7908,799,40720,1544,3,68,1,57155.70,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:14','2024-02-07 12:37:14'),(2909,7908,799,40720,1544,3,217,1,2.55,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:14','2024-02-07 12:37:14'),(2910,7908,799,40720,1544,3,57,2,331366.98,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:14','2024-02-07 12:37:14'),(2911,7908,799,40720,1544,3,136,1,2038.73,NULL,'2023-12-26 19:43:59','2024-02-07 12:37:14','2024-02-07 12:37:14'),(2912,7908,800,40720,1544,3,217,1,780991.74,NULL,'2023-12-26 19:44:00','2023-12-26 19:44:00',NULL),(2913,7908,800,40720,1544,3,68,1,164008.26,NULL,'2023-12-26 19:44:00','2023-12-26 19:44:00',NULL),(2914,7908,800,40720,1544,3,57,2,945000.00,NULL,'2023-12-26 19:44:00','2023-12-26 19:44:00',NULL),(2915,7908,801,40720,1544,3,217,1,14958.73,NULL,'2023-12-26 19:44:00','2024-02-07 12:33:52','2024-02-07 12:33:52'),(2916,7908,801,40720,1544,3,68,1,3141.33,NULL,'2023-12-26 19:44:00','2024-02-07 12:33:52','2024-02-07 12:33:52');
INSERT INTO `balance_libro_details` VALUES (2917,7908,801,40720,1544,3,217,1,0.01,NULL,'2023-12-26 19:44:00','2024-02-07 12:33:52','2024-02-07 12:33:52'),(2918,7908,801,40720,1544,3,57,2,18100.07,NULL,'2023-12-26 19:44:00','2024-02-07 12:33:52','2024-02-07 12:33:52'),(2919,7908,802,40720,1544,3,217,1,550449.00,NULL,'2023-12-27 18:26:03','2023-12-27 18:29:28','2023-12-27 18:29:28'),(2920,7908,802,40720,1544,3,68,1,115594.29,NULL,'2023-12-27 18:26:03','2023-12-27 18:29:28','2023-12-27 18:29:28'),(2921,7908,802,40720,1544,3,217,1,5.13,NULL,'2023-12-27 18:26:03','2023-12-27 18:29:28','2023-12-27 18:29:28'),(2922,7908,802,40720,1544,3,57,2,670171.66,NULL,'2023-12-27 18:26:03','2023-12-27 18:29:28','2023-12-27 18:29:28'),(2923,7908,802,40720,1544,3,136,1,4123.24,NULL,'2023-12-27 18:26:03','2023-12-27 18:29:28','2023-12-27 18:29:28'),(2924,7908,803,40720,1544,3,217,1,1420786.13,NULL,'2023-12-27 18:26:04','2023-12-27 18:29:00','2023-12-27 18:29:00'),(2925,7908,803,40720,1544,3,68,1,298369.11,NULL,'2023-12-27 18:26:04','2023-12-27 18:29:00','2023-12-27 18:29:00'),(2926,7908,803,40720,1544,3,217,1,13.24,NULL,'2023-12-27 18:26:04','2023-12-27 18:29:00','2023-12-27 18:29:00'),(2927,7908,803,40720,1544,3,57,2,1729810.13,NULL,'2023-12-27 18:26:04','2023-12-27 18:29:00','2023-12-27 18:29:00'),(2928,7908,803,40720,1544,3,136,1,10641.65,NULL,'2023-12-27 18:26:04','2023-12-27 18:29:00','2023-12-27 18:29:00'),(2929,7908,804,40720,1544,3,217,1,202797.00,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:30','2023-12-27 18:28:30'),(2930,7908,804,40720,1544,3,68,1,42587.37,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:30','2023-12-27 18:28:30'),(2931,7908,804,40720,1544,3,217,1,1.89,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:30','2023-12-27 18:28:30'),(2932,7908,804,40720,1544,3,57,2,246905.35,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:30','2023-12-27 18:28:30'),(2933,7908,804,40720,1544,3,136,1,1519.09,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:30','2023-12-27 18:28:30'),(2934,7908,805,40720,1544,3,217,1,460638.90,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:03','2023-12-27 18:28:03'),(2935,7908,805,40720,1544,3,68,1,96730.95,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:03','2023-12-27 18:28:03'),(2936,7908,805,40720,1544,3,217,1,4.29,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:03','2023-12-27 18:28:03'),(2937,7908,805,40720,1544,3,57,2,560822.23,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:03','2023-12-27 18:28:03'),(2938,7908,805,40720,1544,3,136,1,3448.09,NULL,'2023-12-27 18:26:04','2023-12-27 18:28:03','2023-12-27 18:28:03'),(2939,7908,806,40720,1544,3,217,1,460638.90,NULL,'2023-12-27 18:28:03','2024-02-07 12:18:57','2024-02-07 12:18:57'),(2940,7908,806,40720,1544,3,68,1,96734.17,NULL,'2023-12-27 18:28:03','2024-02-07 12:18:57','2024-02-07 12:18:57'),(2941,7908,806,40720,1544,3,57,2,557373.07,NULL,'2023-12-27 18:28:03','2024-02-07 12:18:57','2024-02-07 12:18:57'),(2942,7908,807,40720,1544,3,217,1,202797.00,NULL,'2023-12-27 18:28:30','2023-12-27 18:28:30',NULL),(2943,7908,807,40720,1544,3,68,1,42587.37,NULL,'2023-12-27 18:28:30','2023-12-27 18:28:30',NULL),(2944,7908,807,40720,1544,3,57,2,245384.37,NULL,'2023-12-27 18:28:30','2023-12-27 18:28:30',NULL),(2945,7908,808,40720,1544,3,217,1,1420786.13,NULL,'2023-12-27 18:29:00','2023-12-27 18:29:00',NULL),(2946,7908,808,40720,1544,3,68,1,298365.09,NULL,'2023-12-27 18:29:00','2023-12-27 18:29:00',NULL),(2947,7908,808,40720,1544,3,57,2,1719151.22,NULL,'2023-12-27 18:29:00','2023-12-27 18:29:00',NULL),(2948,7908,809,40720,1544,3,217,1,550449.00,NULL,'2023-12-27 18:29:28','2023-12-27 18:29:28',NULL),(2949,7908,809,40720,1544,3,68,1,115594.29,NULL,'2023-12-27 18:29:28','2023-12-27 18:29:28',NULL),(2950,7908,809,40720,1544,3,57,2,666043.29,NULL,'2023-12-27 18:29:28','2023-12-27 18:29:28',NULL),(2951,7908,810,40720,1544,3,217,1,1173223.14,NULL,'2023-12-28 21:33:47','2023-12-28 21:33:47',NULL),(2952,7908,810,40720,1544,3,68,1,246376.86,NULL,'2023-12-28 21:33:47','2023-12-28 21:33:47',NULL);
INSERT INTO `balance_libro_details` VALUES (2953,7908,810,40720,1544,3,57,2,1419600.00,NULL,'2023-12-28 21:33:47','2023-12-28 21:33:47',NULL),(2954,7908,811,40720,1544,3,217,1,16528.93,NULL,'2023-12-28 21:33:47','2023-12-28 21:33:47',NULL),(2955,7908,811,40720,1544,3,68,1,3471.07,NULL,'2023-12-28 21:33:47','2023-12-28 21:33:47',NULL),(2956,7908,811,40720,1544,3,57,2,20000.00,NULL,'2023-12-28 21:33:47','2023-12-28 21:33:47',NULL),(2957,7908,812,40720,1548,2,96,2,10785127.50,NULL,'2024-01-03 12:10:49','2024-01-03 12:10:49',NULL),(2958,7908,812,40720,1548,2,67,2,2264876.77,NULL,'2024-01-03 12:10:49','2024-01-03 12:10:49',NULL),(2959,7908,812,40720,1548,2,13,1,13050004.27,NULL,'2024-01-03 12:10:49','2024-01-03 12:10:49',NULL),(2960,7908,813,40720,1548,2,96,2,23140500.00,NULL,'2024-01-18 10:04:12','2024-01-18 10:04:12',NULL),(2961,7908,813,40720,1548,2,67,2,4859505.00,NULL,'2024-01-18 10:04:12','2024-01-18 10:04:12',NULL),(2962,7908,813,40720,1548,2,13,1,28000005.00,NULL,'2024-01-18 10:04:12','2024-01-18 10:04:12',NULL),(2963,7908,814,40720,1548,3,217,1,363636.36,NULL,'2024-01-27 20:59:21','2024-01-27 20:59:21',NULL),(2964,7908,814,40720,1548,3,68,1,76363.64,NULL,'2024-01-27 20:59:21','2024-01-27 20:59:21',NULL),(2965,7908,814,40720,1548,3,57,2,440000.00,NULL,'2024-01-27 20:59:21','2024-01-27 20:59:21',NULL),(2966,7908,815,40720,1548,3,217,1,14876.03,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2967,7908,815,40720,1548,3,68,1,3123.97,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2968,7908,815,40720,1548,3,57,2,18000.00,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2969,7908,816,40720,1548,3,217,1,29752.07,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2970,7908,816,40720,1548,3,68,1,6247.93,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2971,7908,816,40720,1548,3,57,2,36000.00,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2972,7908,817,40720,1548,3,217,1,14049.59,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2973,7908,817,40720,1548,3,68,1,2950.41,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2974,7908,817,40720,1548,3,57,2,17000.00,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2975,7908,818,40720,1548,3,217,1,411570.25,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2976,7908,818,40720,1548,3,68,1,86429.75,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2977,7908,818,40720,1548,3,57,2,498000.00,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2978,7908,819,40720,1548,3,217,1,22587330.32,NULL,'2024-01-27 20:59:22','2024-04-23 22:13:12','2024-04-23 22:13:12'),(2979,7908,819,40720,1548,3,68,1,2371669.68,NULL,'2024-01-27 20:59:22','2024-04-23 22:13:12','2024-04-23 22:13:12'),(2980,7908,819,40720,1548,3,57,2,24959000.00,NULL,'2024-01-27 20:59:22','2024-04-23 22:13:12','2024-04-23 22:13:12'),(2981,7908,820,40720,1548,3,217,1,505975.21,NULL,'2024-01-27 20:59:22','2024-04-23 22:12:12','2024-04-23 22:12:12'),(2982,7908,820,40720,1548,3,68,1,106254.79,NULL,'2024-01-27 20:59:22','2024-04-23 22:12:12','2024-04-23 22:12:12'),(2983,7908,820,40720,1548,3,217,1,37770.00,NULL,'2024-01-27 20:59:22','2024-04-23 22:12:12','2024-04-23 22:12:12'),(2984,7908,820,40720,1548,3,57,2,650000.00,NULL,'2024-01-27 20:59:22','2024-04-23 22:12:12','2024-04-23 22:12:12'),(2985,7908,821,40720,1548,3,217,1,98908.28,NULL,'2024-01-27 20:59:22','2024-01-27 21:00:30','2024-01-27 21:00:30'),(2986,7908,821,40720,1548,3,68,1,20770.74,NULL,'2024-01-27 20:59:22','2024-01-27 21:00:30','2024-01-27 21:00:30'),(2987,7908,821,40720,1548,3,217,1,2967.25,NULL,'2024-01-27 20:59:22','2024-01-27 21:00:30','2024-01-27 21:00:30'),(2988,7908,821,40720,1548,3,57,2,122646.27,NULL,'2024-01-27 20:59:22','2024-01-27 21:00:30','2024-01-27 21:00:30'),(2989,7908,822,40720,1548,3,217,1,72727.27,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2990,7908,822,40720,1548,3,68,1,15272.73,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL);
INSERT INTO `balance_libro_details` VALUES (2991,7908,822,40720,1548,3,57,2,88000.00,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2992,7908,823,40720,1548,3,217,1,45876.03,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2993,7908,823,40720,1548,3,68,1,9633.97,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2994,7908,823,40720,1548,3,57,2,55510.00,NULL,'2024-01-27 20:59:22','2024-01-27 20:59:22',NULL),(2995,7908,824,40720,1548,3,217,1,98908.28,NULL,'2024-01-27 21:00:30','2024-01-27 21:00:45','2024-01-27 21:00:45'),(2996,7908,824,40720,1548,3,68,1,20770.74,NULL,'2024-01-27 21:00:30','2024-01-27 21:00:45','2024-01-27 21:00:45'),(2997,7908,824,40720,1548,3,57,2,119679.02,NULL,'2024-01-27 21:00:30','2024-01-27 21:00:45','2024-01-27 21:00:45'),(2998,7908,825,40720,1548,3,217,1,98908.28,NULL,'2024-01-27 21:00:45','2024-01-27 21:00:45',NULL),(2999,7908,825,40720,1548,3,68,1,20770.74,NULL,'2024-01-27 21:00:45','2024-01-27 21:00:45',NULL),(3000,7908,825,40720,1548,3,57,2,119679.02,NULL,'2024-01-27 21:00:45','2024-01-27 21:00:45',NULL),(3001,7908,826,40720,1548,3,217,1,16101.62,NULL,'2024-01-29 11:36:42','2024-01-29 11:36:42',NULL),(3002,7908,826,40720,1548,3,68,1,3381.34,NULL,'2024-01-29 11:36:42','2024-01-29 11:36:42',NULL),(3003,7908,826,40720,1548,3,221,1,515.68,NULL,'2024-01-29 11:36:42','2024-01-29 11:36:42',NULL),(3004,7908,826,40720,1548,3,57,2,19998.64,NULL,'2024-01-29 11:36:42','2024-01-29 11:36:42',NULL),(3005,7908,827,40720,1548,3,217,1,37107.43,NULL,'2024-01-29 11:39:01','2024-01-29 11:39:01',NULL),(3006,7908,827,40720,1548,3,68,1,7792.56,NULL,'2024-01-29 11:39:01','2024-01-29 11:39:01',NULL),(3007,7908,827,40720,1548,3,57,2,44899.99,NULL,'2024-01-29 11:39:01','2024-01-29 11:39:01',NULL),(3008,7908,828,40720,1548,3,217,1,40399.31,NULL,'2024-01-29 11:42:12','2024-01-29 11:42:12',NULL),(3009,7908,828,40720,1548,3,68,1,8483.86,NULL,'2024-01-29 11:42:12','2024-01-29 11:42:12',NULL),(3010,7908,828,40720,1548,3,221,1,981.81,NULL,'2024-01-29 11:42:12','2024-01-29 11:42:12',NULL),(3011,7908,828,40720,1548,3,57,2,49864.98,NULL,'2024-01-29 11:42:12','2024-01-29 11:42:12',NULL),(3012,7908,829,40720,1548,3,217,1,42144.45,NULL,'2024-01-29 11:43:48','2024-01-29 11:43:48',NULL),(3013,7908,829,40720,1548,3,68,1,8850.33,NULL,'2024-01-29 11:43:48','2024-01-29 11:43:48',NULL),(3014,7908,829,40720,1548,3,221,1,1024.23,NULL,'2024-01-29 11:43:48','2024-01-29 11:43:48',NULL),(3015,7908,829,40720,1548,3,57,2,52019.01,NULL,'2024-01-29 11:43:48','2024-01-29 11:43:48',NULL),(3016,7908,830,40720,1548,3,217,1,46196.15,NULL,'2024-01-29 11:45:22','2024-01-29 11:45:22',NULL),(3017,7908,830,40720,1548,3,68,1,9701.19,NULL,'2024-01-29 11:45:22','2024-01-29 11:45:22',NULL),(3018,7908,830,40720,1548,3,221,1,1122.69,NULL,'2024-01-29 11:45:22','2024-01-29 11:45:22',NULL),(3019,7908,830,40720,1548,3,57,2,57020.03,NULL,'2024-01-29 11:45:22','2024-01-29 11:45:22',NULL),(3020,7908,831,40720,1548,3,217,1,38170.42,NULL,'2024-01-29 11:46:55','2024-01-29 11:46:55',NULL),(3021,7908,831,40720,1548,3,68,1,8015.79,NULL,'2024-01-29 11:46:55','2024-01-29 11:46:55',NULL),(3022,7908,831,40720,1548,3,222,1,956.83,NULL,'2024-01-29 11:46:55','2024-01-29 11:46:55',NULL),(3023,7908,831,40720,1548,3,57,2,47143.04,NULL,'2024-01-29 11:46:55','2024-01-29 11:46:55',NULL),(3024,7908,832,40720,1548,3,217,1,24276.30,NULL,'2024-01-29 11:48:27','2024-01-29 11:48:27',NULL),(3025,7908,832,40720,1548,3,68,1,5098.02,NULL,'2024-01-29 11:48:27','2024-01-29 11:48:27',NULL),(3026,7908,832,40720,1548,3,221,1,621.69,NULL,'2024-01-29 11:48:27','2024-01-29 11:48:27',NULL),(3027,7908,832,40720,1548,3,57,2,29996.01,NULL,'2024-01-29 11:48:27','2024-01-29 11:48:27',NULL),(3028,7908,833,40720,1548,3,217,1,15514.17,NULL,'2024-01-29 11:49:15','2024-01-29 11:49:15',NULL),(3029,7908,833,40720,1548,3,68,1,3257.98,NULL,'2024-01-29 11:49:15','2024-01-29 11:49:15',NULL),(3030,7908,833,40720,1548,3,222,1,626.83,NULL,'2024-01-29 11:49:15','2024-01-29 11:49:15',NULL);
INSERT INTO `balance_libro_details` VALUES (3031,7908,833,40720,1548,3,57,2,19398.98,NULL,'2024-01-29 11:49:15','2024-01-29 11:49:15',NULL),(3032,7908,834,40720,1548,3,217,1,81265.42,NULL,'2024-01-29 11:50:57','2024-01-29 11:50:57',NULL),(3033,7908,834,40720,1548,3,68,1,17065.74,NULL,'2024-01-29 11:50:57','2024-01-29 11:50:57',NULL),(3034,7908,834,40720,1548,3,221,1,1667.80,NULL,'2024-01-29 11:50:57','2024-01-29 11:50:57',NULL),(3035,7908,834,40720,1548,3,57,2,99998.96,NULL,'2024-01-29 11:50:57','2024-01-29 11:50:57',NULL),(3036,7908,835,40720,1548,3,217,1,46320.11,NULL,'2024-01-29 11:52:07','2024-01-29 11:52:07',NULL),(3037,7908,835,40720,1548,3,68,1,9727.22,NULL,'2024-01-29 11:52:07','2024-01-29 11:52:07',NULL),(3038,7908,835,40720,1548,3,221,1,1125.71,NULL,'2024-01-29 11:52:07','2024-01-29 11:52:07',NULL),(3039,7908,835,40720,1548,3,57,2,57173.04,NULL,'2024-01-29 11:52:07','2024-01-29 11:52:07',NULL),(3040,7908,836,40720,1548,3,217,1,95270.66,NULL,'2024-01-29 11:53:28','2024-01-29 11:53:28',NULL),(3041,7908,836,40720,1548,3,68,1,20006.84,NULL,'2024-01-29 11:53:28','2024-01-29 11:53:28',NULL),(3042,7908,836,40720,1548,3,221,1,2026.43,NULL,'2024-01-29 11:53:28','2024-01-29 11:53:28',NULL),(3043,7908,836,40720,1548,3,57,2,117303.93,NULL,'2024-01-29 11:53:28','2024-01-29 11:53:28',NULL),(3044,7908,837,40720,1548,3,217,1,28008.89,NULL,'2024-01-29 11:54:30','2024-01-29 11:54:30',NULL),(3045,7908,837,40720,1548,3,68,1,5881.87,NULL,'2024-01-29 11:54:30','2024-01-29 11:54:30',NULL),(3046,7908,837,40720,1548,3,221,1,717.28,NULL,'2024-01-29 11:54:30','2024-01-29 11:54:30',NULL),(3047,7908,837,40720,1548,3,57,2,34608.04,NULL,'2024-01-29 11:54:30','2024-01-29 11:54:30',NULL),(3048,7908,838,40720,1548,3,217,1,27920.64,NULL,'2024-01-29 11:55:23','2024-01-29 11:55:23',NULL),(3049,7908,838,40720,1548,3,68,1,5863.33,NULL,'2024-01-29 11:55:23','2024-01-29 11:55:23',NULL),(3050,7908,838,40720,1548,3,221,1,715.02,NULL,'2024-01-29 11:55:23','2024-01-29 11:55:23',NULL),(3051,7908,838,40720,1548,3,57,2,34498.99,NULL,'2024-01-29 11:55:23','2024-01-29 11:55:23',NULL),(3052,7908,839,40720,1548,3,217,1,14167.10,NULL,'2024-01-29 11:56:05','2024-01-29 11:56:05',NULL),(3053,7908,839,40720,1548,3,68,1,2975.09,NULL,'2024-01-29 11:56:05','2024-01-29 11:56:05',NULL),(3054,7908,839,40720,1548,3,221,1,362.80,NULL,'2024-01-29 11:56:05','2024-01-29 11:56:05',NULL),(3055,7908,839,40720,1548,3,57,2,17504.99,NULL,'2024-01-29 11:56:05','2024-01-29 11:56:05',NULL),(3056,7908,840,40720,1548,3,217,1,33821.31,NULL,'2024-01-29 11:57:43','2024-01-29 11:57:43',NULL),(3057,7908,840,40720,1548,3,68,1,7102.48,NULL,'2024-01-29 11:57:43','2024-01-29 11:57:43',NULL),(3058,7908,840,40720,1548,3,221,1,1083.18,NULL,'2024-01-29 11:57:43','2024-01-29 11:57:43',NULL),(3059,7908,840,40720,1548,3,57,2,42006.97,NULL,'2024-01-29 11:57:43','2024-01-29 11:57:43',NULL),(3060,7908,841,40720,1548,3,217,1,81279.27,NULL,'2024-01-29 11:58:48','2024-01-29 11:58:48',NULL),(3061,7908,841,40720,1548,3,68,1,17068.65,NULL,'2024-01-29 11:58:48','2024-01-29 11:58:48',NULL),(3062,7908,841,40720,1548,3,221,1,1668.08,NULL,'2024-01-29 11:58:48','2024-01-29 11:58:48',NULL),(3063,7908,841,40720,1548,3,57,2,100016.00,NULL,'2024-01-29 11:58:48','2024-01-29 11:58:48',NULL),(3064,7908,842,40720,1548,3,217,1,24298.11,NULL,'2024-01-29 11:59:37','2024-01-29 11:59:37',NULL),(3065,7908,842,40720,1548,3,68,1,5102.60,NULL,'2024-01-29 11:59:37','2024-01-29 11:59:37',NULL),(3066,7908,842,40720,1548,3,221,1,622.25,NULL,'2024-01-29 11:59:37','2024-01-29 11:59:37',NULL),(3067,7908,842,40720,1548,3,57,2,30022.96,NULL,'2024-01-29 11:59:37','2024-01-29 11:59:37',NULL),(3068,7908,843,40720,1548,3,217,1,24383.15,NULL,'2024-01-29 12:00:26','2024-01-29 12:00:26',NULL),(3069,7908,843,40720,1548,3,68,1,5120.46,NULL,'2024-01-29 12:00:26','2024-01-29 12:00:26',NULL),(3070,7908,843,40720,1548,3,221,1,500.41,NULL,'2024-01-29 12:00:26','2024-01-29 12:00:26',NULL),(3071,7908,843,40720,1548,3,57,2,30004.02,NULL,'2024-01-29 12:00:26','2024-01-29 12:00:26',NULL);
INSERT INTO `balance_libro_details` VALUES (3072,7908,844,40720,1548,3,217,1,81281.68,NULL,'2024-01-29 12:01:27','2024-01-29 12:01:27',NULL),(3073,7908,844,40720,1548,3,68,1,17069.15,NULL,'2024-01-29 12:01:27','2024-01-29 12:01:27',NULL),(3074,7908,844,40720,1548,3,221,1,1668.13,NULL,'2024-01-29 12:01:27','2024-01-29 12:01:27',NULL),(3075,7908,844,40720,1548,3,57,2,100018.96,NULL,'2024-01-29 12:01:27','2024-01-29 12:01:27',NULL),(3076,7908,845,40720,1548,3,217,1,32384.03,NULL,'2024-01-29 12:02:18','2024-01-29 12:02:18',NULL),(3077,7908,845,40720,1548,3,68,1,6800.65,NULL,'2024-01-29 12:02:18','2024-01-29 12:02:18',NULL),(3078,7908,845,40720,1548,3,221,1,829.32,NULL,'2024-01-29 12:02:18','2024-01-29 12:02:18',NULL),(3079,7908,845,40720,1548,3,57,2,40014.00,NULL,'2024-01-29 12:02:18','2024-01-29 12:02:18',NULL),(3080,7908,846,40720,1548,3,217,1,80951.17,NULL,'2024-01-29 12:03:22','2024-01-29 12:03:22',NULL),(3081,7908,846,40720,1548,3,68,1,16999.75,NULL,'2024-01-29 12:03:22','2024-01-29 12:03:22',NULL),(3082,7908,846,40720,1548,3,221,1,2073.07,NULL,'2024-01-29 12:03:22','2024-01-29 12:03:22',NULL),(3083,7908,846,40720,1548,3,57,2,100023.99,NULL,'2024-01-29 12:03:22','2024-01-29 12:03:22',NULL),(3084,7908,847,40720,1548,3,217,1,11996.90,NULL,'2024-01-29 12:04:19','2024-01-29 12:04:19',NULL),(3085,7908,847,40720,1548,3,68,1,2519.35,NULL,'2024-01-29 12:04:19','2024-01-29 12:04:19',NULL),(3086,7908,847,40720,1548,3,221,1,484.72,NULL,'2024-01-29 12:04:19','2024-01-29 12:04:19',NULL),(3087,7908,847,40720,1548,3,57,2,15000.97,NULL,'2024-01-29 12:04:19','2024-01-29 12:04:19',NULL),(3088,7908,848,40720,1548,3,217,1,32535.78,NULL,'2024-01-29 12:05:04','2024-01-29 12:05:04',NULL),(3089,7908,848,40720,1548,3,68,1,6832.51,NULL,'2024-01-29 12:05:04','2024-01-29 12:05:04',NULL),(3090,7908,848,40720,1548,3,221,1,667.73,NULL,'2024-01-29 12:05:04','2024-01-29 12:05:04',NULL),(3091,7908,848,40720,1548,3,57,2,40036.02,NULL,'2024-01-29 12:05:04','2024-01-29 12:05:04',NULL),(3092,7908,849,40720,1548,3,217,1,81338.28,NULL,'2024-01-29 12:07:40','2024-01-29 12:07:40',NULL),(3093,7908,849,40720,1548,3,68,1,17081.04,NULL,'2024-01-29 12:07:40','2024-01-29 12:07:40',NULL),(3094,7908,849,40720,1548,3,221,1,1624.64,NULL,'2024-01-29 12:07:40','2024-01-29 12:07:40',NULL),(3095,7908,849,40720,1548,3,57,2,100043.96,NULL,'2024-01-29 12:07:40','2024-01-29 12:07:40',NULL),(3096,7908,850,40720,1548,3,217,1,44590.36,NULL,'2024-01-29 12:08:24','2024-01-29 12:08:24',NULL),(3097,7908,850,40720,1548,3,68,1,9363.98,NULL,'2024-01-29 12:08:24','2024-01-29 12:08:24',NULL),(3098,7908,850,40720,1548,3,221,1,1083.67,NULL,'2024-01-29 12:08:24','2024-01-29 12:08:24',NULL),(3099,7908,850,40720,1548,3,57,2,55038.01,NULL,'2024-01-29 12:08:24','2024-01-29 12:08:24',NULL),(3100,7908,851,40720,1548,3,217,1,32526.67,NULL,'2024-01-29 12:09:39','2024-01-29 12:09:39',NULL),(3101,7908,851,40720,1548,3,68,1,6830.60,NULL,'2024-01-29 12:09:39','2024-01-29 12:09:39',NULL),(3102,7908,851,40720,1548,3,221,1,649.68,NULL,'2024-01-29 12:09:39','2024-01-29 12:09:39',NULL),(3103,7908,851,40720,1548,3,57,2,40006.95,NULL,'2024-01-29 12:09:39','2024-01-29 12:09:39',NULL),(3104,7908,852,40720,1548,3,217,1,296460.00,NULL,'2024-01-30 11:13:19','2024-01-30 11:21:35','2024-01-30 11:21:35'),(3105,7908,852,40720,1548,3,68,1,62256.60,NULL,'2024-01-30 11:13:19','2024-01-30 11:21:35','2024-01-30 11:21:35'),(3106,7908,852,40720,1548,3,217,1,2.70,NULL,'2024-01-30 11:13:19','2024-01-30 11:21:35','2024-01-30 11:21:35'),(3107,7908,852,40720,1548,3,57,2,360940.05,NULL,'2024-01-30 11:13:19','2024-01-30 11:21:35','2024-01-30 11:21:35'),(3108,7908,852,40720,1548,3,136,1,2220.75,NULL,'2024-01-30 11:13:19','2024-01-30 11:21:35','2024-01-30 11:21:35'),(3109,7908,853,40720,1548,3,217,1,237168.00,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:54','2024-01-30 11:20:54'),(3110,7908,853,40720,1548,3,68,1,49805.28,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:54','2024-01-30 11:20:54');
INSERT INTO `balance_libro_details` VALUES (3111,7908,853,40720,1548,3,217,1,2.16,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:54','2024-01-30 11:20:54'),(3112,7908,853,40720,1548,3,57,2,288752.04,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:54','2024-01-30 11:20:54'),(3113,7908,853,40720,1548,3,136,1,1776.60,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:54','2024-01-30 11:20:54'),(3114,7908,854,40720,1548,3,217,1,21559.23,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:17','2024-01-30 11:20:17'),(3115,7908,854,40720,1548,3,68,1,4529.25,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:17','2024-01-30 11:20:17'),(3116,7908,854,40720,1548,3,217,1,0.20,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:17','2024-01-30 11:20:17'),(3117,7908,854,40720,1548,3,57,2,26253.18,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:17','2024-01-30 11:20:17'),(3118,7908,854,40720,1548,3,136,1,164.50,NULL,'2024-01-30 11:13:20','2024-01-30 11:20:17','2024-01-30 11:20:17'),(3119,7908,855,40720,1548,3,217,1,138348.00,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:54','2024-01-30 11:19:54'),(3120,7908,855,40720,1548,3,68,1,29053.08,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:54','2024-01-30 11:19:54'),(3121,7908,855,40720,1548,3,217,1,1.26,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:54','2024-01-30 11:19:54'),(3122,7908,855,40720,1548,3,57,2,168438.69,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:54','2024-01-30 11:19:54'),(3123,7908,855,40720,1548,3,136,1,1036.35,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:54','2024-01-30 11:19:54'),(3124,7908,856,40720,1548,3,217,1,92232.00,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:24','2024-01-30 11:19:24'),(3125,7908,856,40720,1548,3,68,1,19368.72,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:24','2024-01-30 11:19:24'),(3126,7908,856,40720,1548,3,217,1,0.84,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:24','2024-01-30 11:19:24'),(3127,7908,856,40720,1548,3,57,2,112292.46,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:24','2024-01-30 11:19:24'),(3128,7908,856,40720,1548,3,136,1,690.90,NULL,'2024-01-30 11:13:20','2024-01-30 11:19:24','2024-01-30 11:19:24'),(3129,7908,857,40720,1548,3,217,1,70326.90,NULL,'2024-01-30 11:13:20','2024-01-30 11:18:59','2024-01-30 11:18:59'),(3130,7908,857,40720,1548,3,68,1,14765.36,NULL,'2024-01-30 11:13:20','2024-01-30 11:18:59','2024-01-30 11:18:59'),(3131,7908,857,40720,1548,3,217,1,0.64,NULL,'2024-01-30 11:13:20','2024-01-30 11:18:59','2024-01-30 11:18:59'),(3132,7908,857,40720,1548,3,57,2,85619.30,NULL,'2024-01-30 11:13:20','2024-01-30 11:18:59','2024-01-30 11:18:59'),(3133,7908,857,40720,1548,3,136,1,526.40,NULL,'2024-01-30 11:13:20','2024-01-30 11:18:59','2024-01-30 11:18:59'),(3134,7908,858,40720,1548,3,217,1,5023.35,NULL,'2024-01-30 11:13:20','2024-01-30 11:16:15','2024-01-30 11:16:15'),(3135,7908,858,40720,1548,3,68,1,1054.08,NULL,'2024-01-30 11:13:20','2024-01-30 11:16:15','2024-01-30 11:16:15'),(3136,7908,858,40720,1548,3,217,1,0.05,NULL,'2024-01-30 11:13:20','2024-01-30 11:16:15','2024-01-30 11:16:15'),(3137,7908,858,40720,1548,3,57,2,6118.61,NULL,'2024-01-30 11:13:20','2024-01-30 11:16:15','2024-01-30 11:16:15'),(3138,7908,858,40720,1548,3,136,1,41.13,NULL,'2024-01-30 11:13:20','2024-01-30 11:16:15','2024-01-30 11:16:15'),(3139,7908,859,40720,1548,3,217,1,464454.00,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:47','2024-01-30 11:15:47'),(3140,7908,859,40720,1548,3,68,1,97535.34,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:47','2024-01-30 11:15:47'),(3141,7908,859,40720,1548,3,217,1,4.23,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:47','2024-01-30 11:15:47'),(3142,7908,859,40720,1548,3,57,2,565472.75,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:47','2024-01-30 11:15:47'),(3143,7908,859,40720,1548,3,136,1,3479.18,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:47','2024-01-30 11:15:47'),(3144,7908,860,40720,1548,3,217,1,296460.00,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:16','2024-01-30 11:15:16'),(3145,7908,860,40720,1548,3,68,1,62256.60,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:16','2024-01-30 11:15:16');
INSERT INTO `balance_libro_details` VALUES (3146,7908,860,40720,1548,3,217,1,2.70,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:16','2024-01-30 11:15:16'),(3147,7908,860,40720,1548,3,57,2,360940.05,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:16','2024-01-30 11:15:16'),(3148,7908,860,40720,1548,3,136,1,2220.75,NULL,'2024-01-30 11:13:20','2024-01-30 11:15:16','2024-01-30 11:15:16'),(3149,7908,861,40720,1548,3,217,1,132418.80,NULL,'2024-01-30 11:13:20','2024-01-30 11:14:50','2024-01-30 11:14:50'),(3150,7908,861,40720,1548,3,68,1,27809.60,NULL,'2024-01-30 11:13:20','2024-01-30 11:14:50','2024-01-30 11:14:50'),(3151,7908,861,40720,1548,3,217,1,1.21,NULL,'2024-01-30 11:13:20','2024-01-30 11:14:50','2024-01-30 11:14:50'),(3152,7908,861,40720,1548,3,57,2,161224.83,NULL,'2024-01-30 11:13:20','2024-01-30 11:14:50','2024-01-30 11:14:50'),(3153,7908,861,40720,1548,3,136,1,995.22,NULL,'2024-01-30 11:13:20','2024-01-30 11:14:50','2024-01-30 11:14:50'),(3154,7908,862,40720,1548,3,217,1,132418.80,NULL,'2024-01-30 11:14:50','2024-01-30 11:14:50',NULL),(3155,7908,862,40720,1548,3,68,1,27807.95,NULL,'2024-01-30 11:14:50','2024-01-30 11:14:50',NULL),(3156,7908,862,40720,1548,3,57,2,160226.75,NULL,'2024-01-30 11:14:50','2024-01-30 11:14:50',NULL),(3157,7908,863,40720,1548,3,217,1,296460.00,NULL,'2024-01-30 11:15:16','2024-01-30 11:15:16',NULL),(3158,7908,863,40720,1548,3,68,1,62256.60,NULL,'2024-01-30 11:15:16','2024-01-30 11:15:16',NULL),(3159,7908,863,40720,1548,3,57,2,358716.60,NULL,'2024-01-30 11:15:16','2024-01-30 11:15:16',NULL),(3160,7908,864,40720,1548,3,217,1,464454.00,NULL,'2024-01-30 11:15:47','2024-01-30 11:15:47',NULL),(3161,7908,864,40720,1548,3,68,1,97535.34,NULL,'2024-01-30 11:15:47','2024-01-30 11:15:47',NULL),(3162,7908,864,40720,1548,3,57,2,561989.34,NULL,'2024-01-30 11:15:47','2024-01-30 11:15:47',NULL),(3163,7908,865,40720,1548,3,217,1,5023.35,NULL,'2024-01-30 11:16:15','2024-01-30 11:16:15',NULL),(3164,7908,865,40720,1548,3,68,1,1054.90,NULL,'2024-01-30 11:16:15','2024-01-30 11:16:15',NULL),(3165,7908,865,40720,1548,3,57,2,6078.25,NULL,'2024-01-30 11:16:15','2024-01-30 11:16:15',NULL),(3166,7908,866,40720,1548,3,217,1,70326.90,NULL,'2024-01-30 11:18:59','2024-01-30 11:18:59',NULL),(3167,7908,866,40720,1548,3,68,1,14768.65,NULL,'2024-01-30 11:18:59','2024-01-30 11:18:59',NULL),(3168,7908,866,40720,1548,3,57,2,85095.55,NULL,'2024-01-30 11:18:59','2024-01-30 11:18:59',NULL),(3169,7908,867,40720,1548,3,217,1,92232.00,NULL,'2024-01-30 11:19:24','2024-01-30 11:19:24',NULL),(3170,7908,867,40720,1548,3,68,1,19368.72,NULL,'2024-01-30 11:19:24','2024-01-30 11:19:24',NULL),(3171,7908,867,40720,1548,3,57,2,111600.72,NULL,'2024-01-30 11:19:24','2024-01-30 11:19:24',NULL),(3172,7908,868,40720,1548,3,217,1,138348.00,NULL,'2024-01-30 11:19:54','2024-01-30 11:19:54',NULL),(3173,7908,868,40720,1548,3,68,1,29053.08,NULL,'2024-01-30 11:19:54','2024-01-30 11:19:54',NULL),(3174,7908,868,40720,1548,3,57,2,167401.08,NULL,'2024-01-30 11:19:54','2024-01-30 11:19:54',NULL),(3175,7908,869,40720,1548,3,217,1,21559.23,NULL,'2024-01-30 11:20:17','2024-01-30 11:20:17',NULL),(3176,7908,869,40720,1548,3,68,1,4527.44,NULL,'2024-01-30 11:20:17','2024-01-30 11:20:17',NULL),(3177,7908,869,40720,1548,3,57,2,26086.67,NULL,'2024-01-30 11:20:17','2024-01-30 11:20:17',NULL),(3178,7908,870,40720,1548,3,217,1,237168.00,NULL,'2024-01-30 11:20:54','2024-01-30 11:20:54',NULL),(3179,7908,870,40720,1548,3,68,1,49805.28,NULL,'2024-01-30 11:20:54','2024-01-30 11:20:54',NULL),(3180,7908,870,40720,1548,3,57,2,286973.28,NULL,'2024-01-30 11:20:54','2024-01-30 11:20:54',NULL),(3181,7908,871,40720,1548,3,217,1,296460.00,NULL,'2024-01-30 11:21:35','2024-01-30 11:21:35',NULL),(3182,7908,871,40720,1548,3,68,1,62256.60,NULL,'2024-01-30 11:21:35','2024-01-30 11:21:35',NULL),(3183,7908,871,40720,1548,3,57,2,358716.60,NULL,'2024-01-30 11:21:35','2024-01-30 11:21:35',NULL),(3184,7908,872,40720,1549,2,96,2,10413225.00,NULL,'2024-02-01 16:25:33','2024-02-01 16:25:33',NULL);
INSERT INTO `balance_libro_details` VALUES (3185,7908,872,40720,1549,2,67,2,2186777.25,NULL,'2024-02-01 16:25:33','2024-02-01 16:25:33',NULL),(3186,7908,872,40720,1549,2,13,1,12600002.25,NULL,'2024-02-01 16:25:33','2024-02-01 16:25:33',NULL),(3187,7908,873,40720,1548,3,217,1,1119900.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:14:18','2024-11-13 13:14:18'),(3188,7908,873,40720,1548,3,68,1,235179.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:14:18','2024-11-13 13:14:18'),(3189,7908,873,40720,1548,3,57,2,1355079.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:14:18','2024-11-13 13:14:18'),(3190,7908,874,40720,1548,3,217,1,1104701.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:54','2024-11-13 13:13:54'),(3191,7908,874,40720,1548,3,68,1,231987.21,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:54','2024-11-13 13:13:54'),(3192,7908,874,40720,1548,3,57,2,1336688.21,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:54','2024-11-13 13:13:54'),(3193,7908,875,40720,1548,3,217,1,1111059.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:04:26','2024-11-13 13:04:26'),(3194,7908,875,40720,1548,3,68,1,233322.39,NULL,'2024-02-05 18:04:57','2024-11-13 13:04:26','2024-11-13 13:04:26'),(3195,7908,875,40720,1548,3,57,2,1344381.39,NULL,'2024-02-05 18:04:57','2024-11-13 13:04:26','2024-11-13 13:04:26'),(3196,7908,876,40720,1548,3,217,1,1140120.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:41','2024-11-13 13:13:41'),(3197,7908,876,40720,1548,3,68,1,239425.20,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:41','2024-11-13 13:13:41'),(3198,7908,876,40720,1548,3,57,2,1379545.20,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:41','2024-11-13 13:13:41'),(3199,7908,877,40720,1548,3,217,1,1100547.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:27','2024-11-13 13:13:27'),(3200,7908,877,40720,1548,3,68,1,231114.87,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:27','2024-11-13 13:13:27'),(3201,7908,877,40720,1548,3,57,2,1331661.87,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:27','2024-11-13 13:13:27'),(3202,7908,878,40720,1548,3,217,1,1110738.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:04:12','2024-11-13 13:04:12'),(3203,7908,878,40720,1548,3,68,1,233254.98,NULL,'2024-02-05 18:04:57','2024-11-13 13:04:12','2024-11-13 13:04:12'),(3204,7908,878,40720,1548,3,57,2,1343992.98,NULL,'2024-02-05 18:04:57','2024-11-13 13:04:12','2024-11-13 13:04:12'),(3205,7908,879,40720,1548,3,217,1,1057043.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:14','2024-11-13 13:13:14'),(3206,7908,879,40720,1548,3,68,1,221979.03,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:14','2024-11-13 13:13:14'),(3207,7908,879,40720,1548,3,57,2,1279022.03,NULL,'2024-02-05 18:04:57','2024-11-13 13:13:14','2024-11-13 13:13:14'),(3208,7908,880,40720,1548,3,217,1,1112824.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:12:59','2024-11-13 13:12:59'),(3209,7908,880,40720,1548,3,68,1,233693.04,NULL,'2024-02-05 18:04:57','2024-11-13 13:12:59','2024-11-13 13:12:59'),(3210,7908,880,40720,1548,3,57,2,1346517.04,NULL,'2024-02-05 18:04:57','2024-11-13 13:12:59','2024-11-13 13:12:59'),(3211,7908,881,40720,1548,3,217,1,1120349.00,NULL,'2024-02-05 18:04:57','2024-11-13 13:12:45','2024-11-13 13:12:45'),(3212,7908,881,40720,1548,3,68,1,235273.29,NULL,'2024-02-05 18:04:57','2024-11-13 13:12:45','2024-11-13 13:12:45'),(3213,7908,881,40720,1548,3,57,2,1355622.29,NULL,'2024-02-05 18:04:57','2024-11-13 13:12:45','2024-11-13 13:12:45'),(3214,7908,882,40720,1548,3,217,1,1156383.00,NULL,'2024-02-05 18:04:58','2024-11-13 13:12:31','2024-11-13 13:12:31'),(3215,7908,882,40720,1548,3,68,1,242840.43,NULL,'2024-02-05 18:04:58','2024-11-13 13:12:31','2024-11-13 13:12:31'),(3216,7908,882,40720,1548,3,57,2,1399223.43,NULL,'2024-02-05 18:04:58','2024-11-13 13:12:31','2024-11-13 13:12:31'),(3217,7908,883,40720,1548,3,217,1,1111953.00,NULL,'2024-02-05 18:04:58','2024-11-13 13:12:17','2024-11-13 13:12:17'),(3218,7908,883,40720,1548,3,68,1,233510.13,NULL,'2024-02-05 18:04:58','2024-11-13 13:12:17','2024-11-13 13:12:17');
INSERT INTO `balance_libro_details` VALUES (3219,7908,883,40720,1548,3,57,2,1345463.13,NULL,'2024-02-05 18:04:58','2024-11-13 13:12:17','2024-11-13 13:12:17'),(3220,7908,884,40720,1548,3,217,1,1129440.00,NULL,'2024-02-05 18:04:58','2024-11-13 13:03:56','2024-11-13 13:03:56'),(3221,7908,884,40720,1548,3,68,1,237182.40,NULL,'2024-02-05 18:04:58','2024-11-13 13:03:56','2024-11-13 13:03:56'),(3222,7908,884,40720,1548,3,57,2,1366622.40,NULL,'2024-02-05 18:04:58','2024-11-13 13:03:56','2024-11-13 13:03:56'),(3223,7908,885,40720,1548,3,217,1,1070431.67,NULL,'2024-02-05 18:04:58','2024-02-15 19:23:31','2024-02-15 19:23:31'),(3224,7908,885,40720,1548,3,68,1,224790.65,NULL,'2024-02-05 18:04:58','2024-02-15 19:23:31','2024-02-15 19:23:31'),(3225,7908,885,40720,1548,3,217,1,-0.01,NULL,'2024-02-05 18:04:58','2024-02-15 19:23:31','2024-02-15 19:23:31'),(3226,7908,885,40720,1548,3,57,2,1295222.31,NULL,'2024-02-05 18:04:58','2024-02-15 19:23:31','2024-02-15 19:23:31'),(3227,7908,886,40720,1548,3,217,1,1115176.00,NULL,'2024-02-05 18:04:58','2024-11-13 13:11:51','2024-11-13 13:11:51'),(3228,7908,886,40720,1548,3,68,1,234186.96,NULL,'2024-02-05 18:04:58','2024-11-13 13:11:51','2024-11-13 13:11:51'),(3229,7908,886,40720,1548,3,57,2,1349362.96,NULL,'2024-02-05 18:04:58','2024-11-13 13:11:51','2024-11-13 13:11:51'),(3230,7908,887,40720,1548,3,217,1,1106002.00,NULL,'2024-02-05 18:04:58','2024-11-13 13:11:26','2024-11-13 13:11:26'),(3231,7908,887,40720,1548,3,68,1,232260.42,NULL,'2024-02-05 18:04:58','2024-11-13 13:11:26','2024-11-13 13:11:26'),(3232,7908,887,40720,1548,3,57,2,1338262.42,NULL,'2024-02-05 18:04:58','2024-11-13 13:11:26','2024-11-13 13:11:26'),(3233,7908,888,40720,1544,3,217,1,7851.24,NULL,'2024-02-05 18:16:59','2024-02-05 18:16:59',NULL),(3234,7908,888,40720,1544,3,68,1,1648.76,NULL,'2024-02-05 18:16:59','2024-02-05 18:16:59',NULL),(3235,7908,888,40720,1544,3,57,2,9500.00,NULL,'2024-02-05 18:16:59','2024-02-05 18:16:59',NULL),(3236,7908,889,40720,1544,3,217,1,874568.33,NULL,'2024-02-05 18:16:59','2024-11-13 12:57:24','2024-11-13 12:57:24'),(3237,7908,889,40720,1544,3,68,1,183659.35,NULL,'2024-02-05 18:16:59','2024-11-13 12:57:24','2024-11-13 12:57:24'),(3238,7908,889,40720,1544,3,57,2,1058227.68,NULL,'2024-02-05 18:16:59','2024-11-13 12:57:24','2024-11-13 12:57:24'),(3239,7908,890,40720,1544,3,217,1,807377.00,NULL,'2024-02-05 18:16:59','2024-11-13 12:57:07','2024-11-13 12:57:07'),(3240,7908,890,40720,1544,3,68,1,169549.17,NULL,'2024-02-05 18:16:59','2024-11-13 12:57:07','2024-11-13 12:57:07'),(3241,7908,890,40720,1544,3,57,2,976926.17,NULL,'2024-02-05 18:16:59','2024-11-13 12:57:07','2024-11-13 12:57:07'),(3242,7908,891,40720,1544,3,217,1,845002.00,NULL,'2024-02-05 18:16:59','2024-11-13 12:56:46','2024-11-13 12:56:46'),(3243,7908,891,40720,1544,3,68,1,177450.42,NULL,'2024-02-05 18:16:59','2024-11-13 12:56:46','2024-11-13 12:56:46'),(3244,7908,891,40720,1544,3,57,2,1022452.42,NULL,'2024-02-05 18:16:59','2024-11-13 12:56:46','2024-11-13 12:56:46'),(3245,7908,892,40720,1544,3,217,1,806386.00,NULL,'2024-02-05 18:16:59','2024-11-13 12:56:24','2024-11-13 12:56:24'),(3246,7908,892,40720,1544,3,68,1,169341.06,NULL,'2024-02-05 18:16:59','2024-11-13 12:56:24','2024-11-13 12:56:24'),(3247,7908,892,40720,1544,3,57,2,975727.06,NULL,'2024-02-05 18:16:59','2024-11-13 12:56:24','2024-11-13 12:56:24'),(3248,7908,893,40720,1544,3,217,1,23688.82,NULL,'2024-02-05 19:07:54','2024-02-05 19:07:54',NULL),(3249,7908,893,40720,1544,3,68,1,4974.65,NULL,'2024-02-05 19:07:54','2024-02-05 19:07:54',NULL),(3250,7908,893,40720,1544,3,221,1,1343.33,NULL,'2024-02-05 19:07:54','2024-02-05 19:07:54',NULL),(3251,7908,893,40720,1544,3,57,2,30006.80,NULL,'2024-02-05 19:07:54','2024-02-05 19:07:54',NULL),(3252,7908,894,40720,1544,3,217,1,11702.60,NULL,'2024-02-05 19:18:14','2024-02-05 19:18:14',NULL),(3253,7908,894,40720,1544,3,68,1,2457.55,NULL,'2024-02-05 19:18:14','2024-02-05 19:18:14',NULL),(3254,7908,894,40720,1544,3,221,1,842.97,NULL,'2024-02-05 19:18:14','2024-02-05 19:18:14',NULL);
INSERT INTO `balance_libro_details` VALUES (3255,7908,894,40720,1544,3,57,2,15003.12,NULL,'2024-02-05 19:18:14','2024-02-05 19:18:14',NULL),(3256,7908,895,40720,1544,3,217,1,15862.37,NULL,'2024-02-05 19:19:05','2024-02-05 19:19:05',NULL),(3257,7908,895,40720,1544,3,68,1,3331.10,NULL,'2024-02-05 19:19:05','2024-02-05 19:19:05',NULL),(3258,7908,895,40720,1544,3,221,1,814.96,NULL,'2024-02-05 19:19:05','2024-02-05 19:19:05',NULL),(3259,7908,895,40720,1544,3,57,2,20008.43,NULL,'2024-02-05 19:19:05','2024-02-05 19:19:05',NULL),(3260,7908,896,40720,1544,3,217,1,7931.16,NULL,'2024-02-05 19:19:48','2024-02-05 19:19:48',NULL),(3261,7908,896,40720,1544,3,68,1,1665.54,NULL,'2024-02-05 19:19:48','2024-02-05 19:19:48',NULL),(3262,7908,896,40720,1544,3,221,1,407.48,NULL,'2024-02-05 19:19:48','2024-02-05 19:19:48',NULL),(3263,7908,896,40720,1544,3,57,2,10004.18,NULL,'2024-02-05 19:19:48','2024-02-05 19:19:48',NULL),(3264,7908,897,40720,1544,3,217,1,16175.04,NULL,'2024-02-05 19:20:40','2024-02-05 19:20:40',NULL),(3265,7908,897,40720,1544,3,68,1,3396.76,NULL,'2024-02-05 19:20:40','2024-02-05 19:20:40',NULL),(3266,7908,897,40720,1544,3,221,1,433.96,NULL,'2024-02-05 19:20:40','2024-02-05 19:20:40',NULL),(3267,7908,897,40720,1544,3,57,2,20005.76,NULL,'2024-02-05 19:20:40','2024-02-05 19:20:40',NULL),(3268,7908,898,40720,1544,3,217,1,33274.77,NULL,'2024-02-05 19:21:33','2024-02-05 19:21:33',NULL),(3269,7908,898,40720,1544,3,68,1,6987.70,NULL,'2024-02-05 19:21:33','2024-02-05 19:21:33',NULL),(3270,7908,898,40720,1544,3,221,1,1492.43,NULL,'2024-02-05 19:21:33','2024-02-05 19:21:33',NULL),(3271,7908,898,40720,1544,3,57,2,41754.90,NULL,'2024-02-05 19:21:33','2024-02-05 19:21:33',NULL),(3272,7908,899,40720,1544,3,217,1,12457.64,NULL,'2024-02-05 19:22:34','2024-02-05 19:22:34',NULL),(3273,7908,899,40720,1544,3,68,1,2616.10,NULL,'2024-02-05 19:22:34','2024-02-05 19:22:34',NULL),(3274,7908,899,40720,1544,3,221,1,334.23,NULL,'2024-02-05 19:22:34','2024-02-05 19:22:34',NULL),(3275,7908,899,40720,1544,3,57,2,15407.97,NULL,'2024-02-05 19:22:34','2024-02-05 19:22:34',NULL),(3276,7908,900,40720,1544,3,217,1,7969.48,NULL,'2024-02-05 19:23:21','2024-02-05 19:23:21',NULL),(3277,7908,900,40720,1544,3,68,1,1673.59,NULL,'2024-02-05 19:23:21','2024-02-05 19:23:21',NULL),(3278,7908,900,40720,1544,3,221,1,357.44,NULL,'2024-02-05 19:23:21','2024-02-05 19:23:21',NULL),(3279,7908,900,40720,1544,3,57,2,10000.51,NULL,'2024-02-05 19:23:21','2024-02-05 19:23:21',NULL),(3280,7908,901,40720,1544,3,217,1,14346.91,NULL,'2024-02-05 19:24:16','2024-02-05 19:24:16',NULL),(3281,7908,901,40720,1544,3,68,1,3012.85,NULL,'2024-02-05 19:24:16','2024-02-05 19:24:16',NULL),(3282,7908,901,40720,1544,3,221,1,643.48,NULL,'2024-02-05 19:24:16','2024-02-05 19:24:16',NULL),(3283,7908,901,40720,1544,3,57,2,18003.24,NULL,'2024-02-05 19:24:16','2024-02-05 19:24:16',NULL),(3284,7908,902,40720,1544,3,217,1,7985.03,NULL,'2024-02-05 19:24:59','2024-02-05 19:24:59',NULL),(3285,7908,902,40720,1544,3,68,1,1676.86,NULL,'2024-02-05 19:24:59','2024-02-05 19:24:59',NULL),(3286,7908,902,40720,1544,3,221,1,345.71,NULL,'2024-02-05 19:24:59','2024-02-05 19:24:59',NULL),(3287,7908,902,40720,1544,3,57,2,10007.60,NULL,'2024-02-05 19:24:59','2024-02-05 19:24:59',NULL),(3288,7908,903,40720,1544,3,217,1,12029.93,NULL,'2024-02-05 19:26:02','2024-02-05 19:26:02',NULL),(3289,7908,903,40720,1544,3,68,1,2526.29,NULL,'2024-02-05 19:26:02','2024-02-05 19:26:02',NULL),(3290,7908,903,40720,1544,3,221,1,447.79,NULL,'2024-02-05 19:26:02','2024-02-05 19:26:02',NULL),(3291,7908,903,40720,1544,3,57,2,15004.01,NULL,'2024-02-05 19:26:02','2024-02-05 19:26:02',NULL),(3292,7908,904,40720,1544,3,217,1,40434.65,NULL,'2024-02-05 19:26:55','2024-02-05 19:26:55',NULL),(3293,7908,904,40720,1544,3,68,1,8491.28,NULL,'2024-02-05 19:26:55','2024-02-05 19:26:55',NULL),(3294,7908,904,40720,1544,3,221,1,1084.83,NULL,'2024-02-05 19:26:55','2024-02-05 19:26:55',NULL),(3295,7908,904,40720,1544,3,57,2,50010.76,NULL,'2024-02-05 19:26:55','2024-02-05 19:26:55',NULL);
INSERT INTO `balance_libro_details` VALUES (3296,7908,905,40720,1544,3,217,1,36467.59,NULL,'2024-02-05 19:28:16','2024-02-05 19:28:16',NULL),(3297,7908,905,40720,1544,3,68,1,7658.19,NULL,'2024-02-05 19:28:16','2024-02-05 19:28:16',NULL),(3298,7908,905,40720,1544,3,221,1,978.40,NULL,'2024-02-05 19:28:16','2024-02-05 19:28:16',NULL),(3299,7908,905,40720,1544,3,57,2,45104.18,NULL,'2024-02-05 19:28:16','2024-02-05 19:28:16',NULL),(3300,7908,906,40720,1544,3,217,1,40242.80,NULL,'2024-02-05 19:29:01','2024-02-05 19:29:01',NULL),(3301,7908,906,40720,1544,3,68,1,8450.99,NULL,'2024-02-05 19:29:01','2024-02-05 19:29:01',NULL),(3302,7908,906,40720,1544,3,221,1,1307.10,NULL,'2024-02-05 19:29:01','2024-02-05 19:29:01',NULL),(3303,7908,906,40720,1544,3,57,2,50000.89,NULL,'2024-02-05 19:29:01','2024-02-05 19:29:01',NULL),(3304,7908,907,40720,1544,3,217,1,31876.12,NULL,'2024-02-05 19:29:58','2024-02-05 19:29:58',NULL),(3305,7908,907,40720,1544,3,68,1,6693.99,NULL,'2024-02-05 19:29:58','2024-02-05 19:29:58',NULL),(3306,7908,907,40720,1544,3,221,1,1429.69,NULL,'2024-02-05 19:29:58','2024-02-05 19:29:58',NULL),(3307,7908,907,40720,1544,3,57,2,39999.80,NULL,'2024-02-05 19:29:58','2024-02-05 19:29:58',NULL),(3308,7908,908,40720,1544,3,217,1,40090.04,NULL,'2024-02-05 19:30:54','2024-02-05 19:30:54',NULL),(3309,7908,908,40720,1544,3,68,1,8418.91,NULL,'2024-02-05 19:30:54','2024-02-05 19:30:54',NULL),(3310,7908,908,40720,1544,3,221,1,1492.28,NULL,'2024-02-05 19:30:54','2024-02-05 19:30:54',NULL),(3311,7908,908,40720,1544,3,57,2,50001.23,NULL,'2024-02-05 19:30:54','2024-02-05 19:30:54',NULL),(3312,7908,909,40720,1544,3,217,1,35929.36,NULL,'2024-02-05 19:31:50','2024-02-05 19:31:50',NULL),(3313,7908,909,40720,1544,3,68,1,7545.17,NULL,'2024-02-05 19:31:50','2024-02-05 19:31:50',NULL),(3314,7908,909,40720,1544,3,221,1,1555.56,NULL,'2024-02-05 19:31:50','2024-02-05 19:31:50',NULL),(3315,7908,909,40720,1544,3,57,2,45030.09,NULL,'2024-02-05 19:31:50','2024-02-05 19:31:50',NULL),(3316,7908,910,40720,1544,3,217,1,11541.81,NULL,'2024-02-05 19:39:01','2024-02-05 19:39:01',NULL),(3317,7908,910,40720,1544,3,68,1,2423.78,NULL,'2024-02-05 19:39:01','2024-02-05 19:39:01',NULL),(3318,7908,910,40720,1544,3,221,1,1034.45,NULL,'2024-02-05 19:39:01','2024-02-05 19:39:01',NULL),(3319,7908,910,40720,1544,3,57,2,15000.04,NULL,'2024-02-05 19:39:01','2024-02-05 19:39:01',NULL),(3320,7908,911,40720,1544,3,217,1,13304.53,NULL,'2024-02-05 19:40:26','2024-02-05 19:40:26',NULL),(3321,7908,911,40720,1544,3,68,1,2793.95,NULL,'2024-02-05 19:40:26','2024-02-05 19:40:26',NULL),(3322,7908,911,40720,1544,3,221,1,901.55,NULL,'2024-02-05 19:40:26','2024-02-05 19:40:26',NULL),(3323,7908,911,40720,1544,3,57,2,17000.03,NULL,'2024-02-05 19:40:26','2024-02-05 19:40:26',NULL),(3324,7908,912,40720,1544,3,217,1,7826.22,NULL,'2024-02-05 19:42:27','2024-02-05 19:42:27',NULL),(3325,7908,912,40720,1544,3,68,1,1643.51,NULL,'2024-02-05 19:42:27','2024-02-05 19:42:27',NULL),(3326,7908,912,40720,1544,3,221,1,530.32,NULL,'2024-02-05 19:42:27','2024-02-05 19:42:27',NULL),(3327,7908,912,40720,1544,3,57,2,10000.05,NULL,'2024-02-05 19:42:27','2024-02-05 19:42:27',NULL),(3328,7908,913,40720,1544,3,217,1,460638.90,NULL,'2024-02-07 12:18:57','2024-02-07 12:18:57',NULL),(3329,7908,913,40720,1544,3,68,1,96734.17,NULL,'2024-02-07 12:18:57','2024-02-07 12:18:57',NULL),(3330,7908,913,40720,1544,3,57,2,557373.07,NULL,'2024-02-07 12:18:57','2024-02-07 12:18:57',NULL),(3331,7908,914,40720,1544,3,217,1,14958.73,NULL,'2024-02-07 12:33:52','2024-02-07 12:33:52',NULL),(3332,7908,914,40720,1544,3,68,1,3141.33,NULL,'2024-02-07 12:33:52','2024-02-07 12:33:52',NULL),(3333,7908,914,40720,1544,3,57,2,18100.06,NULL,'2024-02-07 12:33:52','2024-02-07 12:33:52',NULL),(3334,7908,915,40720,1544,3,217,1,272170.00,NULL,'2024-02-07 12:37:14','2024-02-07 12:37:14',NULL),(3335,7908,915,40720,1544,3,68,1,57155.70,NULL,'2024-02-07 12:37:14','2024-02-07 12:37:14',NULL),(3336,7908,915,40720,1544,3,57,2,329325.70,NULL,'2024-02-07 12:37:14','2024-02-07 12:37:14',NULL);
INSERT INTO `balance_libro_details` VALUES (3337,7908,916,40720,1544,3,217,1,64360.20,NULL,'2024-02-07 12:37:42','2024-02-07 12:37:42',NULL),(3338,7908,916,40720,1544,3,68,1,13515.64,NULL,'2024-02-07 12:37:42','2024-02-07 12:37:42',NULL),(3339,7908,916,40720,1544,3,57,2,77875.84,NULL,'2024-02-07 12:37:42','2024-02-07 12:37:42',NULL),(3340,7908,917,40720,1544,3,217,1,44828.00,NULL,'2024-02-07 12:38:07','2024-02-07 12:38:07',NULL),(3341,7908,917,40720,1544,3,68,1,9413.88,NULL,'2024-02-07 12:38:07','2024-02-07 12:38:07',NULL),(3342,7908,917,40720,1544,3,57,2,54241.88,NULL,'2024-02-07 12:38:07','2024-02-07 12:38:07',NULL),(3343,7908,918,40720,1544,15,67,1,2163347.87,NULL,'2024-02-07 12:48:47','2024-11-13 12:55:12','2024-11-13 12:55:12'),(3344,7908,918,40720,1544,15,68,2,2159295.62,NULL,'2024-02-07 12:48:47','2024-11-13 12:55:12','2024-11-13 12:55:12'),(3345,7908,918,40720,1544,15,74,2,4052.24,NULL,'2024-02-07 12:48:47','2024-11-13 12:55:12','2024-11-13 12:55:12'),(3346,7908,918,40720,1544,15,136,2,0.01,NULL,'2024-02-07 12:48:47','2024-11-13 12:55:12','2024-11-13 12:55:12'),(3347,7908,919,40720,1548,3,217,1,7851.24,NULL,'2024-02-15 11:58:18','2024-02-15 11:58:18',NULL),(3348,7908,919,40720,1548,3,68,1,1648.76,NULL,'2024-02-15 11:58:18','2024-02-15 11:58:18',NULL),(3349,7908,919,40720,1548,3,57,2,9500.00,NULL,'2024-02-15 11:58:18','2024-02-15 11:58:18',NULL),(3350,7908,920,40720,1548,3,217,1,16010.85,NULL,'2024-02-15 12:04:21','2024-02-15 12:04:21',NULL),(3351,7908,920,40720,1548,3,68,1,3362.28,NULL,'2024-02-15 12:04:21','2024-02-15 12:04:21',NULL),(3352,7908,920,40720,1548,3,221,1,624.89,NULL,'2024-02-15 12:04:21','2024-02-15 12:04:21',NULL),(3353,7908,920,40720,1548,3,57,2,19998.02,NULL,'2024-02-15 12:04:21','2024-02-15 12:04:21',NULL),(3354,7908,921,40720,1548,3,217,1,81400.29,NULL,'2024-02-15 12:05:51','2024-02-15 12:05:51',NULL),(3355,7908,921,40720,1548,3,68,1,17094.06,NULL,'2024-02-15 12:05:51','2024-02-15 12:05:51',NULL),(3356,7908,921,40720,1548,3,221,1,1670.57,NULL,'2024-02-15 12:05:51','2024-02-15 12:05:51',NULL),(3357,7908,921,40720,1548,3,57,2,100164.92,NULL,'2024-02-15 12:05:51','2024-02-15 12:05:51',NULL),(3358,7908,922,40720,1548,3,217,1,27592.68,NULL,'2024-02-15 12:07:16','2024-02-15 12:07:16',NULL),(3359,7908,922,40720,1548,3,68,1,5794.46,NULL,'2024-02-15 12:07:16','2024-02-15 12:07:16',NULL),(3360,7908,922,40720,1548,3,221,1,1114.85,NULL,'2024-02-15 12:07:16','2024-02-15 12:07:16',NULL),(3361,7908,922,40720,1548,3,57,2,34501.99,NULL,'2024-02-15 12:07:16','2024-02-15 12:07:16',NULL),(3362,7908,923,40720,1548,3,217,1,35023.22,NULL,'2024-02-15 12:08:25','2024-02-15 12:08:25',NULL),(3363,7908,923,40720,1548,3,68,1,7354.88,NULL,'2024-02-15 12:08:25','2024-02-15 12:08:25',NULL),(3364,7908,923,40720,1548,3,221,1,896.90,NULL,'2024-02-15 12:08:25','2024-02-15 12:08:25',NULL),(3365,7908,923,40720,1548,3,57,2,43275.00,NULL,'2024-02-15 12:08:25','2024-02-15 12:08:25',NULL),(3366,7908,924,40720,1548,3,217,1,40698.69,NULL,'2024-02-15 12:13:20','2024-02-15 12:13:20',NULL),(3367,7908,924,40720,1548,3,68,1,8546.72,NULL,'2024-02-15 12:13:20','2024-02-15 12:13:20',NULL),(3368,7908,924,40720,1548,3,221,1,790.58,NULL,'2024-02-15 12:13:20','2024-02-15 12:13:20',NULL),(3369,7908,924,40720,1548,3,57,2,50035.99,NULL,'2024-02-15 12:13:20','2024-02-15 12:13:20',NULL),(3370,7908,925,40720,1548,3,217,1,40667.00,NULL,'2024-02-15 12:14:57','2024-02-15 12:14:57',NULL),(3371,7908,925,40720,1548,3,68,1,8540.07,NULL,'2024-02-15 12:14:57','2024-02-15 12:14:57',NULL),(3372,7908,925,40720,1548,3,221,1,789.97,NULL,'2024-02-15 12:14:57','2024-02-15 12:14:57',NULL),(3373,7908,925,40720,1548,3,57,2,49997.04,NULL,'2024-02-15 12:14:57','2024-02-15 12:14:57',NULL),(3374,7908,926,40720,1548,3,217,1,26112.95,NULL,'2024-02-15 12:16:35','2024-02-15 12:16:35',NULL),(3375,7908,926,40720,1548,3,68,1,5483.72,NULL,'2024-02-15 12:16:35','2024-02-15 12:16:35',NULL),(3376,7908,926,40720,1548,3,221,1,412.95,NULL,'2024-02-15 12:16:35','2024-02-15 12:16:35',NULL);
INSERT INTO `balance_libro_details` VALUES (3377,7908,926,40720,1548,3,57,2,32009.62,NULL,'2024-02-15 12:16:35','2024-02-15 12:16:35',NULL),(3378,7908,927,40720,1548,3,217,1,8925.62,NULL,'2024-02-15 12:17:43','2024-02-15 12:17:43',NULL),(3379,7908,927,40720,1548,3,68,1,1874.38,NULL,'2024-02-15 12:17:43','2024-02-15 12:17:43',NULL),(3380,7908,927,40720,1548,3,57,2,10800.00,NULL,'2024-02-15 12:17:43','2024-02-15 12:17:43',NULL),(3381,7908,928,40720,1548,15,67,1,7124381.78,NULL,'2024-02-15 12:21:39','2024-02-15 19:13:32','2024-02-15 19:13:32'),(3382,7908,928,40720,1548,15,68,2,6860843.88,NULL,'2024-02-15 12:21:39','2024-02-15 19:13:32','2024-02-15 19:13:32'),(3383,7908,928,40720,1548,15,74,2,263537.90,NULL,'2024-02-15 12:21:39','2024-02-15 19:13:32','2024-02-15 19:13:32'),(3384,7908,929,40720,1548,3,217,1,1070431.67,NULL,'2024-02-15 19:23:31','2024-11-13 13:03:30','2024-11-13 13:03:30'),(3385,7908,929,40720,1548,3,68,1,224790.65,NULL,'2024-02-15 19:23:31','2024-11-13 13:03:30','2024-11-13 13:03:30'),(3386,7908,929,40720,1548,3,57,2,1295222.32,NULL,'2024-02-15 19:23:31','2024-11-13 13:03:30','2024-11-13 13:03:30'),(3387,7908,930,40720,1548,15,67,1,7124381.78,NULL,'2024-02-15 19:30:17','2024-04-23 22:07:43','2024-04-23 22:07:43'),(3388,7908,930,40720,1548,15,68,2,6860843.88,NULL,'2024-02-15 19:30:17','2024-04-23 22:07:43','2024-04-23 22:07:43'),(3389,7908,930,40720,1548,15,74,2,263537.90,NULL,'2024-02-15 19:30:17','2024-04-23 22:07:43','2024-04-23 22:07:43'),(3390,7908,931,40720,1549,3,217,1,198588.43,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3391,7908,931,40720,1549,3,68,1,41703.57,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3392,7908,931,40720,1549,3,57,2,240292.00,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3393,7908,932,40720,1549,3,217,1,15702.48,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3394,7908,932,40720,1549,3,68,1,3297.52,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3395,7908,932,40720,1549,3,57,2,19000.00,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3396,7908,933,40720,1549,3,217,1,18181.82,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3397,7908,933,40720,1549,3,68,1,3818.18,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3398,7908,933,40720,1549,3,57,2,22000.00,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3399,7908,934,40720,1549,3,217,1,81800.69,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3400,7908,934,40720,1549,3,68,1,17178.14,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3401,7908,934,40720,1549,3,57,2,98978.83,NULL,'2024-02-26 19:02:02','2024-02-26 19:02:02',NULL),(3402,7908,935,40720,1549,3,217,1,28925.62,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3403,7908,935,40720,1549,3,68,1,6074.38,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3404,7908,935,40720,1549,3,57,2,35000.00,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3405,7908,936,40720,1549,3,217,1,21510.78,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3406,7908,936,40720,1549,3,68,1,4517.26,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3407,7908,936,40720,1549,3,57,2,26028.04,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3408,7908,937,40720,1549,3,217,1,14028.77,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3409,7908,937,40720,1549,3,68,1,2946.04,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3410,7908,937,40720,1549,3,57,2,16974.81,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3411,7908,938,40720,1549,3,217,1,3172.33,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3412,7908,938,40720,1549,3,68,1,666.19,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3413,7908,938,40720,1549,3,57,2,3838.52,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3414,7908,939,40720,1549,3,217,1,6704.13,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3415,7908,939,40720,1549,3,68,1,1407.87,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL);
INSERT INTO `balance_libro_details` VALUES (3416,7908,939,40720,1549,3,57,2,8112.00,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3417,7908,940,40720,1549,3,217,1,82644.62,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3418,7908,940,40720,1549,3,68,1,17355.37,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3419,7908,940,40720,1549,3,57,2,99999.99,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3420,7908,941,40720,1549,3,217,1,43809.61,NULL,'2024-02-26 19:02:03','2024-02-26 19:04:21','2024-02-26 19:04:21'),(3421,7908,941,40720,1549,3,68,1,9203.70,NULL,'2024-02-26 19:02:03','2024-02-26 19:04:21','2024-02-26 19:04:21'),(3422,7908,941,40720,1549,3,217,1,0.39,NULL,'2024-02-26 19:02:03','2024-02-26 19:04:21','2024-02-26 19:04:21'),(3423,7908,941,40720,1549,3,57,2,53339.63,NULL,'2024-02-26 19:02:03','2024-02-26 19:04:21','2024-02-26 19:04:21'),(3424,7908,941,40720,1549,3,136,1,325.93,NULL,'2024-02-26 19:02:03','2024-02-26 19:04:21','2024-02-26 19:04:21'),(3425,7908,942,40720,1549,3,217,1,162952.89,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3426,7908,942,40720,1549,3,68,1,34220.11,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3427,7908,942,40720,1549,3,57,2,197173.00,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3428,7908,943,40720,1549,3,217,1,399344.40,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:48','2024-02-26 19:03:48'),(3429,7908,943,40720,1549,3,68,1,83862.32,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:48','2024-02-26 19:03:48'),(3430,7908,943,40720,1549,3,217,1,3.58,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:48','2024-02-26 19:03:48'),(3431,7908,943,40720,1549,3,57,2,486203.90,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:48','2024-02-26 19:03:48'),(3432,7908,943,40720,1549,3,136,1,2993.60,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:48','2024-02-26 19:03:48'),(3433,7908,944,40720,1549,3,217,1,134621.76,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:26','2024-02-26 19:03:26'),(3434,7908,944,40720,1549,3,68,1,28272.24,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:26','2024-02-26 19:03:26'),(3435,7908,944,40720,1549,3,217,1,1.21,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:26','2024-02-26 19:03:26'),(3436,7908,944,40720,1549,3,57,2,163907.02,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:26','2024-02-26 19:03:26'),(3437,7908,944,40720,1549,3,136,1,1011.81,NULL,'2024-02-26 19:02:03','2024-02-26 19:03:26','2024-02-26 19:03:26'),(3438,7908,945,40720,1549,3,217,1,1317083.04,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:44','2024-02-26 19:06:44'),(3439,7908,945,40720,1549,3,68,1,276585.76,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:44','2024-02-26 19:06:44'),(3440,7908,945,40720,1549,3,217,1,11.80,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:44','2024-02-26 19:06:44'),(3441,7908,945,40720,1549,3,57,2,1603547.76,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:44','2024-02-26 19:06:44'),(3442,7908,945,40720,1549,3,136,1,9867.16,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:44','2024-02-26 19:06:44'),(3443,7908,946,40720,1549,3,217,1,519733.76,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:15','2024-02-26 19:06:15'),(3444,7908,946,40720,1549,3,68,1,109145.76,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:15','2024-02-26 19:06:15'),(3445,7908,946,40720,1549,3,217,1,4.66,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:15','2024-02-26 19:06:15'),(3446,7908,946,40720,1549,3,57,2,632780.88,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:15','2024-02-26 19:06:15'),(3447,7908,946,40720,1549,3,136,1,3896.70,NULL,'2024-02-26 19:02:03','2024-02-26 19:06:15','2024-02-26 19:06:15'),(3448,7908,947,40720,1549,3,217,1,11602.56,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3449,7908,947,40720,1549,3,68,1,2436.54,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3450,7908,947,40720,1549,3,57,2,14039.10,NULL,'2024-02-26 19:02:03','2024-02-26 19:02:03',NULL),(3451,7908,948,40720,1549,3,217,1,134621.76,NULL,'2024-02-26 19:03:26','2024-02-26 19:05:18','2024-02-26 19:05:18');
INSERT INTO `balance_libro_details` VALUES (3452,7908,948,40720,1549,3,68,1,28270.57,NULL,'2024-02-26 19:03:26','2024-02-26 19:05:18','2024-02-26 19:05:18'),(3453,7908,948,40720,1549,3,57,2,162892.33,NULL,'2024-02-26 19:03:26','2024-02-26 19:05:18','2024-02-26 19:05:18'),(3454,7908,949,40720,1549,3,217,1,399344.40,NULL,'2024-02-26 19:03:48','2024-02-26 19:05:29','2024-02-26 19:05:29'),(3455,7908,949,40720,1549,3,68,1,83862.32,NULL,'2024-02-26 19:03:48','2024-02-26 19:05:29','2024-02-26 19:05:29'),(3456,7908,949,40720,1549,3,57,2,483206.72,NULL,'2024-02-26 19:03:48','2024-02-26 19:05:29','2024-02-26 19:05:29'),(3457,7908,950,40720,1549,3,217,1,43809.61,NULL,'2024-02-26 19:04:21','2024-02-26 19:05:06','2024-02-26 19:05:06'),(3458,7908,950,40720,1549,3,68,1,9200.02,NULL,'2024-02-26 19:04:21','2024-02-26 19:05:06','2024-02-26 19:05:06'),(3459,7908,950,40720,1549,3,57,2,53009.63,NULL,'2024-02-26 19:04:21','2024-02-26 19:05:06','2024-02-26 19:05:06'),(3460,7908,951,40720,1549,3,217,1,43809.61,NULL,'2024-02-26 19:05:06','2024-02-26 19:05:40','2024-02-26 19:05:40'),(3461,7908,951,40720,1549,3,68,1,9200.02,NULL,'2024-02-26 19:05:06','2024-02-26 19:05:40','2024-02-26 19:05:40'),(3462,7908,951,40720,1549,3,57,2,53009.63,NULL,'2024-02-26 19:05:06','2024-02-26 19:05:40','2024-02-26 19:05:40'),(3463,7908,952,40720,1549,3,217,1,134621.76,NULL,'2024-02-26 19:05:18','2024-02-26 19:05:18',NULL),(3464,7908,952,40720,1549,3,68,1,28270.57,NULL,'2024-02-26 19:05:18','2024-02-26 19:05:18',NULL),(3465,7908,952,40720,1549,3,57,2,162892.33,NULL,'2024-02-26 19:05:18','2024-02-26 19:05:18',NULL),(3466,7908,953,40720,1549,3,217,1,399344.40,NULL,'2024-02-26 19:05:29','2024-02-26 19:05:29',NULL),(3467,7908,953,40720,1549,3,68,1,83862.32,NULL,'2024-02-26 19:05:29','2024-02-26 19:05:29',NULL),(3468,7908,953,40720,1549,3,57,2,483206.72,NULL,'2024-02-26 19:05:29','2024-02-26 19:05:29',NULL),(3469,7908,954,40720,1549,3,217,1,43809.61,NULL,'2024-02-26 19:05:40','2024-02-26 19:05:40',NULL),(3470,7908,954,40720,1549,3,68,1,9200.02,NULL,'2024-02-26 19:05:40','2024-02-26 19:05:40',NULL),(3471,7908,954,40720,1549,3,57,2,53009.63,NULL,'2024-02-26 19:05:40','2024-02-26 19:05:40',NULL),(3472,7908,955,40720,1549,3,217,1,519733.76,NULL,'2024-02-26 19:06:15','2024-02-26 19:06:15',NULL),(3473,7908,955,40720,1549,3,68,1,109144.09,NULL,'2024-02-26 19:06:15','2024-02-26 19:06:15',NULL),(3474,7908,955,40720,1549,3,57,2,628877.85,NULL,'2024-02-26 19:06:15','2024-02-26 19:06:15',NULL),(3475,7908,956,40720,1549,3,217,1,1317083.04,NULL,'2024-02-26 19:06:44','2024-02-26 19:06:44',NULL),(3476,7908,956,40720,1549,3,68,1,276587.44,NULL,'2024-02-26 19:06:44','2024-02-26 19:06:44',NULL),(3477,7908,956,40720,1549,3,57,2,1593670.48,NULL,'2024-02-26 19:06:44','2024-02-26 19:06:44',NULL),(3478,7908,957,40720,1549,3,217,1,12307692.31,NULL,'2024-02-27 19:04:11','2024-04-23 22:09:48','2024-04-23 22:09:48'),(3479,7908,957,40720,1549,3,68,1,1292307.69,NULL,'2024-02-27 19:04:11','2024-04-23 22:09:48','2024-04-23 22:09:48'),(3480,7908,957,40720,1549,3,57,2,13600000.00,NULL,'2024-02-27 19:04:11','2024-04-23 22:09:48','2024-04-23 22:09:48'),(3481,7908,958,40720,1549,3,217,1,1084199.00,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(3482,7908,958,40720,1549,3,68,1,227681.79,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(3483,7908,958,40720,1549,3,57,2,1311880.79,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(3484,7908,959,40720,1549,3,217,1,1078512.00,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(3485,7908,959,40720,1549,3,68,1,226487.52,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(3486,7908,959,40720,1549,3,57,2,1304999.52,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(3487,7908,960,40720,1549,3,217,1,1051198.00,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(3488,7908,960,40720,1549,3,68,1,220751.58,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL),(3489,7908,960,40720,1549,3,57,2,1271949.58,NULL,'2024-03-04 19:08:06','2024-03-04 19:08:06',NULL);
INSERT INTO `balance_libro_details` VALUES (3490,7908,961,40720,1549,3,217,1,1092522.57,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3491,7908,961,40720,1549,3,68,1,229429.74,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3492,7908,961,40720,1549,3,57,2,1321952.31,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3493,7908,962,40720,1549,3,217,1,1050189.00,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3494,7908,962,40720,1549,3,68,1,220539.69,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3495,7908,962,40720,1549,3,57,2,1270728.69,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3496,7908,963,40720,1549,3,217,1,1060641.00,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3497,7908,963,40720,1549,3,68,1,222734.61,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3498,7908,963,40720,1549,3,57,2,1283375.61,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3499,7908,964,40720,1549,3,217,1,1082739.00,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3500,7908,964,40720,1549,3,68,1,227375.19,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3501,7908,964,40720,1549,3,57,2,1310114.19,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3502,7908,965,40720,1549,3,217,1,1071428.00,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3503,7908,965,40720,1549,3,68,1,224999.88,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3504,7908,965,40720,1549,3,57,2,1296427.88,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3505,7908,966,40720,1549,3,217,1,47073.60,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:58','2024-03-27 18:45:58'),(3506,7908,966,40720,1549,3,68,1,9885.46,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:58','2024-03-27 18:45:58'),(3507,7908,966,40720,1549,3,217,1,0.42,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:58','2024-03-27 18:45:58'),(3508,7908,966,40720,1549,3,57,2,57312.11,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:58','2024-03-27 18:45:58'),(3509,7908,966,40720,1549,3,136,1,352.63,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:58','2024-03-27 18:45:58'),(3510,7908,967,40720,1549,3,217,1,47073.60,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:38','2024-03-27 18:45:38'),(3511,7908,967,40720,1549,3,68,1,9885.46,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:38','2024-03-27 18:45:38'),(3512,7908,967,40720,1549,3,217,1,0.42,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:38','2024-03-27 18:45:38'),(3513,7908,967,40720,1549,3,57,2,57312.11,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:38','2024-03-27 18:45:38'),(3514,7908,967,40720,1549,3,136,1,352.63,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:38','2024-03-27 18:45:38'),(3515,7908,968,40720,1549,3,217,1,267310.80,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:22','2024-03-27 18:45:22'),(3516,7908,968,40720,1549,3,68,1,56135.27,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:22','2024-03-27 18:45:22'),(3517,7908,968,40720,1549,3,217,1,2.39,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:22','2024-03-27 18:45:22'),(3518,7908,968,40720,1549,3,57,2,325455.10,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:22','2024-03-27 18:45:22'),(3519,7908,968,40720,1549,3,136,1,2006.64,NULL,'2024-03-04 19:08:07','2024-03-27 18:45:22','2024-03-27 18:45:22'),(3520,7908,969,40720,1549,3,217,1,67584.24,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:27','2024-03-27 18:44:27'),(3521,7908,969,40720,1549,3,68,1,14189.33,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:27','2024-03-27 18:44:27'),(3522,7908,969,40720,1549,3,217,1,0.60,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:27','2024-03-27 18:44:27'),(3523,7908,969,40720,1549,3,57,2,82277.93,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:27','2024-03-27 18:44:27'),(3524,7908,969,40720,1549,3,136,1,503.76,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:27','2024-03-27 18:44:27'),(3525,7908,970,40720,1549,3,217,1,67584.24,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:11','2024-03-27 18:44:11'),(3526,7908,970,40720,1549,3,68,1,14189.33,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:11','2024-03-27 18:44:11');
INSERT INTO `balance_libro_details` VALUES (3527,7908,970,40720,1549,3,217,1,0.60,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:11','2024-03-27 18:44:11'),(3528,7908,970,40720,1549,3,57,2,82277.93,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:11','2024-03-27 18:44:11'),(3529,7908,970,40720,1549,3,136,1,503.76,NULL,'2024-03-04 19:08:07','2024-03-27 18:44:11','2024-03-27 18:44:11'),(3530,7908,971,40720,1549,3,217,1,267310.80,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:50','2024-03-27 18:43:50'),(3531,7908,971,40720,1549,3,68,1,56135.27,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:50','2024-03-27 18:43:50'),(3532,7908,971,40720,1549,3,217,1,2.39,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:50','2024-03-27 18:43:50'),(3533,7908,971,40720,1549,3,57,2,325455.10,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:50','2024-03-27 18:43:50'),(3534,7908,971,40720,1549,3,136,1,2006.64,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:50','2024-03-27 18:43:50'),(3535,7908,972,40720,1549,3,217,1,141220.80,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:30','2024-03-27 18:43:30'),(3536,7908,972,40720,1549,3,68,1,29656.37,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:30','2024-03-27 18:43:30'),(3537,7908,972,40720,1549,3,217,1,1.26,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:30','2024-03-27 18:43:30'),(3538,7908,972,40720,1549,3,57,2,171936.32,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:30','2024-03-27 18:43:30'),(3539,7908,972,40720,1549,3,136,1,1057.89,NULL,'2024-03-04 19:08:07','2024-03-27 18:43:30','2024-03-27 18:43:30'),(3540,7908,973,40720,1549,3,217,1,15584.02,NULL,'2024-03-04 19:08:07','2024-03-27 18:42:38','2024-03-27 18:42:38'),(3541,7908,973,40720,1549,3,68,1,3272.64,NULL,'2024-03-04 19:08:07','2024-03-27 18:42:38','2024-03-27 18:42:38'),(3542,7908,973,40720,1549,3,217,1,1143.31,NULL,'2024-03-04 19:08:07','2024-03-27 18:42:38','2024-03-27 18:42:38'),(3543,7908,973,40720,1549,3,57,2,19999.97,NULL,'2024-03-04 19:08:07','2024-03-27 18:42:38','2024-03-27 18:42:38'),(3544,7908,974,40720,1549,3,217,1,12396.69,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3545,7908,974,40720,1549,3,68,1,2603.30,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3546,7908,974,40720,1549,3,57,2,14999.99,NULL,'2024-03-04 19:08:07','2024-03-04 19:08:07',NULL),(3547,7908,975,40720,1550,2,96,2,11404962.00,NULL,'2024-03-05 20:05:09','2024-03-05 20:05:09',NULL),(3548,7908,975,40720,1550,2,67,2,2395042.02,NULL,'2024-03-05 20:05:09','2024-03-05 20:05:09',NULL),(3549,7908,975,40720,1550,2,13,1,13800004.02,NULL,'2024-03-05 20:05:09','2024-03-05 20:05:09',NULL),(3550,7908,976,40720,1550,3,217,1,24895.88,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:45','2024-05-02 18:52:45'),(3551,7908,976,40720,1550,3,68,1,5231.93,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:45','2024-05-02 18:52:45'),(3552,7908,976,40720,1550,3,217,1,0.22,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:45','2024-05-02 18:52:45'),(3553,7908,976,40720,1550,3,57,2,30313.15,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:45','2024-05-02 18:52:45'),(3554,7908,976,40720,1550,3,136,1,185.12,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:45','2024-05-02 18:52:45'),(3555,7908,977,40720,1550,3,217,1,267915.00,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:27','2024-05-02 18:52:27'),(3556,7908,977,40720,1550,3,68,1,56262.15,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:27','2024-05-02 18:52:27'),(3557,7908,977,40720,1550,3,217,1,2.39,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:27','2024-05-02 18:52:27'),(3558,7908,977,40720,1550,3,57,2,326190.73,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:27','2024-05-02 18:52:27'),(3559,7908,977,40720,1550,3,136,1,2011.19,NULL,'2024-03-27 11:40:11','2024-05-02 18:52:27','2024-05-02 18:52:27'),(3560,7908,978,40720,1550,3,217,1,33547.66,NULL,'2024-03-27 11:40:11','2024-05-02 18:54:47','2024-05-02 18:54:47'),(3561,7908,978,40720,1550,3,68,1,7045.01,NULL,'2024-03-27 11:40:11','2024-05-02 18:54:47','2024-05-02 18:54:47'),(3562,7908,978,40720,1550,3,217,1,3414.66,NULL,'2024-03-27 11:40:11','2024-05-02 18:54:47','2024-05-02 18:54:47');
INSERT INTO `balance_libro_details` VALUES (3563,7908,978,40720,1550,3,57,2,44007.33,NULL,'2024-03-27 11:40:11','2024-05-02 18:54:47','2024-05-02 18:54:47'),(3564,7908,979,40720,1550,3,217,1,86400.00,NULL,'2024-03-27 11:40:11','2024-05-02 18:55:34','2024-05-02 18:55:34'),(3565,7908,979,40720,1550,3,68,1,18144.00,NULL,'2024-03-27 11:40:11','2024-05-02 18:55:34','2024-05-02 18:55:34'),(3566,7908,979,40720,1550,3,217,1,0.75,NULL,'2024-03-27 11:40:11','2024-05-02 18:55:34','2024-05-02 18:55:34'),(3567,7908,979,40720,1550,3,57,2,105192.00,NULL,'2024-03-27 11:40:11','2024-05-02 18:55:34','2024-05-02 18:55:34'),(3568,7908,979,40720,1550,3,136,1,647.25,NULL,'2024-03-27 11:40:11','2024-05-02 18:55:34','2024-05-02 18:55:34'),(3569,7908,980,40720,1550,3,217,1,32065.18,NULL,'2024-03-27 11:40:11','2024-05-02 18:56:44','2024-05-02 18:56:44'),(3570,7908,980,40720,1550,3,68,1,6733.69,NULL,'2024-03-27 11:40:11','2024-05-02 18:56:44','2024-05-02 18:56:44'),(3571,7908,980,40720,1550,3,217,1,3807.14,NULL,'2024-03-27 11:40:12','2024-05-02 18:56:44','2024-05-02 18:56:44'),(3572,7908,980,40720,1550,3,57,2,42606.01,NULL,'2024-03-27 11:40:12','2024-05-02 18:56:44','2024-05-02 18:56:44'),(3573,7908,981,40720,1550,3,217,1,35069.41,NULL,'2024-03-27 11:40:12','2024-05-02 18:54:32','2024-05-02 18:54:32'),(3574,7908,981,40720,1550,3,68,1,7364.58,NULL,'2024-03-27 11:40:12','2024-05-02 18:54:32','2024-05-02 18:54:32'),(3575,7908,981,40720,1550,3,217,1,3569.54,NULL,'2024-03-27 11:40:12','2024-05-02 18:54:32','2024-05-02 18:54:32'),(3576,7908,981,40720,1550,3,57,2,46003.53,NULL,'2024-03-27 11:40:12','2024-05-02 18:54:32','2024-05-02 18:54:32'),(3577,7908,982,40720,1550,3,217,1,11821.57,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3578,7908,982,40720,1550,3,68,1,2482.53,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3579,7908,982,40720,1550,3,57,2,14304.10,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3580,7908,983,40720,1550,3,217,1,216163.79,NULL,'2024-03-27 11:40:12','2024-05-02 18:52:07','2024-05-02 18:52:07'),(3581,7908,983,40720,1550,3,68,1,45394.40,NULL,'2024-03-27 11:40:12','2024-05-02 18:52:07','2024-05-02 18:52:07'),(3582,7908,983,40720,1550,3,217,1,1621.23,NULL,'2024-03-27 11:40:12','2024-05-02 18:52:07','2024-05-02 18:52:07'),(3583,7908,983,40720,1550,3,57,2,263179.42,NULL,'2024-03-27 11:40:12','2024-05-02 18:52:07','2024-05-02 18:52:07'),(3584,7908,984,40720,1550,3,217,1,112557.66,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3585,7908,984,40720,1550,3,68,1,23637.11,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3586,7908,984,40720,1550,3,57,2,136194.77,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3587,7908,985,40720,1550,3,217,1,314049.59,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3588,7908,985,40720,1550,3,68,1,65950.41,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3589,7908,985,40720,1550,3,57,2,380000.00,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3590,7908,986,40720,1550,3,217,1,11690.39,NULL,'2024-03-27 11:40:12','2024-05-02 18:59:17','2024-05-02 18:59:17'),(3591,7908,986,40720,1550,3,68,1,2454.98,NULL,'2024-03-27 11:40:12','2024-05-02 18:59:17','2024-05-02 18:59:17'),(3592,7908,986,40720,1550,3,217,1,0.01,NULL,'2024-03-27 11:40:12','2024-05-02 18:59:17','2024-05-02 18:59:17'),(3593,7908,986,40720,1550,3,57,2,14145.38,NULL,'2024-03-27 11:40:12','2024-05-02 18:59:17','2024-05-02 18:59:17'),(3594,7908,987,40720,1550,3,217,1,20002.55,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3595,7908,987,40720,1550,3,68,1,4200.54,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3596,7908,987,40720,1550,3,57,2,24203.09,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3597,7908,988,40720,1550,3,217,1,5950.41,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3598,7908,988,40720,1550,3,68,1,1249.59,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL),(3599,7908,988,40720,1550,3,57,2,7200.00,NULL,'2024-03-27 11:40:12','2024-03-27 11:40:12',NULL);
INSERT INTO `balance_libro_details` VALUES (3600,7908,989,40720,1550,3,217,1,270459.00,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:46','2024-05-02 18:51:46'),(3601,7908,989,40720,1550,3,68,1,56796.39,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:46','2024-05-02 18:51:46'),(3602,7908,989,40720,1550,3,217,1,2.39,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:46','2024-05-02 18:51:46'),(3603,7908,989,40720,1550,3,57,2,329288.09,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:46','2024-05-02 18:51:46'),(3604,7908,989,40720,1550,3,136,1,2030.31,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:46','2024-05-02 18:51:46'),(3605,7908,990,40720,1550,3,217,1,152579.70,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:30','2024-05-02 18:51:30'),(3606,7908,990,40720,1550,3,68,1,32038.34,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:30','2024-05-02 18:51:30'),(3607,7908,990,40720,1550,3,217,1,1.35,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:30','2024-05-02 18:51:30'),(3608,7908,990,40720,1550,3,57,2,185766.21,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:30','2024-05-02 18:51:30'),(3609,7908,990,40720,1550,3,136,1,1146.82,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:30','2024-05-02 18:51:30'),(3610,7908,991,40720,1550,3,217,1,47628.00,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:04','2024-05-02 18:51:04'),(3611,7908,991,40720,1550,3,68,1,10001.88,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:04','2024-05-02 18:51:04'),(3612,7908,991,40720,1550,3,217,1,0.42,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:04','2024-05-02 18:51:04'),(3613,7908,991,40720,1550,3,57,2,57987.09,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:04','2024-05-02 18:51:04'),(3614,7908,991,40720,1550,3,136,1,356.79,NULL,'2024-03-27 11:40:12','2024-05-02 18:51:04','2024-05-02 18:51:04'),(3615,7908,992,40720,1550,3,217,1,16146.69,NULL,'2024-03-27 11:40:13','2024-03-27 11:40:13',NULL),(3616,7908,992,40720,1550,3,68,1,3390.81,NULL,'2024-03-27 11:40:13','2024-03-27 11:40:13',NULL),(3617,7908,992,40720,1550,3,57,2,19537.50,NULL,'2024-03-27 11:40:13','2024-03-27 11:40:13',NULL),(3618,7908,993,40720,1550,3,217,1,14876.03,NULL,'2024-03-27 11:40:13','2024-03-27 11:40:13',NULL),(3619,7908,993,40720,1550,3,68,1,3123.97,NULL,'2024-03-27 11:40:13','2024-03-27 11:40:13',NULL),(3620,7908,993,40720,1550,3,57,2,18000.00,NULL,'2024-03-27 11:40:13','2024-03-27 11:40:13',NULL),(3621,7908,994,40720,1550,3,217,1,68380.20,NULL,'2024-03-27 11:40:13','2024-05-02 18:50:44','2024-05-02 18:50:44'),(3622,7908,994,40720,1550,3,68,1,14356.44,NULL,'2024-03-27 11:40:13','2024-05-02 18:50:44','2024-05-02 18:50:44'),(3623,7908,994,40720,1550,3,217,1,0.60,NULL,'2024-03-27 11:40:13','2024-05-02 18:50:44','2024-05-02 18:50:44'),(3624,7908,994,40720,1550,3,57,2,83246.94,NULL,'2024-03-27 11:40:13','2024-05-02 18:50:44','2024-05-02 18:50:44'),(3625,7908,994,40720,1550,3,136,1,509.70,NULL,'2024-03-27 11:40:13','2024-05-02 18:50:44','2024-05-02 18:50:44'),(3626,7908,995,40720,1550,3,217,1,8556.62,NULL,'2024-03-27 11:40:13','2024-05-02 18:53:55','2024-05-02 18:53:55'),(3627,7908,995,40720,1550,3,68,1,1796.89,NULL,'2024-03-27 11:40:13','2024-05-02 18:53:55','2024-05-02 18:53:55'),(3628,7908,995,40720,1550,3,217,1,64.17,NULL,'2024-03-27 11:40:13','2024-05-02 18:53:55','2024-05-02 18:53:55'),(3629,7908,995,40720,1550,3,57,2,10417.68,NULL,'2024-03-27 11:40:13','2024-05-02 18:53:55','2024-05-02 18:53:55'),(3630,7908,996,40720,1549,7,25,1,2941054.43,NULL,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(3631,7908,996,40720,1549,7,13,2,2941054.43,NULL,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(3632,7908,997,40720,1549,7,25,1,295696.32,NULL,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(3633,7908,997,40720,1549,7,13,2,295696.32,NULL,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(3634,7908,998,40720,1549,7,25,1,451337.64,NULL,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(3635,7908,998,40720,1549,7,13,2,451337.64,NULL,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(3636,7908,999,40720,1549,7,25,1,415358.82,NULL,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3637,7908,999,40720,1549,7,13,2,415358.82,NULL,'2024-03-27 13:34:47','2024-03-27 13:34:47',NULL),(3638,7908,1000,40720,1549,2,96,2,4224233.12,NULL,'2024-03-27 14:34:33','2024-03-27 19:41:22','2024-03-27 19:41:22'),(3639,7908,1000,40720,1549,2,67,2,443544.48,NULL,'2024-03-27 14:34:33','2024-03-27 19:41:22','2024-03-27 19:41:22'),(3640,7908,1000,40720,1549,2,13,1,4667777.60,NULL,'2024-03-27 14:34:33','2024-03-27 19:41:22','2024-03-27 19:41:22'),(3641,7908,1001,40720,1549,2,96,2,6447680.58,NULL,'2024-03-27 14:38:11','2024-03-27 19:41:02','2024-03-27 19:41:02'),(3642,7908,1001,40720,1549,2,67,2,677006.46,NULL,'2024-03-27 14:38:11','2024-03-27 19:41:02','2024-03-27 19:41:02'),(3643,7908,1001,40720,1549,2,13,1,7124687.04,NULL,'2024-03-27 14:38:12','2024-03-27 19:41:02','2024-03-27 19:41:02'),(3644,7908,1002,40720,1549,2,96,2,5933697.50,NULL,'2024-03-27 14:40:39','2024-03-27 19:40:40','2024-03-27 19:40:40'),(3645,7908,1002,40720,1549,2,67,2,623038.24,NULL,'2024-03-27 14:40:39','2024-03-27 19:40:40','2024-03-27 19:40:40'),(3646,7908,1002,40720,1549,2,13,1,6556735.74,NULL,'2024-03-27 14:40:39','2024-03-27 19:40:40','2024-03-27 19:40:40'),(3647,7908,1003,40720,1549,2,96,2,42015063.25,NULL,'2024-03-27 14:43:05','2024-03-27 19:40:17','2024-03-27 19:40:17'),(3648,7908,1003,40720,1549,2,67,2,4411581.64,NULL,'2024-03-27 14:43:05','2024-03-27 19:40:17','2024-03-27 19:40:17'),(3649,7908,1003,40720,1549,2,13,1,46426644.89,NULL,'2024-03-27 14:43:05','2024-03-27 19:40:17','2024-03-27 19:40:17'),(3650,7908,1004,40720,1549,3,217,1,34992.17,NULL,'2024-03-27 17:57:46','2024-03-27 17:57:46',NULL),(3651,7908,1004,40720,1549,3,68,1,7348.36,NULL,'2024-03-27 17:57:46','2024-03-27 17:57:46',NULL),(3652,7908,1004,40720,1549,3,249,1,262.44,NULL,'2024-03-27 17:57:46','2024-03-27 17:57:46',NULL),(3653,7908,1004,40720,1549,3,57,2,42602.97,NULL,'2024-03-27 17:57:46','2024-03-27 17:57:46',NULL),(3654,7908,1005,40720,1549,3,217,1,48112.33,NULL,'2024-03-27 17:59:28','2024-03-27 17:59:28',NULL),(3655,7908,1005,40720,1549,3,68,1,10103.59,NULL,'2024-03-27 17:59:28','2024-03-27 17:59:28',NULL),(3656,7908,1005,40720,1549,3,249,1,360.84,NULL,'2024-03-27 17:59:28','2024-03-27 17:59:28',NULL),(3657,7908,1005,40720,1549,3,57,2,58576.76,NULL,'2024-03-27 17:59:28','2024-03-27 17:59:28',NULL),(3658,7908,1006,40720,1549,3,217,1,126829.69,NULL,'2024-03-27 18:00:21','2024-03-27 18:00:21',NULL),(3659,7908,1006,40720,1549,3,68,1,26634.23,NULL,'2024-03-27 18:00:21','2024-03-27 18:00:21',NULL),(3660,7908,1006,40720,1549,3,249,1,951.22,NULL,'2024-03-27 18:00:21','2024-03-27 18:00:21',NULL),(3661,7908,1006,40720,1549,3,57,2,154415.14,NULL,'2024-03-27 18:00:21','2024-03-27 18:00:21',NULL),(3662,7908,1007,40720,1549,3,217,1,97540.03,NULL,'2024-03-27 18:12:43','2024-03-27 18:12:43',NULL),(3663,7908,1007,40720,1549,3,68,1,20483.41,NULL,'2024-03-27 18:12:43','2024-03-27 18:12:43',NULL),(3664,7908,1007,40720,1549,3,221,1,4580.54,NULL,'2024-03-27 18:12:43','2024-03-27 18:12:43',NULL),(3665,7908,1007,40720,1549,3,57,2,122603.98,NULL,'2024-03-27 18:12:43','2024-03-27 18:12:43',NULL),(3666,7908,1008,40720,1549,3,217,1,24779.88,NULL,'2024-03-27 18:13:35','2024-03-27 18:13:35',NULL),(3667,7908,1008,40720,1549,3,68,1,5203.77,NULL,'2024-03-27 18:13:35','2024-03-27 18:13:35',NULL),(3668,7908,1008,40720,1549,3,221,1,1322.38,NULL,'2024-03-27 18:13:35','2024-03-27 18:13:35',NULL),(3669,7908,1008,40720,1549,3,57,2,31306.03,NULL,'2024-03-27 18:13:35','2024-03-27 18:13:35',NULL),(3670,7908,1009,40720,1549,3,217,1,31660.70,NULL,'2024-03-27 18:14:24','2024-03-27 18:14:24',NULL),(3671,7908,1009,40720,1549,3,68,1,6648.75,NULL,'2024-03-27 18:14:24','2024-03-27 18:14:24',NULL),(3672,7908,1009,40720,1549,3,221,1,1689.57,NULL,'2024-03-27 18:14:24','2024-03-27 18:14:24',NULL),(3673,7908,1009,40720,1549,3,57,2,39999.02,NULL,'2024-03-27 18:14:24','2024-03-27 18:14:24',NULL),(3674,7908,1010,40720,1549,3,217,1,23746.11,NULL,'2024-03-27 18:15:04','2024-03-27 18:15:04',NULL);
INSERT INTO `balance_libro_details` VALUES (3675,7908,1010,40720,1549,3,68,1,4986.68,NULL,'2024-03-27 18:15:04','2024-03-27 18:15:04',NULL),(3676,7908,1010,40720,1549,3,221,1,1267.21,NULL,'2024-03-27 18:15:04','2024-03-27 18:15:04',NULL),(3677,7908,1010,40720,1549,3,57,2,30000.00,NULL,'2024-03-27 18:15:04','2024-03-27 18:15:04',NULL),(3678,7908,1011,40720,1549,3,217,1,44326.09,NULL,'2024-03-27 18:15:50','2024-03-27 18:15:50',NULL),(3679,7908,1011,40720,1549,3,68,1,9308.48,NULL,'2024-03-27 18:15:50','2024-03-27 18:15:50',NULL),(3680,7908,1011,40720,1549,3,221,1,2365.46,NULL,'2024-03-27 18:15:50','2024-03-27 18:15:50',NULL),(3681,7908,1011,40720,1549,3,57,2,56000.03,NULL,'2024-03-27 18:15:50','2024-03-27 18:15:50',NULL),(3682,7908,1012,40720,1549,3,217,1,35618.41,NULL,'2024-03-27 18:16:43','2024-03-27 18:16:43',NULL),(3683,7908,1012,40720,1549,3,68,1,7479.87,NULL,'2024-03-27 18:16:43','2024-03-27 18:16:43',NULL),(3684,7908,1012,40720,1549,3,221,1,1900.77,NULL,'2024-03-27 18:16:43','2024-03-27 18:16:43',NULL),(3685,7908,1012,40720,1549,3,57,2,44999.05,NULL,'2024-03-27 18:16:44','2024-03-27 18:16:44',NULL),(3686,7908,1013,40720,1549,3,217,1,31915.64,NULL,'2024-03-27 18:18:02','2024-03-27 18:18:02',NULL),(3687,7908,1013,40720,1549,3,68,1,6702.28,NULL,'2024-03-27 18:18:02','2024-03-27 18:18:02',NULL),(3688,7908,1013,40720,1549,3,221,1,1393.04,NULL,'2024-03-27 18:18:02','2024-03-27 18:18:02',NULL),(3689,7908,1013,40720,1549,3,57,2,40010.96,NULL,'2024-03-27 18:18:02','2024-03-27 18:18:02',NULL),(3690,7908,1014,40720,1549,3,217,1,46158.50,NULL,'2024-03-27 18:18:51','2024-03-27 18:18:51',NULL),(3691,7908,1014,40720,1549,3,68,1,9693.29,NULL,'2024-03-27 18:18:51','2024-03-27 18:18:51',NULL),(3692,7908,1014,40720,1549,3,222,1,2153.17,NULL,'2024-03-27 18:18:51','2024-03-27 18:18:51',NULL),(3693,7908,1014,40720,1549,3,57,2,58004.96,NULL,'2024-03-27 18:18:51','2024-03-27 18:18:51',NULL),(3694,7908,1015,40720,1549,3,217,1,15831.37,NULL,'2024-03-27 18:19:39','2024-03-27 18:19:39',NULL),(3695,7908,1015,40720,1549,3,68,1,3324.59,NULL,'2024-03-27 18:19:39','2024-03-27 18:19:39',NULL),(3696,7908,1015,40720,1549,3,221,1,844.84,NULL,'2024-03-27 18:19:39','2024-03-27 18:19:39',NULL),(3697,7908,1015,40720,1549,3,57,2,20000.80,NULL,'2024-03-27 18:19:39','2024-03-27 18:19:39',NULL),(3698,7908,1016,40720,1549,3,217,1,11688.02,NULL,'2024-03-27 18:20:38','2024-03-27 18:20:38',NULL),(3699,7908,1016,40720,1549,3,68,1,2454.48,NULL,'2024-03-27 18:20:38','2024-03-27 18:20:38',NULL),(3700,7908,1016,40720,1549,3,221,1,857.48,NULL,'2024-03-27 18:20:38','2024-03-27 18:20:38',NULL),(3701,7908,1016,40720,1549,3,57,2,14999.98,NULL,'2024-03-27 18:20:38','2024-03-27 18:20:38',NULL),(3702,7908,1017,40720,1549,3,217,1,15600.37,NULL,'2024-03-27 18:21:41','2024-03-27 18:21:41',NULL),(3703,7908,1017,40720,1549,3,68,1,3276.08,NULL,'2024-03-27 18:21:41','2024-03-27 18:21:41',NULL),(3704,7908,1017,40720,1549,3,221,1,1144.51,NULL,'2024-03-27 18:21:41','2024-03-27 18:21:41',NULL),(3705,7908,1017,40720,1549,3,57,2,20020.96,NULL,'2024-03-27 18:21:41','2024-03-27 18:21:41',NULL),(3706,7908,1018,40720,1549,3,217,1,14247.64,NULL,'2024-03-27 18:22:28','2024-03-27 18:32:43','2024-03-27 18:32:43'),(3707,7908,1018,40720,1549,3,68,1,2992.00,NULL,'2024-03-27 18:22:28','2024-03-27 18:32:43','2024-03-27 18:32:43'),(3708,7908,1018,40720,1549,3,221,1,760.33,NULL,'2024-03-27 18:22:28','2024-03-27 18:32:43','2024-03-27 18:32:43'),(3709,7908,1018,40720,1549,3,57,2,17999.97,NULL,'2024-03-27 18:22:28','2024-03-27 18:32:43','2024-03-27 18:32:43'),(3710,7908,1019,40720,1549,3,217,1,31903.68,NULL,'2024-03-27 18:23:28','2024-03-27 18:33:17','2024-03-27 18:33:17'),(3711,7908,1019,40720,1549,3,68,1,6699.77,NULL,'2024-03-27 18:23:28','2024-03-27 18:33:17','2024-03-27 18:33:17'),(3712,7908,1019,40720,1549,3,221,1,1392.52,NULL,'2024-03-27 18:23:28','2024-03-27 18:33:17','2024-03-27 18:33:17'),(3713,7908,1019,40720,1549,3,57,2,39995.97,NULL,'2024-03-27 18:23:28','2024-03-27 18:33:17','2024-03-27 18:33:17');
INSERT INTO `balance_libro_details` VALUES (3714,7908,1020,40720,1549,3,217,1,14251.65,NULL,'2024-03-27 18:24:28','2024-03-27 18:32:21','2024-03-27 18:32:21'),(3715,7908,1020,40720,1549,3,68,1,2992.85,NULL,'2024-03-27 18:24:28','2024-03-27 18:32:21','2024-03-27 18:32:21'),(3716,7908,1020,40720,1549,3,221,1,760.54,NULL,'2024-03-27 18:24:28','2024-03-27 18:32:21','2024-03-27 18:32:21'),(3717,7908,1020,40720,1549,3,57,2,18005.04,NULL,'2024-03-27 18:24:28','2024-03-27 18:32:21','2024-03-27 18:32:21'),(3718,7908,1021,40720,1549,3,217,1,23376.11,NULL,'2024-03-27 18:27:27','2024-03-27 18:27:27',NULL),(3719,7908,1021,40720,1549,3,68,1,4908.98,NULL,'2024-03-27 18:27:27','2024-03-27 18:27:27',NULL),(3720,7908,1021,40720,1549,3,221,1,1714.97,NULL,'2024-03-27 18:27:27','2024-03-27 18:27:27',NULL),(3721,7908,1021,40720,1549,3,57,2,30000.06,NULL,'2024-03-27 18:27:27','2024-03-27 18:27:27',NULL),(3722,7908,1022,40720,1549,3,217,1,23376.03,NULL,'2024-03-27 18:31:48','2024-03-27 18:31:48',NULL),(3723,7908,1022,40720,1549,3,68,1,4908.97,NULL,'2024-03-27 18:31:48','2024-03-27 18:31:48',NULL),(3724,7908,1022,40720,1549,3,221,1,1714.97,NULL,'2024-03-27 18:31:48','2024-03-27 18:31:48',NULL),(3725,7908,1022,40720,1549,3,57,2,29999.97,NULL,'2024-03-27 18:31:48','2024-03-27 18:31:48',NULL),(3726,7908,1023,40720,1549,3,217,1,14251.65,NULL,'2024-03-27 18:32:21','2024-03-27 18:32:21',NULL),(3727,7908,1023,40720,1549,3,68,1,2992.85,NULL,'2024-03-27 18:32:21','2024-03-27 18:32:21',NULL),(3728,7908,1023,40720,1549,3,221,1,760.54,NULL,'2024-03-27 18:32:21','2024-03-27 18:32:21',NULL),(3729,7908,1023,40720,1549,3,57,2,18005.04,NULL,'2024-03-27 18:32:21','2024-03-27 18:32:21',NULL),(3730,7908,1024,40720,1549,3,217,1,14247.64,NULL,'2024-03-27 18:32:43','2024-03-27 18:32:43',NULL),(3731,7908,1024,40720,1549,3,68,1,2992.00,NULL,'2024-03-27 18:32:43','2024-03-27 18:32:43',NULL),(3732,7908,1024,40720,1549,3,221,1,760.33,NULL,'2024-03-27 18:32:43','2024-03-27 18:32:43',NULL),(3733,7908,1024,40720,1549,3,57,2,17999.97,NULL,'2024-03-27 18:32:43','2024-03-27 18:32:43',NULL),(3734,7908,1025,40720,1549,3,217,1,31903.68,NULL,'2024-03-27 18:33:18','2024-03-27 18:33:18',NULL),(3735,7908,1025,40720,1549,3,68,1,6699.77,NULL,'2024-03-27 18:33:18','2024-03-27 18:33:18',NULL),(3736,7908,1025,40720,1549,3,221,1,1392.52,NULL,'2024-03-27 18:33:18','2024-03-27 18:33:18',NULL),(3737,7908,1025,40720,1549,3,57,2,39995.97,NULL,'2024-03-27 18:33:18','2024-03-27 18:33:18',NULL),(3738,7908,1026,40720,1549,15,67,1,8341948.07,NULL,'2024-03-27 18:34:56','2024-03-27 18:41:03','2024-03-27 18:41:03'),(3739,7908,1026,40720,1549,15,68,2,4077102.88,NULL,'2024-03-27 18:34:56','2024-03-27 18:41:03','2024-03-27 18:41:03'),(3740,7908,1026,40720,1549,15,25,2,4103447.21,NULL,'2024-03-27 18:34:56','2024-03-27 18:41:03','2024-03-27 18:41:03'),(3741,7908,1026,40720,1549,15,74,2,161397.98,NULL,'2024-03-27 18:34:56','2024-03-27 18:41:03','2024-03-27 18:41:03'),(3742,7908,1027,40720,1549,3,217,1,15584.02,NULL,'2024-03-27 18:42:38','2024-03-27 18:42:38',NULL),(3743,7908,1027,40720,1549,3,68,1,3272.64,NULL,'2024-03-27 18:42:38','2024-03-27 18:42:38',NULL),(3744,7908,1027,40720,1549,3,57,2,18856.66,NULL,'2024-03-27 18:42:38','2024-03-27 18:42:38',NULL),(3745,7908,1028,40720,1549,3,217,1,141220.80,NULL,'2024-03-27 18:43:30','2024-03-27 18:43:30',NULL),(3746,7908,1028,40720,1549,3,68,1,29656.37,NULL,'2024-03-27 18:43:30','2024-03-27 18:43:30',NULL),(3747,7908,1028,40720,1549,3,57,2,170877.17,NULL,'2024-03-27 18:43:30','2024-03-27 18:43:30',NULL),(3748,7908,1029,40720,1549,3,217,1,267310.80,NULL,'2024-03-27 18:43:50','2024-03-27 18:43:50',NULL),(3749,7908,1029,40720,1549,3,68,1,56135.27,NULL,'2024-03-27 18:43:50','2024-03-27 18:43:50',NULL),(3750,7908,1029,40720,1549,3,57,2,323446.07,NULL,'2024-03-27 18:43:50','2024-03-27 18:43:50',NULL),(3751,7908,1030,40720,1549,3,217,1,67584.24,NULL,'2024-03-27 18:44:11','2024-03-27 18:44:11',NULL),(3752,7908,1030,40720,1549,3,68,1,14192.69,NULL,'2024-03-27 18:44:11','2024-03-27 18:44:11',NULL);
INSERT INTO `balance_libro_details` VALUES (3753,7908,1030,40720,1549,3,57,2,81776.93,NULL,'2024-03-27 18:44:11','2024-03-27 18:44:11',NULL),(3754,7908,1031,40720,1549,3,217,1,67584.24,NULL,'2024-03-27 18:44:27','2024-03-27 18:44:27',NULL),(3755,7908,1031,40720,1549,3,68,1,14192.69,NULL,'2024-03-27 18:44:27','2024-03-27 18:44:27',NULL),(3756,7908,1031,40720,1549,3,57,2,81776.93,NULL,'2024-03-27 18:44:27','2024-03-27 18:44:27',NULL),(3757,7908,1032,40720,1549,3,217,1,267310.80,NULL,'2024-03-27 18:45:22','2024-03-27 18:45:22',NULL),(3758,7908,1032,40720,1549,3,68,1,56135.27,NULL,'2024-03-27 18:45:22','2024-03-27 18:45:22',NULL),(3759,7908,1032,40720,1549,3,57,2,323446.07,NULL,'2024-03-27 18:45:22','2024-03-27 18:45:22',NULL),(3760,7908,1033,40720,1549,3,217,1,47073.60,NULL,'2024-03-27 18:45:38','2024-03-27 18:45:38',NULL),(3761,7908,1033,40720,1549,3,68,1,9885.46,NULL,'2024-03-27 18:45:38','2024-03-27 18:45:38',NULL),(3762,7908,1033,40720,1549,3,57,2,56959.06,NULL,'2024-03-27 18:45:38','2024-03-27 18:45:38',NULL),(3763,7908,1034,40720,1549,3,217,1,47073.60,NULL,'2024-03-27 18:45:58','2024-03-27 18:45:58',NULL),(3764,7908,1034,40720,1549,3,68,1,9885.46,NULL,'2024-03-27 18:45:58','2024-03-27 18:45:58',NULL),(3765,7908,1034,40720,1549,3,57,2,56959.06,NULL,'2024-03-27 18:45:58','2024-03-27 18:45:58',NULL),(3766,7908,1035,40720,1549,15,67,1,8341948.07,NULL,'2024-03-27 19:38:37','2024-03-27 19:39:39','2024-03-27 19:39:39'),(3767,7908,1035,40720,1549,15,68,2,4077102.88,NULL,'2024-03-27 19:38:37','2024-03-27 19:39:39','2024-03-27 19:39:39'),(3768,7908,1035,40720,1549,15,25,2,4103447.21,NULL,'2024-03-27 19:38:37','2024-03-27 19:39:39','2024-03-27 19:39:39'),(3769,7908,1035,40720,1549,15,74,2,161397.98,NULL,'2024-03-27 19:38:37','2024-03-27 19:39:39','2024-03-27 19:39:39'),(3770,7908,1036,40720,1549,2,96,2,42015063.25,NULL,'2024-03-27 19:40:17','2024-03-27 19:40:17',NULL),(3771,7908,1036,40720,1549,2,67,2,4411581.64,NULL,'2024-03-27 19:40:17','2024-03-27 19:40:17',NULL),(3772,7908,1036,40720,1549,2,13,1,46426644.89,NULL,'2024-03-27 19:40:17','2024-03-27 19:40:17',NULL),(3773,7908,1037,40720,1549,2,96,2,5933697.50,NULL,'2024-03-27 19:40:40','2024-03-27 19:40:40',NULL),(3774,7908,1037,40720,1549,2,67,2,623038.24,NULL,'2024-03-27 19:40:40','2024-03-27 19:40:40',NULL),(3775,7908,1037,40720,1549,2,13,1,6556735.74,NULL,'2024-03-27 19:40:40','2024-03-27 19:40:40',NULL),(3776,7908,1038,40720,1549,2,96,2,6447680.58,NULL,'2024-03-27 19:41:02','2024-03-27 19:41:02',NULL),(3777,7908,1038,40720,1549,2,67,2,677006.46,NULL,'2024-03-27 19:41:02','2024-03-27 19:41:02',NULL),(3778,7908,1038,40720,1549,2,13,1,7124687.04,NULL,'2024-03-27 19:41:02','2024-03-27 19:41:02',NULL),(3779,7908,1039,40720,1549,2,96,2,4224233.12,NULL,'2024-03-27 19:41:22','2024-03-27 19:41:22',NULL),(3780,7908,1039,40720,1549,2,67,2,443544.48,NULL,'2024-03-27 19:41:22','2024-03-27 19:41:22',NULL),(3781,7908,1039,40720,1549,2,13,1,4667777.60,NULL,'2024-03-27 19:41:22','2024-03-27 19:41:22',NULL),(3782,7908,1040,40720,1549,15,67,1,8341948.07,NULL,'2024-03-27 19:55:32','2024-04-23 22:08:02','2024-04-23 22:08:02'),(3783,7908,1040,40720,1549,15,68,2,4077102.88,NULL,'2024-03-27 19:55:32','2024-04-23 22:08:02','2024-04-23 22:08:02'),(3784,7908,1040,40720,1549,15,25,2,4103447.21,NULL,'2024-03-27 19:55:32','2024-04-23 22:08:02','2024-04-23 22:08:02'),(3785,7908,1040,40720,1549,15,74,2,161397.98,NULL,'2024-03-27 19:55:32','2024-04-23 22:08:02','2024-04-23 22:08:02'),(3786,7908,1041,40720,1550,3,217,1,12396.69,NULL,'2024-03-28 11:12:45','2024-03-28 11:12:45',NULL),(3787,7908,1041,40720,1550,3,68,1,2603.30,NULL,'2024-03-28 11:12:45','2024-03-28 11:12:45',NULL),(3788,7908,1041,40720,1550,3,57,2,14999.99,NULL,'2024-03-28 11:12:45','2024-03-28 11:12:45',NULL),(3789,7908,1042,40720,1551,2,96,2,8471075.00,NULL,'2024-04-08 10:16:03','2024-04-08 10:16:03',NULL),(3790,7908,1042,40720,1551,2,67,2,1778925.75,NULL,'2024-04-08 10:16:03','2024-04-08 10:16:03',NULL);
INSERT INTO `balance_libro_details` VALUES (3791,7908,1042,40720,1551,2,13,1,10250000.75,NULL,'2024-04-08 10:16:03','2024-04-08 10:16:03',NULL),(3792,7908,1043,40720,1551,2,96,2,137640.00,NULL,'2024-04-17 11:30:32','2024-04-17 11:30:32',NULL),(3793,7908,1043,40720,1551,2,67,2,14452.20,NULL,'2024-04-17 11:30:32','2024-04-17 11:30:32',NULL),(3794,7908,1043,40720,1551,2,13,1,152092.20,NULL,'2024-04-17 11:30:32','2024-04-17 11:30:32',NULL),(3795,7908,1044,40720,1539,3,217,1,37601600.00,NULL,'2024-04-23 20:32:18','2024-04-23 20:37:04','2024-04-23 20:37:04'),(3796,7908,1044,40720,1539,3,68,1,3948168.00,NULL,'2024-04-23 20:32:18','2024-04-23 20:37:04','2024-04-23 20:37:04'),(3797,7908,1044,40720,1539,3,57,2,41549768.00,NULL,'2024-04-23 20:32:18','2024-04-23 20:37:04','2024-04-23 20:37:04'),(3798,7908,1045,40720,1539,3,391,1,37601600.00,NULL,'2024-04-23 20:37:04','2024-04-23 20:37:04',NULL),(3799,7908,1045,40720,1539,3,68,1,3948168.00,NULL,'2024-04-23 20:37:04','2024-04-23 20:37:04',NULL),(3800,7908,1045,40720,1539,3,57,2,41549768.00,NULL,'2024-04-23 20:37:04','2024-04-23 20:37:04',NULL),(3801,7908,1046,40720,1539,15,67,1,4604480.78,NULL,'2024-04-23 21:28:19','2024-04-23 21:28:19',NULL),(3802,7908,1046,40720,1539,15,68,2,4771073.90,NULL,'2024-04-23 21:28:19','2024-04-23 21:28:19',NULL),(3803,7908,1046,40720,1539,15,25,2,20893.03,NULL,'2024-04-23 21:28:19','2024-04-23 21:28:19',NULL),(3804,7908,1046,40720,1539,15,353,1,166593.12,NULL,'2024-04-23 21:28:19','2024-04-23 21:28:19',NULL),(3805,7908,1046,40720,1539,15,354,1,20893.03,NULL,'2024-04-23 21:28:19','2024-04-23 21:28:19',NULL),(3806,7908,1047,40720,1536,3,390,1,5352809.92,NULL,'2024-04-23 21:31:03','2024-04-23 21:31:03',NULL),(3807,7908,1047,40720,1536,3,68,1,1124090.08,NULL,'2024-04-23 21:31:03','2024-04-23 21:31:03',NULL),(3808,7908,1047,40720,1536,3,57,2,6476900.00,NULL,'2024-04-23 21:31:03','2024-04-23 21:31:03',NULL),(3809,7908,1048,40720,1536,3,390,1,1719917.35,NULL,'2024-04-23 21:32:07','2024-04-23 21:32:07',NULL),(3810,7908,1048,40720,1536,3,68,1,361182.64,NULL,'2024-04-23 21:32:07','2024-04-23 21:32:07',NULL),(3811,7908,1048,40720,1536,3,390,1,19000.00,NULL,'2024-04-23 21:32:07','2024-04-23 21:32:07',NULL),(3812,7908,1048,40720,1536,3,57,2,2100099.99,NULL,'2024-04-23 21:32:07','2024-04-23 21:32:07',NULL),(3813,7908,1049,40720,1534,3,391,1,1575565.61,NULL,'2024-04-23 21:47:11','2024-04-23 21:47:11',NULL),(3814,7908,1049,40720,1534,3,68,1,165434.39,NULL,'2024-04-23 21:47:11','2024-04-23 21:47:11',NULL),(3815,7908,1049,40720,1534,3,57,2,1741000.00,NULL,'2024-04-23 21:47:11','2024-04-23 21:47:11',NULL),(3816,7908,1050,40720,1536,15,67,1,820041.71,NULL,'2024-04-23 21:47:41','2024-04-23 21:47:41',NULL),(3817,7908,1050,40720,1536,15,68,2,1507853.26,NULL,'2024-04-23 21:47:41','2024-04-23 21:47:41',NULL),(3818,7908,1050,40720,1536,15,353,2,37816.83,NULL,'2024-04-23 21:47:41','2024-04-23 21:47:41',NULL),(3819,7908,1050,40720,1536,15,353,1,725628.39,NULL,'2024-04-23 21:47:41','2024-04-23 21:47:41',NULL),(3820,7908,1050,40720,1536,15,136,2,0.01,NULL,'2024-04-23 21:47:41','2024-04-23 21:47:41',NULL),(3821,7908,1051,40720,1534,15,67,1,479008.53,NULL,'2024-04-23 21:48:00','2024-04-23 21:48:00',NULL),(3822,7908,1051,40720,1534,15,68,2,436176.46,NULL,'2024-04-23 21:48:00','2024-04-23 21:48:00',NULL),(3823,7908,1051,40720,1534,15,353,2,50282.01,NULL,'2024-04-23 21:48:00','2024-04-23 21:48:00',NULL),(3824,7908,1051,40720,1534,15,353,1,7449.94,NULL,'2024-04-23 21:48:00','2024-04-23 21:48:00',NULL),(3825,7908,1052,40720,1549,3,391,1,12307692.31,NULL,'2024-04-23 22:09:48','2024-04-23 22:09:48',NULL),(3826,7908,1052,40720,1549,3,68,1,1292307.69,NULL,'2024-04-23 22:09:48','2024-04-23 22:09:48',NULL),(3827,7908,1052,40720,1549,3,57,2,13600000.00,NULL,'2024-04-23 22:09:48','2024-04-23 22:09:48',NULL),(3828,7908,1053,40720,1548,3,390,1,505975.21,NULL,'2024-04-23 22:12:12','2024-04-23 22:12:12',NULL),(3829,7908,1053,40720,1548,3,68,1,106254.79,NULL,'2024-04-23 22:12:12','2024-04-23 22:12:12',NULL);
INSERT INTO `balance_libro_details` VALUES (3830,7908,1053,40720,1548,3,390,1,37770.00,NULL,'2024-04-23 22:12:12','2024-04-23 22:12:12',NULL),(3831,7908,1053,40720,1548,3,57,2,650000.00,NULL,'2024-04-23 22:12:12','2024-04-23 22:12:12',NULL),(3832,7908,1054,40720,1548,3,390,1,22587330.32,NULL,'2024-04-23 22:13:12','2024-04-23 22:13:12',NULL),(3833,7908,1054,40720,1548,3,68,1,2371669.68,NULL,'2024-04-23 22:13:12','2024-04-23 22:13:12',NULL),(3834,7908,1054,40720,1548,3,57,2,24959000.00,NULL,'2024-04-23 22:13:12','2024-04-23 22:13:12',NULL),(3835,7908,1055,40720,1549,15,67,1,8341948.07,NULL,'2024-04-23 22:14:52','2024-04-23 22:14:52',NULL),(3836,7908,1055,40720,1549,15,68,2,4077102.88,NULL,'2024-04-23 22:14:52','2024-04-23 22:14:52',NULL),(3837,7908,1055,40720,1549,15,25,2,4103447.21,NULL,'2024-04-23 22:14:52','2024-04-23 22:14:52',NULL),(3838,7908,1055,40720,1549,15,74,2,161397.98,NULL,'2024-04-23 22:14:52','2024-04-23 22:14:52',NULL),(3839,7908,1056,40720,1548,15,67,1,7124381.78,NULL,'2024-04-23 22:15:13','2024-11-13 13:00:58','2024-11-13 13:00:58'),(3840,7908,1056,40720,1548,15,68,2,6860843.88,NULL,'2024-04-23 22:15:13','2024-11-13 13:00:58','2024-11-13 13:00:58'),(3841,7908,1056,40720,1548,15,74,2,263537.90,NULL,'2024-04-23 22:15:13','2024-11-13 13:00:58','2024-11-13 13:00:58'),(3842,7908,1057,40720,1550,3,217,1,850991.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3843,7908,1057,40720,1550,3,68,1,178708.11,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3844,7908,1057,40720,1550,3,57,2,1029699.11,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3845,7908,1058,40720,1550,3,217,1,858148.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3846,7908,1058,40720,1550,3,68,1,180211.08,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3847,7908,1058,40720,1550,3,57,2,1038359.08,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3848,7908,1059,40720,1550,3,217,1,858876.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3849,7908,1059,40720,1550,3,68,1,180363.96,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3850,7908,1059,40720,1550,3,57,2,1039239.96,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3851,7908,1060,40720,1550,3,217,1,855749.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3852,7908,1060,40720,1550,3,68,1,179707.29,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3853,7908,1060,40720,1550,3,57,2,1035456.29,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3854,7908,1061,40720,1550,3,217,1,856142.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3855,7908,1061,40720,1550,3,68,1,179789.82,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3856,7908,1061,40720,1550,3,57,2,1035931.82,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3857,7908,1062,40720,1550,3,217,1,858003.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3858,7908,1062,40720,1550,3,68,1,180180.63,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3859,7908,1062,40720,1550,3,57,2,1038183.63,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3860,7908,1063,40720,1550,3,217,1,865245.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3861,7908,1063,40720,1550,3,68,1,181701.45,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3862,7908,1063,40720,1550,3,57,2,1046946.45,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3863,7908,1064,40720,1550,3,217,1,820399.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3864,7908,1064,40720,1550,3,68,1,172283.79,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3865,7908,1064,40720,1550,3,57,2,992682.79,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3866,7908,1065,40720,1550,3,217,1,903955.57,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3867,7908,1065,40720,1550,3,68,1,189830.67,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3868,7908,1065,40720,1550,3,57,2,1093786.24,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL);
INSERT INTO `balance_libro_details` VALUES (3869,7908,1066,40720,1550,3,217,1,843920.00,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3870,7908,1066,40720,1550,3,68,1,177223.20,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3871,7908,1066,40720,1550,3,57,2,1021143.20,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3872,7908,1067,40720,1550,3,217,1,57605.76,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3873,7908,1067,40720,1550,3,68,1,12097.21,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3874,7908,1067,40720,1550,3,57,2,69702.97,NULL,'2024-05-02 12:26:39','2024-05-02 12:26:39',NULL),(3875,7908,1068,40720,1550,3,217,1,68983.20,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:25','2024-05-02 18:50:25'),(3876,7908,1068,40720,1550,3,68,1,14483.04,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:25','2024-05-02 18:50:25'),(3877,7908,1068,40720,1550,3,217,1,0.60,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:25','2024-05-02 18:50:25'),(3878,7908,1068,40720,1550,3,57,2,83981.04,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:25','2024-05-02 18:50:25'),(3879,7908,1068,40720,1550,3,136,1,514.20,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:25','2024-05-02 18:50:25'),(3880,7908,1069,40720,1550,3,217,1,153925.20,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:00','2024-05-02 18:50:00'),(3881,7908,1069,40720,1550,3,68,1,32320.86,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:00','2024-05-02 18:50:00'),(3882,7908,1069,40720,1550,3,217,1,1.35,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:00','2024-05-02 18:50:00'),(3883,7908,1069,40720,1550,3,57,2,187404.36,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:00','2024-05-02 18:50:00'),(3884,7908,1069,40720,1550,3,136,1,1156.95,NULL,'2024-05-02 12:26:39','2024-05-02 18:50:00','2024-05-02 18:50:00'),(3885,7908,1070,40720,1550,3,217,1,25738.62,NULL,'2024-05-02 12:26:40','2024-05-02 12:26:40',NULL),(3886,7908,1070,40720,1550,3,68,1,5405.11,NULL,'2024-05-02 12:26:40','2024-05-02 12:26:40',NULL),(3887,7908,1070,40720,1550,3,57,2,31143.73,NULL,'2024-05-02 12:26:40','2024-05-02 12:26:40',NULL),(3888,7908,1071,40720,1551,3,217,1,19807.94,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3889,7908,1071,40720,1551,3,68,1,4159.67,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3890,7908,1071,40720,1551,3,57,2,23967.61,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3891,7908,1072,40720,1551,3,217,1,158815.80,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:59','2024-05-02 12:42:59'),(3892,7908,1072,40720,1551,3,68,1,33350.46,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:59','2024-05-02 12:42:59'),(3893,7908,1072,40720,1551,3,217,1,1.39,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:59','2024-05-02 12:42:59'),(3894,7908,1072,40720,1551,3,57,2,193358.88,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:59','2024-05-02 12:42:59'),(3895,7908,1072,40720,1551,3,136,1,1191.23,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:59','2024-05-02 12:42:59'),(3896,7908,1073,40720,1551,3,217,1,69224.40,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:43','2024-05-02 12:42:43'),(3897,7908,1073,40720,1551,3,68,1,14533.68,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:43','2024-05-02 12:42:43'),(3898,7908,1073,40720,1551,3,217,1,0.60,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:43','2024-05-02 12:42:43'),(3899,7908,1073,40720,1551,3,57,2,84274.68,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:43','2024-05-02 12:42:43'),(3900,7908,1073,40720,1551,3,136,1,516.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:42:43','2024-05-02 12:42:43'),(3901,7908,1074,40720,1551,3,217,1,4380.17,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3902,7908,1074,40720,1551,3,68,1,919.83,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3903,7908,1074,40720,1551,3,57,2,5300.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3904,7908,1075,40720,1551,3,217,1,1610.40,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3905,7908,1075,40720,1551,3,68,1,334.40,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL);
INSERT INTO `balance_libro_details` VALUES (3906,7908,1075,40720,1551,3,57,2,1944.80,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3907,7908,1076,40720,1551,3,217,1,1610.40,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3908,7908,1076,40720,1551,3,68,1,334.40,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3909,7908,1076,40720,1551,3,57,2,1944.80,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3910,7908,1077,40720,1551,3,217,1,69752.07,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3911,7908,1077,40720,1551,3,68,1,14647.93,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3912,7908,1077,40720,1551,3,57,2,84400.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3913,7908,1078,40720,1551,3,217,1,58925.62,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3914,7908,1078,40720,1551,3,68,1,12374.38,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3915,7908,1078,40720,1551,3,57,2,71300.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3916,7908,1079,40720,1551,3,217,1,2438.02,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3917,7908,1079,40720,1551,3,68,1,511.98,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3918,7908,1079,40720,1551,3,57,2,2950.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3919,7908,1080,40720,1551,3,217,1,37086000.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3920,7908,1080,40720,1551,3,68,1,3894030.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3921,7908,1080,40720,1551,3,57,2,40980030.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3922,7908,1081,40720,1551,3,217,1,33561991.15,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3923,7908,1081,40720,1551,3,68,1,3524008.85,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3924,7908,1081,40720,1551,3,57,2,37086000.00,NULL,'2024-05-02 12:40:07','2024-05-02 12:40:07',NULL),(3925,7908,1082,40720,1551,3,217,1,13282.64,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3926,7908,1082,40720,1551,3,68,1,2789.35,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3927,7908,1082,40720,1551,3,57,2,16071.99,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3928,7908,1083,40720,1551,3,217,1,102182.49,NULL,'2024-05-02 12:40:08','2024-05-02 12:42:24','2024-05-02 12:42:24'),(3929,7908,1083,40720,1551,3,68,1,21458.32,NULL,'2024-05-02 12:40:08','2024-05-02 12:42:24','2024-05-02 12:42:24'),(3930,7908,1083,40720,1551,3,217,1,766.37,NULL,'2024-05-02 12:40:08','2024-05-02 12:42:24','2024-05-02 12:42:24'),(3931,7908,1083,40720,1551,3,57,2,124407.18,NULL,'2024-05-02 12:40:08','2024-05-02 12:42:24','2024-05-02 12:42:24'),(3932,7908,1084,40720,1551,3,217,1,76033.06,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3933,7908,1084,40720,1551,3,68,1,15966.94,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3934,7908,1084,40720,1551,3,57,2,92000.00,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3935,7908,1085,40720,1551,3,217,1,14822.88,NULL,'2024-05-02 12:40:08','2024-05-02 12:41:54','2024-05-02 12:41:54'),(3936,7908,1085,40720,1551,3,68,1,3112.81,NULL,'2024-05-02 12:40:08','2024-05-02 12:41:54','2024-05-02 12:41:54'),(3937,7908,1085,40720,1551,3,217,1,2064.32,NULL,'2024-05-02 12:40:08','2024-05-02 12:41:54','2024-05-02 12:41:54'),(3938,7908,1085,40720,1551,3,57,2,20000.01,NULL,'2024-05-02 12:40:08','2024-05-02 12:41:54','2024-05-02 12:41:54'),(3939,7908,1086,40720,1551,3,217,1,77000.00,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3940,7908,1086,40720,1551,3,68,1,16170.00,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3941,7908,1086,40720,1551,3,57,2,93170.00,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3942,7908,1087,40720,1551,3,217,1,70749.17,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3943,7908,1087,40720,1551,3,68,1,14857.32,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3944,7908,1087,40720,1551,3,57,2,85606.49,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL);
INSERT INTO `balance_libro_details` VALUES (3945,7908,1088,40720,1551,3,217,1,12396.69,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3946,7908,1088,40720,1551,3,68,1,2603.30,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3947,7908,1088,40720,1551,3,57,2,14999.99,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3948,7908,1089,40720,1551,3,217,1,61816.36,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3949,7908,1089,40720,1551,3,68,1,12981.44,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3950,7908,1089,40720,1551,3,57,2,74797.80,NULL,'2024-05-02 12:40:08','2024-05-02 12:40:08',NULL),(3951,7908,1090,40720,1551,3,217,1,14822.88,NULL,'2024-05-02 12:41:54','2024-05-02 12:41:54',NULL),(3952,7908,1090,40720,1551,3,68,1,3112.80,NULL,'2024-05-02 12:41:54','2024-05-02 12:41:54',NULL),(3953,7908,1090,40720,1551,3,57,2,17935.68,NULL,'2024-05-02 12:41:54','2024-05-02 12:41:54',NULL),(3954,7908,1091,40720,1551,3,217,1,102182.49,NULL,'2024-05-02 12:42:24','2024-05-02 12:42:24',NULL),(3955,7908,1091,40720,1551,3,68,1,21458.32,NULL,'2024-05-02 12:42:24','2024-05-02 12:42:24',NULL),(3956,7908,1091,40720,1551,3,57,2,123640.81,NULL,'2024-05-02 12:42:24','2024-05-02 12:42:24',NULL),(3957,7908,1092,40720,1551,3,217,1,69224.40,NULL,'2024-05-02 12:42:43','2024-05-02 12:42:43',NULL),(3958,7908,1092,40720,1551,3,68,1,14537.12,NULL,'2024-05-02 12:42:43','2024-05-02 12:42:43',NULL),(3959,7908,1092,40720,1551,3,57,2,83761.52,NULL,'2024-05-02 12:42:43','2024-05-02 12:42:43',NULL),(3960,7908,1093,40720,1551,3,217,1,158815.80,NULL,'2024-05-02 12:42:59','2024-05-02 12:42:59',NULL),(3961,7908,1093,40720,1551,3,68,1,33351.32,NULL,'2024-05-02 12:42:59','2024-05-02 12:42:59',NULL),(3962,7908,1093,40720,1551,3,57,2,192167.12,NULL,'2024-05-02 12:42:59','2024-05-02 12:42:59',NULL),(3963,7908,1094,40720,1551,3,217,2,1610.40,NULL,'2024-05-02 12:51:57','2024-05-02 12:51:57',NULL),(3964,7908,1094,40720,1551,3,67,2,334.40,NULL,'2024-05-02 12:51:57','2024-05-02 12:51:57',NULL),(3965,7908,1094,40720,1551,3,57,1,1944.80,NULL,'2024-05-02 12:51:57','2024-05-02 12:51:57',NULL),(3966,7908,1095,40720,1551,3,217,2,37086000.00,NULL,'2024-05-02 12:51:57','2024-05-02 12:51:57',NULL),(3967,7908,1095,40720,1551,3,67,2,3894030.00,NULL,'2024-05-02 12:51:57','2024-05-02 12:51:57',NULL),(3968,7908,1095,40720,1551,3,57,1,40980030.00,NULL,'2024-05-02 12:51:57','2024-05-02 12:51:57',NULL),(3969,7908,1096,40720,1550,3,217,1,11661.91,NULL,'2024-05-02 18:29:25','2024-05-02 18:29:25',NULL),(3970,7908,1096,40720,1550,3,68,1,2449.00,NULL,'2024-05-02 18:29:25','2024-05-02 18:29:25',NULL),(3971,7908,1096,40720,1550,3,221,1,888.07,NULL,'2024-05-02 18:29:25','2024-05-02 18:29:25',NULL),(3972,7908,1096,40720,1550,3,57,2,14998.98,NULL,'2024-05-02 18:29:25','2024-05-02 18:29:25',NULL),(3973,7908,1097,40720,1550,3,217,1,18667.25,NULL,'2024-05-02 18:30:18','2024-05-02 18:30:18',NULL),(3974,7908,1097,40720,1550,3,68,1,3920.12,NULL,'2024-05-02 18:30:18','2024-05-02 18:30:18',NULL),(3975,7908,1097,40720,1550,3,221,1,2411.64,NULL,'2024-05-02 18:30:18','2024-05-02 18:30:18',NULL),(3976,7908,1097,40720,1550,3,57,2,24999.01,NULL,'2024-05-02 18:30:18','2024-05-02 18:30:18',NULL),(3977,7908,1098,40720,1550,3,217,1,22408.31,NULL,'2024-05-02 18:31:03','2024-05-02 18:31:03',NULL),(3978,7908,1098,40720,1550,3,68,1,4705.75,NULL,'2024-05-02 18:31:03','2024-05-02 18:31:03',NULL),(3979,7908,1098,40720,1550,3,221,1,2894.96,NULL,'2024-05-02 18:31:03','2024-05-02 18:31:03',NULL),(3980,7908,1098,40720,1550,3,57,2,30009.02,NULL,'2024-05-02 18:31:03','2024-05-02 18:31:03',NULL),(3981,7908,1099,40720,1550,3,217,1,31464.98,NULL,'2024-05-02 18:32:36','2024-05-02 18:32:36',NULL),(3982,7908,1099,40720,1550,3,68,1,6607.65,NULL,'2024-05-02 18:32:36','2024-05-02 18:32:36',NULL),(3983,7908,1099,40720,1550,3,221,1,1952.40,NULL,'2024-05-02 18:32:36','2024-05-02 18:32:36',NULL),(3984,7908,1099,40720,1550,3,57,2,40025.03,NULL,'2024-05-02 18:32:36','2024-05-02 18:32:36',NULL);
INSERT INTO `balance_libro_details` VALUES (3985,7908,1100,40720,1550,3,217,1,31455.51,NULL,'2024-05-02 18:33:29','2024-05-02 18:33:29',NULL),(3986,7908,1100,40720,1550,3,68,1,6605.66,NULL,'2024-05-02 18:33:29','2024-05-02 18:33:29',NULL),(3987,7908,1100,40720,1550,3,221,1,1951.82,NULL,'2024-05-02 18:33:29','2024-05-02 18:33:29',NULL),(3988,7908,1100,40720,1550,3,57,2,40012.99,NULL,'2024-05-02 18:33:29','2024-05-02 18:33:29',NULL),(3989,7908,1101,40720,1550,3,217,1,44077.36,NULL,'2024-05-02 18:34:51','2024-05-02 18:34:51',NULL),(3990,7908,1101,40720,1550,3,68,1,9256.25,NULL,'2024-05-02 18:34:51','2024-05-02 18:34:51',NULL),(3991,7908,1101,40720,1550,3,221,1,5694.40,NULL,'2024-05-02 18:34:51','2024-05-02 18:34:51',NULL),(3992,7908,1101,40720,1550,3,57,2,59028.01,NULL,'2024-05-02 18:34:51','2024-05-02 18:34:51',NULL),(3993,7908,1102,40720,1550,3,217,1,15231.24,NULL,'2024-05-02 18:35:48','2024-05-02 18:35:48',NULL),(3994,7908,1102,40720,1550,3,68,1,3198.56,NULL,'2024-05-02 18:35:48','2024-05-02 18:35:48',NULL),(3995,7908,1102,40720,1550,3,221,1,1605.24,NULL,'2024-05-02 18:35:48','2024-05-02 18:35:48',NULL),(3996,7908,1102,40720,1550,3,57,2,20035.04,NULL,'2024-05-02 18:35:48','2024-05-02 18:35:48',NULL),(3997,7908,1103,40720,1550,3,217,1,51097.81,NULL,'2024-05-02 18:36:52','2024-05-02 18:36:52',NULL),(3998,7908,1103,40720,1550,3,68,1,10730.54,NULL,'2024-05-02 18:36:52','2024-05-02 18:36:52',NULL),(3999,7908,1103,40720,1550,3,221,1,3170.62,NULL,'2024-05-02 18:36:52','2024-05-02 18:36:52',NULL),(4000,7908,1103,40720,1550,3,57,2,64998.97,NULL,'2024-05-02 18:36:52','2024-05-02 18:36:52',NULL),(4001,7908,1104,40720,1550,3,217,1,31100.55,NULL,'2024-05-02 18:37:50','2024-05-02 18:37:50',NULL),(4002,7908,1104,40720,1550,3,68,1,6531.12,NULL,'2024-05-02 18:37:50','2024-05-02 18:37:50',NULL),(4003,7908,1104,40720,1550,3,221,1,2368.34,NULL,'2024-05-02 18:37:50','2024-05-02 18:37:50',NULL),(4004,7908,1104,40720,1550,3,57,2,40000.01,NULL,'2024-05-02 18:37:50','2024-05-02 18:37:50',NULL),(4005,7908,1105,40720,1550,3,217,1,7468.69,NULL,'2024-05-02 18:40:56','2024-05-02 18:40:56',NULL),(4006,7908,1105,40720,1550,3,68,1,1568.42,NULL,'2024-05-02 18:40:56','2024-05-02 18:40:56',NULL),(4007,7908,1105,40720,1550,3,221,1,964.89,NULL,'2024-05-02 18:40:56','2024-05-02 18:40:56',NULL),(4008,7908,1105,40720,1550,3,57,2,10002.00,NULL,'2024-05-02 18:40:56','2024-05-02 18:40:56',NULL),(4009,7908,1106,40720,1550,3,217,1,35092.02,NULL,'2024-05-02 18:42:37','2024-05-02 18:42:37',NULL),(4010,7908,1106,40720,1550,3,68,1,7369.32,NULL,'2024-05-02 18:42:37','2024-05-02 18:42:37',NULL),(4011,7908,1106,40720,1550,3,221,1,4533.58,NULL,'2024-05-02 18:42:37','2024-05-02 18:42:37',NULL),(4012,7908,1106,40720,1550,3,57,2,46994.92,NULL,'2024-05-02 18:42:37','2024-05-02 18:42:37',NULL),(4013,7908,1107,40720,1550,3,217,1,153925.20,NULL,'2024-05-02 18:50:00','2024-05-02 18:50:00',NULL),(4014,7908,1107,40720,1550,3,68,1,32324.29,NULL,'2024-05-02 18:50:00','2024-05-02 18:50:00',NULL),(4015,7908,1107,40720,1550,3,57,2,186249.49,NULL,'2024-05-02 18:50:00','2024-05-02 18:50:00',NULL),(4016,7908,1108,40720,1550,3,217,1,68983.20,NULL,'2024-05-02 18:50:25','2024-05-02 18:50:25',NULL),(4017,7908,1108,40720,1550,3,68,1,14486.47,NULL,'2024-05-02 18:50:25','2024-05-02 18:50:25',NULL),(4018,7908,1108,40720,1550,3,57,2,83469.67,NULL,'2024-05-02 18:50:25','2024-05-02 18:50:25',NULL),(4019,7908,1109,40720,1550,3,217,1,68380.20,NULL,'2024-05-02 18:50:44','2024-05-02 18:50:44',NULL),(4020,7908,1109,40720,1550,3,68,1,14359.84,NULL,'2024-05-02 18:50:44','2024-05-02 18:50:44',NULL),(4021,7908,1109,40720,1550,3,57,2,82740.04,NULL,'2024-05-02 18:50:44','2024-05-02 18:50:44',NULL),(4022,7908,1110,40720,1550,3,217,1,47628.00,NULL,'2024-05-02 18:51:04','2024-05-02 18:51:04',NULL),(4023,7908,1110,40720,1550,3,68,1,10001.88,NULL,'2024-05-02 18:51:04','2024-05-02 18:51:04',NULL),(4024,7908,1110,40720,1550,3,57,2,57629.88,NULL,'2024-05-02 18:51:04','2024-05-02 18:51:04',NULL);
INSERT INTO `balance_libro_details` VALUES (4025,7908,1111,40720,1550,3,217,1,152579.70,NULL,'2024-05-02 18:51:30','2024-05-02 18:51:30',NULL),(4026,7908,1111,40720,1550,3,68,1,32041.74,NULL,'2024-05-02 18:51:30','2024-05-02 18:51:30',NULL),(4027,7908,1111,40720,1550,3,57,2,184621.44,NULL,'2024-05-02 18:51:30','2024-05-02 18:51:30',NULL),(4028,7908,1112,40720,1550,3,217,1,270459.00,NULL,'2024-05-02 18:51:46','2024-05-02 18:51:46',NULL),(4029,7908,1112,40720,1550,3,68,1,56796.39,NULL,'2024-05-02 18:51:46','2024-05-02 18:51:46',NULL),(4030,7908,1112,40720,1550,3,57,2,327255.39,NULL,'2024-05-02 18:51:46','2024-05-02 18:51:46',NULL),(4031,7908,1113,40720,1550,3,217,1,216163.79,NULL,'2024-05-02 18:52:07','2024-05-02 18:52:07',NULL),(4032,7908,1113,40720,1550,3,68,1,45394.40,NULL,'2024-05-02 18:52:07','2024-05-02 18:52:07',NULL),(4033,7908,1113,40720,1550,3,57,2,261558.19,NULL,'2024-05-02 18:52:07','2024-05-02 18:52:07',NULL),(4034,7908,1114,40720,1550,3,217,1,267915.00,NULL,'2024-05-02 18:52:27','2024-05-02 18:52:27',NULL),(4035,7908,1114,40720,1550,3,68,1,56262.15,NULL,'2024-05-02 18:52:27','2024-05-02 18:52:27',NULL),(4036,7908,1114,40720,1550,3,57,2,324177.15,NULL,'2024-05-02 18:52:27','2024-05-02 18:52:27',NULL),(4037,7908,1115,40720,1550,3,217,1,24895.88,NULL,'2024-05-02 18:52:45','2024-05-02 18:52:45',NULL),(4038,7908,1115,40720,1550,3,68,1,5228.13,NULL,'2024-05-02 18:52:45','2024-05-02 18:52:45',NULL),(4039,7908,1115,40720,1550,3,57,2,30124.01,NULL,'2024-05-02 18:52:45','2024-05-02 18:52:45',NULL),(4040,7908,1116,40720,1550,3,217,1,8556.62,NULL,'2024-05-02 18:53:55','2024-05-02 18:53:55',NULL),(4041,7908,1116,40720,1550,3,68,1,1796.89,NULL,'2024-05-02 18:53:55','2024-05-02 18:53:55',NULL),(4042,7908,1116,40720,1550,3,57,2,10353.51,NULL,'2024-05-02 18:53:55','2024-05-02 18:53:55',NULL),(4043,7908,1117,40720,1550,3,217,1,35069.41,NULL,'2024-05-02 18:54:32','2024-05-02 18:54:32',NULL),(4044,7908,1117,40720,1550,3,68,1,7364.58,NULL,'2024-05-02 18:54:32','2024-05-02 18:54:32',NULL),(4045,7908,1117,40720,1550,3,57,2,42433.99,NULL,'2024-05-02 18:54:33','2024-05-02 18:54:33',NULL),(4046,7908,1118,40720,1550,3,217,1,33547.66,NULL,'2024-05-02 18:54:47','2024-05-02 18:54:47',NULL),(4047,7908,1118,40720,1550,3,68,1,7045.01,NULL,'2024-05-02 18:54:47','2024-05-02 18:54:47',NULL),(4048,7908,1118,40720,1550,3,57,2,40592.67,NULL,'2024-05-02 18:54:47','2024-05-02 18:54:47',NULL),(4049,7908,1119,40720,1550,3,217,1,86400.00,NULL,'2024-05-02 18:55:34','2024-05-02 18:55:34',NULL),(4050,7908,1119,40720,1550,3,68,1,18144.00,NULL,'2024-05-02 18:55:34','2024-05-02 18:55:34',NULL),(4051,7908,1119,40720,1550,3,57,2,104544.00,NULL,'2024-05-02 18:55:34','2024-05-02 18:55:34',NULL),(4052,7908,1120,40720,1550,3,217,1,32065.18,NULL,'2024-05-02 18:56:44','2024-05-02 18:56:44',NULL),(4053,7908,1120,40720,1550,3,68,1,6733.69,NULL,'2024-05-02 18:56:44','2024-05-02 18:56:44',NULL),(4054,7908,1120,40720,1550,3,57,2,38798.87,NULL,'2024-05-02 18:56:44','2024-05-02 18:56:44',NULL),(4055,7908,1121,40720,1550,3,217,1,11690.39,NULL,'2024-05-02 18:59:17','2024-05-02 18:59:17',NULL),(4056,7908,1121,40720,1550,3,68,1,2454.98,NULL,'2024-05-02 18:59:17','2024-05-02 18:59:17',NULL),(4057,7908,1121,40720,1550,3,57,2,14145.37,NULL,'2024-05-02 18:59:17','2024-05-02 18:59:17',NULL),(4058,7908,1122,40720,1550,15,67,1,2395042.02,NULL,'2024-05-02 19:00:31','2024-05-02 19:00:31',NULL),(4059,7908,1122,40720,1550,15,68,2,2297517.39,NULL,'2024-05-02 19:00:31','2024-05-02 19:00:31',NULL),(4060,7908,1122,40720,1550,15,74,2,97524.63,NULL,'2024-05-02 19:00:31','2024-05-02 19:00:31',NULL),(4061,7908,1123,40720,1551,3,217,1,23240.02,NULL,'2024-05-22 18:28:42','2024-05-22 18:28:42',NULL),(4062,7908,1123,40720,1551,3,68,1,4880.40,NULL,'2024-05-22 18:28:42','2024-05-22 18:28:42',NULL),(4063,7908,1123,40720,1551,3,221,1,1884.53,NULL,'2024-05-22 18:28:42','2024-05-22 18:28:42',NULL),(4064,7908,1123,40720,1551,3,57,2,30004.95,NULL,'2024-05-22 18:28:42','2024-05-22 18:28:42',NULL);
INSERT INTO `balance_libro_details` VALUES (4065,7908,1124,40720,1551,3,217,1,7743.87,NULL,'2024-05-22 18:30:16','2024-05-22 18:30:16',NULL),(4066,7908,1124,40720,1551,3,68,1,1626.21,NULL,'2024-05-22 18:30:16','2024-05-22 18:30:16',NULL),(4067,7908,1124,40720,1551,3,221,1,627.95,NULL,'2024-05-22 18:30:16','2024-05-22 18:30:16',NULL),(4068,7908,1124,40720,1551,3,57,2,9998.03,NULL,'2024-05-22 18:30:16','2024-05-22 18:30:16',NULL),(4069,7908,1125,40720,1551,3,217,1,70488.50,NULL,'2024-05-22 18:31:08','2024-05-22 18:31:08',NULL),(4070,7908,1125,40720,1551,3,68,1,14802.59,NULL,'2024-05-22 18:31:08','2024-05-22 18:31:08',NULL),(4071,7908,1125,40720,1551,3,221,1,5715.89,NULL,'2024-05-22 18:31:08','2024-05-22 18:31:08',NULL),(4072,7908,1125,40720,1551,3,57,2,91006.97,NULL,'2024-05-22 18:31:08','2024-05-22 18:31:08',NULL),(4073,7908,1125,40720,1551,3,136,2,0.01,NULL,'2024-05-22 18:31:08','2024-05-22 18:31:08',NULL),(4074,7908,1126,40720,1551,3,217,1,37060.87,NULL,'2024-05-22 18:31:58','2024-05-22 18:31:58',NULL),(4075,7908,1126,40720,1551,3,68,1,7782.78,NULL,'2024-05-22 18:31:58','2024-05-22 18:31:58',NULL),(4076,7908,1126,40720,1551,3,221,1,5161.31,NULL,'2024-05-22 18:31:58','2024-05-22 18:31:58',NULL),(4077,7908,1126,40720,1551,3,57,2,50004.96,NULL,'2024-05-22 18:31:58','2024-05-22 18:31:58',NULL),(4078,7908,1127,40720,1551,3,217,1,38736.29,NULL,'2024-05-22 18:34:06','2024-05-22 18:34:06',NULL),(4079,7908,1127,40720,1551,3,68,1,8134.62,NULL,'2024-05-22 18:34:07','2024-05-22 18:34:07',NULL),(4080,7908,1127,40720,1551,3,221,1,3141.11,NULL,'2024-05-22 18:34:07','2024-05-22 18:34:07',NULL),(4081,7908,1127,40720,1551,3,57,2,50012.02,NULL,'2024-05-22 18:34:07','2024-05-22 18:34:07',NULL),(4082,7908,1128,40720,1551,3,217,1,14483.95,NULL,'2024-05-22 18:36:51','2024-05-22 18:36:51',NULL),(4083,7908,1128,40720,1551,3,68,1,3041.63,NULL,'2024-05-22 18:36:51','2024-05-22 18:36:51',NULL),(4084,7908,1128,40720,1551,3,221,1,2485.65,NULL,'2024-05-22 18:36:51','2024-05-22 18:36:51',NULL),(4085,7908,1128,40720,1551,3,57,2,20011.23,NULL,'2024-05-22 18:36:51','2024-05-22 18:36:51',NULL),(4086,7908,1129,40720,1551,3,217,1,22903.71,NULL,'2024-05-22 18:37:45','2024-05-22 18:37:45',NULL),(4087,7908,1129,40720,1551,3,68,1,4809.78,NULL,'2024-05-22 18:37:45','2024-05-22 18:37:45',NULL),(4088,7908,1129,40720,1551,3,221,1,2288.47,NULL,'2024-05-22 18:37:45','2024-05-22 18:37:45',NULL),(4089,7908,1129,40720,1551,3,57,2,30001.96,NULL,'2024-05-22 18:37:45','2024-05-22 18:37:45',NULL),(4090,7908,1130,40720,1551,3,217,1,23319.88,NULL,'2024-05-22 18:43:05','2024-05-22 18:43:05',NULL),(4091,7908,1130,40720,1551,3,68,1,4897.17,NULL,'2024-05-22 18:43:05','2024-05-22 18:43:05',NULL),(4092,7908,1130,40720,1551,3,221,1,1891.00,NULL,'2024-05-22 18:43:05','2024-05-22 18:43:05',NULL),(4093,7908,1130,40720,1551,3,57,2,30108.05,NULL,'2024-05-22 18:43:05','2024-05-22 18:43:05',NULL),(4094,7908,1131,40720,1551,3,217,1,23240.88,NULL,'2024-05-22 18:45:28','2024-05-22 18:45:28',NULL),(4095,7908,1131,40720,1551,3,68,1,4880.58,NULL,'2024-05-22 18:45:28','2024-05-22 18:45:28',NULL),(4096,7908,1131,40720,1551,3,221,1,1884.60,NULL,'2024-05-22 18:45:28','2024-05-22 18:45:28',NULL),(4097,7908,1131,40720,1551,3,57,2,30006.06,NULL,'2024-05-22 18:45:28','2024-05-22 18:45:28',NULL),(4098,7908,1132,40720,1551,3,217,1,22900.71,NULL,'2024-05-22 18:54:08','2024-05-22 18:54:08',NULL),(4099,7908,1132,40720,1551,3,68,1,4809.15,NULL,'2024-05-22 18:54:08','2024-05-22 18:54:08',NULL),(4100,7908,1132,40720,1551,3,221,1,2288.17,NULL,'2024-05-22 18:54:08','2024-05-22 18:54:08',NULL),(4101,7908,1132,40720,1551,3,57,2,29998.03,NULL,'2024-05-22 18:54:08','2024-05-22 18:54:08',NULL),(4102,7908,1133,40720,1551,3,217,1,23716.04,NULL,'2024-05-22 18:55:03','2024-05-22 18:55:03',NULL),(4103,7908,1133,40720,1551,3,68,1,4980.37,NULL,'2024-05-22 18:55:03','2024-05-22 18:55:03',NULL),(4104,7908,1133,40720,1551,3,221,1,2369.63,NULL,'2024-05-22 18:55:03','2024-05-22 18:55:03',NULL);
INSERT INTO `balance_libro_details` VALUES (4105,7908,1133,40720,1551,3,57,2,31066.04,NULL,'2024-05-22 18:55:03','2024-05-22 18:55:03',NULL),(4106,7908,1134,40720,1551,3,217,1,38170.38,NULL,'2024-05-22 18:55:53','2024-05-22 18:55:53',NULL),(4107,7908,1134,40720,1551,3,68,1,8015.78,NULL,'2024-05-22 18:55:53','2024-05-22 18:55:53',NULL),(4108,7908,1134,40720,1551,3,221,1,3813.86,NULL,'2024-05-22 18:55:53','2024-05-22 18:55:53',NULL),(4109,7908,1134,40720,1551,3,57,2,50000.02,NULL,'2024-05-22 18:55:53','2024-05-22 18:55:53',NULL),(4110,7908,1135,40720,1551,3,217,1,45495.28,NULL,'2024-05-22 18:57:20','2024-05-22 18:57:20',NULL),(4111,7908,1135,40720,1551,3,68,1,9554.01,NULL,'2024-05-22 18:57:20','2024-05-22 18:57:20',NULL),(4112,7908,1135,40720,1551,3,221,1,4982.75,NULL,'2024-05-22 18:57:20','2024-05-22 18:57:20',NULL),(4113,7908,1135,40720,1551,3,57,2,60032.04,NULL,'2024-05-22 18:57:20','2024-05-22 18:57:20',NULL),(4114,7908,1136,40720,1551,3,217,1,23234.63,NULL,'2024-05-22 18:58:11','2024-05-22 18:58:11',NULL),(4115,7908,1136,40720,1551,3,68,1,4879.27,NULL,'2024-05-22 18:58:11','2024-05-22 18:58:11',NULL),(4116,7908,1136,40720,1551,3,221,1,1884.09,NULL,'2024-05-22 18:58:11','2024-05-22 18:58:11',NULL),(4117,7908,1136,40720,1551,3,57,2,29997.99,NULL,'2024-05-22 18:58:11','2024-05-22 18:58:11',NULL),(4118,7908,1137,40720,1551,3,217,1,165289.26,NULL,'2024-05-22 19:08:08','2024-05-22 19:08:08',NULL),(4119,7908,1137,40720,1551,3,68,1,34710.74,NULL,'2024-05-22 19:08:08','2024-05-22 19:08:08',NULL),(4120,7908,1137,40720,1551,3,57,2,200000.00,NULL,'2024-05-22 19:08:08','2024-05-22 19:08:08',NULL),(4121,7908,1138,40720,1551,15,67,1,5687746.13,NULL,'2024-05-22 19:15:42','2024-05-22 19:15:42',NULL),(4122,7908,1138,40720,1551,15,68,2,7710962.27,NULL,'2024-05-22 19:15:42','2024-05-22 19:15:42',NULL),(4123,7908,1138,40720,1551,15,353,1,2023216.14,NULL,'2024-05-22 19:15:42','2024-05-22 19:15:42',NULL),(4124,7908,1139,40720,1552,3,217,1,3553.22,NULL,'2024-06-25 12:19:23','2024-06-25 12:21:40','2024-06-25 12:21:40'),(4125,7908,1139,40720,1552,3,68,1,746.18,NULL,'2024-06-25 12:19:23','2024-06-25 12:21:40','2024-06-25 12:21:40'),(4126,7908,1139,40720,1552,3,217,1,-0.01,NULL,'2024-06-25 12:19:23','2024-06-25 12:21:40','2024-06-25 12:21:40'),(4127,7908,1139,40720,1552,3,57,2,4299.39,NULL,'2024-06-25 12:19:23','2024-06-25 12:21:40','2024-06-25 12:21:40'),(4128,7908,1140,40720,1552,3,217,1,65453.72,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4129,7908,1140,40720,1552,3,68,1,13745.28,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4130,7908,1140,40720,1552,3,57,2,79199.00,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4131,7908,1141,40720,1552,3,217,1,5776.03,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4132,7908,1141,40720,1552,3,68,1,1212.97,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4133,7908,1141,40720,1552,3,57,2,6989.00,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4134,7908,1142,40720,1552,3,217,1,107294.21,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4135,7908,1142,40720,1552,3,68,1,22531.79,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4136,7908,1142,40720,1552,3,57,2,129826.00,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4137,7908,1143,40720,1552,3,217,1,89723.14,NULL,'2024-06-25 12:19:23','2024-06-25 12:24:45','2024-06-25 12:24:45'),(4138,7908,1143,40720,1552,3,68,1,18841.86,NULL,'2024-06-25 12:19:23','2024-06-25 12:24:45','2024-06-25 12:24:45'),(4139,7908,1143,40720,1552,3,217,1,672.92,NULL,'2024-06-25 12:19:23','2024-06-25 12:24:45','2024-06-25 12:24:45'),(4140,7908,1143,40720,1552,3,57,2,109237.92,NULL,'2024-06-25 12:19:23','2024-06-25 12:24:45','2024-06-25 12:24:45'),(4141,7908,1144,40720,1552,3,217,1,19289.26,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4142,7908,1144,40720,1552,3,68,1,4050.74,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4143,7908,1144,40720,1552,3,57,2,23340.00,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL);
INSERT INTO `balance_libro_details` VALUES (4144,7908,1145,40720,1552,3,217,1,13181.82,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4145,7908,1145,40720,1552,3,68,1,2768.18,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4146,7908,1145,40720,1552,3,57,2,15950.00,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4147,7908,1146,40720,1552,3,217,1,9173.55,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4148,7908,1146,40720,1552,3,68,1,1926.45,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4149,7908,1146,40720,1552,3,57,2,11100.00,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4150,7908,1147,40720,1552,3,217,1,53719.01,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4151,7908,1147,40720,1552,3,68,1,11280.99,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4152,7908,1147,40720,1552,3,57,2,65000.00,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4153,7908,1148,40720,1552,3,217,1,24157.02,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4154,7908,1148,40720,1552,3,68,1,5072.97,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4155,7908,1148,40720,1552,3,57,2,29229.99,NULL,'2024-06-25 12:19:23','2024-06-25 12:19:23',NULL),(4156,7908,1149,40720,1552,3,217,1,253332.48,NULL,'2024-06-25 12:19:23','2024-06-25 12:22:41','2024-06-25 12:22:41'),(4157,7908,1149,40720,1552,3,68,1,53199.82,NULL,'2024-06-25 12:19:23','2024-06-25 12:22:41','2024-06-25 12:22:41'),(4158,7908,1149,40720,1552,3,217,1,0.02,NULL,'2024-06-25 12:19:23','2024-06-25 12:22:41','2024-06-25 12:22:41'),(4159,7908,1149,40720,1552,3,57,2,306532.32,NULL,'2024-06-25 12:19:24','2024-06-25 12:22:41','2024-06-25 12:22:41'),(4160,7908,1150,40720,1552,3,217,1,12396.69,NULL,'2024-06-25 12:19:24','2024-06-25 12:19:24',NULL),(4161,7908,1150,40720,1552,3,68,1,2603.30,NULL,'2024-06-25 12:19:24','2024-06-25 12:19:24',NULL),(4162,7908,1150,40720,1552,3,57,2,14999.99,NULL,'2024-06-25 12:19:24','2024-06-25 12:19:24',NULL),(4163,7908,1151,40720,1552,3,217,1,3553.22,NULL,'2024-06-25 12:21:40','2024-06-25 12:21:40',NULL),(4164,7908,1151,40720,1552,3,68,1,746.18,NULL,'2024-06-25 12:21:40','2024-06-25 12:21:40',NULL),(4165,7908,1151,40720,1552,3,57,2,4299.40,NULL,'2024-06-25 12:21:40','2024-06-25 12:21:40',NULL),(4166,7908,1152,40720,1552,3,217,1,253332.48,NULL,'2024-06-25 12:22:41','2024-06-25 12:22:41',NULL),(4167,7908,1152,40720,1552,3,68,1,53199.82,NULL,'2024-06-25 12:22:41','2024-06-25 12:22:41',NULL),(4168,7908,1152,40720,1552,3,57,2,306532.30,NULL,'2024-06-25 12:22:41','2024-06-25 12:22:41',NULL),(4169,7908,1153,40720,1552,3,217,1,89723.14,NULL,'2024-06-25 12:24:45','2024-06-25 12:24:45',NULL),(4170,7908,1153,40720,1552,3,68,1,18841.86,NULL,'2024-06-25 12:24:45','2024-06-25 12:24:45',NULL),(4171,7908,1153,40720,1552,3,57,2,108565.00,NULL,'2024-06-25 12:24:45','2024-06-25 12:24:45',NULL),(4172,7908,1154,40720,1552,3,217,1,198347.11,NULL,'2024-06-25 13:16:15','2024-06-25 13:16:15',NULL),(4173,7908,1154,40720,1552,3,68,1,41652.89,NULL,'2024-06-25 13:16:15','2024-06-25 13:16:15',NULL),(4174,7908,1154,40720,1552,3,57,2,240000.00,NULL,'2024-06-25 13:16:15','2024-06-25 13:16:15',NULL),(4175,7908,1155,40720,1552,3,217,1,23296.96,NULL,'2024-06-25 13:19:29','2024-06-25 13:19:29',NULL),(4176,7908,1155,40720,1552,3,68,1,4892.36,NULL,'2024-06-25 13:19:29','2024-06-25 13:19:29',NULL),(4177,7908,1155,40720,1552,3,222,1,1811.69,NULL,'2024-06-25 13:19:29','2024-06-25 13:19:29',NULL),(4178,7908,1155,40720,1552,3,57,2,30001.01,NULL,'2024-06-25 13:19:29','2024-06-25 13:19:29',NULL),(4179,7908,1156,40720,1552,3,217,1,31093.42,NULL,'2024-06-25 13:20:47','2024-06-25 13:20:47',NULL),(4180,7908,1156,40720,1552,3,68,1,6529.62,NULL,'2024-06-25 13:20:47','2024-06-25 13:20:47',NULL),(4181,7908,1156,40720,1552,3,222,1,2417.99,NULL,'2024-06-25 13:20:47','2024-06-25 13:20:47',NULL),(4182,7908,1156,40720,1552,3,57,2,40041.03,NULL,'2024-06-25 13:20:47','2024-06-25 13:20:47',NULL),(4183,7908,1157,40720,1552,3,217,1,29784.51,NULL,'2024-06-25 13:21:58','2024-06-25 13:21:58',NULL);
INSERT INTO `balance_libro_details` VALUES (4184,7908,1157,40720,1552,3,68,1,6254.75,NULL,'2024-06-25 13:21:58','2024-06-25 13:21:58',NULL),(4185,7908,1157,40720,1552,3,222,1,3970.70,NULL,'2024-06-25 13:21:58','2024-06-25 13:21:58',NULL),(4186,7908,1157,40720,1552,3,57,2,40009.96,NULL,'2024-06-25 13:21:58','2024-06-25 13:21:58',NULL),(4187,7908,1158,40720,1552,3,217,1,15538.51,NULL,'2024-06-25 13:23:02','2024-06-25 13:23:02',NULL),(4188,7908,1158,40720,1552,3,68,1,3263.09,NULL,'2024-06-25 13:23:02','2024-06-25 13:23:02',NULL),(4189,7908,1158,40720,1552,3,222,1,1208.36,NULL,'2024-06-25 13:23:02','2024-06-25 13:23:02',NULL),(4190,7908,1158,40720,1552,3,57,2,20009.96,NULL,'2024-06-25 13:23:02','2024-06-25 13:23:02',NULL),(4191,7908,1159,40720,1552,3,217,1,15330.72,NULL,'2024-06-25 13:23:54','2024-06-25 13:23:54',NULL),(4192,7908,1159,40720,1552,3,68,1,3219.45,NULL,'2024-06-25 13:23:54','2024-06-25 13:23:54',NULL),(4193,7908,1159,40720,1552,3,222,1,1468.81,NULL,'2024-06-25 13:23:54','2024-06-25 13:23:54',NULL),(4194,7908,1159,40720,1552,3,57,2,20018.98,NULL,'2024-06-25 13:23:54','2024-06-25 13:23:54',NULL),(4195,7908,1160,40720,1552,3,217,1,23299.32,NULL,'2024-06-25 13:25:06','2024-06-25 13:25:06',NULL),(4196,7908,1160,40720,1552,3,68,1,4892.86,NULL,'2024-06-25 13:25:06','2024-06-25 13:25:06',NULL),(4197,7908,1160,40720,1552,3,222,1,1811.88,NULL,'2024-06-25 13:25:06','2024-06-25 13:25:06',NULL),(4198,7908,1160,40720,1552,3,57,2,30004.06,NULL,'2024-06-25 13:25:06','2024-06-25 13:25:06',NULL),(4199,7908,1161,40720,1552,3,217,1,23296.17,NULL,'2024-06-25 13:25:58','2024-06-25 13:25:58',NULL),(4200,7908,1161,40720,1552,3,68,1,4892.20,NULL,'2024-06-25 13:25:58','2024-06-25 13:25:58',NULL),(4201,7908,1161,40720,1552,3,222,1,1811.63,NULL,'2024-06-25 13:25:58','2024-06-25 13:25:58',NULL),(4202,7908,1161,40720,1552,3,57,2,30000.00,NULL,'2024-06-25 13:25:58','2024-06-25 13:25:58',NULL),(4203,7908,1162,40720,1552,3,217,1,38961.31,NULL,'2024-06-25 13:27:09','2024-06-25 13:27:09',NULL),(4204,7908,1162,40720,1552,3,68,1,8181.88,NULL,'2024-06-25 13:27:09','2024-06-25 13:27:09',NULL),(4205,7908,1162,40720,1552,3,222,1,3029.84,NULL,'2024-06-25 13:27:09','2024-06-25 13:27:09',NULL),(4206,7908,1162,40720,1552,3,57,2,50173.03,NULL,'2024-06-25 13:27:09','2024-06-25 13:27:09',NULL),(4207,7908,1163,40720,1552,3,217,1,21827.42,NULL,'2024-06-25 13:28:16','2024-06-25 13:28:16',NULL),(4208,7908,1163,40720,1552,3,68,1,4583.76,NULL,'2024-06-25 13:28:16','2024-06-25 13:28:16',NULL),(4209,7908,1163,40720,1552,3,222,1,3583.79,NULL,'2024-06-25 13:28:16','2024-06-25 13:28:16',NULL),(4210,7908,1163,40720,1552,3,57,2,29994.97,NULL,'2024-06-25 13:28:16','2024-06-25 13:28:16',NULL),(4211,7908,1164,40720,1552,3,217,1,23314.83,NULL,'2024-06-25 13:29:28','2024-06-25 13:29:28',NULL),(4212,7908,1164,40720,1552,3,68,1,4896.11,NULL,'2024-06-25 13:29:28','2024-06-25 13:29:28',NULL),(4213,7908,1164,40720,1552,3,222,1,1813.08,NULL,'2024-06-25 13:29:28','2024-06-25 13:29:28',NULL),(4214,7908,1164,40720,1552,3,57,2,30024.02,NULL,'2024-06-25 13:29:28','2024-06-25 13:29:28',NULL),(4215,7908,1165,40720,1552,3,217,1,15530.91,NULL,'2024-06-25 13:33:48','2024-06-25 13:33:48',NULL),(4216,7908,1165,40720,1552,3,68,1,3261.49,NULL,'2024-06-25 13:33:48','2024-06-25 13:33:48',NULL),(4217,7908,1165,40720,1552,3,222,1,1207.76,NULL,'2024-06-25 13:33:48','2024-06-25 13:33:48',NULL),(4218,7908,1165,40720,1552,3,57,2,20000.16,NULL,'2024-06-25 13:33:48','2024-06-25 13:33:48',NULL),(4219,7908,1166,40720,1552,3,217,1,32701.02,NULL,'2024-06-25 13:36:02','2024-06-25 13:36:02',NULL),(4220,7908,1166,40720,1552,3,68,1,6867.21,NULL,'2024-06-25 13:36:02','2024-06-25 13:36:02',NULL),(4221,7908,1166,40720,1552,3,222,1,431.83,NULL,'2024-06-25 13:36:02','2024-06-25 13:36:02',NULL),(4222,7908,1166,40720,1552,3,57,2,40000.06,NULL,'2024-06-25 13:36:02','2024-06-25 13:36:02',NULL),(4223,7908,1167,40720,1552,3,217,1,24570.57,NULL,'2024-06-25 13:37:12','2024-06-25 13:37:12',NULL);
INSERT INTO `balance_libro_details` VALUES (4224,7908,1167,40720,1552,3,68,1,5159.82,NULL,'2024-06-25 13:37:12','2024-06-25 13:37:12',NULL),(4225,7908,1167,40720,1552,3,222,1,270.78,NULL,'2024-06-25 13:37:12','2024-06-25 13:37:12',NULL),(4226,7908,1167,40720,1552,3,57,2,30001.17,NULL,'2024-06-25 13:37:12','2024-06-25 13:37:12',NULL),(4227,7908,1168,40720,1552,3,217,1,24570.58,NULL,'2024-06-25 13:38:13','2024-06-25 13:38:13',NULL),(4228,7908,1168,40720,1552,3,68,1,5159.82,NULL,'2024-06-25 13:38:13','2024-06-25 13:38:13',NULL),(4229,7908,1168,40720,1552,3,222,1,270.78,NULL,'2024-06-25 13:38:13','2024-06-25 13:38:13',NULL),(4230,7908,1168,40720,1552,3,57,2,30001.18,NULL,'2024-06-25 13:38:13','2024-06-25 13:38:13',NULL),(4231,7908,1169,40720,1552,3,217,1,10915.97,NULL,'2024-06-25 13:39:50','2024-06-25 13:39:50',NULL),(4232,7908,1169,40720,1552,3,68,1,2292.35,NULL,'2024-06-25 13:39:50','2024-06-25 13:39:50',NULL),(4233,7908,1169,40720,1552,3,222,1,1798.58,NULL,'2024-06-25 13:39:50','2024-06-25 13:39:50',NULL),(4234,7908,1169,40720,1552,3,57,2,15006.90,NULL,'2024-06-25 13:39:50','2024-06-25 13:39:50',NULL),(4235,7908,1170,40720,1552,15,68,2,253980.19,NULL,'2024-06-25 13:43:51','2024-06-25 13:43:51',NULL),(4236,7908,1170,40720,1552,15,353,2,2023216.14,NULL,'2024-06-25 13:43:51','2024-06-25 13:43:51',NULL),(4237,7908,1170,40720,1552,15,353,1,2277196.33,NULL,'2024-06-25 13:43:51','2024-06-25 13:43:51',NULL),(4238,7908,1171,40720,1553,3,217,1,80165.29,NULL,'2024-07-25 19:06:19','2024-07-25 19:06:19',NULL),(4239,7908,1171,40720,1553,3,68,1,16834.71,NULL,'2024-07-25 19:06:19','2024-07-25 19:06:19',NULL),(4240,7908,1171,40720,1553,3,57,2,97000.00,NULL,'2024-07-25 19:06:19','2024-07-25 19:06:19',NULL),(4241,7908,1172,40720,1553,3,217,1,103971.34,NULL,'2024-07-25 19:06:20','2024-07-25 19:09:42','2024-07-25 19:09:42'),(4242,7908,1172,40720,1553,3,68,1,21833.98,NULL,'2024-07-25 19:06:20','2024-07-25 19:09:42','2024-07-25 19:09:42'),(4243,7908,1172,40720,1553,3,217,1,779.79,NULL,'2024-07-25 19:06:20','2024-07-25 19:09:42','2024-07-25 19:09:42'),(4244,7908,1172,40720,1553,3,57,2,126585.11,NULL,'2024-07-25 19:06:20','2024-07-25 19:09:42','2024-07-25 19:09:42'),(4245,7908,1173,40720,1553,3,217,1,7438.02,NULL,'2024-07-25 19:06:20','2024-07-25 19:11:10','2024-07-25 19:11:10'),(4246,7908,1173,40720,1553,3,68,1,1561.98,NULL,'2024-07-25 19:06:20','2024-07-25 19:11:10','2024-07-25 19:11:10'),(4247,7908,1173,40720,1553,3,217,1,111.57,NULL,'2024-07-25 19:06:20','2024-07-25 19:11:10','2024-07-25 19:11:10'),(4248,7908,1173,40720,1553,3,57,2,9111.57,NULL,'2024-07-25 19:06:20','2024-07-25 19:11:10','2024-07-25 19:11:10'),(4249,7908,1174,40720,1553,3,217,1,11487.60,NULL,'2024-07-25 19:06:20','2024-07-25 19:06:20',NULL),(4250,7908,1174,40720,1553,3,68,1,2412.40,NULL,'2024-07-25 19:06:20','2024-07-25 19:06:20',NULL),(4251,7908,1174,40720,1553,3,57,2,13900.00,NULL,'2024-07-25 19:06:20','2024-07-25 19:06:20',NULL),(4252,7908,1175,40720,1553,3,217,1,18595.04,NULL,'2024-07-25 19:06:20','2024-07-25 19:06:20',NULL),(4253,7908,1175,40720,1553,3,68,1,3904.96,NULL,'2024-07-25 19:06:20','2024-07-25 19:06:20',NULL),(4254,7908,1175,40720,1553,3,57,2,22500.00,NULL,'2024-07-25 19:06:20','2024-07-25 19:06:20',NULL),(4255,7908,1176,40720,1553,3,217,1,103971.34,NULL,'2024-07-25 19:09:42','2024-07-25 19:09:42',NULL),(4256,7908,1176,40720,1553,3,68,1,21833.98,NULL,'2024-07-25 19:09:42','2024-07-25 19:09:42',NULL),(4257,7908,1176,40720,1553,3,57,2,125805.32,NULL,'2024-07-25 19:09:42','2024-07-25 19:09:42',NULL),(4258,7908,1177,40720,1553,3,217,1,7438.02,NULL,'2024-07-25 19:11:10','2024-07-25 19:11:10',NULL),(4259,7908,1177,40720,1553,3,68,1,1561.98,NULL,'2024-07-25 19:11:10','2024-07-25 19:11:10',NULL),(4260,7908,1177,40720,1553,3,57,2,9000.00,NULL,'2024-07-25 19:11:10','2024-07-25 19:11:10',NULL),(4261,7908,1178,40720,1553,2,96,2,8939888.05,NULL,'2024-07-25 19:20:57','2024-07-25 19:20:57',NULL),(4262,7908,1178,40720,1553,2,67,2,938688.25,NULL,'2024-07-25 19:20:57','2024-07-25 19:20:57',NULL);
INSERT INTO `balance_libro_details` VALUES (4263,7908,1178,40720,1553,2,13,1,9878576.30,NULL,'2024-07-25 19:20:57','2024-07-25 19:20:57',NULL),(4264,7908,1179,40720,1553,2,96,2,3867548.76,NULL,'2024-07-25 19:24:20','2024-07-25 19:24:20',NULL),(4265,7908,1179,40720,1553,2,67,2,406092.62,NULL,'2024-07-25 19:24:20','2024-07-25 19:24:20',NULL),(4266,7908,1179,40720,1553,2,13,1,4273641.38,NULL,'2024-07-25 19:24:20','2024-07-25 19:24:20',NULL),(4267,7908,1180,40720,1553,7,25,1,309403.90,NULL,'2024-07-25 19:30:02','2024-07-25 19:30:02',NULL),(4268,7908,1180,40720,1553,7,13,2,309403.90,NULL,'2024-07-25 19:30:02','2024-07-25 19:30:02',NULL),(4269,7908,1181,40720,1553,7,25,1,715191.04,NULL,'2024-07-25 19:30:02','2024-07-25 19:30:02',NULL),(4270,7908,1181,40720,1553,7,13,2,715191.04,NULL,'2024-07-25 19:30:02','2024-07-25 19:30:02',NULL),(4271,7908,1182,40720,1553,3,217,1,23169.61,NULL,'2024-07-25 19:46:29','2024-07-25 19:46:29',NULL),(4272,7908,1182,40720,1553,3,68,1,4865.62,NULL,'2024-07-25 19:46:29','2024-07-25 19:46:29',NULL),(4273,7908,1182,40720,1553,3,221,1,1964.79,NULL,'2024-07-25 19:46:29','2024-07-25 19:46:29',NULL),(4274,7908,1182,40720,1553,3,57,2,30000.02,NULL,'2024-07-25 19:46:29','2024-07-25 19:46:29',NULL),(4275,7908,1183,40720,1553,3,217,1,14508.92,NULL,'2024-07-25 19:47:36','2024-07-25 19:47:36',NULL),(4276,7908,1183,40720,1553,3,68,1,3046.87,NULL,'2024-07-25 19:47:36','2024-07-25 19:47:36',NULL),(4277,7908,1183,40720,1553,3,221,1,2490.19,NULL,'2024-07-25 19:47:36','2024-07-25 19:47:36',NULL),(4278,7908,1183,40720,1553,3,57,2,20045.98,NULL,'2024-07-25 19:47:36','2024-07-25 19:47:36',NULL),(4279,7908,1184,40720,1553,3,217,1,30439.89,NULL,'2024-07-25 19:48:30','2024-07-25 19:48:30',NULL),(4280,7908,1184,40720,1553,3,68,1,6392.38,NULL,'2024-07-25 19:48:30','2024-07-25 19:48:30',NULL),(4281,7908,1184,40720,1553,3,221,1,3183.75,NULL,'2024-07-25 19:48:30','2024-07-25 19:48:30',NULL),(4282,7908,1184,40720,1553,3,57,2,40016.02,NULL,'2024-07-25 19:48:30','2024-07-25 19:48:30',NULL),(4283,7908,1185,40720,1553,3,217,1,154460.09,NULL,'2024-07-25 19:49:46','2024-07-25 19:49:46',NULL),(4284,7908,1185,40720,1553,3,68,1,32436.62,NULL,'2024-07-25 19:49:46','2024-07-25 19:49:46',NULL),(4285,7908,1185,40720,1553,3,221,1,13098.24,NULL,'2024-07-25 19:49:46','2024-07-25 19:49:46',NULL),(4286,7908,1185,40720,1553,3,57,2,199994.95,NULL,'2024-07-25 19:49:46','2024-07-25 19:49:46',NULL),(4287,7908,1186,40720,1553,3,217,1,30903.62,NULL,'2024-07-25 19:50:57','2024-07-25 19:50:57',NULL),(4288,7908,1186,40720,1553,3,68,1,6489.76,NULL,'2024-07-25 19:50:57','2024-07-25 19:50:57',NULL),(4289,7908,1186,40720,1553,3,221,1,2620.63,NULL,'2024-07-25 19:50:57','2024-07-25 19:50:57',NULL),(4290,7908,1186,40720,1553,3,57,2,40014.01,NULL,'2024-07-25 19:50:57','2024-07-25 19:50:57',NULL),(4291,7908,1187,40720,1553,3,217,1,23167.31,NULL,'2024-07-25 19:51:39','2024-07-25 19:51:39',NULL),(4292,7908,1187,40720,1553,3,68,1,4865.14,NULL,'2024-07-25 19:51:39','2024-07-25 19:51:39',NULL),(4293,7908,1187,40720,1553,3,221,1,1964.59,NULL,'2024-07-25 19:51:39','2024-07-25 19:51:39',NULL),(4294,7908,1187,40720,1553,3,57,2,29997.04,NULL,'2024-07-25 19:51:39','2024-07-25 19:51:39',NULL),(4295,7908,1188,40720,1553,3,217,1,115866.51,NULL,'2024-07-25 19:54:10','2024-07-25 19:54:10',NULL),(4296,7908,1188,40720,1553,3,68,1,24331.97,NULL,'2024-07-25 19:54:10','2024-07-25 19:54:10',NULL),(4297,7908,1188,40720,1553,3,221,1,9825.50,NULL,'2024-07-25 19:54:10','2024-07-25 19:54:10',NULL),(4298,7908,1188,40720,1553,3,57,2,150023.98,NULL,'2024-07-25 19:54:10','2024-07-25 19:54:10',NULL),(4299,7908,1189,40720,1553,3,217,1,38650.77,NULL,'2024-07-25 19:55:32','2024-07-25 19:55:32',NULL),(4300,7908,1189,40720,1553,3,68,1,8116.66,NULL,'2024-07-25 19:55:32','2024-07-25 19:55:32',NULL),(4301,7908,1189,40720,1553,3,221,1,3277.59,NULL,'2024-07-25 19:55:32','2024-07-25 19:55:32',NULL),(4302,7908,1189,40720,1553,3,57,2,50045.02,NULL,'2024-07-25 19:55:32','2024-07-25 19:55:32',NULL);
INSERT INTO `balance_libro_details` VALUES (4303,7908,1190,40720,1553,3,217,1,23175.02,NULL,'2024-07-25 19:56:39','2024-07-25 19:56:39',NULL),(4304,7908,1190,40720,1553,3,68,1,4866.75,NULL,'2024-07-25 19:56:39','2024-07-25 19:56:39',NULL),(4305,7908,1190,40720,1553,3,221,1,1965.25,NULL,'2024-07-25 19:56:39','2024-07-25 19:56:39',NULL),(4306,7908,1190,40720,1553,3,57,2,30007.02,NULL,'2024-07-25 19:56:39','2024-07-25 19:56:39',NULL),(4307,7908,1191,40720,1553,3,217,1,11418.78,NULL,'2024-07-25 19:57:59','2024-07-25 19:57:59',NULL),(4308,7908,1191,40720,1553,3,68,1,2397.94,NULL,'2024-07-25 19:57:59','2024-07-25 19:57:59',NULL),(4309,7908,1191,40720,1553,3,221,1,1194.30,NULL,'2024-07-25 19:57:59','2024-07-25 19:57:59',NULL),(4310,7908,1191,40720,1553,3,57,2,15011.02,NULL,'2024-07-25 19:57:59','2024-07-25 19:57:59',NULL),(4311,7908,1192,40720,1553,3,217,1,122875.82,NULL,'2024-07-25 19:59:30','2024-07-25 19:59:30',NULL),(4312,7908,1192,40720,1553,3,68,1,25803.92,NULL,'2024-07-25 19:59:30','2024-07-25 19:59:30',NULL),(4313,7908,1192,40720,1553,3,221,1,1320.85,NULL,'2024-07-25 19:59:30','2024-07-25 19:59:30',NULL),(4314,7908,1192,40720,1553,3,57,2,150000.59,NULL,'2024-07-25 19:59:30','2024-07-25 19:59:30',NULL),(4315,7908,1193,40720,1553,3,217,1,12279.73,NULL,'2024-07-25 20:02:11','2024-07-25 20:02:11',NULL),(4316,7908,1193,40720,1553,3,68,1,2578.74,NULL,'2024-07-25 20:02:11','2024-07-25 20:02:11',NULL),(4317,7908,1193,40720,1553,3,221,1,158.19,NULL,'2024-07-25 20:02:11','2024-07-25 20:02:11',NULL),(4318,7908,1193,40720,1553,3,57,2,15016.66,NULL,'2024-07-25 20:02:11','2024-07-25 20:02:11',NULL),(4319,7908,1194,40720,1553,3,217,1,38633.81,NULL,'2024-07-26 10:28:16','2024-07-26 10:28:16',NULL),(4320,7908,1194,40720,1553,3,68,1,8113.10,NULL,'2024-07-26 10:28:16','2024-07-26 10:28:16',NULL),(4321,7908,1194,40720,1553,3,221,1,3276.15,NULL,'2024-07-26 10:28:16','2024-07-26 10:28:16',NULL),(4322,7908,1194,40720,1553,3,57,2,50023.06,NULL,'2024-07-26 10:28:16','2024-07-26 10:28:16',NULL),(4323,7908,1195,40720,1553,3,217,1,23175.02,NULL,'2024-07-26 10:30:36','2024-07-26 10:30:36',NULL),(4324,7908,1195,40720,1553,3,68,1,4866.75,NULL,'2024-07-26 10:30:36','2024-07-26 10:30:36',NULL),(4325,7908,1195,40720,1553,3,221,1,1965.25,NULL,'2024-07-26 10:30:36','2024-07-26 10:30:36',NULL),(4326,7908,1195,40720,1553,3,57,2,30007.02,NULL,'2024-07-26 10:30:36','2024-07-26 10:30:36',NULL),(4327,7908,1196,40720,1553,3,217,1,15448.74,NULL,'2024-07-26 10:31:37','2024-07-26 10:31:37',NULL),(4328,7908,1196,40720,1553,3,68,1,3244.24,NULL,'2024-07-26 10:31:37','2024-07-26 10:31:37',NULL),(4329,7908,1196,40720,1553,3,221,1,1310.06,NULL,'2024-07-26 10:31:37','2024-07-26 10:31:37',NULL),(4330,7908,1196,40720,1553,3,57,2,20003.04,NULL,'2024-07-26 10:31:37','2024-07-26 10:31:37',NULL),(4331,7908,1197,40720,1553,3,217,1,11427.88,NULL,'2024-07-26 10:32:16','2024-07-26 10:32:16',NULL),(4332,7908,1197,40720,1553,3,68,1,2399.85,NULL,'2024-07-26 10:32:16','2024-07-26 10:32:16',NULL),(4333,7908,1197,40720,1553,3,221,1,1195.26,NULL,'2024-07-26 10:32:16','2024-07-26 10:32:16',NULL),(4334,7908,1197,40720,1553,3,57,2,15022.99,NULL,'2024-07-26 10:32:16','2024-07-26 10:32:16',NULL),(4335,7908,1198,40720,1553,3,217,1,76067.76,NULL,'2024-07-26 10:33:12','2024-07-26 10:33:12',NULL),(4336,7908,1198,40720,1553,3,68,1,15974.23,NULL,'2024-07-26 10:33:12','2024-07-26 10:33:12',NULL),(4337,7908,1198,40720,1553,3,221,1,7956.02,NULL,'2024-07-26 10:33:12','2024-07-26 10:33:12',NULL),(4338,7908,1198,40720,1553,3,57,2,99998.01,NULL,'2024-07-26 10:33:12','2024-07-26 10:33:12',NULL),(4339,7908,1199,40720,1553,3,217,1,11414.18,NULL,'2024-07-26 10:34:07','2024-07-26 10:34:07',NULL),(4340,7908,1199,40720,1553,3,68,1,2396.98,NULL,'2024-07-26 10:34:07','2024-07-26 10:34:07',NULL),(4341,7908,1199,40720,1553,3,221,1,1193.82,NULL,'2024-07-26 10:34:07','2024-07-26 10:34:07',NULL),(4342,7908,1199,40720,1553,3,57,2,15004.98,NULL,'2024-07-26 10:34:07','2024-07-26 10:34:07',NULL);
INSERT INTO `balance_libro_details` VALUES (4343,7908,1200,40720,1553,3,217,1,15218.41,NULL,'2024-07-26 10:34:52','2024-07-26 10:34:52',NULL),(4344,7908,1200,40720,1553,3,68,1,3195.87,NULL,'2024-07-26 10:34:52','2024-07-26 10:34:52',NULL),(4345,7908,1200,40720,1553,3,221,1,1591.71,NULL,'2024-07-26 10:34:52','2024-07-26 10:34:52',NULL),(4346,7908,1200,40720,1553,3,57,2,20005.99,NULL,'2024-07-26 10:34:52','2024-07-26 10:34:52',NULL),(4347,7908,1201,40720,1553,3,217,1,15219.16,NULL,'2024-07-26 10:35:35','2024-07-26 10:35:35',NULL),(4348,7908,1201,40720,1553,3,68,1,3196.02,NULL,'2024-07-26 10:35:35','2024-07-26 10:35:35',NULL),(4349,7908,1201,40720,1553,3,221,1,1591.79,NULL,'2024-07-26 10:35:35','2024-07-26 10:35:35',NULL),(4350,7908,1201,40720,1553,3,57,2,20006.97,NULL,'2024-07-26 10:35:35','2024-07-26 10:35:35',NULL),(4351,7908,1202,40720,1553,3,217,1,14951.98,NULL,'2024-07-26 10:36:55','2024-07-26 10:36:55',NULL),(4352,7908,1202,40720,1553,3,68,1,3139.92,NULL,'2024-07-26 10:36:55','2024-07-26 10:36:55',NULL),(4353,7908,1202,40720,1553,3,221,1,1908.14,NULL,'2024-07-26 10:36:55','2024-07-26 10:36:55',NULL),(4354,7908,1202,40720,1553,3,57,2,20000.04,NULL,'2024-07-26 10:36:55','2024-07-26 10:36:55',NULL),(4355,7908,1203,40720,1553,3,217,1,24586.63,NULL,'2024-07-26 10:38:39','2024-07-26 10:38:39',NULL),(4356,7908,1203,40720,1553,3,68,1,5163.19,NULL,'2024-07-26 10:38:39','2024-07-26 10:38:39',NULL),(4357,7908,1203,40720,1553,3,221,1,264.29,NULL,'2024-07-26 10:38:39','2024-07-26 10:38:39',NULL),(4358,7908,1203,40720,1553,3,57,2,30014.11,NULL,'2024-07-26 10:38:39','2024-07-26 10:38:39',NULL),(4359,7908,1204,40720,1553,3,217,1,8180.92,NULL,'2024-07-26 10:39:58','2024-07-26 10:39:58',NULL),(4360,7908,1204,40720,1553,3,68,1,1717.99,NULL,'2024-07-26 10:39:58','2024-07-26 10:39:58',NULL),(4361,7908,1204,40720,1553,3,221,1,105.39,NULL,'2024-07-26 10:39:58','2024-07-26 10:39:58',NULL),(4362,7908,1204,40720,1553,3,57,2,10004.30,NULL,'2024-07-26 10:39:58','2024-07-26 10:39:58',NULL),(4363,7908,1205,40720,1553,3,217,1,29895.03,NULL,'2024-07-26 10:41:23','2024-07-26 10:41:23',NULL),(4364,7908,1205,40720,1553,3,68,1,6277.96,NULL,'2024-07-26 10:41:23','2024-07-26 10:41:23',NULL),(4365,7908,1205,40720,1553,3,221,1,3829.07,NULL,'2024-07-26 10:41:23','2024-07-26 10:41:23',NULL),(4366,7908,1205,40720,1553,3,57,2,40002.06,NULL,'2024-07-26 10:41:23','2024-07-26 10:41:23',NULL),(4367,7908,1206,40720,1553,3,217,1,122875.82,NULL,'2024-07-26 10:44:55','2024-07-26 10:44:55',NULL),(4368,7908,