-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-30775123-3
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-09-30 09:53:56','Actividad Generica 1','000001',NULL),(2,NULL,'2022-09-30 09:53:56','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,'2023-01-02 19:14:04','Acabado de productos textiles','131300','131300'),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,'2023-01-02 19:14:28','Fabricación de somieres y colchones','310030','310030'),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,'2023-01-02 19:14:50','Fabricación de artículos de deporte','323001','323001'),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,'2023-02-11 15:41:00','Venta al por menor no realizada en establecimientos  n.c.p.','479900','479900'),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,'2022-12-07 16:18:20','2022-12-07 16:18:20',NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,'2022-12-07 16:18:59','2022-12-07 16:18:59',NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,'2022-12-07 16:19:24','2022-12-07 16:19:24',NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,'2022-12-07 16:19:58','2022-12-07 16:19:58',NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,'2022-12-07 16:20:28','2022-12-07 16:20:28',NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,'2022-12-07 16:20:53','2022-12-07 16:20:53',NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,'2022-12-07 16:21:09','2022-12-07 16:21:09',NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL),('2023-11','2023-11',2023,11,'2023-11-01','2023-11-30',2816.0628,'2024-11-29 17:12:03','2024-11-29 17:12:03',NULL),('2023-12','2023-12',2023,12,'2023-12-01','2023-12-31',3533.1922,'2024-11-29 17:13:49','2024-11-29 17:13:49',NULL),('2024-1','2024-01',2024,1,'2024-01-01','2024-01-31',4261.5324,'2025-10-20 15:47:41','2025-10-20 15:47:41',NULL),('2024-2','2024-02',2024,2,'2024-02-01','2024-02-28',4825.7881,'2025-10-20 18:47:55','2025-10-20 18:47:55',NULL),('2024-3','2024-03',2024,3,'2024-03-01','2024-03-31',5357.0929,'2025-10-20 15:58:16','2025-10-20 15:58:16',NULL),('2024-4','2024-04',2024,4,'2024-04-01','2024-04-30',5830.2271,'2025-10-20 18:58:31','2025-10-20 18:58:31',NULL),('2024-5','2024-05',2024,5,'2024-05-01','2024-05-31',6073.7165,'2025-10-20 15:59:18','2025-10-20 15:59:18',NULL),('2024-6','2024-06',2024,6,'2024-06-01','2024-06-30',6351.7145,'2025-10-20 15:59:33','2025-10-20 15:59:33',NULL),('2024-7','2024-07',2024,7,'2024-07-01','2024-07-31',6607.7479,'2025-10-20 15:59:51','2025-10-20 15:59:51',NULL),('2024-8','2024-08',2024,8,'2024-08-01','2024-08-31',6883.4412,'2025-10-20 16:00:07','2025-10-20 16:00:07',NULL),('2024-9','2024-09',2024,9,'2024-09-01','2024-09-30',7122.2421,'2025-10-20 16:00:38','2025-10-20 16:00:38',NULL),('2024-10','2024-10',2024,10,'2024-10-01','2024-10-31',7313.9542,'2025-10-20 16:01:29','2025-10-20 16:01:29',NULL),('2024-11','2024-11',2024,11,'2024-11-01','2024-11-30',7491.4314,'2025-10-20 16:02:08','2025-10-20 16:02:08',NULL),('2024-12','2024-12',2024,12,'2024-12-01','2024-12-31',7694.0075,'2025-10-20 16:02:33','2025-10-20 16:02:33',NULL),('2025-1','2025-01',2025,1,'2025-01-01','2025-01-31',7864.1257,'2025-10-20 16:02:50','2025-10-20 16:02:50',NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Dialga2022',NULL,1,40747,'2022-10-20'),(2,NULL,'Dialga2022',NULL,1,40747,'2022-10-20'),(3,NULL,'Taekwondo2022',NULL,1,40750,'2022-12-28'),(4,NULL,'Taekwondo2022',NULL,1,40750,'2022-12-28'),(5,NULL,'Taekwondo2022',NULL,1,40750,'2023-01-02'),(6,'AFIP','Fatiga2022',NULL,1,40773,'2023-02-11'),(7,'AFIP','Fatiga2022',NULL,1,40773,'2023-02-11'),(8,'AFIP','Fatiga2022',NULL,1,40773,'2023-02-11'),(9,'AFIP','Fatiga2022',NULL,1,40773,'2023-02-11'),(10,NULL,'Taekwondo2022',NULL,1,40750,'2023-02-11'),(11,NULL,'Dialga2022',NULL,1,40747,'2023-02-11'),(12,NULL,'Gusosa2022',NULL,1,40729,'2023-02-11'),(13,NULL,'Lapuertaabierta23',NULL,1,41172,'2023-12-12'),(14,NULL,'Estudio2023',NULL,1,40920,'2023-12-26'),(15,NULL,'Periquito18',NULL,1,49722,'2024-01-19'),(16,NULL,'Estudio1149',NULL,3,49722,'2024-01-19'),(17,NULL,'Gusosa2022',NULL,1,40729,'2025-02-10'),(18,NULL,'Dialga2022',NULL,1,40747,'2025-02-10'),(19,NULL,'Lavallol2751',NULL,1,40749,'2025-02-10'),(20,'AFIP','Fatiga2022',NULL,1,40773,'2025-02-10'),(21,NULL,'Lapuertaabierta23',NULL,1,41172,'2025-02-10'),(22,NULL,'Meduson75+',NULL,1,60799,'2025-03-01'),(23,NULL,'Meduson75+',NULL,1,60799,'2025-04-03'),(24,NULL,'Lavallol2751',NULL,1,40749,'2025-04-15'),(25,NULL,'Elsalvador2022',NULL,1,40759,'2025-05-30'),(26,'afip','Jorgeja2022',NULL,1,40820,'2025-05-30'),(27,'AFIP','Viernes2022',NULL,1,40819,'2025-05-30'),(28,NULL,'Lapuertaabierta23',NULL,1,41172,'2025-05-30'),(29,'AFIP','Fatiga2022',NULL,1,40773,'2025-05-30'),(30,NULL,'Taekwondo2022',NULL,1,40750,'2025-05-30'),(31,NULL,'Lavallol2753',NULL,1,40748,'2025-05-30'),(32,NULL,'Lavallol2751',NULL,1,40749,'2025-05-30'),(33,NULL,'Gusosa2022',NULL,1,40729,'2025-05-30'),(34,NULL,'Lavallol2751',NULL,1,40749,'2025-05-30'),(35,NULL,'Lapuertaabierta23',NULL,1,41172,'2025-05-30'),(36,NULL,'Lapuertaabierta23',NULL,1,41172,'2025-05-30'),(37,NULL,'Lapuertaabierta23',NULL,1,41172,'2025-05-30'),(38,NULL,'Lapuertaabierta23',NULL,1,41172,'2025-08-15');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'barrrionuevo.migue@gmail.com','1151771510',NULL,1,40719,'2023-07-07'),(2,'catalinamedialunasycafe@gmail.com','5491161870370','',1,49722,'2024-01-19'),(3,'barrionuevo-miguel@hotmail.com',NULL,NULL,1,40921,'2024-04-28'),(4,'barrionuevo-miguel@hotmail.com',NULL,NULL,1,40729,'2025-02-10'),(5,'barrionuevo-miguel@hotmail.com',NULL,NULL,1,40749,'2025-02-10'),(6,'barrionuevo-miguel@hotmail.com',NULL,NULL,1,41172,'2025-02-10'),(7,'barrionuevo-miguel@hotmail.com',NULL,'',1,40749,'2025-04-15'),(8,'barrionuevo-miguel@hotmail.com',NULL,NULL,1,40759,'2025-05-30'),(9,'barrionuevo-miguel@hotmail.com',NULL,'',1,41172,'2025-05-30'),(10,'barrionuevo-miguel@hotmail.com',NULL,NULL,1,40750,'2025-05-30'),(11,'barrionuevo-miguel@hotmail.com',NULL,'',1,40749,'2025-05-30'),(12,'barrionuevo-miguel@hotmail.com',NULL,'',1,40729,'2025-05-30'),(13,'barrionuevo-miguel@hotmail.com',NULL,'',1,40749,'2025-05-30'),(14,'barrionuevo-miguel@hotmail.com',NULL,'',1,41172,'2025-05-30'),(15,'barrionuevo-miguel@hotmail.com',NULL,'',1,41172,'2025-05-30'),(16,'barrionuevo-miguel@hotmail.com',NULL,'',1,41172,'2025-05-30'),(17,'barrionuevo-miguel@hotmail.com',NULL,'',1,41172,'2025-08-15');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(34,10,5,484,NULL,0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(35,10,5,488,NULL,0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(36,10,5,491,NULL,0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(37,10,5,493,NULL,0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(38,10,5,396,NULL,0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(39,10,5,157,NULL,0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(40,10,5,409,NULL,0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(41,10,5,483,NULL,0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(42,11,5,482,NULL,0.00,'2022-12-06 11:03:02','2022-12-06 11:03:02',NULL),(43,11,5,490,NULL,0.00,'2022-12-06 11:03:02','2022-12-06 11:03:02',NULL),(44,11,5,487,NULL,0.00,'2022-12-06 11:03:02','2022-12-06 11:03:02',NULL),(45,11,5,396,NULL,0.00,'2022-12-06 11:03:02','2022-12-06 11:03:02',NULL),(46,11,5,157,NULL,0.00,'2022-12-06 11:03:02','2022-12-06 11:03:02',NULL),(47,11,5,409,NULL,0.00,'2022-12-06 11:03:02','2022-12-06 11:03:02',NULL),(48,12,3,1039,NULL,0.00,'2023-11-05 12:24:25','2023-11-05 12:24:25',NULL),(49,12,3,1040,NULL,0.00,'2023-11-05 12:24:25','2023-11-05 12:24:25',NULL),(50,12,3,498,NULL,0.00,'2023-11-05 12:24:25','2023-11-05 12:24:25',NULL),(51,12,3,1041,NULL,0.00,'2023-11-05 12:24:25','2023-11-05 12:24:25',NULL),(52,12,3,496,NULL,0.00,'2023-11-05 12:24:25','2023-11-05 12:24:25',NULL),(53,12,3,1033,NULL,0.00,'2023-11-05 12:24:25','2023-11-05 12:24:25',NULL),(54,13,16,1045,NULL,0.00,'2024-04-27 22:17:23','2024-04-27 22:17:23',NULL),(55,13,16,1046,NULL,0.00,'2024-04-27 22:17:23','2024-04-27 22:17:23',NULL),(56,13,16,326,NULL,0.00,'2024-04-27 22:17:23','2024-04-27 22:17:23',NULL),(57,13,16,327,NULL,0.00,'2024-04-27 22:17:23','2024-04-27 22:17:23',NULL),(58,13,16,251,NULL,0.00,'2024-04-27 22:17:23','2024-04-27 22:17:23',NULL),(59,13,16,252,NULL,0.00,'2024-04-27 22:17:23','2024-04-27 22:17:23',NULL),(60,14,15,67,1,1924860.00,'2024-04-27 23:08:28','2024-04-27 23:08:28',NULL),(61,14,15,68,2,2429460.65,'2024-04-27 23:08:28','2024-04-27 23:08:28',NULL),(62,14,15,353,NULL,0.00,'2024-04-27 23:08:28','2024-04-27 23:08:28',NULL),(63,14,15,354,NULL,0.00,'2024-04-27 23:08:28','2024-04-27 23:08:28',NULL),(64,14,15,25,NULL,0.00,'2024-04-27 23:08:28','2024-04-27 23:08:28',NULL),(65,14,15,72,NULL,0.00,'2024-04-27 23:08:28','2024-04-27 23:08:28',NULL),(66,14,15,74,NULL,0.00,'2024-04-27 23:08:28','2024-04-27 23:08:28',NULL),(71,16,2,13,NULL,0.00,'2025-02-23 19:29:33','2025-02-23 19:29:33',NULL),(72,16,2,96,NULL,0.00,'2025-02-23 19:29:33','2025-02-23 19:29:33',NULL),(73,16,2,218,NULL,0.00,'2025-02-23 19:29:33','2025-02-23 19:29:33',NULL),(74,16,2,67,NULL,0.00,'2025-02-23 19:29:33','2025-02-23 19:29:33',NULL),(75,17,3,57,NULL,0.00,'2025-02-23 20:16:03','2025-02-23 20:16:03',NULL),(76,17,3,217,NULL,0.00,'2025-02-23 20:16:03','2025-02-23 20:16:03',NULL),(77,17,3,68,NULL,0.00,'2025-02-23 20:16:03','2025-02-23 20:16:03',NULL),(78,17,3,1444,NULL,0.00,'2025-02-23 20:16:03','2025-02-23 20:16:03',NULL),(79,17,3,68,NULL,0.00,'2025-02-23 20:16:03','2025-02-23 20:16:03',NULL),(80,17,3,1443,NULL,0.00,'2025-02-23 20:16:03','2025-02-23 20:16:03',NULL),(81,17,3,1445,NULL,0.00,'2025-02-23 20:16:03','2025-02-23 20:16:03',NULL),(82,18,16,1045,NULL,0.00,'2025-02-24 16:40:55','2025-02-24 16:40:55',NULL),(83,18,16,301,NULL,0.00,'2025-02-24 16:40:55','2025-02-24 16:40:55',NULL),(84,18,16,1446,NULL,0.00,'2025-02-24 16:40:55','2025-02-24 16:40:55',NULL),(85,18,16,251,NULL,0.00,'2025-02-24 16:40:55','2025-02-24 16:40:55',NULL),(86,18,16,1447,NULL,0.00,'2025-02-24 16:40:55','2025-02-24 16:40:55',NULL),(87,18,16,301,NULL,0.00,'2025-02-24 16:40:55','2025-02-24 16:40:55',NULL);
INSERT INTO `balance_asiento_modelo_detail` VALUES (88,18,16,326,NULL,0.00,'2025-02-24 16:40:55','2025-02-24 16:40:55',NULL),(89,19,5,14,NULL,0.00,'2025-09-05 16:09:33','2025-09-05 16:09:33',NULL),(90,19,5,57,NULL,0.00,'2025-09-05 16:09:33','2025-09-05 16:09:33',NULL),(91,19,5,475,NULL,0.00,'2025-09-05 16:09:33','2025-09-05 16:09:33',NULL),(92,20,5,507,NULL,0.00,'2025-09-11 19:06:11','2025-09-11 19:06:11',NULL),(93,20,5,506,NULL,0.00,'2025-09-11 19:06:11','2025-09-11 19:06:11',NULL),(94,20,5,13,NULL,0.00,'2025-09-11 19:06:11','2025-09-11 19:06:11',NULL),(95,21,1,62,NULL,0.00,'2025-09-11 19:39:44','2025-09-11 19:39:44',NULL),(96,21,1,63,NULL,0.00,'2025-09-11 19:39:44','2025-09-11 19:39:44',NULL),(97,21,1,64,NULL,0.00,'2025-09-11 19:39:44','2025-09-11 19:39:44',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7902,5,2,'BANCO 3740',0.00,'2022-09-30 11:52:35','2022-09-30 12:02:58','2022-09-30 12:02:58'),(4,7902,5,2,'BANCO 3740',0.00,'2022-09-30 11:52:59','2022-09-30 11:53:18','2022-09-30 11:53:18'),(5,7902,5,2,'BANCO 3740',0.00,'2022-09-30 11:54:05','2022-09-30 11:57:35','2022-09-30 11:57:35'),(6,7902,5,2,'BANCO 3740',0.00,'2022-09-30 11:57:17','2022-09-30 11:57:30','2022-09-30 11:57:30'),(7,7902,5,2,'BANCO 3740',0.00,'2022-09-30 11:57:51','2022-09-30 12:03:07','2022-09-30 12:03:07'),(8,7902,5,2,'BANCO 3740',0.00,'2022-09-30 12:04:24','2022-12-06 11:00:02','2022-12-06 11:00:02'),(9,7902,5,2,'BANCO 3757',0.00,'2022-09-30 12:06:11','2022-12-06 10:35:20','2022-12-06 10:35:20'),(10,7902,5,2,'Banco 37572',0.00,'2022-12-06 10:40:16','2022-12-06 10:40:16',NULL),(11,7902,5,2,'Banco cta 3740',0.00,'2022-12-06 11:03:02','2022-12-06 11:03:02',NULL),(12,7902,3,2,'EGRESOS CTRO JUBILADOS',0.00,'2023-11-05 12:24:25','2023-11-05 12:24:25',NULL),(13,7902,16,2,'IIBB-CM',0.00,'2024-04-27 22:17:23','2024-04-27 22:17:23',NULL),(14,7902,15,2,'IVA MENSUAL',0.00,'2024-04-27 23:08:28','2024-04-27 23:08:28',NULL),(15,7902,2,2,'INGRESOS 20XX-XX',0.00,'2025-02-23 19:03:43','2025-02-23 19:26:59','2025-02-23 19:26:59'),(16,7902,2,2,'INGRESOS 202X-XX',0.00,'2025-02-23 19:29:33','2025-02-23 19:29:33',NULL),(17,7902,3,2,'Gastos 2024-XX',0.00,'2025-02-23 20:16:03','2025-02-23 20:16:03',NULL),(18,7902,16,2,'IIBB Buenos Aires 202x-xx',0.00,'2025-02-24 16:40:55','2025-02-24 16:40:55',NULL),(19,7902,5,2,'BANCO ROHR 20XX-XX',0.00,'2025-09-05 16:09:33','2025-09-05 16:09:33',NULL),(20,7902,5,2,NULL,0.00,'2025-09-11 19:06:11','2025-09-11 19:06:11',NULL),(21,7902,1,2,'PAGO DE SUELDOS Y CCSS',0.00,'2025-09-11 19:39:44','2025-09-11 19:39:44',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=49167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7902,40720,1518,12,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',383328.75,'APERTURA',NULL,1,'2022-09-30 11:11:23','2022-09-30 16:10:01','2022-09-30 16:10:01'),(2,7902,40720,1518,5,2,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',12725.90,'BANCO',NULL,1,'2022-09-30 11:26:28','2022-09-30 16:19:32','2022-09-30 16:19:32'),(3,7902,40720,1519,5,3,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',12616.23,'BANCO AGOSTO',NULL,1,'2022-09-30 11:30:41','2022-09-30 15:38:47','2022-09-30 15:38:47'),(4,7902,40720,1519,3,4,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',40404.96,'PAGO ROTARY DIVERSOS',NULL,1,'2022-09-30 11:35:26','2022-09-30 11:35:26',NULL),(5,7902,40720,1520,5,5,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2000.00,'BANCO SEPTIEMBRE 3757',NULL,1,'2022-09-30 11:38:21','2022-09-30 12:44:34','2022-09-30 12:44:34'),(6,7902,40720,1520,5,6,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',29285.67,'BANCO SEPT 3740',NULL,1,'2022-09-30 11:45:09','2022-09-30 16:26:44','2022-09-30 16:26:44'),(7,7902,40720,1521,5,7,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',12000.00,'BANCO OCT 3757',NULL,1,'2022-09-30 11:49:26','2022-09-30 15:41:06','2022-09-30 15:41:06'),(8,7902,40720,1521,5,8,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',26488.99,'BANCO OCT 3740',NULL,1,'2022-09-30 11:57:03','2022-09-30 11:57:03',NULL),(9,7902,40720,1522,5,9,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3000.00,'BANCO NOV 3757',NULL,1,'2022-09-30 11:59:55','2022-09-30 15:41:58','2022-09-30 15:41:58'),(10,7902,40720,1522,5,10,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',8612.37,'BANCO NOV 3740',NULL,1,'2022-09-30 12:02:41','2022-09-30 12:02:41',NULL),(11,7902,40720,1523,5,11,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',7000.00,'BANCO DIC 3757',NULL,1,'2022-09-30 12:09:16','2022-09-30 15:44:09','2022-09-30 15:44:09'),(12,7902,40720,1523,5,12,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1765.03,'BANCO DIC  3740',NULL,1,'2022-09-30 12:11:16','2022-09-30 12:11:16',NULL),(13,7902,40720,1525,5,13,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',43048.57,'BANCO ENE 3757',NULL,1,'2022-09-30 12:18:48','2022-09-30 15:46:11','2022-09-30 15:46:11'),(14,7902,40720,1525,5,14,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1765.03,'BANCO 3740',NULL,1,'2022-09-30 12:20:18','2022-09-30 12:23:38','2022-09-30 12:23:38'),(15,7902,40720,1525,5,15,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1765.03,'BANCO  ENE3740',NULL,1,'2022-09-30 12:23:38','2022-09-30 12:23:38',NULL),(16,7902,40720,1526,5,16,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',7000.00,'BANCO FEB 3757',NULL,1,'2022-09-30 12:26:48','2022-09-30 15:47:28','2022-09-30 15:47:28'),(17,7902,40720,1526,5,17,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1765.03,'BANCO FEB 3740',NULL,1,'2022-09-30 12:29:13','2022-09-30 12:29:13',NULL),(18,7902,40720,1527,5,18,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',33246.00,'BANCO MAR 3757',NULL,1,'2022-09-30 12:32:27','2022-09-30 15:48:43','2022-09-30 15:48:43');
INSERT INTO `balance_libro` VALUES (19,7902,40720,1527,5,19,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1765.03,'BANCO MAR 3740',NULL,1,'2022-09-30 12:33:40','2022-09-30 12:33:40',NULL),(20,7902,40720,1520,5,20,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2000.00,'BANCO SEPTIEMBRE 3757',NULL,1,'2022-09-30 12:44:34','2022-09-30 15:40:05','2022-09-30 15:40:05'),(21,7902,40720,1528,5,21,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4455.57,'BANCO ABR 3757',NULL,1,'2022-09-30 15:15:47','2022-09-30 15:49:36','2022-09-30 15:49:36'),(22,7902,40720,1528,5,22,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1765.03,'BANCO ABR 3740',NULL,1,'2022-09-30 15:18:13','2022-09-30 15:18:13',NULL),(23,7902,40720,1529,5,23,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',12742.03,'BANCO MAY 3757',NULL,1,'2022-09-30 15:20:34','2022-09-30 15:50:47','2022-09-30 15:50:47'),(24,7902,40720,1529,5,24,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1765.03,'BANCO ABR 3740',NULL,1,'2022-09-30 15:22:48','2022-09-30 15:22:48',NULL),(25,7902,40720,1530,5,25,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',53418.60,'BANCO JUN 3757',NULL,1,'2022-09-30 15:24:33','2022-09-30 15:54:02','2022-09-30 15:54:02'),(26,7902,40720,1530,5,26,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2471.04,'BANCO JUN 3740',NULL,1,'2022-09-30 15:26:29','2022-09-30 15:26:29',NULL),(27,7902,40720,1530,5,27,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3913877.22,'BANCO JUN 3740',NULL,1,'2022-09-30 15:31:45','2022-09-30 15:31:45',NULL),(28,7902,40720,1519,5,28,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',12616.23,'BANCO AGO 3757',NULL,1,'2022-09-30 15:38:47','2022-09-30 16:20:16','2022-09-30 16:20:16'),(29,7902,40720,1520,5,29,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2012.00,'BANCO SEPTIEMBRE 3757',NULL,1,'2022-09-30 15:40:05','2022-09-30 15:40:05',NULL),(30,7902,40720,1521,5,30,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',12072.00,'BANCO OCT 3757',NULL,1,'2022-09-30 15:41:06','2022-09-30 15:41:06',NULL),(31,7902,40720,1522,5,31,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3018.00,'BANCO NOV 3757',NULL,1,'2022-09-30 15:41:58','2022-09-30 15:41:58',NULL),(32,7902,40720,1523,5,32,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',7200.24,'BANCO DIC 3757',NULL,1,'2022-09-30 15:44:09','2022-09-30 15:44:09',NULL),(33,7902,40720,1525,5,33,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',84419.57,'BANCO ENE 3757',NULL,1,'2022-09-30 15:46:11','2022-09-30 15:46:11',NULL),(34,7902,40720,1526,5,34,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',7322.67,'BANCO FEB 3757',NULL,1,'2022-09-30 15:47:28','2022-09-30 15:47:28',NULL),(35,7902,40720,1527,5,35,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',41246.00,'BANCO MAR 3757',NULL,1,'2022-09-30 15:48:43','2022-09-30 15:48:43',NULL),(36,7902,40720,1528,5,36,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4455.57,'BANCO ABR 3757',NULL,1,'2022-09-30 15:49:36','2022-09-30 15:49:36',NULL),(37,7902,40720,1529,5,37,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',12748.03,'BANCO MAY 3757',NULL,1,'2022-09-30 15:50:47','2022-09-30 15:50:47',NULL);
INSERT INTO `balance_libro` VALUES (38,7902,40720,1530,5,38,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',53418.60,'BANCO JUN 3757',NULL,1,'2022-09-30 15:54:02','2022-09-30 15:54:02',NULL),(39,7902,40720,1518,12,39,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',383328.75,'APERTURA',NULL,1,'2022-09-30 16:10:01','2022-09-30 16:22:39','2022-09-30 16:22:39'),(40,7902,40720,1518,4,40,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',5366.42,'Amortizacion del ejercicio 2021',NULL,1,'2022-09-30 16:17:51','2022-09-30 16:17:51',NULL),(41,7902,40720,1518,5,41,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',12725.90,'BANCO',NULL,1,'2022-09-30 16:19:32','2022-09-30 16:19:32',NULL),(42,7902,40720,1519,5,42,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',12616.23,'BANCO AGO 3757',NULL,1,'2022-09-30 16:20:16','2022-09-30 16:20:16',NULL),(43,7902,40720,1518,12,43,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',383328.75,'APERTURA',NULL,1,'2022-09-30 16:22:39','2022-09-30 16:22:39',NULL),(44,7902,40720,1520,5,44,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',29285.67,'BANCO SEPT 3740',NULL,1,'2022-09-30 16:26:44','2022-09-30 16:26:44',NULL),(45,7902,40720,1530,23,45,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',126770.71,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-09-30 16:29:21','2022-09-30 16:29:22',NULL),(46,7902,40720,1530,3,46,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',20663.32,'GASTOS ADM',NULL,1,'2022-10-01 09:24:07','2022-10-01 09:24:07',NULL),(65,7902,40729,15183,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',12300.00,NULL,NULL,1,'2022-10-17 12:52:12','2022-10-17 12:52:12',NULL),(66,7902,40729,15183,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',90000.00,NULL,NULL,1,'2022-10-17 12:52:12','2022-10-17 12:52:12',NULL),(67,7902,40729,15183,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',160000.00,NULL,NULL,1,'2022-10-17 12:52:12','2022-10-17 12:52:12',NULL),(68,7902,40729,15183,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',3700.00,NULL,NULL,1,'2022-10-17 12:52:12','2022-10-17 12:52:12',NULL),(69,7902,40729,15183,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',70000.00,NULL,NULL,1,'2022-10-17 12:52:12','2022-10-17 12:52:12',NULL),(70,7902,40729,15182,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',12300.00,NULL,NULL,1,'2022-10-17 12:56:45','2022-10-17 12:56:45',NULL),(71,7902,40729,15182,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',8390.55,NULL,NULL,1,'2022-10-17 12:56:45','2022-10-17 12:56:45',NULL),(72,7902,40729,15182,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',13000.00,NULL,NULL,1,'2022-10-17 12:56:45','2022-10-17 12:56:45',NULL),(73,7902,40729,15182,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',10000.00,NULL,NULL,1,'2022-10-17 12:56:45','2022-10-17 12:56:45',NULL),(74,7902,40729,15182,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',50000.00,NULL,NULL,1,'2022-10-17 12:56:45','2022-10-17 12:56:45',NULL),(75,7902,40729,15182,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',40000.00,NULL,NULL,1,'2022-10-17 12:56:45','2022-10-17 12:56:45',NULL);
INSERT INTO `balance_libro` VALUES (76,7902,40729,15182,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',110000.00,NULL,NULL,1,'2022-10-17 12:56:45','2022-10-17 12:56:45',NULL),(77,7902,40729,15182,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',16000.00,NULL,NULL,1,'2022-10-17 12:56:45','2022-10-17 12:56:45',NULL),(78,7902,40729,15181,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',12300.00,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(79,7902,40729,15181,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',35000.00,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(80,7902,40729,15181,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',36000.00,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(81,7902,40729,15181,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',35000.00,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(82,7902,40729,15181,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',36000.00,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(83,7902,40729,15181,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',13600.00,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(84,7902,40729,15181,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6000.00,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(85,7902,40729,15181,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8390.55,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(86,7902,40729,15181,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',160000.00,NULL,NULL,1,'2022-10-17 12:57:33','2022-10-17 12:57:33',NULL),(87,7902,40729,15180,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',8390.55,NULL,NULL,1,'2022-10-17 12:58:11','2022-10-17 12:58:11',NULL),(88,7902,40729,15180,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',4200.00,NULL,NULL,1,'2022-10-17 12:58:11','2022-10-17 12:58:11',NULL),(89,7902,40729,15180,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',6000.00,NULL,NULL,1,'2022-10-17 12:58:11','2022-10-17 12:58:11',NULL),(90,7902,40729,15180,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',8000.00,NULL,NULL,1,'2022-10-17 12:58:11','2022-10-17 12:58:11',NULL),(91,7902,40729,15180,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',3000.00,NULL,NULL,1,'2022-10-17 12:58:11','2022-10-17 12:58:11',NULL),(92,7902,40729,15179,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',25000.00,NULL,NULL,1,'2022-10-17 12:58:48','2022-10-17 12:58:48',NULL),(93,7902,40729,15179,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',8390.55,NULL,NULL,1,'2022-10-17 12:58:48','2022-10-17 12:58:48',NULL),(94,7902,40729,15179,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',12000.00,NULL,NULL,1,'2022-10-17 12:58:48','2022-10-17 12:58:48',NULL),(95,7902,40729,15179,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',12300.00,NULL,NULL,1,'2022-10-17 12:58:48','2022-10-17 12:58:48',NULL),(96,7902,40729,15179,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',52000.00,NULL,NULL,1,'2022-10-17 12:59:16','2022-10-17 12:59:16',NULL);
INSERT INTO `balance_libro` VALUES (97,7902,40729,15179,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',8390.55,NULL,NULL,1,'2022-10-17 12:59:16','2022-10-17 12:59:16',NULL),(98,7902,40729,15179,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',50000.00,NULL,NULL,1,'2022-10-17 12:59:17','2022-10-17 12:59:17',NULL),(99,7902,40729,15179,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',12300.00,NULL,NULL,1,'2022-10-17 12:59:17','2022-10-17 12:59:17',NULL),(100,7902,40729,15177,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',8000.00,NULL,NULL,1,'2022-10-17 13:00:36','2022-10-17 13:00:36',NULL),(101,7902,40729,15177,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',30000.00,NULL,NULL,1,'2022-10-17 13:00:36','2022-10-17 13:00:36',NULL),(102,7902,40729,15177,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',12500.00,NULL,NULL,1,'2022-10-17 13:00:36','2022-10-17 13:00:36',NULL),(103,7902,40729,15177,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',8390.55,NULL,NULL,1,'2022-10-17 13:00:36','2022-10-17 13:00:36',NULL),(104,7902,40729,15177,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',29000.00,NULL,NULL,1,'2022-10-17 13:00:37','2022-10-17 13:00:37',NULL),(105,7902,40729,15177,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',7000.00,NULL,NULL,1,'2022-10-17 13:00:37','2022-10-17 13:00:37',NULL),(106,7902,40729,15177,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',12100.00,NULL,NULL,1,'2022-10-17 13:00:37','2022-10-17 13:00:37',NULL),(107,7902,40729,15176,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',8694.65,NULL,NULL,1,'2022-10-17 13:01:12','2022-10-17 13:01:12',NULL),(108,7902,40729,15176,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',6000.00,NULL,NULL,1,'2022-10-17 13:01:12','2022-10-17 13:01:12',NULL),(109,7902,40729,15176,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',8000.00,NULL,NULL,1,'2022-10-17 13:01:12','2022-10-17 13:01:12',NULL),(110,7902,40729,15176,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',18000.00,NULL,NULL,1,'2022-10-17 13:01:12','2022-10-17 13:01:12',NULL),(111,7902,40729,15175,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',10037.89,NULL,NULL,1,'2022-10-17 13:01:44','2022-10-17 13:01:44',NULL),(112,7902,40729,15175,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',8801.69,NULL,NULL,1,'2022-10-17 13:01:44','2022-10-17 13:01:44',NULL),(113,7902,40729,15175,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',9521.32,NULL,NULL,1,'2022-10-17 13:01:44','2022-10-17 13:01:44',NULL),(114,7902,40729,15175,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',17000.00,NULL,NULL,1,'2022-10-17 13:01:44','2022-10-17 13:01:44',NULL),(115,7902,40729,15175,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10000.00,NULL,NULL,1,'2022-10-17 13:01:44','2022-10-17 13:01:44',NULL),(116,7902,40748,18190,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',80000.00,NULL,NULL,1,'2022-10-31 13:04:27','2022-10-31 13:04:27',NULL),(117,7902,40748,18190,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',60000.00,NULL,NULL,1,'2022-10-31 13:04:27','2022-10-31 13:04:27',NULL);
INSERT INTO `balance_libro` VALUES (118,7902,40729,15184,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',12300.00,NULL,NULL,1,'2022-10-31 17:22:59','2022-10-31 17:22:59',NULL),(119,7902,40729,15184,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16000.00,NULL,NULL,1,'2022-10-31 17:22:59','2022-10-31 17:22:59',NULL),(120,7902,40729,15184,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',12300.00,NULL,NULL,1,'2022-10-31 17:22:59','2022-10-31 17:22:59',NULL),(121,7902,40729,15184,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',34800.00,NULL,NULL,1,'2022-10-31 17:22:59','2022-10-31 17:22:59',NULL),(122,7902,40729,15184,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',200000.00,NULL,NULL,1,'2022-10-31 17:22:59','2022-10-31 17:22:59',NULL),(123,7902,40729,15184,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',6000.00,NULL,NULL,1,'2022-10-31 17:22:59','2022-10-31 17:22:59',NULL),(124,7902,40729,15184,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',8390.55,NULL,NULL,1,'2022-10-31 17:22:59','2022-10-31 17:22:59',NULL),(125,7902,40729,15184,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',8390.55,NULL,NULL,1,'2022-10-31 17:23:00','2022-10-31 17:23:00',NULL),(126,7902,40729,15184,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',30000.00,NULL,NULL,1,'2022-10-31 17:23:00','2022-10-31 17:23:00',NULL),(127,7902,40748,18199,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',31000.00,NULL,NULL,1,'2022-11-01 10:12:19','2022-11-01 10:12:19',NULL),(128,7902,40748,18199,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',31000.00,NULL,NULL,1,'2022-11-01 10:12:19','2022-11-01 10:12:19',NULL),(129,7902,40748,18199,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',120000.00,NULL,NULL,1,'2022-11-01 10:12:19','2022-11-01 10:12:19',NULL),(130,7902,40748,18199,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',35000.00,NULL,NULL,1,'2022-11-01 10:12:19','2022-11-01 10:12:19',NULL),(131,7902,40748,18199,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',31000.00,NULL,NULL,1,'2022-11-01 10:12:19','2022-11-01 10:12:19',NULL),(132,7902,40748,18199,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',100000.00,NULL,NULL,1,'2022-11-01 10:12:20','2022-11-01 10:12:20',NULL),(133,7902,40748,18199,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',9150.00,NULL,NULL,1,'2022-11-01 10:12:35','2022-11-01 10:12:35',NULL),(134,7902,40750,21229,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28999.00,NULL,NULL,1,'2022-11-03 12:10:05','2022-11-03 12:10:05',NULL),(135,7902,40750,21229,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28999.00,NULL,NULL,1,'2022-11-03 12:10:05','2022-11-03 12:10:05',NULL),(136,7902,40750,21229,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',625.00,NULL,NULL,1,'2022-11-03 12:10:05','2022-11-03 12:10:05',NULL),(137,7902,40750,21229,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',21975.36,NULL,NULL,1,'2022-11-03 12:10:05','2022-11-03 12:10:05',NULL),(138,7902,40759,22732,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',496705.00,NULL,NULL,1,'2022-11-04 10:41:47','2022-11-04 10:41:47',NULL);
INSERT INTO `balance_libro` VALUES (139,7902,40759,22732,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',481580.00,NULL,NULL,1,'2022-11-04 10:41:47','2022-11-04 10:41:47',NULL),(140,7902,40759,22732,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',5136.41,NULL,NULL,1,'2022-11-04 10:42:03','2022-11-04 10:42:03',NULL),(141,7902,40759,22732,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16822.80,NULL,NULL,1,'2022-11-04 10:42:03','2022-11-04 10:42:03',NULL),(142,7902,40759,22732,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5781.97,NULL,NULL,1,'2022-11-04 10:42:03','2022-11-04 10:42:03',NULL),(143,7902,40759,22732,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',6420.60,NULL,NULL,1,'2022-11-04 10:42:03','2022-11-04 10:42:03',NULL),(144,7902,40759,22732,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',5136.41,NULL,NULL,1,'2022-11-04 10:42:03','2022-11-04 10:42:03',NULL),(145,7902,40759,22732,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',3595.48,NULL,NULL,1,'2022-11-04 10:42:03','2022-11-04 10:42:03',NULL),(146,7902,40759,22732,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',6420.60,NULL,NULL,1,'2022-11-04 10:42:03','2022-11-04 10:42:03',NULL),(147,7902,40759,22732,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',8988.92,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(148,7902,40759,22732,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2498.82,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(149,7902,40759,22732,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3852.35,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(150,7902,40759,22732,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',12070.80,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(151,7902,40759,22732,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',8988.92,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(152,7902,40759,22732,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',8988.92,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(153,7902,40759,22732,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',4109.25,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(154,7902,40759,22732,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',13956.84,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(155,7902,40759,22732,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',8988.92,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(156,7902,40759,22732,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',7062.67,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(157,7902,40759,22732,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',10272.98,NULL,NULL,1,'2022-11-04 10:42:04','2022-11-04 10:42:04',NULL),(158,7902,40759,22732,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',7704.83,NULL,NULL,1,'2022-11-04 10:42:05','2022-11-04 10:42:05',NULL),(159,7902,40759,22732,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',3852.32,NULL,NULL,1,'2022-11-04 10:42:05','2022-11-04 10:42:05',NULL);
INSERT INTO `balance_libro` VALUES (160,7902,40759,22732,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4751.31,NULL,NULL,1,'2022-11-04 10:42:05','2022-11-04 10:42:05',NULL),(161,7902,40759,22732,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',12841.27,NULL,NULL,1,'2022-11-04 10:42:05','2022-11-04 10:42:05',NULL),(162,7902,40759,22732,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3748.20,NULL,NULL,1,'2022-11-04 10:42:05','2022-11-04 10:42:05',NULL),(163,7902,40759,22732,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7294.06,NULL,NULL,1,'2022-11-04 10:42:05','2022-11-04 10:42:05',NULL),(164,7902,40720,1530,17,164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',233140.13,'ASIENTO DE CIERRE EERR',NULL,1,'2022-12-05 10:51:42','2022-12-05 10:57:04','2022-12-05 10:57:04'),(165,7902,40720,1530,17,165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',233140.13,'ASIENTO DE CIERRE EERR',NULL,1,'2022-12-05 10:57:04','2022-12-05 10:57:04',NULL),(166,7902,40720,1530,17,166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4339249.68,'CIERRE PATRIMONIAL',NULL,1,'2022-12-05 11:06:19','2022-12-05 11:06:19',NULL),(167,7902,40720,1531,12,167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',4311123.97,'ASIENTO APERTURA',NULL,1,'2022-12-05 11:31:35','2022-12-05 11:31:35',NULL),(168,7902,40720,1531,5,168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2086116.19,'Banco cta 3740 Julio 21',NULL,1,'2022-12-06 10:26:35','2022-12-06 10:26:35',NULL),(169,7902,40720,1531,5,169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',35324.96,'BANCO 3757 Julio 21',NULL,1,'2022-12-06 10:31:57','2022-12-06 10:34:32','2022-12-06 10:34:32'),(170,7902,40720,1531,5,170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',35324.96,'BANCO 3757 Julio 21',NULL,1,'2022-12-06 10:34:32','2022-12-06 10:34:32',NULL),(171,7902,40720,1532,5,171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',70136.09,'BANCO 3740 Ago 21',NULL,1,'2022-12-06 10:43:24','2022-12-06 10:43:24',NULL),(172,7902,40720,1532,5,172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',14764.97,'Banco 37572 Ago 21',NULL,1,'2022-12-06 10:48:56','2022-12-06 10:51:06','2022-12-06 10:51:06'),(173,7902,40720,1532,5,173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',14764.97,'Banco 37572 Ago 21',NULL,1,'2022-12-06 10:51:06','2022-12-06 10:51:06',NULL),(174,7902,40720,1533,5,174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',153959.32,'BANCO 3740 Sept 21',NULL,1,'2022-12-06 10:54:35','2022-12-06 10:54:35',NULL),(175,7902,40720,1533,5,175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10400.00,'Banco 37572 Sept 21',NULL,1,'2022-12-06 10:56:57','2022-12-06 10:56:57',NULL),(176,7902,40720,1534,5,176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',436509.74,'BANCO 3740 Oct 21',NULL,1,'2022-12-06 10:59:41','2022-12-06 10:59:41',NULL),(177,7902,40720,1534,5,177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',10400.00,'Banco 37572 Oct 21',NULL,1,'2022-12-06 11:05:45','2022-12-06 11:05:45',NULL),(178,7902,40720,1535,5,178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',186908.16,'Banco cta 3740 Nov 21',NULL,1,'2022-12-06 11:09:06','2022-12-06 11:09:06',NULL);
INSERT INTO `balance_libro` VALUES (179,7902,40720,1535,5,179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',9524.01,'Banco 37572 Nov 21',NULL,1,'2022-12-06 11:11:57','2022-12-06 11:11:57',NULL),(180,7902,40720,1536,5,180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',74592.21,'Banco cta 3740 Dic 21',NULL,1,'2022-12-06 11:14:04','2022-12-06 11:14:04',NULL),(181,7902,40720,1536,5,181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',96170.00,'Banco 37572 Dic 21',NULL,1,'2022-12-07 07:30:46','2022-12-07 12:28:43','2022-12-07 12:28:43'),(182,7902,40720,1536,5,182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',96170.00,'Banco 37572 Dic 21',NULL,1,'2022-12-07 07:30:46','2022-12-07 07:32:58','2022-12-07 07:32:58'),(183,7902,40720,1536,5,183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',96170.00,'Banco 37572 Dic 21',NULL,1,'2022-12-07 07:32:58','2022-12-07 07:32:58',NULL),(184,7902,40720,1540,5,184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',24148.93,'Banco cta 3740 Ene 22',NULL,1,'2022-12-07 07:35:33','2022-12-07 07:35:33',NULL),(185,7902,40720,1540,5,185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2600.00,'Banco 37572 Ene 22',NULL,1,'2022-12-07 07:37:17','2022-12-07 07:37:17',NULL),(186,7902,40720,1541,5,186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1157150.09,'Banco cta 3740 Feb 22',NULL,1,'2022-12-07 07:40:39','2022-12-07 07:40:39',NULL),(187,7902,40720,1541,5,187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',71863.92,'Banco 37572 Feb 22',NULL,1,'2022-12-07 07:45:53','2022-12-07 07:45:53',NULL),(188,7902,40720,1542,5,188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',868047.72,'Banco cta 3740 Mar 22',NULL,1,'2022-12-07 07:47:34','2022-12-07 07:47:34',NULL),(189,7902,40720,1542,5,189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',13049.43,'Banco 37572 Mar 22',NULL,1,'2022-12-07 07:49:38','2022-12-07 07:49:38',NULL),(190,7902,40720,1543,5,190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',41700.00,'Banco 37572 Abr 22',NULL,1,'2022-12-07 07:51:46','2022-12-07 07:51:46',NULL),(191,7902,40720,1544,5,191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',15600.00,'Banco 37572 May 22',NULL,1,'2022-12-07 07:53:37','2022-12-07 07:53:37',NULL),(192,7902,40720,1545,5,192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',633085.86,'Banco cta 3740 Jun 22',NULL,1,'2022-12-07 07:57:49','2022-12-07 07:57:49',NULL),(193,7902,40720,1545,5,193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',9100.00,'Banco 37572 Jun 22',NULL,1,'2022-12-07 07:58:59','2022-12-07 12:22:28','2022-12-07 12:22:28'),(194,7902,40720,1545,5,194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',9100.00,'Banco 37572 Jun 22',NULL,1,'2022-12-07 12:22:28','2022-12-07 12:22:28',NULL),(195,7902,40720,1545,23,195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',117482.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-07 16:03:21','2022-12-22 15:59:52','2022-12-22 15:59:52'),(196,7902,40720,1545,23,196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',24536.39,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-22 15:55:26','2022-12-22 15:57:37','2022-12-22 15:57:37');
INSERT INTO `balance_libro` VALUES (197,7902,40720,1544,23,197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1291.09,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-22 15:58:24','2022-12-22 15:59:36','2022-12-22 15:59:36'),(198,7902,40720,1545,23,198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',226741.91,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-22 16:00:43','2022-12-22 16:00:44',NULL),(199,7902,40750,21230,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',10200.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(200,7902,40750,21230,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2700.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(201,7902,40750,21230,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',8580.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(202,7902,40750,21230,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6930.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(203,7902,40750,21230,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',23320.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(204,7902,40750,21230,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',94380.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(205,7902,40750,21230,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',17600.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(206,7902,40750,21230,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2750.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(207,7902,40750,21230,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',13000.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(208,7902,40750,21230,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',5390.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(209,7902,40750,21230,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',5400.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(210,7902,40750,21230,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',5400.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(211,7902,40750,21230,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',15000.00,NULL,NULL,1,'2022-12-28 18:50:38','2022-12-28 18:50:38',NULL),(212,7902,40773,24232,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7000.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(213,7902,40773,24232,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',18400.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(214,7902,40773,24232,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7960.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(215,7902,40773,24232,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2260.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(216,7902,40773,24232,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1900.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL);
INSERT INTO `balance_libro` VALUES (217,7902,40773,24232,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3800.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(218,7902,40773,24232,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1800.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(219,7902,40773,24232,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',16550.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(220,7902,40773,24232,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',18400.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(221,7902,40773,24232,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3500.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(222,7902,40773,24232,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5250.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(223,7902,40773,24232,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3800.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(224,7902,40773,24232,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3600.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(225,7902,40773,24232,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',10500.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(226,7902,40773,24232,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3800.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(227,7902,40773,24232,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7000.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(228,7902,40773,24232,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3600.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(229,7902,40773,24232,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3800.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(230,7902,40773,24232,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3600.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(231,7902,40773,24232,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3800.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(232,7902,40773,24232,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1800.00,NULL,NULL,1,'2023-02-11 11:05:48','2023-02-11 11:05:48',NULL),(233,7902,40773,24232,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3800.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(234,7902,40773,24232,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7400.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(235,7902,40773,24232,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5600.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(236,7902,40773,24232,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1800.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(237,7902,40773,24232,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1800.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL);
INSERT INTO `balance_libro` VALUES (238,7902,40773,24232,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1800.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(239,7902,40773,24232,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5600.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(240,7902,40773,24232,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5400.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(241,7902,40773,24232,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5600.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(242,7902,40773,24232,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3600.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(243,7902,40773,24232,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5960.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(244,7902,40773,24232,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',18400.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(245,7902,40773,24232,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3600.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(246,7902,40773,24232,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',14550.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(247,7902,40773,24232,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3500.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(248,7902,40773,24232,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10800.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(249,7902,40773,24232,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',18000.00,NULL,NULL,1,'2023-02-11 11:05:49','2023-02-11 11:05:49',NULL),(250,7902,40749,19720,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',140000.00,NULL,NULL,1,'2023-02-11 16:23:21','2023-02-11 16:23:21',NULL),(251,7902,40749,19720,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',300000.00,NULL,NULL,1,'2023-02-11 16:23:21','2023-02-11 16:23:21',NULL),(252,7902,40749,19720,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',39000.00,NULL,NULL,1,'2023-02-11 16:23:21','2023-02-11 16:23:21',NULL),(253,7902,40748,18205,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',40000.00,NULL,NULL,1,'2023-02-11 16:59:36','2023-02-11 16:59:36',NULL),(254,7902,40748,18205,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',37000.00,NULL,NULL,1,'2023-02-11 16:59:36','2023-02-11 16:59:36',NULL),(255,7902,40750,21235,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',17500.00,NULL,NULL,1,'2023-02-11 17:07:48','2023-02-11 17:07:48',NULL),(256,7902,40750,21235,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3750.00,NULL,NULL,1,'2023-02-11 17:07:48','2023-02-11 17:07:48',NULL),(257,7902,40750,21235,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',53080.00,NULL,NULL,1,'2023-02-11 17:07:48','2023-02-11 17:07:48',NULL),(258,7902,40750,21235,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',52360.00,NULL,NULL,1,'2023-02-11 17:07:48','2023-02-11 17:07:48',NULL);
INSERT INTO `balance_libro` VALUES (259,7902,40750,21235,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2860.00,NULL,NULL,1,'2023-02-11 17:07:48','2023-02-11 17:07:48',NULL),(260,7902,40750,21235,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',27390.00,NULL,NULL,1,'2023-02-11 17:07:48','2023-02-11 17:07:48',NULL),(261,7902,40750,21235,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5450.00,NULL,NULL,1,'2023-02-11 17:07:48','2023-02-11 17:07:48',NULL),(262,7902,40820,27262,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3600.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(263,7902,40820,27262,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3800.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(264,7902,40820,27262,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3600.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(265,7902,40820,27262,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1800.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(266,7902,40820,27262,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',11400.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(267,7902,40820,27262,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1800.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(268,7902,40820,27262,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5400.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(269,7902,40820,27262,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4500.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(270,7902,40820,27262,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5600.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(271,7902,40820,27262,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5600.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(272,7902,40820,27262,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',17480.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(273,7902,40820,27262,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4100.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(274,7902,40820,27262,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1800.00,NULL,NULL,1,'2023-02-11 17:31:07','2023-02-11 17:31:07',NULL),(275,7902,40820,27262,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',27400.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(276,7902,40820,27262,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1550.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(277,7902,40820,27262,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3450.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(278,7902,40820,27262,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1800.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(279,7902,40820,27262,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3800.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL);
INSERT INTO `balance_libro` VALUES (280,7902,40820,27262,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3800.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(281,7902,40820,27262,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7200.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(282,7902,40820,27262,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10800.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(283,7902,40820,27262,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5600.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(284,7902,40820,27262,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1750.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(285,7902,40820,27262,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',18400.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(286,7902,40820,27262,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',18400.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(287,7902,40820,27262,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',11450.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(288,7902,40820,27262,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5050.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(289,7902,40820,27262,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3200.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(290,7902,40820,27262,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3560.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(291,7902,40820,27262,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3200.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(292,7902,40820,27262,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5050.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(293,7902,40820,27262,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1550.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(294,7902,40820,27262,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7750.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(295,7902,40820,27262,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3200.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(296,7902,40820,27262,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5050.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(297,7902,40820,27262,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3450.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(298,7902,40820,27262,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1600.00,NULL,NULL,1,'2023-02-11 17:31:08','2023-02-11 17:31:08',NULL),(299,7902,40820,27262,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3200.00,NULL,NULL,1,'2023-02-11 17:31:09','2023-02-11 17:31:09',NULL),(300,7902,40820,27262,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5050.00,NULL,NULL,1,'2023-02-11 17:31:09','2023-02-11 17:31:09',NULL);
INSERT INTO `balance_libro` VALUES (301,7902,40820,27262,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3100.00,NULL,NULL,1,'2023-02-11 17:31:09','2023-02-11 17:31:09',NULL),(302,7902,40820,27262,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6650.00,NULL,NULL,1,'2023-02-11 17:31:09','2023-02-11 17:31:09',NULL),(303,7902,40820,27262,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1800.00,NULL,NULL,1,'2023-02-11 17:31:09','2023-02-11 17:31:09',NULL),(304,7902,40820,27262,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',14600.00,NULL,NULL,1,'2023-02-11 17:31:09','2023-02-11 17:31:09',NULL),(305,7902,40820,27262,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',7630.00,NULL,NULL,1,'2023-02-11 17:31:09','2023-02-11 17:31:09',NULL),(306,7902,40820,27262,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',10800.00,NULL,NULL,1,'2023-02-11 17:31:09','2023-02-11 17:31:09',NULL),(307,7902,40819,25747,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3600.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(308,7902,40819,25747,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3500.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(309,7902,40819,25747,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',15200.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(310,7902,40819,25747,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',12800.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(311,7902,40819,25747,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5400.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(312,7902,40819,25747,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6350.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(313,7902,40819,25747,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3600.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(314,7902,40819,25747,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7600.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(315,7902,40819,25747,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6060.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(316,7902,40819,25747,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7600.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(317,7902,40819,25747,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1800.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(318,7902,40819,25747,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6650.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(319,7902,40819,25747,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4950.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(320,7902,40819,25747,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3200.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(321,7902,40819,25747,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1550.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL);
INSERT INTO `balance_libro` VALUES (322,7902,40819,25747,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',12400.00,NULL,NULL,1,'2023-02-11 17:37:50','2023-02-11 17:37:50',NULL),(323,7902,40819,25747,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3000.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(324,7902,40819,25747,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3100.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(325,7902,40819,25747,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3000.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(326,7902,40819,25747,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1600.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(327,7902,40819,25747,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3000.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(328,7902,40819,25747,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5050.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(329,7902,40819,25747,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3200.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(330,7902,40819,25747,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4800.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(331,7902,40819,25747,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3000.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(332,7902,40819,25747,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4900.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(333,7902,40819,25747,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5500.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(334,7902,40819,25747,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5450.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(335,7902,40819,25747,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',16050.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(336,7902,40819,25747,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7560.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(337,7902,40819,25747,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',19500.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(338,7902,40819,25747,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1700.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(339,7902,40819,25747,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',24600.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(340,7902,40819,25747,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5300.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(341,7902,40819,25747,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6800.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(342,7902,40819,25747,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7200.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL);
INSERT INTO `balance_libro` VALUES (343,7902,40819,25747,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7560.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(344,7902,40819,25747,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',16050.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(345,7902,40819,25747,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',15300.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(346,7902,40819,25747,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6800.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(347,7902,40819,25747,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4900.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(348,7902,40819,25747,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5700.00,NULL,NULL,1,'2023-02-11 17:37:51','2023-02-11 17:37:51',NULL),(349,7902,40819,25747,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3400.00,NULL,NULL,1,'2023-02-11 17:37:52','2023-02-11 17:37:52',NULL),(350,7902,40819,25747,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6800.00,NULL,NULL,1,'2023-02-11 17:37:52','2023-02-11 17:37:52',NULL),(351,7902,40819,25747,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6800.00,NULL,NULL,1,'2023-02-11 17:37:52','2023-02-11 17:37:52',NULL),(352,7902,40819,25747,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3600.00,NULL,NULL,1,'2023-02-11 17:37:52','2023-02-11 17:37:52',NULL),(353,7902,40819,25747,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3600.00,NULL,NULL,1,'2023-02-11 17:37:52','2023-02-11 17:37:52',NULL),(354,7902,40819,25747,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',7150.00,NULL,NULL,1,'2023-02-11 17:37:52','2023-02-11 17:37:52',NULL),(355,7902,40906,28777,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',33757.44,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(356,7902,40906,28777,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(357,7902,40906,28777,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(358,7902,40906,28777,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11252.48,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(359,7902,40906,28777,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',19850.96,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(360,7902,40906,28777,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11252.48,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(361,7902,40906,28777,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',33757.44,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(362,7902,40906,28777,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(363,7902,40906,28777,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL);
INSERT INTO `balance_libro` VALUES (364,7902,40906,28777,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11252.48,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(365,7902,40906,28777,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:40','2023-02-11 17:50:40',NULL),(366,7902,40906,28777,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(367,7902,40906,28777,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(368,7902,40906,28777,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(369,7902,40906,28777,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(370,7902,40906,28777,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(371,7902,40906,28777,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(372,7902,40906,28777,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(373,7902,40906,28777,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(374,7902,40906,28777,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22504.96,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(375,7902,40906,28777,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-02-11 17:50:41','2023-02-11 17:50:41',NULL),(376,7902,40920,30289,12,376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',2873794.76,NULL,NULL,1,'2023-06-15 19:41:59','2023-06-17 12:52:25','2023-06-17 12:52:25'),(405,7902,40920,30289,15,405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',456616.22,NULL,NULL,1,'2023-06-17 11:23:58','2023-06-17 11:23:58',NULL),(406,7902,40920,30289,3,406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',596135.12,NULL,NULL,1,'2023-06-17 11:23:58','2023-06-17 11:23:59',NULL),(407,7902,40920,30289,2,407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',927998.87,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(408,7902,40920,30289,15,408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',601411.64,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(409,7902,40920,30289,16,409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',13720.65,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(410,7902,40920,30290,3,410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1093576.96,NULL,NULL,1,'2023-06-17 11:23:59','2023-07-29 20:36:20','2023-07-29 20:36:20'),(411,7902,40920,30290,2,411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',650353.91,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL);
INSERT INTO `balance_libro` VALUES (412,7902,40920,30290,15,412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',660029.23,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(413,7902,40920,30290,16,413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',12651.39,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(414,7902,40920,30291,3,414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',633718.18,NULL,NULL,1,'2023-06-17 11:23:59','2023-07-29 20:37:58','2023-07-29 20:37:58'),(415,7902,40920,30291,2,415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',968392.10,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(416,7902,40920,30291,15,416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',719535.00,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(417,7902,40920,30291,16,417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',11824.31,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(418,7902,40920,30292,3,418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',1794944.23,NULL,NULL,1,'2023-06-17 11:23:59','2023-07-29 21:00:00','2023-07-29 21:00:00'),(419,7902,40920,30292,2,419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',950171.07,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(420,7902,40920,30292,15,420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',856532.46,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(421,7902,40920,30292,16,421,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',16146.48,NULL,NULL,1,'2023-06-17 11:23:59','2023-06-17 11:23:59',NULL),(422,7902,40920,30293,3,422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',798544.06,NULL,NULL,1,'2023-06-17 11:23:59','2023-07-29 21:00:43','2023-07-29 21:00:43'),(423,7902,40920,30293,2,423,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1333827.59,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(424,7902,40920,30293,15,424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',897009.85,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(425,7902,40920,30293,16,425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',13779.22,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(426,7902,40920,30294,3,426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',655527.13,NULL,NULL,1,'2023-06-17 11:24:00','2023-07-29 21:01:50','2023-07-29 21:01:50'),(427,7902,40920,30294,2,427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',840774.44,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(428,7902,40920,30294,15,428,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',837929.88,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(429,7902,40920,30294,16,429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',8685.68,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(430,7902,40920,30294,2,430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',3909.68,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 13:44:54','2023-06-17 13:44:54'),(431,7902,40920,30294,2,431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',3407.94,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL);
INSERT INTO `balance_libro` VALUES (432,7902,40920,30296,3,432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',1035371.92,NULL,NULL,1,'2023-06-17 11:24:00','2023-07-29 21:02:37','2023-07-29 21:02:37'),(433,7902,40920,30296,2,433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',1208960.51,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(434,7902,40920,30296,15,434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',940217.39,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(435,7902,40920,30296,16,435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',18142.70,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(436,7902,40920,30297,3,436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',916174.89,NULL,NULL,1,'2023-06-17 11:24:00','2023-07-29 13:33:34','2023-07-29 13:33:34'),(437,7902,40920,30297,2,437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1210943.52,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(438,7902,40920,30297,15,438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',959684.38,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(439,7902,40920,30297,16,439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',32372.34,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(440,7902,40920,30297,2,440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',4441.94,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(441,7902,40920,30298,3,441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1322066.36,NULL,NULL,1,'2023-06-17 11:24:00','2023-07-29 13:34:15','2023-07-29 13:34:15'),(442,7902,40920,30298,2,442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1637818.81,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(443,7902,40920,30298,15,443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1019385.38,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(444,7902,40920,30298,16,444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',41140.85,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(445,7902,40920,30298,2,445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3076.47,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:00',NULL),(446,7902,40920,30298,2,446,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8027.93,NULL,NULL,1,'2023-06-17 11:24:00','2023-06-17 11:24:01',NULL),(447,7902,40920,30299,3,447,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',883828.68,NULL,NULL,1,'2023-06-17 11:24:01','2023-07-29 21:05:22','2023-07-29 21:05:22'),(448,7902,40920,30299,2,448,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1046644.92,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(449,7902,40920,30299,15,449,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',946545.18,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(450,7902,40920,30299,16,450,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',37851.37,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(451,7902,40920,30299,2,451,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',7401.83,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL);
INSERT INTO `balance_libro` VALUES (452,7902,40920,30300,3,452,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',898216.53,NULL,NULL,1,'2023-06-17 11:24:01','2023-07-29 21:06:28','2023-07-29 21:06:28'),(453,7902,40920,30300,2,453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',1262857.10,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(454,7902,40920,30300,15,454,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',942535.15,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(455,7902,40920,30300,16,455,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',42737.95,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(456,7902,40920,30300,2,456,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',6920.14,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(457,7902,40920,30301,3,457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',943736.99,NULL,NULL,1,'2023-06-17 11:24:01','2023-07-29 21:07:19','2023-07-29 21:07:19'),(458,7902,40920,30301,2,458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1338316.89,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(459,7902,40920,30301,15,459,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',912398.37,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(460,7902,40920,30301,16,460,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',44164.81,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(461,7902,40920,30301,2,461,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',9425.83,NULL,NULL,1,'2023-06-17 11:24:01','2023-06-17 11:24:01',NULL),(462,7902,40920,30289,5,462,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',501430.58,NULL,NULL,1,'2023-06-17 12:32:19','2023-06-17 13:36:09','2023-06-17 13:36:09'),(463,7902,40920,30290,5,463,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',832227.55,NULL,NULL,1,'2023-06-17 12:32:19','2023-06-17 13:36:33','2023-06-17 13:36:33'),(464,7902,40920,30291,5,464,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',571871.70,NULL,NULL,1,'2023-06-17 12:32:19','2023-06-17 13:35:34','2023-06-17 13:35:34'),(465,7902,40920,30292,5,465,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',867188.16,NULL,NULL,1,'2023-06-17 12:32:20','2023-06-17 13:35:05','2023-06-17 13:35:05'),(466,7902,40920,30293,5,466,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',715585.66,NULL,NULL,1,'2023-06-17 12:32:20','2023-06-17 13:30:17','2023-06-17 13:30:17'),(467,7902,40920,30294,5,467,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',564846.22,NULL,NULL,1,'2023-06-17 12:32:20','2023-06-17 13:34:25','2023-06-17 13:34:25'),(468,7902,40920,30296,5,468,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',778719.58,NULL,NULL,1,'2023-06-17 12:32:20','2023-06-17 13:33:52','2023-06-17 13:33:52'),(469,7902,40920,30297,5,469,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',619012.08,NULL,NULL,1,'2023-06-17 12:32:20','2023-06-17 13:32:21','2023-06-17 13:32:21'),(470,7902,40920,30298,5,470,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',579950.62,NULL,NULL,1,'2023-06-17 12:32:20','2023-06-17 13:31:31','2023-06-17 13:31:31');
INSERT INTO `balance_libro` VALUES (471,7902,40920,30299,5,471,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',418426.93,NULL,NULL,1,'2023-06-17 12:32:20','2023-06-17 13:31:03','2023-06-17 13:31:03'),(472,7902,40920,30300,5,472,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',534923.37,NULL,NULL,1,'2023-06-17 12:32:20','2023-06-17 13:27:34','2023-06-17 13:27:34'),(473,7902,40920,30301,5,473,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',426813.16,NULL,NULL,1,'2023-06-17 12:32:21','2023-06-17 13:26:00','2023-06-17 13:26:00'),(474,7902,40920,30301,11,474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',90627.67,NULL,NULL,1,'2023-06-17 12:32:21','2023-06-17 12:32:21',NULL),(475,7902,40920,30289,11,475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',100000.00,NULL,NULL,1,'2023-06-17 12:32:21','2023-06-17 12:32:21',NULL),(476,7902,40920,30289,12,476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',2873794.76,NULL,NULL,1,'2023-06-17 12:52:25','2023-06-17 12:52:25',NULL),(477,7902,40920,30301,5,477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',426813.16,NULL,NULL,1,'2023-06-17 13:26:00','2023-06-17 13:33:29','2023-06-17 13:33:29'),(478,7902,40920,30300,5,478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',534923.37,NULL,NULL,1,'2023-06-17 13:27:34','2023-06-17 13:27:34',NULL),(479,7902,40920,30293,5,479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',715585.66,NULL,NULL,1,'2023-06-17 13:30:17','2023-06-17 13:30:17',NULL),(480,7902,40920,30299,5,480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',418426.93,NULL,NULL,1,'2023-06-17 13:31:03','2023-06-17 13:31:03',NULL),(481,7902,40920,30298,5,481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',579950.62,NULL,NULL,1,'2023-06-17 13:31:31','2023-06-17 13:31:31',NULL),(482,7902,40920,30297,5,482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',619012.08,NULL,NULL,1,'2023-06-17 13:32:21','2023-06-17 13:32:21',NULL),(483,7902,40920,30301,5,483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',426813.16,NULL,NULL,1,'2023-06-17 13:33:29','2023-06-17 13:33:29',NULL),(484,7902,40920,30296,5,484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',778719.58,NULL,NULL,1,'2023-06-17 13:33:52','2023-06-17 13:33:52',NULL),(485,7902,40920,30294,5,485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',564846.22,NULL,NULL,1,'2023-06-17 13:34:25','2023-06-17 13:34:25',NULL),(486,7902,40920,30292,5,486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',867188.16,NULL,NULL,1,'2023-06-17 13:35:05','2023-06-17 13:35:05',NULL),(487,7902,40920,30291,5,487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',571871.70,NULL,NULL,1,'2023-06-17 13:35:34','2023-06-17 13:35:34',NULL),(488,7902,40920,30289,5,488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',501430.58,NULL,NULL,1,'2023-06-17 13:36:09','2023-06-17 13:36:09',NULL),(489,7902,40920,30290,5,489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',832227.55,NULL,NULL,1,'2023-06-17 13:36:33','2023-06-17 13:36:33',NULL),(490,7902,40920,30294,2,490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',3909.68,NULL,NULL,1,'2023-06-17 13:44:54','2023-06-17 13:44:54',NULL);
INSERT INTO `balance_libro` VALUES (491,7902,40719,24,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',60000.00,NULL,NULL,1,'2023-07-07 16:14:16','2023-07-07 16:14:16',NULL),(492,7902,40719,24,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',25000.00,NULL,NULL,1,'2023-07-07 16:19:48','2023-07-07 16:19:48',NULL),(493,7902,40719,24,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',5000.00,NULL,NULL,1,'2023-07-07 16:37:51','2023-07-07 16:37:51',NULL),(494,7902,40719,24,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3000.00,NULL,NULL,1,'2023-07-07 16:37:52','2023-07-07 16:37:52',NULL),(495,7902,40719,24,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',10000.00,NULL,NULL,1,'2023-07-07 16:37:54','2023-07-07 16:37:54',NULL),(496,7902,40719,24,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3000.00,NULL,NULL,1,'2023-07-07 16:37:55','2023-07-07 16:37:55',NULL),(497,7902,40719,24,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',6000.00,NULL,NULL,1,'2023-07-21 17:49:39','2023-07-21 17:49:39',NULL),(498,7902,40719,24,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4500.00,NULL,NULL,1,'2023-07-21 17:49:41','2023-07-21 17:49:41',NULL),(499,7902,40719,24,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',10000.00,NULL,NULL,1,'2023-07-21 17:49:42','2023-07-21 17:49:42',NULL),(500,7902,40719,24,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4500.00,NULL,NULL,1,'2023-07-21 17:49:44','2023-07-21 17:49:44',NULL),(501,7902,40719,24,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4500.00,NULL,NULL,1,'2023-07-21 17:49:45','2023-07-21 17:49:45',NULL),(502,7902,40719,24,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4500.00,NULL,NULL,1,'2023-07-21 17:49:46','2023-07-21 17:49:46',NULL),(503,7902,40719,24,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',25000.00,NULL,NULL,1,'2023-07-21 17:49:48','2023-07-21 17:49:48',NULL),(504,7902,40719,24,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',60000.00,NULL,NULL,1,'2023-07-21 17:49:49','2023-07-21 17:49:49',NULL),(505,7902,40920,30297,3,505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',916174.89,NULL,NULL,1,'2023-07-29 13:33:34','2023-07-29 21:14:53','2023-07-29 21:14:53'),(506,7902,40920,30298,3,506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1322066.36,NULL,NULL,1,'2023-07-29 13:34:15','2023-07-29 21:15:42','2023-07-29 21:15:42'),(507,7902,40920,30290,3,507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1093576.96,NULL,NULL,1,'2023-07-29 20:36:20','2023-07-29 20:36:20',NULL),(508,7902,40920,30291,3,508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',633718.18,NULL,NULL,1,'2023-07-29 20:37:58','2023-07-29 20:37:58',NULL),(509,7902,40920,30292,3,509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',1794944.23,NULL,NULL,1,'2023-07-29 21:00:00','2023-08-02 16:51:30','2023-08-02 16:51:30'),(510,7902,40920,30293,3,510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',798544.06,NULL,NULL,1,'2023-07-29 21:00:43','2023-07-29 21:00:43',NULL),(511,7902,40920,30294,3,511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',655527.13,NULL,NULL,1,'2023-07-29 21:01:50','2023-07-29 21:01:50',NULL);
INSERT INTO `balance_libro` VALUES (512,7902,40920,30296,3,512,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',1035371.92,NULL,NULL,1,'2023-07-29 21:02:37','2023-07-29 21:02:37',NULL),(513,7902,40920,30299,3,513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',883828.68,NULL,NULL,1,'2023-07-29 21:05:22','2023-07-29 21:05:22',NULL),(514,7902,40920,30300,3,514,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',898216.53,NULL,NULL,1,'2023-07-29 21:06:28','2023-07-29 21:06:28',NULL),(515,7902,40920,30301,3,515,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',943736.99,NULL,NULL,1,'2023-07-29 21:07:19','2023-07-29 21:07:19',NULL),(516,7902,40920,30297,3,516,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',916174.89,NULL,NULL,1,'2023-07-29 21:14:53','2023-07-29 21:14:53',NULL),(517,7902,40920,30298,3,517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1322066.36,NULL,NULL,1,'2023-07-29 21:15:42','2023-07-29 21:15:42',NULL),(518,7902,40920,30292,3,518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',1794944.23,NULL,NULL,1,'2023-08-02 16:51:30','2023-08-02 16:51:30',NULL),(519,7902,40920,30301,11,519,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',592158.14,'Ajuste Bien de uso y amortización',NULL,1,'2023-08-02 17:04:56','2023-08-02 17:04:56',NULL),(520,7902,40920,30301,11,520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4425005.31,'CMV',NULL,1,'2023-08-02 17:18:03','2023-08-02 17:18:03',NULL),(521,7902,40920,30301,4,521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',201688.53,'Amortizacion del ejercicio',NULL,1,'2023-08-02 17:42:38','2023-08-02 17:42:38',NULL),(522,7902,40920,30301,23,522,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3185696.36,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-08-02 18:09:02','2023-08-02 18:14:10','2023-08-02 18:14:10'),(523,7902,40920,30289,17,523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2873794.76,'Asiento Cierre 2020',NULL,1,'2023-08-02 18:25:04','2023-08-02 18:26:14','2023-08-02 18:26:14'),(524,7902,40920,31936,17,524,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2873794.76,'Asiento Cierre 2020',NULL,1,'2023-08-02 18:26:14','2023-08-02 18:32:54','2023-08-02 18:32:54'),(525,7902,40920,30301,23,525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4124671.80,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-08-02 18:28:04','2023-08-02 18:32:45','2023-08-02 18:32:45'),(526,7902,40920,30301,23,526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3185696.36,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-08-04 17:34:22','2023-08-04 17:34:23',NULL),(565,7902,40920,30302,12,565,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',13078226.67,'Apertura Ejercicio 2022',NULL,1,'2023-08-21 13:46:32','2023-08-28 18:46:58','2023-08-28 18:46:58'),(570,7902,40920,30302,3,570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1657098.52,NULL,NULL,1,'2023-08-21 16:58:59','2023-08-24 13:30:52','2023-08-24 13:30:52'),(571,7902,40920,30303,3,571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1255619.74,NULL,NULL,1,'2023-08-21 16:58:59','2023-08-24 13:31:13','2023-08-24 13:31:13');
INSERT INTO `balance_libro` VALUES (572,7902,40920,30304,3,572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1629321.25,NULL,NULL,1,'2023-08-21 16:59:00','2023-08-24 13:31:32','2023-08-24 13:31:32'),(573,7902,40920,30305,3,573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1541672.09,NULL,NULL,1,'2023-08-21 16:59:00','2023-08-24 13:32:42','2023-08-24 13:32:42'),(574,7902,40920,30306,3,574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1988289.38,NULL,NULL,1,'2023-08-21 16:59:00','2023-08-24 13:33:06','2023-08-24 13:33:06'),(575,7902,40920,30307,3,575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3248022.63,NULL,NULL,1,'2023-08-21 16:59:00','2023-08-24 13:33:49','2023-08-24 13:33:49'),(576,7902,40920,30311,3,576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1979259.08,NULL,NULL,1,'2023-08-21 16:59:00','2023-08-24 13:34:18','2023-08-24 13:34:18'),(577,7902,40920,30312,3,577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1798812.51,NULL,NULL,1,'2023-08-21 16:59:00','2023-08-24 13:34:41','2023-08-24 13:34:41'),(578,7902,40920,30313,3,578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2788556.44,NULL,NULL,1,'2023-08-21 16:59:00','2023-08-24 13:35:08','2023-08-24 13:35:08'),(579,7902,40920,30314,3,579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2538146.13,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:35:33','2023-08-24 13:35:33'),(580,7902,40920,30315,3,580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3614872.67,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:35:58','2023-08-24 13:35:58'),(581,7902,40920,30316,3,581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3661080.70,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:36:26','2023-08-24 13:36:26'),(582,7902,40920,30302,2,582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1549407.01,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:27:04','2023-08-24 13:27:04'),(583,7902,40920,30303,2,583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2154833.28,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:27:33','2023-08-24 13:27:33'),(584,7902,40920,30304,2,584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2300524.70,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:28:47','2023-08-24 13:28:47'),(585,7902,40920,30305,2,585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2463706.69,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:29:44','2023-08-24 13:29:44'),(586,7902,40920,30306,2,586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2399143.29,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:29:09','2023-08-24 13:29:09'),(587,7902,40920,30307,2,587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2146020.05,NULL,NULL,1,'2023-08-21 16:59:01','2023-08-24 13:28:25','2023-08-24 13:28:25'),(588,7902,40920,30311,2,588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2502032.37,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-24 13:28:02','2023-08-24 13:28:02'),(589,7902,40920,30312,2,589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2359620.26,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-24 13:26:39','2023-08-24 13:26:39');
INSERT INTO `balance_libro` VALUES (590,7902,40920,30313,2,590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3236253.09,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-24 13:26:10','2023-08-24 13:26:10'),(591,7902,40920,30314,2,591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3531058.77,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-24 13:25:23','2023-08-24 13:25:23'),(592,7902,40920,30315,2,592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4191126.21,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-24 13:24:50','2023-08-24 13:24:50'),(593,7902,40920,30316,2,593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4454797.71,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-24 13:24:26','2023-08-24 13:24:26'),(594,7902,40920,30302,1,594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',27084.13,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-21 16:59:02',NULL),(595,7902,40920,30303,1,595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',60456.21,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-21 16:59:02',NULL),(596,7902,40920,30304,1,596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',124407.48,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-21 16:59:02',NULL),(597,7902,40920,30305,1,597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',140994.92,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-21 16:59:02',NULL),(598,7902,40920,30306,1,598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',147519.62,NULL,NULL,1,'2023-08-21 16:59:02','2023-08-21 16:59:03',NULL),(599,7902,40920,30307,1,599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',260447.86,NULL,NULL,1,'2023-08-21 16:59:03','2023-08-21 16:59:03',NULL),(600,7902,40920,30311,1,600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',260426.04,NULL,NULL,1,'2023-08-21 16:59:03','2023-08-21 16:59:03',NULL),(601,7902,40920,30312,1,601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',123434.79,NULL,NULL,1,'2023-08-21 16:59:03','2023-08-21 16:59:03',NULL),(602,7902,40920,30313,1,602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',226274.75,NULL,NULL,1,'2023-08-21 16:59:03','2023-08-21 16:59:03',NULL),(603,7902,40920,30314,1,603,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',166514.85,NULL,NULL,1,'2023-08-21 16:59:03','2023-08-21 16:59:03',NULL),(604,7902,40920,30315,1,604,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',193600.01,NULL,NULL,1,'2023-08-21 16:59:03','2023-08-21 16:59:03',NULL),(605,7902,40920,30316,1,605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',223997.15,NULL,NULL,1,'2023-08-21 16:59:03','2023-08-21 16:59:03',NULL),(606,7902,40920,30302,16,606,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',43209.70,NULL,NULL,1,'2023-08-21 16:59:03','2023-08-28 10:07:57','2023-08-28 10:07:57'),(607,7902,40920,30304,16,607,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',61233.87,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:27:21','2023-08-26 10:27:21'),(608,7902,40920,30305,16,608,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',61031.58,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:28:34','2023-08-26 10:28:34');
INSERT INTO `balance_libro` VALUES (609,7902,40920,30306,16,609,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',91745.40,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:29:10','2023-08-26 10:29:10'),(610,7902,40920,30307,16,610,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',127299.60,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:29:48','2023-08-26 10:29:48'),(611,7902,40920,30311,16,611,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',114136.31,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:30:35','2023-08-26 10:30:35'),(612,7902,40920,30312,16,612,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',147053.04,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:31:03','2023-08-26 10:31:03'),(613,7902,40920,30313,16,613,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',188088.18,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:34:22','2023-08-26 10:34:22'),(614,7902,40920,30314,16,614,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',273931.83,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:35:20','2023-08-26 10:35:20'),(615,7902,40920,30315,16,615,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-18','2022-05-18',369299.91,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:35:55','2023-08-26 10:35:55'),(616,7902,40920,30316,16,616,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',467086.14,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:36:33','2023-08-26 10:36:33'),(617,7902,40920,30316,16,617,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',539620.28,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-26 10:37:51','2023-08-26 10:37:51'),(618,7902,40920,30302,21,618,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',9894.63,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-24 19:21:04','2023-08-24 19:21:04'),(619,7902,40920,30305,21,619,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',11495.45,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-24 19:21:45','2023-08-24 19:21:45'),(620,7902,40920,30306,21,620,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',13895.45,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-24 19:22:14','2023-08-24 19:22:14'),(621,7902,40920,30307,21,621,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',10659.84,NULL,NULL,1,'2023-08-21 16:59:04','2023-08-24 19:22:34','2023-08-24 19:22:34'),(622,7902,40920,30311,21,622,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',16882.80,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-24 19:22:55','2023-08-24 19:22:55'),(623,7902,40920,30313,21,623,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',17973.63,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-24 19:23:15','2023-08-24 19:23:15'),(624,7902,40920,30314,21,624,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',15423.30,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-24 19:23:39','2023-08-24 19:23:39'),(625,7902,40920,30315,21,625,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',15302.39,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-24 19:24:17','2023-08-24 19:24:17'),(626,7902,40920,30316,21,626,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',7560.08,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-24 19:24:40','2023-08-24 19:24:40');
INSERT INTO `balance_libro` VALUES (627,7902,40920,30302,15,627,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',946821.77,NULL,NULL,1,'2023-08-21 16:59:05','2023-09-05 10:51:48','2023-09-05 10:51:48'),(628,7902,40920,30303,15,628,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',912278.18,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-21 16:59:05',NULL),(629,7902,40920,30304,15,629,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',860964.44,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-21 16:59:05',NULL),(630,7902,40920,30305,15,630,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',707102.29,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-25 16:32:01','2023-08-25 16:32:01'),(631,7902,40920,30306,15,631,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',678207.94,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-21 16:59:05',NULL),(632,7902,40920,30307,15,632,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',703339.66,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-25 16:34:04','2023-08-25 16:34:04'),(633,7902,40920,30311,15,633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',740045.86,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-21 16:59:05',NULL),(634,7902,40920,30312,15,634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',690176.10,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-21 16:59:05',NULL),(635,7902,40920,30313,15,635,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',842895.33,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-21 16:59:05',NULL),(636,7902,40920,30314,15,636,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',806457.13,NULL,NULL,1,'2023-08-21 16:59:05','2023-08-21 16:59:06',NULL),(637,7902,40920,30315,15,637,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',941949.54,NULL,NULL,1,'2023-08-21 16:59:06','2023-08-21 16:59:06',NULL),(638,7902,40920,30316,15,638,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',982182.02,NULL,NULL,1,'2023-08-21 16:59:06','2023-08-21 16:59:06',NULL),(639,7902,40920,30316,2,639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4454797.71,NULL,NULL,1,'2023-08-24 13:24:26','2023-09-05 10:44:41','2023-09-05 10:44:41'),(640,7902,40920,30315,2,640,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4191126.21,NULL,NULL,1,'2023-08-24 13:24:50','2023-09-05 10:43:43','2023-09-05 10:43:43'),(641,7902,40920,30314,2,641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3531058.77,NULL,NULL,1,'2023-08-24 13:25:23','2023-09-05 10:42:27','2023-09-05 10:42:27'),(642,7902,40920,30313,2,642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3236253.09,NULL,NULL,1,'2023-08-24 13:26:10','2023-09-05 10:40:01','2023-09-05 10:40:01'),(643,7902,40920,30312,2,643,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2359620.26,NULL,NULL,1,'2023-08-24 13:26:39','2023-09-05 10:38:24','2023-09-05 10:38:24'),(644,7902,40920,30302,2,644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1549407.01,NULL,NULL,1,'2023-08-24 13:27:04','2023-09-05 10:14:00','2023-09-05 10:14:00'),(645,7902,40920,30303,2,645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2154833.28,NULL,NULL,1,'2023-08-24 13:27:33','2023-09-05 10:15:56','2023-09-05 10:15:56');
INSERT INTO `balance_libro` VALUES (646,7902,40920,30311,2,646,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2502032.37,NULL,NULL,1,'2023-08-24 13:28:02','2023-09-05 10:35:07','2023-09-05 10:35:07'),(647,7902,40920,30307,2,647,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2146020.05,NULL,NULL,1,'2023-08-24 13:28:25','2023-09-05 10:33:28','2023-09-05 10:33:28'),(648,7902,40920,30304,2,648,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2300524.70,NULL,NULL,1,'2023-08-24 13:28:47','2023-09-05 10:19:50','2023-09-05 10:19:50'),(649,7902,40920,30306,2,649,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2399143.29,NULL,NULL,1,'2023-08-24 13:29:09','2023-09-05 10:32:14','2023-09-05 10:32:14'),(650,7902,40920,30305,2,650,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2463706.69,NULL,NULL,1,'2023-08-24 13:29:44','2023-09-05 10:29:29','2023-09-05 10:29:29'),(651,7902,40920,30302,3,651,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1657098.52,NULL,NULL,1,'2023-08-24 13:30:52','2023-08-26 12:12:11','2023-08-26 12:12:11'),(652,7902,40920,30303,3,652,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1255619.74,NULL,NULL,1,'2023-08-24 13:31:13','2023-08-26 11:58:34','2023-08-26 11:58:34'),(653,7902,40920,30304,3,653,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1629321.25,NULL,NULL,1,'2023-08-24 13:31:32','2023-08-26 12:13:36','2023-08-26 12:13:36'),(654,7902,40920,30305,3,654,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1541672.09,NULL,NULL,1,'2023-08-24 13:32:42','2023-08-26 12:14:19','2023-08-26 12:14:19'),(655,7902,40920,30306,3,655,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1988289.38,NULL,NULL,1,'2023-08-24 13:33:06','2023-08-26 12:14:56','2023-08-26 12:14:56'),(656,7902,40920,30307,3,656,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3248022.63,NULL,NULL,1,'2023-08-24 13:33:49','2023-08-26 12:09:12','2023-08-26 12:09:12'),(657,7902,40920,30311,3,657,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1979259.08,NULL,NULL,1,'2023-08-24 13:34:18','2023-08-26 12:15:54','2023-08-26 12:15:54'),(658,7902,40920,30312,3,658,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1798812.51,NULL,NULL,1,'2023-08-24 13:34:41','2023-08-26 12:16:34','2023-08-26 12:16:34'),(659,7902,40920,30313,3,659,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2788556.44,NULL,NULL,1,'2023-08-24 13:35:08','2023-08-26 12:17:07','2023-08-26 12:17:07'),(660,7902,40920,30314,3,660,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2538146.13,NULL,NULL,1,'2023-08-24 13:35:33','2023-08-26 12:17:48','2023-08-26 12:17:48'),(661,7902,40920,30315,3,661,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3614872.67,NULL,NULL,1,'2023-08-24 13:35:58','2023-08-26 12:18:39','2023-08-26 12:18:39'),(662,7902,40920,30316,3,662,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3661080.70,NULL,NULL,1,'2023-08-24 13:36:26','2023-08-26 11:59:32','2023-08-26 11:59:32'),(675,7902,40920,30302,5,675,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1191158.57,NULL,NULL,1,'2023-08-24 19:12:08','2023-08-28 10:44:27','2023-08-28 10:44:27');
INSERT INTO `balance_libro` VALUES (676,7902,40920,30303,5,676,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1201289.70,NULL,NULL,1,'2023-08-24 19:12:09','2023-08-28 10:10:53','2023-08-28 10:10:53'),(677,7902,40920,30304,5,677,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',993608.72,NULL,NULL,1,'2023-08-24 19:12:09','2023-08-28 10:12:35','2023-08-28 10:12:35'),(678,7902,40920,30305,5,678,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1168352.27,NULL,NULL,1,'2023-08-24 19:12:09','2023-08-28 10:14:36','2023-08-28 10:14:36'),(679,7902,40920,30306,5,679,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1600193.29,NULL,NULL,1,'2023-08-24 19:12:09','2023-09-04 12:26:47','2023-09-04 12:26:47'),(680,7902,40920,30307,5,680,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1070520.31,NULL,NULL,1,'2023-08-24 19:12:09','2023-08-25 15:27:04','2023-08-25 15:27:04'),(681,7902,40920,30311,5,681,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1713358.48,NULL,NULL,1,'2023-08-24 19:12:09','2023-08-25 15:28:18','2023-08-25 15:28:18'),(682,7902,40920,30312,5,682,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',817213.08,NULL,NULL,1,'2023-08-24 19:12:10','2023-08-28 09:21:29','2023-08-28 09:21:29'),(683,7902,40920,30313,5,683,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1995348.18,NULL,NULL,1,'2023-08-24 19:12:10','2023-08-25 15:29:15','2023-08-25 15:29:15'),(684,7902,40920,30314,5,684,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1231912.72,NULL,NULL,1,'2023-08-24 19:12:10','2023-08-28 09:23:18','2023-08-28 09:23:18'),(685,7902,40920,30315,5,685,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1683938.57,NULL,NULL,1,'2023-08-24 19:12:10','2023-08-28 17:35:14','2023-08-28 17:35:14'),(686,7902,40920,30316,5,686,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1985708.44,NULL,NULL,1,'2023-08-24 19:12:10','2023-08-25 15:31:23','2023-08-25 15:31:23'),(687,7902,40920,30302,21,687,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',9894.63,NULL,NULL,1,'2023-08-24 19:21:04','2023-08-26 10:06:53','2023-08-26 10:06:53'),(688,7902,40920,30305,21,688,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',11495.45,NULL,NULL,1,'2023-08-24 19:21:45','2023-08-26 10:08:00','2023-08-26 10:08:00'),(689,7902,40920,30306,21,689,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',13895.45,NULL,NULL,1,'2023-08-24 19:22:14','2023-08-24 19:22:14',NULL),(690,7902,40920,30307,21,690,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',10659.84,NULL,NULL,1,'2023-08-24 19:22:34','2023-08-24 19:22:34',NULL),(691,7902,40920,30311,21,691,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',16882.80,NULL,NULL,1,'2023-08-24 19:22:55','2023-08-24 19:22:55',NULL),(692,7902,40920,30313,21,692,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',17973.63,NULL,NULL,1,'2023-08-24 19:23:15','2023-08-24 19:23:15',NULL),(693,7902,40920,30314,21,693,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',15423.30,NULL,NULL,1,'2023-08-24 19:23:39','2023-08-24 19:23:39',NULL),(694,7902,40920,30315,21,694,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',15302.39,NULL,NULL,1,'2023-08-24 19:24:17','2023-08-24 19:24:17',NULL);
INSERT INTO `balance_libro` VALUES (695,7902,40920,30316,21,695,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',7560.08,NULL,NULL,1,'2023-08-24 19:24:40','2023-08-24 19:24:40',NULL),(696,7902,40920,30302,5,696,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9089.48,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:02:36','2023-08-25 15:02:36'),(697,7902,40920,30303,5,697,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',21227.45,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:02:26','2023-08-25 15:02:26'),(698,7902,40920,30304,5,698,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',44896.31,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:02:16','2023-08-25 15:02:16'),(699,7902,40920,30305,5,699,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',50267.36,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:02:05','2023-08-25 15:02:05'),(700,7902,40920,30306,5,700,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',52711.92,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:01:53','2023-08-25 15:01:53'),(701,7902,40920,30307,5,701,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',96174.12,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:00:53','2023-08-25 15:00:53'),(702,7902,40920,30311,5,702,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',94051.97,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:00:27','2023-08-25 15:00:27'),(703,7902,40920,30312,5,703,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',43756.82,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:00:17','2023-08-25 15:00:17'),(704,7902,40920,30313,5,704,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',81318.28,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 15:00:06','2023-08-25 15:00:06'),(705,7902,40920,30314,5,705,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',59777.60,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 14:59:54','2023-08-25 14:59:54'),(706,7902,40920,30315,5,706,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',70154.51,NULL,NULL,1,'2023-08-25 14:59:09','2023-08-25 14:59:46','2023-08-25 14:59:46'),(707,7902,40920,30315,1,707,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',70154.51,NULL,NULL,1,'2023-08-25 14:59:46','2023-08-25 15:01:43','2023-08-25 15:01:43'),(708,7902,40920,30314,1,708,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',59777.60,NULL,NULL,1,'2023-08-25 14:59:54','2023-08-25 15:01:33','2023-08-25 15:01:33'),(709,7902,40920,30313,1,709,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',81318.28,NULL,NULL,1,'2023-08-25 15:00:06','2023-08-25 15:01:20','2023-08-25 15:01:20'),(710,7902,40920,30312,1,710,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',43756.82,NULL,NULL,1,'2023-08-25 15:00:17','2023-08-25 15:01:10','2023-08-25 15:01:10'),(711,7902,40920,30311,1,711,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',94051.97,NULL,NULL,1,'2023-08-25 15:00:27','2023-08-25 15:01:02','2023-08-25 15:01:02'),(712,7902,40920,30307,10,712,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',96174.12,NULL,NULL,1,'2023-08-25 15:00:53','2023-08-25 15:00:53',NULL),(713,7902,40920,30311,10,713,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',94051.97,NULL,NULL,1,'2023-08-25 15:01:02','2023-08-25 15:01:02',NULL);
INSERT INTO `balance_libro` VALUES (714,7902,40920,30312,10,714,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',43756.82,NULL,NULL,1,'2023-08-25 15:01:10','2023-08-25 15:01:10',NULL),(715,7902,40920,30313,10,715,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',81318.28,NULL,NULL,1,'2023-08-25 15:01:20','2023-08-25 15:01:20',NULL),(716,7902,40920,30314,10,716,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',59777.60,NULL,NULL,1,'2023-08-25 15:01:33','2023-08-25 15:01:33',NULL),(717,7902,40920,30315,10,717,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',70154.51,NULL,NULL,1,'2023-08-25 15:01:43','2023-08-25 15:01:43',NULL),(718,7902,40920,30306,10,718,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',52711.92,NULL,NULL,1,'2023-08-25 15:01:53','2023-08-25 15:01:53',NULL),(719,7902,40920,30305,10,719,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',50267.36,NULL,NULL,1,'2023-08-25 15:02:05','2023-08-25 15:02:05',NULL),(720,7902,40920,30304,10,720,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',44896.31,NULL,NULL,1,'2023-08-25 15:02:16','2023-08-25 15:02:16',NULL),(721,7902,40920,30303,10,721,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',21227.45,NULL,NULL,1,'2023-08-25 15:02:26','2023-08-25 15:02:26',NULL),(722,7902,40920,30302,10,722,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9089.48,NULL,NULL,1,'2023-08-25 15:02:36','2023-08-25 15:02:36',NULL),(723,7902,40920,30307,5,723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1070520.31,NULL,NULL,1,'2023-08-25 15:27:04','2023-08-28 09:14:18','2023-08-28 09:14:18'),(724,7902,40920,30311,5,724,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1713358.48,NULL,NULL,1,'2023-08-25 15:28:18','2023-08-28 09:16:09','2023-08-28 09:16:09'),(725,7902,40920,30313,5,725,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1995348.18,NULL,NULL,1,'2023-08-25 15:29:15','2023-08-28 09:17:45','2023-08-28 09:17:45'),(726,7902,40920,30316,5,726,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1985708.44,NULL,NULL,1,'2023-08-25 15:31:23','2023-08-28 17:53:40','2023-08-28 17:53:40'),(727,7902,40920,30305,15,727,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',775516.13,NULL,NULL,1,'2023-08-25 16:32:01','2023-08-25 16:32:01',NULL),(728,7902,40920,30307,15,728,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',751026.07,NULL,NULL,1,'2023-08-25 16:34:04','2023-08-25 16:34:04',NULL),(729,7902,40920,30302,21,729,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',5761.17,NULL,NULL,1,'2023-08-26 10:06:53','2023-08-26 10:06:53',NULL),(730,7902,40920,30305,21,730,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',11495.03,NULL,NULL,1,'2023-08-26 10:08:00','2023-08-26 10:08:00',NULL),(731,7902,40920,30303,16,731,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',61233.87,NULL,NULL,1,'2023-08-26 10:27:21','2023-09-05 12:26:11','2023-09-05 12:26:11'),(732,7902,40920,30304,16,732,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',61031.58,NULL,NULL,1,'2023-08-26 10:28:34','2023-08-26 10:28:34',NULL),(733,7902,40920,30305,16,733,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',91745.40,NULL,NULL,1,'2023-08-26 10:29:10','2023-09-05 12:29:17','2023-09-05 12:29:17');
INSERT INTO `balance_libro` VALUES (734,7902,40920,30306,16,734,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',127299.60,NULL,NULL,1,'2023-08-26 10:29:48','2023-09-05 12:30:19','2023-09-05 12:30:19'),(735,7902,40920,30307,16,735,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',114136.31,NULL,NULL,1,'2023-08-26 10:30:35','2023-09-05 12:31:21','2023-09-05 12:31:21'),(736,7902,40920,30312,16,736,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',147053.04,NULL,NULL,1,'2023-08-26 10:31:03','2023-08-28 17:20:19','2023-08-28 17:20:19'),(737,7902,40920,30312,16,737,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',188088.18,NULL,NULL,1,'2023-08-26 10:34:22','2023-08-28 17:23:11','2023-08-28 17:23:11'),(738,7902,40920,30313,16,738,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',273931.83,NULL,NULL,1,'2023-08-26 10:35:20','2023-09-05 12:35:44','2023-09-05 12:35:44'),(739,7902,40920,30315,16,739,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',369299.91,NULL,NULL,1,'2023-08-26 10:35:55','2023-08-26 10:36:56','2023-08-26 10:36:56'),(740,7902,40920,30316,16,740,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',467086.14,NULL,NULL,1,'2023-08-26 10:36:33','2023-08-26 10:37:07','2023-08-26 10:37:07'),(741,7902,40920,30314,16,741,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',369299.91,NULL,NULL,1,'2023-08-26 10:36:56','2023-09-05 12:36:52','2023-09-05 12:36:52'),(742,7902,40920,30315,16,742,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',467086.14,NULL,NULL,1,'2023-08-26 10:37:07','2023-09-05 12:37:35','2023-09-05 12:37:35'),(743,7902,40920,30316,16,743,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',539620.28,NULL,NULL,1,'2023-08-26 10:37:51','2023-08-28 17:52:47','2023-08-28 17:52:47'),(744,7902,40920,30304,10,744,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10692.46,NULL,NULL,1,'2023-08-26 11:25:15','2023-08-26 11:25:15',NULL),(745,7902,40920,30303,3,745,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1255619.74,NULL,NULL,1,'2023-08-26 11:58:34','2023-08-26 12:26:59','2023-08-26 12:26:59'),(746,7902,40920,30316,3,746,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3661080.70,NULL,NULL,1,'2023-08-26 11:59:32','2023-09-04 14:05:51','2023-09-04 14:05:51'),(747,7902,40920,30307,3,747,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3248022.63,NULL,NULL,1,'2023-08-26 12:09:12','2023-08-26 12:20:50','2023-08-26 12:20:50'),(748,7902,40920,30302,3,748,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1657098.52,NULL,NULL,1,'2023-08-26 12:12:11','2023-09-04 13:49:15','2023-09-04 13:49:15'),(749,7902,40920,30304,3,749,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1629321.25,NULL,NULL,1,'2023-08-26 12:13:36','2023-09-04 13:53:34','2023-09-04 13:53:34'),(750,7902,40920,30305,3,750,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1541672.09,NULL,NULL,1,'2023-08-26 12:14:19','2023-09-04 13:55:14','2023-09-04 13:55:14'),(751,7902,40920,30306,3,751,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1988289.38,NULL,NULL,1,'2023-08-26 12:14:56','2023-08-26 12:26:03','2023-08-26 12:26:03');
INSERT INTO `balance_libro` VALUES (752,7902,40920,30311,3,752,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1979259.08,NULL,NULL,1,'2023-08-26 12:15:54','2023-09-04 14:00:29','2023-09-04 14:00:29'),(753,7902,40920,30312,3,753,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1798812.51,NULL,NULL,1,'2023-08-26 12:16:34','2023-09-04 14:01:23','2023-09-04 14:01:23'),(754,7902,40920,30313,3,754,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2788556.44,NULL,NULL,1,'2023-08-26 12:17:07','2023-09-04 14:02:21','2023-09-04 14:02:21'),(755,7902,40920,30314,3,755,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2538146.13,NULL,NULL,1,'2023-08-26 12:17:48','2023-09-04 14:03:23','2023-09-04 14:03:23'),(756,7902,40920,30315,3,756,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3614872.67,NULL,NULL,1,'2023-08-26 12:18:39','2023-09-04 14:04:34','2023-09-04 14:04:34'),(757,7902,40920,30307,3,757,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3248022.63,NULL,NULL,1,'2023-08-26 12:20:50','2023-09-04 13:59:27','2023-09-04 13:59:27'),(758,7902,40920,30306,3,758,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1988289.38,NULL,NULL,1,'2023-08-26 12:26:03','2023-09-04 13:58:24','2023-09-04 13:58:24'),(759,7902,40920,30303,3,759,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1255619.74,NULL,NULL,1,'2023-08-26 12:26:59','2023-09-04 13:51:09','2023-09-04 13:51:09'),(760,7902,40920,30307,5,760,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1143306.25,NULL,NULL,1,'2023-08-28 09:14:18','2023-08-28 17:24:01','2023-08-28 17:24:01'),(761,7902,40920,30311,5,761,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1789575.87,NULL,NULL,1,'2023-08-28 09:16:09','2023-08-28 10:17:31','2023-08-28 10:17:31'),(762,7902,40920,30313,5,762,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2077434.27,NULL,NULL,1,'2023-08-28 09:17:45','2023-08-28 09:19:55','2023-08-28 09:19:55'),(763,7902,40920,30313,5,763,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2098002.47,NULL,NULL,1,'2023-08-28 09:19:55','2023-08-28 17:31:53','2023-08-28 17:31:53'),(764,7902,40920,30312,5,764,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',899299.17,NULL,NULL,1,'2023-08-28 09:21:29','2023-08-28 10:20:09','2023-08-28 10:20:09'),(765,7902,40920,30314,5,765,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1356327.87,NULL,NULL,1,'2023-08-28 09:23:18','2023-08-28 17:34:04','2023-08-28 17:34:04'),(766,7902,40920,30302,16,766,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',43209.70,NULL,NULL,1,'2023-08-28 10:07:57','2023-09-05 11:46:00','2023-09-05 11:46:00'),(767,7902,40920,30303,5,767,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1212636.71,NULL,NULL,1,'2023-08-28 10:10:53','2023-09-04 12:23:39','2023-09-04 12:23:39'),(768,7902,40920,30304,5,768,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1036302.80,NULL,NULL,1,'2023-08-28 10:12:35','2023-09-04 12:25:17','2023-09-04 12:25:17'),(769,7902,40920,30305,5,769,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1221920.21,NULL,NULL,1,'2023-08-28 10:14:36','2023-09-04 12:26:00','2023-09-04 12:26:00');
INSERT INTO `balance_libro` VALUES (770,7902,40920,30311,5,770,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1819371.30,NULL,NULL,1,'2023-08-28 10:17:31','2023-08-28 17:13:43','2023-08-28 17:13:43'),(771,7902,40920,30312,5,771,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',947218.83,NULL,NULL,1,'2023-08-28 10:20:09','2023-08-28 11:51:59','2023-08-28 11:51:59'),(772,7902,40920,30302,5,772,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1211916.70,NULL,NULL,1,'2023-08-28 10:44:27','2023-09-04 12:20:00','2023-09-04 12:20:00'),(773,7902,40920,30312,5,773,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',939698.51,NULL,NULL,1,'2023-08-28 11:51:59','2023-08-28 17:30:22','2023-08-28 17:30:22'),(774,7902,40920,30311,5,774,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1821786.04,NULL,NULL,1,'2023-08-28 17:13:43','2023-08-28 17:28:50','2023-08-28 17:28:50'),(775,7902,40920,30311,16,775,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',147053.04,NULL,NULL,1,'2023-08-28 17:20:19','2023-09-05 12:32:59','2023-09-05 12:32:59'),(776,7902,40920,30312,16,776,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',188088.18,NULL,NULL,1,'2023-08-28 17:23:11','2023-09-05 12:34:47','2023-09-05 12:34:47'),(777,7902,40920,30307,5,777,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1177931.16,NULL,NULL,1,'2023-08-28 17:24:01','2023-09-05 17:30:46','2023-09-05 17:30:46'),(778,7902,40920,30311,5,778,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1836818.98,NULL,NULL,1,'2023-08-28 17:28:50','2023-09-05 17:30:12','2023-09-05 17:30:12'),(779,7902,40920,30312,5,779,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',997084.30,NULL,NULL,1,'2023-08-28 17:30:22','2023-09-05 17:29:42','2023-09-05 17:29:42'),(780,7902,40920,30313,5,780,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2217536.02,NULL,NULL,1,'2023-08-28 17:31:53','2023-09-05 17:29:15','2023-09-05 17:29:15'),(781,7902,40920,30314,5,781,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1489869.85,NULL,NULL,1,'2023-08-28 17:34:04','2023-09-05 17:28:33','2023-09-05 17:28:33'),(782,7902,40920,30315,5,782,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1805044.12,NULL,NULL,1,'2023-08-28 17:35:14','2023-09-04 12:27:51','2023-09-04 12:27:51'),(783,7902,40920,30302,16,783,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',10395.54,'ajuste percep iibb',NULL,1,'2023-08-28 17:39:28','2023-08-28 17:39:28',NULL),(784,7902,40920,30316,16,784,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',539620.28,NULL,NULL,1,'2023-08-28 17:52:47','2023-09-05 12:38:44','2023-09-05 12:38:44'),(785,7902,40920,30316,5,785,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2166266.72,NULL,NULL,1,'2023-08-28 17:53:40','2023-08-28 17:59:28','2023-08-28 17:59:28'),(786,7902,40920,30316,5,786,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2321689.22,NULL,NULL,1,'2023-08-28 17:59:28','2023-09-05 12:54:23','2023-09-05 12:54:23'),(787,7902,40920,30302,12,787,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',13078226.67,'Apertura Ejercicio 2022',NULL,1,'2023-08-28 18:46:58','2023-09-07 17:27:21','2023-09-07 17:27:21');
INSERT INTO `balance_libro` VALUES (788,7902,40920,30316,11,788,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',18965777.16,'AJUSTE CAJA',NULL,1,'2023-08-28 18:48:44','2023-09-04 10:47:04','2023-09-04 10:47:04'),(789,7902,40920,30316,19,789,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',485000.00,'PAGO DEUDA SOCIOS',NULL,1,'2023-08-28 18:52:00','2023-08-28 18:52:00',NULL),(790,7902,40920,30316,11,790,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1566820.85,'AJUSTE MATERIAS PRIMAS',NULL,1,'2023-09-04 10:30:52','2023-09-04 10:35:11','2023-09-04 10:35:11'),(791,7902,40920,30316,18,791,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',12118844.21,'COSTO DE MERCADERIA',NULL,1,'2023-09-04 10:34:46','2023-09-05 16:49:59','2023-09-05 16:49:59'),(792,7902,40920,30301,11,792,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1566820.85,'AJUSTE MATERIAS PRIMAS',NULL,1,'2023-09-04 10:35:11','2023-09-04 11:03:41','2023-09-04 11:03:41'),(793,7902,40920,30316,11,793,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',25493012.97,'AJUSTE CAJA',NULL,1,'2023-09-04 10:47:04','2023-09-05 16:36:56','2023-09-05 16:36:56'),(794,7902,40920,30302,11,794,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1566820.85,'AJUSTE MATERIAS PRIMAS',NULL,1,'2023-09-04 11:03:41','2023-09-04 14:47:41','2023-09-04 14:47:41'),(795,7902,40920,30316,21,795,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',44304.75,'PAGO SINDICATO',NULL,1,'2023-09-04 11:29:11','2023-09-04 11:29:11',NULL),(796,7902,40920,30302,21,796,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',9894.63,'PAGO IIBB',NULL,1,'2023-09-04 11:34:58','2023-09-04 11:34:58',NULL),(797,7902,40920,30302,5,797,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1241404.98,NULL,NULL,1,'2023-09-04 12:20:00','2023-09-05 17:33:34','2023-09-05 17:33:34'),(798,7902,40920,30303,5,798,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1258263.05,NULL,NULL,1,'2023-09-04 12:23:39','2023-09-05 17:33:01','2023-09-05 17:33:01'),(799,7902,40920,30304,5,799,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1090345.67,NULL,NULL,1,'2023-09-04 12:25:17','2023-09-05 17:32:30','2023-09-05 17:32:30'),(800,7902,40920,30305,5,800,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1284389.38,NULL,NULL,1,'2023-09-04 12:26:00','2023-09-05 17:31:56','2023-09-05 17:31:56'),(801,7902,40920,30306,5,801,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1668136.80,NULL,NULL,1,'2023-09-04 12:26:47','2023-09-05 17:31:19','2023-09-05 17:31:19'),(802,7902,40920,30315,5,802,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1938741.45,NULL,NULL,1,'2023-09-04 12:27:51','2023-09-05 17:27:56','2023-09-05 17:27:56'),(803,7902,40920,30302,3,803,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1654951.38,NULL,NULL,1,'2023-09-04 13:49:15','2023-09-04 13:49:15',NULL),(804,7902,40920,30303,3,804,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1252985.36,NULL,NULL,1,'2023-09-04 13:51:09','2023-09-04 13:51:09',NULL),(805,7902,40920,30304,3,805,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1626498.99,NULL,NULL,1,'2023-09-04 13:53:34','2023-09-04 13:53:34',NULL);
INSERT INTO `balance_libro` VALUES (806,7902,40920,30305,3,806,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1537354.58,NULL,NULL,1,'2023-09-04 13:55:14','2023-09-04 13:55:14',NULL),(807,7902,40920,30306,3,807,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1983858.16,NULL,NULL,1,'2023-09-04 13:58:24','2023-09-04 13:58:24',NULL),(808,7902,40920,30307,3,808,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3242646.42,NULL,NULL,1,'2023-09-04 13:59:27','2023-09-04 13:59:27',NULL),(809,7902,40920,30311,3,809,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1976182.41,NULL,NULL,1,'2023-09-04 14:00:29','2023-09-04 14:00:29',NULL),(810,7902,40920,30312,3,810,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1796917.57,NULL,NULL,1,'2023-09-04 14:01:23','2023-09-04 14:01:23',NULL),(811,7902,40920,30313,3,811,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2765839.62,NULL,NULL,1,'2023-09-04 14:02:21','2023-09-04 14:02:21',NULL),(812,7902,40920,30314,3,812,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2530139.99,NULL,NULL,1,'2023-09-04 14:03:23','2023-09-05 17:22:34','2023-09-05 17:22:34'),(813,7902,40920,30315,3,813,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3620947.15,NULL,NULL,1,'2023-09-04 14:04:34','2023-09-05 17:21:42','2023-09-05 17:21:42'),(814,7902,40920,30316,3,814,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3667423.42,NULL,NULL,1,'2023-09-04 14:05:51','2023-09-04 14:46:27','2023-09-04 14:46:27'),(815,7902,40920,30316,3,815,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3667423.42,NULL,NULL,1,'2023-09-04 14:46:27','2023-09-05 17:20:56','2023-09-05 17:20:56'),(816,7902,40920,30302,11,816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',3530661.02,'AJUSTE MATERIAS PRIMAS',NULL,1,'2023-09-04 14:47:41','2023-09-05 09:31:58','2023-09-05 09:31:58'),(817,7902,40920,30302,2,817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1549406.89,NULL,NULL,1,'2023-09-05 10:14:00','2023-09-05 10:14:00',NULL),(818,7902,40920,30303,2,818,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2154833.06,NULL,NULL,1,'2023-09-05 10:15:56','2023-09-05 10:15:56',NULL),(819,7902,40920,30304,2,819,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2300524.30,NULL,NULL,1,'2023-09-05 10:19:50','2023-09-05 10:19:50',NULL),(820,7902,40920,30305,2,820,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2463706.30,NULL,NULL,1,'2023-09-05 10:29:29','2023-09-05 10:29:29',NULL),(821,7902,40920,30306,2,821,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2399143.06,NULL,NULL,1,'2023-09-05 10:32:14','2023-09-05 10:32:14',NULL),(822,7902,40920,30307,2,822,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2146020.02,NULL,NULL,1,'2023-09-05 10:33:28','2023-09-05 10:33:28',NULL),(823,7902,40920,30311,2,823,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2502032.12,NULL,NULL,1,'2023-09-05 10:35:07','2023-09-05 10:35:07',NULL),(824,7902,40920,30312,2,824,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2359620.16,NULL,NULL,1,'2023-09-05 10:38:24','2023-09-05 10:38:24',NULL);
INSERT INTO `balance_libro` VALUES (825,7902,40920,30313,2,825,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3236253.02,NULL,NULL,1,'2023-09-05 10:40:01','2023-09-05 10:40:01',NULL),(826,7902,40920,30314,2,826,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3531058.93,NULL,NULL,1,'2023-09-05 10:42:27','2023-09-05 10:42:27',NULL),(827,7902,40920,30315,2,827,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4191126.74,NULL,NULL,1,'2023-09-05 10:43:43','2023-09-05 10:45:48','2023-09-05 10:45:48'),(828,7902,40920,30316,2,828,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4454797.73,NULL,NULL,1,'2023-09-05 10:44:41','2023-09-05 10:46:15','2023-09-05 10:46:15'),(829,7902,40920,30315,2,829,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4191126.58,NULL,NULL,1,'2023-09-05 10:45:48','2023-09-05 10:45:48',NULL),(830,7902,40920,30316,2,830,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4454797.73,NULL,NULL,1,'2023-09-05 10:46:15','2023-09-05 10:46:15',NULL),(831,7902,40920,30302,15,831,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',946821.77,NULL,NULL,1,'2023-09-05 10:51:48','2023-09-05 10:51:48',NULL),(832,7902,40920,30302,16,832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',43209.70,NULL,NULL,1,'2023-09-05 11:46:00','2023-09-05 11:46:00',NULL),(833,7902,40920,30303,16,833,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',61233.87,NULL,NULL,1,'2023-09-05 12:26:11','2023-09-05 12:26:11',NULL),(834,7902,40920,30305,16,834,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',91745.40,NULL,NULL,1,'2023-09-05 12:29:17','2023-09-05 12:29:17',NULL),(835,7902,40920,30306,16,835,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',127299.60,NULL,NULL,1,'2023-09-05 12:30:19','2023-09-05 12:30:19',NULL),(836,7902,40920,30307,16,836,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',114136.31,NULL,NULL,1,'2023-09-05 12:31:21','2023-09-05 12:31:21',NULL),(837,7902,40920,30311,16,837,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',147053.04,NULL,NULL,1,'2023-09-05 12:32:59','2023-09-05 12:32:59',NULL),(838,7902,40920,30312,16,838,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',188091.18,NULL,NULL,1,'2023-09-05 12:34:47','2023-09-05 12:34:47',NULL),(839,7902,40920,30313,16,839,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',273931.83,NULL,NULL,1,'2023-09-05 12:35:44','2023-09-05 12:35:44',NULL),(840,7902,40920,30314,16,840,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',369299.91,NULL,NULL,1,'2023-09-05 12:36:52','2023-09-05 12:36:52',NULL),(841,7902,40920,30315,16,841,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',467086.14,NULL,NULL,1,'2023-09-05 12:37:35','2023-09-05 12:37:35',NULL),(842,7902,40920,30316,16,842,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',539620.28,NULL,NULL,1,'2023-09-05 12:38:44','2023-09-05 12:38:44',NULL),(843,7902,40920,30316,5,843,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2318526.23,NULL,NULL,1,'2023-09-05 12:54:23','2023-09-05 17:26:58','2023-09-05 17:26:58'),(844,7902,40920,30316,11,844,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',25102907.18,'AJUSTE CAJA',NULL,1,'2023-09-05 16:36:56','2023-09-05 16:41:48','2023-09-05 16:41:48');
INSERT INTO `balance_libro` VALUES (845,7902,40920,30316,11,845,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',25102907.18,'AJUSTE CAJA',NULL,1,'2023-09-05 16:41:48','2023-09-05 16:41:48',NULL),(846,7902,40920,30316,18,846,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',12158480.95,'COSTO DE MERCADERIA',NULL,1,'2023-09-05 16:49:59','2023-09-07 12:16:43','2023-09-07 12:16:43'),(847,7902,40920,30316,4,847,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',364910.25,'AMORTIZACION DEL EJERCICIO',NULL,1,'2023-09-05 16:59:38','2023-09-05 16:59:38',NULL),(848,7902,40920,30316,3,848,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3667423.42,NULL,NULL,1,'2023-09-05 17:20:56','2023-09-05 17:20:56',NULL),(849,7902,40920,30315,3,849,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3620947.15,NULL,NULL,1,'2023-09-05 17:21:42','2023-09-05 17:21:42',NULL),(850,7902,40920,30314,3,850,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2530139.99,NULL,NULL,1,'2023-09-05 17:22:34','2023-09-05 17:22:34',NULL),(851,7902,40920,30316,5,851,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2318526.23,NULL,NULL,1,'2023-09-05 17:26:58','2023-09-05 17:26:58',NULL),(852,7902,40920,30315,5,852,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1938741.45,NULL,NULL,1,'2023-09-05 17:27:56','2023-09-05 17:27:56',NULL),(853,7902,40920,30314,5,853,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1489869.85,NULL,NULL,1,'2023-09-05 17:28:33','2023-09-05 17:28:33',NULL),(854,7902,40920,30313,5,854,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2217536.02,NULL,NULL,1,'2023-09-05 17:29:15','2023-09-05 17:29:15',NULL),(855,7902,40920,30312,5,855,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',997084.30,NULL,NULL,1,'2023-09-05 17:29:42','2023-09-05 17:29:42',NULL),(856,7902,40920,30311,5,856,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1836818.98,NULL,NULL,1,'2023-09-05 17:30:12','2023-09-05 17:30:12',NULL),(857,7902,40920,30307,5,857,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1177931.16,NULL,NULL,1,'2023-09-05 17:30:46','2023-09-05 17:30:46',NULL),(858,7902,40920,30306,5,858,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1668136.80,NULL,NULL,1,'2023-09-05 17:31:19','2023-09-05 17:31:19',NULL),(859,7902,40920,30305,5,859,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1284389.38,NULL,NULL,1,'2023-09-05 17:31:56','2023-09-05 17:31:56',NULL),(860,7902,40920,30304,5,860,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1090345.67,NULL,NULL,1,'2023-09-05 17:32:30','2023-09-05 17:32:30',NULL),(861,7902,40920,30303,5,861,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1258263.05,NULL,NULL,1,'2023-09-05 17:33:01','2023-09-05 17:33:01',NULL),(862,7902,40920,30302,5,862,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1241404.98,NULL,NULL,1,'2023-09-05 17:33:34','2023-09-05 17:33:34',NULL),(863,7902,40920,30316,23,863,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',7162735.06,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-09-07 11:45:48','2023-09-07 11:45:50',NULL);
INSERT INTO `balance_libro` VALUES (864,7902,40920,30315,18,864,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',12158480.95,'COSTO DE MERCADERIA',NULL,1,'2023-09-07 12:16:43','2023-09-07 12:16:43',NULL),(865,7902,40920,30316,23,865,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',643818.47,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-09-07 12:17:38','2023-09-07 12:22:38','2023-09-07 12:22:38'),(866,7902,40920,30316,23,866,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2068588.71,'AXI B.USO',NULL,1,'2023-09-07 13:17:44','2023-09-07 13:17:44',NULL),(867,7902,40920,30316,23,867,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3878216.33,'AXI PNETO',NULL,1,'2023-09-07 13:19:15','2023-09-07 13:19:15',NULL),(868,7902,40920,30316,23,868,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4756724.48,'AXI CMV',NULL,1,'2023-09-07 13:20:59','2023-09-07 13:20:59',NULL),(869,7902,40920,30302,12,869,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',13078226.67,'Apertura Ejercicio 2022',NULL,1,'2023-09-07 17:27:21','2023-09-07 17:27:21',NULL),(870,7902,41171,31943,17,870,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3577315.91,'CIERRE 2022',NULL,1,'2023-11-05 10:24:56','2023-11-05 10:41:22','2023-11-05 10:41:22'),(871,7902,41171,31943,17,871,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3577315.91,'CIERRE 2022',NULL,1,'2023-11-05 10:41:22','2023-11-05 10:41:22',NULL),(872,7902,41171,31944,12,872,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',3468324.60,'SALDO INICIAL 22-23',NULL,1,'2023-11-05 10:49:33','2023-11-05 10:49:33',NULL),(873,7902,41171,31944,2,873,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',95000.00,'INNGRESOS MES DE AGOSTO',NULL,1,'2023-11-05 11:11:28','2023-11-05 11:11:28',NULL),(874,7902,41171,31945,2,874,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',71700.00,'INGRESOS SEPTIEMBRE',NULL,1,'2023-11-05 11:12:53','2023-12-27 12:04:03','2023-12-27 12:04:03'),(875,7902,41171,31946,2,875,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5000.00,'INGRESOS OCTUBRE',NULL,1,'2023-11-05 11:15:35','2023-11-05 11:15:35',NULL),(876,7902,41171,31947,2,876,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',106600.00,'INGRESOS NOVIEMBRE',NULL,1,'2023-11-05 11:17:10','2023-12-27 12:04:47','2023-12-27 12:04:47'),(877,7902,41171,31948,2,877,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',29450.00,'INGRESOS DICIEMBRE 22',NULL,1,'2023-11-05 11:21:03','2023-12-27 12:05:21','2023-12-27 12:05:21'),(878,7902,41171,31944,3,878,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',62523.30,'EGRESOS AGOSTO 22',NULL,1,'2023-11-05 11:37:19','2023-11-05 11:37:19',NULL),(879,7902,41171,31945,3,879,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',81322.10,'EGRESOS SEPTIEMBRE 22',NULL,1,'2023-11-05 11:39:57','2023-11-05 11:39:57',NULL),(880,7902,41171,31946,3,880,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',134847.11,'EGRESOS OCTUBRE 22',NULL,1,'2023-11-05 11:45:53','2023-12-27 12:10:12','2023-12-27 12:10:12'),(881,7902,41171,31947,3,881,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',225363.86,'EGRESOS NOVIEMBRE 22',NULL,1,'2023-11-05 11:49:37','2023-11-05 11:49:37',NULL);
INSERT INTO `balance_libro` VALUES (882,7902,41171,31947,19,882,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',119979.00,'COMPRA INSTALACIONES',NULL,1,'2023-11-05 11:51:30','2023-11-05 11:51:30',NULL),(883,7902,41171,31948,3,883,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',46890.00,'EGRESOS DICIEMBRE 22',NULL,1,'2023-11-05 11:54:00','2023-11-05 11:54:00',NULL),(884,7902,41171,31952,2,884,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',140000.00,'INGRESOS ENERO 23',NULL,1,'2023-11-05 11:55:38','2023-11-05 11:55:38',NULL),(885,7902,41171,31953,2,885,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8000.00,'INGRESOS FEBRERO 23',NULL,1,'2023-11-05 11:57:40','2023-12-27 12:00:47','2023-12-27 12:00:47'),(886,7902,41171,31954,2,886,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',90300.00,'INGRESOS MARZO 23',NULL,1,'2023-11-05 11:59:27','2023-12-27 12:05:51','2023-12-27 12:05:51'),(887,7902,41171,31955,2,887,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',20000.00,'INGRESOS ABRIL 23',NULL,1,'2023-11-05 12:00:31','2023-12-27 12:01:45','2023-12-27 12:01:45'),(888,7902,41171,31956,2,888,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',98650.00,'INGRESOS MAYO 23',NULL,1,'2023-11-05 12:06:06','2023-12-27 12:03:16','2023-12-27 12:03:16'),(889,7902,41171,31957,2,889,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',183500.00,'INGRESOS JUNIO 23',NULL,1,'2023-11-05 12:07:16','2023-11-05 12:07:16',NULL),(890,7902,41171,31958,2,890,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',75000.00,'INGRESOS JULIO 23',NULL,1,'2023-11-05 12:08:27','2023-12-27 12:06:38','2023-12-27 12:06:38'),(891,7902,41171,31952,3,891,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',173115.95,'EGRESOS ENERO 23',NULL,1,'2023-11-05 12:21:03','2023-11-05 12:21:03',NULL),(892,7902,41171,31953,3,892,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',69535.16,'EGRESOS FEBRERO 23',NULL,1,'2023-11-05 12:26:37','2023-11-05 12:26:37',NULL),(893,7902,41171,31954,3,893,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',48906.93,'EGRESOS MARZO 23',NULL,1,'2023-11-05 12:29:14','2023-11-05 12:29:14',NULL),(894,7902,41171,31955,3,894,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',52435.76,'EGRESOS ABRIL 23',NULL,1,'2023-11-05 12:41:01','2023-11-05 12:41:01',NULL),(895,7902,41171,31956,3,895,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',87220.83,'EGRESOS MAYO 23',NULL,1,'2023-11-05 12:45:12','2023-11-05 12:45:12',NULL),(896,7902,41171,31957,3,896,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',51869.77,'EGRESOS JUNIO 23',NULL,1,'2023-11-05 12:47:56','2023-11-05 12:47:56',NULL),(897,7902,41171,31958,3,897,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',84481.43,'EGRESOS JULIO 23',NULL,1,'2023-11-05 12:50:44','2023-11-05 12:50:44',NULL),(898,7902,41171,31956,19,898,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',34562.00,'COMPRA MUEBLES Y UTILES',NULL,1,'2023-11-05 12:52:54','2023-11-05 12:52:54',NULL),(899,7902,41171,31952,19,899,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',148500.00,'COMPRA MUEBLES Y UTILES 23',NULL,1,'2023-11-05 12:54:21','2023-11-05 12:54:21',NULL);
INSERT INTO `balance_libro` VALUES (919,NULL,40719,29,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:18:05','2023-12-21 18:18:05',NULL),(920,NULL,40719,29,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:18:07','2023-12-21 18:18:07',NULL),(921,NULL,40719,29,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',3000.00,NULL,NULL,1,'2023-12-21 18:18:08','2023-12-21 18:18:08',NULL),(922,NULL,40719,29,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',3000.00,NULL,NULL,1,'2023-12-21 18:18:10','2023-12-21 18:18:10',NULL),(923,NULL,40719,29,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:18:11','2023-12-21 18:18:11',NULL),(924,NULL,40719,29,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:18:13','2023-12-21 18:18:13',NULL),(925,NULL,40719,29,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:18:15','2023-12-21 18:18:15',NULL),(926,NULL,40719,29,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4000.00,NULL,NULL,1,'2023-12-21 18:18:16','2023-12-21 18:18:16',NULL),(927,NULL,40719,29,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:18:17','2023-12-21 18:18:17',NULL),(928,NULL,40719,29,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:18:18','2023-12-21 18:18:18',NULL),(929,NULL,40719,29,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:18:20','2023-12-21 18:18:20',NULL),(930,NULL,40719,29,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',30000.00,NULL,NULL,1,'2023-12-21 18:18:21','2023-12-21 18:18:21',NULL),(931,7902,40719,29,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',16000.00,NULL,NULL,1,'2023-12-21 18:24:48','2023-12-21 18:24:48',NULL),(932,7902,40719,29,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:24:49','2023-12-21 18:24:49',NULL),(933,7902,40719,29,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:24:50','2023-12-21 18:24:50',NULL),(934,7902,40719,29,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:24:51','2023-12-21 18:24:51',NULL),(935,7902,40719,29,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:24:52','2023-12-21 18:24:52',NULL),(936,7902,40719,29,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:24:53','2023-12-21 18:24:53',NULL),(937,7902,40719,29,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4000.00,NULL,NULL,1,'2023-12-21 18:24:54','2023-12-21 18:24:54',NULL),(938,7902,40719,29,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',3000.00,NULL,NULL,1,'2023-12-21 18:24:55','2023-12-21 18:24:55',NULL),(939,7902,40719,29,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',12000.00,NULL,NULL,1,'2023-12-21 18:24:56','2023-12-21 18:24:56',NULL);
INSERT INTO `balance_libro` VALUES (940,7902,40719,29,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:24:57','2023-12-21 18:24:57',NULL),(941,NULL,40719,29,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',15000.00,NULL,NULL,1,'2023-12-21 18:32:05','2023-12-21 18:32:05',NULL),(942,NULL,40719,29,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:32:06','2023-12-21 18:32:06',NULL),(943,NULL,40719,29,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:32:07','2023-12-21 18:32:07',NULL),(944,NULL,40719,29,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:32:08','2023-12-21 18:32:08',NULL),(945,NULL,40719,29,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:32:09','2023-12-21 18:32:09',NULL),(946,NULL,40719,29,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4000.00,NULL,NULL,1,'2023-12-21 18:32:10','2023-12-21 18:32:10',NULL),(947,NULL,40719,29,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',3000.00,NULL,NULL,1,'2023-12-21 18:32:11','2023-12-21 18:32:11',NULL),(948,NULL,40719,29,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',12000.00,NULL,NULL,1,'2023-12-21 18:32:12','2023-12-21 18:32:12',NULL),(949,NULL,40719,29,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4500.00,NULL,NULL,1,'2023-12-21 18:32:13','2023-12-21 18:32:13',NULL),(950,NULL,40719,29,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',15000.00,NULL,NULL,1,'2023-12-21 18:32:14','2023-12-21 18:32:14',NULL),(951,NULL,40719,29,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:32:16','2023-12-21 18:32:16',NULL),(952,NULL,40719,29,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',15000.00,NULL,NULL,1,'2023-12-21 18:38:55','2023-12-21 18:38:55',NULL),(953,NULL,40719,29,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:38:56','2023-12-21 18:38:56',NULL),(954,NULL,40719,29,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:38:57','2023-12-21 18:38:57',NULL),(955,NULL,40719,29,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',20000.00,NULL,NULL,1,'2023-12-21 18:38:58','2023-12-21 18:38:58',NULL),(956,NULL,40719,29,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:38:59','2023-12-21 18:38:59',NULL),(957,NULL,40719,29,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',25000.00,NULL,NULL,1,'2023-12-21 18:39:00','2023-12-21 18:39:00',NULL),(958,NULL,40719,29,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:39:01','2023-12-21 18:39:01',NULL),(959,NULL,40719,29,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:39:01','2023-12-21 18:39:01',NULL),(960,NULL,40719,29,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:39:03','2023-12-21 18:39:03',NULL);
INSERT INTO `balance_libro` VALUES (961,NULL,40719,29,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',9000.00,NULL,NULL,1,'2023-12-21 18:39:04','2023-12-21 18:39:04',NULL),(962,NULL,40719,29,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:39:05','2023-12-21 18:39:05',NULL),(963,NULL,40719,29,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:39:06','2023-12-21 18:39:06',NULL),(964,7902,40719,29,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',10000.00,NULL,NULL,1,'2023-12-21 18:46:35','2023-12-21 18:46:35',NULL),(965,7902,40719,29,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:46:36','2023-12-21 18:46:36',NULL),(966,7902,40719,29,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:46:37','2023-12-21 18:46:37',NULL),(967,7902,40719,29,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:46:38','2023-12-21 18:46:38',NULL),(968,7902,40719,29,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:46:39','2023-12-21 18:46:39',NULL),(969,7902,40719,29,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:46:40','2023-12-21 18:46:40',NULL),(970,7902,40719,29,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',5000.00,NULL,NULL,1,'2023-12-21 18:46:41','2023-12-21 18:46:41',NULL),(971,7902,40719,29,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:46:42','2023-12-21 18:46:42',NULL),(972,7902,40719,29,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:46:43','2023-12-21 18:46:43',NULL),(973,7902,40719,29,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',6000.00,NULL,NULL,1,'2023-12-21 18:46:43','2023-12-21 18:46:43',NULL),(1042,NULL,40920,30336,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',5198.99,NULL,NULL,1,'2023-12-26 14:22:22','2023-12-26 14:22:22',NULL),(1043,NULL,40920,30336,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',117149.00,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1044,NULL,40920,30336,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',3950.01,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1045,NULL,40920,30336,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',580.00,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1046,NULL,40920,30336,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',82000.01,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1047,NULL,40920,30336,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1048,NULL,40920,30336,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',15672.00,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1049,NULL,40920,30336,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',3597.00,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL);
INSERT INTO `balance_libro` VALUES (1050,NULL,40920,30336,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',10707.00,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1051,NULL,40920,30336,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',25899.00,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1052,NULL,40920,30336,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',49596.00,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1053,NULL,40920,30336,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11994.00,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1054,NULL,40920,30336,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',16389.99,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1055,NULL,40920,30336,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11893.01,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1056,NULL,40920,30336,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',13198.99,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1057,NULL,40920,30336,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',14994.01,NULL,NULL,1,'2023-12-26 14:22:23','2023-12-26 14:22:23',NULL),(1058,NULL,40920,30336,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',2899.99,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1059,NULL,40920,30336,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',15049.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1060,NULL,40920,30336,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',27683.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1061,NULL,40920,30336,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1062,NULL,40920,30336,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',21990.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1063,NULL,40920,30336,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1064,NULL,40920,30336,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',10617.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1065,NULL,40920,30336,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',2899.99,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1066,NULL,40920,30336,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',31398.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1067,NULL,40920,30336,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',10269.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1068,NULL,40920,30336,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',1899.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1069,NULL,40920,30336,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',7998.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1070,NULL,40920,30336,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',14999.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL);
INSERT INTO `balance_libro` VALUES (1071,NULL,40920,30336,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',14885.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1072,NULL,40920,30336,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',28600.00,NULL,NULL,1,'2023-12-26 14:22:24','2023-12-26 14:22:24',NULL),(1073,NULL,40920,30336,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',74998.99,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1074,NULL,40920,30336,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',16796.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1075,NULL,40920,30336,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',17594.15,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1076,NULL,40920,30336,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',2899.99,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1077,NULL,40920,30336,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4598.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1078,NULL,40920,30336,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',15699.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1079,NULL,40920,30336,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11898.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1080,NULL,40920,30336,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',5099.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1081,NULL,40920,30336,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',12796.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1082,NULL,40920,30336,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1083,NULL,40920,30336,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4399.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1084,NULL,40920,30336,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',500.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1085,NULL,40920,30336,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',500.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1086,NULL,40920,30336,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',3749.00,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1087,NULL,40920,30336,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:25','2023-12-26 14:22:25',NULL),(1088,NULL,40920,30336,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',25889.00,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1089,NULL,40920,30336,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',13198.99,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1090,NULL,40920,30336,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1091,NULL,40920,30336,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',269.00,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL);
INSERT INTO `balance_libro` VALUES (1092,NULL,40920,30336,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',12311.91,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1093,NULL,40920,30336,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',10314.15,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1094,NULL,40920,30336,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',13299.00,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1095,NULL,40920,30336,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1096,NULL,40920,30336,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',580.00,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1097,NULL,40920,30336,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',14299.01,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1098,NULL,40920,30336,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',5799.00,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1099,NULL,40920,30336,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',7989.98,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1100,NULL,40920,30336,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1101,NULL,40920,30336,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1102,NULL,40920,30336,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',10200.00,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1103,NULL,40920,30336,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:26','2023-12-26 14:22:26',NULL),(1104,NULL,40920,30336,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',2398.99,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1105,NULL,40920,30336,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',500.00,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1106,NULL,40920,30336,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',13299.00,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1107,NULL,40920,30336,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4640.00,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1108,NULL,40920,30336,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',18897.01,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1109,NULL,40920,30336,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',3798.00,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1110,NULL,40920,30336,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4699.00,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1111,NULL,40920,30336,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1112,NULL,40920,30336,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',17007.30,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL);
INSERT INTO `balance_libro` VALUES (1113,NULL,40920,30336,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',2899.99,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1114,NULL,40920,30336,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',15111.99,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1115,NULL,40920,30336,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1116,NULL,40920,30336,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',499.00,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1117,NULL,40920,30336,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',8398.01,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1118,NULL,40920,30336,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1119,NULL,40920,30336,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',3654.15,NULL,NULL,1,'2023-12-26 14:22:27','2023-12-26 14:22:27',NULL),(1120,NULL,40920,30336,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11814.15,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1121,NULL,40920,30336,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',42002.26,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1122,NULL,40920,30336,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4699.00,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1123,NULL,40920,30336,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',6544.15,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1124,NULL,40920,30336,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',18897.01,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1125,NULL,40920,30336,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',2899.99,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1126,NULL,40920,30336,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',36880.96,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1127,NULL,40920,30336,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10482.48,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1128,NULL,40920,30336,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',12198.00,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1129,NULL,40920,30336,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',1349.00,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1130,NULL,40920,30336,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2449.00,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1131,NULL,40920,30336,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',3654.15,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1132,NULL,40920,30336,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',17499.00,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1133,NULL,40920,30336,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',12224.00,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL);
INSERT INTO `balance_libro` VALUES (1134,NULL,40920,30336,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',3750.00,NULL,NULL,1,'2023-12-26 14:22:28','2023-12-26 14:22:28',NULL),(1135,NULL,40920,30336,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11814.15,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1136,NULL,40920,30336,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',12399.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1137,NULL,40920,30336,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',12399.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1138,NULL,40920,30336,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',12399.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1139,NULL,40920,30336,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',29800.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1140,NULL,40920,30336,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2349.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1141,NULL,40920,30336,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',1349.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1142,NULL,40920,30336,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10194.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1143,NULL,40920,30336,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',3654.15,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1144,NULL,40920,30336,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',3639.99,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1145,NULL,40920,30336,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',13662.46,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1146,NULL,40920,30336,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11598.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1147,NULL,40920,30336,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2398.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1148,NULL,40920,30336,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',1000.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1149,NULL,40920,30336,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',30687.94,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1150,NULL,40920,30336,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',5700.00,NULL,NULL,1,'2023-12-26 14:22:29','2023-12-26 14:22:29',NULL),(1151,NULL,40920,30336,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11814.15,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1152,NULL,40920,30336,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',6137.56,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1153,NULL,40920,30336,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',1250.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1154,NULL,40920,30336,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',7257.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL);
INSERT INTO `balance_libro` VALUES (1155,NULL,40920,30336,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',6900.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1156,NULL,40920,30336,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',3872.15,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1157,NULL,40920,30336,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2398.99,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1158,NULL,40920,30336,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',66500.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1159,NULL,40920,30336,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11745.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1160,NULL,40920,30336,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2899.99,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1161,NULL,40920,30336,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2809.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1162,NULL,40920,30336,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',499.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1163,NULL,40920,30336,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',24797.99,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1164,NULL,40920,30336,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10298.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1165,NULL,40920,30336,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',1799.00,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1166,NULL,40920,30336,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',14752.15,NULL,NULL,1,'2023-12-26 14:22:30','2023-12-26 14:22:30',NULL),(1167,NULL,40920,30336,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10962.45,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1168,NULL,40920,30336,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',5300.01,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1169,NULL,40920,30336,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',499.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1170,NULL,40920,30336,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4699.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1171,NULL,40920,30336,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',13198.99,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1172,NULL,40920,30336,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',580.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1173,NULL,40920,30336,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',380.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1174,NULL,40920,30336,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4798.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1175,NULL,40920,30336,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',290.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL);
INSERT INTO `balance_libro` VALUES (1176,NULL,40920,30336,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',6199.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1177,NULL,40920,30336,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',3399.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1178,NULL,40920,30336,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',7199.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1179,NULL,40920,30336,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',500.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1180,NULL,40920,30336,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',500.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1181,NULL,40920,30336,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11794.00,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1182,NULL,40920,30336,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11590.15,NULL,NULL,1,'2023-12-26 14:22:31','2023-12-26 14:22:31',NULL),(1183,NULL,40920,30336,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4798.00,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1184,NULL,40920,30336,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2899.99,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1185,NULL,40920,30336,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',9814.15,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1186,NULL,40920,30336,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',5100.00,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1187,NULL,40920,30336,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10798.00,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1188,NULL,40920,30336,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',5548.00,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1189,NULL,40920,30336,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10195.00,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1190,NULL,40920,30336,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2129.99,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1191,NULL,40920,30336,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2899.99,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1192,NULL,40920,30336,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10942.70,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1193,NULL,40920,30336,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',9998.00,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1194,NULL,40920,30336,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4998.99,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1195,NULL,40920,30336,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10962.45,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1196,NULL,40920,30336,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',1160.00,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL);
INSERT INTO `balance_libro` VALUES (1197,NULL,40920,30336,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10962.45,NULL,NULL,1,'2023-12-26 14:22:32','2023-12-26 14:22:32',NULL),(1198,NULL,40920,30336,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11814.15,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1199,NULL,40920,30336,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',1199.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1200,NULL,40920,30336,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10394.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1201,NULL,40920,30336,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2899.99,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1202,NULL,40920,30336,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',10962.45,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1203,NULL,40920,30336,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',19590.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1204,NULL,40920,30336,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11798.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1205,NULL,40920,30336,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2299.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1206,NULL,40920,30336,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',580.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1207,NULL,40920,30336,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',11814.15,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1208,NULL,40920,30336,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',5100.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1209,NULL,40920,30336,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',14213.14,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1210,NULL,40920,30336,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',580.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1211,NULL,40920,30336,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',6199.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1212,NULL,40920,30336,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',200.00,NULL,NULL,1,'2023-12-26 14:22:33','2023-12-26 14:22:33',NULL),(1213,NULL,40920,30336,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4299.00,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1214,NULL,40920,30336,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',380.00,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1215,NULL,40920,30336,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',2398.99,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1216,NULL,40920,30336,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',380.00,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1217,NULL,40920,30336,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4465.94,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL);
INSERT INTO `balance_libro` VALUES (1218,NULL,40920,30336,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',11440.01,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1219,NULL,40920,30336,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',10994.00,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1220,NULL,40920,30336,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',27876.60,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1221,NULL,40920,30336,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',2899.99,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1222,NULL,40920,30336,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',3994.13,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1223,NULL,40920,30336,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4699.00,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1224,NULL,40920,30336,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',22014.15,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1225,NULL,40920,30336,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',3654.15,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1226,NULL,40920,30336,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',15715.00,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1227,NULL,40920,30336,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',14290.00,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1228,NULL,40920,30336,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4199.00,NULL,NULL,1,'2023-12-26 14:22:34','2023-12-26 14:22:34',NULL),(1229,NULL,40920,30336,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1899.00,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1230,NULL,40920,30336,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',31704.15,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1231,NULL,40920,30336,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',134.50,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1232,NULL,40920,30336,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',31449.15,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1233,NULL,40920,30336,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4886.56,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1234,NULL,40920,30336,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4886.56,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1235,NULL,40920,30336,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',27876.60,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1236,NULL,40920,30336,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1799.00,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1237,NULL,40920,30336,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4858.00,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1238,NULL,40920,30336,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',290.00,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL);
INSERT INTO `balance_libro` VALUES (1239,NULL,40920,30336,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',58396.97,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1240,NULL,40920,30336,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',8839.00,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1241,NULL,40920,30336,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',7308.30,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1242,NULL,40920,30336,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',435.00,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1243,NULL,40920,30336,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',18182.95,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1244,NULL,40920,30336,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4197.01,NULL,NULL,1,'2023-12-26 14:22:35','2023-12-26 14:22:35',NULL),(1245,NULL,40920,30336,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1799.00,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1246,NULL,40920,30336,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',16197.00,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1247,NULL,40920,30336,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',2129.99,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1248,NULL,40920,30336,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',11814.15,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1249,NULL,40920,30336,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4325.00,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1250,NULL,40920,30336,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',11699.01,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1251,NULL,40920,30336,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',56700.00,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1252,NULL,40920,30336,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',9798.00,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1253,NULL,40920,30336,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',55753.19,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1254,NULL,40920,30336,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',14993.00,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1255,NULL,40920,30336,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',11814.15,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1256,NULL,40920,30336,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',100000.00,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1257,NULL,40920,30336,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',30100.00,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1258,NULL,40920,30336,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',7299.54,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1259,NULL,40920,30336,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',22014.15,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL);
INSERT INTO `balance_libro` VALUES (1260,NULL,40920,30336,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4514.55,NULL,NULL,1,'2023-12-26 14:22:36','2023-12-26 14:22:36',NULL),(1261,NULL,40920,30336,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',11814.15,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1262,NULL,40920,30336,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',6792.13,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1263,NULL,40920,30336,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',2899.99,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1264,NULL,40920,30336,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',13198.99,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1265,NULL,40920,30336,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',20995.00,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1266,NULL,40920,30336,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',3654.15,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1267,NULL,40920,30336,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',12713.16,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1268,NULL,40920,30336,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',22497.00,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1269,NULL,40920,30336,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',580.00,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1270,NULL,40920,30336,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',5100.00,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1271,NULL,40920,30336,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',14394.00,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1272,NULL,40920,30336,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',10796.00,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1273,NULL,40920,30336,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',9071.91,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1274,NULL,40920,30336,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',6399.00,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1275,NULL,40920,30336,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',27876.60,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1276,NULL,40920,30336,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',5740.00,NULL,NULL,1,'2023-12-26 14:22:37','2023-12-26 14:22:37',NULL),(1277,NULL,40920,30336,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1798.00,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1278,NULL,40920,30336,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',11395.01,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1279,NULL,40920,30336,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',22014.15,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1280,NULL,40920,30336,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',27699.01,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL);
INSERT INTO `balance_libro` VALUES (1281,NULL,40920,30336,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',11814.15,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1282,NULL,40920,30336,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',580.00,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1283,NULL,40920,30336,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',19298.96,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1284,NULL,40920,30336,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',27876.60,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1285,NULL,40920,30336,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',21164.15,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1286,NULL,40920,30336,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',15699.00,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1287,NULL,40920,30336,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',11814.15,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1288,NULL,40920,30336,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',13938.30,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1289,NULL,40920,30336,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',22014.15,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1290,NULL,40920,30336,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',11814.15,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1291,NULL,40920,30336,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',4299.00,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1292,NULL,40920,30336,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',13938.30,NULL,NULL,1,'2023-12-26 14:22:38','2023-12-26 14:22:38',NULL),(1293,NULL,40920,30336,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',13198.99,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1294,NULL,40920,30336,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',15797.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1295,NULL,40920,30336,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',11814.15,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1296,NULL,40920,30336,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',20164.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1297,NULL,40920,30336,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',9798.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1298,NULL,40920,30336,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',5900.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1299,NULL,40920,30336,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',14199.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1300,NULL,40920,30336,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',11814.15,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1301,NULL,40920,30336,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',10070.50,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL);
INSERT INTO `balance_libro` VALUES (1302,NULL,40920,30336,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',580.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1303,NULL,40920,30336,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',20439.14,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1304,NULL,40920,30336,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',11995.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1305,NULL,40920,30336,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',5949.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1306,NULL,40920,30336,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',9173.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1307,NULL,40920,30336,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',9546.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1308,NULL,40920,30336,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',37197.00,NULL,NULL,1,'2023-12-26 14:22:39','2023-12-26 14:22:39',NULL),(1309,NULL,40920,30336,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',5899.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1310,NULL,40920,30336,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',4399.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1311,NULL,40920,30336,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',500.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1312,NULL,40920,30336,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',35188.30,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1313,NULL,40920,30336,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',2245.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1314,NULL,40920,30336,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',3420.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1315,NULL,40920,30336,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',305.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1316,NULL,40920,30336,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',4697.99,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1317,NULL,40920,30336,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',15098.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1318,NULL,40920,30336,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',4899.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1319,NULL,40920,30336,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',4899.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1320,NULL,40920,30336,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',17998.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1321,NULL,40920,30336,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',2220.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1322,NULL,40920,30336,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',33249.71,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL);
INSERT INTO `balance_libro` VALUES (1323,NULL,40920,30336,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',9440.00,NULL,NULL,1,'2023-12-26 14:22:40','2023-12-26 14:22:40',NULL),(1324,NULL,40920,30336,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',5100.00,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1325,NULL,40920,30336,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',18266.99,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1326,NULL,40920,30336,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',2899.99,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1327,NULL,40920,30336,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',15678.80,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1328,NULL,40920,30336,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',4699.00,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1329,NULL,40920,30336,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',13899.00,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1330,NULL,40920,30336,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',9613.55,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1331,NULL,40920,30336,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',13899.00,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1332,NULL,40920,30336,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',426.00,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1333,NULL,40920,30336,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',34679.14,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1334,NULL,40920,30336,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',580.00,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1335,NULL,40920,30336,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',14299.01,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1336,NULL,40920,30336,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',13832.20,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1337,NULL,40920,30336,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',2245.00,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1338,NULL,40920,30336,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',500.00,NULL,NULL,1,'2023-12-26 14:22:41','2023-12-26 14:22:41',NULL),(1339,NULL,40920,30336,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',6298.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1340,NULL,40920,30336,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',4699.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1341,NULL,40920,30336,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',1899.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1342,NULL,40920,30336,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',9403.91,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1343,NULL,40920,30336,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',7596.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL);
INSERT INTO `balance_libro` VALUES (1344,NULL,40920,30336,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',33829.16,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1345,NULL,40920,30336,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',5100.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1346,NULL,40920,30336,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',200.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1347,NULL,40920,30336,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',14996.99,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1348,NULL,40920,30336,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',10150.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1349,NULL,40920,30336,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',32979.16,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1350,NULL,40920,30336,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13899.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1351,NULL,40920,30336,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',580.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1352,NULL,40920,30336,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',11358.00,NULL,NULL,1,'2023-12-26 14:22:42','2023-12-26 14:22:42',NULL),(1353,NULL,40920,30336,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',4199.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1354,NULL,40920,30336,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',3736.86,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1355,NULL,40920,30336,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',14479.79,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1356,NULL,40920,30336,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2499.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1357,NULL,40920,30336,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',200.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1358,NULL,40920,30336,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13899.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1359,NULL,40920,30336,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',580.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1360,NULL,40920,30336,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13899.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1361,NULL,40920,30336,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',15918.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1362,NULL,40920,30336,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',17398.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1363,NULL,40920,30336,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',8718.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1364,NULL,40920,30336,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',134.50,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL);
INSERT INTO `balance_libro` VALUES (1365,NULL,40920,30336,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',14033.54,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1366,NULL,40920,30336,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',24597.00,NULL,NULL,1,'2023-12-26 14:22:43','2023-12-26 14:22:43',NULL),(1367,NULL,40920,30336,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',24597.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1368,NULL,40920,30336,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13938.30,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1369,NULL,40920,30336,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',23714.15,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1370,NULL,40920,30336,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',135000.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1371,NULL,40920,30336,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',5399.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1372,NULL,40920,30336,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',23596.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1373,NULL,40920,30336,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2799.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1374,NULL,40920,30336,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',23714.15,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1375,NULL,40920,30336,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',20907.44,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1376,NULL,40920,30336,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2899.99,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1377,NULL,40920,30336,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',4899.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1378,NULL,40920,30336,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',14399.21,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1379,NULL,40920,30336,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',6897.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1380,NULL,40920,30336,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',4699.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1381,NULL,40920,30336,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',499.00,NULL,NULL,1,'2023-12-26 14:22:44','2023-12-26 14:22:44',NULL),(1382,NULL,40920,30336,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',37197.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1383,NULL,40920,30336,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',12399.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1384,NULL,40920,30336,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',18598.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1385,NULL,40920,30336,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13899.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL);
INSERT INTO `balance_libro` VALUES (1386,NULL,40920,30336,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13194.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1387,NULL,40920,30336,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2899.99,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1388,NULL,40920,30336,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',11754.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1389,NULL,40920,30336,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',12104.94,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1390,NULL,40920,30336,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',16749.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1391,NULL,40920,30336,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2899.99,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1392,NULL,40920,30336,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',14199.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1393,NULL,40920,30336,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13899.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1394,NULL,40920,30336,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',910.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1395,NULL,40920,30336,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',6719.86,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1396,NULL,40920,30336,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',380.00,NULL,NULL,1,'2023-12-26 14:22:45','2023-12-26 14:22:45',NULL),(1397,NULL,40920,30336,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2450.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1398,NULL,40920,30336,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',4899.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1399,NULL,40920,30336,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',5949.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1400,NULL,40920,30336,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',380.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1401,NULL,40920,30336,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',5100.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1402,NULL,40920,30336,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',9398.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1403,NULL,40920,30336,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',4299.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1404,NULL,40920,30336,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13899.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1405,NULL,40920,30336,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',201.76,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1406,NULL,40920,30336,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',4699.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL);
INSERT INTO `balance_libro` VALUES (1407,NULL,40920,30336,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',4699.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1408,NULL,40920,30336,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',3698.99,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1409,NULL,40920,30336,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',13938.30,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1410,NULL,40920,30336,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2899.99,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1411,NULL,40920,30336,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',4998.99,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1412,NULL,40920,30336,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',14697.00,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1413,NULL,40920,30336,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',34679.14,NULL,NULL,1,'2023-12-26 14:22:46','2023-12-26 14:22:46',NULL),(1414,NULL,40920,30336,2,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13198.99,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1415,NULL,40920,30336,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',2799.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1416,NULL,40920,30336,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',500.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1417,NULL,40920,30336,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',4598.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1418,NULL,40920,30336,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',7699.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1419,NULL,40920,30336,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',305.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1420,NULL,40920,30336,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',22014.15,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1421,NULL,40920,30336,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',10393.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1422,NULL,40920,30336,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',2899.99,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1423,NULL,40920,30336,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',5840.50,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1424,NULL,40920,30336,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',28300.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1425,NULL,40920,30336,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',26064.01,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1426,NULL,40920,30336,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',14299.01,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1427,NULL,40920,30336,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',580.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL);
INSERT INTO `balance_libro` VALUES (1428,NULL,40920,30336,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',10198.00,NULL,NULL,1,'2023-12-26 14:22:47','2023-12-26 14:22:47',NULL),(1429,NULL,40920,30336,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13198.99,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1430,NULL,40920,30336,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',113049.15,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1431,NULL,40920,30336,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',23714.15,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1432,NULL,40920,30336,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',499.00,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1433,NULL,40920,30336,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',20907.44,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1434,NULL,40920,30336,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',2899.99,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1435,NULL,40920,30336,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',23714.15,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1436,NULL,40920,30336,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',1090.00,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1437,NULL,40920,30336,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',740.00,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1438,NULL,40920,30336,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',11745.00,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1439,NULL,40920,30336,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',8860.00,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1440,NULL,40920,30336,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',1230.00,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1441,NULL,40920,30336,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',2398.99,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1442,NULL,40920,30336,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',6969.15,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1443,NULL,40920,30336,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',500.00,NULL,NULL,1,'2023-12-26 14:22:48','2023-12-26 14:22:48',NULL),(1444,NULL,40920,30336,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13938.30,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1445,NULL,40920,30336,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',6199.00,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1446,NULL,40920,30336,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',27876.60,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1447,NULL,40920,30336,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',17594.15,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1448,NULL,40920,30336,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13861.00,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL);
INSERT INTO `balance_libro` VALUES (1449,NULL,40920,30336,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',22014.15,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1450,NULL,40920,30336,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',27699.01,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1451,NULL,40920,30336,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',31704.15,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1452,NULL,40920,30336,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',11814.15,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1453,NULL,40920,30336,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',580.00,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1454,NULL,40920,30336,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',1900.00,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1455,NULL,40920,30336,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',117039.13,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1456,NULL,40920,30336,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13861.00,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1457,NULL,40920,30336,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',580.00,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1458,NULL,40920,30336,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',5295.00,NULL,NULL,1,'2023-12-26 14:22:49','2023-12-26 14:22:49',NULL),(1459,NULL,40920,30336,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',14097.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1460,NULL,40920,30336,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',4483.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1461,NULL,40920,30336,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',5100.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1462,NULL,40920,30336,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',36799.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1463,NULL,40920,30336,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',6969.15,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1464,NULL,40920,30336,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',11745.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1465,NULL,40920,30336,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',14318.99,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1466,NULL,40920,30336,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',2398.99,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1467,NULL,40920,30336,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',18799.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1468,NULL,40920,30336,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',7998.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1469,NULL,40920,30336,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',33351.77,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL);
INSERT INTO `balance_libro` VALUES (1470,NULL,40920,30336,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',31704.15,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1471,NULL,40920,30336,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',5899.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1472,NULL,40920,30336,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',7497.00,NULL,NULL,1,'2023-12-26 14:22:50','2023-12-26 14:22:50',NULL),(1473,NULL,40920,30336,2,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',3599.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1474,NULL,40920,30336,2,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',29899.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1475,NULL,40920,30336,2,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',380.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1476,NULL,40920,30336,2,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',18127.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1477,NULL,40920,30336,2,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13861.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1478,NULL,40920,30336,2,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',1899.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1479,NULL,40920,30336,2,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',18989.99,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1480,NULL,40920,30336,2,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',500.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1481,NULL,40920,30336,2,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',21774.29,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1482,NULL,40920,30336,2,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',2799.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1483,NULL,40920,30336,2,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',11139.01,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1484,NULL,40920,30336,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',4598.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1485,NULL,40920,30336,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13861.00,NULL,NULL,1,'2023-12-26 14:22:51','2023-12-26 14:22:51',NULL),(1486,NULL,40920,30336,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',3360.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1487,NULL,40920,30336,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13861.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1488,NULL,40920,30336,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',19498.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1489,NULL,40920,30336,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13861.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1490,NULL,40920,30336,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',2450.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL);
INSERT INTO `balance_libro` VALUES (1491,NULL,40920,30336,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',269.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1492,NULL,40920,30336,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',3598.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1493,NULL,40920,30336,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',7182.54,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1494,NULL,40920,30336,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4900.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1495,NULL,40920,30336,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1496,NULL,40920,30336,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',580.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1497,NULL,40920,30336,2,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2799.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1498,NULL,40920,30336,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',3199.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1499,NULL,40920,30336,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2592.75,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1500,NULL,40920,30336,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',499.00,NULL,NULL,1,'2023-12-26 14:22:52','2023-12-26 14:22:52',NULL),(1501,NULL,40920,30336,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',1899.00,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1502,NULL,40920,30336,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',23714.15,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1503,NULL,40920,30336,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',22014.15,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1504,NULL,40920,30336,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',14399.21,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1505,NULL,40920,30336,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13938.30,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1506,NULL,40920,30336,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',6897.00,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1507,NULL,40920,30336,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4998.99,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1508,NULL,40920,30336,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',17499.00,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1509,NULL,40920,30336,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2398.99,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1510,NULL,40920,30336,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',31704.15,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1511,NULL,40920,30336,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13360.00,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL);
INSERT INTO `balance_libro` VALUES (1512,NULL,40920,30336,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2899.99,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1513,NULL,40920,30336,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',23714.15,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1514,NULL,40920,30336,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',605.25,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1515,NULL,40920,30336,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4550.00,NULL,NULL,1,'2023-12-26 14:22:53','2023-12-26 14:22:53',NULL),(1516,NULL,40920,30336,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',580.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1517,NULL,40920,30336,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2245.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1518,NULL,40920,30336,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',3870.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1519,NULL,40920,30336,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',5720.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1520,NULL,40920,30336,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',3480.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1521,NULL,40920,30336,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',305.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1522,NULL,40920,30336,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4199.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1523,NULL,40920,30336,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1524,NULL,40920,30336,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',10898.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1525,NULL,40920,30336,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1526,NULL,40920,30336,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1527,NULL,40920,30336,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',580.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1528,NULL,40920,30336,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',10397.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1529,NULL,40920,30336,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2899.99,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1530,NULL,40920,30336,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:54','2023-12-26 14:22:54',NULL),(1531,NULL,40920,30336,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4299.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1532,NULL,40920,30336,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',22004.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL);
INSERT INTO `balance_libro` VALUES (1533,NULL,40920,30336,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',27998.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1534,NULL,40920,30336,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13198.99,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1535,NULL,40920,30336,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1536,NULL,40920,30336,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13198.99,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1537,NULL,40920,30336,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',580.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1538,NULL,40920,30336,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',12942.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1539,NULL,40920,30336,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2899.99,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1540,NULL,40920,30336,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4697.99,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1541,NULL,40920,30336,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4460.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1542,NULL,40920,30336,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',1000.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1543,NULL,40920,30336,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',7199.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1544,NULL,40920,30336,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4399.00,NULL,NULL,1,'2023-12-26 14:22:55','2023-12-26 14:22:55',NULL),(1545,NULL,40920,30336,2,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4699.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1546,NULL,40920,30336,2,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',500.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1547,NULL,40920,30336,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13938.30,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1548,NULL,40920,30336,2,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2899.99,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1549,NULL,40920,30336,2,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13635.01,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1550,NULL,40920,30336,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',11754.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1551,NULL,40920,30336,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',9299.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1552,NULL,40920,30336,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4299.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1553,NULL,40920,30336,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',49596.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL);
INSERT INTO `balance_libro` VALUES (1554,NULL,40920,30336,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',11590.15,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1555,NULL,40920,30336,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2899.99,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1556,NULL,40920,30336,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',17499.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1557,NULL,40920,30336,2,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',3750.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1558,NULL,40920,30336,2,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',11799.00,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1559,NULL,40920,30336,2,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',11814.15,NULL,NULL,1,'2023-12-26 14:22:56','2023-12-26 14:22:56',NULL),(1560,NULL,40920,30336,2,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4900.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1561,NULL,40920,30336,2,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',499.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1562,NULL,40920,30336,2,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',426.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1563,NULL,40920,30336,2,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1564,NULL,40920,30336,2,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',580.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1565,NULL,40920,30336,2,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1566,NULL,40920,30336,2,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1567,NULL,40920,30336,2,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',15699.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1568,NULL,40920,30336,2,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',580.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1569,NULL,40920,30336,2,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',31704.15,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1570,NULL,40920,30336,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',22014.15,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1571,NULL,40920,30336,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1572,NULL,40920,30336,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',12095.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1573,NULL,40920,30336,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2499.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1574,NULL,40920,30336,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',22014.15,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL);
INSERT INTO `balance_libro` VALUES (1575,NULL,40920,30336,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:57','2023-12-26 14:22:57',NULL),(1576,NULL,40920,30336,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',10494.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1577,NULL,40920,30336,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',38384.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1578,NULL,40920,30336,2,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13198.99,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1579,NULL,40920,30336,2,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13861.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1580,NULL,40920,30336,2,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',17699.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1581,NULL,40920,30336,2,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',2999.99,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1582,NULL,40920,30336,2,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',9596.99,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1583,NULL,40920,30336,2,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',435.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1584,NULL,40920,30336,2,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',12897.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1585,NULL,40920,30336,2,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',4497.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1586,NULL,40920,30336,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',4899.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1587,NULL,40920,30336,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',1199.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1588,NULL,40920,30336,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',4699.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1589,NULL,40920,30336,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',5597.00,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1590,NULL,40920,30336,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',9295.99,NULL,NULL,1,'2023-12-26 14:22:58','2023-12-26 14:22:58',NULL),(1591,NULL,40920,30336,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',3750.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1592,NULL,40920,30336,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',23714.15,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1593,NULL,40920,30336,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',4699.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1594,NULL,40920,30336,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',7347.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1595,NULL,40920,30336,2,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',20192.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL);
INSERT INTO `balance_libro` VALUES (1596,NULL,40920,30336,2,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',8796.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1597,NULL,40920,30336,2,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',23714.15,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1598,NULL,40920,30336,2,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',15642.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1599,NULL,40920,30336,2,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',20907.44,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1600,NULL,40920,30336,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',380.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1601,NULL,40920,30336,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',4699.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1602,NULL,40920,30336,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',15831.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1603,NULL,40920,30336,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',500.00,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1604,NULL,40920,30336,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',18511.95,NULL,NULL,1,'2023-12-26 14:22:59','2023-12-26 14:22:59',NULL),(1605,NULL,40920,30336,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',20889.00,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1606,NULL,40920,30336,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',2499.00,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1607,NULL,40920,30336,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',4798.00,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1608,NULL,40920,30336,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',3499.01,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1609,NULL,40920,30336,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',7598.80,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1610,NULL,40920,30336,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',17994.45,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1611,NULL,40920,30336,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',18397.00,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1612,NULL,40920,30336,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',7948.95,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1613,NULL,40920,30336,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',13419.63,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1614,NULL,40920,30336,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',12366.38,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1615,NULL,40920,30336,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',2899.99,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1616,NULL,40920,30336,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',37049.72,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL);
INSERT INTO `balance_libro` VALUES (1617,NULL,40920,30336,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',13861.00,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1618,NULL,40920,30336,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',4798.00,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1619,NULL,40920,30336,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',599.00,NULL,NULL,1,'2023-12-26 14:23:00','2023-12-26 14:23:00',NULL),(1620,NULL,40920,30336,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',14394.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1621,NULL,40920,30336,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',10200.84,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1622,NULL,40920,30336,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',49980.01,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1623,NULL,40920,30336,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',8517.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1624,NULL,40920,30336,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',13861.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1625,NULL,40920,30336,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',15598.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1626,NULL,40920,30336,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',25196.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1627,NULL,40920,30336,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',4899.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1628,NULL,40920,30336,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',2480.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1629,NULL,40920,30336,2,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',4299.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1630,NULL,40920,30336,2,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',7199.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1631,NULL,40920,30336,2,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',269.00,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1632,NULL,40920,30336,2,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',12849.99,NULL,NULL,1,'2023-12-26 14:23:01','2023-12-26 14:23:01',NULL),(1633,NULL,40920,30336,2,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',580.00,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1634,NULL,40920,30336,2,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',13198.99,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1635,NULL,40920,30336,2,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',5999.00,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1636,NULL,40920,30336,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',10798.00,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1637,NULL,40920,30336,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',2899.99,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL);
INSERT INTO `balance_libro` VALUES (1638,NULL,40920,30336,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',6969.15,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1639,NULL,40920,30336,2,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',2398.99,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1640,NULL,40920,30336,2,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',13198.99,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1641,NULL,40920,30336,2,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',7197.00,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1642,NULL,40920,30336,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',31704.15,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1643,NULL,40920,30336,2,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',64197.00,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1644,NULL,40920,30336,2,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',3698.99,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1645,NULL,40920,30336,2,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',4799.01,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1646,NULL,40920,30336,2,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',305.00,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1647,NULL,40920,30336,2,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',201.76,NULL,NULL,1,'2023-12-26 14:23:02','2023-12-26 14:23:02',NULL),(1648,NULL,40920,30336,2,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',4798.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1649,NULL,40920,30336,2,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',14299.01,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1650,NULL,40920,30336,2,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',580.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1651,NULL,40920,30336,2,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',4798.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1652,NULL,40920,30336,2,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',7199.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1653,NULL,40920,30336,2,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',5999.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1654,NULL,40920,30336,2,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',16516.95,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1655,NULL,40920,30336,2,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',40995.01,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1656,NULL,40920,30336,2,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',32796.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1657,NULL,40920,30336,2,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',4699.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1658,NULL,40920,30336,2,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',10798.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL);
INSERT INTO `balance_libro` VALUES (1659,NULL,40920,30336,2,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',9476.09,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1660,NULL,40920,30336,2,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',5999.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1661,NULL,40920,30336,2,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',5399.00,NULL,NULL,1,'2023-12-26 14:23:03','2023-12-26 14:23:03',NULL),(1662,NULL,40920,30336,2,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',500.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1663,NULL,40920,30336,2,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',7199.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1664,NULL,40920,30336,2,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',305.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1665,NULL,40920,30336,2,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',90400.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1666,NULL,40920,30336,2,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',14529.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1667,NULL,40920,30336,2,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',13198.99,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1668,NULL,40920,30336,2,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',2398.99,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1669,NULL,40920,30336,2,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',4080.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1670,NULL,40920,30336,2,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',10616.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1671,NULL,40920,30336,2,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',2129.99,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1672,NULL,40920,30336,2,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',4998.99,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1673,NULL,40920,30336,2,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',2450.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1674,NULL,40920,30336,2,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',16398.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1675,NULL,40920,30336,2,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',15264.89,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1676,NULL,40920,30336,2,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',13861.00,NULL,NULL,1,'2023-12-26 14:23:04','2023-12-26 14:23:04',NULL),(1677,NULL,40920,30336,2,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',22014.15,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1678,NULL,40920,30336,2,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',21164.15,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1679,NULL,40920,30336,2,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',7199.00,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL);
INSERT INTO `balance_libro` VALUES (1680,NULL,40920,30336,2,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',87548.00,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1681,NULL,40920,30336,2,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',5521.94,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1682,NULL,40920,30336,2,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',7297.00,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1683,NULL,40920,30336,2,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',22491.00,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1684,NULL,40920,30336,2,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',30299.01,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1685,NULL,40920,30336,2,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',13861.00,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1686,NULL,40920,30336,2,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13861.00,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1687,NULL,40920,30336,2,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13938.30,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1688,NULL,40920,30336,2,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2899.99,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1689,NULL,40920,30336,2,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2699.00,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1690,NULL,40920,30336,2,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',3420.00,NULL,NULL,1,'2023-12-26 14:23:05','2023-12-26 14:23:05',NULL),(1691,NULL,40920,30336,2,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',6702.14,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1692,NULL,40920,30336,2,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13861.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1693,NULL,40920,30336,2,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',580.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1694,NULL,40920,30336,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',10794.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1695,NULL,40920,30336,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2899.99,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1696,NULL,40920,30336,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',12145.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1697,NULL,40920,30336,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13598.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1698,NULL,40920,30336,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',20995.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1699,NULL,40920,30336,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2899.99,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1700,NULL,40920,30336,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13861.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL);
INSERT INTO `balance_libro` VALUES (1701,NULL,40920,30336,2,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',7497.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1702,NULL,40920,30336,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2398.99,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1703,NULL,40920,30336,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',1899.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1704,NULL,40920,30336,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',269.00,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1705,NULL,40920,30336,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',8007.13,NULL,NULL,1,'2023-12-26 14:23:06','2023-12-26 14:23:06',NULL),(1706,NULL,40920,30336,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',16828.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1707,NULL,40920,30336,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',8097.01,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1708,NULL,40920,30336,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',11799.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1709,NULL,40920,30336,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',34679.14,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1710,NULL,40920,30336,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13198.99,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1711,NULL,40920,30336,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',20095.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1712,NULL,40920,30336,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',426.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1713,NULL,40920,30336,2,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',14200.35,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1714,NULL,40920,30336,2,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',8700.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1715,NULL,40920,30336,2,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2499.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1716,NULL,40920,30336,2,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',30467.13,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1717,NULL,40920,30336,2,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',4699.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1718,NULL,40920,30336,2,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',500.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1719,NULL,40920,30336,2,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',5197.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1720,NULL,40920,30336,2,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',580.00,NULL,NULL,1,'2023-12-26 14:23:07','2023-12-26 14:23:07',NULL),(1721,NULL,40920,30336,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',6866.85,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL);
INSERT INTO `balance_libro` VALUES (1722,NULL,40920,30336,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2499.00,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1723,NULL,40920,30336,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13198.99,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1724,NULL,40920,30336,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',9550.94,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1725,NULL,40920,30336,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13762.38,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1726,NULL,40920,30336,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',5690.55,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1727,NULL,40920,30336,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',5644.00,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1728,NULL,40920,30336,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',4899.00,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1729,NULL,40920,30336,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',11695.00,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1730,NULL,40920,30336,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',1000.00,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1731,NULL,40920,30336,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',15299.00,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1732,NULL,40920,30336,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',1305.00,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1733,NULL,40920,30336,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',10051.60,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1734,NULL,40920,30336,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',13193.01,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1735,NULL,40920,30336,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',16484.79,NULL,NULL,1,'2023-12-26 14:23:08','2023-12-26 14:23:08',NULL),(1736,NULL,40920,30336,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',11799.00,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1737,NULL,40920,30336,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',12897.00,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1738,NULL,40920,30336,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',2899.99,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1739,NULL,40920,30336,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',2398.99,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1740,NULL,40920,30336,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',13938.30,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1741,NULL,40920,30336,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',11799.00,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1742,NULL,40920,30336,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',2899.99,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL);
INSERT INTO `balance_libro` VALUES (1743,NULL,40920,30336,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',13198.99,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1744,NULL,40920,30336,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',580.00,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1745,NULL,40920,30336,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',4899.00,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1746,NULL,40920,30336,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',2398.99,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1747,NULL,40920,30336,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',11799.00,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1748,NULL,40920,30336,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',580.00,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1749,NULL,40920,30336,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',1875.00,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1750,NULL,40920,30336,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',73484.99,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1751,NULL,40920,30336,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',2398.99,NULL,NULL,1,'2023-12-26 14:23:09','2023-12-26 14:23:09',NULL),(1752,NULL,40920,30336,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',29394.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1753,NULL,40920,30336,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',2398.99,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1754,NULL,40920,30336,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',17999.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1755,NULL,40920,30336,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',14529.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1756,NULL,40920,30336,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',4998.99,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1757,NULL,40920,30336,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',13861.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1758,NULL,40920,30336,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',12800.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1759,NULL,40920,30336,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',34679.14,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1760,NULL,40920,30336,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',580.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1761,NULL,40920,30336,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',499.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1762,NULL,40920,30336,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13198.99,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1763,NULL,40920,30336,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL);
INSERT INTO `balance_libro` VALUES (1764,NULL,40920,30336,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2499.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1765,NULL,40920,30336,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',17279.16,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1766,NULL,40920,30336,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',9798.00,NULL,NULL,1,'2023-12-26 14:23:10','2023-12-26 14:23:10',NULL),(1767,NULL,40920,30336,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',5999.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1768,NULL,40920,30336,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',22014.15,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1769,NULL,40920,30336,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',134.50,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1770,NULL,40920,30336,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13861.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1771,NULL,40920,30336,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1772,NULL,40920,30336,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',499.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1773,NULL,40920,30336,2,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',27390.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1774,NULL,40920,30336,2,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2899.99,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1775,NULL,40920,30336,2,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13861.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1776,NULL,40920,30336,2,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13861.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1777,NULL,40920,30336,2,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1778,NULL,40920,30336,2,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',5874.01,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1779,NULL,40920,30336,2,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',4998.99,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1780,NULL,40920,30336,2,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',305.00,NULL,NULL,1,'2023-12-26 14:23:11','2023-12-26 14:23:11',NULL),(1781,NULL,40920,30336,2,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',499.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1782,NULL,40920,30336,2,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11639.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1783,NULL,40920,30336,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',23714.15,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1784,NULL,40920,30336,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',12897.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL);
INSERT INTO `balance_libro` VALUES (1785,NULL,40920,30336,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',5399.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1786,NULL,40920,30336,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',499.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1787,NULL,40920,30336,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',1305.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1788,NULL,40920,30336,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11799.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1789,NULL,40920,30336,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1790,NULL,40920,30336,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',3848.45,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1791,NULL,40920,30336,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2899.99,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1792,NULL,40920,30336,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11799.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1793,NULL,40920,30336,2,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2799.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1794,NULL,40920,30336,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2899.99,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1795,NULL,40920,30336,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',12295.00,NULL,NULL,1,'2023-12-26 14:23:12','2023-12-26 14:23:12',NULL),(1796,NULL,40920,30336,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2499.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1797,NULL,40920,30336,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11729.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1798,NULL,40920,30336,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2129.99,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1799,NULL,40920,30336,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',5625.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1800,NULL,40920,30336,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',305.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1801,NULL,40920,30336,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',18511.31,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1802,NULL,40920,30336,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13861.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1803,NULL,40920,30336,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',1899.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1804,NULL,40920,30336,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',15995.99,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1805,NULL,40920,30336,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',9299.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL);
INSERT INTO `balance_libro` VALUES (1806,NULL,40920,30336,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',3999.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1807,NULL,40920,30336,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',34999.00,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1808,NULL,40920,30336,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',22014.15,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1809,NULL,40920,30336,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',6969.15,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1810,NULL,40920,30336,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',201.76,NULL,NULL,1,'2023-12-26 14:23:13','2023-12-26 14:23:13',NULL),(1811,NULL,40920,30336,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',17594.15,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1812,NULL,40920,30336,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2899.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1813,NULL,40920,30336,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11799.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1814,NULL,40920,30336,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',28788.01,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1815,NULL,40920,30336,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',499.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1816,NULL,40920,30336,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',500.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1817,NULL,40920,30336,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',32899.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1818,NULL,40920,30336,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11712.86,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1819,NULL,40920,30336,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',15699.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1820,NULL,40920,30336,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',14697.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1821,NULL,40920,30336,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13861.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1822,NULL,40920,30336,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1823,NULL,40920,30336,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13198.99,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1824,NULL,40920,30336,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11799.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1825,NULL,40920,30336,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:14','2023-12-26 14:23:14',NULL),(1826,NULL,40920,30336,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',10798.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL);
INSERT INTO `balance_libro` VALUES (1827,NULL,40920,30336,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',4699.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1828,NULL,40920,30336,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11799.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1829,NULL,40920,30336,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1830,NULL,40920,30336,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',16700.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1831,NULL,40920,30336,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1832,NULL,40920,30336,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11799.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1833,NULL,40920,30336,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',18142.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1834,NULL,40920,30336,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',34679.14,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1835,NULL,40920,30336,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',16398.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1836,NULL,40920,30336,2,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',48784.05,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1837,NULL,40920,30336,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',4699.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1838,NULL,40920,30336,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13190.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1839,NULL,40920,30336,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',11400.00,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1840,NULL,40920,30336,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2899.99,NULL,NULL,1,'2023-12-26 14:23:15','2023-12-26 14:23:15',NULL),(1841,NULL,40920,30336,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2899.99,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1842,NULL,40920,30336,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',9843.85,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1843,NULL,40920,30336,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',16700.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1844,NULL,40920,30336,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',580.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1845,NULL,40920,30336,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11995.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1846,NULL,40920,30336,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4998.99,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1847,NULL,40920,30336,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11799.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL);
INSERT INTO `balance_libro` VALUES (1848,NULL,40920,30336,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',580.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1849,NULL,40920,30336,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',12897.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1850,NULL,40920,30336,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',16700.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1851,NULL,40920,30336,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4899.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1852,NULL,40920,30336,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4899.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1853,NULL,40920,30336,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',12998.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1854,NULL,40920,30336,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',36995.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1855,NULL,40920,30336,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',16796.00,NULL,NULL,1,'2023-12-26 14:23:16','2023-12-26 14:23:16',NULL),(1856,NULL,40920,30336,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',20071.08,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1857,NULL,40920,30336,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',3598.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1858,NULL,40920,30336,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',13198.99,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1859,NULL,40920,30336,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',2129.99,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1860,NULL,40920,30336,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',29303.11,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1861,NULL,40920,30336,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',18296.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1862,NULL,40920,30336,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',29798.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1863,NULL,40920,30336,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',580.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1864,NULL,40920,30336,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4299.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1865,NULL,40920,30336,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',64400.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1866,NULL,40920,30336,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',5399.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1867,NULL,40920,30336,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',305.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1868,NULL,40920,30336,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',13938.30,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL);
INSERT INTO `balance_libro` VALUES (1869,NULL,40920,30336,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',14299.01,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1870,NULL,40920,30336,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',7199.00,NULL,NULL,1,'2023-12-26 14:23:17','2023-12-26 14:23:17',NULL),(1871,NULL,40920,30336,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',2899.99,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1872,NULL,40920,30336,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',7196.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1873,NULL,40920,30336,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',17999.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1874,NULL,40920,30336,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',96999.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1875,NULL,40920,30336,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',2398.99,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1876,NULL,40920,30336,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',14299.01,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1877,NULL,40920,30336,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11495.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1878,NULL,40920,30336,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',3960.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1879,NULL,40920,30336,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4299.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1880,NULL,40920,30336,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',36899.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1881,NULL,40920,30336,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',5099.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1882,NULL,40920,30336,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',22014.15,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1883,NULL,40920,30336,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',30807.69,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1884,NULL,40920,30336,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',580.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1885,NULL,40920,30336,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',7299.00,NULL,NULL,1,'2023-12-26 14:23:18','2023-12-26 14:23:18',NULL),(1886,NULL,40920,30336,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',12897.00,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1887,NULL,40920,30336,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',7197.00,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1888,NULL,40920,30336,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',580.00,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1889,NULL,40920,30336,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',6255.28,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL);
INSERT INTO `balance_libro` VALUES (1890,NULL,40920,30336,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',13198.99,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1891,NULL,40920,30336,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11799.00,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1892,NULL,40920,30336,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',29682.99,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1893,NULL,40920,30336,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11799.00,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1894,NULL,40920,30336,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11799.00,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1895,NULL,40920,30336,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',21896.99,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1896,NULL,40920,30336,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',6596.75,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1897,NULL,40920,30336,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',7015.86,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1898,NULL,40920,30336,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',8598.01,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1899,NULL,40920,30336,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',18745.11,NULL,NULL,1,'2023-12-26 14:23:19','2023-12-26 14:23:19',NULL),(1900,NULL,40920,30336,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',16000.45,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1901,NULL,40920,30336,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',5399.00,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1902,NULL,40920,30336,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',9596.00,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1903,NULL,40920,30336,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',1305.00,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1904,NULL,40920,30336,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',16197.00,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1905,NULL,40920,30336,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',2899.99,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1906,NULL,40920,30336,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',200.00,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1907,NULL,40920,30336,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',17699.00,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1908,NULL,40920,30336,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',22014.15,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1909,NULL,40920,30336,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',9440.00,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1910,NULL,40920,30336,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',13198.99,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL);
INSERT INTO `balance_libro` VALUES (1911,NULL,40920,30336,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11895.00,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1912,NULL,40920,30336,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',2899.99,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1913,NULL,40920,30336,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',3499.01,NULL,NULL,1,'2023-12-26 14:23:20','2023-12-26 14:23:20',NULL),(1914,NULL,40920,30336,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',500.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1915,NULL,40920,30336,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',10198.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1916,NULL,40920,30336,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',2899.99,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1917,NULL,40920,30336,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',6199.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1918,NULL,40920,30336,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',3800.01,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1919,NULL,40920,30336,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',9798.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1920,NULL,40920,30336,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4080.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1921,NULL,40920,30336,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',12418.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1922,NULL,40920,30336,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',5398.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1923,NULL,40920,30336,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',9798.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1924,NULL,40920,30336,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4998.99,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1925,NULL,40920,30336,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',500.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1926,NULL,40920,30336,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',26194.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1927,NULL,40920,30336,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4699.00,NULL,NULL,1,'2023-12-26 14:23:21','2023-12-26 14:23:21',NULL),(1928,NULL,40920,30336,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',500.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1929,NULL,40920,30336,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11499.01,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1930,NULL,40920,30336,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2899.99,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1931,NULL,40920,30336,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4998.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL);
INSERT INTO `balance_libro` VALUES (1932,NULL,40920,30336,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',1160.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1933,NULL,40920,30336,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',5198.99,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1934,NULL,40920,30336,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2799.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1935,NULL,40920,30336,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',580.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1936,NULL,40920,30336,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2899.99,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1937,NULL,40920,30336,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',44000.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1938,NULL,40920,30336,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',16419.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1939,NULL,40920,30336,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',18880.01,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1940,NULL,40920,30336,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',9996.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1941,NULL,40920,30336,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',9998.00,NULL,NULL,1,'2023-12-26 14:23:22','2023-12-26 14:23:22',NULL),(1942,NULL,40920,30336,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',1000.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1943,NULL,40920,30336,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',18319.19,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1944,NULL,40920,30336,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',29394.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1945,NULL,40920,30336,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',17594.15,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1946,NULL,40920,30336,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',34679.14,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1947,NULL,40920,30336,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',7497.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1948,NULL,40920,30336,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',52200.01,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1949,NULL,40920,30336,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',9998.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1950,NULL,40920,30336,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',16793.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1951,NULL,40920,30336,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',3746.99,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1952,NULL,40920,30336,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',435.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL);
INSERT INTO `balance_libro` VALUES (1953,NULL,40920,30336,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',14697.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1954,NULL,40920,30336,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',60000.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1955,NULL,40920,30336,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',13938.30,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1956,NULL,40920,30336,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',15699.00,NULL,NULL,1,'2023-12-26 14:23:23','2023-12-26 14:23:23',NULL),(1957,NULL,40920,30336,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',14194.99,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1958,NULL,40920,30336,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',23990.00,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1959,NULL,40920,30336,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2398.99,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1960,NULL,40920,30336,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2899.99,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1961,NULL,40920,30336,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4998.99,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1962,NULL,40920,30336,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11799.00,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1963,NULL,40920,30336,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',27699.01,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1964,NULL,40920,30336,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',580.00,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1965,NULL,40920,30336,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4798.00,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1966,NULL,40920,30336,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',290.00,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1967,NULL,40920,30336,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11799.00,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1968,NULL,40920,30336,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',580.00,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1969,NULL,40920,30336,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',14801.54,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1970,NULL,40920,30336,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',7199.00,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1971,NULL,40920,30336,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',44800.71,NULL,NULL,1,'2023-12-26 14:23:24','2023-12-26 14:23:24',NULL),(1972,NULL,40920,30336,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',16793.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1973,NULL,40920,30336,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',13198.99,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL);
INSERT INTO `balance_libro` VALUES (1974,NULL,40920,30336,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',500.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1975,NULL,40920,30336,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11995.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1976,NULL,40920,30336,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',24599.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1977,NULL,40920,30336,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',16098.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1978,NULL,40920,30336,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',580.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1979,NULL,40920,30336,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',1890.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1980,NULL,40920,30336,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4998.99,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1981,NULL,40920,30336,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',7998.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1982,NULL,40920,30336,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4699.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1983,NULL,40920,30336,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11799.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1984,NULL,40920,30336,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4899.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1985,NULL,40920,30336,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',7199.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1986,NULL,40920,30336,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',18799.00,NULL,NULL,1,'2023-12-26 14:23:25','2023-12-26 14:23:25',NULL),(1987,NULL,40920,30336,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',5999.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1988,NULL,40920,30336,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',16793.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1989,NULL,40920,30336,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',499.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1990,NULL,40920,30336,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',200.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1991,NULL,40920,30336,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',6198.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1992,NULL,40920,30336,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',426.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1993,NULL,40920,30336,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',14194.99,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1994,NULL,40920,30336,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',26077.25,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL);
INSERT INTO `balance_libro` VALUES (1995,NULL,40920,30336,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',10175.92,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1996,NULL,40920,30336,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11799.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1997,NULL,40920,30336,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',17495.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1998,NULL,40920,30336,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',580.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(1999,NULL,40920,30336,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',12854.00,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(2000,NULL,40920,30336,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2398.99,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(2001,NULL,40920,30336,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11286.55,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(2002,NULL,40920,30336,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',14194.99,NULL,NULL,1,'2023-12-26 14:23:26','2023-12-26 14:23:26',NULL),(2003,NULL,40920,30336,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',13198.99,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2004,NULL,40920,30336,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',13198.99,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2005,NULL,40920,30336,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',580.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2006,NULL,40920,30336,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',5888.01,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2007,NULL,40920,30336,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2860.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2008,NULL,40920,30336,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',500.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2009,NULL,40920,30336,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',8645.99,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2010,NULL,40920,30336,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11799.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2011,NULL,40920,30336,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',13702.50,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2012,NULL,40920,30336,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11997.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2013,NULL,40920,30336,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4114.13,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2014,NULL,40920,30336,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',17594.15,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2015,NULL,40920,30336,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',17699.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL);
INSERT INTO `balance_libro` VALUES (2016,NULL,40920,30336,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',14199.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2017,NULL,40920,30336,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',96999.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2018,NULL,40920,30336,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',7197.00,NULL,NULL,1,'2023-12-26 14:23:27','2023-12-26 14:23:27',NULL),(2019,NULL,40920,30336,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',20495.00,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2020,NULL,40920,30336,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4597.00,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2021,NULL,40920,30336,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',290.00,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2022,NULL,40920,30336,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2398.99,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2023,NULL,40920,30336,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11286.55,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2024,NULL,40920,30336,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',17699.00,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2025,NULL,40920,30336,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11295.00,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2026,NULL,40920,30336,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',6796.00,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2027,NULL,40920,30336,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2129.99,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2028,NULL,40920,30336,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',20907.44,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2029,NULL,40920,30336,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2899.99,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2030,NULL,40920,30336,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',12897.00,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2031,NULL,40920,30336,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11597.00,NULL,NULL,1,'2023-12-26 14:23:28','2023-12-26 14:23:28',NULL),(2032,NULL,40920,30336,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',14194.99,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2033,NULL,40920,30336,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',18998.00,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2034,NULL,40920,30336,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2899.99,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2035,NULL,40920,30336,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',8598.01,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2036,NULL,40920,30336,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',7697.00,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL);
INSERT INTO `balance_libro` VALUES (2037,NULL,40920,30336,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',958.50,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2038,NULL,40920,30336,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',14695.99,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2039,NULL,40920,30336,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11799.00,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2040,NULL,40920,30336,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2398.99,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2041,NULL,40920,30336,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',1875.00,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2042,NULL,40920,30336,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',200.00,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2043,NULL,40920,30336,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',10636.00,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2044,NULL,40920,30336,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2899.99,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2045,NULL,40920,30336,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',14194.99,NULL,NULL,1,'2023-12-26 14:23:29','2023-12-26 14:23:29',NULL),(2046,NULL,40920,30336,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',580.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2047,NULL,40920,30336,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4798.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2048,NULL,40920,30336,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',17699.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2049,NULL,40920,30336,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',580.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2050,NULL,40920,30336,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4398.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2051,NULL,40920,30336,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11799.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2052,NULL,40920,30336,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',580.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2053,NULL,40920,30336,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',20907.44,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2054,NULL,40920,30336,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2899.99,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2055,NULL,40920,30336,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',42480.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2056,NULL,40920,30336,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2899.99,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2057,NULL,40920,30336,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',14194.99,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL);
INSERT INTO `balance_libro` VALUES (2058,NULL,40920,30336,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',21164.15,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2059,NULL,40920,30336,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',8598.01,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2060,NULL,40920,30336,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11799.00,NULL,NULL,1,'2023-12-26 14:23:30','2023-12-26 14:23:30',NULL),(2061,NULL,40920,30336,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4199.00,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2062,NULL,40920,30336,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',6900.00,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2063,NULL,40920,30336,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',12800.00,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2064,NULL,40920,30336,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4998.99,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2065,NULL,40920,30336,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',25856.71,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2066,NULL,40920,30336,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',580.00,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2067,NULL,40920,30336,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',9596.00,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2068,NULL,40920,30336,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',2199.01,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2069,NULL,40920,30336,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',12816.85,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2070,NULL,40920,30336,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',17499.00,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2071,NULL,40920,30336,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4697.99,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2072,NULL,40920,30336,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',11460.54,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2073,NULL,40920,30336,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',8200.00,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2074,NULL,40920,30336,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',499.00,NULL,NULL,1,'2023-12-26 14:23:31','2023-12-26 14:23:31',NULL),(2075,NULL,40920,30336,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',21399.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2076,NULL,40920,30336,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',14194.99,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2077,NULL,40920,30336,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',580.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2078,NULL,40920,30336,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4798.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL);
INSERT INTO `balance_libro` VALUES (2079,NULL,40920,30336,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',1799.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2080,NULL,40920,30336,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',25894.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2081,NULL,40920,30336,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',14194.99,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2082,NULL,40920,30336,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4299.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2083,NULL,40920,30336,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',6798.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2084,NULL,40920,30336,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',15994.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2085,NULL,40920,30336,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',13419.63,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2086,NULL,40920,30336,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',49401.08,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2087,NULL,40920,30336,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',7197.00,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2088,NULL,40920,30336,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',29495.35,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2089,NULL,40920,30336,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',6735.01,NULL,NULL,1,'2023-12-26 14:23:32','2023-12-26 14:23:32',NULL),(2090,NULL,40920,30336,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',11995.00,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2091,NULL,40920,30336,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',13198.99,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2092,NULL,40920,30336,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',11476.00,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2093,NULL,40920,30336,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',4998.99,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2094,NULL,40920,30336,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',10489.01,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2095,NULL,40920,30336,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',42258.44,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2096,NULL,40920,30336,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',5620.70,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2097,NULL,40920,30336,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',15699.00,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2098,NULL,40920,30336,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',3999.00,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2099,NULL,40920,30336,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',14194.99,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL);
INSERT INTO `balance_libro` VALUES (2100,NULL,40920,30336,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',580.00,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2101,NULL,40920,30336,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',16994.99,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2102,NULL,40920,30336,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2899.99,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2103,NULL,40920,30336,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2398.99,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2104,NULL,40920,30336,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',22490.00,NULL,NULL,1,'2023-12-26 14:23:33','2023-12-26 14:23:33',NULL),(2105,NULL,40920,30336,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2398.99,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2106,NULL,40920,30336,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',7199.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2107,NULL,40920,30336,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',13897.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2108,NULL,40920,30336,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2899.99,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2109,NULL,40920,30336,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',11799.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2110,NULL,40920,30336,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',3920.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2111,NULL,40920,30336,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',9840.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2112,NULL,40920,30336,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',1305.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2113,NULL,40920,30336,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',4199.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2114,NULL,40920,30336,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',14798.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2115,NULL,40920,30336,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2499.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2116,NULL,40920,30336,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',4299.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2117,NULL,40920,30336,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',47586.00,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2118,NULL,40920,30336,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',6969.15,NULL,NULL,1,'2023-12-26 14:23:34','2023-12-26 14:23:34',NULL),(2119,NULL,40920,30336,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',11741.36,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2120,NULL,40920,30336,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',14194.99,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL);
INSERT INTO `balance_libro` VALUES (2121,NULL,40920,30336,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',580.00,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2122,NULL,40920,30336,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',14194.99,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2123,NULL,40920,30336,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',20907.44,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2124,NULL,40920,30336,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',14194.99,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2125,NULL,40920,30336,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',11225.00,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2126,NULL,40920,30336,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',499.00,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2127,NULL,40920,30336,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',23714.15,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2128,NULL,40920,30336,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',19192.00,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2129,NULL,40920,30336,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',11799.00,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2130,NULL,40920,30336,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',29394.00,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2131,NULL,40920,30336,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',8796.00,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2132,NULL,40920,30336,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',7199.00,NULL,NULL,1,'2023-12-26 14:23:35','2023-12-26 14:23:35',NULL),(2133,NULL,40920,30336,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',15699.00,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2134,NULL,40920,30336,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',15699.00,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2135,NULL,40920,30336,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',7199.00,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2136,NULL,40920,30336,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',14194.99,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2137,NULL,40920,30336,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',7199.00,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2138,NULL,40920,30336,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',10197.00,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2139,NULL,40920,30336,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2499.00,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2140,NULL,40920,30336,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',31963.95,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2141,NULL,40920,30336,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',10294.99,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL);
INSERT INTO `balance_libro` VALUES (2142,NULL,40920,30336,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',14194.99,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2143,NULL,40920,30336,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',11091.01,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2144,NULL,40920,30336,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2899.99,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2145,NULL,40920,30336,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',23714.15,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2146,NULL,40920,30336,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',14194.99,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2147,NULL,40920,30336,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',41814.90,NULL,NULL,1,'2023-12-26 14:23:36','2023-12-26 14:23:36',NULL),(2148,NULL,40920,30336,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',17594.15,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2149,NULL,40920,30336,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',17999.00,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2150,NULL,40920,30336,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',13198.99,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2151,NULL,40920,30336,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',31187.00,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2152,NULL,40920,30336,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',4902.85,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2153,NULL,40920,30336,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',9624.95,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2154,NULL,40920,30336,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',13598.00,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2155,NULL,40920,30336,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',24599.00,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2156,NULL,40920,30336,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',580.00,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2157,NULL,40920,30336,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',12971.96,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2158,NULL,40920,30336,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',16900.84,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2159,NULL,40920,30336,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',4299.00,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2160,NULL,40920,30336,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',14299.01,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2161,NULL,40920,30336,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',8448.00,NULL,NULL,1,'2023-12-26 14:23:37','2023-12-26 14:23:37',NULL),(2162,NULL,40920,30336,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',13198.99,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL);
INSERT INTO `balance_libro` VALUES (2163,NULL,40920,30336,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',23714.15,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2164,NULL,40920,30336,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',15699.00,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2165,NULL,40920,30336,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',12607.00,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2166,NULL,40920,30336,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',2899.99,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2167,NULL,40920,30336,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',12783.42,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2168,NULL,40920,30336,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',24890.00,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2169,NULL,40920,30336,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',2899.99,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2170,NULL,40920,30336,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',14194.99,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2171,NULL,40920,30336,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',32487.00,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2172,NULL,40920,30336,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',11799.00,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2173,NULL,40920,30336,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',6840.00,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2174,NULL,40920,30336,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',5398.00,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2175,NULL,40920,30336,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',13682.01,NULL,NULL,1,'2023-12-26 14:23:38','2023-12-26 14:23:38',NULL),(2176,NULL,40920,30336,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',5052.85,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2177,NULL,40920,30336,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',2499.00,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2178,NULL,40920,30336,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',4998.99,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2179,NULL,40920,30336,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',14830.14,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2180,NULL,40920,30336,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',9736.94,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2181,NULL,40920,30336,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',13198.99,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2182,NULL,40920,30336,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',580.00,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2183,NULL,40920,30336,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',13938.30,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL);
INSERT INTO `balance_libro` VALUES (2184,NULL,40920,30336,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',20907.44,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2185,NULL,40920,30336,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',17499.00,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2186,NULL,40920,30336,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',6597.00,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2187,NULL,40920,30336,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',2899.99,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2188,NULL,40920,30336,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',2398.99,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2189,NULL,40920,30336,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',500.00,NULL,NULL,1,'2023-12-26 14:23:39','2023-12-26 14:23:39',NULL),(2190,NULL,40920,30336,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',13198.99,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2191,NULL,40920,30336,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',47980.00,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2192,NULL,40920,30336,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',21299.00,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2193,NULL,40920,30336,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',6625.96,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2194,NULL,40920,30336,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',14194.99,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2195,NULL,40920,30336,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',11799.00,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2196,NULL,40920,30336,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',2398.99,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2197,NULL,40920,30336,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',1875.00,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2198,NULL,40920,30336,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',14194.99,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2199,NULL,40920,30336,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',426.00,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2200,NULL,40920,30336,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',14194.99,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2201,NULL,40920,30336,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',9445.01,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2202,NULL,40920,30336,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',13198.99,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2203,NULL,40920,30336,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',14194.99,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2204,NULL,40920,30336,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',17594.15,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL);
INSERT INTO `balance_libro` VALUES (2205,NULL,40920,30336,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',4100.00,NULL,NULL,1,'2023-12-26 14:23:40','2023-12-26 14:23:40',NULL),(2206,NULL,40920,30336,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',14194.99,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2207,NULL,40920,30336,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',20907.44,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2208,NULL,40920,30336,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',14194.99,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2209,NULL,40920,30336,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',13938.30,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2210,NULL,40920,30336,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',2499.00,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2211,NULL,40920,30336,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',17362.00,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2212,NULL,40920,30336,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',12849.99,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2213,NULL,40920,30336,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',14194.99,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2214,NULL,40920,30336,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',3999.00,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2215,NULL,40920,30336,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',3465.94,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2216,NULL,40920,30336,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',7199.00,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2217,NULL,40920,30336,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',10336.36,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2218,NULL,40920,30336,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',13938.30,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2219,NULL,40920,30336,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',16594.00,NULL,NULL,1,'2023-12-26 14:23:41','2023-12-26 14:23:41',NULL),(2220,NULL,40920,30336,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',3971.99,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2221,NULL,40920,30336,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',3971.92,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2222,NULL,40920,30336,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',11995.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2223,NULL,40920,30336,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',7199.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2224,NULL,40920,30336,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',3480.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2225,NULL,40920,30336,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',17069.07,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL);
INSERT INTO `balance_libro` VALUES (2226,NULL,40920,30336,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',12849.99,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2227,NULL,40920,30336,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',16098.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2228,NULL,40920,30336,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',14194.99,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2229,NULL,40920,30336,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',4299.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2230,NULL,40920,30336,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',4699.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2231,NULL,40920,30336,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',3499.01,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2232,NULL,40920,30336,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',9596.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2233,NULL,40920,30336,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',10397.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2234,NULL,40920,30336,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',12997.00,NULL,NULL,1,'2023-12-26 14:23:42','2023-12-26 14:23:42',NULL),(2235,NULL,40920,30336,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',6398.00,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2236,NULL,40920,30336,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',200.00,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2237,NULL,40920,30336,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',11250.00,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2238,NULL,40920,30336,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',2899.99,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2239,NULL,40920,30336,2,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',10225.94,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2240,NULL,40920,30336,2,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',13198.99,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2241,NULL,40920,30336,2,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',5399.00,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2242,NULL,40920,30336,2,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',33489.61,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2243,NULL,40920,30336,2,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',13198.99,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2244,NULL,40920,30336,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',4998.99,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2245,NULL,40920,30336,2,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',7399.00,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2246,NULL,40920,30336,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',9900.85,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL);
INSERT INTO `balance_libro` VALUES (2247,NULL,40920,30336,2,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',14194.99,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2248,NULL,40920,30336,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',7600.00,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2249,NULL,40920,30336,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',9796.99,NULL,NULL,1,'2023-12-26 14:23:43','2023-12-26 14:23:43',NULL),(2250,NULL,40920,30336,2,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',4998.99,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2251,NULL,40920,30336,2,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',4998.99,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2252,NULL,40920,30336,2,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',13499.00,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2253,NULL,40920,30336,2,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',4299.00,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2254,NULL,40920,30336,2,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',22014.15,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2255,NULL,40920,30336,2,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',6498.99,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2256,NULL,40920,30336,2,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2199.01,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2257,NULL,40920,30336,2,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',500.00,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2258,NULL,40920,30336,2,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',11541.13,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2259,NULL,40920,30336,2,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2398.99,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2260,NULL,40920,30336,2,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',11799.00,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2261,NULL,40920,30336,2,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',1305.00,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2262,NULL,40920,30336,2,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',580.00,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2263,NULL,40920,30336,2,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',6996.99,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2264,NULL,40920,30336,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2398.99,NULL,NULL,1,'2023-12-26 14:23:44','2023-12-26 14:23:44',NULL),(2265,NULL,40920,30336,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',200.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2266,NULL,40920,30336,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',14194.99,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2267,NULL,40920,30336,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',4299.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL);
INSERT INTO `balance_libro` VALUES (2268,NULL,40920,30336,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',27876.60,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2269,NULL,40920,30336,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2899.99,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2270,NULL,40920,30336,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2398.99,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2271,NULL,40920,30336,2,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',11397.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2272,NULL,40920,30336,2,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',4900.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2273,NULL,40920,30336,2,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',8200.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2274,NULL,40920,30336,2,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',580.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2275,NULL,40920,30336,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',290.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2276,NULL,40920,30336,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',3599.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2277,NULL,40920,30336,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',44602.26,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2278,NULL,40920,30336,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',9399.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2279,NULL,40920,30336,2,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',10234.00,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2280,NULL,40920,30336,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',7539.99,NULL,NULL,1,'2023-12-26 14:23:45','2023-12-26 14:23:45',NULL),(2281,NULL,40920,30336,2,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',11799.00,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2282,NULL,40920,30336,2,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',4299.00,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2283,NULL,40920,30336,2,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',32979.16,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2284,NULL,40920,30336,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',12244.99,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2285,NULL,40920,30336,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',22014.15,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2286,NULL,40920,30336,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',20907.44,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2287,NULL,40920,30336,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2899.99,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2288,NULL,40920,30336,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',19114.20,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL);
INSERT INTO `balance_libro` VALUES (2289,NULL,40920,30336,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',14194.99,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2290,NULL,40920,30336,2,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',10845.00,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2291,NULL,40920,30336,2,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2899.99,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2292,NULL,40920,30336,2,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',10194.00,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2293,NULL,40920,30336,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',41814.90,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2294,NULL,40920,30336,2,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',27876.60,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2295,NULL,40920,30336,2,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',13938.30,NULL,NULL,1,'2023-12-26 14:23:46','2023-12-26 14:23:46',NULL),(2296,NULL,40920,30336,2,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',499.00,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2297,NULL,40920,30336,2,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2899.99,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2298,NULL,40920,30336,2,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',17145.95,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2299,NULL,40920,30336,2,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',14194.99,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2300,NULL,40920,30336,2,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',10374.00,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2301,NULL,40920,30336,2,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',17699.00,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2302,NULL,40920,30336,2,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2398.99,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2303,NULL,40920,30336,2,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',7699.00,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2304,NULL,40920,30336,2,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',21299.00,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2305,NULL,40920,30336,2,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',10260.00,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2306,NULL,40920,30336,2,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2899.99,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2307,NULL,40920,30336,2,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',10695.00,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2308,NULL,40920,30336,2,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',16299.00,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2309,NULL,40920,30336,2,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',14194.99,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL);
INSERT INTO `balance_libro` VALUES (2310,NULL,40920,30336,2,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',14194.99,NULL,NULL,1,'2023-12-26 14:23:47','2023-12-26 14:23:47',NULL),(2311,NULL,40920,30336,2,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',11795.00,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2312,NULL,40920,30336,2,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',20907.44,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2313,NULL,40920,30336,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',20907.44,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2314,NULL,40920,30336,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2899.99,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2315,NULL,40920,30336,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',17999.00,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2316,NULL,40920,30336,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',11799.00,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2317,NULL,40920,30336,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',12195.00,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2318,NULL,40920,30336,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',580.00,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2319,NULL,40920,30336,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',14299.01,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2320,NULL,40920,30336,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',269.00,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2321,NULL,40920,30336,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',13198.99,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2322,NULL,40920,30336,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',1875.00,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2323,NULL,40920,30336,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',15196.00,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2324,NULL,40920,30336,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2899.99,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2325,NULL,40920,30336,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',31704.15,NULL,NULL,1,'2023-12-26 14:23:48','2023-12-26 14:23:48',NULL),(2326,NULL,40920,30336,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',6840.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2327,NULL,40920,30336,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',21241.01,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2328,NULL,40920,30336,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',14583.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2329,NULL,40920,30336,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',2860.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2330,NULL,40920,30336,2,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',12399.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL);
INSERT INTO `balance_libro` VALUES (2331,NULL,40920,30336,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',27876.60,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2332,NULL,40920,30336,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',1344.99,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2333,NULL,40920,30336,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',3999.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2334,NULL,40920,30336,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',12399.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2335,NULL,40920,30336,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',103500.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2336,NULL,40920,30336,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',37800.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2337,NULL,40920,30336,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3999.00,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2338,NULL,40920,30336,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',2899.99,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2339,NULL,40920,30336,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',14194.99,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2340,NULL,40920,30336,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',14299.01,NULL,NULL,1,'2023-12-26 14:23:49','2023-12-26 14:23:49',NULL),(2341,NULL,40920,30336,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',15899.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2342,NULL,40920,30336,2,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',11799.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2343,NULL,40920,30336,2,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2344,NULL,40920,30336,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',11997.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2345,NULL,40920,30336,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',22014.15,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2346,NULL,40920,30336,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20040.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2347,NULL,40920,30336,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4699.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2348,NULL,40920,30336,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20699.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2349,NULL,40920,30336,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',16594.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2350,NULL,40920,30336,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',2398.99,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2351,NULL,40920,30336,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',10846.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL);
INSERT INTO `balance_libro` VALUES (2352,NULL,40920,30336,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',9196.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2353,NULL,40920,30336,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4898.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2354,NULL,40920,30336,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3750.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2355,NULL,40920,30336,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',499.00,NULL,NULL,1,'2023-12-26 14:23:50','2023-12-26 14:23:50',NULL),(2356,NULL,40920,30336,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2357,NULL,40920,30336,2,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1890.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2358,NULL,40920,30336,2,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3809.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2359,NULL,40920,30336,2,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',7199.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2360,NULL,40920,30336,2,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',16699.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2361,NULL,40920,30336,2,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3499.01,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2362,NULL,40920,30336,2,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',714.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2363,NULL,40920,30336,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1244.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2364,NULL,40920,30336,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1980.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2365,NULL,40920,30336,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',5309.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2366,NULL,40920,30336,2,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1441.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2367,NULL,40920,30336,2,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',11995.00,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2368,NULL,40920,30336,2,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2369,NULL,40920,30336,2,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1613.99,NULL,NULL,1,'2023-12-26 14:23:51','2023-12-26 14:23:51',NULL),(2370,NULL,40920,30336,2,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4699.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2371,NULL,40920,30336,2,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',2199.01,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2372,NULL,40920,30336,2,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL);
INSERT INTO `balance_libro` VALUES (2373,NULL,40920,30336,2,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',9798.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2374,NULL,40920,30336,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3999.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2375,NULL,40920,30336,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',599.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2376,NULL,40920,30336,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1399.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2377,NULL,40920,30336,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',8199.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2378,NULL,40920,30336,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',714.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2379,NULL,40920,30336,2,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',599.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2380,NULL,40920,30336,2,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',8199.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2381,NULL,40920,30336,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',32979.16,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2382,NULL,40920,30336,2,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4998.99,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2383,NULL,40920,30336,2,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',22491.00,NULL,NULL,1,'2023-12-26 14:23:52','2023-12-26 14:23:52',NULL),(2384,NULL,40920,30336,2,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',599.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2385,NULL,40920,30336,2,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',18999.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2386,NULL,40920,30336,2,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4699.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2387,NULL,40920,30336,2,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',714.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2388,NULL,40920,30336,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',994.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2389,NULL,40920,30336,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20907.44,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2390,NULL,40920,30336,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',6799.99,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2391,NULL,40920,30336,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',15594.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2392,NULL,40920,30336,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',13794.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2393,NULL,40920,30336,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',13898.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL);
INSERT INTO `balance_libro` VALUES (2394,NULL,40920,30336,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',7196.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2395,NULL,40920,30336,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2396,NULL,40920,30336,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',13647.74,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2397,NULL,40920,30336,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',8496.00,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2398,NULL,40920,30336,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3391.50,NULL,NULL,1,'2023-12-26 14:23:53','2023-12-26 14:23:53',NULL),(2399,NULL,40920,30336,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',27990.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2400,NULL,40920,30336,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3671.75,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2401,NULL,40920,30336,2,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',12897.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2402,NULL,40920,30336,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',7299.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2403,NULL,40920,30336,2,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',9996.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2404,NULL,40920,30336,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',7500.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2405,NULL,40920,30336,2,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3391.50,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2406,NULL,40920,30336,2,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',21495.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2407,NULL,40920,30336,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',25995.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2408,NULL,40920,30336,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',10029.15,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2409,NULL,40920,30336,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2410,NULL,40920,30336,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1785.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2411,NULL,40920,30336,2,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',29358.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2412,NULL,40920,30336,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20520.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2413,NULL,40920,30336,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',7898.00,NULL,NULL,1,'2023-12-26 14:23:54','2023-12-26 14:23:54',NULL),(2414,NULL,40920,30336,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',7578.00,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL);
INSERT INTO `balance_libro` VALUES (2415,NULL,40920,30336,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',2142.00,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2416,NULL,40920,30336,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20907.44,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2417,NULL,40920,30336,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',29790.24,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2418,NULL,40920,30336,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',10029.15,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2419,NULL,40920,30336,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1792.49,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2420,NULL,40920,30336,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',12897.00,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2421,NULL,40920,30336,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4899.00,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2422,NULL,40920,30336,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',16398.00,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2423,NULL,40920,30336,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4998.99,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2424,NULL,40920,30336,2,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2425,NULL,40920,30336,2,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1244.00,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2426,NULL,40920,30336,2,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20907.44,NULL,NULL,1,'2023-12-26 14:23:55','2023-12-26 14:23:55',NULL),(2427,NULL,40920,30336,2,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4998.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2428,NULL,40920,30336,2,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2429,NULL,40920,30336,2,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',132000.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2430,NULL,40920,30336,2,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1785.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2431,NULL,40920,30336,2,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',11495.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2432,NULL,40920,30336,2,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',32970.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2433,NULL,40920,30336,2,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',21698.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2434,NULL,40920,30336,2,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3569.98,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2435,NULL,40920,30336,2,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',5598.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL);
INSERT INTO `balance_libro` VALUES (2436,NULL,40920,30336,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',6397.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2437,NULL,40920,30336,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',2677.50,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2438,NULL,40920,30336,2,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4299.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2439,NULL,40920,30336,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4398.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2440,NULL,40920,30336,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',18398.00,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2441,NULL,40920,30336,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',5798.01,NULL,NULL,1,'2023-12-26 14:23:56','2023-12-26 14:23:56',NULL),(2442,NULL,40920,30336,2,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4998.99,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2443,NULL,40920,30336,2,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',9799.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2444,NULL,40920,30336,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',2799.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2445,NULL,40920,30336,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',21299.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2446,NULL,40920,30336,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10072.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2447,NULL,40920,30336,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',3798.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2448,NULL,40920,30336,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',2142.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2449,NULL,40920,30336,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4699.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2450,NULL,40920,30336,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',8397.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2451,NULL,40920,30336,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',18593.01,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2452,NULL,40920,30336,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',39596.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2453,NULL,40920,30336,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',3569.98,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2454,NULL,40920,30336,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',3499.01,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2455,NULL,40920,30336,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4199.00,NULL,NULL,1,'2023-12-26 14:23:57','2023-12-26 14:23:57',NULL),(2456,NULL,40920,30336,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4100.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL);
INSERT INTO `balance_libro` VALUES (2457,NULL,40920,30336,2,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',2799.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2458,NULL,40920,30336,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',599.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2459,NULL,40920,30336,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',17720.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2460,NULL,40920,30336,2,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',11196.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2461,NULL,40920,30336,2,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',21398.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2462,NULL,40920,30336,2,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',5598.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2463,NULL,40920,30336,2,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',18999.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2464,NULL,40920,30336,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',8199.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2465,NULL,40920,30336,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',6297.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2466,NULL,40920,30336,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',1654.99,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2467,NULL,40920,30336,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',11718.95,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2468,NULL,40920,30336,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',9996.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2469,NULL,40920,30336,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4798.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2470,NULL,40920,30336,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',2799.00,NULL,NULL,1,'2023-12-26 14:23:58','2023-12-26 14:23:58',NULL),(2471,NULL,40920,30336,2,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',22197.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2472,NULL,40920,30336,2,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',5399.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2473,NULL,40920,30336,2,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',5670.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2474,NULL,40920,30336,2,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10029.15,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2475,NULL,40920,30336,2,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',18999.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2476,NULL,40920,30336,2,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',18999.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2477,NULL,40920,30336,2,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',29699.99,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL);
INSERT INTO `balance_libro` VALUES (2478,NULL,40920,30336,2,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',17593.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2479,NULL,40920,30336,2,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',14299.01,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2480,NULL,40920,30336,2,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',19996.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2481,NULL,40920,30336,2,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',19299.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2482,NULL,40920,30336,2,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',13938.30,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2483,NULL,40920,30336,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10029.15,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2484,NULL,40920,30336,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',7699.00,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2485,NULL,40920,30336,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',74998.99,NULL,NULL,1,'2023-12-26 14:23:59','2023-12-26 14:23:59',NULL),(2486,NULL,40920,30336,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10899.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2487,NULL,40920,30336,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',24599.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2488,NULL,40920,30336,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10029.15,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2489,NULL,40920,30336,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10798.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2490,NULL,40920,30336,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',2799.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2491,NULL,40920,30336,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',14598.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2492,NULL,40920,30336,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',3034.50,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2493,NULL,40920,30336,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',6400.73,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2494,NULL,40920,30336,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4699.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2495,NULL,40920,30336,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',16295.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2496,NULL,40920,30336,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',599.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2497,NULL,40920,30336,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',74998.99,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2498,NULL,40920,30336,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',15995.99,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL);
INSERT INTO `balance_libro` VALUES (2499,NULL,40920,30336,2,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',15499.00,NULL,NULL,1,'2023-12-26 14:24:00','2023-12-26 14:24:00',NULL),(2500,NULL,40920,30336,2,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',13198.99,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2501,NULL,40920,30336,2,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',95112.45,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2502,NULL,40920,30336,2,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',16267.16,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2503,NULL,40920,30336,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10029.15,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2504,NULL,40920,30336,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',11596.00,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2505,NULL,40920,30336,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',13121.95,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2506,NULL,40920,30336,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',19299.00,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2507,NULL,40920,30336,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',2899.99,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2508,NULL,40920,30336,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',8797.99,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2509,NULL,40920,30336,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',24721.20,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2510,NULL,40920,30336,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',17394.00,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2511,NULL,40920,30336,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10029.15,NULL,NULL,1,'2023-12-26 14:24:01','2023-12-26 14:24:01',NULL),(2512,NULL,40920,30336,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',8693.86,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2513,NULL,40920,30336,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',6598.00,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2514,NULL,40920,30336,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',1792.49,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2515,NULL,40920,30336,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',9264.15,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2516,NULL,40920,30336,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',15899.00,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2517,NULL,40920,30336,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',7175.00,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2518,NULL,40920,30336,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10029.15,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2519,NULL,40920,30336,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',9699.00,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL);
INSERT INTO `balance_libro` VALUES (2520,NULL,40920,30336,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10029.15,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2521,NULL,40920,30336,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4399.00,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2522,NULL,40920,30336,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',6498.99,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2523,NULL,40920,30336,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',464.40,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2524,NULL,40920,30336,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',5799.00,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2525,NULL,40920,30336,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',8097.01,NULL,NULL,1,'2023-12-26 14:24:02','2023-12-26 14:24:02',NULL),(2526,NULL,40920,30336,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',2499.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2527,NULL,40920,30336,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',19110.46,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2528,NULL,40920,30336,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',8860.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2529,NULL,40920,30336,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',9998.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2530,NULL,40920,30336,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',1613.99,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2531,NULL,40920,30336,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',31449.15,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2532,NULL,40920,30336,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',44000.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2533,NULL,40920,30336,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',7494.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2534,NULL,40920,30336,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',11596.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2535,NULL,40920,30336,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',4998.99,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2536,NULL,40920,30336,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',29097.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2537,NULL,40920,30336,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',54388.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2538,NULL,40920,30336,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3213.00,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2539,NULL,40920,30336,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',4996.01,NULL,NULL,1,'2023-12-26 14:24:03','2023-12-26 14:24:03',NULL),(2540,NULL,40920,30336,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',13497.01,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL);
INSERT INTO `balance_libro` VALUES (2541,NULL,40920,30336,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3569.98,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2542,NULL,40920,30336,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',7095.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2543,NULL,40920,30336,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',18999.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2544,NULL,40920,30336,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',4699.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2545,NULL,40920,30336,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3299.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2546,NULL,40920,30336,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',18999.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2547,NULL,40920,30336,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',22014.15,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2548,NULL,40920,30336,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',2899.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2549,NULL,40920,30336,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',11893.01,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2550,NULL,40920,30336,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',16195.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2551,NULL,40920,30336,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',6900.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2552,NULL,40920,30336,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',18999.00,NULL,NULL,1,'2023-12-26 14:24:04','2023-12-26 14:24:04',NULL),(2553,NULL,40920,30336,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',12798.00,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2554,NULL,40920,30336,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',1785.00,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2555,NULL,40920,30336,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3569.98,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2556,NULL,40920,30336,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',21399.00,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2557,NULL,40920,30336,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',10029.15,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2558,NULL,40920,30336,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',19428.15,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2559,NULL,40920,30336,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',15300.00,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2560,NULL,40920,30336,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3569.98,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2561,NULL,40920,30336,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3569.98,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL);
INSERT INTO `balance_libro` VALUES (2562,NULL,40920,30336,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',9699.00,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2563,NULL,40920,30336,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',6598.00,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2564,NULL,40920,30336,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',6399.00,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2565,NULL,40920,30336,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',2856.00,NULL,NULL,1,'2023-12-26 14:24:05','2023-12-26 14:24:05',NULL),(2566,NULL,40920,30336,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',97182.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2567,NULL,40920,30336,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3698.99,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2568,NULL,40920,30336,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',1899.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2569,NULL,40920,30336,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',2699.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2570,NULL,40920,30336,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',4699.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2571,NULL,40920,30336,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3199.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2572,NULL,40920,30336,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3569.98,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2573,NULL,40920,30336,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',21798.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2574,NULL,40920,30336,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',17699.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2575,NULL,40920,30336,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',9897.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2576,NULL,40920,30336,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3569.98,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2577,NULL,40920,30336,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',599.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2578,NULL,40920,30336,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3299.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2579,NULL,40920,30336,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',27792.45,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2580,NULL,40920,30336,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',13495.00,NULL,NULL,1,'2023-12-26 14:24:06','2023-12-26 14:24:06',NULL),(2581,NULL,40920,30336,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',786.00,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2582,NULL,40920,30336,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',6571.33,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL);
INSERT INTO `balance_libro` VALUES (2583,NULL,40920,30336,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',9398.00,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2584,NULL,40920,30336,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',15895.00,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2585,NULL,40920,30336,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',14097.00,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2586,NULL,40920,30336,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',12239.15,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2587,NULL,40920,30336,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',1172.50,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2588,NULL,40920,30336,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3299.00,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2589,NULL,40920,30336,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',17594.15,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2590,NULL,40920,30336,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',6598.00,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2591,NULL,40920,30336,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',558.92,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2592,NULL,40920,30336,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',73835.08,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2593,NULL,40920,30336,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',11598.00,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2594,NULL,40920,30336,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',13898.00,NULL,NULL,1,'2023-12-26 14:24:07','2023-12-26 14:24:07',NULL),(2595,NULL,40920,30336,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',16996.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2596,NULL,40920,30336,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',12798.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2597,NULL,40920,30336,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',6598.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2598,NULL,40920,30336,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',7395.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2599,NULL,40920,30336,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',21299.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2600,NULL,40920,30336,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',4998.99,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2601,NULL,40920,30336,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3569.98,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2602,NULL,40920,30336,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',27798.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2603,NULL,40920,30336,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',1654.99,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL);
INSERT INTO `balance_libro` VALUES (2604,NULL,40920,30336,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',2499.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2605,NULL,40920,30336,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',12147.95,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2606,NULL,40920,30336,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',9264.15,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2607,NULL,40920,30336,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',18600.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2608,NULL,40920,30336,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',22014.15,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2609,NULL,40920,30336,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',11596.00,NULL,NULL,1,'2023-12-26 14:24:08','2023-12-26 14:24:08',NULL),(2610,NULL,40920,30336,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',4699.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2611,NULL,40920,30336,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',6198.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2612,NULL,40920,30336,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3569.98,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2613,NULL,40920,30336,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',8697.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2614,NULL,40920,30336,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',2899.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2615,NULL,40920,30336,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',599.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2616,NULL,40920,30336,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',11814.15,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2617,NULL,40920,30336,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',22537.21,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2618,NULL,40920,30336,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',2345.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2619,NULL,40920,30336,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3299.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2620,NULL,40920,30336,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',35869.16,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2621,NULL,40920,30336,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',6498.99,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2622,NULL,40920,30336,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',2899.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2623,NULL,40920,30336,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',16194.00,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL),(2624,NULL,40920,30336,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',12239.15,NULL,NULL,1,'2023-12-26 14:24:09','2023-12-26 14:24:09',NULL);
INSERT INTO `balance_libro` VALUES (2625,NULL,40920,30336,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',1048.01,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2626,NULL,40920,30336,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',6598.00,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2627,NULL,40920,30336,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',7196.00,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2628,NULL,40920,30336,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',23661.71,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2629,NULL,40920,30336,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',7625.00,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2630,NULL,40920,30336,2,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',994.00,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2631,NULL,40920,30336,2,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3299.00,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2632,NULL,40920,30336,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',14167.45,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2633,NULL,40920,30336,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',599.00,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2634,NULL,40920,30336,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',5399.00,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2635,NULL,40920,30336,2,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',24819.14,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2636,NULL,40920,30336,2,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',4699.00,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2637,NULL,40920,30336,2,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',1613.99,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2638,NULL,40920,30336,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',15314.46,NULL,NULL,1,'2023-12-26 14:24:10','2023-12-26 14:24:10',NULL),(2639,NULL,40920,30336,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',21399.00,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2640,NULL,40920,30336,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3099.00,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2641,NULL,40920,30336,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',2365.01,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2642,NULL,40920,30336,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',6598.00,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2643,NULL,40920,30336,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',2899.00,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2644,NULL,40920,30336,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',33996.00,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2645,NULL,40920,30336,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',12597.00,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL);
INSERT INTO `balance_libro` VALUES (2646,NULL,40920,30336,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',13196.01,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2647,NULL,40920,30336,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',3569.98,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2648,NULL,40920,30336,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',19276.76,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2649,NULL,40920,30336,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',26399.01,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2650,NULL,40920,30336,2,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',10200.00,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2651,NULL,40920,30336,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',3299.00,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2652,NULL,40920,30336,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',1613.99,NULL,NULL,1,'2023-12-26 14:24:11','2023-12-26 14:24:11',NULL),(2653,NULL,40920,30336,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',48619.16,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2654,NULL,40920,30336,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',6675.95,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2655,NULL,40920,30336,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',6198.00,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2656,NULL,40920,30336,2,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',10899.00,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2657,NULL,40920,30336,2,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',2699.00,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2658,NULL,40920,30336,2,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',14174.36,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2659,NULL,40920,30336,2,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',20899.00,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2660,NULL,40920,30336,2,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',11596.00,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2661,NULL,40920,30336,2,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',13196.01,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2662,NULL,40920,30336,2,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',3569.98,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2663,NULL,40920,30336,2,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',9699.00,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2664,NULL,40920,30336,2,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',4998.99,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2665,NULL,40920,30336,2,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',5100.00,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL),(2666,NULL,40920,30336,2,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',1244.00,NULL,NULL,1,'2023-12-26 14:24:12','2023-12-26 14:24:12',NULL);
INSERT INTO `balance_libro` VALUES (2667,NULL,40920,30336,2,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',7584.92,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2668,NULL,40920,30336,2,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',27197.00,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2669,NULL,40920,30336,2,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',6498.99,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2670,NULL,40920,30336,2,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',19498.00,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2671,NULL,40920,30336,2,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',34679.14,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2672,NULL,40920,30336,2,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',24686.47,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2673,NULL,40920,30336,2,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',16199.00,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2674,NULL,40920,30336,2,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',7366.73,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2675,NULL,40920,30336,2,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',6598.00,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2676,NULL,40920,30336,2,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',9796.00,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2677,NULL,40920,30336,2,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',3569.98,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2678,NULL,40920,30336,2,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',9399.00,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2679,NULL,40920,30336,2,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',1613.99,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2680,NULL,40920,30336,2,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',18528.29,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2681,NULL,40920,30336,2,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',11598.00,NULL,NULL,1,'2023-12-26 14:24:13','2023-12-26 14:24:13',NULL),(2682,NULL,40920,30336,2,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',5542.54,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2683,NULL,40920,30336,2,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',18528.29,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2684,NULL,40920,30336,2,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',12798.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2685,NULL,40920,30336,2,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',3034.50,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2686,NULL,40920,30336,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',8397.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2687,NULL,40920,30336,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',132800.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL);
INSERT INTO `balance_libro` VALUES (2688,NULL,40920,30336,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',16199.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2689,NULL,40920,30336,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',164999.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2690,NULL,40920,30336,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',714.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2691,NULL,40920,30336,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',2899.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2692,NULL,40920,30336,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',15899.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2693,NULL,40920,30336,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',22999.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2694,NULL,40920,30336,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',9699.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2695,NULL,40920,30336,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',18699.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2696,NULL,40920,30336,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',32990.00,NULL,NULL,1,'2023-12-26 14:24:14','2023-12-26 14:24:14',NULL),(2697,NULL,40920,30336,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',9398.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2698,NULL,40920,30336,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',6598.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2699,NULL,40920,30336,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',24819.14,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2700,NULL,40920,30336,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',4076.49,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2701,NULL,40920,30336,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',6399.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2702,NULL,40920,30336,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',1134.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2703,NULL,40920,30336,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',34455.31,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2704,NULL,40920,30336,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',6598.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2705,NULL,40920,30336,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',10165.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2706,NULL,40920,30336,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',24819.14,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2707,NULL,40920,30336,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',6200.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2708,NULL,40920,30336,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',6498.99,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL);
INSERT INTO `balance_libro` VALUES (2709,NULL,40920,30336,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',3299.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2710,NULL,40920,30336,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',994.00,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2711,NULL,40920,30336,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',19039.14,NULL,NULL,1,'2023-12-26 14:24:15','2023-12-26 14:24:15',NULL),(2712,NULL,40920,30336,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',714.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2713,NULL,40920,30336,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',8943.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2714,NULL,40920,30336,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',2677.50,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2715,NULL,40920,30336,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',16199.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2716,NULL,40920,30336,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',599.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2717,NULL,40920,30336,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',40788.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2718,NULL,40920,30336,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',3569.98,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2719,NULL,40920,30336,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',8898.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2720,NULL,40920,30336,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',37056.60,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2721,NULL,40920,30336,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',5399.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2722,NULL,40920,30336,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',11999.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2723,NULL,40920,30336,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',1172.50,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2724,NULL,40920,30336,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',599.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2725,NULL,40920,30336,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',5598.00,NULL,NULL,1,'2023-12-26 14:24:16','2023-12-26 14:24:16',NULL),(2726,NULL,40920,30336,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',10497.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2727,NULL,40920,30336,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',12998.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2728,NULL,40920,30336,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',21798.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2729,NULL,40920,30336,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',3569.98,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL);
INSERT INTO `balance_libro` VALUES (2730,NULL,40920,30336,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',4350.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2731,NULL,40920,30336,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',21798.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2732,NULL,40920,30336,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',14697.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2733,NULL,40920,30336,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',2499.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2734,NULL,40920,30336,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',1963.50,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2735,NULL,40920,30336,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',8911.86,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2736,NULL,40920,30336,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',2199.01,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2737,NULL,40920,30336,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',6998.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2738,NULL,40920,30336,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',43596.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2739,NULL,40920,30336,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',3569.98,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2740,NULL,40920,30336,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',3299.00,NULL,NULL,1,'2023-12-26 14:24:17','2023-12-26 14:24:17',NULL),(2741,NULL,40920,30336,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',19497.00,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2742,NULL,40920,30336,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',25996.00,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2743,NULL,40920,30336,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',6998.00,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2744,NULL,40920,30336,2,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',9352.49,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2745,NULL,40920,30336,2,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',5399.00,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2746,NULL,40920,30336,2,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',3499.01,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2747,NULL,40920,30336,2,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',16330.00,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2748,NULL,40920,30336,2,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',534.61,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2749,NULL,40920,30336,2,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',17784.59,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2750,NULL,40920,30336,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',6498.99,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL);
INSERT INTO `balance_libro` VALUES (2751,NULL,40920,30336,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',8898.00,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2752,NULL,40920,30336,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3034.50,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2753,NULL,40920,30336,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',12798.00,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2754,NULL,40920,30336,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',15948.01,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2755,NULL,40920,30336,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',18975.00,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2756,NULL,40920,30336,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3569.98,NULL,NULL,1,'2023-12-26 14:24:18','2023-12-26 14:24:18',NULL),(2757,NULL,40920,30336,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',13293.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2758,NULL,40920,30336,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',9699.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2759,NULL,40920,30336,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',4853.56,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2760,NULL,40920,30336,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',15699.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2761,NULL,40920,30336,2,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',599.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2762,NULL,40920,30336,2,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',16199.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2763,NULL,40920,30336,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',16199.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2764,NULL,40920,30336,2,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3099.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2765,NULL,40920,30336,2,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',8226.94,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2766,NULL,40920,30336,2,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',11897.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2767,NULL,40920,30336,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3569.98,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2768,NULL,40920,30336,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',599.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2769,NULL,40920,30336,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',6998.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2770,NULL,40920,30336,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',5100.00,NULL,NULL,1,'2023-12-26 14:24:19','2023-12-26 14:24:19',NULL),(2771,NULL,40920,30336,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',9264.15,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL);
INSERT INTO `balance_libro` VALUES (2772,NULL,40920,30336,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',16196.00,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2773,NULL,40920,30336,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3569.98,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2774,NULL,40920,30336,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',8097.01,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2775,NULL,40920,30336,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',2677.50,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2776,NULL,40920,30336,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',39354.15,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2777,NULL,40920,30336,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3299.00,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2778,NULL,40920,30336,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',9264.15,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2779,NULL,40920,30336,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',19039.14,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2780,NULL,40920,30336,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3499.01,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2781,NULL,40920,30336,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',17720.00,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2782,NULL,40920,30336,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',26411.14,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2783,NULL,40920,30336,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3569.98,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2784,NULL,40920,30336,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',25584.00,NULL,NULL,1,'2023-12-26 14:24:20','2023-12-26 14:24:20',NULL),(2785,NULL,40920,30336,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3099.00,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2786,NULL,40920,30336,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',8499.00,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2787,NULL,40920,30336,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',1613.99,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2788,NULL,40920,30336,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',8828.99,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2789,NULL,40920,30336,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',25509.81,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2790,NULL,40920,30336,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',6998.00,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2791,NULL,40920,30336,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',20757.03,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2792,NULL,40920,30336,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',714.00,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL);
INSERT INTO `balance_libro` VALUES (2793,NULL,40920,30336,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',14097.00,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2794,NULL,40920,30336,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',19039.14,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2795,NULL,40920,30336,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',18528.29,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2796,NULL,40920,30336,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',19039.14,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2797,NULL,40920,30336,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',13996.00,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2798,NULL,40920,30336,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',10183.14,NULL,NULL,1,'2023-12-26 14:24:21','2023-12-26 14:24:21',NULL),(2799,NULL,40920,30336,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',16199.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2800,NULL,40920,30336,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',6399.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2801,NULL,40920,30336,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',1134.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2802,NULL,40920,30336,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',25584.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2803,NULL,40920,30336,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',10497.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2804,NULL,40920,30336,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',2856.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2805,NULL,40920,30336,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3499.01,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2806,NULL,40920,30336,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',21144.06,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2807,NULL,40920,30336,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3569.98,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2808,NULL,40920,30336,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',19039.14,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2809,NULL,40920,30336,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',12396.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2810,NULL,40920,30336,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',599.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2811,NULL,40920,30336,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',8207.94,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2812,NULL,40920,30336,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',11999.00,NULL,NULL,1,'2023-12-26 14:24:22','2023-12-26 14:24:22',NULL),(2813,NULL,40920,30336,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',19039.14,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL);
INSERT INTO `balance_libro` VALUES (2814,NULL,40920,30336,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',6399.00,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2815,NULL,40920,30336,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',19039.14,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2816,NULL,40920,30336,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',5098.00,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2817,NULL,40920,30336,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',12398.98,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2818,NULL,40920,30336,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',13996.00,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2819,NULL,40920,30336,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',11999.00,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2820,NULL,40920,30336,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',7499.00,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2821,NULL,40920,30336,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',4998.99,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2822,NULL,40920,30336,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',714.00,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2823,NULL,40920,30336,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',8525.94,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2824,NULL,40920,30336,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3213.00,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2825,NULL,40920,30336,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',36406.20,NULL,NULL,1,'2023-12-26 14:24:23','2023-12-26 14:24:23',NULL),(2826,NULL,40920,30336,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3499.01,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2827,NULL,40920,30336,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',599.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2828,NULL,40920,30336,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',18959.01,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2829,NULL,40920,30336,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',13996.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2830,NULL,40920,30336,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',599.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2831,NULL,40920,30336,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',16197.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2832,NULL,40920,30336,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3569.98,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2833,NULL,40920,30336,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',9398.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2834,NULL,40920,30336,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3034.50,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL);
INSERT INTO `balance_libro` VALUES (2835,NULL,40920,30336,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',12798.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2836,NULL,40920,30336,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',12800.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2837,NULL,40920,30336,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',599.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2838,NULL,40920,30336,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',7398.00,NULL,NULL,1,'2023-12-26 14:24:24','2023-12-26 14:24:24',NULL),(2839,NULL,40920,30336,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',10497.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2840,NULL,40920,30336,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',2499.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2841,NULL,40920,30336,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',599.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2842,NULL,40920,30336,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',16199.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2843,NULL,40920,30336,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',17994.87,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2844,NULL,40920,30336,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',21299.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2845,NULL,40920,30336,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',6200.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2846,NULL,40920,30336,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3034.50,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2847,NULL,40920,30336,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1199.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2848,NULL,40920,30336,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',714.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2849,NULL,40920,30336,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',19039.14,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2850,NULL,40920,30336,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',5100.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2851,NULL,40920,30336,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',16199.00,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2852,NULL,40920,30336,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3499.01,NULL,NULL,1,'2023-12-26 14:24:25','2023-12-26 14:24:25',NULL),(2853,NULL,40920,30336,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',994.00,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2854,NULL,40920,30336,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',19039.14,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2855,NULL,40920,30336,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',19594.00,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL);
INSERT INTO `balance_libro` VALUES (2856,NULL,40920,30336,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',7250.01,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2857,NULL,40920,30336,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',33829.16,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2858,NULL,40920,30336,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',23174.49,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2859,NULL,40920,30336,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',10018.91,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2860,NULL,40920,30336,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',13996.00,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2861,NULL,40920,30336,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1785.00,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2862,NULL,40920,30336,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5100.00,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2863,NULL,40920,30336,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',637.00,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2864,NULL,40920,30336,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',8697.00,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2865,NULL,40920,30336,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',19039.14,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2866,NULL,40920,30336,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3598.00,NULL,NULL,1,'2023-12-26 14:24:26','2023-12-26 14:24:26',NULL),(2867,NULL,40920,30336,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1071.00,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2868,NULL,40920,30336,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',12998.00,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2869,NULL,40920,30336,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',9295.99,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2870,NULL,40920,30336,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6498.99,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2871,NULL,40920,30336,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',599.00,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2872,NULL,40920,30336,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',33203.45,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2873,NULL,40920,30336,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6998.00,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2874,NULL,40920,30336,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',59074.15,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2875,NULL,40920,30336,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',599.00,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2876,NULL,40920,30336,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3034.50,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL);
INSERT INTO `balance_libro` VALUES (2877,NULL,40920,30336,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',19039.14,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2878,NULL,40920,30336,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',714.00,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2879,NULL,40920,30336,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',9420.00,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2880,NULL,40920,30336,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2227.01,NULL,NULL,1,'2023-12-26 14:24:27','2023-12-26 14:24:27',NULL),(2881,NULL,40920,30336,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',16894.00,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2882,NULL,40920,30336,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',16199.00,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2883,NULL,40920,30336,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',714.00,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2884,NULL,40920,30336,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',4699.00,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2885,NULL,40920,30336,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',357.00,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2886,NULL,40920,30336,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',19039.14,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2887,NULL,40920,30336,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3499.01,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2888,NULL,40920,30336,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',34990.01,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2889,NULL,40920,30336,2,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3569.98,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2890,NULL,40920,30336,2,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',19039.14,NULL,NULL,1,'2023-12-26 14:24:28','2023-12-26 14:24:28',NULL),(2891,7902,40920,30336,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',457707.53,NULL,NULL,1,'2023-12-26 17:25:58','2023-12-26 17:25:58',NULL),(2892,7902,40920,30336,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',107364.30,NULL,NULL,1,'2023-12-26 17:25:58','2023-12-26 17:25:58',NULL),(2893,7902,40920,30336,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4450.00,NULL,NULL,1,'2023-12-26 17:25:58','2023-12-26 17:25:58',NULL),(2894,7902,40920,30336,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',58934.45,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2895,7902,40920,30336,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4950.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2896,7902,40920,30336,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4750.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2897,7902,40920,30336,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',7123.66,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL);
INSERT INTO `balance_libro` VALUES (2898,7902,40920,30336,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4750.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2899,7902,40920,30336,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4450.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2900,7902,40920,30336,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4750.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2901,7902,40920,30336,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',57269.75,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2902,7902,40920,30336,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',13900.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2903,7902,40920,30336,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',4400.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2904,7902,40920,30336,3,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',5200.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2905,7902,40920,30336,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',5060.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2906,7902,40920,30336,3,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',4450.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2907,7902,40920,30336,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',4750.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2908,7902,40920,30336,3,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',30250.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2909,7902,40920,30336,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',13962.15,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2910,7902,40920,30336,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',165999.00,NULL,NULL,1,'2023-12-26 17:25:59','2023-12-26 17:25:59',NULL),(2911,7902,40920,30336,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',3804632.75,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2912,7902,40920,30336,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',223835.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2913,7902,40920,30336,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',5100.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2914,7902,40920,30336,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',6100.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2915,7902,40920,30336,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',4800.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2916,7902,40920,30336,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',5850.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2917,7902,40920,30336,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',6100.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2918,7902,40920,30336,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',67657.92,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL);
INSERT INTO `balance_libro` VALUES (2919,7902,40920,30336,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',5902.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2920,7902,40920,30336,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',5500.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2921,7902,40920,30336,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',4800.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2922,7902,40920,30336,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',167811.16,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2923,7902,40920,30336,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',409899.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2924,7902,40920,30336,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4800.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2925,7902,40920,30336,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',33999.00,NULL,NULL,1,'2023-12-26 17:26:00','2023-12-26 17:26:00',NULL),(2926,7902,40920,30336,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',124222.94,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2927,7902,40920,30336,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',38817.66,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2928,7902,40920,30336,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',396559.17,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2929,7902,40920,30336,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',85523.94,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2930,7902,40920,30336,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',41038.88,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2931,7902,40920,30336,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',5100.00,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2932,7902,40920,30336,3,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',5100.00,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2933,7902,40920,30336,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',190800.00,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2934,7902,40920,30336,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',9400.00,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2935,7902,40920,30336,3,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',4800.00,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2936,7902,40920,30336,3,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',3216.72,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2937,7902,40920,30336,3,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',101659.30,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2938,7902,40920,30336,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4800.00,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL),(2939,7902,40920,30336,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',4950.00,NULL,NULL,1,'2023-12-26 17:26:01','2023-12-26 17:26:01',NULL);
INSERT INTO `balance_libro` VALUES (2940,7902,40920,30336,3,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',1876425.84,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2941,7902,40920,30336,3,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',88923.05,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2942,7902,40920,30336,3,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',145200.00,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2943,7902,40920,30336,3,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4800.00,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2944,7902,40920,30336,3,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',5750.00,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2945,7902,40920,30336,3,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1648.44,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2946,7902,40920,30336,3,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',5450.00,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2947,7902,40920,30336,3,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',3950.00,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2948,7902,40920,30336,3,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',72412.05,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2949,7902,40920,30336,3,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',120361.85,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2950,7902,40920,30336,3,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',6265.00,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2951,7902,40920,30336,3,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',5431.17,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2952,7902,40920,30336,3,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',18006.77,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2953,7902,40920,30336,3,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',32202.77,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2954,7902,40920,30336,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4800.00,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2955,7902,40920,30336,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4800.00,NULL,NULL,1,'2023-12-26 17:26:02','2023-12-26 17:26:02',NULL),(2956,7902,40920,30336,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',250929.99,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2957,7902,40920,30336,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',5100.00,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2958,7902,40920,30336,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4900.00,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2959,7902,40920,30336,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',5100.00,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2960,7902,40920,30336,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',4800.00,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL);
INSERT INTO `balance_libro` VALUES (2961,7902,40920,30336,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',47827.39,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2962,7902,40920,30336,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',5450.00,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2963,7902,40920,30336,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',850.50,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2964,7902,40920,30336,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',56036.59,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2965,7902,40920,30336,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',35660.94,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2966,7902,40920,30336,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',98390.27,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2967,7902,40920,30336,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',238485.00,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2968,7902,40920,30336,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',87.11,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2969,7902,40920,30336,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',2552.95,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2970,7902,40920,30336,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',1323.73,NULL,NULL,1,'2023-12-26 17:26:03','2023-12-26 17:26:03',NULL),(2971,7902,40920,30336,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',116823.07,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2972,7902,40920,30336,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',5100.00,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2973,7902,40920,30336,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',36033.90,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2974,7902,40920,30336,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1607473.39,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2975,7902,40920,30336,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1426622.99,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2976,7902,40920,30336,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',285379.84,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2977,7902,40920,30336,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',163793.88,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2978,7902,40920,30336,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',2852555.66,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2979,7902,40920,30336,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',501436.06,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2980,7902,40920,30336,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',256353.85,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL);
INSERT INTO `balance_libro` VALUES (2981,7902,40920,30336,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',101547.60,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2982,7902,40920,30336,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',10939.98,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2983,7902,40920,30336,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',8699.97,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2984,7902,40920,30336,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',390361.98,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2985,7902,40920,30336,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',43700.66,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2986,7902,40920,30336,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',102916.97,NULL,NULL,1,'2023-12-26 17:26:04','2023-12-26 17:26:04',NULL),(2987,7902,40920,30336,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',2365.85,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2988,7902,40920,30336,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',4152.92,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2989,7902,40920,30336,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',2021.82,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2990,7902,40920,30336,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',61351.50,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2991,7902,40920,30336,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',94923.18,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2992,7902,40920,30336,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',62404.86,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2993,7902,40920,30336,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',46859.88,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2994,7902,40920,30336,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',40784.62,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2995,7902,40920,30336,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',54321.10,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(2996,7902,40920,30336,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',18700.01,NULL,NULL,1,'2023-12-26 17:26:05','2023-12-26 17:26:05',NULL),(3016,7902,40920,30326,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3567.01,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3017,7902,40920,30326,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',312215.36,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3018,7902,40920,30326,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',77357.03,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3019,7902,40920,30326,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',52595.02,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:37','2024-04-29 16:11:37');
INSERT INTO `balance_libro` VALUES (3020,7902,40920,30326,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7800.00,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3021,7902,40920,30326,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4984.03,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3022,7902,40920,30326,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1590.00,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3023,7902,40920,30326,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1400.00,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3024,7902,40920,30326,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1100.00,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3025,7902,40920,30326,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1700.00,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3026,7902,40920,30326,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1550.00,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3027,7902,40920,30326,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',359805.60,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3028,7902,40920,30326,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',11495.00,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3029,7902,40920,30326,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2828.38,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3030,7902,40920,30326,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',15000.00,NULL,NULL,1,'2023-12-26 17:50:55','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3031,7902,40920,30326,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',145434.99,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3032,7902,40920,30326,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1047.23,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3033,7902,40920,30326,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',287495.04,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3034,7902,40920,30326,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1400.00,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3035,7902,40920,30326,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1593.73,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3036,7902,40920,30326,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',354338.82,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3037,7902,40920,30326,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',10954.40,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3038,7902,40920,30326,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1100.00,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38');
INSERT INTO `balance_libro` VALUES (3039,7902,40920,30326,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6761.61,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3040,7902,40920,30326,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2200.00,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3041,7902,40920,30326,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1400.00,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3042,7902,40920,30326,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2200.00,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3043,7902,40920,30326,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',18860.00,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3044,7902,40920,30326,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5040.48,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3045,7902,40920,30326,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1100.00,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3046,7902,40920,30326,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',71390.00,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3047,7902,40920,30326,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9694.96,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3048,7902,40920,30326,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',18481.13,NULL,NULL,1,'2023-12-26 17:50:56','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3049,7902,40920,30326,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1950.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3050,7902,40920,30326,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',86440.08,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3051,7902,40920,30326,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1950.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3052,7902,40920,30326,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4317.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3053,7902,40920,30326,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2250.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3054,7902,40920,30326,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',9438.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3055,7902,40920,30326,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1950.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3056,7902,40920,30326,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1102852.14,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3057,7902,40920,30326,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',19255.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39');
INSERT INTO `balance_libro` VALUES (3058,7902,40920,30326,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',6033.04,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3059,7902,40920,30326,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',29652.01,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3060,7902,40920,30326,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4194.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3061,7902,40920,30326,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',285995.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3062,7902,40920,30326,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6574.37,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3063,7902,40920,30326,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4571.42,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3064,7902,40920,30326,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1890.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3065,7902,40920,30326,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1550.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3066,7902,40920,30326,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2250.00,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3067,7902,40920,30326,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',39465.02,NULL,NULL,1,'2023-12-26 17:50:57','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3068,7902,40920,30326,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1600.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3069,7902,40920,30326,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6372.25,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3070,7902,40920,30326,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1100.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3071,7902,40920,30326,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',11100.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3072,7902,40920,30326,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5697.15,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3073,7902,40920,30326,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1100.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3074,7902,40920,30326,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8989.54,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3075,7902,40920,30326,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1100.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3076,7902,40920,30326,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1800.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40');
INSERT INTO `balance_libro` VALUES (3077,7902,40920,30326,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1750.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3078,7902,40920,30326,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',434.13,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3079,7902,40920,30326,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',14300.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3080,7902,40920,30326,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6187.90,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3081,7902,40920,30326,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2161.24,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3082,7902,40920,30326,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',14280.00,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3083,7902,40920,30326,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6494.60,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3084,7902,40920,30326,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',632951.86,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3085,7902,40920,30326,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',198711.57,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3086,7902,40920,30326,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',304138.42,NULL,NULL,1,'2023-12-26 17:50:58','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3087,7902,40920,30326,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',5695.11,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3088,7902,40920,30326,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',108512.72,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3089,7902,40920,30326,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',414690.02,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3090,7902,40920,30326,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',299211.80,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3091,7902,40920,30326,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2410.00,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3092,7902,40920,30326,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',3634.98,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3093,7902,40920,30326,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1248.88,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3094,7902,40920,30326,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',49636.18,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3095,7902,40920,30326,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',887.09,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41');
INSERT INTO `balance_libro` VALUES (3096,7902,40920,30326,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2504.26,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3097,7902,40920,30326,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',46752.41,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3098,7902,40920,30326,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',6580.96,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3099,7902,40920,30326,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',872970.96,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3100,7902,40920,30326,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2800.00,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3101,7902,40920,30326,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14300.00,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3102,7902,40920,30326,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1474.32,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3103,7902,40920,30326,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1100.00,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3104,7902,40920,30326,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1100.00,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3105,7902,40920,30326,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12447.00,NULL,NULL,1,'2023-12-26 17:50:59','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3106,7902,40920,30326,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6600.00,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3107,7902,40920,30326,3,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1019.75,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3108,7902,40920,30326,3,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6188.02,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3109,7902,40920,30326,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4978.00,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3110,7902,40920,30326,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1850.00,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3111,7902,40920,30326,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1100.00,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3112,7902,40920,30326,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',20600.00,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3113,7902,40920,30326,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',17971.69,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3114,7902,40920,30326,3,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',19130.67,NULL,NULL,1,'2023-12-26 17:51:00','2024-04-29 16:11:42','2024-04-29 16:11:42');
INSERT INTO `balance_libro` VALUES (3570,7902,40920,30326,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',10849.00,NULL,NULL,1,'2023-12-26 18:01:05','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3571,7902,40920,30326,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5499.00,NULL,NULL,1,'2023-12-26 18:01:05','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3572,7902,40920,30326,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4399.00,NULL,NULL,1,'2023-12-26 18:01:05','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3573,7902,40920,30326,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',13100.00,NULL,NULL,1,'2023-12-26 18:01:05','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3574,7902,40920,30326,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6796.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3575,7902,40920,30326,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6209.10,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3576,7902,40920,30326,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',10284.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3577,7902,40920,30326,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8999.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3578,7902,40920,30326,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5499.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3579,7902,40920,30326,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2899.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3580,7902,40920,30326,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',9299.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3581,7902,40920,30326,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6209.10,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:31','2024-04-29 16:11:31'),(3582,7902,40920,30326,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8397.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3583,7902,40920,30326,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6209.10,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3584,7902,40920,30326,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6209.10,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3585,7902,40920,30326,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2899.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3586,7902,40920,30326,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3099.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3587,7902,40920,30326,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5299.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3588,7902,40920,30326,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3219.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32');
INSERT INTO `balance_libro` VALUES (3589,7902,40920,30326,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11300.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3590,7902,40920,30326,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6209.10,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3591,7902,40920,30326,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',9297.00,NULL,NULL,1,'2023-12-26 18:01:06','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3592,7902,40920,30326,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5598.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3593,7902,40920,30326,2,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8999.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3594,7902,40920,30326,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8397.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3595,7902,40920,30326,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8999.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3596,7902,40920,30326,2,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6209.10,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3597,7902,40920,30326,2,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5599.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3598,7902,40920,30326,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14997.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3599,7902,40920,30326,2,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8999.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3600,7902,40920,30326,2,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8999.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:32','2024-04-29 16:11:32'),(3601,7902,40920,30326,2,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6209.10,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3602,7902,40920,30326,2,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6639.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3603,7902,40920,30326,2,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2899.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3604,7902,40920,30326,2,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2899.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3605,7902,40920,30326,2,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5499.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3606,7902,40920,30326,2,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',28519.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3607,7902,40920,30326,2,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2799.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:33','2024-04-29 16:11:33');
INSERT INTO `balance_libro` VALUES (3608,7902,40920,30326,2,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8999.00,NULL,NULL,1,'2023-12-26 18:01:07','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3609,7902,40920,30326,2,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2899.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3610,7902,40920,30326,2,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5598.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3611,7902,40920,30326,2,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2899.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3612,7902,40920,30326,2,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3798.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3613,7902,40920,30326,2,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8783.40,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3614,7902,40920,30326,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2399.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3615,7902,40920,30326,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5499.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3616,7902,40920,30326,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5399.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3617,7902,40920,30326,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',12598.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3618,7902,40920,30326,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8999.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3619,7902,40920,30326,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4299.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:33','2024-04-29 16:11:33'),(3620,7902,40920,30326,2,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2799.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3621,7902,40920,30326,2,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6209.10,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3622,7902,40920,30326,2,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2899.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3623,7902,40920,30326,2,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8029.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3624,7902,40920,30326,2,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5499.00,NULL,NULL,1,'2023-12-26 18:01:08','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3625,7902,40920,30326,2,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4399.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3626,7902,40920,30326,2,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4299.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34');
INSERT INTO `balance_libro` VALUES (3627,7902,40920,30326,2,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4699.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3628,7902,40920,30326,2,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5499.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3629,7902,40920,30326,2,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',27699.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3630,7902,40920,30326,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6209.10,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3631,7902,40920,30326,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2899.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3632,7902,40920,30326,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5499.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3633,7902,40920,30326,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3398.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3634,7902,40920,30326,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1699.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3635,7902,40920,30326,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5499.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3636,7902,40920,30326,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6299.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:34','2024-04-29 16:11:34'),(3637,7902,40920,30326,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9398.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3638,7902,40920,30326,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',752.18,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3639,7902,40920,30326,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6209.10,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3640,7902,40920,30326,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5499.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3641,7902,40920,30326,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8029.00,NULL,NULL,1,'2023-12-26 18:01:09','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3642,7902,40920,30326,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2399.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3643,7902,40920,30326,2,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1699.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3644,7902,40920,30326,2,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5499.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3645,7902,40920,30326,2,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8999.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35');
INSERT INTO `balance_libro` VALUES (3646,7902,40920,30326,2,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4699.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3647,7902,40920,30326,2,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6209.10,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3648,7902,40920,30326,2,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4699.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3649,7902,40920,30326,2,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6209.10,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3650,7902,40920,30326,2,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5598.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3651,7902,40920,30326,2,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4299.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3652,7902,40920,30326,2,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6209.10,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3653,7902,40920,30326,2,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4399.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:35','2024-04-29 16:11:35'),(3654,7902,40920,30326,2,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4398.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3655,7902,40920,30326,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3656,7902,40920,30326,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3657,7902,40920,30326,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',16794.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3658,7902,40920,30326,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3788.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3659,7902,40920,30326,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:10','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3660,7902,40920,30326,2,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1799.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3661,7902,40920,30326,2,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',13999.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3662,7902,40920,30326,2,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8029.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3663,7902,40920,30326,2,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8029.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3664,7902,40920,30326,2,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7320.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36');
INSERT INTO `balance_libro` VALUES (3665,7902,40920,30326,2,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3666,7902,40920,30326,2,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3667,7902,40920,30326,2,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8922.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3668,7902,40920,30326,2,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3669,7902,40920,30326,2,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5598.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3670,7902,40920,30326,2,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3671,7902,40920,30326,2,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11879.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:36','2024-04-29 16:11:36'),(3672,7902,40920,30326,2,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7479.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3673,7902,40920,30326,2,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3798.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3674,7902,40920,30326,2,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7499.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3675,7902,40920,30326,2,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',54600.00,NULL,NULL,1,'2023-12-26 18:01:11','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3676,7902,40920,30326,2,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3099.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3677,7902,40920,30326,2,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6897.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3678,7902,40920,30326,2,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3398.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3679,7902,40920,30326,2,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8397.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3680,7902,40920,30326,2,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5299.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3681,7902,40920,30326,2,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9960.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3682,7902,40920,30326,2,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3683,7902,40920,30326,2,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1978.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37');
INSERT INTO `balance_libro` VALUES (3684,7902,40920,30326,2,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3685,7902,40920,30326,2,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3686,7902,40920,30326,2,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2876.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3687,7902,40920,30326,2,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3688,7902,40920,30326,2,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3689,7902,40920,30326,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2899.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:37','2024-04-29 16:11:37'),(3690,7902,40920,30326,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1598.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3691,7902,40920,30326,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1499.00,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3692,7902,40920,30326,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:12','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3693,7902,40920,30326,2,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',28519.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3694,7902,40920,30326,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4699.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3695,7902,40920,30326,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2899.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3696,7902,40920,30326,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5598.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3697,7902,40920,30326,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8999.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3698,7902,40920,30326,2,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3699,7902,40920,30326,2,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3700,7902,40920,30326,2,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3701,7902,40920,30326,2,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3702,7902,40920,30326,2,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6209.10,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38');
INSERT INTO `balance_libro` VALUES (3703,7902,40920,30326,2,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5499.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3704,7902,40920,30326,2,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7479.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3705,7902,40920,30326,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1598.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3706,7902,40920,30326,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9899.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3707,7902,40920,30326,2,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3708,7902,40920,30326,2,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:38','2024-04-29 16:11:38'),(3709,7902,40920,30326,2,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2799.00,NULL,NULL,1,'2023-12-26 18:01:13','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3710,7902,40920,30326,2,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2998.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3711,7902,40920,30326,2,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3712,7902,40920,30326,2,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5598.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3713,7902,40920,30326,2,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4699.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3714,7902,40920,30326,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5299.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3715,7902,40920,30326,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2799.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3716,7902,40920,30326,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2399.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3717,7902,40920,30326,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3718,7902,40920,30326,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',529.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3719,7902,40920,30326,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3720,7902,40920,30326,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3721,7902,40920,30326,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39');
INSERT INTO `balance_libro` VALUES (3722,7902,40920,30326,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3723,7902,40920,30326,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3724,7902,40920,30326,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2880.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3725,7902,40920,30326,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3726,7902,40920,30326,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2399.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3727,7902,40920,30326,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8397.00,NULL,NULL,1,'2023-12-26 18:01:14','2024-04-29 16:11:39','2024-04-29 16:11:39'),(3728,7902,40920,30326,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2699.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3729,7902,40920,30326,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3730,7902,40920,30326,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',399.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3731,7902,40920,30326,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3732,7902,40920,30326,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3733,7902,40920,30326,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3734,7902,40920,30326,2,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2899.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3735,7902,40920,30326,2,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4399.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3736,7902,40920,30326,2,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4399.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3737,7902,40920,30326,2,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2799.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3738,7902,40920,30326,2,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3739,7902,40920,30326,2,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2699.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3740,7902,40920,30326,2,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1699.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40');
INSERT INTO `balance_libro` VALUES (3741,7902,40920,30326,2,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3742,7902,40920,30326,2,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4098.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3743,7902,40920,30326,2,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9398.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3744,7902,40920,30326,2,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8697.00,NULL,NULL,1,'2023-12-26 18:01:15','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3745,7902,40920,30326,2,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',22087.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3746,7902,40920,30326,2,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3747,7902,40920,30326,2,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5499.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:40','2024-04-29 16:11:40'),(3748,7902,40920,30326,2,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3398.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3749,7902,40920,30326,2,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2899.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3750,7902,40920,30326,2,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',399.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3751,7902,40920,30326,2,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6209.10,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3752,7902,40920,30326,2,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5278.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3753,7902,40920,30326,2,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10899.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3754,7902,40920,30326,2,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2799.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3755,7902,40920,30326,2,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10849.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3756,7902,40920,30326,2,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',8390.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3757,7902,40920,30326,2,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',32798.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3758,7902,40920,30326,2,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4699.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3759,7902,40920,30326,2,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6209.10,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41');
INSERT INTO `balance_libro` VALUES (3760,7902,40920,30326,2,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2899.00,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3761,7902,40920,30326,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6209.10,NULL,NULL,1,'2023-12-26 18:01:16','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3762,7902,40920,30326,2,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5499.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3763,7902,40920,30326,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',8999.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3764,7902,40920,30326,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',7380.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3765,7902,40920,30326,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5499.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3766,7902,40920,30326,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6209.10,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3767,7902,40920,30326,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5499.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:41','2024-04-29 16:11:41'),(3768,7902,40920,30326,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2899.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3769,7902,40920,30326,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2024.81,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3770,7902,40920,30326,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',8397.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3771,7902,40920,30326,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6299.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3772,7902,40920,30326,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6998.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3773,7902,40920,30326,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5598.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3774,7902,40920,30326,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5598.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3775,7902,40920,30326,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10194.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3776,7902,40920,30326,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',399.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3777,7902,40920,30326,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2399.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3778,7902,40920,30326,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12598.00,NULL,NULL,1,'2023-12-26 18:01:17','2024-04-29 16:11:42','2024-04-29 16:11:42');
INSERT INTO `balance_libro` VALUES (3779,7902,40920,30326,2,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2799.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3780,7902,40920,30326,2,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',8029.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3781,7902,40920,30326,2,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5187.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3782,7902,40920,30326,2,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2799.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3783,7902,40920,30326,2,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3998.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3784,7902,40920,30326,2,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',399.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3785,7902,40920,30326,2,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6065.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3786,7902,40920,30326,2,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1699.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3787,7902,40920,30326,2,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',10899.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:42','2024-04-29 16:11:42'),(3788,7902,40920,30326,2,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',8999.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3789,7902,40920,30326,2,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5598.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3790,7902,40920,30326,2,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',8999.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3791,7902,40920,30326,2,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5598.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3792,7902,40920,30326,2,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6639.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3793,7902,40920,30326,2,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5598.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3794,7902,40920,30326,2,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',6798.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3795,7902,40920,30326,2,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',4999.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3796,7902,40920,30326,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',3699.00,NULL,NULL,1,'2023-12-26 18:01:18','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3797,7902,40920,30326,2,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5499.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43');
INSERT INTO `balance_libro` VALUES (3798,7902,40920,30326,2,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',8999.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3799,7902,40920,30326,2,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',11196.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3800,7902,40920,30326,2,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',3899.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3801,7902,40920,30326,2,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1699.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3802,7902,40920,30326,2,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',7470.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3803,7902,40920,30326,2,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5996.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3804,7902,40920,30326,2,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5097.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3805,7902,40920,30326,2,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1799.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3806,7902,40920,30326,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9899.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3807,7902,40920,30326,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1798.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:43','2024-04-29 16:11:43'),(3808,7902,40920,30326,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3398.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3809,7902,40920,30326,2,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',10497.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3810,7902,40920,30326,2,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2010.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3811,7902,40920,30326,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',399.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3812,7902,40920,30326,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5097.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3813,7902,40920,30326,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2099.00,NULL,NULL,1,'2023-12-26 18:01:19','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3814,7902,40920,30326,2,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8697.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3815,7902,40920,30326,2,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1699.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3816,7902,40920,30326,2,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9899.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44');
INSERT INTO `balance_libro` VALUES (3817,7902,40920,30326,2,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7479.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3818,7902,40920,30326,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4798.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3819,7902,40920,30326,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6199.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3820,7902,40920,30326,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6199.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3821,7902,40920,30326,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6299.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3822,7902,40920,30326,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5499.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3823,7902,40920,30326,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3598.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3824,7902,40920,30326,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',12799.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3825,7902,40920,30326,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2399.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3826,7902,40920,30326,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2799.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3827,7902,40920,30326,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',399.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3828,7902,40920,30326,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8697.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:44','2024-04-29 16:11:44'),(3829,7902,40920,30326,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6639.00,NULL,NULL,1,'2023-12-26 18:01:20','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3830,7902,40920,30326,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6199.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3831,7902,40920,30326,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1587.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3832,7902,40920,30326,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',51000.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3833,7902,40920,30326,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11996.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3834,7902,40920,30326,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',14495.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3835,7902,40920,30326,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8697.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45');
INSERT INTO `balance_libro` VALUES (3836,7902,40920,30326,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2799.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3837,7902,40920,30326,2,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',26.95,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3838,7902,40920,30326,2,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1738.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3839,7902,40920,30326,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',898.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3840,7902,40920,30326,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',632.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3841,7902,40920,30326,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1799.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3842,7902,40920,30326,2,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5598.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3843,7902,40920,30326,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',998.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3844,7902,40920,30326,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7917.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3845,7902,40920,30326,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5499.00,NULL,NULL,1,'2023-12-26 18:01:21','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3846,7902,40920,30326,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8798.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3847,7902,40920,30326,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',399.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3848,7902,40920,30326,2,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',399.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3849,7902,40920,30326,2,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',9600.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:45','2024-04-29 16:11:45'),(3850,7902,40920,30326,2,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',9998.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3851,7902,40920,30326,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',14199.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3852,7902,40920,30326,2,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2699.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3853,7902,40920,30326,2,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8399.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3854,7902,40920,30326,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6199.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46');
INSERT INTO `balance_libro` VALUES (3855,7902,40920,30326,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4399.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3856,7902,40920,30326,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',28519.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3857,7902,40920,30326,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6199.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3858,7902,40920,30326,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6299.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3859,7902,40920,30326,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5797.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3860,7902,40920,30326,2,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2899.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3861,7902,40920,30326,2,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6597.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3862,7902,40920,30326,2,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',9299.00,NULL,NULL,1,'2023-12-26 18:01:22','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3863,7902,40920,30326,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4798.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3864,7902,40920,30326,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4497.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3865,7902,40920,30326,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',84401.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3866,7902,40920,30326,2,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4056.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3867,7902,40920,30326,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',6897.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3868,7902,40920,30326,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',6639.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3869,7902,40920,30326,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',32798.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3870,7902,40920,30326,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5499.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:46','2024-04-29 16:11:46'),(3871,7902,40920,30326,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',6199.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3872,7902,40920,30326,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',9299.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3873,7902,40920,30326,2,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8999.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47');
INSERT INTO `balance_libro` VALUES (3874,7902,40920,30326,2,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',399.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3875,7902,40920,30326,2,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5499.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3876,7902,40920,30326,2,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5798.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3877,7902,40920,30326,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1470.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3878,7902,40920,30326,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',14800.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3879,7902,40920,30326,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',399.00,NULL,NULL,1,'2023-12-26 18:01:23','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3880,7902,40920,30326,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',28519.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3881,7902,40920,30326,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8697.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3882,7902,40920,30326,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2899.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3883,7902,40920,30326,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',399.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3884,7902,40920,30326,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5499.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3885,7902,40920,30326,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3459.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3886,7902,40920,30326,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',7479.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3887,7902,40920,30326,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5499.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3888,7902,40920,30326,2,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8029.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3889,7902,40920,30326,2,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2876.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3890,7902,40920,30326,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',6639.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:47','2024-04-29 16:11:47'),(3891,7902,40920,30326,2,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8999.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3892,7902,40920,30326,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',11596.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:48','2024-04-29 16:11:48');
INSERT INTO `balance_libro` VALUES (3893,7902,40920,30326,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3899.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3894,7902,40920,30326,2,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5798.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3895,7902,40920,30326,2,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1499.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3896,7902,40920,30326,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',20994.00,NULL,NULL,1,'2023-12-26 18:01:24','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3897,7902,40920,30326,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3899.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3898,7902,40920,30326,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5598.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3899,7902,40920,30326,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6796.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3900,7902,40920,30326,2,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',699.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3901,7902,40920,30326,2,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4699.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3902,7902,40920,30326,2,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2899.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3903,7902,40920,30326,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',10849.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3904,7902,40920,30326,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3398.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3905,7902,40920,30326,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3598.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3906,7902,40920,30326,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',10849.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3907,7902,40920,30326,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',61300.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3908,7902,40920,30326,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',13999.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3909,7902,40920,30326,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6299.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3910,7902,40920,30326,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5499.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3911,7902,40920,30326,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',16399.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48');
INSERT INTO `balance_libro` VALUES (3912,7902,40920,30326,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3398.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:48','2024-04-29 16:11:48'),(3913,7902,40920,30326,2,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2699.00,NULL,NULL,1,'2023-12-26 18:01:25','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3914,7902,40920,30326,2,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',17900.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3915,7902,40920,30326,2,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4399.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3916,7902,40920,30326,2,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4299.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3917,7902,40920,30326,2,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',31999.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3918,7902,40920,30326,2,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6199.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3919,7902,40920,30326,2,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8999.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3920,7902,40920,30326,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8029.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3921,7902,40920,30326,2,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2699.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3922,7902,40920,30326,2,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3199.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3923,7902,40920,30326,2,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',32400.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3924,7902,40920,30326,2,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6639.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3925,7902,40920,30326,2,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7479.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3926,7902,40920,30326,2,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5798.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3927,7902,40920,30326,2,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3398.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3928,7902,40920,30326,2,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1799.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3929,7902,40920,30326,2,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2799.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3930,7902,40920,30326,2,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2876.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49');
INSERT INTO `balance_libro` VALUES (3931,7902,40920,30326,2,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',31999.00,NULL,NULL,1,'2023-12-26 18:01:26','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3932,7902,40920,30326,2,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1438.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3933,7902,40920,30326,2,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',8899.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:49','2024-04-29 16:11:49'),(3934,7902,40920,30326,2,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3739.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3935,7902,40920,30326,2,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',8399.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3936,7902,40920,30326,2,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10497.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3937,7902,40920,30326,2,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',8029.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3938,7902,40920,30326,2,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3398.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3939,7902,40920,30326,2,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3660.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3940,7902,40920,30326,2,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',8999.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3941,7902,40920,30326,2,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10849.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3942,7902,40920,30326,2,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',7980.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3943,7902,40920,30326,2,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',6299.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3944,7902,40920,30326,2,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',8697.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3945,7902,40920,30326,2,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',399.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3946,7902,40920,30326,2,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',91400.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3947,7902,40920,30326,2,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3499.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3948,7902,40920,30326,2,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5499.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3949,7902,40920,30326,2,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',6199.00,NULL,NULL,1,'2023-12-26 18:01:27','2024-04-29 16:11:50','2024-04-29 16:11:50');
INSERT INTO `balance_libro` VALUES (3950,7902,40920,30326,2,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2399.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3951,7902,40920,30326,2,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2799.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3952,7902,40920,30326,2,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2899.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3953,7902,40920,30326,2,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',6979.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3954,7902,40920,30326,2,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',7980.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3955,7902,40920,30326,2,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5598.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:50','2024-04-29 16:11:50'),(3956,7902,40920,30326,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',22.29,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3957,7902,40920,30326,2,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',31976.71,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3958,7902,40920,30326,2,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6199.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3959,7902,40920,30326,2,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1497.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3960,7902,40920,30326,2,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',10849.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3961,7902,40920,30326,2,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2899.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3962,7902,40920,30326,2,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1899.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3963,7902,40920,30326,2,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3398.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3964,7902,40920,30326,2,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6639.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3965,7902,40920,30326,2,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',8999.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3966,7902,40920,30326,2,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',17394.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3967,7902,40920,30326,2,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6639.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3968,7902,40920,30326,2,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',17394.00,NULL,NULL,1,'2023-12-26 18:01:28','2024-04-29 16:11:51','2024-04-29 16:11:51');
INSERT INTO `balance_libro` VALUES (3969,7902,40920,30326,2,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6199.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3970,7902,40920,30326,2,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',10899.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3971,7902,40920,30326,2,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',399.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3972,7902,40920,30326,2,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3699.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3973,7902,40920,30326,2,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2998.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3974,7902,40920,30326,2,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1499.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3975,7902,40920,30326,2,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1599.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3976,7902,40920,30326,2,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4746.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3977,7902,40920,30326,2,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2699.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:51','2024-04-29 16:11:51'),(3978,7902,40920,30326,2,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',8999.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3979,7902,40920,30326,2,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',8798.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3980,7902,40920,30326,2,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',8697.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3981,7902,40920,30326,2,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2399.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3982,7902,40920,30326,2,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',11596.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3983,7902,40920,30326,2,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',9995.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3984,7902,40920,30326,2,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',9899.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3985,7902,40920,30326,2,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2797.00,NULL,NULL,1,'2023-12-26 18:01:29','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3986,7902,40920,30326,2,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',3398.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3987,7902,40920,30326,2,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2899.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52');
INSERT INTO `balance_libro` VALUES (3988,7902,40920,30326,2,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',8997.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3989,7902,40920,30326,2,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',20293.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3990,7902,40920,30326,2,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',10497.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3991,7902,40920,30326,2,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6097.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3992,7902,40920,30326,2,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',7479.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3993,7902,40920,30326,2,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',4399.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3994,7902,40920,30326,2,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1699.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3995,7902,40920,30326,2,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1699.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3996,7902,40920,30326,2,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6796.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3997,7902,40920,30326,2,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6299.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3998,7902,40920,30326,2,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',81799.99,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:52','2024-04-29 16:11:52'),(3999,7902,40920,30326,2,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',10849.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4000,7902,40920,30326,2,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2799.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4001,7902,40920,30326,2,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',10899.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4002,7902,40920,30326,2,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11277.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4003,7902,40920,30326,2,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3398.00,NULL,NULL,1,'2023-12-26 18:01:30','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4004,7902,40920,30326,2,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',869.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4005,7902,40920,30326,2,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',73100.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4006,7902,40920,30326,2,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5798.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53');
INSERT INTO `balance_libro` VALUES (4007,7902,40920,30326,2,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',58800.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4008,7902,40920,30326,2,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',13996.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4009,7902,40920,30326,2,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1699.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4010,7902,40920,30326,2,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',6796.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4011,7902,40920,30326,2,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',10849.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4012,7902,40920,30326,2,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4399.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4013,7902,40920,30326,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9899.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4014,7902,40920,30326,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9398.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4015,7902,40920,30326,2,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4299.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4016,7902,40920,30326,2,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9459.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4017,7902,40920,30326,2,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5499.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4018,7902,40920,30326,2,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3398.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4019,7902,40920,30326,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2699.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:53','2024-04-29 16:11:53'),(4020,7902,40920,30326,2,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3099.00,NULL,NULL,1,'2023-12-26 18:01:31','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4021,7902,40920,30326,2,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8697.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4022,7902,40920,30326,2,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2699.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4023,7902,40920,30326,2,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8697.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4024,7902,40920,30326,2,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',11596.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4025,7902,40920,30326,2,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2899.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54');
INSERT INTO `balance_libro` VALUES (4026,7902,40920,30326,2,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',11879.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4027,7902,40920,30326,2,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1000.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4028,7902,40920,30326,2,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3099.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4029,7902,40920,30326,2,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',13999.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4030,7902,40920,30326,2,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',18918.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4031,7902,40920,30326,2,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',12396.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4032,7902,40920,30326,2,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',18594.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4033,7902,40920,30326,2,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2899.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4034,7902,40920,30326,2,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2099.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4035,7902,40920,30326,2,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',5500.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4036,7902,40920,30326,2,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1899.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4037,7902,40920,30326,2,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9040.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4038,7902,40920,30326,2,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8999.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4039,7902,40920,30326,2,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',28699.00,NULL,NULL,1,'2023-12-26 18:01:32','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4040,7902,40920,30326,2,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8029.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4041,7902,40920,30326,2,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2699.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:54','2024-04-29 16:11:54'),(4042,7902,40920,30326,2,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',6639.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4043,7902,40920,30326,2,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8999.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4044,7902,40920,30326,2,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',5499.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55');
INSERT INTO `balance_libro` VALUES (4045,7902,40920,30326,2,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1699.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4046,7902,40920,30326,2,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',8999.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4047,7902,40920,30326,2,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5097.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4048,7902,40920,30326,2,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',27699.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4049,7902,40920,30326,2,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5097.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4050,7902,40920,30326,2,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11199.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4051,7902,40920,30326,2,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',798.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4052,7902,40920,30326,2,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',989.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4053,7902,40920,30326,2,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',68300.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4054,7902,40920,30326,2,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2899.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4055,7902,40920,30326,2,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6199.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4056,7902,40920,30326,2,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',9459.00,NULL,NULL,1,'2023-12-26 18:01:33','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4057,7902,40920,30326,2,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',9899.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4058,7902,40920,30326,2,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',8999.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4059,7902,40920,30326,2,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1587.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4060,7902,40920,30326,2,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2199.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4061,7902,40920,30326,2,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4299.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4062,7902,40920,30326,2,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2394.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:55','2024-04-29 16:11:55'),(4063,7902,40920,30326,2,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3399.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:55','2024-04-29 16:11:55');
INSERT INTO `balance_libro` VALUES (4064,7902,40920,30326,2,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2799.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4065,7902,40920,30326,2,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1699.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4066,7902,40920,30326,2,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5798.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4067,7902,40920,30326,2,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4699.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4068,7902,40920,30326,2,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5798.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4069,7902,40920,30326,2,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3398.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4070,7902,40920,30326,2,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1999.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4071,7902,40920,30326,2,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2699.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4072,7902,40920,30326,2,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2899.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4073,7902,40920,30326,2,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2199.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4074,7902,40920,30326,2,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5499.00,NULL,NULL,1,'2023-12-26 18:01:34','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4075,7902,40920,30326,2,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1.04,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4076,7902,40920,30326,2,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10899.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4077,7902,40920,30326,2,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11879.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4078,7902,40920,30326,2,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5556.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4079,7902,40920,30326,2,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',10849.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4080,7902,40920,30326,2,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',798.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4081,7902,40920,30326,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5798.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4082,7902,40920,30326,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5798.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56');
INSERT INTO `balance_libro` VALUES (4083,7902,40920,30326,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',28519.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4084,7902,40920,30326,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5798.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4085,7902,40920,30326,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5889.05,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:56','2024-04-29 16:11:56'),(4086,7902,40920,30326,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11596.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4087,7902,40920,30326,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1699.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4088,7902,40920,30326,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11596.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4089,7902,40920,30326,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2899.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4090,7902,40920,30326,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11199.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4091,7902,40920,30326,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9899.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4092,7902,40920,30326,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9899.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4093,7902,40920,30326,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',23192.00,NULL,NULL,1,'2023-12-26 18:01:35','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4094,7902,40920,30326,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5499.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4095,7902,40920,30326,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',54600.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4096,7902,40920,30326,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2699.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4097,7902,40920,30326,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2699.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4098,7902,40920,30326,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2899.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4099,7902,40920,30326,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',43500.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4100,7902,40920,30326,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8697.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4101,7902,40920,30326,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3699.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57');
INSERT INTO `balance_libro` VALUES (4102,7902,40920,30326,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5889.05,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4103,7902,40920,30326,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2899.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4104,7902,40920,30326,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2899.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4105,7902,40920,30326,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',420.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4106,7902,40920,30326,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2699.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:57','2024-04-29 16:11:57'),(4107,7902,40920,30326,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8999.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4108,7902,40920,30326,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',399.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4109,7902,40920,30326,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8999.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4110,7902,40920,30326,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6998.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4111,7902,40920,30326,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4299.00,NULL,NULL,1,'2023-12-26 18:01:36','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4112,7902,40920,30326,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5097.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4113,7902,40920,30326,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',28519.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4114,7902,40920,30326,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',12699.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4115,7902,40920,30326,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2699.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4116,7902,40920,30326,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',12699.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4117,7902,40920,30326,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',39800.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4118,7902,40920,30326,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4299.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4119,7902,40920,30326,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2699.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4120,7902,40920,30326,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',399.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58');
INSERT INTO `balance_libro` VALUES (4121,7902,40920,30326,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4160.13,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4122,7902,40920,30326,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',9129.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4123,7902,40920,30326,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3499.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4124,7902,40920,30326,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5798.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4125,7902,40920,30326,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',8999.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:58','2024-04-29 16:11:58'),(4126,7902,40920,30326,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',8999.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4127,7902,40920,30326,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11899.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4128,7902,40920,30326,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',49197.00,NULL,NULL,1,'2023-12-26 18:01:37','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4129,7902,40920,30326,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3398.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4130,7902,40920,30326,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2699.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4131,7902,40920,30326,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',28699.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4132,7902,40920,30326,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',8697.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4133,7902,40920,30326,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',32798.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4134,7902,40920,30326,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11899.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4135,7902,40920,30326,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',6299.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4136,7902,40920,30326,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4688.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4137,7902,40920,30326,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7479.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:11:59','2024-04-29 16:11:59'),(4138,7902,40920,30326,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',8999.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4139,7902,40920,30326,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6639.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00');
INSERT INTO `balance_libro` VALUES (4140,7902,40920,30326,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4299.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4141,7902,40920,30326,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2999.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4142,7902,40920,30326,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',23192.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4143,7902,40920,30326,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2899.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4144,7902,40920,30326,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5798.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4145,7902,40920,30326,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3899.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4146,7902,40920,30326,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7479.00,NULL,NULL,1,'2023-12-26 18:01:38','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4147,7902,40920,30326,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4299.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4148,7902,40920,30326,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',12799.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4149,7902,40920,30326,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',9899.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4150,7902,40920,30326,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',9188.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4151,7902,40920,30326,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',10849.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4152,7902,40920,30326,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',11899.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4153,7902,40920,30326,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2799.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:00','2024-04-29 16:12:00'),(4154,7902,40920,30326,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',20766.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4155,7902,40920,30326,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',8697.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4156,7902,40920,30326,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',8999.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4157,7902,40920,30326,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',3798.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4158,7902,40920,30326,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',15999.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01');
INSERT INTO `balance_libro` VALUES (4159,7902,40920,30326,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',6639.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4160,7902,40920,30326,2,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',4198.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4161,7902,40920,30326,2,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',5499.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4162,7902,40920,30326,2,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',6299.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4163,7902,40920,30326,2,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',11199.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4164,7902,40920,30326,2,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',7720.00,NULL,NULL,1,'2023-12-26 18:01:39','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4165,7902,40920,30326,2,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',8999.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4166,7902,40920,30326,2,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',2799.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4167,7902,40920,30326,2,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',6998.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4168,7902,40920,30326,2,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',3160.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:01','2024-04-29 16:12:01'),(4169,7902,40920,30326,2,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',5798.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4170,7902,40920,30326,2,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',3990.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4171,7902,40920,30326,2,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',6796.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4172,7902,40920,30326,2,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',98300.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4173,7902,40920,30326,2,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',10921.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4174,7902,40920,30326,2,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',6546.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4175,7902,40920,30326,2,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8999.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4176,7902,40920,30326,2,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5798.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4177,7902,40920,30326,2,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',9459.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02');
INSERT INTO `balance_libro` VALUES (4178,7902,40920,30326,2,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',18000.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4179,7902,40920,30326,2,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2699.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4180,7902,40920,30326,2,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',9955.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4181,7902,40920,30326,2,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',399.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:02','2024-04-29 16:12:02'),(4182,7902,40920,30326,2,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',7495.00,NULL,NULL,1,'2023-12-26 18:01:40','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4183,7902,40920,30326,2,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1518.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4184,7902,40920,30326,2,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5798.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4185,7902,40920,30326,2,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5798.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4186,7902,40920,30326,2,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4299.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4187,7902,40920,30326,2,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5798.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4188,7902,40920,30326,2,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2899.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4189,7902,40920,30326,2,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',14000.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4190,7902,40920,30326,2,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5499.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4191,7902,40920,30326,2,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',399.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4192,7902,40920,30326,2,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',6495.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4193,7902,40920,30326,2,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',13999.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4194,7902,40920,30326,2,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',399.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4195,7902,40920,30326,2,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3699.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4196,7902,40920,30326,2,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',11596.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03');
INSERT INTO `balance_libro` VALUES (4197,7902,40920,30326,2,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5998.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4198,7902,40920,30326,2,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',6198.00,NULL,NULL,1,'2023-12-26 18:01:41','2024-04-29 16:12:03','2024-04-29 16:12:03'),(4199,7902,40920,30326,2,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3699.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4200,7902,40920,30326,2,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8697.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4201,7902,40920,30326,2,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4639.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4202,7902,40920,30326,2,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8538.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4203,7902,40920,30326,2,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5798.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4204,7902,40920,30326,2,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11596.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4205,7902,40920,30326,2,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',28300.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4206,7902,40920,30326,2,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8999.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4207,7902,40920,30326,2,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5889.05,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4208,7902,40920,30326,2,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',399.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4209,7902,40920,30326,2,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',12396.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4210,7902,40920,30326,2,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5889.05,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4211,7902,40920,30326,2,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4299.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4212,7902,40920,30326,2,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',55000.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4213,7902,40920,30326,2,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1699.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:04','2024-04-29 16:12:04'),(4214,7902,40920,30326,2,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',27699.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4215,7902,40920,30326,2,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8498.00,NULL,NULL,1,'2023-12-26 18:01:42','2024-04-29 16:12:05','2024-04-29 16:12:05');
INSERT INTO `balance_libro` VALUES (4216,7902,40920,30326,2,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3399.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4217,7902,40920,30326,2,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6299.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4218,7902,40920,30326,2,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6639.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4219,7902,40920,30326,2,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6639.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4220,7902,40920,30326,2,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',9297.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4221,7902,40920,30326,2,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3099.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4222,7902,40920,30326,2,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',38200.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4223,7902,40920,30326,2,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7720.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4224,7902,40920,30326,2,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3699.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4225,7902,40920,30326,2,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',28519.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4226,7902,40920,30326,2,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5097.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4227,7902,40920,30326,2,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',815.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4228,7902,40920,30326,2,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',27891.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4229,7902,40920,30326,2,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',32798.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4230,7902,40920,30326,2,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',24792.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:05','2024-04-29 16:12:05'),(4231,7902,40920,30326,2,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2799.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4232,7902,40920,30326,2,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2998.00,NULL,NULL,1,'2023-12-26 18:01:43','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4233,7902,40920,30326,2,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6599.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4234,7902,40920,30326,2,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5889.05,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06');
INSERT INTO `balance_libro` VALUES (4235,7902,40920,30326,2,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9459.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4236,7902,40920,30326,2,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1299.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4237,7902,40920,30326,2,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4828.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4238,7902,40920,30326,2,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9830.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4239,7902,40920,30326,2,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9129.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4240,7902,40920,30326,2,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6198.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4241,7902,40920,30326,2,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',15495.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4242,7902,40920,30326,2,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2699.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4243,7902,40920,30326,2,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2699.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4244,7902,40920,30326,2,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6299.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4245,7902,40920,30326,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6198.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4246,7902,40920,30326,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',28519.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4247,7902,40920,30326,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3499.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:06','2024-04-29 16:12:06'),(4248,7902,40920,30326,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6299.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4249,7902,40920,30326,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',7499.00,NULL,NULL,1,'2023-12-26 18:01:44','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4250,7902,40920,30326,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6198.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4251,7902,40920,30326,2,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9297.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4252,7902,40920,30326,2,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',12396.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4253,7902,40920,30326,2,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',399.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07');
INSERT INTO `balance_libro` VALUES (4254,7902,40920,30326,2,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9899.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4255,7902,40920,30326,2,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5889.05,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4256,7902,40920,30326,2,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',16100.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4257,7902,40920,30326,2,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',30599.99,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4258,7902,40920,30326,2,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3398.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4259,7902,40920,30326,2,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',18201.99,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4260,7902,40920,30326,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6697.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4261,7902,40920,30326,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3398.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4262,7902,40920,30326,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4399.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4263,7902,40920,30326,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',21495.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4264,7902,40920,30326,2,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2699.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4265,7902,40920,30326,2,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4299.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4266,7902,40920,30326,2,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1198.00,NULL,NULL,1,'2023-12-26 18:01:45','2024-04-29 16:12:07','2024-04-29 16:12:07'),(4267,7902,40920,30326,2,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6639.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4268,7902,40920,30326,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5499.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4269,7902,40920,30326,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2644.23,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4270,7902,40920,30326,2,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2699.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4271,7902,40920,30326,2,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',28699.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4272,7902,40920,30326,2,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6639.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08');
INSERT INTO `balance_libro` VALUES (4273,7902,40920,30326,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2399.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4274,7902,40920,30326,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8999.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4275,7902,40920,30326,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3590.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4276,7902,40920,30326,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1999.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4277,7902,40920,30326,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8999.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4278,7902,40920,30326,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6198.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4279,7902,40920,30326,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6198.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4280,7902,40920,30326,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2260.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4281,7902,40920,30326,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',53000.00,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4282,7902,40920,30326,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5889.05,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4283,7902,40920,30326,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5889.05,NULL,NULL,1,'2023-12-26 18:01:46','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4284,7902,40920,30326,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',12396.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:08','2024-04-29 16:12:08'),(4285,7902,40920,30326,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6639.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4286,7902,40920,30326,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8399.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4287,7902,40920,30326,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3499.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4288,7902,40920,30326,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',8029.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4289,7902,40920,30326,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',13700.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4290,7902,40920,30326,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3398.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4291,7902,40920,30326,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',21495.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09');
INSERT INTO `balance_libro` VALUES (4292,7902,40920,30326,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2199.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4293,7902,40920,30326,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1799.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4294,7902,40920,30326,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',5499.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4295,7902,40920,30326,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',8097.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4296,7902,40920,30326,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3297.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4297,7902,40920,30326,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',41699.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4298,7902,40920,30326,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',8999.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4299,7902,40920,30326,2,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',10497.00,NULL,NULL,1,'2023-12-26 18:01:47','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4300,7902,40920,30326,2,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4299.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4301,7902,40920,30326,2,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2799.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:09','2024-04-29 16:12:09'),(4302,7902,40920,30326,2,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4299.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4303,7902,40920,30326,2,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3074.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4304,7902,40920,30326,2,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3398.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4305,7902,40920,30326,2,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3099.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4306,7902,40920,30326,2,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2799.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4307,7902,40920,30326,2,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',399.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4308,7902,40920,30326,2,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',13996.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4309,7902,40920,30326,2,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2499.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4310,7902,40920,30326,2,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',5398.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10');
INSERT INTO `balance_libro` VALUES (4311,7902,40920,30326,2,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2799.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4312,7902,40920,30326,2,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9899.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4313,7902,40920,30326,2,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1499.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4314,7902,40920,30326,2,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2299.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4315,7902,40920,30326,2,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8999.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4316,7902,40920,30326,2,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3319.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4317,7902,40920,30326,2,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8999.00,NULL,NULL,1,'2023-12-26 18:01:48','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4318,7902,40920,30326,2,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5698.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4319,7902,40920,30326,2,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8598.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:10','2024-04-29 16:12:10'),(4320,7902,40920,30326,2,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1438.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4321,7902,40920,30326,2,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6198.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4322,7902,40920,30326,2,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',499.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4323,7902,40920,30326,2,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',9429.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4324,7902,40920,30326,2,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5299.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4325,7902,40920,30326,2,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7198.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4326,7902,40920,30326,2,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6198.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4327,7902,40920,30326,2,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6639.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4328,7902,40920,30326,2,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2999.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4329,7902,40920,30326,2,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2699.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11');
INSERT INTO `balance_libro` VALUES (4330,7902,40920,30326,2,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',6299.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4331,7902,40920,30326,2,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',14199.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4332,7902,40920,30326,2,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',12699.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4333,7902,40920,30326,2,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',8999.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4334,7902,40920,30326,2,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',8999.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4335,7902,40920,30326,2,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',21000.00,NULL,NULL,1,'2023-12-26 18:01:49','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4336,7902,40920,30326,2,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',9199.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4337,7902,40920,30326,2,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',5889.05,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:11','2024-04-29 16:12:11'),(4338,7902,40920,30326,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2098.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4339,7902,40920,30326,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8999.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4340,7902,40920,30326,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10849.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4341,7902,40920,30326,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8029.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4342,7902,40920,30326,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3590.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4343,7902,40920,30326,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',7296.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4344,7902,40920,30326,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',15000.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4345,7902,40920,30326,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1999.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4346,7902,40920,30326,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2799.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4347,7902,40920,30326,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',11070.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4348,7902,40920,30326,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1699.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12');
INSERT INTO `balance_libro` VALUES (4349,7902,40920,30326,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2260.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4350,7902,40920,30326,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10849.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4351,7902,40920,30326,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',9899.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4352,7902,40920,30326,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2799.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4353,7902,40920,30326,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2999.00,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4354,7902,40920,30326,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5889.05,NULL,NULL,1,'2023-12-26 18:01:50','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4355,7902,40920,30326,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1438.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4356,7902,40920,30326,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19990.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:12','2024-04-29 16:12:12'),(4357,7902,40920,30326,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9899.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4358,7902,40920,30326,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',10849.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4359,7902,40920,30326,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9899.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4360,7902,40920,30326,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11199.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4361,7902,40920,30326,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12198.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4362,7902,40920,30326,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2999.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4363,7902,40920,30326,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1200.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4364,7902,40920,30326,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13100.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4365,7902,40920,30326,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7479.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4366,7902,40920,30326,2,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2399.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4367,7902,40920,30326,2,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9608.77,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13');
INSERT INTO `balance_libro` VALUES (4368,7902,40920,30326,2,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4299.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4369,7902,40920,30326,2,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2899.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4370,7902,40920,30326,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3499.00,NULL,NULL,1,'2023-12-26 18:01:51','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4371,7902,40920,30326,2,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6198.00,NULL,NULL,1,'2023-12-26 18:01:52','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4372,7902,40920,30326,2,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',14000.00,NULL,NULL,1,'2023-12-26 18:01:52','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4373,7902,40920,30326,2,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5499.00,NULL,NULL,1,'2023-12-26 18:01:52','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4374,7902,40920,30326,2,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5889.05,NULL,NULL,1,'2023-12-26 18:01:52','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4375,7902,40920,30326,2,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5598.00,NULL,NULL,1,'2023-12-26 18:01:52','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4376,7902,40920,30326,2,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3590.00,NULL,NULL,1,'2023-12-26 18:01:52','2024-04-29 16:12:13','2024-04-29 16:12:13'),(4377,7902,40920,30326,2,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8999.00,NULL,NULL,1,'2023-12-26 18:01:52','2024-04-29 16:12:14','2024-04-29 16:12:14'),(4378,7902,40920,30326,2,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2899.00,NULL,NULL,1,'2023-12-26 18:01:52','2024-04-29 16:12:14','2024-04-29 16:12:14'),(4379,7902,40920,30335,15,118,'App\\Models\\PeriodLiquidation',NULL,118,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',893639.46,NULL,NULL,1,'2023-12-26 18:07:42','2023-12-26 18:07:42',NULL),(4380,7902,41171,31953,2,4380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',98000.00,'INGRESOS FEBRERO 23',NULL,1,'2023-12-27 12:00:47','2023-12-27 12:00:47',NULL),(4381,7902,41171,31955,2,4381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',115000.00,'INGRESOS ABRIL 23',NULL,1,'2023-12-27 12:01:45','2023-12-27 12:01:45',NULL),(4382,7902,41171,31956,2,4382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',153650.00,'INGRESOS MAYO 23',NULL,1,'2023-12-27 12:03:16','2023-12-27 12:03:16',NULL),(4383,7902,41171,31945,2,4383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',101700.00,'INGRESOS SEPTIEMBRE',NULL,1,'2023-12-27 12:04:03','2023-12-27 12:04:03',NULL),(4384,7902,41171,31947,2,4384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',146600.00,'INGRESOS NOVIEMBRE',NULL,1,'2023-12-27 12:04:47','2023-12-27 12:04:47',NULL),(4385,7902,41171,31948,2,4385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',119450.00,'INGRESOS DICIEMBRE 22',NULL,1,'2023-12-27 12:05:21','2023-12-27 12:05:21',NULL),(4386,7902,41171,31954,2,4386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',100300.00,'INGRESOS MARZO 23',NULL,1,'2023-12-27 12:05:51','2023-12-27 12:05:51',NULL);
INSERT INTO `balance_libro` VALUES (4387,7902,41171,31958,2,4387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',131000.00,'INGRESOS JULIO 23',NULL,1,'2023-12-27 12:06:38','2023-12-27 12:06:38',NULL),(4388,7902,41171,31946,3,4388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',134229.68,'EGRESOS OCTUBRE 22',NULL,1,'2023-12-27 12:10:12','2023-12-27 12:10:12',NULL),(4389,7902,41171,31958,18,4389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',4590.00,'CAMBIO DE MONEDA',NULL,1,'2023-12-27 12:27:14','2023-12-27 12:27:14',NULL),(4390,7902,41171,31958,4,4390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',197557.54,'AMORTIZACION BIENES DE USO',NULL,1,'2023-12-27 12:38:00','2023-12-27 12:42:27','2023-12-27 12:42:27'),(4391,7902,41171,31958,4,4391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',197557.54,'AMORTIZACION BIENES DE USO',NULL,1,'2023-12-27 12:42:27','2023-12-27 12:42:27',NULL),(4392,7902,41171,31959,23,4392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',10149197.59,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-12-27 17:20:04','2023-12-27 17:27:42','2023-12-27 17:27:42'),(4393,7902,41171,31958,23,4393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',560139.06,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-12-27 17:30:42','2023-12-27 17:30:43',NULL),(4394,7902,41171,31959,23,4394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',9346528.85,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-12-27 17:32:21','2023-12-27 17:32:21',NULL),(4395,7902,40719,29,2,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',50000.00,NULL,NULL,1,'2023-12-29 09:14:01','2023-12-29 09:14:01',NULL),(4396,7902,40719,29,2,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',24000.00,NULL,NULL,1,'2023-12-29 09:16:53','2023-12-29 09:16:53',NULL),(4397,7902,41172,33467,2,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',11248.00,NULL,NULL,1,'2024-01-03 16:13:12','2024-01-03 16:13:12',NULL),(4398,7902,41172,33468,2,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',5954.00,NULL,NULL,1,'2024-01-03 16:25:18','2024-01-03 16:25:18',NULL),(4399,7902,41172,33468,2,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',1750.00,NULL,NULL,1,'2024-01-03 16:25:19','2024-01-03 16:25:19',NULL),(4400,7902,41172,33468,2,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',10104.00,NULL,NULL,1,'2024-01-03 16:25:19','2024-01-03 16:25:19',NULL),(4401,7902,41172,33468,2,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',11000.00,NULL,NULL,1,'2024-01-03 16:25:21','2024-01-03 16:25:21',NULL),(4402,7902,41172,33468,2,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',2574.00,NULL,NULL,1,'2024-01-03 16:32:22','2024-01-03 16:32:22',NULL),(4403,7902,41172,33468,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',10725.00,NULL,NULL,1,'2024-01-03 16:32:23','2024-01-03 16:32:23',NULL),(4404,7902,41172,33468,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',4000.00,NULL,NULL,1,'2024-01-03 16:32:24','2024-01-03 16:32:24',NULL),(4405,7902,41172,33468,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',2400.00,NULL,NULL,1,'2024-01-03 16:32:26','2024-01-03 16:32:26',NULL);
INSERT INTO `balance_libro` VALUES (4406,7902,41172,33468,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',2400.00,NULL,NULL,1,'2024-01-03 16:32:27','2024-01-03 16:32:27',NULL),(4407,7902,41172,33468,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',4450.00,NULL,NULL,1,'2024-01-03 16:32:29','2024-01-03 16:32:29',NULL),(4408,7902,41172,33468,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',5061.00,NULL,NULL,1,'2024-01-03 16:32:30','2024-01-03 16:32:30',NULL),(4409,7902,41172,33468,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',11650.00,NULL,NULL,1,'2024-01-03 16:32:31','2024-01-03 16:32:31',NULL),(4410,NULL,41172,33468,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',12000.00,NULL,NULL,1,'2024-01-03 16:36:44','2024-01-03 16:36:44',NULL),(4411,NULL,41172,33468,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',1000.00,NULL,NULL,1,'2024-01-03 16:36:45','2024-01-03 16:36:45',NULL),(4412,NULL,41172,33468,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',750.00,NULL,NULL,1,'2024-01-03 16:36:46','2024-01-03 16:36:46',NULL),(4413,NULL,41172,33468,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',17000.00,NULL,NULL,1,'2024-01-03 16:36:47','2024-01-03 16:36:47',NULL),(4414,NULL,41172,33468,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',8600.00,NULL,NULL,1,'2024-01-03 16:36:48','2024-01-03 16:36:48',NULL),(4415,NULL,41172,33468,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',2400.00,NULL,NULL,1,'2024-01-03 16:36:49','2024-01-03 16:36:49',NULL),(4416,NULL,41172,33468,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',7450.00,NULL,NULL,1,'2024-01-03 16:36:49','2024-01-03 16:36:49',NULL),(4417,NULL,41172,33468,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',1000.00,NULL,NULL,1,'2024-01-03 16:36:50','2024-01-03 16:36:50',NULL),(4418,NULL,41172,33468,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',8700.00,NULL,NULL,1,'2024-01-03 16:36:51','2024-01-03 16:36:51',NULL),(4419,NULL,41172,33468,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',15700.00,NULL,NULL,1,'2024-01-03 16:36:52','2024-01-03 16:36:52',NULL),(4420,NULL,41172,33468,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',5800.00,NULL,NULL,1,'2024-01-03 16:36:52','2024-01-03 16:36:52',NULL),(4421,NULL,41172,33468,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',15600.00,NULL,NULL,1,'2024-01-03 16:36:53','2024-01-03 16:36:53',NULL),(4422,NULL,41172,33468,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',3700.00,NULL,NULL,1,'2024-01-03 16:36:54','2024-01-03 16:36:54',NULL),(4423,NULL,41172,33468,2,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',9300.00,NULL,NULL,1,'2024-01-03 16:36:55','2024-01-03 16:36:55',NULL),(4424,NULL,41172,33468,2,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',40000.00,NULL,NULL,1,'2024-01-03 16:36:55','2024-01-03 16:36:55',NULL),(4425,NULL,41172,33468,2,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',3045.00,NULL,NULL,1,'2024-01-03 16:36:56','2024-01-03 16:36:56',NULL),(4426,NULL,41172,33468,2,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',4900.00,NULL,NULL,1,'2024-01-03 16:36:57','2024-01-03 16:36:57',NULL);
INSERT INTO `balance_libro` VALUES (4427,NULL,49722,36674,3,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',10397.12,NULL,NULL,1,'2024-01-19 11:14:47','2024-01-19 11:14:47',NULL),(4428,NULL,49722,36674,3,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',66000.01,NULL,NULL,1,'2024-01-19 11:14:47','2024-01-19 11:14:47',NULL),(4429,NULL,49722,36674,3,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',43681.00,NULL,NULL,1,'2024-01-19 11:14:47','2024-01-19 11:14:47',NULL),(4430,NULL,49722,36674,3,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',71000.00,NULL,NULL,1,'2024-01-19 11:14:47','2024-01-19 11:14:47',NULL),(4431,NULL,49722,36674,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',22989.00,NULL,NULL,1,'2024-01-19 11:14:47','2024-01-19 11:14:47',NULL),(4432,NULL,49722,36674,3,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',150.00,NULL,NULL,1,'2024-01-19 11:14:47','2024-01-19 11:14:47',NULL),(4433,NULL,49722,36674,3,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',1000.00,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4434,NULL,49722,36674,3,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',179.63,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4435,NULL,49722,36674,3,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',17308.19,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4436,NULL,49722,36674,3,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',6236.21,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4437,NULL,49722,36674,3,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',0.00,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4438,NULL,49722,36674,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',233259.03,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4439,NULL,49722,36674,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',1306.67,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4440,NULL,49722,36674,3,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',5221.93,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4441,NULL,49722,36674,3,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',25086.00,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4442,NULL,49722,36674,3,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',76377.17,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4443,NULL,49722,36674,3,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',21251.22,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4444,NULL,49722,36674,3,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',35521.27,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4445,NULL,49722,36674,3,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',69932.88,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4446,NULL,49722,36674,3,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',30000.71,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL),(4447,NULL,49722,36674,3,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',9369.47,NULL,NULL,1,'2024-01-19 11:14:48','2024-01-19 11:14:48',NULL);
INSERT INTO `balance_libro` VALUES (4448,NULL,49722,36674,3,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',13724.15,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4449,NULL,49722,36674,3,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',190665.00,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4450,NULL,49722,36674,3,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',66000.01,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4451,NULL,49722,36674,3,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',4175.49,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4452,NULL,49722,36674,3,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',482485.48,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4453,NULL,49722,36674,3,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',20199.00,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4454,NULL,49722,36674,3,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',61357.74,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4455,NULL,49722,36674,3,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',122819.77,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4456,NULL,49722,36674,3,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',58307.41,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4457,NULL,49722,36674,3,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',58307.41,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4458,NULL,49722,36674,3,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',48685.58,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4459,NULL,49722,36674,3,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',32982.18,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4460,NULL,49722,36674,3,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',67077.62,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4461,NULL,49722,36674,3,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',41690.02,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4462,NULL,49722,36674,3,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',66209.39,NULL,NULL,1,'2024-01-19 11:14:49','2024-01-19 11:14:49',NULL),(4463,NULL,49722,36674,3,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',8312.02,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4464,NULL,49722,36674,3,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',66000.01,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4465,NULL,49722,36674,3,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',444675.00,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4466,NULL,49722,36674,3,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',48685.58,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4467,NULL,49722,36674,3,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',444675.00,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4468,NULL,49722,36674,3,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',9209.00,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL);
INSERT INTO `balance_libro` VALUES (4469,NULL,49722,36674,3,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',500.00,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4470,NULL,49722,36674,3,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',120051.26,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4471,NULL,49722,36674,3,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',8147.31,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4472,NULL,49722,36674,3,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',1200.00,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4473,NULL,49722,36674,3,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',2703.15,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4474,NULL,49722,36674,3,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',2676.76,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4475,NULL,49722,36674,3,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',15000.00,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4476,NULL,49722,36674,3,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',60000.05,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4477,NULL,49722,36674,3,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',54258.55,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4478,NULL,49722,36674,3,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',24917.40,NULL,NULL,1,'2024-01-19 11:14:50','2024-01-19 11:14:50',NULL),(4479,NULL,49722,36674,3,3874,'App\\Models\\Receipt',3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',7223.92,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4480,NULL,49722,36674,3,3875,'App\\Models\\Receipt',3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',2188.53,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4481,NULL,49722,36674,3,3876,'App\\Models\\Receipt',3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-25','2023-12-25',132341.22,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4482,NULL,49722,36674,3,3877,'App\\Models\\Receipt',3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-25','2023-12-25',11569.52,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4483,NULL,49722,36674,3,3878,'App\\Models\\Receipt',3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',3565.41,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4484,NULL,49722,36674,3,3879,'App\\Models\\Receipt',3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',3532.76,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4485,NULL,49722,36674,3,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',13223.00,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4486,NULL,49722,36674,3,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',97000.00,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4487,NULL,49722,36674,3,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',6104.28,NULL,NULL,1,'2024-01-19 11:14:51','2024-01-19 11:14:51',NULL),(4511,NULL,49722,36664,3,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',24200.00,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4512,NULL,49722,36664,3,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',16093.00,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL);
INSERT INTO `balance_libro` VALUES (4513,NULL,49722,36664,3,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',142280.70,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4514,NULL,49722,36664,3,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',10549.00,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4515,NULL,49722,36664,3,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8726.52,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4516,NULL,49722,36664,3,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',25280.02,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4517,NULL,49722,36664,3,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',400.00,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4518,NULL,49722,36664,3,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',13275.91,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4519,NULL,49722,36664,3,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',427.26,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4520,NULL,49722,36664,3,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',212.39,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4521,NULL,49722,36664,3,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',16532.05,NULL,NULL,1,'2024-01-19 12:05:38','2024-01-19 12:05:38',NULL),(4522,NULL,49722,36664,3,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',2201.89,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4523,NULL,49722,36664,3,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',59199.71,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4524,NULL,49722,36664,3,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4738.22,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4525,NULL,49722,36664,3,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',15300.01,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4526,NULL,49722,36664,3,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',10394.92,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4527,NULL,49722,36664,3,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',6084.08,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4528,NULL,49722,36664,3,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',74998.75,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4529,NULL,49722,36664,3,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1099.01,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4530,NULL,49722,36664,3,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',699.00,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4531,NULL,49722,36664,3,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',37145.81,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4532,NULL,49722,36664,3,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',33258.00,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4533,NULL,49722,36664,3,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',15368.77,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL);
INSERT INTO `balance_libro` VALUES (4534,NULL,49722,36664,3,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',14569.00,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4535,NULL,49722,36664,3,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',7143.05,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4536,NULL,49722,36664,3,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',7298.05,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4537,NULL,49722,36664,3,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',5391.86,NULL,NULL,1,'2024-01-19 12:05:39','2024-01-19 12:05:39',NULL),(4538,NULL,49722,36664,3,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',53268.38,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4539,NULL,49722,36664,3,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',4460.78,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4540,NULL,49722,36664,3,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',8712.15,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4541,NULL,49722,36664,3,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',10240.00,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4542,NULL,49722,36664,3,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',22117.02,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4543,NULL,49722,36664,3,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',17562.43,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4544,NULL,49722,36664,3,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',136.00,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4545,NULL,49722,36664,3,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',5126.97,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4546,NULL,49722,36664,3,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',513.39,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4547,NULL,49722,36664,3,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',78028.11,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4548,NULL,49722,36664,3,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',5601.91,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4549,NULL,49722,36664,3,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',21173.06,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4550,NULL,49722,36664,3,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',12164.38,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4551,NULL,49722,36664,3,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',19262.40,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4552,NULL,49722,36664,3,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',11996.70,NULL,NULL,1,'2024-01-19 12:05:40','2024-01-19 12:05:40',NULL),(4553,NULL,49722,36664,3,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',19930.92,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4554,NULL,49722,36664,3,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',27680.04,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL);
INSERT INTO `balance_libro` VALUES (4555,NULL,49722,36664,3,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10714.57,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4556,NULL,49722,36664,3,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',94580.00,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4557,NULL,49722,36664,3,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10240.00,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4558,NULL,49722,36664,3,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6154.24,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4559,NULL,49722,36664,3,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6482.56,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4560,NULL,49722,36664,3,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',67118.82,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4561,NULL,49722,36664,3,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',980.88,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4562,NULL,49722,36664,3,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3242.80,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4563,NULL,49722,36664,3,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',106.00,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4564,NULL,49722,36664,3,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4437.24,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4565,NULL,49722,36664,3,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',90.00,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4566,NULL,49722,36664,3,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16727.74,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4567,NULL,49722,36664,3,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8600.00,NULL,NULL,1,'2024-01-19 12:05:41','2024-01-19 12:05:41',NULL),(4568,NULL,49722,36665,3,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',10499.00,NULL,NULL,1,'2024-01-19 12:05:52','2024-01-19 12:05:52',NULL),(4569,NULL,49722,36665,3,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',19481.00,NULL,NULL,1,'2024-01-19 12:05:52','2024-01-19 12:05:52',NULL),(4570,NULL,49722,36665,3,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5429.76,NULL,NULL,1,'2024-01-19 12:05:52','2024-01-19 12:05:52',NULL),(4571,NULL,49722,36665,3,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',24200.00,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4572,NULL,49722,36665,3,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',602.00,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4573,NULL,49722,36665,3,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2450.84,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4574,NULL,49722,36665,3,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',4837.08,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4575,NULL,49722,36665,3,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1198.89,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL);
INSERT INTO `balance_libro` VALUES (4576,NULL,49722,36665,3,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',63578.19,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4577,NULL,49722,36665,3,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3000.00,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4578,NULL,49722,36665,3,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',5646.30,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4579,NULL,49722,36665,3,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5429.78,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4580,NULL,49722,36665,3,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',37407.69,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4581,NULL,49722,36665,3,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',44204.02,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4582,NULL,49722,36665,3,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',25700.00,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4583,NULL,49722,36665,3,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',7811.49,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4584,NULL,49722,36665,3,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',162250.00,NULL,NULL,1,'2024-01-19 12:05:53','2024-01-19 12:05:53',NULL),(4585,NULL,49722,36665,3,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',162250.00,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4586,NULL,49722,36665,3,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',4919.85,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4587,NULL,49722,36665,3,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3410.66,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4588,NULL,49722,36665,3,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',50447.67,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4589,NULL,49722,36665,3,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6491.83,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4590,NULL,49722,36665,3,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',79860.60,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4591,NULL,49722,36665,3,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3664.24,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4592,NULL,49722,36665,3,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',25280.02,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4593,NULL,49722,36665,3,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3561.92,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4594,NULL,49722,36665,3,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',136.00,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4595,NULL,49722,36665,3,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',78.00,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL),(4596,NULL,49722,36665,3,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',31200.04,NULL,NULL,1,'2024-01-19 12:05:54','2024-01-19 12:05:54',NULL);
INSERT INTO `balance_libro` VALUES (4597,NULL,49722,36665,3,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',637.16,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4598,NULL,49722,36665,3,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',212.39,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4599,NULL,49722,36665,3,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',67108.92,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4600,NULL,49722,36665,3,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4971.16,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4601,NULL,49722,36665,3,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',30034.55,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4602,NULL,49722,36665,3,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',500.00,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4603,NULL,49722,36665,3,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',2026.45,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4604,NULL,49722,36665,3,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6843.80,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4605,NULL,49722,36665,3,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',12701.66,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4606,NULL,49722,36665,3,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',25196.60,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4607,NULL,49722,36665,3,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',16188.89,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4608,NULL,49722,36665,3,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',126942.55,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4609,NULL,49722,36665,3,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',11330.95,NULL,NULL,1,'2024-01-19 12:05:55','2024-01-19 12:05:55',NULL),(4610,NULL,49722,36665,3,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',4072.04,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4611,NULL,49722,36665,3,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',6489.12,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4612,NULL,49722,36665,3,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',8145.00,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4613,NULL,49722,36665,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',85742.95,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4614,NULL,49722,36665,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',9030.00,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4615,NULL,49722,36665,3,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',75404.05,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4616,NULL,49722,36665,3,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',44707.04,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4617,NULL,49722,36665,3,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',506.61,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL);
INSERT INTO `balance_libro` VALUES (4618,NULL,49722,36665,3,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',18872.19,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4619,NULL,49722,36665,3,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',2538.00,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4620,NULL,49722,36665,3,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',13225.54,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4621,NULL,49722,36665,3,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2662.00,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4622,NULL,49722,36665,3,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',28132.45,NULL,NULL,1,'2024-01-19 12:05:56','2024-01-19 12:05:56',NULL),(4623,NULL,49722,36666,3,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',19481.00,NULL,NULL,1,'2024-01-19 12:06:09','2024-01-19 12:06:09',NULL),(4624,NULL,49722,36666,3,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',10549.00,NULL,NULL,1,'2024-01-19 12:06:09','2024-01-19 12:06:09',NULL),(4625,NULL,49722,36666,3,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1950.00,NULL,NULL,1,'2024-01-19 12:06:09','2024-01-19 12:06:09',NULL),(4626,NULL,49722,36666,3,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1950.00,NULL,NULL,1,'2024-01-19 12:06:09','2024-01-19 12:06:09',NULL),(4627,NULL,49722,36666,3,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2141.81,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4628,NULL,49722,36666,3,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',113063.65,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4629,NULL,49722,36666,3,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',93941.70,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4630,NULL,49722,36666,3,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',35203.70,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4631,NULL,49722,36666,3,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',532.89,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4632,NULL,49722,36666,3,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',615.94,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4633,NULL,49722,36666,3,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',872.73,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4634,NULL,49722,36666,3,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6395.34,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4635,NULL,49722,36666,3,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',90935.64,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4636,NULL,49722,36666,3,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',20714.35,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4637,NULL,49722,36666,3,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',80000.00,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4638,NULL,49722,36666,3,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1950.00,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL);
INSERT INTO `balance_libro` VALUES (4639,NULL,49722,36666,3,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1950.00,NULL,NULL,1,'2024-01-19 12:06:10','2024-01-19 12:06:10',NULL),(4640,NULL,49722,36666,3,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1950.00,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4641,NULL,49722,36666,3,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',53948.33,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4642,NULL,49722,36666,3,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',9862.35,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4643,NULL,49722,36666,3,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',7582.29,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4644,NULL,49722,36666,3,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',32070.02,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4645,NULL,49722,36666,3,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',62553.65,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4646,NULL,49722,36666,3,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',34908.69,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4647,NULL,49722,36666,3,4042,'App\\Models\\Receipt',4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',6419.03,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4648,NULL,49722,36666,3,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',84773.83,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4649,NULL,49722,36666,3,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',49277.50,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4650,NULL,49722,36666,3,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',5000.00,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4651,NULL,49722,36666,3,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',9934.04,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4652,NULL,49722,36666,3,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',22913.08,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4653,NULL,49722,36666,3,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',33869.00,NULL,NULL,1,'2024-01-19 12:06:11','2024-01-19 12:06:11',NULL),(4654,NULL,49722,36666,3,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',27879.05,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4655,NULL,49722,36666,3,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',25695.96,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4656,NULL,49722,36666,3,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',5398.76,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4657,NULL,49722,36666,3,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',3060.99,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4658,NULL,49722,36666,3,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8148.41,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4659,NULL,49722,36666,3,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',27062.00,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL);
INSERT INTO `balance_libro` VALUES (4660,NULL,49722,36666,3,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',86358.21,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4661,NULL,49722,36666,3,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',33869.00,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4662,NULL,49722,36666,3,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',11359.62,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4663,NULL,49722,36666,3,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',95.00,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4664,NULL,49722,36666,3,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',181.45,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4665,NULL,49722,36666,3,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',436.45,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4666,NULL,49722,36666,3,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9548.00,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4667,NULL,49722,36666,3,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',4658.50,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4668,NULL,49722,36666,3,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',16765.53,NULL,NULL,1,'2024-01-19 12:06:12','2024-01-19 12:06:12',NULL),(4669,NULL,49722,36666,3,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',25800.04,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4670,NULL,49722,36666,3,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',31508.00,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4671,NULL,49722,36666,3,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',7453.21,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4672,NULL,49722,36666,3,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',240.00,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4673,NULL,49722,36666,3,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',24427.71,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4674,NULL,49722,36666,3,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',221816.50,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4675,NULL,49722,36666,3,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',5953.48,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4676,NULL,49722,36666,3,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',52947.26,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4677,NULL,49722,36666,3,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',36714.77,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4678,NULL,49722,36666,3,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',8100.00,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4679,NULL,49722,36666,3,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',3000.00,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4680,NULL,49722,36666,3,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9481.00,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL);
INSERT INTO `balance_libro` VALUES (4681,NULL,49722,36666,3,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3665.49,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4682,NULL,49722,36666,3,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',37735.00,NULL,NULL,1,'2024-01-19 12:06:13','2024-01-19 12:06:13',NULL),(4683,NULL,49722,36667,3,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',19481.00,NULL,NULL,1,'2024-01-19 12:06:22','2024-01-19 12:06:22',NULL),(4684,NULL,49722,36667,3,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',116165.97,NULL,NULL,1,'2024-01-19 12:06:22','2024-01-19 12:06:22',NULL),(4685,NULL,49722,36667,3,4080,'App\\Models\\Receipt',4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',8930.12,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4686,NULL,49722,36667,3,4081,'App\\Models\\Receipt',4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5600.00,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4687,NULL,49722,36667,3,4082,'App\\Models\\Receipt',4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',12348.99,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4688,NULL,49722,36667,3,4083,'App\\Models\\Receipt',4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',436.45,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4689,NULL,49722,36667,3,4084,'App\\Models\\Receipt',4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',89326.12,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4690,NULL,49722,36667,3,4085,'App\\Models\\Receipt',4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',16327.91,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4691,NULL,49722,36667,3,4086,'App\\Models\\Receipt',4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',23247.08,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4692,NULL,49722,36667,3,4087,'App\\Models\\Receipt',4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',167946.31,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4693,NULL,49722,36667,3,4088,'App\\Models\\Receipt',4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',57886.68,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4694,NULL,49722,36667,3,4089,'App\\Models\\Receipt',4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',5434.12,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4695,NULL,49722,36667,3,4090,'App\\Models\\Receipt',4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',3007.30,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4696,NULL,49722,36667,3,4091,'App\\Models\\Receipt',4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',8027.30,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4697,NULL,49722,36667,3,4092,'App\\Models\\Receipt',4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',99118.25,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4698,NULL,49722,36667,3,4093,'App\\Models\\Receipt',4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',3800.61,NULL,NULL,1,'2024-01-19 12:06:23','2024-01-19 12:06:23',NULL),(4699,NULL,49722,36667,3,4094,'App\\Models\\Receipt',4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',14604.10,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4700,NULL,49722,36667,3,4095,'App\\Models\\Receipt',4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',41300.02,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4701,NULL,49722,36667,3,4096,'App\\Models\\Receipt',4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',21026.52,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL);
INSERT INTO `balance_libro` VALUES (4702,NULL,49722,36667,3,4097,'App\\Models\\Receipt',4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',3331.53,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4703,NULL,49722,36667,3,4098,'App\\Models\\Receipt',4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',84283.27,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4704,NULL,49722,36667,3,4099,'App\\Models\\Receipt',4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',124241.37,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4705,NULL,49722,36667,3,4100,'App\\Models\\Receipt',4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',10749.53,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4706,NULL,49722,36667,3,4101,'App\\Models\\Receipt',4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4356.00,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4707,NULL,49722,36667,3,4102,'App\\Models\\Receipt',4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',8000.00,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4708,NULL,49722,36667,3,4103,'App\\Models\\Receipt',4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',22498.57,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4709,NULL,49722,36667,3,4104,'App\\Models\\Receipt',4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',28882.02,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4710,NULL,49722,36667,3,4105,'App\\Models\\Receipt',4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',10890.00,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4711,NULL,49722,36667,3,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',17107.05,NULL,NULL,1,'2024-01-19 12:06:24','2024-01-19 12:06:24',NULL),(4712,NULL,49722,36667,3,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',23780.02,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4713,NULL,49722,36667,3,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',4354.40,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4714,NULL,49722,36667,3,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',28455.03,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4715,NULL,49722,36667,3,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',22242.80,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4716,NULL,49722,36667,3,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',105152.30,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4717,NULL,49722,36667,3,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',9005.83,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4718,NULL,49722,36667,3,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',254.03,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4719,NULL,49722,36667,3,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',33239.38,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4720,NULL,49722,36667,3,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',4356.82,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4721,NULL,49722,36667,3,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',730.84,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4722,NULL,49722,36667,3,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',22709.29,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL);
INSERT INTO `balance_libro` VALUES (4723,NULL,49722,36667,3,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',27922.00,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4724,NULL,49722,36667,3,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',10243.42,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4725,NULL,49722,36667,3,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',133928.18,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4726,NULL,49722,36667,3,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',19852.22,NULL,NULL,1,'2024-01-19 12:06:25','2024-01-19 12:06:25',NULL),(4727,NULL,49722,36667,3,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',60.00,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4728,NULL,49722,36667,3,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',13786.00,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4729,NULL,49722,36667,3,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',5649.65,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4730,NULL,49722,36667,3,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',2000.02,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4731,NULL,49722,36667,3,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',10275.37,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4732,NULL,49722,36667,3,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',9955.00,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4733,NULL,49722,36667,3,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',33096.00,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4734,NULL,49722,36667,3,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',3080.00,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4735,NULL,49722,36667,3,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',135362.45,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4736,NULL,49722,36667,3,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',4999.88,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4737,NULL,49722,36667,3,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10512.48,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4738,NULL,49722,36667,3,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',21000.00,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4739,NULL,49722,36667,3,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',5625.78,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4740,NULL,49722,36667,3,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',91806.27,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4741,NULL,49722,36667,3,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',413223.30,NULL,NULL,1,'2024-01-19 12:06:26','2024-01-19 12:06:26',NULL),(4742,NULL,49722,36667,3,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',608279.90,NULL,NULL,1,'2024-01-19 12:06:27','2024-01-19 12:06:27',NULL),(4743,NULL,49722,36667,3,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',608279.90,NULL,NULL,1,'2024-01-19 12:06:27','2024-01-19 12:06:27',NULL);
INSERT INTO `balance_libro` VALUES (4744,NULL,49722,36667,3,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',63405.26,NULL,NULL,1,'2024-01-19 12:06:27','2024-01-19 12:06:27',NULL),(4745,NULL,49722,36668,3,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',25047.00,NULL,NULL,1,'2024-01-19 12:06:39','2024-01-19 12:06:39',NULL),(4746,NULL,49722,36668,3,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',12299.00,NULL,NULL,1,'2024-01-19 12:06:39','2024-01-19 12:06:39',NULL),(4747,NULL,49722,36668,3,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',359.25,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4748,NULL,49722,36668,3,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',26160.27,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4749,NULL,49722,36668,3,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',38800.05,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4750,NULL,49722,36668,3,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',2319.89,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4751,NULL,49722,36668,3,4146,'App\\Models\\Receipt',4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',134816.60,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4752,NULL,49722,36668,3,4147,'App\\Models\\Receipt',4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',5363.27,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4753,NULL,49722,36668,3,4148,'App\\Models\\Receipt',4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',10794.69,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4754,NULL,49722,36668,3,4149,'App\\Models\\Receipt',4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',15367.44,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4755,NULL,49722,36668,3,4150,'App\\Models\\Receipt',4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',33396.00,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4756,NULL,49722,36668,3,4151,'App\\Models\\Receipt',4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',8130.00,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4757,NULL,49722,36668,3,4152,'App\\Models\\Receipt',4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',5500.00,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4758,NULL,49722,36668,3,4153,'App\\Models\\Receipt',4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',374449.02,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4759,NULL,49722,36668,3,4154,'App\\Models\\Receipt',4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',72371.96,NULL,NULL,1,'2024-01-19 12:06:40','2024-01-19 12:06:40',NULL),(4760,NULL,49722,36668,3,4155,'App\\Models\\Receipt',4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',8272.88,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4761,NULL,49722,36668,3,4156,'App\\Models\\Receipt',4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',33500.00,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4762,NULL,49722,36668,3,4157,'App\\Models\\Receipt',4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',37754.03,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4763,NULL,49722,36668,3,4158,'App\\Models\\Receipt',4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',25397.82,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4764,NULL,49722,36668,3,4159,'App\\Models\\Receipt',4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',60002.29,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL);
INSERT INTO `balance_libro` VALUES (4765,NULL,49722,36668,3,4160,'App\\Models\\Receipt',4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',5367.43,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4766,NULL,49722,36668,3,4161,'App\\Models\\Receipt',4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',12406.13,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4767,NULL,49722,36668,3,4162,'App\\Models\\Receipt',4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',28.96,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4768,NULL,49722,36668,3,4163,'App\\Models\\Receipt',4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',24316.10,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4769,NULL,49722,36668,3,4164,'App\\Models\\Receipt',4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',302884.32,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4770,NULL,49722,36668,3,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',11005.45,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4771,NULL,49722,36668,3,4166,'App\\Models\\Receipt',4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',146517.98,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4772,NULL,49722,36668,3,4167,'App\\Models\\Receipt',4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',66792.00,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4773,NULL,49722,36668,3,4168,'App\\Models\\Receipt',4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',10455.15,NULL,NULL,1,'2024-01-19 12:06:41','2024-01-19 12:06:41',NULL),(4774,NULL,49722,36668,3,4169,'App\\Models\\Receipt',4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',25902.02,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4775,NULL,49722,36668,3,4170,'App\\Models\\Receipt',4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',72371.96,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4776,NULL,49722,36668,3,4171,'App\\Models\\Receipt',4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',20314.92,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4777,NULL,49722,36668,3,4172,'App\\Models\\Receipt',4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2650.00,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4778,NULL,49722,36668,3,4173,'App\\Models\\Receipt',4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',8886.00,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4779,NULL,49722,36668,3,4174,'App\\Models\\Receipt',4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',14000.00,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4780,NULL,49722,36668,3,4175,'App\\Models\\Receipt',4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',2498.93,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4781,NULL,49722,36668,3,4176,'App\\Models\\Receipt',4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',52348.14,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4782,NULL,49722,36668,3,4177,'App\\Models\\Receipt',4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',50308.38,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4783,NULL,49722,36668,3,4178,'App\\Models\\Receipt',4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',6358.32,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4784,NULL,49722,36668,3,4179,'App\\Models\\Receipt',4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',41458.00,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4785,NULL,49722,36668,3,4180,'App\\Models\\Receipt',4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',5649.72,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL);
INSERT INTO `balance_libro` VALUES (4786,NULL,49722,36668,3,4181,'App\\Models\\Receipt',4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',1950.00,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4787,NULL,49722,36668,3,4182,'App\\Models\\Receipt',4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',167629.14,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4788,NULL,49722,36668,3,4183,'App\\Models\\Receipt',4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',13770.93,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4789,NULL,49722,36668,3,4184,'App\\Models\\Receipt',4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',431.16,NULL,NULL,1,'2024-01-19 12:06:42','2024-01-19 12:06:42',NULL),(4790,NULL,49722,36668,3,4185,'App\\Models\\Receipt',4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',23040.10,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4791,NULL,49722,36668,3,4186,'App\\Models\\Receipt',4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',410.04,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4792,NULL,49722,36668,3,4187,'App\\Models\\Receipt',4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',37512.04,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4793,NULL,49722,36668,3,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',25359.91,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4794,NULL,49722,36668,3,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',1000.00,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4795,NULL,49722,36668,3,4190,'App\\Models\\Receipt',4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',62033.07,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4796,NULL,49722,36668,3,4191,'App\\Models\\Receipt',4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',14130.22,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4797,NULL,49722,36668,3,4192,'App\\Models\\Receipt',4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',8000.08,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4798,NULL,49722,36668,3,4193,'App\\Models\\Receipt',4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',39000.05,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4799,NULL,49722,36668,3,4194,'App\\Models\\Receipt',4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',14250.54,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4800,NULL,49722,36668,3,4195,'App\\Models\\Receipt',4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',163882.31,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4801,NULL,49722,36668,3,4196,'App\\Models\\Receipt',4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',13355.74,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4802,NULL,49722,36668,3,4197,'App\\Models\\Receipt',4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',217042.74,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4803,NULL,49722,36668,3,4198,'App\\Models\\Receipt',4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',19215.83,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4804,NULL,49722,36668,3,4199,'App\\Models\\Receipt',4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',80723.38,NULL,NULL,1,'2024-01-19 12:06:43','2024-01-19 12:06:43',NULL),(4805,NULL,49722,36668,3,4200,'App\\Models\\Receipt',4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',20762.17,NULL,NULL,1,'2024-01-19 12:06:44','2024-01-19 12:06:44',NULL),(4806,NULL,49722,36668,3,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',10353.00,NULL,NULL,1,'2024-01-19 12:06:44','2024-01-19 12:06:44',NULL);
INSERT INTO `balance_libro` VALUES (4807,NULL,49722,36668,3,4202,'App\\Models\\Receipt',4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',4258.46,NULL,NULL,1,'2024-01-19 12:06:44','2024-01-19 12:06:44',NULL),(4808,NULL,49722,36668,3,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',363461.16,NULL,NULL,1,'2024-01-19 12:06:44','2024-01-19 12:06:44',NULL),(4809,NULL,49722,36668,3,4204,'App\\Models\\Receipt',4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',19999.00,NULL,NULL,1,'2024-01-19 12:06:44','2024-01-19 12:06:44',NULL),(4810,NULL,49722,36668,3,4205,'App\\Models\\Receipt',4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',49216.76,NULL,NULL,1,'2024-01-19 12:06:44','2024-01-19 12:06:44',NULL),(4811,NULL,49722,36669,3,4206,'App\\Models\\Receipt',4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',25047.00,NULL,NULL,1,'2024-01-19 12:06:55','2024-01-19 12:06:55',NULL),(4812,NULL,49722,36669,3,4207,'App\\Models\\Receipt',4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',12299.00,NULL,NULL,1,'2024-01-19 12:06:55','2024-01-19 12:06:55',NULL),(4813,NULL,49722,36669,3,4208,'App\\Models\\Receipt',4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',8268.10,NULL,NULL,1,'2024-01-19 12:06:55','2024-01-19 12:06:55',NULL),(4814,NULL,49722,36669,3,4209,'App\\Models\\Receipt',4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',104843.61,NULL,NULL,1,'2024-01-19 12:06:55','2024-01-19 12:06:55',NULL),(4815,NULL,49722,36669,3,4210,'App\\Models\\Receipt',4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',1027.90,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4816,NULL,49722,36669,3,4211,'App\\Models\\Receipt',4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',154702.91,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4817,NULL,49722,36669,3,4212,'App\\Models\\Receipt',4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',4000.00,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4818,NULL,49722,36669,3,4213,'App\\Models\\Receipt',4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',11950.23,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4819,NULL,49722,36669,3,4214,'App\\Models\\Receipt',4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',610.78,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4820,NULL,49722,36669,3,4215,'App\\Models\\Receipt',4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',27885.72,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4821,NULL,49722,36669,3,4216,'App\\Models\\Receipt',4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',200.00,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4822,NULL,49722,36669,3,4217,'App\\Models\\Receipt',4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',3352.32,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4823,NULL,49722,36669,3,4218,'App\\Models\\Receipt',4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',250.00,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4824,NULL,49722,36669,3,4219,'App\\Models\\Receipt',4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',11089.99,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4825,NULL,49722,36669,3,4220,'App\\Models\\Receipt',4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',8223.00,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4826,NULL,49722,36669,3,4221,'App\\Models\\Receipt',4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',7999.00,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4827,NULL,49722,36669,3,4222,'App\\Models\\Receipt',4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',26616.04,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL);
INSERT INTO `balance_libro` VALUES (4828,NULL,49722,36669,3,4223,'App\\Models\\Receipt',4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',36326.08,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4829,NULL,49722,36669,3,4224,'App\\Models\\Receipt',4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-09','2023-07-09',16999.00,NULL,NULL,1,'2024-01-19 12:06:56','2024-01-19 12:06:56',NULL),(4830,NULL,49722,36669,3,4225,'App\\Models\\Receipt',4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',56244.72,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4831,NULL,49722,36669,3,4226,'App\\Models\\Receipt',4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',10803.26,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4832,NULL,49722,36669,3,4227,'App\\Models\\Receipt',4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',144263.66,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4833,NULL,49722,36669,3,4228,'App\\Models\\Receipt',4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',68568.04,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4834,NULL,49722,36669,3,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',54600.00,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4835,NULL,49722,36669,3,4230,'App\\Models\\Receipt',4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',15428.14,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4836,NULL,49722,36669,3,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',5405.01,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4837,NULL,49722,36669,3,4232,'App\\Models\\Receipt',4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',30363.35,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4838,NULL,49722,36669,3,4233,'App\\Models\\Receipt',4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',103248.29,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4839,NULL,49722,36669,3,4234,'App\\Models\\Receipt',4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',9014.46,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4840,NULL,49722,36669,3,4235,'App\\Models\\Receipt',4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',254.03,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4841,NULL,49722,36669,3,4236,'App\\Models\\Receipt',4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',22203.50,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4842,NULL,49722,36669,3,4237,'App\\Models\\Receipt',4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',500.00,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4843,NULL,49722,36669,3,4238,'App\\Models\\Receipt',4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',53792.19,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4844,NULL,49722,36669,3,4239,'App\\Models\\Receipt',4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',4779.04,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4845,NULL,49722,36669,3,4240,'App\\Models\\Receipt',4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',8153.88,NULL,NULL,1,'2024-01-19 12:06:57','2024-01-19 12:06:57',NULL),(4846,NULL,49722,36669,3,4241,'App\\Models\\Receipt',4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',206123.09,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4847,NULL,49722,36669,3,4242,'App\\Models\\Receipt',4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',14716.55,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4848,NULL,49722,36669,3,4243,'App\\Models\\Receipt',4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',8886.00,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL);
INSERT INTO `balance_libro` VALUES (4849,NULL,49722,36669,3,4244,'App\\Models\\Receipt',4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',40572.50,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4850,NULL,49722,36669,3,4245,'App\\Models\\Receipt',4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',23400.03,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4851,NULL,49722,36669,3,4246,'App\\Models\\Receipt',4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',927867.03,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4852,NULL,49722,36669,3,4247,'App\\Models\\Receipt',4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',58124.99,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4853,NULL,49722,36669,3,4248,'App\\Models\\Receipt',4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',10767.00,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4854,NULL,49722,36669,3,4249,'App\\Models\\Receipt',4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',159420.90,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4855,NULL,49722,36669,3,4250,'App\\Models\\Receipt',4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',11242.20,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4856,NULL,49722,36669,3,4251,'App\\Models\\Receipt',4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',752795.27,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4857,NULL,49722,36669,3,4252,'App\\Models\\Receipt',4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',23400.03,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4858,NULL,49722,36669,3,4253,'App\\Models\\Receipt',4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',78000.11,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4859,NULL,49722,36669,3,4254,'App\\Models\\Receipt',4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',246360.43,NULL,NULL,1,'2024-01-19 12:06:58','2024-01-19 12:06:58',NULL),(4860,NULL,49722,36669,3,4255,'App\\Models\\Receipt',4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',28347.03,NULL,NULL,1,'2024-01-19 12:06:59','2024-01-19 12:06:59',NULL),(4861,NULL,49722,36669,3,4256,'App\\Models\\Receipt',4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',752795.27,NULL,NULL,1,'2024-01-19 12:06:59','2024-01-19 12:06:59',NULL),(4862,NULL,49722,36669,3,4257,'App\\Models\\Receipt',4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',17000.50,NULL,NULL,1,'2024-01-19 12:06:59','2024-01-19 12:06:59',NULL),(4863,NULL,49722,36670,3,4258,'App\\Models\\Receipt',4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',21780.00,NULL,NULL,1,'2024-01-19 12:07:10','2024-01-19 12:07:10',NULL),(4864,NULL,49722,36670,3,4259,'App\\Models\\Receipt',4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',16198.00,NULL,NULL,1,'2024-01-19 12:07:10','2024-01-19 12:07:10',NULL),(4865,NULL,49722,36670,3,4260,'App\\Models\\Receipt',4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',59360.02,NULL,NULL,1,'2024-01-19 12:07:10','2024-01-19 12:07:10',NULL),(4866,NULL,49722,36670,3,4261,'App\\Models\\Receipt',4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',2.06,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4867,NULL,49722,36670,3,4262,'App\\Models\\Receipt',4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1200.00,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4868,NULL,49722,36670,3,4263,'App\\Models\\Receipt',4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',359.25,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4869,NULL,49722,36670,3,4264,'App\\Models\\Receipt',4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',57981.59,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL);
INSERT INTO `balance_libro` VALUES (4870,NULL,49722,36670,3,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',15428.14,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4871,NULL,49722,36670,3,4266,'App\\Models\\Receipt',4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',3598.84,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4872,NULL,49722,36670,3,4267,'App\\Models\\Receipt',4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',46284.43,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4873,NULL,49722,36670,3,4268,'App\\Models\\Receipt',4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',46284.43,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4874,NULL,49722,36670,3,4269,'App\\Models\\Receipt',4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',116199.71,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4875,NULL,49722,36670,3,4270,'App\\Models\\Receipt',4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',10267.28,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4876,NULL,49722,36670,3,4271,'App\\Models\\Receipt',4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',663190.73,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4877,NULL,49722,36670,3,4272,'App\\Models\\Receipt',4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',3263.10,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4878,NULL,49722,36670,3,4273,'App\\Models\\Receipt',4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',4107.13,NULL,NULL,1,'2024-01-19 12:07:11','2024-01-19 12:07:11',NULL),(4879,NULL,49722,36670,3,4274,'App\\Models\\Receipt',4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',53047.13,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4880,NULL,49722,36670,3,4275,'App\\Models\\Receipt',4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',11164.00,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4881,NULL,49722,36670,3,4276,'App\\Models\\Receipt',4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',15800.00,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4882,NULL,49722,36670,3,4277,'App\\Models\\Receipt',4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',43997.39,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4883,NULL,49722,36670,3,4278,'App\\Models\\Receipt',4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',38738.00,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4884,NULL,49722,36670,3,4279,'App\\Models\\Receipt',4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',4107.13,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4885,NULL,49722,36670,3,4280,'App\\Models\\Receipt',4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',8798.79,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4886,NULL,49722,36670,3,4281,'App\\Models\\Receipt',4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',95013.35,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4887,NULL,49722,36670,3,4282,'App\\Models\\Receipt',4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',12566.78,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4888,NULL,49722,36670,3,4283,'App\\Models\\Receipt',4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',2658.30,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4889,NULL,49722,36670,3,4284,'App\\Models\\Receipt',4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8451.11,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4890,NULL,49722,36670,3,4285,'App\\Models\\Receipt',4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',300.00,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL);
INSERT INTO `balance_libro` VALUES (4891,NULL,49722,36670,3,4286,'App\\Models\\Receipt',4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',23056.41,NULL,NULL,1,'2024-01-19 12:07:12','2024-01-19 12:07:12',NULL),(4892,NULL,49722,36670,3,4287,'App\\Models\\Receipt',4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',82929.57,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4893,NULL,49722,36670,3,4288,'App\\Models\\Receipt',4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',1042.19,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4894,NULL,49722,36670,3,4289,'App\\Models\\Receipt',4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',127784.83,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4895,NULL,49722,36670,3,4290,'App\\Models\\Receipt',4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',4107.13,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4896,NULL,49722,36670,3,4291,'App\\Models\\Receipt',4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',7480.93,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4897,NULL,49722,36670,3,4292,'App\\Models\\Receipt',4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',84255.16,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4898,NULL,49722,36670,3,4293,'App\\Models\\Receipt',4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',4107.13,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4899,NULL,49722,36670,3,4294,'App\\Models\\Receipt',4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',529881.07,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4900,NULL,49722,36670,3,4295,'App\\Models\\Receipt',4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',21824.00,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4901,NULL,49722,36670,3,4296,'App\\Models\\Receipt',4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',78870.00,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4902,NULL,49722,36670,3,4297,'App\\Models\\Receipt',4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',30855.65,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4903,NULL,49722,36670,3,4298,'App\\Models\\Receipt',4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',20570.86,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4904,NULL,49722,36670,3,4299,'App\\Models\\Receipt',4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',22378.14,NULL,NULL,1,'2024-01-19 12:07:13','2024-01-19 12:07:13',NULL),(4905,NULL,49722,36670,3,4300,'App\\Models\\Receipt',4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',2410.60,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4906,NULL,49722,36670,3,4301,'App\\Models\\Receipt',4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',38676.00,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4907,NULL,49722,36670,3,4302,'App\\Models\\Receipt',4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',11197.00,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4908,NULL,49722,36670,3,4303,'App\\Models\\Receipt',4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-27','2023-08-27',56244.72,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4909,NULL,49722,36670,3,4304,'App\\Models\\Receipt',4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-27','2023-08-27',56244.72,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4910,NULL,49722,36670,3,4305,'App\\Models\\Receipt',4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',111995.31,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4911,NULL,49722,36670,3,4306,'App\\Models\\Receipt',4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',9121.20,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL);
INSERT INTO `balance_libro` VALUES (4912,NULL,49722,36670,3,4307,'App\\Models\\Receipt',4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',9079.35,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4913,NULL,49722,36670,3,4308,'App\\Models\\Receipt',4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',61175.07,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4914,NULL,49722,36670,3,4309,'App\\Models\\Receipt',4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',493166.76,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4915,NULL,49722,36670,3,4310,'App\\Models\\Receipt',4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',2679.83,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4916,NULL,49722,36670,3,4311,'App\\Models\\Receipt',4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',51784.48,NULL,NULL,1,'2024-01-19 12:07:14','2024-01-19 12:07:14',NULL),(4917,7902,49722,36671,3,4312,'App\\Models\\Receipt',4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',32065.00,NULL,NULL,1,'2024-01-19 12:07:24','2024-01-19 12:07:24',NULL),(4918,7902,49722,36671,3,4313,'App\\Models\\Receipt',4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',21680.22,NULL,NULL,1,'2024-01-19 12:07:24','2024-01-19 12:07:24',NULL),(4919,7902,49722,36671,3,4314,'App\\Models\\Receipt',4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',16198.00,NULL,NULL,1,'2024-01-19 12:07:24','2024-01-19 12:07:24',NULL),(4920,7902,49722,36671,3,4315,'App\\Models\\Receipt',4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',40500.49,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4921,7902,49722,36671,3,4316,'App\\Models\\Receipt',4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',2851.53,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4922,7902,49722,36671,3,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',150.00,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4923,7902,49722,36671,3,4318,'App\\Models\\Receipt',4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',550.00,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4924,7902,49722,36671,3,4319,'App\\Models\\Receipt',4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',1149.91,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4925,7902,49722,36671,3,4320,'App\\Models\\Receipt',4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',13359.36,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4926,7902,49722,36671,3,4321,'App\\Models\\Receipt',4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',101386.19,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4927,7902,49722,36671,3,4322,'App\\Models\\Receipt',4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',8583.10,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4928,7902,49722,36671,3,4323,'App\\Models\\Receipt',4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',2994.18,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4929,7902,49722,36671,3,4324,'App\\Models\\Receipt',4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',8541.75,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4930,7902,49722,36671,3,4325,'App\\Models\\Receipt',4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',18812.64,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4931,7902,49722,36671,3,4326,'App\\Models\\Receipt',4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',20962.07,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL),(4932,7902,49722,36671,3,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',43682.24,NULL,NULL,1,'2024-01-19 12:07:25','2024-01-19 12:07:25',NULL);
INSERT INTO `balance_libro` VALUES (4933,7902,49722,36671,3,4328,'App\\Models\\Receipt',4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',15171.79,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4934,7902,49722,36671,3,4329,'App\\Models\\Receipt',4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',55500.00,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4935,7902,49722,36671,3,4330,'App\\Models\\Receipt',4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',10405.86,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4936,7902,49722,36671,3,4331,'App\\Models\\Receipt',4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',158610.69,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4937,7902,49722,36671,3,4332,'App\\Models\\Receipt',4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',9914.25,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4938,7902,49722,36671,3,4333,'App\\Models\\Receipt',4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',5100.00,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4939,7902,49722,36671,3,4334,'App\\Models\\Receipt',4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',20223.09,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4940,7902,49722,36671,3,4335,'App\\Models\\Receipt',4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',21051.83,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4941,7902,49722,36671,3,4336,'App\\Models\\Receipt',4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',17586.21,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4942,7902,49722,36671,3,4337,'App\\Models\\Receipt',4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',7967.28,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4943,7902,49722,36671,3,4338,'App\\Models\\Receipt',4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',64175.22,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4944,7902,49722,36671,3,4339,'App\\Models\\Receipt',4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',1403.96,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4945,7902,49722,36671,3,4340,'App\\Models\\Receipt',4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',9076.96,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4946,7902,49722,36671,3,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',500.00,NULL,NULL,1,'2024-01-19 12:07:26','2024-01-19 12:07:26',NULL),(4947,7902,49722,36671,3,4342,'App\\Models\\Receipt',4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',600.00,NULL,NULL,1,'2024-01-19 12:07:27','2024-01-19 12:07:27',NULL),(4948,7902,49722,36671,3,4343,'App\\Models\\Receipt',4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',110659.75,NULL,NULL,1,'2024-01-19 12:07:27','2024-01-19 12:07:27',NULL),(4949,7902,49722,36671,3,4344,'App\\Models\\Receipt',4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',8833.50,NULL,NULL,1,'2024-01-19 12:07:27','2024-01-19 12:07:27',NULL),(4950,7902,49722,36671,3,4345,'App\\Models\\Receipt',4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',38569.05,NULL,NULL,1,'2024-01-19 12:07:27','2024-01-19 12:07:27',NULL),(4951,7902,49722,36671,3,4346,'App\\Models\\Receipt',4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',949815.30,NULL,NULL,1,'2024-01-19 12:07:27','2024-01-19 12:07:27',NULL),(4952,7902,49722,36671,3,4347,'App\\Models\\Receipt',4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',1000.00,NULL,NULL,1,'2024-01-19 12:07:27','2024-01-19 12:07:27',NULL),(4953,7902,49722,36671,3,4348,'App\\Models\\Receipt',4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',55500.00,NULL,NULL,1,'2024-01-19 12:07:27','2024-01-19 12:07:27',NULL);
IN