-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-31934553-2
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-24 09:46:52','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-24 09:46:52','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'AFIP','200215Luis',NULL,1,40721,'2022-10-27'),(2,'AGIP','200215Luis',NULL,2,40721,'2022-10-27'),(3,NULL,'quillahuaman1804R',NULL,1,40722,'2022-10-27'),(4,NULL,'Bernardo269',NULL,2,40722,'2022-10-27'),(5,NULL,'1343889057',NULL,32,40722,'2022-10-27'),(6,NULL,'2507Marina',NULL,1,40724,'2022-10-28'),(7,'Rentas Entre Rios','2506Marina',NULL,41,40724,'2022-10-28'),(8,NULL,'Selena0001',NULL,1,40723,'2022-10-28'),(9,NULL,'Selena0002',NULL,2,40723,'2022-10-28'),(10,NULL,'quillahuaman1804R',NULL,1,40722,'2022-10-28'),(11,NULL,'Bernardo269',NULL,2,40722,'2022-10-28'),(12,NULL,'1343889057',NULL,32,40722,'2022-10-28'),(13,NULL,'estudio1',NULL,44,40722,'2022-10-28'),(14,'AFIP','200215Luis',NULL,1,40721,'2022-10-28'),(15,'AGIP','200215Luis',NULL,2,40721,'2022-10-28'),(16,'ARBA','MyContador2022',NULL,3,40719,'2023-03-07'),(17,'AFIP','MyContador2022',NULL,1,40719,'2023-03-07'),(18,'AGIP','MyContador2022',NULL,2,40719,'2023-03-07'),(19,'23332031929','Martin00002','Socia',1,40725,'2023-03-22'),(20,'23332031929','1b1e0c1e','Socio Gerente',2,40725,'2023-03-22'),(21,'23332031929','1b1e0c1e','Clave Socio Gerente',3,40725,'2023-03-22'),(22,'23332031929','Martin00002','Socia',1,40725,'2023-03-22'),(23,'23332031929','1b1e0c1e','Socio Gerente',2,40725,'2023-03-22'),(24,'23332031929','1b1e0c1e','Clave Socio Gerente',3,40725,'2023-03-22'),(25,NULL,'2507Marina',NULL,1,40724,'2023-04-23'),(26,'Rentas Entre Rios','2506Marina',NULL,41,40724,'2023-04-23'),(27,'AFIP','200215Luis',NULL,1,40721,'2023-04-23'),(28,'AGIP','200215Luis',NULL,2,40721,'2023-04-23'),(29,NULL,'2507Marina',NULL,1,40724,'2023-04-23'),(30,'Rentas Entre Rios','2506Marina',NULL,41,40724,'2023-04-23'),(31,'AFIP','200215Luis',NULL,1,40721,'2023-04-23'),(32,'AGIP','200215Luis',NULL,2,40721,'2023-04-23'),(33,'ARBA','MyContador2022',NULL,3,40719,'2023-04-23'),(34,'AFIP','MyContador2022',NULL,1,40719,'2023-04-23'),(35,'AGIP','MyContador2022',NULL,2,40719,'2023-04-23'),(36,'ARBA','MyContador2022',NULL,3,40719,'2023-04-23'),(37,'AFIP','MyContador2022',NULL,1,40719,'2023-04-23'),(38,'AGIP','MyContador2022',NULL,2,40719,'2023-04-23'),(39,'ARBA','MyContador2022',NULL,3,40719,'2023-04-23'),(40,'AFIP','MyContador2022',NULL,1,40719,'2023-04-23'),(41,'AGIP','MyContador2022',NULL,2,40719,'2023-04-23'),(42,'AFIP','200215Luis',NULL,1,40721,'2023-04-23'),(43,'AGIP','200215Luis',NULL,2,40721,'2023-04-23'),(44,'AFIP','200215Luis',NULL,1,40721,'2023-04-23'),(45,'AGIP','200215Luis',NULL,2,40721,'2023-04-23'),(46,'AFIP','200215Luis',NULL,1,40721,'2023-04-23'),(47,'AGIP','200215Luis',NULL,2,40721,'2023-04-23'),(48,NULL,'2507Marina',NULL,1,40724,'2023-04-23'),(49,'Rentas Entre Rios','2506Marina',NULL,41,40724,'2023-04-23'),(50,'23332031929','Martin00002','Socia',1,40725,'2023-04-23'),(51,'23332031929','1b1e0c1e','Socio Gerente',2,40725,'2023-04-23'),(52,'23332031929','1b1e0c1e','Clave Socio Gerente',3,40725,'2023-04-23'),(53,NULL,'Selena0001',NULL,1,40723,'2023-04-23'),(54,NULL,'Selena0002',NULL,2,40723,'2023-04-23'),(55,NULL,'quillahuaman1804R',NULL,1,40722,'2023-04-23'),(56,NULL,'Bernardo269',NULL,2,40722,'2023-04-23'),(57,NULL,'1343889057',NULL,32,40722,'2023-04-23'),(58,NULL,'estudio1',NULL,44,40722,'2023-04-23'),(59,'27330199100','24Bustamante','Ignacio (Socio Gerente)',1,40843,'2023-04-23'),(60,'27330199100','241Bustamante','Socia Gerente (Anterior)',2,40843,'2023-04-23'),(61,'AFIP','Catalina187',NULL,1,40727,'2023-04-23'),(62,'ARBA','Silverado1987',NULL,3,40727,'2023-04-23'),(63,NULL,'rosa29265L',NULL,1,40722,'2023-04-23'),(64,NULL,'Bernardo2690',NULL,2,40722,'2023-04-23'),(65,NULL,'1343889057',NULL,32,40722,'2023-04-23'),(66,NULL,'estudio1',NULL,44,40722,'2023-04-23'),(67,NULL,'Ferreteriadecarrera95',NULL,1,40842,'2023-04-23'),(68,NULL,'Wolter2020',NULL,3,40842,'2023-04-23'),(69,NULL,'rosa29265L',NULL,1,40722,'2023-04-23'),(70,NULL,'Bernardo2690',NULL,2,40722,'2023-04-23'),(71,NULL,'1343889057',NULL,32,40722,'2023-04-23'),(72,NULL,'estudio1',NULL,44,40722,'2023-04-23');
INSERT INTO `back_up_claves_details` VALUES (73,'ARBA','MyContador2022',NULL,3,40719,'2023-04-23'),(74,'AFIP','MyContador2022',NULL,1,40719,'2023-04-23'),(75,'AGIP','MyContador2022',NULL,2,40719,'2023-04-23'),(76,'ARBA','MyContador2022',NULL,3,40719,'2023-04-23'),(77,'AFIP','MyContador2022',NULL,1,40719,'2023-04-23'),(78,'AGIP','MyContador2022',NULL,2,40719,'2023-04-23'),(79,'ARBA','MyContador2022',NULL,3,40719,'2023-04-23'),(80,'AFIP','MyContador2022',NULL,1,40719,'2023-04-23'),(81,'AGIP','MyContador2022',NULL,2,40719,'2023-04-23'),(82,'AFIP','Sanblas3066',NULL,1,40841,'2023-04-28'),(83,'ARBA','Kousagi8977,,',NULL,3,40841,'2023-04-28'),(84,'AGIP','Kousagi8977,,',NULL,2,40841,'2023-04-28'),(85,NULL,'Pauleanbarzana1927',NULL,1,40855,'2023-04-29'),(86,NULL,'Paulean20210',NULL,2,40855,'2023-04-29'),(87,NULL,'Paulean20210',NULL,3,40855,'2023-04-29'),(88,'AFIP','Macarena0004',NULL,1,40799,'2023-05-29'),(89,'AGIP','Macarena0002',NULL,2,40799,'2023-05-29'),(90,NULL,'Selena0002',NULL,1,40723,'2023-05-30'),(91,NULL,'Selena0002',NULL,2,40723,'2023-05-30'),(92,NULL,'Selena0002',NULL,3,40723,'2023-05-30'),(93,NULL,'Ferreteriadecarrera95',NULL,1,40842,'2023-05-31'),(94,NULL,'Wolter2020',NULL,3,40842,'2023-05-31'),(95,'AFIP','Sanblas3066',NULL,1,40841,'2023-06-01'),(96,'ARBA','Kousagi8977,,',NULL,3,40841,'2023-06-01'),(97,'AGIP','Kousagi8977,,',NULL,2,40841,'2023-06-01'),(98,NULL,'Agusdisney2023',NULL,1,40852,'2023-06-01'),(99,NULL,'Agustina2022',NULL,3,40852,'2023-06-01'),(100,NULL,'Agustina2022',NULL,2,40852,'2023-06-01'),(101,'AFIP','Bruja040943',NULL,1,40800,'2023-06-01'),(102,'ARBA','Bruja040943',NULL,3,40800,'2023-06-01'),(103,'AGIP','Bruja040943',NULL,2,40800,'2023-06-01'),(104,'AFIP','Catalina187',NULL,1,40727,'2023-06-20'),(105,'ARBA','Silverado1987',NULL,3,40727,'2023-06-20'),(106,NULL,'rosa29265L',NULL,1,40722,'2023-07-05'),(107,NULL,'Bernardo2690',NULL,2,40722,'2023-07-05'),(108,NULL,'1343889057',NULL,32,40722,'2023-07-05'),(109,NULL,'estudio1',NULL,44,40722,'2023-07-05'),(110,'23338108699','Helguera3692','Bongiorno Esteban Daniel (Socio Gerente)',1,40851,'2023-08-25'),(111,'23338108699','Caracas1988','Facundo Rey (Socio)',2,40851,'2023-08-25'),(112,'23338108699','Caracas1988','Bongiorno Esteban Daniel (Clave Socio Gerente)',3,40851,'2023-08-25'),(113,'AFIP','Alejandro2022',NULL,1,40798,'2023-09-05'),(114,'ARBA','jl1234le0',NULL,3,40798,'2023-09-05'),(115,'AGIP','jl1234le0',NULL,2,40798,'2023-09-05'),(116,'AFIP','Valentina09*',NULL,1,40797,'2023-09-07'),(117,'ARBA','Valentina070',NULL,3,40797,'2023-09-07'),(118,'AGIP','Valentina070',NULL,2,40797,'2023-09-07'),(119,NULL,'Pauleanbarzana1927',NULL,1,40855,'2024-05-27'),(120,NULL,'Paulean20210',NULL,2,40855,'2024-05-27'),(121,NULL,'Paulean20210',NULL,3,40855,'2024-05-27'),(122,'AFIP','Sanblas3066',NULL,1,40841,'2024-05-27'),(123,'ARBA','Kousagi8977,,',NULL,3,40841,'2024-05-27'),(124,'AGIP','Kousagi8977,,',NULL,2,40841,'2024-05-27'),(125,'AFIP','Macarena0004',NULL,1,40799,'2024-05-27'),(126,'AGIP','Macarena0002',NULL,2,40799,'2024-05-27'),(127,'23332031929','Martin00002','Socia',1,40725,'2024-05-27'),(128,'23332031929','1b1e0c1e','Socio Gerente',2,40725,'2024-05-27'),(129,'23332031929','1b1e0c1e','Clave Socio Gerente',3,40725,'2024-05-27'),(130,'AFIP','200215Luis',NULL,1,40721,'2024-05-27'),(131,'AGIP','200215Luis',NULL,2,40721,'2024-05-27'),(132,NULL,'2507Marina',NULL,1,40724,'2024-05-27'),(133,'Rentas Entre Rios','2506Marina',NULL,41,40724,'2024-05-27'),(134,'AFIP','Macarena0004',NULL,1,40799,'2025-05-27'),(135,'AGIP','Macarena0002',NULL,2,40799,'2025-05-27'),(136,NULL,'Ferreteriadecarrera95',NULL,1,40842,'2025-05-27'),(137,NULL,'Wolter2020',NULL,3,40842,'2025-05-27'),(138,'AFIP','Sanblas3066',NULL,1,40841,'2025-05-27'),(139,'ARBA','Kousagi8977,,',NULL,3,40841,'2025-05-27'),(140,'AGIP','Kousagi8977,,',NULL,2,40841,'2025-05-27'),(141,'23332031929','Martin00002','Socia',1,40725,'2025-05-27'),(142,'23332031929','1b1e0c1e','Socio Gerente',2,40725,'2025-05-27');
INSERT INTO `back_up_claves_details` VALUES (143,'23332031929','1b1e0c1e','Clave Socio Gerente',3,40725,'2025-05-27'),(144,'AFIP','200215Luis',NULL,1,40721,'2025-05-27'),(145,'AGIP','200215Luis',NULL,2,40721,'2025-05-27'),(146,NULL,'rosa29265L',NULL,1,40722,'2025-05-27'),(147,NULL,'Bernardo2690',NULL,2,40722,'2025-05-27'),(148,NULL,'1343889057',NULL,32,40722,'2025-05-27'),(149,NULL,'estudio1',NULL,44,40722,'2025-05-27'),(150,NULL,'2507Marina',NULL,1,40724,'2025-05-27'),(151,'Rentas Entre Rios','2506Marina',NULL,41,40724,'2025-05-27'),(152,'AFIP','Alejandro2022',NULL,1,40798,'2025-05-27'),(153,'ARBA','jl1234le0',NULL,3,40798,'2025-05-27'),(154,'AGIP','jl1234le0',NULL,2,40798,'2025-05-27'),(155,'AFIP','Matute2609',NULL,1,40801,'2025-05-27'),(156,'AGIP','Matute2609',NULL,2,40801,'2025-05-27'),(157,'AGIP','Matute2609',NULL,3,40801,'2025-05-27'),(158,'AFIP','Sanblas3066',NULL,1,40841,'2025-05-27'),(159,'ARBA','Kousagi8977,,',NULL,3,40841,'2025-05-27'),(160,'AGIP','Kousagi8977,,',NULL,2,40841,'2025-05-27'),(161,'AFIP','Rustik2023',NULL,1,40802,'2025-05-27'),(162,'AGIP','Harol37377',NULL,2,40802,'2025-05-27'),(163,NULL,'Pauleanbarzana1927',NULL,1,40855,'2025-05-27'),(164,NULL,'Paulean20210',NULL,2,40855,'2025-05-27'),(165,NULL,'Paulean20210',NULL,3,40855,'2025-05-27');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'info@mycontador.com.ar','1164275247',NULL,1,40719,'2022-10-27'),(2,'info@mycontador.com.ar','1164275247','',1,40719,'2022-10-27'),(3,'info@mycontador.com.ar','1164275247','',1,40719,'2022-10-27'),(4,'info@mycontador.com.ar','1164275247','',1,40719,'2022-10-27'),(5,'Josvytex10@gmail.com','1131185755','',1,40721,'2022-10-27'),(6,'luisangel.la412@gmail.com',NULL,'',2,40721,'2022-10-27'),(7,'pattylimachi9@gmail.com',NULL,'',2,40721,'2022-10-27'),(8,'fannyquillahuaman@gmail.com','1128245873','',1,40722,'2022-10-27'),(9,'espindolajuanalberto45@gmail.com','3435343249','',1,40724,'2022-10-28'),(10,'rustikhomes0@gmail.com','1161852082','',1,40723,'2022-10-28'),(11,'rustikhomesfurniture@gmail.com',NULL,'',2,40723,'2022-10-28'),(12,'fannyquillahuaman@gmail.com','1128245873','',1,40722,'2022-10-28'),(13,'Josvytex10@gmail.com','1131185755','',1,40721,'2022-10-28'),(14,'pattylimachi9@gmail.com',NULL,'',2,40721,'2022-10-28'),(15,'luisangel.la412@gmail.com',NULL,'',2,40721,'2022-10-28'),(16,'info@mycontador.com.ar','1164275247','',1,40719,'2023-03-07'),(17,'carlosreceloglu@gmail.com','1132669293','',2,40719,'2023-03-07'),(18,'macarenacaballeroderosa@gmail.com','+5491170366171','Socia',1,40725,'2023-03-22'),(19,'martinleonelvalletta@gmail.com','+5491140945755','Socio Gerente',2,40725,'2023-03-22'),(20,'macarenacaballeroderosa@gmail.com','+5491170366171','Socia',1,40725,'2023-03-22'),(21,'martinleonelvalletta@gmail.com','+5491140945755','Socio Gerente',2,40725,'2023-03-22'),(22,'espindolajuanalberto45@gmail.com','3435343249','',1,40724,'2023-04-23'),(23,'Josvytex10@gmail.com','1131185755','',1,40721,'2023-04-23'),(24,'pattylimachi9@gmail.com',NULL,'',2,40721,'2023-04-23'),(25,'luisangel.la412@gmail.com',NULL,'',2,40721,'2023-04-23'),(26,'espindolajuanalberto45@gmail.com','3435343249','',1,40724,'2023-04-23'),(27,'Josvytex10@gmail.com','1131185755','',1,40721,'2023-04-23'),(28,'pattylimachi9@gmail.com',NULL,'',2,40721,'2023-04-23'),(29,'luisangel.la412@gmail.com',NULL,'',2,40721,'2023-04-23'),(30,'info@mycontador.com.ar','1164275247','',1,40719,'2023-04-23'),(31,'carlosreceloglu@gmail.com','1132669293','',2,40719,'2023-04-23'),(32,'info@mycontador.com.ar','1164275247','',1,40719,'2023-04-23'),(33,'carlosreceloglu@gmail.com','1132669293','',2,40719,'2023-04-23'),(34,'info@mycontador.com.ar','1164275247','',1,40719,'2023-04-23'),(35,'carlosreceloglu@gmail.com','1132669293','',2,40719,'2023-04-23'),(36,'Josvytex10@gmail.com','1131185755','',1,40721,'2023-04-23'),(37,'pattylimachi9@gmail.com',NULL,'',2,40721,'2023-04-23'),(38,'luisangel.la412@gmail.com',NULL,'',2,40721,'2023-04-23'),(39,'Josvytex10@gmail.com','1131185755','',1,40721,'2023-04-23'),(40,'pattylimachi9@gmail.com',NULL,'',2,40721,'2023-04-23'),(41,'luisangel.la412@gmail.com',NULL,'',2,40721,'2023-04-23'),(42,'Josvytex10@gmail.com','1131185755','',1,40721,'2023-04-23'),(43,'pattylimachi9@gmail.com',NULL,'',2,40721,'2023-04-23'),(44,'luisangel.la412@gmail.com',NULL,'',2,40721,'2023-04-23'),(45,'espindolajuanalberto45@gmail.com','3435343249','',1,40724,'2023-04-23'),(46,'macarenacaballeroderosa@gmail.com','+5491170366171','Socia',1,40725,'2023-04-23'),(47,'martinleonelvalletta@gmail.com','+5491140945755','Socio Gerente',2,40725,'2023-04-23'),(48,'rustikhomes0@gmail.com','1161852082','',1,40723,'2023-04-23'),(49,'rustikhomesfurniture@gmail.com',NULL,'',2,40723,'2023-04-23'),(50,'fannyquillahuaman@gmail.com','1128245873','',1,40722,'2023-04-23'),(51,'ignacio@icreate.cl','54944039025','Ignacio (Socio Gerente)',1,40843,'2023-04-23'),(52,'mayra_dicaluva@hotmail.com','1133360197','',1,40727,'2023-04-23'),(53,'fannyquillahuaman@gmail.com','1128245873','',1,40722,'2023-04-23'),(54,'ferreteriaelectro95@gmail.com','1151616204','',1,40842,'2023-04-23'),(55,'carreradenise8@gmail.com',NULL,'',2,40842,'2023-04-23'),(56,'fannyquillahuaman@gmail.com','1128245873','',1,40722,'2023-04-23'),(57,'info@mycontador.com.ar','1164275247','',1,40719,'2023-04-23');
INSERT INTO `back_up_mails_details` VALUES (58,'carlosreceloglu@gmail.com','1132669293','',2,40719,'2023-04-23'),(59,'info@mycontador.com.ar','1164275247','',1,40719,'2023-04-23'),(60,'carlosreceloglu@gmail.com','1132669293','',2,40719,'2023-04-23'),(61,'info@mycontador.com.ar','1164275247','',1,40719,'2023-04-23'),(62,'carlosreceloglu@gmail.com','1132669293','',2,40719,'2023-04-23'),(63,'julianacalvo_89@hotmail.com','1162820233','',1,40841,'2023-04-28'),(64,'lashijasdeeva1@gmail.com',NULL,'',2,40841,'2023-04-28'),(65,'paulalema50@gmail.com','1151116420','',1,40855,'2023-04-29'),(66,'kimay.sushi.1@gmail.com',NULL,'',2,40855,'2023-04-29'),(67,'Nanolea26@gmail.com',NULL,'',3,40855,'2023-04-29'),(68,'macarenacaballeroderosa@gmail.com','1170366171','',1,40799,'2023-05-29'),(69,'caballeroderosa.m@gmail.com',NULL,'',2,40799,'2023-05-29'),(70,'rustikhomes0@gmail.com','1161852082','',1,40723,'2023-05-30'),(71,'rustikhomesfurniture@gmail.com',NULL,'',2,40723,'2023-05-30'),(72,'ferreteriaelectro95@gmail.com','1151616204','',1,40842,'2023-05-31'),(73,'carreradenise8@gmail.com',NULL,'',2,40842,'2023-05-31'),(74,'julianacalvo_89@hotmail.com','1162820233','',1,40841,'2023-06-01'),(75,'lashijasdeeva1@gmail.com',NULL,'',2,40841,'2023-06-01'),(76,'agustinaortiz8@gmail.com','1123950852','',1,40852,'2023-06-01'),(77,'zagala.joyas1@gmail.com','1131878419','',1,40800,'2023-06-01'),(78,'elba_aranaga@hotmail.com',NULL,'',2,40800,'2023-06-01'),(79,'mayra_dicaluva@hotmail.com','1133360197','',1,40727,'2023-06-20'),(80,'fannyquillahuaman@gmail.com','1128245873','',1,40722,'2023-07-05'),(81,'bongiornoesteban@gmail.com','1152628510','Bongiorno Esteban Daniel (Socio Gerente)',1,40851,'2023-08-25'),(82,'rey.f87@gmail.com','1130338333','Facundo Rey (Socio)',2,40851,'2023-08-25'),(83,'javierleano.25@gmail.com','1123915596','',1,40798,'2023-09-05'),(84,'juniorleano@gmail.com','1123915596','',1,40797,'2023-09-07'),(85,'javierleano.25@gmail.com',NULL,'',2,40797,'2023-09-07'),(86,'paulalema50@gmail.com','1151116420','',1,40855,'2024-05-27'),(87,'kimay.sushi.1@gmail.com',NULL,'',2,40855,'2024-05-27'),(88,'Nanolea26@gmail.com',NULL,'',3,40855,'2024-05-27'),(89,'julianacalvo_89@hotmail.com','1162820233','',1,40841,'2024-05-27'),(90,'lashijasdeeva1@gmail.com',NULL,'',2,40841,'2024-05-27'),(91,'macarenacaballeroderosa@gmail.com','1170366171','',1,40799,'2024-05-27'),(92,'caballeroderosa.m@gmail.com',NULL,'',2,40799,'2024-05-27'),(93,'macarenacaballeroderosa@gmail.com','+5491170366171','Socia',1,40725,'2024-05-27'),(94,'martinleonelvalletta@gmail.com','+5491140945755','Socio Gerente',2,40725,'2024-05-27'),(95,'Josvytex10@gmail.com','1131185755','',1,40721,'2024-05-27'),(96,'pattylimachi9@gmail.com',NULL,'',2,40721,'2024-05-27'),(97,'luisangel.la412@gmail.com',NULL,'',2,40721,'2024-05-27'),(98,'espindolajuanalberto45@gmail.com','3435343249','',1,40724,'2024-05-27'),(99,'macarenacaballeroderosa@gmail.com','1170366171','',1,40799,'2025-05-27'),(100,'caballeroderosa.m@gmail.com',NULL,'',2,40799,'2025-05-27'),(101,'ferreteriaelectro95@gmail.com','1151616204','',1,40842,'2025-05-27'),(102,'carreradenise8@gmail.com',NULL,'',2,40842,'2025-05-27'),(103,'julianacalvo_89@hotmail.com','1162820233','',1,40841,'2025-05-27'),(104,'lashijasdeeva1@gmail.com',NULL,'',2,40841,'2025-05-27'),(105,'macarenacaballeroderosa@gmail.com','+5491170366171','Socia',1,40725,'2025-05-27'),(106,'martinleonelvalletta@gmail.com','+5491140945755','Socio Gerente',2,40725,'2025-05-27'),(107,'Josvytex10@gmail.com','1131185755','',1,40721,'2025-05-27'),(108,'luisangel.la412@gmail.com',NULL,'',2,40721,'2025-05-27'),(109,'pattylimachi9@gmail.com',NULL,'',2,40721,'2025-05-27'),(110,'fannyquillahuaman@gmail.com','1128245873','',1,40722,'2025-05-27'),(111,'espindolajuanalberto45@gmail.com','3435343249','',1,40724,'2025-05-27'),(112,'javierleano.25@gmail.com','1123915596','',1,40798,'2025-05-27'),(113,'hjrr55@hotmail.com','1124634207','',1,40801,'2025-05-27'),(114,'julianacalvo_89@hotmail.com','1162820233','',1,40841,'2025-05-27');
INSERT INTO `back_up_mails_details` VALUES (115,'lashijasdeeva1@gmail.com',NULL,'',2,40841,'2025-05-27'),(116,'rustikhomesfurniture@gmail.com','1161852082','',1,40802,'2025-05-27'),(117,'paulalema50@gmail.com','1151116420','',1,40855,'2025-05-27'),(118,'kimay.sushi.1@gmail.com',NULL,'',2,40855,'2025-05-27'),(119,'Nanolea26@gmail.com',NULL,'',3,40855,'2025-05-27');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (5,3,20,67,NULL,0.00,'2024-05-27 18:21:22','2024-05-27 18:21:22',NULL),(6,3,20,96,NULL,0.00,'2024-05-27 18:21:22','2024-05-27 18:21:22',NULL),(7,3,20,13,NULL,0.00,'2024-05-27 18:21:22','2024-05-27 18:21:22',NULL),(8,4,1,191,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(9,4,1,62,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(10,4,1,494,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(11,4,1,495,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(12,4,1,497,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(13,4,1,496,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(14,4,1,498,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(15,4,1,498,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(16,4,1,110,NULL,0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(26,6,16,491,NULL,0.00,'2024-05-27 18:43:47','2024-05-27 18:43:47',NULL),(27,6,16,302,NULL,0.00,'2024-05-27 18:43:47','2024-05-27 18:43:47',NULL),(28,6,16,252,NULL,0.00,'2024-05-27 18:43:47','2024-05-27 18:43:47',NULL),(29,6,16,226,NULL,0.00,'2024-05-27 18:43:47','2024-05-27 18:43:47',NULL),(30,6,16,209,NULL,0.00,'2024-05-27 18:43:47','2024-05-27 18:43:47',NULL),(31,6,16,78,NULL,0.00,'2024-05-27 18:43:47','2024-05-27 18:43:47',NULL),(32,6,16,302,NULL,0.00,'2024-05-27 18:43:47','2024-05-27 18:43:47',NULL),(40,8,15,67,NULL,0.00,'2024-05-27 18:47:53','2024-05-27 18:47:53',NULL),(41,8,15,68,NULL,0.00,'2024-05-27 18:47:53','2024-05-27 18:47:53',NULL),(42,8,15,354,NULL,0.00,'2024-05-27 18:47:53','2024-05-27 18:47:53',NULL),(43,8,15,25,NULL,0.00,'2024-05-27 18:47:53','2024-05-27 18:47:53',NULL),(44,8,15,72,NULL,0.00,'2024-05-27 18:47:53','2024-05-27 18:47:53',NULL),(45,8,15,74,NULL,0.00,'2024-05-27 18:47:53','2024-05-27 18:47:53',NULL),(46,8,15,73,NULL,0.00,'2024-05-27 18:47:53','2024-05-27 18:47:53',NULL),(54,10,5,57,NULL,0.00,'2024-05-27 18:53:49','2024-05-27 18:53:49',NULL),(55,10,5,13,NULL,0.00,'2024-05-27 18:53:49','2024-05-27 18:53:49',NULL),(56,10,5,504,NULL,0.00,'2024-05-27 18:53:49','2024-05-27 18:53:49',NULL),(57,10,5,68,NULL,0.00,'2024-05-27 18:53:49','2024-05-27 18:53:49',NULL),(58,10,5,492,NULL,0.00,'2024-05-27 18:53:49','2024-05-27 18:53:49',NULL),(59,10,5,140,NULL,0.00,'2024-05-27 18:53:49','2024-05-27 18:53:49',NULL),(60,10,5,493,NULL,0.00,'2024-05-27 18:53:49','2024-05-27 18:53:49',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,7975,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2024-05-27 18:54:19','2024-05-27 18:54:19'),(2,7975,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2024-05-27 18:54:22','2024-05-27 18:54:22'),(3,7975,20,2,'VENTAS',0.00,'2024-05-27 18:21:22','2024-05-27 18:21:22',NULL),(4,7975,1,2,'SUELDOS Y CCSS',0.00,'2024-05-27 18:36:42','2024-05-27 18:36:42',NULL),(5,7975,1,2,'SUELDOS Y CCSS',0.00,'2024-05-27 18:37:26','2024-05-27 18:54:12','2024-05-27 18:54:12'),(6,7975,16,2,'DEVENGAMIENTO IIBB',0.00,'2024-05-27 18:43:47','2024-05-27 18:43:47',NULL),(7,7975,16,2,'DEVENGAMIENTO IIBB',0.00,'2024-05-27 18:44:04','2024-05-27 18:54:08','2024-05-27 18:54:08'),(8,7975,15,2,'DEVENGAMIENTO IVA',0.00,'2024-05-27 18:47:53','2024-05-27 18:47:53',NULL),(9,7975,15,2,'DEVENGAMIENTO IVA',0.00,'2024-05-27 18:48:11','2024-05-27 18:48:19','2024-05-27 18:48:19'),(10,7975,5,2,'BANCO SANTANDER',0.00,'2024-05-27 18:53:49','2024-05-27 18:53:49',NULL),(11,7975,5,2,'BANCO SANTANDER',0.00,'2024-05-27 18:53:58','2024-05-27 18:54:36','2024-05-27 18:54:36');
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=53777 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7994,40725,7524,12,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',500000.00,'ASIENTO DE INICIO',NULL,1,'2023-03-21 17:56:53','2023-03-22 10:11:06','2023-03-22 10:11:06'),(2,7994,40725,9067,12,2,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',500000.00,'ASIENTO DE INICIO',NULL,1,'2023-03-22 19:10:51','2023-03-22 19:10:51',NULL),(3,7994,40725,9067,19,3,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',125000.00,'INTEGRACION CUOTAS PARTES',NULL,1,'2023-03-22 19:13:08','2023-03-22 19:13:08',NULL),(4,7994,40725,9075,23,4,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-03-22 19:17:31','2023-03-22 19:18:58','2023-03-22 19:18:58'),(5,7994,40725,9075,23,5,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',312007.12,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-03-22 19:17:41','2023-03-22 19:19:03','2023-03-22 19:19:03'),(6,7994,40725,9075,23,6,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',312007.12,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-03-30 17:34:18','2023-03-30 17:34:18',NULL),(7,7975,40719,20,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',498.90,NULL,NULL,1,'2023-04-23 20:19:42','2023-04-23 20:19:42',NULL),(8,7975,40719,20,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',136.00,NULL,NULL,1,'2023-04-23 20:19:42','2023-04-23 20:19:42',NULL),(9,7975,40719,20,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',212.39,NULL,NULL,1,'2023-04-23 20:19:42','2023-04-23 20:19:42',NULL),(10,7975,40719,20,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',30280.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(11,7975,40719,20,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',10232.07,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(12,7975,40719,20,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',855.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(13,7975,40719,20,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',855.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(14,7975,40719,20,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8555.13,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(15,7975,40719,20,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4000.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(16,7975,40719,20,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',70000.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(17,7975,40719,20,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4416.50,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(18,7975,40719,20,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',12080.80,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(19,7975,40719,20,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',242000.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(20,7975,40719,20,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',34920.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL);
INSERT INTO `balance_libro` VALUES (21,7975,40719,20,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',18016.26,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(22,7975,40719,20,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5279.96,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(23,7975,40719,20,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',17415.70,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(24,7975,40719,20,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',31876.84,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(25,7975,40719,20,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',140265.92,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(26,7975,40719,20,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',159570.65,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(27,7975,40719,20,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',70000.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(28,7975,40719,20,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',498.90,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(29,7975,40719,20,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10249.99,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(30,7975,40719,20,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',119473.33,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(31,7975,40719,20,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',155000.00,NULL,NULL,1,'2023-04-23 20:19:43','2023-04-23 20:19:43',NULL),(797,7975,40719,20,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5000.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(798,7975,40719,20,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3000.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(799,7975,40719,20,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5000.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(800,7975,40719,20,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',10000.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(801,7975,40719,20,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',10000.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(802,7975,40719,20,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5000.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(803,7975,40719,20,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',10000.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(804,7975,40719,20,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6500.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(805,7975,40719,20,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2500.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL),(806,7975,40719,20,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4500.00,NULL,NULL,1,'2023-04-23 20:40:01','2023-04-23 20:40:01',NULL);
INSERT INTO `balance_libro` VALUES (807,7975,40719,20,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(808,7975,40719,20,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',7500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(809,7975,40719,20,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(810,7975,40719,20,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',7500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(811,7975,40719,20,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',16000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(812,7975,40719,20,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',5000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(813,7975,40719,20,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(814,7975,40719,20,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',10000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(815,7975,40719,20,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',5500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(816,7975,40719,20,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(817,7975,40719,20,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',6500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(818,7975,40719,20,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',12100.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(819,7975,40719,20,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(820,7975,40719,20,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',6000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(821,7975,40719,20,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(822,7975,40719,20,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(823,7975,40719,20,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(824,7975,40719,20,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(825,7975,40719,20,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',10000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(826,7975,40719,20,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(827,7975,40719,20,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',4500.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL);
INSERT INTO `balance_libro` VALUES (828,7975,40719,20,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5000.00,NULL,NULL,1,'2023-04-23 20:40:02','2023-04-23 20:40:02',NULL),(829,7975,40719,20,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',12100.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(830,7975,40719,20,2,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',8500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(831,7975,40719,20,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(832,7975,40719,20,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',12100.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(833,7975,40719,20,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(834,7975,40719,20,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(835,7975,40719,20,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(836,7975,40719,20,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(837,7975,40719,20,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(838,7975,40719,20,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',11000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(839,7975,40719,20,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(840,7975,40719,20,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(841,7975,40719,20,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(842,7975,40719,20,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(843,7975,40719,20,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(844,7975,40719,20,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(845,7975,40719,20,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(846,7975,40719,20,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',7500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(847,7975,40719,20,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',7500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(848,7975,40719,20,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL);
INSERT INTO `balance_libro` VALUES (849,7975,40719,20,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(850,7975,40719,20,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(851,7975,40719,20,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(852,7975,40719,20,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4500.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(853,7975,40719,20,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(854,7975,40719,20,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',12100.00,NULL,NULL,1,'2023-04-23 20:40:03','2023-04-23 20:40:03',NULL),(855,7975,40719,20,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(856,7975,40719,20,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(857,7975,40719,20,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(858,7975,40719,20,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(859,7975,40719,20,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(860,7975,40719,20,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4500.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(861,7975,40719,20,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(862,7975,40719,20,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(863,7975,40719,20,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',20000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(864,7975,40719,20,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3500.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(865,7975,40719,20,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4500.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(866,7975,40719,20,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(867,7975,40719,20,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',12100.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(868,7975,40719,20,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',11000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(869,7975,40719,20,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL);
INSERT INTO `balance_libro` VALUES (870,7975,40719,20,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(871,7975,40719,20,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(872,7975,40719,20,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',12100.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(873,7975,40719,20,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',17100.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(874,7975,40719,20,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(875,7975,40719,20,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(876,7975,40719,20,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(877,7975,40719,20,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(878,7975,40719,20,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(879,7975,40719,20,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4500.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(880,7975,40719,20,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(881,7975,40719,20,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8500.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(882,7975,40719,20,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4500.00,NULL,NULL,1,'2023-04-23 20:40:04','2023-04-23 20:40:04',NULL),(883,7975,40719,20,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4500.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(884,7975,40719,20,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(885,7975,40719,20,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',20000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(886,7975,40719,20,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(887,7975,40719,20,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(888,7975,40719,20,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(889,7975,40719,20,2,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(890,7975,40719,20,2,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL);
INSERT INTO `balance_libro` VALUES (891,7975,40719,20,2,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(892,7975,40719,20,2,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(893,7975,40719,20,2,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(894,7975,40719,20,2,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(895,7975,40719,20,2,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',35000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(896,7975,40719,20,2,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(897,7975,40719,20,2,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',2500.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(898,7975,40719,20,2,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(899,7975,40719,20,2,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5500.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(900,7975,40719,20,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8500.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(901,7975,40719,20,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5500.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(902,7975,40719,20,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4500.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(903,7975,40719,20,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4500.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(904,7975,40719,20,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(905,7975,40719,20,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',6000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(906,7975,40719,20,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(907,7975,40719,20,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(908,7975,40719,20,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',6000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(909,7975,40719,20,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(910,7975,40719,20,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',12000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(911,7975,40719,20,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',15000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL);
INSERT INTO `balance_libro` VALUES (912,7975,40719,20,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',35000.00,NULL,NULL,1,'2023-04-23 20:40:05','2023-04-23 20:40:05',NULL),(913,7975,40719,20,2,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',15000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(914,7975,40719,20,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',5000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(915,7975,40719,20,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',20000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(916,7975,40719,20,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',2500.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(917,7975,40719,20,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(918,7975,40719,20,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',5000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(919,7975,40719,20,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',5000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(920,7975,40719,20,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',10000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(921,7975,40719,20,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',5500.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(922,7975,40719,20,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',15000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(923,7975,40719,20,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4500.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(924,7975,40719,20,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4500.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(925,7975,40719,20,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(926,7975,40719,20,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4500.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(927,7975,40719,20,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4500.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(928,7975,40719,20,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',10000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(929,7975,40719,20,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',10000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(930,7975,40719,20,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',35000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(931,7975,40719,20,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',5000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(932,7975,40719,20,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL);
INSERT INTO `balance_libro` VALUES (933,7975,40719,20,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3500.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(934,7975,40719,20,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',35000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(935,7975,40719,20,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',12000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(936,7975,40719,20,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',15000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(937,7975,40719,20,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',15000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(938,7975,40719,20,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',10000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(939,7975,40719,20,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',6500.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(940,7975,40719,20,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5000.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(941,7975,40719,20,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',9075.00,NULL,NULL,1,'2023-04-23 20:40:06','2023-04-23 20:40:06',NULL),(942,7975,40719,20,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(943,7975,40719,20,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',4500.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(944,7975,40719,20,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5500.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(945,7975,40719,20,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',4500.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(946,7975,40719,20,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',8000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(947,7975,40719,20,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(948,7975,40719,20,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',6000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(949,7975,40719,20,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',15000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(950,7975,40719,20,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',5000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(951,7975,40719,20,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4500.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(952,7975,40719,20,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4500.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(953,7975,40719,20,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',6000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL);
INSERT INTO `balance_libro` VALUES (954,7975,40719,20,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4500.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(955,7975,40719,20,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',20000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(956,7975,40719,20,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',6000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(957,7975,40719,20,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(958,7975,40719,20,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',7500.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(959,7975,40719,20,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',16000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(960,7975,40719,20,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5000.00,NULL,NULL,1,'2023-04-23 20:40:07','2023-04-23 20:40:07',NULL),(961,7975,40719,21,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',5000.00,NULL,NULL,1,'2023-04-30 15:01:13','2023-04-30 15:01:13',NULL),(962,7975,40719,21,2,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1.21,NULL,NULL,1,'2023-04-30 15:06:47','2023-04-30 15:06:47',NULL),(983,7994,40728,10601,2,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',48000.02,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(984,7994,40728,10601,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',6445.00,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(985,7994,40728,10601,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',50000.03,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(986,7994,40728,10601,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',25000.00,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(987,7994,40728,10601,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',50000.00,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(988,7994,40728,10601,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',30000.00,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(989,7994,40728,10601,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',30000.00,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(990,7994,40728,10601,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',45000.04,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(991,7994,40728,10601,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',15000.02,NULL,NULL,1,'2023-05-24 10:06:50','2023-05-24 10:06:50',NULL),(992,7994,40728,10601,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3918.75,NULL,NULL,1,'2023-05-24 10:12:34','2023-05-24 10:12:34',NULL),(993,7994,40728,10601,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',2764.50,NULL,NULL,1,'2023-05-24 10:12:34','2023-05-24 10:12:34',NULL),(994,7994,40728,10601,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',612.05,NULL,NULL,1,'2023-05-24 10:12:34','2023-05-24 10:12:34',NULL);
INSERT INTO `balance_libro` VALUES (995,7994,40728,10601,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',4759.78,NULL,NULL,1,'2023-05-24 10:12:34','2023-05-24 10:12:34',NULL),(996,7994,40728,10601,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',2079.94,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(997,7994,40728,10601,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',561.88,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(998,7994,40728,10601,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',1043.33,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(999,7994,40728,10601,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',4232.25,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1000,7994,40728,10601,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',18400.00,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1001,7994,40728,10601,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',4900.00,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1002,7994,40728,10601,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',73469.40,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1003,7994,40728,10601,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-10','2022-04-10',1695.00,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1004,7994,40728,10601,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',8550.00,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1005,7994,40728,10601,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',959.45,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1006,7994,40728,10601,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',9453.45,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1007,7994,40728,10601,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',1036.78,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1008,7994,40728,10601,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',881.40,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1009,7994,40728,10601,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',76096.26,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1010,7994,40728,10601,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',8003.64,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1011,7994,40728,10601,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',1695.01,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1012,7994,40728,10601,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',60500.00,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1013,7994,40728,10601,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',800.00,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1014,7994,40728,10601,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',724.76,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1015,7994,40728,10601,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',4900.00,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL);
INSERT INTO `balance_libro` VALUES (1016,7994,40728,10601,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',1915.00,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1017,7994,40728,10601,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',907.38,NULL,NULL,1,'2023-05-24 10:12:35','2023-05-24 10:12:35',NULL),(1018,7994,40728,10601,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',5000.02,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1019,7994,40728,10601,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',612.05,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1020,7994,40728,10601,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',404.53,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1021,7994,40728,10601,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',7267.50,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1022,7994,40728,10601,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',88878.51,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1023,7994,40728,10601,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1043.33,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1024,7994,40728,10601,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',7267.50,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1025,7994,40728,10601,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',7267.50,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1026,7994,40728,10601,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4232.25,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1027,7994,40728,10601,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',404.53,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1028,7994,40728,10601,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',76096.26,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1029,7994,40728,10601,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',8550.00,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1030,7994,40728,10601,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',50820.00,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1031,7994,40728,10601,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2559.76,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1032,7994,40728,10601,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',3750.00,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1033,7994,40728,10601,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',13252.69,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1034,7994,40728,10601,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',23597.05,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1035,7994,40728,10601,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',70000.00,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1036,7994,40728,10601,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',42000.00,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL);
INSERT INTO `balance_libro` VALUES (1037,7994,40728,10601,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',6397.73,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1038,7994,40728,10601,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',8550.00,NULL,NULL,1,'2023-05-24 10:12:36','2023-05-24 10:12:36',NULL),(1039,7994,40851,189813,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',120000.00,NULL,NULL,1,'2023-05-24 10:26:51','2024-05-29 17:41:48','2024-05-29 17:41:48'),(1040,7994,40851,189813,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',9000.46,NULL,NULL,1,'2023-05-24 10:26:51','2024-05-29 17:41:48','2024-05-29 17:41:48'),(1041,7994,40851,189813,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',0.03,NULL,NULL,1,'2023-05-24 10:26:51','2024-05-29 17:41:48','2024-05-29 17:41:48'),(1042,7994,40851,189813,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',28136.00,NULL,NULL,1,'2023-05-24 10:26:51','2024-05-29 17:41:48','2024-05-29 17:41:48'),(1043,7994,40851,189813,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',14999.99,NULL,NULL,1,'2023-05-24 10:26:51','2024-05-29 17:41:48','2024-05-29 17:41:48'),(1044,7994,40851,189813,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',3395.00,NULL,NULL,1,'2023-05-24 10:26:51','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1045,7994,40851,189813,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',950.00,NULL,NULL,1,'2023-05-24 10:26:51','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1047,7994,40728,10602,2,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',150000.02,NULL,NULL,1,'2023-05-27 11:53:46','2023-05-27 11:53:46',NULL),(1048,7994,40728,10602,2,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',10800.00,NULL,NULL,1,'2023-05-27 11:53:46','2023-05-27 11:53:46',NULL),(1049,7994,40728,10602,2,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',5400.00,NULL,NULL,1,'2023-05-27 11:53:46','2023-05-27 11:53:46',NULL),(1050,7994,40728,10602,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',4800.00,NULL,NULL,1,'2023-05-27 11:53:46','2023-05-27 11:53:46',NULL),(1051,7994,40728,10602,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',150000.02,NULL,NULL,1,'2023-05-27 11:53:46','2023-05-27 11:53:46',NULL),(1052,7994,40728,10602,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',45000.00,NULL,NULL,1,'2023-05-27 11:53:46','2023-05-27 11:53:46',NULL),(1053,7994,40728,10602,2,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',52000.00,NULL,NULL,1,'2023-05-27 11:53:46','2023-05-27 11:53:46',NULL),(1054,7994,40728,10602,2,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',54000.00,NULL,NULL,1,'2023-05-27 11:53:46','2023-05-27 11:53:46',NULL),(1055,7994,40728,10602,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',952.73,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1056,7994,40728,10602,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',612.05,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1057,7994,40728,10602,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',8550.01,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL);
INSERT INTO `balance_libro` VALUES (1058,7994,40728,10602,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1043.33,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1059,7994,40728,10602,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',8550.00,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1060,7994,40728,10602,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',2851.86,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1061,7994,40728,10602,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3814.25,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1062,7994,40728,10602,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',3814.25,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1063,7994,40728,10602,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',3814.25,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1064,7994,40728,10602,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1451.60,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1065,7994,40728,10602,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',123134.12,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1066,7994,40728,10602,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',8550.01,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1067,7994,40728,10602,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',4576.16,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1068,7994,40728,10602,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',8550.00,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1069,7994,40728,10602,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',18190.00,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1070,7994,40728,10602,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',8550.00,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1071,7994,40728,10602,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',612.05,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1072,7994,40728,10602,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1480.52,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1073,7994,40728,10602,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',11986.98,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1074,7994,40728,10602,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',2368.13,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1075,7994,40728,10602,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',721.22,NULL,NULL,1,'2023-05-27 11:56:26','2023-05-27 11:56:26',NULL),(1076,7994,40728,10602,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',2949.75,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1077,7994,40728,10602,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',561.88,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1078,7994,40728,10602,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',2949.75,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL);
INSERT INTO `balance_libro` VALUES (1079,7994,40728,10602,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1968.03,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1080,7994,40728,10602,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',2949.75,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1081,7994,40728,10602,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',612.05,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1082,7994,40728,10602,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',19391.90,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1083,7994,40728,10602,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',481.46,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1084,7994,40728,10602,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',19391.90,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1085,7994,40728,10602,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',19391.90,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1086,7994,40728,10602,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',6990.00,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1087,7994,40728,10602,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',4926.65,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1088,7994,40728,10602,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',2488.24,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1089,7994,40728,10602,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1123.75,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1090,7994,40728,10602,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',730.96,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1091,7994,40728,10602,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',2580.00,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1092,7994,40728,10602,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',990.00,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1093,7994,40728,10602,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1378.15,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1094,7994,40728,10602,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',27104.00,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1095,7994,40728,10602,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',40837.50,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1096,7994,40728,10602,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',27104.00,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1097,7994,40728,10602,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',561.88,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1098,7994,40728,10602,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1685.63,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1099,7994,40728,10602,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',15030.00,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL);
INSERT INTO `balance_libro` VALUES (1100,7994,40728,10602,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',4142.25,NULL,NULL,1,'2023-05-27 11:56:27','2023-05-27 11:56:27',NULL),(1101,7994,40728,10602,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',561.88,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1102,7994,40728,10602,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',15030.00,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1103,7994,40728,10602,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',561.88,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1104,7994,40728,10602,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',15030.00,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1105,7994,40728,10602,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',3587.27,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1106,7994,40728,10602,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',49408.26,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1107,7994,40728,10602,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',45088.43,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1108,7994,40728,10602,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700.00,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1109,7994,40728,10602,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5000.01,NULL,NULL,1,'2023-05-27 11:56:28','2023-05-27 11:56:28',NULL),(1119,7994,40728,10603,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',10000.04,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1120,7994,40728,10603,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1899.76,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1121,7994,40728,10603,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',3653.49,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1122,7994,40728,10603,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',4725.00,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1123,7994,40728,10603,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',21760.00,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1124,7994,40728,10603,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',4725.00,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1125,7994,40728,10603,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',4725.00,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1126,7994,40728,10603,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',13141.06,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1127,7994,40728,10603,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',64626.48,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1128,7994,40728,10603,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',632.10,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1129,7994,40728,10603,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',12033.00,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL);
INSERT INTO `balance_libro` VALUES (1130,7994,40728,10603,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2291.62,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1131,7994,40728,10603,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2998.77,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1132,7994,40728,10603,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2498.99,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1133,7994,40728,10603,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2291.62,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1134,7994,40728,10603,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',12033.00,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1135,7994,40728,10603,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2499.00,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1136,7994,40728,10603,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',12033.00,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1137,7994,40728,10603,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2291.62,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1138,7994,40728,10603,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',721.22,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1139,7994,40728,10603,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',5800.01,NULL,NULL,1,'2023-05-27 11:59:57','2023-05-27 11:59:57',NULL),(1140,7994,40728,10603,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',30383.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1141,7994,40728,10603,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',632.10,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1142,7994,40728,10603,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',13133.26,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1143,7994,40728,10603,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',5054.77,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1144,7994,40728,10603,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',2499.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1145,7994,40728,10603,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',3440.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1146,7994,40728,10603,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',13498.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1147,7994,40728,10603,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',688.57,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1148,7994,40728,10603,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',688.57,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1149,7994,40728,10603,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',688.57,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1150,7994,40728,10603,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',3139.97,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL);
INSERT INTO `balance_libro` VALUES (1151,7994,40728,10603,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',2162.49,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1152,7994,40728,10603,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1350.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1153,7994,40728,10603,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',632.10,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1154,7994,40728,10603,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',11679.93,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1155,7994,40728,10603,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',8000.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1156,7994,40728,10603,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',5256.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1157,7994,40728,10603,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',2675.68,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1158,7994,40728,10603,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',4769.41,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1159,7994,40728,10603,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',359.80,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1160,7994,40728,10603,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',2859.18,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1161,7994,40728,10603,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',4783.73,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1162,7994,40728,10603,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',3810.45,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1163,7994,40728,10603,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',39650.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1164,7994,40728,10603,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',42373.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1165,7994,40728,10603,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1402.00,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1166,7994,40728,10603,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',5310.56,NULL,NULL,1,'2023-05-27 11:59:58','2023-05-27 11:59:58',NULL),(1167,7994,40728,10603,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',11016.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1168,7994,40728,10603,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',2009.25,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1169,7994,40728,10603,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',11016.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1170,7994,40728,10603,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',5310.56,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1171,7994,40728,10603,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',632.10,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL);
INSERT INTO `balance_libro` VALUES (1172,7994,40728,10603,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',11016.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1173,7994,40728,10603,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',5310.56,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1174,7994,40728,10603,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',1015.35,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1175,7994,40728,10603,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',11990.25,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1176,7994,40728,10603,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',3190.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1177,7994,40728,10603,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1806.01,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1178,7994,40728,10603,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',11990.25,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1179,7994,40728,10603,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',11990.25,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1180,7994,40728,10603,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',1613.40,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1181,7994,40728,10603,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',2060.69,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1182,7994,40728,10603,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',18785.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1183,7994,40728,10603,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',5000.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1184,7994,40728,10603,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',632.10,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1185,7994,40728,10603,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',632.10,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1186,7994,40728,10603,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',309.41,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1187,7994,40728,10603,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',7500.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1188,7994,40728,10603,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',96250.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1189,7994,40728,10603,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',27344.31,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1190,7994,40728,10603,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',44495.40,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1191,7994,40728,10603,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',8000.00,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL),(1192,7994,40728,10603,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2000.01,NULL,NULL,1,'2023-05-27 11:59:59','2023-05-27 11:59:59',NULL);
INSERT INTO `balance_libro` VALUES (1193,7994,40728,10603,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2468.91,NULL,NULL,1,'2023-05-27 12:00:00','2023-05-27 12:00:00',NULL),(1194,7994,40728,10603,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',39650.00,NULL,NULL,1,'2023-05-27 12:00:00','2023-05-27 12:00:00',NULL),(1195,7994,40728,10603,2,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',63000.00,NULL,NULL,1,'2023-05-27 12:01:11','2023-05-27 12:01:11',NULL),(1196,7994,40728,10603,2,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',65000.00,NULL,NULL,1,'2023-05-27 12:01:11','2023-05-27 12:01:11',NULL),(1197,7994,40728,10603,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',52000.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1198,7994,40728,10603,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',99825.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1199,7994,40728,10603,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',70000.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1200,7994,40728,10603,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',27000.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1201,7994,40728,10603,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',60000.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1202,7994,40728,10603,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',71000.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1203,7994,40728,10603,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',4980.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1204,7994,40728,10603,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',15000.02,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1205,7994,40728,10603,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',45000.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1206,7994,40728,10603,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',30000.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1207,7994,40728,10603,2,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',30000.00,NULL,NULL,1,'2023-05-27 12:01:12','2023-05-27 12:01:12',NULL),(1208,7994,40728,10604,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',83300.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1209,7994,40728,10604,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5402.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1210,7994,40728,10604,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',20000.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1211,7994,40728,10604,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5500.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1212,7994,40728,10604,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',60850.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1213,7994,40728,10604,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5750.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL);
INSERT INTO `balance_libro` VALUES (1214,7994,40728,10604,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',78000.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1215,7994,40728,10604,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3000.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1216,7994,40728,10604,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',70000.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1217,7994,40728,10604,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',100000.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1218,7994,40728,10604,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',85000.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1219,7994,40728,10604,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',96600.00,NULL,NULL,1,'2023-05-27 12:04:56','2023-05-27 12:04:56',NULL),(1220,7994,40728,10604,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',87000.00,NULL,NULL,1,'2023-05-27 12:04:57','2023-05-27 12:04:57',NULL),(1221,7994,40728,10604,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',64999.99,NULL,NULL,1,'2023-05-27 12:04:57','2023-05-27 12:04:57',NULL),(1222,7994,40728,10604,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',92500.00,NULL,NULL,1,'2023-05-27 12:04:57','2023-05-27 12:04:57',NULL),(1223,7994,40728,10604,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',10000.04,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1224,7994,40728,10604,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',8928.69,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1225,7994,40728,10604,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6138.00,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1226,7994,40728,10604,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6138.00,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1227,7994,40728,10604,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6138.00,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1228,7994,40728,10604,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5402.89,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1229,7994,40728,10604,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',632.10,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1230,7994,40728,10604,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',575.25,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1231,7994,40728,10604,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',693.96,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1232,7994,40728,10604,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1423.90,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1233,7994,40728,10604,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',688.57,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1234,7994,40728,10604,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4472.71,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL);
INSERT INTO `balance_libro` VALUES (1235,7994,40728,10604,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',13004.44,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1236,7994,40728,10604,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',632.10,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1237,7994,40728,10604,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3157.45,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1238,7994,40728,10604,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',817.50,NULL,NULL,1,'2023-05-27 12:05:08','2023-05-27 12:05:08',NULL),(1239,7994,40728,10604,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',393.86,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1240,7994,40728,10604,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5178.29,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1241,7994,40728,10604,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2859.18,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1242,7994,40728,10604,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',632.10,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1243,7994,40728,10604,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2420.30,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1244,7994,40728,10604,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',191966.81,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1245,7994,40728,10604,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',20792.00,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1246,7994,40728,10604,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',23291.00,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1247,7994,40728,10604,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',24684.37,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1248,7994,40728,10604,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',13004.44,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1249,7994,40728,10604,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',11679.93,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1250,7994,40728,10604,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',2405.54,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1251,7994,40728,10604,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',817.50,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1252,7994,40728,10604,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5499.99,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1253,7994,40728,10604,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',632.10,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1254,7994,40728,10604,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',632.10,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1255,7994,40728,10604,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',18392.00,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL);
INSERT INTO `balance_libro` VALUES (1256,7994,40728,10604,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',87596.01,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1257,7994,40728,10604,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1264.21,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1258,7994,40728,10604,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',69990.47,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1259,7994,40728,10604,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',40965.64,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1260,7994,40728,10604,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1611.82,NULL,NULL,1,'2023-05-27 12:05:09','2023-05-27 12:05:09',NULL),(1261,7994,40728,10604,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',688.57,NULL,NULL,1,'2023-05-27 12:05:10','2023-05-27 12:05:10',NULL),(1262,7994,40728,10604,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',57999.00,NULL,NULL,1,'2023-05-27 12:05:10','2023-05-27 12:05:10',NULL),(1263,7994,40728,10604,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',28199.00,NULL,NULL,1,'2023-05-27 12:05:10','2023-05-27 12:05:10',NULL),(1264,7994,40728,10604,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',54999.00,NULL,NULL,1,'2023-05-27 12:05:10','2023-05-27 12:05:10',NULL),(1265,7994,40728,10604,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',119998.00,NULL,NULL,1,'2023-05-27 12:05:10','2023-05-27 12:05:10',NULL),(1266,7994,40728,10604,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',118997.00,NULL,NULL,1,'2023-05-27 12:05:10','2023-05-27 12:05:10',NULL),(1271,7994,40728,10605,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1360.97,NULL,NULL,1,'2023-05-27 12:06:51','2023-05-27 12:06:51',NULL),(1272,7994,40728,10605,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',10000.04,NULL,NULL,1,'2023-05-27 12:06:51','2023-05-27 12:06:51',NULL),(1273,7994,40728,10605,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',622.90,NULL,NULL,1,'2023-05-27 12:06:51','2023-05-27 12:06:51',NULL),(1274,7994,40728,10605,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',791.86,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1275,7994,40728,10605,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',10769.00,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1276,7994,40728,10605,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',791.86,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1277,7994,40728,10605,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1501.77,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1278,7994,40728,10605,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',562.47,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1279,7994,40728,10605,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',562.47,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1280,7994,40728,10605,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',562.47,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL);
INSERT INTO `balance_libro` VALUES (1281,7994,40728,10605,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',3294.79,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1282,7994,40728,10605,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1629.40,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1283,7994,40728,10605,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',15087.54,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1284,7994,40728,10605,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',56023.00,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1285,7994,40728,10605,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',726.93,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1286,7994,40728,10605,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1583.72,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1287,7994,40728,10605,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2290.05,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1288,7994,40728,10605,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',622.90,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1289,7994,40728,10605,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',281250.00,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1290,7994,40728,10605,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',60000.00,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1291,7994,40728,10605,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1017.80,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1292,7994,40728,10605,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',726.93,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1293,7994,40728,10605,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',62999.00,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1294,7994,40728,10605,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1235.99,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1295,7994,40728,10605,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',5178.29,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1296,7994,40728,10605,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',2859.18,NULL,NULL,1,'2023-05-27 12:06:52','2023-05-27 12:06:52',NULL),(1297,7994,40728,10605,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',661.25,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1298,7994,40728,10605,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',979.05,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1299,7994,40728,10605,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',5070.04,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1300,7994,40728,10605,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',19142.55,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1301,7994,40728,10605,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1245.79,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL);
INSERT INTO `balance_libro` VALUES (1302,7994,40728,10605,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',437.94,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1303,7994,40728,10605,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',5499.99,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1304,7994,40728,10605,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',11591.94,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1305,7994,40728,10605,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',726.93,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1306,7994,40728,10605,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',622.90,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1307,7994,40728,10605,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',47505.60,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1308,7994,40728,10605,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1558.36,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1309,7994,40728,10605,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',42145.05,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1310,7994,40728,10605,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2077.93,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1311,7994,40728,10605,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',50094.00,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1312,7994,40728,10605,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',13004.44,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1313,7994,40728,10605,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-28','2022-08-28',49400.00,NULL,NULL,1,'2023-05-27 12:06:53','2023-05-27 12:06:53',NULL),(1314,7994,40728,10605,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',85000.00,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL),(1315,7994,40728,10605,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',115000.00,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL),(1316,7994,40728,10605,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',67000.00,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL),(1317,7994,40728,10605,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',78000.00,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL),(1318,7994,40728,10605,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',40000.00,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL),(1319,7994,40728,10605,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',40000.00,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL),(1320,7994,40728,10605,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',69421.51,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL),(1321,7994,40728,10605,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',6326.48,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL),(1322,7994,40728,10605,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',177000.02,NULL,NULL,1,'2023-05-27 12:08:21','2023-05-27 12:08:21',NULL);
INSERT INTO `balance_libro` VALUES (1326,7994,40728,10606,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',622.90,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1327,7994,40728,10606,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',10000.04,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1328,7994,40728,10606,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',11700.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1329,7994,40728,10606,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2730.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1330,7994,40728,10606,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2583.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1331,7994,40728,10606,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1179.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1332,7994,40728,10606,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2730.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1333,7994,40728,10606,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',11700.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1334,7994,40728,10606,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2583.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1335,7994,40728,10606,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2730.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1336,7994,40728,10606,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',11700.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1337,7994,40728,10606,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2583.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1338,7994,40728,10606,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2799.04,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1339,7994,40728,10606,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2026.25,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1340,7994,40728,10606,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',14900.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1341,7994,40728,10606,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',9990.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1342,7994,40728,10606,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',9990.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1343,7994,40728,10606,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',9990.00,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1344,7994,40728,10606,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',5353.71,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1345,7994,40728,10606,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',748.26,NULL,NULL,1,'2023-05-27 12:10:45','2023-05-27 12:10:45',NULL),(1346,7994,40728,10606,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',5103.72,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL);
INSERT INTO `balance_libro` VALUES (1347,7994,40728,10606,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2904.00,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1348,7994,40728,10606,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2904.00,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1349,7994,40728,10606,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2904.00,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1350,7994,40728,10606,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',651.00,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1351,7994,40728,10606,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',14503.85,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1352,7994,40728,10606,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',748.26,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1353,7994,40728,10606,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',622.90,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1354,7994,40728,10606,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',665.38,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1355,7994,40728,10606,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',1023.00,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1356,7994,40728,10606,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',4731.47,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1357,7994,40728,10606,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',6681.66,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1358,7994,40728,10606,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1606.98,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1359,7994,40728,10606,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1245.79,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1360,7994,40728,10606,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',6583.50,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1361,7994,40728,10606,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',6240.00,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1362,7994,40728,10606,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',6583.50,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1363,7994,40728,10606,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',6583.50,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1364,7994,40728,10606,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1245.79,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1365,7994,40728,10606,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',54450.00,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1366,7994,40728,10606,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',748.26,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL),(1367,7994,40728,10606,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',2590.00,NULL,NULL,1,'2023-05-27 12:10:46','2023-05-27 12:10:46',NULL);
INSERT INTO `balance_libro` VALUES (1368,7994,40728,10606,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',622.90,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1369,7994,40728,10606,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',9106.48,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1370,7994,40728,10606,3,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',622.90,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1371,7994,40728,10606,3,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',12090.01,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1372,7994,40728,10606,3,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',12090.00,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1373,7994,40728,10606,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',12090.00,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1374,7994,40728,10606,3,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',622.90,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1375,7994,40728,10606,3,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',63283.00,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1376,7994,40728,10606,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',562.47,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1377,7994,40728,10606,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',19410.00,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1378,7994,40728,10606,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',726.93,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1379,7994,40728,10606,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',622.90,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1380,7994,40728,10606,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',41727.96,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1381,7994,40728,10606,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',622.90,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1382,7994,40728,10606,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',71447.47,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1383,7994,40728,10606,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',680.55,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1384,7994,40728,10606,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',57999.00,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1385,7994,40728,10606,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8870.89,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1386,7994,40728,10606,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',562.47,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1387,7994,40728,10606,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',677.48,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL),(1388,7994,40728,10606,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1400.00,NULL,NULL,1,'2023-05-27 12:10:47','2023-05-27 12:10:47',NULL);
INSERT INTO `balance_libro` VALUES (1389,7994,40728,10606,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',53950.00,NULL,NULL,1,'2023-05-27 12:11:49','2023-05-27 12:11:49',NULL),(1390,7994,40728,10606,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',114000.00,NULL,NULL,1,'2023-05-27 12:11:49','2023-05-27 12:11:49',NULL),(1391,7994,40728,10606,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',100000.00,NULL,NULL,1,'2023-05-27 12:11:49','2023-05-27 12:11:49',NULL),(1392,7994,40728,10606,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',36000.00,NULL,NULL,1,'2023-05-27 12:11:49','2023-05-27 12:11:49',NULL),(1393,7994,40728,10606,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',26600.02,NULL,NULL,1,'2023-05-27 12:11:49','2023-05-27 12:11:49',NULL),(1394,7994,40728,10606,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',37400.02,NULL,NULL,1,'2023-05-27 12:11:50','2023-05-27 12:11:50',NULL),(1395,7994,40728,10606,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',92000.00,NULL,NULL,1,'2023-05-27 12:11:50','2023-05-27 12:11:50',NULL),(1396,7994,40728,10606,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',92000.00,NULL,NULL,1,'2023-05-27 12:11:50','2023-05-27 12:11:50',NULL),(1397,7994,40728,10606,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',40000.02,NULL,NULL,1,'2023-05-27 12:11:50','2023-05-27 12:11:50',NULL),(1398,7994,40728,10606,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',92000.00,NULL,NULL,1,'2023-05-27 12:11:50','2023-05-27 12:11:50',NULL),(1399,7994,40728,10606,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',92000.00,NULL,NULL,1,'2023-05-27 12:11:50','2023-05-27 12:11:50',NULL),(1403,7994,40728,10607,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',5561.34,NULL,NULL,1,'2023-05-27 12:13:56','2023-05-27 12:13:56',NULL),(1404,7994,40728,10607,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',10000.04,NULL,NULL,1,'2023-05-27 12:13:56','2023-05-27 12:13:56',NULL),(1405,7994,40728,10607,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',82000.05,NULL,NULL,1,'2023-05-27 12:13:56','2023-05-27 12:13:56',NULL),(1406,7994,40728,10607,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',765.19,NULL,NULL,1,'2023-05-27 12:13:56','2023-05-27 12:13:56',NULL),(1407,7994,40728,10607,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',779.09,NULL,NULL,1,'2023-05-27 12:13:56','2023-05-27 12:13:56',NULL),(1408,7994,40728,10607,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',765.19,NULL,NULL,1,'2023-05-27 12:13:56','2023-05-27 12:13:56',NULL),(1409,7994,40728,10607,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',63283.00,NULL,NULL,1,'2023-05-27 12:13:56','2023-05-27 12:13:56',NULL),(1410,7994,40728,10607,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',779.09,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1411,7994,40728,10607,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',779.09,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1412,7994,40728,10607,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',923.18,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL);
INSERT INTO `balance_libro` VALUES (1413,7994,40728,10607,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',14503.85,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1414,7994,40728,10607,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',435.12,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1415,7994,40728,10607,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',434.56,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1416,7994,40728,10607,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',14503.85,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1417,7994,40728,10607,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',875.05,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1418,7994,40728,10607,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',14432.13,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1419,7994,40728,10607,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',14503.85,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1420,7994,40728,10607,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1625.71,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1421,7994,40728,10607,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',13629.00,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1422,7994,40728,10607,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',13629.00,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1423,7994,40728,10607,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',13629.00,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1424,7994,40728,10607,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',716.32,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1425,7994,40728,10607,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',7194.07,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1426,7994,40728,10607,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',782.63,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1427,7994,40728,10607,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',835.96,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1428,7994,40728,10607,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',66550.00,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1429,7994,40728,10607,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4731.47,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1430,7994,40728,10607,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3630.36,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1431,7994,40728,10607,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',646.84,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1432,7994,40728,10607,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1437.00,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1433,7994,40728,10607,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',133938.45,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL);
INSERT INTO `balance_libro` VALUES (1434,7994,40728,10607,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1432.64,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1435,7994,40728,10607,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',860.52,NULL,NULL,1,'2023-05-27 12:13:57','2023-05-27 12:13:57',NULL),(1436,7994,40728,10607,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',498.90,NULL,NULL,1,'2023-05-27 12:13:58','2023-05-27 12:13:58',NULL),(1437,7994,40728,10607,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',32932.68,NULL,NULL,1,'2023-05-27 12:13:58','2023-05-27 12:13:58',NULL),(1438,7994,40728,10607,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',45883.00,NULL,NULL,1,'2023-05-27 12:13:58','2023-05-27 12:13:58',NULL),(1439,7994,40728,10607,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',21199.35,NULL,NULL,1,'2023-05-27 12:13:58','2023-05-27 12:13:58',NULL),(1440,7994,40728,10607,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1124.50,NULL,NULL,1,'2023-05-27 12:13:58','2023-05-27 12:13:58',NULL),(1441,7994,40728,10607,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',92000.00,NULL,NULL,1,'2023-05-27 12:14:37','2023-05-27 12:14:37',NULL),(1442,7994,40728,10607,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',137120.39,NULL,NULL,1,'2023-05-27 12:14:37','2023-05-27 12:14:37',NULL),(1443,7994,40728,10607,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',100000.33,NULL,NULL,1,'2023-05-27 12:14:37','2023-05-27 12:14:37',NULL),(1444,7994,40728,10607,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',97750.04,NULL,NULL,1,'2023-05-27 12:14:37','2023-05-27 12:14:37',NULL),(1445,7994,40728,10607,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',97485.00,NULL,NULL,1,'2023-05-27 12:14:37','2023-05-27 12:14:37',NULL),(1446,7994,40728,10607,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',87000.00,NULL,NULL,1,'2023-05-27 12:14:37','2023-05-27 12:14:37',NULL),(1447,7994,40728,10608,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',65000.00,NULL,NULL,1,'2023-05-27 12:16:02','2023-05-27 12:16:02',NULL),(1448,7994,40728,10608,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',100000.00,NULL,NULL,1,'2023-05-27 12:16:02','2023-05-27 12:16:02',NULL),(1449,7994,40728,10608,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',85000.04,NULL,NULL,1,'2023-05-27 12:16:02','2023-05-27 12:16:02',NULL),(1450,7994,40728,10608,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',90000.04,NULL,NULL,1,'2023-05-27 12:16:02','2023-05-27 12:16:02',NULL),(1451,7994,40728,10608,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',98400.04,NULL,NULL,1,'2023-05-27 12:16:02','2023-05-27 12:16:02',NULL),(1452,7994,40728,10608,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',70000.00,NULL,NULL,1,'2023-05-27 12:16:02','2023-05-27 12:16:02',NULL),(1453,7994,40728,10608,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1732.27,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1454,7994,40728,10608,3,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',10000.04,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL);
INSERT INTO `balance_libro` VALUES (1455,7994,40728,10608,3,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1732.27,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1456,7994,40728,10608,3,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1732.27,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1457,7994,40728,10608,3,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2174.07,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1458,7994,40728,10608,3,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',860.52,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1459,7994,40728,10608,3,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',19693.61,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1460,7994,40728,10608,3,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',1587.47,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1461,7994,40728,10608,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',3984.81,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1462,7994,40728,10608,3,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',592.28,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1463,7994,40728,10608,3,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',14380.00,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1464,7994,40728,10608,3,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',940.63,NULL,NULL,1,'2023-05-27 12:16:10','2023-05-27 12:16:10',NULL),(1465,7994,40728,10608,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2232.50,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1466,7994,40728,10608,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2232.50,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1467,7994,40728,10608,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2232.50,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1468,7994,40728,10608,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',15504.61,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1469,7994,40728,10608,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6500.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1470,7994,40728,10608,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5123.01,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1471,7994,40728,10608,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5123.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1472,7994,40728,10608,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3685.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1473,7994,40728,10608,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5123.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1474,7994,40728,10608,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',96800.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1475,7994,40728,10608,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',3404.35,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL);
INSERT INTO `balance_libro` VALUES (1476,7994,40728,10608,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',5144.46,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1477,7994,40728,10608,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',90750.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1478,7994,40728,10608,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',16990.02,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1479,7994,40728,10608,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1637.76,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1480,7994,40728,10608,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',6500.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1481,7994,40728,10608,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',96800.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1482,7994,40728,10608,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',74999.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1483,7994,40728,10608,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',40000.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1484,7994,40728,10608,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',10498.57,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1485,7994,40728,10608,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',909.32,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1486,7994,40728,10608,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',716.32,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1487,7994,40728,10608,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',498.90,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1488,7994,40728,10608,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',40725.29,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1489,7994,40728,10608,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',34998.03,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1490,7994,40728,10608,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1500.00,NULL,NULL,1,'2023-05-27 12:16:11','2023-05-27 12:16:11',NULL),(1491,7994,40728,10608,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1369.00,NULL,NULL,1,'2023-05-27 12:16:12','2023-05-27 12:16:12',NULL),(1492,7994,40728,10608,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',659.85,NULL,NULL,1,'2023-05-27 12:16:12','2023-05-27 12:16:12',NULL),(1493,7994,40728,10608,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8658.86,NULL,NULL,1,'2023-05-27 12:16:12','2023-05-27 12:16:12',NULL),(1494,7994,40728,10608,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',16156.98,NULL,NULL,1,'2023-05-27 12:16:12','2023-05-27 12:16:12',NULL),(1495,7994,40728,10609,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',92000.00,NULL,NULL,1,'2023-05-27 12:17:54','2023-05-27 12:17:54',NULL),(1496,7994,40728,10609,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',92000.00,NULL,NULL,1,'2023-05-27 12:17:54','2023-05-27 12:17:54',NULL);
INSERT INTO `balance_libro` VALUES (1497,7994,40728,10609,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',150000.02,NULL,NULL,1,'2023-05-27 12:17:54','2023-05-27 12:17:54',NULL),(1498,7994,40728,10609,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',162000.00,NULL,NULL,1,'2023-05-27 12:17:54','2023-05-27 12:17:54',NULL),(1499,7994,40728,10609,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',7800.02,NULL,NULL,1,'2023-05-27 12:17:55','2023-05-27 12:17:55',NULL),(1500,7994,40728,10609,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',20000.00,NULL,NULL,1,'2023-05-27 12:17:55','2023-05-27 12:17:55',NULL),(1501,7994,40728,10609,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',20000.00,NULL,NULL,1,'2023-05-27 12:17:55','2023-05-27 12:17:55',NULL),(1502,7994,40728,10609,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',90000.00,NULL,NULL,1,'2023-05-27 12:17:55','2023-05-27 12:17:55',NULL),(1503,7994,40728,10609,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',137000.00,NULL,NULL,1,'2023-05-27 12:17:55','2023-05-27 12:17:55',NULL),(1504,7994,40728,10609,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',90000.00,NULL,NULL,1,'2023-05-27 12:17:55','2023-05-27 12:17:55',NULL),(1505,7994,40728,10609,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',135000.00,NULL,NULL,1,'2023-05-27 12:17:55','2023-05-27 12:17:55',NULL),(1506,7994,40728,10609,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',12500.00,NULL,NULL,1,'2023-05-27 12:18:06','2023-05-27 12:18:06',NULL),(1507,7994,40728,10609,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',742.03,NULL,NULL,1,'2023-05-27 12:18:06','2023-05-27 12:18:06',NULL),(1508,7994,40728,10609,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',61999.04,NULL,NULL,1,'2023-05-27 12:18:06','2023-05-27 12:18:06',NULL),(1509,7994,40728,10609,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',96800.00,NULL,NULL,1,'2023-05-27 12:18:06','2023-05-27 12:18:06',NULL),(1510,7994,40728,10609,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1653.00,NULL,NULL,1,'2023-05-27 12:18:06','2023-05-27 12:18:06',NULL),(1511,7994,40728,10609,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1414.00,NULL,NULL,1,'2023-05-27 12:18:06','2023-05-27 12:18:06',NULL),(1512,7994,40728,10609,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1813.35,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1513,7994,40728,10609,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',55999.20,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1514,7994,40728,10609,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',143998.40,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1515,7994,40728,10609,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',20419.79,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1516,7994,40728,10609,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',7267.80,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1517,7994,40728,10609,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',4800.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL);
INSERT INTO `balance_libro` VALUES (1518,7994,40728,10609,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',84700.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1519,7994,40728,10609,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',989.59,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1520,7994,40728,10609,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',6500.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1521,7994,40728,10609,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',58080.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1522,7994,40728,10609,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',16506.21,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1523,7994,40728,10609,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2366.99,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1524,7994,40728,10609,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',108900.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1525,7994,40728,10609,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',4766.11,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1526,7994,40728,10609,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',7039.30,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1527,7994,40728,10609,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',35798.60,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1528,7994,40728,10609,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',108900.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1529,7994,40728,10609,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',6873.97,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1530,7994,40728,10609,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',108900.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1531,7994,40728,10609,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',23998.40,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1532,7994,40728,10609,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',108900.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1533,7994,40728,10609,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',498.90,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1534,7994,40728,10609,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',108900.00,NULL,NULL,1,'2023-05-27 12:18:07','2023-05-27 12:18:07',NULL),(1535,7994,40728,10609,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1497.00,NULL,NULL,1,'2023-05-27 12:18:08','2023-05-27 12:18:08',NULL),(1536,7994,40728,10609,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',114950.00,NULL,NULL,1,'2023-05-27 12:18:08','2023-05-27 12:18:08',NULL),(1537,7994,40728,10609,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',125998.60,NULL,NULL,1,'2023-05-27 12:18:08','2023-05-27 12:18:08',NULL),(1538,7994,40728,10609,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',28252.04,NULL,NULL,1,'2023-05-27 12:18:08','2023-05-27 12:18:08',NULL);
INSERT INTO `balance_libro` VALUES (1539,7994,40799,200439,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',698091.24,NULL,NULL,1,'2023-05-29 19:39:39','2023-05-29 19:39:39',NULL),(1540,7994,40799,200439,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',12100.00,NULL,NULL,1,'2023-05-29 19:39:40','2023-05-29 19:39:40',NULL),(1541,7994,40799,200439,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',30000.00,NULL,NULL,1,'2023-05-29 19:40:40','2023-05-29 19:40:40',NULL),(1542,7994,40799,200439,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',46028.29,NULL,NULL,1,'2023-05-29 19:40:40','2023-05-29 19:40:40',NULL),(1543,7994,40799,200439,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',35156.00,NULL,NULL,1,'2023-05-29 19:40:40','2023-05-29 19:40:40',NULL),(1544,7994,40799,200439,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',22500.00,NULL,NULL,1,'2023-05-29 19:40:40','2023-05-29 19:40:40',NULL),(1545,7994,40799,200439,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',3800.00,NULL,NULL,1,'2023-05-29 19:40:40','2023-05-29 19:40:40',NULL),(1546,7994,40799,200439,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',51033.29,NULL,NULL,1,'2023-05-29 19:40:40','2023-05-29 19:40:40',NULL),(1547,7994,40799,200439,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',33450.00,NULL,NULL,1,'2023-05-29 19:40:40','2023-05-29 19:40:40',NULL),(1548,7994,40799,200439,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',3818.98,NULL,NULL,1,'2023-05-29 19:40:41','2023-05-29 19:40:41',NULL),(1549,7994,40851,189814,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',3658.00,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1550,7994,40851,189814,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',385651.20,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1551,7994,40851,189814,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',19601.03,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1552,7994,40851,189814,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',3585.00,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1553,7994,40851,189814,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',8279.00,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1554,7994,40851,189814,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',5660.08,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1555,7994,40851,189814,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',15395.01,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1556,7994,40851,189814,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',6490.00,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1557,7994,40851,189814,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',16403.30,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:49','2024-05-29 17:41:49'),(1558,7994,40851,189814,3,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',16499.00,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:50','2024-05-29 17:41:50');
INSERT INTO `balance_libro` VALUES (1559,7994,40851,189814,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',10893.80,NULL,NULL,1,'2023-05-30 12:06:24','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1560,7994,40851,189814,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',33078.37,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1561,7994,40851,189814,3,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',3481.64,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1562,7994,40851,189814,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',0.42,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1563,7994,40851,189814,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',60000.00,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1564,7994,40851,189814,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',556.60,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1565,7994,40851,189814,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',6565.00,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1566,7994,40851,189814,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',14808.40,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1567,7994,40851,189814,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',706.75,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1568,7994,40851,189814,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',24961.95,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1569,7994,40851,189814,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',19019.26,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1570,7994,40851,189814,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',13979.00,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:50','2024-05-29 17:41:50'),(1571,7994,40851,189814,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',3148.36,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1572,7994,40851,189814,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',831.10,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1573,7994,40851,189814,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',19019.26,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1574,7994,40851,189814,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',740.24,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1575,7994,40851,189814,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',367.44,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1576,7994,40851,189814,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',1284.64,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1577,7994,40851,189814,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',15000.00,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51');
INSERT INTO `balance_libro` VALUES (1578,7994,40851,189814,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1049.00,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1579,7994,40851,189814,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2198.99,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1580,7994,40851,189814,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2755.00,NULL,NULL,1,'2023-05-30 12:06:25','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1581,7994,40851,189815,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',12659.26,NULL,NULL,1,'2023-05-30 12:08:55','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1582,7994,40851,189815,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1058.65,NULL,NULL,1,'2023-05-30 12:08:55','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1583,7994,40851,189815,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5572.50,NULL,NULL,1,'2023-05-30 12:08:55','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1584,7994,40851,189815,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',12542.63,NULL,NULL,1,'2023-05-30 12:08:55','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1585,7994,40851,189815,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',314.60,NULL,NULL,1,'2023-05-30 12:08:55','2024-05-29 17:41:51','2024-05-29 17:41:51'),(1586,7994,40851,189815,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',60000.00,NULL,NULL,1,'2023-05-30 12:08:55','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1587,7994,40851,189815,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',7465.00,NULL,NULL,1,'2023-05-30 12:08:55','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1588,7994,40851,189815,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',1302.43,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1589,7994,40851,189815,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',25601.39,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1590,7994,40851,189815,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1866.00,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1591,7994,40851,189815,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',18000.95,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1592,7994,40851,189815,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',16424.03,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1593,7994,40851,189815,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2357.17,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1594,7994,40851,189815,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',15000.00,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1595,7994,40851,189815,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',5690.00,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1596,7994,40851,189815,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',6297.00,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52');
INSERT INTO `balance_libro` VALUES (1597,7994,40851,189815,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3300.00,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1598,7994,40851,189815,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',373.24,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1599,7994,40851,189815,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',4318.00,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:52','2024-05-29 17:41:52'),(1600,7994,40851,189815,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',19981.76,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1601,7994,40851,189815,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',21999.00,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1602,7994,40851,189815,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',756.25,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1603,7994,40851,189815,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',5176.93,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1604,7994,40851,189815,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',9020.01,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1605,7994,40851,189815,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1466.28,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1606,7994,40851,189815,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',6725.18,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1607,7994,40851,189815,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',19462.89,NULL,NULL,1,'2023-05-30 12:08:56','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1608,7994,40851,189815,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1167.46,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1609,7994,40851,189815,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3871.19,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1610,7994,40851,189815,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',722.29,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1611,7994,40851,189815,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',11851.47,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1612,7994,40851,189815,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',302.50,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:53','2024-05-29 17:41:53'),(1613,7994,40851,189815,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',15284.36,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1614,7994,40851,189815,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',24918.79,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1615,7994,40851,189815,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',23863.55,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:54','2024-05-29 17:41:54');
INSERT INTO `balance_libro` VALUES (1616,7994,40851,189815,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',14067.00,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1617,7994,40851,189815,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1865.51,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1618,7994,40851,189815,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',994.00,NULL,NULL,1,'2023-05-30 12:08:57','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1619,7994,40851,189816,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2683.30,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1620,7994,40851,189816,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',9380.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1621,7994,40851,189816,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',3995.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1622,7994,40851,189816,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',14999.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1623,7994,40851,189816,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',15572.77,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1624,7994,40851,189816,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',605.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1625,7994,40851,189816,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',14118.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1626,7994,40851,189816,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',1711.32,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:54','2024-05-29 17:41:54'),(1627,7994,40851,189816,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',21575.13,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1628,7994,40851,189816,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',15000.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1629,7994,40851,189816,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',61000.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1630,7994,40851,189816,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',75000.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1631,7994,40851,189816,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',40328.39,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1632,7994,40851,189816,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',17928.33,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1633,7994,40851,189816,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2827.85,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1634,7994,40851,189816,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1438.85,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55');
INSERT INTO `balance_libro` VALUES (1635,7994,40851,189816,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1119.25,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1636,7994,40851,189816,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',34058.31,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1637,7994,40851,189816,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',37319.64,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1638,7994,40851,189816,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',22154.83,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1639,7994,40851,189816,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',18800.54,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1640,7994,40851,189816,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',16002.40,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1641,7994,40851,189816,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',10310.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:55','2024-05-29 17:41:55'),(1642,7994,40851,189816,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',4318.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1643,7994,40851,189816,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6670.00,NULL,NULL,1,'2023-05-30 12:11:18','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1644,7994,40851,189816,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',373.24,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1645,7994,40851,189816,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',8480.00,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1646,7994,40851,189816,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',8624.00,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1647,7994,40851,189816,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',104999.00,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1648,7994,40851,189816,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',2009.56,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1649,7994,40851,189816,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',24311.69,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1650,7994,40851,189816,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',10460.66,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1651,7994,40851,189816,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',11299.00,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1652,7994,40851,189816,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',13528.87,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1653,7994,40851,189816,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',7294.00,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56');
INSERT INTO `balance_libro` VALUES (1654,7994,40851,189816,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',21304.40,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1655,7994,40851,189816,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',980.03,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1656,7994,40851,189816,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',605.00,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:56','2024-05-29 17:41:56'),(1657,7994,40851,189816,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8140.50,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1658,7994,40851,189816,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2983.50,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1659,7994,40851,189816,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',8714.49,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1660,7994,40851,189816,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',8705.03,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1661,7994,40851,189816,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2684.64,NULL,NULL,1,'2023-05-30 12:11:19','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1662,7994,40851,189816,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',36894.71,NULL,NULL,1,'2023-05-30 12:11:20','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1663,7994,40851,189816,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',6230.40,NULL,NULL,1,'2023-05-30 12:11:20','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1664,7994,40851,189816,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11305.25,NULL,NULL,1,'2023-05-30 12:11:20','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1665,7994,40851,189816,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',108.54,NULL,NULL,1,'2023-05-30 12:11:20','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1666,7994,40851,189816,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',7887.49,NULL,NULL,1,'2023-05-30 12:11:20','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1667,7994,40851,189817,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7666.56,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1668,7994,40851,189817,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',15214.75,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1669,7994,40851,189817,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1331.00,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1670,7994,40851,189817,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',6552.36,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1671,7994,40851,189817,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5874.00,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:57','2024-05-29 17:41:57'),(1672,7994,40851,189817,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1175.27,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58');
INSERT INTO `balance_libro` VALUES (1673,7994,40851,189817,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',19449.40,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1674,7994,40851,189817,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',20400.60,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1675,7994,40851,189817,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',15974.99,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1676,7994,40851,189817,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',40697.75,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1677,7994,40851,189817,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',23966.49,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1678,7994,40851,189817,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',635.25,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1679,7994,40851,189817,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',75000.00,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1680,7994,40851,189817,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',10089.98,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1681,7994,40851,189817,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1875.68,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1682,7994,40851,189817,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',17500.00,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1683,7994,40851,189817,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',18500.80,NULL,NULL,1,'2023-05-30 12:12:25','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1684,7994,40851,189817,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',7070.25,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1685,7994,40851,189817,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',26243.75,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1686,7994,40851,189817,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',786.50,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:58','2024-05-29 17:41:58'),(1687,7994,40851,189817,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',12320.58,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1688,7994,40851,189817,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',443.55,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1689,7994,40851,189817,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',7112.00,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1690,7994,40851,189817,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',25994.25,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1691,7994,40851,189817,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2131.08,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59');
INSERT INTO `balance_libro` VALUES (1692,7994,40851,189817,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',20257.58,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1693,7994,40851,189817,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',888.63,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1694,7994,40851,189817,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',980.10,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1695,7994,40851,189817,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',15115.01,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1696,7994,40851,189817,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',24343.15,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1697,7994,40851,189817,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1399.30,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1698,7994,40851,189817,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',17417.01,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1699,7994,40851,189817,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',7294.00,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1700,7994,40851,189817,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',29264.40,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1701,7994,40851,189817,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2138.00,NULL,NULL,1,'2023-05-30 12:12:26','2024-05-29 17:41:59','2024-05-29 17:41:59'),(1702,7994,40799,200440,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1300.00,NULL,NULL,1,'2023-05-30 12:58:11','2023-05-30 12:58:11',NULL),(1703,7994,40799,200440,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',24261.04,NULL,NULL,1,'2023-05-30 12:58:11','2023-05-30 12:58:11',NULL),(1704,7994,40799,200440,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',158260.74,NULL,NULL,1,'2023-05-30 12:58:11','2023-05-30 12:58:11',NULL),(1705,7994,40799,200440,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',3970.01,NULL,NULL,1,'2023-05-30 12:58:11','2023-05-30 12:58:11',NULL),(1706,7994,40799,200441,2,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1262148.99,NULL,NULL,1,'2023-05-30 12:59:12','2023-05-30 12:59:12',NULL),(1707,7994,40799,200441,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',675127.99,NULL,NULL,1,'2023-05-30 12:59:12','2023-05-30 12:59:12',NULL),(1708,7994,40799,200441,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',20426.15,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1709,7994,40799,200441,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',6600.01,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1710,7994,40799,200441,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',21000.02,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1711,7994,40799,200441,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',45029.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL);
INSERT INTO `balance_libro` VALUES (1712,7994,40799,200441,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',35000.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1713,7994,40799,200441,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1400.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1714,7994,40799,200441,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',39400.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1715,7994,40799,200441,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',45535.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1716,7994,40799,200441,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',45635.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1717,7994,40799,200441,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',72800.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1718,7994,40799,200441,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',46956.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1719,7994,40799,200441,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',46956.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1720,7994,40799,200441,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',23000.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1721,7994,40799,200441,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',66109.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1722,7994,40799,200441,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',46956.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1723,7994,40799,200441,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',9142.82,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1724,7994,40799,200441,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',3500.00,NULL,NULL,1,'2023-05-30 12:59:49','2023-05-30 12:59:49',NULL),(1725,7994,40799,200441,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',43335.00,NULL,NULL,1,'2023-05-30 12:59:50','2023-05-30 12:59:50',NULL),(1726,7994,40799,200441,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',44535.00,NULL,NULL,1,'2023-05-30 12:59:50','2023-05-30 12:59:50',NULL),(1727,7994,40799,200441,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',34756.00,NULL,NULL,1,'2023-05-30 12:59:50','2023-05-30 12:59:50',NULL),(1728,7994,40799,200442,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1315499.46,NULL,NULL,1,'2023-05-30 13:02:37','2023-05-30 13:02:37',NULL),(1729,7994,40799,200442,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',12690.04,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1730,7994,40799,200442,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',49728.29,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1731,7994,40799,200442,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',12650.56,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL);
INSERT INTO `balance_libro` VALUES (1732,7994,40799,200442,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',59128.29,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1733,7994,40799,200442,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',2370.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1734,7994,40799,200442,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',8857.20,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1735,7994,40799,200442,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1380.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1736,7994,40799,200442,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',6900.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1737,7994,40799,200442,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',6395.63,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1738,7994,40799,200442,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',32995.01,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1739,7994,40799,200442,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',17470.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1740,7994,40799,200442,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',4100.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1741,7994,40799,200442,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',1285.79,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1742,7994,40799,200442,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',18100.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1743,7994,40799,200442,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',22990.11,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1744,7994,40799,200442,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',5203.23,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1745,7994,40799,200442,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',15000.04,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1746,7994,40799,200442,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',475.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1747,7994,40799,200442,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',43335.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1748,7994,40799,200442,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',54276.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1749,7994,40799,200442,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',48990.00,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1750,7994,40799,200442,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',52728.29,NULL,NULL,1,'2023-05-30 13:03:23','2023-05-30 13:03:23',NULL),(1751,7994,40799,200442,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',69248.29,NULL,NULL,1,'2023-05-30 13:03:24','2023-05-30 13:03:24',NULL);
INSERT INTO `balance_libro` VALUES (1752,7994,40799,200442,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',14200.00,NULL,NULL,1,'2023-05-30 13:03:24','2023-05-30 13:03:24',NULL),(1753,7994,40799,200442,3,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',45335.00,NULL,NULL,1,'2023-05-30 13:03:24','2023-05-30 13:03:24',NULL),(1754,7994,40799,200442,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',16060.33,NULL,NULL,1,'2023-05-30 13:03:24','2023-05-30 13:03:24',NULL),(1755,7994,40799,200443,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1230620.60,NULL,NULL,1,'2023-05-30 13:04:15','2023-05-30 13:04:15',NULL),(1756,7994,40799,200443,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',16226.15,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1757,7994,40799,200443,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2568.43,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1758,7994,40799,200443,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',2500.00,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1759,7994,40799,200443,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',57180.00,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1760,7994,40799,200443,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',56190.00,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1761,7994,40799,200443,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',66940.00,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1762,7994,40799,200443,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',76178.29,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1763,7994,40799,200443,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',43000.00,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1764,7994,40799,200443,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',98628.29,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1765,7994,40799,200443,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',58750.00,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1766,7994,40799,200443,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',17500.00,NULL,NULL,1,'2023-05-30 13:05:24','2023-05-30 13:05:24',NULL),(1767,7994,40799,200443,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',15000.01,NULL,NULL,1,'2023-05-30 13:05:25','2023-05-30 13:05:25',NULL),(1768,7994,40799,200443,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',12817.79,NULL,NULL,1,'2023-05-30 13:05:25','2023-05-30 13:05:25',NULL),(1769,7994,40799,200444,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1384412.18,NULL,NULL,1,'2023-05-30 13:06:14','2023-05-30 13:06:14',NULL),(1770,7994,40799,200444,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',6910.04,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1771,7994,40799,200444,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',2407.90,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL);
INSERT INTO `balance_libro` VALUES (1772,7994,40799,200444,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',3600.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1773,7994,40799,200444,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',3580.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1774,7994,40799,200444,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',17484.31,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1775,7994,40799,200444,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',17697.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1776,7994,40799,200444,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',1000.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1777,7994,40799,200444,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',5503.98,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1778,7994,40799,200444,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',3600.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1779,7994,40799,200444,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',26395.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1780,7994,40799,200444,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',14199.35,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1781,7994,40799,200444,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',5000.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1782,7994,40799,200444,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',34200.04,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1783,7994,40799,200444,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',152019.01,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1784,7994,40799,200444,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',2154.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1785,7994,40799,200444,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',13250.04,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1786,7994,40799,200444,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',51728.00,NULL,NULL,1,'2023-05-30 13:06:47','2023-05-30 13:06:47',NULL),(1787,7994,40799,200444,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',79970.00,NULL,NULL,1,'2023-05-30 13:06:48','2023-05-30 13:06:48',NULL),(1788,7994,40799,200444,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',70235.00,NULL,NULL,1,'2023-05-30 13:06:48','2023-05-30 13:06:48',NULL),(1789,7994,40799,200444,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',57720.00,NULL,NULL,1,'2023-05-30 13:06:48','2023-05-30 13:06:48',NULL),(1790,7994,40799,200444,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',48135.00,NULL,NULL,1,'2023-05-30 13:06:48','2023-05-30 13:06:48',NULL),(1791,7994,40799,200444,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',76288.29,NULL,NULL,1,'2023-05-30 13:06:48','2023-05-30 13:06:48',NULL);
INSERT INTO `balance_libro` VALUES (1792,7994,40799,200444,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',61350.00,NULL,NULL,1,'2023-05-30 13:06:48','2023-05-30 13:06:48',NULL),(1793,7994,40799,200444,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',45335.00,NULL,NULL,1,'2023-05-30 13:06:48','2023-05-30 13:06:48',NULL),(1794,7994,40799,200444,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',14999.99,NULL,NULL,1,'2023-05-30 13:06:48','2023-05-30 13:06:48',NULL),(1795,7994,40799,200445,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1512846.43,NULL,NULL,1,'2023-05-30 13:09:03','2023-05-30 13:09:03',NULL),(1796,7994,40799,200445,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',17499.52,NULL,NULL,1,'2023-05-30 13:09:57','2023-05-30 13:09:57',NULL),(1797,7994,40799,200445,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',2407.90,NULL,NULL,1,'2023-05-30 13:09:57','2023-05-30 13:09:57',NULL),(1798,7994,40799,200445,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6628.73,NULL,NULL,1,'2023-05-30 13:09:57','2023-05-30 13:09:57',NULL),(1799,7994,40799,200445,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',590.04,NULL,NULL,1,'2023-05-30 13:09:57','2023-05-30 13:09:57',NULL),(1800,7994,40799,200445,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',5776.80,NULL,NULL,1,'2023-05-30 13:09:57','2023-05-30 13:09:57',NULL),(1801,7994,40799,200445,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6900.00,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1802,7994,40799,200445,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1460.02,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1803,7994,40799,200445,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7061.62,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1804,7994,40799,200445,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5373.00,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1805,7994,40799,200445,3,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9030.00,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1806,7994,40799,200445,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',43000.00,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1807,7994,40799,200445,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',23452.47,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1808,7994,40799,200445,3,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',10914.05,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1809,7994,40799,200445,3,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5289.64,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1810,7994,40799,200445,3,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',16000.00,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1811,7994,40799,200445,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',86230.00,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL);
INSERT INTO `balance_libro` VALUES (1812,7994,40799,200445,3,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',2400.00,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1813,7994,40799,200445,3,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',96368.29,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1814,7994,40799,200445,3,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',64728.29,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1815,7994,40799,200445,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',9000.00,NULL,NULL,1,'2023-05-30 13:09:58','2023-05-30 13:09:58',NULL),(1816,7994,40799,200446,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1845973.94,NULL,NULL,1,'2023-05-30 13:10:31','2023-05-30 13:10:31',NULL),(1817,7994,40799,200446,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',50000.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1818,7994,40799,200446,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',6612.04,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1819,7994,40799,200446,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',61435.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1820,7994,40799,200446,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2430.05,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1821,7994,40799,200446,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',37780.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1822,7994,40799,200446,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',456350.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1823,7994,40799,200446,3,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',60470.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1824,7994,40799,200446,3,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3025.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1825,7994,40799,200446,3,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',28920.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1826,7994,40799,200446,3,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',6612.04,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1827,7994,40799,200446,3,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',823.06,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1828,7994,40799,200446,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2200.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1829,7994,40799,200446,3,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2200.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1830,7994,40799,200446,3,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',6620.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1831,7994,40799,200446,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',7000.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL);
INSERT INTO `balance_libro` VALUES (1832,7994,40799,200446,3,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',6999.00,NULL,NULL,1,'2023-05-30 13:10:57','2023-05-30 13:10:57',NULL),(1833,7994,40799,200446,3,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',25990.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1834,7994,40799,200446,3,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',19000.13,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1835,7994,40799,200446,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',6612.04,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1836,7994,40799,200446,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',2380.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1837,7994,40799,200446,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',18411.96,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1838,7994,40799,200446,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',108978.29,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1839,7994,40799,200446,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',16000.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1840,7994,40799,200446,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',10000.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1841,7994,40799,200446,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',46990.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1842,7994,40799,200446,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',65928.29,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1843,7994,40799,200446,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',65335.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1844,7994,40799,200446,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',77530.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1845,7994,40799,200446,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',6505.29,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1846,7994,40799,200446,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',9000.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1847,7994,40799,200446,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',99910.00,NULL,NULL,1,'2023-05-30 13:10:58','2023-05-30 13:10:58',NULL),(1848,7994,40799,200447,2,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',125554.44,NULL,NULL,1,'2023-05-30 13:11:56','2023-05-30 13:11:56',NULL),(1849,7994,40799,200447,2,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1537586.32,NULL,NULL,1,'2023-05-30 13:11:56','2023-05-30 13:11:56',NULL),(1850,7994,40799,200447,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1486766.32,NULL,NULL,1,'2023-05-30 13:11:56','2023-05-30 13:11:56',NULL),(1851,7994,40799,200447,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1537586.32,NULL,NULL,1,'2023-05-30 13:11:56','2023-05-30 13:11:56',NULL);
INSERT INTO `balance_libro` VALUES (1852,7994,40799,200447,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',50000.00,NULL,NULL,1,'2023-05-30 13:12:28','2023-05-30 13:12:28',NULL),(1853,7994,40799,200447,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',8230.00,NULL,NULL,1,'2023-05-30 13:12:28','2023-05-30 13:12:28',NULL),(1854,7994,40799,200447,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',7605.98,NULL,NULL,1,'2023-05-30 13:12:28','2023-05-30 13:12:28',NULL),(1855,7994,40799,200447,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',475.00,NULL,NULL,1,'2023-05-30 13:12:28','2023-05-30 13:12:28',NULL),(1856,7994,40799,200447,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',14500.02,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1857,7994,40799,200447,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',7558.50,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1858,7994,40799,200447,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',81626.08,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1859,7994,40799,200447,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',81626.08,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1860,7994,40799,200447,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',81626.08,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1861,7994,40799,200447,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',6590.02,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1862,7994,40799,200447,3,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',2860.00,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1863,7994,40799,200447,3,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',6000.00,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1864,7994,40799,200447,3,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',7500.00,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1865,7994,40799,200447,3,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',7878.79,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1866,7994,40799,200447,3,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',66280.00,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1867,7994,40799,200447,3,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',49950.00,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1868,7994,40799,200447,3,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',5500.00,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1869,7994,40799,200447,3,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',16000.00,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1870,7994,40799,200447,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2140.05,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL),(1871,7994,40799,200447,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',50000.00,NULL,NULL,1,'2023-05-30 13:12:29','2023-05-30 13:12:29',NULL);
INSERT INTO `balance_libro` VALUES (1872,7994,40799,200448,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',147620.00,NULL,NULL,1,'2023-05-30 13:13:41','2023-05-30 13:13:41',NULL),(1873,7994,40799,200448,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1752506.11,NULL,NULL,1,'2023-05-30 13:13:41','2023-05-30 13:13:41',NULL),(1874,7994,40799,200448,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',73585.00,NULL,NULL,1,'2023-05-30 13:13:56','2023-05-30 13:13:56',NULL),(1875,7994,40799,200448,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',100328.29,NULL,NULL,1,'2023-05-30 13:13:56','2023-05-30 13:13:56',NULL),(1876,7994,40799,200448,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',68628.29,NULL,NULL,1,'2023-05-30 13:13:56','2023-05-30 13:13:56',NULL),(1877,7994,40799,200448,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',9384.03,NULL,NULL,1,'2023-05-30 13:13:56','2023-05-30 13:13:56',NULL),(1878,7994,40799,200448,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',69381.95,NULL,NULL,1,'2023-05-30 13:13:56','2023-05-30 13:13:56',NULL),(1879,7994,40799,200448,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',588100.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1880,7994,40799,200448,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',6911.70,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1881,7994,40799,200448,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',14520.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1882,7994,40799,200448,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',3500.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1883,7994,40799,200448,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',129278.29,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1884,7994,40799,200448,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',75685.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1885,7994,40799,200448,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',54000.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1886,7994,40799,200448,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',75930.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1887,7994,40799,200448,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',13500.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1888,7994,40799,200448,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2499.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1889,7994,40799,200448,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',50000.00,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1890,7994,40799,200448,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',68928.29,NULL,NULL,1,'2023-05-30 13:13:57','2023-05-30 13:13:57',NULL),(1891,7994,40799,200449,2,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',97405.00,NULL,NULL,1,'2023-05-30 13:14:24','2023-05-30 13:14:24',NULL);
INSERT INTO `balance_libro` VALUES (1892,7994,40799,200449,2,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2302244.14,NULL,NULL,1,'2023-05-30 13:14:24','2023-05-30 13:14:24',NULL),(1893,7994,40799,200449,2,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',24200.00,NULL,NULL,1,'2023-05-30 13:14:24','2023-05-30 13:14:24',NULL),(1894,7994,40799,200449,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',86120.48,NULL,NULL,1,'2023-05-30 13:14:41','2023-05-30 13:14:41',NULL),(1895,7994,40799,200449,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',61999.00,NULL,NULL,1,'2023-05-30 13:14:41','2023-05-30 13:14:41',NULL),(1896,7994,40799,200449,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',120625.66,NULL,NULL,1,'2023-05-30 13:14:41','2023-05-30 13:14:41',NULL),(1897,7994,40799,200449,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',42000.04,NULL,NULL,1,'2023-05-30 13:14:42','2023-05-30 13:14:42',NULL),(1898,7994,40799,200449,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6120.46,NULL,NULL,1,'2023-05-30 13:14:42','2023-05-30 13:14:42',NULL),(1899,7994,40799,200449,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',18000.00,NULL,NULL,1,'2023-05-30 13:14:42','2023-05-30 13:14:42',NULL),(1900,7994,40799,200449,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',50000.00,NULL,NULL,1,'2023-05-30 13:14:42','2023-05-30 13:14:42',NULL),(1901,7994,40799,200449,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',215978.29,NULL,NULL,1,'2023-05-30 13:14:42','2023-05-30 13:14:42',NULL),(1902,7994,40799,200449,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',57600.00,NULL,NULL,1,'2023-05-30 13:14:42','2023-05-30 13:14:42',NULL),(1903,7994,40799,200449,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',70980.00,NULL,NULL,1,'2023-05-30 13:14:42','2023-05-30 13:14:42',NULL),(1904,7994,40799,200449,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',114928.29,NULL,NULL,1,'2023-05-30 13:14:42','2023-05-30 13:14:42',NULL),(1905,7994,40799,200450,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',272250.00,NULL,NULL,1,'2023-05-30 13:15:29','2023-05-30 13:15:29',NULL),(1906,7994,40799,200450,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2053444.87,NULL,NULL,1,'2023-05-30 13:15:29','2023-05-30 13:15:29',NULL),(1907,7994,40799,200450,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',86273.00,NULL,NULL,1,'2023-05-30 13:15:29','2023-05-30 13:15:29',NULL),(1908,7994,40799,200450,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',41432.14,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1909,7994,40799,200450,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3166.61,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1910,7994,40799,200450,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',5399.87,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1911,7994,40799,200450,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4558.34,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL);
INSERT INTO `balance_libro` VALUES (1912,7994,40799,200450,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',8978.24,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1913,7994,40799,200450,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',6300.02,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1914,7994,40799,200450,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',20984.53,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1915,7994,40799,200450,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',29295.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1916,7994,40799,200450,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',106410.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1917,7994,40799,200450,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',289.98,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1918,7994,40799,200450,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',136.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1919,7994,40799,200450,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',100.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1920,7994,40799,200450,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',26500.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1921,7994,40799,200450,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',137928.29,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1922,7994,40799,200450,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',20000.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1923,7994,40799,200450,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',69580.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1924,7994,40799,200450,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',43000.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1925,7994,40799,200450,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',110000.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1926,7994,40799,200450,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',18000.00,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1927,7994,40799,200450,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',31920.01,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1928,7994,40799,200450,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2419.54,NULL,NULL,1,'2023-05-30 13:16:03','2023-05-30 13:16:03',NULL),(1929,7994,40799,200450,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1000.00,NULL,NULL,1,'2023-05-30 13:16:04','2023-05-30 13:16:04',NULL),(1930,7994,40799,200450,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',94121.00,NULL,NULL,1,'2023-05-30 13:16:04','2023-05-30 13:16:04',NULL),(1931,7994,40799,200450,3,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',20325.00,NULL,NULL,1,'2023-05-30 13:16:04','2023-05-30 13:16:04',NULL);
INSERT INTO `balance_libro` VALUES (1932,7994,40799,200450,3,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',14739.66,NULL,NULL,1,'2023-05-30 13:16:04','2023-05-30 13:16:04',NULL),(1935,7994,40723,200472,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',8973.00,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1936,7994,40723,200472,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',3592.01,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1937,7994,40723,200472,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',3592.00,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1938,7994,40723,200472,3,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',30959.99,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1939,7994,40723,200472,3,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',32204.48,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1940,7994,40723,200472,3,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',12000.00,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1941,7994,40723,200472,3,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',1159.11,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1942,7994,40723,200472,3,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',26019.99,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1943,7994,40723,200472,3,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',26999.08,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1944,7994,40723,200472,3,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',5655.72,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1945,7994,40723,200472,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',2112.13,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1946,7994,40723,200472,3,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',11750.00,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1947,7994,40723,200472,3,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',3093.97,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1948,7994,40723,200472,3,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',2350.00,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1949,7994,40723,200472,3,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',38000.05,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1950,7994,40723,200472,3,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1159.09,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1951,7994,40723,200472,3,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2789.33,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1952,7994,40723,200472,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',9399.28,NULL,NULL,1,'2023-05-30 17:24:59','2023-05-30 17:24:59',NULL),(1953,7994,41970,197399,1,1953,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,74808.52,NULL,NULL,1,'2023-05-31 11:18:12','2023-05-31 11:18:12',NULL);
INSERT INTO `balance_libro` VALUES (1954,7994,40842,200534,3,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',10916.00,NULL,NULL,1,'2023-05-31 17:05:09','2023-05-31 17:05:09',NULL),(1955,7994,40842,200534,3,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',8409.04,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1956,7994,40842,200534,3,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',84556.69,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1957,7994,40842,200534,3,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',3464.46,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1958,7994,40842,200534,3,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',7831.26,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1959,7994,40842,200534,3,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',16843.73,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1960,7994,40842,200534,3,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',44889.38,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1961,7994,40842,200534,3,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',79249.64,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1962,7994,40842,200534,3,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2904.00,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1963,7994,40842,200534,3,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',20118.62,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1964,7994,40842,200534,3,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',51724.50,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1965,7994,40842,200534,3,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',144357.81,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1966,7994,40842,200534,3,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',2800.00,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1967,7994,40842,200534,3,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',16565.44,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1968,7994,40842,200534,3,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',61092.95,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1969,7994,40842,200534,3,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',0.00,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1970,7994,40842,200534,3,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',7787.96,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1971,7994,40842,200534,3,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',9812.13,NULL,NULL,1,'2023-05-31 17:05:10','2023-05-31 17:05:10',NULL),(1972,7994,40842,200534,3,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',29022.46,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1973,7994,40842,200534,3,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',69053.05,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL);
INSERT INTO `balance_libro` VALUES (1974,7994,40842,200534,3,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',36028.94,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1975,7994,40842,200534,3,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',7634.76,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1976,7994,40842,200534,3,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',31179.33,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1977,7994,40842,200534,3,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',3900.00,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1978,7994,40842,200534,3,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1662.25,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1979,7994,40842,200534,3,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',19001.40,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1980,7994,40842,200534,3,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',67441.81,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1981,7994,40842,200534,3,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1000.00,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1982,7994,40842,200534,3,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',19912.25,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1983,7994,40842,200534,3,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',15210.28,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1984,7994,40842,200534,3,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',90.52,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1985,7994,40842,200534,3,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',15980.86,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1986,7994,40842,200534,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',93435.78,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1987,7994,40842,200534,3,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',27809.22,NULL,NULL,1,'2023-05-31 17:05:11','2023-05-31 17:05:11',NULL),(1988,7994,40842,200534,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',83717.30,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL),(1989,7994,40842,200534,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',71241.63,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL),(1990,7994,40842,200534,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',53351.05,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL),(1991,7994,40842,200534,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',3863.81,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL),(1992,7994,40842,200534,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',3313.71,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL),(1993,7994,40842,200534,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',12461.15,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL);
INSERT INTO `balance_libro` VALUES (1994,7994,40842,200534,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',91416.27,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL),(1995,7994,40842,200534,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',21093.61,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL),(1996,7994,40842,200534,3,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',63305.49,NULL,NULL,1,'2023-05-31 17:05:12','2023-05-31 17:05:12',NULL),(1997,7994,40842,200535,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',71241.63,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(1998,7994,40842,200535,3,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',45924.64,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(1999,7994,40842,200535,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',13301.94,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2000,7994,40842,200535,3,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',27809.22,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2001,7994,40842,200535,3,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',71241.63,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2002,7994,40842,200535,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',27809.22,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2003,7994,40842,200535,3,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',44793.41,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2004,7994,40842,200535,3,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',22470.43,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2005,7994,40842,200535,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',127578.39,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2006,7994,40842,200535,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',33574.05,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2007,7994,40842,200535,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',4486.69,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2008,7994,40842,200535,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',2904.00,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2009,7994,40842,200535,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',35532.57,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2010,7994,40842,200535,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',11000.00,NULL,NULL,1,'2023-05-31 17:09:13','2023-05-31 17:09:13',NULL),(2011,7994,40842,200535,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-10','2022-04-10',0.00,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2012,7994,40842,200535,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',24323.24,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2013,7994,40842,200535,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',14058.43,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL);
INSERT INTO `balance_libro` VALUES (2014,7994,40842,200535,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',93435.78,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2015,7994,40842,200535,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',15210.28,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2016,7994,40842,200535,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',77798.17,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2017,7994,40842,200535,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',10840.31,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2018,7994,40842,200535,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',42176.39,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2019,7994,40842,200535,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',60425.33,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2020,7994,40842,200535,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',96008.62,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2021,7994,40842,200535,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',11126.60,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2022,7994,40842,200535,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2322.67,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2023,7994,40842,200535,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',26186.18,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2024,7994,40842,200535,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',5497.86,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2025,7994,40842,200535,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',27612.62,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2026,7994,40842,200535,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',69147.29,NULL,NULL,1,'2023-05-31 17:09:14','2023-05-31 17:09:14',NULL),(2027,7994,40842,200535,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',25282.70,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2028,7994,40842,200535,3,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1491.52,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2029,7994,40842,200535,3,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',9379.51,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2030,7994,40842,200535,3,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',6203.23,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2031,7994,40842,200535,3,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',63198.82,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2032,7994,40842,200535,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',15457.27,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2033,7994,40842,200535,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',29575.36,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL);
INSERT INTO `balance_libro` VALUES (2034,7994,40842,200535,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',13653.71,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2035,7994,40842,200535,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',5331.37,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2036,7994,40842,200535,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',29266.84,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2037,7994,40842,200535,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',20.04,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2038,7994,40842,200535,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',32556.70,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2039,7994,40842,200535,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',9119.33,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2040,7994,40842,200535,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',47590.37,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2041,7994,40842,200535,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4611.26,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2042,7994,40842,200535,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',8507.86,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2043,7994,40842,200535,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',73865.17,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2044,7994,40842,200535,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',16362.82,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2045,7994,40842,200535,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',40584.57,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2046,7994,40842,200535,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',107794.75,NULL,NULL,1,'2023-05-31 17:09:15','2023-05-31 17:09:15',NULL),(2047,7994,40842,200536,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',34287.50,NULL,NULL,1,'2023-05-31 17:10:05','2023-05-31 17:10:05',NULL),(2048,7994,40842,200536,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',36873.50,NULL,NULL,1,'2023-05-31 17:10:05','2023-05-31 17:10:05',NULL),(2049,7994,40842,200536,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',58547.80,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL),(2050,7994,40842,200536,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',2904.00,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL),(2051,7994,40842,200536,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',12354.22,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL),(2052,7994,40842,200536,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',20373.47,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL),(2053,7994,40842,200536,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',43314.43,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL);
INSERT INTO `balance_libro` VALUES (2054,7994,40842,200536,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',36843.41,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL),(2055,7994,40842,200536,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',148694.52,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL),(2056,7994,40842,200536,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',40421.82,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL),(2057,7994,40842,200536,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',39822.34,NULL,NULL,1,'2023-05-31 17:10:06','2023-05-31 17:10:06',NULL),(2058,7994,40842,200536,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',4410.78,NULL,NULL,1,'2023-05-31 17:10:07','2023-05-31 17:10:07',NULL),(2059,7994,40842,200536,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',60626.57,NULL,NULL,1,'2023-05-31 17:10:07','2023-05-31 17:10:07',NULL),(2060,7994,40842,200536,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',0.00,NULL,NULL,1,'2023-05-31 17:10:07','2023-05-31 17:10:07',NULL),(2061,7994,40842,200536,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',20794.41,NULL,NULL,1,'2023-05-31 17:10:07','2023-05-31 17:10:07',NULL),(2062,7994,40842,200536,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',13596.73,NULL,NULL,1,'2023-05-31 17:10:07','2023-05-31 17:10:07',NULL),(2063,7994,40842,200536,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',20373.47,NULL,NULL,1,'2023-05-31 17:10:07','2023-05-31 17:10:07',NULL),(2064,7994,40842,200536,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',6000.00,NULL,NULL,1,'2023-05-31 17:10:07','2023-05-31 17:10:07',NULL),(2065,7994,40842,200536,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',83669.55,NULL,NULL,1,'2023-05-31 17:10:07','2023-05-31 17:10:07',NULL),(2066,7994,40842,200536,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',11531.10,NULL,NULL,1,'2023-05-31 17:10:08','2023-05-31 17:10:08',NULL),(2067,7994,40842,200536,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',5993.45,NULL,NULL,1,'2023-05-31 17:10:08','2023-05-31 17:10:08',NULL),(2068,7994,40842,200536,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',25670.69,NULL,NULL,1,'2023-05-31 17:10:08','2023-05-31 17:10:08',NULL),(2069,7994,40842,200536,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',49895.34,NULL,NULL,1,'2023-05-31 17:10:08','2023-05-31 17:10:08',NULL),(2070,7994,40842,200536,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',85281.99,NULL,NULL,1,'2023-05-31 17:10:08','2023-05-31 17:10:08',NULL),(2071,7994,40842,200536,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',36317.64,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL),(2072,7994,40842,200536,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',66241.87,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL),(2073,7994,40842,200536,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',103090.41,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL);
INSERT INTO `balance_libro` VALUES (2074,7994,40842,200536,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',12000.00,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL),(2075,7994,40842,200536,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',48252.41,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL),(2076,7994,40842,200536,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-22','2022-05-22',61.52,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL),(2077,7994,40842,200536,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',25284.04,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL),(2078,7994,40842,200536,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',33063.84,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL),(2079,7994,40842,200536,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',37068.26,NULL,NULL,1,'2023-05-31 17:10:09','2023-05-31 17:10:09',NULL),(2080,7994,40842,200536,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',5299.26,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2081,7994,40842,200536,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',33388.97,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2082,7994,40842,200536,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',115088.28,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2083,7994,40842,200536,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',17215.29,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2084,7994,40842,200536,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1930.10,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2085,7994,40842,200536,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',7565.17,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2086,7994,40842,200536,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',107078.09,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2087,7994,40842,200536,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',10491.48,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2088,7994,40842,200536,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',44652.24,NULL,NULL,1,'2023-05-31 17:10:10','2023-05-31 17:10:10',NULL),(2089,7994,40842,200536,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',101405.42,NULL,NULL,1,'2023-05-31 17:10:11','2023-05-31 17:10:11',NULL),(2090,7994,40842,200536,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6974.04,NULL,NULL,1,'2023-05-31 17:10:11','2023-05-31 17:10:11',NULL),(2091,7994,40842,200536,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',8577.07,NULL,NULL,1,'2023-05-31 17:10:11','2023-05-31 17:10:11',NULL),(2092,7994,40842,200536,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',11342.58,NULL,NULL,1,'2023-05-31 17:10:11','2023-05-31 17:10:11',NULL),(2093,7994,40842,200536,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',11657.94,NULL,NULL,1,'2023-05-31 17:10:11','2023-05-31 17:10:11',NULL);
INSERT INTO `balance_libro` VALUES (2094,7994,40842,200536,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',80586.09,NULL,NULL,1,'2023-05-31 17:10:11','2023-05-31 17:10:11',NULL),(2095,7994,40842,200536,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',59208.03,NULL,NULL,1,'2023-05-31 17:10:11','2023-05-31 17:10:11',NULL),(2096,7994,40842,200537,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',46072.97,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2097,7994,40842,200537,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',16091.31,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2098,7994,40842,200537,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',20053.97,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2099,7994,40842,200537,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',8506.69,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2100,7994,40842,200537,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',7008.44,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2101,7994,40842,200537,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',16833.62,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2102,7994,40842,200537,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',23958.00,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2103,7994,40842,200537,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',31630.91,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2104,7994,40842,200537,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',65432.36,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2105,7994,40842,200537,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',20053.97,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2106,7994,40842,200537,3,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',28841.96,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2107,7994,40842,200537,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',31557.79,NULL,NULL,1,'2023-05-31 17:12:57','2023-05-31 17:12:57',NULL),(2108,7994,40842,200537,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',7352.71,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2109,7994,40842,200537,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',26681.98,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2110,7994,40842,200537,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',98554.92,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2111,7994,40842,200537,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',90595.74,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2112,7994,40842,200537,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',7576.63,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2113,7994,40842,200537,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',49609.03,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL);
INSERT INTO `balance_libro` VALUES (2114,7994,40842,200537,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',3935.68,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2115,7994,40842,200537,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',4329.43,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2116,7994,40842,200537,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',11496.63,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2117,7994,40842,200537,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',0.00,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2118,7994,40842,200537,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',13793.74,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2119,7994,40842,200537,3,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',23513.33,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2120,7994,40842,200537,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',50156.76,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2121,7994,40842,200537,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',76258.58,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2122,7994,40842,200537,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',24132.92,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2123,7994,40842,200537,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',2904.00,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2124,7994,40842,200537,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',127970.96,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2125,7994,40842,200537,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',14639.85,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2126,7994,40842,200537,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',99743.05,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2127,7994,40842,200537,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1615.03,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2128,7994,40842,200537,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',88752.60,NULL,NULL,1,'2023-05-31 17:12:58','2023-05-31 17:12:58',NULL),(2129,7994,40842,200537,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',13936.19,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2130,7994,40842,200537,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',13911.07,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2131,7994,40842,200537,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',3290.00,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2132,7994,40842,200537,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',28191.88,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2133,7994,40842,200537,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',81078.13,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL);
INSERT INTO `balance_libro` VALUES (2134,7994,40842,200537,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',75385.28,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2135,7994,40842,200537,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',24245.64,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2136,7994,40842,200537,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',133753.13,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2137,7994,40842,200537,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',5039.61,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2138,7994,40842,200537,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',152362.27,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2139,7994,40842,200537,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',169.92,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2140,7994,40842,200537,3,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',4085.91,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2141,7994,40842,200537,3,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',4089.88,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2142,7994,40842,200537,3,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',67960.62,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2143,7994,40842,200537,3,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',2536.89,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2144,7994,40842,200537,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',3850.41,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2145,7994,40842,200537,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',60277.12,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2146,7994,40842,200537,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',7200.00,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2147,7994,40842,200537,3,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',10472.80,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2148,7994,40842,200537,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',8993.20,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2149,7994,40842,200537,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',64781.54,NULL,NULL,1,'2023-05-31 17:12:59','2023-05-31 17:12:59',NULL),(2150,7994,40842,200537,3,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',79796.01,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2151,7994,40842,200537,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',12724.89,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2152,7994,40842,200537,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',93367.74,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2153,7994,40842,200537,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',13596.11,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL);
INSERT INTO `balance_libro` VALUES (2154,7994,40842,200537,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',96538.82,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2155,7994,40842,200537,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',29426.03,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2156,7994,40842,200537,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',65263.66,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2157,7994,40842,200537,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',10260.80,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2158,7994,40842,200537,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',4053.00,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2159,7994,40842,200537,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',10472.80,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2160,7994,40842,200537,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',679.74,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2161,7994,40842,200537,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',6687.66,NULL,NULL,1,'2023-05-31 17:13:00','2023-05-31 17:13:00',NULL),(2162,7994,40842,200537,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',66201.32,NULL,NULL,1,'2023-05-31 17:13:01','2023-05-31 17:13:01',NULL),(2163,7994,40842,200537,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',63491.99,NULL,NULL,1,'2023-05-31 17:13:01','2023-05-31 17:13:01',NULL),(2164,7994,40842,200537,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',26837.81,NULL,NULL,1,'2023-05-31 17:13:01','2023-05-31 17:13:01',NULL),(2165,7994,40842,200538,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2904.00,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2166,7994,40842,200538,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',12950.96,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2167,7994,40842,200538,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5345.68,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2168,7994,40842,200538,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',61421.81,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2169,7994,40842,200538,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',142003.30,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2170,7994,40842,200538,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',112018.29,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2171,7994,40842,200538,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',28953.81,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2172,7994,40842,200538,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4756.89,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2173,7994,40842,200538,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',204.50,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL);
INSERT INTO `balance_libro` VALUES (2174,7994,40842,200538,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4668.00,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2175,7994,40842,200538,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7010.24,NULL,NULL,1,'2023-05-31 17:13:39','2023-05-31 17:13:39',NULL),(2176,7994,40842,200538,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3239.00,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2177,7994,40842,200538,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',636.24,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2178,7994,40842,200538,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3397.99,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2179,7994,40842,200538,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',680.85,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2180,7994,40842,200538,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2947.96,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2181,7994,40842,200538,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',189.00,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2182,7994,40842,200538,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',9600.00,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2183,7994,40842,200538,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',122147.96,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2184,7994,40842,200538,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',31342.25,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2185,7994,40842,200538,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',0.00,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2186,7994,40842,200538,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',35801.36,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2187,7994,40842,200538,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',17371.25,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2188,7994,40842,200538,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',30309.05,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2189,7994,40842,200538,3,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',90088.69,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2190,7994,40842,200538,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',52428.36,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2191,7994,40842,200538,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',113656.46,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2192,7994,40842,200538,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',30937.91,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2193,7994,40842,200538,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',42670.28,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL);
INSERT INTO `balance_libro` VALUES (2194,7994,40842,200538,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5051.47,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2195,7994,40842,200538,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2995.60,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2196,7994,40842,200538,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',144624.94,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2197,7994,40842,200538,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2198,7994,40842,200538,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',30758.21,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2199,7994,40842,200538,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',55298.72,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2200,7994,40842,200538,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',81300.73,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2201,7994,40842,200538,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',11180.11,NULL,NULL,1,'2023-05-31 17:13:40','2023-05-31 17:13:40',NULL),(2202,7994,40842,200538,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',70354.99,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2203,7994,40842,200538,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',34295.04,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2204,7994,40842,200538,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6653.12,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2205,7994,40842,200538,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',40205.73,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2206,7994,40842,200538,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',31003.39,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2207,7994,40842,200538,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',62331.29,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2208,7994,40842,200538,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',45.67,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2209,7994,40842,200538,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',28202.79,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2210,7994,40842,200538,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',26542.45,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2211,7994,40842,200538,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',4110.20,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2212,7994,40842,200538,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',68346.69,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2213,7994,40842,200538,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',72524.65,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL);
INSERT INTO `balance_libro` VALUES (2214,7994,40842,200538,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',12421.17,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2215,7994,40842,200538,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',109753.23,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2216,7994,40842,200538,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',7500.00,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2217,7994,40842,200538,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',19000.38,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2218,7994,40842,200538,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6000.00,NULL,NULL,1,'2023-05-31 17:13:41','2023-05-31 17:13:41',NULL),(2219,7994,40842,200539,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',23274.64,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2220,7994,40842,200539,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2904.00,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2221,7994,40842,200539,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',4105.39,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2222,7994,40842,200539,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',38774.97,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2223,7994,40842,200539,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',54908.23,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2224,7994,40842,200539,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',18126.64,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2225,7994,40842,200539,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',84919.83,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2226,7994,40842,200539,3,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',109036.16,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2227,7994,40842,200539,3,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',50403.75,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2228,7994,40842,200539,3,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',21893.40,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2229,7994,40842,200539,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',41313.47,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2230,7994,40842,200539,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',71743.46,NULL,NULL,1,'2023-05-31 17:16:39','2023-05-31 17:16:39',NULL),(2231,7994,40842,200539,3,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',21941.92,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2232,7994,40842,200539,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',7153.88,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2233,7994,40842,200539,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',43706.32,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL);
INSERT INTO `balance_libro` VALUES (2234,7994,40842,200539,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',3972.59,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2235,7994,40842,200539,3,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',40896.09,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2236,7994,40842,200539,3,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',33716.26,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2237,7994,40842,200539,3,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',130961.01,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2238,7994,40842,200539,3,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',11201.10,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2239,7994,40842,200539,3,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',42935.01,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2240,7994,40842,200539,3,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',85661.55,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2241,7994,40842,200539,3,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',105123.69,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2242,7994,40842,200539,3,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',28033.33,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2243,7994,40842,200539,3,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',45694.84,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2244,7994,40842,200539,3,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3678.02,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2245,7994,40842,200539,3,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1186.11,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2246,7994,40842,200539,3,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',55063.47,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2247,7994,40842,200539,3,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3025.00,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2248,7994,40842,200539,3,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',25395.19,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2249,7994,40842,200539,3,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',107754.81,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2250,7994,40842,200539,3,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',120529.28,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2251,7994,40842,200539,3,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',39850.80,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2252,7994,40842,200539,3,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',24699.49,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL),(2253,7994,40842,200539,3,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',22080.37,NULL,NULL,1,'2023-05-31 17:16:40','2023-05-31 17:16:40',NULL);
INSERT INTO `balance_libro` VALUES (2254,7994,40842,200539,3,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',20826.33,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2255,7994,40842,200539,3,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',46354.26,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2256,7994,40842,200539,3,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',27009.61,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2257,7994,40842,200539,3,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',11191.60,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2258,7994,40842,200539,3,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',37865.67,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2259,7994,40842,200539,3,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',8690.99,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2260,7994,40842,200539,3,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',5459.98,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2261,7994,40842,200539,3,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',63462.98,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2262,7994,40842,200539,3,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',12942.75,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2263,7994,40842,200539,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',52785.19,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2264,7994,40842,200539,3,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',70252.48,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2265,7994,40842,200539,3,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',15575.16,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2266,7994,40842,200539,3,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2880.33,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2267,7994,40842,200539,3,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',124329.85,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2268,7994,40842,200539,3,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',43346.15,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2269,7994,40842,200539,3,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',46700.64,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2270,7994,40842,200539,3,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',69960.72,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2271,7994,40842,200539,3,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',168.64,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2272,7994,40842,200539,3,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',7356.35,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2273,7994,40842,200539,3,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',151229.65,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL);
INSERT INTO `balance_libro` VALUES (2274,7994,40842,200539,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',34072.21,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2275,7994,40842,200539,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',19530.20,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2276,7994,40842,200539,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',2005.59,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2277,7994,40842,200539,3,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',7500.00,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2278,7994,40842,200539,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',30129.97,NULL,NULL,1,'2023-05-31 17:16:41','2023-05-31 17:16:41',NULL),(2279,7994,40842,200539,3,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-28','2022-08-28',35012.76,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2280,7994,40842,200539,3,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',244266.80,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2281,7994,40842,200539,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',23759.56,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2282,7994,40842,200539,3,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',73220.58,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2283,7994,40842,200539,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',26000.82,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2284,7994,40842,200539,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',8983.86,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2285,7994,40842,200539,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',145361.54,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2286,7994,40842,200539,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',56811.11,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2287,7994,40842,200539,3,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1177.84,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2288,7994,40842,200539,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',11355.92,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2289,7994,40842,200539,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29382.31,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2290,7994,40842,200539,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',55025.96,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2291,7994,40842,200539,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',214.68,NULL,NULL,1,'2023-05-31 17:16:42','2023-05-31 17:16:42',NULL),(2292,7994,40842,200540,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',79765.99,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL),(2293,7994,40842,200540,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',10010.39,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL);
INSERT INTO `balance_libro` VALUES (2294,7994,40842,200540,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',31199.11,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL),(2295,7994,40842,200540,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',57922.86,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL),(2296,7994,40842,200540,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',33409.83,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL),(2297,7994,40842,200540,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',60442.03,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL),(2298,7994,40842,200540,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',83124.02,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL),(2299,7994,40842,200540,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',5228.90,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL),(2300,7994,40842,200540,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',70734.25,NULL,NULL,1,'2023-05-31 17:17:48','2023-05-31 17:17:48',NULL),(2301,7994,40842,200540,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',29460.38,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2302,7994,40842,200540,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1574.74,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2303,7994,40842,200540,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',52162.35,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2304,7994,40842,200540,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',49989.58,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2305,7994,40842,200540,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',34895.19,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2306,7994,40842,200540,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',21117.75,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2307,7994,40842,200540,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3025.00,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2308,7994,40842,200540,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',56709.92,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2309,7994,40842,200540,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',51458.98,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2310,7994,40842,200540,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',15833.39,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2311,7994,40842,200540,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',21113.10,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2312,7994,40842,200540,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',113805.09,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2313,7994,40842,200540,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',119458.55,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL);
INSERT INTO `balance_libro` VALUES (2314,7994,40842,200540,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',39078.92,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2315,7994,40842,200540,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',3756.18,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2316,7994,40842,200540,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',7500.00,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2317,7994,40842,200540,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',46069.36,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2318,7994,40842,200540,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',38911.22,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2319,7994,40842,200540,3,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',47949.26,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2320,7994,40842,200540,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',3630.00,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2321,7994,40842,200540,3,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',51160.05,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2322,7994,40842,200540,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',22780.27,NULL,NULL,1,'2023-05-31 17:17:49','2023-05-31 17:17:49',NULL),(2323,7994,40842,200540,3,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',179155.79,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2324,7994,40842,200540,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',123927.42,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2325,7994,40842,200540,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',5872.86,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2326,7994,40842,200540,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',41399.40,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2327,7994,40842,200540,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',6741.94,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2328,7994,40842,200540,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',37.75,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2329,7994,40842,200540,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',37698.36,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2330,7994,40842,200540,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',7118.53,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2331,7994,40842,200540,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',36719.10,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2332,7994,40842,200540,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3347.70,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL),(2333,7994,40842,200540,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6412.51,NULL,NULL,1,'2023-05-31 17:17:50','2023-05-31 17:17:50',NULL);
INSERT INTO `balance_libro` VALUES (2334,7994,40842,200541,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',21623.57,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2335,7994,40842,200541,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',15550.41,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2336,7994,40842,200541,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',70351.29,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2337,7994,40842,200541,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3262.18,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2338,7994,40842,200541,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',80622.90,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2339,7994,40842,200541,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',123910.36,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2340,7994,40842,200541,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',116014.12,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2341,7994,40842,200541,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',53775.48,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2342,7994,40842,200541,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1882.60,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2343,7994,40842,200541,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7500.00,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2344,7994,40842,200541,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',17902.94,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2345,7994,40842,200541,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',38504.17,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2346,7994,40842,200541,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',12999.99,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2347,7994,40842,200541,3,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',3502.47,NULL,NULL,1,'2023-05-31 17:19:11','2023-05-31 17:19:11',NULL),(2348,7994,40842,200541,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',34021.32,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2349,7994,40842,200541,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',34051.31,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2350,7994,40842,200541,3,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',64667.45,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2351,7994,40842,200541,3,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',78708.27,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2352,7994,40842,200541,3,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',50885.88,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2353,7994,40842,200541,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',6741.94,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL);
INSERT INTO `balance_libro` VALUES (2354,7994,40842,200541,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',23148.24,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2355,7994,40842,200541,3,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',35429.63,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2356,7994,40842,200541,3,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',16800.00,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2357,7994,40842,200541,3,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',102421.45,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2358,7994,40842,200541,3,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',119084.75,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2359,7994,40842,200541,3,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',19215.15,NULL,NULL,1,'2023-05-31 17:19:12','2023-05-31 17:19:12',NULL),(2360,7994,40842,200541,3,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',127468.94,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2361,7994,40842,200541,3,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1496.97,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2362,7994,40842,200541,3,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',38401.46,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2363,7994,40842,200541,3,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',75677.87,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2364,7994,40842,200541,3,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',48200.57,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2365,7994,40842,200541,3,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',261.31,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2366,7994,40842,200541,3,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',39320.10,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2367,7994,40842,200541,3,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',71.34,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2368,7994,40842,200541,3,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',24828.39,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2369,7994,40842,200541,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',80699.79,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2370,7994,40842,200541,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',106700.98,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2371,7994,40842,200541,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',15107.57,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2372,7994,40842,200541,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',25444.09,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2373,7994,40842,200541,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',698.04,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL);
INSERT INTO `balance_libro` VALUES (2374,7994,40842,200541,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',22726.26,NULL,NULL,1,'2023-05-31 17:19:13','2023-05-31 17:19:13',NULL),(2375,7994,40842,200541,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',106196.14,NULL,NULL,1,'2023-05-31 17:19:14','2023-05-31 17:19:14',NULL),(2376,7994,40842,200541,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',22012.95,NULL,NULL,1,'2023-05-31 17:19:14','2023-05-31 17:19:14',NULL),(2377,7994,40842,200541,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6526.38,NULL,NULL,1,'2023-05-31 17:19:14','2023-05-31 17:19:14',NULL),(2378,7994,40842,200541,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',35448.07,NULL,NULL,1,'2023-05-31 17:19:14','2023-05-31 17:19:14',NULL),(2379,7994,40842,200541,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',95096.03,NULL,NULL,1,'2023-05-31 17:19:14','2023-05-31 17:19:14',NULL),(2380,7994,40842,200541,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',15886.97,NULL,NULL,1,'2023-05-31 17:19:14','2023-05-31 17:19:14',NULL),(2381,7994,40842,200542,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',82770.56,NULL,NULL,1,'2023-05-31 17:20:22','2023-05-31 17:20:22',NULL),(2382,7994,40842,200542,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',42162.83,NULL,NULL,1,'2023-05-31 17:20:22','2023-05-31 17:20:22',NULL),(2383,7994,40842,200542,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',58283.95,NULL,NULL,1,'2023-05-31 17:20:22','2023-05-31 17:20:22',NULL),(2384,7994,40842,200542,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',7500.00,NULL,NULL,1,'2023-05-31 17:20:22','2023-05-31 17:20:22',NULL),(2385,7994,40842,200542,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',116746.45,NULL,NULL,1,'2023-05-31 17:20:22','2023-05-31 17:20:22',NULL),(2386,7994,40842,200542,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',65343.76,NULL,NULL,1,'2023-05-31 17:20:22','2023-05-31 17:20:22',NULL),(2387,7994,40842,200542,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',27290.91,NULL,NULL,1,'2023-05-31 17:20:22','2023-05-31 17:20:22',NULL),(2388,7994,40842,200542,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',27276.70,NULL,NULL,1,'2023-05-31 17:20:22','2023-05-31 17:20:22',NULL),(2389,7994,40842,200542,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2792.73,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2390,7994,40842,200542,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',55108.57,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2391,7994,40842,200542,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',122052.03,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2392,7994,40842,200542,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',20033.08,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2393,7994,40842,200542,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',29860.15,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL);
INSERT INTO `balance_libro` VALUES (2394,7994,40842,200542,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',38503.81,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2395,7994,40842,200542,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',12117.26,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2396,7994,40842,200542,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',43390.57,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2397,7994,40842,200542,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',3972.52,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2398,7994,40842,200542,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',15134.00,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2399,7994,40842,200542,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',101603.33,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2400,7994,40842,200542,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',33531.85,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2401,7994,40842,200542,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',142706.08,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2402,7994,40842,200542,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',57339.15,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2403,7994,40842,200542,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',71001.34,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2404,7994,40842,200542,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3842.22,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2405,7994,40842,200542,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',12653.35,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2406,7994,40842,200542,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',28245.72,NULL,NULL,1,'2023-05-31 17:20:23','2023-05-31 17:20:23',NULL),(2407,7994,40842,200542,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',49.51,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2408,7994,40842,200542,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',63041.33,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2409,7994,40842,200542,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',47918.00,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2410,7994,40842,200542,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',42969.29,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2411,7994,40842,200542,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',100643.72,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2412,7994,40842,200542,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',42950.65,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2413,7994,40842,200542,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',29047.09,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL);
INSERT INTO `balance_libro` VALUES (2414,7994,40842,200542,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',9703.00,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2415,7994,40842,200542,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',168365.51,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2416,7994,40842,200542,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',18800.00,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2417,7994,40842,200542,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',800.00,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2418,7994,40842,200542,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',96021.36,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2419,7994,40842,200542,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',46965.66,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2420,7994,40842,200542,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',74882.99,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2421,7994,40842,200542,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4375.45,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2422,7994,40842,200542,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',70391.60,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2423,7994,40842,200542,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',30321.64,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2424,7994,40842,200542,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',20837.22,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2425,7994,40842,200542,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',20837.22,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2426,7994,40842,200542,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',16467.63,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2427,7994,40842,200542,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',12607.04,NULL,NULL,1,'2023-05-31 17:20:24','2023-05-31 17:20:24',NULL),(2428,7994,40842,200542,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12492.87,NULL,NULL,1,'2023-05-31 17:20:25','2023-05-31 17:20:25',NULL),(2429,7994,40842,200542,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',20837.22,NULL,NULL,1,'2023-05-31 17:20:25','2023-05-31 17:20:25',NULL),(2430,7994,40842,200543,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',30317.31,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2431,7994,40842,200543,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',6460.59,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2432,7994,40842,200543,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',21506.36,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2433,7994,40842,200543,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',7802.77,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL);
INSERT INTO `balance_libro` VALUES (2434,7994,40842,200543,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',44972.87,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2435,7994,40842,200543,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',47062.54,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2436,7994,40842,200543,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',124402.71,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2437,7994,40842,200543,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',85143.53,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2438,7994,40842,200543,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',113895.19,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2439,7994,40842,200543,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',78304.90,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2440,7994,40842,200543,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',4301.44,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2441,7994,40842,200543,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2152.30,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2442,7994,40842,200543,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',4210.65,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2443,7994,40842,200543,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',62479.36,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2444,7994,40842,200543,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',7500.00,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2445,7994,40842,200543,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',108458.25,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2446,7994,40842,200543,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',112823.59,NULL,NULL,1,'2023-05-31 17:21:08','2023-05-31 17:21:08',NULL),(2447,7994,40842,200543,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',30617.86,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2448,7994,40842,200543,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',202402.91,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2449,7994,40842,200543,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2594.98,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2450,7994,40842,200543,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',31062.62,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2451,7994,40842,200543,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',27588.00,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2452,7994,40842,200543,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',9484.80,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2453,7994,40842,200543,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',7514.32,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL);
INSERT INTO `balance_libro` VALUES (2454,7994,40842,200543,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',17442.61,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2455,7994,40842,200543,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',11764.22,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2456,7994,40842,200543,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',21600.00,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2457,7994,40842,200543,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4338.84,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2458,7994,40842,200543,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',91908.87,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2459,7994,40842,200543,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',4213.78,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2460,7994,40842,200543,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',32088.58,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2461,7994,40842,200543,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',62705.00,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2462,7994,40842,200543,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',116719.54,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2463,7994,40842,200543,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',31364.96,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2464,7994,40842,200543,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',101533.62,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2465,7994,40842,200543,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',172008.95,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2466,7994,40842,200543,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',149.87,NULL,NULL,1,'2023-05-31 17:21:09','2023-05-31 17:21:09',NULL),(2467,7994,40842,200543,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',32448.05,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2468,7994,40842,200543,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',19778.53,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2469,7994,40842,200543,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',9887.73,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2470,7994,40842,200543,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',21600.00,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2471,7994,40842,200543,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',9824.86,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2472,7994,40842,200543,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',7287.52,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2473,7994,40842,200543,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',160108.99,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL);
INSERT INTO `balance_libro` VALUES (2474,7994,40842,200543,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',142288.60,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2475,7994,40842,200543,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',39102.18,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2476,7994,40842,200543,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',61641.30,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2477,7994,40842,200543,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',17881.10,NULL,NULL,1,'2023-05-31 17:21:10','2023-05-31 17:21:10',NULL),(2478,7994,40723,200473,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1550.00,NULL,NULL,1,'2023-06-01 10:30:46','2023-06-01 10:30:46',NULL),(2479,7994,40723,200473,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',36864.99,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2480,7994,40723,200473,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',12035.12,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2481,7994,40723,200473,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',8323.33,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2482,7994,40723,200473,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',9300.00,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2483,7994,40723,200473,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',8000.00,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2484,7994,40723,200473,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',50139.99,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2485,7994,40723,200473,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',6960.00,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2486,7994,40723,200473,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',34688.53,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2487,7994,40723,200473,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',10831.50,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2488,7994,40723,200473,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',2280.42,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2489,7994,40723,200473,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',3855.00,NULL,NULL,1,'2023-06-01 10:30:47','2023-06-01 10:30:47',NULL),(2490,7994,40723,200473,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',8518.40,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL),(2491,7994,40723,200473,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',18024.29,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL),(2492,7994,40723,200473,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',1000.00,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL),(2493,7994,40723,200473,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',13000.00,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL);
INSERT INTO `balance_libro` VALUES (2494,7994,40723,200473,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',10000.00,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL),(2495,7994,40723,200473,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',10982.47,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL),(2496,7994,40723,200473,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1159.11,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL),(2497,7994,40723,200473,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',7041.61,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL),(2498,7994,40723,200473,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',43969.85,NULL,NULL,1,'2023-06-01 10:30:48','2023-06-01 10:30:48',NULL),(2499,7994,40723,200473,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25450.00,NULL,NULL,1,'2023-06-01 10:30:49','2023-06-01 10:30:49',NULL),(2500,7994,40723,200473,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',4174.50,NULL,NULL,1,'2023-06-01 10:30:49','2023-06-01 10:30:49',NULL),(2501,7994,40723,200473,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',2000.00,NULL,NULL,1,'2023-06-01 10:30:49','2023-06-01 10:30:49',NULL),(2502,7994,40723,200473,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',11824.42,NULL,NULL,1,'2023-06-01 10:30:49','2023-06-01 10:30:49',NULL),(2503,7994,40723,200473,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',29705.92,NULL,NULL,1,'2023-06-01 10:30:49','2023-06-01 10:30:49',NULL),(2504,7994,40723,200473,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',4350.12,NULL,NULL,1,'2023-06-01 10:30:49','2023-06-01 10:30:49',NULL),(2505,7994,40723,200473,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',5800.00,NULL,NULL,1,'2023-06-01 10:30:49','2023-06-01 10:30:49',NULL),(2506,7994,40723,200474,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',16400.00,NULL,NULL,1,'2023-06-01 10:32:01','2023-06-01 10:32:01',NULL),(2507,7994,40723,200474,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2911.01,NULL,NULL,1,'2023-06-01 10:32:01','2023-06-01 10:32:01',NULL),(2508,7994,40723,200474,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',30715.00,NULL,NULL,1,'2023-06-01 10:32:01','2023-06-01 10:32:01',NULL),(2509,7994,40723,200474,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1590.00,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2510,7994,40723,200474,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',2400.01,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2511,7994,40723,200474,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',7900.01,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2512,7994,40723,200474,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',3999.00,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2513,7994,40723,200474,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',9174.36,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL);
INSERT INTO `balance_libro` VALUES (2514,7994,40723,200474,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',4758.26,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2515,7994,40723,200474,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',3000.00,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2516,7994,40723,200474,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',37900.01,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2517,7994,40723,200474,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1540.00,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2518,7994,40723,200474,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',110768.24,NULL,NULL,1,'2023-06-01 10:32:02','2023-06-01 10:32:02',NULL),(2519,7994,40723,200474,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',68.00,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2520,7994,40723,200474,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',7500.00,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2521,7994,40723,200474,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',35860.00,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2522,7994,40723,200474,3,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1356.77,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2523,7994,40723,200474,3,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',187.92,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2524,7994,40723,200474,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',13846.03,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2525,7994,40723,200474,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',579.57,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2526,7994,40723,200474,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',12240.04,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2527,7994,40723,200474,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',15469.85,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2528,7994,40723,200474,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',29800.00,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2529,7994,40723,200474,3,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',20000.00,NULL,NULL,1,'2023-06-01 10:32:03','2023-06-01 10:32:03',NULL),(2530,7994,40723,200474,3,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',9360.00,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2531,7994,40723,200474,3,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',4900.50,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2532,7994,40723,200474,3,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',3400.16,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2533,7994,40723,200474,3,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',3339.00,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL);
INSERT INTO `balance_libro` VALUES (2534,7994,40723,200474,3,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1780.78,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2535,7994,40723,200474,3,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',60520.00,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2536,7994,40723,200474,3,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',4560.62,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2537,7994,40723,200474,3,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',12981.95,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2538,7994,40723,200474,3,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',12460.00,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2539,7994,40723,200474,3,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',11200.00,NULL,NULL,1,'2023-06-01 10:32:04','2023-06-01 10:32:04',NULL),(2540,7994,40723,200475,3,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',53999.00,NULL,NULL,1,'2023-06-01 10:34:10','2023-06-01 10:34:10',NULL),(2541,7994,40723,200475,3,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',2200.02,NULL,NULL,1,'2023-06-01 10:34:10','2023-06-01 10:34:10',NULL),(2542,7994,40723,200475,3,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',9889.00,NULL,NULL,1,'2023-06-01 10:34:10','2023-06-01 10:34:10',NULL),(2543,7994,40723,200475,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',14059.99,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2544,7994,40723,200475,3,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',8460.00,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2545,7994,40723,200475,3,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',16912.53,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2546,7994,40723,200475,3,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',50570.39,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2547,7994,40723,200475,3,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',308550.00,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2548,7994,40723,200475,3,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',999.80,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2549,7994,40723,200475,3,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',17160.00,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2550,7994,40723,200475,3,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',3918.69,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2551,7994,40723,200475,3,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',25914.99,NULL,NULL,1,'2023-06-01 10:34:11','2023-06-01 10:34:11',NULL),(2552,7994,40723,200475,3,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',258.00,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2553,7994,40723,200475,3,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',20000.00,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL);
INSERT INTO `balance_libro` VALUES (2554,7994,40723,200475,3,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',16960.00,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2555,7994,40723,200475,3,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',10055.40,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2556,7994,40723,200475,3,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',9859.08,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2557,7994,40723,200475,3,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',4059.72,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2558,7994,40723,200475,3,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',7560.01,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2559,7994,40723,200475,3,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1700.09,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2560,7994,40723,200475,3,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',90.00,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2561,7994,40723,200475,3,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',9000.00,NULL,NULL,1,'2023-06-01 10:34:12','2023-06-01 10:34:12',NULL),(2562,7994,40723,200475,3,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',32585.00,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2563,7994,40723,200475,3,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',6200.00,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2564,7994,40723,200475,3,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1360.76,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2565,7994,40723,200475,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',456.48,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2566,7994,40723,200475,3,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1306.61,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2567,7994,40723,200475,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',4049.99,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2568,7994,40723,200475,3,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',203.00,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2569,7994,40723,200475,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',14119.76,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2570,7994,40723,200475,3,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',470.00,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2571,7994,40723,200475,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',3788.17,NULL,NULL,1,'2023-06-01 10:34:13','2023-06-01 10:34:13',NULL),(2572,7994,40723,200475,3,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3662.09,NULL,NULL,1,'2023-06-01 10:34:14','2023-06-01 10:34:14',NULL),(2573,7994,40723,200476,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',1645.00,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2574,7994,40723,200476,3,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',27580.00,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL);
INSERT INTO `balance_libro` VALUES (2575,7994,40723,200476,3,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',12907.14,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2576,7994,40723,200476,3,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',187.92,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2577,7994,40723,200476,3,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',786.20,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2578,7994,40723,200476,3,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1210.00,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2579,7994,40723,200476,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',34007.51,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2580,7994,40723,200476,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',12906.56,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2581,7994,40723,200476,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',3310.55,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2582,7994,40723,200476,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',27000.00,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2583,7994,40723,200476,3,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',10500.00,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2584,7994,40723,200476,3,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',9900.00,NULL,NULL,1,'2023-06-01 10:39:31','2023-06-01 10:39:31',NULL),(2585,7994,40723,200476,3,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',56.38,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2586,7994,40723,200476,3,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',2699.00,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2587,7994,40723,200476,3,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',645.62,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2588,7994,40723,200476,3,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',7516.00,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2589,7994,40723,200476,3,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',1790.00,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2590,7994,40723,200476,3,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',1577.60,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2591,7994,40723,200476,3,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',3000.00,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2592,7994,40723,200476,3,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',6453.29,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2593,7994,40723,200476,3,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',4125.00,NULL,NULL,1,'2023-06-01 10:39:32','2023-06-01 10:39:32',NULL),(2594,7994,40723,200476,3,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',2870.00,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL),(2595,7994,40723,200476,3,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',95.00,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL);
INSERT INTO `balance_libro` VALUES (2596,7994,40723,200476,3,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-18','2022-05-18',326.00,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL),(2597,7994,40723,200476,3,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',36345.00,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL),(2598,7994,40723,200476,3,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',4875.09,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL),(2599,7994,40723,200476,3,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1700.00,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL),(2600,7994,40723,200476,3,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',46.85,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL),(2601,7994,40723,200476,3,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',3500.00,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL),(2602,7994,40723,200476,3,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1886.96,NULL,NULL,1,'2023-06-01 10:39:33','2023-06-01 10:39:33',NULL),(2603,7994,40723,200476,3,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',4033.29,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2604,7994,40723,200476,3,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',4691.99,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2605,7994,40723,200476,3,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',5989.50,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2606,7994,40723,200476,3,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',368.20,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2607,7994,40723,200476,3,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',2068.84,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2608,7994,40723,200476,3,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',35770.00,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2609,7994,40723,200476,3,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',4200.01,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2610,7994,40723,200476,3,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',7500.00,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2611,7994,40723,200476,3,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',10500.00,NULL,NULL,1,'2023-06-01 10:39:34','2023-06-01 10:39:34',NULL),(2612,7994,40723,200476,3,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',198.00,NULL,NULL,1,'2023-06-01 10:39:35','2023-06-01 10:39:35',NULL),(2613,7994,40723,200476,3,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',4599.31,NULL,NULL,1,'2023-06-01 10:39:35','2023-06-01 10:39:35',NULL),(2614,7994,40723,200476,3,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',4000.01,NULL,NULL,1,'2023-06-01 10:39:35','2023-06-01 10:39:35',NULL),(2615,7994,40723,200476,3,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',5915.00,NULL,NULL,1,'2023-06-01 10:39:35','2023-06-01 10:39:35',NULL),(2616,7994,40723,200476,3,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',4300.62,NULL,NULL,1,'2023-06-01 10:39:35','2023-06-01 10:39:35',NULL);
INSERT INTO `balance_libro` VALUES (2617,7994,40723,200476,3,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',4799.97,NULL,NULL,1,'2023-06-01 10:39:35','2023-06-01 10:39:35',NULL),(2618,7994,40723,200477,3,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',25778.38,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2619,7994,40723,200477,3,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',4399.99,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2620,7994,40723,200477,3,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1932.01,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2621,7994,40723,200477,3,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1291.24,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2622,7994,40723,200477,3,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',3455.66,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2623,7994,40723,200477,3,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',10000.00,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2624,7994,40723,200477,3,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',6130.00,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2625,7994,40723,200477,3,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',11480.01,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2626,7994,40723,200477,3,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',23512.72,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2627,7994,40723,200477,3,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',3768.12,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2628,7994,40723,200477,3,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',3103.49,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2629,7994,40723,200477,3,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',69519.51,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2630,7994,40723,200477,3,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',3800.00,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2631,7994,40723,200477,3,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',17000.00,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2632,7994,40723,200477,3,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',8014.00,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2633,7994,40723,200477,3,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',3001.00,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2634,7994,40723,200477,3,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',319.80,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2635,7994,40723,200477,3,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',6696.81,NULL,NULL,1,'2023-06-01 10:40:24','2023-06-01 10:40:24',NULL),(2636,7994,40723,200477,3,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',3128.18,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL);
INSERT INTO `balance_libro` VALUES (2637,7994,40723,200477,3,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',16275.87,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2638,7994,40723,200477,3,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',3966.35,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2639,7994,40723,200477,3,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',584.00,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2640,7994,40723,200477,3,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',3984.29,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2641,7994,40723,200477,3,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',6020.00,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2642,7994,40723,200477,3,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',3128.18,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2643,7994,40723,200477,3,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',21883.26,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2644,7994,40723,200477,3,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',58786.08,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2645,7994,40723,200477,3,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',0.00,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2646,7994,40723,200477,3,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',234.00,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2647,7994,40723,200477,3,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',3999.99,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2648,7994,40723,200477,3,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',645.62,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2649,7994,40723,200477,3,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',22357.69,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2650,7994,40723,200477,3,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',3000.00,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2651,7994,40723,200477,3,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',30373.98,NULL,NULL,1,'2023-06-01 10:40:25','2023-06-01 10:40:25',NULL),(2652,7994,40723,200477,3,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',10250.01,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL),(2653,7994,40723,200477,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1505.37,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL),(2654,7994,40723,200477,3,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',2430.06,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL),(2655,7994,40723,200477,3,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1049.77,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL),(2656,7994,40723,200477,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',18055.52,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL),(2657,7994,40723,200477,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',25000.00,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL);
INSERT INTO `balance_libro` VALUES (2658,7994,40723,200477,3,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',3780.00,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL),(2659,7994,40723,200477,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',7500.00,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL),(2660,7994,40723,200477,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',3000.03,NULL,NULL,1,'2023-06-01 10:40:26','2023-06-01 10:40:26',NULL),(2661,7994,40723,200477,3,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',10000.00,NULL,NULL,1,'2023-06-01 10:40:27','2023-06-01 10:40:27',NULL),(2662,7994,40723,200477,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4725.00,NULL,NULL,1,'2023-06-01 10:40:27','2023-06-01 10:40:27',NULL),(2663,7994,40723,200477,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2187.87,NULL,NULL,1,'2023-06-01 10:40:27','2023-06-01 10:40:27',NULL),(2664,7994,40723,200477,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',335.00,NULL,NULL,1,'2023-06-01 10:40:27','2023-06-01 10:40:27',NULL),(2665,7994,40723,200478,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',79815.00,NULL,NULL,1,'2023-06-01 10:42:58','2023-06-01 10:42:58',NULL),(2666,7994,40723,200478,3,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',650.00,NULL,NULL,1,'2023-06-01 10:42:58','2023-06-01 10:42:58',NULL),(2667,7994,40723,200478,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',74376.00,NULL,NULL,1,'2023-06-01 10:42:58','2023-06-01 10:42:58',NULL),(2668,7994,40723,200478,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3400.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2669,7994,40723,200478,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',3128.18,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2670,7994,40723,200478,3,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',19845.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2671,7994,40723,200478,3,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',999.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2672,7994,40723,200478,3,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',8973.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2673,7994,40723,200478,3,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',921.05,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2674,7994,40723,200478,3,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',3000.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2675,7994,40723,200478,3,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4173.97,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2676,7994,40723,200478,3,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',15000.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2677,7994,40723,200478,3,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',45495.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2678,7994,40723,200478,3,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2476.44,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL);
INSERT INTO `balance_libro` VALUES (2679,7994,40723,200478,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',60.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2680,7994,40723,200478,3,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',9547.15,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2681,7994,40723,200478,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2.28,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2682,7994,40723,200478,3,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1320.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2683,7994,40723,200478,3,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7700.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2684,7994,40723,200478,3,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7699.00,NULL,NULL,1,'2023-06-01 10:42:59','2023-06-01 10:42:59',NULL),(2685,7994,40723,200478,3,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2999.99,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2686,7994,40723,200478,3,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1100.01,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2687,7994,40723,200478,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2930.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2688,7994,40723,200478,3,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',728.93,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2689,7994,40723,200478,3,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1798.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2690,7994,40723,200478,3,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1954.98,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2691,7994,40723,200478,3,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',33000.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2692,7994,40723,200478,3,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5297.09,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2693,7994,40723,200478,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',33840.01,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2694,7994,40723,200478,3,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',326.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2695,7994,40723,200478,3,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',68.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2696,7994,40723,200478,3,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',48060.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2697,7994,40723,200478,3,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1600.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2698,7994,40723,200478,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',10880.05,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2699,7994,40723,200478,3,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',36414.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL);
INSERT INTO `balance_libro` VALUES (2700,7994,40723,200478,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',15730.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2701,7994,40723,200478,3,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',4110.01,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2702,7994,40723,200478,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5557.74,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2703,7994,40723,200478,3,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',10000.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2704,7994,40723,200478,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',41552.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2705,7994,40723,200478,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',8000.00,NULL,NULL,1,'2023-06-01 10:43:00','2023-06-01 10:43:00',NULL),(2706,7994,40723,200478,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',540.00,NULL,NULL,1,'2023-06-01 10:43:01','2023-06-01 10:43:01',NULL),(2707,7994,40723,200478,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',30817.37,NULL,NULL,1,'2023-06-01 10:43:01','2023-06-01 10:43:01',NULL),(2708,7994,40723,200478,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',9600.04,NULL,NULL,1,'2023-06-01 10:43:01','2023-06-01 10:43:01',NULL),(2709,7994,40723,200478,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3600.06,NULL,NULL,1,'2023-06-01 10:43:01','2023-06-01 10:43:01',NULL),(2710,7994,40723,200478,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',429.00,NULL,NULL,1,'2023-06-01 10:43:01','2023-06-01 10:43:01',NULL),(2711,7994,40723,200479,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',64880.01,NULL,NULL,1,'2023-06-01 10:44:42','2023-06-01 10:44:42',NULL),(2712,7994,40723,200479,3,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1551.44,NULL,NULL,1,'2023-06-01 10:44:42','2023-06-01 10:44:42',NULL),(2713,7994,40723,200479,3,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',4552.55,NULL,NULL,1,'2023-06-01 10:44:42','2023-06-01 10:44:42',NULL),(2714,7994,40723,200479,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',25039.06,NULL,NULL,1,'2023-06-01 10:44:42','2023-06-01 10:44:42',NULL),(2715,7994,40723,200479,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',14300.02,NULL,NULL,1,'2023-06-01 10:44:42','2023-06-01 10:44:42',NULL),(2716,7994,40723,200479,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',3900.00,NULL,NULL,1,'2023-06-01 10:44:42','2023-06-01 10:44:42',NULL),(2717,7994,40723,200479,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',10599.00,NULL,NULL,1,'2023-06-01 10:44:42','2023-06-01 10:44:42',NULL),(2718,7994,40723,200479,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',337832.00,NULL,NULL,1,'2023-06-01 10:44:42','2023-06-01 10:44:42',NULL),(2719,7994,40723,200479,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',5502.95,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL);
INSERT INTO `balance_libro` VALUES (2720,7994,40723,200479,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1680.01,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2721,7994,40723,200479,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',728.93,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2722,7994,40723,200479,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',33225.00,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2723,7994,40723,200479,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2800.00,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2724,7994,40723,200479,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',4000.05,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2725,7994,40723,200479,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',9840.00,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2726,7994,40723,200479,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',18120.00,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2727,7994,40723,200479,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',11439.88,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2728,7994,40723,200479,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',7562.50,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2729,7994,40723,200479,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',9189.91,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2730,7994,40723,200479,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',5056.28,NULL,NULL,1,'2023-06-01 10:44:43','2023-06-01 10:44:43',NULL),(2731,7994,40723,200479,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',42834.00,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2732,7994,40723,200479,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',6900.00,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2733,7994,40723,200479,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',5687.50,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2734,7994,40723,200479,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',55560.01,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2735,7994,40723,200479,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',13923.08,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2736,7994,40723,200479,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',2200.00,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2737,7994,40723,200479,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',204.00,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2738,7994,40723,200479,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',299.00,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2739,7994,40723,200479,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',9999.00,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2740,7994,40723,200479,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2240.00,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL);
INSERT INTO `balance_libro` VALUES (2741,7994,40723,200479,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',4376.99,NULL,NULL,1,'2023-06-01 10:44:44','2023-06-01 10:44:44',NULL),(2742,7994,40723,200479,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',4050.00,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2743,7994,40723,200479,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',2000.00,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2744,7994,40723,200479,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',22409.97,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2745,7994,40723,200479,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',67873.32,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2746,7994,40723,200479,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',2184.58,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2747,7994,40723,200479,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',6961.54,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2748,7994,40723,200479,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',149149.44,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2749,7994,40723,200479,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',123.06,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2750,7994,40723,200479,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',4508.50,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2751,7994,40723,200479,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',295.01,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2752,7994,40723,200479,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',9500.00,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2753,7994,40723,200479,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',731.82,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2754,7994,40723,200479,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',240.00,NULL,NULL,1,'2023-06-01 10:44:45','2023-06-01 10:44:45',NULL),(2755,7994,40723,200479,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',2968.63,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL),(2756,7994,40723,200479,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',18563.96,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL),(2757,7994,40723,200479,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',64279.99,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL),(2758,7994,40723,200479,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',358.04,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL),(2759,7994,40723,200479,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',2017.38,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL),(2760,7994,40723,200479,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',17695.34,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL),(2761,7994,40723,200479,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',3204.06,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL);
INSERT INTO `balance_libro` VALUES (2762,7994,40723,200479,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',7271.87,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL),(2763,7994,40723,200479,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',117.00,NULL,NULL,1,'2023-06-01 10:44:46','2023-06-01 10:44:46',NULL),(2764,7994,40723,200480,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',496.00,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2765,7994,40723,200480,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',33369.00,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2766,7994,40723,200480,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',4160.00,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2767,7994,40723,200480,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',14586.11,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2768,7994,40723,200480,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',14586.11,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2769,7994,40723,200480,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',19979.99,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2770,7994,40723,200480,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',4400.04,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2771,7994,40723,200480,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',19276.83,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2772,7994,40723,200480,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',3204.06,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2773,7994,40723,200480,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',11640.00,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2774,7994,40723,200480,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',4843.92,NULL,NULL,1,'2023-06-01 10:45:46','2023-06-01 10:45:46',NULL),(2775,7994,40723,200480,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',8923.73,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2776,7994,40723,200480,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',13920.01,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2777,7994,40723,200480,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',731.82,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2778,7994,40723,200480,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3299.00,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2779,7994,40723,200480,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',1170.00,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2780,7994,40723,200480,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',863.54,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2781,7994,40723,200480,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',5000.00,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL);
INSERT INTO `balance_libro` VALUES (2782,7994,40723,200480,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',31120.00,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2783,7994,40723,200480,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',6425.37,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2784,7994,40723,200480,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',35000.00,NULL,NULL,1,'2023-06-01 10:45:47','2023-06-01 10:45:47',NULL),(2785,7994,40723,200480,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',279.71,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2786,7994,40723,200480,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',14520.00,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2787,7994,40723,200480,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',903.37,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2788,7994,40723,200480,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',61800.00,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2789,7994,40723,200480,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',3885.69,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2790,7994,40723,200480,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',11000.00,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2791,7994,40723,200480,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',731.82,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2792,7994,40723,200480,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',79794.66,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2793,7994,40723,200480,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',13370.00,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2794,7994,40723,200480,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',476.00,NULL,NULL,1,'2023-06-01 10:45:48','2023-06-01 10:45:48',NULL),(2795,7994,40723,200480,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',299.00,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL),(2796,7994,40723,200480,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',36120.00,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL),(2797,7994,40723,200480,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',5200.01,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL),(2798,7994,40723,200480,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',31751.12,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL),(2799,7994,40723,200480,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',4184.83,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL),(2800,7994,40723,200480,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',453.38,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL),(2801,7994,40723,200480,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',882.00,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL),(2802,7994,40723,200480,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',21276.96,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL);
INSERT INTO `balance_libro` VALUES (2803,7994,40723,200480,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',21680.06,NULL,NULL,1,'2023-06-01 10:45:49','2023-06-01 10:45:49',NULL),(2804,7994,40723,200480,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',8711.30,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2805,7994,40723,200480,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1195.04,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2806,7994,40723,200480,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',50549.99,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2807,7994,40723,200480,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',13800.00,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2808,7994,40723,200480,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',7562.50,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2809,7994,40723,200480,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',32228.30,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2810,7994,40723,200480,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',120.00,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2811,7994,40723,200480,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2400.02,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2812,7994,40723,200480,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',29306.32,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2813,7994,40723,200480,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',13800.00,NULL,NULL,1,'2023-06-01 10:45:50','2023-06-01 10:45:50',NULL),(2814,7994,40723,200480,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',30000.00,NULL,NULL,1,'2023-06-01 10:45:51','2023-06-01 10:45:51',NULL),(2815,7994,40723,200480,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',25414.84,NULL,NULL,1,'2023-06-01 10:45:51','2023-06-01 10:45:51',NULL),(2816,7994,40723,200480,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',731.82,NULL,NULL,1,'2023-06-01 10:45:51','2023-06-01 10:45:51',NULL),(2817,7994,40723,200480,3,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',100.00,NULL,NULL,1,'2023-06-01 10:45:51','2023-06-01 10:45:51',NULL),(2818,7994,40723,4521,3,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',498.90,NULL,NULL,1,'2023-06-01 10:47:56','2023-06-01 10:47:56',NULL),(2819,7994,40723,4521,3,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',30250.01,NULL,NULL,1,'2023-06-01 10:47:56','2023-06-01 10:47:56',NULL),(2820,7994,40723,4521,3,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4199.81,NULL,NULL,1,'2023-06-01 10:47:56','2023-06-01 10:47:56',NULL),(2821,7994,40723,4521,3,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',83373.84,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2822,7994,40723,4521,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',16437.50,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2823,7994,40723,4521,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',18730.80,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL);
INSERT INTO `balance_libro` VALUES (2824,7994,40723,4521,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',14641.89,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2825,7994,40723,4521,3,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',3850.00,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2826,7994,40723,4521,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',37440.01,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2827,7994,40723,4521,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',3000.00,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2828,7994,40723,4521,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',33992.82,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2829,7994,40723,4521,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',4893.09,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2830,7994,40723,4521,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',19061.13,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2831,7994,40723,4521,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1700.00,NULL,NULL,1,'2023-06-01 10:47:57','2023-06-01 10:47:57',NULL),(2832,7994,40723,4521,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2325.00,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2833,7994,40723,4521,3,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9000.00,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2834,7994,40723,4521,3,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',4560.01,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2835,7994,40723,4521,3,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',888.64,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2836,7994,40723,4521,3,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',17155.04,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2837,7994,40723,4521,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',5125.96,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2838,7994,40723,4521,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',151.71,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2839,7994,40723,4521,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1590.00,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2840,7994,40723,4521,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',25579.99,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2841,7994,40723,4521,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2999.98,NULL,NULL,1,'2023-06-01 10:47:58','2023-06-01 10:47:58',NULL),(2842,7994,40723,4521,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',8539.01,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2843,7994,40723,4521,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',5525.05,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2844,7994,40723,4521,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2000.00,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL);
INSERT INTO `balance_libro` VALUES (2845,7994,40723,4521,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2846,7994,40723,4521,3,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',435.00,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2847,7994,40723,4521,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',6881.69,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2848,7994,40723,4521,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1535.01,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2849,7994,40723,4521,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2299.99,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2850,7994,40723,4521,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',29061.33,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2851,7994,40723,4521,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1259.97,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2852,7994,40723,4521,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',15000.00,NULL,NULL,1,'2023-06-01 10:47:59','2023-06-01 10:47:59',NULL),(2853,7994,40723,4521,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',30000.00,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2854,7994,40723,4521,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',7300.00,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2855,7994,40723,4521,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',32060.00,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2856,7994,40723,4521,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',4056.85,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2857,7994,40723,4521,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',200.00,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2858,7994,40723,4521,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',888.64,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2859,7994,40723,4521,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3128.55,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2860,7994,40723,4521,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5832.89,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2861,7994,40723,4521,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',89559.36,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2862,7994,40723,4521,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',234.00,NULL,NULL,1,'2023-06-01 10:48:00','2023-06-01 10:48:00',NULL),(2863,7994,40723,4522,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',65330.01,NULL,NULL,1,'2023-06-01 10:50:47','2023-06-01 10:50:47',NULL),(2864,7994,40723,4522,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',200.00,NULL,NULL,1,'2023-06-01 10:50:47','2023-06-01 10:50:47',NULL),(2865,7994,40723,4522,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',39100.00,NULL,NULL,1,'2023-06-01 10:50:47','2023-06-01 10:50:47',NULL);
INSERT INTO `balance_libro` VALUES (2866,7994,40723,4522,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',18678.63,NULL,NULL,1,'2023-06-01 10:50:47','2023-06-01 10:50:47',NULL),(2867,7994,40723,4522,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',31532.70,NULL,NULL,1,'2023-06-01 10:50:47','2023-06-01 10:50:47',NULL),(2868,7994,40723,4522,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',888.64,NULL,NULL,1,'2023-06-01 10:50:47','2023-06-01 10:50:47',NULL),(2869,7994,40723,4522,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',498.90,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2870,7994,40723,4522,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',4006.51,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2871,7994,40723,4522,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',45400.00,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2872,7994,40723,4522,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2276.33,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2873,7994,40723,4522,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4400.04,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2874,7994,40723,4522,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',486.41,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2875,7994,40723,4522,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',47990.00,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2876,7994,40723,4522,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',1200.05,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2877,7994,40723,4522,3,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3400.00,NULL,NULL,1,'2023-06-01 10:50:48','2023-06-01 10:50:48',NULL),(2878,7994,40723,4522,3,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',4152.79,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2879,7994,40723,4522,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',11000.00,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2880,7994,40723,4522,3,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1700.00,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2881,7994,40723,4522,3,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',764.74,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2882,7994,40723,4522,3,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',98099.54,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2883,7994,40723,4522,3,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',3861.66,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2884,7994,40723,4522,3,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',3000.00,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2885,7994,40723,4522,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',24862.64,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2886,7994,40723,4522,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1948.55,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL);
INSERT INTO `balance_libro` VALUES (2887,7994,40723,4522,3,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',26440.92,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2888,7994,40723,4522,3,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',14790.01,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2889,7994,40723,4522,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',14593.00,NULL,NULL,1,'2023-06-01 10:50:49','2023-06-01 10:50:49',NULL),(2890,7994,40723,4522,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2707.44,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2891,7994,40723,4522,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1210.00,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2892,7994,40723,4522,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',136.00,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2893,7994,40723,4522,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',7500.00,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2894,7994,40723,4522,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',136.00,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2895,7994,40723,4522,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',885.12,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2896,7994,40723,4522,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',117566.39,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2897,7994,40723,4522,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2999.96,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2898,7994,40723,4522,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2910.00,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2899,7994,40723,4522,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',691.04,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2900,7994,40723,4522,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',46150.02,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2901,7994,40723,4522,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',8349.99,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2902,7994,40723,4522,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',43095.21,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2903,7994,40723,4522,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1770.25,NULL,NULL,1,'2023-06-01 10:50:50','2023-06-01 10:50:50',NULL),(2904,7994,40723,4522,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',11439.99,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL),(2905,7994,40723,4522,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',320.00,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL),(2906,7994,40723,4522,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',12000.00,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL),(2907,7994,40723,4522,3,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',5903.39,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL);
INSERT INTO `balance_libro` VALUES (2908,7994,40723,4522,3,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12143.97,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL),(2909,7994,40723,4522,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',31110.01,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL),(2910,7994,40723,4522,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',15792.00,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL),(2911,7994,40723,4522,3,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',17622.69,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL),(2912,7994,40723,4522,3,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',100.00,NULL,NULL,1,'2023-06-01 10:50:51','2023-06-01 10:50:51',NULL),(2913,7994,40723,4523,3,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3190.82,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2914,7994,40723,4523,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',498.90,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2915,7994,40723,4523,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2999.00,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2916,7994,40723,4523,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',94726.01,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2917,7994,40723,4523,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3715.23,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2918,7994,40723,4523,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2085.44,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2919,7994,40723,4523,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4859.99,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2920,7994,40723,4523,3,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6250.30,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2921,7994,40723,4523,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',367114.00,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2922,7994,40723,4523,3,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',296.83,NULL,NULL,1,'2023-06-01 10:52:11','2023-06-01 10:52:11',NULL),(2923,7994,40723,4523,3,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',102583.80,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL),(2924,7994,40723,4523,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',48000.00,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL),(2925,7994,40723,4523,3,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2844.48,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL),(2926,7994,40723,4523,3,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2721.13,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL),(2927,7994,40723,4523,3,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',12143.97,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL),(2928,7994,40723,4523,3,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',116957.81,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL);
INSERT INTO `balance_libro` VALUES (2929,7994,40723,4523,3,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',23400.70,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL),(2930,7994,40723,4523,3,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2452.98,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL),(2931,7994,40723,4523,3,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3190.82,NULL,NULL,1,'2023-06-01 10:52:12','2023-06-01 10:52:12',NULL),(2932,7994,40723,4523,3,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',542.22,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2933,7994,40723,4523,3,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',20818.24,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2934,7994,40723,4523,3,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',13387.82,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2935,7994,40723,4523,3,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',20000.00,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2936,7994,40723,4523,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',20000.00,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2937,7994,40723,4523,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2186.78,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2938,7994,40723,4523,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',17797.01,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2939,7994,40723,4523,3,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',104922.25,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2940,7994,40723,4523,3,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',136.00,NULL,NULL,1,'2023-06-01 10:52:13','2023-06-01 10:52:13',NULL),(2941,7994,40723,4523,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1953.74,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL),(2942,7994,40723,4523,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',11000.00,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL),(2943,7994,40723,4523,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1020.59,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL),(2944,7994,40723,4523,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3967.94,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL),(2945,7994,40723,4523,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3267.31,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL),(2946,7994,40723,4523,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',21243.34,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL),(2947,7994,40723,4523,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',12608.38,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL),(2948,7994,40723,4523,3,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',3000.01,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL),(2949,7994,40723,4523,3,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3000.00,NULL,NULL,1,'2023-06-01 10:52:14','2023-06-01 10:52:14',NULL);
INSERT INTO `balance_libro` VALUES (2950,7994,40723,4523,3,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3315.00,NULL,NULL,1,'2023-06-01 10:52:15','2023-06-01 10:52:15',NULL),(2951,7994,40723,4523,3,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',300.00,NULL,NULL,1,'2023-06-01 10:52:15','2023-06-01 10:52:15',NULL),(2952,7994,40723,4523,3,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2186.78,NULL,NULL,1,'2023-06-01 10:52:15','2023-06-01 10:52:15',NULL),(2953,7994,40723,4523,3,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',498.90,NULL,NULL,1,'2023-06-01 10:52:15','2023-06-01 10:52:15',NULL),(2954,7994,40841,200594,3,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',603168.06,NULL,NULL,1,'2023-06-01 11:00:26','2023-06-01 11:00:26',NULL),(2955,7994,40841,200595,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',5893.77,NULL,NULL,1,'2023-06-01 11:01:30','2023-06-01 11:01:30',NULL),(2956,7994,40841,200595,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',22455.58,NULL,NULL,1,'2023-06-01 11:01:30','2023-06-01 11:01:30',NULL),(2957,7994,40841,200595,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',26435.46,NULL,NULL,1,'2023-06-01 11:01:30','2023-06-01 11:01:30',NULL),(2958,7994,40841,200595,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25004.61,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2959,7994,40841,200595,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',38998.43,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2960,7994,40841,200595,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',4151.74,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2961,7994,40841,200595,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',3345.04,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2962,7994,40841,200595,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',4752.11,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2963,7994,40841,200595,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',19876.70,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2964,7994,40841,200595,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',11081.18,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2965,7994,40841,200595,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1842.44,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2966,7994,40841,200595,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',6629.06,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2967,7994,40841,200595,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',3781.04,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2968,7994,40841,200595,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',14256.54,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2969,7994,40841,200595,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',24988.85,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2970,7994,40841,200595,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',33307.06,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL);
INSERT INTO `balance_libro` VALUES (2971,7994,40841,200595,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',3524.00,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2972,7994,40841,200595,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',3834.84,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2973,7994,40841,200595,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',17388.91,NULL,NULL,1,'2023-06-01 11:01:31','2023-06-01 11:01:31',NULL),(2974,7994,40841,200595,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',31202.36,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2975,7994,40841,200595,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',7439.90,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2976,7994,40841,200595,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',16430.36,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2977,7994,40841,200595,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1861.80,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2978,7994,40841,200595,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1179.31,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2979,7994,40841,200595,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',25714.11,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2980,7994,40841,200595,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',28028.63,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2981,7994,40841,200595,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',3515.00,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2982,7994,40841,200595,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',39829.71,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2983,7994,40841,200595,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',30166.69,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2984,7994,40841,200595,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',10057.52,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2985,7994,40841,200595,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',15588.80,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2986,7994,40841,200595,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',20392.91,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2987,7994,40841,200595,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',25714.11,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2988,7994,40841,200595,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',25714.11,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2989,7994,40841,200595,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',23214.55,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2990,7994,40841,200595,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',12257.19,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL);
INSERT INTO `balance_libro` VALUES (2991,7994,40841,200595,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',16001.43,NULL,NULL,1,'2023-06-01 11:01:32','2023-06-01 11:01:32',NULL),(2992,7994,40841,200595,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',32555.82,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(2993,7994,40841,200595,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',14289.54,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(2994,7994,40841,200595,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',13053.60,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(2995,7994,40841,200595,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',16001.43,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(2996,7994,40841,200595,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',9927.71,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(2997,7994,40841,200595,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',12314.79,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(2998,7994,40841,200595,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',6629.79,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(2999,7994,40841,200595,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',9630.79,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3000,7994,40841,200595,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',22703.89,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3001,7994,40841,200595,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',21238.99,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3002,7994,40841,200595,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',19780.87,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3003,7994,40841,200595,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',6002.81,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3004,7994,40841,200595,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',16573.44,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3005,7994,40841,200595,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',10497.23,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3006,7994,40841,200595,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',19417.98,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3007,7994,40841,200595,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1907.44,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3008,7994,40841,200595,2,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',17601.72,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3009,7994,40841,200595,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',10387.85,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL),(3010,7994,40841,200595,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',14958.59,NULL,NULL,1,'2023-06-01 11:01:33','2023-06-01 11:01:33',NULL);
INSERT INTO `balance_libro` VALUES (3011,7994,40841,200595,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1551.22,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3012,7994,40841,200595,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',36254.17,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3013,7994,40841,200595,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',3496.90,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3014,7994,40841,200595,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',6168.58,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3015,7994,40841,200595,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',3323.92,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3016,7994,40841,200595,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',6437.20,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3017,7994,40841,200595,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',3319.03,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3018,7994,40841,200595,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',1882.76,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3019,7994,40841,200595,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',2064.26,NULL,NULL,1,'2023-06-01 11:02:11','2023-06-01 11:02:11',NULL),(3020,7994,40841,200595,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',5000.02,NULL,NULL,1,'2023-06-01 11:02:12','2023-06-01 11:02:12',NULL),(3021,7994,40841,200595,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',246900.50,NULL,NULL,1,'2023-06-01 11:02:12','2023-06-01 11:02:12',NULL),(3022,7994,40841,200595,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',605592.90,NULL,NULL,1,'2023-06-01 11:02:12','2023-06-01 11:02:12',NULL),(3023,7994,40841,200595,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',77507.14,NULL,NULL,1,'2023-06-01 11:02:12','2023-06-01 11:02:12',NULL),(3024,7994,40841,200595,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',11682.27,NULL,NULL,1,'2023-06-01 11:02:12','2023-06-01 11:02:12',NULL),(3025,7994,40841,200596,2,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',28697.48,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3026,7994,40841,200596,2,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',26645.68,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3027,7994,40841,200596,2,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',14539.63,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3028,7994,40841,200596,2,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',2700.60,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3029,7994,40841,200596,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',7422.00,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3030,7994,40841,200596,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',20413.69,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL);
INSERT INTO `balance_libro` VALUES (3031,7994,40841,200596,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',10000.65,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3032,7994,40841,200596,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',2771.94,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3033,7994,40841,200596,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',18126.51,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3034,7994,40841,200596,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',4341.28,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3035,7994,40841,200596,2,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',8344.47,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3036,7994,40841,200596,2,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',14150.27,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3037,7994,40841,200596,2,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',15677.39,NULL,NULL,1,'2023-06-01 11:02:51','2023-06-01 11:02:51',NULL),(3038,7994,40841,200596,2,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',12785.79,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3039,7994,40841,200596,2,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',28848.40,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3040,7994,40841,200596,2,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',35779.70,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3041,7994,40841,200596,2,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',10993.14,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3042,7994,40841,200596,2,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',14890.42,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3043,7994,40841,200596,2,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',14931.69,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3044,7994,40841,200596,2,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',14737.24,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3045,7994,40841,200596,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',3999.18,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3046,7994,40841,200596,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',15104.28,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3047,7994,40841,200596,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',21558.61,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3048,7994,40841,200596,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',21558.61,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3049,7994,40841,200596,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',7230.52,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3050,7994,40841,200596,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',2116.81,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL);
INSERT INTO `balance_libro` VALUES (3051,7994,40841,200596,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',3024.03,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3052,7994,40841,200596,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1680.00,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3053,7994,40841,200596,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',21558.61,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3054,7994,40841,200596,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',18805.63,NULL,NULL,1,'2023-06-01 11:02:52','2023-06-01 11:02:52',NULL),(3055,7994,40841,200596,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2300.35,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3056,7994,40841,200596,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',10142.11,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3057,7994,40841,200596,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',4652.30,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3058,7994,40841,200596,2,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',3024.03,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3059,7994,40841,200596,2,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',19998.93,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3060,7994,40841,200596,2,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',27130.92,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3061,7994,40841,200596,2,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',6057.22,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3062,7994,40841,200596,2,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',29398.63,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3063,7994,40841,200596,2,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',26101.64,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3064,7994,40841,200596,2,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',37054.49,NULL,NULL,1,'2023-06-01 11:02:53','2023-06-01 11:02:53',NULL),(3065,7994,40841,200596,2,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',26679.68,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3066,7994,40841,200596,2,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',6053.37,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3067,7994,40841,200596,2,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',21946.43,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3068,7994,40841,200596,2,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',3538.11,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3069,7994,40841,200596,2,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',25277.71,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3070,7994,40841,200596,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',13908.79,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL);
INSERT INTO `balance_libro` VALUES (3071,7994,40841,200596,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',25004.31,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3072,7994,40841,200596,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',8766.17,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3073,7994,40841,200596,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',17832.76,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3074,7994,40841,200596,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',13998.91,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3075,7994,40841,200596,2,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',13364.05,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3076,7994,40841,200596,2,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',15003.65,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3077,7994,40841,200596,2,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',10002.06,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3078,7994,40841,200596,2,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1512.06,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3079,7994,40841,200596,2,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',20569.88,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3080,7994,40841,200596,2,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',4879.38,NULL,NULL,1,'2023-06-01 11:02:54','2023-06-01 11:02:54',NULL),(3081,7994,40841,200596,2,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',4321.91,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3082,7994,40841,200596,2,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',423500.00,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3083,7994,40841,200596,2,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',602156.50,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3084,7994,40841,200596,2,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',11933.62,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3085,7994,40841,200596,2,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',15522.58,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3086,7994,40841,200596,2,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',367235.00,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3087,7994,40841,200596,2,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',410419.90,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3088,7994,40841,200596,2,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',300382.50,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3089,7994,40841,200596,2,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',602156.50,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3090,7994,40841,200596,2,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',410419.90,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL);
INSERT INTO `balance_libro` VALUES (3091,7994,40841,200596,2,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',423500.00,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3092,7994,40841,200596,2,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',367235.00,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3093,7994,40841,200596,2,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',300382.50,NULL,NULL,1,'2023-06-01 11:02:55','2023-06-01 11:02:55',NULL),(3094,7994,40841,200596,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',2541.00,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3095,7994,40841,200596,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',44108.18,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3096,7994,40841,200596,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1859.77,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3097,7994,40841,200596,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',999.00,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3098,7994,40841,200596,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1123.29,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3099,7994,40841,200596,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',3100.27,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3100,7994,40841,200596,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',25835.71,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3101,7994,40841,200596,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',3100.27,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3102,7994,40841,200596,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',3872.68,NULL,NULL,1,'2023-06-01 11:03:24','2023-06-01 11:03:24',NULL),(3103,7994,40841,200596,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',150857.90,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3104,7994,40841,200596,3,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',66951.07,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3105,7994,40841,200596,3,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',27270.75,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3106,7994,40841,200596,3,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',547756.00,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3107,7994,40841,200596,3,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',73780.07,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3108,7994,40841,200596,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',3100.27,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3109,7994,40841,200596,3,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',3677.19,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3110,7994,40841,200596,3,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1256.68,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL);
INSERT INTO `balance_libro` VALUES (3111,7994,40841,200596,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',69126.14,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3112,7994,40841,200596,3,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',185.93,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3113,7994,40841,200596,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',60844.90,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3114,7994,40841,200596,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',68499.07,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3115,7994,40841,200596,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',6034.31,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3116,7994,40841,200596,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',27388.00,NULL,NULL,1,'2023-06-01 11:03:25','2023-06-01 11:03:25',NULL),(3117,7994,40841,200596,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',73589.66,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3118,7994,40841,200596,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',3956.70,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3119,7994,40841,200596,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',600082.56,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3120,7994,40841,200596,3,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',69052.81,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3121,7994,40841,200596,3,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',2765.04,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3122,7994,40841,200596,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',163954.79,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3123,7994,40841,200596,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',29957.04,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3124,7994,40841,200596,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1974.72,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3125,7994,40841,200596,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5000.01,NULL,NULL,1,'2023-06-01 11:03:26','2023-06-01 11:03:26',NULL),(3126,7994,40841,200597,2,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',7999.72,NULL,NULL,1,'2023-06-01 11:04:07','2023-06-01 11:04:07',NULL),(3127,7994,40841,200597,2,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',10210.74,NULL,NULL,1,'2023-06-01 11:04:07','2023-06-01 11:04:07',NULL),(3128,7994,40841,200597,2,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',15953.91,NULL,NULL,1,'2023-06-01 11:04:07','2023-06-01 11:04:07',NULL),(3129,7994,40841,200597,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',12513.19,NULL,NULL,1,'2023-06-01 11:04:07','2023-06-01 11:04:07',NULL),(3130,7994,40841,200597,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5168.29,NULL,NULL,1,'2023-06-01 11:04:07','2023-06-01 11:04:07',NULL);
INSERT INTO `balance_libro` VALUES (3131,7994,40841,200597,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',20751.00,NULL,NULL,1,'2023-06-01 11:04:07','2023-06-01 11:04:07',NULL),(3132,7994,40841,200597,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',24197.99,NULL,NULL,1,'2023-06-01 11:04:07','2023-06-01 11:04:07',NULL),(3133,7994,40841,200597,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',2205.10,NULL,NULL,1,'2023-06-01 11:04:07','2023-06-01 11:04:07',NULL),(3134,7994,40841,200597,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',6363.34,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3135,7994,40841,200597,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1088.65,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3136,7994,40841,200597,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',4140.78,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3137,7994,40841,200597,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',28255.59,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3138,7994,40841,200597,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',18642.33,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3139,7994,40841,200597,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',9001.32,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3140,7994,40841,200597,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3822.00,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3141,7994,40841,200597,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',12530.02,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3142,7994,40841,200597,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',21642.93,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3143,7994,40841,200597,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',7369.44,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3144,7994,40841,200597,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2141.99,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3145,7994,40841,200597,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',7369.44,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3146,7994,40841,200597,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',21506.29,NULL,NULL,1,'2023-06-01 11:04:08','2023-06-01 11:04:08',NULL),(3147,7994,40841,200597,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',21247.64,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3148,7994,40841,200597,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',4661.97,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3149,7994,40841,200597,2,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',11919.67,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3150,7994,40841,200597,2,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',25120.23,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL);
INSERT INTO `balance_libro` VALUES (3151,7994,40841,200597,2,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',22752.31,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3152,7994,40841,200597,2,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',29960.42,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3153,7994,40841,200597,2,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',30051.40,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3154,7994,40841,200597,2,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',3772.00,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3155,7994,40841,200597,2,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',3856.00,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3156,7994,40841,200597,2,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',15000.04,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3157,7994,40841,200597,2,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',29226.41,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3158,7994,40841,200597,2,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',13310.36,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3159,7994,40841,200597,2,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',16517.33,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3160,7994,40841,200597,2,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',3275.35,NULL,NULL,1,'2023-06-01 11:04:09','2023-06-01 11:04:09',NULL),(3161,7994,40841,200597,2,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',19239.69,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3162,7994,40841,200597,2,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',20471.07,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3163,7994,40841,200597,2,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',28777.92,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3164,7994,40841,200597,2,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',13419.12,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3165,7994,40841,200597,2,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',22550.26,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3166,7994,40841,200597,2,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',39196.40,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3167,7994,40841,200597,2,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',30557.75,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3168,7994,40841,200597,2,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',11473.60,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3169,7994,40841,200597,2,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',15997.12,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3170,7994,40841,200597,2,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',1280.95,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL);
INSERT INTO `balance_libro` VALUES (3171,7994,40841,200597,2,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',36184.66,NULL,NULL,1,'2023-06-01 11:04:10','2023-06-01 11:04:10',NULL),(3172,7994,40841,200597,2,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',13732.70,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3173,7994,40841,200597,2,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',21686.18,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3174,7994,40841,200597,2,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',23042.45,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3175,7994,40841,200597,2,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',17653.42,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3176,7994,40841,200597,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',6340.66,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3177,7994,40841,200597,2,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',5785.60,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3178,7994,40841,200597,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',9007.26,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3179,7994,40841,200597,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',43918.50,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3180,7994,40841,200597,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',7801.80,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3181,7994,40841,200597,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',21573.42,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3182,7994,40841,200597,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',29636.24,NULL,NULL,1,'2023-06-01 11:04:11','2023-06-01 11:04:11',NULL),(3183,7994,40841,200597,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',17653.72,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3184,7994,40841,200597,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',18133.06,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3185,7994,40841,200597,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',33918.29,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3186,7994,40841,200597,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',7801.93,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3187,7994,40841,200597,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',10000.04,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3188,7994,40841,200597,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',3712.00,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3189,7994,40841,200597,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',5248.64,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3190,7994,40841,200597,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',10650.19,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL);
INSERT INTO `balance_libro` VALUES (3191,7994,40841,200597,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',29529.66,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3192,7994,40841,200597,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',5478.88,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3193,7994,40841,200597,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',12693.20,NULL,NULL,1,'2023-06-01 11:04:12','2023-06-01 11:04:12',NULL),(3194,7994,40841,200597,2,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',18348.90,NULL,NULL,1,'2023-06-01 11:04:13','2023-06-01 11:04:13',NULL),(3195,7994,40841,200597,2,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',4508.89,NULL,NULL,1,'2023-06-01 11:04:13','2023-06-01 11:04:13',NULL),(3196,7994,40841,200597,2,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',7263.63,NULL,NULL,1,'2023-06-01 11:04:13','2023-06-01 11:04:13',NULL),(3197,7994,40841,200597,2,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',30686.49,NULL,NULL,1,'2023-06-01 11:04:13','2023-06-01 11:04:13',NULL),(3198,7994,40841,200597,2,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',15348.41,NULL,NULL,1,'2023-06-01 11:04:13','2023-06-01 11:04:13',NULL),(3199,7994,40841,200597,2,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',36691.72,NULL,NULL,1,'2023-06-01 11:04:13','2023-06-01 11:04:13',NULL),(3200,7994,40841,200597,3,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',2762.12,NULL,NULL,1,'2023-06-01 11:04:39','2023-06-01 11:04:39',NULL),(3201,7994,40841,200597,3,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',15880.72,NULL,NULL,1,'2023-06-01 11:04:39','2023-06-01 11:04:39',NULL),(3202,7994,40841,200597,3,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3176.14,NULL,NULL,1,'2023-06-01 11:04:39','2023-06-01 11:04:39',NULL),(3203,7994,40841,200597,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',15880.72,NULL,NULL,1,'2023-06-01 11:04:39','2023-06-01 11:04:39',NULL),(3204,7994,40841,200597,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',71939.54,NULL,NULL,1,'2023-06-01 11:04:39','2023-06-01 11:04:39',NULL),(3205,7994,40841,200597,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',6558.19,NULL,NULL,1,'2023-06-01 11:04:39','2023-06-01 11:04:39',NULL),(3206,7994,40841,200597,3,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',2808.50,NULL,NULL,1,'2023-06-01 11:04:39','2023-06-01 11:04:39',NULL),(3207,7994,40841,200597,3,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',2877.57,NULL,NULL,1,'2023-06-01 11:04:39','2023-06-01 11:04:39',NULL),(3208,7994,40841,200597,3,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',2151.38,NULL,NULL,1,'2023-06-01 11:04:40','2023-06-01 11:04:40',NULL),(3209,7994,40841,200597,3,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',8500.00,NULL,NULL,1,'2023-06-01 11:04:40','2023-06-01 11:04:40',NULL),(3210,7994,40841,200597,3,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',5000.00,NULL,NULL,1,'2023-06-01 11:04:40','2023-06-01 11:04:40',NULL);
INSERT INTO `balance_libro` VALUES (3211,7994,40841,200598,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',17060.21,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3212,7994,40841,200598,2,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1083.59,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3213,7994,40841,200598,2,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',9276.95,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3214,7994,40841,200598,2,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',10000.57,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3215,7994,40841,200598,2,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22489.43,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3216,7994,40841,200598,2,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',18219.97,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3217,7994,40841,200598,2,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',15000.04,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3218,7994,40841,200598,2,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5000.02,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3219,7994,40841,200598,2,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',16465.24,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3220,7994,40841,200598,2,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',15005.21,NULL,NULL,1,'2023-06-01 11:05:26','2023-06-01 11:05:26',NULL),(3221,7994,40841,200598,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',12402.50,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3222,7994,40841,200598,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',10427.27,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3223,7994,40841,200598,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1280.95,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3224,7994,40841,200598,2,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6870.03,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3225,7994,40841,200598,2,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',18690.15,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3226,7994,40841,200598,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7929.38,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3227,7994,40841,200598,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5373.38,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3228,7994,40841,200598,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',17907.12,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3229,7994,40841,200598,2,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',26573.26,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3230,7994,40841,200598,2,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',32955.00,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL);
INSERT INTO `balance_libro` VALUES (3231,7994,40841,200598,2,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',8073.12,NULL,NULL,1,'2023-06-01 11:05:27','2023-06-01 11:05:27',NULL),(3232,7994,40841,200598,2,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',11003.74,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3233,7994,40841,200598,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1968.97,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3234,7994,40841,200598,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',14004.12,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3235,7994,40841,200598,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',34981.63,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3236,7994,40841,200598,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4902.00,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3237,7994,40841,200598,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',8736.27,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3238,7994,40841,200598,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',29369.48,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3239,7994,40841,200598,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',16572.17,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3240,7994,40841,200598,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2606.94,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3241,7994,40841,200598,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',30751.25,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3242,7994,40841,200598,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',18888.88,NULL,NULL,1,'2023-06-01 11:05:28','2023-06-01 11:05:28',NULL),(3243,7994,40841,200598,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',10500.85,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL),(3244,7994,40841,200598,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',40736.40,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL),(3245,7994,40841,200598,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',23427.91,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL),(3246,7994,40841,200598,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',23873.96,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL),(3247,7994,40841,200598,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',12993.05,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL),(3248,7994,40841,200598,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',14180.52,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL),(3249,7994,40841,200598,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',22416.28,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL),(3250,7994,40841,200598,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',42673.45,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL);
INSERT INTO `balance_libro` VALUES (3251,7994,40841,200598,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',48416.35,NULL,NULL,1,'2023-06-01 11:05:29','2023-06-01 11:05:29',NULL),(3252,7994,40841,200598,2,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',21235.45,NULL,NULL,1,'2023-06-01 11:05:30','2023-06-01 11:05:30',NULL),(3253,7994,40841,200598,2,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',23147.35,NULL,NULL,1,'2023-06-01 11:05:30','2023-06-01 11:05:30',NULL),(3254,7994,40841,200598,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',34473.11,NULL,NULL,1,'2023-06-01 11:05:30','2023-06-01 11:05:30',NULL),(3255,7994,40841,200598,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',12004.41,NULL,NULL,1,'2023-06-01 11:05:30','2023-06-01 11:05:30',NULL),(3256,7994,40841,200598,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',22869.60,NULL,NULL,1,'2023-06-01 11:05:30','2023-06-01 11:05:30',NULL),(3257,7994,40841,200598,3,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1945.68,NULL,NULL,1,'2023-06-01 11:05:59','2023-06-01 11:05:59',NULL),(3258,7994,40841,200598,3,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',8500.00,NULL,NULL,1,'2023-06-01 11:05:59','2023-06-01 11:05:59',NULL),(3259,7994,40841,200598,3,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5499.99,NULL,NULL,1,'2023-06-01 11:05:59','2023-06-01 11:05:59',NULL),(3260,7994,40841,200599,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',42643.73,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3261,7994,40841,200599,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',13278.95,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3262,7994,40841,200599,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',5870.18,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3263,7994,40841,200599,2,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14000.91,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3264,7994,40841,200599,2,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',21955.00,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3265,7994,40841,200599,2,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',46582.64,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3266,7994,40841,200599,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14984.76,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3267,7994,40841,200599,2,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',27494.79,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3268,7994,40841,200599,2,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',4645.19,NULL,NULL,1,'2023-06-01 11:07:29','2023-06-01 11:07:29',NULL),(3269,7994,40841,200599,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',9928.02,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3270,7994,40841,200599,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',48475.39,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL);
INSERT INTO `balance_libro` VALUES (3271,7994,40841,200599,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',28734.98,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3272,7994,40841,200599,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',11000.74,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3273,7994,40841,200599,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',17426.03,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3274,7994,40841,200599,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',13356.91,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3275,7994,40841,200599,2,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',28069.49,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3276,7994,40841,200599,2,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',13814.80,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3277,7994,40841,200599,2,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',6000.00,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3278,7994,40841,200599,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',10001.13,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3279,7994,40841,200599,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',8022.37,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3280,7994,40841,200599,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',4577.97,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3281,7994,40841,200599,2,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',11670.22,NULL,NULL,1,'2023-06-01 11:07:30','2023-06-01 11:07:30',NULL),(3282,7994,40841,200599,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',33837.93,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL),(3283,7994,40841,200599,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',9491.99,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL),(3284,7994,40841,200599,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',18508.40,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL),(3285,7994,40841,200599,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',26150.72,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL),(3286,7994,40841,200599,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',8986.52,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL),(3287,7994,40841,200599,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',21942.37,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL),(3288,7994,40841,200599,2,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',16933.38,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL),(3289,7994,40841,200599,2,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',7851.24,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL),(3290,7994,40841,200599,2,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',25948.40,NULL,NULL,1,'2023-06-01 11:07:31','2023-06-01 11:07:31',NULL);
INSERT INTO `balance_libro` VALUES (3291,7994,40841,200599,2,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',17656.09,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3292,7994,40841,200599,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',21062.44,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3293,7994,40841,200599,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',8908.49,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3294,7994,40841,200599,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',3383.01,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3295,7994,40841,200599,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',8675.74,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3296,7994,40841,200599,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',26367.69,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3297,7994,40841,200599,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',23654.00,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3298,7994,40841,200599,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',29146.13,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3299,7994,40841,200599,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10142.99,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3300,7994,40841,200599,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',27555.06,NULL,NULL,1,'2023-06-01 11:07:32','2023-06-01 11:07:32',NULL),(3301,7994,40841,200599,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',9423.48,NULL,NULL,1,'2023-06-01 11:07:33','2023-06-01 11:07:33',NULL),(3302,7994,40841,200599,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',11234.64,NULL,NULL,1,'2023-06-01 11:07:33','2023-06-01 11:07:33',NULL),(3303,7994,40841,200599,2,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',23392.76,NULL,NULL,1,'2023-06-01 11:07:33','2023-06-01 11:07:33',NULL),(3304,7994,40841,200599,2,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',9424.83,NULL,NULL,1,'2023-06-01 11:07:33','2023-06-01 11:07:33',NULL),(3305,7994,40841,200599,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',17444.42,NULL,NULL,1,'2023-06-01 11:07:33','2023-06-01 11:07:33',NULL),(3306,7994,40841,200599,2,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',12871.25,NULL,NULL,1,'2023-06-01 11:07:33','2023-06-01 11:07:33',NULL),(3307,7994,40841,200599,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3143.58,NULL,NULL,1,'2023-06-01 11:07:33','2023-06-01 11:07:33',NULL),(3308,7994,40841,200599,3,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',300720.82,NULL,NULL,1,'2023-06-01 11:07:58','2023-06-01 11:07:58',NULL),(3309,7994,40841,200599,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',943.57,NULL,NULL,1,'2023-06-01 11:07:58','2023-06-01 11:07:58',NULL),(3310,7994,40841,200599,3,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',628.52,NULL,NULL,1,'2023-06-01 11:07:58','2023-06-01 11:07:58',NULL);
INSERT INTO `balance_libro` VALUES (3311,7994,40841,200599,3,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',9775.00,NULL,NULL,1,'2023-06-01 11:07:58','2023-06-01 11:07:58',NULL),(3312,7994,40841,200599,3,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2146.88,NULL,NULL,1,'2023-06-01 11:07:59','2023-06-01 11:07:59',NULL),(3313,7994,40841,200599,3,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2146.88,NULL,NULL,1,'2023-06-01 11:07:59','2023-06-01 11:07:59',NULL),(3314,7994,40841,200599,3,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2146.88,NULL,NULL,1,'2023-06-01 11:07:59','2023-06-01 11:07:59',NULL),(3315,7994,40841,200599,3,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',607.42,NULL,NULL,1,'2023-06-01 11:07:59','2023-06-01 11:07:59',NULL),(3316,7994,40841,200599,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',5499.99,NULL,NULL,1,'2023-06-01 11:07:59','2023-06-01 11:07:59',NULL),(3317,7994,40841,200599,3,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3999.00,NULL,NULL,1,'2023-06-01 11:07:59','2023-06-01 11:07:59',NULL),(3318,7994,40841,200600,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',7502.00,NULL,NULL,1,'2023-06-01 11:09:05','2023-06-01 11:09:05',NULL),(3319,7994,40841,200600,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',36702.55,NULL,NULL,1,'2023-06-01 11:09:05','2023-06-01 11:09:05',NULL),(3320,7994,40841,200600,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',4802.44,NULL,NULL,1,'2023-06-01 11:09:05','2023-06-01 11:09:05',NULL),(3321,7994,40841,200600,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',13128.50,NULL,NULL,1,'2023-06-01 11:09:06','2023-06-01 11:09:06',NULL),(3322,7994,40841,200600,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',38507.44,NULL,NULL,1,'2023-06-01 11:09:06','2023-06-01 11:09:06',NULL),(3323,7994,40841,200600,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',38489.32,NULL,NULL,1,'2023-06-01 11:09:06','2023-06-01 11:09:06',NULL),(3324,7994,40841,200600,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',20400.82,NULL,NULL,1,'2023-06-01 11:09:06','2023-06-01 11:09:06',NULL),(3325,7994,40841,200600,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',31234.51,NULL,NULL,1,'2023-06-01 11:09:06','2023-06-01 11:09:06',NULL),(3326,7994,40841,200600,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',3625.99,NULL,NULL,1,'2023-06-01 11:09:06','2023-06-01 11:09:06',NULL),(3327,7994,40841,200600,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',4321.15,NULL,NULL,1,'2023-06-01 11:09:06','2023-06-01 11:09:06',NULL),(3328,7994,40841,200600,2,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',15964.51,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL),(3329,7994,40841,200600,2,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',7784.99,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL),(3330,7994,40841,200600,2,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',5772.06,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL);
INSERT INTO `balance_libro` VALUES (3331,7994,40841,200600,2,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',20788.85,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL),(3332,7994,40841,200600,2,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',8634.11,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL),(3333,7994,40841,200600,2,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',28657.71,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL),(3334,7994,40841,200600,2,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',5872.20,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL),(3335,7994,40841,200600,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',28657.71,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL),(3336,7994,40841,200600,2,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',15004.00,NULL,NULL,1,'2023-06-01 11:09:07','2023-06-01 11:09:07',NULL),(3337,7994,40841,200600,2,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',8498.83,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3338,7994,40841,200600,2,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',6880.88,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3339,7994,40841,200600,2,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',15004.00,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3340,7994,40841,200600,2,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',12948.98,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3341,7994,40841,200600,2,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',27794.23,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3342,7994,40841,200600,2,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',34235.04,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3343,7994,40841,200600,2,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2078.78,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3344,7994,40841,200600,2,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',12618.66,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3345,7994,40841,200600,2,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',11537.30,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3346,7994,40841,200600,2,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',14004.54,NULL,NULL,1,'2023-06-01 11:09:08','2023-06-01 11:09:08',NULL),(3347,7994,40841,200600,2,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',16371.54,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3348,7994,40841,200600,2,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2744.35,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3349,7994,40841,200600,2,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',11066.81,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3350,7994,40841,200600,2,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',29356.10,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL);
INSERT INTO `balance_libro` VALUES (3351,7994,40841,200600,2,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',7000.50,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3352,7994,40841,200600,2,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',10370.41,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3353,7994,40841,200600,2,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',47321.69,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3354,7994,40841,200600,2,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',21976.34,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3355,7994,40841,200600,2,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',12252.70,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3356,7994,40841,200600,2,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',23403.82,NULL,NULL,1,'2023-06-01 11:09:09','2023-06-01 11:09:09',NULL),(3357,7994,40841,200600,2,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',4145.46,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3358,7994,40841,200600,2,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',5707.57,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3359,7994,40841,200600,2,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',5964.45,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3360,7994,40841,200600,2,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',8589.11,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3361,7994,40841,200600,2,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',21605.11,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3362,7994,40841,200600,2,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',9230.37,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3363,7994,40841,200600,2,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',5596.72,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3364,7994,40841,200600,2,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',43712.74,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3365,7994,40841,200600,2,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',10370.41,NULL,NULL,1,'2023-06-01 11:09:10','2023-06-01 11:09:10',NULL),(3366,7994,40841,200600,2,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',11183.22,NULL,NULL,1,'2023-06-01 11:09:11','2023-06-01 11:09:11',NULL),(3367,7994,40841,200600,2,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',5183.30,NULL,NULL,1,'2023-06-01 11:09:11','2023-06-01 11:09:11',NULL),(3368,7994,40841,200600,2,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',10294.46,NULL,NULL,1,'2023-06-01 11:09:11','2023-06-01 11:09:11',NULL),(3369,7994,40841,200600,2,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',12616.24,NULL,NULL,1,'2023-06-01 11:09:11','2023-06-01 11:09:11',NULL),(3370,7994,40841,200600,2,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',6913.60,NULL,NULL,1,'2023-06-01 11:09:11','2023-06-01 11:09:11',NULL);
INSERT INTO `balance_libro` VALUES (3371,7994,40841,200600,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',25743.35,NULL,NULL,1,'2023-06-01 11:09:11','2023-06-01 11:09:11',NULL),(3372,7994,40841,200600,2,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8781.16,NULL,NULL,1,'2023-06-01 11:09:11','2023-06-01 11:09:11',NULL),(3373,7994,40841,200600,2,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7708.69,NULL,NULL,1,'2023-06-01 11:09:11','2023-06-01 11:09:11',NULL),(3374,7994,40841,200600,3,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',4410.00,NULL,NULL,1,'2023-06-01 11:09:45','2023-06-01 11:09:45',NULL),(3375,7994,40841,200600,3,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4783.13,NULL,NULL,1,'2023-06-01 11:09:45','2023-06-01 11:09:45',NULL),(3376,7994,40841,200600,3,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1165.68,NULL,NULL,1,'2023-06-01 11:09:45','2023-06-01 11:09:45',NULL),(3377,7994,40841,200600,3,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2990.00,NULL,NULL,1,'2023-06-01 11:09:45','2023-06-01 11:09:45',NULL),(3378,7994,40841,200600,3,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',9775.00,NULL,NULL,1,'2023-06-01 11:09:45','2023-06-01 11:09:45',NULL),(3379,7994,40841,200601,2,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',47184.08,NULL,NULL,1,'2023-06-01 11:10:55','2023-06-01 11:10:55',NULL),(3380,7994,40841,200601,2,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',58674.31,NULL,NULL,1,'2023-06-01 11:10:55','2023-06-01 11:10:55',NULL),(3381,7994,40841,200601,2,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',25528.97,NULL,NULL,1,'2023-06-01 11:10:55','2023-06-01 11:10:55',NULL),(3382,7994,40841,200601,2,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',36658.52,NULL,NULL,1,'2023-06-01 11:10:55','2023-06-01 11:10:55',NULL),(3383,7994,40841,200601,2,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',16325.96,NULL,NULL,1,'2023-06-01 11:10:55','2023-06-01 11:10:55',NULL),(3384,7994,40841,200601,2,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',739.60,NULL,NULL,1,'2023-06-01 11:10:55','2023-06-01 11:10:55',NULL),(3385,7994,40841,200601,2,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',26653.81,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3386,7994,40841,200601,2,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',9636.44,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3387,7994,40841,200601,2,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7853.99,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3388,7994,40841,200601,2,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',4611.31,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3389,7994,40841,200601,2,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',19405.36,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3390,7994,40841,200601,2,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',3951.95,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL);
INSERT INTO `balance_libro` VALUES (3391,7994,40841,200601,2,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',9125.99,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3392,7994,40841,200601,2,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',11496.30,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3393,7994,40841,200601,2,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',19514.88,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3394,7994,40841,200601,2,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',8022.30,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3395,7994,40841,200601,2,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',21142.34,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3396,7994,40841,200601,2,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2538.88,NULL,NULL,1,'2023-06-01 11:10:56','2023-06-01 11:10:56',NULL),(3397,7994,40841,200601,2,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',8002.38,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3398,7994,40841,200601,2,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',37483.62,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3399,7994,40841,200601,2,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',8716.26,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3400,7994,40841,200601,2,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1329.04,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3401,7994,40841,200601,2,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',750.97,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3402,7994,40841,200601,2,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',10151.87,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3403,7994,40841,200601,2,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',27630.50,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3404,7994,40841,200601,2,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',12136.08,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3405,7994,40841,200601,2,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',24116.82,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3406,7994,40841,200601,2,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',52607.43,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3407,7994,40841,200601,2,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4802.85,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3408,7994,40841,200601,2,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',13735.71,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3409,7994,40841,200601,2,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4817.14,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3410,7994,40841,200601,2,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',11721.84,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL);
INSERT INTO `balance_libro` VALUES (3411,7994,40841,200601,2,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',33475.01,NULL,NULL,1,'2023-06-01 11:10:57','2023-06-01 11:10:57',NULL),(3412,7994,40841,200601,2,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',6500.48,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3413,7994,40841,200601,2,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',8503.32,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3414,7994,40841,200601,2,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3126.64,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3415,7994,40841,200601,2,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',7243.31,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3416,7994,40841,200601,2,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',17799.10,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3417,7994,40841,200601,2,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',25335.33,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3418,7994,40841,200601,2,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',4833.91,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3419,7994,40841,200601,2,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',11202.34,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3420,7994,40841,200601,2,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',19846.03,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3421,7994,40841,200601,2,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',39330.34,NULL,NULL,1,'2023-06-01 11:10:58','2023-06-01 11:10:58',NULL),(3422,7994,40841,200601,3,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',192453.51,NULL,NULL,1,'2023-06-01 11:11:30','2023-06-01 11:11:30',NULL),(3423,7994,40841,200601,3,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',301799.99,NULL,NULL,1,'2023-06-01 11:11:30','2023-06-01 11:11:30',NULL),(3424,7994,40841,200601,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',692883.51,NULL,NULL,1,'2023-06-01 11:11:30','2023-06-01 11:11:30',NULL),(3425,7994,40841,200601,3,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',66508.97,NULL,NULL,1,'2023-06-01 11:11:30','2023-06-01 11:11:30',NULL),(3426,7994,40841,200601,3,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',9775.00,NULL,NULL,1,'2023-06-01 11:11:30','2023-06-01 11:11:30',NULL),(3427,7994,40841,200602,2,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3449.95,NULL,NULL,1,'2023-06-01 11:12:36','2023-06-01 11:12:36',NULL),(3428,7994,40841,200602,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',11908.08,NULL,NULL,1,'2023-06-01 11:12:36','2023-06-01 11:12:36',NULL),(3429,7994,40841,200602,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',5088.17,NULL,NULL,1,'2023-06-01 11:12:36','2023-06-01 11:12:36',NULL),(3430,7994,40841,200602,2,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',17115.98,NULL,NULL,1,'2023-06-01 11:12:36','2023-06-01 11:12:36',NULL);
INSERT INTO `balance_libro` VALUES (3431,7994,40841,200602,2,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',5016.84,NULL,NULL,1,'2023-06-01 11:12:36','2023-06-01 11:12:36',NULL),(3432,7994,40841,200602,2,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',21626.01,NULL,NULL,1,'2023-06-01 11:12:36','2023-06-01 11:12:36',NULL),(3433,7994,40841,200602,2,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',25146.99,NULL,NULL,1,'2023-06-01 11:12:36','2023-06-01 11:12:36',NULL),(3434,7994,40841,200602,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',12579.33,NULL,NULL,1,'2023-06-01 11:12:36','2023-06-01 11:12:36',NULL),(3435,7994,40841,200602,2,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',32881.63,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3436,7994,40841,200602,2,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',12019.75,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3437,7994,40841,200602,2,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',12020.61,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3438,7994,40841,200602,2,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',24574.20,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3439,7994,40841,200602,2,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',59558.06,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3440,7994,40841,200602,2,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',13409.82,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3441,7994,40841,200602,2,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',14309.74,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3442,7994,40841,200602,2,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',16331.53,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3443,7994,40841,200602,2,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',8302.74,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3444,7994,40841,200602,2,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',4361.21,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3445,7994,40841,200602,2,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3593.93,NULL,NULL,1,'2023-06-01 11:12:37','2023-06-01 11:12:37',NULL),(3446,7994,40841,200602,2,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',22765.20,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3447,7994,40841,200602,2,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',32015.12,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3448,7994,40841,200602,2,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',23865.82,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3449,7994,40841,200602,2,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',12399.25,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3450,7994,40841,200602,2,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',25387.20,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL);
INSERT INTO `balance_libro` VALUES (3451,7994,40841,200602,2,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',4841.40,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3452,7994,40841,200602,2,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7863.79,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3453,7994,40841,200602,2,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',15996.15,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3454,7994,40841,200602,2,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',21279.58,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3455,7994,40841,200602,2,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',12302.71,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3456,7994,40841,200602,2,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',6388.94,NULL,NULL,1,'2023-06-01 11:12:38','2023-06-01 11:12:38',NULL),(3457,7994,40841,200602,2,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',35058.95,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3458,7994,40841,200602,2,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7000.09,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3459,7994,40841,200602,2,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',20347.49,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3460,7994,40841,200602,2,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5168.44,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3461,7994,40841,200602,2,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',45337.37,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3462,7994,40841,200602,2,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',8280.28,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3463,7994,40841,200602,2,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5394.47,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3464,7994,40841,200602,2,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',9000.97,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3465,7994,40841,200602,2,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4994.88,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3466,7994,40841,200602,2,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',42223.89,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3467,7994,40841,200602,2,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',7247.57,NULL,NULL,1,'2023-06-01 11:12:39','2023-06-01 11:12:39',NULL),(3468,7994,40841,200602,2,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',7925.74,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3469,7994,40841,200602,2,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',19502.22,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3470,7994,40841,200602,2,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',9812.25,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL);
INSERT INTO `balance_libro` VALUES (3471,7994,40841,200602,2,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',12254.49,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3472,7994,40841,200602,2,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',22154.42,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3473,7994,40841,200602,2,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',4009.96,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3474,7994,40841,200602,2,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',68278.32,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3475,7994,40841,200602,2,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',4894.98,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3476,7994,40841,200602,2,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',10328.91,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3477,7994,40841,200602,2,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',21684.13,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3478,7994,40841,200602,2,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',4756.75,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3479,7994,40841,200602,2,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',11277.22,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3480,7994,40841,200602,2,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',37994.44,NULL,NULL,1,'2023-06-01 11:12:40','2023-06-01 11:12:40',NULL),(3481,7994,40841,200602,2,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',21218.28,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3482,7994,40841,200602,2,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',40388.67,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3483,7994,40841,200602,2,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',18722.63,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3484,7994,40841,200602,2,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12003.20,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3485,7994,40841,200602,2,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',8004.15,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3486,7994,40841,200602,2,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',26470.15,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3487,7994,40841,200602,2,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',48091.11,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3488,7994,40841,200602,2,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',16365.21,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3489,7994,40841,200602,2,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',23142.18,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL),(3490,7994,40841,200602,2,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',31441.87,NULL,NULL,1,'2023-06-01 11:12:41','2023-06-01 11:12:41',NULL);
INSERT INTO `balance_libro` VALUES (3491,7994,40841,200602,2,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8603.57,NULL,NULL,1,'2023-06-01 11:12:42','2023-06-01 11:12:42',NULL),(3492,7994,40841,200602,2,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11980.45,NULL,NULL,1,'2023-06-01 11:12:42','2023-06-01 11:12:42',NULL),(3493,7994,40841,200602,2,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6737.52,NULL,NULL,1,'2023-06-01 11:12:42','2023-06-01 11:12:42',NULL),(3494,7994,40841,200602,2,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',15825.49,NULL,NULL,1,'2023-06-01 11:12:42','2023-06-01 11:12:42',NULL),(3495,7994,40841,200602,2,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4894.98,NULL,NULL,1,'2023-06-01 11:12:42','2023-06-01 11:12:42',NULL),(3496,7994,40841,200602,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3566.80,NULL,NULL,1,'2023-06-01 11:12:42','2023-06-01 11:12:42',NULL),(3497,7994,40841,200602,3,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',24038.88,NULL,NULL,1,'2023-06-01 11:13:11','2023-06-01 11:13:11',NULL),(3498,7994,40841,200602,3,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',171062.66,NULL,NULL,1,'2023-06-01 11:13:11','2023-06-01 11:13:11',NULL),(3499,7994,40841,200602,3,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',22790.51,NULL,NULL,1,'2023-06-01 11:13:11','2023-06-01 11:13:11',NULL),(3500,7994,40841,200602,3,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',227234.90,NULL,NULL,1,'2023-06-01 11:13:11','2023-06-01 11:13:11',NULL),(3501,7994,40841,200602,3,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2811.15,NULL,NULL,1,'2023-06-01 11:13:11','2023-06-01 11:13:11',NULL),(3502,7994,40841,200602,3,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',276840.39,NULL,NULL,1,'2023-06-01 11:13:11','2023-06-01 11:13:11',NULL),(3503,7994,40841,200602,3,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4887.50,NULL,NULL,1,'2023-06-01 11:13:11','2023-06-01 11:13:11',NULL),(3504,7994,40841,200602,3,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',156825.10,NULL,NULL,1,'2023-06-01 11:13:11','2023-06-01 11:13:11',NULL),(3505,7994,40841,200602,3,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',11240.00,NULL,NULL,1,'2023-06-01 11:13:12','2023-06-01 11:13:12',NULL),(3506,7994,40841,200602,3,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',3500.00,NULL,NULL,1,'2023-06-01 11:13:12','2023-06-01 11:13:12',NULL),(3507,7994,40841,200602,3,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',9089.39,NULL,NULL,1,'2023-06-01 11:13:12','2023-06-01 11:13:12',NULL),(3508,7994,40841,200602,3,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',606000.00,NULL,NULL,1,'2023-06-01 11:13:12','2023-06-01 11:13:12',NULL),(3509,7994,40841,200602,3,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',607299.00,NULL,NULL,1,'2023-06-01 11:13:12','2023-06-01 11:13:12',NULL),(3510,7994,40841,200603,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',15439.23,NULL,NULL,1,'2023-06-01 11:14:36','2023-06-01 11:14:36',NULL);
INSERT INTO `balance_libro` VALUES (3511,7994,40841,200603,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',58811.21,NULL,NULL,1,'2023-06-01 11:14:36','2023-06-01 11:14:36',NULL),(3512,7994,40841,200603,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',34370.71,NULL,NULL,1,'2023-06-01 11:14:36','2023-06-01 11:14:36',NULL),(3513,7994,40841,200603,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',21168.89,NULL,NULL,1,'2023-06-01 11:14:36','2023-06-01 11:14:36',NULL),(3514,7994,40841,200603,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',33608.21,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3515,7994,40841,200603,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',41967.40,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3516,7994,40841,200603,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',9177.22,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3517,7994,40841,200603,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',12393.33,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3518,7994,40841,200603,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',19507.39,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3519,7994,40841,200603,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',19786.38,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3520,7994,40841,200603,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',8530.86,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3521,7994,40841,200603,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',5924.16,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3522,7994,40841,200603,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',53745.76,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3523,7994,40841,200603,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',23637.70,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3524,7994,40841,200603,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',21804.37,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3525,7994,40841,200603,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2897.90,NULL,NULL,1,'2023-06-01 11:14:37','2023-06-01 11:14:37',NULL),(3526,7994,40841,200603,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',24662.81,NULL,NULL,1,'2023-06-01 11:14:38','2023-06-01 11:14:38',NULL),(3527,7994,40841,200603,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',19209.62,NULL,NULL,1,'2023-06-01 11:14:38','2023-06-01 11:14:38',NULL),(3528,7994,40841,200603,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',5061.83,NULL,NULL,1,'2023-06-01 11:14:38','2023-06-01 11:14:38',NULL),(3529,7994,40841,200603,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',5186.69,NULL,NULL,1,'2023-06-01 11:14:38','2023-06-01 11:14:38',NULL),(3530,7994,40841,200603,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',18444.02,NULL,NULL,1,'2023-06-01 11:14:38','2023-06-01 11:14:38',NULL);
INSERT INTO `balance_libro` VALUES (3531,7994,40841,200603,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',18105.78,NULL,NULL,1,'2023-06-01 11:14:38','2023-06-01 11:14:38',NULL),(3532,7994,40841,200603,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',13154.72,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3533,7994,40841,200603,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',31244.16,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3534,7994,40841,200603,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4994.88,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3535,7994,40841,200603,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',26829.70,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3536,7994,40841,200603,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',6039.41,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3537,7994,40841,200603,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',898.01,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3538,7994,40841,200603,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',9980.84,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3539,7994,40841,200603,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5186.69,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3540,7994,40841,200603,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',21005.60,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3541,7994,40841,200603,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',10244.95,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3542,7994,40841,200603,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',631.80,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3543,7994,40841,200603,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',40495.10,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3544,7994,40841,200603,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',4436.15,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3545,7994,40841,200603,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',898.01,NULL,NULL,1,'2023-06-01 11:14:39','2023-06-01 11:14:39',NULL),(3546,7994,40841,200603,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',793.64,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3547,7994,40841,200603,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',27287.02,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3548,7994,40841,200603,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',26132.46,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3549,7994,40841,200603,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',13704.93,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3550,7994,40841,200603,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',4756.82,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL);
INSERT INTO `balance_libro` VALUES (3551,7994,40841,200603,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',942.47,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3552,7994,40841,200603,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',48745.57,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3553,7994,40841,200603,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',10648.95,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3554,7994,40841,200603,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',29807.09,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3555,7994,40841,200603,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',13548.89,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3556,7994,40841,200603,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2693.99,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3557,7994,40841,200603,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',17226.09,NULL,NULL,1,'2023-06-01 11:14:40','2023-06-01 11:14:40',NULL),(3558,7994,40841,200603,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',9088.10,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3559,7994,40841,200603,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',400207.50,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3560,7994,40841,200603,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',21705.97,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3561,7994,40841,200603,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',5239.61,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3562,7994,40841,200603,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',27160.73,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3563,7994,40841,200603,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',190212.00,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3564,7994,40841,200603,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',33012.06,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3565,7994,40841,200603,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',58166.53,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3566,7994,40841,200603,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',10503.52,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3567,7994,40841,200603,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',400026.00,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3568,7994,40841,200603,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12505.13,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3569,7994,40841,200603,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',27174.83,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL),(3570,7994,40841,200603,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',26368.06,NULL,NULL,1,'2023-06-01 11:14:41','2023-06-01 11:14:41',NULL);
INSERT INTO `balance_libro` VALUES (3571,7994,40841,200603,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',429550.00,NULL,NULL,1,'2023-06-01 11:14:42','2023-06-01 11:14:42',NULL),(3572,7994,40841,200603,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',396275.00,NULL,NULL,1,'2023-06-01 11:14:42','2023-06-01 11:14:42',NULL),(3573,7994,40841,200603,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',24673.08,NULL,NULL,1,'2023-06-01 11:14:42','2023-06-01 11:14:42',NULL),(3574,7994,40841,200603,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7079.84,NULL,NULL,1,'2023-06-01 11:14:42','2023-06-01 11:14:42',NULL),(3575,7994,40841,200603,2,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',429550.00,NULL,NULL,1,'2023-06-01 11:14:42','2023-06-01 11:14:42',NULL),(3576,7994,40841,200603,3,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',56382.87,NULL,NULL,1,'2023-06-01 11:15:13','2023-06-01 11:15:13',NULL),(3577,7994,40841,200603,3,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',11240.00,NULL,NULL,1,'2023-06-01 11:15:13','2023-06-01 11:15:13',NULL),(3578,7994,40841,200603,3,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5620.00,NULL,NULL,1,'2023-06-01 11:15:13','2023-06-01 11:15:13',NULL),(3579,7994,40841,200603,3,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',35397.55,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3580,7994,40841,200603,3,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',19279.14,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3581,7994,40841,200603,3,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',303000.00,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3582,7994,40841,200603,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',292565.22,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3583,7994,40841,200603,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',526.58,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3584,7994,40841,200603,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',904882.00,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3585,7994,40841,200603,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',53938.43,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3586,7994,40841,200603,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',303000.00,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3587,7994,40841,200603,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',50263.16,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3588,7994,40841,200603,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2780.00,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3589,7994,40841,200603,3,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',45244.10,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL),(3590,7994,40841,200603,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',41222.50,NULL,NULL,1,'2023-06-01 11:15:14','2023-06-01 11:15:14',NULL);
INSERT INTO `balance_libro` VALUES (3591,7994,40841,200603,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',45244.10,NULL,NULL,1,'2023-06-01 11:15:15','2023-06-01 11:15:15',NULL),(3592,7994,40841,200603,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',80432.00,NULL,NULL,1,'2023-06-01 11:15:15','2023-06-01 11:15:15',NULL),(3593,7994,40841,200603,3,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',8487.91,NULL,NULL,1,'2023-06-01 11:15:15','2023-06-01 11:15:15',NULL),(3594,7994,40841,200603,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',19366.40,NULL,NULL,1,'2023-06-01 11:15:15','2023-06-01 11:15:15',NULL),(3595,7994,40841,200603,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',801626.21,NULL,NULL,1,'2023-06-01 11:15:15','2023-06-01 11:15:15',NULL),(4493,7994,40852,200798,2,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',19690.00,NULL,NULL,1,'2023-06-01 16:31:12','2023-06-01 16:31:12',NULL),(4494,7994,40852,200798,3,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',34145.39,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4495,7994,40852,200798,3,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',216.44,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4496,7994,40852,200798,3,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2124.75,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4497,7994,40852,200798,3,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1668.57,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4498,7994,40852,200798,3,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',7343.66,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4499,7994,40852,200798,3,4494,'App\\Models\\Receipt',4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',874.89,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4500,7994,40852,200798,3,4495,'App\\Models\\Receipt',4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',5310.00,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4501,7994,40852,200798,3,4496,'App\\Models\\Receipt',4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',7260.00,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4502,7994,40852,200798,3,4497,'App\\Models\\Receipt',4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',6103.41,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4503,7994,40852,200798,3,4498,'App\\Models\\Receipt',4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',9538.67,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4504,7994,40852,200798,3,4499,'App\\Models\\Receipt',4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',27904.51,NULL,NULL,1,'2023-06-01 16:31:55','2023-06-01 16:31:55',NULL),(4505,7994,40852,200798,3,4500,'App\\Models\\Receipt',4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',30399.99,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4506,7994,40852,200798,3,4501,'App\\Models\\Receipt',4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2261.00,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4507,7994,40852,200798,3,4502,'App\\Models\\Receipt',4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4368.33,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL);
INSERT INTO `balance_libro` VALUES (4508,7994,40852,200798,3,4503,'App\\Models\\Receipt',4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',30400.00,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4509,7994,40852,200798,3,4504,'App\\Models\\Receipt',4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',31999.00,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4510,7994,40852,200798,3,4505,'App\\Models\\Receipt',4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',45199.00,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4511,7994,40852,200798,3,4506,'App\\Models\\Receipt',4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3106.51,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4512,7994,40852,200798,3,4507,'App\\Models\\Receipt',4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',12100.00,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4513,7994,40852,200798,3,4508,'App\\Models\\Receipt',4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',17808.91,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4514,7994,40852,200798,3,4509,'App\\Models\\Receipt',4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',874.89,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4515,7994,40852,200798,3,4510,'App\\Models\\Receipt',4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',9146.74,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4516,7994,40852,200798,3,4511,'App\\Models\\Receipt',4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3323.99,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4517,7994,40852,200798,3,4512,'App\\Models\\Receipt',4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',743.87,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4518,7994,40852,200798,3,4513,'App\\Models\\Receipt',4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',18349.15,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4519,7994,40852,200798,3,4514,'App\\Models\\Receipt',4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',8444.94,NULL,NULL,1,'2023-06-01 16:31:56','2023-06-01 16:31:56',NULL),(4520,7994,40855,195880,3,4515,'App\\Models\\Receipt',4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',14165.16,NULL,NULL,1,'2023-06-01 16:35:36','2023-06-01 16:35:36',NULL),(4521,7994,40855,195880,3,4516,'App\\Models\\Receipt',4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',32341.27,NULL,NULL,1,'2023-06-01 16:35:36','2023-06-01 16:35:36',NULL),(4522,7994,40855,195880,3,4517,'App\\Models\\Receipt',4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',27672.37,NULL,NULL,1,'2023-06-01 16:35:36','2023-06-01 16:35:36',NULL),(4523,7994,40855,195880,3,4518,'App\\Models\\Receipt',4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',45592.56,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4524,7994,40855,195880,3,4519,'App\\Models\\Receipt',4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5721.82,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4525,7994,40855,195880,3,4520,'App\\Models\\Receipt',4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',225490.80,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4526,7994,40855,195880,3,4521,'App\\Models\\Receipt',4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3314.13,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4527,7994,40855,195880,3,4522,'App\\Models\\Receipt',4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',26610.88,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL);
INSERT INTO `balance_libro` VALUES (4528,7994,40855,195880,3,4523,'App\\Models\\Receipt',4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',10999.00,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4529,7994,40855,195880,3,4524,'App\\Models\\Receipt',4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',17424.00,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4530,7994,40855,195880,3,4525,'App\\Models\\Receipt',4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',15298.38,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4531,7994,40855,195880,3,4526,'App\\Models\\Receipt',4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',21539.98,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4532,7994,40855,195880,3,4527,'App\\Models\\Receipt',4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4562.48,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4533,7994,40855,195880,3,4528,'App\\Models\\Receipt',4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',7139.00,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4534,7994,40855,195880,3,4529,'App\\Models\\Receipt',4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',498.90,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4535,7994,40855,195880,3,4530,'App\\Models\\Receipt',4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',3938.37,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4536,7994,40855,195880,3,4531,'App\\Models\\Receipt',4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',29622.70,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4537,7994,40855,195880,3,4532,'App\\Models\\Receipt',4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',95523.45,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4538,7994,40855,195880,3,4533,'App\\Models\\Receipt',4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',22412.79,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4539,7994,40855,195880,3,4534,'App\\Models\\Receipt',4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',15418.74,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4540,7994,40855,195880,3,4535,'App\\Models\\Receipt',4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',28022.69,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4541,7994,40855,195880,3,4536,'App\\Models\\Receipt',4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3321.38,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4542,7994,40855,195880,3,4537,'App\\Models\\Receipt',4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3900.00,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4543,7994,40855,195880,3,4538,'App\\Models\\Receipt',4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4375.00,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4544,7994,40855,195880,3,4539,'App\\Models\\Receipt',4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3369.73,NULL,NULL,1,'2023-06-01 16:35:37','2023-06-01 16:35:37',NULL),(4545,7994,40855,195880,3,4540,'App\\Models\\Receipt',4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',4676.63,NULL,NULL,1,'2023-06-01 16:35:38','2023-06-01 16:35:38',NULL),(4546,7994,40855,195880,3,4541,'App\\Models\\Receipt',4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2489.99,NULL,NULL,1,'2023-06-01 16:35:38','2023-06-01 16:35:38',NULL),(4547,7994,40855,195880,3,4542,'App\\Models\\Receipt',4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',60.00,NULL,NULL,1,'2023-06-01 16:35:38','2023-06-01 16:35:38',NULL);
INSERT INTO `balance_libro` VALUES (4548,7994,40855,195880,3,4543,'App\\Models\\Receipt',4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',22810.26,NULL,NULL,1,'2023-06-01 16:35:38','2023-06-01 16:35:38',NULL),(4549,7994,40855,195880,3,4544,'App\\Models\\Receipt',4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',10508.80,NULL,NULL,1,'2023-06-01 16:35:38','2023-06-01 16:35:38',NULL),(4550,7994,40855,195880,3,4545,'App\\Models\\Receipt',4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',20000.00,NULL,NULL,1,'2023-06-01 16:35:38','2023-06-01 16:35:38',NULL),(4551,7994,40855,195880,3,4546,'App\\Models\\Receipt',4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3918.50,NULL,NULL,1,'2023-06-01 16:35:38','2023-06-01 16:35:38',NULL),(4552,7994,40855,195880,3,4547,'App\\Models\\Receipt',4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-06-01 16:35:38','2023-06-01 16:35:38',NULL),(4567,7994,40727,9083,3,4562,'App\\Models\\Receipt',4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',483.00,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4568,7994,40727,9083,3,4563,'App\\Models\\Receipt',4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',253.81,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4569,7994,40727,9083,3,4564,'App\\Models\\Receipt',4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',27415.89,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4570,7994,40727,9083,3,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',14366.94,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4571,7994,40727,9083,3,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',9382.30,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4572,7994,40727,9083,3,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',10537.55,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4573,7994,40727,9083,3,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',29994.50,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4574,7994,40727,9083,3,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',17425.40,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4575,7994,40727,9083,3,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',394.94,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4576,7994,40727,9083,3,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',17314.51,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4577,7994,40727,9083,3,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',8660.91,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4578,7994,40727,9083,3,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',20825.41,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4579,7994,40727,9083,3,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',10341.34,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4580,7994,40727,9083,3,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',22077.61,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4581,7994,40727,9083,3,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',103507.13,NULL,NULL,1,'2023-06-01 16:43:21','2023-06-01 16:43:21',NULL),(4582,7994,40727,9083,3,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',360.25,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL);
INSERT INTO `balance_libro` VALUES (4583,7994,40727,9083,3,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',12212.17,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4584,7994,40727,9083,3,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',559.26,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4585,7994,40727,9083,3,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',18709.31,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4586,7994,40727,9083,3,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',3000.00,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4587,7994,40727,9083,3,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',28864.80,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4588,7994,40727,9083,3,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7115.32,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4589,7994,40727,9083,3,4584,'App\\Models\\Receipt',4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',35934.10,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4590,7994,40727,9083,3,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',38917.77,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4591,7994,40727,9083,3,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',10753.45,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4592,7994,40727,9083,3,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',561.50,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4593,7994,40727,9083,3,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3767.39,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4594,7994,40727,9083,3,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',8758.19,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4595,7994,40727,9083,3,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',20334.19,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4596,7994,40727,9083,3,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',21330.07,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4597,7994,40727,9083,3,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',209999.00,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4598,7994,40727,9083,3,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',22058.77,NULL,NULL,1,'2023-06-01 16:43:22','2023-06-01 16:43:22',NULL),(4599,7994,40727,9083,3,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',18160.33,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4600,7994,40727,9083,3,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5531.86,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4601,7994,40727,9083,3,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',10576.25,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4602,7994,40727,9083,3,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',73611.51,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4603,7994,40727,9083,3,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',56303.97,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL);
INSERT INTO `balance_libro` VALUES (4604,7994,40727,9083,3,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',20224.05,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4605,7994,40727,9083,3,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',25056.32,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4606,7994,40727,9083,3,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',470.86,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4607,7994,40727,9083,3,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',3608.49,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4608,7994,40727,9083,3,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',4251.58,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4609,7994,40727,9083,3,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',250.52,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4610,7994,40727,9083,3,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',122107.15,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4611,7994,40727,9083,3,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',72326.25,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4612,7994,40727,9083,3,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',5263.87,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4613,7994,40727,9083,3,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',12201.91,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4614,7994,40727,9083,3,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',13250.94,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4615,7994,40727,9083,3,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8841.40,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4616,7994,40727,9083,3,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',28480.00,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4617,7994,40727,9083,3,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',15874.16,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4618,7994,40727,9083,3,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',57806.37,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4619,7994,40727,9083,3,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',2834.51,NULL,NULL,1,'2023-06-01 16:43:23','2023-06-01 16:43:23',NULL),(4620,7994,40727,9083,3,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',11442.15,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL),(4621,7994,40727,9083,3,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12998.16,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL),(4622,7994,40727,9083,3,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',18165.73,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL),(4623,7994,40727,9083,3,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',22449.73,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL),(4624,7994,40727,9083,3,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',7709.06,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL);
INSERT INTO `balance_libro` VALUES (4625,7994,40727,9083,3,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',11224.15,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL),(4626,7994,40727,9083,3,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',21144.94,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL),(4627,7994,40727,9083,3,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',85375.10,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL),(4628,7994,40727,9083,3,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',383.09,NULL,NULL,1,'2023-06-01 16:43:24','2023-06-01 16:43:24',NULL),(4629,7994,40727,9084,2,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',13636.70,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4630,7994,40727,9084,2,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',30250.00,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4631,7994,40727,9084,2,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',29040.00,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4632,7994,40727,9084,2,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',13310.00,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4633,7994,40727,9084,2,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6050.00,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4634,7994,40727,9084,2,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',59290.00,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4635,7994,40727,9084,2,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',10769.00,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4636,7994,40727,9084,2,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',12705.00,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4637,7994,40727,9084,2,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6900.00,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4638,7994,40727,9084,2,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1400.06,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4639,7994,40727,9084,2,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',5990.04,NULL,NULL,1,'2023-06-01 16:44:06','2023-06-01 16:44:06',NULL),(4640,7994,40727,9084,3,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',19400.06,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4641,7994,40727,9084,3,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',10900.31,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4642,7994,40727,9084,3,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',6674.80,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4643,7994,40727,9084,3,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2557.46,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4644,7994,40727,9084,3,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2612.39,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4645,7994,40727,9084,3,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',399.37,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL);
INSERT INTO `balance_libro` VALUES (4646,7994,40727,9084,3,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',51752.40,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4647,7994,40727,9084,3,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',48386.58,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4648,7994,40727,9084,3,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',10148.03,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4649,7994,40727,9084,3,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',31780.28,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4650,7994,40727,9084,3,4645,'App\\Models\\Receipt',4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4664.99,NULL,NULL,1,'2023-06-01 16:44:44','2023-06-01 16:44:44',NULL),(4651,7994,40727,9084,3,4646,'App\\Models\\Receipt',4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',166.00,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4652,7994,40727,9084,3,4647,'App\\Models\\Receipt',4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',9907.02,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4653,7994,40727,9084,3,4648,'App\\Models\\Receipt',4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',13827.21,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4654,7994,40727,9084,3,4649,'App\\Models\\Receipt',4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',17870.63,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4655,7994,40727,9084,3,4650,'App\\Models\\Receipt',4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5909.66,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4656,7994,40727,9084,3,4651,'App\\Models\\Receipt',4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',67109.02,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4657,7994,40727,9084,3,4652,'App\\Models\\Receipt',4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',15718.40,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4658,7994,40727,9084,3,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',139.23,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4659,7994,40727,9084,3,4654,'App\\Models\\Receipt',4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',107302.05,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4660,7994,40727,9084,3,4655,'App\\Models\\Receipt',4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2590.61,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4661,7994,40727,9084,3,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',24696.00,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4662,7994,40727,9084,3,4657,'App\\Models\\Receipt',4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',51738.72,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4663,7994,40727,9084,3,4658,'App\\Models\\Receipt',4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',132625.15,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4664,7994,40727,9084,3,4659,'App\\Models\\Receipt',4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',12541.40,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4665,7994,40727,9084,3,4660,'App\\Models\\Receipt',4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',12100.00,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4666,7994,40727,9084,3,4661,'App\\Models\\Receipt',4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',9376.77,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL);
INSERT INTO `balance_libro` VALUES (4667,7994,40727,9084,3,4662,'App\\Models\\Receipt',4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',36197.28,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4668,7994,40727,9084,3,4663,'App\\Models\\Receipt',4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1053.12,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4669,7994,40727,9084,3,4664,'App\\Models\\Receipt',4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',13012.34,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4670,7994,40727,9084,3,4665,'App\\Models\\Receipt',4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4672.81,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4671,7994,40727,9084,3,4666,'App\\Models\\Receipt',4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',10556.72,NULL,NULL,1,'2023-06-01 16:44:45','2023-06-01 16:44:45',NULL),(4672,7994,40727,9084,3,4667,'App\\Models\\Receipt',4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',24050.27,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4673,7994,40727,9084,3,4668,'App\\Models\\Receipt',4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',38582.35,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4674,7994,40727,9084,3,4669,'App\\Models\\Receipt',4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1251.14,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4675,7994,40727,9084,3,4670,'App\\Models\\Receipt',4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',143579.60,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4676,7994,40727,9084,3,4671,'App\\Models\\Receipt',4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',9035.35,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4677,7994,40727,9084,3,4672,'App\\Models\\Receipt',4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7767.10,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4678,7994,40727,9084,3,4673,'App\\Models\\Receipt',4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',16978.51,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4679,7994,40727,9084,3,4674,'App\\Models\\Receipt',4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',26856.30,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4680,7994,40727,9084,3,4675,'App\\Models\\Receipt',4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',66383.36,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4681,7994,40727,9084,3,4676,'App\\Models\\Receipt',4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',4068.43,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4682,7994,40727,9084,3,4677,'App\\Models\\Receipt',4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',10556.72,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4683,7994,40727,9084,3,4678,'App\\Models\\Receipt',4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',44059.86,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4684,7994,40727,9084,3,4679,'App\\Models\\Receipt',4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',13961.10,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4685,7994,40727,9084,3,4680,'App\\Models\\Receipt',4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',9277.96,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4686,7994,40727,9084,3,4681,'App\\Models\\Receipt',4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',28509.40,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4687,7994,40727,9084,3,4682,'App\\Models\\Receipt',4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',155223.98,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL);
INSERT INTO `balance_libro` VALUES (4688,7994,40727,9084,3,4683,'App\\Models\\Receipt',4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',31406.91,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4689,7994,40727,9084,3,4684,'App\\Models\\Receipt',4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1914.36,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4690,7994,40727,9084,3,4685,'App\\Models\\Receipt',4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',4539.81,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4691,7994,40727,9084,3,4686,'App\\Models\\Receipt',4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',22256.86,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4692,7994,40727,9084,3,4687,'App\\Models\\Receipt',4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',54233.00,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4693,7994,40727,9084,3,4688,'App\\Models\\Receipt',4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',12247.14,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4694,7994,40727,9084,3,4689,'App\\Models\\Receipt',4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',36240.93,NULL,NULL,1,'2023-06-01 16:44:46','2023-06-01 16:44:46',NULL),(4695,7994,40727,9084,3,4690,'App\\Models\\Receipt',4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',40751.35,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4696,7994,40727,9084,3,4691,'App\\Models\\Receipt',4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1023.09,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4697,7994,40727,9084,3,4692,'App\\Models\\Receipt',4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',25982.69,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4698,7994,40727,9084,3,4693,'App\\Models\\Receipt',4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',12990.00,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4699,7994,40727,9084,3,4694,'App\\Models\\Receipt',4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',12990.00,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4700,7994,40727,9084,3,4695,'App\\Models\\Receipt',4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',6120.00,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4701,7994,40727,9084,3,4696,'App\\Models\\Receipt',4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1166.00,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4702,7994,40727,9084,3,4697,'App\\Models\\Receipt',4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4029.30,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4703,7994,40727,9084,3,4698,'App\\Models\\Receipt',4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',13581.51,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4704,7994,40727,9084,3,4699,'App\\Models\\Receipt',4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',12559.04,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4705,7994,40727,9084,3,4700,'App\\Models\\Receipt',4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',9641.25,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4706,7994,40727,9084,3,4701,'App\\Models\\Receipt',4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',32227.77,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4707,7994,40727,9084,3,4702,'App\\Models\\Receipt',4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1796.17,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL),(4708,7994,40727,9084,3,4703,'App\\Models\\Receipt',4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2000.13,NULL,NULL,1,'2023-06-01 16:44:47','2023-06-01 16:44:47',NULL);
INSERT INTO `balance_libro` VALUES (4709,7994,40800,200961,3,4704,'App\\Models\\Receipt',4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',3010.21,NULL,NULL,1,'2023-06-01 16:51:18','2023-06-01 16:51:18',NULL),(4710,7994,40800,200961,3,4705,'App\\Models\\Receipt',4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',860.52,NULL,NULL,1,'2023-06-01 16:51:18','2023-06-01 16:51:18',NULL),(4711,7994,40800,200961,3,4706,'App\\Models\\Receipt',4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',858.56,NULL,NULL,1,'2023-06-01 16:51:18','2023-06-01 16:51:18',NULL),(4712,7994,40800,200961,3,4707,'App\\Models\\Receipt',4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',8600.00,NULL,NULL,1,'2023-06-01 16:51:18','2023-06-01 16:51:18',NULL),(4713,7994,40800,200961,3,4708,'App\\Models\\Receipt',4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7290.10,NULL,NULL,1,'2023-06-01 16:51:18','2023-06-01 16:51:18',NULL),(4714,7994,40800,200961,3,4709,'App\\Models\\Receipt',4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',4386.83,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4715,7994,40800,200961,3,4710,'App\\Models\\Receipt',4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4795.75,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4716,7994,40800,200961,3,4711,'App\\Models\\Receipt',4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',716.32,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4717,7994,40800,200961,3,4712,'App\\Models\\Receipt',4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',3632.86,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4718,7994,40800,200961,3,4713,'App\\Models\\Receipt',4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1986.55,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4719,7994,40800,200961,3,4714,'App\\Models\\Receipt',4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1660.00,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4720,7994,40800,200961,3,4715,'App\\Models\\Receipt',4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',33747.49,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4721,7994,40800,200961,3,4716,'App\\Models\\Receipt',4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',910.65,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4722,7994,40800,200961,3,4717,'App\\Models\\Receipt',4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1951.69,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4723,7994,40800,200961,3,4718,'App\\Models\\Receipt',4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',779.09,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4724,7994,40800,200961,3,4719,'App\\Models\\Receipt',4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',779.09,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4725,7994,40800,200961,3,4720,'App\\Models\\Receipt',4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3912.44,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4726,7994,40800,200961,3,4721,'App\\Models\\Receipt',4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',716.32,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4727,7994,40800,200961,3,4722,'App\\Models\\Receipt',4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',465.05,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4728,7994,40800,200961,3,4723,'App\\Models\\Receipt',4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',3788.68,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL),(4729,7994,40800,200961,3,4724,'App\\Models\\Receipt',4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2061.82,NULL,NULL,1,'2023-06-01 16:51:19','2023-06-01 16:51:19',NULL);
INSERT INTO `balance_libro` VALUES (4730,7994,40800,200961,3,4725,'App\\Models\\Receipt',4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',393.50,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4731,7994,40800,200961,3,4726,'App\\Models\\Receipt',4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',716.32,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4732,7994,40800,200961,3,4727,'App\\Models\\Receipt',4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',465.05,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4733,7994,40800,200961,3,4728,'App\\Models\\Receipt',4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1181.37,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4734,7994,40800,200961,3,4729,'App\\Models\\Receipt',4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2000.01,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4735,7994,40800,200961,3,4730,'App\\Models\\Receipt',4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',110261.25,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4736,7994,40800,200961,3,4731,'App\\Models\\Receipt',4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1800.00,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4737,7994,40800,200961,3,4732,'App\\Models\\Receipt',4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3286.48,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4738,7994,40800,200961,3,4733,'App\\Models\\Receipt',4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',18120.00,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4739,7994,40800,200961,3,4734,'App\\Models\\Receipt',4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',716.32,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4740,7994,40800,200961,3,4735,'App\\Models\\Receipt',4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1040.35,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4741,7994,40800,200961,3,4736,'App\\Models\\Receipt',4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',716.32,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4742,7994,40800,200961,3,4737,'App\\Models\\Receipt',4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',716.32,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4743,7994,40800,200961,3,4738,'App\\Models\\Receipt',4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',6210.11,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4744,7994,40800,200961,3,4739,'App\\Models\\Receipt',4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',646.84,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4745,7994,40800,200961,3,4740,'App\\Models\\Receipt',4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',646.84,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4746,7994,40800,200961,3,4741,'App\\Models\\Receipt',4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',465.05,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4747,7994,40800,200961,3,4742,'App\\Models\\Receipt',4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',835.96,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4748,7994,40800,200961,3,4743,'App\\Models\\Receipt',4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1495.41,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4749,7994,40800,200961,3,4744,'App\\Models\\Receipt',4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',716.32,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4750,7994,40800,200961,3,4745,'App\\Models\\Receipt',4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1363.16,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL);
INSERT INTO `balance_libro` VALUES (4751,7994,40800,200961,3,4746,'App\\Models\\Receipt',4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',646.84,NULL,NULL,1,'2023-06-01 16:51:20','2023-06-01 16:51:20',NULL),(4752,7994,40800,200961,3,4747,'App\\Models\\Receipt',4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',646.84,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4753,7994,40800,200961,3,4748,'App\\Models\\Receipt',4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',716.32,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4754,7994,40800,200961,3,4749,'App\\Models\\Receipt',4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1356.56,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4755,7994,40800,200961,3,4750,'App\\Models\\Receipt',4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3725.09,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4756,7994,40800,200961,3,4751,'App\\Models\\Receipt',4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',509.56,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4757,7994,40800,200961,3,4752,'App\\Models\\Receipt',4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',2934.70,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4758,7994,40800,200961,3,4753,'App\\Models\\Receipt',4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',57449.99,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4759,7994,40800,200961,3,4754,'App\\Models\\Receipt',4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1407.62,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4760,7994,40800,200961,3,4755,'App\\Models\\Receipt',4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1363.16,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4761,7994,40800,200961,3,4756,'App\\Models\\Receipt',4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',465.05,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4762,7994,40800,200961,3,4757,'App\\Models\\Receipt',4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',58533.75,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4763,7994,40800,200961,3,4758,'App\\Models\\Receipt',4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5438.03,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4764,7994,40800,200961,3,4759,'App\\Models\\Receipt',4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',10072.76,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4765,7994,40800,200961,3,4760,'App\\Models\\Receipt',4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',913.60,NULL,NULL,1,'2023-06-01 16:51:21','2023-06-01 16:51:21',NULL),(4766,7994,40800,200962,3,4761,'App\\Models\\Receipt',4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',465.05,NULL,NULL,1,'2023-06-01 16:54:00','2023-06-01 16:54:00',NULL),(4767,7994,40800,200962,3,4762,'App\\Models\\Receipt',4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',8600.00,NULL,NULL,1,'2023-06-01 16:54:00','2023-06-01 16:54:00',NULL),(4768,7994,40800,200962,3,4763,'App\\Models\\Receipt',4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',509.56,NULL,NULL,1,'2023-06-01 16:54:00','2023-06-01 16:54:00',NULL),(4769,7994,40800,200962,3,4764,'App\\Models\\Receipt',4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',646.84,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4770,7994,40800,200962,3,4765,'App\\Models\\Receipt',4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',520.59,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4771,7994,40800,200962,3,4766,'App\\Models\\Receipt',4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',9907.16,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL);
INSERT INTO `balance_libro` VALUES (4772,7994,40800,200962,3,4767,'App\\Models\\Receipt',4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',4492.37,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4773,7994,40800,200962,3,4768,'App\\Models\\Receipt',4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',646.84,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4774,7994,40800,200962,3,4769,'App\\Models\\Receipt',4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',47555.87,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4775,7994,40800,200962,3,4770,'App\\Models\\Receipt',4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',465.05,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4776,7994,40800,200962,3,4771,'App\\Models\\Receipt',4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1890.99,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4777,7994,40800,200962,3,4772,'App\\Models\\Receipt',4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3323.63,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4778,7994,40800,200962,3,4773,'App\\Models\\Receipt',4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',465.05,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4779,7994,40800,200962,3,4774,'App\\Models\\Receipt',4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1111.89,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4780,7994,40800,200962,3,4775,'App\\Models\\Receipt',4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5336.10,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4781,7994,40800,200962,3,4776,'App\\Models\\Receipt',4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',60500.60,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4782,7994,40800,200962,3,4777,'App\\Models\\Receipt',4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6094.03,NULL,NULL,1,'2023-06-01 16:54:01','2023-06-01 16:54:01',NULL),(4783,7994,40800,200962,3,4778,'App\\Models\\Receipt',4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1024.22,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4784,7994,40800,200962,3,4779,'App\\Models\\Receipt',4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',779.09,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4785,7994,40800,200962,3,4780,'App\\Models\\Receipt',4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1181.37,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4786,7994,40800,200962,3,4781,'App\\Models\\Receipt',4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',716.32,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4787,7994,40800,200962,3,4782,'App\\Models\\Receipt',4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',760.78,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4788,7994,40800,200962,3,4783,'App\\Models\\Receipt',4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',646.84,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4789,7994,40800,200962,3,4784,'App\\Models\\Receipt',4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',716.32,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4790,7994,40800,200962,3,4785,'App\\Models\\Receipt',4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',7477.11,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4791,7994,40800,200962,3,4786,'App\\Models\\Receipt',4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',1425.94,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4792,7994,40800,200962,3,4787,'App\\Models\\Receipt',4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',10800.00,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL);
INSERT INTO `balance_libro` VALUES (4793,7994,40800,200962,3,4788,'App\\Models\\Receipt',4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1495.41,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4794,7994,40800,200962,3,4789,'App\\Models\\Receipt',4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2041.89,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4795,7994,40800,200962,3,4790,'App\\Models\\Receipt',4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',760.78,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4796,7994,40800,200962,3,4791,'App\\Models\\Receipt',4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1830.00,NULL,NULL,1,'2023-06-01 16:54:02','2023-06-01 16:54:02',NULL),(4797,7994,40800,200962,3,4792,'App\\Models\\Receipt',4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1111.89,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4798,7994,40800,200962,3,4793,'App\\Models\\Receipt',4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1236.91,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4799,7994,40800,200962,3,4794,'App\\Models\\Receipt',4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',646.84,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4800,7994,40800,200962,3,4795,'App\\Models\\Receipt',4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1407.62,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4801,7994,40800,200962,3,4796,'App\\Models\\Receipt',4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',716.32,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4802,7994,40800,200962,3,4797,'App\\Models\\Receipt',4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',4561.01,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4803,7994,40800,200962,3,4798,'App\\Models\\Receipt',4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',393.50,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4804,7994,40800,200962,3,4799,'App\\Models\\Receipt',4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1211.98,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4805,7994,40800,200962,3,4800,'App\\Models\\Receipt',4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1211.98,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4806,7994,40800,200962,3,4801,'App\\Models\\Receipt',4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3497.76,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4807,7994,40800,200962,3,4802,'App\\Models\\Receipt',4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3535.23,NULL,NULL,1,'2023-06-01 16:54:03','2023-06-01 16:54:03',NULL),(4808,7994,40800,200963,3,4803,'App\\Models\\Receipt',4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1278.68,NULL,NULL,1,'2023-06-01 16:59:07','2023-06-01 16:59:07',NULL),(4809,7994,40800,200963,3,4804,'App\\Models\\Receipt',4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',8600.00,NULL,NULL,1,'2023-06-01 16:59:07','2023-06-01 16:59:07',NULL),(4810,7994,40800,200963,3,4805,'App\\Models\\Receipt',4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4284.90,NULL,NULL,1,'2023-06-01 16:59:07','2023-06-01 16:59:07',NULL),(4811,7994,40800,200963,3,4806,'App\\Models\\Receipt',4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',9139.26,NULL,NULL,1,'2023-06-01 16:59:07','2023-06-01 16:59:07',NULL),(4812,7994,40800,200963,3,4807,'App\\Models\\Receipt',4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1487.74,NULL,NULL,1,'2023-06-01 16:59:07','2023-06-01 16:59:07',NULL),(4813,7994,40800,200963,3,4808,'App\\Models\\Receipt',4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3375.34,NULL,NULL,1,'2023-06-01 16:59:07','2023-06-01 16:59:07',NULL);
INSERT INTO `balance_libro` VALUES (4814,7994,40800,200963,3,4809,'App\\Models\\Receipt',4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',84095.00,NULL,NULL,1,'2023-06-01 16:59:07','2023-06-01 16:59:07',NULL),(4815,7994,40800,200963,3,4810,'App\\Models\\Receipt',4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2368.21,NULL,NULL,1,'2023-06-01 16:59:07','2023-06-01 16:59:07',NULL),(4816,7994,40800,200963,3,4811,'App\\Models\\Receipt',4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',895.97,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4817,7994,40800,200963,3,4812,'App\\Models\\Receipt',4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',39085.16,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4818,7994,40800,200963,3,4813,'App\\Models\\Receipt',4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',11397.15,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4819,7994,40800,200963,3,4814,'App\\Models\\Receipt',4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',313.29,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4820,7994,40800,200963,3,4815,'App\\Models\\Receipt',4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',2654.25,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4821,7994,40800,200963,3,4816,'App\\Models\\Receipt',4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4455.16,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4822,7994,40800,200963,3,4817,'App\\Models\\Receipt',4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2543.17,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4823,7994,40800,200963,3,4818,'App\\Models\\Receipt',4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2511.96,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4824,7994,40800,200963,3,4819,'App\\Models\\Receipt',4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1235.66,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4825,7994,40800,200963,3,4820,'App\\Models\\Receipt',4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2663.77,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4826,7994,40800,200963,3,4821,'App\\Models\\Receipt',4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',823.77,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4827,7994,40800,200963,3,4822,'App\\Models\\Receipt',4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2463.61,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4828,7994,40800,200963,3,4823,'App\\Models\\Receipt',4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1789.58,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4829,7994,40800,200963,3,4824,'App\\Models\\Receipt',4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1789.58,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4830,7994,40800,200963,3,4825,'App\\Models\\Receipt',4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2131.63,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4831,7994,40800,200963,3,4826,'App\\Models\\Receipt',4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',10700.00,NULL,NULL,1,'2023-06-01 16:59:08','2023-06-01 16:59:08',NULL),(4832,7994,40800,200963,3,4827,'App\\Models\\Receipt',4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1235.66,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4833,7994,40800,200963,3,4828,'App\\Models\\Receipt',4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',3424.97,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4834,7994,40800,200963,3,4829,'App\\Models\\Receipt',4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1813.49,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL);
INSERT INTO `balance_libro` VALUES (4835,7994,40800,200963,3,4830,'App\\Models\\Receipt',4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1235.66,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4836,7994,40800,200963,3,4831,'App\\Models\\Receipt',4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1081.73,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4837,7994,40800,200963,3,4832,'App\\Models\\Receipt',4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',823.77,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4838,7994,40800,200963,3,4833,'App\\Models\\Receipt',4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',743.87,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4839,7994,40800,200963,3,4834,'App\\Models\\Receipt',4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',895.97,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4840,7994,40800,200963,3,4835,'App\\Models\\Receipt',4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2065.00,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4841,7994,40800,200963,3,4836,'App\\Models\\Receipt',4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2637.26,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4842,7994,40800,200963,3,4837,'App\\Models\\Receipt',4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',743.87,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4843,7994,40800,200963,3,4838,'App\\Models\\Receipt',4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2259.50,NULL,NULL,1,'2023-06-01 16:59:09','2023-06-01 16:59:09',NULL),(4851,7975,40719,23,2,4846,'App\\Models\\Receipt',4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',0.07,NULL,NULL,1,'2023-06-03 12:04:37','2023-06-03 12:04:37',NULL),(4862,7994,40727,9083,2,4859,'App\\Models\\Receipt',4859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',43000.00,NULL,NULL,1,'2023-06-07 11:45:20','2023-06-07 11:45:20',NULL),(4863,7994,40727,9083,2,4860,'App\\Models\\Receipt',4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',58000.04,NULL,NULL,1,'2023-06-07 11:45:20','2023-06-07 11:45:20',NULL),(4864,7994,40727,9083,2,4861,'App\\Models\\Receipt',4861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',58000.04,NULL,NULL,1,'2023-06-07 11:45:20','2023-06-07 11:45:20',NULL),(4865,7994,40727,9083,2,4862,'App\\Models\\Receipt',4862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',9810.00,NULL,NULL,1,'2023-06-07 11:45:20','2023-06-07 11:45:20',NULL),(4866,7994,40727,9083,2,4863,'App\\Models\\Receipt',4863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2440.00,NULL,NULL,1,'2023-06-07 11:45:20','2023-06-07 11:45:20',NULL),(4867,7994,40727,9083,2,4864,'App\\Models\\Receipt',4864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11270.00,NULL,NULL,1,'2023-06-07 11:45:20','2023-06-07 11:45:20',NULL),(4868,7994,40727,9083,2,4865,'App\\Models\\Receipt',4865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6000.00,NULL,NULL,1,'2023-06-07 11:45:20','2023-06-07 11:45:20',NULL),(4869,7994,40727,9083,2,4866,'App\\Models\\Receipt',4866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',25800.04,NULL,NULL,1,'2023-06-07 11:45:21','2023-06-07 11:45:21',NULL),(4870,7994,40727,9083,2,4867,'App\\Models\\Receipt',4867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',30000.00,NULL,NULL,1,'2023-06-07 11:45:21','2023-06-07 11:45:21',NULL),(4871,7994,40727,9083,2,4868,'App\\Models\\Receipt',4868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5000.02,NULL,NULL,1,'2023-06-07 11:45:21','2023-06-07 11:45:21',NULL),(4872,7994,40727,9083,2,4869,'App\\Models\\Receipt',4869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11500.02,NULL,NULL,1,'2023-06-07 11:45:21','2023-06-07 11:45:21',NULL);
INSERT INTO `balance_libro` VALUES (4873,7994,40727,9083,2,4870,'App\\Models\\Receipt',4870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5000.02,NULL,NULL,1,'2023-06-07 11:45:21','2023-06-07 11:45:21',NULL),(4874,7994,40727,9083,2,4871,'App\\Models\\Receipt',4871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12230.00,NULL,NULL,1,'2023-06-07 11:45:21','2023-06-07 11:45:21',NULL),(4898,7994,40800,200961,2,4895,'App\\Models\\Receipt',4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4899,7994,40800,200961,2,4896,'App\\Models\\Receipt',4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4900,7994,40800,200961,2,4897,'App\\Models\\Receipt',4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4901,7994,40800,200961,2,4898,'App\\Models\\Receipt',4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4902,7994,40800,200961,2,4899,'App\\Models\\Receipt',4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4903,7994,40800,200961,2,4900,'App\\Models\\Receipt',4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4904,7994,40800,200961,2,4901,'App\\Models\\Receipt',4901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4905,7994,40800,200961,2,4902,'App\\Models\\Receipt',4902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4906,7994,40800,200961,2,4903,'App\\Models\\Receipt',4903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4907,7994,40800,200961,2,4904,'App\\Models\\Receipt',4904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4908,7994,40800,200961,2,4905,'App\\Models\\Receipt',4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4909,7994,40800,200961,2,4906,'App\\Models\\Receipt',4906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4910,7994,40800,200961,2,4907,'App\\Models\\Receipt',4907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4911,7994,40800,200961,2,4908,'App\\Models\\Receipt',4908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4912,7994,40800,200961,2,4909,'App\\Models\\Receipt',4909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',43000.00,NULL,NULL,1,'2023-06-07 12:21:53','2023-06-07 12:21:53',NULL),(4913,7994,40800,200961,2,4910,'App\\Models\\Receipt',4910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4914,7994,40800,200961,2,4911,'App\\Models\\Receipt',4911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4915,7994,40800,200961,2,4912,'App\\Models\\Receipt',4912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL);
INSERT INTO `balance_libro` VALUES (4916,7994,40800,200961,2,4913,'App\\Models\\Receipt',4913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4917,7994,40800,200961,2,4914,'App\\Models\\Receipt',4914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',27691.95,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4918,7994,40800,200961,2,4915,'App\\Models\\Receipt',4915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4919,7994,40800,200961,2,4916,'App\\Models\\Receipt',4916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4920,7994,40800,200961,2,4917,'App\\Models\\Receipt',4917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',93389.01,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4921,7994,40800,200961,2,4918,'App\\Models\\Receipt',4918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4922,7994,40800,200961,2,4919,'App\\Models\\Receipt',4919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4923,7994,40800,200961,2,4920,'App\\Models\\Receipt',4920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4924,7994,40800,200961,2,4921,'App\\Models\\Receipt',4921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4925,7994,40800,200961,2,4922,'App\\Models\\Receipt',4922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4926,7994,40800,200961,2,4923,'App\\Models\\Receipt',4923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4927,7994,40800,200961,2,4924,'App\\Models\\Receipt',4924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4928,7994,40800,200961,2,4925,'App\\Models\\Receipt',4925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4929,7994,40800,200961,2,4926,'App\\Models\\Receipt',4926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4930,7994,40800,200961,2,4927,'App\\Models\\Receipt',4927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4931,7994,40800,200961,2,4928,'App\\Models\\Receipt',4928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',43000.00,NULL,NULL,1,'2023-06-07 12:21:54','2023-06-07 12:21:54',NULL),(4932,7994,40800,200962,2,4929,'App\\Models\\Receipt',4929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',43000.00,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4933,7994,40800,200962,2,4930,'App\\Models\\Receipt',4930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6558.11,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4934,7994,40800,200962,2,4931,'App\\Models\\Receipt',4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',21933.97,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4935,7994,40800,200962,2,4932,'App\\Models\\Receipt',4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',35000.00,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL);
INSERT INTO `balance_libro` VALUES (4936,7994,40800,200962,2,4933,'App\\Models\\Receipt',4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',569.99,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4937,7994,40800,200962,2,4934,'App\\Models\\Receipt',4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',111856.03,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4938,7994,40800,200962,2,4935,'App\\Models\\Receipt',4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',43000.00,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4939,7994,40800,200962,2,4936,'App\\Models\\Receipt',4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',43000.00,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4940,7994,40800,200962,2,4937,'App\\Models\\Receipt',4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',43000.00,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4941,7994,40800,200962,2,4938,'App\\Models\\Receipt',4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',43000.00,NULL,NULL,1,'2023-06-07 12:33:24','2023-06-07 12:33:24',NULL),(4942,7994,40800,200962,2,4939,'App\\Models\\Receipt',4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4943,7994,40800,200962,2,4940,'App\\Models\\Receipt',4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4944,7994,40800,200962,2,4941,'App\\Models\\Receipt',4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4945,7994,40800,200962,2,4942,'App\\Models\\Receipt',4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4946,7994,40800,200962,2,4943,'App\\Models\\Receipt',4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4947,7994,40800,200962,2,4944,'App\\Models\\Receipt',4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4948,7994,40800,200962,2,4945,'App\\Models\\Receipt',4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4949,7994,40800,200962,2,4946,'App\\Models\\Receipt',4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4950,7994,40800,200962,2,4947,'App\\Models\\Receipt',4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4951,7994,40800,200962,2,4948,'App\\Models\\Receipt',4948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4952,7994,40800,200962,2,4949,'App\\Models\\Receipt',4949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4953,7994,40800,200962,2,4950,'App\\Models\\Receipt',4950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',43000.00,NULL,NULL,1,'2023-06-07 12:33:25','2023-06-07 12:33:25',NULL),(4954,7994,40800,200962,2,4951,'App\\Models\\Receipt',4951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',11568.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4955,7994,40800,200962,2,4952,'App\\Models\\Receipt',4952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',43000.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL);
INSERT INTO `balance_libro` VALUES (4956,7994,40800,200962,2,4953,'App\\Models\\Receipt',4953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',43000.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4957,7994,40800,200962,2,4954,'App\\Models\\Receipt',4954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',43000.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4958,7994,40800,200962,2,4955,'App\\Models\\Receipt',4955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',11568.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4959,7994,40800,200962,2,4956,'App\\Models\\Receipt',4956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',43000.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4960,7994,40800,200962,2,4957,'App\\Models\\Receipt',4957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',43000.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4961,7994,40800,200962,2,4958,'App\\Models\\Receipt',4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',34813.56,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4962,7994,40800,200962,2,4959,'App\\Models\\Receipt',4959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',43000.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4963,7994,40800,200962,2,4960,'App\\Models\\Receipt',4960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',43000.00,NULL,NULL,1,'2023-06-07 12:33:26','2023-06-07 12:33:26',NULL),(4964,7994,40800,200963,2,4961,'App\\Models\\Receipt',4961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',30000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4965,7994,40800,200963,2,4962,'App\\Models\\Receipt',4962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',42000.04,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4966,7994,40800,200963,2,4963,'App\\Models\\Receipt',4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4967,7994,40800,200963,2,4964,'App\\Models\\Receipt',4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4968,7994,40800,200963,2,4965,'App\\Models\\Receipt',4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4969,7994,40800,200963,2,4966,'App\\Models\\Receipt',4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4970,7994,40800,200963,2,4967,'App\\Models\\Receipt',4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4971,7994,40800,200963,2,4968,'App\\Models\\Receipt',4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4972,7994,40800,200963,2,4969,'App\\Models\\Receipt',4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4973,7994,40800,200963,2,4970,'App\\Models\\Receipt',4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4974,7994,40800,200963,2,4971,'App\\Models\\Receipt',4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',43000.00,NULL,NULL,1,'2023-06-07 12:40:03','2023-06-07 12:40:03',NULL),(4975,7994,40800,200963,2,4972,'App\\Models\\Receipt',4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL);
INSERT INTO `balance_libro` VALUES (4976,7994,40800,200963,2,4973,'App\\Models\\Receipt',4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4977,7994,40800,200963,2,4974,'App\\Models\\Receipt',4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4978,7994,40800,200963,2,4975,'App\\Models\\Receipt',4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4979,7994,40800,200963,2,4976,'App\\Models\\Receipt',4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',15004.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4980,7994,40800,200963,2,4977,'App\\Models\\Receipt',4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4981,7994,40800,200963,2,4978,'App\\Models\\Receipt',4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4982,7994,40800,200963,2,4979,'App\\Models\\Receipt',4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4983,7994,40800,200963,2,4980,'App\\Models\\Receipt',4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4984,7994,40800,200963,2,4981,'App\\Models\\Receipt',4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4985,7994,40800,200963,2,4982,'App\\Models\\Receipt',4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4986,7994,40800,200963,2,4983,'App\\Models\\Receipt',4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4987,7994,40800,200963,2,4984,'App\\Models\\Receipt',4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4988,7994,40800,200963,2,4985,'App\\Models\\Receipt',4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4989,7994,40800,200963,2,4986,'App\\Models\\Receipt',4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4990,7994,40800,200963,2,4987,'App\\Models\\Receipt',4987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4991,7994,40800,200963,2,4988,'App\\Models\\Receipt',4988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4992,7994,40800,200963,2,4989,'App\\Models\\Receipt',4989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4993,7994,40800,200963,2,4990,'App\\Models\\Receipt',4990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',43000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4994,7994,40800,200963,2,4991,'App\\Models\\Receipt',4991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20000.00,NULL,NULL,1,'2023-06-07 12:40:04','2023-06-07 12:40:04',NULL),(4995,7994,40800,200963,2,4992,'App\\Models\\Receipt',4992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',24521.13,NULL,NULL,1,'2023-06-07 12:40:05','2023-06-07 12:40:05',NULL);
INSERT INTO `balance_libro` VALUES (4996,7994,40800,200963,2,4993,'App\\Models\\Receipt',4993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',43000.00,NULL,NULL,1,'2023-06-07 12:40:05','2023-06-07 12:40:05',NULL),(4997,7994,40800,200963,2,4994,'App\\Models\\Receipt',4994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',43000.00,NULL,NULL,1,'2023-06-07 12:40:05','2023-06-07 12:40:05',NULL),(4998,7994,40800,200963,2,4995,'App\\Models\\Receipt',4995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',43000.00,NULL,NULL,1,'2023-06-07 12:40:05','2023-06-07 12:40:05',NULL),(4999,7994,40800,200963,2,4996,'App\\Models\\Receipt',4996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',43000.00,NULL,NULL,1,'2023-06-07 12:40:05','2023-06-07 12:40:05',NULL),(5000,7994,40851,189815,2,4997,'App\\Models\\Receipt',4997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1.00,NULL,NULL,1,'2023-06-08 10:16:29','2024-05-29 17:40:23','2024-05-29 17:40:23'),(5001,7994,40851,189815,2,4998,'App\\Models\\Receipt',4998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1487.50,NULL,NULL,1,'2023-06-08 10:16:29','2024-05-29 17:40:23','2024-05-29 17:40:23'),(5002,7994,40851,189815,2,4999,'App\\Models\\Receipt',4999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1.00,NULL,NULL,1,'2023-06-08 10:16:29','2024-05-29 17:40:23','2024-05-29 17:40:23'),(5003,7994,40851,189815,2,5000,'App\\Models\\Receipt',5000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2750.00,NULL,NULL,1,'2023-06-08 10:16:29','2024-05-29 17:40:23','2024-05-29 17:40:23'),(5004,7994,40851,189815,2,5001,'App\\Models\\Receipt',5001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4462.50,NULL,NULL,1,'2023-06-08 10:16:29','2024-05-29 17:40:23','2024-05-29 17:40:23'),(5005,7994,40851,189815,2,5002,'App\\Models\\Receipt',5002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2805.00,NULL,NULL,1,'2023-06-08 10:16:29','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5006,7994,40851,189815,2,5003,'App\\Models\\Receipt',5003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2805.00,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5007,7994,40851,189815,2,5004,'App\\Models\\Receipt',5004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',9350.00,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5008,7994,40851,189815,2,5005,'App\\Models\\Receipt',5005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1402.50,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5009,7994,40851,189815,2,5006,'App\\Models\\Receipt',5006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2100.00,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5010,7994,40851,189815,2,5007,'App\\Models\\Receipt',5007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1870.00,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5011,7994,40851,189815,2,5008,'App\\Models\\Receipt',5008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5610.00,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5012,7994,40851,189815,2,5009,'App\\Models\\Receipt',5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2314.15,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5013,7994,40851,189815,2,5010,'App\\Models\\Receipt',5010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1615.00,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5014,7994,40851,189815,2,5011,'App\\Models\\Receipt',5011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1850.02,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24');
INSERT INTO `balance_libro` VALUES (5015,7994,40851,189815,2,5012,'App\\Models\\Receipt',5012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1300.00,NULL,NULL,1,'2023-06-08 10:16:30','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5016,7994,40851,189815,2,5013,'App\\Models\\Receipt',5013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3315.00,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:24','2024-05-29 17:40:24'),(5017,7994,40851,189815,2,5014,'App\\Models\\Receipt',5014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1300.00,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5018,7994,40851,189815,2,5015,'App\\Models\\Receipt',5015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1402.50,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5019,7994,40851,189815,2,5016,'App\\Models\\Receipt',5016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1300.04,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5020,7994,40851,189815,2,5017,'App\\Models\\Receipt',5017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3272.50,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5021,7994,40851,189815,2,5018,'App\\Models\\Receipt',5018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1232.50,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5022,7994,40851,189815,2,5019,'App\\Models\\Receipt',5019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1900.00,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5023,7994,40851,189815,2,5020,'App\\Models\\Receipt',5020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',3202.66,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5024,7994,40851,189815,2,5021,'App\\Models\\Receipt',5021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4227.50,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5025,7994,40851,189815,2,5022,'App\\Models\\Receipt',5022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',850.00,NULL,NULL,1,'2023-06-08 10:16:31','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5026,7994,40851,189815,2,5023,'App\\Models\\Receipt',5023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1350.00,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5027,7994,40851,189815,2,5024,'App\\Models\\Receipt',5024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2082.50,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5028,7994,40851,189815,2,5025,'App\\Models\\Receipt',5025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1350.00,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5029,7994,40851,189815,2,5026,'App\\Models\\Receipt',5026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1402.50,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:25','2024-05-29 17:40:25'),(5030,7994,40851,189815,2,5027,'App\\Models\\Receipt',5027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3960.22,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5031,7994,40851,189815,2,5028,'App\\Models\\Receipt',5028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1395.00,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5032,7994,40851,189815,2,5029,'App\\Models\\Receipt',5029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1350.00,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5033,7994,40851,189815,2,5030,'App\\Models\\Receipt',5030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1730.00,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:26','2024-05-29 17:40:26');
INSERT INTO `balance_libro` VALUES (5034,7994,40851,189815,2,5031,'App\\Models\\Receipt',5031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1485.00,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5035,7994,40851,189815,2,5032,'App\\Models\\Receipt',5032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2850.00,NULL,NULL,1,'2023-06-08 10:16:32','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5036,7994,40851,189815,2,5033,'App\\Models\\Receipt',5033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1485.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5037,7994,40851,189815,2,5034,'App\\Models\\Receipt',5034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1485.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5038,7994,40851,189815,2,5035,'App\\Models\\Receipt',5035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5175.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5039,7994,40851,189815,2,5036,'App\\Models\\Receipt',5036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1485.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5040,7994,40851,189815,2,5037,'App\\Models\\Receipt',5037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2750.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5041,7994,40851,189815,2,5038,'App\\Models\\Receipt',5038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3050.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5042,7994,40851,189815,2,5039,'App\\Models\\Receipt',5039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1395.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:26','2024-05-29 17:40:26'),(5043,7994,40851,189815,2,5040,'App\\Models\\Receipt',5040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',9600.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5044,7994,40851,189815,2,5041,'App\\Models\\Receipt',5041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',9500.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5045,7994,40851,189815,2,5042,'App\\Models\\Receipt',5042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2800.00,NULL,NULL,1,'2023-06-08 10:16:33','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5046,7994,40851,189815,2,5043,'App\\Models\\Receipt',5043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2160.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5047,7994,40851,189815,2,5044,'App\\Models\\Receipt',5044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1305.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5048,7994,40851,189815,2,5045,'App\\Models\\Receipt',5045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3240.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5049,7994,40851,189815,2,5046,'App\\Models\\Receipt',5046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2495.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5050,7994,40851,189815,2,5047,'App\\Models\\Receipt',5047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1590.02,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5051,7994,40851,189815,2,5048,'App\\Models\\Receipt',5048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',4115.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5052,7994,40851,189815,2,5049,'App\\Models\\Receipt',5049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1920.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27');
INSERT INTO `balance_libro` VALUES (5053,7994,40851,189815,2,5050,'App\\Models\\Receipt',5050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1485.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5054,7994,40851,189815,2,5051,'App\\Models\\Receipt',5051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1800.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5055,7994,40851,189815,2,5052,'App\\Models\\Receipt',5052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1485.00,NULL,NULL,1,'2023-06-08 10:16:34','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5056,7994,40851,189815,2,5053,'App\\Models\\Receipt',5053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1485.00,NULL,NULL,1,'2023-06-08 10:16:35','2024-05-29 17:40:27','2024-05-29 17:40:27'),(5057,7994,40851,189815,2,5054,'App\\Models\\Receipt',5054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1800.00,NULL,NULL,1,'2023-06-08 10:16:35','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5058,7994,40851,189815,2,5055,'App\\Models\\Receipt',5055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1980.00,NULL,NULL,1,'2023-06-08 10:16:35','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5059,7994,40851,189815,2,5056,'App\\Models\\Receipt',5056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1485.00,NULL,NULL,1,'2023-06-08 10:16:35','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5060,7994,40851,189815,2,5057,'App\\Models\\Receipt',5057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2600.01,NULL,NULL,1,'2023-06-08 10:16:35','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5061,7994,40851,189815,2,5058,'App\\Models\\Receipt',5058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2205.00,NULL,NULL,1,'2023-06-08 10:16:35','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5062,7994,40851,189816,2,5059,'App\\Models\\Receipt',5059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2750.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5063,7994,40851,189816,2,5060,'App\\Models\\Receipt',5060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1710.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5064,7994,40851,189816,2,5061,'App\\Models\\Receipt',5061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1485.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5065,7994,40851,189816,2,5062,'App\\Models\\Receipt',5062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4455.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5066,7994,40851,189816,2,5063,'App\\Models\\Receipt',5063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',3870.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5067,7994,40851,189816,2,5064,'App\\Models\\Receipt',5064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1305.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5068,7994,40851,189816,2,5065,'App\\Models\\Receipt',5065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2970.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5069,7994,40851,189816,2,5066,'App\\Models\\Receipt',5066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1485.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:28','2024-05-29 17:40:28'),(5070,7994,40851,189816,2,5067,'App\\Models\\Receipt',5067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1400.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5071,7994,40851,189816,2,5068,'App\\Models\\Receipt',5068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2900.07,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:29','2024-05-29 17:40:29');
INSERT INTO `balance_libro` VALUES (5072,7994,40851,189816,2,5069,'App\\Models\\Receipt',5069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',5200.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5073,7994,40851,189816,2,5070,'App\\Models\\Receipt',5070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1250.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5074,7994,40851,189816,2,5071,'App\\Models\\Receipt',5071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',6800.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5075,7994,40851,189816,2,5072,'App\\Models\\Receipt',5072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1485.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5076,7994,40851,189816,2,5073,'App\\Models\\Receipt',5073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1500.00,NULL,NULL,1,'2023-06-08 10:18:20','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5077,7994,40851,189816,2,5074,'App\\Models\\Receipt',5074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',4140.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5078,7994,40851,189816,2,5075,'App\\Models\\Receipt',5075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1250.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5079,7994,40851,189816,2,5076,'App\\Models\\Receipt',5076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',4400.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5080,7994,40851,189816,2,5077,'App\\Models\\Receipt',5077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',3000.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5081,7994,40851,189816,2,5078,'App\\Models\\Receipt',5078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',4100.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:29','2024-05-29 17:40:29'),(5082,7994,40851,189816,2,5079,'App\\Models\\Receipt',5079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',3600.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5083,7994,40851,189816,2,5080,'App\\Models\\Receipt',5080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1485.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5084,7994,40851,189816,2,5081,'App\\Models\\Receipt',5081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1500.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5085,7994,40851,189816,2,5082,'App\\Models\\Receipt',5082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1485.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5086,7994,40851,189816,2,5083,'App\\Models\\Receipt',5083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2700.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5087,7994,40851,189816,2,5084,'App\\Models\\Receipt',5084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',3780.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5088,7994,40851,189816,2,5085,'App\\Models\\Receipt',5085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',3600.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5089,7994,40851,189816,2,5086,'App\\Models\\Receipt',5086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',4185.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5090,7994,40851,189816,2,5087,'App\\Models\\Receipt',5087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1170.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30');
INSERT INTO `balance_libro` VALUES (5091,7994,40851,189816,2,5088,'App\\Models\\Receipt',5088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',5175.00,NULL,NULL,1,'2023-06-08 10:18:21','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5092,7994,40851,189816,2,5089,'App\\Models\\Receipt',5089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',4770.08,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:30','2024-05-29 17:40:30'),(5093,7994,40851,189816,2,5090,'App\\Models\\Receipt',5090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1305.00,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5094,7994,40851,189816,2,5091,'App\\Models\\Receipt',5091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1400.00,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5095,7994,40851,189816,2,5092,'App\\Models\\Receipt',5092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',5850.00,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5096,7994,40851,189816,2,5093,'App\\Models\\Receipt',5093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',1270.05,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5097,7994,40851,189816,2,5094,'App\\Models\\Receipt',5094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2790.00,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5098,7994,40851,189816,2,5095,'App\\Models\\Receipt',5095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',1935.00,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5099,7994,40851,189816,2,5096,'App\\Models\\Receipt',5096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',1305.00,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5100,7994,40851,189816,2,5097,'App\\Models\\Receipt',5097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2160.00,NULL,NULL,1,'2023-06-08 10:18:22','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5101,7994,40851,189816,2,5098,'App\\Models\\Receipt',5098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1485.00,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5102,7994,40851,189816,2,5099,'App\\Models\\Receipt',5099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',3465.00,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5103,7994,40851,189816,2,5100,'App\\Models\\Receipt',5100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2970.00,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5104,7994,40851,189816,2,5101,'App\\Models\\Receipt',5101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',810.02,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:31','2024-05-29 17:40:31'),(5105,7994,40851,189816,2,5102,'App\\Models\\Receipt',5102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2970.00,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5106,7994,40851,189816,2,5103,'App\\Models\\Receipt',5103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1230.07,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5107,7994,40851,189816,2,5104,'App\\Models\\Receipt',5104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2970.00,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5108,7994,40851,189816,2,5105,'App\\Models\\Receipt',5105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',5200.00,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5109,7994,40851,189816,2,5106,'App\\Models\\Receipt',5106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2800.00,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:32','2024-05-29 17:40:32');
INSERT INTO `balance_libro` VALUES (5110,7994,40851,189816,2,5107,'App\\Models\\Receipt',5107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1600.03,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5111,7994,40851,189816,2,5108,'App\\Models\\Receipt',5108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1500.00,NULL,NULL,1,'2023-06-08 10:18:23','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5112,7994,40851,189816,2,5109,'App\\Models\\Receipt',5109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1384.02,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5113,7994,40851,189816,2,5110,'App\\Models\\Receipt',5110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2800.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5114,7994,40851,189816,2,5111,'App\\Models\\Receipt',5111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2970.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5115,7994,40851,189816,2,5112,'App\\Models\\Receipt',5112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1650.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5116,7994,40851,189816,2,5113,'App\\Models\\Receipt',5113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2970.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:32','2024-05-29 17:40:32'),(5117,7994,40851,189816,2,5114,'App\\Models\\Receipt',5114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1700.10,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5118,7994,40851,189816,2,5115,'App\\Models\\Receipt',5115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',3690.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5119,7994,40851,189816,2,5116,'App\\Models\\Receipt',5116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1485.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5120,7994,40851,189816,2,5117,'App\\Models\\Receipt',5117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',3195.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5121,7994,40851,189816,2,5118,'App\\Models\\Receipt',5118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1485.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5122,7994,40851,189816,2,5119,'App\\Models\\Receipt',5119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1700.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5123,7994,40851,189816,2,5120,'App\\Models\\Receipt',5120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2950.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5124,7994,40851,189816,2,5121,'App\\Models\\Receipt',5121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1170.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5125,7994,40851,189816,2,5122,'App\\Models\\Receipt',5122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2800.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5126,7994,40851,189816,2,5123,'App\\Models\\Receipt',5123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',4455.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5127,7994,40851,189816,2,5124,'App\\Models\\Receipt',5124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',719.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33'),(5128,7994,40851,189816,2,5125,'App\\Models\\Receipt',5125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2610.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:33','2024-05-29 17:40:33');
INSERT INTO `balance_libro` VALUES (5129,7994,40851,189816,2,5126,'App\\Models\\Receipt',5126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1485.00,NULL,NULL,1,'2023-06-08 10:18:24','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5130,7994,40851,189816,2,5127,'App\\Models\\Receipt',5127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4500.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5131,7994,40851,189816,2,5128,'App\\Models\\Receipt',5128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1790.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5132,7994,40851,189816,2,5129,'App\\Models\\Receipt',5129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2790.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5133,7994,40851,189816,2,5130,'App\\Models\\Receipt',5130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1530.02,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5134,7994,40851,189816,2,5131,'App\\Models\\Receipt',5131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1130.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5135,7994,40851,189816,2,5132,'App\\Models\\Receipt',5132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',850.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5136,7994,40851,189816,2,5133,'App\\Models\\Receipt',5133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2680.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5137,7994,40851,189816,2,5134,'App\\Models\\Receipt',5134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3600.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5138,7994,40851,189816,2,5135,'App\\Models\\Receipt',5135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2520.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5139,7994,40851,189816,2,5136,'App\\Models\\Receipt',5136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',8550.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5140,7994,40851,189816,2,5137,'App\\Models\\Receipt',5137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1500.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5141,7994,40851,189816,2,5138,'App\\Models\\Receipt',5138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',8550.00,NULL,NULL,1,'2023-06-08 10:18:25','2024-05-29 17:40:34','2024-05-29 17:40:34'),(5142,7994,40851,189816,2,5139,'App\\Models\\Receipt',5139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1230.07,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5143,7994,40851,189816,2,5140,'App\\Models\\Receipt',5140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2610.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5144,7994,40851,189816,2,5141,'App\\Models\\Receipt',5141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2400.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5145,7994,40851,189816,2,5142,'App\\Models\\Receipt',5142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',5400.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5146,7994,40851,189816,2,5143,'App\\Models\\Receipt',5143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1620.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5147,7994,40851,189816,2,5144,'App\\Models\\Receipt',5144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',3840.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35');
INSERT INTO `balance_libro` VALUES (5148,7994,40851,189816,2,5145,'App\\Models\\Receipt',5145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',3000.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5149,7994,40851,189816,2,5146,'App\\Models\\Receipt',5146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1845.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5150,7994,40851,189816,2,5147,'App\\Models\\Receipt',5147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1485.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5151,7994,40851,189816,2,5148,'App\\Models\\Receipt',5148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1845.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5152,7994,40851,189816,2,5149,'App\\Models\\Receipt',5149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2250.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5153,7994,40851,189816,2,5150,'App\\Models\\Receipt',5150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1650.06,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5154,7994,40851,189816,2,5151,'App\\Models\\Receipt',5151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',6900.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5155,7994,40851,189816,2,5152,'App\\Models\\Receipt',5152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2800.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:35','2024-05-29 17:40:35'),(5156,7994,40851,189816,2,5153,'App\\Models\\Receipt',5153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1650.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5157,7994,40851,189816,2,5154,'App\\Models\\Receipt',5154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2385.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5158,7994,40851,189816,2,5155,'App\\Models\\Receipt',5155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',7265.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5159,7994,40851,189816,2,5156,'App\\Models\\Receipt',5156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',4770.08,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5160,7994,40851,189816,2,5157,'App\\Models\\Receipt',5157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',1620.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5161,7994,40851,189816,2,5158,'App\\Models\\Receipt',5158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',1485.00,NULL,NULL,1,'2023-06-08 10:18:26','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5162,7994,40851,189816,2,5159,'App\\Models\\Receipt',5159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',1485.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5163,7994,40851,189816,2,5160,'App\\Models\\Receipt',5160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2640.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5164,7994,40851,189816,2,5161,'App\\Models\\Receipt',5161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',1414.07,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5165,7994,40851,189816,2,5162,'App\\Models\\Receipt',5162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',3285.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5166,7994,40851,189816,2,5163,'App\\Models\\Receipt',5163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',6975.32,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:36','2024-05-29 17:40:36');
INSERT INTO `balance_libro` VALUES (5167,7994,40851,189816,2,5164,'App\\Models\\Receipt',5164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',1305.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:36','2024-05-29 17:40:36'),(5168,7994,40851,189816,2,5165,'App\\Models\\Receipt',5165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',3150.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5169,7994,40851,189816,2,5166,'App\\Models\\Receipt',5166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',4770.08,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5170,7994,40851,189816,2,5167,'App\\Models\\Receipt',5167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',3000.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5171,7994,40851,189816,2,5168,'App\\Models\\Receipt',5168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',2970.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5172,7994,40851,189816,2,5169,'App\\Models\\Receipt',5169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',1230.07,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5173,7994,40851,189816,2,5170,'App\\Models\\Receipt',5170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',1800.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5174,7994,40851,189816,2,5171,'App\\Models\\Receipt',5171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',2970.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5175,7994,40851,189816,2,5172,'App\\Models\\Receipt',5172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',1800.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5176,7994,40851,189816,2,5173,'App\\Models\\Receipt',5173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',9155.48,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5177,7994,40851,189816,2,5174,'App\\Models\\Receipt',5174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1485.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:37','2024-05-29 17:40:37'),(5178,7994,40851,189816,2,5175,'App\\Models\\Receipt',5175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1485.00,NULL,NULL,1,'2023-06-08 10:18:27','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5179,7994,40851,189816,2,5176,'App\\Models\\Receipt',5176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1485.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5180,7994,40851,189816,2,5177,'App\\Models\\Receipt',5177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1300.04,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5181,7994,40851,189816,2,5178,'App\\Models\\Receipt',5178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2970.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5182,7994,40851,189816,2,5179,'App\\Models\\Receipt',5179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',3050.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5183,7994,40851,189816,2,5180,'App\\Models\\Receipt',5180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',3850.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5184,7994,40851,189816,2,5181,'App\\Models\\Receipt',5181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',5445.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5185,7994,40851,189816,2,5182,'App\\Models\\Receipt',5182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2200.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38');
INSERT INTO `balance_libro` VALUES (5186,7994,40851,189816,2,5183,'App\\Models\\Receipt',5183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2240.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5187,7994,40851,189816,2,5184,'App\\Models\\Receipt',5184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2250.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:38','2024-05-29 17:40:38'),(5188,7994,40851,189816,2,5185,'App\\Models\\Receipt',5185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',5175.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5189,7994,40851,189816,2,5186,'App\\Models\\Receipt',5186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',3150.00,NULL,NULL,1,'2023-06-08 10:18:28','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5190,7994,40851,189816,2,5187,'App\\Models\\Receipt',5187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2565.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5191,7994,40851,189816,2,5188,'App\\Models\\Receipt',5188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1800.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5192,7994,40851,189816,2,5189,'App\\Models\\Receipt',5189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',6300.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5193,7994,40851,189816,2,5190,'App\\Models\\Receipt',5190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',3735.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5194,7994,40851,189816,2,5191,'App\\Models\\Receipt',5191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1777.50,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5195,7994,40851,189816,2,5192,'App\\Models\\Receipt',5192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2540.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5196,7994,40851,189816,2,5193,'App\\Models\\Receipt',5193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',2550.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5197,7994,40851,189816,2,5194,'App\\Models\\Receipt',5194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',3150.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:39','2024-05-29 17:40:39'),(5198,7994,40851,189816,2,5195,'App\\Models\\Receipt',5195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1330.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5199,7994,40851,189816,2,5196,'App\\Models\\Receipt',5196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1575.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5200,7994,40851,189816,2,5197,'App\\Models\\Receipt',5197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',3150.00,NULL,NULL,1,'2023-06-08 10:18:29','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5201,7994,40851,189816,2,5198,'App\\Models\\Receipt',5198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1509.03,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5202,7994,40851,189816,2,5199,'App\\Models\\Receipt',5199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3500.00,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5203,7994,40851,189816,2,5200,'App\\Models\\Receipt',5200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2440.01,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5204,7994,40851,189816,2,5201,'App\\Models\\Receipt',5201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3000.00,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:40','2024-05-29 17:40:40');
INSERT INTO `balance_libro` VALUES (5205,7994,40851,189816,2,5202,'App\\Models\\Receipt',5202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1890.06,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5206,7994,40851,189816,2,5203,'App\\Models\\Receipt',5203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2900.00,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5207,7994,40851,189816,2,5204,'App\\Models\\Receipt',5204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1750.00,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5208,7994,40851,189816,2,5205,'App\\Models\\Receipt',5205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3140.00,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:40','2024-05-29 17:40:40'),(5209,7994,40851,189816,2,5206,'App\\Models\\Receipt',5206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',9300.29,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5210,7994,40851,189816,2,5207,'App\\Models\\Receipt',5207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2000.00,NULL,NULL,1,'2023-06-08 10:18:30','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5211,7994,40851,189816,2,5208,'App\\Models\\Receipt',5208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2200.00,NULL,NULL,1,'2023-06-08 10:18:31','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5212,7994,40851,189817,2,5209,'App\\Models\\Receipt',5209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3500.00,NULL,NULL,1,'2023-06-08 10:19:09','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5213,7994,40851,189817,2,5210,'App\\Models\\Receipt',5210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1180.00,NULL,NULL,1,'2023-06-08 10:19:09','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5214,7994,40851,189817,2,5211,'App\\Models\\Receipt',5211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1450.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5215,7994,40851,189817,2,5212,'App\\Models\\Receipt',5212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',5200.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5216,7994,40851,189817,2,5213,'App\\Models\\Receipt',5213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',4800.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5217,7994,40851,189817,2,5214,'App\\Models\\Receipt',5214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2400.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5218,7994,40851,189817,2,5215,'App\\Models\\Receipt',5215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3350.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:41','2024-05-29 17:40:41'),(5219,7994,40851,189817,2,5216,'App\\Models\\Receipt',5216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5190.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5220,7994,40851,189817,2,5217,'App\\Models\\Receipt',5217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1750.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5221,7994,40851,189817,2,5218,'App\\Models\\Receipt',5218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',7770.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5222,7994,40851,189817,2,5219,'App\\Models\\Receipt',5219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3500.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5223,7994,40851,189817,2,5220,'App\\Models\\Receipt',5220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1750.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42');
INSERT INTO `balance_libro` VALUES (5224,7994,40851,189817,2,5221,'App\\Models\\Receipt',5221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3350.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5225,7994,40851,189817,2,5222,'App\\Models\\Receipt',5222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2640.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5226,7994,40851,189817,2,5223,'App\\Models\\Receipt',5223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3000.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5227,7994,40851,189817,2,5224,'App\\Models\\Receipt',5224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',5250.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5228,7994,40851,189817,2,5225,'App\\Models\\Receipt',5225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1750.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5229,7994,40851,189817,2,5226,'App\\Models\\Receipt',5226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',2140.04,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:42','2024-05-29 17:40:42'),(5230,7994,40851,189817,2,5227,'App\\Models\\Receipt',5227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',4150.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5231,7994,40851,189817,2,5228,'App\\Models\\Receipt',5228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',3200.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5232,7994,40851,189817,2,5229,'App\\Models\\Receipt',5229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',8110.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5233,7994,40851,189817,2,5230,'App\\Models\\Receipt',5230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1950.00,NULL,NULL,1,'2023-06-08 10:19:10','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5234,7994,40851,189817,2,5231,'App\\Models\\Receipt',5231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',3400.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5235,7994,40851,189817,2,5232,'App\\Models\\Receipt',5232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1930.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5236,7994,40851,189817,2,5233,'App\\Models\\Receipt',5233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',2200.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5237,7994,40851,189817,2,5234,'App\\Models\\Receipt',5234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',3200.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5238,7994,40851,189817,2,5235,'App\\Models\\Receipt',5235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3750.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5239,7994,40851,189817,2,5236,'App\\Models\\Receipt',5236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1750.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5240,7994,40851,189817,2,5237,'App\\Models\\Receipt',5237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1450.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:43','2024-05-29 17:40:43'),(5241,7994,40851,189817,2,5238,'App\\Models\\Receipt',5238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3400.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5242,7994,40851,189817,2,5239,'App\\Models\\Receipt',5239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5450.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:44','2024-05-29 17:40:44');
INSERT INTO `balance_libro` VALUES (5243,7994,40851,189817,2,5240,'App\\Models\\Receipt',5240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1330.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5244,7994,40851,189817,2,5241,'App\\Models\\Receipt',5241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1750.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5245,7994,40851,189817,2,5242,'App\\Models\\Receipt',5242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3200.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5246,7994,40851,189817,2,5243,'App\\Models\\Receipt',5243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3850.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5247,7994,40851,189817,2,5244,'App\\Models\\Receipt',5244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4100.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5248,7994,40851,189817,2,5245,'App\\Models\\Receipt',5245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4250.00,NULL,NULL,1,'2023-06-08 10:19:11','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5249,7994,40851,189817,2,5246,'App\\Models\\Receipt',5246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4300.00,NULL,NULL,1,'2023-06-08 10:19:12','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5250,7994,40851,189817,2,5247,'App\\Models\\Receipt',5247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1.00,NULL,NULL,1,'2023-06-08 10:19:12','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5251,7994,40851,189817,2,5248,'App\\Models\\Receipt',5248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4800.00,NULL,NULL,1,'2023-06-08 10:19:12','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5252,7994,40851,189817,2,5249,'App\\Models\\Receipt',5249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1.00,NULL,NULL,1,'2023-06-08 10:19:12','2024-05-29 17:40:44','2024-05-29 17:40:44'),(5253,7994,40851,189817,2,5250,'App\\Models\\Receipt',5250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1600.00,NULL,NULL,1,'2023-06-08 10:19:12','2024-05-29 17:40:45','2024-05-29 17:40:45'),(5254,7994,40851,189817,2,5251,'App\\Models\\Receipt',5251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2190.00,NULL,NULL,1,'2023-06-08 10:19:12','2024-05-29 17:40:45','2024-05-29 17:40:45'),(5255,7994,40851,189817,2,5252,'App\\Models\\Receipt',5252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',22120.00,NULL,NULL,1,'2023-06-08 10:19:12','2024-05-29 17:40:45','2024-05-29 17:40:45'),(5491,7994,40842,200534,2,5488,'App\\Models\\Receipt',5488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',9844.00,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5492,7994,40842,200534,2,5489,'App\\Models\\Receipt',5489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2278.06,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5493,7994,40842,200534,2,5490,'App\\Models\\Receipt',5490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2278.06,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5494,7994,40842,200534,2,5491,'App\\Models\\Receipt',5491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1590.00,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5495,7994,40842,200534,2,5492,'App\\Models\\Receipt',5492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2550.00,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5496,7994,40842,200534,2,5493,'App\\Models\\Receipt',5493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1018.02,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL);
INSERT INTO `balance_libro` VALUES (5497,7994,40842,200534,2,5494,'App\\Models\\Receipt',5494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',9844.00,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5498,7994,40842,200534,2,5495,'App\\Models\\Receipt',5495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',6490.00,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5499,7994,40842,200534,2,5496,'App\\Models\\Receipt',5496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2620.00,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5500,7994,40842,200534,2,5497,'App\\Models\\Receipt',5497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1590.00,NULL,NULL,1,'2023-06-08 10:51:04','2023-06-08 10:51:04',NULL),(5501,7994,40842,200534,2,5498,'App\\Models\\Receipt',5498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1270.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5502,7994,40842,200534,2,5499,'App\\Models\\Receipt',5499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2290.02,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5503,7994,40842,200534,2,5500,'App\\Models\\Receipt',5500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1600.04,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5504,7994,40842,200534,2,5501,'App\\Models\\Receipt',5501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1190.02,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5505,7994,40842,200534,2,5502,'App\\Models\\Receipt',5502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',8890.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5506,7994,40842,200534,2,5503,'App\\Models\\Receipt',5503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',670.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5507,7994,40842,200534,2,5504,'App\\Models\\Receipt',5504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',230.04,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5508,7994,40842,200534,2,5505,'App\\Models\\Receipt',5505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',8390.04,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5509,7994,40842,200534,2,5506,'App\\Models\\Receipt',5506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',720.02,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5510,7994,40842,200534,2,5507,'App\\Models\\Receipt',5507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1670.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5511,7994,40842,200534,2,5508,'App\\Models\\Receipt',5508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1010.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5512,7994,40842,200534,2,5509,'App\\Models\\Receipt',5509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',6610.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5513,7994,40842,200534,2,5510,'App\\Models\\Receipt',5510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1730.02,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5514,7994,40842,200534,2,5511,'App\\Models\\Receipt',5511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1255.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5515,7994,40842,200534,2,5512,'App\\Models\\Receipt',5512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',8560.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5516,7994,40842,200534,2,5513,'App\\Models\\Receipt',5513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',750.06,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5517,7994,40842,200534,2,5514,'App\\Models\\Receipt',5514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',640.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL);
INSERT INTO `balance_libro` VALUES (5518,7994,40842,200534,2,5515,'App\\Models\\Receipt',5515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',798.04,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5519,7994,40842,200534,2,5516,'App\\Models\\Receipt',5516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4878.06,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5520,7994,40842,200534,2,5517,'App\\Models\\Receipt',5517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1365.00,NULL,NULL,1,'2023-06-08 10:51:05','2023-06-08 10:51:05',NULL),(5521,7994,40842,200534,2,5518,'App\\Models\\Receipt',5518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1140.00,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5522,7994,40842,200534,2,5519,'App\\Models\\Receipt',5519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',19040.08,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5523,7994,40842,200534,2,5520,'App\\Models\\Receipt',5520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',10484.04,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5524,7994,40842,200534,2,5521,'App\\Models\\Receipt',5521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',7900.00,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5525,7994,40842,200534,2,5522,'App\\Models\\Receipt',5522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2530.00,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5526,7994,40842,200534,2,5523,'App\\Models\\Receipt',5523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1800.04,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5527,7994,40842,200534,2,5524,'App\\Models\\Receipt',5524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1310.06,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5528,7994,40842,200534,2,5525,'App\\Models\\Receipt',5525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1160.00,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5529,7994,40842,200534,2,5526,'App\\Models\\Receipt',5526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',2350.00,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5530,7994,40842,200534,2,5527,'App\\Models\\Receipt',5527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',6170.04,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5531,7994,40842,200534,2,5528,'App\\Models\\Receipt',5528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',7115.00,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5532,7994,40842,200534,2,5529,'App\\Models\\Receipt',5529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',6710.06,NULL,NULL,1,'2023-06-08 10:51:06','2023-06-08 10:51:06',NULL),(5533,7994,40842,200534,2,5530,'App\\Models\\Receipt',5530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',7300.00,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5534,7994,40842,200534,2,5531,'App\\Models\\Receipt',5531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1300.00,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5535,7994,40842,200534,2,5532,'App\\Models\\Receipt',5532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',900.02,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5536,7994,40842,200534,2,5533,'App\\Models\\Receipt',5533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1240.04,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5537,7994,40842,200534,2,5534,'App\\Models\\Receipt',5534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1820.02,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5538,7994,40842,200534,2,5535,'App\\Models\\Receipt',5535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',850.00,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL);
INSERT INTO `balance_libro` VALUES (5539,7994,40842,200534,2,5536,'App\\Models\\Receipt',5536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',11650.00,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5540,7994,40842,200534,2,5537,'App\\Models\\Receipt',5537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1750.02,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5541,7994,40842,200534,2,5538,'App\\Models\\Receipt',5538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',560.00,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5542,7994,40842,200534,2,5539,'App\\Models\\Receipt',5539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',900.02,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5543,7994,40842,200534,2,5540,'App\\Models\\Receipt',5540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',7910.00,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5544,7994,40842,200534,2,5541,'App\\Models\\Receipt',5541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2526.04,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5545,7994,40842,200534,2,5542,'App\\Models\\Receipt',5542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',385.02,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5546,7994,40842,200534,2,5543,'App\\Models\\Receipt',5543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2360.04,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5547,7994,40842,200534,2,5544,'App\\Models\\Receipt',5544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',350.00,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5548,7994,40842,200534,2,5545,'App\\Models\\Receipt',5545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2170.00,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5549,7994,40842,200534,2,5546,'App\\Models\\Receipt',5546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',250.02,NULL,NULL,1,'2023-06-08 10:51:07','2023-06-08 10:51:07',NULL),(5550,7994,40842,200534,2,5547,'App\\Models\\Receipt',5547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',80.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5551,7994,40842,200534,2,5548,'App\\Models\\Receipt',5548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',3175.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5552,7994,40842,200534,2,5549,'App\\Models\\Receipt',5549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',5000.02,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5553,7994,40842,200534,2,5550,'App\\Models\\Receipt',5550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1200.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5554,7994,40842,200534,2,5551,'App\\Models\\Receipt',5551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',400.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5555,7994,40842,200534,2,5552,'App\\Models\\Receipt',5552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1270.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5556,7994,40842,200534,2,5553,'App\\Models\\Receipt',5553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',20000.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5557,7994,40842,200534,2,5554,'App\\Models\\Receipt',5554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',2830.04,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5558,7994,40842,200534,2,5555,'App\\Models\\Receipt',5555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',2000.02,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5559,7994,40842,200534,2,5556,'App\\Models\\Receipt',5556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',2118.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL);
INSERT INTO `balance_libro` VALUES (5560,7994,40842,200534,2,5557,'App\\Models\\Receipt',5557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',7320.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5561,7994,40842,200534,2,5558,'App\\Models\\Receipt',5558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',3060.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5562,7994,40842,200534,2,5559,'App\\Models\\Receipt',5559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',8710.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5563,7994,40842,200534,2,5560,'App\\Models\\Receipt',5560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',7300.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5564,7994,40842,200534,2,5561,'App\\Models\\Receipt',5561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1690.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5565,7994,40842,200534,2,5562,'App\\Models\\Receipt',5562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',8710.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5566,7994,40842,200534,2,5563,'App\\Models\\Receipt',5563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',3500.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5567,7994,40842,200534,2,5564,'App\\Models\\Receipt',5564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',6980.00,NULL,NULL,1,'2023-06-08 10:51:08','2023-06-08 10:51:08',NULL),(5568,7994,40842,200534,2,5565,'App\\Models\\Receipt',5565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',14653.10,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5569,7994,40842,200534,2,5566,'App\\Models\\Receipt',5566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1380.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5570,7994,40842,200534,2,5567,'App\\Models\\Receipt',5567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2620.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5571,7994,40842,200534,2,5568,'App\\Models\\Receipt',5568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1000.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5572,7994,40842,200534,2,5569,'App\\Models\\Receipt',5569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',960.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5573,7994,40842,200534,2,5570,'App\\Models\\Receipt',5570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2030.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5574,7994,40842,200534,2,5571,'App\\Models\\Receipt',5571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',6980.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5575,7994,40842,200534,2,5572,'App\\Models\\Receipt',5572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',19860.04,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5576,7994,40842,200534,2,5573,'App\\Models\\Receipt',5573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',15000.14,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5577,7994,40842,200534,2,5574,'App\\Models\\Receipt',5574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',9200.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5578,7994,40842,200534,2,5575,'App\\Models\\Receipt',5575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',7400.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5579,7994,40842,200534,2,5576,'App\\Models\\Receipt',5576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',5830.02,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5580,7994,40842,200534,2,5577,'App\\Models\\Receipt',5577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',9100.02,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL);
INSERT INTO `balance_libro` VALUES (5581,7994,40842,200534,2,5578,'App\\Models\\Receipt',5578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',7450.06,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5582,7994,40842,200534,2,5579,'App\\Models\\Receipt',5579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',13215.00,NULL,NULL,1,'2023-06-08 10:51:09','2023-06-08 10:51:09',NULL),(5583,7994,40842,200534,2,5580,'App\\Models\\Receipt',5580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',13215.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5584,7994,40842,200534,2,5581,'App\\Models\\Receipt',5581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',10764.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5585,7994,40842,200534,2,5582,'App\\Models\\Receipt',5582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',590.04,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5586,7994,40842,200534,2,5583,'App\\Models\\Receipt',5583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',860.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5587,7994,40842,200534,2,5584,'App\\Models\\Receipt',5584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1980.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5588,7994,40842,200534,2,5585,'App\\Models\\Receipt',5585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',580.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5589,7994,40842,200534,2,5586,'App\\Models\\Receipt',5586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',8880.04,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5590,7994,40842,200534,2,5587,'App\\Models\\Receipt',5587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1380.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5591,7994,40842,200534,2,5588,'App\\Models\\Receipt',5588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',7920.06,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5592,7994,40842,200534,2,5589,'App\\Models\\Receipt',5589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',10576.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5593,7994,40842,200534,2,5590,'App\\Models\\Receipt',5590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',650.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5594,7994,40842,200534,2,5591,'App\\Models\\Receipt',5591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',9360.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5595,7994,40842,200534,2,5592,'App\\Models\\Receipt',5592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',8990.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5596,7994,40842,200534,2,5593,'App\\Models\\Receipt',5593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1270.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5597,7994,40842,200534,2,5594,'App\\Models\\Receipt',5594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',409.50,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5598,7994,40842,200534,2,5595,'App\\Models\\Receipt',5595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1380.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5599,7994,40842,200534,2,5596,'App\\Models\\Receipt',5596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',500.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5600,7994,40842,200534,2,5597,'App\\Models\\Receipt',5597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1040.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5601,7994,40842,200534,2,5598,'App\\Models\\Receipt',5598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',4430.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL);
INSERT INTO `balance_libro` VALUES (5602,7994,40842,200534,2,5599,'App\\Models\\Receipt',5599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',8880.00,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5603,7994,40842,200534,2,5600,'App\\Models\\Receipt',5600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',19860.04,NULL,NULL,1,'2023-06-08 10:51:10','2023-06-08 10:51:10',NULL),(5604,7994,40842,200534,2,5601,'App\\Models\\Receipt',5601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',320.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5605,7994,40842,200534,2,5602,'App\\Models\\Receipt',5602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',8362.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5606,7994,40842,200534,2,5603,'App\\Models\\Receipt',5603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',620.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5607,7994,40842,200534,2,5604,'App\\Models\\Receipt',5604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',3140.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5608,7994,40842,200534,2,5605,'App\\Models\\Receipt',5605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',8880.04,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5609,7994,40842,200534,2,5606,'App\\Models\\Receipt',5606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',800.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5610,7994,40842,200534,2,5607,'App\\Models\\Receipt',5607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',2500.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5611,7994,40842,200534,2,5608,'App\\Models\\Receipt',5608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',9100.02,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5612,7994,40842,200534,2,5609,'App\\Models\\Receipt',5609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1240.04,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5613,7994,40842,200534,2,5610,'App\\Models\\Receipt',5610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1260.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5614,7994,40842,200534,2,5611,'App\\Models\\Receipt',5611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',950.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5615,7994,40842,200534,2,5612,'App\\Models\\Receipt',5612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',3360.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5616,7994,40842,200534,2,5613,'App\\Models\\Receipt',5613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',990.02,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5617,7994,40842,200534,2,5614,'App\\Models\\Receipt',5614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',14970.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5618,7994,40842,200534,2,5615,'App\\Models\\Receipt',5615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',2320.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5619,7994,40842,200534,2,5616,'App\\Models\\Receipt',5616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',29940.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5620,7994,40842,200534,2,5617,'App\\Models\\Receipt',5617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1230.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5621,7994,40842,200534,2,5618,'App\\Models\\Receipt',5618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',14790.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5622,7994,40842,200534,2,5619,'App\\Models\\Receipt',5619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1820.02,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL);
INSERT INTO `balance_libro` VALUES (5623,7994,40842,200534,2,5620,'App\\Models\\Receipt',5620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',710.00,NULL,NULL,1,'2023-06-08 10:51:11','2023-06-08 10:51:11',NULL),(5624,7994,40842,200534,2,5621,'App\\Models\\Receipt',5621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',940.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5625,7994,40842,200534,2,5622,'App\\Models\\Receipt',5622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',726.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5626,7994,40842,200534,2,5623,'App\\Models\\Receipt',5623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',2010.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5627,7994,40842,200534,2,5624,'App\\Models\\Receipt',5624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',3640.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5628,7994,40842,200534,2,5625,'App\\Models\\Receipt',5625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',630.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5629,7994,40842,200534,2,5626,'App\\Models\\Receipt',5626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',870.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5630,7994,40842,200534,2,5627,'App\\Models\\Receipt',5627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',2824.50,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5631,7994,40842,200534,2,5628,'App\\Models\\Receipt',5628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',3039.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5632,7994,40842,200534,2,5629,'App\\Models\\Receipt',5629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',7920.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5633,7994,40842,200534,2,5630,'App\\Models\\Receipt',5630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',50000.04,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5634,7994,40842,200534,2,5631,'App\\Models\\Receipt',5631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',8880.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5635,7994,40842,200534,2,5632,'App\\Models\\Receipt',5632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',2800.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5636,7994,40842,200534,2,5633,'App\\Models\\Receipt',5633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',8610.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5637,7994,40842,200534,2,5634,'App\\Models\\Receipt',5634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1790.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5638,7994,40842,200534,2,5635,'App\\Models\\Receipt',5635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',9000.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5639,7994,40842,200534,2,5636,'App\\Models\\Receipt',5636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',10560.04,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5640,7994,40842,200534,2,5637,'App\\Models\\Receipt',5637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',9300.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5641,7994,40842,200534,2,5638,'App\\Models\\Receipt',5638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',900.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5642,7994,40842,200534,2,5639,'App\\Models\\Receipt',5639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1500.00,NULL,NULL,1,'2023-06-08 10:51:12','2023-06-08 10:51:12',NULL),(5643,7994,40842,200534,2,5640,'App\\Models\\Receipt',5640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',370.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL);
INSERT INTO `balance_libro` VALUES (5644,7994,40842,200534,2,5641,'App\\Models\\Receipt',5641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',26000.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5645,7994,40842,200534,2,5642,'App\\Models\\Receipt',5642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',9830.31,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5646,7994,40842,200534,2,5643,'App\\Models\\Receipt',5643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',3500.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5647,7994,40842,200534,2,5644,'App\\Models\\Receipt',5644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',7900.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5648,7994,40842,200534,2,5645,'App\\Models\\Receipt',5645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',7920.06,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5649,7994,40842,200534,2,5646,'App\\Models\\Receipt',5646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1280.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5650,7994,40842,200534,2,5647,'App\\Models\\Receipt',5647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1930.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5651,7994,40842,200534,2,5648,'App\\Models\\Receipt',5648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',651.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5652,7994,40842,200534,2,5649,'App\\Models\\Receipt',5649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',651.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5653,7994,40842,200534,2,5650,'App\\Models\\Receipt',5650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',2600.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5654,7994,40842,200534,2,5651,'App\\Models\\Receipt',5651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',8220.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5655,7994,40842,200534,2,5652,'App\\Models\\Receipt',5652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1770.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5656,7994,40842,200534,2,5653,'App\\Models\\Receipt',5653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',3842.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5657,7994,40842,200534,2,5654,'App\\Models\\Receipt',5654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1070.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5658,7994,40842,200534,2,5655,'App\\Models\\Receipt',5655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',2690.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5659,7994,40842,200534,2,5656,'App\\Models\\Receipt',5656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1700.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5660,7994,40842,200534,2,5657,'App\\Models\\Receipt',5657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',2450.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5661,7994,40842,200534,2,5658,'App\\Models\\Receipt',5658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',390.00,NULL,NULL,1,'2023-06-08 10:51:13','2023-06-08 10:51:13',NULL),(5662,7994,40842,200534,2,5659,'App\\Models\\Receipt',5659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',830.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5663,7994,40842,200534,2,5660,'App\\Models\\Receipt',5660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',37.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5664,7994,40842,200534,2,5661,'App\\Models\\Receipt',5661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',11600.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL);
INSERT INTO `balance_libro` VALUES (5665,7994,40842,200534,2,5662,'App\\Models\\Receipt',5662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',520.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5666,7994,40842,200534,2,5663,'App\\Models\\Receipt',5663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',550.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5667,7994,40842,200534,2,5664,'App\\Models\\Receipt',5664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1580.06,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5668,7994,40842,200534,2,5665,'App\\Models\\Receipt',5665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',560.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5669,7994,40842,200534,2,5666,'App\\Models\\Receipt',5666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1990.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5670,7994,40842,200534,2,5667,'App\\Models\\Receipt',5667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1990.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5671,7994,40842,200534,2,5668,'App\\Models\\Receipt',5668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',2670.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5672,7994,40842,200534,2,5669,'App\\Models\\Receipt',5669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',2598.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5673,7994,40842,200534,2,5670,'App\\Models\\Receipt',5670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',6560.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5674,7994,40842,200534,2,5671,'App\\Models\\Receipt',5671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',6858.50,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5675,7994,40842,200534,2,5672,'App\\Models\\Receipt',5672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',6336.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5676,7994,40842,200534,2,5673,'App\\Models\\Receipt',5673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',720.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5677,7994,40842,200534,2,5674,'App\\Models\\Receipt',5674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',12110.06,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5678,7994,40842,200534,2,5675,'App\\Models\\Receipt',5675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',7600.02,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5679,7994,40842,200534,2,5676,'App\\Models\\Receipt',5676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',2660.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5680,7994,40842,200534,2,5677,'App\\Models\\Receipt',5677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',420.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5681,7994,40842,200534,2,5678,'App\\Models\\Receipt',5678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',6980.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5682,7994,40842,200534,2,5679,'App\\Models\\Receipt',5679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1060.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5683,7994,40842,200534,2,5680,'App\\Models\\Receipt',5680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1910.00,NULL,NULL,1,'2023-06-08 10:51:14','2023-06-08 10:51:14',NULL),(5684,7994,40842,200534,2,5681,'App\\Models\\Receipt',5681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',9100.02,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5685,7994,40842,200534,2,5682,'App\\Models\\Receipt',5682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',40975.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL);
INSERT INTO `balance_libro` VALUES (5686,7994,40842,200534,2,5683,'App\\Models\\Receipt',5683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',19855.02,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5687,7994,40842,200534,2,5684,'App\\Models\\Receipt',5684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',5000.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5688,7994,40842,200534,2,5685,'App\\Models\\Receipt',5685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',9100.02,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5689,7994,40842,200534,2,5686,'App\\Models\\Receipt',5686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',6100.02,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5690,7994,40842,200534,2,5687,'App\\Models\\Receipt',5687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1910.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5691,7994,40842,200534,2,5688,'App\\Models\\Receipt',5688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',9100.02,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5692,7994,40842,200534,2,5689,'App\\Models\\Receipt',5689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',7600.02,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5693,7994,40842,200534,2,5690,'App\\Models\\Receipt',5690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',310.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5694,7994,40842,200534,2,5691,'App\\Models\\Receipt',5691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',430.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5695,7994,40842,200534,2,5692,'App\\Models\\Receipt',5692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',760.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5696,7994,40842,200534,2,5693,'App\\Models\\Receipt',5693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3180.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5697,7994,40842,200534,2,5694,'App\\Models\\Receipt',5694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',200.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5698,7994,40842,200534,2,5695,'App\\Models\\Receipt',5695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5138.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5699,7994,40842,200534,2,5696,'App\\Models\\Receipt',5696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',9380.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5700,7994,40842,200534,2,5697,'App\\Models\\Receipt',5697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1120.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5701,7994,40842,200534,2,5698,'App\\Models\\Receipt',5698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',22000.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5702,7994,40842,200534,2,5699,'App\\Models\\Receipt',5699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1600.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5703,7994,40842,200534,2,5700,'App\\Models\\Receipt',5700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4700.00,NULL,NULL,1,'2023-06-08 10:51:15','2023-06-08 10:51:15',NULL),(5704,7994,40842,200535,2,5701,'App\\Models\\Receipt',5701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',9100.02,NULL,NULL,1,'2023-06-08 11:08:02','2023-06-08 11:08:02',NULL),(5705,7994,40842,200535,2,5702,'App\\Models\\Receipt',5702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',5430.00,NULL,NULL,1,'2023-06-08 11:08:02','2023-06-08 11:08:02',NULL),(5706,7994,40842,200535,2,5703,'App\\Models\\Receipt',5703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1780.00,NULL,NULL,1,'2023-06-08 11:08:02','2023-06-08 11:08:02',NULL);
INSERT INTO `balance_libro` VALUES (5707,7994,40842,200535,2,5704,'App\\Models\\Receipt',5704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3900.00,NULL,NULL,1,'2023-06-08 11:08:02','2023-06-08 11:08:02',NULL),(5708,7994,40842,200535,2,5705,'App\\Models\\Receipt',5705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',430.00,NULL,NULL,1,'2023-06-08 11:08:02','2023-06-08 11:08:02',NULL),(5709,7994,40842,200535,2,5706,'App\\Models\\Receipt',5706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',6844.44,NULL,NULL,1,'2023-06-08 11:08:03','2023-06-08 11:08:03',NULL),(5710,7994,40842,200535,2,5707,'App\\Models\\Receipt',5707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1892.00,NULL,NULL,1,'2023-06-08 11:08:03','2023-06-08 11:08:03',NULL),(5711,7994,40842,200535,2,5708,'App\\Models\\Receipt',5708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3100.00,NULL,NULL,1,'2023-06-08 11:08:03','2023-06-08 11:08:03',NULL),(5712,7994,40842,200535,2,5709,'App\\Models\\Receipt',5709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1850.00,NULL,NULL,1,'2023-06-08 11:08:03','2023-06-08 11:08:03',NULL),(5713,7994,40842,200535,2,5710,'App\\Models\\Receipt',5710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3840.00,NULL,NULL,1,'2023-06-08 11:08:03','2023-06-08 11:08:03',NULL),(5714,7994,40842,200535,2,5711,'App\\Models\\Receipt',5711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',1040.00,NULL,NULL,1,'2023-06-08 11:08:03','2023-06-08 11:08:03',NULL),(5715,7994,40842,200535,2,5712,'App\\Models\\Receipt',5712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',1040.00,NULL,NULL,1,'2023-06-08 11:08:04','2023-06-08 11:08:04',NULL),(5716,7994,40842,200535,2,5713,'App\\Models\\Receipt',5713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',7650.00,NULL,NULL,1,'2023-06-08 11:08:04','2023-06-08 11:08:04',NULL),(5717,7994,40842,200535,2,5714,'App\\Models\\Receipt',5714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',10000.04,NULL,NULL,1,'2023-06-08 11:08:04','2023-06-08 11:08:04',NULL),(5718,7994,40842,200535,2,5715,'App\\Models\\Receipt',5715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',11670.00,NULL,NULL,1,'2023-06-08 11:08:04','2023-06-08 11:08:04',NULL),(5719,7994,40842,200535,2,5716,'App\\Models\\Receipt',5716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',9100.02,NULL,NULL,1,'2023-06-08 11:08:04','2023-06-08 11:08:04',NULL),(5720,7994,40842,200535,2,5717,'App\\Models\\Receipt',5717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',810.00,NULL,NULL,1,'2023-06-08 11:08:05','2023-06-08 11:08:05',NULL),(5721,7994,40842,200535,2,5718,'App\\Models\\Receipt',5718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',300.00,NULL,NULL,1,'2023-06-08 11:08:05','2023-06-08 11:08:05',NULL),(5722,7994,40842,200535,2,5719,'App\\Models\\Receipt',5719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',940.00,NULL,NULL,1,'2023-06-08 11:08:05','2023-06-08 11:08:05',NULL),(5723,7994,40842,200535,2,5720,'App\\Models\\Receipt',5720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',14030.00,NULL,NULL,1,'2023-06-08 11:08:05','2023-06-08 11:08:05',NULL),(5724,7994,40842,200535,2,5721,'App\\Models\\Receipt',5721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',530.00,NULL,NULL,1,'2023-06-08 11:08:05','2023-06-08 11:08:05',NULL),(5725,7994,40842,200535,2,5722,'App\\Models\\Receipt',5722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',2600.00,NULL,NULL,1,'2023-06-08 11:08:05','2023-06-08 11:08:05',NULL),(5726,7994,40842,200535,2,5723,'App\\Models\\Receipt',5723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',9360.00,NULL,NULL,1,'2023-06-08 11:08:05','2023-06-08 11:08:05',NULL),(5727,7994,40842,200535,2,5724,'App\\Models\\Receipt',5724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',2052.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL);
INSERT INTO `balance_libro` VALUES (5728,7994,40842,200535,2,5725,'App\\Models\\Receipt',5725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',6725.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5729,7994,40842,200535,2,5726,'App\\Models\\Receipt',5726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',1335.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5730,7994,40842,200535,2,5727,'App\\Models\\Receipt',5727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',3350.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5731,7994,40842,200535,2,5728,'App\\Models\\Receipt',5728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',8300.04,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5732,7994,40842,200535,2,5729,'App\\Models\\Receipt',5729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',350.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5733,7994,40842,200535,2,5730,'App\\Models\\Receipt',5730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',600.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5734,7994,40842,200535,2,5731,'App\\Models\\Receipt',5731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',170.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5735,7994,40842,200535,2,5732,'App\\Models\\Receipt',5732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',295.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5736,7994,40842,200535,2,5733,'App\\Models\\Receipt',5733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',200.00,NULL,NULL,1,'2023-06-08 11:08:06','2023-06-08 11:08:06',NULL),(5737,7994,40842,200535,2,5734,'App\\Models\\Receipt',5734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',3290.00,NULL,NULL,1,'2023-06-08 11:08:07','2023-06-08 11:08:07',NULL),(5738,7994,40842,200535,2,5735,'App\\Models\\Receipt',5735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',9360.00,NULL,NULL,1,'2023-06-08 11:08:07','2023-06-08 11:08:07',NULL),(5739,7994,40842,200535,2,5736,'App\\Models\\Receipt',5736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2400.00,NULL,NULL,1,'2023-06-08 11:08:07','2023-06-08 11:08:07',NULL),(5740,7994,40842,200535,2,5737,'App\\Models\\Receipt',5737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2000.00,NULL,NULL,1,'2023-06-08 11:08:07','2023-06-08 11:08:07',NULL),(5741,7994,40842,200535,2,5738,'App\\Models\\Receipt',5738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',4000.00,NULL,NULL,1,'2023-06-08 11:08:07','2023-06-08 11:08:07',NULL),(5742,7994,40842,200535,2,5739,'App\\Models\\Receipt',5739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2740.00,NULL,NULL,1,'2023-06-08 11:08:07','2023-06-08 11:08:07',NULL),(5743,7994,40842,200535,2,5740,'App\\Models\\Receipt',5740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1650.00,NULL,NULL,1,'2023-06-08 11:08:08','2023-06-08 11:08:08',NULL),(5744,7994,40842,200535,2,5741,'App\\Models\\Receipt',5741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2000.00,NULL,NULL,1,'2023-06-08 11:08:08','2023-06-08 11:08:08',NULL),(5745,7994,40842,200535,2,5742,'App\\Models\\Receipt',5742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',3675.00,NULL,NULL,1,'2023-06-08 11:08:08','2023-06-08 11:08:08',NULL),(5746,7994,40842,200535,2,5743,'App\\Models\\Receipt',5743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',980.00,NULL,NULL,1,'2023-06-08 11:08:08','2023-06-08 11:08:08',NULL),(5747,7994,40842,200535,2,5744,'App\\Models\\Receipt',5744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',7315.00,NULL,NULL,1,'2023-06-08 11:08:08','2023-06-08 11:08:08',NULL),(5748,7994,40842,200535,2,5745,'App\\Models\\Receipt',5745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',860.04,NULL,NULL,1,'2023-06-08 11:08:08','2023-06-08 11:08:08',NULL);
INSERT INTO `balance_libro` VALUES (5749,7994,40842,200535,2,5746,'App\\Models\\Receipt',5746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2740.04,NULL,NULL,1,'2023-06-08 11:08:09','2023-06-08 11:08:09',NULL),(5750,7994,40842,200535,2,5747,'App\\Models\\Receipt',5747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',12110.06,NULL,NULL,1,'2023-06-08 11:08:09','2023-06-08 11:08:09',NULL),(5751,7994,40842,200535,2,5748,'App\\Models\\Receipt',5748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1730.00,NULL,NULL,1,'2023-06-08 11:08:09','2023-06-08 11:08:09',NULL),(5752,7994,40842,200535,2,5749,'App\\Models\\Receipt',5749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1250.00,NULL,NULL,1,'2023-06-08 11:08:09','2023-06-08 11:08:09',NULL),(5753,7994,40842,200535,2,5750,'App\\Models\\Receipt',5750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',680.00,NULL,NULL,1,'2023-06-08 11:08:09','2023-06-08 11:08:09',NULL),(5754,7994,40842,200535,2,5751,'App\\Models\\Receipt',5751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',575.00,NULL,NULL,1,'2023-06-08 11:08:09','2023-06-08 11:08:09',NULL),(5755,7994,40842,200535,2,5752,'App\\Models\\Receipt',5752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',2120.00,NULL,NULL,1,'2023-06-08 11:08:09','2023-06-08 11:08:09',NULL),(5756,7994,40842,200535,2,5753,'App\\Models\\Receipt',5753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',4900.00,NULL,NULL,1,'2023-06-08 11:08:09','2023-06-08 11:08:09',NULL),(5757,7994,40842,200535,2,5754,'App\\Models\\Receipt',5754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',8200.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5758,7994,40842,200535,2,5755,'App\\Models\\Receipt',5755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',5000.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5759,7994,40842,200535,2,5756,'App\\Models\\Receipt',5756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',600.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5760,7994,40842,200535,2,5757,'App\\Models\\Receipt',5757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',470.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5761,7994,40842,200535,2,5758,'App\\Models\\Receipt',5758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',7200.04,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5762,7994,40842,200535,2,5759,'App\\Models\\Receipt',5759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',770.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5763,7994,40842,200535,2,5760,'App\\Models\\Receipt',5760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',550.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5764,7994,40842,200535,2,5761,'App\\Models\\Receipt',5761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',3170.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5765,7994,40842,200535,2,5762,'App\\Models\\Receipt',5762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',2200.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5766,7994,40842,200535,2,5763,'App\\Models\\Receipt',5763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',7490.00,NULL,NULL,1,'2023-06-08 11:08:10','2023-06-08 11:08:10',NULL),(5767,7994,40842,200535,2,5764,'App\\Models\\Receipt',5764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',800.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL),(5768,7994,40842,200535,2,5765,'App\\Models\\Receipt',5765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1000.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL),(5769,7994,40842,200535,2,5766,'App\\Models\\Receipt',5766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',690.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL);
INSERT INTO `balance_libro` VALUES (5770,7994,40842,200535,2,5767,'App\\Models\\Receipt',5767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',11670.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL),(5771,7994,40842,200535,2,5768,'App\\Models\\Receipt',5768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',7500.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL),(5772,7994,40842,200535,2,5769,'App\\Models\\Receipt',5769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',12940.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL),(5773,7994,40842,200535,2,5770,'App\\Models\\Receipt',5770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1470.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL),(5774,7994,40842,200535,2,5771,'App\\Models\\Receipt',5771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',810.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL),(5775,7994,40842,200535,2,5772,'App\\Models\\Receipt',5772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',33200.00,NULL,NULL,1,'2023-06-08 11:08:11','2023-06-08 11:08:11',NULL),(5776,7994,40842,200535,2,5773,'App\\Models\\Receipt',5773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',9100.02,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5777,7994,40842,200535,2,5774,'App\\Models\\Receipt',5774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',23400.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5778,7994,40842,200535,2,5775,'App\\Models\\Receipt',5775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4053.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5779,7994,40842,200535,2,5776,'App\\Models\\Receipt',5776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',16500.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5780,7994,40842,200535,2,5777,'App\\Models\\Receipt',5777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',29080.50,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5781,7994,40842,200535,2,5778,'App\\Models\\Receipt',5778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',4600.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5782,7994,40842,200535,2,5779,'App\\Models\\Receipt',5779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',1260.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5783,7994,40842,200535,2,5780,'App\\Models\\Receipt',5780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',9000.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5784,7994,40842,200535,2,5781,'App\\Models\\Receipt',5781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',14000.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5785,7994,40842,200535,2,5782,'App\\Models\\Receipt',5782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',900.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5786,7994,40842,200535,2,5783,'App\\Models\\Receipt',5783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',1235.00,NULL,NULL,1,'2023-06-08 11:08:12','2023-06-08 11:08:12',NULL),(5787,7994,40842,200535,2,5784,'App\\Models\\Receipt',5784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',1040.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5788,7994,40842,200535,2,5785,'App\\Models\\Receipt',5785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',3266.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5789,7994,40842,200535,2,5786,'App\\Models\\Receipt',5786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',9170.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL);
INSERT INTO `balance_libro` VALUES (5790,7994,40842,200535,2,5787,'App\\Models\\Receipt',5787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',4070.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5791,7994,40842,200535,2,5788,'App\\Models\\Receipt',5788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',520.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5792,7994,40842,200535,2,5789,'App\\Models\\Receipt',5789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',860.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5793,7994,40842,200535,2,5790,'App\\Models\\Receipt',5790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',2000.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5794,7994,40842,200535,2,5791,'App\\Models\\Receipt',5791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',19860.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5795,7994,40842,200535,2,5792,'App\\Models\\Receipt',5792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',3340.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5796,7994,40842,200535,2,5793,'App\\Models\\Receipt',5793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',7600.02,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5797,7994,40842,200535,2,5794,'App\\Models\\Receipt',5794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',7600.02,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5798,7994,40842,200535,2,5795,'App\\Models\\Receipt',5795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',790.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5799,7994,40842,200535,2,5796,'App\\Models\\Receipt',5796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',2205.00,NULL,NULL,1,'2023-06-08 11:08:13','2023-06-08 11:08:13',NULL),(5800,7994,40842,200535,2,5797,'App\\Models\\Receipt',5797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',9100.02,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5801,7994,40842,200535,2,5798,'App\\Models\\Receipt',5798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',4740.00,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5802,7994,40842,200535,2,5799,'App\\Models\\Receipt',5799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',700.00,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5803,7994,40842,200535,2,5800,'App\\Models\\Receipt',5800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1470.00,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5804,7994,40842,200535,2,5801,'App\\Models\\Receipt',5801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',250.00,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5805,7994,40842,200535,2,5802,'App\\Models\\Receipt',5802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1630.00,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5806,7994,40842,200535,2,5803,'App\\Models\\Receipt',5803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',3350.00,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5807,7994,40842,200535,2,5804,'App\\Models\\Receipt',5804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2550.00,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5808,7994,40842,200535,2,5805,'App\\Models\\Receipt',5805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1820.00,NULL,NULL,1,'2023-06-08 11:08:14','2023-06-08 11:08:14',NULL),(5809,7994,40842,200535,2,5806,'App\\Models\\Receipt',5806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1785.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL),(5810,7994,40842,200535,2,5807,'App\\Models\\Receipt',5807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2690.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL);
INSERT INTO `balance_libro` VALUES (5811,7994,40842,200535,2,5808,'App\\Models\\Receipt',5808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',3100.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL),(5812,7994,40842,200535,2,5809,'App\\Models\\Receipt',5809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',410.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL),(5813,7994,40842,200535,2,5810,'App\\Models\\Receipt',5810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',700.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL),(5814,7994,40842,200535,2,5811,'App\\Models\\Receipt',5811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1140.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL),(5815,7994,40842,200535,2,5812,'App\\Models\\Receipt',5812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',700.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL),(5816,7994,40842,200535,2,5813,'App\\Models\\Receipt',5813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1940.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL),(5817,7994,40842,200535,2,5814,'App\\Models\\Receipt',5814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1100.00,NULL,NULL,1,'2023-06-08 11:08:15','2023-06-08 11:08:15',NULL),(5818,7994,40842,200535,2,5815,'App\\Models\\Receipt',5815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',6490.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5819,7994,40842,200535,2,5816,'App\\Models\\Receipt',5816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1470.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5820,7994,40842,200535,2,5817,'App\\Models\\Receipt',5817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',6900.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5821,7994,40842,200535,2,5818,'App\\Models\\Receipt',5818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',4430.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5822,7994,40842,200535,2,5819,'App\\Models\\Receipt',5819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',320.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5823,7994,40842,200535,2,5820,'App\\Models\\Receipt',5820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',9000.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5824,7994,40842,200535,2,5821,'App\\Models\\Receipt',5821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',9751.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5825,7994,40842,200535,2,5822,'App\\Models\\Receipt',5822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',7000.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5826,7994,40842,200535,2,5823,'App\\Models\\Receipt',5823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',6740.00,NULL,NULL,1,'2023-06-08 11:08:16','2023-06-08 11:08:16',NULL),(5827,7994,40842,200535,2,5824,'App\\Models\\Receipt',5824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',210.00,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL),(5828,7994,40842,200535,2,5825,'App\\Models\\Receipt',5825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',17000.00,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL),(5829,7994,40842,200535,2,5826,'App\\Models\\Receipt',5826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',920.00,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL),(5830,7994,40842,200535,2,5827,'App\\Models\\Receipt',5827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',635.00,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL),(5831,7994,40842,200535,2,5828,'App\\Models\\Receipt',5828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',7090.00,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL);
INSERT INTO `balance_libro` VALUES (5832,7994,40842,200535,2,5829,'App\\Models\\Receipt',5829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',8290.00,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL),(5833,7994,40842,200535,2,5830,'App\\Models\\Receipt',5830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',9350.04,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL),(5834,7994,40842,200535,2,5831,'App\\Models\\Receipt',5831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',900.02,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL),(5835,7994,40842,200535,2,5832,'App\\Models\\Receipt',5832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',2770.00,NULL,NULL,1,'2023-06-08 11:08:17','2023-06-08 11:08:17',NULL),(5836,7994,40842,200535,2,5833,'App\\Models\\Receipt',5833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',400.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5837,7994,40842,200535,2,5834,'App\\Models\\Receipt',5834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',800.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5838,7994,40842,200535,2,5835,'App\\Models\\Receipt',5835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',780.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5839,7994,40842,200535,2,5836,'App\\Models\\Receipt',5836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',6285.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5840,7994,40842,200535,2,5837,'App\\Models\\Receipt',5837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',2400.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5841,7994,40842,200535,2,5838,'App\\Models\\Receipt',5838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',2520.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5842,7994,40842,200535,2,5839,'App\\Models\\Receipt',5839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',1360.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5843,7994,40842,200535,2,5840,'App\\Models\\Receipt',5840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',1150.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5844,7994,40842,200535,2,5841,'App\\Models\\Receipt',5841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',1900.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5845,7994,40842,200535,2,5842,'App\\Models\\Receipt',5842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',300.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5846,7994,40842,200535,2,5843,'App\\Models\\Receipt',5843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',2385.06,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5847,7994,40842,200535,2,5844,'App\\Models\\Receipt',5844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',1140.00,NULL,NULL,1,'2023-06-08 11:08:18','2023-06-08 11:08:18',NULL),(5848,7994,40842,200535,2,5845,'App\\Models\\Receipt',5845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',660.06,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5849,7994,40842,200535,2,5846,'App\\Models\\Receipt',5846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',1980.04,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5850,7994,40842,200535,2,5847,'App\\Models\\Receipt',5847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',5550.00,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5851,7994,40842,200535,2,5848,'App\\Models\\Receipt',5848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',3250.00,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5852,7994,40842,200535,2,5849,'App\\Models\\Receipt',5849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',2782.04,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL);
INSERT INTO `balance_libro` VALUES (5853,7994,40842,200535,2,5850,'App\\Models\\Receipt',5850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',2660.00,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5854,7994,40842,200535,2,5851,'App\\Models\\Receipt',5851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',1200.00,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5855,7994,40842,200535,2,5852,'App\\Models\\Receipt',5852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',7000.04,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5856,7994,40842,200535,2,5853,'App\\Models\\Receipt',5853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',200.00,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5857,7994,40842,200535,2,5854,'App\\Models\\Receipt',5854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2793.06,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5858,7994,40842,200535,2,5855,'App\\Models\\Receipt',5855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1200.00,NULL,NULL,1,'2023-06-08 11:08:19','2023-06-08 11:08:19',NULL),(5859,7994,40842,200535,2,5856,'App\\Models\\Receipt',5856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',3370.04,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5860,7994,40842,200535,2,5857,'App\\Models\\Receipt',5857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',250.02,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5861,7994,40842,200535,2,5858,'App\\Models\\Receipt',5858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',510.00,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5862,7994,40842,200535,2,5859,'App\\Models\\Receipt',5859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',9940.00,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5863,7994,40842,200535,2,5860,'App\\Models\\Receipt',5860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',9315.00,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5864,7994,40842,200535,2,5861,'App\\Models\\Receipt',5861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',4620.02,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5865,7994,40842,200535,2,5862,'App\\Models\\Receipt',5862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',7194.06,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5866,7994,40842,200535,2,5863,'App\\Models\\Receipt',5863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',2620.00,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5867,7994,40842,200535,2,5864,'App\\Models\\Receipt',5864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1740.00,NULL,NULL,1,'2023-06-08 11:08:20','2023-06-08 11:08:20',NULL),(5868,7994,40842,200535,2,5865,'App\\Models\\Receipt',5865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1090.00,NULL,NULL,1,'2023-06-08 11:08:21','2023-06-08 11:08:21',NULL),(5869,7994,40842,200535,2,5866,'App\\Models\\Receipt',5866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',3000.00,NULL,NULL,1,'2023-06-08 11:08:21','2023-06-08 11:08:21',NULL),(5870,7994,40842,200535,2,5867,'App\\Models\\Receipt',5867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',270.00,NULL,NULL,1,'2023-06-08 11:08:21','2023-06-08 11:08:21',NULL),(5871,7994,40842,200535,2,5868,'App\\Models\\Receipt',5868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',6430.00,NULL,NULL,1,'2023-06-08 11:08:21','2023-06-08 11:08:21',NULL),(5872,7994,40842,200535,2,5869,'App\\Models\\Receipt',5869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',1365.00,NULL,NULL,1,'2023-06-08 11:08:21','2023-06-08 11:08:21',NULL),(5873,7994,40842,200535,2,5870,'App\\Models\\Receipt',5870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',4260.02,NULL,NULL,1,'2023-06-08 11:08:21','2023-06-08 11:08:21',NULL);
INSERT INTO `balance_libro` VALUES (5874,7994,40842,200535,2,5871,'App\\Models\\Receipt',5871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',790.02,NULL,NULL,1,'2023-06-08 11:08:21','2023-06-08 11:08:21',NULL),(5875,7994,40842,200535,2,5872,'App\\Models\\Receipt',5872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',5612.00,NULL,NULL,1,'2023-06-08 11:08:21','2023-06-08 11:08:21',NULL),(5876,7994,40842,200535,2,5873,'App\\Models\\Receipt',5873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1200.00,NULL,NULL,1,'2023-06-08 11:08:22','2023-06-08 11:08:22',NULL),(5877,7994,40842,200535,2,5874,'App\\Models\\Receipt',5874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',400.00,NULL,NULL,1,'2023-06-08 11:08:22','2023-06-08 11:08:22',NULL),(5878,7994,40842,200535,2,5875,'App\\Models\\Receipt',5875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',550.00,NULL,NULL,1,'2023-06-08 11:08:22','2023-06-08 11:08:22',NULL),(5879,7994,40842,200535,2,5876,'App\\Models\\Receipt',5876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',900.02,NULL,NULL,1,'2023-06-08 11:08:22','2023-06-08 11:08:22',NULL),(5880,7994,40842,200535,2,5877,'App\\Models\\Receipt',5877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',1480.00,NULL,NULL,1,'2023-06-08 11:08:22','2023-06-08 11:08:22',NULL),(5881,7994,40842,200535,2,5878,'App\\Models\\Receipt',5878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',1180.00,NULL,NULL,1,'2023-06-08 11:08:22','2023-06-08 11:08:22',NULL),(5882,7994,40842,200535,2,5879,'App\\Models\\Receipt',5879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',2240.00,NULL,NULL,1,'2023-06-08 11:08:22','2023-06-08 11:08:22',NULL),(5883,7994,40842,200535,2,5880,'App\\Models\\Receipt',5880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',10956.00,NULL,NULL,1,'2023-06-08 11:08:22','2023-06-08 11:08:22',NULL),(5884,7994,40842,200535,2,5881,'App\\Models\\Receipt',5881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',440.00,NULL,NULL,1,'2023-06-08 11:08:23','2023-06-08 11:08:23',NULL),(5885,7994,40842,200535,2,5882,'App\\Models\\Receipt',5882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',820.00,NULL,NULL,1,'2023-06-08 11:08:23','2023-06-08 11:08:23',NULL),(5886,7994,40842,200535,2,5883,'App\\Models\\Receipt',5883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',8604.04,NULL,NULL,1,'2023-06-08 11:08:23','2023-06-08 11:08:23',NULL),(5887,7994,40842,200535,2,5884,'App\\Models\\Receipt',5884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',9260.02,NULL,NULL,1,'2023-06-08 11:08:23','2023-06-08 11:08:23',NULL),(5888,7994,40842,200535,2,5885,'App\\Models\\Receipt',5885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',9260.02,NULL,NULL,1,'2023-06-08 11:08:23','2023-06-08 11:08:23',NULL),(5889,7994,40842,200535,2,5886,'App\\Models\\Receipt',5886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',750.06,NULL,NULL,1,'2023-06-08 11:08:23','2023-06-08 11:08:23',NULL),(5890,7994,40842,200535,2,5887,'App\\Models\\Receipt',5887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',2210.00,NULL,NULL,1,'2023-06-08 11:08:23','2023-06-08 11:08:23',NULL),(5891,7994,40842,200535,2,5888,'App\\Models\\Receipt',5888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',6900.00,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL),(5892,7994,40842,200535,2,5889,'App\\Models\\Receipt',5889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',1600.00,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL),(5893,7994,40842,200535,2,5890,'App\\Models\\Receipt',5890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1659.06,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL),(5894,7994,40842,200535,2,5891,'App\\Models\\Receipt',5891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1140.00,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL);
INSERT INTO `balance_libro` VALUES (5895,7994,40842,200535,2,5892,'App\\Models\\Receipt',5892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1659.06,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL),(5896,7994,40842,200535,2,5893,'App\\Models\\Receipt',5893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1320.00,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL),(5897,7994,40842,200535,2,5894,'App\\Models\\Receipt',5894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',2430.06,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL),(5898,7994,40842,200535,2,5895,'App\\Models\\Receipt',5895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1090.00,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL),(5899,7994,40842,200535,2,5896,'App\\Models\\Receipt',5896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1040.04,NULL,NULL,1,'2023-06-08 11:08:24','2023-06-08 11:08:24',NULL),(5900,7994,40842,200535,2,5897,'App\\Models\\Receipt',5897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',350.00,NULL,NULL,1,'2023-06-08 11:08:25','2023-06-08 11:08:25',NULL),(5901,7994,40842,200535,2,5898,'App\\Models\\Receipt',5898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',9590.00,NULL,NULL,1,'2023-06-08 11:08:25','2023-06-08 11:08:25',NULL),(5902,7994,40842,200535,2,5899,'App\\Models\\Receipt',5899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',10830.04,NULL,NULL,1,'2023-06-08 11:08:25','2023-06-08 11:08:25',NULL),(5903,7994,40842,200535,2,5900,'App\\Models\\Receipt',5900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',20300.00,NULL,NULL,1,'2023-06-08 11:08:25','2023-06-08 11:08:25',NULL),(5904,7994,40842,200535,2,5901,'App\\Models\\Receipt',5901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',2238.00,NULL,NULL,1,'2023-06-08 11:08:25','2023-06-08 11:08:25',NULL),(5905,7994,40842,200535,2,5902,'App\\Models\\Receipt',5902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1180.00,NULL,NULL,1,'2023-06-08 11:08:25','2023-06-08 11:08:25',NULL),(5906,7994,40842,200535,2,5903,'App\\Models\\Receipt',5903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',3202.02,NULL,NULL,1,'2023-06-08 11:08:25','2023-06-08 11:08:25',NULL),(5907,7994,40842,200535,2,5904,'App\\Models\\Receipt',5904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',600.00,NULL,NULL,1,'2023-06-08 11:08:25','2023-06-08 11:08:25',NULL),(5908,7994,40842,200535,2,5905,'App\\Models\\Receipt',5905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',7967.00,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5909,7994,40842,200535,2,5906,'App\\Models\\Receipt',5906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',13000.02,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5910,7994,40842,200535,2,5907,'App\\Models\\Receipt',5907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',819.00,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5911,7994,40842,200535,2,5908,'App\\Models\\Receipt',5908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1020.00,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5912,7994,40842,200535,2,5909,'App\\Models\\Receipt',5909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1020.00,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5913,7994,40842,200535,2,5910,'App\\Models\\Receipt',5910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',4382.00,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5914,7994,40842,200535,2,5911,'App\\Models\\Receipt',5911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1340.00,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5915,7994,40842,200535,2,5912,'App\\Models\\Receipt',5912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',5730.00,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL);
INSERT INTO `balance_libro` VALUES (5916,7994,40842,200535,2,5913,'App\\Models\\Receipt',5913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1969.04,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5917,7994,40842,200535,2,5914,'App\\Models\\Receipt',5914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',11300.04,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5918,7994,40842,200535,2,5915,'App\\Models\\Receipt',5915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',8130.00,NULL,NULL,1,'2023-06-08 11:08:26','2023-06-08 11:08:26',NULL),(5919,7994,40842,200535,2,5916,'App\\Models\\Receipt',5916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',8130.00,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5920,7994,40842,200535,2,5917,'App\\Models\\Receipt',5917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2000.02,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5921,7994,40842,200535,2,5918,'App\\Models\\Receipt',5918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',882.00,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5922,7994,40842,200535,2,5919,'App\\Models\\Receipt',5919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',882.00,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5923,7994,40842,200535,2,5920,'App\\Models\\Receipt',5920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',3090.00,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5924,7994,40842,200535,2,5921,'App\\Models\\Receipt',5921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',6865.04,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5925,7994,40842,200535,2,5922,'App\\Models\\Receipt',5922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',200.00,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5926,7994,40842,200535,2,5923,'App\\Models\\Receipt',5923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2000.02,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5927,7994,40842,200535,2,5924,'App\\Models\\Receipt',5924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',3090.00,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5928,7994,40842,200535,2,5925,'App\\Models\\Receipt',5925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',400.00,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5929,7994,40842,200535,2,5926,'App\\Models\\Receipt',5926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',870.00,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5930,7994,40842,200535,2,5927,'App\\Models\\Receipt',5927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2000.02,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5931,7994,40842,200535,2,5928,'App\\Models\\Receipt',5928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',5000.02,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5932,7994,40842,200535,2,5929,'App\\Models\\Receipt',5929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',13000.02,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5933,7994,40842,200535,2,5930,'App\\Models\\Receipt',5930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',15000.04,NULL,NULL,1,'2023-06-08 11:08:27','2023-06-08 11:08:27',NULL),(5934,7994,40842,200535,2,5931,'App\\Models\\Receipt',5931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',10000.04,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5935,7994,40842,200535,2,5932,'App\\Models\\Receipt',5932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1774.00,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5936,7994,40842,200535,2,5933,'App\\Models\\Receipt',5933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1690.04,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL);
INSERT INTO `balance_libro` VALUES (5937,7994,40842,200535,2,5934,'App\\Models\\Receipt',5934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',840.06,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5938,7994,40842,200535,2,5935,'App\\Models\\Receipt',5935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1160.00,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5939,7994,40842,200535,2,5936,'App\\Models\\Receipt',5936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',305.00,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5940,7994,40842,200535,2,5937,'App\\Models\\Receipt',5937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1600.04,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5941,7994,40842,200535,2,5938,'App\\Models\\Receipt',5938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1400.06,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5942,7994,40842,200535,2,5939,'App\\Models\\Receipt',5939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',790.02,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5943,7994,40842,200535,2,5940,'App\\Models\\Receipt',5940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1122.04,NULL,NULL,1,'2023-06-08 11:08:28','2023-06-08 11:08:28',NULL),(5944,7994,40842,200536,2,5941,'App\\Models\\Receipt',5941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1690.04,NULL,NULL,1,'2023-06-08 11:54:46','2023-06-08 11:54:46',NULL),(5945,7994,40842,200536,2,5942,'App\\Models\\Receipt',5942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1300.00,NULL,NULL,1,'2023-06-08 11:54:46','2023-06-08 11:54:46',NULL),(5946,7994,40842,200536,2,5943,'App\\Models\\Receipt',5943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1628.06,NULL,NULL,1,'2023-06-08 11:54:46','2023-06-08 11:54:46',NULL),(5947,7994,40842,200536,2,5944,'App\\Models\\Receipt',5944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',7080.00,NULL,NULL,1,'2023-06-08 11:54:46','2023-06-08 11:54:46',NULL),(5948,7994,40842,200536,2,5945,'App\\Models\\Receipt',5945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',720.02,NULL,NULL,1,'2023-06-08 11:54:46','2023-06-08 11:54:46',NULL),(5949,7994,40842,200536,2,5946,'App\\Models\\Receipt',5946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',3675.00,NULL,NULL,1,'2023-06-08 11:54:46','2023-06-08 11:54:46',NULL),(5950,7994,40842,200536,2,5947,'App\\Models\\Receipt',5947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',10800.00,NULL,NULL,1,'2023-06-08 11:54:46','2023-06-08 11:54:46',NULL),(5951,7994,40842,200536,2,5948,'App\\Models\\Receipt',5948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',2500.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5952,7994,40842,200536,2,5949,'App\\Models\\Receipt',5949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',510.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5953,7994,40842,200536,2,5950,'App\\Models\\Receipt',5950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',2990.06,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5954,7994,40842,200536,2,5951,'App\\Models\\Receipt',5951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',16340.02,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5955,7994,40842,200536,2,5952,'App\\Models\\Receipt',5952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',6900.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5956,7994,40842,200536,2,5953,'App\\Models\\Receipt',5953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1680.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5957,7994,40842,200536,2,5954,'App\\Models\\Receipt',5954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',610.02,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL);
INSERT INTO `balance_libro` VALUES (5958,7994,40842,200536,2,5955,'App\\Models\\Receipt',5955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',11840.04,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5959,7994,40842,200536,2,5956,'App\\Models\\Receipt',5956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1178.04,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5960,7994,40842,200536,2,5957,'App\\Models\\Receipt',5957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3780.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5961,7994,40842,200536,2,5958,'App\\Models\\Receipt',5958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3465.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5962,7994,40842,200536,2,5959,'App\\Models\\Receipt',5959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',4553.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5963,7994,40842,200536,2,5960,'App\\Models\\Receipt',5960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3780.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5964,7994,40842,200536,2,5961,'App\\Models\\Receipt',5961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',672.02,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5965,7994,40842,200536,2,5962,'App\\Models\\Receipt',5962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3080.06,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5966,7994,40842,200536,2,5963,'App\\Models\\Receipt',5963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3780.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5967,7994,40842,200536,2,5964,'App\\Models\\Receipt',5964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1331.00,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5968,7994,40842,200536,2,5965,'App\\Models\\Receipt',5965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',13340.04,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5969,7994,40842,200536,2,5966,'App\\Models\\Receipt',5966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',72000.02,NULL,NULL,1,'2023-06-08 11:54:47','2023-06-08 11:54:47',NULL),(5970,7994,40842,200536,2,5967,'App\\Models\\Receipt',5967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',20350.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5971,7994,40842,200536,2,5968,'App\\Models\\Receipt',5968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',355.00,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5972,7994,40842,200536,2,5969,'App\\Models\\Receipt',5969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1.00,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5973,7994,40842,200536,2,5970,'App\\Models\\Receipt',5970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',4000.00,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5974,7994,40842,200536,2,5971,'App\\Models\\Receipt',5971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',4890.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5975,7994,40842,200536,2,5972,'App\\Models\\Receipt',5972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',6245.00,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5976,7994,40842,200536,2,5973,'App\\Models\\Receipt',5973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',2515.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5977,7994,40842,200536,2,5974,'App\\Models\\Receipt',5974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1190.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5978,7994,40842,200536,2,5975,'App\\Models\\Receipt',5975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',430.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL);
INSERT INTO `balance_libro` VALUES (5979,7994,40842,200536,2,5976,'App\\Models\\Receipt',5976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',9100.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5980,7994,40842,200536,2,5977,'App\\Models\\Receipt',5977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1320.00,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5981,7994,40842,200536,2,5978,'App\\Models\\Receipt',5978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',3210.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5982,7994,40842,200536,2,5979,'App\\Models\\Receipt',5979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',3210.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5983,7994,40842,200536,2,5980,'App\\Models\\Receipt',5980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',2660.00,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5984,7994,40842,200536,2,5981,'App\\Models\\Receipt',5981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',2365.00,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5985,7994,40842,200536,2,5982,'App\\Models\\Receipt',5982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',3430.00,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5986,7994,40842,200536,2,5983,'App\\Models\\Receipt',5983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',2760.02,NULL,NULL,1,'2023-06-08 11:54:48','2023-06-08 11:54:48',NULL),(5987,7994,40842,200536,2,5984,'App\\Models\\Receipt',5984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',2700.06,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5988,7994,40842,200536,2,5985,'App\\Models\\Receipt',5985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',400.00,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5989,7994,40842,200536,2,5986,'App\\Models\\Receipt',5986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',3000.00,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5990,7994,40842,200536,2,5987,'App\\Models\\Receipt',5987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',7690.02,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5991,7994,40842,200536,2,5988,'App\\Models\\Receipt',5988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',930.00,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5992,7994,40842,200536,2,5989,'App\\Models\\Receipt',5989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',1620.04,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5993,7994,40842,200536,2,5990,'App\\Models\\Receipt',5990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',380.00,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5994,7994,40842,200536,2,5991,'App\\Models\\Receipt',5991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',5775.00,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5995,7994,40842,200536,2,5992,'App\\Models\\Receipt',5992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',5869.04,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5996,7994,40842,200536,2,5993,'App\\Models\\Receipt',5993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',7690.02,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5997,7994,40842,200536,2,5994,'App\\Models\\Receipt',5994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',11960.00,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5998,7994,40842,200536,2,5995,'App\\Models\\Receipt',5995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',5876.00,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(5999,7994,40842,200536,2,5996,'App\\Models\\Receipt',5996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',1400.06,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL);
INSERT INTO `balance_libro` VALUES (6000,7994,40842,200536,2,5997,'App\\Models\\Receipt',5997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',660.06,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(6001,7994,40842,200536,2,5998,'App\\Models\\Receipt',5998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',9340.00,NULL,NULL,1,'2023-06-08 11:54:49','2023-06-08 11:54:49',NULL),(6002,7994,40842,200536,2,5999,'App\\Models\\Receipt',5999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',9100.02,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6003,7994,40842,200536,2,6000,'App\\Models\\Receipt',6000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',12540.00,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6004,7994,40842,200536,2,6001,'App\\Models\\Receipt',6001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',9790.00,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6005,7994,40842,200536,2,6002,'App\\Models\\Receipt',6002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',2380.02,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6006,7994,40842,200536,2,6003,'App\\Models\\Receipt',6003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1900.00,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6007,7994,40842,200536,2,6004,'App\\Models\\Receipt',6004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1710.04,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6008,7994,40842,200536,2,6005,'App\\Models\\Receipt',6005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',500.04,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6009,7994,40842,200536,2,6006,'App\\Models\\Receipt',6006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',9600.04,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6010,7994,40842,200536,2,6007,'App\\Models\\Receipt',6007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2230.00,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6011,7994,40842,200536,2,6008,'App\\Models\\Receipt',6008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1340.00,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6012,7994,40842,200536,2,6009,'App\\Models\\Receipt',6009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1840.02,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6013,7994,40842,200536,2,6010,'App\\Models\\Receipt',6010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1800.04,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6014,7994,40842,200536,2,6011,'App\\Models\\Receipt',6011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1060.04,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6015,7994,40842,200536,2,6012,'App\\Models\\Receipt',6012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1050.00,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6016,7994,40842,200536,2,6013,'App\\Models\\Receipt',6013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',5180.02,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6017,7994,40842,200536,2,6014,'App\\Models\\Receipt',6014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',210.04,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6018,7994,40842,200536,2,6015,'App\\Models\\Receipt',6015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',3500.02,NULL,NULL,1,'2023-06-08 11:54:50','2023-06-08 11:54:50',NULL),(6019,7994,40842,200536,2,6016,'App\\Models\\Receipt',6016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',300.04,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6020,7994,40842,200536,2,6017,'App\\Models\\Receipt',6017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1200.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL);
INSERT INTO `balance_libro` VALUES (6021,7994,40842,200536,2,6018,'App\\Models\\Receipt',6018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',9600.04,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6022,7994,40842,200536,2,6019,'App\\Models\\Receipt',6019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',600.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6023,7994,40842,200536,2,6020,'App\\Models\\Receipt',6020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',8100.06,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6024,7994,40842,200536,2,6021,'App\\Models\\Receipt',6021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',5310.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6025,7994,40842,200536,2,6022,'App\\Models\\Receipt',6022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2075.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6026,7994,40842,200536,2,6023,'App\\Models\\Receipt',6023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1190.02,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6027,7994,40842,200536,2,6024,'App\\Models\\Receipt',6024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2075.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6028,7994,40842,200536,2,6025,'App\\Models\\Receipt',6025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',550.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6029,7994,40842,200536,2,6026,'App\\Models\\Receipt',6026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2670.02,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6030,7994,40842,200536,2,6027,'App\\Models\\Receipt',6027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',9590.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6031,7994,40842,200536,2,6028,'App\\Models\\Receipt',6028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2488.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6032,7994,40842,200536,2,6029,'App\\Models\\Receipt',6029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2950.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6033,7994,40842,200536,2,6030,'App\\Models\\Receipt',6030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',4720.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6034,7994,40842,200536,2,6031,'App\\Models\\Receipt',6031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',8100.06,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6035,7994,40842,200536,2,6032,'App\\Models\\Receipt',6032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',840.06,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6036,7994,40842,200536,2,6033,'App\\Models\\Receipt',6033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1360.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6037,7994,40842,200536,2,6034,'App\\Models\\Receipt',6034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',3062.30,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6038,7994,40842,200536,2,6035,'App\\Models\\Receipt',6035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',9513.04,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6039,7994,40842,200536,2,6036,'App\\Models\\Receipt',6036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',8000.00,NULL,NULL,1,'2023-06-08 11:54:51','2023-06-08 11:54:51',NULL),(6040,7994,40842,200536,2,6037,'App\\Models\\Receipt',6037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',6890.06,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6041,7994,40842,200536,2,6038,'App\\Models\\Receipt',6038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',6890.06,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL);
INSERT INTO `balance_libro` VALUES (6042,7994,40842,200536,2,6039,'App\\Models\\Receipt',6039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1250.00,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6043,7994,40842,200536,2,6040,'App\\Models\\Receipt',6040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',325.50,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6044,7994,40842,200536,2,6041,'App\\Models\\Receipt',6041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',3062.30,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6045,7994,40842,200536,2,6042,'App\\Models\\Receipt',6042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',9513.04,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6046,7994,40842,200536,2,6043,'App\\Models\\Receipt',6043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',550.00,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6047,7994,40842,200536,2,6044,'App\\Models\\Receipt',6044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',7530.00,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6048,7994,40842,200536,2,6045,'App\\Models\\Receipt',6045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',690.10,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6049,7994,40842,200536,2,6046,'App\\Models\\Receipt',6046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',300.04,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6050,7994,40842,200536,2,6047,'App\\Models\\Receipt',6047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',1200.00,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6051,7994,40842,200536,2,6048,'App\\Models\\Receipt',6048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',710.00,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6052,7994,40842,200536,2,6049,'App\\Models\\Receipt',6049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',2520.06,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6053,7994,40842,200536,2,6050,'App\\Models\\Receipt',6050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',980.00,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6054,7994,40842,200536,2,6051,'App\\Models\\Receipt',6051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1228.00,NULL,NULL,1,'2023-06-08 11:54:52','2023-06-08 11:54:52',NULL),(6055,7994,40842,200536,2,6052,'App\\Models\\Receipt',6052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1810.00,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6056,7994,40842,200536,2,6053,'App\\Models\\Receipt',6053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',2207.00,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6057,7994,40842,200536,2,6054,'App\\Models\\Receipt',6054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',470.00,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6058,7994,40842,200536,2,6055,'App\\Models\\Receipt',6055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1150.04,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6059,7994,40842,200536,2,6056,'App\\Models\\Receipt',6056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',2190.00,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6060,7994,40842,200536,2,6057,'App\\Models\\Receipt',6057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1600.04,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6061,7994,40842,200536,2,6058,'App\\Models\\Receipt',6058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',3364.06,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6062,7994,40842,200536,2,6059,'App\\Models\\Receipt',6059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',360.00,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL);
INSERT INTO `balance_libro` VALUES (6063,7994,40842,200536,2,6060,'App\\Models\\Receipt',6060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',7290.04,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6064,7994,40842,200536,2,6061,'App\\Models\\Receipt',6061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',900.02,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6065,7994,40842,200536,2,6062,'App\\Models\\Receipt',6062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',7285.02,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6066,7994,40842,200536,2,6063,'App\\Models\\Receipt',6063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',650.00,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6067,7994,40842,200536,2,6064,'App\\Models\\Receipt',6064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',12115.00,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6068,7994,40842,200536,2,6065,'App\\Models\\Receipt',6065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2751.04,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6069,7994,40842,200536,2,6066,'App\\Models\\Receipt',6066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',3520.02,NULL,NULL,1,'2023-06-08 11:54:53','2023-06-08 11:54:53',NULL),(6070,7994,40842,200536,2,6067,'App\\Models\\Receipt',6067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',3000.00,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6071,7994,40842,200536,2,6068,'App\\Models\\Receipt',6068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',710.00,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6072,7994,40842,200536,2,6069,'App\\Models\\Receipt',6069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2870.00,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6073,7994,40842,200536,2,6070,'App\\Models\\Receipt',6070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',7290.04,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6074,7994,40842,200536,2,6071,'App\\Models\\Receipt',6071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',710.00,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6075,7994,40842,200536,2,6072,'App\\Models\\Receipt',6072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',8538.75,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6076,7994,40842,200536,2,6073,'App\\Models\\Receipt',6073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2490.02,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6077,7994,40842,200536,2,6074,'App\\Models\\Receipt',6074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',4400.04,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6078,7994,40842,200536,2,6075,'App\\Models\\Receipt',6075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',30440.06,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6079,7994,40842,200536,2,6076,'App\\Models\\Receipt',6076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',860.04,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6080,7994,40842,200536,2,6077,'App\\Models\\Receipt',6077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1295.00,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6081,7994,40842,200536,2,6078,'App\\Models\\Receipt',6078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',7572.56,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6082,7994,40842,200536,2,6079,'App\\Models\\Receipt',6079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',7572.56,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6083,7994,40842,200536,2,6080,'App\\Models\\Receipt',6080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',4000.00,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL);
INSERT INTO `balance_libro` VALUES (6084,7994,40842,200536,2,6081,'App\\Models\\Receipt',6081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',545.04,NULL,NULL,1,'2023-06-08 11:54:54','2023-06-08 11:54:54',NULL),(6085,7994,40842,200536,2,6082,'App\\Models\\Receipt',6082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',9590.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6086,7994,40842,200536,2,6083,'App\\Models\\Receipt',6083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',220.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6087,7994,40842,200536,2,6084,'App\\Models\\Receipt',6084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',2572.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6088,7994,40842,200536,2,6085,'App\\Models\\Receipt',6085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1000.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6089,7994,40842,200536,2,6086,'App\\Models\\Receipt',6086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',6200.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6090,7994,40842,200536,2,6087,'App\\Models\\Receipt',6087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',550.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6091,7994,40842,200536,2,6088,'App\\Models\\Receipt',6088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',4570.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6092,7994,40842,200536,2,6089,'App\\Models\\Receipt',6089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',315.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6093,7994,40842,200536,2,6090,'App\\Models\\Receipt',6090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',3000.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6094,7994,40842,200536,2,6091,'App\\Models\\Receipt',6091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',450.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6095,7994,40842,200536,2,6092,'App\\Models\\Receipt',6092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',310.00,NULL,NULL,1,'2023-06-08 11:54:55','2023-06-08 11:54:55',NULL),(6096,7994,40842,200536,2,6093,'App\\Models\\Receipt',6093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',16200.00,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL),(6097,7994,40842,200536,2,6094,'App\\Models\\Receipt',6094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1050.00,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL),(6098,7994,40842,200536,2,6095,'App\\Models\\Receipt',6095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1140.00,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL),(6099,7994,40842,200536,2,6096,'App\\Models\\Receipt',6096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',18400.02,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL),(6100,7994,40842,200536,2,6097,'App\\Models\\Receipt',6097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',7000.04,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL),(6101,7994,40842,200536,2,6098,'App\\Models\\Receipt',6098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',12400.04,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL),(6102,7994,40842,200536,2,6099,'App\\Models\\Receipt',6099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',7070.00,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL),(6103,7994,40842,200536,2,6100,'App\\Models\\Receipt',6100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',4870.04,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL),(6104,7994,40842,200536,2,6101,'App\\Models\\Receipt',6101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',350.00,NULL,NULL,1,'2023-06-08 11:54:56','2023-06-08 11:54:56',NULL);
INSERT INTO `balance_libro` VALUES (6105,7994,40842,200536,2,6102,'App\\Models\\Receipt',6102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',7000.04,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6106,7994,40842,200536,2,6103,'App\\Models\\Receipt',6103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',3040.00,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6107,7994,40842,200536,2,6104,'App\\Models\\Receipt',6104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',495.02,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6108,7994,40842,200536,2,6105,'App\\Models\\Receipt',6105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',2260.00,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6109,7994,40842,200536,2,6106,'App\\Models\\Receipt',6106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',600.00,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6110,7994,40842,200536,2,6107,'App\\Models\\Receipt',6107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',2000.02,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6111,7994,40842,200536,2,6108,'App\\Models\\Receipt',6108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',2480.00,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6112,7994,40842,200536,2,6109,'App\\Models\\Receipt',6109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',750.06,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6113,7994,40842,200536,2,6110,'App\\Models\\Receipt',6110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',13164.52,NULL,NULL,1,'2023-06-08 11:54:57','2023-06-08 11:54:57',NULL),(6114,7994,40842,200536,2,6111,'App\\Models\\Receipt',6111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',430.02,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6115,7994,40842,200536,2,6112,'App\\Models\\Receipt',6112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',600.00,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6116,7994,40842,200536,2,6113,'App\\Models\\Receipt',6113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1440.04,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6117,7994,40842,200536,2,6114,'App\\Models\\Receipt',6114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',4543.00,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6118,7994,40842,200536,2,6115,'App\\Models\\Receipt',6115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',14420.00,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6119,7994,40842,200536,2,6116,'App\\Models\\Receipt',6116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',5881.00,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6120,7994,40842,200536,2,6117,'App\\Models\\Receipt',6117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1940.00,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6121,7994,40842,200536,2,6118,'App\\Models\\Receipt',6118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',270.00,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6122,7994,40842,200536,2,6119,'App\\Models\\Receipt',6119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',9040.06,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6123,7994,40842,200536,2,6120,'App\\Models\\Receipt',6120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',9530.04,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6124,7994,40842,200536,2,6121,'App\\Models\\Receipt',6121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1200.00,NULL,NULL,1,'2023-06-08 11:54:58','2023-06-08 11:54:58',NULL),(6125,7994,40842,200536,2,6122,'App\\Models\\Receipt',6122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',9860.00,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL);
INSERT INTO `balance_libro` VALUES (6126,7994,40842,200536,2,6123,'App\\Models\\Receipt',6123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',6960.00,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6127,7994,40842,200536,2,6124,'App\\Models\\Receipt',6124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',3565.02,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6128,7994,40842,200536,2,6125,'App\\Models\\Receipt',6125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',2710.40,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6129,7994,40842,200536,2,6126,'App\\Models\\Receipt',6126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1920.00,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6130,7994,40842,200536,2,6127,'App\\Models\\Receipt',6127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',14139.25,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6131,7994,40842,200536,2,6128,'App\\Models\\Receipt',6128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1260.02,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6132,7994,40842,200536,2,6129,'App\\Models\\Receipt',6129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',2944.00,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6133,7994,40842,200536,2,6130,'App\\Models\\Receipt',6130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1430.00,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6134,7994,40842,200536,2,6131,'App\\Models\\Receipt',6131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1330.04,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6135,7994,40842,200536,2,6132,'App\\Models\\Receipt',6132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',3050.02,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6136,7994,40842,200536,2,6133,'App\\Models\\Receipt',6133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',440.00,NULL,NULL,1,'2023-06-08 11:54:59','2023-06-08 11:54:59',NULL),(6137,7994,40842,200536,2,6134,'App\\Models\\Receipt',6134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',7887.02,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6138,7994,40842,200536,2,6135,'App\\Models\\Receipt',6135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',6570.02,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6139,7994,40842,200536,2,6136,'App\\Models\\Receipt',6136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',7000.04,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6140,7994,40842,200536,2,6137,'App\\Models\\Receipt',6137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1100.02,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6141,7994,40842,200536,2,6138,'App\\Models\\Receipt',6138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',3688.04,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6142,7994,40842,200536,2,6139,'App\\Models\\Receipt',6139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',2734.04,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6143,7994,40842,200536,2,6140,'App\\Models\\Receipt',6140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',3013.04,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6144,7994,40842,200536,2,6141,'App\\Models\\Receipt',6141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',2360.04,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6145,7994,40842,200536,2,6142,'App\\Models\\Receipt',6142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',3135.00,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6146,7994,40842,200536,2,6143,'App\\Models\\Receipt',6143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',3540.00,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL);
INSERT INTO `balance_libro` VALUES (6147,7994,40842,200536,2,6144,'App\\Models\\Receipt',6144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',850.00,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6148,7994,40842,200536,2,6145,'App\\Models\\Receipt',6145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',2370.00,NULL,NULL,1,'2023-06-08 11:55:00','2023-06-08 11:55:00',NULL),(6149,7994,40842,200536,2,6146,'App\\Models\\Receipt',6146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',4785.55,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6150,7994,40842,200536,2,6147,'App\\Models\\Receipt',6147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',7640.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6151,7994,40842,200536,2,6148,'App\\Models\\Receipt',6148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',645.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6152,7994,40842,200536,2,6149,'App\\Models\\Receipt',6149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',2880.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6153,7994,40842,200536,2,6150,'App\\Models\\Receipt',6150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',955.50,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6154,7994,40842,200536,2,6151,'App\\Models\\Receipt',6151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',5376.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6155,7994,40842,200536,2,6152,'App\\Models\\Receipt',6152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',12100.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6156,7994,40842,200536,2,6153,'App\\Models\\Receipt',6153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1900.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6157,7994,40842,200536,2,6154,'App\\Models\\Receipt',6154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',10100.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6158,7994,40842,200536,2,6155,'App\\Models\\Receipt',6155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',12100.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6159,7994,40842,200536,2,6156,'App\\Models\\Receipt',6156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',3000.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6160,7994,40842,200536,2,6157,'App\\Models\\Receipt',6157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',735.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6161,7994,40842,200536,2,6158,'App\\Models\\Receipt',6158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',3000.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6162,7994,40842,200536,2,6159,'App\\Models\\Receipt',6159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',2830.04,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6163,7994,40842,200536,2,6160,'App\\Models\\Receipt',6160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',4050.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6164,7994,40842,200536,2,6161,'App\\Models\\Receipt',6161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',10944.00,NULL,NULL,1,'2023-06-08 11:55:01','2023-06-08 11:55:01',NULL),(6165,7994,40842,200536,2,6162,'App\\Models\\Receipt',6162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',7000.04,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6166,7994,40842,200536,2,6163,'App\\Models\\Receipt',6163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',2580.02,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6167,7994,40842,200536,2,6164,'App\\Models\\Receipt',6164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',787.04,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL);
INSERT INTO `balance_libro` VALUES (6168,7994,40842,200536,2,6165,'App\\Models\\Receipt',6165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',3340.00,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6169,7994,40842,200536,2,6166,'App\\Models\\Receipt',6166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',1405.00,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6170,7994,40842,200536,2,6167,'App\\Models\\Receipt',6167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',4170.02,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6171,7994,40842,200536,2,6168,'App\\Models\\Receipt',6168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',11583.00,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6172,7994,40842,200536,2,6169,'App\\Models\\Receipt',6169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',42015.50,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6173,7994,40842,200536,2,6170,'App\\Models\\Receipt',6170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',15000.04,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6174,7994,40842,200536,2,6171,'App\\Models\\Receipt',6171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',1970.00,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6175,7994,40842,200536,2,6172,'App\\Models\\Receipt',6172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',9950.00,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6176,7994,40842,200536,2,6173,'App\\Models\\Receipt',6173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',2370.00,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6177,7994,40842,200536,2,6174,'App\\Models\\Receipt',6174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',10100.00,NULL,NULL,1,'2023-06-08 11:55:02','2023-06-08 11:55:02',NULL),(6178,7994,40842,200536,2,6175,'App\\Models\\Receipt',6175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',4460.00,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6179,7994,40842,200536,2,6176,'App\\Models\\Receipt',6176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',21070.04,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6180,7994,40842,200536,2,6177,'App\\Models\\Receipt',6177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',25000.00,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6181,7994,40842,200536,2,6178,'App\\Models\\Receipt',6178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',2970.00,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6182,7994,40842,200536,2,6179,'App\\Models\\Receipt',6179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',3600.00,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6183,7994,40842,200536,2,6180,'App\\Models\\Receipt',6180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',3600.00,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6184,7994,40842,200536,2,6181,'App\\Models\\Receipt',6181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',500.04,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6185,7994,40842,200536,2,6182,'App\\Models\\Receipt',6182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',2850.02,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6186,7994,40842,200536,2,6183,'App\\Models\\Receipt',6183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',2553.80,NULL,NULL,1,'2023-06-08 11:55:03','2023-06-08 11:55:03',NULL),(6187,7994,40842,200536,2,6184,'App\\Models\\Receipt',6184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',245.00,NULL,NULL,1,'2023-06-08 11:55:04','2023-06-08 11:55:04',NULL);
INSERT INTO `balance_libro` VALUES (6188,7994,40842,200536,2,6185,'App\\Models\\Receipt',6185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',3365.02,NULL,NULL,1,'2023-06-08 11:55:04','2023-06-08 11:55:04',NULL),(6189,7994,40842,200536,2,6186,'App\\Models\\Receipt',6186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1090.00,NULL,NULL,1,'2023-06-08 11:55:04','2023-06-08 11:55:04',NULL),(6190,7994,40842,200536,2,6187,'App\\Models\\Receipt',6187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',12540.00,NULL,NULL,1,'2023-06-08 11:55:04','2023-06-08 11:55:04',NULL),(6191,7994,40842,200536,2,6188,'App\\Models\\Receipt',6188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',440.00,NULL,NULL,1,'2023-06-08 11:55:04','2023-06-08 11:55:04',NULL),(6192,7994,40842,200536,2,6189,'App\\Models\\Receipt',6189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',4700.00,NULL,NULL,1,'2023-06-08 11:55:04','2023-06-08 11:55:04',NULL),(6193,7994,40842,200536,2,6190,'App\\Models\\Receipt',6190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',10540.04,NULL,NULL,1,'2023-06-08 11:55:04','2023-06-08 11:55:04',NULL),(6194,7994,40842,200536,2,6191,'App\\Models\\Receipt',6191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',5000.02,NULL,NULL,1,'2023-06-08 11:55:04','2023-06-08 11:55:04',NULL),(6195,7994,40842,200536,2,6192,'App\\Models\\Receipt',6192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',9100.02,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6196,7994,40842,200536,2,6193,'App\\Models\\Receipt',6193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',400.00,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6197,7994,40842,200536,2,6194,'App\\Models\\Receipt',6194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',880.04,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6198,7994,40842,200536,2,6195,'App\\Models\\Receipt',6195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',2150.00,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6199,7994,40842,200536,2,6196,'App\\Models\\Receipt',6196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',15000.04,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6200,7994,40842,200536,2,6197,'App\\Models\\Receipt',6197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',8325.00,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6201,7994,40842,200536,2,6198,'App\\Models\\Receipt',6198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',4040.04,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6202,7994,40842,200536,2,6199,'App\\Models\\Receipt',6199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',1470.00,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6203,7994,40842,200536,2,6200,'App\\Models\\Receipt',6200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',1190.02,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6204,7994,40842,200536,2,6201,'App\\Models\\Receipt',6201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',2262.02,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6205,7994,40842,200536,2,6202,'App\\Models\\Receipt',6202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',1457.02,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6206,7994,40842,200536,2,6203,'App\\Models\\Receipt',6203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',3817.00,NULL,NULL,1,'2023-06-08 11:55:05','2023-06-08 11:55:05',NULL),(6207,7994,40842,200536,2,6204,'App\\Models\\Receipt',6204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',3727.50,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6208,7994,40842,200536,2,6205,'App\\Models\\Receipt',6205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',3750.04,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL);
INSERT INTO `balance_libro` VALUES (6209,7994,40842,200536,2,6206,'App\\Models\\Receipt',6206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',9920.00,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6210,7994,40842,200536,2,6207,'App\\Models\\Receipt',6207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',8765.02,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6211,7994,40842,200536,2,6208,'App\\Models\\Receipt',6208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',570.06,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6212,7994,40842,200536,2,6209,'App\\Models\\Receipt',6209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',12245.06,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6213,7994,40842,200536,2,6210,'App\\Models\\Receipt',6210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',440.00,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6214,7994,40842,200536,2,6211,'App\\Models\\Receipt',6211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',670.00,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6215,7994,40842,200536,2,6212,'App\\Models\\Receipt',6212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1110.00,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6216,7994,40842,200536,2,6213,'App\\Models\\Receipt',6213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',798.04,NULL,NULL,1,'2023-06-08 11:55:06','2023-06-08 11:55:06',NULL),(6217,7994,40842,200536,2,6214,'App\\Models\\Receipt',6214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',590.04,NULL,NULL,1,'2023-06-08 11:55:07','2023-06-08 11:55:07',NULL),(6218,7994,40842,200536,2,6215,'App\\Models\\Receipt',6215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1586.04,NULL,NULL,1,'2023-06-08 11:55:07','2023-06-08 11:55:07',NULL),(6219,7994,40842,200536,2,6216,'App\\Models\\Receipt',6216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',270.00,NULL,NULL,1,'2023-06-08 11:55:07','2023-06-08 11:55:07',NULL),(6220,7994,40842,200536,2,6217,'App\\Models\\Receipt',6217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',510.00,NULL,NULL,1,'2023-06-08 11:55:07','2023-06-08 11:55:07',NULL),(6221,7994,40842,200536,2,6218,'App\\Models\\Receipt',6218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',5440.08,NULL,NULL,1,'2023-06-08 11:55:07','2023-06-08 11:55:07',NULL),(6222,7994,40842,200536,2,6219,'App\\Models\\Receipt',6219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2500.00,NULL,NULL,1,'2023-06-08 11:55:07','2023-06-08 11:55:07',NULL),(6223,7994,40842,200536,2,6220,'App\\Models\\Receipt',6220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',270.00,NULL,NULL,1,'2023-06-08 11:55:07','2023-06-08 11:55:07',NULL),(6224,7994,40842,200536,2,6221,'App\\Models\\Receipt',6221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',7412.00,NULL,NULL,1,'2023-06-08 11:55:07','2023-06-08 11:55:07',NULL),(6225,7994,40842,200536,2,6222,'App\\Models\\Receipt',6222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',7600.02,NULL,NULL,1,'2023-06-08 11:55:08','2023-06-08 11:55:08',NULL),(6226,7994,40842,200536,2,6223,'App\\Models\\Receipt',6223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',270.00,NULL,NULL,1,'2023-06-08 11:55:08','2023-06-08 11:55:08',NULL),(6227,7994,40842,200536,2,6224,'App\\Models\\Receipt',6224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2500.00,NULL,NULL,1,'2023-06-08 11:55:08','2023-06-08 11:55:08',NULL),(6228,7994,40842,200536,2,6225,'App\\Models\\Receipt',6225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1225.00,NULL,NULL,1,'2023-06-08 11:55:08','2023-06-08 11:55:08',NULL),(6229,7994,40842,200536,2,6226,'App\\Models\\Receipt',6226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2580.02,NULL,NULL,1,'2023-06-08 11:55:08','2023-06-08 11:55:08',NULL);
INSERT INTO `balance_libro` VALUES (6230,7994,40842,200536,2,6227,'App\\Models\\Receipt',6227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1440.04,NULL,NULL,1,'2023-06-08 11:55:08','2023-06-08 11:55:08',NULL),(6231,7994,40842,200537,2,6228,'App\\Models\\Receipt',6228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',8052.00,NULL,NULL,1,'2023-06-08 12:29:13','2023-06-08 12:29:13',NULL),(6232,7994,40842,200537,2,6229,'App\\Models\\Receipt',6229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2037.02,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6233,7994,40842,200537,2,6230,'App\\Models\\Receipt',6230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1449.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6234,7994,40842,200537,2,6231,'App\\Models\\Receipt',6231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',15680.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6235,7994,40842,200537,2,6232,'App\\Models\\Receipt',6232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',8052.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6236,7994,40842,200537,2,6233,'App\\Models\\Receipt',6233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1480.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6237,7994,40842,200537,2,6234,'App\\Models\\Receipt',6234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',13147.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6238,7994,40842,200537,2,6235,'App\\Models\\Receipt',6235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1700.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6239,7994,40842,200537,2,6236,'App\\Models\\Receipt',6236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',7320.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6240,7994,40842,200537,2,6237,'App\\Models\\Receipt',6237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',9920.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6241,7994,40842,200537,2,6238,'App\\Models\\Receipt',6238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1300.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6242,7994,40842,200537,2,6239,'App\\Models\\Receipt',6239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1879.02,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6243,7994,40842,200537,2,6240,'App\\Models\\Receipt',6240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',50.02,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6244,7994,40842,200537,2,6241,'App\\Models\\Receipt',6241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',4290.06,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6245,7994,40842,200537,2,6242,'App\\Models\\Receipt',6242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2640.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6246,7994,40842,200537,2,6243,'App\\Models\\Receipt',6243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',13360.02,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6247,7994,40842,200537,2,6244,'App\\Models\\Receipt',6244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',10600.00,NULL,NULL,1,'2023-06-08 12:29:14','2023-06-08 12:29:14',NULL),(6248,7994,40842,200537,2,6245,'App\\Models\\Receipt',6245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',12300.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6249,7994,40842,200537,2,6246,'App\\Models\\Receipt',6246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',8000.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6250,7994,40842,200537,2,6247,'App\\Models\\Receipt',6247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',9720.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL);
INSERT INTO `balance_libro` VALUES (6251,7994,40842,200537,2,6248,'App\\Models\\Receipt',6248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',9720.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6252,7994,40842,200537,2,6249,'App\\Models\\Receipt',6249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',10750.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6253,7994,40842,200537,2,6250,'App\\Models\\Receipt',6250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',15022.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6254,7994,40842,200537,2,6251,'App\\Models\\Receipt',6251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',4610.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6255,7994,40842,200537,2,6252,'App\\Models\\Receipt',6252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1530.04,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6256,7994,40842,200537,2,6253,'App\\Models\\Receipt',6253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',750.06,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6257,7994,40842,200537,2,6254,'App\\Models\\Receipt',6254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',750.06,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6258,7994,40842,200537,2,6255,'App\\Models\\Receipt',6255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3828.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6259,7994,40842,200537,2,6256,'App\\Models\\Receipt',6256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',10170.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6260,7994,40842,200537,2,6257,'App\\Models\\Receipt',6257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2130.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6261,7994,40842,200537,2,6258,'App\\Models\\Receipt',6258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1470.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6262,7994,40842,200537,2,6259,'App\\Models\\Receipt',6259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2709.04,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6263,7994,40842,200537,2,6260,'App\\Models\\Receipt',6260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',670.00,NULL,NULL,1,'2023-06-08 12:29:15','2023-06-08 12:29:15',NULL),(6264,7994,40842,200537,2,6261,'App\\Models\\Receipt',6261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',10170.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6265,7994,40842,200537,2,6262,'App\\Models\\Receipt',6262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',4035.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6266,7994,40842,200537,2,6263,'App\\Models\\Receipt',6263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',230.04,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6267,7994,40842,200537,2,6264,'App\\Models\\Receipt',6264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',4315.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6268,7994,40842,200537,2,6265,'App\\Models\\Receipt',6265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1900.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6269,7994,40842,200537,2,6266,'App\\Models\\Receipt',6266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3885.04,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6270,7994,40842,200537,2,6267,'App\\Models\\Receipt',6267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',360.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6271,7994,40842,200537,2,6268,'App\\Models\\Receipt',6268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2690.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL);
INSERT INTO `balance_libro` VALUES (6272,7994,40842,200537,2,6269,'App\\Models\\Receipt',6269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3270.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6273,7994,40842,200537,2,6270,'App\\Models\\Receipt',6270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3595.06,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6274,7994,40842,200537,2,6271,'App\\Models\\Receipt',6271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1470.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6275,7994,40842,200537,2,6272,'App\\Models\\Receipt',6272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',7160.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6276,7994,40842,200537,2,6273,'App\\Models\\Receipt',6273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',7290.04,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6277,7994,40842,200537,2,6274,'App\\Models\\Receipt',6274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2780.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6278,7994,40842,200537,2,6275,'App\\Models\\Receipt',6275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2550.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6279,7994,40842,200537,2,6276,'App\\Models\\Receipt',6276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',7790.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6280,7994,40842,200537,2,6277,'App\\Models\\Receipt',6277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1685.02,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6281,7994,40842,200537,2,6278,'App\\Models\\Receipt',6278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2170.00,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6282,7994,40842,200537,2,6279,'App\\Models\\Receipt',6279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',900.02,NULL,NULL,1,'2023-06-08 12:29:16','2023-06-08 12:29:16',NULL),(6283,7994,40842,200537,2,6280,'App\\Models\\Receipt',6280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',7630.00,NULL,NULL,1,'2023-06-08 12:29:17','2023-06-08 12:29:17',NULL),(6284,7994,40842,200537,2,6281,'App\\Models\\Receipt',6281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',720.02,NULL,NULL,1,'2023-06-08 12:29:17','2023-06-08 12:29:17',NULL),(6285,7994,40842,200537,2,6282,'App\\Models\\Receipt',6282,NULL,N