-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-32854023-2
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-04-04 23:46:31','Actividad Generica 1','000001',NULL),(2,NULL,'2021-04-04 23:46:31','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,'2021-12-04 15:28:44','2021-12-04 15:28:44',NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,'2021-12-04 15:33:29','2021-12-04 15:33:29',NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,'2021-12-04 15:40:48','2021-12-04 15:40:48',NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,'2021-12-04 15:41:21','2021-12-04 15:41:21',NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,'2021-12-04 15:41:42','2021-12-04 15:41:42',NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,'2021-12-04 15:42:03','2021-12-04 15:42:03',NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,'2021-12-04 15:42:20','2021-12-04 15:42:20',NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,'2021-12-04 15:42:40','2021-12-04 15:42:40',NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,'2021-12-04 15:42:58','2021-12-04 15:42:58',NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,'2021-12-04 15:43:14','2021-12-04 15:43:14',NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,'2021-12-04 15:43:38','2021-12-04 15:43:38',NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,'2021-12-04 15:44:12','2021-12-04 15:44:12',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,'2021-12-04 15:44:28','2021-12-04 15:44:28',NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL),('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,'2023-07-09 18:25:00','2023-07-09 18:25:00',NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,'2023-07-09 18:28:16','2023-07-09 18:28:16',NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,'2023-07-09 18:28:32','2023-07-09 18:28:32',NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL),('2023-11','2023-11',2023,11,'2023-11-01','2023-11-30',2816.0628,'2024-04-13 14:31:47','2024-04-13 14:31:47',NULL),('2023-12','2023-12',2023,12,'2023-12-01','2023-12-31',3533.1922,'2024-04-13 14:37:32','2024-04-13 14:37:32',NULL),('2024-1','2024-01',2024,1,'2024-01-01','2024-01-31',4261.5324,'2024-04-13 14:37:54','2024-04-13 14:37:54',NULL),('2024-2','2024-02',2024,2,'2024-02-01','2024-02-28',4825.7881,'2024-04-13 14:38:17','2024-04-13 14:38:17',NULL),('2024-3','2024-03',2024,3,'2024-03-01','2024-03-31',5357.0929,'2024-04-13 14:38:37','2024-04-13 14:38:37',NULL),('2024-4','2024-04',2024,4,'2024-04-01','2024-04-30',5830.2271,'2025-05-30 20:30:15','2025-05-30 20:30:15',NULL),('2024-5','2024-05',2024,5,'2024-05-01','2024-05-31',6073.7165,'2025-05-30 20:30:32','2025-05-30 20:30:32',NULL),('2024-6','2024-06',2024,6,'2024-06-01','2024-06-30',6351.7145,'2025-05-30 20:30:51','2025-05-30 20:30:51',NULL),('2024-7','2024-07',2024,7,'2024-07-01','2024-07-31',6607.7479,'2025-05-30 20:31:07','2025-05-30 20:31:07',NULL),('2024-8','2024-08',2024,8,'2024-08-01','2024-08-31',6883.4412,'2025-05-30 20:31:23','2025-05-30 20:31:23',NULL),('2024-9','2024-09',2024,9,'2024-09-01','2024-09-30',7122.2421,'2025-05-30 20:31:38','2025-05-30 20:31:38',NULL),('2024-10','2024-10',2024,10,'2024-10-01','2024-10-31',7313.9542,'2025-05-30 20:31:53','2025-05-30 20:31:53',NULL),('2024-11','2024-11',2024,11,'2024-11-01','2024-11-30',7491.4314,'2025-05-30 20:32:07','2025-05-30 20:32:07',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2024-12','2024-12',2024,12,'2024-12-01','2024-12-31',7694.0075,'2025-05-30 20:32:26','2025-05-30 20:32:26',NULL),('2025-1','2025-01',2025,1,'2025-01-01','2025-01-31',7864.1257,'2025-08-15 21:34:53','2025-08-15 21:34:53',NULL),('2025-2','2025-02',2025,2,'2025-02-01','2025-02-28',8052.9927,'2025-08-15 21:35:15','2025-08-15 21:35:15',NULL),('2025-3','2025-03',2025,3,'2025-03-01','2025-03-31',8353.3158,'2025-08-15 21:35:47','2025-08-15 21:35:47',NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Vallejos211',NULL,1,40720,'2023-06-19'),(2,NULL,'Vallejos211',NULL,1,40720,'2023-07-09'),(3,NULL,'Vallejos211',NULL,1,40720,'2023-07-09'),(4,NULL,'Vallejos211',NULL,1,40720,'2023-07-09'),(5,NULL,'Vallejos211',NULL,1,40720,'2023-07-10'),(6,NULL,'Vallejos211',NULL,1,40720,'2024-08-25'),(7,NULL,'Vallejos211',NULL,1,40720,'2024-08-26'),(8,NULL,'Vallejos211',NULL,1,40720,'2024-08-26'),(9,NULL,'Vallejos211',NULL,1,40720,'2024-08-26');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4293 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,3666,40720,1527,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',0.00,NULL,NULL,1,'2021-08-14 12:25:13','2021-08-14 12:25:13',NULL),(2,3666,40720,1527,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',0.00,NULL,NULL,1,'2021-08-14 12:25:13','2021-08-14 12:25:13',NULL),(3,3666,40720,1527,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',4741.01,NULL,NULL,1,'2021-08-14 12:31:42','2021-08-14 12:31:42',NULL),(4,3666,40720,1527,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',19425.04,NULL,NULL,1,'2021-08-14 12:31:42','2021-08-14 12:31:42',NULL),(5,3666,40720,1528,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',0.00,NULL,NULL,1,'2021-08-16 11:09:34','2021-08-16 11:09:34',NULL),(6,3666,40720,1528,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',0.00,NULL,NULL,1,'2021-08-16 11:09:34','2021-08-16 11:09:34',NULL),(7,3666,40720,1529,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',0.00,NULL,NULL,1,'2021-08-16 11:22:59','2021-08-16 11:22:59',NULL),(8,3666,40720,1529,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',0.00,NULL,NULL,1,'2021-08-16 11:22:59','2021-08-16 11:22:59',NULL),(9,3666,40720,1530,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',0.00,NULL,NULL,1,'2021-08-16 11:22:59','2021-08-16 11:22:59',NULL),(10,3666,40720,1530,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',0.00,NULL,NULL,1,'2021-08-16 11:22:59','2021-08-16 11:22:59',NULL),(11,3666,40720,1531,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',45000.00,NULL,NULL,1,'2021-08-16 11:36:29','2021-08-16 11:36:29',NULL),(12,3666,40720,1531,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',13086.00,NULL,NULL,1,'2021-08-16 11:36:29','2021-08-16 11:36:29',NULL),(13,3666,40720,1531,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',162440.00,NULL,NULL,1,'2021-08-16 11:36:29','2021-08-16 11:36:29',NULL),(14,3666,40720,1527,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',45000.00,NULL,NULL,1,'2021-08-16 17:00:16','2021-08-16 17:00:16',NULL),(15,3666,40720,1527,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',13086.00,NULL,NULL,1,'2021-08-16 17:00:16','2021-08-16 17:00:16',NULL),(16,3666,40720,1528,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',13086.00,NULL,NULL,1,'2021-08-16 17:00:27','2021-08-16 17:00:27',NULL),(17,3666,40720,1528,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',45000.00,NULL,NULL,1,'2021-08-16 17:00:27','2021-08-16 17:00:27',NULL),(18,3666,40720,1529,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',45000.00,NULL,NULL,1,'2021-08-16 17:00:37','2021-08-16 17:00:37',NULL),(19,3666,40720,1529,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',13086.00,NULL,NULL,1,'2021-08-16 17:00:37','2021-08-16 17:00:37',NULL),(20,3666,40720,1530,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',13086.00,NULL,NULL,1,'2021-08-16 17:00:37','2021-08-16 17:00:37',NULL),(21,3666,40720,1530,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',45000.00,NULL,NULL,1,'2021-08-16 17:00:37','2021-08-16 17:00:37',NULL),(22,3666,40720,1532,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',13086.00,NULL,NULL,1,'2021-08-16 17:18:32','2021-08-16 17:18:32',NULL);
INSERT INTO `balance_libro` VALUES (23,3666,40720,1532,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',45000.00,NULL,NULL,1,'2021-08-16 17:18:32','2021-08-16 17:18:32',NULL),(24,3666,40720,1533,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',45000.00,NULL,NULL,1,'2021-08-16 17:18:32','2021-08-16 17:18:32',NULL),(25,3666,40720,1533,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',18235.43,NULL,NULL,1,'2021-08-16 17:18:32','2021-08-16 17:18:32',NULL),(26,3666,40720,1534,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',18235.43,NULL,NULL,1,'2021-08-16 17:18:32','2021-08-16 17:18:32',NULL),(27,3666,40720,1534,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',45000.00,NULL,NULL,1,'2021-08-16 17:18:32','2021-08-16 17:18:32',NULL),(28,3666,40720,1535,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-12','2020-02-12',45000.00,NULL,NULL,1,'2021-08-16 17:18:32','2021-09-15 19:26:30','2021-09-15 19:26:30'),(29,3666,40720,1535,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',18235.43,NULL,NULL,1,'2021-08-16 17:18:32','2021-08-16 17:18:32',NULL),(30,3666,40720,1542,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',45000.00,NULL,NULL,1,'2021-08-16 17:18:32','2021-08-16 17:18:32',NULL),(31,3666,40720,1542,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',18235.43,NULL,NULL,1,'2021-08-16 17:18:33','2021-08-16 17:18:33',NULL),(32,3666,40720,1543,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',18235.43,NULL,NULL,1,'2021-08-16 17:18:33','2021-08-16 17:18:33',NULL),(33,3666,40720,1543,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',45000.00,NULL,NULL,1,'2021-08-16 17:18:33','2021-08-16 17:18:33',NULL),(34,3666,40720,1544,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',45000.00,NULL,NULL,1,'2021-08-16 17:18:33','2021-08-16 17:18:33',NULL),(35,3666,40720,1544,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',18235.43,NULL,NULL,1,'2021-08-16 17:18:33','2021-08-16 17:18:33',NULL),(36,3666,40720,1528,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',24000.00,NULL,NULL,1,'2021-08-16 17:37:43','2021-08-16 17:37:43',NULL),(37,3666,40720,1528,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-17','2020-05-17',4698.62,NULL,NULL,1,'2021-08-16 17:37:43','2021-08-16 17:37:43',NULL),(38,3666,40720,1528,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',19425.04,NULL,NULL,1,'2021-08-16 17:37:43','2021-08-16 17:37:43',NULL),(39,3666,40720,1529,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',18000.00,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL),(40,3666,40720,1529,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',18000.00,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL),(41,3666,40720,1529,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',18000.00,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL),(42,3666,40720,1529,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',4665.66,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL),(43,3666,40720,1529,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',25000.00,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL);
INSERT INTO `balance_libro` VALUES (44,3666,40720,1529,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',69970.00,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL),(45,3666,40720,1529,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',3784.32,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL),(46,3666,40720,1529,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',50000.00,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL),(47,3666,40720,1529,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',19425.04,NULL,NULL,1,'2021-08-16 17:42:06','2021-08-16 17:42:06',NULL),(48,3666,40720,1530,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',4665.66,NULL,NULL,1,'2021-08-16 17:42:39','2021-08-16 17:42:39',NULL),(49,3666,40720,1530,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',19425.04,NULL,NULL,1,'2021-08-16 17:42:39','2021-08-16 17:42:39',NULL),(50,3666,40720,1531,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',4770.96,NULL,NULL,1,'2021-08-16 17:44:13','2021-08-16 17:44:13',NULL),(51,3666,40720,1531,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',19425.04,NULL,NULL,1,'2021-08-16 17:44:13','2021-08-16 17:44:13',NULL),(52,3666,40720,1532,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',4665.66,NULL,NULL,1,'2021-08-16 17:44:31','2021-08-16 17:44:31',NULL),(53,3666,40720,1532,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',19425.04,NULL,NULL,1,'2021-08-16 17:44:31','2021-08-16 17:44:31',NULL),(54,3666,40720,1533,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-17','2020-10-17',4665.66,NULL,NULL,1,'2021-08-16 17:44:53','2021-08-16 17:44:53',NULL),(55,3666,40720,1533,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',19425.04,NULL,NULL,1,'2021-08-16 17:44:53','2021-08-16 17:44:53',NULL),(56,3666,40720,1534,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',4703.33,NULL,NULL,1,'2021-08-16 17:45:06','2021-08-16 17:45:06',NULL),(57,3666,40720,1534,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',19425.04,NULL,NULL,1,'2021-08-16 17:45:06','2021-08-16 17:45:06',NULL),(58,3666,40720,1535,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',51425.00,NULL,NULL,1,'2021-08-16 17:45:17','2021-08-16 17:45:17',NULL),(59,3666,40720,1535,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',4665.66,NULL,NULL,1,'2021-08-16 17:45:17','2021-08-16 17:45:17',NULL),(60,3666,40720,1535,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',3045.00,NULL,NULL,1,'2021-08-16 17:45:17','2021-08-16 17:45:17',NULL),(61,3666,40720,1535,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',304.50,NULL,NULL,1,'2021-08-16 17:45:17','2021-08-16 17:45:17',NULL),(62,3666,40720,1535,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',2287.30,NULL,NULL,1,'2021-08-16 17:45:17','2021-08-16 17:45:17',NULL),(63,3666,40720,1535,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',12000.00,NULL,NULL,1,'2021-08-16 17:45:17','2021-08-16 17:45:17',NULL),(64,3666,40720,1535,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',19425.04,NULL,NULL,1,'2021-08-16 17:45:17','2021-08-16 17:45:17',NULL);
INSERT INTO `balance_libro` VALUES (65,3666,40720,1542,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',2287.30,NULL,NULL,1,'2021-08-16 17:46:00','2021-08-16 17:46:00',NULL),(66,3666,40720,1542,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-17','2021-01-17',5726.59,NULL,NULL,1,'2021-08-16 17:46:00','2021-08-16 17:46:00',NULL),(67,3666,40720,1542,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',19425.04,NULL,NULL,1,'2021-08-16 17:46:00','2021-08-16 17:46:00',NULL),(68,3666,40720,1543,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-14','2021-02-14',2287.30,NULL,NULL,1,'2021-08-16 17:46:19','2021-08-16 17:46:19',NULL),(69,3666,40720,1543,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5686.66,NULL,NULL,1,'2021-08-16 17:46:19','2021-08-16 17:46:19',NULL),(70,3666,40720,1543,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',19425.04,NULL,NULL,1,'2021-08-16 17:46:19','2021-08-16 17:46:19',NULL),(71,3666,40720,1544,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',2287.30,NULL,NULL,1,'2021-08-16 17:46:32','2021-08-16 17:46:32',NULL),(72,3666,40720,1544,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',5686.66,NULL,NULL,1,'2021-08-16 17:46:32','2021-08-16 17:46:32',NULL),(73,3666,40720,1544,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',8000.00,NULL,NULL,1,'2021-08-16 17:46:32','2021-08-16 17:46:32',NULL),(74,3666,40720,1544,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',23310.05,NULL,NULL,1,'2021-08-16 17:46:32','2021-08-16 17:46:32',NULL),(75,3666,40720,1527,1,75,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-04-30',NULL,73931.25,NULL,NULL,1,'2021-08-28 15:50:23','2021-08-28 15:50:23',NULL),(76,3666,40720,1528,1,76,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-05-31',NULL,73931.25,NULL,NULL,1,'2021-08-28 15:55:57','2021-08-28 15:55:57',NULL),(77,3666,40720,1529,1,77,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-06-30',NULL,112983.11,NULL,NULL,1,'2021-08-28 16:16:30','2021-08-30 09:43:24','2021-08-30 09:43:24'),(78,3666,40720,1530,1,78,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-07-31',NULL,73931.28,NULL,NULL,1,'2021-08-28 16:22:18','2021-08-28 16:22:18',NULL),(79,3666,40720,1531,1,79,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-08-31',NULL,73931.28,NULL,NULL,1,'2021-08-28 16:38:25','2021-08-28 16:38:25',NULL),(80,3666,40720,1532,1,80,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-09-30',NULL,73931.28,NULL,NULL,1,'2021-08-28 16:41:12','2021-08-30 10:22:59','2021-08-30 10:22:59'),(81,3666,40720,1533,1,81,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-10-31',NULL,88812.22,NULL,NULL,1,'2021-08-28 21:54:00','2021-08-28 21:54:00',NULL),(82,3666,40720,1534,1,82,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-11-30',NULL,85388.51,NULL,NULL,1,'2021-08-30 09:02:58','2021-08-30 09:34:03','2021-08-30 09:34:03'),(83,3666,40720,1534,1,83,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-11-30',NULL,85258.09,NULL,NULL,1,'2021-08-30 09:38:58','2021-08-30 10:13:05','2021-08-30 10:13:05'),(84,3666,40720,1534,1,84,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-11-30',NULL,85258.09,NULL,NULL,1,'2021-08-30 09:38:58','2021-08-30 10:21:14','2021-08-30 10:21:14'),(85,3666,40720,1534,1,85,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-11-30',NULL,85258.09,NULL,NULL,1,'2021-08-30 09:38:59','2021-08-30 09:38:59',NULL);
INSERT INTO `balance_libro` VALUES (87,3666,40720,1529,1,87,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-06-30',NULL,112983.11,NULL,NULL,1,'2021-08-30 09:44:32','2021-08-30 09:44:32',NULL),(88,3666,40720,1534,1,88,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-11-30',NULL,85258.09,NULL,NULL,1,'2021-08-30 10:17:37','2021-08-30 10:17:37',NULL),(89,3666,40720,1534,1,89,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-11-30',NULL,85258.09,NULL,NULL,1,'2021-08-30 10:22:35','2021-08-30 10:22:35',NULL),(90,3666,40720,1532,1,90,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-09-30',NULL,73931.28,NULL,NULL,1,'2021-08-30 10:23:47','2021-08-30 10:30:38','2021-08-30 10:30:38'),(91,3666,40720,1532,1,91,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-09-30',NULL,73931.28,NULL,NULL,1,'2021-08-30 10:23:47','2021-08-30 10:23:47',NULL),(92,3666,40720,1532,1,92,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-09-30',NULL,73931.28,NULL,NULL,1,'2021-08-30 10:32:25','2021-08-30 10:32:25',NULL),(93,3666,40720,1532,1,93,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',73931.28,'Reversion asiento sueldo 09-2020',NULL,1,'2021-08-30 10:56:26','2021-08-30 10:56:26',NULL),(94,3666,40720,1534,1,94,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',170516.18,'Reversion asiento sueldo 11-2020',NULL,1,'2021-08-30 11:05:46','2021-08-30 11:05:46',NULL),(95,3666,40720,1535,1,95,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2020-12-31',NULL,125564.37,NULL,NULL,1,'2021-08-31 20:39:47','2021-08-31 20:39:47',NULL),(96,3666,40720,1542,1,96,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-01-31',NULL,102635.14,NULL,NULL,1,'2021-09-03 18:19:22','2021-09-03 18:19:22',NULL),(97,3666,40720,1543,1,97,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-02-28',NULL,92080.50,NULL,NULL,1,'2021-09-03 18:26:28','2021-09-03 18:26:28',NULL),(98,3666,40720,1544,1,98,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-03-31',NULL,95501.21,NULL,NULL,1,'2021-09-03 18:31:17','2023-01-16 18:55:56','2023-01-16 18:55:56'),(99,3666,40720,1527,21,75,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,75,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',6191.26,'',NULL,1,'2021-09-04 09:55:00','2021-09-04 09:56:35','2021-09-04 09:56:35'),(100,3666,40720,1527,21,100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',3095.63,NULL,NULL,1,'2021-09-04 09:56:35','2021-09-04 09:56:42','2021-09-04 09:56:42'),(101,3666,40720,1527,21,76,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,76,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3095.63,'',NULL,1,'2021-09-04 10:15:36','2021-09-18 09:59:46','2021-09-18 09:59:46'),(102,3666,40720,1528,21,77,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,77,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3979.72,'',NULL,1,'2021-09-04 10:36:53','2021-09-18 10:02:32','2021-09-18 10:02:32'),(103,3666,40720,1529,21,78,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,78,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2899.12,'',NULL,1,'2021-09-04 10:39:14','2021-09-18 11:28:40','2021-09-18 11:28:40'),(104,3666,40720,1530,21,79,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,79,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1865.60,'',NULL,1,'2021-09-04 10:40:18','2021-09-18 11:57:37','2021-09-18 11:57:37'),(105,3666,40720,1531,21,80,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,80,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2746.22,'',NULL,1,'2021-09-04 10:41:12','2021-09-18 12:10:31','2021-09-18 12:10:31'),(106,3666,40720,1532,21,81,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,81,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1924.52,'',NULL,1,'2021-09-04 10:41:56','2021-09-19 18:26:24','2021-09-19 18:26:24');
INSERT INTO `balance_libro` VALUES (107,3666,40720,1533,21,82,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,82,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',2008.95,'',NULL,1,'2021-09-04 10:43:11','2021-09-19 18:51:42','2021-09-19 18:51:42'),(108,3666,40720,1534,21,83,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,83,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2991.60,'',NULL,1,'2021-09-04 10:44:00','2021-09-19 18:55:51','2021-09-19 18:55:51'),(109,3666,40720,1535,21,84,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,84,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2315.90,'',NULL,1,'2021-09-04 10:44:41','2021-09-19 19:06:04','2021-09-19 19:06:04'),(110,3666,40720,1542,21,85,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,85,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2640.42,'',NULL,1,'2021-09-04 10:45:24','2021-09-19 19:43:40','2021-09-19 19:43:40'),(111,3666,40720,1543,21,86,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,86,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2466.39,'',NULL,1,'2021-09-04 10:46:13','2021-09-19 19:47:19','2021-09-19 19:47:19'),(112,3666,40720,1544,21,87,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,87,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',7666.72,'',NULL,1,'2021-09-04 10:46:52','2021-09-19 19:54:26','2021-09-19 19:54:26'),(113,3666,40720,1527,21,88,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,88,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',446.51,'',NULL,1,'2021-09-04 11:24:14','2021-09-18 10:04:06','2021-09-18 10:04:06'),(114,3666,40720,1528,21,89,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,89,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',7418.92,'',NULL,1,'2021-09-04 11:25:35','2021-09-18 11:01:08','2021-09-18 11:01:08'),(115,3666,40720,1529,21,90,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,90,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',14994.74,'',NULL,1,'2021-09-04 11:27:27','2021-09-18 11:27:37','2021-09-18 11:27:37'),(116,3666,40720,1530,21,91,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,91,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',537.10,'',NULL,1,'2021-09-04 11:28:18','2021-09-18 11:55:47','2021-09-18 11:55:47'),(117,3666,40720,1531,21,92,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,92,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',319.73,'',NULL,1,'2021-09-04 11:30:03','2021-09-18 12:09:19','2021-09-18 12:09:19'),(118,3666,40720,1532,21,93,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,93,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',186.59,'',NULL,1,'2021-09-04 11:30:54','2021-09-19 18:25:20','2021-09-19 18:25:20'),(119,3666,40720,1533,21,94,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,94,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',997.28,'',NULL,1,'2021-09-04 11:31:41','2021-09-19 18:50:43','2021-09-19 18:50:43'),(120,3666,40720,1534,21,95,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,95,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',958.67,'',NULL,1,'2021-09-04 11:32:35','2021-09-19 18:54:18','2021-09-19 18:54:18'),(121,3666,40720,1535,21,96,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,96,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',956.64,'',NULL,1,'2021-09-04 11:33:19','2021-09-19 19:05:05','2021-09-19 19:05:05'),(122,3666,40720,1542,21,97,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,97,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',15.81,'',NULL,1,'2021-09-04 11:34:15','2021-09-19 19:42:40','2021-09-19 19:42:40'),(123,3666,40720,1543,21,98,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,98,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',14.78,'',NULL,1,'2021-09-04 11:34:47','2021-09-19 19:46:13','2021-09-19 19:46:13'),(124,3666,40720,1544,21,99,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,99,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3697.41,'',NULL,1,'2021-09-04 11:36:54','2021-09-19 19:53:28','2021-09-19 19:53:28'),(125,3666,40720,1527,21,100,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,100,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',3095.63,'',NULL,1,'2021-09-04 11:51:02','2021-09-04 12:57:15','2021-09-04 12:57:15');
INSERT INTO `balance_libro` VALUES (126,3666,40720,1544,21,101,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,101,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',24056.69,'',NULL,1,'2021-09-04 12:08:22','2021-09-04 12:41:24','2021-09-04 12:41:24'),(127,3666,40720,1544,21,102,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,102,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1767.30,'',NULL,1,'2021-09-04 12:10:33','2021-09-04 12:36:24','2021-09-04 12:36:24'),(128,3666,40720,1544,21,103,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,103,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',379979.77,'',NULL,1,'2021-09-04 12:18:39','2021-09-04 12:35:52','2021-09-04 12:35:52'),(129,3666,40720,1544,21,129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',100.00,NULL,NULL,1,'2021-09-04 12:35:52','2021-09-04 12:36:07','2021-09-04 12:36:07'),(130,3666,40720,1544,21,130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1767.31,NULL,NULL,1,'2021-09-04 12:36:24','2021-09-04 12:36:29','2021-09-04 12:36:29'),(131,3666,40720,1544,21,131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',24056.68,NULL,NULL,1,'2021-09-04 12:41:24','2021-09-04 12:41:32','2021-09-04 12:41:32'),(132,3666,40720,1527,21,132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',38.55,NULL,NULL,1,'2021-09-04 12:44:55','2021-09-14 20:39:14','2021-09-14 20:39:14'),(133,3666,40720,1527,12,133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-01','2020-04-01',9992035.24,NULL,NULL,1,'2021-09-14 20:36:29','2021-09-14 20:36:29',NULL),(134,3666,40720,1528,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',1184.29,NULL,NULL,1,'2021-09-15 09:04:50','2021-09-15 09:07:43','2021-09-15 09:07:43'),(135,3666,40720,1528,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',1184.29,NULL,NULL,1,'2021-09-15 09:07:43','2021-09-15 09:21:27','2021-09-15 09:21:27'),(136,3666,40720,1529,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-20','2020-06-20',1298.01,NULL,NULL,1,'2021-09-15 09:16:15','2021-09-15 09:21:48','2021-09-15 09:21:48'),(137,3666,40720,1530,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-18','2020-07-18',1181.74,NULL,NULL,1,'2021-09-15 09:18:29','2021-09-15 09:22:07','2021-09-15 09:22:07'),(138,3666,40720,1531,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',1178.96,NULL,NULL,1,'2021-09-15 09:20:57','2021-09-15 09:20:57',NULL),(139,3666,40720,1528,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',1184.29,NULL,NULL,1,'2021-09-15 09:21:27','2021-09-15 09:21:27',NULL),(140,3666,40720,1529,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-20','2020-06-20',1298.01,NULL,NULL,1,'2021-09-15 09:21:48','2021-09-15 09:21:48',NULL),(141,3666,40720,1530,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-18','2020-07-18',1181.74,NULL,NULL,1,'2021-09-15 09:22:07','2021-09-15 09:22:07',NULL),(142,3666,40720,1532,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',1176.44,NULL,NULL,1,'2021-09-15 09:23:45','2021-09-15 09:23:45',NULL),(143,3666,40720,1533,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-22','2020-10-22',1789.63,NULL,NULL,1,'2021-09-15 09:25:38','2021-09-15 09:25:38',NULL),(144,3666,40720,1534,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',2098.15,NULL,NULL,1,'2021-09-15 09:26:41','2021-09-15 09:26:41',NULL),(145,3666,40720,1535,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',1888.71,NULL,NULL,1,'2021-09-15 09:27:36','2021-09-15 09:27:36',NULL);
INSERT INTO `balance_libro` VALUES (146,3666,40720,1542,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1699.29,NULL,NULL,1,'2021-09-15 09:28:45','2021-09-15 09:28:45',NULL),(147,3666,40720,1543,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5670.45,NULL,NULL,1,'2021-09-15 09:29:42','2021-09-15 09:29:42',NULL),(148,3666,40720,1544,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',3537.48,NULL,NULL,1,'2021-09-15 09:30:49','2021-09-15 09:30:49',NULL),(149,3666,40720,1527,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-19','2020-04-19',481.31,NULL,NULL,1,'2021-09-15 15:58:33','2021-09-15 15:58:33',NULL),(150,3666,40720,1528,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-06','2020-05-06',3800.00,NULL,NULL,1,'2021-09-15 16:00:37','2021-09-15 16:00:37',NULL),(151,3666,40720,1528,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',867.82,NULL,NULL,1,'2021-09-15 16:02:08','2021-09-15 16:02:08',NULL),(152,3666,40720,1529,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',375.79,NULL,NULL,1,'2021-09-15 16:04:16','2021-09-15 16:04:16',NULL),(153,3666,40720,1531,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',503.84,NULL,NULL,1,'2021-09-15 16:09:53','2021-09-15 16:09:53',NULL),(154,3666,40720,1530,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',418.85,NULL,NULL,1,'2021-09-15 16:11:09','2021-09-15 16:11:09',NULL),(155,3666,40720,1533,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-02','2020-10-02',437.15,NULL,NULL,1,'2021-09-15 16:13:57','2021-09-15 16:13:57',NULL),(156,3666,40720,1532,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',425.66,NULL,NULL,1,'2021-09-15 16:15:02','2021-09-15 16:15:02',NULL),(157,3666,40720,1534,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',855.40,NULL,NULL,1,'2021-09-15 16:18:45','2021-09-15 16:18:45',NULL),(158,3666,40720,1535,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',1504.70,NULL,NULL,1,'2021-09-15 16:28:32','2021-09-15 16:28:32',NULL),(159,3666,40720,1542,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',1370.78,NULL,NULL,1,'2021-09-15 16:31:11','2021-09-15 16:31:11',NULL),(160,3666,40720,1543,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1289.14,NULL,NULL,1,'2021-09-15 16:31:48','2021-09-15 16:31:48',NULL),(161,3666,40720,1544,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',602.37,NULL,NULL,1,'2021-09-15 16:32:26','2021-09-15 16:32:26',NULL),(162,3666,40720,1528,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',3079.31,NULL,NULL,1,'2021-09-15 17:38:51','2021-09-15 17:38:51',NULL),(163,3666,40720,1529,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-14','2020-06-14',3156.51,NULL,NULL,1,'2021-09-15 17:40:25','2021-09-15 17:40:25',NULL),(164,3666,40720,1530,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',3033.23,NULL,NULL,1,'2021-09-15 17:41:36','2021-09-15 17:41:36',NULL),(165,3666,40720,1530,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',3138.10,NULL,NULL,1,'2021-09-15 17:42:24','2021-09-15 17:43:34','2021-09-15 17:43:34'),(166,3666,40720,1531,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',3138.10,NULL,NULL,1,'2021-09-15 17:43:34','2021-09-15 17:43:34',NULL);
INSERT INTO `balance_libro` VALUES (167,3666,40720,1532,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',2871.94,NULL,NULL,1,'2021-09-15 17:44:52','2021-09-15 17:44:52',NULL),(168,3666,40720,1533,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',2844.78,NULL,NULL,1,'2021-09-15 17:46:01','2021-09-15 17:46:01',NULL),(169,3666,40720,1534,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',2150.48,NULL,NULL,1,'2021-09-15 17:49:07','2021-09-15 17:49:07',NULL),(170,3666,40720,1535,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',2309.52,NULL,NULL,1,'2021-09-15 17:50:08','2021-09-15 17:50:08',NULL),(171,3666,40720,1535,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',2134.23,NULL,NULL,1,'2021-09-15 17:50:38','2021-09-15 17:52:52','2021-09-15 17:52:52'),(172,3666,40720,1544,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1947.16,NULL,NULL,1,'2021-09-15 17:52:14','2021-09-15 17:52:14',NULL),(173,3666,40720,1542,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2134.23,NULL,NULL,1,'2021-09-15 17:52:52','2021-09-15 17:52:52',NULL),(174,3666,40720,1535,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',45000.00,NULL,NULL,1,'2021-09-15 19:26:30','2021-09-15 19:26:30',NULL),(175,3666,40720,1527,20,145,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,145,NULL,NULL,NULL,0,NULL,'2020-04-09','2020-04-09',20436.30,'',NULL,1,'2021-09-16 21:40:16','2021-09-16 21:40:16',NULL),(176,3666,40720,1527,20,146,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,146,NULL,NULL,NULL,0,NULL,'2020-04-12','2020-04-12',24564.70,'',NULL,1,'2021-09-16 21:45:12','2021-12-05 17:50:01','2021-12-05 17:50:01'),(177,3666,40720,1528,20,147,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,147,NULL,NULL,NULL,0,NULL,'2020-05-07','2020-05-07',1800.00,'',NULL,1,'2021-09-16 21:49:20','2021-09-16 21:49:20',NULL),(178,3666,40720,1528,20,148,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,148,NULL,NULL,NULL,0,NULL,'2020-05-10','2020-05-10',43200.00,'',NULL,1,'2021-09-16 21:51:45','2021-09-16 21:51:45',NULL),(179,3666,40720,1529,20,149,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,149,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',45000.00,'',NULL,1,'2021-09-16 22:02:20','2021-09-16 22:02:20',NULL),(180,3666,40720,1530,20,150,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,150,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',45000.00,'',NULL,1,'2021-09-16 22:04:49','2021-09-16 22:04:49',NULL),(181,3666,40720,1531,20,151,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,151,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',45000.00,'',NULL,1,'2021-09-16 22:05:53','2021-09-16 22:05:53',NULL),(182,3666,40720,1532,20,152,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,152,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',45000.00,'',NULL,1,'2021-09-16 22:07:00','2021-09-16 22:07:00',NULL),(183,3666,40720,1533,20,153,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,153,NULL,NULL,NULL,0,NULL,'2020-10-09','2020-10-09',30000.00,'',NULL,1,'2021-09-16 22:11:12','2021-09-16 22:11:12',NULL),(184,3666,40720,1533,20,154,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,154,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',15000.00,'',NULL,1,'2021-09-16 22:11:57','2021-09-16 22:11:57',NULL),(185,3666,40720,1534,20,155,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,155,NULL,NULL,NULL,0,NULL,'2020-11-10','2020-11-10',45000.00,'',NULL,1,'2021-09-16 22:13:11','2021-09-16 22:13:11',NULL),(186,3666,40720,1535,20,156,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,156,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',22287.00,'',NULL,1,'2021-09-16 22:22:23','2021-09-16 22:22:23',NULL);
INSERT INTO `balance_libro` VALUES (187,3666,40720,1535,20,157,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,157,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',22713.00,'',NULL,1,'2021-09-16 22:23:08','2021-09-16 22:23:08',NULL),(188,3666,40720,1542,20,158,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,158,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',20000.00,'',NULL,1,'2021-09-16 22:24:15','2021-09-16 22:24:15',NULL),(189,3666,40720,1542,20,159,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,159,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',25000.00,'',NULL,1,'2021-09-16 22:24:55','2021-09-16 22:24:55',NULL),(190,3666,40720,1543,20,160,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,160,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',45000.00,'',NULL,1,'2021-09-16 22:25:56','2021-09-16 22:25:56',NULL),(191,3666,40720,1544,20,161,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,161,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',45000.00,'',NULL,1,'2021-09-16 22:26:44','2021-09-16 22:26:44',NULL),(192,3666,40720,1528,20,162,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,162,NULL,NULL,NULL,0,NULL,'2020-05-06','2020-05-06',13086.00,'',NULL,1,'2021-09-16 22:41:44','2021-09-16 22:41:44',NULL),(193,3666,40720,1529,20,163,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,163,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',13086.00,'',NULL,1,'2021-09-16 22:43:24','2021-09-16 22:43:24',NULL),(194,3666,40720,1529,20,164,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,164,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',13086.00,'',NULL,1,'2021-09-16 22:45:09','2021-09-16 22:45:09',NULL),(195,3666,40720,1531,20,165,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,165,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',13086.00,'',NULL,1,'2021-09-16 22:46:29','2021-09-16 22:46:29',NULL),(196,3666,40720,1532,20,166,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,166,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',13086.00,'',NULL,1,'2021-09-16 22:58:58','2021-09-16 22:58:58',NULL),(197,3666,40720,1533,20,167,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,167,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',18235.43,'',NULL,1,'2021-09-16 23:01:39','2021-09-16 23:01:39',NULL),(198,3666,40720,1534,20,168,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,168,NULL,NULL,NULL,0,NULL,'2020-11-18','2020-11-18',18235.43,'',NULL,1,'2021-09-16 23:03:34','2021-09-16 23:03:34',NULL),(199,3666,40720,1535,20,169,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,169,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',18235.43,'',NULL,1,'2021-09-16 23:05:32','2021-09-16 23:05:32',NULL),(200,3666,40720,1542,20,170,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,170,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',18235.43,'',NULL,1,'2021-09-16 23:07:39','2021-09-16 23:07:39',NULL),(201,3666,40720,1543,20,171,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,171,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',18235.43,'',NULL,1,'2021-09-16 23:09:05','2021-09-16 23:09:05',NULL),(202,3666,40720,1531,20,172,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,172,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',162440.00,'',NULL,1,'2021-09-16 23:21:02','2021-09-16 23:21:02',NULL),(203,3666,40720,1530,20,173,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,173,NULL,NULL,NULL,0,NULL,'2020-07-27','2020-07-27',13086.00,'',NULL,1,'2021-09-18 09:50:44','2021-09-18 09:50:44',NULL),(204,3666,40720,1527,21,204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',3095.63,NULL,NULL,1,'2021-09-18 09:59:46','2021-09-18 10:37:22','2021-09-18 10:37:22'),(205,3666,40720,1528,21,205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',3979.72,NULL,NULL,1,'2021-09-18 10:02:32','2021-09-18 10:58:52','2021-09-18 10:58:52'),(206,3666,40720,1527,21,206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',446.51,NULL,NULL,1,'2021-09-18 10:04:06','2021-09-18 10:45:50','2021-09-18 10:45:50');
INSERT INTO `balance_libro` VALUES (207,3666,40720,1527,21,207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',524.91,'PERC IIBB MNES 04-2020',NULL,1,'2021-09-18 10:11:35','2021-09-18 10:38:38','2021-09-18 10:38:38'),(208,3666,40720,1527,21,208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',38.55,'PERC IIBB TUCUMAN 04-2020',NULL,1,'2021-09-18 10:14:01','2021-09-18 10:40:11','2021-09-18 10:40:11'),(209,3666,40720,1527,10,209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',2896.40,'HONORARIOS EJECUCIONES FISCALES',NULL,1,'2021-09-18 10:21:21','2021-09-18 10:21:43','2021-09-18 10:21:43'),(210,3666,40720,1527,10,210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',2986.40,'HONORARIOS EJECUCIONES FISCALES',NULL,1,'2021-09-18 10:21:43','2021-09-18 10:41:09','2021-09-18 10:41:09'),(211,3666,40720,1527,10,211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',21634.22,'PAGO CARGAS SOCIALES 02-2020',NULL,1,'2021-09-18 10:28:28','2021-09-18 10:41:59','2021-09-18 10:41:59'),(212,3666,40720,1527,21,212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-14','2020-04-14',3313.05,'CENTRO EMP COMERCIO 04-2020',NULL,1,'2021-09-18 10:32:38','2021-09-18 10:42:41','2021-09-18 10:42:41'),(213,3666,40720,1527,21,213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',3095.63,NULL,NULL,1,'2021-09-18 10:37:22','2021-09-18 10:37:51','2021-09-18 10:37:51'),(214,3666,40720,1527,21,214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',3095.63,'COMISIONES BANCARIAS 04-2020',NULL,1,'2021-09-18 10:37:51','2021-09-18 10:37:51',NULL),(215,3666,40720,1527,21,215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',524.91,'PERC IIBB MNES 04-2020',NULL,1,'2021-09-18 10:38:38','2021-09-18 10:39:23','2021-09-18 10:39:23'),(216,3666,40720,1527,21,216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',524.91,'PERC IIBB MNES 04-2020',NULL,1,'2021-09-18 10:39:23','2021-09-18 10:39:23',NULL),(217,3666,40720,1527,21,217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',38.55,'PERC IIBB TUCUMAN 04-2020',NULL,1,'2021-09-18 10:40:11','2021-09-18 10:40:11',NULL),(218,3666,40720,1527,10,218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',2986.40,'HONORARIOS EJECUCIONES FISCALES',NULL,1,'2021-09-18 10:41:09','2021-09-18 10:41:09',NULL),(219,3666,40720,1527,10,219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',21634.22,'PAGO CARGAS SOCIALES 02-2020',NULL,1,'2021-09-18 10:41:59','2021-09-18 10:41:59',NULL),(220,3666,40720,1527,21,220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-14','2020-04-14',3313.05,'CENTRO EMP COMERCIO 04-2020',NULL,1,'2021-09-18 10:42:41','2021-09-18 10:42:41',NULL),(221,3666,40720,1527,21,221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',446.51,'Imp  A LOS DEBITOS Y CREDITOS BANCARIOS',NULL,1,'2021-09-18 10:45:50','2021-09-18 10:45:50',NULL),(222,3666,40720,1528,21,222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',3979.72,'COMISIONES BANCARIAS 05-2020',NULL,1,'2021-09-18 10:58:52','2021-09-18 10:58:52',NULL),(223,3666,40720,1528,21,223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',7418.92,'imp a los creditos y debitos bancarios 05-2020',NULL,1,'2021-09-18 11:01:08','2021-09-18 11:04:47','2021-09-18 11:04:47');
INSERT INTO `balance_libro` VALUES (224,3666,40720,1528,21,224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',7418.92,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS05-2020',NULL,1,'2021-09-18 11:04:47','2021-09-18 11:04:47',NULL),(225,3666,40720,1528,21,225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',14862.55,'PERC IIBB MISIONES 05-2020',NULL,1,'2021-09-18 11:06:35','2021-09-18 11:06:35',NULL),(226,3666,40720,1528,21,226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1091.91,'PERC IIBB TUCUMAN 05-2020',NULL,1,'2021-09-18 11:08:02','2021-09-18 11:08:02',NULL),(227,3666,40720,1528,21,227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-13','2020-05-13',3313.50,'CENTRO EMP COMERCIO 05-2020',NULL,1,'2021-09-18 11:10:44','2021-09-18 11:10:44',NULL),(228,3666,40720,1528,20,228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',1157645.00,'SUBSIDIO DCTO 403/2020',NULL,1,'2021-09-18 11:22:09','2021-09-18 11:22:09',NULL),(229,3666,40720,1529,21,229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',14994.74,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 06-2020',NULL,1,'2021-09-18 11:27:37','2021-09-18 11:45:43','2021-09-18 11:45:43'),(230,3666,40720,1529,21,230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2899.12,'COMISIONES BANCARIAS 06-2020',NULL,1,'2021-09-18 11:28:40','2021-09-18 11:28:40',NULL),(231,3666,40720,1529,21,231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',871.85,'PERC IIBB MISIONES 06-2020',NULL,1,'2021-09-18 11:30:30','2021-09-18 11:30:30',NULL),(232,3666,40720,1529,21,232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',64.04,'PERC IIBB TUCUMAN',NULL,1,'2021-09-18 11:33:35','2021-09-18 11:33:55','2021-09-18 11:33:55'),(233,3666,40720,1529,21,233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',64.04,'PERC IIBB TUCUMAN 06-2020',NULL,1,'2021-09-18 11:33:55','2021-09-18 11:33:55',NULL),(234,3666,40720,1529,10,234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',24129.91,'PAGO 931 03-2020',NULL,1,'2021-09-18 11:36:10','2021-09-18 11:36:10',NULL),(235,3666,40720,1529,21,235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',1200000.00,'SELLADO DGR MISIONES',NULL,1,'2021-09-18 11:39:47','2021-09-18 11:39:47',NULL),(236,3666,40720,1529,21,236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',7794.74,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 06-2020',NULL,1,'2021-09-18 11:45:43','2021-09-18 11:45:43',NULL),(237,3666,40720,1530,21,237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',264.90,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS',NULL,1,'2021-09-18 11:55:47','2021-09-18 11:57:51','2021-09-18 11:57:51'),(238,3666,40720,1530,21,238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2553.40,'COMISIONES BANCARIAS 07-2020',NULL,1,'2021-09-18 11:57:37','2021-09-18 11:57:37',NULL),(239,3666,40720,1530,21,239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',264.90,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 07-2020',NULL,1,'2021-09-18 11:57:51','2021-09-18 11:57:51',NULL),(240,3666,40720,1530,21,240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',503.02,'PERC IIBB MISIONES 07-2020',NULL,1,'2021-09-18 11:59:39','2021-09-18 11:59:39',NULL),(241,3666,40720,1530,21,241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',36.95,'PERC IIBB TUCUMAN 07-2020',NULL,1,'2021-09-18 12:00:45','2021-09-18 12:00:45',NULL);
INSERT INTO `balance_libro` VALUES (242,3666,40720,1531,21,242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',95.48,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 08-2020',NULL,1,'2021-09-18 12:09:19','2021-09-18 12:09:19',NULL),(243,3666,40720,1531,21,243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2661.58,'COMISIONES BANCARIAS 08-2020',NULL,1,'2021-09-18 12:10:31','2021-09-18 12:10:31',NULL),(244,3666,40720,1531,21,244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',160.30,'PERC IIBB MISIONES 08-2020',NULL,1,'2021-09-18 12:11:24','2021-09-18 12:11:24',NULL),(245,3666,40720,1531,21,245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',11.77,'PERC IIBB TUCUMAN 08-2020',NULL,1,'2021-09-18 12:12:23','2021-09-18 12:12:23',NULL),(246,3666,40720,1532,21,246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1025.32,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS',NULL,1,'2021-09-19 18:25:20','2021-09-19 18:26:43','2021-09-19 18:26:43'),(247,3666,40720,1532,21,247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3104.96,'COMISIONES BANCARIAS 09-2020',NULL,1,'2021-09-19 18:26:24','2021-09-19 18:26:24',NULL),(248,3666,40720,1532,21,248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1025.32,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 09-2020',NULL,1,'2021-09-19 18:26:43','2021-09-19 18:26:43',NULL),(249,3666,40720,1532,21,249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',721.32,'PERC IIBB MNES 09-2020',NULL,1,'2021-09-19 18:28:06','2021-09-19 18:28:06',NULL),(250,3666,40720,1532,21,250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',52.99,'PERC IIBB TUCUMAN 09-2020',NULL,1,'2021-09-19 18:29:23','2021-09-19 18:29:23',NULL),(251,3666,40720,1532,22,251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',20305.00,'DEPOSITO CHEQUE COOP JARDIN AMERICA',NULL,1,'2021-09-19 18:41:04','2021-09-19 18:41:04',NULL),(252,3666,40720,1532,10,252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',23658.66,'PAGO 931 05-2020',NULL,1,'2021-09-19 18:44:32','2021-09-19 18:44:32',NULL),(253,3666,40720,1532,10,253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',37161.37,'PAGO 931 06-2020',NULL,1,'2021-09-19 18:45:37','2021-09-19 18:45:37',NULL),(254,3666,40720,1532,10,254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',23658.66,'PAGO 931 07-2020',NULL,1,'2021-09-19 18:46:34','2021-09-19 18:46:34',NULL),(255,3666,40720,1532,10,255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',23658.66,'PAGO 931 08-2020',NULL,1,'2021-09-19 18:47:18','2021-09-19 18:47:18',NULL),(256,3666,40720,1533,21,256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',14.78,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 10-2020',NULL,1,'2021-09-19 18:50:43','2021-09-19 18:50:43',NULL),(257,3666,40720,1533,21,257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',2466.39,'COMISIONES BANCARIAS 10-2020',NULL,1,'2021-09-19 18:51:42','2021-09-19 18:51:42',NULL),(258,3666,40720,1534,21,258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',140.00,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 11-2020',NULL,1,'2021-09-19 18:54:18','2021-09-19 18:54:18',NULL),(259,3666,40720,1534,21,259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2769.27,'COMISIONES BANCARIAS 11-2020',NULL,1,'2021-09-19 18:55:51','2021-09-19 18:55:51',NULL);
INSERT INTO `balance_libro` VALUES (260,3666,40720,1534,21,260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',248.73,'PERC IIBB MNES 11-2020',NULL,1,'2021-09-19 18:56:57','2021-09-19 18:56:57',NULL),(261,3666,40720,1534,21,261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',18.27,'PERC IIBB TUCUMAN 11-2020',NULL,1,'2021-09-19 18:57:59','2021-09-19 18:57:59',NULL),(262,3666,40720,1534,22,262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-18','2020-11-18',20305.00,'DEPOSITO CHEQUE COOP JARDIN AMERICA',NULL,1,'2021-09-19 18:59:10','2021-09-19 18:59:10',NULL),(263,3666,40720,1535,21,263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',187.31,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 12-2020',NULL,1,'2021-09-19 19:05:05','2021-09-19 19:05:05',NULL),(264,3666,40720,1535,21,264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2738.40,'COMISIONES BANCARIAS 12-2020',NULL,1,'2021-09-19 19:06:04','2021-09-19 19:06:04',NULL),(265,3666,40720,1535,21,265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',223.38,'PERC IIBB MNES 12-2020',NULL,1,'2021-09-19 19:07:42','2021-09-19 19:07:42',NULL),(266,3666,40720,1535,21,266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',16.41,'PERC IIBB TUCUMAN 12-2020',NULL,1,'2021-09-19 19:08:26','2021-09-19 19:08:26',NULL),(267,3666,40720,1535,21,174,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,174,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',2740.50,'',NULL,1,'2021-09-19 19:18:35','2021-09-19 19:30:21','2021-09-19 19:30:21'),(268,3666,40720,1535,21,175,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,175,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',45820.30,'',NULL,1,'2021-09-19 19:24:03','2021-09-19 19:29:43','2021-09-19 19:29:43'),(269,3666,40720,1535,21,269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',45820.30,'HONORARIOS BALANCE Nº80',NULL,1,'2021-09-19 19:29:43','2021-09-19 19:29:43',NULL),(270,3666,40720,1535,21,270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',2740.50,'TASA LEGALIZACION CPCEM BALANCE Nº80',NULL,1,'2021-09-19 19:30:21','2021-09-19 19:30:21',NULL),(271,3666,40720,1535,22,271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',18235.43,'DEPOSITO CHEQUE PIPORE',NULL,1,'2021-09-19 19:38:30','2021-09-19 19:38:30',NULL),(272,3666,40720,1542,21,272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',15.56,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 01-2021',NULL,1,'2021-09-19 19:42:40','2021-09-19 19:42:40',NULL),(273,3666,40720,1542,21,273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2596.91,'COMISIONES BANCARIAS 01-2021',NULL,1,'2021-09-19 19:43:40','2021-09-19 19:43:40',NULL),(274,3666,40720,1543,21,274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',14.78,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 02-2021',NULL,1,'2021-09-19 19:46:13','2021-09-19 19:47:43','2021-09-19 19:47:43'),(275,3666,40720,1543,21,275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2466.39,'COMISIONES BANCARIAS 02-2021',NULL,1,'2021-09-19 19:47:19','2021-09-19 19:47:19',NULL),(276,3666,40720,1543,21,276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',14.78,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 02-2021',NULL,1,'2021-09-19 19:47:43','2021-09-19 19:47:43',NULL),(277,3666,40720,1544,21,277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',20.84,'IMP A LOS DEBITOS Y CREDITOS BANCARIOS 03-2021',NULL,1,'2021-09-19 19:53:28','2021-09-19 19:53:28',NULL);
INSERT INTO `balance_libro` VALUES (278,3666,40720,1544,21,278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3518.20,'COMISIONES BANCARIAS 03-2021',NULL,1,'2021-09-19 19:54:26','2021-09-19 19:54:26',NULL),(279,3666,40720,1527,21,176,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,176,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',867.82,'',NULL,1,'2021-09-19 20:32:15','2021-09-19 20:32:15',NULL),(280,3666,40720,1528,21,177,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,177,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',375.79,'',NULL,1,'2021-09-19 20:33:30','2021-09-19 20:33:30',NULL),(281,3666,40720,1529,21,178,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,178,NULL,NULL,NULL,0,NULL,'2020-07-27','2020-07-27',418.85,'',NULL,1,'2021-09-19 20:34:21','2021-09-19 20:34:21',NULL),(282,3666,40720,1530,21,179,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,179,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',503.84,'',NULL,1,'2021-09-19 20:35:31','2021-09-19 20:35:31',NULL),(283,3666,40720,1531,21,180,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,180,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',425.66,'',NULL,1,'2021-09-19 20:36:31','2021-09-19 20:36:31',NULL),(284,3666,40720,1532,20,181,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,181,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',437.15,'',NULL,1,'2021-09-19 20:37:38','2021-09-19 20:50:43','2021-09-19 20:50:43'),(285,3666,40720,1533,21,182,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,182,NULL,NULL,NULL,0,NULL,'2020-11-10','2020-11-10',855.40,'',NULL,1,'2021-09-19 20:38:37','2021-09-19 20:38:37',NULL),(286,3666,40720,1534,21,183,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,183,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',1504.70,'',NULL,1,'2021-09-19 20:39:43','2021-09-19 20:39:43',NULL),(287,3666,40720,1535,21,184,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,184,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1370.78,'',NULL,1,'2021-09-19 20:41:54','2021-09-19 20:41:54',NULL),(288,3666,40720,1542,21,185,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,185,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1289.14,'',NULL,1,'2021-09-19 20:42:44','2021-09-19 20:42:44',NULL),(289,3666,40720,1543,21,186,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,186,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',602.37,'',NULL,1,'2021-09-19 20:43:49','2021-09-19 20:43:49',NULL),(290,3666,40720,1532,21,187,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,187,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',437.15,'',NULL,1,'2021-09-19 20:51:37','2021-09-19 20:51:37',NULL),(291,3666,40720,1527,21,188,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,188,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',481.31,'',NULL,1,'2021-09-19 20:55:01','2021-09-19 20:55:01',NULL),(292,3666,40720,1528,21,189,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,189,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',1184.29,'',NULL,1,'2021-09-19 20:57:32','2021-09-19 20:57:32',NULL),(293,3666,40720,1529,21,190,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,190,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',1298.01,'',NULL,1,'2021-09-19 20:58:19','2021-09-19 20:58:19',NULL),(294,3666,40720,1530,21,191,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,191,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',1181.74,'',NULL,1,'2021-09-19 20:59:16','2021-09-19 20:59:16',NULL),(295,3666,40720,1531,21,192,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,192,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',1178.96,'',NULL,1,'2021-09-19 21:00:17','2021-09-19 21:00:17',NULL),(296,3666,40720,1532,21,193,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,193,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',1176.44,'',NULL,1,'2021-09-19 21:01:01','2021-09-19 21:01:01',NULL),(297,3666,40720,1533,21,194,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,194,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',1789.63,'',NULL,1,'2021-09-19 21:01:49','2021-09-19 21:01:49',NULL);
INSERT INTO `balance_libro` VALUES (298,3666,40720,1534,21,195,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,195,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',2098.15,'',NULL,1,'2021-09-19 21:02:48','2021-09-19 21:02:48',NULL),(299,3666,40720,1535,21,196,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,196,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1888.71,'',NULL,1,'2021-09-19 21:03:40','2021-09-19 21:03:40',NULL),(300,3666,40720,1542,21,197,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,197,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1699.29,'',NULL,1,'2021-09-19 21:04:25','2021-09-19 21:04:25',NULL),(301,3666,40720,1543,21,198,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,198,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',5670.45,'',NULL,1,'2021-09-19 21:05:50','2021-09-19 21:05:50',NULL),(302,3666,40720,1544,21,199,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,199,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3537.48,'',NULL,1,'2021-09-19 21:07:07','2021-09-19 21:07:07',NULL),(303,3666,40720,1527,21,200,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,200,NULL,NULL,NULL,0,NULL,'2020-05-16','2020-05-16',4741.01,'',NULL,1,'2021-09-19 21:23:12','2021-09-19 21:23:12',NULL),(304,3666,40720,1528,21,201,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,201,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',3079.31,'',NULL,1,'2021-09-19 21:24:43','2021-09-19 21:24:43',NULL),(305,3666,40720,1529,21,202,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,202,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',3156.51,'',NULL,1,'2021-09-19 21:28:20','2021-09-19 21:28:20',NULL),(306,3666,40720,1529,21,203,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,203,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',4665.66,'',NULL,1,'2021-09-19 21:30:03','2021-09-19 21:30:03',NULL),(307,3666,40720,1530,21,204,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,204,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',3033.23,'',NULL,1,'2021-09-19 21:31:21','2021-09-19 21:31:21',NULL),(308,3666,40720,1531,21,205,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,205,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',4770.96,'',NULL,1,'2021-09-19 21:34:14','2021-09-19 21:34:14',NULL),(309,3666,40720,1531,21,206,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,206,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',3138.10,'',NULL,1,'2021-09-19 21:34:54','2021-09-19 21:34:54',NULL),(310,3666,40720,1532,21,207,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,207,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',2871.94,'',NULL,1,'2021-09-19 21:35:48','2021-09-19 21:35:48',NULL),(311,3666,40720,1532,21,208,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,208,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',4665.66,'',NULL,1,'2021-09-19 21:36:49','2021-09-19 21:36:49',NULL),(312,3666,40720,1533,21,209,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,209,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',2844.78,'',NULL,1,'2021-09-19 21:38:20','2021-09-19 21:38:20',NULL),(313,3666,40720,1533,21,210,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,210,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',4665.66,'',NULL,1,'2021-09-19 21:39:22','2021-09-19 21:39:22',NULL),(314,3666,40720,1534,21,211,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,211,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',4703.32,'',NULL,1,'2021-09-19 21:40:39','2021-09-19 21:40:39',NULL),(315,3666,40720,1530,21,212,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,212,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',4665.66,'',NULL,1,'2021-09-19 21:53:17','2021-09-19 21:53:17',NULL),(316,3666,40720,1534,21,213,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,213,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',923.95,'',NULL,1,'2021-09-19 21:57:29','2021-09-19 21:57:29',NULL),(317,3666,40720,1535,21,214,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,214,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',4665.66,'',NULL,1,'2021-09-19 21:58:42','2021-09-19 21:58:42',NULL),(318,3666,40720,1542,21,215,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,215,NULL,NULL,NULL,0,NULL,'2020-02-11','2020-02-11',5726.59,'',NULL,1,'2021-09-19 22:00:55','2021-09-19 22:00:55',NULL);
INSERT INTO `balance_libro` VALUES (319,3666,40720,1527,21,319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-01','2020-04-01',10000.00,'A CTA SUELDO OSCAR MARZO 2020',NULL,1,'2021-09-25 12:43:46','2021-09-25 12:50:02','2021-09-25 12:50:02'),(320,3666,40720,1527,21,320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-06','2020-04-06',25000.00,'A CTA SUELDO OSCAR MARZO 2020',NULL,1,'2021-09-25 12:46:09','2021-10-02 13:43:32','2021-10-02 13:43:32'),(321,3666,40720,1527,21,321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',10000.00,'A CTA SUELDO OSCAR MARZO 2020',NULL,1,'2021-09-25 12:47:55','2021-10-02 13:43:32','2021-10-02 13:43:32'),(322,3666,40720,1527,21,322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',10000.00,'A CTA SUELDO OSCAR MARZO 2020',NULL,1,'2021-09-25 12:48:49','2021-10-02 13:43:32','2021-10-02 13:43:32'),(323,3666,40720,1528,21,323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',10000.00,'A CTA SUELDO OSCAR ABRIL 2020',NULL,1,'2021-09-25 12:50:52','2021-10-02 13:43:32','2021-10-02 13:43:32'),(324,3666,40720,1528,21,324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',25000.00,'A CTA SUELDO OSCAR ABRIL 2020',NULL,1,'2021-09-25 12:58:38','2021-10-02 13:31:38','2021-10-02 13:31:38'),(325,3666,40720,1528,21,325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',10000.00,'A CTA SUELDO OSCAR ABRIL 2020',NULL,1,'2021-09-25 13:00:08','2021-10-02 13:43:32','2021-10-02 13:43:32'),(326,3666,40720,1528,21,326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',13905.16,'A CTA SUELDO OSCAR ABRIL 2020',NULL,1,'2021-10-02 13:31:38','2021-10-02 13:43:32','2021-10-02 13:43:32'),(327,3666,40720,1527,21,327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',47547.00,'SUELDO OSCAR 04-2020',NULL,1,'2021-10-02 13:56:39','2021-10-02 13:56:39',NULL),(328,3666,40720,1528,21,328,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',47547.00,'SUELDO OSCAR 05-2020',NULL,1,'2021-10-02 13:57:43','2021-10-02 13:57:43',NULL),(329,3666,40720,1529,21,329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',71711.00,'SUELDO+1º SAC OSCAR 06-2020',NULL,1,'2021-10-02 13:59:25','2021-10-02 13:59:25',NULL),(330,3666,40720,1530,21,330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',47547.00,'SUELDO OSCAR 07-2020',NULL,1,'2021-10-02 14:00:18','2021-10-02 14:00:18',NULL),(331,3666,40720,1531,21,331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',47547.00,'SUELDO OSCAR 08-2020',NULL,1,'2021-10-02 14:01:01','2021-10-02 14:01:01',NULL),(332,3666,40720,1532,21,332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',47547.00,'SUELDO OSCAR 09-2020',NULL,1,'2021-10-02 14:01:48','2021-10-02 14:01:48',NULL),(333,3666,40720,1533,21,333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',59124.00,'SUELDO OSCAR 10-2020',NULL,1,'2021-10-02 14:02:46','2021-10-02 14:02:46',NULL),(334,3666,40720,1534,21,334,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',56692.00,'SUELDO OSCAR 11-2020',NULL,1,'2021-10-02 14:03:48','2021-10-02 14:03:48',NULL),(335,3666,40720,1535,21,335,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',81632.00,'SUELDO+2ºSAC OSCAR 12-2020',NULL,1,'2021-10-02 14:05:19','2021-10-02 14:05:19',NULL);
INSERT INTO `balance_libro` VALUES (336,3666,40720,1542,21,336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',68416.00,'SUELDO+VACACIONES OSCAR 01-2021',NULL,1,'2021-10-02 14:06:10','2021-10-02 14:06:10',NULL),(337,3666,40720,1543,21,337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',62844.00,'SUELDO OSCAR 02-2021',NULL,1,'2021-10-02 14:06:49','2021-10-02 14:06:49',NULL),(338,3666,40720,1544,21,338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',65920.00,'SUELDO OSCAR 03-2021',NULL,1,'2021-10-02 14:07:54','2021-10-02 14:07:54',NULL),(339,3666,40720,1529,21,216,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,216,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',69970.00,'',NULL,1,'2021-10-10 10:35:14','2021-10-10 11:47:24','2021-10-10 11:47:24'),(340,3666,40720,1529,21,217,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,217,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',308250.00,'',NULL,1,'2021-10-10 11:19:44','2021-10-10 11:47:40','2021-10-10 11:47:40'),(341,3666,40720,1529,21,341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',685000.00,'HONORARIOS DR. NOGUERA',NULL,1,'2021-10-10 11:39:37','2021-10-30 10:21:30','2021-10-30 10:21:30'),(342,3666,40720,1529,21,342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',34250.00,'HONORARIOS CLOTILDE GESSNER',NULL,1,'2021-10-10 11:46:49','2021-10-30 10:23:28','2021-10-30 10:23:28'),(343,3666,40720,1529,21,343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',69970.00,'HONORARIOS MIRIAN LARREA',NULL,1,'2021-10-10 11:47:24','2021-10-30 10:25:23','2021-10-30 10:25:23'),(344,3666,40720,1529,21,344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',308250.00,'HONORARIOS JORGE CACERES',NULL,1,'2021-10-10 11:47:40','2021-10-30 10:27:30','2021-10-30 10:27:30'),(345,3666,40720,1529,22,345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',81000.00,'VENTA DE DOLARES 900 A $90',NULL,1,'2021-10-10 11:53:56','2021-10-16 20:13:19','2021-10-16 20:13:19'),(346,3666,40720,1531,21,346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-06','2020-08-06',358750.00,'HONORARIOS DR. NOGUERA',NULL,1,'2021-10-16 12:05:15','2021-10-30 10:29:58','2021-10-30 10:29:58'),(347,3666,40720,1544,22,347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',195000.00,'VENTA DE U$S1500 A $130',NULL,1,'2021-10-16 12:21:14','2021-10-16 20:17:07','2021-10-16 20:17:07'),(348,3666,40720,1544,21,348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',441000.00,'PAGO A CONINAGRO U$S 3000 A $147',NULL,1,'2021-10-16 12:35:27','2021-10-16 20:20:02','2021-10-16 20:20:02'),(349,3666,40720,1544,22,349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',147000.00,'VENTA A BUSER U$S1000 A $147',NULL,1,'2021-10-16 12:38:33','2021-10-16 20:21:43','2021-10-16 20:21:43'),(350,3666,40720,1544,22,350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',74500.00,'VENTA A WOLHEIN U$S 500 A $149',NULL,1,'2021-10-16 12:41:14','2021-10-16 20:24:01','2021-10-16 20:24:01'),(351,3666,40720,1529,22,351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',61650.00,'VENTA DE DOLARES 900 A $68,5',NULL,1,'2021-10-16 20:13:19','2021-10-16 20:13:19',NULL),(352,3666,40720,1531,22,352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',107625.00,'VENTA DE U$S1500 A $71.75',NULL,1,'2021-10-16 20:17:07','2021-10-16 20:17:07',NULL);
INSERT INTO `balance_libro` VALUES (353,3666,40720,1531,21,353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',215250.00,'PAGO A CONINAGRO U$S 3000 A $71.75',NULL,1,'2021-10-16 20:20:02','2021-10-16 20:20:02',NULL),(354,3666,40720,1531,22,354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',71750.00,'VENTA A BUSER U$S1000 A $71.75',NULL,1,'2021-10-16 20:21:43','2021-10-16 20:21:43',NULL),(355,3666,40720,1531,22,355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',35875.00,'VENTA A WOLHEIN U$S 500 A $71.75',NULL,1,'2021-10-16 20:24:01','2021-10-16 20:24:01',NULL),(356,3666,40720,1529,21,356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',685000.00,'HONORARIOS DR. NOGUERA',NULL,1,'2021-10-30 10:21:30','2021-10-30 10:21:30',NULL),(357,3666,40720,1529,21,357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',34250.00,'HONORARIOS CLOTILDE GESSNER',NULL,1,'2021-10-30 10:23:28','2021-10-30 10:23:28',NULL),(358,3666,40720,1529,21,358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',69970.00,'HONORARIOS MIRIAN LARREA',NULL,1,'2021-10-30 10:25:23','2021-10-30 10:25:23',NULL),(359,3666,40720,1529,21,359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',308250.00,'HONORARIOS JORGE CACERES',NULL,1,'2021-10-30 10:27:30','2021-10-30 10:27:30',NULL),(360,3666,40720,1531,21,360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-06','2020-08-06',358750.00,'HONORARIOS DR. NOGUERA',NULL,1,'2021-10-30 10:29:58','2021-10-30 10:29:58',NULL),(361,3666,40720,1544,21,361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',96750.00,'HONORARIOS MIRIAN LARREA U$S 1000',NULL,1,'2021-10-30 11:22:55','2021-10-30 11:22:55',NULL),(362,3666,40720,1528,21,218,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,218,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',24000.00,'',NULL,1,'2021-10-30 13:08:43','2021-10-30 13:08:43',NULL),(363,3666,40720,1528,21,219,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,219,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',3800.00,'',NULL,1,'2021-10-30 13:10:26','2021-10-30 13:10:26',NULL),(364,3666,40720,1529,21,220,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,220,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',25000.00,'',NULL,1,'2021-10-31 10:46:53','2021-10-31 10:46:53',NULL),(365,3666,40720,1529,21,365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',8000.00,'HONORARIOS PRESIDENTE',NULL,1,'2021-10-31 11:00:26','2021-10-31 11:00:26',NULL),(366,3666,40720,1529,21,221,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,221,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',18000.00,'',NULL,1,'2021-10-31 11:02:10','2021-10-31 11:02:10',NULL),(367,3666,40720,1535,21,222,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,222,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',12000.00,'',NULL,1,'2021-10-31 11:06:56','2021-10-31 11:06:56',NULL),(368,3666,40720,1544,21,223,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,223,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',8000.00,'',NULL,1,'2021-10-31 11:08:00','2021-10-31 11:08:00',NULL),(369,3666,40720,1544,21,369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',18900.00,'GASTOS CAJA SEGURIDAD BANCO NACION',NULL,1,'2021-10-31 11:48:26','2021-10-31 11:50:07','2021-10-31 11:50:07'),(370,3666,40720,1544,22,370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',17000.00,'GASTOS CAJA SEGURIDAD BBVA FRANCES',NULL,1,'2021-10-31 11:49:57','2021-10-31 12:09:53','2021-10-31 12:09:53');
INSERT INTO `balance_libro` VALUES (371,3666,40720,1544,22,371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',18900.00,'GASTOS CAJA SEGURIDAD BANCO NACION',NULL,1,'2021-10-31 11:50:07','2021-10-31 12:12:46','2021-10-31 12:12:46'),(372,3666,40720,1544,20,224,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,224,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',18235.43,'',NULL,1,'2021-10-31 11:54:59','2021-10-31 11:54:59',NULL),(373,3666,40720,1544,22,373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',18153.84,'GASTOS CAJA SEGURIDAD BANCO NACION',NULL,1,'2021-10-31 12:12:46','2021-10-31 12:12:46',NULL),(374,3666,40720,1543,21,374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',450000.00,'PAGO A CONINAGRO',NULL,1,'2021-10-31 12:18:48','2021-10-31 12:21:19','2021-10-31 12:21:19'),(375,3666,40720,1543,21,375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',450000.00,'PAGO A CONINAGRO',NULL,1,'2021-10-31 12:21:19','2021-11-01 12:19:37','2021-11-01 12:19:37'),(376,3666,40720,1535,21,225,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,225,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',5604.70,'',NULL,1,'2021-11-04 22:12:00','2021-11-05 18:06:45','2021-11-05 18:06:45'),(377,3666,40720,1543,21,226,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,226,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',228162.72,'',NULL,1,'2021-11-04 22:17:19','2021-11-05 18:02:04','2021-11-05 18:02:04'),(378,3666,40720,1543,21,378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',450000.00,'PAGO A CONINAGRO',NULL,1,'2021-11-05 18:02:04','2021-11-05 18:06:08','2021-11-05 18:06:08'),(379,3666,40720,1535,21,379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',5604.70,'SALDO HONORARIOS BALANCE CR ANDUJAR',NULL,1,'2021-11-05 18:06:45','2021-11-05 18:06:45',NULL),(380,3666,40720,1543,21,227,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,227,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',167247.72,'',NULL,1,'2021-11-05 18:21:20','2021-11-05 18:22:30','2021-11-05 18:22:30'),(381,3666,40720,1543,21,381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',450000.00,'PAGO A CONINAGRO',NULL,1,'2021-11-05 18:22:30','2021-11-05 18:24:11','2021-11-05 18:24:11'),(382,3666,40720,1543,21,382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',450000.00,'PAGO A CONINAGRO',NULL,1,'2021-11-05 18:25:51','2021-11-05 18:27:09','2021-11-05 18:27:09'),(383,3666,40720,1544,4,383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',38955.85,'AMORTIZACION EDIFICIOS',NULL,1,'2021-12-04 11:14:33','2021-12-04 11:14:33',NULL),(384,3666,40720,1544,23,384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3187988.71,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-12-04 13:08:22','2021-12-05 17:29:29','2021-12-05 17:29:29'),(385,3666,40720,1544,23,385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3187988.71,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-12-05 17:36:04','2021-12-05 17:55:44','2021-12-05 17:55:44'),(386,3666,40720,1527,20,386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-12','2020-04-12',24563.70,NULL,NULL,1,'2021-12-05 17:50:01','2021-12-05 17:50:01',NULL),(387,3666,40720,1544,23,387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3187988.71,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-12-05 18:02:00','2021-12-05 18:03:47','2021-12-05 18:03:47'),(388,3666,40720,1544,19,388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',290276.00,'DIFERENCIA DE CAMBIO MONEDA EXTRANJERA',NULL,1,'2021-12-05 18:04:56','2021-12-05 18:04:56',NULL);
INSERT INTO `balance_libro` VALUES (389,3666,40720,1544,23,389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3187988.71,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-12-05 18:06:39','2021-12-05 18:06:41',NULL),(390,3666,40720,1544,19,390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',0.70,'DIFERENCIA DE CAMBIO MONEDA EXTRANJERA',NULL,1,'2022-11-28 21:07:56','2022-11-28 21:30:22','2022-11-28 21:30:22'),(391,3666,40720,1544,19,391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',5359100.66,'REFUNDICION DE CUENTAS',NULL,1,'2022-11-28 21:26:55','2022-11-28 21:32:59','2022-11-28 21:32:59'),(392,3666,40720,1544,19,392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',5359100.66,'REFUNDICION DE CUENTAS',NULL,1,'2022-11-28 21:32:59','2022-11-28 21:32:59',NULL),(393,3666,40720,1544,19,393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',2640035.24,'ASIENTO DE TRASPASO RDO EJ A RNA',NULL,1,'2022-11-28 21:37:52','2022-11-28 21:40:58','2022-11-28 21:40:58'),(394,3666,40720,1544,19,394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',2640035.24,'ASIENTO DE TRASPASO RDO EJ A RNA',NULL,1,'2022-11-28 21:40:58','2022-11-28 21:40:58',NULL),(395,3666,40720,1544,17,395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',11607764.60,'CIERRE DE CUENTAS PATRIMOMIALES',NULL,1,'2022-11-28 22:43:01','2022-11-28 22:43:01',NULL),(396,3666,40720,1545,12,396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',11607764.60,'ASIENTO DE REAPERTURA CTAS PATRIMONIALES',NULL,1,'2022-11-30 00:28:59','2022-11-30 00:28:59',NULL),(397,3666,40720,1545,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',2287.30,NULL,NULL,1,'2022-11-30 00:39:59','2022-11-30 00:39:59',NULL),(398,3666,40720,1545,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',5710.22,NULL,NULL,1,'2022-11-30 00:39:59','2022-11-30 00:39:59',NULL),(399,3666,40720,1545,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',23310.05,NULL,NULL,1,'2022-11-30 00:39:59','2022-11-30 00:39:59',NULL),(400,3666,40720,1546,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',8425.28,NULL,NULL,1,'2022-11-30 00:54:46','2022-11-30 00:54:46',NULL),(401,3666,40720,1546,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',5719.63,NULL,NULL,1,'2022-11-30 00:54:46','2022-11-30 00:54:46',NULL),(402,3666,40720,1546,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2648.05,NULL,NULL,1,'2022-11-30 00:54:46','2022-11-30 00:54:46',NULL),(403,3666,40720,1546,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',23310.05,NULL,NULL,1,'2022-11-30 00:54:46','2022-11-30 00:54:46',NULL),(404,3666,40720,1547,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',94980.00,NULL,NULL,1,'2022-11-30 12:56:08','2022-11-30 12:56:08',NULL),(405,3666,40720,1547,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',2648.05,NULL,NULL,1,'2022-11-30 12:56:08','2022-11-30 12:56:08',NULL),(406,3666,40720,1547,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',6445.06,NULL,NULL,1,'2022-11-30 12:56:08','2022-11-30 12:56:08',NULL),(407,3666,40720,1547,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1900.00,NULL,NULL,1,'2022-11-30 12:56:08','2022-11-30 12:56:08',NULL);
INSERT INTO `balance_libro` VALUES (408,3666,40720,1547,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',23310.05,NULL,NULL,1,'2022-11-30 12:56:08','2022-11-30 12:56:08',NULL),(409,3666,40720,1548,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2648.05,NULL,NULL,1,'2022-11-30 12:57:33','2022-11-30 12:57:33',NULL),(410,3666,40720,1548,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',6603.08,NULL,NULL,1,'2022-11-30 12:57:33','2022-11-30 12:57:33',NULL),(411,3666,40720,1548,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',2000.00,NULL,NULL,1,'2022-11-30 12:57:33','2022-11-30 12:57:33',NULL),(412,3666,40720,1548,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1900.00,NULL,NULL,1,'2022-11-30 12:57:33','2022-11-30 12:57:33',NULL),(413,3666,40720,1548,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',23310.05,NULL,NULL,1,'2022-11-30 12:57:33','2022-11-30 12:57:33',NULL),(414,3666,40720,1549,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-15','2021-08-15',2902.67,NULL,NULL,1,'2022-11-30 12:59:24','2022-11-30 12:59:24',NULL),(415,3666,40720,1549,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',6421.51,NULL,NULL,1,'2022-11-30 12:59:24','2022-11-30 12:59:24',NULL),(416,3666,40720,1549,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',140785.45,NULL,NULL,1,'2022-11-30 12:59:24','2022-11-30 12:59:24',NULL),(417,3666,40720,1549,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1900.00,NULL,NULL,1,'2022-11-30 12:59:24','2022-11-30 12:59:24',NULL),(418,3666,40720,1549,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',23310.00,NULL,NULL,1,'2022-11-30 12:59:24','2022-11-30 12:59:24',NULL),(419,3666,40720,1550,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1000.00,NULL,NULL,1,'2022-11-30 12:59:51','2022-11-30 12:59:51',NULL),(420,3666,40720,1550,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',2902.67,NULL,NULL,1,'2022-11-30 12:59:51','2022-11-30 12:59:51',NULL),(421,3666,40720,1550,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',7258.73,NULL,NULL,1,'2022-11-30 12:59:51','2022-11-30 12:59:51',NULL),(422,3666,40720,1550,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2500.01,NULL,NULL,1,'2022-11-30 12:59:51','2022-11-30 12:59:51',NULL),(423,3666,40720,1550,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',27972.00,NULL,NULL,1,'2022-11-30 12:59:51','2022-11-30 12:59:51',NULL),(424,3666,40720,1551,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',2902.67,NULL,NULL,1,'2022-11-30 13:00:20','2022-11-30 13:00:20',NULL),(425,3666,40720,1551,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',7218.55,NULL,NULL,1,'2022-11-30 13:00:20','2022-11-30 13:00:20',NULL),(426,3666,40720,1551,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',27972.00,NULL,NULL,1,'2022-11-30 13:00:20','2022-11-30 13:00:20',NULL),(427,3666,40720,1551,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2500.01,NULL,NULL,1,'2022-11-30 13:00:20','2022-11-30 13:00:20',NULL),(428,3666,40720,1552,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',2902.67,NULL,NULL,1,'2022-11-30 13:00:39','2022-11-30 13:00:39',NULL);
INSERT INTO `balance_libro` VALUES (429,3666,40720,1552,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',1765.94,NULL,NULL,1,'2022-11-30 13:00:39','2022-11-30 13:00:39',NULL),(430,3666,40720,1552,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2500.01,NULL,NULL,1,'2022-11-30 13:00:39','2022-11-30 13:00:39',NULL),(431,3666,40720,1552,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',27972.00,NULL,NULL,1,'2022-11-30 13:00:39','2022-11-30 13:00:39',NULL),(432,3666,40720,1553,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',7956.88,NULL,NULL,1,'2022-11-30 13:00:56','2022-11-30 13:00:56',NULL),(433,3666,40720,1553,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',8527.35,NULL,NULL,1,'2022-11-30 13:00:56','2022-11-30 13:00:56',NULL),(434,3666,40720,1553,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',2500.01,NULL,NULL,1,'2022-11-30 13:00:56','2022-11-30 13:00:56',NULL),(435,3666,40720,1553,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',27972.00,NULL,NULL,1,'2022-11-30 13:00:56','2022-11-30 13:00:56',NULL),(436,3666,40720,1557,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',7956.88,NULL,NULL,1,'2022-11-30 13:01:14','2022-11-30 13:01:14',NULL),(437,3666,40720,1557,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',8166.25,NULL,NULL,1,'2022-11-30 13:01:14','2022-11-30 13:01:14',NULL),(438,3666,40720,1557,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',27972.00,NULL,NULL,1,'2022-11-30 13:01:14','2022-11-30 13:01:14',NULL),(439,3666,40720,1558,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2500.01,NULL,NULL,1,'2022-11-30 13:01:43','2022-11-30 13:01:43',NULL),(440,3666,40720,1558,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',7956.88,NULL,NULL,1,'2022-11-30 13:01:43','2022-11-30 13:01:43',NULL),(441,3666,40720,1558,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',8188.80,NULL,NULL,1,'2022-11-30 13:01:43','2022-11-30 13:01:43',NULL),(442,3666,40720,1558,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2500.01,NULL,NULL,1,'2022-11-30 13:01:43','2022-11-30 13:01:43',NULL),(443,3666,40720,1558,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',27972.00,NULL,NULL,1,'2022-11-30 13:01:43','2022-11-30 13:01:43',NULL),(444,3666,40720,1559,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',3045.00,NULL,NULL,1,'2022-11-30 13:01:55','2022-11-30 13:01:55',NULL),(445,3666,40720,1559,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',54450.00,NULL,NULL,1,'2022-11-30 13:01:55','2022-11-30 13:01:55',NULL),(446,3666,40720,1559,3,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',8147.13,NULL,NULL,1,'2022-11-30 13:01:55','2022-11-30 13:01:55',NULL),(447,3666,40720,1559,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',4500.00,NULL,NULL,1,'2022-11-30 13:01:55','2022-11-30 13:01:55',NULL),(448,3666,40720,1559,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3750.00,NULL,NULL,1,'2022-11-30 13:01:55','2022-11-30 13:01:55',NULL),(449,3666,40720,1559,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',36363.60,NULL,NULL,1,'2022-11-30 13:01:55','2022-11-30 13:01:55',NULL);
INSERT INTO `balance_libro` VALUES (450,3666,40720,1547,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',100000.00,NULL,NULL,1,'2022-11-30 13:21:21','2022-11-30 13:21:21',NULL),(451,3666,40720,1558,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',35747.00,NULL,NULL,1,'2022-11-30 13:22:20','2022-11-30 13:22:20',NULL),(452,3666,40720,1558,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',35747.00,NULL,NULL,1,'2022-11-30 13:22:20','2022-11-30 13:22:20',NULL),(453,3666,40720,1558,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',35747.00,NULL,NULL,1,'2022-11-30 13:22:20','2022-11-30 13:22:20',NULL),(454,3666,40720,1559,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',35747.00,NULL,NULL,1,'2022-11-30 13:22:35','2022-11-30 13:22:35',NULL),(455,3666,40720,1546,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',452.21,NULL,NULL,1,'2023-01-10 19:26:08','2023-01-10 19:26:08',NULL),(456,3666,40720,1548,3,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',397.37,NULL,NULL,1,'2023-01-10 19:31:36','2023-01-10 19:31:36',NULL),(457,3666,40720,1549,3,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',410.57,NULL,NULL,1,'2023-01-10 19:32:50','2023-01-10 19:32:50',NULL),(458,3666,40720,1550,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',384.87,NULL,NULL,1,'2023-01-10 19:33:49','2023-01-10 19:39:31','2023-01-10 19:39:31'),(459,3666,40720,1551,3,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',282.29,NULL,NULL,1,'2023-01-10 19:35:24','2023-01-10 19:35:24',NULL),(460,3666,40720,1552,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',282.58,NULL,NULL,1,'2023-01-10 19:36:23','2023-01-10 19:39:52','2023-01-10 19:39:52'),(461,3666,40720,1557,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',304.44,NULL,NULL,1,'2023-01-10 19:37:49','2023-01-10 19:37:49',NULL),(462,3666,40720,1558,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',302.87,NULL,NULL,1,'2023-01-10 19:38:49','2023-01-10 19:38:49',NULL),(463,3666,40720,1550,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',384.87,NULL,NULL,1,'2023-01-10 19:39:31','2023-01-10 19:39:31',NULL),(464,3666,40720,1552,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',282.58,NULL,NULL,1,'2023-01-10 19:39:52','2023-01-10 19:39:52',NULL),(465,3666,40720,1553,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',821.35,NULL,NULL,1,'2023-01-10 19:42:14','2023-01-10 19:42:14',NULL),(466,3666,40720,1557,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1567.35,NULL,NULL,1,'2023-01-10 19:46:10','2023-01-10 19:46:10',NULL),(467,3666,40720,1558,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',4540.50,NULL,NULL,1,'2023-01-10 19:48:52','2023-01-10 19:48:52',NULL),(468,3666,40720,1553,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',549.56,NULL,NULL,1,'2023-01-10 19:50:24','2023-01-10 19:50:24',NULL),(469,3666,40720,1557,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',573.20,NULL,NULL,1,'2023-01-10 19:51:40','2023-01-10 19:51:40',NULL),(470,3666,40720,1558,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',729.73,NULL,NULL,1,'2023-01-10 19:52:53','2023-01-10 19:52:53',NULL);
INSERT INTO `balance_libro` VALUES (471,3666,40720,1547,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1420.18,NULL,NULL,1,'2023-01-10 20:30:56','2023-01-10 20:30:56',NULL),(472,3666,40720,1548,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1263.94,NULL,NULL,1,'2023-01-10 20:31:40','2023-01-10 20:31:40',NULL),(473,3666,40720,1545,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',18235.43,NULL,NULL,1,'2023-01-10 20:40:34','2023-01-10 20:40:34',NULL),(474,3666,40720,1545,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',45000.00,NULL,NULL,1,'2023-01-10 20:41:31','2023-01-10 20:41:31',NULL),(475,3666,40720,1546,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',35747.00,NULL,NULL,1,'2023-01-10 20:43:04','2023-01-10 20:43:04',NULL),(476,3666,40720,1546,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',45000.00,NULL,NULL,1,'2023-01-10 20:43:50','2023-01-10 20:43:50',NULL),(477,3666,40720,1547,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',35747.00,NULL,NULL,1,'2023-01-10 20:45:19','2023-01-10 20:45:19',NULL),(478,3666,40720,1547,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',45000.00,NULL,NULL,1,'2023-01-10 20:46:23','2023-01-10 20:46:23',NULL),(479,3666,40720,1548,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',35747.00,NULL,NULL,1,'2023-01-10 20:47:44','2023-01-10 20:47:44',NULL),(480,3666,40720,1548,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',45000.00,NULL,NULL,1,'2023-01-10 20:48:19','2023-01-10 20:48:19',NULL),(481,3666,40720,1549,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',35747.00,NULL,NULL,1,'2023-01-10 20:51:18','2023-01-10 20:51:18',NULL),(482,3666,40720,1549,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',45000.00,NULL,NULL,1,'2023-01-10 20:52:31','2023-01-10 20:52:31',NULL),(483,3666,40720,1550,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',35747.00,NULL,NULL,1,'2023-01-10 20:53:16','2023-01-10 20:53:16',NULL),(484,3666,40720,1550,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',45000.00,NULL,NULL,1,'2023-01-10 20:53:47','2023-01-10 20:53:47',NULL),(485,3666,40720,1551,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',45000.00,NULL,NULL,1,'2023-01-10 20:54:27','2023-01-10 20:54:27',NULL),(486,3666,40720,1551,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',35747.00,NULL,NULL,1,'2023-01-10 20:55:02','2023-01-10 20:55:02',NULL),(487,3666,40720,1552,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',35747.00,NULL,NULL,1,'2023-01-10 20:56:16','2023-01-10 20:56:16',NULL),(488,3666,40720,1552,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',45000.00,NULL,NULL,1,'2023-01-10 20:56:49','2023-01-10 20:56:49',NULL),(489,3666,40720,1553,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',45000.00,NULL,NULL,1,'2023-01-10 20:57:15','2023-01-10 20:57:15',NULL),(490,3666,40720,1553,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',35747.00,NULL,NULL,1,'2023-01-10 20:57:40','2023-01-10 20:57:40',NULL),(491,3666,40720,1557,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',35747.00,NULL,NULL,1,'2023-01-10 20:58:32','2023-01-10 20:58:32',NULL);
INSERT INTO `balance_libro` VALUES (492,3666,40720,1557,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',45000.00,NULL,NULL,1,'2023-01-10 20:59:06','2023-01-10 20:59:06',NULL),(493,3666,40720,1558,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',45000.00,NULL,NULL,1,'2023-01-10 21:01:06','2023-01-10 21:01:06',NULL),(494,3666,40720,1559,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',45000.00,NULL,NULL,1,'2023-01-10 21:01:35','2023-01-10 21:01:35',NULL),(495,3666,40720,1544,1,495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-03-31',NULL,95501.21,NULL,NULL,1,'2023-01-16 18:59:15','2023-01-17 18:00:15','2023-01-17 18:00:15'),(496,3666,40720,1544,1,496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-03-31',NULL,95501.21,NULL,NULL,1,'2023-01-17 18:09:08','2023-01-17 18:20:43','2023-01-17 18:20:43'),(497,3666,40720,1544,1,497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-03-31',NULL,95501.21,NULL,NULL,1,'2023-01-17 18:25:55','2023-01-17 18:42:05','2023-01-17 18:42:05'),(498,3666,40720,1544,1,498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-03-31',NULL,95501.21,NULL,NULL,1,'2023-01-17 18:47:33','2023-01-17 22:36:59','2023-01-17 22:36:59'),(499,3666,40720,1544,1,499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-03-31',NULL,95501.21,NULL,NULL,1,'2023-01-17 22:43:31','2023-01-17 22:43:31',NULL),(500,3666,40720,1545,1,500,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-04-30',NULL,105839.16,NULL,NULL,1,'2023-01-18 16:44:53','2023-01-18 16:44:53',NULL),(501,3666,40720,1546,1,501,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-05-31',NULL,111473.37,NULL,NULL,1,'2023-01-18 17:04:19','2023-01-22 18:08:29','2023-01-22 18:08:29'),(502,3666,40720,1547,1,502,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-06-30',NULL,166356.14,NULL,NULL,1,'2023-01-18 17:56:47','2023-01-22 18:10:25','2023-01-22 18:10:25'),(503,3666,40720,1546,1,503,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-05-31',NULL,111473.37,NULL,NULL,1,'2023-01-22 18:10:15','2023-01-22 18:10:15',NULL),(504,3666,40720,1547,1,504,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-06-30',NULL,166356.14,NULL,NULL,1,'2023-01-22 18:12:24','2023-01-22 18:12:24',NULL),(505,3666,40720,1548,1,505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-07-31',NULL,111473.37,NULL,NULL,1,'2023-01-22 18:15:56','2023-01-22 18:15:56',NULL),(506,3666,40720,1549,1,506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-08-31',NULL,115588.05,NULL,NULL,1,'2023-01-22 19:36:11','2023-01-22 19:36:11',NULL),(507,3666,40720,1550,1,507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-09-30',NULL,91436.59,NULL,NULL,1,'2023-01-22 20:47:36','2023-01-22 20:47:36',NULL),(508,3666,40720,1545,21,508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',591.74,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 04-2021',NULL,1,'2023-01-22 21:11:11','2023-01-22 21:11:11',NULL),(509,3666,40720,1545,21,509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',479.58,'PERC IIBB MISIONES - TUCUMAN 04-2021',NULL,1,'2023-01-22 21:13:17','2023-01-22 21:13:17',NULL),(510,3666,40720,1545,10,510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',36585.90,'PAGO 931',NULL,1,'2023-01-22 21:32:55','2023-01-22 21:32:55',NULL),(511,3666,40720,1545,10,511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',21577.63,'PAGO 931',NULL,1,'2023-01-22 21:34:21','2023-01-22 21:34:21',NULL);
INSERT INTO `balance_libro` VALUES (512,3666,40720,1545,21,512,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3517.91,'COMISIONES BANCARIAS 04-2021',NULL,1,'2023-01-22 21:38:06','2023-01-22 21:38:06',NULL),(513,3666,40720,1545,22,513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',18235.43,'DEPOSITO DE CHEQUES',NULL,1,'2023-01-22 21:58:11','2023-01-23 20:01:25','2023-01-23 20:01:25'),(514,3666,40720,1545,22,514,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',18235.43,'DEPOSITO DE CHEQUES',NULL,1,'2023-01-22 21:59:17','2023-01-23 20:02:09','2023-01-23 20:02:09'),(515,3666,40720,1546,20,326,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,326,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',45000.00,NULL,NULL,1,'2023-01-22 22:06:33','2023-01-22 22:06:33',NULL),(516,3666,40720,1546,21,516,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',295.29,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 05-2021',NULL,1,'2023-01-22 22:08:54','2023-01-22 22:08:54',NULL),(517,3666,40720,1546,21,517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',591.75,'PERC IIBB MISIONES - TUCUMAN 05-2021',NULL,1,'2023-01-22 22:10:27','2023-01-22 22:10:27',NULL),(518,3666,40720,1546,21,518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3629.78,'COMISIONES BANCARIAS 05-2021',NULL,1,'2023-01-22 22:14:09','2023-01-22 22:14:09',NULL),(519,3666,40720,1546,20,327,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,327,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',45000.00,NULL,NULL,1,'2023-01-22 22:28:19','2023-01-22 22:28:19',NULL),(520,3666,40720,1547,21,520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',585.82,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 06-2021',NULL,1,'2023-01-22 22:31:15','2023-01-22 22:55:32','2023-01-22 22:55:32'),(521,3666,40720,1547,21,521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',591.75,'PERC IIBB MISIONES - TUCUMAN 06-2021',NULL,1,'2023-01-22 22:32:33','2023-01-22 22:32:33',NULL),(522,3666,40720,1547,10,522,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',34332.83,'PAGO 931',NULL,1,'2023-01-22 22:47:55','2023-01-22 22:47:55',NULL),(523,3666,40720,1547,10,523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',13791.90,'PAGO 931',NULL,1,'2023-01-22 22:48:55','2023-01-22 22:48:55',NULL),(524,3666,40720,1547,21,524,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',849.82,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 06-2021',NULL,1,'2023-01-22 22:55:32','2023-01-22 22:55:32',NULL),(525,3666,40720,1547,21,525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3928.13,'COMISIONES BANCARIAS 06-2021',NULL,1,'2023-01-22 22:58:56','2023-01-22 22:58:56',NULL),(526,3666,40720,1547,21,526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',22000.00,'SUELDO OSCAR',NULL,1,'2023-01-22 23:01:08','2023-01-22 23:01:08',NULL),(527,3666,40720,1548,21,527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',564.38,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 07-2021',NULL,1,'2023-01-22 23:11:30','2023-01-22 23:11:30',NULL),(528,3666,40720,1548,21,528,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1610.60,'PERC IIBB MISIONES 07-2021',NULL,1,'2023-01-22 23:13:17','2023-01-22 23:13:17',NULL),(529,3666,40720,1548,21,529,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4223.38,'COMISIONES BANCARIAS 07-2021',NULL,1,'2023-01-22 23:19:32','2023-01-22 23:19:32',NULL);
INSERT INTO `balance_libro` VALUES (530,3666,40720,1548,20,328,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,328,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',45000.00,NULL,NULL,1,'2023-01-22 23:21:17','2023-01-22 23:21:17',NULL),(531,3666,40720,1548,20,329,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,329,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',16690.00,NULL,NULL,1,'2023-01-22 23:28:12','2023-01-22 23:28:12',NULL),(532,3666,40720,1548,20,330,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,330,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',26549.00,NULL,NULL,1,'2023-01-22 23:36:55','2023-01-22 23:36:55',NULL),(533,3666,40720,1548,22,533,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',43239.00,'DEPOSITO DE CHEQUES',NULL,1,'2023-01-22 23:39:15','2023-01-22 23:39:15',NULL),(534,3666,40720,1546,20,331,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,331,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',35747.00,NULL,NULL,1,'2023-01-22 23:47:15','2023-01-22 23:51:20','2023-01-22 23:51:20'),(535,3666,40720,1546,20,332,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,332,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',35747.00,NULL,NULL,1,'2023-01-22 23:52:57','2023-01-22 23:52:57',NULL),(536,3666,40720,1547,20,333,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,333,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',35747.00,NULL,NULL,1,'2023-01-22 23:54:42','2023-01-22 23:54:42',NULL),(537,3666,40720,1549,21,537,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',526.62,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 08-2021',NULL,1,'2023-01-23 10:35:41','2023-01-23 10:35:41',NULL),(538,3666,40720,1549,21,538,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1997.95,'PERCEPCION IIBB MISIONES 08-2021',NULL,1,'2023-01-23 10:38:35','2023-01-23 10:38:35',NULL),(539,3666,40720,1549,21,539,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',4230.91,'COMISIONES BANCARIAS 08-2021',NULL,1,'2023-01-23 10:40:23','2023-01-23 10:40:23',NULL),(540,3666,40720,1549,20,334,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,334,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',45000.00,NULL,NULL,1,'2023-01-23 10:45:39','2023-01-23 10:45:39',NULL),(541,3666,40720,1549,20,335,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,335,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',10000.00,NULL,NULL,1,'2023-01-23 10:56:48','2023-01-23 10:56:48',NULL),(542,3666,40720,1549,20,336,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,336,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',26549.00,NULL,NULL,1,'2023-01-23 10:58:55','2023-01-23 10:58:55',NULL),(543,3666,40720,1550,21,543,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1594.23,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 09-2021',NULL,1,'2023-01-23 11:07:24','2023-01-23 11:07:24',NULL),(544,3666,40720,1550,21,544,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2223.30,'PERCEPCION IIBB MISIONES 09-2021',NULL,1,'2023-01-23 11:09:33','2023-01-23 11:09:33',NULL),(545,3666,40720,1550,21,545,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',4163.01,'COMISIONES BANCARIAS 09-2021',NULL,1,'2023-01-23 11:11:06','2023-01-23 11:11:06',NULL),(546,3666,40720,1550,10,546,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',168581.53,'PAGO 931',NULL,1,'2023-01-23 11:17:18','2023-01-23 11:17:18',NULL),(547,3666,40720,1548,20,337,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,337,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',35747.00,NULL,NULL,1,'2023-01-23 11:27:35','2023-01-23 11:27:35',NULL),(548,3666,40720,1549,20,338,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,338,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',35747.00,NULL,NULL,1,'2023-01-23 11:30:01','2023-01-23 11:30:01',NULL);
INSERT INTO `balance_libro` VALUES (549,3666,40720,1550,20,339,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,339,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',35747.00,NULL,NULL,1,'2023-01-23 11:31:46','2023-01-23 11:31:46',NULL),(550,3666,40720,1550,20,340,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,340,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',45000.00,NULL,NULL,1,'2023-01-23 11:38:21','2023-01-23 11:38:21',NULL),(551,3666,40720,1550,20,341,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,341,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',10000.00,NULL,NULL,1,'2023-01-23 11:39:28','2023-01-23 11:39:28',NULL),(552,3666,40720,1550,22,552,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',35747.00,'DEPOSITO CH N° 48446 PIPORE',NULL,1,'2023-01-23 11:41:23','2023-01-23 11:48:06','2023-01-23 11:48:06'),(553,3666,40720,1550,22,553,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',35747.00,'DEPOSITO CH N° 48446 PIPORE',NULL,1,'2023-01-23 11:48:06','2023-01-23 11:48:06',NULL),(554,3666,40720,1551,21,554,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1113.91,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 10-2021',NULL,1,'2023-01-23 11:53:09','2023-01-23 11:53:09',NULL),(555,3666,40720,1551,21,555,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',3297.04,'PERCEPCION IIBB MISIONES 10-2021',NULL,1,'2023-01-23 11:56:09','2023-01-23 11:56:09',NULL),(556,3666,40720,1551,21,556,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',4737.79,'COMISIONES BANCARIAS 10-2021',NULL,1,'2023-01-23 12:00:28','2023-01-23 12:00:28',NULL),(557,3666,40720,1551,20,342,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,342,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',35747.00,NULL,NULL,1,'2023-01-23 12:13:36','2023-01-23 12:13:36',NULL),(558,3666,40720,1551,21,558,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',43059.04,'GASTOS VARIOS CH N° 00676693',NULL,1,'2023-01-23 12:16:52','2023-03-19 22:25:32','2023-03-19 22:25:32'),(559,3666,40720,1551,20,343,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,343,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',45000.00,NULL,NULL,1,'2023-01-23 12:22:50','2023-01-23 12:22:50',NULL),(560,3666,40720,1550,20,344,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,344,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',26549.00,NULL,NULL,1,'2023-01-23 12:35:13','2023-01-23 12:35:13',NULL),(561,3666,40720,1550,20,345,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,345,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10000.00,NULL,NULL,1,'2023-01-23 12:41:52','2023-01-23 12:41:52',NULL),(562,3666,40720,1551,22,562,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',35747.00,'DEPOSITO CH N° 48846 PIPORE',NULL,1,'2023-01-23 12:47:51','2023-01-23 12:47:51',NULL),(563,3666,40720,1551,22,563,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',10000.00,'DEPOSITO CH N° 00114637 MONTECARLO',NULL,1,'2023-01-23 12:49:34','2023-01-23 12:49:34',NULL),(564,3666,40720,1551,22,564,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',26549.00,'DEPOSITO CH N° 00009280 JARDIN AMERICA',NULL,1,'2023-01-23 12:52:15','2023-01-23 12:52:15',NULL),(565,3666,40720,1550,20,346,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,346,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',17277.50,NULL,NULL,1,'2023-01-23 17:42:04','2023-01-23 17:42:04',NULL),(566,3666,40720,1551,22,566,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',17277.50,'DEPOSITO DE CHEQUES N° 00534961 JARDIN AMERICA',NULL,1,'2023-01-23 17:43:30','2023-01-23 17:43:30',NULL);
INSERT INTO `balance_libro` VALUES (567,3666,40720,1552,20,347,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,347,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',35747.00,NULL,NULL,1,'2023-01-23 17:54:23','2023-01-23 17:54:23',NULL),(568,3666,40720,1552,20,348,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,348,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',45000.00,NULL,NULL,1,'2023-01-23 18:01:18','2023-01-23 18:01:18',NULL),(569,3666,40720,1552,20,349,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,349,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',5000.00,NULL,NULL,1,'2023-01-23 18:02:55','2023-01-23 18:02:55',NULL),(570,3666,40720,1552,22,570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',35747.00,'DEPOSITO DE CHEQUE N° 50011 PIPORE',NULL,1,'2023-01-23 18:04:30','2023-01-23 18:04:30',NULL),(571,3666,40720,1552,21,571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',842.41,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 11-2021',NULL,1,'2023-01-23 18:07:21','2023-01-23 18:07:21',NULL),(572,3666,40720,1552,21,572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2100.80,'PERC IIBB MISIONES 11-2021',NULL,1,'2023-01-23 18:08:29','2023-01-23 18:08:29',NULL),(573,3666,40720,1552,21,573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',6040.09,'COMISIONES BANCARIAS 11-2021',NULL,1,'2023-01-23 18:09:42','2023-01-23 18:09:42',NULL),(574,3666,40720,1552,21,574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',30000.00,'PAGO CH N° 00676694 HECTOR BARRIOS',NULL,1,'2023-01-23 18:12:56','2023-01-23 18:12:56',NULL),(575,3666,40720,1552,21,575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',16526.60,'PAGO CHEQUE N° 00676696 GERARDO VALLEJOS',NULL,1,'2023-01-23 18:16:43','2023-01-23 18:16:43',NULL),(576,3666,40720,1553,20,350,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,350,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',35747.00,NULL,NULL,1,'2023-01-23 18:20:49','2023-01-23 18:20:49',NULL),(577,3666,40720,1553,20,351,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,351,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',45000.00,NULL,NULL,1,'2023-01-23 18:22:25','2023-01-23 18:22:25',NULL),(578,3666,40720,1553,21,578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',915.19,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 12-2021',NULL,1,'2023-01-23 18:24:03','2023-01-23 18:24:03',NULL),(579,3666,40720,1553,21,579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1102.50,'PERC IIBB MISIONES 12-2021',NULL,1,'2023-01-23 18:25:11','2023-01-23 18:25:11',NULL),(580,3666,40720,1553,21,580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3698.15,'COMISIONES BANCARIAS 12-2021',NULL,1,'2023-01-23 18:26:38','2023-01-23 18:26:38',NULL),(581,3666,40720,1553,10,581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',32546.35,'PAGO 931 06-2021',NULL,1,'2023-01-23 18:29:14','2023-01-23 18:29:14',NULL),(582,3666,40720,1553,10,582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',35039.27,'PAGO 931 07-2021',NULL,1,'2023-01-23 18:30:07','2023-01-23 18:30:07',NULL),(583,3666,40720,1553,10,583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',35153.95,'PAGO 931 08-2021',NULL,1,'2023-01-23 18:31:18','2023-01-23 18:31:18',NULL),(584,3666,40720,1557,21,584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',428.05,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 01-2022',NULL,1,'2023-01-23 18:34:11','2023-01-23 18:34:11',NULL);
INSERT INTO `balance_libro` VALUES (585,3666,40720,1557,21,585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1102.50,'PERC IIBB MISIONES 01-2022',NULL,1,'2023-01-23 18:35:02','2023-01-23 18:35:02',NULL),(586,3666,40720,1557,21,586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3517.91,'COMISIONES BANCARIAS 01-2022',NULL,1,'2023-01-23 18:36:42','2023-01-23 18:36:42',NULL),(587,3666,40720,1557,20,352,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,352,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',35747.00,NULL,NULL,1,'2023-01-23 18:38:46','2023-01-23 18:38:46',NULL),(588,3666,40720,1557,20,353,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,353,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',45000.00,NULL,NULL,1,'2023-01-23 18:40:24','2023-01-23 18:40:24',NULL),(589,3666,40720,1557,21,589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',11473.00,'PAGO CHEQUE N° 00676695 GERARDO VALLEJOS',NULL,1,'2023-01-23 18:42:25','2023-01-23 18:45:10','2023-01-23 18:45:10'),(590,3666,40720,1557,21,590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',10253.00,'PAGO CHEQUE N° 00676697 GERARDO VALLEJOS',NULL,1,'2023-01-23 18:43:52','2023-01-23 18:43:52',NULL),(591,3666,40720,1557,21,591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',11473.40,'PAGO CHEQUE N° 00676695 GERARDO VALLEJOS',NULL,1,'2023-01-23 18:45:10','2023-01-23 18:45:10',NULL),(592,3666,40720,1558,20,354,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,354,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',35747.00,NULL,NULL,1,'2023-01-23 18:59:09','2023-01-23 18:59:09',NULL),(593,3666,40720,1558,20,355,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,355,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',45000.00,NULL,NULL,1,'2023-01-23 19:00:19','2023-01-23 19:00:19',NULL),(594,3666,40720,1558,21,594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',406.43,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 02-2022',NULL,1,'2023-01-23 19:01:37','2023-01-23 19:01:37',NULL),(595,3666,40720,1558,21,595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1102.50,'PERC IIBB MISIONES 02-2022',NULL,1,'2023-01-23 19:02:40','2023-01-23 19:02:40',NULL),(596,3666,40720,1558,21,596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3642.22,'COMISIONES BANCARIAS 02-2022',NULL,1,'2023-01-23 19:03:36','2023-01-23 19:03:36',NULL),(597,3666,40720,1558,21,597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',18000.00,'PAGO CHEQUE N° 00676698 GERARDO VALLEJOS',NULL,1,'2023-01-23 19:04:46','2023-01-23 19:04:46',NULL),(598,3666,40720,1559,20,356,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,356,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',35747.00,NULL,NULL,1,'2023-01-23 19:09:18','2023-01-23 19:09:18',NULL),(599,3666,40720,1559,22,599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',35747.00,'DEPOSITO DE CHEQUE N° 51871 PIPORE',NULL,1,'2023-01-23 19:11:56','2023-01-23 19:11:56',NULL),(600,3666,40720,1559,21,600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1167.23,'IMPUESTO A LOS DEBITOS Y CREDITOS BANCARIOS 03-2022',NULL,1,'2023-01-23 19:13:00','2023-01-23 19:13:00',NULL),(601,3666,40720,1559,21,601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',875.80,'PERC IIBB MISIONES 03-2022',NULL,1,'2023-01-23 19:14:27','2023-01-23 19:14:27',NULL),(602,3666,40720,1559,21,602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5564.02,'COMISIONES BANCARIAS 03-2022',NULL,1,'2023-01-23 19:15:44','2023-01-23 19:15:44',NULL);
INSERT INTO `balance_libro` VALUES (603,3666,40720,1559,21,357,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,357,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',3045.00,NULL,NULL,1,'2023-01-23 19:27:50','2023-01-23 19:27:50',NULL),(604,3666,40720,1559,21,358,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,358,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',54450.00,NULL,NULL,1,'2023-01-23 19:29:09','2023-01-23 19:29:09',NULL),(605,3666,40720,1559,21,605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',64680.00,'GASTOS SERVICIO CUSTODIA PREDIO',NULL,1,'2023-01-23 19:47:41','2023-01-23 19:47:41',NULL),(606,3666,40720,1559,21,606,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',7000.00,'MANTENIMIENTO CUENTA CREDICOOP FEDECOOP',NULL,1,'2023-01-23 19:49:10','2023-01-24 09:01:08','2023-01-24 09:01:08'),(607,3666,40720,1559,21,607,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',30184.00,'GASTOS SERVICIO CUSTODIA PREDIO',NULL,1,'2023-01-23 19:50:07','2023-01-23 19:50:07',NULL),(608,3666,40720,1545,20,359,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,359,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',36470.86,NULL,NULL,1,'2023-01-23 19:59:18','2023-01-23 19:59:18',NULL),(609,3666,40720,1545,22,609,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',18235.43,'DEPOSITO DE CHEQUES N° 45153 PIPORE',NULL,1,'2023-01-23 20:01:25','2023-01-23 20:01:25',NULL),(610,3666,40720,1545,22,610,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',18235.43,'DEPOSITO DE CHEQUES N° 697005 PIPORE',NULL,1,'2023-01-23 20:02:09','2023-01-23 20:02:09',NULL),(611,3666,40720,1559,20,360,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,360,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',10000.00,NULL,NULL,1,'2023-01-23 20:08:36','2023-01-23 20:08:36',NULL),(612,3666,40720,1559,21,612,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',7000.00,'TRANSFERENCIA CTA CREDICOOP FEDECOOP',NULL,1,'2023-01-24 09:01:08','2023-01-24 09:03:13','2023-01-24 09:03:13'),(613,3666,40720,1559,22,613,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',7000.00,'TRANSFERENCIA CTA CREDICOOP FEDECOOP',NULL,1,'2023-01-24 09:03:13','2023-01-24 09:03:13',NULL),(614,3666,40751,3069,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6000.00,NULL,NULL,1,'2023-01-26 18:27:03','2023-01-26 18:27:03',NULL),(615,3666,40751,3069,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',110000.00,NULL,NULL,1,'2023-01-26 18:40:45','2023-01-26 18:40:45',NULL),(616,3666,40751,3069,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',11000.00,NULL,NULL,1,'2023-01-26 19:35:20','2023-01-26 19:35:20',NULL),(617,3666,40751,3069,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',7000.00,NULL,NULL,1,'2023-01-26 19:37:03','2023-01-26 19:37:03',NULL),(618,3666,40751,3069,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',114000.00,NULL,NULL,1,'2023-01-26 19:40:48','2023-01-26 19:40:48',NULL),(619,3666,40751,3069,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',12600.00,NULL,NULL,1,'2023-01-26 19:44:02','2023-01-26 19:44:02',NULL),(620,8450,40751,3069,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7500.00,NULL,NULL,1,'2023-01-31 18:30:00','2023-01-31 18:30:00',NULL),(621,8450,40751,3069,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9000.00,NULL,NULL,1,'2023-01-31 18:33:47','2023-01-31 18:33:47',NULL);
INSERT INTO `balance_libro` VALUES (622,8450,40751,3069,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8500.00,NULL,NULL,1,'2023-01-31 18:41:38','2023-01-31 18:41:38',NULL),(623,8450,40751,3069,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',150.00,NULL,NULL,1,'2023-01-31 18:45:14','2023-01-31 18:45:14',NULL),(624,3666,40751,3070,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',68000.13,NULL,NULL,1,'2023-02-22 11:01:57','2023-02-22 11:01:57',NULL),(625,3666,40751,3069,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1755.00,NULL,NULL,1,'2023-02-23 11:31:09','2023-02-23 11:31:09',NULL),(626,3666,40751,3069,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',97.50,NULL,NULL,1,'2023-02-23 11:31:09','2023-02-23 11:31:09',NULL),(627,3666,40751,3069,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4322.17,NULL,NULL,1,'2023-02-23 11:31:09','2023-02-23 11:31:09',NULL),(628,3666,40751,3069,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',314683.85,NULL,NULL,1,'2023-02-23 11:31:09','2023-02-23 11:31:09',NULL),(629,3666,40751,3069,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',38999.99,NULL,NULL,1,'2023-02-23 11:31:09','2023-02-23 11:31:09',NULL),(630,3666,40751,3070,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',80000.00,NULL,NULL,1,'2023-03-09 21:03:19','2023-03-09 21:03:19',NULL),(631,3666,40751,3070,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',55000.01,NULL,NULL,1,'2023-03-09 21:05:59','2023-03-09 21:05:59',NULL),(632,3666,40751,3071,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',21000.00,NULL,NULL,1,'2023-03-09 21:09:38','2023-03-09 21:09:38',NULL),(633,3666,40720,1546,21,380,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,380,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',452.21,NULL,NULL,1,'2023-03-19 13:42:56','2023-03-19 13:42:56',NULL),(634,3666,40720,1548,21,381,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,381,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',397.37,NULL,NULL,1,'2023-03-19 13:44:38','2023-03-19 13:44:38',NULL),(635,3666,40720,1549,21,382,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,382,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',410.57,NULL,NULL,1,'2023-03-19 13:47:29','2023-03-19 13:47:29',NULL),(636,3666,40720,1550,21,383,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,383,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',384.87,NULL,NULL,1,'2023-03-19 13:48:38','2023-03-19 13:48:38',NULL),(637,3666,40720,1551,21,384,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,384,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',282.29,NULL,NULL,1,'2023-03-19 13:49:56','2023-03-19 13:49:56',NULL),(638,3666,40720,1552,21,385,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,385,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',282.58,NULL,NULL,1,'2023-03-19 13:50:54','2023-03-19 13:50:54',NULL),(639,3666,40720,1557,21,386,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,386,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',304.44,NULL,NULL,1,'2023-03-19 13:52:30','2023-03-19 13:52:30',NULL),(640,3666,40720,1558,21,387,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,387,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',302.87,NULL,NULL,1,'2023-03-19 13:53:23','2023-03-19 13:53:23',NULL),(641,3666,40720,1553,21,388,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,388,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',821.35,NULL,NULL,1,'2023-03-19 13:54:56','2023-03-19 13:54:56',NULL),(642,3666,40720,1557,21,389,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,389,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1567.35,NULL,NULL,1,'2023-03-19 13:56:13','2023-03-19 13:56:13',NULL);
INSERT INTO `balance_libro` VALUES (643,3666,40720,1558,21,390,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,390,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',4540.50,NULL,NULL,1,'2023-03-19 13:57:29','2023-03-19 13:57:29',NULL),(644,3666,40720,1553,21,391,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,391,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',549.56,NULL,NULL,1,'2023-03-19 13:58:38','2023-03-19 13:58:38',NULL),(645,3666,40720,1557,21,392,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,392,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',573.20,NULL,NULL,1,'2023-03-19 13:59:48','2023-03-19 13:59:48',NULL),(646,3666,40720,1558,21,393,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,393,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',729.73,NULL,NULL,1,'2023-03-19 14:01:02','2023-03-19 14:01:02',NULL),(647,3666,40720,1547,21,394,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,394,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2648.05,NULL,NULL,1,'2023-03-19 18:04:36','2023-03-19 18:04:36',NULL),(648,3666,40720,1548,21,395,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,395,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2648.05,NULL,NULL,1,'2023-03-19 18:07:04','2023-03-19 18:07:04',NULL),(649,3666,40720,1551,21,396,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,396,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',5805.34,NULL,NULL,1,'2023-03-19 18:12:07','2023-03-19 18:12:07',NULL),(650,3666,40720,1547,21,397,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,397,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',5719.63,NULL,NULL,1,'2023-03-19 18:14:21','2023-03-19 18:14:21',NULL),(651,3666,40720,1548,21,398,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,398,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',6445.06,NULL,NULL,1,'2023-03-19 18:17:45','2023-03-19 18:17:45',NULL),(652,3666,40720,1549,21,399,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,399,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',6603.08,NULL,NULL,1,'2023-03-19 18:19:33','2023-03-19 18:19:33',NULL),(653,3666,40720,1551,21,400,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,400,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',795.43,NULL,NULL,1,'2023-03-19 18:33:04','2023-03-19 18:33:04',NULL),(654,3666,40720,1552,21,401,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,401,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',7500.00,NULL,NULL,1,'2023-03-19 18:34:38','2023-03-19 18:34:38',NULL),(655,3666,40720,1558,21,402,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,402,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',5000.00,NULL,NULL,1,'2023-03-19 18:36:01','2023-03-19 18:36:01',NULL),(656,3666,40720,1558,21,403,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,403,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',5000.00,NULL,NULL,1,'2023-03-19 18:39:35','2023-03-19 18:39:35',NULL),(657,3666,40720,1558,21,404,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,404,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',5000.00,NULL,NULL,1,'2023-03-19 18:41:06','2023-03-19 18:41:06',NULL),(658,3666,40720,1558,21,405,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,405,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',5000.00,NULL,NULL,1,'2023-03-19 18:42:22','2023-03-19 18:42:22',NULL),(659,3666,40720,1558,21,406,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,406,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',14079.63,NULL,NULL,1,'2023-03-19 18:43:34','2023-03-19 18:43:34',NULL),(660,3666,40720,1545,21,660,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',30000.00,'SUELDO OSCAR 04 2021',NULL,1,'2023-03-19 21:18:22','2023-03-21 19:14:21','2023-03-21 19:14:21'),(661,3666,40720,1545,21,661,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',15000.00,'SUELDO OSCAR 04 2021',NULL,1,'2023-03-19 21:21:02','2023-03-21 19:14:21','2023-03-21 19:14:21'),(662,3666,40720,1545,21,662,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',19000.00,'SUELDO OSCAR 04 2021',NULL,1,'2023-03-19 21:23:44','2023-03-21 19:14:21','2023-03-21 19:14:21');
INSERT INTO `balance_libro` VALUES (663,3666,40720,1546,21,663,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',30000.00,'SUELDO OSCAR 04 2021',NULL,1,'2023-03-19 21:26:22','2023-03-21 19:14:21','2023-03-21 19:14:21'),(664,3666,40720,1546,21,664,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',12000.00,'SUELDO OSCAR 05 2021',NULL,1,'2023-03-19 21:30:40','2023-03-21 19:14:21','2023-03-21 19:14:21'),(665,3666,40720,1546,21,665,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',14000.00,'SUELDO OSCAR 05 2021',NULL,1,'2023-03-19 21:31:39','2023-03-21 19:14:21','2023-03-21 19:14:21'),(666,3666,40720,1547,21,666,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',10000.00,'SUELDO OSCAR 06 2021',NULL,1,'2023-03-19 21:32:53','2023-03-21 19:14:21','2023-03-21 19:14:21'),(667,3666,40720,1547,21,667,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',13000.00,'SUELDO OSCAR 06 2021',NULL,1,'2023-03-19 21:34:16','2023-03-21 19:14:21','2023-03-21 19:14:21'),(668,3666,40720,1547,21,668,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',15000.00,'SUELDO OSCAR 06 2021',NULL,1,'2023-03-19 21:35:29','2023-03-21 19:14:21','2023-03-21 19:14:21'),(669,3666,40720,1547,21,669,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',18000.00,'SUELDO OSCAR 06 2021',NULL,1,'2023-03-19 21:36:25','2023-03-21 19:14:21','2023-03-21 19:14:21'),(670,3666,40720,1547,21,670,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',30000.00,'SUELDO OSCAR 06 2021',NULL,1,'2023-03-19 21:37:30','2023-03-21 19:14:21','2023-03-21 19:14:21'),(671,3666,40720,1548,21,671,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',10000.00,'SUELDO OSCAR 07 2021',NULL,1,'2023-03-19 21:38:19','2023-03-21 19:14:21','2023-03-21 19:14:21'),(672,3666,40720,1548,21,672,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1325.27,'SUELDO OSCAR 07 2021',NULL,1,'2023-03-19 21:40:08','2023-03-21 19:14:21','2023-03-21 19:14:21'),(673,3666,40720,1549,21,673,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',40000.00,'SUELDO OSCAR 07 2021',NULL,1,'2023-03-19 21:41:06','2023-03-21 19:14:21','2023-03-21 19:14:21'),(674,3666,40720,1549,21,674,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',15000.00,'SUELDO OSCAR 08 2021',NULL,1,'2023-03-19 21:42:04','2023-03-21 19:14:21','2023-03-21 19:14:21'),(675,3666,40720,1549,21,675,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',17096.19,'SUELDO OSCAR 08 2021',NULL,1,'2023-03-19 21:43:09','2023-03-21 19:14:21','2023-03-21 19:14:21'),(676,3666,40720,1548,21,676,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',22999.97,'PAGO DGR-MUNI POSADAS',NULL,1,'2023-03-19 21:52:59','2023-03-19 21:52:59',NULL),(677,3666,40720,1545,21,677,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',28000.00,'HONORARIOS PRESIDENCIA 04 2021',NULL,1,'2023-03-19 21:59:32','2023-03-21 18:14:38','2023-03-21 18:14:38'),(678,3666,40720,1546,21,678,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',28000.00,'HONORARIOS PRESIDENCIA 05 2021',NULL,1,'2023-03-19 22:00:49','2023-03-21 18:34:21','2023-03-21 18:34:21'),(679,3666,40720,1547,21,679,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',28000.00,'HONORARIOS PRESIDENCIA 06 2021',NULL,1,'2023-03-19 22:01:54','2023-03-21 18:36:05','2023-03-21 18:36:05');
INSERT INTO `balance_libro` VALUES (680,3666,40720,1548,21,680,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',28000.00,'HONORARIOS PRESIDENCIA 07 2021',NULL,1,'2023-03-19 22:02:44','2023-03-21 18:36:26','2023-03-21 18:36:26'),(681,3666,40720,1549,21,681,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',28000.00,'HONORARIOS PRESIDENCIA 08 2021',NULL,1,'2023-03-19 22:03:58','2023-03-21 18:36:50','2023-03-21 18:36:50'),(682,3666,40720,1550,21,682,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',28000.00,'HONORARIOS PRESIDENCIA 09 2021',NULL,1,'2023-03-19 22:05:15','2023-03-21 18:37:12','2023-03-21 18:37:12'),(683,3666,40720,1551,21,683,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',28000.00,'HONORARIOS PRESIDENCIA 10 2021',NULL,1,'2023-03-19 22:06:00','2023-03-19 22:25:50','2023-03-19 22:25:50'),(684,3666,40720,1552,21,684,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',28000.00,'HONORARIOS PRESIDENCIA 11 2021',NULL,1,'2023-03-19 22:07:26','2023-03-21 18:37:45','2023-03-21 18:37:45'),(685,3666,40720,1553,21,685,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',28000.00,'HONORARIOS PRESIDENCIA 12 2021',NULL,1,'2023-03-19 22:08:19','2023-03-21 18:38:09','2023-03-21 18:38:09'),(686,3666,40720,1557,21,686,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',28000.00,'HONORARIOS PRESIDENCIA 01 2022',NULL,1,'2023-03-19 22:09:07','2023-03-19 22:21:02','2023-03-19 22:21:02'),(687,3666,40720,1558,21,687,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',28000.00,'HONORARIOS PRESIDENCIA 02 2022',NULL,1,'2023-03-19 22:10:01','2023-03-19 22:22:09','2023-03-19 22:22:09'),(688,3666,40720,1559,21,688,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',28000.00,'HONORARIOS PRESIDENCIA 03 2022',NULL,1,'2023-03-19 22:11:48','2023-03-21 18:38:48','2023-03-21 18:38:48'),(689,3666,40720,1557,21,689,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',28000.00,'HONORARIOS PRESIDENCIA 01 2022',NULL,1,'2023-03-19 22:21:02','2023-03-19 22:21:02',NULL),(690,3666,40720,1558,21,690,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',28000.00,'HONORARIOS PRESIDENCIA 02 2022',NULL,1,'2023-03-19 22:22:09','2023-03-19 22:22:09',NULL),(691,3666,40720,1551,21,691,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',43059.04,'GASTOS VARIOS CH N° 00676693',NULL,1,'2023-03-19 22:25:32','2023-03-19 22:25:32',NULL),(692,3666,40720,1551,20,407,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,407,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10000.00,NULL,NULL,1,'2023-03-21 17:53:08','2023-03-21 17:53:08',NULL),(693,3666,40720,1547,20,408,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,408,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',20000.00,NULL,NULL,1,'2023-03-21 17:55:56','2023-03-21 17:55:56',NULL),(694,3666,40720,1547,20,409,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,409,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',79647.00,NULL,NULL,1,'2023-03-21 18:01:45','2023-03-21 18:01:45',NULL),(695,3666,40720,1549,21,410,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,410,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',109647.00,NULL,NULL,1,'2023-03-21 18:05:48','2023-03-21 18:05:48',NULL),(696,3666,40720,1545,21,696,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',28000.00,'HONORARIOS PRESIDENCIA 04 2021',NULL,1,'2023-03-21 18:14:38','2023-03-21 18:14:38',NULL);
INSERT INTO `balance_libro` VALUES (697,3666,40720,1546,21,697,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',28000.00,'HONORARIOS PRESIDENCIA 05 2021',NULL,1,'2023-03-21 18:34:21','2023-03-21 18:34:21',NULL),(698,3666,40720,1547,21,698,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',28000.00,'HONORARIOS PRESIDENCIA 06 2021',NULL,1,'2023-03-21 18:36:05','2023-03-21 18:36:05',NULL),(699,3666,40720,1548,21,699,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',28000.00,'HONORARIOS PRESIDENCIA 07 2021',NULL,1,'2023-03-21 18:36:26','2023-03-21 18:36:26',NULL),(700,3666,40720,1549,21,700,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',28000.00,'HONORARIOS PRESIDENCIA 08 2021',NULL,1,'2023-03-21 18:36:50','2023-03-21 18:36:50',NULL),(701,3666,40720,1550,21,701,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',28000.00,'HONORARIOS PRESIDENCIA 09 2021',NULL,1,'2023-03-21 18:37:12','2023-03-21 18:37:12',NULL),(702,3666,40720,1552,21,702,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',28000.00,'HONORARIOS PRESIDENCIA 11 2021',NULL,1,'2023-03-21 18:37:45','2023-03-21 18:37:45',NULL),(703,3666,40720,1553,21,703,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',28000.00,'HONORARIOS PRESIDENCIA 12 2021',NULL,1,'2023-03-21 18:38:09','2023-03-21 18:38:09',NULL),(704,3666,40720,1559,21,704,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',28000.00,'HONORARIOS PRESIDENCIA 03 2022',NULL,1,'2023-03-21 18:38:48','2023-03-21 18:38:48',NULL),(705,3666,40720,1549,11,705,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',2608200.00,'AJUSTE ANTICIPO VENTA SEDE',NULL,1,'2023-03-21 19:34:34','2023-03-21 19:34:34',NULL),(706,3666,40720,1549,23,706,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',654712.13,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-03-21 19:38:02','2023-03-21 19:39:06','2023-03-21 19:39:06'),(707,3666,40720,1545,23,707,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',131016.06,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-03-21 19:40:29','2023-03-21 19:41:53','2023-03-21 19:41:53'),(708,3666,40720,1545,23,708,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',244624.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-03-21 19:40:29','2023-03-21 19:41:53','2023-03-21 19:41:53'),(709,3666,40720,1545,23,709,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',268222.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-03-21 19:40:29','2023-03-21 19:41:53','2023-03-21 19:41:53'),(710,3666,40720,1548,23,710,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',512846.43,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-03-21 19:42:37','2023-03-21 19:42:37',NULL),(711,3666,40720,1549,2,711,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',118761945.19,'FORMALIZACION VENTA SEDE',NULL,1,'2023-03-21 20:38:49','2023-03-21 22:46:34','2023-03-21 22:46:34'),(712,3666,40720,1549,2,712,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',118761945.19,'FORMALIZACION VENTA SEDE',NULL,1,'2023-03-21 22:46:34','2023-04-17 18:09:23','2023-04-17 18:09:23'),(713,8450,40751,3071,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',5000.00,NULL,NULL,1,'2023-03-24 10:36:38','2023-03-24 10:36:38',NULL);
INSERT INTO `balance_libro` VALUES (714,8450,40751,3071,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2000.00,NULL,NULL,1,'2023-03-24 10:38:03','2023-03-24 10:38:03',NULL),(715,8450,40751,3071,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',10000.00,NULL,NULL,1,'2023-03-24 10:40:30','2023-03-24 10:40:30',NULL),(716,8450,40751,3071,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',80000.00,NULL,NULL,1,'2023-03-24 11:01:38','2023-03-24 11:01:38',NULL),(717,3666,40720,1552,21,415,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,415,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',2902.67,NULL,NULL,1,'2023-03-28 19:27:28','2023-03-28 19:27:28',NULL),(718,3666,40720,1552,21,416,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,416,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',6978.00,NULL,NULL,1,'2023-03-28 19:31:23','2023-03-28 19:31:23',NULL),(719,3666,40720,1553,21,417,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,417,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1765.94,NULL,NULL,1,'2023-03-28 19:33:30','2023-03-28 19:33:30',NULL),(720,3666,40720,1557,21,418,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,418,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',8527.35,NULL,NULL,1,'2023-03-28 19:38:12','2023-03-28 19:38:12',NULL),(721,3666,40720,1557,21,419,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,419,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',9936.24,NULL,NULL,1,'2023-03-28 19:43:19','2023-03-28 19:43:19',NULL),(722,3666,40720,1550,21,420,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,420,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',6421.51,NULL,NULL,1,'2023-03-28 19:44:45','2023-03-28 19:44:45',NULL),(723,3666,40720,1549,19,723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',44100.00,'DIF DE CAMBIO U$S 9800 A $96',NULL,1,'2023-03-30 18:13:50','2023-03-30 18:13:50',NULL),(724,3666,40720,1549,19,724,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',100000.00,'DIF DE CAMBIO U$S 400.000 A $96',NULL,1,'2023-03-30 18:19:48','2023-03-30 18:19:48',NULL),(725,3666,40720,1549,19,725,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',100000.00,'DIF DE CAMBIO U$S 400.000 A $96',NULL,1,'2023-03-30 18:19:57','2023-03-30 18:22:06','2023-03-30 18:22:06'),(726,3666,40720,1549,19,726,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',100000.00,'DIF DE CAMBIO U$S 400.000 A $96',NULL,1,'2023-03-30 18:19:58','2023-03-30 18:22:06','2023-03-30 18:22:06'),(727,3666,40720,1549,19,727,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',100000.00,'DIF DE CAMBIO U$S 400.000 A $96',NULL,1,'2023-03-30 18:19:58','2023-03-30 18:22:06','2023-03-30 18:22:06'),(728,3666,40720,1549,22,728,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',38169600.00,'RETIRO DE DOLARES DE LA CUENTA A LA CAJA DE SEGURIDAD',NULL,1,'2023-03-30 18:31:19','2023-03-30 18:31:19',NULL),(729,3666,40720,1549,21,421,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,421,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',677250.00,NULL,NULL,1,'2023-04-02 19:51:13','2023-04-02 19:51:13',NULL),(730,3666,40720,1549,21,422,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,422,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',290250.00,NULL,NULL,1,'2023-04-02 19:53:54','2023-04-02 19:53:54',NULL),(731,3666,40720,1549,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',575770.00,NULL,NULL,1,'2023-04-02 20:02:07','2023-04-02 20:02:07',NULL),(732,3666,40720,1549,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',290250.00,NULL,NULL,1,'2023-04-02 20:04:06','2023-04-02 20:04:06',NULL);
INSERT INTO `balance_libro` VALUES (733,3666,40720,1550,19,733,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',399800.00,'DIFERENCIA DE CAMBIO U$S 399.800 A $97',NULL,1,'2023-04-02 20:18:07','2023-04-17 19:38:31','2023-04-17 19:38:31'),(734,3666,40720,1550,21,734,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1988500.00,'PAGO ACUERDO OSCAR ALEGRE',NULL,1,'2023-04-02 20:34:23','2023-04-02 21:20:50','2023-04-02 21:20:50'),(735,3666,40720,1551,19,735,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',663775.00,'DIFERENCIA DE CAMBIO U$S 379.300 A $98,75',NULL,1,'2023-04-02 20:40:20','2023-04-17 19:51:17','2023-04-17 19:51:17'),(736,3666,40720,1551,2,736,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',366700.00,'VENTA A BUSER U$S 1900 A $193',NULL,1,'2023-04-02 20:44:23','2023-04-02 20:44:23',NULL),(737,3666,40720,1551,21,425,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,425,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',365046.00,NULL,NULL,1,'2023-04-02 20:56:46','2023-04-02 20:56:46',NULL),(738,3666,40720,1550,21,738,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1988500.00,'PAGO ACUERDO OSCAR ALEGRE',NULL,1,'2023-04-02 21:20:50','2023-04-02 21:43:41','2023-04-02 21:43:41'),(739,3666,40720,1550,21,739,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1988500.00,'PAGO ACUERDO OSCAR ALEGRE',NULL,1,'2023-04-02 21:43:41','2023-04-17 19:46:24','2023-04-17 19:46:24'),(740,3666,40720,1550,21,426,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,426,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1000.00,NULL,NULL,1,'2023-04-03 18:36:51','2023-04-03 18:36:51',NULL),(741,3666,40720,1546,21,427,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,427,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8425.28,NULL,NULL,1,'2023-04-03 18:38:29','2023-04-03 18:38:29',NULL),(742,3666,40720,1559,21,428,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,428,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',34481.69,NULL,NULL,1,'2023-04-03 18:42:42','2023-04-03 18:42:42',NULL),(743,3666,40720,1545,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',18235.43,NULL,NULL,1,'2023-04-06 18:06:40','2023-04-06 18:06:40',NULL),(744,3666,40720,1548,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',176571.50,NULL,NULL,1,'2023-04-06 18:10:00','2023-04-06 18:10:00',NULL),(745,3666,40720,1545,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3784.32,NULL,NULL,1,'2023-04-06 19:11:35','2023-04-06 19:11:35',NULL),(746,3666,40720,1545,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',258250.00,NULL,NULL,1,'2023-04-06 19:13:36','2023-04-06 19:13:36',NULL),(747,3666,40720,1559,19,747,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1941740.74,'COMPENSACION CREDITOS Y PASIVOS HISTORICOS',NULL,1,'2023-04-06 20:23:17','2023-04-06 20:27:40','2023-04-06 20:27:40'),(748,3666,40720,1559,19,748,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1941740.74,'COMPENSACION CREDITOS Y PASIVOS HISTORICOS',NULL,1,'2023-04-06 20:27:40','2023-04-06 20:33:02','2023-04-06 20:33:02'),(749,3666,40720,1559,19,749,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1941740.34,'COMPENSACION CREDITOS Y PASIVOS HISTORICOS',NULL,1,'2023-04-06 20:33:02','2023-04-17 20:05:28','2023-04-17 20:05:28'),(750,3666,40720,1559,4,750,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',679825.00,'AMORTIZACION EDIFICIO 1° AÑO',NULL,1,'2023-04-06 20:47:25','2023-04-17 20:05:33','2023-04-17 20:05:33');
INSERT INTO `balance_libro` VALUES (751,3666,40720,1559,19,751,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',31200.00,'VALUACION DE DOLARES CC BANCO FRANCESAL CIERRE DE EJ',NULL,1,'2023-04-06 21:11:06','2023-04-17 20:05:38','2023-04-17 20:05:38'),(752,3666,40720,1559,19,752,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4452450.00,'VALUACION DE DOLARES  CAJA SEGURIDADAL CIERRE DE EJ',NULL,1,'2023-04-06 21:15:44','2023-04-17 20:05:43','2023-04-17 20:05:43'),(753,3666,40720,1559,19,753,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4452450.00,'VALUACION DE DOLARES  CAJA SEGURIDADAL CIERRE DE EJ',NULL,1,'2023-04-06 21:15:44','2023-04-06 21:16:13','2023-04-06 21:16:13'),(754,3666,40720,1559,23,754,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39895153.77,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-06 21:40:04','2023-04-06 22:34:44','2023-04-06 22:34:44'),(755,3666,40720,1559,19,755,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',158202819.44,'REFUNDICION DE CUENTAS',NULL,1,'2023-04-06 22:12:01','2023-04-06 22:28:28','2023-04-06 22:28:28'),(756,3666,40720,1559,23,756,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39669323.43,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-06 22:39:48','2023-04-08 14:30:56','2023-04-08 14:30:56'),(757,3666,40720,1559,23,757,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',10533732.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-06 22:40:19','2023-04-07 16:21:22','2023-04-07 16:21:22'),(758,3666,40720,1559,19,758,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',158202819.44,'REFUNDICION DE CUENTAS',NULL,1,'2023-04-06 22:56:04','2023-04-06 23:13:51','2023-04-06 23:13:51'),(759,3666,40720,1559,19,759,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',158202819.44,'REFUNDICION DE CUENTAS',NULL,1,'2023-04-06 23:13:51','2023-04-07 16:20:53','2023-04-07 16:20:53'),(760,3666,40720,1559,17,760,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',129205987.14,'CIERRE DE CUENTAS PATRIMOMIALES',NULL,1,'2023-04-06 23:21:06','2023-04-07 16:20:43','2023-04-07 16:20:43'),(761,3666,40720,1559,23,761,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',10533732.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-07 16:21:54','2023-04-07 16:23:35','2023-04-07 16:23:35'),(762,3666,40720,1559,23,762,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',11495120.26,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-07 16:28:08','2023-04-07 16:34:33','2023-04-07 16:34:33'),(763,3666,40720,1559,23,763,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',11495120.26,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-07 16:35:15','2023-04-07 16:36:03','2023-04-07 16:36:03'),(764,3666,40720,1559,23,764,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',40031571.98,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-08 14:34:57','2023-04-08 14:37:05','2023-04-08 14:37:05'),(765,3666,40720,1559,23,765,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39805741.64,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-08 14:38:28','2023-04-14 18:23:41','2023-04-14 18:23:41'),(766,3666,40720,1559,19,766,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5700000.00,'VALUACION DE CREDITO EN DOLARES AL CIERRE DE EJ',NULL,1,'2023-04-14 18:27:07','2023-04-17 18:28:46','2023-04-17 18:28:46');
INSERT INTO `balance_libro` VALUES (767,3666,40720,1559,23,767,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39805741.64,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-14 18:34:50','2023-04-17 18:09:37','2023-04-17 18:09:37'),(768,3666,40720,1549,2,768,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',118761945.19,'FORMALIZACION VENTA SEDE',NULL,1,'2023-04-17 18:09:23','2023-04-17 18:09:23',NULL),(769,3666,40720,1550,19,769,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',397400.00,'DIFERENCIA DE CAMBIO U$S 399.800 A $97',NULL,1,'2023-04-17 19:38:31','2023-04-17 19:45:27','2023-04-17 19:45:27'),(770,3666,40720,1550,19,770,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',397400.00,'DIFERENCIA DE CAMBIO U$S 397.400 A $97',NULL,1,'2023-04-17 19:45:27','2023-04-17 19:45:27',NULL),(771,3666,40720,1550,21,771,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1988500.00,'PAGO ACUERDO OSCAR ALEGRE u$s 20.500 A $97',NULL,1,'2023-04-17 19:46:24','2023-04-17 19:46:24',NULL),(772,3666,40720,1551,19,772,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',659575.00,'DIFERENCIA DE CAMBIO U$S 376.900 A $98,75',NULL,1,'2023-04-17 19:51:17','2023-04-17 19:51:17',NULL),(773,3666,40720,1559,19,773,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2036866.97,'COMPENSACION CREDITOS Y PASIVOS HISTORICOS',NULL,1,'2023-04-17 21:11:40','2023-04-17 22:22:21','2023-04-17 22:22:21'),(774,3666,40720,1559,19,774,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',27000.00,'VALUACION DE DOLARES CC BANCO FRANCES AL CIERRE DE EJ',NULL,1,'2023-04-17 21:22:59','2023-04-17 21:22:59',NULL),(775,3666,40720,1559,19,775,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4199250.00,'VALUACION DE DOLARES  CAJA SEGURIDAD AL CIERRE DE EJ',NULL,1,'2023-04-17 21:26:31','2023-04-17 21:26:31',NULL),(776,3666,40720,1559,19,776,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',240600.00,'AJUSTE CREDITO SERGIO DELAPIERRE U$S 5000 A $110',NULL,1,'2023-04-17 21:50:15','2023-04-17 21:50:15',NULL),(777,3666,40720,1559,19,777,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',38778750.00,'REG DEL SALDO EN U$S VENTA DE LA SEDE EN CRED EN MON EXT',NULL,1,'2023-04-17 21:55:23','2023-04-17 21:55:23',NULL),(778,3666,40720,1559,19,778,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5771250.00,'VALUACION DE CREDITO EN DOLARES AL CIERRE DE EJ',NULL,1,'2023-04-17 21:58:01','2023-04-17 21:58:01',NULL),(779,3666,40720,1559,4,779,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',670250.00,'AMORTIZACION EDIFICIO 1° AÑO',NULL,1,'2023-04-17 22:06:17','2023-04-17 22:06:17',NULL),(780,3666,40720,1559,23,780,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39804081.39,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-17 22:12:24','2023-04-17 22:21:13','2023-04-17 22:21:13'),(781,3666,40720,1559,19,781,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2126715.79,'COMPENSACION CREDITOS Y PASIVOS HISTORICOS',NULL,1,'2023-04-17 22:22:21','2023-04-17 22:30:17','2023-04-17 22:30:17'),(782,3666,40720,1559,23,782,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39804081.39,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-17 22:25:51','2023-04-17 22:30:27','2023-04-17 22:30:27');
INSERT INTO `balance_libro` VALUES (783,3666,40720,1559,19,783,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2126418.79,'COMPENSACION CREDITOS Y PASIVOS HISTORICOS',NULL,1,'2023-04-17 22:30:17','2023-04-17 23:26:43','2023-04-17 23:26:43'),(784,3666,40720,1559,23,784,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39804081.39,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-17 22:32:33','2023-04-17 22:32:35',NULL),(785,3666,40720,1559,20,785,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',0.40,'COBRO APORTE COOPERATIVOS PENDIENTES',NULL,1,'2023-04-17 23:24:04','2023-04-17 23:25:21','2023-04-17 23:25:21'),(786,3666,40720,1559,19,786,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2126418.39,'COMPENSACION CREDITOS Y PASIVOS HISTORICOS',NULL,1,'2023-04-17 23:26:43','2023-04-17 23:26:43',NULL),(787,3666,40751,3073,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2500.01,NULL,NULL,1,'2023-05-10 12:45:26','2023-05-10 12:45:26',NULL),(788,3666,40751,3073,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',6000.00,NULL,NULL,1,'2023-05-10 12:45:56','2023-05-10 12:45:56',NULL),(789,3666,40751,3073,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2000.00,NULL,NULL,1,'2023-05-10 12:46:30','2023-05-10 12:46:30',NULL),(790,3666,40751,3073,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2000.00,NULL,NULL,1,'2023-05-10 12:46:48','2023-05-10 12:46:48',NULL),(791,3666,40751,3073,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2500.01,NULL,NULL,1,'2023-05-10 12:47:16','2023-05-10 12:47:16',NULL),(792,3666,40751,3073,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2000.00,NULL,NULL,1,'2023-05-10 12:47:30','2023-05-10 12:47:30',NULL),(793,3666,40751,3073,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2000.00,NULL,NULL,1,'2023-05-10 12:47:51','2023-05-10 12:47:51',NULL),(794,3666,40751,3073,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',9000.00,NULL,NULL,1,'2023-05-10 12:48:16','2023-05-10 12:48:16',NULL),(795,3666,40751,3073,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4000.01,NULL,NULL,1,'2023-05-10 12:49:15','2023-05-10 12:49:15',NULL),(796,3666,40751,3073,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',5000.00,NULL,NULL,1,'2023-05-10 12:49:55','2023-05-10 12:49:55',NULL),(797,3666,40751,3073,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',6000.00,NULL,NULL,1,'2023-05-10 12:50:10','2023-05-10 12:50:10',NULL),(798,3666,40751,3073,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4000.01,NULL,NULL,1,'2023-05-10 12:50:30','2023-05-10 12:50:30',NULL),(799,3666,40751,3073,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-05-10 12:50:45','2023-05-10 12:50:45',NULL),(800,3666,40751,3073,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',3000.00,NULL,NULL,1,'2023-05-10 12:51:18','2023-05-10 12:51:18',NULL),(801,3666,40751,3073,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',14999.99,NULL,NULL,1,'2023-05-10 12:51:31','2023-05-10 12:51:31',NULL),(802,3666,40751,3073,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2000.00,NULL,NULL,1,'2023-05-10 12:52:19','2023-05-10 12:52:19',NULL);
INSERT INTO `balance_libro` VALUES (803,3666,40751,3073,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',9000.00,NULL,NULL,1,'2023-05-10 12:52:40','2023-05-10 12:52:40',NULL),(804,3666,40751,3073,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',3000.00,NULL,NULL,1,'2023-05-10 12:52:54','2023-05-10 12:52:54',NULL),(805,3666,40751,3073,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2000.00,NULL,NULL,1,'2023-05-10 12:53:15','2023-05-10 12:53:15',NULL),(806,3666,40751,3073,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-05-10 12:53:29','2023-05-10 12:53:29',NULL),(807,3666,40751,3073,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',5000.00,NULL,NULL,1,'2023-05-10 12:53:44','2023-05-10 12:53:44',NULL),(808,3666,40751,3073,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',6000.00,NULL,NULL,1,'2023-05-10 12:54:16','2023-05-10 12:54:16',NULL),(809,3666,40751,3073,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2000.00,NULL,NULL,1,'2023-05-10 12:54:34','2023-05-10 12:54:34',NULL),(810,3666,40751,3073,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',6000.00,NULL,NULL,1,'2023-05-10 12:54:52','2023-05-10 12:54:52',NULL),(811,3666,40751,3073,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',3000.00,NULL,NULL,1,'2023-05-10 12:55:09','2023-05-10 12:55:09',NULL),(812,3666,40751,3073,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',10000.00,NULL,NULL,1,'2023-05-10 12:55:22','2023-05-10 12:55:22',NULL),(813,3666,40751,3073,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',105000.00,NULL,NULL,1,'2023-05-10 13:01:10','2023-05-10 13:01:10',NULL),(814,3666,40751,3073,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',161000.00,NULL,NULL,1,'2023-05-11 10:29:58','2023-05-11 10:29:58',NULL),(815,3666,40720,1559,17,815,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',163949009.19,'REFUNDICION DE CUENTAS',NULL,1,'2023-05-28 19:01:34','2023-05-28 19:01:34',NULL),(816,3666,40720,1559,19,816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',117541934.33,'PASE DE RDO DEL EJ A RDO NO ASIGNADO',NULL,1,'2023-05-28 19:29:16','2023-05-28 19:29:16',NULL),(817,3666,40720,1559,17,817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',120778654.65,'CIERRE DE CUENTAS PATRIMOMIALES',NULL,1,'2023-05-28 19:46:35','2023-05-28 19:46:35',NULL),(818,8450,40751,3074,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',3000.00,NULL,NULL,1,'2023-06-06 17:29:00','2023-06-06 17:29:00',NULL),(819,8450,40751,3074,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',1500.00,NULL,NULL,1,'2023-06-06 17:30:24','2023-06-06 17:30:24',NULL),(820,8450,40751,3074,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',3000.00,NULL,NULL,1,'2023-06-06 17:35:35','2023-06-06 17:35:35',NULL),(821,8450,40751,3074,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',6000.00,NULL,NULL,1,'2023-06-07 17:01:35','2023-06-07 17:01:35',NULL),(822,3666,40751,3074,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',80000.00,NULL,NULL,1,'2023-06-11 17:38:05','2023-06-11 17:38:05',NULL);
INSERT INTO `balance_libro` VALUES (823,3666,40751,3074,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',188000.00,NULL,NULL,1,'2023-06-11 17:41:16','2023-06-11 17:41:16',NULL),(824,3666,40751,3074,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',100000.00,NULL,NULL,1,'2023-06-11 17:45:44','2023-06-11 17:45:44',NULL),(825,3666,40751,3074,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',8500.00,NULL,NULL,1,'2023-06-11 17:46:45','2023-06-11 17:46:45',NULL),(826,3666,40720,1560,12,826,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',120778654.65,'ASIENTO DE REAPERTURA CTAS PATRIMONIALES',NULL,1,'2023-06-11 18:05:43','2023-06-11 18:05:43',NULL),(827,3666,40720,1560,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',35747.00,NULL,NULL,1,'2023-06-12 18:02:54','2023-06-12 18:02:54',NULL),(828,3666,40720,1560,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',48000.00,NULL,NULL,1,'2023-06-12 18:03:19','2023-06-12 18:03:19',NULL),(829,3666,40720,1560,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',9223.11,NULL,NULL,1,'2023-06-12 18:03:19','2023-06-12 18:03:19',NULL),(830,3666,40720,1560,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',3750.00,NULL,NULL,1,'2023-06-12 18:03:19','2023-06-12 18:03:19',NULL),(831,3666,40720,1560,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',36364.00,NULL,NULL,1,'2023-06-12 18:03:19','2023-06-12 18:03:19',NULL),(832,3666,40720,1561,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',35747.00,NULL,NULL,1,'2023-06-12 18:20:04','2023-06-12 18:20:04',NULL),(833,3666,40720,1561,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',8740.68,NULL,NULL,1,'2023-06-12 18:21:25','2023-06-12 18:21:25',NULL),(834,3666,40720,1561,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',325000.00,NULL,NULL,1,'2023-06-12 18:21:25','2023-06-12 18:21:25',NULL),(835,3666,40720,1561,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3750.00,NULL,NULL,1,'2023-06-12 18:21:25','2023-06-12 18:21:25',NULL),(836,3666,40720,1561,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',36364.00,NULL,NULL,1,'2023-06-12 18:21:25','2023-06-12 18:21:25',NULL),(837,8450,40751,3074,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',6500.00,NULL,NULL,1,'2023-06-13 17:29:13','2023-06-13 17:29:13',NULL),(838,8450,40751,3074,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',3500.00,NULL,NULL,1,'2023-06-13 17:29:54','2023-06-13 17:29:54',NULL),(839,3666,40720,1562,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',35747.00,NULL,NULL,1,'2023-06-13 18:21:12','2023-06-13 18:21:12',NULL),(840,3666,40720,1562,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',9279.08,NULL,NULL,1,'2023-06-13 18:21:40','2023-06-13 18:21:40',NULL),(841,3666,40720,1562,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',259000.00,NULL,NULL,1,'2023-06-13 18:21:40','2023-06-13 18:21:40',NULL),(842,3666,40720,1562,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3750.00,NULL,NULL,1,'2023-06-13 18:21:41','2023-06-13 18:21:41',NULL),(843,3666,40720,1562,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',36364.00,NULL,NULL,1,'2023-06-13 18:21:41','2023-06-13 18:21:41',NULL);
INSERT INTO `balance_libro` VALUES (844,3666,40720,1563,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',35747.00,NULL,NULL,1,'2023-06-13 18:22:21','2023-06-13 18:22:21',NULL),(845,3666,40720,1563,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',10253.97,NULL,NULL,1,'2023-06-13 18:22:45','2023-06-13 18:22:45',NULL),(846,3666,40720,1563,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',522720.00,NULL,NULL,1,'2023-06-13 18:22:45','2023-06-13 18:22:45',NULL),(847,3666,40720,1563,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',36364.00,NULL,NULL,1,'2023-06-13 18:22:45','2023-06-13 18:22:45',NULL),(848,3666,40720,1563,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3750.00,NULL,NULL,1,'2023-06-13 18:22:45','2023-06-13 18:22:45',NULL),(849,3666,40720,1564,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',35747.00,NULL,NULL,1,'2023-06-13 18:25:38','2023-06-13 18:25:38',NULL),(850,3666,40720,1564,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',66785.00,NULL,NULL,1,'2023-06-13 18:26:06','2023-06-13 18:26:06',NULL),(851,3666,40720,1564,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',10595.31,NULL,NULL,1,'2023-06-13 18:26:06','2023-06-13 18:26:06',NULL),(852,3666,40720,1564,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3750.00,NULL,NULL,1,'2023-06-13 18:26:06','2023-06-13 18:26:06',NULL),(853,3666,40720,1564,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36364.00,NULL,NULL,1,'2023-06-13 18:26:06','2023-06-13 18:26:06',NULL),(854,3666,40720,1565,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',35747.00,NULL,NULL,1,'2023-06-13 18:28:56','2023-06-13 18:28:56',NULL),(855,3666,40720,1565,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',58080.00,NULL,NULL,1,'2023-06-13 18:28:56','2023-06-13 18:28:56',NULL),(856,3666,40720,1565,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',58080.00,NULL,NULL,1,'2023-06-13 18:28:56','2023-06-13 18:28:56',NULL),(857,3666,40720,1565,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',12598.82,NULL,NULL,1,'2023-06-13 18:29:16','2023-07-09 12:45:43','2023-07-09 12:45:43'),(858,3666,40720,1565,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',45455.00,NULL,NULL,1,'2023-06-13 18:29:16','2023-06-13 18:29:16',NULL),(859,3666,40720,1566,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',35747.00,NULL,NULL,1,'2023-06-13 18:30:30','2023-06-13 18:30:30',NULL),(860,3666,40720,1566,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',59048.00,NULL,NULL,1,'2023-06-13 18:30:30','2023-06-13 18:30:30',NULL),(861,3666,40720,1566,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',4500.00,NULL,NULL,1,'2023-06-13 18:31:29','2023-06-13 18:31:29',NULL),(862,3666,40720,1566,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',13113.05,NULL,NULL,1,'2023-06-13 18:31:29','2023-07-09 12:58:25','2023-07-09 12:58:25'),(863,3666,40720,1566,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',95426.96,NULL,NULL,1,'2023-06-13 18:31:29','2023-06-13 18:31:29',NULL),(864,3666,40720,1566,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4500.00,NULL,NULL,1,'2023-06-13 18:31:29','2023-06-13 18:31:29',NULL);
INSERT INTO `balance_libro` VALUES (865,3666,40720,1566,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',45455.00,NULL,NULL,1,'2023-06-13 18:31:29','2023-06-13 18:31:29',NULL),(866,3666,40720,1567,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',35747.00,NULL,NULL,1,'2023-06-13 18:34:37','2023-06-13 18:34:37',NULL),(867,3666,40720,1567,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',59048.00,NULL,NULL,1,'2023-06-13 18:34:37','2023-06-13 18:34:37',NULL),(868,3666,40720,1567,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',14937.40,NULL,NULL,1,'2023-06-13 18:34:50','2023-07-09 13:02:42','2023-07-09 13:02:42'),(869,3666,40720,1567,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4500.00,NULL,NULL,1,'2023-06-13 18:34:50','2023-06-13 18:34:50',NULL),(870,3666,40720,1567,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',45455.00,NULL,NULL,1,'2023-06-13 18:34:50','2023-06-13 18:34:50',NULL),(871,3666,40720,1568,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',59048.00,NULL,NULL,1,'2023-06-13 18:35:15','2023-06-13 18:35:15',NULL),(872,3666,40720,1568,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',35747.00,NULL,NULL,1,'2023-06-13 18:35:15','2023-06-13 18:35:15',NULL),(873,3666,40720,1568,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',59048.00,NULL,NULL,1,'2023-06-13 18:43:06','2023-06-13 18:45:00','2023-06-13 18:45:00'),(874,3666,40720,1568,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',35747.00,NULL,NULL,1,'2023-06-13 18:43:06','2023-06-13 18:45:07','2023-06-13 18:45:07'),(875,3666,40720,1568,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',5000.00,NULL,NULL,1,'2023-06-13 18:49:18','2023-06-13 18:49:18',NULL),(876,3666,40720,1568,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',15854.49,NULL,NULL,1,'2023-06-13 18:49:18','2023-07-09 13:09:49','2023-07-09 13:09:49'),(877,3666,40720,1568,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1784836.99,NULL,NULL,1,'2023-06-13 18:49:18','2023-06-13 18:51:55','2023-06-13 18:51:55'),(878,3666,40720,1568,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4500.00,NULL,NULL,1,'2023-06-13 18:49:18','2023-06-13 18:49:18',NULL),(879,3666,40720,1568,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',45455.00,NULL,NULL,1,'2023-06-13 18:49:18','2023-06-13 18:49:18',NULL),(880,3666,40720,1568,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1149500.00,NULL,NULL,1,'2023-06-13 18:49:18','2023-06-13 18:52:21','2023-06-13 18:52:21'),(881,3666,40720,1568,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1784836.99,NULL,NULL,1,'2023-06-13 18:51:55','2023-06-13 18:51:55',NULL),(882,3666,40720,1568,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1149500.00,NULL,NULL,1,'2023-06-13 18:52:21','2023-06-13 18:52:21',NULL),(883,3666,40720,1572,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',35747.00,NULL,NULL,1,'2023-06-13 19:25:52','2023-06-13 19:25:52',NULL),(884,3666,40720,1572,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',59048.00,NULL,NULL,1,'2023-06-13 19:25:52','2023-06-13 19:25:52',NULL);
INSERT INTO `balance_libro` VALUES (885,3666,40720,1572,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',35747.00,NULL,NULL,1,'2023-06-13 19:26:02','2023-06-13 19:26:49','2023-06-13 19:26:49'),(886,3666,40720,1572,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',59048.00,NULL,NULL,1,'2023-06-13 19:26:02','2023-06-13 19:26:58','2023-06-13 19:26:58'),(887,3666,40720,1572,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15478.66,NULL,NULL,1,'2023-06-13 19:27:52','2023-07-09 13:12:18','2023-07-09 13:12:18'),(888,3666,40720,1572,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4500.00,NULL,NULL,1,'2023-06-13 19:27:52','2023-06-13 19:27:52',NULL),(889,3666,40720,1572,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',45455.00,NULL,NULL,1,'2023-06-13 19:27:52','2023-06-13 19:27:52',NULL),(890,3666,40720,1573,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',59048.00,NULL,NULL,1,'2023-06-13 19:31:10','2023-06-13 19:31:10',NULL),(891,3666,40720,1573,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',35747.00,NULL,NULL,1,'2023-06-13 19:31:10','2023-06-13 19:31:10',NULL),(892,3666,40720,1573,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',5200.00,NULL,NULL,1,'2023-06-13 19:31:27','2023-06-13 19:31:27',NULL),(893,3666,40720,1573,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',18628.10,NULL,NULL,1,'2023-06-13 19:31:27','2023-07-09 13:14:30','2023-07-09 13:14:30'),(894,3666,40720,1573,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1301127.91,NULL,NULL,1,'2023-06-13 19:31:27','2023-06-13 19:37:56','2023-06-13 19:37:56'),(895,3666,40720,1573,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4500.00,NULL,NULL,1,'2023-06-13 19:31:27','2023-06-13 19:31:27',NULL),(896,3666,40720,1573,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',45455.00,NULL,NULL,1,'2023-06-13 19:31:27','2023-06-13 19:31:27',NULL),(897,3666,40720,1574,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',35747.00,NULL,NULL,1,'2023-06-13 19:32:23','2023-06-13 19:32:23',NULL),(898,3666,40720,1574,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',59048.00,NULL,NULL,1,'2023-06-13 19:32:23','2023-06-13 19:32:23',NULL),(899,3666,40720,1574,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',35747.00,NULL,NULL,1,'2023-06-13 19:32:23','2023-06-13 19:32:23',NULL),(900,3666,40720,1574,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',35747.00,NULL,NULL,1,'2023-06-13 19:32:23','2023-06-13 19:32:23',NULL),(901,3666,40720,1574,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',48400.00,NULL,NULL,1,'2023-06-13 19:32:23','2023-06-13 19:32:23',NULL),(902,3666,40720,1574,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',48400.00,NULL,NULL,1,'2023-06-13 19:32:23','2023-06-13 19:32:23',NULL),(903,3666,40720,1574,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',18602.13,NULL,NULL,1,'2023-06-13 19:32:38','2023-07-09 13:17:38','2023-07-09 13:17:38'),(904,3666,40720,1574,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1301923.49,NULL,NULL,1,'2023-06-13 19:32:38','2023-06-13 19:38:49','2023-06-13 19:38:49');
INSERT INTO `balance_libro` VALUES (905,3666,40720,1574,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6000.00,NULL,NULL,1,'2023-06-13 19:32:38','2023-06-13 19:32:38',NULL),(906,3666,40720,1574,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',61364.00,NULL,NULL,1,'2023-06-13 19:32:38','2023-06-13 19:32:38',NULL),(907,3666,40720,1573,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1301127.91,NULL,NULL,1,'2023-06-13 19:37:56','2023-06-13 19:37:56',NULL),(908,3666,40720,1574,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1301923.49,NULL,NULL,1,'2023-06-13 19:38:49','2023-06-13 19:38:49',NULL),(909,3666,40720,1563,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',58120.00,NULL,NULL,1,'2023-06-19 12:24:37','2023-06-19 12:24:37',NULL),(910,3666,40720,1563,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',42080.00,NULL,NULL,1,'2023-06-19 12:24:37','2023-06-19 12:24:37',NULL),(911,3666,40720,1563,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',46496.00,NULL,NULL,1,'2023-06-19 12:24:37','2023-06-19 12:24:37',NULL),(912,3666,40720,1563,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',42080.00,NULL,NULL,1,'2023-06-19 12:24:37','2023-06-19 12:24:37',NULL),(913,3666,40720,1560,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',14548.00,NULL,NULL,1,'2023-06-19 13:29:15','2023-06-19 13:29:15',NULL),(914,3666,40720,1560,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',14548.00,NULL,NULL,1,'2023-06-19 13:29:15','2023-06-19 13:29:15',NULL),(915,3666,40720,1560,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',18822.00,NULL,NULL,1,'2023-06-19 13:29:15','2023-06-19 13:29:15',NULL),(916,3666,40720,1561,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',15918.00,NULL,NULL,1,'2023-06-19 17:13:16','2023-06-19 17:13:16',NULL),(917,3666,40720,1561,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',15918.00,NULL,NULL,1,'2023-06-19 17:13:16','2023-06-19 17:13:16',NULL),(918,3666,40720,1561,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',19644.00,NULL,NULL,1,'2023-06-19 17:13:16','2023-06-19 17:13:16',NULL),(919,3666,40720,1562,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',14822.00,NULL,NULL,1,'2023-06-19 17:15:16','2023-06-19 17:15:16',NULL),(920,3666,40720,1562,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',14822.00,NULL,NULL,1,'2023-06-19 17:15:16','2023-06-19 17:15:16',NULL),(921,3666,40720,1562,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',18822.00,NULL,NULL,1,'2023-06-19 17:15:16','2023-06-19 17:15:16',NULL),(922,3666,40720,1563,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',14822.00,NULL,NULL,1,'2023-06-19 17:18:57','2023-06-19 17:18:57',NULL),(923,3666,40720,1563,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',14822.00,NULL,NULL,1,'2023-06-19 17:18:57','2023-06-19 17:18:57',NULL),(924,3666,40720,1563,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',18822.00,NULL,NULL,1,'2023-06-19 17:18:57','2023-06-19 17:18:57',NULL),(925,3666,40720,1564,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',14822.00,NULL,NULL,1,'2023-06-19 17:32:47','2023-06-19 17:32:47',NULL);
INSERT INTO `balance_libro` VALUES (926,3666,40720,1564,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',14822.00,NULL,NULL,1,'2023-06-19 17:32:47','2023-06-19 17:32:47',NULL),(927,3666,40720,1564,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',18822.00,NULL,NULL,1,'2023-06-19 17:32:47','2023-06-19 17:32:47',NULL),(928,3666,40720,1564,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',36000.00,NULL,NULL,1,'2023-06-19 17:32:47','2023-06-19 17:32:47',NULL),(929,3666,40720,1564,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',24000.00,NULL,NULL,1,'2023-06-19 17:32:47','2023-06-19 17:32:47',NULL),(930,3666,40720,1564,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',28800.00,NULL,NULL,1,'2023-06-19 17:32:47','2023-06-19 17:32:47',NULL),(931,3666,40720,1564,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',185000.00,NULL,NULL,1,'2023-06-19 17:32:48','2023-06-19 17:32:48',NULL),(936,3666,40720,1565,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',14822.00,NULL,NULL,1,'2023-06-19 17:39:32','2023-06-19 17:39:32',NULL),(937,3666,40720,1565,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',14822.00,NULL,NULL,1,'2023-06-19 17:39:32','2023-06-19 17:39:32',NULL),(938,3666,40720,1565,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',18822.00,NULL,NULL,1,'2023-06-19 17:39:32','2023-06-19 17:39:32',NULL),(939,3666,40720,1565,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',36000.00,NULL,NULL,1,'2023-06-19 17:39:32','2023-06-19 17:39:32',NULL),(940,3666,40720,1565,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',28800.00,NULL,NULL,1,'2023-06-19 17:39:32','2023-06-19 17:39:32',NULL),(941,3666,40720,1565,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',28800.00,NULL,NULL,1,'2023-06-19 17:39:32','2023-06-19 17:39:32',NULL),(942,3666,40720,1565,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',185000.00,NULL,NULL,1,'2023-06-19 17:39:32','2023-06-19 17:39:32',NULL),(943,3666,40720,1566,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',14822.00,NULL,NULL,1,'2023-06-19 18:09:35','2023-06-19 18:09:35',NULL),(944,3666,40720,1566,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',14822.00,NULL,NULL,1,'2023-06-19 18:09:35','2023-06-19 18:09:35',NULL),(945,3666,40720,1566,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',18822.00,NULL,NULL,1,'2023-06-19 18:09:35','2023-06-19 18:09:35',NULL),(946,3666,40720,1566,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',36000.00,NULL,NULL,1,'2023-06-19 18:09:35','2023-06-19 18:09:35',NULL),(947,3666,40720,1566,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',28800.00,NULL,NULL,1,'2023-06-19 18:09:35','2023-06-19 18:09:35',NULL),(948,3666,40720,1566,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',28800.00,NULL,NULL,1,'2023-06-19 18:09:35','2023-06-19 18:09:35',NULL),(949,3666,40720,1566,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',185000.00,NULL,NULL,1,'2023-06-19 18:09:35','2023-06-19 18:09:35',NULL),(950,3666,40720,1567,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',14822.00,NULL,NULL,1,'2023-06-19 18:12:19','2023-06-19 18:12:19',NULL);
INSERT INTO `balance_libro` VALUES (951,3666,40720,1567,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',14822.00,NULL,NULL,1,'2023-06-19 18:12:19','2023-06-19 18:12:19',NULL),(952,3666,40720,1567,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',18822.00,NULL,NULL,1,'2023-06-19 18:12:19','2023-06-19 18:12:19',NULL),(953,3666,40720,1567,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',36000.00,NULL,NULL,1,'2023-06-19 18:12:20','2023-06-19 18:12:20',NULL),(954,3666,40720,1567,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',28800.00,NULL,NULL,1,'2023-06-19 18:12:20','2023-06-19 18:12:20',NULL),(955,3666,40720,1567,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',28800.00,NULL,NULL,1,'2023-06-19 18:12:20','2023-06-19 18:12:20',NULL),(956,3666,40720,1567,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',185000.00,NULL,NULL,1,'2023-06-19 18:12:20','2023-06-19 18:12:20',NULL),(957,3666,40720,1568,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',14822.00,NULL,NULL,1,'2023-06-19 18:14:25','2023-06-19 18:14:25',NULL),(958,3666,40720,1568,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',14822.00,NULL,NULL,1,'2023-06-19 18:14:25','2023-06-19 18:14:25',NULL),(959,3666,40720,1568,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',18822.00,NULL,NULL,1,'2023-06-19 18:14:25','2023-06-19 18:14:25',NULL),(960,3666,40720,1568,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',36000.00,NULL,NULL,1,'2023-06-19 18:14:25','2023-06-19 18:14:25',NULL),(961,3666,40720,1568,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',28800.00,NULL,NULL,1,'2023-06-19 18:14:26','2023-06-19 18:14:26',NULL),(962,3666,40720,1568,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',28800.00,NULL,NULL,1,'2023-06-19 18:14:26','2023-06-19 18:14:26',NULL),(963,3666,40720,1568,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',185000.00,NULL,NULL,1,'2023-06-19 18:14:26','2023-06-19 18:14:26',NULL),(964,3666,40720,1572,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14822.00,NULL,NULL,1,'2023-06-19 18:23:01','2023-06-19 18:23:01',NULL),(965,3666,40720,1572,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14822.00,NULL,NULL,1,'2023-06-19 18:23:01','2023-06-19 18:23:01',NULL),(966,3666,40720,1572,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',18822.00,NULL,NULL,1,'2023-06-19 18:23:01','2023-06-19 18:23:01',NULL),(967,3666,40720,1572,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',43200.00,NULL,NULL,1,'2023-06-19 18:23:01','2023-06-19 18:23:01',NULL),(968,3666,40720,1572,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',28800.00,NULL,NULL,1,'2023-06-19 18:23:01','2023-06-19 18:23:01',NULL),(969,3666,40720,1572,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',28800.00,NULL,NULL,1,'2023-06-19 18:23:01','2023-06-19 18:23:01',NULL),(970,3666,40720,1572,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',40000.00,NULL,NULL,1,'2023-06-19 18:23:01','2023-06-19 18:23:01',NULL),(971,3666,40720,1572,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',185000.00,NULL,NULL,1,'2023-06-19 18:23:01','2023-06-19 18:23:01',NULL);
INSERT INTO `balance_libro` VALUES (972,3666,40720,1573,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',14822.00,NULL,NULL,1,'2023-06-19 18:26:59','2023-06-19 18:26:59',NULL),(973,3666,40720,1573,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',14822.00,NULL,NULL,1,'2023-06-19 18:26:59','2023-06-19 18:26:59',NULL),(974,3666,40720,1573,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',18822.00,NULL,NULL,1,'2023-06-19 18:26:59','2023-06-19 18:26:59',NULL),(975,3666,40720,1573,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',43200.00,NULL,NULL,1,'2023-06-19 18:26:59','2023-06-19 18:26:59',NULL),(976,3666,40720,1573,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',28800.00,NULL,NULL,1,'2023-06-19 18:26:59','2023-06-19 18:26:59',NULL),(977,3666,40720,1573,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',28800.00,NULL,NULL,1,'2023-06-19 18:26:59','2023-06-19 18:26:59',NULL),(978,3666,40720,1573,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',185000.00,NULL,NULL,1,'2023-06-19 18:27:00','2023-06-19 18:27:00',NULL),(979,3666,40720,1574,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',14822.00,NULL,NULL,1,'2023-06-19 18:29:25','2023-06-19 18:29:25',NULL),(980,3666,40720,1574,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',14822.00,NULL,NULL,1,'2023-06-19 18:29:25','2023-06-19 18:29:25',NULL),(981,3666,40720,1574,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',18822.00,NULL,NULL,1,'2023-06-19 18:29:25','2023-06-19 18:29:25',NULL),(982,3666,40720,1574,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',43200.00,NULL,NULL,1,'2023-06-19 18:29:26','2023-06-19 18:29:26',NULL),(983,3666,40720,1574,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',28800.00,NULL,NULL,1,'2023-06-19 18:29:26','2023-06-19 18:29:26',NULL),(984,3666,40720,1574,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',28800.00,NULL,NULL,1,'2023-06-19 18:29:26','2023-06-19 18:29:26',NULL),(985,3666,40720,1574,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',185000.00,NULL,NULL,1,'2023-06-19 18:29:26','2023-06-19 18:29:26',NULL),(992,3666,40720,1560,3,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',56400.00,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(993,3666,40720,1560,3,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',57600.00,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(994,3666,40720,1560,3,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',35100.00,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(995,3666,40720,1560,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',30184.00,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(996,3666,40720,1560,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',30184.00,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(997,3666,40720,1560,3,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',28500.00,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(998,3666,40720,1560,3,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',17100.00,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL);
INSERT INTO `balance_libro` VALUES (999,3666,40720,1560,3,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3999.70,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(1000,3666,40720,1560,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',302.19,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(1001,3666,40720,1560,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',302.87,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(1002,3666,40720,1560,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',4000.01,NULL,NULL,1,'2023-06-19 19:47:26','2023-06-19 19:47:26',NULL),(1003,3666,40720,1561,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-22','2022-05-22',4400.59,NULL,NULL,1,'2023-06-19 20:32:07','2023-06-19 20:32:07',NULL),(1004,3666,40720,1561,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',886.27,NULL,NULL,1,'2023-06-19 20:32:07','2023-06-19 20:32:07',NULL),(1005,3666,40720,1561,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',5400.00,NULL,NULL,1,'2023-06-19 20:32:07','2023-06-19 20:32:07',NULL),(1006,3666,40720,1561,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',5000.07,NULL,NULL,1,'2023-06-19 20:32:07','2023-06-19 20:32:07',NULL),(1007,3666,40720,1561,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',8701.58,NULL,NULL,1,'2023-06-19 20:32:07','2023-06-19 20:32:07',NULL),(1008,3666,40720,1561,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-22','2022-05-22',1000.00,NULL,NULL,1,'2023-06-19 20:32:07','2023-06-19 20:32:07',NULL),(1009,3666,40720,1561,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',220.00,NULL,NULL,1,'2023-06-19 20:32:07','2023-06-19 20:32:07',NULL),(1010,3666,40720,1561,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',630.00,NULL,NULL,1,'2023-06-19 20:32:08','2023-06-19 20:32:08',NULL),(1011,3666,40720,1561,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',4700.00,NULL,NULL,1,'2023-06-19 20:32:08','2023-06-19 20:32:08',NULL),(1012,3666,40720,1562,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',170.00,NULL,NULL,1,'2023-06-19 20:46:14','2023-06-19 20:46:14',NULL),(1013,3666,40720,1562,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1040.00,NULL,NULL,1,'2023-06-19 20:46:14','2023-06-19 20:46:14',NULL),(1014,3666,40720,1562,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',500.00,NULL,NULL,1,'2023-06-19 20:46:14','2023-06-19 20:46:14',NULL),(1015,3666,40720,1562,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',7404.77,NULL,NULL,1,'2023-06-19 20:46:14','2023-06-19 20:46:14',NULL),(1016,3666,40720,1563,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',420.00,NULL,NULL,1,'2023-06-19 21:02:35','2023-06-19 21:02:35',NULL),(1017,3666,40720,1563,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2023-06-19 21:02:35','2023-06-19 21:02:35',NULL),(1018,3666,40720,1564,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',720.00,NULL,NULL,1,'2023-06-20 11:30:13','2023-06-20 11:30:13',NULL),(1019,3666,40720,1564,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',300.00,NULL,NULL,1,'2023-06-20 11:30:13','2023-06-20 11:30:13',NULL);
INSERT INTO `balance_libro` VALUES (1020,3666,40720,1564,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1337.00,NULL,NULL,1,'2023-06-20 11:30:13','2023-06-20 11:30:13',NULL),(1021,3666,40720,1564,3,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',170.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1022,3666,40720,1564,3,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1700.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1023,3666,40720,1564,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2750.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1024,3666,40720,1564,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',470.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1025,3666,40720,1564,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3140.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1026,3666,40720,1564,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',3000.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1027,3666,40720,1564,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',9052.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1028,3666,40720,1564,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',4800.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1029,3666,40720,1564,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',8708.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1030,3666,40720,1564,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',4500.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1031,3666,40720,1564,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',5003.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1032,3666,40720,1564,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',9230.00,NULL,NULL,1,'2023-06-20 11:30:14','2023-06-20 11:30:14',NULL),(1033,3666,40720,1565,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1700.00,NULL,NULL,1,'2023-06-20 11:30:21','2023-06-20 11:30:21',NULL),(1042,3666,40720,1567,3,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',160.00,NULL,NULL,1,'2023-06-20 12:13:37','2023-06-20 12:13:37',NULL),(1043,3666,40720,1567,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',100.00,NULL,NULL,1,'2023-06-20 12:13:37','2023-06-20 12:13:37',NULL),(1044,3666,40720,1567,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',400.00,NULL,NULL,1,'2023-06-20 12:13:37','2023-06-20 12:13:37',NULL),(1045,3666,40720,1567,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',800.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1046,3666,40720,1567,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',16000.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1047,3666,40720,1567,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',600.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1048,3666,40720,1567,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1850.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL);
INSERT INTO `balance_libro` VALUES (1049,3666,40720,1567,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2360.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1050,3666,40720,1567,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1265.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1051,3666,40720,1567,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',60.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1052,3666,40720,1567,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',9700.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1053,3666,40720,1567,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',10500.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1054,3666,40720,1567,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',11137.23,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1055,3666,40720,1567,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7800.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1056,3666,40720,1567,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',7500.00,NULL,NULL,1,'2023-06-20 12:13:38','2023-06-20 12:13:38',NULL),(1057,3666,40720,1568,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',40000.00,NULL,NULL,1,'2023-06-20 18:25:33','2023-06-20 18:25:33',NULL),(1058,3666,40720,1568,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',40000.00,NULL,NULL,1,'2023-06-20 18:41:44','2023-06-20 18:41:44',NULL),(1059,3666,40720,1568,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',26909.48,NULL,NULL,1,'2023-06-20 18:41:44','2023-06-20 18:41:44',NULL),(1060,3666,40720,1568,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',9825.00,NULL,NULL,1,'2023-06-20 18:41:44','2023-06-20 18:41:44',NULL),(1061,3666,40720,1568,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',40000.00,NULL,NULL,1,'2023-06-20 18:41:44','2023-06-20 18:41:44',NULL),(1062,3666,40720,1568,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',7082.80,NULL,NULL,1,'2023-06-20 18:41:45','2023-06-20 18:41:45',NULL),(1063,3666,40720,1568,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',42060.00,NULL,NULL,1,'2023-06-20 18:41:45','2023-06-20 18:41:45',NULL),(1064,3666,40720,1568,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',5350.00,NULL,NULL,1,'2023-06-20 18:41:45','2023-06-20 18:41:45',NULL),(1065,3666,40720,1572,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1100.00,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1066,3666,40720,1572,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',33500.00,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1067,3666,40720,1572,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1600.00,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1068,3666,40720,1572,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1100.00,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1069,3666,40720,1572,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',32700.00,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL);
INSERT INTO `balance_libro` VALUES (1070,3666,40720,1572,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',37150.00,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1071,3666,40720,1572,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1250.94,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1072,3666,40720,1572,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',999.90,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1073,3666,40720,1572,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4900.00,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1074,3666,40720,1572,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7002.00,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1075,3666,40720,1572,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14540.86,NULL,NULL,1,'2023-06-20 19:15:11','2023-06-20 19:15:11',NULL),(1076,3666,40720,1573,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4260.00,NULL,NULL,1,'2023-06-20 19:42:14','2023-06-20 19:42:14',NULL),(1077,3666,40720,1573,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',46853.60,NULL,NULL,1,'2023-06-20 19:42:14','2023-06-20 19:42:14',NULL),(1078,3666,40720,1573,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',40000.00,NULL,NULL,1,'2023-06-20 19:42:14','2023-06-20 19:42:14',NULL),(1079,3666,40720,1573,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',25000.00,NULL,NULL,1,'2023-06-20 19:42:14','2023-06-20 19:42:14',NULL),(1080,3666,40720,1573,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',15000.00,NULL,NULL,1,'2023-06-20 19:42:14','2023-06-20 19:42:14',NULL),(1081,3666,40720,1573,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4000.00,NULL,NULL,1,'2023-06-20 19:42:14','2023-06-20 19:42:14',NULL),(1082,3666,40720,1574,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1300.00,NULL,NULL,1,'2023-06-20 19:50:51','2023-06-20 19:50:51',NULL),(1083,3666,40720,1560,22,196,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,196,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',13086.00,'',NULL,1,'2023-06-21 17:52:12','2023-06-30 17:23:23','2023-06-30 17:23:23'),(1084,3666,40720,1560,20,725,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,725,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',35747.00,NULL,NULL,1,'2023-06-24 11:58:51','2023-06-24 12:03:02','2023-06-24 12:03:02'),(1085,3666,40720,1560,20,726,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,726,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',35747.00,NULL,NULL,1,'2023-06-24 12:04:40','2023-06-24 12:04:40',NULL),(1086,3666,40720,1561,20,727,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,727,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',35747.00,NULL,NULL,1,'2023-06-24 12:09:08','2023-06-24 12:09:08',NULL),(1087,3666,40720,1562,20,728,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,728,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',35747.00,NULL,NULL,1,'2023-06-24 12:10:24','2023-06-24 12:10:24',NULL),(1088,3666,40720,1563,20,729,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,729,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',35747.00,NULL,NULL,1,'2023-06-24 12:11:46','2023-06-24 12:11:46',NULL),(1089,3666,40720,1564,20,730,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,730,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',35747.00,NULL,NULL,1,'2023-06-24 12:16:16','2023-06-24 12:16:16',NULL);
INSERT INTO `balance_libro` VALUES (1090,3666,40720,1565,20,731,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,731,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',35747.00,NULL,NULL,1,'2023-06-24 12:18:32','2023-06-24 12:18:32',NULL),(1091,3666,40720,1566,20,732,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,732,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',35747.00,NULL,NULL,1,'2023-06-24 12:20:14','2023-06-24 12:20:14',NULL),(1092,3666,40720,1568,20,733,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,733,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',71494.00,NULL,NULL,1,'2023-06-24 12:23:10','2023-06-24 12:23:10',NULL),(1093,3666,40720,1572,20,734,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,734,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',35747.00,NULL,NULL,1,'2023-06-24 12:24:05','2023-06-24 12:24:05',NULL),(1094,3666,40720,1573,20,735,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,735,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',35747.00,NULL,NULL,1,'2023-06-24 12:24:58','2023-06-24 12:24:58',NULL),(1095,3666,40720,1575,20,736,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,736,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',89999.99,NULL,NULL,1,'2023-06-24 12:44:41','2023-06-24 12:45:25','2023-06-24 12:45:25'),(1096,3666,40720,1560,20,737,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,737,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',89999.00,NULL,NULL,1,'2023-06-24 12:47:55','2023-06-24 12:47:55',NULL),(1097,3666,40720,1560,20,738,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,738,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',47918.00,NULL,NULL,1,'2023-06-24 13:22:45','2023-06-24 13:22:45',NULL),(1098,3666,40720,1561,20,739,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,739,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',51480.00,NULL,NULL,1,'2023-06-24 13:25:47','2023-06-24 13:25:47',NULL),(1099,3666,40720,1562,20,740,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,740,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',48466.00,NULL,NULL,1,'2023-06-24 13:37:13','2023-06-24 13:37:13',NULL),(1100,3666,40720,1563,20,741,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,741,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',48466.00,NULL,NULL,1,'2023-06-25 18:07:37','2023-06-25 18:07:37',NULL),(1101,3666,40720,1564,20,742,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,742,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',48466.00,NULL,NULL,1,'2023-06-25 18:08:50','2023-06-25 18:08:50',NULL),(1102,3666,40720,1565,20,743,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,743,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',48466.00,NULL,NULL,1,'2023-06-25 18:10:43','2023-06-25 18:10:43',NULL),(1103,3666,40720,1566,20,744,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,744,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',48466.00,NULL,NULL,1,'2023-06-25 18:12:09','2023-06-25 18:12:09',NULL),(1104,3666,40720,1567,20,745,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,745,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',48466.00,NULL,NULL,1,'2023-06-25 18:13:14','2023-06-25 18:13:14',NULL),(1105,3666,40720,1568,20,746,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,746,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',48466.00,NULL,NULL,1,'2023-06-25 18:14:48','2023-06-25 18:14:48',NULL),(1106,3666,40720,1572,20,747,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,747,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',48466.00,NULL,NULL,1,'2023-06-25 18:16:50','2023-06-25 18:16:50',NULL),(1107,3666,40720,1573,20,748,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,748,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',48466.00,NULL,NULL,1,'2023-06-25 18:17:47','2023-06-25 18:17:47',NULL),(1108,3666,40720,1574,20,749,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,749,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',48466.00,NULL,NULL,1,'2023-06-25 18:21:20','2023-06-25 18:21:20',NULL),(1109,3666,40720,1560,22,222,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,222,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',10000.00,'',NULL,1,'2023-06-27 21:39:37','2023-06-30 17:25:41','2023-06-30 17:25:41');
INSERT INTO `balance_libro` VALUES (1110,3666,40720,1560,22,223,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,223,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',10000.00,'',NULL,1,'2023-06-27 21:43:09','2023-06-27 21:43:09',NULL),(1111,3666,40720,1560,22,224,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,224,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',549.28,'',NULL,1,'2023-06-28 00:01:17','2023-06-28 00:01:17',NULL),(1112,3666,40720,1560,22,225,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,225,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',5695.85,'',NULL,1,'2023-06-28 00:04:09','2023-06-28 00:04:09',NULL),(1113,3666,40720,1560,22,226,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,226,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',18235.43,'',NULL,1,'2023-06-28 00:10:29','2023-06-28 00:12:51','2023-06-28 00:12:51'),(1114,3666,40720,1560,22,227,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,227,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',13086.00,'',NULL,1,'2023-06-30 17:22:26','2023-06-30 17:22:26',NULL),(1115,3666,40720,1560,22,228,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,228,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',10000.00,'',NULL,1,'2023-06-30 17:24:38','2023-06-30 17:24:38',NULL),(1116,3666,40720,1560,21,750,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,750,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',30184.00,NULL,NULL,1,'2023-06-30 17:27:35','2023-06-30 17:27:35',NULL),(1117,3666,40720,1560,21,751,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,751,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',30184.00,NULL,NULL,1,'2023-06-30 17:29:07','2023-06-30 17:29:07',NULL),(1118,3666,40720,1560,21,752,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,752,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',5000.00,NULL,NULL,1,'2023-06-30 17:37:47','2023-06-30 17:37:47',NULL),(1119,3666,40720,1560,21,1119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',490.00,'PERC IIBB MISIONES 04-2022',NULL,1,'2023-06-30 17:47:40','2023-06-30 17:47:40',NULL),(1120,3666,40720,1561,22,232,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,232,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',35747.00,'',NULL,1,'2023-06-30 18:04:39','2023-06-30 18:04:39',NULL),(1121,3666,40720,1561,21,1121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',875.80,'PERC IIBB MISIONES 05-2022',NULL,1,'2023-06-30 18:06:19','2023-06-30 18:06:19',NULL),(1122,3666,40720,1561,22,233,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,233,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',313.04,'',NULL,1,'2023-06-30 18:07:31','2023-06-30 18:07:31',NULL),(1123,3666,40720,1561,22,234,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,234,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5557.81,'',NULL,1,'2023-06-30 18:09:02','2023-06-30 18:09:02',NULL),(1124,3666,40720,1561,21,753,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,753,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',9999.99,NULL,NULL,1,'2023-06-30 18:12:22','2023-06-30 18:12:22',NULL),(1125,3666,40720,1562,22,236,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,236,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5045.53,'',NULL,1,'2023-06-30 18:15:17','2023-06-30 18:15:17',NULL),(1126,3666,40720,1561,22,237,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,237,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',30.24,'',NULL,1,'2023-06-30 18:16:18','2023-06-30 18:16:18',NULL),(1127,3666,40720,1563,22,238,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,238,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',35747.00,'',NULL,1,'2023-06-30 18:20:32','2023-06-30 18:20:32',NULL),(1128,3666,40720,1563,22,239,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,239,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5883.31,'',NULL,1,'2023-06-30 18:23:11','2023-06-30 18:23:11',NULL),(1129,3666,40720,1563,21,1129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',875.80,'PERC IIBB MISIONES 07-2022',NULL,1,'2023-06-30 18:24:45','2023-06-30 18:24:45',NULL);
INSERT INTO `balance_libro` VALUES (1130,3666,40720,1563,21,1130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',28000.00,'HONORARIOS PRESIDENCIA 07 2022',NULL,1,'2023-06-30 18:27:23','2023-06-30 18:27:23',NULL),(1131,3666,40720,1564,20,754,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,754,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',53735.00,NULL,NULL,1,'2023-06-30 18:35:51','2023-06-30 18:35:51',NULL),(1132,3666,40720,1579,22,241,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,241,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5312.23,'',NULL,1,'2023-06-30 18:38:02','2023-06-30 18:48:00','2023-06-30 18:48:00'),(1133,3666,40720,1579,22,242,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,242,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',429.65,'',NULL,1,'2023-06-30 18:38:38','2023-06-30 18:48:04','2023-06-30 18:48:04'),(1134,3666,40720,1564,21,755,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,755,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',11250.00,NULL,NULL,1,'2023-06-30 18:41:08','2023-06-30 18:41:08',NULL),(1135,3666,40720,1564,21,1135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1316.50,'PERC IIBB MISIONES 08-2022',NULL,1,'2023-06-30 18:44:11','2023-06-30 18:44:11',NULL),(1136,3666,40720,1579,22,244,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,244,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5312.23,'',NULL,1,'2023-06-30 18:48:41','2023-06-30 18:56:40','2023-06-30 18:56:40'),(1137,3666,40720,1579,22,245,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,245,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',429.65,'',NULL,1,'2023-06-30 18:49:41','2023-06-30 18:56:46','2023-06-30 18:56:46'),(1138,3666,40720,1564,22,246,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,246,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5741.88,'',NULL,1,'2023-06-30 18:58:03','2023-06-30 18:58:03',NULL),(1139,3666,40720,1565,22,247,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,247,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4973.43,'',NULL,1,'2023-06-30 19:01:11','2023-06-30 19:01:11',NULL),(1140,3666,40720,1566,20,756,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,756,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',62425.00,NULL,NULL,1,'2023-06-30 19:03:40','2023-06-30 19:03:40',NULL),(1141,3666,40720,1566,20,757,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,757,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',59048.00,NULL,NULL,1,'2023-06-30 19:04:37','2023-06-30 19:04:37',NULL),(1142,3666,40720,1566,22,250,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,250,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5720.10,'',NULL,1,'2023-06-30 19:06:00','2023-06-30 19:06:00',NULL),(1143,3666,40720,1566,21,1143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2976.08,'PERC IIBB MISIONES 10-2022',NULL,1,'2023-06-30 19:07:49','2023-06-30 19:07:49',NULL),(1144,3666,40720,1567,20,758,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,758,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',59048.00,NULL,NULL,1,'2023-06-30 19:10:31','2023-06-30 19:10:31',NULL),(1145,3666,40720,1567,22,252,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,252,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6408.88,'',NULL,1,'2023-06-30 19:12:55','2023-06-30 19:12:55',NULL),(1146,3666,40720,1567,21,1146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1446.67,'PERC IIBB MISIONES 11-2022',NULL,1,'2023-06-30 19:14:47','2023-06-30 19:14:47',NULL),(1147,3666,40720,1567,21,759,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,759,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',12000.00,NULL,NULL,1,'2023-06-30 19:20:21','2023-06-30 19:20:21',NULL),(1148,3666,40720,1567,21,1148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',28000.00,'HONORARIOS PRESIDENCIA 10 2022',NULL,1,'2023-06-30 19:21:44','2023-06-30 19:21:44',NULL);
INSERT INTO `balance_libro` VALUES (1149,3666,40720,1568,20,760,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,760,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',59048.00,NULL,NULL,1,'2023-06-30 19:24:08','2023-06-30 19:24:08',NULL),(1150,3666,40720,1568,22,255,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,255,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',6986.26,'',NULL,1,'2023-06-30 19:25:15','2023-06-30 19:25:15',NULL),(1151,3666,40720,1568,21,761,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,761,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',80000.00,NULL,NULL,1,'2023-06-30 19:27:54','2023-06-30 19:27:54',NULL),(1152,3666,40720,1568,21,1152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1446.67,'PERC IIBB MISIONES 12-2022',NULL,1,'2023-06-30 19:28:51','2023-06-30 19:28:51',NULL),(1153,3666,40720,1568,21,762,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,762,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',12000.00,NULL,NULL,1,'2023-06-30 19:32:00','2023-06-30 19:32:00',NULL),(1154,3666,40720,1568,21,1154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',28000.00,'HONORARIOS PRESIDENCIA 11 2022',NULL,1,'2023-06-30 19:33:20','2023-07-05 10:57:05','2023-07-05 10:57:05'),(1155,3666,40720,1572,20,763,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,763,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',59048.00,NULL,NULL,1,'2023-07-05 08:57:31','2023-07-05 08:57:31',NULL),(1156,3666,40720,1572,22,259,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,259,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',129300.00,'',NULL,1,'2023-07-05 08:59:37','2023-07-05 08:59:37',NULL),(1157,3666,40720,1572,22,260,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,260,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10080.18,'',NULL,1,'2023-07-05 09:00:51','2023-07-05 09:20:05','2023-07-05 09:20:05'),(1158,3666,40720,1572,22,261,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,261,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2803.42,'',NULL,1,'2023-07-05 09:01:43','2023-07-05 09:01:43',NULL),(1159,3666,40720,1572,21,1159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4870.46,'IIBB MISIONES 01-2023',NULL,1,'2023-07-05 09:19:26','2023-07-05 09:19:26',NULL),(1160,3666,40720,1572,22,262,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,262,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',9824.24,'',NULL,1,'2023-07-05 09:20:43','2023-07-05 09:20:43',NULL),(1161,3666,40720,1572,21,764,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,764,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',9000.00,NULL,NULL,1,'2023-07-05 09:27:09','2023-07-05 09:27:09',NULL),(1162,3666,40720,1572,21,765,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,765,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',255582.50,NULL,NULL,1,'2023-07-05 09:32:32','2023-07-05 09:32:32',NULL),(1163,3666,40720,1572,21,766,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,766,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',44365.83,NULL,NULL,1,'2023-07-05 09:34:01','2023-07-05 09:34:01',NULL),(1164,3666,40720,1573,20,767,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,767,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',59048.00,NULL,NULL,1,'2023-07-05 09:46:08','2023-07-05 09:58:19','2023-07-05 09:58:19'),(1165,3666,40720,1573,22,267,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,267,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',35747.00,'',NULL,1,'2023-07-05 09:47:31','2023-07-05 09:47:31',NULL),(1166,3666,40720,1573,22,268,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,268,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',201800.00,'',NULL,1,'2023-07-05 09:48:07','2023-07-05 09:48:07',NULL),(1167,3666,40720,1574,22,269,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,269,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',14640.17,'',NULL,1,'2023-07-05 09:49:40','2023-07-05 10:00:32','2023-07-05 10:00:32');
INSERT INTO `balance_libro` VALUES (1168,3666,40720,1573,21,1168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7582.53,'IIBB MISIONES 02-2023',NULL,1,'2023-07-05 09:53:13','2023-07-05 09:53:13',NULL),(1169,3666,40720,1573,20,768,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,768,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',59048.00,NULL,NULL,1,'2023-07-05 10:00:08','2023-07-05 10:00:08',NULL),(1170,3666,40720,1573,22,271,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,271,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',12687.59,'',NULL,1,'2023-07-05 10:01:08','2023-07-05 10:10:43','2023-07-05 10:10:43'),(1171,3666,40720,1573,22,272,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,272,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1952.58,'',NULL,1,'2023-07-05 10:03:18','2023-07-05 10:03:18',NULL),(1172,3666,40720,1573,22,273,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,273,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',12687.59,'',NULL,1,'2023-07-05 10:11:34','2023-07-05 10:11:34',NULL),(1173,3666,40720,1573,22,274,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,274,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1.00,'',NULL,1,'2023-07-05 10:13:30','2023-07-05 10:13:30',NULL),(1174,3666,40720,1574,20,769,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,769,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',40000.00,NULL,NULL,1,'2023-07-05 10:26:48','2023-07-05 10:26:48',NULL),(1175,3666,40720,1574,20,770,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,770,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',59048.00,NULL,NULL,1,'2023-07-05 10:27:37','2023-07-05 10:27:37',NULL),(1176,3666,40720,1574,22,277,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,277,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',35747.00,'',NULL,1,'2023-07-05 10:29:13','2023-07-05 10:29:13',NULL),(1177,3666,40720,1574,22,278,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,278,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',8852.37,'',NULL,1,'2023-07-05 10:34:50','2023-07-05 10:34:50',NULL),(1178,3666,40720,1574,22,279,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,279,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1156.39,'',NULL,1,'2023-07-05 10:38:35','2023-07-05 10:38:35',NULL),(1179,3666,40720,1574,21,771,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,771,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',18000.00,NULL,NULL,1,'2023-07-05 10:51:10','2023-07-05 10:51:10',NULL),(1180,3666,40720,1574,21,1180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3518.00,'IIBB MISIONES 03-2023',NULL,1,'2023-07-05 10:53:27','2023-07-05 10:53:27',NULL),(1181,3666,40720,1574,21,1181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',28000.00,'HONORARIOS PRESIDENCIA 03 2023',NULL,1,'2023-07-05 10:56:05','2023-07-05 10:56:05',NULL),(1182,3666,40720,1568,21,1182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',28000.00,'HONORARIOS PRESIDENCIA 11 2022',NULL,1,'2023-07-05 10:57:05','2023-07-05 10:57:05',NULL),(1183,3666,40720,1574,22,281,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,281,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1.00,'',NULL,1,'2023-07-05 10:59:16','2023-07-05 10:59:16',NULL),(1184,3666,40720,1560,20,1184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',44550000.00,'COBRO SALDO VENTA SEDE U$S 405.000',NULL,1,'2023-07-05 17:01:48','2023-07-05 17:01:48',NULL),(1185,3666,40720,1560,22,283,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,283,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2430.00,'',NULL,1,'2023-07-05 17:14:58','2023-07-05 17:21:34','2023-07-05 17:21:34'),(1186,3666,40720,1560,22,284,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,284,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2430.00,'',NULL,1,'2023-07-05 17:23:54','2023-07-05 17:38:03','2023-07-05 17:38:03');
INSERT INTO `balance_libro` VALUES (1187,3666,40720,1560,22,285,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,285,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',267300.00,'',NULL,1,'2023-07-05 17:39:46','2023-07-05 17:39:46',NULL),(1188,3666,40720,1561,22,286,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,286,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',521664.00,'',NULL,1,'2023-07-05 17:43:55','2023-07-05 17:43:55',NULL),(1189,3666,40720,1561,22,287,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,287,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',132000.00,'',NULL,1,'2023-07-05 17:46:12','2023-07-05 17:46:12',NULL),(1190,3666,40720,1561,22,1190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',11000000.00,'RETIRO U$S 100.000',NULL,1,'2023-07-05 17:48:18','2023-07-05 17:48:18',NULL),(1191,3666,40720,1563,22,1191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11000000.00,'RETIRO U$S 100.000',NULL,1,'2023-07-05 17:52:24','2023-07-05 17:52:24',NULL),(1192,3666,40720,1563,22,1192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11000000.00,'RETIRO U$S 100.000',NULL,1,'2023-07-05 17:53:21','2023-07-05 17:53:21',NULL),(1193,3666,40720,1563,22,1193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',10692000.00,'RETIRO U$S 97.200',NULL,1,'2023-07-05 17:54:39','2023-07-05 17:54:39',NULL),(1194,3666,40720,1561,3,1194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1315000.00,'PAGO ANTICIPO COMPRA SEDE U$S 10.000 A $131,5',NULL,1,'2023-07-08 12:00:59','2023-07-08 12:00:59',NULL),(1195,3666,40720,1563,3,1195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',59175000.00,'ESCRITURA DE COMPRA PREDIO AV QUARANTA',NULL,1,'2023-07-08 12:12:37','2023-07-08 12:12:37',NULL),(1196,3666,40720,1574,21,772,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,772,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',40950.07,NULL,NULL,1,'2023-07-08 14:15:14','2023-07-08 14:15:14',NULL),(1197,3666,40720,1574,21,773,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,773,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',860405.00,NULL,NULL,1,'2023-07-08 14:20:39','2023-07-08 14:20:39',NULL),(1198,3666,40720,1574,21,774,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,774,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',157304.80,NULL,NULL,1,'2023-07-08 14:25:55','2023-07-08 14:25:55',NULL),(1199,3666,40720,1574,21,775,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,775,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1491.33,NULL,NULL,1,'2023-07-08 14:26:44','2023-07-08 14:26:44',NULL),(1200,3666,40720,1574,21,776,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,776,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',140785.45,NULL,NULL,1,'2023-07-08 14:30:03','2023-07-08 14:30:03',NULL),(1201,3666,40720,1574,21,777,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,777,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',820.00,NULL,NULL,1,'2023-07-08 14:31:23','2023-07-08 14:31:23',NULL),(1202,3666,40720,1574,21,778,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,778,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4000.01,NULL,NULL,1,'2023-07-08 14:32:41','2023-07-08 14:32:41',NULL),(1203,3666,40720,1574,21,779,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,779,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1850.00,NULL,NULL,1,'2023-07-08 14:33:21','2023-07-08 14:33:21',NULL),(1204,3666,40720,1574,21,780,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,780,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',10206.42,NULL,NULL,1,'2023-07-08 14:38:06','2023-07-08 14:38:06',NULL),(1205,3666,40720,1574,21,781,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,781,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4200.00,NULL,NULL,1,'2023-07-08 14:38:54','2023-07-08 14:38:54',NULL);
INSERT INTO `balance_libro` VALUES (1206,3666,40720,1574,21,782,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,782,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',9800.59,NULL,NULL,1,'2023-07-08 14:39:48','2023-07-08 14:39:48',NULL),(1207,3666,40720,1574,21,783,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,783,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',48000.00,NULL,NULL,1,'2023-07-08 14:40:38','2023-07-08 14:40:38',NULL),(1208,3666,40720,1574,21,784,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,784,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',325000.00,NULL,NULL,1,'2023-07-08 15:16:35','2023-07-08 15:16:35',NULL),(1209,3666,40720,1574,21,785,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,785,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',95426.96,NULL,NULL,1,'2023-07-08 15:17:47','2023-07-08 15:17:47',NULL),(1210,3666,40720,1574,21,786,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,786,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1404888.66,NULL,NULL,1,'2023-07-08 15:19:18','2023-07-08 15:19:18',NULL),(1211,3666,40720,1574,21,787,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,787,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1149500.00,NULL,NULL,1,'2023-07-08 15:20:12','2023-07-08 15:20:12',NULL),(1212,3666,40720,1574,21,788,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,788,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2603051.40,NULL,NULL,1,'2023-07-08 15:21:02','2023-07-08 15:21:02',NULL),(1213,3666,40720,1574,21,789,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,789,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',45600.00,NULL,NULL,1,'2023-07-08 15:21:53','2023-07-08 15:21:53',NULL),(1214,3666,40720,1574,21,790,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,790,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',28489.60,NULL,NULL,1,'2023-07-08 15:23:24','2023-07-08 15:23:24',NULL),(1215,3666,40720,1574,21,791,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,791,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2980.00,NULL,NULL,1,'2023-07-08 15:24:05','2023-07-08 15:24:05',NULL),(1216,3666,40720,1574,21,792,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,792,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4700.00,NULL,NULL,1,'2023-07-08 15:24:56','2023-07-08 15:24:56',NULL),(1217,3666,40720,1574,21,793,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,793,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',10110.00,NULL,NULL,1,'2023-07-08 15:25:59','2023-07-08 15:25:59',NULL),(1218,3666,40720,1574,21,794,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,794,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1700.00,NULL,NULL,1,'2023-07-08 15:34:49','2023-07-08 15:34:49',NULL),(1219,3666,40720,1574,21,795,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,795,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2750.00,NULL,NULL,1,'2023-07-08 15:35:34','2023-07-08 15:35:34',NULL),(1220,3666,40720,1574,21,796,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,796,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',470.00,NULL,NULL,1,'2023-07-08 15:38:59','2023-07-08 15:38:59',NULL),(1221,3666,40720,1574,21,797,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,797,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',5500.00,NULL,NULL,1,'2023-07-08 15:42:12','2023-07-08 15:42:12',NULL),(1222,3666,40720,1574,21,798,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,798,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',15637.23,NULL,NULL,1,'2023-07-08 15:43:02','2023-07-08 15:43:02',NULL),(1223,3666,40720,1574,21,799,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,799,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',160.00,NULL,NULL,1,'2023-07-08 15:44:28','2023-07-08 15:44:28',NULL),(1224,3666,40720,1574,21,800,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,800,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',400.00,NULL,NULL,1,'2023-07-08 15:45:36','2023-07-08 15:45:36',NULL),(1225,3666,40720,1574,21,801,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,801,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',800.00,NULL,NULL,1,'2023-07-08 15:46:51','2023-07-08 15:46:51',NULL);
INSERT INTO `balance_libro` VALUES (1226,3666,40720,1574,21,802,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,802,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',16000.00,NULL,NULL,1,'2023-07-08 15:47:42','2023-07-08 15:47:42',NULL),(1227,3666,40720,1574,21,803,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,803,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1265.00,NULL,NULL,1,'2023-07-08 15:48:47','2023-07-08 15:48:47',NULL),(1228,3666,40720,1574,21,804,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,804,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',60.00,NULL,NULL,1,'2023-07-08 15:52:05','2023-07-08 15:52:05',NULL),(1229,3666,40720,1574,21,805,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,805,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',9700.00,NULL,NULL,1,'2023-07-08 15:53:42','2023-07-08 15:53:42',NULL),(1230,3666,40720,1574,21,806,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,806,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',7500.00,NULL,NULL,1,'2023-07-08 15:54:59','2023-07-08 15:54:59',NULL),(1231,3666,40720,1574,21,807,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,807,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',377263.60,NULL,NULL,1,'2023-07-08 15:55:39','2023-07-08 15:55:39',NULL),(1232,3666,40720,1574,21,808,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,808,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',26909.48,NULL,NULL,1,'2023-07-08 15:57:41','2023-07-08 15:57:41',NULL),(1233,3666,40720,1574,21,809,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,809,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',16907.80,NULL,NULL,1,'2023-07-08 15:58:29','2023-07-08 15:58:29',NULL),(1234,3666,40720,1574,21,810,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,810,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',11350.00,NULL,NULL,1,'2023-07-08 15:59:31','2023-07-08 15:59:31',NULL),(1235,3666,40720,1574,21,811,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,811,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1600.00,NULL,NULL,1,'2023-07-08 16:02:35','2023-07-08 16:02:35',NULL),(1236,3666,40720,1574,21,812,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,812,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1250.94,NULL,NULL,1,'2023-07-08 16:04:13','2023-07-08 16:04:13',NULL),(1237,3666,40720,1574,21,813,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,813,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',7002.00,NULL,NULL,1,'2023-07-08 16:05:18','2023-07-08 16:05:18',NULL),(1238,3666,40720,1574,21,814,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,814,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',14540.86,NULL,NULL,1,'2023-07-08 16:06:34','2023-07-08 16:06:34',NULL),(1239,3666,40720,1574,21,815,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,815,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4260.00,NULL,NULL,1,'2023-07-08 16:08:00','2023-07-08 16:08:00',NULL),(1240,3666,40720,1574,21,816,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,816,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',15000.00,NULL,NULL,1,'2023-07-08 16:08:50','2023-07-08 16:08:50',NULL),(1241,3666,40720,1574,21,817,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,817,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',149100.00,NULL,NULL,1,'2023-07-08 16:09:42','2023-07-08 16:09:42',NULL),(1242,3666,40720,1527,16,96,'App\\Models\\PeriodLiquidation',NULL,96,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',0.00,NULL,NULL,1,'2023-07-09 11:46:58','2023-07-09 11:50:31','2023-07-09 11:50:31'),(1243,3666,40720,1574,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',591567.85,NULL,NULL,1,'2023-07-09 12:35:47','2023-07-09 13:19:50','2023-07-09 13:19:50'),(1244,3666,40720,1565,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',12598.82,NULL,NULL,1,'2023-07-09 12:45:43','2023-07-09 12:45:43',NULL),(1245,3666,40720,1565,15,528,'App\\Models\\PeriodLiquidation',NULL,528,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',20160.00,NULL,NULL,1,'2023-07-09 12:49:23','2023-07-09 12:49:23',NULL);
INSERT INTO `balance_libro` VALUES (1246,3666,40720,1565,15,1246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',18065.63,'COMPENSACION IVA 09-2022',NULL,1,'2023-07-09 12:53:01','2023-07-09 12:53:01',NULL),(1247,3666,40720,1566,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',13113.05,NULL,NULL,1,'2023-07-09 12:58:25','2023-07-09 12:58:25',NULL),(1248,3666,40720,1566,15,530,'App\\Models\\PeriodLiquidation',NULL,530,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',20322.41,NULL,NULL,1,'2023-07-09 12:59:56','2023-07-09 12:59:56',NULL),(1249,3666,40720,1567,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',14937.40,NULL,NULL,1,'2023-07-09 13:02:42','2023-07-09 13:02:42',NULL),(1250,3666,40720,1567,15,532,'App\\Models\\PeriodLiquidation',NULL,532,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13317.58,NULL,NULL,1,'2023-07-09 13:03:53','2023-07-09 13:03:53',NULL),(1251,3666,40720,1568,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',15854.49,NULL,NULL,1,'2023-07-09 13:09:49','2023-07-09 13:09:49',NULL),(1252,3666,40720,1568,15,534,'App\\Models\\PeriodLiquidation',NULL,534,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',505585.13,NULL,NULL,1,'2023-07-09 13:10:45','2023-07-09 13:10:45',NULL),(1253,3666,40720,1572,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15478.67,NULL,NULL,1,'2023-07-09 13:12:18','2023-07-09 13:12:18',NULL),(1254,3666,40720,1572,15,536,'App\\Models\\PeriodLiquidation',NULL,536,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',498689.11,NULL,NULL,1,'2023-07-09 13:13:03','2025-06-04 19:05:21','2025-06-04 19:05:21'),(1255,3666,40720,1573,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',18628.10,NULL,NULL,1,'2023-07-09 13:14:30','2023-07-09 13:14:30',NULL),(1256,3666,40720,1573,15,538,'App\\Models\\PeriodLiquidation',NULL,538,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',712091.94,NULL,NULL,1,'2023-07-09 13:15:35','2023-07-09 13:15:35',NULL),(1257,3666,40720,1574,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',18602.13,NULL,NULL,1,'2023-07-09 13:17:38','2023-07-09 13:17:38',NULL),(1258,3666,40720,1574,15,540,'App\\Models\\PeriodLiquidation',NULL,540,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',925885.24,NULL,NULL,1,'2023-07-09 13:18:33','2023-07-09 13:19:30','2023-07-09 13:19:30'),(1259,3666,40720,1574,15,542,'App\\Models\\PeriodLiquidation',NULL,542,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',925885.24,NULL,NULL,1,'2023-07-09 13:20:25','2023-07-09 13:20:25',NULL),(1260,3666,40720,1574,16,1260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4264852.07,'REGISTRACION SALDO A FAVOR IIBB MISIONES',NULL,1,'2023-07-09 13:27:05','2023-07-09 13:27:05',NULL),(1261,3666,40720,1564,21,826,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,826,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',439163.93,NULL,NULL,1,'2023-07-09 15:13:37','2023-07-09 15:13:37',NULL),(1262,3666,40720,1574,20,827,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,827,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1480000.00,NULL,NULL,1,'2023-07-09 15:31:37','2023-07-09 15:31:37',NULL),(1263,3666,40720,1574,20,828,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,828,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',276896.00,NULL,NULL,1,'2023-07-09 15:33:06','2023-07-09 15:33:06',NULL),(1264,3666,40720,1574,20,829,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,829,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',267680.00,NULL,NULL,1,'2023-07-09 15:34:43','2023-07-09 15:34:43',NULL),(1265,3666,40720,1574,20,830,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,830,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',367720.00,NULL,NULL,1,'2023-07-09 15:35:35','2023-07-09 15:35:35',NULL);
INSERT INTO `balance_libro` VALUES (1266,3666,40720,1560,21,1266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',28000.00,'HONORARIOS PRESIDENCIA 04 2022',NULL,1,'2023-07-09 15:45:26','2023-07-09 15:45:26',NULL),(1267,3666,40720,1561,21,1267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',28000.00,'HONORARIOS PRESIDENCIA 05 2022',NULL,1,'2023-07-09 15:46:17','2023-07-09 15:46:17',NULL),(1268,3666,40720,1562,21,1268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',28000.00,'HONORARIOS PRESIDENCIA 06 2022',NULL,1,'2023-07-09 15:47:43','2023-07-09 15:47:43',NULL),(1269,3666,40720,1564,21,1269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',28000.00,'HONORARIOS PRESIDENCIA 08 2022',NULL,1,'2023-07-09 15:49:55','2023-07-09 15:49:55',NULL),(1270,3666,40720,1565,21,1270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',28000.00,'HONORARIOS PRESIDENCIA 09 2022',NULL,1,'2023-07-09 15:51:00','2023-07-09 15:51:00',NULL),(1271,3666,40720,1568,21,1271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',28000.00,'HONORARIOS PRESIDENCIA 12 2022',NULL,1,'2023-07-09 15:52:51','2023-07-09 15:52:51',NULL),(1272,3666,40720,1572,21,1272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',28000.00,'HONORARIOS PRESIDENCIA 01 2023',NULL,1,'2023-07-09 15:54:52','2023-07-09 15:54:52',NULL),(1273,3666,40720,1573,21,1273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',28000.00,'HONORARIOS PRESIDENCIA 02 2022',NULL,1,'2023-07-09 15:56:14','2023-07-09 15:56:14',NULL),(1274,3666,40720,1574,4,1274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',670250.00,'AMORTIZACION EDIFICIO 2° AÑO',NULL,1,'2023-07-09 15:59:57','2023-07-09 15:59:57',NULL),(1275,3666,40720,1574,4,1275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1183500.00,'AMORTIZACION INMUEBLE 1° AÑO',NULL,1,'2023-07-09 16:07:51','2023-07-09 16:07:51',NULL),(1276,3666,40720,1574,19,1276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',487500.00,'AJUSTE CREDITO SERGIO DELAPIERRE U$S 5000 A $207.5',NULL,1,'2023-07-09 16:35:49','2023-07-09 16:35:49',NULL),(1277,3666,40720,1574,19,1277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',311250.00,'CANCELACION PARCIAL CREDITO SERGIO DELAPIERRE U$S 1500 A $207.50',NULL,1,'2023-07-09 16:38:16','2023-07-09 16:38:16',NULL),(1278,3666,40720,1574,23,1278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',112691578.69,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 16:42:39','2023-07-09 16:57:48','2023-07-09 16:57:48'),(1279,3666,40720,1574,23,1279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',71070618.03,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 16:58:57','2023-07-09 18:05:25','2023-07-09 18:05:25'),(1280,3666,40720,1574,17,1280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',69107271.86,'REFUNDICION DE CUENTAS',NULL,1,'2023-07-09 17:08:44','2023-07-09 18:05:25','2023-07-09 18:05:25'),(1281,3666,40720,1574,23,1281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6995155.56,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 18:08:17','2023-07-09 18:09:31','2023-07-09 18:09:31'),(1282,3666,40720,1574,23,1282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6847069.71,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 18:11:03','2023-07-09 18:13:03','2023-07-09 18:13:03');
INSERT INTO `balance_libro` VALUES (1283,3666,40720,1574,23,1283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5879101.64,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 18:16:57','2023-07-09 18:43:41','2023-07-09 18:43:41'),(1284,3666,40720,1574,19,1284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',178191.00,'AJUSTE SALDO CTA CTE DOLARES BBVA FRANCES',NULL,1,'2023-07-09 18:50:03','2023-07-09 18:50:03',NULL),(1285,3666,40720,1574,23,1285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5786080.56,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 18:55:23','2023-07-09 18:56:14','2023-07-09 18:56:14'),(1286,3666,40720,1574,23,1286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5786080.56,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 18:58:19','2023-07-09 19:00:15','2023-07-09 19:00:15'),(1287,3666,40720,1574,23,1287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5786080.56,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 19:01:13','2023-07-09 21:08:58','2023-07-09 21:08:58'),(1288,3666,40720,1574,23,1288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',112691578.69,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 21:10:54','2023-07-09 21:50:19','2023-07-09 21:50:19'),(1289,3666,40720,1574,23,1289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',112691578.69,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-07-09 21:51:41','2023-07-09 21:51:43',NULL),(1290,3666,40720,1574,17,1290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',49637549.40,'REFUNDICION DE CUENTAS',NULL,1,'2023-07-11 21:54:02','2023-07-11 21:54:02',NULL),(1291,3666,40720,1574,17,1291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',43806585.40,'PASE DE RDO DEL EJ A RDO NO ASIGNADO',NULL,1,'2023-07-11 21:58:00','2023-07-11 21:58:00',NULL),(1292,3666,40849,4566,12,1292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35251859.08,'ASIENTO DE REAPERTURA CTAS PATRIMONIALES',NULL,1,'2023-07-25 19:59:43','2023-08-07 21:46:18','2023-08-07 21:46:18'),(1293,3666,40849,4566,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',4991250.00,NULL,NULL,1,'2023-07-25 20:11:44','2024-04-06 12:23:08','2024-04-06 12:23:08'),(1294,3666,40849,4570,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',12100000.00,NULL,NULL,1,'2023-07-25 20:14:40','2024-04-06 12:23:16','2024-04-06 12:23:16'),(1295,3666,40849,4571,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',6745750.00,NULL,NULL,1,'2023-07-25 20:15:37','2024-04-06 12:23:20','2024-04-06 12:23:20'),(1296,3666,40849,4572,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9740500.00,NULL,NULL,1,'2023-07-25 20:18:22','2024-04-06 12:23:28','2024-04-06 12:23:28'),(1297,3666,40849,4572,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6957500.00,NULL,NULL,1,'2023-07-25 20:18:59','2024-04-06 12:23:36','2024-04-06 12:23:36'),(1298,3666,40849,4573,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',7199500.00,NULL,NULL,1,'2023-07-25 20:20:20','2024-04-06 12:23:41','2024-04-06 12:23:41'),(1299,3666,40849,4573,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',7245576.80,NULL,NULL,1,'2023-07-25 20:21:45','2024-04-06 12:23:47','2024-04-06 12:23:47');
INSERT INTO `balance_libro` VALUES (1300,3666,40849,4575,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',8276062.00,NULL,NULL,1,'2023-07-25 20:26:08','2024-04-06 12:23:51','2024-04-06 12:23:51'),(1301,3666,40849,4577,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',6620849.80,NULL,NULL,1,'2023-07-25 20:28:15','2024-04-06 12:23:54','2024-04-06 12:23:54'),(1302,3666,40849,4566,3,1302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1931259.53,'COMPRAS 01-2022',NULL,1,'2023-07-25 20:36:25','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1303,3666,40849,4567,3,1303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',645959.07,'COMPRAS 02-2022',NULL,1,'2023-07-25 20:40:50','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1304,3666,40849,4568,3,1304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1614203.41,'COMPRAS 03-2022',NULL,1,'2023-07-25 20:43:48','2023-07-25 20:59:24','2023-07-25 20:59:24'),(1305,3666,40849,4569,3,1305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',704453.19,'COMPRAS 04-2022',NULL,1,'2023-07-25 20:45:52','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1306,3666,40849,4570,3,1306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700111.65,'COMPRAS 05-2022',NULL,1,'2023-07-25 20:47:24','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1307,3666,40849,4571,3,1307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',306665.02,'COMPRAS 06-2022',NULL,1,'2023-07-25 20:48:37','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1308,3666,40849,4572,3,1308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1883116.73,'COMPRAS 07-2022',NULL,1,'2023-07-25 20:50:38','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1309,3666,40849,4573,3,1309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1428278.24,'COMPRAS 08-2022',NULL,1,'2023-07-25 20:52:04','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1310,3666,40849,4574,3,1310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2856202.17,'COMPRAS 09-2022',NULL,1,'2023-07-25 20:54:02','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1311,3666,40849,4575,3,1311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1358168.12,'COMPRAS 10-2022',NULL,1,'2023-07-25 20:55:11','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1312,3666,40849,4576,3,1312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',318782.20,'COMPRAS 11-2022',NULL,1,'2023-07-25 20:56:16','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1313,3666,40849,4577,3,1313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1035156.42,'COMPRAS 12-2022',NULL,1,'2023-07-25 20:57:21','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1314,3666,40849,4568,3,1314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1614203.41,'COMPRAS 03-2022',NULL,1,'2023-07-25 20:59:24','2024-04-06 14:00:08','2024-04-06 14:00:08'),(1315,3666,40849,4566,1,1315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',116705.00,'SUELDOS 01-2022',NULL,1,'2023-07-26 17:07:00','2024-04-06 14:00:37','2024-04-06 14:00:37'),(1316,3666,40849,4568,1,1316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',117300.00,'SUELDOS 03-2022',NULL,1,'2023-07-26 17:10:02','2024-04-06 14:00:37','2024-04-06 14:00:37');
INSERT INTO `balance_libro` VALUES (1317,3666,40849,4569,1,1317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',117300.00,'SUELDOS 04-2022',NULL,1,'2023-07-26 17:12:10','2024-04-06 14:00:37','2024-04-06 14:00:37'),(1318,3666,40849,4570,1,1318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',658574.86,'SUELDOS 05-2022',NULL,1,'2023-07-26 17:17:36','2024-04-06 14:00:37','2024-04-06 14:00:37'),(1319,3666,40849,4571,1,1319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1237985.29,'SUELDOS 06-2022',NULL,1,'2023-07-26 17:21:12','2024-04-06 14:00:37','2024-04-06 14:00:37'),(1320,3666,40849,4572,1,1320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1354343.94,'SUELDOS 07-2022',NULL,1,'2023-07-26 17:26:48','2024-04-06 14:00:37','2024-04-06 14:00:37'),(1321,3666,40849,4573,1,1321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1155419.92,'SUELDOS 08-2022',NULL,1,'2023-07-26 17:29:17','2024-04-06 14:00:37','2024-04-06 14:00:37'),(1322,3666,40849,4574,1,1322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',556650.13,'SUELDOS 09-2022',NULL,1,'2023-07-26 17:32:14','2024-04-06 14:00:53','2024-04-06 14:00:53'),(1323,3666,40849,4575,1,1323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',153000.00,'SUELDOS 10-2022',NULL,1,'2023-07-26 17:34:14','2024-04-06 14:00:53','2024-04-06 14:00:53'),(1324,3666,40849,4576,1,1324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',168300.00,'SUELDOS 11-2022',NULL,1,'2023-07-26 17:35:33','2024-04-06 14:00:53','2024-04-06 14:00:53'),(1325,3666,40849,4577,1,1325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',532256.40,'SUELDOS 12-2022',NULL,1,'2023-07-26 17:37:42','2024-04-06 14:00:53','2024-04-06 14:00:53'),(1326,3666,40849,4575,19,1326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',220366.00,'PERC A DEPOSITAR IIBB MISIONES 10-2022',NULL,1,'2023-07-26 18:00:38','2024-04-06 14:00:53','2024-04-06 14:00:53'),(1327,3666,40849,4577,19,1327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',176293.00,'PERC A DEPOSITAR IIBB MISIONES 12-2022',NULL,1,'2023-07-26 18:01:37','2024-04-06 14:00:53','2024-04-06 14:00:53'),(1328,3666,40849,4566,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',1320.60,NULL,NULL,1,'2023-08-05 19:02:00','2023-08-05 19:34:00','2023-08-05 19:34:00'),(1329,3666,40849,4566,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',19000.00,NULL,NULL,1,'2023-08-05 19:02:00','2023-08-05 19:33:54','2023-08-05 19:33:54'),(1330,3666,40849,4566,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',7004.81,NULL,NULL,1,'2023-08-05 19:02:00','2023-08-05 19:33:50','2023-08-05 19:33:50'),(1331,3666,40849,4566,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',885.36,NULL,NULL,1,'2023-08-05 19:02:00','2023-08-05 19:33:47','2023-08-05 19:33:47'),(1332,3666,40849,4566,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',101562.23,NULL,NULL,1,'2023-08-05 19:02:01','2023-08-05 19:29:22','2023-08-05 19:29:22'),(1333,3666,40849,4566,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',63000.01,NULL,NULL,1,'2023-08-05 19:02:01','2023-08-05 19:33:39','2023-08-05 19:33:39'),(1334,3666,40849,4566,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',50000.00,NULL,NULL,1,'2023-08-05 19:02:01','2023-08-05 19:29:59','2023-08-05 19:29:59');
INSERT INTO `balance_libro` VALUES (1335,3666,40849,4566,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',3149.62,NULL,NULL,1,'2023-08-05 19:02:01','2023-08-05 19:33:28','2023-08-05 19:33:28'),(1336,3666,40849,4566,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7962.03,NULL,NULL,1,'2023-08-05 19:02:01','2023-08-05 19:30:21','2023-08-05 19:30:21'),(1337,3666,40849,4566,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',104266.53,NULL,NULL,1,'2023-08-05 19:29:22','2023-08-05 19:33:43','2023-08-05 19:33:43'),(1338,3666,40849,4566,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',51331.36,NULL,NULL,1,'2023-08-05 19:29:59','2023-08-05 19:33:32','2023-08-05 19:33:32'),(1339,3666,40849,4566,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',8174.03,NULL,NULL,1,'2023-08-05 19:30:21','2023-08-05 19:33:21','2023-08-05 19:33:21'),(1340,3666,40849,4566,20,852,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,852,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',4991250.00,NULL,NULL,1,'2023-08-06 19:35:16','2024-04-06 12:22:48','2024-04-06 12:22:48'),(1341,3666,40849,4566,22,1341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2569863.01,'ACREDITACION PLAZO FIJO',NULL,1,'2023-08-06 19:49:19','2024-04-06 13:09:10','2024-04-06 13:09:10'),(1342,3666,40849,4577,23,1342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',35092222.42,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-08-07 18:29:04','2023-08-07 18:31:12','2023-08-07 18:31:12'),(1343,3666,40849,4577,23,1343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',15759513.32,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-08-07 18:32:29','2023-08-07 19:27:07','2023-08-07 19:27:07'),(1344,3666,40849,4577,23,1344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',15747380.02,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-08-07 19:29:06','2023-08-07 21:46:26','2023-08-07 21:46:26'),(1345,3666,40849,4566,12,1345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35257859.08,'ASIENTO DE REAPERTURA CTAS PATRIMONIALES',NULL,1,'2023-08-07 21:46:18','2024-04-06 12:34:05','2024-04-06 12:34:05'),(1346,3666,40849,4577,23,1346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',15752631.54,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-08-07 21:47:47','2024-04-06 13:09:10','2024-04-06 13:09:10'),(1347,3666,40751,3076,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',6000.00,NULL,NULL,1,'2023-08-24 21:11:22','2023-08-24 21:11:22',NULL),(1348,3666,40751,3076,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',18200.00,NULL,NULL,1,'2023-08-24 21:12:30','2023-08-24 21:12:30',NULL),(1349,3666,40751,3076,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',8000.00,NULL,NULL,1,'2023-08-24 21:12:58','2023-08-24 21:12:58',NULL),(1350,3666,40751,3076,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',6000.00,NULL,NULL,1,'2023-08-24 21:13:21','2023-08-24 21:13:21',NULL),(1351,3666,40751,3076,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',10000.00,NULL,NULL,1,'2023-08-24 21:13:43','2023-08-24 21:13:43',NULL),(1352,3666,40751,3076,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',9000.00,NULL,NULL,1,'2023-08-24 21:14:22','2023-08-24 21:14:22',NULL);
INSERT INTO `balance_libro` VALUES (1353,3666,40751,3076,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',14999.99,NULL,NULL,1,'2023-08-24 21:27:59','2023-08-24 21:27:59',NULL),(1354,3666,40751,3076,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',14999.99,NULL,NULL,1,'2023-08-24 21:28:14','2023-08-24 21:28:14',NULL),(1355,3666,40751,3076,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',2000.00,NULL,NULL,1,'2023-08-24 21:28:55','2023-08-24 21:28:55',NULL),(1356,3666,40751,3076,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',10000.00,NULL,NULL,1,'2023-08-24 21:29:22','2023-08-24 21:29:22',NULL),(1357,3666,40751,3076,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',6000.00,NULL,NULL,1,'2023-08-24 21:29:42','2023-08-24 21:29:42',NULL),(1358,3666,40751,3076,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',12000.01,NULL,NULL,1,'2023-08-24 21:30:13','2023-08-24 21:30:13',NULL),(1359,3666,40751,3076,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',4000.01,NULL,NULL,1,'2023-08-24 21:34:24','2023-08-24 21:34:24',NULL),(1360,3666,40751,3076,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',6500.00,NULL,NULL,1,'2023-08-24 21:34:39','2023-08-24 21:34:39',NULL),(1361,3666,40751,3076,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',3500.00,NULL,NULL,1,'2023-08-24 21:35:13','2023-08-24 21:35:13',NULL),(1362,3666,40751,3076,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',19000.00,NULL,NULL,1,'2023-08-24 21:35:27','2023-08-24 21:35:27',NULL),(1363,3666,40751,3076,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',3000.00,NULL,NULL,1,'2023-08-24 21:43:32','2023-08-24 21:43:32',NULL),(1364,3666,40751,3076,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',30000.00,NULL,NULL,1,'2023-08-24 21:43:47','2023-08-24 21:43:47',NULL),(1365,3666,40751,3076,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',2500.01,NULL,NULL,1,'2023-08-24 21:44:05','2023-08-24 21:44:05',NULL),(1366,3666,40751,3076,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',7000.00,NULL,NULL,1,'2023-08-24 21:45:32','2023-08-24 21:45:32',NULL),(1367,3666,40751,3076,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',4000.01,NULL,NULL,1,'2023-08-24 21:45:56','2023-08-24 21:45:56',NULL),(1368,3666,40751,3076,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',12000.01,NULL,NULL,1,'2023-08-24 21:46:12','2023-08-24 21:46:12',NULL),(1369,3666,40751,3076,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',4000.01,NULL,NULL,1,'2023-08-24 21:49:15','2023-08-24 21:49:15',NULL),(1370,3666,40751,3076,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',2500.01,NULL,NULL,1,'2023-08-24 21:49:32','2023-08-24 21:49:32',NULL),(1371,3666,40751,3076,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',4000.01,NULL,NULL,1,'2023-08-24 21:49:48','2023-08-24 21:49:48',NULL),(1372,3666,40751,3076,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',4000.01,NULL,NULL,1,'2023-08-24 21:50:03','2023-08-24 21:50:03',NULL),(1373,3666,40751,3076,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',3000.00,NULL,NULL,1,'2023-08-24 21:50:24','2023-08-24 21:50:24',NULL);
INSERT INTO `balance_libro` VALUES (1374,3666,40751,3077,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',5000.00,NULL,NULL,1,'2023-09-27 17:51:12','2023-09-27 17:51:12',NULL),(1375,3666,40751,3077,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',50000.00,NULL,NULL,1,'2023-09-27 18:02:23','2023-09-27 18:02:23',NULL),(1376,3666,40751,3077,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',50000.00,NULL,NULL,1,'2023-09-27 18:02:39','2023-09-27 18:02:39',NULL),(1377,3666,40751,3077,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:03:26','2023-09-27 18:03:26',NULL),(1378,3666,40751,3077,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',6000.00,NULL,NULL,1,'2023-09-27 18:03:43','2023-09-27 18:03:43',NULL),(1379,3666,40751,3077,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',6000.00,NULL,NULL,1,'2023-09-27 18:08:54','2023-09-27 18:08:54',NULL),(1380,3666,40751,3077,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',5000.00,NULL,NULL,1,'2023-09-27 18:09:18','2023-09-27 18:09:18',NULL),(1381,3666,40751,3077,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:09:35','2023-09-27 18:09:35',NULL),(1382,3666,40751,3077,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10000.00,NULL,NULL,1,'2023-09-27 18:10:18','2023-09-27 18:10:18',NULL),(1383,3666,40751,3077,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',2000.00,NULL,NULL,1,'2023-09-27 18:18:28','2023-09-27 18:18:28',NULL),(1384,3666,40751,3077,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:19:07','2023-09-27 18:19:07',NULL),(1385,3666,40751,3077,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:19:21','2023-09-27 18:19:21',NULL),(1386,3666,40751,3077,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',4000.01,NULL,NULL,1,'2023-09-27 18:20:25','2023-09-27 18:20:25',NULL),(1387,3666,40751,3077,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',2000.00,NULL,NULL,1,'2023-09-27 18:20:57','2023-09-27 18:20:57',NULL),(1388,3666,40751,3077,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:22:38','2023-09-27 18:22:38',NULL),(1389,3666,40751,3077,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',7000.00,NULL,NULL,1,'2023-09-27 18:23:05','2023-09-27 18:23:05',NULL),(1390,3666,40751,3077,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',5000.00,NULL,NULL,1,'2023-09-27 18:23:20','2023-09-27 18:23:20',NULL),(1391,3666,40751,3077,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',4000.01,NULL,NULL,1,'2023-09-27 18:27:12','2023-09-27 18:27:12',NULL),(1392,3666,40751,3077,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',5090.00,NULL,NULL,1,'2023-09-27 18:27:38','2023-09-27 18:27:38',NULL),(1393,3666,40751,3077,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',11000.00,NULL,NULL,1,'2023-09-27 18:28:05','2023-09-27 18:28:05',NULL),(1394,3666,40751,3077,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:28:21','2023-09-27 18:28:21',NULL);
INSERT INTO `balance_libro` VALUES (1395,3666,40751,3077,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',6000.00,NULL,NULL,1,'2023-09-27 18:28:43','2023-09-27 18:28:43',NULL),(1396,3666,40751,3077,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10000.00,NULL,NULL,1,'2023-09-27 18:29:19','2023-09-27 18:29:19',NULL),(1397,3666,40751,3077,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',5000.00,NULL,NULL,1,'2023-09-27 18:30:04','2023-09-27 18:30:04',NULL),(1398,3666,40751,3077,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:30:18','2023-09-27 18:30:18',NULL),(1399,3666,40751,3077,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:30:41','2023-09-27 18:30:41',NULL),(1400,3666,40751,3077,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3000.00,NULL,NULL,1,'2023-09-27 18:31:02','2023-09-27 18:31:02',NULL),(1401,3666,40751,3077,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10000.00,NULL,NULL,1,'2023-09-27 18:34:11','2023-09-27 18:34:11',NULL),(1402,3666,40751,3077,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10000.00,NULL,NULL,1,'2023-09-27 18:34:25','2023-09-27 18:34:25',NULL),(1403,3666,40751,3077,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',11000.00,NULL,NULL,1,'2023-09-27 18:34:38','2023-09-27 18:34:38',NULL),(1404,3666,40751,3077,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',4000.01,NULL,NULL,1,'2023-09-27 18:34:53','2023-09-27 18:34:53',NULL),(1405,3666,40849,4581,12,1405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',87414635.87,'ASIENTO DE REAPERTURA CTAS PATRIMONIALES',NULL,1,'2024-04-06 12:34:05','2024-04-13 13:14:50','2024-04-13 13:14:50'),(1406,3666,40849,4581,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2692.19,NULL,NULL,1,'2024-04-06 13:15:38','2024-04-06 13:15:38',NULL),(1407,3666,40849,4581,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',755.04,NULL,NULL,1,'2024-04-06 13:15:38','2024-04-06 13:15:38',NULL),(1408,3666,40849,4581,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1874.90,NULL,NULL,1,'2024-04-06 13:15:38','2024-04-06 13:15:38',NULL),(1409,3666,40849,4581,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',17978.72,NULL,NULL,1,'2024-04-06 13:15:38','2024-04-09 11:28:36','2024-04-09 11:28:36'),(1410,3666,40849,4581,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2800.00,NULL,NULL,1,'2024-04-06 13:15:38','2024-04-06 13:15:38',NULL),(1411,3666,40849,4581,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4900.00,NULL,NULL,1,'2024-04-06 13:15:38','2024-04-06 13:15:38',NULL),(1412,3666,40849,4581,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',50000.36,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-09 11:27:26','2024-04-09 11:27:26'),(1413,3666,40849,4581,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.01,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-06 13:15:39',NULL),(1414,3666,40849,4581,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4100.00,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-06 13:15:39',NULL);
INSERT INTO `balance_libro` VALUES (1415,3666,40849,4581,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2100.00,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-06 13:15:39',NULL),(1416,3666,40849,4581,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',29796.36,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-06 13:15:39',NULL),(1417,3666,40849,4581,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4500.00,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-06 13:15:39',NULL),(1418,3666,40849,4581,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1988.99,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-06 13:15:39',NULL),(1419,3666,40849,4581,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3380.00,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-09 09:32:23','2024-04-09 09:32:23'),(1420,3666,40849,4581,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',141735.23,NULL,NULL,1,'2024-04-06 13:15:39','2024-04-06 13:15:39',NULL),(1421,3666,40849,4581,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',37584.84,NULL,NULL,1,'2024-04-06 13:15:40','2024-04-06 13:15:40',NULL),(1422,3666,40849,4581,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',100017.97,NULL,NULL,1,'2024-04-06 13:15:40','2024-04-06 13:15:40',NULL),(1423,3666,40849,4582,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2990.00,NULL,NULL,1,'2024-04-06 14:02:22','2024-04-06 14:02:22',NULL),(1424,3666,40849,4582,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1414.30,NULL,NULL,1,'2024-04-06 14:02:22','2024-04-06 14:02:22',NULL),(1425,3666,40849,4582,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',80000.00,NULL,NULL,1,'2024-04-06 14:02:22','2024-04-06 14:02:22',NULL),(1426,3666,40849,4582,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5034.04,NULL,NULL,1,'2024-04-06 14:02:22','2024-04-09 11:38:26','2024-04-09 11:38:26'),(1427,3666,40849,4582,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',11032.67,NULL,NULL,1,'2024-04-06 14:02:22','2024-04-06 14:02:22',NULL),(1428,3666,40849,4582,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',26440.00,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL),(1429,3666,40849,4582,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',10834.14,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL),(1430,3666,40849,4582,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',778.27,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL),(1431,3666,40849,4582,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',377.51,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL),(1432,3666,40849,4582,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',10000.56,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL),(1433,3666,40849,4582,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',6001.26,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL),(1434,3666,40849,4582,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',4000.35,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL),(1435,3666,40849,4582,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',606653.35,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL);
INSERT INTO `balance_libro` VALUES (1436,3666,40849,4582,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10000.94,NULL,NULL,1,'2024-04-06 14:02:23','2024-04-06 14:02:23',NULL),(1437,3666,40849,4582,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10001.11,NULL,NULL,1,'2024-04-06 14:02:24','2024-04-06 14:02:24',NULL),(1438,3666,40849,4582,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2024-04-06 14:02:24','2024-04-06 14:02:24',NULL),(1439,3666,40849,4583,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4299.99,NULL,NULL,1,'2024-04-06 14:02:57','2024-04-06 14:02:57',NULL),(1440,3666,40849,4583,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',10001.01,NULL,NULL,1,'2024-04-06 14:02:57','2024-04-06 14:02:57',NULL),(1441,3666,40849,4583,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',6574.13,NULL,NULL,1,'2024-04-06 14:02:57','2024-04-06 14:02:57',NULL),(1442,3666,40849,4583,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9202.75,NULL,NULL,1,'2024-04-06 14:02:57','2024-04-06 14:02:57',NULL),(1443,3666,40849,4583,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',10002.66,NULL,NULL,1,'2024-04-06 14:02:57','2024-04-06 14:02:57',NULL),(1444,3666,40849,4583,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',7000.27,NULL,NULL,1,'2024-04-06 14:02:57','2024-04-06 14:02:57',NULL),(1445,3666,40849,4583,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',80000.00,NULL,NULL,1,'2024-04-06 14:02:57','2024-04-06 14:02:57',NULL),(1446,3666,40849,4583,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',9000.53,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1447,3666,40849,4583,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',15410.33,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1448,3666,40849,4583,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10002.69,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1449,3666,40849,4583,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10001.36,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1450,3666,40849,4583,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',14182.38,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1451,3666,40849,4583,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',948.33,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1452,3666,40849,4583,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',11961.91,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1453,3666,40849,4583,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',7250.80,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1454,3666,40849,4583,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',10002.03,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1455,3666,40849,4583,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',9000.53,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1456,3666,40849,4583,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',8101.07,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL);
INSERT INTO `balance_libro` VALUES (1457,3666,40849,4583,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',10001.11,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1458,3666,40849,4583,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',7000.67,NULL,NULL,1,'2024-04-06 14:02:58','2024-04-06 14:02:58',NULL),(1459,3666,40849,4583,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9000.53,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1460,3666,40849,4583,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9000.53,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1461,3666,40849,4583,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',93702.36,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1462,3666,40849,4583,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',9001.15,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1463,3666,40849,4583,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8404.02,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1464,3666,40849,4583,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10602.06,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1465,3666,40849,4583,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10000.29,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1466,3666,40849,4583,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10001.11,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1467,3666,40849,4583,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8004.64,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1468,3666,40849,4583,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',10000.40,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1469,3666,40849,4583,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',7000.54,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1470,3666,40849,4583,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',8000.97,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1471,3666,40849,4583,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',10502.39,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1472,3666,40849,4583,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',7601.51,NULL,NULL,1,'2024-04-06 14:02:59','2024-04-06 14:02:59',NULL),(1473,3666,40849,4583,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8858.50,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1474,3666,40849,4583,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',10500.78,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1475,3666,40849,4583,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',10501.23,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1476,3666,40849,4583,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10401.69,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1477,3666,40849,4583,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10001.27,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL);
INSERT INTO `balance_libro` VALUES (1478,3666,40849,4583,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10402.09,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1479,3666,40849,4583,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10302.15,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1480,3666,40849,4583,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10001.08,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1481,3666,40849,4583,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',8301.25,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1482,3666,40849,4583,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',9301.09,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1483,3666,40849,4583,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',8000.47,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1484,3666,40849,4583,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',10001.08,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1485,3666,40849,4583,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',10801.81,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1486,3666,40849,4583,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',9500.33,NULL,NULL,1,'2024-04-06 14:03:00','2024-04-06 14:03:00',NULL),(1487,3666,40849,4583,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',10601.94,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1488,3666,40849,4583,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',7001.60,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1489,3666,40849,4583,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',9801.07,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1490,3666,40849,4583,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',10000.73,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1491,3666,40849,4583,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',10000.46,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1492,3666,40849,4583,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',7000.76,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1493,3666,40849,4583,3,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',8000.92,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1494,3666,40849,4583,3,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',10001.14,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1495,3666,40849,4583,3,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',10502.66,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1496,3666,40849,4583,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',10103.25,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1497,3666,40849,4583,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',10000.82,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1498,3666,40849,4583,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',5700.37,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL);
INSERT INTO `balance_libro` VALUES (1499,3666,40849,4583,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',5500.00,NULL,NULL,1,'2024-04-06 14:03:01','2024-04-06 14:03:01',NULL),(1500,3666,40849,4583,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',200153.24,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1501,3666,40849,4583,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',23543.96,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1502,3666,40849,4583,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',9602.71,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1503,3666,40849,4583,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',10000.46,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1504,3666,40849,4583,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',7900.73,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1505,3666,40849,4583,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',10700.31,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1506,3666,40849,4583,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',10001.27,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1507,3666,40849,4583,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',10501.94,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1508,3666,40849,4583,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',10000.73,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1509,3666,40849,4583,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',10000.13,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1510,3666,40849,4583,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',10203.50,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1511,3666,40849,4583,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',6002.03,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1512,3666,40849,4583,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',10003.65,NULL,NULL,1,'2024-04-06 14:03:02','2024-04-06 14:03:02',NULL),(1513,3666,40849,4583,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',10001.67,NULL,NULL,1,'2024-04-06 14:03:03','2024-04-06 14:03:03',NULL),(1514,3666,40849,4583,3,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',10301.66,NULL,NULL,1,'2024-04-06 14:03:03','2024-04-06 14:03:03',NULL),(1515,3666,40849,4583,3,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',10002.09,NULL,NULL,1,'2024-04-06 14:03:03','2024-04-06 14:03:03',NULL),(1516,3666,40849,4583,3,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',8002.74,NULL,NULL,1,'2024-04-06 14:03:03','2024-04-06 14:03:03',NULL),(1517,3666,40849,4583,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',16129.48,NULL,NULL,1,'2024-04-06 14:03:03','2024-04-06 14:03:03',NULL),(1518,3666,40849,4583,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',10000.19,NULL,NULL,1,'2024-04-06 14:03:03','2024-04-06 14:03:03',NULL),(1519,3666,40849,4583,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',7300.46,NULL,NULL,1,'2024-04-06 14:03:03','2024-04-06 14:03:03',NULL);
INSERT INTO `balance_libro` VALUES (1520,3666,40849,4583,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10000.81,NULL,NULL,1,'2024-04-06 14:03:03','2024-04-06 14:03:03',NULL),(1521,3666,40849,4584,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',10200.50,NULL,NULL,1,'2024-04-06 14:03:32','2024-04-06 14:03:32',NULL),(1522,3666,40849,4584,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',7401.62,NULL,NULL,1,'2024-04-06 14:03:32','2024-04-06 14:03:32',NULL),(1523,3666,40849,4584,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',10599.66,NULL,NULL,1,'2024-04-06 14:03:32','2024-04-06 14:03:32',NULL),(1524,3666,40849,4584,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10000.33,NULL,NULL,1,'2024-04-06 14:03:32','2024-04-06 14:03:32',NULL),(1525,3666,40849,4584,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',9000.88,NULL,NULL,1,'2024-04-06 14:03:32','2024-04-06 14:03:32',NULL),(1526,3666,40849,4584,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',9800.32,NULL,NULL,1,'2024-04-06 14:03:32','2024-04-06 14:03:32',NULL),(1527,3666,40849,4584,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3000.63,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1528,3666,40849,4584,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',10000.19,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1529,3666,40849,4584,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',10399.74,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1530,3666,40849,4584,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',6001.72,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1531,3666,40849,4584,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',6000.75,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1532,3666,40849,4584,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',9701.86,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1533,3666,40849,4584,3,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',10501.43,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1534,3666,40849,4584,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',10400.95,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1535,3666,40849,4584,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',80000.00,NULL,NULL,1,'2024-04-06 14:03:33','2024-04-06 14:03:33',NULL),(1536,3666,40849,4584,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',8302.17,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1537,3666,40849,4584,3,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',16477.54,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1538,3666,40849,4584,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',100279.94,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1539,3666,40849,4584,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2500.00,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1540,3666,40849,4584,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',9700.70,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL);
INSERT INTO `balance_libro` VALUES (1541,3666,40849,4584,3,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',10303.25,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1542,3666,40849,4584,3,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',10000.46,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1543,3666,40849,4584,3,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',10601.89,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1544,3666,40849,4584,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',10000.46,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1545,3666,40849,4584,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',476.91,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1546,3666,40849,4584,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',7100.00,NULL,NULL,1,'2024-04-06 14:03:34','2024-04-06 14:03:34',NULL),(1547,3666,40849,4584,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',10000.81,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1548,3666,40849,4584,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',10000.13,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1549,3666,40849,4584,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',7600.85,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1550,3666,40849,4584,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',9000.45,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1551,3666,40849,4584,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',6000.75,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1552,3666,40849,4584,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',15414.24,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1553,3666,40849,4584,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',10502.02,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1554,3666,40849,4584,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',10001.10,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1555,3666,40849,4584,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',7001.54,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1556,3666,40849,4584,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',10702.69,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1557,3666,40849,4584,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',34900.00,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1558,3666,40849,4584,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',4692.70,NULL,NULL,1,'2024-04-06 14:03:35','2024-04-06 14:03:35',NULL),(1559,3666,40849,4584,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',10000.06,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1560,3666,40849,4584,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',9801.66,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1561,3666,40849,4584,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',10701.51,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL);
INSERT INTO `balance_libro` VALUES (1562,3666,40849,4584,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',10502.86,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1563,3666,40849,4584,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',10001.12,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1564,3666,40849,4584,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',10502.78,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1565,3666,40849,4584,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9504.37,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1566,3666,40849,4584,3,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',10303.56,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1567,3666,40849,4584,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',9005.26,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1568,3666,40849,4584,3,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',7000.04,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1569,3666,40849,4584,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3670.00,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1570,3666,40849,4584,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',9999.94,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1571,3666,40849,4584,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',8001.72,NULL,NULL,1,'2024-04-06 14:03:36','2024-04-06 14:03:36',NULL),(1572,3666,40849,4584,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',15004.00,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1573,3666,40849,4584,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',8300.40,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1574,3666,40849,4584,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',10401.27,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1575,3666,40849,4584,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',8100.23,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1576,3666,40849,4584,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7000.04,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1577,3666,40849,4584,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9000.42,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1578,3666,40849,4584,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',9302.66,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1579,3666,40849,4584,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',7001.25,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1580,3666,40849,4584,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',10000.48,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1581,3666,40849,4584,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',9001.15,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1582,3666,40849,4584,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',10000.48,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL);
INSERT INTO `balance_libro` VALUES (1583,3666,40849,4584,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',10110.67,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1584,3666,40849,4584,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',16680.37,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1585,3666,40849,4584,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',9200.55,NULL,NULL,1,'2024-04-06 14:03:37','2024-04-06 14:03:37',NULL),(1586,3666,40849,4584,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',10102.94,NULL,NULL,1,'2024-04-06 14:03:38','2024-04-06 14:03:38',NULL),(1587,3666,40849,4584,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',9908.05,NULL,NULL,1,'2024-04-06 14:03:38','2024-04-06 14:03:38',NULL),(1588,3666,40849,4584,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',10806.04,NULL,NULL,1,'2024-04-06 14:03:38','2024-04-06 14:03:38',NULL),(1589,3666,40849,4585,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',5980.72,NULL,NULL,1,'2024-04-06 14:04:34','2024-04-06 14:04:34',NULL),(1590,3666,40849,4585,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',80000.00,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1591,3666,40849,4585,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',94799.99,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1592,3666,40849,4585,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',142122.96,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1593,3666,40849,4585,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',18078.97,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1594,3666,40849,4585,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',9302.55,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1595,3666,40849,4585,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',22400.00,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1596,3666,40849,4585,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',33965.01,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1597,3666,40849,4585,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',40451.78,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1598,3666,40849,4585,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',16352.17,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1599,3666,40849,4585,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',9000.20,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1600,3666,40849,4585,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',10000.58,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1601,3666,40849,4585,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',9297.57,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1602,3666,40849,4585,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10602.22,NULL,NULL,1,'2024-04-06 14:04:35','2024-04-06 14:04:35',NULL),(1603,3666,40849,4585,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10502.11,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL);
INSERT INTO `balance_libro` VALUES (1604,3666,40849,4585,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',11320.02,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1605,3666,40849,4585,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',8000.98,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1606,3666,40849,4585,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',10002.46,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1607,3666,40849,4585,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',10700.97,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1608,3666,40849,4585,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',10001.19,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1609,3666,40849,4585,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',10000.11,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1610,3666,40849,4585,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',9000.96,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1611,3666,40849,4585,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',8550.61,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1612,3666,40849,4585,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',7000.36,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1613,3666,40849,4585,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',8300.70,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1614,3666,40849,4585,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',250000.06,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1615,3666,40849,4585,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',10001.15,NULL,NULL,1,'2024-04-06 14:04:36','2024-04-06 14:04:36',NULL),(1616,3666,40849,4585,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',2500.00,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1617,3666,40849,4585,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',6301.68,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1618,3666,40849,4585,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',5000.48,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1619,3666,40849,4585,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',1200.00,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1620,3666,40849,4585,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',15417.34,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1621,3666,40849,4585,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',4001.01,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1622,3666,40849,4585,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',6001.09,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1623,3666,40849,4585,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',6001.27,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1624,3666,40849,4585,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',8001.21,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL);
INSERT INTO `balance_libro` VALUES (1625,3666,40849,4585,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',5001.19,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1626,3666,40849,4585,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',7502.78,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1627,3666,40849,4585,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',6000.05,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1628,3666,40849,4585,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',5000.82,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1629,3666,40849,4585,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',5239.69,NULL,NULL,1,'2024-04-06 14:04:37','2024-04-06 14:04:37',NULL),(1630,3666,40849,4585,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',10001.63,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1631,3666,40849,4585,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',14648.87,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1632,3666,40849,4585,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',10001.64,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1633,3666,40849,4585,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',10501.77,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1634,3666,40849,4585,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',10302.93,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1635,3666,40849,4585,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',10500.48,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1636,3666,40849,4585,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',8200.69,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1637,3666,40849,4585,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',8000.59,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1638,3666,40849,4585,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',9800.24,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1639,3666,40849,4585,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10700.58,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1640,3666,40849,4585,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',6000.81,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1641,3666,40849,4585,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',11588.37,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1642,3666,40849,4585,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',10002.15,NULL,NULL,1,'2024-04-06 14:04:38','2024-04-06 14:04:38',NULL),(1643,3666,40849,4585,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',10001.64,NULL,NULL,1,'2024-04-06 14:04:39','2024-04-06 14:04:39',NULL),(1644,3666,40849,4585,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5000.82,NULL,NULL,1,'2024-04-06 14:04:39','2024-04-06 14:04:39',NULL),(1645,3666,40849,4585,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',10000.73,NULL,NULL,1,'2024-04-06 14:04:39','2024-04-06 14:04:39',NULL);
INSERT INTO `balance_libro` VALUES (1646,3666,40849,4586,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',10000.68,NULL,NULL,1,'2024-04-06 14:05:28','2024-04-06 14:05:28',NULL),(1647,3666,40849,4586,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',10501.96,NULL,NULL,1,'2024-04-06 14:05:28','2024-04-06 14:05:28',NULL),(1648,3666,40849,4586,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',11612.99,NULL,NULL,1,'2024-04-06 14:05:28','2024-04-06 14:05:28',NULL),(1649,3666,40849,4586,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',69654.69,NULL,NULL,1,'2024-04-06 14:05:28','2024-04-06 14:05:28',NULL),(1650,3666,40849,4586,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',9202.51,NULL,NULL,1,'2024-04-06 14:05:28','2024-04-06 14:05:28',NULL),(1651,3666,40849,4586,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',15427.30,NULL,NULL,1,'2024-04-06 14:05:28','2024-04-06 14:05:28',NULL),(1652,3666,40849,4586,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',7800.00,NULL,NULL,1,'2024-04-06 14:05:28','2024-04-06 14:05:28',NULL),(1653,3666,40849,4586,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',10002.53,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1654,3666,40849,4586,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',10000.80,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1655,3666,40849,4586,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',5638.85,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1656,3666,40849,4586,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',10700.58,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1657,3666,40849,4586,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',9100.58,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1658,3666,40849,4586,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',9306.47,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1659,3666,40849,4586,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',9001.19,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1660,3666,40849,4586,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',80000.00,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1661,3666,40849,4586,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',10201.31,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1662,3666,40849,4586,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',10000.82,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1663,3666,40849,4586,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',10502.42,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1664,3666,40849,4586,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',561798.54,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1665,3666,40849,4586,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',229332.06,NULL,NULL,1,'2024-04-06 14:05:29','2024-04-06 14:05:29',NULL),(1666,3666,40849,4586,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',8105.67,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL);
INSERT INTO `balance_libro` VALUES (1667,3666,40849,4586,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',8000.59,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1668,3666,40849,4586,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',6002.50,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1669,3666,40849,4586,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',10000.86,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1670,3666,40849,4586,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',300000.80,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1671,3666,40849,4586,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',10002.53,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1672,3666,40849,4586,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',3998.42,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1673,3666,40849,4586,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',10701.36,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1674,3666,40849,4586,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',9502.02,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1675,3666,40849,4586,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',3450.07,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1676,3666,40849,4586,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',7000.58,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1677,3666,40849,4586,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',9000.34,NULL,NULL,1,'2024-04-06 14:05:30','2024-04-06 14:05:30',NULL),(1678,3666,40849,4586,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',10502.08,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1679,3666,40849,4586,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',10000.86,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1680,3666,40849,4586,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',10001.64,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1681,3666,40849,4586,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',9000.90,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1682,3666,40849,4586,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',17500.00,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1683,3666,40849,4586,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',7000.42,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1684,3666,40849,4586,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',11587.79,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1685,3666,40849,4586,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',10301.43,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1686,3666,40849,4586,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',10002.85,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1687,3666,40849,4586,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',10501.52,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL);
INSERT INTO `balance_libro` VALUES (1688,3666,40849,4586,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',8000.59,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1689,3666,40849,4586,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',10702.65,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1690,3666,40849,4586,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',9001.11,NULL,NULL,1,'2024-04-06 14:05:31','2024-04-06 14:05:31',NULL),(1691,3666,40849,4586,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',10002.23,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1692,3666,40849,4586,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',8001.36,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1693,3666,40849,4586,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',9002.92,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1694,3666,40849,4586,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',10602.14,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1695,3666,40849,4586,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',32000.02,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1696,3666,40849,4586,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',17472.88,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1697,3666,40849,4586,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',10000.97,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1698,3666,40849,4586,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',6300.00,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1699,3666,40849,4586,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',10000.68,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1700,3666,40849,4586,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',8001.06,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1701,3666,40849,4586,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',13565.64,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1702,3666,40849,4586,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',10000.54,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1703,3666,40849,4586,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',7300.88,NULL,NULL,1,'2024-04-06 14:05:32','2024-04-06 14:05:32',NULL),(1704,3666,40849,4586,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',8301.35,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1705,3666,40849,4586,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',7300.88,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1706,3666,40849,4586,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',9001.72,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1707,3666,40849,4586,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',10000.97,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1708,3666,40849,4586,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',7001.16,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL);
INSERT INTO `balance_libro` VALUES (1709,3666,40849,4586,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',10002.46,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1710,3666,40849,4586,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10000.97,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1711,3666,40849,4586,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10001.80,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1712,3666,40849,4586,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10000.44,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1713,3666,40849,4586,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10251.89,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1714,3666,40849,4586,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10001.90,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1715,3666,40849,4586,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10603.61,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1716,3666,40849,4586,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',7967.14,NULL,NULL,1,'2024-04-06 14:05:33','2024-04-06 14:05:33',NULL),(1717,3666,40849,4586,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',9802.59,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1718,3666,40849,4586,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',14200.00,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1719,3666,40849,4586,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',10001.26,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1720,3666,40849,4586,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',10001.14,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1721,3666,40849,4586,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',37946.81,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1722,3666,40849,4586,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',10001.23,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1723,3666,40849,4586,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',10002.46,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1724,3666,40849,4586,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',10303.62,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1725,3666,40849,4586,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',10002.46,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1726,3666,40849,4586,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',10102.13,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1727,3666,40849,4586,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',9002.08,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1728,3666,40849,4586,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',9001.04,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL),(1729,3666,40849,4586,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',10501.16,NULL,NULL,1,'2024-04-06 14:05:34','2024-04-06 14:05:34',NULL);
INSERT INTO `balance_libro` VALUES (1730,3666,40849,4586,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',15000.00,NULL,NULL,1,'2024-04-06 14:05:35','2024-04-06 14:05:35',NULL),(1731,3666,40849,4586,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',10001.35,NULL,NULL,1,'2024-04-06 14:05:35','2024-04-06 14:05:35',NULL),(1732,3666,40849,4586,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',9900.00,NULL,NULL,1,'2024-04-06 14:05:35','2024-04-06 14:05:35',NULL),(1733,3666,40849,4586,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',11070.00,NULL,NULL,1,'2024-04-06 14:05:35','2024-04-06 14:05:35',NULL),(1734,3666,40849,4586,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',12332.04,NULL,NULL,1,'2024-04-06 14:05:35','2024-04-06 14:05:35',NULL),(1735,3666,40849,4586,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10002.32,NULL,NULL,1,'2024-04-06 14:05:35','2024-04-06 14:05:35',NULL),(1736,3666,40849,4587,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',10002.01,NULL,NULL,1,'2024-04-06 14:06:03','2024-04-06 14:06:03',NULL),(1737,3666,40849,4587,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-02','2023-07-02',14395.12,NULL,NULL,1,'2024-04-06 14:06:03','2024-04-06 14:06:03',NULL),(1738,3666,40849,4587,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',51400.00,NULL,NULL,1,'2024-04-06 14:06:03','2024-04-06 14:06:03',NULL),(1739,3666,40849,4587,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',12332.50,NULL,NULL,1,'2024-04-06 14:06:03','2024-04-06 14:06:03',NULL),(1740,3666,40849,4587,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',12332.04,NULL,NULL,1,'2024-04-06 14:06:03','2024-04-06 14:06:03',NULL),(1741,3666,40849,4587,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',1500.00,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1742,3666,40849,4587,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',10002.63,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1743,3666,40849,4587,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',10301.88,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1744,3666,40849,4587,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',23218.23,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1745,3666,40849,4587,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',100000.00,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1746,3666,40849,4587,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',9103.11,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1747,3666,40849,4587,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',3500.00,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1748,3666,40849,4587,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-09','2023-07-09',5000.82,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1749,3666,40849,4587,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-09','2023-07-09',10300.92,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL),(1750,3666,40849,4587,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',7319999.99,NULL,NULL,1,'2024-04-06 14:06:04','2024-04-06 14:06:04',NULL);
INSERT INTO `balance_libro` VALUES (1751,3666,40849,4587,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',9001.98,NULL,NULL,1,'2024-04-06 14:06:05','2024-04-06 14:06:05',NULL),(1752,3666,40849,4587,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',9002.50,NULL,NULL,1,'2024-04-06 14:06:05','2024-04-06 14:06:05',NULL),(1753,3666,40849,4587,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',10002.10,NULL,NULL,1,'2024-04-06 14:06:05','2024-04-06 14:06:05',NULL),(1754,3666,40849,4587,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',10489.15,NULL,NULL,1,'2024-04-06 14:06:05','2024-04-06 14:06:05',NULL),(1755,3666,40849,4587,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',3060000.00,NULL,NULL,1,'2024-04-06 14:06:05','2024-04-06 14:06:05',NULL),(1756,3666,40849,4587,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',10702.33,NULL,NULL,1,'2024-04-06 14:06:05','2024-04-06 14:06:05',NULL),(1757,3666,40849,4587,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',10001.73,NULL,NULL,1,'2024-04-06 14:06:06','2024-04-06 14:06:06',NULL),(1758,3666,40849,4587,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',10001.68,NULL,NULL,1,'2024-04-06 14:06:06','2024-04-06 14:06:06',NULL),(1759,3666,40849,4587,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',12332.50,NULL,NULL,1,'2024-04-06 14:06:06','2024-04-06 14:06:06',NULL),(1760,3666,40849,4587,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',2646000.00,NULL,NULL,1,'2024-04-06 14:06:06','2024-04-06 14:06:06',NULL),(1761,3666,40849,4587,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',10070.26,NULL,NULL,1,'2024-04-06 14:06:07','2024-04-06 14:06:07',NULL),(1762,3666,40849,4587,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',3000.00,NULL,NULL,1,'2024-04-06 14:06:07','2024-04-06 14:06:07',NULL),(1763,3666,40849,4587,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',10000.04,NULL,NULL,1,'2024-04-06 14:06:07','2024-04-06 14:06:07',NULL),(1764,3666,40849,4587,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',21700.08,NULL,NULL,1,'2024-04-06 14:06:07','2024-04-06 14:06:07',NULL),(1765,3666,40849,4587,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',21700.08,NULL,NULL,1,'2024-04-06 14:06:07','2024-04-06 14:06:07',NULL),(1766,3666,40849,4587,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',15413.76,NULL,NULL,1,'2024-04-06 14:06:07','2024-04-06 14:06:07',NULL),(1767,3666,40849,4587,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',888403.35,NULL,NULL,1,'2024-04-06 14:06:07','2024-04-06 14:06:07',NULL),(1768,3666,40849,4587,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',9900.80,NULL,NULL,1,'2024-04-06 14:06:07','2024-04-06 14:06:07',NULL),(1769,3666,40849,4587,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',10000.89,NULL,NULL,1,'2024-04-06 14:06:08','2024-04-06 14:06:08',NULL),(1770,3666,40849,4587,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',10000.49,NULL,NULL,1,'2024-04-06 14:06:08','2024-04-06 14:06:08',NULL),(1771,3666,40849,4587,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',208000.00,NULL,NULL,1,'2024-04-06 14:06:08','2024-04-06 14:06:08',NULL);
INSERT INTO `balance_libro` VALUES (1772,3666,40849,4587,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',10000.08,NULL,NULL,1,'2024-04-06 14:06:08','2024-04-06 14:06:08',NULL),(1773,3666,40849,4587,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',9500.48,NULL,NULL,1,'2024-04-06 14:06:08','2024-04-06 14:06:08',NULL),(1774,3666,40849,4587,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',2505.00,NULL,NULL,1,'2024-04-06 14:06:09','2024-04-06 14:06:09',NULL),(1775,3666,40849,4587,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',15630.00,NULL,NULL,1,'2024-04-06 14:06:09','2024-04-06 14:06:09',NULL),(1776,3666,40849,4587,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',18608.43,NULL,NULL,1,'2024-04-06 14:06:09','2024-04-06 14:06:09',NULL),(1777,3666,40849,4587,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',12332.50,NULL,NULL,1,'2024-04-06 14:06:09','2024-04-06 14:06:09',NULL),(1778,3666,40849,4587,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',10001.12,NULL,NULL,1,'2024-04-06 14:06:09','2024-04-06 14:06:09',NULL),(1779,3666,40849,4587,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',10001.92,NULL,NULL,1,'2024-04-06 14:06:09','2024-04-06 14:06:09',NULL),(1780,3666,40849,4587,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',10501.28,NULL,NULL,1,'2024-04-06 14:06:09','2024-04-06 14:06:09',NULL),(1781,3666,40849,4587,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',10000.95,NULL,NULL,1,'2024-04-06 14:06:09','2024-04-06 14:06:09',NULL),(1782,3666,40849,4587,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',10000.95,NULL,NULL,1,'2024-04-06 14:06:10','2024-04-06 14:06:10',NULL),(1783,3666,40849,4587,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',10001.16,NULL,NULL,1,'2024-04-06 14:06:10','2024-04-06 14:06:10',NULL),(1784,3666,40849,4587,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',23258.22,NULL,NULL,1,'2024-04-06 14:06:10','2024-04-06 14:06:10',NULL),(1785,3666,40849,4587,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10400.60,NULL,NULL,1,'2024-04-06 14:06:10','2024-04-06 14:06:10',NULL),(1786,3666,40849,4588,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',100000.00,NULL,NULL,1,'2024-04-06 14:07:49','2024-04-06 14:07:49',NULL),(1787,3666,40849,4588,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',20000.00,NULL,NULL,1,'2024-04-06 14:07:49','2024-04-06 14:07:49',NULL),(1788,3666,40849,4588,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',9000.00,NULL,NULL,1,'2024-04-06 14:07:49','2024-04-06 14:07:49',NULL),(1789,3666,40849,4588,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',18590.00,NULL,NULL,1,'2024-04-06 14:07:49','2024-04-06 14:07:49',NULL),(1790,3666,40849,4588,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',10001.13,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1791,3666,40849,4588,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',3451.91,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1792,3666,40849,4588,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',250014.12,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL);
INSERT INTO `balance_libro` VALUES (1793,3666,40849,4588,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',24802.97,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1794,3666,40849,4588,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',5480.09,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1795,3666,40849,4588,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',10804.62,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1796,3666,40849,4588,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',10302.14,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1797,3666,40849,4588,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',180000.52,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1798,3666,40849,4588,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',10064.04,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1799,3666,40849,4588,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',10704.75,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1800,3666,40849,4588,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',10000.08,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1801,3666,40849,4588,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',10000.08,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1802,3666,40849,4588,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',10800.42,NULL,NULL,1,'2024-04-06 14:07:50','2024-04-06 14:07:50',NULL),(1803,3666,40849,4588,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-13','2023-08-13',10000.86,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1804,3666,40849,4588,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',10003.00,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1805,3666,40849,4588,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',10001.40,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1806,3666,40849,4588,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10000.46,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1807,3666,40849,4588,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10001.40,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1808,3666,40849,4588,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10000.26,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1809,3666,40849,4588,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',9000.00,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1810,3666,40849,4588,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',10102.19,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1811,3666,40849,4588,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',10000.78,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1812,3666,40849,4588,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',10501.65,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1813,3666,40849,4588,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',9904.90,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL);
INSERT INTO `balance_libro` VALUES (1814,3666,40849,4588,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',9999.75,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1815,3666,40849,4588,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',10600.99,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1816,3666,40849,4588,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',10000.93,NULL,NULL,1,'2024-04-06 14:07:51','2024-04-06 14:07:51',NULL),(1817,3666,40849,4588,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',17400.01,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1818,3666,40849,4588,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',25275.07,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1819,3666,40849,4588,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',2500.00,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1820,3666,40849,4588,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',2035.19,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1821,3666,40849,4588,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-20','2023-08-20',9999.87,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1822,3666,40849,4588,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',8203.56,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1823,3666,40849,4588,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',10000.78,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1824,3666,40849,4588,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',28230.00,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1825,3666,40849,4588,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',7000.97,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1826,3666,40849,4588,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',30071.41,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1827,3666,40849,4588,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',1300.00,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1828,3666,40849,4588,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',1435500.00,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1829,3666,40849,4588,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',8800.00,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1830,3666,40849,4588,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',10003.48,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1831,3666,40849,4588,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',8001.12,NULL,NULL,1,'2024-04-06 14:07:52','2024-04-06 14:07:52',NULL),(1832,3666,40849,4589,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',9002.20,NULL,NULL,1,'2024-04-06 14:08:40','2024-04-06 14:08:40',NULL),(1833,3666,40849,4589,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',9999.97,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1834,3666,40849,4589,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',13359.06,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL);
INSERT INTO `balance_libro` VALUES (1835,3666,40849,4589,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',350389.28,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1836,3666,40849,4589,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',120000.00,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1837,3666,40849,4589,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',10000.78,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1838,3666,40849,4589,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',8001.05,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1839,3666,40849,4589,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',10001.21,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1840,3666,40849,4589,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',9902.09,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1841,3666,40849,4589,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',25691.09,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1842,3666,40849,4589,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',30900.00,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1843,3666,40849,4589,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',10005.17,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1844,3666,40849,4589,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',8300.61,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1845,3666,40849,4589,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',7100.00,NULL,NULL,1,'2024-04-06 14:08:41','2024-04-06 14:08:41',NULL),(1846,3666,40849,4589,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',698050.18,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1847,3666,40849,4589,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',10000.99,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1848,3666,40849,4589,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',2094965.59,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1849,3666,40849,4589,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',698050.18,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1850,3666,40849,4589,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',9504.37,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1851,3666,40849,4589,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',4500.00,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1852,3666,40849,4589,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',9999.97,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1853,3666,40849,4589,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',10000.78,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1854,3666,40849,4589,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',9225.00,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1855,3666,40849,4589,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',15412.98,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL);
INSERT INTO `balance_libro` VALUES (1856,3666,40849,4589,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',9999.87,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1857,3666,40849,4589,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',10000.78,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1858,3666,40849,4589,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',10002.03,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1859,3666,40849,4589,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',10001.21,NULL,NULL,1,'2024-04-06 14:08:42','2024-04-06 14:08:42',NULL),(1860,3666,40849,4589,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',20000.75,NULL,NULL,1,'2024-04-06 14:08:43','2024-04-06 14:08:43',NULL),(1861,3666,40849,4589,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',1700.00,NULL,NULL,1,'2024-04-06 14:08:43','2024-04-06 14:08:43',NULL),(1862,3666,40849,4589,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',39501.18,NULL,NULL,1,'2024-04-06 14:08:43','2024-04-06 14:08:43',NULL),(1863,3666,40849,4589,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-24','2023-09-24',12000.18,NULL,NULL,1,'2024-04-06 14:08:43','2024-04-06 14:08:43',NULL),(1864,3666,40849,4589,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',2227368.00,NULL,NULL,1,'2024-04-06 14:08:43','2024-04-06 14:08:43',NULL),(1865,3666,40849,4589,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',1404990.00,NULL,NULL,1,'2024-04-06 14:08:43','2024-04-06 14:08:43',NULL),(1866,3666,40849,4589,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',17258.86,NULL,NULL,1,'2024-04-06 14:08:43','2024-04-06 14:08:43',NULL),(1867,3666,40849,4589,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10001.80,NULL,NULL,1,'2024-04-06 14:08:43','2024-04-06 14:08:43',NULL),(1868,3666,40849,4590,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',13600.93,NULL,NULL,1,'2024-04-06 14:09:07','2024-04-06 14:09:07',NULL),(1869,3666,40849,4590,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',23700.40,NULL,NULL,1,'2024-04-06 14:09:07','2024-04-06 14:09:07',NULL),(1870,3666,40849,4590,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',19001.30,NULL,NULL,1,'2024-04-06 14:09:07','2024-04-06 14:09:07',NULL),(1871,3666,40849,4590,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',16879.50,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1872,3666,40849,4590,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',5801.25,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1873,3666,40849,4590,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',1588.42,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1874,3666,40849,4590,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',150000.05,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1875,3666,40849,4590,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',48675.86,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1876,3666,40849,4590,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',18000.50,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL);
INSERT INTO `balance_libro` VALUES (1877,3666,40849,4590,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',25001.39,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1878,3666,40849,4590,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',40001.71,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1879,3666,40849,4590,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-15','2023-10-15',13001.21,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1880,3666,40849,4590,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',24002.69,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1881,3666,40849,4590,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',18203.18,NULL,NULL,1,'2024-04-06 14:09:08','2024-04-06 14:09:08',NULL),(1882,3666,40849,4590,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',314700.00,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1883,3666,40849,4590,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',1153.86,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1884,3666,40849,4590,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',12772.79,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1885,3666,40849,4590,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',2002.16,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1886,3666,40849,4590,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',18404.56,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1887,3666,40849,4590,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',19400.00,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1888,3666,40849,4590,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',7559.29,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1889,3666,40849,4590,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',22504.24,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1890,3666,40849,4590,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',10000.16,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1891,3666,40849,4590,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',28697.01,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1892,3666,40849,4590,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',57339.48,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1893,3666,40849,4590,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',20001.49,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1894,3666,40849,4590,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',150000.00,NULL,NULL,1,'2024-04-06 14:09:09','2024-04-06 14:09:09',NULL),(1895,3666,40849,4591,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',19871.30,NULL,NULL,1,'2024-04-06 14:09:24','2024-04-06 14:09:24',NULL),(1896,3666,40849,4591,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',21001.39,NULL,NULL,1,'2024-04-06 14:09:24','2024-04-06 14:09:24',NULL),(1897,3666,40849,4591,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',21003.12,NULL,NULL,1,'2024-04-06 14:09:24','2024-04-06 14:09:24',NULL);
INSERT INTO `balance_libro` VALUES (1898,3666,40849,4591,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',33001.78,NULL,NULL,1,'2024-04-06 14:09:24','2024-04-06 14:09:24',NULL),(1899,3666,40849,4591,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',15593.39,NULL,NULL,1,'2024-04-06 14:09:24','2024-04-06 14:09:24',NULL),(1900,3666,40849,4591,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',17028.87,NULL,NULL,1,'2024-04-06 14:09:24','2024-04-06 14:09:24',NULL),(1901,3666,40849,4591,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2800.00,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1902,3666,40849,4591,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',255447.06,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1903,3666,40849,4591,3,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',169360.00,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1904,3666,40849,4591,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',15000.59,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1905,3666,40849,4591,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',500000.00,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1906,3666,40849,4591,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',8000.00,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1907,3666,40849,4591,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',102850.00,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1908,3666,40849,4591,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',10000.00,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1909,3666,40849,4591,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',20201.60,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1910,3666,40849,4591,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',478.92,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1911,3666,40849,4591,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',2847.51,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1912,3666,40849,4591,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',37514.89,NULL,NULL,1,'2024-04-06 14:09:25','2024-04-06 14:09:25',NULL),(1913,3666,40849,4591,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',19234.76,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1914,3666,40849,4591,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',5172.00,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1915,3666,40849,4591,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',33545.41,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1916,3666,40849,4591,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',8800.00,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1917,3666,40849,4591,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',139720.33,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1918,3666,40849,4591,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',15003.26,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL);
INSERT INTO `balance_libro` VALUES (1919,3666,40849,4591,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',10800.00,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1920,3666,40849,4591,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',20362.24,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1921,3666,40849,4591,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',24000.94,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1922,3666,40849,4591,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',700000.00,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1923,3666,40849,4591,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',700000.00,NULL,NULL,1,'2024-04-06 14:09:26','2024-04-06 14:09:26',NULL),(1924,3666,40849,4591,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',1400000.00,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1925,3666,40849,4591,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',1400000.00,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1926,3666,40849,4591,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',42075.00,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1927,3666,40849,4591,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',11900.83,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1928,3666,40849,4591,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',21002.89,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1929,3666,40849,4591,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',11290.96,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1930,3666,40849,4591,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',42327.00,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1931,3666,40849,4591,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',45004.81,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1932,3666,40849,4591,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',24693.00,NULL,NULL,1,'2024-04-06 14:09:27','2024-04-06 14:09:27',NULL),(1933,3666,40849,4592,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',19001.52,NULL,NULL,1,'2024-04-06 14:10:00','2024-04-06 14:10:00',NULL),(1934,3666,40849,4592,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',7200.00,NULL,NULL,1,'2024-04-06 14:10:00','2024-04-06 14:10:00',NULL),(1935,3666,40849,4592,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',12564.25,NULL,NULL,1,'2024-04-06 14:10:00','2024-04-06 14:10:00',NULL),(1936,3666,40849,4592,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',3000.18,NULL,NULL,1,'2024-04-06 14:10:00','2024-04-06 14:10:00',NULL),(1937,3666,40849,4592,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',18702.38,NULL,NULL,1,'2024-04-06 14:10:00','2024-04-06 14:10:00',NULL),(1938,3666,40849,4592,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',9980.50,NULL,NULL,1,'2024-04-06 14:10:00','2024-04-06 14:10:00',NULL),(1939,3666,40849,4592,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',6610.00,NULL,NULL,1,'2024-04-06 14:10:00','2024-04-06 14:10:00',NULL);
INSERT INTO `balance_libro` VALUES (1940,3666,40849,4592,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',7200.00,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1941,3666,40849,4592,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',8650.00,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1942,3666,40849,4592,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',22006.40,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1943,3666,40849,4592,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',14651.97,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1944,3666,40849,4592,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',210000.00,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1945,3666,40849,4592,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',19981.72,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1946,3666,40849,4592,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',8000.47,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1947,3666,40849,4592,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',19114.00,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1948,3666,40849,4592,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',299780.03,NULL,NULL,1,'2024-04-06 14:10:01','2024-04-06 14:10:01',NULL),(1949,3666,40849,4592,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',4900.00,NULL,NULL,1,'2024-04-06 14:10:02','2024-04-06 14:10:02',NULL),(1950,3666,40849,4592,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',13860.69,NULL,NULL,1,'2024-04-06 14:10:02','2024-04-06 14:10:02',NULL),(1951,3666,40849,4592,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',10500.00,NULL,NULL,1,'2024-04-06 14:10:02','2024-04-06 14:10:02',NULL),(1952,3666,40849,4592,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',30000.65,NULL,NULL,1,'2024-04-06 14:10:02','2024-04-06 14:10:02',NULL),(1953,3666,40849,4592,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',1514.46,NULL,NULL,1,'2024-04-06 14:10:02','2024-04-06 14:10:02',NULL),(1954,3666,40849,4592,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',41002.76,NULL,NULL,1,'2024-04-06 14:10:02','2024-04-06 14:10:02',NULL),(1955,3666,40849,4592,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',49121.84,NULL,NULL,1,'2024-04-06 14:10:02','2024-04-06 14:10:02',NULL),(1956,3666,40849,4592,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',41999.96,NULL,NULL,1,'2024-04-06 14:10:02','2024-04-06 14:10:02',NULL),(1957,3666,40849,4592,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',30404.80,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL),(1958,3666,40849,4592,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',3544.38,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL),(1959,3666,40849,4592,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',21201.18,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL),(1960,3666,40849,4592,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',12220.00,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL);
INSERT INTO `balance_libro` VALUES (1961,3666,40849,4592,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',582000.00,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL),(1962,3666,40849,4592,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',24005.38,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL),(1963,3666,40849,4592,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',1459.26,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL),(1964,3666,40849,4592,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',1459.26,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL),(1965,3666,40849,4592,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',1323241.36,NULL,NULL,1,'2024-04-06 14:10:03','2024-04-06 14:10:03',NULL),(1966,3666,40849,4592,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',3954139.64,NULL,NULL,1,'2024-04-06 14:10:04','2024-04-06 14:10:04',NULL),(1967,3666,40849,4592,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',15000.00,NULL,NULL,1,'2024-04-06 14:10:04','2024-04-06 14:10:04',NULL),(1968,3666,40849,4592,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',11200.00,NULL,NULL,1,'2024-04-06 14:10:04','2024-04-06 14:10:04',NULL),(1969,3666,40849,4592,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',3969724.08,NULL,NULL,1,'2024-04-06 14:10:04','2024-04-06 14:10:04',NULL),(1970,3666,40849,4592,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',1000050.00,NULL,NULL,1,'2024-04-06 14:10:04','2024-04-06 14:10:04',NULL),(1971,3666,40849,4585,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',26453168.00,NULL,NULL,1,'2024-04-09 08:33:08','2024-04-20 14:50:27','2024-04-20 14:50:27'),(1972,3666,40849,4587,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',14171340.00,NULL,NULL,1,'2024-04-09 08:34:40','2024-04-20 14:52:18','2024-04-20 14:52:18'),(1973,3666,40849,4587,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',10203364.80,NULL,NULL,1,'2024-04-09 08:34:40','2024-04-20 14:52:47','2024-04-20 14:52:47'),(1974,3666,40849,4587,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',14171340.00,NULL,NULL,1,'2024-04-09 08:34:41','2024-04-20 14:53:10','2024-04-20 14:53:10'),(1975,3666,40849,4589,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',2722389.00,NULL,NULL,1,'2024-04-09 08:35:08','2024-04-20 14:53:50','2024-04-20 14:53:50'),(1976,3666,40849,4592,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',29759814.00,NULL,NULL,1,'2024-04-09 08:35:58','2024-04-20 14:54:10','2024-04-20 14:54:10'),(1977,3666,40849,4581,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12792.13,NULL,NULL,1,'2024-04-09 08:58:05','2024-04-09 08:58:05',NULL),(1978,3666,40849,4581,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',13143.45,NULL,NULL,1,'2024-04-09 09:12:19','2024-04-09 09:12:19',NULL),(1979,3666,40849,4581,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10000.84,NULL,NULL,1,'2024-04-09 09:15:42','2024-04-09 09:15:42',NULL),(1980,3666,40849,4581,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',637.98,NULL,NULL,1,'2024-04-09 09:17:19','2024-04-09 09:17:19',NULL);
INSERT INTO `balance_libro` VALUES (1981,3666,40849,4581,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',47294.36,NULL,NULL,1,'2024-04-09 09:25:44','2024-04-09 09:25:44',NULL),(1982,3666,40849,4581,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',8001.50,NULL,NULL,1,'2024-04-09 09:28:02','2024-04-09 09:28:02',NULL),(1983,3666,40849,4581,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',36720.77,NULL,NULL,1,'2024-04-09 09:30:25','2024-04-09 09:30:25',NULL),(1984,3666,40849,4581,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3380.00,NULL,NULL,1,'2024-04-09 09:32:23','2024-04-09 09:34:12','2024-04-09 09:34:12'),(1985,3666,40849,4581,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',19982.06,NULL,NULL,1,'2024-04-09 09:34:13','2024-04-09 09:34:58','2024-04-09 09:34:58'),(1986,3666,40849,4581,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',20000.55,NULL,NULL,1,'2024-04-09 09:34:58','2024-04-09 09:34:58',NULL),(1987,3666,40849,4581,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',8000.65,NULL,NULL,1,'2024-04-09 09:40:43','2024-04-09 09:40:43',NULL),(1988,3666,40849,4581,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',8364.80,NULL,NULL,1,'2024-04-09 09:41:58','2024-04-09 09:41:58',NULL),(1989,3666,40849,4581,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',19999.53,NULL,NULL,1,'2024-04-09 09:43:28','2024-04-09 09:43:28',NULL),(1990,3666,40849,4581,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',258.95,NULL,NULL,1,'2024-04-09 09:46:07','2024-04-09 09:46:07',NULL),(1991,3666,40849,4581,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',17202.39,NULL,NULL,1,'2024-04-09 09:47:44','2024-04-09 09:47:44',NULL),(1992,3666,40849,4581,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1600.00,NULL,NULL,1,'2024-04-09 09:50:09','2024-04-09 09:50:09',NULL),(1993,3666,40849,4581,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1699.99,NULL,NULL,1,'2024-04-09 09:53:23','2024-04-09 09:53:23',NULL),(1994,3666,40849,4581,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',10001.42,NULL,NULL,1,'2024-04-09 09:54:30','2024-04-09 09:54:30',NULL),(1995,3666,40849,4581,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',9001.35,NULL,NULL,1,'2024-04-09 09:55:19','2024-04-09 09:55:19',NULL),(1996,3666,40849,4581,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10000.59,NULL,NULL,1,'2024-04-09 09:56:22','2024-04-09 09:56:22',NULL),(1997,3666,40849,4581,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',14200.43,NULL,NULL,1,'2024-04-09 09:59:59','2024-04-09 09:59:59',NULL),(1998,3666,40849,4581,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',50000.36,NULL,NULL,1,'2024-04-09 11:27:26','2024-04-09 11:27:26',NULL),(1999,3666,40849,4581,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',17978.72,NULL,NULL,1,'2024-04-09 11:28:36','2024-04-09 11:28:36',NULL),(2000,3666,40849,4581,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3380.00,NULL,NULL,1,'2024-04-09 11:36:19','2024-04-09 11:36:19',NULL),(2001,3666,40849,4582,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5034.04,NULL,NULL,1,'2024-04-09 11:38:26','2024-04-09 11:38:26',NULL);
INSERT INTO `balance_libro` VALUES (2002,3666,40849,4592,23,2002,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',97542741.35,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-04-13 11:43:31','2024-04-13 13:06:03','2024-04-13 13:06:03'),(2003,3666,40849,4581,12,2003,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',91192238.80,'ASIENTO DE REAPERTURA CTAS PATRIMONIALES',NULL,1,'2024-04-13 13:14:50','2024-04-13 13:14:50',NULL),(2004,3666,40849,4592,23,2004,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',104860092.87,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-04-13 13:18:56','2024-04-15 10:06:05','2024-04-15 10:06:05'),(2005,3666,40849,4592,23,2005,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',186544752.22,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-04-15 10:13:44','2024-04-17 08:42:33','2024-04-17 08:42:33'),(2006,3666,40849,4589,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',76646634.46,NULL,NULL,1,'2024-04-20 12:41:18','2024-04-20 13:06:18','2024-04-20 13:06:18'),(2007,3666,40849,4589,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',56725496.65,NULL,NULL,1,'2024-04-20 12:42:54','2024-04-20 13:06:27','2024-04-20 13:06:27'),(2008,3666,40849,4589,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',79518093.96,NULL,NULL,1,'2024-04-20 13:06:18','2024-04-20 13:06:18',NULL),(2009,3666,40849,4592,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',53852971.58,NULL,NULL,1,'2024-04-20 13:10:35','2024-04-20 13:10:35',NULL),(2010,3666,40849,4585,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',26453168.00,NULL,NULL,1,'2024-04-20 14:50:27','2024-04-20 14:50:27',NULL),(2011,3666,40849,4587,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',14171340.00,NULL,NULL,1,'2024-04-20 14:52:18','2024-04-20 14:52:18',NULL),(2012,3666,40849,4587,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',10475049.60,NULL,NULL,1,'2024-04-20 14:52:47','2024-04-20 15:18:16','2024-04-20 15:18:16'),(2013,3666,40849,4587,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',14171340.00,NULL,NULL,1,'2024-04-20 14:53:10','2024-04-20 14:53:10',NULL),(2014,3666,40849,4589,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',2722389.00,NULL,NULL,1,'2024-04-20 14:53:50','2024-04-20 14:53:50',NULL),(2015,3666,40849,4592,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',29759814.00,NULL,NULL,1,'2024-04-20 14:54:10','2024-04-20 14:54:10',NULL),(2016,3666,40849,4584,22,2016,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1370801.45,'CANCELACION PRESTAMO IFAI',NULL,1,'2024-04-20 15:11:23','2024-04-20 15:11:23',NULL),(2017,3666,40849,4584,22,2017,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',20000000.00,'PRESTAMO IFAI',NULL,1,'2024-04-20 15:12:22','2024-04-20 15:12:22',NULL),(2018,3666,40849,4587,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',10203364.80,NULL,NULL,1,'2024-04-20 15:18:16','2024-04-20 15:18:16',NULL),(2019,3666,40849,4592,20,1518,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1518,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',97481415.80,NULL,NULL,1,'2024-04-20 15:21:07','2024-04-20 15:21:07',NULL),(2020,3666,40849,4592,21,1519,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1519,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',113081921.66,NULL,NULL,1,'2024-04-20 15:44:18','2024-04-20 15:44:18',NULL);
INSERT INTO `balance_libro` VALUES (2021,3666,40849,4592,16,2021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',2595635.80,'LIQUIDACION IIBB MNES',NULL,1,'2024-04-20 16:09:36','2024-04-20 16:09:36',NULL),(2022,3666,40849,4592,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',5050012.57,NULL,NULL,1,'2024-04-20 16:23:38','2024-05-13 10:39:24','2024-05-13 10:39:24'),(2023,3666,40849,4592,21,1521,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1521,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',5050012.57,NULL,NULL,1,'2024-04-20 16:25:21','2024-05-13 10:38:16','2024-05-13 10:38:16'),(2024,3666,40849,4592,11,2024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',38649535.43,'AJUSTE VALUACION YERBA CANCHADA',NULL,1,'2024-04-20 16:31:00','2024-05-13 09:42:50','2024-05-13 09:42:50'),(2025,3666,40849,4592,23,2025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',104847674.58,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-04-20 16:34:05','2024-04-20 20:53:11','2024-04-20 20:53:11'),(2026,3666,40849,4592,4,2026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',506065.69,'AMORTIZACION EDIFICIO',NULL,1,'2024-04-20 20:18:17','2024-04-20 20:53:11','2024-04-20 20:53:11'),(2027,3666,40849,4592,4,2027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',506065.69,'AMORTIZACION EDIFICIO',NULL,1,'2024-04-20 20:56:55','2024-04-20 20:56:55',NULL),(2028,3666,40849,4592,23,2028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',103015282.69,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-04-20 20:58:30','2024-05-13 09:38:06','2024-05-13 09:38:06'),(2029,3666,40849,4592,23,2029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',41867360.89,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-04-21 18:46:10','2024-04-21 18:50:29','2024-04-21 18:50:29'),(2030,3666,40720,1574,17,2030,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',190219837.51,'CIERRE CUENTAS PATRIMONIALES',NULL,1,'2024-04-27 12:24:26','2024-04-27 12:24:26',NULL),(2031,3666,40720,1575,12,2031,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',190219837.51,'ASIENTO REAPERTURA',NULL,1,'2024-05-01 20:06:30','2024-05-01 20:06:30',NULL),(2032,3666,40849,4592,23,2032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',221817976.04,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-05-13 09:44:08','2024-05-13 09:45:32','2024-05-13 09:45:32'),(2033,3666,40849,4592,23,2033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',69410689.46,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-05-13 09:47:03','2024-05-13 09:55:00','2024-05-13 09:55:00'),(2034,3666,40849,4592,23,2034,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',69410689.46,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-05-13 09:56:09','2024-05-13 09:56:10',NULL),(2035,3666,40849,4592,23,2035,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1167026.20,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-05-13 09:59:19','2024-05-13 09:59:47','2024-05-13 09:59:47'),(2036,3666,40849,4592,23,2036,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',55734446.47,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-05-13 10:00:14','2024-05-13 10:00:14',NULL),(2037,3666,40849,4592,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',10050012.57,NULL,NULL,1,'2024-05-13 10:39:24','2024-05-13 10:39:24',NULL);
INSERT INTO `balance_libro` VALUES (2038,3666,40849,4592,21,1523,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1523,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',5050012.57,NULL,NULL,1,'2024-05-13 10:43:25','2024-05-13 10:43:25',NULL),(2039,3666,40849,4592,11,2039,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',33649535.43,'AJUSTE VALUACION YERBA CANCHADA',NULL,1,'2024-05-13 10:45:37','2024-05-13 10:45:37',NULL),(2040,3666,40720,1575,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',35747.00,NULL,NULL,1,'2024-06-19 19:55:29','2024-06-19 19:55:29',NULL),(2041,3666,40720,1575,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',59048.00,NULL,NULL,1,'2024-06-19 19:55:29','2024-06-19 19:55:29',NULL),(2042,3666,40720,1575,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',48400.00,NULL,NULL,1,'2024-06-19 19:55:29','2024-06-19 19:55:29',NULL),(2043,3666,40720,1575,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',41817.60,NULL,NULL,1,'2024-06-19 19:55:29','2024-06-19 19:55:29',NULL),(2044,3666,40720,1575,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',41817.60,NULL,NULL,1,'2024-06-19 19:55:29','2024-06-19 19:55:29',NULL),(2045,3666,40720,1577,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',35747.00,NULL,NULL,1,'2024-06-19 20:42:34','2024-06-19 20:42:34',NULL),(2046,3666,40720,1577,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',48400.00,NULL,NULL,1,'2024-06-19 20:42:34','2024-06-19 20:42:34',NULL),(2047,3666,40720,1577,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',41817.60,NULL,NULL,1,'2024-06-19 20:42:34','2024-06-19 20:42:34',NULL),(2048,3666,40720,1577,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',59048.00,NULL,NULL,1,'2024-06-19 20:42:34','2024-06-19 20:42:34',NULL),(2049,3666,40720,1577,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',41817.60,NULL,NULL,1,'2024-06-19 20:42:34','2024-06-19 20:42:34',NULL),(2050,3666,40720,1576,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',41817.60,NULL,NULL,1,'2024-06-19 20:44:22','2024-06-19 20:44:22',NULL),(2051,3666,40720,1576,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',59048.00,NULL,NULL,1,'2024-06-19 20:44:22','2024-06-19 20:44:22',NULL),(2052,3666,40720,1576,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',35747.00,NULL,NULL,1,'2024-06-19 20:44:22','2024-06-19 20:44:22',NULL),(2053,3666,40720,1576,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',48400.00,NULL,NULL,1,'2024-06-19 20:44:22','2024-06-19 20:44:22',NULL),(2054,3666,40720,1576,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',41817.60,NULL,NULL,1,'2024-06-19 20:44:22','2024-06-19 20:44:22',NULL),(2055,3666,40720,1578,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',59048.00,NULL,NULL,1,'2024-06-19 20:44:35','2024-06-19 20:47:05','2024-06-19 20:47:05'),(2056,3666,40720,1578,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',41817.60,NULL,NULL,1,'2024-06-19 20:44:35','2024-06-19 20:47:50','2024-06-19 20:47:50'),(2057,3666,40720,1578,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',35747.00,NULL,NULL,1,'2024-06-19 20:44:35','2024-06-19 20:47:44','2024-06-19 20:47:44');
INSERT INTO `balance_libro` VALUES (2058,3666,40720,1578,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',48400.00,NULL,NULL,1,'2024-06-19 20:44:35','2024-06-19 20:47:38','2024-06-19 20:47:38'),(2059,3666,40720,1578,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',41817.60,NULL,NULL,1,'2024-06-19 20:44:35','2024-06-19 20:47:33','2024-06-19 20:47:33'),(2060,3666,40720,1578,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',20000.01,NULL,NULL,1,'2024-06-19 20:44:35','2024-06-19 20:47:25','2024-06-19 20:47:25'),(2061,3666,40720,1578,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',24200.00,NULL,NULL,1,'2024-06-19 20:44:35','2024-06-19 20:47:17','2024-06-19 20:47:17'),(2062,3666,40720,1578,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',20000.01,NULL,NULL,1,'2024-06-19 20:44:35','2024-06-19 20:46:40','2024-06-19 20:46:40'),(2063,3666,40720,1578,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',59048.00,NULL,NULL,1,'2024-06-19 20:48:16','2024-06-19 20:48:16',NULL),(2064,3666,40720,1578,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',41817.60,NULL,NULL,1,'2024-06-19 20:48:16','2024-06-19 20:48:16',NULL),(2065,3666,40720,1578,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',35747.00,NULL,NULL,1,'2024-06-19 20:48:16','2024-06-19 20:48:16',NULL),(2066,3666,40720,1578,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',48400.00,NULL,NULL,1,'2024-06-19 20:48:16','2024-06-19 20:48:16',NULL),(2067,3666,40720,1578,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',41817.60,NULL,NULL,1,'2024-06-19 20:48:16','2024-06-19 20:48:16',NULL),(2068,3666,40720,1578,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',20000.03,NULL,NULL,1,'2024-06-19 20:48:16','2024-06-19 20:48:16',NULL),(2069,3666,40720,1578,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',24200.00,NULL,NULL,1,'2024-06-19 20:48:16','2024-06-19 20:48:16',NULL),(2070,3666,40720,1578,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',20000.03,NULL,NULL,1,'2024-06-19 20:48:16','2024-06-19 20:48:16',NULL),(2071,3666,40720,1579,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',35747.00,NULL,NULL,1,'2024-06-19 20:49:07','2024-06-19 20:49:07',NULL),(2072,3666,40720,1579,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',59048.00,NULL,NULL,1,'2024-06-19 20:49:07','2024-06-19 20:49:07',NULL),(2073,3666,40720,1579,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',41817.60,NULL,NULL,1,'2024-06-19 20:49:07','2024-06-19 20:49:07',NULL),(2074,3666,40720,1579,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',48400.00,NULL,NULL,1,'2024-06-19 20:49:07','2024-06-19 20:49:07',NULL),(2075,3666,40720,1579,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',24200.00,NULL,NULL,1,'2024-06-19 20:49:08','2024-06-19 20:49:08',NULL),(2076,3666,40720,1579,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',41817.60,NULL,NULL,1,'2024-06-19 20:49:08','2024-06-19 20:49:08',NULL),(2077,3666,40720,1579,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',62726.40,NULL,NULL,1,'2024-06-19 20:49:08','2024-06-19 20:49:08',NULL);
INSERT INTO `balance_libro` VALUES (2078,3666,40720,1579,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',62726.40,NULL,NULL,1,'2024-06-19 20:49:08','2024-06-19 20:49:08',NULL),(2079,3666,40720,1579,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',31460.00,NULL,NULL,1,'2024-06-19 20:49:08','2024-06-19 20:49:08',NULL),(2080,3666,40720,1579,2,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',24200.00,NULL,NULL,1,'2024-06-19 20:49:08','2024-06-19 20:49:08',NULL),(2081,3666,40720,1580,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',62726.40,NULL,NULL,1,'2024-06-19 20:49:19','2024-06-19 20:49:19',NULL),(2082,3666,40720,1580,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',35747.00,NULL,NULL,1,'2024-06-19 20:49:20','2024-06-19 20:49:20',NULL),(2083,3666,40720,1580,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',48400.00,NULL,NULL,1,'2024-06-19 20:49:20','2024-06-19 20:49:20',NULL),(2084,3666,40720,1580,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',41817.60,NULL,NULL,1,'2024-06-19 20:49:20','2024-06-19 20:49:20',NULL),(2085,3666,40720,1580,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',59048.00,NULL,NULL,1,'2024-06-19 20:49:20','2024-06-19 20:49:20',NULL),(2086,3666,40720,1580,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',41817.60,NULL,NULL,1,'2024-06-19 20:49:20','2024-06-19 20:49:20',NULL),(2087,3666,40720,1580,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',31460.00,NULL,NULL,1,'2024-06-19 20:49:20','2024-06-19 20:49:20',NULL),(2088,3666,40720,1581,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',35747.00,NULL,NULL,1,'2024-06-19 20:49:33','2024-06-19 20:49:33',NULL),(2089,3666,40720,1581,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',48400.00,NULL,NULL,1,'2024-06-19 20:49:33','2024-06-19 20:49:33',NULL),(2090,3666,40720,1581,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',41817.60,NULL,NULL,1,'2024-06-19 20:49:33','2024-06-19 20:49:33',NULL),(2091,3666,40720,1581,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',31460.00,NULL,NULL,1,'2024-06-19 20:49:33','2024-06-19 20:49:33',NULL),(2092,3666,40720,1581,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',59048.00,NULL,NULL,1,'2024-06-19 20:49:33','2024-06-19 20:49:33',NULL),(2093,3666,40720,1581,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',41817.60,NULL,NULL,1,'2024-06-19 20:49:33','2024-06-19 20:49:33',NULL),(2094,3666,40720,1582,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',35747.00,NULL,NULL,1,'2024-06-19 20:49:44','2024-06-19 20:49:44',NULL),(2095,3666,40720,1582,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',48400.00,NULL,NULL,1,'2024-06-19 20:49:44','2024-06-19 20:49:44',NULL),(2096,3666,40720,1582,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',41817.60,NULL,NULL,1,'2024-06-19 20:49:44','2024-06-19 20:49:44',NULL),(2097,3666,40720,1582,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',59048.00,NULL,NULL,1,'2024-06-19 20:49:44','2024-06-19 20:49:44',NULL),(2098,3666,40720,1582,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',41817.60,NULL,NULL,1,'2024-06-19 20:49:44','2024-06-19 20:49:44',NULL);
INSERT INTO `balance_libro` VALUES (2099,3666,40720,1582,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',31460.00,NULL,NULL,1,'2024-06-19 20:49:44','2024-06-19 20:49:44',NULL),(2100,3666,40720,1583,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',59048.00,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2101,3666,40720,1583,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',41817.60,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2102,3666,40720,1583,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',35747.00,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2103,3666,40720,1583,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',35747.00,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2104,3666,40720,1583,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',48400.00,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2105,3666,40720,1583,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',41817.60,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2106,3666,40720,1583,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',31460.00,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2107,3666,40720,1583,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',242000.00,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2108,3666,40720,1583,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',6359.76,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2109,3666,40720,1583,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',6359.76,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2110,3666,40720,1583,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',60500.00,NULL,NULL,1,'2024-06-19 20:49:57','2024-06-19 20:49:57',NULL),(2111,3666,40720,1583,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',36429.47,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL),(2112,3666,40720,1583,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',27209.27,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL),(2113,3666,40720,1583,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',36429.47,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL),(2114,3666,40720,1583,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',27209.27,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL),(2115,3666,40720,1583,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',302500.00,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL),(2116,3666,40720,1583,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',1459.26,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL),(2117,3666,40720,1583,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',22896.83,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL),(2118,3666,40720,1583,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',22896.83,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL),(2119,3666,40720,1583,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',1459.26,NULL,NULL,1,'2024-06-19 20:49:58','2024-06-19 20:49:58',NULL);
INSERT INTO `balance_libro` VALUES (2120,3666,40720,1587,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',41817.60,NULL,NULL,1,'2024-06-19 20:50:13','2024-06-19 20:50:13',NULL),(2121,3666,40720,1587,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',41817.60,NULL,NULL,1,'2024-06-19 20:50:13','2024-06-19 20:50:13',NULL),(2122,3666,40720,1587,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',59048.00,NULL,NULL,1,'2024-06-19 20:50:13','2024-06-19 20:50:13',NULL),(2123,3666,40720,1587,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',48400.00,NULL,NULL,1,'2024-06-19 20:50:13','2024-06-19 20:50:13',NULL),(2124,3666,40720,1587,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',31460.00,NULL,NULL,1,'2024-06-19 20:50:13','2024-06-19 20:50:13',NULL),(2125,3666,40720,1587,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',36429.47,NULL,NULL,1,'2024-06-19 20:50:13','2024-06-19 20:50:13',NULL),(2126,3666,40720,1587,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',22896.83,NULL,NULL,1,'2024-06-19 20:50:14','2024-06-19 20:50:14',NULL),(2127,3666,40720,1587,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',1459.26,NULL,NULL,1,'2024-06-19 20:50:14','2024-06-19 20:50:14',NULL),(2128,3666,40720,1587,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',27209.27,NULL,NULL,1,'2024-06-19 20:50:14','2024-06-19 20:50:14',NULL),(2129,3666,40720,1588,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',1459.26,NULL,NULL,1,'2024-06-19 20:50:24','2024-06-19 20:50:24',NULL),(2130,3666,40720,1588,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',27209.27,NULL,NULL,1,'2024-06-19 20:50:24','2024-06-19 20:50:24',NULL),(2131,3666,40720,1588,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',22896.83,NULL,NULL,1,'2024-06-19 20:50:24','2024-06-19 20:50:24',NULL),(2132,3666,40720,1588,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',36429.47,NULL,NULL,1,'2024-06-19 20:50:24','2024-06-19 20:50:24',NULL),(2133,3666,40720,1588,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',48400.00,NULL,NULL,1,'2024-06-19 20:50:24','2024-06-19 20:50:24',NULL),(2134,3666,40720,1588,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',41817.60,NULL,NULL,1,'2024-06-19 20:50:24','2024-06-19 20:50:24',NULL),(2135,3666,40720,1588,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',41817.60,NULL,NULL,1,'2024-06-19 20:50:24','2024-06-19 20:50:24',NULL),(2136,3666,40720,1588,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',59048.00,NULL,NULL,1,'2024-06-19 20:50:24','2024-06-19 20:50:24',NULL),(2137,3666,40720,1588,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',31460.00,NULL,NULL,1,'2024-06-19 20:50:25','2024-06-19 20:50:25',NULL),(2138,3666,40720,1589,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',41817.60,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2139,3666,40720,1589,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',48400.00,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2140,3666,40720,1589,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',1459.26,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL);
INSERT INTO `balance_libro` VALUES (2141,3666,40720,1589,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',41817.60,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2142,3666,40720,1589,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',22896.83,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2143,3666,40720,1589,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',27209.27,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2144,3666,40720,1589,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',36429.47,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2145,3666,40720,1589,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',31460.00,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2146,3666,40720,1589,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',76317.12,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2147,3666,40720,1589,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',13133.34,NULL,NULL,1,'2024-06-19 20:50:40','2024-06-19 20:50:40',NULL),(2148,3666,40720,1575,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',22823.68,NULL,NULL,1,'2024-06-19 20:53:58','2024-06-20 19:20:23','2024-06-20 19:20:23'),(2149,3666,40720,1575,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',942590.00,NULL,NULL,1,'2024-06-19 20:53:58','2024-06-21 18:13:19','2024-06-21 18:13:19'),(2150,3666,40720,1575,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',213347.20,NULL,NULL,1,'2024-06-19 20:53:58','2024-06-21 18:14:21','2024-06-21 18:14:21'),(2151,3666,40720,1575,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.00,NULL,NULL,1,'2024-06-19 20:53:58','2024-06-19 20:53:58',NULL),(2152,3666,40720,1575,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',61364.00,NULL,NULL,1,'2024-06-19 20:53:58','2024-06-19 20:53:58',NULL),(2153,3666,40720,1576,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',10000.00,NULL,NULL,1,'2024-06-19 20:54:33','2024-06-19 20:54:33',NULL),(2154,3666,40720,1576,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',21175.94,NULL,NULL,1,'2024-06-19 20:54:33','2024-06-20 19:42:05','2024-06-20 19:42:05'),(2155,3666,40720,1576,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1230669.00,NULL,NULL,1,'2024-06-19 20:54:33','2024-06-20 19:42:48','2024-06-20 19:42:48'),(2156,3666,40720,1576,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6000.00,NULL,NULL,1,'2024-06-19 20:54:33','2024-06-19 20:54:33',NULL),(2157,3666,40720,1576,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',61364.00,NULL,NULL,1,'2024-06-19 20:54:33','2024-06-19 20:54:33',NULL),(2158,3666,40720,1577,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',24618.08,NULL,NULL,1,'2024-06-19 20:55:36','2024-06-20 19:47:18','2024-06-20 19:47:18'),(2159,3666,40720,1577,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',704708.35,NULL,NULL,1,'2024-06-19 20:55:36','2024-06-19 20:55:36',NULL),(2160,3666,40720,1577,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',626291.69,NULL,NULL,1,'2024-06-19 20:55:36','2024-06-19 20:55:36',NULL);
INSERT INTO `balance_libro` VALUES (2161,3666,40720,1577,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',5000.01,NULL,NULL,1,'2024-06-19 20:55:36','2024-06-20 19:50:14','2024-06-20 19:50:14'),(2162,3666,40720,1577,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6000.00,NULL,NULL,1,'2024-06-19 20:55:37','2024-06-19 20:55:37',NULL),(2163,3666,40720,1577,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',61364.00,NULL,NULL,1,'2024-06-19 20:55:37','2024-06-19 20:55:37',NULL),(2164,3666,40720,1578,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',6000.00,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2165,3666,40720,1578,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',63521.79,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-20 19:55:05','2024-06-20 19:55:05'),(2166,3666,40720,1578,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',386749.65,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2167,3666,40720,1578,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',21300.00,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2168,3666,40720,1578,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',46215.86,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-21 10:36:26','2024-06-21 10:36:26'),(2169,3666,40720,1578,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',451976.02,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2170,3666,40720,1578,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',885014.57,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2171,3666,40720,1578,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',383635.00,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2172,3666,40720,1578,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',21300.00,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2173,3666,40720,1578,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',4999.99,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2174,3666,40720,1578,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6000.00,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2175,3666,40720,1578,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',61364.00,NULL,NULL,1,'2024-06-19 20:56:01','2024-06-19 20:56:01',NULL),(2176,3666,40720,1579,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',9999.98,NULL,NULL,1,'2024-06-19 20:56:28','2024-06-19 20:56:28',NULL),(2177,3666,40720,1579,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',35664.98,NULL,NULL,1,'2024-06-19 20:56:28','2024-06-21 10:41:58','2024-06-21 10:41:58'),(2178,3666,40720,1579,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',4680.72,NULL,NULL,1,'2024-06-19 20:56:28','2024-06-19 20:56:28',NULL),(2179,3666,40720,1579,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',636435.00,NULL,NULL,1,'2024-06-19 20:56:29','2024-06-19 20:56:29',NULL),(2180,3666,40720,1579,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',636438.63,NULL,NULL,1,'2024-06-19 20:56:29','2024-06-19 20:56:29',NULL);
INSERT INTO `balance_libro` VALUES (2181,3666,40720,1579,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',636435.00,NULL,NULL,1,'2024-06-19 20:56:29','2024-06-19 20:56:29',NULL),(2182,3666,40720,1579,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6000.00,NULL,NULL,1,'2024-06-19 20:56:29','2024-06-19 20:56:29',NULL),(2183,3666,40720,1579,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',61364.00,NULL,NULL,1,'2024-06-19 20:56:29','2024-06-19 20:56:29',NULL),(2184,3666,40720,1580,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',36192.70,NULL,NULL,1,'2024-06-19 20:56:57','2024-06-21 10:44:51','2024-06-21 10:44:51'),(2185,3666,40720,1580,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',6000.00,NULL,NULL,1,'2024-06-19 20:56:57','2024-06-19 20:56:57',NULL),(2186,3666,40720,1580,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',82841.00,NULL,NULL,1,'2024-06-19 20:56:57','2024-06-19 20:56:57',NULL),(2187,3666,40720,1581,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',19663.91,NULL,NULL,1,'2024-06-19 20:57:18','2024-06-21 10:48:07','2024-06-21 10:48:07'),(2188,3666,40720,1581,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',9500.00,NULL,NULL,1,'2024-06-19 20:57:18','2024-06-19 20:57:18',NULL),(2189,3666,40720,1581,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',82841.00,NULL,NULL,1,'2024-06-19 20:57:19','2024-06-19 20:57:19',NULL),(2190,3666,40720,1582,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',20514.82,NULL,NULL,1,'2024-06-19 20:57:35','2024-06-21 10:50:46','2024-06-21 10:50:46'),(2191,3666,40720,1582,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',9500.00,NULL,NULL,1,'2024-06-19 20:57:35','2024-06-19 20:57:35',NULL),(2192,3666,40720,1583,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',82841.00,NULL,NULL,1,'2024-06-19 20:57:55','2024-06-19 20:57:55',NULL),(2193,3666,40720,1583,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',21836.08,NULL,NULL,1,'2024-06-19 20:57:55','2024-06-21 10:56:58','2024-06-21 10:56:58'),(2194,3666,40720,1583,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',15412.12,NULL,NULL,1,'2024-06-19 20:57:55','2024-06-19 20:57:55',NULL),(2195,3666,40720,1583,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',82841.00,NULL,NULL,1,'2024-06-19 20:57:56','2024-06-19 20:57:56',NULL),(2196,3666,40720,1583,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',22490.63,NULL,NULL,1,'2024-06-19 20:57:56','2024-06-19 20:57:56',NULL),(2197,3666,40720,1583,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',9500.00,NULL,NULL,1,'2024-06-19 20:57:56','2024-06-19 20:57:56',NULL),(2198,3666,40720,1587,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',27092.96,NULL,NULL,1,'2024-06-19 20:58:53','2024-06-21 11:00:35','2024-06-21 11:00:35'),(2199,3666,40720,1587,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',30807.08,NULL,NULL,1,'2024-06-19 20:58:53','2024-06-19 20:58:53',NULL),(2200,3666,40720,1587,3,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',9500.00,NULL,NULL,1,'2024-06-19 20:58:53','2024-06-19 20:58:53',NULL);
INSERT INTO `balance_libro` VALUES (2201,3666,40720,1588,3,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',30008.00,NULL,NULL,1,'2024-06-19 20:59:10','2024-06-19 20:59:10',NULL),(2202,3666,40720,1588,3,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',82841.00,NULL,NULL,1,'2024-06-19 20:59:10','2024-06-19 20:59:10',NULL),(2203,3666,40720,1588,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',29927.57,NULL,NULL,1,'2024-06-19 20:59:11','2024-06-21 11:03:44','2024-06-21 11:03:44'),(2204,3666,40720,1588,3,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',14999.99,NULL,NULL,1,'2024-06-19 20:59:11','2024-06-19 20:59:11',NULL),(2205,3666,40720,1588,3,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',82841.00,NULL,NULL,1,'2024-06-19 20:59:11','2024-06-19 20:59:11',NULL),(2206,3666,40720,1589,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',37385.17,NULL,NULL,1,'2024-06-19 20:59:34','2024-06-21 11:12:07','2024-06-21 11:12:07'),(2207,3666,40720,1589,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',14999.99,NULL,NULL,1,'2024-06-19 20:59:34','2024-06-19 20:59:34',NULL),(2208,3666,40720,1589,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',165682.00,NULL,NULL,1,'2024-06-19 20:59:34','2024-06-19 20:59:34',NULL),(2209,3666,40720,1575,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',22823.68,NULL,NULL,1,'2024-06-20 19:20:23','2024-06-20 20:01:43','2024-06-20 20:01:43'),(2210,3666,40720,1576,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',21175.94,NULL,NULL,1,'2024-06-20 19:42:05','2024-08-25 21:12:58','2024-08-25 21:12:58'),(2211,3666,40720,1576,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1230669.00,NULL,NULL,1,'2024-06-20 19:42:48','2024-06-21 18:14:50','2024-06-21 18:14:50'),(2212,3666,40720,1577,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',24618.08,NULL,NULL,1,'2024-06-20 19:47:18','2024-08-25 21:27:44','2024-08-25 21:27:44'),(2213,3666,40720,1577,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',5000.01,NULL,NULL,1,'2024-06-20 19:50:14','2024-06-20 19:50:14',NULL),(2214,3666,40720,1578,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',63521.79,NULL,NULL,1,'2024-06-20 19:55:05','2024-06-20 19:55:05',NULL),(2215,3666,40720,1575,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',22823.68,NULL,NULL,1,'2024-06-20 20:01:43','2024-08-26 23:51:13','2024-08-26 23:51:13'),(2216,3666,40720,1590,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',50000.00,NULL,NULL,1,'2024-06-20 20:17:19','2024-06-20 20:17:19',NULL),(2217,3666,40720,1590,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',44849.18,NULL,NULL,1,'2024-06-20 20:17:19','2025-06-04 11:16:36','2025-06-04 11:16:36'),(2218,3666,40720,1590,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',30000.05,NULL,NULL,1,'2024-06-20 20:17:20','2024-06-20 20:17:20',NULL),(2219,3666,40720,1590,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',165682.00,NULL,NULL,1,'2024-06-20 20:17:20','2024-06-20 20:17:20',NULL),(2220,3666,40720,1590,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',14999.99,NULL,NULL,1,'2024-06-20 20:17:20','2024-06-20 20:17:20',NULL);
INSERT INTO `balance_libro` VALUES (2221,3666,40720,1578,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',11965.60,NULL,NULL,1,'2024-06-20 20:21:11','2024-06-20 20:21:11',NULL),(2222,3666,40720,1578,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',10877.83,NULL,NULL,1,'2024-06-20 20:21:11','2024-06-20 20:21:11',NULL),(2223,3666,40720,1578,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',8702.27,NULL,NULL,1,'2024-06-20 20:21:11','2024-06-20 20:21:11',NULL),(2224,3666,40720,1578,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',8216.04,NULL,NULL,1,'2024-06-20 20:21:12','2024-06-20 20:21:12',NULL),(2225,3666,40720,1579,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',22660.94,NULL,NULL,1,'2024-06-20 20:30:38','2024-06-20 20:30:38',NULL),(2226,3666,40720,1578,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',46215.86,NULL,NULL,1,'2024-06-21 10:36:26','2024-08-25 21:51:21','2024-08-25 21:51:21'),(2227,3666,40720,1579,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',35664.98,NULL,NULL,1,'2024-06-21 10:41:58','2024-08-25 22:09:14','2024-08-25 22:09:14'),(2228,3666,40720,1580,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',36192.70,NULL,NULL,1,'2024-06-21 10:44:51','2024-08-25 22:33:06','2024-08-25 22:33:06'),(2229,3666,40720,1581,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',19663.91,NULL,NULL,1,'2024-06-21 10:48:07','2024-08-25 22:45:12','2024-08-25 22:45:12'),(2230,3666,40720,1582,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',20514.82,NULL,NULL,1,'2024-06-21 10:50:46','2024-08-26 08:04:28','2024-08-26 08:04:28'),(2231,3666,40720,1583,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',21836.08,NULL,NULL,1,'2024-06-21 10:56:58','2024-08-26 08:53:43','2024-08-26 08:53:43'),(2232,3666,40720,1587,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',27092.96,NULL,NULL,1,'2024-06-21 11:00:35','2024-08-26 10:06:42','2024-08-26 10:06:42'),(2233,3666,40720,1588,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',29927.57,NULL,NULL,1,'2024-06-21 11:03:44','2024-08-26 18:49:34','2024-08-26 18:49:34'),(2234,3666,40720,1589,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',37385.17,NULL,NULL,1,'2024-06-21 11:12:07','2024-08-26 16:39:04','2024-08-26 16:39:04'),(2235,3666,40720,1575,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',942590.00,NULL,NULL,1,'2024-06-21 18:13:19','2024-06-21 18:13:19',NULL),(2236,3666,40720,1575,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',213347.20,NULL,NULL,1,'2024-06-21 18:14:21','2024-06-21 18:14:21',NULL),(2237,3666,40720,1576,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1230669.00,NULL,NULL,1,'2024-06-21 18:14:50','2024-06-21 18:14:50',NULL),(2238,3666,40902,6094,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',9000.00,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL),(2239,3666,40902,6094,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',9000.01,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL),(2240,3666,40902,6094,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',30000.00,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL);
INSERT INTO `balance_libro` VALUES (2241,3666,40902,6094,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',9450.00,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL),(2242,3666,40902,6094,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',315800.01,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL),(2243,3666,40902,6094,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',25922.47,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL),(2244,3666,40902,6094,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',17200.00,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL),(2245,3666,40902,6094,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',362810.15,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL),(2246,3666,40902,6094,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',25200.00,NULL,NULL,1,'2024-06-21 19:28:54','2024-06-21 19:28:54',NULL),(2247,3666,40902,6094,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',13639.50,NULL,NULL,1,'2024-06-21 19:28:55','2024-06-21 19:28:55',NULL),(2248,3666,40902,6094,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-25','2024-05-25',30773.21,NULL,NULL,1,'2024-06-21 19:28:55','2024-06-21 19:28:55',NULL),(2249,3666,40902,6094,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',437604.00,NULL,NULL,1,'2024-06-21 19:28:55','2024-06-21 19:28:55',NULL),(2250,3666,40902,6094,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',60863.00,NULL,NULL,1,'2024-06-21 19:28:55','2024-06-21 19:28:55',NULL),(2251,3666,40902,6094,3,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',20000.00,NULL,NULL,1,'2024-06-21 19:28:55','2024-06-21 19:28:55',NULL),(2252,3666,40902,6094,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2600.00,NULL,NULL,1,'2024-06-21 19:28:55','2024-06-21 19:28:55',NULL),(2253,3666,40902,6094,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',368686.13,NULL,NULL,1,'2024-06-21 19:28:55','2024-06-21 19:28:55',NULL),(2254,3666,40902,6094,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',8608.31,NULL,NULL,1,'2024-06-21 20:01:32','2024-06-21 20:01:32',NULL),(2255,3666,40902,6094,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',48267.82,NULL,NULL,1,'2024-06-21 20:04:34','2024-06-21 20:04:34',NULL),(2256,3666,40902,6094,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',69999.99,NULL,NULL,1,'2024-06-21 20:12:37','2024-06-21 20:45:36','2024-06-21 20:45:36'),(2257,3666,40902,6094,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',69999.99,NULL,NULL,1,'2024-06-21 20:15:30','2024-06-21 20:45:20','2024-06-21 20:45:20'),(2258,3666,40902,6094,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',69999.99,NULL,NULL,1,'2024-06-21 20:19:31','2024-06-21 20:44:48','2024-06-21 20:44:48'),(2259,3666,40902,6094,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',150000.02,NULL,NULL,1,'2024-06-21 20:23:20','2024-06-21 20:44:37','2024-06-21 20:44:37'),(2260,3666,40902,6094,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',80000.02,NULL,NULL,1,'2024-06-21 20:26:00','2024-06-21 20:44:22','2024-06-21 20:44:22');
INSERT INTO `balance_libro` VALUES (2261,3666,40902,6094,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',69999.99,NULL,NULL,1,'2024-06-21 20:28:01','2024-06-21 20:44:10','2024-06-21 20:44:10'),(2262,3666,40902,6094,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',87999.96,NULL,NULL,1,'2024-06-21 20:30:12','2024-06-21 20:43:58','2024-06-21 20:43:58'),(2263,3666,40902,6094,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',69999.94,NULL,NULL,1,'2024-06-21 20:32:50','2024-06-21 20:43:32','2024-06-21 20:43:32'),(2264,3666,40902,6094,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',489245.76,NULL,NULL,1,'2024-06-21 20:47:31','2024-06-21 20:47:31',NULL),(2265,3666,40902,6094,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',6398480.00,NULL,NULL,1,'2024-06-21 20:47:31','2024-06-21 20:47:31',NULL),(2266,3666,40902,6095,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',41025.84,NULL,NULL,1,'2024-06-21 21:43:33','2024-06-21 21:43:33',NULL),(2267,3666,40720,1575,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',150000.00,NULL,NULL,1,'2024-06-25 21:29:18','2024-06-25 21:29:18',NULL),(2268,3666,40720,1575,20,1752,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1752,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',35747.00,NULL,NULL,1,'2024-07-23 20:50:48','2024-07-23 20:54:52','2024-07-23 20:54:52'),(2269,3666,40720,1575,20,1753,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1753,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',35747.00,NULL,NULL,1,'2024-07-23 20:56:08','2024-07-23 20:56:08',NULL),(2270,3666,40720,1575,20,1754,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1754,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',35747.00,NULL,NULL,1,'2024-07-23 21:08:07','2024-07-23 21:08:52','2024-07-23 21:08:52'),(2271,3666,40720,1577,20,1755,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1755,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',35747.00,NULL,NULL,1,'2024-07-23 21:09:37','2024-07-23 21:09:37',NULL),(2272,3666,40720,1578,20,1756,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1756,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',35747.00,NULL,NULL,1,'2024-07-23 21:11:16','2024-07-23 21:11:16',NULL),(2273,3666,40720,1579,20,1757,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1757,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',35747.00,NULL,NULL,1,'2024-07-23 21:12:54','2024-07-23 21:12:54',NULL),(2274,3666,40720,1580,20,1758,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1758,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',35747.00,NULL,NULL,1,'2024-07-23 21:14:44','2024-07-23 21:14:44',NULL),(2275,3666,40720,1587,20,1759,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1759,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',302500.00,NULL,NULL,1,'2024-07-23 21:23:34','2024-07-23 21:24:00','2024-07-23 21:24:00'),(2276,3666,40720,1588,20,1760,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1760,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',302500.00,NULL,NULL,1,'2024-07-23 21:25:06','2024-07-23 21:25:06',NULL),(2277,3666,40720,1588,20,1761,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1761,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',72858.94,NULL,NULL,1,'2024-07-23 21:26:12','2024-07-23 21:26:12',NULL),(2278,3666,40720,1589,20,1762,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1762,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',72858.94,NULL,NULL,1,'2024-07-23 21:54:22','2024-07-23 21:54:22',NULL),(2279,3666,40720,1575,20,1763,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1763,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',59048.00,NULL,NULL,1,'2024-07-24 16:47:40','2024-07-24 16:47:40',NULL),(2280,3666,40720,1575,20,1764,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1764,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',40000.00,NULL,NULL,1,'2024-07-24 16:55:32','2024-07-24 16:55:32',NULL);
INSERT INTO `balance_libro` VALUES (2281,3666,40720,1575,20,1765,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1765,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',34560.00,NULL,NULL,1,'2024-07-24 16:57:02','2024-07-24 16:57:02',NULL),(2282,3666,40720,1575,20,1766,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1766,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',34560.00,NULL,NULL,1,'2024-07-24 16:58:14','2024-07-24 16:58:14',NULL),(2283,3666,40720,1575,20,1767,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1767,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',43200.00,NULL,NULL,1,'2024-07-24 17:16:38','2024-07-24 17:16:38',NULL),(2284,3666,40720,1575,21,1768,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1768,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',15000.00,NULL,NULL,1,'2024-07-24 17:46:17','2024-07-24 17:46:17',NULL),(2285,3666,40720,1575,21,1769,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1769,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',20191.83,NULL,NULL,1,'2024-07-24 18:02:08','2024-08-12 18:07:10','2024-08-12 18:07:10'),(2286,3666,40720,1575,22,2286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',15831.42,'DEBITOS BANCARIOS',NULL,1,'2024-07-24 18:15:44','2024-07-24 18:18:15','2024-07-24 18:18:15'),(2287,3666,40720,1575,22,2287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',15830.42,'DEBITOS BANCARIOS',NULL,1,'2024-07-24 18:18:15','2024-07-24 18:18:15',NULL),(2288,3666,40720,1575,21,1770,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1770,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',225000.00,NULL,NULL,1,'2024-07-24 18:31:01','2024-07-24 18:31:01',NULL),(2289,3666,40720,1576,20,1771,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1771,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',40000.00,NULL,NULL,1,'2024-07-24 18:33:40','2024-07-24 18:33:40',NULL),(2290,3666,40720,1576,20,1772,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1772,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',59048.00,NULL,NULL,1,'2024-07-24 18:35:30','2024-07-24 18:35:30',NULL),(2291,3666,40720,1576,20,1773,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1773,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',34560.00,NULL,NULL,1,'2024-07-24 18:44:38','2024-07-24 18:44:38',NULL),(2292,3666,40720,1576,22,2292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',13599.39,'DEBITOS BANCARIOS 05-2023',NULL,1,'2024-07-24 18:48:22','2024-07-24 18:48:22',NULL),(2293,3666,40720,1576,22,2293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',495000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-24 18:49:36','2024-07-24 18:49:36',NULL),(2294,3666,40720,1592,22,2294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',529785.62,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-24 19:03:24','2024-07-24 19:36:45','2024-07-24 19:36:45'),(2295,3666,40720,1577,20,1774,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1774,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',40000.00,NULL,NULL,1,'2024-07-24 19:10:42','2024-07-24 19:10:42',NULL),(2296,3666,40720,1577,20,1775,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1775,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',34560.00,NULL,NULL,1,'2024-07-24 19:12:24','2024-07-24 19:12:24',NULL),(2297,3666,40720,1577,20,1776,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1776,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',59048.00,NULL,NULL,1,'2024-07-24 19:15:49','2024-07-24 19:15:49',NULL),(2298,3666,40720,1577,20,1777,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1777,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',43200.00,NULL,NULL,1,'2024-07-24 19:18:34','2024-07-24 19:18:34',NULL),(2299,3666,40720,1577,22,2299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',500000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-24 19:20:45','2024-07-24 19:20:45',NULL);
INSERT INTO `balance_libro` VALUES (2300,3666,40720,1577,22,2300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',13785.06,'DEBITOS BANCARIOS 06-2023',NULL,1,'2024-07-24 19:23:22','2024-07-24 19:23:22',NULL),(2301,3666,40720,1577,22,2301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',529785.62,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-24 19:36:45','2024-07-24 19:36:45',NULL),(2302,3666,40720,1578,20,1778,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1778,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',59048.00,NULL,NULL,1,'2024-07-24 19:41:48','2024-07-24 19:41:48',NULL),(2303,3666,40720,1578,20,1779,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1779,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',25000.00,NULL,NULL,1,'2024-07-24 20:19:32','2024-07-24 20:19:32',NULL),(2304,3666,40720,1578,20,1780,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1780,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',54000.00,NULL,NULL,1,'2024-07-24 20:20:26','2024-07-24 20:20:26',NULL),(2305,3666,40720,1578,20,1781,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1781,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',20000.00,NULL,NULL,1,'2024-07-24 20:21:21','2024-07-24 20:21:21',NULL),(2306,3666,40720,1578,22,2306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',536986.30,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-24 20:25:51','2024-07-24 20:25:51',NULL),(2307,3666,40720,1578,22,2307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',22962.57,'DEBITOS BANCARIOS 07-2023',NULL,1,'2024-07-24 20:28:56','2024-07-24 20:28:56',NULL),(2308,3666,40720,1578,21,1782,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1782,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',386749.65,NULL,NULL,1,'2024-07-24 20:33:15','2024-07-24 20:33:15',NULL),(2309,3666,40720,1578,21,1783,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1783,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',21300.00,NULL,NULL,1,'2024-07-24 20:34:15','2024-07-24 20:34:15',NULL),(2310,3666,40720,1578,21,1784,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1784,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',21300.00,NULL,NULL,1,'2024-07-24 20:47:26','2024-07-24 20:47:26',NULL),(2311,3666,40720,1578,21,1785,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1785,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',451976.02,NULL,NULL,1,'2024-07-24 20:48:23','2024-07-24 20:48:23',NULL),(2312,3666,40720,1578,21,1786,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1786,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',18000.00,NULL,NULL,1,'2024-07-24 20:51:29','2024-07-24 20:51:29',NULL),(2313,3666,40720,1579,20,1787,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1787,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',4200.00,NULL,NULL,1,'2024-07-25 18:51:50','2024-07-25 18:51:50',NULL),(2314,3666,40720,1579,20,1788,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1788,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',54000.00,NULL,NULL,1,'2024-07-25 18:59:17','2024-07-25 18:59:17',NULL),(2315,3666,40720,1579,20,1789,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1789,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',59048.00,NULL,NULL,1,'2024-07-25 19:00:23','2024-07-25 19:00:23',NULL),(2316,3666,40720,1579,20,1790,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1790,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',51840.00,NULL,NULL,1,'2024-07-25 19:02:12','2024-07-25 19:02:12',NULL),(2317,3666,40720,1579,20,1791,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1791,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',41472.00,NULL,NULL,1,'2024-07-25 19:04:25','2024-07-25 19:04:25',NULL),(2318,3666,40720,1579,22,2318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',17450.26,'DEBITOS BANCARIOS 08-2023',NULL,1,'2024-07-25 19:08:13','2024-07-25 19:08:13',NULL);
INSERT INTO `balance_libro` VALUES (2319,3666,40720,1579,20,1792,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1792,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',41472.00,NULL,NULL,1,'2024-07-25 19:11:27','2024-07-25 19:11:27',NULL),(2320,3666,40720,1580,20,1793,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1793,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',31460.00,NULL,NULL,1,'2024-07-25 19:16:11','2024-07-25 19:16:11',NULL),(2321,3666,40720,1580,20,1794,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1794,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',51840.00,NULL,NULL,1,'2024-07-25 19:20:11','2024-07-25 19:20:11',NULL),(2322,3666,40720,1580,20,1795,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1795,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',54000.00,NULL,NULL,1,'2024-07-25 19:24:05','2024-07-25 19:24:05',NULL),(2323,3666,40720,1580,20,1796,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1796,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',59048.00,NULL,NULL,1,'2024-07-25 19:25:24','2024-07-25 19:25:24',NULL),(2324,3666,40720,1580,21,1797,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1797,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',12000.00,NULL,NULL,1,'2024-07-25 19:34:07','2024-07-25 19:34:07',NULL),(2325,3666,40720,1580,22,2325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',163000.00,'COBRO CHQUE N° 741582',NULL,1,'2024-07-25 19:51:25','2024-07-25 19:51:25',NULL),(2326,3666,40720,1580,22,2326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',18329.73,'DEBITOS BANCARIOS 09-2023',NULL,1,'2024-07-25 19:53:14','2024-07-25 19:53:14',NULL),(2327,3666,40720,1580,22,2327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',349105.80,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-25 19:54:25','2024-07-25 19:54:25',NULL),(2328,3666,40720,1581,20,1798,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1798,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',59048.00,NULL,NULL,1,'2024-07-25 19:57:28','2024-07-25 19:57:28',NULL),(2329,3666,40720,1581,20,1799,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1799,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',41472.00,NULL,NULL,1,'2024-07-25 20:58:57','2024-07-25 20:58:57',NULL),(2330,3666,40720,1581,22,2330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',106773.00,'DEPOSITO CHEQUE 535979',NULL,1,'2024-07-25 21:00:35','2024-07-25 21:00:35',NULL),(2331,3666,40720,1581,22,2331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',6618.37,'DEBITOS BANCARIOS 10-2023',NULL,1,'2024-07-25 21:02:00','2024-07-25 21:02:00',NULL),(2332,3666,40720,1582,22,2332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',436493.15,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-26 09:56:25','2024-07-26 09:56:25',NULL),(2333,3666,40720,1582,20,1800,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1800,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',51840.00,NULL,NULL,1,'2024-07-26 10:16:22','2024-07-26 10:16:22',NULL),(2334,3666,40720,1582,20,1801,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1801,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',41472.00,NULL,NULL,1,'2024-07-26 10:18:04','2024-07-26 10:18:04',NULL),(2335,3666,40720,1582,20,1802,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1802,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',31460.00,NULL,NULL,1,'2024-07-26 10:18:55','2024-07-26 10:18:55',NULL),(2336,3666,40720,1582,20,1803,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1803,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',54000.00,NULL,NULL,1,'2024-07-26 10:20:44','2024-07-26 10:20:44',NULL),(2337,3666,40720,1582,20,1804,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1804,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',59048.00,NULL,NULL,1,'2024-07-26 10:22:57','2024-07-26 10:22:57',NULL);
INSERT INTO `balance_libro` VALUES (2338,3666,40720,1582,22,2338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',636493.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-26 10:27:51','2024-07-26 10:27:51',NULL),(2339,3666,40720,1582,22,2339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',21774.88,'DEBITOS BANCARIOS 11-2023',NULL,1,'2024-07-26 10:29:15','2024-07-26 10:29:15',NULL),(2340,3666,40720,1582,22,2340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',108000.00,'DEPOSITO EN EFECTIVO',NULL,1,'2024-07-26 10:30:19','2024-07-26 10:30:19',NULL),(2341,3666,40720,1583,20,1805,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1805,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',338350.00,NULL,NULL,1,'2024-07-29 10:07:06','2024-07-29 10:07:06',NULL),(2342,3666,40720,1583,22,2342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',706803.68,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-29 16:36:22','2024-07-29 16:36:22',NULL),(2343,3666,40720,1583,22,2343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',14166670.00,'PRESTAMO CONINAGRO',NULL,1,'2024-07-29 16:43:04','2024-07-29 16:43:04',NULL),(2344,3666,40720,1583,20,1806,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1806,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',41472.00,NULL,NULL,1,'2024-07-29 16:52:08','2024-07-29 16:52:08',NULL),(2345,3666,40720,1583,20,1807,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1807,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',41472.00,NULL,NULL,1,'2024-07-29 16:54:02','2024-07-29 16:54:02',NULL),(2346,3666,40720,1583,20,1808,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1808,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',59048.00,NULL,NULL,1,'2024-07-29 16:54:52','2024-07-29 16:54:52',NULL),(2347,3666,40720,1583,21,1809,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1809,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',25000.00,NULL,NULL,1,'2024-07-29 17:44:49','2024-07-29 17:44:49',NULL),(2348,3666,40720,1583,22,2348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',5000000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-29 17:46:24','2024-07-29 17:46:24',NULL),(2349,3666,40720,1583,22,2349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',5000000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-29 17:47:06','2024-07-29 17:47:06',NULL),(2350,3666,40720,1583,22,2350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',4166670.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-29 17:47:56','2024-07-29 17:47:56',NULL),(2351,3666,40720,1583,21,1810,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1810,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',331364.00,NULL,NULL,1,'2024-07-29 17:54:05','2024-07-29 17:54:05',NULL),(2352,3666,40720,1583,22,2352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',468742.30,'DEBITOS BANCARIOS 12-2023',NULL,1,'2024-07-29 17:57:49','2024-07-29 17:57:49',NULL),(2353,3666,40720,1583,22,2353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',710000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-29 18:02:17','2024-07-29 18:02:17',NULL),(2354,3666,40720,1587,22,2354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',4598177.19,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-29 18:12:14','2024-07-29 18:12:14',NULL),(2355,3666,40720,1587,22,2355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',5517808.22,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-29 18:14:50','2024-07-29 18:14:50',NULL);
INSERT INTO `balance_libro` VALUES (2356,3666,40720,1587,22,2356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',5517808.22,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-29 18:19:03','2024-07-29 18:19:03',NULL),(2357,3666,40720,1587,22,2357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',783528.77,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-29 18:23:29','2024-07-29 18:23:29',NULL),(2358,3666,40720,1587,20,1811,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1811,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',136817.12,NULL,NULL,1,'2024-07-29 18:31:24','2024-07-29 18:31:24',NULL),(2359,3666,40720,1587,20,1812,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1812,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',279920.96,NULL,NULL,1,'2024-07-29 18:40:52','2024-08-26 09:41:41','2024-08-26 09:41:41'),(2360,3666,40720,1587,20,1813,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1813,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',46862.90,NULL,NULL,1,'2024-07-29 18:44:19','2024-08-26 09:42:18','2024-08-26 09:42:18'),(2361,3666,40720,1587,20,1814,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1814,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',82944.00,NULL,NULL,1,'2024-07-29 18:55:50','2024-07-29 18:55:50',NULL),(2362,3666,40720,1587,21,1815,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1815,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',9500.00,NULL,NULL,1,'2024-07-29 19:00:51','2024-07-29 19:00:51',NULL),(2363,3666,40720,1587,22,2363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',5500000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-29 19:01:49','2024-07-29 19:01:49',NULL),(2364,3666,40720,1587,22,2364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',5500000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-29 19:02:36','2024-07-29 19:02:36',NULL),(2365,3666,40720,1587,22,2365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',4500000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-29 19:03:12','2024-07-29 19:03:12',NULL),(2366,3666,40720,1587,22,2366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',39544.18,'DEBITOS BANCARIOS 01-2024',NULL,1,'2024-07-29 19:06:00','2024-07-29 19:14:04','2024-07-29 19:14:04'),(2367,3666,40720,1587,22,2367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',39543.18,'DEBITOS BANCARIOS 01-2024',NULL,1,'2024-07-29 19:14:04','2024-07-29 19:21:34','2024-07-29 19:21:34'),(2368,3666,40720,1587,22,2368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',160000.00,'COBRO CHQUE N° 741585',NULL,1,'2024-07-29 19:15:58','2024-07-29 19:15:58',NULL),(2369,3666,40720,1587,22,2369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',39545.18,'DEBITOS BANCARIOS 01-2024',NULL,1,'2024-07-29 19:21:34','2024-07-29 19:21:34',NULL),(2370,3666,40720,1588,20,1816,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1816,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',31460.00,NULL,NULL,1,'2024-07-30 18:23:13','2024-07-30 18:23:13',NULL),(2371,3666,40720,1588,22,2371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',4920410.96,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-30 18:28:43','2024-07-30 18:28:43',NULL),(2372,3666,40720,1588,22,2372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',6013835.62,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-30 18:29:49','2024-07-30 18:29:49',NULL),(2373,3666,40720,1588,22,2373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',6013835.62,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-30 18:31:12','2024-07-30 18:31:12',NULL);
INSERT INTO `balance_libro` VALUES (2374,3666,40720,1588,20,1817,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1817,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',45374.26,NULL,NULL,1,'2024-07-30 18:36:54','2024-08-26 18:56:02','2024-08-26 18:56:02'),(2375,3666,40720,1588,20,1818,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1818,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',2918.52,NULL,NULL,1,'2024-07-30 18:38:46','2024-07-30 18:38:46',NULL),(2376,3666,40720,1588,20,1819,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1819,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',82944.00,NULL,NULL,1,'2024-07-30 18:41:12','2024-07-30 18:41:12',NULL),(2377,3666,40720,1588,20,1820,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1820,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',31500.00,NULL,NULL,1,'2024-07-30 18:54:11','2024-07-30 18:54:11',NULL),(2378,3666,40720,1588,20,1821,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1821,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',31500.00,NULL,NULL,1,'2024-07-30 18:54:51','2024-07-30 18:54:51',NULL),(2379,3666,40720,1588,20,1822,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1822,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',31500.00,NULL,NULL,1,'2024-07-30 18:55:32','2024-07-30 18:55:32',NULL),(2380,3666,40720,1588,20,1823,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1823,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',51840.00,NULL,NULL,1,'2024-07-30 18:56:38','2024-07-30 18:56:38',NULL),(2381,3666,40720,1588,20,1824,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1824,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',41817.60,NULL,NULL,1,'2024-07-30 18:58:36','2024-07-30 18:58:36',NULL),(2382,3666,40720,1588,20,1825,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1825,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',48400.00,NULL,NULL,1,'2024-07-30 18:59:52','2024-07-30 18:59:52',NULL),(2383,3666,40720,1588,20,1826,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1826,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',48400.00,NULL,NULL,1,'2024-07-30 19:00:16','2024-07-30 19:00:16',NULL),(2384,3666,40720,1588,20,1827,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1827,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',41817.60,NULL,NULL,1,'2024-07-30 19:01:06','2024-07-30 19:08:05','2024-07-30 19:08:05'),(2385,3666,40720,1588,20,1828,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1828,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',41817.00,NULL,NULL,1,'2024-07-30 19:09:28','2024-07-30 19:09:28',NULL),(2386,3666,40720,1588,20,1829,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1829,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',7000.00,NULL,NULL,1,'2024-07-30 19:16:29','2024-07-30 19:16:29',NULL),(2387,3666,40720,1588,21,2387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',2086632.44,'CUOTA 1 PRESTAMO CONINAGRO',NULL,1,'2024-07-30 20:26:05','2024-07-30 20:26:05',NULL),(2388,3666,40720,1588,21,2388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',14166670.00,'TRANSF PRESTAMO CONINAGRO COOP JARD AMERICA',NULL,1,'2024-07-30 20:34:25','2024-07-30 20:34:25',NULL),(2389,3666,40720,1588,22,2389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',1200000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-30 20:35:20','2024-07-30 20:35:20',NULL),(2390,3666,40720,1588,21,2390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',70000.00,'HONORARIOS NESTOR ACUÑA',NULL,1,'2024-07-30 20:44:19','2024-07-30 20:44:19',NULL),(2391,3666,40720,1588,22,2391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',157804.12,'DEBITOS BANCARIOS 02-2024',NULL,1,'2024-07-30 20:48:09','2024-07-30 20:48:09',NULL),(2392,3666,40720,1588,10,2392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',7306.74,'PAGO FONDO PROMOCION COOPERATIVA',NULL,1,'2024-07-30 21:12:26','2024-07-30 21:12:26',NULL);
INSERT INTO `balance_libro` VALUES (2393,3666,40720,1589,22,2393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',1308493.15,'ACREDITACION PLAZO FIJO',NULL,1,'2024-07-31 18:23:25','2024-07-31 18:23:25',NULL),(2394,3666,40720,1589,22,2394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',1708493.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2024-07-31 18:25:48','2024-07-31 18:25:48',NULL),(2395,3666,40720,1589,20,1830,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1830,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',45793.66,NULL,NULL,1,'2024-07-31 18:46:09','2024-07-31 18:46:09',NULL),(2396,3666,40720,1589,20,1831,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1831,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',62208.00,NULL,NULL,1,'2024-08-01 17:07:47','2024-08-01 17:07:47',NULL),(2397,3666,40720,1589,20,1832,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1832,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',62208.00,NULL,NULL,1,'2024-08-01 17:09:10','2024-08-01 17:09:10',NULL),(2398,3666,40720,1589,20,1833,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1833,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',31460.00,NULL,NULL,1,'2024-08-01 17:10:17','2024-08-01 17:10:17',NULL),(2399,3666,40720,1589,20,1834,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1834,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',16051.86,NULL,NULL,1,'2024-08-01 17:13:23','2024-08-01 17:13:23',NULL),(2400,3666,40720,1589,20,1835,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1835,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',87120.00,NULL,NULL,1,'2024-08-01 17:16:06','2024-08-01 17:16:06',NULL),(2401,3666,40720,1589,20,1836,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1836,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',225000.00,NULL,NULL,1,'2024-08-01 17:18:46','2024-08-01 17:18:46',NULL),(2402,3666,40720,1589,20,1837,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1837,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',41817.60,NULL,NULL,1,'2024-08-01 17:25:45','2024-08-01 17:25:45',NULL),(2403,3666,40720,1589,22,434,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,434,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',106580.00,NULL,NULL,1,'2024-08-02 19:44:12','2024-08-02 19:45:33','2024-08-02 19:45:33'),(2404,3666,40720,1589,22,435,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,435,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',106580.00,NULL,NULL,1,'2024-08-02 19:46:33','2024-08-02 19:48:08','2024-08-02 19:48:08'),(2405,3666,40720,1589,22,2405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',106580.00,'HONORARIOS MARIO PAYESKA',NULL,1,'2024-08-02 20:09:43','2024-08-02 20:12:51','2024-08-02 20:12:51'),(2406,3666,40720,1589,22,2406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',106580.00,'HONORARIOS GUSTAVO HEIN',NULL,1,'2024-08-02 20:11:02','2024-08-02 20:13:20','2024-08-02 20:13:20'),(2407,3666,40720,1589,21,2407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',106580.00,'HONORARIOS MARIO PAYESKA',NULL,1,'2024-08-02 20:12:51','2024-08-02 20:12:51',NULL),(2408,3666,40720,1589,21,2408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',106580.00,'HONORARIOS GUSTAVO HEIN',NULL,1,'2024-08-02 20:13:20','2024-08-02 20:13:20',NULL),(2409,3666,40720,1589,21,2409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',35000.00,'HONORARIOS NESTOR ACUÑA',NULL,1,'2024-08-02 20:15:45','2024-08-02 20:15:45',NULL),(2410,3666,40720,1589,21,2410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',35000.00,'HONORARIOS ANALIA DIAZ',NULL,1,'2024-08-02 20:17:10','2024-08-02 20:18:04','2024-08-02 20:18:04');
INSERT INTO `balance_libro` VALUES (2411,3666,40720,1589,21,2411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',50000.00,'HONORARIOS ANALIA DIAZ',NULL,1,'2024-08-02 20:18:04','2024-08-02 20:18:04',NULL),(2412,3666,40720,1589,21,2412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',100000.00,'HONORARIOS JOSE CUNALE',NULL,1,'2024-08-02 20:19:57','2024-08-02 20:19:57',NULL),(2413,3666,40720,1589,21,2413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',100000.00,'HONORARIOS MARIO PAYESKA',NULL,1,'2024-08-02 20:33:32','2024-08-02 20:33:32',NULL),(2414,3666,40720,1589,21,2414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',80000.00,'PAGO CHEQUE N° 741586',NULL,1,'2024-08-02 20:37:04','2024-08-02 20:37:04',NULL),(2415,3666,40720,1589,21,2415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',90000.00,'HONORARIOS AIV',NULL,1,'2024-08-02 20:40:41','2024-08-02 20:40:41',NULL),(2416,3666,40720,1589,21,2416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',30792.13,'HONORARIOS AIV',NULL,1,'2024-08-02 20:43:41','2024-08-02 20:43:41',NULL),(2417,3666,40720,1589,21,1838,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1838,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',331364.00,NULL,NULL,1,'2024-08-02 20:45:45','2024-08-02 20:45:45',NULL),(2418,3666,40720,1589,21,2418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',33405.74,'HONORARIOS MARIO PAYESKA',NULL,1,'2024-08-02 20:50:48','2024-08-02 20:50:48',NULL),(2419,3666,40720,1589,21,2419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',33405.74,'HONORARIOS KEVIN KNOTT',NULL,1,'2024-08-02 20:52:34','2024-08-02 20:52:34',NULL),(2420,3666,40720,1589,21,2420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',33405.74,'HONORARIOS MANFREDO SEIFERT',NULL,1,'2024-08-02 20:54:51','2024-08-02 20:54:51',NULL),(2421,3666,40720,1589,22,438,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,438,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',66722.95,NULL,NULL,1,'2024-08-02 21:15:37','2024-08-02 21:15:37',NULL),(2422,3666,40720,1575,2,2422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',370000.00,'ALQUILER CANCHA 04-2023',NULL,1,'2024-08-06 20:59:01','2024-08-12 18:38:45','2024-08-12 18:38:45'),(2423,3666,40720,1575,2,2423,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',40822.00,'ALQUILER DEPTOS 04-2023',NULL,1,'2024-08-06 21:00:30','2024-08-12 18:42:53','2024-08-12 18:42:53'),(2424,3666,40720,1576,2,2424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',370000.00,'ALQUILER CANCHA 05-2023',NULL,1,'2024-08-06 21:01:31','2024-08-12 18:41:34','2024-08-12 18:41:34'),(2425,3666,40720,1576,2,2425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',58308.00,'ALQUILER DEPTOS 05-2023',NULL,1,'2024-08-06 21:02:56','2024-08-12 18:45:53','2024-08-12 18:45:53'),(2426,3666,40720,1577,2,2426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',370000.00,'ALQUILER CANCHA 06-2023',NULL,1,'2024-08-06 21:04:07','2024-08-12 18:46:25','2024-08-12 18:46:25'),(2427,3666,40720,1577,2,2427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',74146.00,'ALQUILER DEPTOS 06-2023',NULL,1,'2024-08-06 21:05:44','2024-08-12 18:47:07','2024-08-12 18:47:07'),(2428,3666,40720,1578,2,2428,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',370000.00,'ALQUILER CANCHA 07-2023',NULL,1,'2024-08-06 21:06:56','2024-08-12 18:47:54','2024-08-12 18:47:54');
INSERT INTO `balance_libro` VALUES (2429,3666,40720,1578,2,2429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',74146.00,'ALQUILER DEPTOS 07-2023',NULL,1,'2024-08-06 21:07:51','2024-08-12 18:48:45','2024-08-12 18:48:45'),(2430,3666,40720,1579,2,2430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',370000.00,'ALQUILER CANCHA 08-2023',NULL,1,'2024-08-06 21:17:44','2024-08-12 18:49:14','2024-08-12 18:49:14'),(2431,3666,40720,1579,2,2431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',74026.00,'ALQUILER DEPTOS 08-2023',NULL,1,'2024-08-06 21:18:56','2024-08-12 18:50:51','2024-08-12 18:50:51'),(2432,3666,40720,1580,2,2432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',370000.00,'ALQUILER CANCHA 09-2023',NULL,1,'2024-08-06 21:19:43','2024-08-12 18:53:11','2024-08-12 18:53:11'),(2433,3666,40720,1580,2,2433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',74026.00,'ALQUILER DEPTOS 09-2023',NULL,1,'2024-08-06 21:20:53','2024-08-12 18:53:49','2024-08-12 18:53:49'),(2434,3666,40720,1581,2,2434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',370000.00,'ALQUILER CANCHA 10-2023',NULL,1,'2024-08-06 21:22:17','2024-08-12 18:54:39','2024-08-12 18:54:39'),(2435,3666,40720,1581,2,2435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',74026.00,'ALQUILER DEPTOS 10-2023',NULL,1,'2024-08-06 21:23:19','2024-08-12 18:55:04','2024-08-12 18:55:04'),(2436,3666,40720,1582,2,2436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',370000.00,'ALQUILER CANCHA 11-2023',NULL,1,'2024-08-06 21:24:23','2024-08-12 18:55:41','2024-08-12 18:55:41'),(2437,3666,40720,1582,2,2437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',93646.00,'ALQUILER DEPTOS 11-2023',NULL,1,'2024-08-06 21:29:26','2024-08-06 21:30:50','2024-08-06 21:30:50'),(2438,3666,40720,1582,2,2438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',74026.00,'ALQUILER DEPTOS 11-2023',NULL,1,'2024-08-06 21:30:50','2024-08-12 18:56:05','2024-08-12 18:56:05'),(2439,3666,40720,1583,2,2439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',370000.00,'ALQUILER CANCHA 12-2023',NULL,1,'2024-08-06 21:31:52','2024-08-12 18:57:01','2024-08-12 18:57:01'),(2440,3666,40720,1583,2,2440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',93646.00,'ALQUILER DEPTOS 12-2023',NULL,1,'2024-08-06 21:34:02','2024-08-12 18:57:32','2024-08-12 18:57:32'),(2441,3666,40720,1587,2,2441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',370000.00,'ALQUILER CANCHA 01-2024',NULL,1,'2024-08-06 21:35:03','2024-08-12 18:58:19','2024-08-12 18:58:19'),(2442,3666,40720,1587,2,2442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',93646.00,'ALQUILER DEPTOS 01-2024',NULL,1,'2024-08-06 21:36:12','2024-08-12 18:59:00','2024-08-12 18:59:00'),(2443,3666,40720,1588,2,2443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',370000.00,'ALQUILER CANCHA 02-2024',NULL,1,'2024-08-06 21:38:22','2024-08-12 19:00:15','2024-08-12 19:00:15'),(2444,3666,40720,1588,2,2444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',370000.00,'ALQUILER DEPTOS 02-2024',NULL,1,'2024-08-06 21:39:14','2024-08-06 21:40:31','2024-08-06 21:40:31'),(2445,3666,40720,1588,2,2445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',93646.00,'ALQUILER DEPTOS 02-2024',NULL,1,'2024-08-06 21:40:31','2024-08-12 19:01:15','2024-08-12 19:01:15');
INSERT INTO `balance_libro` VALUES (2446,3666,40720,1589,2,2446,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',370000.00,'ALQUILER CANCHA 03-2024',NULL,1,'2024-08-06 21:41:26','2024-08-12 19:02:05','2024-08-12 19:02:05'),(2447,3666,40720,1589,2,2447,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',93646.00,'ALQUILER DEPTOS 03-2024',NULL,1,'2024-08-06 21:42:12','2024-08-12 19:03:00','2024-08-12 19:03:00'),(2448,3666,40720,1575,21,2448,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',20191.83,'PAGO CARGAS SOCIALES AFIP',NULL,1,'2024-08-12 18:11:24','2024-08-12 18:11:24',NULL),(2449,3666,40720,1575,3,2449,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',119176.59,NULL,NULL,1,'2024-08-12 18:15:56','2024-08-12 18:17:20','2024-08-12 18:17:20'),(2450,3666,40720,1575,3,2450,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',119176.59,'GASTOS VS 04-2023',NULL,1,'2024-08-12 18:17:20','2024-08-12 18:17:20',NULL),(2451,3666,40720,1576,3,2451,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',68025.66,'GASTOS VS 05-2023',NULL,1,'2024-08-12 18:18:49','2024-08-12 18:18:49',NULL),(2452,3666,40720,1577,3,2452,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',16002.27,'GASTOS VS 06-2023',NULL,1,'2024-08-12 18:21:05','2024-08-12 18:21:05',NULL),(2453,3666,40720,1578,3,2453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',301084.89,'GASTOS VS 07-2023',NULL,1,'2024-08-12 18:22:19','2024-08-12 18:22:19',NULL),(2454,3666,40720,1579,3,2454,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',191382.72,'GASTOS VS 08-2023',NULL,1,'2024-08-12 18:23:49','2024-08-12 18:23:49',NULL),(2455,3666,40720,1580,3,2455,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',275920.00,'HONORARIOS 09-2023',NULL,1,'2024-08-12 18:32:55','2024-08-12 18:32:55',NULL),(2456,3666,40720,1580,3,2456,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',278348.91,'GASTOS VS 09-2023',NULL,1,'2024-08-12 18:35:20','2024-08-12 18:35:20',NULL),(2457,3666,40720,1575,2,2457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',370000.00,'ALQUILER CANCHA 04-2023',NULL,1,'2024-08-12 18:38:45','2024-08-12 18:38:45',NULL),(2458,3666,40720,1576,2,2458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',370000.00,'ALQUILER CANCHA 05-2023',NULL,1,'2024-08-12 18:41:34','2024-08-12 18:41:34',NULL),(2459,3666,40720,1575,2,2459,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',40822.00,'ALQUILER DEPTOS 04-2023',NULL,1,'2024-08-12 18:42:53','2024-08-12 18:42:53',NULL),(2460,3666,40720,1576,2,2460,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',58308.00,'ALQUILER DEPTOS 05-2023',NULL,1,'2024-08-12 18:45:53','2024-08-12 18:45:53',NULL),(2461,3666,40720,1577,2,2461,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',370000.00,'ALQUILER CANCHA 06-2023',NULL,1,'2024-08-12 18:46:25','2024-08-12 18:46:25',NULL),(2462,3666,40720,1577,2,2462,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',74146.00,'ALQUILER DEPTOS 06-2023',NULL,1,'2024-08-12 18:47:07','2024-08-12 18:47:07',NULL),(2463,3666,40720,1578,2,2463,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',370000.00,'ALQUILER CANCHA 07-2023',NULL,1,'2024-08-12 18:47:54','2024-08-12 18:47:54',NULL);
INSERT INTO `balance_libro` VALUES (2464,3666,40720,1578,2,2464,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',74146.00,'ALQUILER DEPTOS 07-2023',NULL,1,'2024-08-12 18:48:45','2024-08-12 18:48:45',NULL),(2465,3666,40720,1579,2,2465,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',370000.00,'ALQUILER CANCHA 08-2023',NULL,1,'2024-08-12 18:49:14','2024-08-12 18:49:14',NULL),(2466,3666,40720,1579,2,2466,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',74026.00,'ALQUILER DEPTOS 08-2023',NULL,1,'2024-08-12 18:50:51','2024-08-12 18:50:51',NULL),(2467,3666,40720,1580,2,2467,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',370000.00,'ALQUILER CANCHA 09-2023',NULL,1,'2024-08-12 18:53:11','2024-08-12 18:53:11',NULL),(2468,3666,40720,1580,2,2468,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',74026.00,'ALQUILER DEPTOS 09-2023',NULL,1,'2024-08-12 18:53:49','2024-08-12 18:53:49',NULL),(2469,3666,40720,1581,2,2469,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',370000.00,'ALQUILER CANCHA 10-2023',NULL,1,'2024-08-12 18:54:39','2024-08-12 18:54:39',NULL),(2470,3666,40720,1581,2,2470,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',74026.00,'ALQUILER DEPTOS 10-2023',NULL,1,'2024-08-12 18:55:04','2024-08-12 18:55:04',NULL),(2471,3666,40720,1582,2,2471,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',370000.00,'ALQUILER CANCHA 11-2023',NULL,1,'2024-08-12 18:55:41','2024-08-12 18:55:41',NULL),(2472,3666,40720,1582,2,2472,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',74026.00,'ALQUILER DEPTOS 11-2023',NULL,1,'2024-08-12 18:56:05','2024-08-12 18:56:05',NULL),(2473,3666,40720,1583,2,2473,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',370000.00,'ALQUILER CANCHA 12-2023',NULL,1,'2024-08-12 18:57:01','2024-08-12 18:57:01',NULL),(2474,3666,40720,1583,2,2474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',93646.00,'ALQUILER DEPTOS 12-2023',NULL,1,'2024-08-12 18:57:32','2024-08-12 18:57:32',NULL),(2475,3666,40720,1587,2,2475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',370000.00,'ALQUILER CANCHA 01-2024',NULL,1,'2024-08-12 18:58:19','2024-08-12 18:58:19',NULL),(2476,3666,40720,1587,2,2476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',93646.00,'ALQUILER DEPTOS 01-2024',NULL,1,'2024-08-12 18:59:00','2024-08-12 18:59:00',NULL),(2477,3666,40720,1588,2,2477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',370000.00,'ALQUILER CANCHA 02-2024',NULL,1,'2024-08-12 19:00:15','2024-08-12 19:00:15',NULL),(2478,3666,40720,1588,2,2478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',93646.00,'ALQUILER DEPTOS 02-2024',NULL,1,'2024-08-12 19:01:15','2024-08-12 19:01:15',NULL),(2479,3666,40720,1589,2,2479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',370000.00,'ALQUILER CANCHA 03-2024',NULL,1,'2024-08-12 19:02:05','2024-08-12 19:02:05',NULL),(2480,3666,40720,1589,2,2480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',93646.00,'ALQUILER DEPTOS 03-2024',NULL,1,'2024-08-12 19:03:00','2024-08-12 19:03:00',NULL),(2481,3666,40720,1581,3,2481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',55405.80,'GASTOS VS 10-2023',NULL,1,'2024-08-12 19:16:24','2024-08-12 19:16:24',NULL);
INSERT INTO `balance_libro` VALUES (2482,3666,40720,1582,3,2482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',464800.00,'HONORARIOS 11-2023',NULL,1,'2024-08-12 19:18:21','2024-08-12 19:21:04','2024-08-12 19:21:04'),(2483,3666,40720,1582,3,2483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',197117.11,'GASTOS VS 11-2023',NULL,1,'2024-08-12 19:19:36','2024-08-12 19:19:36',NULL),(2484,3666,40720,1582,3,2484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',464800.00,'HONORARIOS 11-2023',NULL,1,'2024-08-12 19:21:04','2024-08-12 19:21:04',NULL),(2485,3666,40720,1583,3,2485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',570283.40,'GASTOS VS 12-2023',NULL,1,'2024-08-12 19:25:02','2024-08-12 19:25:02',NULL),(2486,3666,40720,1587,3,2486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',34107.08,'GASTOS VS 01-2024',NULL,1,'2024-08-12 19:26:24','2024-08-12 19:26:24',NULL),(2487,3666,40720,1588,3,2487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',244452.80,'GASTOS VS 02-2024',NULL,1,'2024-08-12 19:27:29','2024-08-12 19:27:29',NULL),(2488,3666,40720,1589,3,2488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',342603.67,'GASTOS VS 03-2024',NULL,1,'2024-08-12 19:29:06','2024-08-12 19:29:06',NULL),(2489,3666,40720,1575,2,2489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',213347.20,'VENTA U$S 450,10 A $474',NULL,1,'2024-08-13 19:24:16','2024-08-27 18:39:29','2024-08-27 18:39:29'),(2490,3666,40720,1575,2,2490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',942590.00,'VENTA U$S 1988,59 A $474',NULL,1,'2024-08-13 19:27:08','2024-08-27 18:41:18','2024-08-27 18:41:18'),(2491,3666,40720,1576,2,2491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1230669.00,'VENTA U$S 2496,29 A $493',NULL,1,'2024-08-13 19:30:27','2024-08-27 18:42:47','2024-08-27 18:42:47'),(2492,3666,40720,1577,2,2492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',626291.69,'VENTA U$S 1265,24 A $495',NULL,1,'2024-08-13 19:38:01','2024-08-27 18:44:33','2024-08-27 18:44:33'),(2493,3666,40720,1577,2,2493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',704708.35,'VENTA U$S 1423,65 A $495',NULL,1,'2024-08-13 19:39:50','2024-08-27 18:46:02','2024-08-27 18:46:02'),(2494,3666,40720,1578,2,2494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',885014.57,'VENTA U$S 1187,94 A $745',NULL,1,'2024-08-13 19:58:34','2024-08-27 18:48:15','2024-08-27 18:48:15'),(2495,3666,40720,1578,2,2495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',383635.00,'VENTA U$S 514,95 A $745',NULL,1,'2024-08-13 20:00:13','2024-08-27 18:49:47','2024-08-27 18:49:47'),(2496,3666,40720,1579,2,2496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',636435.00,'VENTA U$S 848,58 A $750',NULL,1,'2024-08-13 20:02:13','2024-08-27 18:51:17','2024-08-27 18:51:17'),(2497,3666,40720,1575,21,1839,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1839,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',1155937.20,NULL,NULL,1,'2024-08-13 20:12:16','2024-08-13 20:12:16',NULL),(2498,3666,40720,1576,21,1840,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1840,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1230669.00,NULL,NULL,1,'2024-08-13 20:15:08','2024-08-13 20:15:08',NULL),(2499,3666,40720,1577,21,1841,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1841,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',1331000.04,NULL,NULL,1,'2024-08-13 20:17:15','2024-10-17 11:24:39','2024-10-17 11:24:39');
INSERT INTO `balance_libro` VALUES (2500,3666,40720,1578,21,1842,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1842,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',1268649.57,NULL,NULL,1,'2024-08-13 20:20:18','2024-10-17 11:24:46','2024-10-17 11:24:46'),(2501,3666,40720,1579,21,1843,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1843,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',636438.63,NULL,NULL,1,'2024-08-13 20:21:29','2024-10-17 11:24:50','2024-10-17 11:24:50'),(2502,3666,40720,1575,16,934,'App\\Models\\PeriodLiquidation',NULL,934,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',4265588.44,NULL,NULL,1,'2024-08-25 10:53:10','2024-08-25 11:27:58','2024-08-25 11:27:58'),(2503,3666,40720,1575,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',22651.32,NULL,NULL,1,'2024-08-25 11:29:59','2024-08-25 11:43:11','2024-08-25 11:43:11'),(2504,3666,40720,1575,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',22730.63,NULL,NULL,1,'2024-08-25 11:43:11','2024-08-26 23:53:26','2024-08-26 23:53:26'),(2505,3666,40720,1575,15,937,'App\\Models\\PeriodLiquidation',NULL,937,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1109519.69,NULL,NULL,1,'2024-08-25 11:47:01','2024-08-26 23:46:00','2024-08-26 23:46:00'),(2506,3666,40720,1575,16,938,'App\\Models\\PeriodLiquidation',NULL,938,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',9683.35,NULL,NULL,1,'2024-08-25 11:48:15','2024-08-25 12:33:00','2024-08-25 12:33:00'),(2507,3666,40720,1575,16,938,'App\\Models\\PeriodLiquidation',NULL,938,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',9683.35,NULL,NULL,1,'2024-08-25 12:33:59','2024-08-25 12:36:30','2024-08-25 12:36:30'),(2508,3666,40720,1575,16,938,'App\\Models\\PeriodLiquidation',NULL,938,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',4265667.75,NULL,NULL,1,'2024-08-25 12:37:57','2024-08-26 23:49:50','2024-08-26 23:49:50'),(2509,3666,40720,1575,16,2509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',8327.67,'AJUSTE IIBB 04-2023',NULL,1,'2024-08-25 12:53:42','2024-08-25 12:53:42',NULL),(2510,3666,40720,1576,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',22586.22,NULL,NULL,1,'2024-08-25 21:12:58','2024-08-25 21:12:58',NULL),(2511,3666,40720,1576,16,940,'App\\Models\\PeriodLiquidation',NULL,940,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4289822.20,NULL,NULL,1,'2024-08-25 21:15:26','2024-08-25 21:15:26',NULL),(2512,3666,40720,1576,15,939,'App\\Models\\PeriodLiquidation',NULL,939,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1290310.79,NULL,NULL,1,'2024-08-25 21:17:17','2024-08-26 23:45:09','2024-08-26 23:45:09'),(2513,3666,40720,1576,16,2513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5546.75,'AJUSTE IIBB 05-2023',NULL,1,'2024-08-25 21:23:37','2024-08-25 21:23:37',NULL),(2514,3666,40720,1577,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',25833.41,NULL,NULL,1,'2024-08-25 21:27:44','2024-08-25 21:27:44',NULL),(2515,3666,40720,1577,15,941,'App\\Models\\PeriodLiquidation',NULL,941,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1495604.27,NULL,NULL,1,'2024-08-25 21:29:24','2024-08-26 23:44:55','2024-08-26 23:44:55'),(2516,3666,40720,1577,16,942,'App\\Models\\PeriodLiquidation',NULL,942,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4295077.15,NULL,NULL,1,'2024-08-25 21:31:05','2024-08-25 21:31:05',NULL),(2517,3666,40720,1577,16,2517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6825.65,'AJUSTE IIBB 06-2023',NULL,1,'2024-08-25 21:36:27','2024-08-25 21:36:27',NULL),(2518,3666,40720,1578,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',47202.76,NULL,NULL,1,'2024-08-25 21:51:21','2024-08-25 21:51:21',NULL);
INSERT INTO `balance_libro` VALUES (2519,3666,40720,1578,15,943,'App\\Models\\PeriodLiquidation',NULL,943,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1858186.10,NULL,NULL,1,'2024-08-25 21:52:35','2024-08-26 23:44:46','2024-08-26 23:44:46'),(2520,3666,40720,1578,16,944,'App\\Models\\PeriodLiquidation',NULL,944,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4295297.54,NULL,NULL,1,'2024-08-25 21:55:22','2024-08-25 21:55:22',NULL),(2521,3666,40720,1578,16,2521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7241.33,'AJUSTE IIBB 07-2023',NULL,1,'2024-08-25 22:01:37','2024-08-25 22:23:17','2024-08-25 22:23:17'),(2522,3666,40720,1579,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',37367.80,NULL,NULL,1,'2024-08-25 22:09:14','2024-08-25 22:09:14',NULL),(2523,3666,40720,1579,15,945,'App\\Models\\PeriodLiquidation',NULL,945,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',2052752.34,NULL,NULL,1,'2024-08-25 22:10:33','2024-08-26 23:44:37','2024-08-26 23:44:37'),(2524,3666,40720,1579,16,946,'App\\Models\\PeriodLiquidation',NULL,946,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4292911.98,NULL,NULL,1,'2024-08-25 22:11:24','2024-08-25 22:11:24',NULL),(2525,3666,40720,1579,16,2525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',6174.80,'AJUSTE IIBB 08-2023',NULL,1,'2024-08-25 22:16:35','2024-08-25 22:16:35',NULL),(2526,3666,40720,1578,16,2526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7241.33,'AJUSTE IIBB 07-2023',NULL,1,'2024-08-25 22:23:17','2024-08-25 22:23:17',NULL),(2527,3666,40720,1580,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',37965.24,NULL,NULL,1,'2024-08-25 22:33:06','2024-08-25 22:33:06',NULL),(2528,3666,40720,1580,15,947,'App\\Models\\PeriodLiquidation',NULL,947,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1883106.28,NULL,NULL,1,'2024-08-25 22:34:05','2024-08-26 23:44:28','2024-08-26 23:44:28'),(2529,3666,40720,1580,16,948,'App\\Models\\PeriodLiquidation',NULL,948,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',4282634.35,NULL,NULL,1,'2024-08-25 22:35:18','2024-08-25 22:35:18',NULL),(2530,3666,40720,1580,16,2530,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5686.35,'AJUSTE IIBB 09-2023',NULL,1,'2024-08-25 22:36:55','2024-08-25 22:39:27','2024-08-25 22:39:27'),(2531,3666,40720,1580,16,2531,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',7223.15,'AJUSTE IIBB 09-2023',NULL,1,'2024-08-25 22:39:27','2024-08-25 22:39:27',NULL),(2532,3666,40720,1581,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',21218.33,NULL,NULL,1,'2024-08-25 22:45:12','2024-08-25 22:50:43','2024-08-25 22:50:43'),(2533,3666,40720,1581,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',20010.62,NULL,NULL,1,'2024-08-25 22:50:43','2024-08-25 22:50:43',NULL),(2534,3666,40720,1581,15,951,'App\\Models\\PeriodLiquidation',NULL,951,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1839272.26,NULL,NULL,1,'2024-08-25 22:52:50','2024-08-26 23:44:20','2024-08-26 23:44:20'),(2535,3666,40720,1581,16,952,'App\\Models\\PeriodLiquidation',NULL,952,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4277015.26,NULL,NULL,1,'2024-08-25 22:54:11','2024-08-25 22:54:11',NULL),(2536,3666,40720,1581,16,2536,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',7638.03,'AJUSTE IIBB 10-2023',NULL,1,'2024-08-25 22:58:17','2024-08-25 22:58:17',NULL),(2537,3666,40720,1582,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',22615.33,NULL,NULL,1,'2024-08-26 08:04:28','2024-08-26 08:04:28',NULL);
INSERT INTO `balance_libro` VALUES (2538,3666,40720,1582,15,953,'App\\Models\\PeriodLiquidation',NULL,953,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1808022.28,NULL,NULL,1,'2024-08-26 08:07:20','2024-08-26 23:44:11','2024-08-26 23:44:11'),(2539,3666,40720,1582,16,954,'App\\Models\\PeriodLiquidation',NULL,954,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',4267038.52,NULL,NULL,1,'2024-08-26 08:37:32','2024-08-26 08:40:59','2024-08-26 08:40:59'),(2540,3666,40720,1582,16,954,'App\\Models\\PeriodLiquidation',NULL,954,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',4274676.55,NULL,NULL,1,'2024-08-26 08:41:45','2024-08-26 08:41:45',NULL),(2541,3666,40720,1582,16,2541,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',8385.94,'AJUSTE IIBB 11-2023',NULL,1,'2024-08-26 08:44:30','2024-08-26 08:48:15','2024-08-26 08:48:15'),(2542,3666,40720,1582,16,2542,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',11031.94,'AJUSTE IIBB 11-2023',NULL,1,'2024-08-26 08:48:15','2024-08-26 08:48:15',NULL),(2543,3666,40720,1583,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',24423.79,NULL,NULL,1,'2024-08-26 08:53:43','2024-08-26 08:55:58','2024-08-26 08:55:58'),(2544,3666,40720,1583,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',23483.72,NULL,NULL,1,'2024-08-26 08:55:58','2024-08-26 08:55:58',NULL),(2545,3666,40720,1583,15,957,'App\\Models\\PeriodLiquidation',NULL,957,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1781783.19,NULL,NULL,1,'2024-08-26 08:57:38','2024-08-26 23:43:46','2024-08-26 23:43:46'),(2546,3666,40720,1583,16,958,'App\\Models\\PeriodLiquidation',NULL,958,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4274400.43,NULL,NULL,1,'2024-08-26 09:00:17','2024-08-26 09:00:17',NULL),(2547,3666,40720,1583,16,2547,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',370714.30,'AJUSTE IIBB 12-2023',NULL,1,'2024-08-26 09:06:11','2024-08-26 09:06:11',NULL),(2548,3666,40720,1587,20,1856,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1856,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',54418.54,NULL,NULL,1,'2024-08-26 10:03:41','2024-08-26 18:22:44','2024-08-26 18:22:44'),(2549,3666,40720,1587,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',29613.68,NULL,NULL,1,'2024-08-26 10:06:42','2024-08-26 10:06:42',NULL),(2550,3666,40720,1594,20,1858,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1858,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',13086.00,NULL,NULL,1,'2024-08-26 16:35:33','2024-08-26 18:07:26','2024-08-26 18:07:26'),(2551,3666,40720,1589,20,1859,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1859,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',13086.00,NULL,NULL,1,'2024-08-26 16:37:18','2024-08-26 18:01:38','2024-08-26 18:01:38'),(2552,3666,40720,1589,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',38385.17,NULL,NULL,1,'2024-08-26 16:39:04','2024-08-26 19:22:50','2024-08-26 19:22:50'),(2553,3666,40720,1587,7,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',3777.82,NULL,NULL,1,'2024-08-26 17:41:16','2024-08-26 17:41:16',NULL),(2554,3666,40720,1587,7,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',3777.82,NULL,NULL,1,'2024-08-26 17:41:16','2024-08-26 17:41:16',NULL),(2555,3666,40720,1587,20,1861,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1861,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',287793.66,NULL,NULL,1,'2024-08-26 18:21:15','2024-08-26 18:21:15',NULL),(2556,3666,40720,1587,20,1862,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1862,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',46862.90,NULL,NULL,1,'2024-08-26 18:24:46','2024-08-26 18:24:46',NULL);
INSERT INTO `balance_libro` VALUES (2557,3666,40720,1587,15,964,'App\\Models\\PeriodLiquidation',NULL,964,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1626254.43,NULL,NULL,1,'2024-08-26 18:28:11','2024-08-26 23:43:38','2024-08-26 23:43:38'),(2558,3666,40720,1587,16,965,'App\\Models\\PeriodLiquidation',NULL,965,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4600620.65,NULL,NULL,1,'2024-08-26 18:30:57','2024-08-26 18:30:57',NULL),(2559,3666,40720,1587,16,2559,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',24377.02,'AJUSTE IIBB 01-2024',NULL,1,'2024-08-26 18:40:36','2024-08-26 18:40:36',NULL),(2560,3666,40720,1588,7,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',3777.82,NULL,NULL,1,'2024-08-26 18:45:29','2024-08-26 18:45:29',NULL),(2561,3666,40720,1588,7,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',3777.82,NULL,NULL,1,'2024-08-26 18:45:29','2024-08-26 18:45:29',NULL),(2562,3666,40720,1588,7,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',10115.96,NULL,NULL,1,'2024-08-26 18:46:19','2024-08-26 18:46:19',NULL),(2563,3666,40720,1588,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',32198.42,NULL,NULL,1,'2024-08-26 18:49:34','2024-08-26 18:49:34',NULL),(2564,3666,40720,1588,15,970,'App\\Models\\PeriodLiquidation',NULL,970,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1605068.53,NULL,NULL,1,'2024-08-26 18:50:56','2024-08-26 23:43:29','2024-08-26 23:43:29'),(2565,3666,40720,1588,20,1864,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1864,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',46862.90,NULL,NULL,1,'2024-08-26 19:00:40','2024-08-26 19:00:40',NULL),(2566,3666,40720,1588,16,971,'App\\Models\\PeriodLiquidation',NULL,971,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',4494050.54,NULL,NULL,1,'2024-08-26 19:07:04','2024-08-26 19:12:56','2024-08-26 19:12:56'),(2567,3666,40720,1588,16,2567,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',22848.48,'AJUSTE IIBB 02-2024',NULL,1,'2024-08-26 19:12:43','2024-08-26 19:12:43',NULL),(2568,3666,40720,1588,16,971,'App\\Models\\PeriodLiquidation',NULL,971,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',4518427.56,NULL,NULL,1,'2024-08-26 19:13:16','2024-08-26 19:13:16',NULL),(2569,3666,40720,1589,7,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',5057.98,NULL,NULL,1,'2024-08-26 19:18:26','2024-08-26 19:18:26',NULL),(2570,3666,40720,1589,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',39775.05,NULL,NULL,1,'2024-08-26 19:22:50','2024-08-26 19:22:50',NULL),(2571,3666,40720,1589,15,974,'App\\Models\\PeriodLiquidation',NULL,974,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1567529.98,NULL,NULL,1,'2024-08-26 19:24:57','2024-08-26 23:43:21','2024-08-26 23:43:21'),(2572,3666,40720,1589,16,975,'App\\Models\\PeriodLiquidation',NULL,975,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4436231.29,NULL,NULL,1,'2024-08-26 19:27:06','2024-08-26 19:27:06',NULL),(2573,3666,40720,1589,16,2573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',18942.91,'AJUSTE IIBB 03-2024',NULL,1,'2024-08-26 19:28:55','2024-08-26 19:28:55',NULL),(2574,3666,40720,1575,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',23715.11,NULL,NULL,1,'2024-08-26 23:51:13','2024-08-26 23:51:13',NULL),(2575,3666,40720,1575,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',18062.69,NULL,NULL,1,'2024-08-26 23:53:26','2024-08-26 23:53:26',NULL);
INSERT INTO `balance_libro` VALUES (2576,3666,40720,1575,16,979,'App\\Models\\PeriodLiquidation',NULL,979,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',4265667.75,NULL,NULL,1,'2024-08-26 23:54:34','2024-08-26 23:54:34',NULL),(2577,3666,40720,1575,15,978,'App\\Models\\PeriodLiquidation',NULL,978,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1105743.18,NULL,NULL,1,'2024-08-27 00:02:27','2024-08-27 00:02:27',NULL),(2578,3666,40720,1576,15,939,'App\\Models\\PeriodLiquidation',NULL,939,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1290310.79,NULL,NULL,1,'2024-08-27 00:04:01','2024-08-27 00:04:01',NULL),(2579,3666,40720,1577,15,941,'App\\Models\\PeriodLiquidation',NULL,941,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1495604.27,NULL,NULL,1,'2024-08-27 00:04:54','2024-08-27 00:04:54',NULL),(2580,3666,40720,1578,15,943,'App\\Models\\PeriodLiquidation',NULL,943,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1858186.10,NULL,NULL,1,'2024-08-27 00:05:43','2024-08-27 00:05:43',NULL),(2581,3666,40720,1579,15,945,'App\\Models\\PeriodLiquidation',NULL,945,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',2052752.34,NULL,NULL,1,'2024-08-27 00:06:58','2024-08-27 00:06:58',NULL),(2582,3666,40720,1580,15,947,'App\\Models\\PeriodLiquidation',NULL,947,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1883106.28,NULL,NULL,1,'2024-08-27 00:08:01','2024-08-27 00:08:01',NULL),(2583,3666,40720,1581,15,951,'App\\Models\\PeriodLiquidation',NULL,951,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1839272.26,NULL,NULL,1,'2024-08-27 00:08:53','2024-08-27 00:08:53',NULL),(2584,3666,40720,1582,15,953,'App\\Models\\PeriodLiquidation',NULL,953,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1808022.28,NULL,NULL,1,'2024-08-27 00:09:56','2024-08-27 00:09:56',NULL),(2585,3666,40720,1583,15,957,'App\\Models\\PeriodLiquidation',NULL,957,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1781783.19,NULL,NULL,1,'2024-08-27 00:10:53','2024-08-27 00:10:53',NULL),(2586,3666,40720,1587,15,964,'App\\Models\\PeriodLiquidation',NULL,964,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1626254.43,NULL,NULL,1,'2024-08-27 00:11:29','2024-08-27 00:11:29',NULL),(2587,3666,40720,1588,15,970,'App\\Models\\PeriodLiquidation',NULL,970,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1605068.53,NULL,NULL,1,'2024-08-27 00:12:00','2024-08-27 00:12:00',NULL),(2588,3666,40720,1589,15,974,'App\\Models\\PeriodLiquidation',NULL,974,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1567529.98,NULL,NULL,1,'2024-08-27 00:12:29','2025-08-02 11:07:16','2025-08-02 11:07:16'),(2589,3666,40720,1575,2,2589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',213347.20,'VENTA U$S 937,79 A $227,5',NULL,1,'2024-08-27 18:39:29','2024-08-27 18:39:29',NULL),(2590,3666,40720,1575,2,2590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',942590.00,'VENTA U$S 4143,25 A $227,5',NULL,1,'2024-08-27 18:41:18','2024-08-27 18:41:18',NULL),(2591,3666,40720,1576,2,2591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1230669.00,'VENTA U$S 5152,48 A $238,85',NULL,1,'2024-08-27 18:42:47','2024-08-27 18:42:47',NULL),(2592,3666,40720,1577,2,2592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',626291.69,'VENTA U$S 2375,20 A $263,68',NULL,1,'2024-08-27 18:44:33','2024-09-15 19:43:05','2024-09-15 19:43:05'),(2593,3666,40720,1577,2,2593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',704708.35,'VENTA U$S 2672,59 A $263,68',NULL,1,'2024-08-27 18:46:02','2024-09-15 19:45:39','2024-09-15 19:45:39'),(2594,3666,40720,1578,2,2594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',885014.57,'VENTA U$S 3098,14 A $285,66',NULL,1,'2024-08-27 18:48:15','2024-09-15 19:47:27','2024-09-15 19:47:27');
INSERT INTO `balance_libro` VALUES (2595,3666,40720,1578,2,2595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',383635.00,'VENTA U$S 1342,98 A $285,66',NULL,1,'2024-08-27 18:49:47','2024-09-15 19:49:03','2024-09-15 19:49:03'),(2596,3666,40720,1579,2,2596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',636435.00,'VENTA U$S 1733,12 A $367,22',NULL,1,'2024-08-27 18:51:17','2024-09-15 19:51:18','2024-09-15 19:51:18'),(2597,3666,40720,1589,4,2597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1291213.61,'AMORTIZACION EDIFICIO 3° AÑO',NULL,1,'2024-08-28 18:04:49','2024-10-17 11:56:53','2024-10-17 11:56:53'),(2598,3666,40720,1589,4,2598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1919086.43,'AMORTIZACION INMUEBLE 2° AÑO',NULL,1,'2024-08-28 18:06:23','2024-10-17 11:52:03','2024-10-17 11:52:03'),(2599,3666,40720,1589,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',502818333.79,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-09-02 19:15:00','2024-09-15 19:06:04','2024-09-15 19:06:04'),(2600,3666,40720,1577,2,2600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',626291.69,'VENTA U$S 1265,24 A $495',NULL,1,'2024-09-15 19:43:05','2024-09-15 19:43:05',NULL),(2601,3666,40720,1577,2,2601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',704708.35,'VENTA U$S 1423,65 A $495',NULL,1,'2024-09-15 19:45:39','2024-09-15 19:45:39',NULL),(2602,3666,40720,1578,2,2602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',885014.57,'VENTA U$S 1187,94 A $745',NULL,1,'2024-09-15 19:47:27','2024-09-15 19:47:27',NULL),(2603,3666,40720,1578,2,2603,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',383635.00,'VENTA U$S 514,95 A $745',NULL,1,'2024-09-15 19:49:03','2024-09-15 19:49:03',NULL),(2604,3666,40720,1579,2,2604,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',636435.00,'VENTA U$S 848,58 A $750',NULL,1,'2024-09-15 19:51:18','2024-09-15 19:51:18',NULL),(2605,3666,40720,1589,3,2605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',16720000.00,'U$S 20.000 A $836 COOP J.A. PARA SEDE',NULL,1,'2024-09-15 20:02:46','2024-09-15 20:02:46',NULL),(2606,3666,40720,1589,11,2606,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',55058.05,'AJUSTE DOLARES',NULL,1,'2024-09-15 20:46:57','2024-09-15 20:46:57',NULL),(2607,3666,40720,1589,11,2607,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',19043550.00,'AJUSTE VALUACION DOLARES EN EFECTIVO AL 31/03/2024',NULL,1,'2024-09-15 20:50:47','2024-09-15 20:50:47',NULL),(2608,3666,40720,1589,11,2608,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1148646.60,'AJUSTE VALUACION DOLARES EN CTA CTE AL 31/03/2024',NULL,1,'2024-09-15 20:53:16','2024-09-15 20:53:16',NULL),(2609,3666,40720,1589,11,2609,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2199750.00,'AJUSTE VALUACION CREDITO EN DOLARES AL 31/03/2024',NULL,1,'2024-09-15 20:55:00','2024-09-15 20:55:00',NULL),(2610,3666,40720,1589,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',500452303.77,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-09-15 21:01:29','2024-10-17 13:17:41','2024-10-17 13:17:41'),(2611,3666,40720,1589,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',18736998.17,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-09-27 18:15:38','2024-09-27 19:20:07','2024-09-27 19:20:07');
INSERT INTO `balance_libro` VALUES (2612,3666,40720,1589,18,2612,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',27267066.85,'PASO SALDO OBRAS EN CURSO A INMUEBLES',NULL,1,'2024-10-17 11:20:58','2024-10-17 13:34:36','2024-10-17 13:34:36'),(2613,3666,40720,1577,21,1868,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1868,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',1331000.04,NULL,NULL,1,'2024-10-17 11:37:35','2024-10-17 11:37:35',NULL),(2614,3666,40720,1578,21,1869,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1869,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',1268649.57,NULL,NULL,1,'2024-10-17 11:38:20','2024-10-17 11:38:20',NULL),(2615,3666,40720,1578,21,1870,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1870,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',636435.00,NULL,NULL,1,'2024-10-17 11:39:18','2024-10-17 11:39:18',NULL),(2616,3666,40720,1589,18,2616,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2674453.09,'ACTIVACION DE COMPRAS',NULL,1,'2024-10-17 11:41:25','2024-10-17 20:27:13','2024-10-17 20:27:13'),(2617,3666,40720,1589,18,2617,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1803826.61,'ACTIVACION DE GASTOS VARIOS',NULL,1,'2024-10-17 11:48:18','2024-10-17 20:27:13','2024-10-17 20:27:13'),(2618,3666,40720,1589,4,2618,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',7501473.43,'AMORTIZACION INMUEBLE 2° AÑO',NULL,1,'2024-10-17 11:52:03','2024-10-17 13:54:50','2024-10-17 13:54:50'),(2619,3666,40720,1589,4,2619,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4620012.93,'AMORTIZACION EDIFICIO 3° AÑO',NULL,1,'2024-10-17 11:56:53','2024-10-17 13:56:49','2024-10-17 13:56:49'),(2620,3666,40720,1583,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',264890550.70,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-10-17 13:20:24','2024-10-17 20:27:13','2024-10-17 20:27:13'),(2621,3666,40720,1589,18,2621,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',7692073.49,'PASO SALDO OBRAS EN CURSO A INMUEBLES',NULL,1,'2024-10-17 13:34:36','2024-10-17 20:27:13','2024-10-17 20:27:13'),(2622,3666,40720,1589,4,2622,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4772150.48,'AMORTIZACION INMUEBLE 2° AÑO',NULL,1,'2024-10-17 13:54:50','2024-10-17 20:27:13','2024-10-17 20:27:13'),(2623,3666,40720,1589,4,2623,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',3047061.89,'AMORTIZACION EDIFICIO 3° AÑO',NULL,1,'2024-10-17 13:56:49','2024-10-17 20:27:13','2024-10-17 20:27:13'),(2624,3666,40720,1589,18,2624,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',7692073.49,'ACTIVACION DE OBRAS EN CURSO',NULL,1,'2024-10-17 21:57:05','2024-10-17 21:57:05',NULL),(2625,3666,40720,1589,18,2625,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2674453.09,'ACTIVACION DE COMPRAS (FCT CELINA ANDRADE)',NULL,1,'2024-10-17 21:59:47','2024-10-17 21:59:47',NULL),(2626,3666,40720,1589,18,2626,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1803826.61,'ACTIVACION GASTOS VARIOS',NULL,1,'2024-10-17 22:01:25','2024-10-17 22:01:25',NULL),(2627,3666,40720,1589,11,2627,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2086632.44,'BAJA DS X VTAS COMUNES',NULL,1,'2024-10-17 22:35:09','2024-10-17 23:00:12','2024-10-17 23:00:12'),(2628,3666,40720,1589,11,2628,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2086632.44,'BAJA DS X VTAS COMUNES',NULL,1,'2024-10-17 23:00:12','2024-10-17 23:00:12',NULL);
INSERT INTO `balance_libro` VALUES (2629,3666,40720,1583,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',264890550.70,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-10-18 00:32:13','2024-10-18 00:56:27','2024-10-18 00:56:27'),(2630,3666,40720,1589,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',505266062.97,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-10-18 01:00:01','2024-12-11 17:10:59','2024-12-11 17:10:59'),(2631,3666,40720,1589,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',505266062.97,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-12-11 17:20:22','2024-12-11 17:23:53','2024-12-11 17:23:53'),(2632,3666,40720,1583,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',264890550.70,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-12-11 17:26:41','2024-12-11 17:26:44',NULL),(2633,3666,40720,1589,4,2633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4772150.48,'AMORTIZACION EDIFICIO',NULL,1,'2024-12-11 19:45:54','2024-12-11 19:48:38','2024-12-11 19:48:38'),(2634,3666,40720,1589,4,2634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',3047061.89,'AMORTIZACION EDIFICIO 3° AÑO',NULL,1,'2024-12-11 19:48:38','2024-12-11 19:48:38',NULL),(2635,3666,40720,1589,4,2635,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',4772150.48,'AMORTIZACION INMUEBLE 3° AÑO',NULL,1,'2024-12-11 19:49:28','2024-12-11 19:49:28',NULL),(2636,3666,40720,1589,19,2636,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',61637499.03,'REFUNDICION CUENTAS DE RESULTADO',NULL,1,'2024-12-11 20:04:32','2024-12-11 20:04:32',NULL),(2637,3666,40720,1589,19,2637,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',5370697.29,'PASE RDO DEL EJ A RDO NO ASIGNADOS',NULL,1,'2024-12-11 20:06:26','2024-12-11 20:06:26',NULL),(2638,3666,40720,1589,9,2638,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',77839.88,'COMPENSACION CREDITOS Y PASIVOS',NULL,1,'2024-12-12 10:45:02','2025-08-13 10:07:36','2025-08-13 10:07:36'),(2639,3666,40720,1589,13,2639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1163273.07,'CANCELACION PASIVOS',NULL,1,'2024-12-12 10:49:05','2024-12-12 10:49:05',NULL),(2640,3666,40720,1589,17,2640,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',450489864.69,'ASIENTO CIERRRE EJ N°84',NULL,1,'2024-12-12 11:04:19','2024-12-12 11:04:19',NULL),(2641,3666,40849,4592,19,2641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',167801981.90,'REFUNDICION CUENTAS DE RESULTADO',NULL,1,'2025-05-03 11:05:59','2025-05-03 11:05:59',NULL),(2642,3666,40849,4592,19,2642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3948625.22,'PASE RDO DEL EJ A RDO NO ASIGNADOS',NULL,1,'2025-05-03 11:08:29','2025-05-03 11:08:29',NULL),(2643,3666,40849,4592,9,2643,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',18867692.95,'COMPENSACION IVA DF-IVA CF',NULL,1,'2025-05-03 11:16:38','2025-05-03 11:16:38',NULL),(2644,3666,40849,4592,17,2644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',233754588.81,'ASIENTO CIERRRE EJ N°64',NULL,1,'2025-05-03 11:41:10','2025-05-03 11:41:10',NULL),(2645,3666,40849,4596,12,2645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',233754588.81,'ASIENTO REAPERTURA EJ N°65',NULL,1,'2025-05-03 11:50:57','2025-05-03 11:50:57',NULL);
INSERT INTO `balance_libro` VALUES (2646,3666,40849,4597,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',14917200.00,NULL,NULL,1,'2025-05-03 12:00:14','2025-05-03 12:00:14',NULL),(2647,3666,40849,4597,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',37740516.00,NULL,NULL,1,'2025-05-03 12:00:14','2025-05-03 12:00:14',NULL),(2648,3666,40849,4598,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',17776330.00,NULL,NULL,1,'2025-05-03 12:01:28','2025-05-03 12:01:28',NULL),(2649,3666,40849,4600,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',46616250.00,NULL,NULL,1,'2025-05-03 12:02:34','2025-05-03 12:02:34',NULL),(2650,3666,40849,4600,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',46616250.00,NULL,NULL,1,'2025-05-03 12:02:34','2025-05-03 12:02:34',NULL),(2651,3666,40849,4600,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',62217155.00,NULL,NULL,1,'2025-05-03 12:02:34','2025-05-03 12:02:34',NULL),(2652,3666,40849,4601,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',106657980.00,NULL,NULL,1,'2025-05-03 12:03:14','2025-05-03 12:03:14',NULL),(2653,3666,40849,4601,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',79860000.00,NULL,NULL,1,'2025-05-03 12:03:14','2025-05-03 12:03:14',NULL),(2654,3666,40849,4607,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',63772583.88,NULL,NULL,1,'2025-05-03 12:07:56','2025-05-03 12:07:56',NULL),(2655,3666,40849,4607,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',63772583.88,NULL,NULL,1,'2025-05-03 12:07:56','2025-05-03 12:07:56',NULL),(2656,3666,40849,4607,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',63772583.88,NULL,NULL,1,'2025-05-03 12:07:56','2025-05-03 12:07:56',NULL),(2657,3666,40849,4607,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-16','2024-12-16',65021277.83,NULL,NULL,1,'2025-05-03 12:07:56','2025-05-03 12:07:56',NULL),(2658,3666,40849,4607,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',70449273.98,NULL,NULL,1,'2025-05-03 12:07:56','2025-05-03 12:07:56',NULL),(2659,3666,40849,4596,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',22428.00,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-03 12:11:13',NULL),(2660,3666,40849,4596,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',21000.00,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-03 12:11:13',NULL),(2661,3666,40849,4596,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',22403.58,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-03 12:11:13',NULL),(2662,3666,40849,4596,3,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',200284.70,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-03 12:11:13',NULL),(2663,3666,40849,4596,3,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',40001.01,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-03 12:11:13',NULL),(2664,3666,40849,4596,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-07','2024-01-07',20428.00,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-03 12:11:13',NULL),(2665,3666,40849,4596,3,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',20630.00,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-03 12:11:13',NULL);
INSERT INTO `balance_libro` VALUES (2666,3666,40849,4596,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',10276.28,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-19 09:04:38','2025-05-19 09:04:38'),(2667,3666,40849,4596,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',42007.69,NULL,NULL,1,'2025-05-03 12:11:13','2025-05-03 12:11:13',NULL),(2668,3666,40849,4596,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',17400.00,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2669,3666,40849,4596,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',40003.76,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2670,3666,40849,4596,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',25001.06,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2671,3666,40849,4596,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',30001.27,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2672,3666,40849,4596,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',82207.88,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-24 10:00:50','2025-05-24 10:00:50'),(2673,3666,40849,4596,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',50340.00,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2674,3666,40849,4596,3,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',14778.00,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2675,3666,40849,4596,3,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',46295.93,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2676,3666,40849,4596,3,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',36628.38,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2677,3666,40849,4596,3,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-14','2024-01-14',12500.00,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2678,3666,40849,4596,3,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',37204.18,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2679,3666,40849,4596,3,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',7000.00,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2680,3666,40849,4596,3,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',12503.00,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2681,3666,40849,4596,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-21','2024-01-21',82207.69,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-24 10:06:27','2025-05-24 10:06:27'),(2682,3666,40849,4596,3,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-21','2024-01-21',59708.50,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2683,3666,40849,4596,3,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-21','2024-01-21',16060.00,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2684,3666,40849,4596,3,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',10002.66,NULL,NULL,1,'2025-05-03 12:11:14','2025-05-03 12:11:14',NULL),(2685,3666,40849,4596,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',441963.82,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-19 09:19:49','2025-05-19 09:19:49');
INSERT INTO `balance_libro` VALUES (2686,3666,40849,4596,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',102750.75,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-24 10:17:13','2025-05-24 10:17:13'),(2687,3666,40849,4596,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',51000.05,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2688,3666,40849,4596,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',15800.00,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2689,3666,40849,4596,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',8482.06,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2690,3666,40849,4596,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',40861.03,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2691,3666,40849,4596,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',6700.00,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2692,3666,40849,4596,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',57003.21,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2693,3666,40849,4596,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',1459.26,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2694,3666,40849,4596,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-28','2024-01-28',44504.58,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2695,3666,40849,4596,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-28','2024-01-28',45705.40,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2696,3666,40849,4596,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',200110.91,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2697,3666,40849,4596,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',201709.98,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2698,3666,40849,4596,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',40001.09,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2699,3666,40849,4596,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',44001.77,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2700,3666,40849,4596,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2700.97,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2701,3666,40849,4596,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',40003.95,NULL,NULL,1,'2025-05-03 12:11:15','2025-05-03 12:11:15',NULL),(2702,3666,40849,4597,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',60000.48,NULL,NULL,1,'2025-05-03 12:15:03','2025-05-03 12:15:03',NULL),(2703,3666,40849,4597,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',30443.00,NULL,NULL,1,'2025-05-03 12:15:03','2025-05-03 12:15:03',NULL),(2704,3666,40849,4597,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',1459.26,NULL,NULL,1,'2025-05-03 12:15:03','2025-05-03 12:15:03',NULL),(2705,3666,40849,4597,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',17978.72,NULL,NULL,1,'2025-05-03 12:15:03','2025-05-19 09:23:11','2025-05-19 09:23:11');
INSERT INTO `balance_libro` VALUES (2706,3666,40849,4597,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',2260.18,NULL,NULL,1,'2025-05-03 12:15:03','2025-05-19 09:24:03','2025-05-19 09:24:03'),(2707,3666,40849,4597,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',11551.24,NULL,NULL,1,'2025-05-03 12:15:03','2025-05-03 12:15:03',NULL),(2708,3666,40849,4597,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',30010.72,NULL,NULL,1,'2025-05-03 12:15:03','2025-05-03 12:15:03',NULL),(2709,3666,40849,4597,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',7600.00,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2710,3666,40849,4597,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',17000.01,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2711,3666,40849,4597,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',30800.00,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2712,3666,40849,4597,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',240000.00,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2713,3666,40849,4597,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',7800.00,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2714,3666,40849,4597,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',57029.52,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-19 09:25:30','2025-05-19 09:25:30'),(2715,3666,40849,4597,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',71926.88,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-24 12:26:32','2025-05-24 12:26:32'),(2716,3666,40849,4597,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',240000.00,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2717,3666,40849,4597,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',1540191.96,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2718,3666,40849,4597,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',100000.00,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2719,3666,40849,4597,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',71925.61,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-24 12:28:11','2025-05-24 12:28:11'),(2720,3666,40849,4597,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',55201.86,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-24 12:19:49','2025-05-24 12:19:49'),(2721,3666,40849,4597,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',56003.22,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2722,3666,40849,4597,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',250349.99,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2723,3666,40849,4597,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',9000.10,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2724,3666,40849,4597,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',560651.18,NULL,NULL,1,'2025-05-03 12:15:04','2025-05-03 12:15:04',NULL),(2725,3666,40849,4597,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',9878.73,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-03 12:15:05',NULL);
INSERT INTO `balance_libro` VALUES (2726,3666,40849,4597,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',24000.00,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-03 12:15:05',NULL),(2727,3666,40849,4597,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',50001.12,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-03 12:15:05',NULL),(2728,3666,40849,4597,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',6857.55,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-03 12:15:05',NULL),(2729,3666,40849,4597,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',71924.55,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-24 12:37:01','2025-05-24 12:37:01'),(2730,3666,40849,4597,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',18360.92,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-03 12:15:05',NULL),(2731,3666,40849,4597,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',1650.00,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-03 12:15:05',NULL),(2732,3666,40849,4597,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',22500.00,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-03 12:15:05',NULL),(2733,3666,40849,4597,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',30005.82,NULL,NULL,1,'2025-05-03 12:15:05','2025-05-03 12:15:05',NULL),(2734,3666,40849,4598,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',350000.00,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2735,3666,40849,4598,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',1459.26,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2736,3666,40849,4598,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',300.00,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2737,3666,40849,4598,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',30000.00,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2738,3666,40849,4598,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',279000.00,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2739,3666,40849,4598,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',4220.26,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2740,3666,40849,4598,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',13133.34,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2741,3666,40849,4598,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',398453.00,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2742,3666,40849,4598,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',200319.95,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2743,3666,40849,4598,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',1600.00,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2744,3666,40849,4598,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',40763.06,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2745,3666,40849,4598,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',15000.00,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2746,3666,40849,4598,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',2500.15,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL);
INSERT INTO `balance_libro` VALUES (2747,3666,40849,4598,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',107911.30,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-24 15:51:19','2025-05-24 15:51:19'),(2748,3666,40849,4598,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',10001.71,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2749,3666,40849,4598,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',50003.35,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2750,3666,40849,4598,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',452995.41,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2751,3666,40849,4598,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',300209.90,NULL,NULL,1,'2025-05-03 12:16:07','2025-05-03 12:16:07',NULL),(2752,3666,40849,4598,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',15500.00,NULL,NULL,1,'2025-05-03 12:16:08','2025-05-03 12:16:08',NULL),(2753,3666,40849,4598,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',51000.01,NULL,NULL,1,'2025-05-03 12:16:08','2025-05-03 12:16:08',NULL),(2754,3666,40849,4598,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',45004.21,NULL,NULL,1,'2025-05-03 12:16:08','2025-05-03 12:16:08',NULL),(2755,3666,40849,4598,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',52879.26,NULL,NULL,1,'2025-05-03 12:16:08','2025-05-03 12:16:08',NULL),(2756,3666,40849,4598,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',17800.00,NULL,NULL,1,'2025-05-03 12:16:08','2025-05-03 12:16:08',NULL),(2757,3666,40849,4599,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',71500.01,NULL,NULL,1,'2025-05-03 12:17:04','2025-05-03 12:17:04',NULL),(2758,3666,40849,4599,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',1296986.90,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2759,3666,40849,4599,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',370000.00,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2760,3666,40849,4599,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',439000.10,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2761,3666,40849,4599,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',4700.00,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2762,3666,40849,4599,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1459.26,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2763,3666,40849,4599,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1459.26,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2764,3666,40849,4599,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',2918.52,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2765,3666,40849,4599,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',10003.49,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2766,3666,40849,4599,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',68116.87,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-24 16:28:09','2025-05-24 16:28:09');
INSERT INTO `balance_libro` VALUES (2767,3666,40849,4599,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',946131.91,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2768,3666,40849,4599,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',30800.00,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2769,3666,40849,4599,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',21600.00,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2770,3666,40849,4599,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',80000.00,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2771,3666,40849,4599,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',2704529.52,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2772,3666,40849,4599,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',949875.17,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2773,3666,40849,4599,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',84500.00,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2774,3666,40849,4599,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',100000.17,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2775,3666,40849,4599,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',19500.00,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2776,3666,40849,4599,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',86254.01,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-24 16:29:48','2025-05-24 16:29:48'),(2777,3666,40849,4599,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',106017.28,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2778,3666,40849,4599,3,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',531857.12,NULL,NULL,1,'2025-05-03 12:17:05','2025-05-03 12:17:05',NULL),(2779,3666,40849,4599,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',23006.77,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2780,3666,40849,4599,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',17004.89,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2781,3666,40849,4599,3,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',106588.00,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2782,3666,40849,4599,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',4952.88,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2783,3666,40849,4599,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',36000.00,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2784,3666,40849,4599,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',15416.76,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2785,3666,40849,4599,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',65000.00,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2786,3666,40849,4599,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',9000.00,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL);
INSERT INTO `balance_libro` VALUES (2787,3666,40849,4599,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',110836.51,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-24 16:37:24','2025-05-24 16:37:24'),(2788,3666,40849,4599,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',84286.44,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-24 16:36:21','2025-05-24 16:36:21'),(2789,3666,40849,4599,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',14400.00,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2790,3666,40849,4599,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',13972.04,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-24 16:38:12','2025-05-24 16:38:12'),(2791,3666,40849,4599,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',213300.32,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2792,3666,40849,4599,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',21659.00,NULL,NULL,1,'2025-05-03 12:17:06','2025-05-03 12:17:06',NULL),(2793,3666,40849,4600,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',370000.00,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2794,3666,40849,4600,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',500289.30,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2795,3666,40849,4600,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',27170.00,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2796,3666,40849,4600,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-05','2024-05-05',50005.75,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2797,3666,40849,4600,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',4000.00,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2798,3666,40849,4600,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',11000.00,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2799,3666,40849,4600,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',45000.09,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2800,3666,40849,4600,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',10008.09,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2801,3666,40849,4600,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',65945.00,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2802,3666,40849,4600,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',60007.62,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2803,3666,40849,4600,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',41011.37,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2804,3666,40849,4600,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',50002.13,NULL,NULL,1,'2025-05-03 12:18:30','2025-05-03 12:18:30',NULL),(2805,3666,40849,4600,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',126300.00,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2806,3666,40849,4600,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',74399.95,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL);
INSERT INTO `balance_libro` VALUES (2807,3666,40849,4600,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',1532815.61,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-24 16:55:11','2025-05-24 16:55:11'),(2808,3666,40849,4600,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',20003.05,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2809,3666,40849,4600,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',19800.09,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2810,3666,40849,4600,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',2004.52,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2811,3666,40849,4600,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',1849.24,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-24 16:55:46','2025-05-24 16:55:46'),(2812,3666,40849,4600,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',11207.14,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2813,3666,40849,4600,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',63800.01,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2814,3666,40849,4600,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',13001.00,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2815,3666,40849,4600,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',1650.90,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2816,3666,40849,4600,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',1650.90,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2817,3666,40849,4600,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',174218.14,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2818,3666,40849,4600,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',75000.01,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2819,3666,40849,4600,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-26','2024-05-26',54014.27,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2820,3666,40849,4600,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',579942.11,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-24 16:56:49','2025-05-24 16:56:49'),(2821,3666,40849,4600,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',20003.05,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2822,3666,40849,4600,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',1203790.24,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-24 17:14:29','2025-05-24 17:14:29'),(2823,3666,40849,4600,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',120000.00,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2824,3666,40849,4600,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',79114.28,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-24 16:57:27','2025-05-24 16:57:27'),(2825,3666,40849,4600,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',4418.05,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL),(2826,3666,40849,4600,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',139000.00,NULL,NULL,1,'2025-05-03 12:18:31','2025-05-03 12:18:31',NULL);
INSERT INTO `balance_libro` VALUES (2827,3666,40849,4600,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',50000.58,NULL,NULL,1,'2025-05-03 12:18:32','2025-05-03 12:18:32',NULL),(2828,3666,40849,4601,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',3750.11,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2829,3666,40849,4601,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-02','2024-06-02',10005.57,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2830,3666,40849,4601,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',475694.77,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2831,3666,40849,4601,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',12000.00,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2832,3666,40849,4601,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',50003.82,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2833,3666,40849,4601,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',45000.00,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2834,3666,40849,4601,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',339987.15,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-24 17:18:43','2025-05-24 17:18:43'),(2835,3666,40849,4601,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',39799.99,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2836,3666,40849,4601,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',8369200.00,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2837,3666,40849,4601,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',499559.96,NULL,NULL,1,'2025-05-03 12:19:30','2025-05-03 12:19:30',NULL),(2838,3666,40849,4601,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',38872.53,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2839,3666,40849,4601,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',54009.79,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2840,3666,40849,4601,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',82223.26,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-24 17:28:04','2025-05-24 17:28:04'),(2841,3666,40849,4601,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',28870.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2842,3666,40849,4601,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',50001.54,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-24 17:36:18','2025-05-24 17:36:18'),(2843,3666,40849,4601,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',370000.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2844,3666,40849,4601,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',15004.57,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2845,3666,40849,4601,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',189678.02,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2846,3666,40849,4601,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',6574.61,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL);
INSERT INTO `balance_libro` VALUES (2847,3666,40849,4601,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',3100.59,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2848,3666,40849,4601,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',169128.61,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2849,3666,40849,4601,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',19503.99,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2850,3666,40849,4601,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',18360.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2851,3666,40849,4601,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',12000.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2852,3666,40849,4601,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',43200.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2853,3666,40849,4601,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',13500.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2854,3666,40849,4601,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',479826.84,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2855,3666,40849,4601,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',64990.16,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2856,3666,40849,4601,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',57400.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2857,3666,40849,4601,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',500000.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2858,3666,40849,4601,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',2586000.01,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2859,3666,40849,4601,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',3020000.04,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2860,3666,40849,4601,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',7500.00,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-03 12:19:31',NULL),(2861,3666,40849,4601,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',87380.91,NULL,NULL,1,'2025-05-03 12:19:31','2025-05-24 17:20:43','2025-05-24 17:20:43'),(2862,3666,40849,4601,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2360000.02,NULL,NULL,1,'2025-05-03 12:19:32','2025-05-03 12:19:32',NULL),(2863,3666,40849,4601,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2576000.01,NULL,NULL,1,'2025-05-03 12:19:32','2025-05-03 12:19:32',NULL),(2864,3666,40849,4601,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',119659.16,NULL,NULL,1,'2025-05-03 12:19:32','2025-05-24 17:20:11','2025-05-24 17:20:11'),(2865,3666,40849,4601,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',512.31,NULL,NULL,1,'2025-05-03 12:19:32','2025-05-03 12:19:32',NULL),(2866,3666,40849,4601,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',107800.00,NULL,NULL,1,'2025-05-03 12:19:32','2025-05-03 12:19:32',NULL);
INSERT INTO `balance_libro` VALUES (2867,3666,40849,4601,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',1760000.01,NULL,NULL,1,'2025-05-03 12:19:32','2025-05-03 12:19:32',NULL),(2868,3666,40849,4602,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',370000.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2869,3666,40849,4602,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',40000.24,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2870,3666,40849,4602,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',34500.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2871,3666,40849,4602,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',13200.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2872,3666,40849,4602,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',182162.77,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2873,3666,40849,4602,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',18350.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2874,3666,40849,4602,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',200639.87,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2875,3666,40849,4602,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',8900.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2876,3666,40849,4602,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',200499.99,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2877,3666,40849,4602,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',7600.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2878,3666,40849,4602,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',324633.07,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-24 17:47:57','2025-05-24 17:47:57'),(2879,3666,40849,4602,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',120000.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2880,3666,40849,4602,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',2540000.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2881,3666,40849,4602,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',6000.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2882,3666,40849,4602,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',22500.23,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-24 17:51:10','2025-05-24 17:51:10'),(2883,3666,40849,4602,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',2400000.01,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2884,3666,40849,4602,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',3700000.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2885,3666,40849,4602,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',10920000.00,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL),(2886,3666,40849,4602,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',19910.43,NULL,NULL,1,'2025-05-03 12:22:23','2025-05-03 12:22:23',NULL);
INSERT INTO `balance_libro` VALUES (2887,3666,40849,4602,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',28400.00,NULL,NULL,1,'2025-05-03 12:22:24','2025-05-03 12:22:24',NULL),(2888,3666,40849,4602,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',4000.00,NULL,NULL,1,'2025-05-03 12:22:24','2025-05-03 12:22:24',NULL),(2889,3666,40849,4602,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',41757.34,NULL,NULL,1,'2025-05-03 12:22:24','2025-05-03 12:22:24',NULL),(2890,3666,40849,4602,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',1754000.01,NULL,NULL,1,'2025-05-03 12:22:24','2025-05-03 12:22:24',NULL),(2891,3666,40849,4602,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',4830000.00,NULL,NULL,1,'2025-05-03 12:22:24','2025-05-03 12:22:24',NULL),(2892,3666,40849,4602,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',18300.00,NULL,NULL,1,'2025-05-03 12:22:24','2025-05-03 12:22:24',NULL),(2893,3666,40849,4604,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',164620.91,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2894,3666,40849,4604,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',60000.00,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2895,3666,40849,4604,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',6530.00,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2896,3666,40849,4604,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',138128.85,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2897,3666,40849,4604,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',370000.00,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2898,3666,40849,4604,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-07','2024-09-07',71782.38,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2899,3666,40849,4604,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-07','2024-09-07',20000.59,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2900,3666,40849,4604,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',5900.20,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2901,3666,40849,4604,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-14','2024-09-14',25004.95,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2902,3666,40849,4604,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-14','2024-09-14',30002.24,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2903,3666,40849,4604,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',32500.00,NULL,NULL,1,'2025-05-03 12:24:45','2025-05-03 12:24:45',NULL),(2904,3666,40849,4604,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',102516.85,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2905,3666,40849,4604,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',20004.20,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2906,3666,40849,4604,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',19755.60,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2907,3666,40849,4604,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',127880.37,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL);
INSERT INTO `balance_libro` VALUES (2908,3666,40849,4604,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',25115.84,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2909,3666,40849,4604,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',491927.10,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-24 18:19:15','2025-05-24 18:19:15'),(2910,3666,40849,4604,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',9800.00,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2911,3666,40849,4604,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',85380.00,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2912,3666,40849,4604,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',12972.49,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2913,3666,40849,4604,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',20004.20,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2914,3666,40849,4604,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',66703.98,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2915,3666,40849,4604,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',6200.00,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2916,3666,40849,4604,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',10712.23,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2917,3666,40849,4604,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',39600.00,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2918,3666,40849,4604,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',148070.20,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2919,3666,40849,4604,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',35006.61,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2920,3666,40849,4604,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',30002.24,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2921,3666,40849,4604,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',29999.68,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2922,3666,40849,4604,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',35001.18,NULL,NULL,1,'2025-05-03 12:24:46','2025-05-03 12:24:46',NULL),(2923,3666,40849,4605,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',35003.64,NULL,NULL,1,'2025-05-03 12:26:12','2025-05-03 12:26:12',NULL),(2924,3666,40849,4605,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',3000.00,NULL,NULL,1,'2025-05-03 12:26:12','2025-05-03 12:26:12',NULL),(2925,3666,40849,4605,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',60000.00,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2926,3666,40849,4605,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',50009.06,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2927,3666,40849,4605,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',20005.20,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2928,3666,40849,4605,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',30037.20,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL);
INSERT INTO `balance_libro` VALUES (2929,3666,40849,4605,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',500899.94,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2930,3666,40849,4605,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',20700.00,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2931,3666,40849,4605,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',85003.80,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2932,3666,40849,4605,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',23450.02,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2933,3666,40849,4605,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',31317.83,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2934,3666,40849,4605,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',30001.20,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2935,3666,40849,4605,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',20005.20,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2936,3666,40849,4605,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',11500.00,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2937,3666,40849,4605,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',60000.88,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2938,3666,40849,4605,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',370000.00,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2939,3666,40849,4605,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-12','2024-10-12',16303.13,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2940,3666,40849,4605,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-12','2024-10-12',27030.19,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2941,3666,40849,4605,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',50000.04,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2942,3666,40849,4605,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',20007.60,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2943,3666,40849,4605,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',25003.20,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2944,3666,40849,4605,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',12869.54,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2945,3666,40849,4605,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',6852.46,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-24 18:32:06','2025-05-24 18:32:06'),(2946,3666,40849,4605,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',12869.54,NULL,NULL,1,'2025-05-03 12:26:13','2025-05-03 12:26:13',NULL),(2947,3666,40849,4605,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',12869.54,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2948,3666,40849,4605,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',1891.58,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2949,3666,40849,4605,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',7328.21,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL);
INSERT INTO `balance_libro` VALUES (2950,3666,40849,4605,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',50003.00,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2951,3666,40849,4605,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',50004.41,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2952,3666,40849,4605,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',68123.94,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-24 18:33:26','2025-05-24 18:33:26'),(2953,3666,40849,4605,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',50001.60,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2954,3666,40849,4605,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',50006.21,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2955,3666,40849,4605,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',83018.39,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2956,3666,40849,4605,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',39998.85,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2957,3666,40849,4605,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',4114000.00,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2958,3666,40849,4605,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-29','2024-10-29',22849.99,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2959,3666,40849,4605,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',4150764.13,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2960,3666,40849,4605,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',4150764.13,NULL,NULL,1,'2025-05-03 12:26:14','2025-05-03 12:26:14',NULL),(2961,3666,40849,4606,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',60000.00,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2962,3666,40849,4606,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-02','2024-11-02',70006.70,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2963,3666,40849,4606,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-02','2024-11-02',24000.00,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2964,3666,40849,4606,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-02','2024-11-02',64503.95,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2965,3666,40849,4606,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-02','2024-11-02',32580.00,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2966,3666,40849,4606,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-02','2024-11-02',30007.81,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2967,3666,40849,4606,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',11800.00,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2968,3666,40849,4606,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',50006.83,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2969,3666,40849,4606,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',50081.25,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL),(2970,3666,40849,4606,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',150000.00,NULL,NULL,1,'2025-05-03 12:26:53','2025-05-03 12:26:53',NULL);
INSERT INTO `balance_libro` VALUES (2971,3666,40849,4606,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',1600000.00,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2972,3666,40849,4606,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',31005.04,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2973,3666,40849,4606,3,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',30003.92,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2974,3666,40849,4606,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',5235851.50,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2975,3666,40849,4606,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-09','2024-11-09',40003.60,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2976,3666,40849,4606,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-09','2024-11-09',12200.00,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2977,3666,40849,4606,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-09','2024-11-09',30007.60,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2978,3666,40849,4606,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-09','2024-11-09',9300.00,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2979,3666,40849,4606,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-10','2024-11-10',50046.20,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2980,3666,40849,4606,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',12002.55,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2981,3666,40849,4606,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',6000.05,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2982,3666,40849,4606,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',162800.00,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2983,3666,40849,4606,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',18500.10,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2984,3666,40849,4606,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',49400.00,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2985,3666,40849,4606,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',500219.02,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2986,3666,40849,4606,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',16000.00,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2987,3666,40849,4606,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',50005.62,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2988,3666,40849,4606,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',50002.33,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2989,3666,40849,4606,3,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',60003.35,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2990,3666,40849,4606,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',40005.16,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2991,3666,40849,4606,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-23','2024-11-23',64503.36,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL);
INSERT INTO `balance_libro` VALUES (2992,3666,40849,4606,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-23','2024-11-23',50081.25,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2993,3666,40849,4606,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-23','2024-11-23',503941.25,NULL,NULL,1,'2025-05-03 12:26:54','2025-05-03 12:26:54',NULL),(2994,3666,40849,4606,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',65031.57,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(2995,3666,40849,4606,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',6000.00,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(2996,3666,40849,4606,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',50004.83,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(2997,3666,40849,4606,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',20000.00,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(2998,3666,40849,4606,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',1056256.44,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(2999,3666,40849,4606,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',90005.03,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3000,3666,40849,4606,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',871754.43,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3001,3666,40849,4606,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',953714.78,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3002,3666,40849,4606,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',96011.60,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3003,3666,40849,4606,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',246964.65,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3004,3666,40849,4606,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',97375.14,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3005,3666,40849,4606,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',97011.10,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3006,3666,40849,4606,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',110508.95,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3007,3666,40849,4606,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',99002.38,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3008,3666,40849,4606,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',1056256.44,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3009,3666,40849,4606,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',4945512.00,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3010,3666,40849,4606,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',97483.70,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3011,3666,40849,4606,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',80073.86,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3012,3666,40849,4606,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',88275.67,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL);
INSERT INTO `balance_libro` VALUES (3013,3666,40849,4606,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',24501.22,NULL,NULL,1,'2025-05-03 12:26:55','2025-05-03 12:26:55',NULL),(3014,3666,40849,4607,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',851840.00,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3015,3666,40849,4607,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',70000.00,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3016,3666,40849,4607,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',30002.08,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3017,3666,40849,4607,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',11146.80,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-24 19:02:21','2025-05-24 19:02:21'),(3018,3666,40849,4607,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',40005.17,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3019,3666,40849,4607,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',22500.00,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3020,3666,40849,4607,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',810000.01,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3021,3666,40849,4607,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',65013.77,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3022,3666,40849,4607,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',180700.33,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3023,3666,40849,4607,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',740000.00,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3024,3666,40849,4607,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',1390000.00,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3025,3666,40849,4607,3,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',1040600.00,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3026,3666,40849,4607,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-07','2024-12-07',1248720.00,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3027,3666,40849,4607,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-09','2024-12-09',871200.00,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3028,3666,40849,4607,3,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',50005.16,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3029,3666,40849,4607,3,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',50001.36,NULL,NULL,1,'2025-05-03 12:27:36','2025-05-03 12:27:36',NULL),(3030,3666,40849,4607,3,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',40006.74,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3031,3666,40849,4607,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',65005.63,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3032,3666,40849,4607,3,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',58008.16,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL);
INSERT INTO `balance_libro` VALUES (3033,3666,40849,4607,3,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-14','2024-12-14',29000.00,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3034,3666,40849,4607,3,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-14','2024-12-14',1119.67,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3035,3666,40849,4607,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-18','2024-12-18',18889.02,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3036,3666,40849,4607,3,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',7000000.01,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3037,3666,40849,4607,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',1331000.00,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3038,3666,40849,4607,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',50000.92,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3039,3666,40849,4607,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',321640.00,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-24 19:05:08','2025-05-24 19:05:08'),(3040,3666,40849,4607,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',1032130.00,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3041,3666,40849,4607,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',18000.00,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3042,3666,40849,4607,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',60005.18,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3043,3666,40849,4607,3,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',29520.00,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3044,3666,40849,4607,3,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-22','2024-12-22',12002.41,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3045,3666,40849,4607,3,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',50001.36,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3046,3666,40849,4607,3,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',100002.72,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3047,3666,40849,4607,3,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',213475.13,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3048,3666,40849,4607,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',1694000.00,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3049,3666,40849,4607,3,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-24','2024-12-24',131640.00,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3050,3666,40849,4607,3,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-24','2024-12-24',8560000.02,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-03 12:27:37',NULL),(3051,3666,40849,4607,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',383372.04,NULL,NULL,1,'2025-05-03 12:27:37','2025-05-24 19:06:10','2025-05-24 19:06:10'),(3052,3666,40849,4607,3,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',57001.49,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL);
INSERT INTO `balance_libro` VALUES (3053,3666,40849,4607,3,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',55005.70,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3054,3666,40849,4607,3,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',60005.93,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3055,3666,40849,4607,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',8830000.00,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3056,3666,40849,4607,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',4420000.01,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3057,3666,40849,4607,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',50006.07,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3058,3666,40849,4607,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',56106.07,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3059,3666,40849,4607,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',75018.31,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3060,3666,40849,4607,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',40001.41,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3061,3666,40849,4607,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',35392392.56,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-24 19:07:45','2025-05-24 19:07:45'),(3062,3666,40849,4607,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',67012.31,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3063,3666,40849,4607,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',2460819.83,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3064,3666,40849,4607,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',5145888.00,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3065,3666,40849,4607,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',254100.00,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3066,3666,40849,4607,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',56588.02,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3067,3666,40849,4607,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',953714.78,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3068,3666,40849,4607,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',48871.91,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3069,3666,40849,4607,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',88007.92,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3070,3666,40849,4607,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',949451.21,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3071,3666,40849,4607,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2349663.83,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL),(3072,3666,40849,4607,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',709456.21,NULL,NULL,1,'2025-05-03 12:27:38','2025-05-03 12:27:38',NULL);
INSERT INTO `balance_libro` VALUES (3073,3666,40849,4606,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',48160180.20,NULL,NULL,1,'2025-05-03 12:46:57','2025-05-03 12:46:57',NULL),(3074,3666,40849,4606,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',31077500.00,NULL,NULL,1,'2025-05-03 12:46:57','2025-05-03 12:46:57',NULL),(3075,3666,40849,4606,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',65581915.93,NULL,NULL,1,'2025-05-03 12:46:57','2025-05-03 12:46:57',NULL),(3076,3666,40849,4596,1,3076,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',705000.00,'SUELDOS 01-2024',NULL,1,'2025-05-13 11:40:25','2025-05-13 11:40:25',NULL),(3077,3666,40849,4597,1,3077,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1101623.17,'SUELDOS 02-2024',NULL,1,'2025-05-13 11:42:50','2025-05-13 11:42:50',NULL),(3078,3666,40849,4598,1,3078,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',622822.46,'SUELDOS 03-2024',NULL,1,'2025-05-13 11:43:50','2025-05-13 11:43:50',NULL),(3079,3666,40849,4599,1,3079,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1537779.10,'SUELDOS 04-2024',NULL,1,'2025-05-13 11:44:49','2025-05-13 11:44:49',NULL),(3080,3666,40849,4600,1,3080,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',7380004.80,'SUELDOS 05-2024',NULL,1,'2025-05-13 11:46:06','2025-05-13 11:46:06',NULL),(3081,3666,40849,4601,1,3081,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',11528678.06,'SUELDOS 06-2024',NULL,1,'2025-05-13 11:48:07','2025-05-13 11:48:07',NULL),(3082,3666,40849,4602,1,3082,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',8217660.00,'SUELDOS 07-2024',NULL,1,'2025-05-13 11:48:52','2025-05-13 11:48:52',NULL),(3083,3666,40849,4603,1,3083,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',8913315.01,'sueldos 08-2024',NULL,1,'2025-05-13 11:50:29','2025-05-13 11:50:29',NULL),(3084,3666,40849,4604,1,3084,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',700030.00,'sueldos 09-2024',NULL,1,'2025-05-13 11:51:15','2025-05-13 11:51:15',NULL),(3085,3666,40849,4605,1,3085,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',700000.00,'sueldos 10-2024',NULL,1,'2025-05-13 11:52:09','2025-05-13 11:52:09',NULL),(3086,3666,40849,4606,1,3086,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',9958798.20,'sueldos 11-2024',NULL,1,'2025-05-13 11:53:36','2025-05-13 11:54:33','2025-05-13 11:54:33'),(3087,3666,40849,4606,1,3087,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',10486365.70,'sueldos 11-2024',NULL,1,'2025-05-13 11:54:33','2025-05-13 11:54:33',NULL),(3088,3666,40849,4607,1,3088,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4512943.37,'sueldos 12-2024',NULL,1,'2025-05-13 11:56:18','2025-05-13 11:56:18',NULL),(3089,3666,40849,4607,19,3089,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',798573.93,'SINDICATO',NULL,1,'2025-05-13 12:01:26','2025-05-13 12:01:26',NULL),(3090,3666,40849,4597,7,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',3187800.00,NULL,NULL,1,'2025-05-18 12:05:53','2025-05-18 12:05:53',NULL),(3091,3666,40849,4597,7,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',1260000.00,NULL,NULL,1,'2025-05-18 12:05:53','2025-05-18 12:05:53',NULL);
INSERT INTO `balance_libro` VALUES (3092,3666,40849,4598,7,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1501500.00,NULL,NULL,1,'2025-05-18 20:06:37','2025-05-18 20:06:37',NULL),(3093,3666,40849,4600,7,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',5255250.00,NULL,NULL,1,'2025-05-18 20:07:48','2025-05-18 20:07:48',NULL),(3094,3666,40849,4600,7,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',7875000.00,NULL,NULL,1,'2025-05-18 20:07:48','2025-05-18 20:07:48',NULL),(3095,3666,40849,4601,7,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',6930000.00,NULL,NULL,1,'2025-05-18 20:08:27','2025-05-18 20:08:27',NULL),(3096,3666,40849,4601,7,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',9009000.00,NULL,NULL,1,'2025-05-18 20:08:27','2025-05-18 20:08:27',NULL),(3097,3666,40849,4596,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',10276.28,NULL,NULL,1,'2025-05-19 09:04:38','2025-05-19 09:04:38',NULL),(3098,3666,40849,4596,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',441963.82,NULL,NULL,1,'2025-05-19 09:19:49','2025-05-19 09:19:49',NULL),(3099,3666,40849,4597,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',17978.72,NULL,NULL,1,'2025-05-19 09:23:11','2025-05-19 09:23:11',NULL),(3100,3666,40849,4597,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',2260.18,NULL,NULL,1,'2025-05-19 09:24:03','2025-05-19 09:24:03',NULL),(3101,3666,40849,4597,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',57029.52,NULL,NULL,1,'2025-05-19 09:25:30','2025-05-19 09:25:30',NULL),(3102,3666,40849,4596,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',82207.88,NULL,NULL,1,'2025-05-24 10:00:50','2025-05-24 10:00:50',NULL),(3103,3666,40849,4596,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-21','2024-01-21',82207.69,NULL,NULL,1,'2025-05-24 10:06:27','2025-05-24 10:06:27',NULL),(3104,3666,40849,4596,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',102750.75,NULL,NULL,1,'2025-05-24 10:17:13','2025-05-24 10:17:13',NULL),(3105,3666,40849,4596,3,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',139720.34,NULL,NULL,1,'2025-05-24 10:25:51','2025-05-24 10:25:51',NULL),(3106,3666,40849,4596,3,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',642161.25,NULL,NULL,1,'2025-05-24 10:44:48','2025-05-24 10:44:48',NULL),(3107,3666,40849,4596,15,1026,'App\\Models\\PeriodLiquidation',NULL,1026,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',530122.95,NULL,NULL,1,'2025-05-24 10:56:25','2025-05-24 10:56:25',NULL),(3108,3666,40849,4596,10,3108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',1947615.40,'CANCELACION IVA 2023',NULL,1,'2025-05-24 10:59:25','2025-05-28 19:45:04','2025-05-28 19:45:04'),(3109,3666,40849,4597,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',55201.86,NULL,NULL,1,'2025-05-24 12:19:49','2025-05-24 12:19:49',NULL),(3110,3666,40849,4597,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',71926.88,NULL,NULL,1,'2025-05-24 12:26:32','2025-05-24 12:26:32',NULL),(3111,3666,40849,4597,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',71925.61,NULL,NULL,1,'2025-05-24 12:28:11','2025-05-24 12:28:11',NULL);
INSERT INTO `balance_libro` VALUES (3112,3666,40849,4597,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',71924.55,NULL,NULL,1,'2025-05-24 12:37:01','2025-05-24 12:37:01',NULL),(3113,3666,40849,4597,3,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',5368.34,NULL,NULL,1,'2025-05-24 12:39:55','2025-05-24 12:39:55',NULL),(3114,3666,40849,4597,3,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',5120.38,NULL,NULL,1,'2025-05-24 12:45:38','2025-05-24 12:45:38',NULL),(3115,3666,40849,4597,3,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',30955.44,NULL,NULL,1,'2025-05-24 12:49:01','2025-05-24 12:49:01',NULL),(3116,3666,40849,4597,3,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',4346211.91,NULL,NULL,1,'2025-05-24 13:13:42','2025-05-24 13:13:42',NULL),(3117,3666,40849,4597,15,1038,'App\\Models\\PeriodLiquidation',NULL,1038,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',8895600.00,NULL,NULL,1,'2025-05-24 13:15:24','2025-05-24 13:15:24',NULL),(3118,3666,40849,4598,3,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',21281.15,NULL,NULL,1,'2025-05-24 15:45:47','2025-05-24 15:45:47',NULL),(3119,3666,40849,4598,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',107911.30,NULL,NULL,1,'2025-05-24 15:51:19','2025-05-24 15:51:19',NULL),(3120,3666,40849,4598,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2191811.23,NULL,NULL,1,'2025-05-24 15:54:40','2025-05-24 15:59:04','2025-05-24 15:59:04'),(3121,3666,40849,4598,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2036239.80,NULL,NULL,1,'2025-05-24 16:03:39','2025-05-24 16:03:39',NULL),(3122,3666,40849,4598,15,1048,'App\\Models\\PeriodLiquidation',NULL,1048,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',3003000.00,NULL,NULL,1,'2025-05-24 16:12:26','2025-05-24 16:12:26',NULL),(3123,3666,40849,4599,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',68116.87,NULL,NULL,1,'2025-05-24 16:28:09','2025-05-24 16:28:09',NULL),(3124,3666,40849,4599,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',86254.01,NULL,NULL,1,'2025-05-24 16:29:48','2025-05-24 16:29:48',NULL),(3125,3666,40849,4599,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',9042.60,NULL,NULL,1,'2025-05-24 16:33:10','2025-05-24 16:33:10',NULL),(3126,3666,40849,4599,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',84286.44,NULL,NULL,1,'2025-05-24 16:36:21','2025-05-24 16:36:21',NULL),(3127,3666,40849,4599,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',108198.49,NULL,NULL,1,'2025-05-24 16:37:24','2025-05-24 16:37:24',NULL),(3128,3666,40849,4599,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',13972.03,NULL,NULL,1,'2025-05-24 16:38:12','2025-05-24 16:38:12',NULL),(3129,3666,40849,4599,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3809864.48,NULL,NULL,1,'2025-05-24 16:44:20','2025-05-24 16:44:20',NULL),(3130,3666,40849,4599,15,1059,'App\\Models\\PeriodLiquidation',NULL,1059,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1422564.69,NULL,NULL,1,'2025-05-24 16:48:23','2025-05-24 16:48:23',NULL),(3131,3666,40849,4600,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',1532815.62,NULL,NULL,1,'2025-05-24 16:55:11','2025-05-24 17:06:21','2025-05-24 17:06:21');
INSERT INTO `balance_libro` VALUES (3132,3666,40849,4600,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',1849.24,NULL,NULL,1,'2025-05-24 16:55:46','2025-05-24 16:55:46',NULL),(3133,3666,40849,4600,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',579942.12,NULL,NULL,1,'2025-05-24 16:56:49','2025-05-24 16:56:49',NULL),(3134,3666,40849,4600,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',79114.27,NULL,NULL,1,'2025-05-24 16:57:27','2025-05-24 16:57:27',NULL),(3135,3666,40849,4600,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',1273873.23,NULL,NULL,1,'2025-05-24 17:06:21','2025-05-24 17:06:21',NULL),(3136,3666,40849,4600,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',1172540.71,NULL,NULL,1,'2025-05-24 17:14:29','2025-05-24 17:14:29',NULL),(3137,3666,40849,4600,15,1068,'App\\Models\\PeriodLiquidation',NULL,1068,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',26260500.00,NULL,NULL,1,'2025-05-24 17:16:00','2025-05-24 17:16:00',NULL),(3138,3666,40849,4601,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',339987.15,NULL,NULL,1,'2025-05-24 17:18:43','2025-05-24 17:18:43',NULL),(3139,3666,40849,4601,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',119659.16,NULL,NULL,1,'2025-05-24 17:20:11','2025-05-24 17:20:11',NULL),(3140,3666,40849,4601,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',87380.91,NULL,NULL,1,'2025-05-24 17:20:43','2025-05-24 17:20:43',NULL),(3141,3666,40849,4601,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',82223.26,NULL,NULL,1,'2025-05-24 17:28:04','2025-05-24 17:28:04',NULL),(3142,3666,40849,4601,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',50001.54,NULL,NULL,1,'2025-05-24 17:36:18','2025-05-24 17:36:18',NULL),(3143,3666,40849,4601,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',3730311.77,NULL,NULL,1,'2025-05-24 17:39:43','2025-05-24 17:39:43',NULL),(3144,3666,40849,4601,15,1077,'App\\Models\\PeriodLiquidation',NULL,1077,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',31878000.00,NULL,NULL,1,'2025-05-24 17:42:49','2025-05-24 17:42:49',NULL),(3145,3666,40849,4602,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',324633.07,NULL,NULL,1,'2025-05-24 17:47:57','2025-05-24 17:47:57',NULL),(3146,3666,40849,4602,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',22500.23,NULL,NULL,1,'2025-05-24 17:51:10','2025-05-24 17:51:10',NULL),(3147,3666,40849,4602,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2040968.88,NULL,NULL,1,'2025-05-24 17:54:08','2025-05-24 17:54:08',NULL),(3148,3666,40849,4602,15,1081,'App\\Models\\PeriodLiquidation',NULL,1081,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2530370.11,NULL,NULL,1,'2025-05-24 17:54:50','2025-05-24 17:54:50',NULL),(3149,3666,40849,4603,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',60000.00,NULL,NULL,1,'2025-05-24 18:00:09','2025-05-24 18:00:09',NULL),(3150,3666,40849,4603,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',200309.95,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3151,3666,40849,4603,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',19500.00,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL);
INSERT INTO `balance_libro` VALUES (3152,3666,40849,4603,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',370000.00,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3153,3666,40849,4603,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',118265.08,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3154,3666,40849,4603,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',11000.00,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3155,3666,40849,4603,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',251314.86,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3156,3666,40849,4603,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',64990.16,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3157,3666,40849,4603,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',6400000.00,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3158,3666,40849,4603,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',251450.01,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3159,3666,40849,4603,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',201029.94,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3160,3666,40849,4603,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',2932.37,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3161,3666,40849,4603,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',12000.01,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3162,3666,40849,4603,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',4219800.00,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3163,3666,40849,4603,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',6400000.00,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3164,3666,40849,4603,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',6400000.00,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3165,3666,40849,4603,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-22','2024-08-22',41440.31,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3166,3666,40849,4603,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-24','2024-08-24',303650.01,NULL,NULL,1,'2025-05-24 18:00:10','2025-05-24 18:00:10',NULL),(3167,3666,40849,4603,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-24','2024-08-24',28000.06,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3168,3666,40849,4603,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-24','2024-08-24',66819.56,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3169,3666,40849,4603,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-24','2024-08-24',53000.00,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3170,3666,40849,4603,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',82227.52,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:07:27','2025-05-24 18:07:27'),(3171,3666,40849,4603,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',25003.33,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL);
INSERT INTO `balance_libro` VALUES (3172,3666,40849,4603,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',27859923.30,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3173,3666,40849,4603,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',1500400.00,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3174,3666,40849,4603,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',2503.76,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3175,3666,40849,4603,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',251860.01,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3176,3666,40849,4603,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',1249999.99,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3177,3666,40849,4603,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',258643.45,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3178,3666,40849,4603,3,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',24004.64,NULL,NULL,1,'2025-05-24 18:00:11','2025-05-24 18:00:11',NULL),(3179,3666,40849,4603,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',82227.52,NULL,NULL,1,'2025-05-24 18:07:27','2025-05-24 18:07:27',NULL),(3180,3666,40849,4603,3,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',98490.39,NULL,NULL,1,'2025-05-24 18:09:47','2025-05-24 18:09:47',NULL),(3181,3666,40849,4603,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1058523.38,NULL,NULL,1,'2025-05-24 18:14:20','2025-05-24 18:14:20',NULL),(3182,3666,40849,4603,15,1088,'App\\Models\\PeriodLiquidation',NULL,1088,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',8323242.98,NULL,NULL,1,'2025-05-24 18:15:21','2025-05-24 18:15:21',NULL),(3183,3666,40849,4604,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',491927.10,NULL,NULL,1,'2025-05-24 18:19:15','2025-05-24 18:19:15',NULL),(3184,3666,40849,4604,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',49313.06,NULL,NULL,1,'2025-05-24 18:22:02','2025-05-24 18:22:02',NULL),(3185,3666,40849,4604,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1239774.93,NULL,NULL,1,'2025-05-24 18:24:16','2025-05-24 18:24:16',NULL),(3186,3666,40849,4604,15,1093,'App\\Models\\PeriodLiquidation',NULL,1093,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',8803693.70,NULL,NULL,1,'2025-05-24 18:28:35','2025-05-24 18:28:35',NULL),(3187,3666,40849,4605,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',6852.45,NULL,NULL,1,'2025-05-24 18:32:06','2025-05-24 18:32:06',NULL),(3188,3666,40849,4605,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',68123.92,NULL,NULL,1,'2025-05-24 18:33:26','2025-05-24 18:33:26',NULL),(3189,3666,40849,4605,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',10479.02,NULL,NULL,1,'2025-05-24 18:35:29','2025-05-24 18:35:29',NULL),(3190,3666,40849,4605,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',4111.36,NULL,NULL,1,'2025-05-24 18:37:31','2025-05-24 18:37:31',NULL),(3191,3666,40849,4605,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2213190.95,NULL,NULL,1,'2025-05-24 18:40:30','2025-05-24 18:40:30',NULL);
INSERT INTO `balance_libro` VALUES (3192,3666,40849,4605,15,1102,'App\\Models\\PeriodLiquidation',NULL,1102,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',10867909.89,NULL,NULL,1,'2025-05-24 18:42:00','2025-05-24 18:42:00',NULL),(3193,3666,40849,4606,7,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',2625000.00,NULL,NULL,1,'2025-05-24 18:49:00','2025-05-24 18:49:00',NULL),(3194,3666,40849,4606,7,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',4067910.00,NULL,NULL,1,'2025-05-24 18:49:00','2025-05-24 18:49:00',NULL),(3195,3666,40849,4606,7,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',5539458.75,NULL,NULL,1,'2025-05-24 18:49:11','2025-05-24 18:49:11',NULL),(3196,3666,40849,4606,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',4036656.05,NULL,NULL,1,'2025-05-24 18:54:58','2025-05-24 18:54:58',NULL),(3197,3666,40849,4606,15,1109,'App\\Models\\PeriodLiquidation',NULL,1109,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',26193198.26,NULL,NULL,1,'2025-05-24 18:57:14','2025-05-24 18:57:14',NULL),(3198,3666,40849,4607,7,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',5950586.25,NULL,NULL,1,'2025-05-24 19:00:52','2025-05-24 19:00:52',NULL),(3199,3666,40849,4607,7,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',5492103.75,NULL,NULL,1,'2025-05-24 19:00:53','2025-05-24 19:00:53',NULL),(3200,3666,40849,4607,7,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',5386631.25,NULL,NULL,1,'2025-05-24 19:00:53','2025-05-24 19:00:53',NULL),(3201,3666,40849,4607,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',11146.81,NULL,NULL,1,'2025-05-24 19:02:21','2025-05-24 19:02:21',NULL),(3202,3666,40849,4607,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',330438.58,NULL,NULL,1,'2025-05-24 19:05:08','2025-05-24 19:05:08',NULL),(3203,3666,40849,4607,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',383372.04,NULL,NULL,1,'2025-05-24 19:06:10','2025-05-24 19:06:10',NULL),(3204,3666,40849,4607,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',35392392.56,NULL,NULL,1,'2025-05-24 19:07:45','2025-05-24 19:07:45',NULL),(3205,3666,40849,4607,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',751836.66,NULL,NULL,1,'2025-05-24 19:16:39','2025-05-24 19:22:35','2025-05-24 19:22:35'),(3206,3666,40849,4607,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',751836.66,NULL,NULL,1,'2025-05-24 19:22:35','2025-05-24 19:22:35',NULL),(3207,3666,40849,4607,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',968157.47,NULL,NULL,1,'2025-05-24 19:25:16','2025-05-24 19:25:16',NULL),(3208,3666,40849,4607,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',957857.92,NULL,NULL,1,'2025-05-24 19:27:07','2025-05-24 19:27:07',NULL),(3209,3666,40849,4607,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',733531.77,NULL,NULL,1,'2025-05-24 19:28:47','2025-05-24 19:28:47',NULL),(3210,3666,40849,4607,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',818779.32,NULL,NULL,1,'2025-05-24 19:30:43','2025-05-24 19:30:43',NULL),(3211,3666,40849,4607,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',973307.24,NULL,NULL,1,'2025-05-24 19:32:13','2025-05-24 19:32:13',NULL);
INSERT INTO `balance_libro` VALUES (3212,3666,40849,4607,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',820453.43,NULL,NULL,1,'2025-05-24 19:33:48','2025-05-24 19:33:48',NULL),(3213,3666,40849,4607,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',896060.63,NULL,NULL,1,'2025-05-24 19:35:28','2025-05-24 19:35:28',NULL),(3214,3666,40849,4607,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',837808.30,NULL,NULL,1,'2025-05-24 19:37:21','2025-05-24 19:37:21',NULL),(3215,3666,40849,4607,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',758701.92,NULL,NULL,1,'2025-05-24 19:39:11','2025-05-24 19:39:11',NULL),(3216,3666,40849,4607,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',298960.38,NULL,NULL,1,'2025-05-24 19:40:37','2025-05-24 19:40:37',NULL),(3217,3666,40849,4607,3,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',746717.19,NULL,NULL,1,'2025-05-24 19:42:27','2025-05-24 19:42:27',NULL),(3218,3666,40849,4607,3,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',806454.58,NULL,NULL,1,'2025-05-24 19:44:20','2025-05-24 19:44:20',NULL),(3219,3666,40849,4607,3,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',36601.84,NULL,NULL,1,'2025-05-24 19:46:39','2025-05-24 19:46:39',NULL),(3220,3666,40849,4607,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',806288.99,NULL,NULL,1,'2025-05-24 20:00:33','2025-05-24 20:00:33',NULL),(3221,3666,40849,4607,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',179006.40,NULL,NULL,1,'2025-05-24 20:02:25','2025-05-24 20:02:25',NULL),(3222,3666,40849,4607,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',7132309.85,NULL,NULL,1,'2025-05-24 20:05:00','2025-05-24 20:05:00',NULL),(3223,3666,40849,4607,15,1137,'App\\Models\\PeriodLiquidation',NULL,1137,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',47199042.68,NULL,NULL,1,'2025-05-24 20:06:41','2025-05-24 20:06:41',NULL),(3224,3666,40849,4596,20,3224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',5000000.00,'COBRANZA 01-2024',NULL,1,'2025-05-28 18:44:13','2025-05-28 18:44:13',NULL),(3225,3666,40849,4596,21,2409,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2409,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2434229.36,NULL,NULL,1,'2025-05-28 19:01:52','2025-05-28 19:01:52',NULL),(3226,3666,40849,4596,16,1025,'App\\Models\\PeriodLiquidation',NULL,1025,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',24678.81,NULL,NULL,1,'2025-05-28 19:23:37','2025-05-28 19:31:11','2025-05-28 19:31:11'),(3227,3666,40849,4596,7,3227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',122500.00,'IIBB RET BANCARIAS 01-2024',NULL,1,'2025-05-28 19:35:47','2025-08-26 13:32:16','2025-08-26 13:32:16'),(3228,3666,40849,4596,22,3228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',36232.49,'COMISIONES BANCARIAS + IVA 01-2024',NULL,1,'2025-05-28 19:38:19','2025-05-28 19:38:19',NULL),(3229,3666,40849,4596,22,3229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',58359.74,'LEY 25.413 01-2024',NULL,1,'2025-05-28 19:39:46','2025-05-28 19:39:46',NULL),(3230,3666,40849,4596,10,3230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',63459.40,'PAGOS AFIP',NULL,1,'2025-05-28 19:42:45','2025-05-28 19:42:45',NULL);
INSERT INTO `balance_libro` VALUES (3231,3666,40849,4596,10,3231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',1947615.55,'CANCELACION IVA 2023',NULL,1,'2025-05-28 19:45:04','2025-05-28 19:45:04',NULL),(3232,3666,40849,4596,16,1025,'App\\Models\\PeriodLiquidation',NULL,1025,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',24678.81,NULL,NULL,1,'2025-05-28 19:55:00','2025-08-26 12:50:50','2025-08-26 12:50:50'),(3233,3666,40849,4597,16,1037,'App\\Models\\PeriodLiquidation',NULL,1037,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',157577.06,NULL,NULL,1,'2025-05-28 19:57:10','2025-05-28 20:00:19','2025-05-28 20:00:19'),(3234,3666,40849,4597,16,1037,'App\\Models\\PeriodLiquidation',NULL,1037,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',157577.06,NULL,NULL,1,'2025-05-28 20:00:32','2025-05-28 21:13:05','2025-05-28 21:13:05'),(3235,3666,40849,4597,20,2418,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2418,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',14917200.00,NULL,NULL,1,'2025-05-28 20:55:42','2025-05-28 20:57:14','2025-05-28 20:57:14'),(3236,3666,40849,4597,20,2419,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2419,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',14917200.00,NULL,NULL,1,'2025-05-28 21:00:06','2025-05-28 21:00:06',NULL),(3237,3666,40849,4597,20,2420,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2420,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',37740516.00,NULL,NULL,1,'2025-05-28 21:10:07','2025-05-28 21:10:07',NULL),(3238,3666,40849,4596,16,3238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',122500.00,'AJUSTE IIBB 01-2024',NULL,1,'2025-05-28 21:19:09','2025-08-26 13:33:24','2025-08-26 13:33:24'),(3239,3666,40849,4597,16,1037,'App\\Models\\PeriodLiquidation',NULL,1037,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',157576.25,NULL,NULL,1,'2025-05-28 21:22:58','2025-05-28 21:24:37','2025-05-28 21:24:37'),(3240,3666,40849,4597,22,3240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',840604.94,'IIBB RET BANCARIAS 02-2024',NULL,1,'2025-05-28 21:26:32','2025-05-28 21:50:23','2025-05-28 21:50:23'),(3241,3666,40849,4597,16,1037,'App\\Models\\PeriodLiquidation',NULL,1037,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',157576.25,NULL,NULL,1,'2025-05-28 21:42:38','2025-08-26 12:51:01','2025-08-26 12:51:01'),(3242,3666,40849,4597,22,3242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',972578.29,'IIBB RET BANCARIAS 02-2024',NULL,1,'2025-05-28 21:50:23','2025-05-28 21:50:23',NULL),(3243,3666,40849,4597,16,3243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',2374695.10,'AJUSTE IIBB MNES 02-2024',NULL,1,'2025-05-28 21:55:53','2025-05-28 21:55:53',NULL),(3244,3666,40849,4597,22,3244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',40000.00,'DEPOSITO EN EFECTIVO',NULL,1,'2025-05-28 21:57:50','2025-05-28 21:57:50',NULL),(3245,3666,40849,4597,22,3245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',20576.19,'COMISIONES BANCARIAS + IVA 02-2024',NULL,1,'2025-05-28 22:01:45','2025-05-28 22:21:20','2025-05-28 22:21:20'),(3246,3666,40849,4597,22,3246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',245275.03,'LEY 25.413 02-2024',NULL,1,'2025-05-28 22:02:43','2025-05-28 22:02:43',NULL),(3247,3666,40849,4597,21,2421,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2421,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',3105417.49,NULL,NULL,1,'2025-05-28 22:11:08','2025-05-28 22:11:08',NULL),(3248,3666,40849,4597,21,3248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',1491501.35,'PAGO INTERES PRESTAMOS IFAI',NULL,1,'2025-05-28 22:15:21','2025-05-28 22:15:21',NULL);
INSERT INTO `balance_libro` VALUES (3249,3666,40849,4597,21,3249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',750410.77,'PAGO INTERES PRESTAMOS IFAI',NULL,1,'2025-05-28 22:16:19','2025-05-28 22:16:19',NULL),(3250,3666,40849,4597,21,3250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',22355635.16,'PAGO INTERES y PRESTAMOS IFAI',NULL,1,'2025-05-28 22:18:12','2025-05-28 22:18:12',NULL),(3251,3666,40849,4597,22,3251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',20756.19,'COMISIONES BANCARIAS + IVA 02-2024',NULL,1,'2025-05-28 22:21:21','2025-05-28 22:21:21',NULL),(3252,3666,40849,4598,22,3252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',1000000.00,'ACREDITACION CHEQUES',NULL,1,'2025-05-29 08:50:39','2025-05-29 08:50:39',NULL),(3253,3666,40849,4598,21,3253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',46259.13,'COMISIONES BANCARIAS + IVA 03-2024',NULL,1,'2025-05-29 08:54:37','2025-05-29 08:54:37',NULL),(3254,3666,40849,4598,21,3254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',29197.66,'LEY 25.413 03-2024',NULL,1,'2025-05-29 08:56:02','2025-05-29 08:56:02',NULL),(3255,3666,40849,4598,21,3255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',24500.00,'IIBB RET BANCARIAS 03-2024',NULL,1,'2025-05-29 08:57:36','2025-05-29 08:57:36',NULL),(3256,3666,40849,4598,21,2422,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2422,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1095563.33,NULL,NULL,1,'2025-05-29 09:08:26','2025-05-29 09:08:26',NULL),(3257,3666,40849,4598,21,2423,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2423,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',642161.25,NULL,NULL,1,'2025-05-29 09:09:31','2025-05-29 09:09:31',NULL),(3258,3666,40849,4598,21,2424,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2424,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',5120.38,NULL,NULL,1,'2025-05-29 09:10:50','2025-05-29 09:10:50',NULL),(3259,3666,40849,4598,21,2425,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2425,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',516170.00,NULL,NULL,1,'2025-05-29 09:16:10','2025-05-29 09:16:10',NULL),(3260,3666,40849,4598,21,2426,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2426,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',146837.40,NULL,NULL,1,'2025-05-29 09:17:15','2025-05-29 09:17:15',NULL),(3261,3666,40849,4598,21,2427,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2427,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',142783.94,NULL,NULL,1,'2025-05-29 09:19:32','2025-05-29 09:19:32',NULL),(3262,3666,40849,4598,21,2428,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2428,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',738913.30,NULL,NULL,1,'2025-05-29 09:20:59','2025-05-29 09:20:59',NULL),(3263,3666,40849,4598,21,2429,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2429,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',20429.64,NULL,NULL,1,'2025-05-29 09:25:07','2025-05-29 09:25:07',NULL),(3264,3666,40849,4598,21,2430,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2430,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',36720.77,NULL,NULL,1,'2025-05-29 09:26:56','2025-05-29 09:26:56',NULL),(3265,3666,40849,4598,21,2431,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2431,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',19400.00,NULL,NULL,1,'2025-05-29 09:27:38','2025-05-29 09:27:38',NULL),(3266,3666,40849,4598,21,2432,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2432,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',12792.13,NULL,NULL,1,'2025-05-29 09:28:26','2025-05-29 09:28:26',NULL),(3267,3666,40849,4598,21,2433,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2433,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',47560.00,NULL,NULL,1,'2025-05-29 09:29:35','2025-05-29 09:29:35',NULL);
INSERT INTO `balance_libro` VALUES (3268,3666,40849,4598,21,2434,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2434,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',44597.58,NULL,NULL,1,'2025-05-29 09:30:48','2025-05-29 09:30:48',NULL),(3269,3666,40849,4598,21,2435,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2435,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',11032.67,NULL,NULL,1,'2025-05-29 09:31:21','2025-05-29 09:31:21',NULL),(3270,3666,40849,4598,21,2436,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2436,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',21300.00,NULL,NULL,1,'2025-05-29 09:32:03','2025-05-29 09:32:03',NULL),(3271,3666,40849,4598,21,2437,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2437,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',47607.48,NULL,NULL,1,'2025-05-29 09:33:13','2025-05-29 09:33:13',NULL),(3272,3666,40849,4598,21,2438,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2438,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',7800.00,NULL,NULL,1,'2025-05-29 09:33:43','2025-05-29 09:33:43',NULL),(3273,3666,40849,4598,21,2439,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2439,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',40801.26,NULL,NULL,1,'2025-05-29 09:34:36','2025-05-29 09:34:36',NULL),(3274,3666,40849,4598,21,2440,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2440,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',58357.01,NULL,NULL,1,'2025-05-29 09:35:43','2025-05-29 09:35:43',NULL),(3275,3666,40849,4598,21,2441,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2441,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',40459.98,NULL,NULL,1,'2025-05-29 09:37:15','2025-05-29 09:37:15',NULL),(3276,3666,40849,4598,21,2442,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2442,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',42075.00,NULL,NULL,1,'2025-05-29 09:37:50','2025-05-29 09:37:50',NULL),(3277,3666,40849,4598,21,2443,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2443,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',25496.53,NULL,NULL,1,'2025-05-29 09:38:39','2025-05-29 09:38:39',NULL),(3278,3666,40849,4598,21,2444,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2444,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',29767.76,NULL,NULL,1,'2025-05-29 09:40:59','2025-05-29 09:40:59',NULL),(3279,3666,40849,4598,16,1047,'App\\Models\\PeriodLiquidation',NULL,1047,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2535743.87,NULL,NULL,1,'2025-05-29 09:43:44','2025-08-26 12:51:14','2025-08-26 12:51:14'),(3280,3666,40849,4598,20,2445,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2445,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',1974830.00,NULL,NULL,1,'2025-05-29 09:48:07','2025-05-29 09:48:07',NULL),(3281,3666,40849,4598,16,3281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',497830.00,'AJUSTE IIBB 03-2024',NULL,1,'2025-05-29 09:51:25','2025-05-29 09:51:25',NULL),(3282,3666,40849,4599,22,3282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',2000000.00,'ACREDITACION CHEQUES',NULL,1,'2025-05-29 09:55:19','2025-05-29 09:55:19',NULL),(3283,3666,40849,4599,21,3283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',58333.00,'COMISIONES BANCARIAS + IVA 04-2024',NULL,1,'2025-05-29 09:56:56','2025-05-29 09:56:56',NULL),(3284,3666,40849,4599,21,3284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',27677.37,'LEY 25.413 04-2024',NULL,1,'2025-05-29 09:57:54','2025-05-29 09:57:54',NULL),(3285,3666,40849,4599,7,3285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',49000.00,'IIBB RET BANCARIAS 04-2024',NULL,1,'2025-05-29 10:02:08','2025-05-29 10:02:08',NULL),(3286,3666,40849,4599,21,2446,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2446,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3303621.04,NULL,NULL,1,'2025-05-29 10:05:24','2025-05-29 10:06:51','2025-05-29 10:06:51');
INSERT INTO `balance_libro` VALUES (3287,3666,40849,4599,21,2447,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2447,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3203620.87,NULL,NULL,1,'2025-05-29 10:09:18','2025-05-29 10:09:18',NULL),(3288,3666,40849,4599,21,2448,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2448,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',28.86,NULL,NULL,1,'2025-05-29 10:11:49','2025-05-29 10:11:49',NULL),(3289,3666,40849,4599,21,2449,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2449,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',30955.44,NULL,NULL,1,'2025-05-29 10:12:36','2025-05-29 10:12:36',NULL),(3290,3666,40849,4599,21,2450,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2450,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',21600.00,NULL,NULL,1,'2025-05-29 10:18:45','2025-05-29 10:18:45',NULL),(3291,3666,40849,4599,21,2451,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2451,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',16431.57,NULL,NULL,1,'2025-05-29 10:20:46','2025-05-29 10:20:46',NULL),(3292,3666,40849,4599,16,1058,'App\\Models\\PeriodLiquidation',NULL,1058,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3043783.57,NULL,NULL,1,'2025-05-29 10:21:54','2025-08-26 12:51:23','2025-08-26 12:51:23'),(3293,3666,40849,4599,16,3293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',49000.00,'AJUSTE IIBB 04-2024',NULL,1,'2025-05-29 10:22:48','2025-05-29 10:22:48',NULL),(3294,3666,40849,4600,21,3294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',34794.50,'COMISIONES BANCARIAS + IVA 05-2024',NULL,1,'2025-05-29 10:38:20','2025-05-29 10:38:20',NULL),(3295,3666,40849,4600,21,3295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',179319.32,'LEY 25.413 05-2024',NULL,1,'2025-05-29 10:39:53','2025-05-29 10:39:53',NULL),(3296,3666,40849,4600,7,3296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',612500.00,'IIBB RET BANCARIAS 05-2024',NULL,1,'2025-05-29 10:41:20','2025-05-29 10:41:20',NULL),(3297,3666,40849,4600,21,2452,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2452,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',688014.99,NULL,NULL,1,'2025-05-29 10:50:01','2025-05-29 10:50:01',NULL),(3298,3666,40849,4600,21,2453,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2453,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',523300.00,NULL,NULL,1,'2025-05-29 10:51:17','2025-05-29 10:51:17',NULL),(3299,3666,40849,4600,21,2454,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2454,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',250708.59,NULL,NULL,1,'2025-05-29 10:52:08','2025-05-29 10:52:08',NULL),(3300,3666,40849,4600,21,2455,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2455,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',174218.14,NULL,NULL,1,'2025-05-29 10:53:02','2025-05-29 10:53:02',NULL),(3301,3666,40849,4600,21,2456,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2456,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1595907.61,NULL,NULL,1,'2025-05-29 10:54:36','2025-05-29 10:54:36',NULL),(3302,3666,40849,4600,21,2457,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2457,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',133400.00,NULL,NULL,1,'2025-05-29 10:55:38','2025-05-29 10:55:38',NULL),(3303,3666,40849,4600,21,2458,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2458,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',207500.06,NULL,NULL,1,'2025-05-29 10:56:51','2025-05-29 10:56:51',NULL),(3304,3666,40849,4600,21,2459,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2459,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',21659.00,NULL,NULL,1,'2025-05-29 10:57:26','2025-05-29 10:57:26',NULL),(3305,3666,40849,4600,21,2460,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2460,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',141772.64,NULL,NULL,1,'2025-05-29 10:58:41','2025-05-29 10:58:41',NULL);
INSERT INTO `balance_libro` VALUES (3306,3666,40849,4600,21,2461,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2461,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',247752.51,NULL,NULL,1,'2025-05-29 10:59:18','2025-05-29 10:59:18',NULL),(3307,3666,40849,4600,21,2462,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2462,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',146199.99,NULL,NULL,1,'2025-05-29 11:00:49','2025-05-29 11:00:49',NULL),(3308,3666,40849,4600,21,2463,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2463,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',102850.00,NULL,NULL,1,'2025-05-29 11:01:55','2025-05-29 11:01:55',NULL),(3309,3666,40849,4600,21,2464,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2464,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',4700.00,NULL,NULL,1,'2025-05-29 11:02:45','2025-05-29 11:02:45',NULL),(3310,3666,40849,4600,21,2465,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2465,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1273.63,NULL,NULL,1,'2025-05-29 11:03:41','2025-05-29 11:03:41',NULL),(3311,3666,40849,4600,20,2466,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2466,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',20357500.00,NULL,NULL,1,'2025-05-29 11:15:58','2025-05-29 11:18:27','2025-05-29 11:18:27'),(3312,3666,40849,4600,20,2467,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2467,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',20357500.00,NULL,NULL,1,'2025-05-29 11:21:14','2025-05-29 11:21:14',NULL),(3313,3666,40849,4600,20,2468,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2468,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',21911905.00,NULL,NULL,1,'2025-05-29 11:23:10','2025-05-29 11:23:10',NULL),(3314,3666,40849,4600,16,1067,'App\\Models\\PeriodLiquidation',NULL,1067,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',3151195.74,NULL,NULL,1,'2025-05-29 11:26:31','2025-08-26 12:51:31','2025-08-26 12:51:31'),(3315,3666,40849,4600,16,3315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',4751655.00,'AJUSTE IIBB 05-2024',NULL,1,'2025-05-29 11:28:52','2025-05-29 11:28:52',NULL),(3316,3666,40849,4601,21,3316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',38192.95,'COMISIONES BANCARIAS + IVA 06-2024',NULL,1,'2025-05-29 11:34:26','2025-05-29 11:34:26',NULL),(3317,3666,40849,4601,21,3317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',161884.29,'LEY 25.413 06-2024',NULL,1,'2025-05-29 11:35:14','2025-05-29 11:35:14',NULL),(3318,3666,40849,4601,7,3318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',245000.00,'IIBB RET BANCARIAS 06-2024',NULL,1,'2025-05-29 11:36:25','2025-05-29 11:36:25',NULL),(3319,3666,40849,4601,21,2469,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2469,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',12302000.09,NULL,NULL,1,'2025-05-29 11:38:04','2025-05-29 11:38:04',NULL),(3320,3666,40849,4601,21,2470,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2470,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1330902.75,NULL,NULL,1,'2025-05-29 11:38:46','2025-05-29 11:38:46',NULL),(3321,3666,40849,4601,21,2471,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2471,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',2456658.26,NULL,NULL,1,'2025-05-29 11:39:21','2025-05-29 11:39:21',NULL),(3322,3666,40849,4601,21,2472,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2472,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',500000.00,NULL,NULL,1,'2025-05-29 11:40:25','2025-05-29 11:40:25',NULL),(3323,3666,40849,4601,21,2473,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2473,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',107800.00,NULL,NULL,1,'2025-05-29 11:42:46','2025-05-29 11:42:46',NULL),(3324,3666,40849,4601,21,2474,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2474,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',94.80,NULL,NULL,1,'2025-05-29 11:43:40','2025-05-29 11:43:40',NULL);
INSERT INTO `balance_libro` VALUES (3325,3666,40849,4601,21,2475,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2475,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',63.65,NULL,NULL,1,'2025-05-29 11:45:22','2025-05-29 11:45:22',NULL),(3326,3666,40849,4601,20,2476,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2476,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',16848980.00,NULL,NULL,1,'2025-05-29 11:54:22','2025-05-29 11:54:22',NULL),(3327,3666,40849,4601,20,2477,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2477,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',14114600.00,NULL,NULL,1,'2025-05-29 11:56:18','2025-05-29 11:56:18',NULL),(3328,3666,40849,4601,16,1076,'App\\Models\\PeriodLiquidation',NULL,1076,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',7921762.97,NULL,NULL,1,'2025-05-29 11:58:03','2025-08-26 12:51:37','2025-08-26 12:51:37'),(3329,3666,40849,4601,16,3329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',5269580.00,'AJUSTE IIBB 06-2024',NULL,1,'2025-05-29 11:59:55','2025-05-29 11:59:55',NULL),(3330,3666,40849,4602,21,3330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',125307.00,'COMISIONES BANCARIAS + IVA 07-2024',NULL,1,'2025-05-29 12:48:39','2025-05-29 12:48:39',NULL),(3331,3666,40849,4602,21,3331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',147582.38,'LEY 25.413 07-2024',NULL,1,'2025-05-29 12:50:34','2025-05-29 12:50:34',NULL),(3332,3666,40849,4602,7,3332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',295986.00,'IIBB RET BANCARIAS 07-2024',NULL,1,'2025-05-29 12:52:03','2025-05-29 12:52:03',NULL),(3333,3666,40849,4602,21,2478,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2478,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',479826.84,NULL,NULL,1,'2025-05-29 12:55:19','2025-05-29 12:55:19',NULL),(3334,3666,40849,4602,21,2479,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2479,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',57400.00,NULL,NULL,1,'2025-05-29 12:56:16','2025-05-29 12:56:16',NULL),(3335,3666,40849,4602,21,2480,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2480,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',612362.80,NULL,NULL,1,'2025-05-29 12:57:40','2025-05-29 12:57:40',NULL),(3336,3666,40849,4602,21,2481,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2481,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',11015200.00,NULL,NULL,1,'2025-05-29 12:58:15','2025-05-29 12:58:15',NULL),(3337,3666,40849,4602,21,2482,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2482,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',11000.00,NULL,NULL,1,'2025-05-29 13:00:54','2025-05-29 13:00:54',NULL),(3338,3666,40849,4602,21,2483,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2483,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1966.71,NULL,NULL,1,'2025-05-29 13:02:28','2025-05-29 13:02:28',NULL),(3339,3666,40849,4602,16,1080,'App\\Models\\PeriodLiquidation',NULL,1080,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',13203001.04,NULL,NULL,1,'2025-05-29 13:42:02','2025-08-26 12:51:48','2025-08-26 12:51:48'),(3340,3666,40849,4602,16,3340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',295986.00,'AJUSTE IIBB 07-2024',NULL,1,'2025-05-29 13:45:16','2025-05-29 13:45:16',NULL),(3341,3666,40849,4598,20,2484,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2484,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',15801500.00,NULL,NULL,1,'2025-05-29 17:22:40','2025-05-29 17:22:40',NULL),(3342,3666,40849,4602,22,3342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',6000000.00,'ACREDITACION CHEQUES',NULL,1,'2025-05-29 17:25:48','2025-05-29 17:25:48',NULL),(3343,3666,40849,4602,22,3343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',5000000.00,'ACREDITACION CHEQUES',NULL,1,'2025-05-29 17:27:24','2025-05-29 17:27:24',NULL);
INSERT INTO `balance_libro` VALUES (3344,3666,40849,4602,22,3344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',1000000.00,'ACREDITACION CHEQUES',NULL,1,'2025-05-29 17:28:08','2025-05-29 17:28:08',NULL),(3345,3666,40849,4600,20,2485,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2485,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',36437500.00,NULL,NULL,1,'2025-05-29 17:48:54','2025-05-29 17:48:54',NULL),(3346,3666,40849,4600,20,2486,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2486,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',36437500.00,NULL,NULL,1,'2025-05-29 17:49:45','2025-05-29 17:49:45',NULL),(3347,3666,40849,4600,20,2487,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2487,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',40305250.00,NULL,NULL,1,'2025-05-29 18:02:26','2025-05-29 18:02:26',NULL),(3348,3666,40849,4601,20,2488,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2488,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',89809000.00,NULL,NULL,1,'2025-05-29 18:07:00','2025-05-29 18:07:00',NULL),(3349,3666,40849,4601,20,2489,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2489,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',65745400.00,NULL,NULL,1,'2025-05-29 18:10:16','2025-05-29 18:10:16',NULL),(3350,3666,40849,4603,21,3350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',46802.60,'COMISIONES BANCARIAS + IVA 08-2024',NULL,1,'2025-05-29 18:13:35','2025-05-29 18:13:35',NULL),(3351,3666,40849,4603,21,3351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',400177.37,'LEY 25.413 08-2024',NULL,1,'2025-05-29 18:14:41','2025-05-29 18:14:41',NULL),(3352,3666,40849,4603,7,3352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1207850.00,'IIBB RET BANCARIAS 08-2024',NULL,1,'2025-05-29 18:16:25','2025-05-29 18:16:25',NULL),(3353,3666,40849,4603,21,2490,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2490,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',10610961.06,NULL,NULL,1,'2025-05-29 18:18:59','2025-05-29 18:21:08','2025-05-29 18:21:08'),(3354,3666,40849,4603,21,2491,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2491,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',3949360.00,NULL,NULL,1,'2025-05-29 18:20:55','2025-05-29 18:20:55',NULL),(3355,3666,40849,4603,21,2492,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2492,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',10610961.06,NULL,NULL,1,'2025-05-29 18:22:00','2025-05-29 18:22:00',NULL),(3356,3666,40849,4603,21,2493,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2493,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',790000.00,NULL,NULL,1,'2025-05-29 18:24:11','2025-05-29 18:24:11',NULL),(3357,3666,40849,4603,21,2494,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2494,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',719204.02,NULL,NULL,1,'2025-05-29 18:25:08','2025-05-29 18:25:08',NULL),(3358,3666,40849,4603,21,2495,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2495,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',71390.53,NULL,NULL,1,'2025-05-29 18:26:40','2025-05-29 18:26:40',NULL),(3359,3666,40849,4603,21,2496,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2496,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',659.39,NULL,NULL,1,'2025-05-29 18:28:59','2025-05-29 18:28:59',NULL),(3360,3666,40849,4603,22,3360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',4500000.00,'ACREDITACION CHEQUES',NULL,1,'2025-05-29 18:33:11','2025-05-29 18:33:11',NULL),(3361,3666,40849,4603,22,3361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',5000000.00,'ACREDITACION CHEQUES',NULL,1,'2025-05-29 18:34:09','2025-05-29 18:34:09',NULL),(3362,3666,40849,4603,19,3362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',67800000.00,'PRESTAMO IFAI',NULL,1,'2025-05-29 18:44:08','2025-05-29 18:44:08',NULL);
INSERT INTO `balance_libro` VALUES (3363,3666,40849,4603,16,1087,'App\\Models\\PeriodLiquidation',NULL,1087,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',13503873.77,NULL,NULL,1,'2025-05-29 18:46:20','2025-08-26 12:51:57','2025-08-26 12:51:57'),(3364,3666,40849,4603,16,3364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1207850.00,'AJUSTE IIBB 08-2024',NULL,1,'2025-05-29 18:47:45','2025-05-29 18:47:45',NULL),(3365,3666,40849,4604,21,3365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',44321.30,'COMISIONES BANCARIAS + IVA 09-2024',NULL,1,'2025-05-29 18:50:13','2025-05-29 18:50:13',NULL),(3366,3666,40849,4604,21,3366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',59958.08,'LEY 25.413 09-2024',NULL,1,'2025-05-29 18:51:27','2025-05-29 18:51:27',NULL),(3367,3666,40849,4604,21,2497,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2497,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1435500.00,NULL,NULL,1,'2025-05-29 18:56:06','2025-05-29 18:56:06',NULL),(3368,3666,40849,4604,21,2498,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2498,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6339687.07,NULL,NULL,1,'2025-05-29 18:57:19','2025-05-29 18:57:19',NULL),(3369,3666,40849,4604,21,2499,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2499,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',68380.84,NULL,NULL,1,'2025-05-29 18:58:01','2025-05-29 18:58:01',NULL),(3370,3666,40849,4604,21,2500,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2500,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',47294.36,NULL,NULL,1,'2025-05-29 18:58:32','2025-05-29 18:58:32',NULL),(3371,3666,40849,4604,21,2501,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2501,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',179720.42,NULL,NULL,1,'2025-05-29 18:59:18','2025-05-29 18:59:18',NULL),(3372,3666,40849,4604,21,2502,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2502,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',5675.05,NULL,NULL,1,'2025-05-29 18:59:48','2025-05-29 18:59:48',NULL),(3373,3666,40849,4604,21,2503,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2503,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',17202.39,NULL,NULL,1,'2025-05-29 19:00:17','2025-05-29 19:00:17',NULL),(3374,3666,40849,4604,21,2504,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2504,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',441963.82,NULL,NULL,1,'2025-05-29 19:01:04','2025-05-29 19:01:04',NULL),(3375,3666,40849,4604,21,2505,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2505,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',321500.00,NULL,NULL,1,'2025-05-29 19:01:47','2025-05-29 19:01:47',NULL),(3376,3666,40849,4604,21,2506,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2506,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',398453.00,NULL,NULL,1,'2025-05-29 19:02:50','2025-05-29 19:02:50',NULL),(3377,3666,40849,4604,21,2507,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2507,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',36000.00,NULL,NULL,1,'2025-05-29 19:04:47','2025-05-29 19:04:47',NULL),(3378,3666,40849,4604,21,2508,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2508,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',213300.32,NULL,NULL,1,'2025-05-29 19:05:12','2025-05-29 19:05:12',NULL),(3379,3666,40849,4604,21,2509,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2509,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',76520.20,NULL,NULL,1,'2025-05-29 19:05:53','2025-05-29 19:05:53',NULL),(3380,3666,40849,4604,21,2510,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2510,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',126300.00,NULL,NULL,1,'2025-05-29 19:06:44','2025-05-29 19:06:44',NULL),(3381,3666,40849,4604,21,2511,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2511,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',169128.61,NULL,NULL,1,'2025-05-29 19:07:22','2025-05-29 19:07:22',NULL);
INSERT INTO `balance_libro` VALUES (3382,3666,40849,4604,21,2512,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2512,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',41440.31,NULL,NULL,1,'2025-05-29 19:09:30','2025-05-29 19:09:30',NULL),(3383,3666,40849,4604,21,2513,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2513,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',12000.01,NULL,NULL,1,'2025-05-29 19:10:04','2025-05-29 19:10:04',NULL),(3384,3666,40849,4604,21,2514,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2514,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',18350.00,NULL,NULL,1,'2025-05-29 19:11:05','2025-05-29 19:11:05',NULL),(3385,3666,40849,4604,21,2515,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2515,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',273.60,NULL,NULL,1,'2025-05-29 19:13:16','2025-05-29 19:13:16',NULL),(3386,3666,40849,4604,7,3386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1088.66,'IIBB RET BANCARIAS 09-2024',NULL,1,'2025-05-29 19:14:57','2025-05-29 19:14:57',NULL),(3387,3666,40849,4604,16,1092,'App\\Models\\PeriodLiquidation',NULL,1092,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',14726135.36,NULL,NULL,1,'2025-05-29 19:16:28','2025-08-26 12:52:05','2025-08-26 12:52:05'),(3388,3666,40849,4604,16,3388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1088.66,'AJUSTE IIBB 09-2024',NULL,1,'2025-05-29 19:18:29','2025-05-29 19:18:29',NULL),(3389,3666,40849,4605,21,3389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',7312.90,'COMISIONES BANCARIAS + IVA 10-2024',NULL,1,'2025-05-29 19:21:40','2025-05-29 19:21:40',NULL),(3390,3666,40849,4605,21,3390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',10093.14,'LEY 25.413 10-2024',NULL,1,'2025-05-29 19:22:59','2025-05-29 19:22:59',NULL),(3391,3666,40849,4605,21,2516,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2516,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1500400.00,NULL,NULL,1,'2025-05-29 19:26:23','2025-05-29 19:26:23',NULL),(3392,3666,40849,4605,21,2517,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2517,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2020076.27,NULL,NULL,1,'2025-05-29 19:30:30','2025-05-29 19:30:30',NULL),(3393,3666,40849,4605,21,2518,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2518,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',740000.00,NULL,NULL,1,'2025-05-29 19:33:44','2025-05-29 19:33:44',NULL),(3394,3666,40849,4605,21,2519,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2519,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',500000.00,NULL,NULL,1,'2025-05-29 19:35:17','2025-05-29 19:35:17',NULL),(3395,3666,40849,4605,21,2520,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2520,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',120000.00,NULL,NULL,1,'2025-05-29 19:36:42','2025-05-29 19:36:42',NULL),(3396,3666,40849,4605,21,2521,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2521,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',16513.82,NULL,NULL,1,'2025-05-29 19:40:31','2025-05-29 19:40:31',NULL),(3397,3666,40849,4605,16,1101,'App\\Models\\PeriodLiquidation',NULL,1101,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',14729608.88,NULL,NULL,1,'2025-05-29 19:42:30','2025-08-26 12:52:12','2025-08-26 12:52:12'),(3398,3666,40849,4606,21,3398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',54923.30,'COMISIONES BANCARIAS + IVA 11-2024',NULL,1,'2025-05-29 19:45:32','2025-05-29 19:45:32',NULL),(3399,3666,40849,4606,21,3399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',74319.44,'LEY 25.413 11-2024',NULL,1,'2025-05-29 19:46:32','2025-05-29 19:46:32',NULL),(3400,3666,40849,4606,7,3400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',1198.22,'IIBB RET BANCARIAS 11-2024',NULL,1,'2025-05-29 19:48:24','2025-05-29 19:48:24',NULL);
INSERT INTO `balance_libro` VALUES (3401,3666,40849,4606,21,2522,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2522,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',11524000.02,NULL,NULL,1,'2025-05-29 19:51:08','2025-05-29 19:51:08',NULL),(3402,3666,40849,4606,21,2523,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2523,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',731411.37,NULL,NULL,1,'2025-05-29 19:52:52','2025-05-29 19:52:52',NULL),(3403,3666,40849,4606,21,2524,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2524,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',63694.91,NULL,NULL,1,'2025-05-29 19:54:05','2025-05-29 19:54:05',NULL),(3404,3666,40849,4606,21,2525,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2525,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',10479.02,NULL,NULL,1,'2025-05-29 19:54:57','2025-05-29 19:54:57',NULL),(3405,3666,40849,4606,21,2526,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2526,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2062.68,NULL,NULL,1,'2025-05-29 19:56:03','2025-05-29 19:56:03',NULL),(3406,3666,40849,4606,20,2527,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2527,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',48107095.90,NULL,NULL,1,'2025-05-29 20:11:19','2025-05-29 20:11:19',NULL),(3407,3666,40849,4606,20,2528,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2528,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',31077500.00,NULL,NULL,1,'2025-05-29 20:14:16','2025-05-29 20:14:16',NULL),(3408,3666,40849,4606,20,2529,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2529,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',65581915.93,NULL,NULL,1,'2025-05-29 20:22:19','2025-05-29 20:22:19',NULL),(3409,3666,40849,4606,16,1108,'App\\Models\\PeriodLiquidation',NULL,1108,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',14729608.88,NULL,NULL,1,'2025-05-29 20:24:17','2025-08-26 12:52:20','2025-08-26 12:52:20'),(3410,3666,40849,4606,16,3410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',3856108.63,'AJUSTE IIBB 11-2024',NULL,1,'2025-05-29 20:26:00','2025-05-29 20:26:00',NULL),(3411,3666,40849,4607,21,3411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1020956.05,'COMISIONES BANCARIAS + IVA 12-2024',NULL,1,'2025-05-29 20:30:26','2025-05-29 20:30:26',NULL),(3412,3666,40849,4607,21,3412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',744761.89,'LEY 25.413 12-2024',NULL,1,'2025-05-29 20:31:10','2025-05-29 20:31:10',NULL),(3413,3666,40849,4607,7,3413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2700481.55,'IIBB RET BANCARIAS 12-2024',NULL,1,'2025-05-29 20:40:28','2025-05-29 20:40:28',NULL),(3414,3666,40849,4607,21,2530,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2530,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',10091400.00,NULL,NULL,1,'2025-05-29 20:41:55','2025-05-29 20:41:55',NULL),(3415,3666,40849,4607,21,2531,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2531,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1032130.00,NULL,NULL,1,'2025-05-29 20:42:40','2025-05-29 20:42:40',NULL),(3416,3666,40849,4607,21,2532,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2532,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',150000.05,NULL,NULL,1,'2025-05-29 20:44:39','2025-05-29 20:44:39',NULL),(3417,3666,40849,4607,21,2533,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2533,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',18500.10,NULL,NULL,1,'2025-05-29 20:45:31','2025-05-29 20:45:31',NULL),(3418,3666,40849,4607,21,2534,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2534,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',38.48,NULL,NULL,1,'2025-05-29 20:47:33','2025-05-29 20:47:33',NULL),(3419,3666,40849,4607,22,3419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',52965153.57,'ACREDITACION CHEQUES KABOUR',NULL,1,'2025-05-29 20:50:50','2025-05-29 20:50:50',NULL);
INSERT INTO `balance_libro` VALUES (3420,3666,40849,4607,20,2535,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2535,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',63772583.88,NULL,NULL,1,'2025-05-29 21:01:10','2025-05-29 21:01:10',NULL),(3421,3666,40849,4607,22,3421,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',44000000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2025-05-29 21:05:23','2025-05-29 21:05:23',NULL),(3422,3666,40849,4607,22,3422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',44000000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2025-05-29 21:06:10','2025-05-29 21:06:10',NULL),(3423,3666,40849,4607,20,2536,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2536,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',65021277.83,NULL,NULL,1,'2025-05-29 21:12:22','2025-05-29 21:44:31','2025-05-29 21:44:31'),(3424,3666,40849,4607,20,2537,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2537,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',70449273.98,NULL,NULL,1,'2025-05-29 21:16:38','2025-05-29 21:44:40','2025-05-29 21:44:40'),(3425,3666,40849,4607,16,1136,'App\\Models\\PeriodLiquidation',NULL,1136,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',19866049.06,NULL,NULL,1,'2025-05-29 21:18:49','2025-08-26 12:52:26','2025-08-26 12:52:26'),(3426,3666,40849,4607,16,3426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',6698842.49,'AJUSTE IIBB 12-2024',NULL,1,'2025-05-29 21:34:19','2025-05-29 21:34:19',NULL),(3427,3666,40849,4607,20,2538,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2538,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',65021277.83,NULL,NULL,1,'2025-05-29 21:47:40','2025-05-29 21:47:40',NULL),(3428,3666,40849,4607,20,2539,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2539,NULL,NULL,NULL,0,NULL,'2024-12-24','2024-12-24',70449273.98,NULL,NULL,1,'2025-05-29 21:50:58','2025-05-29 21:50:58',NULL),(3429,3666,40849,4607,3,3429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',177701800.00,'COMPRA YERBA CANCHADA',NULL,1,'2025-05-30 12:41:11','2025-05-30 12:41:11',NULL),(3430,3666,40849,4607,11,3430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',69466495.65,'GASTOS VS 12-2024',NULL,1,'2025-05-30 17:16:17','2025-05-30 17:16:17',NULL),(3431,3666,40849,4607,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',161335251.82,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-05-30 17:35:04','2025-05-30 17:42:44','2025-05-30 17:42:44'),(3432,3666,40849,4607,21,3432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',40659811.44,'AJUSTE PAGOS DE SUELDOS',NULL,1,'2025-05-31 10:25:08','2025-05-31 10:25:08',NULL),(3433,3666,40849,4607,11,3433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',64027155.70,'AJUSTE DS X VTAS COMUNES 12-2024',NULL,1,'2025-05-31 10:26:31','2025-05-31 10:26:31',NULL),(3434,3666,40849,4607,16,3434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',18015932.82,'AJUSTE PERC IIBB MNES A DEPOSITAR',NULL,1,'2025-05-31 10:29:23','2025-05-31 10:29:23',NULL),(3435,3666,40849,4607,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',161327732.29,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-05-31 11:46:11','2025-05-31 14:23:55','2025-05-31 14:23:55'),(3436,3666,40849,4607,4,3436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',913679.13,'AMORTIZACION EDIFICIO',NULL,1,'2025-05-31 11:54:46','2025-05-31 11:54:46',NULL),(3437,3666,40849,4607,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',7519.53,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-05-31 13:47:18','2025-05-31 14:23:55','2025-05-31 14:23:55');
INSERT INTO `balance_libro` VALUES (3438,3666,40849,4607,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',161335251.82,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-05-31 14:25:42','2025-08-26 20:00:09','2025-08-26 20:00:09'),(3439,3666,40720,1590,12,3439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',450489864.69,'ASIENTO REAPERTURA EJ N° 85',NULL,1,'2025-06-03 18:15:49','2025-06-03 18:15:49',NULL),(3440,3666,40720,1590,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',22896.83,NULL,NULL,1,'2025-06-03 18:20:37','2025-06-03 18:20:37',NULL),(3441,3666,40720,1590,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',27209.27,NULL,NULL,1,'2025-06-03 18:20:37','2025-06-03 18:20:37',NULL),(3442,3666,40720,1590,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1459.26,NULL,NULL,1,'2025-06-03 18:20:37','2025-06-03 18:20:37',NULL),(3443,3666,40720,1590,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',36429.47,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3444,3666,40720,1590,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',76317.12,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3445,3666,40720,1590,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1459.26,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3446,3666,40720,1590,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',41817.60,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3447,3666,40720,1590,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',48400.00,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3448,3666,40720,1590,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',41817.60,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3449,3666,40720,1590,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',76317.12,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3450,3666,40720,1590,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',2918.52,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3451,3666,40720,1590,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',31460.00,NULL,NULL,1,'2025-06-03 18:20:38','2025-06-03 18:20:38',NULL),(3452,3666,40720,1591,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',36429.47,NULL,NULL,1,'2025-06-03 18:25:10','2025-06-03 18:25:10',NULL),(3453,3666,40720,1591,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',41817.60,NULL,NULL,1,'2025-06-03 18:25:10','2025-06-03 18:25:10',NULL),(3454,3666,40720,1591,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',48400.00,NULL,NULL,1,'2025-06-03 18:25:10','2025-06-03 18:25:10',NULL),(3455,3666,40720,1591,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',41817.60,NULL,NULL,1,'2025-06-03 18:25:10','2025-06-03 18:25:10',NULL),(3456,3666,40720,1591,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',22896.83,NULL,NULL,1,'2025-06-03 18:25:10','2025-06-03 18:25:10',NULL),(3457,3666,40720,1591,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',27209.27,NULL,NULL,1,'2025-06-03 18:25:10','2025-06-03 18:25:10',NULL);
INSERT INTO `balance_libro` VALUES (3458,3666,40720,1591,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',31460.00,NULL,NULL,1,'2025-06-03 18:25:10','2025-06-03 18:25:10',NULL),(3459,3666,40720,1592,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',22896.83,NULL,NULL,1,'2025-06-03 18:25:27','2025-06-03 18:25:27',NULL),(3460,3666,40720,1592,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',27209.27,NULL,NULL,1,'2025-06-03 18:25:27','2025-06-03 18:25:27',NULL),(3461,3666,40720,1592,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',41817.60,NULL,NULL,1,'2025-06-03 18:25:27','2025-06-03 18:25:27',NULL),(3462,3666,40720,1592,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',48400.00,NULL,NULL,1,'2025-06-03 18:25:27','2025-06-03 18:25:27',NULL),(3463,3666,40720,1592,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',41817.60,NULL,NULL,1,'2025-06-03 18:25:27','2025-06-03 18:25:27',NULL),(3464,3666,40720,1592,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',36429.47,NULL,NULL,1,'2025-06-03 18:25:28','2025-06-03 18:25:28',NULL),(3465,3666,40720,1592,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',31460.00,NULL,NULL,1,'2025-06-03 18:25:28','2025-06-03 18:25:28',NULL),(3466,3666,40720,1592,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',181500.00,NULL,NULL,1,'2025-06-03 18:25:28','2025-06-03 18:25:28',NULL),(3467,3666,40720,1593,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',41817.60,NULL,NULL,1,'2025-06-03 18:25:39','2025-06-03 18:25:39',NULL),(3468,3666,40720,1593,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',48400.00,NULL,NULL,1,'2025-06-03 18:25:39','2025-06-03 18:25:39',NULL),(3469,3666,40720,1593,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',22896.83,NULL,NULL,1,'2025-06-03 18:25:39','2025-06-03 18:25:39',NULL),(3470,3666,40720,1593,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',41817.60,NULL,NULL,1,'2025-06-03 18:25:39','2025-06-03 18:25:39',NULL),(3471,3666,40720,1593,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',27209.27,NULL,NULL,1,'2025-06-03 18:25:39','2025-06-03 18:25:39',NULL),(3472,3666,40720,1593,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',181500.00,NULL,NULL,1,'2025-06-03 18:25:39','2025-06-03 18:25:39',NULL),(3473,3666,40720,1593,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',36429.47,NULL,NULL,1,'2025-06-03 18:25:40','2025-06-03 18:25:40',NULL),(3474,3666,40720,1593,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',31460.00,NULL,NULL,1,'2025-06-03 18:25:40','2025-06-03 18:25:40',NULL),(3475,3666,40720,1594,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',41817.60,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3476,3666,40720,1594,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',48400.00,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3477,3666,40720,1594,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',41817.60,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3478,3666,40720,1594,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',181500.00,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL);
INSERT INTO `balance_libro` VALUES (3479,3666,40720,1594,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',22896.83,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3480,3666,40720,1594,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',27209.27,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3481,3666,40720,1594,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',36429.47,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3482,3666,40720,1594,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',22896.83,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3483,3666,40720,1594,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',22896.83,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3484,3666,40720,1594,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',31460.00,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3485,3666,40720,1594,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',181500.00,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3486,3666,40720,1594,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',30250.00,NULL,NULL,1,'2025-06-03 18:27:26','2025-06-03 18:27:26',NULL),(3487,3666,40720,1595,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',22896.83,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3488,3666,40720,1595,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',27209.27,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3489,3666,40720,1595,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',36429.47,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3490,3666,40720,1595,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',41817.60,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3491,3666,40720,1595,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',48400.00,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3492,3666,40720,1595,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',41817.60,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3493,3666,40720,1595,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',211750.00,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3494,3666,40720,1595,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',31460.00,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3495,3666,40720,1595,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',68970.00,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3496,3666,40720,1595,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',68970.00,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3497,3666,40720,1595,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',68970.00,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3498,3666,40720,1595,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',175982.40,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL),(3499,3666,40720,1595,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',68970.00,NULL,NULL,1,'2025-06-03 18:27:47','2025-06-03 18:27:47',NULL);
INSERT INTO `balance_libro` VALUES (3500,3666,40720,1596,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',211750.00,NULL,NULL,1,'2025-06-03 18:28:15','2025-06-03 18:28:15',NULL),(3501,3666,40720,1596,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',36429.47,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3502,3666,40720,1596,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',22896.83,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3503,3666,40720,1596,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',27209.27,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3504,3666,40720,1596,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',217800.00,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3505,3666,40720,1596,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',117370.00,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3506,3666,40720,1596,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',41817.60,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3507,3666,40720,1596,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',31460.00,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3508,3666,40720,1596,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',242000.00,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3509,3666,40720,1596,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',242000.00,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3510,3666,40720,1596,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',38720.00,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3511,3666,40720,1596,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',38720.00,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3512,3666,40720,1596,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',38720.00,NULL,NULL,1,'2025-06-03 18:28:16','2025-06-03 18:28:16',NULL),(3513,3666,40720,1597,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',27209.27,NULL,NULL,1,'2025-06-03 18:28:32','2025-06-03 18:28:32',NULL),(3514,3666,40720,1597,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',242000.00,NULL,NULL,1,'2025-06-03 18:28:32','2025-06-03 18:28:32',NULL),(3515,3666,40720,1597,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',211750.00,NULL,NULL,1,'2025-06-03 18:28:33','2025-06-03 18:28:33',NULL),(3516,3666,40720,1597,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',217800.00,NULL,NULL,1,'2025-06-03 18:28:33','2025-06-03 18:28:33',NULL),(3517,3666,40720,1597,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',117370.00,NULL,NULL,1,'2025-06-03 18:28:33','2025-06-03 18:28:33',NULL),(3518,3666,40720,1597,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',36429.47,NULL,NULL,1,'2025-06-03 18:28:33','2025-06-03 18:28:33',NULL),(3519,3666,40720,1597,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',22896.83,NULL,NULL,1,'2025-06-03 18:28:33','2025-06-03 18:28:33',NULL),(3520,3666,40720,1597,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',41817.60,NULL,NULL,1,'2025-06-03 18:28:33','2025-06-03 18:28:33',NULL);
INSERT INTO `balance_libro` VALUES (3521,3666,40720,1597,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',70180.00,NULL,NULL,1,'2025-06-03 18:28:33','2025-06-03 18:28:33',NULL),(3522,3666,40720,1598,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',36429.47,NULL,NULL,1,'2025-06-03 18:29:04','2025-06-03 18:29:04',NULL),(3523,3666,40720,1598,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',22896.83,NULL,NULL,1,'2025-06-03 18:29:04','2025-06-03 18:29:04',NULL),(3524,3666,40720,1598,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',266200.00,NULL,NULL,1,'2025-06-03 18:29:04','2025-06-03 18:29:04',NULL),(3525,3666,40720,1598,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',211750.00,NULL,NULL,1,'2025-06-03 18:29:04','2025-06-03 18:29:04',NULL),(3526,3666,40720,1598,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',239580.00,NULL,NULL,1,'2025-06-03 18:29:04','2025-06-03 18:29:04',NULL),(3527,3666,40720,1598,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',117370.00,NULL,NULL,1,'2025-06-03 18:29:04','2025-06-03 18:29:04',NULL),(3528,3666,40720,1598,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',41817.60,NULL,NULL,1,'2025-06-03 18:29:05','2025-06-03 18:29:05',NULL),(3529,3666,40720,1598,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',27209.27,NULL,NULL,1,'2025-06-03 18:29:05','2025-06-03 18:29:05',NULL),(3530,3666,40720,1598,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',70180.00,NULL,NULL,1,'2025-06-03 18:29:05','2025-06-03 18:29:05',NULL),(3531,3666,40720,1602,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',266200.00,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3532,3666,40720,1602,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',211750.00,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3533,3666,40720,1602,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',239580.00,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3534,3666,40720,1602,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',117370.00,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3535,3666,40720,1602,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',41817.60,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3536,3666,40720,1602,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',27209.27,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3537,3666,40720,1602,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',36429.47,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3538,3666,40720,1602,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',22896.83,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3539,3666,40720,1602,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',70180.00,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3540,3666,40720,1602,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',9937.73,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3541,3666,40720,1602,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',28586.25,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL);
INSERT INTO `balance_libro` VALUES (3542,3666,40720,1602,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',150469.55,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3543,3666,40720,1602,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',195840.92,NULL,NULL,1,'2025-06-03 18:30:04','2025-06-03 18:30:04',NULL),(3544,3666,40720,1602,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',178016.41,NULL,NULL,1,'2025-06-03 18:30:05','2025-06-03 18:30:05',NULL),(3545,3666,40720,1602,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',27209.27,NULL,NULL,1,'2025-06-03 18:30:05','2025-06-03 18:30:05',NULL),(3546,3666,40720,1602,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',36429.47,NULL,NULL,1,'2025-06-03 18:30:05','2025-06-03 18:30:05',NULL),(3547,3666,40720,1602,2,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',22896.83,NULL,NULL,1,'2025-06-03 18:30:05','2025-06-03 18:30:05',NULL),(3548,3666,40720,1603,2,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-14','2025-02-14',150469.55,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3549,3666,40720,1603,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-14','2025-02-14',195840.92,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3550,3666,40720,1603,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-14','2025-02-14',178016.41,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3551,3666,40720,1603,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-14','2025-02-14',9937.73,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3552,3666,40720,1603,2,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-14','2025-02-14',28586.25,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3553,3666,40720,1603,2,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',157300.00,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3554,3666,40720,1603,2,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',266200.00,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3555,3666,40720,1603,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',239580.00,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3556,3666,40720,1603,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',96800.00,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3557,3666,40720,1603,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',239580.00,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3558,3666,40720,1603,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',70180.00,NULL,NULL,1,'2025-06-03 18:30:35','2025-06-03 18:30:35',NULL),(3559,3666,40720,1604,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',195840.92,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3560,3666,40720,1604,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',178016.41,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3561,3666,40720,1604,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',9937.73,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3562,3666,40720,1604,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',28586.25,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL);
INSERT INTO `balance_libro` VALUES (3563,3666,40720,1604,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',150469.55,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3564,3666,40720,1604,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',266200.00,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3565,3666,40720,1604,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',262570.00,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3566,3666,40720,1604,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',239580.00,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3567,3666,40720,1604,2,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',157300.00,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3568,3666,40720,1604,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',100000.00,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3569,3666,40720,1604,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-09','2025-03-09',217000.00,NULL,NULL,1,'2025-06-03 18:30:59','2025-06-03 18:30:59',NULL),(3570,3666,40720,1591,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',51344.01,NULL,NULL,1,'2025-06-03 18:40:30','2025-06-04 18:05:12','2025-06-04 18:05:12'),(3571,3666,40720,1591,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',165682.00,NULL,NULL,1,'2025-06-03 18:40:30','2025-06-04 18:05:12','2025-06-04 18:05:12'),(3572,3666,40720,1591,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',130000.00,NULL,NULL,1,'2025-06-03 18:40:30','2025-06-04 18:05:11','2025-06-04 18:05:11'),(3573,3666,40720,1591,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',114000.00,NULL,NULL,1,'2025-06-03 18:40:30','2025-06-04 18:05:11','2025-06-04 18:05:11'),(3574,3666,40720,1591,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',14999.99,NULL,NULL,1,'2025-06-03 18:40:30','2025-06-04 18:05:10','2025-06-04 18:05:10'),(3575,3666,40720,1592,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',59429.89,NULL,NULL,1,'2025-06-03 18:41:10','2025-06-04 18:32:01','2025-06-04 18:32:01'),(3576,3666,40720,1592,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',22500.00,NULL,NULL,1,'2025-06-03 18:41:10','2025-06-04 18:32:00','2025-06-04 18:32:00'),(3577,3666,40720,1592,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',84000.00,NULL,NULL,1,'2025-06-03 18:41:10','2025-06-04 18:31:59','2025-06-04 18:31:59'),(3578,3666,40720,1592,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',165682.00,NULL,NULL,1,'2025-06-03 18:41:10','2025-06-04 18:31:58','2025-06-04 18:31:58'),(3579,3666,40720,1593,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',58002.50,NULL,NULL,1,'2025-06-03 18:41:34','2025-06-04 18:31:57','2025-06-04 18:31:57'),(3580,3666,40720,1593,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',168000.00,NULL,NULL,1,'2025-06-03 18:41:34','2025-06-04 18:31:56','2025-06-04 18:31:56'),(3581,3666,40720,1593,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',22500.00,NULL,NULL,1,'2025-06-03 18:41:34','2025-06-04 18:31:55','2025-06-04 18:31:55');
INSERT INTO `balance_libro` VALUES (3582,3666,40720,1593,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6000.00,NULL,NULL,1,'2025-06-03 18:41:34','2025-06-04 18:31:55','2025-06-04 18:31:55'),(3583,3666,40720,1593,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',165682.00,NULL,NULL,1,'2025-06-03 18:41:34','2025-06-04 18:31:54','2025-06-04 18:31:54'),(3584,3666,40720,1594,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',74002.98,NULL,NULL,1,'2025-06-03 18:41:56','2025-06-04 18:31:53','2025-06-04 18:31:53'),(3585,3666,40720,1594,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',1137.11,NULL,NULL,1,'2025-06-03 18:41:56','2025-06-04 18:31:52','2025-06-04 18:31:52'),(3586,3666,40720,1594,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',1680000.00,NULL,NULL,1,'2025-06-03 18:41:56','2025-06-04 18:31:51','2025-06-04 18:31:51'),(3587,3666,40720,1594,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',24000.00,NULL,NULL,1,'2025-06-03 18:41:56','2025-06-04 18:31:50','2025-06-04 18:31:50'),(3588,3666,40720,1594,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',6000.00,NULL,NULL,1,'2025-06-03 18:41:56','2025-06-04 18:31:48','2025-06-04 18:31:48'),(3589,3666,40720,1594,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',22500.00,NULL,NULL,1,'2025-06-03 18:41:56','2025-06-04 18:31:47','2025-06-04 18:31:47'),(3590,3666,40720,1594,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',165682.00,NULL,NULL,1,'2025-06-03 18:41:56','2025-06-04 18:31:46','2025-06-04 18:31:46'),(3591,3666,40720,1595,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',37500.00,NULL,NULL,1,'2025-06-03 18:42:16','2025-06-04 18:31:45','2025-06-04 18:31:45'),(3592,3666,40720,1595,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',86382.75,NULL,NULL,1,'2025-06-03 18:42:16','2025-06-04 18:31:44','2025-06-04 18:31:44'),(3593,3666,40720,1595,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',168000.00,NULL,NULL,1,'2025-06-03 18:42:17','2025-06-04 18:31:43','2025-06-04 18:31:43'),(3594,3666,40720,1595,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',1680000.00,NULL,NULL,1,'2025-06-03 18:42:17','2025-06-04 18:31:42','2025-06-04 18:31:42'),(3595,3666,40720,1595,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',24000.00,NULL,NULL,1,'2025-06-03 18:42:17','2025-06-04 18:31:41','2025-06-04 18:31:41'),(3596,3666,40720,1595,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',22500.00,NULL,NULL,1,'2025-06-03 18:42:17','2025-06-04 18:31:40','2025-06-04 18:31:40'),(3597,3666,40720,1595,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6000.00,NULL,NULL,1,'2025-06-03 18:42:17','2025-06-04 18:31:39','2025-06-04 18:31:39'),(3598,3666,40720,1595,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',331364.00,NULL,NULL,1,'2025-06-03 18:42:17','2025-06-04 18:31:38','2025-06-04 18:31:38'),(3599,3666,40720,1596,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',82800.00,NULL,NULL,1,'2025-06-03 18:42:35','2025-06-04 18:31:37','2025-06-04 18:31:37'),(3600,3666,40720,1596,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',40000.99,NULL,NULL,1,'2025-06-03 18:42:35','2025-06-04 18:31:37','2025-06-04 18:31:37');
INSERT INTO `balance_libro` VALUES (3601,3666,40720,1596,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',60000.00,NULL,NULL,1,'2025-06-03 18:42:35','2025-06-04 18:31:36','2025-06-04 18:31:36'),(3602,3666,40720,1596,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',60000.00,NULL,NULL,1,'2025-06-03 18:42:35','2025-06-04 18:31:36','2025-06-04 18:31:36'),(3603,3666,40720,1596,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',83460.20,NULL,NULL,1,'2025-06-03 18:42:35','2025-06-04 18:31:35','2025-06-04 18:31:35'),(3604,3666,40720,1596,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',98000.00,NULL,NULL,1,'2025-06-03 18:42:36','2025-06-04 18:31:34','2025-06-04 18:31:34'),(3605,3666,40720,1596,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',28000.01,NULL,NULL,1,'2025-06-03 18:42:36','2025-06-04 18:31:34','2025-06-04 18:31:34'),(3606,3666,40720,1596,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',7500.00,NULL,NULL,1,'2025-06-03 18:42:36','2025-06-04 18:31:33','2025-06-04 18:31:33'),(3607,3666,40720,1596,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',28000.01,NULL,NULL,1,'2025-06-03 18:42:36','2025-06-04 18:31:33','2025-06-04 18:31:33'),(3608,3666,40720,1596,3,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',331364.00,NULL,NULL,1,'2025-06-03 18:42:36','2025-06-04 18:31:32','2025-06-04 18:31:32'),(3609,3666,40720,1597,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-17','2024-11-17',87316.10,NULL,NULL,1,'2025-06-03 18:43:02','2025-06-04 18:31:32','2025-06-04 18:31:32'),(3610,3666,40720,1597,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-19','2024-11-19',94700.00,NULL,NULL,1,'2025-06-03 18:43:02','2025-06-04 18:31:31','2025-06-04 18:31:31'),(3611,3666,40720,1597,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',28000.01,NULL,NULL,1,'2025-06-03 18:43:02','2025-06-04 18:31:30','2025-06-04 18:31:30'),(3612,3666,40720,1597,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',28000.01,NULL,NULL,1,'2025-06-03 18:43:02','2025-06-04 18:31:30','2025-06-04 18:31:30'),(3613,3666,40720,1597,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',7500.00,NULL,NULL,1,'2025-06-03 18:43:02','2025-06-04 18:31:29','2025-06-04 18:31:29'),(3614,3666,40720,1597,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',331364.00,NULL,NULL,1,'2025-06-03 18:43:02','2025-06-04 18:31:29','2025-06-04 18:31:29'),(3615,3666,40720,1598,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',86074.38,NULL,NULL,1,'2025-06-03 18:43:28','2025-06-04 18:31:28','2025-06-04 18:31:28'),(3616,3666,40720,1598,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',28000.01,NULL,NULL,1,'2025-06-03 18:43:28','2025-06-04 18:31:28','2025-06-04 18:31:28'),(3617,3666,40720,1598,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',28000.01,NULL,NULL,1,'2025-06-03 18:43:28','2025-06-04 18:31:27','2025-06-04 18:31:27'),(3618,3666,40720,1598,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',28000.01,NULL,NULL,1,'2025-06-03 18:43:28','2025-06-04 18:31:27','2025-06-04 18:31:27'),(3619,3666,40720,1598,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',331364.00,NULL,NULL,1,'2025-06-03 18:43:28','2025-06-04 18:31:26','2025-06-04 18:31:26');
INSERT INTO `balance_libro` VALUES (3620,3666,40720,1602,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',92520.97,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-11 11:32:34','2025-06-11 11:32:34'),(3621,3666,40720,1602,3,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',28000.01,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3622,3666,40720,1602,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',28000.01,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3623,3666,40720,1602,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',155741.77,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3624,3666,40720,1602,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',156850.12,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3625,3666,40720,1602,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',200000.00,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3626,3666,40720,1602,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-30','2025-01-30',28000.01,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3627,3666,40720,1602,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',7500.00,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3628,3666,40720,1602,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',28000.01,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3629,3666,40720,1602,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',331364.00,NULL,NULL,1,'2025-06-03 18:43:53','2025-06-03 18:43:53',NULL),(3630,3666,40720,1603,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',118399.51,NULL,NULL,1,'2025-06-03 18:44:11','2025-06-11 11:52:36','2025-06-11 11:52:36'),(3631,3666,40720,1603,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',424400.00,NULL,NULL,1,'2025-06-03 18:44:11','2025-06-03 18:44:11',NULL),(3632,3666,40720,1603,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',28000.01,NULL,NULL,1,'2025-06-03 18:44:11','2025-06-03 18:44:11',NULL),(3633,3666,40720,1603,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',7500.00,NULL,NULL,1,'2025-06-03 18:44:12','2025-06-03 18:44:12',NULL),(3634,3666,40720,1603,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',28000.01,NULL,NULL,1,'2025-06-03 18:44:12','2025-06-03 18:44:12',NULL),(3635,3666,40720,1603,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',155741.77,NULL,NULL,1,'2025-06-03 18:44:12','2025-06-03 18:44:12',NULL),(3636,3666,40720,1603,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',331364.00,NULL,NULL,1,'2025-06-03 18:44:12','2025-06-03 18:44:12',NULL),(3637,3666,40720,1604,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',37507.96,NULL,NULL,1,'2025-06-03 18:44:24','2025-06-03 18:44:24',NULL),(3638,3666,40720,1604,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',112276.87,NULL,NULL,1,'2025-06-03 18:44:24','2025-06-11 18:09:59','2025-06-11 18:09:59'),(3639,3666,40720,1604,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',7500.00,NULL,NULL,1,'2025-06-03 18:44:24','2025-06-03 18:44:24',NULL);
INSERT INTO `balance_libro` VALUES (3640,3666,40720,1604,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',28000.01,NULL,NULL,1,'2025-06-03 18:44:25','2025-06-03 18:44:25',NULL),(3641,3666,40720,1604,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',28000.01,NULL,NULL,1,'2025-06-03 18:44:25','2025-06-03 18:44:25',NULL),(3642,3666,40720,1604,3,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',414205.00,NULL,NULL,1,'2025-06-03 18:44:25','2025-06-03 18:44:25',NULL),(3643,3666,40720,1604,3,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',160000.00,NULL,NULL,1,'2025-06-03 18:44:25','2025-06-03 18:44:25',NULL),(3644,3666,40720,1590,7,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',3777.82,NULL,NULL,1,'2025-06-04 10:47:35','2025-06-04 10:47:35',NULL),(3645,3666,40720,1590,7,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',3777.82,NULL,NULL,1,'2025-06-04 10:47:35','2025-06-04 10:47:35',NULL),(3646,3666,40720,1590,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',100000.00,NULL,NULL,1,'2025-06-04 10:53:24','2025-08-08 00:15:17','2025-08-08 00:15:17'),(3653,3666,40720,1590,7,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',135.58,NULL,NULL,1,'2025-06-04 11:11:07','2025-06-04 11:11:07',NULL),(3654,3666,40720,1590,7,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',729.81,NULL,NULL,1,'2025-06-04 11:11:07','2025-06-04 11:11:07',NULL),(3655,3666,40720,1590,7,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',135.58,NULL,NULL,1,'2025-06-04 11:11:07','2025-06-04 11:11:07',NULL),(3656,3666,40720,1590,7,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',14.82,NULL,NULL,1,'2025-06-04 11:11:07','2025-06-04 11:11:07',NULL),(3657,3666,40720,1590,7,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',874.65,NULL,NULL,1,'2025-06-04 11:11:07','2025-06-04 11:11:07',NULL),(3658,3666,40720,1590,7,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',857.83,NULL,NULL,1,'2025-06-04 11:11:07','2025-06-04 11:11:07',NULL),(3660,3666,40720,1590,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',47597.45,NULL,NULL,1,'2025-06-04 11:16:36','2025-08-02 11:28:18','2025-08-02 11:28:18'),(3661,3666,40720,1591,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',51344.01,NULL,NULL,1,'2025-06-04 18:06:34','2025-08-02 11:44:48','2025-08-02 11:44:48'),(3662,3666,40720,1591,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',114000.00,NULL,NULL,1,'2025-06-04 18:06:34','2025-06-04 18:06:34',NULL),(3663,3666,40720,1591,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',130000.00,NULL,NULL,1,'2025-06-04 18:06:34','2025-06-04 18:06:34',NULL),(3664,3666,40720,1591,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',14999.99,NULL,NULL,1,'2025-06-04 18:06:34','2025-06-04 18:06:34',NULL),(3665,3666,40720,1591,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',165682.00,NULL,NULL,1,'2025-06-04 18:06:34','2025-06-04 18:06:34',NULL),(3666,3666,40720,1591,7,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',307.42,NULL,NULL,1,'2025-06-04 18:07:05','2025-06-04 18:07:05',NULL);
INSERT INTO `balance_libro` VALUES (3667,3666,40720,1591,7,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',135.58,NULL,NULL,1,'2025-06-04 18:07:06','2025-06-04 18:07:06',NULL),(3668,3666,40720,1591,7,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',255.10,NULL,NULL,1,'2025-06-04 18:07:06','2025-06-04 18:18:39','2025-06-04 18:18:39'),(3669,3666,40720,1591,7,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',135.58,NULL,NULL,1,'2025-06-04 18:07:06','2025-06-04 18:07:06',NULL),(3670,3666,40720,1591,7,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',49.40,NULL,NULL,1,'2025-06-04 18:07:06','2025-06-04 18:18:56','2025-06-04 18:18:56'),(3671,3666,40720,1591,7,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',857.83,NULL,NULL,1,'2025-06-04 18:07:06','2025-06-04 18:07:06',NULL),(3672,3666,40720,1591,7,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',2255.10,NULL,NULL,1,'2025-06-04 18:18:39','2025-06-04 18:18:39',NULL),(3673,3666,40720,1591,7,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',1049.40,NULL,NULL,1,'2025-06-04 18:18:56','2025-06-04 18:18:56',NULL),(3674,3666,40720,1592,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',59429.89,NULL,NULL,1,'2025-06-04 18:35:03','2025-06-04 19:17:12','2025-06-04 19:17:12'),(3675,3666,40720,1592,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',22500.00,NULL,NULL,1,'2025-06-04 18:35:03','2025-06-04 18:35:03',NULL),(3676,3666,40720,1592,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',84000.00,NULL,NULL,1,'2025-06-04 18:35:03','2025-06-04 18:35:03',NULL),(3677,3666,40720,1592,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',165682.00,NULL,NULL,1,'2025-06-04 18:35:04','2025-06-04 18:35:04',NULL),(3678,3666,40720,1593,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',58002.50,NULL,NULL,1,'2025-06-04 18:55:58','2025-06-04 21:30:03','2025-06-04 21:30:03'),(3679,3666,40720,1593,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',168000.00,NULL,NULL,1,'2025-06-04 18:55:58','2025-06-04 18:55:58',NULL),(3680,3666,40720,1593,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',22500.00,NULL,NULL,1,'2025-06-04 18:55:58','2025-06-04 18:55:58',NULL),(3681,3666,40720,1593,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',165682.00,NULL,NULL,1,'2025-06-04 18:55:58','2025-06-04 18:55:58',NULL),(3682,3666,40720,1593,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6000.00,NULL,NULL,1,'2025-06-04 18:55:59','2025-06-04 18:55:59',NULL),(3683,3666,40720,1594,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',74002.98,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3684,3666,40720,1594,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',1137.11,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 21:35:58','2025-06-04 21:35:58'),(3685,3666,40720,1594,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',1680000.00,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3686,3666,40720,1594,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',165682.00,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL);
INSERT INTO `balance_libro` VALUES (3687,3666,40720,1594,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',24000.00,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3688,3666,40720,1594,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',6000.00,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3689,3666,40720,1594,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',22500.00,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3690,3666,40720,1594,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',65001.00,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3691,3666,40720,1594,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',67004.50,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3692,3666,40720,1594,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',61999.65,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3693,3666,40720,1594,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',79742.97,NULL,NULL,1,'2025-06-04 18:56:17','2025-06-04 18:56:17',NULL),(3694,3666,40720,1595,3,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',37500.00,NULL,NULL,1,'2025-06-04 18:56:33','2025-06-04 18:56:33',NULL),(3695,3666,40720,1595,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',86382.75,NULL,NULL,1,'2025-06-04 18:56:33','2025-06-04 21:39:21','2025-06-04 21:39:21'),(3696,3666,40720,1595,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',168000.00,NULL,NULL,1,'2025-06-04 18:56:33','2025-06-04 18:56:33',NULL),(3697,3666,40720,1595,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',331364.00,NULL,NULL,1,'2025-06-04 18:56:33','2025-06-04 18:56:33',NULL),(3698,3666,40720,1595,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',1680000.00,NULL,NULL,1,'2025-06-04 18:56:33','2025-08-03 22:18:13','2025-08-03 22:18:13'),(3699,3666,40720,1595,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6000.00,NULL,NULL,1,'2025-06-04 18:56:33','2025-06-04 18:56:33',NULL),(3700,3666,40720,1595,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',24000.00,NULL,NULL,1,'2025-06-04 18:56:33','2025-06-04 18:56:33',NULL),(3701,3666,40720,1595,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',22500.00,NULL,NULL,1,'2025-06-04 18:56:33','2025-06-04 18:56:33',NULL),(3702,3666,40720,1596,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',82800.00,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 18:56:51',NULL),(3703,3666,40720,1596,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',40000.99,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 18:56:51',NULL),(3704,3666,40720,1596,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',60000.00,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 18:56:51',NULL),(3705,3666,40720,1596,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',331364.00,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 18:56:51',NULL),(3706,3666,40720,1596,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',83460.20,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 22:03:48','2025-06-04 22:03:48');
INSERT INTO `balance_libro` VALUES (3707,3666,40720,1596,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',98000.00,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 18:56:51',NULL),(3708,3666,40720,1596,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',7500.00,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 18:56:51',NULL),(3709,3666,40720,1596,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',28000.01,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 18:56:51',NULL),(3710,3666,40720,1596,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',28000.01,NULL,NULL,1,'2025-06-04 18:56:51','2025-06-04 18:56:51',NULL),(3711,3666,40720,1597,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-17','2024-11-17',87316.10,NULL,NULL,1,'2025-06-04 18:57:12','2025-06-04 22:08:19','2025-06-04 22:08:19'),(3712,3666,40720,1597,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-19','2024-11-19',94700.00,NULL,NULL,1,'2025-06-04 18:57:13','2025-06-04 18:57:13',NULL),(3713,3666,40720,1597,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',28000.01,NULL,NULL,1,'2025-06-04 18:57:13','2025-06-04 18:57:13',NULL),(3714,3666,40720,1597,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',331364.00,NULL,NULL,1,'2025-06-04 18:57:13','2025-06-04 18:57:13',NULL),(3715,3666,40720,1597,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',7500.00,NULL,NULL,1,'2025-06-04 18:57:13','2025-06-04 18:57:13',NULL),(3716,3666,40720,1597,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',28000.01,NULL,NULL,1,'2025-06-04 18:57:13','2025-06-04 18:57:13',NULL),(3717,3666,40720,1598,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',86074.38,NULL,NULL,1,'2025-06-04 18:57:28','2025-08-02 12:57:25','2025-08-02 12:57:25'),(3718,3666,40720,1598,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',28000.01,NULL,NULL,1,'2025-06-04 18:57:28','2025-06-04 18:57:28',NULL),(3719,3666,40720,1598,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',28000.01,NULL,NULL,1,'2025-06-04 18:57:29','2025-06-04 18:57:29',NULL),(3720,3666,40720,1598,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',331364.00,NULL,NULL,1,'2025-06-04 18:57:29','2025-06-04 18:57:29',NULL),(3721,3666,40720,1598,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',28000.01,NULL,NULL,1,'2025-06-04 18:57:29','2025-06-04 18:57:29',NULL),(3722,3666,40720,1590,15,1195,'App\\Models\\PeriodLiquidation',NULL,1195,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1547260.70,NULL,NULL,1,'2025-06-04 19:05:21','2025-08-02 11:04:28','2025-08-02 11:04:28'),(3723,3666,40720,1591,15,1214,'App\\Models\\PeriodLiquidation',NULL,1214,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1505958.43,NULL,NULL,1,'2025-06-04 19:06:26','2025-08-02 11:04:47','2025-08-02 11:04:47'),(3724,3666,40720,1592,7,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',430.15,NULL,NULL,1,'2025-06-04 19:11:04','2025-06-04 19:11:04',NULL),(3725,3666,40720,1592,7,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',317.48,NULL,NULL,1,'2025-06-04 19:11:04','2025-06-04 19:15:03','2025-06-04 19:15:03'),(3726,3666,40720,1592,7,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',430.15,NULL,NULL,1,'2025-06-04 19:11:04','2025-06-04 19:11:04',NULL);
INSERT INTO `balance_libro` VALUES (3727,3666,40720,1592,7,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',199.29,NULL,NULL,1,'2025-06-04 19:11:04','2025-06-04 19:14:40','2025-06-04 19:14:40'),(3728,3666,40720,1592,7,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',186.50,NULL,NULL,1,'2025-06-04 19:11:04','2025-06-04 19:14:23','2025-06-04 19:14:23'),(3729,3666,40720,1592,7,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',5057.98,NULL,NULL,1,'2025-06-04 19:11:11','2025-06-04 19:11:11',NULL),(3730,3666,40720,1592,7,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',3777.82,NULL,NULL,1,'2025-06-04 19:11:18','2025-06-04 19:11:18',NULL),(3731,3666,40720,1592,7,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',1186.50,NULL,NULL,1,'2025-06-04 19:14:23','2025-06-04 19:14:23',NULL),(3732,3666,40720,1592,7,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',1199.29,NULL,NULL,1,'2025-06-04 19:14:40','2025-06-04 19:14:40',NULL),(3733,3666,40720,1592,7,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',2317.48,NULL,NULL,1,'2025-06-04 19:15:03','2025-06-04 19:15:03',NULL),(3734,3666,40720,1592,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',59430.09,NULL,NULL,1,'2025-06-04 19:17:12','2025-06-04 19:18:49','2025-06-04 19:18:49'),(3735,3666,40720,1592,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',59429.71,NULL,NULL,1,'2025-06-04 19:18:49','2025-08-02 11:54:55','2025-08-02 11:54:55'),(3736,3666,40720,1592,15,1390,'App\\Models\\PeriodLiquidation',NULL,1390,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1490773.75,NULL,NULL,1,'2025-06-04 19:19:33','2025-08-02 11:04:57','2025-08-02 11:04:57'),(3737,3666,40720,1593,7,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',5057.98,NULL,NULL,1,'2025-06-04 19:36:19','2025-06-04 19:38:26','2025-06-04 19:38:26'),(3738,3666,40720,1593,7,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',3777.82,NULL,NULL,1,'2025-06-04 19:36:30','2025-06-04 19:38:13','2025-06-04 19:38:13'),(3739,3666,40720,1593,7,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',5057.98,NULL,NULL,1,'2025-06-04 19:38:26','2025-06-04 19:38:35','2025-06-04 19:38:35'),(3740,3666,40720,1593,7,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',5057.98,NULL,NULL,1,'2025-06-04 21:26:54','2025-06-04 21:26:54',NULL),(3741,3666,40720,1593,7,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',3777.82,NULL,NULL,1,'2025-06-04 21:27:08','2025-06-04 21:27:08',NULL),(3742,3666,40720,1593,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',63944.91,NULL,NULL,1,'2025-06-04 21:30:03','2025-08-02 12:01:07','2025-08-02 12:01:07'),(3743,3666,40720,1593,15,1406,'App\\Models\\PeriodLiquidation',NULL,1406,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1445119.76,NULL,NULL,1,'2025-06-04 21:31:38','2025-08-02 11:05:53','2025-08-02 11:05:53'),(3744,3666,40720,1594,7,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',5057.98,NULL,NULL,1,'2025-06-04 21:33:36','2025-06-04 21:33:36',NULL),(3745,3666,40720,1594,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',7167.06,NULL,NULL,1,'2025-06-04 21:35:58','2025-08-02 12:09:25','2025-08-02 12:09:25');
INSERT INTO `balance_libro` VALUES (3746,3666,40720,1594,15,1413,'App\\Models\\PeriodLiquidation',NULL,1413,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1435736.15,NULL,NULL,1,'2025-06-04 21:36:49','2025-06-04 21:42:55','2025-06-04 21:42:55'),(3747,3666,40720,1595,7,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',5057.98,NULL,NULL,1,'2025-06-04 21:38:19','2025-06-04 21:38:19',NULL),(3748,3666,40720,1595,7,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',3777.82,NULL,NULL,1,'2025-06-04 21:38:27','2025-06-04 21:38:27',NULL),(3749,3666,40720,1595,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',91407.21,NULL,NULL,1,'2025-06-04 21:39:21','2025-08-02 12:14:02','2025-08-02 12:14:02'),(3750,3666,40720,1594,15,1422,'App\\Models\\PeriodLiquidation',NULL,1422,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1450514.36,NULL,NULL,1,'2025-06-04 21:54:46','2025-08-02 11:06:08','2025-08-02 11:06:08'),(3751,3666,40720,1595,15,1423,'App\\Models\\PeriodLiquidation',NULL,1423,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1372288.35,NULL,NULL,1,'2025-06-04 21:57:24','2025-08-02 11:06:18','2025-08-02 11:06:18'),(3752,3666,40720,1596,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',90542.98,NULL,NULL,1,'2025-06-04 22:03:48','2025-08-02 12:28:55','2025-08-02 12:28:55'),(3753,3666,40720,1596,15,1425,'App\\Models\\PeriodLiquidation',NULL,1425,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1251820.94,NULL,NULL,1,'2025-06-04 22:05:06','2025-08-02 11:06:29','2025-08-02 11:06:29'),(3754,3666,40720,1597,7,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-15','2024-11-15',5057.98,NULL,NULL,1,'2025-06-04 22:07:11','2025-06-04 22:07:11',NULL),(3755,3666,40720,1597,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-17','2024-11-17',94613.89,NULL,NULL,1,'2025-06-04 22:08:19','2025-08-02 12:44:47','2025-08-02 12:44:47'),(3756,3666,40720,1597,15,1430,'App\\Models\\PeriodLiquidation',NULL,1430,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1062748.10,NULL,NULL,1,'2025-06-04 22:09:17','2025-08-02 11:06:36','2025-08-02 11:06:36'),(3757,3666,40720,1598,7,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',661.59,NULL,NULL,1,'2025-06-11 10:53:59','2025-06-11 10:55:13','2025-06-11 10:55:13'),(3758,3666,40720,1598,7,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',661.59,NULL,NULL,1,'2025-06-11 10:55:13','2025-06-11 11:01:23','2025-06-11 11:01:23'),(3759,3666,40720,1598,7,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',3231.38,NULL,NULL,1,'2025-06-11 10:57:02','2025-06-11 11:00:27','2025-06-11 11:00:27'),(3760,3666,40720,1598,7,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',3231.38,NULL,NULL,1,'2025-06-11 11:00:27','2025-06-11 11:00:27',NULL),(3761,3666,40720,1598,7,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',661.59,NULL,NULL,1,'2025-06-11 11:01:23','2025-06-11 11:01:23',NULL),(3762,3666,40720,1598,7,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',598.90,NULL,NULL,1,'2025-06-11 11:02:48','2025-06-11 11:02:48',NULL),(3763,3666,40720,1598,7,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',2042.22,NULL,NULL,1,'2025-06-11 11:05:45','2025-06-11 11:05:45',NULL),(3764,3666,40720,1598,7,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',360.00,NULL,NULL,1,'2025-06-11 11:07:19','2025-06-11 11:07:19',NULL);
INSERT INTO `balance_libro` VALUES (3765,3666,40720,1598,7,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',142.50,NULL,NULL,1,'2025-06-11 11:07:46','2025-06-11 11:07:46',NULL),(3766,3666,40720,1598,7,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',1772.97,NULL,NULL,1,'2025-06-11 11:08:11','2025-06-11 11:08:11',NULL),(3767,3666,40720,1598,15,1451,'App\\Models\\PeriodLiquidation',NULL,1451,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',928877.27,NULL,NULL,1,'2025-06-11 11:10:12','2025-08-02 11:06:44','2025-08-02 11:06:44'),(3768,3666,40720,1602,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',92520.97,NULL,NULL,1,'2025-06-11 11:32:34','2025-08-02 13:04:22','2025-08-02 13:04:22'),(3770,3666,40720,1602,7,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',598.90,NULL,NULL,1,'2025-06-11 11:41:15','2025-06-11 11:41:15',NULL),(3771,3666,40720,1602,7,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',3102.61,NULL,NULL,1,'2025-06-11 11:42:15','2025-06-11 11:42:15',NULL),(3772,3666,40720,1602,7,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',661.59,NULL,NULL,1,'2025-06-11 11:42:59','2025-06-11 11:42:59',NULL),(3773,3666,40720,1602,7,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',2014.49,NULL,NULL,1,'2025-06-11 11:44:21','2025-06-11 11:44:21',NULL),(3774,3666,40720,1602,7,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',7505.57,NULL,NULL,1,'2025-06-11 11:45:36','2025-06-11 11:45:36',NULL),(3775,3666,40720,1602,7,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',501.65,NULL,NULL,1,'2025-06-11 11:45:59','2025-06-11 11:45:59',NULL),(3776,3666,40720,1602,15,1469,'App\\Models\\PeriodLiquidation',NULL,1469,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',805118.92,NULL,NULL,1,'2025-06-11 11:47:15','2025-08-02 11:06:52','2025-08-02 11:06:52'),(3777,3666,40720,1603,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',118399.51,NULL,NULL,1,'2025-06-11 11:52:36','2025-08-02 13:07:56','2025-08-02 13:07:56'),(3778,3666,40720,1603,7,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',27191.14,NULL,NULL,1,'2025-06-11 11:56:46','2025-06-11 11:56:46',NULL),(3779,3666,40720,1603,7,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',20891.64,NULL,NULL,1,'2025-06-11 11:56:58','2025-06-11 11:56:58',NULL),(3780,3666,40720,1603,7,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',20891.64,NULL,NULL,1,'2025-06-11 11:56:58','2025-06-11 11:56:58',NULL),(3781,3666,40720,1603,7,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',573.96,NULL,NULL,1,'2025-06-11 11:59:13','2025-06-11 11:59:13',NULL),(3782,3666,40720,1603,7,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',3124.07,NULL,NULL,1,'2025-06-11 11:59:46','2025-06-11 11:59:46',NULL),(3783,3666,40720,1603,7,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-19','2025-02-19',849.78,NULL,NULL,1,'2025-06-11 12:00:24','2025-06-11 12:00:24',NULL),(3784,3666,40720,1603,7,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-05','2025-02-05',2165.42,NULL,NULL,1,'2025-06-11 12:01:20','2025-06-11 12:01:20',NULL),(3785,3666,40720,1603,7,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',1772.97,NULL,NULL,1,'2025-06-11 12:02:20','2025-06-11 12:02:20',NULL);
INSERT INTO `balance_libro` VALUES (3786,3666,40720,1603,15,1485,'App\\Models\\PeriodLiquidation',NULL,1485,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',626568.18,NULL,NULL,1,'2025-06-11 12:03:23','2025-08-02 11:07:06','2025-08-02 11:07:06'),(3787,3666,40720,1604,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',112276.87,NULL,NULL,1,'2025-06-11 18:09:59','2025-08-02 13:11:31','2025-08-02 13:11:31'),(3788,3666,40720,1604,7,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-21','2025-03-21',573.96,NULL,NULL,1,'2025-06-11 18:13:41','2025-06-11 18:17:00','2025-06-11 18:17:00'),(3789,3666,40720,1604,7,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',3204.16,NULL,NULL,1,'2025-06-11 18:14:15','2025-06-11 18:14:15',NULL),(3790,3666,40720,1604,7,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',849.78,NULL,NULL,1,'2025-06-11 18:14:42','2025-06-11 18:14:42',NULL),(3791,3666,40720,1604,7,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',2762.18,NULL,NULL,1,'2025-06-11 18:15:42','2025-06-11 18:15:42',NULL),(3792,3666,40720,1604,7,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-05','2025-03-05',1772.97,NULL,NULL,1,'2025-06-11 18:16:32','2025-06-11 18:16:32',NULL),(3793,3666,40720,1604,7,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-21','2025-03-21',573.96,NULL,NULL,1,'2025-06-11 18:17:00','2025-06-11 18:17:00',NULL),(3794,3666,40720,1590,20,2809,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2809,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',23431.45,NULL,NULL,1,'2025-07-11 10:55:36','2025-07-11 10:55:36',NULL),(3795,3666,40720,1590,20,2810,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2810,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',23431.45,NULL,NULL,1,'2025-07-11 10:57:59','2025-07-11 10:57:59',NULL),(3796,3666,40720,1590,22,3796,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',1868108.37,'ACREDITACION PLAZO FIJO',NULL,1,'2025-07-29 19:50:28','2025-07-29 19:50:28',NULL),(3797,3666,40720,1590,22,3797,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',1900000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2025-07-29 19:52:53','2025-07-29 19:52:53',NULL),(3798,3666,40720,1590,20,3798,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',87120.00,'COBRANZA 04-2024',NULL,1,'2025-07-29 20:46:00','2025-07-29 20:46:00',NULL),(3799,3666,40720,1590,20,3799,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',150000.00,'COBRANZA 04-2024',NULL,1,'2025-07-29 20:54:34','2025-07-29 20:54:34',NULL),(3800,3666,40720,1590,22,3800,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',31371.49,'ACREDITACION CHEQUES',NULL,1,'2025-07-29 20:59:06','2025-07-29 20:59:06',NULL),(3801,3666,40720,1590,20,3801,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',62208.00,'COBRANZA 04-2024',NULL,1,'2025-07-29 21:27:48','2025-07-29 21:27:48',NULL),(3802,3666,40720,1590,20,3802,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',62208.00,'COBRANZA 04-2024',NULL,1,'2025-07-29 21:32:27','2025-07-29 21:32:27',NULL),(3803,3666,40720,1590,20,3803,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',49764.00,'COBRANZA 04-2024',NULL,1,'2025-07-29 21:42:52','2025-07-29 21:42:52',NULL),(3804,3666,40720,1590,22,3804,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',54717.51,'DEBITOS BANCARIOS 04-2024',NULL,1,'2025-07-29 21:53:33','2025-07-29 21:53:33',NULL);
INSERT INTO `balance_libro` VALUES (3805,3666,40720,1590,21,2811,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2811,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',50000.00,NULL,NULL,1,'2025-07-29 21:58:28','2025-07-29 21:58:28',NULL),(3806,3666,40720,1590,21,2812,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2812,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',39500.00,NULL,NULL,1,'2025-07-29 22:08:19','2025-07-29 22:08:19',NULL),(3807,3666,40720,1590,21,3807,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',139316.70,'TRANSF GUSTAVO HEIN',NULL,1,'2025-07-29 22:12:55','2025-07-30 08:50:00','2025-07-30 08:50:00'),(3808,3666,40720,1590,10,3808,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',7600.00,'PAGOS AFIP MULTAS',NULL,1,'2025-07-29 22:17:07','2025-07-30 08:48:44','2025-07-30 08:48:44'),(3809,3666,40720,1591,22,3809,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',2009315.07,'ACREDITACION PLAZO FIJO',NULL,1,'2025-07-30 08:21:53','2025-07-30 08:21:53',NULL),(3810,3666,40720,1591,22,3810,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',2000000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2025-07-30 08:26:47','2025-07-30 08:26:47',NULL),(3811,3666,40720,1591,20,2813,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2813,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',87120.00,NULL,NULL,1,'2025-07-30 08:32:21','2025-07-30 08:32:21',NULL),(3812,3666,40720,1591,20,2814,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2814,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',150000.00,NULL,NULL,1,'2025-07-30 08:34:22','2025-07-30 08:34:22',NULL),(3813,3666,40720,1591,20,2815,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2815,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',49764.00,NULL,NULL,1,'2025-07-30 08:38:17','2025-07-30 08:38:17',NULL),(3814,3666,40720,1591,20,2816,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2816,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',62208.00,NULL,NULL,1,'2025-07-30 08:39:49','2025-07-30 08:39:49',NULL),(3815,3666,40720,1591,21,3815,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',160000.00,'TRANSF NESTOR ACUÑA',NULL,1,'2025-07-30 08:46:23','2025-07-30 08:59:03','2025-07-30 08:59:03'),(3816,3666,40720,1591,21,3816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',106580.00,'TRANS MARITO PAYESKA',NULL,1,'2025-07-30 08:48:01','2025-07-30 08:48:01',NULL),(3817,3666,40720,1590,10,3817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',7600.00,'PAGOS AFIP MULTAS',NULL,1,'2025-07-30 08:48:44','2025-07-30 08:48:44',NULL),(3818,3666,40720,1590,21,3818,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',139316.70,'TRANSF GUSTAVO HEIN',NULL,1,'2025-07-30 08:50:00','2025-07-30 08:50:00',NULL),(3819,3666,40720,1591,21,3819,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',160000.00,'HONORARIOS PTE ABRIL MAYO 2024',NULL,1,'2025-07-30 08:53:14','2025-07-30 08:53:14',NULL),(3820,3666,40720,1591,21,3820,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',48779.92,'DEBITOS BANCARIOS 05-2024',NULL,1,'2025-07-30 08:55:20','2025-07-30 08:55:20',NULL),(3821,3666,40720,1591,21,3821,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',70000.00,'TRANSF NESTOR ACUÑA',NULL,1,'2025-07-30 08:59:03','2025-07-30 08:59:03',NULL),(3822,3666,40720,1592,22,3822,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',2060821.92,'ACREDITACION PLAZO FIJO',NULL,1,'2025-07-30 10:09:54','2025-07-30 10:09:54',NULL);
INSERT INTO `balance_libro` VALUES (3823,3666,40720,1592,22,3823,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',2300000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2025-07-30 10:11:09','2025-07-30 10:11:09',NULL),(3824,3666,40720,1592,20,2817,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2817,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',87120.00,NULL,NULL,1,'2025-07-30 10:14:33','2025-07-30 10:14:33',NULL),(3825,3666,40720,1592,20,2818,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2818,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',150000.00,NULL,NULL,1,'2025-07-30 10:15:51','2025-07-30 10:15:51',NULL),(3826,3666,40720,1592,20,2819,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2819,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',23431.45,NULL,NULL,1,'2025-07-30 10:17:35','2025-07-30 10:17:35',NULL),(3827,3666,40720,1592,20,2820,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2820,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',31460.00,NULL,NULL,1,'2025-07-30 10:20:37','2025-07-30 10:20:37',NULL),(3828,3666,40720,1592,20,2821,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2821,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',31460.00,NULL,NULL,1,'2025-07-30 10:21:02','2025-07-30 10:21:02',NULL),(3829,3666,40720,1592,20,2822,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2822,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',31460.00,NULL,NULL,1,'2025-07-30 10:21:31','2025-07-30 10:21:31',NULL),(3830,3666,40720,1592,20,2823,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2823,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',41817.60,NULL,NULL,1,'2025-07-30 10:23:54','2025-07-30 10:30:18','2025-07-30 10:30:18'),(3831,3666,40720,1592,21,3831,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',80000.00,'HONORARIOS PTE JUNIO 2024',NULL,1,'2025-07-30 10:26:37','2025-07-30 10:26:37',NULL),(3832,3666,40720,1592,21,3832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',64662.12,'DEBITOS BANCARIOS 06-2024',NULL,1,'2025-07-30 10:28:16','2025-07-30 10:28:16',NULL),(3833,3666,40720,1592,20,2824,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2824,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',41817.00,NULL,NULL,1,'2025-07-30 10:31:20','2025-07-30 10:31:20',NULL),(3834,3666,40720,1593,22,3834,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',2360493.15,'ACREDITACION PLAZO FIJO',NULL,1,'2025-07-31 18:06:55','2025-07-31 18:06:55',NULL),(3835,3666,40720,1593,20,2825,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2825,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',87120.00,NULL,NULL,1,'2025-07-31 18:13:32','2025-07-31 18:13:32',NULL),(3836,3666,40720,1593,20,2826,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2826,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',181500.00,NULL,NULL,1,'2025-07-31 18:14:29','2025-07-31 18:14:29',NULL),(3837,3666,40720,1593,20,2827,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2827,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',31500.00,NULL,NULL,1,'2025-07-31 18:14:58','2025-07-31 18:14:58',NULL),(3838,3666,40720,1593,20,2828,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2828,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',23431.45,NULL,NULL,1,'2025-07-31 18:19:30','2025-07-31 18:19:30',NULL),(3839,3666,40720,1593,22,3839,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',2450000.00,'CONSTITUCION PLAZO FIJO',NULL,1,'2025-07-31 18:25:00','2025-07-31 18:25:00',NULL),(3840,3666,40720,1593,10,3840,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',84000.00,'TRANSF 03-07-2024',NULL,1,'2025-07-31 18:42:46','2025-08-12 22:32:53','2025-08-12 22:32:53'),(3841,3666,40720,1593,10,3841,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',226225.16,'TRANSF 22-07-2024',NULL,1,'2025-07-31 18:44:59','2025-08-12 22:37:07','2025-08-12 22:37:07');
INSERT INTO `balance_libro` VALUES (3842,3666,40720,1593,21,3842,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',48628.51,'PAGO CHEQUE N° 741589',NULL,1,'2025-07-31 18:47:06','2025-07-31 18:47:06',NULL),(3843,3666,40720,1593,21,3843,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',63452.52,'DEBITOS BANCARIOS 07-2024',NULL,1,'2025-07-31 18:49:08','2025-07-31 18:49:08',NULL),(3844,3666,40720,1594,20,2829,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2829,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',91587.32,NULL,NULL,1,'2025-07-31 18:53:23','2025-07-31 18:53:23',NULL),(3845,3666,40720,1594,20,2830,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2830,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',200000.00,NULL,NULL,1,'2025-07-31 18:55:14','2025-07-31 18:55:14',NULL),(3846,3666,40720,1594,20,2831,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2831,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',87120.00,NULL,NULL,1,'2025-07-31 18:57:58','2025-07-31 18:57:58',NULL),(3847,3666,40720,1594,20,2832,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2832,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',181500.00,NULL,NULL,1,'2025-07-31 18:58:34','2025-07-31 18:58:34',NULL),(3848,3666,40720,1594,20,2833,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2833,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',62208.00,NULL,NULL,1,'2025-07-31 18:59:34','2025-07-31 18:59:34',NULL),(3849,3666,40720,1594,22,3849,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-22','2024-08-22',2527527.40,'ACREDITACION PLAZO FIJO',NULL,1,'2025-07-31 19:02:05','2025-07-31 19:02:06',NULL),(3850,3666,40720,1594,20,2834,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2834,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',31460.00,NULL,NULL,1,'2025-07-31 19:02:56','2025-07-31 19:02:56',NULL),(3851,3666,40720,1594,21,3851,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',150000.00,'TRANSF MARIO PAYESKA',NULL,1,'2025-07-31 19:13:55','2025-07-31 19:13:55',NULL),(3852,3666,40720,1594,21,2835,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2835,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',52500.00,NULL,NULL,1,'2025-07-31 19:17:06','2025-07-31 19:17:06',NULL),(3853,3666,40720,1594,21,2836,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2836,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',28500.00,NULL,NULL,1,'2025-07-31 19:17:55','2025-07-31 19:17:55',NULL),(3854,3666,40720,1594,21,3854,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',93742.00,'TRANSF PEDROZO ELEUTERIO',NULL,1,'2025-07-31 19:27:19','2025-08-20 18:45:33','2025-08-20 18:45:33'),(3855,3666,40720,1594,21,3855,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',130300.00,'TRANSF FLORENCIA HEIN',NULL,1,'2025-07-31 19:29:09','2025-07-31 19:29:09',NULL),(3856,3666,40720,1594,21,3856,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',48628.51,'PAGO CHEQUE N° 741590',NULL,1,'2025-07-31 19:31:27','2025-07-31 19:31:27',NULL),(3857,3666,40720,1594,21,3857,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',74444.83,'DEBITOS BANCARIOS 08-2024',NULL,1,'2025-07-31 19:35:31','2025-07-31 19:35:31',NULL),(3858,3666,40720,1595,20,2837,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2837,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',117370.00,NULL,NULL,1,'2025-07-31 19:46:10','2025-07-31 19:46:10',NULL),(3859,3666,40720,1595,20,2838,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2838,NULL,NULL,NULL,0,NULL,'2024-09-10','2024-09-10',211750.00,NULL,NULL,1,'2025-07-31 19:49:50','2025-07-31 20:08:56','2025-07-31 20:08:56'),(3860,3666,40720,1595,20,2839,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2839,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',23431.45,NULL,NULL,1,'2025-07-31 19:50:55','2025-07-31 19:50:55',NULL);
INSERT INTO `balance_libro` VALUES (3861,3666,40720,1595,20,2840,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2840,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',41818.00,NULL,NULL,1,'2025-07-31 19:53:19','2025-07-31 19:53:19',NULL),(3862,3666,40720,1595,21,3862,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',37500.00,'TRANSF MAYRA DANIELA ESCALADA',NULL,1,'2025-07-31 19:56:04','2025-08-13 00:44:18','2025-08-13 00:44:18'),(3863,3666,40720,1595,21,3863,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',63694.73,'DEBITOS BANCARIOS 09-2024',NULL,1,'2025-07-31 19:57:42','2025-07-31 19:57:42',NULL),(3864,3666,40720,1596,20,2841,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2841,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',200000.00,NULL,NULL,1,'2025-07-31 20:04:15','2025-07-31 20:04:15',NULL),(3865,3666,40720,1596,20,2842,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2842,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',200000.00,NULL,NULL,1,'2025-07-31 20:07:31','2025-07-31 20:07:31',NULL),(3866,3666,40720,1595,20,2843,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2843,NULL,NULL,NULL,0,NULL,'2024-09-10','2024-09-10',211750.00,NULL,NULL,1,'2025-07-31 20:10:00','2025-07-31 20:10:00',NULL),(3867,3666,40720,1596,20,2844,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2844,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',211750.00,NULL,NULL,1,'2025-07-31 20:11:01','2025-07-31 20:11:01',NULL),(3868,3666,40720,1596,20,2845,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2845,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',117370.00,NULL,NULL,1,'2025-07-31 20:12:33','2025-07-31 20:12:33',NULL),(3869,3666,40720,1596,20,2846,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2846,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',158152.00,NULL,NULL,1,'2025-07-31 20:19:06','2025-07-31 20:19:06',NULL),(3870,3666,40720,1596,20,2847,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2847,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',31460.00,NULL,NULL,1,'2025-07-31 20:20:40','2025-07-31 20:20:40',NULL),(3871,3666,40720,1596,20,2848,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2848,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',58000.00,NULL,NULL,1,'2025-07-31 20:23:44','2025-07-31 20:23:44',NULL),(3872,3666,40720,1596,20,2849,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2849,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',58000.00,NULL,NULL,1,'2025-07-31 20:24:20','2025-07-31 20:24:20',NULL),(3873,3666,40720,1596,20,2850,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2850,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',242000.00,NULL,NULL,1,'2025-07-31 20:25:29','2025-07-31 20:25:29',NULL),(3874,3666,40720,1596,22,3874,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',31371.49,'DEPOSITO CHEQUE',NULL,1,'2025-07-31 20:26:58','2025-07-31 20:26:58',NULL),(3875,3666,40720,1596,21,3875,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',48628.51,'PAGO CHEQUE N° 741591',NULL,1,'2025-07-31 20:29:09','2025-07-31 20:29:09',NULL),(3876,3666,40720,1596,21,3876,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',129801.00,'TRANSF MAXI CUNALE',NULL,1,'2025-07-31 20:31:48','2025-07-31 20:31:48',NULL),(3877,3666,40720,1596,21,2851,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2851,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',662728.00,NULL,NULL,1,'2025-07-31 20:35:11','2025-07-31 20:35:11',NULL),(3878,3666,40720,1596,21,3878,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',60000.00,'TRANSF LEGUIZA AUGUSTO',NULL,1,'2025-07-31 20:37:41','2025-08-01 20:46:14','2025-08-01 20:46:14'),(3879,3666,40720,1596,21,3879,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',90039.70,'DEBITOS BANCARIOS 10-2024',NULL,1,'2025-07-31 20:39:12','2025-07-31 20:39:12',NULL);
INSERT INTO `balance_libro` VALUES (3880,3666,40720,1597,20,2852,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2852,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',216000.00,NULL,NULL,1,'2025-08-01 19:04:09','2025-08-01 19:04:09',NULL),(3881,3666,40720,1597,20,2853,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2853,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',400000.00,NULL,NULL,1,'2025-08-01 19:14:49','2025-08-01 19:14:49',NULL),(3882,3666,40720,1597,20,2854,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2854,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',211750.00,NULL,NULL,1,'2025-08-01 19:18:34','2025-08-01 19:18:34',NULL),(3883,3666,40720,1597,20,2855,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2855,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',117370.00,NULL,NULL,1,'2025-08-01 19:19:42','2025-08-01 19:19:42',NULL),(3884,3666,40720,1597,20,2856,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2856,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',42000.00,NULL,NULL,1,'2025-08-01 19:20:37','2025-08-01 19:20:37',NULL),(3885,3666,40720,1597,20,2857,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2857,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',242000.00,NULL,NULL,1,'2025-08-01 19:21:10','2025-08-01 19:21:10',NULL),(3886,3666,40720,1597,21,3886,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',262500.00,'PAGO CHEQUE N° 741593',NULL,1,'2025-08-01 19:40:35','2025-08-20 18:46:08','2025-08-20 18:46:08'),(3887,3666,40720,1597,21,3887,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-15','2024-11-15',150000.00,'PAGO CHEQUE N° 741594',NULL,1,'2025-08-01 20:23:53','2025-08-20 18:49:49','2025-08-20 18:49:49'),(3888,3666,40720,1597,21,3888,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',129801.00,'PAGO CHEQUE N° 741595',NULL,1,'2025-08-01 20:25:29','2025-08-01 20:25:29',NULL),(3889,3666,40720,1597,21,2858,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2858,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',94700.00,NULL,NULL,1,'2025-08-01 20:31:50','2025-08-01 20:31:50',NULL),(3890,3666,40720,1596,21,3890,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',60000.00,'TRANSF LEGUIZA AUGUSTO',NULL,1,'2025-08-01 20:56:27','2025-08-13 01:28:53','2025-08-13 01:28:53'),(3891,3666,40720,1597,21,2859,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2859,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',869044.75,NULL,NULL,1,'2025-08-01 21:01:26','2025-08-01 21:01:26',NULL),(3892,3666,40720,1597,21,3892,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',106900.17,'DEBITOS BANCARIOS 11-2024',NULL,1,'2025-08-01 21:05:16','2025-08-01 21:13:36','2025-08-01 21:13:36'),(3893,3666,40720,1597,21,3893,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',106900.77,'DEBITOS BANCARIOS 11-2024',NULL,1,'2025-08-01 21:13:36','2025-08-01 21:13:36',NULL),(3894,3666,40720,1598,20,2860,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2860,NULL,NULL,NULL,0,NULL,'2024-12-09','2024-12-09',211500.00,NULL,NULL,1,'2025-08-01 21:20:21','2025-08-01 21:20:21',NULL),(3895,3666,40720,1598,20,2861,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2861,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',217800.00,NULL,NULL,1,'2025-08-01 21:23:58','2025-08-01 21:23:58',NULL),(3896,3666,40720,1598,22,3896,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',31371.49,'DEPOSITO CHEQUE',NULL,1,'2025-08-01 21:24:37','2025-08-01 21:24:37',NULL),(3897,3666,40720,1598,21,3897,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',600000.00,'PAGO CHEQUE N° 741601',NULL,1,'2025-08-01 21:27:07','2025-08-01 21:27:07',NULL),(3898,3666,40720,1598,21,3898,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',1161047.40,'PAGO CHEQUE N° 741600',NULL,1,'2025-08-01 21:28:18','2025-08-01 21:28:18',NULL);
INSERT INTO `balance_libro` VALUES (3899,3666,40720,1598,21,3899,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-16','2024-12-16',80000.00,'PAGO CHEQUE N° 741602',NULL,1,'2025-08-01 21:31:06','2025-08-01 21:31:06',NULL),(3900,3666,40720,1598,21,2862,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2862,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',400000.00,NULL,NULL,1,'2025-08-01 21:41:26','2025-08-01 21:41:26',NULL),(3901,3666,40720,1598,21,2863,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2863,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',113000.00,NULL,NULL,1,'2025-08-01 21:47:05','2025-08-01 21:47:05',NULL),(3902,3666,40720,1598,21,3902,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',35000.00,'TRANSF MARIO BENITEZ',NULL,1,'2025-08-01 21:49:57','2025-08-20 18:50:49','2025-08-20 18:50:49'),(3903,3666,40720,1598,21,3903,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',131248.65,'DEBITOS BANCARIOS 12-2024',NULL,1,'2025-08-01 21:52:05','2025-08-01 21:52:05',NULL),(3904,3666,40720,1602,20,2864,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2864,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',130000.00,NULL,NULL,1,'2025-08-01 21:55:14','2025-08-01 21:55:14',NULL),(3905,3666,40720,1602,20,2865,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2865,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',130000.00,NULL,NULL,1,'2025-08-01 21:55:45','2025-08-01 21:55:45',NULL),(3906,3666,40720,1602,20,2866,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2866,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',211500.00,NULL,NULL,1,'2025-08-01 21:58:03','2025-08-01 21:58:03',NULL),(3907,3666,40720,1602,21,3907,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',129801.00,'TRANSF MAXI CUNALE',NULL,1,'2025-08-01 22:04:58','2025-08-01 22:04:58',NULL),(3908,3666,40720,1602,21,2867,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2867,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',428410.00,NULL,NULL,1,'2025-08-01 22:07:43','2025-08-01 22:07:43',NULL),(3909,3666,40720,1602,21,3909,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',104701.00,'DEBITOS BANCARIOS 01-2025',NULL,1,'2025-08-01 22:09:24','2025-08-01 22:09:24',NULL),(3910,3666,40720,1603,20,2868,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2868,NULL,NULL,NULL,0,NULL,'2025-02-10','2025-02-10',211500.00,NULL,NULL,1,'2025-08-01 22:13:30','2025-08-01 22:13:30',NULL),(3911,3666,40720,1603,20,2869,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2869,NULL,NULL,NULL,0,NULL,'2025-02-10','2025-02-10',130000.00,NULL,NULL,1,'2025-08-01 22:16:23','2025-08-01 22:16:23',NULL),(3912,3666,40720,1603,20,2870,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2870,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',259155.82,NULL,NULL,1,'2025-08-01 22:20:59','2025-08-01 22:20:59',NULL),(3913,3666,40720,1603,21,3913,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',179800.00,'TRANSF GUSTAVO HEIN',NULL,1,'2025-08-01 22:23:20','2025-08-01 22:23:20',NULL),(3914,3666,40720,1603,21,3914,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',129801.00,'TRANSF MAXI CUNALE',NULL,1,'2025-08-01 22:24:39','2025-08-01 22:24:39',NULL),(3915,3666,40720,1603,21,3915,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',97477.98,'DEBITOS BANCARIOS 02-2025',NULL,1,'2025-08-01 22:26:26','2025-08-01 22:29:25','2025-08-01 22:29:25'),(3916,3666,40720,1603,21,3916,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',97477.78,'DEBITOS BANCARIOS 02-2025',NULL,1,'2025-08-01 22:29:25','2025-08-01 22:29:25',NULL),(3917,3666,40720,1604,20,2872,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2872,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',248000.00,NULL,NULL,1,'2025-08-01 22:42:29','2025-08-01 22:42:29',NULL);
INSERT INTO `balance_libro` VALUES (3918,3666,40720,1604,20,2873,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2873,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',248000.00,NULL,NULL,1,'2025-08-01 22:43:25','2025-08-01 22:43:25',NULL),(3919,3666,40720,1604,20,2874,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2874,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',248000.00,NULL,NULL,1,'2025-08-01 22:44:37','2025-08-01 22:44:37',NULL),(3920,3666,40720,1604,20,2875,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2875,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',211500.00,NULL,NULL,1,'2025-08-01 22:47:10','2025-08-01 22:47:10',NULL),(3921,3666,40720,1604,20,2877,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2877,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',184600.00,NULL,NULL,1,'2025-08-01 22:51:15','2025-08-01 22:51:15',NULL),(3922,3666,40720,1604,21,2878,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2878,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',114000.00,NULL,NULL,1,'2025-08-01 22:56:49','2025-08-01 22:56:49',NULL),(3923,3666,40720,1604,21,3923,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',285000.00,'TRANSF GUSTAVO HEIN',NULL,1,'2025-08-01 22:58:06','2025-08-01 22:58:06',NULL),(3924,3666,40720,1604,21,3924,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',70000.00,'TRANSF MARIO BENITEZ',NULL,1,'2025-08-01 23:01:18','2025-08-20 18:51:27','2025-08-20 18:51:27'),(3925,3666,40720,1604,21,3925,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',113390.13,'DEBITOS BANCARIOS 03-2025',NULL,1,'2025-08-01 23:02:39','2025-08-01 23:02:39',NULL),(3926,3666,40720,1590,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',48302.92,NULL,NULL,1,'2025-08-02 11:28:18','2025-08-02 11:28:18',NULL),(3927,3666,40720,1590,16,1503,'App\\Models\\PeriodLiquidation',NULL,1503,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4436187.24,NULL,NULL,1,'2025-08-02 11:29:55','2025-08-02 11:36:47','2025-08-02 11:36:47'),(3928,3666,40720,1589,15,974,'App\\Models\\PeriodLiquidation',NULL,974,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1567529.98,NULL,NULL,1,'2025-08-02 11:31:44','2025-08-02 11:31:44',NULL),(3929,3666,40720,1590,16,3929,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',11993.59,'AJUSTE IIBB 04-2024',NULL,1,'2025-08-02 11:35:13','2025-08-02 11:49:31','2025-08-02 11:49:31'),(3930,3666,40720,1590,16,1504,'App\\Models\\PeriodLiquidation',NULL,1504,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4436187.24,NULL,NULL,1,'2025-08-02 11:40:43','2025-08-07 23:26:25','2025-08-07 23:26:25'),(3931,3666,40720,1591,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',52081.27,NULL,NULL,1,'2025-08-02 11:44:48','2025-08-02 11:44:48',NULL),(3932,3666,40720,1591,16,1506,'App\\Models\\PeriodLiquidation',NULL,1506,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',4429868.48,NULL,NULL,1,'2025-08-02 11:46:35','2025-08-07 23:26:44','2025-08-07 23:26:44'),(3933,3666,40720,1591,16,3933,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',8552.72,'AJUSTE IIBB 05-2024',NULL,1,'2025-08-02 11:48:09','2025-08-02 11:50:24','2025-08-02 11:50:24'),(3934,3666,40720,1590,16,3934,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',11993.57,'AJUSTE IIBB 04-2024',NULL,1,'2025-08-02 11:49:31','2025-08-02 11:49:31',NULL),(3935,3666,40720,1591,16,3935,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',8552.74,'AJUSTE IIBB 05-2024',NULL,1,'2025-08-02 11:50:24','2025-08-02 11:50:24',NULL),(3936,3666,40720,1592,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',60478.27,NULL,NULL,1,'2025-08-02 11:54:55','2025-08-02 11:54:55',NULL);
INSERT INTO `balance_libro` VALUES (3937,3666,40720,1592,16,1508,'App\\Models\\PeriodLiquidation',NULL,1508,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',4423950.26,NULL,NULL,1,'2025-08-02 11:56:59','2025-08-07 23:26:59','2025-08-07 23:26:59'),(3938,3666,40720,1592,16,3938,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',13643.41,'AJUSTE IIBB 06-2024',NULL,1,'2025-08-02 11:58:50','2025-08-02 11:58:50',NULL),(3939,3666,40720,1593,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',65299.05,NULL,NULL,1,'2025-08-02 12:01:07','2025-08-02 12:01:07',NULL),(3940,3666,40720,1593,16,1510,'App\\Models\\PeriodLiquidation',NULL,1510,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',4419035.34,NULL,NULL,1,'2025-08-02 12:03:11','2025-08-02 12:07:36','2025-08-02 12:07:36'),(3941,3666,40720,1593,16,3941,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',11850.09,'AJUSTE IIBB 07-2024',NULL,1,'2025-08-02 12:05:08','2025-08-02 12:05:08',NULL),(3942,3666,40720,1593,16,1510,'App\\Models\\PeriodLiquidation',NULL,1510,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',4419035.33,NULL,NULL,1,'2025-08-02 12:08:13','2025-08-07 23:27:23','2025-08-07 23:27:23'),(3943,3666,40720,1594,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',10311.74,NULL,NULL,1,'2025-08-02 12:09:25','2025-08-02 12:09:25',NULL),(3944,3666,40720,1594,16,1512,'App\\Models\\PeriodLiquidation',NULL,1512,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',4412303.41,NULL,NULL,1,'2025-08-02 12:11:42','2025-08-03 21:52:29','2025-08-03 21:52:29'),(3945,3666,40720,1594,16,3945,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',16019.93,'AJUSTE IIBB 08-2024',NULL,1,'2025-08-02 12:12:49','2025-08-02 12:12:49',NULL),(3946,3666,40720,1595,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',89966.06,NULL,NULL,1,'2025-08-02 12:14:02','2025-08-02 12:14:02',NULL),(3947,3666,40720,1595,16,1514,'App\\Models\\PeriodLiquidation',NULL,1514,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',4398048.52,NULL,NULL,1,'2025-08-02 12:15:38','2025-08-03 21:52:21','2025-08-03 21:52:21'),(3948,3666,40720,1595,16,3948,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',9662.04,'AJUSTE IIBB 09-2024',NULL,1,'2025-08-02 12:18:23','2025-08-02 12:18:23',NULL),(3949,3666,40720,1596,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',91979.67,NULL,NULL,1,'2025-08-02 12:28:55','2025-08-02 12:28:55',NULL),(3950,3666,40720,1596,16,1516,'App\\Models\\PeriodLiquidation',NULL,1516,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4372198.02,NULL,NULL,1,'2025-08-02 12:30:47','2025-08-07 23:28:14','2025-08-07 23:28:14'),(3951,3666,40720,1596,16,3951,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',32048.52,'AJUSTE IIBB 10-2024',NULL,1,'2025-08-02 12:42:25','2025-08-02 12:42:25',NULL),(3952,3666,40720,1597,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-17','2024-11-17',95854.89,NULL,NULL,1,'2025-08-02 12:44:47','2025-08-02 12:44:47',NULL),(3953,3666,40720,1597,16,1518,'App\\Models\\PeriodLiquidation',NULL,1518,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',4322254.16,NULL,NULL,1,'2025-08-02 12:46:45','2025-08-02 12:50:26','2025-08-02 12:50:26'),(3954,3666,40720,1597,16,3954,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',30113.43,'AJUSTE IIBB 11-2024',NULL,1,'2025-08-02 12:49:26','2025-08-02 12:55:43','2025-08-02 12:55:43'),(3955,3666,40720,1597,16,1518,'App\\Models\\PeriodLiquidation',NULL,1518,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',44354302.68,NULL,NULL,1,'2025-08-02 12:51:05','2025-08-02 12:52:10','2025-08-02 12:52:10');
INSERT INTO `balance_libro` VALUES (3956,3666,40720,1597,16,1518,'App\\Models\\PeriodLiquidation',NULL,1518,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',4354302.68,NULL,NULL,1,'2025-08-02 12:53:04','2025-08-07 23:28:30','2025-08-07 23:28:30'),(3957,3666,40720,1597,16,3957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',38738.35,'AJUSTE IIBB 11-2024',NULL,1,'2025-08-02 12:55:43','2025-08-02 12:55:43',NULL),(3958,3666,40720,1598,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',85860.38,NULL,NULL,1,'2025-08-02 12:57:25','2025-08-02 12:57:25',NULL),(3959,3666,40720,1598,16,1520,'App\\Models\\PeriodLiquidation',NULL,1520,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4354802.38,NULL,NULL,1,'2025-08-02 12:58:38','2025-08-07 23:28:45','2025-08-07 23:28:45'),(3960,3666,40720,1598,16,3960,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',20329.37,'AJUSTE IIBB 12-2024',NULL,1,'2025-08-02 12:59:51','2025-08-02 12:59:51',NULL),(3961,3666,40720,1602,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',102203.19,NULL,NULL,1,'2025-08-02 13:04:22','2025-08-02 13:04:22',NULL),(3962,3666,40720,1602,16,1522,'App\\Models\\PeriodLiquidation',NULL,1522,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',4342110.12,NULL,NULL,1,'2025-08-02 13:05:39','2025-08-07 23:28:58','2025-08-07 23:28:58'),(3963,3666,40720,1602,16,3963,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',11551.75,'AJUSTE IIBB 01-2025',NULL,1,'2025-08-02 13:06:43','2025-08-02 13:06:43',NULL),(3964,3666,40720,1603,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',123343.03,NULL,NULL,1,'2025-08-02 13:07:56','2025-08-02 13:07:56',NULL),(3965,3666,40720,1603,16,1524,'App\\Models\\PeriodLiquidation',NULL,1524,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',4296219.09,NULL,NULL,1,'2025-08-02 13:09:09','2025-08-07 23:29:11','2025-08-07 23:29:11'),(3966,3666,40720,1603,16,3966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',14716.06,'AJUSTE IIBB 02-2025',NULL,1,'2025-08-02 13:10:19','2025-08-02 13:10:19',NULL),(3967,3666,40720,1604,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',118053.90,NULL,NULL,1,'2025-08-02 13:11:31','2025-08-02 13:11:31',NULL),(3968,3666,40720,1604,16,1526,'App\\Models\\PeriodLiquidation',NULL,1526,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',4249253.88,NULL,NULL,1,'2025-08-02 13:13:02','2025-08-07 23:29:25','2025-08-07 23:29:25'),(3969,3666,40720,1604,16,3969,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',27932.60,'AJUSTE IIBB 03-2025',NULL,1,'2025-08-02 13:14:24','2025-08-02 13:14:24',NULL),(3970,3666,40720,1590,15,1502,'App\\Models\\PeriodLiquidation',NULL,1502,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1547260.70,NULL,NULL,1,'2025-08-02 15:12:59','2025-08-07 23:26:38','2025-08-07 23:26:38'),(3971,3666,40720,1591,15,1505,'App\\Models\\PeriodLiquidation',NULL,1505,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1505958.43,NULL,NULL,1,'2025-08-02 15:15:21','2025-08-07 23:26:52','2025-08-07 23:26:52'),(3972,3666,40720,1592,15,1507,'App\\Models\\PeriodLiquidation',NULL,1507,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1490773.75,NULL,NULL,1,'2025-08-02 15:17:56','2025-08-07 23:27:16','2025-08-07 23:27:16'),(3973,3666,40720,1593,15,1509,'App\\Models\\PeriodLiquidation',NULL,1509,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1445119.72,NULL,NULL,1,'2025-08-02 15:18:35','2025-08-07 23:27:32','2025-08-07 23:27:32');
INSERT INTO `balance_libro` VALUES (3974,3666,40720,1594,15,1511,'App\\Models\\PeriodLiquidation',NULL,1511,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1450514.32,NULL,NULL,1,'2025-08-02 15:19:18','2025-08-03 21:27:28','2025-08-03 21:27:28'),(3975,3666,40720,1595,15,1513,'App\\Models\\PeriodLiquidation',NULL,1513,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1372288.31,NULL,NULL,1,'2025-08-02 15:20:07','2025-08-03 21:27:13','2025-08-03 21:27:13'),(3976,3666,40720,1596,15,1515,'App\\Models\\PeriodLiquidation',NULL,1515,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1251820.90,NULL,NULL,1,'2025-08-02 15:21:43','2025-08-07 23:28:22','2025-08-07 23:28:22'),(3977,3666,40720,1597,15,1517,'App\\Models\\PeriodLiquidation',NULL,1517,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1062748.06,NULL,NULL,1,'2025-08-02 15:22:41','2025-08-07 23:28:38','2025-08-07 23:28:38'),(3978,3666,40720,1598,15,1519,'App\\Models\\PeriodLiquidation',NULL,1519,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',928877.23,NULL,NULL,1,'2025-08-02 15:23:29','2025-08-07 23:28:52','2025-08-07 23:28:52'),(3979,3666,40720,1602,15,1521,'App\\Models\\PeriodLiquidation',NULL,1521,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',805118.88,NULL,NULL,1,'2025-08-02 15:24:36','2025-08-07 23:29:05','2025-08-07 23:29:05'),(3980,3666,40720,1603,15,1523,'App\\Models\\PeriodLiquidation',NULL,1523,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',626568.14,NULL,NULL,1,'2025-08-02 15:25:27','2025-08-07 23:29:20','2025-08-07 23:29:20'),(3981,3666,40720,1604,15,1525,'App\\Models\\PeriodLiquidation',NULL,1525,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',387386.28,NULL,NULL,1,'2025-08-02 15:29:23','2025-08-03 21:51:56','2025-08-03 21:51:56'),(3982,3666,40720,1595,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',1680000.00,NULL,NULL,1,'2025-08-03 22:18:13','2025-08-03 22:18:13',NULL),(3983,3666,40720,1594,16,1512,'App\\Models\\PeriodLiquidation',NULL,1512,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',4412303.41,NULL,NULL,1,'2025-08-04 01:23:45','2025-08-07 23:27:39','2025-08-07 23:27:39'),(3984,3666,40720,1594,15,1511,'App\\Models\\PeriodLiquidation',NULL,1511,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1450514.32,NULL,NULL,1,'2025-08-04 01:23:55','2025-08-07 23:27:47','2025-08-07 23:27:47'),(3985,3666,40720,1595,15,1527,'App\\Models\\PeriodLiquidation',NULL,1527,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1372288.31,NULL,NULL,1,'2025-08-04 01:24:17','2025-08-07 23:28:04','2025-08-07 23:28:04'),(3986,3666,40720,1595,16,1528,'App\\Models\\PeriodLiquidation',NULL,1528,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',4382028.59,NULL,NULL,1,'2025-08-04 01:24:22','2025-08-07 23:27:54','2025-08-07 23:27:54'),(3987,3666,40720,1604,15,1525,'App\\Models\\PeriodLiquidation',NULL,1525,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',387386.28,NULL,NULL,1,'2025-08-04 01:24:29','2025-08-07 23:29:33','2025-08-07 23:29:33'),(3988,3666,40720,1590,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',470000.00,NULL,NULL,1,'2025-08-07 23:32:18','2025-08-07 23:38:33','2025-08-07 23:38:33'),(3989,3666,40720,1591,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',470000.00,NULL,NULL,1,'2025-08-07 23:33:24','2025-08-07 23:38:50','2025-08-07 23:38:50'),(3990,3666,40720,1592,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',470000.00,NULL,NULL,1,'2025-08-07 23:34:02','2025-08-07 23:39:07','2025-08-07 23:39:07'),(3991,3666,40720,1593,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',470000.00,NULL,NULL,1,'2025-08-07 23:34:35','2025-08-07 23:39:38','2025-08-07 23:39:38');
INSERT INTO `balance_libro` VALUES (3992,3666,40720,1590,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',470000.00,NULL,NULL,1,'2025-08-07 23:38:33','2025-08-07 23:38:33',NULL),(3993,3666,40720,1591,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',470000.00,NULL,NULL,1,'2025-08-07 23:38:50','2025-08-07 23:38:50',NULL),(3994,3666,40720,1592,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',470000.00,NULL,NULL,1,'2025-08-07 23:39:07','2025-08-07 23:39:23','2025-08-07 23:39:23'),(3995,3666,40720,1592,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',470000.00,NULL,NULL,1,'2025-08-07 23:39:23','2025-08-07 23:39:23',NULL),(3996,3666,40720,1593,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',470000.00,NULL,NULL,1,'2025-08-07 23:39:38','2025-08-07 23:40:20','2025-08-07 23:40:20'),(3997,3666,40720,1594,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',470000.00,NULL,NULL,1,'2025-08-07 23:40:20','2025-08-07 23:41:07','2025-08-07 23:41:07'),(3998,3666,40720,1595,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',470000.00,NULL,NULL,1,'2025-08-07 23:41:07','2025-08-07 23:41:41','2025-08-07 23:41:41'),(3999,3666,40720,1596,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',470000.00,NULL,NULL,1,'2025-08-07 23:41:41','2025-08-07 23:42:12','2025-08-07 23:42:12'),(4000,3666,40720,1597,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',470000.00,NULL,NULL,1,'2025-08-07 23:42:12','2025-08-07 23:42:52','2025-08-07 23:42:52'),(4001,3666,40720,1598,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',470000.00,NULL,NULL,1,'2025-08-07 23:42:52','2025-08-07 23:43:26','2025-08-07 23:43:26'),(4002,3666,40720,1602,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',470000.00,NULL,NULL,1,'2025-08-07 23:43:26','2025-08-07 23:43:59','2025-08-07 23:43:59'),(4003,3666,40720,1603,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',470000.00,NULL,NULL,1,'2025-08-07 23:43:59','2025-08-07 23:44:34','2025-08-07 23:44:34'),(4004,3666,40720,1604,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',470000.00,NULL,NULL,1,'2025-08-07 23:44:34','2025-08-07 23:55:46','2025-08-07 23:55:46'),(4005,3666,40720,1593,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',470000.00,NULL,NULL,1,'2025-08-07 23:48:44','2025-08-07 23:48:44',NULL),(4006,3666,40720,1594,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',470000.00,NULL,NULL,1,'2025-08-07 23:49:38','2025-08-07 23:49:38',NULL),(4007,3666,40720,1595,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',470000.00,NULL,NULL,1,'2025-08-07 23:50:43','2025-08-07 23:50:43',NULL),(4008,3666,40720,1596,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',470000.00,NULL,NULL,1,'2025-08-07 23:51:13','2025-08-07 23:51:13',NULL),(4009,3666,40720,1597,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',470000.00,NULL,NULL,1,'2025-08-07 23:52:00','2025-08-07 23:52:00',NULL),(4010,3666,40720,1598,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',470000.00,NULL,NULL,1,'2025-08-07 23:52:44','2025-08-07 23:52:44',NULL),(4011,3666,40720,1602,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',470000.00,NULL,NULL,1,'2025-08-07 23:53:16','2025-08-07 23:53:16',NULL);
INSERT INTO `balance_libro` VALUES (4012,3666,40720,1603,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',470000.00,NULL,NULL,1,'2025-08-07 23:53:43','2025-08-07 23:55:47','2025-08-07 23:55:47'),(4013,3666,40720,1603,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',680000.00,NULL,NULL,1,'2025-08-07 23:56:37','2025-08-07 23:56:37',NULL),(4014,3666,40720,1604,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',680000.00,NULL,NULL,1,'2025-08-07 23:57:10','2025-08-07 23:57:10',NULL),(4015,3666,40720,1590,20,2919,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2919,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',470000.00,NULL,NULL,1,'2025-08-08 11:37:43','2025-08-08 11:37:43',NULL),(4016,3666,40720,1591,20,2920,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2920,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',470000.00,NULL,NULL,1,'2025-08-08 11:38:10','2025-08-08 11:38:10',NULL),(4017,3666,40720,1592,20,2921,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2921,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',470000.00,NULL,NULL,1,'2025-08-08 11:38:50','2025-08-08 11:38:50',NULL),(4018,3666,40720,1593,20,2922,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2922,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',470000.00,NULL,NULL,1,'2025-08-08 11:39:24','2025-08-08 11:39:24',NULL),(4019,3666,40720,1594,20,2923,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2923,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',470000.00,NULL,NULL,1,'2025-08-08 11:39:51','2025-08-08 11:39:51',NULL),(4020,3666,40720,1595,20,2924,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2924,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',470000.00,NULL,NULL,1,'2025-08-08 11:40:12','2025-08-08 11:40:12',NULL),(4021,3666,40720,1596,20,2925,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2925,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',470000.00,NULL,NULL,1,'2025-08-08 11:40:31','2025-08-08 11:40:31',NULL),(4022,3666,40720,1597,20,2926,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2926,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',470000.00,NULL,NULL,1,'2025-08-08 11:40:49','2025-08-08 11:40:49',NULL),(4023,3666,40720,1598,20,2927,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2927,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',470000.00,NULL,NULL,1,'2025-08-08 11:41:07','2025-08-08 11:41:07',NULL),(4024,3666,40720,1602,20,2928,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2928,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',470000.00,NULL,NULL,1,'2025-08-08 11:41:25','2025-08-08 11:41:25',NULL),(4025,3666,40720,1603,20,2929,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2929,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',680000.00,NULL,NULL,1,'2025-08-08 11:41:54','2025-08-08 11:41:54',NULL),(4026,3666,40720,1604,20,2930,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2930,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',680000.00,NULL,NULL,1,'2025-08-08 11:47:13','2025-08-08 11:47:13',NULL),(4027,3666,40720,1590,20,2931,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2931,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',169693.15,NULL,NULL,1,'2025-08-10 20:40:49','2025-08-10 20:40:49',NULL),(4028,3666,40720,1590,20,2932,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2932,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',197652.90,NULL,NULL,1,'2025-08-10 20:45:18','2025-08-10 20:45:18',NULL),(4029,3666,40720,1590,20,2933,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2933,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',36429.47,NULL,NULL,1,'2025-08-10 20:49:33','2025-08-10 20:49:33',NULL),(4030,3666,40720,1591,20,2934,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2934,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',36429.47,NULL,NULL,1,'2025-08-10 21:07:09','2025-08-10 21:07:09',NULL),(4031,3666,40720,1592,20,2935,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2935,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',36429.47,NULL,NULL,1,'2025-08-10 21:11:32','2025-08-10 21:11:32',NULL);
INSERT INTO `balance_libro` VALUES (4032,3666,40720,1593,20,2936,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2936,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',36429.47,NULL,NULL,1,'2025-08-10 21:13:13','2025-08-10 21:13:13',NULL),(4033,3666,40720,1594,20,2937,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2937,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',36429.47,NULL,NULL,1,'2025-08-10 21:14:35','2025-08-10 21:14:35',NULL),(4034,3666,40720,1595,20,2938,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2938,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',36429.47,NULL,NULL,1,'2025-08-10 21:20:20','2025-08-10 21:20:20',NULL),(4035,3666,40720,1596,20,2939,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2939,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',36429.47,NULL,NULL,1,'2025-08-10 21:23:50','2025-08-10 21:23:50',NULL),(4036,3666,40720,1597,20,2940,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2940,NULL,NULL,NULL,0,NULL,'2024-11-15','2024-11-15',36429.47,NULL,NULL,1,'2025-08-10 21:24:27','2025-08-10 21:24:27',NULL),(4037,3666,40720,1603,20,2941,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2941,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',195840.92,NULL,NULL,1,'2025-08-10 21:35:46','2025-08-10 21:35:46',NULL),(4038,3666,40720,1598,2,4038,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2928079.00,'ALQUILERES ROBERTO BUSER',NULL,1,'2025-08-10 22:05:59','2025-08-10 22:05:59',NULL),(4042,3666,40720,1590,21,2945,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2945,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3079.31,NULL,NULL,1,'2025-08-11 11:40:48','2025-08-21 18:24:32','2025-08-21 18:24:32'),(4045,3666,40720,1590,21,2948,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2948,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3156.51,NULL,NULL,1,'2025-08-11 11:45:29','2025-08-21 18:22:40','2025-08-21 18:22:40'),(4046,3666,40720,1590,21,2949,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2949,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3033.23,NULL,NULL,1,'2025-08-11 11:45:47','2025-08-21 18:24:18','2025-08-21 18:24:18'),(4047,3666,40720,1590,21,2950,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2950,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3770.95,NULL,NULL,1,'2025-08-11 11:46:14','2025-08-21 18:24:13','2025-08-21 18:24:13'),(4051,3666,40720,1590,21,2954,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2954,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4770.96,NULL,NULL,1,'2025-08-11 11:48:15','2025-08-21 18:24:09','2025-08-21 18:24:09'),(4052,3666,40720,1590,21,2955,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2955,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',9331.32,NULL,NULL,1,'2025-08-11 11:48:50','2025-08-21 18:24:04','2025-08-21 18:24:04'),(4054,3666,40720,1590,21,2957,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2957,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4703.33,NULL,NULL,1,'2025-08-11 11:51:12','2025-08-21 18:23:58','2025-08-21 18:23:58'),(4055,3666,40720,1590,21,2958,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2958,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4506.62,NULL,NULL,1,'2025-08-11 11:52:22','2025-08-21 18:23:51','2025-08-21 18:23:51'),(4059,3666,40720,1590,21,2962,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2962,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',5686.66,NULL,NULL,1,'2025-08-11 12:05:16','2025-08-21 18:23:45','2025-08-21 18:23:45'),(4061,3666,40720,1590,21,2964,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2964,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3739.50,NULL,NULL,1,'2025-08-11 12:06:13','2025-08-21 18:23:29','2025-08-21 18:23:29'),(4063,3666,40720,1591,3,4063,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',140000.00,'OBRAS M.O. 05-2024',NULL,1,'2025-08-11 12:31:52','2025-08-11 12:31:52',NULL),(4064,3666,40720,1595,3,4064,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',170000.00,'OBRAS M.O. 09-2024',NULL,1,'2025-08-11 12:33:09','2025-08-11 12:33:09',NULL);
INSERT INTO `balance_libro` VALUES (4067,3666,40720,1605,25,2968,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2968,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',29290.84,NULL,NULL,1,'2025-08-11 17:59:09','2025-08-12 22:18:41','2025-08-12 22:18:41'),(4068,3666,40720,1590,21,2973,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2973,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',391407.46,NULL,NULL,1,'2025-08-11 18:20:47','2025-08-21 18:23:08','2025-08-21 18:23:08'),(4070,3666,40720,1592,3,4070,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',134694.08,'COMBUSTIBLE 06-2024',NULL,1,'2025-08-11 18:25:41','2025-08-11 18:25:41',NULL),(4071,3666,40720,1593,3,4071,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',20000.00,'COMBUSTIBLE 07-2024',NULL,1,'2025-08-11 18:26:32','2025-08-11 18:26:32',NULL),(4072,3666,40720,1594,3,4072,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',30006.21,'COMBUSTIBLE 08-2024',NULL,1,'2025-08-11 18:27:23','2025-08-11 18:27:23',NULL),(4073,3666,40720,1595,3,4073,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',70490.98,'COMBUSTIBLE 09-2024',NULL,1,'2025-08-11 18:28:25','2025-08-11 18:28:25',NULL),(4074,3666,40720,1596,3,4074,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',182511.99,'COMBUSTIBLE 10-2024',NULL,1,'2025-08-11 18:29:25','2025-08-11 18:29:25',NULL),(4075,3666,40720,1597,3,4075,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',180662.01,'COMBUSTIBLE 11-2024',NULL,1,'2025-08-11 18:30:44','2025-08-11 18:30:44',NULL),(4076,3666,40720,1598,3,4076,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',30000.00,'COMBUSTIBLE 12-2024',NULL,1,'2025-08-11 18:31:27','2025-08-11 18:31:27',NULL),(4077,3666,40720,1603,3,4077,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',39999.99,'COMBUSTIBLE 02-2025',NULL,1,'2025-08-11 18:32:36','2025-08-11 18:32:36',NULL),(4078,3666,40720,1604,3,4078,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',99999.97,'COMBUSTIBLE 03-2025',NULL,1,'2025-08-11 18:33:40','2025-08-11 18:33:40',NULL),(4079,3666,40720,1591,3,4079,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',110000.00,'MANT Y REP 05-2024',NULL,1,'2025-08-11 18:35:47','2025-08-11 18:35:47',NULL),(4080,3666,40720,1595,3,4080,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',168754.90,'MANT Y REP 09-2024',NULL,1,'2025-08-11 18:36:36','2025-08-11 18:36:36',NULL),(4081,3666,40720,1598,3,4081,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',39700.00,'MANT Y REP 12-2024',NULL,1,'2025-08-11 18:37:54','2025-08-11 18:37:54',NULL),(4082,3666,40720,1602,3,4082,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',27000.00,'MANT Y REP 01-2025',NULL,1,'2025-08-11 18:38:54','2025-08-11 18:38:54',NULL),(4083,3666,40720,1592,3,4083,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',122100.00,'REFRIGERIOS 06-2024',NULL,1,'2025-08-11 18:40:55','2025-08-11 18:40:55',NULL),(4084,3666,40720,1595,3,4084,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',37000.00,'REFRIGERIOS 09-2024',NULL,1,'2025-08-11 19:34:40','2025-08-11 19:34:40',NULL),(4085,3666,40720,1596,3,4085,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',36030.00,'REFRIGERIOS 10-2024',NULL,1,'2025-08-11 19:35:24','2025-08-11 19:35:24',NULL);
INSERT INTO `balance_libro` VALUES (4086,3666,40720,1597,3,4086,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',4200.00,'REFRIGERIOS 11-2024',NULL,1,'2025-08-11 19:36:06','2025-08-11 19:36:06',NULL),(4087,3666,40720,1598,3,4087,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',336031.59,'REFRIGERIOS 12-2024',NULL,1,'2025-08-11 19:37:09','2025-08-11 19:37:09',NULL),(4089,3666,40720,1590,3,4089,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4500.00,'PEAJES 04-2024',NULL,1,'2025-08-12 18:24:49','2025-08-12 18:24:49',NULL),(4090,3666,40720,1592,3,4090,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',9100.00,'PEAJES 06-2024',NULL,1,'2025-08-12 18:25:44','2025-08-12 18:25:44',NULL),(4091,3666,40720,1594,3,4091,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',4400.00,'PEAJES 08-2024',NULL,1,'2025-08-12 18:26:35','2025-08-12 18:26:35',NULL),(4092,3666,40720,1595,3,4092,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',9000.00,'PEAJES 09-2024',NULL,1,'2025-08-12 18:27:43','2025-08-12 18:27:43',NULL),(4093,3666,40720,1596,3,4093,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',9200.00,'PEAJES 10-2024',NULL,1,'2025-08-12 18:28:27','2025-08-12 18:28:27',NULL),(4094,3666,40720,1597,3,4094,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',9800.00,'PEAJES 11-2024',NULL,1,'2025-08-12 18:29:51','2025-08-12 18:29:51',NULL),(4095,3666,40720,1598,3,4095,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2400.00,'PEAJES 12-2024',NULL,1,'2025-08-12 18:30:32','2025-08-12 18:30:32',NULL),(4096,3666,40720,1598,3,4096,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',436518.19,'GASTOS CAJA DE SEGURIDAD',NULL,1,'2025-08-12 18:33:41','2025-08-12 18:33:41',NULL),(4097,3666,40720,1603,21,2976,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2976,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',155741.77,NULL,NULL,1,'2025-08-12 18:52:49','2025-08-12 18:52:49',NULL),(4098,3666,40720,1602,21,2977,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2977,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',156850.12,NULL,NULL,1,'2025-08-12 18:53:42','2025-08-12 18:53:42',NULL),(4099,3666,40720,1602,21,2978,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2978,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',155741.77,NULL,NULL,1,'2025-08-12 18:54:15','2025-08-12 18:54:15',NULL),(4100,3666,40720,1603,21,2979,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2979,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',424400.00,NULL,NULL,1,'2025-08-12 18:54:59','2025-08-13 01:13:37','2025-08-13 01:13:37'),(4101,3666,40720,1590,21,2980,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2980,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',60000.00,NULL,NULL,1,'2025-08-12 18:55:59','2025-08-12 18:55:59',NULL),(4102,3666,40720,1590,21,2981,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2981,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',37500.00,NULL,NULL,1,'2025-08-12 18:56:42','2025-08-13 00:41:52','2025-08-13 00:41:52'),(4103,3666,40720,1590,21,2982,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2982,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',84000.00,NULL,NULL,1,'2025-08-12 18:57:46','2025-08-12 22:29:54','2025-08-12 22:29:54'),(4104,3666,40720,1590,21,2983,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2983,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',30008.00,NULL,NULL,1,'2025-08-12 18:59:28','2025-08-12 18:59:28',NULL),(4105,3666,40720,1590,21,2984,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2984,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4680.72,NULL,NULL,1,'2025-08-12 19:00:16','2025-08-12 19:00:16',NULL);
INSERT INTO `balance_libro` VALUES (4106,3666,40720,1590,21,2985,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2985,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3.63,NULL,NULL,1,'2025-08-12 19:01:18','2025-08-12 19:01:18',NULL),(4107,3666,40720,1590,21,2986,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2986,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1038000.00,NULL,NULL,1,'2025-08-12 19:07:05','2025-08-12 19:07:05',NULL),(4108,3666,40720,1594,21,2987,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2987,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',119304.15,NULL,NULL,1,'2025-08-12 19:10:58','2025-08-21 18:35:15','2025-08-21 18:35:15'),(4109,3666,40720,1594,21,2988,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2988,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',129106.74,NULL,NULL,1,'2025-08-12 19:12:17','2025-08-12 19:12:17',NULL),(4110,3666,40720,1590,21,2989,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2989,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',102383.13,NULL,NULL,1,'2025-08-12 19:13:46','2025-08-12 19:13:46',NULL),(4111,3666,40720,1590,21,2990,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2990,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',123205.33,NULL,NULL,1,'2025-08-12 19:16:23','2025-08-12 19:16:23',NULL),(4112,3666,40720,1590,21,2991,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2991,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',62422.68,NULL,NULL,1,'2025-08-12 19:17:20','2025-08-21 18:40:02','2025-08-21 18:40:02'),(4113,3666,40720,1590,21,2992,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2992,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',900.00,NULL,NULL,1,'2025-08-12 19:18:04','2025-08-12 19:18:04',NULL),(4114,3666,40720,1590,21,2993,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2993,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',161070.00,NULL,NULL,1,'2025-08-12 19:20:13','2025-08-12 19:20:13',NULL),(4116,3666,40720,1604,21,2995,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2995,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',943734.36,NULL,NULL,1,'2025-08-12 19:52:04','2025-08-16 13:52:20','2025-08-16 13:52:20'),(4117,3666,40720,1593,3,4117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',310225.16,'Pasajes y movilidad 07-2024',NULL,1,'2025-08-12 20:51:23','2025-08-12 22:40:18','2025-08-12 22:40:18'),(4118,3666,40720,1594,3,4118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',130300.00,'Pasajes y movilidad 08-2024',NULL,1,'2025-08-12 20:52:49','2025-08-12 22:41:48','2025-08-12 22:41:48'),(4119,3666,40720,1595,3,4119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',812410.00,'Pasajes y movilidad 09-2024',NULL,1,'2025-08-12 20:56:29','2025-08-12 20:56:29',NULL),(4120,3666,40720,1596,3,4120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1317529.00,'Pasajes y movilidad 10-2024',NULL,1,'2025-08-12 21:01:36','2025-08-12 22:52:21','2025-08-12 22:52:21'),(4121,3666,40720,1597,3,4121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2225338.58,'Pasajes y movilidad 11-2024',NULL,1,'2025-08-12 21:02:27','2025-08-16 13:33:54','2025-08-16 13:33:54'),(4122,3666,40720,1598,3,4122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',266200.00,'Pasajes y movilidad 12-2024',NULL,1,'2025-08-12 21:07:01','2025-08-16 13:36:19','2025-08-16 13:36:19'),(4123,3666,40720,1591,3,4123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',10640.46,'Papeles y Utiles 05-2024',NULL,1,'2025-08-12 21:18:31','2025-08-12 21:18:31',NULL),(4124,3666,40720,1594,3,4124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',11515.00,'Papeles y Utiles 08-2024',NULL,1,'2025-08-12 21:24:25','2025-08-12 21:24:25',NULL);
INSERT INTO `balance_libro` VALUES (4125,3666,40720,1595,3,4125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',7576.08,'Papeles y Utiles 09-2024',NULL,1,'2025-08-12 21:25:15','2025-08-12 21:25:15',NULL),(4126,3666,40720,1597,3,4126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',11050.00,'Papeles y Utiles 11-2024',NULL,1,'2025-08-12 21:27:07','2025-08-12 21:27:07',NULL),(4127,3666,40720,1598,3,4127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',46020.00,'Papeles y Utiles 12-2024',NULL,1,'2025-08-12 21:28:22','2025-08-12 21:28:22',NULL),(4128,3666,40720,1620,21,2996,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2996,NULL,NULL,NULL,0,NULL,'2026-04-01','2026-04-01',241608.36,NULL,NULL,1,'2025-08-12 22:03:09','2025-08-12 22:04:43','2025-08-12 22:04:43'),(4129,3666,40720,1590,21,2997,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2997,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',241608.36,NULL,NULL,1,'2025-08-12 22:05:35','2025-08-12 22:05:35',NULL),(4130,3666,40720,1604,21,2998,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2998,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',336305.00,NULL,NULL,1,'2025-08-12 22:06:53','2025-08-12 22:06:53',NULL),(4131,3666,40720,1593,21,2999,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2999,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',84000.00,NULL,NULL,1,'2025-08-12 22:31:48','2025-08-12 22:31:48',NULL),(4132,3666,40720,1593,10,4132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',226225.16,'TRANSF 22-07-2024',NULL,1,'2025-08-12 22:37:07','2025-08-12 22:37:41','2025-08-12 22:37:41'),(4133,3666,40720,1593,3,4133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',226225.16,'TRANSF 22-07-2024',NULL,1,'2025-08-12 22:37:41','2025-08-12 22:37:41',NULL),(4134,3666,40720,1596,3,4134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',525000.00,'Pasajes y movilidad 10-2024',NULL,1,'2025-08-12 22:52:21','2025-08-12 22:52:21',NULL),(4135,3666,40720,1593,3,4135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',5057.98,'TASAS MUNICIPALES 07-2024',NULL,1,'2025-08-12 22:59:09','2025-08-12 22:59:09',NULL),(4136,3666,40720,1594,3,4136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',5057.98,'TASAS MUNICIPALES 08-2024',NULL,1,'2025-08-12 23:00:52','2025-08-12 23:00:52',NULL),(4137,3666,40720,1598,3,4137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',13152.00,'TASAS MUNICIPALES 12-2024',NULL,1,'2025-08-12 23:02:37','2025-08-12 23:02:37',NULL),(4138,3666,40720,1603,3,4138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',55150.00,'TASAS MUNICIPALES 02-2025',NULL,1,'2025-08-12 23:03:43','2025-08-12 23:03:43',NULL),(4139,3666,40720,1604,3,4139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2600.00,'TASAS MUNICIPALES 03-2025',NULL,1,'2025-08-12 23:04:29','2025-08-12 23:04:29',NULL),(4140,3666,40720,1590,3,4140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',50000.00,'HONORARIOS CONSEJEROS 04-2024',NULL,1,'2025-08-13 00:12:46','2025-08-13 00:12:46',NULL),(4141,3666,40720,1592,3,4141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',70000.00,'HONORARIOS NESTOR ACUÑA',NULL,1,'2025-08-13 00:16:07','2025-08-13 00:16:07',NULL),(4142,3666,40720,1592,3,4142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',100000.00,'HONORARIOS JOSE CUNALE',NULL,1,'2025-08-13 00:17:03','2025-08-13 00:17:03',NULL);
INSERT INTO `balance_libro` VALUES (4143,3666,40720,1593,3,4143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',31371.49,'HONORARIOS PRESIDENTE GRV',NULL,1,'2025-08-13 00:20:10','2025-08-13 00:20:10',NULL),(4144,3666,40720,1594,3,4144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',31371.49,'HONORARIOS PRESIDENTE GRV',NULL,1,'2025-08-13 00:22:08','2025-08-13 00:22:08',NULL),(4145,3666,40720,1594,3,4145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',324742.00,'HONORARIOS CONSEJEROS 08-2024',NULL,1,'2025-08-13 00:22:56','2025-08-13 00:22:56',NULL),(4146,3666,40720,1595,3,4146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',193213.74,'HONORARIOS CONSEJEROS 09-2024',NULL,1,'2025-08-13 00:25:52','2025-08-13 00:25:52',NULL),(4147,3666,40720,1596,3,4147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',266477.49,'HONORARIOS CONSEJEROS 10-2024',NULL,1,'2025-08-13 00:28:58','2025-08-13 00:28:58',NULL),(4148,3666,40720,1597,3,4148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',80000.00,'HONORARIOS PRESIDENTE GRV',NULL,1,'2025-08-13 00:30:46','2025-08-13 00:30:46',NULL),(4149,3666,40720,1598,3,4149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',436000.00,'HONORARIOS CONSEJEROS 12-2024',NULL,1,'2025-08-13 00:32:32','2025-08-13 00:32:32',NULL),(4150,3666,40720,1602,3,4150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',80000.00,'HONORARIOS PRESIDENTE GRV',NULL,1,'2025-08-13 00:34:16','2025-08-13 00:34:16',NULL),(4151,3666,40720,1603,3,4151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',80000.00,'HONORARIOS PRESIDENTE GRV',NULL,1,'2025-08-13 00:35:23','2025-08-13 00:35:23',NULL),(4152,3666,40720,1604,3,4152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',80000.00,'HONORARIOS PRESIDENTE GRV',NULL,1,'2025-08-13 00:36:05','2025-08-13 00:36:05',NULL),(4153,3666,40720,1595,21,3000,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3000,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',37500.00,NULL,NULL,1,'2025-08-13 00:42:58','2025-08-13 00:42:58',NULL),(4154,3666,40720,1596,21,3001,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3001,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',424400.00,NULL,NULL,1,'2025-08-13 01:15:24','2025-08-13 01:15:24',NULL),(4155,3666,40720,1596,21,4155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',321861.48,'HONORARIOS PROFESIONALES',NULL,1,'2025-08-13 01:28:53','2025-08-13 01:31:16','2025-08-13 01:31:16'),(4156,3666,40720,1596,21,4156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',321841.48,'HONORARIOS PROFESIONALES',NULL,1,'2025-08-13 01:31:16','2025-08-13 01:31:16',NULL),(4160,3666,40720,1589,25,4160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',77839.88,'COMPENSACION CREDITOS Y PASIVOS',NULL,1,'2025-08-13 10:07:36','2025-08-13 10:07:59','2025-08-13 10:07:59'),(4161,3666,40720,1589,26,4161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',77839.88,'COMPENSACION CREDITOS Y PASIVOS',NULL,1,'2025-08-13 10:07:59','2025-08-13 10:08:21','2025-08-13 10:08:21'),(4162,3666,40720,1589,9,4162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',77839.88,'COMPENSACION CREDITOS Y PASIVOS',NULL,1,'2025-08-13 10:08:21','2025-08-13 10:08:21',NULL),(4164,3666,40720,1604,9,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',180980.00,NULL,NULL,1,'2025-08-13 11:08:06','2025-08-13 11:44:39','2025-08-13 11:44:39');
INSERT INTO `balance_libro` VALUES (4165,3666,40720,1604,9,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',180980.00,NULL,NULL,1,'2025-08-13 11:08:34','2025-08-13 11:44:03','2025-08-13 11:44:03'),(4166,3666,40720,1604,9,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',18980.00,NULL,NULL,1,'2025-08-13 11:40:34','2025-08-13 11:43:25','2025-08-13 11:43:25'),(4167,3666,40720,1604,9,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',241012.85,NULL,NULL,1,'2025-08-13 11:44:39','2025-08-13 11:44:39',NULL),(4168,3666,40720,1590,16,1588,'App\\Models\\PeriodLiquidation',NULL,1588,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4436187.24,NULL,NULL,1,'2025-08-13 12:34:12','2025-08-13 12:34:12',NULL),(4169,3666,40720,1590,15,1587,'App\\Models\\PeriodLiquidation',NULL,1587,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1547260.70,NULL,NULL,1,'2025-08-13 12:35:06','2025-08-13 12:35:06',NULL),(4170,3666,40720,1591,16,1540,'App\\Models\\PeriodLiquidation',NULL,1540,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',4429868.53,NULL,NULL,1,'2025-08-13 12:36:27','2025-08-13 12:36:27',NULL),(4171,3666,40720,1591,15,1539,'App\\Models\\PeriodLiquidation',NULL,1539,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1505958.43,NULL,NULL,1,'2025-08-13 12:36:57','2025-08-13 12:36:57',NULL),(4172,3666,40720,1592,16,1544,'App\\Models\\PeriodLiquidation',NULL,1544,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',4423950.34,NULL,NULL,1,'2025-08-13 12:38:13','2025-08-13 12:38:13',NULL),(4173,3666,40720,1592,15,1543,'App\\Models\\PeriodLiquidation',NULL,1543,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1490773.75,NULL,NULL,1,'2025-08-13 12:38:37','2025-08-13 12:38:37',NULL),(4174,3666,40720,1593,16,1564,'App\\Models\\PeriodLiquidation',NULL,1564,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',4419035.42,NULL,NULL,1,'2025-08-13 12:39:52','2025-08-13 12:39:52',NULL),(4175,3666,40720,1593,15,1563,'App\\Models\\PeriodLiquidation',NULL,1563,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1445119.72,NULL,NULL,1,'2025-08-13 12:40:19','2025-08-13 12:40:19',NULL),(4176,3666,40720,1594,16,1566,'App\\Models\\PeriodLiquidation',NULL,1566,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',4412303.50,NULL,NULL,1,'2025-08-13 12:41:22','2025-08-13 12:41:22',NULL),(4177,3666,40720,1594,15,1565,'App\\Models\\PeriodLiquidation',NULL,1565,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',1450514.32,NULL,NULL,1,'2025-08-13 12:41:46','2025-08-13 12:41:46',NULL),(4178,3666,40720,1595,16,1568,'App\\Models\\PeriodLiquidation',NULL,1568,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',4398048.63,NULL,NULL,1,'2025-08-13 12:42:39','2025-08-13 12:42:39',NULL),(4179,3666,40720,1595,15,1567,'App\\Models\\PeriodLiquidation',NULL,1567,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1372288.31,NULL,NULL,1,'2025-08-13 12:43:02','2025-08-13 12:43:02',NULL),(4180,3666,40720,1596,16,1570,'App\\Models\\PeriodLiquidation',NULL,1570,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4372198.14,NULL,NULL,1,'2025-08-13 12:44:21','2025-08-13 12:44:21',NULL),(4181,3666,40720,1596,15,1569,'App\\Models\\PeriodLiquidation',NULL,1569,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1251820.90,NULL,NULL,1,'2025-08-13 12:44:54','2025-08-13 12:44:54',NULL),(4182,3666,40720,1597,16,1572,'App\\Models\\PeriodLiquidation',NULL,1572,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',4354302.81,NULL,NULL,1,'2025-08-13 12:50:11','2025-08-13 12:50:11',NULL),(4183,3666,40720,1597,15,1571,'App\\Models\\PeriodLiquidation',NULL,1571,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',1062748.06,NULL,NULL,1,'2025-08-13 12:50:41','2025-08-13 12:50:41',NULL);
INSERT INTO `balance_libro` VALUES (4184,3666,40720,1598,16,1574,'App\\Models\\PeriodLiquidation',NULL,1574,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',4354802.52,NULL,NULL,1,'2025-08-13 12:51:23','2025-08-13 12:51:23',NULL),(4185,3666,40720,1598,15,1573,'App\\Models\\PeriodLiquidation',NULL,1573,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',928877.23,NULL,NULL,1,'2025-08-13 12:51:54','2025-08-13 12:51:54',NULL),(4186,3666,40720,1602,16,1576,'App\\Models\\PeriodLiquidation',NULL,1576,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',4342110.26,NULL,NULL,1,'2025-08-13 12:52:43','2025-08-13 12:52:43',NULL),(4187,3666,40720,1602,15,1575,'App\\Models\\PeriodLiquidation',NULL,1575,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',805118.88,NULL,NULL,1,'2025-08-13 12:53:06','2025-08-13 12:53:06',NULL),(4188,3666,40720,1603,16,1584,'App\\Models\\PeriodLiquidation',NULL,1584,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',4296219.23,NULL,NULL,1,'2025-08-13 12:53:52','2025-08-13 12:53:52',NULL),(4189,3666,40720,1603,15,1583,'App\\Models\\PeriodLiquidation',NULL,1583,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',626568.14,NULL,NULL,1,'2025-08-13 12:54:16','2025-08-13 12:54:16',NULL),(4190,3666,40720,1604,16,1600,'App\\Models\\PeriodLiquidation',NULL,1600,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',4249254.03,NULL,NULL,1,'2025-08-13 12:55:15','2025-08-13 12:55:15',NULL),(4191,3666,40720,1604,15,1599,'App\\Models\\PeriodLiquidation',NULL,1599,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',313351.39,NULL,NULL,1,'2025-08-13 12:56:08','2025-08-13 12:56:08',NULL),(4195,3666,40720,1604,10,4195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',241012.85,'MULTAS E INTERESES AFIP',NULL,1,'2025-08-15 17:47:26','2025-08-15 17:47:26',NULL),(4196,3666,40720,1604,20,4196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',964050.00,'CANCELACION PARCIAL DEUDA SERGIO DELAPIERRE',NULL,1,'2025-08-15 18:00:55','2025-08-15 18:07:09','2025-08-15 18:07:09'),(4197,3666,40720,1604,11,4197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',761250.00,'AJUSTE CREDITO SERGIO DELAPIERRE',NULL,1,'2025-08-15 18:07:09','2025-08-15 18:07:09',NULL),(4198,3666,40720,1604,20,4198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',964050.00,'CANCELACION PARCIAL DEUDA SERGIO DELAPIERRE',NULL,1,'2025-08-15 18:08:41','2025-08-25 01:37:33','2025-08-25 01:37:33'),(4199,3666,40720,1604,11,4199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',6590250.35,'AJUSTE DOLARES EN EFECTIVO',NULL,1,'2025-08-15 18:14:59','2025-08-15 18:14:59',NULL),(4200,3666,40720,1604,11,4200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',397503.00,'AJUSTE DOLARES CTA CTE BBVA FRANCES',NULL,1,'2025-08-15 18:22:42','2025-08-15 18:22:42',NULL),(4201,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',68653344.40,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-15 18:39:32','2025-08-15 18:59:04','2025-08-15 18:59:04'),(4202,3666,40720,1604,4,4202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2661486.00,'AMORTIZACION EDIFICIO 4° AÑO',NULL,1,'2025-08-15 18:46:34','2025-08-15 18:59:04','2025-08-15 18:59:04'),(4203,3666,40720,1604,4,4203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',4304419.11,'AMORTIZACION INMUEBLE 4° AÑO',NULL,1,'2025-08-15 18:48:43','2025-08-15 18:59:04','2025-08-15 18:59:04'),(4204,3666,40720,1604,19,4204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',16720000.00,'ALTA SEDE JARDIN AMERICA',NULL,1,'2025-08-15 19:00:51','2025-08-19 08:05:28','2025-08-19 08:05:28');
INSERT INTO `balance_libro` VALUES (4205,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',306854777.86,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-15 19:03:03','2025-08-15 19:56:13','2025-08-15 19:56:13'),(4206,3666,40720,1604,4,4206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',5056885.20,'AMORTIZACION EDIFICIO 4° AÑO',NULL,1,'2025-08-15 19:17:47','2025-08-15 19:56:59','2025-08-15 19:56:59'),(4207,3666,40720,1604,4,4207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',7864618.64,'AMORTIZACION INMUEBLE 4° AÑO',NULL,1,'2025-08-15 19:19:13','2025-08-15 19:56:59','2025-08-15 19:56:59'),(4208,3666,40720,1604,4,4208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',334400.00,'AMORTIZACION SEDE JARDIN AMERICA 1° AÑO',NULL,1,'2025-08-15 19:27:30','2025-08-15 19:56:00','2025-08-15 19:56:00'),(4209,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',293263698.22,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-15 19:58:57','2025-08-15 20:04:21','2025-08-15 20:04:21'),(4210,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',293794204.50,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-15 20:00:33','2025-08-15 20:04:21','2025-08-15 20:04:21'),(4211,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',260506847.12,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-15 20:07:01','2025-08-16 13:29:40','2025-08-16 13:29:40'),(4212,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',302552599.95,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-15 20:08:21','2025-08-16 13:29:40','2025-08-16 13:29:40'),(4213,3666,40720,1604,4,4213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',5056885.20,'AMORTIZACION EDIFICIO 4° AÑO',NULL,1,'2025-08-15 20:12:47','2025-08-16 13:29:40','2025-08-16 13:29:40'),(4214,3666,40720,1604,4,4214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',7864618.64,'AMORTIZACION INMUEBLE 4° AÑO',NULL,1,'2025-08-15 20:14:11','2025-08-16 13:29:40','2025-08-16 13:29:40'),(4215,3666,40720,1604,4,4215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',334400.00,'AMORTIZACION SEDE JARDIN AMERICA 1° AÑO',NULL,1,'2025-08-15 20:15:19','2025-08-16 13:29:40','2025-08-16 13:29:40'),(4216,3666,40720,1598,3,4216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',296436.18,'Pasajes y movilidad 12-2024',NULL,1,'2025-08-16 13:36:19','2025-08-16 13:36:19',NULL),(4217,3666,40720,1604,22,4217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',51120.96,'PASE A CAJA SALDOS A FAVOR GCIAS - IIBB BS AS',NULL,1,'2025-08-16 14:10:15','2025-08-16 14:10:15',NULL),(4218,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',260253414.32,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-16 14:29:59','2025-08-18 11:32:46','2025-08-18 11:32:46'),(4219,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',302552599.95,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-16 14:30:56','2025-08-16 16:27:00','2025-08-16 16:27:00'),(4220,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',269578498.26,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-16 16:29:01','2025-08-18 11:31:14','2025-08-18 11:31:14'),(4221,3666,40720,1604,4,4221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',5056885.20,'AMORTIZACION EDIFICIO 4° AÑO',NULL,1,'2025-08-16 16:33:04','2025-08-18 12:00:48','2025-08-18 12:00:48');
INSERT INTO `balance_libro` VALUES (4222,3666,40720,1604,4,4222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',7864618.64,'AMORTIZACION INMUEBLE 4° AÑO',NULL,1,'2025-08-16 16:34:07','2025-08-18 12:00:53','2025-08-18 12:00:53'),(4223,3666,40720,1604,4,4223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',334400.00,'AMORTIZACION SEDE JARDIN AMERICA 1° AÑO',NULL,1,'2025-08-16 16:34:52','2025-08-18 12:00:58','2025-08-18 12:00:58'),(4224,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',197486234.52,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-18 11:37:52','2025-08-18 11:54:12','2025-08-18 11:54:12'),(4225,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',194953964.50,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-18 12:03:21','2025-08-18 12:13:07','2025-08-18 12:13:07'),(4226,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',194953964.50,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-18 12:15:06','2025-08-21 18:58:14','2025-08-21 18:58:14'),(4238,3666,40720,1604,4,4238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',6837346.01,'Amortización Inmueble 4° año',NULL,1,'2025-08-18 13:43:04','2025-08-21 18:58:08','2025-08-21 18:58:08'),(4239,3666,40720,1604,4,4239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',4365708.20,'Amortización Edificio 4° año',NULL,1,'2025-08-18 13:44:21','2025-08-21 18:58:05','2025-08-21 18:58:05'),(4240,3666,40720,1604,4,4240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',334400.00,'Amortización Sede Jardín América 1° año',NULL,1,'2025-08-18 13:45:38','2025-08-19 08:09:58','2025-08-19 08:09:58'),(4241,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2922157.75,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-18 13:48:16','2025-08-21 18:57:59','2025-08-21 18:57:59'),(4242,3666,40720,1590,19,4242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',16720000.00,'ALTA SEDE JARDIN AMERICA',NULL,1,'2025-08-19 08:05:28','2025-08-21 19:13:23','2025-08-21 19:13:23'),(4243,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',7235746.11,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-19 08:06:33','2025-08-21 18:57:56','2025-08-21 18:57:56'),(4244,3666,40720,1604,4,4244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',479114.92,'Amortización Sede Jardín América 1° año',NULL,1,'2025-08-19 08:09:58','2025-08-21 18:57:49','2025-08-21 18:57:49'),(4245,3666,40720,1594,21,4245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',93742.00,'TRANSF PEDROZO ELEUTERIO',NULL,1,'2025-08-20 18:45:33','2025-08-20 18:45:33',NULL),(4246,3666,40720,1597,21,4246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',262500.00,'PAGO CHEQUE N° 741593',NULL,1,'2025-08-20 18:46:08','2025-08-20 18:46:08',NULL),(4247,3666,40720,1597,21,4247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-15','2024-11-15',150000.00,'PAGO CHEQUE N° 741594',NULL,1,'2025-08-20 18:49:49','2025-08-20 18:49:49',NULL),(4248,3666,40720,1598,21,4248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',35000.00,'TRANSF MARIO BENITEZ',NULL,1,'2025-08-20 18:50:49','2025-08-20 18:50:49',NULL),(4249,3666,40720,1604,21,4249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',70000.00,'TRANSF MARIO BENITEZ',NULL,1,'2025-08-20 18:51:27','2025-08-20 18:51:27',NULL);
INSERT INTO `balance_libro` VALUES (4250,3666,40720,1604,21,3015,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3015,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',58638.78,NULL,NULL,1,'2025-08-21 18:42:08','2025-08-21 18:44:16','2025-08-21 18:44:16'),(4251,3666,40720,1589,21,3016,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3016,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',3783.90,NULL,NULL,1,'2025-08-21 18:46:00','2025-08-21 18:51:15','2025-08-21 18:51:15'),(4252,3666,40720,1604,21,3017,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3017,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',3783.90,NULL,NULL,1,'2025-08-21 19:02:05','2025-08-21 19:02:05',NULL),(4253,3666,40720,1598,10,4253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',490137.39,'Fondo Educ y Prom Cooperativa',NULL,1,'2025-08-21 19:23:05','2025-08-21 19:23:05',NULL),(4254,3666,40720,1598,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',145163380.90,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 19:30:11','2025-08-21 19:32:31','2025-08-21 19:32:31'),(4255,3666,40720,1604,23,4255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',145163380.90,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 19:32:31','2025-08-21 19:40:16','2025-08-21 19:40:16'),(4256,3666,40720,1598,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',145163380.90,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 19:42:36','2025-08-21 19:46:28','2025-08-21 19:46:28'),(4257,3666,40720,1604,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',197486234.52,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 19:48:06','2025-08-21 19:49:42','2025-08-21 19:49:42'),(4258,3666,40720,1593,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',56682245.55,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 19:52:09','2025-08-21 19:52:58','2025-08-21 19:52:58'),(4259,3666,40720,1604,23,4259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',56682245.55,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 19:52:58','2025-08-21 21:14:30','2025-08-21 21:14:30'),(4260,3666,40720,1604,4,4260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',8861984.83,'Amortización Inmueble y Edificio 4° año',NULL,1,'2025-08-21 19:59:36','2025-08-21 19:59:36',NULL),(4261,3666,40720,1604,21,4261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2136595.70,'Gastos R Buser',NULL,1,'2025-08-21 20:04:11','2025-08-21 20:04:11',NULL),(4262,3666,40720,1593,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',60294019.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 22:46:47','2025-08-21 22:49:24','2025-08-21 22:49:24'),(4263,3666,40720,1591,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',18848858.47,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 22:51:02','2025-08-21 22:52:05','2025-08-21 22:52:05'),(4264,3666,40720,1592,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',40405049.95,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 22:53:30','2025-08-21 22:54:55','2025-08-21 22:54:55'),(4265,3666,40720,1593,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',60294019.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 23:01:32','2025-08-21 23:29:39','2025-08-21 23:29:39'),(4266,3666,40720,1604,23,4266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',60294019.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 23:29:39','2025-08-21 23:50:12','2025-08-21 23:50:12');
INSERT INTO `balance_libro` VALUES (4267,3666,40720,1593,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',60294019.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 23:51:34','2025-08-21 23:56:34','2025-08-21 23:56:34'),(4268,3666,40720,1604,23,4268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',60294019.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-08-21 23:56:34','2025-08-21 23:56:34',NULL),(4269,3666,40720,1604,19,4269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',16720000.00,'Anticipo de obra sede jardin america',NULL,1,'2025-08-24 21:56:50','2025-08-24 21:56:50',NULL),(4270,3666,40720,1604,19,4270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',4350000.00,'ajuste anticipo sede jardin america',NULL,1,'2025-08-24 22:03:30','2025-08-24 22:03:30',NULL),(4271,3666,40720,1604,20,4271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',2107000.00,'CANCELACION PARCIAL DEUDA SERGIO DELAPIERRE',NULL,1,'2025-08-25 01:37:33','2025-08-25 01:37:33',NULL),(4272,3666,40849,4596,16,1025,'App\\Models\\PeriodLiquidation',NULL,1025,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',24678.81,NULL,NULL,1,'2025-08-26 12:58:10','2025-08-26 12:58:10',NULL),(4273,3666,40849,4597,16,1037,'App\\Models\\PeriodLiquidation',NULL,1037,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',12482344.31,NULL,NULL,1,'2025-08-26 12:58:40','2025-08-26 12:58:40',NULL),(4274,3666,40849,4598,16,1047,'App\\Models\\PeriodLiquidation',NULL,1047,NULL,NULL,NULL,NULL,NULL,0