-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-32973599-1
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-27 17:46:24','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-27 17:46:24','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=949 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7730,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',400000.00,'s/ Suscripción Capital Social',NULL,1,'2022-08-27 18:48:41','2022-08-27 19:14:04','2022-08-27 19:14:04'),(2,7730,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',400000.00,'s/ Suscripción Capital Social',NULL,1,'2022-08-27 19:14:04','2022-08-27 20:53:05','2022-08-27 20:53:05'),(3,7730,40720,1518,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',100000.00,'s/ Integración Capital Social',NULL,1,'2022-08-27 20:28:27','2022-08-27 20:53:35','2022-08-27 20:53:35'),(4,7730,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',16500.00,'s/ Prestamo',NULL,1,'2022-08-27 20:50:32','2022-08-27 20:53:26','2022-08-27 20:53:26'),(5,7730,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',16500.00,'s/ Activación gastos de constitución',NULL,1,'2022-08-27 20:52:21','2022-08-27 20:53:13','2022-08-27 20:53:13'),(6,7730,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',400000.00,'Suscripción Capital Social',NULL,1,'2022-08-27 20:53:05','2022-08-27 21:14:13','2022-08-27 21:14:13'),(7,7730,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',16500.00,'Activación gastos de constitución',NULL,1,'2022-08-27 20:53:13','2022-08-28 21:33:13','2022-08-28 21:33:13'),(8,7730,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',16500.00,'Prestamo',NULL,1,'2022-08-27 20:53:26','2022-08-28 21:33:13','2022-08-28 21:33:13'),(9,7730,40720,1518,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',100000.00,'Integración Capital Social',NULL,1,'2022-08-27 20:53:35','2022-08-27 21:14:41','2022-08-27 21:14:41'),(10,7730,40720,1519,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',300000.00,'Integración Capital Social',NULL,1,'2022-08-27 20:56:05','2022-08-27 21:15:00','2022-08-27 21:15:00'),(11,7730,40720,1519,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',300000.00,'Puesta a disposición de acciones',NULL,1,'2022-08-27 21:03:08','2022-08-28 21:20:14','2022-08-28 21:20:14'),(12,7730,40720,1518,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',400000.00,'Suscripción Capital Social',NULL,1,'2022-08-27 21:14:13','2022-08-28 21:33:13','2022-08-28 21:33:13'),(13,7730,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',100000.00,'Integración Capital Social',NULL,1,'2022-08-27 21:14:41','2022-08-28 21:24:19','2022-08-28 21:24:19'),(14,7730,40720,1519,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',300000.00,'Integración Capital Social',NULL,1,'2022-08-27 21:15:00','2022-08-28 21:33:13','2022-08-28 21:33:13'),(15,7730,40720,1520,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5272.00,NULL,NULL,1,'2022-08-28 13:01:48','2022-08-28 13:04:51','2022-08-28 13:04:51'),(16,7730,40720,1520,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5272.01,NULL,NULL,1,'2022-08-28 13:04:51','2022-08-28 13:05:09','2022-08-28 13:05:09'),(17,7730,40720,1520,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5271.99,NULL,NULL,1,'2022-08-28 13:05:09','2022-08-28 13:13:02','2022-08-28 13:13:02'),(18,7730,40720,1520,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5271.99,NULL,NULL,1,'2022-08-28 13:13:02','2022-08-28 18:21:56','2022-08-28 18:21:56'),(19,7730,40720,1520,22,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',5271.99,'',NULL,1,'2022-08-28 13:23:52','2022-08-28 15:06:53','2022-08-28 15:06:53'),(20,7730,40720,1520,20,NULL,NULL,NULL,5,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5271.99,NULL,NULL,1,'2022-08-28 15:04:15','2022-08-28 16:39:22','2022-08-28 16:39:22');
INSERT INTO `balance_libro` VALUES (21,7730,40720,1520,20,NULL,NULL,NULL,6,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5272.00,NULL,NULL,1,'2022-08-28 16:43:18','2022-08-28 16:54:30','2022-08-28 16:54:30'),(22,7730,40720,1520,20,NULL,NULL,NULL,7,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5271.99,NULL,NULL,1,'2022-08-28 16:55:29','2022-08-28 23:49:23','2022-08-28 23:49:23'),(23,7730,40720,1520,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3599.35,NULL,NULL,1,'2022-08-28 17:15:31','2022-08-28 21:33:13','2022-08-28 21:33:13'),(24,7730,40720,1520,16,NULL,11,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',217.85,NULL,NULL,1,'2022-08-28 17:55:33','2022-08-28 18:21:07','2022-08-28 18:21:07'),(25,7730,40720,1520,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5271.99,NULL,NULL,1,'2022-08-28 18:21:56','2022-08-28 20:10:04','2022-08-28 20:10:04'),(26,7730,40720,1520,15,NULL,21,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',914.97,NULL,NULL,1,'2022-08-28 18:28:21','2022-08-28 20:09:29','2022-08-28 20:09:29'),(27,7730,40720,1520,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5271.99,NULL,NULL,1,'2022-08-28 20:41:57','2022-08-28 23:31:51','2022-08-28 23:31:51'),(28,7730,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',6050.00,NULL,NULL,1,'2022-08-28 20:53:42','2022-08-28 20:55:00','2022-08-28 20:55:00'),(29,7730,40720,1519,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',400000.00,'Puesta a disposición de acciones',NULL,1,'2022-08-28 21:20:14','2022-08-28 21:33:39','2022-08-28 21:33:39'),(30,7730,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',100000.00,'Integración Capital Social',NULL,1,'2022-08-28 21:24:19','2022-08-28 21:33:59','2022-08-28 21:33:59'),(31,7730,40720,3134,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',400000.00,'s/ Suscripción Capital Social',NULL,1,'2022-08-28 22:32:48','2022-08-28 22:32:48',NULL),(32,7730,40720,3134,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',100000.00,'s/ Integración Capital Social',NULL,1,'2022-08-28 22:33:58','2022-08-28 22:33:58',NULL),(33,7730,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',16500.00,'s/ Prestamo',NULL,1,'2022-08-28 22:36:42','2022-09-02 01:42:33','2022-09-02 01:42:33'),(34,7730,40720,1519,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',16500.00,'s/ Activación gastos de constitución',NULL,1,'2022-08-28 22:40:08','2022-09-02 01:38:39','2022-09-02 01:38:39'),(35,7730,40720,1547,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',300000.00,'s/ Integración Capital Social',NULL,1,'2022-08-28 22:44:48','2022-08-29 00:09:02','2022-08-29 00:09:02'),(36,7730,40720,1519,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',400000.00,'s / Puesta a disposición de acciones',NULL,1,'2022-08-28 22:46:45','2022-08-29 01:47:01','2022-08-29 01:47:01'),(37,7730,40720,1520,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5272.00,NULL,NULL,1,'2022-08-28 23:35:04','2022-09-02 04:23:51','2022-09-02 04:23:51'),(38,7730,40720,1520,20,NULL,NULL,NULL,11,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',5272.00,NULL,NULL,1,'2022-08-28 23:51:22','2022-08-29 00:15:32','2022-08-29 00:15:32'),(39,7730,40720,1520,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3599.35,NULL,NULL,1,'2022-08-28 23:54:12','2022-09-01 02:06:54','2022-09-01 02:06:54'),(40,7730,40720,1520,15,NULL,32,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',914.97,NULL,NULL,1,'2022-08-28 23:56:37','2022-09-02 03:04:36','2022-09-02 03:04:36'),(41,7730,40720,1520,16,NULL,33,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',217.85,NULL,NULL,1,'2022-08-28 23:57:27','2022-09-02 03:04:45','2022-09-02 03:04:45');
INSERT INTO `balance_libro` VALUES (42,7730,40720,1519,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',300000.00,'s/ Integración Capital Social',NULL,1,'2022-08-29 00:09:02','2022-08-29 14:18:09','2022-08-29 14:18:09'),(43,7730,40720,1520,20,NULL,NULL,NULL,12,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5272.00,NULL,NULL,1,'2022-08-29 00:16:35','2022-09-02 04:26:26','2022-09-02 04:26:26'),(44,7730,40720,1521,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',4815.00,NULL,NULL,1,'2022-08-29 00:23:21','2022-08-29 00:27:06','2022-08-29 00:27:06'),(45,7730,40720,1521,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',4815.00,NULL,NULL,1,'2022-08-29 00:27:06','2022-09-02 04:24:05','2022-09-02 04:24:05'),(46,7730,40720,1521,20,NULL,NULL,NULL,15,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',4815.00,NULL,NULL,1,'2022-08-29 00:39:42','2022-09-02 04:26:31','2022-09-02 04:26:31'),(47,7730,40720,1521,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',3267.75,NULL,NULL,1,'2022-08-29 00:42:19','2022-09-01 02:08:15','2022-09-01 02:08:15'),(48,7730,40720,1521,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',3953.98,NULL,NULL,1,'2022-08-29 00:44:09','2022-08-29 01:44:34','2022-08-29 01:44:34'),(49,7730,40720,1521,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-08-29 00:44:09','2022-08-29 01:02:45','2022-08-29 01:02:45'),(50,7730,40720,1521,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',14400.00,NULL,NULL,1,'2022-08-29 00:44:09','2022-08-29 01:02:36','2022-08-29 01:02:36'),(51,7730,40720,1521,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-08-29 00:44:09','2022-08-29 00:56:54','2022-08-29 00:56:54'),(52,7730,40720,1521,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-22','2020-10-22',2990.21,NULL,NULL,1,'2022-08-29 00:44:09','2022-08-29 01:45:25','2022-08-29 01:45:25'),(53,7730,40720,1521,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',989.41,NULL,NULL,1,'2022-08-29 00:44:09','2022-08-29 00:53:15','2022-08-29 00:53:15'),(54,7730,40720,1521,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',989.41,NULL,NULL,1,'2022-08-29 00:53:15','2022-08-29 01:02:22','2022-08-29 01:02:22'),(55,7730,40720,1521,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-08-29 00:56:54','2022-08-29 01:26:01','2022-08-29 01:26:01'),(56,7730,40720,1521,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-08-29 01:12:29','2022-08-29 01:20:08','2022-08-29 01:20:08'),(57,7730,40720,1521,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-08-29 01:20:08','2022-09-02 02:51:17','2022-09-02 02:51:17'),(58,7730,40720,1521,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-08-29 01:26:01','2022-08-29 02:09:54','2022-08-29 02:09:54'),(59,7730,40720,1521,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',989.41,NULL,NULL,1,'2022-08-29 01:31:55','2022-09-02 02:54:54','2022-09-02 02:54:54'),(60,7730,40720,1521,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',14400.00,NULL,NULL,1,'2022-08-29 01:37:02','2022-09-02 02:30:33','2022-09-02 02:30:33'),(61,7730,40720,1521,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',3953.98,NULL,NULL,1,'2022-08-29 01:44:34','2022-08-29 01:44:34',NULL),(62,7730,40720,1521,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-22','2020-10-22',2990.21,NULL,NULL,1,'2022-08-29 01:45:25','2022-08-29 01:45:25',NULL),(63,7730,40720,1521,21,NULL,NULL,NULL,31,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',14400.00,NULL,NULL,1,'2022-08-29 01:53:25','2022-09-02 02:50:01','2022-09-02 02:50:01'),(64,7730,40720,1521,21,NULL,NULL,NULL,32,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-08-29 01:55:39','2022-08-29 01:56:02','2022-08-29 01:56:02');
INSERT INTO `balance_libro` VALUES (65,7730,40720,1521,21,NULL,NULL,NULL,33,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-08-29 01:56:57','2022-08-29 01:59:28','2022-08-29 01:59:28'),(66,7730,40720,1521,21,NULL,NULL,NULL,34,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-08-29 01:59:15','2022-08-29 02:06:13','2022-08-29 02:06:13'),(67,7730,40720,1521,21,NULL,NULL,NULL,35,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-08-29 02:01:13','2022-08-29 02:07:43','2022-08-29 02:07:43'),(68,7730,40720,1521,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-08-29 02:09:54','2022-09-02 02:36:32','2022-09-02 02:36:32'),(69,7730,40720,1521,21,NULL,NULL,NULL,37,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-08-29 02:12:05','2022-09-02 02:02:41','2022-09-02 02:02:41'),(70,7730,40720,1521,21,NULL,NULL,NULL,38,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-08-29 02:13:35','2022-09-02 02:50:52','2022-09-02 02:50:52'),(71,7730,40720,1521,21,NULL,NULL,NULL,39,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',989.41,NULL,NULL,1,'2022-08-29 02:14:47','2022-08-29 02:15:06','2022-08-29 02:15:06'),(72,7730,40720,1521,21,NULL,NULL,NULL,40,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',989.41,NULL,NULL,1,'2022-08-29 02:16:34','2022-09-02 02:54:54','2022-09-02 02:54:54'),(73,7730,40720,1521,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',100.00,NULL,NULL,1,'2022-08-29 02:19:50','2022-08-29 02:19:50',NULL),(74,7730,40720,1519,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',300000.00,'s/ Integración Capital Social',NULL,1,'2022-08-29 14:18:09','2022-11-20 03:15:45','2022-11-20 03:15:45'),(75,7730,40720,1518,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',400000.00,'s / Puesta a disposición de acciones',NULL,1,'2022-08-29 14:20:52','2022-08-29 14:20:52',NULL),(76,7730,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',16500.00,NULL,NULL,1,'2022-08-29 14:28:56','2022-09-02 01:46:41','2022-09-02 01:46:41'),(77,7730,40720,1520,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2178.51,NULL,NULL,1,'2022-09-01 02:06:54','2022-09-01 02:26:51','2022-09-01 02:26:51'),(78,7730,40720,1521,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',1989.67,NULL,NULL,1,'2022-09-01 02:08:15','2022-09-01 02:27:16','2022-09-01 02:27:16'),(79,7730,40720,1520,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2614.21,NULL,NULL,1,'2022-09-01 02:26:51','2022-11-20 03:59:33','2022-11-20 03:59:33'),(80,7730,40720,1521,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',2387.60,NULL,NULL,1,'2022-09-01 02:27:16','2022-09-01 02:27:16',NULL),(81,7730,40720,1521,15,NULL,64,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1205.19,NULL,NULL,1,'2022-09-01 03:32:40','2022-09-02 01:59:23','2022-09-02 01:59:23'),(82,7730,40720,1521,16,NULL,68,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',215.96,NULL,NULL,1,'2022-09-01 04:55:42','2022-09-01 05:05:23','2022-09-01 05:05:23'),(83,7730,40720,1521,16,NULL,68,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',257.74,NULL,NULL,1,'2022-09-01 14:12:13','2022-09-02 01:55:37','2022-09-02 01:55:37'),(84,7730,40720,1522,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',5295.00,NULL,NULL,1,'2022-09-01 14:28:33','2022-09-01 14:33:01','2022-09-01 14:33:01'),(85,7730,40720,1522,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',11754.01,NULL,NULL,1,'2022-09-01 14:28:33','2022-09-01 14:43:32','2022-09-01 14:43:32'),(86,7730,40720,1522,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 14:28:33','2022-09-01 14:33:35','2022-09-01 14:33:35');
INSERT INTO `balance_libro` VALUES (87,7730,40720,1522,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 14:28:33','2022-09-01 14:34:12','2022-09-01 14:34:12'),(88,7730,40720,1522,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-01 14:28:33','2022-09-01 14:38:43','2022-09-01 14:38:43'),(89,7730,40720,1522,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-01 14:28:34','2022-09-01 14:40:17','2022-09-01 14:40:17'),(90,7730,40720,1522,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1959.00,NULL,NULL,1,'2022-09-01 14:28:34','2022-09-01 14:41:46','2022-09-01 14:41:46'),(91,7730,40720,1522,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',150.00,NULL,NULL,1,'2022-09-01 14:28:34','2022-09-01 14:42:46','2022-09-01 14:42:46'),(92,7730,40720,1522,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',5295.00,NULL,NULL,1,'2022-09-01 14:33:01','2022-09-02 04:28:12','2022-09-02 04:28:12'),(93,7730,40720,1522,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 14:33:35','2022-09-01 14:37:19','2022-09-01 14:37:19'),(94,7730,40720,1522,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 14:34:12','2022-09-01 14:35:57','2022-09-01 14:35:57'),(95,7730,40720,1522,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 14:35:57','2022-09-02 04:29:26','2022-09-02 04:29:26'),(96,7730,40720,1522,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 14:37:19','2022-09-02 04:28:43','2022-09-02 04:28:43'),(97,7730,40720,1522,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-01 14:38:43','2022-09-02 04:29:38','2022-09-02 04:29:38'),(98,7730,40720,1522,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-01 14:40:17','2022-09-02 04:30:02','2022-09-02 04:30:02'),(99,7730,40720,1522,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1959.00,NULL,NULL,1,'2022-09-01 14:41:46','2022-09-02 04:30:20','2022-09-02 04:30:20'),(100,7730,40720,1522,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',150.00,NULL,NULL,1,'2022-09-01 14:42:46','2022-09-02 04:30:32','2022-09-02 04:30:32'),(101,7730,40720,1522,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',11754.01,NULL,NULL,1,'2022-09-01 14:43:32','2022-09-02 04:28:27','2022-09-02 04:28:27'),(102,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',2625.62,NULL,NULL,1,'2022-09-01 15:23:37','2022-11-21 23:33:17','2022-11-21 23:33:17'),(103,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',74.38,NULL,NULL,1,'2022-09-01 15:28:43','2022-11-21 23:32:19','2022-11-21 23:32:19'),(104,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',74.38,NULL,NULL,1,'2022-09-01 15:29:36','2022-11-21 23:32:19','2022-11-21 23:32:19'),(105,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',74.38,NULL,NULL,1,'2022-09-01 15:30:15','2022-11-21 23:32:19','2022-11-21 23:32:19'),(106,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',74.38,NULL,NULL,1,'2022-09-01 15:31:01','2022-11-21 23:32:19','2022-11-21 23:32:19'),(107,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',971.40,NULL,NULL,1,'2022-09-01 18:17:30','2022-11-21 23:32:19','2022-11-21 23:32:19'),(108,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',5828.43,NULL,NULL,1,'2022-09-01 18:21:33','2022-11-21 23:31:14','2022-11-21 23:31:14');
INSERT INTO `balance_libro` VALUES (109,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',74.38,NULL,NULL,1,'2022-09-01 18:23:22','2022-11-21 23:31:36','2022-11-21 23:31:36'),(110,7730,40720,1522,20,NULL,NULL,NULL,59,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',5295.00,NULL,NULL,1,'2022-09-01 18:27:19','2022-09-01 18:29:15','2022-09-01 18:29:15'),(111,7730,40720,1522,20,NULL,NULL,NULL,60,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-01 18:29:03','2022-09-01 18:32:07','2022-09-01 18:32:07'),(112,7730,40720,1522,20,NULL,NULL,NULL,61,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',5295.00,NULL,NULL,1,'2022-09-01 18:31:32','2022-09-01 18:51:47','2022-09-01 18:51:47'),(113,7730,40720,1522,20,NULL,NULL,NULL,62,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 18:50:21','2022-09-01 18:50:39','2022-09-01 18:50:39'),(114,7730,40720,1522,20,NULL,NULL,NULL,63,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',5295.00,NULL,NULL,1,'2022-09-01 18:56:40','2022-09-02 04:26:39','2022-09-02 04:26:39'),(115,7730,40720,1522,20,NULL,NULL,NULL,64,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 19:00:43','2022-09-01 19:27:11','2022-09-01 19:27:11'),(116,7730,40720,1522,20,NULL,NULL,NULL,65,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-01 19:28:36','2022-09-02 04:26:35','2022-09-02 04:26:35'),(117,7730,40720,1522,20,NULL,NULL,NULL,66,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 19:30:20','2022-09-02 04:26:43','2022-09-02 04:26:43'),(118,7730,40720,1522,20,NULL,NULL,NULL,67,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 19:32:09','2022-09-01 19:32:44','2022-09-01 19:32:44'),(119,7730,40720,1522,20,NULL,NULL,NULL,68,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-01 19:34:00','2022-09-02 04:26:47','2022-09-02 04:26:47'),(120,7730,40720,1522,20,NULL,NULL,NULL,69,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-01 19:35:26','2022-09-02 04:26:50','2022-09-02 04:26:50'),(121,7730,40720,1522,20,NULL,NULL,NULL,70,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1959.00,NULL,NULL,1,'2022-09-01 19:36:21','2022-09-01 19:36:31','2022-09-01 19:36:31'),(122,7730,40720,1522,20,NULL,NULL,NULL,71,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1959.00,NULL,NULL,1,'2022-09-01 19:37:39','2022-09-02 04:26:54','2022-09-02 04:26:54'),(123,7730,40720,1522,20,NULL,NULL,NULL,72,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',11754.01,NULL,NULL,1,'2022-09-01 19:38:51','2022-09-02 04:26:58','2022-09-02 04:26:58'),(124,7730,40720,1522,20,NULL,NULL,NULL,73,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',150.00,NULL,NULL,1,'2022-09-01 19:39:57','2022-09-02 04:27:02','2022-09-02 04:27:02'),(125,7730,40720,1522,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-10','2020-11-10',1346.89,NULL,NULL,1,'2022-09-02 00:53:11','2022-09-02 00:56:28','2022-09-02 00:56:28'),(126,7730,40720,1522,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-10','2020-11-10',1346.92,NULL,NULL,1,'2022-09-02 00:56:28','2022-09-02 00:57:48','2022-09-02 00:57:48'),(127,7730,40720,1522,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-10','2020-11-10',1346.89,NULL,NULL,1,'2022-09-02 00:57:48','2022-09-02 00:58:14','2022-09-02 00:58:14'),(128,7730,40720,1522,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-10','2020-11-10',1346.89,NULL,NULL,1,'2022-09-02 00:58:14','2022-09-02 00:58:14',NULL),(129,7730,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',16500.00,'s/ Activación gastos de constitución',NULL,1,'2022-09-02 01:38:39','2022-09-02 01:41:51','2022-09-02 01:41:51'),(130,7730,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',16500.00,NULL,NULL,1,'2022-09-02 01:40:14','2022-09-02 01:41:07','2022-09-02 01:41:07');
INSERT INTO `balance_libro` VALUES (131,7730,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',16500.00,NULL,NULL,1,'2022-09-02 01:41:07','2022-09-02 01:42:16','2022-09-02 01:42:16'),(132,7730,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',16500.00,'s/ Activación gastos de constitución',NULL,1,'2022-09-02 01:41:51','2022-09-02 01:41:51',NULL),(133,7730,40720,1519,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',16500.00,NULL,NULL,1,'2022-09-02 01:42:16','2022-11-20 03:47:58','2022-11-20 03:47:58'),(134,7730,40720,1519,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',16500.00,'s/ Prestamo',NULL,1,'2022-09-02 01:42:33','2022-11-21 18:48:12','2022-11-21 18:48:12'),(135,7730,40720,1519,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',16500.00,NULL,NULL,1,'2022-09-02 01:46:41','2022-11-20 03:45:17','2022-11-20 03:45:17'),(136,7730,40720,1521,21,NULL,NULL,NULL,78,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-09-02 02:26:47','2022-09-02 02:36:33','2022-09-02 02:36:33'),(137,7730,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',14400.00,NULL,NULL,1,'2022-09-02 02:33:48','2022-09-02 02:46:12','2022-09-02 02:46:12'),(138,7730,40720,1521,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',14400.00,NULL,NULL,1,'2022-09-02 02:35:14','2022-09-02 02:45:58','2022-09-02 02:45:58'),(139,7730,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-09-02 02:43:37','2022-09-02 02:43:37',NULL),(140,7730,40720,1521,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-09-02 02:44:32','2022-09-02 02:44:32',NULL),(141,7730,40720,1521,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',14400.00,NULL,NULL,1,'2022-09-02 02:45:58','2022-09-02 02:49:13','2022-09-02 02:49:13'),(142,7730,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',14400.00,NULL,NULL,1,'2022-09-02 02:46:12','2022-09-02 02:46:12',NULL),(143,7730,40720,1521,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',14400.00,NULL,NULL,1,'2022-09-02 02:49:13','2022-09-02 03:32:40','2022-09-02 03:32:40'),(144,7730,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-09-02 02:52:39','2022-09-02 02:52:39',NULL),(145,7730,40720,1521,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',786.50,NULL,NULL,1,'2022-09-02 02:53:58','2022-09-02 02:53:58',NULL),(146,7730,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',989.41,NULL,NULL,1,'2022-09-02 02:56:48','2022-09-02 02:56:48',NULL),(147,7730,40720,1521,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',989.41,NULL,NULL,1,'2022-09-02 02:58:22','2022-09-02 02:58:22',NULL),(148,7730,40720,1520,16,NULL,33,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',217.85,NULL,NULL,1,'2022-09-02 03:07:31','2022-09-02 04:20:14','2022-09-02 04:20:14'),(149,7730,40720,1520,15,NULL,32,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',914.97,NULL,NULL,1,'2022-09-02 03:07:52','2022-09-02 04:22:07','2022-09-02 04:22:07'),(150,7730,40720,1521,15,NULL,105,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1205.19,NULL,NULL,1,'2022-09-02 03:08:19','2022-09-02 03:17:18','2022-09-02 03:17:18'),(151,7730,40720,1521,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',747.66,NULL,NULL,1,'2022-09-02 03:17:22','2022-09-02 03:20:56','2022-09-02 03:20:56'),(152,7730,40720,1521,15,NULL,109,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1205.19,NULL,NULL,1,'2022-09-02 03:23:59','2022-09-02 04:22:15','2022-09-02 04:22:15'),(153,7730,40720,1521,16,NULL,110,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',240.75,NULL,NULL,1,'2022-09-02 03:24:27','2022-09-02 04:22:24','2022-09-02 04:22:24');
INSERT INTO `balance_libro` VALUES (154,7730,40720,1521,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',62.30,NULL,NULL,1,'2022-09-02 03:27:04','2022-09-27 01:52:13','2022-09-27 01:52:13'),(155,7730,40720,1521,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',14400.00,NULL,NULL,1,'2022-09-02 03:32:40','2022-09-02 03:32:40',NULL),(156,7730,40720,1520,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5271.99,NULL,NULL,1,'2022-09-02 04:23:51','2022-09-02 04:43:00','2022-09-02 04:43:00'),(157,7730,40720,1521,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',4815.00,NULL,NULL,1,'2022-09-02 04:24:05','2022-09-02 04:24:05',NULL),(158,7730,40720,1522,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',5295.00,NULL,NULL,1,'2022-09-02 04:28:12','2022-09-02 04:28:12',NULL),(159,7730,40720,1522,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',11754.01,NULL,NULL,1,'2022-09-02 04:28:27','2022-09-04 02:29:11','2022-09-04 02:29:11'),(160,7730,40720,1522,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-02 04:28:43','2022-09-02 04:28:43',NULL),(161,7730,40720,1522,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-02 04:29:26','2022-09-02 04:29:26',NULL),(162,7730,40720,1522,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-02 04:29:38','2022-09-02 04:29:38',NULL),(163,7730,40720,1522,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-02 04:30:02','2022-09-02 04:30:02',NULL),(164,7730,40720,1522,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1959.00,NULL,NULL,1,'2022-09-02 04:30:20','2022-09-02 04:30:20',NULL),(165,7730,40720,1522,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',150.00,NULL,NULL,1,'2022-09-02 04:30:32','2022-09-04 02:28:54','2022-09-04 02:28:54'),(166,7730,40720,1520,15,NULL,131,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',914.97,NULL,NULL,1,'2022-09-02 04:36:36','2022-09-02 04:41:36','2022-09-02 04:41:36'),(167,7730,40720,1520,16,NULL,132,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',217.85,NULL,NULL,1,'2022-09-02 04:36:55','2022-09-02 04:42:03','2022-09-02 04:42:03'),(168,7730,40720,1521,15,NULL,133,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1205.19,NULL,NULL,1,'2022-09-02 04:37:31','2022-09-02 04:37:31',NULL),(169,7730,40720,1521,16,NULL,134,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',240.75,NULL,NULL,1,'2022-09-02 04:37:55','2022-09-04 02:55:57','2022-09-04 02:55:57'),(170,7730,40720,1520,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5272.00,NULL,NULL,1,'2022-09-02 04:44:36','2022-09-02 04:44:36',NULL),(171,7730,40720,1520,20,NULL,NULL,NULL,91,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5272.00,NULL,NULL,1,'2022-09-02 04:48:48','2022-09-02 04:48:48',NULL),(172,7730,40720,1521,20,NULL,NULL,NULL,92,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',4815.00,NULL,NULL,1,'2022-09-02 04:50:02','2022-09-02 04:50:02',NULL),(173,7730,40720,1521,20,NULL,NULL,NULL,93,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',5295.00,NULL,NULL,1,'2022-09-02 04:51:17','2022-09-02 05:10:29','2022-09-02 05:10:29'),(174,7730,40720,1522,20,NULL,NULL,NULL,94,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-02 04:52:22','2022-09-02 04:52:22',NULL),(175,7730,40720,1522,20,NULL,NULL,NULL,95,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-02 04:53:18','2022-09-02 04:53:30','2022-09-02 04:53:30'),(176,7730,40720,1522,20,NULL,NULL,NULL,96,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-02 04:54:33','2022-09-02 04:54:33',NULL),(177,7730,40720,1522,20,NULL,NULL,NULL,97,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',150.00,NULL,NULL,1,'2022-09-02 04:55:29','2022-09-02 04:55:29',NULL);
INSERT INTO `balance_libro` VALUES (178,7730,40720,1522,20,NULL,NULL,NULL,98,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',219.00,NULL,NULL,1,'2022-09-02 04:56:45','2022-09-02 04:56:45',NULL),(179,7730,40720,1522,20,NULL,NULL,NULL,99,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1959.00,NULL,NULL,1,'2022-09-02 04:57:54','2022-09-02 04:57:54',NULL),(180,7730,40720,1522,20,NULL,NULL,NULL,100,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',11754.01,NULL,NULL,1,'2022-09-02 04:58:54','2022-09-04 02:28:22','2022-09-04 02:28:22'),(181,7730,40720,1522,20,NULL,NULL,NULL,101,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',150.00,NULL,NULL,1,'2022-09-02 04:59:43','2022-09-04 02:28:10','2022-09-04 02:28:10'),(182,7730,40720,1520,16,NULL,138,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',217.85,NULL,NULL,1,'2022-09-02 05:00:31','2022-09-02 05:00:31',NULL),(183,7730,40720,1520,15,NULL,137,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',914.97,NULL,NULL,1,'2022-09-02 05:01:10','2022-09-02 05:01:10',NULL),(184,7730,40720,1522,20,NULL,NULL,NULL,102,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',5295.00,NULL,NULL,1,'2022-09-02 05:11:36','2022-09-02 05:11:36',NULL),(185,7730,40720,1522,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-07','2020-11-07',907.50,NULL,NULL,1,'2022-09-03 23:02:31','2022-09-03 23:02:31',NULL),(186,7730,40720,1522,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-08','2020-11-08',907.50,NULL,NULL,1,'2022-09-03 23:05:17','2022-09-03 23:05:17',NULL),(187,7730,40720,1522,21,NULL,NULL,NULL,103,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',1346.89,NULL,NULL,1,'2022-09-03 23:06:29','2022-09-03 23:06:29',NULL),(188,7730,40720,1522,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',100.00,NULL,NULL,1,'2022-09-04 01:24:53','2022-09-04 01:31:10','2022-09-04 01:31:10'),(189,7730,40720,1522,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',12895.00,NULL,NULL,1,'2022-09-04 01:27:31','2022-09-04 01:32:10','2022-09-04 01:32:10'),(190,7730,40720,1522,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',100.00,NULL,NULL,1,'2022-09-04 01:31:10','2022-09-04 01:31:10',NULL),(191,7730,40720,1522,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',12895.00,NULL,NULL,1,'2022-09-04 01:32:10','2022-09-04 01:32:10',NULL),(192,7730,40720,1522,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',77.97,NULL,NULL,1,'2022-09-04 01:33:11','2022-09-04 01:34:21','2022-09-04 01:34:21'),(193,7730,40720,1522,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',77.97,NULL,NULL,1,'2022-09-04 01:34:21','2022-09-04 01:34:21',NULL),(194,7730,40720,1522,15,NULL,139,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3453.03,NULL,NULL,1,'2022-09-04 01:37:33','2022-09-04 02:25:47','2022-09-04 02:25:47'),(195,7730,40720,1522,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',150.00,NULL,NULL,1,'2022-09-04 02:28:54','2022-09-04 02:28:54',NULL),(196,7730,40720,1522,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',11754.01,NULL,NULL,1,'2022-09-04 02:29:11','2022-09-04 02:29:11',NULL),(197,7730,40720,1522,20,NULL,NULL,NULL,106,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',11754.01,NULL,NULL,1,'2022-09-04 02:30:53','2022-09-04 02:30:53',NULL),(198,7730,40720,1522,20,NULL,NULL,NULL,107,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',150.00,NULL,NULL,1,'2022-09-04 02:32:18','2022-09-04 02:32:18',NULL),(199,7730,40720,1522,16,NULL,145,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',625.39,NULL,NULL,1,'2022-09-04 02:50:01','2022-09-04 02:50:01',NULL),(200,7730,40720,1522,15,NULL,143,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3453.03,NULL,NULL,1,'2022-09-04 02:50:22','2022-09-04 02:50:22',NULL),(201,7730,40720,1521,16,NULL,134,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',198.97,NULL,NULL,1,'2022-09-04 02:57:06','2022-09-04 02:57:06',NULL);
INSERT INTO `balance_libro` VALUES (202,7730,40720,1522,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',989.41,NULL,NULL,1,'2022-09-04 03:13:22','2022-09-04 03:15:22','2022-09-04 03:15:22'),(203,7730,40720,1522,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',989.41,NULL,NULL,1,'2022-09-04 03:15:22','2022-09-04 03:15:22',NULL),(204,7730,40720,1523,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7239.00,NULL,NULL,1,'2022-09-04 03:29:55','2022-09-04 03:34:24','2022-09-04 03:34:24'),(205,7730,40720,1523,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7239.00,NULL,NULL,1,'2022-09-04 03:29:55','2022-09-04 03:37:12','2022-09-04 03:37:12'),(206,7730,40720,1523,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:40:13','2022-09-04 03:40:13'),(207,7730,40720,1523,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',14478.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:45:21','2022-09-04 03:45:21'),(208,7730,40720,1523,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:49:24','2022-09-04 03:49:24'),(209,7730,40720,1523,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',8685.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:47:43','2022-09-04 03:47:43'),(210,7730,40720,1523,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:51:07','2022-09-04 03:51:07'),(211,7730,40720,1523,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:53:01','2022-09-04 03:53:01'),(212,7730,40720,1523,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:54:26','2022-09-04 03:54:26'),(213,7730,40720,1523,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',8685.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:29:56',NULL),(214,7730,40720,1523,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 03:57:17','2022-09-04 03:57:17'),(215,7730,40720,1523,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',4955.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:18:26','2022-09-04 04:18:26'),(216,7730,40720,1523,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:04:23','2022-09-04 04:04:23'),(217,7730,40720,1523,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:06:04','2022-09-04 04:06:04'),(218,7730,40720,1523,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:07:36','2022-09-04 04:07:36'),(219,7730,40720,1523,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:09:11','2022-09-04 04:09:11'),(220,7730,40720,1523,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:12:01','2022-09-04 04:12:01'),(221,7730,40720,1523,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:13:18','2022-09-04 04:13:18'),(222,7730,40720,1523,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:14:25','2022-09-04 04:14:25'),(223,7730,40720,1523,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',8685.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:10:49','2022-09-04 04:10:49'),(224,7730,40720,1523,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',3880.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:19:28','2022-09-04 04:19:28');
INSERT INTO `balance_libro` VALUES (225,7730,40720,1523,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:15:43','2022-09-04 04:15:43'),(226,7730,40720,1523,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',14478.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:20:58','2022-09-04 04:20:58'),(227,7730,40720,1523,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',7239.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:22:49','2022-09-04 04:22:49'),(228,7730,40720,1523,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',7971.00,NULL,NULL,1,'2022-09-04 03:29:56','2022-09-04 04:24:10','2022-09-04 04:24:10'),(229,7730,40720,1523,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',7239.00,NULL,NULL,1,'2022-09-04 03:29:57','2022-09-04 04:25:04','2022-09-04 04:25:04'),(230,7730,40720,1523,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 03:34:24','2022-09-04 03:35:39','2022-09-04 03:35:39'),(231,7730,40720,1523,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 03:35:39','2022-09-04 03:36:17','2022-09-04 03:36:17'),(232,7730,40720,1523,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 03:36:17','2022-09-04 03:41:24','2022-09-04 03:41:24'),(233,7730,40720,1523,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 03:37:12','2022-09-04 03:42:40','2022-09-04 03:42:40'),(234,7730,40720,1523,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 03:40:13','2022-09-04 03:43:54','2022-09-04 03:43:54'),(235,7730,40720,1523,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 03:41:24','2022-09-04 03:41:24',NULL),(236,7730,40720,1523,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 03:42:40','2022-09-04 03:42:40',NULL),(237,7730,40720,1523,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 03:43:54','2022-09-04 03:43:54',NULL),(238,7730,40720,1523,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',14478.00,NULL,NULL,1,'2022-09-04 03:45:21','2022-09-04 03:45:21',NULL),(239,7730,40720,1523,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',8685.00,NULL,NULL,1,'2022-09-04 03:47:43','2022-09-04 03:47:43',NULL),(240,7730,40720,1523,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',7238.99,NULL,NULL,1,'2022-09-04 03:49:24','2022-09-04 03:49:24',NULL),(241,7730,40720,1523,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',7238.99,NULL,NULL,1,'2022-09-04 03:51:07','2022-09-04 03:51:07',NULL),(242,7730,40720,1523,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',7238.99,NULL,NULL,1,'2022-09-04 03:53:01','2022-09-04 03:53:01',NULL),(243,7730,40720,1523,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',7238.99,NULL,NULL,1,'2022-09-04 03:54:26','2022-09-04 03:54:26',NULL),(244,7730,40720,1523,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 03:57:17','2022-09-04 03:59:00','2022-09-04 03:59:00'),(245,7730,40720,1523,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 03:59:00','2022-09-04 04:02:49','2022-09-04 04:02:49'),(246,7730,40720,1523,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:02:49','2022-09-04 04:02:49',NULL),(247,7730,40720,1523,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:04:23','2022-09-04 04:47:07','2022-09-04 04:47:07');
INSERT INTO `balance_libro` VALUES (248,7730,40720,1523,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:06:04','2022-09-04 04:06:04',NULL),(249,7730,40720,1523,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:07:36','2022-09-04 04:07:36',NULL),(250,7730,40720,1523,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:09:11','2022-09-04 04:09:11',NULL),(251,7730,40720,1523,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',8685.00,NULL,NULL,1,'2022-09-04 04:10:49','2022-09-04 04:10:49',NULL),(252,7730,40720,1523,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:12:01','2022-09-04 04:12:01',NULL),(253,7730,40720,1523,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:13:18','2022-09-04 04:13:18',NULL),(254,7730,40720,1523,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:14:25','2022-09-04 04:14:25',NULL),(255,7730,40720,1523,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:15:43','2022-09-04 04:15:43',NULL),(256,7730,40720,1523,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',4955.00,NULL,NULL,1,'2022-09-04 04:18:26','2022-09-04 04:18:26',NULL),(257,7730,40720,1523,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',3880.00,NULL,NULL,1,'2022-09-04 04:19:28','2022-09-04 04:19:28',NULL),(258,7730,40720,1523,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',14478.00,NULL,NULL,1,'2022-09-04 04:20:58','2022-09-04 04:20:58',NULL),(259,7730,40720,1523,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',7238.99,NULL,NULL,1,'2022-09-04 04:22:49','2022-09-04 04:22:49',NULL),(260,7730,40720,1523,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',7971.00,NULL,NULL,1,'2022-09-04 04:24:10','2022-09-04 04:24:10',NULL),(261,7730,40720,1523,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',7238.99,NULL,NULL,1,'2022-09-04 04:25:04','2022-09-04 04:25:04',NULL),(262,7730,40720,1523,20,NULL,NULL,NULL,166,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 04:29:57','2022-09-04 04:29:57',NULL),(263,7730,40720,1523,20,NULL,NULL,NULL,167,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 04:31:28','2022-09-04 04:31:28',NULL),(264,7730,40720,1523,20,NULL,NULL,NULL,168,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7238.99,NULL,NULL,1,'2022-09-04 04:37:21','2022-09-04 04:37:21',NULL),(265,7730,40720,1523,20,NULL,NULL,NULL,169,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',14478.00,NULL,NULL,1,'2022-09-04 04:38:26','2022-09-04 04:38:26',NULL),(266,7730,40720,1523,20,NULL,NULL,NULL,170,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',8685.00,NULL,NULL,1,'2022-09-04 04:39:39','2022-09-04 04:39:39',NULL),(267,7730,40720,1523,20,NULL,NULL,NULL,171,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',7238.99,NULL,NULL,1,'2022-09-04 04:40:44','2022-09-04 04:40:44',NULL),(268,7730,40720,1523,20,NULL,NULL,NULL,172,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',7238.99,NULL,NULL,1,'2022-09-04 04:42:14','2022-09-04 04:42:14',NULL),(269,7730,40720,1523,20,NULL,NULL,NULL,173,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',7238.99,NULL,NULL,1,'2022-09-04 04:43:41','2022-09-04 04:43:41',NULL),(270,7730,40720,1523,20,NULL,NULL,NULL,174,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',7238.99,NULL,NULL,1,'2022-09-04 04:44:24','2022-09-04 04:44:24',NULL),(271,7730,40720,1523,20,NULL,NULL,NULL,175,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:45:26','2022-09-04 04:45:26',NULL),(272,7730,40720,1523,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:47:07','2022-09-04 04:47:07',NULL);
INSERT INTO `balance_libro` VALUES (273,7730,40720,1523,20,NULL,NULL,NULL,177,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:47:59','2022-09-04 04:47:59',NULL),(274,7730,40720,1523,20,NULL,NULL,NULL,178,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:48:58','2022-09-04 04:48:58',NULL),(275,7730,40720,1523,20,NULL,NULL,NULL,179,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:50:16','2022-09-04 04:50:16',NULL),(276,7730,40720,1523,20,NULL,NULL,NULL,180,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:51:10','2022-09-04 04:51:10',NULL),(277,7730,40720,1523,20,NULL,NULL,NULL,181,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',8685.00,NULL,NULL,1,'2022-09-04 04:52:07','2022-09-04 04:52:07',NULL),(278,7730,40720,1523,20,NULL,NULL,NULL,182,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:53:16','2022-09-04 04:53:16',NULL),(279,7730,40720,1523,20,NULL,NULL,NULL,183,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:54:08','2022-09-04 04:54:08',NULL),(280,7730,40720,1523,20,NULL,NULL,NULL,184,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:55:06','2022-09-04 04:55:06',NULL),(281,7730,40720,1523,20,NULL,NULL,NULL,185,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',7238.99,NULL,NULL,1,'2022-09-04 04:56:15','2022-09-04 04:56:15',NULL),(282,7730,40720,1523,20,NULL,NULL,NULL,186,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',8685.00,NULL,NULL,1,'2022-09-04 04:57:04','2022-09-04 04:57:04',NULL),(283,7730,40720,1523,20,NULL,NULL,NULL,187,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',4955.00,NULL,NULL,1,'2022-09-04 04:57:56','2022-09-04 04:57:56',NULL),(284,7730,40720,1523,20,NULL,NULL,NULL,188,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',3880.00,NULL,NULL,1,'2022-09-04 04:58:49','2022-09-04 04:58:49',NULL),(285,7730,40720,1523,20,NULL,NULL,NULL,189,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',14478.00,NULL,NULL,1,'2022-09-04 04:59:44','2022-09-04 04:59:44',NULL),(286,7730,40720,1523,20,NULL,NULL,NULL,190,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',7238.99,NULL,NULL,1,'2022-09-04 05:00:55','2022-09-04 05:00:55',NULL),(287,7730,40720,1523,20,NULL,NULL,NULL,191,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',7971.00,NULL,NULL,1,'2022-09-04 05:01:50','2022-09-04 05:01:50',NULL),(288,7730,40720,1523,20,NULL,NULL,NULL,192,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',7238.99,NULL,NULL,1,'2022-09-04 05:02:47','2022-09-04 05:02:47',NULL),(289,7730,40720,1523,3,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',1513750.00,NULL,NULL,1,'2022-09-04 05:07:48','2022-09-04 05:17:23','2022-09-04 05:17:23'),(290,7730,40720,1523,3,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',20000.00,NULL,NULL,1,'2022-09-04 05:07:48','2022-09-04 05:28:22','2022-09-04 05:28:22'),(291,7730,40720,1523,3,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',17067.75,NULL,NULL,1,'2022-09-04 05:07:48','2022-09-04 05:13:32','2022-09-04 05:13:32'),(292,7730,40720,1523,3,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',1513750.00,NULL,NULL,1,'2022-09-04 05:07:48','2022-09-04 05:16:20','2022-09-04 05:16:20'),(293,7730,40720,1523,3,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',1513750.00,NULL,NULL,1,'2022-09-04 05:07:49','2022-09-04 05:18:16','2022-09-04 05:18:16'),(294,7730,40720,1523,3,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',84572.83,NULL,NULL,1,'2022-09-04 05:07:49','2022-09-04 10:51:32','2022-09-04 10:51:32'),(295,7730,40720,1523,3,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',5880.60,NULL,NULL,1,'2022-09-04 05:07:49','2022-09-04 10:51:55','2022-09-04 10:51:55'),(296,7730,40720,1523,3,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',47044.80,NULL,NULL,1,'2022-09-04 05:07:49','2022-09-04 10:52:38','2022-09-04 10:52:38');
INSERT INTO `balance_libro` VALUES (297,7730,40720,1523,3,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',21155.94,NULL,NULL,1,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(298,7730,40720,1523,3,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',17067.75,NULL,NULL,1,'2022-09-04 05:13:57','2022-09-04 05:13:57',NULL),(299,7730,40720,1523,3,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',1513750.00,NULL,NULL,1,'2022-09-04 05:16:20','2022-09-04 05:16:20',NULL),(300,7730,40720,1523,3,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',1513750.00,NULL,NULL,1,'2022-09-04 05:17:23','2022-09-04 05:17:23',NULL),(301,7730,40720,1523,3,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',1513750.00,NULL,NULL,1,'2022-09-04 05:18:16','2022-09-04 05:18:16',NULL),(302,7730,40720,1523,21,NULL,NULL,NULL,206,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',17067.75,NULL,NULL,1,'2022-09-04 05:23:20','2022-09-04 05:23:20',NULL),(303,7730,40720,1523,3,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',20000.00,NULL,NULL,1,'2022-09-04 05:28:22','2022-09-04 05:28:22',NULL),(304,7730,40720,1523,21,NULL,NULL,NULL,208,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',20000.00,NULL,NULL,1,'2022-09-04 05:34:03','2022-09-04 05:34:03',NULL),(305,7730,40720,1523,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',989.41,NULL,NULL,1,'2022-09-04 05:35:57','2022-09-04 05:35:57',NULL),(306,7730,40720,1523,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',989.41,NULL,NULL,1,'2022-09-04 05:38:49','2022-09-04 05:38:49',NULL),(307,7730,40720,1523,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',907.50,NULL,NULL,1,'2022-09-04 05:45:29','2022-09-04 05:45:29',NULL),(308,7730,40720,1523,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',907.50,NULL,NULL,1,'2022-09-04 05:46:24','2022-09-04 05:46:24',NULL),(309,7730,40720,1523,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2352.65,NULL,NULL,1,'2022-09-04 05:48:10','2022-09-04 05:48:10',NULL),(310,7730,40720,1523,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',136990.95,NULL,NULL,1,'2022-09-04 05:52:35','2022-09-04 05:52:35',NULL),(311,7730,40720,1523,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1056.92,NULL,NULL,1,'2022-09-04 05:59:25','2022-09-04 05:59:25',NULL),(312,7730,40720,1523,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',12600.00,NULL,NULL,1,'2022-09-04 06:07:47','2022-09-04 06:07:47',NULL),(313,7730,40720,1523,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',20764.00,NULL,NULL,1,'2022-09-04 06:08:47','2022-09-04 06:08:47',NULL),(314,7730,40720,1523,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',31800.00,NULL,NULL,1,'2022-09-04 06:09:35','2022-09-04 06:09:35',NULL),(315,7730,40720,1523,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',90000.00,NULL,NULL,1,'2022-09-04 06:10:26','2022-09-04 06:10:26',NULL),(316,7730,40720,1523,3,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',84572.83,NULL,NULL,1,'2022-09-04 10:51:32','2022-09-04 10:51:32',NULL),(317,7730,40720,1523,3,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',5880.60,NULL,NULL,1,'2022-09-04 10:51:55','2022-09-04 10:51:55',NULL),(318,7730,40720,1523,3,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',47044.80,NULL,NULL,1,'2022-09-04 10:52:38','2022-09-04 10:52:38',NULL),(319,7730,40720,1523,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',90949.06,NULL,NULL,1,'2022-09-05 03:06:33','2022-09-05 03:07:18','2022-09-05 03:07:18'),(320,7730,40720,1523,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',90949.06,NULL,NULL,1,'2022-09-05 03:07:18','2022-11-22 02:14:39','2022-11-22 02:14:39');
INSERT INTO `balance_libro` VALUES (321,7730,40720,1523,15,NULL,232,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',316771.89,NULL,NULL,1,'2022-09-05 03:38:47','2022-11-24 09:35:50','2022-11-24 09:35:50'),(322,7730,40720,1523,16,NULL,233,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',7540.11,NULL,NULL,1,'2022-09-05 03:56:17','2022-09-05 03:56:17',NULL),(323,7730,40720,1523,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',50000.00,'Provisión impuesto a las ganancias',NULL,1,'2022-09-26 13:56:46','2023-01-24 10:24:42','2023-01-24 10:24:42'),(324,7730,40720,1520,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',0.01,'Reclasificación',NULL,1,'2022-09-27 01:42:33','2022-11-20 04:00:40','2022-11-20 04:00:40'),(325,7730,40720,1523,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',0.01,'Reclasificación',NULL,1,'2022-09-27 01:43:37','2022-11-24 11:46:18','2022-11-24 11:46:18'),(326,7730,40720,1521,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',62.30,NULL,NULL,1,'2022-09-27 01:52:13','2022-09-27 01:52:13',NULL),(327,7730,40720,3135,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',300000.00,'s/ Integración Capital Social',NULL,1,'2022-11-20 03:15:45','2022-11-20 03:15:45',NULL),(328,7730,40720,1519,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',16500.00,'s/ Devolución préstamo',NULL,1,'2022-11-20 03:45:17','2022-11-21 18:56:13','2022-11-21 18:56:13'),(329,7730,40720,1519,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',16500.00,'s/ pago gastos de organización',NULL,1,'2022-11-20 03:47:58','2022-11-20 03:47:58',NULL),(330,7730,40720,1520,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2614.21,'s/ CMV',NULL,1,'2022-11-20 03:59:33','2022-11-20 03:59:33',NULL),(331,7730,40720,1520,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',0.01,'s/ Reclasificación',NULL,1,'2022-11-20 04:00:40','2022-11-20 04:00:40',NULL),(332,7730,40720,1519,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',16500.00,'s/ Prestamo',NULL,1,'2022-11-21 18:48:12','2022-11-21 18:48:12',NULL),(333,7730,40720,1519,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',16500.00,'s/ Devolución préstamo',NULL,1,'2022-11-21 18:56:13','2022-11-21 18:56:13',NULL),(334,7730,40720,1522,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',9797.35,NULL,NULL,1,'2022-11-21 23:33:17','2022-11-21 23:33:17',NULL),(335,7730,40720,1523,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',90949.06,'s/ CMV',NULL,1,'2022-11-22 02:14:39','2022-11-22 02:14:39',NULL),(336,7730,40720,1523,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1513750.00,NULL,NULL,1,'2022-11-22 03:10:54','2022-11-22 03:10:54',NULL),(337,7730,40720,1523,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',316771.90,NULL,NULL,1,'2022-11-24 10:43:54','2022-11-24 10:43:54',NULL),(338,7730,40720,1523,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',0.10,NULL,NULL,1,'2022-11-24 11:32:53','2022-11-24 11:36:52','2022-11-24 11:36:52'),(339,7730,40720,1523,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',0.10,NULL,NULL,1,'2022-11-24 11:36:52','2022-11-24 11:36:52',NULL),(340,7730,40720,1523,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3300.00,'Amortización gs de organización',NULL,1,'2023-01-06 14:05:35','2023-01-06 14:05:35',NULL),(341,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',15156.76,'AxI Mercaderias',NULL,1,'2023-01-06 15:02:19','2023-01-06 17:50:54','2023-01-06 17:50:54'),(342,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',20990.04,'AxI Costo de mercaderías vendidas',NULL,1,'2023-01-06 15:07:25','2023-01-06 17:48:13','2023-01-06 17:48:13');
INSERT INTO `balance_libro` VALUES (343,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',90151.72,'AxI Capital',NULL,1,'2023-01-06 15:10:55','2023-01-06 17:54:34','2023-01-06 17:54:34'),(344,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',93.48,'AxI Comisiones Mercado Libre',NULL,1,'2023-01-06 15:24:22','2023-01-06 17:54:23','2023-01-06 17:54:23'),(345,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',4.54,'AxI Gastos varios',NULL,1,'2023-01-06 15:27:15','2023-01-06 17:53:52','2023-01-06 17:53:52'),(346,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1050.02,'AxI Honorarios',NULL,1,'2023-01-06 15:28:33','2023-01-06 17:53:37','2023-01-06 17:53:37'),(347,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',64.23,'AxI IIBB',NULL,1,'2023-01-06 15:30:02','2023-01-06 17:53:17','2023-01-06 17:53:17'),(348,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',93.70,'AxI Servicio de informatica',NULL,1,'2023-01-06 15:33:00','2023-01-06 17:52:58','2023-01-06 17:52:58'),(349,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',111.78,'AxI Servicio de telefonia',NULL,1,'2023-01-06 15:34:14','2023-01-06 17:52:29','2023-01-06 17:52:29'),(350,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1442.32,'AxI Ventas',NULL,1,'2023-01-06 15:35:59','2023-01-06 15:35:59',NULL),(351,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',20990.04,'AxI Costo de mercaderías vendidas',NULL,1,'2023-01-06 17:48:13','2023-01-06 17:51:51','2023-01-06 17:51:51'),(352,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',15156.76,'AxI Mercaderias',NULL,1,'2023-01-06 17:50:54','2023-01-06 17:50:54',NULL),(353,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',20990.04,'AxI Costo de mercaderías vendidas',NULL,1,'2023-01-06 17:51:51','2023-01-06 17:51:51',NULL),(354,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',111.78,'AxI Servicio de telefonia',NULL,1,'2023-01-06 17:52:29','2023-01-06 17:52:29',NULL),(355,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',93.70,'AxI Servicio de informatica',NULL,1,'2023-01-06 17:52:58','2023-01-06 17:52:58',NULL),(356,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',64.23,'AxI IIBB',NULL,1,'2023-01-06 17:53:17','2023-01-06 17:53:17',NULL),(357,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1050.02,'AxI Honorarios',NULL,1,'2023-01-06 17:53:37','2023-01-06 17:53:37',NULL),(358,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',4.54,'AxI Gastos varios',NULL,1,'2023-01-06 17:53:52','2023-01-06 17:53:52',NULL),(359,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',93.48,'AxI Comisiones Mercado Libre',NULL,1,'2023-01-06 17:54:23','2023-01-06 17:54:23',NULL),(360,7730,40720,1523,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',90151.72,'AxI Capital',NULL,1,'2023-01-06 17:54:34','2023-01-06 17:54:34',NULL),(361,7730,40720,1523,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',385942.03,'Refundición de cuentas de resultado',NULL,1,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(362,7730,40720,1523,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',385942.03,'Refundición de resultados',NULL,1,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(363,7730,40720,1523,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2300831.34,'Cierre de cuentas patrimoniales',NULL,1,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL);
INSERT INTO `balance_libro` VALUES (364,7730,40720,1525,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1446.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:15:02','2023-03-27 11:15:02'),(365,7730,40720,1525,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',6490.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:14:55','2023-03-27 11:14:55'),(366,7730,40720,1525,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1600.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:14:48','2023-03-27 11:14:48'),(367,7730,40720,1525,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7590.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:14:39','2023-03-27 11:14:39'),(368,7730,40720,1525,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7590.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:14:31','2023-03-27 11:14:31'),(369,7730,40720,1525,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1500.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:14:21','2023-03-27 11:14:21'),(370,7730,40720,1525,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',19470.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:14:13','2023-03-27 11:14:13'),(371,7730,40720,1525,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:14:04','2023-03-27 11:14:04'),(372,7730,40720,1525,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',7590.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:13:57','2023-03-27 11:13:57'),(373,7730,40720,1525,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:13:48','2023-03-27 11:13:48'),(374,7730,40720,1525,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:13:40','2023-03-27 11:13:40'),(375,7730,40720,1525,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:13:32','2023-03-27 11:13:32'),(376,7730,40720,1525,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7590.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:13:25','2023-03-27 11:13:25'),(377,7730,40720,1525,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:13:19','2023-03-27 11:13:19'),(378,7730,40720,1525,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:13:10','2023-03-27 11:13:10'),(379,7730,40720,1525,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',799.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:13:00','2023-03-27 11:13:00'),(380,7730,40720,1525,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:12:53','2023-03-27 11:12:53'),(381,7730,40720,1525,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:12:46','2023-03-27 11:12:46'),(382,7730,40720,1525,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-26 23:30:20','2023-03-27 11:12:39','2023-03-27 11:12:39'),(383,7730,40720,1525,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:12:11','2023-03-27 11:12:11'),(384,7730,40720,1525,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',150.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:12:02','2023-03-27 11:12:02'),(385,7730,40720,1525,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1379.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:10:53','2023-03-27 11:10:53');
INSERT INTO `balance_libro` VALUES (386,7730,40720,1525,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7590.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:10:44','2023-03-27 11:10:44'),(387,7730,40720,1525,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7819.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:10:36','2023-03-27 11:10:36'),(388,7730,40720,1525,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6490.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:09:34','2023-03-27 11:09:34'),(389,7730,40720,1525,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6490.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:09:26','2023-03-27 11:09:26'),(390,7730,40720,1525,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6490.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:09:19','2023-03-27 11:09:19'),(391,7730,40720,1525,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',8685.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:09:12','2023-03-27 11:09:12'),(392,7730,40720,1525,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8685.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:09:03','2023-03-27 11:09:03'),(393,7730,40720,1525,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',300.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:08:56','2023-03-27 11:08:56'),(394,7730,40720,1525,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',7590.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:08:48','2023-03-27 11:08:48'),(395,7730,40720,1525,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',6490.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:08:41','2023-03-27 11:08:41'),(396,7730,40720,1525,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',8685.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:08:33','2023-03-27 11:08:33'),(397,7730,40720,1525,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:08:26','2023-03-27 11:08:26'),(398,7730,40720,1525,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',7590.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:08:18','2023-03-27 11:08:18'),(399,7730,40720,1525,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:08:12','2023-03-27 11:08:12'),(400,7730,40720,1525,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:08:05','2023-03-27 11:08:05'),(401,7730,40720,1525,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',8685.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:07:58','2023-03-27 11:07:58'),(402,7730,40720,1525,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7590.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:07:48','2023-03-27 11:07:48'),(403,7730,40720,1525,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7590.00,NULL,NULL,1,'2023-03-26 23:30:21','2023-03-27 11:07:36','2023-03-27 11:07:36'),(404,7730,40720,1525,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-26 23:31:17','2023-03-27 11:07:29','2023-03-27 11:07:29'),(405,7730,40720,1525,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6799.00,NULL,NULL,1,'2023-03-26 23:31:17','2023-03-27 11:07:22','2023-03-27 11:07:22'),(406,7730,40720,1525,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',40794.00,NULL,NULL,1,'2023-03-26 23:31:17','2023-03-27 11:07:14','2023-03-27 11:07:14'),(407,7730,40720,1525,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40794.00,NULL,NULL,1,'2023-03-26 23:31:17','2023-03-27 11:06:51','2023-03-27 11:06:51');
INSERT INTO `balance_libro` VALUES (408,7730,40720,1525,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40794.00,NULL,NULL,1,'2023-03-26 23:31:17','2023-03-27 11:06:31','2023-03-27 11:06:31'),(409,7730,40720,1525,3,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',20000.00,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:08:06','2023-03-27 00:08:06'),(410,7730,40720,1525,3,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',1204.90,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-26 23:56:30','2023-03-26 23:56:30'),(411,7730,40720,1525,3,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5719.07,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:07:32','2023-03-27 00:07:32'),(412,7730,40720,1525,3,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',40365.09,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:00:20','2023-03-27 00:00:20'),(413,7730,40720,1525,3,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',12801.20,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:07:15','2023-03-27 00:07:15'),(414,7730,40720,1525,3,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',7234.59,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:07:01','2023-03-27 00:07:01'),(415,7730,40720,1525,3,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',4267.07,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:06:45','2023-03-27 00:06:45'),(416,7730,40720,1525,3,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',10684.52,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:06:20','2023-03-27 00:06:20'),(417,7730,40720,1525,3,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',3298.42,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:05:01','2023-03-27 00:05:01'),(418,7730,40720,1525,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1206.09,NULL,NULL,1,'2023-03-26 23:43:09','2023-03-27 00:03:07','2023-03-27 00:03:07'),(419,7730,40720,1525,3,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',1204.90,NULL,NULL,1,'2023-03-26 23:56:30','2023-03-27 00:08:53','2023-03-27 00:08:53'),(420,7730,40720,1525,3,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',40365.09,NULL,NULL,1,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(421,7730,40720,1525,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1241.12,NULL,NULL,1,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(422,7730,40720,1525,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1206.09,NULL,NULL,1,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(423,7730,40720,1525,3,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',3298.43,NULL,NULL,1,'2023-03-27 00:05:01','2023-03-27 00:09:30','2023-03-27 00:09:30'),(424,7730,40720,1525,3,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',10684.52,NULL,NULL,1,'2023-03-27 00:06:20','2023-03-27 00:06:20',NULL),(425,7730,40720,1525,3,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',4267.07,NULL,NULL,1,'2023-03-27 00:06:45','2023-03-27 00:06:45',NULL),(426,7730,40720,1525,3,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',7234.59,NULL,NULL,1,'2023-03-27 00:07:01','2023-03-27 00:07:01',NULL),(427,7730,40720,1525,3,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',12801.20,NULL,NULL,1,'2023-03-27 00:07:15','2023-03-27 00:07:15',NULL),(428,7730,40720,1525,3,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5719.07,NULL,NULL,1,'2023-03-27 00:07:32','2023-03-27 00:07:32',NULL),(429,7730,40720,1525,3,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',20000.00,NULL,NULL,1,'2023-03-27 00:08:06','2023-03-27 00:08:38','2023-03-27 00:08:38'),(430,7730,40720,1525,3,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',20000.00,NULL,NULL,1,'2023-03-27 00:08:38','2023-03-27 00:08:38',NULL);
INSERT INTO `balance_libro` VALUES (431,7730,40720,1525,3,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',1204.90,NULL,NULL,1,'2023-03-27 00:08:53','2023-03-28 12:44:11','2023-03-28 12:44:11'),(432,7730,40720,1525,3,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',40365.09,NULL,NULL,1,'2023-03-27 00:09:11','2023-03-28 13:21:48','2023-03-28 13:21:48'),(433,7730,40720,1525,3,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',3298.43,NULL,NULL,1,'2023-03-27 00:09:30','2023-03-27 00:09:30',NULL),(434,7730,40720,1525,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1206.09,NULL,NULL,1,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(435,7730,40720,1525,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2300831.34,'Asiento de apertura',NULL,1,'2023-03-27 02:44:00','2023-03-27 02:44:00',NULL),(436,7730,40720,1525,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1446.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:34:42',NULL),(437,7730,40720,1525,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',6490.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:42:48','2023-03-27 14:42:48'),(438,7730,40720,1525,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1600.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:44:21','2023-03-27 14:44:21'),(439,7730,40720,1525,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7590.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:45:24','2023-03-27 14:45:24'),(440,7730,40720,1525,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7590.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:47:13','2023-03-27 14:47:13'),(441,7730,40720,1525,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1500.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:48:01','2023-03-27 14:48:01'),(442,7730,40720,1525,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',19470.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:49:25','2023-03-27 14:49:25'),(443,7730,40720,1525,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:50:41','2023-03-27 14:50:41'),(444,7730,40720,1525,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',7590.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:52:37','2023-03-27 14:52:37'),(445,7730,40720,1525,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 14:34:42','2023-03-27 14:53:54','2023-03-27 14:53:54'),(446,7730,40720,1525,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 14:55:03','2023-03-27 14:55:03'),(447,7730,40720,1525,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 14:56:02','2023-03-27 14:56:02'),(448,7730,40720,1525,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7590.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 14:57:22','2023-03-27 14:57:22'),(449,7730,40720,1525,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 14:58:21','2023-03-27 14:58:21'),(450,7730,40720,1525,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 14:59:37','2023-03-27 14:59:37'),(451,7730,40720,1525,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',799.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:00:29','2023-03-27 15:00:29'),(452,7730,40720,1525,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:06:44','2023-03-27 15:06:44');
INSERT INTO `balance_libro` VALUES (453,7730,40720,1525,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:02:54','2023-03-27 15:02:54'),(454,7730,40720,1525,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:04:08','2023-03-27 15:04:08'),(455,7730,40720,1525,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:04:42','2023-03-27 15:04:42'),(456,7730,40720,1525,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',150.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:05:54','2023-03-27 15:05:54'),(457,7730,40720,1525,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1379.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:08:24','2023-03-27 15:08:24'),(458,7730,40720,1525,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7590.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:11:08','2023-03-27 15:11:08'),(459,7730,40720,1525,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7819.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:12:51','2023-03-27 15:12:51'),(460,7730,40720,1525,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6490.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:14:06','2023-03-27 15:14:06'),(461,7730,40720,1525,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6490.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:14:41','2023-03-27 15:14:41'),(462,7730,40720,1525,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6490.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:15:48','2023-03-27 15:15:48'),(463,7730,40720,1525,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',8685.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:17:10','2023-03-27 15:17:10'),(464,7730,40720,1525,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8685.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:18:09','2023-03-27 15:18:09'),(465,7730,40720,1525,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',300.00,NULL,NULL,1,'2023-03-27 14:34:43','2023-03-27 15:20:22','2023-03-27 15:20:22'),(466,7730,40720,1525,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',7590.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:21:38','2023-03-27 15:21:38'),(467,7730,40720,1525,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',6490.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:22:48','2023-03-27 15:22:48'),(468,7730,40720,1525,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',8685.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:23:55','2023-03-27 15:23:55'),(469,7730,40720,1525,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:25:16','2023-03-27 15:25:16'),(470,7730,40720,1525,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',7590.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:26:08','2023-03-27 15:26:08'),(471,7730,40720,1525,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:27:27','2023-03-27 15:27:27'),(472,7730,40720,1525,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:28:27','2023-03-27 15:28:27'),(473,7730,40720,1525,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',8685.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:29:31','2023-03-27 15:29:31'),(474,7730,40720,1525,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7590.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:30:29','2023-03-27 15:30:29');
INSERT INTO `balance_libro` VALUES (475,7730,40720,1525,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7590.00,NULL,NULL,1,'2023-03-27 14:34:44','2023-03-27 15:31:17','2023-03-27 15:31:17'),(476,7730,40720,1525,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 14:36:03','2023-03-27 15:32:52','2023-03-27 15:32:52'),(477,7730,40720,1525,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6799.00,NULL,NULL,1,'2023-03-27 14:36:03','2023-03-27 15:33:40','2023-03-27 15:33:40'),(478,7730,40720,1525,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',40794.00,NULL,NULL,1,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(479,7730,40720,1525,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40794.00,NULL,NULL,1,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(480,7730,40720,1525,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40794.00,NULL,NULL,1,'2023-03-27 14:36:03','2023-03-27 15:32:17','2023-03-27 15:32:17'),(481,7730,40720,1525,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',6490.00,NULL,NULL,1,'2023-03-27 14:42:48','2023-03-27 14:42:48',NULL),(482,7730,40720,1525,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1600.00,NULL,NULL,1,'2023-03-27 14:44:21','2023-03-27 14:44:21',NULL),(483,7730,40720,1525,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7590.00,NULL,NULL,1,'2023-03-27 14:45:24','2023-03-27 14:45:24',NULL),(484,7730,40720,1525,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7590.00,NULL,NULL,1,'2023-03-27 14:47:13','2023-03-27 14:47:13',NULL),(485,7730,40720,1525,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1500.00,NULL,NULL,1,'2023-03-27 14:48:01','2023-03-27 14:48:01',NULL),(486,7730,40720,1525,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',19470.00,NULL,NULL,1,'2023-03-27 14:49:25','2023-03-27 14:49:25',NULL),(487,7730,40720,1525,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 14:50:41','2023-03-27 14:50:41',NULL),(488,7730,40720,1525,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',7590.00,NULL,NULL,1,'2023-03-27 14:52:37','2023-03-27 14:52:37',NULL),(489,7730,40720,1525,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 14:53:54','2023-03-27 14:53:54',NULL),(490,7730,40720,1525,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 14:55:03','2023-03-27 14:55:03',NULL),(491,7730,40720,1525,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',150.00,NULL,NULL,1,'2023-03-27 14:56:02','2023-03-27 14:56:02',NULL),(492,7730,40720,1525,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7590.00,NULL,NULL,1,'2023-03-27 14:57:22','2023-03-27 14:57:22',NULL),(493,7730,40720,1525,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',150.00,NULL,NULL,1,'2023-03-27 14:58:21','2023-03-27 14:58:21',NULL),(494,7730,40720,1525,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',150.00,NULL,NULL,1,'2023-03-27 14:59:37','2023-03-27 14:59:37',NULL),(495,7730,40720,1525,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',799.00,NULL,NULL,1,'2023-03-27 15:00:29','2023-03-27 15:00:29',NULL),(496,7730,40720,1525,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 15:02:54','2023-03-27 15:02:54',NULL),(497,7730,40720,1525,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 15:04:08','2023-03-27 15:04:08',NULL),(498,7730,40720,1525,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 15:04:42','2023-03-27 15:04:42',NULL);
INSERT INTO `balance_libro` VALUES (499,7730,40720,1525,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',150.00,NULL,NULL,1,'2023-03-27 15:05:54','2023-03-27 15:05:54',NULL),(500,7730,40720,1525,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 15:06:44','2023-03-27 15:06:44',NULL),(501,7730,40720,1525,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1379.00,NULL,NULL,1,'2023-03-27 15:08:24','2023-03-27 15:08:24',NULL),(502,7730,40720,1525,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7590.00,NULL,NULL,1,'2023-03-27 15:11:08','2023-03-27 15:11:08',NULL),(503,7730,40720,1525,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7819.00,NULL,NULL,1,'2023-03-27 15:12:51','2023-03-27 15:12:51',NULL),(504,7730,40720,1525,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6490.00,NULL,NULL,1,'2023-03-27 15:14:06','2023-03-27 15:14:06',NULL),(505,7730,40720,1525,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6490.00,NULL,NULL,1,'2023-03-27 15:14:41','2023-03-27 15:14:41',NULL),(506,7730,40720,1525,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6490.00,NULL,NULL,1,'2023-03-27 15:15:48','2023-03-27 15:15:48',NULL),(507,7730,40720,1525,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',8685.00,NULL,NULL,1,'2023-03-27 15:17:10','2023-03-27 15:17:10',NULL),(508,7730,40720,1525,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8685.00,NULL,NULL,1,'2023-03-27 15:18:09','2023-03-27 15:18:52','2023-03-27 15:18:52'),(509,7730,40720,1525,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8685.00,NULL,NULL,1,'2023-03-27 15:18:52','2023-03-27 15:19:25','2023-03-27 15:19:25'),(510,7730,40720,1525,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8685.00,NULL,NULL,1,'2023-03-27 15:19:25','2023-03-27 15:19:25',NULL),(511,7730,40720,1525,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',300.00,NULL,NULL,1,'2023-03-27 15:20:22','2023-03-27 15:20:22',NULL),(512,7730,40720,1525,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',7590.00,NULL,NULL,1,'2023-03-27 15:21:38','2023-03-27 15:21:38',NULL),(513,7730,40720,1525,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',6490.00,NULL,NULL,1,'2023-03-27 15:22:48','2023-03-27 15:22:48',NULL),(514,7730,40720,1525,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',8685.00,NULL,NULL,1,'2023-03-27 15:23:55','2023-03-27 15:23:55',NULL),(515,7730,40720,1525,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 15:25:16','2023-03-27 15:25:16',NULL),(516,7730,40720,1525,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',7590.00,NULL,NULL,1,'2023-03-27 15:26:08','2023-03-27 15:26:08',NULL),(517,7730,40720,1525,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 15:27:27','2023-03-27 15:27:27',NULL),(518,7730,40720,1525,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 15:28:27','2023-03-27 15:28:27',NULL),(519,7730,40720,1525,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',8685.00,NULL,NULL,1,'2023-03-27 15:29:31','2023-03-27 15:29:31',NULL),(520,7730,40720,1525,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7590.00,NULL,NULL,1,'2023-03-27 15:30:29','2023-03-27 15:30:29',NULL),(521,7730,40720,1525,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7590.00,NULL,NULL,1,'2023-03-27 15:31:17','2023-03-27 15:31:17',NULL),(522,7730,40720,1525,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40794.00,NULL,NULL,1,'2023-03-27 15:32:17','2023-03-27 15:32:17',NULL),(523,7730,40720,1525,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 15:32:52','2023-03-27 15:32:52',NULL);
INSERT INTO `balance_libro` VALUES (524,7730,40720,1525,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6799.00,NULL,NULL,1,'2023-03-27 15:33:40','2023-03-27 15:33:40',NULL),(525,7730,40720,1525,20,NULL,NULL,NULL,372,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',150.00,NULL,NULL,1,'2023-03-27 15:56:08','2023-03-27 15:56:08',NULL),(526,7730,40720,1525,20,NULL,NULL,NULL,373,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',949.00,NULL,NULL,1,'2023-03-27 15:58:45','2023-03-27 15:58:45',NULL),(527,7730,40720,1525,20,NULL,NULL,NULL,374,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',8090.00,NULL,NULL,1,'2023-03-27 16:00:34','2023-03-27 16:00:34',NULL),(528,7730,40720,1525,20,NULL,NULL,NULL,375,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7590.00,NULL,NULL,1,'2023-03-27 16:02:07','2023-03-27 16:02:07',NULL),(529,7730,40720,1525,20,NULL,NULL,NULL,376,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',9090.00,NULL,NULL,1,'2023-03-27 16:03:07','2023-03-27 16:03:07',NULL),(530,7730,40720,1525,20,NULL,NULL,NULL,377,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',19470.00,NULL,NULL,1,'2023-03-27 16:03:59','2023-03-27 16:03:59',NULL),(531,7730,40720,1525,20,NULL,NULL,NULL,378,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 16:05:00','2023-03-27 16:05:00',NULL),(532,7730,40720,1525,20,NULL,NULL,NULL,379,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',7590.00,NULL,NULL,1,'2023-03-27 16:06:03','2023-03-27 16:06:03',NULL),(533,7730,40720,1525,20,NULL,NULL,NULL,380,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 16:06:54','2023-03-27 16:06:54',NULL),(534,7730,40720,1525,20,NULL,NULL,NULL,381,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',150.00,NULL,NULL,1,'2023-03-27 16:07:35','2023-03-27 16:07:35',NULL),(535,7730,40720,1525,20,NULL,NULL,NULL,382,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',150.00,NULL,NULL,1,'2023-03-27 16:08:33','2023-03-27 16:08:33',NULL),(536,7730,40720,1525,20,NULL,NULL,NULL,383,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7590.00,NULL,NULL,1,'2023-03-27 16:09:12','2023-03-27 16:09:12',NULL),(537,7730,40720,1525,20,NULL,NULL,NULL,384,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',150.00,NULL,NULL,1,'2023-03-27 16:09:56','2023-03-27 16:09:56',NULL),(538,7730,40720,1525,20,NULL,NULL,NULL,385,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 16:11:16','2023-03-27 16:11:16',NULL),(539,7730,40720,1525,20,NULL,NULL,NULL,386,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 16:11:52','2023-03-27 16:11:52',NULL),(540,7730,40720,1525,20,NULL,NULL,NULL,387,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 16:12:34','2023-03-27 16:12:34',NULL),(541,7730,40720,1525,20,NULL,NULL,NULL,388,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',1379.00,NULL,NULL,1,'2023-03-27 16:13:20','2023-03-27 16:13:20',NULL),(542,7730,40720,1525,20,NULL,NULL,NULL,389,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7590.00,NULL,NULL,1,'2023-03-27 16:14:22','2023-03-27 16:14:22',NULL),(543,7730,40720,1525,20,NULL,NULL,NULL,390,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7819.00,NULL,NULL,1,'2023-03-27 16:16:08','2023-03-27 16:16:08',NULL),(544,7730,40720,1525,20,NULL,NULL,NULL,391,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6490.00,NULL,NULL,1,'2023-03-27 16:17:14','2023-03-27 16:17:14',NULL),(545,7730,40720,1525,20,NULL,NULL,NULL,392,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6490.00,NULL,NULL,1,'2023-03-27 16:18:43','2023-03-27 16:18:43',NULL),(546,7730,40720,1525,20,NULL,NULL,NULL,393,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6490.00,NULL,NULL,1,'2023-03-27 16:19:37','2023-03-27 16:19:37',NULL),(547,7730,40720,1525,20,NULL,NULL,NULL,394,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',8685.00,NULL,NULL,1,'2023-03-27 16:20:30','2023-03-27 16:20:30',NULL),(548,7730,40720,1525,20,NULL,NULL,NULL,395,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8685.00,NULL,NULL,1,'2023-03-27 16:21:24','2023-03-27 16:21:24',NULL);
INSERT INTO `balance_libro` VALUES (549,7730,40720,1525,20,NULL,NULL,NULL,396,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',300.00,NULL,NULL,1,'2023-03-27 16:30:20','2023-03-27 16:30:20',NULL),(550,7730,40720,1525,20,NULL,NULL,NULL,397,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',7590.00,NULL,NULL,1,'2023-03-27 16:31:13','2023-03-27 16:31:13',NULL),(551,7730,40720,1525,20,NULL,NULL,NULL,398,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',6490.00,NULL,NULL,1,'2023-03-27 16:32:13','2023-03-27 16:32:13',NULL),(552,7730,40720,1525,20,NULL,NULL,NULL,399,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',8685.00,NULL,NULL,1,'2023-03-27 16:33:00','2023-03-27 16:33:00',NULL),(553,7730,40720,1525,20,NULL,NULL,NULL,400,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 16:33:48','2023-03-27 16:33:48',NULL),(554,7730,40720,1525,20,NULL,NULL,NULL,401,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 16:34:55','2023-03-27 16:34:55',NULL),(555,7730,40720,1525,20,NULL,NULL,NULL,402,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6490.00,NULL,NULL,1,'2023-03-27 16:38:54','2023-03-27 16:38:54',NULL),(556,7730,40720,1525,20,NULL,NULL,NULL,403,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',8685.00,NULL,NULL,1,'2023-03-27 16:39:47','2023-03-27 16:39:47',NULL),(557,7730,40720,1525,20,NULL,NULL,NULL,404,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7590.00,NULL,NULL,1,'2023-03-27 16:40:40','2023-03-27 16:40:40',NULL),(558,7730,40720,1525,20,NULL,NULL,NULL,405,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 16:43:44','2023-03-27 16:43:44',NULL),(559,7730,40720,1525,20,NULL,NULL,NULL,406,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6799.00,NULL,NULL,1,'2023-03-27 16:45:38','2023-03-27 16:45:38',NULL),(560,7730,40720,1525,20,NULL,NULL,NULL,407,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40794.00,NULL,NULL,1,'2023-03-27 16:47:49','2023-03-27 16:47:49',NULL),(561,7730,40720,1525,20,NULL,NULL,NULL,408,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',150.00,NULL,NULL,1,'2023-03-27 16:54:51','2023-03-27 16:54:51',NULL),(562,7730,40720,1525,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1446.00,'Devoluciòn s/ nota de credito',NULL,1,'2023-03-27 17:50:11','2023-03-27 18:33:14','2023-03-27 18:33:14'),(563,7730,40720,1525,21,NULL,NULL,NULL,409,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',36966.12,'Transferencia realizada por 50000.00',NULL,1,'2023-03-27 18:30:31','2023-03-28 17:17:32','2023-03-28 17:17:32'),(564,7730,40720,1525,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',1446.00,'Devoluciòn s/ nota de credito',NULL,1,'2023-03-27 18:33:14','2023-03-27 18:33:14',NULL),(565,7730,40720,1525,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',20000.00,'Pago Servicio Marketing Digital',NULL,1,'2023-03-27 18:53:24','2023-03-28 12:39:33','2023-03-28 12:39:33'),(566,7730,40720,1525,21,NULL,NULL,NULL,410,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',137498.23,NULL,NULL,1,'2023-03-27 18:58:21','2023-03-27 18:58:21',NULL),(567,7730,40720,1525,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',190.94,NULL,NULL,1,'2023-03-27 19:01:38','2023-03-27 19:01:38',NULL),(568,7730,40720,1525,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',60000.00,NULL,NULL,1,'2023-03-27 19:02:38','2023-03-27 19:02:38',NULL),(569,7730,40720,1525,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1864.50,NULL,NULL,1,'2023-03-27 19:07:26','2023-03-29 14:18:21','2023-03-29 14:18:21'),(570,7730,40720,1523,15,NULL,234,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',316771.90,NULL,NULL,1,'2023-03-27 19:09:10','2023-03-27 19:10:58','2023-03-27 19:10:58'),(571,7730,40720,1523,15,NULL,234,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',316771.89,NULL,NULL,1,'2023-03-27 19:13:03','2023-03-27 19:59:29','2023-03-27 19:59:29');
INSERT INTO `balance_libro` VALUES (572,7730,40720,1525,15,NULL,455,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',165537.71,NULL,NULL,1,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(573,7730,40720,1525,15,NULL,455,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',47098.17,NULL,NULL,1,'2023-03-27 19:34:18','2023-03-27 19:36:52','2023-03-27 19:36:52'),(574,7730,40720,1525,15,NULL,455,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',165537.70,NULL,NULL,1,'2023-03-27 21:03:03','2023-03-27 21:14:20','2023-03-27 21:14:20'),(575,7730,40720,1525,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',165537.70,'Liquidaciòn IVA 2021-01',NULL,1,'2023-03-27 21:19:55','2023-03-27 21:42:23','2023-03-27 21:42:23'),(576,7730,40720,1525,15,NULL,455,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',165537.70,NULL,NULL,1,'2023-03-27 21:20:23','2023-03-27 21:22:05','2023-03-27 21:22:05'),(577,7730,40720,1525,15,NULL,455,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',165537.71,NULL,NULL,1,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(578,7730,40720,1525,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',165537.70,'Liquidaciòn IVA 2021-01',NULL,1,'2023-03-27 22:10:30','2023-03-27 22:10:30',NULL),(579,7730,40720,1525,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',819.70,'SIRCREB 2021-01',NULL,1,'2023-03-28 10:35:02','2023-03-28 18:35:17','2023-03-28 18:35:17'),(580,7730,40720,1525,16,NULL,456,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',9028.68,NULL,NULL,1,'2023-03-28 11:51:24','2023-03-28 11:55:07','2023-03-28 11:55:07'),(581,7730,40720,1525,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',8524.02,'Liquidación IIBB 2021-01',NULL,1,'2023-03-28 12:01:52','2023-03-28 12:05:19','2023-03-28 12:05:19'),(582,7730,40720,1525,16,NULL,456,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',9028.68,NULL,NULL,1,'2023-03-28 12:02:50','2023-03-28 12:03:38','2023-03-28 12:03:38'),(583,7730,40720,1525,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',9818.46,'Liquidación IIBB 2021-01',NULL,1,'2023-03-28 12:05:19','2023-03-28 18:37:04','2023-03-28 18:37:04'),(584,7730,40720,1525,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1206.09,NULL,NULL,1,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(585,7730,40720,1525,21,NULL,NULL,NULL,412,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',40365.09,NULL,NULL,1,'2023-03-28 12:20:13','2023-03-28 13:21:24','2023-03-28 13:21:24'),(586,7730,40720,1525,21,NULL,NULL,NULL,413,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1206.09,NULL,NULL,1,'2023-03-28 12:22:21','2023-03-28 12:42:47','2023-03-28 12:42:47'),(587,7730,40720,1525,21,NULL,NULL,NULL,414,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',3298.43,NULL,NULL,1,'2023-03-28 12:24:10','2023-03-28 12:24:10',NULL),(588,7730,40720,1525,21,NULL,NULL,NULL,415,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',20000.00,NULL,NULL,1,'2023-03-28 12:40:44','2023-03-28 12:40:44',NULL),(589,7730,40720,1525,21,NULL,NULL,NULL,416,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1206.09,NULL,NULL,1,'2023-03-28 12:46:41','2023-03-28 12:46:41',NULL),(590,7730,40720,1525,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',989.41,'Pago de servicio de telefonía',NULL,1,'2023-03-28 12:50:19','2023-03-28 12:50:19',NULL),(591,7730,40720,1525,3,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',1204.90,NULL,NULL,1,'2023-03-28 13:14:06','2023-03-28 13:16:58','2023-03-28 13:16:58'),(592,7730,40720,1525,3,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',1204.90,NULL,NULL,1,'2023-03-28 13:16:58','2023-03-28 13:41:33','2023-03-28 13:41:33'),(593,7730,40720,1525,3,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',40365.09,NULL,NULL,1,'2023-03-28 13:22:48','2023-03-28 13:24:56','2023-03-28 13:24:56');
INSERT INTO `balance_libro` VALUES (594,7730,40720,1525,3,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',40365.09,NULL,NULL,1,'2023-03-28 13:24:56','2023-03-28 13:24:56',NULL),(595,7730,40720,1525,21,NULL,NULL,NULL,421,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',40365.09,NULL,NULL,1,'2023-03-28 13:26:34','2023-03-28 14:25:03','2023-03-28 14:25:03'),(596,7730,40720,1525,3,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',1204.90,NULL,NULL,1,'2023-03-28 13:41:33','2023-03-28 13:41:33',NULL),(597,7730,40720,1525,21,NULL,NULL,NULL,423,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',39160.19,NULL,NULL,1,'2023-03-28 14:38:52','2023-03-28 14:38:52',NULL),(598,7730,40720,1526,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',9990.00,NULL,NULL,1,'2023-03-28 15:17:33','2023-03-28 15:22:21','2023-03-28 15:22:21'),(599,7730,40720,1526,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7919.00,NULL,NULL,1,'2023-03-28 15:17:33','2023-03-28 15:23:10','2023-03-28 15:23:10'),(600,7730,40720,1526,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',8557.00,NULL,NULL,1,'2023-03-28 15:17:33','2023-03-28 15:23:57','2023-03-28 15:23:57'),(601,7730,40720,1526,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',9990.00,NULL,NULL,1,'2023-03-28 15:17:33','2023-03-28 15:24:57','2023-03-28 15:24:57'),(602,7730,40720,1526,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7590.00,NULL,NULL,1,'2023-03-28 15:17:33','2023-03-28 15:25:56','2023-03-28 15:25:56'),(603,7730,40720,1526,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',2990.00,NULL,NULL,1,'2023-03-28 15:17:33','2023-03-28 15:26:37','2023-03-28 15:26:37'),(604,7730,40720,1526,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',9990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:27:43','2023-03-28 15:27:43'),(605,7730,40720,1526,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',9990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:28:30','2023-03-28 15:28:30'),(606,7730,40720,1526,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',17780.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:20:06','2023-03-28 15:20:06'),(607,7730,40720,1526,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',9990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:29:20','2023-03-28 15:29:20'),(608,7730,40720,1526,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',9990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:30:03','2023-03-28 15:30:03'),(609,7730,40720,1526,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',17780.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:30:46','2023-03-28 15:30:46'),(610,7730,40720,1526,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7919.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:31:38','2023-03-28 15:31:38'),(611,7730,40720,1526,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:33:16','2023-03-28 15:33:16'),(612,7730,40720,1526,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:34:36','2023-03-28 15:34:36'),(613,7730,40720,1526,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',7990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:39:33','2023-03-28 15:39:33'),(614,7730,40720,1526,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3400.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:35:23','2023-03-28 15:35:23'),(615,7730,40720,1526,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2750.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:36:27','2023-03-28 15:36:27'),(616,7730,40720,1526,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',9990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:36:53','2023-03-28 15:36:53');
INSERT INTO `balance_libro` VALUES (617,7730,40720,1526,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',9990.00,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:37:46','2023-03-28 15:37:46'),(618,7730,40720,1526,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',9490.50,NULL,NULL,1,'2023-03-28 15:17:34','2023-03-28 15:38:39','2023-03-28 15:38:39'),(619,7730,40720,1526,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',17780.00,NULL,NULL,1,'2023-03-28 15:21:09','2023-03-28 15:40:44','2023-03-28 15:40:44'),(620,7730,40720,1526,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',9990.00,NULL,NULL,1,'2023-03-28 15:22:21','2023-03-28 15:22:21',NULL),(621,7730,40720,1526,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7919.00,NULL,NULL,1,'2023-03-28 15:23:10','2023-03-28 15:23:10',NULL),(622,7730,40720,1526,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',8557.00,NULL,NULL,1,'2023-03-28 15:23:57','2023-03-28 15:23:57',NULL),(623,7730,40720,1526,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',9990.00,NULL,NULL,1,'2023-03-28 15:24:57','2023-03-28 15:24:57',NULL),(624,7730,40720,1526,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7590.00,NULL,NULL,1,'2023-03-28 15:25:56','2023-03-28 15:25:56',NULL),(625,7730,40720,1526,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',2990.00,NULL,NULL,1,'2023-03-28 15:26:37','2023-03-28 15:26:37',NULL),(626,7730,40720,1526,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',9990.00,NULL,NULL,1,'2023-03-28 15:27:43','2023-03-28 15:27:43',NULL),(627,7730,40720,1526,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',9990.00,NULL,NULL,1,'2023-03-28 15:28:30','2023-03-28 15:28:30',NULL),(628,7730,40720,1526,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',9990.00,NULL,NULL,1,'2023-03-28 15:29:20','2023-03-28 15:29:20',NULL),(629,7730,40720,1526,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',9990.00,NULL,NULL,1,'2023-03-28 15:30:03','2023-03-28 15:30:03',NULL),(630,7730,40720,1526,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',17780.00,NULL,NULL,1,'2023-03-28 15:30:46','2023-03-28 15:30:46',NULL),(631,7730,40720,1526,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7919.00,NULL,NULL,1,'2023-03-28 15:31:38','2023-03-28 15:31:38',NULL),(632,7730,40720,1526,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7990.01,NULL,NULL,1,'2023-03-28 15:33:16','2023-03-28 15:33:38','2023-03-28 15:33:38'),(633,7730,40720,1526,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9990.00,NULL,NULL,1,'2023-03-28 15:34:36','2023-03-28 15:34:36',NULL),(634,7730,40720,1526,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3400.00,NULL,NULL,1,'2023-03-28 15:35:23','2023-03-28 15:35:23',NULL),(635,7730,40720,1526,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2750.00,NULL,NULL,1,'2023-03-28 15:36:27','2023-03-28 15:36:27',NULL),(636,7730,40720,1526,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',9990.00,NULL,NULL,1,'2023-03-28 15:36:53','2023-03-28 15:36:53',NULL),(637,7730,40720,1526,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',9990.00,NULL,NULL,1,'2023-03-28 15:37:46','2023-03-28 15:37:46',NULL),(638,7730,40720,1526,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',9490.50,NULL,NULL,1,'2023-03-28 15:38:39','2023-03-28 15:38:39',NULL),(639,7730,40720,1526,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',7990.01,NULL,NULL,1,'2023-03-28 15:39:33','2023-03-28 15:44:07','2023-03-28 15:44:07'),(640,7730,40720,1526,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',17780.00,NULL,NULL,1,'2023-03-28 15:40:44','2023-03-28 15:40:44',NULL);
INSERT INTO `balance_libro` VALUES (641,7730,40720,1526,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7990.00,NULL,NULL,1,'2023-03-28 15:41:41','2023-03-28 15:43:08','2023-03-28 15:43:08'),(642,7730,40720,1526,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7990.00,NULL,NULL,1,'2023-03-28 15:43:08','2023-03-28 15:43:08',NULL),(643,7730,40720,1526,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',7990.00,NULL,NULL,1,'2023-03-28 15:44:07','2023-03-28 15:44:07',NULL),(644,7730,40720,1526,20,NULL,NULL,NULL,470,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',9990.00,NULL,NULL,1,'2023-03-28 15:45:24','2023-03-28 15:45:24',NULL),(645,7730,40720,1526,20,NULL,NULL,NULL,471,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7919.00,NULL,NULL,1,'2023-03-28 15:49:20','2023-03-28 15:49:20',NULL),(646,7730,40720,1526,20,NULL,NULL,NULL,472,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',8557.00,NULL,NULL,1,'2023-03-28 15:50:10','2023-03-28 15:50:10',NULL),(647,7730,40720,1526,20,NULL,NULL,NULL,473,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',12980.00,NULL,NULL,1,'2023-03-28 15:51:22','2023-03-28 15:51:22',NULL),(648,7730,40720,1526,20,NULL,NULL,NULL,474,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7590.00,NULL,NULL,1,'2023-03-28 15:52:07','2023-03-28 15:52:07',NULL),(649,7730,40720,1526,20,NULL,NULL,NULL,475,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',9990.00,NULL,NULL,1,'2023-03-28 15:52:50','2023-03-28 15:52:50',NULL),(650,7730,40720,1526,20,NULL,NULL,NULL,476,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',9990.00,NULL,NULL,1,'2023-03-28 15:53:55','2023-03-28 15:53:55',NULL),(651,7730,40720,1526,20,NULL,NULL,NULL,477,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',9990.00,NULL,NULL,1,'2023-03-28 15:54:34','2023-03-28 15:54:34',NULL),(652,7730,40720,1526,20,NULL,NULL,NULL,478,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',27770.00,NULL,NULL,1,'2023-03-28 15:55:24','2023-03-28 15:55:24',NULL),(653,7730,40720,1526,20,NULL,NULL,NULL,479,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7919.00,NULL,NULL,1,'2023-03-28 15:56:05','2023-03-28 15:56:05',NULL),(654,7730,40720,1526,20,NULL,NULL,NULL,480,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9990.00,NULL,NULL,1,'2023-03-28 15:56:48','2023-03-28 15:56:48',NULL),(655,7730,40720,1526,20,NULL,NULL,NULL,481,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3400.00,NULL,NULL,1,'2023-03-28 15:57:28','2023-03-28 15:57:28',NULL),(656,7730,40720,1526,20,NULL,NULL,NULL,482,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',12740.00,NULL,NULL,1,'2023-03-28 16:00:04','2023-03-28 16:00:04',NULL),(657,7730,40720,1526,20,NULL,NULL,NULL,483,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',9990.00,NULL,NULL,1,'2023-03-28 16:00:52','2023-03-28 16:00:52',NULL),(658,7730,40720,1526,20,NULL,NULL,NULL,484,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7990.00,NULL,NULL,1,'2023-03-28 16:01:53','2023-03-28 16:01:53',NULL),(659,7730,40720,1526,20,NULL,NULL,NULL,485,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',9490.50,NULL,NULL,1,'2023-03-28 16:02:38','2023-03-28 16:02:38',NULL),(660,7730,40720,1526,20,NULL,NULL,NULL,486,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',17780.00,NULL,NULL,1,'2023-03-28 16:03:43','2023-03-28 16:03:43',NULL),(661,7730,40720,1526,20,NULL,NULL,NULL,487,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',7990.00,NULL,NULL,1,'2023-03-28 16:04:41','2023-03-28 16:04:41',NULL),(662,7730,40720,1526,3,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',25003.44,NULL,NULL,1,'2023-03-28 16:08:42','2023-03-29 10:33:33','2023-03-29 10:33:33'),(663,7730,40720,1526,3,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',2244.43,NULL,NULL,1,'2023-03-28 16:08:42','2023-03-29 10:33:15','2023-03-29 10:33:15'),(664,7730,40720,1526,3,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',20000.00,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-28 16:10:10','2023-03-28 16:10:10');
INSERT INTO `balance_libro` VALUES (665,7730,40720,1526,3,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1754.50,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-28 16:10:37','2023-03-28 16:10:37'),(666,7730,40720,1526,3,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',4378.50,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-29 10:32:55','2023-03-29 10:32:55'),(667,7730,40720,1526,3,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',42059.18,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-28 16:13:57','2023-03-28 16:13:57'),(668,7730,40720,1526,3,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5307.97,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-29 10:32:43','2023-03-29 10:32:43'),(669,7730,40720,1526,3,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',4267.07,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-29 10:36:56','2023-03-29 10:36:56'),(670,7730,40720,1526,3,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',5103.78,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-29 10:32:30','2023-03-29 10:32:30'),(671,7730,40720,1526,3,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',5934.14,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-29 10:32:13','2023-03-29 10:32:13'),(672,7730,40720,1526,3,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',29520.61,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-29 10:31:59','2023-03-29 10:31:59'),(673,7730,40720,1526,3,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',12374.31,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-29 10:31:45','2023-03-29 10:31:45'),(674,7730,40720,1526,3,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1206.09,NULL,NULL,1,'2023-03-28 16:08:43','2023-03-28 16:16:33','2023-03-28 16:16:33'),(675,7730,40720,1526,3,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',20000.00,NULL,NULL,1,'2023-03-28 16:10:10','2023-03-28 16:14:44','2023-03-28 16:14:44'),(676,7730,40720,1526,3,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',42059.18,NULL,NULL,1,'2023-03-28 16:13:57','2023-03-28 16:13:57',NULL),(677,7730,40720,1526,3,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',20000.00,NULL,NULL,1,'2023-03-28 16:14:44','2023-03-28 16:14:44',NULL),(678,7730,40720,1526,3,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1206.09,NULL,NULL,1,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(679,7730,40720,1526,21,NULL,NULL,NULL,505,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',42059.18,NULL,NULL,1,'2023-03-28 16:17:50','2023-03-28 16:17:50',NULL),(680,7730,40720,1526,21,NULL,NULL,NULL,506,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',20000.00,NULL,NULL,1,'2023-03-28 16:20:44','2023-03-28 16:20:44',NULL),(681,7730,40720,1526,20,NULL,NULL,NULL,507,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1206.09,NULL,NULL,1,'2023-03-28 16:21:40','2023-03-28 16:45:54','2023-03-28 16:45:54'),(682,7730,40720,1526,21,NULL,NULL,NULL,508,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1206.09,NULL,NULL,1,'2023-03-28 16:46:32','2023-03-28 16:46:32',NULL),(683,7730,40720,1525,21,NULL,NULL,NULL,509,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',50000.00,NULL,NULL,1,'2023-03-28 17:19:46','2023-03-28 17:19:46',NULL),(684,7730,40720,1526,21,NULL,NULL,NULL,510,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',90000.00,NULL,NULL,1,'2023-03-28 17:23:20','2023-03-28 17:23:20',NULL),(685,7730,40720,1526,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',90000.00,'Transferencia entre cuentas propias',NULL,1,'2023-03-28 17:30:53','2023-03-28 17:30:53',NULL),(686,7730,40720,1526,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',59000.00,'Transferencia entre cuentas propias',NULL,1,'2023-03-28 17:31:54','2023-03-28 17:31:54',NULL),(687,7730,40720,1526,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',9512.14,'Tarjetas bancarias',NULL,1,'2023-03-28 17:35:30','2023-03-28 17:35:30',NULL);
INSERT INTO `balance_libro` VALUES (688,7730,40720,1526,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1351.52,NULL,NULL,1,'2023-03-28 17:37:58','2023-03-28 18:44:55','2023-03-28 18:44:55'),(689,7730,40720,1525,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2019.70,'SIRCREB 2021-01',NULL,1,'2023-03-28 18:35:17','2023-03-29 14:18:41','2023-03-29 14:18:41'),(690,7730,40720,1525,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',11018.46,'Liquidación IIBB 2021-01',NULL,1,'2023-03-28 18:37:04','2023-03-28 18:37:04',NULL),(691,7730,40720,1526,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',6893.94,'BANCO',NULL,1,'2023-03-28 18:44:55','2023-03-29 10:30:14','2023-03-29 10:30:14'),(692,7730,40720,1526,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',16059.63,'Liquidación IIBB 2021-02',NULL,1,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(693,7730,40719,4,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',143847.18,'Liquidaciòn IVA 2021-02',NULL,1,'2023-03-29 02:13:56','2023-03-29 10:15:34','2023-03-29 10:15:34'),(694,7730,40720,1526,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',143847.18,'Liquidaciòn IVA 2021-02',NULL,1,'2023-03-29 02:17:44','2023-03-29 02:17:44',NULL),(695,7730,40720,1526,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',7073.94,'BANCO',NULL,1,'2023-03-29 10:30:14','2023-03-29 14:15:36','2023-03-29 14:15:36'),(696,7730,40720,1526,3,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',12374.31,NULL,NULL,1,'2023-03-29 10:31:45','2023-03-29 10:31:45',NULL),(697,7730,40720,1526,3,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',29520.61,NULL,NULL,1,'2023-03-29 10:31:59','2023-03-29 10:31:59',NULL),(698,7730,40720,1526,3,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',5934.14,NULL,NULL,1,'2023-03-29 10:32:13','2023-03-29 10:32:13',NULL),(699,7730,40720,1526,3,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',5103.78,NULL,NULL,1,'2023-03-29 10:32:30','2023-03-29 10:32:30',NULL),(700,7730,40720,1526,3,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5307.97,NULL,NULL,1,'2023-03-29 10:32:43','2023-03-29 10:32:43',NULL),(701,7730,40720,1526,3,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',4378.50,NULL,NULL,1,'2023-03-29 10:32:55','2023-03-29 10:32:55',NULL),(702,7730,40720,1526,3,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',2244.43,NULL,NULL,1,'2023-03-29 10:33:15','2023-03-29 10:33:15',NULL),(703,7730,40720,1526,3,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',25003.44,NULL,NULL,1,'2023-03-29 10:33:33','2023-03-29 10:33:33',NULL),(704,7730,40720,1526,3,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',4267.07,NULL,NULL,1,'2023-03-29 10:36:56','2023-03-29 10:36:56',NULL),(705,7730,40720,1527,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2000.00,NULL,NULL,1,'2023-03-29 10:40:16','2023-03-29 10:42:31','2023-03-29 10:42:31'),(706,7730,40720,1527,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6800.00,NULL,NULL,1,'2023-03-29 10:40:16','2023-03-29 10:42:06','2023-03-29 10:42:06'),(707,7730,40720,1527,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',2397.00,NULL,NULL,1,'2023-03-29 10:40:16','2023-03-29 10:43:38','2023-03-29 10:43:38'),(708,7730,40720,1527,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',7990.00,NULL,NULL,1,'2023-03-29 10:40:16','2023-03-29 10:45:21','2023-03-29 10:45:21'),(709,7730,40720,1527,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7830.00,NULL,NULL,1,'2023-03-29 10:40:16','2023-03-29 10:47:01','2023-03-29 10:47:01'),(710,7730,40720,1527,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1500.00,NULL,NULL,1,'2023-03-29 10:40:16','2023-03-29 10:47:18','2023-03-29 10:47:18');
INSERT INTO `balance_libro` VALUES (711,7730,40720,1527,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7990.00,NULL,NULL,1,'2023-03-29 10:40:16','2023-03-29 10:47:55','2023-03-29 10:47:55'),(712,7730,40720,1527,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6800.00,NULL,NULL,1,'2023-03-29 10:42:06','2023-03-29 10:42:06',NULL),(713,7730,40720,1527,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2000.00,NULL,NULL,1,'2023-03-29 10:42:31','2023-03-29 10:42:31',NULL),(714,7730,40720,1527,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',2397.00,NULL,NULL,1,'2023-03-29 10:43:38','2023-03-29 11:05:47','2023-03-29 11:05:47'),(715,7730,40720,1527,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',7990.00,NULL,NULL,1,'2023-03-29 10:45:21','2023-03-29 10:45:21',NULL),(716,7730,40720,1527,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7830.00,NULL,NULL,1,'2023-03-29 10:47:01','2023-03-29 11:22:52','2023-03-29 11:22:52'),(717,7730,40720,1527,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1500.00,NULL,NULL,1,'2023-03-29 10:47:18','2023-03-29 11:23:17','2023-03-29 11:23:17'),(718,7730,40720,1527,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7990.00,NULL,NULL,1,'2023-03-29 10:47:55','2023-03-29 11:23:51','2023-03-29 11:23:51'),(719,7730,40720,1527,20,NULL,NULL,NULL,534,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8800.00,NULL,NULL,1,'2023-03-29 10:50:15','2023-03-29 10:50:15',NULL),(720,7730,40720,1527,20,NULL,NULL,NULL,535,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',7990.00,NULL,NULL,1,'2023-03-29 10:53:20','2023-03-29 10:53:20',NULL),(721,7730,40720,1527,20,NULL,NULL,NULL,536,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',2397.00,NULL,NULL,1,'2023-03-29 11:05:46','2023-03-29 11:05:46',NULL),(722,7730,40720,1527,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',2397.00,NULL,NULL,1,'2023-03-29 11:05:47','2023-03-29 11:05:47',NULL),(723,7730,40720,1527,20,NULL,NULL,NULL,538,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7830.00,NULL,NULL,1,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(724,7730,40720,1527,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7830.00,NULL,NULL,1,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(725,7730,40720,1527,20,NULL,NULL,NULL,540,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1500.00,NULL,NULL,1,'2023-03-29 11:23:16','2023-03-29 11:23:16',NULL),(726,7730,40720,1527,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1500.00,NULL,NULL,1,'2023-03-29 11:23:17','2023-03-29 11:23:17',NULL),(727,7730,40720,1527,20,NULL,NULL,NULL,542,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7990.00,NULL,NULL,1,'2023-03-29 11:23:50','2023-03-29 11:23:50',NULL),(728,7730,40720,1527,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7990.00,NULL,NULL,1,'2023-03-29 11:23:51','2023-03-29 11:23:51',NULL),(729,7730,40720,1527,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1206.09,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 13:05:26','2023-03-29 13:05:26'),(730,7730,40720,1527,3,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',31867.42,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:39:39','2023-03-29 11:39:39'),(731,7730,40720,1527,3,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',4653.66,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:30:03','2023-03-29 11:30:03'),(732,7730,40720,1527,3,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',6053.03,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:29:51','2023-03-29 11:29:51'),(733,7730,40720,1527,3,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7567.64,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:29:38','2023-03-29 11:29:38');
INSERT INTO `balance_libro` VALUES (734,7730,40720,1527,3,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6969.60,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:29:25','2023-03-29 11:29:25'),(735,7730,40720,1527,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5454.80,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:29:14','2023-03-29 11:29:14'),(736,7730,40720,1527,3,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7567.64,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:28:59','2023-03-29 11:28:59'),(737,7730,40720,1527,3,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',5767.16,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:28:45','2023-03-29 11:28:45'),(738,7730,40720,1527,3,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',4267.07,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:28:34','2023-03-29 11:28:34'),(739,7730,40720,1527,3,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',20000.00,NULL,NULL,1,'2023-03-29 11:27:14','2023-03-29 11:28:21','2023-03-29 11:28:21'),(740,7730,40720,1527,3,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',20000.00,NULL,NULL,1,'2023-03-29 11:28:21','2023-03-29 13:07:14','2023-03-29 13:07:14'),(741,7730,40720,1527,3,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',4267.07,NULL,NULL,1,'2023-03-29 11:28:34','2023-03-29 13:09:37','2023-03-29 13:09:37'),(742,7730,40720,1527,3,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',5767.16,NULL,NULL,1,'2023-03-29 11:28:45','2023-03-29 11:28:45',NULL),(743,7730,40720,1527,3,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7567.64,NULL,NULL,1,'2023-03-29 11:28:59','2023-03-29 11:28:59',NULL),(744,7730,40720,1527,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5454.80,NULL,NULL,1,'2023-03-29 11:29:14','2023-03-29 13:12:50','2023-03-29 13:12:50'),(745,7730,40720,1527,3,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6969.60,NULL,NULL,1,'2023-03-29 11:29:25','2023-03-29 11:29:25',NULL),(746,7730,40720,1527,3,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7567.64,NULL,NULL,1,'2023-03-29 11:29:38','2023-03-29 11:29:38',NULL),(747,7730,40720,1527,3,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',6053.03,NULL,NULL,1,'2023-03-29 11:29:51','2023-03-29 11:29:51',NULL),(748,7730,40720,1527,3,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',4653.66,NULL,NULL,1,'2023-03-29 11:30:03','2023-03-29 11:30:03',NULL),(749,7730,40720,1527,3,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',39278.17,NULL,NULL,1,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(750,7730,40720,1527,3,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',31867.42,NULL,NULL,1,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(751,7730,40720,1527,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1206.09,NULL,NULL,1,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(752,7730,40720,1527,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1206.09,NULL,NULL,1,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(753,7730,40720,1527,21,NULL,NULL,NULL,568,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',20000.00,NULL,NULL,1,'2023-03-29 13:07:13','2023-03-29 13:07:13',NULL),(754,7730,40720,1527,3,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',20000.00,NULL,NULL,1,'2023-03-29 13:07:14','2023-03-29 13:07:14',NULL),(755,7730,40720,1527,21,NULL,NULL,NULL,570,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',31867.42,NULL,NULL,1,'2023-03-29 13:07:54','2023-03-29 13:07:54',NULL),(756,7730,40720,1527,3,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',31867.42,NULL,NULL,1,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL);
INSERT INTO `balance_libro` VALUES (757,7730,40720,1527,21,NULL,NULL,NULL,572,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',11721.00,NULL,NULL,1,'2023-03-29 13:09:36','2023-03-29 13:09:36',NULL),(758,7730,40720,1527,3,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',4267.07,NULL,NULL,1,'2023-03-29 13:09:37','2023-03-29 13:09:37',NULL),(759,7730,40720,1527,21,NULL,NULL,NULL,574,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',67248.27,NULL,NULL,1,'2023-03-29 13:12:50','2023-03-29 13:19:28','2023-03-29 13:19:28'),(760,7730,40720,1527,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5454.80,NULL,NULL,1,'2023-03-29 13:12:50','2023-03-29 13:21:22','2023-03-29 13:21:22'),(761,7730,40720,1527,21,NULL,NULL,NULL,576,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1206.09,NULL,NULL,1,'2023-03-29 13:14:05','2023-03-29 14:54:23','2023-03-29 14:54:23'),(762,7730,40720,1527,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1206.09,NULL,NULL,1,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(763,7730,40720,1527,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',100000.00,'Transferencia entre cuentas propias',NULL,1,'2023-03-29 13:15:28','2023-03-29 13:15:28',NULL),(764,7730,40720,1527,21,NULL,NULL,NULL,578,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',67248.27,NULL,NULL,1,'2023-03-29 13:21:21','2023-03-29 13:21:21',NULL),(765,7730,40720,1527,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5454.80,NULL,NULL,1,'2023-03-29 13:21:22','2023-03-29 13:21:22',NULL),(766,7730,40720,1527,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1513750.00,'Préstamo PF',NULL,1,'2023-03-29 13:24:22','2023-03-29 13:25:38','2023-03-29 13:25:38'),(767,7730,40720,1527,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1513750.00,'Préstamo PF',NULL,1,'2023-03-29 13:25:38','2023-03-29 14:05:27','2023-03-29 14:05:27'),(768,7730,40720,1525,21,NULL,NULL,NULL,580,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',1513750.00,NULL,NULL,1,'2023-03-29 13:30:40','2023-03-29 14:02:04','2023-03-29 14:02:04'),(769,7730,40720,1527,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',28883.78,'Anticipo de CLIENTES',NULL,1,'2023-03-29 13:33:08','2023-03-29 13:35:27','2023-03-29 13:35:27'),(770,7730,40720,1527,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1446.00,'Anticipo de CLIENTES',NULL,1,'2023-03-29 13:35:27','2023-03-29 13:45:00','2023-03-29 13:45:00'),(771,7730,40720,1527,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1446.00,'Anticipo de CLIENTES',NULL,1,'2023-03-29 13:45:00','2023-03-29 13:51:40','2023-03-29 13:51:40'),(772,7730,40720,1527,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',28883.78,'Anticipo de PROVEEDORES',NULL,1,'2023-03-29 13:47:13','2023-03-29 13:47:13',NULL),(773,7730,40720,1525,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',1513750.00,'Pago Acreedores Varios',NULL,1,'2023-03-29 14:04:43','2023-03-29 14:04:43',NULL),(774,7730,40720,1525,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1513750.00,'Préstamo PF',NULL,1,'2023-03-29 14:05:27','2023-03-30 12:36:06','2023-03-30 12:36:06'),(775,7730,40720,1527,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3115.00,'BANCO 2021-03',NULL,1,'2023-03-29 14:14:02','2023-03-29 14:42:44','2023-03-29 14:42:44'),(776,7730,40720,1526,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',7073.94,'BANCO 2021-02',NULL,1,'2023-03-29 14:15:36','2023-03-29 14:15:36',NULL),(777,7730,40720,1525,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',3884.20,'BANCO 2021-01',NULL,1,'2023-03-29 14:18:21','2023-03-29 14:18:21',NULL),(778,7730,40720,1527,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',123955.22,'Liquidaciòn IVA 2021-03',NULL,1,'2023-03-29 14:34:19','2023-03-29 14:34:19',NULL);
INSERT INTO `balance_libro` VALUES (779,7730,40720,1527,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3115.00,'BANCO 2021-03',NULL,1,'2023-03-29 14:42:44','2023-03-29 15:05:30','2023-03-29 15:05:30'),(780,7730,40720,1527,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1206.09,NULL,NULL,1,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(781,7730,40720,1527,21,NULL,NULL,NULL,582,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1206.09,NULL,NULL,1,'2023-03-29 14:56:01','2023-03-29 14:56:01',NULL),(782,7730,40720,1527,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3115.00,'BANCO 2021-03',NULL,1,'2023-03-29 15:05:30','2023-03-29 15:05:30',NULL),(783,7730,40720,1527,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',13308.07,'Liquidación IIBB 2021-03',NULL,1,'2023-03-29 15:10:15','2023-03-29 15:10:15',NULL),(784,7730,40720,1528,3,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1206.09,NULL,NULL,1,'2023-03-29 17:30:47','2023-03-29 17:32:16','2023-03-29 17:32:16'),(785,7730,40720,1528,3,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1206.09,NULL,NULL,1,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(786,7730,40720,1528,21,NULL,NULL,NULL,585,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1206.09,NULL,NULL,1,'2023-03-29 17:36:56','2023-03-29 18:41:50','2023-03-29 18:41:50'),(787,7730,40720,1528,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3272.48,'BANCO 2021-04',NULL,1,'2023-03-29 17:41:58','2023-03-29 17:41:58',NULL),(788,7730,40720,1528,15,NULL,631,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',117827.32,NULL,NULL,1,'2023-03-29 17:46:52','2023-03-29 17:48:06','2023-03-29 17:48:06'),(789,7730,40720,1528,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',117827.35,'Liquidación IVA 2021-04',NULL,1,'2023-03-29 17:50:36','2023-03-29 17:50:36',NULL),(790,7730,40720,1528,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',11983.22,'Liquidación IIBB 2021-04',NULL,1,'2023-03-29 18:26:46','2023-03-29 18:26:46',NULL),(791,7730,40720,1529,3,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',261.88,NULL,NULL,1,'2023-03-29 18:29:35','2023-03-29 18:41:12','2023-03-29 18:41:12'),(792,7730,40720,1529,3,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',261.88,NULL,NULL,1,'2023-03-29 18:41:12','2023-03-29 18:41:12',NULL),(793,7730,40720,1529,21,NULL,NULL,NULL,588,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1206.09,NULL,NULL,1,'2023-03-29 18:42:54','2023-03-29 18:42:54',NULL),(794,7730,40720,1529,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1801.50,'BANCO 2021-05',NULL,1,'2023-03-29 18:51:24','2023-03-29 18:51:24',NULL),(795,7730,40720,1529,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',117880.81,'Liquidaciòn IVA 2021-05',NULL,1,'2023-03-29 19:02:34','2023-03-29 19:02:34',NULL),(796,7730,40720,1529,16,NULL,636,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4629.63,NULL,NULL,1,'2023-03-29 19:04:52','2023-03-29 19:05:32','2023-03-29 19:05:32'),(797,7730,40720,1529,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',11892.76,'Liquidación IIBB 2021-05',NULL,1,'2023-03-29 19:09:18','2023-03-29 19:09:18',NULL),(798,7730,40720,1530,3,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1528.76,NULL,NULL,1,'2023-03-29 19:28:12','2023-03-29 20:01:23','2023-03-29 20:01:23'),(799,7730,40720,1530,3,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1528.76,NULL,NULL,1,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(800,7730,40720,1530,3,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1528.76,NULL,NULL,1,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(801,7730,40720,1530,21,NULL,NULL,NULL,592,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',261.88,NULL,NULL,1,'2023-03-29 20:05:20','2023-03-29 20:05:20',NULL);
INSERT INTO `balance_libro` VALUES (802,7730,40720,1530,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2634.42,'BANCO 2021-06',NULL,1,'2023-03-29 20:07:09','2023-03-29 20:07:09',NULL),(803,7730,40720,1530,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',118150.64,'Liquidaciòn IVA 2021-06',NULL,1,'2023-03-29 20:10:49','2023-03-29 20:10:49',NULL),(804,7730,40720,1530,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',11892.76,'Liquidación IIBB 2021-06',NULL,1,'2023-03-29 20:12:13','2023-03-29 20:12:13',NULL),(805,7730,40720,1531,3,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',366.63,NULL,NULL,1,'2023-03-29 20:18:01','2023-03-29 20:19:14','2023-03-29 20:19:14'),(806,7730,40720,1531,3,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',366.63,NULL,NULL,1,'2023-03-29 20:19:14','2023-03-29 20:19:39','2023-03-29 20:19:39'),(807,7730,40720,1531,3,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',366.63,NULL,NULL,1,'2023-03-29 20:19:39','2023-03-29 20:19:39',NULL),(808,7730,40720,1531,21,NULL,NULL,NULL,596,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1528.76,NULL,NULL,1,'2023-03-29 20:20:24','2023-03-29 20:20:24',NULL),(809,7730,40720,1531,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2634.42,'BANCO 2021-07',NULL,1,'2023-03-29 20:31:41','2023-03-29 20:31:41',NULL),(810,7730,40720,1531,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',118225.48,'Liquidaciòn IVA 2021-07',NULL,1,'2023-03-29 20:33:55','2023-07-12 18:28:53','2023-07-12 18:28:53'),(811,7730,40720,1531,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11892.76,'Liquidación IIBB 2021-07',NULL,1,'2023-03-29 20:35:05','2023-03-29 20:35:05',NULL),(812,7730,40720,1532,21,NULL,NULL,NULL,597,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',366.63,NULL,NULL,1,'2023-03-29 20:37:23','2023-03-29 20:37:23',NULL),(813,7730,40720,1532,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2583.36,'BANCO 2021-08',NULL,1,'2023-03-29 20:39:21','2023-03-29 20:39:21',NULL),(814,7730,40720,1528,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1080.71,'PAGO IVA DJ 2020-11; INT RESARCITORIOS',NULL,1,'2023-03-29 21:19:10','2023-03-29 21:19:10',NULL),(815,7730,40720,1528,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',2063.93,'PAGO IVA DJ 2020-11',NULL,1,'2023-03-29 21:32:40','2023-03-29 21:32:40',NULL),(816,7730,40720,1532,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',118225.48,'Liquidaciòn IVA 2021-08',NULL,1,'2023-03-29 21:40:20','2023-03-29 21:40:20',NULL),(817,7730,40720,1532,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',11892.76,'Liquidación IIBB 2021-08',NULL,1,'2023-03-29 21:41:37','2023-03-29 21:41:37',NULL),(818,7730,40720,1533,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2538.36,'BANCO 2021-09',NULL,1,'2023-03-29 22:33:02','2023-03-29 23:04:41','2023-03-29 23:04:41'),(819,7730,40720,1533,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',115665.42,'Liquidaciòn IVA 2021-09',NULL,1,'2023-03-29 22:43:09','2023-03-29 22:43:09',NULL),(820,7730,40720,1533,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',11892.76,'Liquidación IIBB 2021-09',NULL,1,'2023-03-29 22:44:23','2023-03-29 22:44:23',NULL),(821,7730,40720,1534,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2593.58,'BANCO 2021-10',NULL,1,'2023-03-29 22:46:10','2023-03-29 22:46:10',NULL),(822,7730,40720,1534,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',115665.42,'Liquidaciòn IVA 2021-10',NULL,1,'2023-03-29 22:48:59','2023-03-29 22:48:59',NULL),(823,7730,40720,1534,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',11892.76,'Liquidación IIBB 2021-10',NULL,1,'2023-03-29 22:50:01','2023-03-29 22:50:01',NULL);
INSERT INTO `balance_libro` VALUES (824,7730,40720,1535,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2593.58,'BANCO 2021-11',NULL,1,'2023-03-29 22:51:24','2023-03-29 22:51:24',NULL),(825,7730,40720,1535,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',115665.42,'Liquidaciòn IVA 2021-11',NULL,1,'2023-03-29 22:53:01','2023-03-29 22:53:01',NULL),(826,7730,40720,1535,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',11892.76,'Liquidación IIBB 2021-11',NULL,1,'2023-03-29 22:53:50','2023-03-29 22:53:50',NULL),(827,7730,40720,1536,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2593.58,'BANCO 2021-12',NULL,1,'2023-03-29 22:55:04','2023-03-29 22:55:04',NULL),(828,7730,40720,1536,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',115665.42,'Liquidaciòn IVA 2021-12',NULL,1,'2023-03-29 22:56:10','2023-03-29 22:56:10',NULL),(829,7730,40720,1536,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',11892.76,'Liquidación IIBB 2021-12',NULL,1,'2023-03-29 22:57:10','2023-03-29 22:57:10',NULL),(830,7730,40720,1533,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2583.36,'BANCO 2021-09',NULL,1,'2023-03-29 23:04:41','2023-03-29 23:04:41',NULL),(831,7730,40720,1532,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',7279.12,'Transferencia entre cuentas propias',NULL,1,'2023-03-29 23:07:22','2023-03-29 23:10:40','2023-03-29 23:10:40'),(832,7730,40720,1532,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',7279.12,'Transferencia entre cuentas propias',NULL,1,'2023-03-29 23:10:40','2023-03-29 23:10:40',NULL),(833,7730,40720,1536,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',0.17,'Diferencia de centavos',NULL,1,'2023-03-29 23:19:13','2023-03-29 23:24:19','2023-03-29 23:24:19'),(834,7730,40720,1536,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',0.21,'Diferencia de centavos',NULL,1,'2023-03-29 23:24:19','2023-03-29 23:43:22','2023-03-29 23:43:22'),(835,7730,40720,1536,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',136990.95,'Amortizacion Maquinaria',NULL,1,'2023-03-29 23:29:08','2023-03-29 23:29:08',NULL),(836,7730,40720,1536,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3300.00,'Amortizacion Gs. de Organización',NULL,1,'2023-03-29 23:30:20','2023-03-29 23:30:20',NULL),(837,7730,40720,1536,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',0.21,'Diferencia de centavos',NULL,1,'2023-03-29 23:43:22','2023-03-29 23:43:22',NULL),(838,7730,40720,1536,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',224630.22,'Costo de Mercaderias Vendidas',NULL,1,'2023-03-30 11:51:31','2023-07-13 17:54:21','2023-07-13 17:54:21'),(839,7730,40720,1525,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1600000.00,'Préstamo PF',NULL,1,'2023-03-30 12:36:06','2023-03-30 12:36:06',NULL),(840,7730,40720,1529,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',99.99,'Retenciones IIGG 2020',NULL,1,'2023-04-11 22:49:14','2023-04-12 00:09:39','2023-04-12 00:09:39'),(841,7730,40720,1529,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',99.99,'Liquidación IIGG 2020',NULL,1,'2023-04-11 22:51:14','2023-04-12 00:10:07','2023-04-12 00:10:07'),(842,7730,40720,1536,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',38385.28,'Provisión IIGG 2021',NULL,1,'2023-04-11 22:53:44','2023-07-13 18:00:24','2023-07-13 18:00:24'),(843,7730,40720,1529,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',99.99,'Liquidación IIGG 2020',NULL,1,'2023-04-12 00:10:07','2023-07-11 18:16:53','2023-07-11 18:16:53'),(844,7730,40720,1529,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',99.99,'Liquidación IIGG 2021',NULL,1,'2023-07-11 18:16:53','2023-07-11 18:17:32','2023-07-11 18:17:32');
INSERT INTO `balance_libro` VALUES (845,7730,40720,1529,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',99.99,'Liquidación IIGG 2020',NULL,1,'2023-07-11 18:17:32','2023-07-11 18:17:32',NULL),(846,7730,40720,1531,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',118225.48,'Liquidaciòn IVA 2021-07',NULL,1,'2023-07-12 18:28:53','2023-07-12 18:29:41','2023-07-12 18:29:41'),(847,7730,40720,1531,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',118225.48,'Liquidaciòn IVA 2021-07',NULL,1,'2023-07-12 18:29:41','2023-07-12 18:29:41',NULL),(848,7730,40720,1536,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',239786.99,'Costo de Mercaderias Vendidas',NULL,1,'2023-07-13 17:54:21','2023-07-13 17:54:21',NULL),(849,7730,40720,1536,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',34596.09,'Provisión IIGG 2021',NULL,1,'2023-07-13 18:19:43','2023-07-13 18:19:43',NULL),(850,7730,40720,1536,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',0.11,NULL,NULL,1,'2023-07-17 16:17:30','2023-07-17 16:17:30',NULL),(851,7730,40720,1536,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1111792.99,NULL,NULL,1,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(852,7730,40720,1536,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1099743.85,'Refundición de resultados',NULL,1,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(853,7730,40720,1536,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3049571.00,'Cierre de cuentas patrimoniales',NULL,1,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(854,7730,40720,1540,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',690972.97,'Asiento de apertura',NULL,1,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(859,7730,40720,1540,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',690972.97,'Asiento de apertura',NULL,1,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(861,7730,40720,1540,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',2817644.09,'Asiento de apertura',NULL,1,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(862,7730,40720,1540,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2850.00,'BANCO 2022-01',NULL,1,'2023-08-03 11:12:38','2023-08-03 11:23:52','2023-08-03 11:23:52'),(863,7730,40720,1540,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3555.71,'BANCO 2022-01',NULL,1,'2023-08-03 11:23:52','2023-08-03 11:25:48','2023-08-03 11:25:48'),(864,7730,40720,1540,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3641.21,'BANCO 2022-01',NULL,1,'2023-08-03 11:25:48','2023-08-03 11:25:48',NULL),(865,7730,40720,1540,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',116349.42,'Liquidaciòn IVA 2022-01',NULL,1,'2023-08-03 11:33:40','2023-08-03 11:33:40',NULL),(866,7730,40720,1540,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',11978.26,'Liquidación IIBB 2022-01',NULL,1,'2023-08-03 11:37:36','2023-08-03 11:37:36',NULL),(867,7730,40720,1541,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3619.50,'BANCO 2022-02',NULL,1,'2023-08-03 13:44:54','2023-08-03 13:58:10','2023-08-03 13:58:10'),(868,7730,40720,1541,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',117033.42,'Liquidaciòn IVA 2022-02',NULL,1,'2023-08-03 13:47:53','2023-08-03 13:58:52','2023-08-03 13:58:52'),(869,7730,40720,1541,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',12063.76,'Liquidación IIBB 2022-02',NULL,1,'2023-08-03 13:57:18','2023-08-03 13:57:18',NULL),(870,7730,40720,1541,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3641.21,'BANCO 2022-02',NULL,1,'2023-08-03 13:58:10','2023-08-03 13:58:10',NULL);
INSERT INTO `balance_libro` VALUES (871,7730,40720,1541,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',117033.42,'Liquidaciòn IVA 2022-02',NULL,1,'2023-08-03 13:58:52','2023-08-03 13:58:52',NULL),(872,7730,40720,1542,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3641.21,'BANCO 2022-03',NULL,1,'2023-08-03 14:10:13','2023-08-03 14:10:13',NULL),(873,7730,40720,1542,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',117717.42,'Liquidaciòn IVA 2022-03',NULL,1,'2023-08-03 14:20:35','2023-08-03 14:20:35',NULL),(874,7730,40720,1542,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',12149.26,'Liquidación IIBB 2022-03',NULL,1,'2023-08-03 14:24:36','2023-08-03 14:24:36',NULL),(875,7730,40720,1543,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3641.21,'BANCO 2022-04',NULL,1,'2023-08-03 14:27:45','2023-08-03 14:27:45',NULL),(876,7730,40720,1543,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',7056.75,NULL,NULL,1,'2023-08-03 16:30:53','2023-08-04 00:10:39','2023-08-04 00:10:39'),(877,7730,40720,1543,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',118401.42,'Liquidaciòn IVA 2022-04',NULL,1,'2023-08-03 17:34:46','2023-08-03 17:34:46',NULL),(878,7730,40720,1543,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',12234.76,'Liquidación IIBB 2022-04',NULL,1,'2023-08-03 17:38:05','2023-08-03 17:38:05',NULL),(879,7730,40720,1544,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3641.21,'BANCO 2022-05',NULL,1,'2023-08-03 17:40:40','2023-08-03 17:40:40',NULL),(880,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',217.85,'PAGO DJ IIBB 2020-09',NULL,1,'2023-08-03 17:44:43','2023-08-03 17:44:43',NULL),(881,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',240.75,'PAGO DJ IIBB 2020-10',NULL,1,'2023-08-03 17:49:23','2023-08-03 17:52:44','2023-08-03 17:52:44'),(882,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',240.75,'PAGO DJ IIBB 2020-10',NULL,1,'2023-08-03 17:52:44','2023-08-03 17:52:44',NULL),(883,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',591.46,'PAGO DJ IIBB 2020-11',NULL,1,'2023-08-03 18:16:32','2023-08-03 18:16:32',NULL),(884,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',6419.32,'PAGO DJ IIBB 2020-12',NULL,1,'2023-08-03 18:47:20','2023-08-03 19:02:04','2023-08-03 19:02:04'),(885,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',6489.48,'PAGO DJ IIBB 2021-01',NULL,1,'2023-08-03 18:58:15','2023-08-03 18:58:15',NULL),(886,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',4839.77,'PAGO DJ IIBB 2021-02',NULL,1,'2023-08-03 19:01:13','2023-08-03 19:01:13',NULL),(887,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',6419.32,'PAGO DJ IIBB 2020-12',NULL,1,'2023-08-03 19:02:04','2023-08-03 19:02:04',NULL),(888,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',34.09,'Liquidación IIBB 2021-03',NULL,1,'2023-08-03 19:07:14','2023-08-03 19:23:12','2023-08-03 19:23:12'),(889,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',25154.24,'PAGOS DJ IIBB, AUTONOMOS',NULL,1,'2023-08-03 19:22:50','2023-08-03 19:24:24','2023-08-03 19:24:24'),(890,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',34.09,'PAGO IIBB 2021-03',NULL,1,'2023-08-03 19:23:12','2023-08-04 04:59:02','2023-08-04 04:59:02'),(891,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',25154.24,'PAGOS DJ IIBB, AUTONOMOS',NULL,1,'2023-08-03 19:24:24','2023-08-04 00:01:46','2023-08-04 00:01:46');
INSERT INTO `balance_libro` VALUES (892,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',6321.52,'BANCO',NULL,1,'2023-08-04 00:06:01','2023-08-04 00:06:01',NULL),(893,7730,40720,1543,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',7056.75,NULL,NULL,1,'2023-08-04 00:10:39','2023-08-04 01:38:40','2023-08-04 01:38:40'),(894,7730,40720,1544,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',119085.42,'Liquidación IVA 2022-05',NULL,1,'2023-08-04 00:19:43','2023-08-04 00:19:43',NULL),(895,7730,40720,1544,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',12320.26,'Liquidación IIBB 2022-05',NULL,1,'2023-08-04 00:23:16','2023-08-04 00:23:16',NULL),(896,7730,40720,1545,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',5861.26,'gasto de socio Balbuena',NULL,1,'2023-08-04 00:26:52','2023-08-04 01:35:02','2023-08-04 01:35:02'),(897,7730,40720,1545,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3641.21,'BANCO 2022-06',NULL,1,'2023-08-04 00:29:26','2023-08-04 01:28:04','2023-08-04 01:28:04'),(898,7730,40720,1543,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',11596.35,'Constitución de Reserva Legal',NULL,1,'2023-08-04 00:33:56','2023-08-04 11:02:00','2023-08-04 11:02:00'),(899,7730,40720,1545,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',119769.42,'Liquidaciòn IVA 2022-06',NULL,1,'2023-08-04 00:39:54','2023-08-04 00:39:54',NULL),(900,7730,40720,1545,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',12405.76,'Liquidación IIBB 2022-06',NULL,1,'2023-08-04 00:48:10','2023-08-04 05:21:06','2023-08-04 05:21:06'),(901,7730,40720,1543,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',34596.09,'Liquidación IIGG 2021',NULL,1,'2023-08-04 01:17:27','2023-08-04 01:22:18','2023-08-04 01:22:18'),(902,7730,40720,1543,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',34596.09,'Liquidación IIGG 2021',NULL,1,'2023-08-04 01:22:18','2023-08-04 01:22:18',NULL),(903,7730,40720,1545,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',3641.21,'BANCO 2022-06',NULL,1,'2023-08-04 01:28:04','2023-08-04 05:19:53','2023-08-04 05:19:53'),(904,7730,40720,1546,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4199.55,'BANCO 2022-07',NULL,1,'2023-08-04 01:31:18','2023-08-04 01:31:18',NULL),(905,7730,40720,1546,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6780.88,'pago socio',NULL,1,'2023-08-04 01:34:15','2023-08-04 01:35:16','2023-08-04 01:35:16'),(906,7730,40720,1545,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',5861.26,'retiro socio: Balbuena',NULL,1,'2023-08-04 01:35:02','2023-08-04 05:23:32','2023-08-04 05:23:32'),(907,7730,40720,1546,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6780.88,'retiro socio: Balbuena',NULL,1,'2023-08-04 01:35:16','2023-08-04 01:35:16',NULL),(908,7730,40720,1543,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',7056.75,NULL,NULL,1,'2023-08-04 01:38:40','2023-08-04 01:38:40',NULL),(909,7730,40720,1544,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',34.09,'PAGO DJ IIBB 2021-03',NULL,1,'2023-08-04 04:59:02','2023-08-04 04:59:02',NULL),(910,7730,40720,1546,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',120561.42,'Liquidaciòn IVA 2022-07',NULL,1,'2023-08-04 05:12:07','2023-08-04 05:12:07',NULL),(911,7730,40720,1546,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',11975.26,'Liquidación IIBB 2022-07',NULL,1,'2023-08-04 05:14:49','2023-08-04 05:28:12','2023-08-04 05:28:12'),(912,7730,40720,1545,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',3555.20,'BANCO 2022-06',NULL,1,'2023-08-04 05:19:53','2023-08-04 05:19:53',NULL);
INSERT INTO `balance_libro` VALUES (913,7730,40720,1545,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',12320.26,'Liquidación IIBB 2022-06',NULL,1,'2023-08-04 05:21:06','2023-08-04 06:52:56','2023-08-04 06:52:56'),(914,7730,40720,1545,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',5896.43,'retiro socio: Balbuena',NULL,1,'2023-08-04 05:23:32','2023-08-04 05:23:32',NULL),(915,7730,40720,1546,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',12402.76,'Liquidación IIBB 2022-07',NULL,1,'2023-08-04 05:28:12','2023-08-04 05:28:12',NULL),(916,7730,40720,1547,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',4199.55,'BANCO 2022-08',NULL,1,'2023-08-04 05:31:11','2023-08-04 05:31:11',NULL),(917,7730,40720,1547,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',121353.42,'Liquidaciòn IVA 2022-08',NULL,1,'2023-08-04 05:33:43','2023-08-04 05:33:43',NULL),(918,7730,40720,1547,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',12485.26,'Liquidación IIBB 2022-08',NULL,1,'2023-08-04 05:36:24','2023-08-04 05:36:24',NULL),(919,7730,40720,1548,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',15667.77,'retiro socio: Balbuena',NULL,1,'2023-08-04 05:40:26','2023-08-04 05:40:26',NULL),(920,7730,40720,1548,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',4282.54,'BANCO 2022-09',NULL,1,'2023-08-04 05:42:19','2023-08-04 05:42:19',NULL),(921,7730,40720,1548,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',122145.42,'Liquidaciòn IVA 2022-09',NULL,1,'2023-08-04 05:45:48','2023-08-04 05:48:36','2023-08-04 05:48:36'),(922,7730,40720,1548,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',122145.42,'Liquidaciòn IVA 2022-09',NULL,1,'2023-08-04 05:48:36','2023-08-04 05:48:36',NULL),(923,7730,40720,1548,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',12650.26,'Liquidación IIBB 2022-09',NULL,1,'2023-08-04 05:50:54','2023-08-04 05:50:54',NULL),(924,7730,40720,1549,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5353.18,'BANCO 2022-10',NULL,1,'2023-08-04 05:57:00','2023-08-04 05:57:00',NULL),(925,7730,40720,1549,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',123135.42,'Liquidaciòn IVA 2022-10',NULL,1,'2023-08-04 06:00:02','2023-08-04 06:00:02',NULL),(926,7730,40720,1549,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',123135.42,'Liquidaciòn IVA 2022-10',NULL,1,'2023-08-04 06:00:02','2023-08-04 06:00:40','2023-08-04 06:00:40'),(927,7730,40720,1549,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',12856.51,'Liquidación IIBB 2022-10',NULL,1,'2023-08-04 06:02:46','2023-08-04 06:02:46',NULL),(928,7730,40720,1550,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',15667.77,'retiro socio: Balbuena',NULL,1,'2023-08-04 06:07:50','2023-08-04 06:07:50',NULL),(929,7730,40720,1550,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5353.18,'BANCO 2022-11',NULL,1,'2023-08-04 06:09:49','2023-08-04 06:09:49',NULL),(930,7730,40720,1550,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',124125.42,'Liquidaciòn IVA 2022-11',NULL,1,'2023-08-04 06:14:47','2023-08-04 06:14:47',NULL),(931,7730,40720,1550,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13062.76,'Liquidación IIBB 2022-11',NULL,1,'2023-08-04 06:17:31','2023-08-04 06:17:31',NULL),(932,7730,40720,1551,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',15667.77,'retiro socio: Balbuena',NULL,1,'2023-08-04 06:24:28','2023-08-04 06:24:28',NULL),(933,7730,40720,1551,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',18115.08,'retiro socio: Balbuena',NULL,1,'2023-08-04 06:26:07','2023-08-04 06:26:07',NULL);
INSERT INTO `balance_libro` VALUES (934,7730,40720,1551,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',5353.18,'BANCO 2022-12',NULL,1,'2023-08-04 06:28:07','2023-08-04 06:28:07',NULL),(935,7730,40720,1551,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',125115.42,'Liquidaciòn IVA 2022-12',NULL,1,'2023-08-04 06:32:00','2023-08-04 06:32:00',NULL),(936,7730,40720,1551,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',13269.01,'Liquidación IIBB 2022-12',NULL,1,'2023-08-04 06:34:59','2023-08-04 06:34:59',NULL),(937,7730,40720,1545,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',12320.26,'Liquidación IIBB 2022-06',NULL,1,'2023-08-04 06:52:56','2023-08-04 06:52:56',NULL),(938,7730,40720,1551,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',136990.95,'Amortizacion Maquinaria',NULL,1,'2023-08-04 07:22:53','2023-08-04 14:28:36','2023-08-04 14:28:36'),(939,7730,40720,1551,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3300.00,'Amortizacion Gs. de Organización',NULL,1,'2023-08-04 07:23:47','2023-08-04 14:29:04','2023-08-04 14:29:04'),(940,7730,40720,1551,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3034706.63,'Ajuste por inflación contable',NULL,1,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(941,7730,40720,1551,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',206776.38,'Amortizacion Maquinaria',NULL,1,'2023-08-04 14:28:36','2023-08-04 14:28:36',NULL),(942,7730,40720,1551,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4981.07,'Amortizacion Gs. de Organización',NULL,1,'2023-08-04 14:29:04','2023-08-04 14:29:04',NULL),(943,7730,40720,1551,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2256980.48,'Ajuste por inflación contable',NULL,1,'2023-08-04 14:33:12','2023-08-04 14:44:03','2023-08-04 14:44:03'),(944,7730,40720,1551,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2415471.19,'Ajuste por inflación contable',NULL,1,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(945,7730,40720,1551,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2415471.19,'Ajuste por inflación contable',NULL,1,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(946,7730,40720,1551,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',111648.22,'Provisión IIGG 2022',NULL,1,'2023-08-04 15:19:25','2023-08-04 15:27:31','2023-08-04 15:27:31'),(947,7730,40720,1551,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',110690.92,'Provisión IIGG 2022',NULL,1,'2023-08-04 15:27:31','2023-08-06 23:06:58','2023-08-06 23:06:58'),(948,7730,40720,1551,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',136905.84,'Provisión IIGG 2022',NULL,1,'2023-08-06 23:06:58','2023-08-06 23:06:58',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3067 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7730,1,40720,1518,12,388,1,400000.00,NULL,'2022-08-27 18:48:41','2022-08-27 19:14:04','2022-08-27 19:14:04'),(2,7730,1,40720,1518,12,369,2,400000.00,NULL,'2022-08-27 18:48:41','2022-08-27 19:14:04','2022-08-27 19:14:04'),(3,7730,2,40720,1518,12,482,1,400000.00,NULL,'2022-08-27 19:14:04','2022-08-27 20:53:05','2022-08-27 20:53:05'),(4,7730,2,40720,1518,12,483,2,400000.00,NULL,'2022-08-27 19:14:04','2022-08-27 20:53:05','2022-08-27 20:53:05'),(5,7730,3,40720,1518,19,359,1,100000.00,NULL,'2022-08-27 20:28:27','2022-08-27 20:53:35','2022-08-27 20:53:35'),(6,7730,3,40720,1518,19,482,2,100000.00,NULL,'2022-08-27 20:28:27','2022-08-27 20:53:35','2022-08-27 20:53:35'),(7,7730,4,40720,1519,2,452,1,16500.00,NULL,'2022-08-27 20:50:32','2022-08-27 20:53:26','2022-08-27 20:53:26'),(8,7730,4,40720,1519,2,485,2,16500.00,NULL,'2022-08-27 20:50:32','2022-08-27 20:53:26','2022-08-27 20:53:26'),(9,7730,5,40720,1519,3,50,1,16500.00,NULL,'2022-08-27 20:52:21','2022-08-27 20:53:13','2022-08-27 20:53:13'),(10,7730,5,40720,1519,3,452,2,16500.00,NULL,'2022-08-27 20:52:21','2022-08-27 20:53:13','2022-08-27 20:53:13'),(11,7730,6,40720,1518,12,482,1,400000.00,NULL,'2022-08-27 20:53:05','2022-08-27 21:14:13','2022-08-27 21:14:13'),(12,7730,6,40720,1518,12,483,2,400000.00,NULL,'2022-08-27 20:53:05','2022-08-27 21:14:13','2022-08-27 21:14:13'),(13,7730,7,40720,1519,3,50,1,16500.00,NULL,'2022-08-27 20:53:13','2022-08-28 21:33:13','2022-08-28 21:33:13'),(14,7730,7,40720,1519,3,452,2,16500.00,NULL,'2022-08-27 20:53:13','2022-08-28 21:33:13','2022-08-28 21:33:13'),(15,7730,8,40720,1519,2,452,1,16500.00,NULL,'2022-08-27 20:53:26','2022-08-28 21:33:13','2022-08-28 21:33:13'),(16,7730,8,40720,1519,2,485,2,16500.00,NULL,'2022-08-27 20:53:26','2022-08-28 21:33:13','2022-08-28 21:33:13'),(17,7730,9,40720,1518,19,359,1,100000.00,NULL,'2022-08-27 20:53:35','2022-08-27 21:14:41','2022-08-27 21:14:41'),(18,7730,9,40720,1518,19,482,2,100000.00,NULL,'2022-08-27 20:53:35','2022-08-27 21:14:41','2022-08-27 21:14:41'),(19,7730,10,40720,1519,19,359,1,120000.00,NULL,'2022-08-27 20:56:05','2022-08-27 21:15:00','2022-08-27 21:15:00'),(20,7730,10,40720,1519,19,392,1,180000.00,NULL,'2022-08-27 20:56:05','2022-08-27 21:15:00','2022-08-27 21:15:00'),(21,7730,10,40720,1519,19,482,2,300000.00,NULL,'2022-08-27 20:56:05','2022-08-27 21:15:00','2022-08-27 21:15:00'),(22,7730,11,40720,1519,14,483,1,300000.00,NULL,'2022-08-27 21:03:08','2022-08-28 21:20:14','2022-08-28 21:20:14'),(23,7730,11,40720,1519,14,87,2,300000.00,NULL,'2022-08-27 21:03:08','2022-08-28 21:20:14','2022-08-28 21:20:14'),(24,7730,12,40720,1518,14,482,1,400000.00,NULL,'2022-08-27 21:14:13','2022-08-28 21:33:13','2022-08-28 21:33:13'),(25,7730,12,40720,1518,14,483,2,400000.00,NULL,'2022-08-27 21:14:13','2022-08-28 21:33:13','2022-08-28 21:33:13'),(26,7730,13,40720,1518,12,359,1,100000.00,NULL,'2022-08-27 21:14:41','2022-08-28 21:24:19','2022-08-28 21:24:19'),(27,7730,13,40720,1518,12,482,2,100000.00,NULL,'2022-08-27 21:14:41','2022-08-28 21:24:19','2022-08-28 21:24:19'),(28,7730,14,40720,1519,12,359,1,120000.00,NULL,'2022-08-27 21:15:00','2022-08-28 21:33:13','2022-08-28 21:33:13'),(29,7730,14,40720,1519,12,392,1,180000.00,NULL,'2022-08-27 21:15:00','2022-08-28 21:33:13','2022-08-28 21:33:13'),(30,7730,14,40720,1519,12,482,2,300000.00,NULL,'2022-08-27 21:15:00','2022-08-28 21:33:13','2022-08-28 21:33:13'),(31,7730,15,40720,1520,2,96,2,4357.02,NULL,'2022-08-28 13:01:48','2022-08-28 13:04:51','2022-08-28 13:04:51'),(32,7730,15,40720,1520,2,67,2,914.98,NULL,'2022-08-28 13:01:48','2022-08-28 13:04:51','2022-08-28 13:04:51'),(33,7730,15,40720,1520,2,13,1,5272.00,NULL,'2022-08-28 13:01:48','2022-08-28 13:04:51','2022-08-28 13:04:51'),(34,7730,16,40720,1520,2,96,2,4357.03,NULL,'2022-08-28 13:04:51','2022-08-28 13:05:09','2022-08-28 13:05:09'),(35,7730,16,40720,1520,2,67,2,914.98,NULL,'2022-08-28 13:04:51','2022-08-28 13:05:09','2022-08-28 13:05:09');
INSERT INTO `balance_libro_details` VALUES (36,7730,16,40720,1520,2,13,1,5272.01,NULL,'2022-08-28 13:04:51','2022-08-28 13:05:09','2022-08-28 13:05:09'),(37,7730,17,40720,1520,2,96,2,4357.02,NULL,'2022-08-28 13:05:09','2022-08-28 13:13:02','2022-08-28 13:13:02'),(38,7730,17,40720,1520,2,67,2,914.97,NULL,'2022-08-28 13:05:09','2022-08-28 13:13:02','2022-08-28 13:13:02'),(39,7730,17,40720,1520,2,13,1,5271.99,NULL,'2022-08-28 13:05:09','2022-08-28 13:13:02','2022-08-28 13:13:02'),(40,7730,18,40720,1520,2,96,2,4357.02,NULL,'2022-08-28 13:13:02','2022-08-28 18:21:56','2022-08-28 18:21:56'),(41,7730,18,40720,1520,2,67,2,914.97,NULL,'2022-08-28 13:13:02','2022-08-28 18:21:56','2022-08-28 18:21:56'),(42,7730,18,40720,1520,2,13,1,5271.99,NULL,'2022-08-28 13:13:02','2022-08-28 18:21:56','2022-08-28 18:21:56'),(43,7730,19,40720,1520,22,359,1,5271.99,NULL,'2022-08-28 13:23:52','2022-08-28 15:06:53','2022-08-28 15:06:53'),(44,7730,19,40720,1520,22,359,2,5271.99,NULL,'2022-08-28 13:23:52','2022-08-28 15:06:53','2022-08-28 15:06:53'),(45,7730,20,40720,1520,20,13,2,5271.99,NULL,'2022-08-28 15:04:15','2022-08-28 16:39:22','2022-08-28 16:39:22'),(46,7730,20,40720,1520,20,359,1,5271.99,NULL,'2022-08-28 15:04:15','2022-08-28 16:39:22','2022-08-28 16:39:22'),(47,7730,21,40720,1520,20,13,2,5272.00,NULL,'2022-08-28 16:43:18','2022-08-28 16:54:30','2022-08-28 16:54:30'),(48,7730,21,40720,1520,20,484,1,5272.00,NULL,'2022-08-28 16:43:18','2022-08-28 16:54:30','2022-08-28 16:54:30'),(49,7730,22,40720,1520,20,13,2,5271.99,NULL,'2022-08-28 16:55:29','2022-08-28 23:49:23','2022-08-28 23:49:23'),(50,7730,22,40720,1520,20,484,1,5271.99,NULL,'2022-08-28 16:55:29','2022-08-28 23:49:23','2022-08-28 23:49:23'),(51,7730,23,40720,1520,19,486,1,3599.35,NULL,'2022-08-28 17:15:31','2022-08-28 21:33:13','2022-08-28 21:33:13'),(52,7730,23,40720,1520,19,392,2,3599.35,NULL,'2022-08-28 17:15:31','2022-08-28 21:33:13','2022-08-28 21:33:13'),(53,7730,24,40720,1520,16,156,1,217.85,NULL,'2022-08-28 17:55:33','2022-08-28 18:21:07','2022-08-28 18:21:07'),(54,7730,24,40720,1520,16,326,2,217.85,NULL,'2022-08-28 17:55:33','2022-08-28 18:21:07','2022-08-28 18:21:07'),(55,7730,25,40720,1520,2,96,2,4357.02,NULL,'2022-08-28 18:21:56','2022-08-28 20:10:04','2022-08-28 20:10:04'),(56,7730,25,40720,1520,2,67,2,914.97,NULL,'2022-08-28 18:21:56','2022-08-28 20:10:04','2022-08-28 20:10:04'),(57,7730,25,40720,1520,2,13,1,5271.99,NULL,'2022-08-28 18:21:56','2022-08-28 20:10:04','2022-08-28 20:10:04'),(58,7730,26,40720,1520,15,67,1,914.97,NULL,'2022-08-28 18:28:21','2022-08-28 20:09:29','2022-08-28 20:09:29'),(59,7730,26,40720,1520,15,74,2,914.98,NULL,'2022-08-28 18:28:21','2022-08-28 20:09:29','2022-08-28 20:09:29'),(60,7730,26,40720,1520,15,136,1,0.01,NULL,'2022-08-28 18:28:21','2022-08-28 20:09:29','2022-08-28 20:09:29'),(61,7730,27,40720,1520,2,96,2,4357.02,NULL,'2022-08-28 20:41:57','2022-08-28 23:31:51','2022-08-28 23:31:51'),(62,7730,27,40720,1520,2,67,2,914.97,NULL,'2022-08-28 20:41:57','2022-08-28 23:31:51','2022-08-28 23:31:51'),(63,7730,27,40720,1520,2,13,1,5271.99,NULL,'2022-08-28 20:41:57','2022-08-28 23:31:51','2022-08-28 23:31:51'),(64,7730,28,40720,1520,2,13,1,5000.00,NULL,'2022-08-28 20:53:42','2022-08-28 20:55:00','2022-08-28 20:55:00'),(65,7730,28,40720,1520,2,67,1,1050.00,NULL,'2022-08-28 20:53:42','2022-08-28 20:55:00','2022-08-28 20:55:00'),(66,7730,28,40720,1520,2,96,2,6050.00,NULL,'2022-08-28 20:53:42','2022-08-28 20:55:00','2022-08-28 20:55:00'),(67,7730,29,40720,1519,14,483,1,400000.00,NULL,'2022-08-28 21:20:14','2022-08-28 21:33:39','2022-08-28 21:33:39'),(68,7730,29,40720,1519,14,87,2,400000.00,NULL,'2022-08-28 21:20:14','2022-08-28 21:33:39','2022-08-28 21:33:39'),(69,7730,30,40720,1518,12,359,1,100000.00,NULL,'2022-08-28 21:24:19','2022-08-28 21:33:59','2022-08-28 21:33:59'),(70,7730,30,40720,1518,12,482,2,100000.00,NULL,'2022-08-28 21:24:19','2022-08-28 21:33:59','2022-08-28 21:33:59'),(71,7730,31,40720,3134,14,482,1,400000.00,NULL,'2022-08-28 22:32:48','2022-08-28 22:32:48',NULL);
INSERT INTO `balance_libro_details` VALUES (72,7730,31,40720,3134,14,483,2,400000.00,NULL,'2022-08-28 22:32:48','2022-08-28 22:32:48',NULL),(73,7730,32,40720,3134,12,359,1,100000.00,NULL,'2022-08-28 22:33:58','2022-08-28 22:33:58',NULL),(74,7730,32,40720,3134,12,482,2,100000.00,NULL,'2022-08-28 22:33:58','2022-08-28 22:33:58',NULL),(75,7730,33,40720,1519,2,452,1,16500.00,NULL,'2022-08-28 22:36:42','2022-09-02 01:42:33','2022-09-02 01:42:33'),(76,7730,33,40720,1519,2,485,2,16500.00,NULL,'2022-08-28 22:36:42','2022-09-02 01:42:33','2022-09-02 01:42:33'),(77,7730,34,40720,1519,19,50,1,16500.00,NULL,'2022-08-28 22:40:08','2022-09-02 01:38:39','2022-09-02 01:38:39'),(78,7730,34,40720,1519,19,452,2,16500.00,NULL,'2022-08-28 22:40:08','2022-09-02 01:38:39','2022-09-02 01:38:39'),(79,7730,35,40720,1547,12,359,1,120000.00,NULL,'2022-08-28 22:44:48','2022-08-29 00:09:02','2022-08-29 00:09:02'),(80,7730,35,40720,1547,12,392,1,180000.00,NULL,'2022-08-28 22:44:48','2022-08-29 00:09:02','2022-08-29 00:09:02'),(81,7730,35,40720,1547,12,482,2,300000.00,NULL,'2022-08-28 22:44:48','2022-08-29 00:09:02','2022-08-29 00:09:02'),(82,7730,36,40720,1519,14,483,1,400000.00,NULL,'2022-08-28 22:46:45','2022-08-29 01:47:01','2022-08-29 01:47:01'),(83,7730,36,40720,1519,14,87,2,400000.00,NULL,'2022-08-28 22:46:45','2022-08-29 01:47:01','2022-08-29 01:47:01'),(84,7730,37,40720,1520,2,96,2,4357.02,NULL,'2022-08-28 23:35:04','2022-09-02 04:23:51','2022-09-02 04:23:51'),(85,7730,37,40720,1520,2,67,2,914.98,NULL,'2022-08-28 23:35:04','2022-09-02 04:23:51','2022-09-02 04:23:51'),(86,7730,37,40720,1520,2,13,1,5272.00,NULL,'2022-08-28 23:35:04','2022-09-02 04:23:51','2022-09-02 04:23:51'),(87,7730,38,40720,1520,20,13,2,5272.00,NULL,'2022-08-28 23:51:22','2022-08-29 00:15:32','2022-08-29 00:15:32'),(88,7730,38,40720,1520,20,484,1,5272.00,NULL,'2022-08-28 23:51:22','2022-08-29 00:15:32','2022-08-29 00:15:32'),(89,7730,39,40720,1520,19,486,1,3599.35,NULL,'2022-08-28 23:54:12','2022-09-01 02:06:54','2022-09-01 02:06:54'),(90,7730,39,40720,1520,19,392,2,3599.35,NULL,'2022-08-28 23:54:12','2022-09-01 02:06:54','2022-09-01 02:06:54'),(91,7730,40,40720,1520,15,67,1,914.97,NULL,'2022-08-28 23:56:37','2022-09-02 03:04:36','2022-09-02 03:04:36'),(92,7730,40,40720,1520,15,74,2,914.98,NULL,'2022-08-28 23:56:37','2022-09-02 03:04:36','2022-09-02 03:04:36'),(93,7730,40,40720,1520,15,136,1,0.01,NULL,'2022-08-28 23:56:37','2022-09-02 03:04:36','2022-09-02 03:04:36'),(94,7730,41,40720,1520,16,156,1,217.85,NULL,'2022-08-28 23:57:27','2022-09-02 03:04:45','2022-09-02 03:04:45'),(95,7730,41,40720,1520,16,326,2,217.85,NULL,'2022-08-28 23:57:27','2022-09-02 03:04:45','2022-09-02 03:04:45'),(96,7730,42,40720,1519,12,359,1,120000.00,NULL,'2022-08-29 00:09:02','2022-08-29 14:18:09','2022-08-29 14:18:09'),(97,7730,42,40720,1519,12,392,1,180000.00,NULL,'2022-08-29 00:09:02','2022-08-29 14:18:09','2022-08-29 14:18:09'),(98,7730,42,40720,1519,12,482,2,300000.00,NULL,'2022-08-29 00:09:02','2022-08-29 14:18:09','2022-08-29 14:18:09'),(99,7730,43,40720,1520,20,13,2,5272.00,NULL,'2022-08-29 00:16:35','2022-09-02 04:26:26','2022-09-02 04:26:26'),(100,7730,43,40720,1520,20,484,1,5272.00,NULL,'2022-08-29 00:16:35','2022-09-02 04:26:26','2022-09-02 04:26:26'),(101,7730,44,40720,1521,2,218,2,0.00,NULL,'2022-08-29 00:23:21','2022-08-29 00:27:06','2022-08-29 00:27:06'),(102,7730,44,40720,1521,2,218,2,4815.00,NULL,'2022-08-29 00:23:21','2022-08-29 00:27:06','2022-08-29 00:27:06'),(103,7730,44,40720,1521,2,13,1,4815.00,NULL,'2022-08-29 00:23:21','2022-08-29 00:27:06','2022-08-29 00:27:06'),(104,7730,45,40720,1521,2,96,2,3979.34,NULL,'2022-08-29 00:27:06','2022-09-02 04:24:05','2022-09-02 04:24:05'),(105,7730,45,40720,1521,2,67,2,835.66,NULL,'2022-08-29 00:27:06','2022-09-02 04:24:05','2022-09-02 04:24:05'),(106,7730,45,40720,1521,2,13,1,4815.00,NULL,'2022-08-29 00:27:06','2022-09-02 04:24:05','2022-09-02 04:24:05'),(107,7730,46,40720,1521,20,13,2,4815.00,NULL,'2022-08-29 00:39:42','2022-09-02 04:26:31','2022-09-02 04:26:31');
INSERT INTO `balance_libro_details` VALUES (108,7730,46,40720,1521,20,484,1,4815.00,NULL,'2022-08-29 00:39:42','2022-09-02 04:26:31','2022-09-02 04:26:31'),(109,7730,47,40720,1521,19,486,1,3267.75,NULL,'2022-08-29 00:42:19','2022-09-01 02:08:15','2022-09-01 02:08:15'),(110,7730,47,40720,1521,19,392,2,3267.75,NULL,'2022-08-29 00:42:19','2022-09-01 02:08:15','2022-09-01 02:08:15'),(111,7730,48,40720,1521,3,217,1,3267.75,NULL,'2022-08-29 00:44:09','2022-08-29 01:44:34','2022-08-29 01:44:34'),(112,7730,48,40720,1521,3,68,1,686.23,NULL,'2022-08-29 00:44:09','2022-08-29 01:44:34','2022-08-29 01:44:34'),(113,7730,48,40720,1521,3,57,2,3953.98,NULL,'2022-08-29 00:44:09','2022-08-29 01:44:34','2022-08-29 01:44:34'),(114,7730,49,40720,1521,3,217,1,650.00,NULL,'2022-08-29 00:44:09','2022-08-29 01:02:45','2022-08-29 01:02:45'),(115,7730,49,40720,1521,3,68,1,136.50,NULL,'2022-08-29 00:44:09','2022-08-29 01:02:45','2022-08-29 01:02:45'),(116,7730,49,40720,1521,3,57,2,786.50,NULL,'2022-08-29 00:44:09','2022-08-29 01:02:45','2022-08-29 01:02:45'),(117,7730,50,40720,1521,3,250,1,14400.00,NULL,'2022-08-29 00:44:09','2022-08-29 01:02:36','2022-08-29 01:02:36'),(118,7730,50,40720,1521,3,57,2,14400.00,NULL,'2022-08-29 00:44:09','2022-08-29 01:02:36','2022-08-29 01:02:36'),(119,7730,51,40720,1521,3,217,1,566.41,NULL,'2022-08-29 00:44:09','2022-08-29 00:56:54','2022-08-29 00:56:54'),(120,7730,51,40720,1521,3,68,1,118.95,NULL,'2022-08-29 00:44:09','2022-08-29 00:56:54','2022-08-29 00:56:54'),(121,7730,51,40720,1521,3,217,1,62.30,NULL,'2022-08-29 00:44:09','2022-08-29 00:56:54','2022-08-29 00:56:54'),(122,7730,51,40720,1521,3,57,2,747.66,NULL,'2022-08-29 00:44:09','2022-08-29 00:56:54','2022-08-29 00:56:54'),(123,7730,52,40720,1521,3,217,1,2471.25,NULL,'2022-08-29 00:44:09','2022-08-29 01:45:25','2022-08-29 01:45:25'),(124,7730,52,40720,1521,3,68,1,518.96,NULL,'2022-08-29 00:44:09','2022-08-29 01:45:25','2022-08-29 01:45:25'),(125,7730,52,40720,1521,3,57,2,2990.21,NULL,'2022-08-29 00:44:09','2022-08-29 01:45:25','2022-08-29 01:45:25'),(126,7730,53,40720,1521,3,217,1,790.00,NULL,'2022-08-29 00:44:09','2022-08-29 00:53:15','2022-08-29 00:53:15'),(127,7730,53,40720,1521,3,68,1,170.68,NULL,'2022-08-29 00:44:09','2022-08-29 00:53:15','2022-08-29 00:53:15'),(128,7730,53,40720,1521,3,217,1,28.73,NULL,'2022-08-29 00:44:09','2022-08-29 00:53:15','2022-08-29 00:53:15'),(129,7730,53,40720,1521,3,57,2,989.41,NULL,'2022-08-29 00:44:09','2022-08-29 00:53:15','2022-08-29 00:53:15'),(130,7730,54,40720,1521,3,217,1,989.41,NULL,'2022-08-29 00:53:15','2022-08-29 01:02:22','2022-08-29 01:02:22'),(131,7730,54,40720,1521,3,57,2,989.41,NULL,'2022-08-29 00:53:15','2022-08-29 01:02:22','2022-08-29 01:02:22'),(132,7730,55,40720,1521,3,217,1,566.41,NULL,'2022-08-29 00:56:54','2022-08-29 01:26:01','2022-08-29 01:26:01'),(133,7730,55,40720,1521,3,68,1,118.95,NULL,'2022-08-29 00:56:54','2022-08-29 01:26:01','2022-08-29 01:26:01'),(134,7730,55,40720,1521,3,225,1,45.31,NULL,'2022-08-29 00:56:54','2022-08-29 01:26:01','2022-08-29 01:26:01'),(135,7730,55,40720,1521,3,226,1,16.99,NULL,'2022-08-29 00:56:54','2022-08-29 01:26:01','2022-08-29 01:26:01'),(136,7730,55,40720,1521,3,57,2,747.66,NULL,'2022-08-29 00:56:54','2022-08-29 01:26:01','2022-08-29 01:26:01'),(137,7730,56,40720,1521,3,193,1,786.50,NULL,'2022-08-29 01:12:29','2022-08-29 01:20:08','2022-08-29 01:20:08'),(138,7730,56,40720,1521,3,57,2,786.50,NULL,'2022-08-29 01:12:29','2022-08-29 01:20:08','2022-08-29 01:20:08'),(139,7730,57,40720,1521,3,487,1,786.50,NULL,'2022-08-29 01:20:08','2022-09-02 02:51:17','2022-09-02 02:51:17'),(140,7730,57,40720,1521,3,57,2,786.50,NULL,'2022-08-29 01:20:08','2022-09-02 02:51:17','2022-09-02 02:51:17'),(141,7730,58,40720,1521,3,488,1,566.41,NULL,'2022-08-29 01:26:01','2022-08-29 02:09:54','2022-08-29 02:09:54'),(142,7730,58,40720,1521,3,68,1,118.95,NULL,'2022-08-29 01:26:01','2022-08-29 02:09:54','2022-08-29 02:09:54'),(143,7730,58,40720,1521,3,225,1,45.31,NULL,'2022-08-29 01:26:01','2022-08-29 02:09:54','2022-08-29 02:09:54');
INSERT INTO `balance_libro_details` VALUES (144,7730,58,40720,1521,3,226,1,16.99,NULL,'2022-08-29 01:26:01','2022-08-29 02:09:54','2022-08-29 02:09:54'),(145,7730,58,40720,1521,3,57,2,747.66,NULL,'2022-08-29 01:26:01','2022-08-29 02:09:54','2022-08-29 02:09:54'),(146,7730,59,40720,1521,3,489,1,989.41,NULL,'2022-08-29 01:31:55','2022-09-02 02:54:54','2022-09-02 02:54:54'),(147,7730,59,40720,1521,3,57,2,989.41,NULL,'2022-08-29 01:31:55','2022-09-02 02:54:54','2022-09-02 02:54:54'),(148,7730,60,40720,1521,3,192,1,14400.00,NULL,'2022-08-29 01:37:02','2022-09-02 02:30:33','2022-09-02 02:30:33'),(149,7730,60,40720,1521,3,57,2,14400.00,NULL,'2022-08-29 01:37:02','2022-09-02 02:30:33','2022-09-02 02:30:33'),(150,7730,61,40720,1521,3,392,1,3267.75,NULL,'2022-08-29 01:44:34','2022-08-29 01:44:34',NULL),(151,7730,61,40720,1521,3,68,1,686.23,NULL,'2022-08-29 01:44:34','2022-08-29 01:44:34',NULL),(152,7730,61,40720,1521,3,57,2,3953.98,NULL,'2022-08-29 01:44:34','2022-08-29 01:44:34',NULL),(153,7730,62,40720,1521,3,392,1,2471.25,NULL,'2022-08-29 01:45:25','2022-08-29 01:45:25',NULL),(154,7730,62,40720,1521,3,68,1,518.96,NULL,'2022-08-29 01:45:25','2022-08-29 01:45:25',NULL),(155,7730,62,40720,1521,3,57,2,2990.21,NULL,'2022-08-29 01:45:25','2022-08-29 01:45:25',NULL),(156,7730,63,40720,1521,21,57,1,14400.00,NULL,'2022-08-29 01:53:25','2022-09-02 02:50:01','2022-09-02 02:50:01'),(157,7730,63,40720,1521,21,359,2,14400.00,NULL,'2022-08-29 01:53:25','2022-09-02 02:50:01','2022-09-02 02:50:01'),(158,7730,64,40720,1521,21,57,1,786.50,NULL,'2022-08-29 01:55:39','2022-08-29 01:56:02','2022-08-29 01:56:02'),(159,7730,64,40720,1521,21,359,2,786.50,NULL,'2022-08-29 01:55:39','2022-08-29 01:56:02','2022-08-29 01:56:02'),(160,7730,65,40720,1521,21,57,1,786.50,NULL,'2022-08-29 01:56:57','2022-08-29 01:59:28','2022-08-29 01:59:28'),(161,7730,65,40720,1521,21,359,2,786.50,NULL,'2022-08-29 01:56:57','2022-08-29 01:59:28','2022-08-29 01:59:28'),(162,7730,66,40720,1521,21,57,1,747.66,NULL,'2022-08-29 01:59:15','2022-08-29 02:06:13','2022-08-29 02:06:13'),(163,7730,66,40720,1521,21,484,2,747.66,NULL,'2022-08-29 01:59:15','2022-08-29 02:06:13','2022-08-29 02:06:13'),(164,7730,67,40720,1521,21,57,1,786.50,NULL,'2022-08-29 02:01:13','2022-08-29 02:07:43','2022-08-29 02:07:43'),(165,7730,67,40720,1521,21,359,2,786.50,NULL,'2022-08-29 02:01:13','2022-08-29 02:07:43','2022-08-29 02:07:43'),(166,7730,68,40720,1521,3,488,1,685.36,NULL,'2022-08-29 02:09:54','2022-09-02 02:36:32','2022-09-02 02:36:32'),(167,7730,68,40720,1521,3,225,1,45.31,NULL,'2022-08-29 02:09:54','2022-09-02 02:36:32','2022-09-02 02:36:32'),(168,7730,68,40720,1521,3,226,1,16.99,NULL,'2022-08-29 02:09:54','2022-09-02 02:36:32','2022-09-02 02:36:32'),(169,7730,68,40720,1521,3,57,2,747.66,NULL,'2022-08-29 02:09:54','2022-09-02 02:36:32','2022-09-02 02:36:32'),(170,7730,69,40720,1521,21,57,1,747.66,NULL,'2022-08-29 02:12:05','2022-09-02 02:02:41','2022-09-02 02:02:41'),(171,7730,69,40720,1521,21,484,2,747.66,NULL,'2022-08-29 02:12:05','2022-09-02 02:02:41','2022-09-02 02:02:41'),(172,7730,70,40720,1521,21,57,1,786.50,NULL,'2022-08-29 02:13:35','2022-09-02 02:50:52','2022-09-02 02:50:52'),(173,7730,70,40720,1521,21,359,2,786.50,NULL,'2022-08-29 02:13:35','2022-09-02 02:50:52','2022-09-02 02:50:52'),(174,7730,71,40720,1521,21,57,1,989.41,NULL,'2022-08-29 02:14:47','2022-08-29 02:15:06','2022-08-29 02:15:06'),(175,7730,71,40720,1521,21,359,2,989.41,NULL,'2022-08-29 02:14:47','2022-08-29 02:15:06','2022-08-29 02:15:06'),(176,7730,72,40720,1521,21,57,1,989.41,NULL,'2022-08-29 02:16:34','2022-09-02 02:54:54','2022-09-02 02:54:54'),(177,7730,72,40720,1521,21,359,2,989.41,NULL,'2022-08-29 02:16:34','2022-09-02 02:54:54','2022-09-02 02:54:54'),(178,7730,73,40720,1521,22,484,1,100.00,NULL,'2022-08-29 02:19:50','2022-08-29 02:19:50',NULL),(179,7730,73,40720,1521,22,359,2,100.00,NULL,'2022-08-29 02:19:50','2022-08-29 02:19:50',NULL),(180,7730,74,40720,1519,12,359,1,120000.00,NULL,'2022-08-29 14:18:09','2022-11-20 03:15:45','2022-11-20 03:15:45');
INSERT INTO `balance_libro_details` VALUES (181,7730,74,40720,1519,12,392,1,180000.00,NULL,'2022-08-29 14:18:09','2022-11-20 03:15:45','2022-11-20 03:15:45'),(182,7730,74,40720,1519,12,482,2,300000.00,NULL,'2022-08-29 14:18:09','2022-11-20 03:15:45','2022-11-20 03:15:45'),(183,7730,75,40720,1518,14,483,1,400000.00,NULL,'2022-08-29 14:20:52','2022-08-29 14:20:52',NULL),(184,7730,75,40720,1518,14,87,2,400000.00,NULL,'2022-08-29 14:20:52','2022-08-29 14:20:52',NULL),(185,7730,76,40720,1519,3,485,1,16500.00,NULL,'2022-08-29 14:28:56','2022-09-02 01:46:41','2022-09-02 01:46:41'),(186,7730,76,40720,1519,3,359,2,16500.00,NULL,'2022-08-29 14:28:56','2022-09-02 01:46:41','2022-09-02 01:46:41'),(187,7730,77,40720,1520,19,486,1,2178.51,NULL,'2022-09-01 02:06:54','2022-09-01 02:26:51','2022-09-01 02:26:51'),(188,7730,77,40720,1520,19,392,2,2178.51,NULL,'2022-09-01 02:06:54','2022-09-01 02:26:51','2022-09-01 02:26:51'),(189,7730,78,40720,1521,19,486,1,1989.67,NULL,'2022-09-01 02:08:15','2022-09-01 02:27:16','2022-09-01 02:27:16'),(190,7730,78,40720,1521,19,392,2,1989.67,NULL,'2022-09-01 02:08:15','2022-09-01 02:27:16','2022-09-01 02:27:16'),(191,7730,79,40720,1520,19,486,1,2614.21,NULL,'2022-09-01 02:26:51','2022-11-20 03:59:33','2022-11-20 03:59:33'),(192,7730,79,40720,1520,19,392,2,2614.21,NULL,'2022-09-01 02:26:51','2022-11-20 03:59:33','2022-11-20 03:59:33'),(193,7730,80,40720,1521,19,486,1,2387.60,NULL,'2022-09-01 02:27:16','2022-09-01 02:27:16',NULL),(194,7730,80,40720,1521,19,392,2,2387.60,NULL,'2022-09-01 02:27:16','2022-09-01 02:27:16',NULL),(195,7730,81,40720,1521,15,67,1,835.66,NULL,'2022-09-01 03:32:40','2022-09-02 01:59:23','2022-09-02 01:59:23'),(196,7730,81,40720,1521,15,68,2,1205.19,NULL,'2022-09-01 03:32:40','2022-09-02 01:59:23','2022-09-02 01:59:23'),(197,7730,81,40720,1521,15,353,1,369.53,NULL,'2022-09-01 03:32:40','2022-09-02 01:59:23','2022-09-02 01:59:23'),(198,7730,82,40720,1521,16,226,2,16.99,NULL,'2022-09-01 04:55:42','2022-09-01 05:05:23','2022-09-01 05:05:23'),(199,7730,82,40720,1521,16,302,1,16.99,NULL,'2022-09-01 04:55:42','2022-09-01 05:05:23','2022-09-01 05:05:23'),(200,7730,82,40720,1521,16,156,1,198.97,NULL,'2022-09-01 04:55:42','2022-09-01 05:05:23','2022-09-01 05:05:23'),(201,7730,82,40720,1521,16,225,2,45.31,NULL,'2022-09-01 04:55:42','2022-09-01 05:05:23','2022-09-01 05:05:23'),(202,7730,82,40720,1521,16,326,2,153.66,NULL,'2022-09-01 04:55:42','2022-09-01 05:05:23','2022-09-01 05:05:23'),(203,7730,83,40720,1521,16,226,2,16.99,NULL,'2022-09-01 14:12:13','2022-09-02 01:55:37','2022-09-02 01:55:37'),(204,7730,83,40720,1521,16,302,1,16.99,NULL,'2022-09-01 14:12:13','2022-09-02 01:55:37','2022-09-02 01:55:37'),(205,7730,83,40720,1521,16,156,1,240.75,NULL,'2022-09-01 14:12:13','2022-09-02 01:55:37','2022-09-02 01:55:37'),(206,7730,83,40720,1521,16,225,2,45.31,NULL,'2022-09-01 14:12:13','2022-09-02 01:55:37','2022-09-02 01:55:37'),(207,7730,83,40720,1521,16,326,2,195.44,NULL,'2022-09-01 14:12:13','2022-09-02 01:55:37','2022-09-02 01:55:37'),(208,7730,84,40720,1522,2,218,2,0.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:33:01','2022-09-01 14:33:01'),(209,7730,84,40720,1522,2,218,2,5295.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:33:01','2022-09-01 14:33:01'),(210,7730,84,40720,1522,2,13,1,5295.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:33:01','2022-09-01 14:33:01'),(211,7730,85,40720,1522,2,96,2,9714.06,NULL,'2022-09-01 14:28:33','2022-09-01 14:43:32','2022-09-01 14:43:32'),(212,7730,85,40720,1522,2,67,2,2039.95,NULL,'2022-09-01 14:28:33','2022-09-01 14:43:32','2022-09-01 14:43:32'),(213,7730,85,40720,1522,2,13,1,11754.01,NULL,'2022-09-01 14:28:33','2022-09-01 14:43:32','2022-09-01 14:43:32'),(214,7730,86,40720,1522,2,218,2,150.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:33:35','2022-09-01 14:33:35'),(215,7730,86,40720,1522,2,13,1,150.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:33:35','2022-09-01 14:33:35'),(216,7730,87,40720,1522,2,218,2,150.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:34:12','2022-09-01 14:34:12');
INSERT INTO `balance_libro_details` VALUES (217,7730,87,40720,1522,2,13,1,150.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:34:12','2022-09-01 14:34:12'),(218,7730,88,40720,1522,2,218,2,219.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:38:43','2022-09-01 14:38:43'),(219,7730,88,40720,1522,2,13,1,219.00,NULL,'2022-09-01 14:28:33','2022-09-01 14:38:43','2022-09-01 14:38:43'),(220,7730,89,40720,1522,2,218,2,219.00,NULL,'2022-09-01 14:28:34','2022-09-01 14:40:17','2022-09-01 14:40:17'),(221,7730,89,40720,1522,2,13,1,219.00,NULL,'2022-09-01 14:28:34','2022-09-01 14:40:17','2022-09-01 14:40:17'),(222,7730,90,40720,1522,2,218,2,1959.00,NULL,'2022-09-01 14:28:34','2022-09-01 14:41:46','2022-09-01 14:41:46'),(223,7730,90,40720,1522,2,13,1,1959.00,NULL,'2022-09-01 14:28:34','2022-09-01 14:41:46','2022-09-01 14:41:46'),(224,7730,91,40720,1522,2,96,2,123.97,NULL,'2022-09-01 14:28:34','2022-09-01 14:42:46','2022-09-01 14:42:46'),(225,7730,91,40720,1522,2,67,2,26.03,NULL,'2022-09-01 14:28:34','2022-09-01 14:42:46','2022-09-01 14:42:46'),(226,7730,91,40720,1522,2,13,1,150.00,NULL,'2022-09-01 14:28:34','2022-09-01 14:42:46','2022-09-01 14:42:46'),(227,7730,92,40720,1522,2,96,2,4376.03,NULL,'2022-09-01 14:33:01','2022-09-02 04:28:12','2022-09-02 04:28:12'),(228,7730,92,40720,1522,2,67,2,918.97,NULL,'2022-09-01 14:33:01','2022-09-02 04:28:12','2022-09-02 04:28:12'),(229,7730,92,40720,1522,2,13,1,5295.00,NULL,'2022-09-01 14:33:01','2022-09-02 04:28:12','2022-09-02 04:28:12'),(230,7730,93,40720,1522,2,96,2,123.97,NULL,'2022-09-01 14:33:35','2022-09-01 14:37:19','2022-09-01 14:37:19'),(231,7730,93,40720,1522,2,67,2,26.03,NULL,'2022-09-01 14:33:35','2022-09-01 14:37:19','2022-09-01 14:37:19'),(232,7730,93,40720,1522,2,13,1,150.00,NULL,'2022-09-01 14:33:35','2022-09-01 14:37:19','2022-09-01 14:37:19'),(233,7730,94,40720,1522,2,96,2,123.97,NULL,'2022-09-01 14:34:12','2022-09-01 14:35:57','2022-09-01 14:35:57'),(234,7730,94,40720,1522,2,67,2,26.03,NULL,'2022-09-01 14:34:12','2022-09-01 14:35:57','2022-09-01 14:35:57'),(235,7730,94,40720,1522,2,13,1,150.00,NULL,'2022-09-01 14:34:12','2022-09-01 14:35:57','2022-09-01 14:35:57'),(236,7730,95,40720,1522,2,96,2,123.97,NULL,'2022-09-01 14:35:57','2022-09-02 04:29:26','2022-09-02 04:29:26'),(237,7730,95,40720,1522,2,67,2,26.03,NULL,'2022-09-01 14:35:57','2022-09-02 04:29:26','2022-09-02 04:29:26'),(238,7730,95,40720,1522,2,13,1,150.00,NULL,'2022-09-01 14:35:57','2022-09-02 04:29:26','2022-09-02 04:29:26'),(239,7730,96,40720,1522,2,96,2,123.97,NULL,'2022-09-01 14:37:19','2022-09-02 04:28:43','2022-09-02 04:28:43'),(240,7730,96,40720,1522,2,67,2,26.03,NULL,'2022-09-01 14:37:19','2022-09-02 04:28:43','2022-09-02 04:28:43'),(241,7730,96,40720,1522,2,13,1,150.00,NULL,'2022-09-01 14:37:19','2022-09-02 04:28:43','2022-09-02 04:28:43'),(242,7730,97,40720,1522,2,96,2,180.99,NULL,'2022-09-01 14:38:43','2022-09-02 04:29:38','2022-09-02 04:29:38'),(243,7730,97,40720,1522,2,67,2,38.01,NULL,'2022-09-01 14:38:43','2022-09-02 04:29:38','2022-09-02 04:29:38'),(244,7730,97,40720,1522,2,13,1,219.00,NULL,'2022-09-01 14:38:43','2022-09-02 04:29:38','2022-09-02 04:29:38'),(245,7730,98,40720,1522,2,96,2,180.99,NULL,'2022-09-01 14:40:17','2022-09-02 04:30:02','2022-09-02 04:30:02'),(246,7730,98,40720,1522,2,67,2,38.01,NULL,'2022-09-01 14:40:17','2022-09-02 04:30:02','2022-09-02 04:30:02'),(247,7730,98,40720,1522,2,13,1,219.00,NULL,'2022-09-01 14:40:17','2022-09-02 04:30:02','2022-09-02 04:30:02'),(248,7730,99,40720,1522,2,96,2,1619.01,NULL,'2022-09-01 14:41:46','2022-09-02 04:30:20','2022-09-02 04:30:20'),(249,7730,99,40720,1522,2,67,2,339.99,NULL,'2022-09-01 14:41:46','2022-09-02 04:30:20','2022-09-02 04:30:20'),(250,7730,99,40720,1522,2,13,1,1959.00,NULL,'2022-09-01 14:41:46','2022-09-02 04:30:20','2022-09-02 04:30:20'),(251,7730,100,40720,1522,2,96,2,123.97,NULL,'2022-09-01 14:42:46','2022-09-02 04:30:32','2022-09-02 04:30:32'),(252,7730,100,40720,1522,2,67,2,26.03,NULL,'2022-09-01 14:42:46','2022-09-02 04:30:32','2022-09-02 04:30:32');
INSERT INTO `balance_libro_details` VALUES (253,7730,100,40720,1522,2,13,1,150.00,NULL,'2022-09-01 14:42:46','2022-09-02 04:30:32','2022-09-02 04:30:32'),(254,7730,101,40720,1522,2,96,2,9714.06,NULL,'2022-09-01 14:43:32','2022-09-02 04:28:27','2022-09-02 04:28:27'),(255,7730,101,40720,1522,2,67,2,2039.95,NULL,'2022-09-01 14:43:32','2022-09-02 04:28:27','2022-09-02 04:28:27'),(256,7730,101,40720,1522,2,13,1,11754.01,NULL,'2022-09-01 14:43:32','2022-09-02 04:28:27','2022-09-02 04:28:27'),(257,7730,102,40720,1522,19,486,1,2625.62,NULL,'2022-09-01 15:23:37','2022-11-21 23:33:17','2022-11-21 23:33:17'),(258,7730,102,40720,1522,19,392,2,2625.62,NULL,'2022-09-01 15:23:37','2022-11-21 23:33:17','2022-11-21 23:33:17'),(259,7730,103,40720,1522,19,486,1,74.38,NULL,'2022-09-01 15:28:43','2022-11-21 23:32:19','2022-11-21 23:32:19'),(260,7730,103,40720,1522,19,392,2,74.38,NULL,'2022-09-01 15:28:43','2022-11-21 23:32:19','2022-11-21 23:32:19'),(261,7730,104,40720,1522,19,486,1,74.38,NULL,'2022-09-01 15:29:36','2022-11-21 23:32:19','2022-11-21 23:32:19'),(262,7730,104,40720,1522,19,392,2,74.38,NULL,'2022-09-01 15:29:36','2022-11-21 23:32:19','2022-11-21 23:32:19'),(263,7730,105,40720,1522,19,486,1,74.38,NULL,'2022-09-01 15:30:15','2022-11-21 23:32:19','2022-11-21 23:32:19'),(264,7730,105,40720,1522,19,392,2,74.38,NULL,'2022-09-01 15:30:15','2022-11-21 23:32:19','2022-11-21 23:32:19'),(265,7730,106,40720,1522,19,486,1,74.38,NULL,'2022-09-01 15:31:01','2022-11-21 23:32:19','2022-11-21 23:32:19'),(266,7730,106,40720,1522,19,392,2,74.38,NULL,'2022-09-01 15:31:01','2022-11-21 23:32:19','2022-11-21 23:32:19'),(267,7730,107,40720,1522,19,486,1,971.40,NULL,'2022-09-01 18:17:30','2022-11-21 23:32:19','2022-11-21 23:32:19'),(268,7730,107,40720,1522,19,392,2,971.40,NULL,'2022-09-01 18:17:30','2022-11-21 23:32:19','2022-11-21 23:32:19'),(269,7730,108,40720,1522,19,486,1,5828.43,NULL,'2022-09-01 18:21:33','2022-11-21 23:31:14','2022-11-21 23:31:14'),(270,7730,108,40720,1522,19,392,2,5828.43,NULL,'2022-09-01 18:21:33','2022-11-21 23:31:14','2022-11-21 23:31:14'),(271,7730,109,40720,1522,19,486,1,74.38,NULL,'2022-09-01 18:23:22','2022-11-21 23:31:36','2022-11-21 23:31:36'),(272,7730,109,40720,1522,19,392,2,74.38,NULL,'2022-09-01 18:23:22','2022-11-21 23:31:36','2022-11-21 23:31:36'),(273,7730,110,40720,1522,20,13,2,5295.00,NULL,'2022-09-01 18:27:19','2022-09-01 18:29:15','2022-09-01 18:29:15'),(274,7730,110,40720,1522,20,484,1,5295.00,NULL,'2022-09-01 18:27:19','2022-09-01 18:29:15','2022-09-01 18:29:15'),(275,7730,111,40720,1522,20,13,2,219.00,NULL,'2022-09-01 18:29:03','2022-09-01 18:32:07','2022-09-01 18:32:07'),(276,7730,111,40720,1522,20,484,1,219.00,NULL,'2022-09-01 18:29:03','2022-09-01 18:32:07','2022-09-01 18:32:07'),(277,7730,112,40720,1522,20,13,2,5295.00,NULL,'2022-09-01 18:31:32','2022-09-01 18:51:47','2022-09-01 18:51:47'),(278,7730,112,40720,1522,20,484,1,5295.00,NULL,'2022-09-01 18:31:32','2022-09-01 18:51:47','2022-09-01 18:51:47'),(279,7730,113,40720,1522,20,13,2,150.00,NULL,'2022-09-01 18:50:21','2022-09-01 18:50:39','2022-09-01 18:50:39'),(280,7730,113,40720,1522,20,484,1,150.00,NULL,'2022-09-01 18:50:21','2022-09-01 18:50:39','2022-09-01 18:50:39'),(281,7730,114,40720,1522,20,13,2,5295.00,NULL,'2022-09-01 18:56:40','2022-09-02 04:26:39','2022-09-02 04:26:39'),(282,7730,114,40720,1522,20,484,1,5295.00,NULL,'2022-09-01 18:56:40','2022-09-02 04:26:39','2022-09-02 04:26:39'),(283,7730,115,40720,1522,20,13,2,150.00,NULL,'2022-09-01 19:00:43','2022-09-01 19:27:11','2022-09-01 19:27:11'),(284,7730,115,40720,1522,20,484,1,150.00,NULL,'2022-09-01 19:00:43','2022-09-01 19:27:11','2022-09-01 19:27:11'),(285,7730,116,40720,1522,20,13,2,219.00,NULL,'2022-09-01 19:28:36','2022-09-02 04:26:35','2022-09-02 04:26:35'),(286,7730,116,40720,1522,20,484,1,219.00,NULL,'2022-09-01 19:28:36','2022-09-02 04:26:35','2022-09-02 04:26:35'),(287,7730,117,40720,1522,20,13,2,150.00,NULL,'2022-09-01 19:30:20','2022-09-02 04:26:43','2022-09-02 04:26:43');
INSERT INTO `balance_libro_details` VALUES (288,7730,117,40720,1522,20,484,1,150.00,NULL,'2022-09-01 19:30:20','2022-09-02 04:26:43','2022-09-02 04:26:43'),(289,7730,118,40720,1522,20,13,2,150.00,NULL,'2022-09-01 19:32:09','2022-09-01 19:32:44','2022-09-01 19:32:44'),(290,7730,118,40720,1522,20,484,1,150.00,NULL,'2022-09-01 19:32:09','2022-09-01 19:32:44','2022-09-01 19:32:44'),(291,7730,119,40720,1522,20,13,2,150.00,NULL,'2022-09-01 19:34:00','2022-09-02 04:26:47','2022-09-02 04:26:47'),(292,7730,119,40720,1522,20,484,1,150.00,NULL,'2022-09-01 19:34:00','2022-09-02 04:26:47','2022-09-02 04:26:47'),(293,7730,120,40720,1522,20,13,2,219.00,NULL,'2022-09-01 19:35:26','2022-09-02 04:26:50','2022-09-02 04:26:50'),(294,7730,120,40720,1522,20,484,1,219.00,NULL,'2022-09-01 19:35:26','2022-09-02 04:26:50','2022-09-02 04:26:50'),(295,7730,121,40720,1522,20,13,2,1959.00,NULL,'2022-09-01 19:36:21','2022-09-01 19:36:31','2022-09-01 19:36:31'),(296,7730,121,40720,1522,20,484,1,1959.00,NULL,'2022-09-01 19:36:21','2022-09-01 19:36:31','2022-09-01 19:36:31'),(297,7730,122,40720,1522,20,13,2,1959.00,NULL,'2022-09-01 19:37:39','2022-09-02 04:26:54','2022-09-02 04:26:54'),(298,7730,122,40720,1522,20,484,1,1959.00,NULL,'2022-09-01 19:37:39','2022-09-02 04:26:54','2022-09-02 04:26:54'),(299,7730,123,40720,1522,20,13,2,11754.01,NULL,'2022-09-01 19:38:51','2022-09-02 04:26:58','2022-09-02 04:26:58'),(300,7730,123,40720,1522,20,484,1,11754.01,NULL,'2022-09-01 19:38:51','2022-09-02 04:26:58','2022-09-02 04:26:58'),(301,7730,124,40720,1522,20,13,2,150.00,NULL,'2022-09-01 19:39:57','2022-09-02 04:27:02','2022-09-02 04:27:02'),(302,7730,124,40720,1522,20,484,1,150.00,NULL,'2022-09-01 19:39:57','2022-09-02 04:27:02','2022-09-02 04:27:02'),(303,7730,125,40720,1522,3,217,1,1086.20,NULL,'2022-09-02 00:53:11','2022-09-02 00:56:28','2022-09-02 00:56:28'),(304,7730,125,40720,1522,3,68,1,228.10,NULL,'2022-09-02 00:53:11','2022-09-02 00:56:28','2022-09-02 00:56:28'),(305,7730,125,40720,1522,3,217,1,32.59,NULL,'2022-09-02 00:53:11','2022-09-02 00:56:28','2022-09-02 00:56:28'),(306,7730,125,40720,1522,3,57,2,1346.89,NULL,'2022-09-02 00:53:11','2022-09-02 00:56:28','2022-09-02 00:56:28'),(307,7730,126,40720,1522,3,488,1,1086.20,NULL,'2022-09-02 00:56:28','2022-09-02 00:57:48','2022-09-02 00:57:48'),(308,7730,126,40720,1522,3,68,1,228.10,NULL,'2022-09-02 00:56:28','2022-09-02 00:57:48','2022-09-02 00:57:48'),(309,7730,126,40720,1522,3,488,1,32.59,NULL,'2022-09-02 00:56:28','2022-09-02 00:57:48','2022-09-02 00:57:48'),(310,7730,126,40720,1522,3,226,1,0.03,NULL,'2022-09-02 00:56:28','2022-09-02 00:57:48','2022-09-02 00:57:48'),(311,7730,126,40720,1522,3,57,2,1346.92,NULL,'2022-09-02 00:56:28','2022-09-02 00:57:48','2022-09-02 00:57:48'),(312,7730,127,40720,1522,3,488,1,1086.20,NULL,'2022-09-02 00:57:48','2022-09-02 00:58:14','2022-09-02 00:58:14'),(313,7730,127,40720,1522,3,68,1,228.10,NULL,'2022-09-02 00:57:48','2022-09-02 00:58:14','2022-09-02 00:58:14'),(314,7730,127,40720,1522,3,226,1,32.59,NULL,'2022-09-02 00:57:48','2022-09-02 00:58:14','2022-09-02 00:58:14'),(315,7730,127,40720,1522,3,57,2,1346.89,NULL,'2022-09-02 00:57:48','2022-09-02 00:58:14','2022-09-02 00:58:14'),(316,7730,128,40720,1522,3,488,1,1086.20,NULL,'2022-09-02 00:58:14','2022-09-02 00:58:14',NULL),(317,7730,128,40720,1522,3,68,1,228.10,NULL,'2022-09-02 00:58:14','2022-09-02 00:58:14',NULL),(318,7730,128,40720,1522,3,226,1,32.59,NULL,'2022-09-02 00:58:14','2022-09-02 00:58:14',NULL),(319,7730,128,40720,1522,3,57,2,1346.89,NULL,'2022-09-02 00:58:14','2022-09-02 00:58:14',NULL),(320,7730,129,40720,1519,3,495,1,16500.00,NULL,'2022-09-02 01:38:39','2022-09-02 01:41:51','2022-09-02 01:41:51'),(321,7730,129,40720,1519,3,496,2,16500.00,NULL,'2022-09-02 01:38:39','2022-09-02 01:41:51','2022-09-02 01:41:51'),(322,7730,130,40720,1519,3,496,1,16500.00,NULL,'2022-09-02 01:40:14','2022-09-02 01:41:07','2022-09-02 01:41:07'),(323,7730,130,40720,1519,3,452,2,16500.00,NULL,'2022-09-02 01:40:14','2022-09-02 01:41:07','2022-09-02 01:41:07');
INSERT INTO `balance_libro_details` VALUES (324,7730,131,40720,1519,3,496,1,16500.00,NULL,'2022-09-02 01:41:07','2022-09-02 01:42:16','2022-09-02 01:42:16'),(325,7730,131,40720,1519,3,452,2,16500.00,NULL,'2022-09-02 01:41:07','2022-09-02 01:42:16','2022-09-02 01:42:16'),(326,7730,132,40720,1519,3,495,1,16500.00,NULL,'2022-09-02 01:41:51','2022-09-02 01:41:51',NULL),(327,7730,132,40720,1519,3,496,2,16500.00,NULL,'2022-09-02 01:41:51','2022-09-02 01:41:51',NULL),(328,7730,133,40720,1519,21,496,1,16500.00,NULL,'2022-09-02 01:42:16','2022-11-20 03:47:58','2022-11-20 03:47:58'),(329,7730,133,40720,1519,21,452,2,16500.00,NULL,'2022-09-02 01:42:16','2022-11-20 03:47:58','2022-11-20 03:47:58'),(330,7730,134,40720,1519,5,452,1,16500.00,NULL,'2022-09-02 01:42:33','2022-11-21 18:48:12','2022-11-21 18:48:12'),(331,7730,134,40720,1519,5,485,2,16500.00,NULL,'2022-09-02 01:42:33','2022-11-21 18:48:12','2022-11-21 18:48:12'),(332,7730,135,40720,1519,21,485,1,16500.00,NULL,'2022-09-02 01:46:41','2022-11-20 03:45:17','2022-11-20 03:45:17'),(333,7730,135,40720,1519,21,359,2,16500.00,NULL,'2022-09-02 01:46:41','2022-11-20 03:45:17','2022-11-20 03:45:17'),(334,7730,136,40720,1521,21,57,1,747.66,NULL,'2022-09-02 02:26:47','2022-09-02 02:36:33','2022-09-02 02:36:33'),(335,7730,136,40720,1521,21,484,2,747.66,NULL,'2022-09-02 02:26:47','2022-09-02 02:36:33','2022-09-02 02:36:33'),(336,7730,137,40720,1521,3,192,1,14400.00,NULL,'2022-09-02 02:33:48','2022-09-02 02:46:12','2022-09-02 02:46:12'),(337,7730,137,40720,1521,3,493,2,14400.00,NULL,'2022-09-02 02:33:48','2022-09-02 02:46:12','2022-09-02 02:46:12'),(338,7730,138,40720,1521,21,493,1,14400.00,NULL,'2022-09-02 02:35:14','2022-09-02 02:45:58','2022-09-02 02:45:58'),(339,7730,138,40720,1521,21,359,2,14400.00,NULL,'2022-09-02 02:35:14','2022-09-02 02:45:58','2022-09-02 02:45:58'),(340,7730,139,40720,1521,3,488,1,685.36,NULL,'2022-09-02 02:43:37','2022-09-02 02:43:37',NULL),(341,7730,139,40720,1521,3,225,1,45.31,NULL,'2022-09-02 02:43:37','2022-09-02 02:43:37',NULL),(342,7730,139,40720,1521,3,226,1,16.99,NULL,'2022-09-02 02:43:37','2022-09-02 02:43:37',NULL),(343,7730,139,40720,1521,3,492,2,747.66,NULL,'2022-09-02 02:43:37','2022-09-02 02:43:37',NULL),(344,7730,140,40720,1521,21,492,1,747.66,NULL,'2022-09-02 02:44:32','2022-09-02 02:44:32',NULL),(345,7730,140,40720,1521,21,484,2,747.66,NULL,'2022-09-02 02:44:32','2022-09-02 02:44:32',NULL),(346,7730,141,40720,1521,21,493,1,14400.00,NULL,'2022-09-02 02:45:58','2022-09-02 02:49:13','2022-09-02 02:49:13'),(347,7730,141,40720,1521,21,359,2,14400.00,NULL,'2022-09-02 02:45:58','2022-09-02 02:49:13','2022-09-02 02:49:13'),(348,7730,142,40720,1521,3,192,1,14400.00,NULL,'2022-09-02 02:46:12','2022-09-02 02:46:12',NULL),(349,7730,142,40720,1521,3,493,2,14400.00,NULL,'2022-09-02 02:46:12','2022-09-02 02:46:12',NULL),(350,7730,143,40720,1521,21,493,1,14400.00,NULL,'2022-09-02 02:49:13','2022-09-02 03:32:40','2022-09-02 03:32:40'),(351,7730,143,40720,1521,21,359,2,14400.00,NULL,'2022-09-02 02:49:13','2022-09-02 03:32:40','2022-09-02 03:32:40'),(352,7730,144,40720,1521,3,487,1,786.50,NULL,'2022-09-02 02:52:39','2022-09-02 02:52:39',NULL),(353,7730,144,40720,1521,3,490,2,786.50,NULL,'2022-09-02 02:52:39','2022-09-02 02:52:39',NULL),(354,7730,145,40720,1521,21,490,1,786.50,NULL,'2022-09-02 02:53:58','2022-09-02 02:53:58',NULL),(355,7730,145,40720,1521,21,359,2,786.50,NULL,'2022-09-02 02:53:58','2022-09-02 02:53:58',NULL),(356,7730,146,40720,1521,3,489,1,989.41,NULL,'2022-09-02 02:56:48','2022-09-02 02:56:48',NULL),(357,7730,146,40720,1521,3,491,2,989.41,NULL,'2022-09-02 02:56:48','2022-09-02 02:56:48',NULL),(358,7730,147,40720,1521,21,491,1,989.41,NULL,'2022-09-02 02:58:22','2022-09-02 02:58:22',NULL),(359,7730,147,40720,1521,21,359,2,989.41,NULL,'2022-09-02 02:58:22','2022-09-02 02:58:22',NULL),(360,7730,148,40720,1520,16,156,1,217.85,NULL,'2022-09-02 03:07:31','2022-09-02 04:20:14','2022-09-02 04:20:14'),(361,7730,148,40720,1520,16,326,2,217.85,NULL,'2022-09-02 03:07:31','2022-09-02 04:20:14','2022-09-02 04:20:14');
INSERT INTO `balance_libro_details` VALUES (362,7730,149,40720,1520,15,67,1,914.97,NULL,'2022-09-02 03:07:52','2022-09-02 04:22:07','2022-09-02 04:22:07'),(363,7730,149,40720,1520,15,74,2,914.98,NULL,'2022-09-02 03:07:52','2022-09-02 04:22:07','2022-09-02 04:22:07'),(364,7730,149,40720,1520,15,136,1,0.01,NULL,'2022-09-02 03:07:52','2022-09-02 04:22:07','2022-09-02 04:22:07'),(365,7730,150,40720,1521,15,67,1,835.66,NULL,'2022-09-02 03:08:19','2022-09-02 03:17:18','2022-09-02 03:17:18'),(366,7730,150,40720,1521,15,68,2,1205.19,NULL,'2022-09-02 03:08:19','2022-09-02 03:17:18','2022-09-02 03:17:18'),(367,7730,150,40720,1521,15,353,1,369.53,NULL,'2022-09-02 03:08:19','2022-09-02 03:17:18','2022-09-02 03:17:18'),(368,7730,151,40720,1521,3,488,1,566.41,NULL,'2022-09-02 03:17:22','2022-09-02 03:20:56','2022-09-02 03:20:56'),(369,7730,151,40720,1521,3,68,1,118.95,NULL,'2022-09-02 03:17:22','2022-09-02 03:20:56','2022-09-02 03:20:56'),(370,7730,151,40720,1521,3,225,1,45.31,NULL,'2022-09-02 03:17:22','2022-09-02 03:20:56','2022-09-02 03:20:56'),(371,7730,151,40720,1521,3,226,1,16.99,NULL,'2022-09-02 03:17:22','2022-09-02 03:20:56','2022-09-02 03:20:56'),(372,7730,151,40720,1521,3,57,2,747.66,NULL,'2022-09-02 03:17:22','2022-09-02 03:20:56','2022-09-02 03:20:56'),(373,7730,152,40720,1521,15,67,1,835.66,NULL,'2022-09-02 03:23:59','2022-09-02 04:22:15','2022-09-02 04:22:15'),(374,7730,152,40720,1521,15,68,2,1205.19,NULL,'2022-09-02 03:23:59','2022-09-02 04:22:15','2022-09-02 04:22:15'),(375,7730,152,40720,1521,15,353,1,369.53,NULL,'2022-09-02 03:23:59','2022-09-02 04:22:15','2022-09-02 04:22:15'),(376,7730,153,40720,1521,16,156,1,240.75,NULL,'2022-09-02 03:24:27','2022-09-02 04:22:24','2022-09-02 04:22:24'),(377,7730,153,40720,1521,16,326,2,240.75,NULL,'2022-09-02 03:24:27','2022-09-02 04:22:24','2022-09-02 04:22:24'),(378,7730,154,40720,1521,9,135,1,62.30,NULL,'2022-09-02 03:27:04','2022-09-27 01:52:13','2022-09-27 01:52:13'),(379,7730,154,40720,1521,9,225,2,45.31,NULL,'2022-09-02 03:27:04','2022-09-27 01:52:13','2022-09-27 01:52:13'),(380,7730,154,40720,1521,9,226,2,16.99,NULL,'2022-09-02 03:27:04','2022-09-27 01:52:13','2022-09-27 01:52:13'),(381,7730,155,40720,1521,21,493,1,14400.00,NULL,'2022-09-02 03:32:40','2022-09-02 03:32:40',NULL),(382,7730,155,40720,1521,21,359,2,14400.00,NULL,'2022-09-02 03:32:40','2022-09-02 03:32:40',NULL),(383,7730,156,40720,1520,2,96,2,4357.02,NULL,'2022-09-02 04:23:51','2022-09-02 04:43:00','2022-09-02 04:43:00'),(384,7730,156,40720,1520,2,67,2,914.97,NULL,'2022-09-02 04:23:51','2022-09-02 04:43:00','2022-09-02 04:43:00'),(385,7730,156,40720,1520,2,13,1,5271.99,NULL,'2022-09-02 04:23:51','2022-09-02 04:43:00','2022-09-02 04:43:00'),(386,7730,157,40720,1521,2,96,2,3979.34,NULL,'2022-09-02 04:24:05','2022-09-02 04:24:05',NULL),(387,7730,157,40720,1521,2,67,2,835.66,NULL,'2022-09-02 04:24:05','2022-09-02 04:24:05',NULL),(388,7730,157,40720,1521,2,13,1,4815.00,NULL,'2022-09-02 04:24:05','2022-09-02 04:24:05',NULL),(389,7730,158,40720,1522,2,96,2,4376.03,NULL,'2022-09-02 04:28:12','2022-09-02 04:28:12',NULL),(390,7730,158,40720,1522,2,67,2,918.97,NULL,'2022-09-02 04:28:12','2022-09-02 04:28:12',NULL),(391,7730,158,40720,1522,2,13,1,5295.00,NULL,'2022-09-02 04:28:12','2022-09-02 04:28:12',NULL),(392,7730,159,40720,1522,2,96,2,9714.06,NULL,'2022-09-02 04:28:27','2022-09-04 02:29:11','2022-09-04 02:29:11'),(393,7730,159,40720,1522,2,67,2,2039.95,NULL,'2022-09-02 04:28:27','2022-09-04 02:29:11','2022-09-04 02:29:11'),(394,7730,159,40720,1522,2,13,1,11754.01,NULL,'2022-09-02 04:28:27','2022-09-04 02:29:11','2022-09-04 02:29:11'),(395,7730,160,40720,1522,2,96,2,123.97,NULL,'2022-09-02 04:28:43','2022-09-02 04:28:43',NULL),(396,7730,160,40720,1522,2,67,2,26.03,NULL,'2022-09-02 04:28:43','2022-09-02 04:28:43',NULL),(397,7730,160,40720,1522,2,13,1,150.00,NULL,'2022-09-02 04:28:43','2022-09-02 04:28:43',NULL),(398,7730,161,40720,1522,2,96,2,123.97,NULL,'2022-09-02 04:29:26','2022-09-02 04:29:26',NULL);
INSERT INTO `balance_libro_details` VALUES (399,7730,161,40720,1522,2,67,2,26.03,NULL,'2022-09-02 04:29:26','2022-09-02 04:29:26',NULL),(400,7730,161,40720,1522,2,13,1,150.00,NULL,'2022-09-02 04:29:26','2022-09-02 04:29:26',NULL),(401,7730,162,40720,1522,2,96,2,180.99,NULL,'2022-09-02 04:29:38','2022-09-02 04:29:38',NULL),(402,7730,162,40720,1522,2,67,2,38.01,NULL,'2022-09-02 04:29:38','2022-09-02 04:29:38',NULL),(403,7730,162,40720,1522,2,13,1,219.00,NULL,'2022-09-02 04:29:38','2022-09-02 04:29:38',NULL),(404,7730,163,40720,1522,2,96,2,180.99,NULL,'2022-09-02 04:30:02','2022-09-02 04:30:02',NULL),(405,7730,163,40720,1522,2,67,2,38.01,NULL,'2022-09-02 04:30:02','2022-09-02 04:30:02',NULL),(406,7730,163,40720,1522,2,13,1,219.00,NULL,'2022-09-02 04:30:02','2022-09-02 04:30:02',NULL),(407,7730,164,40720,1522,2,96,2,1619.01,NULL,'2022-09-02 04:30:20','2022-09-02 04:30:20',NULL),(408,7730,164,40720,1522,2,67,2,339.99,NULL,'2022-09-02 04:30:20','2022-09-02 04:30:20',NULL),(409,7730,164,40720,1522,2,13,1,1959.00,NULL,'2022-09-02 04:30:20','2022-09-02 04:30:20',NULL),(410,7730,165,40720,1522,2,96,2,123.97,NULL,'2022-09-02 04:30:32','2022-09-04 02:28:53','2022-09-04 02:28:53'),(411,7730,165,40720,1522,2,67,2,26.03,NULL,'2022-09-02 04:30:32','2022-09-04 02:28:53','2022-09-04 02:28:53'),(412,7730,165,40720,1522,2,13,1,150.00,NULL,'2022-09-02 04:30:32','2022-09-04 02:28:53','2022-09-04 02:28:53'),(413,7730,166,40720,1520,15,67,1,914.97,NULL,'2022-09-02 04:36:36','2022-09-02 04:41:36','2022-09-02 04:41:36'),(414,7730,166,40720,1520,15,74,2,914.98,NULL,'2022-09-02 04:36:36','2022-09-02 04:41:36','2022-09-02 04:41:36'),(415,7730,166,40720,1520,15,136,1,0.01,NULL,'2022-09-02 04:36:36','2022-09-02 04:41:36','2022-09-02 04:41:36'),(416,7730,167,40720,1520,16,156,1,217.85,NULL,'2022-09-02 04:36:55','2022-09-02 04:42:03','2022-09-02 04:42:03'),(417,7730,167,40720,1520,16,326,2,217.85,NULL,'2022-09-02 04:36:55','2022-09-02 04:42:03','2022-09-02 04:42:03'),(418,7730,168,40720,1521,15,67,1,835.66,NULL,'2022-09-02 04:37:31','2022-09-02 04:37:31',NULL),(419,7730,168,40720,1521,15,68,2,1205.19,NULL,'2022-09-02 04:37:31','2022-09-02 04:37:31',NULL),(420,7730,168,40720,1521,15,353,1,369.53,NULL,'2022-09-02 04:37:31','2022-09-02 04:37:31',NULL),(421,7730,169,40720,1521,16,156,1,240.75,NULL,'2022-09-02 04:37:55','2022-09-04 02:55:57','2022-09-04 02:55:57'),(422,7730,169,40720,1521,16,326,2,240.75,NULL,'2022-09-02 04:37:55','2022-09-04 02:55:57','2022-09-04 02:55:57'),(423,7730,170,40720,1520,2,96,2,4357.02,NULL,'2022-09-02 04:44:36','2022-09-02 04:44:36',NULL),(424,7730,170,40720,1520,2,67,2,914.98,NULL,'2022-09-02 04:44:36','2022-09-02 04:44:36',NULL),(425,7730,170,40720,1520,2,13,1,5272.00,NULL,'2022-09-02 04:44:36','2022-09-02 04:44:36',NULL),(426,7730,171,40720,1520,20,13,2,5272.00,NULL,'2022-09-02 04:48:48','2022-09-02 04:48:48',NULL),(427,7730,171,40720,1520,20,484,1,5272.00,NULL,'2022-09-02 04:48:48','2022-09-02 04:48:48',NULL),(428,7730,172,40720,1521,20,13,2,4815.00,NULL,'2022-09-02 04:50:02','2022-09-02 04:50:02',NULL),(429,7730,172,40720,1521,20,484,1,4815.00,NULL,'2022-09-02 04:50:02','2022-09-02 04:50:02',NULL),(430,7730,173,40720,1521,20,13,2,5295.00,NULL,'2022-09-02 04:51:17','2022-09-02 05:10:29','2022-09-02 05:10:29'),(431,7730,173,40720,1521,20,484,1,5295.00,NULL,'2022-09-02 04:51:17','2022-09-02 05:10:29','2022-09-02 05:10:29'),(432,7730,174,40720,1522,20,13,2,219.00,NULL,'2022-09-02 04:52:22','2022-09-02 04:52:22',NULL),(433,7730,174,40720,1522,20,484,1,219.00,NULL,'2022-09-02 04:52:22','2022-09-02 04:52:22',NULL),(434,7730,175,40720,1522,20,13,2,150.00,NULL,'2022-09-02 04:53:18','2022-09-02 04:53:30','2022-09-02 04:53:30'),(435,7730,175,40720,1522,20,484,1,150.00,NULL,'2022-09-02 04:53:18','2022-09-02 04:53:30','2022-09-02 04:53:30'),(436,7730,176,40720,1522,20,13,2,150.00,NULL,'2022-09-02 04:54:33','2022-09-02 04:54:33',NULL),(437,7730,176,40720,1522,20,484,1,150.00,NULL,'2022-09-02 04:54:33','2022-09-02 04:54:33',NULL);
INSERT INTO `balance_libro_details` VALUES (438,7730,177,40720,1522,20,13,2,150.00,NULL,'2022-09-02 04:55:29','2022-09-02 04:55:29',NULL),(439,7730,177,40720,1522,20,484,1,150.00,NULL,'2022-09-02 04:55:29','2022-09-02 04:55:29',NULL),(440,7730,178,40720,1522,20,13,2,219.00,NULL,'2022-09-02 04:56:45','2022-09-02 04:56:45',NULL),(441,7730,178,40720,1522,20,484,1,219.00,NULL,'2022-09-02 04:56:45','2022-09-02 04:56:45',NULL),(442,7730,179,40720,1522,20,13,2,1959.00,NULL,'2022-09-02 04:57:54','2022-09-02 04:57:54',NULL),(443,7730,179,40720,1522,20,484,1,1959.00,NULL,'2022-09-02 04:57:54','2022-09-02 04:57:54',NULL),(444,7730,180,40720,1522,20,13,2,11754.01,NULL,'2022-09-02 04:58:54','2022-09-04 02:28:22','2022-09-04 02:28:22'),(445,7730,180,40720,1522,20,484,1,11754.01,NULL,'2022-09-02 04:58:54','2022-09-04 02:28:22','2022-09-04 02:28:22'),(446,7730,181,40720,1522,20,13,2,150.00,NULL,'2022-09-02 04:59:43','2022-09-04 02:28:10','2022-09-04 02:28:10'),(447,7730,181,40720,1522,20,484,1,150.00,NULL,'2022-09-02 04:59:43','2022-09-04 02:28:10','2022-09-04 02:28:10'),(448,7730,182,40720,1520,16,156,1,217.85,NULL,'2022-09-02 05:00:31','2022-09-02 05:00:31',NULL),(449,7730,182,40720,1520,16,326,2,217.85,NULL,'2022-09-02 05:00:31','2022-09-02 05:00:31',NULL),(450,7730,183,40720,1520,15,67,1,914.97,NULL,'2022-09-02 05:01:10','2022-09-02 05:01:10',NULL),(451,7730,183,40720,1520,15,74,2,914.98,NULL,'2022-09-02 05:01:10','2022-09-02 05:01:10',NULL),(452,7730,183,40720,1520,15,136,1,0.01,NULL,'2022-09-02 05:01:10','2022-09-02 05:01:10',NULL),(453,7730,184,40720,1522,20,13,2,5295.00,NULL,'2022-09-02 05:11:36','2022-09-02 05:11:36',NULL),(454,7730,184,40720,1522,20,484,1,5295.00,NULL,'2022-09-02 05:11:36','2022-09-02 05:11:36',NULL),(455,7730,185,40720,1522,3,487,1,907.50,NULL,'2022-09-03 23:02:31','2022-09-03 23:02:31',NULL),(456,7730,185,40720,1522,3,490,2,907.50,NULL,'2022-09-03 23:02:31','2022-09-03 23:02:31',NULL),(457,7730,186,40720,1522,21,490,1,907.50,NULL,'2022-09-03 23:05:17','2022-09-03 23:05:17',NULL),(458,7730,186,40720,1522,21,359,2,907.50,NULL,'2022-09-03 23:05:17','2022-09-03 23:05:17',NULL),(459,7730,187,40720,1522,21,57,1,1346.89,NULL,'2022-09-03 23:06:29','2022-09-03 23:06:29',NULL),(460,7730,187,40720,1522,21,484,2,1346.89,NULL,'2022-09-03 23:06:29','2022-09-03 23:06:29',NULL),(461,7730,188,40720,1522,5,444,1,100.00,NULL,'2022-09-04 01:24:53','2022-09-04 01:31:10','2022-09-04 01:31:10'),(462,7730,188,40720,1522,5,484,2,100.00,NULL,'2022-09-04 01:24:53','2022-09-04 01:31:10','2022-09-04 01:31:10'),(463,7730,189,40720,1522,5,444,1,12895.00,NULL,'2022-09-04 01:27:31','2022-09-04 01:32:10','2022-09-04 01:32:10'),(464,7730,189,40720,1522,5,484,2,12895.00,NULL,'2022-09-04 01:27:31','2022-09-04 01:32:10','2022-09-04 01:32:10'),(465,7730,190,40720,1522,5,497,1,100.00,NULL,'2022-09-04 01:31:10','2022-09-04 01:31:10',NULL),(466,7730,190,40720,1522,5,484,2,100.00,NULL,'2022-09-04 01:31:10','2022-09-04 01:31:10',NULL),(467,7730,191,40720,1522,5,497,1,12895.00,NULL,'2022-09-04 01:32:10','2022-09-04 01:32:10',NULL),(468,7730,191,40720,1522,5,484,2,12895.00,NULL,'2022-09-04 01:32:10','2022-09-04 01:32:10',NULL),(469,7730,192,40720,1522,3,437,1,77.97,NULL,'2022-09-04 01:33:11','2022-09-04 01:34:21','2022-09-04 01:34:21'),(470,7730,192,40720,1522,3,497,2,77.97,NULL,'2022-09-04 01:33:11','2022-09-04 01:34:21','2022-09-04 01:34:21'),(471,7730,193,40720,1522,21,437,1,77.97,NULL,'2022-09-04 01:34:21','2022-09-04 01:34:21',NULL),(472,7730,193,40720,1522,21,497,2,77.97,NULL,'2022-09-04 01:34:21','2022-09-04 01:34:21',NULL),(473,7730,194,40720,1522,15,67,1,3453.03,NULL,'2022-09-04 01:37:33','2022-09-04 02:25:47','2022-09-04 02:25:47'),(474,7730,194,40720,1522,15,68,2,228.10,NULL,'2022-09-04 01:37:33','2022-09-04 02:25:47','2022-09-04 02:25:47'),(475,7730,194,40720,1522,15,353,2,369.53,NULL,'2022-09-04 01:37:33','2022-09-04 02:25:47','2022-09-04 02:25:47'),(476,7730,194,40720,1522,15,74,2,2855.40,NULL,'2022-09-04 01:37:33','2022-09-04 02:25:47','2022-09-04 02:25:47');
INSERT INTO `balance_libro_details` VALUES (477,7730,195,40720,1522,2,96,2,123.97,NULL,'2022-09-04 02:28:54','2022-09-04 02:28:54',NULL),(478,7730,195,40720,1522,2,67,2,26.03,NULL,'2022-09-04 02:28:54','2022-09-04 02:28:54',NULL),(479,7730,195,40720,1522,2,13,1,150.00,NULL,'2022-09-04 02:28:54','2022-09-04 02:28:54',NULL),(480,7730,196,40720,1522,2,96,2,9714.06,NULL,'2022-09-04 02:29:11','2022-09-04 02:29:11',NULL),(481,7730,196,40720,1522,2,67,2,2039.95,NULL,'2022-09-04 02:29:11','2022-09-04 02:29:11',NULL),(482,7730,196,40720,1522,2,13,1,11754.01,NULL,'2022-09-04 02:29:11','2022-09-04 02:29:11',NULL),(483,7730,197,40720,1522,20,13,2,11754.01,NULL,'2022-09-04 02:30:53','2022-09-04 02:30:53',NULL),(484,7730,197,40720,1522,20,484,1,11754.01,NULL,'2022-09-04 02:30:53','2022-09-04 02:30:53',NULL),(485,7730,198,40720,1522,20,13,2,150.00,NULL,'2022-09-04 02:32:18','2022-09-04 02:32:18',NULL),(486,7730,198,40720,1522,20,484,1,150.00,NULL,'2022-09-04 02:32:18','2022-09-04 02:32:18',NULL),(487,7730,199,40720,1522,16,156,1,295.14,NULL,'2022-09-04 02:50:01','2022-09-04 02:50:01',NULL),(488,7730,199,40720,1522,16,226,2,32.59,NULL,'2022-09-04 02:50:01','2022-09-04 02:50:01',NULL),(489,7730,199,40720,1522,16,327,2,262.55,NULL,'2022-09-04 02:50:01','2022-09-04 02:50:01',NULL),(490,7730,199,40720,1522,16,156,1,330.25,NULL,'2022-09-04 02:50:01','2022-09-04 02:50:01',NULL),(491,7730,199,40720,1522,16,326,2,330.25,NULL,'2022-09-04 02:50:01','2022-09-04 02:50:01',NULL),(492,7730,200,40720,1522,15,67,1,3453.03,NULL,'2022-09-04 02:50:22','2022-09-04 02:50:22',NULL),(493,7730,200,40720,1522,15,68,2,228.10,NULL,'2022-09-04 02:50:22','2022-09-04 02:50:22',NULL),(494,7730,200,40720,1522,15,353,2,369.53,NULL,'2022-09-04 02:50:22','2022-09-04 02:50:22',NULL),(495,7730,200,40720,1522,15,74,2,2855.40,NULL,'2022-09-04 02:50:22','2022-09-04 02:50:22',NULL),(496,7730,201,40720,1521,16,156,1,198.97,NULL,'2022-09-04 02:57:06','2022-09-04 02:57:06',NULL),(497,7730,201,40720,1521,16,326,2,198.97,NULL,'2022-09-04 02:57:06','2022-09-04 02:57:06',NULL),(498,7730,202,40720,1522,3,489,1,989.41,NULL,'2022-09-04 03:13:22','2022-09-04 03:15:22','2022-09-04 03:15:22'),(499,7730,202,40720,1522,3,490,2,989.41,NULL,'2022-09-04 03:13:22','2022-09-04 03:15:22','2022-09-04 03:15:22'),(500,7730,203,40720,1522,3,489,1,989.41,NULL,'2022-09-04 03:15:22','2022-09-04 03:15:22',NULL),(501,7730,203,40720,1522,3,491,2,989.41,NULL,'2022-09-04 03:15:22','2022-09-04 03:15:22',NULL),(502,7730,204,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:55','2022-09-04 03:34:24','2022-09-04 03:34:24'),(503,7730,204,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:55','2022-09-04 03:34:24','2022-09-04 03:34:24'),(504,7730,204,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:55','2022-09-04 03:34:24','2022-09-04 03:34:24'),(505,7730,205,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:55','2022-09-04 03:37:12','2022-09-04 03:37:12'),(506,7730,205,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:55','2022-09-04 03:37:12','2022-09-04 03:37:12'),(507,7730,205,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:55','2022-09-04 03:37:12','2022-09-04 03:37:12'),(508,7730,206,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:40:13','2022-09-04 03:40:13'),(509,7730,206,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:40:13','2022-09-04 03:40:13'),(510,7730,206,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:40:13','2022-09-04 03:40:13'),(511,7730,207,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:45:21','2022-09-04 03:45:21'),(512,7730,207,40720,1523,2,218,2,14478.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:45:21','2022-09-04 03:45:21'),(513,7730,207,40720,1523,2,13,1,14478.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:45:21','2022-09-04 03:45:21'),(514,7730,208,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:49:24','2022-09-04 03:49:24'),(515,7730,208,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:49:24','2022-09-04 03:49:24');
INSERT INTO `balance_libro_details` VALUES (516,7730,209,40720,1523,2,218,2,8685.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:47:43','2022-09-04 03:47:43'),(517,7730,209,40720,1523,2,13,1,8685.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:47:43','2022-09-04 03:47:43'),(518,7730,210,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:51:07','2022-09-04 03:51:07'),(519,7730,210,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:51:07','2022-09-04 03:51:07'),(520,7730,210,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:51:07','2022-09-04 03:51:07'),(521,7730,211,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:53:01','2022-09-04 03:53:01'),(522,7730,211,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:53:01','2022-09-04 03:53:01'),(523,7730,211,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:53:01','2022-09-04 03:53:01'),(524,7730,212,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:54:26','2022-09-04 03:54:26'),(525,7730,212,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:54:26','2022-09-04 03:54:26'),(526,7730,212,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:54:26','2022-09-04 03:54:26'),(527,7730,213,40720,1523,2,96,2,7177.69,NULL,'2022-09-04 03:29:56','2022-09-04 03:29:56',NULL),(528,7730,213,40720,1523,2,67,2,1507.31,NULL,'2022-09-04 03:29:56','2022-09-04 03:29:56',NULL),(529,7730,213,40720,1523,2,13,1,8685.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:29:56',NULL),(530,7730,214,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:57:17','2022-09-04 03:57:17'),(531,7730,214,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:57:17','2022-09-04 03:57:17'),(532,7730,214,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 03:57:17','2022-09-04 03:57:17'),(533,7730,215,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:18:26','2022-09-04 04:18:26'),(534,7730,215,40720,1523,2,218,2,4955.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:18:26','2022-09-04 04:18:26'),(535,7730,215,40720,1523,2,13,1,4955.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:18:26','2022-09-04 04:18:26'),(536,7730,216,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:04:23','2022-09-04 04:04:23'),(537,7730,216,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:04:23','2022-09-04 04:04:23'),(538,7730,216,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:04:23','2022-09-04 04:04:23'),(539,7730,217,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:06:04','2022-09-04 04:06:04'),(540,7730,217,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:06:04','2022-09-04 04:06:04'),(541,7730,217,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:06:04','2022-09-04 04:06:04'),(542,7730,218,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:07:36','2022-09-04 04:07:36'),(543,7730,218,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:07:36','2022-09-04 04:07:36'),(544,7730,218,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:07:36','2022-09-04 04:07:36'),(545,7730,219,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:09:11','2022-09-04 04:09:11'),(546,7730,219,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:09:11','2022-09-04 04:09:11'),(547,7730,219,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:09:11','2022-09-04 04:09:11'),(548,7730,220,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:12:01','2022-09-04 04:12:01'),(549,7730,220,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:12:01','2022-09-04 04:12:01'),(550,7730,220,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:12:01','2022-09-04 04:12:01'),(551,7730,221,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:13:18','2022-09-04 04:13:18');
INSERT INTO `balance_libro_details` VALUES (552,7730,221,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:13:18','2022-09-04 04:13:18'),(553,7730,221,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:13:18','2022-09-04 04:13:18'),(554,7730,222,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:14:25','2022-09-04 04:14:25'),(555,7730,222,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:14:25','2022-09-04 04:14:25'),(556,7730,222,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:14:25','2022-09-04 04:14:25'),(557,7730,223,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:10:49','2022-09-04 04:10:49'),(558,7730,223,40720,1523,2,218,2,8685.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:10:49','2022-09-04 04:10:49'),(559,7730,223,40720,1523,2,13,1,8685.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:10:49','2022-09-04 04:10:49'),(560,7730,224,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:19:28','2022-09-04 04:19:28'),(561,7730,224,40720,1523,2,218,2,3880.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:19:28','2022-09-04 04:19:28'),(562,7730,224,40720,1523,2,13,1,3880.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:19:28','2022-09-04 04:19:28'),(563,7730,225,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:15:43','2022-09-04 04:15:43'),(564,7730,225,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:15:43','2022-09-04 04:15:43'),(565,7730,225,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:15:43','2022-09-04 04:15:43'),(566,7730,226,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:20:58','2022-09-04 04:20:58'),(567,7730,226,40720,1523,2,218,2,14478.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:20:58','2022-09-04 04:20:58'),(568,7730,226,40720,1523,2,13,1,14478.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:20:58','2022-09-04 04:20:58'),(569,7730,227,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:22:49','2022-09-04 04:22:49'),(570,7730,227,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:22:49','2022-09-04 04:22:49'),(571,7730,227,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:22:49','2022-09-04 04:22:49'),(572,7730,228,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:24:10','2022-09-04 04:24:10'),(573,7730,228,40720,1523,2,218,2,7971.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:24:10','2022-09-04 04:24:10'),(574,7730,228,40720,1523,2,13,1,7971.00,NULL,'2022-09-04 03:29:56','2022-09-04 04:24:10','2022-09-04 04:24:10'),(575,7730,229,40720,1523,2,218,2,0.00,NULL,'2022-09-04 03:29:57','2022-09-04 04:25:04','2022-09-04 04:25:04'),(576,7730,229,40720,1523,2,218,2,7239.00,NULL,'2022-09-04 03:29:57','2022-09-04 04:25:04','2022-09-04 04:25:04'),(577,7730,229,40720,1523,2,13,1,7239.00,NULL,'2022-09-04 03:29:57','2022-09-04 04:25:04','2022-09-04 04:25:04'),(578,7730,230,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:34:24','2022-09-04 03:35:39','2022-09-04 03:35:39'),(579,7730,230,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:34:24','2022-09-04 03:35:39','2022-09-04 03:35:39'),(580,7730,230,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:34:24','2022-09-04 03:35:39','2022-09-04 03:35:39'),(581,7730,231,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:35:39','2022-09-04 03:36:17','2022-09-04 03:36:17'),(582,7730,231,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:35:39','2022-09-04 03:36:17','2022-09-04 03:36:17'),(583,7730,231,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:35:39','2022-09-04 03:36:17','2022-09-04 03:36:17'),(584,7730,232,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:36:17','2022-09-04 03:41:24','2022-09-04 03:41:24'),(585,7730,232,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:36:17','2022-09-04 03:41:24','2022-09-04 03:41:24'),(586,7730,232,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:36:17','2022-09-04 03:41:24','2022-09-04 03:41:24');
INSERT INTO `balance_libro_details` VALUES (587,7730,233,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:37:12','2022-09-04 03:42:40','2022-09-04 03:42:40'),(588,7730,233,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:37:12','2022-09-04 03:42:40','2022-09-04 03:42:40'),(589,7730,233,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:37:12','2022-09-04 03:42:40','2022-09-04 03:42:40'),(590,7730,234,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:40:13','2022-09-04 03:43:54','2022-09-04 03:43:54'),(591,7730,234,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:40:13','2022-09-04 03:43:54','2022-09-04 03:43:54'),(592,7730,234,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:40:13','2022-09-04 03:43:54','2022-09-04 03:43:54'),(593,7730,235,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:41:24','2022-09-04 03:41:24',NULL),(594,7730,235,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:41:24','2022-09-04 03:41:24',NULL),(595,7730,235,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:41:24','2022-09-04 03:41:24',NULL),(596,7730,236,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:42:40','2022-09-04 03:42:40',NULL),(597,7730,236,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:42:40','2022-09-04 03:42:40',NULL),(598,7730,236,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:42:40','2022-09-04 03:42:40',NULL),(599,7730,237,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:43:54','2022-09-04 03:43:54',NULL),(600,7730,237,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:43:54','2022-09-04 03:43:54',NULL),(601,7730,237,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:43:54','2022-09-04 03:43:54',NULL),(602,7730,238,40720,1523,2,96,2,11965.29,NULL,'2022-09-04 03:45:21','2022-09-04 03:45:21',NULL),(603,7730,238,40720,1523,2,67,2,2512.71,NULL,'2022-09-04 03:45:21','2022-09-04 03:45:21',NULL),(604,7730,238,40720,1523,2,13,1,14478.00,NULL,'2022-09-04 03:45:21','2022-09-04 03:45:21',NULL),(605,7730,239,40720,1523,2,96,2,7177.69,NULL,'2022-09-04 03:47:43','2022-09-04 03:47:43',NULL),(606,7730,239,40720,1523,2,67,2,1507.31,NULL,'2022-09-04 03:47:43','2022-09-04 03:47:43',NULL),(607,7730,239,40720,1523,2,13,1,8685.00,NULL,'2022-09-04 03:47:43','2022-09-04 03:47:43',NULL),(608,7730,240,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:49:24','2022-09-04 03:49:24',NULL),(609,7730,240,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:49:24','2022-09-04 03:49:24',NULL),(610,7730,240,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:49:24','2022-09-04 03:49:24',NULL),(611,7730,241,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:51:07','2022-09-04 03:51:07',NULL),(612,7730,241,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:51:07','2022-09-04 03:51:07',NULL),(613,7730,241,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:51:07','2022-09-04 03:51:07',NULL),(614,7730,242,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:53:01','2022-09-04 03:53:01',NULL),(615,7730,242,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:53:01','2022-09-04 03:53:01',NULL),(616,7730,242,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:53:01','2022-09-04 03:53:01',NULL),(617,7730,243,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:54:26','2022-09-04 03:54:26',NULL),(618,7730,243,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:54:26','2022-09-04 03:54:26',NULL),(619,7730,243,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:54:26','2022-09-04 03:54:26',NULL),(620,7730,244,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:57:17','2022-09-04 03:59:00','2022-09-04 03:59:00'),(621,7730,244,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:57:17','2022-09-04 03:59:00','2022-09-04 03:59:00'),(622,7730,244,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:57:17','2022-09-04 03:59:00','2022-09-04 03:59:00'),(623,7730,245,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 03:59:00','2022-09-04 04:02:49','2022-09-04 04:02:49'),(624,7730,245,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 03:59:00','2022-09-04 04:02:49','2022-09-04 04:02:49'),(625,7730,245,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 03:59:00','2022-09-04 04:02:49','2022-09-04 04:02:49'),(626,7730,246,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:02:49','2022-09-04 04:02:49',NULL);
INSERT INTO `balance_libro_details` VALUES (627,7730,246,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:02:49','2022-09-04 04:02:49',NULL),(628,7730,246,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:02:49','2022-09-04 04:02:49',NULL),(629,7730,247,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:04:23','2022-09-04 04:47:07','2022-09-04 04:47:07'),(630,7730,247,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:04:23','2022-09-04 04:47:07','2022-09-04 04:47:07'),(631,7730,247,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:04:23','2022-09-04 04:47:07','2022-09-04 04:47:07'),(632,7730,248,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:06:04','2022-09-04 04:06:04',NULL),(633,7730,248,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:06:04','2022-09-04 04:06:04',NULL),(634,7730,248,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:06:04','2022-09-04 04:06:04',NULL),(635,7730,249,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:07:36','2022-09-04 04:07:36',NULL),(636,7730,249,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:07:36','2022-09-04 04:07:36',NULL),(637,7730,249,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:07:36','2022-09-04 04:07:36',NULL),(638,7730,250,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:09:11','2022-09-04 04:09:11',NULL),(639,7730,250,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:09:11','2022-09-04 04:09:11',NULL),(640,7730,250,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:09:11','2022-09-04 04:09:11',NULL),(641,7730,251,40720,1523,2,96,2,7177.69,NULL,'2022-09-04 04:10:49','2022-09-04 04:10:49',NULL),(642,7730,251,40720,1523,2,67,2,1507.31,NULL,'2022-09-04 04:10:49','2022-09-04 04:10:49',NULL),(643,7730,251,40720,1523,2,13,1,8685.00,NULL,'2022-09-04 04:10:49','2022-09-04 04:10:49',NULL),(644,7730,252,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:12:01','2022-09-04 04:12:01',NULL),(645,7730,252,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:12:01','2022-09-04 04:12:01',NULL),(646,7730,252,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:12:01','2022-09-04 04:12:01',NULL),(647,7730,253,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:13:18','2022-09-04 04:13:18',NULL),(648,7730,253,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:13:18','2022-09-04 04:13:18',NULL),(649,7730,253,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:13:18','2022-09-04 04:13:18',NULL),(650,7730,254,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:14:25','2022-09-04 04:14:25',NULL),(651,7730,254,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:14:25','2022-09-04 04:14:25',NULL),(652,7730,254,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:14:25','2022-09-04 04:14:25',NULL),(653,7730,255,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:15:43','2022-09-04 04:15:43',NULL),(654,7730,255,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:15:43','2022-09-04 04:15:43',NULL),(655,7730,255,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:15:43','2022-09-04 04:15:43',NULL),(656,7730,256,40720,1523,2,96,2,4095.04,NULL,'2022-09-04 04:18:26','2022-09-04 04:18:26',NULL),(657,7730,256,40720,1523,2,67,2,859.96,NULL,'2022-09-04 04:18:26','2022-09-04 04:18:26',NULL),(658,7730,256,40720,1523,2,13,1,4955.00,NULL,'2022-09-04 04:18:26','2022-09-04 04:18:26',NULL),(659,7730,257,40720,1523,2,96,2,3206.61,NULL,'2022-09-04 04:19:28','2022-09-04 04:19:28',NULL),(660,7730,257,40720,1523,2,67,2,673.39,NULL,'2022-09-04 04:19:28','2022-09-04 04:19:28',NULL),(661,7730,257,40720,1523,2,13,1,3880.00,NULL,'2022-09-04 04:19:28','2022-09-04 04:19:28',NULL),(662,7730,258,40720,1523,2,96,2,11965.29,NULL,'2022-09-04 04:20:58','2022-09-04 04:20:58',NULL),(663,7730,258,40720,1523,2,67,2,2512.71,NULL,'2022-09-04 04:20:58','2022-09-04 04:20:58',NULL),(664,7730,258,40720,1523,2,13,1,14478.00,NULL,'2022-09-04 04:20:58','2022-09-04 04:20:58',NULL),(665,7730,259,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:22:49','2022-09-04 04:22:49',NULL),(666,7730,259,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:22:49','2022-09-04 04:22:49',NULL),(667,7730,259,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:22:49','2022-09-04 04:22:49',NULL);
INSERT INTO `balance_libro_details` VALUES (668,7730,260,40720,1523,2,96,2,6587.60,NULL,'2022-09-04 04:24:10','2022-09-04 04:24:10',NULL),(669,7730,260,40720,1523,2,67,2,1383.40,NULL,'2022-09-04 04:24:10','2022-09-04 04:24:10',NULL),(670,7730,260,40720,1523,2,13,1,7971.00,NULL,'2022-09-04 04:24:10','2022-09-04 04:24:10',NULL),(671,7730,261,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:25:04','2022-09-04 04:25:04',NULL),(672,7730,261,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:25:04','2022-09-04 04:25:04',NULL),(673,7730,261,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:25:04','2022-09-04 04:25:04',NULL),(674,7730,262,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:29:57','2022-09-04 04:29:57',NULL),(675,7730,262,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:29:57','2022-09-04 04:29:57',NULL),(676,7730,263,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:31:28','2022-09-04 04:31:28',NULL),(677,7730,263,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:31:28','2022-09-04 04:31:28',NULL),(678,7730,264,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:37:21','2022-09-04 04:37:21',NULL),(679,7730,264,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:37:21','2022-09-04 04:37:21',NULL),(680,7730,265,40720,1523,20,13,2,14478.00,NULL,'2022-09-04 04:38:26','2022-09-04 04:38:26',NULL),(681,7730,265,40720,1523,20,484,1,14478.00,NULL,'2022-09-04 04:38:26','2022-09-04 04:38:26',NULL),(682,7730,266,40720,1523,20,13,2,8685.00,NULL,'2022-09-04 04:39:39','2022-09-04 04:39:39',NULL),(683,7730,266,40720,1523,20,484,1,8685.00,NULL,'2022-09-04 04:39:39','2022-09-04 04:39:39',NULL),(684,7730,267,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:40:44','2022-09-04 04:40:44',NULL),(685,7730,267,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:40:44','2022-09-04 04:40:44',NULL),(686,7730,268,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:42:14','2022-09-04 04:42:14',NULL),(687,7730,268,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:42:14','2022-09-04 04:42:14',NULL),(688,7730,269,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:43:41','2022-09-04 04:43:41',NULL),(689,7730,269,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:43:41','2022-09-04 04:43:41',NULL),(690,7730,270,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:44:24','2022-09-04 04:44:24',NULL),(691,7730,270,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:44:24','2022-09-04 04:44:24',NULL),(692,7730,271,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:45:26','2022-09-04 04:45:26',NULL),(693,7730,271,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:45:26','2022-09-04 04:45:26',NULL),(694,7730,272,40720,1523,2,96,2,5982.64,NULL,'2022-09-04 04:47:07','2022-09-04 04:47:07',NULL),(695,7730,272,40720,1523,2,67,2,1256.35,NULL,'2022-09-04 04:47:07','2022-09-04 04:47:07',NULL),(696,7730,272,40720,1523,2,13,1,7238.99,NULL,'2022-09-04 04:47:07','2022-09-04 04:47:07',NULL),(697,7730,273,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:47:59','2022-09-04 04:47:59',NULL),(698,7730,273,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:47:59','2022-09-04 04:47:59',NULL),(699,7730,274,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:48:58','2022-09-04 04:48:58',NULL),(700,7730,274,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:48:58','2022-09-04 04:48:58',NULL),(701,7730,275,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:50:16','2022-09-04 04:50:16',NULL),(702,7730,275,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:50:16','2022-09-04 04:50:16',NULL),(703,7730,276,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:51:10','2022-09-04 04:51:10',NULL),(704,7730,276,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:51:10','2022-09-04 04:51:10',NULL),(705,7730,277,40720,1523,20,13,2,8685.00,NULL,'2022-09-04 04:52:07','2022-09-04 04:52:07',NULL),(706,7730,277,40720,1523,20,484,1,8685.00,NULL,'2022-09-04 04:52:07','2022-09-04 04:52:07',NULL),(707,7730,278,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:53:16','2022-09-04 04:53:16',NULL),(708,7730,278,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:53:16','2022-09-04 04:53:16',NULL);
INSERT INTO `balance_libro_details` VALUES (709,7730,279,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:54:08','2022-09-04 04:54:08',NULL),(710,7730,279,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:54:08','2022-09-04 04:54:08',NULL),(711,7730,280,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:55:06','2022-09-04 04:55:06',NULL),(712,7730,280,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:55:06','2022-09-04 04:55:06',NULL),(713,7730,281,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 04:56:15','2022-09-04 04:56:15',NULL),(714,7730,281,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 04:56:15','2022-09-04 04:56:15',NULL),(715,7730,282,40720,1523,20,13,2,8685.00,NULL,'2022-09-04 04:57:04','2022-09-04 04:57:04',NULL),(716,7730,282,40720,1523,20,484,1,8685.00,NULL,'2022-09-04 04:57:04','2022-09-04 04:57:04',NULL),(717,7730,283,40720,1523,20,13,2,4955.00,NULL,'2022-09-04 04:57:56','2022-09-04 04:57:56',NULL),(718,7730,283,40720,1523,20,484,1,4955.00,NULL,'2022-09-04 04:57:56','2022-09-04 04:57:56',NULL),(719,7730,284,40720,1523,20,13,2,3880.00,NULL,'2022-09-04 04:58:49','2022-09-04 04:58:49',NULL),(720,7730,284,40720,1523,20,484,1,3880.00,NULL,'2022-09-04 04:58:49','2022-09-04 04:58:49',NULL),(721,7730,285,40720,1523,20,13,2,14478.00,NULL,'2022-09-04 04:59:44','2022-09-04 04:59:44',NULL),(722,7730,285,40720,1523,20,484,1,14478.00,NULL,'2022-09-04 04:59:44','2022-09-04 04:59:44',NULL),(723,7730,286,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 05:00:55','2022-09-04 05:00:55',NULL),(724,7730,286,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 05:00:55','2022-09-04 05:00:55',NULL),(725,7730,287,40720,1523,20,13,2,7971.00,NULL,'2022-09-04 05:01:50','2022-09-04 05:01:50',NULL),(726,7730,287,40720,1523,20,484,1,7971.00,NULL,'2022-09-04 05:01:50','2022-09-04 05:01:50',NULL),(727,7730,288,40720,1523,20,13,2,7238.99,NULL,'2022-09-04 05:02:47','2022-09-04 05:02:47',NULL),(728,7730,288,40720,1523,20,484,1,7238.99,NULL,'2022-09-04 05:02:47','2022-09-04 05:02:47',NULL),(729,7730,289,40720,1523,3,217,1,1369909.50,NULL,'2022-09-04 05:07:48','2022-09-04 05:17:23','2022-09-04 05:17:23'),(730,7730,289,40720,1523,3,68,1,143840.50,NULL,'2022-09-04 05:07:48','2022-09-04 05:17:23','2022-09-04 05:17:23'),(731,7730,289,40720,1523,3,57,2,1513750.00,NULL,'2022-09-04 05:07:48','2022-09-04 05:17:23','2022-09-04 05:17:23'),(732,7730,290,40720,1523,3,250,1,20000.00,NULL,'2022-09-04 05:07:48','2022-09-04 05:28:22','2022-09-04 05:28:22'),(733,7730,290,40720,1523,3,57,2,20000.00,NULL,'2022-09-04 05:07:48','2022-09-04 05:28:22','2022-09-04 05:28:22'),(734,7730,291,40720,1523,3,217,1,10726.91,NULL,'2022-09-04 05:07:48','2022-09-04 05:13:32','2022-09-04 05:13:32'),(735,7730,291,40720,1523,3,68,1,2252.65,NULL,'2022-09-04 05:07:48','2022-09-04 05:13:32','2022-09-04 05:13:32'),(736,7730,291,40720,1523,3,217,1,4088.19,NULL,'2022-09-04 05:07:48','2022-09-04 05:13:32','2022-09-04 05:13:32'),(737,7730,291,40720,1523,3,57,2,17067.75,NULL,'2022-09-04 05:07:48','2022-09-04 05:13:32','2022-09-04 05:13:32'),(738,7730,292,40720,1523,3,217,2,1369909.50,NULL,'2022-09-04 05:07:48','2022-09-04 05:16:20','2022-09-04 05:16:20'),(739,7730,292,40720,1523,3,67,2,143840.50,NULL,'2022-09-04 05:07:48','2022-09-04 05:16:20','2022-09-04 05:16:20'),(740,7730,292,40720,1523,3,57,1,1513750.00,NULL,'2022-09-04 05:07:48','2022-09-04 05:16:20','2022-09-04 05:16:20'),(741,7730,293,40720,1523,3,217,1,1369909.50,NULL,'2022-09-04 05:07:49','2022-09-04 05:18:16','2022-09-04 05:18:16'),(742,7730,293,40720,1523,3,68,1,143840.50,NULL,'2022-09-04 05:07:49','2022-09-04 05:18:16','2022-09-04 05:18:16'),(743,7730,293,40720,1523,3,57,2,1513750.00,NULL,'2022-09-04 05:07:49','2022-09-04 05:18:16','2022-09-04 05:18:16'),(744,7730,294,40720,1523,3,217,1,69894.90,NULL,'2022-09-04 05:07:49','2022-09-04 10:51:32','2022-09-04 10:51:32'),(745,7730,294,40720,1523,3,68,1,14677.93,NULL,'2022-09-04 05:07:49','2022-09-04 10:51:32','2022-09-04 10:51:32'),(746,7730,294,40720,1523,3,57,2,84572.83,NULL,'2022-09-04 05:07:49','2022-09-04 10:51:32','2022-09-04 10:51:32');
INSERT INTO `balance_libro_details` VALUES (747,7730,295,40720,1523,3,217,1,4860.00,NULL,'2022-09-04 05:07:49','2022-09-04 10:51:55','2022-09-04 10:51:55'),(748,7730,295,40720,1523,3,68,1,1020.60,NULL,'2022-09-04 05:07:49','2022-09-04 10:51:55','2022-09-04 10:51:55'),(749,7730,295,40720,1523,3,57,2,5880.60,NULL,'2022-09-04 05:07:49','2022-09-04 10:51:55','2022-09-04 10:51:55'),(750,7730,296,40720,1523,3,217,1,38880.00,NULL,'2022-09-04 05:07:49','2022-09-04 10:52:38','2022-09-04 10:52:38'),(751,7730,296,40720,1523,3,68,1,8164.80,NULL,'2022-09-04 05:07:49','2022-09-04 10:52:38','2022-09-04 10:52:38'),(752,7730,296,40720,1523,3,57,2,47044.80,NULL,'2022-09-04 05:07:49','2022-09-04 10:52:38','2022-09-04 10:52:38'),(753,7730,297,40720,1523,3,488,1,10726.91,NULL,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(754,7730,297,40720,1523,3,68,1,2252.65,NULL,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(755,7730,297,40720,1523,3,488,1,4088.19,NULL,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(756,7730,297,40720,1523,3,220,1,2974.92,NULL,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(757,7730,297,40720,1523,3,226,1,1113.27,NULL,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(758,7730,297,40720,1523,3,57,2,21155.94,NULL,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(759,7730,298,40720,1523,3,488,1,10726.91,NULL,'2022-09-04 05:13:57','2022-09-04 05:13:57',NULL),(760,7730,298,40720,1523,3,68,1,2252.65,NULL,'2022-09-04 05:13:57','2022-09-04 05:13:57',NULL),(761,7730,298,40720,1523,3,220,1,2974.92,NULL,'2022-09-04 05:13:57','2022-09-04 05:13:57',NULL),(762,7730,298,40720,1523,3,226,1,1113.27,NULL,'2022-09-04 05:13:57','2022-09-04 05:13:57',NULL),(763,7730,298,40720,1523,3,57,2,17067.75,NULL,'2022-09-04 05:13:57','2022-09-04 05:13:57',NULL),(764,7730,299,40720,1523,3,391,2,1369909.50,NULL,'2022-09-04 05:16:20','2022-09-04 05:16:20',NULL),(765,7730,299,40720,1523,3,67,2,143840.50,NULL,'2022-09-04 05:16:20','2022-09-04 05:16:20',NULL),(766,7730,299,40720,1523,3,57,1,1513750.00,NULL,'2022-09-04 05:16:20','2022-09-04 05:16:20',NULL),(767,7730,300,40720,1523,3,391,1,1369909.50,NULL,'2022-09-04 05:17:23','2022-09-04 05:17:23',NULL),(768,7730,300,40720,1523,3,68,1,143840.50,NULL,'2022-09-04 05:17:23','2022-09-04 05:17:23',NULL),(769,7730,300,40720,1523,3,57,2,1513750.00,NULL,'2022-09-04 05:17:23','2022-09-04 05:17:23',NULL),(770,7730,301,40720,1523,3,391,1,1369909.50,NULL,'2022-09-04 05:18:16','2022-09-04 05:18:16',NULL),(771,7730,301,40720,1523,3,68,1,143840.50,NULL,'2022-09-04 05:18:16','2022-09-04 05:18:16',NULL),(772,7730,301,40720,1523,3,57,2,1513750.00,NULL,'2022-09-04 05:18:16','2022-09-04 05:18:16',NULL),(773,7730,302,40720,1523,21,57,1,17067.75,NULL,'2022-09-04 05:23:20','2022-09-04 05:23:20',NULL),(774,7730,302,40720,1523,21,484,2,17067.75,NULL,'2022-09-04 05:23:20','2022-09-04 05:23:20',NULL),(775,7730,303,40720,1523,3,498,1,20000.00,NULL,'2022-09-04 05:28:22','2022-09-04 05:28:22',NULL),(776,7730,303,40720,1523,3,57,2,20000.00,NULL,'2022-09-04 05:28:22','2022-09-04 05:28:22',NULL),(777,7730,304,40720,1523,21,57,1,20000.00,NULL,'2022-09-04 05:34:03','2022-09-04 05:34:03',NULL),(778,7730,304,40720,1523,21,497,2,20000.00,NULL,'2022-09-04 05:34:03','2022-09-04 05:34:03',NULL),(779,7730,305,40720,1523,21,491,1,989.41,NULL,'2022-09-04 05:35:57','2022-09-04 05:35:57',NULL),(780,7730,305,40720,1523,21,497,2,989.41,NULL,'2022-09-04 05:35:57','2022-09-04 05:35:57',NULL),(781,7730,306,40720,1523,3,489,1,989.41,NULL,'2022-09-04 05:38:49','2022-09-04 05:38:49',NULL),(782,7730,306,40720,1523,3,491,2,989.41,NULL,'2022-09-04 05:38:49','2022-09-04 05:38:49',NULL),(783,7730,307,40720,1523,3,487,1,907.50,NULL,'2022-09-04 05:45:29','2022-09-04 05:45:29',NULL),(784,7730,307,40720,1523,3,490,2,907.50,NULL,'2022-09-04 05:45:29','2022-09-04 05:45:29',NULL),(785,7730,308,40720,1523,21,490,1,907.50,NULL,'2022-09-04 05:46:24','2022-09-04 05:46:24',NULL);
INSERT INTO `balance_libro_details` VALUES (786,7730,308,40720,1523,21,359,2,907.50,NULL,'2022-09-04 05:46:24','2022-09-04 05:46:24',NULL),(787,7730,309,40720,1523,21,188,1,2352.65,NULL,'2022-09-04 05:48:10','2022-09-04 05:48:10',NULL),(788,7730,309,40720,1523,21,484,2,2352.65,NULL,'2022-09-04 05:48:10','2022-09-04 05:48:10',NULL),(789,7730,310,40720,1523,4,499,1,136990.95,NULL,'2022-09-04 05:52:35','2022-09-04 05:52:35',NULL),(790,7730,310,40720,1523,4,415,2,136990.95,NULL,'2022-09-04 05:52:35','2022-09-04 05:52:35',NULL),(791,7730,311,40720,1523,21,437,1,1056.92,NULL,'2022-09-04 05:59:25','2022-09-04 05:59:25',NULL),(792,7730,311,40720,1523,21,497,2,1056.92,NULL,'2022-09-04 05:59:25','2022-09-04 05:59:25',NULL),(793,7730,312,40720,1523,22,497,1,12600.00,NULL,'2022-09-04 06:07:47','2022-09-04 06:07:47',NULL),(794,7730,312,40720,1523,22,484,2,12600.00,NULL,'2022-09-04 06:07:47','2022-09-04 06:07:47',NULL),(795,7730,313,40720,1523,22,497,1,20764.00,NULL,'2022-09-04 06:08:47','2022-09-04 06:08:47',NULL),(796,7730,313,40720,1523,22,484,2,20764.00,NULL,'2022-09-04 06:08:47','2022-09-04 06:08:47',NULL),(797,7730,314,40720,1523,22,497,1,31800.00,NULL,'2022-09-04 06:09:35','2022-09-04 06:09:35',NULL),(798,7730,314,40720,1523,22,484,2,31800.00,NULL,'2022-09-04 06:09:35','2022-09-04 06:09:35',NULL),(799,7730,315,40720,1523,22,497,1,90000.00,NULL,'2022-09-04 06:10:26','2022-09-04 06:10:26',NULL),(800,7730,315,40720,1523,22,484,2,90000.00,NULL,'2022-09-04 06:10:26','2022-09-04 06:10:26',NULL),(801,7730,316,40720,1523,3,392,1,69894.90,NULL,'2022-09-04 10:51:32','2022-09-04 10:51:32',NULL),(802,7730,316,40720,1523,3,68,1,14677.93,NULL,'2022-09-04 10:51:32','2022-09-04 10:51:32',NULL),(803,7730,316,40720,1523,3,57,2,84572.83,NULL,'2022-09-04 10:51:32','2022-09-04 10:51:32',NULL),(804,7730,317,40720,1523,3,392,1,4860.00,NULL,'2022-09-04 10:51:55','2022-09-04 10:51:55',NULL),(805,7730,317,40720,1523,3,68,1,1020.60,NULL,'2022-09-04 10:51:55','2022-09-04 10:51:55',NULL),(806,7730,317,40720,1523,3,57,2,5880.60,NULL,'2022-09-04 10:51:55','2022-09-04 10:51:55',NULL),(807,7730,318,40720,1523,3,392,1,38880.00,NULL,'2022-09-04 10:52:38','2022-09-04 10:52:38',NULL),(808,7730,318,40720,1523,3,68,1,8164.80,NULL,'2022-09-04 10:52:38','2022-09-04 10:52:38',NULL),(809,7730,318,40720,1523,3,57,2,47044.80,NULL,'2022-09-04 10:52:38','2022-09-04 10:52:38',NULL),(810,7730,319,40720,1523,19,486,1,90949.06,NULL,'2022-09-05 03:06:33','2022-09-05 03:07:18','2022-09-05 03:07:18'),(811,7730,319,40720,1523,19,392,2,90949.06,NULL,'2022-09-05 03:06:33','2022-09-05 03:07:18','2022-09-05 03:07:18'),(812,7730,320,40720,1523,11,486,1,90949.06,NULL,'2022-09-05 03:07:18','2022-11-22 02:14:39','2022-11-22 02:14:39'),(813,7730,320,40720,1523,11,392,2,90949.06,NULL,'2022-09-05 03:07:18','2022-11-22 02:14:39','2022-11-22 02:14:39'),(814,7730,321,40720,1523,15,67,1,178918.99,NULL,'2022-09-05 03:38:47','2022-11-24 09:35:50','2022-11-24 09:35:50'),(815,7730,321,40720,1523,15,68,2,313796.98,NULL,'2022-09-05 03:38:47','2022-11-24 09:35:50','2022-11-24 09:35:50'),(816,7730,321,40720,1523,15,220,2,2974.92,NULL,'2022-09-05 03:38:47','2022-11-24 09:35:50','2022-11-24 09:35:50'),(817,7730,321,40720,1523,15,353,1,134877.98,NULL,'2022-09-05 03:38:47','2022-11-24 09:35:50','2022-11-24 09:35:50'),(818,7730,321,40720,1523,15,354,1,2974.92,NULL,'2022-09-05 03:38:47','2022-11-24 09:35:50','2022-11-24 09:35:50'),(819,7730,321,40720,1523,15,136,1,0.01,NULL,'2022-09-05 03:38:47','2022-11-24 09:35:50','2022-11-24 09:35:50'),(820,7730,322,40720,1523,16,156,1,1217.88,NULL,'2022-09-05 03:56:17','2022-09-05 03:56:17',NULL),(821,7730,322,40720,1523,16,226,2,1113.27,NULL,'2022-09-05 03:56:17','2022-09-05 03:56:17',NULL),(822,7730,322,40720,1523,16,327,2,104.61,NULL,'2022-09-05 03:56:17','2022-09-05 03:56:17',NULL),(823,7730,322,40720,1523,16,156,1,6322.23,NULL,'2022-09-05 03:56:17','2022-09-05 03:56:17',NULL),(824,7730,322,40720,1523,16,326,2,6322.23,NULL,'2022-09-05 03:56:17','2022-09-05 03:56:17',NULL);
INSERT INTO `balance_libro_details` VALUES (825,7730,323,40720,1523,19,155,1,50000.00,NULL,'2022-09-26 13:56:46','2023-01-24 10:24:42','2023-01-24 10:24:42'),(826,7730,323,40720,1523,19,411,2,50000.00,NULL,'2022-09-26 13:56:46','2023-01-24 10:24:42','2023-01-24 10:24:42'),(827,7730,324,40720,1520,18,135,1,0.01,NULL,'2022-09-27 01:42:33','2022-11-20 04:00:40','2022-11-20 04:00:40'),(828,7730,324,40720,1520,18,136,2,0.01,NULL,'2022-09-27 01:42:33','2022-11-20 04:00:40','2022-11-20 04:00:40'),(829,7730,325,40720,1523,18,135,1,0.01,NULL,'2022-09-27 01:43:37','2022-11-24 11:46:18','2022-11-24 11:46:18'),(830,7730,325,40720,1523,18,136,2,0.01,NULL,'2022-09-27 01:43:37','2022-11-24 11:46:18','2022-11-24 11:46:18'),(831,7730,326,40720,1521,18,135,1,62.30,NULL,'2022-09-27 01:52:13','2022-09-27 01:52:13',NULL),(832,7730,326,40720,1521,18,225,2,45.31,NULL,'2022-09-27 01:52:13','2022-09-27 01:52:13',NULL),(833,7730,326,40720,1521,18,226,2,16.99,NULL,'2022-09-27 01:52:13','2022-09-27 01:52:13',NULL),(834,7730,327,40720,3135,12,359,1,120000.00,NULL,'2022-11-20 03:15:45','2022-11-20 03:15:45',NULL),(835,7730,327,40720,3135,12,392,1,180000.00,NULL,'2022-11-20 03:15:45','2022-11-20 03:15:45',NULL),(836,7730,327,40720,3135,12,482,2,300000.00,NULL,'2022-11-20 03:15:45','2022-11-20 03:15:45',NULL),(837,7730,328,40720,1519,21,485,1,16500.00,NULL,'2022-11-20 03:45:17','2022-11-21 18:56:13','2022-11-21 18:56:13'),(838,7730,328,40720,1519,21,359,2,16500.00,NULL,'2022-11-20 03:45:17','2022-11-21 18:56:13','2022-11-21 18:56:13'),(839,7730,329,40720,1519,21,496,1,16500.00,NULL,'2022-11-20 03:47:58','2022-11-20 03:47:58',NULL),(840,7730,329,40720,1519,21,452,2,16500.00,NULL,'2022-11-20 03:47:58','2022-11-20 03:47:58',NULL),(841,7730,330,40720,1520,19,486,1,2614.21,NULL,'2022-11-20 03:59:33','2022-11-20 03:59:33',NULL),(842,7730,330,40720,1520,19,392,2,2614.21,NULL,'2022-11-20 03:59:33','2022-11-20 03:59:33',NULL),(843,7730,331,40720,1520,18,135,1,0.01,NULL,'2022-11-20 04:00:40','2022-11-20 04:00:40',NULL),(844,7730,331,40720,1520,18,136,2,0.01,NULL,'2022-11-20 04:00:40','2022-11-20 04:00:40',NULL),(845,7730,332,40720,1519,22,452,1,16500.00,NULL,'2022-11-21 18:48:12','2022-11-21 18:48:12',NULL),(846,7730,332,40720,1519,22,485,2,16500.00,NULL,'2022-11-21 18:48:12','2022-11-21 18:48:12',NULL),(847,7730,333,40720,1519,22,485,1,16500.00,NULL,'2022-11-21 18:56:13','2022-11-21 18:56:13',NULL),(848,7730,333,40720,1519,22,359,2,16500.00,NULL,'2022-11-21 18:56:13','2022-11-21 18:56:13',NULL),(849,7730,334,40720,1522,19,486,1,9797.35,NULL,'2022-11-21 23:33:17','2022-11-21 23:33:17',NULL),(850,7730,334,40720,1522,19,392,2,9797.35,NULL,'2022-11-21 23:33:17','2022-11-21 23:33:17',NULL),(851,7730,335,40720,1523,19,486,1,90949.06,NULL,'2022-11-22 02:14:39','2022-11-22 02:14:39',NULL),(852,7730,335,40720,1523,19,392,2,90949.06,NULL,'2022-11-22 02:14:39','2022-11-22 02:14:39',NULL),(853,7730,336,40720,1523,18,57,1,1513750.00,NULL,'2022-11-22 03:10:54','2022-11-22 03:10:54',NULL),(854,7730,336,40720,1523,18,485,2,1513750.00,NULL,'2022-11-22 03:10:54','2022-11-22 03:10:54',NULL),(855,7730,337,40720,1523,15,67,1,178919.00,NULL,'2022-11-24 10:43:54','2022-11-24 10:43:54',NULL),(856,7730,337,40720,1523,15,354,1,2974.92,NULL,'2022-11-24 10:43:54','2022-11-24 10:43:54',NULL),(857,7730,337,40720,1523,15,353,1,134877.98,NULL,'2022-11-24 10:43:54','2022-11-24 10:43:54',NULL),(858,7730,337,40720,1523,15,68,2,313796.98,NULL,'2022-11-24 10:43:54','2022-11-24 10:43:54',NULL),(859,7730,337,40720,1523,15,220,2,2974.92,NULL,'2022-11-24 10:43:54','2022-11-24 10:43:54',NULL),(860,7730,338,40720,1523,11,67,1,0.10,NULL,'2022-11-24 11:32:53','2022-11-24 11:36:52','2022-11-24 11:36:52'),(861,7730,338,40720,1523,11,135,2,0.10,NULL,'2022-11-24 11:32:53','2022-11-24 11:36:52','2022-11-24 11:36:52'),(862,7730,339,40720,1523,11,135,1,0.10,NULL,'2022-11-24 11:36:52','2022-11-24 11:36:52',NULL),(863,7730,339,40720,1523,11,67,2,0.10,NULL,'2022-11-24 11:36:52','2022-11-24 11:36:52',NULL);
INSERT INTO `balance_libro_details` VALUES (864,7730,340,40720,1523,4,500,1,3300.00,NULL,'2023-01-06 14:05:35','2023-01-06 14:05:35',NULL),(865,7730,340,40720,1523,4,52,2,3300.00,NULL,'2023-01-06 14:05:35','2023-01-06 14:05:35',NULL),(866,7730,341,40720,1523,23,392,1,15156.76,NULL,'2023-01-06 15:02:19','2023-01-06 17:50:54','2023-01-06 17:50:54'),(867,7730,341,40720,1523,23,501,2,15156.76,NULL,'2023-01-06 15:02:19','2023-01-06 17:50:54','2023-01-06 17:50:54'),(868,7730,342,40720,1523,23,392,1,20990.04,NULL,'2023-01-06 15:07:25','2023-01-06 17:48:13','2023-01-06 17:48:13'),(869,7730,342,40720,1523,23,486,2,20990.04,NULL,'2023-01-06 15:07:25','2023-01-06 17:48:13','2023-01-06 17:48:13'),(870,7730,343,40720,1523,23,476,1,90151.72,NULL,'2023-01-06 15:10:55','2023-01-06 17:54:34','2023-01-06 17:54:34'),(871,7730,343,40720,1523,23,88,2,90151.72,NULL,'2023-01-06 15:10:55','2023-01-06 17:54:34','2023-01-06 17:54:34'),(872,7730,344,40720,1523,23,488,1,93.48,NULL,'2023-01-06 15:24:22','2023-01-06 17:54:23','2023-01-06 17:54:23'),(873,7730,344,40720,1523,23,501,2,93.48,NULL,'2023-01-06 15:24:22','2023-01-06 17:54:23','2023-01-06 17:54:23'),(874,7730,345,40720,1523,23,135,1,4.54,NULL,'2023-01-06 15:27:15','2023-01-06 17:53:52','2023-01-06 17:53:52'),(875,7730,345,40720,1523,23,501,2,4.54,NULL,'2023-01-06 15:27:15','2023-01-06 17:53:52','2023-01-06 17:53:52'),(876,7730,346,40720,1523,23,192,1,1050.02,NULL,'2023-01-06 15:28:33','2023-01-06 17:53:37','2023-01-06 17:53:37'),(877,7730,346,40720,1523,23,501,2,1050.02,NULL,'2023-01-06 15:28:33','2023-01-06 17:53:37','2023-01-06 17:53:37'),(878,7730,347,40720,1523,23,156,1,64.23,NULL,'2023-01-06 15:30:02','2023-01-06 17:53:17','2023-01-06 17:53:17'),(879,7730,347,40720,1523,23,501,2,64.23,NULL,'2023-01-06 15:30:02','2023-01-06 17:53:17','2023-01-06 17:53:17'),(880,7730,348,40720,1523,23,487,1,93.70,NULL,'2023-01-06 15:33:00','2023-01-06 17:52:58','2023-01-06 17:52:58'),(881,7730,348,40720,1523,23,501,2,93.70,NULL,'2023-01-06 15:33:00','2023-01-06 17:52:58','2023-01-06 17:52:58'),(882,7730,349,40720,1523,23,489,1,111.78,NULL,'2023-01-06 15:34:14','2023-01-06 17:52:29','2023-01-06 17:52:29'),(883,7730,349,40720,1523,23,501,2,111.78,NULL,'2023-01-06 15:34:14','2023-01-06 17:52:29','2023-01-06 17:52:29'),(884,7730,350,40720,1523,23,476,1,1442.32,NULL,'2023-01-06 15:35:59','2023-01-06 15:35:59',NULL),(885,7730,350,40720,1523,23,96,2,1442.32,NULL,'2023-01-06 15:35:59','2023-01-06 15:35:59',NULL),(886,7730,351,40720,1523,23,486,1,20990.04,NULL,'2023-01-06 17:48:13','2023-01-06 17:51:51','2023-01-06 17:51:51'),(887,7730,351,40720,1523,23,501,2,20990.04,NULL,'2023-01-06 17:48:13','2023-01-06 17:51:51','2023-01-06 17:51:51'),(888,7730,352,40720,1523,23,392,1,15156.76,NULL,'2023-01-06 17:50:54','2023-01-06 17:50:54',NULL),(889,7730,352,40720,1523,23,476,2,15156.76,NULL,'2023-01-06 17:50:54','2023-01-06 17:50:54',NULL),(890,7730,353,40720,1523,23,486,1,20990.04,NULL,'2023-01-06 17:51:51','2023-01-06 17:51:51',NULL),(891,7730,353,40720,1523,23,476,2,20990.04,NULL,'2023-01-06 17:51:51','2023-01-06 17:51:51',NULL),(892,7730,354,40720,1523,23,489,1,111.78,NULL,'2023-01-06 17:52:29','2023-01-06 17:52:29',NULL),(893,7730,354,40720,1523,23,476,2,111.78,NULL,'2023-01-06 17:52:29','2023-01-06 17:52:29',NULL),(894,7730,355,40720,1523,23,487,1,93.70,NULL,'2023-01-06 17:52:58','2023-01-06 17:52:58',NULL),(895,7730,355,40720,1523,23,476,2,93.70,NULL,'2023-01-06 17:52:58','2023-01-06 17:52:58',NULL),(896,7730,356,40720,1523,23,156,1,64.23,NULL,'2023-01-06 17:53:17','2023-01-06 17:53:17',NULL),(897,7730,356,40720,1523,23,476,2,64.23,NULL,'2023-01-06 17:53:17','2023-01-06 17:53:17',NULL),(898,7730,357,40720,1523,23,192,1,1050.02,NULL,'2023-01-06 17:53:37','2023-01-06 17:53:37',NULL),(899,7730,357,40720,1523,23,476,2,1050.02,NULL,'2023-01-06 17:53:37','2023-01-06 17:53:37',NULL),(900,7730,358,40720,1523,23,135,1,4.54,NULL,'2023-01-06 17:53:52','2023-01-06 17:53:52',NULL),(901,7730,358,40720,1523,23,476,2,4.54,NULL,'2023-01-06 17:53:52','2023-01-06 17:53:52',NULL);
INSERT INTO `balance_libro_details` VALUES (902,7730,359,40720,1523,23,488,1,93.48,NULL,'2023-01-06 17:54:23','2023-01-06 17:54:23',NULL),(903,7730,359,40720,1523,23,476,2,93.48,NULL,'2023-01-06 17:54:23','2023-01-06 17:54:23',NULL),(904,7730,360,40720,1523,23,476,1,90151.72,NULL,'2023-01-06 17:54:34','2023-01-06 17:54:34',NULL),(905,7730,360,40720,1523,23,88,2,90151.72,NULL,'2023-01-06 17:54:34','2023-01-06 17:54:34',NULL),(906,7730,361,40720,1523,17,96,1,193262.09,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(907,7730,361,40720,1523,17,488,2,12591.95,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(908,7730,361,40720,1523,17,499,2,136990.95,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(909,7730,361,40720,1523,17,500,2,3300.00,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(910,7730,361,40720,1523,17,498,2,20000.00,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(911,7730,361,40720,1523,17,489,2,3080.01,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(912,7730,361,40720,1523,17,486,2,126738.26,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(913,7730,361,40720,1523,17,487,2,2695.20,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(914,7730,361,40720,1523,17,135,2,66.95,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(915,7730,361,40720,1523,17,188,2,2352.65,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(916,7730,361,40720,1523,17,192,2,15450.02,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(917,7730,361,40720,1523,17,156,2,8646.55,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(918,7730,361,40720,1523,17,476,2,54029.49,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(919,7730,361,40720,1523,17,91,1,192679.94,NULL,'2023-03-24 14:41:25','2023-03-24 14:45:07','2023-03-24 14:45:07'),(920,7730,362,40720,1523,17,96,1,193262.09,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(921,7730,362,40720,1523,17,488,2,12591.95,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(922,7730,362,40720,1523,17,499,2,136990.95,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(923,7730,362,40720,1523,17,500,2,3300.00,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(924,7730,362,40720,1523,17,498,2,20000.00,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(925,7730,362,40720,1523,17,489,2,3080.01,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(926,7730,362,40720,1523,17,486,2,126738.26,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(927,7730,362,40720,1523,17,487,2,2695.20,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(928,7730,362,40720,1523,17,135,2,66.95,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(929,7730,362,40720,1523,17,188,2,2352.65,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(930,7730,362,40720,1523,17,192,2,15450.02,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(931,7730,362,40720,1523,17,156,2,8646.55,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(932,7730,362,40720,1523,17,476,2,54029.49,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(933,7730,362,40720,1523,17,91,1,192679.94,NULL,'2023-03-24 14:45:07','2023-03-24 14:45:07',NULL),(934,7730,363,40720,1523,17,359,2,185409.09,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(935,7730,363,40720,1523,17,484,2,42527.88,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(936,7730,363,40720,1523,17,497,2,146034.70,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(937,7730,363,40720,1523,17,437,2,1134.89,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(938,7730,363,40720,1523,17,353,2,134877.98,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(939,7730,363,40720,1523,17,354,2,2974.92,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL);
INSERT INTO `balance_libro_details` VALUES (940,7730,363,40720,1523,17,392,2,208782.44,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(941,7730,363,40720,1523,17,495,2,16500.00,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(942,7730,363,40720,1523,17,391,2,1369909.50,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(943,7730,363,40720,1523,17,415,1,136990.95,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(944,7730,363,40720,1523,17,52,1,3300.00,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(945,7730,363,40720,1523,17,57,1,144442.42,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(946,7730,363,40720,1523,17,491,1,989.41,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(947,7730,363,40720,1523,17,74,1,3770.38,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(948,7730,363,40720,1523,17,326,1,7069.30,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(949,7730,363,40720,1523,17,327,1,367.16,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(950,7730,363,40720,1523,17,485,1,1513750.00,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(951,7730,363,40720,1523,17,87,1,400000.00,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(952,7730,363,40720,1523,17,88,1,90151.72,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(953,7730,363,40720,1523,17,91,2,192679.94,NULL,'2023-03-24 15:10:54','2023-03-24 15:10:54',NULL),(954,7730,364,40720,1525,2,96,1,1195.04,NULL,'2023-03-26 23:30:20','2023-03-27 11:15:02','2023-03-27 11:15:02'),(955,7730,364,40720,1525,2,68,1,250.96,NULL,'2023-03-26 23:30:20','2023-03-27 11:15:02','2023-03-27 11:15:02'),(956,7730,364,40720,1525,2,13,2,1446.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:15:02','2023-03-27 11:15:02'),(957,7730,365,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:55','2023-03-27 11:14:55'),(958,7730,365,40720,1525,2,218,2,6490.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:55','2023-03-27 11:14:55'),(959,7730,365,40720,1525,2,13,1,6490.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:55','2023-03-27 11:14:55'),(960,7730,366,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:48','2023-03-27 11:14:48'),(961,7730,366,40720,1525,2,218,2,1600.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:48','2023-03-27 11:14:48'),(962,7730,366,40720,1525,2,13,1,1600.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:48','2023-03-27 11:14:48'),(963,7730,367,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:39','2023-03-27 11:14:39'),(964,7730,367,40720,1525,2,218,2,7590.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:39','2023-03-27 11:14:39'),(965,7730,367,40720,1525,2,13,1,7590.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:39','2023-03-27 11:14:39'),(966,7730,368,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:31','2023-03-27 11:14:31'),(967,7730,368,40720,1525,2,218,2,7590.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:31','2023-03-27 11:14:31'),(968,7730,368,40720,1525,2,13,1,7590.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:31','2023-03-27 11:14:31'),(969,7730,369,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:21','2023-03-27 11:14:21'),(970,7730,369,40720,1525,2,218,2,1500.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:21','2023-03-27 11:14:21'),(971,7730,369,40720,1525,2,13,1,1500.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:21','2023-03-27 11:14:21'),(972,7730,370,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:13','2023-03-27 11:14:13'),(973,7730,370,40720,1525,2,218,2,19470.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:13','2023-03-27 11:14:13'),(974,7730,370,40720,1525,2,13,1,19470.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:13','2023-03-27 11:14:13'),(975,7730,371,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:04','2023-03-27 11:14:04'),(976,7730,371,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:04','2023-03-27 11:14:04');
INSERT INTO `balance_libro_details` VALUES (977,7730,371,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:14:04','2023-03-27 11:14:04'),(978,7730,372,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:57','2023-03-27 11:13:57'),(979,7730,372,40720,1525,2,218,2,7590.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:57','2023-03-27 11:13:57'),(980,7730,372,40720,1525,2,13,1,7590.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:57','2023-03-27 11:13:57'),(981,7730,373,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:48','2023-03-27 11:13:48'),(982,7730,373,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:48','2023-03-27 11:13:48'),(983,7730,373,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:48','2023-03-27 11:13:48'),(984,7730,374,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:40','2023-03-27 11:13:40'),(985,7730,374,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:40','2023-03-27 11:13:40'),(986,7730,374,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:40','2023-03-27 11:13:40'),(987,7730,375,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:32','2023-03-27 11:13:32'),(988,7730,375,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:32','2023-03-27 11:13:32'),(989,7730,375,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:32','2023-03-27 11:13:32'),(990,7730,376,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:25','2023-03-27 11:13:25'),(991,7730,376,40720,1525,2,218,2,7590.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:25','2023-03-27 11:13:25'),(992,7730,376,40720,1525,2,13,1,7590.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:25','2023-03-27 11:13:25'),(993,7730,377,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:19','2023-03-27 11:13:19'),(994,7730,377,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:19','2023-03-27 11:13:19'),(995,7730,377,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:19','2023-03-27 11:13:19'),(996,7730,378,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:10','2023-03-27 11:13:10'),(997,7730,378,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:10','2023-03-27 11:13:10'),(998,7730,378,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:10','2023-03-27 11:13:10'),(999,7730,379,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:00','2023-03-27 11:13:00'),(1000,7730,379,40720,1525,2,218,2,799.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:00','2023-03-27 11:13:00'),(1001,7730,379,40720,1525,2,13,1,799.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:13:00','2023-03-27 11:13:00'),(1002,7730,380,40720,1525,2,96,2,123.97,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:53','2023-03-27 11:12:53'),(1003,7730,380,40720,1525,2,67,2,26.03,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:53','2023-03-27 11:12:53'),(1004,7730,380,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:53','2023-03-27 11:12:53'),(1005,7730,381,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:46','2023-03-27 11:12:46'),(1006,7730,381,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:46','2023-03-27 11:12:46'),(1007,7730,381,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:46','2023-03-27 11:12:46'),(1008,7730,382,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:39','2023-03-27 11:12:39'),(1009,7730,382,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:39','2023-03-27 11:12:39'),(1010,7730,382,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:20','2023-03-27 11:12:39','2023-03-27 11:12:39'),(1011,7730,383,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:12:11','2023-03-27 11:12:11'),(1012,7730,383,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:12:11','2023-03-27 11:12:11');
INSERT INTO `balance_libro_details` VALUES (1013,7730,383,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:12:11','2023-03-27 11:12:11'),(1014,7730,384,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:12:02','2023-03-27 11:12:02'),(1015,7730,384,40720,1525,2,218,2,150.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:12:02','2023-03-27 11:12:02'),(1016,7730,384,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:12:02','2023-03-27 11:12:02'),(1017,7730,385,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:53','2023-03-27 11:10:53'),(1018,7730,385,40720,1525,2,218,2,1379.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:53','2023-03-27 11:10:53'),(1019,7730,385,40720,1525,2,13,1,1379.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:53','2023-03-27 11:10:53'),(1020,7730,386,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:44','2023-03-27 11:10:44'),(1021,7730,386,40720,1525,2,218,2,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:44','2023-03-27 11:10:44'),(1022,7730,386,40720,1525,2,13,1,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:44','2023-03-27 11:10:44'),(1023,7730,387,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:36','2023-03-27 11:10:36'),(1024,7730,387,40720,1525,2,218,2,7819.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:36','2023-03-27 11:10:36'),(1025,7730,387,40720,1525,2,13,1,7819.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:10:36','2023-03-27 11:10:36'),(1026,7730,388,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:34','2023-03-27 11:09:34'),(1027,7730,388,40720,1525,2,218,2,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:34','2023-03-27 11:09:34'),(1028,7730,388,40720,1525,2,13,1,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:34','2023-03-27 11:09:34'),(1029,7730,389,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:26','2023-03-27 11:09:26'),(1030,7730,389,40720,1525,2,218,2,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:26','2023-03-27 11:09:26'),(1031,7730,389,40720,1525,2,13,1,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:26','2023-03-27 11:09:26'),(1032,7730,390,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:19','2023-03-27 11:09:19'),(1033,7730,390,40720,1525,2,218,2,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:19','2023-03-27 11:09:19'),(1034,7730,390,40720,1525,2,13,1,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:19','2023-03-27 11:09:19'),(1035,7730,391,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:12','2023-03-27 11:09:12'),(1036,7730,391,40720,1525,2,218,2,8685.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:12','2023-03-27 11:09:12'),(1037,7730,391,40720,1525,2,13,1,8685.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:12','2023-03-27 11:09:12'),(1038,7730,392,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:03','2023-03-27 11:09:03'),(1039,7730,392,40720,1525,2,218,2,8685.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:03','2023-03-27 11:09:03'),(1040,7730,392,40720,1525,2,13,1,8685.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:09:03','2023-03-27 11:09:03'),(1041,7730,393,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:56','2023-03-27 11:08:56'),(1042,7730,393,40720,1525,2,218,2,300.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:56','2023-03-27 11:08:56'),(1043,7730,393,40720,1525,2,13,1,300.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:56','2023-03-27 11:08:56'),(1044,7730,394,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:48','2023-03-27 11:08:48'),(1045,7730,394,40720,1525,2,218,2,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:48','2023-03-27 11:08:48'),(1046,7730,394,40720,1525,2,13,1,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:48','2023-03-27 11:08:48'),(1047,7730,395,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:41','2023-03-27 11:08:41');
INSERT INTO `balance_libro_details` VALUES (1048,7730,395,40720,1525,2,218,2,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:41','2023-03-27 11:08:41'),(1049,7730,395,40720,1525,2,13,1,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:41','2023-03-27 11:08:41'),(1050,7730,396,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:33','2023-03-27 11:08:33'),(1051,7730,396,40720,1525,2,218,2,8685.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:33','2023-03-27 11:08:33'),(1052,7730,396,40720,1525,2,13,1,8685.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:33','2023-03-27 11:08:33'),(1053,7730,397,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:26','2023-03-27 11:08:26'),(1054,7730,397,40720,1525,2,218,2,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:26','2023-03-27 11:08:26'),(1055,7730,397,40720,1525,2,13,1,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:26','2023-03-27 11:08:26'),(1056,7730,398,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:18','2023-03-27 11:08:18'),(1057,7730,398,40720,1525,2,218,2,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:18','2023-03-27 11:08:18'),(1058,7730,398,40720,1525,2,13,1,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:18','2023-03-27 11:08:18'),(1059,7730,399,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:12','2023-03-27 11:08:12'),(1060,7730,399,40720,1525,2,218,2,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:12','2023-03-27 11:08:12'),(1061,7730,399,40720,1525,2,13,1,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:12','2023-03-27 11:08:12'),(1062,7730,400,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:05','2023-03-27 11:08:05'),(1063,7730,400,40720,1525,2,218,2,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:05','2023-03-27 11:08:05'),(1064,7730,400,40720,1525,2,13,1,6490.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:08:05','2023-03-27 11:08:05'),(1065,7730,401,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:58','2023-03-27 11:07:58'),(1066,7730,401,40720,1525,2,218,2,8685.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:58','2023-03-27 11:07:58'),(1067,7730,401,40720,1525,2,13,1,8685.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:58','2023-03-27 11:07:58'),(1068,7730,402,40720,1525,2,218,2,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:48','2023-03-27 11:07:48'),(1069,7730,402,40720,1525,2,218,2,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:48','2023-03-27 11:07:48'),(1070,7730,402,40720,1525,2,13,1,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:48','2023-03-27 11:07:48'),(1071,7730,403,40720,1525,2,218,1,0.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:36','2023-03-27 11:07:36'),(1072,7730,403,40720,1525,2,218,1,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:36','2023-03-27 11:07:36'),(1073,7730,403,40720,1525,2,13,2,7590.00,NULL,'2023-03-26 23:30:21','2023-03-27 11:07:36','2023-03-27 11:07:36'),(1074,7730,404,40720,1525,2,96,2,123.97,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:29','2023-03-27 11:07:29'),(1075,7730,404,40720,1525,2,67,2,26.03,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:29','2023-03-27 11:07:29'),(1076,7730,404,40720,1525,2,13,1,150.00,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:29','2023-03-27 11:07:29'),(1077,7730,405,40720,1525,2,96,2,5619.01,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:22','2023-03-27 11:07:22'),(1078,7730,405,40720,1525,2,67,2,1179.99,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:22','2023-03-27 11:07:22'),(1079,7730,405,40720,1525,2,13,1,6799.00,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:22','2023-03-27 11:07:22'),(1080,7730,406,40720,1525,2,96,2,33714.05,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:14','2023-03-27 11:07:14'),(1081,7730,406,40720,1525,2,67,2,7079.95,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:14','2023-03-27 11:07:14'),(1082,7730,406,40720,1525,2,13,1,40794.00,NULL,'2023-03-26 23:31:17','2023-03-27 11:07:14','2023-03-27 11:07:14');
INSERT INTO `balance_libro_details` VALUES (1083,7730,407,40720,1525,2,96,2,33714.05,NULL,'2023-03-26 23:31:17','2023-03-27 11:06:51','2023-03-27 11:06:51'),(1084,7730,407,40720,1525,2,67,2,7079.95,NULL,'2023-03-26 23:31:17','2023-03-27 11:06:51','2023-03-27 11:06:51'),(1085,7730,407,40720,1525,2,13,1,40794.00,NULL,'2023-03-26 23:31:17','2023-03-27 11:06:51','2023-03-27 11:06:51'),(1086,7730,408,40720,1525,2,96,1,33714.05,NULL,'2023-03-26 23:31:17','2023-03-27 11:06:31','2023-03-27 11:06:31'),(1087,7730,408,40720,1525,2,68,1,7079.95,NULL,'2023-03-26 23:31:17','2023-03-27 11:06:31','2023-03-27 11:06:31'),(1088,7730,408,40720,1525,2,13,2,40794.00,NULL,'2023-03-26 23:31:17','2023-03-27 11:06:31','2023-03-27 11:06:31'),(1089,7730,409,40720,1525,3,250,1,20000.00,NULL,'2023-03-26 23:43:09','2023-03-27 00:08:06','2023-03-27 00:08:06'),(1090,7730,409,40720,1525,3,57,2,20000.00,NULL,'2023-03-26 23:43:09','2023-03-27 00:08:06','2023-03-27 00:08:06'),(1091,7730,410,40720,1525,3,217,2,777.74,NULL,'2023-03-26 23:43:09','2023-03-26 23:56:30','2023-03-26 23:56:30'),(1092,7730,410,40720,1525,3,67,2,163.33,NULL,'2023-03-26 23:43:09','2023-03-26 23:56:30','2023-03-26 23:56:30'),(1093,7730,410,40720,1525,3,217,2,263.83,NULL,'2023-03-26 23:43:09','2023-03-26 23:56:30','2023-03-26 23:56:30'),(1094,7730,410,40720,1525,3,57,1,1204.90,NULL,'2023-03-26 23:43:09','2023-03-26 23:56:30','2023-03-26 23:56:30'),(1095,7730,411,40720,1525,3,217,1,4726.50,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:32','2023-03-27 00:07:32'),(1096,7730,411,40720,1525,3,68,1,992.57,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:32','2023-03-27 00:07:32'),(1097,7730,411,40720,1525,3,57,2,5719.07,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:32','2023-03-27 00:07:32'),(1098,7730,412,40720,1525,3,217,1,26141.60,NULL,'2023-03-26 23:43:09','2023-03-27 00:00:20','2023-03-27 00:00:20'),(1099,7730,412,40720,1525,3,68,1,5489.74,NULL,'2023-03-26 23:43:09','2023-03-27 00:00:20','2023-03-27 00:00:20'),(1100,7730,412,40720,1525,3,217,1,8733.75,NULL,'2023-03-26 23:43:09','2023-03-27 00:00:20','2023-03-27 00:00:20'),(1101,7730,412,40720,1525,3,57,2,40365.09,NULL,'2023-03-26 23:43:09','2023-03-27 00:00:20','2023-03-27 00:00:20'),(1102,7730,413,40720,1525,3,217,1,10579.50,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:15','2023-03-27 00:07:15'),(1103,7730,413,40720,1525,3,68,1,2221.70,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:15','2023-03-27 00:07:15'),(1104,7730,413,40720,1525,3,57,2,12801.20,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:15','2023-03-27 00:07:15'),(1105,7730,414,40720,1525,3,217,1,5979.00,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:01','2023-03-27 00:07:01'),(1106,7730,414,40720,1525,3,68,1,1255.59,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:01','2023-03-27 00:07:01'),(1107,7730,414,40720,1525,3,57,2,7234.59,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:01','2023-03-27 00:07:01'),(1108,7730,415,40720,1525,3,217,1,3526.50,NULL,'2023-03-26 23:43:09','2023-03-27 00:06:45','2023-03-27 00:06:45'),(1109,7730,415,40720,1525,3,68,1,740.57,NULL,'2023-03-26 23:43:09','2023-03-27 00:06:45','2023-03-27 00:06:45'),(1110,7730,415,40720,1525,3,57,2,4267.07,NULL,'2023-03-26 23:43:09','2023-03-27 00:06:45','2023-03-27 00:06:45'),(1111,7730,416,40720,1525,3,217,1,8830.18,NULL,'2023-03-26 23:43:09','2023-03-27 00:06:20','2023-03-27 00:06:20'),(1112,7730,416,40720,1525,3,68,1,1854.34,NULL,'2023-03-26 23:43:09','2023-03-27 00:06:20','2023-03-27 00:06:20'),(1113,7730,416,40720,1525,3,57,2,10684.52,NULL,'2023-03-26 23:43:09','2023-03-27 00:06:20','2023-03-27 00:06:20'),(1114,7730,417,40720,1525,3,217,1,2985.00,NULL,'2023-03-26 23:43:09','2023-03-27 00:05:01','2023-03-27 00:05:01'),(1115,7730,417,40720,1525,3,68,1,313.42,NULL,'2023-03-26 23:43:09','2023-03-27 00:05:01','2023-03-27 00:05:01'),(1116,7730,417,40720,1525,3,57,2,3298.42,NULL,'2023-03-26 23:43:09','2023-03-27 00:05:01','2023-03-27 00:05:01'),(1117,7730,418,40720,1525,3,217,1,963.00,NULL,'2023-03-26 23:43:09','2023-03-27 00:03:07','2023-03-27 00:03:07');
INSERT INTO `balance_libro_details` VALUES (1118,7730,418,40720,1525,3,68,1,208.06,NULL,'2023-03-26 23:43:09','2023-03-27 00:03:07','2023-03-27 00:03:07'),(1119,7730,418,40720,1525,3,217,1,35.03,NULL,'2023-03-26 23:43:09','2023-03-27 00:03:07','2023-03-27 00:03:07'),(1120,7730,418,40720,1525,3,57,2,1206.09,NULL,'2023-03-26 23:43:09','2023-03-27 00:03:07','2023-03-27 00:03:07'),(1121,7730,419,40720,1525,3,488,2,777.74,NULL,'2023-03-26 23:56:30','2023-03-27 00:08:53','2023-03-27 00:08:53'),(1122,7730,419,40720,1525,3,67,2,163.33,NULL,'2023-03-26 23:56:30','2023-03-27 00:08:53','2023-03-27 00:08:53'),(1123,7730,419,40720,1525,3,220,2,240.50,NULL,'2023-03-26 23:56:30','2023-03-27 00:08:53','2023-03-27 00:08:53'),(1124,7730,419,40720,1525,3,226,2,23.33,NULL,'2023-03-26 23:56:30','2023-03-27 00:08:53','2023-03-27 00:08:53'),(1125,7730,419,40720,1525,3,57,1,1204.90,NULL,'2023-03-26 23:56:30','2023-03-27 00:08:53','2023-03-27 00:08:53'),(1126,7730,420,40720,1525,3,488,1,26141.60,NULL,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(1127,7730,420,40720,1525,3,68,1,5489.74,NULL,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(1128,7730,420,40720,1525,3,220,1,6201.14,NULL,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(1129,7730,420,40720,1525,3,225,1,653.54,NULL,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(1130,7730,420,40720,1525,3,226,1,1879.07,NULL,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(1131,7730,420,40720,1525,3,57,2,40365.09,NULL,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(1132,7730,421,40720,1525,3,217,1,97.14,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(1133,7730,421,40720,1525,3,68,1,26.23,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(1134,7730,421,40720,1525,3,217,1,865.86,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(1135,7730,421,40720,1525,3,68,1,181.83,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(1136,7730,421,40720,1525,3,217,1,35.03,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(1137,7730,421,40720,1525,3,221,1,5.11,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(1138,7730,421,40720,1525,3,226,1,29.92,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(1139,7730,421,40720,1525,3,57,2,1241.12,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(1140,7730,422,40720,1525,3,489,1,97.14,NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(1141,7730,422,40720,1525,3,68,1,26.23,NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(1142,7730,422,40720,1525,3,489,1,865.86,NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(1143,7730,422,40720,1525,3,68,1,181.83,NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(1144,7730,422,40720,1525,3,221,1,5.11,NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(1145,7730,422,40720,1525,3,226,1,29.92,NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(1146,7730,422,40720,1525,3,57,2,1206.09,NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(1147,7730,423,40720,1525,3,188,1,2985.00,NULL,'2023-03-27 00:05:01','2023-03-27 00:09:30','2023-03-27 00:09:30'),(1148,7730,423,40720,1525,3,68,1,313.43,NULL,'2023-03-27 00:05:01','2023-03-27 00:09:30','2023-03-27 00:09:30'),(1149,7730,423,40720,1525,3,57,2,3298.43,NULL,'2023-03-27 00:05:01','2023-03-27 00:09:30','2023-03-27 00:09:30'),(1150,7730,424,40720,1525,3,392,1,8830.18,NULL,'2023-03-27 00:06:20','2023-03-27 00:06:20',NULL),(1151,7730,424,40720,1525,3,68,1,1854.34,NULL,'2023-03-27 00:06:20','2023-03-27 00:06:20',NULL),(1152,7730,424,40720,1525,3,57,2,10684.52,NULL,'2023-03-27 00:06:20','2023-03-27 00:06:20',NULL),(1153,7730,425,40720,1525,3,392,1,3526.50,NULL,'2023-03-27 00:06:45','2023-03-27 00:06:45',NULL);
INSERT INTO `balance_libro_details` VALUES (1154,7730,425,40720,1525,3,68,1,740.57,NULL,'2023-03-27 00:06:45','2023-03-27 00:06:45',NULL),(1155,7730,425,40720,1525,3,57,2,4267.07,NULL,'2023-03-27 00:06:45','2023-03-27 00:06:45',NULL),(1156,7730,426,40720,1525,3,392,1,5979.00,NULL,'2023-03-27 00:07:01','2023-03-27 00:07:01',NULL),(1157,7730,426,40720,1525,3,68,1,1255.59,NULL,'2023-03-27 00:07:01','2023-03-27 00:07:01',NULL),(1158,7730,426,40720,1525,3,57,2,7234.59,NULL,'2023-03-27 00:07:01','2023-03-27 00:07:01',NULL),(1159,7730,427,40720,1525,3,392,1,10579.50,NULL,'2023-03-27 00:07:15','2023-03-27 00:07:15',NULL),(1160,7730,427,40720,1525,3,68,1,2221.70,NULL,'2023-03-27 00:07:15','2023-03-27 00:07:15',NULL),(1161,7730,427,40720,1525,3,57,2,12801.20,NULL,'2023-03-27 00:07:15','2023-03-27 00:07:15',NULL),(1162,7730,428,40720,1525,3,392,1,4726.50,NULL,'2023-03-27 00:07:32','2023-03-27 00:07:32',NULL),(1163,7730,428,40720,1525,3,68,1,992.57,NULL,'2023-03-27 00:07:32','2023-03-27 00:07:32',NULL),(1164,7730,428,40720,1525,3,57,2,5719.07,NULL,'2023-03-27 00:07:32','2023-03-27 00:07:32',NULL),(1165,7730,429,40720,1525,3,250,1,20000.00,NULL,'2023-03-27 00:08:06','2023-03-27 00:08:38','2023-03-27 00:08:38'),(1166,7730,429,40720,1525,3,57,2,20000.00,NULL,'2023-03-27 00:08:06','2023-03-27 00:08:38','2023-03-27 00:08:38'),(1167,7730,430,40720,1525,3,498,1,20000.00,NULL,'2023-03-27 00:08:38','2023-03-27 00:08:38',NULL),(1168,7730,430,40720,1525,3,57,2,20000.00,NULL,'2023-03-27 00:08:38','2023-03-27 00:08:38',NULL),(1169,7730,431,40720,1525,3,488,2,777.74,NULL,'2023-03-27 00:08:53','2023-03-28 12:44:11','2023-03-28 12:44:11'),(1170,7730,431,40720,1525,3,67,2,163.33,NULL,'2023-03-27 00:08:53','2023-03-28 12:44:11','2023-03-28 12:44:11'),(1171,7730,431,40720,1525,3,220,2,240.50,NULL,'2023-03-27 00:08:53','2023-03-28 12:44:11','2023-03-28 12:44:11'),(1172,7730,431,40720,1525,3,226,2,23.33,NULL,'2023-03-27 00:08:53','2023-03-28 12:44:11','2023-03-28 12:44:11'),(1173,7730,431,40720,1525,3,57,1,1204.90,NULL,'2023-03-27 00:08:53','2023-03-28 12:44:11','2023-03-28 12:44:11'),(1174,7730,432,40720,1525,3,488,1,26141.60,NULL,'2023-03-27 00:09:11','2023-03-28 13:21:48','2023-03-28 13:21:48'),(1175,7730,432,40720,1525,3,68,1,5489.74,NULL,'2023-03-27 00:09:11','2023-03-28 13:21:48','2023-03-28 13:21:48'),(1176,7730,432,40720,1525,3,220,1,6201.14,NULL,'2023-03-27 00:09:11','2023-03-28 13:21:48','2023-03-28 13:21:48'),(1177,7730,432,40720,1525,3,225,1,653.54,NULL,'2023-03-27 00:09:11','2023-03-28 13:21:48','2023-03-28 13:21:48'),(1178,7730,432,40720,1525,3,226,1,1879.07,NULL,'2023-03-27 00:09:11','2023-03-28 13:21:48','2023-03-28 13:21:48'),(1179,7730,432,40720,1525,3,57,2,40365.09,NULL,'2023-03-27 00:09:11','2023-03-28 13:21:48','2023-03-28 13:21:48'),(1180,7730,433,40720,1525,3,188,1,2985.00,NULL,'2023-03-27 00:09:30','2023-03-27 00:09:30',NULL),(1181,7730,433,40720,1525,3,68,1,313.43,NULL,'2023-03-27 00:09:30','2023-03-27 00:09:30',NULL),(1182,7730,433,40720,1525,3,57,2,3298.43,NULL,'2023-03-27 00:09:30','2023-03-27 00:09:30',NULL),(1183,7730,434,40720,1525,3,489,1,97.14,NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(1184,7730,434,40720,1525,3,68,1,26.23,NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(1185,7730,434,40720,1525,3,489,1,865.86,NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(1186,7730,434,40720,1525,3,68,1,181.83,NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(1187,7730,434,40720,1525,3,221,1,5.11,NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(1188,7730,434,40720,1525,3,226,1,29.92,NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(1189,7730,434,40720,1525,3,57,2,1206.09,NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(1190,7730,435,40720,1525,12,359,1,185409.09,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1191,7730,435,40720,1525,12,484,1,42527.88,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL);
INSERT INTO `balance_libro_details` VALUES (1192,7730,435,40720,1525,12,497,1,146034.70,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1193,7730,435,40720,1525,12,437,1,1134.89,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1194,7730,435,40720,1525,12,353,1,134877.98,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1195,7730,435,40720,1525,12,354,1,2974.92,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1196,7730,435,40720,1525,12,391,1,1369909.50,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1197,7730,435,40720,1525,12,415,2,136990.95,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1198,7730,435,40720,1525,12,495,1,16500.00,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1199,7730,435,40720,1525,12,52,2,3300.00,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1200,7730,435,40720,1525,12,57,2,144442.42,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1201,7730,435,40720,1525,12,485,2,1513750.00,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1202,7730,435,40720,1525,12,74,2,3770.38,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1203,7730,435,40720,1525,12,326,2,7069.30,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1204,7730,435,40720,1525,12,327,2,367.16,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1205,7730,435,40720,1525,12,491,2,989.41,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1206,7730,435,40720,1525,12,369,2,400000.00,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1207,7730,435,40720,1525,12,88,2,90151.72,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1208,7730,435,40720,1525,12,383,1,192679.94,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1209,7730,435,40720,1525,12,392,1,208782.44,NULL,'2023-03-27 02:44:01','2023-03-27 02:44:01',NULL),(1210,7730,436,40720,1525,2,96,1,1195.04,NULL,'2023-03-27 14:34:42','2023-03-27 14:34:42',NULL),(1211,7730,436,40720,1525,2,68,1,250.96,NULL,'2023-03-27 14:34:42','2023-03-27 14:34:42',NULL),(1212,7730,436,40720,1525,2,13,2,1446.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:34:42',NULL),(1213,7730,437,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:42:48','2023-03-27 14:42:48'),(1214,7730,437,40720,1525,2,218,2,6490.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:42:48','2023-03-27 14:42:48'),(1215,7730,437,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:42:48','2023-03-27 14:42:48'),(1216,7730,438,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:44:21','2023-03-27 14:44:21'),(1217,7730,438,40720,1525,2,218,2,1600.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:44:21','2023-03-27 14:44:21'),(1218,7730,438,40720,1525,2,13,1,1600.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:44:21','2023-03-27 14:44:21'),(1219,7730,439,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:45:24','2023-03-27 14:45:24'),(1220,7730,439,40720,1525,2,218,2,7590.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:45:24','2023-03-27 14:45:24'),(1221,7730,439,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:45:24','2023-03-27 14:45:24'),(1222,7730,440,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:47:13','2023-03-27 14:47:13'),(1223,7730,440,40720,1525,2,218,2,7590.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:47:13','2023-03-27 14:47:13'),(1224,7730,440,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:47:13','2023-03-27 14:47:13'),(1225,7730,441,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:48:01','2023-03-27 14:48:01'),(1226,7730,441,40720,1525,2,218,2,1500.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:48:01','2023-03-27 14:48:01'),(1227,7730,441,40720,1525,2,13,1,1500.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:48:01','2023-03-27 14:48:01'),(1228,7730,442,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:49:25','2023-03-27 14:49:25'),(1229,7730,442,40720,1525,2,218,2,19470.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:49:25','2023-03-27 14:49:25');
INSERT INTO `balance_libro_details` VALUES (1230,7730,442,40720,1525,2,13,1,19470.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:49:25','2023-03-27 14:49:25'),(1231,7730,443,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:50:41','2023-03-27 14:50:41'),(1232,7730,443,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:50:41','2023-03-27 14:50:41'),(1233,7730,443,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:50:41','2023-03-27 14:50:41'),(1234,7730,444,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:52:37','2023-03-27 14:52:37'),(1235,7730,444,40720,1525,2,218,2,7590.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:52:37','2023-03-27 14:52:37'),(1236,7730,444,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:52:37','2023-03-27 14:52:37'),(1237,7730,445,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:53:54','2023-03-27 14:53:54'),(1238,7730,445,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:53:54','2023-03-27 14:53:54'),(1239,7730,445,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:42','2023-03-27 14:53:54','2023-03-27 14:53:54'),(1240,7730,446,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:55:03','2023-03-27 14:55:03'),(1241,7730,446,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:55:03','2023-03-27 14:55:03'),(1242,7730,446,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:55:03','2023-03-27 14:55:03'),(1243,7730,447,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:56:02','2023-03-27 14:56:02'),(1244,7730,447,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:56:02','2023-03-27 14:56:02'),(1245,7730,447,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:56:02','2023-03-27 14:56:02'),(1246,7730,448,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:57:22','2023-03-27 14:57:22'),(1247,7730,448,40720,1525,2,218,2,7590.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:57:22','2023-03-27 14:57:22'),(1248,7730,448,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:57:22','2023-03-27 14:57:22'),(1249,7730,449,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:58:21','2023-03-27 14:58:21'),(1250,7730,449,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:58:21','2023-03-27 14:58:21'),(1251,7730,449,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:58:21','2023-03-27 14:58:21'),(1252,7730,450,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:59:37','2023-03-27 14:59:37'),(1253,7730,450,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:59:37','2023-03-27 14:59:37'),(1254,7730,450,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 14:59:37','2023-03-27 14:59:37'),(1255,7730,451,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:00:29','2023-03-27 15:00:29'),(1256,7730,451,40720,1525,2,218,2,799.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:00:29','2023-03-27 15:00:29'),(1257,7730,451,40720,1525,2,13,1,799.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:00:29','2023-03-27 15:00:29'),(1258,7730,452,40720,1525,2,96,2,123.97,NULL,'2023-03-27 14:34:43','2023-03-27 15:06:44','2023-03-27 15:06:44'),(1259,7730,452,40720,1525,2,67,2,26.03,NULL,'2023-03-27 14:34:43','2023-03-27 15:06:44','2023-03-27 15:06:44'),(1260,7730,452,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:06:44','2023-03-27 15:06:44'),(1261,7730,453,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:02:54','2023-03-27 15:02:54'),(1262,7730,453,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:02:54','2023-03-27 15:02:54'),(1263,7730,453,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:02:54','2023-03-27 15:02:54'),(1264,7730,454,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:04:08','2023-03-27 15:04:08');
INSERT INTO `balance_libro_details` VALUES (1265,7730,454,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:04:08','2023-03-27 15:04:08'),(1266,7730,454,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:04:08','2023-03-27 15:04:08'),(1267,7730,455,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:04:42','2023-03-27 15:04:42'),(1268,7730,455,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:04:42','2023-03-27 15:04:42'),(1269,7730,455,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:04:42','2023-03-27 15:04:42'),(1270,7730,456,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:05:54','2023-03-27 15:05:54'),(1271,7730,456,40720,1525,2,218,2,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:05:54','2023-03-27 15:05:54'),(1272,7730,456,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:05:54','2023-03-27 15:05:54'),(1273,7730,457,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:08:24','2023-03-27 15:08:24'),(1274,7730,457,40720,1525,2,218,2,1379.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:08:24','2023-03-27 15:08:24'),(1275,7730,457,40720,1525,2,13,1,1379.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:08:24','2023-03-27 15:08:24'),(1276,7730,458,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:11:08','2023-03-27 15:11:08'),(1277,7730,458,40720,1525,2,218,2,7590.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:11:08','2023-03-27 15:11:08'),(1278,7730,458,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:11:08','2023-03-27 15:11:08'),(1279,7730,459,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:12:51','2023-03-27 15:12:51'),(1280,7730,459,40720,1525,2,218,2,7819.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:12:51','2023-03-27 15:12:51'),(1281,7730,459,40720,1525,2,13,1,7819.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:12:51','2023-03-27 15:12:51'),(1282,7730,460,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:14:06','2023-03-27 15:14:06'),(1283,7730,460,40720,1525,2,218,2,6490.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:14:06','2023-03-27 15:14:06'),(1284,7730,460,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:14:06','2023-03-27 15:14:06'),(1285,7730,461,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:14:41','2023-03-27 15:14:41'),(1286,7730,461,40720,1525,2,218,2,6490.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:14:41','2023-03-27 15:14:41'),(1287,7730,461,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:14:41','2023-03-27 15:14:41'),(1288,7730,462,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:15:48','2023-03-27 15:15:48'),(1289,7730,462,40720,1525,2,218,2,6490.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:15:48','2023-03-27 15:15:48'),(1290,7730,462,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:15:48','2023-03-27 15:15:48'),(1291,7730,463,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:17:10','2023-03-27 15:17:10'),(1292,7730,463,40720,1525,2,218,2,8685.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:17:10','2023-03-27 15:17:10'),(1293,7730,463,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:17:10','2023-03-27 15:17:10'),(1294,7730,464,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:18:09','2023-03-27 15:18:09'),(1295,7730,464,40720,1525,2,218,2,8685.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:18:09','2023-03-27 15:18:09'),(1296,7730,464,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:18:09','2023-03-27 15:18:09'),(1297,7730,465,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:20:22','2023-03-27 15:20:22'),(1298,7730,465,40720,1525,2,218,2,300.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:20:22','2023-03-27 15:20:22'),(1299,7730,465,40720,1525,2,13,1,300.00,NULL,'2023-03-27 14:34:43','2023-03-27 15:20:22','2023-03-27 15:20:22');
INSERT INTO `balance_libro_details` VALUES (1300,7730,466,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:21:38','2023-03-27 15:21:38'),(1301,7730,466,40720,1525,2,218,2,7590.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:21:38','2023-03-27 15:21:38'),(1302,7730,466,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:21:38','2023-03-27 15:21:38'),(1303,7730,467,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:22:48','2023-03-27 15:22:48'),(1304,7730,467,40720,1525,2,218,2,6490.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:22:48','2023-03-27 15:22:48'),(1305,7730,467,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:22:48','2023-03-27 15:22:48'),(1306,7730,468,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:23:55','2023-03-27 15:23:55'),(1307,7730,468,40720,1525,2,218,2,8685.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:23:55','2023-03-27 15:23:55'),(1308,7730,468,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:23:55','2023-03-27 15:23:55'),(1309,7730,469,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:25:16','2023-03-27 15:25:16'),(1310,7730,469,40720,1525,2,218,2,6490.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:25:16','2023-03-27 15:25:16'),(1311,7730,469,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:25:16','2023-03-27 15:25:16'),(1312,7730,470,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:26:08','2023-03-27 15:26:08'),(1313,7730,470,40720,1525,2,218,2,7590.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:26:08','2023-03-27 15:26:08'),(1314,7730,470,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:26:08','2023-03-27 15:26:08'),(1315,7730,471,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:27:27','2023-03-27 15:27:27'),(1316,7730,471,40720,1525,2,218,2,6490.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:27:27','2023-03-27 15:27:27'),(1317,7730,471,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:27:27','2023-03-27 15:27:27'),(1318,7730,472,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:28:27','2023-03-27 15:28:27'),(1319,7730,472,40720,1525,2,218,2,6490.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:28:27','2023-03-27 15:28:27'),(1320,7730,472,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:28:27','2023-03-27 15:28:27'),(1321,7730,473,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:29:31','2023-03-27 15:29:31'),(1322,7730,473,40720,1525,2,218,2,8685.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:29:31','2023-03-27 15:29:31'),(1323,7730,473,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:29:31','2023-03-27 15:29:31'),(1324,7730,474,40720,1525,2,218,2,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:30:29','2023-03-27 15:30:29'),(1325,7730,474,40720,1525,2,218,2,7590.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:30:29','2023-03-27 15:30:29'),(1326,7730,474,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:30:29','2023-03-27 15:30:29'),(1327,7730,475,40720,1525,2,218,1,0.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:31:17','2023-03-27 15:31:17'),(1328,7730,475,40720,1525,2,218,1,7590.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:31:17','2023-03-27 15:31:17'),(1329,7730,475,40720,1525,2,13,2,7590.00,NULL,'2023-03-27 14:34:44','2023-03-27 15:31:17','2023-03-27 15:31:17'),(1330,7730,476,40720,1525,2,96,2,123.97,NULL,'2023-03-27 14:36:03','2023-03-27 15:32:52','2023-03-27 15:32:52'),(1331,7730,476,40720,1525,2,67,2,26.03,NULL,'2023-03-27 14:36:03','2023-03-27 15:32:52','2023-03-27 15:32:52'),(1332,7730,476,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:36:03','2023-03-27 15:32:52','2023-03-27 15:32:52'),(1333,7730,477,40720,1525,2,96,2,5619.01,NULL,'2023-03-27 14:36:03','2023-03-27 15:33:40','2023-03-27 15:33:40'),(1334,7730,477,40720,1525,2,67,2,1179.99,NULL,'2023-03-27 14:36:03','2023-03-27 15:33:40','2023-03-27 15:33:40');
INSERT INTO `balance_libro_details` VALUES (1335,7730,477,40720,1525,2,13,1,6799.00,NULL,'2023-03-27 14:36:03','2023-03-27 15:33:40','2023-03-27 15:33:40'),(1336,7730,478,40720,1525,2,96,2,33714.05,NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(1337,7730,478,40720,1525,2,67,2,7079.95,NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(1338,7730,478,40720,1525,2,13,1,40794.00,NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(1339,7730,479,40720,1525,2,96,2,33714.05,NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(1340,7730,479,40720,1525,2,67,2,7079.95,NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(1341,7730,479,40720,1525,2,13,1,40794.00,NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(1342,7730,480,40720,1525,2,96,1,33714.05,NULL,'2023-03-27 14:36:03','2023-03-27 15:32:17','2023-03-27 15:32:17'),(1343,7730,480,40720,1525,2,68,1,7079.95,NULL,'2023-03-27 14:36:03','2023-03-27 15:32:17','2023-03-27 15:32:17'),(1344,7730,480,40720,1525,2,13,2,40794.00,NULL,'2023-03-27 14:36:03','2023-03-27 15:32:17','2023-03-27 15:32:17'),(1345,7730,481,40720,1525,2,96,2,5363.64,NULL,'2023-03-27 14:42:48','2023-03-27 14:42:48',NULL),(1346,7730,481,40720,1525,2,67,2,1126.36,NULL,'2023-03-27 14:42:48','2023-03-27 14:42:48',NULL),(1347,7730,481,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 14:42:48','2023-03-27 14:42:48',NULL),(1348,7730,482,40720,1525,2,96,2,1322.31,NULL,'2023-03-27 14:44:21','2023-03-27 14:44:21',NULL),(1349,7730,482,40720,1525,2,67,2,277.69,NULL,'2023-03-27 14:44:21','2023-03-27 14:44:21',NULL),(1350,7730,482,40720,1525,2,13,1,1600.00,NULL,'2023-03-27 14:44:21','2023-03-27 14:44:21',NULL),(1351,7730,483,40720,1525,2,96,2,6272.73,NULL,'2023-03-27 14:45:24','2023-03-27 14:45:24',NULL),(1352,7730,483,40720,1525,2,67,2,1317.27,NULL,'2023-03-27 14:45:24','2023-03-27 14:45:24',NULL),(1353,7730,483,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:45:24','2023-03-27 14:45:24',NULL),(1354,7730,484,40720,1525,2,96,2,6272.73,NULL,'2023-03-27 14:47:13','2023-03-27 14:47:13',NULL),(1355,7730,484,40720,1525,2,67,2,1317.27,NULL,'2023-03-27 14:47:13','2023-03-27 14:47:13',NULL),(1356,7730,484,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:47:13','2023-03-27 14:47:13',NULL),(1357,7730,485,40720,1525,2,96,2,1239.67,NULL,'2023-03-27 14:48:01','2023-03-27 14:48:01',NULL),(1358,7730,485,40720,1525,2,67,2,260.33,NULL,'2023-03-27 14:48:01','2023-03-27 14:48:01',NULL),(1359,7730,485,40720,1525,2,13,1,1500.00,NULL,'2023-03-27 14:48:01','2023-03-27 14:48:01',NULL),(1360,7730,486,40720,1525,2,96,2,16090.91,NULL,'2023-03-27 14:49:25','2023-03-27 14:49:25',NULL),(1361,7730,486,40720,1525,2,67,2,3379.09,NULL,'2023-03-27 14:49:25','2023-03-27 14:49:25',NULL),(1362,7730,486,40720,1525,2,13,1,19470.00,NULL,'2023-03-27 14:49:25','2023-03-27 14:49:25',NULL),(1363,7730,487,40720,1525,2,96,2,123.97,NULL,'2023-03-27 14:50:41','2023-03-27 14:50:41',NULL),(1364,7730,487,40720,1525,2,67,2,26.03,NULL,'2023-03-27 14:50:41','2023-03-27 14:50:41',NULL),(1365,7730,487,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:50:41','2023-03-27 14:50:41',NULL),(1366,7730,488,40720,1525,2,96,2,6272.73,NULL,'2023-03-27 14:52:37','2023-03-27 14:52:37',NULL),(1367,7730,488,40720,1525,2,67,2,1317.27,NULL,'2023-03-27 14:52:37','2023-03-27 14:52:37',NULL),(1368,7730,488,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:52:37','2023-03-27 14:52:37',NULL),(1369,7730,489,40720,1525,2,96,2,123.97,NULL,'2023-03-27 14:53:54','2023-03-27 14:53:54',NULL),(1370,7730,489,40720,1525,2,67,2,26.03,NULL,'2023-03-27 14:53:54','2023-03-27 14:53:54',NULL),(1371,7730,489,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:53:54','2023-03-27 14:53:54',NULL),(1372,7730,490,40720,1525,2,96,2,123.97,NULL,'2023-03-27 14:55:03','2023-03-27 14:55:03',NULL),(1373,7730,490,40720,1525,2,67,2,26.03,NULL,'2023-03-27 14:55:03','2023-03-27 14:55:03',NULL),(1374,7730,490,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:55:03','2023-03-27 14:55:03',NULL),(1375,7730,491,40720,1525,2,96,2,123.97,NULL,'2023-03-27 14:56:02','2023-03-27 14:56:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1376,7730,491,40720,1525,2,67,2,26.03,NULL,'2023-03-27 14:56:02','2023-03-27 14:56:02',NULL),(1377,7730,491,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:56:02','2023-03-27 14:56:02',NULL),(1378,7730,492,40720,1525,2,96,2,6272.73,NULL,'2023-03-27 14:57:22','2023-03-27 14:57:22',NULL),(1379,7730,492,40720,1525,2,67,2,1317.27,NULL,'2023-03-27 14:57:22','2023-03-27 14:57:22',NULL),(1380,7730,492,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 14:57:22','2023-03-27 14:57:22',NULL),(1381,7730,493,40720,1525,2,96,2,123.97,NULL,'2023-03-27 14:58:21','2023-03-27 14:58:21',NULL),(1382,7730,493,40720,1525,2,67,2,26.03,NULL,'2023-03-27 14:58:21','2023-03-27 14:58:21',NULL),(1383,7730,493,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:58:21','2023-03-27 14:58:21',NULL),(1384,7730,494,40720,1525,2,96,2,123.97,NULL,'2023-03-27 14:59:37','2023-03-27 14:59:37',NULL),(1385,7730,494,40720,1525,2,67,2,26.03,NULL,'2023-03-27 14:59:37','2023-03-27 14:59:37',NULL),(1386,7730,494,40720,1525,2,13,1,150.00,NULL,'2023-03-27 14:59:37','2023-03-27 14:59:37',NULL),(1387,7730,495,40720,1525,2,96,2,660.33,NULL,'2023-03-27 15:00:29','2023-03-27 15:00:29',NULL),(1388,7730,495,40720,1525,2,67,2,138.67,NULL,'2023-03-27 15:00:29','2023-03-27 15:00:29',NULL),(1389,7730,495,40720,1525,2,13,1,799.00,NULL,'2023-03-27 15:00:29','2023-03-27 15:00:29',NULL),(1390,7730,496,40720,1525,2,96,2,123.97,NULL,'2023-03-27 15:02:54','2023-03-27 15:02:54',NULL),(1391,7730,496,40720,1525,2,67,2,26.03,NULL,'2023-03-27 15:02:54','2023-03-27 15:02:54',NULL),(1392,7730,496,40720,1525,2,13,1,150.00,NULL,'2023-03-27 15:02:54','2023-03-27 15:02:54',NULL),(1393,7730,497,40720,1525,2,96,2,123.97,NULL,'2023-03-27 15:04:08','2023-03-27 15:04:08',NULL),(1394,7730,497,40720,1525,2,67,2,26.03,NULL,'2023-03-27 15:04:08','2023-03-27 15:04:08',NULL),(1395,7730,497,40720,1525,2,13,1,150.00,NULL,'2023-03-27 15:04:08','2023-03-27 15:04:08',NULL),(1396,7730,498,40720,1525,2,96,2,123.97,NULL,'2023-03-27 15:04:42','2023-03-27 15:04:42',NULL),(1397,7730,498,40720,1525,2,67,2,26.03,NULL,'2023-03-27 15:04:42','2023-03-27 15:04:42',NULL),(1398,7730,498,40720,1525,2,13,1,150.00,NULL,'2023-03-27 15:04:42','2023-03-27 15:04:42',NULL),(1399,7730,499,40720,1525,2,96,2,123.97,NULL,'2023-03-27 15:05:54','2023-03-27 15:05:54',NULL),(1400,7730,499,40720,1525,2,67,2,26.03,NULL,'2023-03-27 15:05:54','2023-03-27 15:05:54',NULL),(1401,7730,499,40720,1525,2,13,1,150.00,NULL,'2023-03-27 15:05:54','2023-03-27 15:05:54',NULL),(1402,7730,500,40720,1525,2,96,2,123.97,NULL,'2023-03-27 15:06:44','2023-03-27 15:06:44',NULL),(1403,7730,500,40720,1525,2,67,2,26.03,NULL,'2023-03-27 15:06:44','2023-03-27 15:06:44',NULL),(1404,7730,500,40720,1525,2,13,1,150.00,NULL,'2023-03-27 15:06:44','2023-03-27 15:06:44',NULL),(1405,7730,501,40720,1525,2,96,2,1139.67,NULL,'2023-03-27 15:08:24','2023-03-27 15:08:24',NULL),(1406,7730,501,40720,1525,2,67,2,239.33,NULL,'2023-03-27 15:08:24','2023-03-27 15:08:24',NULL),(1407,7730,501,40720,1525,2,13,1,1379.00,NULL,'2023-03-27 15:08:24','2023-03-27 15:08:24',NULL),(1408,7730,502,40720,1525,2,96,2,6272.73,NULL,'2023-03-27 15:11:08','2023-03-27 15:11:08',NULL),(1409,7730,502,40720,1525,2,67,2,1317.27,NULL,'2023-03-27 15:11:08','2023-03-27 15:11:08',NULL),(1410,7730,502,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 15:11:08','2023-03-27 15:11:08',NULL),(1411,7730,503,40720,1525,2,96,2,6461.98,NULL,'2023-03-27 15:12:51','2023-03-27 15:12:51',NULL),(1412,7730,503,40720,1525,2,67,2,1357.02,NULL,'2023-03-27 15:12:51','2023-03-27 15:12:51',NULL),(1413,7730,503,40720,1525,2,13,1,7819.00,NULL,'2023-03-27 15:12:51','2023-03-27 15:12:51',NULL),(1414,7730,504,40720,1525,2,96,2,5363.64,NULL,'2023-03-27 15:14:06','2023-03-27 15:14:06',NULL),(1415,7730,504,40720,1525,2,67,2,1126.36,NULL,'2023-03-27 15:14:06','2023-03-27 15:14:06',NULL),(1416,7730,504,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 15:14:06','2023-03-27 15:14:06',NULL),(1417,7730,505,40720,1525,2,96,2,5363.64,NULL,'2023-03-27 15:14:41','2023-03-27 15:14:41',NULL);
INSERT INTO `balance_libro_details` VALUES (1418,7730,505,40720,1525,2,67,2,1126.36,NULL,'2023-03-27 15:14:41','2023-03-27 15:14:41',NULL),(1419,7730,505,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 15:14:41','2023-03-27 15:14:41',NULL),(1420,7730,506,40720,1525,2,96,2,5363.64,NULL,'2023-03-27 15:15:48','2023-03-27 15:15:48',NULL),(1421,7730,506,40720,1525,2,67,2,1126.36,NULL,'2023-03-27 15:15:48','2023-03-27 15:15:48',NULL),(1422,7730,506,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 15:15:48','2023-03-27 15:15:48',NULL),(1423,7730,507,40720,1525,2,96,2,7177.69,NULL,'2023-03-27 15:17:10','2023-03-27 15:17:10',NULL),(1424,7730,507,40720,1525,2,67,2,1507.31,NULL,'2023-03-27 15:17:10','2023-03-27 15:17:10',NULL),(1425,7730,507,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 15:17:10','2023-03-27 15:17:10',NULL),(1426,7730,508,40720,1525,2,96,2,7177.69,NULL,'2023-03-27 15:18:09','2023-03-27 15:18:52','2023-03-27 15:18:52'),(1427,7730,508,40720,1525,2,67,2,1507.31,NULL,'2023-03-27 15:18:09','2023-03-27 15:18:52','2023-03-27 15:18:52'),(1428,7730,508,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 15:18:09','2023-03-27 15:18:52','2023-03-27 15:18:52'),(1429,7730,509,40720,1525,2,96,2,7177.69,NULL,'2023-03-27 15:18:52','2023-03-27 15:19:25','2023-03-27 15:19:25'),(1430,7730,509,40720,1525,2,67,2,1507.31,NULL,'2023-03-27 15:18:52','2023-03-27 15:19:25','2023-03-27 15:19:25'),(1431,7730,509,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 15:18:52','2023-03-27 15:19:25','2023-03-27 15:19:25'),(1432,7730,510,40720,1525,2,96,2,7177.69,NULL,'2023-03-27 15:19:25','2023-03-27 15:19:25',NULL),(1433,7730,510,40720,1525,2,67,2,1507.31,NULL,'2023-03-27 15:19:25','2023-03-27 15:19:25',NULL),(1434,7730,510,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 15:19:25','2023-03-27 15:19:25',NULL),(1435,7730,511,40720,1525,2,96,2,247.93,NULL,'2023-03-27 15:20:22','2023-03-27 15:20:22',NULL),(1436,7730,511,40720,1525,2,67,2,52.07,NULL,'2023-03-27 15:20:22','2023-03-27 15:20:22',NULL),(1437,7730,511,40720,1525,2,13,1,300.00,NULL,'2023-03-27 15:20:22','2023-03-27 15:20:22',NULL),(1438,7730,512,40720,1525,2,96,2,6272.73,NULL,'2023-03-27 15:21:38','2023-03-27 15:21:38',NULL),(1439,7730,512,40720,1525,2,67,2,1317.27,NULL,'2023-03-27 15:21:38','2023-03-27 15:21:38',NULL),(1440,7730,512,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 15:21:38','2023-03-27 15:21:38',NULL),(1441,7730,513,40720,1525,2,96,2,5363.64,NULL,'2023-03-27 15:22:48','2023-03-27 15:22:48',NULL),(1442,7730,513,40720,1525,2,67,2,1126.36,NULL,'2023-03-27 15:22:48','2023-03-27 15:22:48',NULL),(1443,7730,513,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 15:22:48','2023-03-27 15:22:48',NULL),(1444,7730,514,40720,1525,2,96,2,7177.69,NULL,'2023-03-27 15:23:55','2023-03-27 15:23:55',NULL),(1445,7730,514,40720,1525,2,67,2,1507.31,NULL,'2023-03-27 15:23:55','2023-03-27 15:23:55',NULL),(1446,7730,514,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 15:23:55','2023-03-27 15:23:55',NULL),(1447,7730,515,40720,1525,2,96,2,5363.64,NULL,'2023-03-27 15:25:16','2023-03-27 15:25:16',NULL),(1448,7730,515,40720,1525,2,67,2,1126.36,NULL,'2023-03-27 15:25:16','2023-03-27 15:25:16',NULL),(1449,7730,515,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 15:25:16','2023-03-27 15:25:16',NULL),(1450,7730,516,40720,1525,2,96,2,6272.73,NULL,'2023-03-27 15:26:08','2023-03-27 15:26:08',NULL),(1451,7730,516,40720,1525,2,67,2,1317.27,NULL,'2023-03-27 15:26:08','2023-03-27 15:26:08',NULL),(1452,7730,516,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 15:26:08','2023-03-27 15:26:08',NULL),(1453,7730,517,40720,1525,2,96,2,5363.64,NULL,'2023-03-27 15:27:27','2023-03-27 15:27:27',NULL),(1454,7730,517,40720,1525,2,67,2,1126.36,NULL,'2023-03-27 15:27:27','2023-03-27 15:27:27',NULL),(1455,7730,517,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 15:27:27','2023-03-27 15:27:27',NULL),(1456,7730,518,40720,1525,2,96,2,5363.64,NULL,'2023-03-27 15:28:27','2023-03-27 15:28:27',NULL),(1457,7730,518,40720,1525,2,67,2,1126.36,NULL,'2023-03-27 15:28:27','2023-03-27 15:28:27',NULL);
INSERT INTO `balance_libro_details` VALUES (1458,7730,518,40720,1525,2,13,1,6490.00,NULL,'2023-03-27 15:28:27','2023-03-27 15:28:27',NULL),(1459,7730,519,40720,1525,2,96,2,7177.69,NULL,'2023-03-27 15:29:31','2023-03-27 15:29:31',NULL),(1460,7730,519,40720,1525,2,67,2,1507.31,NULL,'2023-03-27 15:29:31','2023-03-27 15:29:31',NULL),(1461,7730,519,40720,1525,2,13,1,8685.00,NULL,'2023-03-27 15:29:31','2023-03-27 15:29:31',NULL),(1462,7730,520,40720,1525,2,96,2,6272.73,NULL,'2023-03-27 15:30:29','2023-03-27 15:30:29',NULL),(1463,7730,520,40720,1525,2,67,2,1317.27,NULL,'2023-03-27 15:30:29','2023-03-27 15:30:29',NULL),(1464,7730,520,40720,1525,2,13,1,7590.00,NULL,'2023-03-27 15:30:29','2023-03-27 15:30:29',NULL),(1465,7730,521,40720,1525,2,96,1,6272.73,NULL,'2023-03-27 15:31:17','2023-03-27 15:31:17',NULL),(1466,7730,521,40720,1525,2,68,1,1317.27,NULL,'2023-03-27 15:31:17','2023-03-27 15:31:17',NULL),(1467,7730,521,40720,1525,2,13,2,7590.00,NULL,'2023-03-27 15:31:17','2023-03-27 15:31:17',NULL),(1468,7730,522,40720,1525,2,96,1,33714.05,NULL,'2023-03-27 15:32:17','2023-03-27 15:32:17',NULL),(1469,7730,522,40720,1525,2,68,1,7079.95,NULL,'2023-03-27 15:32:17','2023-03-27 15:32:17',NULL),(1470,7730,522,40720,1525,2,13,2,40794.00,NULL,'2023-03-27 15:32:17','2023-03-27 15:32:17',NULL),(1471,7730,523,40720,1525,2,96,2,123.97,NULL,'2023-03-27 15:32:52','2023-03-27 15:32:52',NULL),(1472,7730,523,40720,1525,2,67,2,26.03,NULL,'2023-03-27 15:32:52','2023-03-27 15:32:52',NULL),(1473,7730,523,40720,1525,2,13,1,150.00,NULL,'2023-03-27 15:32:52','2023-03-27 15:32:52',NULL),(1474,7730,524,40720,1525,2,96,2,5619.01,NULL,'2023-03-27 15:33:40','2023-03-27 15:33:40',NULL),(1475,7730,524,40720,1525,2,67,2,1179.99,NULL,'2023-03-27 15:33:40','2023-03-27 15:33:40',NULL),(1476,7730,524,40720,1525,2,13,1,6799.00,NULL,'2023-03-27 15:33:40','2023-03-27 15:33:40',NULL),(1477,7730,525,40720,1525,20,13,2,150.00,NULL,'2023-03-27 15:56:08','2023-03-27 15:56:08',NULL),(1478,7730,525,40720,1525,20,484,1,150.00,NULL,'2023-03-27 15:56:08','2023-03-27 15:56:08',NULL),(1479,7730,526,40720,1525,20,13,2,949.00,NULL,'2023-03-27 15:58:45','2023-03-27 15:58:45',NULL),(1480,7730,526,40720,1525,20,484,1,949.00,NULL,'2023-03-27 15:58:45','2023-03-27 15:58:45',NULL),(1481,7730,527,40720,1525,20,13,2,8090.00,NULL,'2023-03-27 16:00:34','2023-03-27 16:00:34',NULL),(1482,7730,527,40720,1525,20,484,1,8090.00,NULL,'2023-03-27 16:00:34','2023-03-27 16:00:34',NULL),(1483,7730,528,40720,1525,20,13,2,7590.00,NULL,'2023-03-27 16:02:07','2023-03-27 16:02:07',NULL),(1484,7730,528,40720,1525,20,484,1,7590.00,NULL,'2023-03-27 16:02:07','2023-03-27 16:02:07',NULL),(1485,7730,529,40720,1525,20,13,2,9090.00,NULL,'2023-03-27 16:03:07','2023-03-27 16:03:07',NULL),(1486,7730,529,40720,1525,20,484,1,9090.00,NULL,'2023-03-27 16:03:07','2023-03-27 16:03:07',NULL),(1487,7730,530,40720,1525,20,13,2,19470.00,NULL,'2023-03-27 16:03:59','2023-03-27 16:03:59',NULL),(1488,7730,530,40720,1525,20,484,1,19470.00,NULL,'2023-03-27 16:03:59','2023-03-27 16:03:59',NULL),(1489,7730,531,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:05:00','2023-03-27 16:05:00',NULL),(1490,7730,531,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:05:00','2023-03-27 16:05:00',NULL),(1491,7730,532,40720,1525,20,13,2,7590.00,NULL,'2023-03-27 16:06:03','2023-03-27 16:06:03',NULL),(1492,7730,532,40720,1525,20,484,1,7590.00,NULL,'2023-03-27 16:06:03','2023-03-27 16:06:03',NULL),(1493,7730,533,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:06:54','2023-03-27 16:06:54',NULL),(1494,7730,533,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:06:54','2023-03-27 16:06:54',NULL),(1495,7730,534,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:07:35','2023-03-27 16:07:35',NULL),(1496,7730,534,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:07:35','2023-03-27 16:07:35',NULL),(1497,7730,535,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:08:33','2023-03-27 16:08:33',NULL),(1498,7730,535,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:08:33','2023-03-27 16:08:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1499,7730,536,40720,1525,20,13,2,7590.00,NULL,'2023-03-27 16:09:12','2023-03-27 16:09:12',NULL),(1500,7730,536,40720,1525,20,484,1,7590.00,NULL,'2023-03-27 16:09:12','2023-03-27 16:09:12',NULL),(1501,7730,537,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:09:56','2023-03-27 16:09:56',NULL),(1502,7730,537,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:09:56','2023-03-27 16:09:56',NULL),(1503,7730,538,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:11:16','2023-03-27 16:11:16',NULL),(1504,7730,538,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:11:16','2023-03-27 16:11:16',NULL),(1505,7730,539,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:11:52','2023-03-27 16:11:52',NULL),(1506,7730,539,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:11:52','2023-03-27 16:11:52',NULL),(1507,7730,540,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:12:34','2023-03-27 16:12:34',NULL),(1508,7730,540,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:12:34','2023-03-27 16:12:34',NULL),(1509,7730,541,40720,1525,20,13,2,1379.00,NULL,'2023-03-27 16:13:20','2023-03-27 16:13:20',NULL),(1510,7730,541,40720,1525,20,484,1,1379.00,NULL,'2023-03-27 16:13:20','2023-03-27 16:13:20',NULL),(1511,7730,542,40720,1525,20,13,2,7590.00,NULL,'2023-03-27 16:14:22','2023-03-27 16:14:22',NULL),(1512,7730,542,40720,1525,20,484,1,7590.00,NULL,'2023-03-27 16:14:22','2023-03-27 16:14:22',NULL),(1513,7730,543,40720,1525,20,13,2,7819.00,NULL,'2023-03-27 16:16:08','2023-03-27 16:16:08',NULL),(1514,7730,543,40720,1525,20,484,1,7819.00,NULL,'2023-03-27 16:16:08','2023-03-27 16:16:08',NULL),(1515,7730,544,40720,1525,20,13,2,6490.00,NULL,'2023-03-27 16:17:14','2023-03-27 16:17:14',NULL),(1516,7730,544,40720,1525,20,484,1,6490.00,NULL,'2023-03-27 16:17:14','2023-03-27 16:17:14',NULL),(1517,7730,545,40720,1525,20,13,2,6490.00,NULL,'2023-03-27 16:18:43','2023-03-27 16:18:43',NULL),(1518,7730,545,40720,1525,20,484,1,6490.00,NULL,'2023-03-27 16:18:43','2023-03-27 16:18:43',NULL),(1519,7730,546,40720,1525,20,13,2,6490.00,NULL,'2023-03-27 16:19:37','2023-03-27 16:19:37',NULL),(1520,7730,546,40720,1525,20,484,1,6490.00,NULL,'2023-03-27 16:19:37','2023-03-27 16:19:37',NULL),(1521,7730,547,40720,1525,20,13,2,8685.00,NULL,'2023-03-27 16:20:30','2023-03-27 16:20:30',NULL),(1522,7730,547,40720,1525,20,484,1,8685.00,NULL,'2023-03-27 16:20:30','2023-03-27 16:20:30',NULL),(1523,7730,548,40720,1525,20,13,2,8685.00,NULL,'2023-03-27 16:21:24','2023-03-27 16:21:24',NULL),(1524,7730,548,40720,1525,20,484,1,8685.00,NULL,'2023-03-27 16:21:24','2023-03-27 16:21:24',NULL),(1525,7730,549,40720,1525,20,13,2,300.00,NULL,'2023-03-27 16:30:20','2023-03-27 16:30:20',NULL),(1526,7730,549,40720,1525,20,484,1,300.00,NULL,'2023-03-27 16:30:20','2023-03-27 16:30:20',NULL),(1527,7730,550,40720,1525,20,13,2,7590.00,NULL,'2023-03-27 16:31:13','2023-03-27 16:31:13',NULL),(1528,7730,550,40720,1525,20,484,1,7590.00,NULL,'2023-03-27 16:31:13','2023-03-27 16:31:13',NULL),(1529,7730,551,40720,1525,20,13,2,6490.00,NULL,'2023-03-27 16:32:13','2023-03-27 16:32:13',NULL),(1530,7730,551,40720,1525,20,484,1,6490.00,NULL,'2023-03-27 16:32:13','2023-03-27 16:32:13',NULL),(1531,7730,552,40720,1525,20,13,2,8685.00,NULL,'2023-03-27 16:33:00','2023-03-27 16:33:00',NULL),(1532,7730,552,40720,1525,20,484,1,8685.00,NULL,'2023-03-27 16:33:00','2023-03-27 16:33:00',NULL),(1533,7730,553,40720,1525,20,13,2,6490.00,NULL,'2023-03-27 16:33:48','2023-03-27 16:33:48',NULL),(1534,7730,553,40720,1525,20,484,1,6490.00,NULL,'2023-03-27 16:33:48','2023-03-27 16:33:48',NULL),(1535,7730,554,40720,1525,20,13,2,6490.00,NULL,'2023-03-27 16:34:55','2023-03-27 16:34:55',NULL),(1536,7730,554,40720,1525,20,484,1,6490.00,NULL,'2023-03-27 16:34:55','2023-03-27 16:34:55',NULL),(1537,7730,555,40720,1525,20,13,2,6490.00,NULL,'2023-03-27 16:38:54','2023-03-27 16:38:54',NULL),(1538,7730,555,40720,1525,20,484,1,6490.00,NULL,'2023-03-27 16:38:54','2023-03-27 16:38:54',NULL),(1539,7730,556,40720,1525,20,13,2,8685.00,NULL,'2023-03-27 16:39:47','2023-03-27 16:39:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1540,7730,556,40720,1525,20,484,1,8685.00,NULL,'2023-03-27 16:39:47','2023-03-27 16:39:47',NULL),(1541,7730,557,40720,1525,20,13,2,7590.00,NULL,'2023-03-27 16:40:40','2023-03-27 16:40:40',NULL),(1542,7730,557,40720,1525,20,484,1,7590.00,NULL,'2023-03-27 16:40:40','2023-03-27 16:40:40',NULL),(1543,7730,558,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:43:44','2023-03-27 16:43:44',NULL),(1544,7730,558,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:43:44','2023-03-27 16:43:44',NULL),(1545,7730,559,40720,1525,20,13,2,6799.00,NULL,'2023-03-27 16:45:38','2023-03-27 16:45:38',NULL),(1546,7730,559,40720,1525,20,484,1,6799.00,NULL,'2023-03-27 16:45:38','2023-03-27 16:45:38',NULL),(1547,7730,560,40720,1525,20,13,2,40794.00,NULL,'2023-03-27 16:47:49','2023-03-27 16:47:49',NULL),(1548,7730,560,40720,1525,20,497,1,40794.00,NULL,'2023-03-27 16:47:49','2023-03-27 16:47:49',NULL),(1549,7730,561,40720,1525,20,13,2,150.00,NULL,'2023-03-27 16:54:51','2023-03-27 16:54:51',NULL),(1550,7730,561,40720,1525,20,484,1,150.00,NULL,'2023-03-27 16:54:51','2023-03-27 16:54:51',NULL),(1551,7730,562,40720,1525,3,13,1,1446.00,NULL,'2023-03-27 17:50:11','2023-03-27 18:33:14','2023-03-27 18:33:14'),(1552,7730,562,40720,1525,3,484,2,1446.00,NULL,'2023-03-27 17:50:11','2023-03-27 18:33:14','2023-03-27 18:33:14'),(1553,7730,563,40720,1525,21,57,1,36966.12,NULL,'2023-03-27 18:30:31','2023-03-28 17:17:32','2023-03-28 17:17:32'),(1554,7730,563,40720,1525,21,497,2,36966.12,NULL,'2023-03-27 18:30:31','2023-03-28 17:17:32','2023-03-28 17:17:32'),(1555,7730,564,40720,1525,3,13,1,1446.00,NULL,'2023-03-27 18:33:14','2023-03-27 18:33:14',NULL),(1556,7730,564,40720,1525,3,497,2,1446.00,NULL,'2023-03-27 18:33:14','2023-03-27 18:33:14',NULL),(1557,7730,565,40720,1525,21,57,1,20000.00,NULL,'2023-03-27 18:53:24','2023-03-28 12:39:33','2023-03-28 12:39:33'),(1558,7730,565,40720,1525,21,497,2,20000.00,NULL,'2023-03-27 18:53:24','2023-03-28 12:39:33','2023-03-28 12:39:33'),(1559,7730,566,40720,1525,21,57,1,137498.23,NULL,'2023-03-27 18:58:21','2023-03-27 18:58:21',NULL),(1560,7730,566,40720,1525,21,497,2,137498.23,NULL,'2023-03-27 18:58:21','2023-03-27 18:58:21',NULL),(1561,7730,567,40720,1525,22,497,1,190.94,NULL,'2023-03-27 19:01:38','2023-03-27 19:01:38',NULL),(1562,7730,567,40720,1525,22,359,2,190.94,NULL,'2023-03-27 19:01:38','2023-03-27 19:01:38',NULL),(1563,7730,568,40720,1525,22,497,1,60000.00,NULL,'2023-03-27 19:02:38','2023-03-27 19:02:38',NULL),(1564,7730,568,40720,1525,22,484,2,60000.00,NULL,'2023-03-27 19:02:38','2023-03-27 19:02:38',NULL),(1565,7730,569,40720,1525,5,437,1,1864.50,NULL,'2023-03-27 19:07:26','2023-03-29 14:18:21','2023-03-29 14:18:21'),(1566,7730,569,40720,1525,5,497,2,1864.50,NULL,'2023-03-27 19:07:26','2023-03-29 14:18:21','2023-03-29 14:18:21'),(1567,7730,570,40720,1523,15,67,1,178918.99,NULL,'2023-03-27 19:09:10','2023-03-27 19:10:58','2023-03-27 19:10:58'),(1568,7730,570,40720,1523,15,68,2,313796.98,NULL,'2023-03-27 19:09:10','2023-03-27 19:10:58','2023-03-27 19:10:58'),(1569,7730,570,40720,1523,15,220,2,2974.92,NULL,'2023-03-27 19:09:10','2023-03-27 19:10:58','2023-03-27 19:10:58'),(1570,7730,570,40720,1523,15,353,1,134877.99,NULL,'2023-03-27 19:09:10','2023-03-27 19:10:58','2023-03-27 19:10:58'),(1571,7730,570,40720,1523,15,354,1,2974.92,NULL,'2023-03-27 19:09:10','2023-03-27 19:10:58','2023-03-27 19:10:58'),(1572,7730,571,40720,1523,15,67,1,178918.99,NULL,'2023-03-27 19:13:03','2023-03-27 19:59:29','2023-03-27 19:59:29'),(1573,7730,571,40720,1523,15,68,2,313796.98,NULL,'2023-03-27 19:13:03','2023-03-27 19:59:29','2023-03-27 19:59:29'),(1574,7730,571,40720,1523,15,220,2,2974.92,NULL,'2023-03-27 19:13:03','2023-03-27 19:59:29','2023-03-27 19:59:29'),(1575,7730,571,40720,1523,15,353,1,134877.98,NULL,'2023-03-27 19:13:03','2023-03-27 19:59:29','2023-03-27 19:59:29'),(1576,7730,571,40720,1523,15,354,1,2974.92,NULL,'2023-03-27 19:13:03','2023-03-27 19:59:29','2023-03-27 19:59:29');
INSERT INTO `balance_libro_details` VALUES (1577,7730,571,40720,1523,15,136,1,0.01,NULL,'2023-03-27 19:13:03','2023-03-27 19:59:29','2023-03-27 19:59:29'),(1578,7730,572,40720,1525,15,67,1,47098.17,NULL,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(1579,7730,572,40720,1525,15,68,2,21724.15,NULL,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(1580,7730,572,40720,1525,15,353,2,134877.99,NULL,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(1581,7730,572,40720,1525,15,354,2,2974.92,NULL,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(1582,7730,572,40720,1525,15,220,2,5960.64,NULL,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(1583,7730,572,40720,1525,15,353,1,109503.98,NULL,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(1584,7730,572,40720,1525,15,354,1,8935.56,NULL,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(1585,7730,572,40720,1525,15,136,2,0.01,NULL,'2023-03-27 19:27:14','2023-03-27 19:33:31','2023-03-27 19:33:31'),(1586,7730,573,40720,1525,15,67,1,47098.17,NULL,'2023-03-27 19:34:18','2023-03-27 19:36:52','2023-03-27 19:36:52'),(1587,7730,573,40720,1525,15,68,2,21724.15,NULL,'2023-03-27 19:34:18','2023-03-27 19:36:52','2023-03-27 19:36:52'),(1588,7730,573,40720,1525,15,353,2,134877.99,NULL,'2023-03-27 19:34:18','2023-03-27 19:36:52','2023-03-27 19:36:52'),(1589,7730,573,40720,1525,15,354,2,2974.92,NULL,'2023-03-27 19:34:18','2023-03-27 19:36:52','2023-03-27 19:36:52'),(1590,7730,573,40720,1525,15,220,2,5960.64,NULL,'2023-03-27 19:34:18','2023-03-27 19:36:52','2023-03-27 19:36:52'),(1591,7730,573,40720,1525,15,136,1,118439.53,NULL,'2023-03-27 19:34:18','2023-03-27 19:36:52','2023-03-27 19:36:52'),(1592,7730,574,40720,1525,15,67,1,47098.17,NULL,'2023-03-27 21:03:03','2023-03-27 21:14:20','2023-03-27 21:14:20'),(1593,7730,574,40720,1525,15,68,2,21724.15,NULL,'2023-03-27 21:03:03','2023-03-27 21:14:20','2023-03-27 21:14:20'),(1594,7730,574,40720,1525,15,353,2,134877.99,NULL,'2023-03-27 21:03:03','2023-03-27 21:14:20','2023-03-27 21:14:20'),(1595,7730,574,40720,1525,15,354,2,2974.92,NULL,'2023-03-27 21:03:03','2023-03-27 21:14:20','2023-03-27 21:14:20'),(1596,7730,574,40720,1525,15,220,2,5960.64,NULL,'2023-03-27 21:03:03','2023-03-27 21:14:20','2023-03-27 21:14:20'),(1597,7730,574,40720,1525,15,353,1,109503.97,NULL,'2023-03-27 21:03:03','2023-03-27 21:14:20','2023-03-27 21:14:20'),(1598,7730,574,40720,1525,15,354,1,8935.56,NULL,'2023-03-27 21:03:03','2023-03-27 21:14:20','2023-03-27 21:14:20'),(1599,7730,575,40720,1525,15,67,1,47098.16,NULL,'2023-03-27 21:19:55','2023-03-27 21:42:23','2023-03-27 21:42:23'),(1600,7730,575,40720,1525,15,68,2,21724.16,NULL,'2023-03-27 21:19:55','2023-03-27 21:42:23','2023-03-27 21:42:23'),(1601,7730,575,40720,1525,15,353,2,134877.98,NULL,'2023-03-27 21:19:55','2023-03-27 21:42:23','2023-03-27 21:42:23'),(1602,7730,575,40720,1525,15,353,1,109503.98,NULL,'2023-03-27 21:19:55','2023-03-27 21:42:23','2023-03-27 21:42:23'),(1603,7730,575,40720,1525,15,354,2,2974.92,NULL,'2023-03-27 21:19:55','2023-03-27 21:42:23','2023-03-27 21:42:23'),(1604,7730,575,40720,1525,15,220,2,5960.64,NULL,'2023-03-27 21:19:55','2023-03-27 21:42:23','2023-03-27 21:42:23'),(1605,7730,575,40720,1525,15,354,1,8935.56,NULL,'2023-03-27 21:19:55','2023-03-27 21:42:23','2023-03-27 21:42:23'),(1606,7730,576,40720,1525,15,67,1,47098.17,NULL,'2023-03-27 21:20:23','2023-03-27 21:22:05','2023-03-27 21:22:05'),(1607,7730,576,40720,1525,15,68,2,21724.15,NULL,'2023-03-27 21:20:23','2023-03-27 21:22:05','2023-03-27 21:22:05'),(1608,7730,576,40720,1525,15,353,2,134877.99,NULL,'2023-03-27 21:20:23','2023-03-27 21:22:05','2023-03-27 21:22:05'),(1609,7730,576,40720,1525,15,354,2,2974.92,NULL,'2023-03-27 21:20:23','2023-03-27 21:22:05','2023-03-27 21:22:05'),(1610,7730,576,40720,1525,15,220,2,5960.64,NULL,'2023-03-27 21:20:23','2023-03-27 21:22:05','2023-03-27 21:22:05');
INSERT INTO `balance_libro_details` VALUES (1611,7730,576,40720,1525,15,353,1,109503.97,NULL,'2023-03-27 21:20:23','2023-03-27 21:22:05','2023-03-27 21:22:05'),(1612,7730,576,40720,1525,15,354,1,8935.56,NULL,'2023-03-27 21:20:23','2023-03-27 21:22:05','2023-03-27 21:22:05'),(1613,7730,577,40720,1525,15,67,1,47098.17,NULL,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(1614,7730,577,40720,1525,15,68,2,21724.15,NULL,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(1615,7730,577,40720,1525,15,353,2,134877.99,NULL,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(1616,7730,577,40720,1525,15,354,2,2974.92,NULL,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(1617,7730,577,40720,1525,15,220,2,5960.64,NULL,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(1618,7730,577,40720,1525,15,353,1,109503.98,NULL,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(1619,7730,577,40720,1525,15,354,1,8935.56,NULL,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(1620,7730,577,40720,1525,15,136,2,0.01,NULL,'2023-03-27 21:43:54','2023-03-27 22:06:43','2023-03-27 22:06:43'),(1621,7730,578,40720,1525,15,67,1,47098.16,NULL,'2023-03-27 22:10:30','2023-03-27 22:10:30',NULL),(1622,7730,578,40720,1525,15,68,2,21724.16,NULL,'2023-03-27 22:10:30','2023-03-27 22:10:30',NULL),(1623,7730,578,40720,1525,15,353,2,134877.98,NULL,'2023-03-27 22:10:30','2023-03-27 22:10:30',NULL),(1624,7730,578,40720,1525,15,354,2,2974.92,NULL,'2023-03-27 22:10:30','2023-03-27 22:10:30',NULL),(1625,7730,578,40720,1525,15,220,2,5960.64,NULL,'2023-03-27 22:10:30','2023-03-27 22:10:30',NULL),(1626,7730,578,40720,1525,15,353,1,109503.98,NULL,'2023-03-27 22:10:30','2023-03-27 22:10:30',NULL),(1627,7730,578,40720,1525,15,354,1,8935.56,NULL,'2023-03-27 22:10:30','2023-03-27 22:10:30',NULL),(1628,7730,579,40720,1525,8,277,1,819.70,NULL,'2023-03-28 10:35:02','2023-03-28 18:35:17','2023-03-28 18:35:17'),(1629,7730,579,40720,1525,8,497,2,819.70,NULL,'2023-03-28 10:35:02','2023-03-28 18:35:17','2023-03-28 18:35:17'),(1630,7730,580,40720,1525,16,156,1,1183.71,NULL,'2023-03-28 11:51:24','2023-03-28 11:55:07','2023-03-28 11:55:07'),(1631,7730,580,40720,1525,16,226,2,1885.66,NULL,'2023-03-28 11:51:24','2023-03-28 11:55:07','2023-03-28 11:55:07'),(1632,7730,580,40720,1525,16,302,1,701.95,NULL,'2023-03-28 11:51:24','2023-03-28 11:55:07','2023-03-28 11:55:07'),(1633,7730,580,40720,1525,16,156,1,7143.02,NULL,'2023-03-28 11:51:24','2023-03-28 11:55:07','2023-03-28 11:55:07'),(1634,7730,580,40720,1525,16,225,2,653.54,NULL,'2023-03-28 11:51:24','2023-03-28 11:55:07','2023-03-28 11:55:07'),(1635,7730,580,40720,1525,16,326,2,6489.48,NULL,'2023-03-28 11:51:24','2023-03-28 11:55:07','2023-03-28 11:55:07'),(1636,7730,581,40720,1525,16,502,1,1381.00,NULL,'2023-03-28 12:01:52','2023-03-28 12:05:19','2023-03-28 12:05:19'),(1637,7730,581,40720,1525,16,208,1,7143.02,NULL,'2023-03-28 12:01:52','2023-03-28 12:05:19','2023-03-28 12:05:19'),(1638,7730,581,40720,1525,16,226,2,1855.74,NULL,'2023-03-28 12:01:52','2023-03-28 12:05:19','2023-03-28 12:05:19'),(1639,7730,581,40720,1525,16,225,2,653.54,NULL,'2023-03-28 12:01:52','2023-03-28 12:05:19','2023-03-28 12:05:19'),(1640,7730,581,40720,1525,16,277,2,819.70,NULL,'2023-03-28 12:01:52','2023-03-28 12:05:19','2023-03-28 12:05:19'),(1641,7730,581,40720,1525,16,326,2,5195.04,NULL,'2023-03-28 12:01:52','2023-03-28 12:05:19','2023-03-28 12:05:19'),(1642,7730,582,40720,1525,16,156,1,1183.71,NULL,'2023-03-28 12:02:50','2023-03-28 12:03:38','2023-03-28 12:03:38'),(1643,7730,582,40720,1525,16,226,2,1885.66,NULL,'2023-03-28 12:02:50','2023-03-28 12:03:38','2023-03-28 12:03:38'),(1644,7730,582,40720,1525,16,302,1,701.95,NULL,'2023-03-28 12:02:50','2023-03-28 12:03:38','2023-03-28 12:03:38'),(1645,7730,582,40720,1525,16,156,1,7143.02,NULL,'2023-03-28 12:02:50','2023-03-28 12:03:38','2023-03-28 12:03:38');
INSERT INTO `balance_libro_details` VALUES (1646,7730,582,40720,1525,16,225,2,653.54,NULL,'2023-03-28 12:02:50','2023-03-28 12:03:38','2023-03-28 12:03:38'),(1647,7730,582,40720,1525,16,326,2,6489.48,NULL,'2023-03-28 12:02:50','2023-03-28 12:03:38','2023-03-28 12:03:38'),(1648,7730,583,40720,1525,16,502,1,1381.00,NULL,'2023-03-28 12:05:19','2023-03-28 18:37:04','2023-03-28 18:37:04'),(1649,7730,583,40720,1525,16,208,1,7143.02,NULL,'2023-03-28 12:05:19','2023-03-28 18:37:04','2023-03-28 18:37:04'),(1650,7730,583,40720,1525,16,226,2,1855.74,NULL,'2023-03-28 12:05:19','2023-03-28 18:37:04','2023-03-28 18:37:04'),(1651,7730,583,40720,1525,16,225,2,653.54,NULL,'2023-03-28 12:05:19','2023-03-28 18:37:04','2023-03-28 18:37:04'),(1652,7730,583,40720,1525,16,277,2,819.70,NULL,'2023-03-28 12:05:19','2023-03-28 18:37:04','2023-03-28 18:37:04'),(1653,7730,583,40720,1525,16,326,2,6489.48,NULL,'2023-03-28 12:05:19','2023-03-28 18:37:04','2023-03-28 18:37:04'),(1654,7730,583,40720,1525,16,302,1,1294.44,NULL,'2023-03-28 12:05:19','2023-03-28 18:37:04','2023-03-28 18:37:04'),(1655,7730,584,40720,1525,3,489,1,97.14,NULL,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(1656,7730,584,40720,1525,3,68,1,26.23,NULL,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(1657,7730,584,40720,1525,3,489,1,865.86,NULL,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(1658,7730,584,40720,1525,3,68,1,181.83,NULL,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(1659,7730,584,40720,1525,3,489,1,29.92,NULL,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(1660,7730,584,40720,1525,3,221,1,5.11,NULL,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(1661,7730,584,40720,1525,3,57,2,1206.09,NULL,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(1662,7730,585,40720,1525,21,57,1,40365.09,NULL,'2023-03-28 12:20:13','2023-03-28 13:21:24','2023-03-28 13:21:24'),(1663,7730,585,40720,1525,21,484,2,40365.09,NULL,'2023-03-28 12:20:13','2023-03-28 13:21:24','2023-03-28 13:21:24'),(1664,7730,586,40720,1525,21,57,1,1206.09,NULL,'2023-03-28 12:22:21','2023-03-28 12:42:47','2023-03-28 12:42:47'),(1665,7730,586,40720,1525,21,484,2,1206.09,NULL,'2023-03-28 12:22:21','2023-03-28 12:42:47','2023-03-28 12:42:47'),(1666,7730,587,40720,1525,21,57,1,3298.43,NULL,'2023-03-28 12:24:10','2023-03-28 12:24:10',NULL),(1667,7730,587,40720,1525,21,484,2,3298.43,NULL,'2023-03-28 12:24:10','2023-03-28 12:24:10',NULL),(1668,7730,588,40720,1525,21,57,1,20000.00,NULL,'2023-03-28 12:40:44','2023-03-28 12:40:44',NULL),(1669,7730,588,40720,1525,21,497,2,20000.00,NULL,'2023-03-28 12:40:44','2023-03-28 12:40:44',NULL),(1670,7730,589,40720,1525,21,57,1,1206.09,NULL,'2023-03-28 12:46:41','2023-03-28 12:46:41',NULL),(1671,7730,589,40720,1525,21,484,2,1206.09,NULL,'2023-03-28 12:46:41','2023-03-28 12:46:41',NULL),(1672,7730,590,40720,1525,21,491,1,989.41,NULL,'2023-03-28 12:50:19','2023-03-28 12:50:19',NULL),(1673,7730,590,40720,1525,21,484,2,989.41,NULL,'2023-03-28 12:50:19','2023-03-28 12:50:19',NULL),(1674,7730,591,40720,1525,3,217,2,777.74,NULL,'2023-03-28 13:14:06','2023-03-28 13:16:58','2023-03-28 13:16:58'),(1675,7730,591,40720,1525,3,67,2,163.33,NULL,'2023-03-28 13:14:06','2023-03-28 13:16:58','2023-03-28 13:16:58'),(1676,7730,591,40720,1525,3,217,2,263.83,NULL,'2023-03-28 13:14:06','2023-03-28 13:16:58','2023-03-28 13:16:58'),(1677,7730,591,40720,1525,3,57,1,1204.90,NULL,'2023-03-28 13:14:06','2023-03-28 13:16:58','2023-03-28 13:16:58'),(1678,7730,592,40720,1525,3,217,2,777.74,NULL,'2023-03-28 13:16:58','2023-03-28 13:41:33','2023-03-28 13:41:33'),(1679,7730,592,40720,1525,3,67,2,163.33,NULL,'2023-03-28 13:16:58','2023-03-28 13:41:33','2023-03-28 13:41:33'),(1680,7730,592,40720,1525,3,220,2,240.50,NULL,'2023-03-28 13:16:58','2023-03-28 13:41:33','2023-03-28 13:41:33'),(1681,7730,592,40720,1525,3,226,2,23.33,NULL,'2023-03-28 13:16:58','2023-03-28 13:41:33','2023-03-28 13:41:33'),(1682,7730,592,40720,1525,3,57,1,1204.90,NULL,'2023-03-28 13:16:58','2023-03-28 13:41:33','2023-03-28 13:41:33');
INSERT INTO `balance_libro_details` VALUES (1683,7730,593,40720,1525,3,217,1,26141.60,NULL,'2023-03-28 13:22:49','2023-03-28 13:24:56','2023-03-28 13:24:56'),(1684,7730,593,40720,1525,3,68,1,5489.74,NULL,'2023-03-28 13:22:49','2023-03-28 13:24:56','2023-03-28 13:24:56'),(1685,7730,593,40720,1525,3,217,1,8733.75,NULL,'2023-03-28 13:22:49','2023-03-28 13:24:56','2023-03-28 13:24:56'),(1686,7730,593,40720,1525,3,57,2,40365.09,NULL,'2023-03-28 13:22:49','2023-03-28 13:24:56','2023-03-28 13:24:56'),(1687,7730,594,40720,1525,3,488,1,26141.60,NULL,'2023-03-28 13:24:56','2023-03-28 13:24:56',NULL),(1688,7730,594,40720,1525,3,68,1,5489.74,NULL,'2023-03-28 13:24:56','2023-03-28 13:24:56',NULL),(1689,7730,594,40720,1525,3,220,1,6201.14,NULL,'2023-03-28 13:24:56','2023-03-28 13:24:56',NULL),(1690,7730,594,40720,1525,3,225,1,653.54,NULL,'2023-03-28 13:24:56','2023-03-28 13:24:56',NULL),(1691,7730,594,40720,1525,3,226,1,1879.07,NULL,'2023-03-28 13:24:56','2023-03-28 13:24:56',NULL),(1692,7730,594,40720,1525,3,57,2,40365.09,NULL,'2023-03-28 13:24:56','2023-03-28 13:24:56',NULL),(1693,7730,595,40720,1525,21,57,1,40365.09,NULL,'2023-03-28 13:26:34','2023-03-28 14:25:03','2023-03-28 14:25:03'),(1694,7730,595,40720,1525,21,484,2,40365.09,NULL,'2023-03-28 13:26:34','2023-03-28 14:25:03','2023-03-28 14:25:03'),(1695,7730,596,40720,1525,3,488,2,777.74,NULL,'2023-03-28 13:41:33','2023-03-28 13:41:33',NULL),(1696,7730,596,40720,1525,3,67,2,163.33,NULL,'2023-03-28 13:41:33','2023-03-28 13:41:33',NULL),(1697,7730,596,40720,1525,3,220,2,240.50,NULL,'2023-03-28 13:41:33','2023-03-28 13:41:33',NULL),(1698,7730,596,40720,1525,3,226,2,23.33,NULL,'2023-03-28 13:41:33','2023-03-28 13:41:33',NULL),(1699,7730,596,40720,1525,3,57,1,1204.90,NULL,'2023-03-28 13:41:33','2023-03-28 13:41:33',NULL),(1700,7730,597,40720,1525,21,57,1,39160.19,NULL,'2023-03-28 14:38:52','2023-03-28 14:38:52',NULL),(1701,7730,597,40720,1525,21,484,2,39160.19,NULL,'2023-03-28 14:38:52','2023-03-28 14:38:52',NULL),(1702,7730,598,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:22:21','2023-03-28 15:22:21'),(1703,7730,598,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:22:21','2023-03-28 15:22:21'),(1704,7730,598,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:22:21','2023-03-28 15:22:21'),(1705,7730,599,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:23:10','2023-03-28 15:23:10'),(1706,7730,599,40720,1526,2,218,2,7919.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:23:10','2023-03-28 15:23:10'),(1707,7730,599,40720,1526,2,13,1,7919.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:23:10','2023-03-28 15:23:10'),(1708,7730,600,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:23:57','2023-03-28 15:23:57'),(1709,7730,600,40720,1526,2,218,2,8557.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:23:57','2023-03-28 15:23:57'),(1710,7730,600,40720,1526,2,13,1,8557.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:23:57','2023-03-28 15:23:57'),(1711,7730,601,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:24:57','2023-03-28 15:24:57'),(1712,7730,601,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:24:57','2023-03-28 15:24:57'),(1713,7730,601,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:24:57','2023-03-28 15:24:57'),(1714,7730,602,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:25:56','2023-03-28 15:25:56'),(1715,7730,602,40720,1526,2,218,2,7590.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:25:56','2023-03-28 15:25:56'),(1716,7730,602,40720,1526,2,13,1,7590.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:25:56','2023-03-28 15:25:56'),(1717,7730,603,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:26:37','2023-03-28 15:26:37'),(1718,7730,603,40720,1526,2,218,2,2990.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:26:37','2023-03-28 15:26:37'),(1719,7730,603,40720,1526,2,13,1,2990.00,NULL,'2023-03-28 15:17:33','2023-03-28 15:26:37','2023-03-28 15:26:37');
INSERT INTO `balance_libro_details` VALUES (1720,7730,604,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:27:43','2023-03-28 15:27:43'),(1721,7730,604,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:27:43','2023-03-28 15:27:43'),(1722,7730,604,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:27:43','2023-03-28 15:27:43'),(1723,7730,605,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:28:30','2023-03-28 15:28:30'),(1724,7730,605,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:28:30','2023-03-28 15:28:30'),(1725,7730,605,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:28:30','2023-03-28 15:28:30'),(1726,7730,606,40720,1526,2,96,2,14694.21,NULL,'2023-03-28 15:17:34','2023-03-28 15:20:06','2023-03-28 15:20:06'),(1727,7730,606,40720,1526,2,67,2,3085.79,NULL,'2023-03-28 15:17:34','2023-03-28 15:20:06','2023-03-28 15:20:06'),(1728,7730,606,40720,1526,2,13,1,17780.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:20:06','2023-03-28 15:20:06'),(1729,7730,607,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:29:20','2023-03-28 15:29:20'),(1730,7730,607,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:29:20','2023-03-28 15:29:20'),(1731,7730,607,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:29:20','2023-03-28 15:29:20'),(1732,7730,608,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:30:03','2023-03-28 15:30:03'),(1733,7730,608,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:30:03','2023-03-28 15:30:03'),(1734,7730,608,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:30:03','2023-03-28 15:30:03'),(1735,7730,609,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:30:46','2023-03-28 15:30:46'),(1736,7730,609,40720,1526,2,218,2,17780.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:30:46','2023-03-28 15:30:46'),(1737,7730,609,40720,1526,2,13,1,17780.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:30:46','2023-03-28 15:30:46'),(1738,7730,610,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:31:38','2023-03-28 15:31:38'),(1739,7730,610,40720,1526,2,218,2,7919.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:31:38','2023-03-28 15:31:38'),(1740,7730,610,40720,1526,2,13,1,7919.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:31:38','2023-03-28 15:31:38'),(1741,7730,611,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:33:16','2023-03-28 15:33:16'),(1742,7730,611,40720,1526,2,218,2,7990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:33:16','2023-03-28 15:33:16'),(1743,7730,611,40720,1526,2,13,1,7990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:33:16','2023-03-28 15:33:16'),(1744,7730,612,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:34:36','2023-03-28 15:34:36'),(1745,7730,612,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:34:36','2023-03-28 15:34:36'),(1746,7730,612,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:34:36','2023-03-28 15:34:36'),(1747,7730,613,40720,1526,2,96,2,6603.31,NULL,'2023-03-28 15:17:34','2023-03-28 15:39:33','2023-03-28 15:39:33'),(1748,7730,613,40720,1526,2,67,2,1386.69,NULL,'2023-03-28 15:17:34','2023-03-28 15:39:33','2023-03-28 15:39:33'),(1749,7730,613,40720,1526,2,13,1,7990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:39:33','2023-03-28 15:39:33'),(1750,7730,614,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:35:23','2023-03-28 15:35:23'),(1751,7730,614,40720,1526,2,218,2,3400.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:35:23','2023-03-28 15:35:23'),(1752,7730,614,40720,1526,2,13,1,3400.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:35:23','2023-03-28 15:35:23'),(1753,7730,615,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:36:27','2023-03-28 15:36:27'),(1754,7730,615,40720,1526,2,218,2,2750.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:36:27','2023-03-28 15:36:27');
INSERT INTO `balance_libro_details` VALUES (1755,7730,615,40720,1526,2,13,1,2750.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:36:27','2023-03-28 15:36:27'),(1756,7730,616,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:36:53','2023-03-28 15:36:53'),(1757,7730,616,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:36:53','2023-03-28 15:36:53'),(1758,7730,616,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:36:53','2023-03-28 15:36:53'),(1759,7730,617,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:37:46','2023-03-28 15:37:46'),(1760,7730,617,40720,1526,2,218,2,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:37:46','2023-03-28 15:37:46'),(1761,7730,617,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:37:46','2023-03-28 15:37:46'),(1762,7730,618,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:17:34','2023-03-28 15:38:39','2023-03-28 15:38:39'),(1763,7730,618,40720,1526,2,218,2,9490.50,NULL,'2023-03-28 15:17:34','2023-03-28 15:38:39','2023-03-28 15:38:39'),(1764,7730,618,40720,1526,2,13,1,9490.50,NULL,'2023-03-28 15:17:34','2023-03-28 15:38:39','2023-03-28 15:38:39'),(1765,7730,619,40720,1526,2,96,2,14694.21,NULL,'2023-03-28 15:21:09','2023-03-28 15:40:44','2023-03-28 15:40:44'),(1766,7730,619,40720,1526,2,67,2,3085.79,NULL,'2023-03-28 15:21:09','2023-03-28 15:40:44','2023-03-28 15:40:44'),(1767,7730,619,40720,1526,2,13,1,17780.00,NULL,'2023-03-28 15:21:09','2023-03-28 15:40:44','2023-03-28 15:40:44'),(1768,7730,620,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:22:21','2023-03-28 15:22:21',NULL),(1769,7730,620,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:22:21','2023-03-28 15:22:21',NULL),(1770,7730,620,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:22:21','2023-03-28 15:22:21',NULL),(1771,7730,621,40720,1526,2,96,2,6544.63,NULL,'2023-03-28 15:23:10','2023-03-28 15:23:10',NULL),(1772,7730,621,40720,1526,2,67,2,1374.37,NULL,'2023-03-28 15:23:10','2023-03-28 15:23:10',NULL),(1773,7730,621,40720,1526,2,13,1,7919.00,NULL,'2023-03-28 15:23:10','2023-03-28 15:23:10',NULL),(1774,7730,622,40720,1526,2,96,2,7071.90,NULL,'2023-03-28 15:23:57','2023-03-28 15:23:57',NULL),(1775,7730,622,40720,1526,2,67,2,1485.10,NULL,'2023-03-28 15:23:57','2023-03-28 15:23:57',NULL),(1776,7730,622,40720,1526,2,13,1,8557.00,NULL,'2023-03-28 15:23:57','2023-03-28 15:23:57',NULL),(1777,7730,623,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:24:57','2023-03-28 15:24:57',NULL),(1778,7730,623,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:24:57','2023-03-28 15:24:57',NULL),(1779,7730,623,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:24:57','2023-03-28 15:24:57',NULL),(1780,7730,624,40720,1526,2,96,2,6272.73,NULL,'2023-03-28 15:25:56','2023-03-28 15:25:56',NULL),(1781,7730,624,40720,1526,2,67,2,1317.27,NULL,'2023-03-28 15:25:56','2023-03-28 15:25:56',NULL),(1782,7730,624,40720,1526,2,13,1,7590.00,NULL,'2023-03-28 15:25:56','2023-03-28 15:25:56',NULL),(1783,7730,625,40720,1526,2,96,2,2471.07,NULL,'2023-03-28 15:26:37','2023-03-28 15:26:37',NULL),(1784,7730,625,40720,1526,2,67,2,518.92,NULL,'2023-03-28 15:26:37','2023-03-28 15:26:37',NULL),(1785,7730,625,40720,1526,2,218,2,0.01,NULL,'2023-03-28 15:26:37','2023-03-28 15:26:37',NULL),(1786,7730,625,40720,1526,2,13,1,2990.00,NULL,'2023-03-28 15:26:37','2023-03-28 15:26:37',NULL),(1787,7730,626,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:27:43','2023-03-28 15:27:43',NULL),(1788,7730,626,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:27:43','2023-03-28 15:27:43',NULL),(1789,7730,626,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:27:43','2023-03-28 15:27:43',NULL),(1790,7730,627,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:28:30','2023-03-28 15:28:30',NULL),(1791,7730,627,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:28:30','2023-03-28 15:28:30',NULL),(1792,7730,627,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:28:30','2023-03-28 15:28:30',NULL),(1793,7730,628,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:29:20','2023-03-28 15:29:20',NULL);
INSERT INTO `balance_libro_details` VALUES (1794,7730,628,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:29:20','2023-03-28 15:29:20',NULL),(1795,7730,628,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:29:20','2023-03-28 15:29:20',NULL),(1796,7730,629,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:30:03','2023-03-28 15:30:03',NULL),(1797,7730,629,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:30:03','2023-03-28 15:30:03',NULL),(1798,7730,629,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:30:03','2023-03-28 15:30:03',NULL),(1799,7730,630,40720,1526,2,96,2,14694.21,NULL,'2023-03-28 15:30:46','2023-03-28 15:30:46',NULL),(1800,7730,630,40720,1526,2,67,2,3085.78,NULL,'2023-03-28 15:30:46','2023-03-28 15:30:46',NULL),(1801,7730,630,40720,1526,2,218,2,0.01,NULL,'2023-03-28 15:30:46','2023-03-28 15:30:46',NULL),(1802,7730,630,40720,1526,2,13,1,17780.00,NULL,'2023-03-28 15:30:46','2023-03-28 15:30:46',NULL),(1803,7730,631,40720,1526,2,96,2,6544.63,NULL,'2023-03-28 15:31:38','2023-03-28 15:31:38',NULL),(1804,7730,631,40720,1526,2,67,2,1374.37,NULL,'2023-03-28 15:31:38','2023-03-28 15:31:38',NULL),(1805,7730,631,40720,1526,2,13,1,7919.00,NULL,'2023-03-28 15:31:38','2023-03-28 15:31:38',NULL),(1806,7730,632,40720,1526,2,96,2,6603.31,NULL,'2023-03-28 15:33:16','2023-03-28 15:33:38','2023-03-28 15:33:38'),(1807,7730,632,40720,1526,2,67,2,1386.70,NULL,'2023-03-28 15:33:16','2023-03-28 15:33:38','2023-03-28 15:33:38'),(1808,7730,632,40720,1526,2,13,1,7990.01,NULL,'2023-03-28 15:33:16','2023-03-28 15:33:38','2023-03-28 15:33:38'),(1809,7730,633,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:34:36','2023-03-28 15:34:36',NULL),(1810,7730,633,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:34:36','2023-03-28 15:34:36',NULL),(1811,7730,633,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:34:36','2023-03-28 15:34:36',NULL),(1812,7730,634,40720,1526,2,96,2,2809.92,NULL,'2023-03-28 15:35:23','2023-03-28 15:35:23',NULL),(1813,7730,634,40720,1526,2,67,2,590.08,NULL,'2023-03-28 15:35:23','2023-03-28 15:35:23',NULL),(1814,7730,634,40720,1526,2,13,1,3400.00,NULL,'2023-03-28 15:35:23','2023-03-28 15:35:23',NULL),(1815,7730,635,40720,1526,2,96,2,2272.73,NULL,'2023-03-28 15:36:27','2023-03-28 15:36:27',NULL),(1816,7730,635,40720,1526,2,67,2,477.27,NULL,'2023-03-28 15:36:27','2023-03-28 15:36:27',NULL),(1817,7730,635,40720,1526,2,13,1,2750.00,NULL,'2023-03-28 15:36:27','2023-03-28 15:36:27',NULL),(1818,7730,636,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:36:53','2023-03-28 15:36:53',NULL),(1819,7730,636,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:36:53','2023-03-28 15:36:53',NULL),(1820,7730,636,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:36:53','2023-03-28 15:36:53',NULL),(1821,7730,637,40720,1526,2,96,2,8256.20,NULL,'2023-03-28 15:37:46','2023-03-28 15:37:46',NULL),(1822,7730,637,40720,1526,2,67,2,1733.80,NULL,'2023-03-28 15:37:46','2023-03-28 15:37:46',NULL),(1823,7730,637,40720,1526,2,13,1,9990.00,NULL,'2023-03-28 15:37:46','2023-03-28 15:37:46',NULL),(1824,7730,638,40720,1526,2,96,2,7843.39,NULL,'2023-03-28 15:38:39','2023-03-28 15:38:39',NULL),(1825,7730,638,40720,1526,2,67,2,1647.11,NULL,'2023-03-28 15:38:39','2023-03-28 15:38:39',NULL),(1826,7730,638,40720,1526,2,13,1,9490.50,NULL,'2023-03-28 15:38:39','2023-03-28 15:38:39',NULL),(1827,7730,639,40720,1526,2,96,2,6603.31,NULL,'2023-03-28 15:39:33','2023-03-28 15:44:07','2023-03-28 15:44:07'),(1828,7730,639,40720,1526,2,67,2,1386.70,NULL,'2023-03-28 15:39:33','2023-03-28 15:44:07','2023-03-28 15:44:07'),(1829,7730,639,40720,1526,2,13,1,7990.01,NULL,'2023-03-28 15:39:33','2023-03-28 15:44:07','2023-03-28 15:44:07'),(1830,7730,640,40720,1526,2,96,2,14694.21,NULL,'2023-03-28 15:40:44','2023-03-28 15:40:44',NULL),(1831,7730,640,40720,1526,2,67,2,3085.78,NULL,'2023-03-28 15:40:44','2023-03-28 15:40:44',NULL),(1832,7730,640,40720,1526,2,218,2,0.01,NULL,'2023-03-28 15:40:44','2023-03-28 15:40:44',NULL),(1833,7730,640,40720,1526,2,13,1,17780.00,NULL,'2023-03-28 15:40:44','2023-03-28 15:40:44',NULL);
INSERT INTO `balance_libro_details` VALUES (1834,7730,641,40720,1526,2,218,2,0.00,NULL,'2023-03-28 15:41:41','2023-03-28 15:43:08','2023-03-28 15:43:08'),(1835,7730,641,40720,1526,2,218,2,7990.00,NULL,'2023-03-28 15:41:41','2023-03-28 15:43:08','2023-03-28 15:43:08'),(1836,7730,641,40720,1526,2,13,1,7990.00,NULL,'2023-03-28 15:41:41','2023-03-28 15:43:08','2023-03-28 15:43:08'),(1837,7730,642,40720,1526,2,96,2,6603.30,NULL,'2023-03-28 15:43:08','2023-03-28 15:43:08',NULL),(1838,7730,642,40720,1526,2,67,2,1386.69,NULL,'2023-03-28 15:43:08','2023-03-28 15:43:08',NULL),(1839,7730,642,40720,1526,2,218,2,0.01,NULL,'2023-03-28 15:43:08','2023-03-28 15:43:08',NULL),(1840,7730,642,40720,1526,2,13,1,7990.00,NULL,'2023-03-28 15:43:08','2023-03-28 15:43:08',NULL),(1841,7730,643,40720,1526,2,96,2,6603.30,NULL,'2023-03-28 15:44:07','2023-03-28 15:44:07',NULL),(1842,7730,643,40720,1526,2,67,2,1386.69,NULL,'2023-03-28 15:44:07','2023-03-28 15:44:07',NULL),(1843,7730,643,40720,1526,2,218,2,0.01,NULL,'2023-03-28 15:44:07','2023-03-28 15:44:07',NULL),(1844,7730,643,40720,1526,2,13,1,7990.00,NULL,'2023-03-28 15:44:07','2023-03-28 15:44:07',NULL),(1845,7730,644,40720,1526,20,13,2,9990.00,NULL,'2023-03-28 15:45:24','2023-03-28 15:45:24',NULL),(1846,7730,644,40720,1526,20,484,1,9990.00,NULL,'2023-03-28 15:45:24','2023-03-28 15:45:24',NULL),(1847,7730,645,40720,1526,20,13,2,7919.00,NULL,'2023-03-28 15:49:20','2023-03-28 15:49:20',NULL),(1848,7730,645,40720,1526,20,484,1,7919.00,NULL,'2023-03-28 15:49:20','2023-03-28 15:49:20',NULL),(1849,7730,646,40720,1526,20,13,2,8557.00,NULL,'2023-03-28 15:50:10','2023-03-28 15:50:10',NULL),(1850,7730,646,40720,1526,20,484,1,8557.00,NULL,'2023-03-28 15:50:10','2023-03-28 15:50:10',NULL),(1851,7730,647,40720,1526,20,13,2,12980.00,NULL,'2023-03-28 15:51:22','2023-03-28 15:51:22',NULL),(1852,7730,647,40720,1526,20,484,1,12980.00,NULL,'2023-03-28 15:51:22','2023-03-28 15:51:22',NULL),(1853,7730,648,40720,1526,20,13,2,7590.00,NULL,'2023-03-28 15:52:07','2023-03-28 15:52:07',NULL),(1854,7730,648,40720,1526,20,484,1,7590.00,NULL,'2023-03-28 15:52:07','2023-03-28 15:52:07',NULL),(1855,7730,649,40720,1526,20,13,2,9990.00,NULL,'2023-03-28 15:52:50','2023-03-28 15:52:50',NULL),(1856,7730,649,40720,1526,20,484,1,9990.00,NULL,'2023-03-28 15:52:50','2023-03-28 15:52:50',NULL),(1857,7730,650,40720,1526,20,13,2,9990.00,NULL,'2023-03-28 15:53:55','2023-03-28 15:53:55',NULL),(1858,7730,650,40720,1526,20,484,1,9990.00,NULL,'2023-03-28 15:53:55','2023-03-28 15:53:55',NULL),(1859,7730,651,40720,1526,20,13,2,9990.00,NULL,'2023-03-28 15:54:34','2023-03-28 15:54:34',NULL),(1860,7730,651,40720,1526,20,484,1,9990.00,NULL,'2023-03-28 15:54:34','2023-03-28 15:54:34',NULL),(1861,7730,652,40720,1526,20,13,2,27770.00,NULL,'2023-03-28 15:55:24','2023-03-28 15:55:24',NULL),(1862,7730,652,40720,1526,20,484,1,27770.00,NULL,'2023-03-28 15:55:24','2023-03-28 15:55:24',NULL),(1863,7730,653,40720,1526,20,13,2,7919.00,NULL,'2023-03-28 15:56:05','2023-03-28 15:56:05',NULL),(1864,7730,653,40720,1526,20,484,1,7919.00,NULL,'2023-03-28 15:56:05','2023-03-28 15:56:05',NULL),(1865,7730,654,40720,1526,20,13,2,9990.00,NULL,'2023-03-28 15:56:48','2023-03-28 15:56:48',NULL),(1866,7730,654,40720,1526,20,484,1,9990.00,NULL,'2023-03-28 15:56:48','2023-03-28 15:56:48',NULL),(1867,7730,655,40720,1526,20,13,2,3400.00,NULL,'2023-03-28 15:57:28','2023-03-28 15:57:28',NULL),(1868,7730,655,40720,1526,20,484,1,3400.00,NULL,'2023-03-28 15:57:28','2023-03-28 15:57:28',NULL),(1869,7730,656,40720,1526,20,13,2,12740.00,NULL,'2023-03-28 16:00:04','2023-03-28 16:00:04',NULL),(1870,7730,656,40720,1526,20,484,1,12740.00,NULL,'2023-03-28 16:00:04','2023-03-28 16:00:04',NULL),(1871,7730,657,40720,1526,20,13,2,9990.00,NULL,'2023-03-28 16:00:52','2023-03-28 16:00:52',NULL),(1872,7730,657,40720,1526,20,484,1,9990.00,NULL,'2023-03-28 16:00:52','2023-03-28 16:00:52',NULL),(1873,7730,658,40720,1526,20,13,2,7990.00,NULL,'2023-03-28 16:01:53','2023-03-28 16:01:53',NULL);
INSERT INTO `balance_libro_details` VALUES (1874,7730,658,40720,1526,20,484,1,7990.00,NULL,'2023-03-28 16:01:53','2023-03-28 16:01:53',NULL),(1875,7730,659,40720,1526,20,13,2,9490.50,NULL,'2023-03-28 16:02:38','2023-03-28 16:02:38',NULL),(1876,7730,659,40720,1526,20,484,1,9490.50,NULL,'2023-03-28 16:02:38','2023-03-28 16:02:38',NULL),(1877,7730,660,40720,1526,20,13,2,17780.00,NULL,'2023-03-28 16:03:43','2023-03-28 16:03:43',NULL),(1878,7730,660,40720,1526,20,484,1,17780.00,NULL,'2023-03-28 16:03:43','2023-03-28 16:03:43',NULL),(1879,7730,661,40720,1526,20,13,2,7990.00,NULL,'2023-03-28 16:04:41','2023-03-28 16:04:41',NULL),(1880,7730,661,40720,1526,20,484,1,7990.00,NULL,'2023-03-28 16:04:41','2023-03-28 16:04:41',NULL),(1881,7730,662,40720,1526,3,217,1,20664.00,NULL,'2023-03-28 16:08:42','2023-03-29 10:33:33','2023-03-29 10:33:33'),(1882,7730,662,40720,1526,3,68,1,4339.44,NULL,'2023-03-28 16:08:42','2023-03-29 10:33:33','2023-03-29 10:33:33'),(1883,7730,662,40720,1526,3,57,2,25003.44,NULL,'2023-03-28 16:08:42','2023-03-29 10:33:33','2023-03-29 10:33:33'),(1884,7730,663,40720,1526,3,217,1,1854.90,NULL,'2023-03-28 16:08:42','2023-03-29 10:33:15','2023-03-29 10:33:15'),(1885,7730,663,40720,1526,3,68,1,389.53,NULL,'2023-03-28 16:08:42','2023-03-29 10:33:15','2023-03-29 10:33:15'),(1886,7730,663,40720,1526,3,57,2,2244.43,NULL,'2023-03-28 16:08:42','2023-03-29 10:33:15','2023-03-29 10:33:15'),(1887,7730,664,40720,1526,3,250,1,20000.00,NULL,'2023-03-28 16:08:43','2023-03-28 16:10:10','2023-03-28 16:10:10'),(1888,7730,664,40720,1526,3,57,2,20000.00,NULL,'2023-03-28 16:08:43','2023-03-28 16:10:10','2023-03-28 16:10:10'),(1889,7730,665,40720,1526,3,217,1,1450.00,NULL,'2023-03-28 16:08:43','2023-03-28 16:10:37','2023-03-28 16:10:37'),(1890,7730,665,40720,1526,3,68,1,304.50,NULL,'2023-03-28 16:08:43','2023-03-28 16:10:37','2023-03-28 16:10:37'),(1891,7730,665,40720,1526,3,57,2,1754.50,NULL,'2023-03-28 16:08:43','2023-03-28 16:10:37','2023-03-28 16:10:37'),(1892,7730,666,40720,1526,3,250,1,0.00,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:55','2023-03-29 10:32:55'),(1893,7730,666,40720,1526,3,250,1,4378.50,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:55','2023-03-29 10:32:55'),(1894,7730,666,40720,1526,3,57,2,4378.50,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:55','2023-03-29 10:32:55'),(1895,7730,667,40720,1526,3,217,1,29254.74,NULL,'2023-03-28 16:08:43','2023-03-28 16:13:57','2023-03-28 16:13:57'),(1896,7730,667,40720,1526,3,68,1,6143.50,NULL,'2023-03-28 16:08:43','2023-03-28 16:13:57','2023-03-28 16:13:57'),(1897,7730,667,40720,1526,3,217,1,6660.94,NULL,'2023-03-28 16:08:43','2023-03-28 16:13:57','2023-03-28 16:13:57'),(1898,7730,667,40720,1526,3,57,2,42059.18,NULL,'2023-03-28 16:08:43','2023-03-28 16:13:57','2023-03-28 16:13:57'),(1899,7730,668,40720,1526,3,217,1,4386.75,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:43','2023-03-29 10:32:43'),(1900,7730,668,40720,1526,3,68,1,921.22,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:43','2023-03-29 10:32:43'),(1901,7730,668,40720,1526,3,57,2,5307.97,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:43','2023-03-29 10:32:43'),(1902,7730,669,40720,1526,3,217,1,3526.50,NULL,'2023-03-28 16:08:43','2023-03-29 10:36:56','2023-03-29 10:36:56'),(1903,7730,669,40720,1526,3,68,1,740.57,NULL,'2023-03-28 16:08:43','2023-03-29 10:36:56','2023-03-29 10:36:56'),(1904,7730,669,40720,1526,3,57,2,4267.07,NULL,'2023-03-28 16:08:43','2023-03-29 10:36:56','2023-03-29 10:36:56'),(1905,7730,670,40720,1526,3,217,1,4218.00,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:30','2023-03-29 10:32:30'),(1906,7730,670,40720,1526,3,68,1,885.78,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:30','2023-03-29 10:32:30'),(1907,7730,670,40720,1526,3,57,2,5103.78,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:30','2023-03-29 10:32:30'),(1908,7730,671,40720,1526,3,217,1,4904.25,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:13','2023-03-29 10:32:13'),(1909,7730,671,40720,1526,3,68,1,1029.89,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:13','2023-03-29 10:32:13');
INSERT INTO `balance_libro_details` VALUES (1910,7730,671,40720,1526,3,57,2,5934.14,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:13','2023-03-29 10:32:13'),(1911,7730,672,40720,1526,3,217,1,24397.20,NULL,'2023-03-28 16:08:43','2023-03-29 10:31:59','2023-03-29 10:31:59'),(1912,7730,672,40720,1526,3,68,1,5123.41,NULL,'2023-03-28 16:08:43','2023-03-29 10:31:59','2023-03-29 10:31:59'),(1913,7730,672,40720,1526,3,57,2,29520.61,NULL,'2023-03-28 16:08:43','2023-03-29 10:31:59','2023-03-29 10:31:59'),(1914,7730,673,40720,1526,3,217,1,10226.70,NULL,'2023-03-28 16:08:43','2023-03-29 10:31:45','2023-03-29 10:31:45'),(1915,7730,673,40720,1526,3,68,1,2147.61,NULL,'2023-03-28 16:08:43','2023-03-29 10:31:45','2023-03-29 10:31:45'),(1916,7730,673,40720,1526,3,57,2,12374.31,NULL,'2023-03-28 16:08:43','2023-03-29 10:31:45','2023-03-29 10:31:45'),(1917,7730,674,40720,1526,3,217,1,963.00,NULL,'2023-03-28 16:08:43','2023-03-28 16:16:33','2023-03-28 16:16:33'),(1918,7730,674,40720,1526,3,68,1,208.06,NULL,'2023-03-28 16:08:43','2023-03-28 16:16:33','2023-03-28 16:16:33'),(1919,7730,674,40720,1526,3,217,1,35.03,NULL,'2023-03-28 16:08:43','2023-03-28 16:16:33','2023-03-28 16:16:33'),(1920,7730,674,40720,1526,3,57,2,1206.09,NULL,'2023-03-28 16:08:43','2023-03-28 16:16:33','2023-03-28 16:16:33'),(1921,7730,675,40720,1526,3,250,1,20000.00,NULL,'2023-03-28 16:10:10','2023-03-28 16:14:44','2023-03-28 16:14:44'),(1922,7730,675,40720,1526,3,57,2,20000.00,NULL,'2023-03-28 16:10:10','2023-03-28 16:14:44','2023-03-28 16:14:44'),(1923,7730,676,40720,1526,3,488,1,29254.74,NULL,'2023-03-28 16:13:57','2023-03-28 16:13:57',NULL),(1924,7730,676,40720,1526,3,68,1,6143.50,NULL,'2023-03-28 16:13:57','2023-03-28 16:13:57',NULL),(1925,7730,676,40720,1526,3,220,1,3478.64,NULL,'2023-03-28 16:13:57','2023-03-28 16:13:57',NULL),(1926,7730,676,40720,1526,3,225,1,731.37,NULL,'2023-03-28 16:13:57','2023-03-28 16:13:57',NULL),(1927,7730,676,40720,1526,3,226,1,2450.93,NULL,'2023-03-28 16:13:57','2023-03-28 16:13:57',NULL),(1928,7730,676,40720,1526,3,57,2,42059.18,NULL,'2023-03-28 16:13:57','2023-03-28 16:13:57',NULL),(1929,7730,677,40720,1526,3,498,1,20000.00,NULL,'2023-03-28 16:14:44','2023-03-28 16:14:44',NULL),(1930,7730,677,40720,1526,3,57,2,20000.00,NULL,'2023-03-28 16:14:44','2023-03-28 16:14:44',NULL),(1931,7730,678,40720,1526,3,489,1,97.14,NULL,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(1932,7730,678,40720,1526,3,68,1,26.23,NULL,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(1933,7730,678,40720,1526,3,489,1,865.86,NULL,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(1934,7730,678,40720,1526,3,68,1,181.83,NULL,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(1935,7730,678,40720,1526,3,489,1,29.92,NULL,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(1936,7730,678,40720,1526,3,221,1,5.11,NULL,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(1937,7730,678,40720,1526,3,57,2,1206.09,NULL,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(1938,7730,679,40720,1526,21,57,1,42059.18,NULL,'2023-03-28 16:17:50','2023-03-28 16:17:50',NULL),(1939,7730,679,40720,1526,21,484,2,42059.18,NULL,'2023-03-28 16:17:50','2023-03-28 16:17:50',NULL),(1940,7730,680,40720,1526,21,57,1,20000.00,NULL,'2023-03-28 16:20:44','2023-03-28 16:20:44',NULL),(1941,7730,680,40720,1526,21,359,2,20000.00,NULL,'2023-03-28 16:20:44','2023-03-28 16:20:44',NULL),(1942,7730,681,40720,1526,20,13,2,1206.09,NULL,'2023-03-28 16:21:40','2023-03-28 16:45:54','2023-03-28 16:45:54'),(1943,7730,681,40720,1526,20,484,1,1206.09,NULL,'2023-03-28 16:21:40','2023-03-28 16:45:54','2023-03-28 16:45:54'),(1944,7730,682,40720,1526,21,57,1,1206.09,NULL,'2023-03-28 16:46:32','2023-03-28 16:46:32',NULL),(1945,7730,682,40720,1526,21,484,2,1206.09,NULL,'2023-03-28 16:46:32','2023-03-28 16:46:32',NULL),(1946,7730,683,40720,1525,21,57,1,50000.00,NULL,'2023-03-28 17:19:46','2023-03-28 17:19:46',NULL),(1947,7730,683,40720,1525,21,497,2,50000.00,NULL,'2023-03-28 17:19:46','2023-03-28 17:19:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1948,7730,684,40720,1526,21,57,1,90000.00,NULL,'2023-03-28 17:23:20','2023-03-28 17:23:20',NULL),(1949,7730,684,40720,1526,21,497,2,90000.00,NULL,'2023-03-28 17:23:20','2023-03-28 17:23:20',NULL),(1950,7730,685,40720,1526,22,497,1,90000.00,NULL,'2023-03-28 17:30:53','2023-03-28 17:30:53',NULL),(1951,7730,685,40720,1526,22,484,2,90000.00,NULL,'2023-03-28 17:30:53','2023-03-28 17:30:53',NULL),(1952,7730,686,40720,1526,22,497,1,59000.00,NULL,'2023-03-28 17:31:54','2023-03-28 17:31:54',NULL),(1953,7730,686,40720,1526,22,484,2,59000.00,NULL,'2023-03-28 17:31:54','2023-03-28 17:31:54',NULL),(1954,7730,687,40720,1526,5,497,1,9354.84,NULL,'2023-03-28 17:35:30','2023-03-28 17:35:30',NULL),(1955,7730,687,40720,1526,5,214,2,9354.84,NULL,'2023-03-28 17:35:30','2023-03-28 17:35:30',NULL),(1956,7730,687,40720,1526,5,497,2,157.30,NULL,'2023-03-28 17:35:30','2023-03-28 17:35:30',NULL),(1957,7730,687,40720,1526,5,212,1,157.30,NULL,'2023-03-28 17:35:30','2023-03-28 17:35:30',NULL),(1958,7730,688,40720,1526,5,437,1,1351.52,NULL,'2023-03-28 17:37:58','2023-03-28 18:44:55','2023-03-28 18:44:55'),(1959,7730,688,40720,1526,5,497,2,1351.52,NULL,'2023-03-28 17:37:58','2023-03-28 18:44:55','2023-03-28 18:44:55'),(1960,7730,689,40720,1525,8,277,1,2019.70,NULL,'2023-03-28 18:35:17','2023-03-29 14:18:41','2023-03-29 14:18:41'),(1961,7730,689,40720,1525,8,497,2,2019.70,NULL,'2023-03-28 18:35:17','2023-03-29 14:18:41','2023-03-29 14:18:41'),(1962,7730,690,40720,1525,16,502,1,1381.00,NULL,'2023-03-28 18:37:04','2023-03-28 18:37:04',NULL),(1963,7730,690,40720,1525,16,208,1,7143.02,NULL,'2023-03-28 18:37:04','2023-03-28 18:37:04',NULL),(1964,7730,690,40720,1525,16,226,2,1855.74,NULL,'2023-03-28 18:37:04','2023-03-28 18:37:04',NULL),(1965,7730,690,40720,1525,16,225,2,653.54,NULL,'2023-03-28 18:37:04','2023-03-28 18:37:04',NULL),(1966,7730,690,40720,1525,16,277,2,2019.70,NULL,'2023-03-28 18:37:04','2023-03-28 18:37:04',NULL),(1967,7730,690,40720,1525,16,326,2,6489.48,NULL,'2023-03-28 18:37:04','2023-03-28 18:37:04',NULL),(1968,7730,690,40720,1525,16,302,1,2494.44,NULL,'2023-03-28 18:37:04','2023-03-28 18:37:04',NULL),(1969,7730,691,40720,1526,5,437,1,1351.52,NULL,'2023-03-28 18:44:55','2023-03-29 10:30:14','2023-03-29 10:30:14'),(1970,7730,691,40720,1526,5,277,1,3912.38,NULL,'2023-03-28 18:44:55','2023-03-29 10:30:14','2023-03-29 10:30:14'),(1971,7730,691,40720,1526,5,276,1,1630.04,NULL,'2023-03-28 18:44:55','2023-03-29 10:30:14','2023-03-29 10:30:14'),(1972,7730,691,40720,1526,5,497,2,6893.94,NULL,'2023-03-28 18:44:55','2023-03-29 10:30:14','2023-03-29 10:30:14'),(1973,7730,692,40720,1526,16,502,1,514.30,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1974,7730,692,40720,1526,16,208,1,7201.88,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1975,7730,692,40720,1526,16,226,2,2450.93,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1976,7730,692,40720,1526,16,277,2,3912.38,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1977,7730,692,40720,1526,16,225,2,731.37,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1978,7730,692,40720,1526,16,276,2,1630.04,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1979,7730,692,40720,1526,16,302,2,2494.44,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1980,7730,692,40720,1526,16,302,1,8343.45,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1981,7730,692,40720,1526,16,326,2,4840.47,NULL,'2023-03-28 19:16:07','2023-03-28 19:16:07',NULL),(1982,7730,693,40719,4,15,67,1,33333.68,NULL,'2023-03-29 02:13:56','2023-03-29 10:15:34','2023-03-29 10:15:34'),(1983,7730,693,40719,4,15,68,2,21929.00,NULL,'2023-03-29 02:13:56','2023-03-29 10:15:34','2023-03-29 10:15:34'),(1984,7730,693,40719,4,15,353,2,109503.98,NULL,'2023-03-29 02:13:56','2023-03-29 10:15:34','2023-03-29 10:15:34'),(1985,7730,693,40719,4,15,354,2,8935.56,NULL,'2023-03-29 02:13:56','2023-03-29 10:15:34','2023-03-29 10:15:34');
INSERT INTO `balance_libro_details` VALUES (1986,7730,693,40719,4,15,220,2,3478.64,NULL,'2023-03-29 02:13:56','2023-03-29 10:15:34','2023-03-29 10:15:34'),(1987,7730,693,40719,4,15,353,1,98099.30,NULL,'2023-03-29 02:13:56','2023-03-29 10:15:34','2023-03-29 10:15:34'),(1988,7730,693,40719,4,15,354,1,12414.20,NULL,'2023-03-29 02:13:56','2023-03-29 10:15:34','2023-03-29 10:15:34'),(1989,7730,694,40720,1526,15,67,1,33333.68,NULL,'2023-03-29 02:17:44','2023-03-29 02:17:44',NULL),(1990,7730,694,40720,1526,15,68,2,21929.00,NULL,'2023-03-29 02:17:44','2023-03-29 02:17:44',NULL),(1991,7730,694,40720,1526,15,353,2,109503.98,NULL,'2023-03-29 02:17:44','2023-03-29 02:17:44',NULL),(1992,7730,694,40720,1526,15,354,2,8935.56,NULL,'2023-03-29 02:17:44','2023-03-29 02:17:44',NULL),(1993,7730,694,40720,1526,15,220,2,3478.64,NULL,'2023-03-29 02:17:44','2023-03-29 02:17:44',NULL),(1994,7730,694,40720,1526,15,353,1,98099.30,NULL,'2023-03-29 02:17:44','2023-03-29 02:17:44',NULL),(1995,7730,694,40720,1526,15,354,1,12414.20,NULL,'2023-03-29 02:17:44','2023-03-29 02:17:44',NULL),(1996,7730,695,40720,1526,5,437,1,1531.52,NULL,'2023-03-29 10:30:14','2023-03-29 14:15:36','2023-03-29 14:15:36'),(1997,7730,695,40720,1526,5,277,1,3912.38,NULL,'2023-03-29 10:30:14','2023-03-29 14:15:36','2023-03-29 14:15:36'),(1998,7730,695,40720,1526,5,276,1,1630.04,NULL,'2023-03-29 10:30:14','2023-03-29 14:15:36','2023-03-29 14:15:36'),(1999,7730,695,40720,1526,5,497,2,7073.94,NULL,'2023-03-29 10:30:14','2023-03-29 14:15:36','2023-03-29 14:15:36'),(2000,7730,696,40720,1526,3,392,1,10226.70,NULL,'2023-03-29 10:31:45','2023-03-29 10:31:45',NULL),(2001,7730,696,40720,1526,3,68,1,2147.61,NULL,'2023-03-29 10:31:45','2023-03-29 10:31:45',NULL),(2002,7730,696,40720,1526,3,57,2,12374.31,NULL,'2023-03-29 10:31:45','2023-03-29 10:31:45',NULL),(2003,7730,697,40720,1526,3,392,1,24397.20,NULL,'2023-03-29 10:31:59','2023-03-29 10:31:59',NULL),(2004,7730,697,40720,1526,3,68,1,5123.41,NULL,'2023-03-29 10:31:59','2023-03-29 10:31:59',NULL),(2005,7730,697,40720,1526,3,57,2,29520.61,NULL,'2023-03-29 10:31:59','2023-03-29 10:31:59',NULL),(2006,7730,698,40720,1526,3,392,1,4904.25,NULL,'2023-03-29 10:32:13','2023-03-29 10:32:13',NULL),(2007,7730,698,40720,1526,3,68,1,1029.89,NULL,'2023-03-29 10:32:13','2023-03-29 10:32:13',NULL),(2008,7730,698,40720,1526,3,57,2,5934.14,NULL,'2023-03-29 10:32:13','2023-03-29 10:32:13',NULL),(2009,7730,699,40720,1526,3,392,1,4218.00,NULL,'2023-03-29 10:32:30','2023-03-29 10:32:30',NULL),(2010,7730,699,40720,1526,3,68,1,885.78,NULL,'2023-03-29 10:32:30','2023-03-29 10:32:30',NULL),(2011,7730,699,40720,1526,3,57,2,5103.78,NULL,'2023-03-29 10:32:30','2023-03-29 10:32:30',NULL),(2012,7730,700,40720,1526,3,392,1,4386.75,NULL,'2023-03-29 10:32:43','2023-03-29 10:32:43',NULL),(2013,7730,700,40720,1526,3,68,1,921.22,NULL,'2023-03-29 10:32:43','2023-03-29 10:32:43',NULL),(2014,7730,700,40720,1526,3,57,2,5307.97,NULL,'2023-03-29 10:32:43','2023-03-29 10:32:43',NULL),(2015,7730,701,40720,1526,3,392,1,4378.50,NULL,'2023-03-29 10:32:55','2023-03-29 10:32:55',NULL),(2016,7730,701,40720,1526,3,57,2,4378.50,NULL,'2023-03-29 10:32:55','2023-03-29 10:32:55',NULL),(2017,7730,702,40720,1526,3,392,1,1854.90,NULL,'2023-03-29 10:33:15','2023-03-29 10:33:15',NULL),(2018,7730,702,40720,1526,3,68,1,389.53,NULL,'2023-03-29 10:33:15','2023-03-29 10:33:15',NULL),(2019,7730,702,40720,1526,3,57,2,2244.43,NULL,'2023-03-29 10:33:15','2023-03-29 10:33:15',NULL),(2020,7730,703,40720,1526,3,392,1,20664.00,NULL,'2023-03-29 10:33:33','2023-03-29 10:33:33',NULL),(2021,7730,703,40720,1526,3,68,1,4339.44,NULL,'2023-03-29 10:33:33','2023-03-29 10:33:33',NULL),(2022,7730,703,40720,1526,3,57,2,25003.44,NULL,'2023-03-29 10:33:33','2023-03-29 10:33:33',NULL),(2023,7730,704,40720,1526,3,392,1,3526.50,NULL,'2023-03-29 10:36:56','2023-03-29 10:36:56',NULL),(2024,7730,704,40720,1526,3,68,1,740.57,NULL,'2023-03-29 10:36:56','2023-03-29 10:36:56',NULL),(2025,7730,704,40720,1526,3,57,2,4267.07,NULL,'2023-03-29 10:36:56','2023-03-29 10:36:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2026,7730,705,40720,1527,2,218,2,0.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:42:31','2023-03-29 10:42:31'),(2027,7730,705,40720,1527,2,218,2,2000.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:42:31','2023-03-29 10:42:31'),(2028,7730,705,40720,1527,2,13,1,2000.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:42:31','2023-03-29 10:42:31'),(2029,7730,706,40720,1527,2,218,2,0.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:42:06','2023-03-29 10:42:06'),(2030,7730,706,40720,1527,2,218,2,6800.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:42:06','2023-03-29 10:42:06'),(2031,7730,706,40720,1527,2,13,1,6800.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:42:06','2023-03-29 10:42:06'),(2032,7730,707,40720,1527,2,218,2,0.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:43:38','2023-03-29 10:43:38'),(2033,7730,707,40720,1527,2,218,2,2397.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:43:38','2023-03-29 10:43:38'),(2034,7730,707,40720,1527,2,13,1,2397.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:43:38','2023-03-29 10:43:38'),(2035,7730,708,40720,1527,2,218,2,0.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:45:21','2023-03-29 10:45:21'),(2036,7730,708,40720,1527,2,218,2,7990.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:45:21','2023-03-29 10:45:21'),(2037,7730,708,40720,1527,2,13,1,7990.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:45:21','2023-03-29 10:45:21'),(2038,7730,709,40720,1527,2,218,2,0.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:01','2023-03-29 10:47:01'),(2039,7730,709,40720,1527,2,218,2,7830.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:01','2023-03-29 10:47:01'),(2040,7730,709,40720,1527,2,13,1,7830.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:01','2023-03-29 10:47:01'),(2041,7730,710,40720,1527,2,218,2,0.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:18','2023-03-29 10:47:18'),(2042,7730,710,40720,1527,2,218,2,1500.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:18','2023-03-29 10:47:18'),(2043,7730,710,40720,1527,2,13,1,1500.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:18','2023-03-29 10:47:18'),(2044,7730,711,40720,1527,2,218,2,0.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:55','2023-03-29 10:47:55'),(2045,7730,711,40720,1527,2,218,2,7990.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:55','2023-03-29 10:47:55'),(2046,7730,711,40720,1527,2,13,1,7990.00,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:55','2023-03-29 10:47:55'),(2047,7730,712,40720,1527,2,96,2,5619.83,NULL,'2023-03-29 10:42:06','2023-03-29 10:42:06',NULL),(2048,7730,712,40720,1527,2,67,2,1180.16,NULL,'2023-03-29 10:42:06','2023-03-29 10:42:06',NULL),(2049,7730,712,40720,1527,2,218,2,0.01,NULL,'2023-03-29 10:42:06','2023-03-29 10:42:06',NULL),(2050,7730,712,40720,1527,2,13,1,6800.00,NULL,'2023-03-29 10:42:06','2023-03-29 10:42:06',NULL),(2051,7730,713,40720,1527,2,96,2,1652.89,NULL,'2023-03-29 10:42:31','2023-03-29 10:42:31',NULL),(2052,7730,713,40720,1527,2,67,2,347.11,NULL,'2023-03-29 10:42:31','2023-03-29 10:42:31',NULL),(2053,7730,713,40720,1527,2,13,1,2000.00,NULL,'2023-03-29 10:42:31','2023-03-29 10:42:31',NULL),(2054,7730,714,40720,1527,2,96,2,1980.99,NULL,'2023-03-29 10:43:38','2023-03-29 11:05:47','2023-03-29 11:05:47'),(2055,7730,714,40720,1527,2,67,2,416.01,NULL,'2023-03-29 10:43:38','2023-03-29 11:05:47','2023-03-29 11:05:47'),(2056,7730,714,40720,1527,2,13,1,2397.00,NULL,'2023-03-29 10:43:38','2023-03-29 11:05:47','2023-03-29 11:05:47'),(2057,7730,715,40720,1527,2,96,2,6603.30,NULL,'2023-03-29 10:45:21','2023-03-29 10:45:21',NULL),(2058,7730,715,40720,1527,2,67,2,1386.69,NULL,'2023-03-29 10:45:21','2023-03-29 10:45:21',NULL),(2059,7730,715,40720,1527,2,218,2,0.01,NULL,'2023-03-29 10:45:21','2023-03-29 10:45:21',NULL),(2060,7730,715,40720,1527,2,13,1,7990.00,NULL,'2023-03-29 10:45:21','2023-03-29 10:45:21',NULL),(2061,7730,716,40720,1527,2,96,2,6471.07,NULL,'2023-03-29 10:47:01','2023-03-29 11:22:52','2023-03-29 11:22:52'),(2062,7730,716,40720,1527,2,67,2,1358.92,NULL,'2023-03-29 10:47:01','2023-03-29 11:22:52','2023-03-29 11:22:52');
INSERT INTO `balance_libro_details` VALUES (2063,7730,716,40720,1527,2,218,2,0.01,NULL,'2023-03-29 10:47:01','2023-03-29 11:22:52','2023-03-29 11:22:52'),(2064,7730,716,40720,1527,2,13,1,7830.00,NULL,'2023-03-29 10:47:01','2023-03-29 11:22:52','2023-03-29 11:22:52'),(2065,7730,717,40720,1527,2,96,2,1239.67,NULL,'2023-03-29 10:47:18','2023-03-29 11:23:17','2023-03-29 11:23:17'),(2066,7730,717,40720,1527,2,67,2,260.33,NULL,'2023-03-29 10:47:18','2023-03-29 11:23:17','2023-03-29 11:23:17'),(2067,7730,717,40720,1527,2,13,1,1500.00,NULL,'2023-03-29 10:47:18','2023-03-29 11:23:17','2023-03-29 11:23:17'),(2068,7730,718,40720,1527,2,96,2,6603.30,NULL,'2023-03-29 10:47:55','2023-03-29 11:23:51','2023-03-29 11:23:51'),(2069,7730,718,40720,1527,2,67,2,1386.69,NULL,'2023-03-29 10:47:55','2023-03-29 11:23:51','2023-03-29 11:23:51'),(2070,7730,718,40720,1527,2,218,2,0.01,NULL,'2023-03-29 10:47:55','2023-03-29 11:23:51','2023-03-29 11:23:51'),(2071,7730,718,40720,1527,2,13,1,7990.00,NULL,'2023-03-29 10:47:55','2023-03-29 11:23:51','2023-03-29 11:23:51'),(2072,7730,719,40720,1527,20,13,2,8800.00,NULL,'2023-03-29 10:50:15','2023-03-29 10:50:15',NULL),(2073,7730,719,40720,1527,20,484,1,8800.00,NULL,'2023-03-29 10:50:15','2023-03-29 10:50:15',NULL),(2074,7730,720,40720,1527,20,13,2,7990.00,NULL,'2023-03-29 10:53:20','2023-03-29 10:53:20',NULL),(2075,7730,720,40720,1527,20,484,1,7990.00,NULL,'2023-03-29 10:53:20','2023-03-29 10:53:20',NULL),(2076,7730,721,40720,1527,20,13,2,2397.00,NULL,'2023-03-29 11:05:46','2023-03-29 11:05:46',NULL),(2077,7730,721,40720,1527,20,484,1,2397.00,NULL,'2023-03-29 11:05:46','2023-03-29 11:05:46',NULL),(2078,7730,722,40720,1527,2,96,2,1980.99,NULL,'2023-03-29 11:05:47','2023-03-29 11:05:47',NULL),(2079,7730,722,40720,1527,2,67,2,416.01,NULL,'2023-03-29 11:05:47','2023-03-29 11:05:47',NULL),(2080,7730,722,40720,1527,2,13,1,2397.00,NULL,'2023-03-29 11:05:47','2023-03-29 11:05:47',NULL),(2081,7730,723,40720,1527,20,13,2,7830.00,NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(2082,7730,723,40720,1527,20,484,1,7830.00,NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(2083,7730,724,40720,1527,2,96,2,6471.07,NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(2084,7730,724,40720,1527,2,67,2,1358.92,NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(2085,7730,724,40720,1527,2,218,2,0.01,NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(2086,7730,724,40720,1527,2,13,1,7830.00,NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(2087,7730,725,40720,1527,20,13,2,1500.00,NULL,'2023-03-29 11:23:16','2023-03-29 11:23:16',NULL),(2088,7730,725,40720,1527,20,484,1,1500.00,NULL,'2023-03-29 11:23:16','2023-03-29 11:23:16',NULL),(2089,7730,726,40720,1527,2,96,2,1239.67,NULL,'2023-03-29 11:23:17','2023-03-29 11:23:17',NULL),(2090,7730,726,40720,1527,2,67,2,260.33,NULL,'2023-03-29 11:23:17','2023-03-29 11:23:17',NULL),(2091,7730,726,40720,1527,2,13,1,1500.00,NULL,'2023-03-29 11:23:17','2023-03-29 11:23:17',NULL),(2092,7730,727,40720,1527,20,13,2,7990.00,NULL,'2023-03-29 11:23:50','2023-03-29 11:23:50',NULL),(2093,7730,727,40720,1527,20,484,1,7990.00,NULL,'2023-03-29 11:23:50','2023-03-29 11:23:50',NULL),(2094,7730,728,40720,1527,2,96,2,6603.30,NULL,'2023-03-29 11:23:51','2023-03-29 11:23:51',NULL),(2095,7730,728,40720,1527,2,67,2,1386.69,NULL,'2023-03-29 11:23:51','2023-03-29 11:23:51',NULL),(2096,7730,728,40720,1527,2,218,2,0.01,NULL,'2023-03-29 11:23:51','2023-03-29 11:23:51',NULL),(2097,7730,728,40720,1527,2,13,1,7990.00,NULL,'2023-03-29 11:23:51','2023-03-29 11:23:51',NULL),(2098,7730,729,40720,1527,3,217,1,963.00,NULL,'2023-03-29 11:27:14','2023-03-29 13:05:26','2023-03-29 13:05:26'),(2099,7730,729,40720,1527,3,68,1,208.06,NULL,'2023-03-29 11:27:14','2023-03-29 13:05:26','2023-03-29 13:05:26'),(2100,7730,729,40720,1527,3,217,1,35.03,NULL,'2023-03-29 11:27:14','2023-03-29 13:05:26','2023-03-29 13:05:26'),(2101,7730,729,40720,1527,3,57,2,1206.09,NULL,'2023-03-29 11:27:14','2023-03-29 13:05:26','2023-03-29 13:05:26');
INSERT INTO `balance_libro_details` VALUES (2102,7730,730,40720,1527,3,217,1,20212.12,NULL,'2023-03-29 11:27:14','2023-03-29 11:39:39','2023-03-29 11:39:39'),(2103,7730,730,40720,1527,3,68,1,4244.55,NULL,'2023-03-29 11:27:14','2023-03-29 11:39:39','2023-03-29 11:39:39'),(2104,7730,730,40720,1527,3,217,1,7410.75,NULL,'2023-03-29 11:27:14','2023-03-29 11:39:39','2023-03-29 11:39:39'),(2105,7730,730,40720,1527,3,57,2,31867.42,NULL,'2023-03-29 11:27:14','2023-03-29 11:39:39','2023-03-29 11:39:39'),(2106,7730,731,40720,1527,3,217,1,3846.00,NULL,'2023-03-29 11:27:14','2023-03-29 11:30:03','2023-03-29 11:30:03'),(2107,7730,731,40720,1527,3,68,1,807.66,NULL,'2023-03-29 11:27:14','2023-03-29 11:30:03','2023-03-29 11:30:03'),(2108,7730,731,40720,1527,3,57,2,4653.66,NULL,'2023-03-29 11:27:14','2023-03-29 11:30:03','2023-03-29 11:30:03'),(2109,7730,732,40720,1527,3,217,1,5002.50,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:51','2023-03-29 11:29:51'),(2110,7730,732,40720,1527,3,68,1,1050.53,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:51','2023-03-29 11:29:51'),(2111,7730,732,40720,1527,3,57,2,6053.03,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:51','2023-03-29 11:29:51'),(2112,7730,733,40720,1527,3,217,1,6254.25,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:38','2023-03-29 11:29:38'),(2113,7730,733,40720,1527,3,68,1,1313.39,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:38','2023-03-29 11:29:38'),(2114,7730,733,40720,1527,3,57,2,7567.64,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:38','2023-03-29 11:29:38'),(2115,7730,734,40720,1527,3,217,1,5760.00,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:25','2023-03-29 11:29:25'),(2116,7730,734,40720,1527,3,68,1,1209.60,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:25','2023-03-29 11:29:25'),(2117,7730,734,40720,1527,3,57,2,6969.60,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:25','2023-03-29 11:29:25'),(2118,7730,735,40720,1527,3,217,1,4508.10,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:14','2023-03-29 11:29:14'),(2119,7730,735,40720,1527,3,68,1,946.70,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:14','2023-03-29 11:29:14'),(2120,7730,735,40720,1527,3,57,2,5454.80,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:14','2023-03-29 11:29:14'),(2121,7730,736,40720,1527,3,217,1,6254.25,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:59','2023-03-29 11:28:59'),(2122,7730,736,40720,1527,3,68,1,1313.39,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:59','2023-03-29 11:28:59'),(2123,7730,736,40720,1527,3,57,2,7567.64,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:59','2023-03-29 11:28:59'),(2124,7730,737,40720,1527,3,217,1,4766.25,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:45','2023-03-29 11:28:45'),(2125,7730,737,40720,1527,3,68,1,1000.91,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:45','2023-03-29 11:28:45'),(2126,7730,737,40720,1527,3,57,2,5767.16,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:45','2023-03-29 11:28:45'),(2127,7730,738,40720,1527,3,217,1,3526.50,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:34','2023-03-29 11:28:34'),(2128,7730,738,40720,1527,3,68,1,740.57,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:34','2023-03-29 11:28:34'),(2129,7730,738,40720,1527,3,57,2,4267.07,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:34','2023-03-29 11:28:34'),(2130,7730,739,40720,1527,3,250,1,20000.00,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:21','2023-03-29 11:28:21'),(2131,7730,739,40720,1527,3,57,2,20000.00,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:21','2023-03-29 11:28:21'),(2132,7730,740,40720,1527,3,498,1,20000.00,NULL,'2023-03-29 11:28:21','2023-03-29 13:07:14','2023-03-29 13:07:14'),(2133,7730,740,40720,1527,3,57,2,20000.00,NULL,'2023-03-29 11:28:21','2023-03-29 13:07:14','2023-03-29 13:07:14'),(2134,7730,741,40720,1527,3,392,1,3526.50,NULL,'2023-03-29 11:28:34','2023-03-29 13:09:37','2023-03-29 13:09:37'),(2135,7730,741,40720,1527,3,68,1,740.57,NULL,'2023-03-29 11:28:34','2023-03-29 13:09:37','2023-03-29 13:09:37'),(2136,7730,741,40720,1527,3,57,2,4267.07,NULL,'2023-03-29 11:28:34','2023-03-29 13:09:37','2023-03-29 13:09:37');
INSERT INTO `balance_libro_details` VALUES (2137,7730,742,40720,1527,3,392,1,4766.25,NULL,'2023-03-29 11:28:45','2023-03-29 11:28:45',NULL),(2138,7730,742,40720,1527,3,68,1,1000.91,NULL,'2023-03-29 11:28:45','2023-03-29 11:28:45',NULL),(2139,7730,742,40720,1527,3,57,2,5767.16,NULL,'2023-03-29 11:28:45','2023-03-29 11:28:45',NULL),(2140,7730,743,40720,1527,3,392,1,6254.25,NULL,'2023-03-29 11:28:59','2023-03-29 11:28:59',NULL),(2141,7730,743,40720,1527,3,68,1,1313.39,NULL,'2023-03-29 11:28:59','2023-03-29 11:28:59',NULL),(2142,7730,743,40720,1527,3,57,2,7567.64,NULL,'2023-03-29 11:28:59','2023-03-29 11:28:59',NULL),(2143,7730,744,40720,1527,3,392,1,4508.10,NULL,'2023-03-29 11:29:14','2023-03-29 13:12:50','2023-03-29 13:12:50'),(2144,7730,744,40720,1527,3,68,1,946.70,NULL,'2023-03-29 11:29:14','2023-03-29 13:12:50','2023-03-29 13:12:50'),(2145,7730,744,40720,1527,3,57,2,5454.80,NULL,'2023-03-29 11:29:14','2023-03-29 13:12:50','2023-03-29 13:12:50'),(2146,7730,745,40720,1527,3,392,1,5760.00,NULL,'2023-03-29 11:29:25','2023-03-29 11:29:25',NULL),(2147,7730,745,40720,1527,3,68,1,1209.60,NULL,'2023-03-29 11:29:25','2023-03-29 11:29:25',NULL),(2148,7730,745,40720,1527,3,57,2,6969.60,NULL,'2023-03-29 11:29:25','2023-03-29 11:29:25',NULL),(2149,7730,746,40720,1527,3,392,1,6254.25,NULL,'2023-03-29 11:29:38','2023-03-29 11:29:38',NULL),(2150,7730,746,40720,1527,3,68,1,1313.39,NULL,'2023-03-29 11:29:38','2023-03-29 11:29:38',NULL),(2151,7730,746,40720,1527,3,57,2,7567.64,NULL,'2023-03-29 11:29:38','2023-03-29 11:29:38',NULL),(2152,7730,747,40720,1527,3,392,1,5002.50,NULL,'2023-03-29 11:29:51','2023-03-29 11:29:51',NULL),(2153,7730,747,40720,1527,3,68,1,1050.53,NULL,'2023-03-29 11:29:51','2023-03-29 11:29:51',NULL),(2154,7730,747,40720,1527,3,57,2,6053.03,NULL,'2023-03-29 11:29:51','2023-03-29 11:29:51',NULL),(2155,7730,748,40720,1527,3,392,1,3846.00,NULL,'2023-03-29 11:30:03','2023-03-29 11:30:03',NULL),(2156,7730,748,40720,1527,3,68,1,807.66,NULL,'2023-03-29 11:30:03','2023-03-29 11:30:03',NULL),(2157,7730,748,40720,1527,3,57,2,4653.66,NULL,'2023-03-29 11:30:03','2023-03-29 11:30:03',NULL),(2158,7730,749,40720,1527,3,488,1,20212.12,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(2159,7730,749,40720,1527,3,68,1,4244.55,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(2160,7730,749,40720,1527,3,488,1,7410.75,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(2161,7730,749,40720,1527,3,220,1,606.36,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(2162,7730,749,40720,1527,3,221,1,4411.43,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(2163,7730,749,40720,1527,3,225,1,505.30,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(2164,7730,749,40720,1527,3,226,1,1887.66,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(2165,7730,749,40720,1527,3,57,2,39278.17,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(2166,7730,750,40720,1527,3,488,1,20212.12,NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(2167,7730,750,40720,1527,3,68,1,4244.55,NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(2168,7730,750,40720,1527,3,220,1,606.36,NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(2169,7730,750,40720,1527,3,221,1,4411.43,NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(2170,7730,750,40720,1527,3,225,1,505.30,NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(2171,7730,750,40720,1527,3,226,1,1887.66,NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(2172,7730,750,40720,1527,3,57,2,31867.42,NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(2173,7730,751,40720,1527,3,217,1,97.14,NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(2174,7730,751,40720,1527,3,68,1,26.23,NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48');
INSERT INTO `balance_libro_details` VALUES (2175,7730,751,40720,1527,3,217,1,865.86,NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(2176,7730,751,40720,1527,3,68,1,181.83,NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(2177,7730,751,40720,1527,3,217,1,29.92,NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(2178,7730,751,40720,1527,3,221,1,5.11,NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(2179,7730,751,40720,1527,3,57,2,1206.09,NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(2180,7730,752,40720,1527,3,489,1,97.14,NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(2181,7730,752,40720,1527,3,68,1,26.23,NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(2182,7730,752,40720,1527,3,489,1,865.86,NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(2183,7730,752,40720,1527,3,68,1,181.83,NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(2184,7730,752,40720,1527,3,489,1,29.92,NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(2185,7730,752,40720,1527,3,221,1,5.11,NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(2186,7730,752,40720,1527,3,57,2,1206.09,NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(2187,7730,753,40720,1527,21,57,1,20000.00,NULL,'2023-03-29 13:07:13','2023-03-29 13:07:13',NULL),(2188,7730,753,40720,1527,21,359,2,20000.00,NULL,'2023-03-29 13:07:13','2023-03-29 13:07:13',NULL),(2189,7730,754,40720,1527,3,498,1,20000.00,NULL,'2023-03-29 13:07:14','2023-03-29 13:07:14',NULL),(2190,7730,754,40720,1527,3,57,2,20000.00,NULL,'2023-03-29 13:07:14','2023-03-29 13:07:14',NULL),(2191,7730,755,40720,1527,21,57,1,31867.42,NULL,'2023-03-29 13:07:54','2023-03-29 13:07:54',NULL),(2192,7730,755,40720,1527,21,484,2,31867.42,NULL,'2023-03-29 13:07:54','2023-03-29 13:07:54',NULL),(2193,7730,756,40720,1527,3,488,1,20212.12,NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(2194,7730,756,40720,1527,3,68,1,4244.55,NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(2195,7730,756,40720,1527,3,220,1,606.36,NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(2196,7730,756,40720,1527,3,221,1,4411.43,NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(2197,7730,756,40720,1527,3,225,1,505.30,NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(2198,7730,756,40720,1527,3,226,1,1887.66,NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(2199,7730,756,40720,1527,3,57,2,31867.42,NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(2200,7730,757,40720,1527,21,57,1,11721.00,NULL,'2023-03-29 13:09:36','2023-03-29 13:09:36',NULL),(2201,7730,757,40720,1527,21,484,2,11721.00,NULL,'2023-03-29 13:09:36','2023-03-29 13:09:36',NULL),(2202,7730,758,40720,1527,3,392,1,3526.50,NULL,'2023-03-29 13:09:37','2023-03-29 13:09:37',NULL),(2203,7730,758,40720,1527,3,68,1,740.57,NULL,'2023-03-29 13:09:37','2023-03-29 13:09:37',NULL),(2204,7730,758,40720,1527,3,57,2,4267.07,NULL,'2023-03-29 13:09:37','2023-03-29 13:09:37',NULL),(2205,7730,759,40720,1527,21,57,1,67248.27,NULL,'2023-03-29 13:12:50','2023-03-29 13:19:28','2023-03-29 13:19:28'),(2206,7730,759,40720,1527,21,484,2,67248.27,NULL,'2023-03-29 13:12:50','2023-03-29 13:19:28','2023-03-29 13:19:28'),(2207,7730,760,40720,1527,3,392,1,4508.10,NULL,'2023-03-29 13:12:50','2023-03-29 13:21:22','2023-03-29 13:21:22'),(2208,7730,760,40720,1527,3,68,1,946.70,NULL,'2023-03-29 13:12:50','2023-03-29 13:21:22','2023-03-29 13:21:22'),(2209,7730,760,40720,1527,3,57,2,5454.80,NULL,'2023-03-29 13:12:50','2023-03-29 13:21:22','2023-03-29 13:21:22'),(2210,7730,761,40720,1527,21,57,1,1206.09,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:23','2023-03-29 14:54:23'),(2211,7730,761,40720,1527,21,484,2,1206.09,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:23','2023-03-29 14:54:23'),(2212,7730,762,40720,1527,3,489,1,97.14,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53');
INSERT INTO `balance_libro_details` VALUES (2213,7730,762,40720,1527,3,68,1,26.23,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(2214,7730,762,40720,1527,3,489,1,865.86,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(2215,7730,762,40720,1527,3,68,1,181.83,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(2216,7730,762,40720,1527,3,489,1,29.92,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(2217,7730,762,40720,1527,3,221,1,5.11,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(2218,7730,762,40720,1527,3,57,2,1206.09,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(2219,7730,763,40720,1527,22,497,1,100000.00,NULL,'2023-03-29 13:15:28','2023-03-29 13:15:28',NULL),(2220,7730,763,40720,1527,22,484,2,100000.00,NULL,'2023-03-29 13:15:28','2023-03-29 13:15:28',NULL),(2221,7730,764,40720,1527,21,57,1,67248.27,NULL,'2023-03-29 13:21:21','2023-03-29 13:21:21',NULL),(2222,7730,764,40720,1527,21,359,2,67248.27,NULL,'2023-03-29 13:21:21','2023-03-29 13:21:21',NULL),(2223,7730,765,40720,1527,3,392,1,4508.10,NULL,'2023-03-29 13:21:22','2023-03-29 13:21:22',NULL),(2224,7730,765,40720,1527,3,68,1,946.70,NULL,'2023-03-29 13:21:22','2023-03-29 13:21:22',NULL),(2225,7730,765,40720,1527,3,57,2,5454.80,NULL,'2023-03-29 13:21:22','2023-03-29 13:21:22',NULL),(2226,7730,766,40720,1527,2,359,1,1513750.00,NULL,'2023-03-29 13:24:22','2023-03-29 13:25:38','2023-03-29 13:25:38'),(2227,7730,766,40720,1527,2,485,2,1513750.00,NULL,'2023-03-29 13:24:22','2023-03-29 13:25:38','2023-03-29 13:25:38'),(2228,7730,767,40720,1527,2,359,1,1513750.00,NULL,'2023-03-29 13:25:38','2023-03-29 14:05:27','2023-03-29 14:05:27'),(2229,7730,767,40720,1527,2,485,2,1513750.00,NULL,'2023-03-29 13:25:38','2023-03-29 14:05:27','2023-03-29 14:05:27'),(2230,7730,768,40720,1525,21,57,1,1513750.00,NULL,'2023-03-29 13:30:40','2023-03-29 14:02:04','2023-03-29 14:02:04'),(2231,7730,768,40720,1525,21,359,2,1513750.00,NULL,'2023-03-29 13:30:40','2023-03-29 14:02:04','2023-03-29 14:02:04'),(2232,7730,769,40720,1527,18,57,1,28883.78,NULL,'2023-03-29 13:33:08','2023-03-29 13:35:27','2023-03-29 13:35:27'),(2233,7730,769,40720,1527,18,364,2,28883.78,NULL,'2023-03-29 13:33:08','2023-03-29 13:35:27','2023-03-29 13:35:27'),(2234,7730,770,40720,1527,18,364,1,1446.00,NULL,'2023-03-29 13:35:27','2023-03-29 13:45:00','2023-03-29 13:45:00'),(2235,7730,770,40720,1527,18,13,2,1446.00,NULL,'2023-03-29 13:35:27','2023-03-29 13:45:00','2023-03-29 13:45:00'),(2236,7730,771,40720,1527,18,13,1,1446.00,NULL,'2023-03-29 13:45:00','2023-03-29 13:51:40','2023-03-29 13:51:40'),(2237,7730,771,40720,1527,18,364,2,1446.00,NULL,'2023-03-29 13:45:00','2023-03-29 13:51:40','2023-03-29 13:51:40'),(2238,7730,772,40720,1527,18,27,1,28883.78,NULL,'2023-03-29 13:47:13','2023-03-29 13:47:13',NULL),(2239,7730,772,40720,1527,18,57,2,28883.78,NULL,'2023-03-29 13:47:13','2023-03-29 13:47:13',NULL),(2240,7730,773,40720,1525,21,485,1,1513750.00,NULL,'2023-03-29 14:04:43','2023-03-29 14:04:43',NULL),(2241,7730,773,40720,1525,21,359,2,1513750.00,NULL,'2023-03-29 14:04:43','2023-03-29 14:04:43',NULL),(2242,7730,774,40720,1525,2,359,1,1513750.00,NULL,'2023-03-29 14:05:27','2023-03-30 12:36:06','2023-03-30 12:36:06'),(2243,7730,774,40720,1525,2,485,2,1513750.00,NULL,'2023-03-29 14:05:27','2023-03-30 12:36:06','2023-03-30 12:36:06'),(2244,7730,775,40720,1527,5,437,1,615.00,NULL,'2023-03-29 14:14:02','2023-03-29 14:42:44','2023-03-29 14:42:44'),(2245,7730,775,40720,1527,5,277,1,1538.50,NULL,'2023-03-29 14:14:02','2023-03-29 14:42:44','2023-03-29 14:42:44'),(2246,7730,775,40720,1527,5,276,1,961.50,NULL,'2023-03-29 14:14:02','2023-03-29 14:42:44','2023-03-29 14:42:44'),(2247,7730,775,40720,1527,5,497,2,3115.00,NULL,'2023-03-29 14:14:02','2023-03-29 14:42:44','2023-03-29 14:42:44'),(2248,7730,776,40720,1526,5,437,1,1531.52,NULL,'2023-03-29 14:15:36','2023-03-29 14:15:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2249,7730,776,40720,1526,5,277,1,3912.38,NULL,'2023-03-29 14:15:36','2023-03-29 14:15:36',NULL),(2250,7730,776,40720,1526,5,276,1,1630.04,NULL,'2023-03-29 14:15:36','2023-03-29 14:15:36',NULL),(2251,7730,776,40720,1526,5,497,2,7073.94,NULL,'2023-03-29 14:15:36','2023-03-29 14:15:36',NULL),(2252,7730,777,40720,1525,5,437,1,1864.50,NULL,'2023-03-29 14:18:21','2023-03-29 14:18:21',NULL),(2253,7730,777,40720,1525,5,277,1,2019.70,NULL,'2023-03-29 14:18:21','2023-03-29 14:18:21',NULL),(2254,7730,777,40720,1525,5,497,2,3884.20,NULL,'2023-03-29 14:18:21','2023-03-29 14:18:21',NULL),(2255,7730,778,40720,1527,15,67,1,6335.93,NULL,'2023-03-29 14:34:19','2023-03-29 14:34:19',NULL),(2256,7730,778,40720,1527,15,68,2,12835.36,NULL,'2023-03-29 14:34:19','2023-03-29 14:34:19',NULL),(2257,7730,778,40720,1527,15,353,2,98099.30,NULL,'2023-03-29 14:34:19','2023-03-29 14:34:19',NULL),(2258,7730,778,40720,1527,15,354,2,12414.20,NULL,'2023-03-29 14:34:19','2023-03-29 14:34:19',NULL),(2259,7730,778,40720,1527,15,220,2,606.36,NULL,'2023-03-29 14:34:19','2023-03-29 14:34:19',NULL),(2260,7730,778,40720,1527,15,353,1,104598.73,NULL,'2023-03-29 14:34:19','2023-03-29 14:34:19',NULL),(2261,7730,778,40720,1527,15,354,1,13020.56,NULL,'2023-03-29 14:34:19','2023-03-29 14:34:19',NULL),(2262,7730,779,40720,1527,5,437,1,615.00,NULL,'2023-03-29 14:42:44','2023-03-29 15:05:30','2023-03-29 15:05:30'),(2263,7730,779,40720,1527,5,277,1,1538.49,NULL,'2023-03-29 14:42:44','2023-03-29 15:05:30','2023-03-29 15:05:30'),(2264,7730,779,40720,1527,5,276,1,961.51,NULL,'2023-03-29 14:42:44','2023-03-29 15:05:30','2023-03-29 15:05:30'),(2265,7730,779,40720,1527,5,497,2,3115.00,NULL,'2023-03-29 14:42:44','2023-03-29 15:05:30','2023-03-29 15:05:30'),(2266,7730,780,40720,1527,3,489,1,97.14,NULL,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(2267,7730,780,40720,1527,3,68,1,26.23,NULL,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(2268,7730,780,40720,1527,3,489,1,865.86,NULL,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(2269,7730,780,40720,1527,3,68,1,181.83,NULL,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(2270,7730,780,40720,1527,3,221,1,5.11,NULL,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(2271,7730,780,40720,1527,3,226,1,29.92,NULL,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(2272,7730,780,40720,1527,3,57,2,1206.09,NULL,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(2273,7730,781,40720,1527,21,57,1,1206.09,NULL,'2023-03-29 14:56:01','2023-03-29 14:56:01',NULL),(2274,7730,781,40720,1527,21,484,2,1206.09,NULL,'2023-03-29 14:56:01','2023-03-29 14:56:01',NULL),(2275,7730,782,40720,1527,5,437,1,615.00,NULL,'2023-03-29 15:05:30','2023-03-29 15:05:30',NULL),(2276,7730,782,40720,1527,5,277,1,1538.49,NULL,'2023-03-29 15:05:30','2023-03-29 15:05:30',NULL),(2277,7730,782,40720,1527,5,276,1,961.51,NULL,'2023-03-29 15:05:30','2023-03-29 15:05:30',NULL),(2278,7730,782,40720,1527,5,497,2,3115.00,NULL,'2023-03-29 15:05:30','2023-03-29 15:05:30',NULL),(2279,7730,783,40720,1527,16,208,1,1508.55,NULL,'2023-03-29 15:10:15','2023-03-29 15:10:15',NULL),(2280,7730,783,40720,1527,16,226,2,1917.58,NULL,'2023-03-29 15:10:15','2023-03-29 15:10:15',NULL),(2281,7730,783,40720,1527,16,277,2,1538.49,NULL,'2023-03-29 15:10:15','2023-03-29 15:10:15',NULL),(2282,7730,783,40720,1527,16,225,2,505.30,NULL,'2023-03-29 15:10:16','2023-03-29 15:10:16',NULL),(2283,7730,783,40720,1527,16,276,2,961.51,NULL,'2023-03-29 15:10:16','2023-03-29 15:10:16',NULL),(2284,7730,783,40720,1527,16,302,2,8343.45,NULL,'2023-03-29 15:10:16','2023-03-29 15:10:16',NULL),(2285,7730,783,40720,1527,16,302,1,11799.52,NULL,'2023-03-29 15:10:16','2023-03-29 15:10:16',NULL),(2286,7730,783,40720,1527,16,326,2,41.74,NULL,'2023-03-29 15:10:16','2023-03-29 15:10:16',NULL),(2287,7730,784,40720,1528,3,217,1,963.00,NULL,'2023-03-29 17:30:47','2023-03-29 17:32:16','2023-03-29 17:32:16'),(2288,7730,784,40720,1528,3,68,1,208.06,NULL,'2023-03-29 17:30:47','2023-03-29 17:32:16','2023-03-29 17:32:16');
INSERT INTO `balance_libro_details` VALUES (2289,7730,784,40720,1528,3,217,1,35.03,NULL,'2023-03-29 17:30:47','2023-03-29 17:32:16','2023-03-29 17:32:16'),(2290,7730,784,40720,1528,3,57,2,1206.09,NULL,'2023-03-29 17:30:47','2023-03-29 17:32:16','2023-03-29 17:32:16'),(2291,7730,785,40720,1528,3,489,1,97.14,NULL,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(2292,7730,785,40720,1528,3,68,1,26.23,NULL,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(2293,7730,785,40720,1528,3,489,1,865.86,NULL,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(2294,7730,785,40720,1528,3,68,1,181.83,NULL,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(2295,7730,785,40720,1528,3,221,1,5.11,NULL,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(2296,7730,785,40720,1528,3,226,1,29.92,NULL,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(2297,7730,785,40720,1528,3,57,2,1206.09,NULL,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(2298,7730,786,40720,1528,21,57,1,1206.09,NULL,'2023-03-29 17:36:56','2023-03-29 18:41:50','2023-03-29 18:41:50'),(2299,7730,786,40720,1528,21,484,2,1206.09,NULL,'2023-03-29 17:36:56','2023-03-29 18:41:50','2023-03-29 18:41:50'),(2300,7730,787,40720,1528,5,396,1,3252.96,NULL,'2023-03-29 17:41:58','2023-03-29 17:41:58',NULL),(2301,7730,787,40720,1528,5,437,1,19.52,NULL,'2023-03-29 17:41:58','2023-03-29 17:41:58',NULL),(2302,7730,787,40720,1528,5,497,2,3272.48,NULL,'2023-03-29 17:41:58','2023-03-29 17:41:58',NULL),(2303,7730,788,40720,1528,15,68,2,208.06,NULL,'2023-03-29 17:46:52','2023-03-29 17:48:06','2023-03-29 17:48:06'),(2304,7730,788,40720,1528,15,353,2,104598.70,NULL,'2023-03-29 17:46:52','2023-03-29 17:48:06','2023-03-29 17:48:06'),(2305,7730,788,40720,1528,15,354,2,13020.56,NULL,'2023-03-29 17:46:52','2023-03-29 17:48:06','2023-03-29 17:48:06'),(2306,7730,788,40720,1528,15,353,1,104806.76,NULL,'2023-03-29 17:46:52','2023-03-29 17:48:06','2023-03-29 17:48:06'),(2307,7730,788,40720,1528,15,354,1,13020.56,NULL,'2023-03-29 17:46:52','2023-03-29 17:48:06','2023-03-29 17:48:06'),(2308,7730,789,40720,1528,15,68,2,208.06,NULL,'2023-03-29 17:50:36','2023-03-29 17:50:36',NULL),(2309,7730,789,40720,1528,15,353,2,104598.73,NULL,'2023-03-29 17:50:36','2023-03-29 17:50:36',NULL),(2310,7730,789,40720,1528,15,354,2,13020.56,NULL,'2023-03-29 17:50:36','2023-03-29 17:50:36',NULL),(2311,7730,789,40720,1528,15,353,1,104806.79,NULL,'2023-03-29 17:50:36','2023-03-29 17:50:36',NULL),(2312,7730,789,40720,1528,15,354,1,13020.56,NULL,'2023-03-29 17:50:36','2023-03-29 17:50:36',NULL),(2313,7730,790,40720,1528,16,502,2,63.32,NULL,'2023-03-29 18:26:46','2023-03-29 18:26:46',NULL),(2314,7730,790,40720,1528,16,208,1,90.46,NULL,'2023-03-29 18:26:46','2023-03-29 18:26:46',NULL),(2315,7730,790,40720,1528,16,226,2,29.92,NULL,'2023-03-29 18:26:46','2023-03-29 18:26:46',NULL),(2316,7730,790,40720,1528,16,302,2,11799.52,NULL,'2023-03-29 18:26:46','2023-03-29 18:26:46',NULL),(2317,7730,790,40720,1528,16,302,1,11892.76,NULL,'2023-03-29 18:26:46','2023-03-29 18:26:46',NULL),(2318,7730,790,40720,1528,16,326,2,90.46,NULL,'2023-03-29 18:26:46','2023-03-29 18:26:46',NULL),(2319,7730,791,40720,1529,3,217,1,198.00,NULL,'2023-03-29 18:29:35','2023-03-29 18:41:12','2023-03-29 18:41:12'),(2320,7730,791,40720,1529,3,68,1,53.46,NULL,'2023-03-29 18:29:35','2023-03-29 18:41:12','2023-03-29 18:41:12'),(2321,7730,791,40720,1529,3,217,1,10.42,NULL,'2023-03-29 18:29:35','2023-03-29 18:41:12','2023-03-29 18:41:12'),(2322,7730,791,40720,1529,3,57,2,261.88,NULL,'2023-03-29 18:29:35','2023-03-29 18:41:12','2023-03-29 18:41:12'),(2323,7730,792,40720,1529,3,489,1,198.00,NULL,'2023-03-29 18:41:12','2023-03-29 18:41:12',NULL),(2324,7730,792,40720,1529,3,68,1,53.46,NULL,'2023-03-29 18:41:12','2023-03-29 18:41:12',NULL),(2325,7730,792,40720,1529,3,221,1,10.42,NULL,'2023-03-29 18:41:12','2023-03-29 18:41:12',NULL),(2326,7730,792,40720,1529,3,57,2,261.88,NULL,'2023-03-29 18:41:12','2023-03-29 18:41:12',NULL),(2327,7730,793,40720,1529,21,57,1,1206.09,NULL,'2023-03-29 18:42:54','2023-03-29 18:42:54',NULL);
INSERT INTO `balance_libro_details` VALUES (2328,7730,793,40720,1529,21,484,2,1206.09,NULL,'2023-03-29 18:42:54','2023-03-29 18:42:54',NULL),(2329,7730,794,40720,1529,5,396,1,1801.50,NULL,'2023-03-29 18:51:24','2023-03-29 18:51:24',NULL),(2330,7730,794,40720,1529,5,497,2,1801.50,NULL,'2023-03-29 18:51:24','2023-03-29 18:51:24',NULL),(2331,7730,795,40720,1529,15,68,2,53.46,NULL,'2023-03-29 19:02:34','2023-03-29 19:02:34',NULL),(2332,7730,795,40720,1529,15,353,2,104806.79,NULL,'2023-03-29 19:02:34','2023-03-29 19:02:34',NULL),(2333,7730,795,40720,1529,15,354,2,13020.56,NULL,'2023-03-29 19:02:34','2023-03-29 19:02:34',NULL),(2334,7730,795,40720,1529,15,353,1,104860.25,NULL,'2023-03-29 19:02:34','2023-03-29 19:02:34',NULL),(2335,7730,795,40720,1529,15,354,1,13020.56,NULL,'2023-03-29 19:02:34','2023-03-29 19:02:34',NULL),(2336,7730,796,40720,1529,16,302,2,4629.63,NULL,'2023-03-29 19:04:52','2023-03-29 19:05:32','2023-03-29 19:05:32'),(2337,7730,796,40720,1529,16,302,1,4629.63,NULL,'2023-03-29 19:04:52','2023-03-29 19:05:32','2023-03-29 19:05:32'),(2338,7730,797,40720,1529,16,302,2,11892.76,NULL,'2023-03-29 19:09:18','2023-03-29 19:09:18',NULL),(2339,7730,797,40720,1529,16,302,1,11892.76,NULL,'2023-03-29 19:09:18','2023-03-29 19:09:18',NULL),(2340,7730,798,40720,1530,3,217,1,1216.18,NULL,'2023-03-29 19:28:12','2023-03-29 20:01:23','2023-03-29 20:01:23'),(2341,7730,798,40720,1530,3,68,1,269.83,NULL,'2023-03-29 19:28:12','2023-03-29 20:01:23','2023-03-29 20:01:23'),(2342,7730,798,40720,1530,3,217,1,42.75,NULL,'2023-03-29 19:28:12','2023-03-29 20:01:23','2023-03-29 20:01:23'),(2343,7730,798,40720,1530,3,57,2,1528.76,NULL,'2023-03-29 19:28:12','2023-03-29 20:01:23','2023-03-29 20:01:23'),(2344,7730,799,40720,1530,3,489,1,240.62,NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(2345,7730,799,40720,1530,3,68,1,64.97,NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(2346,7730,799,40720,1530,3,489,1,975.56,NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(2347,7730,799,40720,1530,3,68,1,204.87,NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(2348,7730,799,40720,1530,3,489,1,42.75,NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(2349,7730,799,40720,1530,3,57,2,1528.76,NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(2350,7730,799,40720,1530,3,136,2,0.01,NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(2351,7730,800,40720,1530,3,489,1,240.62,NULL,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(2352,7730,800,40720,1530,3,68,1,64.97,NULL,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(2353,7730,800,40720,1530,3,489,1,975.56,NULL,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(2354,7730,800,40720,1530,3,68,1,204.87,NULL,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(2355,7730,800,40720,1530,3,221,1,42.75,NULL,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(2356,7730,800,40720,1530,3,57,2,1528.76,NULL,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(2357,7730,800,40720,1530,3,136,2,0.01,NULL,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(2358,7730,801,40720,1530,21,57,1,261.88,NULL,'2023-03-29 20:05:20','2023-03-29 20:05:20',NULL),(2359,7730,801,40720,1530,21,484,2,261.88,NULL,'2023-03-29 20:05:20','2023-03-29 20:05:20',NULL),(2360,7730,802,40720,1530,5,396,1,2634.42,NULL,'2023-03-29 20:07:09','2023-03-29 20:07:09',NULL),(2361,7730,802,40720,1530,5,497,2,2634.42,NULL,'2023-03-29 20:07:09','2023-03-29 20:07:09',NULL),(2362,7730,803,40720,1530,15,68,2,269.83,NULL,'2023-03-29 20:10:49','2023-03-29 20:10:49',NULL),(2363,7730,803,40720,1530,15,353,2,104860.25,NULL,'2023-03-29 20:10:49','2023-03-29 20:10:49',NULL),(2364,7730,803,40720,1530,15,354,2,13020.56,NULL,'2023-03-29 20:10:49','2023-03-29 20:10:49',NULL),(2365,7730,803,40720,1530,15,353,1,105130.08,NULL,'2023-03-29 20:10:49','2023-03-29 20:10:49',NULL),(2366,7730,803,40720,1530,15,354,1,13020.56,NULL,'2023-03-29 20:10:49','2023-03-29 20:10:49',NULL);
INSERT INTO `balance_libro_details` VALUES (2367,7730,804,40720,1530,16,302,2,11892.76,NULL,'2023-03-29 20:12:13','2023-03-29 20:12:13',NULL),(2368,7730,804,40720,1530,16,302,1,11892.76,NULL,'2023-03-29 20:12:13','2023-03-29 20:12:13',NULL),(2369,7730,805,40720,1531,3,217,1,277.20,NULL,'2023-03-29 20:18:01','2023-03-29 20:19:14','2023-03-29 20:19:14'),(2370,7730,805,40720,1531,3,68,1,74.84,NULL,'2023-03-29 20:18:01','2023-03-29 20:19:14','2023-03-29 20:19:14'),(2371,7730,805,40720,1531,3,217,1,14.59,NULL,'2023-03-29 20:18:01','2023-03-29 20:19:14','2023-03-29 20:19:14'),(2372,7730,805,40720,1531,3,57,2,366.63,NULL,'2023-03-29 20:18:01','2023-03-29 20:19:14','2023-03-29 20:19:14'),(2373,7730,806,40720,1531,3,217,1,277.20,NULL,'2023-03-29 20:19:14','2023-03-29 20:19:39','2023-03-29 20:19:39'),(2374,7730,806,40720,1531,3,68,1,74.84,NULL,'2023-03-29 20:19:14','2023-03-29 20:19:39','2023-03-29 20:19:39'),(2375,7730,806,40720,1531,3,221,1,14.59,NULL,'2023-03-29 20:19:14','2023-03-29 20:19:39','2023-03-29 20:19:39'),(2376,7730,806,40720,1531,3,57,2,366.63,NULL,'2023-03-29 20:19:14','2023-03-29 20:19:39','2023-03-29 20:19:39'),(2377,7730,807,40720,1531,3,489,1,277.20,NULL,'2023-03-29 20:19:39','2023-03-29 20:19:39',NULL),(2378,7730,807,40720,1531,3,68,1,74.84,NULL,'2023-03-29 20:19:39','2023-03-29 20:19:39',NULL),(2379,7730,807,40720,1531,3,221,1,14.59,NULL,'2023-03-29 20:19:39','2023-03-29 20:19:39',NULL),(2380,7730,807,40720,1531,3,57,2,366.63,NULL,'2023-03-29 20:19:39','2023-03-29 20:19:39',NULL),(2381,7730,808,40720,1531,21,57,1,1528.76,NULL,'2023-03-29 20:20:24','2023-03-29 20:20:24',NULL),(2382,7730,808,40720,1531,21,484,2,1528.76,NULL,'2023-03-29 20:20:24','2023-03-29 20:20:24',NULL),(2383,7730,809,40720,1531,5,396,1,2634.42,NULL,'2023-03-29 20:31:41','2023-03-29 20:31:41',NULL),(2384,7730,809,40720,1531,5,497,2,2634.42,NULL,'2023-03-29 20:31:41','2023-03-29 20:31:41',NULL),(2385,7730,810,40720,1531,15,68,2,74.84,NULL,'2023-03-29 20:33:55','2023-07-12 18:28:53','2023-07-12 18:28:53'),(2386,7730,810,40720,1531,15,353,2,105130.08,NULL,'2023-03-29 20:33:55','2023-07-12 18:28:53','2023-07-12 18:28:53'),(2387,7730,810,40720,1531,15,354,2,13020.56,NULL,'2023-03-29 20:33:55','2023-07-12 18:28:53','2023-07-12 18:28:53'),(2388,7730,810,40720,1531,15,353,1,105204.92,NULL,'2023-03-29 20:33:55','2023-07-12 18:28:53','2023-07-12 18:28:53'),(2389,7730,810,40720,1531,15,354,1,13020.56,NULL,'2023-03-29 20:33:55','2023-07-12 18:28:53','2023-07-12 18:28:53'),(2390,7730,811,40720,1531,16,302,2,11892.76,NULL,'2023-03-29 20:35:05','2023-03-29 20:35:05',NULL),(2391,7730,811,40720,1531,16,302,1,11892.76,NULL,'2023-03-29 20:35:05','2023-03-29 20:35:05',NULL),(2392,7730,812,40720,1532,21,57,1,366.63,NULL,'2023-03-29 20:37:23','2023-03-29 20:37:23',NULL),(2393,7730,812,40720,1532,21,484,2,366.63,NULL,'2023-03-29 20:37:23','2023-03-29 20:37:23',NULL),(2394,7730,813,40720,1532,5,396,1,2583.36,NULL,'2023-03-29 20:39:21','2023-03-29 20:39:21',NULL),(2395,7730,813,40720,1532,5,497,2,2583.36,NULL,'2023-03-29 20:39:21','2023-03-29 20:39:21',NULL),(2396,7730,814,40720,1528,10,74,1,914.98,NULL,'2023-03-29 21:19:10','2023-03-29 21:19:10',NULL),(2397,7730,814,40720,1528,10,503,1,165.73,NULL,'2023-03-29 21:19:10','2023-03-29 21:19:10',NULL),(2398,7730,814,40720,1528,10,359,2,1080.71,NULL,'2023-03-29 21:19:10','2023-03-29 21:19:10',NULL),(2399,7730,815,40720,1528,10,74,1,2063.93,NULL,'2023-03-29 21:32:40','2023-03-29 21:32:40',NULL),(2400,7730,815,40720,1528,10,359,2,2063.93,NULL,'2023-03-29 21:32:40','2023-03-29 21:32:40',NULL),(2401,7730,816,40720,1532,15,353,2,105204.92,NULL,'2023-03-29 21:40:20','2023-03-29 21:40:20',NULL),(2402,7730,816,40720,1532,15,354,2,13020.56,NULL,'2023-03-29 21:40:20','2023-03-29 21:40:20',NULL),(2403,7730,816,40720,1532,15,204,1,2560.06,NULL,'2023-03-29 21:40:20','2023-03-29 21:40:20',NULL),(2404,7730,816,40720,1532,15,353,1,105204.92,NULL,'2023-03-29 21:40:20','2023-03-29 21:40:20',NULL),(2405,7730,816,40720,1532,15,354,1,10460.50,NULL,'2023-03-29 21:40:20','2023-03-29 21:40:20',NULL);
INSERT INTO `balance_libro_details` VALUES (2406,7730,817,40720,1532,16,302,2,11892.76,NULL,'2023-03-29 21:41:37','2023-03-29 21:41:37',NULL),(2407,7730,817,40720,1532,16,302,1,11892.76,NULL,'2023-03-29 21:41:37','2023-03-29 21:41:37',NULL),(2408,7730,818,40720,1533,5,396,1,2538.36,NULL,'2023-03-29 22:33:02','2023-03-29 23:04:41','2023-03-29 23:04:41'),(2409,7730,818,40720,1533,5,497,2,2538.36,NULL,'2023-03-29 22:33:02','2023-03-29 23:04:41','2023-03-29 23:04:41'),(2410,7730,819,40720,1533,15,353,2,105204.92,NULL,'2023-03-29 22:43:09','2023-03-29 22:43:09',NULL),(2411,7730,819,40720,1533,15,354,2,10460.50,NULL,'2023-03-29 22:43:09','2023-03-29 22:43:09',NULL),(2412,7730,819,40720,1533,15,353,1,105204.92,NULL,'2023-03-29 22:43:09','2023-03-29 22:43:09',NULL),(2413,7730,819,40720,1533,15,354,1,10460.50,NULL,'2023-03-29 22:43:09','2023-03-29 22:43:09',NULL),(2414,7730,820,40720,1533,16,302,2,11892.76,NULL,'2023-03-29 22:44:23','2023-03-29 22:44:23',NULL),(2415,7730,820,40720,1533,16,302,1,11892.76,NULL,'2023-03-29 22:44:23','2023-03-29 22:44:23',NULL),(2416,7730,821,40720,1534,5,396,1,2593.58,NULL,'2023-03-29 22:46:10','2023-03-29 22:46:10',NULL),(2417,7730,821,40720,1534,5,497,2,2593.58,NULL,'2023-03-29 22:46:10','2023-03-29 22:46:10',NULL),(2418,7730,822,40720,1534,15,353,2,105204.92,NULL,'2023-03-29 22:48:59','2023-03-29 22:48:59',NULL),(2419,7730,822,40720,1534,15,354,2,10460.50,NULL,'2023-03-29 22:48:59','2023-03-29 22:48:59',NULL),(2420,7730,822,40720,1534,15,353,1,105204.92,NULL,'2023-03-29 22:48:59','2023-03-29 22:48:59',NULL),(2421,7730,822,40720,1534,15,354,1,10460.50,NULL,'2023-03-29 22:48:59','2023-03-29 22:48:59',NULL),(2422,7730,823,40720,1534,16,302,2,11892.76,NULL,'2023-03-29 22:50:01','2023-03-29 22:50:01',NULL),(2423,7730,823,40720,1534,16,302,1,11892.76,NULL,'2023-03-29 22:50:01','2023-03-29 22:50:01',NULL),(2424,7730,824,40720,1535,5,396,1,2593.58,NULL,'2023-03-29 22:51:24','2023-03-29 22:51:24',NULL),(2425,7730,824,40720,1535,5,497,2,2593.58,NULL,'2023-03-29 22:51:24','2023-03-29 22:51:24',NULL),(2426,7730,825,40720,1535,15,353,2,105204.92,NULL,'2023-03-29 22:53:01','2023-03-29 22:53:01',NULL),(2427,7730,825,40720,1535,15,354,2,10460.50,NULL,'2023-03-29 22:53:01','2023-03-29 22:53:01',NULL),(2428,7730,825,40720,1535,15,353,1,105204.92,NULL,'2023-03-29 22:53:01','2023-03-29 22:53:01',NULL),(2429,7730,825,40720,1535,15,354,1,10460.50,NULL,'2023-03-29 22:53:01','2023-03-29 22:53:01',NULL),(2430,7730,826,40720,1535,16,302,2,11892.76,NULL,'2023-03-29 22:53:50','2023-03-29 22:53:50',NULL),(2431,7730,826,40720,1535,16,302,1,11892.76,NULL,'2023-03-29 22:53:50','2023-03-29 22:53:50',NULL),(2432,7730,827,40720,1536,5,396,1,2593.58,NULL,'2023-03-29 22:55:04','2023-03-29 22:55:04',NULL),(2433,7730,827,40720,1536,5,497,2,2593.58,NULL,'2023-03-29 22:55:04','2023-03-29 22:55:04',NULL),(2434,7730,828,40720,1536,15,353,2,105204.92,NULL,'2023-03-29 22:56:10','2023-03-29 22:56:10',NULL),(2435,7730,828,40720,1536,15,354,2,10460.50,NULL,'2023-03-29 22:56:10','2023-03-29 22:56:10',NULL),(2436,7730,828,40720,1536,15,353,1,105204.92,NULL,'2023-03-29 22:56:10','2023-03-29 22:56:10',NULL),(2437,7730,828,40720,1536,15,354,1,10460.50,NULL,'2023-03-29 22:56:10','2023-03-29 22:56:10',NULL),(2438,7730,829,40720,1536,16,302,2,11892.76,NULL,'2023-03-29 22:57:10','2023-03-29 22:57:10',NULL),(2439,7730,829,40720,1536,16,302,1,11892.76,NULL,'2023-03-29 22:57:10','2023-03-29 22:57:10',NULL),(2440,7730,830,40720,1533,5,396,1,2583.36,NULL,'2023-03-29 23:04:41','2023-03-29 23:04:41',NULL),(2441,7730,830,40720,1533,5,497,2,2583.36,NULL,'2023-03-29 23:04:41','2023-03-29 23:04:41',NULL),(2442,7730,831,40720,1532,22,497,1,7279.12,NULL,'2023-03-29 23:07:22','2023-03-29 23:10:40','2023-03-29 23:10:40'),(2443,7730,831,40720,1532,22,484,2,7279.12,NULL,'2023-03-29 23:07:22','2023-03-29 23:10:40','2023-03-29 23:10:40'),(2444,7730,832,40720,1532,22,484,2,7279.12,NULL,'2023-03-29 23:10:40','2023-03-29 23:10:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2445,7730,832,40720,1532,22,359,1,7279.12,NULL,'2023-03-29 23:10:40','2023-03-29 23:10:40',NULL),(2446,7730,833,40720,1536,11,67,1,0.17,NULL,'2023-03-29 23:19:13','2023-03-29 23:24:19','2023-03-29 23:24:19'),(2447,7730,833,40720,1536,11,68,2,0.04,NULL,'2023-03-29 23:19:13','2023-03-29 23:24:19','2023-03-29 23:24:19'),(2448,7730,833,40720,1536,11,504,2,0.13,NULL,'2023-03-29 23:19:13','2023-03-29 23:24:19','2023-03-29 23:24:19'),(2449,7730,834,40720,1536,11,67,2,0.17,NULL,'2023-03-29 23:24:19','2023-03-29 23:43:22','2023-03-29 23:43:22'),(2450,7730,834,40720,1536,11,68,2,0.04,NULL,'2023-03-29 23:24:19','2023-03-29 23:43:22','2023-03-29 23:43:22'),(2451,7730,834,40720,1536,11,136,1,0.21,NULL,'2023-03-29 23:24:19','2023-03-29 23:43:22','2023-03-29 23:43:22'),(2452,7730,835,40720,1536,4,499,1,136990.95,NULL,'2023-03-29 23:29:08','2023-03-29 23:29:08',NULL),(2453,7730,835,40720,1536,4,415,2,136990.95,NULL,'2023-03-29 23:29:08','2023-03-29 23:29:08',NULL),(2454,7730,836,40720,1536,4,500,1,3300.00,NULL,'2023-03-29 23:30:20','2023-03-29 23:30:20',NULL),(2455,7730,836,40720,1536,4,52,2,3300.00,NULL,'2023-03-29 23:30:20','2023-03-29 23:30:20',NULL),(2456,7730,837,40720,1536,11,67,2,0.17,NULL,'2023-03-29 23:43:22','2023-03-29 23:43:22',NULL),(2457,7730,837,40720,1536,11,68,2,0.04,NULL,'2023-03-29 23:43:22','2023-03-29 23:43:22',NULL),(2458,7730,837,40720,1536,11,136,1,0.12,NULL,'2023-03-29 23:43:22','2023-03-29 23:43:22',NULL),(2459,7730,837,40720,1536,11,218,1,0.09,NULL,'2023-03-29 23:43:22','2023-03-29 23:43:22',NULL),(2460,7730,838,40720,1536,19,486,1,224630.22,NULL,'2023-03-30 11:51:31','2023-07-13 17:54:21','2023-07-13 17:54:21'),(2461,7730,838,40720,1536,19,392,2,224630.22,NULL,'2023-03-30 11:51:31','2023-07-13 17:54:21','2023-07-13 17:54:21'),(2462,7730,839,40720,1525,2,359,1,1600000.00,NULL,'2023-03-30 12:36:06','2023-03-30 12:36:06',NULL),(2463,7730,839,40720,1525,2,485,2,1600000.00,NULL,'2023-03-30 12:36:06','2023-03-30 12:36:06',NULL),(2464,7730,840,40720,1529,7,23,1,99.99,NULL,'2023-04-11 22:49:14','2023-04-12 00:09:39','2023-04-12 00:09:39'),(2465,7730,840,40720,1529,7,359,2,99.99,NULL,'2023-04-11 22:49:14','2023-04-12 00:09:39','2023-04-12 00:09:39'),(2466,7730,841,40720,1529,6,24,1,99.99,NULL,'2023-04-11 22:51:14','2023-04-12 00:10:07','2023-04-12 00:10:07'),(2467,7730,841,40720,1529,6,23,2,99.99,NULL,'2023-04-11 22:51:14','2023-04-12 00:10:07','2023-04-12 00:10:07'),(2468,7730,842,40720,1536,19,155,1,38385.28,NULL,'2023-04-11 22:53:44','2023-07-13 18:00:24','2023-07-13 18:00:24'),(2469,7730,842,40720,1536,19,411,2,38385.28,NULL,'2023-04-11 22:53:44','2023-07-13 18:00:24','2023-07-13 18:00:24'),(2470,7730,843,40720,1529,6,24,1,99.99,NULL,'2023-04-12 00:10:07','2023-07-11 18:16:53','2023-07-11 18:16:53'),(2471,7730,843,40720,1529,6,359,2,99.99,NULL,'2023-04-12 00:10:07','2023-07-11 18:16:53','2023-07-11 18:16:53'),(2472,7730,844,40720,1529,6,24,1,99.99,NULL,'2023-07-11 18:16:53','2023-07-11 18:17:32','2023-07-11 18:17:32'),(2473,7730,844,40720,1529,6,359,2,99.99,NULL,'2023-07-11 18:16:53','2023-07-11 18:17:32','2023-07-11 18:17:32'),(2474,7730,845,40720,1529,6,24,1,99.99,NULL,'2023-07-11 18:17:32','2023-07-11 18:17:32',NULL),(2475,7730,845,40720,1529,6,359,2,99.99,NULL,'2023-07-11 18:17:32','2023-07-11 18:17:32',NULL),(2476,7730,846,40720,1531,15,68,2,74.84,NULL,'2023-07-12 18:28:53','2023-07-12 18:29:41','2023-07-12 18:29:41'),(2477,7730,846,40720,1531,15,353,2,105130.08,NULL,'2023-07-12 18:28:53','2023-07-12 18:29:41','2023-07-12 18:29:41'),(2478,7730,846,40720,1531,15,354,2,10460.50,NULL,'2023-07-12 18:28:53','2023-07-12 18:29:41','2023-07-12 18:29:41'),(2479,7730,846,40720,1531,15,353,1,105204.92,NULL,'2023-07-12 18:28:53','2023-07-12 18:29:41','2023-07-12 18:29:41'),(2480,7730,846,40720,1531,15,354,1,13020.56,NULL,'2023-07-12 18:28:53','2023-07-12 18:29:41','2023-07-12 18:29:41'),(2481,7730,846,40720,1531,15,204,2,2560.06,NULL,'2023-07-12 18:28:53','2023-07-12 18:29:41','2023-07-12 18:29:41');
INSERT INTO `balance_libro_details` VALUES (2482,7730,847,40720,1531,15,68,2,74.84,NULL,'2023-07-12 18:29:41','2023-07-12 18:29:41',NULL),(2483,7730,847,40720,1531,15,353,2,105130.08,NULL,'2023-07-12 18:29:41','2023-07-12 18:29:41',NULL),(2484,7730,847,40720,1531,15,354,2,13020.56,NULL,'2023-07-12 18:29:41','2023-07-12 18:29:41',NULL),(2485,7730,847,40720,1531,15,353,1,105204.92,NULL,'2023-07-12 18:29:41','2023-07-12 18:29:41',NULL),(2486,7730,847,40720,1531,15,354,1,13020.56,NULL,'2023-07-12 18:29:41','2023-07-12 18:29:41',NULL),(2487,7730,848,40720,1536,19,486,1,239786.99,NULL,'2023-07-13 17:54:21','2023-07-13 17:54:21',NULL),(2488,7730,848,40720,1536,19,392,2,239786.99,NULL,'2023-07-13 17:54:21','2023-07-13 17:54:21',NULL),(2489,7730,849,40720,1536,19,155,1,34596.09,NULL,'2023-07-13 18:19:43','2023-07-13 18:19:43',NULL),(2490,7730,849,40720,1536,19,411,2,34596.09,NULL,'2023-07-13 18:19:43','2023-07-13 18:19:43',NULL),(2491,7730,850,40720,1536,19,135,1,0.11,NULL,'2023-07-17 16:17:30','2023-07-17 16:17:30',NULL),(2492,7730,850,40720,1536,19,136,2,0.11,NULL,'2023-07-17 16:17:30','2023-07-17 16:17:30',NULL),(2493,7730,851,40720,1536,23,392,1,46084.54,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2494,7730,851,40720,1536,23,486,1,120330.25,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2495,7730,851,40720,1536,23,495,1,8405.37,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2496,7730,851,40720,1536,23,52,2,3362.15,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2497,7730,851,40720,1536,23,500,1,1681.07,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2498,7730,851,40720,1536,23,391,1,697854.28,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2499,7730,851,40720,1536,23,415,2,139570.86,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2500,7730,851,40720,1536,23,499,1,69785.43,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2501,7730,851,40720,1536,23,383,1,98154.31,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2502,7730,851,40720,1536,23,88,2,249691.29,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2503,7730,851,40720,1536,23,96,2,155903.44,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2504,7730,851,40720,1536,23,489,1,1786.16,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2505,7730,851,40720,1536,23,498,1,23752.25,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2506,7730,851,40720,1536,23,488,1,29948.52,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2507,7730,851,40720,1536,23,188,1,1345.27,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2508,7730,851,40720,1536,23,212,1,63.02,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2509,7730,851,40720,1536,23,214,2,3747.65,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2510,7730,851,40720,1536,23,396,1,3241.24,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2511,7730,851,40720,1536,23,503,1,47.06,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2512,7730,851,40720,1536,23,502,1,810.44,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2513,7730,851,40720,1536,23,208,1,6637.40,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2514,7730,851,40720,1536,23,204,1,361.46,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2515,7730,851,40720,1536,23,221,1,1504.92,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2516,7730,851,40720,1536,23,501,2,559517.60,NULL,'2023-08-01 16:06:55','2023-08-01 16:06:55',NULL),(2517,7730,852,40720,1536,17,96,1,527123.76,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2518,7730,852,40720,1536,17,488,2,104779.24,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2519,7730,852,40720,1536,17,499,2,206776.38,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2520,7730,852,40720,1536,17,489,2,7389.38,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2521,7730,852,40720,1536,17,486,2,360117.24,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2522,7730,852,40720,1536,17,498,2,83752.25,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2523,7730,852,40720,1536,17,500,2,4981.07,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2524,7730,852,40720,1536,17,135,2,0.11,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2525,7730,852,40720,1536,17,188,2,4330.27,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2526,7730,852,40720,1536,17,212,2,220.32,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2527,7730,852,40720,1536,17,214,1,13102.49,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2528,7730,852,40720,1536,17,396,2,26512.00,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2529,7730,852,40720,1536,17,502,2,2642.42,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2530,7730,852,40720,1536,17,155,2,34596.09,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2531,7730,852,40720,1536,17,503,2,212.79,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2532,7730,852,40720,1536,17,204,2,2921.52,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2533,7730,852,40720,1536,17,221,2,6004.55,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2534,7730,852,40720,1536,17,208,2,22581.31,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2535,7730,852,40720,1536,17,501,1,559517.60,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2536,7730,852,40720,1536,17,91,2,231926.91,NULL,'2023-08-01 16:29:56','2023-08-01 16:29:56',NULL),(2537,7730,853,40720,1536,17,359,2,168254.37,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2538,7730,853,40720,1536,17,497,2,168909.53,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2539,7730,853,40720,1536,17,24,2,99.99,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2540,7730,853,40720,1536,17,27,2,28883.78,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2541,7730,853,40720,1536,17,437,2,5165.43,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2542,7730,853,40720,1536,17,302,2,11892.76,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2543,7730,853,40720,1536,17,353,2,105204.92,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2544,7730,853,40720,1536,17,354,2,10460.50,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2545,7730,853,40720,1536,17,392,2,167196.32,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2546,7730,853,40720,1536,17,495,2,24905.37,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2547,7730,853,40720,1536,17,391,2,2067763.78,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2548,7730,853,40720,1536,17,415,1,413552.76,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2549,7730,853,40720,1536,17,52,1,9962.15,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2550,7730,853,40720,1536,17,74,1,791.47,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2551,7730,853,40720,1536,17,326,1,18531.45,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2552,7730,853,40720,1536,17,327,1,367.16,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2553,7730,853,40720,1536,17,411,1,34596.09,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2554,7730,853,40720,1536,17,485,1,1600000.00,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2555,7730,853,40720,1536,17,369,1,400000.00,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2556,7730,853,40720,1536,17,88,1,339843.01,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2557,7730,853,40720,1536,17,383,2,290834.25,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2558,7730,853,40720,1536,17,91,1,231926.91,NULL,'2023-08-01 17:12:36','2023-08-01 17:12:36',NULL),(2559,7730,854,40720,1540,12,359,1,168254.37,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2560,7730,854,40720,1540,12,497,1,168909.53,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2561,7730,854,40720,1540,12,24,1,99.99,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40');
INSERT INTO `balance_libro_details` VALUES (2562,7730,854,40720,1540,12,27,1,28883.78,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2563,7730,854,40720,1540,12,437,1,5165.43,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2564,7730,854,40720,1540,12,302,1,11892.76,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2565,7730,854,40720,1540,12,353,1,105204.92,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2566,7730,854,40720,1540,12,354,1,10460.50,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2567,7730,854,40720,1540,12,392,1,167196.32,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2568,7730,854,40720,1540,12,495,1,24905.37,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2569,7730,854,40720,1540,12,52,2,690972.97,NULL,'2023-08-01 19:18:25','2023-08-02 09:37:40','2023-08-02 09:37:40'),(2614,7730,859,40720,1540,12,359,1,168254.37,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2615,7730,859,40720,1540,12,497,1,168909.53,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2616,7730,859,40720,1540,12,24,1,99.99,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2617,7730,859,40720,1540,12,27,1,28883.78,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2618,7730,859,40720,1540,12,437,1,5165.43,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2619,7730,859,40720,1540,12,302,1,11892.76,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2620,7730,859,40720,1540,12,353,1,105204.92,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2621,7730,859,40720,1540,12,354,1,10460.50,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2622,7730,859,40720,1540,12,392,1,167196.32,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2623,7730,859,40720,1540,12,495,1,24905.37,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2624,7730,859,40720,1540,12,52,2,690972.97,NULL,'2023-08-02 09:37:40','2023-08-02 09:44:01','2023-08-02 09:44:01'),(2636,7730,861,40720,1540,12,359,1,168254.37,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2637,7730,861,40720,1540,12,497,1,168909.53,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2638,7730,861,40720,1540,12,24,1,99.99,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2639,7730,861,40720,1540,12,27,1,28883.78,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2640,7730,861,40720,1540,12,437,1,5165.43,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2641,7730,861,40720,1540,12,302,1,11892.76,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2642,7730,861,40720,1540,12,353,1,105204.92,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2643,7730,861,40720,1540,12,354,1,10460.50,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2644,7730,861,40720,1540,12,392,1,167196.32,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2645,7730,861,40720,1540,12,495,1,24905.37,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2646,7730,861,40720,1540,12,52,2,9962.15,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2647,7730,861,40720,1540,12,391,1,2067763.78,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2648,7730,861,40720,1540,12,415,2,413552.76,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2649,7730,861,40720,1540,12,74,2,791.47,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2650,7730,861,40720,1540,12,326,2,18531.45,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2651,7730,861,40720,1540,12,327,2,367.16,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2652,7730,861,40720,1540,12,411,2,34596.09,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2653,7730,861,40720,1540,12,485,2,1600000.00,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL);
INSERT INTO `balance_libro_details` VALUES (2654,7730,861,40720,1540,12,369,2,400000.00,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2655,7730,861,40720,1540,12,88,2,339843.01,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2656,7730,861,40720,1540,12,383,1,58907.34,NULL,'2023-08-02 09:44:01','2023-08-02 09:44:01',NULL),(2657,7730,862,40720,1540,5,396,1,2850.00,NULL,'2023-08-03 11:12:38','2023-08-03 11:23:52','2023-08-03 11:23:52'),(2658,7730,863,40720,1540,5,396,1,2850.00,NULL,'2023-08-03 11:23:52','2023-08-03 11:25:48','2023-08-03 11:25:48'),(2659,7730,863,40720,1540,5,505,1,85.50,NULL,'2023-08-03 11:23:52','2023-08-03 11:25:48','2023-08-03 11:25:48'),(2660,7730,863,40720,1540,5,68,1,598.50,NULL,'2023-08-03 11:23:52','2023-08-03 11:25:48','2023-08-03 11:25:48'),(2661,7730,863,40720,1540,5,437,1,21.71,NULL,'2023-08-03 11:23:52','2023-08-03 11:25:48','2023-08-03 11:25:48'),(2662,7730,863,40720,1540,5,497,2,3555.71,NULL,'2023-08-03 11:23:52','2023-08-03 11:25:48','2023-08-03 11:25:48'),(2663,7730,864,40720,1540,5,396,1,2850.00,NULL,'2023-08-03 11:25:48','2023-08-03 11:25:48',NULL),(2664,7730,864,40720,1540,5,505,1,85.50,NULL,'2023-08-03 11:25:48','2023-08-03 11:25:48',NULL),(2665,7730,864,40720,1540,5,68,1,598.50,NULL,'2023-08-03 11:25:48','2023-08-03 11:25:48',NULL),(2666,7730,864,40720,1540,5,437,1,21.71,NULL,'2023-08-03 11:25:48','2023-08-03 11:25:48',NULL),(2667,7730,864,40720,1540,5,506,1,85.50,NULL,'2023-08-03 11:25:48','2023-08-03 11:25:48',NULL),(2668,7730,864,40720,1540,5,497,2,3641.21,NULL,'2023-08-03 11:25:48','2023-08-03 11:25:48',NULL),(2669,7730,865,40720,1540,15,68,2,598.50,NULL,'2023-08-03 11:33:40','2023-08-03 11:33:40',NULL),(2670,7730,865,40720,1540,15,506,2,85.50,NULL,'2023-08-03 11:33:40','2023-08-03 11:33:40',NULL),(2671,7730,865,40720,1540,15,353,2,105204.92,NULL,'2023-08-03 11:33:40','2023-08-03 11:33:40',NULL),(2672,7730,865,40720,1540,15,354,2,10460.50,NULL,'2023-08-03 11:33:40','2023-08-03 11:33:40',NULL),(2673,7730,865,40720,1540,15,353,1,105803.42,NULL,'2023-08-03 11:33:40','2023-08-03 11:33:40',NULL),(2674,7730,865,40720,1540,15,354,1,10546.00,NULL,'2023-08-03 11:33:40','2023-08-03 11:33:40',NULL),(2675,7730,866,40720,1540,16,505,2,85.50,NULL,'2023-08-03 11:37:36','2023-08-03 11:37:36',NULL),(2676,7730,866,40720,1540,16,302,2,11892.76,NULL,'2023-08-03 11:37:36','2023-08-03 11:37:36',NULL),(2677,7730,866,40720,1540,16,302,1,11892.76,NULL,'2023-08-03 11:37:36','2023-08-03 11:37:36',NULL),(2678,7730,866,40720,1540,16,301,1,85.50,NULL,'2023-08-03 11:37:36','2023-08-03 11:37:36',NULL),(2679,7730,867,40720,1541,5,396,1,2850.00,NULL,'2023-08-03 13:44:54','2023-08-03 13:58:10','2023-08-03 13:58:10'),(2680,7730,867,40720,1541,5,505,1,85.50,NULL,'2023-08-03 13:44:54','2023-08-03 13:58:10','2023-08-03 13:58:10'),(2681,7730,867,40720,1541,5,68,1,598.50,NULL,'2023-08-03 13:44:54','2023-08-03 13:58:10','2023-08-03 13:58:10'),(2682,7730,867,40720,1541,5,506,1,85.50,NULL,'2023-08-03 13:44:54','2023-08-03 13:58:10','2023-08-03 13:58:10'),(2683,7730,867,40720,1541,5,497,2,3619.50,NULL,'2023-08-03 13:44:54','2023-08-03 13:58:10','2023-08-03 13:58:10'),(2684,7730,868,40720,1541,15,68,2,598.50,NULL,'2023-08-03 13:47:53','2023-08-03 13:58:52','2023-08-03 13:58:52'),(2685,7730,868,40720,1541,15,506,2,85.50,NULL,'2023-08-03 13:47:53','2023-08-03 13:58:52','2023-08-03 13:58:52'),(2686,7730,868,40720,1541,15,353,2,105803.42,NULL,'2023-08-03 13:47:53','2023-08-03 13:58:52','2023-08-03 13:58:52'),(2687,7730,868,40720,1541,15,354,2,10546.00,NULL,'2023-08-03 13:47:53','2023-08-03 13:58:52','2023-08-03 13:58:52'),(2688,7730,868,40720,1541,15,353,1,106401.92,NULL,'2023-08-03 13:47:53','2023-08-03 13:58:52','2023-08-03 13:58:52'),(2689,7730,868,40720,1541,15,354,1,10631.50,NULL,'2023-08-03 13:47:53','2023-08-03 13:58:52','2023-08-03 13:58:52'),(2690,7730,869,40720,1541,16,505,2,85.50,NULL,'2023-08-03 13:57:18','2023-08-03 13:57:18',NULL),(2691,7730,869,40720,1541,16,302,2,11892.76,NULL,'2023-08-03 13:57:18','2023-08-03 13:57:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2692,7730,869,40720,1541,16,301,2,85.50,NULL,'2023-08-03 13:57:18','2023-08-03 13:57:18',NULL),(2693,7730,869,40720,1541,16,302,1,11892.76,NULL,'2023-08-03 13:57:18','2023-08-03 13:57:18',NULL),(2694,7730,869,40720,1541,16,301,1,171.00,NULL,'2023-08-03 13:57:18','2023-08-03 13:57:18',NULL),(2695,7730,870,40720,1541,5,396,1,2850.00,NULL,'2023-08-03 13:58:10','2023-08-03 13:58:10',NULL),(2696,7730,870,40720,1541,5,505,1,85.50,NULL,'2023-08-03 13:58:10','2023-08-03 13:58:10',NULL),(2697,7730,870,40720,1541,5,68,1,598.50,NULL,'2023-08-03 13:58:10','2023-08-03 13:58:10',NULL),(2698,7730,870,40720,1541,5,506,1,85.50,NULL,'2023-08-03 13:58:10','2023-08-03 13:58:10',NULL),(2699,7730,870,40720,1541,5,437,1,21.71,NULL,'2023-08-03 13:58:10','2023-08-03 13:58:10',NULL),(2700,7730,870,40720,1541,5,497,2,3641.21,NULL,'2023-08-03 13:58:10','2023-08-03 13:58:10',NULL),(2701,7730,871,40720,1541,15,68,2,598.50,NULL,'2023-08-03 13:58:52','2023-08-03 13:58:52',NULL),(2702,7730,871,40720,1541,15,506,2,85.50,NULL,'2023-08-03 13:58:52','2023-08-03 13:58:52',NULL),(2703,7730,871,40720,1541,15,353,2,105803.42,NULL,'2023-08-03 13:58:52','2023-08-03 13:58:52',NULL),(2704,7730,871,40720,1541,15,354,2,10546.00,NULL,'2023-08-03 13:58:52','2023-08-03 13:58:52',NULL),(2705,7730,871,40720,1541,15,353,1,106401.92,NULL,'2023-08-03 13:58:52','2023-08-03 13:58:52',NULL),(2706,7730,871,40720,1541,15,354,1,10631.50,NULL,'2023-08-03 13:58:52','2023-08-03 13:58:52',NULL),(2707,7730,872,40720,1542,5,396,1,2850.00,NULL,'2023-08-03 14:10:13','2023-08-03 14:10:13',NULL),(2708,7730,872,40720,1542,5,505,1,85.50,NULL,'2023-08-03 14:10:13','2023-08-03 14:10:13',NULL),(2709,7730,872,40720,1542,5,68,1,598.50,NULL,'2023-08-03 14:10:13','2023-08-03 14:10:13',NULL),(2710,7730,872,40720,1542,5,506,1,85.50,NULL,'2023-08-03 14:10:13','2023-08-03 14:10:13',NULL),(2711,7730,872,40720,1542,5,437,1,21.71,NULL,'2023-08-03 14:10:13','2023-08-03 14:10:13',NULL),(2712,7730,872,40720,1542,5,497,2,3641.21,NULL,'2023-08-03 14:10:13','2023-08-03 14:10:13',NULL),(2713,7730,873,40720,1542,15,68,2,598.50,NULL,'2023-08-03 14:20:35','2023-08-03 14:20:35',NULL),(2714,7730,873,40720,1542,15,506,2,85.50,NULL,'2023-08-03 14:20:35','2023-08-03 14:20:35',NULL),(2715,7730,873,40720,1542,15,353,2,106401.92,NULL,'2023-08-03 14:20:35','2023-08-03 14:20:35',NULL),(2716,7730,873,40720,1542,15,354,2,10631.50,NULL,'2023-08-03 14:20:35','2023-08-03 14:20:35',NULL),(2717,7730,873,40720,1542,15,353,1,107000.42,NULL,'2023-08-03 14:20:35','2023-08-03 14:20:35',NULL),(2718,7730,873,40720,1542,15,354,1,10717.00,NULL,'2023-08-03 14:20:35','2023-08-03 14:20:35',NULL),(2719,7730,874,40720,1542,16,505,2,85.50,NULL,'2023-08-03 14:24:36','2023-08-03 14:24:36',NULL),(2720,7730,874,40720,1542,16,302,2,11892.76,NULL,'2023-08-03 14:24:36','2023-08-03 14:24:36',NULL),(2721,7730,874,40720,1542,16,301,2,171.00,NULL,'2023-08-03 14:24:36','2023-08-03 14:24:36',NULL),(2722,7730,874,40720,1542,16,302,1,11892.76,NULL,'2023-08-03 14:24:36','2023-08-03 14:24:36',NULL),(2723,7730,874,40720,1542,16,301,1,256.50,NULL,'2023-08-03 14:24:36','2023-08-03 14:24:36',NULL),(2724,7730,875,40720,1543,5,396,1,2850.00,NULL,'2023-08-03 14:27:45','2023-08-03 14:27:45',NULL),(2725,7730,875,40720,1543,5,505,1,85.50,NULL,'2023-08-03 14:27:45','2023-08-03 14:27:45',NULL),(2726,7730,875,40720,1543,5,68,1,598.50,NULL,'2023-08-03 14:27:45','2023-08-03 14:27:45',NULL),(2727,7730,875,40720,1543,5,506,1,85.50,NULL,'2023-08-03 14:27:45','2023-08-03 14:27:45',NULL),(2728,7730,875,40720,1543,5,437,1,21.71,NULL,'2023-08-03 14:27:45','2023-08-03 14:27:45',NULL),(2729,7730,875,40720,1543,5,497,2,3641.21,NULL,'2023-08-03 14:27:45','2023-08-03 14:27:45',NULL),(2730,7730,876,40720,1543,21,203,1,5861.26,NULL,'2023-08-03 16:30:53','2023-08-04 00:10:39','2023-08-04 00:10:39'),(2731,7730,876,40720,1543,21,74,1,791.47,NULL,'2023-08-03 16:30:53','2023-08-04 00:10:39','2023-08-04 00:10:39');
INSERT INTO `balance_libro_details` VALUES (2732,7730,876,40720,1543,21,359,1,361.93,NULL,'2023-08-03 16:30:53','2023-08-04 00:10:39','2023-08-04 00:10:39'),(2733,7730,876,40720,1543,21,437,1,42.09,NULL,'2023-08-03 16:30:53','2023-08-04 00:10:39','2023-08-04 00:10:39'),(2734,7730,876,40720,1543,21,497,2,7056.75,NULL,'2023-08-03 16:30:53','2023-08-04 00:10:39','2023-08-04 00:10:39'),(2735,7730,877,40720,1543,15,68,2,598.50,NULL,'2023-08-03 17:34:46','2023-08-03 17:34:46',NULL),(2736,7730,877,40720,1543,15,506,2,85.50,NULL,'2023-08-03 17:34:46','2023-08-03 17:34:46',NULL),(2737,7730,877,40720,1543,15,353,2,107000.42,NULL,'2023-08-03 17:34:46','2023-08-03 17:34:46',NULL),(2738,7730,877,40720,1543,15,354,2,10717.00,NULL,'2023-08-03 17:34:46','2023-08-03 17:34:46',NULL),(2739,7730,877,40720,1543,15,353,1,107598.92,NULL,'2023-08-03 17:34:46','2023-08-03 17:34:46',NULL),(2740,7730,877,40720,1543,15,354,1,10802.50,NULL,'2023-08-03 17:34:46','2023-08-03 17:34:46',NULL),(2741,7730,878,40720,1543,16,505,2,85.50,NULL,'2023-08-03 17:38:05','2023-08-03 17:38:05',NULL),(2742,7730,878,40720,1543,16,302,2,11892.76,NULL,'2023-08-03 17:38:05','2023-08-03 17:38:05',NULL),(2743,7730,878,40720,1543,16,301,2,256.50,NULL,'2023-08-03 17:38:05','2023-08-03 17:38:05',NULL),(2744,7730,878,40720,1543,16,302,1,11892.76,NULL,'2023-08-03 17:38:05','2023-08-03 17:38:05',NULL),(2745,7730,878,40720,1543,16,301,1,342.00,NULL,'2023-08-03 17:38:05','2023-08-03 17:38:05',NULL),(2746,7730,879,40720,1544,5,396,1,2850.00,NULL,'2023-08-03 17:40:40','2023-08-03 17:40:40',NULL),(2747,7730,879,40720,1544,5,505,1,85.50,NULL,'2023-08-03 17:40:40','2023-08-03 17:40:40',NULL),(2748,7730,879,40720,1544,5,68,1,598.50,NULL,'2023-08-03 17:40:40','2023-08-03 17:40:40',NULL),(2749,7730,879,40720,1544,5,506,1,85.50,NULL,'2023-08-03 17:40:40','2023-08-03 17:40:40',NULL),(2750,7730,879,40720,1544,5,437,1,21.71,NULL,'2023-08-03 17:40:40','2023-08-03 17:40:40',NULL),(2751,7730,879,40720,1544,5,497,2,3641.21,NULL,'2023-08-03 17:40:40','2023-08-03 17:40:40',NULL),(2752,7730,880,40720,1544,21,326,1,217.85,NULL,'2023-08-03 17:44:43','2023-08-03 17:44:43',NULL),(2753,7730,880,40720,1544,21,497,2,217.85,NULL,'2023-08-03 17:44:43','2023-08-03 17:44:43',NULL),(2754,7730,881,40720,1544,21,326,1,198.97,NULL,'2023-08-03 17:49:23','2023-08-03 17:52:44','2023-08-03 17:52:44'),(2755,7730,881,40720,1544,21,497,2,240.75,NULL,'2023-08-03 17:49:23','2023-08-03 17:52:44','2023-08-03 17:52:44'),(2756,7730,881,40720,1544,21,301,1,41.78,NULL,'2023-08-03 17:49:23','2023-08-03 17:52:44','2023-08-03 17:52:44'),(2757,7730,882,40720,1544,21,326,1,198.97,NULL,'2023-08-03 17:52:44','2023-08-03 17:52:44',NULL),(2758,7730,882,40720,1544,21,497,2,240.75,NULL,'2023-08-03 17:52:44','2023-08-03 17:52:44',NULL),(2759,7730,882,40720,1544,21,135,1,41.78,NULL,'2023-08-03 17:52:44','2023-08-03 17:52:44',NULL),(2760,7730,883,40720,1544,21,327,1,262.55,NULL,'2023-08-03 18:16:32','2023-08-03 18:16:32',NULL),(2761,7730,883,40720,1544,21,497,2,591.46,NULL,'2023-08-03 18:16:32','2023-08-03 18:16:32',NULL),(2762,7730,883,40720,1544,21,135,1,328.91,NULL,'2023-08-03 18:16:32','2023-08-03 18:16:32',NULL),(2763,7730,884,40720,1544,21,326,1,1909.70,NULL,'2023-08-03 18:47:20','2023-08-03 19:02:04','2023-08-03 19:02:04'),(2764,7730,884,40720,1544,21,327,1,104.61,NULL,'2023-08-03 18:47:20','2023-08-03 19:02:04','2023-08-03 19:02:04'),(2765,7730,884,40720,1544,21,497,2,6419.32,NULL,'2023-08-03 18:47:20','2023-08-03 19:02:04','2023-08-03 19:02:04'),(2766,7730,884,40720,1544,21,135,1,4405.01,NULL,'2023-08-03 18:47:20','2023-08-03 19:02:04','2023-08-03 19:02:04'),(2767,7730,885,40720,1544,21,326,1,6489.48,NULL,'2023-08-03 18:58:15','2023-08-03 18:58:15',NULL),(2768,7730,885,40720,1544,21,497,2,6489.48,NULL,'2023-08-03 18:58:15','2023-08-03 18:58:15',NULL),(2769,7730,886,40720,1544,21,326,1,4839.77,NULL,'2023-08-03 19:01:13','2023-08-03 19:01:13',NULL),(2770,7730,886,40720,1544,21,497,2,4839.77,NULL,'2023-08-03 19:01:13','2023-08-03 19:01:13',NULL);
INSERT INTO `balance_libro_details` VALUES (2771,7730,887,40720,1544,21,326,1,1909.70,NULL,'2023-08-03 19:02:04','2023-08-03 19:02:04',NULL),(2772,7730,887,40720,1544,21,327,1,104.61,NULL,'2023-08-03 19:02:04','2023-08-03 19:02:04',NULL),(2773,7730,887,40720,1544,21,497,2,6419.32,NULL,'2023-08-03 19:02:04','2023-08-03 19:02:04',NULL),(2774,7730,887,40720,1544,21,135,1,4405.01,NULL,'2023-08-03 19:02:04','2023-08-03 19:02:04',NULL),(2775,7730,888,40720,1544,21,326,1,34.09,NULL,'2023-08-03 19:07:14','2023-08-03 19:23:12','2023-08-03 19:23:12'),(2776,7730,888,40720,1544,21,497,2,34.09,NULL,'2023-08-03 19:07:14','2023-08-03 19:23:12','2023-08-03 19:23:12'),(2777,7730,889,40720,1544,21,326,1,13689.86,NULL,'2023-08-03 19:22:50','2023-08-03 19:24:24','2023-08-03 19:24:24'),(2778,7730,889,40720,1544,21,327,1,367.16,NULL,'2023-08-03 19:22:50','2023-08-03 19:24:24','2023-08-03 19:24:24'),(2779,7730,889,40720,1544,21,135,1,5085.93,NULL,'2023-08-03 19:22:50','2023-08-03 19:24:24','2023-08-03 19:24:24'),(2780,7730,889,40720,1544,21,507,1,5861.26,NULL,'2023-08-03 19:22:50','2023-08-03 19:24:24','2023-08-03 19:24:24'),(2781,7730,889,40720,1544,21,437,1,150.03,NULL,'2023-08-03 19:22:50','2023-08-03 19:24:24','2023-08-03 19:24:24'),(2782,7730,889,40720,1544,21,497,2,25154.24,NULL,'2023-08-03 19:22:50','2023-08-03 19:24:24','2023-08-03 19:24:24'),(2783,7730,890,40720,1544,21,326,1,34.09,NULL,'2023-08-03 19:23:12','2023-08-04 04:59:02','2023-08-04 04:59:02'),(2784,7730,890,40720,1544,21,497,2,34.09,NULL,'2023-08-03 19:23:12','2023-08-04 04:59:02','2023-08-04 04:59:02'),(2785,7730,891,40720,1544,21,326,1,13689.86,NULL,'2023-08-03 19:24:24','2023-08-04 00:01:46','2023-08-04 00:01:46'),(2786,7730,891,40720,1544,21,327,1,367.16,NULL,'2023-08-03 19:24:24','2023-08-04 00:01:46','2023-08-04 00:01:46'),(2787,7730,891,40720,1544,21,135,1,5085.93,NULL,'2023-08-03 19:24:24','2023-08-04 00:01:46','2023-08-04 00:01:46'),(2788,7730,891,40720,1544,21,507,1,5861.26,NULL,'2023-08-03 19:24:24','2023-08-04 00:01:46','2023-08-04 00:01:46'),(2789,7730,891,40720,1544,21,437,1,150.03,NULL,'2023-08-03 19:24:24','2023-08-04 00:01:46','2023-08-04 00:01:46'),(2790,7730,891,40720,1544,21,497,2,25154.24,NULL,'2023-08-03 19:24:24','2023-08-04 00:01:46','2023-08-04 00:01:46'),(2791,7730,892,40720,1544,21,507,1,5861.26,NULL,'2023-08-04 00:06:01','2023-08-04 00:06:01',NULL),(2792,7730,892,40720,1544,21,437,1,150.03,NULL,'2023-08-04 00:06:01','2023-08-04 00:06:01',NULL),(2793,7730,892,40720,1544,21,135,1,310.23,NULL,'2023-08-04 00:06:01','2023-08-04 00:06:01',NULL),(2794,7730,892,40720,1544,21,497,2,6321.52,NULL,'2023-08-04 00:06:01','2023-08-04 00:06:01',NULL),(2795,7730,893,40720,1543,21,74,1,791.47,NULL,'2023-08-04 00:10:39','2023-08-04 01:38:40','2023-08-04 01:38:40'),(2796,7730,893,40720,1543,21,359,1,361.93,NULL,'2023-08-04 00:10:39','2023-08-04 01:38:40','2023-08-04 01:38:40'),(2797,7730,893,40720,1543,21,437,1,42.09,NULL,'2023-08-04 00:10:39','2023-08-04 01:38:40','2023-08-04 01:38:40'),(2798,7730,893,40720,1543,21,507,1,5861.26,NULL,'2023-08-04 00:10:39','2023-08-04 01:38:40','2023-08-04 01:38:40'),(2799,7730,893,40720,1543,21,497,2,7056.75,NULL,'2023-08-04 00:10:39','2023-08-04 01:38:40','2023-08-04 01:38:40'),(2800,7730,894,40720,1544,15,68,2,598.50,NULL,'2023-08-04 00:19:43','2023-08-04 00:19:43',NULL),(2801,7730,894,40720,1544,15,506,2,85.50,NULL,'2023-08-04 00:19:43','2023-08-04 00:19:43',NULL),(2802,7730,894,40720,1544,15,353,2,107598.92,NULL,'2023-08-04 00:19:43','2023-08-04 00:19:43',NULL),(2803,7730,894,40720,1544,15,354,2,10802.50,NULL,'2023-08-04 00:19:43','2023-08-04 00:19:43',NULL),(2804,7730,894,40720,1544,15,353,1,108197.42,NULL,'2023-08-04 00:19:43','2023-08-04 00:19:43',NULL),(2805,7730,894,40720,1544,15,354,1,10888.00,NULL,'2023-08-04 00:19:43','2023-08-04 00:19:43',NULL),(2806,7730,895,40720,1544,16,505,2,85.50,NULL,'2023-08-04 00:23:17','2023-08-04 00:23:17',NULL),(2807,7730,895,40720,1544,16,302,2,11892.76,NULL,'2023-08-04 00:23:17','2023-08-04 00:23:17',NULL);
INSERT INTO `balance_libro_details` VALUES (2808,7730,895,40720,1544,16,301,2,342.00,NULL,'2023-08-04 00:23:17','2023-08-04 00:23:17',NULL),(2809,7730,895,40720,1544,16,302,1,11892.76,NULL,'2023-08-04 00:23:17','2023-08-04 00:23:17',NULL),(2810,7730,895,40720,1544,16,301,1,427.50,NULL,'2023-08-04 00:23:17','2023-08-04 00:23:17',NULL),(2811,7730,896,40720,1545,21,507,1,5861.26,NULL,'2023-08-04 00:26:52','2023-08-04 01:35:02','2023-08-04 01:35:02'),(2812,7730,896,40720,1545,21,497,2,5861.26,NULL,'2023-08-04 00:26:52','2023-08-04 01:35:02','2023-08-04 01:35:02'),(2813,7730,897,40720,1545,5,396,1,2850.00,NULL,'2023-08-04 00:29:26','2023-08-04 01:28:04','2023-08-04 01:28:04'),(2814,7730,897,40720,1545,5,505,1,85.50,NULL,'2023-08-04 00:29:26','2023-08-04 01:28:04','2023-08-04 01:28:04'),(2815,7730,897,40720,1545,5,68,1,598.50,NULL,'2023-08-04 00:29:26','2023-08-04 01:28:04','2023-08-04 01:28:04'),(2816,7730,897,40720,1545,5,506,1,85.50,NULL,'2023-08-04 00:29:26','2023-08-04 01:28:04','2023-08-04 01:28:04'),(2817,7730,897,40720,1545,5,437,1,21.71,NULL,'2023-08-04 00:29:26','2023-08-04 01:28:04','2023-08-04 01:28:04'),(2818,7730,897,40720,1545,5,497,2,3641.21,NULL,'2023-08-04 00:29:26','2023-08-04 01:28:04','2023-08-04 01:28:04'),(2819,7730,898,40720,1543,14,383,1,11596.35,NULL,'2023-08-04 00:33:56','2023-08-04 11:02:00','2023-08-04 11:02:00'),(2820,7730,898,40720,1543,14,381,2,11596.35,NULL,'2023-08-04 00:33:56','2023-08-04 11:02:00','2023-08-04 11:02:00'),(2821,7730,899,40720,1545,15,68,2,598.50,NULL,'2023-08-04 00:39:54','2023-08-04 00:39:54',NULL),(2822,7730,899,40720,1545,15,506,2,85.50,NULL,'2023-08-04 00:39:54','2023-08-04 00:39:54',NULL),(2823,7730,899,40720,1545,15,353,2,108197.42,NULL,'2023-08-04 00:39:54','2023-08-04 00:39:54',NULL),(2824,7730,899,40720,1545,15,354,2,10888.00,NULL,'2023-08-04 00:39:54','2023-08-04 00:39:54',NULL),(2825,7730,899,40720,1545,15,353,1,108795.92,NULL,'2023-08-04 00:39:54','2023-08-04 00:39:54',NULL),(2826,7730,899,40720,1545,15,354,1,10973.50,NULL,'2023-08-04 00:39:54','2023-08-04 00:39:54',NULL),(2827,7730,900,40720,1545,16,505,2,85.50,NULL,'2023-08-04 00:48:10','2023-08-04 05:21:06','2023-08-04 05:21:06'),(2828,7730,900,40720,1545,16,302,2,11892.76,NULL,'2023-08-04 00:48:10','2023-08-04 05:21:06','2023-08-04 05:21:06'),(2829,7730,900,40720,1545,16,302,2,427.50,NULL,'2023-08-04 00:48:10','2023-08-04 05:21:06','2023-08-04 05:21:06'),(2830,7730,900,40720,1545,16,302,1,11892.76,NULL,'2023-08-04 00:48:10','2023-08-04 05:21:06','2023-08-04 05:21:06'),(2831,7730,900,40720,1545,16,301,1,513.00,NULL,'2023-08-04 00:48:10','2023-08-04 05:21:06','2023-08-04 05:21:06'),(2832,7730,901,40720,1543,6,411,1,34596.09,NULL,'2023-08-04 01:17:27','2023-08-04 01:22:18','2023-08-04 01:22:18'),(2833,7730,901,40720,1543,6,437,2,5165.43,NULL,'2023-08-04 01:17:27','2023-08-04 01:22:18','2023-08-04 01:22:18'),(2834,7730,901,40720,1543,6,24,2,99.99,NULL,'2023-08-04 01:17:27','2023-08-04 01:22:18','2023-08-04 01:22:18'),(2835,7730,901,40720,1543,6,477,2,29330.67,NULL,'2023-08-04 01:17:27','2023-08-04 01:22:18','2023-08-04 01:22:18'),(2836,7730,902,40720,1543,6,411,1,34596.09,NULL,'2023-08-04 01:22:18','2023-08-04 01:22:18',NULL),(2837,7730,902,40720,1543,6,437,2,5165.43,NULL,'2023-08-04 01:22:18','2023-08-04 01:22:18',NULL),(2838,7730,902,40720,1543,6,24,2,99.99,NULL,'2023-08-04 01:22:18','2023-08-04 01:22:18',NULL),(2839,7730,902,40720,1543,6,79,2,29330.67,NULL,'2023-08-04 01:22:18','2023-08-04 01:22:18',NULL),(2840,7730,903,40720,1545,5,396,1,2850.00,NULL,'2023-08-04 01:28:04','2023-08-04 05:19:53','2023-08-04 05:19:53'),(2841,7730,903,40720,1545,5,505,1,85.50,NULL,'2023-08-04 01:28:04','2023-08-04 05:19:53','2023-08-04 05:19:53'),(2842,7730,903,40720,1545,5,68,1,598.50,NULL,'2023-08-04 01:28:04','2023-08-04 05:19:53','2023-08-04 05:19:53'),(2843,7730,903,40720,1545,5,506,1,85.50,NULL,'2023-08-04 01:28:04','2023-08-04 05:19:53','2023-08-04 05:19:53'),(2844,7730,903,40720,1545,5,437,1,21.71,NULL,'2023-08-04 01:28:04','2023-08-04 05:19:53','2023-08-04 05:19:53');
INSERT INTO `balance_libro_details` VALUES (2845,7730,903,40720,1545,5,497,2,3641.21,NULL,'2023-08-04 01:28:04','2023-08-04 05:19:53','2023-08-04 05:19:53'),(2846,7730,904,40720,1546,5,396,1,3300.00,NULL,'2023-08-04 01:31:18','2023-08-04 01:31:18',NULL),(2847,7730,904,40720,1546,5,505,1,82.50,NULL,'2023-08-04 01:31:18','2023-08-04 01:31:18',NULL),(2848,7730,904,40720,1546,5,68,1,693.00,NULL,'2023-08-04 01:31:18','2023-08-04 01:31:18',NULL),(2849,7730,904,40720,1546,5,506,1,99.00,NULL,'2023-08-04 01:31:18','2023-08-04 01:31:18',NULL),(2850,7730,904,40720,1546,5,437,1,25.05,NULL,'2023-08-04 01:31:18','2023-08-04 01:31:18',NULL),(2851,7730,904,40720,1546,5,497,2,4199.55,NULL,'2023-08-04 01:31:18','2023-08-04 01:31:18',NULL),(2852,7730,905,40720,1546,19,507,1,6740.44,NULL,'2023-08-04 01:34:15','2023-08-04 01:35:16','2023-08-04 01:35:16'),(2853,7730,905,40720,1546,19,437,1,40.44,NULL,'2023-08-04 01:34:15','2023-08-04 01:35:16','2023-08-04 01:35:16'),(2854,7730,905,40720,1546,19,497,2,6780.88,NULL,'2023-08-04 01:34:15','2023-08-04 01:35:16','2023-08-04 01:35:16'),(2855,7730,906,40720,1545,19,507,1,5861.26,NULL,'2023-08-04 01:35:02','2023-08-04 05:23:32','2023-08-04 05:23:32'),(2856,7730,906,40720,1545,19,497,2,5861.26,NULL,'2023-08-04 01:35:02','2023-08-04 05:23:32','2023-08-04 05:23:32'),(2857,7730,907,40720,1546,19,507,1,6740.44,NULL,'2023-08-04 01:35:16','2023-08-04 01:35:16',NULL),(2858,7730,907,40720,1546,19,437,1,40.44,NULL,'2023-08-04 01:35:16','2023-08-04 01:35:16',NULL),(2859,7730,907,40720,1546,19,497,2,6780.88,NULL,'2023-08-04 01:35:16','2023-08-04 01:35:16',NULL),(2860,7730,908,40720,1543,21,74,1,791.47,NULL,'2023-08-04 01:38:40','2023-08-04 01:38:40',NULL),(2861,7730,908,40720,1543,21,359,1,361.93,NULL,'2023-08-04 01:38:40','2023-08-04 01:38:40',NULL),(2862,7730,908,40720,1543,21,437,1,42.09,NULL,'2023-08-04 01:38:40','2023-08-04 01:38:40',NULL),(2863,7730,908,40720,1543,21,507,1,5861.26,NULL,'2023-08-04 01:38:40','2023-08-04 01:38:40',NULL),(2864,7730,908,40720,1543,21,497,2,7056.75,NULL,'2023-08-04 01:38:40','2023-08-04 01:38:40',NULL),(2865,7730,909,40720,1544,21,326,1,34.09,NULL,'2023-08-04 04:59:02','2023-08-04 04:59:02',NULL),(2866,7730,909,40720,1544,21,497,2,34.09,NULL,'2023-08-04 04:59:02','2023-08-04 04:59:02',NULL),(2867,7730,910,40720,1546,15,68,2,693.00,NULL,'2023-08-04 05:12:07','2023-08-04 05:12:07',NULL),(2868,7730,910,40720,1546,15,506,2,99.00,NULL,'2023-08-04 05:12:07','2023-08-04 05:12:07',NULL),(2869,7730,910,40720,1546,15,353,2,108795.92,NULL,'2023-08-04 05:12:07','2023-08-04 05:12:07',NULL),(2870,7730,910,40720,1546,15,354,2,10973.50,NULL,'2023-08-04 05:12:07','2023-08-04 05:12:07',NULL),(2871,7730,910,40720,1546,15,353,1,109488.92,NULL,'2023-08-04 05:12:07','2023-08-04 05:12:07',NULL),(2872,7730,910,40720,1546,15,354,1,11072.50,NULL,'2023-08-04 05:12:07','2023-08-04 05:12:07',NULL),(2873,7730,911,40720,1546,16,505,2,82.50,NULL,'2023-08-04 05:14:49','2023-08-04 05:28:12','2023-08-04 05:28:12'),(2874,7730,911,40720,1546,16,302,2,11892.76,NULL,'2023-08-04 05:14:49','2023-08-04 05:28:12','2023-08-04 05:28:12'),(2875,7730,911,40720,1546,16,302,1,11892.76,NULL,'2023-08-04 05:14:49','2023-08-04 05:28:12','2023-08-04 05:28:12'),(2876,7730,911,40720,1546,16,301,1,82.50,NULL,'2023-08-04 05:14:49','2023-08-04 05:28:12','2023-08-04 05:28:12'),(2877,7730,912,40720,1545,5,396,1,2850.00,NULL,'2023-08-04 05:19:53','2023-08-04 05:19:53',NULL),(2878,7730,912,40720,1545,5,68,1,598.50,NULL,'2023-08-04 05:19:53','2023-08-04 05:19:53',NULL),(2879,7730,912,40720,1545,5,506,1,85.50,NULL,'2023-08-04 05:19:53','2023-08-04 05:19:53',NULL),(2880,7730,912,40720,1545,5,437,1,21.20,NULL,'2023-08-04 05:19:53','2023-08-04 05:19:53',NULL),(2881,7730,912,40720,1545,5,497,2,3555.20,NULL,'2023-08-04 05:19:53','2023-08-04 05:19:53',NULL),(2882,7730,913,40720,1545,16,302,2,11892.76,NULL,'2023-08-04 05:21:06','2023-08-04 06:52:56','2023-08-04 06:52:56'),(2883,7730,913,40720,1545,16,302,2,427.50,NULL,'2023-08-04 05:21:06','2023-08-04 06:52:56','2023-08-04 06:52:56');
INSERT INTO `balance_libro_details` VALUES (2884,7730,913,40720,1545,16,302,1,11892.76,NULL,'2023-08-04 05:21:06','2023-08-04 06:52:56','2023-08-04 06:52:56'),(2885,7730,913,40720,1545,16,301,1,427.50,NULL,'2023-08-04 05:21:06','2023-08-04 06:52:56','2023-08-04 06:52:56'),(2886,7730,914,40720,1545,19,507,1,5861.26,NULL,'2023-08-04 05:23:32','2023-08-04 05:23:32',NULL),(2887,7730,914,40720,1545,19,437,1,35.17,NULL,'2023-08-04 05:23:32','2023-08-04 05:23:32',NULL),(2888,7730,914,40720,1545,19,497,2,5896.43,NULL,'2023-08-04 05:23:32','2023-08-04 05:23:32',NULL),(2889,7730,915,40720,1546,16,505,2,82.50,NULL,'2023-08-04 05:28:12','2023-08-04 05:28:12',NULL),(2890,7730,915,40720,1546,16,302,2,11892.76,NULL,'2023-08-04 05:28:12','2023-08-04 05:28:12',NULL),(2891,7730,915,40720,1546,16,301,2,427.50,NULL,'2023-08-04 05:28:12','2023-08-04 05:28:12',NULL),(2892,7730,915,40720,1546,16,302,1,11892.76,NULL,'2023-08-04 05:28:12','2023-08-04 05:28:12',NULL),(2893,7730,915,40720,1546,16,301,1,510.00,NULL,'2023-08-04 05:28:12','2023-08-04 05:28:12',NULL),(2894,7730,916,40720,1547,5,396,1,3300.00,NULL,'2023-08-04 05:31:11','2023-08-04 05:31:11',NULL),(2895,7730,916,40720,1547,5,505,1,82.50,NULL,'2023-08-04 05:31:11','2023-08-04 05:31:11',NULL),(2896,7730,916,40720,1547,5,68,1,693.00,NULL,'2023-08-04 05:31:11','2023-08-04 05:31:11',NULL),(2897,7730,916,40720,1547,5,506,1,99.00,NULL,'2023-08-04 05:31:11','2023-08-04 05:31:11',NULL),(2898,7730,916,40720,1547,5,437,1,25.05,NULL,'2023-08-04 05:31:11','2023-08-04 05:31:11',NULL),(2899,7730,916,40720,1547,5,497,2,4199.55,NULL,'2023-08-04 05:31:11','2023-08-04 05:31:11',NULL),(2900,7730,917,40720,1547,15,68,2,693.00,NULL,'2023-08-04 05:33:43','2023-08-04 05:33:43',NULL),(2901,7730,917,40720,1547,15,506,2,99.00,NULL,'2023-08-04 05:33:43','2023-08-04 05:33:43',NULL),(2902,7730,917,40720,1547,15,353,2,109488.92,NULL,'2023-08-04 05:33:43','2023-08-04 05:33:43',NULL),(2903,7730,917,40720,1547,15,354,2,11072.50,NULL,'2023-08-04 05:33:43','2023-08-04 05:33:43',NULL),(2904,7730,917,40720,1547,15,353,1,110181.92,NULL,'2023-08-04 05:33:43','2023-08-04 05:33:43',NULL),(2905,7730,917,40720,1547,15,354,1,11171.50,NULL,'2023-08-04 05:33:43','2023-08-04 05:33:43',NULL),(2906,7730,918,40720,1547,16,505,2,82.50,NULL,'2023-08-04 05:36:24','2023-08-04 05:36:24',NULL),(2907,7730,918,40720,1547,16,302,2,11892.76,NULL,'2023-08-04 05:36:24','2023-08-04 05:36:24',NULL),(2908,7730,918,40720,1547,16,301,2,510.00,NULL,'2023-08-04 05:36:24','2023-08-04 05:36:24',NULL),(2909,7730,918,40720,1547,16,302,1,11892.76,NULL,'2023-08-04 05:36:24','2023-08-04 05:36:24',NULL),(2910,7730,918,40720,1547,16,301,1,592.50,NULL,'2023-08-04 05:36:24','2023-08-04 05:36:24',NULL),(2911,7730,919,40720,1548,21,507,1,15574.32,NULL,'2023-08-04 05:40:26','2023-08-04 05:40:26',NULL),(2912,7730,919,40720,1548,21,437,1,93.45,NULL,'2023-08-04 05:40:26','2023-08-04 05:40:26',NULL),(2913,7730,919,40720,1548,21,497,2,15667.77,NULL,'2023-08-04 05:40:26','2023-08-04 05:40:26',NULL),(2914,7730,920,40720,1548,5,396,1,3300.00,NULL,'2023-08-04 05:42:19','2023-08-04 05:42:19',NULL),(2915,7730,920,40720,1548,5,505,1,165.00,NULL,'2023-08-04 05:42:19','2023-08-04 05:42:19',NULL),(2916,7730,920,40720,1548,5,68,1,693.00,NULL,'2023-08-04 05:42:19','2023-08-04 05:42:19',NULL),(2917,7730,920,40720,1548,5,506,1,99.00,NULL,'2023-08-04 05:42:19','2023-08-04 05:42:19',NULL),(2918,7730,920,40720,1548,5,437,1,25.54,NULL,'2023-08-04 05:42:19','2023-08-04 05:42:19',NULL),(2919,7730,920,40720,1548,5,497,2,4282.54,NULL,'2023-08-04 05:42:19','2023-08-04 05:42:19',NULL),(2920,7730,921,40720,1548,15,68,2,693.00,NULL,'2023-08-04 05:45:48','2023-08-04 05:48:36','2023-08-04 05:48:36'),(2921,7730,921,40720,1548,15,506,2,99.00,NULL,'2023-08-04 05:45:48','2023-08-04 05:48:36','2023-08-04 05:48:36'),(2922,7730,921,40720,1548,15,353,2,110181.92,NULL,'2023-08-04 05:45:48','2023-08-04 05:48:36','2023-08-04 05:48:36'),(2923,7730,921,40720,1548,15,354,2,11171.50,NULL,'2023-08-04 05:45:48','2023-08-04 05:48:36','2023-08-04 05:48:36');
INSERT INTO `balance_libro_details` VALUES (2924,7730,921,40720,1548,15,353,1,110874.92,NULL,'2023-08-04 05:45:48','2023-08-04 05:48:36','2023-08-04 05:48:36'),(2925,7730,921,40720,1548,15,354,1,11270.50,NULL,'2023-08-04 05:45:48','2023-08-04 05:48:36','2023-08-04 05:48:36'),(2926,7730,922,40720,1548,15,68,2,693.00,NULL,'2023-08-04 05:48:36','2023-08-04 05:48:36',NULL),(2927,7730,922,40720,1548,15,506,2,99.00,NULL,'2023-08-04 05:48:36','2023-08-04 05:48:36',NULL),(2928,7730,922,40720,1548,15,353,2,110181.92,NULL,'2023-08-04 05:48:36','2023-08-04 05:48:36',NULL),(2929,7730,922,40720,1548,15,354,2,11171.50,NULL,'2023-08-04 05:48:36','2023-08-04 05:48:36',NULL),(2930,7730,922,40720,1548,15,353,1,110874.92,NULL,'2023-08-04 05:48:36','2023-08-04 05:48:36',NULL),(2931,7730,922,40720,1548,15,354,1,11270.50,NULL,'2023-08-04 05:48:36','2023-08-04 05:48:36',NULL),(2932,7730,923,40720,1548,16,505,2,165.00,NULL,'2023-08-04 05:50:54','2023-08-04 05:50:54',NULL),(2933,7730,923,40720,1548,16,302,2,11892.76,NULL,'2023-08-04 05:50:54','2023-08-04 05:50:54',NULL),(2934,7730,923,40720,1548,16,301,2,592.50,NULL,'2023-08-04 05:50:54','2023-08-04 05:50:54',NULL),(2935,7730,923,40720,1548,16,302,1,11892.76,NULL,'2023-08-04 05:50:54','2023-08-04 05:50:54',NULL),(2936,7730,923,40720,1548,16,301,1,757.50,NULL,'2023-08-04 05:50:54','2023-08-04 05:50:54',NULL),(2937,7730,924,40720,1549,5,396,1,4125.00,NULL,'2023-08-04 05:57:00','2023-08-04 05:57:00',NULL),(2938,7730,924,40720,1549,5,505,1,206.25,NULL,'2023-08-04 05:57:00','2023-08-04 05:57:00',NULL),(2939,7730,924,40720,1549,5,68,1,866.25,NULL,'2023-08-04 05:57:00','2023-08-04 05:57:00',NULL),(2940,7730,924,40720,1549,5,506,1,123.75,NULL,'2023-08-04 05:57:00','2023-08-04 05:57:00',NULL),(2941,7730,924,40720,1549,5,437,1,31.93,NULL,'2023-08-04 05:57:00','2023-08-04 05:57:00',NULL),(2942,7730,924,40720,1549,5,497,2,5353.18,NULL,'2023-08-04 05:57:00','2023-08-04 05:57:00',NULL),(2943,7730,925,40720,1549,15,68,2,866.25,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:02',NULL),(2944,7730,926,40720,1549,15,68,2,866.25,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:40','2023-08-04 06:00:40'),(2945,7730,925,40720,1549,15,506,2,123.75,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:02',NULL),(2946,7730,926,40720,1549,15,506,2,123.75,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:40','2023-08-04 06:00:40'),(2947,7730,925,40720,1549,15,353,2,110874.92,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:02',NULL),(2948,7730,926,40720,1549,15,353,2,110874.92,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:40','2023-08-04 06:00:40'),(2949,7730,925,40720,1549,15,354,2,11270.50,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:02',NULL),(2950,7730,926,40720,1549,15,354,2,11270.50,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:40','2023-08-04 06:00:40'),(2951,7730,925,40720,1549,15,353,1,111741.17,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:02',NULL),(2952,7730,926,40720,1549,15,353,1,111741.17,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:40','2023-08-04 06:00:40'),(2953,7730,926,40720,1549,15,354,1,11394.25,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:40','2023-08-04 06:00:40'),(2954,7730,925,40720,1549,15,354,1,11394.25,NULL,'2023-08-04 06:00:02','2023-08-04 06:00:02',NULL),(2955,7730,927,40720,1549,16,505,2,206.25,NULL,'2023-08-04 06:02:46','2023-08-04 06:02:46',NULL),(2956,7730,927,40720,1549,16,302,2,11892.76,NULL,'2023-08-04 06:02:46','2023-08-04 06:02:46',NULL),(2957,7730,927,40720,1549,16,301,2,757.50,NULL,'2023-08-04 06:02:46','2023-08-04 06:02:46',NULL),(2958,7730,927,40720,1549,16,302,1,11892.76,NULL,'2023-08-04 06:02:46','2023-08-04 06:02:46',NULL),(2959,7730,927,40720,1549,16,301,1,963.75,NULL,'2023-08-04 06:02:46','2023-08-04 06:02:46',NULL),(2960,7730,928,40720,1550,21,507,1,15574.32,NULL,'2023-08-04 06:07:50','2023-08-04 06:07:50',NULL),(2961,7730,928,40720,1550,21,437,1,93.45,NULL,'2023-08-04 06:07:51','2023-08-04 06:07:51',NULL),(2962,7730,928,40720,1550,21,497,2,15667.77,NULL,'2023-08-04 06:07:51','2023-08-04 06:07:51',NULL);
INSERT INTO `balance_libro_details` VALUES (2963,7730,929,40720,1550,5,396,1,4125.00,NULL,'2023-08-04 06:09:49','2023-08-04 06:09:49',NULL),(2964,7730,929,40720,1550,5,505,1,206.25,NULL,'2023-08-04 06:09:49','2023-08-04 06:09:49',NULL),(2965,7730,929,40720,1550,5,68,1,866.25,NULL,'2023-08-04 06:09:49','2023-08-04 06:09:49',NULL),(2966,7730,929,40720,1550,5,506,1,123.75,NULL,'2023-08-04 06:09:49','2023-08-04 06:09:49',NULL),(2967,7730,929,40720,1550,5,437,1,31.93,NULL,'2023-08-04 06:09:49','2023-08-04 06:09:49',NULL),(2968,7730,929,40720,1550,5,497,2,5353.18,NULL,'2023-08-04 06:09:49','2023-08-04 06:09:49',NULL),(2969,7730,930,40720,1550,15,68,2,866.25,NULL,'2023-08-04 06:14:47','2023-08-04 06:14:47',NULL),(2970,7730,930,40720,1550,15,506,2,123.75,NULL,'2023-08-04 06:14:47','2023-08-04 06:14:47',NULL),(2971,7730,930,40720,1550,15,353,2,111741.17,NULL,'2023-08-04 06:14:47','2023-08-04 06:14:47',NULL),(2972,7730,930,40720,1550,15,354,2,11394.25,NULL,'2023-08-04 06:14:47','2023-08-04 06:14:47',NULL),(2973,7730,930,40720,1550,15,353,1,112607.42,NULL,'2023-08-04 06:14:47','2023-08-04 06:14:47',NULL),(2974,7730,930,40720,1550,15,354,1,11518.00,NULL,'2023-08-04 06:14:47','2023-08-04 06:14:47',NULL),(2975,7730,931,40720,1550,16,505,2,206.25,NULL,'2023-08-04 06:17:31','2023-08-04 06:17:31',NULL),(2976,7730,931,40720,1550,16,302,2,11892.76,NULL,'2023-08-04 06:17:31','2023-08-04 06:17:31',NULL),(2977,7730,931,40720,1550,16,301,2,963.75,NULL,'2023-08-04 06:17:31','2023-08-04 06:17:31',NULL),(2978,7730,931,40720,1550,16,302,1,11892.76,NULL,'2023-08-04 06:17:31','2023-08-04 06:17:31',NULL),(2979,7730,931,40720,1550,16,301,1,1170.00,NULL,'2023-08-04 06:17:31','2023-08-04 06:17:31',NULL),(2980,7730,932,40720,1551,21,507,1,15574.32,NULL,'2023-08-04 06:24:28','2023-08-04 06:24:28',NULL),(2981,7730,932,40720,1551,21,437,1,93.45,NULL,'2023-08-04 06:24:28','2023-08-04 06:24:28',NULL),(2982,7730,932,40720,1551,21,497,2,15667.77,NULL,'2023-08-04 06:24:28','2023-08-04 06:24:28',NULL),(2983,7730,933,40720,1551,21,507,1,18007.04,NULL,'2023-08-04 06:26:07','2023-08-04 06:26:07',NULL),(2984,7730,933,40720,1551,21,437,1,108.04,NULL,'2023-08-04 06:26:07','2023-08-04 06:26:07',NULL),(2985,7730,933,40720,1551,21,497,2,18115.08,NULL,'2023-08-04 06:26:07','2023-08-04 06:26:07',NULL),(2986,7730,934,40720,1551,5,396,1,4125.00,NULL,'2023-08-04 06:28:07','2023-08-04 06:28:07',NULL),(2987,7730,934,40720,1551,5,505,1,206.25,NULL,'2023-08-04 06:28:07','2023-08-04 06:28:07',NULL),(2988,7730,934,40720,1551,5,68,1,866.25,NULL,'2023-08-04 06:28:07','2023-08-04 06:28:07',NULL),(2989,7730,934,40720,1551,5,506,1,123.75,NULL,'2023-08-04 06:28:07','2023-08-04 06:28:07',NULL),(2990,7730,934,40720,1551,5,437,1,31.93,NULL,'2023-08-04 06:28:07','2023-08-04 06:28:07',NULL),(2991,7730,934,40720,1551,5,497,2,5353.18,NULL,'2023-08-04 06:28:07','2023-08-04 06:28:07',NULL),(2992,7730,935,40720,1551,15,68,2,866.25,NULL,'2023-08-04 06:32:00','2023-08-04 06:32:00',NULL),(2993,7730,935,40720,1551,15,506,2,123.75,NULL,'2023-08-04 06:32:00','2023-08-04 06:32:00',NULL),(2994,7730,935,40720,1551,15,353,2,112607.42,NULL,'2023-08-04 06:32:00','2023-08-04 06:32:00',NULL),(2995,7730,935,40720,1551,15,354,2,11518.00,NULL,'2023-08-04 06:32:00','2023-08-04 06:32:00',NULL),(2996,7730,935,40720,1551,15,353,1,113473.67,NULL,'2023-08-04 06:32:00','2023-08-04 06:32:00',NULL),(2997,7730,935,40720,1551,15,354,1,11641.75,NULL,'2023-08-04 06:32:00','2023-08-04 06:32:00',NULL),(2998,7730,936,40720,1551,16,505,2,206.25,NULL,'2023-08-04 06:34:59','2023-08-04 06:34:59',NULL),(2999,7730,936,40720,1551,16,302,2,11892.76,NULL,'2023-08-04 06:34:59','2023-08-04 06:34:59',NULL),(3000,7730,936,40720,1551,16,301,2,1170.00,NULL,'2023-08-04 06:34:59','2023-08-04 06:34:59',NULL),(3001,7730,936,40720,1551,16,302,1,11892.76,NULL,'2023-08-04 06:34:59','2023-08-04 06:34:59',NULL),(3002,7730,936,40720,1551,16,301,1,1376.25,NULL,'2023-08-04 06:34:59','2023-08-04 06:34:59',NULL),(3003,7730,937,40720,1545,16,302,2,11892.76,NULL,'2023-08-04 06:52:56','2023-08-04 06:52:56',NULL);
INSERT INTO `balance_libro_details` VALUES (3004,7730,937,40720,1545,16,301,2,427.50,NULL,'2023-08-04 06:52:56','2023-08-04 06:52:56',NULL),(3005,7730,937,40720,1545,16,302,1,11892.76,NULL,'2023-08-04 06:52:56','2023-08-04 06:52:56',NULL),(3006,7730,937,40720,1545,16,301,1,427.50,NULL,'2023-08-04 06:52:56','2023-08-04 06:52:56',NULL),(3007,7730,938,40720,1551,4,499,1,136990.95,NULL,'2023-08-04 07:22:53','2023-08-04 14:28:36','2023-08-04 14:28:36'),(3008,7730,938,40720,1551,4,415,2,136990.95,NULL,'2023-08-04 07:22:53','2023-08-04 14:28:36','2023-08-04 14:28:36'),(3009,7730,939,40720,1551,4,500,1,3300.00,NULL,'2023-08-04 07:23:47','2023-08-04 14:29:04','2023-08-04 14:29:04'),(3010,7730,939,40720,1551,4,52,2,3300.00,NULL,'2023-08-04 07:23:47','2023-08-04 14:29:04','2023-08-04 14:29:04'),(3011,7730,940,40720,1551,23,495,1,32013.96,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3012,7730,940,40720,1551,23,500,1,6402.79,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3013,7730,940,40720,1551,23,391,1,2657953.37,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3014,7730,940,40720,1551,23,499,1,265795.34,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3015,7730,940,40720,1551,23,135,1,2575.83,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3016,7730,940,40720,1551,23,396,1,14125.20,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3017,7730,940,40720,1551,23,383,1,55840.14,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3018,7730,940,40720,1551,23,88,2,701320.73,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3019,7730,940,40720,1551,23,52,2,19208.38,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3020,7730,940,40720,1551,23,415,2,797386.01,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3021,7730,940,40720,1551,23,501,2,1516791.51,NULL,'2023-08-04 11:17:54','2023-08-04 14:33:12','2023-08-04 14:33:12'),(3022,7730,941,40720,1551,4,499,1,206776.38,NULL,'2023-08-04 14:28:36','2023-08-04 14:28:36',NULL),(3023,7730,941,40720,1551,4,415,2,206776.38,NULL,'2023-08-04 14:28:36','2023-08-04 14:28:36',NULL),(3024,7730,942,40720,1551,4,500,1,4981.07,NULL,'2023-08-04 14:29:04','2023-08-04 14:29:04',NULL),(3025,7730,942,40720,1551,4,52,2,4981.07,NULL,'2023-08-04 14:29:04','2023-08-04 14:29:04',NULL),(3026,7730,943,40720,1551,23,495,1,23608.59,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3027,7730,943,40720,1551,23,500,1,4721.72,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3028,7730,943,40720,1551,23,391,1,1960099.09,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3029,7730,943,40720,1551,23,499,1,196009.91,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3030,7730,943,40720,1551,23,135,1,2575.83,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3031,7730,943,40720,1551,23,396,1,14125.20,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3032,7730,943,40720,1551,23,383,1,55840.14,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3033,7730,943,40720,1551,23,88,2,701320.73,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3034,7730,943,40720,1551,23,52,2,14165.16,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3035,7730,943,40720,1551,23,415,2,588029.73,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3036,7730,943,40720,1551,23,501,2,953464.86,NULL,'2023-08-04 14:33:13','2023-08-04 14:44:03','2023-08-04 14:44:03'),(3037,7730,944,40720,1551,23,495,1,23608.59,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3038,7730,944,40720,1551,23,500,1,4721.72,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47');
INSERT INTO `balance_libro_details` VALUES (3039,7730,944,40720,1551,23,391,1,1960099.09,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3040,7730,944,40720,1551,23,499,1,196009.91,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3041,7730,944,40720,1551,23,135,1,2575.83,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3042,7730,944,40720,1551,23,396,1,14125.20,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3043,7730,944,40720,1551,23,383,1,55840.14,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3044,7730,944,40720,1551,23,88,2,701320.73,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3045,7730,944,40720,1551,23,52,2,14165.16,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3046,7730,944,40720,1551,23,415,2,588029.73,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3047,7730,944,40720,1551,23,501,2,1111955.57,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3048,7730,944,40720,1551,23,392,1,158490.71,NULL,'2023-08-04 14:44:03','2023-08-04 14:47:47','2023-08-04 14:47:47'),(3049,7730,945,40720,1551,23,495,1,23608.59,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3050,7730,945,40720,1551,23,500,1,4721.72,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3051,7730,945,40720,1551,23,391,1,1960099.09,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3052,7730,945,40720,1551,23,499,1,196009.91,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3053,7730,945,40720,1551,23,392,1,158490.71,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3054,7730,945,40720,1551,23,135,1,2575.83,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3055,7730,945,40720,1551,23,396,1,14125.20,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3056,7730,945,40720,1551,23,383,1,55840.14,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3057,7730,945,40720,1551,23,88,2,701320.73,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3058,7730,945,40720,1551,23,52,2,14165.16,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3059,7730,945,40720,1551,23,415,2,588029.73,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3060,7730,945,40720,1551,23,501,2,1111955.57,NULL,'2023-08-04 14:59:33','2023-08-04 14:59:33',NULL),(3061,7730,946,40720,1551,6,155,1,111648.22,NULL,'2023-08-04 15:19:25','2023-08-04 15:27:31','2023-08-04 15:27:31'),(3062,7730,946,40720,1551,6,411,2,111648.22,NULL,'2023-08-04 15:19:25','2023-08-04 15:27:31','2023-08-04 15:27:31'),(3063,7730,947,40720,1551,6,155,1,110690.92,NULL,'2023-08-04 15:27:31','2023-08-06 23:06:58','2023-08-06 23:06:58'),(3064,7730,947,40720,1551,6,411,2,110690.92,NULL,'2023-08-04 15:27:31','2023-08-06 23:06:58','2023-08-06 23:06:58'),(3065,7730,948,40720,1551,6,155,1,136905.84,NULL,'2023-08-06 23:06:58','2023-08-06 23:06:58',NULL),(3066,7730,948,40720,1551,6,411,2,136905.84,NULL,'2023-08-06 23:06:58','2023-08-06 23:06:58',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-08-27 17:46:23',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-08-27 17:46:23',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-08-27 17:46:23',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-27 17:46:23','2022-08-27 17:46:23',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-08-27 17:46:29','2022-08-27 17:46:29',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-08-27 17:46:29','2022-08-27 17:46:29',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-08-27 17:46:29','2022-08-27 17:46:29',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-27 17:46:29','2022-08-27 17:46:29',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-08-27 17:46:37','2022-08-27 17:46:37',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-08-27 17:46:37','2022-08-27 17:46:37',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-08-27 17:46:37','2022-08-27 17:46:37',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-27 17:46:37','2022-08-27 17:46:37',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:04:17','2023-05-30 15:04:17',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:04:17','2023-05-30 15:04:17',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:04:17','2023-05-30 15:04:17',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:04:17','2023-05-30 15:04:17',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:04:17','2023-05-30 15:04:17',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:04:17','2023-05-30 15:04:17',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:34:48',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:34:48',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:34:48',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:34:48',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:34:48',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:34:48',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:34:48',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:34:48',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',2108288.01,175690.67,'No Excluida','0',30,3330,485448.92,1047.86,1047.86,4623.27,6457.26,12128.39,12128.39,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',3133941.63,261161.80,'No Excluida','0',45,5000,485448.92,2018.89,2018.89,5085.60,6457.26,13561.75,13561.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',4387518.23,365626.52,'No Excluida','0',60,6700,970897.79,3452.09,3190.00,5594.16,6457.26,15503.51,15241.42,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',5449094.55,454091.21,'No Excluida','0',85,10000,970897.79,5671.23,5239.75,6153.58,7673.13,19497.94,19066.46,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',6416528.72,534710.73,'No Excluida','0',110,13000,1209769.40,10787.67,8368.13,6768.94,9389.36,26945.97,24526.43,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',8020660.90,668388.41,'No Excluida','0',150,16500,1213622.14,14840.88,10926.38,7445.83,10850.90,33137.61,29223.11,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',9624793.05,802066.09,'No Excluida','0',200,20000,1456346.67,18878.58,13623.24,8190.41,11625.96,38694.95,33439.61,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',11916410.45,993034.20,'No Excluida','0',200,20000,1941795.53,43150.91,33442.08,9009.45,13951.15,66111.51,56402.68,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',13337213.22,1111434.44,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,53938.71,9910.39,17272.86,NULL,81121.96,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',15285088.04,1273757.34,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,63385.73,10901.43,19332.31,NULL,93619.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',16957968.71,1413164.06,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,72817.31,11991.57,22155.77,NULL,106964.65,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(2,NULL,'Articulo 6',6,0,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(3,NULL,'Articulo 7',7,0,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(4,NULL,'Articulo 8',8,0,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(5,NULL,'Articulo 9',9,0,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(6,NULL,'Articulo 10',10,0,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(7,NULL,'Articulo 11',11,0,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(8,NULL,'Articulo 12',12,0,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(9,NULL,'Articulo 13',13,0,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL),(10,NULL,'Articulo 14',14,1,'2022-08-27 17:46:30','2022-08-27 17:46:30',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:43:23','2023-03-12 23:43:23',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1027 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,7730,2110352,5,2,2110300,'Impuesto a las Ganancias a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(482,7730,1140225,5,1,1140200,'Accionistas','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (483,7730,3110101,5,2,3110100,'Acciones a emitir','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(484,7730,1110216,5,1,1110200,'Mercado Pago','Activo',NULL,1,1,1,1,1,0,NULL),(485,7730,2110503,5,2,2110500,'Acreedores Varios','Pasivo',NULL,1,1,0,0,0,1,NULL),(486,7730,5120108,5,2,5120100,'Costo de mercaderias vendidas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(487,7730,5120108,5,2,5120100,'Servicio de informática','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(488,7730,5120108,5,2,5120100,'Comisiones Mercado Libre','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(489,7730,5120108,5,2,5120100,'Servicio de telefonía','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(490,7730,2110121,5,2,2110100,'Servicio de informática a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(491,7730,2110122,5,2,2110100,'Servicio de telefonía a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(492,7730,2110131,5,2,2110100,'Comisiones Mercado Libre a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(493,7730,2110124,5,2,2110100,'Honorarios a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(494,7730,2110125,5,2,2110100,'Gastor de organización a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(495,7730,1160107,5,1,1160100,'Gastos de organización','Activo',NULL,1,1,0,0,0,0,NULL),(496,7730,2110126,5,2,2110100,'Gastos de organización a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(497,7730,1110217,5,1,1110200,'Banco Santander Rio cta. cte.','Activo',NULL,1,1,1,1,1,0,NULL),(498,7730,5120108,5,2,5120100,'Servicio de Marketing Digital','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(499,7730,5120108,5,2,5120100,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(500,7730,5120108,5,2,5120100,'Amortización gastos de organización','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(501,7730,4120101,5,1,4120100,'RECPAM','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(502,7730,5140101,5,2,5140100,'Impuesto a los ingresos Brutos - Capital Federal','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(503,7730,5140101,5,2,5140100,'Intereses Resarcitorios Impositivos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(504,7730,4120101,5,1,4120100,'Ajuste por redondeo','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(505,7730,1140333,5,1,1140300,'Percepciones IIBB - Prov. Buenos Aires','Activo',NULL,1,1,0,0,0,0,NULL),(506,7730,1140334,5,1,1140300,'Percepciones IVA RG 2408','Activo',NULL,1,1,0,0,0,0,NULL),(507,7730,1140226,5,1,1140200,'Cuenta Particular - Socio Balbuena','Activo',NULL,1,1,0,0,0,0,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,1,2,0,0,1,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:14:54','2023-10-16 21:14:54',NULL,20);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=598 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5272.00,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-08-28 13:01:48','2022-08-28 13:04:51','2022-08-28 13:04:51'),(2,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5272.01,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-08-28 13:04:51','2022-08-28 13:05:09','2022-08-28 13:05:09'),(3,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5271.99,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-08-28 13:05:09','2022-08-28 13:13:02','2022-08-28 13:13:02'),(4,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5271.99,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-08-28 13:13:02','2022-08-28 18:21:56','2022-08-28 18:21:56'),(5,7730,20,40720,40721,13,1520,2,0,'2020-09-30','2020-09-30',5271.99,1,1.00,NULL,NULL,'2022-08-28 15:04:15','2022-08-28 16:39:22','2022-08-28 16:39:22'),(6,7730,20,40720,40721,13,1520,2,0,'2020-09-30','2020-09-30',5272.00,1,1.00,NULL,NULL,'2022-08-28 16:43:18','2022-08-28 16:54:30','2022-08-28 16:54:30'),(7,7730,20,40720,40721,13,1520,2,0,'2020-09-30','2020-09-30',5271.99,1,1.00,NULL,NULL,'2022-08-28 16:55:29','2022-08-28 23:49:23','2022-08-28 23:49:23'),(8,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5271.99,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-08-28 18:21:56','2022-08-28 20:10:04','2022-08-28 20:10:04'),(9,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5271.99,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-08-28 20:41:57','2022-08-28 23:31:51','2022-08-28 23:31:51'),(10,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5272.00,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-08-28 23:35:04','2022-09-02 04:23:51','2022-09-02 04:23:51'),(11,7730,20,40720,40721,13,1520,2,0,'2020-10-01','2020-10-01',5272.00,1,1.00,NULL,NULL,'2022-08-28 23:51:22','2022-08-29 00:15:32','2022-08-29 00:15:32'),(12,7730,20,40720,40721,13,1520,2,0,'2020-09-30','2020-09-30',5272.00,1,1.00,NULL,NULL,'2022-08-29 00:16:35','2022-09-02 04:26:26','2022-09-02 04:26:26'),(13,7730,2,40720,40723,13,1521,1,0,'2020-10-15','2020-10-15',4815.00,1,1.00,'Factura B N°: 0001-00000002',NULL,'2022-08-29 00:23:21','2022-08-29 00:27:06','2022-08-29 00:27:06'),(14,7730,2,40720,40723,13,1521,1,0,'2020-10-15','2020-10-15',4815.00,1,1.00,'Factura B N°: 0001-00000002',NULL,'2022-08-29 00:27:06','2022-09-02 04:24:05','2022-09-02 04:24:05'),(15,7730,20,40720,40723,13,1521,2,0,'2020-10-15','2020-10-15',4815.00,1,1.00,NULL,NULL,'2022-08-29 00:39:42','2022-09-02 04:26:31','2022-09-02 04:26:31'),(16,7730,3,40720,40724,57,1521,2,0,'2020-10-01','2020-10-01',3953.98,1,1.00,'Factura A N°: 0003-00004168',NULL,'2022-08-29 00:44:09','2022-08-29 01:44:34','2022-08-29 01:44:34'),(17,7730,3,40720,40725,57,1521,2,0,'2020-10-05','2020-10-05',786.50,1,1.00,'Factura B N°: 0003-00040186',NULL,'2022-08-29 00:44:09','2022-08-29 01:02:45','2022-08-29 01:02:45'),(18,7730,3,40720,40726,57,1521,2,0,'2020-10-07','2020-10-07',14400.00,1,1.00,'Factura C N°: 0002-00000102',NULL,'2022-08-29 00:44:09','2022-08-29 01:02:36','2022-08-29 01:02:36'),(19,7730,3,40720,40727,57,1521,2,0,'2020-10-08','2020-10-08',747.66,1,1.00,'Factura B N°: 0011-07066419',NULL,'2022-08-29 00:44:09','2022-08-29 00:56:54','2022-08-29 00:56:54'),(20,7730,3,40720,40724,57,1521,2,0,'2020-10-22','2020-10-22',2990.21,1,1.00,'Factura A N°: 0003-00004227',NULL,'2022-08-29 00:44:09','2022-08-29 01:45:25','2022-08-29 01:45:25'),(21,7730,3,40720,40728,57,1521,2,0,'2020-10-31','2020-10-31',989.41,1,1.00,'Factura A N°: 6364-03838983',NULL,'2022-08-29 00:44:09','2022-08-29 00:53:15','2022-08-29 00:53:15'),(22,7730,3,40720,40728,57,1521,2,0,'2020-10-31','2020-10-31',989.41,1,1.00,'Factura A N°: 6364-03838983',NULL,'2022-08-29 00:53:15','2022-08-29 01:02:22','2022-08-29 01:02:22'),(23,7730,3,40720,40727,57,1521,2,0,'2020-10-08','2020-10-08',747.66,1,1.00,'Factura B N°: 0011-07066419',NULL,'2022-08-29 00:56:54','2022-08-29 01:26:01','2022-08-29 01:26:01');
INSERT INTO `cta_cte_cliente` VALUES (24,7730,3,40720,40725,57,1521,2,0,'2020-10-05','2020-10-05',786.50,1,1.00,'Factura B N°: 0003-00040186',NULL,'2022-08-29 01:12:29','2022-08-29 01:20:08','2022-08-29 01:20:08'),(25,7730,3,40720,40725,57,1521,2,0,'2020-10-05','2020-10-05',786.50,1,1.00,'Factura B N°: 0003-00040186',NULL,'2022-08-29 01:20:08','2022-09-02 02:51:17','2022-09-02 02:51:17'),(26,7730,3,40720,40727,57,1521,2,0,'2020-10-08','2020-10-08',747.66,1,1.00,'Factura B N°: 0011-07066419',NULL,'2022-08-29 01:26:01','2022-08-29 02:09:54','2022-08-29 02:09:54'),(27,7730,3,40720,40728,57,1521,2,0,'2020-10-31','2020-10-31',989.41,1,1.00,'Factura A N°: 6364-03838983',NULL,'2022-08-29 01:31:55','2022-09-02 02:54:54','2022-09-02 02:54:54'),(28,7730,3,40720,40726,57,1521,2,0,'2020-10-07','2020-10-07',14400.00,1,1.00,'Factura C N°: 0002-00000102',NULL,'2022-08-29 01:37:02','2022-09-02 02:30:33','2022-09-02 02:30:33'),(29,7730,3,40720,40724,57,1521,2,0,'2020-10-01','2020-10-01',3953.98,1,1.00,'Factura A N°: 0003-00004168',NULL,'2022-08-29 01:44:34','2023-03-28 17:17:32',NULL),(30,7730,3,40720,40724,57,1521,2,0,'2020-10-22','2020-10-22',2990.21,1,1.00,'Factura A N°: 0003-00004227',NULL,'2022-08-29 01:45:25','2023-03-28 17:17:32',NULL),(31,7730,21,40720,40726,57,1521,1,0,'2020-10-07','2020-10-07',14400.00,1,1.00,NULL,NULL,'2022-08-29 01:53:25','2022-09-02 02:50:01','2022-09-02 02:50:01'),(32,7730,21,40720,40726,57,1521,1,0,'2020-10-05','2020-10-05',786.50,1,1.00,NULL,NULL,'2022-08-29 01:55:39','2022-08-29 01:56:02','2022-08-29 01:56:02'),(33,7730,21,40720,40726,57,1521,1,0,'2020-10-05','2020-10-05',786.50,1,1.00,NULL,NULL,'2022-08-29 01:56:57','2022-08-29 01:59:28','2022-08-29 01:59:28'),(34,7730,21,40720,40727,57,1521,1,0,'2020-10-08','2020-10-08',747.66,1,1.00,NULL,NULL,'2022-08-29 01:59:15','2022-08-29 02:06:13','2022-08-29 02:06:13'),(35,7730,21,40720,40727,57,1521,1,0,'2020-10-05','2020-10-05',786.50,1,1.00,NULL,NULL,'2022-08-29 02:01:13','2022-08-29 02:07:43','2022-08-29 02:07:43'),(36,7730,3,40720,40727,57,1521,2,0,'2020-10-08','2020-10-08',747.66,1,1.00,'Factura B N°: 0011-07066419',NULL,'2022-08-29 02:09:54','2022-09-02 02:36:32','2022-09-02 02:36:32'),(37,7730,21,40720,40727,57,1521,1,0,'2020-10-08','2020-10-08',747.66,1,1.00,NULL,NULL,'2022-08-29 02:12:05','2022-09-02 02:02:41','2022-09-02 02:02:41'),(38,7730,21,40720,40725,57,1521,1,0,'2020-10-05','2020-10-05',786.50,1,1.00,NULL,NULL,'2022-08-29 02:13:35','2022-09-02 02:50:52','2022-09-02 02:50:52'),(39,7730,21,40720,40725,57,1521,1,0,'2020-10-31','2020-10-31',989.41,1,1.00,NULL,NULL,'2022-08-29 02:14:47','2022-08-29 02:15:06','2022-08-29 02:15:06'),(40,7730,21,40720,40728,57,1521,1,0,'2020-10-31','2020-10-31',989.41,1,1.00,NULL,NULL,'2022-08-29 02:16:34','2022-09-02 02:54:54','2022-09-02 02:54:54'),(41,7730,2,40720,40729,13,1522,1,0,'2020-11-03','2020-11-03',5295.00,1,1.00,'Factura B N°: 0001-00000003',NULL,'2022-09-01 14:28:33','2022-09-01 14:33:01','2022-09-01 14:33:01'),(42,7730,2,40720,40730,13,1522,1,0,'2020-11-20','2020-11-20',11754.01,1,1.00,'Factura A N°: 0001-00000001',NULL,'2022-09-01 14:28:33','2022-09-01 14:43:32','2022-09-01 14:43:32'),(43,7730,2,40720,40731,13,1522,1,0,'2020-11-20','2020-11-20',150.00,1,1.00,'Factura B N°: 0001-00000004',NULL,'2022-09-01 14:28:33','2022-09-01 14:33:35','2022-09-01 14:33:35'),(44,7730,2,40720,40732,13,1522,1,0,'2020-11-20','2020-11-20',150.00,1,1.00,'Factura B N°: 0001-00000005',NULL,'2022-09-01 14:28:33','2022-09-01 14:34:12','2022-09-01 14:34:12'),(45,7730,2,40720,40729,13,1522,1,0,'2020-11-20','2020-11-20',219.00,1,1.00,'Factura B N°: 0001-00000006',NULL,'2022-09-01 14:28:34','2022-09-01 14:38:43','2022-09-01 14:38:43'),(46,7730,2,40720,40733,13,1522,1,0,'2020-11-20','2020-11-20',219.00,1,1.00,'Factura B N°: 0001-00000007',NULL,'2022-09-01 14:28:34','2022-09-01 14:40:17','2022-09-01 14:40:17'),(47,7730,2,40720,40734,13,1522,1,0,'2020-11-20','2020-11-20',1959.00,1,1.00,'Factura B N°: 0001-00000008',NULL,'2022-09-01 14:28:34','2022-09-01 14:41:46','2022-09-01 14:41:46');
INSERT INTO `cta_cte_cliente` VALUES (48,7730,2,40720,40735,13,1522,1,0,'2020-11-30','2020-11-30',150.00,1,1.00,'Factura A N°: 0001-00000002',NULL,'2022-09-01 14:28:34','2022-09-01 14:42:46','2022-09-01 14:42:46'),(49,7730,2,40720,40729,13,1522,1,0,'2020-11-03','2020-11-03',5295.00,1,1.00,'Factura B N°: 0001-00000003',NULL,'2022-09-01 14:33:01','2022-09-02 04:28:12','2022-09-02 04:28:12'),(50,7730,2,40720,40731,13,1522,1,0,'2020-11-20','2020-11-20',150.00,1,1.00,'Factura B N°: 0001-00000004',NULL,'2022-09-01 14:33:35','2022-09-01 14:37:19','2022-09-01 14:37:19'),(51,7730,2,40720,40732,13,1522,1,0,'2020-11-20','2020-11-20',150.00,1,1.00,'Factura B N°: 0001-00000005',NULL,'2022-09-01 14:34:12','2022-09-01 14:35:57','2022-09-01 14:35:57'),(52,7730,2,40720,40732,13,1522,1,0,'2020-11-20','2020-11-20',150.00,1,1.00,'Factura B N°: 0001-00000005',NULL,'2022-09-01 14:35:57','2022-09-02 04:29:26','2022-09-02 04:29:26'),(53,7730,2,40720,40731,13,1522,1,0,'2020-11-20','2020-11-20',150.00,1,1.00,'Factura B N°: 0001-00000004',NULL,'2022-09-01 14:37:19','2022-09-02 04:28:43','2022-09-02 04:28:43'),(54,7730,2,40720,40729,13,1522,1,0,'2020-11-20','2020-11-20',219.00,1,1.00,'Factura B N°: 0001-00000006',NULL,'2022-09-01 14:38:43','2022-09-02 04:29:38','2022-09-02 04:29:38'),(55,7730,2,40720,40733,13,1522,1,0,'2020-11-20','2020-11-20',219.00,1,1.00,'Factura B N°: 0001-00000007',NULL,'2022-09-01 14:40:17','2022-09-02 04:30:02','2022-09-02 04:30:02'),(56,7730,2,40720,40734,13,1522,1,0,'2020-11-20','2020-11-20',1959.00,1,1.00,'Factura B N°: 0001-00000008',NULL,'2022-09-01 14:41:46','2022-09-02 04:30:20','2022-09-02 04:30:20'),(57,7730,2,40720,40735,13,1522,1,0,'2020-11-30','2020-11-30',150.00,1,1.00,'Factura A N°: 0001-00000002',NULL,'2022-09-01 14:42:46','2022-09-02 04:30:32','2022-09-02 04:30:32'),(58,7730,2,40720,40730,13,1522,1,0,'2020-11-20','2020-11-20',11754.01,1,1.00,'Factura A N°: 0001-00000001',NULL,'2022-09-01 14:43:32','2022-09-02 04:28:27','2022-09-02 04:28:27'),(59,7730,20,40720,40718,13,1522,2,0,'2020-11-03','2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-01 18:27:19','2022-09-01 18:29:15','2022-09-01 18:29:15'),(60,7730,20,40720,40718,13,1522,2,0,'2020-11-20','2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-01 18:29:03','2022-09-01 18:32:07','2022-09-01 18:32:07'),(61,7730,20,40720,40718,13,1522,2,0,'2020-11-03','2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-01 18:31:32','2022-09-01 18:51:47','2022-09-01 18:51:47'),(62,7730,20,40720,40718,13,1522,2,0,'2020-11-20','2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 18:50:21','2022-09-01 18:50:39','2022-09-01 18:50:39'),(63,7730,20,40720,40729,13,1522,2,0,'2020-11-03','2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-01 18:56:40','2022-09-02 04:26:39','2022-09-02 04:26:39'),(64,7730,20,40720,40729,13,1522,2,0,'2020-11-20','2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 19:00:43','2022-09-01 19:27:11','2022-09-01 19:27:11'),(65,7730,20,40720,40729,13,1522,2,0,'2020-11-20','2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-01 19:28:36','2022-09-02 04:26:35','2022-09-02 04:26:35'),(66,7730,20,40720,40731,13,1522,2,0,'2020-11-20','2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 19:30:20','2022-09-02 04:26:43','2022-09-02 04:26:43'),(67,7730,20,40720,40731,13,1522,2,0,'2020-11-20','2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 19:32:09','2022-09-01 19:32:44','2022-09-01 19:32:44'),(68,7730,20,40720,40732,13,1522,2,0,'2020-11-20','2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 19:34:00','2022-09-02 04:26:47','2022-09-02 04:26:47'),(69,7730,20,40720,40733,13,1522,2,0,'2020-11-20','2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-01 19:35:26','2022-09-02 04:26:50','2022-09-02 04:26:50'),(70,7730,20,40720,40733,13,1522,2,0,'2020-11-20','2020-11-20',1959.00,1,1.00,NULL,NULL,'2022-09-01 19:36:21','2022-09-01 19:36:31','2022-09-01 19:36:31'),(71,7730,20,40720,40734,13,1522,2,0,'2020-11-20','2020-11-20',1959.00,1,1.00,NULL,NULL,'2022-09-01 19:37:39','2022-09-02 04:26:54','2022-09-02 04:26:54');
INSERT INTO `cta_cte_cliente` VALUES (72,7730,20,40720,40730,13,1522,2,0,'2020-11-20','2020-11-20',11754.01,1,1.00,NULL,NULL,'2022-09-01 19:38:51','2022-09-02 04:26:58','2022-09-02 04:26:58'),(73,7730,20,40720,40735,13,1522,2,0,'2020-11-30','2020-11-30',150.00,1,1.00,NULL,NULL,'2022-09-01 19:39:57','2022-09-02 04:27:02','2022-09-02 04:27:02'),(74,7730,3,40720,40727,57,1522,2,0,'2020-11-10','2020-11-10',1346.89,1,1.00,'Factura A N°: 0011-00943147',NULL,'2022-09-02 00:53:11','2022-09-02 00:56:28','2022-09-02 00:56:28'),(75,7730,3,40720,40727,57,1522,2,0,'2020-11-10','2020-11-10',1346.92,1,1.00,'Factura A N°: 0011-00943147',NULL,'2022-09-02 00:56:28','2022-09-02 00:57:48','2022-09-02 00:57:48'),(76,7730,3,40720,40727,57,1522,2,0,'2020-11-10','2020-11-10',1346.89,1,1.00,'Factura A N°: 0011-00943147',NULL,'2022-09-02 00:57:48','2022-09-02 00:58:14','2022-09-02 00:58:14'),(77,7730,3,40720,40727,57,1522,2,0,'2020-11-10','2020-11-10',1346.89,1,1.00,'Factura A N°: 0011-00943147',NULL,'2022-09-02 00:58:14','2022-09-02 00:58:14',NULL),(78,7730,21,40720,40727,57,1521,1,0,'2020-10-08','2020-10-08',747.66,1,1.00,NULL,NULL,'2022-09-02 02:26:47','2022-09-02 02:36:33','2022-09-02 02:36:33'),(79,7730,3,40720,40727,57,1521,2,0,'2020-10-08','2020-10-08',747.66,1,1.00,'Factura B N°: 0011-07066419',NULL,'2022-09-02 03:17:22','2022-09-02 03:20:56','2022-09-02 03:20:56'),(80,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5271.99,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-09-02 04:23:51','2022-09-02 04:43:00','2022-09-02 04:43:00'),(81,7730,2,40720,40723,13,1521,1,0,'2020-10-15','2020-10-15',4815.00,1,1.00,'Factura B N°: 0001-00000002',NULL,'2022-09-02 04:24:05','2022-09-02 04:24:05',NULL),(82,7730,2,40720,40729,13,1522,1,0,'2020-11-03','2020-11-03',5295.00,1,1.00,'Factura B N°: 0001-00000003',NULL,'2022-09-02 04:28:12','2022-09-02 04:28:12',NULL),(83,7730,2,40720,40730,13,1522,1,0,'2020-11-20','2020-11-20',11754.01,1,1.00,'Factura A N°: 0001-00000001',NULL,'2022-09-02 04:28:27','2022-09-04 02:29:11','2022-09-04 02:29:11'),(84,7730,2,40720,40731,13,1522,1,0,'2020-11-20','2020-11-20',150.00,1,1.00,'Factura B N°: 0001-00000004',NULL,'2022-09-02 04:28:43','2022-09-02 04:28:43',NULL),(85,7730,2,40720,40732,13,1522,1,0,'2020-11-20','2020-11-20',150.00,1,1.00,'Factura B N°: 0001-00000005',NULL,'2022-09-02 04:29:26','2022-09-02 04:29:26',NULL),(86,7730,2,40720,40729,13,1522,1,0,'2020-11-20','2020-11-20',219.00,1,1.00,'Factura B N°: 0001-00000006',NULL,'2022-09-02 04:29:38','2022-09-02 04:29:38',NULL),(87,7730,2,40720,40733,13,1522,1,0,'2020-11-20','2020-11-20',219.00,1,1.00,'Factura B N°: 0001-00000007',NULL,'2022-09-02 04:30:02','2022-09-02 04:30:02',NULL),(88,7730,2,40720,40734,13,1522,1,0,'2020-11-20','2020-11-20',1959.00,1,1.00,'Factura B N°: 0001-00000008',NULL,'2022-09-02 04:30:20','2022-09-02 04:30:20',NULL),(89,7730,2,40720,40735,13,1522,1,0,'2020-11-30','2020-11-30',150.00,1,1.00,'Factura A N°: 0001-00000002',NULL,'2022-09-02 04:30:32','2022-09-04 02:28:54','2022-09-04 02:28:54'),(90,7730,2,40720,40721,13,1520,1,0,'2020-09-30','2020-09-30',5272.00,1,1.00,'Factura B N°: 0001-00000001',NULL,'2022-09-02 04:44:36','2022-09-02 04:44:36',NULL),(91,7730,20,40720,40721,13,1520,2,0,'2020-09-30','2020-09-30',5272.00,1,1.00,NULL,NULL,'2022-09-02 04:48:48','2022-09-02 04:48:48',NULL),(92,7730,20,40720,40723,13,1521,2,0,'2020-10-15','2020-10-15',4815.00,1,1.00,NULL,NULL,'2022-09-02 04:50:02','2022-09-02 04:50:02',NULL),(93,7730,20,40720,40729,13,1521,2,0,'2020-11-03','2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-02 04:51:17','2022-09-02 05:10:29','2022-09-02 05:10:29'),(94,7730,20,40720,40729,13,1522,2,0,'2020-11-20','2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-02 04:52:22','2022-09-02 04:52:22',NULL),(95,7730,20,40720,40729,13,1522,2,0,'2020-11-20','2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-02 04:53:18','2022-09-02 04:53:30','2022-09-02 04:53:30'),(96,7730,20,40720,40731,13,1522,2,0,'2020-11-20','2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-02 04:54:33','2022-09-02 04:54:33',NULL);
INSERT INTO `cta_cte_cliente` VALUES (97,7730,20,40720,40732,13,1522,2,0,'2020-11-20','2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-02 04:55:29','2022-09-02 04:55:29',NULL),(98,7730,20,40720,40733,13,1522,2,0,'2020-11-20','2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-02 04:56:45','2022-09-02 04:56:45',NULL),(99,7730,20,40720,40734,13,1522,2,0,'2020-11-20','2020-11-20',1959.00,1,1.00,NULL,NULL,'2022-09-02 04:57:54','2022-09-02 04:57:54',NULL),(100,7730,20,40720,40730,13,1522,2,0,'2020-11-20','2020-11-20',11754.01,1,1.00,NULL,NULL,'2022-09-02 04:58:54','2022-09-04 02:28:22','2022-09-04 02:28:22'),(101,7730,20,40720,40735,13,1522,2,0,'2020-11-30','2020-11-30',150.00,1,1.00,NULL,NULL,'2022-09-02 04:59:43','2022-09-04 02:28:10','2022-09-04 02:28:10'),(102,7730,20,40720,40729,13,1522,2,0,'2020-11-03','2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-02 05:11:36','2022-09-02 05:11:36',NULL),(103,7730,21,40720,40727,57,1522,1,0,'2020-11-12','2020-11-12',1346.89,1,1.00,NULL,NULL,'2022-09-03 23:06:29','2022-09-03 23:06:29',NULL),(104,7730,2,40720,40735,13,1522,1,0,'2020-11-30','2020-11-30',150.00,1,1.00,'Factura A N°: 0001-00000002',NULL,'2022-09-04 02:28:54','2022-09-04 02:28:54',NULL),(105,7730,2,40720,40730,13,1522,1,0,'2020-11-20','2020-11-20',11754.01,1,1.00,'Factura A N°: 0001-00000001',NULL,'2022-09-04 02:29:11','2022-09-04 02:29:11',NULL),(106,7730,20,40720,40730,13,1522,2,0,'2020-11-20','2020-11-20',11754.01,1,1.00,NULL,NULL,'2022-09-04 02:30:53','2022-09-04 02:30:53',NULL),(107,7730,20,40720,40735,13,1522,2,0,'2020-11-30','2020-11-30',150.00,1,1.00,NULL,NULL,'2022-09-04 02:32:18','2022-09-04 02:32:18',NULL),(108,7730,2,40720,40736,13,1523,1,0,'2020-12-03','2020-12-03',7239.00,1,1.00,'Factura B N°: 0001-00000009',NULL,'2022-09-04 03:29:55','2022-09-04 03:34:24','2022-09-04 03:34:24'),(109,7730,2,40720,40737,13,1523,1,0,'2020-12-03','2020-12-03',7239.00,1,1.00,'Factura B N°: 0001-00000010',NULL,'2022-09-04 03:29:55','2022-09-04 03:37:12','2022-09-04 03:37:12'),(110,7730,2,40720,40738,13,1523,1,0,'2020-12-03','2020-12-03',7239.00,1,1.00,'Factura B N°: 0001-00000011',NULL,'2022-09-04 03:29:56','2022-09-04 03:40:13','2022-09-04 03:40:13'),(111,7730,2,40720,40739,13,1523,1,0,'2020-12-04','2020-12-04',14478.00,1,1.00,'Factura B N°: 0001-00000012',NULL,'2022-09-04 03:29:56','2022-09-04 03:45:21','2022-09-04 03:45:21'),(112,7730,2,40720,40740,13,1523,1,0,'2020-12-07','2020-12-07',7239.00,1,1.00,'Factura B N°: 0001-00000013',NULL,'2022-09-04 03:29:56','2022-09-04 03:49:24','2022-09-04 03:49:24'),(113,7730,2,40720,40741,13,1523,1,0,'2020-12-07','2020-12-07',8685.00,1,1.00,'Factura B N°: 0001-00000014',NULL,'2022-09-04 03:29:56','2022-09-04 03:47:43','2022-09-04 03:47:43'),(114,7730,2,40720,40742,13,1523,1,0,'2020-12-09','2020-12-09',7239.00,1,1.00,'Factura B N°: 0001-00000015',NULL,'2022-09-04 03:29:56','2022-09-04 03:51:07','2022-09-04 03:51:07'),(115,7730,2,40720,40743,13,1523,1,0,'2020-12-09','2020-12-09',7239.00,1,1.00,'Factura B N°: 0001-00000016',NULL,'2022-09-04 03:29:56','2022-09-04 03:53:01','2022-09-04 03:53:01'),(116,7730,2,40720,40744,13,1523,1,0,'2020-12-10','2020-12-10',7239.00,1,1.00,'Factura B N°: 0001-00000017',NULL,'2022-09-04 03:29:56','2022-09-04 03:54:26','2022-09-04 03:54:26'),(117,7730,2,40720,40745,13,1523,1,0,'2020-12-17','2020-12-17',8685.00,1,1.00,'Factura A N°: 0001-00000003',NULL,'2022-09-04 03:29:56','2022-09-04 03:29:56',NULL),(118,7730,2,40720,40746,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000018',NULL,'2022-09-04 03:29:56','2022-09-04 03:57:17','2022-09-04 03:57:17'),(119,7730,2,40720,40747,13,1523,1,0,'2020-12-17','2020-12-17',4955.00,1,1.00,'Factura B N°: 0001-00000019',NULL,'2022-09-04 03:29:56','2022-09-04 04:18:26','2022-09-04 04:18:26'),(120,7730,2,40720,40748,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000020',NULL,'2022-09-04 03:29:56','2022-09-04 04:04:23','2022-09-04 04:04:23');
INSERT INTO `cta_cte_cliente` VALUES (121,7730,2,40720,40749,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000021',NULL,'2022-09-04 03:29:56','2022-09-04 04:06:04','2022-09-04 04:06:04'),(122,7730,2,40720,40750,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000022',NULL,'2022-09-04 03:29:56','2022-09-04 04:07:36','2022-09-04 04:07:36'),(123,7730,2,40720,40751,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000023',NULL,'2022-09-04 03:29:56','2022-09-04 04:09:11','2022-09-04 04:09:11'),(124,7730,2,40720,40752,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000024',NULL,'2022-09-04 03:29:56','2022-09-04 04:12:01','2022-09-04 04:12:01'),(125,7730,2,40720,40753,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000025',NULL,'2022-09-04 03:29:56','2022-09-04 04:13:18','2022-09-04 04:13:18'),(126,7730,2,40720,40754,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000026',NULL,'2022-09-04 03:29:56','2022-09-04 04:14:25','2022-09-04 04:14:25'),(127,7730,2,40720,40755,13,1523,1,0,'2020-12-17','2020-12-17',8685.00,1,1.00,'Factura B N°: 0001-00000027',NULL,'2022-09-04 03:29:56','2022-09-04 04:10:49','2022-09-04 04:10:49'),(128,7730,2,40720,40752,13,1523,1,0,'2020-12-17','2020-12-17',3880.00,1,1.00,'Factura B N°: 0001-00000028',NULL,'2022-09-04 03:29:56','2022-09-04 04:19:28','2022-09-04 04:19:28'),(129,7730,2,40720,40756,13,1523,1,0,'2020-12-17','2020-12-17',7239.00,1,1.00,'Factura B N°: 0001-00000029',NULL,'2022-09-04 03:29:56','2022-09-04 04:15:43','2022-09-04 04:15:43'),(130,7730,2,40720,40757,13,1523,1,0,'2020-12-17','2020-12-17',14478.00,1,1.00,'Factura B N°: 0001-00000030',NULL,'2022-09-04 03:29:56','2022-09-04 04:20:58','2022-09-04 04:20:58'),(131,7730,2,40720,40758,13,1523,1,0,'2020-12-18','2020-12-18',7239.00,1,1.00,'Factura B N°: 0001-00000031',NULL,'2022-09-04 03:29:56','2022-09-04 04:22:49','2022-09-04 04:22:49'),(132,7730,2,40720,40759,13,1523,1,0,'2020-12-22','2020-12-22',7971.00,1,1.00,'Factura B N°: 0001-00000032',NULL,'2022-09-04 03:29:56','2022-09-04 04:24:10','2022-09-04 04:24:10'),(133,7730,2,40720,40760,13,1523,1,0,'2020-12-22','2020-12-22',7239.00,1,1.00,'Factura B N°: 0001-00000033',NULL,'2022-09-04 03:29:57','2022-09-04 04:25:04','2022-09-04 04:25:04'),(134,7730,2,40720,40736,13,1523,1,0,'2020-12-03','2020-12-03',7238.99,1,1.00,'Factura B N°: 0001-00000009',NULL,'2022-09-04 03:34:24','2022-09-04 03:35:39','2022-09-04 03:35:39'),(135,7730,2,40720,40736,13,1523,1,0,'2020-12-03','2020-12-03',7238.99,1,1.00,'Factura B N°: 0001-00000009',NULL,'2022-09-04 03:35:39','2022-09-04 03:36:17','2022-09-04 03:36:17'),(136,7730,2,40720,40736,13,1523,1,0,'2020-12-03','2020-12-03',7238.99,1,1.00,'Factura B N°: 0001-00000009',NULL,'2022-09-04 03:36:17','2022-09-04 03:41:24','2022-09-04 03:41:24'),(137,7730,2,40720,40737,13,1523,1,0,'2020-12-03','2020-12-03',7238.99,1,1.00,'Factura B N°: 0001-00000010',NULL,'2022-09-04 03:37:12','2022-09-04 03:42:40','2022-09-04 03:42:40'),(138,7730,2,40720,40738,13,1523,1,0,'2020-12-03','2020-12-03',7238.99,1,1.00,'Factura B N°: 0001-00000011',NULL,'2022-09-04 03:40:13','2022-09-04 03:43:54','2022-09-04 03:43:54'),(139,7730,2,40720,40736,13,1523,1,0,'2020-12-03','2020-12-03',7238.99,1,1.00,'Factura B N°: 0001-00000009',NULL,'2022-09-04 03:41:24','2022-09-04 03:41:24',NULL),(140,7730,2,40720,40737,13,1523,1,0,'2020-12-03','2020-12-03',7238.99,1,1.00,'Factura B N°: 0001-00000010',NULL,'2022-09-04 03:42:40','2022-09-04 03:42:40',NULL),(141,7730,2,40720,40738,13,1523,1,0,'2020-12-03','2020-12-03',7238.99,1,1.00,'Factura B N°: 0001-00000011',NULL,'2022-09-04 03:43:54','2022-09-04 03:43:54',NULL),(142,7730,2,40720,40739,13,1523,1,0,'2020-12-04','2020-12-04',14478.00,1,1.00,'Factura B N°: 0001-00000012',NULL,'2022-09-04 03:45:21','2022-09-04 03:45:21',NULL);
INSERT INTO `cta_cte_cliente` VALUES (143,7730,2,40720,40741,13,1523,1,0,'2020-12-07','2020-12-07',8685.00,1,1.00,'Factura B N°: 0001-00000014',NULL,'2022-09-04 03:47:43','2022-09-04 03:47:43',NULL),(144,7730,2,40720,40740,13,1523,1,0,'2020-12-07','2020-12-07',7238.99,1,1.00,'Factura B N°: 0001-00000013',NULL,'2022-09-04 03:49:24','2022-09-04 03:49:24',NULL),(145,7730,2,40720,40742,13,1523,1,0,'2020-12-09','2020-12-09',7238.99,1,1.00,'Factura B N°: 0001-00000015',NULL,'2022-09-04 03:51:07','2022-09-04 03:51:07',NULL),(146,7730,2,40720,40743,13,1523,1,0,'2020-12-09','2020-12-09',7238.99,1,1.00,'Factura B N°: 0001-00000016',NULL,'2022-09-04 03:53:01','2022-09-04 03:53:01',NULL),(147,7730,2,40720,40744,13,1523,1,0,'2020-12-10','2020-12-10',7238.99,1,1.00,'Factura B N°: 0001-00000017',NULL,'2022-09-04 03:54:26','2022-09-04 03:54:26',NULL),(148,7730,2,40720,40746,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000018',NULL,'2022-09-04 03:57:17','2022-09-04 03:59:00','2022-09-04 03:59:00'),(149,7730,2,40720,40746,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000018',NULL,'2022-09-04 03:59:00','2022-09-04 04:02:49','2022-09-04 04:02:49'),(150,7730,2,40720,40746,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000018',NULL,'2022-09-04 04:02:49','2022-09-04 04:02:49',NULL),(151,7730,2,40720,40748,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000020',NULL,'2022-09-04 04:04:23','2022-09-04 04:47:07','2022-09-04 04:47:07'),(152,7730,2,40720,40749,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000021',NULL,'2022-09-04 04:06:04','2022-09-04 04:06:04',NULL),(153,7730,2,40720,40750,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000022',NULL,'2022-09-04 04:07:36','2022-09-04 04:07:36',NULL),(154,7730,2,40720,40751,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000023',NULL,'2022-09-04 04:09:11','2022-09-04 04:09:11',NULL),(155,7730,2,40720,40755,13,1523,1,0,'2020-12-17','2020-12-17',8685.00,1,1.00,'Factura B N°: 0001-00000027',NULL,'2022-09-04 04:10:49','2022-09-04 04:10:49',NULL),(156,7730,2,40720,40752,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000024',NULL,'2022-09-04 04:12:01','2022-09-04 04:12:01',NULL),(157,7730,2,40720,40753,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000025',NULL,'2022-09-04 04:13:18','2022-09-04 04:13:18',NULL),(158,7730,2,40720,40754,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000026',NULL,'2022-09-04 04:14:25','2022-09-04 04:14:25',NULL),(159,7730,2,40720,40756,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000029',NULL,'2022-09-04 04:15:43','2022-09-04 04:15:43',NULL),(160,7730,2,40720,40747,13,1523,1,0,'2020-12-17','2020-12-17',4955.00,1,1.00,'Factura B N°: 0001-00000019',NULL,'2022-09-04 04:18:26','2022-09-04 04:18:26',NULL),(161,7730,2,40720,40752,13,1523,1,0,'2020-12-17','2020-12-17',3880.00,1,1.00,'Factura B N°: 0001-00000028',NULL,'2022-09-04 04:19:28','2022-09-04 04:19:28',NULL),(162,7730,2,40720,40757,13,1523,1,0,'2020-12-17','2020-12-17',14478.00,1,1.00,'Factura B N°: 0001-00000030',NULL,'2022-09-04 04:20:58','2022-09-04 04:20:58',NULL),(163,7730,2,40720,40758,13,1523,1,0,'2020-12-18','2020-12-18',7238.99,1,1.00,'Factura B N°: 0001-00000031',NULL,'2022-09-04 04:22:49','2022-09-04 04:22:49',NULL),(164,7730,2,40720,40759,13,1523,1,0,'2020-12-22','2020-12-22',7971.00,1,1.00,'Factura B N°: 0001-00000032',NULL,'2022-09-04 04:24:10','2022-09-04 04:24:10',NULL),(165,7730,2,40720,40760,13,1523,1,0,'2020-12-22','2020-12-22',7238.99,1,1.00,'Factura B N°: 0001-00000033',NULL,'2022-09-04 04:25:04','2022-09-04 04:25:04',NULL),(166,7730,20,40720,40736,13,1523,2,0,'2020-12-03','2020-12-03',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:29:57','2022-09-04 04:29:57',NULL);
INSERT INTO `cta_cte_cliente` VALUES (167,7730,20,40720,40737,13,1523,2,0,'2020-12-03','2020-12-03',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:31:28','2022-09-04 04:31:28',NULL),(168,7730,20,40720,40738,13,1523,2,0,'2020-12-03','2020-12-03',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:37:21','2022-09-04 04:37:21',NULL),(169,7730,20,40720,40739,13,1523,2,0,'2020-12-04','2020-12-04',14478.00,1,1.00,NULL,NULL,'2022-09-04 04:38:26','2022-09-04 04:38:26',NULL),(170,7730,20,40720,40741,13,1523,2,0,'2020-12-07','2020-12-07',8685.00,1,1.00,NULL,NULL,'2022-09-04 04:39:39','2022-09-04 04:39:39',NULL),(171,7730,20,40720,40740,13,1523,2,0,'2020-12-07','2020-12-07',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:40:44','2022-09-04 04:40:44',NULL),(172,7730,20,40720,40742,13,1523,2,0,'2020-12-09','2020-12-09',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:42:14','2022-09-04 04:42:14',NULL),(173,7730,20,40720,40743,13,1523,2,0,'2020-12-09','2020-12-09',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:43:40','2022-09-04 04:43:40',NULL),(174,7730,20,40720,40744,13,1523,2,0,'2020-12-10','2020-12-10',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:44:24','2022-09-04 04:44:24',NULL),(175,7730,20,40720,40746,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:45:26','2022-09-04 04:45:26',NULL),(176,7730,2,40720,40748,13,1523,1,0,'2020-12-17','2020-12-17',7238.99,1,1.00,'Factura B N°: 0001-00000020',NULL,'2022-09-04 04:47:07','2022-09-04 04:47:07',NULL),(177,7730,20,40720,40748,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:47:59','2022-09-04 04:47:59',NULL),(178,7730,20,40720,40749,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:48:58','2022-09-04 04:48:58',NULL),(179,7730,20,40720,40750,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:50:16','2022-09-04 04:50:16',NULL),(180,7730,20,40720,40751,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:51:10','2022-09-04 04:51:10',NULL),(181,7730,20,40720,40755,13,1523,2,0,'2020-12-17','2020-12-17',8685.00,1,1.00,NULL,NULL,'2022-09-04 04:52:07','2022-09-04 04:52:07',NULL),(182,7730,20,40720,40752,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:53:16','2022-09-04 04:53:16',NULL),(183,7730,20,40720,40753,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:54:08','2022-09-04 04:54:08',NULL),(184,7730,20,40720,40754,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:55:06','2022-09-04 04:55:06',NULL),(185,7730,20,40720,40756,13,1523,2,0,'2020-12-17','2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:56:15','2022-09-04 04:56:15',NULL),(186,7730,20,40720,40745,13,1523,2,0,'2020-12-17','2020-12-17',8685.00,1,1.00,NULL,NULL,'2022-09-04 04:57:04','2022-09-04 04:57:04',NULL),(187,7730,20,40720,40747,13,1523,2,0,'2020-12-17','2020-12-17',4955.00,1,1.00,NULL,NULL,'2022-09-04 04:57:56','2022-09-04 04:57:56',NULL),(188,7730,20,40720,40752,13,1523,2,0,'2020-12-17','2020-12-17',3880.00,1,1.00,NULL,NULL,'2022-09-04 04:58:49','2022-09-04 04:58:49',NULL),(189,7730,20,40720,40757,13,1523,2,0,'2020-12-17','2020-12-17',14478.00,1,1.00,NULL,NULL,'2022-09-04 04:59:44','2022-09-04 04:59:44',NULL),(190,7730,20,40720,40758,13,1523,2,0,'2020-12-18','2020-12-18',7238.99,1,1.00,NULL,NULL,'2022-09-04 05:00:55','2022-09-04 05:00:55',NULL),(191,7730,20,40720,40759,13,1523,2,0,'2020-12-22','2020-12-22',7971.00,1,1.00,NULL,NULL,'2022-09-04 05:01:50','2022-09-04 05:01:50',NULL),(192,7730,20,40720,40760,13,1523,2,0,'2020-12-22','2020-12-22',7238.99,1,1.00,NULL,NULL,'2022-09-04 05:02:47','2022-09-04 05:02:47',NULL),(193,7730,3,40720,40761,57,1523,2,0,'2020-12-03','2020-12-03',1513750.00,1,1.00,'Factura A N°: 0031-00001752',NULL,'2022-09-04 05:07:48','2022-09-04 05:17:23','2022-09-04 05:17:23'),(194,7730,3,40720,40762,57,1523,2,0,'2020-12-04','2020-12-04',20000.00,1,1.00,'Factura C N°: 0002-00000027',NULL,'2022-09-04 05:07:48','2022-09-04 05:28:22','2022-09-04 05:28:22');
INSERT INTO `cta_cte_cliente` VALUES (195,7730,3,40720,40727,57,1523,2,0,'2020-12-09','2020-12-09',17067.75,1,1.00,'Factura A N°: 0011-00976912',NULL,'2022-09-04 05:07:48','2022-09-04 05:13:32','2022-09-04 05:13:32'),(196,7730,3,40720,40761,57,1523,1,0,'2020-12-09','2020-12-09',1513750.00,1,1.00,'Nota de crédito A N°: 0031-00000183',NULL,'2022-09-04 05:07:48','2022-09-04 05:16:20','2022-09-04 05:16:20'),(197,7730,3,40720,40763,57,1523,2,0,'2020-12-09','2020-12-09',1513750.00,1,1.00,'Factura A N°: 0031-00000462',NULL,'2022-09-04 05:07:49','2022-09-04 05:18:16','2022-09-04 05:18:16'),(198,7730,3,40720,40764,57,1523,2,0,'2020-12-17','2020-12-17',84572.83,1,1.00,'Factura A N°: 0002-00000041',NULL,'2022-09-04 05:07:49','2022-09-04 10:51:32','2022-09-04 10:51:32'),(199,7730,3,40720,40764,57,1523,2,0,'2020-12-18','2020-12-18',5880.60,1,1.00,'Factura A N°: 0002-00000042',NULL,'2022-09-04 05:07:49','2022-09-04 10:51:55','2022-09-04 10:51:55'),(200,7730,3,40720,40764,57,1523,2,0,'2020-12-22','2020-12-22',47044.80,1,1.00,'Factura A N°: 0002-00000043',NULL,'2022-09-04 05:07:49','2022-09-04 10:52:38','2022-09-04 10:52:38'),(201,7730,3,40720,40727,57,1523,2,0,'2020-12-09','2020-12-09',21155.94,1,1.00,'Factura A N°: 0011-00976912',NULL,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(202,7730,3,40720,40727,57,1523,2,0,'2020-12-09','2020-12-09',17067.75,1,1.00,'Factura A N°: 0011-00976912',NULL,'2022-09-04 05:13:57','2022-09-04 05:13:57',NULL),(203,7730,3,40720,40761,57,1523,1,0,'2020-12-09','2020-12-09',1513750.00,1,1.00,'Nota de crédito A N°: 0031-00000183',NULL,'2022-09-04 05:16:20','2022-09-04 05:16:20',NULL),(204,7730,3,40720,40761,57,1523,2,0,'2020-12-03','2020-12-03',1513750.00,1,1.00,'Factura A N°: 0031-00001752',NULL,'2022-09-04 05:17:23','2022-09-04 05:17:23',NULL),(205,7730,3,40720,40763,57,1523,2,0,'2020-12-09','2020-12-09',1513750.00,1,1.00,'Factura A N°: 0031-00000462',NULL,'2022-09-04 05:18:16','2023-03-29 14:02:04',NULL),(206,7730,21,40720,40727,57,1523,1,0,'2020-12-09','2020-12-09',17067.75,1,1.00,NULL,NULL,'2022-09-04 05:23:20','2022-09-04 05:23:20',NULL),(207,7730,3,40720,40762,57,1523,2,0,'2020-12-04','2020-12-04',20000.00,1,1.00,'Factura C N°: 0002-00000027',NULL,'2022-09-04 05:28:22','2022-09-04 05:28:22',NULL),(208,7730,21,40720,40762,57,1523,1,0,'2020-12-15','2020-12-15',20000.00,1,1.00,NULL,NULL,'2022-09-04 05:34:03','2022-09-04 05:34:03',NULL),(209,7730,3,40720,40764,57,1523,2,1,'2020-12-17','2020-12-17',84572.83,1,1.00,'Factura A N°: 0002-00000041',NULL,'2022-09-04 10:51:32','2023-03-27 18:58:21',NULL),(210,7730,3,40720,40764,57,1523,2,1,'2020-12-18','2020-12-18',5880.60,1,1.00,'Factura A N°: 0002-00000042',NULL,'2022-09-04 10:51:55','2023-03-27 18:58:21',NULL),(211,7730,3,40720,40764,57,1523,2,1,'2020-12-22','2020-12-22',47044.80,1,1.00,'Factura A N°: 0002-00000043',NULL,'2022-09-04 10:52:38','2023-03-27 18:58:21',NULL),(212,7730,2,40720,40745,13,1525,2,0,'2021-01-04','2021-01-04',1446.00,1,1.00,'Nota de crédito A N°: 0001-00000001',NULL,'2023-03-26 23:30:20','2023-03-27 11:15:02','2023-03-27 11:15:02'),(213,7730,2,40720,40765,13,1525,1,0,'2021-01-04','2021-01-04',6490.00,1,1.00,'Factura B N°: 0001-00000034',NULL,'2023-03-26 23:30:20','2023-03-27 11:14:55','2023-03-27 11:14:55'),(214,7730,2,40720,40765,13,1525,1,0,'2021-01-04','2021-01-04',1600.00,1,1.00,'Factura B N°: 0001-00000035',NULL,'2023-03-26 23:30:20','2023-03-27 11:14:48','2023-03-27 11:14:48'),(215,7730,2,40720,40766,13,1525,1,0,'2021-01-06','2021-01-06',7590.00,1,1.00,'Factura B N°: 0001-00000036',NULL,'2023-03-26 23:30:20','2023-03-27 11:14:39','2023-03-27 11:14:39'),(216,7730,2,40720,40767,13,1525,1,0,'2021-01-06','2021-01-06',7590.00,1,1.00,'Factura B N°: 0001-00000037',NULL,'2023-03-26 23:30:20','2023-03-27 11:14:31','2023-03-27 11:14:31'),(217,7730,2,40720,40767,13,1525,1,0,'2021-01-06','2021-01-06',1500.00,1,1.00,'Factura B N°: 0001-00000038',NULL,'2023-03-26 23:30:20','2023-03-27 11:14:21','2023-03-27 11:14:21');
INSERT INTO `cta_cte_cliente` VALUES (218,7730,2,40720,40768,13,1525,1,0,'2021-01-06','2021-01-06',19470.00,1,1.00,'Factura B N°: 0001-00000039',NULL,'2023-03-26 23:30:20','2023-03-27 11:14:13','2023-03-27 11:14:13'),(219,7730,2,40720,40769,13,1525,1,0,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000040',NULL,'2023-03-26 23:30:20','2023-03-27 11:14:04','2023-03-27 11:14:04'),(220,7730,2,40720,40770,13,1525,1,0,'2021-01-07','2021-01-07',7590.00,1,1.00,'Factura B N°: 0001-00000041',NULL,'2023-03-26 23:30:20','2023-03-27 11:13:57','2023-03-27 11:13:57'),(221,7730,2,40720,40771,13,1525,1,0,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000042',NULL,'2023-03-26 23:30:20','2023-03-27 11:13:48','2023-03-27 11:13:48'),(222,7730,2,40720,40772,13,1525,1,0,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000043',NULL,'2023-03-26 23:30:20','2023-03-27 11:13:40','2023-03-27 11:13:40'),(223,7730,2,40720,40773,13,1525,1,0,'2021-01-12','2021-01-12',150.00,1,1.00,'Factura B N°: 0001-00000044',NULL,'2023-03-26 23:30:20','2023-03-27 11:13:32','2023-03-27 11:13:32'),(224,7730,2,40720,40774,13,1525,1,0,'2021-01-12','2021-01-12',7590.00,1,1.00,'Factura B N°: 0001-00000045',NULL,'2023-03-26 23:30:20','2023-03-27 11:13:25','2023-03-27 11:13:25'),(225,7730,2,40720,40731,13,1525,1,0,'2021-01-13','2021-01-13',150.00,1,1.00,'Factura B N°: 0001-00000046',NULL,'2023-03-26 23:30:20','2023-03-27 11:13:19','2023-03-27 11:13:19'),(226,7730,2,40720,40775,13,1525,1,0,'2021-01-13','2021-01-13',150.00,1,1.00,'Factura B N°: 0001-00000047',NULL,'2023-03-26 23:30:20','2023-03-27 11:13:10','2023-03-27 11:13:10'),(227,7730,2,40720,40733,13,1525,1,0,'2021-01-13','2021-01-13',799.00,1,1.00,'Factura B N°: 0001-00000048',NULL,'2023-03-26 23:30:20','2023-03-27 11:13:00','2023-03-27 11:13:00'),(228,7730,2,40720,40764,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura A N°: 0001-00000005',NULL,'2023-03-26 23:30:20','2023-03-27 11:12:53','2023-03-27 11:12:53'),(229,7730,2,40720,40776,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000049',NULL,'2023-03-26 23:30:20','2023-03-27 11:12:46','2023-03-27 11:12:46'),(230,7730,2,40720,40777,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000050',NULL,'2023-03-26 23:30:20','2023-03-27 11:12:39','2023-03-27 11:12:39'),(231,7730,2,40720,40733,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000051',NULL,'2023-03-26 23:30:21','2023-03-27 11:12:11','2023-03-27 11:12:11'),(232,7730,2,40720,40778,13,1525,1,0,'2021-01-15','2021-01-15',150.00,1,1.00,'Factura B N°: 0001-00000052',NULL,'2023-03-26 23:30:21','2023-03-27 11:12:03','2023-03-27 11:12:03'),(233,7730,2,40720,40779,13,1525,1,0,'2021-01-18','2021-01-18',1379.00,1,1.00,'Factura B N°: 0001-00000053',NULL,'2023-03-26 23:30:21','2023-03-27 11:10:53','2023-03-27 11:10:53'),(234,7730,2,40720,40780,13,1525,1,0,'2021-01-18','2021-01-18',7590.00,1,1.00,'Factura B N°: 0001-00000054',NULL,'2023-03-26 23:30:21','2023-03-27 11:10:44','2023-03-27 11:10:44'),(235,7730,2,40720,40781,13,1525,1,0,'2021-01-18','2021-01-18',7819.00,1,1.00,'Factura B N°: 0001-00000055',NULL,'2023-03-26 23:30:21','2023-03-27 11:10:36','2023-03-27 11:10:36'),(236,7730,2,40720,40782,13,1525,1,0,'2021-01-19','2021-01-19',6490.00,1,1.00,'Factura B N°: 0001-00000056',NULL,'2023-03-26 23:30:21','2023-03-27 11:09:34','2023-03-27 11:09:34'),(237,7730,2,40720,40781,13,1525,1,0,'2021-01-19','2021-01-19',6490.00,1,1.00,'Factura B N°: 0001-00000057',NULL,'2023-03-26 23:30:21','2023-03-27 11:09:26','2023-03-27 11:09:26'),(238,7730,2,40720,40783,13,1525,1,0,'2021-01-20','2021-01-20',6490.00,1,1.00,'Factura B N°: 0001-00000058',NULL,'2023-03-26 23:30:21','2023-03-27 11:09:19','2023-03-27 11:09:19'),(239,7730,2,40720,40784,13,1525,1,0,'2021-01-20','2021-01-20',8685.00,1,1.00,'Factura B N°: 0001-00000059',NULL,'2023-03-26 23:30:21','2023-03-27 11:09:12','2023-03-27 11:09:12');
INSERT INTO `cta_cte_cliente` VALUES (240,7730,2,40720,40785,13,1525,1,0,'2021-01-21','2021-01-21',8685.00,1,1.00,'Factura B N°: 0001-00000060',NULL,'2023-03-26 23:30:21','2023-03-27 11:09:03','2023-03-27 11:09:03'),(241,7730,2,40720,40786,13,1525,1,0,'2021-01-22','2021-01-22',300.00,1,1.00,'Factura B N°: 0001-00000061',NULL,'2023-03-26 23:30:21','2023-03-27 11:08:56','2023-03-27 11:08:56'),(242,7730,2,40720,40787,13,1525,1,0,'2021-01-25','2021-01-25',7590.00,1,1.00,'Factura B N°: 0001-00000062',NULL,'2023-03-26 23:30:21','2023-03-27 11:08:48','2023-03-27 11:08:48'),(243,7730,2,40720,40788,13,1525,1,0,'2021-01-25','2021-01-25',6490.00,1,1.00,'Factura B N°: 0001-00000063',NULL,'2023-03-26 23:30:21','2023-03-27 11:08:41','2023-03-27 11:08:41'),(244,7730,2,40720,40789,13,1525,1,0,'2021-01-25','2021-01-25',8685.00,1,1.00,'Factura B N°: 0001-00000064',NULL,'2023-03-26 23:30:21','2023-03-27 11:08:33','2023-03-27 11:08:33'),(245,7730,2,40720,40790,13,1525,1,0,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000065',NULL,'2023-03-26 23:30:21','2023-03-27 11:08:26','2023-03-27 11:08:26'),(246,7730,2,40720,40791,13,1525,1,0,'2021-01-26','2021-01-26',7590.00,1,1.00,'Factura B N°: 0001-00000066',NULL,'2023-03-26 23:30:21','2023-03-27 11:08:18','2023-03-27 11:08:18'),(247,7730,2,40720,40792,13,1525,1,0,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000067',NULL,'2023-03-26 23:30:21','2023-03-27 11:08:12','2023-03-27 11:08:12'),(248,7730,2,40720,40793,13,1525,1,0,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000068',NULL,'2023-03-26 23:30:21','2023-03-27 11:08:05','2023-03-27 11:08:05'),(249,7730,2,40720,40794,13,1525,1,0,'2021-01-26','2021-01-26',8685.00,1,1.00,'Factura B N°: 0001-00000069',NULL,'2023-03-26 23:30:21','2023-03-27 11:07:58','2023-03-27 11:07:58'),(250,7730,2,40720,40795,13,1525,1,0,'2021-01-28','2021-01-28',7590.00,1,1.00,'Factura B N°: 0001-00000070',NULL,'2023-03-26 23:30:21','2023-03-27 11:07:48','2023-03-27 11:07:48'),(251,7730,2,40720,40791,13,1525,2,0,'2021-01-28','2021-01-28',7590.00,1,1.00,'Nota de crédito B N°: 0001-00000001',NULL,'2023-03-26 23:30:21','2023-03-27 11:07:36','2023-03-27 11:07:36'),(252,7730,2,40720,40796,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura A N°: 0001-00000004',NULL,'2023-03-26 23:31:17','2023-03-27 11:07:29','2023-03-27 11:07:29'),(253,7730,2,40720,40797,13,1525,1,0,'2021-01-26','2021-01-26',6799.00,1,1.00,'Factura A N°: 0001-00000006',NULL,'2023-03-26 23:31:17','2023-03-27 11:07:22','2023-03-27 11:07:22'),(254,7730,2,40720,40797,13,1525,1,0,'2021-01-26','2021-01-26',40794.00,1,1.00,'Factura A N°: 0001-00000007',NULL,'2023-03-26 23:31:17','2023-03-27 11:07:14','2023-03-27 11:07:14'),(255,7730,2,40720,40797,13,1525,1,0,'2021-01-27','2021-01-27',40794.00,1,1.00,'Factura A N°: 0001-00000008',NULL,'2023-03-26 23:31:17','2023-03-27 11:06:51','2023-03-27 11:06:51'),(256,7730,2,40720,40797,13,1525,2,0,'2021-01-27','2021-01-27',40794.00,1,1.00,'Nota de crédito A N°: 0001-00000002',NULL,'2023-03-26 23:31:17','2023-03-27 11:06:31','2023-03-27 11:06:31'),(257,7730,3,40720,40762,57,1525,2,0,'2021-01-05','2021-01-05',20000.00,1,1.00,'Factura C N°: 0002-00000028',NULL,'2023-03-26 23:43:09','2023-03-27 00:08:06','2023-03-27 00:08:06'),(258,7730,3,40720,40727,57,1525,1,0,'2021-01-08','2021-01-08',1204.90,1,1.00,'Nota de crédito A N°: 0011-00471338',NULL,'2023-03-26 23:43:09','2023-03-26 23:56:30','2023-03-26 23:56:30'),(259,7730,3,40720,40724,57,1525,2,0,'2021-01-08','2021-01-08',5719.07,1,1.00,'Factura A N°: 0003-00004406',NULL,'2023-03-26 23:43:09','2023-03-27 00:07:32','2023-03-27 00:07:32'),(260,7730,3,40720,40727,57,1525,2,0,'2021-01-10','2021-01-10',40365.09,1,1.00,'Factura A N°: 0011-01002751',NULL,'2023-03-26 23:43:09','2023-03-27 00:00:20','2023-03-27 00:00:20'),(261,7730,3,40720,40724,57,1525,2,0,'2021-01-12','2021-01-12',12801.20,1,1.00,'Factura A N°: 0003-00004414',NULL,'2023-03-26 23:43:09','2023-03-27 00:07:15','2023-03-27 00:07:15');
INSERT INTO `cta_cte_cliente` VALUES (262,7730,3,40720,40724,57,1525,2,0,'2021-01-21','2021-01-21',7234.59,1,1.00,'Factura A N°: 0003-00004440',NULL,'2023-03-26 23:43:09','2023-03-27 00:07:01','2023-03-27 00:07:01'),(263,7730,3,40720,40724,57,1525,2,0,'2021-01-21','2021-01-21',4267.07,1,1.00,'Factura A N°: 0003-00004441',NULL,'2023-03-26 23:43:09','2023-03-27 00:06:45','2023-03-27 00:06:45'),(264,7730,3,40720,40764,57,1525,2,0,'2021-01-29','2021-01-29',10684.52,1,1.00,'Factura A N°: 0002-00000048',NULL,'2023-03-26 23:43:09','2023-03-27 00:06:20','2023-03-27 00:06:20'),(265,7730,3,40720,40798,57,1525,2,0,'2021-01-31','2021-01-31',3298.42,1,1.00,'Factura A N°: 0005-00000024',NULL,'2023-03-26 23:43:09','2023-03-27 00:05:01','2023-03-27 00:05:01'),(266,7730,3,40720,40728,57,1525,2,0,'2021-01-31','2021-01-31',1206.09,1,1.00,'Factura A N°: 6364-04165950',NULL,'2023-03-26 23:43:10','2023-03-27 00:03:07','2023-03-27 00:03:07'),(267,7730,3,40720,40727,57,1525,1,0,'2021-01-08','2021-01-08',1204.90,1,1.00,'Nota de crédito A N°: 0011-00471338',NULL,'2023-03-26 23:56:30','2023-03-27 00:08:53','2023-03-27 00:08:53'),(268,7730,3,40720,40727,57,1525,2,0,'2021-01-10','2021-01-10',40365.09,1,1.00,'Factura A N°: 0011-01002751',NULL,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(269,7730,3,40720,40728,57,1525,2,0,'2021-01-31','2021-01-31',1241.12,1,1.00,'Factura A N°: 6364-04165950',NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(270,7730,3,40720,40728,57,1525,2,0,'2021-01-31','2021-01-31',1206.09,1,1.00,'Factura A N°: 6364-04165950',NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(271,7730,3,40720,40798,57,1525,2,0,'2021-01-31','2021-01-31',3298.43,1,1.00,'Factura A N°: 0005-00000024',NULL,'2023-03-27 00:05:01','2023-03-27 00:09:30','2023-03-27 00:09:30'),(272,7730,3,40720,40764,57,1525,2,0,'2021-01-29','2021-01-29',10684.52,1,1.00,'Factura A N°: 0002-00000048',NULL,'2023-03-27 00:06:20','2023-03-27 00:06:20',NULL),(273,7730,3,40720,40724,57,1525,2,0,'2021-01-21','2021-01-21',4267.07,1,1.00,'Factura A N°: 0003-00004441',NULL,'2023-03-27 00:06:45','2023-03-28 17:17:32',NULL),(274,7730,3,40720,40724,57,1525,2,0,'2021-01-21','2021-01-21',7234.59,1,1.00,'Factura A N°: 0003-00004440',NULL,'2023-03-27 00:07:01','2023-03-28 17:17:32',NULL),(275,7730,3,40720,40724,57,1525,2,0,'2021-01-12','2021-01-12',12801.20,1,1.00,'Factura A N°: 0003-00004414',NULL,'2023-03-27 00:07:15','2023-03-28 17:17:32',NULL),(276,7730,3,40720,40724,57,1525,2,0,'2021-01-08','2021-01-08',5719.07,1,1.00,'Factura A N°: 0003-00004406',NULL,'2023-03-27 00:07:32','2023-03-28 17:17:32',NULL),(277,7730,3,40720,40762,57,1525,2,0,'2021-01-05','2021-01-05',20000.00,1,1.00,'Factura C N°: 0002-00000028',NULL,'2023-03-27 00:08:06','2023-03-27 00:08:38','2023-03-27 00:08:38'),(278,7730,3,40720,40762,57,1525,2,1,'2021-01-05','2021-01-05',20000.00,1,1.00,'Factura C N°: 0002-00000028',NULL,'2023-03-27 00:08:38','2023-03-28 12:40:44',NULL),(279,7730,3,40720,40727,57,1525,1,0,'2021-01-08','2021-01-08',1204.90,1,1.00,'Nota de crédito A N°: 0011-00471338',NULL,'2023-03-27 00:08:53','2023-03-28 12:44:11','2023-03-28 12:44:11'),(280,7730,3,40720,40727,57,1525,2,0,'2021-01-10','2021-01-10',40365.09,1,1.00,'Factura A N°: 0011-01002751',NULL,'2023-03-27 00:09:11','2023-03-28 13:21:48','2023-03-28 13:21:48'),(281,7730,3,40720,40798,57,1525,2,1,'2021-01-31','2021-01-31',3298.43,1,1.00,'Factura A N°: 0005-00000024',NULL,'2023-03-27 00:09:30','2023-03-28 12:24:10',NULL),(282,7730,3,40720,40728,57,1525,2,0,'2021-01-31','2021-01-31',1206.09,1,1.00,'Factura A N°: 6364-04165950',NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(283,7730,2,40720,40745,13,1525,2,0,'2021-01-04','2021-01-04',1446.00,1,1.00,'Nota de crédito A N°: 0001-00000001',NULL,'2023-03-27 14:34:42','2023-03-27 14:34:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (284,7730,2,40720,40765,13,1525,1,0,'2021-01-04','2021-01-04',6490.00,1,1.00,'Factura B N°: 0001-00000034',NULL,'2023-03-27 14:34:42','2023-03-27 14:42:48','2023-03-27 14:42:48'),(285,7730,2,40720,40765,13,1525,1,0,'2021-01-04','2021-01-04',1600.00,1,1.00,'Factura B N°: 0001-00000035',NULL,'2023-03-27 14:34:42','2023-03-27 14:44:21','2023-03-27 14:44:21'),(286,7730,2,40720,40766,13,1525,1,0,'2021-01-06','2021-01-06',7590.00,1,1.00,'Factura B N°: 0001-00000036',NULL,'2023-03-27 14:34:42','2023-03-27 14:45:24','2023-03-27 14:45:24'),(287,7730,2,40720,40767,13,1525,1,0,'2021-01-06','2021-01-06',7590.00,1,1.00,'Factura B N°: 0001-00000037',NULL,'2023-03-27 14:34:42','2023-03-27 14:47:13','2023-03-27 14:47:13'),(288,7730,2,40720,40767,13,1525,1,0,'2021-01-06','2021-01-06',1500.00,1,1.00,'Factura B N°: 0001-00000038',NULL,'2023-03-27 14:34:42','2023-03-27 14:48:01','2023-03-27 14:48:01'),(289,7730,2,40720,40768,13,1525,1,0,'2021-01-06','2021-01-06',19470.00,1,1.00,'Factura B N°: 0001-00000039',NULL,'2023-03-27 14:34:42','2023-03-27 14:49:25','2023-03-27 14:49:25'),(290,7730,2,40720,40769,13,1525,1,0,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000040',NULL,'2023-03-27 14:34:42','2023-03-27 14:50:41','2023-03-27 14:50:41'),(291,7730,2,40720,40770,13,1525,1,0,'2021-01-07','2021-01-07',7590.00,1,1.00,'Factura B N°: 0001-00000041',NULL,'2023-03-27 14:34:42','2023-03-27 14:52:37','2023-03-27 14:52:37'),(292,7730,2,40720,40771,13,1525,1,0,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000042',NULL,'2023-03-27 14:34:42','2023-03-27 14:53:54','2023-03-27 14:53:54'),(293,7730,2,40720,40772,13,1525,1,0,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000043',NULL,'2023-03-27 14:34:43','2023-03-27 14:55:03','2023-03-27 14:55:03'),(294,7730,2,40720,40773,13,1525,1,0,'2021-01-12','2021-01-12',150.00,1,1.00,'Factura B N°: 0001-00000044',NULL,'2023-03-27 14:34:43','2023-03-27 14:56:02','2023-03-27 14:56:02'),(295,7730,2,40720,40774,13,1525,1,0,'2021-01-12','2021-01-12',7590.00,1,1.00,'Factura B N°: 0001-00000045',NULL,'2023-03-27 14:34:43','2023-03-27 14:57:22','2023-03-27 14:57:22'),(296,7730,2,40720,40731,13,1525,1,0,'2021-01-13','2021-01-13',150.00,1,1.00,'Factura B N°: 0001-00000046',NULL,'2023-03-27 14:34:43','2023-03-27 14:58:21','2023-03-27 14:58:21'),(297,7730,2,40720,40775,13,1525,1,0,'2021-01-13','2021-01-13',150.00,1,1.00,'Factura B N°: 0001-00000047',NULL,'2023-03-27 14:34:43','2023-03-27 14:59:37','2023-03-27 14:59:37'),(298,7730,2,40720,40733,13,1525,1,0,'2021-01-13','2021-01-13',799.00,1,1.00,'Factura B N°: 0001-00000048',NULL,'2023-03-27 14:34:43','2023-03-27 15:00:29','2023-03-27 15:00:29'),(299,7730,2,40720,40764,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura A N°: 0001-00000005',NULL,'2023-03-27 14:34:43','2023-03-27 15:06:44','2023-03-27 15:06:44'),(300,7730,2,40720,40776,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000049',NULL,'2023-03-27 14:34:43','2023-03-27 15:02:54','2023-03-27 15:02:54'),(301,7730,2,40720,40777,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000050',NULL,'2023-03-27 14:34:43','2023-03-27 15:04:08','2023-03-27 15:04:08'),(302,7730,2,40720,40733,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000051',NULL,'2023-03-27 14:34:43','2023-03-27 15:04:42','2023-03-27 15:04:42'),(303,7730,2,40720,40778,13,1525,1,0,'2021-01-15','2021-01-15',150.00,1,1.00,'Factura B N°: 0001-00000052',NULL,'2023-03-27 14:34:43','2023-03-27 15:05:54','2023-03-27 15:05:54'),(304,7730,2,40720,40779,13,1525,1,0,'2021-01-18','2021-01-18',1379.00,1,1.00,'Factura B N°: 0001-00000053',NULL,'2023-03-27 14:34:43','2023-03-27 15:08:24','2023-03-27 15:08:24'),(305,7730,2,40720,40780,13,1525,1,0,'2021-01-18','2021-01-18',7590.00,1,1.00,'Factura B N°: 0001-00000054',NULL,'2023-03-27 14:34:43','2023-03-27 15:11:08','2023-03-27 15:11:08');
INSERT INTO `cta_cte_cliente` VALUES (306,7730,2,40720,40781,13,1525,1,0,'2021-01-18','2021-01-18',7819.00,1,1.00,'Factura B N°: 0001-00000055',NULL,'2023-03-27 14:34:43','2023-03-27 15:12:51','2023-03-27 15:12:51'),(307,7730,2,40720,40782,13,1525,1,0,'2021-01-19','2021-01-19',6490.00,1,1.00,'Factura B N°: 0001-00000056',NULL,'2023-03-27 14:34:43','2023-03-27 15:14:06','2023-03-27 15:14:06'),(308,7730,2,40720,40781,13,1525,1,0,'2021-01-19','2021-01-19',6490.00,1,1.00,'Factura B N°: 0001-00000057',NULL,'2023-03-27 14:34:43','2023-03-27 15:14:41','2023-03-27 15:14:41'),(309,7730,2,40720,40783,13,1525,1,0,'2021-01-20','2021-01-20',6490.00,1,1.00,'Factura B N°: 0001-00000058',NULL,'2023-03-27 14:34:43','2023-03-27 15:15:48','2023-03-27 15:15:48'),(310,7730,2,40720,40784,13,1525,1,0,'2021-01-20','2021-01-20',8685.00,1,1.00,'Factura B N°: 0001-00000059',NULL,'2023-03-27 14:34:43','2023-03-27 15:17:10','2023-03-27 15:17:10'),(311,7730,2,40720,40785,13,1525,1,0,'2021-01-21','2021-01-21',8685.00,1,1.00,'Factura B N°: 0001-00000060',NULL,'2023-03-27 14:34:43','2023-03-27 15:18:09','2023-03-27 15:18:09'),(312,7730,2,40720,40786,13,1525,1,0,'2021-01-22','2021-01-22',300.00,1,1.00,'Factura B N°: 0001-00000061',NULL,'2023-03-27 14:34:44','2023-03-27 15:20:22','2023-03-27 15:20:22'),(313,7730,2,40720,40787,13,1525,1,0,'2021-01-25','2021-01-25',7590.00,1,1.00,'Factura B N°: 0001-00000062',NULL,'2023-03-27 14:34:44','2023-03-27 15:21:38','2023-03-27 15:21:38'),(314,7730,2,40720,40788,13,1525,1,0,'2021-01-25','2021-01-25',6490.00,1,1.00,'Factura B N°: 0001-00000063',NULL,'2023-03-27 14:34:44','2023-03-27 15:22:48','2023-03-27 15:22:48'),(315,7730,2,40720,40789,13,1525,1,0,'2021-01-25','2021-01-25',8685.00,1,1.00,'Factura B N°: 0001-00000064',NULL,'2023-03-27 14:34:44','2023-03-27 15:23:55','2023-03-27 15:23:55'),(316,7730,2,40720,40790,13,1525,1,0,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000065',NULL,'2023-03-27 14:34:44','2023-03-27 15:25:16','2023-03-27 15:25:16'),(317,7730,2,40720,40791,13,1525,1,0,'2021-01-26','2021-01-26',7590.00,1,1.00,'Factura B N°: 0001-00000066',NULL,'2023-03-27 14:34:44','2023-03-27 15:26:08','2023-03-27 15:26:08'),(318,7730,2,40720,40792,13,1525,1,0,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000067',NULL,'2023-03-27 14:34:44','2023-03-27 15:27:27','2023-03-27 15:27:27'),(319,7730,2,40720,40793,13,1525,1,0,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000068',NULL,'2023-03-27 14:34:44','2023-03-27 15:28:27','2023-03-27 15:28:27'),(320,7730,2,40720,40794,13,1525,1,0,'2021-01-26','2021-01-26',8685.00,1,1.00,'Factura B N°: 0001-00000069',NULL,'2023-03-27 14:34:44','2023-03-27 15:29:31','2023-03-27 15:29:31'),(321,7730,2,40720,40795,13,1525,1,0,'2021-01-28','2021-01-28',7590.00,1,1.00,'Factura B N°: 0001-00000070',NULL,'2023-03-27 14:34:44','2023-03-27 15:30:29','2023-03-27 15:30:29'),(322,7730,2,40720,40791,13,1525,2,0,'2021-01-28','2021-01-28',7590.00,1,1.00,'Nota de crédito B N°: 0001-00000001',NULL,'2023-03-27 14:34:44','2023-03-27 15:31:17','2023-03-27 15:31:17'),(323,7730,2,40720,40796,13,1525,1,0,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura A N°: 0001-00000004',NULL,'2023-03-27 14:36:03','2023-03-27 15:32:52','2023-03-27 15:32:52'),(324,7730,2,40720,40797,13,1525,1,0,'2021-01-26','2021-01-26',6799.00,1,1.00,'Factura A N°: 0001-00000006',NULL,'2023-03-27 14:36:03','2023-03-27 15:33:40','2023-03-27 15:33:40'),(325,7730,2,40720,40797,13,1525,1,1,'2021-01-26','2021-01-26',40794.00,1,1.00,'Factura A N°: 0001-00000007',NULL,'2023-03-27 14:36:03','2023-03-27 16:47:49',NULL),(326,7730,2,40720,40797,13,1525,1,0,'2021-01-27','2021-01-27',40794.00,1,1.00,'Factura A N°: 0001-00000008',NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(327,7730,2,40720,40797,13,1525,2,0,'2021-01-27','2021-01-27',40794.00,1,1.00,'Nota de crédito A N°: 0001-00000002',NULL,'2023-03-27 14:36:03','2023-03-27 15:32:17','2023-03-27 15:32:17');
INSERT INTO `cta_cte_cliente` VALUES (328,7730,2,40720,40765,13,1525,1,1,'2021-01-04','2021-01-04',6490.00,1,1.00,'Factura B N°: 0001-00000034',NULL,'2023-03-27 14:42:48','2023-03-27 16:00:34',NULL),(329,7730,2,40720,40765,13,1525,1,1,'2021-01-04','2021-01-04',1600.00,1,1.00,'Factura B N°: 0001-00000035',NULL,'2023-03-27 14:44:21','2023-03-27 16:00:34',NULL),(330,7730,2,40720,40766,13,1525,1,1,'2021-01-06','2021-01-06',7590.00,1,1.00,'Factura B N°: 0001-00000036',NULL,'2023-03-27 14:45:24','2023-03-27 16:02:07',NULL),(331,7730,2,40720,40767,13,1525,1,1,'2021-01-06','2021-01-06',7590.00,1,1.00,'Factura B N°: 0001-00000037',NULL,'2023-03-27 14:47:13','2023-03-27 16:03:07',NULL),(332,7730,2,40720,40767,13,1525,1,1,'2021-01-06','2021-01-06',1500.00,1,1.00,'Factura B N°: 0001-00000038',NULL,'2023-03-27 14:48:01','2023-03-27 16:03:07',NULL),(333,7730,2,40720,40768,13,1525,1,1,'2021-01-06','2021-01-06',19470.00,1,1.00,'Factura B N°: 0001-00000039',NULL,'2023-03-27 14:49:25','2023-03-27 16:03:59',NULL),(334,7730,2,40720,40769,13,1525,1,1,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000040',NULL,'2023-03-27 14:50:41','2023-03-27 16:05:00',NULL),(335,7730,2,40720,40770,13,1525,1,1,'2021-01-07','2021-01-07',7590.00,1,1.00,'Factura B N°: 0001-00000041',NULL,'2023-03-27 14:52:37','2023-03-27 16:06:03',NULL),(336,7730,2,40720,40771,13,1525,1,1,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000042',NULL,'2023-03-27 14:53:54','2023-03-27 16:06:54',NULL),(337,7730,2,40720,40772,13,1525,1,1,'2021-01-07','2021-01-07',150.00,1,1.00,'Factura B N°: 0001-00000043',NULL,'2023-03-27 14:55:03','2023-03-27 16:07:35',NULL),(338,7730,2,40720,40773,13,1525,1,1,'2021-01-12','2021-01-12',150.00,1,1.00,'Factura B N°: 0001-00000044',NULL,'2023-03-27 14:56:02','2023-03-27 16:08:33',NULL),(339,7730,2,40720,40774,13,1525,1,1,'2021-01-12','2021-01-12',7590.00,1,1.00,'Factura B N°: 0001-00000045',NULL,'2023-03-27 14:57:22','2023-03-27 16:09:12',NULL),(340,7730,2,40720,40731,13,1525,1,1,'2021-01-13','2021-01-13',150.00,1,1.00,'Factura B N°: 0001-00000046',NULL,'2023-03-27 14:58:21','2023-03-27 15:56:08',NULL),(341,7730,2,40720,40775,13,1525,1,1,'2021-01-13','2021-01-13',150.00,1,1.00,'Factura B N°: 0001-00000047',NULL,'2023-03-27 14:59:37','2023-03-27 16:09:56',NULL),(342,7730,2,40720,40733,13,1525,1,1,'2021-01-13','2021-01-13',799.00,1,1.00,'Factura B N°: 0001-00000048',NULL,'2023-03-27 15:00:29','2023-03-27 15:58:45',NULL),(343,7730,2,40720,40776,13,1525,1,1,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000049',NULL,'2023-03-27 15:02:54','2023-03-27 16:11:16',NULL),(344,7730,2,40720,40777,13,1525,1,1,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000050',NULL,'2023-03-27 15:04:08','2023-03-27 16:11:52',NULL),(345,7730,2,40720,40733,13,1525,1,1,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura B N°: 0001-00000051',NULL,'2023-03-27 15:04:42','2023-03-27 15:58:45',NULL),(346,7730,2,40720,40778,13,1525,1,1,'2021-01-15','2021-01-15',150.00,1,1.00,'Factura B N°: 0001-00000052',NULL,'2023-03-27 15:05:54','2023-03-27 16:12:34',NULL),(347,7730,2,40720,40764,13,1525,1,1,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura A N°: 0001-00000005',NULL,'2023-03-27 15:06:44','2023-03-27 16:54:51',NULL),(348,7730,2,40720,40779,13,1525,1,1,'2021-01-18','2021-01-18',1379.00,1,1.00,'Factura B N°: 0001-00000053',NULL,'2023-03-27 15:08:24','2023-03-27 16:13:20',NULL),(349,7730,2,40720,40780,13,1525,1,1,'2021-01-18','2021-01-18',7590.00,1,1.00,'Factura B N°: 0001-00000054',NULL,'2023-03-27 15:11:08','2023-03-27 16:14:22',NULL),(350,7730,2,40720,40781,13,1525,1,1,'2021-01-18','2021-01-18',7819.00,1,1.00,'Factura B N°: 0001-00000055',NULL,'2023-03-27 15:12:51','2023-03-27 16:16:08',NULL),(351,7730,2,40720,40782,13,1525,1,1,'2021-01-19','2021-01-19',6490.00,1,1.00,'Factura B N°: 0001-00000056',NULL,'2023-03-27 15:14:06','2023-03-27 16:18:43',NULL);
INSERT INTO `cta_cte_cliente` VALUES (352,7730,2,40720,40781,13,1525,1,1,'2021-01-19','2021-01-19',6490.00,1,1.00,'Factura B N°: 0001-00000057',NULL,'2023-03-27 15:14:41','2023-03-27 16:17:14',NULL),(353,7730,2,40720,40783,13,1525,1,1,'2021-01-20','2021-01-20',6490.00,1,1.00,'Factura B N°: 0001-00000058',NULL,'2023-03-27 15:15:48','2023-03-27 16:19:37',NULL),(354,7730,2,40720,40784,13,1525,1,1,'2021-01-20','2021-01-20',8685.00,1,1.00,'Factura B N°: 0001-00000059',NULL,'2023-03-27 15:17:10','2023-03-27 16:20:30',NULL),(355,7730,2,40720,40785,13,1525,1,0,'2021-01-21','2021-01-21',8685.00,1,1.00,'Factura B N°: 0001-00000060',NULL,'2023-03-27 15:18:09','2023-03-27 15:18:52','2023-03-27 15:18:52'),(356,7730,2,40720,40785,13,1525,1,0,'2021-01-21','2021-01-21',8685.00,1,1.00,'Factura B N°: 0001-00000060',NULL,'2023-03-27 15:18:52','2023-03-27 15:19:25','2023-03-27 15:19:25'),(357,7730,2,40720,40785,13,1525,1,1,'2021-01-21','2021-01-21',8685.00,1,1.00,'Factura B N°: 0001-00000060',NULL,'2023-03-27 15:19:25','2023-03-27 16:21:24',NULL),(358,7730,2,40720,40786,13,1525,1,1,'2021-01-22','2021-01-22',300.00,1,1.00,'Factura B N°: 0001-00000061',NULL,'2023-03-27 15:20:22','2023-03-27 16:30:20',NULL),(359,7730,2,40720,40787,13,1525,1,1,'2021-01-25','2021-01-25',7590.00,1,1.00,'Factura B N°: 0001-00000062',NULL,'2023-03-27 15:21:38','2023-03-27 16:31:13',NULL),(360,7730,2,40720,40788,13,1525,1,1,'2021-01-25','2021-01-25',6490.00,1,1.00,'Factura B N°: 0001-00000063',NULL,'2023-03-27 15:22:48','2023-03-27 16:32:13',NULL),(361,7730,2,40720,40789,13,1525,1,1,'2021-01-25','2021-01-25',8685.00,1,1.00,'Factura B N°: 0001-00000064',NULL,'2023-03-27 15:23:55','2023-03-27 16:33:00',NULL),(362,7730,2,40720,40790,13,1525,1,1,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000065',NULL,'2023-03-27 15:25:16','2023-03-27 16:33:48',NULL),(363,7730,2,40720,40791,13,1525,1,0,'2021-01-26','2021-01-26',7590.00,1,1.00,'Factura B N°: 0001-00000066',NULL,'2023-03-27 15:26:08','2023-03-27 15:26:08',NULL),(364,7730,2,40720,40792,13,1525,1,1,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000067',NULL,'2023-03-27 15:27:27','2023-03-27 16:34:55',NULL),(365,7730,2,40720,40793,13,1525,1,1,'2021-01-26','2021-01-26',6490.00,1,1.00,'Factura B N°: 0001-00000068',NULL,'2023-03-27 15:28:27','2023-03-27 16:38:54',NULL),(366,7730,2,40720,40794,13,1525,1,1,'2021-01-26','2021-01-26',8685.00,1,1.00,'Factura B N°: 0001-00000069',NULL,'2023-03-27 15:29:31','2023-03-27 16:39:47',NULL),(367,7730,2,40720,40795,13,1525,1,1,'2021-01-28','2021-01-28',7590.00,1,1.00,'Factura B N°: 0001-00000070',NULL,'2023-03-27 15:30:29','2023-03-27 16:40:40',NULL),(368,7730,2,40720,40791,13,1525,2,0,'2021-01-28','2021-01-28',7590.00,1,1.00,'Nota de crédito B N°: 0001-00000001',NULL,'2023-03-27 15:31:17','2023-03-27 15:31:17',NULL),(369,7730,2,40720,40797,13,1525,2,0,'2021-01-27','2021-01-27',40794.00,1,1.00,'Nota de crédito A N°: 0001-00000002',NULL,'2023-03-27 15:32:17','2023-03-27 15:32:17',NULL),(370,7730,2,40720,40796,13,1525,1,1,'2021-01-14','2021-01-14',150.00,1,1.00,'Factura A N°: 0001-00000004',NULL,'2023-03-27 15:32:52','2023-03-27 16:43:44',NULL),(371,7730,2,40720,40797,13,1525,1,1,'2021-01-26','2021-01-26',6799.00,1,1.00,'Factura A N°: 0001-00000006',NULL,'2023-03-27 15:33:40','2023-03-27 16:45:38',NULL),(372,7730,20,40720,40731,13,1525,2,1,'2021-01-13','2021-01-13',150.00,1,1.00,NULL,NULL,'2023-03-27 15:56:08','2023-03-27 15:56:08',NULL),(373,7730,20,40720,40733,13,1525,2,1,'2021-01-14','2021-01-14',949.00,1,1.00,NULL,NULL,'2023-03-27 15:58:45','2023-03-27 15:58:45',NULL),(374,7730,20,40720,40765,13,1525,2,1,'2021-01-04','2021-01-04',8090.00,1,1.00,NULL,NULL,'2023-03-27 16:00:34','2023-03-27 16:00:34',NULL),(375,7730,20,40720,40766,13,1525,2,1,'2021-01-06','2021-01-06',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:02:07','2023-03-27 16:02:07',NULL),(376,7730,20,40720,40767,13,1525,2,1,'2021-01-06','2021-01-06',9090.00,1,1.00,NULL,NULL,'2023-03-27 16:03:07','2023-03-27 16:03:07',NULL);
INSERT INTO `cta_cte_cliente` VALUES (377,7730,20,40720,40768,13,1525,2,1,'2021-01-06','2021-01-06',19470.00,1,1.00,NULL,NULL,'2023-03-27 16:03:59','2023-03-27 16:03:59',NULL),(378,7730,20,40720,40769,13,1525,2,1,'2021-01-07','2021-01-07',150.00,1,1.00,NULL,NULL,'2023-03-27 16:05:00','2023-03-27 16:05:00',NULL),(379,7730,20,40720,40770,13,1525,2,1,'2021-01-07','2021-01-07',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:06:03','2023-03-27 16:06:03',NULL),(380,7730,20,40720,40771,13,1525,2,1,'2021-01-07','2021-01-07',150.00,1,1.00,NULL,NULL,'2023-03-27 16:06:54','2023-03-27 16:06:54',NULL),(381,7730,20,40720,40772,13,1525,2,1,'2021-01-07','2021-01-07',150.00,1,1.00,NULL,NULL,'2023-03-27 16:07:35','2023-03-27 16:07:35',NULL),(382,7730,20,40720,40773,13,1525,2,1,'2021-01-12','2021-01-12',150.00,1,1.00,NULL,NULL,'2023-03-27 16:08:33','2023-03-27 16:08:33',NULL),(383,7730,20,40720,40774,13,1525,2,1,'2021-01-12','2021-01-12',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:09:12','2023-03-27 16:09:12',NULL),(384,7730,20,40720,40775,13,1525,2,1,'2021-01-13','2021-01-13',150.00,1,1.00,NULL,NULL,'2023-03-27 16:09:56','2023-03-27 16:09:56',NULL),(385,7730,20,40720,40776,13,1525,2,1,'2021-01-14','2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:11:16','2023-03-27 16:11:16',NULL),(386,7730,20,40720,40777,13,1525,2,1,'2021-01-14','2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:11:52','2023-03-27 16:11:52',NULL),(387,7730,20,40720,40778,13,1525,2,1,'2021-01-14','2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:12:34','2023-03-27 16:12:34',NULL),(388,7730,20,40720,40779,13,1525,2,1,'2021-01-14','2021-01-14',1379.00,1,1.00,NULL,NULL,'2023-03-27 16:13:20','2023-03-27 16:13:20',NULL),(389,7730,20,40720,40780,13,1525,2,1,'2021-01-18','2021-01-18',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:14:22','2023-03-27 16:14:22',NULL),(390,7730,20,40720,40781,13,1525,2,1,'2021-01-18','2021-01-18',7819.00,1,1.00,NULL,NULL,'2023-03-27 16:16:08','2023-03-27 16:16:08',NULL),(391,7730,20,40720,40781,13,1525,2,1,'2021-01-19','2021-01-19',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:17:14','2023-03-27 16:17:14',NULL),(392,7730,20,40720,40782,13,1525,2,1,'2021-01-19','2021-01-19',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:18:43','2023-03-27 16:18:43',NULL),(393,7730,20,40720,40783,13,1525,2,1,'2021-01-20','2021-01-20',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:19:37','2023-03-27 16:19:37',NULL),(394,7730,20,40720,40784,13,1525,2,1,'2021-01-20','2021-01-20',8685.00,1,1.00,NULL,NULL,'2023-03-27 16:20:30','2023-03-27 16:20:30',NULL),(395,7730,20,40720,40785,13,1525,2,1,'2021-01-21','2021-01-21',8685.00,1,1.00,NULL,NULL,'2023-03-27 16:21:24','2023-03-27 16:21:24',NULL),(396,7730,20,40720,40786,13,1525,2,1,'2021-01-22','2021-01-22',300.00,1,1.00,NULL,NULL,'2023-03-27 16:30:20','2023-03-27 16:30:20',NULL),(397,7730,20,40720,40787,13,1525,2,1,'2021-01-25','2021-01-25',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:31:13','2023-03-27 16:31:13',NULL),(398,7730,20,40720,40788,13,1525,2,1,'2021-01-25','2021-01-25',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:32:13','2023-03-27 16:32:13',NULL),(399,7730,20,40720,40789,13,1525,2,1,'2021-01-25','2021-01-25',8685.00,1,1.00,NULL,NULL,'2023-03-27 16:33:00','2023-03-27 16:33:00',NULL),(400,7730,20,40720,40790,13,1525,2,1,'2021-01-26','2021-01-26',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:33:48','2023-03-27 16:33:48',NULL),(401,7730,20,40720,40792,13,1525,2,1,'2021-01-26','2021-01-26',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:34:55','2023-03-27 16:34:55',NULL),(402,7730,20,40720,40793,13,1525,2,1,'2021-01-26','2021-01-26',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:38:54','2023-03-27 16:38:54',NULL),(403,7730,20,40720,40794,13,1525,2,1,'2021-01-26','2021-01-26',8685.00,1,1.00,NULL,NULL,'2023-03-27 16:39:47','2023-03-27 16:39:47',NULL),(404,7730,20,40720,40795,13,1525,2,1,'2021-01-28','2021-01-28',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:40:40','2023-03-27 16:40:40',NULL),(405,7730,20,40720,40796,13,1525,2,1,'2021-01-14','2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:43:44','2023-03-27 16:43:44',NULL);
INSERT INTO `cta_cte_cliente` VALUES (406,7730,20,40720,40797,13,1525,2,1,'2021-01-26','2021-01-26',6799.00,1,1.00,NULL,NULL,'2023-03-27 16:45:38','2023-03-27 16:45:38',NULL),(407,7730,20,40720,40797,13,1525,2,1,'2021-01-27','2021-01-27',40794.00,1,1.00,NULL,NULL,'2023-03-27 16:47:49','2023-03-27 16:47:49',NULL),(408,7730,20,40720,40764,13,1525,2,1,'2021-01-14','2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:54:51','2023-03-27 16:54:51',NULL),(409,7730,21,40720,40724,57,1525,1,0,'2021-01-04','2021-01-04',36966.12,1,1.00,'Transferencia realizada por 50000.00',NULL,'2023-03-27 18:30:31','2023-03-28 17:17:32','2023-03-28 17:17:32'),(410,7730,21,40720,40764,57,1525,1,1,'2021-01-29','2021-01-29',137498.23,1,1.00,NULL,NULL,'2023-03-27 18:58:21','2023-03-27 18:58:21',NULL),(411,7730,3,40720,40728,57,1525,2,1,'2021-01-31','2021-01-31',1206.09,1,1.00,'Factura A N°: 6364-04165950',NULL,'2023-03-28 12:14:55','2023-03-28 12:46:41',NULL),(412,7730,21,40720,40727,57,1525,1,0,'2021-01-31','2021-01-31',40365.09,1,1.00,NULL,NULL,'2023-03-28 12:20:13','2023-03-28 13:21:24','2023-03-28 13:21:24'),(413,7730,21,40720,40728,57,1525,1,0,'2021-01-31','2021-01-31',1206.09,1,1.00,NULL,NULL,'2023-03-28 12:22:21','2023-03-28 12:42:47','2023-03-28 12:42:47'),(414,7730,21,40720,40798,57,1525,1,1,'2021-01-31','2021-01-31',3298.43,1,1.00,NULL,NULL,'2023-03-28 12:24:10','2023-03-28 12:24:10',NULL),(415,7730,21,40720,40762,57,1525,1,1,'2021-01-22','2021-01-22',20000.00,1,1.00,NULL,NULL,'2023-03-28 12:40:44','2023-03-28 12:40:44',NULL),(416,7730,21,40720,40728,57,1525,1,1,'2021-01-31','2021-01-31',1206.09,1,1.00,NULL,NULL,'2023-03-28 12:46:41','2023-03-28 12:46:41',NULL),(417,7730,3,40720,40727,57,1525,1,0,'2021-01-08','2021-01-08',1204.90,1,1.00,'Nota de crédito A N°: 0011-00471338',NULL,'2023-03-28 13:14:06','2023-03-28 13:16:58','2023-03-28 13:16:58'),(418,7730,3,40720,40727,57,1525,1,0,'2021-01-08','2021-01-08',1204.90,1,1.00,'Nota de crédito A N°: 0011-00471338',NULL,'2023-03-28 13:16:58','2023-03-28 13:41:33','2023-03-28 13:41:33'),(419,7730,3,40720,40727,57,1525,2,0,'2021-01-10','2021-01-10',40365.09,1,1.00,'Factura A N°: 0011-01002751',NULL,'2023-03-28 13:22:49','2023-03-28 13:24:56','2023-03-28 13:24:56'),(420,7730,3,40720,40727,57,1525,2,0,'2021-01-10','2021-01-10',40365.09,1,1.00,'Factura A N°: 0011-01002751',NULL,'2023-03-28 13:24:56','2023-03-28 14:25:03',NULL),(421,7730,21,40720,40727,57,1525,1,0,'2021-01-31','2021-01-31',40365.09,1,1.00,NULL,NULL,'2023-03-28 13:26:34','2023-03-28 14:25:03','2023-03-28 14:25:03'),(422,7730,3,40720,40727,57,1525,1,0,'2021-01-08','2021-01-08',1204.90,1,1.00,'Nota de crédito A N°: 0011-00471338',NULL,'2023-03-28 13:41:33','2023-03-28 13:41:33',NULL),(423,7730,21,40720,40727,57,1525,1,0,'2021-01-31','2021-01-31',39160.19,1,1.00,NULL,NULL,'2023-03-28 14:38:52','2023-03-28 14:38:52',NULL),(424,7730,2,40720,40799,13,1526,1,0,'2021-02-01','2021-02-01',9990.00,1,1.00,'Factura B N°: 0001-00000071',NULL,'2023-03-28 15:17:33','2023-03-28 15:22:21','2023-03-28 15:22:21'),(425,7730,2,40720,40800,13,1526,1,0,'2021-02-02','2021-02-02',7919.00,1,1.00,'Factura B N°: 0001-00000072',NULL,'2023-03-28 15:17:33','2023-03-28 15:23:10','2023-03-28 15:23:10'),(426,7730,2,40720,40801,13,1526,1,0,'2021-02-02','2021-02-02',8557.00,1,1.00,'Factura B N°: 0001-00000073',NULL,'2023-03-28 15:17:33','2023-03-28 15:23:57','2023-03-28 15:23:57'),(427,7730,2,40720,40802,13,1526,1,0,'2021-02-02','2021-02-02',9990.00,1,1.00,'Factura B N°: 0001-00000074',NULL,'2023-03-28 15:17:33','2023-03-28 15:24:57','2023-03-28 15:24:57'),(428,7730,2,40720,40803,13,1526,1,0,'2021-02-02','2021-02-02',7590.00,1,1.00,'Factura B N°: 0001-00000075',NULL,'2023-03-28 15:17:33','2023-03-28 15:25:56','2023-03-28 15:25:56'),(429,7730,2,40720,40802,13,1526,1,0,'2021-02-02','2021-02-02',2990.00,1,1.00,'Factura B N°: 0001-00000076',NULL,'2023-03-28 15:17:33','2023-03-28 15:26:38','2023-03-28 15:26:38');
INSERT INTO `cta_cte_cliente` VALUES (430,7730,2,40720,40804,13,1526,1,0,'2021-02-02','2021-02-02',9990.00,1,1.00,'Factura B N°: 0001-00000077',NULL,'2023-03-28 15:17:34','2023-03-28 15:27:43','2023-03-28 15:27:43'),(431,7730,2,40720,40805,13,1526,1,0,'2021-02-09','2021-02-09',9990.00,1,1.00,'Factura B N°: 0001-00000078',NULL,'2023-03-28 15:17:34','2023-03-28 15:28:30','2023-03-28 15:28:30'),(432,7730,2,40720,40806,13,1526,1,0,'2021-02-10','2021-02-10',17780.00,1,1.00,'Factura A N°: 0001-00000009',NULL,'2023-03-28 15:17:34','2023-03-28 15:20:06','2023-03-28 15:20:06'),(433,7730,2,40720,40807,13,1526,1,0,'2021-02-10','2021-02-10',9990.00,1,1.00,'Factura B N°: 0001-00000079',NULL,'2023-03-28 15:17:34','2023-03-28 15:29:20','2023-03-28 15:29:20'),(434,7730,2,40720,40808,13,1526,1,0,'2021-02-10','2021-02-10',9990.00,1,1.00,'Factura B N°: 0001-00000080',NULL,'2023-03-28 15:17:34','2023-03-28 15:30:03','2023-03-28 15:30:03'),(435,7730,2,40720,40808,13,1526,1,0,'2021-02-10','2021-02-10',17780.00,1,1.00,'Factura B N°: 0001-00000081',NULL,'2023-03-28 15:17:34','2023-03-28 15:30:46','2023-03-28 15:30:46'),(436,7730,2,40720,40809,13,1526,1,0,'2021-02-10','2021-02-10',7919.00,1,1.00,'Factura B N°: 0001-00000082',NULL,'2023-03-28 15:17:34','2023-03-28 15:31:38','2023-03-28 15:31:38'),(437,7730,2,40720,40810,13,1526,1,0,'2021-02-10','2021-02-10',7990.00,1,1.00,'Factura B N°: 0001-00000083',NULL,'2023-03-28 15:17:34','2023-03-28 15:33:16','2023-03-28 15:33:16'),(438,7730,2,40720,40811,13,1526,1,0,'2021-02-12','2021-02-12',9990.00,1,1.00,'Factura B N°: 0001-00000084',NULL,'2023-03-28 15:17:34','2023-03-28 15:34:36','2023-03-28 15:34:36'),(439,7730,2,40720,40812,13,1526,1,0,'2021-02-18','2021-02-18',7990.00,1,1.00,'Factura A N°: 0001-00000010',NULL,'2023-03-28 15:17:34','2023-03-28 15:39:33','2023-03-28 15:39:33'),(440,7730,2,40720,40813,13,1526,1,0,'2021-02-18','2021-02-18',3400.00,1,1.00,'Factura B N°: 0001-00000085',NULL,'2023-03-28 15:17:34','2023-03-28 15:35:23','2023-03-28 15:35:23'),(441,7730,2,40720,40814,13,1526,1,0,'2021-02-18','2021-02-18',2750.00,1,1.00,'Factura B N°: 0001-00000086',NULL,'2023-03-28 15:17:34','2023-03-28 15:36:27','2023-03-28 15:36:27'),(442,7730,2,40720,40814,13,1526,1,0,'2021-02-18','2021-02-18',9990.00,1,1.00,'Factura B N°: 0001-00000087',NULL,'2023-03-28 15:17:34','2023-03-28 15:36:53','2023-03-28 15:36:53'),(443,7730,2,40720,40815,13,1526,1,0,'2021-02-19','2021-02-19',9990.00,1,1.00,'Factura B N°: 0001-00000088',NULL,'2023-03-28 15:17:34','2023-03-28 15:37:46','2023-03-28 15:37:46'),(444,7730,2,40720,40816,13,1526,1,0,'2021-02-22','2021-02-22',9490.50,1,1.00,'Factura B N°: 0001-00000089',NULL,'2023-03-28 15:17:34','2023-03-28 15:38:39','2023-03-28 15:38:39'),(445,7730,2,40720,40806,13,1526,1,0,'2021-02-10','2021-02-10',17780.00,1,1.00,'Factura A N°: 0001-00000009',NULL,'2023-03-28 15:21:09','2023-03-28 15:40:44','2023-03-28 15:40:44'),(446,7730,2,40720,40799,13,1526,1,1,'2021-02-01','2021-02-01',9990.00,1,1.00,'Factura B N°: 0001-00000071',NULL,'2023-03-28 15:22:21','2023-03-28 15:45:24',NULL),(447,7730,2,40720,40800,13,1526,1,1,'2021-02-02','2021-02-02',7919.00,1,1.00,'Factura B N°: 0001-00000072',NULL,'2023-03-28 15:23:10','2023-03-28 15:49:20',NULL),(448,7730,2,40720,40801,13,1526,1,1,'2021-02-02','2021-02-02',8557.00,1,1.00,'Factura B N°: 0001-00000073',NULL,'2023-03-28 15:23:57','2023-03-28 15:50:10',NULL),(449,7730,2,40720,40802,13,1526,1,1,'2021-02-02','2021-02-02',9990.00,1,1.00,'Factura B N°: 0001-00000074',NULL,'2023-03-28 15:24:57','2023-03-28 15:51:22',NULL),(450,7730,2,40720,40803,13,1526,1,1,'2021-02-02','2021-02-02',7590.00,1,1.00,'Factura B N°: 0001-00000075',NULL,'2023-03-28 15:25:56','2023-03-28 15:52:07',NULL),(451,7730,2,40720,40802,13,1526,1,1,'2021-02-02','2021-02-02',2990.00,1,1.00,'Factura B N°: 0001-00000076',NULL,'2023-03-28 15:26:38','2023-03-28 15:51:22',NULL),(452,7730,2,40720,40804,13,1526,1,1,'2021-02-02','2021-02-02',9990.00,1,1.00,'Factura B N°: 0001-00000077',NULL,'2023-03-28 15:27:43','2023-03-28 15:52:50',NULL);
INSERT INTO `cta_cte_cliente` VALUES (453,7730,2,40720,40805,13,1526,1,1,'2021-02-09','2021-02-09',9990.00,1,1.00,'Factura B N°: 0001-00000078',NULL,'2023-03-28 15:28:30','2023-03-28 15:53:55',NULL),(454,7730,2,40720,40807,13,1526,1,1,'2021-02-10','2021-02-10',9990.00,1,1.00,'Factura B N°: 0001-00000079',NULL,'2023-03-28 15:29:20','2023-03-28 15:54:34',NULL),(455,7730,2,40720,40808,13,1526,1,1,'2021-02-10','2021-02-10',9990.00,1,1.00,'Factura B N°: 0001-00000080',NULL,'2023-03-28 15:30:03','2023-03-28 15:55:24',NULL),(456,7730,2,40720,40808,13,1526,1,1,'2021-02-10','2021-02-10',17780.00,1,1.00,'Factura B N°: 0001-00000081',NULL,'2023-03-28 15:30:46','2023-03-28 15:55:24',NULL),(457,7730,2,40720,40809,13,1526,1,1,'2021-02-10','2021-02-10',7919.00,1,1.00,'Factura B N°: 0001-00000082',NULL,'2023-03-28 15:31:38','2023-03-28 15:56:05',NULL),(458,7730,2,40720,40810,13,1526,1,0,'2021-02-10','2021-02-10',7990.01,1,1.00,'Factura B N°: 0001-00000083',NULL,'2023-03-28 15:33:16','2023-03-28 15:33:38','2023-03-28 15:33:38'),(459,7730,2,40720,40811,13,1526,1,1,'2021-02-12','2021-02-12',9990.00,1,1.00,'Factura B N°: 0001-00000084',NULL,'2023-03-28 15:34:36','2023-03-28 15:56:48',NULL),(460,7730,2,40720,40813,13,1526,1,1,'2021-02-18','2021-02-18',3400.00,1,1.00,'Factura B N°: 0001-00000085',NULL,'2023-03-28 15:35:23','2023-03-28 15:57:28',NULL),(461,7730,2,40720,40814,13,1526,1,1,'2021-02-18','2021-02-18',2750.00,1,1.00,'Factura B N°: 0001-00000086',NULL,'2023-03-28 15:36:27','2023-03-28 16:00:04',NULL),(462,7730,2,40720,40814,13,1526,1,1,'2021-02-18','2021-02-18',9990.00,1,1.00,'Factura B N°: 0001-00000087',NULL,'2023-03-28 15:36:53','2023-03-28 16:00:04',NULL),(463,7730,2,40720,40815,13,1526,1,1,'2021-02-19','2021-02-19',9990.00,1,1.00,'Factura B N°: 0001-00000088',NULL,'2023-03-28 15:37:46','2023-03-28 16:00:52',NULL),(464,7730,2,40720,40816,13,1526,1,1,'2021-02-22','2021-02-22',9490.50,1,1.00,'Factura B N°: 0001-00000089',NULL,'2023-03-28 15:38:39','2023-03-28 16:02:38',NULL),(465,7730,2,40720,40812,13,1526,1,0,'2021-02-18','2021-02-18',7990.01,1,1.00,'Factura A N°: 0001-00000010',NULL,'2023-03-28 15:39:33','2023-03-28 15:44:07','2023-03-28 15:44:07'),(466,7730,2,40720,40806,13,1526,1,1,'2021-02-10','2021-02-10',17780.00,1,1.00,'Factura A N°: 0001-00000009',NULL,'2023-03-28 15:40:44','2023-03-28 16:03:43',NULL),(467,7730,2,40720,40810,13,1526,1,0,'2021-02-10','2021-02-10',7990.00,1,1.00,'Factura B N°: 0001-00000083',NULL,'2023-03-28 15:41:42','2023-03-28 15:43:08','2023-03-28 15:43:08'),(468,7730,2,40720,40810,13,1526,1,1,'2021-02-10','2021-02-10',7990.00,1,1.00,'Factura B N°: 0001-00000083',NULL,'2023-03-28 15:43:08','2023-03-28 16:01:53',NULL),(469,7730,2,40720,40812,13,1526,1,1,'2021-02-18','2021-02-18',7990.00,1,1.00,'Factura A N°: 0001-00000010',NULL,'2023-03-28 15:44:07','2023-03-28 16:04:41',NULL),(470,7730,20,40720,40799,13,1526,2,1,'2021-02-01','2021-02-01',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:45:24','2023-03-28 15:45:24',NULL),(471,7730,20,40720,40800,13,1526,2,1,'2021-02-02','2021-02-02',7919.00,1,1.00,NULL,NULL,'2023-03-28 15:49:20','2023-03-28 15:49:20',NULL),(472,7730,20,40720,40801,13,1526,2,1,'2021-02-02','2021-02-02',8557.00,1,1.00,NULL,NULL,'2023-03-28 15:50:10','2023-03-28 15:50:10',NULL),(473,7730,20,40720,40802,13,1526,2,1,'2021-02-02','2021-02-02',12980.00,1,1.00,NULL,NULL,'2023-03-28 15:51:22','2023-03-28 15:51:22',NULL),(474,7730,20,40720,40803,13,1526,2,1,'2021-02-02','2021-02-02',7590.00,1,1.00,NULL,NULL,'2023-03-28 15:52:07','2023-03-28 15:52:07',NULL),(475,7730,20,40720,40804,13,1526,2,1,'2021-02-02','2021-02-02',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:52:50','2023-03-28 15:52:50',NULL),(476,7730,20,40720,40805,13,1526,2,1,'2021-02-09','2021-02-09',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:53:55','2023-03-28 15:53:55',NULL),(477,7730,20,40720,40807,13,1526,2,1,'2021-02-10','2021-02-10',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:54:34','2023-03-28 15:54:34',NULL);
INSERT INTO `cta_cte_cliente` VALUES (478,7730,20,40720,40808,13,1526,2,1,'2021-02-10','2021-02-10',27770.00,1,1.00,NULL,NULL,'2023-03-28 15:55:24','2023-03-28 15:55:24',NULL),(479,7730,20,40720,40809,13,1526,2,1,'2021-02-10','2021-02-10',7919.00,1,1.00,NULL,NULL,'2023-03-28 15:56:05','2023-03-28 15:56:05',NULL),(480,7730,20,40720,40811,13,1526,2,1,'2021-02-12','2021-02-12',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:56:48','2023-03-28 15:56:48',NULL),(481,7730,20,40720,40813,13,1526,2,1,'2021-02-18','2021-02-18',3400.00,1,1.00,NULL,NULL,'2023-03-28 15:57:28','2023-03-28 15:57:28',NULL),(482,7730,20,40720,40814,13,1526,2,1,'2021-02-18','2021-02-18',12740.00,1,1.00,NULL,NULL,'2023-03-28 16:00:04','2023-03-28 16:00:04',NULL),(483,7730,20,40720,40815,13,1526,2,1,'2021-02-19','2021-02-19',9990.00,1,1.00,NULL,NULL,'2023-03-28 16:00:52','2023-03-28 16:00:52',NULL),(484,7730,20,40720,40810,13,1526,2,1,'2021-02-10','2021-02-10',7990.00,1,1.00,NULL,NULL,'2023-03-28 16:01:53','2023-03-28 16:01:53',NULL),(485,7730,20,40720,40816,13,1526,2,1,'2021-02-22','2021-02-22',9490.50,1,1.00,NULL,NULL,'2023-03-28 16:02:38','2023-03-28 16:02:38',NULL),(486,7730,20,40720,40806,13,1526,2,1,'2021-02-10','2021-02-10',17780.00,1,1.00,NULL,NULL,'2023-03-28 16:03:43','2023-03-28 16:03:43',NULL),(487,7730,20,40720,40812,13,1526,2,1,'2021-02-18','2021-02-18',7990.00,1,1.00,NULL,NULL,'2023-03-28 16:04:41','2023-03-28 16:04:41',NULL),(488,7730,3,40720,40724,57,1526,2,0,'2021-02-01','2021-02-01',25003.44,1,1.00,'Factura A N°: 0003-00004470',NULL,'2023-03-28 16:08:42','2023-03-29 10:33:33','2023-03-29 10:33:33'),(489,7730,3,40720,40764,57,1526,2,0,'2021-02-03','2021-02-03',2244.43,1,1.00,'Factura A N°: 0002-00000049',NULL,'2023-03-28 16:08:42','2023-03-29 10:33:15','2023-03-29 10:33:15'),(490,7730,3,40720,40762,57,1526,2,0,'2021-02-03','2021-02-03',20000.00,1,1.00,'Factura C N°: 0002-00000029',NULL,'2023-03-28 16:08:43','2023-03-28 16:10:10','2023-03-28 16:10:10'),(491,7730,3,40720,40725,57,1526,2,0,'2021-02-04','2021-02-04',1754.50,1,1.00,'Factura B N°: 0003-00044154',NULL,'2023-03-28 16:08:43','2023-03-28 16:10:37','2023-03-28 16:10:37'),(492,7730,3,40720,40724,57,1526,2,0,'2021-02-08','2021-02-08',4378.50,1,1.00,'Factura A N°: 0003-00004488',NULL,'2023-03-28 16:08:43','2023-03-29 10:32:55','2023-03-29 10:32:55'),(493,7730,3,40720,40727,57,1526,2,0,'2021-02-09','2021-02-09',42059.18,1,1.00,'Factura A N°: 0011-01029077',NULL,'2023-03-28 16:08:43','2023-03-28 16:13:57','2023-03-28 16:13:57'),(494,7730,3,40720,40724,57,1526,2,0,'2021-02-09','2021-02-09',5307.97,1,1.00,'Factura A N°: 0003-00004490',NULL,'2023-03-28 16:08:43','2023-03-29 10:32:43','2023-03-29 10:32:43'),(495,7730,3,40720,40724,57,1526,2,0,'2021-02-10','2021-02-10',4267.07,1,1.00,'Factura A N°: 0003-00004496',NULL,'2023-03-28 16:08:43','2023-03-29 10:36:56','2023-03-29 10:36:56'),(496,7730,3,40720,40724,57,1526,2,0,'2021-02-10','2021-02-10',5103.78,1,1.00,'Factura A N°: 0003-00004495',NULL,'2023-03-28 16:08:43','2023-03-29 10:32:30','2023-03-29 10:32:30'),(497,7730,3,40720,40724,57,1526,2,0,'2021-02-10','2021-02-10',5934.14,1,1.00,'Factura A N°: 0003-00004497',NULL,'2023-03-28 16:08:43','2023-03-29 10:32:13','2023-03-29 10:32:13'),(498,7730,3,40720,40764,57,1526,2,0,'2021-02-11','2021-02-11',29520.61,1,1.00,'Factura A N°: 0002-00000052',NULL,'2023-03-28 16:08:43','2023-03-29 10:31:59','2023-03-29 10:31:59'),(499,7730,3,40720,40764,57,1526,2,0,'2021-02-23','2021-02-23',12374.31,1,1.00,'Factura A N°: 0002-00000054',NULL,'2023-03-28 16:08:43','2023-03-29 10:31:45','2023-03-29 10:31:45'),(500,7730,3,40720,40728,57,1526,2,0,'2021-02-28','2021-02-28',1206.09,1,1.00,'Factura A N°: 6364-04272969',NULL,'2023-03-28 16:08:43','2023-03-28 16:16:33','2023-03-28 16:16:33'),(501,7730,3,40720,40762,57,1526,2,0,'2021-02-03','2021-02-03',20000.00,1,1.00,'Factura C N°: 0002-00000029',NULL,'2023-03-28 16:10:10','2023-03-28 16:14:44','2023-03-28 16:14:44');
INSERT INTO `cta_cte_cliente` VALUES (502,7730,3,40720,40727,57,1526,2,1,'2021-02-09','2021-02-09',42059.18,1,1.00,'Factura A N°: 0011-01029077',NULL,'2023-03-28 16:13:57','2023-03-28 16:17:50',NULL),(503,7730,3,40720,40762,57,1526,2,1,'2021-02-03','2021-02-03',20000.00,1,1.00,'Factura C N°: 0002-00000029',NULL,'2023-03-28 16:14:44','2023-03-28 16:20:44',NULL),(504,7730,3,40720,40728,57,1526,2,1,'2021-02-28','2021-02-28',1206.09,1,1.00,'Factura A N°: 6364-04272969',NULL,'2023-03-28 16:16:33','2023-03-28 16:46:32',NULL),(505,7730,21,40720,40727,57,1526,1,1,'2021-02-28','2021-02-28',42059.18,1,1.00,NULL,NULL,'2023-03-28 16:17:50','2023-03-28 16:17:50',NULL),(506,7730,21,40720,40762,57,1526,1,1,'2021-02-28','2021-02-28',20000.00,1,1.00,NULL,NULL,'2023-03-28 16:20:44','2023-03-28 16:20:44',NULL),(507,7730,20,40720,40728,13,1526,2,0,'2021-02-28','2021-02-28',1206.09,1,1.00,NULL,NULL,'2023-03-28 16:21:40','2023-03-28 16:45:54','2023-03-28 16:45:54'),(508,7730,21,40720,40728,57,1526,1,1,'2021-02-28','2021-02-28',1206.09,1,1.00,NULL,NULL,'2023-03-28 16:46:32','2023-03-28 16:46:32',NULL),(509,7730,21,40720,40724,57,1525,1,0,'2021-01-04','2021-01-04',50000.00,1,1.00,NULL,NULL,'2023-03-28 17:19:46','2023-03-28 17:19:46',NULL),(510,7730,21,40720,40724,57,1526,1,0,'2021-02-17','2021-02-17',90000.00,1,1.00,NULL,NULL,'2023-03-28 17:23:20','2023-03-28 17:23:20',NULL),(511,7730,3,40720,40764,57,1526,2,0,'2021-02-23','2021-02-23',12374.31,1,1.00,'Factura A N°: 0002-00000054',NULL,'2023-03-29 10:31:45','2023-03-29 10:31:45',NULL),(512,7730,3,40720,40764,57,1526,2,0,'2021-02-11','2021-02-11',29520.61,1,1.00,'Factura A N°: 0002-00000052',NULL,'2023-03-29 10:31:59','2023-03-29 10:31:59',NULL),(513,7730,3,40720,40724,57,1526,2,0,'2021-02-10','2021-02-10',5934.14,1,1.00,'Factura A N°: 0003-00004497',NULL,'2023-03-29 10:32:13','2023-03-29 10:32:13',NULL),(514,7730,3,40720,40724,57,1526,2,0,'2021-02-10','2021-02-10',5103.78,1,1.00,'Factura A N°: 0003-00004495',NULL,'2023-03-29 10:32:30','2023-03-29 10:32:30',NULL),(515,7730,3,40720,40724,57,1526,2,0,'2021-02-09','2021-02-09',5307.97,1,1.00,'Factura A N°: 0003-00004490',NULL,'2023-03-29 10:32:43','2023-03-29 10:32:43',NULL),(516,7730,3,40720,40724,57,1526,2,0,'2021-02-08','2021-02-08',4378.50,1,1.00,'Factura A N°: 0003-00004488',NULL,'2023-03-29 10:32:55','2023-03-29 10:32:55',NULL),(517,7730,3,40720,40764,57,1526,2,0,'2021-02-03','2021-02-03',2244.43,1,1.00,'Factura A N°: 0002-00000049',NULL,'2023-03-29 10:33:15','2023-03-29 10:33:15',NULL),(518,7730,3,40720,40724,57,1526,2,0,'2021-02-01','2021-02-01',25003.44,1,1.00,'Factura A N°: 0003-00004470',NULL,'2023-03-29 10:33:33','2023-03-29 10:33:33',NULL),(519,7730,3,40720,40724,57,1526,2,0,'2021-02-10','2021-02-10',4267.07,1,1.00,'Factura A N°: 0003-00004496',NULL,'2023-03-29 10:36:56','2023-03-29 10:36:56',NULL),(520,7730,2,40720,40817,13,1527,1,0,'2021-03-01','2021-03-01',2000.00,1,1.00,'Factura B N°: 0001-00000091',NULL,'2023-03-29 10:40:16','2023-03-29 10:42:31','2023-03-29 10:42:31'),(521,7730,2,40720,40817,13,1527,1,0,'2021-03-01','2021-03-01',6800.00,1,1.00,'Factura B N°: 0001-00000090',NULL,'2023-03-29 10:40:16','2023-03-29 10:42:06','2023-03-29 10:42:06'),(522,7730,2,40720,40818,13,1527,1,0,'2021-03-02','2021-03-02',2397.00,1,1.00,'Factura B N°: 0001-00000092',NULL,'2023-03-29 10:40:16','2023-03-29 10:43:38','2023-03-29 10:43:38'),(523,7730,2,40720,40819,13,1527,1,0,'2021-03-02','2021-03-02',7990.00,1,1.00,'Factura B N°: 0001-00000093',NULL,'2023-03-29 10:40:16','2023-03-29 10:45:21','2023-03-29 10:45:21'),(524,7730,2,40720,40820,13,1527,1,0,'2021-03-05','2021-03-05',7830.00,1,1.00,'Factura B N°: 0001-00000094',NULL,'2023-03-29 10:40:16','2023-03-29 10:47:01','2023-03-29 10:47:01'),(525,7730,2,40720,40820,13,1527,1,0,'2021-03-05','2021-03-05',1500.00,1,1.00,'Factura B N°: 0001-00000095',NULL,'2023-03-29 10:40:16','2023-03-29 10:47:18','2023-03-29 10:47:18');
INSERT INTO `cta_cte_cliente` VALUES (526,7730,2,40720,40820,13,1527,1,0,'2021-03-05','2021-03-05',7990.00,1,1.00,'Factura B N°: 0001-00000096',NULL,'2023-03-29 10:40:16','2023-03-29 10:47:55','2023-03-29 10:47:55'),(527,7730,2,40720,40817,13,1527,1,1,'2021-03-01','2021-03-01',6800.00,1,1.00,'Factura B N°: 0001-00000090',NULL,'2023-03-29 10:42:06','2023-03-29 10:50:15',NULL),(528,7730,2,40720,40817,13,1527,1,1,'2021-03-01','2021-03-01',2000.00,1,1.00,'Factura B N°: 0001-00000091',NULL,'2023-03-29 10:42:31','2023-03-29 10:50:15',NULL),(529,7730,2,40720,40818,13,1527,1,1,'2021-03-02','2021-03-02',2397.00,1,1.00,'Factura B N°: 0001-00000092',NULL,'2023-03-29 10:43:38','2023-03-29 11:05:47','2023-03-29 11:05:47'),(530,7730,2,40720,40819,13,1527,1,1,'2021-03-02','2021-03-02',7990.00,1,1.00,'Factura B N°: 0001-00000093',NULL,'2023-03-29 10:45:21','2023-03-29 10:53:20',NULL),(531,7730,2,40720,40820,13,1527,1,1,'2021-03-05','2021-03-05',7830.00,1,1.00,'Factura B N°: 0001-00000094',NULL,'2023-03-29 10:47:01','2023-03-29 11:22:52','2023-03-29 11:22:52'),(532,7730,2,40720,40820,13,1527,1,1,'2021-03-05','2021-03-05',1500.00,1,1.00,'Factura B N°: 0001-00000095',NULL,'2023-03-29 10:47:18','2023-03-29 11:23:17','2023-03-29 11:23:17'),(533,7730,2,40720,40820,13,1527,1,1,'2021-03-05','2021-03-05',7990.00,1,1.00,'Factura B N°: 0001-00000096',NULL,'2023-03-29 10:47:55','2023-03-29 11:23:51','2023-03-29 11:23:51'),(534,7730,20,40720,40817,13,1527,2,1,'2021-03-01','2021-03-01',8800.00,1,1.00,NULL,NULL,'2023-03-29 10:50:15','2023-03-29 10:50:15',NULL),(535,7730,20,40720,40819,13,1527,2,1,'2021-03-02','2021-03-02',7990.00,1,1.00,NULL,NULL,'2023-03-29 10:53:20','2023-03-29 10:53:20',NULL),(536,7730,20,40720,40818,13,1527,2,0,'2021-03-02','2021-03-02',2397.00,1,1.00,NULL,NULL,'2023-03-29 11:05:46','2023-03-29 13:19:28',NULL),(537,7730,2,40720,40818,13,1527,1,0,'2021-03-02','2021-03-02',2397.00,1,1.00,'Factura B N°: 0001-00000092',NULL,'2023-03-29 11:05:47','2023-03-29 11:05:47',NULL),(538,7730,20,40720,40820,13,1527,2,0,'2021-03-05','2021-03-05',7830.00,1,1.00,NULL,NULL,'2023-03-29 11:22:52','2023-03-29 13:19:28',NULL),(539,7730,2,40720,40820,13,1527,1,0,'2021-03-05','2021-03-05',7830.00,1,1.00,'Factura B N°: 0001-00000094',NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(540,7730,20,40720,40820,13,1527,2,0,'2021-03-05','2021-03-05',1500.00,1,1.00,NULL,NULL,'2023-03-29 11:23:16','2023-03-29 13:19:28',NULL),(541,7730,2,40720,40820,13,1527,1,0,'2021-03-05','2021-03-05',1500.00,1,1.00,'Factura B N°: 0001-00000095',NULL,'2023-03-29 11:23:17','2023-03-29 11:23:17',NULL),(542,7730,20,40720,40820,13,1527,2,0,'2021-03-05','2021-03-05',7990.00,1,1.00,NULL,NULL,'2023-03-29 11:23:50','2023-03-29 13:19:28',NULL),(543,7730,2,40720,40820,13,1527,1,0,'2021-03-05','2021-03-05',7990.00,1,1.00,'Factura B N°: 0001-00000096',NULL,'2023-03-29 11:23:51','2023-03-29 11:23:51',NULL),(544,7730,3,40720,40728,57,1527,2,0,'2021-03-31','2021-03-31',1206.09,1,1.00,'Factura A N°: 6364-04381710',NULL,'2023-03-29 11:27:14','2023-03-29 13:05:26','2023-03-29 13:05:26'),(545,7730,3,40720,40727,57,1527,2,0,'2021-03-29','2021-03-29',31867.42,1,1.00,'Factura A N°: 0011-01059571',NULL,'2023-03-29 11:27:14','2023-03-29 11:39:39','2023-03-29 11:39:39'),(546,7730,3,40720,40724,57,1527,2,0,'2021-03-16','2021-03-16',4653.66,1,1.00,'Factura A N°: 0003-00004567',NULL,'2023-03-29 11:27:14','2023-03-29 11:30:03','2023-03-29 11:30:03'),(547,7730,3,40720,40724,57,1527,2,0,'2021-03-11','2021-03-11',6053.03,1,1.00,'Factura A N°: 0003-00004558',NULL,'2023-03-29 11:27:14','2023-03-29 11:29:51','2023-03-29 11:29:51'),(548,7730,3,40720,40724,57,1527,2,0,'2021-03-11','2021-03-11',7567.64,1,1.00,'Factura A N°: 0003-00004559',NULL,'2023-03-29 11:27:14','2023-03-29 11:29:38','2023-03-29 11:29:38'),(549,7730,3,40720,40764,57,1527,2,0,'2021-03-08','2021-03-08',6969.60,1,1.00,'Factura A N°: 0002-00000058',NULL,'2023-03-29 11:27:14','2023-03-29 11:29:25','2023-03-29 11:29:25');
INSERT INTO `cta_cte_cliente` VALUES (550,7730,3,40720,40764,57,1527,2,0,'2021-03-05','2021-03-05',5454.80,1,1.00,'Factura A N°: 0002-00000056',NULL,'2023-03-29 11:27:14','2023-03-29 11:29:14','2023-03-29 11:29:14'),(551,7730,3,40720,40724,57,1527,2,0,'2021-03-05','2021-03-05',7567.64,1,1.00,'Factura A N°: 0003-00004553',NULL,'2023-03-29 11:27:14','2023-03-29 11:28:59','2023-03-29 11:28:59'),(552,7730,3,40720,40724,57,1527,2,0,'2021-03-04','2021-03-04',5767.16,1,1.00,'Factura A N°: 0003-00004546',NULL,'2023-03-29 11:27:14','2023-03-29 11:28:45','2023-03-29 11:28:45'),(553,7730,3,40720,40724,57,1527,2,0,'2021-03-03','2021-03-03',4267.07,1,1.00,'Factura A N°: 0003-00004540',NULL,'2023-03-29 11:27:14','2023-03-29 11:28:34','2023-03-29 11:28:34'),(554,7730,3,40720,40762,57,1527,2,0,'2021-03-02','2021-03-02',20000.00,1,1.00,'Factura C N°: 0002-00000030',NULL,'2023-03-29 11:27:14','2023-03-29 11:28:21','2023-03-29 11:28:21'),(555,7730,3,40720,40762,57,1527,2,1,'2021-03-02','2021-03-02',20000.00,1,1.00,'Factura C N°: 0002-00000030',NULL,'2023-03-29 11:28:21','2023-03-29 13:07:14','2023-03-29 13:07:14'),(556,7730,3,40720,40724,57,1527,2,0,'2021-03-03','2021-03-03',4267.07,1,1.00,'Factura A N°: 0003-00004540',NULL,'2023-03-29 11:28:34','2023-03-29 13:09:37','2023-03-29 13:09:37'),(557,7730,3,40720,40724,57,1527,2,0,'2021-03-04','2021-03-04',5767.16,1,1.00,'Factura A N°: 0003-00004546',NULL,'2023-03-29 11:28:45','2023-03-29 11:28:45',NULL),(558,7730,3,40720,40724,57,1527,2,0,'2021-03-05','2021-03-05',7567.64,1,1.00,'Factura A N°: 0003-00004553',NULL,'2023-03-29 11:28:59','2023-03-29 11:28:59',NULL),(559,7730,3,40720,40764,57,1527,2,0,'2021-03-05','2021-03-05',5454.80,1,1.00,'Factura A N°: 0002-00000056',NULL,'2023-03-29 11:29:14','2023-03-29 13:12:50','2023-03-29 13:12:50'),(560,7730,3,40720,40764,57,1527,2,0,'2021-03-08','2021-03-08',6969.60,1,1.00,'Factura A N°: 0002-00000058',NULL,'2023-03-29 11:29:25','2023-03-29 11:29:25',NULL),(561,7730,3,40720,40724,57,1527,2,0,'2021-03-11','2021-03-11',7567.64,1,1.00,'Factura A N°: 0003-00004559',NULL,'2023-03-29 11:29:38','2023-03-29 11:29:38',NULL),(562,7730,3,40720,40724,57,1527,2,0,'2021-03-11','2021-03-11',6053.03,1,1.00,'Factura A N°: 0003-00004558',NULL,'2023-03-29 11:29:51','2023-03-29 11:29:51',NULL),(563,7730,3,40720,40724,57,1527,2,0,'2021-03-16','2021-03-16',4653.66,1,1.00,'Factura A N°: 0003-00004567',NULL,'2023-03-29 11:30:03','2023-03-29 11:30:03',NULL),(564,7730,3,40720,40727,57,1527,2,0,'2021-03-29','2021-03-29',39278.17,1,1.00,'Factura A N°: 0011-01059571',NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(565,7730,3,40720,40727,57,1527,2,1,'2021-03-29','2021-03-29',31867.42,1,1.00,'Factura A N°: 0011-01059571',NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(566,7730,3,40720,40728,57,1527,2,0,'2021-03-31','2021-03-31',1206.09,1,1.00,'Factura A N°: 6364-04381710',NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(567,7730,3,40720,40728,57,1527,2,1,'2021-03-31','2021-03-31',1206.09,1,1.00,'Factura A N°: 6364-04381710',NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(568,7730,21,40720,40762,57,1527,1,0,'2021-03-02','2021-03-02',20000.00,1,1.00,NULL,NULL,'2023-03-29 13:07:13','2023-03-29 13:19:28',NULL),(569,7730,3,40720,40762,57,1527,2,0,'2021-03-02','2021-03-02',20000.00,1,1.00,'Factura C N°: 0002-00000030',NULL,'2023-03-29 13:07:14','2023-03-29 13:07:14',NULL),(570,7730,21,40720,40727,57,1527,1,0,'2021-03-29','2021-03-29',31867.42,1,1.00,NULL,NULL,'2023-03-29 13:07:54','2023-03-29 13:19:28',NULL),(571,7730,3,40720,40727,57,1527,2,0,'2021-03-29','2021-03-29',31867.42,1,1.00,'Factura A N°: 0011-01059571',NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(572,7730,21,40720,40724,57,1527,1,0,'2021-03-03','2021-03-03',11721.00,1,1.00,NULL,NULL,'2023-03-29 13:09:36','2023-03-29 13:09:36',NULL);
INSERT INTO `cta_cte_cliente` VALUES (573,7730,3,40720,40724,57,1527,2,0,'2021-03-03','2021-03-03',4267.07,1,1.00,'Factura A N°: 0003-00004540',NULL,'2023-03-29 13:09:37','2023-03-29 13:09:37',NULL),(574,7730,21,40720,40764,57,1527,1,0,'2021-03-05','2021-03-05',67248.27,1,1.00,NULL,NULL,'2023-03-29 13:12:50','2023-03-29 13:19:28','2023-03-29 13:19:28'),(575,7730,3,40720,40764,57,1527,2,0,'2021-03-05','2021-03-05',5454.80,1,1.00,'Factura A N°: 0002-00000056',NULL,'2023-03-29 13:12:50','2023-03-29 13:21:22','2023-03-29 13:21:22'),(576,7730,21,40720,40728,57,1527,1,0,'2021-03-31','2021-03-31',1206.09,1,1.00,NULL,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:23','2023-03-29 14:54:23'),(577,7730,3,40720,40728,57,1527,2,0,'2021-03-31','2021-03-31',1206.09,1,1.00,'Factura A N°: 6364-04381710',NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(578,7730,21,40720,40764,57,1527,1,0,'2021-03-05','2021-03-05',67248.27,1,1.00,NULL,NULL,'2023-03-29 13:21:21','2023-03-29 13:21:21',NULL),(579,7730,3,40720,40764,57,1527,2,0,'2021-03-05','2021-03-05',5454.80,1,1.00,'Factura A N°: 0002-00000056',NULL,'2023-03-29 13:21:22','2023-03-29 13:21:22',NULL),(580,7730,21,40720,40763,57,1525,1,0,'2021-01-10','2021-01-10',1513750.00,1,1.00,NULL,NULL,'2023-03-29 13:30:40','2023-03-29 14:02:04','2023-03-29 14:02:04'),(581,7730,3,40720,40728,57,1527,2,1,'2021-03-31','2021-03-31',1206.09,1,1.00,'Factura A N°: 6364-04381710',NULL,'2023-03-29 14:54:53','2023-03-29 14:56:01',NULL),(582,7730,21,40720,40728,57,1527,1,1,'2021-03-31','2021-03-31',1206.09,1,1.00,NULL,NULL,'2023-03-29 14:56:01','2023-03-29 14:56:01',NULL),(583,7730,3,40720,40728,57,1528,2,0,'2021-04-30','2021-04-30',1206.09,1,1.00,'Factura A N°: 6364-04489633',NULL,'2023-03-29 17:30:47','2023-03-29 17:32:16','2023-03-29 17:32:16'),(584,7730,3,40720,40728,57,1528,2,1,'2021-04-30','2021-04-30',1206.09,1,1.00,'Factura A N°: 6364-04489633',NULL,'2023-03-29 17:32:16','2023-03-29 18:42:54',NULL),(585,7730,21,40720,40728,57,1528,1,0,'2021-05-10','2021-05-10',1206.09,1,1.00,NULL,NULL,'2023-03-29 17:36:56','2023-03-29 18:41:50','2023-03-29 18:41:50'),(586,7730,3,40720,40728,57,1529,2,0,'2021-05-31','2021-05-31',261.88,1,1.00,'Factura A N°: 6364-04599360',NULL,'2023-03-29 18:29:35','2023-03-29 18:41:12','2023-03-29 18:41:12'),(587,7730,3,40720,40728,57,1529,2,1,'2021-05-31','2021-05-31',261.88,1,1.00,'Factura A N°: 6364-04599360',NULL,'2023-03-29 18:41:12','2023-03-29 20:05:20',NULL),(588,7730,21,40720,40728,57,1529,1,1,'2021-05-31','2021-05-31',1206.09,1,1.00,NULL,NULL,'2023-03-29 18:42:54','2023-03-29 18:42:54',NULL),(589,7730,3,40720,40728,57,1530,2,0,'2021-06-30','2021-06-30',1528.76,1,1.00,'Factura A N°: 6364-04706100',NULL,'2023-03-29 19:28:12','2023-03-29 20:01:23','2023-03-29 20:01:23'),(590,7730,3,40720,40728,57,1530,2,0,'2021-06-30','2021-06-30',1528.76,1,1.00,'Factura A N°: 6364-04706100',NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(591,7730,3,40720,40728,57,1530,2,1,'2021-06-30','2021-06-30',1528.76,1,1.00,'Factura A N°: 6364-04706100',NULL,'2023-03-29 20:03:43','2023-03-29 20:20:24',NULL),(592,7730,21,40720,40728,57,1530,1,1,'2021-06-10','2021-06-10',261.88,1,1.00,NULL,NULL,'2023-03-29 20:05:20','2023-03-29 20:05:20',NULL),(593,7730,3,40720,40728,57,1531,2,0,'2021-07-31','2021-07-31',366.63,1,1.00,'Factura A N°: 6364-04848739',NULL,'2023-03-29 20:18:01','2023-03-29 20:19:14','2023-03-29 20:19:14'),(594,7730,3,40720,40728,57,1531,2,0,'2021-07-31','2021-07-31',366.63,1,1.00,'Factura A N°: 6364-04848739',NULL,'2023-03-29 20:19:14','2023-03-29 20:19:39','2023-03-29 20:19:39'),(595,7730,3,40720,40728,57,1531,2,1,'2021-07-31','2021-07-31',366.63,1,1.00,'Factura A N°: 6364-04848739',NULL,'2023-03-29 20:19:39','2023-03-29 20:37:23',NULL),(596,7730,21,40720,40728,57,1531,1,1,'2021-07-10','2021-07-10',1528.76,1,1.00,NULL,NULL,'2023-03-29 20:20:24','2023-03-29 20:20:24',NULL),(597,7730,21,40720,40728,57,1532,1,1,'2021-08-10','2021-08-10',366.63,1,1.00,NULL,NULL,'2023-03-29 20:37:23','2023-03-29 20:37:23',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=327 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_details` VALUES (1,7730,5,40720,40721,13,1520,20,2,5271.99,'2022-08-28 15:04:15','2022-08-28 16:39:22','2022-08-28 16:39:22'),(2,7730,5,40720,40721,757,1520,20,1,5271.99,'2022-08-28 15:04:15','2022-08-28 16:39:22','2022-08-28 16:39:22'),(3,7730,6,40720,40721,13,1520,20,2,5272.00,'2022-08-28 16:43:18','2022-08-28 16:54:30','2022-08-28 16:54:30'),(4,7730,6,40720,40721,757,1520,20,1,5272.00,'2022-08-28 16:43:18','2022-08-28 16:54:30','2022-08-28 16:54:30'),(5,7730,7,40720,40721,13,1520,20,2,5271.99,'2022-08-28 16:55:29','2022-08-28 23:49:23','2022-08-28 23:49:23'),(6,7730,7,40720,40721,757,1520,20,1,5271.99,'2022-08-28 16:55:29','2022-08-28 23:49:23','2022-08-28 23:49:23'),(7,7730,11,40720,40721,13,1520,20,2,5272.00,'2022-08-28 23:51:22','2022-08-29 00:15:32','2022-08-29 00:15:32'),(8,7730,11,40720,40721,757,1520,20,1,5272.00,'2022-08-28 23:51:22','2022-08-29 00:15:32','2022-08-29 00:15:32'),(9,7730,12,40720,40721,13,1520,20,2,5272.00,'2022-08-29 00:16:35','2022-09-02 04:26:26','2022-09-02 04:26:26'),(10,7730,12,40720,40721,757,1520,20,1,5272.00,'2022-08-29 00:16:35','2022-09-02 04:26:26','2022-09-02 04:26:26'),(11,7730,15,40720,40723,13,1521,20,2,4815.00,'2022-08-29 00:39:42','2022-09-02 04:26:31','2022-09-02 04:26:31'),(12,7730,15,40720,40723,757,1521,20,1,4815.00,'2022-08-29 00:39:42','2022-09-02 04:26:31','2022-09-02 04:26:31'),(13,7730,31,40720,40726,57,1521,21,1,14400.00,'2022-08-29 01:53:25','2022-09-02 02:50:01','2022-09-02 02:50:01'),(14,7730,31,40720,40726,359,1521,21,2,14400.00,'2022-08-29 01:53:25','2022-09-02 02:50:01','2022-09-02 02:50:01'),(15,7730,32,40720,40726,57,1521,21,1,786.50,'2022-08-29 01:55:39','2022-08-29 01:56:02','2022-08-29 01:56:02'),(16,7730,32,40720,40726,359,1521,21,2,786.50,'2022-08-29 01:55:39','2022-08-29 01:56:02','2022-08-29 01:56:02'),(17,7730,33,40720,40726,57,1521,21,1,786.50,'2022-08-29 01:56:57','2022-08-29 01:59:28','2022-08-29 01:59:28'),(18,7730,33,40720,40726,359,1521,21,2,786.50,'2022-08-29 01:56:57','2022-08-29 01:59:28','2022-08-29 01:59:28'),(19,7730,34,40720,40727,57,1521,21,1,747.66,'2022-08-29 01:59:15','2022-08-29 02:06:13','2022-08-29 02:06:13'),(20,7730,34,40720,40727,757,1521,21,2,747.66,'2022-08-29 01:59:15','2022-08-29 02:06:13','2022-08-29 02:06:13'),(21,7730,35,40720,40727,57,1521,21,1,786.50,'2022-08-29 02:01:13','2022-08-29 02:07:43','2022-08-29 02:07:43'),(22,7730,35,40720,40727,359,1521,21,2,786.50,'2022-08-29 02:01:13','2022-08-29 02:07:43','2022-08-29 02:07:43'),(23,7730,37,40720,40727,57,1521,21,1,747.66,'2022-08-29 02:12:05','2022-09-02 02:02:41','2022-09-02 02:02:41'),(24,7730,37,40720,40727,757,1521,21,2,747.66,'2022-08-29 02:12:05','2022-09-02 02:02:41','2022-09-02 02:02:41'),(25,7730,38,40720,40725,57,1521,21,1,786.50,'2022-08-29 02:13:35','2022-09-02 02:50:52','2022-09-02 02:50:52'),(26,7730,38,40720,40725,359,1521,21,2,786.50,'2022-08-29 02:13:35','2022-09-02 02:50:52','2022-09-02 02:50:52'),(27,7730,39,40720,40725,57,1521,21,1,989.41,'2022-08-29 02:14:47','2022-08-29 02:15:06','2022-08-29 02:15:06'),(28,7730,39,40720,40725,359,1521,21,2,989.41,'2022-08-29 02:14:47','2022-08-29 02:15:06','2022-08-29 02:15:06'),(29,7730,40,40720,40728,57,1521,21,1,989.41,'2022-08-29 02:16:34','2022-09-02 02:54:54','2022-09-02 02:54:54'),(30,7730,40,40720,40728,359,1521,21,2,989.41,'2022-08-29 02:16:34','2022-09-02 02:54:54','2022-09-02 02:54:54'),(31,7730,59,40720,40718,13,1522,20,2,5295.00,'2022-09-01 18:27:19','2022-09-01 18:29:15','2022-09-01 18:29:15'),(32,7730,59,40720,40718,757,1522,20,1,5295.00,'2022-09-01 18:27:19','2022-09-01 18:29:15','2022-09-01 18:29:15'),(33,7730,60,40720,40718,13,1522,20,2,219.00,'2022-09-01 18:29:03','2022-09-01 18:32:07','2022-09-01 18:32:07'),(34,7730,60,40720,40718,757,1522,20,1,219.00,'2022-09-01 18:29:03','2022-09-01 18:32:07','2022-09-01 18:32:07'),(35,7730,61,40720,40718,13,1522,20,2,5295.00,'2022-09-01 18:31:32','2022-09-01 18:51:47','2022-09-01 18:51:47');
INSERT INTO `cta_cte_cliente_details` VALUES (36,7730,61,40720,40718,757,1522,20,1,5295.00,'2022-09-01 18:31:32','2022-09-01 18:51:47','2022-09-01 18:51:47'),(37,7730,62,40720,40718,13,1522,20,2,150.00,'2022-09-01 18:50:21','2022-09-01 18:50:39','2022-09-01 18:50:39'),(38,7730,62,40720,40718,757,1522,20,1,150.00,'2022-09-01 18:50:21','2022-09-01 18:50:39','2022-09-01 18:50:39'),(39,7730,63,40720,40729,13,1522,20,2,5295.00,'2022-09-01 18:56:40','2022-09-02 04:26:39','2022-09-02 04:26:39'),(40,7730,63,40720,40729,757,1522,20,1,5295.00,'2022-09-01 18:56:40','2022-09-02 04:26:39','2022-09-02 04:26:39'),(41,7730,64,40720,40729,13,1522,20,2,150.00,'2022-09-01 19:00:43','2022-09-01 19:27:11','2022-09-01 19:27:11'),(42,7730,64,40720,40729,757,1522,20,1,150.00,'2022-09-01 19:00:43','2022-09-01 19:27:11','2022-09-01 19:27:11'),(43,7730,65,40720,40729,13,1522,20,2,219.00,'2022-09-01 19:28:36','2022-09-02 04:26:35','2022-09-02 04:26:35'),(44,7730,65,40720,40729,757,1522,20,1,219.00,'2022-09-01 19:28:36','2022-09-02 04:26:35','2022-09-02 04:26:35'),(45,7730,66,40720,40731,13,1522,20,2,150.00,'2022-09-01 19:30:20','2022-09-02 04:26:43','2022-09-02 04:26:43'),(46,7730,66,40720,40731,757,1522,20,1,150.00,'2022-09-01 19:30:20','2022-09-02 04:26:43','2022-09-02 04:26:43'),(47,7730,67,40720,40731,13,1522,20,2,150.00,'2022-09-01 19:32:09','2022-09-01 19:32:44','2022-09-01 19:32:44'),(48,7730,67,40720,40731,757,1522,20,1,150.00,'2022-09-01 19:32:09','2022-09-01 19:32:44','2022-09-01 19:32:44'),(49,7730,68,40720,40732,13,1522,20,2,150.00,'2022-09-01 19:34:00','2022-09-02 04:26:47','2022-09-02 04:26:47'),(50,7730,68,40720,40732,757,1522,20,1,150.00,'2022-09-01 19:34:00','2022-09-02 04:26:47','2022-09-02 04:26:47'),(51,7730,69,40720,40733,13,1522,20,2,219.00,'2022-09-01 19:35:26','2022-09-02 04:26:50','2022-09-02 04:26:50'),(52,7730,69,40720,40733,757,1522,20,1,219.00,'2022-09-01 19:35:26','2022-09-02 04:26:50','2022-09-02 04:26:50'),(53,7730,70,40720,40733,13,1522,20,2,1959.00,'2022-09-01 19:36:21','2022-09-01 19:36:31','2022-09-01 19:36:31'),(54,7730,70,40720,40733,757,1522,20,1,1959.00,'2022-09-01 19:36:21','2022-09-01 19:36:31','2022-09-01 19:36:31'),(55,7730,71,40720,40734,13,1522,20,2,1959.00,'2022-09-01 19:37:39','2022-09-02 04:26:54','2022-09-02 04:26:54'),(56,7730,71,40720,40734,757,1522,20,1,1959.00,'2022-09-01 19:37:39','2022-09-02 04:26:54','2022-09-02 04:26:54'),(57,7730,72,40720,40730,13,1522,20,2,11754.01,'2022-09-01 19:38:51','2022-09-02 04:26:58','2022-09-02 04:26:58'),(58,7730,72,40720,40730,757,1522,20,1,11754.01,'2022-09-01 19:38:51','2022-09-02 04:26:58','2022-09-02 04:26:58'),(59,7730,73,40720,40735,13,1522,20,2,150.00,'2022-09-01 19:39:57','2022-09-02 04:27:02','2022-09-02 04:27:02'),(60,7730,73,40720,40735,757,1522,20,1,150.00,'2022-09-01 19:39:57','2022-09-02 04:27:02','2022-09-02 04:27:02'),(61,7730,78,40720,40727,57,1521,21,1,747.66,'2022-09-02 02:26:47','2022-09-02 02:36:33','2022-09-02 02:36:33'),(62,7730,78,40720,40727,757,1521,21,2,747.66,'2022-09-02 02:26:47','2022-09-02 02:36:33','2022-09-02 02:36:33'),(63,7730,91,40720,40721,13,1520,20,2,5272.00,'2022-09-02 04:48:48','2022-09-02 04:48:48',NULL),(64,7730,91,40720,40721,757,1520,20,1,5272.00,'2022-09-02 04:48:48','2022-09-02 04:48:48',NULL),(65,7730,92,40720,40723,13,1521,20,2,4815.00,'2022-09-02 04:50:02','2022-09-02 04:50:02',NULL),(66,7730,92,40720,40723,757,1521,20,1,4815.00,'2022-09-02 04:50:02','2022-09-02 04:50:02',NULL),(67,7730,93,40720,40729,13,1521,20,2,5295.00,'2022-09-02 04:51:17','2022-09-02 05:10:29','2022-09-02 05:10:29'),(68,7730,93,40720,40729,757,1521,20,1,5295.00,'2022-09-02 04:51:17','2022-09-02 05:10:29','2022-09-02 05:10:29'),(69,7730,94,40720,40729,13,1522,20,2,219.00,'2022-09-02 04:52:22','2022-09-02 04:52:22',NULL),(70,7730,94,40720,40729,757,1522,20,1,219.00,'2022-09-02 04:52:22','2022-09-02 04:52:22',NULL),(71,7730,95,40720,40729,13,1522,20,2,150.00,'2022-09-02 04:53:18','2022-09-02 04:53:30','2022-09-02 04:53:30');
INSERT INTO `cta_cte_cliente_details` VALUES (72,7730,95,40720,40729,757,1522,20,1,150.00,'2022-09-02 04:53:18','2022-09-02 04:53:30','2022-09-02 04:53:30'),(73,7730,96,40720,40731,13,1522,20,2,150.00,'2022-09-02 04:54:33','2022-09-02 04:54:33',NULL),(74,7730,96,40720,40731,757,1522,20,1,150.00,'2022-09-02 04:54:33','2022-09-02 04:54:33',NULL),(75,7730,97,40720,40732,13,1522,20,2,150.00,'2022-09-02 04:55:29','2022-09-02 04:55:29',NULL),(76,7730,97,40720,40732,757,1522,20,1,150.00,'2022-09-02 04:55:29','2022-09-02 04:55:29',NULL),(77,7730,98,40720,40733,13,1522,20,2,219.00,'2022-09-02 04:56:45','2022-09-02 04:56:45',NULL),(78,7730,98,40720,40733,757,1522,20,1,219.00,'2022-09-02 04:56:45','2022-09-02 04:56:45',NULL),(79,7730,99,40720,40734,13,1522,20,2,1959.00,'2022-09-02 04:57:54','2022-09-02 04:57:54',NULL),(80,7730,99,40720,40734,757,1522,20,1,1959.00,'2022-09-02 04:57:54','2022-09-02 04:57:54',NULL),(81,7730,100,40720,40730,13,1522,20,2,11754.01,'2022-09-02 04:58:54','2022-09-04 02:28:22','2022-09-04 02:28:22'),(82,7730,100,40720,40730,757,1522,20,1,11754.01,'2022-09-02 04:58:54','2022-09-04 02:28:22','2022-09-04 02:28:22'),(83,7730,101,40720,40735,13,1522,20,2,150.00,'2022-09-02 04:59:43','2022-09-04 02:28:10','2022-09-04 02:28:10'),(84,7730,101,40720,40735,757,1522,20,1,150.00,'2022-09-02 04:59:43','2022-09-04 02:28:10','2022-09-04 02:28:10'),(85,7730,102,40720,40729,13,1522,20,2,5295.00,'2022-09-02 05:11:36','2022-09-02 05:11:36',NULL),(86,7730,102,40720,40729,757,1522,20,1,5295.00,'2022-09-02 05:11:36','2022-09-02 05:11:36',NULL),(87,7730,103,40720,40727,57,1522,21,1,1346.89,'2022-09-03 23:06:29','2022-09-03 23:06:29',NULL),(88,7730,103,40720,40727,757,1522,21,2,1346.89,'2022-09-03 23:06:29','2022-09-03 23:06:29',NULL),(89,7730,106,40720,40730,13,1522,20,2,11754.01,'2022-09-04 02:30:53','2022-09-04 02:30:53',NULL),(90,7730,106,40720,40730,757,1522,20,1,11754.01,'2022-09-04 02:30:53','2022-09-04 02:30:53',NULL),(91,7730,107,40720,40735,13,1522,20,2,150.00,'2022-09-04 02:32:18','2022-09-04 02:32:18',NULL),(92,7730,107,40720,40735,757,1522,20,1,150.00,'2022-09-04 02:32:18','2022-09-04 02:32:18',NULL),(93,7730,166,40720,40736,13,1523,20,2,7238.99,'2022-09-04 04:29:57','2022-09-04 04:29:57',NULL),(94,7730,166,40720,40736,757,1523,20,1,7238.99,'2022-09-04 04:29:57','2022-09-04 04:29:57',NULL),(95,7730,167,40720,40737,13,1523,20,2,7238.99,'2022-09-04 04:31:28','2022-09-04 04:31:28',NULL),(96,7730,167,40720,40737,757,1523,20,1,7238.99,'2022-09-04 04:31:28','2022-09-04 04:31:28',NULL),(97,7730,168,40720,40738,13,1523,20,2,7238.99,'2022-09-04 04:37:21','2022-09-04 04:37:21',NULL),(98,7730,168,40720,40738,757,1523,20,1,7238.99,'2022-09-04 04:37:21','2022-09-04 04:37:21',NULL),(99,7730,169,40720,40739,13,1523,20,2,14478.00,'2022-09-04 04:38:26','2022-09-04 04:38:26',NULL),(100,7730,169,40720,40739,757,1523,20,1,14478.00,'2022-09-04 04:38:26','2022-09-04 04:38:26',NULL),(101,7730,170,40720,40741,13,1523,20,2,8685.00,'2022-09-04 04:39:39','2022-09-04 04:39:39',NULL),(102,7730,170,40720,40741,757,1523,20,1,8685.00,'2022-09-04 04:39:39','2022-09-04 04:39:39',NULL),(103,7730,171,40720,40740,13,1523,20,2,7238.99,'2022-09-04 04:40:44','2022-09-04 04:40:44',NULL),(104,7730,171,40720,40740,757,1523,20,1,7238.99,'2022-09-04 04:40:44','2022-09-04 04:40:44',NULL),(105,7730,172,40720,40742,13,1523,20,2,7238.99,'2022-09-04 04:42:14','2022-09-04 04:42:14',NULL),(106,7730,172,40720,40742,757,1523,20,1,7238.99,'2022-09-04 04:42:14','2022-09-04 04:42:14',NULL),(107,7730,173,40720,40743,13,1523,20,2,7238.99,'2022-09-04 04:43:40','2022-09-04 04:43:40',NULL),(108,7730,173,40720,40743,757,1523,20,1,7238.99,'2022-09-04 04:43:40','2022-09-04 04:43:40',NULL),(109,7730,174,40720,40744,13,1523,20,2,7238.99,'2022-09-04 04:44:24','2022-09-04 04:44:24',NULL),(110,7730,174,40720,40744,757,1523,20,1,7238.99,'2022-09-04 04:44:24','2022-09-04 04:44:24',NULL),(111,7730,175,40720,40746,13,1523,20,2,7238.99,'2022-09-04 04:45:26','2022-09-04 04:45:26',NULL);
INSERT INTO `cta_cte_cliente_details` VALUES (112,7730,175,40720,40746,757,1523,20,1,7238.99,'2022-09-04 04:45:26','2022-09-04 04:45:26',NULL),(113,7730,177,40720,40748,13,1523,20,2,7238.99,'2022-09-04 04:47:59','2022-09-04 04:47:59',NULL),(114,7730,177,40720,40748,757,1523,20,1,7238.99,'2022-09-04 04:47:59','2022-09-04 04:47:59',NULL),(115,7730,178,40720,40749,13,1523,20,2,7238.99,'2022-09-04 04:48:58','2022-09-04 04:48:58',NULL),(116,7730,178,40720,40749,757,1523,20,1,7238.99,'2022-09-04 04:48:58','2022-09-04 04:48:58',NULL),(117,7730,179,40720,40750,13,1523,20,2,7238.99,'2022-09-04 04:50:16','2022-09-04 04:50:16',NULL),(118,7730,179,40720,40750,757,1523,20,1,7238.99,'2022-09-04 04:50:16','2022-09-04 04:50:16',NULL),(119,7730,180,40720,40751,13,1523,20,2,7238.99,'2022-09-04 04:51:10','2022-09-04 04:51:10',NULL),(120,7730,180,40720,40751,757,1523,20,1,7238.99,'2022-09-04 04:51:10','2022-09-04 04:51:10',NULL),(121,7730,181,40720,40755,13,1523,20,2,8685.00,'2022-09-04 04:52:07','2022-09-04 04:52:07',NULL),(122,7730,181,40720,40755,757,1523,20,1,8685.00,'2022-09-04 04:52:07','2022-09-04 04:52:07',NULL),(123,7730,182,40720,40752,13,1523,20,2,7238.99,'2022-09-04 04:53:16','2022-09-04 04:53:16',NULL),(124,7730,182,40720,40752,757,1523,20,1,7238.99,'2022-09-04 04:53:16','2022-09-04 04:53:16',NULL),(125,7730,183,40720,40753,13,1523,20,2,7238.99,'2022-09-04 04:54:08','2022-09-04 04:54:08',NULL),(126,7730,183,40720,40753,757,1523,20,1,7238.99,'2022-09-04 04:54:08','2022-09-04 04:54:08',NULL),(127,7730,184,40720,40754,13,1523,20,2,7238.99,'2022-09-04 04:55:06','2022-09-04 04:55:06',NULL),(128,7730,184,40720,40754,757,1523,20,1,7238.99,'2022-09-04 04:55:06','2022-09-04 04:55:06',NULL),(129,7730,185,40720,40756,13,1523,20,2,7238.99,'2022-09-04 04:56:15','2022-09-04 04:56:15',NULL),(130,7730,185,40720,40756,757,1523,20,1,7238.99,'2022-09-04 04:56:15','2022-09-04 04:56:15',NULL),(131,7730,186,40720,40745,13,1523,20,2,8685.00,'2022-09-04 04:57:04','2022-09-04 04:57:04',NULL),(132,7730,186,40720,40745,757,1523,20,1,8685.00,'2022-09-04 04:57:04','2022-09-04 04:57:04',NULL),(133,7730,187,40720,40747,13,1523,20,2,4955.00,'2022-09-04 04:57:56','2022-09-04 04:57:56',NULL),(134,7730,187,40720,40747,757,1523,20,1,4955.00,'2022-09-04 04:57:56','2022-09-04 04:57:56',NULL),(135,7730,188,40720,40752,13,1523,20,2,3880.00,'2022-09-04 04:58:49','2022-09-04 04:58:49',NULL),(136,7730,188,40720,40752,757,1523,20,1,3880.00,'2022-09-04 04:58:49','2022-09-04 04:58:49',NULL),(137,7730,189,40720,40757,13,1523,20,2,14478.00,'2022-09-04 04:59:44','2022-09-04 04:59:44',NULL),(138,7730,189,40720,40757,757,1523,20,1,14478.00,'2022-09-04 04:59:44','2022-09-04 04:59:44',NULL),(139,7730,190,40720,40758,13,1523,20,2,7238.99,'2022-09-04 05:00:55','2022-09-04 05:00:55',NULL),(140,7730,190,40720,40758,757,1523,20,1,7238.99,'2022-09-04 05:00:55','2022-09-04 05:00:55',NULL),(141,7730,191,40720,40759,13,1523,20,2,7971.00,'2022-09-04 05:01:50','2022-09-04 05:01:50',NULL),(142,7730,191,40720,40759,757,1523,20,1,7971.00,'2022-09-04 05:01:50','2022-09-04 05:01:50',NULL),(143,7730,192,40720,40760,13,1523,20,2,7238.99,'2022-09-04 05:02:47','2022-09-04 05:02:47',NULL),(144,7730,192,40720,40760,757,1523,20,1,7238.99,'2022-09-04 05:02:47','2022-09-04 05:02:47',NULL),(145,7730,206,40720,40727,57,1523,21,1,17067.75,'2022-09-04 05:23:20','2022-09-04 05:23:20',NULL),(146,7730,206,40720,40727,757,1523,21,2,17067.75,'2022-09-04 05:23:20','2022-09-04 05:23:20',NULL),(147,7730,208,40720,40762,57,1523,21,1,20000.00,'2022-09-04 05:34:03','2022-09-04 05:34:03',NULL),(148,7730,208,40720,40762,758,1523,21,2,20000.00,'2022-09-04 05:34:03','2022-09-04 05:34:03',NULL),(149,7730,372,40720,40731,13,1525,20,2,150.00,'2023-03-27 15:56:08','2023-03-27 15:56:08',NULL),(150,7730,372,40720,40731,759,1525,20,1,150.00,'2023-03-27 15:56:08','2023-03-27 15:56:08',NULL),(151,7730,373,40720,40733,13,1525,20,2,949.00,'2023-03-27 15:58:45','2023-03-27 15:58:45',NULL),(152,7730,373,40720,40733,759,1525,20,1,949.00,'2023-03-27 15:58:45','2023-03-27 15:58:45',NULL);
INSERT INTO `cta_cte_cliente_details` VALUES (153,7730,374,40720,40765,13,1525,20,2,8090.00,'2023-03-27 16:00:34','2023-03-27 16:00:34',NULL),(154,7730,374,40720,40765,759,1525,20,1,8090.00,'2023-03-27 16:00:34','2023-03-27 16:00:34',NULL),(155,7730,375,40720,40766,13,1525,20,2,7590.00,'2023-03-27 16:02:07','2023-03-27 16:02:07',NULL),(156,7730,375,40720,40766,759,1525,20,1,7590.00,'2023-03-27 16:02:07','2023-03-27 16:02:07',NULL),(157,7730,376,40720,40767,13,1525,20,2,9090.00,'2023-03-27 16:03:07','2023-03-27 16:03:07',NULL),(158,7730,376,40720,40767,759,1525,20,1,9090.00,'2023-03-27 16:03:07','2023-03-27 16:03:07',NULL),(159,7730,377,40720,40768,13,1525,20,2,19470.00,'2023-03-27 16:03:59','2023-03-27 16:03:59',NULL),(160,7730,377,40720,40768,759,1525,20,1,19470.00,'2023-03-27 16:03:59','2023-03-27 16:03:59',NULL),(161,7730,378,40720,40769,13,1525,20,2,150.00,'2023-03-27 16:05:00','2023-03-27 16:05:00',NULL),(162,7730,378,40720,40769,759,1525,20,1,150.00,'2023-03-27 16:05:00','2023-03-27 16:05:00',NULL),(163,7730,379,40720,40770,13,1525,20,2,7590.00,'2023-03-27 16:06:03','2023-03-27 16:06:03',NULL),(164,7730,379,40720,40770,759,1525,20,1,7590.00,'2023-03-27 16:06:03','2023-03-27 16:06:03',NULL),(165,7730,380,40720,40771,13,1525,20,2,150.00,'2023-03-27 16:06:54','2023-03-27 16:06:54',NULL),(166,7730,380,40720,40771,759,1525,20,1,150.00,'2023-03-27 16:06:54','2023-03-27 16:06:54',NULL),(167,7730,381,40720,40772,13,1525,20,2,150.00,'2023-03-27 16:07:35','2023-03-27 16:07:35',NULL),(168,7730,381,40720,40772,759,1525,20,1,150.00,'2023-03-27 16:07:35','2023-03-27 16:07:35',NULL),(169,7730,382,40720,40773,13,1525,20,2,150.00,'2023-03-27 16:08:33','2023-03-27 16:08:33',NULL),(170,7730,382,40720,40773,759,1525,20,1,150.00,'2023-03-27 16:08:33','2023-03-27 16:08:33',NULL),(171,7730,383,40720,40774,13,1525,20,2,7590.00,'2023-03-27 16:09:12','2023-03-27 16:09:12',NULL),(172,7730,383,40720,40774,759,1525,20,1,7590.00,'2023-03-27 16:09:12','2023-03-27 16:09:12',NULL),(173,7730,384,40720,40775,13,1525,20,2,150.00,'2023-03-27 16:09:56','2023-03-27 16:09:56',NULL),(174,7730,384,40720,40775,759,1525,20,1,150.00,'2023-03-27 16:09:56','2023-03-27 16:09:56',NULL),(175,7730,385,40720,40776,13,1525,20,2,150.00,'2023-03-27 16:11:16','2023-03-27 16:11:16',NULL),(176,7730,385,40720,40776,759,1525,20,1,150.00,'2023-03-27 16:11:16','2023-03-27 16:11:16',NULL),(177,7730,386,40720,40777,13,1525,20,2,150.00,'2023-03-27 16:11:52','2023-03-27 16:11:52',NULL),(178,7730,386,40720,40777,759,1525,20,1,150.00,'2023-03-27 16:11:52','2023-03-27 16:11:52',NULL),(179,7730,387,40720,40778,13,1525,20,2,150.00,'2023-03-27 16:12:34','2023-03-27 16:12:34',NULL),(180,7730,387,40720,40778,759,1525,20,1,150.00,'2023-03-27 16:12:34','2023-03-27 16:12:34',NULL),(181,7730,388,40720,40779,13,1525,20,2,1379.00,'2023-03-27 16:13:20','2023-03-27 16:13:20',NULL),(182,7730,388,40720,40779,759,1525,20,1,1379.00,'2023-03-27 16:13:20','2023-03-27 16:13:20',NULL),(183,7730,389,40720,40780,13,1525,20,2,7590.00,'2023-03-27 16:14:22','2023-03-27 16:14:22',NULL),(184,7730,389,40720,40780,759,1525,20,1,7590.00,'2023-03-27 16:14:22','2023-03-27 16:14:22',NULL),(185,7730,390,40720,40781,13,1525,20,2,7819.00,'2023-03-27 16:16:08','2023-03-27 16:16:08',NULL),(186,7730,390,40720,40781,759,1525,20,1,7819.00,'2023-03-27 16:16:08','2023-03-27 16:16:08',NULL),(187,7730,391,40720,40781,13,1525,20,2,6490.00,'2023-03-27 16:17:14','2023-03-27 16:17:14',NULL),(188,7730,391,40720,40781,759,1525,20,1,6490.00,'2023-03-27 16:17:14','2023-03-27 16:17:14',NULL),(189,7730,392,40720,40782,13,1525,20,2,6490.00,'2023-03-27 16:18:43','2023-03-27 16:18:43',NULL),(190,7730,392,40720,40782,759,1525,20,1,6490.00,'2023-03-27 16:18:43','2023-03-27 16:18:43',NULL),(191,7730,393,40720,40783,13,1525,20,2,6490.00,'2023-03-27 16:19:37','2023-03-27 16:19:37',NULL),(192,7730,393,40720,40783,759,1525,20,1,6490.00,'2023-03-27 16:19:37','2023-03-27 16:19:37',NULL),(193,7730,394,40720,40784,13,1525,20,2,8685.00,'2023-03-27 16:20:30','2023-03-27 16:20:30',NULL);
INSERT INTO `cta_cte_cliente_details` VALUES (194,7730,394,40720,40784,759,1525,20,1,8685.00,'2023-03-27 16:20:30','2023-03-27 16:20:30',NULL),(195,7730,395,40720,40785,13,1525,20,2,8685.00,'2023-03-27 16:21:24','2023-03-27 16:21:24',NULL),(196,7730,395,40720,40785,759,1525,20,1,8685.00,'2023-03-27 16:21:24','2023-03-27 16:21:24',NULL),(197,7730,396,40720,40786,13,1525,20,2,300.00,'2023-03-27 16:30:20','2023-03-27 16:30:20',NULL),(198,7730,396,40720,40786,759,1525,20,1,300.00,'2023-03-27 16:30:20','2023-03-27 16:30:20',NULL),(199,7730,397,40720,40787,13,1525,20,2,7590.00,'2023-03-27 16:31:13','2023-03-27 16:31:13',NULL),(200,7730,397,40720,40787,759,1525,20,1,7590.00,'2023-03-27 16:31:13','2023-03-27 16:31:13',NULL),(201,7730,398,40720,40788,13,1525,20,2,6490.00,'2023-03-27 16:32:13','2023-03-27 16:32:13',NULL),(202,7730,398,40720,40788,759,1525,20,1,6490.00,'2023-03-27 16:32:13','2023-03-27 16:32:13',NULL),(203,7730,399,40720,40789,13,1525,20,2,8685.00,'2023-03-27 16:33:00','2023-03-27 16:33:00',NULL),(204,7730,399,40720,40789,759,1525,20,1,8685.00,'2023-03-27 16:33:00','2023-03-27 16:33:00',NULL),(205,7730,400,40720,40790,13,1525,20,2,6490.00,'2023-03-27 16:33:48','2023-03-27 16:33:48',NULL),(206,7730,400,40720,40790,759,1525,20,1,6490.00,'2023-03-27 16:33:48','2023-03-27 16:33:48',NULL),(207,7730,401,40720,40792,13,1525,20,2,6490.00,'2023-03-27 16:34:55','2023-03-27 16:34:55',NULL),(208,7730,401,40720,40792,759,1525,20,1,6490.00,'2023-03-27 16:34:55','2023-03-27 16:34:55',NULL),(209,7730,402,40720,40793,13,1525,20,2,6490.00,'2023-03-27 16:38:54','2023-03-27 16:38:54',NULL),(210,7730,402,40720,40793,759,1525,20,1,6490.00,'2023-03-27 16:38:54','2023-03-27 16:38:54',NULL),(211,7730,403,40720,40794,13,1525,20,2,8685.00,'2023-03-27 16:39:47','2023-03-27 16:39:47',NULL),(212,7730,403,40720,40794,759,1525,20,1,8685.00,'2023-03-27 16:39:47','2023-03-27 16:39:47',NULL),(213,7730,404,40720,40795,13,1525,20,2,7590.00,'2023-03-27 16:40:40','2023-03-27 16:40:40',NULL),(214,7730,404,40720,40795,759,1525,20,1,7590.00,'2023-03-27 16:40:40','2023-03-27 16:40:40',NULL),(215,7730,405,40720,40796,13,1525,20,2,150.00,'2023-03-27 16:43:44','2023-03-27 16:43:44',NULL),(216,7730,405,40720,40796,759,1525,20,1,150.00,'2023-03-27 16:43:44','2023-03-27 16:43:44',NULL),(217,7730,406,40720,40797,13,1525,20,2,6799.00,'2023-03-27 16:45:38','2023-03-27 16:45:38',NULL),(218,7730,406,40720,40797,759,1525,20,1,6799.00,'2023-03-27 16:45:38','2023-03-27 16:45:38',NULL),(219,7730,407,40720,40797,13,1525,20,2,40794.00,'2023-03-27 16:47:49','2023-03-27 16:47:49',NULL),(220,7730,407,40720,40797,758,1525,20,1,40794.00,'2023-03-27 16:47:49','2023-03-27 16:47:49',NULL),(221,7730,408,40720,40764,13,1525,20,2,150.00,'2023-03-27 16:54:51','2023-03-27 16:54:51',NULL),(222,7730,408,40720,40764,759,1525,20,1,150.00,'2023-03-27 16:54:51','2023-03-27 16:54:51',NULL),(223,7730,409,40720,40724,57,1525,21,1,36966.12,'2023-03-27 18:30:31','2023-03-28 17:17:32','2023-03-28 17:17:32'),(224,7730,409,40720,40724,758,1525,21,2,36966.12,'2023-03-27 18:30:31','2023-03-28 17:17:32','2023-03-28 17:17:32'),(225,7730,410,40720,40764,57,1525,21,1,137498.23,'2023-03-27 18:58:21','2023-03-27 18:58:21',NULL),(226,7730,410,40720,40764,758,1525,21,2,137498.23,'2023-03-27 18:58:21','2023-03-27 18:58:21',NULL),(227,7730,412,40720,40727,57,1525,21,1,40365.09,'2023-03-28 12:20:13','2023-03-28 13:21:24','2023-03-28 13:21:24'),(228,7730,412,40720,40727,759,1525,21,2,40365.09,'2023-03-28 12:20:13','2023-03-28 13:21:24','2023-03-28 13:21:24'),(229,7730,413,40720,40728,57,1525,21,1,1206.09,'2023-03-28 12:22:21','2023-03-28 12:42:47','2023-03-28 12:42:47'),(230,7730,413,40720,40728,759,1525,21,2,1206.09,'2023-03-28 12:22:21','2023-03-28 12:42:47','2023-03-28 12:42:47'),(231,7730,414,40720,40798,57,1525,21,1,3298.43,'2023-03-28 12:24:10','2023-03-28 12:24:10',NULL),(232,7730,414,40720,40798,759,1525,21,2,3298.43,'2023-03-28 12:24:10','2023-03-28 12:24:10',NULL);
INSERT INTO `cta_cte_cliente_details` VALUES (233,7730,415,40720,40762,57,1525,21,1,20000.00,'2023-03-28 12:40:44','2023-03-28 12:40:44',NULL),(234,7730,415,40720,40762,758,1525,21,2,20000.00,'2023-03-28 12:40:44','2023-03-28 12:40:44',NULL),(235,7730,416,40720,40728,57,1525,21,1,1206.09,'2023-03-28 12:46:41','2023-03-28 12:46:41',NULL),(236,7730,416,40720,40728,759,1525,21,2,1206.09,'2023-03-28 12:46:41','2023-03-28 12:46:41',NULL),(237,7730,421,40720,40727,57,1525,21,1,40365.09,'2023-03-28 13:26:34','2023-03-28 14:25:03','2023-03-28 14:25:03'),(238,7730,421,40720,40727,759,1525,21,2,40365.09,'2023-03-28 13:26:34','2023-03-28 14:25:03','2023-03-28 14:25:03'),(239,7730,423,40720,40727,57,1525,21,1,39160.19,'2023-03-28 14:38:52','2023-03-28 14:38:52',NULL),(240,7730,423,40720,40727,759,1525,21,2,39160.19,'2023-03-28 14:38:52','2023-03-28 14:38:52',NULL),(241,7730,470,40720,40799,13,1526,20,2,9990.00,'2023-03-28 15:45:24','2023-03-28 15:45:24',NULL),(242,7730,470,40720,40799,759,1526,20,1,9990.00,'2023-03-28 15:45:24','2023-03-28 15:45:24',NULL),(243,7730,471,40720,40800,13,1526,20,2,7919.00,'2023-03-28 15:49:20','2023-03-28 15:49:20',NULL),(244,7730,471,40720,40800,759,1526,20,1,7919.00,'2023-03-28 15:49:20','2023-03-28 15:49:20',NULL),(245,7730,472,40720,40801,13,1526,20,2,8557.00,'2023-03-28 15:50:10','2023-03-28 15:50:10',NULL),(246,7730,472,40720,40801,759,1526,20,1,8557.00,'2023-03-28 15:50:10','2023-03-28 15:50:10',NULL),(247,7730,473,40720,40802,13,1526,20,2,12980.00,'2023-03-28 15:51:22','2023-03-28 15:51:22',NULL),(248,7730,473,40720,40802,759,1526,20,1,12980.00,'2023-03-28 15:51:22','2023-03-28 15:51:22',NULL),(249,7730,474,40720,40803,13,1526,20,2,7590.00,'2023-03-28 15:52:07','2023-03-28 15:52:07',NULL),(250,7730,474,40720,40803,759,1526,20,1,7590.00,'2023-03-28 15:52:07','2023-03-28 15:52:07',NULL),(251,7730,475,40720,40804,13,1526,20,2,9990.00,'2023-03-28 15:52:50','2023-03-28 15:52:50',NULL),(252,7730,475,40720,40804,759,1526,20,1,9990.00,'2023-03-28 15:52:50','2023-03-28 15:52:50',NULL),(253,7730,476,40720,40805,13,1526,20,2,9990.00,'2023-03-28 15:53:55','2023-03-28 15:53:55',NULL),(254,7730,476,40720,40805,759,1526,20,1,9990.00,'2023-03-28 15:53:55','2023-03-28 15:53:55',NULL),(255,7730,477,40720,40807,13,1526,20,2,9990.00,'2023-03-28 15:54:34','2023-03-28 15:54:34',NULL),(256,7730,477,40720,40807,759,1526,20,1,9990.00,'2023-03-28 15:54:34','2023-03-28 15:54:34',NULL),(257,7730,478,40720,40808,13,1526,20,2,27770.00,'2023-03-28 15:55:24','2023-03-28 15:55:24',NULL),(258,7730,478,40720,40808,759,1526,20,1,27770.00,'2023-03-28 15:55:24','2023-03-28 15:55:24',NULL),(259,7730,479,40720,40809,13,1526,20,2,7919.00,'2023-03-28 15:56:05','2023-03-28 15:56:05',NULL),(260,7730,479,40720,40809,759,1526,20,1,7919.00,'2023-03-28 15:56:05','2023-03-28 15:56:05',NULL),(261,7730,480,40720,40811,13,1526,20,2,9990.00,'2023-03-28 15:56:48','2023-03-28 15:56:48',NULL),(262,7730,480,40720,40811,759,1526,20,1,9990.00,'2023-03-28 15:56:48','2023-03-28 15:56:48',NULL),(263,7730,481,40720,40813,13,1526,20,2,3400.00,'2023-03-28 15:57:28','2023-03-28 15:57:28',NULL),(264,7730,481,40720,40813,759,1526,20,1,3400.00,'2023-03-28 15:57:28','2023-03-28 15:57:28',NULL),(265,7730,482,40720,40814,13,1526,20,2,12740.00,'2023-03-28 16:00:04','2023-03-28 16:00:04',NULL),(266,7730,482,40720,40814,759,1526,20,1,12740.00,'2023-03-28 16:00:04','2023-03-28 16:00:04',NULL),(267,7730,483,40720,40815,13,1526,20,2,9990.00,'2023-03-28 16:00:52','2023-03-28 16:00:52',NULL),(268,7730,483,40720,40815,759,1526,20,1,9990.00,'2023-03-28 16:00:52','2023-03-28 16:00:52',NULL),(269,7730,484,40720,40810,13,1526,20,2,7990.00,'2023-03-28 16:01:53','2023-03-28 16:01:53',NULL),(270,7730,484,40720,40810,759,1526,20,1,7990.00,'2023-03-28 16:01:53','2023-03-28 16:01:53',NULL),(271,7730,485,40720,40816,13,1526,20,2,9490.50,'2023-03-28 16:02:38','2023-03-28 16:02:38',NULL),(272,7730,485,40720,40816,759,1526,20,1,9490.50,'2023-03-28 16:02:38','2023-03-28 16:02:38',NULL);
INSERT INTO `cta_cte_cliente_details` VALUES (273,7730,486,40720,40806,13,1526,20,2,17780.00,'2023-03-28 16:03:43','2023-03-28 16:03:43',NULL),(274,7730,486,40720,40806,759,1526,20,1,17780.00,'2023-03-28 16:03:43','2023-03-28 16:03:43',NULL),(275,7730,487,40720,40812,13,1526,20,2,7990.00,'2023-03-28 16:04:41','2023-03-28 16:04:41',NULL),(276,7730,487,40720,40812,759,1526,20,1,7990.00,'2023-03-28 16:04:41','2023-03-28 16:04:41',NULL),(277,7730,505,40720,40727,57,1526,21,1,42059.18,'2023-03-28 16:17:50','2023-03-28 16:17:50',NULL),(278,7730,505,40720,40727,759,1526,21,2,42059.18,'2023-03-28 16:17:50','2023-03-28 16:17:50',NULL),(279,7730,506,40720,40762,57,1526,21,1,20000.00,'2023-03-28 16:20:44','2023-03-28 16:20:44',NULL),(280,7730,506,40720,40762,760,1526,21,2,20000.00,'2023-03-28 16:20:44','2023-03-28 16:20:44',NULL),(281,7730,507,40720,40728,13,1526,20,2,1206.09,'2023-03-28 16:21:40','2023-03-28 16:45:54','2023-03-28 16:45:54'),(282,7730,507,40720,40728,759,1526,20,1,1206.09,'2023-03-28 16:21:40','2023-03-28 16:45:54','2023-03-28 16:45:54'),(283,7730,508,40720,40728,57,1526,21,1,1206.09,'2023-03-28 16:46:32','2023-03-28 16:46:32',NULL),(284,7730,508,40720,40728,759,1526,21,2,1206.09,'2023-03-28 16:46:32','2023-03-28 16:46:32',NULL),(285,7730,509,40720,40724,57,1525,21,1,50000.00,'2023-03-28 17:19:46','2023-03-28 17:19:46',NULL),(286,7730,509,40720,40724,758,1525,21,2,50000.00,'2023-03-28 17:19:46','2023-03-28 17:19:46',NULL),(287,7730,510,40720,40724,57,1526,21,1,90000.00,'2023-03-28 17:23:20','2023-03-28 17:23:20',NULL),(288,7730,510,40720,40724,758,1526,21,2,90000.00,'2023-03-28 17:23:20','2023-03-28 17:23:20',NULL),(289,7730,534,40720,40817,13,1527,20,2,8800.00,'2023-03-29 10:50:15','2023-03-29 10:50:15',NULL),(290,7730,534,40720,40817,759,1527,20,1,8800.00,'2023-03-29 10:50:15','2023-03-29 10:50:15',NULL),(291,7730,535,40720,40819,13,1527,20,2,7990.00,'2023-03-29 10:53:20','2023-03-29 10:53:20',NULL),(292,7730,535,40720,40819,759,1527,20,1,7990.00,'2023-03-29 10:53:20','2023-03-29 10:53:20',NULL),(293,7730,536,40720,40818,13,1527,20,2,2397.00,'2023-03-29 11:05:46','2023-03-29 11:05:46',NULL),(294,7730,536,40720,40818,759,1527,20,1,2397.00,'2023-03-29 11:05:46','2023-03-29 11:05:46',NULL),(295,7730,538,40720,40820,13,1527,20,2,7830.00,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(296,7730,538,40720,40820,759,1527,20,1,7830.00,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(297,7730,540,40720,40820,13,1527,20,2,1500.00,'2023-03-29 11:23:16','2023-03-29 11:23:16',NULL),(298,7730,540,40720,40820,759,1527,20,1,1500.00,'2023-03-29 11:23:16','2023-03-29 11:23:16',NULL),(299,7730,542,40720,40820,13,1527,20,2,7990.00,'2023-03-29 11:23:50','2023-03-29 11:23:50',NULL),(300,7730,542,40720,40820,759,1527,20,1,7990.00,'2023-03-29 11:23:50','2023-03-29 11:23:50',NULL),(301,7730,568,40720,40762,57,1527,21,1,20000.00,'2023-03-29 13:07:13','2023-03-29 13:07:13',NULL),(302,7730,568,40720,40762,760,1527,21,2,20000.00,'2023-03-29 13:07:13','2023-03-29 13:07:13',NULL),(303,7730,570,40720,40727,57,1527,21,1,31867.42,'2023-03-29 13:07:54','2023-03-29 13:07:54',NULL),(304,7730,570,40720,40727,759,1527,21,2,31867.42,'2023-03-29 13:07:54','2023-03-29 13:07:54',NULL),(305,7730,572,40720,40724,57,1527,21,1,11721.00,'2023-03-29 13:09:36','2023-03-29 13:09:36',NULL),(306,7730,572,40720,40724,759,1527,21,2,11721.00,'2023-03-29 13:09:36','2023-03-29 13:09:36',NULL),(307,7730,574,40720,40764,57,1527,21,1,67248.27,'2023-03-29 13:12:50','2023-03-29 13:19:28','2023-03-29 13:19:28'),(308,7730,574,40720,40764,759,1527,21,2,67248.27,'2023-03-29 13:12:50','2023-03-29 13:19:28','2023-03-29 13:19:28'),(309,7730,576,40720,40728,57,1527,21,1,1206.09,'2023-03-29 13:14:05','2023-03-29 14:54:23','2023-03-29 14:54:23'),(310,7730,576,40720,40728,759,1527,21,2,1206.09,'2023-03-29 13:14:05','2023-03-29 14:54:23','2023-03-29 14:54:23'),(311,7730,578,40720,40764,57,1527,21,1,67248.27,'2023-03-29 13:21:21','2023-03-29 13:21:21',NULL);
INSERT INTO `cta_cte_cliente_details` VALUES (312,7730,578,40720,40764,760,1527,21,2,67248.27,'2023-03-29 13:21:21','2023-03-29 13:21:21',NULL),(313,7730,580,40720,40763,57,1525,21,1,1513750.00,'2023-03-29 13:30:40','2023-03-29 14:02:04','2023-03-29 14:02:04'),(314,7730,580,40720,40763,760,1525,21,2,1513750.00,'2023-03-29 13:30:40','2023-03-29 14:02:04','2023-03-29 14:02:04'),(315,7730,582,40720,40728,57,1527,21,1,1206.09,'2023-03-29 14:56:01','2023-03-29 14:56:01',NULL),(316,7730,582,40720,40728,759,1527,21,2,1206.09,'2023-03-29 14:56:01','2023-03-29 14:56:01',NULL),(317,7730,585,40720,40728,57,1528,21,1,1206.09,'2023-03-29 17:36:56','2023-03-29 18:41:50','2023-03-29 18:41:50'),(318,7730,585,40720,40728,759,1528,21,2,1206.09,'2023-03-29 17:36:56','2023-03-29 18:41:50','2023-03-29 18:41:50'),(319,7730,588,40720,40728,57,1529,21,1,1206.09,'2023-03-29 18:42:54','2023-03-29 18:42:54',NULL),(320,7730,588,40720,40728,759,1529,21,2,1206.09,'2023-03-29 18:42:54','2023-03-29 18:42:54',NULL),(321,7730,592,40720,40728,57,1530,21,1,261.88,'2023-03-29 20:05:20','2023-03-29 20:05:20',NULL),(322,7730,592,40720,40728,759,1530,21,2,261.88,'2023-03-29 20:05:20','2023-03-29 20:05:20',NULL),(323,7730,596,40720,40728,57,1531,21,1,1528.76,'2023-03-29 20:20:24','2023-03-29 20:20:24',NULL),(324,7730,596,40720,40728,759,1531,21,2,1528.76,'2023-03-29 20:20:24','2023-03-29 20:20:24',NULL),(325,7730,597,40720,40728,57,1532,21,1,366.63,'2023-03-29 20:37:23','2023-03-29 20:37:23',NULL),(326,7730,597,40720,40728,759,1532,21,2,366.63,'2023-03-29 20:37:23','2023-03-29 20:37:23',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=611 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,7730,1,1,NULL,'2022-08-28 13:01:48','2022-08-28 13:04:51','2022-08-28 13:04:51'),(2,7730,2,1,NULL,'2022-08-28 13:04:51','2022-08-28 13:05:09','2022-08-28 13:05:09'),(3,7730,3,1,NULL,'2022-08-28 13:05:09','2022-08-28 13:13:02','2022-08-28 13:13:02'),(4,7730,4,1,NULL,'2022-08-28 13:13:02','2022-08-28 18:21:56','2022-08-28 18:21:56'),(5,7730,8,1,NULL,'2022-08-28 18:21:56','2022-08-28 18:21:56',NULL),(6,7730,9,2,NULL,'2022-08-28 20:41:57','2022-08-28 20:41:57',NULL),(7,7730,10,3,NULL,'2022-08-28 23:35:04','2022-09-02 04:23:51','2022-09-02 04:23:51'),(8,7730,13,4,NULL,'2022-08-29 00:23:21','2022-08-29 00:27:06','2022-08-29 00:27:06'),(9,7730,14,4,NULL,'2022-08-29 00:27:06','2022-09-02 04:24:05','2022-09-02 04:24:05'),(10,7730,16,5,NULL,'2022-08-29 00:44:09','2022-08-29 01:44:34','2022-08-29 01:44:34'),(11,7730,17,6,NULL,'2022-08-29 00:44:09','2022-08-29 00:44:09',NULL),(12,7730,18,7,NULL,'2022-08-29 00:44:09','2022-08-29 00:44:09',NULL),(13,7730,19,8,NULL,'2022-08-29 00:44:09','2022-08-29 00:56:54','2022-08-29 00:56:54'),(14,7730,20,9,NULL,'2022-08-29 00:44:09','2022-08-29 01:45:25','2022-08-29 01:45:25'),(15,7730,21,10,NULL,'2022-08-29 00:44:09','2022-08-29 00:53:15','2022-08-29 00:53:15'),(16,7730,22,10,NULL,'2022-08-29 00:53:15','2022-08-29 00:53:15',NULL),(17,7730,23,8,NULL,'2022-08-29 00:56:54','2022-08-29 01:26:01','2022-08-29 01:26:01'),(18,7730,24,11,NULL,'2022-08-29 01:12:29','2022-08-29 01:20:08','2022-08-29 01:20:08'),(19,7730,25,11,NULL,'2022-08-29 01:20:08','2022-08-29 01:20:08',NULL),(20,7730,26,8,NULL,'2022-08-29 01:26:01','2022-08-29 02:09:54','2022-08-29 02:09:54'),(21,7730,27,12,NULL,'2022-08-29 01:31:55','2022-08-29 01:31:55',NULL),(22,7730,28,13,NULL,'2022-08-29 01:37:02','2022-08-29 01:37:02',NULL),(23,7730,29,5,NULL,'2022-08-29 01:44:34','2022-08-29 01:44:34',NULL),(24,7730,30,9,NULL,'2022-08-29 01:45:25','2022-08-29 01:45:25',NULL),(25,7730,34,8,747.66,NULL,'2022-08-29 02:06:13','2022-08-29 02:06:13'),(26,7730,35,11,786.50,NULL,'2022-08-29 02:07:43','2022-08-29 02:07:43'),(27,7730,36,8,NULL,'2022-08-29 02:09:54','2022-08-29 02:09:54',NULL),(28,7730,37,8,747.66,NULL,'2022-09-02 02:02:41','2022-09-02 02:02:41'),(29,7730,38,11,786.50,NULL,'2022-09-02 02:50:52','2022-09-02 02:50:52'),(30,7730,39,12,989.41,NULL,'2022-08-29 02:15:06','2022-08-29 02:15:06'),(31,7730,40,12,989.41,NULL,'2022-09-02 02:54:54','2022-09-02 02:54:54'),(32,7730,41,14,NULL,'2022-09-01 14:28:33','2022-09-01 14:33:01','2022-09-01 14:33:01'),(33,7730,42,15,NULL,'2022-09-01 14:28:33','2022-09-01 14:43:32','2022-09-01 14:43:32'),(34,7730,43,16,NULL,'2022-09-01 14:28:33','2022-09-01 14:33:35','2022-09-01 14:33:35'),(35,7730,44,17,NULL,'2022-09-01 14:28:33','2022-09-01 14:34:12','2022-09-01 14:34:12'),(36,7730,45,18,NULL,'2022-09-01 14:28:34','2022-09-01 14:38:43','2022-09-01 14:38:43'),(37,7730,46,19,NULL,'2022-09-01 14:28:34','2022-09-01 14:40:17','2022-09-01 14:40:17'),(38,7730,47,20,NULL,'2022-09-01 14:28:34','2022-09-01 14:41:46','2022-09-01 14:41:46'),(39,7730,48,21,NULL,'2022-09-01 14:28:34','2022-09-01 14:42:46','2022-09-01 14:42:46'),(40,7730,49,14,NULL,'2022-09-01 14:33:01','2022-09-02 04:28:12','2022-09-02 04:28:12'),(41,7730,50,16,NULL,'2022-09-01 14:33:35','2022-09-01 14:37:19','2022-09-01 14:37:19'),(42,7730,51,17,NULL,'2022-09-01 14:34:12','2022-09-01 14:35:57','2022-09-01 14:35:57'),(43,7730,52,17,NULL,'2022-09-01 14:35:57','2022-09-02 04:29:26','2022-09-02 04:29:26'),(44,7730,53,16,NULL,'2022-09-01 14:37:19','2022-09-02 04:28:43','2022-09-02 04:28:43'),(45,7730,54,18,NULL,'2022-09-01 14:38:43','2022-09-02 04:29:38','2022-09-02 04:29:38'),(46,7730,55,19,NULL,'2022-09-01 14:40:17','2022-09-02 04:30:02','2022-09-02 04:30:02'),(47,7730,56,20,NULL,'2022-09-01 14:41:46','2022-09-02 04:30:20','2022-09-02 04:30:20'),(48,7730,57,21,NULL,'2022-09-01 14:42:46','2022-09-02 04:30:32','2022-09-02 04:30:32'),(49,7730,58,15,NULL,'2022-09-01 14:43:32','2022-09-02 04:28:27','2022-09-02 04:28:27');
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (50,7730,60,18,219.00,NULL,'2022-09-01 18:32:07','2022-09-01 18:32:07'),(51,7730,61,14,5295.00,NULL,'2022-09-01 18:51:47','2022-09-01 18:51:47'),(52,7730,62,16,150.00,NULL,'2022-09-01 18:50:39','2022-09-01 18:50:39'),(53,7730,63,14,5295.00,NULL,'2022-09-02 04:26:39','2022-09-02 04:26:39'),(54,7730,64,16,150.00,NULL,'2022-09-01 19:27:11','2022-09-01 19:27:11'),(55,7730,65,18,219.00,NULL,'2022-09-02 04:26:35','2022-09-02 04:26:35'),(56,7730,66,16,150.00,NULL,'2022-09-02 04:26:43','2022-09-02 04:26:43'),(57,7730,67,17,150.00,NULL,'2022-09-01 19:32:44','2022-09-01 19:32:44'),(58,7730,68,17,150.00,NULL,'2022-09-02 04:26:47','2022-09-02 04:26:47'),(59,7730,69,19,219.00,NULL,'2022-09-02 04:26:50','2022-09-02 04:26:50'),(60,7730,70,20,1959.00,NULL,'2022-09-01 19:36:31','2022-09-01 19:36:31'),(61,7730,71,20,1959.00,NULL,'2022-09-02 04:26:54','2022-09-02 04:26:54'),(62,7730,72,15,11754.01,NULL,'2022-09-02 04:26:58','2022-09-02 04:26:58'),(63,7730,73,21,150.00,NULL,'2022-09-02 04:27:02','2022-09-02 04:27:02'),(64,7730,74,22,NULL,'2022-09-02 00:53:11','2022-09-02 00:56:28','2022-09-02 00:56:28'),(65,7730,75,22,NULL,'2022-09-02 00:56:28','2022-09-02 00:57:48','2022-09-02 00:57:48'),(66,7730,76,22,NULL,'2022-09-02 00:57:48','2022-09-02 00:58:14','2022-09-02 00:58:14'),(67,7730,77,22,NULL,'2022-09-02 00:58:14','2022-09-02 00:58:14',NULL),(68,7730,78,8,747.66,NULL,'2022-09-02 02:36:32','2022-09-02 02:36:32'),(69,7730,79,23,NULL,'2022-09-02 03:17:22','2022-09-02 03:17:22',NULL),(70,7730,80,3,NULL,'2022-09-02 04:23:51','2022-09-02 04:23:51',NULL),(71,7730,81,4,NULL,'2022-09-02 04:24:05','2022-09-02 04:24:05',NULL),(72,7730,82,14,NULL,'2022-09-02 04:28:12','2022-09-02 04:28:12',NULL),(73,7730,83,15,NULL,'2022-09-02 04:28:27','2022-09-04 02:29:11','2022-09-04 02:29:11'),(74,7730,84,16,NULL,'2022-09-02 04:28:43','2022-09-02 04:28:43',NULL),(75,7730,85,17,NULL,'2022-09-02 04:29:26','2022-09-02 04:29:26',NULL),(76,7730,86,18,NULL,'2022-09-02 04:29:38','2022-09-02 04:29:38',NULL),(77,7730,87,19,NULL,'2022-09-02 04:30:02','2022-09-02 04:30:02',NULL),(78,7730,88,20,NULL,'2022-09-02 04:30:20','2022-09-02 04:30:20',NULL),(79,7730,89,21,NULL,'2022-09-02 04:30:32','2022-09-04 02:28:54','2022-09-04 02:28:54'),(80,7730,90,24,NULL,'2022-09-02 04:44:36','2022-09-02 04:44:36',NULL),(81,NULL,91,24,5272.00,NULL,NULL,NULL),(82,NULL,92,4,4815.00,NULL,NULL,NULL),(83,7730,93,14,5295.00,NULL,'2022-09-02 05:10:29','2022-09-02 05:10:29'),(84,NULL,94,18,219.00,NULL,NULL,NULL),(85,7730,95,16,150.00,NULL,'2022-09-02 04:53:30','2022-09-02 04:53:30'),(86,NULL,96,16,150.00,NULL,NULL,NULL),(87,NULL,97,17,150.00,NULL,NULL,NULL),(88,NULL,98,19,219.00,NULL,NULL,NULL),(89,NULL,99,20,1959.00,NULL,NULL,NULL),(90,7730,100,15,11754.01,NULL,'2022-09-04 02:28:22','2022-09-04 02:28:22'),(91,7730,101,21,150.00,NULL,'2022-09-04 02:28:10','2022-09-04 02:28:10'),(92,NULL,102,14,5295.00,NULL,NULL,NULL),(93,NULL,103,22,1346.89,NULL,NULL,NULL),(94,7730,104,21,NULL,'2022-09-04 02:28:54','2022-09-04 02:28:54',NULL),(95,7730,105,15,NULL,'2022-09-04 02:29:11','2022-09-04 02:29:11',NULL),(96,NULL,106,15,11754.01,NULL,NULL,NULL),(97,NULL,107,21,150.00,NULL,NULL,NULL),(98,7730,108,25,NULL,'2022-09-04 03:29:55','2022-09-04 03:34:24','2022-09-04 03:34:24'),(99,7730,109,26,NULL,'2022-09-04 03:29:55','2022-09-04 03:37:12','2022-09-04 03:37:12'),(100,7730,110,27,NULL,'2022-09-04 03:29:56','2022-09-04 03:40:13','2022-09-04 03:40:13'),(101,7730,111,28,NULL,'2022-09-04 03:29:56','2022-09-04 03:45:21','2022-09-04 03:45:21'),(102,7730,112,29,NULL,'2022-09-04 03:29:56','2022-09-04 03:49:24','2022-09-04 03:49:24'),(103,7730,113,30,NULL,'2022-09-04 03:29:56','2022-09-04 03:47:43','2022-09-04 03:47:43'),(104,7730,114,31,NULL,'2022-09-04 03:29:56','2022-09-04 03:51:07','2022-09-04 03:51:07'),(105,7730,115,32,NULL,'2022-09-04 03:29:56','2022-09-04 03:53:01','2022-09-04 03:53:01'),(106,7730,116,33,NULL,'2022-09-04 03:29:56','2022-09-04 03:54:26','2022-09-04 03:54:26');
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (107,7730,117,34,NULL,'2022-09-04 03:29:56','2022-09-04 03:29:56',NULL),(108,7730,118,35,NULL,'2022-09-04 03:29:56','2022-09-04 03:57:17','2022-09-04 03:57:17'),(109,7730,119,36,NULL,'2022-09-04 03:29:56','2022-09-04 04:18:26','2022-09-04 04:18:26'),(110,7730,120,37,NULL,'2022-09-04 03:29:56','2022-09-04 04:04:23','2022-09-04 04:04:23'),(111,7730,121,38,NULL,'2022-09-04 03:29:56','2022-09-04 04:06:04','2022-09-04 04:06:04'),(112,7730,122,39,NULL,'2022-09-04 03:29:56','2022-09-04 04:07:36','2022-09-04 04:07:36'),(113,7730,123,40,NULL,'2022-09-04 03:29:56','2022-09-04 04:09:11','2022-09-04 04:09:11'),(114,7730,124,41,NULL,'2022-09-04 03:29:56','2022-09-04 04:12:01','2022-09-04 04:12:01'),(115,7730,125,42,NULL,'2022-09-04 03:29:56','2022-09-04 04:13:18','2022-09-04 04:13:18'),(116,7730,126,43,NULL,'2022-09-04 03:29:56','2022-09-04 04:14:25','2022-09-04 04:14:25'),(117,7730,127,44,NULL,'2022-09-04 03:29:56','2022-09-04 04:10:49','2022-09-04 04:10:49'),(118,7730,128,45,NULL,'2022-09-04 03:29:56','2022-09-04 04:19:28','2022-09-04 04:19:28'),(119,7730,129,46,NULL,'2022-09-04 03:29:56','2022-09-04 04:15:43','2022-09-04 04:15:43'),(120,7730,130,47,NULL,'2022-09-04 03:29:56','2022-09-04 04:20:58','2022-09-04 04:20:58'),(121,7730,131,48,NULL,'2022-09-04 03:29:56','2022-09-04 04:22:49','2022-09-04 04:22:49'),(122,7730,132,49,NULL,'2022-09-04 03:29:56','2022-09-04 04:24:10','2022-09-04 04:24:10'),(123,7730,133,50,NULL,'2022-09-04 03:29:57','2022-09-04 04:25:04','2022-09-04 04:25:04'),(124,7730,134,25,NULL,'2022-09-04 03:34:24','2022-09-04 03:35:39','2022-09-04 03:35:39'),(125,7730,135,25,NULL,'2022-09-04 03:35:39','2022-09-04 03:36:17','2022-09-04 03:36:17'),(126,7730,136,25,NULL,'2022-09-04 03:36:17','2022-09-04 03:41:24','2022-09-04 03:41:24'),(127,7730,137,26,NULL,'2022-09-04 03:37:12','2022-09-04 03:42:40','2022-09-04 03:42:40'),(128,7730,138,27,NULL,'2022-09-04 03:40:13','2022-09-04 03:43:54','2022-09-04 03:43:54'),(129,7730,139,25,NULL,'2022-09-04 03:41:24','2022-09-04 03:41:24',NULL),(130,7730,140,26,NULL,'2022-09-04 03:42:40','2022-09-04 03:42:40',NULL),(131,7730,141,27,NULL,'2022-09-04 03:43:54','2022-09-04 03:43:54',NULL),(132,7730,142,28,NULL,'2022-09-04 03:45:21','2022-09-04 03:45:21',NULL),(133,7730,143,30,NULL,'2022-09-04 03:47:43','2022-09-04 03:47:43',NULL),(134,7730,144,29,NULL,'2022-09-04 03:49:24','2022-09-04 03:49:24',NULL),(135,7730,145,31,NULL,'2022-09-04 03:51:07','2022-09-04 03:51:07',NULL),(136,7730,146,32,NULL,'2022-09-04 03:53:01','2022-09-04 03:53:01',NULL),(137,7730,147,33,NULL,'2022-09-04 03:54:26','2022-09-04 03:54:26',NULL),(138,7730,148,35,NULL,'2022-09-04 03:57:17','2022-09-04 03:59:00','2022-09-04 03:59:00'),(139,7730,149,35,NULL,'2022-09-04 03:59:00','2022-09-04 04:02:49','2022-09-04 04:02:49'),(140,7730,150,35,NULL,'2022-09-04 04:02:49','2022-09-04 04:02:49',NULL),(141,7730,151,37,NULL,'2022-09-04 04:04:23','2022-09-04 04:47:07','2022-09-04 04:47:07'),(142,7730,152,38,NULL,'2022-09-04 04:06:04','2022-09-04 04:06:04',NULL),(143,7730,153,39,NULL,'2022-09-04 04:07:36','2022-09-04 04:07:36',NULL),(144,7730,154,40,NULL,'2022-09-04 04:09:11','2022-09-04 04:09:11',NULL),(145,7730,155,44,NULL,'2022-09-04 04:10:49','2022-09-04 04:10:49',NULL),(146,7730,156,41,NULL,'2022-09-04 04:12:01','2022-09-04 04:12:01',NULL),(147,7730,157,42,NULL,'2022-09-04 04:13:18','2022-09-04 04:13:18',NULL),(148,7730,158,43,NULL,'2022-09-04 04:14:25','2022-09-04 04:14:25',NULL),(149,7730,159,46,NULL,'2022-09-04 04:15:43','2022-09-04 04:15:43',NULL),(150,7730,160,36,NULL,'2022-09-04 04:18:26','2022-09-04 04:18:26',NULL),(151,7730,161,45,NULL,'2022-09-04 04:19:28','2022-09-04 04:19:28',NULL),(152,7730,162,47,NULL,'2022-09-04 04:20:58','2022-09-04 04:20:58',NULL),(153,7730,163,48,NULL,'2022-09-04 04:22:49','2022-09-04 04:22:49',NULL),(154,7730,164,49,NULL,'2022-09-04 04:24:10','2022-09-04 04:24:10',NULL),(155,7730,165,50,NULL,'2022-09-04 04:25:04','2022-09-04 04:25:04',NULL),(156,NULL,166,25,7238.99,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (157,NULL,167,26,7238.99,NULL,NULL,NULL),(158,NULL,168,27,7238.99,NULL,NULL,NULL),(159,NULL,169,28,14478.00,NULL,NULL,NULL),(160,NULL,170,30,8685.00,NULL,NULL,NULL),(161,NULL,171,29,7238.99,NULL,NULL,NULL),(162,NULL,172,31,7238.99,NULL,NULL,NULL),(163,NULL,173,32,7238.99,NULL,NULL,NULL),(164,NULL,174,33,7238.99,NULL,NULL,NULL),(165,NULL,175,35,7238.99,NULL,NULL,NULL),(166,7730,176,37,NULL,'2022-09-04 04:47:07','2022-09-04 04:47:07',NULL),(167,NULL,177,37,7238.99,NULL,NULL,NULL),(168,NULL,178,38,7238.99,NULL,NULL,NULL),(169,NULL,179,39,7238.99,NULL,NULL,NULL),(170,NULL,180,40,7238.99,NULL,NULL,NULL),(171,NULL,181,44,8685.00,NULL,NULL,NULL),(172,NULL,182,41,7238.99,NULL,NULL,NULL),(173,NULL,183,42,7238.99,NULL,NULL,NULL),(174,NULL,184,43,7238.99,NULL,NULL,NULL),(175,NULL,185,46,7238.99,NULL,NULL,NULL),(176,NULL,187,36,4955.00,NULL,NULL,NULL),(177,NULL,188,45,3880.00,NULL,NULL,NULL),(178,NULL,189,47,14478.00,NULL,NULL,NULL),(179,NULL,190,48,7238.99,NULL,NULL,NULL),(180,NULL,191,49,7971.00,NULL,NULL,NULL),(181,NULL,192,50,7238.99,NULL,NULL,NULL),(182,7730,193,51,NULL,'2022-09-04 05:07:48','2022-09-04 05:17:23','2022-09-04 05:17:23'),(183,7730,194,52,NULL,'2022-09-04 05:07:48','2022-09-04 05:28:22','2022-09-04 05:28:22'),(184,7730,195,53,NULL,'2022-09-04 05:07:48','2022-09-04 05:13:32','2022-09-04 05:13:32'),(185,7730,196,54,NULL,'2022-09-04 05:07:48','2022-09-04 05:16:20','2022-09-04 05:16:20'),(186,7730,197,55,NULL,'2022-09-04 05:07:49','2022-09-04 05:18:16','2022-09-04 05:18:16'),(187,7730,198,56,NULL,'2022-09-04 05:07:49','2022-09-04 10:51:32','2022-09-04 10:51:32'),(188,7730,199,57,NULL,'2022-09-04 05:07:49','2022-09-04 10:51:55','2022-09-04 10:51:55'),(189,7730,200,58,NULL,'2022-09-04 05:07:49','2022-09-04 10:52:38','2022-09-04 10:52:38'),(190,7730,201,53,NULL,'2022-09-04 05:13:32','2022-09-04 05:13:57','2022-09-04 05:13:57'),(191,7730,202,53,NULL,'2022-09-04 05:13:57','2022-09-04 05:13:57',NULL),(192,7730,203,54,NULL,'2022-09-04 05:16:20','2022-09-04 05:16:20',NULL),(193,7730,204,51,NULL,'2022-09-04 05:17:23','2022-09-04 05:17:23',NULL),(194,7730,205,55,NULL,'2022-09-04 05:18:16','2022-09-04 05:18:16',NULL),(195,NULL,206,53,17067.75,NULL,NULL,NULL),(196,7730,207,52,NULL,'2022-09-04 05:28:22','2022-09-04 05:28:22',NULL),(197,NULL,208,52,20000.00,NULL,NULL,NULL),(198,7730,209,56,NULL,'2022-09-04 10:51:32','2022-09-04 10:51:32',NULL),(199,7730,210,57,NULL,'2022-09-04 10:51:55','2022-09-04 10:51:55',NULL),(200,7730,211,58,NULL,'2022-09-04 10:52:38','2022-09-04 10:52:38',NULL),(201,7730,212,59,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(202,7730,213,60,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(203,7730,214,61,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(204,7730,215,62,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(205,7730,216,63,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(206,7730,217,64,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(207,7730,218,65,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(208,7730,219,66,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(209,7730,220,67,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(210,7730,221,68,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(211,7730,222,69,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(212,7730,223,70,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(213,7730,224,71,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(214,7730,225,72,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(215,7730,226,73,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(216,7730,227,74,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(217,7730,228,75,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(218,7730,229,76,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(219,7730,230,77,NULL,'2023-03-26 23:30:20','2023-03-26 23:30:20',NULL),(220,7730,231,78,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (221,7730,232,79,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(222,7730,233,80,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(223,7730,234,81,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(224,7730,235,82,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(225,7730,236,83,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(226,7730,237,84,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(227,7730,238,85,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(228,7730,239,86,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(229,7730,240,87,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(230,7730,241,88,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(231,7730,242,89,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(232,7730,243,90,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(233,7730,244,91,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(234,7730,245,92,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(235,7730,246,93,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(236,7730,247,94,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(237,7730,248,95,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(238,7730,249,96,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(239,7730,250,97,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(240,7730,251,98,NULL,'2023-03-26 23:30:21','2023-03-26 23:30:21',NULL),(241,7730,252,99,NULL,'2023-03-26 23:31:17','2023-03-26 23:31:17',NULL),(242,7730,253,100,NULL,'2023-03-26 23:31:17','2023-03-26 23:31:17',NULL),(243,7730,254,101,NULL,'2023-03-26 23:31:17','2023-03-26 23:31:17',NULL),(244,7730,255,102,NULL,'2023-03-26 23:31:17','2023-03-26 23:31:17',NULL),(245,7730,256,103,NULL,'2023-03-26 23:31:17','2023-03-26 23:31:17',NULL),(246,7730,257,104,NULL,'2023-03-26 23:43:09','2023-03-27 00:08:06','2023-03-27 00:08:06'),(247,7730,258,105,NULL,'2023-03-26 23:43:09','2023-03-26 23:56:30','2023-03-26 23:56:30'),(248,7730,259,106,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:32','2023-03-27 00:07:32'),(249,7730,260,107,NULL,'2023-03-26 23:43:09','2023-03-27 00:00:20','2023-03-27 00:00:20'),(250,7730,261,108,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:15','2023-03-27 00:07:15'),(251,7730,262,109,NULL,'2023-03-26 23:43:09','2023-03-27 00:07:01','2023-03-27 00:07:01'),(252,7730,263,110,NULL,'2023-03-26 23:43:09','2023-03-27 00:06:45','2023-03-27 00:06:45'),(253,7730,264,111,NULL,'2023-03-26 23:43:09','2023-03-27 00:06:20','2023-03-27 00:06:20'),(254,7730,265,112,NULL,'2023-03-26 23:43:09','2023-03-27 00:05:01','2023-03-27 00:05:01'),(255,7730,266,113,NULL,'2023-03-26 23:43:10','2023-03-27 00:03:07','2023-03-27 00:03:07'),(256,7730,267,105,NULL,'2023-03-26 23:56:30','2023-03-27 00:08:53','2023-03-27 00:08:53'),(257,7730,268,107,NULL,'2023-03-27 00:00:20','2023-03-27 00:09:11','2023-03-27 00:09:11'),(258,7730,269,113,NULL,'2023-03-27 00:03:07','2023-03-27 00:04:10','2023-03-27 00:04:10'),(259,7730,270,113,NULL,'2023-03-27 00:04:10','2023-03-27 00:09:49','2023-03-27 00:09:49'),(260,7730,271,112,NULL,'2023-03-27 00:05:01','2023-03-27 00:09:30','2023-03-27 00:09:30'),(261,7730,272,111,NULL,'2023-03-27 00:06:20','2023-03-27 00:06:20',NULL),(262,7730,273,110,NULL,'2023-03-27 00:06:45','2023-03-27 00:06:45',NULL),(263,7730,274,109,NULL,'2023-03-27 00:07:01','2023-03-27 00:07:01',NULL),(264,7730,275,108,NULL,'2023-03-27 00:07:15','2023-03-27 00:07:15',NULL),(265,7730,276,106,NULL,'2023-03-27 00:07:32','2023-03-27 00:07:32',NULL),(266,7730,277,104,NULL,'2023-03-27 00:08:06','2023-03-27 00:08:38','2023-03-27 00:08:38'),(267,7730,278,104,NULL,'2023-03-27 00:08:38','2023-03-27 00:08:38',NULL),(268,7730,279,105,NULL,'2023-03-27 00:08:53','2023-03-27 00:08:53',NULL),(269,7730,280,107,NULL,'2023-03-27 00:09:11','2023-03-27 00:09:11',NULL),(270,7730,281,112,NULL,'2023-03-27 00:09:30','2023-03-27 00:09:30',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (271,7730,282,113,NULL,'2023-03-27 00:09:49','2023-03-28 12:14:55','2023-03-28 12:14:55'),(272,7730,283,114,NULL,'2023-03-27 14:34:42','2023-03-27 14:34:42',NULL),(273,7730,284,115,NULL,'2023-03-27 14:34:42','2023-03-27 14:42:48','2023-03-27 14:42:48'),(274,7730,285,116,NULL,'2023-03-27 14:34:42','2023-03-27 14:44:21','2023-03-27 14:44:21'),(275,7730,286,117,NULL,'2023-03-27 14:34:42','2023-03-27 14:45:24','2023-03-27 14:45:24'),(276,7730,287,118,NULL,'2023-03-27 14:34:42','2023-03-27 14:47:13','2023-03-27 14:47:13'),(277,7730,288,119,NULL,'2023-03-27 14:34:42','2023-03-27 14:48:01','2023-03-27 14:48:01'),(278,7730,289,120,NULL,'2023-03-27 14:34:42','2023-03-27 14:49:25','2023-03-27 14:49:25'),(279,7730,290,121,NULL,'2023-03-27 14:34:42','2023-03-27 14:50:41','2023-03-27 14:50:41'),(280,7730,291,122,NULL,'2023-03-27 14:34:42','2023-03-27 14:52:37','2023-03-27 14:52:37'),(281,7730,292,123,NULL,'2023-03-27 14:34:43','2023-03-27 14:53:54','2023-03-27 14:53:54'),(282,7730,293,124,NULL,'2023-03-27 14:34:43','2023-03-27 14:55:03','2023-03-27 14:55:03'),(283,7730,294,125,NULL,'2023-03-27 14:34:43','2023-03-27 14:56:02','2023-03-27 14:56:02'),(284,7730,295,126,NULL,'2023-03-27 14:34:43','2023-03-27 14:57:22','2023-03-27 14:57:22'),(285,7730,296,127,NULL,'2023-03-27 14:34:43','2023-03-27 14:58:21','2023-03-27 14:58:21'),(286,7730,297,128,NULL,'2023-03-27 14:34:43','2023-03-27 14:59:37','2023-03-27 14:59:37'),(287,7730,298,129,NULL,'2023-03-27 14:34:43','2023-03-27 15:00:29','2023-03-27 15:00:29'),(288,7730,299,130,NULL,'2023-03-27 14:34:43','2023-03-27 15:06:44','2023-03-27 15:06:44'),(289,7730,300,131,NULL,'2023-03-27 14:34:43','2023-03-27 15:02:54','2023-03-27 15:02:54'),(290,7730,301,132,NULL,'2023-03-27 14:34:43','2023-03-27 15:04:08','2023-03-27 15:04:08'),(291,7730,302,133,NULL,'2023-03-27 14:34:43','2023-03-27 15:04:42','2023-03-27 15:04:42'),(292,7730,303,134,NULL,'2023-03-27 14:34:43','2023-03-27 15:05:54','2023-03-27 15:05:54'),(293,7730,304,135,NULL,'2023-03-27 14:34:43','2023-03-27 15:08:24','2023-03-27 15:08:24'),(294,7730,305,136,NULL,'2023-03-27 14:34:43','2023-03-27 15:11:08','2023-03-27 15:11:08'),(295,7730,306,137,NULL,'2023-03-27 14:34:43','2023-03-27 15:12:51','2023-03-27 15:12:51'),(296,7730,307,138,NULL,'2023-03-27 14:34:43','2023-03-27 15:14:06','2023-03-27 15:14:06'),(297,7730,308,139,NULL,'2023-03-27 14:34:43','2023-03-27 15:14:41','2023-03-27 15:14:41'),(298,7730,309,140,NULL,'2023-03-27 14:34:43','2023-03-27 15:15:48','2023-03-27 15:15:48'),(299,7730,310,141,NULL,'2023-03-27 14:34:43','2023-03-27 15:17:10','2023-03-27 15:17:10'),(300,7730,311,142,NULL,'2023-03-27 14:34:43','2023-03-27 15:18:09','2023-03-27 15:18:09'),(301,7730,312,143,NULL,'2023-03-27 14:34:44','2023-03-27 15:20:22','2023-03-27 15:20:22'),(302,7730,313,144,NULL,'2023-03-27 14:34:44','2023-03-27 15:21:38','2023-03-27 15:21:38'),(303,7730,314,145,NULL,'2023-03-27 14:34:44','2023-03-27 15:22:48','2023-03-27 15:22:48'),(304,7730,315,146,NULL,'2023-03-27 14:34:44','2023-03-27 15:23:55','2023-03-27 15:23:55'),(305,7730,316,147,NULL,'2023-03-27 14:34:44','2023-03-27 15:25:16','2023-03-27 15:25:16'),(306,7730,317,148,NULL,'2023-03-27 14:34:44','2023-03-27 15:26:08','2023-03-27 15:26:08'),(307,7730,318,149,NULL,'2023-03-27 14:34:44','2023-03-27 15:27:27','2023-03-27 15:27:27'),(308,7730,319,150,NULL,'2023-03-27 14:34:44','2023-03-27 15:28:27','2023-03-27 15:28:27'),(309,7730,320,151,NULL,'2023-03-27 14:34:44','2023-03-27 15:29:31','2023-03-27 15:29:31'),(310,7730,321,152,NULL,'2023-03-27 14:34:44','2023-03-27 15:30:29','2023-03-27 15:30:29'),(311,7730,322,153,NULL,'2023-03-27 14:34:44','2023-03-27 15:31:17','2023-03-27 15:31:17'),(312,7730,323,154,NULL,'2023-03-27 14:36:03','2023-03-27 15:32:52','2023-03-27 15:32:52'),(313,7730,324,155,NULL,'2023-03-27 14:36:03','2023-03-27 15:33:40','2023-03-27 15:33:40'),(314,7730,325,156,NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (315,7730,326,157,NULL,'2023-03-27 14:36:03','2023-03-27 14:36:03',NULL),(316,7730,327,158,NULL,'2023-03-27 14:36:03','2023-03-27 15:32:17','2023-03-27 15:32:17'),(317,7730,328,115,NULL,'2023-03-27 14:42:48','2023-03-27 14:42:48',NULL),(318,7730,329,116,NULL,'2023-03-27 14:44:21','2023-03-27 14:44:21',NULL),(319,7730,330,117,NULL,'2023-03-27 14:45:24','2023-03-27 14:45:24',NULL),(320,7730,331,118,NULL,'2023-03-27 14:47:13','2023-03-27 14:47:13',NULL),(321,7730,332,119,NULL,'2023-03-27 14:48:01','2023-03-27 14:48:01',NULL),(322,7730,333,120,NULL,'2023-03-27 14:49:25','2023-03-27 14:49:25',NULL),(323,7730,334,121,NULL,'2023-03-27 14:50:41','2023-03-27 14:50:41',NULL),(324,7730,335,122,NULL,'2023-03-27 14:52:37','2023-03-27 14:52:37',NULL),(325,7730,336,123,NULL,'2023-03-27 14:53:54','2023-03-27 14:53:54',NULL),(326,7730,337,124,NULL,'2023-03-27 14:55:03','2023-03-27 14:55:03',NULL),(327,7730,338,125,NULL,'2023-03-27 14:56:02','2023-03-27 14:56:02',NULL),(328,7730,339,126,NULL,'2023-03-27 14:57:22','2023-03-27 14:57:22',NULL),(329,7730,340,127,NULL,'2023-03-27 14:58:21','2023-03-27 14:58:21',NULL),(330,7730,341,128,NULL,'2023-03-27 14:59:37','2023-03-27 14:59:37',NULL),(331,7730,342,129,NULL,'2023-03-27 15:00:29','2023-03-27 15:00:29',NULL),(332,7730,343,131,NULL,'2023-03-27 15:02:54','2023-03-27 15:02:54',NULL),(333,7730,344,132,NULL,'2023-03-27 15:04:08','2023-03-27 15:04:08',NULL),(334,7730,345,133,NULL,'2023-03-27 15:04:42','2023-03-27 15:04:42',NULL),(335,7730,346,134,NULL,'2023-03-27 15:05:54','2023-03-27 15:05:54',NULL),(336,7730,347,130,NULL,'2023-03-27 15:06:44','2023-03-27 15:06:44',NULL),(337,7730,348,135,NULL,'2023-03-27 15:08:24','2023-03-27 15:08:24',NULL),(338,7730,349,136,NULL,'2023-03-27 15:11:08','2023-03-27 15:11:08',NULL),(339,7730,350,137,NULL,'2023-03-27 15:12:51','2023-03-27 15:12:51',NULL),(340,7730,351,138,NULL,'2023-03-27 15:14:06','2023-03-27 15:14:06',NULL),(341,7730,352,139,NULL,'2023-03-27 15:14:41','2023-03-27 15:14:41',NULL),(342,7730,353,140,NULL,'2023-03-27 15:15:48','2023-03-27 15:15:48',NULL),(343,7730,354,141,NULL,'2023-03-27 15:17:10','2023-03-27 15:17:10',NULL),(344,7730,355,142,NULL,'2023-03-27 15:18:09','2023-03-27 15:18:52','2023-03-27 15:18:52'),(345,7730,356,142,NULL,'2023-03-27 15:18:52','2023-03-27 15:19:25','2023-03-27 15:19:25'),(346,7730,357,142,NULL,'2023-03-27 15:19:25','2023-03-27 15:19:25',NULL),(347,7730,358,143,NULL,'2023-03-27 15:20:22','2023-03-27 15:20:22',NULL),(348,7730,359,144,NULL,'2023-03-27 15:21:38','2023-03-27 15:21:38',NULL),(349,7730,360,145,NULL,'2023-03-27 15:22:48','2023-03-27 15:22:48',NULL),(350,7730,361,146,NULL,'2023-03-27 15:23:55','2023-03-27 15:23:55',NULL),(351,7730,362,147,NULL,'2023-03-27 15:25:16','2023-03-27 15:25:16',NULL),(352,7730,363,148,NULL,'2023-03-27 15:26:08','2023-03-27 15:26:08',NULL),(353,7730,364,149,NULL,'2023-03-27 15:27:27','2023-03-27 15:27:27',NULL),(354,7730,365,150,NULL,'2023-03-27 15:28:27','2023-03-27 15:28:27',NULL),(355,7730,366,151,NULL,'2023-03-27 15:29:31','2023-03-27 15:29:31',NULL),(356,7730,367,152,NULL,'2023-03-27 15:30:29','2023-03-27 15:30:29',NULL),(357,7730,368,153,NULL,'2023-03-27 15:31:17','2023-03-27 15:31:17',NULL),(358,7730,369,158,NULL,'2023-03-27 15:32:17','2023-03-27 15:32:17',NULL),(359,7730,370,154,NULL,'2023-03-27 15:32:52','2023-03-27 15:32:52',NULL),(360,7730,371,155,NULL,'2023-03-27 15:33:40','2023-03-27 15:33:40',NULL),(361,NULL,372,127,150.00,NULL,NULL,NULL),(362,NULL,373,129,799.00,NULL,NULL,NULL),(363,NULL,373,133,150.00,NULL,NULL,NULL),(364,NULL,374,115,6490.00,NULL,NULL,NULL),(365,NULL,374,116,1600.00,NULL,NULL,NULL),(366,NULL,375,117,7590.00,NULL,NULL,NULL),(367,NULL,376,118,7590.00,NULL,NULL,NULL),(368,NULL,376,119,1500.00,NULL,NULL,NULL),(369,NULL,377,120,19470.00,NULL,NULL,NULL),(370,NULL,378,121,150.00,NULL,NULL,NULL),(371,NULL,379,122,7590.00,NULL,NULL,NULL),(372,NULL,380,123,150.00,NULL,NULL,NULL),(373,NULL,381,124,150.00,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (374,NULL,382,125,150.00,NULL,NULL,NULL),(375,NULL,383,126,7590.00,NULL,NULL,NULL),(376,NULL,384,128,150.00,NULL,NULL,NULL),(377,NULL,385,131,150.00,NULL,NULL,NULL),(378,NULL,386,132,150.00,NULL,NULL,NULL),(379,NULL,387,134,150.00,NULL,NULL,NULL),(380,NULL,388,135,1379.00,NULL,NULL,NULL),(381,NULL,389,136,7590.00,NULL,NULL,NULL),(382,NULL,390,137,7819.00,NULL,NULL,NULL),(383,NULL,391,139,6490.00,NULL,NULL,NULL),(384,NULL,392,138,6490.00,NULL,NULL,NULL),(385,NULL,393,140,6490.00,NULL,NULL,NULL),(386,NULL,394,141,8685.00,NULL,NULL,NULL),(387,NULL,395,142,8685.00,NULL,NULL,NULL),(388,NULL,396,143,300.00,NULL,NULL,NULL),(389,NULL,397,144,7590.00,NULL,NULL,NULL),(390,NULL,398,145,6490.00,NULL,NULL,NULL),(391,NULL,399,146,8685.00,NULL,NULL,NULL),(392,NULL,400,147,6490.00,NULL,NULL,NULL),(393,NULL,401,149,6490.00,NULL,NULL,NULL),(394,NULL,402,150,6490.00,NULL,NULL,NULL),(395,NULL,403,151,8685.00,NULL,NULL,NULL),(396,NULL,404,152,7590.00,NULL,NULL,NULL),(397,NULL,405,154,150.00,NULL,NULL,NULL),(398,NULL,406,155,6799.00,NULL,NULL,NULL),(399,NULL,407,156,40794.00,NULL,NULL,NULL),(400,NULL,408,130,150.00,NULL,NULL,NULL),(401,7730,409,5,3953.98,NULL,'2023-03-28 17:17:32','2023-03-28 17:17:32'),(402,7730,409,9,2990.21,NULL,'2023-03-28 17:17:32','2023-03-28 17:17:32'),(403,7730,409,108,12801.20,NULL,'2023-03-28 17:17:32','2023-03-28 17:17:32'),(404,7730,409,106,5719.07,NULL,'2023-03-28 17:17:32','2023-03-28 17:17:32'),(405,7730,409,109,7234.59,NULL,'2023-03-28 17:17:32','2023-03-28 17:17:32'),(406,7730,409,110,4267.07,NULL,'2023-03-28 17:17:32','2023-03-28 17:17:32'),(407,NULL,410,56,84572.83,NULL,NULL,NULL),(408,NULL,410,57,5880.60,NULL,NULL,NULL),(409,NULL,410,58,47044.80,NULL,NULL,NULL),(410,7730,411,113,NULL,'2023-03-28 12:14:55','2023-03-28 12:14:55',NULL),(411,7730,412,107,40365.09,NULL,'2023-03-28 13:21:24','2023-03-28 13:21:24'),(412,7730,413,113,1206.09,NULL,'2023-03-28 12:42:47','2023-03-28 12:42:47'),(413,NULL,414,112,3298.43,NULL,NULL,NULL),(414,NULL,415,104,20000.00,NULL,NULL,NULL),(415,NULL,416,113,1206.09,NULL,NULL,NULL),(416,7730,417,159,NULL,'2023-03-28 13:14:06','2023-03-28 13:16:58','2023-03-28 13:16:58'),(417,7730,418,159,NULL,'2023-03-28 13:16:58','2023-03-28 13:41:33','2023-03-28 13:41:33'),(418,7730,419,160,NULL,'2023-03-28 13:22:49','2023-03-28 13:24:56','2023-03-28 13:24:56'),(419,7730,420,160,NULL,'2023-03-28 13:24:56','2023-03-28 13:24:56',NULL),(420,7730,421,160,40365.09,NULL,'2023-03-28 14:25:03','2023-03-28 14:25:03'),(421,7730,422,159,NULL,'2023-03-28 13:41:33','2023-03-28 13:41:33',NULL),(422,NULL,423,NULL,39160.19,NULL,NULL,NULL),(423,7730,424,161,NULL,'2023-03-28 15:17:33','2023-03-28 15:22:21','2023-03-28 15:22:21'),(424,7730,425,162,NULL,'2023-03-28 15:17:33','2023-03-28 15:23:10','2023-03-28 15:23:10'),(425,7730,426,163,NULL,'2023-03-28 15:17:33','2023-03-28 15:23:57','2023-03-28 15:23:57'),(426,7730,427,164,NULL,'2023-03-28 15:17:33','2023-03-28 15:24:57','2023-03-28 15:24:57'),(427,7730,428,165,NULL,'2023-03-28 15:17:33','2023-03-28 15:25:56','2023-03-28 15:25:56'),(428,7730,429,166,NULL,'2023-03-28 15:17:33','2023-03-28 15:26:38','2023-03-28 15:26:38'),(429,7730,430,167,NULL,'2023-03-28 15:17:34','2023-03-28 15:27:43','2023-03-28 15:27:43'),(430,7730,431,168,NULL,'2023-03-28 15:17:34','2023-03-28 15:28:30','2023-03-28 15:28:30'),(431,7730,432,169,NULL,'2023-03-28 15:17:34','2023-03-28 15:17:34',NULL),(432,7730,433,170,NULL,'2023-03-28 15:17:34','2023-03-28 15:29:20','2023-03-28 15:29:20'),(433,7730,434,171,NULL,'2023-03-28 15:17:34','2023-03-28 15:30:03','2023-03-28 15:30:03'),(434,7730,435,172,NULL,'2023-03-28 15:17:34','2023-03-28 15:30:46','2023-03-28 15:30:46'),(435,7730,436,173,NULL,'2023-03-28 15:17:34','2023-03-28 15:31:38','2023-03-28 15:31:38'),(436,7730,437,174,NULL,'2023-03-28 15:17:34','2023-03-28 15:33:16','2023-03-28 15:33:16'),(437,7730,438,175,NULL,'2023-03-28 15:17:34','2023-03-28 15:34:36','2023-03-28 15:34:36');
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (438,7730,439,176,NULL,'2023-03-28 15:17:34','2023-03-28 15:39:33','2023-03-28 15:39:33'),(439,7730,440,177,NULL,'2023-03-28 15:17:34','2023-03-28 15:35:23','2023-03-28 15:35:23'),(440,7730,441,178,NULL,'2023-03-28 15:17:34','2023-03-28 15:36:27','2023-03-28 15:36:27'),(441,7730,442,179,NULL,'2023-03-28 15:17:34','2023-03-28 15:36:53','2023-03-28 15:36:53'),(442,7730,443,180,NULL,'2023-03-28 15:17:34','2023-03-28 15:37:46','2023-03-28 15:37:46'),(443,7730,444,181,NULL,'2023-03-28 15:17:34','2023-03-28 15:38:39','2023-03-28 15:38:39'),(444,7730,445,182,NULL,'2023-03-28 15:21:09','2023-03-28 15:40:44','2023-03-28 15:40:44'),(445,7730,446,161,NULL,'2023-03-28 15:22:21','2023-03-28 15:22:21',NULL),(446,7730,447,162,NULL,'2023-03-28 15:23:10','2023-03-28 15:23:10',NULL),(447,7730,448,163,NULL,'2023-03-28 15:23:57','2023-03-28 15:23:57',NULL),(448,7730,449,164,NULL,'2023-03-28 15:24:57','2023-03-28 15:24:57',NULL),(449,7730,450,165,NULL,'2023-03-28 15:25:56','2023-03-28 15:25:56',NULL),(450,7730,451,166,NULL,'2023-03-28 15:26:38','2023-03-28 15:26:38',NULL),(451,7730,452,167,NULL,'2023-03-28 15:27:43','2023-03-28 15:27:43',NULL),(452,7730,453,168,NULL,'2023-03-28 15:28:30','2023-03-28 15:28:30',NULL),(453,7730,454,170,NULL,'2023-03-28 15:29:20','2023-03-28 15:29:20',NULL),(454,7730,455,171,NULL,'2023-03-28 15:30:03','2023-03-28 15:30:03',NULL),(455,7730,456,172,NULL,'2023-03-28 15:30:46','2023-03-28 15:30:46',NULL),(456,7730,457,173,NULL,'2023-03-28 15:31:38','2023-03-28 15:31:38',NULL),(457,7730,458,174,NULL,'2023-03-28 15:33:16','2023-03-28 15:33:16',NULL),(458,7730,459,175,NULL,'2023-03-28 15:34:36','2023-03-28 15:34:36',NULL),(459,7730,460,177,NULL,'2023-03-28 15:35:23','2023-03-28 15:35:23',NULL),(460,7730,461,178,NULL,'2023-03-28 15:36:27','2023-03-28 15:36:27',NULL),(461,7730,462,179,NULL,'2023-03-28 15:36:53','2023-03-28 15:36:53',NULL),(462,7730,463,180,NULL,'2023-03-28 15:37:46','2023-03-28 15:37:46',NULL),(463,7730,464,181,NULL,'2023-03-28 15:38:39','2023-03-28 15:38:39',NULL),(464,7730,465,176,NULL,'2023-03-28 15:39:33','2023-03-28 15:44:07','2023-03-28 15:44:07'),(465,7730,466,182,NULL,'2023-03-28 15:40:44','2023-03-28 15:40:44',NULL),(466,7730,467,183,NULL,'2023-03-28 15:41:42','2023-03-28 15:43:08','2023-03-28 15:43:08'),(467,7730,468,183,NULL,'2023-03-28 15:43:08','2023-03-28 15:43:08',NULL),(468,7730,469,176,NULL,'2023-03-28 15:44:07','2023-03-28 15:44:07',NULL),(469,NULL,470,161,9990.00,NULL,NULL,NULL),(470,NULL,471,162,7919.00,NULL,NULL,NULL),(471,NULL,472,163,8557.00,NULL,NULL,NULL),(472,NULL,473,164,9990.00,NULL,NULL,NULL),(473,NULL,473,166,2990.00,NULL,NULL,NULL),(474,NULL,474,165,7590.00,NULL,NULL,NULL),(475,NULL,475,167,9990.00,NULL,NULL,NULL),(476,NULL,476,168,9990.00,NULL,NULL,NULL),(477,NULL,477,170,9990.00,NULL,NULL,NULL),(478,NULL,478,171,9990.00,NULL,NULL,NULL),(479,NULL,478,172,17780.00,NULL,NULL,NULL),(480,NULL,479,173,7919.00,NULL,NULL,NULL),(481,NULL,480,175,9990.00,NULL,NULL,NULL),(482,NULL,481,177,3400.00,NULL,NULL,NULL),(483,NULL,482,178,2750.00,NULL,NULL,NULL),(484,NULL,482,179,9990.00,NULL,NULL,NULL),(485,NULL,483,180,9990.00,NULL,NULL,NULL),(486,NULL,484,183,7990.00,NULL,NULL,NULL),(487,NULL,485,181,9490.50,NULL,NULL,NULL),(488,NULL,486,182,17780.00,NULL,NULL,NULL),(489,NULL,487,176,7990.00,NULL,NULL,NULL),(490,7730,488,184,NULL,'2023-03-28 16:08:42','2023-03-29 10:33:33','2023-03-29 10:33:33'),(491,7730,489,185,NULL,'2023-03-28 16:08:42','2023-03-29 10:33:15','2023-03-29 10:33:15'),(492,7730,490,186,NULL,'2023-03-28 16:08:43','2023-03-28 16:10:10','2023-03-28 16:10:10'),(493,7730,491,187,NULL,'2023-03-28 16:08:43','2023-03-28 16:08:43',NULL),(494,7730,492,188,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:55','2023-03-29 10:32:55'),(495,7730,493,189,NULL,'2023-03-28 16:08:43','2023-03-28 16:13:57','2023-03-28 16:13:57'),(496,7730,494,190,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:43','2023-03-29 10:32:43');
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (497,7730,495,191,NULL,'2023-03-28 16:08:43','2023-03-29 10:36:56','2023-03-29 10:36:56'),(498,7730,496,192,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:30','2023-03-29 10:32:30'),(499,7730,497,193,NULL,'2023-03-28 16:08:43','2023-03-29 10:32:13','2023-03-29 10:32:13'),(500,7730,498,194,NULL,'2023-03-28 16:08:43','2023-03-29 10:31:59','2023-03-29 10:31:59'),(501,7730,499,195,NULL,'2023-03-28 16:08:43','2023-03-29 10:31:45','2023-03-29 10:31:45'),(502,7730,500,196,NULL,'2023-03-28 16:08:43','2023-03-28 16:16:33','2023-03-28 16:16:33'),(503,7730,501,186,NULL,'2023-03-28 16:10:10','2023-03-28 16:14:44','2023-03-28 16:14:44'),(504,7730,502,189,NULL,'2023-03-28 16:13:57','2023-03-28 16:13:57',NULL),(505,7730,503,186,NULL,'2023-03-28 16:14:44','2023-03-28 16:14:44',NULL),(506,7730,504,196,NULL,'2023-03-28 16:16:33','2023-03-28 16:16:33',NULL),(507,NULL,505,189,42059.18,NULL,NULL,NULL),(508,NULL,506,186,20000.00,NULL,NULL,NULL),(509,7730,507,196,1206.09,NULL,'2023-03-28 16:45:54','2023-03-28 16:45:54'),(510,NULL,508,196,1206.09,NULL,NULL,NULL),(511,NULL,509,NULL,50000.00,NULL,NULL,NULL),(512,NULL,510,NULL,90000.00,NULL,NULL,NULL),(513,7730,511,195,NULL,'2023-03-29 10:31:45','2023-03-29 10:31:45',NULL),(514,7730,512,194,NULL,'2023-03-29 10:31:59','2023-03-29 10:31:59',NULL),(515,7730,513,193,NULL,'2023-03-29 10:32:13','2023-03-29 10:32:13',NULL),(516,7730,514,192,NULL,'2023-03-29 10:32:30','2023-03-29 10:32:30',NULL),(517,7730,515,190,NULL,'2023-03-29 10:32:43','2023-03-29 10:32:43',NULL),(518,7730,516,188,NULL,'2023-03-29 10:32:55','2023-03-29 10:32:55',NULL),(519,7730,517,185,NULL,'2023-03-29 10:33:15','2023-03-29 10:33:15',NULL),(520,7730,518,184,NULL,'2023-03-29 10:33:33','2023-03-29 10:33:33',NULL),(521,7730,519,191,NULL,'2023-03-29 10:36:56','2023-03-29 10:36:56',NULL),(522,7730,520,197,NULL,'2023-03-29 10:40:16','2023-03-29 10:42:31','2023-03-29 10:42:31'),(523,7730,521,198,NULL,'2023-03-29 10:40:16','2023-03-29 10:42:06','2023-03-29 10:42:06'),(524,7730,522,199,NULL,'2023-03-29 10:40:16','2023-03-29 10:43:38','2023-03-29 10:43:38'),(525,7730,523,200,NULL,'2023-03-29 10:40:16','2023-03-29 10:45:21','2023-03-29 10:45:21'),(526,7730,524,201,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:01','2023-03-29 10:47:01'),(527,7730,525,202,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:18','2023-03-29 10:47:18'),(528,7730,526,203,NULL,'2023-03-29 10:40:16','2023-03-29 10:47:55','2023-03-29 10:47:55'),(529,7730,527,198,NULL,'2023-03-29 10:42:06','2023-03-29 10:42:06',NULL),(530,7730,528,197,NULL,'2023-03-29 10:42:31','2023-03-29 10:42:31',NULL),(531,7730,529,199,NULL,'2023-03-29 10:43:38','2023-03-29 11:05:47','2023-03-29 11:05:47'),(532,7730,530,200,NULL,'2023-03-29 10:45:21','2023-03-29 10:45:21',NULL),(533,7730,531,201,NULL,'2023-03-29 10:47:01','2023-03-29 11:22:52','2023-03-29 11:22:52'),(534,7730,532,202,NULL,'2023-03-29 10:47:18','2023-03-29 11:23:17','2023-03-29 11:23:17'),(535,7730,533,203,NULL,'2023-03-29 10:47:55','2023-03-29 11:23:51','2023-03-29 11:23:51'),(536,NULL,534,197,2000.00,NULL,NULL,NULL),(537,NULL,534,198,6800.00,NULL,NULL,NULL),(538,NULL,535,200,7990.00,NULL,NULL,NULL),(539,NULL,536,NULL,2397.00,NULL,NULL,NULL),(540,NULL,536,199,2397.00,NULL,NULL,NULL),(541,7730,537,199,NULL,'2023-03-29 11:05:47','2023-03-29 11:05:47',NULL),(542,NULL,538,NULL,7830.00,NULL,NULL,NULL),(543,NULL,538,201,7830.00,NULL,NULL,NULL),(544,7730,539,201,NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL),(545,NULL,540,NULL,1500.00,NULL,NULL,NULL),(546,NULL,540,202,1500.00,NULL,NULL,NULL),(547,7730,541,202,NULL,'2023-03-29 11:23:17','2023-03-29 11:23:17',NULL),(548,NULL,542,NULL,7990.00,NULL,NULL,NULL),(549,NULL,542,203,7990.00,NULL,NULL,NULL),(550,7730,543,203,NULL,'2023-03-29 11:23:51','2023-03-29 11:23:51',NULL),(551,7730,544,204,NULL,'2023-03-29 11:27:14','2023-03-29 13:05:26','2023-03-29 13:05:26'),(552,7730,545,205,NULL,'2023-03-29 11:27:14','2023-03-29 11:39:39','2023-03-29 11:39:39');
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (553,7730,546,206,NULL,'2023-03-29 11:27:14','2023-03-29 11:30:03','2023-03-29 11:30:03'),(554,7730,547,207,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:51','2023-03-29 11:29:51'),(555,7730,548,208,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:38','2023-03-29 11:29:38'),(556,7730,549,209,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:25','2023-03-29 11:29:25'),(557,7730,550,210,NULL,'2023-03-29 11:27:14','2023-03-29 11:29:14','2023-03-29 11:29:14'),(558,7730,551,211,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:59','2023-03-29 11:28:59'),(559,7730,552,212,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:45','2023-03-29 11:28:45'),(560,7730,553,213,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:34','2023-03-29 11:28:34'),(561,7730,554,214,NULL,'2023-03-29 11:27:14','2023-03-29 11:28:21','2023-03-29 11:28:21'),(562,7730,555,214,NULL,'2023-03-29 11:28:21','2023-03-29 13:07:14','2023-03-29 13:07:14'),(563,7730,556,213,NULL,'2023-03-29 11:28:34','2023-03-29 13:09:37','2023-03-29 13:09:37'),(564,7730,557,212,NULL,'2023-03-29 11:28:45','2023-03-29 11:28:45',NULL),(565,7730,558,211,NULL,'2023-03-29 11:28:59','2023-03-29 11:28:59',NULL),(566,7730,559,210,NULL,'2023-03-29 11:29:14','2023-03-29 13:12:50','2023-03-29 13:12:50'),(567,7730,560,209,NULL,'2023-03-29 11:29:25','2023-03-29 11:29:25',NULL),(568,7730,561,208,NULL,'2023-03-29 11:29:38','2023-03-29 11:29:38',NULL),(569,7730,562,207,NULL,'2023-03-29 11:29:51','2023-03-29 11:29:51',NULL),(570,7730,563,206,NULL,'2023-03-29 11:30:03','2023-03-29 11:30:03',NULL),(571,7730,564,205,NULL,'2023-03-29 11:39:39','2023-03-29 11:41:30','2023-03-29 11:41:30'),(572,7730,565,205,NULL,'2023-03-29 11:41:30','2023-03-29 13:07:55','2023-03-29 13:07:55'),(573,7730,566,204,NULL,'2023-03-29 13:05:26','2023-03-29 13:05:48','2023-03-29 13:05:48'),(574,7730,567,204,NULL,'2023-03-29 13:05:48','2023-03-29 13:14:05','2023-03-29 13:14:05'),(575,NULL,568,NULL,20000.00,NULL,NULL,NULL),(576,NULL,568,214,20000.00,NULL,NULL,NULL),(577,7730,569,214,NULL,'2023-03-29 13:07:14','2023-03-29 13:07:14',NULL),(578,NULL,570,NULL,31867.42,NULL,NULL,NULL),(579,NULL,570,205,31867.42,NULL,NULL,NULL),(580,7730,571,205,NULL,'2023-03-29 13:07:55','2023-03-29 13:07:55',NULL),(581,NULL,572,NULL,11721.00,NULL,NULL,NULL),(582,NULL,572,213,11721.00,NULL,NULL,NULL),(583,7730,573,213,NULL,'2023-03-29 13:09:37','2023-03-29 13:09:37',NULL),(584,7730,574,NULL,67248.27,NULL,'2023-03-29 13:19:28','2023-03-29 13:19:28'),(585,7730,574,210,67248.27,NULL,'2023-03-29 13:19:28','2023-03-29 13:19:28'),(586,7730,575,210,NULL,'2023-03-29 13:12:51','2023-03-29 13:21:22','2023-03-29 13:21:22'),(587,7730,576,NULL,1206.09,NULL,'2023-03-29 14:54:23','2023-03-29 14:54:23'),(588,7730,576,204,1206.09,NULL,'2023-03-29 14:54:23','2023-03-29 14:54:23'),(589,7730,577,204,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:53','2023-03-29 14:54:53'),(590,NULL,578,NULL,67248.27,NULL,NULL,NULL),(591,NULL,578,210,67248.27,NULL,NULL,NULL),(592,7730,579,210,NULL,'2023-03-29 13:21:22','2023-03-29 13:21:22',NULL),(593,7730,580,55,1513750.00,NULL,'2023-03-29 14:02:04','2023-03-29 14:02:04'),(594,7730,581,204,NULL,'2023-03-29 14:54:53','2023-03-29 14:54:53',NULL),(595,NULL,582,204,1206.09,NULL,NULL,NULL),(596,7730,583,215,NULL,'2023-03-29 17:30:47','2023-03-29 17:32:16','2023-03-29 17:32:16'),(597,7730,584,215,NULL,'2023-03-29 17:32:16','2023-03-29 17:32:16',NULL),(598,7730,585,215,1206.09,NULL,'2023-03-29 18:41:50','2023-03-29 18:41:50'),(599,7730,586,216,NULL,'2023-03-29 18:29:35','2023-03-29 18:41:12','2023-03-29 18:41:12'),(600,7730,587,216,NULL,'2023-03-29 18:41:12','2023-03-29 18:41:12',NULL),(601,NULL,588,215,1206.09,NULL,NULL,NULL),(602,7730,589,217,NULL,'2023-03-29 19:28:12','2023-03-29 20:01:23','2023-03-29 20:01:23'),(603,7730,590,217,NULL,'2023-03-29 20:01:23','2023-03-29 20:03:43','2023-03-29 20:03:43'),(604,7730,591,217,NULL,'2023-03-29 20:03:43','2023-03-29 20:03:43',NULL),(605,NULL,592,216,261.88,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (606,7730,593,218,NULL,'2023-03-29 20:18:01','2023-03-29 20:19:14','2023-03-29 20:19:14'),(607,7730,594,218,NULL,'2023-03-29 20:19:14','2023-03-29 20:19:39','2023-03-29 20:19:39'),(608,7730,595,218,NULL,'2023-03-29 20:19:39','2023-03-29 20:19:39',NULL),(609,NULL,596,217,1528.76,NULL,NULL,NULL),(610,NULL,597,218,366.63,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `ticket_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_ticket_id_foreign` (`ticket_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria` VALUES (1,7730,40720,NULL,NULL,359,1520,'2022-09-30',5271.99,1,1.00,'',NULL,'2022-08-28 13:23:52','2022-08-28 15:06:53','2022-08-28 15:06:53',NULL),(2,7730,40720,5,NULL,13,1520,'2020-09-30',5271.99,1,1.00,NULL,NULL,'2022-08-28 15:04:15','2022-08-28 16:39:22','2022-08-28 16:39:22',NULL),(3,7730,40720,6,NULL,13,1520,'2020-09-30',5272.00,1,1.00,NULL,NULL,'2022-08-28 16:43:18','2022-08-28 16:54:30','2022-08-28 16:54:30',NULL),(4,7730,40720,7,NULL,13,1520,'2020-09-30',5271.99,1,1.00,NULL,NULL,'2022-08-28 16:55:29','2022-08-28 23:49:23','2022-08-28 23:49:23',NULL),(5,7730,40720,11,NULL,13,1520,'2020-10-01',5272.00,1,1.00,NULL,NULL,'2022-08-28 23:51:22','2022-08-29 00:15:32','2022-08-29 00:15:32',NULL),(6,7730,40720,12,NULL,13,1520,'2020-09-30',5272.00,1,1.00,NULL,NULL,'2022-08-29 00:16:35','2022-09-02 04:26:26','2022-09-02 04:26:26',NULL),(7,7730,40720,15,NULL,13,1521,'2020-10-15',4815.00,1,1.00,NULL,NULL,'2022-08-29 00:39:42','2022-09-02 04:26:31','2022-09-02 04:26:31',NULL),(8,7730,40720,31,NULL,57,1521,'2020-10-07',14400.00,1,1.00,NULL,NULL,'2022-08-29 01:53:25','2022-09-02 02:50:01','2022-09-02 02:50:01',NULL),(9,7730,40720,32,NULL,57,1521,'2020-10-05',786.50,1,1.00,NULL,NULL,'2022-08-29 01:55:39','2022-08-29 01:56:02','2022-08-29 01:56:02',NULL),(10,7730,40720,33,NULL,57,1521,'2020-10-05',786.50,1,1.00,NULL,NULL,'2022-08-29 01:56:57','2022-08-29 01:59:28','2022-08-29 01:59:28',NULL),(11,7730,40720,34,NULL,57,1521,'2020-10-08',747.66,1,1.00,NULL,NULL,'2022-08-29 01:59:15','2022-08-29 02:06:13','2022-08-29 02:06:13',NULL),(12,7730,40720,35,NULL,57,1521,'2020-10-05',786.50,1,1.00,NULL,NULL,'2022-08-29 02:01:13','2022-08-29 02:07:43','2022-08-29 02:07:43',NULL),(13,7730,40720,37,NULL,57,1521,'2020-10-08',747.66,1,1.00,NULL,NULL,'2022-08-29 02:12:05','2022-09-02 02:02:41','2022-09-02 02:02:41',NULL),(14,7730,40720,38,NULL,57,1521,'2020-10-05',786.50,1,1.00,NULL,NULL,'2022-08-29 02:13:35','2022-09-02 02:50:52','2022-09-02 02:50:52',NULL),(15,7730,40720,39,NULL,57,1521,'2020-10-31',989.41,1,1.00,NULL,NULL,'2022-08-29 02:14:47','2022-08-29 02:15:06','2022-08-29 02:15:06',NULL),(16,7730,40720,40,NULL,57,1521,'2020-10-31',989.41,1,1.00,NULL,NULL,'2022-08-29 02:16:34','2022-09-02 02:54:54','2022-09-02 02:54:54',NULL),(17,7730,40720,59,NULL,13,1522,'2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-01 18:27:19','2022-09-01 18:29:15','2022-09-01 18:29:15',NULL),(18,7730,40720,60,NULL,13,1522,'2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-01 18:29:03','2022-09-01 18:32:07','2022-09-01 18:32:07',NULL),(19,7730,40720,61,NULL,13,1522,'2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-01 18:31:32','2022-09-01 18:51:47','2022-09-01 18:51:47',NULL),(20,7730,40720,62,NULL,13,1522,'2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 18:50:21','2022-09-01 18:50:39','2022-09-01 18:50:39',NULL),(21,7730,40720,63,NULL,13,1522,'2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-01 18:56:40','2022-09-02 04:26:39','2022-09-02 04:26:39',NULL),(22,7730,40720,64,NULL,13,1522,'2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 19:00:43','2022-09-01 19:27:11','2022-09-01 19:27:11',NULL),(23,7730,40720,65,NULL,13,1522,'2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-01 19:28:36','2022-09-02 04:26:35','2022-09-02 04:26:35',NULL),(24,7730,40720,66,NULL,13,1522,'2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 19:30:20','2022-09-02 04:26:43','2022-09-02 04:26:43',NULL),(25,7730,40720,67,NULL,13,1522,'2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 19:32:09','2022-09-01 19:32:44','2022-09-01 19:32:44',NULL),(26,7730,40720,68,NULL,13,1522,'2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-01 19:34:00','2022-09-02 04:26:47','2022-09-02 04:26:47',NULL),(27,7730,40720,69,NULL,13,1522,'2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-01 19:35:26','2022-09-02 04:26:50','2022-09-02 04:26:50',NULL),(28,7730,40720,70,NULL,13,1522,'2020-11-20',1959.00,1,1.00,NULL,NULL,'2022-09-01 19:36:21','2022-09-01 19:36:31','2022-09-01 19:36:31',NULL);
INSERT INTO `cta_cte_tesoreria` VALUES (29,7730,40720,71,NULL,13,1522,'2020-11-20',1959.00,1,1.00,NULL,NULL,'2022-09-01 19:37:39','2022-09-02 04:26:54','2022-09-02 04:26:54',NULL),(30,7730,40720,72,NULL,13,1522,'2020-11-20',11754.01,1,1.00,NULL,NULL,'2022-09-01 19:38:51','2022-09-02 04:26:58','2022-09-02 04:26:58',NULL),(31,7730,40720,73,NULL,13,1522,'2020-11-30',150.00,1,1.00,NULL,NULL,'2022-09-01 19:39:57','2022-09-02 04:27:02','2022-09-02 04:27:02',NULL),(32,7730,40720,78,NULL,57,1521,'2020-10-08',747.66,1,1.00,NULL,NULL,'2022-09-02 02:26:47','2022-09-02 02:36:33','2022-09-02 02:36:33',NULL),(33,7730,40720,91,NULL,13,1520,'2020-09-30',5272.00,1,1.00,NULL,NULL,'2022-09-02 04:48:48','2022-09-02 04:48:48',NULL,NULL),(34,7730,40720,92,NULL,13,1521,'2020-10-15',4815.00,1,1.00,NULL,NULL,'2022-09-02 04:50:02','2022-09-02 04:50:02',NULL,NULL),(35,7730,40720,93,NULL,13,1521,'2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-02 04:51:17','2022-09-02 05:10:29','2022-09-02 05:10:29',NULL),(36,7730,40720,94,NULL,13,1522,'2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-02 04:52:22','2022-09-02 04:52:22',NULL,NULL),(37,7730,40720,95,NULL,13,1522,'2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-02 04:53:18','2022-09-02 04:53:30','2022-09-02 04:53:30',NULL),(38,7730,40720,96,NULL,13,1522,'2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-02 04:54:33','2022-09-02 04:54:33',NULL,NULL),(39,7730,40720,97,NULL,13,1522,'2020-11-20',150.00,1,1.00,NULL,NULL,'2022-09-02 04:55:29','2022-09-02 04:55:29',NULL,NULL),(40,7730,40720,98,NULL,13,1522,'2020-11-20',219.00,1,1.00,NULL,NULL,'2022-09-02 04:56:45','2022-09-02 04:56:45',NULL,NULL),(41,7730,40720,99,NULL,13,1522,'2020-11-20',1959.00,1,1.00,NULL,NULL,'2022-09-02 04:57:54','2022-09-02 04:57:54',NULL,NULL),(42,7730,40720,100,NULL,13,1522,'2020-11-20',11754.01,1,1.00,NULL,NULL,'2022-09-02 04:58:54','2022-09-04 02:28:22','2022-09-04 02:28:22',NULL),(43,7730,40720,101,NULL,13,1522,'2020-11-30',150.00,1,1.00,NULL,NULL,'2022-09-02 04:59:43','2022-09-04 02:28:10','2022-09-04 02:28:10',NULL),(44,7730,40720,102,NULL,13,1522,'2020-11-03',5295.00,1,1.00,NULL,NULL,'2022-09-02 05:11:36','2022-09-02 05:11:36',NULL,NULL),(45,7730,40720,103,NULL,57,1522,'2020-11-12',1346.89,1,1.00,NULL,NULL,'2022-09-03 23:06:29','2022-09-03 23:06:29',NULL,NULL),(46,7730,40720,106,NULL,13,1522,'2020-11-20',11754.01,1,1.00,NULL,NULL,'2022-09-04 02:30:53','2022-09-04 02:30:53',NULL,NULL),(47,7730,40720,107,NULL,13,1522,'2020-11-30',150.00,1,1.00,NULL,NULL,'2022-09-04 02:32:18','2022-09-04 02:32:18',NULL,NULL),(48,7730,40720,166,NULL,13,1523,'2020-12-03',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:29:57','2022-09-04 04:29:57',NULL,NULL),(49,7730,40720,167,NULL,13,1523,'2020-12-03',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:31:28','2022-09-04 04:31:28',NULL,NULL),(50,7730,40720,168,NULL,13,1523,'2020-12-03',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:37:21','2022-09-04 04:37:21',NULL,NULL),(51,7730,40720,169,NULL,13,1523,'2020-12-04',14478.00,1,1.00,NULL,NULL,'2022-09-04 04:38:26','2022-09-04 04:38:26',NULL,NULL),(52,7730,40720,170,NULL,13,1523,'2020-12-07',8685.00,1,1.00,NULL,NULL,'2022-09-04 04:39:39','2022-09-04 04:39:39',NULL,NULL),(53,7730,40720,171,NULL,13,1523,'2020-12-07',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:40:44','2022-09-04 04:40:44',NULL,NULL),(54,7730,40720,172,NULL,13,1523,'2020-12-09',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:42:14','2022-09-04 04:42:14',NULL,NULL),(55,7730,40720,173,NULL,13,1523,'2020-12-09',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:43:40','2022-09-04 04:43:40',NULL,NULL),(56,7730,40720,174,NULL,13,1523,'2020-12-10',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:44:24','2022-09-04 04:44:24',NULL,NULL),(57,7730,40720,175,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:45:26','2022-09-04 04:45:26',NULL,NULL),(58,7730,40720,177,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:47:59','2022-09-04 04:47:59',NULL,NULL),(59,7730,40720,178,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:48:58','2022-09-04 04:48:58',NULL,NULL);
INSERT INTO `cta_cte_tesoreria` VALUES (60,7730,40720,179,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:50:16','2022-09-04 04:50:16',NULL,NULL),(61,7730,40720,180,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:51:10','2022-09-04 04:51:10',NULL,NULL),(62,7730,40720,181,NULL,13,1523,'2020-12-17',8685.00,1,1.00,NULL,NULL,'2022-09-04 04:52:07','2022-09-04 04:52:07',NULL,NULL),(63,7730,40720,182,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:53:16','2022-09-04 04:53:16',NULL,NULL),(64,7730,40720,183,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:54:08','2022-09-04 04:54:08',NULL,NULL),(65,7730,40720,184,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:55:06','2022-09-04 04:55:06',NULL,NULL),(66,7730,40720,185,NULL,13,1523,'2020-12-17',7238.99,1,1.00,NULL,NULL,'2022-09-04 04:56:15','2022-09-04 04:56:15',NULL,NULL),(67,7730,40720,186,NULL,13,1523,'2020-12-17',8685.00,1,1.00,NULL,NULL,'2022-09-04 04:57:04','2022-09-04 04:57:04',NULL,NULL),(68,7730,40720,187,NULL,13,1523,'2020-12-17',4955.00,1,1.00,NULL,NULL,'2022-09-04 04:57:56','2022-09-04 04:57:56',NULL,NULL),(69,7730,40720,188,NULL,13,1523,'2020-12-17',3880.00,1,1.00,NULL,NULL,'2022-09-04 04:58:49','2022-09-04 04:58:49',NULL,NULL),(70,7730,40720,189,NULL,13,1523,'2020-12-17',14478.00,1,1.00,NULL,NULL,'2022-09-04 04:59:44','2022-09-04 04:59:44',NULL,NULL),(71,7730,40720,190,NULL,13,1523,'2020-12-18',7238.99,1,1.00,NULL,NULL,'2022-09-04 05:00:55','2022-09-04 05:00:55',NULL,NULL),(72,7730,40720,191,NULL,13,1523,'2020-12-22',7971.00,1,1.00,NULL,NULL,'2022-09-04 05:01:50','2022-09-04 05:01:50',NULL,NULL),(73,7730,40720,192,NULL,13,1523,'2020-12-22',7238.99,1,1.00,NULL,NULL,'2022-09-04 05:02:47','2022-09-04 05:02:47',NULL,NULL),(74,7730,40720,206,NULL,57,1523,'2020-12-09',17067.75,1,1.00,NULL,NULL,'2022-09-04 05:23:20','2022-09-04 05:23:20',NULL,NULL),(75,7730,40720,208,NULL,57,1523,'2020-12-15',20000.00,1,1.00,NULL,NULL,'2022-09-04 05:34:03','2022-09-04 05:34:03',NULL,NULL),(76,7730,40720,372,NULL,13,1525,'2021-01-13',150.00,1,1.00,NULL,NULL,'2023-03-27 15:56:08','2023-03-27 15:56:08',NULL,NULL),(77,7730,40720,373,NULL,13,1525,'2021-01-14',949.00,1,1.00,NULL,NULL,'2023-03-27 15:58:45','2023-03-27 15:58:45',NULL,NULL),(78,7730,40720,374,NULL,13,1525,'2021-01-04',8090.00,1,1.00,NULL,NULL,'2023-03-27 16:00:34','2023-03-27 16:00:34',NULL,NULL),(79,7730,40720,375,NULL,13,1525,'2021-01-06',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:02:07','2023-03-27 16:02:07',NULL,NULL),(80,7730,40720,376,NULL,13,1525,'2021-01-06',9090.00,1,1.00,NULL,NULL,'2023-03-27 16:03:07','2023-03-27 16:03:07',NULL,NULL),(81,7730,40720,377,NULL,13,1525,'2021-01-06',19470.00,1,1.00,NULL,NULL,'2023-03-27 16:03:59','2023-03-27 16:03:59',NULL,NULL),(82,7730,40720,378,NULL,13,1525,'2021-01-07',150.00,1,1.00,NULL,NULL,'2023-03-27 16:05:00','2023-03-27 16:05:00',NULL,NULL),(83,7730,40720,379,NULL,13,1525,'2021-01-07',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:06:03','2023-03-27 16:06:03',NULL,NULL),(84,7730,40720,380,NULL,13,1525,'2021-01-07',150.00,1,1.00,NULL,NULL,'2023-03-27 16:06:54','2023-03-27 16:06:54',NULL,NULL),(85,7730,40720,381,NULL,13,1525,'2021-01-07',150.00,1,1.00,NULL,NULL,'2023-03-27 16:07:35','2023-03-27 16:07:35',NULL,NULL),(86,7730,40720,382,NULL,13,1525,'2021-01-12',150.00,1,1.00,NULL,NULL,'2023-03-27 16:08:33','2023-03-27 16:08:33',NULL,NULL),(87,7730,40720,383,NULL,13,1525,'2021-01-12',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:09:12','2023-03-27 16:09:12',NULL,NULL),(88,7730,40720,384,NULL,13,1525,'2021-01-13',150.00,1,1.00,NULL,NULL,'2023-03-27 16:09:56','2023-03-27 16:09:56',NULL,NULL),(89,7730,40720,385,NULL,13,1525,'2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:11:16','2023-03-27 16:11:16',NULL,NULL),(90,7730,40720,386,NULL,13,1525,'2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:11:52','2023-03-27 16:11:52',NULL,NULL),(91,7730,40720,387,NULL,13,1525,'2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:12:34','2023-03-27 16:12:34',NULL,NULL);
INSERT INTO `cta_cte_tesoreria` VALUES (92,7730,40720,388,NULL,13,1525,'2021-01-14',1379.00,1,1.00,NULL,NULL,'2023-03-27 16:13:20','2023-03-27 16:13:20',NULL,NULL),(93,7730,40720,389,NULL,13,1525,'2021-01-18',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:14:22','2023-03-27 16:14:22',NULL,NULL),(94,7730,40720,390,NULL,13,1525,'2021-01-18',7819.00,1,1.00,NULL,NULL,'2023-03-27 16:16:08','2023-03-27 16:16:08',NULL,NULL),(95,7730,40720,391,NULL,13,1525,'2021-01-19',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:17:14','2023-03-27 16:17:14',NULL,NULL),(96,7730,40720,392,NULL,13,1525,'2021-01-19',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:18:43','2023-03-27 16:18:43',NULL,NULL),(97,7730,40720,393,NULL,13,1525,'2021-01-20',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:19:37','2023-03-27 16:19:37',NULL,NULL),(98,7730,40720,394,NULL,13,1525,'2021-01-20',8685.00,1,1.00,NULL,NULL,'2023-03-27 16:20:30','2023-03-27 16:20:30',NULL,NULL),(99,7730,40720,395,NULL,13,1525,'2021-01-21',8685.00,1,1.00,NULL,NULL,'2023-03-27 16:21:24','2023-03-27 16:21:24',NULL,NULL),(100,7730,40720,396,NULL,13,1525,'2021-01-22',300.00,1,1.00,NULL,NULL,'2023-03-27 16:30:20','2023-03-27 16:30:20',NULL,NULL),(101,7730,40720,397,NULL,13,1525,'2021-01-25',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:31:13','2023-03-27 16:31:13',NULL,NULL),(102,7730,40720,398,NULL,13,1525,'2021-01-25',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:32:13','2023-03-27 16:32:13',NULL,NULL),(103,7730,40720,399,NULL,13,1525,'2021-01-25',8685.00,1,1.00,NULL,NULL,'2023-03-27 16:33:00','2023-03-27 16:33:00',NULL,NULL),(104,7730,40720,400,NULL,13,1525,'2021-01-26',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:33:48','2023-03-27 16:33:48',NULL,NULL),(105,7730,40720,401,NULL,13,1525,'2021-01-26',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:34:55','2023-03-27 16:34:55',NULL,NULL),(106,7730,40720,402,NULL,13,1525,'2021-01-26',6490.00,1,1.00,NULL,NULL,'2023-03-27 16:38:54','2023-03-27 16:38:54',NULL,NULL),(107,7730,40720,403,NULL,13,1525,'2021-01-26',8685.00,1,1.00,NULL,NULL,'2023-03-27 16:39:47','2023-03-27 16:39:47',NULL,NULL),(108,7730,40720,404,NULL,13,1525,'2021-01-28',7590.00,1,1.00,NULL,NULL,'2023-03-27 16:40:40','2023-03-27 16:40:40',NULL,NULL),(109,7730,40720,405,NULL,13,1525,'2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:43:44','2023-03-27 16:43:44',NULL,NULL),(110,7730,40720,406,NULL,13,1525,'2021-01-26',6799.00,1,1.00,NULL,NULL,'2023-03-27 16:45:38','2023-03-27 16:45:38',NULL,NULL),(111,7730,40720,407,NULL,13,1525,'2021-01-27',40794.00,1,1.00,NULL,NULL,'2023-03-27 16:47:49','2023-03-27 16:47:49',NULL,NULL),(112,7730,40720,408,NULL,13,1525,'2021-01-14',150.00,1,1.00,NULL,NULL,'2023-03-27 16:54:51','2023-03-27 16:54:51',NULL,NULL),(113,7730,40720,409,NULL,57,1525,'2021-01-04',36966.12,1,1.00,'Transferencia realizada por 50000.00',NULL,'2023-03-27 18:30:31','2023-03-28 17:17:32','2023-03-28 17:17:32',NULL),(114,7730,40720,410,NULL,57,1525,'2021-01-29',137498.23,1,1.00,NULL,NULL,'2023-03-27 18:58:21','2023-03-27 18:58:21',NULL,NULL),(115,7730,40720,412,NULL,57,1525,'2021-01-31',40365.09,1,1.00,NULL,NULL,'2023-03-28 12:20:13','2023-03-28 13:21:24','2023-03-28 13:21:24',NULL),(116,7730,40720,413,NULL,57,1525,'2021-01-31',1206.09,1,1.00,NULL,NULL,'2023-03-28 12:22:21','2023-03-28 12:42:47','2023-03-28 12:42:47',NULL),(117,7730,40720,414,NULL,57,1525,'2021-01-31',3298.43,1,1.00,NULL,NULL,'2023-03-28 12:24:10','2023-03-28 12:24:10',NULL,NULL),(118,7730,40720,415,NULL,57,1525,'2021-01-22',20000.00,1,1.00,NULL,NULL,'2023-03-28 12:40:44','2023-03-28 12:40:44',NULL,NULL),(119,7730,40720,416,NULL,57,1525,'2021-01-31',1206.09,1,1.00,NULL,NULL,'2023-03-28 12:46:41','2023-03-28 12:46:41',NULL,NULL),(120,7730,40720,421,NULL,57,1525,'2021-01-31',40365.09,1,1.00,NULL,NULL,'2023-03-28 13:26:34','2023-03-28 14:25:03','2023-03-28 14:25:03',NULL),(121,7730,40720,423,NULL,57,1525,'2021-01-31',39160.19,1,1.00,NULL,NULL,'2023-03-28 14:38:52','2023-03-28 14:38:52',NULL,NULL),(122,7730,40720,470,NULL,13,1526,'2021-02-01',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:45:24','2023-03-28 15:45:24',NULL,NULL);
INSERT INTO `cta_cte_tesoreria` VALUES (123,7730,40720,471,NULL,13,1526,'2021-02-02',7919.00,1,1.00,NULL,NULL,'2023-03-28 15:49:20','2023-03-28 15:49:20',NULL,NULL),(124,7730,40720,472,NULL,13,1526,'2021-02-02',8557.00,1,1.00,NULL,NULL,'2023-03-28 15:50:10','2023-03-28 15:50:10',NULL,NULL),(125,7730,40720,473,NULL,13,1526,'2021-02-02',12980.00,1,1.00,NULL,NULL,'2023-03-28 15:51:22','2023-03-28 15:51:22',NULL,NULL),(126,7730,40720,474,NULL,13,1526,'2021-02-02',7590.00,1,1.00,NULL,NULL,'2023-03-28 15:52:07','2023-03-28 15:52:07',NULL,NULL),(127,7730,40720,475,NULL,13,1526,'2021-02-02',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:52:50','2023-03-28 15:52:50',NULL,NULL),(128,7730,40720,476,NULL,13,1526,'2021-02-09',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:53:55','2023-03-28 15:53:55',NULL,NULL),(129,7730,40720,477,NULL,13,1526,'2021-02-10',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:54:34','2023-03-28 15:54:34',NULL,NULL),(130,7730,40720,478,NULL,13,1526,'2021-02-10',27770.00,1,1.00,NULL,NULL,'2023-03-28 15:55:24','2023-03-28 15:55:24',NULL,NULL),(131,7730,40720,479,NULL,13,1526,'2021-02-10',7919.00,1,1.00,NULL,NULL,'2023-03-28 15:56:05','2023-03-28 15:56:05',NULL,NULL),(132,7730,40720,480,NULL,13,1526,'2021-02-12',9990.00,1,1.00,NULL,NULL,'2023-03-28 15:56:48','2023-03-28 15:56:48',NULL,NULL),(133,7730,40720,481,NULL,13,1526,'2021-02-18',3400.00,1,1.00,NULL,NULL,'2023-03-28 15:57:28','2023-03-28 15:57:28',NULL,NULL),(134,7730,40720,482,NULL,13,1526,'2021-02-18',12740.00,1,1.00,NULL,NULL,'2023-03-28 16:00:04','2023-03-28 16:00:04',NULL,NULL),(135,7730,40720,483,NULL,13,1526,'2021-02-19',9990.00,1,1.00,NULL,NULL,'2023-03-28 16:00:52','2023-03-28 16:00:52',NULL,NULL),(136,7730,40720,484,NULL,13,1526,'2021-02-10',7990.00,1,1.00,NULL,NULL,'2023-03-28 16:01:53','2023-03-28 16:01:53',NULL,NULL),(137,7730,40720,485,NULL,13,1526,'2021-02-22',9490.50,1,1.00,NULL,NULL,'2023-03-28 16:02:38','2023-03-28 16:02:38',NULL,NULL),(138,7730,40720,486,NULL,13,1526,'2021-02-10',17780.00,1,1.00,NULL,NULL,'2023-03-28 16:03:43','2023-03-28 16:03:43',NULL,NULL),(139,7730,40720,487,NULL,13,1526,'2021-02-18',7990.00,1,1.00,NULL,NULL,'2023-03-28 16:04:41','2023-03-28 16:04:41',NULL,NULL),(140,7730,40720,505,NULL,57,1526,'2021-02-28',42059.18,1,1.00,NULL,NULL,'2023-03-28 16:17:50','2023-03-28 16:17:50',NULL,NULL),(141,7730,40720,NULL,NULL,760,1557,'2023-03-28',0.00,1,1.00,'Saldo Inicial',NULL,'2023-03-28 16:19:07','2023-03-28 16:19:07',NULL,NULL),(142,7730,40720,506,NULL,57,1526,'2021-02-28',20000.00,1,1.00,NULL,NULL,'2023-03-28 16:20:44','2023-03-28 16:20:44',NULL,NULL),(143,7730,40720,507,NULL,13,1526,'2021-02-28',1206.09,1,1.00,NULL,NULL,'2023-03-28 16:21:40','2023-03-28 16:45:54','2023-03-28 16:45:54',NULL),(144,7730,40720,508,NULL,57,1526,'2021-02-28',1206.09,1,1.00,NULL,NULL,'2023-03-28 16:46:32','2023-03-28 16:46:32',NULL,NULL),(145,7730,40720,509,NULL,57,1525,'2021-01-04',50000.00,1,1.00,NULL,NULL,'2023-03-28 17:19:46','2023-03-28 17:19:46',NULL,NULL),(146,7730,40720,510,NULL,57,1526,'2021-02-17',90000.00,1,1.00,NULL,NULL,'2023-03-28 17:23:20','2023-03-28 17:23:20',NULL,NULL),(147,7730,40720,534,NULL,13,1527,'2021-03-01',8800.00,1,1.00,NULL,NULL,'2023-03-29 10:50:15','2023-03-29 10:50:15',NULL,NULL),(148,7730,40720,535,NULL,13,1527,'2021-03-02',7990.00,1,1.00,NULL,NULL,'2023-03-29 10:53:20','2023-03-29 10:53:20',NULL,NULL),(149,7730,40720,536,NULL,13,1527,'2021-03-02',2397.00,1,1.00,NULL,NULL,'2023-03-29 11:05:46','2023-03-29 11:05:46',NULL,NULL),(150,7730,40720,538,NULL,13,1527,'2021-03-05',7830.00,1,1.00,NULL,NULL,'2023-03-29 11:22:52','2023-03-29 11:22:52',NULL,NULL),(151,7730,40720,540,NULL,13,1527,'2021-03-05',1500.00,1,1.00,NULL,NULL,'2023-03-29 11:23:16','2023-03-29 11:23:16',NULL,NULL),(152,7730,40720,542,NULL,13,1527,'2021-03-05',7990.00,1,1.00,NULL,NULL,'2023-03-29 11:23:50','2023-03-29 11:23:50',NULL,NULL),(153,7730,40720,568,NULL,57,1527,'2021-03-02',20000.00,1,1.00,NULL,NULL,'2023-03-29 13:07:13','2023-03-29 13:07:13',NULL,NULL);
INSERT INTO `cta_cte_tesoreria` VALUES (154,7730,40720,570,NULL,57,1527,'2021-03-29',31867.42,1,1.00,NULL,NULL,'2023-03-29 13:07:54','2023-03-29 13:07:54',NULL,NULL),(155,7730,40720,572,NULL,57,1527,'2021-03-03',11721.00,1,1.00,NULL,NULL,'2023-03-29 13:09:36','2023-03-29 13:09:36',NULL,NULL),(156,7730,40720,574,NULL,57,1527,'2021-03-05',67248.27,1,1.00,NULL,NULL,'2023-03-29 13:12:50','2023-03-29 13:19:28','2023-03-29 13:19:28',NULL),(157,7730,40720,576,NULL,57,1527,'2021-03-31',1206.09,1,1.00,NULL,NULL,'2023-03-29 13:14:05','2023-03-29 14:54:23','2023-03-29 14:54:23',NULL),(158,7730,40720,578,NULL,57,1527,'2021-03-05',67248.27,1,1.00,NULL,NULL,'2023-03-29 13:21:21','2023-03-29 13:21:21',NULL,NULL),(159,7730,40720,580,NULL,57,1525,'2021-01-10',1513750.00,1,1.00,NULL,NULL,'2023-03-29 13:30:40','2023-03-29 14:02:04','2023-03-29 14:02:04',NULL),(160,7730,40720,582,NULL,57,1527,'2021-03-31',1206.09,1,1.00,NULL,NULL,'2023-03-29 14:56:01','2023-03-29 14:56:01',NULL,NULL),(161,7730,40720,585,NULL,57,1528,'2021-05-10',1206.09,1,1.00,NULL,NULL,'2023-03-29 17:36:56','2023-03-29 18:41:50','2023-03-29 18:41:50',NULL),(162,7730,40720,588,NULL,57,1529,'2021-05-31',1206.09,1,1.00,NULL,NULL,'2023-03-29 18:42:54','2023-03-29 18:42:54',NULL,NULL),(163,7730,40720,592,NULL,57,1530,'2021-06-10',261.88,1,1.00,NULL,NULL,'2023-03-29 20:05:20','2023-03-29 20:05:20',NULL,NULL),(164,7730,40720,596,NULL,57,1531,'2021-07-10',1528.76,1,1.00,NULL,NULL,'2023-03-29 20:20:24','2023-03-29 20:20:24',NULL,NULL),(165,7730,40720,597,NULL,57,1532,'2021-08-10',366.63,1,1.00,NULL,NULL,'2023-03-29 20:37:23','2023-03-29 20:37:23',NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_banco_cheq` VALUES (1,NULL,40720,758,1,1,'T',1541545,1,'2023-03-27 00:07:49','2023-03-27 00:07:49',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_claves`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_claves_person_id_foreign` (`person_id`),
  KEY `ct_cuenta_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_banco_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_banco_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuenta_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_claves_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_claves`
--

LOCK TABLES `cta_cte_tesoreria_banco_claves` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `persona_empresa` int(11) NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `alias` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_bancos` VALUES (1,NULL,40720,758,1,1,22,497,497,497,'015-Ejemplo','1234567890123456789012',NULL,1,'2023-03-27 00:07:49','2023-03-27 00:07:49',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES',1,NULL,NULL,NULL),(5,NULL,'PERCEPCIONES',1,NULL,NULL,NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=761 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,'Clientes - Deudores',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,'Anticipos Impuesto a las Ganancias',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,'Retenciones Impuesto a las Ganancias',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(25,NULL,1,25,NULL,4,'Retenciones de IVA',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(57,NULL,1,57,NULL,8,'Proveedores en Cta. Cte. locales',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,'Cheques emitidos ',NULL,0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(62,NULL,1,62,NULL,8,'Sueldos y Jornales a pagar',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,'Intereses y Gastos bancarios',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(162,NULL,1,162,NULL,4,'Retenciones SUSS',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(176,NULL,1,176,NULL,3,'Cheques en Cartera',NULL,1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(201,NULL,1,201,NULL,6,'Monotributo',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(203,NULL,1,203,NULL,6,'Autonomos',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(219,NULL,1,219,NULL,8,'Pagos AFIP',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,'Retenciones de IIBB Buenos Aires',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(252,NULL,1,252,NULL,4,'Retenciones de IIBB Capital Federal',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(253,NULL,1,253,NULL,4,'Retenciones de IIBB Catamarca',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(254,NULL,1,254,NULL,4,'Retenciones de IIBB Chaco',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(255,NULL,1,255,NULL,4,'Retenciones de IIBB Chubut',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(256,NULL,1,256,NULL,4,'Retenciones de IIBB Córdoba',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(257,NULL,1,257,NULL,4,'Retenciones de IIBB Corrientes',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(258,NULL,1,258,NULL,4,'Retenciones de IIBB Entre Ríos',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(259,NULL,1,259,NULL,4,'Retenciones de IIBB Formosa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(260,NULL,1,260,NULL,4,'Retenciones de IIBB Jujuy',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(261,NULL,1,261,NULL,4,'Retenciones de IIBB La Pampa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(262,NULL,1,262,NULL,4,'Retenciones de IIBB La Rioja',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(263,NULL,1,263,NULL,4,'Retenciones de IIBB Mendoza',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(264,NULL,1,264,NULL,4,'Retenciones de IIBB Misiones',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(265,NULL,1,265,NULL,4,'Retenciones de IIBB Neuquén',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(266,NULL,1,266,NULL,4,'Retenciones de IIBB Pascua Lama',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(267,NULL,1,267,NULL,4,'Retenciones de IIBB Río Negro',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(268,NULL,1,268,NULL,4,'Retenciones de IIBB Salta',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(269,NULL,1,269,NULL,4,'Retenciones de IIBB San Juan',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(270,NULL,1,270,NULL,4,'Retenciones de IIBB San Luis',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (271,NULL,1,271,NULL,4,'Retenciones de IIBB Santa Cruz',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(272,NULL,1,272,NULL,4,'Retenciones de IIBB Santa Fe',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(273,NULL,1,273,NULL,4,'Retenciones de IIBB Santiago del Estero',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(274,NULL,1,274,NULL,4,'Retenciones de IIBB Tierra del Fuego',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(275,NULL,1,275,NULL,4,'Retenciones de IIBB Tucuman',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(351,NULL,1,351,NULL,8,'BANCO SIRCREB',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,'Caja en Pesos',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:14:12','2023-03-20 23:14:12'),(360,NULL,1,360,NULL,8,'Retenciones Bancarias de Ganancias a Favor',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,'Anticipo de Clientes',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,'Caja en Dolares',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:14:12','2023-03-20 23:14:12'),(409,NULL,1,409,NULL,6,'IVA Crédito Fiscal No computable',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(418,NULL,1,418,NULL,8,'Deudas Bancarias',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,'Préstamo',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,1,441,NULL,8,'Leasing',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,1,448,NULL,8,'Planes de Pagos AFIP',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,1,450,NULL,3,'Cheques Rechazados',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(467,NULL,1,467,NULL,6,'Interés',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:07:48',NULL),(468,NULL,1,14,NULL,8,'Deudores por ventas comunes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(469,NULL,1,15,NULL,8,'Deudores por ventas morosos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(470,NULL,1,16,NULL,8,'Deudores en gestión judicial',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(471,NULL,1,17,NULL,8,'Previsión deudores incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(472,NULL,1,22,NULL,8,'Anticipo Impto.Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(473,NULL,1,24,NULL,4,'Impuesto a las Ganancias (Saldo a favor)',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:54:48',NULL),(474,NULL,1,27,NULL,8,'Anticipos de proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(475,NULL,1,28,NULL,8,'Depósito en garantía alquileres',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(476,NULL,1,29,NULL,8,'Derechos adquiridos a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(477,NULL,1,30,NULL,8,'Intereses a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(478,NULL,1,31,NULL,8,'Cuentas a rendir - Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(479,NULL,1,32,NULL,8,'Alquileres no devengados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(480,NULL,1,38,NULL,8,'Equipos de computación valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(481,NULL,1,39,NULL,8,'Equipos de computación ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(482,NULL,1,40,NULL,8,'Amortización Acumulada Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (483,NULL,1,42,NULL,8,'Instalaciones valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(484,NULL,1,43,NULL,8,'Instalaciones ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(485,NULL,1,44,NULL,8,'Amortización Acumulada Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(486,NULL,1,46,NULL,8,'Muebles y utiles valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(487,NULL,1,47,NULL,8,'Muebles y utiles ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(488,NULL,1,48,NULL,8,'Amortización Acumulada Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(489,NULL,1,50,NULL,8,'Gastos de organización valores historicos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(490,NULL,1,51,NULL,8,'Gastos de organización ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(491,NULL,1,52,NULL,8,'Amortización acumulada gs. de organización',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(492,NULL,1,58,NULL,8,'Proveedores en cta. cte. exterior',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(493,NULL,1,59,NULL,8,'Derechos de exhibición a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(494,NULL,1,63,NULL,8,'Cargas sociales a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(495,NULL,1,64,NULL,8,'Sindicatos a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(496,NULL,1,67,NULL,8,'IVA Debito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(497,NULL,1,68,NULL,8,'IVA Credito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(498,NULL,1,69,NULL,8,'Impuestos Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(499,NULL,1,70,NULL,8,'Impuestos al Combustible',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(500,NULL,1,71,NULL,8,'IVA Retenciones de terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(501,NULL,1,72,NULL,5,'IVA Percepciones realiz.por terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(502,NULL,1,73,NULL,8,'IVA Saldo a favor',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(503,NULL,1,74,NULL,8,'IVA a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(504,NULL,1,75,NULL,5,'Percepciones Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(505,NULL,1,76,NULL,8,'Otros Pagos AFIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(506,NULL,1,78,NULL,8,'Impuesto a los Ingresos Brutos Pasivo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(507,NULL,1,79,NULL,8,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(508,NULL,1,80,NULL,8,'Impuesto a la Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(509,NULL,1,81,NULL,8,'AFIP - Retenciones Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(510,NULL,1,82,NULL,8,'AFIP - Plan de Facilidades Decreto 338/02',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(511,NULL,1,87,NULL,8,'Acciones en circulación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(512,NULL,1,88,NULL,8,'Ajuste del Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(513,NULL,1,89,NULL,8,'Aportes Irrevocables Futuras Suscripciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(514,NULL,1,91,NULL,8,'Resultado del ejercicio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (515,NULL,1,92,NULL,8,'Resultado ejercicios anteriores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(516,NULL,1,93,NULL,8,'A.R.E.A.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(517,NULL,1,96,NULL,7,'VENTAS',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(518,NULL,1,97,NULL,7,'Honorarios',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(519,NULL,1,99,NULL,7,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(520,NULL,1,100,NULL,7,'Reintegros por exportaciones',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(521,NULL,1,102,NULL,7,'Intereses Cobrados',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(522,NULL,1,103,NULL,7,'Diferencias de cambio',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(523,NULL,1,104,NULL,7,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(524,NULL,1,110,NULL,6,'Sueldos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(525,NULL,1,111,NULL,6,'Contribuciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(526,NULL,1,112,NULL,6,'Sindicato',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(527,NULL,1,114,NULL,8,'ACA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(528,NULL,1,115,NULL,6,'Aereos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(529,NULL,1,116,NULL,6,'Alquiler',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(530,NULL,1,117,NULL,8,'AGUA AYSA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(531,NULL,1,118,NULL,8,'TV Cablevision',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(532,NULL,1,119,NULL,1,'Caja Jubilacion Consejo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(533,NULL,1,120,NULL,6,'Celulares',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(534,NULL,1,121,NULL,3,'Cheques',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(535,NULL,1,123,NULL,8,'Comida',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(536,NULL,1,126,NULL,6,'Fletes y acarreos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(537,NULL,1,127,NULL,8,'Luz Edesur',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(538,NULL,1,128,NULL,6,'Movilidad y Viáticos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(539,NULL,1,129,NULL,8,'Mantenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(540,NULL,1,130,NULL,8,'IVA No Computable',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(541,NULL,1,131,NULL,8,'Entretenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(542,NULL,1,132,NULL,6,'Amortización Bienes de Uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(543,NULL,1,135,NULL,6,'Gastos varios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(544,NULL,1,136,NULL,6,'Ajuste por redondeo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(545,NULL,1,137,NULL,6,'Deudores Incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(546,NULL,1,141,NULL,6,'Intereses Proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(547,NULL,1,143,NULL,6,'Diferencias de cambio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(548,NULL,1,144,NULL,8,'Diferencia de Cambio Bces. en M.Extranjera',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(549,NULL,1,145,NULL,6,'Diferencia tipo cambio Vendedor/Comprador',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (550,NULL,1,146,NULL,8,'Diferencia por conversion en Bce. en Mon. Extranj.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(551,NULL,1,147,NULL,8,'Diferencia de cambio CMV',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(552,NULL,1,148,NULL,8,'Diferencia de cambio PT',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(553,NULL,1,149,NULL,8,'Resultado por Exposición a la Inflación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(554,NULL,1,150,NULL,8,'Diferencia de cambio PE',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(555,NULL,1,151,NULL,8,'Diferencia de cambio Ds.Vtas.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(556,NULL,1,152,NULL,6,'Diferencia de cambio ME',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(557,NULL,1,153,NULL,6,'Descuentos otorgados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(558,NULL,1,155,NULL,6,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(559,NULL,1,156,NULL,6,'Impuesto a los Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(560,NULL,1,157,NULL,6,'Impuesto al Debito y Credito Bancario',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(561,NULL,1,159,NULL,6,'Pérdida por venta bienes de uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(562,NULL,1,160,NULL,6,'Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(563,NULL,1,161,NULL,6,'Amortizaciones extraordinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(564,NULL,1,178,NULL,8,'Google',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(565,NULL,1,188,NULL,6,'Publicidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(566,NULL,1,191,NULL,6,'Cargas Sociales',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(567,NULL,1,192,NULL,6,'Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(568,NULL,1,193,NULL,6,'Telefono Fijo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(569,NULL,1,198,NULL,6,'Seguros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(570,NULL,1,199,NULL,6,'Internet',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(571,NULL,1,204,NULL,6,'Multas Impositivas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(572,NULL,1,208,NULL,6,'Impuesto a los Ingresos Brutos - BS AS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(573,NULL,1,209,NULL,6,'SIRCREB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(574,NULL,1,212,NULL,6,'Tarjeta Visa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(575,NULL,1,213,NULL,6,'Tarjeta American Express',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(576,NULL,1,214,NULL,6,'Tarjeta Mastercard',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(577,NULL,1,215,NULL,8,'Tarjeta Shopping',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(578,NULL,1,216,NULL,6,'Tarjeta Cencosud',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(579,NULL,1,217,NULL,6,'Compras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(580,NULL,1,218,NULL,7,'Ventas No Gravadas',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(581,NULL,1,220,NULL,5,'Perc IVA -RG3337',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:54:48',NULL),(582,NULL,1,221,NULL,6,'Imps. Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(583,NULL,1,222,NULL,6,'Imp. Gasoil',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (584,NULL,1,223,NULL,6,'Imp. Hídricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(585,NULL,1,224,NULL,6,'ITC',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(586,NULL,1,225,NULL,5,'Perc IIBB  Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(587,NULL,1,226,NULL,5,'Perc IIBB  Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(588,NULL,1,227,NULL,5,'Perc IIBB  Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(589,NULL,1,228,NULL,5,'Perc IIBB  Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(590,NULL,1,229,NULL,5,'Perc IIBB  Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(591,NULL,1,230,NULL,5,'Perc IIBB  Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(592,NULL,1,231,NULL,5,'Perc IIBB  Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(593,NULL,1,232,NULL,5,'Perc IIBB  Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(594,NULL,1,233,NULL,5,'Perc IIBB  Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(595,NULL,1,234,NULL,5,'Perc IIBB  Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(596,NULL,1,235,NULL,5,'Perc IIBB  La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(597,NULL,1,236,NULL,5,'Perc IIBB  La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(598,NULL,1,237,NULL,5,'Perc IIBB  Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(599,NULL,1,238,NULL,5,'Perc IIBB  Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(600,NULL,1,239,NULL,5,'Perc IIBB  Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(601,NULL,1,240,NULL,5,'Perc IIBB  Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(602,NULL,1,241,NULL,5,'Perc IIBB  Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(603,NULL,1,242,NULL,5,'Perc IIBB  Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(604,NULL,1,243,NULL,5,'Perc IIBB  San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(605,NULL,1,244,NULL,5,'Perc IIBB  San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(606,NULL,1,245,NULL,5,'Perc IIBB  Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(607,NULL,1,246,NULL,5,'Perc IIBB  Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(608,NULL,1,247,NULL,5,'Perc IIBB  Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(609,NULL,1,248,NULL,5,'Perc IIBB  Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(610,NULL,1,249,NULL,5,'Perc IIBB  Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(611,NULL,1,250,NULL,6,'Compras No Gravadas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(612,NULL,1,276,NULL,6,'SIRCREB Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(613,NULL,1,277,NULL,6,'SIRCREB Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(614,NULL,1,278,NULL,6,'SIRCREB Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(615,NULL,1,279,NULL,6,'SIRCREB Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(616,NULL,1,280,NULL,6,'SIRCREB Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(617,NULL,1,281,NULL,6,'SIRCREB Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(618,NULL,1,282,NULL,6,'SIRCREB Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (619,NULL,1,283,NULL,6,'SIRCREB Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(620,NULL,1,284,NULL,6,'SIRCREB Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(621,NULL,1,285,NULL,6,'SIRCREB Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(622,NULL,1,286,NULL,6,'SIRCREB La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(623,NULL,1,287,NULL,6,'SIRCREB La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(624,NULL,1,288,NULL,6,'SIRCREB Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(625,NULL,1,289,NULL,6,'SIRCREB Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(626,NULL,1,290,NULL,6,'SIRCREB Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(627,NULL,1,291,NULL,6,'SIRCREB Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(628,NULL,1,292,NULL,6,'SIRCREB Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(629,NULL,1,293,NULL,6,'SIRCREB Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(630,NULL,1,294,NULL,6,'SIRCREB San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(631,NULL,1,295,NULL,6,'SIRCREB San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(632,NULL,1,296,NULL,6,'SIRCREB Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(633,NULL,1,297,NULL,6,'SIRCREB Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(634,NULL,1,298,NULL,6,'SIRCREB Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(635,NULL,1,299,NULL,6,'SIRCREB Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',NULL),(636,NULL,1,300,NULL,6,'SIRCREB Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:07:48',N