-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-35171328-4
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-09 07:37:14','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-09 07:37:14','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'AFIP MABEL','Mabelsastre3105','ALEXIS SIRIO',1,40720,'2022-08-16'),(2,'AFIP MABEL','Mabelsastre3105','ALEXIS SIRIO',1,40720,'2022-08-16'),(3,'Clave AFIP','Pamela#3683','MU',1,42285,'2022-08-16'),(4,'Clave AFIP','Pamela#3683','MU',1,42285,'2022-08-16'),(5,'Clave AGIP','Shopfer3291','MU',2,42285,'2022-08-16'),(6,'Clave AFIP','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(7,'Clave AGIP','Shopfer3291','MU',2,42285,'2022-08-16'),(8,'Clave AFIP','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(9,'Clave AGIP','Shopfer3291','MU',2,42285,'2022-08-16'),(10,'Clave AFIP','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(11,'Clave AGIP','Shopfer3291','MU',2,42285,'2022-08-16'),(12,'Clave AFIP','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(13,'Clave AGIP','Shopfer3291','MU',2,42285,'2022-08-16'),(14,'Clave AFIP','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(15,'Clave AGIP','Shopfer3291','MU',2,42285,'2022-08-16'),(16,'Clave fiscal','Pamela#3683',NULL,2,42297,'2022-08-16'),(17,'Clave AGIP','Shopfer3291',NULL,2,42297,'2022-08-16'),(18,'Clave AFIP','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(19,'Clave AGIP','Shopfer3291','MU',2,42285,'2022-08-16'),(20,'Clave fiscal','Pamela#3683',NULL,1,42285,'2022-08-16'),(21,'Clave AGIP','Shopfer3291',NULL,2,42285,'2022-08-16'),(22,'Clave fiscal','Pamela#3683',NULL,2,42297,'2022-08-16'),(23,'Clave AGIP','Shopfer3291',NULL,2,42297,'2022-08-16'),(24,'Clave fiscal','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(25,'Clave AGIP','Shopfer3291',NULL,2,42285,'2022-08-16'),(26,'Clave fiscal','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(27,'Clave AGIP','Shopfer3291',NULL,2,42285,'2022-08-16'),(28,'Clave fiscal','Pamela#3683','Matias Usinger',1,42285,'2022-08-16'),(29,'Clave AGIP','Shopfer3291',NULL,2,42285,'2022-08-16'),(30,'Clave fiscal','Pamela#3683',NULL,2,42297,'2022-08-16'),(31,'Clave AGIP','Shopfer3291',NULL,2,42297,'2022-08-16'),(32,'AFIP MABEL','Mabelsastre3105','ALEXIS SIRIO',1,40720,'2022-08-16'),(33,'AFIP MABEL','Mabelsastre3105','ALEXIS SIRIO',1,40720,'2022-08-18'),(34,'AFIP MABEL','Mabelsastre3105','ALEXIS SIRIO',1,40720,'2022-08-18'),(35,'AFIP MABEL','Mabelsastre3105','ALEXIS SIRIO',1,40720,'2022-08-29'),(36,NULL,'SASTRE14',NULL,2,40720,'2022-08-29');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'admin@catalanashoes.com','1160006512','ALEXIS SIRIO',1,40720,'2022-08-16'),(2,'admin@catalanashoes.com','1160006512','ALEXIS SIRIO',1,40720,'2022-08-16'),(3,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(4,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(5,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(6,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(7,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(8,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(9,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(10,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(11,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(12,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(13,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(14,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(15,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(16,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(17,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(18,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(19,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-16'),(20,'admin@catalanashoes.com','1160006512','ALEXIS SIRIO',1,40720,'2022-08-16'),(21,'alesirio2015@gmail.com','1160006512',NULL,1,40719,'2022-08-16'),(22,'alesirio2015@gmail.com','1160006512','',1,40719,'2022-08-16'),(23,'matias.usinger@shopferretero.com.ar','11 5661-5470','Matias Usinger',1,42285,'2022-08-17'),(24,'admin@catalanashoes.com','1160006512','ALEXIS SIRIO',1,40720,'2022-08-18'),(25,'admin@catalanashoes.com','1160006512','ALEXIS SIRIO',1,40720,'2022-08-18'),(26,'admin@catalanashoes.com','1160006512','ALEXIS SIRIO',1,40720,'2022-08-29');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7637 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7523,40720,1518,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2400.00,NULL,NULL,1,'2022-08-16 15:07:23','2022-08-16 15:41:33','2022-08-16 15:41:33'),(758,NULL,40720,1518,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2400.00,NULL,NULL,1,'2022-08-16 15:48:33','2022-08-16 15:48:33',NULL),(759,NULL,40720,1518,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3510.00,NULL,NULL,1,'2022-08-16 15:48:33','2022-08-16 15:48:33',NULL),(760,NULL,40720,1518,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4199.99,NULL,NULL,1,'2022-08-16 15:48:33','2022-08-16 15:48:33',NULL),(761,NULL,40720,1518,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',10450.00,NULL,NULL,1,'2022-08-16 15:48:33','2022-08-16 15:48:33',NULL),(762,NULL,40720,1518,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3200.00,NULL,NULL,1,'2022-08-16 15:48:33','2022-08-16 15:48:33',NULL),(763,NULL,40720,1518,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5175.00,NULL,NULL,1,'2022-08-16 15:48:33','2022-08-16 15:48:33',NULL),(764,NULL,40720,1518,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4500.00,NULL,NULL,1,'2022-08-16 15:48:33','2022-08-16 15:48:33',NULL),(765,NULL,40720,1518,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4800.00,NULL,NULL,1,'2022-08-16 15:48:33','2022-08-16 15:48:33',NULL),(766,NULL,40720,1518,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4500.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(767,NULL,40720,1518,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4500.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(768,NULL,40720,1518,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4500.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(769,NULL,40720,1518,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4970.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(770,NULL,40720,1518,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5175.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(771,NULL,40720,1518,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4900.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(772,NULL,40720,1518,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4900.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(773,NULL,40720,1518,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',18530.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(774,NULL,40720,1518,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4540.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(775,NULL,40720,1518,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4950.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(776,NULL,40720,1518,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4500.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(777,NULL,40720,1518,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',9959.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(778,NULL,40720,1518,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4199.99,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(779,NULL,40720,1518,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',1120.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(780,NULL,40720,1518,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4500.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(781,NULL,40720,1518,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4500.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL);
INSERT INTO `balance_libro` VALUES (782,NULL,40720,1518,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4600.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(783,NULL,40720,1518,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4531.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(784,NULL,40720,1518,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',5520.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(785,NULL,40720,1518,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',3000.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(786,NULL,40720,1518,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',2300.00,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(787,NULL,40720,1518,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4199.99,NULL,NULL,1,'2022-08-16 15:48:34','2022-08-16 15:48:34',NULL),(788,NULL,40720,1518,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4900.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(789,NULL,40720,1518,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',18680.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(790,NULL,40720,1518,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',13710.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(791,NULL,40720,1518,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',18000.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(792,NULL,40720,1518,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4540.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(793,NULL,40720,1518,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',10100.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(794,NULL,40720,1518,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',3200.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(795,NULL,40720,1518,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',5693.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(796,NULL,40720,1518,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',2000.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(797,NULL,40720,1518,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',5175.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(798,NULL,40720,1518,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',6210.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(799,NULL,40720,1518,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',9591.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(800,NULL,40720,1518,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',9591.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(801,NULL,40720,1518,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',5871.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(802,NULL,40720,1518,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',3100.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(803,NULL,40720,1518,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5221.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(804,NULL,40720,1518,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4500.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(805,NULL,40720,1518,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4130.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(806,NULL,40720,1518,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5499.99,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL);
INSERT INTO `balance_libro` VALUES (807,NULL,40720,1518,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',14999.99,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(808,NULL,40720,1518,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4600.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(809,NULL,40720,1518,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',10000.00,NULL,NULL,1,'2022-08-16 15:48:35','2022-08-16 15:48:35',NULL),(810,NULL,40720,1518,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5589.99,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(811,NULL,40720,1518,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6429.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(812,NULL,40720,1518,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13910.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(813,NULL,40720,1518,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4650.01,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(814,NULL,40720,1518,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6500.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(815,NULL,40720,1518,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7780.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(816,NULL,40720,1518,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',14030.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(817,NULL,40720,1518,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5400.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(818,NULL,40720,1518,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6500.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(819,NULL,40720,1518,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(820,NULL,40720,1518,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(821,NULL,40720,1518,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6954.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(822,NULL,40720,1518,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5299.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(823,NULL,40720,1518,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(824,NULL,40720,1518,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',18158.58,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(825,NULL,40720,1518,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2899.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(826,NULL,40720,1518,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5299.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(827,NULL,40720,1518,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(828,NULL,40720,1518,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(829,NULL,40720,1518,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(830,NULL,40720,1518,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7499.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(831,NULL,40720,1518,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL);
INSERT INTO `balance_libro` VALUES (832,NULL,40720,1518,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2670.01,NULL,NULL,1,'2022-08-16 15:48:36','2022-08-16 15:48:36',NULL),(833,NULL,40720,1518,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5599.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(834,NULL,40720,1518,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(835,NULL,40720,1518,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(836,NULL,40720,1518,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(837,NULL,40720,1518,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6943.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(838,NULL,40720,1518,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5198.99,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(839,NULL,40720,1518,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5299.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(840,NULL,40720,1518,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5599.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(841,NULL,40720,1518,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5188.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(842,NULL,40720,1518,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(843,NULL,40720,1518,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7703.01,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(844,NULL,40720,1518,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5599.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(845,NULL,40720,1518,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(846,NULL,40720,1518,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7489.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(847,NULL,40720,1518,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7798.99,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(848,NULL,40720,1518,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6847.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(849,NULL,40720,1518,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8344.99,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(850,NULL,40720,1518,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5599.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(851,NULL,40720,1518,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6699.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(852,NULL,40720,1518,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8344.99,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(853,NULL,40720,1518,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7798.99,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(854,NULL,40720,1518,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',21999.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(855,NULL,40720,1518,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(856,NULL,40720,1518,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5599.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL);
INSERT INTO `balance_libro` VALUES (857,NULL,40720,1518,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5198.99,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(858,NULL,40720,1518,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5299.00,NULL,NULL,1,'2022-08-16 15:48:37','2022-08-16 15:48:37',NULL),(859,NULL,40720,1518,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5349.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(860,NULL,40720,1518,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(861,NULL,40720,1518,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(862,NULL,40720,1518,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6999.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(863,NULL,40720,1518,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5599.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(864,NULL,40720,1518,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',12999.01,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(865,NULL,40720,1518,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(866,NULL,40720,1518,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7159.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(867,NULL,40720,1518,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6930.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(868,NULL,40720,1518,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5188.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(869,NULL,40720,1518,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(870,NULL,40720,1518,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9094.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(871,NULL,40720,1518,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5699.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(872,NULL,40720,1518,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7499.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(873,NULL,40720,1518,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6419.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(874,NULL,40720,1518,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6123.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(875,NULL,40720,1518,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5349.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(876,NULL,40720,1518,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7999.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(877,NULL,40720,1518,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7703.01,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(878,NULL,40720,1518,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4793.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(879,NULL,40720,1518,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6943.00,NULL,NULL,1,'2022-08-16 15:48:38','2022-08-16 15:48:38',NULL),(880,NULL,40720,1518,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4921.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(881,NULL,40720,1518,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5699.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL);
INSERT INTO `balance_libro` VALUES (882,NULL,40720,1518,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5167.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(883,NULL,40720,1518,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6943.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(884,NULL,40720,1518,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8899.01,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(885,NULL,40720,1518,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5188.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(886,NULL,40720,1518,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4800.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(887,NULL,40720,1518,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8659.99,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(888,NULL,40720,1518,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3670.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(889,NULL,40720,1518,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2800.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(890,NULL,40720,1518,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6000.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(891,NULL,40720,1518,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6670.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(892,NULL,40720,1518,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7200.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(893,NULL,40720,1518,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',10440.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(894,NULL,40720,1518,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5699.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(895,NULL,40720,1518,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6123.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(896,NULL,40720,1518,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',10699.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(897,NULL,40720,1518,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5349.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(898,NULL,40720,1518,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(899,NULL,40720,1518,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(900,NULL,40720,1518,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5349.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(901,NULL,40720,1518,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(902,NULL,40720,1518,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(903,NULL,40720,1518,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5392.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(904,NULL,40720,1518,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5392.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(905,NULL,40720,1518,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7999.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(906,NULL,40720,1518,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8291.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL);
INSERT INTO `balance_libro` VALUES (907,NULL,40720,1518,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7999.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(908,NULL,40720,1518,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:39','2022-08-16 15:48:39',NULL),(909,NULL,40720,1518,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4151.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(910,NULL,40720,1518,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(911,NULL,40720,1518,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3300.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(912,NULL,40720,1518,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5520.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(913,NULL,40720,1518,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4800.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(914,NULL,40720,1518,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5400.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(915,NULL,40720,1518,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5520.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(916,NULL,40720,1518,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4400.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(917,NULL,40720,1518,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5845.99,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(918,NULL,40720,1518,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6900.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(919,NULL,40720,1518,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6000.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(920,NULL,40720,1518,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(921,NULL,40720,1518,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7264.01,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(922,NULL,40720,1518,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7999.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(923,NULL,40720,1518,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(924,NULL,40720,1518,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7499.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(925,NULL,40720,1518,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5028.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(926,NULL,40720,1518,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7798.99,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(927,NULL,40720,1518,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(928,NULL,40720,1518,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5699.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(929,NULL,40720,1518,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8899.01,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(930,NULL,40720,1518,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3999.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(931,NULL,40720,1518,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4160.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL);
INSERT INTO `balance_libro` VALUES (932,NULL,40720,1518,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',10120.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(933,NULL,40720,1518,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5290.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(934,NULL,40720,1518,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5392.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(935,NULL,40720,1518,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5699.00,NULL,NULL,1,'2022-08-16 15:48:40','2022-08-16 15:48:40',NULL),(936,NULL,40720,1518,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5699.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(937,NULL,40720,1518,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6419.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(938,NULL,40720,1518,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7999.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(939,NULL,40720,1518,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',9869.99,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(940,NULL,40720,1518,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7999.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(941,NULL,40720,1518,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5991.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(942,NULL,40720,1518,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5699.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(943,NULL,40720,1518,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7798.99,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(944,NULL,40720,1518,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',9999.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(945,NULL,40720,1518,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5699.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(946,NULL,40720,1518,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',10051.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(947,NULL,40720,1518,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4800.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(948,NULL,40720,1518,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',10000.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(949,NULL,40720,1518,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4800.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(950,NULL,40720,1518,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3800.01,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(951,NULL,40720,1518,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',11983.01,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(952,NULL,40720,1518,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4600.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(953,NULL,40720,1518,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3900.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(954,NULL,40720,1518,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',20320.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(955,NULL,40720,1518,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',5170.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(956,NULL,40720,1518,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',10304.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL);
INSERT INTO `balance_libro` VALUES (957,NULL,40720,1518,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',3900.00,NULL,NULL,1,'2022-08-16 15:48:41','2022-08-16 15:48:41',NULL),(958,NULL,40720,1518,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',4199.99,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(959,NULL,40720,1518,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',5880.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(960,NULL,40720,1518,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',6601.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(961,NULL,40720,1518,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',11063.01,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(962,NULL,40720,1518,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',5520.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(963,NULL,40720,1518,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',4800.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(964,NULL,40720,1518,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',9840.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(965,NULL,40720,1518,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',7337.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(966,NULL,40720,1518,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',5175.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(967,NULL,40720,1518,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',16675.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(968,NULL,40720,1518,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',3670.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(969,NULL,40720,1518,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4800.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(970,NULL,40720,1518,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5188.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(971,NULL,40720,1518,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5392.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(972,NULL,40720,1518,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7703.01,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(973,NULL,40720,1518,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(974,NULL,40720,1518,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',8899.01,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(975,NULL,40720,1518,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7999.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(976,NULL,40720,1518,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6419.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(977,NULL,40720,1518,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7999.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(978,NULL,40720,1518,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(979,NULL,40720,1518,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(980,NULL,40720,1518,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6419.00,NULL,NULL,1,'2022-08-16 15:48:42','2022-08-16 15:48:42',NULL),(981,NULL,40720,1518,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7159.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL);
INSERT INTO `balance_libro` VALUES (982,NULL,40720,1518,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5167.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(983,NULL,40720,1518,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(984,NULL,40720,1518,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',8023.99,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(985,NULL,40720,1518,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7703.01,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(986,NULL,40720,1518,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5349.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(987,NULL,40720,1518,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5350.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(988,NULL,40720,1518,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5028.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(989,NULL,40720,1518,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6849.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(990,NULL,40720,1518,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5349.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(991,NULL,40720,1518,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7703.01,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(992,NULL,40720,1518,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5350.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(993,NULL,40720,1518,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7999.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(994,NULL,40720,1518,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(995,NULL,40720,1518,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(996,NULL,40720,1518,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(997,NULL,40720,1518,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(998,NULL,40720,1518,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7999.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(999,NULL,40720,1518,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(1000,NULL,40720,1518,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(1001,NULL,40720,1518,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',8899.01,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(1002,NULL,40720,1518,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(1003,NULL,40720,1518,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6419.00,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(1004,NULL,40720,1518,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7703.01,NULL,NULL,1,'2022-08-16 15:48:43','2022-08-16 15:48:43',NULL),(1005,NULL,40720,1518,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7159.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1006,NULL,40720,1518,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL);
INSERT INTO `balance_libro` VALUES (1007,NULL,40720,1518,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7999.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1008,NULL,40720,1518,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7999.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1009,NULL,40720,1518,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6019.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1010,NULL,40720,1518,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1011,NULL,40720,1518,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6849.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1012,NULL,40720,1518,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7999.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1013,NULL,40720,1518,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1014,NULL,40720,1518,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',3999.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1015,NULL,40720,1518,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1016,NULL,40720,1518,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6676.01,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1017,NULL,40720,1518,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1018,NULL,40720,1518,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',9598.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1019,NULL,40720,1518,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5699.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1020,NULL,40720,1518,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',3899.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1021,NULL,40720,1518,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',8499.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1022,NULL,40720,1518,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',10441.01,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1023,NULL,40720,1518,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6849.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1024,NULL,40720,1518,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7998.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1025,NULL,40720,1518,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6123.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1026,NULL,40720,1518,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5028.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1027,NULL,40720,1518,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6500.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1028,NULL,40720,1518,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4800.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1029,NULL,40720,1518,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5762.00,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL),(1030,NULL,40720,1518,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',15900.01,NULL,NULL,1,'2022-08-16 15:48:44','2022-08-16 15:48:44',NULL);
INSERT INTO `balance_libro` VALUES (1031,NULL,40720,1518,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5980.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1032,NULL,40720,1518,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5520.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1033,NULL,40720,1518,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4255.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1034,NULL,40720,1518,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4720.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1035,NULL,40720,1518,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2000.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1036,NULL,40720,1518,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',3000.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1037,NULL,40720,1518,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5175.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1038,NULL,40720,1518,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4100.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1039,NULL,40720,1518,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6000.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1040,NULL,40720,1518,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5200.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1041,NULL,40720,1518,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',12121.01,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1042,NULL,40720,1518,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',16884.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1043,NULL,40720,1518,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5880.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1044,NULL,40720,1518,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',3999.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1045,NULL,40720,1518,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5699.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1046,NULL,40720,1518,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7999.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1047,NULL,40720,1518,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3850.99,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1048,NULL,40720,1518,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3899.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1049,NULL,40720,1518,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5699.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1050,NULL,40720,1518,2,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6849.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1051,NULL,40720,1518,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5699.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1052,NULL,40720,1518,2,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6019.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1053,NULL,40720,1518,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5699.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL),(1054,NULL,40720,1518,2,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5135.00,NULL,NULL,1,'2022-08-16 15:48:45','2022-08-16 15:48:45',NULL);
INSERT INTO `balance_libro` VALUES (1055,NULL,40720,1518,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4921.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1056,NULL,40720,1518,2,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8899.01,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1057,NULL,40720,1518,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5349.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1058,NULL,40720,1518,2,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3899.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1059,NULL,40720,1518,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7999.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1060,NULL,40720,1518,2,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5350.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1061,NULL,40720,1518,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5349.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1062,NULL,40720,1518,2,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3999.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1063,NULL,40720,1518,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5699.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1064,NULL,40720,1518,2,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7999.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1065,NULL,40720,1518,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',13266.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1066,NULL,40720,1518,2,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7798.99,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1067,NULL,40720,1518,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6098.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1068,NULL,40720,1518,2,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6098.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1069,NULL,40720,1518,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',11110.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1070,NULL,40720,1518,2,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',21839.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1071,NULL,40720,1518,2,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3710.01,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1072,NULL,40720,1518,2,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3795.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1073,NULL,40720,1518,2,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8200.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1074,NULL,40720,1518,2,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10310.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1075,NULL,40720,1518,2,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6380.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1076,NULL,40720,1518,2,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5175.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1077,NULL,40720,1518,2,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5170.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1078,NULL,40720,1518,2,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2300.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL);
INSERT INTO `balance_libro` VALUES (1079,NULL,40720,1518,2,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6000.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1080,NULL,40720,1518,2,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5349.00,NULL,NULL,1,'2022-08-16 15:48:46','2022-08-16 15:48:46',NULL),(1081,NULL,40720,1518,2,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3528.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1082,NULL,40720,1518,2,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5699.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1083,NULL,40720,1518,2,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7999.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1084,NULL,40720,1518,2,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',8899.01,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1085,NULL,40720,1518,2,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4151.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1086,NULL,40720,1518,2,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6676.01,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1087,NULL,40720,1518,2,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',8899.01,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1088,NULL,40720,1518,2,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6849.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1089,NULL,40720,1518,2,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2599.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1090,NULL,40720,1518,2,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5699.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1091,NULL,40720,1518,2,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5699.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1092,NULL,40720,1518,2,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7489.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1093,NULL,40720,1518,2,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9999.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1094,NULL,40720,1518,2,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5699.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1095,NULL,40720,1518,2,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9999.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1096,NULL,40720,1518,2,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6849.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1097,NULL,40720,1518,2,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7679.04,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1098,NULL,40720,1518,2,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4221.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1099,NULL,40720,1518,2,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3710.01,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1100,NULL,40720,1518,2,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4600.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1101,NULL,40720,1518,2,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5499.99,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1102,NULL,40720,1518,2,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5672.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL);
INSERT INTO `balance_libro` VALUES (1103,NULL,40720,1518,2,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9800.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1104,NULL,40720,1518,2,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5693.00,NULL,NULL,1,'2022-08-16 15:48:47','2022-08-16 15:48:47',NULL),(1105,NULL,40720,1518,2,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',16670.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1106,NULL,40720,1518,2,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10600.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1107,NULL,40720,1518,2,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5028.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1108,NULL,40720,1518,2,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5028.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1109,NULL,40720,1518,2,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5699.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1110,NULL,40720,1518,2,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7756.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1111,NULL,40720,1518,2,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6419.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1112,NULL,40720,1518,2,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7798.99,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1113,NULL,40720,1518,2,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6225.99,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1114,NULL,40720,1518,2,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5699.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1115,NULL,40720,1518,2,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',370.01,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1116,NULL,40720,1518,2,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7999.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1117,NULL,40720,1518,2,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5699.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1118,NULL,40720,1518,2,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7649.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1119,NULL,40720,1518,2,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7159.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1120,NULL,40720,1518,2,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5740.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1121,NULL,40720,1518,2,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',14970.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1122,NULL,40720,1518,2,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3000.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1123,NULL,40720,1518,2,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4500.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1124,NULL,40720,1518,2,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',16740.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1125,NULL,40720,1518,2,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4485.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1126,NULL,40720,1518,2,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5400.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL);
INSERT INTO `balance_libro` VALUES (1127,NULL,40720,1518,2,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3670.00,NULL,NULL,1,'2022-08-16 15:48:48','2022-08-16 15:48:48',NULL),(1128,NULL,40720,1518,2,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6500.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1129,NULL,40720,1518,2,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1130,NULL,40720,1518,2,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',11500.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1131,NULL,40720,1518,2,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5290.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1132,NULL,40720,1518,2,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',9914.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1133,NULL,40720,1518,2,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3000.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1134,NULL,40720,1518,2,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7474.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1135,NULL,40720,1518,2,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5175.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1136,NULL,40720,1518,2,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',12700.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1137,NULL,40720,1518,2,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4100.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1138,NULL,40720,1518,2,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',16670.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1139,NULL,40720,1518,2,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4500.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1140,NULL,40720,1518,2,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',6500.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1141,NULL,40720,1518,2,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5290.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1142,NULL,40720,1518,2,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5693.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1143,NULL,40720,1518,2,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',8500.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1144,NULL,40720,1518,2,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3700.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1145,NULL,40720,1518,2,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',13700.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1146,NULL,40720,1518,2,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4950.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1147,NULL,40720,1518,2,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',9050.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1148,NULL,40720,1518,2,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4900.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1149,NULL,40720,1518,2,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',8119.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL),(1150,NULL,40720,1518,2,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5980.00,NULL,NULL,1,'2022-08-16 15:48:49','2022-08-16 15:48:49',NULL);
INSERT INTO `balance_libro` VALUES (1151,NULL,40720,1518,2,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5980.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1152,NULL,40720,1518,2,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',6785.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1153,NULL,40720,1518,2,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',11700.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1154,NULL,40720,1518,2,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4100.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1155,NULL,40720,1518,2,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5699.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1156,NULL,40720,1518,2,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5349.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1157,NULL,40720,1518,2,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',8899.01,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1158,NULL,40720,1518,2,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1159,NULL,40720,1518,2,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6677.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1160,NULL,40720,1518,2,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1161,NULL,40720,1518,2,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1162,NULL,40720,1518,2,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9999.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1163,NULL,40720,1518,2,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5350.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1164,NULL,40720,1518,2,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5456.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1165,NULL,40720,1518,2,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7703.01,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1166,NULL,40720,1518,2,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',8899.01,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1167,NULL,40720,1518,2,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3000.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1168,NULL,40720,1518,2,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6943.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1169,NULL,40720,1518,2,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6676.01,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1170,NULL,40720,1518,2,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5899.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1171,NULL,40720,1518,2,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4800.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1172,NULL,40720,1518,2,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6000.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1173,NULL,40720,1518,2,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',22999.99,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1174,NULL,40720,1518,2,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL);
INSERT INTO `balance_libro` VALUES (1175,NULL,40720,1518,2,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:50','2022-08-16 15:48:50',NULL),(1176,NULL,40720,1518,2,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1177,NULL,40720,1518,2,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1178,NULL,40720,1518,2,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1179,NULL,40720,1518,2,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5392.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1180,NULL,40720,1518,2,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',2674.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1181,NULL,40720,1518,2,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6225.99,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1182,NULL,40720,1518,2,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7489.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1183,NULL,40720,1518,2,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3899.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1184,NULL,40720,1518,2,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5349.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1185,NULL,40720,1518,2,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7842.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1186,NULL,40720,1518,2,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1187,NULL,40720,1518,2,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5188.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1188,NULL,40720,1518,2,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3899.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1189,NULL,40720,1518,2,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1190,NULL,40720,1518,2,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1191,NULL,40720,1518,2,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5188.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1192,NULL,40720,1518,2,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1193,NULL,40720,1518,2,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6999.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1194,NULL,40720,1518,2,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1195,NULL,40720,1518,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3850.99,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1196,NULL,40720,1518,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5349.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1197,NULL,40720,1518,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7703.01,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1198,NULL,40720,1518,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9094.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL);
INSERT INTO `balance_libro` VALUES (1199,NULL,40720,1518,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:51','2022-08-16 15:48:51',NULL),(1200,NULL,40720,1518,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1201,NULL,40720,1518,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5699.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1202,NULL,40720,1518,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',8739.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1203,NULL,40720,1518,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5392.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1204,NULL,40720,1518,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3999.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1205,NULL,40720,1518,2,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7999.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1206,NULL,40720,1518,2,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4921.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1207,NULL,40720,1518,2,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4921.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1208,NULL,40720,1518,2,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5349.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1209,NULL,40720,1518,2,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6321.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1210,NULL,40720,1518,2,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5740.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1211,NULL,40720,1518,2,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5980.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1212,NULL,40720,1518,2,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',8300.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1213,NULL,40720,1518,2,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7359.99,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1214,NULL,40720,1518,2,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6200.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1215,NULL,40720,1518,2,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5980.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1216,NULL,40720,1518,2,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',8899.01,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1217,NULL,40720,1518,2,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7999.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1218,NULL,40720,1518,2,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5349.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1219,NULL,40720,1518,2,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1220,NULL,40720,1518,2,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1221,NULL,40720,1518,2,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1222,NULL,40720,1518,2,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL);
INSERT INTO `balance_libro` VALUES (1223,NULL,40720,1518,2,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5028.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1224,NULL,40720,1518,2,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1225,NULL,40720,1518,2,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3899.00,NULL,NULL,1,'2022-08-16 15:48:52','2022-08-16 15:48:52',NULL),(1226,NULL,40720,1518,2,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1227,NULL,40720,1518,2,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5991.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1228,NULL,40720,1518,2,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5135.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1229,NULL,40720,1518,2,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1230,NULL,40720,1518,2,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7798.99,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1231,NULL,40720,1518,2,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1232,NULL,40720,1518,2,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1233,NULL,40720,1518,2,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7999.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1234,NULL,40720,1518,2,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6999.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1235,NULL,40720,1518,2,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4600.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1236,NULL,40720,1518,2,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5900.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1237,NULL,40720,1518,2,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5451.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1238,NULL,40720,1518,2,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3000.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1239,NULL,40720,1518,2,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',8300.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1240,NULL,40720,1518,2,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4900.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1241,NULL,40720,1518,2,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3000.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1242,NULL,40720,1518,2,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',22999.99,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1243,NULL,40720,1518,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4100.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1244,NULL,40720,1518,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5699.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1245,NULL,40720,1518,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL),(1246,NULL,40720,1518,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:53','2022-08-16 15:48:53',NULL);
INSERT INTO `balance_libro` VALUES (1247,NULL,40720,1518,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5338.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1248,NULL,40720,1518,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1249,NULL,40720,1518,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3899.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1250,NULL,40720,1518,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4160.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1251,NULL,40720,1518,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1252,NULL,40720,1518,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7599.01,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1253,NULL,40720,1518,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8999.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1254,NULL,40720,1518,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1255,NULL,40720,1518,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7999.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1256,NULL,40720,1518,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1257,NULL,40720,1518,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1258,NULL,40720,1518,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1259,NULL,40720,1518,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7159.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1260,NULL,40720,1518,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6098.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1261,NULL,40720,1518,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1262,NULL,40720,1518,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1263,NULL,40720,1518,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5396.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1264,NULL,40720,1518,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6019.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1265,NULL,40720,1518,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3899.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1266,NULL,40720,1518,2,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1267,NULL,40720,1518,2,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1268,NULL,40720,1518,2,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2599.00,NULL,NULL,1,'2022-08-16 15:48:54','2022-08-16 15:48:54',NULL),(1269,NULL,40720,1518,2,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1270,NULL,40720,1518,2,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5699.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL);
INSERT INTO `balance_libro` VALUES (1271,NULL,40720,1518,2,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3860.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1272,NULL,40720,1518,2,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4800.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1273,NULL,40720,1518,2,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5980.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1274,NULL,40720,1518,2,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5200.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1275,NULL,40720,1518,2,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3960.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1276,NULL,40720,1518,2,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10408.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1277,NULL,40720,1518,2,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3700.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1278,NULL,40720,1518,2,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5693.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1279,NULL,40720,1518,2,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8300.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1280,NULL,40720,1518,2,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6500.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1281,NULL,40720,1518,2,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4500.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1282,NULL,40720,1518,2,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5980.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1283,NULL,40720,1518,2,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3000.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1284,NULL,40720,1518,2,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5699.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1285,NULL,40720,1518,2,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5349.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1286,NULL,40720,1518,2,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3999.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1287,NULL,40720,1518,2,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6943.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1288,NULL,40720,1518,2,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7159.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1289,NULL,40720,1518,2,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6799.00,NULL,NULL,1,'2022-08-16 15:48:55','2022-08-16 15:48:55',NULL),(1290,NULL,40720,1518,2,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5699.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1291,NULL,40720,1518,2,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',8899.01,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1292,NULL,40720,1518,2,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7489.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1293,NULL,40720,1518,2,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6429.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1294,NULL,40720,1518,2,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5699.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL);
INSERT INTO `balance_libro` VALUES (1295,NULL,40720,1518,2,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7703.01,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1296,NULL,40720,1518,2,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5699.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1297,NULL,40720,1518,2,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5699.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1298,NULL,40720,1518,2,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6943.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1299,NULL,40720,1518,2,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5349.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1300,NULL,40720,1518,2,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7703.01,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1301,NULL,40720,1518,2,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7999.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1302,NULL,40720,1518,2,1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',8899.01,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1303,NULL,40720,1518,2,1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3000.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1304,NULL,40720,1518,2,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5800.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1305,NULL,40720,1518,2,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5693.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1306,NULL,40720,1518,2,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',14600.01,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1307,NULL,40720,1518,2,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6785.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1308,NULL,40720,1518,2,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5750.00,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1309,NULL,40720,1518,2,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2699.99,NULL,NULL,1,'2022-08-16 15:48:56','2022-08-16 15:48:56',NULL),(1310,NULL,40720,1518,2,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',13870.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1311,NULL,40720,1518,2,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',27110.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1312,NULL,40720,1518,2,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5699.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1313,NULL,40720,1518,2,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7489.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1314,NULL,40720,1518,2,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7007.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1315,NULL,40720,1518,2,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5699.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1316,NULL,40720,1518,2,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3899.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1317,NULL,40720,1518,2,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9999.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1318,NULL,40720,1518,2,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9999.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL);
INSERT INTO `balance_libro` VALUES (1319,NULL,40720,1518,2,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',20999.01,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1320,NULL,40720,1518,2,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5350.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1321,NULL,40720,1518,2,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5349.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1322,NULL,40720,1518,2,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5699.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1323,NULL,40720,1518,2,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5699.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1324,NULL,40720,1518,2,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',8499.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1325,NULL,40720,1518,2,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5350.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1326,NULL,40720,1518,2,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5980.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1327,NULL,40720,1518,2,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4160.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1328,NULL,40720,1518,2,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',19110.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1329,NULL,40720,1518,2,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9821.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1330,NULL,40720,1518,2,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3899.00,NULL,NULL,1,'2022-08-16 15:48:57','2022-08-16 15:48:57',NULL),(1331,NULL,40720,1518,2,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5699.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1332,NULL,40720,1518,2,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6429.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1333,NULL,40720,1518,2,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3899.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1334,NULL,40720,1518,2,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5200.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1335,NULL,40720,1518,2,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4485.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1336,NULL,40720,1518,2,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7820.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1337,NULL,40720,1518,2,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',11400.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1338,NULL,40720,1518,2,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4160.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1339,NULL,40720,1518,2,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4810.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1340,NULL,40720,1518,2,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6799.99,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1341,NULL,40720,1518,2,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',14400.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1342,NULL,40720,1518,2,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9320.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL);
INSERT INTO `balance_libro` VALUES (1343,NULL,40720,1518,2,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5200.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1344,NULL,40720,1518,2,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',6270.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1345,NULL,40720,1518,2,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',6799.99,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1346,NULL,40720,1518,2,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5980.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1347,NULL,40720,1518,2,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',11000.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1348,NULL,40720,1518,2,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5200.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1349,NULL,40720,1518,2,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',8119.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1350,NULL,40720,1518,2,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5240.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1351,NULL,40720,1518,2,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',18989.99,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1352,NULL,40720,1518,2,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5980.00,NULL,NULL,1,'2022-08-16 15:48:58','2022-08-16 15:48:58',NULL),(1353,NULL,40720,1518,2,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',20000.01,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1354,NULL,40720,1518,2,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3700.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1355,NULL,40720,1518,2,1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3700.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1356,NULL,40720,1518,2,1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5350.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1357,NULL,40720,1518,2,1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',6429.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1358,NULL,40720,1518,2,1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1359,NULL,40720,1518,2,1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1360,NULL,40720,1518,2,1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5028.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1361,NULL,40720,1518,2,1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1362,NULL,40720,1518,2,1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',10699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1363,NULL,40720,1518,2,1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1364,NULL,40720,1518,2,1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',9999.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1365,NULL,40720,1518,2,1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5350.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1366,NULL,40720,1518,2,1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',8999.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL);
INSERT INTO `balance_libro` VALUES (1367,NULL,40720,1518,2,1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1368,NULL,40720,1518,2,1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1369,NULL,40720,1518,2,1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1370,NULL,40720,1518,2,1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1371,NULL,40720,1518,2,1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',8999.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1372,NULL,40720,1518,2,1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1373,NULL,40720,1518,2,1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1374,NULL,40720,1518,2,1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',7703.01,NULL,NULL,1,'2022-08-16 15:48:59','2022-08-16 15:48:59',NULL),(1375,NULL,40720,1518,2,1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1376,NULL,40720,1518,2,1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1377,NULL,40720,1518,2,1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5699.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1378,NULL,40720,1518,2,1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5349.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1379,NULL,40720,1518,2,1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',6429.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1380,NULL,40720,1518,2,1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',6847.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1381,NULL,40720,1518,2,1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5028.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1382,NULL,40720,1518,2,1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',8540.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1383,NULL,40720,1518,2,1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4500.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1384,NULL,40720,1518,2,1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4500.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1385,NULL,40720,1518,2,1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',13000.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1386,NULL,40720,1518,2,1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5400.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1387,NULL,40720,1518,2,1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',6510.01,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1388,NULL,40720,1518,2,1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',7798.99,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1389,NULL,40720,1518,2,1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',18799.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1390,NULL,40720,1518,2,1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',8358.99,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL);
INSERT INTO `balance_libro` VALUES (1391,NULL,40720,1518,2,1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5699.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1392,NULL,40720,1518,2,1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6429.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1393,NULL,40720,1518,2,1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6429.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1394,NULL,40720,1518,2,1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5699.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1395,NULL,40720,1518,2,1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5699.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1396,NULL,40720,1518,2,1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6429.00,NULL,NULL,1,'2022-08-16 15:49:00','2022-08-16 15:49:00',NULL),(1397,NULL,40720,1518,2,1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',7999.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1398,NULL,40720,1518,2,1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6943.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1399,NULL,40720,1518,2,1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',20999.01,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1400,NULL,40720,1518,2,1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',8358.99,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1401,NULL,40720,1518,2,1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',7159.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1402,NULL,40720,1518,2,1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5699.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1403,NULL,40720,1518,2,1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',7842.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1404,NULL,40720,1518,2,1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',8899.01,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1405,NULL,40720,1518,2,1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5699.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1406,NULL,40720,1518,2,1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',7061.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1407,NULL,40720,1518,2,1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',8358.99,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1408,NULL,40720,1518,2,1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6429.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1409,NULL,40720,1518,2,1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5699.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1410,NULL,40720,1518,2,1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5028.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1411,NULL,40720,1518,2,1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5699.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1412,NULL,40720,1518,2,1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6123.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1413,NULL,40720,1518,2,1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6799.99,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1414,NULL,40720,1518,2,1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',12500.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL);
INSERT INTO `balance_libro` VALUES (1415,NULL,40720,1518,2,1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',3700.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1416,NULL,40720,1518,2,1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',19700.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1417,NULL,40720,1518,2,1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',7600.00,NULL,NULL,1,'2022-08-16 15:49:01','2022-08-16 15:49:01',NULL),(1418,NULL,40720,1518,2,1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6030.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1419,NULL,40720,1518,2,1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5290.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1420,NULL,40720,1518,2,1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',20470.01,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1421,NULL,40720,1518,2,1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',8970.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1422,NULL,40720,1518,2,1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6934.99,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1423,NULL,40720,1518,2,1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',5693.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1424,NULL,40720,1518,2,1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',3899.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1425,NULL,40720,1518,2,1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',22445.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1426,NULL,40720,1518,2,1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1427,NULL,40720,1518,2,1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',6975.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1428,NULL,40720,1518,2,1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',8739.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1429,NULL,40720,1518,2,1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1430,NULL,40720,1518,2,1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1431,NULL,40720,1518,2,1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',6429.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1432,NULL,40720,1518,2,1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1433,NULL,40720,1518,2,1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',2599.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1434,NULL,40720,1518,2,1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1435,NULL,40720,1518,2,1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1436,NULL,40720,1518,2,1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1437,NULL,40720,1518,2,1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',6847.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1438,NULL,40720,1518,2,1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',9999.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL);
INSERT INTO `balance_libro` VALUES (1439,NULL,40720,1518,2,1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',11583.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1440,NULL,40720,1518,2,1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:02','2022-08-16 15:49:02',NULL),(1441,NULL,40720,1518,2,1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',7756.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1442,NULL,40720,1518,2,1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5699.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1443,NULL,40720,1518,2,1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',7500.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1444,NULL,40720,1518,2,1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',4199.99,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1445,NULL,40720,1518,2,1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5980.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1446,NULL,40720,1518,2,1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',2500.01,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1447,NULL,40720,1518,2,1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',4428.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1448,NULL,40720,1518,2,1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',3700.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1449,NULL,40720,1518,2,1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6799.99,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1450,NULL,40720,1518,2,1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5880.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1451,NULL,40720,1518,2,1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5200.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1452,NULL,40720,1518,2,1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4580.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1453,NULL,40720,1518,2,1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4540.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1454,NULL,40720,1518,2,1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5400.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1455,NULL,40720,1518,2,1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',9990.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1456,NULL,40720,1518,2,1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',23541.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1457,NULL,40720,1518,2,1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6400.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1458,NULL,40720,1518,2,1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6030.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1459,NULL,40720,1518,2,1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3899.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1460,NULL,40720,1518,2,1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1461,NULL,40720,1518,2,1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6429.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1462,NULL,40720,1518,2,1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5349.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL);
INSERT INTO `balance_libro` VALUES (1463,NULL,40720,1518,2,1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8899.01,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1464,NULL,40720,1518,2,1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7264.01,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1465,NULL,40720,1518,2,1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1466,NULL,40720,1518,2,1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7999.00,NULL,NULL,1,'2022-08-16 15:49:03','2022-08-16 15:49:03',NULL),(1467,NULL,40720,1518,2,1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6429.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1468,NULL,40720,1518,2,1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1469,NULL,40720,1518,2,1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5350.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1470,NULL,40720,1518,2,1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1471,NULL,40720,1518,2,1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7999.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1472,NULL,40720,1518,2,1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7703.01,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1473,NULL,40720,1518,2,1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1474,NULL,40720,1518,2,1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1475,NULL,40720,1518,2,1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7999.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1476,NULL,40720,1518,2,1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1477,NULL,40720,1518,2,1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1478,NULL,40720,1518,2,1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1479,NULL,40720,1518,2,1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1480,NULL,40720,1518,2,1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1481,NULL,40720,1518,2,1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1482,NULL,40720,1518,2,1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7159.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1483,NULL,40720,1518,2,1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1484,NULL,40720,1518,2,1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1738.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1485,NULL,40720,1518,2,1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5188.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1486,NULL,40720,1518,2,1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',9039.99,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL);
INSERT INTO `balance_libro` VALUES (1487,NULL,40720,1518,2,1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7999.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1488,NULL,40720,1518,2,1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7999.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1489,NULL,40720,1518,2,1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6098.00,NULL,NULL,1,'2022-08-16 15:49:04','2022-08-16 15:49:04',NULL),(1490,NULL,40720,1518,2,1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4921.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1491,NULL,40720,1518,2,1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5349.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1492,NULL,40720,1518,2,1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5699.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1493,NULL,40720,1518,2,1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3700.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1494,NULL,40720,1518,2,1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6799.99,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1495,NULL,40720,1518,2,1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8004.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1496,NULL,40720,1518,2,1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3850.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1497,NULL,40720,1518,2,1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',10580.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1498,NULL,40720,1518,2,1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2500.01,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1499,NULL,40720,1518,2,1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5980.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1500,NULL,40720,1518,2,1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6960.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1501,NULL,40720,1518,2,1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',22999.99,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1502,NULL,40720,1518,2,1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7820.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1503,NULL,40720,1518,2,1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5750.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1504,NULL,40720,1518,2,1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5221.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1505,NULL,40720,1518,2,1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',23541.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1506,NULL,40720,1518,2,1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5350.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1507,NULL,40720,1518,2,1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7820.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1508,NULL,40720,1518,2,1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',11040.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1509,NULL,40720,1518,2,1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4100.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1510,NULL,40720,1518,2,1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5200.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL);
INSERT INTO `balance_libro` VALUES (1511,NULL,40720,1518,2,1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7820.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1512,NULL,40720,1518,2,1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',11489.00,NULL,NULL,1,'2022-08-16 15:49:05','2022-08-16 15:49:05',NULL),(1513,NULL,40720,1518,2,1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5599.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1514,NULL,40720,1518,2,1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1515,NULL,40720,1518,2,1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8899.01,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1516,NULL,40720,1518,2,1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8899.01,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1517,NULL,40720,1518,2,1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5392.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1518,NULL,40720,1518,2,1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1405.29,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1519,NULL,40720,1518,2,1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6593.71,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1520,NULL,40720,1518,2,1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6419.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1521,NULL,40720,1518,2,1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7159.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1522,NULL,40720,1518,2,1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7999.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1523,NULL,40720,1518,2,1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7999.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1524,NULL,40720,1518,2,1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8899.01,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1525,NULL,40720,1518,2,1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3215.49,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1526,NULL,40720,1518,2,1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7649.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1527,NULL,40720,1518,2,1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7842.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1528,NULL,40720,1518,2,1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1529,NULL,40720,1518,2,1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',4921.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1530,NULL,40720,1518,2,1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1531,NULL,40720,1518,2,1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7798.99,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1532,NULL,40720,1518,2,1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7159.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1533,NULL,40720,1518,2,1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6098.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1534,NULL,40720,1518,2,1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',120.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL);
INSERT INTO `balance_libro` VALUES (1535,NULL,40720,1518,2,1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5899.00,NULL,NULL,1,'2022-08-16 15:49:06','2022-08-16 15:49:06',NULL),(1536,NULL,40720,1518,2,1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7279.09,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1537,NULL,40720,1518,2,1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',74.74,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1538,NULL,40720,1518,2,1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7732.86,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1539,NULL,40720,1518,2,1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',227.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1540,NULL,40720,1518,2,1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7476.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1541,NULL,40720,1518,2,1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3899.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1542,NULL,40720,1518,2,1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1543,NULL,40720,1518,2,1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',250.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1544,NULL,40720,1518,2,1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8749.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1545,NULL,40720,1518,2,1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6429.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1546,NULL,40720,1518,2,1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1547,NULL,40720,1518,2,1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1548,NULL,40720,1518,2,1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8358.99,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1549,NULL,40720,1518,2,1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1550,NULL,40720,1518,2,1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5349.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1551,NULL,40720,1518,2,1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7702.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1552,NULL,40720,1518,2,1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1553,NULL,40720,1518,2,1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6098.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1554,NULL,40720,1518,2,1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1555,NULL,40720,1518,2,1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',9147.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1556,NULL,40720,1518,2,1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7999.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1557,NULL,40720,1518,2,1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3999.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1558,NULL,40720,1518,2,1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5330.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL);
INSERT INTO `balance_libro` VALUES (1559,NULL,40720,1518,2,1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8899.01,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1560,NULL,40720,1518,2,1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5028.00,NULL,NULL,1,'2022-08-16 15:49:07','2022-08-16 15:49:07',NULL),(1561,NULL,40720,1518,2,1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1562,NULL,40720,1518,2,1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',4386.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1563,NULL,40720,1518,2,1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1564,NULL,40720,1518,2,1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1565,NULL,40720,1518,2,1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5349.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1566,NULL,40720,1518,2,1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6847.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1567,NULL,40720,1518,2,1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1568,NULL,40720,1518,2,1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1569,NULL,40720,1518,2,1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5349.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1570,NULL,40720,1518,2,1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5028.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1571,NULL,40720,1518,2,1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5349.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1572,NULL,40720,1518,2,1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',4992.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1573,NULL,40720,1518,2,1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1574,NULL,40720,1518,2,1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1575,NULL,40720,1518,2,1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1576,NULL,40720,1518,2,1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1577,NULL,40720,1518,2,1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6429.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1578,NULL,40720,1518,2,1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3594.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1579,NULL,40720,1518,2,1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5349.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1580,NULL,40720,1518,2,1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8358.99,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1581,NULL,40720,1518,2,1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8899.01,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1582,NULL,40720,1518,2,1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6419.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL);
INSERT INTO `balance_libro` VALUES (1583,NULL,40720,1518,2,1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5198.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1584,NULL,40720,1518,2,1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1585,NULL,40720,1518,2,1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5991.00,NULL,NULL,1,'2022-08-16 15:49:08','2022-08-16 15:49:08',NULL),(1586,NULL,40720,1518,2,1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8899.01,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1587,NULL,40720,1518,2,1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1588,NULL,40720,1518,2,1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1589,NULL,40720,1518,2,1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6429.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1590,NULL,40720,1518,2,1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6419.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1591,NULL,40720,1518,2,1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1592,NULL,40720,1518,2,1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7999.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1593,NULL,40720,1518,2,1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5188.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1594,NULL,40720,1518,2,1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1595,NULL,40720,1518,2,1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7999.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1596,NULL,40720,1518,2,1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5699.00,NULL,NULL,1,'2022-08-16 15:49:09','2022-08-16 15:49:09',NULL),(1597,7523,40720,1518,2,1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2400.00,NULL,NULL,1,'2022-08-16 16:23:57','2022-08-16 16:24:38','2022-08-16 16:24:38'),(1598,7523,42285,3025,3,1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1026897.27,NULL,NULL,1,'2022-08-17 12:10:23','2022-08-17 12:10:23',NULL),(1599,7523,42285,3025,3,1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1275.62,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1600,7523,42285,3025,3,1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',85000.00,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1601,7523,42285,3025,3,1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',473411.68,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1602,7523,42285,3025,3,1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',14182.41,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1603,7523,42285,3025,3,1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',84700.00,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1604,7523,42285,3025,3,1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',78939.62,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1605,7523,42285,3025,3,1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2210.61,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1606,7523,42285,3025,3,1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',199650.00,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL);
INSERT INTO `balance_libro` VALUES (1607,7523,42285,3025,3,1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',46152.42,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1608,7523,42285,3025,3,1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',185614.00,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1609,7523,42285,3025,3,1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',515755.63,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1610,7523,42285,3025,3,1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',8500.00,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1611,7523,42285,3025,3,1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3663.01,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1612,7523,42285,3025,3,1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7329.12,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1613,7523,42285,3025,3,1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6542.49,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1614,7523,42285,3025,3,1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6542.49,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1615,7523,42285,3025,3,1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2327.56,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1616,7523,42285,3025,3,1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6542.49,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1617,7523,42285,3025,3,1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5976.08,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1618,7523,42285,3025,3,1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13666.69,NULL,NULL,1,'2022-08-17 12:10:24','2022-08-17 12:10:24',NULL),(1619,7523,42285,3025,3,1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',78939.62,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1620,7523,42285,3025,3,1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11725.00,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1621,7523,42285,3025,3,1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7797.30,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1622,7523,42285,3025,3,1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4026.00,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1623,7523,42285,3025,3,1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',199141.80,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1624,7523,42285,3025,3,1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',183315.00,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1625,7523,42285,3025,3,1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',10420.04,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1626,7523,42285,3025,3,1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',36631.65,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1627,7523,42285,3025,3,1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',602700.25,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1628,7523,42285,3025,3,1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',543425.86,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1629,7523,42285,3025,3,1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',764.92,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1630,7523,42285,3025,3,1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1457.85,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL);
INSERT INTO `balance_libro` VALUES (1631,7523,42285,3025,3,1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',366630.00,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1632,7523,42285,3025,3,1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',183315.00,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1633,7523,42285,3025,3,1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',2999.00,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1634,7523,42285,3025,3,1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',2497.45,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1635,7523,42285,3025,3,1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',402786.77,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1636,7523,42285,3025,3,1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',402786.77,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1637,7523,42285,3025,3,1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',961471.18,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1638,7523,42285,3025,3,1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',13068.00,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1639,7523,42285,3025,3,1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',208579.80,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1640,7523,42285,3025,3,1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1267329.37,NULL,NULL,1,'2022-08-17 12:10:25','2022-08-17 12:10:25',NULL),(1641,7523,42285,3025,3,1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',944123.00,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1642,7523,42285,3025,3,1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',26646.62,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1643,7523,42285,3025,3,1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8599.47,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1644,7523,42285,3025,3,1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',24731.19,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1645,7523,42285,3025,3,1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',132430.31,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1646,7523,42285,3025,3,1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',75072.00,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1647,7523,42285,3025,3,1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',179461.46,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1648,7523,42285,3025,3,1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',320935.68,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1649,7523,42285,3025,3,1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3644.63,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1650,7523,42285,3025,3,1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',13440.00,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1651,7523,42285,3025,3,1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',413093.66,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1652,7523,42285,3025,3,1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',595465.54,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1653,7523,42285,3025,3,1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',79187.53,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1654,7523,42285,3025,3,1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1149593.68,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL);
INSERT INTO `balance_libro` VALUES (1655,7523,42285,3025,3,1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',22062.64,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1656,7523,42285,3025,3,1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',471001.32,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1657,7523,42285,3025,3,1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',14690.74,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1658,7523,42285,3025,3,1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',15748.00,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1659,7523,42285,3025,3,1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',94674.59,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1660,7523,42285,3025,3,1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',153229.59,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1661,7523,42285,3025,3,1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',9082.79,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1662,7523,42285,3025,3,1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',275242.57,NULL,NULL,1,'2022-08-17 12:10:26','2022-08-17 12:10:26',NULL),(1663,7523,42285,3025,3,1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',199292.88,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1664,7523,42285,3025,3,1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',16701.27,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1665,7523,42285,3025,3,1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',35077.98,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1666,7523,42285,3025,3,1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',146367.50,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1667,7523,42285,3025,3,1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',16016.84,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1668,7523,42285,3025,3,1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1130248.30,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1669,7523,42285,3025,3,1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',398926.73,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1670,7523,42285,3025,3,1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',204175.40,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1671,7523,42285,3025,3,1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',879172.31,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1672,7523,42285,3025,3,1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',212339.20,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1673,7523,42285,3025,3,1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',451935.68,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1674,7523,42285,3025,3,1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',230923.66,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1675,7523,42285,3025,3,1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',350236.92,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1676,7523,42285,3025,3,1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1457.85,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1677,7523,42285,3025,3,1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',10285.00,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1678,7523,42285,3025,3,1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',19327.57,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL);
INSERT INTO `balance_libro` VALUES (1679,7523,42285,3025,3,1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',160931.10,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1680,7523,42285,3025,3,1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1262266.89,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1681,7523,42285,3025,3,1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',98786.17,NULL,NULL,1,'2022-08-17 12:10:27','2022-08-17 12:10:27',NULL),(1682,7523,42285,3025,3,1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',21892.05,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1683,7523,42285,3025,3,1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',183722.14,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1684,7523,42285,3025,3,1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',212669.60,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1685,7523,42285,3025,3,1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',152709.74,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1686,7523,42285,3025,3,1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2169.28,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1687,7523,42285,3025,3,1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',42658.76,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1688,7523,42285,3025,3,1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',169309.23,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1689,7523,42285,3025,3,1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1457.85,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1690,7523,42285,3025,3,1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1642180.82,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 15:06:19','2022-08-17 15:06:19'),(1691,7523,42285,3025,3,1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',291613.75,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 15:00:38','2022-08-17 15:00:38'),(1692,7523,42285,3025,3,1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',807.20,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 14:53:09','2022-08-17 14:53:09'),(1693,7523,42285,3025,3,1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',22178.78,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 15:04:38','2022-08-17 15:04:38'),(1694,7523,42285,3025,3,1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6063708.60,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 15:03:17','2022-08-17 15:03:17'),(1695,7523,42285,3025,3,1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',13585.37,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1696,7523,42285,3025,3,1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1721.19,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 15:05:47','2022-08-17 15:05:47'),(1697,7523,42285,3025,3,1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',554539.27,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1698,7523,42285,3025,3,1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',14776.34,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1699,7523,42285,3025,3,1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',851676.66,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1700,7523,42285,3025,3,1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1111.24,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL),(1701,7523,42285,3025,3,1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5060.29,NULL,NULL,1,'2022-08-17 12:10:28','2022-08-17 12:10:28',NULL);
INSERT INTO `balance_libro` VALUES (2033,7523,42285,3025,2,2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5591.90,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:55','2022-08-17 12:57:55'),(2034,7523,42285,3025,2,2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1754.44,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:55','2022-08-17 12:57:55'),(2035,7523,42285,3025,2,2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6452.92,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:55','2022-08-17 12:57:55'),(2036,7523,42285,3025,2,2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1928.01,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:55','2022-08-17 12:57:55'),(2037,7523,42285,3025,2,2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2120.45,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2038,7523,42285,3025,2,2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3290.62,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2039,7523,42285,3025,2,2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2792.99,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2040,7523,42285,3025,2,2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2871.40,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2041,7523,42285,3025,2,2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5120.48,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2042,7523,42285,3025,2,2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1577.10,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2043,7523,42285,3025,2,2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2061.32,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2044,7523,42285,3025,2,2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2307.40,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2045,7523,42285,3025,2,2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2424.62,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2046,7523,42285,3025,2,2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2703.97,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2047,7523,42285,3025,2,2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1725.60,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2048,7523,42285,3025,2,2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2507.68,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2049,7523,42285,3025,2,2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',7304.07,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2050,7523,42285,3025,2,2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1345.97,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2051,7523,42285,3025,2,2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2090.18,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2052,7523,42285,3025,2,2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',10162.63,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2053,7523,42285,3025,2,2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1319.98,NULL,NULL,1,'2022-08-17 12:29:20','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2054,7523,42285,3025,2,2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',12476.67,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:56','2022-08-17 12:57:56');
INSERT INTO `balance_libro` VALUES (2055,7523,42285,3025,2,2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3586.01,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2056,7523,42285,3025,2,2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3335.84,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2057,7523,42285,3025,2,2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1330.45,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2058,7523,42285,3025,2,2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',19254.57,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2059,7523,42285,3025,2,2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',9840.90,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2060,7523,42285,3025,2,2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1453.10,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:56','2022-08-17 12:57:56'),(2061,7523,42285,3025,2,2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2642.99,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2062,7523,42285,3025,2,2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5171.91,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2063,7523,42285,3025,2,2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3797.34,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2064,7523,42285,3025,2,2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11274.78,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2065,7523,42285,3025,2,2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2732.35,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2066,7523,42285,3025,2,2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3901.68,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2067,7523,42285,3025,2,2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',59345.51,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2068,7523,42285,3025,2,2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2058.19,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2069,7523,42285,3025,2,2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4650.64,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2070,7523,42285,3025,2,2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4729.67,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2071,7523,42285,3025,2,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3005.86,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2072,7523,42285,3025,2,2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2934.41,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2073,7523,42285,3025,2,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2703.16,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2074,7523,42285,3025,2,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5012.55,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2075,7523,42285,3025,2,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3511.31,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57'),(2076,7523,42285,3025,2,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6889.41,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:57','2022-08-17 12:57:57');
INSERT INTO `balance_libro` VALUES (2077,7523,42285,3025,2,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2886.14,NULL,NULL,1,'2022-08-17 12:29:21','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2078,7523,42285,3025,2,2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4197.99,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2079,7523,42285,3025,2,2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',7564.92,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2080,7523,42285,3025,2,2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3986.68,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2081,7523,42285,3025,2,2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2982.21,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2082,7523,42285,3025,2,2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3113.58,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2083,7523,42285,3025,2,2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3367.95,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2084,7523,42285,3025,2,2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6247.85,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2085,7523,42285,3025,2,2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3553.99,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2086,7523,42285,3025,2,2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2639.41,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2087,7523,42285,3025,2,2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',8792.00,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2088,7523,42285,3025,2,2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5637.73,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2089,7523,42285,3025,2,2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2831.46,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2090,7523,42285,3025,2,2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1844.44,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2091,7523,42285,3025,2,2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11654.19,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2092,7523,42285,3025,2,2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3705.65,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2093,7523,42285,3025,2,2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4385.19,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2094,7523,42285,3025,2,2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1005.55,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2095,7523,42285,3025,2,2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4789.12,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2096,7523,42285,3025,2,2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1885.60,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2097,7523,42285,3025,2,2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6615.24,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2098,7523,42285,3025,2,2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2656.08,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58');
INSERT INTO `balance_libro` VALUES (2099,7523,42285,3025,2,2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1645.60,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2100,7523,42285,3025,2,2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1758.90,NULL,NULL,1,'2022-08-17 12:29:22','2022-08-17 12:57:58','2022-08-17 12:57:58'),(2101,7523,42285,3025,2,2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1595.07,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2102,7523,42285,3025,2,2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2936.77,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2103,7523,42285,3025,2,2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1760.45,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2104,7523,42285,3025,2,2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3661.81,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2105,7523,42285,3025,2,2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5145.53,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2106,7523,42285,3025,2,2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',12247.29,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2107,7523,42285,3025,2,2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3114.84,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2108,7523,42285,3025,2,2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3024.84,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2109,7523,42285,3025,2,2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3475.59,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2110,7523,42285,3025,2,2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5550.34,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2111,7523,42285,3025,2,2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1042.85,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2112,7523,42285,3025,2,2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',13527.80,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2113,7523,42285,3025,2,2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',15978.12,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2114,7523,42285,3025,2,2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',7921.82,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2115,7523,42285,3025,2,2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',9573.52,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2116,7523,42285,3025,2,2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3471.04,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2117,7523,42285,3025,2,2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11543.19,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2118,7523,42285,3025,2,2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5720.15,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2119,7523,42285,3025,2,2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6509.09,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2120,7523,42285,3025,2,2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',9352.61,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59');
INSERT INTO `balance_libro` VALUES (2121,7523,42285,3025,2,2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',861.78,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:57:59','2022-08-17 12:57:59'),(2122,7523,42285,3025,2,2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6691.70,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2123,7523,42285,3025,2,2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4245.48,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2124,7523,42285,3025,2,2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',12277.20,NULL,NULL,1,'2022-08-17 12:29:23','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2125,7523,42285,3025,2,2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',8657.46,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2126,7523,42285,3025,2,2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',10191.08,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2127,7523,42285,3025,2,2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3570.84,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2128,7523,42285,3025,2,2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2331.64,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2129,7523,42285,3025,2,2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2232.64,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2130,7523,42285,3025,2,2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1511.41,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2131,7523,42285,3025,2,2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4220.78,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2132,7523,42285,3025,2,2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2554.89,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2133,7523,42285,3025,2,2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4674.00,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2134,7523,42285,3025,2,2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4471.50,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2135,7523,42285,3025,2,2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',8685.25,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2136,7523,42285,3025,2,2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11304.83,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2137,7523,42285,3025,2,2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1578.60,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2138,7523,42285,3025,2,2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5793.74,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2139,7523,42285,3025,2,2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2656.08,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2140,7523,42285,3025,2,2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1628.82,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2141,7523,42285,3025,2,2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3574.18,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2142,7523,42285,3025,2,2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',12422.63,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00');
INSERT INTO `balance_libro` VALUES (2143,7523,42285,3025,2,2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4709.62,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2144,7523,42285,3025,2,2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5116.12,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2145,7523,42285,3025,2,2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7998.08,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2146,7523,42285,3025,2,2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3606.18,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2147,7523,42285,3025,2,2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',10777.72,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:00','2022-08-17 12:58:00'),(2148,7523,42285,3025,2,2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2709.53,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2149,7523,42285,3025,2,2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',16770.60,NULL,NULL,1,'2022-08-17 12:29:24','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2150,7523,42285,3025,2,2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',634.17,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2151,7523,42285,3025,2,2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1785.60,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2152,7523,42285,3025,2,2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',10308.60,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2153,7523,42285,3025,2,2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1770.92,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2154,7523,42285,3025,2,2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3540.23,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2155,7523,42285,3025,2,2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2972.99,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2156,7523,42285,3025,2,2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2452.34,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2157,7523,42285,3025,2,2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2640.03,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2158,7523,42285,3025,2,2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1248.99,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2159,7523,42285,3025,2,2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',13512.81,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2160,7523,42285,3025,2,2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',10315.60,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2161,7523,42285,3025,2,2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2160.23,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2162,7523,42285,3025,2,2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1989.13,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2163,7523,42285,3025,2,2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7925.94,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2164,7523,42285,3025,2,2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2732.35,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01');
INSERT INTO `balance_libro` VALUES (2165,7523,42285,3025,2,2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1142.11,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2166,7523,42285,3025,2,2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3712.34,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2167,7523,42285,3025,2,2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1536.25,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2168,7523,42285,3025,2,2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2525.37,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2169,7523,42285,3025,2,2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1196.07,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2170,7523,42285,3025,2,2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1752.84,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2171,7523,42285,3025,2,2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',11367.00,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2172,7523,42285,3025,2,2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2161.94,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2173,7523,42285,3025,2,2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2231.22,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2174,7523,42285,3025,2,2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2356.40,NULL,NULL,1,'2022-08-17 12:29:25','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2175,7523,42285,3025,2,2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5425.21,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2176,7523,42285,3025,2,2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4547.18,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2177,7523,42285,3025,2,2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2802.68,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2178,7523,42285,3025,2,2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2474.41,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2179,7523,42285,3025,2,2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1254.66,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2180,7523,42285,3025,2,2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1559.49,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2181,7523,42285,3025,2,2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3440.31,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2182,7523,42285,3025,2,2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1225.42,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2183,7523,42285,3025,2,2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3328.13,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2184,7523,42285,3025,2,2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3186.72,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2185,7523,42285,3025,2,2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4269.86,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01'),(2186,7523,42285,3025,2,2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3390.95,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:01','2022-08-17 12:58:01');
INSERT INTO `balance_libro` VALUES (2187,7523,42285,3025,2,2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3661.81,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2188,7523,42285,3025,2,2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2887.99,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2189,7523,42285,3025,2,2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1703.82,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2190,7523,42285,3025,2,2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2114.90,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2191,7523,42285,3025,2,2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1340.63,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2192,7523,42285,3025,2,2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6421.40,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2193,7523,42285,3025,2,2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3026.94,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2194,7523,42285,3025,2,2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7485.27,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2195,7523,42285,3025,2,2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',11661.96,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2196,7523,42285,3025,2,2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1681.06,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2197,7523,42285,3025,2,2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2241.78,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2198,7523,42285,3025,2,2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2030.07,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2199,7523,42285,3025,2,2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4096.68,NULL,NULL,1,'2022-08-17 12:29:26','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2200,7523,42285,3025,2,2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3335.84,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2201,7523,42285,3025,2,2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7351.24,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2202,7523,42285,3025,2,2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3401.94,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2203,7523,42285,3025,2,2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5156.82,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2204,7523,42285,3025,2,2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3193.84,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2205,7523,42285,3025,2,2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',20374.34,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2206,7523,42285,3025,2,2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4813.22,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2207,7523,42285,3025,2,2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1235.58,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2208,7523,42285,3025,2,2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1513.94,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02');
INSERT INTO `balance_libro` VALUES (2209,7523,42285,3025,2,2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6213.87,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2210,7523,42285,3025,2,2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3090.00,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2211,7523,42285,3025,2,2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',9310.04,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2212,7523,42285,3025,2,2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3248.62,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2213,7523,42285,3025,2,2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7420.84,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2214,7523,42285,3025,2,2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1590.45,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2215,7523,42285,3025,2,2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1461.95,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2216,7523,42285,3025,2,2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3826.68,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2217,7523,42285,3025,2,2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2192.68,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2218,7523,42285,3025,2,2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8160.50,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2219,7523,42285,3025,2,2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1514.80,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2220,7523,42285,3025,2,2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4262.68,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2221,7523,42285,3025,2,2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3707.68,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2222,7523,42285,3025,2,2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1996.50,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2223,7523,42285,3025,2,2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2003.68,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2224,7523,42285,3025,2,2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4027.94,NULL,NULL,1,'2022-08-17 12:29:27','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2225,7523,42285,3025,2,2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1206.73,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2226,7523,42285,3025,2,2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7109.05,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2227,7523,42285,3025,2,2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2637.17,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2228,7523,42285,3025,2,2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1043.10,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2229,7523,42285,3025,2,2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6345.93,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:02','2022-08-17 12:58:02'),(2230,7523,42285,3025,2,2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5174.94,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:02','2022-08-17 12:58:02');
INSERT INTO `balance_libro` VALUES (2231,7523,42285,3025,2,2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',63735.20,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2232,7523,42285,3025,2,2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',32705.10,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2233,7523,42285,3025,2,2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4238.22,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2234,7523,42285,3025,2,2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6297.95,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2235,7523,42285,3025,2,2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3434.25,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2236,7523,42285,3025,2,2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4780.14,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2237,7523,42285,3025,2,2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',39363.60,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2238,7523,42285,3025,2,2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6541.26,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2239,7523,42285,3025,2,2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3793.19,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2240,7523,42285,3025,2,2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3282.34,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2241,7523,42285,3025,2,2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7797.00,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2242,7523,42285,3025,2,2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4633.43,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2243,7523,42285,3025,2,2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',11470.80,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2244,7523,42285,3025,2,2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1656.25,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2245,7523,42285,3025,2,2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2740.94,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2246,7523,42285,3025,2,2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',10409.54,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2247,7523,42285,3025,2,2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3199.47,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2248,7523,42285,3025,2,2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2759.76,NULL,NULL,1,'2022-08-17 12:29:28','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2249,7523,42285,3025,2,2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5120.62,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2250,7523,42285,3025,2,2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2912.58,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2251,7523,42285,3025,2,2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3409.50,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2252,7523,42285,3025,2,2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2458.24,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03');
INSERT INTO `balance_libro` VALUES (2253,7523,42285,3025,2,2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2108.87,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2254,7523,42285,3025,2,2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2655.49,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2255,7523,42285,3025,2,2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3432.18,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2256,7523,42285,3025,2,2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2416.94,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2257,7523,42285,3025,2,2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',14161.80,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2258,7523,42285,3025,2,2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1966.51,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2259,7523,42285,3025,2,2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3756.89,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2260,7523,42285,3025,2,2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1018.52,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2261,7523,42285,3025,2,2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3614.34,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2262,7523,42285,3025,2,2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6299.67,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2263,7523,42285,3025,2,2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4820.48,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2264,7523,42285,3025,2,2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3944.49,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2265,7523,42285,3025,2,2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',12122.20,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2266,7523,42285,3025,2,2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8465.49,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2267,7523,42285,3025,2,2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4490.82,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2268,7523,42285,3025,2,2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2159.40,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2269,7523,42285,3025,2,2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',14905.80,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2270,7523,42285,3025,2,2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4221.80,NULL,NULL,1,'2022-08-17 12:29:29','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2271,7523,42285,3025,2,2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3430.14,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2272,7523,42285,3025,2,2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2300.90,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2273,7523,42285,3025,2,2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4221.80,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2274,7523,42285,3025,2,2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3979.16,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:03','2022-08-17 12:58:03');
INSERT INTO `balance_libro` VALUES (2275,7523,42285,3025,2,2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2656.08,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2276,7523,42285,3025,2,2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1565.60,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2277,7523,42285,3025,2,2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1563.38,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2278,7523,42285,3025,2,2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1563.38,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:03','2022-08-17 12:58:03'),(2279,7523,42285,3025,2,2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4903.89,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2280,7523,42285,3025,2,2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3782.09,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2281,7523,42285,3025,2,2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2368.59,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2282,7523,42285,3025,2,2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1800.60,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2283,7523,42285,3025,2,2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',21060.00,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2284,7523,42285,3025,2,2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8579.00,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2285,7523,42285,3025,2,2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3732.91,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2286,7523,42285,3025,2,2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2732.35,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2287,7523,42285,3025,2,2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2392.39,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2288,7523,42285,3025,2,2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3182.34,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2289,7523,42285,3025,2,2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5248.35,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2290,7523,42285,3025,2,2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1042.85,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2291,7523,42285,3025,2,2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2545.43,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2292,7523,42285,3025,2,2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6200.04,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2293,7523,42285,3025,2,2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1412.43,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2294,7523,42285,3025,2,2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',30577.50,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2295,7523,42285,3025,2,2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',20849.50,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2296,7523,42285,3025,2,2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3251.08,NULL,NULL,1,'2022-08-17 12:29:30','2022-08-17 12:58:04','2022-08-17 12:58:04');
INSERT INTO `balance_libro` VALUES (2297,7523,42285,3025,2,2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1850.36,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2298,7523,42285,3025,2,2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1569.88,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2299,7523,42285,3025,2,2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',10777.72,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2300,7523,42285,3025,2,2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7132.83,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2301,7523,42285,3025,2,2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2640.87,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2302,7523,42285,3025,2,2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3007.22,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2303,7523,42285,3025,2,2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2587.50,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2304,7523,42285,3025,2,2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7043.02,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2305,7523,42285,3025,2,2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',63011.23,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2306,7523,42285,3025,2,2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2657.49,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2307,7523,42285,3025,2,2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1664.54,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2308,7523,42285,3025,2,2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4309.14,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2309,7523,42285,3025,2,2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3236.15,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2310,7523,42285,3025,2,2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4872.78,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2311,7523,42285,3025,2,2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8829.35,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2312,7523,42285,3025,2,2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',47489.38,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2313,7523,42285,3025,2,2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6020.00,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2314,7523,42285,3025,2,2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1138.86,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2315,7523,42285,3025,2,2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1780.04,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2316,7523,42285,3025,2,2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2271.72,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2317,7523,42285,3025,2,2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',12953.50,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2318,7523,42285,3025,2,2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3696.81,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04');
INSERT INTO `balance_libro` VALUES (2319,7523,42285,3025,2,2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',10950.38,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2320,7523,42285,3025,2,2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2768.91,NULL,NULL,1,'2022-08-17 12:29:31','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2321,7523,42285,3025,2,2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2394.71,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:04','2022-08-17 12:58:04'),(2322,7523,42285,3025,2,2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2764.51,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2323,7523,42285,3025,2,2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2746.10,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2324,7523,42285,3025,2,2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2384.55,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2325,7523,42285,3025,2,2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4394.72,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2326,7523,42285,3025,2,2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4484.26,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2327,7523,42285,3025,2,2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1272.00,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2328,7523,42285,3025,2,2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',13049.79,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2329,7523,42285,3025,2,2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5845.83,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2330,7523,42285,3025,2,2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2355.60,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2331,7523,42285,3025,2,2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1800.60,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2332,7523,42285,3025,2,2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2801.94,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2333,7523,42285,3025,2,2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2027.53,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2334,7523,42285,3025,2,2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2870.21,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2335,7523,42285,3025,2,2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2355.60,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2336,7523,42285,3025,2,2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',16781.25,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2337,7523,42285,3025,2,2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1323.80,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2338,7523,42285,3025,2,2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3003.99,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2339,7523,42285,3025,2,2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1283.53,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2340,7523,42285,3025,2,2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2171.94,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05');
INSERT INTO `balance_libro` VALUES (2341,7523,42285,3025,2,2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4135.16,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2342,7523,42285,3025,2,2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1781.10,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2343,7523,42285,3025,2,2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',24219.00,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2344,7523,42285,3025,2,2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3082.00,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2345,7523,42285,3025,2,2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3003.99,NULL,NULL,1,'2022-08-17 12:29:32','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2346,7523,42285,3025,2,2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',11325.81,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2347,7523,42285,3025,2,2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4420.04,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2348,7523,42285,3025,2,2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3491.99,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2349,7523,42285,3025,2,2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3122.84,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2350,7523,42285,3025,2,2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5169.62,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2351,7523,42285,3025,2,2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2998.13,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2352,7523,42285,3025,2,2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2254.91,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2353,7523,42285,3025,2,2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2814.99,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2354,7523,42285,3025,2,2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2239.26,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2355,7523,42285,3025,2,2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2946.39,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2356,7523,42285,3025,2,2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',16317.20,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2357,7523,42285,3025,2,2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2814.99,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2358,7523,42285,3025,2,2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4110.64,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2359,7523,42285,3025,2,2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2958.99,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2360,7523,42285,3025,2,2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4427.50,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2361,7523,42285,3025,2,2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',10986.80,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2362,7523,42285,3025,2,2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15711.00,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05');
INSERT INTO `balance_libro` VALUES (2363,7523,42285,3025,2,2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2532.19,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2364,7523,42285,3025,2,2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3371.34,NULL,NULL,1,'2022-08-17 12:29:33','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2365,7523,42285,3025,2,2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2946.39,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2366,7523,42285,3025,2,2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2511.96,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:05','2022-08-17 12:58:05'),(2367,7523,42285,3025,2,2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1322.25,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2368,7523,42285,3025,2,2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3690.84,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2369,7523,42285,3025,2,2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4081.20,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2370,7523,42285,3025,2,2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2183.11,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2371,7523,42285,3025,2,2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3480.99,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2372,7523,42285,3025,2,2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1685.57,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2373,7523,42285,3025,2,2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4008.31,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2374,7523,42285,3025,2,2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1270.22,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2375,7523,42285,3025,2,2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2986.51,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2376,7523,42285,3025,2,2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7925.94,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2377,7523,42285,3025,2,2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6248.87,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2378,7523,42285,3025,2,2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6346.30,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2379,7523,42285,3025,2,2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1062.30,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2380,7523,42285,3025,2,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4530.58,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2381,7523,42285,3025,2,2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3592.34,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2382,7523,42285,3025,2,2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',25250.00,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2383,7523,42285,3025,2,2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5039.00,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2384,7523,42285,3025,2,2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2130.35,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06');
INSERT INTO `balance_libro` VALUES (2385,7523,42285,3025,2,2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4587.64,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2386,7523,42285,3025,2,2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2958.99,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2387,7523,42285,3025,2,2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4269.86,NULL,NULL,1,'2022-08-17 12:29:34','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2388,7523,42285,3025,2,2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3874.68,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2389,7523,42285,3025,2,2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1281.06,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2390,7523,42285,3025,2,2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2648.41,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2391,7523,42285,3025,2,2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4548.68,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2392,7523,42285,3025,2,2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1281.06,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2393,7523,42285,3025,2,2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1916.40,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2394,7523,42285,3025,2,2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4198.38,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2395,7523,42285,3025,2,2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4394.72,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2396,7523,42285,3025,2,2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',13949.55,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2397,7523,42285,3025,2,2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4848.13,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2398,7523,42285,3025,2,2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3104.50,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2399,7523,42285,3025,2,2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1246.45,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2400,7523,42285,3025,2,2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8579.00,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2401,7523,42285,3025,2,2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8980.85,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2402,7523,42285,3025,2,2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3384.79,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2403,7523,42285,3025,2,2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4716.78,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2404,7523,42285,3025,2,2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8098.53,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2405,7523,42285,3025,2,2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3292.99,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2406,7523,42285,3025,2,2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1548.99,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06');
INSERT INTO `balance_libro` VALUES (2407,7523,42285,3025,2,2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1477.52,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2408,7523,42285,3025,2,2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4190.09,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2409,7523,42285,3025,2,2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',13893.00,NULL,NULL,1,'2022-08-17 12:29:35','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2410,7523,42285,3025,2,2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7017.29,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2411,7523,42285,3025,2,2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6470.67,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2412,7523,42285,3025,2,2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1008.94,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2413,7523,42285,3025,2,2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1952.32,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2414,7523,42285,3025,2,2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3424.81,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2415,7523,42285,3025,2,2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3522.86,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2416,7523,42285,3025,2,2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7934.64,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:06','2022-08-17 12:58:06'),(2417,7523,42285,3025,2,2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4429.30,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2418,7523,42285,3025,2,2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2315.49,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2419,7523,42285,3025,2,2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7286.88,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2420,7523,42285,3025,2,2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6541.26,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2421,7523,42285,3025,2,2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4223.23,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2422,7523,42285,3025,2,2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',9125.07,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2423,7523,42285,3025,2,2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2262.42,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2424,7523,42285,3025,2,2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4014.00,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2425,7523,42285,3025,2,2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1928.53,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2426,7523,42285,3025,2,2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15526.77,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2427,7523,42285,3025,2,2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15526.77,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2428,7523,42285,3025,2,2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2416.94,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07');
INSERT INTO `balance_libro` VALUES (2429,7523,42285,3025,2,2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1848.25,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2430,7523,42285,3025,2,2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',14445.29,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2431,7523,42285,3025,2,2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1825.60,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2432,7523,42285,3025,2,2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3722.49,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2433,7523,42285,3025,2,2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3870.84,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2434,7523,42285,3025,2,2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2618.47,NULL,NULL,1,'2022-08-17 12:29:36','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2435,7523,42285,3025,2,2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4820.64,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2436,7523,42285,3025,2,2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1115.61,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2437,7523,42285,3025,2,2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7078.50,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2438,7523,42285,3025,2,2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6015.50,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2439,7523,42285,3025,2,2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3146.91,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2440,7523,42285,3025,2,2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2932.87,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2441,7523,42285,3025,2,2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2266.40,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2442,7523,42285,3025,2,2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4770.64,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2443,7523,42285,3025,2,2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8095.63,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2444,7523,42285,3025,2,2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1478.39,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2445,7523,42285,3025,2,2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',11775.03,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2446,7523,42285,3025,2,2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2981.49,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2447,7523,42285,3025,2,2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',35067.32,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2448,7523,42285,3025,2,2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1989.11,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2449,7523,42285,3025,2,2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1667.95,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2450,7523,42285,3025,2,2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3265.89,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07');
INSERT INTO `balance_libro` VALUES (2451,7523,42285,3025,2,2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',10236.03,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2452,7523,42285,3025,2,2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2150.40,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2453,7523,42285,3025,2,2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1283.53,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2454,7523,42285,3025,2,2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5598.70,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2455,7523,42285,3025,2,2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5711.12,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2456,7523,42285,3025,2,2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3565.31,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2457,7523,42285,3025,2,2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4441.47,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2458,7523,42285,3025,2,2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',9604.15,NULL,NULL,1,'2022-08-17 12:29:37','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2459,7523,42285,3025,2,2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5062.01,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2460,7523,42285,3025,2,2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3712.34,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2461,7523,42285,3025,2,2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6672.51,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2462,7523,42285,3025,2,2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',16083.10,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2463,7523,42285,3025,2,2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3458.49,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2464,7523,42285,3025,2,2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5404.96,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2465,7523,42285,3025,2,2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1018.37,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2466,7523,42285,3025,2,2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4320.04,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2467,7523,42285,3025,2,2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1933.00,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2468,7523,42285,3025,2,2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8993.00,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2469,7523,42285,3025,2,2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3306.94,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:07','2022-08-17 12:58:07'),(2470,7523,42285,3025,2,2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1350.47,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2471,7523,42285,3025,2,2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2742.71,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2472,7523,42285,3025,2,2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',17639.44,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08');
INSERT INTO `balance_libro` VALUES (2473,7523,42285,3025,2,2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3522.93,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2474,7523,42285,3025,2,2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1393.79,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2475,7523,42285,3025,2,2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5590.20,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2476,7523,42285,3025,2,2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2315.49,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2477,7523,42285,3025,2,2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6450.44,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2478,7523,42285,3025,2,2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',9274.60,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2479,7523,42285,3025,2,2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3895.24,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2480,7523,42285,3025,2,2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2657.81,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2481,7523,42285,3025,2,2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',17908.05,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2482,7523,42285,3025,2,2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2403.41,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2483,7523,42285,3025,2,2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4029.74,NULL,NULL,1,'2022-08-17 12:29:38','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2484,7523,42285,3025,2,2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3082.00,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2485,7523,42285,3025,2,2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15802.60,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2486,7523,42285,3025,2,2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5154.30,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2487,7523,42285,3025,2,2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',20607.83,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2488,7523,42285,3025,2,2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4285.24,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2489,7523,42285,3025,2,2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6668.81,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2490,7523,42285,3025,2,2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3182.34,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2491,7523,42285,3025,2,2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',16268.81,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2492,7523,42285,3025,2,2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4297.08,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2493,7523,42285,3025,2,2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4319.14,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2494,7523,42285,3025,2,2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2337.99,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08');
INSERT INTO `balance_libro` VALUES (2495,7523,42285,3025,2,2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1289.07,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2496,7523,42285,3025,2,2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4113.55,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2497,7523,42285,3025,2,2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2594.34,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2498,7523,42285,3025,2,2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3588.12,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2499,7523,42285,3025,2,2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5145.53,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2500,7523,42285,3025,2,2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3174.17,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2501,7523,42285,3025,2,2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1410.36,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2502,7523,42285,3025,2,2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4273.96,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2503,7523,42285,3025,2,2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7901.30,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2504,7523,42285,3025,2,2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2422.23,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2505,7523,42285,3025,2,2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1770.45,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2506,7523,42285,3025,2,2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2399.09,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2507,7523,42285,3025,2,2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1932.68,NULL,NULL,1,'2022-08-17 12:29:39','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2508,7523,42285,3025,2,2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1952.32,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2509,7523,42285,3025,2,2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2525.58,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2510,7523,42285,3025,2,2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8951.66,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2511,7523,42285,3025,2,2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5894.77,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2512,7523,42285,3025,2,2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2814.99,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2513,7523,42285,3025,2,2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2446.66,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2514,7523,42285,3025,2,2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5418.55,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2515,7523,42285,3025,2,2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',9740.78,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2516,7523,42285,3025,2,2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2437.68,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08');
INSERT INTO `balance_libro` VALUES (2517,7523,42285,3025,2,2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4702.11,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2518,7523,42285,3025,2,2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7370.45,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2519,7523,42285,3025,2,2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7326.72,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2520,7523,42285,3025,2,2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7267.29,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2521,7523,42285,3025,2,2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18584.30,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2522,7523,42285,3025,2,2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3159.39,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2523,7523,42285,3025,2,2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4159.15,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:08','2022-08-17 12:58:08'),(2524,7523,42285,3025,2,2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',25250.00,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2525,7523,42285,3025,2,2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5736.82,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2526,7523,42285,3025,2,2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1825.60,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2527,7523,42285,3025,2,2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2507.47,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2528,7523,42285,3025,2,2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3476.09,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2529,7523,42285,3025,2,2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2827.53,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2530,7523,42285,3025,2,2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3373.89,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2531,7523,42285,3025,2,2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3373.89,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2532,7523,42285,3025,2,2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2337.99,NULL,NULL,1,'2022-08-17 12:29:40','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2533,7523,42285,3025,2,2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6910.08,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2534,7523,42285,3025,2,2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3174.72,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2535,7523,42285,3025,2,2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7289.00,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2536,7523,42285,3025,2,2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5120.62,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2537,7523,42285,3025,2,2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',9358.10,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2538,7523,42285,3025,2,2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',13271.50,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09');
INSERT INTO `balance_libro` VALUES (2539,7523,42285,3025,2,2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4566.12,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2540,7523,42285,3025,2,2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2425.11,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2541,7523,42285,3025,2,2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',12422.63,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2542,7523,42285,3025,2,2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2696.99,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2543,7523,42285,3025,2,2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3155.58,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2544,7523,42285,3025,2,2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1769.61,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2545,7523,42285,3025,2,2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2943.19,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2546,7523,42285,3025,2,2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3564.84,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2547,7523,42285,3025,2,2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',20017.36,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2548,7523,42285,3025,2,2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3490.79,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2549,7523,42285,3025,2,2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2522.66,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2550,7523,42285,3025,2,2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',13527.80,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2551,7523,42285,3025,2,2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8632.38,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2552,7523,42285,3025,2,2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4228.95,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2553,7523,42285,3025,2,2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3770.60,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2554,7523,42285,3025,2,2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6810.39,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2555,7523,42285,3025,2,2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5623.19,NULL,NULL,1,'2022-08-17 12:29:41','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2556,7523,42285,3025,2,2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2697.99,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2557,7523,42285,3025,2,2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5309.73,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2558,7523,42285,3025,2,2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1023.53,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2559,7523,42285,3025,2,2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',9388.85,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2560,7523,42285,3025,2,2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7979.40,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09');
INSERT INTO `balance_libro` VALUES (2561,7523,42285,3025,2,2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6057.43,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2562,7523,42285,3025,2,2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3203.74,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2563,7523,42285,3025,2,2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2661.89,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2564,7523,42285,3025,2,2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4916.53,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2565,7523,42285,3025,2,2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3784.81,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2566,7523,42285,3025,2,2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',12574.03,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2567,7523,42285,3025,2,2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7979.40,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:09','2022-08-17 12:58:09'),(2568,7523,42285,3025,2,2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2447.53,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2569,7523,42285,3025,2,2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1709.58,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2570,7523,42285,3025,2,2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',5637.73,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2571,7523,42285,3025,2,2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',3991.94,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2572,7523,42285,3025,2,2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8764.05,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2573,7523,42285,3025,2,2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6409.52,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2574,7523,42285,3025,2,2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1737.66,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2575,7523,42285,3025,2,2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2832.99,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2576,7523,42285,3025,2,2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6450.44,NULL,NULL,1,'2022-08-17 12:29:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2577,7523,42285,3025,2,2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6451.42,NULL,NULL,1,'2022-08-17 12:29:43','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2578,7523,42285,3025,2,2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4861.08,NULL,NULL,1,'2022-08-17 12:29:43','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2579,7523,42285,3025,2,2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6148.63,NULL,NULL,1,'2022-08-17 12:29:43','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2580,7523,42285,3025,2,2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2889.24,NULL,NULL,1,'2022-08-17 12:29:43','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2581,7523,42285,3025,2,2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1911.94,NULL,NULL,1,'2022-08-17 12:29:43','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2582,7523,42285,3025,2,2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7289.00,NULL,NULL,1,'2022-08-17 12:29:43','2022-08-17 12:58:10','2022-08-17 12:58:10');
INSERT INTO `balance_libro` VALUES (2583,7523,42285,3025,2,2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2119.11,NULL,NULL,1,'2022-08-17 12:29:43','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2584,7523,42285,3025,2,2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',8993.00,NULL,NULL,1,'2022-08-17 12:29:43','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2969,NULL,42285,3025,2,2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2677.68,NULL,NULL,1,'2022-08-17 12:45:40','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2970,NULL,42285,3025,2,2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5580.52,NULL,NULL,1,'2022-08-17 12:45:40','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2971,NULL,42285,3025,2,2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3838.00,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2972,NULL,42285,3025,2,2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4399.56,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2973,NULL,42285,3025,2,2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6259.09,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2974,NULL,42285,3025,2,2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',13650.86,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2975,NULL,42285,3025,2,2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',14905.80,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2976,NULL,42285,3025,2,2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1772.09,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2977,NULL,42285,3025,2,2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',39783.60,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2978,NULL,42285,3025,2,2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2426.59,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2979,NULL,42285,3025,2,2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',15461.00,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2980,NULL,42285,3025,2,2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6919.74,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2981,NULL,42285,3025,2,2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3702.19,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2982,NULL,42285,3025,2,2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',10521.20,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2983,NULL,42285,3025,2,2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6321.42,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2984,NULL,42285,3025,2,2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5866.08,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2985,NULL,42285,3025,2,2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5866.08,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2986,NULL,42285,3025,2,2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',15286.62,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2987,NULL,42285,3025,2,2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5095.54,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2988,NULL,42285,3025,2,2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',11489.47,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10');
INSERT INTO `balance_libro` VALUES (2989,NULL,42285,3025,2,2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1363.10,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2990,NULL,42285,3025,2,2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',929.42,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2991,NULL,42285,3025,2,2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4054.60,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2992,NULL,42285,3025,2,2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',9125.07,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2993,NULL,42285,3025,2,2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2961.83,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2994,NULL,42285,3025,2,2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',833.21,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2995,NULL,42285,3025,2,2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4334.07,NULL,NULL,1,'2022-08-17 12:45:41','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2996,NULL,42285,3025,2,2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2340.14,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2997,NULL,42285,3025,2,2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',15022.11,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2998,NULL,42285,3025,2,2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4887.90,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(2999,NULL,42285,3025,2,2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',2815.31,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(3000,NULL,42285,3025,2,3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',3620.04,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(3001,NULL,42285,3025,2,3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',34468.41,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(3002,NULL,42285,3025,2,3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',22978.94,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(3003,NULL,42285,3025,2,3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',11489.47,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(3004,NULL,42285,3025,2,3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4110.48,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(3005,NULL,42285,3025,2,3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4020.23,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(3006,NULL,42285,3025,2,3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3154.50,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:10','2022-08-17 12:58:10'),(3007,NULL,42285,3025,2,3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',12537.69,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3008,NULL,42285,3025,2,3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',22874.65,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3009,NULL,42285,3025,2,3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',22874.65,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3010,NULL,42285,3025,2,3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2767.94,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:11','2022-08-17 12:58:11');
INSERT INTO `balance_libro` VALUES (3011,NULL,42285,3025,2,3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7083.47,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3012,NULL,42285,3025,2,3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',22874.65,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3013,NULL,42285,3025,2,3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2833.14,NULL,NULL,1,'2022-08-17 12:45:42','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3014,NULL,42285,3025,2,3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2400.77,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3015,NULL,42285,3025,2,3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2189.63,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3016,NULL,42285,3025,2,3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2767.94,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3017,NULL,42285,3025,2,3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1954.10,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3018,NULL,42285,3025,2,3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1273.20,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3019,NULL,42285,3025,2,3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2693.36,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3020,NULL,42285,3025,2,3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1565.89,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3021,NULL,42285,3025,2,3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4304.00,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3022,NULL,42285,3025,2,3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3442.01,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3023,NULL,42285,3025,2,3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2764.02,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3024,NULL,42285,3025,2,3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3687.01,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3025,NULL,42285,3025,2,3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',9173.23,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3026,NULL,42285,3025,2,3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4275.30,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3027,NULL,42285,3025,2,3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',18486.05,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3028,NULL,42285,3025,2,3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1314.66,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3029,NULL,42285,3025,2,3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3364.92,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3030,NULL,42285,3025,2,3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2717.51,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3031,NULL,42285,3025,2,3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1349.15,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3032,NULL,42285,3025,2,3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1529.49,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11');
INSERT INTO `balance_libro` VALUES (3033,NULL,42285,3025,2,3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3307.01,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3034,NULL,42285,3025,2,3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1169.93,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3035,NULL,42285,3025,2,3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',16538.70,NULL,NULL,1,'2022-08-17 12:45:43','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3036,NULL,42285,3025,2,3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',12167.88,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3037,NULL,42285,3025,2,3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2141.52,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3038,NULL,42285,3025,2,3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7249.22,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3039,NULL,42285,3025,2,3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2220.52,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3040,NULL,42285,3025,2,3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2455.04,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3041,NULL,42285,3025,2,3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6597.29,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3042,NULL,42285,3025,2,3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1687.48,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3043,NULL,42285,3025,2,3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',47971.98,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3044,NULL,42285,3025,2,3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2144.60,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3045,NULL,42285,3025,2,3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2220.57,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3046,NULL,42285,3025,2,3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2779.02,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3047,NULL,42285,3025,2,3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2064.38,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3048,NULL,42285,3025,2,3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5687.47,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3049,NULL,42285,3025,2,3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2035.36,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3050,NULL,42285,3025,2,3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5071.95,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3051,NULL,42285,3025,2,3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1820.43,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3052,NULL,42285,3025,2,3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',21945.04,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:11','2022-08-17 12:58:11'),(3053,NULL,42285,3025,2,3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1115.61,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3054,NULL,42285,3025,2,3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3724.39,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12');
INSERT INTO `balance_libro` VALUES (3055,NULL,42285,3025,2,3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7322.89,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3056,NULL,42285,3025,2,3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',9125.07,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3057,NULL,42285,3025,2,3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5587.66,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3058,NULL,42285,3025,2,3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4752.88,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3059,NULL,42285,3025,2,3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7901.30,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3060,NULL,42285,3025,2,3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',11994.95,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3061,NULL,42285,3025,2,3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',41090.28,NULL,NULL,1,'2022-08-17 12:45:44','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3062,NULL,42285,3025,2,3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',10564.56,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3063,NULL,42285,3025,2,3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',9405.00,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3064,NULL,42285,3025,2,3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5529.47,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3065,NULL,42285,3025,2,3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',12643.60,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3066,NULL,42285,3025,2,3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7134.03,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3067,NULL,42285,3025,2,3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4408.32,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3068,NULL,42285,3025,2,3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',748.09,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3069,NULL,42285,3025,2,3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5159.45,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3070,NULL,42285,3025,2,3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2367.68,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3071,NULL,42285,3025,2,3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6083.37,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3072,NULL,42285,3025,2,3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7392.48,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3073,NULL,42285,3025,2,3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',10015.29,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3074,NULL,42285,3025,2,3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',12620.63,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3075,NULL,42285,3025,2,3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',10174.75,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3076,NULL,42285,3025,2,3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',10415.30,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12');
INSERT INTO `balance_libro` VALUES (3077,NULL,42285,3025,2,3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6527.90,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3078,NULL,42285,3025,2,3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5489.61,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3079,NULL,42285,3025,2,3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',15286.41,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3080,NULL,42285,3025,2,3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2172.77,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3081,NULL,42285,3025,2,3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2619.51,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3082,NULL,42285,3025,2,3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5095.54,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3083,NULL,42285,3025,2,3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7274.71,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3084,NULL,42285,3025,2,3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1040.04,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3085,NULL,42285,3025,2,3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',24063.50,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:12','2022-08-17 12:58:12'),(3086,NULL,42285,3025,2,3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2030.36,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3087,NULL,42285,3025,2,3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3037.01,NULL,NULL,1,'2022-08-17 12:45:45','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3088,NULL,42285,3025,2,3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3243.70,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3089,NULL,42285,3025,2,3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1474.00,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3090,NULL,42285,3025,2,3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2368.31,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3091,NULL,42285,3025,2,3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5382.00,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3092,NULL,42285,3025,2,3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2709.51,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3093,NULL,42285,3025,2,3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1600.63,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3094,NULL,42285,3025,2,3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1612.63,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3095,NULL,42285,3025,2,3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3096,NULL,42285,3025,2,3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1301.43,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3097,NULL,42285,3025,2,3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2434.02,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3098,NULL,42285,3025,2,3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5788.80,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13');
INSERT INTO `balance_libro` VALUES (3099,NULL,42285,3025,2,3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2582.16,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3100,NULL,42285,3025,2,3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3355.71,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3101,NULL,42285,3025,2,3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1710.61,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3102,NULL,42285,3025,2,3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',955.66,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3103,NULL,42285,3025,2,3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',489.85,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3104,NULL,42285,3025,2,3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3547.72,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3105,NULL,42285,3025,2,3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3663.70,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3106,NULL,42285,3025,2,3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3107,NULL,42285,3025,2,3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2895.98,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3108,NULL,42285,3025,2,3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6426.16,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3109,NULL,42285,3025,2,3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2714.30,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3110,NULL,42285,3025,2,3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2006.52,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3111,NULL,42285,3025,2,3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4685.85,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3112,NULL,42285,3025,2,3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2327.02,NULL,NULL,1,'2022-08-17 12:45:46','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3113,NULL,42285,3025,2,3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3207.01,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3114,NULL,42285,3025,2,3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8335.57,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3115,NULL,42285,3025,2,3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6419.20,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3116,NULL,42285,3025,2,3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8946.44,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3117,NULL,42285,3025,2,3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5753.63,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3118,NULL,42285,3025,2,3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3119,NULL,42285,3025,2,3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22874.65,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3120,NULL,42285,3025,2,3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',21945.04,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13');
INSERT INTO `balance_libro` VALUES (3121,NULL,42285,3025,2,3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5418.67,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3122,NULL,42285,3025,2,3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6663.46,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3123,NULL,42285,3025,2,3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4164.49,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3124,NULL,42285,3025,2,3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11582.00,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3125,NULL,42285,3025,2,3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3097.81,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3126,NULL,42285,3025,2,3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3638.35,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3127,NULL,42285,3025,2,3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7455.84,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3128,NULL,42285,3025,2,3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4708.93,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3129,NULL,42285,3025,2,3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3130,NULL,42285,3025,2,3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2493.97,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3131,NULL,42285,3025,2,3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2791.66,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3132,NULL,42285,3025,2,3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',84163.88,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3133,NULL,42285,3025,2,3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7643.75,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3134,NULL,42285,3025,2,3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9371.70,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3135,NULL,42285,3025,2,3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2739.02,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3136,NULL,42285,3025,2,3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8583.99,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3137,NULL,42285,3025,2,3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2739.02,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3138,NULL,42285,3025,2,3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1382.75,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3139,NULL,42285,3025,2,3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2036.96,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3140,NULL,42285,3025,2,3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2574.99,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3141,NULL,42285,3025,2,3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7772.60,NULL,NULL,1,'2022-08-17 12:45:47','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3142,NULL,42285,3025,2,3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13');
INSERT INTO `balance_libro` VALUES (3143,NULL,42285,3025,2,3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2971.80,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3144,NULL,42285,3025,2,3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4121.19,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3145,NULL,42285,3025,2,3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2327.02,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3146,NULL,42285,3025,2,3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4598.35,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3147,NULL,42285,3025,2,3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1088.57,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3148,NULL,42285,3025,2,3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1427.48,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3149,NULL,42285,3025,2,3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3150,NULL,42285,3025,2,3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2884.02,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3151,NULL,42285,3025,2,3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3282.33,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3152,NULL,42285,3025,2,3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2457.46,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3153,NULL,42285,3025,2,3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4200.79,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3154,NULL,42285,3025,2,3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5394.96,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3155,NULL,42285,3025,2,3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4379.32,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:13','2022-08-17 12:58:13'),(3156,NULL,42285,3025,2,3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2265.86,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3157,NULL,42285,3025,2,3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2832.45,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3158,NULL,42285,3025,2,3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1759.03,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3159,NULL,42285,3025,2,3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11188.90,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3160,NULL,42285,3025,2,3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5095.54,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3161,NULL,42285,3025,2,3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1909.77,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3162,NULL,42285,3025,2,3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3163,NULL,42285,3025,2,3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4654.04,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3164,NULL,42285,3025,2,3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',14507.69,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14');
INSERT INTO `balance_libro` VALUES (3165,NULL,42285,3025,2,3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2814.88,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3166,NULL,42285,3025,2,3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1872.57,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3167,NULL,42285,3025,2,3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2096.52,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3168,NULL,42285,3025,2,3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9694.06,NULL,NULL,1,'2022-08-17 12:45:48','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3169,NULL,42285,3025,2,3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3496.60,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3170,NULL,42285,3025,2,3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1559.21,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3171,NULL,42285,3025,2,3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3172,NULL,42285,3025,2,3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2777.01,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3173,NULL,42285,3025,2,3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3586.60,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3174,NULL,42285,3025,2,3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',14334.08,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3175,NULL,42285,3025,2,3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1653.67,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3176,NULL,42285,3025,2,3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1420.43,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3177,NULL,42285,3025,2,3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3698.19,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3178,NULL,42285,3025,2,3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1000.62,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3179,NULL,42285,3025,2,3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9717.19,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3180,NULL,42285,3025,2,3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2705.80,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3181,NULL,42285,3025,2,3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22874.65,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3182,NULL,42285,3025,2,3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3931.37,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3183,NULL,42285,3025,2,3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',19682.25,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3184,NULL,42285,3025,2,3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1417.35,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3185,NULL,42285,3025,2,3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3540.70,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3186,NULL,42285,3025,2,3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14');
INSERT INTO `balance_libro` VALUES (3187,NULL,42285,3025,2,3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5984.00,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3188,NULL,42285,3025,2,3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2337.47,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3189,NULL,42285,3025,2,3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3190,NULL,42285,3025,2,3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1780.07,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3191,NULL,42285,3025,2,3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1226.37,NULL,NULL,1,'2022-08-17 12:45:49','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3192,NULL,42285,3025,2,3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4934.02,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3193,NULL,42285,3025,2,3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',88296.19,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3194,NULL,42285,3025,2,3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8551.61,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3195,NULL,42285,3025,2,3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5984.00,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3196,NULL,42285,3025,2,3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8603.48,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3197,NULL,42285,3025,2,3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3198,NULL,42285,3025,2,3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',16289.14,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3199,NULL,42285,3025,2,3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2458.37,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3200,NULL,42285,3025,2,3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2930.51,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3201,NULL,42285,3025,2,3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2709.51,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3202,NULL,42285,3025,2,3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2363.33,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3203,NULL,42285,3025,2,3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4252.49,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3204,NULL,42285,3025,2,3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1944.95,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3205,NULL,42285,3025,2,3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2070.47,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3206,NULL,42285,3025,2,3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3904.10,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3207,NULL,42285,3025,2,3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1735.21,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3208,NULL,42285,3025,2,3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2042.29,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14');
INSERT INTO `balance_libro` VALUES (3209,NULL,42285,3025,2,3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4293.45,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3210,NULL,42285,3025,2,3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',45344.37,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3211,NULL,42285,3025,2,3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3601.51,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3212,NULL,42285,3025,2,3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1544.10,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3213,NULL,42285,3025,2,3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1341.60,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3214,NULL,42285,3025,2,3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11907.63,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3215,NULL,42285,3025,2,3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3091.48,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3216,NULL,42285,3025,2,3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3364.71,NULL,NULL,1,'2022-08-17 12:45:50','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3217,NULL,42285,3025,2,3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2339.02,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3218,NULL,42285,3025,2,3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3219,NULL,42285,3025,2,3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6229.28,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3220,NULL,42285,3025,2,3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',40015.40,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3221,NULL,42285,3025,2,3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3739.92,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3222,NULL,42285,3025,2,3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22874.65,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:14','2022-08-17 12:58:14'),(3223,NULL,42285,3025,2,3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3759.10,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3224,NULL,42285,3025,2,3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2859.51,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3225,NULL,42285,3025,2,3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1544.10,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3226,NULL,42285,3025,2,3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3672.63,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3227,NULL,42285,3025,2,3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4679.82,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3228,NULL,42285,3025,2,3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1521.42,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3229,NULL,42285,3025,2,3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22874.65,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3230,NULL,42285,3025,2,3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2631.75,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15');
INSERT INTO `balance_libro` VALUES (3231,NULL,42285,3025,2,3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3307.01,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3232,NULL,42285,3025,2,3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5535.88,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3233,NULL,42285,3025,2,3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3807.60,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3234,NULL,42285,3025,2,3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',10754.50,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3235,NULL,42285,3025,2,3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9043.90,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3236,NULL,42285,3025,2,3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4654.04,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3237,NULL,42285,3025,2,3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1544.10,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3238,NULL,42285,3025,2,3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2222.31,NULL,NULL,1,'2022-08-17 12:45:51','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3239,NULL,42285,3025,2,3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',19499.53,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3240,NULL,42285,3025,2,3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2574.51,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3241,NULL,42285,3025,2,3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4075.14,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3242,NULL,42285,3025,2,3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3307.01,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3243,NULL,42285,3025,2,3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1946.32,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3244,NULL,42285,3025,2,3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1446.00,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3245,NULL,42285,3025,2,3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3102.01,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3246,NULL,42285,3025,2,3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4965.83,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3247,NULL,42285,3025,2,3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6916.63,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3248,NULL,42285,3025,2,3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',17527.53,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3249,NULL,42285,3025,2,3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2192.56,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3250,NULL,42285,3025,2,3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1875.47,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3251,NULL,42285,3025,2,3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2615.80,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3252,NULL,42285,3025,2,3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5535.88,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15');
INSERT INTO `balance_libro` VALUES (3253,NULL,42285,3025,2,3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2709.51,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3254,NULL,42285,3025,2,3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2971.80,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3255,NULL,42285,3025,2,3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',21945.04,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3256,NULL,42285,3025,2,3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6625.26,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3257,NULL,42285,3025,2,3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4597.70,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3258,NULL,42285,3025,2,3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4024.95,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3259,NULL,42285,3025,2,3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3260,NULL,42285,3025,2,3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5849.04,NULL,NULL,1,'2022-08-17 12:45:52','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3261,NULL,42285,3025,2,3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4031.22,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3262,NULL,42285,3025,2,3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2151.33,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3263,NULL,42285,3025,2,3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13962.12,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3264,NULL,42285,3025,2,3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2665.63,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3265,NULL,42285,3025,2,3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3266,NULL,42285,3025,2,3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3267,NULL,42285,3025,2,3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3726.21,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3268,NULL,42285,3025,2,3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5615.98,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3269,NULL,42285,3025,2,3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5250.48,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3270,NULL,42285,3025,2,3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',19682.25,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3271,NULL,42285,3025,2,3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3307.01,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3272,NULL,42285,3025,2,3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2793.14,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3273,NULL,42285,3025,2,3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2532.29,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3274,NULL,42285,3025,2,3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2362.52,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15');
INSERT INTO `balance_libro` VALUES (3275,NULL,42285,3025,2,3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22874.65,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3276,NULL,42285,3025,2,3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1313.59,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3277,NULL,42285,3025,2,3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8437.73,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3278,NULL,42285,3025,2,3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',36906.64,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3279,NULL,42285,3025,2,3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3967.17,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3280,NULL,42285,3025,2,3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1880.65,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3281,NULL,42285,3025,2,3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2777.01,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3282,NULL,42285,3025,2,3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3741.16,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3283,NULL,42285,3025,2,3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13732.30,NULL,NULL,1,'2022-08-17 12:45:53','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3284,NULL,42285,3025,2,3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7348.94,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3285,NULL,42285,3025,2,3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6426.16,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3286,NULL,42285,3025,2,3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5648.54,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3287,NULL,42285,3025,2,3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3288,NULL,42285,3025,2,3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6288.14,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3289,NULL,42285,3025,2,3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3627.63,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3290,NULL,42285,3025,2,3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1504.61,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:15','2022-08-17 12:58:15'),(3291,NULL,42285,3025,2,3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4097.58,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3292,NULL,42285,3025,2,3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4608.65,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3293,NULL,42285,3025,2,3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',21945.04,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3294,NULL,42285,3025,2,3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5535.88,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3295,NULL,42285,3025,2,3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4613.94,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3296,NULL,42285,3025,2,3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',47971.98,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16');
INSERT INTO `balance_libro` VALUES (3297,NULL,42285,3025,2,3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2662.31,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3298,NULL,42285,3025,2,3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3197.49,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3299,NULL,42285,3025,2,3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1775.46,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3300,NULL,42285,3025,2,3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3078.36,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3301,NULL,42285,3025,2,3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2023.91,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3302,NULL,42285,3025,2,3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1837.11,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3303,NULL,42285,3025,2,3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2884.61,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3304,NULL,42285,3025,2,3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2777.01,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3305,NULL,42285,3025,2,3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1759.03,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3306,NULL,42285,3025,2,3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1974.51,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3307,NULL,42285,3025,2,3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4031.91,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3308,NULL,42285,3025,2,3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5963.67,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3309,NULL,42285,3025,2,3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',16585.90,NULL,NULL,1,'2022-08-17 12:45:54','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3310,NULL,42285,3025,2,3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',16020.55,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3311,NULL,42285,3025,2,3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1288.41,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3312,NULL,42285,3025,2,3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3778.30,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3313,NULL,42285,3025,2,3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11489.47,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3314,NULL,42285,3025,2,3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3315,NULL,42285,3025,2,3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4191.13,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3316,NULL,42285,3025,2,3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2416.87,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3317,NULL,42285,3025,2,3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7368.41,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3318,NULL,42285,3025,2,3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2413.87,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16');
INSERT INTO `balance_libro` VALUES (3319,NULL,42285,3025,2,3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',21945.04,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3320,NULL,42285,3025,2,3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3321,NULL,42285,3025,2,3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1788.92,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3322,NULL,42285,3025,2,3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9769.06,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3323,NULL,42285,3025,2,3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',14498.44,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3324,NULL,42285,3025,2,3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2849.30,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3325,NULL,42285,3025,2,3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1855.82,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3326,NULL,42285,3025,2,3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3416.21,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3327,NULL,42285,3025,2,3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2073.41,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3328,NULL,42285,3025,2,3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1523.32,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3329,NULL,42285,3025,2,3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2611.51,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3330,NULL,42285,3025,2,3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3488.70,NULL,NULL,1,'2022-08-17 12:45:55','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3331,NULL,42285,3025,2,3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2597.54,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3332,NULL,42285,3025,2,3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5131.58,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3333,NULL,42285,3025,2,3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1974.10,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3334,NULL,42285,3025,2,3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3894.92,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3335,NULL,42285,3025,2,3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1971.32,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3336,NULL,42285,3025,2,3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',17115.00,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3337,NULL,42285,3025,2,3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4679.82,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3338,NULL,42285,3025,2,3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1593.06,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3339,NULL,42285,3025,2,3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1924.33,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3340,NULL,42285,3025,2,3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2292.47,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16');
INSERT INTO `balance_libro` VALUES (3341,NULL,42285,3025,2,3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2422.46,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3342,NULL,42285,3025,2,3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1807.78,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3343,NULL,42285,3025,2,3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2322.54,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3344,NULL,42285,3025,2,3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7520.83,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3345,NULL,42285,3025,2,3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9283.87,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3346,NULL,42285,3025,2,3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2594.02,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3347,NULL,42285,3025,2,3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2043.92,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3348,NULL,42285,3025,2,3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3153.30,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:16','2022-08-17 12:58:16'),(3349,NULL,42285,3025,2,3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4685.85,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3350,NULL,42285,3025,2,3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4043.29,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3351,NULL,42285,3025,2,3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3313.30,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3352,NULL,42285,3025,2,3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1965.46,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3353,NULL,42285,3025,2,3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2593.90,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3354,NULL,42285,3025,2,3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7205.82,NULL,NULL,1,'2022-08-17 12:45:56','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3355,NULL,42285,3025,2,3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5920.98,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3356,NULL,42285,3025,2,3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2634.63,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3357,NULL,42285,3025,2,3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5984.00,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3358,NULL,42285,3025,2,3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4186.42,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3359,NULL,42285,3025,2,3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5130.60,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3360,NULL,42285,3025,2,3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7045.38,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3361,NULL,42285,3025,2,3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9173.72,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3362,NULL,42285,3025,2,3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3985.33,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17');
INSERT INTO `balance_libro` VALUES (3363,NULL,42285,3025,2,3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7740.31,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3364,NULL,42285,3025,2,3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6083.38,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3365,NULL,42285,3025,2,3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4003.11,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3366,NULL,42285,3025,2,3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4172.34,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3367,NULL,42285,3025,2,3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4434.70,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3368,NULL,42285,3025,2,3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5851.86,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3369,NULL,42285,3025,2,3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6083.37,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3370,NULL,42285,3025,2,3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',23745.70,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3371,NULL,42285,3025,2,3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',17079.44,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3372,NULL,42285,3025,2,3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',17079.44,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3373,NULL,42285,3025,2,3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',17079.44,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3374,NULL,42285,3025,2,3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',17079.44,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3375,NULL,42285,3025,2,3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2053.13,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3376,NULL,42285,3025,2,3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3632.29,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3377,NULL,42285,3025,2,3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',360.58,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3378,NULL,42285,3025,2,3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',20271.12,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3379,NULL,42285,3025,2,3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2368.86,NULL,NULL,1,'2022-08-17 12:45:57','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3380,NULL,42285,3025,2,3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4429.96,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3381,NULL,42285,3025,2,3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',8859.92,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3382,NULL,42285,3025,2,3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',17079.44,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3383,NULL,42285,3025,2,3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3041.69,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3384,NULL,42285,3025,2,3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',15526.77,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17');
INSERT INTO `balance_libro` VALUES (3385,NULL,42285,3025,2,3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',15526.77,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3386,NULL,42285,3025,2,3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',15526.77,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3387,NULL,42285,3025,2,3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2594.02,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3388,NULL,42285,3025,2,3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',10345.76,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3389,NULL,42285,3025,2,3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5459.93,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3390,NULL,42285,3025,2,3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5095.54,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3391,NULL,42285,3025,2,3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3209.92,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3392,NULL,42285,3025,2,3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',7648.92,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3393,NULL,42285,3025,2,3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3759.39,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3394,NULL,42285,3025,2,3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2876.09,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3395,NULL,42285,3025,2,3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1386.60,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3396,NULL,42285,3025,2,3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3987.27,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3397,NULL,42285,3025,2,3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1369.60,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3398,NULL,42285,3025,2,3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4654.04,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3399,NULL,42285,3025,2,3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:17','2022-08-17 12:58:17'),(3400,NULL,42285,3025,2,3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9907.60,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3401,NULL,42285,3025,2,3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2767.94,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3402,NULL,42285,3025,2,3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5615.98,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3403,NULL,42285,3025,2,3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1568.00,NULL,NULL,1,'2022-08-17 12:45:58','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3404,NULL,42285,3025,2,3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1402.45,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3405,NULL,42285,3025,2,3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9748.84,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3406,NULL,42285,3025,2,3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3270.83,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18');
INSERT INTO `balance_libro` VALUES (3407,NULL,42285,3025,2,3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4157.52,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3408,NULL,42285,3025,2,3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',24153.17,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3409,NULL,42285,3025,2,3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2317.20,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3410,NULL,42285,3025,2,3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1568.32,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3411,NULL,42285,3025,2,3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13363.26,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3412,NULL,42285,3025,2,3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6860.42,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3413,NULL,42285,3025,2,3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1555.39,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3414,NULL,42285,3025,2,3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',41491.02,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3415,NULL,42285,3025,2,3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',15190.76,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3416,NULL,42285,3025,2,3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2950.23,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3417,NULL,42285,3025,2,3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1461.95,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3418,NULL,42285,3025,2,3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5660.88,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3419,NULL,42285,3025,2,3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3449.14,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3420,NULL,42285,3025,2,3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3069.41,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3421,NULL,42285,3025,2,3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1769.49,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3422,NULL,42285,3025,2,3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4927.36,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3423,NULL,42285,3025,2,3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',545.28,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3424,NULL,42285,3025,2,3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3449.14,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3425,NULL,42285,3025,2,3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',11489.47,NULL,NULL,1,'2022-08-17 12:45:59','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3426,NULL,42285,3025,2,3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3150.81,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3427,NULL,42285,3025,2,3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5095.54,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3428,NULL,42285,3025,2,3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4196.86,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18');
INSERT INTO `balance_libro` VALUES (3429,NULL,42285,3025,2,3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3538.36,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3430,NULL,42285,3025,2,3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5637.73,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3431,NULL,42285,3025,2,3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3432,NULL,42285,3025,2,3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2022.48,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3433,NULL,42285,3025,2,3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4796.92,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3434,NULL,42285,3025,2,3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',10273.25,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3435,NULL,42285,3025,2,3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3436,NULL,42285,3025,2,3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6881.73,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3437,NULL,42285,3025,2,3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3438,NULL,42285,3025,2,3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1427.48,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3439,NULL,42285,3025,2,3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5093.90,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3440,NULL,42285,3025,2,3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3441,NULL,42285,3025,2,3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2459.02,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3442,NULL,42285,3025,2,3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2849.30,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3443,NULL,42285,3025,2,3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3624.90,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3444,NULL,42285,3025,2,3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3078.30,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3445,NULL,42285,3025,2,3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2788.36,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3446,NULL,42285,3025,2,3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5094.79,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3447,NULL,42285,3025,2,3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:00','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3448,NULL,42285,3025,2,3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3449,NULL,42285,3025,2,3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',11582.00,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3450,NULL,42285,3025,2,3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4856.73,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18');
INSERT INTO `balance_libro` VALUES (3451,NULL,42285,3025,2,3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4239.23,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3452,NULL,42285,3025,2,3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3453,NULL,42285,3025,2,3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3454,NULL,42285,3025,2,3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1883.88,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3455,NULL,42285,3025,2,3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3844.01,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3456,NULL,42285,3025,2,3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3009.01,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3457,NULL,42285,3025,2,3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2435.71,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3458,NULL,42285,3025,2,3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2292.47,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3459,NULL,42285,3025,2,3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4119.92,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3460,NULL,42285,3025,2,3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4275.30,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3461,NULL,42285,3025,2,3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2070.61,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3462,NULL,42285,3025,2,3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2107.78,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:18','2022-08-17 12:58:18'),(3463,NULL,42285,3025,2,3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2522.29,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3464,NULL,42285,3025,2,3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5512.90,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3465,NULL,42285,3025,2,3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2018.92,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3466,NULL,42285,3025,2,3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2791.71,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3467,NULL,42285,3025,2,3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2362.52,NULL,NULL,1,'2022-08-17 12:46:01','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3468,NULL,42285,3025,2,3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',13257.96,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3469,NULL,42285,3025,2,3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1506.03,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3470,NULL,42285,3025,2,3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4815.65,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3471,NULL,42285,3025,2,3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',11907.63,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3472,NULL,42285,3025,2,3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19');
INSERT INTO `balance_libro` VALUES (3473,NULL,42285,3025,2,3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5779.90,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3474,NULL,42285,3025,2,3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2250.34,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3475,NULL,42285,3025,2,3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2533.36,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3476,NULL,42285,3025,2,3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1386.60,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3477,NULL,42285,3025,2,3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5049.33,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3478,NULL,42285,3025,2,3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',24982.98,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3479,NULL,42285,3025,2,3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1609.98,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3480,NULL,42285,3025,2,3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',11582.00,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3481,NULL,42285,3025,2,3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4275.30,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3482,NULL,42285,3025,2,3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1971.32,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3483,NULL,42285,3025,2,3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4987.57,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3484,NULL,42285,3025,2,3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1624.10,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3485,NULL,42285,3025,2,3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',16841.64,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3486,NULL,42285,3025,2,3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1265.75,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3487,NULL,42285,3025,2,3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1566.42,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3488,NULL,42285,3025,2,3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3348.30,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3489,NULL,42285,3025,2,3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4275.30,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3490,NULL,42285,3025,2,3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2135.82,NULL,NULL,1,'2022-08-17 12:46:02','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3491,NULL,42285,3025,2,3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5339.07,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3492,NULL,42285,3025,2,3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3493,NULL,42285,3025,2,3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3494,NULL,42285,3025,2,3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6143.34,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19');
INSERT INTO `balance_libro` VALUES (3495,NULL,42285,3025,2,3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2640.17,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3496,NULL,42285,3025,2,3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2265.86,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3497,NULL,42285,3025,2,3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4953.65,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3498,NULL,42285,3025,2,3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3967.17,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3499,NULL,42285,3025,2,3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',9723.73,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3500,NULL,42285,3025,2,3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1009.14,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3501,NULL,42285,3025,2,3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1389.12,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:19','2022-08-17 12:58:19'),(3502,NULL,42285,3025,2,3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2025.82,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3503,NULL,42285,3025,2,3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2107.78,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3504,NULL,42285,3025,2,3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2602.51,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3505,NULL,42285,3025,2,3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1435.46,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3506,NULL,42285,3025,2,3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2825.58,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3507,NULL,42285,3025,2,3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2753.76,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3508,NULL,42285,3025,2,3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4267.88,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3509,NULL,42285,3025,2,3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1617.73,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3510,NULL,42285,3025,2,3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3548.63,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3511,NULL,42285,3025,2,3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1197.52,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3512,NULL,42285,3025,2,3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',44868.64,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3513,NULL,42285,3025,2,3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',17167.80,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3514,NULL,42285,3025,2,3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4706.75,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3515,NULL,42285,3025,2,3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1173.37,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3516,NULL,42285,3025,2,3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1966.37,NULL,NULL,1,'2022-08-17 12:46:03','2022-08-17 12:58:20','2022-08-17 12:58:20');
INSERT INTO `balance_libro` VALUES (3517,NULL,42285,3025,2,3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5691.04,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3518,NULL,42285,3025,2,3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2628.70,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3519,NULL,42285,3025,2,3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2996.97,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3520,NULL,42285,3025,2,3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2389.86,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3521,NULL,42285,3025,2,3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3137.40,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3522,NULL,42285,3025,2,3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4233.71,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3523,NULL,42285,3025,2,3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2916.80,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3524,NULL,42285,3025,2,3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7508.06,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3525,NULL,42285,3025,2,3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3638.35,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3526,NULL,42285,3025,2,3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5984.00,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3527,NULL,42285,3025,2,3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3001.95,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3528,NULL,42285,3025,2,3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2988.49,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3529,NULL,42285,3025,2,3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2665.63,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3530,NULL,42285,3025,2,3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4759.38,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3531,NULL,42285,3025,2,3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4731.28,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3532,NULL,42285,3025,2,3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1521.29,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3533,NULL,42285,3025,2,3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',11582.00,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3534,NULL,42285,3025,2,3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3928.71,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3535,NULL,42285,3025,2,3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4170.28,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3536,NULL,42285,3025,2,3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5538.51,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3537,NULL,42285,3025,2,3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3416.21,NULL,NULL,1,'2022-08-17 12:46:04','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3538,NULL,42285,3025,2,3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3816.53,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:20','2022-08-17 12:58:20');
INSERT INTO `balance_libro` VALUES (3539,NULL,42285,3025,2,3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8437.73,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3540,NULL,42285,3025,2,3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',12308.20,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3541,NULL,42285,3025,2,3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8303.82,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3542,NULL,42285,3025,2,3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7643.75,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3543,NULL,42285,3025,2,3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2337.49,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:20','2022-08-17 12:58:20'),(3544,NULL,42285,3025,2,3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3775.62,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3545,NULL,42285,3025,2,3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2714.02,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3546,NULL,42285,3025,2,3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5240.21,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3547,NULL,42285,3025,2,3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5535.88,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3548,NULL,42285,3025,2,3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',9828.13,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3549,NULL,42285,3025,2,3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4063.48,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3550,NULL,42285,3025,2,3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8216.13,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3551,NULL,42285,3025,2,3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3181.59,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3552,NULL,42285,3025,2,3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3678.30,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3553,NULL,42285,3025,2,3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2759.93,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3554,NULL,42285,3025,2,3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',11399.73,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3555,NULL,42285,3025,2,3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2045.61,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3556,NULL,42285,3025,2,3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1568.32,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3557,NULL,42285,3025,2,3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3833.10,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3558,NULL,42285,3025,2,3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3408.81,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3559,NULL,42285,3025,2,3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2971.80,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3560,NULL,42285,3025,2,3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2110.82,NULL,NULL,1,'2022-08-17 12:46:05','2022-08-17 12:58:21','2022-08-17 12:58:21');
INSERT INTO `balance_libro` VALUES (3561,NULL,42285,3025,2,3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2635.82,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3562,NULL,42285,3025,2,3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5048.93,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3563,NULL,42285,3025,2,3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',11582.00,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3564,NULL,42285,3025,2,3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3334.46,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3565,NULL,42285,3025,2,3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3175.33,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3566,NULL,42285,3025,2,3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8551.61,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3567,NULL,42285,3025,2,3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1129.20,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3568,NULL,42285,3025,2,3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2845.63,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3569,NULL,42285,3025,2,3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2234.02,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3570,NULL,42285,3025,2,3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3571,NULL,42285,3025,2,3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5131.58,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3572,NULL,42285,3025,2,3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',10773.44,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3573,NULL,42285,3025,2,3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4720.90,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3574,NULL,42285,3025,2,3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4892.74,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3575,NULL,42285,3025,2,3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3576,NULL,42285,3025,2,3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1887.59,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3577,NULL,42285,3025,2,3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2185.95,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3578,NULL,42285,3025,2,3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3910.03,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3579,NULL,42285,3025,2,3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1427.48,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3580,NULL,42285,3025,2,3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5512.90,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3581,NULL,42285,3025,2,3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5055.55,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3582,NULL,42285,3025,2,3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8551.61,NULL,NULL,1,'2022-08-17 12:46:06','2022-08-17 12:58:21','2022-08-17 12:58:21');
INSERT INTO `balance_libro` VALUES (3583,NULL,42285,3025,2,3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1767.48,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3584,NULL,42285,3025,2,3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1046.30,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3585,NULL,42285,3025,2,3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2116.46,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3586,NULL,42285,3025,2,3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2709.51,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3587,NULL,42285,3025,2,3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1809.60,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3588,NULL,42285,3025,2,3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3589,NULL,42285,3025,2,3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1611.92,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3590,NULL,42285,3025,2,3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3014.02,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3591,NULL,42285,3025,2,3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1190.78,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3592,NULL,42285,3025,2,3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3603.30,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3593,NULL,42285,3025,2,3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',9306.20,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3594,NULL,42285,3025,2,3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5512.90,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3595,NULL,42285,3025,2,3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3077.85,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:21','2022-08-17 12:58:21'),(3596,NULL,42285,3025,2,3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3446.80,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3597,NULL,42285,3025,2,3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2763.64,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3598,NULL,42285,3025,2,3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6365.86,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3599,NULL,42285,3025,2,3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1940.35,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3600,NULL,42285,3025,2,3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7502.93,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3601,NULL,42285,3025,2,3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2404.02,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3602,NULL,42285,3025,2,3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2615.80,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3603,NULL,42285,3025,2,3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7180.79,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3604,NULL,42285,3025,2,3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4750.60,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22');
INSERT INTO `balance_libro` VALUES (3605,NULL,42285,3025,2,3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3606,NULL,42285,3025,2,3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3104.01,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3607,NULL,42285,3025,2,3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',14377.35,NULL,NULL,1,'2022-08-17 12:46:07','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3608,NULL,42285,3025,2,3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4975.48,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3609,NULL,42285,3025,2,3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5611.67,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3610,NULL,42285,3025,2,3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2291.52,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3611,NULL,42285,3025,2,3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4064.10,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3612,NULL,42285,3025,2,3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3613,NULL,42285,3025,2,3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1985.82,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3614,NULL,42285,3025,2,3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4899.22,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3615,NULL,42285,3025,2,3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',22874.65,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3616,NULL,42285,3025,2,3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7641.66,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3617,NULL,42285,3025,2,3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4127.44,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3618,NULL,42285,3025,2,3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2246.81,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3619,NULL,42285,3025,2,3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2339.02,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3620,NULL,42285,3025,2,3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',11582.00,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3621,NULL,42285,3025,2,3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2766.43,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3622,NULL,42285,3025,2,3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1629.60,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3623,NULL,42285,3025,2,3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2780.93,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3624,NULL,42285,3025,2,3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5739.84,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3625,NULL,42285,3025,2,3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5963.67,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3626,NULL,42285,3025,2,3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8761.92,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22');
INSERT INTO `balance_libro` VALUES (3627,NULL,42285,3025,2,3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2222.65,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3628,NULL,42285,3025,2,3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',44868.64,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3629,NULL,42285,3025,2,3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2249.27,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3630,NULL,42285,3025,2,3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2594.02,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3631,NULL,42285,3025,2,3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2287.78,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3632,NULL,42285,3025,2,3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2368.31,NULL,NULL,1,'2022-08-17 12:46:08','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3633,NULL,42285,3025,2,3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2220.52,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3634,NULL,42285,3025,2,3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',9530.08,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3635,NULL,42285,3025,2,3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7601.81,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3636,NULL,42285,3025,2,3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4379.32,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3637,NULL,42285,3025,2,3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2912.21,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3638,NULL,42285,3025,2,3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1399.40,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3639,NULL,42285,3025,2,3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1156.90,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3640,NULL,42285,3025,2,3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4363.04,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3641,NULL,42285,3025,2,3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1869.35,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3642,NULL,42285,3025,2,3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1110.24,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3643,NULL,42285,3025,2,3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',84163.88,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3644,NULL,42285,3025,2,3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3970.18,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3645,NULL,42285,3025,2,3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3187.01,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3646,NULL,42285,3025,2,3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2594.02,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3647,NULL,42285,3025,2,3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2269.63,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3648,NULL,42285,3025,2,3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4887.90,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22');
INSERT INTO `balance_libro` VALUES (3649,NULL,42285,3025,2,3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2759.30,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3650,NULL,42285,3025,2,3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2077.79,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3651,NULL,42285,3025,2,3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2185.04,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3652,NULL,42285,3025,2,3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',22978.94,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:22','2022-08-17 12:58:22'),(3653,NULL,42285,3025,2,3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',9284.22,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3654,NULL,42285,3025,2,3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4530.49,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3655,NULL,42285,3025,2,3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2291.52,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3656,NULL,42285,3025,2,3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5478.63,NULL,NULL,1,'2022-08-17 12:46:09','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3657,NULL,42285,3025,2,3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2709.51,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3658,NULL,42285,3025,2,3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4654.04,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3659,NULL,42285,3025,2,3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2767.94,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3660,NULL,42285,3025,2,3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3048.69,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3661,NULL,42285,3025,2,3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4887.90,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3662,NULL,42285,3025,2,3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1562.28,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3663,NULL,42285,3025,2,3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5095.54,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3664,NULL,42285,3025,2,3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2365.64,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3665,NULL,42285,3025,2,3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5431.00,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3666,NULL,42285,3025,2,3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1906.44,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3667,NULL,42285,3025,2,3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6044.50,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3668,NULL,42285,3025,2,3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4005.75,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3669,NULL,42285,3025,2,3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3700.68,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3670,NULL,42285,3025,2,3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6691.70,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23');
INSERT INTO `balance_libro` VALUES (3671,NULL,42285,3025,2,3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2680.35,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3672,NULL,42285,3025,2,3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',32050.20,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3673,NULL,42285,3025,2,3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8783.00,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3674,NULL,42285,3025,2,3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5635.55,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3675,NULL,42285,3025,2,3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',19671.05,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3676,NULL,42285,3025,2,3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1262.78,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3677,NULL,42285,3025,2,3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5756.21,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3678,NULL,42285,3025,2,3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2909.80,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3679,NULL,42285,3025,2,3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4685.85,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3680,NULL,42285,3025,2,3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4537.70,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3681,NULL,42285,3025,2,3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1454.92,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3682,NULL,42285,3025,2,3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3312.63,NULL,NULL,1,'2022-08-17 12:46:10','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3683,NULL,42285,3025,2,3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3526.76,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3684,NULL,42285,3025,2,3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3654.10,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3685,NULL,42285,3025,2,3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1759.03,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3686,NULL,42285,3025,2,3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',54208.34,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3687,NULL,42285,3025,2,3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1626.60,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3688,NULL,42285,3025,2,3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1433.37,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3689,NULL,42285,3025,2,3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2930.51,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3690,NULL,42285,3025,2,3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1457.17,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3691,NULL,42285,3025,2,3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3624.21,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3692,NULL,42285,3025,2,3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5133.63,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23');
INSERT INTO `balance_libro` VALUES (3693,NULL,42285,3025,2,3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4537.56,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3694,NULL,42285,3025,2,3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2024.54,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3695,NULL,42285,3025,2,3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3077.01,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3696,NULL,42285,3025,2,3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7643.75,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3697,NULL,42285,3025,2,3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2759.21,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3698,NULL,42285,3025,2,3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4065.71,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3699,NULL,42285,3025,2,3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2963.70,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3700,NULL,42285,3025,2,3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',73185.98,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3701,NULL,42285,3025,2,3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2261.45,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3702,NULL,42285,3025,2,3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2709.51,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3703,NULL,42285,3025,2,3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4359.62,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3704,NULL,42285,3025,2,3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1712.55,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3705,NULL,42285,3025,2,3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5960.72,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3706,NULL,42285,3025,2,3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6981.06,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3707,NULL,42285,3025,2,3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2287.78,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3708,NULL,42285,3025,2,3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1038.99,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3709,NULL,42285,3025,2,3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2434.30,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3710,NULL,42285,3025,2,3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3449.46,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3711,NULL,42285,3025,2,3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',10779.92,NULL,NULL,1,'2022-08-17 12:46:11','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3712,NULL,42285,3025,2,3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3763.71,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3713,NULL,42285,3025,2,3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8476.93,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:23','2022-08-17 12:58:23'),(3714,NULL,42285,3025,2,3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5095.54,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24');
INSERT INTO `balance_libro` VALUES (3715,NULL,42285,3025,2,3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2758.07,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3716,NULL,42285,3025,2,3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4685.85,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3717,NULL,42285,3025,2,3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4535.48,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3718,NULL,42285,3025,2,3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5181.43,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3719,NULL,42285,3025,2,3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4679.94,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3720,NULL,42285,3025,2,3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3664.82,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3721,NULL,42285,3025,2,3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3911.13,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3722,NULL,42285,3025,2,3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3594.92,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3723,NULL,42285,3025,2,3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1570.10,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3724,NULL,42285,3025,2,3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6646.64,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3725,NULL,42285,3025,2,3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1822.10,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3726,NULL,42285,3025,2,3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2454.35,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3727,NULL,42285,3025,2,3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3223.77,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3728,NULL,42285,3025,2,3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5963.67,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3729,NULL,42285,3025,2,3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5626.21,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3730,NULL,42285,3025,2,3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3684.78,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3731,NULL,42285,3025,2,3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1982.64,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3732,NULL,42285,3025,2,3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2732.35,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3733,NULL,42285,3025,2,3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2449.25,NULL,NULL,1,'2022-08-17 12:46:12','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3734,NULL,42285,3025,2,3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2933.04,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3735,NULL,42285,3025,2,3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6027.45,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3736,NULL,42285,3025,2,3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7084.90,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24');
INSERT INTO `balance_libro` VALUES (3737,NULL,42285,3025,2,3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6736.58,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3738,NULL,42285,3025,2,3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2280.50,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3739,NULL,42285,3025,2,3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',13678.77,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3740,NULL,42285,3025,2,3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1645.80,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3741,NULL,42285,3025,2,3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1142.72,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3742,NULL,42285,3025,2,3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6130.36,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3743,NULL,42285,3025,2,3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4502.81,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3744,NULL,42285,3025,2,3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1562.98,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3745,NULL,42285,3025,2,3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4597.70,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3746,NULL,42285,3025,2,3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6623.77,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3747,NULL,42285,3025,2,3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2990.36,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3748,NULL,42285,3025,2,3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7503.51,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3749,NULL,42285,3025,2,3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4830.77,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3750,NULL,42285,3025,2,3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5263.17,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3751,NULL,42285,3025,2,3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5779.20,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3752,NULL,42285,3025,2,3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1817.02,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3753,NULL,42285,3025,2,3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3632.09,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3754,NULL,42285,3025,2,3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1941.15,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3755,NULL,42285,3025,2,3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3756,NULL,42285,3025,2,3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3098.98,NULL,NULL,1,'2022-08-17 12:46:13','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3757,NULL,42285,3025,2,3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3758,NULL,42285,3025,2,3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6397.98,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24');
INSERT INTO `balance_libro` VALUES (3759,NULL,42285,3025,2,3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2789.48,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3760,NULL,42285,3025,2,3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1748.09,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3761,NULL,42285,3025,2,3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',12595.52,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3762,NULL,42285,3025,2,3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9283.87,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3763,NULL,42285,3025,2,3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5051.34,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3764,NULL,42285,3025,2,3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3727.95,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3765,NULL,42285,3025,2,3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3766,NULL,42285,3025,2,3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4246.65,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3767,NULL,42285,3025,2,3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7227.50,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3768,NULL,42285,3025,2,3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4150.20,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3769,NULL,42285,3025,2,3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1713.42,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3770,NULL,42285,3025,2,3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2183.56,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3771,NULL,42285,3025,2,3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2014.58,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3772,NULL,42285,3025,2,3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3003.98,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3773,NULL,42285,3025,2,3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',12563.06,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3774,NULL,42285,3025,2,3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1804.55,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3775,NULL,42285,3025,2,3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8703.07,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3776,NULL,42285,3025,2,3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',23582.11,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3777,NULL,42285,3025,2,3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5103.61,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3778,NULL,42285,3025,2,3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2212.97,NULL,NULL,1,'2022-08-17 12:46:14','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3779,NULL,42285,3025,2,3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2303.97,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3780,NULL,42285,3025,2,3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3471.39,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:24','2022-08-17 12:58:24');
INSERT INTO `balance_libro` VALUES (3781,NULL,42285,3025,2,3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9612.24,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3782,NULL,42285,3025,2,3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1447.81,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3783,NULL,42285,3025,2,3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7133.17,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:24','2022-08-17 12:58:24'),(3784,NULL,42285,3025,2,3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4431.94,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3785,NULL,42285,3025,2,3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2400.23,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3786,NULL,42285,3025,2,3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',23075.40,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3787,NULL,42285,3025,2,3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2848.98,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3788,NULL,42285,3025,2,3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7460.00,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3789,NULL,42285,3025,2,3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4183.33,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3790,NULL,42285,3025,2,3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1979.56,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3791,NULL,42285,3025,2,3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1607.22,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3792,NULL,42285,3025,2,3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7970.23,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3793,NULL,42285,3025,2,3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4597.70,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3794,NULL,42285,3025,2,3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6298.95,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3795,NULL,42285,3025,2,3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',34379.73,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3796,NULL,42285,3025,2,3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2848.98,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3797,NULL,42285,3025,2,3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4885.27,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3798,NULL,42285,3025,2,3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1071.83,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3799,NULL,42285,3025,2,3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1376.47,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3800,NULL,42285,3025,2,3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2077.23,NULL,NULL,1,'2022-08-17 12:46:15','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3801,NULL,42285,3025,2,3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3802,NULL,42285,3025,2,3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8504.40,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25');
INSERT INTO `balance_libro` VALUES (3803,NULL,42285,3025,2,3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4863.26,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3804,NULL,42285,3025,2,3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3177.01,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3805,NULL,42285,3025,2,3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',15870.00,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3806,NULL,42285,3025,2,3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2286.92,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3807,NULL,42285,3025,2,3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3501.26,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3808,NULL,42285,3025,2,3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2563.89,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3809,NULL,42285,3025,2,3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3629.20,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3810,NULL,42285,3025,2,3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3002.48,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3811,NULL,42285,3025,2,3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3812,NULL,42285,3025,2,3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2848.98,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3813,NULL,42285,3025,2,3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3003.98,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3814,NULL,42285,3025,2,3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1144.29,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3815,NULL,42285,3025,2,3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2287.97,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3816,NULL,42285,3025,2,3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2646.48,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3817,NULL,42285,3025,2,3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4379.32,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3818,NULL,42285,3025,2,3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',14393.94,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3819,NULL,42285,3025,2,3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1203.92,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3820,NULL,42285,3025,2,3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3092.17,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3821,NULL,42285,3025,2,3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1995.27,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3822,NULL,42285,3025,2,3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3823,NULL,42285,3025,2,3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4830.77,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3824,NULL,42285,3025,2,3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2848.98,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25');
INSERT INTO `balance_libro` VALUES (3825,NULL,42285,3025,2,3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7635.45,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3826,NULL,42285,3025,2,3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3037.00,NULL,NULL,1,'2022-08-17 12:46:16','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3827,NULL,42285,3025,2,3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5396.37,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3828,NULL,42285,3025,2,3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3829,NULL,42285,3025,2,3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3830,NULL,42285,3025,2,3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4750.33,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3831,NULL,42285,3025,2,3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3832,NULL,42285,3025,2,3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2987.43,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3833,NULL,42285,3025,2,3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4663.01,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3834,NULL,42285,3025,2,3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1760.93,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3835,NULL,42285,3025,2,3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1947.76,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3836,NULL,42285,3025,2,3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5568.94,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3837,NULL,42285,3025,2,3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5205.82,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3838,NULL,42285,3025,2,3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3003.98,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3839,NULL,42285,3025,2,3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7757.34,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3840,NULL,42285,3025,2,3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6066.51,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3841,NULL,42285,3025,2,3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5024.44,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3842,NULL,42285,3025,2,3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',77037.87,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3843,NULL,42285,3025,2,3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3844,NULL,42285,3025,2,3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1952.48,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3845,NULL,42285,3025,2,3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4797.98,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3846,NULL,42285,3025,2,3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4808.65,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25');
INSERT INTO `balance_libro` VALUES (3847,NULL,42285,3025,2,3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1595.62,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3848,NULL,42285,3025,2,3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6081.83,NULL,NULL,1,'2022-08-17 12:46:17','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3849,NULL,42285,3025,2,3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2238.04,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3850,NULL,42285,3025,2,3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1433.37,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3851,NULL,42285,3025,2,3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4923.48,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3852,NULL,42285,3025,2,3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3914.10,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3853,NULL,42285,3025,2,3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2030.29,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:25','2022-08-17 12:58:25'),(3854,NULL,42285,3025,2,3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2589.47,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3855,NULL,42285,3025,2,3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2767.94,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3856,NULL,42285,3025,2,3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2767.94,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3857,NULL,42285,3025,2,3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2767.94,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3858,NULL,42285,3025,2,3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8761.92,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3859,NULL,42285,3025,2,3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3228.30,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3860,NULL,42285,3025,2,3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5048.55,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3861,NULL,42285,3025,2,3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2071.24,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3862,NULL,42285,3025,2,3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1694.98,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3863,NULL,42285,3025,2,3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2767.94,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3864,NULL,42285,3025,2,3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4599.67,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3865,NULL,42285,3025,2,3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9283.87,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3866,NULL,42285,3025,2,3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8967.46,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3867,NULL,42285,3025,2,3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',13527.80,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3868,NULL,42285,3025,2,3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1393.04,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26');
INSERT INTO `balance_libro` VALUES (3869,NULL,42285,3025,2,3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2539.34,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3870,NULL,42285,3025,2,3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',18878.10,NULL,NULL,1,'2022-08-17 12:46:18','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3871,NULL,42285,3025,2,3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',11627.30,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3872,NULL,42285,3025,2,3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4278.92,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3873,NULL,42285,3025,2,3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1958.37,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3874,NULL,42285,3025,2,3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',10813.95,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3875,NULL,42285,3025,2,3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1646.89,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3876,NULL,42285,3025,2,3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5963.67,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3877,NULL,42285,3025,2,3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5940.00,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3878,NULL,42285,3025,2,3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5158.16,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3879,NULL,42285,3025,2,3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3318.09,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3880,NULL,42285,3025,2,3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',27352.05,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3881,NULL,42285,3025,2,3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5637.73,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3882,NULL,42285,3025,2,3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1929.39,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3883,NULL,42285,3025,2,3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1935.99,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3884,NULL,42285,3025,2,3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5256.94,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3885,NULL,42285,3025,2,3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1510.44,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3886,NULL,42285,3025,2,3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2395.24,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3887,NULL,42285,3025,2,3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4529.12,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3888,NULL,42285,3025,2,3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7763.53,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3889,NULL,42285,3025,2,3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4803.88,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3890,NULL,42285,3025,2,3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1278.52,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26');
INSERT INTO `balance_libro` VALUES (3891,NULL,42285,3025,2,3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3691.88,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3892,NULL,42285,3025,2,3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3276.47,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3893,NULL,42285,3025,2,3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2594.02,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3894,NULL,42285,3025,2,3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2767.94,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3895,NULL,42285,3025,2,3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5095.54,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3896,NULL,42285,3025,2,3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8006.00,NULL,NULL,1,'2022-08-17 12:46:19','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3897,NULL,42285,3025,2,3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5095.54,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3898,NULL,42285,3025,2,3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1845.77,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3899,NULL,42285,3025,2,3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4097.33,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3900,NULL,42285,3025,2,3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2327.02,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3901,NULL,42285,3025,2,3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1710.61,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3902,NULL,42285,3025,2,3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8303.82,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3903,NULL,42285,3025,2,3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2997.30,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3904,NULL,42285,3025,2,3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2018.92,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3905,NULL,42285,3025,2,3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9828.13,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3906,NULL,42285,3025,2,3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1199.57,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3907,NULL,42285,3025,2,3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1687.48,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3908,NULL,42285,3025,2,3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2767.94,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3909,NULL,42285,3025,2,3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',22874.65,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3910,NULL,42285,3025,2,3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6278.91,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3911,NULL,42285,3025,2,3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1629.00,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26'),(3912,NULL,42285,3025,2,3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2594.02,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:26','2022-08-17 12:58:26');
INSERT INTO `balance_libro` VALUES (3913,NULL,42285,3025,2,3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2730.46,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3914,NULL,42285,3025,2,3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2522.29,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3915,NULL,42285,3025,2,3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1985.82,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3916,NULL,42285,3025,2,3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3449.92,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3917,NULL,42285,3025,2,3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3098.48,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3918,NULL,42285,3025,2,3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4173.83,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3919,NULL,42285,3025,2,3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3037.01,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3920,NULL,42285,3025,2,3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7905.72,NULL,NULL,1,'2022-08-17 12:46:20','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3921,NULL,42285,3025,2,3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5666.08,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3922,NULL,42285,3025,2,3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3416.21,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3923,NULL,42285,3025,2,3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2767.94,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3924,NULL,42285,3025,2,3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1500.45,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3925,NULL,42285,3025,2,3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6119.29,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3926,NULL,42285,3025,2,3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1676.34,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3927,NULL,42285,3025,2,3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1891.62,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3928,NULL,42285,3025,2,3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4201.25,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3929,NULL,42285,3025,2,3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3569.96,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3930,NULL,42285,3025,2,3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',11486.01,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3931,NULL,42285,3025,2,3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3187.01,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3932,NULL,42285,3025,2,3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3141.33,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3933,NULL,42285,3025,2,3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1519.49,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3934,NULL,42285,3025,2,3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',22874.65,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27');
INSERT INTO `balance_libro` VALUES (3935,NULL,42285,3025,2,3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2780.63,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3936,NULL,42285,3025,2,3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2767.94,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3937,NULL,42285,3025,2,3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1920.36,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3938,NULL,42285,3025,2,3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6013.00,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3939,NULL,42285,3025,2,3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3940,NULL,42285,3025,2,3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7863.22,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3941,NULL,42285,3025,2,3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5779.20,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3942,NULL,42285,3025,2,3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5779.20,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3943,NULL,42285,3025,2,3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2270.09,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3944,NULL,42285,3025,2,3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2836.08,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3945,NULL,42285,3025,2,3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2901.03,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3946,NULL,42285,3025,2,3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',50496.82,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3947,NULL,42285,3025,2,3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2889.60,NULL,NULL,1,'2022-08-17 12:46:21','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3948,NULL,42285,3025,2,3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3031.08,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3949,NULL,42285,3025,2,3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8668.80,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3950,NULL,42285,3025,2,3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3558.23,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3951,NULL,42285,3025,2,3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2454.35,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3952,NULL,42285,3025,2,3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3617.55,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3953,NULL,42285,3025,2,3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3757.29,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3954,NULL,42285,3025,2,3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',18486.05,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3955,NULL,42285,3025,2,3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2279.56,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3956,NULL,42285,3025,2,3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1786.06,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27');
INSERT INTO `balance_libro` VALUES (3957,NULL,42285,3025,2,3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5002.25,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3958,NULL,42285,3025,2,3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1202.00,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3959,NULL,42285,3025,2,3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',11489.47,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3960,NULL,42285,3025,2,3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5100.29,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3961,NULL,42285,3025,2,3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2631.39,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3962,NULL,42285,3025,2,3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3041.69,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3963,NULL,42285,3025,2,3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',10340.22,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3964,NULL,42285,3025,2,3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7034.43,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3965,NULL,42285,3025,2,3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1897.93,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:27','2022-08-17 12:58:27'),(3966,NULL,42285,3025,2,3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3902.95,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3967,NULL,42285,3025,2,3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',13318.00,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3968,NULL,42285,3025,2,3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3041.69,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3969,NULL,42285,3025,2,3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1104.12,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3970,NULL,42285,3025,2,3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2556.58,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3971,NULL,42285,3025,2,3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9735.47,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3972,NULL,42285,3025,2,3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2860.48,NULL,NULL,1,'2022-08-17 12:46:22','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3973,NULL,42285,3025,2,3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3041.69,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3974,NULL,42285,3025,2,3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2781.48,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3975,NULL,42285,3025,2,3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9283.87,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3976,NULL,42285,3025,2,3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3041.69,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3977,NULL,42285,3025,2,3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4849.07,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3978,NULL,42285,3025,2,3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6870.69,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28');
INSERT INTO `balance_libro` VALUES (3979,NULL,42285,3025,2,3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3148.98,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3980,NULL,42285,3025,2,3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2778.15,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3981,NULL,42285,3025,2,3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2619.49,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3982,NULL,42285,3025,2,3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1218.26,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3983,NULL,42285,3025,2,3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3041.69,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3984,NULL,42285,3025,2,3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1724.47,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3985,NULL,42285,3025,2,3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',12740.20,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3986,NULL,42285,3025,2,3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1827.48,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3987,NULL,42285,3025,2,3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5095.54,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3988,NULL,42285,3025,2,3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1519.79,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3989,NULL,42285,3025,2,3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4245.75,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3990,NULL,42285,3025,2,3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3233.98,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3991,NULL,42285,3025,2,3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2485.63,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3992,NULL,42285,3025,2,3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5372.25,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3993,NULL,42285,3025,2,3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2280.50,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3994,NULL,42285,3025,2,3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1815.59,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3995,NULL,42285,3025,2,3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2482.77,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3996,NULL,42285,3025,2,3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6495.43,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3997,NULL,42285,3025,2,3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5601.32,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3998,NULL,42285,3025,2,3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2200.90,NULL,NULL,1,'2022-08-17 12:46:23','2022-08-17 12:58:28','2022-08-17 12:58:28'),(3999,NULL,42285,3025,2,3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',9024.12,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4000,NULL,42285,3025,2,4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',697.59,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28');
INSERT INTO `balance_libro` VALUES (4001,NULL,42285,3025,2,4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',326.61,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4002,NULL,42285,3025,2,4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4811.43,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4003,NULL,42285,3025,2,4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',10071.89,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4004,NULL,42285,3025,2,4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5131.58,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4005,NULL,42285,3025,2,4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2889.60,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4006,NULL,42285,3025,2,4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2422.01,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4007,NULL,42285,3025,2,4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1767.19,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4008,NULL,42285,3025,2,4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',10231.60,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4009,NULL,42285,3025,2,4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1309.98,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4010,NULL,42285,3025,2,4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',8368.55,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4011,NULL,42285,3025,2,4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',57061.41,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4012,NULL,42285,3025,2,4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4402.74,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4013,NULL,42285,3025,2,4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',23582.11,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4014,NULL,42285,3025,2,4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4158.53,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4015,NULL,42285,3025,2,4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3132.69,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4016,NULL,42285,3025,2,4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7249.20,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4017,NULL,42285,3025,2,4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3003.98,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4018,NULL,42285,3025,2,4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1668.60,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4019,NULL,42285,3025,2,4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2889.60,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4020,NULL,42285,3025,2,4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4830.77,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4021,NULL,42285,3025,2,4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3621.59,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4022,NULL,42285,3025,2,4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3192.95,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28');
INSERT INTO `balance_libro` VALUES (4023,NULL,42285,3025,2,4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1444.98,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4024,NULL,42285,3025,2,4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4797.98,NULL,NULL,1,'2022-08-17 12:46:24','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4025,NULL,42285,3025,2,4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1962.94,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4026,NULL,42285,3025,2,4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2889.60,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4027,NULL,42285,3025,2,4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2889.60,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:28','2022-08-17 12:58:28'),(4028,NULL,42285,3025,2,4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2889.60,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4029,NULL,42285,3025,2,4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3353.98,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4030,NULL,42285,3025,2,4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3511.62,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4031,NULL,42285,3025,2,4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6843.29,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4032,NULL,42285,3025,2,4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2889.60,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4033,NULL,42285,3025,2,4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2257.06,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4034,NULL,42285,3025,2,4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3041.69,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4035,NULL,42285,3025,2,4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1747.71,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4036,NULL,42285,3025,2,4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',8470.24,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4037,NULL,42285,3025,2,4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',9661.54,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4038,NULL,42285,3025,2,4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4953.65,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4039,NULL,42285,3025,2,4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4797.98,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4040,NULL,42285,3025,2,4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2771.70,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4041,NULL,42285,3025,2,4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2270.49,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4042,NULL,42285,3025,2,4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3831.33,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4043,NULL,42285,3025,2,4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2844.70,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4044,NULL,42285,3025,2,4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2432.49,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29');
INSERT INTO `balance_libro` VALUES (4045,NULL,42285,3025,2,4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2124.00,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4046,NULL,42285,3025,2,4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',20536.25,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4047,NULL,42285,3025,2,4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4652.86,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4048,NULL,42285,3025,2,4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1647.00,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4049,NULL,42285,3025,2,4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4072.07,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4050,NULL,42285,3025,2,4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3074.43,NULL,NULL,1,'2022-08-17 12:46:25','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4051,NULL,42285,3025,2,4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1875.47,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4052,NULL,42285,3025,2,4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1548.52,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4053,NULL,42285,3025,2,4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4415.53,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4054,NULL,42285,3025,2,4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2528.02,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4055,NULL,42285,3025,2,4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6076.71,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4056,NULL,42285,3025,2,4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2104.00,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4057,NULL,42285,3025,2,4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1490.09,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4058,NULL,42285,3025,2,4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2073.77,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4059,NULL,42285,3025,2,4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2511.51,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4060,NULL,42285,3025,2,4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4124.09,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4061,NULL,42285,3025,2,4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3098.98,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4062,NULL,42285,3025,2,4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1398.03,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4063,NULL,42285,3025,2,4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4408.07,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4064,NULL,42285,3025,2,4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7189.04,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4065,NULL,42285,3025,2,4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1399.98,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4066,NULL,42285,3025,2,4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2820.63,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29');
INSERT INTO `balance_libro` VALUES (4067,NULL,42285,3025,2,4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1353.69,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4068,NULL,42285,3025,2,4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4679.82,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4069,NULL,42285,3025,2,4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',13760.58,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4070,NULL,42285,3025,2,4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7078.50,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4071,NULL,42285,3025,2,4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2781.48,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4072,NULL,42285,3025,2,4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2798.95,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4073,NULL,42285,3025,2,4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2682.99,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4074,NULL,42285,3025,2,4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3108.99,NULL,NULL,1,'2022-08-17 12:46:26','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4075,NULL,42285,3025,2,4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1859.36,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4076,NULL,42285,3025,2,4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4123.50,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4077,NULL,42285,3025,2,4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1785.47,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4078,NULL,42285,3025,2,4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6016.50,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4079,NULL,42285,3025,2,4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3041.69,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4080,NULL,42285,3025,2,4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4697.49,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4081,NULL,42285,3025,2,4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',13970.00,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4082,NULL,42285,3025,2,4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2149.00,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4083,NULL,42285,3025,2,4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2674.52,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4084,NULL,42285,3025,2,4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2237.77,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4085,NULL,42285,3025,2,4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2781.48,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4086,NULL,42285,3025,2,4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3378.06,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4087,NULL,42285,3025,2,4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3041.69,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4088,NULL,42285,3025,2,4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',50496.82,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29');
INSERT INTO `balance_libro` VALUES (4089,NULL,42285,3025,2,4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1998.49,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4090,NULL,42285,3025,2,4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3472.95,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4091,NULL,42285,3025,2,4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3352.95,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4092,NULL,42285,3025,2,4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1247.76,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4093,NULL,42285,3025,2,4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1621.50,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4094,NULL,42285,3025,2,4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2270.49,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4095,NULL,42285,3025,2,4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4597.70,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4096,NULL,42285,3025,2,4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1594.28,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:29','2022-08-17 12:58:29'),(4097,NULL,42285,3025,2,4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7366.24,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4098,NULL,42285,3025,2,4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1788.47,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4099,NULL,42285,3025,2,4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1790.62,NULL,NULL,1,'2022-08-17 12:46:27','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4100,NULL,42285,3025,2,4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2767.99,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4101,NULL,42285,3025,2,4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',8470.24,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4102,NULL,42285,3025,2,4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4572.40,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4103,NULL,42285,3025,2,4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2887.99,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4104,NULL,42285,3025,2,4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5649.72,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4105,NULL,42285,3025,2,4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1974.27,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4106,NULL,42285,3025,2,4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3041.69,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4107,NULL,42285,3025,2,4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5489.51,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4108,NULL,42285,3025,2,4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2302.36,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4109,NULL,42285,3025,2,4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1680.59,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4110,NULL,42285,3025,2,4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1621.87,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30');
INSERT INTO `balance_libro` VALUES (4111,NULL,42285,3025,2,4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3055.69,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4112,NULL,42285,3025,2,4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1680.47,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4113,NULL,42285,3025,2,4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5433.55,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4114,NULL,42285,3025,2,4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2841.22,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4115,NULL,42285,3025,2,4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6548.05,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4116,NULL,42285,3025,2,4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',9501.79,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4117,NULL,42285,3025,2,4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1023.53,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4118,NULL,42285,3025,2,4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1435.82,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4119,NULL,42285,3025,2,4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1444.98,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4120,NULL,42285,3025,2,4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2407.74,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4121,NULL,42285,3025,2,4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',16070.96,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4122,NULL,42285,3025,2,4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4307.70,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4123,NULL,42285,3025,2,4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',8239.81,NULL,NULL,1,'2022-08-17 12:46:28','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4124,NULL,42285,3025,2,4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4270.54,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4125,NULL,42285,3025,2,4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4505.80,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4126,NULL,42285,3025,2,4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3593.34,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4127,NULL,42285,3025,2,4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1585.31,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4128,NULL,42285,3025,2,4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5182.56,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4129,NULL,42285,3025,2,4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5095.54,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4130,NULL,42285,3025,2,4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2858.90,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4131,NULL,42285,3025,2,4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',13173.91,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4132,NULL,42285,3025,2,4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5188.46,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30');
INSERT INTO `balance_libro` VALUES (4133,NULL,42285,3025,2,4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2027.30,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4134,NULL,42285,3025,2,4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2467.77,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4135,NULL,42285,3025,2,4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1419.98,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4136,NULL,42285,3025,2,4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',88593.56,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4137,NULL,42285,3025,2,4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3859.11,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4138,NULL,42285,3025,2,4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',22978.94,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4139,NULL,42285,3025,2,4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',8590.89,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4140,NULL,42285,3025,2,4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3627.46,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4141,NULL,42285,3025,2,4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',15677.50,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4142,NULL,42285,3025,2,4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4586.86,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4143,NULL,42285,3025,2,4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3041.69,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4144,NULL,42285,3025,2,4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',12377.73,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4145,NULL,42285,3025,2,4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5042.45,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4146,NULL,42285,3025,2,4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6991.90,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4147,NULL,42285,3025,2,4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4255.79,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4148,NULL,42285,3025,2,4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3680.05,NULL,NULL,1,'2022-08-17 12:46:29','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4149,NULL,42285,3025,2,4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',819.36,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4150,NULL,42285,3025,2,4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',77013.95,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4151,NULL,42285,3025,2,4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',24612.51,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4152,NULL,42285,3025,2,4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5333.62,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4153,NULL,42285,3025,2,4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',19944.56,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4154,NULL,42285,3025,2,4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',6043.86,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30');
INSERT INTO `balance_libro` VALUES (4155,NULL,42285,3025,2,4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',10966.50,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4156,NULL,42285,3025,2,4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',9219.20,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4157,NULL,42285,3025,2,4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',9772.20,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4158,NULL,42285,3025,2,4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',2666.56,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:30','2022-08-17 12:58:30'),(4159,NULL,42285,3025,2,4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',8163.50,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4160,NULL,42285,3025,2,4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',7268.32,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4161,NULL,42285,3025,2,4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5095.54,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4162,NULL,42285,3025,2,4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7025.48,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4163,NULL,42285,3025,2,4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8691.43,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4164,NULL,42285,3025,2,4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6691.70,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4165,NULL,42285,3025,2,4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',875.80,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4166,NULL,42285,3025,2,4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',13664.89,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4167,NULL,42285,3025,2,4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',13664.89,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4168,NULL,42285,3025,2,4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5226.42,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4169,NULL,42285,3025,2,4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3311.95,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4170,NULL,42285,3025,2,4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6092.14,NULL,NULL,1,'2022-08-17 12:46:30','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4171,NULL,42285,3025,2,4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2516.79,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4172,NULL,42285,3025,2,4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2229.35,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4173,NULL,42285,3025,2,4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',13324.63,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4174,NULL,42285,3025,2,4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4932.41,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4175,NULL,42285,3025,2,4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',23582.11,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4176,NULL,42285,3025,2,4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',14456.53,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31');
INSERT INTO `balance_libro` VALUES (4177,NULL,42285,3025,2,4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6298.95,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4178,NULL,42285,3025,2,4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5042.30,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4179,NULL,42285,3025,2,4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',12720.02,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4180,NULL,42285,3025,2,4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5303.91,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4181,NULL,42285,3025,2,4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7236.99,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4182,NULL,42285,3025,2,4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1607.76,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4183,NULL,42285,3025,2,4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6758.24,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4184,NULL,42285,3025,2,4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7078.50,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4185,NULL,42285,3025,2,4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8780.19,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4186,NULL,42285,3025,2,4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8276.82,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4187,NULL,42285,3025,2,4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4441.81,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4188,NULL,42285,3025,2,4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1626.51,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4189,NULL,42285,3025,2,4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4512.81,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4190,NULL,42285,3025,2,4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1813.27,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4191,NULL,42285,3025,2,4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7078.50,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4192,NULL,42285,3025,2,4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4381.99,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:31','2022-08-17 12:58:31'),(4193,NULL,42285,3025,2,4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4797.98,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4194,NULL,42285,3025,2,4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1245.33,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4195,NULL,42285,3025,2,4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1421.93,NULL,NULL,1,'2022-08-17 12:46:31','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4196,NULL,42285,3025,2,4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6297.76,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4197,NULL,42285,3025,2,4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4346.88,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4198,NULL,42285,3025,2,4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2202.97,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32');
INSERT INTO `balance_libro` VALUES (4199,NULL,42285,3025,2,4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2234.77,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4200,NULL,42285,3025,2,4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',93980.04,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4201,NULL,42285,3025,2,4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6141.27,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4202,NULL,42285,3025,2,4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2594.30,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4203,NULL,42285,3025,2,4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4204,NULL,42285,3025,2,4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3002.48,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4205,NULL,42285,3025,2,4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3002.48,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4206,NULL,42285,3025,2,4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3345.49,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4207,NULL,42285,3025,2,4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6488.96,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4208,NULL,42285,3025,2,4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3864.89,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4209,NULL,42285,3025,2,4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1987.94,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4210,NULL,42285,3025,2,4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2585.37,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4211,NULL,42285,3025,2,4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8167.20,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4212,NULL,42285,3025,2,4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3162.95,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4213,NULL,42285,3025,2,4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',11430.00,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4214,NULL,42285,3025,2,4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2182.06,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4215,NULL,42285,3025,2,4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2635.63,NULL,NULL,1,'2022-08-17 12:46:32','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4216,NULL,42285,3025,2,4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5155.74,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4217,NULL,42285,3025,2,4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3002.48,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4218,NULL,42285,3025,2,4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1179.48,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4219,NULL,42285,3025,2,4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2983.58,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4220,NULL,42285,3025,2,4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7240.38,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32');
INSERT INTO `balance_libro` VALUES (4221,NULL,42285,3025,2,4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5159.45,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4222,NULL,42285,3025,2,4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4246.83,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4223,NULL,42285,3025,2,4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',23582.11,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4224,NULL,42285,3025,2,4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3182.95,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4225,NULL,42285,3025,2,4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2648.19,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4226,NULL,42285,3025,2,4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1772.48,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4227,NULL,42285,3025,2,4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3002.48,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:32','2022-08-17 12:58:32'),(4228,NULL,42285,3025,2,4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4229,NULL,42285,3025,2,4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2781.48,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4230,NULL,42285,3025,2,4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1761.70,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4231,NULL,42285,3025,2,4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5017.11,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4232,NULL,42285,3025,2,4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3108.99,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4233,NULL,42285,3025,2,4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2114.90,NULL,NULL,1,'2022-08-17 12:46:33','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4234,NULL,42285,3025,2,4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2860.48,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4235,NULL,42285,3025,2,4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2781.48,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4236,NULL,42285,3025,2,4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1127.95,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4237,NULL,42285,3025,2,4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',16712.00,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4238,NULL,42285,3025,2,4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4672.40,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4239,NULL,42285,3025,2,4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4240,NULL,42285,3025,2,4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5844.32,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4241,NULL,42285,3025,2,4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1420.44,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4242,NULL,42285,3025,2,4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4713.24,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33');
INSERT INTO `balance_libro` VALUES (4243,NULL,42285,3025,2,4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5611.05,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4244,NULL,42285,3025,2,4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4512.81,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4245,NULL,42285,3025,2,4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7196.97,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4246,NULL,42285,3025,2,4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2315.02,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4247,NULL,42285,3025,2,4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2646.48,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4248,NULL,42285,3025,2,4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1330.46,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4249,NULL,42285,3025,2,4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6193.54,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4250,NULL,42285,3025,2,4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1335.99,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4251,NULL,42285,3025,2,4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5095.54,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4252,NULL,42285,3025,2,4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2983.30,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4253,NULL,42285,3025,2,4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1505.33,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4254,NULL,42285,3025,2,4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1823.77,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4255,NULL,42285,3025,2,4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3378.98,NULL,NULL,1,'2022-08-17 12:46:34','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4256,NULL,42285,3025,2,4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3912.47,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4257,NULL,42285,3025,2,4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4797.98,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4258,NULL,42285,3025,2,4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1929.41,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4259,NULL,42285,3025,2,4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4263.01,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4260,NULL,42285,3025,2,4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3108.99,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4261,NULL,42285,3025,2,4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2646.48,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4262,NULL,42285,3025,2,4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2023.49,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4263,NULL,42285,3025,2,4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4264,NULL,42285,3025,2,4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2497.68,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33');
INSERT INTO `balance_libro` VALUES (4265,NULL,42285,3025,2,4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2657.68,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4266,NULL,42285,3025,2,4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4263.91,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4267,NULL,42285,3025,2,4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3713.08,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4268,NULL,42285,3025,2,4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4041.66,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4269,NULL,42285,3025,2,4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1874.23,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:33','2022-08-17 12:58:33'),(4270,NULL,42285,3025,2,4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5748.07,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4271,NULL,42285,3025,2,4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2931.48,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4272,NULL,42285,3025,2,4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6849.00,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4273,NULL,42285,3025,2,4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5120.62,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4274,NULL,42285,3025,2,4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1928.34,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4275,NULL,42285,3025,2,4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4577.00,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4276,NULL,42285,3025,2,4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5874.00,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4277,NULL,42285,3025,2,4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3607.95,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4278,NULL,42285,3025,2,4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2781.48,NULL,NULL,1,'2022-08-17 12:46:35','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4279,NULL,42285,3025,2,4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3003.98,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4280,NULL,42285,3025,2,4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1665.98,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4281,NULL,42285,3025,2,4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5159.45,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4282,NULL,42285,3025,2,4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2502.27,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4283,NULL,42285,3025,2,4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2087.01,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4284,NULL,42285,3025,2,4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2639.89,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4285,NULL,42285,3025,2,4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3540.60,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4286,NULL,42285,3025,2,4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2998.86,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34');
INSERT INTO `balance_libro` VALUES (4287,NULL,42285,3025,2,4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4980.83,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4288,NULL,42285,3025,2,4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4460.84,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4289,NULL,42285,3025,2,4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1969.97,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4290,NULL,42285,3025,2,4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4715.60,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4291,NULL,42285,3025,2,4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4165.64,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4292,NULL,42285,3025,2,4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2588.56,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4293,NULL,42285,3025,2,4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1321.43,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4294,NULL,42285,3025,2,4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5943.71,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4295,NULL,42285,3025,2,4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5701.75,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4296,NULL,42285,3025,2,4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3258.98,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4297,NULL,42285,3025,2,4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5012.21,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:34','2022-08-17 12:58:34'),(4298,NULL,42285,3025,2,4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4797.98,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4299,NULL,42285,3025,2,4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1788.67,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4300,NULL,42285,3025,2,4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2239.11,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4301,NULL,42285,3025,2,4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4379.32,NULL,NULL,1,'2022-08-17 12:46:36','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4302,NULL,42285,3025,2,4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4303,NULL,42285,3025,2,4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4176.98,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4304,NULL,42285,3025,2,4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5584.66,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4305,NULL,42285,3025,2,4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1962.94,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4306,NULL,42285,3025,2,4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2454.31,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4307,NULL,42285,3025,2,4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3403.98,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4308,NULL,42285,3025,2,4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1375.44,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35');
INSERT INTO `balance_libro` VALUES (4309,NULL,42285,3025,2,4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2991.65,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4310,NULL,42285,3025,2,4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2545.63,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4311,NULL,42285,3025,2,4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1342.98,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4312,NULL,42285,3025,2,4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2657.81,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4313,NULL,42285,3025,2,4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',9304.69,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4314,NULL,42285,3025,2,4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3162.30,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4315,NULL,42285,3025,2,4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3470.71,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4316,NULL,42285,3025,2,4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4797.98,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4317,NULL,42285,3025,2,4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5579.03,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4318,NULL,42285,3025,2,4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3098.98,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4319,NULL,42285,3025,2,4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1928.09,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4320,NULL,42285,3025,2,4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3233.98,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4321,NULL,42285,3025,2,4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2315.49,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4322,NULL,42285,3025,2,4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3341.86,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4323,NULL,42285,3025,2,4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3192.95,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4324,NULL,42285,3025,2,4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1878.49,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4325,NULL,42285,3025,2,4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7650.35,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4326,NULL,42285,3025,2,4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1859.36,NULL,NULL,1,'2022-08-17 12:46:37','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4327,NULL,42285,3025,2,4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2750.95,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4328,NULL,42285,3025,2,4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5305.29,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4329,NULL,42285,3025,2,4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4797.98,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4330,NULL,42285,3025,2,4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1123.27,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:35','2022-08-17 12:58:35');
INSERT INTO `balance_libro` VALUES (4331,NULL,42285,3025,2,4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6339.55,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4332,NULL,42285,3025,2,4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1612.02,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4333,NULL,42285,3025,2,4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1062.49,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:35','2022-08-17 12:58:35'),(4334,NULL,42285,3025,2,4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',12938.06,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4335,NULL,42285,3025,2,4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',10699.61,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4336,NULL,42285,3025,2,4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1744.09,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4337,NULL,42285,3025,2,4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2931.48,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4338,NULL,42285,3025,2,4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3003.98,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4339,NULL,42285,3025,2,4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1124.28,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4340,NULL,42285,3025,2,4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',10740.01,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4341,NULL,42285,3025,2,4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1399.98,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4342,NULL,42285,3025,2,4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2931.48,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4343,NULL,42285,3025,2,4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',10740.01,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4344,NULL,42285,3025,2,4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',28532.50,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4345,NULL,42285,3025,2,4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4807.08,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4346,NULL,42285,3025,2,4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6228.78,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4347,NULL,42285,3025,2,4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4147.59,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4348,NULL,42285,3025,2,4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4987.21,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4349,NULL,42285,3025,2,4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1075.11,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4350,NULL,42285,3025,2,4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4715.60,NULL,NULL,1,'2022-08-17 12:46:38','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4351,NULL,42285,3025,2,4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1603.04,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4352,NULL,42285,3025,2,4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6543.65,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36');
INSERT INTO `balance_libro` VALUES (4353,NULL,42285,3025,2,4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3902.30,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4354,NULL,42285,3025,2,4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3015.31,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4355,NULL,42285,3025,2,4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',11727.03,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4356,NULL,42285,3025,2,4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5263.17,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4357,NULL,42285,3025,2,4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1999.85,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4358,NULL,42285,3025,2,4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1575.99,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4359,NULL,42285,3025,2,4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1753.04,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4360,NULL,42285,3025,2,4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',10740.01,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4361,NULL,42285,3025,2,4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2880.79,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4362,NULL,42285,3025,2,4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',16965.84,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4363,NULL,42285,3025,2,4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3289.69,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4364,NULL,42285,3025,2,4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4365,NULL,42285,3025,2,4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2083.84,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4366,NULL,42285,3025,2,4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2419.13,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4367,NULL,42285,3025,2,4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',20084.75,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4368,NULL,42285,3025,2,4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3148.98,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4369,NULL,42285,3025,2,4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6426.16,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4370,NULL,42285,3025,2,4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2419.13,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4371,NULL,42285,3025,2,4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1523.98,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4372,NULL,42285,3025,2,4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1845.47,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4373,NULL,42285,3025,2,4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4374,NULL,42285,3025,2,4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2114.95,NULL,NULL,1,'2022-08-17 12:46:39','2022-08-17 12:58:36','2022-08-17 12:58:36');
INSERT INTO `balance_libro` VALUES (4375,NULL,42285,3025,2,4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1621.50,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4376,NULL,42285,3025,2,4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1062.49,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4377,NULL,42285,3025,2,4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2368.84,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4378,NULL,42285,3025,2,4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1147.08,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4379,NULL,42285,3025,2,4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2713.88,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4380,NULL,42285,3025,2,4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3998.00,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:36','2022-08-17 12:58:36'),(4381,NULL,42285,3025,2,4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7729.03,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4382,NULL,42285,3025,2,4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',11275.46,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4383,NULL,42285,3025,2,4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1699.31,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4384,NULL,42285,3025,2,4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3233.98,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4385,NULL,42285,3025,2,4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4459.19,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4386,NULL,42285,3025,2,4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7463.53,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4387,NULL,42285,3025,2,4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2042.97,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4388,NULL,42285,3025,2,4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7536.40,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4389,NULL,42285,3025,2,4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2407.36,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4390,NULL,42285,3025,2,4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3576.77,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4391,NULL,42285,3025,2,4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2636.58,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4392,NULL,42285,3025,2,4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2736.48,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4393,NULL,42285,3025,2,4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5432.90,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4394,NULL,42285,3025,2,4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4395,NULL,42285,3025,2,4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3763.40,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4396,NULL,42285,3025,2,4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37');
INSERT INTO `balance_libro` VALUES (4397,NULL,42285,3025,2,4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5948.88,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4398,NULL,42285,3025,2,4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',11594.00,NULL,NULL,1,'2022-08-17 12:46:40','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4399,NULL,42285,3025,2,4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1452.98,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4400,NULL,42285,3025,2,4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4629.79,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4401,NULL,42285,3025,2,4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',23582.11,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4402,NULL,42285,3025,2,4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',9840.90,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4403,NULL,42285,3025,2,4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3362.23,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4404,NULL,42285,3025,2,4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1575.99,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4405,NULL,42285,3025,2,4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2848.98,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4406,NULL,42285,3025,2,4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2254.11,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4407,NULL,42285,3025,2,4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5227.58,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4408,NULL,42285,3025,2,4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1721.60,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4409,NULL,42285,3025,2,4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2841.22,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4410,NULL,42285,3025,2,4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3713.27,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4411,NULL,42285,3025,2,4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5249.03,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4412,NULL,42285,3025,2,4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1274.19,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4413,NULL,42285,3025,2,4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1510.44,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4414,NULL,42285,3025,2,4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1682.04,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4415,NULL,42285,3025,2,4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1952.48,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4416,NULL,42285,3025,2,4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4417,NULL,42285,3025,2,4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2303.11,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4418,NULL,42285,3025,2,4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3917.39,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37');
INSERT INTO `balance_libro` VALUES (4419,NULL,42285,3025,2,4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3378.98,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4420,NULL,42285,3025,2,4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1871.06,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4421,NULL,42285,3025,2,4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4244.24,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4422,NULL,42285,3025,2,4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2965.69,NULL,NULL,1,'2022-08-17 12:46:41','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4423,NULL,42285,3025,2,4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2781.48,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4424,NULL,42285,3025,2,4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3233.98,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4425,NULL,42285,3025,2,4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1179.48,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4426,NULL,42285,3025,2,4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4427,NULL,42285,3025,2,4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1238.61,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:37','2022-08-17 12:58:37'),(4428,NULL,42285,3025,2,4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1840.20,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4429,NULL,42285,3025,2,4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2858.00,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4430,NULL,42285,3025,2,4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2565.26,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4431,NULL,42285,3025,2,4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1836.35,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4432,NULL,42285,3025,2,4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1741.83,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4433,NULL,42285,3025,2,4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2615.63,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4434,NULL,42285,3025,2,4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2781.48,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4435,NULL,42285,3025,2,4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4436,NULL,42285,3025,2,4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2848.98,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4437,NULL,42285,3025,2,4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4438,NULL,42285,3025,2,4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',13355.82,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4439,NULL,42285,3025,2,4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4440,NULL,42285,3025,2,4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2725.63,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38');
INSERT INTO `balance_libro` VALUES (4441,NULL,42285,3025,2,4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3352.95,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4442,NULL,42285,3025,2,4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5344.34,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4443,NULL,42285,3025,2,4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2736.48,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4444,NULL,42285,3025,2,4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5095.54,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4445,NULL,42285,3025,2,4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2874.17,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4446,NULL,42285,3025,2,4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2368.84,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4447,NULL,42285,3025,2,4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',11489.47,NULL,NULL,1,'2022-08-17 12:46:42','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4448,NULL,42285,3025,2,4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4449,NULL,42285,3025,2,4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1225.95,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4450,NULL,42285,3025,2,4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',11863.44,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4451,NULL,42285,3025,2,4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1938.09,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4452,NULL,42285,3025,2,4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2197.36,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4453,NULL,42285,3025,2,4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',17791.75,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4454,NULL,42285,3025,2,4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2175.54,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4455,NULL,42285,3025,2,4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4511.60,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4456,NULL,42285,3025,2,4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',24100.00,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4457,NULL,42285,3025,2,4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3748.49,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4458,NULL,42285,3025,2,4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1557.47,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4459,NULL,42285,3025,2,4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5628.17,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4460,NULL,42285,3025,2,4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4461,NULL,42285,3025,2,4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3735.12,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4462,NULL,42285,3025,2,4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4198.33,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38');
INSERT INTO `balance_libro` VALUES (4463,NULL,42285,3025,2,4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',53583.81,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4464,NULL,42285,3025,2,4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2696.34,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4465,NULL,42285,3025,2,4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2124.98,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4466,NULL,42285,3025,2,4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4467,NULL,42285,3025,2,4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4468,NULL,42285,3025,2,4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7078.50,NULL,NULL,1,'2022-08-17 12:46:43','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4469,NULL,42285,3025,2,4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7196.97,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4470,NULL,42285,3025,2,4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2064.00,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4471,NULL,42285,3025,2,4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3727.95,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4472,NULL,42285,3025,2,4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4473,NULL,42285,3025,2,4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1832.48,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4474,NULL,42285,3025,2,4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2791.34,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4475,NULL,42285,3025,2,4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1159.18,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4476,NULL,42285,3025,2,4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2596.66,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4477,NULL,42285,3025,2,4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7924.42,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4478,NULL,42285,3025,2,4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2860.56,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4479,NULL,42285,3025,2,4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4797.98,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4480,NULL,42285,3025,2,4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3976.24,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4481,NULL,42285,3025,2,4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2820.63,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4482,NULL,42285,3025,2,4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4512.81,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4483,NULL,42285,3025,2,4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5529.81,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38'),(4484,NULL,42285,3025,2,4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2234.00,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:38','2022-08-17 12:58:38');
INSERT INTO `balance_libro` VALUES (4485,NULL,42285,3025,2,4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8796.98,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4486,NULL,42285,3025,2,4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5637.22,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4487,NULL,42285,3025,2,4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3002.48,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4488,NULL,42285,3025,2,4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3296.06,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4489,NULL,42285,3025,2,4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5558.26,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4490,NULL,42285,3025,2,4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3387.82,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4491,NULL,42285,3025,2,4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4257.07,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4492,NULL,42285,3025,2,4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:44','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4493,NULL,42285,3025,2,4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1579.39,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4494,NULL,42285,3025,2,4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1873.99,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4495,NULL,42285,3025,2,4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1502.13,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4496,NULL,42285,3025,2,4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',9422.12,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4497,NULL,42285,3025,2,4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4280.20,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4498,NULL,42285,3025,2,4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',12176.92,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4499,NULL,42285,3025,2,4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4500,NULL,42285,3025,2,4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3023.00,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4501,NULL,42285,3025,2,4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1859.36,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4502,NULL,42285,3025,2,4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1393.79,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4503,NULL,42285,3025,2,4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2315.02,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4504,NULL,42285,3025,2,4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2521.08,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4505,NULL,42285,3025,2,4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3680.05,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4506,NULL,42285,3025,2,4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',102841.20,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39');
INSERT INTO `balance_libro` VALUES (4507,NULL,42285,3025,2,4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2789.48,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4508,NULL,42285,3025,2,4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3688.40,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4509,NULL,42285,3025,2,4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6187.70,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4510,NULL,42285,3025,2,4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4860.32,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4511,NULL,42285,3025,2,4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1728.52,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4512,NULL,42285,3025,2,4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3108.99,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4513,NULL,42285,3025,2,4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2002.74,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4514,NULL,42285,3025,2,4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2570.47,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4515,NULL,42285,3025,2,4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',13527.80,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4516,NULL,42285,3025,2,4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',11489.47,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4517,NULL,42285,3025,2,4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2303.11,NULL,NULL,1,'2022-08-17 12:46:45','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4518,NULL,42285,3025,2,4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3258.98,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4519,NULL,42285,3025,2,4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2781.48,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4520,NULL,42285,3025,2,4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2781.48,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4521,NULL,42285,3025,2,4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3598.21,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4522,NULL,42285,3025,2,4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',9840.90,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4523,NULL,42285,3025,2,4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2257.99,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4524,NULL,42285,3025,2,4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5682.32,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4525,NULL,42285,3025,2,4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4602.40,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4526,NULL,42285,3025,2,4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2354.00,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4527,NULL,42285,3025,2,4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3161.14,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4528,NULL,42285,3025,2,4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39');
INSERT INTO `balance_libro` VALUES (4529,NULL,42285,3025,2,4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6125.44,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4530,NULL,42285,3025,2,4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4117.10,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4531,NULL,42285,3025,2,4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6083.38,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4532,NULL,42285,3025,2,4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1674.55,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4533,NULL,42285,3025,2,4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5095.54,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4534,NULL,42285,3025,2,4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6767.70,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4535,NULL,42285,3025,2,4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2027.30,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4536,NULL,42285,3025,2,4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2492.97,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4537,NULL,42285,3025,2,4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3041.69,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4538,NULL,42285,3025,2,4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',10811.82,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4539,NULL,42285,3025,2,4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1288.52,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4540,NULL,42285,3025,2,4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2092.45,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4541,NULL,42285,3025,2,4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1944.16,NULL,NULL,1,'2022-08-17 12:46:46','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4542,NULL,42285,3025,2,4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3002.48,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4543,NULL,42285,3025,2,4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3841.46,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4544,NULL,42285,3025,2,4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2417.47,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4545,NULL,42285,3025,2,4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',9248.69,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4546,NULL,42285,3025,2,4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2931.48,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4547,NULL,42285,3025,2,4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1519.75,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4548,NULL,42285,3025,2,4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2889.60,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4549,NULL,42285,3025,2,4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3448.19,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39'),(4550,NULL,42285,3025,2,4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1079.75,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:39','2022-08-17 12:58:39');
INSERT INTO `balance_libro` VALUES (4551,NULL,42285,3025,2,4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3362.33,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4552,NULL,42285,3025,2,4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',3983.49,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4553,NULL,42285,3025,2,4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4973.73,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4554,NULL,42285,3025,2,4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6725.80,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4555,NULL,42285,3025,2,4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4062.69,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4556,NULL,42285,3025,2,4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2399.80,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4557,NULL,42285,3025,2,4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',19191.72,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4558,NULL,42285,3025,2,4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6932.87,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4559,NULL,42285,3025,2,4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5566.95,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4560,NULL,42285,3025,2,4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7196.97,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4561,NULL,42285,3025,2,4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',3345.85,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4562,NULL,42285,3025,2,4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',17279.90,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4563,NULL,42285,3025,2,4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',10000.07,NULL,NULL,1,'2022-08-17 12:46:47','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4564,NULL,42285,3025,2,4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2858.90,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4565,NULL,42285,3025,2,4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',30731.07,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4566,NULL,42285,3025,2,4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2126.30,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4567,NULL,42285,3025,2,4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',14880.58,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4568,NULL,42285,3025,2,4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2590.05,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4569,NULL,42285,3025,2,4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7667.25,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4570,NULL,42285,3025,2,4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4004.78,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4571,NULL,42285,3025,2,4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4144.23,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4572,NULL,42285,3025,2,4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10345.50,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40');
INSERT INTO `balance_libro` VALUES (4573,NULL,42285,3025,2,4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10437.63,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4574,NULL,42285,3025,2,4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10961.19,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4575,NULL,42285,3025,2,4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4985.20,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4576,NULL,42285,3025,2,4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7171.44,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4577,NULL,42285,3025,2,4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10579.66,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4578,NULL,42285,3025,2,4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5126.51,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4579,NULL,42285,3025,2,4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',120401.02,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4580,NULL,42285,3025,2,4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3872.00,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4581,NULL,42285,3025,2,4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',93980.04,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4582,NULL,42285,3025,2,4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6153.15,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4583,NULL,42285,3025,2,4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7214.57,NULL,NULL,1,'2022-08-17 12:46:48','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4584,NULL,42285,3025,2,4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2978.98,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4585,NULL,42285,3025,2,4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8796.98,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4586,NULL,42285,3025,2,4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2646.39,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4587,NULL,42285,3025,2,4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2401.71,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4588,NULL,42285,3025,2,4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5498.10,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4589,NULL,42285,3025,2,4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3002.48,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4590,NULL,42285,3025,2,4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1634.12,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4591,NULL,42285,3025,2,4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6663.46,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4592,NULL,42285,3025,2,4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5930.38,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4593,NULL,42285,3025,2,4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2209.65,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4594,NULL,42285,3025,2,4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1859.36,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40');
INSERT INTO `balance_libro` VALUES (4595,NULL,42285,3025,2,4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1762.48,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4596,NULL,42285,3025,2,4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5748.78,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4597,NULL,42285,3025,2,4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7927.18,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4598,NULL,42285,3025,2,4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',533.50,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4599,NULL,42285,3025,2,4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4423.41,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4600,NULL,42285,3025,2,4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5744.60,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4601,NULL,42285,3025,2,4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7876.37,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4602,NULL,42285,3025,2,4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',12670.10,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4603,NULL,42285,3025,2,4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1272.00,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4604,NULL,42285,3025,2,4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5159.45,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4605,NULL,42285,3025,2,4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1106.47,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4606,NULL,42285,3025,2,4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1290.99,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4607,NULL,42285,3025,2,4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2649.97,NULL,NULL,1,'2022-08-17 12:46:49','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4608,NULL,42285,3025,2,4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2677.68,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4609,NULL,42285,3025,2,4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4274.62,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4610,NULL,42285,3025,2,4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3108.99,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4611,NULL,42285,3025,2,4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4612,NULL,42285,3025,2,4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3078.40,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4613,NULL,42285,3025,2,4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2238.84,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4614,NULL,42285,3025,2,4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5126.55,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4615,NULL,42285,3025,2,4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2830.45,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:40','2022-08-17 12:58:40'),(4616,NULL,42285,3025,2,4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1797.69,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41');
INSERT INTO `balance_libro` VALUES (4617,NULL,42285,3025,2,4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2045.18,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4618,NULL,42285,3025,2,4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5637.41,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4619,NULL,42285,3025,2,4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',31703.76,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4620,NULL,42285,3025,2,4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2501.79,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4621,NULL,42285,3025,2,4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7078.50,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4622,NULL,42285,3025,2,4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6663.46,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4623,NULL,42285,3025,2,4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5120.62,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4624,NULL,42285,3025,2,4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7262.57,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4625,NULL,42285,3025,2,4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1818.52,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4626,NULL,42285,3025,2,4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4269.86,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4627,NULL,42285,3025,2,4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2507.47,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4628,NULL,42285,3025,2,4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6271.96,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4629,NULL,42285,3025,2,4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4099.93,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4630,NULL,42285,3025,2,4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4631,NULL,42285,3025,2,4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2595.46,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4632,NULL,42285,3025,2,4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',29182.86,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4633,NULL,42285,3025,2,4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5355.53,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4634,NULL,42285,3025,2,4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',11489.47,NULL,NULL,1,'2022-08-17 12:46:50','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4635,NULL,42285,3025,2,4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2752.68,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4636,NULL,42285,3025,2,4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4493.08,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4637,NULL,42285,3025,2,4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4834.49,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4638,NULL,42285,3025,2,4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',35067.32,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41');
INSERT INTO `balance_libro` VALUES (4639,NULL,42285,3025,2,4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10926.10,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4640,NULL,42285,3025,2,4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1493.23,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4641,NULL,42285,3025,2,4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2781.48,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4642,NULL,42285,3025,2,4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4232.49,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4643,NULL,42285,3025,2,4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2575.63,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4644,NULL,42285,3025,2,4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4645,NULL,42285,3025,2,4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1725.29,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4646,NULL,42285,3025,2,4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',22978.94,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4647,NULL,42285,3025,2,4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5797.00,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4648,NULL,42285,3025,2,4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1859.36,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4649,NULL,42285,3025,2,4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4073.80,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4650,NULL,42285,3025,2,4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2059.82,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4651,NULL,42285,3025,2,4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8796.98,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4652,NULL,42285,3025,2,4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6083.38,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4653,NULL,42285,3025,2,4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5274.03,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4654,NULL,42285,3025,2,4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4498.01,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4655,NULL,42285,3025,2,4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5095.54,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4656,NULL,42285,3025,2,4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2789.48,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4657,NULL,42285,3025,2,4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4410.36,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4658,NULL,42285,3025,2,4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',24063.50,NULL,NULL,1,'2022-08-17 12:46:51','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4659,NULL,42285,3025,2,4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4582.20,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4660,NULL,42285,3025,2,4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2878.58,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41');
INSERT INTO `balance_libro` VALUES (4661,NULL,42285,3025,2,4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2402.68,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4662,NULL,42285,3025,2,4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',15859.20,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4663,NULL,42285,3025,2,4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4664,NULL,42285,3025,2,4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5478.88,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4665,NULL,42285,3025,2,4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4666,NULL,42285,3025,2,4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5095.54,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4667,NULL,42285,3025,2,4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3353.98,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4668,NULL,42285,3025,2,4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',9840.90,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4669,NULL,42285,3025,2,4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5259.46,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4670,NULL,42285,3025,2,4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4273.96,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4671,NULL,42285,3025,2,4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4672,NULL,42285,3025,2,4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3255.69,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4673,NULL,42285,3025,2,4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4674,NULL,42285,3025,2,4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1548.52,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4675,NULL,42285,3025,2,4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3088.98,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4676,NULL,42285,3025,2,4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2789.48,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:41','2022-08-17 12:58:41'),(4677,NULL,42285,3025,2,4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6000.62,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4678,NULL,42285,3025,2,4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1877.94,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4679,NULL,42285,3025,2,4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5823.45,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4680,NULL,42285,3025,2,4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2379.13,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4681,NULL,42285,3025,2,4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4682,NULL,42285,3025,2,4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2781.48,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42');
INSERT INTO `balance_libro` VALUES (4683,NULL,42285,3025,2,4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4367.08,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4684,NULL,42285,3025,2,4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8592.64,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4685,NULL,42285,3025,2,4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',9248.69,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4686,NULL,42285,3025,2,4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1981.79,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4687,NULL,42285,3025,2,4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10257.03,NULL,NULL,1,'2022-08-17 12:46:52','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4688,NULL,42285,3025,2,4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3582.87,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4689,NULL,42285,3025,2,4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1577.94,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4690,NULL,42285,3025,2,4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1912.45,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4691,NULL,42285,3025,2,4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1425.99,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4692,NULL,42285,3025,2,4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1155.31,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4693,NULL,42285,3025,2,4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5159.45,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4694,NULL,42285,3025,2,4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3920.69,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4695,NULL,42285,3025,2,4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2130.05,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4696,NULL,42285,3025,2,4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2752.68,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4697,NULL,42285,3025,2,4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1775.33,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4698,NULL,42285,3025,2,4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7816.60,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4699,NULL,42285,3025,2,4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1309.98,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4700,NULL,42285,3025,2,4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1541.67,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4701,NULL,42285,3025,2,4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6298.95,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4702,NULL,42285,3025,2,4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3325.39,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4703,NULL,42285,3025,2,4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3148.98,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4704,NULL,42285,3025,2,4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5456.03,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42');
INSERT INTO `balance_libro` VALUES (4705,NULL,42285,3025,2,4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2474.77,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4706,NULL,42285,3025,2,4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6083.38,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4707,NULL,42285,3025,2,4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1906.44,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:42','2022-08-17 12:58:42'),(4708,NULL,42285,3025,2,4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6663.46,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4709,NULL,42285,3025,2,4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1775.33,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4710,NULL,42285,3025,2,4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2841.22,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4711,NULL,42285,3025,2,4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4433.90,NULL,NULL,1,'2022-08-17 12:46:53','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4712,NULL,42285,3025,2,4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3233.98,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4713,NULL,42285,3025,2,4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1246.06,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4714,NULL,42285,3025,2,4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5628.17,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4715,NULL,42285,3025,2,4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2398.99,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4716,NULL,42285,3025,2,4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1562.57,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4717,NULL,42285,3025,2,4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4718,NULL,42285,3025,2,4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4237.02,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4719,NULL,42285,3025,2,4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4797.98,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4720,NULL,42285,3025,2,4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3458.98,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4721,NULL,42285,3025,2,4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8796.98,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4722,NULL,42285,3025,2,4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3108.99,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4723,NULL,42285,3025,2,4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3030.01,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4724,NULL,42285,3025,2,4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1745.54,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4725,NULL,42285,3025,2,4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1896.72,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4726,NULL,42285,3025,2,4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7677.10,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43');
INSERT INTO `balance_libro` VALUES (4727,NULL,42285,3025,2,4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1722.00,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4728,NULL,42285,3025,2,4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2912.68,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4729,NULL,42285,3025,2,4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',9840.90,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4730,NULL,42285,3025,2,4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2533.56,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4731,NULL,42285,3025,2,4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2205.93,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:43','2022-08-17 12:58:43'),(4732,NULL,42285,3025,2,4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4733,NULL,42285,3025,2,4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2413.56,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4734,NULL,42285,3025,2,4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2802.68,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4735,NULL,42285,3025,2,4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3557.95,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4736,NULL,42285,3025,2,4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1130.31,NULL,NULL,1,'2022-08-17 12:46:54','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4737,NULL,42285,3025,2,4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1589.44,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4738,NULL,42285,3025,2,4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8462.26,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4739,NULL,42285,3025,2,4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3916.81,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4740,NULL,42285,3025,2,4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2647.68,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4741,NULL,42285,3025,2,4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2873.98,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4742,NULL,42285,3025,2,4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5939.99,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4743,NULL,42285,3025,2,4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5159.45,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4744,NULL,42285,3025,2,4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',9604.15,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4745,NULL,42285,3025,2,4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4746,NULL,42285,3025,2,4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4747,NULL,42285,3025,2,4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4765.36,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4748,NULL,42285,3025,2,4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5259.46,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44');
INSERT INTO `balance_libro` VALUES (4749,NULL,42285,3025,2,4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4170.91,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4750,NULL,42285,3025,2,4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3022.59,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4751,NULL,42285,3025,2,4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5098.90,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4752,NULL,42285,3025,2,4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3173.98,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4753,NULL,42285,3025,2,4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3403.98,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4754,NULL,42285,3025,2,4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5263.17,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4755,NULL,42285,3025,2,4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3233.98,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4756,NULL,42285,3025,2,4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3557.52,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:44','2022-08-17 12:58:44'),(4757,NULL,42285,3025,2,4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3378.98,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4758,NULL,42285,3025,2,4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6187.70,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4759,NULL,42285,3025,2,4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1898.26,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4760,NULL,42285,3025,2,4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5120.62,NULL,NULL,1,'2022-08-17 12:46:55','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4761,NULL,42285,3025,2,4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4035.48,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4762,NULL,42285,3025,2,4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1859.36,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4763,NULL,42285,3025,2,4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1634.09,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4764,NULL,42285,3025,2,4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',9840.90,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4765,NULL,42285,3025,2,4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6187.70,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4766,NULL,42285,3025,2,4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1634.09,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4767,NULL,42285,3025,2,4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4768,NULL,42285,3025,2,4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1050.28,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4769,NULL,42285,3025,2,4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3121.95,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4770,NULL,42285,3025,2,4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3487.34,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45');
INSERT INTO `balance_libro` VALUES (4771,NULL,42285,3025,2,4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1844.17,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4772,NULL,42285,3025,2,4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5120.62,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4773,NULL,42285,3025,2,4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2781.48,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4774,NULL,42285,3025,2,4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3437.95,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4775,NULL,42285,3025,2,4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3002.48,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4776,NULL,42285,3025,2,4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4548.36,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4777,NULL,42285,3025,2,4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2180.18,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4778,NULL,42285,3025,2,4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1270.22,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4779,NULL,42285,3025,2,4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3727.95,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4780,NULL,42285,3025,2,4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4480.58,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:45','2022-08-17 12:58:45'),(4781,NULL,42285,3025,2,4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5159.45,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4782,NULL,42285,3025,2,4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2188.18,NULL,NULL,1,'2022-08-17 12:46:56','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4783,NULL,42285,3025,2,4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1066.09,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4784,NULL,42285,3025,2,4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2070.01,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4785,NULL,42285,3025,2,4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2398.99,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4786,NULL,42285,3025,2,4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3063.80,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4787,NULL,42285,3025,2,4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1859.36,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4788,NULL,42285,3025,2,4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',28532.50,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4789,NULL,42285,3025,2,4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',25603.10,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4790,NULL,42285,3025,2,4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2827.68,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4791,NULL,42285,3025,2,4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3766.81,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4792,NULL,42285,3025,2,4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2472.68,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46');
INSERT INTO `balance_libro` VALUES (4793,NULL,42285,3025,2,4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1775.33,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4794,NULL,42285,3025,2,4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6168.76,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4795,NULL,42285,3025,2,4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3049.92,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4796,NULL,42285,3025,2,4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1602.95,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4797,NULL,42285,3025,2,4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',9840.90,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4798,NULL,42285,3025,2,4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4093.17,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4799,NULL,42285,3025,2,4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1235.58,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4800,NULL,42285,3025,2,4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1859.36,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4801,NULL,42285,3025,2,4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4802,NULL,42285,3025,2,4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2107.94,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4803,NULL,42285,3025,2,4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2646.40,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4804,NULL,42285,3025,2,4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2677.68,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4805,NULL,42285,3025,2,4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4806,NULL,42285,3025,2,4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3466.19,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4807,NULL,42285,3025,2,4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3440.91,NULL,NULL,1,'2022-08-17 12:46:57','2022-08-17 12:58:46','2022-08-17 12:58:46'),(4808,NULL,42285,3025,2,4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5367.75,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4809,NULL,42285,3025,2,4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5159.45,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4810,NULL,42285,3025,2,4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2272.48,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4811,NULL,42285,3025,2,4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6071.28,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4812,NULL,42285,3025,2,4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4279.89,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4813,NULL,42285,3025,2,4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6663.46,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4814,NULL,42285,3025,2,4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3916.90,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47');
INSERT INTO `balance_libro` VALUES (4815,NULL,42285,3025,2,4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2572.68,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4816,NULL,42285,3025,2,4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4817,NULL,42285,3025,2,4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2135.18,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4818,NULL,42285,3025,2,4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5077.78,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4819,NULL,42285,3025,2,4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2978.98,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4820,NULL,42285,3025,2,4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3352.95,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4821,NULL,42285,3025,2,4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2271.07,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4822,NULL,42285,3025,2,4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2188.18,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4823,NULL,42285,3025,2,4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2310.57,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4824,NULL,42285,3025,2,4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4825,NULL,42285,3025,2,4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4797.98,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4826,NULL,42285,3025,2,4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',18042.11,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4827,NULL,42285,3025,2,4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2242.97,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4828,NULL,42285,3025,2,4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4249.96,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4829,NULL,42285,3025,2,4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5544.96,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4830,NULL,42285,3025,2,4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4831,NULL,42285,3025,2,4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7800.00,NULL,NULL,1,'2022-08-17 12:46:58','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4832,NULL,42285,3025,2,4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3648.08,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4833,NULL,42285,3025,2,4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1732.94,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4834,NULL,42285,3025,2,4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2942.95,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4835,NULL,42285,3025,2,4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2398.99,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4836,NULL,42285,3025,2,4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2607.68,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47');
INSERT INTO `balance_libro` VALUES (4837,NULL,42285,3025,2,4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',9604.15,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4838,NULL,42285,3025,2,4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4985.93,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4839,NULL,42285,3025,2,4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2861.43,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4840,NULL,42285,3025,2,4840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5259.46,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4841,NULL,42285,3025,2,4841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4453.20,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4842,NULL,42285,3025,2,4842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3606.58,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4843,NULL,42285,3025,2,4843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',60644.99,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4844,NULL,42285,3025,2,4844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3041.69,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4845,NULL,42285,3025,2,4845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1774.38,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4846,NULL,42285,3025,2,4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2889.60,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4847,NULL,42285,3025,2,4847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5276.18,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4848,NULL,42285,3025,2,4848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3195.67,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4849,NULL,42285,3025,2,4849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2889.60,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4850,NULL,42285,3025,2,4850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3914.58,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4851,NULL,42285,3025,2,4851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1654.98,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4852,NULL,42285,3025,2,4852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1952.48,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4853,NULL,42285,3025,2,4853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4797.98,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4854,NULL,42285,3025,2,4854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5779.20,NULL,NULL,1,'2022-08-17 12:46:59','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4855,NULL,42285,3025,2,4855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5621.88,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4856,NULL,42285,3025,2,4856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3353.98,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4857,NULL,42285,3025,2,4857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3763.24,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4858,NULL,42285,3025,2,4858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2889.60,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47');
INSERT INTO `balance_libro` VALUES (4859,NULL,42285,3025,2,4859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2527.98,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4860,NULL,42285,3025,2,4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',6911.76,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4861,NULL,42285,3025,2,4861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',15890.60,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4862,NULL,42285,3025,2,4862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6673.15,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4863,NULL,42285,3025,2,4863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3430.90,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:47','2022-08-17 12:58:47'),(4864,NULL,42285,3025,2,4864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10587.22,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4865,NULL,42285,3025,2,4865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3736.34,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4866,NULL,42285,3025,2,4866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',15286.41,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4867,NULL,42285,3025,2,4867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9007.48,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4868,NULL,42285,3025,2,4868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7809.74,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4869,NULL,42285,3025,2,4869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',22954.86,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4870,NULL,42285,3025,2,4870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9380.14,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4871,NULL,42285,3025,2,4871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',41508.65,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4872,NULL,42285,3025,2,4872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',30569.99,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4873,NULL,42285,3025,2,4873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5233.04,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4874,NULL,42285,3025,2,4874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6556.76,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4875,NULL,42285,3025,2,4875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4020.55,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4876,NULL,42285,3025,2,4876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4673.75,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4877,NULL,42285,3025,2,4877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',36834.90,NULL,NULL,1,'2022-08-17 12:47:00','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4878,NULL,42285,3025,2,4878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2041.25,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4879,NULL,42285,3025,2,4879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4827.90,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4880,NULL,42285,3025,2,4880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2253.95,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48');
INSERT INTO `balance_libro` VALUES (4881,NULL,42285,3025,2,4881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1538.99,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4882,NULL,42285,3025,2,4882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',23582.11,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4883,NULL,42285,3025,2,4883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',23582.11,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4884,NULL,42285,3025,2,4884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2444.85,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4885,NULL,42285,3025,2,4885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1218.26,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4886,NULL,42285,3025,2,4886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',88452.12,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4887,NULL,42285,3025,2,4887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3319.19,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4888,NULL,42285,3025,2,4888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7901.30,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4889,NULL,42285,3025,2,4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4890,NULL,42285,3025,2,4890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5251.40,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4891,NULL,42285,3025,2,4891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1830.47,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4892,NULL,42285,3025,2,4892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5259.46,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4893,NULL,42285,3025,2,4893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5802.04,NULL,NULL,1,'2022-08-17 12:47:01','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4894,NULL,42285,3025,2,4894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1375.44,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4895,NULL,42285,3025,2,4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1797.69,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4896,NULL,42285,3025,2,4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',21059.60,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4897,NULL,42285,3025,2,4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10804.77,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4898,NULL,42285,3025,2,4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10804.77,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4899,NULL,42285,3025,2,4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3908.16,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4900,NULL,42285,3025,2,4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1284.94,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4901,NULL,42285,3025,2,4901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3746.81,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4902,NULL,42285,3025,2,4902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9595.96,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48');
INSERT INTO `balance_libro` VALUES (4903,NULL,42285,3025,2,4903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3148.98,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4904,NULL,42285,3025,2,4904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4905,NULL,42285,3025,2,4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',12708.53,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4906,NULL,42285,3025,2,4906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4907,NULL,42285,3025,2,4907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3041.69,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:48','2022-08-17 12:58:48'),(4908,NULL,42285,3025,2,4908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4610.31,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4909,NULL,42285,3025,2,4909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3002.48,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4910,NULL,42285,3025,2,4910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2272.05,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4911,NULL,42285,3025,2,4911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2377.68,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4912,NULL,42285,3025,2,4912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:02','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4913,NULL,42285,3025,2,4913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',81721.78,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4914,NULL,42285,3025,2,4914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1859.36,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4915,NULL,42285,3025,2,4915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1008.94,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4916,NULL,42285,3025,2,4916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7999.00,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4917,NULL,42285,3025,2,4917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4918,NULL,42285,3025,2,4918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3151.99,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4919,NULL,42285,3025,2,4919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2273.59,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4920,NULL,42285,3025,2,4920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2304.65,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4921,NULL,42285,3025,2,4921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1797.69,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4922,NULL,42285,3025,2,4922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1797.69,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4923,NULL,42285,3025,2,4923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5159.45,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4924,NULL,42285,3025,2,4924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2973.11,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49');
INSERT INTO `balance_libro` VALUES (4925,NULL,42285,3025,2,4925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9889.00,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4926,NULL,42285,3025,2,4926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1980.56,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4927,NULL,42285,3025,2,4927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1879.81,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4928,NULL,42285,3025,2,4928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2912.68,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4929,NULL,42285,3025,2,4929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1628.74,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4930,NULL,42285,3025,2,4930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3232.66,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4931,NULL,42285,3025,2,4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3363.16,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4932,NULL,42285,3025,2,4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4933,NULL,42285,3025,2,4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:03','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4934,NULL,42285,3025,2,4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4532.38,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4935,NULL,42285,3025,2,4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6125.44,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4936,NULL,42285,3025,2,4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2740.55,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4937,NULL,42285,3025,2,4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2398.99,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4938,NULL,42285,3025,2,4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2646.48,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4939,NULL,42285,3025,2,4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4940,NULL,42285,3025,2,4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3233.98,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4941,NULL,42285,3025,2,4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3523.98,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4942,NULL,42285,3025,2,4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2982.30,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4943,NULL,42285,3025,2,4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2372.97,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4944,NULL,42285,3025,2,4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2398.99,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4945,NULL,42285,3025,2,4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6663.46,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4946,NULL,42285,3025,2,4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4278.96,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49');
INSERT INTO `balance_libro` VALUES (4947,NULL,42285,3025,2,4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10253.10,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4948,NULL,42285,3025,2,4948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1594.98,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4949,NULL,42285,3025,2,4949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4950,NULL,42285,3025,2,4950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3745.71,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4951,NULL,42285,3025,2,4951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2657.68,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4952,NULL,42285,3025,2,4952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1825.60,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:49','2022-08-17 12:58:49'),(4953,NULL,42285,3025,2,4953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5380.87,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4954,NULL,42285,3025,2,4954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4955,NULL,42285,3025,2,4955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3041.69,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4956,NULL,42285,3025,2,4956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4269.86,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4957,NULL,42285,3025,2,4957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2579.84,NULL,NULL,1,'2022-08-17 12:47:04','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4958,NULL,42285,3025,2,4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1076.75,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4959,NULL,42285,3025,2,4959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5095.54,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4960,NULL,42285,3025,2,4960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1287.06,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4961,NULL,42285,3025,2,4961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6177.89,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4962,NULL,42285,3025,2,4962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3052.68,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4963,NULL,42285,3025,2,4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1797.69,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4964,NULL,42285,3025,2,4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4965,NULL,42285,3025,2,4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1562.57,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4966,NULL,42285,3025,2,4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1342.98,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4967,NULL,42285,3025,2,4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2673.20,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4968,NULL,42285,3025,2,4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1062.49,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50');
INSERT INTO `balance_libro` VALUES (4969,NULL,42285,3025,2,4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3108.99,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4970,NULL,42285,3025,2,4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3200.98,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4971,NULL,42285,3025,2,4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3507.21,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4972,NULL,42285,3025,2,4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4973,NULL,42285,3025,2,4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5159.45,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4974,NULL,42285,3025,2,4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4975,NULL,42285,3025,2,4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3813.98,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4976,NULL,42285,3025,2,4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1466.52,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4977,NULL,42285,3025,2,4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3767.21,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4978,NULL,42285,3025,2,4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1903.49,NULL,NULL,1,'2022-08-17 12:47:05','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4979,NULL,42285,3025,2,4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1505.33,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4980,NULL,42285,3025,2,4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1875.63,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4981,NULL,42285,3025,2,4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1846.82,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4982,NULL,42285,3025,2,4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4989.17,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4983,NULL,42285,3025,2,4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1814.29,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4984,NULL,42285,3025,2,4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4047.05,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4985,NULL,42285,3025,2,4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3620.24,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4986,NULL,42285,3025,2,4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2889.60,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4987,NULL,42285,3025,2,4987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3420.64,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4988,NULL,42285,3025,2,4988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4504.04,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4989,NULL,42285,3025,2,4989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5274.03,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4990,NULL,42285,3025,2,4990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',11489.47,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50');
INSERT INTO `balance_libro` VALUES (4991,NULL,42285,3025,2,4991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6426.16,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4992,NULL,42285,3025,2,4992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2116.98,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4993,NULL,42285,3025,2,4993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5159.45,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4994,NULL,42285,3025,2,4994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3983.46,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4995,NULL,42285,3025,2,4995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',12120.73,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4996,NULL,42285,3025,2,4996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1388.82,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4997,NULL,42285,3025,2,4997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1159.80,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:50','2022-08-17 12:58:50'),(4998,NULL,42285,3025,2,4998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1832.48,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:51','2022-08-17 12:58:51'),(4999,NULL,42285,3025,2,4999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7814.31,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5000,NULL,42285,3025,2,5000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4701.35,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5001,NULL,42285,3025,2,5001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',32426.00,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5002,NULL,42285,3025,2,5002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4862.00,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5003,NULL,42285,3025,2,5003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',697.59,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5004,NULL,42285,3025,2,5004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6405.81,NULL,NULL,1,'2022-08-17 12:47:06','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5005,NULL,42285,3025,2,5005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4156.62,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5006,NULL,42285,3025,2,5006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1713.98,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5007,NULL,42285,3025,2,5007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1645.23,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5008,NULL,42285,3025,2,5008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7195.39,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5009,NULL,42285,3025,2,5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',11594.00,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5010,NULL,42285,3025,2,5010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',10565.48,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5011,NULL,42285,3025,2,5011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6691.70,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5012,NULL,42285,3025,2,5012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',26120.40,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51');
INSERT INTO `balance_libro` VALUES (5013,NULL,42285,3025,2,5013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5827.36,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5014,NULL,42285,3025,2,5014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',11843.65,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5015,NULL,42285,3025,2,5015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4210.17,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5016,NULL,42285,3025,2,5016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2935.06,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5017,NULL,42285,3025,2,5017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4080.94,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5018,NULL,42285,3025,2,5018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',4095.33,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5019,NULL,42285,3025,2,5019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',53910.70,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5020,NULL,42285,3025,2,5020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',7537.24,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5021,NULL,42285,3025,2,5021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5138.70,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5022,NULL,42285,3025,2,5022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',533.50,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5023,NULL,42285,3025,2,5023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',908.84,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5024,NULL,42285,3025,2,5024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3061.40,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5025,NULL,42285,3025,2,5025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3655.91,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5026,NULL,42285,3025,2,5026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',8348.00,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5027,NULL,42285,3025,2,5027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',11621.02,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5028,NULL,42285,3025,2,5028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',2000.02,NULL,NULL,1,'2022-08-17 12:47:07','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5029,NULL,42285,3025,2,5029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3363.46,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5030,NULL,42285,3025,2,5030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',2296.41,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5031,NULL,42285,3025,2,5031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',12882.49,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5032,NULL,42285,3025,2,5032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',2377.68,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5033,NULL,42285,3025,2,5033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4395.59,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5034,NULL,42285,3025,2,5034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',27316.17,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51');
INSERT INTO `balance_libro` VALUES (5035,NULL,42285,3025,2,5035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4975.10,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5036,NULL,42285,3025,2,5036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5938.92,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5037,NULL,42285,3025,2,5037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',15063.12,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5038,NULL,42285,3025,2,5038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4290.21,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5039,NULL,42285,3025,2,5039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9342.14,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5040,NULL,42285,3025,2,5040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6063.10,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5041,NULL,42285,3025,2,5041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',10349.00,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5042,NULL,42285,3025,2,5042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',10349.00,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5043,NULL,42285,3025,2,5043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7875.46,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5044,NULL,42285,3025,2,5044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1886.95,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5045,NULL,42285,3025,2,5045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1932.91,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5046,NULL,42285,3025,2,5046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4555.38,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5047,NULL,42285,3025,2,5047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4498.48,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5048,NULL,42285,3025,2,5048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11941.29,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:51','2022-08-17 12:58:51'),(5049,NULL,42285,3025,2,5049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',4170.14,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5050,NULL,42285,3025,2,5050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',47784.41,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5051,NULL,42285,3025,2,5051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5052,NULL,42285,3025,2,5052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5053,NULL,42285,3025,2,5053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5054,NULL,42285,3025,2,5054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:08','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5055,NULL,42285,3025,2,5055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1137.20,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5056,NULL,42285,3025,2,5056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52');
INSERT INTO `balance_libro` VALUES (5057,NULL,42285,3025,2,5057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5058,NULL,42285,3025,2,5058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1891.04,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5059,NULL,42285,3025,2,5059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5060,NULL,42285,3025,2,5060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5061,NULL,42285,3025,2,5061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5062,NULL,42285,3025,2,5062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',11843.65,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5063,NULL,42285,3025,2,5063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7930.11,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5064,NULL,42285,3025,2,5064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',16980.24,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5065,NULL,42285,3025,2,5065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1492.37,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5066,NULL,42285,3025,2,5066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3245.81,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5067,NULL,42285,3025,2,5067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',14161.80,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5068,NULL,42285,3025,2,5068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',14161.80,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5069,NULL,42285,3025,2,5069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',2103.73,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5070,NULL,42285,3025,2,5070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7130.02,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5071,NULL,42285,3025,2,5071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',105015.28,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5072,NULL,42285,3025,2,5072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5008.69,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5073,NULL,42285,3025,2,5073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1477.41,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5074,NULL,42285,3025,2,5074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',957.02,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5075,NULL,42285,3025,2,5075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3320.72,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5076,NULL,42285,3025,2,5076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1558.02,NULL,NULL,1,'2022-08-17 12:47:09','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5077,NULL,42285,3025,2,5077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5045.56,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5078,NULL,42285,3025,2,5078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6144.60,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52');
INSERT INTO `balance_libro` VALUES (5079,NULL,42285,3025,2,5079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3814.55,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5080,NULL,42285,3025,2,5080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3694.53,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5081,NULL,42285,3025,2,5081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7195.39,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5082,NULL,42285,3025,2,5082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',10037.55,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5083,NULL,42285,3025,2,5083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2621.29,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5084,NULL,42285,3025,2,5084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5756.32,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5085,NULL,42285,3025,2,5085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',8000.32,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5086,NULL,42285,3025,2,5086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2712.49,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5087,NULL,42285,3025,2,5087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6135.85,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5088,NULL,42285,3025,2,5088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5083.26,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5089,NULL,42285,3025,2,5089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3329.45,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5090,NULL,42285,3025,2,5090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',10143.81,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5091,NULL,42285,3025,2,5091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5092,NULL,42285,3025,2,5092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1335.96,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5093,NULL,42285,3025,2,5093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1987.94,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5094,NULL,42285,3025,2,5094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5095,NULL,42285,3025,2,5095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5779.20,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5096,NULL,42285,3025,2,5096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1734.33,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5097,NULL,42285,3025,2,5097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1440.22,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5098,NULL,42285,3025,2,5098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',9368.96,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5099,NULL,42285,3025,2,5099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5100,NULL,42285,3025,2,5100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',11030.60,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52');
INSERT INTO `balance_libro` VALUES (5101,NULL,42285,3025,2,5101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',9601.34,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5102,NULL,42285,3025,2,5102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',17467.85,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5103,NULL,42285,3025,2,5103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1797.69,NULL,NULL,1,'2022-08-17 12:47:10','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5104,NULL,42285,3025,2,5104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5072.95,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5105,NULL,42285,3025,2,5105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2961.82,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5106,NULL,42285,3025,2,5106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6663.46,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5107,NULL,42285,3025,2,5107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7213.79,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5108,NULL,42285,3025,2,5108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',15863.70,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5109,NULL,42285,3025,2,5109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1342.98,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:52','2022-08-17 12:58:52'),(5110,NULL,42285,3025,2,5110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',12020.51,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5111,NULL,42285,3025,2,5111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2398.99,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5112,NULL,42285,3025,2,5112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5452.35,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5113,NULL,42285,3025,2,5113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2249.00,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5114,NULL,42285,3025,2,5114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',9433.56,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5115,NULL,42285,3025,2,5115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1065.44,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5116,NULL,42285,3025,2,5116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1647.00,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5117,NULL,42285,3025,2,5117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2904.97,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5118,NULL,42285,3025,2,5118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5095.54,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5119,NULL,42285,3025,2,5119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3857.37,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5120,NULL,42285,3025,2,5120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3741.68,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5121,NULL,42285,3025,2,5121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4770.00,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5122,NULL,42285,3025,2,5122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6354.70,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53');
INSERT INTO `balance_libro` VALUES (5123,NULL,42285,3025,2,5123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',11515.60,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5124,NULL,42285,3025,2,5124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',15260.41,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5125,NULL,42285,3025,2,5125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2666.64,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5126,NULL,42285,3025,2,5126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4133.72,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5127,NULL,42285,3025,2,5127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2069.23,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5128,NULL,42285,3025,2,5128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3142.51,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5129,NULL,42285,3025,2,5129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:11','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5130,NULL,42285,3025,2,5130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4797.98,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5131,NULL,42285,3025,2,5131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3503.11,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5132,NULL,42285,3025,2,5132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3002.48,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5133,NULL,42285,3025,2,5133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3108.99,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5134,NULL,42285,3025,2,5134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5266.78,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5135,NULL,42285,3025,2,5135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1186.47,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5136,NULL,42285,3025,2,5136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2294.57,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5137,NULL,42285,3025,2,5137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4017.55,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5138,NULL,42285,3025,2,5138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1802.94,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5139,NULL,42285,3025,2,5139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6663.46,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5140,NULL,42285,3025,2,5140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3353.98,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5141,NULL,42285,3025,2,5141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5263.17,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5142,NULL,42285,3025,2,5142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',8975.40,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5143,NULL,42285,3025,2,5143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5410.98,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5144,NULL,42285,3025,2,5144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53');
INSERT INTO `balance_libro` VALUES (5145,NULL,42285,3025,2,5145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3887.95,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5146,NULL,42285,3025,2,5146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3014.35,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5147,NULL,42285,3025,2,5147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',17202.00,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5148,NULL,42285,3025,2,5148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2736.48,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5149,NULL,42285,3025,2,5149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4557.05,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5150,NULL,42285,3025,2,5150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2647.68,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5151,NULL,42285,3025,2,5151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3437.95,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5152,NULL,42285,3025,2,5152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:12','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5153,NULL,42285,3025,2,5153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5551.95,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5154,NULL,42285,3025,2,5154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2081.85,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5155,NULL,42285,3025,2,5155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5982.82,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5156,NULL,42285,3025,2,5156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4649.12,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5157,NULL,42285,3025,2,5157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5802.04,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5158,NULL,42285,3025,2,5158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2903.67,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5159,NULL,42285,3025,2,5159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5082.00,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5160,NULL,42285,3025,2,5160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3233.98,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5161,NULL,42285,3025,2,5161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6958.26,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5162,NULL,42285,3025,2,5162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5802.04,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5163,NULL,42285,3025,2,5163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2978.98,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5164,NULL,42285,3025,2,5164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5165,NULL,42285,3025,2,5165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2672.97,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5166,NULL,42285,3025,2,5166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3503.98,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53');
INSERT INTO `balance_libro` VALUES (5167,NULL,42285,3025,2,5167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',10729.65,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5168,NULL,42285,3025,2,5168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5169,NULL,42285,3025,2,5169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1336.00,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5170,NULL,42285,3025,2,5170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2578.81,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5171,NULL,42285,3025,2,5171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5073.17,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5172,NULL,42285,3025,2,5172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1797.69,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5173,NULL,42285,3025,2,5173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:53','2022-08-17 12:58:53'),(5174,NULL,42285,3025,2,5174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5175,NULL,42285,3025,2,5175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5343.36,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5176,NULL,42285,3025,2,5176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5177,NULL,42285,3025,2,5177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7812.85,NULL,NULL,1,'2022-08-17 12:47:13','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5178,NULL,42285,3025,2,5178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1680.47,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5179,NULL,42285,3025,2,5179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2158.13,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5180,NULL,42285,3025,2,5180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5978.49,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5181,NULL,42285,3025,2,5181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2192.97,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5182,NULL,42285,3025,2,5182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6318.50,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5183,NULL,42285,3025,2,5183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2978.98,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5184,NULL,42285,3025,2,5184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4679.82,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5185,NULL,42285,3025,2,5185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5186,NULL,42285,3025,2,5186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7073.93,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5187,NULL,42285,3025,2,5187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3597.23,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5188,NULL,42285,3025,2,5188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2303.11,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54');
INSERT INTO `balance_libro` VALUES (5189,NULL,42285,3025,2,5189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3549.64,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5190,NULL,42285,3025,2,5190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5759.60,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5191,NULL,42285,3025,2,5191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3347.50,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5192,NULL,42285,3025,2,5192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3148.98,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5193,NULL,42285,3025,2,5193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2746.08,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5194,NULL,42285,3025,2,5194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3595.38,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5195,NULL,42285,3025,2,5195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2596.43,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5196,NULL,42285,3025,2,5196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6426.16,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5197,NULL,42285,3025,2,5197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5621.88,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5198,NULL,42285,3025,2,5198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2889.60,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5199,NULL,42285,3025,2,5199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6187.70,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5200,NULL,42285,3025,2,5200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',17618.54,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5201,NULL,42285,3025,2,5201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2933.13,NULL,NULL,1,'2022-08-17 12:47:14','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5202,NULL,42285,3025,2,5202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3437.95,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5203,NULL,42285,3025,2,5203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1797.69,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5204,NULL,42285,3025,2,5204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5205,NULL,42285,3025,2,5205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1064.28,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5206,NULL,42285,3025,2,5206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2883.45,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5207,NULL,42285,3025,2,5207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2398.99,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5208,NULL,42285,3025,2,5208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5536.68,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5209,NULL,42285,3025,2,5209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1279.73,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5210,NULL,42285,3025,2,5210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1725.47,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54');
INSERT INTO `balance_libro` VALUES (5211,NULL,42285,3025,2,5211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4759.61,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5212,NULL,42285,3025,2,5212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4891.28,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5213,NULL,42285,3025,2,5213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1505.33,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5214,NULL,42285,3025,2,5214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5159.45,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5215,NULL,42285,3025,2,5215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3343.98,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5216,NULL,42285,3025,2,5216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1225.95,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5217,NULL,42285,3025,2,5217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5218,NULL,42285,3025,2,5218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2329.53,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5219,NULL,42285,3025,2,5219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',11646.00,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5220,NULL,42285,3025,2,5220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5221,NULL,42285,3025,2,5221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1797.69,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5222,NULL,42285,3025,2,5222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6663.46,NULL,NULL,1,'2022-08-17 12:47:15','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5223,NULL,42285,3025,2,5223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1656.34,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5224,NULL,42285,3025,2,5224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4794.99,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5225,NULL,42285,3025,2,5225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2830.45,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5226,NULL,42285,3025,2,5226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',9248.69,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5227,NULL,42285,3025,2,5227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',10250.24,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5228,NULL,42285,3025,2,5228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6083.38,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5229,NULL,42285,3025,2,5229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5095.54,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5230,NULL,42285,3025,2,5230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5231,NULL,42285,3025,2,5231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2225.63,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5232,NULL,42285,3025,2,5232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7717.50,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54');
INSERT INTO `balance_libro` VALUES (5233,NULL,42285,3025,2,5233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1952.32,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5234,NULL,42285,3025,2,5234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5159.45,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5235,NULL,42285,3025,2,5235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1878.49,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5236,NULL,42285,3025,2,5236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5237,NULL,42285,3025,2,5237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',10740.01,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5238,NULL,42285,3025,2,5238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',49911.36,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5239,NULL,42285,3025,2,5239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2723.58,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5240,NULL,42285,3025,2,5240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5241,NULL,42285,3025,2,5241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5759.21,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5242,NULL,42285,3025,2,5242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1797.69,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:54','2022-08-17 12:58:54'),(5243,NULL,42285,3025,2,5243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1794.66,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5244,NULL,42285,3025,2,5244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',9248.69,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5245,NULL,42285,3025,2,5245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1305.18,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5246,NULL,42285,3025,2,5246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1408.10,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5247,NULL,42285,3025,2,5247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5522.43,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5248,NULL,42285,3025,2,5248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6996.63,NULL,NULL,1,'2022-08-17 12:47:16','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5249,NULL,42285,3025,2,5249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3078.11,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5250,NULL,42285,3025,2,5250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1740.27,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5251,NULL,42285,3025,2,5251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3168.32,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5252,NULL,42285,3025,2,5252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1246.06,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5253,NULL,42285,3025,2,5253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1794.66,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5254,NULL,42285,3025,2,5254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6304.43,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55');
INSERT INTO `balance_libro` VALUES (5255,NULL,42285,3025,2,5255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7199.97,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5256,NULL,42285,3025,2,5256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5257,NULL,42285,3025,2,5257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',13178.00,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5258,NULL,42285,3025,2,5258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',11380.58,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5259,NULL,42285,3025,2,5259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2046.55,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5260,NULL,42285,3025,2,5260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5261,NULL,42285,3025,2,5261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1984.49,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5262,NULL,42285,3025,2,5262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2607.37,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5263,NULL,42285,3025,2,5263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2873.98,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5264,NULL,42285,3025,2,5264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1893.90,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5265,NULL,42285,3025,2,5265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',20577.19,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5266,NULL,42285,3025,2,5266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2566.08,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5267,NULL,42285,3025,2,5267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5637.73,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5268,NULL,42285,3025,2,5268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4138.79,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5269,NULL,42285,3025,2,5269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1626.55,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5270,NULL,42285,3025,2,5270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1750.33,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5271,NULL,42285,3025,2,5271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1814.07,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5272,NULL,42285,3025,2,5272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5273,NULL,42285,3025,2,5273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',8013.75,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5274,NULL,42285,3025,2,5274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',8034.06,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5275,NULL,42285,3025,2,5275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1672.07,NULL,NULL,1,'2022-08-17 12:47:17','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5276,NULL,42285,3025,2,5276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5522.43,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55');
INSERT INTO `balance_libro` VALUES (5277,NULL,42285,3025,2,5277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1363.10,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5278,NULL,42285,3025,2,5278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1874.21,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5279,NULL,42285,3025,2,5279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1911.75,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5280,NULL,42285,3025,2,5280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3041.69,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5281,NULL,42285,3025,2,5281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2631.56,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5282,NULL,42285,3025,2,5282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1343.82,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5283,NULL,42285,3025,2,5283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2188.18,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5284,NULL,42285,3025,2,5284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2695.55,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5285,NULL,42285,3025,2,5285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2297.97,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5286,NULL,42285,3025,2,5286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1432.77,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5287,NULL,42285,3025,2,5287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4001.74,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5288,NULL,42285,3025,2,5288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6298.95,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5289,NULL,42285,3025,2,5289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2948.67,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5290,NULL,42285,3025,2,5290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3378.98,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5291,NULL,42285,3025,2,5291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5522.43,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5292,NULL,42285,3025,2,5292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1886.32,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5293,NULL,42285,3025,2,5293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5377.99,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5294,NULL,42285,3025,2,5294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7567.54,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5295,NULL,42285,3025,2,5295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6745.50,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5296,NULL,42285,3025,2,5296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2647.68,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5297,NULL,42285,3025,2,5297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',13970.00,NULL,NULL,1,'2022-08-17 12:47:18','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5298,NULL,42285,3025,2,5298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2675.37,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:55','2022-08-17 12:58:55');
INSERT INTO `balance_libro` VALUES (5299,NULL,42285,3025,2,5299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1975.98,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5300,NULL,42285,3025,2,5300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4750.33,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5301,NULL,42285,3025,2,5301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2510.79,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5302,NULL,42285,3025,2,5302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',17639.44,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5303,NULL,42285,3025,2,5303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6923.00,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:55','2022-08-17 12:58:55'),(5304,NULL,42285,3025,2,5304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5777.00,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5305,NULL,42285,3025,2,5305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2272.68,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5306,NULL,42285,3025,2,5306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2523.71,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5307,NULL,42285,3025,2,5307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',17639.44,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5308,NULL,42285,3025,2,5308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3096.45,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5309,NULL,42285,3025,2,5309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2132.51,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5310,NULL,42285,3025,2,5310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6468.71,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5311,NULL,42285,3025,2,5311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2777.68,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5312,NULL,42285,3025,2,5312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',24426.00,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5313,NULL,42285,3025,2,5313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3108.99,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5314,NULL,42285,3025,2,5314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1292.86,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5315,NULL,42285,3025,2,5315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2328.56,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5316,NULL,42285,3025,2,5316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5204.24,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5317,NULL,42285,3025,2,5317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2979.47,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5318,NULL,42285,3025,2,5318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',49911.36,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5319,NULL,42285,3025,2,5319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2690.01,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5320,NULL,42285,3025,2,5320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.73,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56');
INSERT INTO `balance_libro` VALUES (5321,NULL,42285,3025,2,5321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1664.34,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5322,NULL,42285,3025,2,5322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5159.45,NULL,NULL,1,'2022-08-17 12:47:19','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5323,NULL,42285,3025,2,5323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2848.98,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5324,NULL,42285,3025,2,5324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2472.68,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5325,NULL,42285,3025,2,5325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3448.18,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5326,NULL,42285,3025,2,5326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',10963.83,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5327,NULL,42285,3025,2,5327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4284.50,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5328,NULL,42285,3025,2,5328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3115.66,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5329,NULL,42285,3025,2,5329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3002.48,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5330,NULL,42285,3025,2,5330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1331.11,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5331,NULL,42285,3025,2,5331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7259.51,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5332,NULL,42285,3025,2,5332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6158.95,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5333,NULL,42285,3025,2,5333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5522.43,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5334,NULL,42285,3025,2,5334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',4095.33,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5335,NULL,42285,3025,2,5335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8372.96,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5336,NULL,42285,3025,2,5336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2751.67,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5337,NULL,42285,3025,2,5337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3565.31,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5338,NULL,42285,3025,2,5338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4916.53,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5339,NULL,42285,3025,2,5339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2509.65,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5340,NULL,42285,3025,2,5340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1797.69,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5341,NULL,42285,3025,2,5341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1920.47,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5342,NULL,42285,3025,2,5342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3228.22,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56');
INSERT INTO `balance_libro` VALUES (5343,NULL,42285,3025,2,5343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1628.52,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5344,NULL,42285,3025,2,5344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1831.61,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5345,NULL,42285,3025,2,5345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1578.77,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5346,NULL,42285,3025,2,5346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3091.93,NULL,NULL,1,'2022-08-17 12:47:20','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5347,NULL,42285,3025,2,5347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1464.92,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5348,NULL,42285,3025,2,5348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3876.89,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5349,NULL,42285,3025,2,5349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1725.59,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5350,NULL,42285,3025,2,5350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2521.08,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5351,NULL,42285,3025,2,5351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2836.89,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5352,NULL,42285,3025,2,5352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3182.95,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5353,NULL,42285,3025,2,5353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4041.31,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5354,NULL,42285,3025,2,5354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6932.87,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5355,NULL,42285,3025,2,5355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5451.59,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5356,NULL,42285,3025,2,5356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4072.74,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:56','2022-08-17 12:58:56'),(5357,NULL,42285,3025,2,5357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1115.61,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5358,NULL,42285,3025,2,5358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',21799.00,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5359,NULL,42285,3025,2,5359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3245.39,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5360,NULL,42285,3025,2,5360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3937.15,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5361,NULL,42285,3025,2,5361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9141.77,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5362,NULL,42285,3025,2,5362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6392.54,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5363,NULL,42285,3025,2,5363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3803.04,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5364,NULL,42285,3025,2,5364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2603.19,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57');
INSERT INTO `balance_libro` VALUES (5365,NULL,42285,3025,2,5365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3378.98,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5366,NULL,42285,3025,2,5366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1273.85,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5367,NULL,42285,3025,2,5367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9430.10,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5368,NULL,42285,3025,2,5368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7219.74,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5369,NULL,42285,3025,2,5369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7907.26,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5370,NULL,42285,3025,2,5370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2507.68,NULL,NULL,1,'2022-08-17 12:47:21','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5371,NULL,42285,3025,2,5371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1806.62,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5372,NULL,42285,3025,2,5372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2188.18,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5373,NULL,42285,3025,2,5373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1425.99,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5374,NULL,42285,3025,2,5374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4293.69,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5375,NULL,42285,3025,2,5375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9347.45,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5376,NULL,42285,3025,2,5376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2978.98,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5377,NULL,42285,3025,2,5377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1835.51,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5378,NULL,42285,3025,2,5378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5073.17,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5379,NULL,42285,3025,2,5379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1493.49,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5380,NULL,42285,3025,2,5380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1832.01,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5381,NULL,42285,3025,2,5381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3112.35,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5382,NULL,42285,3025,2,5382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1728.52,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5383,NULL,42285,3025,2,5383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10145.66,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5384,NULL,42285,3025,2,5384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1742.67,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5385,NULL,42285,3025,2,5385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1506.10,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5386,NULL,42285,3025,2,5386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2827.92,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57');
INSERT INTO `balance_libro` VALUES (5387,NULL,42285,3025,2,5387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',19404.00,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5388,NULL,42285,3025,2,5388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',18130.00,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5389,NULL,42285,3025,2,5389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5661.44,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5390,NULL,42285,3025,2,5390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2204.96,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5391,NULL,42285,3025,2,5391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3378.98,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5392,NULL,42285,3025,2,5392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3352.95,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5393,NULL,42285,3025,2,5393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1788.25,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5394,NULL,42285,3025,2,5394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1474.71,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5395,NULL,42285,3025,2,5395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9248.69,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5396,NULL,42285,3025,2,5396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',49911.36,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5397,NULL,42285,3025,2,5397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3731.55,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5398,NULL,42285,3025,2,5398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3315.53,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:57','2022-08-17 12:58:57'),(5399,NULL,42285,3025,2,5399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',12020.51,NULL,NULL,1,'2022-08-17 12:47:22','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5400,NULL,42285,3025,2,5400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5117.99,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5401,NULL,42285,3025,2,5401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5433.17,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5402,NULL,42285,3025,2,5402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7196.97,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5403,NULL,42285,3025,2,5403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',14404.29,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5404,NULL,42285,3025,2,5404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7078.50,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5405,NULL,42285,3025,2,5405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',46594.62,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5406,NULL,42285,3025,2,5406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5682.32,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5407,NULL,42285,3025,2,5407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1556.59,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5408,NULL,42285,3025,2,5408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5682.32,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58');
INSERT INTO `balance_libro` VALUES (5409,NULL,42285,3025,2,5409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4965.84,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5410,NULL,42285,3025,2,5410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4074.19,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5411,NULL,42285,3025,2,5411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5432.90,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5412,NULL,42285,3025,2,5412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',19404.00,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5413,NULL,42285,3025,2,5413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5648.49,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5414,NULL,42285,3025,2,5414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3352.95,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5415,NULL,42285,3025,2,5415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',53583.81,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5416,NULL,42285,3025,2,5416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3671.81,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 12:58:58','2022-08-17 12:58:58'),(5417,NULL,42285,3025,2,5417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5420.28,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5418,NULL,42285,3025,2,5418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2076.62,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5419,NULL,42285,3025,2,5419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1567.84,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5420,NULL,42285,3025,2,5420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1725.47,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5421,NULL,42285,3025,2,5421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3979.97,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5422,NULL,42285,3025,2,5422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7785.56,NULL,NULL,1,'2022-08-17 12:47:23','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5423,NULL,42285,3025,2,5423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2977.39,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5424,NULL,42285,3025,2,5424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2398.99,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5425,NULL,42285,3025,2,5425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',11801.49,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5426,NULL,42285,3025,2,5426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3717.46,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5427,NULL,42285,3025,2,5427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1010.22,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5428,NULL,42285,3025,2,5428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3305.72,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5429,NULL,42285,3025,2,5429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2848.98,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5430,NULL,42285,3025,2,5430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2566.61,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59');
INSERT INTO `balance_libro` VALUES (5431,NULL,42285,3025,2,5431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1398.98,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5432,NULL,42285,3025,2,5432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2013.06,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5433,NULL,42285,3025,2,5433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2284.93,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5434,NULL,42285,3025,2,5434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5159.45,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5435,NULL,42285,3025,2,5435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4356.00,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5436,NULL,42285,3025,2,5436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4089.52,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5437,NULL,42285,3025,2,5437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1946.47,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5438,NULL,42285,3025,2,5438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5963.53,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5439,NULL,42285,3025,2,5439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4715.73,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5440,NULL,42285,3025,2,5440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9500.66,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5441,NULL,42285,3025,2,5441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1614.99,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5442,NULL,42285,3025,2,5442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1130.31,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5443,NULL,42285,3025,2,5443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2477.97,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5444,NULL,42285,3025,2,5444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2875.45,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5445,NULL,42285,3025,2,5445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3767.75,NULL,NULL,1,'2022-08-17 12:47:24','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5446,NULL,42285,3025,2,5446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2933.69,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5447,NULL,42285,3025,2,5447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1643.52,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5448,NULL,42285,3025,2,5448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1565.94,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:06:59','2022-08-17 15:06:59'),(5449,NULL,42285,3025,2,5449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5115.05,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5450,NULL,42285,3025,2,5450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5052.24,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5451,NULL,42285,3025,2,5451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5874.00,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5452,NULL,42285,3025,2,5452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10813.95,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00');
INSERT INTO `balance_libro` VALUES (5453,NULL,42285,3025,2,5453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4797.98,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5454,NULL,42285,3025,2,5454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9038.87,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5455,NULL,42285,3025,2,5455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2578.47,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5456,NULL,42285,3025,2,5456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1225.95,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5457,NULL,42285,3025,2,5457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5610.32,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5458,NULL,42285,3025,2,5458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4797.98,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5459,NULL,42285,3025,2,5459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4890.71,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5460,NULL,42285,3025,2,5460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3372.75,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5461,NULL,42285,3025,2,5461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4175.79,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5462,NULL,42285,3025,2,5462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5095.54,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5463,NULL,42285,3025,2,5463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3148.45,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5464,NULL,42285,3025,2,5464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4770.00,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5465,NULL,42285,3025,2,5465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9735.47,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5466,NULL,42285,3025,2,5466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1340.63,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5467,NULL,42285,3025,2,5467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5521.57,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5468,NULL,42285,3025,2,5468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5797.00,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5469,NULL,42285,3025,2,5469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2316.94,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5470,NULL,42285,3025,2,5470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2296.41,NULL,NULL,1,'2022-08-17 12:47:25','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5471,NULL,42285,3025,2,5471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2203.49,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5472,NULL,42285,3025,2,5472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1553.66,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5473,NULL,42285,3025,2,5473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',279.64,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5474,NULL,42285,3025,2,5474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',878.90,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00');
INSERT INTO `balance_libro` VALUES (5475,NULL,42285,3025,2,5475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4103.70,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5476,NULL,42285,3025,2,5476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4733.58,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5477,NULL,42285,3025,2,5477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',15982.08,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5478,NULL,42285,3025,2,5478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1268.69,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5479,NULL,42285,3025,2,5479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9989.02,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5480,NULL,42285,3025,2,5480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3527.95,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5481,NULL,42285,3025,2,5481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4770.00,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5482,NULL,42285,3025,2,5482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2401.18,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5483,NULL,42285,3025,2,5483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4117.10,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5484,NULL,42285,3025,2,5484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3378.98,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5485,NULL,42285,3025,2,5485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3758.98,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5486,NULL,42285,3025,2,5486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1184.10,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5487,NULL,42285,3025,2,5487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1439.77,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5488,NULL,42285,3025,2,5488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4770.00,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5489,NULL,42285,3025,2,5489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4797.98,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5490,NULL,42285,3025,2,5490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4797.98,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5491,NULL,42285,3025,2,5491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2409.47,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5492,NULL,42285,3025,2,5492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7901.30,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5493,NULL,42285,3025,2,5493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2650.36,NULL,NULL,1,'2022-08-17 12:47:26','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5494,NULL,42285,3025,2,5494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4221.80,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5495,NULL,42285,3025,2,5495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1290.34,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5496,NULL,42285,3025,2,5496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',15018.24,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:00','2022-08-17 15:07:00');
INSERT INTO `balance_libro` VALUES (5497,NULL,42285,3025,2,5497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4159.20,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5498,NULL,42285,3025,2,5498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5120.62,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5499,NULL,42285,3025,2,5499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7528.92,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5500,NULL,42285,3025,2,5500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3002.48,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:00','2022-08-17 15:07:00'),(5501,NULL,42285,3025,2,5501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5537.25,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5502,NULL,42285,3025,2,5502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1078.26,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5503,NULL,42285,3025,2,5503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8422.75,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5504,NULL,42285,3025,2,5504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1817.90,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5505,NULL,42285,3025,2,5505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6125.44,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5506,NULL,42285,3025,2,5506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1928.28,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5507,NULL,42285,3025,2,5507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3472.95,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5508,NULL,42285,3025,2,5508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5095.54,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5509,NULL,42285,3025,2,5509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2398.99,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5510,NULL,42285,3025,2,5510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3420.23,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5511,NULL,42285,3025,2,5511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3855.48,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5512,NULL,42285,3025,2,5512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',33975.00,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5513,NULL,42285,3025,2,5513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9735.47,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5514,NULL,42285,3025,2,5514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2071.80,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5515,NULL,42285,3025,2,5515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4770.00,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5516,NULL,42285,3025,2,5516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1931.81,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5517,NULL,42285,3025,2,5517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2025.27,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5518,NULL,42285,3025,2,5518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2169.43,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01');
INSERT INTO `balance_libro` VALUES (5519,NULL,42285,3025,2,5519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6091.44,NULL,NULL,1,'2022-08-17 12:47:27','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5520,NULL,42285,3025,2,5520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3493.09,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5521,NULL,42285,3025,2,5521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4127.88,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5522,NULL,42285,3025,2,5522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1393.79,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5523,NULL,42285,3025,2,5523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3073.98,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5524,NULL,42285,3025,2,5524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4199.59,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5525,NULL,42285,3025,2,5525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3267.95,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5526,NULL,42285,3025,2,5526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7923.96,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5527,NULL,42285,3025,2,5527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7253.92,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5528,NULL,42285,3025,2,5528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2843.75,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5529,NULL,42285,3025,2,5529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5874.00,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5530,NULL,42285,3025,2,5530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2848.98,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5531,NULL,42285,3025,2,5531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1822.42,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5532,NULL,42285,3025,2,5532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1072.56,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5533,NULL,42285,3025,2,5533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6025.80,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5534,NULL,42285,3025,2,5534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5450.76,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5535,NULL,42285,3025,2,5535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2413.56,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5536,NULL,42285,3025,2,5536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5082.00,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5537,NULL,42285,3025,2,5537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3433.25,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5538,NULL,42285,3025,2,5538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1295.91,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5539,NULL,42285,3025,2,5539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5117.99,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5540,NULL,42285,3025,2,5540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3167.39,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01');
INSERT INTO `balance_libro` VALUES (5541,NULL,42285,3025,2,5541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3269.07,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5542,NULL,42285,3025,2,5542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2978.69,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5543,NULL,42285,3025,2,5543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4797.98,NULL,NULL,1,'2022-08-17 12:47:28','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5544,NULL,42285,3025,2,5544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3450.11,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5545,NULL,42285,3025,2,5545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1775.33,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5546,NULL,42285,3025,2,5546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',11074.50,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5547,NULL,42285,3025,2,5547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2507.16,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5548,NULL,42285,3025,2,5548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1725.47,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5549,NULL,42285,3025,2,5549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3108.99,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5550,NULL,42285,3025,2,5550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2347.97,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:01','2022-08-17 15:07:01'),(5551,NULL,42285,3025,2,5551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5735.09,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5552,NULL,42285,3025,2,5552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3855.48,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5553,NULL,42285,3025,2,5553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3758.98,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5554,NULL,42285,3025,2,5554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1113.68,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5555,NULL,42285,3025,2,5555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2166.10,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5556,NULL,42285,3025,2,5556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5143.27,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5557,NULL,42285,3025,2,5557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2242.97,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5558,NULL,42285,3025,2,5558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2611.08,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5559,NULL,42285,3025,2,5559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10191.08,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5560,NULL,42285,3025,2,5560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2397.38,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5561,NULL,42285,3025,2,5561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8827.54,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5562,NULL,42285,3025,2,5562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4219.98,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02');
INSERT INTO `balance_libro` VALUES (5563,NULL,42285,3025,2,5563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2401.18,NULL,NULL,1,'2022-08-17 12:47:29','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5564,NULL,42285,3025,2,5564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3108.99,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5565,NULL,42285,3025,2,5565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2486.19,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5566,NULL,42285,3025,2,5566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',11015.16,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5567,NULL,42285,3025,2,5567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4898.50,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5568,NULL,42285,3025,2,5568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1743.49,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5569,NULL,42285,3025,2,5569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10796.88,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5570,NULL,42285,3025,2,5570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4441.70,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5571,NULL,42285,3025,2,5571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3447.95,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5572,NULL,42285,3025,2,5572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4074.19,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5573,NULL,42285,3025,2,5573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3275.95,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5574,NULL,42285,3025,2,5574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3108.99,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5575,NULL,42285,3025,2,5575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3557.95,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5576,NULL,42285,3025,2,5576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',22769.42,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5577,NULL,42285,3025,2,5577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',14756.74,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5578,NULL,42285,3025,2,5578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4750.33,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5579,NULL,42285,3025,2,5579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6611.44,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5580,NULL,42285,3025,2,5580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1788.99,NULL,NULL,1,'2022-08-17 12:47:30','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5581,NULL,42285,3025,2,5581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2037.16,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5582,NULL,42285,3025,2,5582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',24426.00,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5583,NULL,42285,3025,2,5583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2201.91,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5584,NULL,42285,3025,2,5584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6083.37,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02');
INSERT INTO `balance_libro` VALUES (5585,NULL,42285,3025,2,5585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3001.03,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5586,NULL,42285,3025,2,5586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',11863.44,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5587,NULL,42285,3025,2,5587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2911.38,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5588,NULL,42285,3025,2,5588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3754.80,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5589,NULL,42285,3025,2,5589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1885.60,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5590,NULL,42285,3025,2,5590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5263.17,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5591,NULL,42285,3025,2,5591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4597.74,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5592,NULL,42285,3025,2,5592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1296.80,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5593,NULL,42285,3025,2,5593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7675.00,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5594,NULL,42285,3025,2,5594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1405.65,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5595,NULL,42285,3025,2,5595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',16729.25,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5596,NULL,42285,3025,2,5596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4211.90,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:02','2022-08-17 15:07:02'),(5597,NULL,42285,3025,2,5597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2287.96,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5598,NULL,42285,3025,2,5598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5293.19,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5599,NULL,42285,3025,2,5599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6099.48,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5600,NULL,42285,3025,2,5600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',57940.05,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5601,NULL,42285,3025,2,5601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8908.84,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5602,NULL,42285,3025,2,5602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',56278.40,NULL,NULL,1,'2022-08-17 12:47:31','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5603,NULL,42285,3025,2,5603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4992.52,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5604,NULL,42285,3025,2,5604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4774.46,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5605,NULL,42285,3025,2,5605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',12642.10,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5606,NULL,42285,3025,2,5606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6254.28,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03');
INSERT INTO `balance_libro` VALUES (5607,NULL,42285,3025,2,5607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',45960.90,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5608,NULL,42285,3025,2,5608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',18638.90,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5609,NULL,42285,3025,2,5609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1899.14,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5610,NULL,42285,3025,2,5610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',47765.16,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5611,NULL,42285,3025,2,5611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4358.67,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5612,NULL,42285,3025,2,5612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2789.48,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5613,NULL,42285,3025,2,5613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6951.18,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5614,NULL,42285,3025,2,5614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2781.48,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5615,NULL,42285,3025,2,5615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',15608.79,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5616,NULL,42285,3025,2,5616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2719.22,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5617,NULL,42285,3025,2,5617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1926.62,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5618,NULL,42285,3025,2,5618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6548.05,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5619,NULL,42285,3025,2,5619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4141.38,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5620,NULL,42285,3025,2,5620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2830.45,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5621,NULL,42285,3025,2,5621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1843.74,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5622,NULL,42285,3025,2,5622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5120.62,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5623,NULL,42285,3025,2,5623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1502.15,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5624,NULL,42285,3025,2,5624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2700.75,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5625,NULL,42285,3025,2,5625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4327.74,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5626,NULL,42285,3025,2,5626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',13527.80,NULL,NULL,1,'2022-08-17 12:47:32','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5627,NULL,42285,3025,2,5627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1512.68,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5628,NULL,42285,3025,2,5628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2049.13,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03');
INSERT INTO `balance_libro` VALUES (5629,NULL,42285,3025,2,5629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6959.10,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5630,NULL,42285,3025,2,5630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9761.60,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5631,NULL,42285,3025,2,5631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',14622.00,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5632,NULL,42285,3025,2,5632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',43598.00,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5633,NULL,42285,3025,2,5633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2863.45,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5634,NULL,42285,3025,2,5634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1577.10,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5635,NULL,42285,3025,2,5635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5303.91,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5636,NULL,42285,3025,2,5636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4025.99,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5637,NULL,42285,3025,2,5637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3770.46,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5638,NULL,42285,3025,2,5638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4548.70,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5639,NULL,42285,3025,2,5639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3553.21,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5640,NULL,42285,3025,2,5640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4418.08,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5641,NULL,42285,3025,2,5641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2299.01,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5642,NULL,42285,3025,2,5642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4797.98,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5643,NULL,42285,3025,2,5643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3233.98,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5644,NULL,42285,3025,2,5644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1408.10,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5645,NULL,42285,3025,2,5645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2188.18,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5646,NULL,42285,3025,2,5646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4530.38,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5647,NULL,42285,3025,2,5647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2495.00,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5648,NULL,42285,3025,2,5648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1489.47,NULL,NULL,1,'2022-08-17 12:47:33','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5649,NULL,42285,3025,2,5649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2173.10,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5650,NULL,42285,3025,2,5650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2736.48,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:03','2022-08-17 15:07:03');
INSERT INTO `balance_libro` VALUES (5651,NULL,42285,3025,2,5651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1721.60,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5652,NULL,42285,3025,2,5652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3901.68,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5653,NULL,42285,3025,2,5653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5748.07,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5654,NULL,42285,3025,2,5654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2922.68,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5655,NULL,42285,3025,2,5655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4531.69,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:03','2022-08-17 15:07:03'),(5656,NULL,42285,3025,2,5656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4750.33,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5657,NULL,42285,3025,2,5657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4070.71,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5658,NULL,42285,3025,2,5658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2448.38,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5659,NULL,42285,3025,2,5659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5159.45,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5660,NULL,42285,3025,2,5660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1885.60,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5661,NULL,42285,3025,2,5661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2288.56,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5662,NULL,42285,3025,2,5662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5126.32,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5663,NULL,42285,3025,2,5663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3204.17,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5664,NULL,42285,3025,2,5664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2961.82,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5665,NULL,42285,3025,2,5665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2527.68,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5666,NULL,42285,3025,2,5666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3731.68,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5667,NULL,42285,3025,2,5667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5674.65,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5668,NULL,42285,3025,2,5668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2802.68,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5669,NULL,42285,3025,2,5669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4770.00,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5670,NULL,42285,3025,2,5670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2401.18,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5671,NULL,42285,3025,2,5671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',33705.78,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5672,NULL,42285,3025,2,5672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',12570.18,NULL,NULL,1,'2022-08-17 12:47:34','2022-08-17 15:07:04','2022-08-17 15:07:04');
INSERT INTO `balance_libro` VALUES (5673,NULL,42285,3025,2,5673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',32145.99,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5674,NULL,42285,3025,2,5674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6409.64,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5675,NULL,42285,3025,2,5675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1197.90,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5676,NULL,42285,3025,2,5676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1797.69,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5677,NULL,42285,3025,2,5677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',14411.64,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5678,NULL,42285,3025,2,5678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5950.91,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5679,NULL,42285,3025,2,5679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5216.00,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5680,NULL,42285,3025,2,5680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3192.95,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5681,NULL,42285,3025,2,5681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1699.77,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5682,NULL,42285,3025,2,5682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4660.84,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5683,NULL,42285,3025,2,5683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10304.84,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5684,NULL,42285,3025,2,5684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2204.07,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5685,NULL,42285,3025,2,5685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2802.68,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5686,NULL,42285,3025,2,5686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2401.18,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5687,NULL,42285,3025,2,5687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1734.33,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5688,NULL,42285,3025,2,5688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9248.69,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5689,NULL,42285,3025,2,5689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10191.08,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5690,NULL,42285,3025,2,5690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1391.61,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5691,NULL,42285,3025,2,5691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2180.18,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5692,NULL,42285,3025,2,5692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5117.99,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5693,NULL,42285,3025,2,5693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2391.14,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5694,NULL,42285,3025,2,5694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5325.86,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04');
INSERT INTO `balance_libro` VALUES (5695,NULL,42285,3025,2,5695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4840.87,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5696,NULL,42285,3025,2,5696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2848.98,NULL,NULL,1,'2022-08-17 12:47:35','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5697,NULL,42285,3025,2,5697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2492.96,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5698,NULL,42285,3025,2,5698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8698.69,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5699,NULL,42285,3025,2,5699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1497.46,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5700,NULL,42285,3025,2,5700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4851.19,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5701,NULL,42285,3025,2,5701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',13053.31,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5702,NULL,42285,3025,2,5702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9248.69,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5703,NULL,42285,3025,2,5703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5251.40,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5704,NULL,42285,3025,2,5704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1645.09,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5705,NULL,42285,3025,2,5705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5159.45,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5706,NULL,42285,3025,2,5706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4030.96,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5707,NULL,42285,3025,2,5707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2259.18,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5708,NULL,42285,3025,2,5708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3896.00,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5709,NULL,42285,3025,2,5709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1242.95,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5710,NULL,42285,3025,2,5710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8789.44,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5711,NULL,42285,3025,2,5711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2740.45,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5712,NULL,42285,3025,2,5712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1797.69,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5713,NULL,42285,3025,2,5713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1800.60,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5714,NULL,42285,3025,2,5714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2379.41,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5715,NULL,42285,3025,2,5715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3016.49,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:04','2022-08-17 15:07:04'),(5716,NULL,42285,3025,2,5716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10381.60,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:05','2022-08-17 15:07:04');
INSERT INTO `balance_libro` VALUES (5717,NULL,42285,3025,2,5717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2857.46,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5718,NULL,42285,3025,2,5718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4030.35,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5719,NULL,42285,3025,2,5719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5254.22,NULL,NULL,1,'2022-08-17 12:47:36','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5720,NULL,42285,3025,2,5720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3986.68,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5721,NULL,42285,3025,2,5721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2732.35,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5722,NULL,42285,3025,2,5722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5027.10,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5723,NULL,42285,3025,2,5723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3108.99,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5724,NULL,42285,3025,2,5724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2860.48,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5725,NULL,42285,3025,2,5725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1612.02,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5726,NULL,42285,3025,2,5726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6354.70,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5727,NULL,42285,3025,2,5727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3651.18,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5728,NULL,42285,3025,2,5728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2673.20,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5729,NULL,42285,3025,2,5729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',60644.99,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5730,NULL,42285,3025,2,5730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2789.48,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5731,NULL,42285,3025,2,5731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1753.49,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5732,NULL,42285,3025,2,5732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4127.74,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5733,NULL,42285,3025,2,5733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1399.49,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5734,NULL,42285,3025,2,5734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4591.05,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5735,NULL,42285,3025,2,5735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2641.14,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5736,NULL,42285,3025,2,5736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',13869.23,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5737,NULL,42285,3025,2,5737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4280.20,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5738,NULL,42285,3025,2,5738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6125.44,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05');
INSERT INTO `balance_libro` VALUES (5739,NULL,42285,3025,2,5739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1631.17,NULL,NULL,1,'2022-08-17 12:47:37','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5740,NULL,42285,3025,2,5740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5104.40,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5741,NULL,42285,3025,2,5741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1831.62,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5742,NULL,42285,3025,2,5742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',11001.08,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5743,NULL,42285,3025,2,5743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4750.33,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5744,NULL,42285,3025,2,5744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5996.76,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5745,NULL,42285,3025,2,5745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1725.47,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5746,NULL,42285,3025,2,5746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3353.98,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5747,NULL,42285,3025,2,5747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3098.98,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5748,NULL,42285,3025,2,5748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5675.84,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5749,NULL,42285,3025,2,5749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',49911.36,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5750,NULL,42285,3025,2,5750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2912.68,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5751,NULL,42285,3025,2,5751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1577.10,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5752,NULL,42285,3025,2,5752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',11827.67,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5753,NULL,42285,3025,2,5753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3816.42,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5754,NULL,42285,3025,2,5754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1803.49,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5755,NULL,42285,3025,2,5755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2983.29,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5756,NULL,42285,3025,2,5756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6249.72,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5757,NULL,42285,3025,2,5757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3751.68,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5758,NULL,42285,3025,2,5758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2186.72,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5759,NULL,42285,3025,2,5759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5528.98,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5760,NULL,42285,3025,2,5760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5082.00,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05');
INSERT INTO `balance_libro` VALUES (5761,NULL,42285,3025,2,5761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5019.54,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5762,NULL,42285,3025,2,5762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2180.18,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5763,NULL,42285,3025,2,5763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6910.00,NULL,NULL,1,'2022-08-17 12:47:38','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5764,NULL,42285,3025,2,5764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7117.81,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5765,NULL,42285,3025,2,5765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6465.33,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5766,NULL,42285,3025,2,5766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2946.18,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5767,NULL,42285,3025,2,5767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3088.98,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5768,NULL,42285,3025,2,5768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1797.69,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5769,NULL,42285,3025,2,5769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6426.16,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5770,NULL,42285,3025,2,5770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9982.04,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5771,NULL,42285,3025,2,5771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',49911.36,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5772,NULL,42285,3025,2,5772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2339.53,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5773,NULL,42285,3025,2,5773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1440.77,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5774,NULL,42285,3025,2,5774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1550.46,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5775,NULL,42285,3025,2,5775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2891.97,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5776,NULL,42285,3025,2,5776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1608.99,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5777,NULL,42285,3025,2,5777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1963.28,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5778,NULL,42285,3025,2,5778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',15507.75,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5779,NULL,42285,3025,2,5779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6817.58,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5780,NULL,42285,3025,2,5780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',17202.00,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5781,NULL,42285,3025,2,5781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3200.62,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5782,NULL,42285,3025,2,5782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',12025.17,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05');
INSERT INTO `balance_libro` VALUES (5783,NULL,42285,3025,2,5783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1575.34,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5784,NULL,42285,3025,2,5784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3598.21,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5785,NULL,42285,3025,2,5785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4028.94,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5786,NULL,42285,3025,2,5786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2488.45,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5787,NULL,42285,3025,2,5787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4216.30,NULL,NULL,1,'2022-08-17 12:47:39','2022-08-17 15:07:05','2022-08-17 15:07:05'),(5788,NULL,42285,3025,2,5788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',11182.20,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5789,NULL,42285,3025,2,5789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4559.31,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5790,NULL,42285,3025,2,5790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7395.04,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5791,NULL,42285,3025,2,5791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2129.52,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5792,NULL,42285,3025,2,5792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2259.76,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5793,NULL,42285,3025,2,5793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1379.84,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5794,NULL,42285,3025,2,5794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',8060.84,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5795,NULL,42285,3025,2,5795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',17911.92,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5796,NULL,42285,3025,2,5796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4133.02,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5797,NULL,42285,3025,2,5797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',716.32,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5798,NULL,42285,3025,2,5798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6231.22,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5799,NULL,42285,3025,2,5799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',10121.82,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5800,NULL,42285,3025,2,5800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2597.47,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5801,NULL,42285,3025,2,5801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2756.46,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5802,NULL,42285,3025,2,5802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4414.98,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5803,NULL,42285,3025,2,5803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3359.80,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5804,NULL,42285,3025,2,5804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2877.08,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06');
INSERT INTO `balance_libro` VALUES (5805,NULL,42285,3025,2,5805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',34423.47,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5806,NULL,42285,3025,2,5806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4197.40,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5807,NULL,42285,3025,2,5807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3722.61,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5808,NULL,42285,3025,2,5808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3234.78,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5809,NULL,42285,3025,2,5809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',13527.80,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5810,NULL,42285,3025,2,5810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3559.50,NULL,NULL,1,'2022-08-17 12:47:40','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5811,NULL,42285,3025,2,5811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3859.17,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5812,NULL,42285,3025,2,5812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1224.49,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5813,NULL,42285,3025,2,5813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2401.18,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5814,NULL,42285,3025,2,5814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9735.47,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5815,NULL,42285,3025,2,5815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6821.86,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5816,NULL,42285,3025,2,5816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',18838.57,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5817,NULL,42285,3025,2,5817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1763.87,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5818,NULL,42285,3025,2,5818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',8702.32,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5819,NULL,42285,3025,2,5819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2425.41,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5820,NULL,42285,3025,2,5820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5217.50,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5821,NULL,42285,3025,2,5821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1550.10,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5822,NULL,42285,3025,2,5822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5117.99,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5823,NULL,42285,3025,2,5823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1469.51,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5824,NULL,42285,3025,2,5824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4615.20,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5825,NULL,42285,3025,2,5825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5448.44,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5826,NULL,42285,3025,2,5826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1496.61,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06');
INSERT INTO `balance_libro` VALUES (5827,NULL,42285,3025,2,5827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3983.46,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5828,NULL,42285,3025,2,5828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4548.24,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5829,NULL,42285,3025,2,5829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2992.25,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5830,NULL,42285,3025,2,5830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',15543.13,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5831,NULL,42285,3025,2,5831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5043.41,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5832,NULL,42285,3025,2,5832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1831.61,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5833,NULL,42285,3025,2,5833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2547.01,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5834,NULL,42285,3025,2,5834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2398.99,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5835,NULL,42285,3025,2,5835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',13869.23,NULL,NULL,1,'2022-08-17 12:47:41','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5836,NULL,42285,3025,2,5836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4174.64,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5837,NULL,42285,3025,2,5837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7996.02,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5838,NULL,42285,3025,2,5838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7599.51,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5839,NULL,42285,3025,2,5839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3352.95,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5840,NULL,42285,3025,2,5840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4773.55,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5841,NULL,42285,3025,2,5841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3002.48,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5842,NULL,42285,3025,2,5842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3082.79,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5843,NULL,42285,3025,2,5843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3298.62,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5844,NULL,42285,3025,2,5844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6354.70,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5845,NULL,42285,3025,2,5845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2004.01,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5846,NULL,42285,3025,2,5846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2583.79,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5847,NULL,42285,3025,2,5847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1941.51,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5848,NULL,42285,3025,2,5848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6589.00,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06');
INSERT INTO `balance_libro` VALUES (5849,NULL,42285,3025,2,5849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1735.37,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5850,NULL,42285,3025,2,5850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2085.12,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5851,NULL,42285,3025,2,5851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3418.87,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5852,NULL,42285,3025,2,5852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2721.88,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5853,NULL,42285,3025,2,5853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6466.53,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5854,NULL,42285,3025,2,5854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1688.99,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5855,NULL,42285,3025,2,5855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7504.51,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5856,NULL,42285,3025,2,5856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',11801.49,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5857,NULL,42285,3025,2,5857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1797.69,NULL,NULL,1,'2022-08-17 12:47:42','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5858,NULL,42285,3025,2,5858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',21799.00,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5859,NULL,42285,3025,2,5859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4794.34,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:06','2022-08-17 15:07:06'),(5860,NULL,42285,3025,2,5860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3258.98,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5861,NULL,42285,3025,2,5861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1963.92,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5862,NULL,42285,3025,2,5862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1785.01,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5863,NULL,42285,3025,2,5863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1343.82,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5864,NULL,42285,3025,2,5864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4084.99,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5865,NULL,42285,3025,2,5865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1270.22,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5866,NULL,42285,3025,2,5866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1226.63,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5867,NULL,42285,3025,2,5867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3766.97,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5868,NULL,42285,3025,2,5868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7723.98,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5869,NULL,42285,3025,2,5869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3108.99,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5870,NULL,42285,3025,2,5870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',10963.83,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07');
INSERT INTO `balance_libro` VALUES (5871,NULL,42285,3025,2,5871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9735.47,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5872,NULL,42285,3025,2,5872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1969.32,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5873,NULL,42285,3025,2,5873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1645.76,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5874,NULL,42285,3025,2,5874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1746.05,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5875,NULL,42285,3025,2,5875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3775.48,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5876,NULL,42285,3025,2,5876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9595.96,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5877,NULL,42285,3025,2,5877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',53583.81,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5878,NULL,42285,3025,2,5878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3813.31,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5879,NULL,42285,3025,2,5879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4962.14,NULL,NULL,1,'2022-08-17 12:47:43','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5880,NULL,42285,3025,2,5880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2284.18,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5881,NULL,42285,3025,2,5881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2327.91,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5882,NULL,42285,3025,2,5882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2177.19,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5883,NULL,42285,3025,2,5883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6992.28,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5884,NULL,42285,3025,2,5884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',15329.86,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5885,NULL,42285,3025,2,5885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',28532.50,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5886,NULL,42285,3025,2,5886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1780.64,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5887,NULL,42285,3025,2,5887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3002.48,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5888,NULL,42285,3025,2,5888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5019.54,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5889,NULL,42285,3025,2,5889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2221.40,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5890,NULL,42285,3025,2,5890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2065.60,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5891,NULL,42285,3025,2,5891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6083.38,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5892,NULL,42285,3025,2,5892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2848.98,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07');
INSERT INTO `balance_libro` VALUES (5893,NULL,42285,3025,2,5893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6844.88,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5894,NULL,42285,3025,2,5894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2014.34,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5895,NULL,42285,3025,2,5895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2492.97,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5896,NULL,42285,3025,2,5896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2976.97,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5897,NULL,42285,3025,2,5897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4232.49,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5898,NULL,42285,3025,2,5898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1478.06,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5899,NULL,42285,3025,2,5899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1686.45,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5900,NULL,42285,3025,2,5900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3131.32,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5901,NULL,42285,3025,2,5901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4477.26,NULL,NULL,1,'2022-08-17 12:47:44','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5902,NULL,42285,3025,2,5902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1719.10,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5903,NULL,42285,3025,2,5903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3279.07,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5904,NULL,42285,3025,2,5904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1453.10,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5905,NULL,42285,3025,2,5905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2360.23,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5906,NULL,42285,3025,2,5906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1609.12,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5907,NULL,42285,3025,2,5907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',11572.60,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5908,NULL,42285,3025,2,5908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2373.23,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5909,NULL,42285,3025,2,5909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2481.62,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5910,NULL,42285,3025,2,5910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2156.40,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5911,NULL,42285,3025,2,5911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1226.63,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5912,NULL,42285,3025,2,5912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1718.77,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5913,NULL,42285,3025,2,5913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2961.88,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5914,NULL,42285,3025,2,5914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5956.00,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07');
INSERT INTO `balance_libro` VALUES (5915,NULL,42285,3025,2,5915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',13453.71,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5916,NULL,42285,3025,2,5916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5910.90,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5917,NULL,42285,3025,2,5917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3437.68,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5918,NULL,42285,3025,2,5918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2146.47,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5919,NULL,42285,3025,2,5919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3344.48,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5920,NULL,42285,3025,2,5920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3408.08,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:07','2022-08-17 15:07:07'),(5921,NULL,42285,3025,2,5921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3598.24,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5922,NULL,42285,3025,2,5922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4596.36,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5923,NULL,42285,3025,2,5923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6426.16,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5924,NULL,42285,3025,2,5924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5069.34,NULL,NULL,1,'2022-08-17 12:47:45','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5925,NULL,42285,3025,2,5925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3874.10,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5926,NULL,42285,3025,2,5926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1931.35,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5927,NULL,42285,3025,2,5927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3342.49,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5928,NULL,42285,3025,2,5928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7650.35,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5929,NULL,42285,3025,2,5929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6105.92,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5930,NULL,42285,3025,2,5930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1723.95,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5931,NULL,42285,3025,2,5931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4246.83,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5932,NULL,42285,3025,2,5932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4595.11,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5933,NULL,42285,3025,2,5933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1254.66,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5934,NULL,42285,3025,2,5934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5261.57,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5935,NULL,42285,3025,2,5935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2228.73,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5936,NULL,42285,3025,2,5936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5120.62,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08');
INSERT INTO `balance_libro` VALUES (5937,NULL,42285,3025,2,5937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4117.10,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5938,NULL,42285,3025,2,5938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5222.36,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5939,NULL,42285,3025,2,5939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1878.49,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5940,NULL,42285,3025,2,5940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1653.61,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5941,NULL,42285,3025,2,5941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2970.28,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5942,NULL,42285,3025,2,5942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3157.89,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5943,NULL,42285,3025,2,5943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5145.53,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5944,NULL,42285,3025,2,5944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2527.68,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5945,NULL,42285,3025,2,5945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3902.95,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5946,NULL,42285,3025,2,5946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9282.60,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5947,NULL,42285,3025,2,5947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3883.58,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5948,NULL,42285,3025,2,5948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3096.45,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5949,NULL,42285,3025,2,5949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5617.40,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5950,NULL,42285,3025,2,5950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5263.17,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5951,NULL,42285,3025,2,5951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4030.96,NULL,NULL,1,'2022-08-17 12:47:46','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5952,NULL,42285,3025,2,5952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1916.72,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5953,NULL,42285,3025,2,5953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3991.81,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5954,NULL,42285,3025,2,5954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1500.27,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5955,NULL,42285,3025,2,5955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2453.54,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5956,NULL,42285,3025,2,5956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1082.17,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5957,NULL,42285,3025,2,5957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4710.37,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5958,NULL,42285,3025,2,5958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',23582.11,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08');
INSERT INTO `balance_libro` VALUES (5959,NULL,42285,3025,2,5959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6921.75,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5960,NULL,42285,3025,2,5960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6503.04,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5961,NULL,42285,3025,2,5961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1218.26,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5962,NULL,42285,3025,2,5962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2297.97,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5963,NULL,42285,3025,2,5963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3337.39,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5964,NULL,42285,3025,2,5964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1635.59,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5965,NULL,42285,3025,2,5965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5419.20,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5966,NULL,42285,3025,2,5966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2605.73,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5967,NULL,42285,3025,2,5967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5120.62,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5968,NULL,42285,3025,2,5968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9501.79,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5969,NULL,42285,3025,2,5969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1650.80,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5970,NULL,42285,3025,2,5970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2978.98,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5971,NULL,42285,3025,2,5971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3821.81,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5972,NULL,42285,3025,2,5972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1087.00,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5973,NULL,42285,3025,2,5973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6611.44,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5974,NULL,42285,3025,2,5974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1921.61,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5975,NULL,42285,3025,2,5975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3233.98,NULL,NULL,1,'2022-08-17 12:47:47','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5976,NULL,42285,3025,2,5976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7055.80,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5977,NULL,42285,3025,2,5977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3858.63,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5978,NULL,42285,3025,2,5978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2104.13,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:08','2022-08-17 15:07:08'),(5979,NULL,42285,3025,2,5979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9840.90,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5980,NULL,42285,3025,2,5980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1642.78,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09');
INSERT INTO `balance_libro` VALUES (5981,NULL,42285,3025,2,5981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3115.66,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5982,NULL,42285,3025,2,5982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2655.67,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5983,NULL,42285,3025,2,5983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2632.68,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5984,NULL,42285,3025,2,5984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',81721.78,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5985,NULL,42285,3025,2,5985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',8643.07,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5986,NULL,42285,3025,2,5986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2323.64,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5987,NULL,42285,3025,2,5987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4365.58,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5988,NULL,42285,3025,2,5988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2527.68,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5989,NULL,42285,3025,2,5989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3353.98,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5990,NULL,42285,3025,2,5990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',13970.00,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5991,NULL,42285,3025,2,5991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4035.49,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5992,NULL,42285,3025,2,5992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',4963.33,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5993,NULL,42285,3025,2,5993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',10813.95,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5994,NULL,42285,3025,2,5994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1645.15,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5995,NULL,42285,3025,2,5995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',7015.43,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5996,NULL,42285,3025,2,5996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',10819.12,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5997,NULL,42285,3025,2,5997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3598.21,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5998,NULL,42285,3025,2,5998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1461.68,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(5999,NULL,42285,3025,2,5999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5112.31,NULL,NULL,1,'2022-08-17 12:47:48','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6000,NULL,42285,3025,2,6000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5699.45,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6001,NULL,42285,3025,2,6001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',21799.00,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6002,NULL,42285,3025,2,6002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3727.99,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09');
INSERT INTO `balance_libro` VALUES (6003,NULL,42285,3025,2,6003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2632.68,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6004,NULL,42285,3025,2,6004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2040.57,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6005,NULL,42285,3025,2,6005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3182.95,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6006,NULL,42285,3025,2,6006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5377.99,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6007,NULL,42285,3025,2,6007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3526.38,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6008,NULL,42285,3025,2,6008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1251.01,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6009,NULL,42285,3025,2,6009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2630.79,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6010,NULL,42285,3025,2,6010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',60491.07,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6011,NULL,42285,3025,2,6011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2736.48,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6012,NULL,42285,3025,2,6012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2912.68,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6013,NULL,42285,3025,2,6013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',11358.26,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6014,NULL,42285,3025,2,6014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',5705.86,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6015,NULL,42285,3025,2,6015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2262.29,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6016,NULL,42285,3025,2,6016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',9735.47,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6017,NULL,42285,3025,2,6017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',10415.29,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6018,NULL,42285,3025,2,6018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3598.21,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6019,NULL,42285,3025,2,6019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1147.14,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6020,NULL,42285,3025,2,6020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',140289.17,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6021,NULL,42285,3025,2,6021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',6410.00,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6022,NULL,42285,3025,2,6022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1365.11,NULL,NULL,1,'2022-08-17 12:47:49','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6023,NULL,42285,3025,2,6023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1528.23,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6024,NULL,42285,3025,2,6024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',804.05,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09');
INSERT INTO `balance_libro` VALUES (6025,NULL,42285,3025,2,6025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9696.64,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6026,NULL,42285,3025,2,6026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',8381.67,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6027,NULL,42285,3025,2,6027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1028.15,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6028,NULL,42285,3025,2,6028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',10071.89,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6029,NULL,42285,3025,2,6029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6556.76,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6030,NULL,42285,3025,2,6030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',11257.76,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6031,NULL,42285,3025,2,6031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2326.35,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6032,NULL,42285,3025,2,6032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5740.30,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6033,NULL,42285,3025,2,6033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',16088.67,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6034,NULL,42285,3025,2,6034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9342.14,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6035,NULL,42285,3025,2,6035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7798.64,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6036,NULL,42285,3025,2,6036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5246.44,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6037,NULL,42285,3025,2,6037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',8561.36,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6038,NULL,42285,3025,2,6038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',870.47,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6039,NULL,42285,3025,2,6039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3083.43,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6040,NULL,42285,3025,2,6040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6581.85,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6041,NULL,42285,3025,2,6041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1364.21,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6042,NULL,42285,3025,2,6042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',8561.36,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:09','2022-08-17 15:07:09'),(6043,NULL,42285,3025,2,6043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',11661.96,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6044,NULL,42285,3025,2,6044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',20016.59,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6045,NULL,42285,3025,2,6045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1312.93,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6046,NULL,42285,3025,2,6046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',27710.52,NULL,NULL,1,'2022-08-17 12:47:50','2022-08-17 15:07:10','2022-08-17 15:07:10');
INSERT INTO `balance_libro` VALUES (6047,NULL,42285,3025,2,6047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3014.35,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6048,NULL,42285,3025,2,6048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2492.54,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6049,NULL,42285,3025,2,6049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5095.54,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6050,NULL,42285,3025,2,6050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3129.74,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6051,NULL,42285,3025,2,6051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1547.15,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6052,NULL,42285,3025,2,6052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1144.31,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6053,NULL,42285,3025,2,6053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1969.34,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6054,NULL,42285,3025,2,6054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5399.02,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6055,NULL,42285,3025,2,6055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4414.98,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6056,NULL,42285,3025,2,6056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4797.98,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6057,NULL,42285,3025,2,6057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4750.33,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6058,NULL,42285,3025,2,6058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5243.80,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6059,NULL,42285,3025,2,6059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5243.80,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6060,NULL,42285,3025,2,6060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2869.39,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6061,NULL,42285,3025,2,6061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2801.93,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6062,NULL,42285,3025,2,6062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3053.99,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6063,NULL,42285,3025,2,6063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3841.46,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6064,NULL,42285,3025,2,6064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4029.96,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6065,NULL,42285,3025,2,6065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3598.21,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6066,NULL,42285,3025,2,6066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1294.90,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6067,NULL,42285,3025,2,6067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1578.77,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6068,NULL,42285,3025,2,6068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5748.07,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10');
INSERT INTO `balance_libro` VALUES (6069,NULL,42285,3025,2,6069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7196.97,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6070,NULL,42285,3025,2,6070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6690.00,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6071,NULL,42285,3025,2,6071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3002.48,NULL,NULL,1,'2022-08-17 12:47:51','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6072,NULL,42285,3025,2,6072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',14196.93,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6073,NULL,42285,3025,2,6073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',25854.75,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6074,NULL,42285,3025,2,6074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7854.50,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6075,NULL,42285,3025,2,6075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',115166.19,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6076,NULL,42285,3025,2,6076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5031.18,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6077,NULL,42285,3025,2,6077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2129.96,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6078,NULL,42285,3025,2,6078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3983.46,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6079,NULL,42285,3025,2,6079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',13527.80,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6080,NULL,42285,3025,2,6080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1786.06,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6081,NULL,42285,3025,2,6081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2413.47,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6082,NULL,42285,3025,2,6082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1838.82,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6083,NULL,42285,3025,2,6083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3696.21,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6084,NULL,42285,3025,2,6084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1115.61,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6085,NULL,42285,3025,2,6085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3035.95,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6086,NULL,42285,3025,2,6086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2889.60,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6087,NULL,42285,3025,2,6087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7177.87,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6088,NULL,42285,3025,2,6088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1721.99,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6089,NULL,42285,3025,2,6089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9888.16,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6090,NULL,42285,3025,2,6090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',21799.00,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10');
INSERT INTO `balance_libro` VALUES (6091,NULL,42285,3025,2,6091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2180.18,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6092,NULL,42285,3025,2,6092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5303.91,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6093,NULL,42285,3025,2,6093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3653.46,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6094,NULL,42285,3025,2,6094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3304.75,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6095,NULL,42285,3025,2,6095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1504.34,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6096,NULL,42285,3025,2,6096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2697.68,NULL,NULL,1,'2022-08-17 12:47:52','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6097,NULL,42285,3025,2,6097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1952.32,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6098,NULL,42285,3025,2,6098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2613.90,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6099,NULL,42285,3025,2,6099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3334.18,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6100,NULL,42285,3025,2,6100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4213.28,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6101,NULL,42285,3025,2,6101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5625.11,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:10','2022-08-17 15:07:10'),(6102,NULL,42285,3025,2,6102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1628.52,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6103,NULL,42285,3025,2,6103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4091.20,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6104,NULL,42285,3025,2,6104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1725.60,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6105,NULL,42285,3025,2,6105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',15115.60,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6106,NULL,42285,3025,2,6106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6961.44,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6107,NULL,42285,3025,2,6107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5021.12,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6108,NULL,42285,3025,2,6108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1952.32,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6109,NULL,42285,3025,2,6109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1498.10,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6110,NULL,42285,3025,2,6110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5095.54,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6111,NULL,42285,3025,2,6111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2401.18,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6112,NULL,42285,3025,2,6112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5221.08,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11');
INSERT INTO `balance_libro` VALUES (6113,NULL,42285,3025,2,6113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1015.29,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6114,NULL,42285,3025,2,6114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2259.18,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6115,NULL,42285,3025,2,6115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4793.87,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6116,NULL,42285,3025,2,6116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3352.95,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6117,NULL,42285,3025,2,6117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1385.80,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6118,NULL,42285,3025,2,6118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3621.89,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6119,NULL,42285,3025,2,6119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6253.17,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6120,NULL,42285,3025,2,6120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3437.68,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6121,NULL,42285,3025,2,6121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1498.10,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6122,NULL,42285,3025,2,6122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2848.98,NULL,NULL,1,'2022-08-17 12:47:53','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6123,NULL,42285,3025,2,6123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1800.60,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6124,NULL,42285,3025,2,6124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2632.68,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6125,NULL,42285,3025,2,6125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4267.05,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6126,NULL,42285,3025,2,6126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',10304.84,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6127,NULL,42285,3025,2,6127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2781.48,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6128,NULL,42285,3025,2,6128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4985.93,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6129,NULL,42285,3025,2,6129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4102.18,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6130,NULL,42285,3025,2,6130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3211.64,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6131,NULL,42285,3025,2,6131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1094.19,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6132,NULL,42285,3025,2,6132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1769.96,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6133,NULL,42285,3025,2,6133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1697.85,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6134,NULL,42285,3025,2,6134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1630.35,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11');
INSERT INTO `balance_libro` VALUES (6135,NULL,42285,3025,2,6135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2964.34,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6136,NULL,42285,3025,2,6136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3910.71,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6137,NULL,42285,3025,2,6137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5019.54,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6138,NULL,42285,3025,2,6138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1564.12,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6139,NULL,42285,3025,2,6139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2180.18,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6140,NULL,42285,3025,2,6140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2547.68,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6141,NULL,42285,3025,2,6141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3762.46,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6142,NULL,42285,3025,2,6142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1425.99,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6143,NULL,42285,3025,2,6143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',10994.63,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6144,NULL,42285,3025,2,6144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2877.08,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6145,NULL,42285,3025,2,6145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',24063.50,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6146,NULL,42285,3025,2,6146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5305.29,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6147,NULL,42285,3025,2,6147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6361.27,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6148,NULL,42285,3025,2,6148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7925.00,NULL,NULL,1,'2022-08-17 12:47:54','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6149,NULL,42285,3025,2,6149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3043.98,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6150,NULL,42285,3025,2,6150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3352.95,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6151,NULL,42285,3025,2,6151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',24426.00,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6152,NULL,42285,3025,2,6152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3739.49,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6153,NULL,42285,3025,2,6153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',15843.64,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6154,NULL,42285,3025,2,6154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2922.68,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6155,NULL,42285,3025,2,6155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1496.83,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:11','2022-08-17 15:07:11'),(6156,NULL,42285,3025,2,6156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1843.52,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:11','2022-08-17 15:07:11');
INSERT INTO `balance_libro` VALUES (6157,NULL,42285,3025,2,6157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',10191.08,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6158,NULL,42285,3025,2,6158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3523.98,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6159,NULL,42285,3025,2,6159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1753.49,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6160,NULL,42285,3025,2,6160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2402.64,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6161,NULL,42285,3025,2,6161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4675.76,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6162,NULL,42285,3025,2,6162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3096.97,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6163,NULL,42285,3025,2,6163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5095.54,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6164,NULL,42285,3025,2,6164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',8215.20,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6165,NULL,42285,3025,2,6165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2978.98,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6166,NULL,42285,3025,2,6166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2978.98,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6167,NULL,42285,3025,2,6167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4797.98,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6168,NULL,42285,3025,2,6168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5251.40,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6169,NULL,42285,3025,2,6169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4117.10,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6170,NULL,42285,3025,2,6170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',11489.47,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6171,NULL,42285,3025,2,6171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1871.32,NULL,NULL,1,'2022-08-17 12:47:55','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6172,NULL,42285,3025,2,6172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6313.55,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6173,NULL,42285,3025,2,6173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2752.68,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6174,NULL,42285,3025,2,6174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2781.48,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6175,NULL,42285,3025,2,6175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2752.68,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6176,NULL,42285,3025,2,6176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2386.47,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6177,NULL,42285,3025,2,6177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6658.55,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6178,NULL,42285,3025,2,6178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2636.40,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12');
INSERT INTO `balance_libro` VALUES (6179,NULL,42285,3025,2,6179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2687.69,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6180,NULL,42285,3025,2,6180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1674.12,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6181,NULL,42285,3025,2,6181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3258.98,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6182,NULL,42285,3025,2,6182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9501.79,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6183,NULL,42285,3025,2,6183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9501.79,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6184,NULL,42285,3025,2,6184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5095.54,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6185,NULL,42285,3025,2,6185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5432.62,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6186,NULL,42285,3025,2,6186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2677.68,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6187,NULL,42285,3025,2,6187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2814.41,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6188,NULL,42285,3025,2,6188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2740.45,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6189,NULL,42285,3025,2,6189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9982.04,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6190,NULL,42285,3025,2,6190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1196.07,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6191,NULL,42285,3025,2,6191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',13411.13,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6192,NULL,42285,3025,2,6192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4112.82,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6193,NULL,42285,3025,2,6193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3297.95,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6194,NULL,42285,3025,2,6194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1536.85,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6195,NULL,42285,3025,2,6195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5100.29,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6196,NULL,42285,3025,2,6196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3915.75,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6197,NULL,42285,3025,2,6197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2578.49,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6198,NULL,42285,3025,2,6198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7240.38,NULL,NULL,1,'2022-08-17 12:47:56','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6199,NULL,42285,3025,2,6199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',46693.50,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6200,NULL,42285,3025,2,6200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6645.90,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12');
INSERT INTO `balance_libro` VALUES (6201,NULL,42285,3025,2,6201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6037.95,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6202,NULL,42285,3025,2,6202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2931.48,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6203,NULL,42285,3025,2,6203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4349.95,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6204,NULL,42285,3025,2,6204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1115.61,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6205,NULL,42285,3025,2,6205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4552.69,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6206,NULL,42285,3025,2,6206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5420.28,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6207,NULL,42285,3025,2,6207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4770.00,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:12','2022-08-17 15:07:12'),(6208,NULL,42285,3025,2,6208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1461.55,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6209,NULL,42285,3025,2,6209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1453.10,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6210,NULL,42285,3025,2,6210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2667.68,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6211,NULL,42285,3025,2,6211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3167.58,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6212,NULL,42285,3025,2,6212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4810.25,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6213,NULL,42285,3025,2,6213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1797.69,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6214,NULL,42285,3025,2,6214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2398.99,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6215,NULL,42285,3025,2,6215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9735.47,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6216,NULL,42285,3025,2,6216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4331.68,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6217,NULL,42285,3025,2,6217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3059.26,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6218,NULL,42285,3025,2,6218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2521.08,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6219,NULL,42285,3025,2,6219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2669.41,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6220,NULL,42285,3025,2,6220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',12691.98,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6221,NULL,42285,3025,2,6221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3019.14,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6222,NULL,42285,3025,2,6222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1932.84,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13');
INSERT INTO `balance_libro` VALUES (6223,NULL,42285,3025,2,6223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',13668.44,NULL,NULL,1,'2022-08-17 12:47:57','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6224,NULL,42285,3025,2,6224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',46594.62,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6225,NULL,42285,3025,2,6225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2330.18,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6226,NULL,42285,3025,2,6226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4547.18,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6227,NULL,42285,3025,2,6227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3751.27,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6228,NULL,42285,3025,2,6228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4076.81,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6229,NULL,42285,3025,2,6229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',13527.80,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6230,NULL,42285,3025,2,6230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5168.54,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6231,NULL,42285,3025,2,6231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',12388.83,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6232,NULL,42285,3025,2,6232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',36208.43,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6233,NULL,42285,3025,2,6233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',26658.72,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6234,NULL,42285,3025,2,6234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',156989.43,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6235,NULL,42285,3025,2,6235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4365.11,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6236,NULL,42285,3025,2,6236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',11631.02,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6237,NULL,42285,3025,2,6237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5568.94,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6238,NULL,42285,3025,2,6238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2781.48,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6239,NULL,42285,3025,2,6239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2091.67,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6240,NULL,42285,3025,2,6240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2492.96,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6241,NULL,42285,3025,2,6241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2572.68,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6242,NULL,42285,3025,2,6242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6298.95,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6243,NULL,42285,3025,2,6243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2680.61,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6244,NULL,42285,3025,2,6244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4879.49,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13');
INSERT INTO `balance_libro` VALUES (6245,NULL,42285,3025,2,6245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2330.18,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6246,NULL,42285,3025,2,6246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',12413.90,NULL,NULL,1,'2022-08-17 12:47:58','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6247,NULL,42285,3025,2,6247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9735.47,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6248,NULL,42285,3025,2,6248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9735.47,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6249,NULL,42285,3025,2,6249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6732.82,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6250,NULL,42285,3025,2,6250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3029.99,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6251,NULL,42285,3025,2,6251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2114.90,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6252,NULL,42285,3025,2,6252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2135.71,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6253,NULL,42285,3025,2,6253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2106.32,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6254,NULL,42285,3025,2,6254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9283.87,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6255,NULL,42285,3025,2,6255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6760.03,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6256,NULL,42285,3025,2,6256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1432.77,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6257,NULL,42285,3025,2,6257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',16378.36,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6258,NULL,42285,3025,2,6258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2695.88,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6259,NULL,42285,3025,2,6259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4797.98,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:13','2022-08-17 15:07:13'),(6260,NULL,42285,3025,2,6260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1536.57,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6261,NULL,42285,3025,2,6261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3339.56,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6262,NULL,42285,3025,2,6262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1617.25,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6263,NULL,42285,3025,2,6263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2805.74,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6264,NULL,42285,3025,2,6264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3808.55,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6265,NULL,42285,3025,2,6265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5263.17,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6266,NULL,42285,3025,2,6266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',4261.50,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14');
INSERT INTO `balance_libro` VALUES (6267,NULL,42285,3025,2,6267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',4041.18,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6268,NULL,42285,3025,2,6268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',4713.10,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6269,NULL,42285,3025,2,6269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',4227.34,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6270,NULL,42285,3025,2,6270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',6015.08,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6271,NULL,42285,3025,2,6271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',51675.09,NULL,NULL,1,'2022-08-17 12:47:59','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6272,NULL,42285,3025,2,6272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5095.54,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6273,NULL,42285,3025,2,6273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4431.94,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6274,NULL,42285,3025,2,6274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',11489.47,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6275,NULL,42285,3025,2,6275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',7199.97,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6276,NULL,42285,3025,2,6276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1658.81,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6277,NULL,42285,3025,2,6277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',8796.98,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6278,NULL,42285,3025,2,6278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2491.40,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6279,NULL,42285,3025,2,6279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5627.44,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6280,NULL,42285,3025,2,6280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2781.48,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6281,NULL,42285,3025,2,6281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',3233.98,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6282,NULL,42285,3025,2,6282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',14687.95,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6283,NULL,42285,3025,2,6283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2139.48,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6284,NULL,42285,3025,2,6284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1797.69,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6285,NULL,42285,3025,2,6285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2398.99,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6286,NULL,42285,3025,2,6286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',3849.00,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6287,NULL,42285,3025,2,6287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',3002.48,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6288,NULL,42285,3025,2,6288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1793.82,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14');
INSERT INTO `balance_libro` VALUES (6289,NULL,42285,3025,2,6289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2644.18,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6290,NULL,42285,3025,2,6290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',3353.98,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6291,NULL,42285,3025,2,6291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4056.00,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6292,NULL,42285,3025,2,6292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2964.93,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6293,NULL,42285,3025,2,6293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1679.56,NULL,NULL,1,'2022-08-17 12:48:00','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6294,NULL,42285,3025,2,6294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4029.30,NULL,NULL,1,'2022-08-17 12:48:01','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6295,NULL,42285,3025,2,6295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1750.33,NULL,NULL,1,'2022-08-17 12:48:01','2022-08-17 15:07:14','2022-08-17 15:07:14'),(6296,NULL,42285,3025,2,6296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5608.17,NULL,NULL,1,'2022-08-17 12:48